(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27680,        962]
NotebookOptionsPosition[     18912,        736]
NotebookOutlinePosition[     19254,        752]
CellTagsIndexPosition[     19211,        749]
MenuPosition->0
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \

a given style.  Make modifications to any definition using commands in the 
Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
 PageWidth->WindowWidth,
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
 PageWidth->WindowWidth,
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
 PageWidth->PaperWidth,
 ShowAutoStyles->False,
 ScriptMinSize->7,
 FontSize->10,
 PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\

The options defined for the style below will be used at the Notebook level.
\
\>", "Text"],

Cell[StyleData["Notebook"],
 WindowToolbars->{},
 PageHeaders->{{
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None, 
    Cell[
     TextData[{
       ValueBox[FileName], " \[Bullet]  ", 
       ValueBox[Date]}], "Header"]}, {
    Cell[
     TextData[{
       ValueBox[FileName], " \[Bullet]  ", 
       ValueBox[Date]}], "Header"], None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"]}},
 DefaultNewCellStyle->"Text",
 DefaultDuplicateCellStyle->"Text",
 DefaultInlineFormatType->StandardForm,
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\

The cells in this section define styles used for input and output to the 
kernel.  Be careful when modifying, renaming, or removing these styles, 
because the front end associates special meanings with these style names.
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
 CellMargins->{{45, 10}, {5, 7}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 LinebreakAdjustments->{0.85, 2, 10, 0, 1},
 CounterIncrements->"Input",
 FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
 CellMargins->{{65, 10}, {6, 10}},
 FontSize->18],

Cell[StyleData["Input", "Printout"],
 CellMargins->{{39, 0}, {4, 6}},
 LinebreakAdjustments->{0.85, 2, 10, 1, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
 CellMargins->{{47, 10}, {7, 5}},
 CellEditDuplicate->True,
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 CounterIncrements->"Output",
 StyleMenuListing->None],

Cell[StyleData["Output", "Presentation"],
 CellMargins->{{68, 10}, {12, 6}},
 FontSize->18],

Cell[StyleData["Output", "Printout"],
 CellMargins->{{39, 0}, {6, 4}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
 CellMargins->{{45, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 AutoStyleOptions->{"SyntaxErrorStyle"->None},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Message",
 StyleMenuListing->None,
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Presentation"],
 CellMargins->{{65, 10}, {8, 8}},
 FontSize->18],

Cell[StyleData["Message", "Printout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 FontSize->8,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
 CellMargins->{{45, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Print",
 StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
 CellMargins->{{65, 10}, {6, 6}},
 FontSize->18],

Cell[StyleData["Print", "Printout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
 CellMargins->{{4, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 FormatType->InputForm,
 CounterIncrements->"Graphics",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
 CellMargins->{{6, 6}, {6, 4}},
 FontSize->18],

Cell[StyleData["Graphics", "Printout"],
 ImageSize->{250, 250},
 ImageMargins->{{30, Inherited}, {Inherited, 0}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
 FontSize->14],

Cell[StyleData["CellLabel", "Printout"],
 FontFamily->"Courier",
 FontSize->8,
 FontSlant->"Italic",
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["MonoText"],
 CellMargins->{{12, 10}, {7, 7}},
 LineSpacing->{1, 2},
 FontFamily->"Courier"],

Cell[StyleData["MonoText", "Presentation"],
 CellMargins->{{18, 10}, {10, 10}},
 FontSize->18],

Cell[StyleData["MonoText", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 Hyphenation->True,
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 LineSpacing->{1, 2}],

Cell[StyleData["Text", "Presentation"],
 CellMargins->{{18, 10}, {10, 10}},
 FontSize->18],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 Hyphenation->True]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellDingbat->"\[FilledSquare]",
 CellMargins->{{24, Inherited}, {8, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 CellFrameLabelMargins->6,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
 CellMargins->{{32, 10}, {12, 40}},
 FontSize->18],

Cell[StyleData["Section", "Printout"],
 CellMargins->{{15, 0}, {7, 22}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["TR"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->7,
 FontWeight->"Plain",
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
 StyleMenuListing->None,
 Background->RGBColor[0.870588235294118, 0.905882352941176, 0.972549019607843]
  ],

Cell[StyleData["Inert", "Printout"],
 StyleMenuListing->None,
 Background->GrayLevel[1]]
}, Closed]],

Cell[StyleData["Small"],
 StyleMenuListing->None,
 FontSize->9],

Cell[StyleData["Medium"],
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["Large"],
 StyleMenuListing->None,
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line help \
system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MainBook", #]}]& )}],

Cell[StyleData["MainBookLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["AddOns", #]}]& )}],

Cell[StyleData["AddOnsLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["RefGuide", #]}]& )}],

Cell[StyleData["RefGuideLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["GettingStarted", #]}]& )}],

Cell[StyleData["GettingStartedLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Demos", #]}]& )}],

Cell[StyleData["DemosLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Tour", #]}]& )}],

Cell[StyleData["TourLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["OtherInformation", #]}]& )}],

Cell[StyleData["OtherInformationLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MasterIndex", #]}]& )}],

Cell[StyleData["MasterIndexLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["Evaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["EvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionMove[
     FrontEnd`InputNotebook[], All, Cell, 1], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit)",
WindowSize->{500, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
MenuPosition->None,
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[606, 24, 34, 0, 76, "Title"],
Cell[643, 26, 193, 5, 56, "Text"],
Cell[CellGroupData[{
Cell[861, 35, 42, 0, 67, "Section"],
Cell[906, 37, 99, 3, 70, 31, 0, "StyleData", "All", "Working"],
Cell[1008, 42, 104, 3, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[1115, 47, 160, 5, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[1312, 57, 35, 0, 37, "Section"],
Cell[1350, 59, 101, 4, 70, "Text"],
Cell[1454, 65, 567, 20, 70, 27, 0, "StyleData", "Notebook", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[2058, 90, 42, 0, 37, "Section"],
Cell[2103, 92, 246, 6, 70, "Text"],
Cell[CellGroupData[{
Cell[2374, 102, 664, 19, 70, 24, 0, "StyleData", "Input", "All",
 CounterIncrements->"Input"],
Cell[3041, 123, 90, 2, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[3134, 127, 127, 3, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[3298, 135, 610, 17, 70, 25, 0, "StyleData", "Output", "All",
 CounterIncrements->"Output",
 StyleMenuListing->None],
Cell[3911, 154, 91, 2, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[4005, 158, 84, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[4126, 165, 648, 17, 70, 26, 0, "StyleData", "Message", "All",
 CounterIncrements->"Message",
 StyleMenuListing->None],
Cell[4777, 184, 91, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[4871, 188, 183, 4, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5091, 197, 598, 16, 70, 24, 0, "StyleData", "Print", "All",
 CounterIncrements->"Print",
 StyleMenuListing->None],
Cell[5692, 215, 89, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[5784, 219, 107, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5928, 226, 427, 12, 70, 27, 0, "StyleData", "Graphics", "All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[6358, 240, 90, 2, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[6451, 244, 127, 3, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[6615, 252, 124, 4, 70, 28, 0, "StyleData", "CellLabel", "All",
 StyleMenuListing->None],
Cell[6742, 258, 59, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[6804, 261, 126, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[6979, 271, 34, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[7038, 275, 107, 3, 70, 27, 0, "StyleData", "MonoText", "All"],
Cell[7148, 280, 94, 2, 70, 43, 0, "StyleData", "MonoText", "Presentation"],
Cell[7245, 284, 105, 3, 70, 39, 0, "StyleData", "MonoText", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[7387, 292, 1046, 25, 70, 23, 0, "StyleData", "Text", "All"],
Cell[8436, 319, 90, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[8529, 323, 87, 2, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[8653, 330, 1242, 31, 70, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->"Section"],
Cell[9898, 363, 93, 2, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[9994, 367, 87, 2, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[10130, 375, 36, 0, 37, "Section"],
Cell[10169, 377, 121, 3, 70, "Text"],
Cell[10293, 382, 89, 3, 70, 21, 0, "StyleData", "RM", "All",
 StyleMenuListing->None],
Cell[10385, 387, 67, 2, 70, 21, 0, "StyleData", "BF", "All",
 StyleMenuListing->None],
Cell[10455, 391, 68, 2, 70, 21, 0, "StyleData", "IT", "All",
 StyleMenuListing->None],
Cell[10526, 395, 111, 4, 70, 21, 0, "StyleData", "TR", "All",
 StyleMenuListing->None],
Cell[10640, 401, 112, 4, 70, 21, 0, "StyleData", "TI", "All",
 StyleMenuListing->None],
Cell[10755, 407, 110, 4, 70, 21, 0, "StyleData", "TB", "All",
 StyleMenuListing->None],
Cell[10868, 413, 112, 4, 70, 22, 0, "StyleData", "TBI", "All",
 StyleMenuListing->None],
Cell[10983, 419, 227, 6, 70, 21, 0, "StyleData", "MR", "All",
 StyleMenuListing->None],
Cell[11213, 427, 228, 6, 70, 21, 0, "StyleData", "MO", "All",
 StyleMenuListing->None],
Cell[11444, 435, 226, 6, 70, 21, 0, "StyleData", "MB", "All",
 StyleMenuListing->None],
Cell[11673, 443, 228, 6, 70, 22, 0, "StyleData", "MBO", "All",
 StyleMenuListing->None],
Cell[11904, 451, 115, 4, 70, 21, 0, "StyleData", "SR", "All",
 StyleMenuListing->None],
Cell[12022, 457, 116, 4, 70, 21, 0, "StyleData", "SO", "All",
 StyleMenuListing->None],
Cell[12141, 463, 114, 4, 70, 21, 0, "StyleData", "SB", "All",
 StyleMenuListing->None],
Cell[12258, 469, 116, 4, 70, 22, 0, "StyleData", "SBO", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[12399, 477, 133, 5, 70, 23, 0, "StyleData", "SO10", "All",
 StyleMenuListing->None],
Cell[12535, 484, 144, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[12716, 494, 132, 3, 70, 24, 0, "StyleData", "Inert", "All",
 StyleMenuListing->None],
Cell[12851, 499, 88, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[12954, 504, 63, 2, 70, 24, 0, "StyleData", "Small", "All",
 StyleMenuListing->None],
Cell[13020, 508, 65, 2, 70, 25, 0, "StyleData", "Medium", "All",
 StyleMenuListing->None],
Cell[13088, 512, 64, 2, 70, 24, 0, "StyleData", "Large", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[13189, 519, 35, 0, 37, "Section"],
Cell[13227, 521, 184, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[13436, 529, 254, 7, 70, 28, 0, "StyleData", "Hyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[13693, 538, 81, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[13789, 543, 104, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[13918, 550, 268, 7, 70, 31, 0, "StyleData", "MainBookLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[14189, 559, 84, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14310, 566, 288, 8, 70, 29, 0, "StyleData", "AddOnsLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[14601, 576, 82, 2, 70, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14720, 583, 292, 8, 70, 31, 0, "StyleData", "RefGuideLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[15015, 593, 84, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15136, 600, 280, 7, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[15419, 609, 90, 2, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15546, 616, 262, 7, 70, 28, 0, "StyleData", "DemosLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[15811, 625, 66, 1, 70, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15914, 631, 260, 7, 70, 27, 0, "StyleData", "TourLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[16177, 640, 65, 1, 70, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16279, 646, 284, 7, 70, 39, 0, "StyleData", "OtherInformationLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[16566, 655, 92, 2, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16695, 662, 274, 7, 70, 34, 0, "StyleData", "MasterIndexLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[16972, 671, 72, 1, 70, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[17093, 678, 33, 0, 37, "Section"],
Cell[17129, 680, 121, 3, 70, "Text"],
Cell[17253, 685, 216, 5, 70, 24, 0, "StyleData", "Paste", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[17472, 692, 287, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[17762, 701, 376, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[18141, 712, 363, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[18507, 723, 377, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
