Notebook[{
Cell[BoxData[
 DynamicModuleBox[{Global`$SoundLength$$ = 0, Global`$Init$$ = 0, 
  Global`$Record$$ = 1, Global`$Stop$$ = 2, Global`$OK$$ = 3, 
  Global`$Cancel$$ = 4, Global`$GetDeviceList$$ = 5, Global`$GetFormatList$$ =
   6, Global`$Device$$ = "SoundMAX Digital Audio", Global`$Format$$ = 1}, 
  StyleBox[
   TagBox[GridBox[{
      {
       TagBox[GridBox[{
          {
           InterpretationBox[
            TagBox[GridBox[{
               {"\<\"Input:\"\>", 
                DynamicBox[ToBoxes[
                  PopupMenu[
                   Dynamic[Global`$Device$$], 
                   FrontEndExecute[
                    FrontEnd`RecordSound[Global`$GetDeviceList$$]], FieldSize -> 
                   Medium, Enabled :> FEPrivate`UnsameQ[
                    Dynamic[FE`RecordSound`$Status], "Recording..."]], 
                  StandardForm],
                 ImageSizeCache->{181., 15.}]},
               {"\<\"Format:\"\>", 
                DynamicBox[ToBoxes[
                  PopupMenu[
                   Dynamic[Global`$Format$$], 
                   FrontEndExecute[
                    FrontEnd`RecordSound[
                    Global`$GetFormatList$$, Global`$Device$$]], FieldSize -> 
                   Medium, Enabled :> FEPrivate`UnsameQ[
                    Dynamic[FE`RecordSound`$Status], "Recording..."]], 
                  StandardForm],
                 ImageSizeCache->{181., 15.}]}
              },
              GridBoxAlignment->{"Columns" -> {Right, Left}}],
             "Grid"],
            Row[{
              Grid[{{"Input:", 
                 Dynamic[
                  PopupMenu[
                   Dynamic[Global`$Device$$], 
                   FrontEndExecute[
                    FrontEnd`RecordSound[Global`$GetDeviceList$$]], FieldSize -> 
                   Medium, Enabled :> FEPrivate`UnsameQ[
                    Dynamic[FE`RecordSound`$Status], "Recording..."]]]}, {
                "Format:", 
                 Dynamic[
                  PopupMenu[
                   Dynamic[Global`$Format$$], 
                   FrontEndExecute[
                    FrontEnd`RecordSound[
                    Global`$GetFormatList$$, Global`$Device$$]], FieldSize -> 
                   Medium, Enabled :> FEPrivate`UnsameQ[
                    Dynamic[FE`RecordSound`$Status], "Recording..."]]]}}, 
               Alignment -> {{Right, Left}}]}]]},
          {
           InterpretationBox["\<\"\"\>",
            Row[{""}]]},
          {
           InterpretationBox[
            RowBox[{
             ButtonBox[
              GraphicsBox[
               {GrayLevel[
                 Dynamic[
                  If[FE`RecordSound`$Status === "Recording...", 0, 0.5]]], 
                StyleBox[RectangleBox[{0, 0}],
                 FontColor->GrayLevel[
                   Dynamic[
                    If[FE`RecordSound`$Status === "Recording...", 0, 0.5]]]]},
               
               ImageSize->{10, 10}],
              Appearance->Automatic,
              ButtonExpandable->False,
              ButtonFrame->"DialogBox",
              ButtonFunction:>If[(Global`$SoundLength$$ = FrontEndExecute[
                   FrontEnd`RecordSound[Global`$Stop$$]]) > 0, 
                FE`RecordSound`$Status = StringJoin["Recorded ", 
                  ToString[
                   NumberForm[Global`$SoundLength$$, {Infinity, 3}]], 
                  " secs."], FE`RecordSound`$Status = "Waiting..."],
              Enabled:>FEPrivate`SameQ[
                Dynamic[FE`RecordSound`$Status], "Recording..."],
              Evaluator->Automatic,
              ImageSize->{55, 20},
              Method->"Preemptive"], "\[InvisibleSpace]", 
             ButtonBox[
              GraphicsBox[
               {RGBColor[
                 Dynamic[
                  Part[
                   If[
                   FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 1]], 
                 Dynamic[
                  Part[
                   If[
                   FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 2]], 
                 Dynamic[
                  Part[
                   If[
                   FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 3]]], 
                StyleBox[DiskBox[{0, 0}],
                 FontColor->RGBColor[
                   Dynamic[
                    Part[
                    If[
                    FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 1]], 
                   Dynamic[
                    Part[
                    If[
                    FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 2]], 
                   Dynamic[
                    Part[
                    If[
                    FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 3]]]]},
               ImageSize->{10, 10}],
              Appearance->Automatic,
              ButtonExpandable->False,
              ButtonFrame->"DialogBox",
              
              ButtonFunction:>(FE`RecordSound`$Status = "Recording..."; 
               Global`$SoundLength$$ = 0; FrontEndExecute[
                 FrontEnd`RecordSound[
                 Global`$Record$$, Global`$Device$$, Global`$Format$$]]),
              Enabled:>FEPrivate`UnsameQ[
                Dynamic[FE`RecordSound`$Status], "Recording..."],
              Evaluator->Automatic,
              ImageSize->{55, 20},
              Method->"Preemptive"]}],
            Row[{
              Button[
               Graphics[{
                 GrayLevel[
                  Dynamic[
                   If[FE`RecordSound`$Status === "Recording...", 0, 0.5]]], 
                 Rectangle[{0, 0}]}, ImageSize -> {10, 10}], 
               If[(Global`$SoundLength$$ = FrontEndExecute[
                   FrontEnd`RecordSound[Global`$Stop$$]]) > 0, 
                FE`RecordSound`$Status = StringJoin["Recorded ", 
                  ToString[
                   NumberForm[Global`$SoundLength$$, {Infinity, 3}]], 
                  " secs."], FE`RecordSound`$Status = "Waiting..."], 
               ButtonFrame -> "DialogBox", ButtonExpandable -> False, 
               Evaluator -> Automatic, ImageSize -> {55, 20}, Enabled :> 
               FEPrivate`SameQ[
                 Dynamic[FE`RecordSound`$Status], "Recording..."]], 
              Button[
               Graphics[{
                 RGBColor[
                  Dynamic[
                   Part[
                    If[
                    FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 1]], 
                  Dynamic[
                   Part[
                    If[
                    FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 2]], 
                  Dynamic[
                   Part[
                    If[
                    FE`RecordSound`$Status =!= "Recording...", {0.8, 0, 0}, {
                    0.5, 0.5, 0.5}], 3]]], 
                 Disk[{0, 0}]}, ImageSize -> {10, 10}], 
               FE`RecordSound`$Status = "Recording..."; 
               Global`$SoundLength$$ = 0; FrontEndExecute[
                 FrontEnd`RecordSound[
                 Global`$Record$$, Global`$Device$$, Global`$Format$$]], 
               ButtonFrame -> "DialogBox", ButtonExpandable -> False, 
               Evaluator -> Automatic, ImageSize -> {55, 20}, Enabled :> 
               FEPrivate`UnsameQ[
                 Dynamic[FE`RecordSound`$Status], "Recording..."]]}]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
        "Column"], "\[SpanFromLeft]"},
      {
       InterpretationBox["\<\"\"\>",
        Row[{""}]], "\[SpanFromLeft]"},
      {
       InterpretationBox[
        DynamicBox[ToBoxes[FE`RecordSound`$Status, StandardForm],
         ImageSizeCache->{48., 10.}],
        Row[{
          Dynamic[FE`RecordSound`$Status]}]], 
       InterpretationBox[
        RowBox[{
         ButtonBox["\<\"Cancel\"\>",
          Appearance->Automatic,
          ButtonExpandable->False,
          ButtonFrame->"DialogBox",
          ButtonFunction:>(FE`RecordSound`$Done = "Cancel"),
          Enabled:>FEPrivate`UnsameQ[
            Dynamic[FE`RecordSound`$Status], "Recording..."],
          Evaluator->Automatic,
          ImageSize->{55, 20},
          Method->"Preemptive"], "\[InvisibleSpace]", 
         ButtonBox["\<\"OK\"\>",
          Appearance->Automatic,
          ButtonExpandable->False,
          ButtonFrame->"DialogBox",
          ButtonFunction:>(FE`RecordSound`$Done = "OK"),
          Enabled:>FEPrivate`UnsameQ[
            Dynamic[Global`$SoundLength$$], 0],
          Evaluator->Automatic,
          ImageSize->{55, 20},
          Method->"Preemptive"]}],
        Row[{
          Button[
          "Cancel", FE`RecordSound`$Done = "Cancel", ButtonFrame -> 
           "DialogBox", ButtonExpandable -> False, Evaluator -> Automatic, 
           ImageSize -> {55, 20}, Enabled :> FEPrivate`UnsameQ[
             Dynamic[FE`RecordSound`$Status], "Recording..."]], 
          Button[
          "OK", FE`RecordSound`$Done = "OK", ButtonFrame -> "DialogBox", 
           ButtonExpandable -> False, Evaluator -> Automatic, 
           ImageSize -> {55, 20}, Enabled :> FEPrivate`UnsameQ[
             Dynamic[Global`$SoundLength$$], 0]]}]]}
     },
     GridBoxAlignment->{"Columns" -> {Left, Right}}],
    "Grid"], "Panel",
   StripOnInput->False],
  DynamicModuleValues:>{},
  Initialization:>(FrontEndExecute[
     FrontEnd`RecordSound[Global`$Init$$]]; 
   FE`RecordSound`$Status = "Waiting...")]]]
},
Editable->False,
Saveable->False,
Selectable->False,
WindowSize->Fit,
WindowMargins->Automatic,
WindowFrame->"ModalDialog",
WindowElements->{},
WindowFrameElements->None,
WindowTitle->"Sound Recorder",
ScrollingOptions->{"PagewiseScrolling"->False,
"VerticalScrollRange"->Fit},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowCellBracket->False,
Deployed->True,
DynamicUpdating->True,
TrackCellChangeTimes->False,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (December 11, 2006)",
StyleDefinitions->"Default.nb"
]

