(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10261,        355]
NotebookOptionsPosition[      7307,        255]
NotebookOutlinePosition[      8794,        300]
CellTagsIndexPosition[      8685,        294]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Getting Started in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/GettingStarted"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Getting Started in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InstallService" :> 
          Documentation`HelpLookup["paclet:ref/InstallService"], 
          "InstallServiceOperation" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/InstallServiceOperation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InstallService\"\>", 
       2->"\<\"InstallServiceOperation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$InstalledServices", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$InstalledServices"], "InlineFormula"],
     " \[LineSeparator]is a list of the installed web service operations."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->576086845],

Cell["Load the package and install a service:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->130542498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"In[2]:=",
 CellID->1869],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"Out[2]=",
 CellID->617700690]
}, Open  ]],

Cell["List the installed web service operations:", "ExampleText",
 CellID->194179741],

Cell[CellGroupData[{

Cell[BoxData["$InstalledServices"], "Input", "ConversionLockdown",
 CellLabel->"In[3]:=",
 CellID->318029893],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellLabel->"Out[3]=",
 CellID->205944703]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallService",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InstallService"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallServiceOperation",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/InstallServiceOperation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Getting Started in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/GettingStarted"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/GettingStarted"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/GettingStarted"]
}], "Tutorials",
 CellID->660774177]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->345352178],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->46793959]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$InstalledServices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 23.1994567}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "$InstalledServices is a list of the installed web service operations.", 
    "synonyms" -> {}, "title" -> "$InstalledServices", "type" -> "Symbol", 
    "uri" -> "WebServices/ref/$InstalledServices"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3276, 99, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:1.2.2"->{
  Cell[4034, 130, 231, 6, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->1869],
  Cell[4268, 138, 146, 4, 70, "Output",
   CellTags->"b:1.2.2",
   CellID->617700690]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8368, 280},
 {"b:1.2.2", 8493, 284}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2190, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2813, 81, 61, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2877, 84, 362, 10, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3276, 99, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3653, 113, 148, 5, 70, "ExampleSection",
 CellID->576086845],
Cell[3804, 120, 81, 1, 70, "ExampleText",
 CellID->25852921],
Cell[3888, 123, 121, 3, 70, "Input",
 CellID->130542498],
Cell[CellGroupData[{
Cell[4034, 130, 231, 6, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->1869],
Cell[4268, 138, 146, 4, 70, "Output",
 CellTags->"b:1.2.2",
 CellID->617700690]
}, Open  ]],
Cell[4429, 145, 85, 1, 70, "ExampleText",
 CellID->194179741],
Cell[CellGroupData[{
Cell[4539, 150, 109, 2, 70, "Input",
 CellID->318029893],
Cell[4651, 154, 124, 3, 70, "Output",
 CellID->205944703]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4836, 164, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5155, 175, 509, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[5701, 197, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6022, 208, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[6319, 219, 422, 12, 70, "Tutorials",
 CellID->660774177]
}, Open  ]],
Cell[CellGroupData[{
Cell[6778, 236, 319, 9, 70, "MoreAboutSection",
 CellID->345352178],
Cell[7100, 247, 165, 3, 70, "MoreAbout",
 CellID->46793959]
}, Open  ]],
Cell[7280, 253, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

