(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12944,        446]
NotebookOptionsPosition[      9490,        332]
NotebookOutlinePosition[     11090,        378]
CellTagsIndexPosition[     10979,        372]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Advanced Topics in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/AdvancedTopics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Advanced Topics in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromServiceResponse" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/FromServiceResponse"], 
          "$PrintServiceRequest" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/$PrintServiceRequest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FromServiceResponse\"\>", 
       2->"\<\"$PrintServiceRequest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$PrintServiceResponse", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$PrintServiceResponse"], "InlineFormula"],
     " \[LineSeparator]uses the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"],
     " function to print the message received from a web service before it is \
deserialized into a ",
     Cell[BoxData[
      ButtonBox["Rule",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
     " syntax expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89895330],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->101016889],

Cell["Load the package and install a service:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->130542498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"In[2]:=",
 CellID->1869],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"Out[2]=",
 CellID->208103555]
}, Open  ]],

Cell[TextData[{
 "Set ",
 Cell[BoxData["$PrintServiceResponse"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->194179741],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrintServiceResponse", " ", "=", " ", "True"}], ";"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[3]:=",
 CellID->318029893],

Cell["\<\
Evaluating a web service function prints the response message:\
\>", "ExampleText",
 CellID->379053363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HelloWorld", "[", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[4]:=",
 CellID->982057571],

Cell[BoxData["\<\"<soapenv:Envelope \
xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/'>\\r\\n \
<soapenv:Body>\\r\\n  <ns1:HelloWorldReturn \
xmlns:ns1='http://localhost:8080/webMathematica/Examples/WebServices/Hello.m'>\
\\r\\n   <element>Hello!  The current date is {2007, 3, 29, 15, 22, \
47.2091292}</element>\\r\\n  </ns1:HelloWorldReturn>\\r\\n </soapenv:Body>\\r\
\\n</soapenv:Envelope>\"\>"], "Print", "ConversionLockdown",
 CellLabel->"During evaluation of In[4]:=",
 CellID->124112805],

Cell[BoxData["\<\"Hello! The current date is {2007, 3, 29, 15, 22, \
47.2091292}\"\>"], "Output", "ConversionLockdown",
 CellLabel->"Out[4]=",
 CellID->207624215]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromServiceResponse",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/FromServiceResponse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrintServiceRequest",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/$PrintServiceRequest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1701638026]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Advanced Topics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"]
}], "Tutorials",
 CellID->807310188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->583121670],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->447661526]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$PrintServiceResponse - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 24.9650704}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "$PrintServiceResponse uses the Mathematica Print function to print the \
message received from a web service before it is deserialized into a Rule \
syntax expression. ", "synonyms" -> {}, "title" -> "$PrintServiceResponse", 
    "type" -> "Symbol", "uri" -> "WebServices/ref/$PrintServiceResponse"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4428, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89895330]},
 "b:1.2.2"->{
  Cell[5193, 175, 231, 6, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->1869],
  Cell[5427, 183, 146, 4, 70, "Output",
   CellTags->"b:1.2.2",
   CellID->208103555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10654, 358},
 {"b:1.2.2", 10787, 362}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2220, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2843, 82, 64, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2910, 85, 779, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3726, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4204, 131, 187, 8, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[4428, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89895330],
Cell[CellGroupData[{
Cell[4812, 158, 148, 5, 70, "ExampleSection",
 CellID->101016889],
Cell[4963, 165, 81, 1, 70, "ExampleText",
 CellID->25852921],
Cell[5047, 168, 121, 3, 70, "Input",
 CellID->130542498],
Cell[CellGroupData[{
Cell[5193, 175, 231, 6, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->1869],
Cell[5427, 183, 146, 4, 70, "Output",
 CellTags->"b:1.2.2",
 CellID->208103555]
}, Open  ]],
Cell[5588, 190, 246, 10, 70, "ExampleText",
 CellID->194179741],
Cell[5837, 202, 167, 5, 70, "Input",
 CellID->318029893],
Cell[6007, 209, 113, 3, 70, "ExampleText",
 CellID->379053363],
Cell[CellGroupData[{
Cell[6145, 216, 123, 3, 70, "Input",
 CellID->982057571],
Cell[6271, 221, 504, 8, 70, "Print",
 CellID->124112805],
Cell[6778, 231, 162, 3, 70, "Output",
 CellID->207624215]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7001, 241, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7320, 252, 526, 17, 70, "SeeAlso",
 CellID->1701638026]
}, Open  ]],
Cell[CellGroupData[{
Cell[7883, 274, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8204, 285, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[8501, 296, 422, 12, 70, "Tutorials",
 CellID->807310188]
}, Open  ]],
Cell[CellGroupData[{
Cell[8960, 313, 319, 9, 70, "MoreAboutSection",
 CellID->583121670],
Cell[9282, 324, 166, 3, 70, "MoreAbout",
 CellID->447661526]
}, Open  ]],
Cell[9463, 330, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

