(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21672,        743]
NotebookOptionsPosition[     14957,        509]
NotebookOutlinePosition[     18300,        618]
CellTagsIndexPosition[     18189,        612]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Advanced Topics in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/AdvancedTopics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Advanced Topics in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$PrintShortErrorMessages" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/$PrintShortErrorMessages"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"$PrintShortErrorMessages\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$PrintWSDLDebug", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$PrintWSDLDebug"], "InlineFormula"],
     "\[LineSeparator]specifies whether WSDL debugging information will be \
printed when installing a web service. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391742503],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->696083349],

Cell["Load the package and install a web service:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->130542498],

Cell[TextData[{
 "Set ",
 Cell[BoxData["$PrintWSDLDebug"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->194179741],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrintWSDLDebug", " ", "=", " ", "True"}], ";"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[2]:=",
 CellID->318029893],

Cell["Installing a web service function prints debug information:", \
"ExampleText",
 CellID->379053363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"In[3]:=",
 CellID->1869],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"User Context: \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["User Context: ", ""],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->182757880],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"WSDL URL: \"\>", 
   "\[InvisibleSpace]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\"\
\>"}],
  SequenceForm[
  "WSDL URL: ", 
   "http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1486881],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Options: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Options: ", {}],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->277320765],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Target Namespace: \"\>", 
   "\[InvisibleSpace]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Hello.m\"\>"}],
  
  SequenceForm[
  "Target Namespace: ", 
   "http://localhost:8080/webMathematica/Examples/WebServices/Hello.m"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->318707046],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Service Name: \"\>", 
   "\[InvisibleSpace]", "\<\"HelloWorldService\"\>"}],
  SequenceForm["Service Name: ", "HelloWorldService"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->517582013],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Port Name: \"\>", 
   "\[InvisibleSpace]", "\<\"HelloWorldPort\"\>"}],
  SequenceForm["Port Name: ", "HelloWorldPort"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->144591771],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SOAP End Point: \"\>", 
   "\[InvisibleSpace]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Hello.m\"\>"}],
  
  SequenceForm[
  "SOAP End Point: ", 
   "http://localhost:8080/webMathematica/Examples/WebServices/Hello.m"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->508001028],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Transport: \"\>", 
   "\[InvisibleSpace]", "\<\"http://schemas.xmlsoap.org/soap/http\"\>"}],
  SequenceForm["Transport: ", "http://schemas.xmlsoap.org/soap/http"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->308211202],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Binding Operation Style: \"\>", 
   "\[InvisibleSpace]", "\<\"document\"\>"}],
  SequenceForm["Binding Operation Style: ", "document"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->240609734],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Operation Name: \"\>", 
   "\[InvisibleSpace]", "\<\"HelloWorld\"\>"}],
  SequenceForm["Operation Name: ", "HelloWorld"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->247167582],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Operation Style: \"\>", 
   "\[InvisibleSpace]", "\<\"document\"\>"}],
  SequenceForm["Operation Style: ", "document"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->657669038],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SOAP Action URI: \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["SOAP Action URI: ", ""],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->249427192],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Header Params: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Header Params: ", {}],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->37554309],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Encoding Style: \"\>", 
   "\[InvisibleSpace]", "\<\"literal\"\>"}],
  SequenceForm["Encoding Style: ", "literal"],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->185528688],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Encoding Style URI: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Encoding Style URI: ", {}],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->301926010],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Namespace URI: \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["Namespace URI: ", ""],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->35524913],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Binding Parts: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Binding Parts: ", {}],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->174576288],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Operation: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"http://localhost:8080/webMathematica/Examples/WebServices/\
Hello.m\"\>", ",", "\<\"HelloWorld\"\>"}], "}"}]}],
  SequenceForm[
  "Operation: ", {
   "http://localhost:8080/webMathematica/Examples/WebServices/Hello.m", 
    "HelloWorld"}],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->285616230],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Params: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", "}"}]}],
  SequenceForm["Params: ", {}],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->430754911],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Return Type: \"\>", "\[InvisibleSpace]", 
   "HelloWorldService`HelloWorldPort`HelloWorldReturn"}],
  SequenceForm[
  "Return Type: ", HelloWorldService`HelloWorldPort`HelloWorldReturn],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->154952147],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Documentation: \"\>", 
   "\[InvisibleSpace]", "\<\"Simple HelloWorld web service example.\"\>"}],
  SequenceForm["Documentation: ", "Simple HelloWorld web service example."],
  Editable->False]], "Print", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"During evaluation of In[3]:=",
 CellID->153200917]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"Out[3]=",
 CellID->69438488]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["$PrintShortErrorMessages",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/$PrintShortErrorMessages"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Advanced Topics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"]
}], "Tutorials",
 CellID->807310188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->933889174],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->864733559]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$PrintWSDLDebug - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 26.7150592}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "$PrintWSDLDebug specifies whether WSDL debugging information will be \
printed when installing a web service. ", "synonyms" -> {}, "title" -> 
    "$PrintWSDLDebug", "type" -> "Symbol", "uri" -> 
    "WebServices/ref/$PrintWSDLDebug"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3893, 128, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->391742503]},
 "b:1.2.2"->{
  Cell[5177, 182, 231, 6, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->1869],
  Cell[5433, 192, 280, 7, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->182757880],
  Cell[5716, 201, 425, 12, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->1486881],
  Cell[6144, 215, 282, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->277320765],
  Cell[6429, 225, 434, 12, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->318707046],
  Cell[6866, 239, 318, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->517582013],
  Cell[7187, 249, 306, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->144591771],
  Cell[7496, 259, 430, 12, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->508001028],
  Cell[7929, 273, 350, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->308211202],
  Cell[8282, 283, 322, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->240609734],
  Cell[8607, 293, 308, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->247167582],
  Cell[8918, 303, 306, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->657669038],
  Cell[9227, 313, 286, 7, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->249427192],
  Cell[9516, 322, 293, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->37554309],
  Cell[9812, 332, 302, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->185528688],
  Cell[10117, 342, 304, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->301926010],
  Cell[10424, 352, 281, 7, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->35524913],
  Cell[10708, 361, 294, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->174576288],
  Cell[11005, 371, 500, 13, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->285616230],
  Cell[11508, 386, 280, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->430754911],
  Cell[11791, 396, 373, 9, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->154952147],
  Cell[12167, 407, 362, 8, 70, "Print",
   CellTags->"b:1.2.2",
   CellID->153200917],
  Cell[12544, 418, 145, 4, 70, "Output",
   CellTags->"b:1.2.2",
   CellID->69438488]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16050, 535},
 {"b:1.2.2", 16184, 539}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2067, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2690, 79, 58, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2751, 82, 402, 11, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3190, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3668, 115, 188, 8, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[3893, 128, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->391742503],
Cell[CellGroupData[{
Cell[4278, 142, 148, 5, 70, "ExampleSection",
 CellID->696083349],
Cell[4429, 149, 85, 1, 70, "ExampleText",
 CellID->25852921],
Cell[4517, 152, 121, 3, 70, "Input",
 CellID->130542498],
Cell[4641, 157, 240, 10, 70, "ExampleText",
 CellID->194179741],
Cell[4884, 169, 161, 5, 70, "Input",
 CellID->318029893],
Cell[5048, 176, 104, 2, 70, "ExampleText",
 CellID->379053363],
Cell[CellGroupData[{
Cell[5177, 182, 231, 6, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->1869],
Cell[CellGroupData[{
Cell[5433, 192, 280, 7, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->182757880],
Cell[5716, 201, 425, 12, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->1486881],
Cell[6144, 215, 282, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->277320765],
Cell[6429, 225, 434, 12, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->318707046],
Cell[6866, 239, 318, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->517582013],
Cell[7187, 249, 306, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->144591771],
Cell[7496, 259, 430, 12, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->508001028],
Cell[7929, 273, 350, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->308211202],
Cell[8282, 283, 322, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->240609734],
Cell[8607, 293, 308, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->247167582],
Cell[8918, 303, 306, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->657669038],
Cell[9227, 313, 286, 7, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->249427192],
Cell[9516, 322, 293, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->37554309],
Cell[9812, 332, 302, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->185528688],
Cell[10117, 342, 304, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->301926010],
Cell[10424, 352, 281, 7, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->35524913],
Cell[10708, 361, 294, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->174576288],
Cell[11005, 371, 500, 13, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->285616230],
Cell[11508, 386, 280, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->430754911],
Cell[11791, 396, 373, 9, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->154952147],
Cell[12167, 407, 362, 8, 70, "Print",
 CellTags->"b:1.2.2",
 CellID->153200917]
}, Open  ]],
Cell[12544, 418, 145, 4, 70, "Output",
 CellTags->"b:1.2.2",
 CellID->69438488]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12750, 429, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[13069, 440, 244, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[13350, 451, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[13671, 462, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[13968, 473, 422, 12, 70, "Tutorials",
 CellID->807310188]
}, Open  ]],
Cell[CellGroupData[{
Cell[14427, 490, 319, 9, 70, "MoreAboutSection",
 CellID->933889174],
Cell[14749, 501, 166, 3, 70, "MoreAbout",
 CellID->864733559]
}, Open  ]],
Cell[14930, 507, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

