(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13842,        477]
NotebookOptionsPosition[      9567,        330]
NotebookOutlinePosition[     11746,        397]
CellTagsIndexPosition[     11635,        391]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Advanced Topics in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/AdvancedTopics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Advanced Topics in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InstallService" :> 
          Documentation`HelpLookup["paclet:ref/InstallService"], 
          "$InstalledServices" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/$InstalledServices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"InstallService\"\>", 
       2->"\<\"$InstalledServices\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InstallServiceOperation", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InstallServiceOperation", "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", 
        StyleBox["endpoint", "TI"], ",", 
        StyleBox["arguments", "TI"], ",", 
        StyleBox["headers", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a function for the web service operation using \
the end point, arguments, and options. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->104836400],

Cell["Load the package:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input",
 CellTags->"b:1.4.2",
 CellLabel->"In[1]:=",
 CellID->21881],

Cell["Define the request message data type:", "ExampleText",
 CellID->408910767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefineSchema", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\>\
\"", ",", " ", "\[IndentingNewLine]", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"IntegrateString", ":", 
     RowBox[{"IntegrateStringType", "[", "str_String", "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellTags->"b:1.4.2",
 CellLabel->"In[2]:=",
 CellID->31998],

Cell[BoxData[
 RowBox[{"{", "IntegrateString", "}"}]], "Output",
 CellTags->"b:1.4.2",
 CellLabel->"Out[2]=",
 CellID->55734268]
}, Open  ]],

Cell["Define the response message data type:", "ExampleText",
 CellID->262149390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefineSchema", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\>\
\"", ",", " ", "\[IndentingNewLine]", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"IntegrateStringReturnType", "[", "element_String", "]"}], 
    "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellTags->"b:1.4.2",
 CellLabel->"In[3]:=",
 CellID->2510],

Cell[BoxData[
 RowBox[{"{", "IntegrateStringReturnType", "}"}]], "Output",
 CellTags->"b:1.4.2",
 CellLabel->"Out[3]=",
 CellID->262549213]
}, Open  ]],

Cell["Install the service operation:", "ExampleText",
 CellID->294495331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallServiceOperation", "[", "\[IndentingNewLine]", 
  RowBox[{
  "integrateString", ",", " ", "\[IndentingNewLine]", 
   "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\
\>\"", ",", " ", "\[IndentingNewLine]", 
   RowBox[{"TypeElements", "[", 
    RowBox[{"ElementType", "[", "IntegrateString", "]"}], "]"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "}"}], ",", " ", "\[IndentingNewLine]", 
   RowBox[{"OperationName", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.\
m\>\"", ",", " ", "\"\<IntegrateString\>\""}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"ReturnType", "\[Rule]", "IntegrateStringReturnType"}]}], 
  "]"}]], "Input",
 CellTags->"b:1.4.2",
 CellLabel->"In[4]:=",
 CellID->13401],

Cell[BoxData["integrateString"], "Output",
 CellTags->"b:1.4.2",
 CellLabel->"Out[4]=",
 CellID->193709323]
}, Open  ]],

Cell["Evaluate the service operation:", "ExampleText",
 CellID->263251255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrateString", "[", "\"\<Cos[x]\>\"", "]"}]], "Input",
 CellTags->"b:1.4.2",
 CellLabel->"In[5]:=",
 CellID->10585],

Cell[BoxData["\<\"Sin[x]\"\>"], "Output",
 CellTags->"b:1.4.2",
 CellLabel->"Out[5]=",
 CellID->74004005]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallService",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InstallService"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstalledServices",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/$InstalledServices"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Advanced Topics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"]
}], "Tutorials",
 CellID->807310188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->192052947],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->75903425]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InstallServiceOperation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 20.4807241}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "InstallServiceOperation[name, endpoint, arguments, headers] creates a \
function for the web service operation using the end point, arguments, and \
options. ", "synonyms" -> {}, "title" -> "InstallServiceOperation", "type" -> 
    "Symbol", "uri" -> "WebServices/ref/InstallServiceOperation"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3521, 106, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:1.4.2"->{
  Cell[4111, 130, 117, 4, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->21881],
  Cell[4336, 141, 453, 11, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->31998],
  Cell[4792, 154, 128, 4, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->55734268],
  Cell[5041, 166, 422, 10, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->2510],
  Cell[5466, 178, 139, 4, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->262549213],
  Cell[5718, 190, 853, 20, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->13401],
  Cell[6574, 212, 107, 3, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->193709323],
  Cell[6795, 223, 142, 4, 70, "Input",
   CellTags->"b:1.4.2",
   CellID->10585],
  Cell[6940, 229, 105, 3, 70, "Output",
   CellTags->"b:1.4.2",
   CellID->74004005]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10727, 356},
 {"b:1.4.2", 10853, 360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2175, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2798, 81, 66, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2867, 84, 617, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3521, 106, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3898, 120, 148, 5, 70, "ExampleSection",
 CellID->104836400],
Cell[4049, 127, 59, 1, 70, "ExampleText",
 CellID->25852921],
Cell[4111, 130, 117, 4, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->21881],
Cell[4231, 136, 80, 1, 70, "ExampleText",
 CellID->408910767],
Cell[CellGroupData[{
Cell[4336, 141, 453, 11, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->31998],
Cell[4792, 154, 128, 4, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->55734268]
}, Open  ]],
Cell[4935, 161, 81, 1, 70, "ExampleText",
 CellID->262149390],
Cell[CellGroupData[{
Cell[5041, 166, 422, 10, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->2510],
Cell[5466, 178, 139, 4, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->262549213]
}, Open  ]],
Cell[5620, 185, 73, 1, 70, "ExampleText",
 CellID->294495331],
Cell[CellGroupData[{
Cell[5718, 190, 853, 20, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->13401],
Cell[6574, 212, 107, 3, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->193709323]
}, Open  ]],
Cell[6696, 218, 74, 1, 70, "ExampleText",
 CellID->263251255],
Cell[CellGroupData[{
Cell[6795, 223, 142, 4, 70, "Input",
 CellTags->"b:1.4.2",
 CellID->10585],
Cell[6940, 229, 105, 3, 70, "Output",
 CellTags->"b:1.4.2",
 CellID->74004005]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7106, 239, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7425, 250, 499, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7961, 272, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8282, 283, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[8579, 294, 422, 12, 70, "Tutorials",
 CellID->807310188]
}, Open  ]],
Cell[CellGroupData[{
Cell[9038, 311, 319, 9, 70, "MoreAboutSection",
 CellID->192052947],
Cell[9360, 322, 165, 3, 70, "MoreAbout",
 CellID->75903425]
}, Open  ]],
Cell[9540, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

