(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13730,        458]
NotebookOptionsPosition[     10428,        345]
NotebookOutlinePosition[     12200,        400]
CellTagsIndexPosition[     12089,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Services Link User Guide" :> 
          Documentation`HelpLookup["paclet:WebServices/tutorial/Overview"], 
          "Advanced Topics in Web Services Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/tutorial/AdvancedTopics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Web Services Link User Guide\"\>", 
       2->"\<\"Advanced Topics in Web Services Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromServiceResponse" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/FromServiceResponse"], 
          "$PrintServiceRequest" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/$PrintServiceRequest"], 
          "InvokeServiceOperation" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/ref/InvokeServiceOperation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FromServiceResponse\"\>", 
       2->"\<\"$PrintServiceRequest\"\>", 
       3->"\<\"InvokeServiceOperation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Web Service Operations" :> 
          Documentation`HelpLookup[
           "paclet:WebServices/guide/WebServiceOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Web Service Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToServiceRequest", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToServiceRequest", "[", 
       RowBox[{
        StyleBox["parameters", "TI"], ",", 
        StyleBox["headers", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]builds a request message using input provided in the \
parameters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->983883729],

Cell["Load the package and install a web service:", "ExampleText",
 CellID->25852921],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[1]:=",
 CellID->22888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m?\
wsdl\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[2]:=",
 CellID->19156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "IntegrateExpression", ",", "IntegrateExpressionToGIF", ",", 
   "IntegrateMathML", ",", "IntegrateMathMLToGIF", ",", "IntegrateString", 
   ",", "IntegrateStringToGIF"}], "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[2]=",
 CellID->51350147]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["ToServiceRequest"], "InlineFormula"],
 " to build a message in symbolic XML:"
}], "ExampleText",
 CellID->860419062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"symbolicXML", " ", "=", 
  RowBox[{"ToServiceRequest", "[", 
   RowBox[{"IntegrateString", ",", "\"\<Sin[x]\>\""}], "]"}]}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"In[3]:=",
 CellID->16202],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"soapenv\"\>", ",", "\<\"Envelope\"\>"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenv\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/envelope/\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsd\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"xsi\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/2001/XMLSchema-instance\"\>"}], ",",
        
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"xmlns\"\>", ",", "\<\"soapenc\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://schemas.xmlsoap.org/soap/encoding/\"\>"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"soapenv\"\>", ",", "\<\"Body\"\>"}], "}"}], ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\<\"ns0\"\>", ",", "\<\"IntegrateString\"\>"}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"xmlns\"\>", ",", "\<\"ns0\"\>"}], "}"}], 
             "\[Rule]", \
"\<\"http://localhost:8080/webMathematica/Examples/WebServices/Integrate.m\"\>\
"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\<\"\"\>", ",", "\<\"str\"\>"}], "}"}], ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Sin[x]\"\>", "}"}]}], "]"}], "}"}]}], "]"}], 
         "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.4.1",
 CellLabel->"Out[3]=",
 CellID->282642575]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromServiceResponse",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/FromServiceResponse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrintServiceRequest",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/$PrintServiceRequest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InvokeServiceOperation",
    BaseStyle->"Link",
    ButtonData->"paclet:WebServices/ref/InvokeServiceOperation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Advanced Topics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
 StyleBox[ButtonBox["Web Services Link",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:WebServices/tutorial/AdvancedTopics"]
}], "Tutorials",
 CellID->807310188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->6479445],

Cell[TextData[ButtonBox["Web Service Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:WebServices/guide/WebServiceOperations"]], "MoreAbout",
 CellID->354658739]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToServiceRequest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 22.3400872}", "context" -> 
    "WebServices`", "keywords" -> {}, "index" -> True, "label" -> 
    "Web Services Symbol", "language" -> "en", "paclet" -> "WebServices", 
    "status" -> "None", "summary" -> 
    "ToServiceRequest[parameters, headers] builds a request message using \
input provided in the parameters.", "synonyms" -> {}, "title" -> 
    "ToServiceRequest", "type" -> "Symbol", "uri" -> 
    "WebServices/ref/ToServiceRequest"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3625, 109, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:1.4.1"->{
  Cell[4241, 133, 139, 4, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->22888],
  Cell[4405, 141, 236, 6, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->19156],
  Cell[4644, 149, 317, 8, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->51350147],
  Cell[5157, 169, 243, 7, 70, "Input",
   CellTags->"b:1.4.1",
   CellID->16202],
  Cell[5403, 178, 2193, 60, 70, "Output",
   CellTags->"b:1.4.1",
   CellID->282642575]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11518, 371},
 {"b:1.4.1", 11644, 375}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2402, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3025, 86, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[3087, 89, 501, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3625, 109, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4002, 123, 148, 5, 70, "ExampleSection",
 CellID->983883729],
Cell[4153, 130, 85, 1, 70, "ExampleText",
 CellID->25852921],
Cell[4241, 133, 139, 4, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->22888],
Cell[CellGroupData[{
Cell[4405, 141, 236, 6, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->19156],
Cell[4644, 149, 317, 8, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->51350147]
}, Open  ]],
Cell[4976, 160, 156, 5, 70, "ExampleText",
 CellID->860419062],
Cell[CellGroupData[{
Cell[5157, 169, 243, 7, 70, "Input",
 CellTags->"b:1.4.1",
 CellID->16202],
Cell[5403, 178, 2193, 60, 70, "Output",
 CellTags->"b:1.4.1",
 CellID->282642575]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7657, 245, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7976, 256, 810, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8823, 287, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9144, 298, 294, 9, 70, "Tutorials",
 CellID->341631938],
Cell[9441, 309, 422, 12, 70, "Tutorials",
 CellID->807310188]
}, Open  ]],
Cell[CellGroupData[{
Cell[9900, 326, 317, 9, 70, "MoreAboutSection",
 CellID->6479445],
Cell[10220, 337, 166, 3, 70, "MoreAbout",
 CellID->354658739]
}, Open  ]],
Cell[10401, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

