(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27897,        774]
NotebookOptionsPosition[     23196,        631]
NotebookOutlinePosition[     26661,        723]
CellTagsIndexPosition[     26591,        718]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Amazon", "Section",
 CellID->23757],

Cell[TextData[{
 ButtonBox["Amazon.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.amazon.com"], None}],
 " is a well-known web retailer that specializes in books, music, movies, and \
many other products. Amazon has made a ",
 ButtonBox["web service",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.amazon.com/gp/browse.html/102-1833813-2986559?node=\
3435361"], None}],
 " available that allows developers to interface with their database of \
products. A user can search for specific products, authors, artists, and so \
on. A query will return information (price, description, location, and so on) \
about the products that are found. This example demonstrates a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interface to the Amazon web service."
}], "Text",
 CellTags->"b:1.5.1",
 CellID->9832],

Cell[TextData[{
 "The Amazon web services are good demonstrations of using web services to \
retrieve data. This example searches the Amazon databases for books written \
by certain authors, published by a certain manufacturer, or containing a \
certain keyword. The example code then places the results in a new notebook. \
The example has one option. Setting the ",
 StyleBox["ShowPictures", "MR"],
 " option to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " will force the code to retrieve and display the cover image of the book."
}], "Text",
 CellTags->"b:1.5.1",
 CellID->30932],

Cell[TextData[{
 "To try this example, evaluate all the initialization cells. (You can do \
this using ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" ", "MenuName"],
 StyleBox["\[FilledRightTriangle]", "MenuNameDelimiter"],
 StyleBox[" ", "MenuName"],
 StyleBox[ButtonBox["Evaluate Initialization Cells",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EvaluateInitializationCells"], 
  "MenuName"],
 ".) Then go to the examples here."
}], "Text",
 CellTags->"b:1.5.1",
 CellID->573231514],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 CellTags->"b:1.5.1",
 CellID->2154],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"BeginPackage", "[", 
    RowBox[{"\"\<WebServices`Examples`Amazon`\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<WebServices`\>\"", ",", "\"\<JLink`\>\""}], "}"}]}], "]"}],
    ";"}], "\n"}], "\n", 
 RowBox[{"AuthorSearch", ";"}], "\n", 
 RowBox[{"ManufacturerSearch", ";"}], "\n", 
 RowBox[{"KeywordSearch", ";"}], "\n", 
 RowBox[{
  RowBox[{"ShowPictures", ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
   "InstallService", "[", 
    "\"\<http://soap.amazon.com/schemas3/AmazonWebServices.wsdl\>\"", "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "AuthorSearch", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"ShowPictures", "\[Rule]", "False"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"AuthorSearch", "[", 
    RowBox[{"keyword_String", ",", "pages_Integer", ",", 
     RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "result", "}"}], ",", 
     RowBox[{
      RowBox[{"result", "=", 
       RowBox[{"AuthorSearchRequest", "[", 
        RowBox[{"AuthorRequest", "[", 
         RowBox[{
          RowBox[{"\"\<author\>\"", "\[Rule]", "keyword"}], ",", 
          RowBox[{"\"\<page\>\"", "\[Rule]", 
           RowBox[{"ToString", "[", "pages", "]"}]}], ",", 
          RowBox[{"\"\<mode\>\"", "\[Rule]", "\"\<books\>\""}], ",", 
          RowBox[{"\"\<tag\>\"", "\[Rule]", "\"\<webservices-20\>\""}], ",", 
          RowBox[{"\"\<type\>\"", "\[Rule]", "\"\<lite\>\""}], ",", 
          RowBox[{"\"\<devtag\>\"", "\[Rule]", "\"\<D3VZJS46JD5U9D\>\""}]}], 
         "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"result", "===", "$Failed"}], ",", 
        RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"result", "=", 
       RowBox[{"result", "[", "\"\<Details\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"NotebookPut", "[", "\[IndentingNewLine]", 
       RowBox[{"resultNotebook", "[", 
        RowBox[{
        "\"\<Amazon Author Search\>\"", ",", "keyword", ",", "result", ",", 
         "options"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ManufacturerSearch", "[", 
     RowBox[{"keyword_String", ",", "pages_Integer", ",", 
      RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "result", "}"}], ",", 
      RowBox[{
       RowBox[{"result", "=", 
        RowBox[{"ManufacturerSearchRequest", "[", 
         RowBox[{"ManufacturerRequest", "[", 
          RowBox[{
           RowBox[{"\"\<manufacturer\>\"", "\[Rule]", "keyword"}], ",", 
           RowBox[{"\"\<page\>\"", "\[Rule]", 
            RowBox[{"ToString", "[", "pages", "]"}]}], ",", 
           RowBox[{"\"\<mode\>\"", "\[Rule]", "\"\<books\>\""}], ",", 
           RowBox[{"\"\<tag\>\"", "\[Rule]", "\"\<webservices-20\>\""}], ",", 
           
           RowBox[{"\"\<type\>\"", "\[Rule]", "\"\<lite\>\""}], ",", 
           RowBox[{"\"\<devtag\>\"", "\[Rule]", "\"\<D3VZJS46JD5U9D\>\""}]}], 
          "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"result", "===", "$Failed"}], ",", 
         RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"result", "=", 
        RowBox[{"result", "[", "\"\<Details\>\"", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"NotebookPut", "[", "\[IndentingNewLine]", 
        RowBox[{"resultNotebook", "[", 
         RowBox[{
         "\"\<Amazon Manufacturer Search\>\"", ",", "keyword", ",", "result", 
          ",", "options"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"KeywordSearch", "[", 
     RowBox[{"keyword_String", ",", "pages_Integer", ",", 
      RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "result", "}"}], ",", 
      RowBox[{
       RowBox[{"result", "=", 
        RowBox[{"KeywordSearchRequest", "[", 
         RowBox[{"KeywordRequest", "[", 
          RowBox[{
           RowBox[{"\"\<keyword\>\"", "\[Rule]", "keyword"}], ",", 
           RowBox[{"\"\<page\>\"", "\[Rule]", 
            RowBox[{"ToString", "[", "pages", "]"}]}], ",", 
           RowBox[{"\"\<mode\>\"", "\[Rule]", "\"\<books\>\""}], ",", 
           RowBox[{"\"\<tag\>\"", "\[Rule]", "\"\<webservices-20\>\""}], ",", 
           
           RowBox[{"\"\<type\>\"", "\[Rule]", "\"\<lite\>\""}], ",", 
           RowBox[{"\"\<devtag\>\"", "\[Rule]", "\"\<D3VZJS46JD5U9D\>\""}]}], 
          "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"result", "===", "$Failed"}], ",", 
         RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"result", "=", 
        RowBox[{"result", "[", "\"\<Details\>\"", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"NotebookPut", "[", "\[IndentingNewLine]", 
        RowBox[{"resultNotebook", "[", 
         RowBox[{
         "\"\<Amazon Keyword Search\>\"", ",", "keyword", ",", "result", ",", 
          "options"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"resultNotebook", "[", 
    RowBox[{
    "title_String", ",", " ", "keyword_String", ",", "result_List", ",", 
     RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Notebook", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{"title", ",", "\"\<Subtitle\>\""}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"\"\<Results for: \>\"", "<>", "keyword"}], ",", 
          "\"\<Section\>\""}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"resultCells", "[", 
           RowBox[{"#", ",", "options"}], "]"}], "&"}], " ", "/@", " ", 
         "result"}]}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
     RowBox[{"CellGrouping", "\[Rule]", "Manual"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"title", "<>", "\"\<: \>\"", "<>", "keyword"}], ")"}]}]}], 
    "]"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"resultCells", "[", 
    RowBox[{"d_", ",", 
     RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "url", ",", "asin", ",", "productName", ",", "authorNames", ",", 
       "releaseDate", ",", "manufacturer", ",", "imageUrlMedium", ",", 
       "listPrice", ",", "ourPrice", ",", "usedPrice", ",", "showPictures", 
       ",", "cellList"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", "showPictures", "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"{", "ShowPictures", "}"}], "/.", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", "options", "}"}], "]"}]}], "/.", 
        RowBox[{"Options", "[", "AuthorSearch", "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"url", "=", 
       RowBox[{"d", "[", "\"\<Url\>\"", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"asin", "=", 
       RowBox[{"d", "[", "\"\<Asin\>\"", "]"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"productName", "=", 
       RowBox[{"d", "[", "\"\<ProductName\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"authorNames", "=", 
       RowBox[{"d", "[", "\"\<Authors\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"releaseDate", "=", 
       RowBox[{"d", "[", "\"\<ReleaseDate\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"manufacturer", "=", 
       RowBox[{"d", "[", "\"\<Manufacturer\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"imageUrlMedium", "=", 
       RowBox[{"d", "[", "\"\<ImageUrlMedium\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"listPrice", "=", 
       RowBox[{"d", "[", "\"\<ListPrice\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ourPrice", "=", 
       RowBox[{"d", "[", "\"\<OurPrice\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"usedPrice", "=", 
       RowBox[{"d", "[", "\"\<UsedPrice\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"authorNames", "=", 
       RowBox[{"ToString", "[", "authorNames", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"authorNames", "=", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"authorNames", ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"authorNames", "=", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"authorNames", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"TrueQ", "[", "showPictures", "]"}], ",", 
        RowBox[{
         RowBox[{"imageUrlMedium", "=", 
          RowBox[{"getImageData", "[", "imageUrlMedium", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"StringMatchQ", "[", 
            RowBox[{"imageUrlMedium", ",", "\"\<GIF*\>\""}], "]"}], ",", 
           RowBox[{"imageCell", "=", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"ExportString", "[", 
              RowBox[{
               RowBox[{"ImportString", "[", 
                RowBox[{"imageUrlMedium", ",", "\"\<GIF\>\""}], "]"}], ",", 
               "\"\<MGFCell\>\""}], "]"}], "]"}]}], ",", 
           RowBox[{"imageCell", "=", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"ExportString", "[", 
              RowBox[{
               RowBox[{"ImportString", "[", 
                RowBox[{"imageUrlMedium", ",", "\"\<JPEG\>\""}], "]"}], ",", 
               "\"\<MGFCell\>\""}], "]"}], "]"}]}]}], "]"}], ";"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{"CellGroupData", "[", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"TextData", "[", 
                RowBox[{"{", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"ButtonBox", "[", 
                   RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"productName", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], 
                    "]"}], ",", 
                    RowBox[{"ButtonData", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"URL", "[", "url", "]"}], ",", "None"}], "}"}]}], 
                    ",", 
                    RowBox[{"ButtonStyle", "\[Rule]", "\"\<Hyperlink\>\""}]}],
                    "]"}], ",", "\"\< by \>\"", ",", 
                  RowBox[{"StyleBox", "[", 
                   RowBox[{"authorNames", ",", 
                    RowBox[{"FontSlant", "\[Rule]", "\"\<Italic\>\""}]}], 
                   "]"}]}], "}"}], "]"}], ",", "\"\<Text\>\"", ",", 
               RowBox[{"ShowGroupOpenCloseIcon", "\[Rule]", "True"}]}], "]"}],
              ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"TrueQ", "[", "showPictures", "]"}], ",", 
               RowBox[{"Cell", "[", 
                RowBox[{
                 RowBox[{"TextData", "[", "imageCell", "]"}], ",", 
                 "\"\<Text\>\""}], "]"}], ",", 
               RowBox[{"{", "}"}]}], "]"}], ",", 
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"TextData", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"StyleBox", "[", 
                   RowBox[{"\"\<Release Date: \>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], 
                   "]"}], ",", "releaseDate", ",", "\"\<\\n\>\"", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"StyleBox", "[", 
                   RowBox[{"\"\<ASIN: \>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], 
                   "]"}], ",", "asin", ",", "\"\<\\n\>\"", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"StyleBox", "[", 
                   RowBox[{"\"\<List Price: \>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], 
                   "]"}], ",", "listPrice", ",", "\"\<\\n\>\"", ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"StyleBox", "[", 
                   RowBox[{"\"\<Our Price: \>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], 
                   "]"}], ",", "ourPrice"}], "}"}], "]"}], ",", 
               "\"\<Text\>\""}], "]"}]}], "}"}], "]"}], ",", "Closed"}], 
         "]"}], "]"}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"getImageData", "[", "url_String", "]"}], ":=", 
   RowBox[{"JavaBlock", "[", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "connection", ",", "stream", ",", 
        RowBox[{"input", "=", "\"\<\>\""}], ",", 
        RowBox[{"numRead", "=", "0"}], ",", 
        RowBox[{"bytesRead", "=", "0"}], ",", "buf"}], "}"}], ",", 
      RowBox[{
       RowBox[{"u", "=", 
        RowBox[{"JavaNew", "[", 
         RowBox[{"\"\<java.net.URL\>\"", ",", "url"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"connection", "=", 
        RowBox[{"u", "@", 
         RowBox[{"openConnection", "[", "]"}]}]}], ";", "\[IndentingNewLine]",
        
       RowBox[{"stream", "=", 
        RowBox[{"connection", "@", 
         RowBox[{"getInputStream", "[", "]"}]}]}], ";", "\[IndentingNewLine]",
        
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"stream", "\[Equal]", "$Failed"}], ",", 
         RowBox[{"Return", "[", 
          RowBox[{"URLError", "[", "\"\<Failed to open URL stream\>\"", "]"}],
           "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"buf", "=", 
        RowBox[{"JavaNew", "[", 
         RowBox[{"\"\<[B\>\"", ",", "5000"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"While", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"numRead", "=", 
            RowBox[{"stream", "@", 
             RowBox[{"read", "[", "buf", "]"}]}]}], ")"}], ">", "0"}], ",", 
         RowBox[{
          RowBox[{"AddTo", "[", 
           RowBox[{"bytesRead", ",", "numRead"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"input", "=", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"input", ",", 
             RowBox[{"ToString", "[", 
              RowBox[{"FromCharacterCode", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"#", "<", "0"}], ",", 
                   RowBox[{"#", "+", "256"}], ",", "#"}], "]"}], "&"}], "/@", 
                
                RowBox[{"Take", "[", 
                 RowBox[{
                  RowBox[{"JavaObjectToExpression", "[", "buf", "]"}], ",", 
                  "numRead"}], "]"}]}], "]"}], "]"}]}], "]"}]}], ";"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"stream", "@", 
        RowBox[{"close", "[", "]"}]}], ";", "\[IndentingNewLine]", 
       "input"}]}], "]"}], "]"}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.1",
 CellID->25721]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Subsection",
 CellTags->"b:1.5.1",
 CellID->9512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AuthorSearch", "[", 
  RowBox[{"\"\<Stephen Wolfram\>\"", ",", "1"}], "]"}]], "Input",
 CellTags->"b:1.5.1",
 CellID->30145],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["mkg_shm", 1, 1]], 16]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Amazon Author Search: Stephen Wolfram\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["mkg_shm", 1, 1]], 16],
  Editable->False]], "Output",
 CellTags->"b:1.5.1",
 CellID->706750112]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ManufacturerSearch", "[", 
  RowBox[{"\"\<Addison-Wesley\>\"", ",", "1"}], "]"}]], "Input",
 CellTags->"b:1.5.1",
 CellID->21718],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["mkg_shm", 1, 1]], 17]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Amazon Manufacturer Search: Addison-Wesley\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["mkg_shm", 1, 1]], 17],
  Editable->False]], "Output",
 CellTags->"b:1.5.1",
 CellID->617080827]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KeywordSearch", "[", 
  RowBox[{"\"\<Mathematica\>\"", ",", "1", ",", 
   RowBox[{"ShowPictures", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:1.5.1",
 CellID->16139],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["mkg_shm", 1, 1]], 18]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Amazon Keyword Search: Mathematica\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["mkg_shm", 1, 1]], 18],
  Editable->False]], "Output",
 CellTags->"b:1.5.1",
 CellID->1078928026]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Amazon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 28.7931709}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Web Services Tutorial", 
    "language" -> "en", "paclet" -> "WebServices", "status" -> "None", 
    "summary" -> 
    "Amazon.com is a well-known web retailer that specializes in books, \
music, movies, and many other products. Amazon has made a web service \
available that allows developers to interface with their database of \
products. A user can search for specific products, authors, artists, and so \
on. A query will return information (price, description, location, and so on) \
about the products that are found. This example demonstrates a Mathematica \
interface to the Amazon web service. The Amazon web services are good \
demonstrations of using web services to retrieve data. This example searches \
the Amazon databases for books written by certain authors, published by a \
certain manufacturer, or containing a certain keyword. The example code then \
places the results in a new notebook. The example has one option. Setting the \
ShowPictures option to True will force the code to retrieve and display the \
cover image of the book. To try this example, evaluate all the initialization \
cells. (You can do this using Evaluation > Evaluate Initialization Cells.) \
Then go to the examples here.", "synonyms" -> {}, "title" -> "Amazon", "type" -> 
    "Tutorial", "uri" -> "WebServices/tutorial/AmazonExample"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.5.1"->{
  Cell[773, 32, 843, 21, 70, "Text",
   CellTags->"b:1.5.1",
   CellID->9832],
  Cell[1619, 55, 654, 15, 70, "Text",
   CellTags->"b:1.5.1",
   CellID->30932],
  Cell[2276, 72, 579, 16, 70, "Text",
   CellTags->"b:1.5.1",
   CellID->573231514],
  Cell[2880, 92, 69, 2, 70, "SubsectionOpener",
   CellTags->"b:1.5.1",
   CellID->2154],
  Cell[2952, 96, 16310, 392, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.1",
   CellID->25721],
  Cell[19299, 493, 67, 2, 70, "Subsection",
   CellTags->"b:1.5.1",
   CellID->9512],
  Cell[19391, 499, 148, 4, 70, "Input",
   CellTags->"b:1.5.1",
   CellID->30145],
  Cell[19542, 505, 1051, 32, 70, "Output",
   CellTags->"b:1.5.1",
   CellID->706750112],
  Cell[20630, 542, 153, 4, 70, "Input",
   CellTags->"b:1.5.1",
   CellID->21718],
  Cell[20786, 548, 1056, 32, 70, "Output",
   CellTags->"b:1.5.1",
   CellID->617080827],
  Cell[21879, 585, 199, 5, 70, "Input",
   CellTags->"b:1.5.1",
   CellID->16139],
  Cell[22081, 592, 1049, 32, 70, "Output",
   CellTags->"b:1.5.1",
   CellID->1078928026]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.5.1", 25512, 677}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 41, 1, 70, "Section",
 CellID->23757],
Cell[773, 32, 843, 21, 70, "Text",
 CellTags->"b:1.5.1",
 CellID->9832],
Cell[1619, 55, 654, 15, 70, "Text",
 CellTags->"b:1.5.1",
 CellID->30932],
Cell[2276, 72, 579, 16, 70, "Text",
 CellTags->"b:1.5.1",
 CellID->573231514],
Cell[CellGroupData[{
Cell[2880, 92, 69, 2, 70, "SubsectionOpener",
 CellTags->"b:1.5.1",
 CellID->2154],
Cell[2952, 96, 16310, 392, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.1",
 CellID->25721]
}, Closed]],
Cell[CellGroupData[{
Cell[19299, 493, 67, 2, 70, "Subsection",
 CellTags->"b:1.5.1",
 CellID->9512],
Cell[CellGroupData[{
Cell[19391, 499, 148, 4, 70, "Input",
 CellTags->"b:1.5.1",
 CellID->30145],
Cell[19542, 505, 1051, 32, 70, "Output",
 CellTags->"b:1.5.1",
 CellID->706750112]
}, Open  ]],
Cell[CellGroupData[{
Cell[20630, 542, 153, 4, 70, "Input",
 CellTags->"b:1.5.1",
 CellID->21718],
Cell[20786, 548, 1056, 32, 70, "Output",
 CellTags->"b:1.5.1",
 CellID->617080827]
}, Open  ]],
Cell[CellGroupData[{
Cell[21879, 585, 199, 5, 70, "Input",
 CellTags->"b:1.5.1",
 CellID->16139],
Cell[22081, 592, 1049, 32, 70, "Output",
 CellTags->"b:1.5.1",
 CellID->1078928026]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[23169, 629, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

