(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16524,        602]
NotebookOptionsPosition[      9312,        345]
NotebookOutlinePosition[     13863,        490]
CellTagsIndexPosition[     13648,        480]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Getting Started", "Title",
 CellID->19718],

Cell[CellGroupData[{

Cell["Loading the Package", "Section",
 CellTags->"b:1.2.1",
 CellID->19895],

Cell[TextData[{
 StyleBox["Web Services Link ",
  FontSlant->"Italic"],
 "is a ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "add-on application. Before any functions from the package can be used, it \
must be loaded as follows."
}], "Text",
 CellTags->"b:1.2.1",
 CellID->5447],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.1",
 CellLabel->"In[1]:=",
 CellID->21726]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installing a Web Service", "Section",
 CellTags->"b:1.2.2",
 CellID->14771],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InstallService",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 " will install the web service operations defined by a supplied WSDL as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. The functions created are returned in a list."
}], "Text",
 CellTags->"b:1.2.2",
 CellID->11538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"In[2]:=",
 CellID->1869],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"Out[2]=",
 CellID->84915329]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Naming a Web Service", "Section",
 CellTags->"b:1.2.3",
 CellID->25667],

Cell[TextData[{
 "The functions created by ",
 Cell[BoxData[
  ButtonBox["InstallService",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 " are placed in a context based on the service name and port name specified \
by the WSDL. A user can change this context by supplying a valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " context to ",
 Cell[BoxData[
  ButtonBox["InstallService",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:1.2.3",
 CellID->26299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Echo.m?wsdl\>\
\"", ",", " ", "\"\<EchoService`\>\""}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"In[3]:=",
 CellID->17035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "EchoBase64Binary", ",", "EchoBoolean", ",", "EchoDate", ",", 
   "EchoDateTime", ",", "EchoDatum", ",", "EchoDatumArray", ",", 
   "EchoExpression", ",", "EchoInteger", ",", "EchoIntegerArray", ",", 
   "EchoMathML", ",", "EchoReal", ",", "EchoString", ",", "EchoTime"}], 
  "}"}]], "Output", "ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"Out[3]=",
 CellID->749271]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "EchoString", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"In[4]:=",
 CellID->28703],

Cell[BoxData["\<\"EchoService`\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"Out[4]=",
 CellID->279541201]
}, Open  ]],

Cell[TextData[{
 "By default the context of a web service is added to the ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". This allows users to call the functions without having to specify the \
context. However, there is a danger that the functions installed by ",
 Cell[BoxData[
  ButtonBox["InstallService",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 " will collide with other functions already defined in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "on ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". If a user does not want the web service context added to ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ", then the user should set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AllowShortContext",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InstallService"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ". If this option is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then the entire context will need to be specified in order to call a \
function."
}], "Text",
 CellTags->"b:1.2.3",
 CellID->31322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Plot.m?wsdl\>\
\"", ",", 
   RowBox[{"AllowShortContext", "\[Rule]", "False"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"In[5]:=",
 CellID->30333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "PlotServiceService`PlotServicePort`PlotExpression", ",", 
   "PlotServiceService`PlotServicePort`PlotString"}], "}"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"Out[5]=",
 CellID->403389611]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inspecting Web Service Functions", "Section",
 CellTags->"b:1.2.4",
 CellID->4664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$InstalledServices",
   BaseStyle->"Link",
   ButtonData->"paclet:WebServices/ref/$InstalledServices"]], 
  "InlineFormula"],
 " may be used to determine which web service functions are installed. This \
is a list of all the web service functions installed."
}], "Text",
 CellTags->"b:1.2.4",
 CellID->15141],

Cell[CellGroupData[{

Cell[BoxData["$InstalledServices"], "Input", "ConversionLockdown",
 CellTags->"b:1.2.4",
 CellLabel->"In[6]:=",
 CellID->7711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "EchoBase64Binary", ",", "EchoBoolean", ",", "EchoDate", ",", 
   "EchoDateTime", ",", "EchoDatum", ",", "EchoDatumArray", ",", 
   "EchoExpression", ",", "EchoInteger", ",", "EchoIntegerArray", ",", 
   "EchoMathML", ",", "EchoReal", ",", "EchoString", ",", "EchoTime", ",", 
   "HelloWorld", ",", "PlotServiceService`PlotServicePort`PlotExpression", 
   ",", "PlotServiceService`PlotServicePort`PlotString"}], "}"}]], "Output", \
"ConversionLockdown",
 CellTags->"b:1.2.4",
 CellLabel->"Out[6]=",
 CellID->257743128]
}, Open  ]],

Cell[TextData[{
 "The usage message for each function may be inspected to discover how the \
function works. ",
 StyleBox["?SymbolName", "MR"],
 " may be used to get the usage message for a symbol. For instance, ",
 StyleBox["?HelloWorld ", "MR"],
 "retrieves the usage message for ",
 StyleBox["HelloWorld", "MR"],
 ". The usage message for a web service function is populated with the \
documentation provided by the WSDL."
}], "Text",
 CellTags->"b:1.2.4",
 CellID->6868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "HelloWorld"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.4",
 CellLabel->"In[7]:=",
 CellID->25547],

Cell[BoxData[
 StyleBox["\<\"String HelloWorld[]\\n\\nSimple HelloWorld web service \
example.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"b:1.2.4", "Info3384166500-2810444"},
 CellID->281514396]
}, Open  ]],

Cell[TextData[{
 "Each usage message contains a function signature that may be used to call \
the function. For instance, ",
 StyleBox["HelloWorld", "MR"],
 " does not require any parameters and returns a string."
}], "Text",
 CellTags->"b:1.2.4",
 CellID->32662]
}, Open  ]],

Cell[CellGroupData[{

Cell["Executing a Web Service Function", "Section",
 CellTags->"b:1.2.5",
 CellID->32757],

Cell[TextData[{
 "The usage message should be a starting point for determining what to input \
as parameters and what to expect as a result. Once this is determined, the \
function may be executed. A web service function may be executed just like \
any other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function."
}], "Text",
 CellTags->"b:1.2.5",
 CellID->20037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HelloWorld", "[", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.5",
 CellLabel->"In[8]:=",
 CellID->12859],

Cell[BoxData["\<\"Hello! The current date is {2007, 3, 29, 14, 15, \
17.5561239}\"\>"], "Output", "ConversionLockdown",
 CellTags->"b:1.2.5",
 CellLabel->"Out[8]=",
 CellID->344791595]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Getting Started - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 31.2931549}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Web Services Tutorial", 
    "language" -> "en", "paclet" -> "WebServices", "status" -> "None", 
    "summary" -> 
    "Web Services Link is a Mathematica add-on application. Before any \
functions from the package can be used, it must be loaded as follows. \
InstallService will install the web service operations defined by a supplied \
WSDL as Mathematica functions. The functions created are returned in a list. \
The functions created by InstallService are placed in a context based on the \
service name and port name specified by the WSDL. A user can change this \
context by supplying a valid Mathematica context to InstallService.", 
    "synonyms" -> {}, "title" -> "Getting Started", "type" -> "Tutorial", 
    "uri" -> "WebServices/tutorial/GettingStarted"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.2.1"->{
  Cell[802, 34, 76, 2, 70, "Section",
   CellTags->"b:1.2.1",
   CellID->19895],
  Cell[881, 38, 286, 10, 70, "Text",
   CellTags->"b:1.2.1",
   CellID->5447],
  Cell[1170, 50, 139, 4, 70, "Input",
   CellTags->"b:1.2.1",
   CellID->21726]},
 "b:1.2.2"->{
  Cell[1346, 59, 81, 2, 70, "Section",
   CellTags->"b:1.2.2",
   CellID->14771],
  Cell[1430, 63, 382, 11, 70, "Text",
   CellTags->"b:1.2.2",
   CellID->11538],
  Cell[1837, 78, 231, 6, 70, "Input",
   CellTags->"b:1.2.2",
   CellID->1869],
  Cell[2071, 86, 145, 4, 70, "Output",
   CellTags->"b:1.2.2",
   CellID->84915329]},
 "b:1.2.3"->{
  Cell[2265, 96, 77, 2, 70, "Section",
   CellTags->"b:1.2.3",
   CellID->25667],
  Cell[2345, 100, 575, 18, 70, "Text",
   CellTags->"b:1.2.3",
   CellID->26299],
  Cell[2945, 122, 280, 8, 70, "Input",
   CellTags->"b:1.2.3",
   CellID->17035],
  Cell[3228, 132, 419, 10, 70, "Output",
   CellTags->"b:1.2.3",
   CellID->749271],
  Cell[3684, 147, 152, 4, 70, "Input",
   CellTags->"b:1.2.3",
   CellID->28703],
  Cell[3839, 153, 134, 3, 70, "Output",
   CellTags->"b:1.2.3",
   CellID->279541201],
  Cell[3988, 159, 1468, 43, 70, "Text",
   CellTags->"b:1.2.3",
   CellID->31322],
  Cell[5481, 206, 306, 9, 70, "Input",
   CellTags->"b:1.2.3",
   CellID->30333],
  Cell[5790, 217, 261, 8, 70, "Output",
   CellTags->"b:1.2.3",
   CellID->403389611]},
 "b:1.2.4"->{
  Cell[6100, 231, 88, 2, 70, "Section",
   CellTags->"b:1.2.4",
   CellID->4664],
  Cell[6191, 235, 352, 10, 70, "Text",
   CellTags->"b:1.2.4",
   CellID->15141],
  Cell[6568, 249, 126, 3, 70, "Input",
   CellTags->"b:1.2.4",
   CellID->7711],
  Cell[6697, 254, 560, 12, 70, "Output",
   CellTags->"b:1.2.4",
   CellID->257743128],
  Cell[7272, 269, 474, 12, 70, "Text",
   CellTags->"b:1.2.4",
   CellID->6868],
  Cell[7771, 285, 136, 4, 70, "Input",
   CellTags->"b:1.2.4",
   CellID->25547],
  Cell[7910, 291, 202, 4, 70, "Print",
   CellTags->{"b:1.2.4", "Info3384166500-2810444"},
   CellID->281514396],
  Cell[8127, 298, 263, 7, 70, "Text",
   CellTags->"b:1.2.4",
   CellID->32662]},
 "Info3384166500-2810444"->{
  Cell[7910, 291, 202, 4, 70, "Print",
   CellTags->{"b:1.2.4", "Info3384166500-2810444"},
   CellID->281514396]},
 "b:1.2.5"->{
  Cell[8427, 310, 89, 2, 70, "Section",
   CellTags->"b:1.2.5",
   CellID->32757],
  Cell[8519, 314, 374, 10, 70, "Text",
   CellTags->"b:1.2.5",
   CellID->20037],
  Cell[8918, 328, 141, 4, 70, "Input",
   CellTags->"b:1.2.5",
   CellID->12859],
  Cell[9062, 334, 184, 4, 70, "Output",
   CellTags->"b:1.2.5",
   CellID->344791595]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.2.1", 11074, 384},
 {"b:1.2.2", 11330, 394},
 {"b:1.2.3", 11673, 407},
 {"b:1.2.4", 12440, 435},
 {"Info3384166500-2810444", 13161, 460},
 {"b:1.2.5", 13290, 464}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 48, 1, 70, "Title",
 CellID->19718],
Cell[CellGroupData[{
Cell[802, 34, 76, 2, 70, "Section",
 CellTags->"b:1.2.1",
 CellID->19895],
Cell[881, 38, 286, 10, 70, "Text",
 CellTags->"b:1.2.1",
 CellID->5447],
Cell[1170, 50, 139, 4, 70, "Input",
 CellTags->"b:1.2.1",
 CellID->21726]
}, Open  ]],
Cell[CellGroupData[{
Cell[1346, 59, 81, 2, 70, "Section",
 CellTags->"b:1.2.2",
 CellID->14771],
Cell[1430, 63, 382, 11, 70, "Text",
 CellTags->"b:1.2.2",
 CellID->11538],
Cell[CellGroupData[{
Cell[1837, 78, 231, 6, 70, "Input",
 CellTags->"b:1.2.2",
 CellID->1869],
Cell[2071, 86, 145, 4, 70, "Output",
 CellTags->"b:1.2.2",
 CellID->84915329]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2265, 96, 77, 2, 70, "Section",
 CellTags->"b:1.2.3",
 CellID->25667],
Cell[2345, 100, 575, 18, 70, "Text",
 CellTags->"b:1.2.3",
 CellID->26299],
Cell[CellGroupData[{
Cell[2945, 122, 280, 8, 70, "Input",
 CellTags->"b:1.2.3",
 CellID->17035],
Cell[3228, 132, 419, 10, 70, "Output",
 CellTags->"b:1.2.3",
 CellID->749271]
}, Open  ]],
Cell[CellGroupData[{
Cell[3684, 147, 152, 4, 70, "Input",
 CellTags->"b:1.2.3",
 CellID->28703],
Cell[3839, 153, 134, 3, 70, "Output",
 CellTags->"b:1.2.3",
 CellID->279541201]
}, Open  ]],
Cell[3988, 159, 1468, 43, 70, "Text",
 CellTags->"b:1.2.3",
 CellID->31322],
Cell[CellGroupData[{
Cell[5481, 206, 306, 9, 70, "Input",
 CellTags->"b:1.2.3",
 CellID->30333],
Cell[5790, 217, 261, 8, 70, "Output",
 CellTags->"b:1.2.3",
 CellID->403389611]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6100, 231, 88, 2, 70, "Section",
 CellTags->"b:1.2.4",
 CellID->4664],
Cell[6191, 235, 352, 10, 70, "Text",
 CellTags->"b:1.2.4",
 CellID->15141],
Cell[CellGroupData[{
Cell[6568, 249, 126, 3, 70, "Input",
 CellTags->"b:1.2.4",
 CellID->7711],
Cell[6697, 254, 560, 12, 70, "Output",
 CellTags->"b:1.2.4",
 CellID->257743128]
}, Open  ]],
Cell[7272, 269, 474, 12, 70, "Text",
 CellTags->"b:1.2.4",
 CellID->6868],
Cell[CellGroupData[{
Cell[7771, 285, 136, 4, 70, "Input",
 CellTags->"b:1.2.4",
 CellID->25547],
Cell[7910, 291, 202, 4, 70, "Print",
 CellTags->{"b:1.2.4", "Info3384166500-2810444"},
 CellID->281514396]
}, Open  ]],
Cell[8127, 298, 263, 7, 70, "Text",
 CellTags->"b:1.2.4",
 CellID->32662]
}, Open  ]],
Cell[CellGroupData[{
Cell[8427, 310, 89, 2, 70, "Section",
 CellTags->"b:1.2.5",
 CellID->32757],
Cell[8519, 314, 374, 10, 70, "Text",
 CellTags->"b:1.2.5",
 CellID->20037],
Cell[CellGroupData[{
Cell[8918, 328, 141, 4, 70, "Input",
 CellTags->"b:1.2.5",
 CellID->12859],
Cell[9062, 334, 184, 4, 70, "Output",
 CellTags->"b:1.2.5",
 CellID->344791595]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9285, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

