(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34282,       1163]
NotebookOptionsPosition[     24046,        818]
NotebookOutlinePosition[     30215,       1008]
CellTagsIndexPosition[     30119,       1002]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["WEB SERVICES TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Google", "Section",
 CellTags->"b:1.5.2",
 CellID->16279],

Cell[TextData[{
 ButtonBox["Google.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.google.com"], None}],
 " is a well-known web search engine. Google has made a ",
 ButtonBox["web service",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://api.google.com"], None}],
 " available that allows developers to interface with their search engine \
within their own applications. A user can search for any topic on the web. A \
query will return data about the web pages that are found. This example \
demonstrates a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interface to the Google web service."
}], "Text",
 CellTags->"b:1.5.2",
 CellID->25996],

Cell["\<\
The Google web service provides a good demonstration of using web services to \
retrieve data. This example searches the Google databases for web pages \
containing a certain keyword. The example code then places the results in the \
notebook.\
\>", "Text",
 CellTags->"b:1.5.2",
 CellID->16687],

Cell[TextData[{
 "To try this example, evaluate all the initialization cells. (You can do \
this using ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" ", "MenuName"],
 StyleBox["\[FilledRightTriangle]", "MenuNameDelimiter"],
 StyleBox[" ", "MenuName"],
 StyleBox[ButtonBox["Evaluate Initialization Cells",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EvaluateInitializationCells"], 
  "MenuName"],
 ".) Then go to the examples here."
}], "Text",
 CellTags->"b:1.5.1",
 CellID->12046353],

Cell[CellGroupData[{

Cell["Code", "SubsectionOpener",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->22549],

Cell[BoxData[
 RowBox[{"<<", "WebServices`"}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->17437],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "InstallService", "[", "\"\<http://api.google.com/GoogleSearch.wsdl\>\"", 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->19866],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "GoogleSearch", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MaxHits", " ", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Filter", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"IncludeURL", " ", "\[Rule]", " ", "True"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->12949],

Cell[BoxData[
 RowBox[{
  RowBox[{"$backgrounds", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.960784", ",", "0.878431", ",", "0.666667"}], "]"}], ",", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.964706", ",", "0.929412", ",", "0.839216"}], "]"}]}], 
    "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->193],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GoogleSearch", "::", "err"}], "=", "\"\<Search Error.\>\""}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->23195],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GoogleSearch", "::", "nomatch"}], "=", 
   "\"\<No page containing `1` found.\>\""}], ";"}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->3297],

Cell[BoxData[
 RowBox[{
  RowBox[{"GoogleSearch", "[", 
   RowBox[{"str_String", ",", "opts___"}], "]"}], ":=", "\[IndentingNewLine]",
   
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "lis", ",", "results", ",", "matches", ",", "filterQ", ",", " ", 
      "urlQ"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"matches", ",", "filterQ", ",", "urlQ"}], "}"}], "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"MaxHits", ",", "Filter", ",", "IncludeURL"}], "}"}], " ", "/.",
        " ", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{"opts", ",", 
          RowBox[{"Options", " ", "@", " ", "GoogleSearch"}]}], "}"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"results", "=", 
      RowBox[{"GoogleSearchService`GoogleSearchPort`doGoogleSearch", "[", 
       RowBox[{
       "\"\<3HB82PdQFHITKPmbmm5G/9aTfVHx/m95\>\"", ",", "str", ",", " ", "0", 
        ",", "matches", ",", "filterQ", ",", "\"\<\>\"", ",", "True", ",", 
        "\"\<\>\"", ",", "\"\<\>\"", ",", "\"\<\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"results", "===", "$Failed"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Message", "[", 
        RowBox[{"GoogleSearch", "::", "err"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"lis", " ", "=", " ", 
         RowBox[{"results", "[", "\"\<resultElements\>\"", "]"}]}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"lis", "===", "Null"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"GoogleSearch", "::", "nomatch"}], ",", " ", "str"}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"$bg", "=", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Scan", "[", 
         RowBox[{"CellPrint", ",", 
          RowBox[{"searchResultCells", "[", 
           RowBox[{"lis", ",", "urlQ"}], "]"}]}], "]"}]}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->20416],

Cell[BoxData[
 RowBox[{
  RowBox[{"searchResultCells", "[", 
   RowBox[{"lis_", ",", "urlQ_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"cellTemplate", "[", 
     RowBox[{"formatSingleResult", "[", 
      RowBox[{"#", ",", "urlQ"}], "]"}], "]"}], "&"}], " ", "/@", " ", 
   "lis"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->28286],

Cell[BoxData[
 RowBox[{
  RowBox[{"cellTemplate", "[", "lis_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"TextData", " ", "@", " ", 
     RowBox[{"Flatten", " ", "@", " ", 
      RowBox[{"{", "lis", "}"}]}]}], ",", "\"\<Print\>\"", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Inherited", ",", "Inherited"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]",
     
    RowBox[{"CellDingbat", "\[Rule]", 
     RowBox[{"ToString", "[", 
      RowBox[{"++", "$bg"}], "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"Part", "[", 
      RowBox[{"$backgrounds", ",", 
       RowBox[{"Mod", "[", 
        RowBox[{"$bg", ",", "2", ",", "1"}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->16105],

Cell[BoxData[
 RowBox[{
  RowBox[{"formatSingleResult", "[", 
   RowBox[{"result_", ",", "urlQ_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "t"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"\"\< \>\"", ",", "\[IndentingNewLine]", 
      RowBox[{"webLink", "[", 
       RowBox[{
        RowBox[{"StyleBox", "[", 
         RowBox[{
          RowBox[{"formatTitle", " ", "@", 
           RowBox[{"result", "[", "\"\<title\>\"", "]"}]}], ",", 
          RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}], ",", 
        RowBox[{"result", "[", "\"\<URL\>\"", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"urlQ", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\\n\>\"", ",", 
          RowBox[{"webLink", "[", 
           RowBox[{
            RowBox[{"StyleBox", "[", 
             RowBox[{
              RowBox[{"result", "[", "\"\<URL\>\"", "]"}], ",", 
              "\"\<SmallText\>\"", ",", 
              RowBox[{"FontColor", "\[Rule]", 
               RowBox[{"GrayLevel", "[", "0.4", "]"}]}]}], "]"}], ",", 
            RowBox[{"result", "[", "\"\<URL\>\"", "]"}]}], "]"}]}], "}"}], 
        ",", 
        RowBox[{"{", "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->24488],

Cell[BoxData[
 RowBox[{
  RowBox[{"webLink", "[", 
   RowBox[{"content_", ",", "url_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"ButtonBox", "[", 
   RowBox[{"content", ",", "\[IndentingNewLine]", 
    RowBox[{"ButtonData", "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"URL", "[", "url", "]"}], ",", "None"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ButtonStyle", "\[Rule]", "\"\<Hyperlink\>\""}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->16282],

Cell[BoxData[
 RowBox[{
  RowBox[{"formatTitle", "[", "str_String", "]"}], ":=", 
  RowBox[{"translateAllEntities", "[", "str", "]"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->12455],

Cell[BoxData[
 RowBox[{
  RowBox[{"decodeString", "[", "str_", "]"}], ":=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"str", ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<&lt;\>\"", "\[Rule]", "\"\<<\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<&gt;\>\"", "\[Rule]", "\"\<>\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<&amp;\>\"", "\[Rule]", "\"\<&\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<&quot;\>\"", "\[Rule]", "\"\<\\\"\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<\\\\\>\"", "\[Rule]", "\"\<\\\\[Backslash]\>\""}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->25734],

Cell[BoxData[
 RowBox[{
  RowBox[{"translateAllEntities", "[", "str_", "]"}], ":=", 
  RowBox[{
   RowBox[{"StringReplace", "[", 
    RowBox[{"str", ",", 
     RowBox[{
     "Reverse", " ", "/@", " ", 
      "System`Convert`MLStringDataDump`$UnicodeToHTML4Entities"}]}], "]"}], "//",
    "decodeString"}]}]], "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->18114]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellTags->"b:1.5.2",
 CellID->11701],

Cell["\<\
Find the top 10 wolfram.com web pages containing all the given strings.\
\>", "Text",
 CellTags->"b:1.5.2",
 CellID->31316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GoogleSearch", "[", "\"\<Mathematica\>\"", "]"}]], "Input",
 CellTags->"b:1.5.2",
 CellID->20671],

Cell[CellGroupData[{

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["Wolfram.com - <b>Mathematica</b>",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://www.wolfram.com/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"1",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Mathematica</b>: The Way the World Calculates",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/products/mathematica/index.html"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://www.wolfram.com/products/mathematica/index.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/products/mathematica/index.html"], None}], 
  "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"2",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Mathematica</b> Policy Research, Inc.: Home",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.mathematica-mpr.com/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://www.mathematica-mpr.com/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.mathematica-mpr.com/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"3",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Mathematica</b> - Wikipedia, the free encyclopedia",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Mathematica"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://en.wikipedia.org/wiki/Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Mathematica"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"4",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Mathematica</b> Information Center",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://library.wolfram.com/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://library.wolfram.com/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://library.wolfram.com/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"5",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["The Integrator--Integrals from <b>Mathematica</b>",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://integrals.wolfram.com/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://integrals.wolfram.com/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://integrals.wolfram.com/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"6",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["Wolfram Research Documentation Center: A Collection of \
Online <b>...</b>",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://documents.wolfram.com/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://documents.wolfram.com/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://documents.wolfram.com/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"7",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["Wolfram <b>Mathematica</b> Documentation",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://documents.wolfram.com/mathematica/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://documents.wolfram.com/mathematica/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://documents.wolfram.com/mathematica/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"8",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Mathematica</b> Graphics Gallery",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://gallery.wolfram.com/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://gallery.wolfram.com/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://gallery.wolfram.com/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"9",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["Technical Support: <b>Mathematica</b>: Questions About \
<b>Mathematica</b>",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica/"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://support.wolfram.com/mathematica/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica/"], None}], "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"10",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Search for pages containing all the given strings, and return only the top \
two results.\
\>", "Text",
 CellTags->"b:1.5.2",
 CellID->27756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GoogleSearch", "[", 
  RowBox[{"\"\<Hermite polynomial\>\"", ",", 
   RowBox[{"MaxHits", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellTags->"b:1.5.2",
 CellID->28321],

Cell[CellGroupData[{

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Hermite Polynomial</b> -- from Wolfram MathWorld",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://mathworld.wolfram.com/HermitePolynomial.html"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://mathworld.wolfram.com/HermitePolynomial.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://mathworld.wolfram.com/HermitePolynomial.html"], None}], 
  "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"1",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Hermite polynomials</b> - Wikipedia, the free \
encyclopedia",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Hermite_polynomials"], None}],
  FontWeight->"Bold"],
 "\n",
 StyleBox[ButtonBox["http://en.wikipedia.org/wiki/Hermite_polynomials",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Hermite_polynomials"], None}], 
  "SmallText",
  FontColor->GrayLevel[0.4]]
}], "Print",
 CellDingbat->"2",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Display less verbose results and do not filter near-duplicate content and \
host crowding.\
\>", "Text",
 CellTags->"b:1.5.2",
 CellID->27982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GoogleSearch", "[", 
  RowBox[{"\"\<Chebyshev\>\"", ",", 
   RowBox[{"IncludeURL", "\[Rule]", "False"}], ",", 
   RowBox[{"Filter", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"b:1.5.2",
 CellID->481],

Cell[CellGroupData[{

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev</b> summary",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www-groups.dcs.st-and.ac.uk/~history/Mathematicians/Chebyshev.\
html"], None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"1",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial of the First Kind -- from \
Wolfram MathWorld",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://mathworld.wolfram.com/ChebyshevPolynomialoftheFirstKind.html"]\
, None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"2",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["Pafnuty <b>Chebyshev</b> - Wikipedia, the free \
encyclopedia",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Pafnuty_Chebyshev"], None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"3",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev</b> polynomials - Wikipedia, the free \
encyclopedia",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Chebyshev_polynomials"], None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"4",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev&#39;s</b> inequality - Wikipedia, the free \
encyclopedia",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Chebyshev's_inequality"], None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"5",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev</b> filter - Wikipedia, the free \
encyclopedia",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://en.wikipedia.org/wiki/Chebyshev_filter"], None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"6",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.efunda.com/math/Chebyshev/index.cfm"], None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"7",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["One tailed version of <b>Chebyshev&#39;s</b> inequality \
- by Henry Bottomley",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.btinternet.com/~se16/hgb/cheb.htm"], None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"8",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev</b> biography",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www-history.mcs.st-andrews.ac.uk/Biographies/Chebyshev.html"],
     None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"9",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.960784, 0.878431, 0.666667],
 CellTags->"b:1.5.2"],

Cell[TextData[{
 " ",
 StyleBox[ButtonBox["<b>Chebyshev</b> Polynomials",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://mathews.ecs.fullerton.edu/n2003/ChebyshevPolyMod.html"], 
    None}],
  FontWeight->"Bold"]
}], "Print",
 CellDingbat->"10",
 CellMargins->{{Inherited, Inherited}, {0, 0}},
 FontFamily->"Times",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 CellTags->"b:1.5.2"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Google - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 31.9806505}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Web Services Tutorial", 
    "language" -> "en", "paclet" -> "WebServices", "status" -> "None", 
    "summary" -> 
    "Google.com is a well-known web search engine. Google has made a web \
service available that allows developers to interface with their search \
engine within their own applications. A user can search for any topic on the \
web. A query will return data about the web pages that are found. This \
example demonstrates a Mathematica interface to the Google web service. The \
Google web service provides a good demonstration of using web services to \
retrieve data. This example searches the Google databases for web pages \
containing a certain keyword. The example code then places the results in the \
notebook. To try this example, evaluate all the initialization cells. (You \
can do this using Evaluation > Evaluate Initialization Cells.) Then go to the \
examples here.", "synonyms" -> {}, "title" -> "Google", "type" -> "Tutorial", 
    "uri" -> "WebServices/tutorial/GoogleExample"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:1.5.2"->{
  Cell[729, 29, 63, 2, 70, "Section",
   CellTags->"b:1.5.2",
   CellID->16279],
  Cell[795, 33, 680, 19, 70, "Text",
   CellTags->"b:1.5.2",
   CellID->25996],
  Cell[1478, 54, 305, 7, 70, "Text",
   CellTags->"b:1.5.2",
   CellID->16687],
  Cell[2389, 83, 97, 3, 70, "SubsectionOpener",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->22549],
  Cell[2489, 88, 121, 4, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->17437],
  Cell[2613, 94, 203, 7, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->19866],
  Cell[2819, 103, 472, 12, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->12949],
  Cell[3294, 117, 387, 12, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->193],
  Cell[3684, 131, 193, 7, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->23195],
  Cell[3880, 140, 213, 7, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->3297],
  Cell[4096, 149, 2265, 57, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->20416],
  Cell[6364, 208, 368, 12, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->28286],
  Cell[6735, 222, 1102, 30, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->16105],
  Cell[7840, 254, 1463, 37, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->24488],
  Cell[9306, 293, 557, 15, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->16282],
  Cell[9866, 310, 211, 6, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->12455],
  Cell[10080, 318, 756, 19, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->25734],
  Cell[10839, 339, 382, 12, 70, "Input",
   InitializationCell->True,
   CellTags->"b:1.5.2",
   CellID->18114],
  Cell[11258, 356, 67, 2, 70, "Subsection",
   CellTags->"b:1.5.2",
   CellID->11701],
  Cell[11328, 360, 133, 4, 70, "Text",
   CellTags->"b:1.5.2",
   CellID->31316],
  Cell[11486, 368, 121, 3, 70, "Input",
   CellTags->"b:1.5.2",
   CellID->20671],
  Cell[11632, 375, 545, 18, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[12180, 395, 657, 19, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[12840, 416, 583, 18, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[13426, 436, 617, 18, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[14046, 456, 562, 18, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[14611, 476, 580, 18, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[15194, 496, 605, 19, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[15802, 517, 607, 18, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[16412, 537, 560, 18, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[16975, 557, 637, 19, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[17639, 580, 151, 5, 70, "Text",
   CellTags->"b:1.5.2",
   CellID->27756],
  Cell[17815, 589, 187, 5, 70, "Input",
   CellTags->"b:1.5.2",
   CellID->28321],
  Cell[18027, 598, 651, 19, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[18681, 619, 654, 20, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[19362, 643, 152, 5, 70, "Text",
   CellTags->"b:1.5.2",
   CellID->27982],
  Cell[19539, 652, 232, 6, 70, "Input",
   CellTags->"b:1.5.2",
   CellID->481],
  Cell[19796, 662, 406, 13, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[20205, 677, 449, 14, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[20657, 693, 414, 13, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[21074, 708, 422, 13, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[21499, 723, 428, 13, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[21930, 738, 412, 13, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[22345, 753, 380, 12, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[22728, 767, 429, 13, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[23160, 782, 404, 13, 70, "Print",
   CellTags->"b:1.5.2"],
  Cell[23567, 797, 401, 13, 70, "Print",
   CellTags->"b:1.5.2"]},
 "b:1.5.1"->{
  Cell[1786, 63, 578, 16, 70, "Text",
   CellTags->"b:1.5.1",
   CellID->12046353]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:1.5.2", 26040, 860},
 {"b:1.5.1", 30011, 995}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 63, 2, 70, "Section",
 CellTags->"b:1.5.2",
 CellID->16279],
Cell[795, 33, 680, 19, 70, "Text",
 CellTags->"b:1.5.2",
 CellID->25996],
Cell[1478, 54, 305, 7, 70, "Text",
 CellTags->"b:1.5.2",
 CellID->16687],
Cell[1786, 63, 578, 16, 70, "Text",
 CellTags->"b:1.5.1",
 CellID->12046353],
Cell[CellGroupData[{
Cell[2389, 83, 97, 3, 70, "SubsectionOpener",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->22549],
Cell[2489, 88, 121, 4, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->17437],
Cell[2613, 94, 203, 7, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->19866],
Cell[2819, 103, 472, 12, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->12949],
Cell[3294, 117, 387, 12, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->193],
Cell[3684, 131, 193, 7, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->23195],
Cell[3880, 140, 213, 7, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->3297],
Cell[4096, 149, 2265, 57, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->20416],
Cell[6364, 208, 368, 12, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->28286],
Cell[6735, 222, 1102, 30, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->16105],
Cell[7840, 254, 1463, 37, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->24488],
Cell[9306, 293, 557, 15, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->16282],
Cell[9866, 310, 211, 6, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->12455],
Cell[10080, 318, 756, 19, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->25734],
Cell[10839, 339, 382, 12, 70, "Input",
 InitializationCell->True,
 CellTags->"b:1.5.2",
 CellID->18114]
}, Closed]],
Cell[CellGroupData[{
Cell[11258, 356, 67, 2, 70, "Subsection",
 CellTags->"b:1.5.2",
 CellID->11701],
Cell[11328, 360, 133, 4, 70, "Text",
 CellTags->"b:1.5.2",
 CellID->31316],
Cell[CellGroupData[{
Cell[11486, 368, 121, 3, 70, "Input",
 CellTags->"b:1.5.2",
 CellID->20671],
Cell[CellGroupData[{
Cell[11632, 375, 545, 18, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[12180, 395, 657, 19, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[12840, 416, 583, 18, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[13426, 436, 617, 18, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[14046, 456, 562, 18, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[14611, 476, 580, 18, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[15194, 496, 605, 19, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[15802, 517, 607, 18, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[16412, 537, 560, 18, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[16975, 557, 637, 19, 70, "Print",
 CellTags->"b:1.5.2"]
}, Open  ]]
}, Open  ]],
Cell[17639, 580, 151, 5, 70, "Text",
 CellTags->"b:1.5.2",
 CellID->27756],
Cell[CellGroupData[{
Cell[17815, 589, 187, 5, 70, "Input",
 CellTags->"b:1.5.2",
 CellID->28321],
Cell[CellGroupData[{
Cell[18027, 598, 651, 19, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[18681, 619, 654, 20, 70, "Print",
 CellTags->"b:1.5.2"]
}, Open  ]]
}, Open  ]],
Cell[19362, 643, 152, 5, 70, "Text",
 CellTags->"b:1.5.2",
 CellID->27982],
Cell[CellGroupData[{
Cell[19539, 652, 232, 6, 70, "Input",
 CellTags->"b:1.5.2",
 CellID->481],
Cell[CellGroupData[{
Cell[19796, 662, 406, 13, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[20205, 677, 449, 14, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[20657, 693, 414, 13, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[21074, 708, 422, 13, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[21499, 723, 428, 13, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[21930, 738, 412, 13, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[22345, 753, 380, 12, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[22728, 767, 429, 13, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[23160, 782, 404, 13, 70, "Print",
 CellTags->"b:1.5.2"],
Cell[23567, 797, 401, 13, 70, "Print",
 CellTags->"b:1.5.2"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[24019, 816, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

