(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51015,       1256]
NotebookOptionsPosition[     46879,       1118]
NotebookOutlinePosition[     48458,       1171]
CellTagsIndexPosition[     48173,       1160]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Equal Time Curves   ",
 StyleBox["(A Sample Demonstration)",
  FontSize->20,
  FontWeight->"Plain"]
}], "DemoTitle",
 CellChangeTimes->{
  3.35332394657587*^9, {3.38126871925653*^9, 3.38126877592682*^9}},
 CellID->700863240],

Cell[CellGroupData[{

Cell["", "InitializationSection"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"brachistochrone", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1_", ",", " ", "yp1_"}], "}"}], ",", " ", "v0_"}], "]"}], " ",
    ":=", "\[IndentingNewLine]", 
   RowBox[{"Quiet", "[", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "=", "9.81"}], ",", 
        RowBox[{"y1", "=", 
         RowBox[{"-", "yp1"}]}], ",", " ", "v1", ",", " ", "fr", ",", "curve",
         ",", " ", "normal", ",", 
        RowBox[{"\[Rho]", " ", "=", " ", "0.05"}], ",", " ", "\[CurlyPhi]0", 
        ",", "\[CurlyPhi]1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"v1", " ", "=", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"v0", "^", "2"}], " ", "+", " ", 
          RowBox[{"2", " ", "g", " ", 
           RowBox[{"(", "y1", ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"fr", " ", "=", " ", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              FractionBox[
               RowBox[{
                RowBox[{"v1", "^", "2"}], " ", 
                SuperscriptBox[
                 RowBox[{"Sec", "[", "\[CurlyPhi]1", "]"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"\[CurlyPhi]0", "-", "\[CurlyPhi]1", "+", 
                  RowBox[{
                   RowBox[{"Cos", "[", "\[CurlyPhi]0", "]"}], " ", 
                   RowBox[{"Sin", "[", "\[CurlyPhi]0", "]"}]}], "-", 
                  RowBox[{
                   RowBox[{"Cos", "[", "\[CurlyPhi]1", "]"}], " ", 
                   RowBox[{"Sin", "[", "\[CurlyPhi]1", "]"}]}]}], ")"}]}], 
               RowBox[{"2", " ", "g"}]], "\[Equal]", "x1"}], ",", 
             RowBox[{
              FractionBox[
               RowBox[{
                RowBox[{"v1", "^", "2"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"Cos", "[", 
                    RowBox[{"2", " ", "\[CurlyPhi]0"}], "]"}]}], "+", 
                  RowBox[{"Cos", "[", 
                   RowBox[{"2", " ", "\[CurlyPhi]1"}], "]"}]}], ")"}], " ", 
                SuperscriptBox[
                 RowBox[{"Sec", "[", "\[CurlyPhi]1", "]"}], "2"]}], 
               RowBox[{"4", " ", "g"}]], "\[Equal]", "y1"}]}], "}"}], "]"}], 
          ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[CurlyPhi]0", ",", "1.5"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[CurlyPhi]1", ",", 
            RowBox[{"-", "0.5"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"curve", "[", "\[CurlyPhi]_", "]"}], "=", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"v1", "^", "2"}]}], "/", 
             RowBox[{"(", 
              RowBox[{"2", " ", "g", " ", 
               RowBox[{
                RowBox[{"Cos", "[", "\[CurlyPhi]1", "]"}], "^", "2"}]}], 
              ")"}]}], 
            RowBox[{"(", 
             RowBox[{"\[CurlyPhi]", "-", "\[CurlyPhi]0", "+", 
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"\[CurlyPhi]", "+", "\[CurlyPhi]0"}], "]"}], 
               RowBox[{"Sin", "[", 
                RowBox[{"\[CurlyPhi]", "-", "\[CurlyPhi]0"}], "]"}]}]}], 
             ")"}]}], ",", "\[IndentingNewLine]", "  ", 
           RowBox[{
            RowBox[{
             RowBox[{"v1", "^", "2"}], "/", 
             RowBox[{"(", 
              RowBox[{"2", " ", "g", " ", 
               RowBox[{
                RowBox[{"Cos", "[", "\[CurlyPhi]1", "]"}], "^", "2"}]}], 
              ")"}]}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"\[CurlyPhi]", "+", "\[CurlyPhi]0"}], "]"}], 
              RowBox[{"Sin", "[", 
               RowBox[{"\[CurlyPhi]", "-", "\[CurlyPhi]0"}], "]"}]}], 
             ")"}]}]}], "}"}], "/.", "fr"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"normal", "[", "\[CurlyPhi]_", "]"}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"#", ".", "#"}], "]"}]}], "&"}], "[", 
         RowBox[{
          RowBox[{"Reverse", "[", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"curve", "[", "\[CurlyPhi]", "]"}], ",", "\[CurlyPhi]"}],
             "]"}], "]"}], 
          RowBox[{"{", 
           RowBox[{"1", ",", " ", 
            RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Show", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ParametricPlot", "[", 
            RowBox[{
             RowBox[{"Evaluate", "[", 
              RowBox[{"curve", "[", "\[CurlyPhi]", "]"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Evaluate", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "\[CurlyPhi]", ",", " ", "\[CurlyPhi]0", ",", 
                 "\[CurlyPhi]1"}], "}"}], "/.", "fr"}], "]"}], ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Thickness", "[", ".01", "]"}], "}"}]}], ",", 
             RowBox[{"AxesOrigin", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Thickness", "[", ".008", "]"}], ",", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Circle", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"curve", "[", "\[CurlyPhi]", "]"}], "+", 
                   RowBox[{"\[Rho]", " ", 
                    RowBox[{"normal", "[", "\[CurlyPhi]", "]"}]}]}], ",", 
                  "\[Rho]"}], "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                   "\[CurlyPhi]", ",", " ", "\[CurlyPhi]0", ",", 
                    "\[CurlyPhi]1", ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[CurlyPhi]1", "-", "\[CurlyPhi]0"}], ")"}], "/",
                     "12"}]}], "}"}], "/.", "fr"}], "]"}]}], "]"}]}], "}"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PlotRange", " ", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "3"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", " ", 
              RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"400", ",", "400"}], "}"}]}], ",", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"\"\<time = \>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"NumberForm", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"v1", " ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[CurlyPhi]0", "-", "\[CurlyPhi]1"}], ")"}], "/",
                     
                    RowBox[{"(", 
                    RowBox[{"g", " ", 
                    RowBox[{"Cos", "[", "\[CurlyPhi]1", "]"}]}], ")"}]}]}], "/.",
                   "fr"}], ")"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "3"}], "}"}], ",", 
                RowBox[{"NumberPadding", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}]}], "]"}], 
              "]"}]}], ",", "\"\<Label\>\"", ",", "14"}], "]"}]}], ",", 
         RowBox[{"ImagePadding", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"20", ",", "20"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"20", ",", "30"}], "}"}]}], "}"}]}]}], "]"}]}]}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35092666999086*^9, 3.35092667071099*^9}, {
   3.35092672149832*^9, 3.35092694953367*^9}, {3.35092698298204*^9, 
   3.35092702667317*^9}, {3.35092712078971*^9, 3.35092716104868*^9}, {
   3.35092724846803*^9, 3.35092726708198*^9}, {3.35092732678105*^9, 
   3.35092732721442*^9}, 3.35092738038621*^9, {3.35092748011684*^9, 
   3.35092749409689*^9}, {3.35092752916099*^9, 3.350927533107*^9}, 
   3.35092758945807*^9, {3.35092906050555*^9, 3.35092908667393*^9}, {
   3.3509291746306*^9, 3.35092920394365*^9}, {3.35092937667745*^9, 
   3.35092939611456*^9}, {3.35092960021951*^9, 3.35092960357359*^9}, {
   3.35092974814*^9, 3.35092975196184*^9}, {3.35093001574458*^9, 
   3.35093013369625*^9}, {3.35093028336249*^9, 3.35093028484376*^9}, {
   3.35093034380298*^9, 3.35093035297765*^9}, 3.35093054095865*^9, {
   3.35093102382172*^9, 3.35093103351868*^9}, {3.35093119196225*^9, 
   3.35093119520379*^9}, 3.35093172316084*^9, 3.35093176172175*^9, {
   3.35098914939429*^9, 3.35098928619145*^9}, {3.35098936800097*^9, 
   3.35098945308198*^9}, {3.3509894867691*^9, 3.35098950570827*^9}, {
   3.35098955306041*^9, 3.35098958312181*^9}, {3.35722558428125*^9, 
   3.35722559946875*^9}, {3.35824688923346*^9, 3.35824689715958*^9}, {
   3.36434521626613*^9, 3.36434523473488*^9}, {3.36434528429738*^9, 
   3.36434531665675*^9}, {3.36434538053175*^9, 3.36434538060988*^9}, {
   3.3647502423246*^9, 3.36475025644942*^9}, {3.36483557907852*^9, 
   3.36483565883649*^9}, {3.36483570894105*^9, 3.36483571429991*^9}, {
   3.36559724757968*^9, 3.36559725126718*^9}, {3.36924279801563*^9, 
   3.36924280432813*^9}, {3.37054147034375*^9, 3.370541564484375*^9}, {
   3.374880766359375*^9, 3.374880771*^9}, {3.3779800659189253`*^9, 
   3.3779800685595503`*^9}},
 CellID->24470059]
}, Closed]],

Cell[CellGroupData[{

Cell["", "ManipulateSection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"brachistochrone", "[", 
    RowBox[{"xy", ",", " ", "v0"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v0", ",", " ", "0", ",", " ", "\"\<initial velocity\>\""}], 
      "}"}], ",", " ", "0", ",", " ", "3"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xy", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", "\"\<final point\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"-", "0.3"}]}], "}"}], ",", "Locator"}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Top", ",", "Left"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.35332396390388*^9, 3.35332397140384*^9}, {
  3.35472656070313*^9, 3.35472656964063*^9}, {3.3572255708125*^9, 
  3.35722557289063*^9}, {3.35844501789063*^9, 3.358445032875*^9}, {
  3.364345353688*^9, 3.3643453656255*^9}, {3.36434545729738*^9, 
  3.3643454590005*^9}, {3.3779799565751753`*^9, 3.3779799639658003`*^9}, {
  3.3779801611064253`*^9, 3.3779801940283003`*^9}, {3.3816801001007266`*^9, 
  3.3816801002882266`*^9}},
 CellID->1496021318],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`v0$$ = 0, $CellContext`xy$$ = {2, -2}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`v0$$], 0, "initial velocity"}, 0, 3}, {{
       Hold[$CellContext`xy$$], {2, -2}, "final point"}, {0, -3}, {3, -0.3}}},
     Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`v0$100380$$ = 0, $CellContext`xy$100381$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`v0$$ = 0, $CellContext`xy$$ = {2, -2}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`v0$$, $CellContext`v0$100380$$, 0], 
        Hold[$CellContext`xy$$, $CellContext`xy$100381$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`brachistochrone[$CellContext`xy$$, \
$CellContext`v0$$], 
      "Specifications" :> {{{$CellContext`v0$$, 0, "initial velocity"}, 0, 
         3}, {{$CellContext`xy$$, {2, -2}, "final point"}, {0, -3}, {3, -0.3},
          ControlType -> Locator}}, 
      "Options" :> {ControlPlacement -> {Top, Left}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{444., {245.875, 251.125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`brachistochrone[{
          Pattern[$CellContext`x1, 
           Blank[]], 
          Pattern[$CellContext`yp1, 
           Blank[]]}, 
         Pattern[$CellContext`v0, 
          Blank[]]] := Quiet[
         Module[{$CellContext`g = 
           9.81, $CellContext`y1 = -$CellContext`yp1, $CellContext`v1, \
$CellContext`fr, $CellContext`curve, $CellContext`normal, $CellContext`\[Rho] = 
           0.05, $CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, \
$CellContext`v1 = 
           Sqrt[$CellContext`v0^2 + (
               2 $CellContext`g) $CellContext`y1]; $CellContext`fr = 
           FindRoot[
             
             Evaluate[{(($CellContext`v1^2 
                  Sec[$CellContext`\[CurlyPhi]1]^2) \
($CellContext`\[CurlyPhi]0 - $CellContext`\[CurlyPhi]1 + 
                  Cos[$CellContext`\[CurlyPhi]0] 
                   Sin[$CellContext`\[CurlyPhi]0] - 
                  Cos[$CellContext`\[CurlyPhi]1] 
                  Sin[$CellContext`\[CurlyPhi]1]))/(
                2 $CellContext`g) == $CellContext`x1, (($CellContext`v1^2 (-
                    Cos[2 $CellContext`\[CurlyPhi]0] + 
                   Cos[2 $CellContext`\[CurlyPhi]1])) 
                 Sec[$CellContext`\[CurlyPhi]1]^2)/(
                4 $CellContext`g) == $CellContext`y1}], {$CellContext`\
\[CurlyPhi]0, 1.5}, {$CellContext`\[CurlyPhi]1, -0.5}]; $CellContext`curve[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = 
           ReplaceAll[{(-($CellContext`v1^2/((2 $CellContext`g) 
                Cos[$CellContext`\[CurlyPhi]1]^2))) ($CellContext`\[CurlyPhi] - \
$CellContext`\[CurlyPhi]0 + 
               Cos[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
                Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0]), \
($CellContext`v1^2/((2 $CellContext`g) Cos[$CellContext`\[CurlyPhi]1]^2)) (
               Sin[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
               Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0])}, \
$CellContext`fr]; $CellContext`normal[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = (#/Sqrt[
             Dot[#, #]]& )[Reverse[
               D[
                $CellContext`curve[$CellContext`\[CurlyPhi]], $CellContext`\
\[CurlyPhi]]] {1, -1}]; Show[{
             ParametricPlot[
              Evaluate[
               $CellContext`curve[$CellContext`\[CurlyPhi]]], 
              Evaluate[
               
               ReplaceAll[{$CellContext`\[CurlyPhi], \
$CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, $CellContext`fr]], 
              PlotStyle -> {
                Thickness[0.01]}, AxesOrigin -> {0, 0}], 
             Graphics[{
               Thickness[0.008], 
               Table[
                
                Circle[$CellContext`curve[$CellContext`\[CurlyPhi]] + \
$CellContext`\[Rho] $CellContext`normal[$CellContext`\[CurlyPhi]], \
$CellContext`\[Rho]], 
                Evaluate[
                 
                 ReplaceAll[{$CellContext`\[CurlyPhi], $CellContext`\
\[CurlyPhi]0, $CellContext`\[CurlyPhi]1, ($CellContext`\[CurlyPhi]1 - \
$CellContext`\[CurlyPhi]0)/12}, $CellContext`fr]]]}]}, 
            PlotRange -> {{0, 3}, {1/2, -3}}, ImageSize -> {400, 400}, 
            PlotLabel -> Style[
              StringJoin["time = ", 
               ToString[
                NumberForm[
                 
                 ReplaceAll[$CellContext`v1 (($CellContext`\[CurlyPhi]0 - \
$CellContext`\[CurlyPhi]1)/($CellContext`g 
                   Cos[$CellContext`\[CurlyPhi]1])), $CellContext`fr], {4, 3},
                  NumberPadding -> {"", "0"}]]], "Label"], 
            ImagePadding -> {{20, 20}, {20, 30}}]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->70079138]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ManipulateCaptionSection"],

Cell["\<\
This shows the shape of the brachistochrone from the origin to a variable \
final point. The circles indicate the position of the sliding point at \
equally spaced times.\
\>", "ManipulateCaption",
 CellChangeTimes->{3.35332401137233*^9},
 CellID->1044312921]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ThumbnailSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`v0$$ = 0, $CellContext`xy$$ = {2, -2}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`v0$$], 0, "initial velocity"}, 0, 3}, {{
       Hold[$CellContext`xy$$], {2, -2}, "final point"}, {0, -3}, {3, -0.3}}},
     Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`v0$100436$$ = 0, $CellContext`xy$100437$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`v0$$ = 0, $CellContext`xy$$ = {2, -2}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`v0$$, $CellContext`v0$100436$$, 0], 
        Hold[$CellContext`xy$$, $CellContext`xy$100437$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`brachistochrone[$CellContext`xy$$, \
$CellContext`v0$$], 
      "Specifications" :> {{{$CellContext`v0$$, 0, "initial velocity"}, 0, 
         3}, {{$CellContext`xy$$, {2, -2}, "final point"}, {0, -3}, {3, -0.3},
          ControlType -> Locator}}, 
      "Options" :> {ControlPlacement -> {Top, Left}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{444., {245.875, 251.125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`brachistochrone[{
          Pattern[$CellContext`x1, 
           Blank[]], 
          Pattern[$CellContext`yp1, 
           Blank[]]}, 
         Pattern[$CellContext`v0, 
          Blank[]]] := Quiet[
         Module[{$CellContext`g = 
           9.81, $CellContext`y1 = -$CellContext`yp1, $CellContext`v1, \
$CellContext`fr, $CellContext`curve, $CellContext`normal, $CellContext`\[Rho] = 
           0.05, $CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, \
$CellContext`v1 = 
           Sqrt[$CellContext`v0^2 + (
               2 $CellContext`g) $CellContext`y1]; $CellContext`fr = 
           FindRoot[
             
             Evaluate[{(($CellContext`v1^2 
                  Sec[$CellContext`\[CurlyPhi]1]^2) \
($CellContext`\[CurlyPhi]0 - $CellContext`\[CurlyPhi]1 + 
                  Cos[$CellContext`\[CurlyPhi]0] 
                   Sin[$CellContext`\[CurlyPhi]0] - 
                  Cos[$CellContext`\[CurlyPhi]1] 
                  Sin[$CellContext`\[CurlyPhi]1]))/(
                2 $CellContext`g) == $CellContext`x1, (($CellContext`v1^2 (-
                    Cos[2 $CellContext`\[CurlyPhi]0] + 
                   Cos[2 $CellContext`\[CurlyPhi]1])) 
                 Sec[$CellContext`\[CurlyPhi]1]^2)/(
                4 $CellContext`g) == $CellContext`y1}], {$CellContext`\
\[CurlyPhi]0, 1.5}, {$CellContext`\[CurlyPhi]1, -0.5}]; $CellContext`curve[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = 
           ReplaceAll[{(-($CellContext`v1^2/((2 $CellContext`g) 
                Cos[$CellContext`\[CurlyPhi]1]^2))) ($CellContext`\[CurlyPhi] - \
$CellContext`\[CurlyPhi]0 + 
               Cos[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
                Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0]), \
($CellContext`v1^2/((2 $CellContext`g) Cos[$CellContext`\[CurlyPhi]1]^2)) (
               Sin[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
               Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0])}, \
$CellContext`fr]; $CellContext`normal[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = (#/Sqrt[
             Dot[#, #]]& )[Reverse[
               D[
                $CellContext`curve[$CellContext`\[CurlyPhi]], $CellContext`\
\[CurlyPhi]]] {1, -1}]; Show[{
             ParametricPlot[
              Evaluate[
               $CellContext`curve[$CellContext`\[CurlyPhi]]], 
              Evaluate[
               
               ReplaceAll[{$CellContext`\[CurlyPhi], \
$CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, $CellContext`fr]], 
              PlotStyle -> {
                Thickness[0.01]}, AxesOrigin -> {0, 0}], 
             Graphics[{
               Thickness[0.008], 
               Table[
                
                Circle[$CellContext`curve[$CellContext`\[CurlyPhi]] + \
$CellContext`\[Rho] $CellContext`normal[$CellContext`\[CurlyPhi]], \
$CellContext`\[Rho]], 
                Evaluate[
                 
                 ReplaceAll[{$CellContext`\[CurlyPhi], $CellContext`\
\[CurlyPhi]0, $CellContext`\[CurlyPhi]1, ($CellContext`\[CurlyPhi]1 - \
$CellContext`\[CurlyPhi]0)/12}, $CellContext`fr]]]}]}, 
            PlotRange -> {{0, 3}, {1/2, -3}}, ImageSize -> {400, 400}, 
            PlotLabel -> Style[
              StringJoin["time = ", 
               ToString[
                NumberForm[
                 
                 ReplaceAll[$CellContext`v1 (($CellContext`\[CurlyPhi]0 - \
$CellContext`\[CurlyPhi]1)/($CellContext`g 
                   Cos[$CellContext`\[CurlyPhi]1])), $CellContext`fr], {4, 3},
                  NumberPadding -> {"", "0"}]]], "Label"], 
            ImagePadding -> {{20, 20}, {20, 30}}]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->455422817]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SnapshotsSection"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`v0$$ = 1.085, $CellContext`xy$$ = {
    2.436, -1.125}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`v0$$], 1.085, "initial velocity"}, 0, 3}, {{
       Hold[$CellContext`xy$$], {2.436, -1.125}, "final point"}, {0, -3}, {
      3, -0.3}}}, Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0,
     Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`v0$100492$$ = 0, $CellContext`xy$100493$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`v0$$ = 
        1.085, $CellContext`xy$$ = {2.436, -1.125}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`v0$$, $CellContext`v0$100492$$, 0], 
        Hold[$CellContext`xy$$, $CellContext`xy$100493$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`brachistochrone[$CellContext`xy$$, \
$CellContext`v0$$], 
      "Specifications" :> {{{$CellContext`v0$$, 1.085, "initial velocity"}, 0,
          3}, {{$CellContext`xy$$, {2.436, -1.125}, "final point"}, {0, -3}, {
         3, -0.3}, ControlType -> Locator}}, 
      "Options" :> {ControlPlacement -> {Top, Left}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{444., {245.875, 251.125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`brachistochrone[{
          Pattern[$CellContext`x1, 
           Blank[]], 
          Pattern[$CellContext`yp1, 
           Blank[]]}, 
         Pattern[$CellContext`v0, 
          Blank[]]] := Quiet[
         Module[{$CellContext`g = 
           9.81, $CellContext`y1 = -$CellContext`yp1, $CellContext`v1, \
$CellContext`fr, $CellContext`curve, $CellContext`normal, $CellContext`\[Rho] = 
           0.05, $CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, \
$CellContext`v1 = 
           Sqrt[$CellContext`v0^2 + (
               2 $CellContext`g) $CellContext`y1]; $CellContext`fr = 
           FindRoot[
             
             Evaluate[{(($CellContext`v1^2 
                  Sec[$CellContext`\[CurlyPhi]1]^2) \
($CellContext`\[CurlyPhi]0 - $CellContext`\[CurlyPhi]1 + 
                  Cos[$CellContext`\[CurlyPhi]0] 
                   Sin[$CellContext`\[CurlyPhi]0] - 
                  Cos[$CellContext`\[CurlyPhi]1] 
                  Sin[$CellContext`\[CurlyPhi]1]))/(
                2 $CellContext`g) == $CellContext`x1, (($CellContext`v1^2 (-
                    Cos[2 $CellContext`\[CurlyPhi]0] + 
                   Cos[2 $CellContext`\[CurlyPhi]1])) 
                 Sec[$CellContext`\[CurlyPhi]1]^2)/(
                4 $CellContext`g) == $CellContext`y1}], {$CellContext`\
\[CurlyPhi]0, 1.5}, {$CellContext`\[CurlyPhi]1, -0.5}]; $CellContext`curve[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = 
           ReplaceAll[{(-($CellContext`v1^2/((2 $CellContext`g) 
                Cos[$CellContext`\[CurlyPhi]1]^2))) ($CellContext`\[CurlyPhi] - \
$CellContext`\[CurlyPhi]0 + 
               Cos[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
                Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0]), \
($CellContext`v1^2/((2 $CellContext`g) Cos[$CellContext`\[CurlyPhi]1]^2)) (
               Sin[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
               Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0])}, \
$CellContext`fr]; $CellContext`normal[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = (#/Sqrt[
             Dot[#, #]]& )[Reverse[
               D[
                $CellContext`curve[$CellContext`\[CurlyPhi]], $CellContext`\
\[CurlyPhi]]] {1, -1}]; Show[{
             ParametricPlot[
              Evaluate[
               $CellContext`curve[$CellContext`\[CurlyPhi]]], 
              Evaluate[
               
               ReplaceAll[{$CellContext`\[CurlyPhi], \
$CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, $CellContext`fr]], 
              PlotStyle -> {
                Thickness[0.01]}, AxesOrigin -> {0, 0}], 
             Graphics[{
               Thickness[0.008], 
               Table[
                
                Circle[$CellContext`curve[$CellContext`\[CurlyPhi]] + \
$CellContext`\[Rho] $CellContext`normal[$CellContext`\[CurlyPhi]], \
$CellContext`\[Rho]], 
                Evaluate[
                 
                 ReplaceAll[{$CellContext`\[CurlyPhi], $CellContext`\
\[CurlyPhi]0, $CellContext`\[CurlyPhi]1, ($CellContext`\[CurlyPhi]1 - \
$CellContext`\[CurlyPhi]0)/12}, $CellContext`fr]]]}]}, 
            PlotRange -> {{0, 3}, {1/2, -3}}, ImageSize -> {400, 400}, 
            PlotLabel -> Style[
              StringJoin["time = ", 
               ToString[
                NumberForm[
                 
                 ReplaceAll[$CellContext`v1 (($CellContext`\[CurlyPhi]0 - \
$CellContext`\[CurlyPhi]1)/($CellContext`g 
                   Cos[$CellContext`\[CurlyPhi]1])), $CellContext`fr], {4, 3},
                  NumberPadding -> {"", "0"}]]], "Label"], 
            ImagePadding -> {{20, 20}, {20, 30}}]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->15896079],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`v0$$ = 2.99, $CellContext`xy$$ = {
    1.1340000000000001`, -2.76}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`v0$$], 2.99, "initial velocity"}, 0, 3}, {{
       Hold[$CellContext`xy$$], {1.1340000000000001`, -2.76}, 
       "final point"}, {0, -3}, {3, -0.3}}}, Typeset`size$$ = {
    400., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`v0$100548$$ = 
    0, $CellContext`xy$100549$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`v0$$ = 
        2.99, $CellContext`xy$$ = {1.1340000000000001`, -2.76}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`v0$$, $CellContext`v0$100548$$, 0], 
        Hold[$CellContext`xy$$, $CellContext`xy$100549$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`brachistochrone[$CellContext`xy$$, \
$CellContext`v0$$], 
      "Specifications" :> {{{$CellContext`v0$$, 2.99, "initial velocity"}, 0, 
         3}, {{$CellContext`xy$$, {1.1340000000000001`, -2.76}, 
          "final point"}, {0, -3}, {3, -0.3}, ControlType -> Locator}}, 
      "Options" :> {ControlPlacement -> {Top, Left}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{444., {245.875, 251.125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`brachistochrone[{
          Pattern[$CellContext`x1, 
           Blank[]], 
          Pattern[$CellContext`yp1, 
           Blank[]]}, 
         Pattern[$CellContext`v0, 
          Blank[]]] := Quiet[
         Module[{$CellContext`g = 
           9.81, $CellContext`y1 = -$CellContext`yp1, $CellContext`v1, \
$CellContext`fr, $CellContext`curve, $CellContext`normal, $CellContext`\[Rho] = 
           0.05, $CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, \
$CellContext`v1 = 
           Sqrt[$CellContext`v0^2 + (
               2 $CellContext`g) $CellContext`y1]; $CellContext`fr = 
           FindRoot[
             
             Evaluate[{(($CellContext`v1^2 
                  Sec[$CellContext`\[CurlyPhi]1]^2) \
($CellContext`\[CurlyPhi]0 - $CellContext`\[CurlyPhi]1 + 
                  Cos[$CellContext`\[CurlyPhi]0] 
                   Sin[$CellContext`\[CurlyPhi]0] - 
                  Cos[$CellContext`\[CurlyPhi]1] 
                  Sin[$CellContext`\[CurlyPhi]1]))/(
                2 $CellContext`g) == $CellContext`x1, (($CellContext`v1^2 (-
                    Cos[2 $CellContext`\[CurlyPhi]0] + 
                   Cos[2 $CellContext`\[CurlyPhi]1])) 
                 Sec[$CellContext`\[CurlyPhi]1]^2)/(
                4 $CellContext`g) == $CellContext`y1}], {$CellContext`\
\[CurlyPhi]0, 1.5}, {$CellContext`\[CurlyPhi]1, -0.5}]; $CellContext`curve[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = 
           ReplaceAll[{(-($CellContext`v1^2/((2 $CellContext`g) 
                Cos[$CellContext`\[CurlyPhi]1]^2))) ($CellContext`\[CurlyPhi] - \
$CellContext`\[CurlyPhi]0 + 
               Cos[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
                Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0]), \
($CellContext`v1^2/((2 $CellContext`g) Cos[$CellContext`\[CurlyPhi]1]^2)) (
               Sin[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
               Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0])}, \
$CellContext`fr]; $CellContext`normal[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = (#/Sqrt[
             Dot[#, #]]& )[Reverse[
               D[
                $CellContext`curve[$CellContext`\[CurlyPhi]], $CellContext`\
\[CurlyPhi]]] {1, -1}]; Show[{
             ParametricPlot[
              Evaluate[
               $CellContext`curve[$CellContext`\[CurlyPhi]]], 
              Evaluate[
               
               ReplaceAll[{$CellContext`\[CurlyPhi], \
$CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, $CellContext`fr]], 
              PlotStyle -> {
                Thickness[0.01]}, AxesOrigin -> {0, 0}], 
             Graphics[{
               Thickness[0.008], 
               Table[
                
                Circle[$CellContext`curve[$CellContext`\[CurlyPhi]] + \
$CellContext`\[Rho] $CellContext`normal[$CellContext`\[CurlyPhi]], \
$CellContext`\[Rho]], 
                Evaluate[
                 
                 ReplaceAll[{$CellContext`\[CurlyPhi], $CellContext`\
\[CurlyPhi]0, $CellContext`\[CurlyPhi]1, ($CellContext`\[CurlyPhi]1 - \
$CellContext`\[CurlyPhi]0)/12}, $CellContext`fr]]]}]}, 
            PlotRange -> {{0, 3}, {1/2, -3}}, ImageSize -> {400, 400}, 
            PlotLabel -> Style[
              StringJoin["time = ", 
               ToString[
                NumberForm[
                 
                 ReplaceAll[$CellContext`v1 (($CellContext`\[CurlyPhi]0 - \
$CellContext`\[CurlyPhi]1)/($CellContext`g 
                   Cos[$CellContext`\[CurlyPhi]1])), $CellContext`fr], {4, 3},
                  NumberPadding -> {"", "0"}]]], "Label"], 
            ImagePadding -> {{20, 20}, {20, 30}}]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->137729279],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`v0$$ = 3., $CellContext`xy$$ = {
    2.906, -0.30500000000000016`}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`v0$$], 3., "initial velocity"}, 0, 3}, {{
       Hold[$CellContext`xy$$], {2.906, -0.30500000000000016`}, 
       "final point"}, {0, -3}, {3, -0.3}}}, Typeset`size$$ = {
    400., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`v0$100604$$ = 
    0, $CellContext`xy$100605$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`v0$$ = 
        3., $CellContext`xy$$ = {2.906, -0.30500000000000016`}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`v0$$, $CellContext`v0$100604$$, 0], 
        Hold[$CellContext`xy$$, $CellContext`xy$100605$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`brachistochrone[$CellContext`xy$$, \
$CellContext`v0$$], 
      "Specifications" :> {{{$CellContext`v0$$, 3., "initial velocity"}, 0, 
         3}, {{$CellContext`xy$$, {2.906, -0.30500000000000016`}, 
          "final point"}, {0, -3}, {3, -0.3}, ControlType -> Locator}}, 
      "Options" :> {ControlPlacement -> {Top, Left}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{444., {245.875, 251.125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`brachistochrone[{
          Pattern[$CellContext`x1, 
           Blank[]], 
          Pattern[$CellContext`yp1, 
           Blank[]]}, 
         Pattern[$CellContext`v0, 
          Blank[]]] := Quiet[
         Module[{$CellContext`g = 
           9.81, $CellContext`y1 = -$CellContext`yp1, $CellContext`v1, \
$CellContext`fr, $CellContext`curve, $CellContext`normal, $CellContext`\[Rho] = 
           0.05, $CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, \
$CellContext`v1 = 
           Sqrt[$CellContext`v0^2 + (
               2 $CellContext`g) $CellContext`y1]; $CellContext`fr = 
           FindRoot[
             
             Evaluate[{(($CellContext`v1^2 
                  Sec[$CellContext`\[CurlyPhi]1]^2) \
($CellContext`\[CurlyPhi]0 - $CellContext`\[CurlyPhi]1 + 
                  Cos[$CellContext`\[CurlyPhi]0] 
                   Sin[$CellContext`\[CurlyPhi]0] - 
                  Cos[$CellContext`\[CurlyPhi]1] 
                  Sin[$CellContext`\[CurlyPhi]1]))/(
                2 $CellContext`g) == $CellContext`x1, (($CellContext`v1^2 (-
                    Cos[2 $CellContext`\[CurlyPhi]0] + 
                   Cos[2 $CellContext`\[CurlyPhi]1])) 
                 Sec[$CellContext`\[CurlyPhi]1]^2)/(
                4 $CellContext`g) == $CellContext`y1}], {$CellContext`\
\[CurlyPhi]0, 1.5}, {$CellContext`\[CurlyPhi]1, -0.5}]; $CellContext`curve[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = 
           ReplaceAll[{(-($CellContext`v1^2/((2 $CellContext`g) 
                Cos[$CellContext`\[CurlyPhi]1]^2))) ($CellContext`\[CurlyPhi] - \
$CellContext`\[CurlyPhi]0 + 
               Cos[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
                Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0]), \
($CellContext`v1^2/((2 $CellContext`g) Cos[$CellContext`\[CurlyPhi]1]^2)) (
               Sin[$CellContext`\[CurlyPhi] + $CellContext`\[CurlyPhi]0] 
               Sin[$CellContext`\[CurlyPhi] - $CellContext`\[CurlyPhi]0])}, \
$CellContext`fr]; $CellContext`normal[
             Pattern[$CellContext`\[CurlyPhi], 
              Blank[]]] = (#/Sqrt[
             Dot[#, #]]& )[Reverse[
               D[
                $CellContext`curve[$CellContext`\[CurlyPhi]], $CellContext`\
\[CurlyPhi]]] {1, -1}]; Show[{
             ParametricPlot[
              Evaluate[
               $CellContext`curve[$CellContext`\[CurlyPhi]]], 
              Evaluate[
               
               ReplaceAll[{$CellContext`\[CurlyPhi], \
$CellContext`\[CurlyPhi]0, $CellContext`\[CurlyPhi]1}, $CellContext`fr]], 
              PlotStyle -> {
                Thickness[0.01]}, AxesOrigin -> {0, 0}], 
             Graphics[{
               Thickness[0.008], 
               Table[
                
                Circle[$CellContext`curve[$CellContext`\[CurlyPhi]] + \
$CellContext`\[Rho] $CellContext`normal[$CellContext`\[CurlyPhi]], \
$CellContext`\[Rho]], 
                Evaluate[
                 
                 ReplaceAll[{$CellContext`\[CurlyPhi], $CellContext`\
\[CurlyPhi]0, $CellContext`\[CurlyPhi]1, ($CellContext`\[CurlyPhi]1 - \
$CellContext`\[CurlyPhi]0)/12}, $CellContext`fr]]]}]}, 
            PlotRange -> {{0, 3}, {1/2, -3}}, ImageSize -> {400, 400}, 
            PlotLabel -> Style[
              StringJoin["time = ", 
               ToString[
                NumberForm[
                 
                 ReplaceAll[$CellContext`v1 (($CellContext`\[CurlyPhi]0 - \
$CellContext`\[CurlyPhi]1)/($CellContext`g 
                   Cos[$CellContext`\[CurlyPhi]1])), $CellContext`fr], {4, 3},
                  NumberPadding -> {"", "0"}]]], "Label"], 
            ImagePadding -> {{20, 20}, {20, 30}}]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->416497313]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "DetailsSection"],

Cell[TextData[{
 "More than 300 years after Johann Bernoulli published the \"problema novum\" \
in ",
 StyleBox["Acta Eruditorium",
  FontSlant->"Italic"],
 " in the summer of 1696, the new ",
 StyleBox["Manipulate", "MR"],
 " feature of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 shows the solution curve, a brachistochrone, in an interactive way. "
}], "DetailNotes",
 CellChangeTimes->{{3.35332402535662*^9, 3.35332402576286*^9}, {
   3.35824691695113*^9, 3.35824693859204*^9}, 3.35824711337094*^9, 
   3.35825190964684*^9, 3.35825208733327*^9, {3.3584448744375*^9, 
   3.35844487795313*^9}},
 CellID->29624037]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "ControlSuggestionsSection",
 CellID->146334000],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Slider Zoom"]}],
  "Hold down the Alt key while moving the sliders for fine adjustment. \n\
Holding Ctrl and/or Shift at the same time as Alt increases the precision of \
the adjustment.",
  ActionDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"SliderZoom",
 CellID->566762185],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Drag Locators"]}],
  "Drag the locators inside this Demonstration to change its settings.",
  ActionDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"DragLocators",
 CellID->1482068850],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Rotate and Zoom in 3D"]}],
  "Drag a 3D graphic to rotate it. Starting the drag near the center tumbles \
the graphic; \nstarting near a corner turns it parallel to the plane of the \
screen. Hold down Ctrl \n(or Cmd on Mac) and drag up and down to zoom.",
  ActionDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"RotateAndZoomIn3D",
 CellID->468340397],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Automatic Animation"]}],
  "Make an animation by clicking the button next to a slider and the play \
button \nthat appears underneath it, or animate all the sliders by selecting \
Autorun \nfrom the menu.",
  ActionDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"AutomaticAnimation",
 CellID->869486124],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Gamepad Controls"]}],
  "Instead of using the sliders and other controls, use a gamepad connected \
to your computer.",
  ActionDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"GamepadControls",
 CellID->1974551880],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Resize Images"]}],
  "Drag the lower\[Hyphen]right corner of an image to resize it.",
  ActionDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"ResizeImages",
 CellID->1228650069],

Cell[BoxData[
 TooltipBox[
  RowBox[{
   CheckboxBox[False], Cell[" Bookmark Animation"]}],
  "Create an animation by adding bookmarks and then selecting Animate \
Bookmarks from the menu.",
  ActionDelay->0.35]], "ControlSuggestions",
 FontFamily->"Verdana",
 CellTags->"BookmarkAnimation",
 CellID->1866443778]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SearchTermsSection"],

Cell["acta eruditorium", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.36434516692238*^9, 3.36434517307863*^9}},
 CellID->9620120],

Cell["brachistochrone", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.364345187125*^9, 3.36434519742188*^9}},
 CellID->245912470],

Cell["Johann Bernoulli", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.36434517834425*^9, 3.36434518228175*^9}},
 CellID->316166559],

Cell["problema novum", "SearchTerms",
 CellChangeTimes->{
  3.35696210375764*^9, {3.36434515707863*^9, 3.364345162188*^9}},
 CellID->137963802]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "RelatedLinksSection"],

Cell[TextData[ButtonBox["Brachistochrone Problem",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/BrachistochroneProblem.html"], 
   None}]], "RelatedLinks",
 CellChangeTimes->{
  3.35696210375764*^9, {3.36924283604688*^9, 3.36924284157813*^9}, {
   3.3779800163095503`*^9, 3.3779800176689253`*^9}},
 CellID->221727717]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "AuthorSection"],

Cell["Contributed by: Michael Trott", "Author",
 CellChangeTimes->{{3.35332404745022*^9, 3.35332404993458*^9}, {
   3.36434516804688*^9, 3.36434517198438*^9}, 3.36924285448438*^9},
 CellID->95413255]
}, Open  ]]
}, Open  ]]
},
WindowSize->{702, 704},
WindowMargins->{{85, Automatic}, {Automatic, 30}},
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 7, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Demonstration.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SliderZoom"->{
  Cell[43115, 988, 370, 10, 27, "ControlSuggestions",
   CellTags->"SliderZoom",
   CellID->566762185]},
 "DragLocators"->{
  Cell[43488, 1000, 276, 8, 27, "ControlSuggestions",
   CellTags->"DragLocators",
   CellID->1482068850]},
 "RotateAndZoomIn3D"->{
  Cell[43767, 1010, 445, 10, 27, "ControlSuggestions",
   CellTags->"RotateAndZoomIn3D",
   CellID->468340397]},
 "AutomaticAnimation"->{
  Cell[44215, 1022, 396, 10, 27, "ControlSuggestions",
   CellTags->"AutomaticAnimation",
   CellID->869486124]},
 "GamepadControls"->{
  Cell[44614, 1034, 307, 9, 27, "ControlSuggestions",
   CellTags->"GamepadControls",
   CellID->1974551880]},
 "ResizeImages"->{
  Cell[44924, 1045, 270, 8, 27, "ControlSuggestions",
   CellTags->"ResizeImages",
   CellID->1228650069]},
 "BookmarkAnimation"->{
  Cell[45197, 1055, 312, 9, 27, "ControlSuggestions",
   CellTags->"BookmarkAnimation",
   CellID->1866443778]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SliderZoom", 47245, 1129},
 {"DragLocators", 47369, 1133},
 {"RotateAndZoomIn3D", 47501, 1137},
 {"AutomaticAnimation", 47639, 1141},
 {"GamepadControls", 47775, 1145},
 {"ResizeImages", 47905, 1149},
 {"BookmarkAnimation", 48037, 1153}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 242, 8, 74, "DemoTitle",
 CellID->700863240],
Cell[CellGroupData[{
Cell[857, 35, 33, 0, 156, "InitializationSection"],
Cell[893, 37, 10269, 239, 70, "Input",
 CellID->24470059]
}, Closed]],
Cell[CellGroupData[{
Cell[11199, 281, 29, 0, 188, "ManipulateSection"],
Cell[CellGroupData[{
Cell[11253, 285, 1432, 36, 101, "Input",
 CellID->1496021318],
Cell[12688, 323, 5768, 119, 508, "Output",
 CellID->70079138]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18502, 448, 36, 0, 136, "ManipulateCaptionSection"],
Cell[18541, 450, 269, 6, 35, "ManipulateCaption",
 CellID->1044312921]
}, Open  ]],
Cell[CellGroupData[{
Cell[18847, 461, 28, 0, 168, "ThumbnailSection"],
Cell[18878, 463, 5769, 119, 508, "Output",
 CellID->455422817]
}, Open  ]],
Cell[CellGroupData[{
Cell[24684, 587, 28, 0, 138, "SnapshotsSection"],
Cell[24715, 589, 5827, 120, 508, "Output",
 CellID->15896079],
Cell[30545, 711, 5888, 122, 508, "Output",
 CellID->137729279],
Cell[36436, 835, 5888, 122, 508, "Output",
 CellID->416497313]
}, Open  ]],
Cell[CellGroupData[{
Cell[42361, 962, 26, 0, 232, "DetailsSection"],
Cell[42390, 964, 628, 16, 50, "DetailNotes",
 CellID->29624037]
}, Open  ]],
Cell[CellGroupData[{
Cell[43055, 985, 57, 1, 120, "ControlSuggestionsSection",
 CellID->146334000],
Cell[43115, 988, 370, 10, 27, "ControlSuggestions",
 CellTags->"SliderZoom",
 CellID->566762185],
Cell[43488, 1000, 276, 8, 27, "ControlSuggestions",
 CellTags->"DragLocators",
 CellID->1482068850],
Cell[43767, 1010, 445, 10, 27, "ControlSuggestions",
 CellTags->"RotateAndZoomIn3D",
 CellID->468340397],
Cell[44215, 1022, 396, 10, 27, "ControlSuggestions",
 CellTags->"AutomaticAnimation",
 CellID->869486124],
Cell[44614, 1034, 307, 9, 27, "ControlSuggestions",
 CellTags->"GamepadControls",
 CellID->1974551880],
Cell[44924, 1045, 270, 8, 27, "ControlSuggestions",
 CellTags->"ResizeImages",
 CellID->1228650069],
Cell[45197, 1055, 312, 9, 27, "ControlSuggestions",
 CellTags->"BookmarkAnimation",
 CellID->1866443778]
}, Open  ]],
Cell[CellGroupData[{
Cell[45546, 1069, 30, 0, 152, "SearchTermsSection"],
Cell[45579, 1071, 145, 3, 21, "SearchTerms",
 CellID->9620120],
Cell[45727, 1076, 144, 3, 21, "SearchTerms",
 CellID->245912470],
Cell[45874, 1081, 147, 3, 21, "SearchTerms",
 CellID->316166559],
Cell[46024, 1086, 143, 3, 21, "SearchTerms",
 CellID->137963802]
}, Open  ]],
Cell[CellGroupData[{
Cell[46204, 1094, 31, 0, 138, "RelatedLinksSection"],
Cell[46238, 1096, 349, 8, 21, "RelatedLinks",
 CellID->221727717]
}, Open  ]],
Cell[CellGroupData[{
Cell[46624, 1109, 25, 0, 136, "AuthorSection"],
Cell[46652, 1111, 199, 3, 21, "Author",
 CellID->95413255]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
