(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1249800,      45576]*)
(*NotebookOutlinePosition[  20124975,     326078]*)
(*  CellTagsIndexPosition[  20020377,     323495]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Advanced Numerical Methods", "IndexSection",
  CellTags->{
  "AbsorptionColumn", "Absorption column example", "Aircraft example", 
    "AircraftF8", "AircraftL1011", "Algebraic Riccati equations", 
    "AmmoniaReactor", "Automobile gas turbine example", "Benchmark systems", 
    "Binary distillation column example", "Block Hessenberg forms", 
    "Canonical forms", "CARE", "Case study systems", "CatalyticCracker", 
    "Catalytic cracker example", "CatalyticReactor", 
    "Catalytic reactor example", "CH-47 helicopter example", "Cheap control", 
    "ChemicalPlant", "Chemical plant example", 
    "CholeskyFactorControllabilityGramian", "Cholesky factorization", 
    "CholeskyFactorObservabilityGramian", "Condenser", 
    "Constrained feedback stabilization", "ControlInput", "Controllability", 
    "Controllability Gramian", "ControllabilityGramian", 
    "Controllability index", "Controllability test", "ControllabilityTest", 
    "Controllable", "Controller design", "Controller-Hessenberg form", 
    "ControllerHessenbergForm", "Damping factor", "DampingFactorRegion", 
    "Damping ratio", "DampingRatioRegion", "DARE", "Deflating subspace", 
    "Design constraints", "DiscreteLyapunovSolve", "DiscreteRiccatiSolve", 
    "DistillationColumn", "Distillation column example", "DominantSubsystem", 
    "DrumBoiler", "Drum boiler case study", "Drum boiler example", 
    "Drum pressure", "Eigenvalues", "Eigenvector matrix", "Eigenvectors", 
    "Electric power system example", "Estimator", "Example systems", 
    "Explicit QR algorithm", "F-8 aircraft example", "Feedback stabilization",
     "Feedwater flow", "FlightControlSystem", "Flight control system example",
     "Fluid catalytic reactor example", "Frequency domain identification", 
    "Frequency response", "FrequencyResponseIdentify", "FrequencyWeights", 
    "FullRankControllerHessenbergBlocks", "FullRankObserverHessenbergBlocks", 
    "GasTurbine", "Gas turbine example", "Gaussian distribution", 
    "GeneralizedEigendecomposition", "GeneralizedEigensystem", 
    "Generalized eigenvalue problem", "Generalized eigenvalues", 
    "GeneralizedEigenvalues", "Generalized eigenvector method", 
    "Generalized eigenvectors", "GeneralizedEigenvectors", 
    "Generalized Schur decomposition", "GeneralizedSchurDecomposition", 
    "GeneralizedSchurDecompositionOrdered", "Generalized Schur method", 
    "Generator axle example", "H2 norm", "Hamiltonian matrix", 
    "Hammarling algorithm", "Hankel matrix", "Hankel singular values", 
    "Heat flow", "HelicopterCH47", "Helicopter example", "Hessenberg forms", 
    "Hessenberg matrix", "HessenbergSchurDecomposition", 
    "Hessenberg-Schur method", "Highway example", "HInfinity control", 
    "HInfinity norm", "Implicit QR algorithm", "Implicit RQ algorithm", 
    "ImplicitRQDecomposition", "Impulse response", "ImpulseResponseIdentify", 
    "Industrial control, case study", "InitialConditions", "InitialGuess", 
    "Internal balancing", "InternallyBalancedForm", 
    "Internally balanced realizations", "Invariant subspace", 
    "Inverse-free methods", "Iterations", "J-100 jet engine example", 
    "Jet engine example", "Kalman-Bucy filter", "KalmanEstimator", 
    "Kalman filter", "Left matrix fraction", 
    "Linear quadratic Gaussian problem", "Linear quadratic regulator", 
    "Lower controller-Hessenberg form", "LowerControllerHessenbergForm", 
    "Lower observer-Hessenberg form", "LQEstimatorGains", "LQG", "LQR", 
    "LQR controller", "LQRegulatorGains", "Lyapunov algorithms", 
    "Lyapunov equations", "Lyapunov feedback stabilization", "Lyapunov shift",
     "LyapunovShift", "LyapunovSolve", "LyapunovSolveOptions", "MagneticTape",
     "Magnetic tape example", "Markov parameters", "Matrix decompositions", 
    "Matrix equations", "Matrix pencil", "MatrixSign", 
    "Matrix Sign-function method", "MaxIterations", "MaxOrder", 
    "Measurement noise", "Method", "Minimal realization", 
    "Minimum energy control", "Model identification", "Model reduction", 
    "Natural frequency", "NaturalFrequencyRegion", "Newton", "Newton method", 
    "Noise", "Observability", "Observability Gramian", "Observability test", 
    "ObservabilityTest", "Observable", "Observer", "Observer design", 
    "Observer-Hessenberg form", "ObserverHessenbergForm", 
    "Observer-Hessenberg forms", "Ordered Schur decomposition", 
    "OutputResponse", "OutputResponseIdentify", "PaperMachine", 
    "Paper machine example", "Partial Lyapunov shift", "PartialLyapunovShift",
     "Partial pole assignment", "Pencil", "Persistently exciting input", 
    "Pivoting", "Pole assignment", "Pole placement", "Poles", 
    "Position control ", 
    "PositiveDiagonalCholeskyFactorControllabilityGramian", 
    "PositiveDiagonalCholeskyFactorObservabilityGramian", 
    "Power plant example", "PowerSystem", "Power system example", 
    "Process noise", "Projection technique", "QRDecomposition", 
    "QR factorization", "QR iteration", "QZ decomposition", "RealBlockForm", 
    "Reboiler", "Recursive", "RecursiveBidiagonal", 
    "Recursive bidiagonal method", "RecursiveBlockBidiagonal", 
    "RecursiveBlockTriangular", "Recursive method", 
    "RecursiveRQDecomposition", "RecursiveTriangular", 
    "Recursive triangular method", "Reduced-order estimator", 
    "ReducedOrderEstimator", "RejectionLevel", "Residuals", 
    "Resonance frequency", "Riccati equations", "RiccatiSolve", "Risers", 
    "Robustness", "Robust stability", "Rotating axle example", 
    "RQ decomposition", "Sampled", "Schur decomposition", 
    "SchurDecomposition", "SchurDecompositionOrdered", "Schur method", 
    "Separation property", "ServoJ100", "Servomechanism example", 
    "Settling time", "SettlingTimeRegion", "Sign-function method", 
    "SimulationPlot", "Singular values", "SmartHighway", 
    "Smart highway example", "SolveMethod", "SquareRoot", 
    "Square-root method", "Stability", "Stability analysis", 
    "Stability region", "Stabilization", "Stabilizing solution", 
    "Staircase algorithm", "State estimation", "StateFeedbackConnect", 
    "StateFeedbackGains", "Steam flow", "SteamPowerSystem", 
    "Steam power system example", "Strong modes", 
    "Subspace system identification", "Sylvester equations", 
    "Sylvester-observer equation", "Symplectic matrix", 
    "System identification", "Tandem-rotor helicopter example", 
    "Time-domain identification", "Time-domain response", "ToDiscreteTime", 
    "Tolerance", "Tubular ammonia reactor example", "TurbineAxle", 
    "Turbine axle example", "Uncontrollable state", "Uncontrollable states", 
    "Uncontrollable system", "Unobservable states", 
    "Unreduced controller-Hessenberg form", 
    "Unreduced observer-Hessenberg form", "Upper controller-Hessenberg form", 
    "Upper observer-Hessenberg form", "UpperObserverHessenbergForm", 
    "Velocity control", "Weak modes", "White noise", "Wind disturbances", 
    "WorkingPrecision", "$SamplingPeriod"}],

Cell[TextData[{
  "Absorption column example",
  ", ",
  StyleBox["AbsorptionColumn", "MR"],
  ", ",
  ButtonBox["ANMA.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Absorption column example"],

Cell[TextData[{
  "model reduction for",
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Absorption column example"],

Cell[TextData[{
  StyleBox["AbsorptionColumn", "MR"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AbsorptionColumn"],

Cell[TextData[{
  "Aircraft example",
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Aircraft example"],

Cell[TextData[{
  StyleBox["AircraftF8", "MR"],
  ", ",
  ButtonBox["ANMA.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Aircraft example"],

Cell[TextData[{
  StyleBox["AircraftL1011", "MR"],
  ", ",
  ButtonBox["ANMA.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Aircraft example"],

Cell[TextData[{
  "Lyapunov equation for",
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Aircraft example"],

Cell[TextData[{
  "pole assignment for",
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Aircraft example"],

Cell[TextData[{
  StyleBox["AircraftF8", "MR"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AircraftF8"],

Cell[TextData[{
  StyleBox["AircraftL1011", "MR"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AircraftL1011"],

Cell[TextData[{
  "Algebraic Riccati equations",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Algebraic Riccati equations"],

Cell[TextData[{
  StyleBox["AmmoniaReactor", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AmmoniaReactor"],

Cell[TextData[{
  "Automobile gas turbine example",
  ", ",
  StyleBox["GasTurbine", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Automobile gas turbine example"],

Cell[TextData[{
  "Benchmark systems",
  ", ",
  " ",
  ButtonBox["ANMA.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Benchmark systems"],

Cell[TextData[{
  "Binary distillation column example",
  ", ",
  StyleBox["DistillationColumn", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Binary distillation column example"],

Cell[TextData[{
  "Block Hessenberg forms",
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Block Hessenberg forms"],

Cell[TextData[{
  "Canonical forms",
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "controller-Hessenberg",
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "observer-Hessenberg",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "CARE",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CARE"],

Cell[TextData[{
  "Case study systems",
  ", ",
  " ",
  ButtonBox["ANMA.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Case study systems"],

Cell[TextData[{
  "Catalytic cracker example",
  ", ",
  StyleBox["CatalyticCracker", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Catalytic cracker example"],

Cell[TextData[{
  "Catalytic reactor example",
  ", ",
  StyleBox["CatalyticReactor", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Catalytic reactor example"],

Cell[TextData[{
  StyleBox["CatalyticCracker", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CatalyticCracker"],

Cell[TextData[{
  StyleBox["CatalyticReactor", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CatalyticReactor"],

Cell[TextData[{
  "CH-47 helicopter example",
  ", ",
  StyleBox["HelicopterCH47", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.10",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CH-47 helicopter example"],

Cell[TextData[{
  "Cheap control",
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cheap control"],

Cell[TextData[{
  "Chemical plant example",
  ", ",
  StyleBox["ChemicalPlant", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Chemical plant example"],

Cell[TextData[{
  StyleBox["ChemicalPlant", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ChemicalPlant"],

Cell[TextData[{
  "Cholesky factorization",
  ", ",
  "of Gramians",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cholesky factorization"],

Cell[TextData[{
  StyleBox["CholeskyFactorControllabilityGramian", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CholeskyFactorControllabilityGramian"],

Cell[TextData[{
  StyleBox["CholeskyFactorObservabilityGramian", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CholeskyFactorObservabilityGramian"],

Cell[TextData[{
  "Condenser",
  ", ",
  " ",
  ButtonBox["ANMA.1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Condenser"],

Cell[TextData[{
  "Constrained feedback stabilization",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Constrained feedback stabilization"],

Cell[TextData[{
  "of drum boiler",
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Constrained feedback stabilization"],

Cell[TextData[{
  StyleBox["ControlInput", "MR"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControlInput"],

Cell[TextData[{
  "Controllability",
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability"],

Cell[TextData[{
  "and controller-Hessenberg forms",
  ", ",
  ButtonBox["ANM2.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controllability"],

Cell[TextData[{
  "Controllability Gramian",
  ", ",
  "Cholesky factor of",
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability Gramian"],

Cell[TextData[{
  "Controllability index",
  ", ",
  " ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability index"],

Cell[TextData[{
  "Controllability test",
  ", ",
  "controllability Gramian",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability test"],

Cell[TextData[{
  "using block Hessenberg form",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controllability test"],

Cell[TextData[{
  "using Lyapunov equations",
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controllability test"],

Cell[TextData[{
  StyleBox["ControllabilityGramian", "MR"],
  ", ",
  " ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllabilityGramian"],

Cell[TextData[{
  StyleBox["ControllabilityTest", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllabilityTest"],

Cell[TextData[{
  StyleBox["Controllable", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllable"],

Cell[TextData[{
  "Controller design",
  ", ",
  "and LQR problem",
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controller design"],

Cell[TextData[{
  "using feedback stabilization",
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller design"],

Cell[TextData[{
  "Controller-Hessenberg form",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controller-Hessenberg form"],

Cell[TextData[{
  StyleBox["ControllerHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller-Hessenberg form"],

Cell[TextData[{
  "in pole assignment",
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller-Hessenberg form"],

Cell[TextData[{
  "lower",
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller-Hessenberg form"],

Cell[TextData[{
  StyleBox["LowerControllerHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller-Hessenberg form"],

Cell[TextData[{
  "unreduced",
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller-Hessenberg form"],

Cell[TextData[{
  "upper",
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller-Hessenberg form"],

Cell[TextData[{
  StyleBox["ControllerHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllerHessenbergForm"],

Cell[TextData[{
  "Damping factor",
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Damping factor"],

Cell[TextData[{
  "of drum boiler",
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Damping factor"],

Cell[TextData[{
  "Damping ratio",
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Damping ratio"],

Cell[TextData[{
  StyleBox["DampingFactorRegion", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DampingFactorRegion"],

Cell[TextData[{
  StyleBox["DampingRatioRegion", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DampingRatioRegion"],

Cell[TextData[{
  "DARE",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DARE"],

Cell[TextData[{
  "Deflating subspace",
  ", ",
  " ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Deflating subspace"],

Cell[TextData[{
  "Design constraints",
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Design constraints"],

Cell[TextData[{
  StyleBox["DiscreteLyapunovSolve", "MR"],
  ", ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteLyapunovSolve"],

Cell[TextData[{
  StyleBox["DiscreteRiccatiSolve", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteRiccatiSolve"],

Cell[TextData[{
  "Distillation column example",
  ", ",
  StyleBox["DistillationColumn", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Distillation column example"],

Cell[TextData[{
  StyleBox["DistillationColumn", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DistillationColumn"],

Cell[TextData[{
  StyleBox["DominantSubsystem", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DominantSubsystem"],

Cell[TextData[{
  "Drum boiler case study",
  ", ",
  " ",
  ButtonBox["ANM2.2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Drum boiler case study"],

Cell[TextData[{
  "Drum boiler example",
  ", ",
  "controller-Hessenberg forms for",
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Drum boiler example"],

Cell[TextData[{
  StyleBox["DrumBoiler", "MR"],
  ", ",
  ButtonBox["ANM2.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Drum boiler example"],

Cell[TextData[{
  "feedback stabilization for",
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Drum boiler example"],

Cell[TextData[{
  "observer-Hessenberg forms for",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Drum boiler example"],

Cell[TextData[{
  "Drum pressure",
  ", ",
  "in drum boiler",
  ", ",
  ButtonBox["ANM2.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Drum pressure"],

Cell[TextData[{
  StyleBox["DrumBoiler", "MR"],
  ", ",
  ButtonBox["ANM2.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DrumBoiler"],

Cell[TextData[{
  "Eigenvalues",
  ", ",
  "generalized",
  ", ",
  " ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Eigenvalues"],

Cell[TextData[{
  "Eigenvector matrix",
  ", ",
  " ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Eigenvector matrix"],

Cell[TextData[{
  "Eigenvectors",
  ", ",
  "generalized",
  ", ",
  " ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Eigenvectors"],

Cell[TextData[{
  "Electric power system example",
  ", ",
  StyleBox["PowerSystem", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.12",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Electric power system example"],

Cell[TextData[{
  "Estimator",
  ", ",
  "reduced-order",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Estimator"],

Cell[TextData[{
  StyleBox["ReducedOrderEstimator", "MR"],
  ", ",
  ButtonBox["ANM6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Estimator"],

Cell[TextData[{
  "Example systems",
  ", ",
  " ",
  ButtonBox["ANMA.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Example systems"],

Cell[TextData[{
  "Explicit QR algorithm",
  ", ",
  "for pole assignment",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Explicit QR algorithm"],

Cell[TextData[{
  "F-8 aircraft example",
  ", ",
  StyleBox["AircraftF8", "MR"],
  ", ",
  ButtonBox["ANMA.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"F-8 aircraft example"],

Cell[TextData[{
  "controllability of",
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"F-8 aircraft example"],

Cell[TextData[{
  "controller-Hessenberg form for",
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"F-8 aircraft example"],

Cell[TextData[{
  "Feedback stabilization",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feedback stabilization"],

Cell[TextData[{
  "for drum boiler",
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Feedback stabilization"],

Cell[TextData[{
  "Lyapunov",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Feedback stabilization"],

Cell[TextData[{
  "Feedwater flow",
  ", ",
  "in drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feedwater flow"],

Cell[TextData[{
  "Flight control system example",
  ", ",
  StyleBox["FlightControlSystem", "MR"],
  ", ",
  ButtonBox["ANMA.1.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Flight control system example"],

Cell[TextData[{
  "pole assignment for",
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Flight control system example"],

Cell[TextData[{
  "Riccati equation for",
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Flight control system example"],

Cell[TextData[{
  StyleBox["FlightControlSystem", "MR"],
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FlightControlSystem"],

Cell[TextData[{
  "Fluid catalytic reactor example",
  ", ",
  StyleBox["CatalyticReactor", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fluid catalytic reactor example"],

Cell[TextData[{
  "Frequency domain identification",
  ", ",
  " ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Frequency domain identification"],

Cell[TextData[{
  "Frequency response",
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Frequency response"],

Cell[TextData[{
  StyleBox["FrequencyResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FrequencyResponseIdentify"],

Cell[TextData[{
  "and ",
  StyleBox["ImpulseResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"FrequencyResponseIdentify"],

Cell[TextData[{
  StyleBox["FrequencyWeights", "MR"],
  ", ",
  "in ",
  StyleBox["FrequencyResponseIdentify", "MR"],
  ", ",
  " ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FrequencyWeights"],

Cell[TextData[{
  StyleBox["FullRankControllerHessenbergBlocks", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FullRankControllerHessenbergBlocks"],

Cell[TextData[{
  StyleBox["FullRankObserverHessenbergBlocks", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FullRankObserverHessenbergBlocks"],

Cell[TextData[{
  "Gas turbine example",
  ", ",
  StyleBox["GasTurbine", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gas turbine example"],

Cell[TextData[{
  StyleBox["GasTurbine", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GasTurbine"],

Cell[TextData[{
  "Gaussian distribution",
  ", ",
  " ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gaussian distribution"],

Cell[TextData[{
  "Generalized eigenvalue problem",
  ", ",
  " ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generalized eigenvalue problem"],

Cell[TextData[{
  "Generalized eigenvalues",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generalized eigenvalues"],

Cell[TextData[{
  StyleBox["GeneralizedEigenvalues", "MR"],
  ", ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generalized eigenvalues"],

Cell[TextData[{
  "Generalized eigenvector method",
  ", ",
  "for Riccati equations",
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generalized eigenvector method"],

Cell[TextData[{
  "Generalized eigenvectors",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generalized eigenvectors"],

Cell[TextData[{
  StyleBox["GeneralizedEigenvectors", "MR"],
  ", ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generalized eigenvectors"],

Cell[TextData[{
  "Generalized Schur decomposition",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generalized Schur decomposition"],

Cell[TextData[{
  "ordered",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generalized Schur decomposition"],

Cell[TextData[{
  "ordered, ",
  StyleBox["GeneralizedSchurDecompositionOrdered", "MR"],
  ", ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generalized Schur decomposition"],

Cell[TextData[{
  "Generalized Schur method",
  ", ",
  "for Riccati equations",
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generalized Schur method"],

Cell[TextData[{
  StyleBox["GeneralizedEigendecomposition", "MR"],
  ", ",
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralizedEigendecomposition"],

Cell[TextData[{
  StyleBox["GeneralizedEigensystem", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralizedEigensystem"],

Cell[TextData[{
  StyleBox["GeneralizedEigenvalues", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralizedEigenvalues"],

Cell[TextData[{
  StyleBox["GeneralizedEigenvectors", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralizedEigenvectors"],

Cell[TextData[{
  StyleBox["GeneralizedSchurDecomposition", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralizedSchurDecomposition"],

Cell[TextData[{
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"GeneralizedSchurDecomposition"],

Cell[TextData[{
  StyleBox["GeneralizedSchurDecompositionOrdered", "MR"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralizedSchurDecompositionOrdered"],

Cell[TextData[{
  "Generator axle example",
  ", ",
  StyleBox["TurbineAxle", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generator axle example"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "2"], TraditionalForm]]],
  " norm",
  ", ",
  "and Gramians",
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"H2 norm"],

Cell[TextData[{
  "using Lyapunov equations",
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"H2 norm"],

Cell[TextData[{
  "Hamiltonian matrix",
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hamiltonian matrix"],

Cell[TextData[{
  "Hammarling algorithm",
  ", ",
  "for Cholesky factorization",
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hammarling algorithm"],

Cell[TextData[{
  "Hankel matrix",
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hankel matrix"],

Cell[TextData[{
  "Hankel singular values",
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hankel singular values"],

Cell[TextData[{
  "Heat flow",
  ", ",
  "in drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Heat flow"],

Cell[TextData[{
  "Helicopter example",
  ", ",
  StyleBox["HelicopterCH47", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.10",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Helicopter example"],

Cell[TextData[{
  StyleBox["HelicopterCH47", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.10",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HelicopterCH47"],

Cell[TextData[{
  "Hessenberg forms",
  ", ",
  " ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hessenberg forms"],

Cell[TextData[{
  "Hessenberg matrix",
  ", ",
  " ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hessenberg matrix"],

Cell[TextData[{
  "Hessenberg-Schur method",
  ", ",
  "for Lyapunov equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hessenberg-Schur method"],

Cell[TextData[{
  StyleBox["HessenbergSchurDecomposition", "MR"],
  ", ",
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HessenbergSchurDecomposition"],

Cell[TextData[{
  "Highway example",
  ", ",
  StyleBox["SmartHighway", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Highway example"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "\[Infinity]"], TraditionalForm]]],
  " control",
  ", ",
  "and Riccati equations",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HInfinity control"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "\[Infinity]"], TraditionalForm]]],
  " norm",
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HInfinity norm"],

Cell[TextData[{
  "and Gramians",
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"HInfinity norm"],

Cell[TextData[{
  "using Lyapunov equations",
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"HInfinity norm"],

Cell[TextData[{
  "Implicit QR algorithm",
  ", ",
  "for pole assignment",
  ", ",
  " ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Implicit QR algorithm"],

Cell[TextData[{
  "Implicit RQ algorithm",
  ", ",
  "for pole assignment",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Implicit RQ algorithm"],

Cell[TextData[{
  StyleBox["ImplicitRQDecomposition", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImplicitRQDecomposition"],

Cell[TextData[{
  "Impulse response",
  ", ",
  "in system identification",
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Impulse response"],

Cell[TextData[{
  "of steam power system",
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Impulse response"],

Cell[TextData[{
  StyleBox["ImpulseResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImpulseResponseIdentify"],

Cell[TextData[{
  "Industrial control, case study",
  ", ",
  " ",
  ButtonBox["ANM2.2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Industrial control, case study"],

Cell[TextData[{
  StyleBox["InitialConditions", "MR"],
  ", ",
  "in ",
  StyleBox["OutputResponse", "MR"],
  ", ",
  " ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialConditions"],

Cell[TextData[{
  StyleBox["InitialGuess", "MR"],
  ", ",
  "in ",
  StyleBox["DiscreteRiccatiSolve", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialGuess"],

Cell[TextData[{
  "in ",
  StyleBox["RiccatiSolve", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"InitialGuess"],

Cell[TextData[{
  "Internal balancing",
  ", ",
  "partial",
  ", ",
  " ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Internal balancing"],

Cell[TextData[{
  "Internally balanced realizations",
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Internally balanced realizations"],

Cell[TextData[{
  StyleBox["InternallyBalancedForm", "MR"],
  ", ",
  " ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InternallyBalancedForm"],

Cell[TextData[{
  "Invariant subspace",
  ", ",
  " ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Invariant subspace"],

Cell[TextData[{
  "Inverse-free methods",
  ", ",
  "for Riccati equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverse-free methods"],

Cell[TextData[{
  "Iterations",
  ", ",
  "number of",
  ", ",
  " ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Iterations"],

Cell[TextData[{
  "J-100 jet engine example",
  ", ",
  StyleBox["ServoJ100", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.13",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"J-100 jet engine example"],

Cell[TextData[{
  "Jet engine example",
  ", ",
  "partial pole assignment for",
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Jet engine example"],

Cell[TextData[{
  StyleBox["ServoJ100", "MR"],
  ", ",
  ButtonBox["ANMA.1.13",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Jet engine example"],

Cell[TextData[{
  "Kalman filter",
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman filter"],

Cell[TextData[{
  "Kalman-Bucy filter",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman-Bucy filter"],

Cell[TextData[{
  StyleBox["KalmanEstimator", "MR"],
  ", ",
  " ",
  ButtonBox["ANM6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KalmanEstimator"],

Cell[TextData[{
  "Left matrix fraction",
  ", ",
  " ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Left matrix fraction"],

Cell[TextData[{
  "Linear quadratic Gaussian problem",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linear quadratic Gaussian problem"],

Cell[TextData[{
  "Linear quadratic regulator",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linear quadratic regulator"],

Cell[TextData[{
  "Lower controller-Hessenberg form",
  ", ",
  StyleBox["LowerControllerHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lower controller-Hessenberg form"],

Cell[TextData[{
  "Lower observer-Hessenberg form",
  ", ",
  StyleBox["ObserverHessenbergForm", "MR"],
  ", ",
  " ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lower observer-Hessenberg form"],

Cell[TextData[{
  StyleBox["LowerControllerHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LowerControllerHessenbergForm"],

Cell[TextData[{
  StyleBox["LQEstimatorGains", "MR"],
  ", ",
  " ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQEstimatorGains"],

Cell[TextData[{
  "LQG",
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQG"],

Cell[TextData[{
  "LQR",
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQR"],

Cell[TextData[{
  "LQR controller",
  ", ",
  "for drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQR controller"],

Cell[TextData[{
  StyleBox["LQRegulatorGains", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQRegulatorGains"],

Cell[TextData[{
  "Lyapunov algorithms",
  ", ",
  "for feedback stabilization",
  ", ",
  " ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lyapunov algorithms"],

Cell[TextData[{
  "Lyapunov equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "discrete",
  ", ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  StyleBox["DiscreteLyapunovSolve", "MR"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "for feedback stabilization",
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "for Gramians",
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "Hessenberg-Schur method for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "in Newton method for CARE and DARE",
  ", ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  StyleBox["LyapunovSolve", "MR"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "Schur method for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "Lyapunov feedback stabilization",
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lyapunov feedback stabilization"],

Cell[TextData[{
  "for drum boiler",
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov feedback stabilization"],

Cell[TextData[{
  "Lyapunov shift",
  ", ",
  StyleBox["LyapunovShift", "MR"],
  ", ",
  " ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lyapunov shift"],

Cell[TextData[{
  StyleBox["LyapunovShift", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LyapunovShift"],

Cell[TextData[{
  StyleBox["LyapunovSolve", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LyapunovSolve"],

Cell[TextData[{
  StyleBox["LyapunovSolveOptions", "MR"],
  ", ",
  " ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LyapunovSolveOptions"],

Cell[TextData[{
  "Magnetic tape example",
  ", ",
  "feedback stabilization for",
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Magnetic tape example"],

Cell[TextData[{
  StyleBox["MagneticTape", "MR"],
  ", ",
  ButtonBox["ANMA.1.11",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Magnetic tape example"],

Cell[TextData[{
  "state estimator for",
  ", ",
  ButtonBox["ANM6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Magnetic tape example"],

Cell[TextData[{
  StyleBox["MagneticTape", "MR"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.11",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MagneticTape"],

Cell[TextData[{
  "Markov parameters",
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Markov parameters"],

Cell[TextData[{
  "Matrix decompositions",
  ", ",
  " ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix decompositions"],

Cell[TextData[{
  "Matrix equations",
  ", ",
  " ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix equations"],

Cell[TextData[{
  "Matrix pencil",
  ", ",
  " ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix pencil"],

Cell[TextData[{
  "Matrix Sign-function method",
  ", ",
  ButtonBox["ANM3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix Sign-function method"],

Cell[TextData[{
  "for Riccati equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Matrix Sign-function method"],

Cell[TextData[{
  StyleBox["MatrixSign", "MR"],
  ", ",
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatrixSign"],

Cell[TextData[{
  StyleBox["MaxIterations", "MR"],
  ", ",
  "in ",
  StyleBox["Advanced Numerical Methods",
    FontSlant->"Italic"],
  " functions",
  ", ",
  " ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaxIterations"],

Cell[TextData[{
  StyleBox["MaxOrder", "MR"],
  ", ",
  "in ",
  StyleBox["FrequencyResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaxOrder"],

Cell[TextData[{
  "in ",
  StyleBox["ImpulseResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MaxOrder"],

Cell[TextData[{
  "in ",
  StyleBox["OutputResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MaxOrder"],

Cell[TextData[{
  "Measurement noise",
  ", ",
  " ",
  ButtonBox["ANMA.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Measurement noise"],

Cell[TextData[{
  StyleBox["Method", "MR"],
  ", ",
  "in ",
  StyleBox["ReducedOrderEstimator", "MR"],
  ", ",
  ButtonBox["ANM6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Method"],

Cell[TextData[{
  "in ",
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Method"],

Cell[TextData[{
  "Minimal realization",
  ", ",
  " ",
  ButtonBox["ANM8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Minimal realization"],

Cell[TextData[{
  "Minimum energy control",
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Minimum energy control"],

Cell[TextData[{
  "Model identification",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Model identification"],

Cell[TextData[{
  "Model reduction",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Model reduction"],

Cell[TextData[{
  "using balanced truncation",
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Model reduction"],

Cell[TextData[{
  "using Lyapunov equations",
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Model reduction"],

Cell[TextData[{
  "using Schur method",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Model reduction"],

Cell[TextData[{
  "using square-root method",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Model reduction"],

Cell[TextData[{
  "Natural frequency",
  ", ",
  " ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Natural frequency"],

Cell[TextData[{
  StyleBox["NaturalFrequencyRegion", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NaturalFrequencyRegion"],

Cell[TextData[{
  StyleBox["Newton", "MR"],
  ", ",
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Newton"],

Cell[TextData[{
  "Newton method",
  ", ",
  "for Riccati equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Newton method"],

Cell[TextData[{
  "in ",
  StyleBox["LQRegulatorGains", "MR"],
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Newton method"],

Cell[TextData[{
  "Noise",
  ", ",
  "sensitivity to",
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Noise"],

Cell[TextData[{
  "white",
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "Observability",
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability"],

Cell[TextData[{
  "and observer-Hessenberg forms",
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observability"],

Cell[TextData[{
  "index",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observability"],

Cell[TextData[{
  "Observability Gramian",
  ", ",
  "Cholesky factor of",
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability Gramian"],

Cell[TextData[{
  "Observability test",
  ", ",
  "using block Hessenberg form",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability test"],

Cell[TextData[{
  "using observability Gramian",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observability test"],

Cell[TextData[{
  StyleBox["ObservabilityTest", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservabilityTest"],

Cell[TextData[{
  StyleBox["Observable", "MR"],
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observable"],

Cell[TextData[{
  "Observer",
  ", ",
  ButtonBox["ANM6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observer"],

Cell[TextData[{
  "reduced-order",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer"],

Cell[TextData[{
  StyleBox["ReducedOrderEstimator", "MR"],
  ", ",
  ButtonBox["ANM6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer"],

Cell[TextData[{
  "Observer design",
  ", ",
  "for drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observer design"],

Cell[TextData[{
  "Observer-Hessenberg form",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observer-Hessenberg form"],

Cell[TextData[{
  "lower",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer-Hessenberg form"],

Cell[TextData[{
  StyleBox["ObserverHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer-Hessenberg form"],

Cell[TextData[{
  "unreduced",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer-Hessenberg form"],

Cell[TextData[{
  "upper",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer-Hessenberg form"],

Cell[TextData[{
  StyleBox["UpperObserverHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer-Hessenberg form"],

Cell[TextData[{
  "Observer-Hessenberg forms",
  ", ",
  " ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observer-Hessenberg forms"],

Cell[TextData[{
  StyleBox["ObserverHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObserverHessenbergForm"],

Cell[TextData[{
  "Ordered Schur decomposition",
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ordered Schur decomposition"],

Cell[TextData[{
  StyleBox["OutputResponse", "MR"],
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OutputResponse"],

Cell[TextData[{
  StyleBox["OutputResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OutputResponseIdentify"],

Cell[TextData[{
  "and ",
  StyleBox["ImpulseResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"OutputResponseIdentify"],

Cell[TextData[{
  "Paper machine example",
  ", ",
  "Cholesky factor of controllability Gramian for",
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Paper machine example"],

Cell[TextData[{
  "discrete Lyapunov equation for",
  ", ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Paper machine example"],

Cell[TextData[{
  "discrete Riccati equation for",
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Paper machine example"],

Cell[TextData[{
  "Lyapunov equation for",
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Paper machine example"],

Cell[TextData[{
  StyleBox["PaperMachine", "MR"],
  ", ",
  ButtonBox["ANMA.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Paper machine example"],

Cell[TextData[{
  "system identification for",
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Paper machine example"],

Cell[TextData[{
  StyleBox["PaperMachine", "MR"],
  ", ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PaperMachine"],

Cell[TextData[{
  "Partial Lyapunov shift",
  ", ",
  StyleBox["PartialLyapunovShift", "MR"],
  ", ",
  " ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Partial Lyapunov shift"],

Cell[TextData[{
  "Partial pole assignment",
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Partial pole assignment"],

Cell[TextData[{
  "in state estimator",
  ", ",
  ButtonBox["ANM6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Partial pole assignment"],

Cell[TextData[{
  StyleBox["PartialLyapunovShift", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PartialLyapunovShift"],

Cell[TextData[{
  "in ",
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"PartialLyapunovShift"],

Cell[TextData[{
  "Pencil",
  ", ",
  " ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pencil"],

Cell[TextData[{
  "Persistently exciting input",
  ", ",
  " ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Persistently exciting input"],

Cell[TextData[{
  StyleBox["Pivoting", "MR"],
  ", ",
  "in controller-Hessenberg forms",
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pivoting"],

Cell[TextData[{
  "in observer-Hessenberg forms",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pivoting"],

Cell[TextData[{
  "Pole assignment",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "partial",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "using explicit QR algorithm",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "using implicit QR algorithm",
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "using implicit RQ algorithm",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "using recursive algorithms",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "using Schur method",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "Pole placement",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pole placement"],

Cell[TextData[{
  "partial",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole placement"],

Cell[TextData[{
  "using explicit QR algorithm",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole placement"],

Cell[TextData[{
  "using implicit QR algorithm",
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole placement"],

Cell[TextData[{
  "using implicit RQ algorithm",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole placement"],

Cell[TextData[{
  "using recursive algorithms",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole placement"],

Cell[TextData[{
  "using Schur method",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole placement"],

Cell[TextData[{
  "Poles",
  ", ",
  "and stability, in drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Poles"],

Cell[TextData[{
  "Position control ",
  ", ",
  " ",
  ButtonBox["ANMA.1.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Position control "],

Cell[TextData[{
  StyleBox["PositiveDiagonalCholeskyFactorControllabilityGramian", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PositiveDiagonalCholeskyFactorControllabilityGramian"],

Cell[TextData[{
  StyleBox["PositiveDiagonalCholeskyFactorObservabilityGramian", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PositiveDiagonalCholeskyFactorObservabilityGramian"],

Cell[TextData[{
  "Power plant example",
  ", ",
  StyleBox["TurbineAxle", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Power plant example"],

Cell[TextData[{
  "Power system example",
  ", ",
  StyleBox["PowerSystem", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.12",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Power system example"],

Cell[TextData[{
  StyleBox["PowerSystem", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.12",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PowerSystem"],

Cell[TextData[{
  "Process noise",
  ", ",
  " ",
  ButtonBox["ANMA.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Process noise"],

Cell[TextData[{
  "Projection technique",
  ", ",
  "for partial pole assignment",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Projection technique"],

Cell[TextData[{
  "QR factorization",
  ", ",
  " ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QR factorization"],

Cell[TextData[{
  "QR iteration",
  ", ",
  " ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QR iteration"],

Cell[TextData[{
  StyleBox["QRDecomposition", "MR"],
  ", ",
  "as value of ",
  StyleBox["Method", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QRDecomposition"],

Cell[TextData[{
  "QZ decomposition",
  ", ",
  " ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QZ decomposition"],

Cell[TextData[{
  StyleBox["RealBlockForm", "MR"],
  ", ",
  "in ",
  StyleBox["GeneralizedSchurDecomposition", "MR"],
  ", ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RealBlockForm"],

Cell[TextData[{
  "in ",
  StyleBox["GeneralizedSchurDecompositionOrdered", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"RealBlockForm"],

Cell[TextData[{
  "in ",
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"RealBlockForm"],

Cell[TextData[{
  "Reboiler",
  ", ",
  " ",
  ButtonBox["ANMA.1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Reboiler"],

Cell[TextData[{
  StyleBox["Recursive", "MR"],
  ", ",
  "as value of ",
  StyleBox["Method", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Recursive"],

Cell[TextData[{
  "Recursive bidiagonal method",
  ", ",
  "for pole assignment",
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Recursive bidiagonal method"],

Cell[TextData[{
  "for reduced-order estimatation",
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Recursive bidiagonal method"],

Cell[TextData[{
  "Recursive method",
  ", ",
  "for pole assignment",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Recursive method"],

Cell[TextData[{
  "Recursive triangular method",
  ", ",
  "for reduced-order estimatation",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Recursive triangular method"],

Cell[TextData[{
  StyleBox["RecursiveBidiagonal", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RecursiveBidiagonal"],

Cell[TextData[{
  StyleBox["RecursiveBlockBidiagonal", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RecursiveBlockBidiagonal"],

Cell[TextData[{
  StyleBox["RecursiveBlockTriangular", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RecursiveBlockTriangular"],

Cell[TextData[{
  StyleBox["RecursiveRQDecomposition", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RecursiveRQDecomposition"],

Cell[TextData[{
  StyleBox["RecursiveTriangular", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RecursiveTriangular"],

Cell[TextData[{
  "Reduced-order estimator",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Reduced-order estimator"],

Cell[TextData[{
  "via pole assignment",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Reduced-order estimator"],

Cell[TextData[{
  "via Sylvester-observer equation",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Reduced-order estimator"],

Cell[TextData[{
  StyleBox["ReducedOrderEstimator", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ReducedOrderEstimator"],

Cell[TextData[{
  "and ",
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["ANM6.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ReducedOrderEstimator"],

Cell[TextData[{
  StyleBox["RejectionLevel", "MR"],
  ", ",
  " ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RejectionLevel"],

Cell[TextData[{
  "Residuals",
  ", ",
  "of solution of matrix equations",
  ", ",
  " ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Residuals"],

Cell[TextData[{
  "Resonance frequency",
  ", ",
  "in drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Resonance frequency"],

Cell[TextData[{
  "Riccati equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Riccati equations"],

Cell[TextData[{
  "and Lyapunov equations",
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  StyleBox["DiscreteRiccatiSolve", "MR"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  "generalized eigenvector method for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  "generalized Schur method for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  "inverse-free methods for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  "matrix Sign-function method for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  "Newton method for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  StyleBox["RiccatiSolve", "MR"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  "Schur method for",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Riccati equations"],

Cell[TextData[{
  StyleBox["RiccatiSolve", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RiccatiSolve"],

Cell[TextData[{
  "Risers",
  ", ",
  "in drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Risers"],

Cell[TextData[{
  "Robust stability",
  ", ",
  " ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Robust stability"],

Cell[TextData[{
  "Robustness",
  ", ",
  "of numerical methods",
  ", ",
  " ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Robustness"],

Cell[TextData[{
  "Rotating axle example",
  ", ",
  StyleBox["TurbineAxle", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Rotating axle example"],

Cell[TextData[{
  "RQ decomposition",
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RQ decomposition"],

Cell[TextData[{
  "in recursive method",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"RQ decomposition"],

Cell[TextData[{
  StyleBox["Sampled", "MR"],
  ", ",
  "in ",
  StyleBox["FrequencyResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sampled"],

Cell[TextData[{
  "in ",
  StyleBox["ImpulseResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Sampled"],

Cell[TextData[{
  "in ",
  StyleBox["OutputResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Sampled"],

Cell[TextData[{
  "Schur decomposition",
  ", ",
  "generalized",
  ", ",
  ButtonBox["ANM9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Schur decomposition"],

Cell[TextData[{
  "ordered",
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Schur decomposition"],

Cell[TextData[{
  "Schur method",
  ", ",
  "for Lyapunov equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Schur method"],

Cell[TextData[{
  "for model reduction",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Schur method"],

Cell[TextData[{
  "for pole assignment",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Schur method"],

Cell[TextData[{
  "for Riccati equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Schur method"],

Cell[TextData[{
  StyleBox["SchurDecomposition", "MR"],
  ", ",
  "as value of ",
  StyleBox["Method", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SchurDecomposition"],

Cell[TextData[{
  "as value of ",
  StyleBox["ReductionMethod", "MR"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SchurDecomposition"],

Cell[TextData[{
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SchurDecomposition"],

Cell[TextData[{
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  " ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SchurDecompositionOrdered"],

Cell[TextData[{
  "Separation property",
  ", ",
  " ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Separation property"],

Cell[TextData[{
  StyleBox["ServoJ100", "MR"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.13",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ServoJ100"],

Cell[TextData[{
  "Servomechanism example",
  ", ",
  StyleBox["ServoJ100", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.13",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Servomechanism example"],

Cell[TextData[{
  "Settling time",
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Settling time"],

Cell[TextData[{
  StyleBox["SettlingTimeRegion", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SettlingTimeRegion"],

Cell[TextData[{
  "Sign-function method",
  ", ",
  "for Riccati equations",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sign-function method"],

Cell[TextData[{
  StyleBox["SimulationPlot", "MR"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SimulationPlot"],

Cell[TextData[{
  "of drum boiler",
  ", ",
  ButtonBox["ANM2.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SimulationPlot"],

Cell[TextData[{
  "Singular values",
  ", ",
  "Hankel",
  ", ",
  " ",
  ButtonBox["ANM7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Singular values"],

Cell[TextData[{
  "Smart highway example",
  ", ",
  StyleBox["SmartHighway", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Smart highway example"],

Cell[TextData[{
  StyleBox["SmartHighway", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SmartHighway"],

Cell[TextData[{
  StyleBox["SolveMethod", "MR"],
  ", ",
  "in ",
  StyleBox["LQRRegulatorGains", "MR"],
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SolveMethod"],

Cell[TextData[{
  "Square-root method",
  ", ",
  "for model reduction",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Square-root method"],

Cell[TextData[{
  StyleBox["SquareRoot", "MR"],
  ", ",
  "as value of ",
  StyleBox["Method", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SquareRoot"],

Cell[TextData[{
  "as value of ",
  StyleBox["ReductionMethod", "MR"],
  ", ",
  ButtonBox["ANM7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SquareRoot"],

Cell[TextData[{
  "Stability",
  ", ",
  "of drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stability"],

Cell[TextData[{
  "Stability analysis",
  ", ",
  "using Lyapunov equations",
  ", ",
  " ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stability analysis"],

Cell[TextData[{
  "Stability region",
  ", ",
  " ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stability region"],

Cell[TextData[{
  "Stabilization",
  ", ",
  "by state feedback",
  ", ",
  " ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stabilization"],

Cell[TextData[{
  "Stabilizing solution",
  ", ",
  "of Riccati equations",
  ", ",
  " ",
  ButtonBox["ANM3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stabilizing solution"],

Cell[TextData[{
  "Staircase algorithm",
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Staircase algorithm"],

Cell[TextData[{
  "State estimation",
  ", ",
  ButtonBox["ANM6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State estimation"],

Cell[TextData[{
  "and pole assignment",
  ", ",
  ButtonBox["ANM6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State estimation"],

Cell[TextData[{
  "full-order",
  ", ",
  ButtonBox["ANM6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State estimation"],

Cell[TextData[{
  "reduced-order",
  ", ",
  ButtonBox["ANM6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State estimation"],

Cell[TextData[{
  StyleBox["StateFeedbackConnect", "MR"],
  ", ",
  " ",
  ButtonBox["ANM2.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateFeedbackConnect"],

Cell[TextData[{
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM2.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateFeedbackGains"],

Cell[TextData[{
  "for feedback stabilization",
  ", ",
  ButtonBox["ANM5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateFeedbackGains"],

Cell[TextData[{
  "for partial pole assignment",
  ", ",
  ButtonBox["ANM5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateFeedbackGains"],

Cell[TextData[{
  "Steam flow",
  ", ",
  "in drum boiler",
  ", ",
  ButtonBox["ANM2.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.1.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Steam flow"],

Cell[TextData[{
  "Steam power system example",
  ", ",
  "feedback design for",
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Steam power system example"],

Cell[TextData[{
  "LQ regulator for",
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Steam power system example"],

Cell[TextData[{
  "reduced-order estimator for",
  ", ",
  ButtonBox["ANM6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Steam power system example"],

Cell[TextData[{
  StyleBox["SteamPowerSystem", "MR"],
  ", ",
  ButtonBox["ANMA.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Steam power system example"],

Cell[TextData[{
  "system identification for",
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Steam power system example"],

Cell[TextData[{
  StyleBox["SteamPowerSystem", "MR"],
  ", ",
  ButtonBox["ANM3.2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANMA.2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SteamPowerSystem"],

Cell[TextData[{
  "Strong modes",
  ", ",
  " ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Strong modes"],

Cell[TextData[{
  "Subspace system identification",
  ", ",
  " ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subspace system identification"],

Cell[TextData[{
  "Sylvester equations",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sylvester equations"],

Cell[TextData[{
  "Sylvester-observer equation",
  ", ",
  ButtonBox["ANM6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sylvester-observer equation"],

Cell[TextData[{
  "recursive bidiagonal method for",
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Sylvester-observer equation"],

Cell[TextData[{
  "recursive block diagonal method for",
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Sylvester-observer equation"],

Cell[TextData[{
  "recursive block triangular method for",
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Sylvester-observer equation"],

Cell[TextData[{
  "recursive triangular method for",
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Sylvester-observer equation"],

Cell[TextData[{
  "Symplectic matrix",
  ", ",
  " ",
  ButtonBox["ANM3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Symplectic matrix"],

Cell[TextData[{
  "System identification",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"System identification"],

Cell[TextData[{
  "in frequency domain",
  ", ",
  ButtonBox["ANM8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System identification"],

Cell[TextData[{
  "in time domain",
  ", ",
  ButtonBox["ANM8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System identification"],

Cell[TextData[{
  "using frequency response",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System identification"],

Cell[TextData[{
  "using impulse response",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System identification"],

Cell[TextData[{
  "using input-output data",
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System identification"],

Cell[TextData[{
  "using Markov parameters",
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System identification"],

Cell[TextData[{
  "Tandem-rotor helicopter example",
  ", ",
  " ",
  ButtonBox["ANMA.1.10",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Tandem-rotor helicopter example"],

Cell[TextData[{
  "Time-domain identification",
  ", ",
  " ",
  ButtonBox["ANM8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Time-domain identification"],

Cell[TextData[{
  "Time-domain response",
  ", ",
  "in drum boiler",
  ", ",
  " ",
  ButtonBox["ANM2.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Time-domain response"],

Cell[TextData[{
  StyleBox["ToDiscreteTime", "MR"],
  ", ",
  " ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToDiscreteTime"],

Cell[TextData[{
  StyleBox["Tolerance", "MR"],
  ", ",
  "in ",
  StyleBox["Advanced Numerical Methods",
    FontSlant->"Italic"],
  " functions",
  ", ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Tolerance"],

Cell[TextData[{
  "in ",
  StyleBox["Controllable", "MR"],
  ", ",
  ButtonBox["ANM2.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Tolerance"],

Cell[TextData[{
  "in ",
  StyleBox["ImpulseResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Tolerance"],

Cell[TextData[{
  "in ",
  StyleBox["Observable", "MR"],
  ", ",
  ButtonBox["ANM2.2.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Tolerance"],

Cell[TextData[{
  "in ",
  StyleBox["OutputResponseIdentify", "MR"],
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Tolerance"],

Cell[TextData[{
  "Tubular ammonia reactor example",
  ", ",
  StyleBox["AmmoniaReactor", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Tubular ammonia reactor example"],

Cell[TextData[{
  "Turbine axle example",
  ", ",
  StyleBox["TurbineAxle", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Turbine axle example"],

Cell[TextData[{
  StyleBox["TurbineAxle", "MR"],
  ", ",
  " ",
  ButtonBox["ANMA.1.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TurbineAxle"],

Cell[TextData[{
  "Uncontrollable state",
  ", ",
  "distance from",
  ", ",
  " ",
  ButtonBox["ANM2.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Uncontrollable state"],

Cell[TextData[{
  "Uncontrollable states",
  ", ",
  "and controller-Hessenberg forms",
  ", ",
  " ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Uncontrollable states"],

Cell[TextData[{
  "Uncontrollable system",
  ", ",
  " ",
  ButtonBox["ANM2.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Uncontrollable system"],

Cell[TextData[{
  "Unobservable states",
  ", ",
  "and controller-Hessenberg forms",
  ", ",
  " ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unobservable states"],

Cell[TextData[{
  "Unreduced controller-Hessenberg form",
  ", ",
  " ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unreduced controller-Hessenberg form"],

Cell[TextData[{
  "Unreduced observer-Hessenberg form",
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM6.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unreduced observer-Hessenberg form"],

Cell[TextData[{
  "Upper controller-Hessenberg form",
  ", ",
  StyleBox["ControllerHessenbergForm", "MR"],
  ", ",
  " ",
  ButtonBox["ANM4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Upper controller-Hessenberg form"],

Cell[TextData[{
  "Upper observer-Hessenberg form",
  ", ",
  StyleBox["UpperObserverHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Upper observer-Hessenberg form"],

Cell[TextData[{
  StyleBox["UpperObserverHessenbergForm", "MR"],
  ", ",
  ButtonBox["ANM2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ANM4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UpperObserverHessenbergForm"],

Cell[TextData[{
  "Velocity control",
  ", ",
  " ",
  ButtonBox["ANMA.1.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Velocity control"],

Cell[TextData[{
  "Weak modes",
  ", ",
  " ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Weak modes"],

Cell[TextData[{
  "White noise",
  ", ",
  ButtonBox["ANM8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"White noise"],

Cell[TextData[{
  "Wind disturbances",
  ", ",
  " ",
  ButtonBox["ANMA.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Wind disturbances"],

Cell[TextData[{
  StyleBox["WorkingPrecision", "MR"],
  ", ",
  "in ",
  StyleBox["Advanced Numerical Methods",
    FontSlant->"Italic"],
  " functions",
  ", ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WorkingPrecision"],

Cell[TextData[{
  "in ",
  StyleBox["DiscreteLyapunovSolve", "MR"],
  ", ",
  ButtonBox["ANM1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"WorkingPrecision"],

Cell[TextData[{
  StyleBox["$SamplingPeriod", "MR"],
  ", ",
  " ",
  ButtonBox["ANM8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Advanced Numerical Methods"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$SamplingPeriod"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Scientific Astronomer",
  FontSlant->"Italic"]], "IndexSection",
  CellTags->{
  "Aldebaran", "Algol", "Altitude", "AndromedaGalaxy", "Antares", 
    "ApparentDiameter", "ApparentMagnitude", "apparitions of Mercury", 
    "apparitions of Venus", "Appearance", "Aquarius", 
    "areographic coordinates", "Aries", "Ascension", "AspectChart", 
    "asteroids", "astrology", "Astronomical Unit", "astronomy", 
    "atmospheric refraction", "AU", "AutumnalEquinox", "Azimuth", 
    "Background", "BestView", "Betelgeuse", "Big Dipper", "BirthChart", 
    "BrightClusters", "BrightGalaxies", "BrightNebulae", "bright stars", 
    "Callisto", "Cancer", "CanisMajor", "Capricornus", "Castor", 
    "celestial equator", "Centaurus", "CentralLatitude", "CentralLongitude", 
    "central meridian", "Ceres", "ChartCoordinates", "ChartPosition", 
    "Chinese New Year", "ClusterLabels", "Clusters", "COBE satellite", 
    "Comet Hale-Bopp", "Comet Halley", "comets", "compass direction", 
    "CompassStarChart", "Conjunction", "ConjunctionEvents", 
    "ConstellationLabels", "Constellations", "Coordinates", "Crux", 
    "Culmination", "Date", "dates", "DaylightSaving", "Declination", 
    "DeepSkyMark", "deep sky objects", "diffuse nebulae", "Distance", 
    "double stars", "Duration", "dynamic time (TDT)", "Earth", "EarthShadow", 
    "East", "EclipseBegin", "EclipseEnd", "eclipse predicting", "EclipseQ", 
    "eclipses", "EclipseTrackPlot", "eclipsing variables", "Ecliptic", 
    "EclipticChart", "EclipticCoordinates", "EclipticLatitude", 
    "EclipticLongitude", "Elongation", "Ephemeris", "Epilog", "Epoch", 
    "EquatorCoordinates", "equinox", "Europa", "EveningApparition", 
    "FeatureLabels", "Features", "FindNearestObject", "Fold", "FullMoon", 
    "GalacticCenter", "GalacticPlane", "Galaxies", "GalaxyLabels", 
    "Galilean moons", "Ganymede", "Gemini", "GeoAltitude", 
    "geographic coordinates", "GeoLatitude", "GeoLongitude", "GetLocation", 
    "GetOrbitalElements", "globular clusters", "Great Red Spot", 
    "Greenwich Mean Time", "Gregorian calendar", "Halley's Comet", 
    "Harvest Moon", "heliographic coordinates", "Horizon", 
    "HorizonCoordinates", "Hour", "HourAngle", "HST satellite", "Hyades", 
    "IC", "Index Catalog", "installation", "InterestingObjects", "Io", 
    "Jovian events", "Julian calendar", "Julian day", "Jupiter", 
    "JupiterCoordinates", "JupiterGreatRedSpot", "JupiterMoonChart", 
    "JupiterSystemPlot", "KiloMeter", "LargeMagellanicCloud", "Leo", "Libra", 
    "libration", "LightYear", "loading", "LocalDate", "LocationRing", 
    "LunarEclipse", "lunar eclipses", "lunar occultations", "Lunation", 
    "LunationNumber", "M", "Magellanic Clouds", "MagnitudeRange", 
    "MagnitudeScale", "Mars", "Mars-Venus conjunction", "Mercator projection",
     "Mercury", "meridian", "Mesh", "Messier's catalog", "meteor showers", 
    "MilkyWay", "Mir Space Station", "Mizar", "ModifiedJulianDay", "Moon", 
    "MoonCalendar", "MoonRise", "moons", "MoonSet", "MoonShadow", 
    "MorningApparition", "Nadir", "Nebulae", "NebulaLabels", "Neptune", 
    "New General Catalog", "NewMoon", "NGC", "NORAD", "North", 
    "NorthCelestialPole", "NorthGalacticPole", "notebooks", "objects", 
    "occultations", "open star clusters", "Opposition", 
    "oppositions of Jupiter", "oppositions of Mars", "oppositions of Saturn", 
    "orbital elements", "OrbitMark", "OrbitPlot", "OrbitPlot3D", "OrbitTrack",
     "OrbitTrackPlot", "Orion", "OrionNebula", "OuterPlanetChart", "Palettes",
     "Pallas", "partial eclipses", "penumbra", "PenumbraDiameter", "Phase", 
    "Pisces", "planetary nebulae", "PlanetChart", "PlanetLabels", 
    "planetographic coordinates", "PlanetPlot", "PlanetPlot3D", 
    "planet plotting", "Planets", "Planisphere", "Pleiades", "PlotLabel", 
    "PlotPoints", "PlotRange", "PlotStyle", "Pluto", "Polaris", 
    "poles of Uranus", "Pollux", "PositionAngle", "precession", 
    "prime meridian", "Prolog", "PtolemyChart", "pulsating variables", 
    "RadialAngle", "RadialStarChart", "Refract", "refraction", "Regulus", 
    "retrograde", "right ascension", "rings of Saturn", "RiseSetChart", 
    "RotateLabel", "Sagittarius", "satellites", "satellite tracking", 
    "Saturn", "Scientific Astronomer", "Scorpius", 
    "selenographic coordinates", "Separation", "SetCoordinates", 
    "SetLocation", "SetOrbitalElements", "SetStars", "Shading", 
    "SiderealTime", "Sirius", "site location", "Skyline", 
    "SmallMagellanicCloud", "SolarEclipse", "solar eclipses", 
    "SolarSystemPlot", "solar transits", "South", "SouthCelestialPole", 
    "Southern Cross", "SouthGalacticPole", "Space Shuttle", "spectral color", 
    "Spica", "StarChart", "star charting", "StarColors", "StarLabels", 
    "star names", "StarNames", "star occultations", "Stars", "Stars300", 
    "Stars3000", "Stars9000", "SummerSolstice", "Summer Time", "Sun", 
    "SunRise", "SunSet", "Taurus", "telescopic view", "TheStars", "time", 
    "TimeZone", "TopoCentric", "Totality", "Transit", "transits of Mercury", 
    "transits of Venus", "TransitVisible", "TwoLineElements", 
    "UARS satellite", "umbra", "UmbraDiameter", "Universal Time (UT)", 
    "Uranus", "UrsaMajor", "variable stars", "Vega", "Venus", "VenusChart", 
    "Vernal equinox", "VernalEquinox", "Vesta", "ViewPoint", "ViewVertical", 
    "Virgo", "West", "WinterSolstice", "Zenith", "ZenithStarChart", "zodiac", 
    "$DefaultFontName", "$DefaultFontScale", "$DegreeCharacter", 
    "$JupiterGreatRedSpotLongitude", "$PointSizeScale", "$ThicknessScale"}],

Cell[TextData[{
  StyleBox["Aldebaran",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Aldebaran"],

Cell[TextData[{
  StyleBox["Algol",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.19",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Algol"],

Cell[TextData[{
  StyleBox["Altitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Altitude"],

Cell[TextData[{
  StyleBox["AndromedaGalaxy",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AndromedaGalaxy"],

Cell[TextData[{
  StyleBox["Antares",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Antares"],

Cell[TextData[{
  StyleBox["ApparentDiameter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ApparentDiameter"],

Cell[TextData[{
  StyleBox["ApparentMagnitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ApparentMagnitude"],

Cell[TextData[{
  "apparitions of Mercury, ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"apparitions of Mercury"],

Cell[TextData[{
  "apparitions of Venus, ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.10",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"apparitions of Venus"],

Cell[TextData[{
  StyleBox["Appearance",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Appearance"],

Cell[TextData[{
  StyleBox["Aquarius",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Aquarius"],

Cell[TextData[{
  "areographic coordinates, ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"areographic coordinates"],

Cell[TextData[{
  StyleBox["Aries",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Aries"],

Cell[TextData[{
  StyleBox["Ascension",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ascension"],

Cell[TextData[{
  StyleBox["AspectChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AspectChart"],

Cell[TextData[{
  "asteroids",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"asteroids"],

Cell[TextData[{
  "astrology",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"astrology"],

Cell[TextData[{
  "Astronomical Unit, ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Astronomical Unit"],

Cell[TextData[{
  "astronomy",
  ",",
  " ",
  ButtonBox["Cover",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"astronomy"],

Cell[TextData[{
  "atmospheric refraction",
  ",",
  " ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"atmospheric refraction"],

Cell[TextData[{
  StyleBox["AU",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AU"],

Cell[TextData[{
  StyleBox["AutumnalEquinox",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AutumnalEquinox"],

Cell[TextData[{
  StyleBox["Azimuth",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Azimuth"],

Cell[TextData[{
  StyleBox["Background",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Background"],

Cell[TextData[{
  StyleBox["BestView",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BestView"],

Cell[TextData[{
  StyleBox["Betelgeuse",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Betelgeuse"],

Cell[TextData[{
  "Big Dipper, ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Big Dipper"],

Cell[TextData[{
  StyleBox["BirthChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BirthChart"],

Cell[TextData[{
  "bright stars",
  ",",
  " ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.17",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"bright stars"],

Cell[TextData[{
  StyleBox["BrightClusters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BrightClusters"],

Cell[TextData[{
  StyleBox["BrightGalaxies",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BrightGalaxies"],

Cell[TextData[{
  StyleBox["BrightNebulae",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BrightNebulae"],

Cell[TextData[{
  StyleBox["Callisto",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Callisto"],

Cell[TextData[{
  StyleBox["Cancer",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cancer"],

Cell[TextData[{
  StyleBox["CanisMajor",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CanisMajor"],

Cell[TextData[{
  StyleBox["Capricornus",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Capricornus"],

Cell[TextData[{
  StyleBox["Castor",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Castor"],

Cell[TextData[{
  "celestial equator",
  ",",
  " ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"celestial equator"],

Cell[TextData[{
  "central meridian",
  ",",
  " ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"central meridian"],

Cell[TextData[{
  StyleBox["Centaurus",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Centaurus"],

Cell[TextData[{
  StyleBox["CentralLatitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CentralLatitude"],

Cell[TextData[{
  StyleBox["CentralLongitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CentralLongitude"],

Cell[TextData[{
  StyleBox["Ceres",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ceres"],

Cell[TextData[{
  StyleBox["ChartCoordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ChartCoordinates"],

Cell[TextData[{
  StyleBox["ChartPosition",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ChartPosition"],

Cell[TextData[{
  "Chinese New Year, ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Chinese New Year"],

Cell[TextData[{
  StyleBox["ClusterLabels",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClusterLabels"],

Cell[TextData[{
  StyleBox["Clusters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Clusters"],

Cell[TextData[{
  "COBE satellite",
  ",",
  " ",
  ButtonBox["A.21",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"COBE satellite"],

Cell[TextData[{
  "Comet Halley, ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Comet Halley"],

Cell[TextData[{
  "Comet Hale-Bopp, ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Comet Hale-Bopp"],

Cell[TextData[{
  "comets",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"comets"],

Cell[TextData[{
  "compass direction",
  ",",
  " ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"compass direction"],

Cell[TextData[{
  StyleBox["CompassStarChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CompassStarChart"],

Cell[TextData[{
  StyleBox["Conjunction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Conjunction"],

Cell[TextData[{
  StyleBox["ConjunctionEvents",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ConjunctionEvents"],

Cell[TextData[{
  StyleBox["ConstellationLabels",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ConstellationLabels"],

Cell[TextData[{
  StyleBox["Constellations",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Constellations"],

Cell[TextData[{
  StyleBox["Coordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Coordinates"],

Cell[TextData[{
  StyleBox["Crux",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Crux"],

Cell[TextData[{
  StyleBox["Culmination",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Culmination"],

Cell[TextData[{
  StyleBox["Date",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Date"],

Cell[TextData[{
  "dates",
  ",",
  " ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"dates"],

Cell[TextData[{
  StyleBox["DaylightSaving",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DaylightSaving"],

Cell[TextData[{
  StyleBox["Declination",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Declination"],

Cell[TextData[{
  "deep sky objects",
  ",",
  " ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"deep sky objects"],

Cell[TextData[{
  StyleBox["DeepSkyMark",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DeepSkyMark"],

Cell[TextData[{
  "diffuse nebulae",
  ",",
  " ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"diffuse nebulae"],

Cell[TextData[{
  StyleBox["Distance",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Distance"],

Cell[TextData[{
  "double stars",
  ",",
  " ",
  ButtonBox["8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.18",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"double stars"],

Cell[TextData[{
  StyleBox["Duration",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Duration"],

Cell[TextData[{
  "dynamic time (TDT)",
  ",",
  " ",
  ButtonBox["9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"dynamic time (TDT)"],

Cell[TextData[{
  StyleBox["Earth",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Earth"],

Cell[TextData[{
  StyleBox["EarthShadow",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EarthShadow"],

Cell[TextData[{
  StyleBox["East",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"East"],

Cell[TextData[{
  "eclipse predicting",
  ",",
  " ",
  ButtonBox["6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"eclipse predicting"],

Cell[TextData[{
  StyleBox["EclipseBegin",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipseBegin"],

Cell[TextData[{
  StyleBox["EclipseEnd",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipseEnd"],

Cell[TextData[{
  StyleBox["EclipseQ",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipseQ"],

Cell[TextData[{
  "eclipses",
  ",",
  " ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"eclipses"],

Cell[TextData[{
  StyleBox["EclipseTrackPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipseTrackPlot"],

Cell[TextData[{
  "eclipsing variables",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.19",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"eclipsing variables"],

Cell[TextData[{
  StyleBox["Ecliptic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ecliptic"],

Cell[TextData[{
  StyleBox["EclipticChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipticChart"],

Cell[TextData[{
  StyleBox["EclipticCoordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipticCoordinates"],

Cell[TextData[{
  StyleBox["EclipticLatitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipticLatitude"],

Cell[TextData[{
  StyleBox["EclipticLongitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EclipticLongitude"],

Cell[TextData[{
  StyleBox["Elongation",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Elongation"],

Cell[TextData[{
  StyleBox["Ephemeris",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ephemeris"],

Cell[TextData[{
  StyleBox["Epilog",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Epilog"],

Cell[TextData[{
  StyleBox["Epoch",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Epoch"],

Cell[TextData[{
  StyleBox["EquatorCoordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EquatorCoordinates"],

Cell[TextData[{
  "equinox",
  ",",
  " ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"equinox"],

Cell[TextData[{
  StyleBox["Europa",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Europa"],

Cell[TextData[{
  StyleBox["EveningApparition",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EveningApparition"],

Cell[TextData[{
  StyleBox["FeatureLabels",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FeatureLabels"],

Cell[TextData[{
  StyleBox["Features",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Features"],

Cell[TextData[{
  StyleBox["FindNearestObject",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FindNearestObject"],

Cell[TextData[{
  StyleBox["Fold",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fold"],

Cell[TextData[{
  StyleBox["FullMoon",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FullMoon"],

Cell[TextData[{
  StyleBox["GalacticCenter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GalacticCenter"],

Cell[TextData[{
  StyleBox["GalacticPlane",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GalacticPlane"],

Cell[TextData[{
  StyleBox["Galaxies",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Galaxies"],

Cell[TextData[{
  StyleBox["GalaxyLabels",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GalaxyLabels"],

Cell[TextData[{
  "Galilean moons, ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Galilean moons"],

Cell[TextData[{
  StyleBox["Ganymede",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ganymede"],

Cell[TextData[{
  "geographic coordinates",
  ",",
  " ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"geographic coordinates"],

Cell[TextData[{
  StyleBox["Gemini",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gemini"],

Cell[TextData[{
  StyleBox["GeoAltitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeoAltitude"],

Cell[TextData[{
  StyleBox["GeoLatitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeoLatitude"],

Cell[TextData[{
  StyleBox["GeoLongitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeoLongitude"],

Cell[TextData[{
  StyleBox["GetLocation",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GetLocation"],

Cell[TextData[{
  StyleBox["GetOrbitalElements",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GetOrbitalElements"],

Cell[TextData[{
  "globular clusters",
  ",",
  " ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"globular clusters"],

Cell[TextData[{
  "Great Red Spot, ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Great Red Spot"],

Cell[TextData[{
  "Greenwich Mean Time, ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  ButtonBox["6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Greenwich Mean Time"],

Cell[TextData[{
  "Gregorian calendar, ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gregorian calendar"],

Cell[TextData[{
  "Halley's Comet, ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Halley's Comet"],

Cell[TextData[{
  "Harvest Moon, ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Harvest Moon"],

Cell[TextData[{
  "heliographic coordinates",
  ",",
  " ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"heliographic coordinates"],

Cell[TextData[{
  StyleBox["Horizon",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Horizon"],

Cell[TextData[{
  StyleBox["HorizonCoordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HorizonCoordinates"],

Cell[TextData[{
  StyleBox["Hour",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hour"],

Cell[TextData[{
  StyleBox["HourAngle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HourAngle"],

Cell[TextData[{
  "HST satellite",
  ",",
  " ",
  ButtonBox["7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.21",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HST satellite"],

Cell[TextData[{
  StyleBox["Hyades",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hyades"],

Cell[TextData[{
  StyleBox["IC",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IC"],

Cell[TextData[{
  "Index Catalog, ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Index Catalog"],

Cell[TextData[{
  "installation",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"installation"],

Cell[TextData[{
  StyleBox["InterestingObjects",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InterestingObjects"],

Cell[TextData[{
  StyleBox["Io",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Io"],

Cell[TextData[{
  "Jovian events, ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Jovian events"],

Cell[TextData[{
  "Julian calendar, ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Julian calendar"],

Cell[TextData[{
  "Julian day, ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Julian day"],

Cell[TextData[{
  StyleBox["Jupiter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.12",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Jupiter"],

Cell[TextData[{
  StyleBox["JupiterCoordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JupiterCoordinates"],

Cell[TextData[{
  StyleBox["JupiterGreatRedSpot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JupiterGreatRedSpot"],

Cell[TextData[{
  StyleBox["JupiterMoonChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JupiterMoonChart"],

Cell[TextData[{
  StyleBox["JupiterSystemPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JupiterSystemPlot"],

Cell[TextData[{
  StyleBox["KiloMeter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KiloMeter"],

Cell[TextData[{
  StyleBox["LargeMagellanicCloud",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LargeMagellanicCloud"],

Cell[TextData[{
  StyleBox["Leo",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Leo"],

Cell[TextData[{
  StyleBox["Libra",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Libra"],

Cell[TextData[{
  "libration",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"libration"],

Cell[TextData[{
  StyleBox["LightYear",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LightYear"],

Cell[TextData[{
  "loading",
  ",",
  " ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"loading"],

Cell[TextData[{
  StyleBox["LocalDate",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LocalDate"],

Cell[TextData[{
  StyleBox["LocationRing",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LocationRing"],

Cell[TextData[{
  "lunar eclipses",
  ",",
  " ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"lunar eclipses"],

Cell[TextData[{
  "lunar occultations",
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"lunar occultations"],

Cell[TextData[{
  StyleBox["LunarEclipse",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LunarEclipse"],

Cell[TextData[{
  StyleBox["Lunation",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lunation"],

Cell[TextData[{
  StyleBox["LunationNumber",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LunationNumber"],

Cell[TextData[{
  StyleBox["M",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"M"],

Cell[TextData[{
  "Magellanic Clouds, ",
  ButtonBox["4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Magellanic Clouds"],

Cell[TextData[{
  StyleBox["MagnitudeRange",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MagnitudeRange"],

Cell[TextData[{
  StyleBox["MagnitudeScale",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MagnitudeScale"],

Cell[TextData[{
  StyleBox["Mars",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.11",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mars"],

Cell[TextData[{
  "Mars-Venus conjunction, ",
  ButtonBox["6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mars-Venus conjunction"],

Cell[TextData[{
  "Mercator projection, ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mercator projection"],

Cell[TextData[{
  StyleBox["Mercury",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mercury"],

Cell[TextData[{
  "meridian",
  ",",
  " ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"meridian"],

Cell[TextData[{
  StyleBox["Mesh",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mesh"],

Cell[TextData[{
  "Messier's catalog, ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Messier's catalog"],

Cell[TextData[{
  "meteor showers",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"meteor showers"],

Cell[TextData[{
  StyleBox["MilkyWay",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MilkyWay"],

Cell[TextData[{
  "Mir Space Station, ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.21",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mir Space Station"],

Cell[TextData[{
  StyleBox["Mizar",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.18",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mizar"],

Cell[TextData[{
  StyleBox["ModifiedJulianDay",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ModifiedJulianDay"],

Cell[TextData[{
  StyleBox["Moon",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Moon"],

Cell[TextData[{
  StyleBox["MoonCalendar",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MoonCalendar"],

Cell[TextData[{
  StyleBox["MoonRise",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MoonRise"],

Cell[TextData[{
  "moons",
  ",",
  " ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"moons"],

Cell[TextData[{
  StyleBox["MoonSet",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MoonSet"],

Cell[TextData[{
  StyleBox["MoonShadow",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MoonShadow"],

Cell[TextData[{
  StyleBox["MorningApparition",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MorningApparition"],

Cell[TextData[{
  StyleBox["Nadir",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nadir"],

Cell[TextData[{
  StyleBox["Nebulae",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nebulae"],

Cell[TextData[{
  StyleBox["NebulaLabels",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NebulaLabels"],

Cell[TextData[{
  StyleBox["Neptune",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Neptune"],

Cell[TextData[{
  "New General Catalog, ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"New General Catalog"],

Cell[TextData[{
  StyleBox["NewMoon",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NewMoon"],

Cell[TextData[{
  StyleBox["NGC",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NGC"],

Cell[TextData[{
  "NORAD",
  ",",
  " ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NORAD"],

Cell[TextData[{
  StyleBox["North",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"North"],

Cell[TextData[{
  StyleBox["NorthCelestialPole",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NorthCelestialPole"],

Cell[TextData[{
  StyleBox["NorthGalacticPole",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NorthGalacticPole"],

Cell[TextData[{
  "notebooks",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"notebooks"],

Cell[TextData[{
  "objects",
  ",",
  " ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"objects"],

Cell[TextData[{
  "occultations",
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"occultations"],

Cell[TextData[{
  "open star clusters",
  ",",
  " ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"open star clusters"],

Cell[TextData[{
  StyleBox["Opposition",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Opposition"],

Cell[TextData[{
  "oppositions of Jupiter",
  ",",
  " ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.12",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"oppositions of Jupiter"],

Cell[TextData[{
  "oppositions of Mars",
  ",",
  " ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.11",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"oppositions of Mars"],

Cell[TextData[{
  "oppositions of Saturn",
  ",",
  " ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.13",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"oppositions of Saturn"],

Cell[TextData[{
  "orbital elements",
  ",",
  " ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"orbital elements"],

Cell[TextData[{
  StyleBox["OrbitMark",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrbitMark"],

Cell[TextData[{
  StyleBox["OrbitPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrbitPlot"],

Cell[TextData[{
  StyleBox["OrbitPlot3D",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrbitPlot3D"],

Cell[TextData[{
  StyleBox["OrbitTrack",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrbitTrack"],

Cell[TextData[{
  StyleBox["OrbitTrackPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrbitTrackPlot"],

Cell[TextData[{
  StyleBox["Orion",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Orion"],

Cell[TextData[{
  StyleBox["OrionNebula",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrionNebula"],

Cell[TextData[{
  StyleBox["OuterPlanetChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OuterPlanetChart"],

Cell[TextData[{
  "Palettes",
  ",",
  " ",
  ButtonBox["1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["Windows",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["Macintosh",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["Unix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Palettes"],

Cell[TextData[{
  StyleBox["Pallas",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pallas"],

Cell[TextData[{
  "partial eclipses",
  ",",
  " ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"partial eclipses"],

Cell[TextData[{
  "penumbra",
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"penumbra"],

Cell[TextData[{
  StyleBox["PenumbraDiameter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PenumbraDiameter"],

Cell[TextData[{
  StyleBox["Phase",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Phase"],

Cell[TextData[{
  StyleBox["Pisces",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pisces"],

Cell[TextData[{
  "planet plotting",
  ",",
  " ",
  ButtonBox["5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"planet plotting"],

Cell[TextData[{
  "planetary nebulae",
  ",",
  " ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"planetary nebulae"],

Cell[TextData[{
  StyleBox["PlanetChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlanetChart"],

Cell[TextData[{
  StyleBox["PlanetLabels",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlanetLabels"],

Cell[TextData[{
  "planetographic coordinates",
  ",",
  " ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"planetographic coordinates"],

Cell[TextData[{
  StyleBox["PlanetPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlanetPlot"],

Cell[TextData[{
  StyleBox["PlanetPlot3D",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlanetPlot3D"],

Cell[TextData[{
  StyleBox["Planets",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Planets"],

Cell[TextData[{
  StyleBox["Planisphere",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Planisphere"],

Cell[TextData[{
  StyleBox["Pleiades",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pleiades"],

Cell[TextData[{
  StyleBox["PlotLabel",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlotLabel"],

Cell[TextData[{
  StyleBox["PlotPoints",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlotPoints"],

Cell[TextData[{
  StyleBox["PlotRange",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlotRange"],

Cell[TextData[{
  StyleBox["PlotStyle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlotStyle"],

Cell[TextData[{
  StyleBox["Pluto",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pluto"],

Cell[TextData[{
  StyleBox["Polaris",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polaris"],

Cell[TextData[{
  "poles of Uranus",
  ",",
  " ",
  ButtonBox["A.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"poles of Uranus"],

Cell[TextData[{
  StyleBox["Pollux",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pollux"],

Cell[TextData[{
  StyleBox["PositionAngle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PositionAngle"],

Cell[TextData[{
  "precession",
  ",",
  " ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"precession"],

Cell[TextData[{
  "prime meridian",
  ",",
  " ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"prime meridian"],

Cell[TextData[{
  StyleBox["Prolog",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Prolog"],

Cell[TextData[{
  StyleBox["PtolemyChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PtolemyChart"],

Cell[TextData[{
  "pulsating variables",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.19",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"pulsating variables"],

Cell[TextData[{
  StyleBox["RadialAngle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RadialAngle"],

Cell[TextData[{
  StyleBox["RadialStarChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RadialStarChart"],

Cell[TextData[{
  "refraction",
  ",",
  " ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"refraction"],

Cell[TextData[{
  StyleBox["Refract",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Refract"],

Cell[TextData[{
  StyleBox["Regulus",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Regulus"],

Cell[TextData[{
  "retrograde",
  ",",
  " ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"retrograde"],

Cell[TextData[{
  "right ascension",
  ",",
  " ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"right ascension"],

Cell[TextData[{
  "rings of Saturn",
  ",",
  " ",
  ButtonBox["A.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"rings of Saturn"],

Cell[TextData[{
  StyleBox["RiseSetChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RiseSetChart"],

Cell[TextData[{
  StyleBox["RotateLabel",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RotateLabel"],

Cell[TextData[{
  StyleBox["Sagittarius",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sagittarius"],

Cell[TextData[{
  "satellites",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.21",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"satellites"],

Cell[TextData[{
  "satellite tracking",
  ",",
  " ",
  ButtonBox["7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"satellite tracking"],

Cell[TextData[{
  StyleBox["Saturn",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.13",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Saturn"],

Cell[TextData[{
  StyleBox["Scientific Astronomer",
    FontSlant->"Italic"],
  ", ",
  ButtonBox["Cover",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Scientific Astronomer"],

Cell[TextData[{
  StyleBox["Scorpius",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Scorpius"],

Cell[TextData[{
  "selenographic coordinates",
  ",",
  " ",
  ButtonBox["9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"selenographic coordinates"],

Cell[TextData[{
  StyleBox["Separation",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Separation"],

Cell[TextData[{
  StyleBox["SetCoordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SetCoordinates"],

Cell[TextData[{
  StyleBox["SetLocation",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SetLocation"],

Cell[TextData[{
  StyleBox["SetOrbitalElements",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SetOrbitalElements"],

Cell[TextData[{
  StyleBox["SetStars",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SetStars"],

Cell[TextData[{
  StyleBox["Shading",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Shading"],

Cell[TextData[{
  StyleBox["SiderealTime",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SiderealTime"],

Cell[TextData[{
  StyleBox["Sirius",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sirius"],

Cell[TextData[{
  "site location",
  ",",
  " ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"site location"],

Cell[TextData[{
  StyleBox["Skyline",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Skyline"],

Cell[TextData[{
  StyleBox["SmallMagellanicCloud",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.16",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.22",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SmallMagellanicCloud"],

Cell[TextData[{
  "solar eclipses",
  ",",
  " ",
  ButtonBox["5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.15",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"solar eclipses"],

Cell[TextData[{
  "solar transits",
  ",",
  " ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"solar transits"],

Cell[TextData[{
  StyleBox["SolarEclipse",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SolarEclipse"],

Cell[TextData[{
  StyleBox["SolarSystemPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SolarSystemPlot"],

Cell[TextData[{
  StyleBox["South",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"South"],

Cell[TextData[{
  StyleBox["SouthCelestialPole",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SouthCelestialPole"],

Cell[TextData[{
  "Southern Cross, ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Southern Cross"],

Cell[TextData[{
  StyleBox["SouthGalacticPole",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SouthGalacticPole"],

Cell[TextData[{
  "Space Shuttle, ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.21",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Space Shuttle"],

Cell[TextData[{
  "spectral color",
  ",",
  " ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"spectral color"],

Cell[TextData[{
  StyleBox["Spica",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Spica"],

Cell[TextData[{
  "star charting",
  ",",
  " ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"star charting"],

Cell[TextData[{
  "star names",
  ",",
  " ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.17",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"star names"],

Cell[TextData[{
  "star occultations",
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.14",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"star occultations"],

Cell[TextData[{
  StyleBox["StarChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StarChart"],

Cell[TextData[{
  StyleBox["StarColors",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StarColors"],

Cell[TextData[{
  StyleBox["StarLabels",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StarLabels"],

Cell[TextData[{
  StyleBox["StarNames",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StarNames"],

Cell[TextData[{
  StyleBox["Stars",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stars"],

Cell[TextData[{
  StyleBox["Stars300",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stars300"],

Cell[TextData[{
  StyleBox["Stars3000",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stars3000"],

Cell[TextData[{
  StyleBox["Stars9000",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stars9000"],

Cell[TextData[{
  "Summer Time, ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Summer Time"],

Cell[TextData[{
  StyleBox["SummerSolstice",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SummerSolstice"],

Cell[TextData[{
  StyleBox["Sun",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sun"],

Cell[TextData[{
  StyleBox["SunRise",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SunRise"],

Cell[TextData[{
  StyleBox["SunSet",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->""],

Cell[TextData[{
  "sunspots",
  ",",
  " ",
  ButtonBox["A.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SunSet"],

Cell[TextData[{
  StyleBox["Taurus",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Taurus"],

Cell[TextData[{
  "telescopic view",
  ",",
  " ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"telescopic view"],

Cell[TextData[{
  StyleBox["TheStars",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TheStars"],

Cell[TextData[{
  "time",
  ",",
  " ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"time"],

Cell[TextData[{
  StyleBox["TimeZone",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TimeZone"],

Cell[TextData[{
  StyleBox["TopoCentric",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TopoCentric"],

Cell[TextData[{
  StyleBox["Totality",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Totality"],

Cell[TextData[{
  StyleBox["Transit",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transit"],

Cell[TextData[{
  "transits of Mercury",
  ",",
  " ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"transits of Mercury"],

Cell[TextData[{
  "transits of Venus",
  ",",
  " ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"transits of Venus"],

Cell[TextData[{
  StyleBox["TransitVisible",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TransitVisible"],

Cell[TextData[{
  StyleBox["TwoLineElements",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TwoLineElements"],

Cell[TextData[{
  "UARS satellite",
  ",",
  " ",
  ButtonBox["A.21",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UARS satellite"],

Cell[TextData[{
  "umbra",
  ",",
  " ",
  ButtonBox["6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"umbra"],

Cell[TextData[{
  StyleBox["UmbraDiameter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UmbraDiameter"],

Cell[TextData[{
  "Universal Time (UT), ",
  ButtonBox["8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Universal Time (UT)"],

Cell[TextData[{
  StyleBox["Uranus",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["A.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Uranus"],

Cell[TextData[{
  StyleBox["UrsaMajor",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UrsaMajor"],

Cell[TextData[{
  "variable stars",
  ",",
  " ",
  ButtonBox["1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["A.19",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"variable stars"],

Cell[TextData[{
  StyleBox["Vega",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Vega"],

Cell[TextData[{
  StyleBox["Venus",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.10",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["A.20",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Venus"],

Cell[TextData[{
  StyleBox["VenusChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VenusChart"],

Cell[TextData[{
  "Vernal equinox, ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Vernal equinox"],

Cell[TextData[{
  StyleBox["VernalEquinox",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VernalEquinox"],

Cell[TextData[{
  StyleBox["Vesta",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Vesta"],

Cell[TextData[{
  StyleBox["ViewPoint",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ViewPoint"],

Cell[TextData[{
  StyleBox["ViewVertical",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ViewVertical"],

Cell[TextData[{
  StyleBox["Virgo",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Virgo"],

Cell[TextData[{
  StyleBox["West",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"West"],

Cell[TextData[{
  StyleBox["WinterSolstice",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WinterSolstice"],

Cell[TextData[{
  StyleBox["Zenith",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zenith"],

Cell[TextData[{
  StyleBox["ZenithStarChart",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZenithStarChart"],

Cell[TextData[{
  "zodiac",
  ",",
  " ",
  ButtonBox["2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ",",
  " ",
  ButtonBox["9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"zodiac"],

Cell[TextData[{
  StyleBox["$DefaultFontName",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$DefaultFontName"],

Cell[TextData[{
  StyleBox["$DefaultFontScale",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["4.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$DefaultFontScale"],

Cell[TextData[{
  StyleBox["$DegreeCharacter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$DegreeCharacter"],

Cell[TextData[{
  StyleBox["$JupiterGreatRedSpotLongitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["5.9",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$JupiterGreatRedSpotLongitude"],

Cell[TextData[{
  StyleBox["$PointSizeScale",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$PointSizeScale"],

Cell[TextData[{
  StyleBox["$ThicknessScale",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Scientific Astronomer"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$ThicknessScale"]
}, Closed]],

Cell[CellGroupData[{

Cell["Control System Professional", "IndexSection",
  CellTags->{
  "1/f", "Ackermann", "Ackermann's formula", "Active wrappers", "Actuators", 
    "A/D conversion", "Admissible controls", "Admissible error", 
    "AdmissibleError", "Admissible trajectories", "Ailerons", 
    "Aircraft example", "Algebraic Riccati equation", "All", "Amplifiers", 
    "Analog simulation", "Analog systems", "Analog-to-digital converters", 
    "Analytic", "Angle of attack", "Antenna example", "ARE", 
    "Attitude control", "Azimuth control", "Backward rectangular rule", 
    "BackwardRectangularRule", "BilinearTransform", "Bilinear transformation",
     "Block diagrams", "Bode plot", "BodePlot", "Bridged-T network", 
    "\\[Bullet]", "Calculus`Pade`", "Canonical forms", "Cascade compensation",
     "Cascade connection", "Center of gravity", "Center of mass", 
    "Characteristic equation", "Characteristic polynomial", 
    "Chemical mixture", "Classical control", "Closed loop", 
    "Companion realizations", "Compensator", "Complex exponentials", 
    "Complex numbers", "Complex plane", "ComplexRootProbability", 
    "ComplexVariables", "Composite systems", "Concentration control", 
    "Condition number", "Consistency check", "ConsistentQ", "ContinuousTimeQ",
     "Continuous-time systems", "Continuous-time to discrete-time conversion",
     "Continuous-time vs. discrete-time systems", "Control design", 
    "Control effort", "Control Format palette", "Control input", 
    "ControlInput", "Control inputs", "ControlInputs", "Controllability", 
    "Controllability Gramian", "ControllabilityGramian", 
    "Controllability matrix", "ControllabilityMatrix", "Controllability test",
     "ControllabilityTest", "Controllable", "Controllable canonical form", 
    "ControllableCompanion", "Controllable companion realization", 
    "ControllableSpaceSize", "Controllable states", "Controllable subspace", 
    "ControllableSubsystem", "Controlled signal", "Controller", 
    "Controller design", "Control matrix", "Control objects", "Correlation", 
    "Cost function", "CountInputs", "CountOutputs", "CountStates", 
    "Covariance matrix", "CriticalFrequency", "Critically damped", 
    "Cross-covariance matrix", "Crossover frequency", "Current estimator", 
    "D/A conversion", "Damping ratio", "DARE", "DecompositionMethod", 
    "DefaultInputPort", "Deflection", "Deflection rate", "Delay", 
    "DeleteSubsystem", "Depth control", "Derivative controller", 
    "DeterminantExpansion", "Determinant expansion formula", "Deterministic", 
    "Deterministic inputs", "Differential equations, StateSpace model from", 
    "Digital systems", "Digital-to-analog converters", "DiracDelta", 
    "Dirac delta function", "DirectSolve", "Direct transmission matrix", 
    "DiscreteDelta", "Discrete emulation of continuous design", 
    "DiscreteLQRegulatorGains", "DiscreteLyapunovSolve", 
    "DiscreteRiccatiSolve", "Discrete simulation", "DiscreteTimeQ", 
    "Discrete-time systems", "Discrete-time to continuous-time conversion", 
    "Displacement", "DisplayTogether", "DisplayTogetherGraphicsArray", 
    "Domain identification of control objects", "Dominant subsystem", 
    "DominantSubsystem", "Double integrator", "Dryden Flight Research Center",
     "DualSystem", "Dual systems", "Dynamic systems", 
    "Economized rational approximation", "Effectiveness", 
    "Eigendecomposition", "Eigensystem", "Eigenvalues", "Eigenvectors", 
    "Electrical Engineering Examples", "\\[EmptyUpTriangle]", 
    "EmptyUpTriangle", "Emulation", "EquationForm", "Equilibrium", 
    "Equivalent cost", "Error signal", "Estimator", "EstimatorGains", 
    "Evolution matrix", "Exact", "ExactConversionFunction", 
    "Expanding transfer functions", "ExpandRational", "F-8 aircraft example", 
    "Factoring transfer functions", "FactorRational", "Feedback", 
    "FeedbackConnect", "Feedback connection", "Feedback controller design", 
    "Feedback loop", "Feed-forward path", "Feedthrough matrix", 
    "First-order hold", "FirstOrderHold", "First-order lag", "Flicker noise", 
    "Flight control example", "Forced response", "Forward rectangular rule", 
    "ForwardRectangularRule", "Frames", "Free response", 
    "Frequency prewarping", "Frequency response", 
    "FullRankControllabilityMatrix", "FullRankObservabilityMatrix", 
    "Gain band", "Gain margin", "GainPhaseMargins", "Gaussian distribution", 
    "Gaussian noise", "General rational approximation", "GenericConnect", 
    "Gramian", "GraphicsArray", "Hamiltonian matrix", 
    "Heat exchanger example", "Hold equivalence methods", 
    "Homogeneous response", "Horizon", "ImaginaryToRealRatio", 
    "Imaginary unit,  notation for", "Impulse response", 
    "Infinite-horizon problem", 
    "Infinite\[Hyphen]time\[Hyphen]to\[Hyphen]go problem", "Inflow control", 
    "Inflow rate", "Initial conditions", "InitialConditions", "Input matrix", 
    "Inputs", "InputVariables", "Installation", "Integral controller", 
    "Integrator", "Interconnections", "InternallyBalanced", 
    "InternallyBalancedForm", "Internally balanced realizations", 
    "InterpolatingFunction", "InterpolatingPolynomial", "Interpolation", 
    "Inventory control", "Inventory level", "Inverted pendulum example", 
    "InvertedTransformMatrix", "Irreducible realization", "Iterations", 
    "Jacobian matrix", "Jordan canonical form", "JordanCanonicalForm", 
    "Kalman", "Kalman canonical forms", "KalmanControllableForm", 
    "Kalman decomposition", "Kalman estimator", "KalmanEstimator", 
    "Kalman filter", "Kalman gain matrix", "KalmanObservableForm", 
    "Kautsky-Nichols-Van Dooren algorithm", "KNVD", "Lag system", 
    "Laplace transform", "LaplaceTransform", "Levitation system example", 
    "Linearization", "Linearize", "Linear quadratic Gaussian problem", 
    "Linear quadratic regulator", "LinearSpacing", "LogSpacing", 
    "LQEstimatorGains", "LQG controller", "LQG problem, LQEstimatorGains", 
    "LQOutputRegulatorGains", "LQ regulator", "LQRegulatorGains", 
    "LTI systems", "Lyapunov equations", "Lyapunov function", "LyapunovSolve",
     "Magnetic ball suspension example", "Magnitude response", 
    "MappingFunction", "Margins", "MarginStyle", "MaxIterations", 
    "Measurement noise", "MergeSystems", "Method", "MIMO systems", 
    "Minimal realization", "MinimalRealization", "Minimax approximation", 
    "Minimum-time response", "Missile example", "Mixing tank example", 
    "Modal realization", "Model reduction", "Modern control", 
    "Moment of inertia", "Monic polynomial", "Most likelihood", 
    "Multiple-input, multiple-output (MIMO) systems", 
    "MultipleRootProbability", "Multivariable control", "NASA", 
    "Natural frequency", "Natural response", "NDSolve", "Negative", 
    "Negative feedback", "Nichols plot", "NicholsPlot", "Noise", 
    "Nominal solution", "None", "Nonlinear state-space models", 
    "Nonlinear systems", "Nonpolynomial transfer functions", 
    "NonSingularControllabilityGramian", "NonSingularObservabilityGramian", 
    "Normal distribution", "NormalDistribution", "NullSpace", 
    "Numerical errors", "Numerical integration methods", 
    "NumericalMath`Approximations`", "Nyquist frequency", "Nyquist plot", 
    "NyquistPlot", "Observability", "Observability Gramian", 
    "ObservabilityGramian", "Observability matrix", "ObservabilityMatrix", 
    "Observability test", "ObservabilityTest", "Observable", 
    "Observable canonical form", "ObservableCompanion", 
    "Observable companion realization", "ObservableSpaceSize", 
    "Observable states", "Observable subspace", "ObservableSubsystem", 
    "Observation matrix", "Observer", "Optimal control", "Optimal controller",
     "Optimal estimation", "Ordered Schur decomposition", "Orthogonal basis", 
    "Orthogonal complement", "OrthogonalTransformMatrix", "Outflow control", 
    "Outflow rate", "Output controllability matrix", 
    "OutputControllabilityMatrix", "OutputControllable", "Output matrix", 
    "Output regulator", "Output response", "OutputResponse", "Outputs", 
    "OutputVariables", "Overdamped response", "Overshoot", 
    "Pade approximation", "ParallelConnect", "Parallel connection", 
    "Particular response", "Penalty function", "Pendulum", 
    "Performance criterion", "Performance index", "Period", "Phase band", 
    "Phase margin", "PhaseRange", "Phase response", "Phase unwrapping", 
    "PID controller", "Pivoting", "Plant", "PlotPoints", "PlotSampling", 
    "Pole assignment", "Pole placement", "Poles", "PoleStyle", 
    "PoleZeroCancel", "Pole-zero cancellation", "Polynomial approximations", 
    "Positive", "Positive definite", "Positive feedback", 
    "Positive semidefinite", "Predictor estimator", "Prewarping", 
    "Process noise", "Production and inventory control model", 
    "Production rate", "Proper transfer function", "Proportional controller", 
    "QRDecomposition", "Quadratic cost function", "Ramp response", 
    "RandomOrthogonalComplement", "RandomSystem", "Random systems", "Rank", 
    "Rational polynomial approximations", "Rational polynomials", 
    "RealBlockForm", "Realizations", "RealRootProbability", 
    "Reduced-order model", "ReductionMethod", "Reference signal", "Regulator",
     "RejectionLevel", "Resolvent matrix", "Response", "ResponseVariable", 
    "ReviewForm", "Riccati equations", "RiccatiSolve", 
    "Robust pole assignment", "Roll angle", "Roll attitude control", 
    "Roll rate", "Roll time constant", "Root loci", "RootLocusAnimation", 
    "RootLocusPlot", "RowReduce", "Rudder", "Sampled", "Sampling", 
    "Sampling period", "SamplingPeriod", "Sampling rate", 
    "Satellite attitude control example", "Schur decomposition", 
    "SchurDecomposition", "SchurDecompositionOrdered", "\\[ScriptCapitalS]", 
    "ScriptCapitalS", "\\[ScriptCapitalT]", "ScriptCapitalT", "\\[ScriptK]", 
    "ScriptK", "\\[ScriptS]", "ScriptS", "\\[ScriptT]", "ScriptT", 
    "\\[ScriptU]", "ScriptU", "\\[ScriptX]", "ScriptX", "\\[ScriptY]", 
    "ScriptY", "\\[ScriptZ]", "ScriptZ", "Second-order system", 
    "Second\[Hyphen]order system", "Separation principle", 
    "Serial connection", "Series compensation", "SeriesConnect", 
    "Servo mechanism", "Servo motor", "SetControlFormat", "SetStandardFormat",
     "Sideslip angle", "SimilarityTransform", "Similarity transformation", 
    "Simulation", "SimulationPlot", 
    "Single-input, single-output (SISO) systems", "Singular-value plot", 
    "SingularValuePlot", "SingularValues", "SISO systems", "Solution", 
    "SolveMethod", "Spacecraft", "SpecialPointProbability", "SpecialPoints", 
    "Spectrum", "Stabilizable system", "Stable system", "State equations", 
    "State estimation", "State feedback", "StateFeedbackConnect", 
    "StateFeedbackGains", "State matrix", "State reconstruction", 
    "State response", "StateResponse", "States", "StateSpace", 
    "State-space data structure", "State-space models", 
    "State-space realizations", "State-space systems", "State trajectories", 
    "StateVariables", "Stationary noise", "Steady-state error", 
    "Step response", "Stern plane", "Stochastic", 
    "Strictly proper transfer function", "Submarine", "Subspace", "Subsystem",
     "Suspension system example", "SV plot", "System", "TargetForm", 
    "T-bridge network", "Temperature sensor", "Terminal state error", 
    "Third-order system, step response of", "Time-domain response", 
    "Time-domain simulation", "TimeVariable", "Time-varying systems", 
    "ToContinuousTime", "ToDiscreteTime", "Tolerance", "Torque", 
    "TraditionalForm", "Traditional notations", "TransferFunction", 
    "Transfer function matrix", "Transfer matrix", "Transformation matrix", 
    "TransformationMatrix", "Transient response", "Transient state error", 
    "Transport lag", "Triangle hold", "Tustin transformation", 
    "Uncontrollable states", "Undamped response", "Underdamped response", 
    "Unforced response", "Unobservable", "VerifyPoles", "Weak modes", 
    "Weak subsystem", "Yaw rate", "Zero-input response", "Zero-order hold", 
    "ZeroOrderHold", "ZeroPoleGain", "Zero-pole-gain data structure", 
    "Zero-pole mapping", "ZeroPoleMapping", "Zeros", "Zero-state response", 
    "ZeroStyle", "z-transform", "ZTransform", 
    "$ContinuousTimeComplexPlaneVariable", "$ContinuousTimeToken", 
    "$DiscreteTimeComplexPlaneVariable", "$DiscreteTimeToken ", 
    "$RandomOrthogonalComplement", "$Sampled", "$SamplingPeriod"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`1/f\)]],
  " noise",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"1/f"],

Cell[TextData[{
  StyleBox["Ackermann", "MR"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ackermann"],

Cell[TextData[{
  "robustness of solutions",
  ", ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Ackermann"],

Cell[TextData[{
  "Ackermann's formula",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ackermann's formula"],

Cell[TextData[{
  StyleBox["Ackermann", "MR"],
  ", ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Ackermann's formula"],

Cell[TextData[{
  "Active wrappers",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Active wrappers"],

Cell[TextData[{
  "Actuators",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Actuators"],

Cell[TextData[{
  "A/D conversion",
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"A/D conversion"],

Cell[TextData[{
  "Admissible controls",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Admissible controls"],

Cell[TextData[{
  "Admissible error",
  ", ",
  StyleBox["AdmissibleError", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Admissible error"],

Cell[TextData[{
  "Admissible trajectories",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Admissible trajectories"],

Cell[TextData[{
  StyleBox["AdmissibleError", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AdmissibleError"],

Cell[TextData[{
  "Ailerons",
  ", ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ailerons"],

Cell[TextData[{
  "effectiveness of",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Ailerons"],

Cell[TextData[{
  "of a missile",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Ailerons"],

Cell[TextData[{
  "roll\[Hyphen]time constant of",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Ailerons"],

Cell[TextData[{
  "Aircraft example",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Aircraft example"],

Cell[TextData[{
  "Algebraic Riccati equation",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Algebraic Riccati equation"],

Cell[TextData[{
  "discrete",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Algebraic Riccati equation"],

Cell[TextData[{
  StyleBox["All", "MR"],
  ", ",
  "in ",
  StyleBox["DeleteSubsystem", "MR"],
  ", ",
  ButtonBox["CSP6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"All"],

Cell[TextData[{
  "in ",
  StyleBox["Subsystem", "MR"],
  ", ",
  ButtonBox["CSP6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"All"],

Cell[TextData[{
  "Amplifiers",
  ", ",
  " ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Amplifiers"],

Cell[TextData[{
  "Analog simulation",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Analog simulation"],

Cell[TextData[{
  "Analog systems",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Analog systems"],

Cell[TextData[{
  "Analog-to-digital converters",
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Analog-to-digital converters"],

Cell[TextData[{
  StyleBox["Analytic", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Analytic"],

Cell[TextData[{
  "Angle of attack",
  ", ",
  "of submarine",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Angle of attack"],

Cell[TextData[{
  "Antenna example",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Antenna example"],

Cell[TextData[{
  "discrete estimator for",
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Antenna example"],

Cell[TextData[{
  "Kalman filter for",
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Antenna example"],

Cell[TextData[{
  "ARE",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ARE"],

Cell[TextData[{
  "Attitude control",
  ", ",
  "of satellite",
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Attitude control"],

Cell[TextData[{
  "of spacecraft",
  ", ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Attitude control"],

Cell[TextData[{
  "Azimuth control",
  ", ",
  "of antenna",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Azimuth control"],

Cell[TextData[{
  "Backward rectangular rule",
  ", ",
  StyleBox["BackwardRectangularRule", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Backward rectangular rule"],

Cell[TextData[{
  StyleBox["BackwardRectangularRule", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BackwardRectangularRule"],

Cell[TextData[{
  "Bilinear transformation",
  ", ",
  StyleBox["BilinearTransform", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Bilinear transformation"],

Cell[TextData[{
  StyleBox["BilinearTransform", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BilinearTransform"],

Cell[TextData[{
  "Block diagrams",
  ", ",
  " ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Block diagrams"],

Cell[TextData[{
  "Bode plot",
  ", ",
  StyleBox["BodePlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Bode plot"],

Cell[TextData[{
  StyleBox["BodePlot", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BodePlot"],

Cell[TextData[{
  "collecting several plots in one",
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"BodePlot"],

Cell[TextData[{
  "displaying several objects together",
  ", ",
  ButtonBox["CSP12.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"BodePlot"],

Cell[TextData[{
  "gain and phase margins in",
  ", ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"BodePlot"],

Cell[TextData[{
  "phase unwrapping in",
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"BodePlot"],

Cell[TextData[{
  "Bridged-",
  StyleBox["T",
    FontSlant->"Italic"],
  " network",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Bridged-T network"],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["[Bullet]", "MR"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(\[Bullet]\)\(\ \)\)\)\)], 
    "InlineFormula"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[Bullet]"],

Cell[TextData[{
  StyleBox["Calculus`Pade`", "MR"],
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Calculus`Pade`"],

Cell[TextData[{
  "Canonical forms",
  ", ",
  "controllable",
  ", ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "controllable companion",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "Jordan",
  ", ",
  ButtonBox["CSP8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "Kalman controllable",
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "Kalman observable",
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "modal",
  ", ",
  ButtonBox["CSP8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "observable companion",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Canonical forms"],

Cell[TextData[{
  "Cascade compensation",
  ", ",
  " ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cascade compensation"],

Cell[TextData[{
  "Cascade connection",
  ", ",
  StyleBox["SeriesConnect", "MR"],
  ", ",
  " ",
  ButtonBox["CSP6.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cascade connection"],

Cell[TextData[{
  "Center of gravity",
  ", ",
  "of pendulum",
  ", ",
  " ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Center of gravity"],

Cell[TextData[{
  "Center of mass",
  ", ",
  "of satellite",
  ", ",
  " ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Center of mass"],

Cell[TextData[{
  "Characteristic equation",
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Characteristic equation"],

Cell[TextData[{
  "Characteristic polynomial",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Characteristic polynomial"],

Cell[TextData[{
  "Chemical mixture",
  ", ",
  "control of",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Chemical mixture"],

Cell[TextData[{
  "Classical control",
  ", ",
  " ",
  ButtonBox["CSP5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Classical control"],

Cell[TextData[{
  "Closed loop",
  ", ",
  "construction of",
  ", ",
  " ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Closed loop"],

Cell[TextData[{
  "Companion realizations",
  ", ",
  "controllable",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Companion realizations"],

Cell[TextData[{
  "observable",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Companion realizations"],

Cell[TextData[{
  "Compensator",
  ", ",
  " ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Compensator"],

Cell[TextData[{
  "Complex exponentials",
  ", ",
  "reducing to trigonometric functions",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Complex exponentials"],

Cell[TextData[{
  "Complex numbers",
  ", ",
  "notation for",
  ", ",
  " ",
  ButtonBox["CSP1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Complex numbers"],

Cell[TextData[{
  "Complex plane",
  ", ",
  StyleBox["s",
    FontSlant->"Italic"],
  "- vs. ",
  StyleBox["z",
    FontSlant->"Italic"],
  "-plane",
  ", ",
  " ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Complex plane"],

Cell[TextData[{
  StyleBox["ComplexRootProbability", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ComplexRootProbability"],

Cell[TextData[{
  StyleBox["ComplexVariables", "MR"],
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ComplexVariables"],

Cell[TextData[{
  "Composite systems",
  ", ",
  " ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Composite systems"],

Cell[TextData[{
  "Concentration control",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Concentration control"],

Cell[TextData[{
  "Condition number",
  ", ",
  "of controllability matrix",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Condition number"],

Cell[TextData[{
  "Consistency check",
  ", ",
  StyleBox["ConsistentQ", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Consistency check"],

Cell[TextData[{
  StyleBox["ConsistentQ", "MR"],
  ", ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ConsistentQ"],

Cell[TextData[{
  "Continuous-time systems",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Continuous-time systems"],

Cell[TextData[{
  "Continuous-time to discrete-time conversion",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Continuous-time to discrete-time conversion"],

Cell[TextData[{
  "Continuous-time vs. discrete-time systems",
  ", ",
  " ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Continuous-time vs. discrete-time systems"],

Cell[TextData[{
  StyleBox["ContinuousTimeQ", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ContinuousTimeQ"],

Cell[TextData[{
  "Control design",
  ", ",
  "optimal",
  ", ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Control design"],

Cell[TextData[{
  "using pole assignment",
  ", ",
  ButtonBox["CSP9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Control design"],

Cell[TextData[{
  "Control effort",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Control effort"],

Cell[TextData[{
  "Control Format palette",
  ", ",
  " ",
  ButtonBox["CSP1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Control Format palette"],

Cell[TextData[{
  "Control input",
  ", ",
  "selection in single-input algorithms, ",
  StyleBox["ControlInput", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Control input"],

Cell[TextData[{
  "Control inputs",
  ", ",
  "for time-domain response, ",
  StyleBox["ControlInputs", "MR"],
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Control inputs"],

Cell[TextData[{
  "Control matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Control matrix"],

Cell[TextData[{
  "Control objects",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Control objects"],

Cell[TextData[{
  "constructing from ODEs",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Control objects"],

Cell[TextData[{
  "continuous-time vs. discrete-time",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Control objects"],

Cell[TextData[{
  "converting between",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Control objects"],

Cell[TextData[{
  "default domain of",
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Control objects"],

Cell[TextData[{
  "domain identification of",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Control objects"],

Cell[TextData[{
  "traditional notations for",
  ", ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Control objects"],

Cell[TextData[{
  StyleBox["ControlInput", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControlInput"],

Cell[TextData[{
  StyleBox["ControlInputs", "MR"],
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControlInputs"],

Cell[TextData[{
  "Controllability",
  ", ",
  " ",
  ButtonBox["CSP7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability"],

Cell[TextData[{
  "Controllability Gramian",
  ", ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability Gramian"],

Cell[TextData[{
  StyleBox["ControllabilityGramian", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controllability Gramian"],

Cell[TextData[{
  "Controllability matrix",
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability matrix"],

Cell[TextData[{
  StyleBox["ControllabilityMatrix", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controllability matrix"],

Cell[TextData[{
  "Controllability test",
  ", ",
  StyleBox["Controllable", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability test"],

Cell[TextData[{
  StyleBox["ControllabilityGramian", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllabilityGramian"],

Cell[TextData[{
  StyleBox["ControllabilityMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllabilityMatrix"],

Cell[TextData[{
  StyleBox["ControllabilityTest", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllabilityTest"],

Cell[TextData[{
  StyleBox["Controllable", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllable"],

Cell[TextData[{
  "Controllable canonical form",
  ", ",
  " ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllable canonical form"],

Cell[TextData[{
  "Controllable companion realization",
  ", ",
  StyleBox["ControllableCompanion", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllable companion realization"],

Cell[TextData[{
  "Controllable states",
  ", ",
  " ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllable states"],

Cell[TextData[{
  "Controllable subspace",
  ", ",
  "size of, ",
  StyleBox["ControllableSpaceSize", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllable subspace"],

Cell[TextData[{
  StyleBox["ControllableCompanion", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllableCompanion"],

Cell[TextData[{
  StyleBox["ControllableSpaceSize", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllableSpaceSize"],

Cell[TextData[{
  StyleBox["ControllableSubsystem", "MR"],
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllableSubsystem"],

Cell[TextData[{
  "vs. ",
  StyleBox["KalmanControllableForm", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ControllableSubsystem"],

Cell[TextData[{
  "Controlled signal",
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controlled signal"],

Cell[TextData[{
  "Controller",
  ", ",
  "current",
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controller"],

Cell[TextData[{
  "design of",
  ", ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller"],

Cell[TextData[{
  "in output feedback",
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller"],

Cell[TextData[{
  "in state feedback",
  ", ",
  ButtonBox["CSP6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller"],

Cell[TextData[{
  "optimal",
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Controller"],

Cell[TextData[{
  StyleBox["Controller", "MR"],
  ", ",
  " ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controller"],

Cell[TextData[{
  "Controller design",
  ", ",
  " ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controller design"],

Cell[TextData[{
  "Correlation",
  ", ",
  "between process and measurement noises",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Correlation"],

Cell[TextData[{
  "Cost function",
  ", ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cost function"],

Cell[TextData[{
  "equivalent",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Cost function"],

Cell[TextData[{
  "quadratic",
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Cost function"],

Cell[TextData[{
  StyleBox["CountInputs", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CountInputs"],

Cell[TextData[{
  StyleBox["CountOutputs", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CountOutputs"],

Cell[TextData[{
  StyleBox["CountStates", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CountStates"],

Cell[TextData[{
  "Covariance matrix",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Covariance matrix"],

Cell[TextData[{
  StyleBox["CriticalFrequency", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CriticalFrequency"],

Cell[TextData[{
  "Critically damped",
  ", ",
  " ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Critically damped"],

Cell[TextData[{
  "Cross\[Hyphen]covariance matrix",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cross-covariance matrix"],

Cell[TextData[{
  "Crossover frequency",
  ", ",
  " ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Crossover frequency"],

Cell[TextData[{
  "Current estimator",
  ", ",
  " ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Current estimator"],

Cell[TextData[{
  "D/A conversion",
  ", ",
  " ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"D/A conversion"],

Cell[TextData[{
  "Damping ratio",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Damping ratio"],

Cell[TextData[{
  "of dominant poles",
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Damping ratio"],

Cell[TextData[{
  "of third\[Hyphen]order system",
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Damping ratio"],

Cell[TextData[{
  "DARE",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DARE"],

Cell[TextData[{
  StyleBox["DecompositionMethod", "MR"],
  ", ",
  "in ",
  StyleBox["InternallyBalancedForm", "MR"],
  ", ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DecompositionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["KalmanControllableForm", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"DecompositionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["KalmanObservableForm", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"DecompositionMethod"],

Cell[TextData[{
  StyleBox["DefaultInputPort", "MR"],
  ", ",
  " ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DefaultInputPort"],

Cell[TextData[{
  "Deflection",
  ", ",
  "of ailerons",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Deflection"],

Cell[TextData[{
  "Deflection rate",
  ", ",
  "of ailerons",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Deflection rate"],

Cell[TextData[{
  "Delay",
  ", ",
  ButtonBox["CSP3.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Delay"],

Cell[TextData[{
  "in heat exchanger",
  ", ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Delay"],

Cell[TextData[{
  "Pad\[EAcute] approximation of",
  ", ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Delay"],

Cell[TextData[{
  StyleBox["DeleteSubsystem", "MR"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DeleteSubsystem"],

Cell[TextData[{
  "Depth control",
  ", ",
  "of submarine",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Depth control"],

Cell[TextData[{
  "Derivative controller",
  ", ",
  " ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Derivative controller"],

Cell[TextData[{
  "Determinant expansion formula",
  ", ",
  StyleBox["DeterminantExpansion", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Determinant expansion formula"],

Cell[TextData[{
  StyleBox["DeterminantExpansion", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DeterminantExpansion"],

Cell[TextData[{
  "Deterministic",
  ", ",
  "inputs",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Deterministic"],

Cell[TextData[{
  "state reconstruction",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Deterministic"],

Cell[TextData[{
  "Deterministic inputs",
  ", ",
  " ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Deterministic inputs"],

Cell[TextData[{
  "Differential equations, ",
  StyleBox["StateSpace", "MR"],
  " model from",
  ", ",
  " ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Differential equations, StateSpace model from"],

Cell[TextData[{
  "Digital systems",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Digital systems"],

Cell[TextData[{
  "Digital-to-analog converters",
  ", ",
  " ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Digital-to-analog converters"],

Cell[TextData[{
  "Dirac delta function",
  ", ",
  "approximating in analog simulation",
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dirac delta function"],

Cell[TextData[{
  StyleBox["DiracDelta", "MR"],
  ", in impulse response simulation",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Dirac delta function"],

Cell[TextData[{
  StyleBox["DiracDelta", "MR"],
  ", ",
  "in impulse response simulation",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiracDelta"],

Cell[TextData[{
  "Direct transmission matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Direct transmission matrix"],

Cell[TextData[{
  StyleBox["DirectSolve", "MR"],
  ", ",
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DirectSolve"],

Cell[TextData[{
  "Discrete emulation of continuous design",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete emulation of continuous design"],

Cell[TextData[{
  "Discrete simulation",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete simulation"],

Cell[TextData[{
  "Discrete-time systems",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete-time systems"],

Cell[TextData[{
  "Discrete-time to continuous-time conversion",
  ", ",
  " ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete-time to continuous-time conversion"],

Cell[TextData[{
  StyleBox["DiscreteDelta", "MR"],
  ", ",
  "in impulse response simulation",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteDelta"],

Cell[TextData[{
  StyleBox["DiscreteLQRegulatorGains", "MR"],
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteLQRegulatorGains"],

Cell[TextData[{
  StyleBox["DiscreteLyapunovSolve", "MR"],
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteLyapunovSolve"],

Cell[TextData[{
  StyleBox["DiscreteRiccatiSolve", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteRiccatiSolve"],

Cell[TextData[{
  StyleBox["DiscreteTimeQ", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteTimeQ"],

Cell[TextData[{
  "Displacement",
  ", ",
  "of pendulum",
  ", ",
  " ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Displacement"],

Cell[TextData[{
  StyleBox["DisplayTogether", "MR"],
  ", ",
  "vs. ",
  StyleBox["DisplayTogetherGraphicsArray", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DisplayTogether"],

Cell[TextData[{
  StyleBox["DisplayTogetherGraphicsArray", "MR"],
  ", ",
  ButtonBox["CSP12.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DisplayTogetherGraphicsArray"],

Cell[TextData[{
  "Domain identification of control objects",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Domain identification of control objects"],

Cell[TextData[{
  "Dominant subsystem",
  ", ",
  StyleBox["DominantSubsystem", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dominant subsystem"],

Cell[TextData[{
  StyleBox["DominantSubsystem", "MR"],
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DominantSubsystem"],

Cell[TextData[{
  "Double integrator",
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Double integrator"],

Cell[TextData[{
  "PID controller for",
  ", ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Double integrator"],

Cell[TextData[{
  "Dryden Flight Research Center",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dryden Flight Research Center"],

Cell[TextData[{
  "Dual systems",
  ", ",
  StyleBox["DualSystem", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dual systems"],

Cell[TextData[{
  StyleBox["DualSystem", "MR"],
  ", ",
  ButtonBox["CSP7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DualSystem"],

Cell[TextData[{
  "Dynamic systems",
  ", ",
  " ",
  ButtonBox["CSP3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dynamic systems"],

Cell[TextData[{
  "Economized rational approximation",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Economized rational approximation"],

Cell[TextData[{
  "Effectiveness",
  ", ",
  "of ailerons",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Effectiveness"],

Cell[TextData[{
  StyleBox["Eigendecomposition", "MR"],
  ", ",
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Eigendecomposition"],

Cell[TextData[{
  StyleBox["Eigensystem", "MR"],
  ", ",
  "as value of ",
  StyleBox["DecompositionMethod", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Eigensystem"],

Cell[TextData[{
  "Eigenvalues",
  ", ",
  "and poles",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Eigenvalues"],

Cell[TextData[{
  "in ",
  StyleBox["SchurDecomposition", "MR"],
  ", ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Eigenvalues"],

Cell[TextData[{
  "multiple",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Eigenvalues"],

Cell[TextData[{
  "of closed-loop system",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Eigenvalues"],

Cell[TextData[{
  "of Hamiltonian matrix",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Eigenvalues"],

Cell[TextData[{
  "specifying order of",
  ", ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Eigenvalues"],

Cell[TextData[{
  "Eigenvectors",
  ", ",
  " ",
  ButtonBox["CSP8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Eigenvectors"],

Cell[TextData[{
  StyleBox["Electrical Engineering", "TI"],
  " ",
  StyleBox["Examples",
    FontSlant->"Italic"],
  ", ",
  "plotting routines from",
  ", ",
  " ",
  ButtonBox["CSP5.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Electrical Engineering Examples"],

Cell[TextData[{
  "Emulation",
  ", ",
  "of continuous design",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Emulation"],

Cell[TextData[{
  StyleBox["EquationForm", "MR"],
  ", ",
  ButtonBox["CSP1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EquationForm"],

Cell[TextData[{
  "Equilibrium",
  ", ",
  "of magnetic ball",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Equilibrium"],

Cell[TextData[{
  "of pendulum",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Equilibrium"],

Cell[TextData[{
  "Equivalent cost",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Equivalent cost"],

Cell[TextData[{
  "Error signal",
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Error signal"],

Cell[TextData[{
  "Estimator",
  ", ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Estimator"],

Cell[TextData[{
  "current",
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Estimator"],

Cell[TextData[{
  "discrete by emulation of continuous",
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Estimator"],

Cell[TextData[{
  "gain matrix for, ",
  StyleBox["EstimatorGains", "MR"],
  ", ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Estimator"],

Cell[TextData[{
  "Kalman",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Estimator"],

Cell[TextData[{
  "optimal",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Estimator"],

Cell[TextData[{
  "predictor",
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Estimator"],

Cell[TextData[{
  StyleBox["EstimatorGains", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EstimatorGains"],

Cell[TextData[{
  "Evolution matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Evolution matrix"],

Cell[TextData[{
  StyleBox["Exact", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Exact"],

Cell[TextData[{
  StyleBox["ExactConversionFunction", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ExactConversionFunction"],

Cell[TextData[{
  "Expanding transfer functions",
  ", ",
  StyleBox["ExpandRational", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Expanding transfer functions"],

Cell[TextData[{
  StyleBox["ExpandRational", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ExpandRational"],

Cell[TextData[{
  "F\[Hyphen]8 aircraft example",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"F-8 aircraft example"],

Cell[TextData[{
  "Factoring transfer functions",
  ", ",
  StyleBox["FactorRational", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Factoring transfer functions"],

Cell[TextData[{
  StyleBox["FactorRational", "MR"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FactorRational"],

Cell[TextData[{
  "pole-zero cancellation in",
  ", ",
  ButtonBox["CSP8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"FactorRational"],

Cell[TextData[{
  "Feed\[Hyphen]forward path",
  ", ",
  " ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feed-forward path"],

Cell[TextData[{
  "Feedback",
  ", ",
  "negative",
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feedback"],

Cell[TextData[{
  "path",
  ", ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Feedback"],

Cell[TextData[{
  "positive",
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Feedback"],

Cell[TextData[{
  "Feedback connection",
  ", ",
  StyleBox["FeedbackConnect", "MR"],
  ", ",
  " ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feedback connection"],

Cell[TextData[{
  "Feedback controller design",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feedback controller design"],

Cell[TextData[{
  "using Lyapunov's method",
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Feedback controller design"],

Cell[TextData[{
  "Feedback loop",
  ", ",
  "forming with ",
  StyleBox["FeedbackConnect", "MR"],
  ", ",
  " ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feedback loop"],

Cell[TextData[{
  StyleBox["FeedbackConnect", "MR"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FeedbackConnect"],

Cell[TextData[{
  "Feedthrough matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Feedthrough matrix"],

Cell[TextData[{
  "First-order hold",
  ", ",
  StyleBox["FirstOrderHold", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"First-order hold"],

Cell[TextData[{
  "First\[Hyphen]order lag",
  ", ",
  " ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"First-order lag"],

Cell[TextData[{
  StyleBox["FirstOrderHold", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FirstOrderHold"],

Cell[TextData[{
  "Flicker noise",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Flicker noise"],

Cell[TextData[{
  "Flight control example",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Flight control example"],

Cell[TextData[{
  "Forced response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Forced response"],

Cell[TextData[{
  "Forward rectangular rule",
  ", ",
  StyleBox["ForwardRectangularRule", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Forward rectangular rule"],

Cell[TextData[{
  StyleBox["ForwardRectangularRule", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ForwardRectangularRule"],

Cell[TextData[{
  StyleBox["Frames", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Frames"],

Cell[TextData[{
  "Free response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Free response"],

Cell[TextData[{
  "Frequency prewarping",
  ", ",
  StyleBox["CriticalFrequency", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Frequency prewarping"],

Cell[TextData[{
  "Frequency response",
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Frequency response"],

Cell[TextData[{
  StyleBox["FullRankControllabilityMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FullRankControllabilityMatrix"],

Cell[TextData[{
  StyleBox["FullRankObservabilityMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FullRankObservabilityMatrix"],

Cell[TextData[{
  "Gain band",
  ", ",
  " ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gain band"],

Cell[TextData[{
  "Gain margin",
  ", ",
  StyleBox["GainPhaseMargins", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gain margin"],

Cell[TextData[{
  StyleBox["GainPhaseMargins", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GainPhaseMargins"],

Cell[TextData[{
  "Gaussian distribution",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gaussian distribution"],

Cell[TextData[{
  StyleBox["NormalDistribution", "MR"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Gaussian distribution"],

Cell[TextData[{
  "Gaussian noise",
  ", ",
  " ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gaussian noise"],

Cell[TextData[{
  "General rational approximation",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"General rational approximation"],

Cell[TextData[{
  StyleBox["GenericConnect", "MR"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GenericConnect"],

Cell[TextData[{
  "Gramian",
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gramian"],

Cell[TextData[{
  StyleBox["GraphicsArray", "MR"],
  ", ",
  "displaying several objects together",
  ", ",
  " ",
  ButtonBox["CSP12.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphicsArray"],

Cell[TextData[{
  "Hamiltonian matrix",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hamiltonian matrix"],

Cell[TextData[{
  "Heat exchanger example",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Heat exchanger example"],

Cell[TextData[{
  "Hold equivalence methods",
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hold equivalence methods"],

Cell[TextData[{
  "Homogeneous response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Homogeneous response"],

Cell[TextData[{
  "Horizon",
  ", ",
  "infinite",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Horizon"],

Cell[TextData[{
  "Imaginary unit,  notation for",
  ", ",
  " ",
  ButtonBox["CSP1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Imaginary unit,  notation for"],

Cell[TextData[{
  StyleBox["ImaginaryToRealRatio", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImaginaryToRealRatio"],

Cell[TextData[{
  "Impulse response",
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Impulse response"],

Cell[TextData[{
  "simulating with ",
  StyleBox["DiracDelta", "MR"],
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Impulse response"],

Cell[TextData[{
  "simulating with ",
  StyleBox["DiscreteDelta", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Impulse response"],

Cell[TextData[{
  "simulation of",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Impulse response"],

Cell[TextData[{
  "Infinite\[Hyphen]horizon problem",
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Infinite-horizon problem"],

Cell[TextData[{
  "Infinite\[Hyphen]time\[Hyphen]to\[Hyphen]go problem",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Infinite\[Hyphen]time\[Hyphen]to\[Hyphen]go problem"],

Cell[TextData[{
  "Inflow control",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inflow control"],

Cell[TextData[{
  "Inflow rate",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inflow rate"],

Cell[TextData[{
  "Initial conditions",
  ", ",
  StyleBox["InitialConditions", "MR"],
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Initial conditions"],

Cell[TextData[{
  StyleBox["InitialConditions", "MR"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialConditions"],

Cell[TextData[{
  "Input matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Input matrix"],

Cell[TextData[{
  "Inputs",
  ", ",
  "count of",
  ", ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inputs"],

Cell[TextData[{
  "deterministic",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Inputs"],

Cell[TextData[{
  "stochastic",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Inputs"],

Cell[TextData[{
  StyleBox["InputVariables", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InputVariables"],

Cell[TextData[{
  "Installation",
  ", ",
  " ",
  ButtonBox["CSP1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Installation"],

Cell[TextData[{
  "Integral controller",
  ", ",
  " ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Integral controller"],

Cell[TextData[{
  "Integrator",
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Integrator"],

Cell[TextData[{
  "Interconnections",
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Interconnections"],

Cell[TextData[{
  "arbitrary",
  ", ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Interconnections"],

Cell[TextData[{
  "elementary",
  ", ",
  ButtonBox["CSP6.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Interconnections"],

Cell[TextData[{
  "Internally balanced realizations",
  ", ",
  StyleBox["InternallyBalancedForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Internally balanced realizations"],

Cell[TextData[{
  StyleBox["InternallyBalanced", "MR"],
  ", ",
  " ",
  ButtonBox["CSP0.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InternallyBalanced"],

Cell[TextData[{
  StyleBox["InternallyBalancedForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InternallyBalancedForm"],

Cell[TextData[{
  StyleBox["InterpolatingFunction", "MR"],
  ", ",
  "in time-domain simulations",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InterpolatingFunction"],

Cell[TextData[{
  StyleBox["InterpolatingPolynomial", "MR"],
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InterpolatingPolynomial"],

Cell[TextData[{
  StyleBox["Interpolation", "MR"],
  ", ",
  "as value of ",
  StyleBox["GainPhaseMargins", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Interpolation"],

Cell[TextData[{
  "Inventory control",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inventory control"],

Cell[TextData[{
  "Inventory level",
  ", ",
  "control of",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inventory level"],

Cell[TextData[{
  "Inverted pendulum example",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverted pendulum example"],

Cell[TextData[{
  "controller for",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Inverted pendulum example"],

Cell[TextData[{
  "optimal controller for",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Inverted pendulum example"],

Cell[TextData[{
  StyleBox["InvertedTransformMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InvertedTransformMatrix"],

Cell[TextData[{
  "Irreducible realization",
  ", ",
  StyleBox["MinimalRealization", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Irreducible realization"],

Cell[TextData[{
  StyleBox["Iterations", "MR"],
  ", ",
  " ",
  ButtonBox["CSP0.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Iterations"],

Cell[TextData[{
  "Jacobian matrix",
  ", ",
  " ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Jacobian matrix"],

Cell[TextData[{
  "Jordan canonical form",
  ", ",
  StyleBox["JordanCanonicalForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Jordan canonical form"],

Cell[TextData[{
  StyleBox["JordanCanonicalForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JordanCanonicalForm"],

Cell[TextData[{
  StyleBox["Kalman", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman"],

Cell[TextData[{
  "Kalman canonical forms",
  ", ",
  " ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman canonical forms"],

Cell[TextData[{
  "Kalman decomposition",
  ", ",
  StyleBox["Kalman", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman decomposition"],

Cell[TextData[{
  "Kalman estimator",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman estimator"],

Cell[TextData[{
  StyleBox["KalmanEstimator", "MR"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Kalman estimator"],

Cell[TextData[{
  "Kalman filter",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman filter"],

Cell[TextData[{
  "example of",
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Kalman filter"],

Cell[TextData[{
  "Kalman gain matrix",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kalman gain matrix"],

Cell[TextData[{
  StyleBox["KalmanControllableForm", "MR"],
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KalmanControllableForm"],

Cell[TextData[{
  StyleBox["KalmanEstimator", "MR"],
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KalmanEstimator"],

Cell[TextData[{
  StyleBox["KalmanObservableForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KalmanObservableForm"],

Cell[TextData[{
  "Kautsky-Nichols-Van Dooren algorithm",
  ", ",
  StyleBox["KNVD", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kautsky-Nichols-Van Dooren algorithm"],

Cell[TextData[{
  StyleBox["KNVD", "MR"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KNVD"],

Cell[TextData[{
  "Lag system",
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lag system"],

Cell[TextData[{
  "Laplace transform",
  ", ",
  StyleBox["LaplaceTransform", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Laplace transform"],

Cell[TextData[{
  StyleBox["LaplaceTransform", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LaplaceTransform"],

Cell[TextData[{
  "Levitation system example",
  ", ",
  " ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Levitation system example"],

Cell[TextData[{
  "Linear quadratic Gaussian problem",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linear quadratic Gaussian problem"],

Cell[TextData[{
  "Linear quadratic regulator",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linear quadratic regulator"],

Cell[TextData[{
  StyleBox["LQRegulatorGains", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Linear quadratic regulator"],

Cell[TextData[{
  "Linearization",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linearization"],

Cell[TextData[{
  StyleBox["Linearize", "MR"],
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Linearization"],

Cell[TextData[{
  StyleBox["Linearize", "MR"],
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linearize"],

Cell[TextData[{
  StyleBox["LinearSpacing", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearSpacing"],

Cell[TextData[{
  StyleBox["LogSpacing", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LogSpacing"],

Cell[TextData[{
  "LQ regulator",
  ", ",
  " ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQ regulator"],

Cell[TextData[{
  StyleBox["LQEstimatorGains", "MR"],
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQEstimatorGains"],

Cell[TextData[{
  "LQG controller",
  ", ",
  StyleBox["Controller", "MR"],
  ", ",
  " ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQG controller"],

Cell[TextData[{
  "LQG problem, ",
  StyleBox["LQEstimatorGains", "MR"],
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQG problem, LQEstimatorGains"],

Cell[TextData[{
  StyleBox["LQOutputRegulatorGains", "MR"],
  ", ",
  " ",
  ButtonBox["CSP10.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQOutputRegulatorGains"],

Cell[TextData[{
  StyleBox["LQRegulatorGains", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQRegulatorGains"],

Cell[TextData[{
  "vs. ",
  StyleBox["DiscreteLQRegulatorGains", "MR"],
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"LQRegulatorGains"],

Cell[TextData[{
  "vs. ",
  StyleBox["LQOutputRegulatorGains", "MR"],
  ", ",
  ButtonBox["CSP10.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"LQRegulatorGains"],

Cell[TextData[{
  "LTI systems",
  ", ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LTI systems"],

Cell[TextData[{
  "Lyapunov equations",
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "continuous",
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "discrete",
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "for controllability and observability Gramians",
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Lyapunov equations"],

Cell[TextData[{
  "Lyapunov function",
  ", ",
  " ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lyapunov function"],

Cell[TextData[{
  StyleBox["LyapunovSolve", "MR"],
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LyapunovSolve"],

Cell[TextData[{
  "Magnetic ball suspension example",
  ", ",
  " ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Magnetic ball suspension example"],

Cell[TextData[{
  "Magnitude response",
  ", ",
  " ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Magnitude response"],

Cell[TextData[{
  StyleBox["MappingFunction", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MappingFunction"],

Cell[TextData[{
  StyleBox["Margins", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Margins"],

Cell[TextData[{
  StyleBox["MarginStyle", "MR"],
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MarginStyle"],

Cell[TextData[{
  StyleBox["MaxIterations", "MR"],
  ", ",
  "in ",
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaxIterations"],

Cell[TextData[{
  "Measurement noise",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Measurement noise"],

Cell[TextData[{
  StyleBox["MergeSystems", "MR"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MergeSystems"],

Cell[TextData[{
  StyleBox["Method", "MR"],
  ", ",
  "in ",
  StyleBox["Rank", "MR"],
  ", ",
  ButtonBox["CSP12.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Method"],

Cell[TextData[{
  "in ",
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Method"],

Cell[TextData[{
  "in ",
  StyleBox["ToContinuousTime", "MR"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Method"],

Cell[TextData[{
  "in ",
  StyleBox["ToDiscreteTime", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Method"],

Cell[TextData[{
  "MIMO systems",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MIMO systems"],

Cell[TextData[{
  "frequency response of",
  ", ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MIMO systems"],

Cell[TextData[{
  "Minimal realization",
  ", ",
  StyleBox["MinimalRealization", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Minimal realization"],

Cell[TextData[{
  StyleBox["MinimalRealization", "MR"],
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MinimalRealization"],

Cell[TextData[{
  "Minimax approximation",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Minimax approximation"],

Cell[TextData[{
  "Minimum\[Hyphen]time response",
  ", ",
  " ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Minimum-time response"],

Cell[TextData[{
  "Missile example",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Missile example"],

Cell[TextData[{
  "Mixing tank example",
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mixing tank example"],

Cell[TextData[{
  "controllability Gramian of",
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mixing tank example"],

Cell[TextData[{
  "LQ regulator for",
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mixing tank example"],

Cell[TextData[{
  "output regulator for",
  ", ",
  ButtonBox["CSP10.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mixing tank example"],

Cell[TextData[{
  "singular value plot for",
  ", ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mixing tank example"],

Cell[TextData[{
  "Modal realization",
  ", ",
  StyleBox["JordanCanonicalForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Modal realization"],

Cell[TextData[{
  "Model reduction",
  ", ",
  StyleBox["DominantSubsystem", "MR"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Model reduction"],

Cell[TextData[{
  StyleBox["MinimalRealization", "MR"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Model reduction"],

Cell[TextData[{
  StyleBox["PoleZeroCancel", "MR"],
  ", ",
  ButtonBox["CSP8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Model reduction"],

Cell[TextData[{
  "Modern control",
  ", ",
  " ",
  ButtonBox["CSP3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Modern control"],

Cell[TextData[{
  "Moment of inertia",
  ", ",
  "of pendulum",
  ", ",
  " ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Moment of inertia"],

Cell[TextData[{
  "Monic polynomial",
  ", ",
  " ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Monic polynomial"],

Cell[TextData[{
  "Most likelihood",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Most likelihood"],

Cell[TextData[{
  "Multiple-input, multiple-output (MIMO) systems",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multiple-input, multiple-output (MIMO) systems"],

Cell[TextData[{
  "minimal realization of",
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Multiple-input, multiple-output (MIMO) systems"],

Cell[TextData[{
  StyleBox["MultipleRootProbability", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultipleRootProbability"],

Cell[TextData[{
  "Multivariable control",
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multivariable control"],

Cell[TextData[{
  "NASA",
  ", ",
  "Dryden Flight Research Center",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NASA"],

Cell[TextData[{
  "Natural frequency",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Natural frequency"],

Cell[TextData[{
  "of third\[Hyphen]order system",
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Natural frequency"],

Cell[TextData[{
  "Natural response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Natural response"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  ", ",
  "in time-domain simulations",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NDSolve"],

Cell[TextData[{
  StyleBox["Negative", "MR"],
  ", ",
  "in ",
  StyleBox["FeedbackConnect", "MR"],
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Negative"],

Cell[TextData[{
  "in ",
  StyleBox["GenericConnect", "MR"],
  ", ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Negative"],

Cell[TextData[{
  "Negative feedback",
  ", ",
  " ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Negative feedback"],

Cell[TextData[{
  "Nichols plot",
  ", ",
  StyleBox["NicholsPlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nichols plot"],

Cell[TextData[{
  StyleBox["NicholsPlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NicholsPlot"],

Cell[TextData[{
  "Noise",
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1/f\)]],
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Noise"],

Cell[TextData[{
  "additive",
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "covariance matrix of",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "Gaussian",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "high-frequency cutoff of",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "measurement",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "process",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "spectrum of",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "stationary",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "white",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Noise"],

Cell[TextData[{
  "Nominal solution",
  ", ",
  " ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nominal solution"],

Cell[TextData[{
  StyleBox["None", "MR"],
  ", ",
  "in ",
  StyleBox["DeleteSubsystem", "MR"],
  ", ",
  ButtonBox["CSP6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"None"],

Cell[TextData[{
  "in ",
  StyleBox["Subsystem", "MR"],
  ", ",
  ButtonBox["CSP6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"None"],

Cell[TextData[{
  "Nonlinear state-space models",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nonlinear state-space models"],

Cell[TextData[{
  "linearization of",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Nonlinear state-space models"],

Cell[TextData[{
  "simulation of",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Nonlinear state-space models"],

Cell[TextData[{
  "Nonlinear systems",
  ", ",
  ButtonBox["CSP11.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nonlinear systems"],

Cell[TextData[{
  "local linearization of",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Nonlinear systems"],

Cell[TextData[{
  "rational polynomial approximations for",
  ", ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Nonlinear systems"],

Cell[TextData[{
  "Nonpolynomial transfer functions",
  ", ",
  " ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nonpolynomial transfer functions"],

Cell[TextData[{
  StyleBox["NonSingularControllabilityGramian", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NonSingularControllabilityGramian"],

Cell[TextData[{
  StyleBox["NonSingularObservabilityGramian", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NonSingularObservabilityGramian"],

Cell[TextData[{
  "Normal distribution",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Normal distribution"],

Cell[TextData[{
  StyleBox["NormalDistribution", "MR"],
  ", ",
  "in simulations",
  ", ",
  " ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NormalDistribution"],

Cell[TextData[{
  StyleBox["NullSpace", "MR"],
  ", ",
  "as value of ",
  StyleBox["DecompositionMethod", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NullSpace"],

Cell[TextData[{
  "in ",
  StyleBox["Rank", "MR"],
  ", ",
  ButtonBox["CSP12.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"NullSpace"],

Cell[TextData[{
  "Numerical errors",
  ", ",
  "control of",
  ", ",
  " ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Numerical errors"],

Cell[TextData[{
  "Numerical integration methods",
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Numerical integration methods"],

Cell[TextData[{
  StyleBox["NumericalMath`Approximations`", "MR"],
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NumericalMath`Approximations`"],

Cell[TextData[{
  "Nyquist frequency",
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nyquist frequency"],

Cell[TextData[{
  "Nyquist plot",
  ", ",
  StyleBox["NyquistPlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nyquist plot"],

Cell[TextData[{
  StyleBox["NyquistPlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NyquistPlot"],

Cell[TextData[{
  "Observability",
  ", ",
  " ",
  ButtonBox["CSP7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability"],

Cell[TextData[{
  "Observability Gramian",
  ", ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability Gramian"],

Cell[TextData[{
  StyleBox["ObservabilityGramian", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observability Gramian"],

Cell[TextData[{
  "Observability matrix",
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability matrix"],

Cell[TextData[{
  StyleBox["ObservabilityMatrix", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observability matrix"],

Cell[TextData[{
  "Observability test",
  ", ",
  StyleBox["Observable", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability test"],

Cell[TextData[{
  StyleBox["ObservabilityGramian", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservabilityGramian"],

Cell[TextData[{
  StyleBox["ObservabilityMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservabilityMatrix"],

Cell[TextData[{
  StyleBox["ObservabilityTest", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservabilityTest"],

Cell[TextData[{
  StyleBox["Observable", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observable"],

Cell[TextData[{
  "Observable canonical form",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observable canonical form"],

Cell[TextData[{
  "Observable companion realization",
  ", ",
  StyleBox["ObservableCompanion", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observable companion realization"],

Cell[TextData[{
  "Observable states",
  ", ",
  " ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observable states"],

Cell[TextData[{
  "Observable subspace",
  ", ",
  "size of, ",
  StyleBox["ObservableSpaceSize", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observable subspace"],

Cell[TextData[{
  StyleBox["ObservableCompanion", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservableCompanion"],

Cell[TextData[{
  StyleBox["ObservableSpaceSize", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservableSpaceSize"],

Cell[TextData[{
  StyleBox["ObservableSubsystem", "MR"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservableSubsystem"],

Cell[TextData[{
  "vs. ",
  StyleBox["KalmanObservableForm", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ObservableSubsystem"],

Cell[TextData[{
  "Observation matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observation matrix"],

Cell[TextData[{
  "Observer",
  ", ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observer"],

Cell[TextData[{
  "Kalman",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer"],

Cell[TextData[{
  "optimal",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Observer"],

Cell[TextData[{
  "Optimal control",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Optimal control"],

Cell[TextData[{
  "Optimal controller",
  ", ",
  " ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Optimal controller"],

Cell[TextData[{
  "Optimal estimation",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Optimal estimation"],

Cell[TextData[{
  "Ordered Schur decomposition",
  ", ",
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ordered Schur decomposition"],

Cell[TextData[{
  "Orthogonal basis",
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Orthogonal basis"],

Cell[TextData[{
  "reconstruction of",
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Orthogonal basis"],

Cell[TextData[{
  "Orthogonal complement",
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Orthogonal complement"],

Cell[TextData[{
  StyleBox["OrthogonalTransformMatrix", "MR"],
  ", ",
  ButtonBox["CSP8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrthogonalTransformMatrix"],

Cell[TextData[{
  "Outflow control",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Outflow control"],

Cell[TextData[{
  "Outflow rate",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Outflow rate"],

Cell[TextData[{
  "Output controllability matrix",
  ", ",
  StyleBox["OutputControllabilityMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Output controllability matrix"],

Cell[TextData[{
  "Output matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Output matrix"],

Cell[TextData[{
  "Output regulator",
  ", ",
  "optimal, ",
  StyleBox["LQOutputRegulatorGains", "MR"],
  ", ",
  " ",
  ButtonBox["CSP10.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Output regulator"],

Cell[TextData[{
  "Output response",
  ", ",
  StyleBox["OutputResponse", "MR"],
  ", ",
  " ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Output response"],

Cell[TextData[{
  StyleBox["OutputControllabilityMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OutputControllabilityMatrix"],

Cell[TextData[{
  StyleBox["OutputControllable", "MR"],
  ", ",
  " ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OutputControllable"],

Cell[TextData[{
  StyleBox["OutputResponse", "MR"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OutputResponse"],

Cell[TextData[{
  "dummy variable in",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"OutputResponse"],

Cell[TextData[{
  "initial conditions in",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"OutputResponse"],

Cell[TextData[{
  "number of input signals in",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"OutputResponse"],

Cell[TextData[{
  "polling inputs in",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"OutputResponse"],

Cell[TextData[{
  "simulations with",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"OutputResponse"],

Cell[TextData[{
  "symbolic solution",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"OutputResponse"],

Cell[TextData[{
  "Outputs",
  ", ",
  "count of",
  ", ",
  " ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Outputs"],

Cell[TextData[{
  StyleBox["OutputVariables", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OutputVariables"],

Cell[TextData[{
  "Overdamped response",
  ", ",
  " ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Overdamped response"],

Cell[TextData[{
  "Overshoot",
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Overshoot"],

Cell[TextData[{
  "Pad\[EAcute] approximation",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pade approximation"],

Cell[TextData[{
  "Parallel connection",
  ", ",
  StyleBox["ParallelConnect", "MR"],
  ", ",
  " ",
  ButtonBox["CSP6.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Parallel connection"],

Cell[TextData[{
  StyleBox["ParallelConnect", "MR"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ParallelConnect"],

Cell[TextData[{
  "for adding inputs to system",
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ParallelConnect"],

Cell[TextData[{
  "Particular response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Particular response"],

Cell[TextData[{
  "Penalty function",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Penalty function"],

Cell[TextData[{
  "Pendulum",
  ", ",
  "inverted",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pendulum"],

Cell[TextData[{
  "Performance criterion",
  ", ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Performance criterion"],

Cell[TextData[{
  "of a missile",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Performance criterion"],

Cell[TextData[{
  "Performance index",
  ", ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Performance index"],

Cell[TextData[{
  "of a missile",
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Performance index"],

Cell[TextData[{
  StyleBox["Period", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Period"],

Cell[TextData[{
  "Phase band",
  ", ",
  " ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Phase band"],

Cell[TextData[{
  "Phase margin",
  ", ",
  StyleBox["GainPhaseMargins", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Phase margin"],

Cell[TextData[{
  "Phase response",
  ", ",
  " ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Phase response"],

Cell[TextData[{
  "Phase unwrapping",
  ", ",
  "adjusting ",
  StyleBox["PlotPoints", "MR"],
  " for",
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Phase unwrapping"],

Cell[TextData[{
  StyleBox["PhaseRange", "MR"],
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Phase unwrapping"],

Cell[TextData[{
  StyleBox["PhaseRange", "MR"],
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PhaseRange"],

Cell[TextData[{
  "PID controller",
  ", ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PID controller"],

Cell[TextData[{
  StyleBox["Pivoting", "MR"],
  ", ",
  "in ",
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pivoting"],

Cell[TextData[{
  "Plant",
  ", ",
  " ",
  ButtonBox["CSP3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Plant"],

Cell[TextData[{
  StyleBox["PlotPoints", "MR"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlotPoints"],

Cell[TextData[{
  StyleBox["PlotSampling", "MR"],
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlotSampling"],

Cell[TextData[{
  "Pole assignment",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "controlling numerical errors in",
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "robust",
  ", ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "using Ackermann's formula",
  ", ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole assignment"],

Cell[TextData[{
  "Pole placement",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pole placement"],

Cell[TextData[{
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Pole placement"],

Cell[TextData[{
  "Pole\[Hyphen]zero cancellation",
  ", ",
  StyleBox["PoleZeroCancel", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pole-zero cancellation"],

Cell[TextData[{
  "Poles",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Poles"],

Cell[TextData[{
  "multiple",
  ", ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Poles"],

Cell[TextData[{
  "of closed\[Hyphen]loop system",
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Poles"],

Cell[TextData[{
  "of transfer function, ",
  StyleBox["Poles", "MR"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Poles"],

Cell[TextData[{
  "of transfer function, ",
  StyleBox["ZeroPoleGain", "MR"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Poles"],

Cell[TextData[{
  StyleBox["Poles", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Poles"],

Cell[TextData[{
  StyleBox["PoleStyle", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PoleStyle"],

Cell[TextData[{
  StyleBox["PoleZeroCancel", "MR"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PoleZeroCancel"],

Cell[TextData[{
  "Polynomial approximations",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomial approximations"],

Cell[TextData[{
  StyleBox["Positive", "MR"],
  ", ",
  "in ",
  StyleBox["FeedbackConnect", "MR"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Positive"],

Cell[TextData[{
  "in ",
  StyleBox["GenericConnect", "MR"],
  ", ",
  ButtonBox["CSP6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Positive"],

Cell[TextData[{
  "Positive definite",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Positive definite"],

Cell[TextData[{
  "Positive feedback",
  ", ",
  " ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Positive feedback"],

Cell[TextData[{
  "Positive semidefinite",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Positive semidefinite"],

Cell[TextData[{
  "Predictor estimator",
  ", ",
  " ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Predictor estimator"],

Cell[TextData[{
  "Prewarping",
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Prewarping"],

Cell[TextData[{
  StyleBox["CriticalFrequency", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Prewarping"],

Cell[TextData[{
  "Process noise",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Process noise"],

Cell[TextData[{
  "Production and inventory control model",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Production and inventory control model"],

Cell[TextData[{
  "Production rate",
  ", ",
  "control of",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Production rate"],

Cell[TextData[{
  "Proper transfer function",
  ", ",
  "state-space realization of",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Proper transfer function"],

Cell[TextData[{
  "Proportional controller",
  ", ",
  " ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Proportional controller"],

Cell[TextData[{
  StyleBox["QRDecomposition", "MR"],
  ", ",
  "as value of ",
  StyleBox["DecompositionMethod", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QRDecomposition"],

Cell[TextData[{
  "Quadratic cost function",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Quadratic cost function"],

Cell[TextData[{
  "Ramp response",
  ", ",
  " ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ramp response"],

Cell[TextData[{
  "Random systems",
  ", ",
  StyleBox["RandomSystem", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Random systems"],

Cell[TextData[{
  StyleBox["RandomOrthogonalComplement", "MR"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomOrthogonalComplement"],

Cell[TextData[{
  "in ",
  StyleBox["KalmanControllableForm", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"RandomOrthogonalComplement"],

Cell[TextData[{
  "in ",
  StyleBox["KalmanObservableForm", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"RandomOrthogonalComplement"],

Cell[TextData[{
  "in ",
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"RandomOrthogonalComplement"],

Cell[TextData[{
  StyleBox["RandomSystem", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomSystem"],

Cell[TextData[{
  "Rank",
  ", ",
  "of matrix, ",
  StyleBox["Rank", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Rank"],

Cell[TextData[{
  "Rational polynomial approximations",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Rational polynomial approximations"],

Cell[TextData[{
  "Rational polynomials",
  ", ",
  "as ",
  StyleBox["TransferFunction", "MR"],
  " objects",
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Rational polynomials"],

Cell[TextData[{
  StyleBox["RealBlockForm", "MR"],
  ", ",
  "in ",
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RealBlockForm"],

Cell[TextData[{
  "Realizations",
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Realizations"],

Cell[TextData[{
  "converting between",
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Realizations"],

Cell[TextData[{
  StyleBox["RealRootProbability", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RealRootProbability"],

Cell[TextData[{
  "Reduced-order model",
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Reduced-order model"],

Cell[TextData[{
  StyleBox["ReductionMethod", "MR"],
  ", ",
  "in ",
  StyleBox["ControllableSpaceSize", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ReductionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["ControllableSubsystem", "MR"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ReductionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["DominantSubsystem", "MR"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ReductionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["MinimalRealization", "MR"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ReductionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["ObservableSpaceSize", "MR"],
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ReductionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["ObservableSubsystem", "MR"],
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ReductionMethod"],

Cell[TextData[{
  "in ",
  StyleBox["TransferFunction", "MR"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ReductionMethod"],

Cell[TextData[{
  "Reference signal",
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Reference signal"],

Cell[TextData[{
  "Regulator",
  ", ",
  "linear quadratic, ",
  StyleBox["LQRegulatorGains", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Regulator"],

Cell[TextData[{
  "output",
  ", ",
  ButtonBox["CSP10.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Regulator"],

Cell[TextData[{
  StyleBox["RejectionLevel", "MR"],
  ", ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RejectionLevel"],

Cell[TextData[{
  "Resolvent matrix",
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Resolvent matrix"],

Cell[TextData[{
  "Response",
  ", ",
  "in frequency domain",
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Response"],

Cell[TextData[{
  "in time domain",
  ", ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Response"],

Cell[TextData[{
  "minimum\[Hyphen]time",
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Response"],

Cell[TextData[{
  StyleBox["ResponseVariable", "MR"],
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ResponseVariable"],

Cell[TextData[{
  StyleBox["ReviewForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP0.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ReviewForm"],

Cell[TextData[{
  "Riccati equations",
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Riccati equations"],

Cell[TextData[{
  StyleBox["RiccatiSolve", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RiccatiSolve"],

Cell[TextData[{
  "Robust pole assignment",
  ", ",
  StyleBox["KNVD", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Robust pole assignment"],

Cell[TextData[{
  "Roll angle",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Roll angle"],

Cell[TextData[{
  "Roll attitude control",
  ", ",
  "of a missile",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Roll attitude control"],

Cell[TextData[{
  "Roll rate",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Roll rate"],

Cell[TextData[{
  "Roll time constant",
  ", ",
  "of ailerons",
  ", ",
  " ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Roll time constant"],

Cell[TextData[{
  "Root loci",
  ", ",
  "evolution of",
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Root loci"],

Cell[TextData[{
  StyleBox["RootLocusPlot", "MR"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Root loci"],

Cell[TextData[{
  StyleBox["RootLocusAnimation", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RootLocusAnimation"],

Cell[TextData[{
  StyleBox["RootLocusPlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RootLocusPlot"],

Cell[TextData[{
  StyleBox["RowReduce", "MR"],
  ", ",
  "as value of ",
  StyleBox["DecompositionMethod", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RowReduce"],

Cell[TextData[{
  "Rudder",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Rudder"],

Cell[TextData[{
  StyleBox["Sampled", "MR"],
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sampled"],

Cell[TextData[{
  "Sampling",
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sampling"],

Cell[TextData[{
  "Sampling period",
  ", ",
  "choice of",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sampling period"],

Cell[TextData[{
  StyleBox["SamplingPeriod", "MR"],
  ", ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Sampling period"],

Cell[TextData[{
  "Sampling rate",
  ", ",
  " ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sampling rate"],

Cell[TextData[{
  StyleBox["SamplingPeriod", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SamplingPeriod"],

Cell[TextData[{
  "Satellite attitude control example",
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Satellite attitude control example"],

Cell[TextData[{
  "controller for",
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Satellite attitude control example"],

Cell[TextData[{
  "PID controller for",
  ", ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Satellite attitude control example"],

Cell[TextData[{
  "Schur decomposition",
  ", ",
  "ordered, ",
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Schur decomposition"],

Cell[TextData[{
  StyleBox["SchurDecomposition", "MR"],
  ", ",
  "as value of ",
  StyleBox["SolveMethod", "MR"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SchurDecomposition"],

Cell[TextData[{
  "vs. ",
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SchurDecomposition"],

Cell[TextData[{
  StyleBox["SchurDecompositionOrdered", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SchurDecompositionOrdered"],

Cell[TextData[{
  "Second\[Hyphen]order system",
  ", ",
  "frequency response of",
  ", ",
  ButtonBox["CSP5.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Second-order system"],

Cell[TextData[{
  "impulse response of",
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Second\[Hyphen]order system"],

Cell[TextData[{
  "root  loci of",
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Second\[Hyphen]order system"],

Cell[TextData[{
  "sampling rate for",
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Second\[Hyphen]order system"],

Cell[TextData[{
  "step response of",
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Second\[Hyphen]order system"],

Cell[TextData[{
  "Separation principle",
  ", ",
  " ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Separation principle"],

Cell[TextData[{
  "Serial connection",
  ", ",
  StyleBox["SeriesConnect", "MR"],
  ", ",
  " ",
  ButtonBox["CSP6.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Serial connection"],

Cell[TextData[{
  "Series compensation",
  ", ",
  " ",
  ButtonBox["CSP6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Series compensation"],

Cell[TextData[{
  StyleBox["SeriesConnect", "MR"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SeriesConnect"],

Cell[TextData[{
  "Servo mechanism",
  ", ",
  " ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Servo mechanism"],

Cell[TextData[{
  "Servo motor",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Servo motor"],

Cell[TextData[{
  StyleBox["SetControlFormat", "MR"],
  ", ",
  " ",
  ButtonBox["CSP1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SetControlFormat"],

Cell[TextData[{
  StyleBox["SetStandardFormat", "MR"],
  ", ",
  " ",
  ButtonBox["CSP1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SetStandardFormat"],

Cell[TextData[{
  "Sideslip angle",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sideslip angle"],

Cell[TextData[{
  "Similarity transformation",
  ", ",
  "for Kalman forms",
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Similarity transformation"],

Cell[TextData[{
  StyleBox["SimilarityTransform", "MR"],
  ", ",
  ButtonBox["CSP8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Similarity transformation"],

Cell[TextData[{
  StyleBox["SimilarityTransform", "MR"],
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SimilarityTransform"],

Cell[TextData[{
  "Simulation",
  ", ",
  "analog",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Simulation"],

Cell[TextData[{
  "discrete",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Simulation"],

Cell[TextData[{
  StyleBox["SimulationPlot", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SimulationPlot"],

Cell[TextData[{
  "plotting state response with",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SimulationPlot"],

Cell[TextData[{
  "Single-input, single-output (SISO) systems",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Single-input, single-output (SISO) systems"],

Cell[TextData[{
  "minimal realization of",
  ", ",
  ButtonBox["CSP8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Single-input, single-output (SISO) systems"],

Cell[TextData[{
  "Singular\[Hyphen]value plot",
  ", ",
  StyleBox["SingularValuePlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Singular-value plot"],

Cell[TextData[{
  StyleBox["SingularValuePlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SingularValuePlot"],

Cell[TextData[{
  StyleBox["SingularValues", "MR"],
  ", ",
  "as value of ",
  StyleBox["DecompositionMethod", "MR"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SingularValues"],

Cell[TextData[{
  "in ",
  StyleBox["Rank", "MR"],
  ", ",
  ButtonBox["CSP12.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SingularValues"],

Cell[TextData[{
  "SISO systems",
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SISO systems"],

Cell[TextData[{
  "Solution",
  ", ",
  "nominal",
  ", ",
  " ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Solution"],

Cell[TextData[{
  StyleBox["SolveMethod", "MR"],
  ", ",
  "in ",
  StyleBox["DiscreteRiccatiSolve", "MR"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SolveMethod"],

Cell[TextData[{
  "in ",
  StyleBox["RiccatiSolve", "MR"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"SolveMethod"],

Cell[TextData[{
  "Spacecraft",
  ", ",
  "attitude control of",
  ", ",
  " ",
  ButtonBox["CSP5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Spacecraft"],

Cell[TextData[{
  StyleBox["SpecialPointProbability", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpecialPointProbability"],

Cell[TextData[{
  StyleBox["SpecialPoints", "MR"],
  ", ",
  " ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpecialPoints"],

Cell[TextData[{
  "Spectrum",
  ", ",
  "of noise",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Spectrum"],

Cell[TextData[{
  "Stabilizable system",
  ", ",
  " ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stabilizable system"],

Cell[TextData[{
  "Stable system",
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stable system"],

Cell[TextData[{
  "in Lyapunov's sense",
  ", ",
  ButtonBox["CSP12.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Stable system"],

Cell[TextData[{
  "State equations",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State equations"],

Cell[TextData[{
  "nonlinear",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State equations"],

Cell[TextData[{
  "State estimation",
  ", ",
  "deterministic",
  ", ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State estimation"],

Cell[TextData[{
  "optimal",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State estimation"],

Cell[TextData[{
  "stochastic",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State estimation"],

Cell[TextData[{
  "State feedback",
  ", ",
  StyleBox["StateFeedbackConnect", "MR"],
  ", ",
  ButtonBox["CSP6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State feedback"],

Cell[TextData[{
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State feedback"],

Cell[TextData[{
  "State matrix",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State matrix"],

Cell[TextData[{
  "State reconstruction",
  ", ",
  "deterministic",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State reconstruction"],

Cell[TextData[{
  "optimal",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State reconstruction"],

Cell[TextData[{
  "stochastic",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State reconstruction"],

Cell[TextData[{
  "State response",
  ", ",
  "plotting with ",
  StyleBox["SimulationPlot", "MR"],
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State response"],

Cell[TextData[{
  StyleBox["StateResponse", "MR"],
  ", ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"State response"],

Cell[TextData[{
  "State trajectories",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State trajectories"],

Cell[TextData[{
  "State-space data structure",
  ", ",
  StyleBox["StateSpace", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State-space data structure"],

Cell[TextData[{
  "State-space models",
  ", ",
  "nonlinear",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State-space models"],

Cell[TextData[{
  "State-space realizations",
  ", ",
  " ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State-space realizations"],

Cell[TextData[{
  "State-space systems",
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"State-space systems"],

Cell[TextData[{
  StyleBox["StateFeedbackConnect", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateFeedbackConnect"],

Cell[TextData[{
  StyleBox["StateFeedbackGains", "MR"],
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateFeedbackGains"],

Cell[TextData[{
  StyleBox["StateResponse", "MR"],
  ", ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateResponse"],

Cell[TextData[{
  "dummy variable in",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateResponse"],

Cell[TextData[{
  "initial conditions in",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateResponse"],

Cell[TextData[{
  "number of input signals in",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateResponse"],

Cell[TextData[{
  "polling inputs in",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateResponse"],

Cell[TextData[{
  "simulations with",
  ", ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateResponse"],

Cell[TextData[{
  "symbolic solution",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateResponse"],

Cell[TextData[{
  "States",
  ", ",
  "count of",
  ", ",
  " ",
  ButtonBox["CSP12.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"States"],

Cell[TextData[{
  StyleBox["StateSpace", "MR"],
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateSpace"],

Cell[TextData[{
  "traditional notations for",
  ", ",
  ButtonBox["CSP1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateSpace"],

Cell[TextData[{
  "with ",
  StyleBox["RandomSystem", "MR"],
  ", ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"StateSpace"],

Cell[TextData[{
  StyleBox["StateVariables", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateVariables"],

Cell[TextData[{
  "Stationary noise",
  ", ",
  "in wide sense",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stationary noise"],

Cell[TextData[{
  "Steady\[Hyphen]state error",
  ", ",
  " ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Steady-state error"],

Cell[TextData[{
  "Step response",
  ", ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Step response"],

Cell[TextData[{
  "Stern plane",
  ", ",
  "deflection of",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stern plane"],

Cell[TextData[{
  "Stochastic",
  ", ",
  "inputs",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stochastic"],

Cell[TextData[{
  "state reconstruction",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Stochastic"],

Cell[TextData[{
  "system",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Stochastic"],

Cell[TextData[{
  "Strictly proper transfer function",
  ", ",
  "and ",
  StyleBox["RandomSystem", "MR"],
  ", ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Strictly proper transfer function"],

Cell[TextData[{
  "state-space realization of",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Strictly proper transfer function"],

Cell[TextData[{
  "Submarine",
  ", ",
  "depth control of",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Submarine"],

Cell[TextData[{
  "Subspace",
  ", ",
  "controllable",
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subspace"],

Cell[TextData[{
  "observable",
  ", ",
  ButtonBox["CSP7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Subspace"],

Cell[TextData[{
  StyleBox["Subsystem", "MR"],
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subsystem"],

Cell[TextData[{
  "Suspension system example",
  ", ",
  " ",
  ButtonBox["CSP11.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Suspension system example"],

Cell[TextData[{
  "SV plot",
  ", ",
  StyleBox["SingularValuePlot", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SV plot"],

Cell[TextData[{
  "System",
  ", ",
  "analog",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"System"],

Cell[TextData[{
  "composite",
  ", ",
  ButtonBox["CSP6.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "continuous-time",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "digital",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "discrete\[Hyphen]time",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "dual",
  ", ",
  ButtonBox["CSP7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "dynamic",
  ", ",
  ButtonBox["CSP3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "nonlinear",
  ", ",
  ButtonBox["CSP11.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "random",
  ", ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "state\[Hyphen]space realization of",
  ", ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "stochastic",
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  "time-varying",
  ", ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"System"],

Cell[TextData[{
  StyleBox["T",
    FontSlant->"Italic"],
  "\[Hyphen]bridge network",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"T-bridge network"],

Cell[TextData[{
  StyleBox["TargetForm", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TargetForm"],

Cell[TextData[{
  "Temperature sensor",
  ", ",
  " ",
  ButtonBox["CSP11.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Temperature sensor"],

Cell[TextData[{
  "Terminal state error",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Terminal state error"],

Cell[TextData[{
  "Third\[Hyphen]order system, step response of",
  ", ",
  " ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Third-order system, step response of"],

Cell[TextData[{
  "Time-domain response",
  ", ",
  " ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Time-domain response"],

Cell[TextData[{
  "Time-domain simulation",
  ", ",
  " ",
  ButtonBox["CSP4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Time-domain simulation"],

Cell[TextData[{
  "Time-varying systems",
  ", ",
  "response of",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Time-varying systems"],

Cell[TextData[{
  StyleBox["TimeVariable", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TimeVariable"],

Cell[TextData[{
  StyleBox["ToContinuousTime", "MR"],
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToContinuousTime"],

Cell[TextData[{
  StyleBox["ToDiscreteTime", "MR"],
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP10.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToDiscreteTime"],

Cell[TextData[{
  StyleBox["Tolerance", "MR"],
  ", ",
  "in ",
  StyleBox["PoleZeroCancel", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Tolerance"],

Cell[TextData[{
  "Torque",
  ", ",
  " ",
  ButtonBox["CSP10.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Torque"],

Cell[TextData[{
  "Traditional notations",
  ", ",
  ButtonBox["CSP1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Traditional notations"],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  ", ",
  "of control objects",
  ", ",
  ButtonBox["CSP1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TraditionalForm"],

Cell[TextData[{
  "Transfer function matrix",
  ", ",
  "data structure for, ",
  StyleBox["TransferFunction", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transfer function matrix"],

Cell[TextData[{
  "Transfer matrix",
  ", ",
  "data structure for, ",
  StyleBox["TransferFunction", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transfer matrix"],

Cell[TextData[{
  StyleBox["TransferFunction", "MR"],
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "as a pure function object",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "expanding",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "factoring",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "nonpolynomial",
  ", ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "traditional notations for",
  ", ",
  ButtonBox["CSP1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "variable in",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "with ",
  StyleBox["RandomSystem", "MR"],
  ", ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TransferFunction"],

Cell[TextData[{
  "Transformation matrix",
  ", ",
  "recovering of, ",
  StyleBox["TransformationMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transformation matrix"],

Cell[TextData[{
  StyleBox["TransformationMatrix", "MR"],
  ", ",
  " ",
  ButtonBox["CSP8.8",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TransformationMatrix"],

Cell[TextData[{
  "Transient response",
  ", ",
  " ",
  ButtonBox["CSP4.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transient response"],

Cell[TextData[{
  "Transient state error",
  ", ",
  " ",
  ButtonBox["CSP10.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transient state error"],

Cell[TextData[{
  "Transport lag",
  ", ",
  " ",
  ButtonBox["CSP5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transport lag"],

Cell[TextData[{
  "Triangle hold",
  ", ",
  StyleBox["FirstOrderHold", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Triangle hold"],

Cell[TextData[{
  "Tustin transformation",
  ", ",
  StyleBox["BilinearTransform", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Tustin transformation"],

Cell[TextData[{
  "Uncontrollable states",
  ", ",
  ButtonBox["CSP10.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Uncontrollable states"],

Cell[TextData[{
  "Undamped response",
  ", ",
  " ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Undamped response"],

Cell[TextData[{
  "Underdamped response",
  ", ",
  " ",
  ButtonBox["CSP4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Underdamped response"],

Cell[TextData[{
  "Unforced response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unforced response"],

Cell[TextData[{
  "Unobservable",
  ", ",
  "states",
  ", ",
  " ",
  ButtonBox["CSP8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unobservable"],

Cell[TextData[{
  StyleBox["VerifyPoles", "MR"],
  ", ",
  " ",
  ButtonBox["CSP9.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VerifyPoles"],

Cell[TextData[{
  "Weak modes",
  ", ",
  " ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Weak modes"],

Cell[TextData[{
  "Weak subsystem",
  ", ",
  " ",
  ButtonBox["CSP8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Weak subsystem"],

Cell[TextData[{
  "Yaw rate",
  ", ",
  " ",
  ButtonBox["CSP9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Yaw rate"],

Cell[TextData[{
  StyleBox["z",
    FontSlant->"Italic"],
  "-transform",
  ", ",
  "modified",
  ", ",
  ButtonBox["CSP3.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"z-transform"],

Cell[TextData[{
  StyleBox["ZTransform", "MR"],
  ", ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"z-transform"],

Cell[TextData[{
  "Zero-input response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero-input response"],

Cell[TextData[{
  "Zero-order hold",
  ", ",
  StyleBox["ZeroOrderHold", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero-order hold"],

Cell[TextData[{
  "Zero-pole mapping",
  ", ",
  StyleBox["ZeroPoleMapping", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero-pole mapping"],

Cell[TextData[{
  "Zero-pole-gain data structure",
  ", ",
  StyleBox["ZeroPoleGain", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero-pole-gain data structure"],

Cell[TextData[{
  "Zero-state response",
  ", ",
  " ",
  ButtonBox["CSP4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero-state response"],

Cell[TextData[{
  StyleBox["ZeroOrderHold", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroOrderHold"],

Cell[TextData[{
  StyleBox["ZeroPoleGain", "MR"],
  ", ",
  ButtonBox["CSP1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroPoleGain"],

Cell[TextData[{
  "variable in",
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ZeroPoleGain"],

Cell[TextData[{
  "with ",
  StyleBox["RandomSystem", "MR"],
  ", ",
  ButtonBox["CSP12.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"ZeroPoleGain"],

Cell[TextData[{
  StyleBox["ZeroPoleMapping", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroPoleMapping"],

Cell[TextData[{
  "Zeros",
  ", ",
  "of transfer function, ",
  StyleBox["ZeroPoleGain", "MR"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zeros"],

Cell[TextData[{
  "of transfer function, ",
  StyleBox["Zeros", "MR"],
  ", ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Zeros"],

Cell[TextData[{
  StyleBox["Zeros", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zeros"],

Cell[TextData[{
  StyleBox["ZeroStyle", "MR"],
  ", ",
  " ",
  ButtonBox["CSP5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroStyle"],

Cell[TextData[{
  StyleBox["ZTransform", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZTransform"],

Cell[TextData[{
  StyleBox["$ContinuousTimeComplexPlaneVariable", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$ContinuousTimeComplexPlaneVariable"],

Cell[TextData[{
  StyleBox["$ContinuousTimeToken", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$ContinuousTimeToken"],

Cell[TextData[{
  StyleBox["$DiscreteTimeComplexPlaneVariable", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$DiscreteTimeComplexPlaneVariable"],

Cell[TextData[{
  StyleBox["$DiscreteTimeToken", "MR"],
  " ",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$DiscreteTimeToken "],

Cell[TextData[{
  StyleBox["$RandomOrthogonalComplement", "MR"],
  ", ",
  ButtonBox["CSP0.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CSP7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$RandomOrthogonalComplement"],

Cell[TextData[{
  StyleBox["$Sampled", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$Sampled"],

Cell[TextData[{
  StyleBox["$SamplingPeriod", "MR"],
  ", ",
  " ",
  ButtonBox["CSP3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$SamplingPeriod"],

Cell[TextData[{
  StyleBox["\[Backslash][EmptyUpTriangle]", "MR"],
  " (",
  StyleBox["\[EmptyUpTriangle]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EmptyUpTriangle"],

Cell[TextData[{
  StyleBox["\[Backslash][EmptyUpTriangle]", "MR"],
  " (",
  StyleBox["\[EmptyUpTriangle]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[EmptyUpTriangle]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptCapitalS]", "MR"],
  " (",
  StyleBox["\[ScriptCapitalS]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptCapitalS"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptCapitalS]", "MR"],
  " (",
  StyleBox["\[ScriptCapitalS]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptCapitalS]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptCapitalT]", "MR"],
  " (",
  StyleBox["\[ScriptCapitalT]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptCapitalT"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptCapitalT]", "MR"],
  " (",
  StyleBox["\[ScriptCapitalT]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptCapitalT]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptK]", "MR"],
  " (",
  StyleBox["\[ScriptK]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptK"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptK]", "MR"],
  " (",
  StyleBox["\[ScriptK]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptK]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptS]", "MR"],
  " (",
  StyleBox["\[ScriptS]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptS"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptS]", "MR"],
  " (",
  StyleBox["\[ScriptS]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptS]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptT]", "MR"],
  " (",
  StyleBox["\[ScriptT]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptT"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptT]", "MR"],
  " (",
  StyleBox["\[ScriptT]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptT]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptU]", "MR"],
  " (",
  StyleBox["\[ScriptU]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptU"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptU]", "MR"],
  " (",
  StyleBox["\[ScriptU]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptU]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptX]", "MR"],
  " (",
  StyleBox["\[ScriptX]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptX"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptX]", "MR"],
  " (",
  StyleBox["\[ScriptX]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptX]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptY]", "MR"],
  " (",
  StyleBox["\[ScriptY]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptY"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptY]", "MR"],
  " (",
  StyleBox["\[ScriptY]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptY]"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptZ]", "MR"],
  " (",
  StyleBox["\[ScriptZ]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScriptZ"],

Cell[TextData[{
  StyleBox["\[Backslash][ScriptZ]", "MR"],
  " (",
  StyleBox["\[ScriptZ]", "MR"],
  ")",
  ", ",
  "in control objects",
  ", ",
  " ",
  ButtonBox["CSP3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Control System Professional"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\\[ScriptZ]"]
}, Closed]],

Cell[CellGroupData[{

Cell["Digital Image Processing", "IndexSection",
  CellTags->{
  "AbsDistance", "AbsValue", "Amplitude features", "Barrel distortion", 
    "Basis functions", "Basis images", "Basis sequences", "BinaryClose", 
    "BinaryDilate", "BinaryErode", "BinaryHitMiss", "BinaryMajority", 
    "BinaryOpen", "BinarySkeleton", "BlockLee", "BlockMedian", "BlockOutlier",
     "Block processing", "BlockProcessing", "BlockSigma", 
    "Block transform coding", "BlockTrimmedMean", "BMP", "BoxFilter", 
    "CanberraDistance", "Centered", "ChebyshevDistance", "Circulant matrix", 
    "CirculantMatrix", "Circular", "Close", "Clustering", "ClusterMetric", 
    " CMYK", "CMYKtoGray", "CMYKtoRGB", "Color digital image", 
    "ColorFunction", "Color-interleaved format", "Column profile", 
    "ColumnThread", "ComplementSet", "Concurrence matrix", 
    "ConcurrenceMatrix", "Contouring", "Contrast modification", "Convolution",
     "Co-occurence matrix", "Cosine", "Cosine matrix", "CosineMatrix", 
    "CumulativeHistogram", "DaubechiesFilter", "DCT", "Decimate", 
    "Decimation", "DFT", "DHT", "Digital filter design", "Dilation", 
    "DiscreteConvolve", "DiscreteCorrelate", "Discrete cosine transform", 
    "DiscreteCosineTransform", "Discrete Fourier transform", 
    "DiscreteFourierTransform", "Discrete Hadamard transform", 
    "DiscreteHadamardTransform", "Discrete-time Fourier transform (DTFT)", 
    "Discrete wavelet transform", "DiscreteWaveletTransform", 
    "DiscreteWindow", "DiscreteWindow2D", "DistanceFunction", 
    "Distance measures", "DownSample", "Downsampling", "DWT", 
    "Edge detection", "EdgeMagnitude", "EdgeOrientation", "EquirippleFilter", 
    "Erosion", "EvenSymmetry", "Fast Fourier transform", "Filter", "Filter2D",
     "Filtering", "FilterLength", "Finite impulse response", 
    "Finite impulse response filter", "FIR filter design", "FixedPad", 
    "Fixed padding", "Fourier", "Fourier matrix", "FourierMatrix", 
    "Fourier spectrum", "FreiChenFilter", "FrequencySamplingFilter", 
    "FrequencySamplingGrid", "FrequencyTransformation", "FromChannels", 
    "FromSet", "Fundamental frequency", "Fundamental interval", 
    "GaussianFilter", "Geometric operations", "Geometric transformation", 
    "Geometric warping", "GIF", "GlobalSet", "Gradient edge operators", 
    "GradientType", "GraphicsRotate", "GrayscaleClose", "GrayscaleDilate", 
    "GrayscaleErode", "GrayscaleOpen", "GrayscaleTopHat", "GridDensity", 
    "HaarFilter", "Hadamard matrix", "HadamardMatrix", "HighpassFilter", 
    "Histogram", "Histogram equalization", "HistogramEqualize", 
    "Histogram features", "Hit-or-miss transform", "HSV", "HSVtoGray", 
    "HSVtoRGB", "IDCT", "IDFT", "IDHT", "IDWT", "ImageData", "ImageDataQ", 
    "ImageDepth", "ImageDimensions", "ImageDivide", "ImageEnergy", 
    "ImageEntropy", "ImageHistogram", "ImageMean", "ImageMedian", 
    "ImageOptions", "ImagePlus", "ImagePower", "ImageRange", "ImageRead", 
    "ImageRotate", "Image segmentation", "ImageSize", "ImageSubtract", 
    "ImageTake", "ImageThread", "ImageTimes", "ImageVariance", "ImageWarp", 
    "ImageWrite", "Impulse response", "Intensity profile", "Interpolate", 
    "Interpolation", "InverseDiscreteCosineTransform", 
    "InverseDiscreteFourierTransform", "InverseDiscreteHadamardTransform", 
    "Inverse discrete wavelet transform", "InverseDiscreteWaveletTransform", 
    "Joint Photographic Experts Group", "JPEG", "KaiserLength", "KaiserShape",
     "KMeans", "KMeansList", "Kronecker product", "KroneckerProduct", 
    "LaplacianFilter", "Least-squares", "Linear shift invariant filters", 
    "LinePlot", "LinePlot3D", "LineProfile", "LineStyle", "ListConvolve", 
    "ListCorrelate", "LoGFilter", "Luminance", "Mach bands", 
    "Magnitude spectrum", "Mallat's algorithm", "Mathematical morphological", 
    "Mathematical morphology", "MatrixJoin", "MatrixThread", 
    "McClellan transformation", "Meshed color format", "MeshedImageData", 
    "MGF", "MinkowskiDistance", "Monochrome digital image", 
    "Motion Picture Experts Group", "Noise reduction", "Nyquist filter", 
    "Open", "OptimumThreshold", "Orthogonality", "Passband", "PBM", 
    "PeriodicPad", "Periodic padding", "PGM", "Phase spectrum", "Pixel", 
    "PixelInterleave", "Pixel-interleaved format", "Planar color format", 
    "PlanarImageData", "PNG", "PNM", "Point operations", "PointStyle", "PPM", 
    "PrewittFilter", "Primary colors", "Pseudoinverse", "PSImage", 
    "Quantization", "Quantization table", "Raster", "RawImageData", "Reflect",
     "Reflection", "RegionArea", "RegionBorder", "RegionCenter", 
    "RegionCircle", "Region-of-interest processing", "RegionPoints", 
    "RegionProcessing", "RegionRectangle", "Remez exchange algorithm", 
    "Replicate", "Resize", "Resolution", "RGB", "RGBtoCMYK", "RGBtoGray, MR", 
    "RGBtoHSV", "RobertsFilter", "Rotation", "Row profile", "RowThread", 
    "ScaleClip", "ScaleLinear", "ScalePiecewiseLinear", "Scaling filter", 
    "ScalingSequence", "Secondary colors", "Sequency", "SequencyOrdered", 
    "Set complement", "Set description", "ShowImageHistogram", 
    "ShowImageWarp", "ShowLineProfile", "ShowRegionOfInterest", 
    "Signal-to-noise ratio", "Similarity", "SmoothingFilter", "SobelFilter", 
    "SqrtDistance", "Stopband", "Threshold", "Thresholding", "TIFF", 
    "ToChannels", "ToCMYKColor", "Toeplitz matrix", "ToeplitzMatrix", 
    "ToGrayLevel", "ToHSVColor", "Top-hat transformation", "ToRGBColor", 
    "ToSet", "TransientSamples", "Transition band", "UniformQuantizer", 
    "Unitary matrices", "UnsharpFilter", "Unsharp masking", "UnsharpRatio", 
    "UpSample", "Upsampling", "Walsh functions", "WarpMatrix", 
    "WaveletDensityPlot", "Wavelet filter", "WaveletFlatten", 
    "Wavelet matrix", "WaveletMatrix", "WaveletPartition", "WaveletSequence", 
    "Where", "WindowFilter", "WindowFilter2D", "Windows", "XBitmap", 
    "ZeroCrossing", "Zero-crossings", "ZeroPad", "Zero padding", 
    "$ImageDataDirectory", "$ImageTopDirectory"}],

Cell[TextData[{
  StyleBox["AbsDistance", "MR"],
  ", ",
  ButtonBox["AbsDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AbsDistance"],

Cell[TextData[{
  StyleBox["AbsValue", "MR"],
  ", ",
  ButtonBox["AbsValue",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AbsValue"],

Cell[TextData[{
  "Amplitude features",
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Amplitude features"],

Cell[TextData[{
  "Barrel distortion",
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Barrel distortion"],

Cell[TextData[{
  "Basis functions",
  ", ",
  ButtonBox["ImageProcessing 8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Basis functions"],

Cell["Basis images", "Index",
  CellTags->"Basis images"],

Cell[TextData[{
  "cosine",
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis images"],

Cell[TextData[{
  "Fourier, ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis images"],

Cell[TextData[{
  "Hadamard, ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis images"],

Cell[TextData[{
  "wavelet, ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis images"],

Cell["Basis sequences", "Index",
  CellTags->"Basis sequences"],

Cell[TextData[{
  "cosine",
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis sequences"],

Cell[TextData[{
  "Fourier, ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis sequences"],

Cell[TextData[{
  "Hadamard, ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis sequences"],

Cell[TextData[{
  "wavelet, ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Basis sequences"],

Cell[TextData[{
  StyleBox["BinaryClose", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BinaryClose",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BinaryClose"],

Cell[TextData[{
  StyleBox["BinaryDilate", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BinaryDilate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BinaryDilate"],

Cell[TextData[{
  StyleBox["BinaryErode", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BinaryErode",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BinaryErode"],

Cell[TextData[{
  StyleBox["BinaryHitMiss", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BinaryHitMiss",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BinaryHitMiss"],

Cell[TextData[{
  StyleBox["BinaryMajority", "MR"],
  ", ",
  ButtonBox["BinaryMajority",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BinaryMajority"],

Cell[TextData[{
  StyleBox["BinaryOpen", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BinaryOpen",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BinaryOpen"],

Cell[TextData[{
  StyleBox["BinarySkeleton", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BinarySkeleton",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BinarySkeleton"],

Cell[TextData[{
  StyleBox["BlockLee", "MR"],
  ", ",
  ButtonBox["BlockLee",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BlockLee"],

Cell[TextData[{
  StyleBox["BlockMedian", "MR"],
  ", ",
  ButtonBox["BlockMedian",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BlockMedian"],

Cell[TextData[{
  StyleBox["BlockOutlier", "MR"],
  ", ",
  ButtonBox["BlockOutlier",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BlockOutlier"],

Cell[TextData[{
  StyleBox["Block processing", "Text"],
  ", ",
  ButtonBox["ImageProcessing 5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Block processing"],

Cell[TextData[{
  StyleBox["BlockProcessing", "MR"],
  ", ",
  ButtonBox["BlockProcessing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BlockProcessing"],

Cell[TextData[{
  StyleBox["BlockSigma", "MR"],
  ", ",
  ButtonBox["BlockSigma",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BlockSigma"],

Cell[TextData[{
  "Block transform coding",
  ", ",
  ButtonBox["ImageProcessing 8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Block transform coding"],

Cell[TextData[{
  StyleBox["BlockTrimmedMean", "MR"],
  ", ",
  ButtonBox["BlockTrimmedMean",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BlockTrimmedMean"],

Cell[TextData[{
  "BMP",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BMP"],

Cell[TextData[{
  StyleBox["BoxFilter", "MR"],
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BoxFilter"],

Cell[TextData[{
  StyleBox["CanberraDistance", "MR"],
  ", ",
  ButtonBox["CanberraDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CanberraDistance"],

Cell[TextData[{
  StyleBox["Centered", "MR"],
  ", ",
  ButtonBox["Centered",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Centered"],

Cell[TextData[{
  StyleBox["ChebyshevDistance", "MR"],
  ", ",
  ButtonBox["ChebyshevDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ChebyshevDistance"],

Cell[TextData[{
  "Circulant matrix",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Circulant matrix"],

Cell[TextData[{
  StyleBox["CirculantMatrix", "MR"],
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["CirculantMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CirculantMatrix"],

Cell[TextData[{
  StyleBox["Circular", "MR"],
  ", ",
  ButtonBox["Circular",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Circular"],

Cell["Close", "Index",
  CellTags->"Close"],

Cell[TextData[{
  "binary",
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Close"],

Cell[TextData[{
  "duality with open, ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Close"],

Cell[TextData[{
  "grayscale, ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Close"],

Cell[TextData[{
  "Clustering",
  ", ",
  ButtonBox["ImageProcessing 7.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Clustering"],

Cell[TextData[{
  StyleBox["ClusterMetric", "MR"],
  ", ",
  ButtonBox["ClusterMetric",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClusterMetric"],

Cell[TextData[{
  " CMYK",
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->" CMYK"],

Cell[TextData[{
  "Color digital image",
  ", ",
  ButtonBox["ImageProcessing 2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Color digital image"],

Cell[TextData[{
  StyleBox["ColorFunction", "MR"],
  ", ",
  ButtonBox["ColorFunction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ColorFunction"],

Cell[TextData[{
  "Color-interleaved format",
  ", ",
  ButtonBox["ImageProcessing 2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Color-interleaved format"],

Cell[TextData[{
  "Column profile",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Column profile"],

Cell[TextData[{
  StyleBox["ColumnThread", "MR"],
  ", ",
  ButtonBox["ColumnThread",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ColumnThread"],

Cell[TextData[{
  StyleBox["ComplementSet", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ComplementSet",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ComplementSet"],

Cell[TextData[{
  "Concurrence matrix",
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Concurrence matrix"],

Cell[TextData[{
  StyleBox["ConcurrenceMatrix", "MR"],
  ", ",
  ButtonBox["ConcurrenceMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ConcurrenceMatrix"],

Cell[TextData[{
  "Contouring",
  ", ",
  ButtonBox["ImageProcessing 3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Contouring"],

Cell[TextData[{
  "Contrast modification",
  ", ",
  ButtonBox["ImageProcessing 3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Contrast modification"],

Cell[TextData[{
  "Convolution",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Convolution"],

Cell[TextData[{
  "circular, ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Convolution"],

Cell[TextData[{
  "linear, ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Convolution"],

Cell[TextData[{
  "matrix formulation, ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Convolution"],

Cell[TextData[{
  "periodic, ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Convolution"],

Cell[TextData[{
  " sum, ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Convolution"],

Cell[TextData[{
  "Co-occurrence matrix",
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Co-occurence matrix"],

Cell[TextData[{
  "Cosine",
  ", ",
  "basis images",
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cosine"],

Cell[TextData[{
  "Cosine matrix",
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cosine matrix"],

Cell[TextData[{
  StyleBox["CosineMatrix", "MR"],
  ", ",
  ButtonBox["CosineMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CosineMatrix"],

Cell[TextData[{
  StyleBox["CumulativeHistogram", "MR"],
  ", ",
  ButtonBox["CumulativeHistogram",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CumulativeHistogram"],

Cell[TextData[{
  StyleBox["DaubechiesFilter", "MR"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["DaubechiesFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DaubechiesFilter"],

Cell[TextData[{
  StyleBox["Decimate", "MR"],
  ", ",
  ButtonBox["Decimate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Decimate"],

Cell[TextData[{
  "Decimation",
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Decimation"],

Cell[TextData[{
  "Digital filter design",
  ", ",
  ButtonBox["ImageProcessing 9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Digital filter design"],

Cell[TextData[{
  "window method, ",
  ButtonBox["ImageProcessing 9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Digital filter design"],

Cell["Dilation", "Index",
  CellTags->"Dilation"],

Cell[TextData[{
  "binary",
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Dilation"],

Cell[TextData[{
  "duality with erosion, ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Dilation"],

Cell[TextData[{
  "grayscale, ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Dilation"],

Cell[TextData[{
  "matrix formulation, ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Dilation"],

Cell[TextData[{
  StyleBox["DiscreteConvolve", "MR"],
  ", ",
  ButtonBox["DiscreteConvolve",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteConvolve"],

Cell[TextData[{
  StyleBox["DiscreteCorrelate", "MR"],
  ", ",
  ButtonBox["DiscreteCorrelate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteCorrelate"],

Cell[TextData[{
  "Discrete cosine transform (DCT)",
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete cosine transform"],

Cell[TextData[{
  "fast algorithm, ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Discrete cosine transform"],

Cell[TextData[{
  StyleBox["DiscreteCosineTransform", "MR"],
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["DiscreteCosineTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteCosineTransform"],

Cell[TextData[{
  StyleBox["DCT", "MR"],
  ", ",
  ButtonBox["DiscreteCosineTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DCT"],

Cell[TextData[{
  "Discrete Fourier transform",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete Fourier transform"],

Cell[TextData[{
  StyleBox["DiscreteFourierTransform", "MR"],
  ", ",
  ButtonBox["DiscreteFourierTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteFourierTransform"],

Cell[TextData[{
  StyleBox["DFT", "MR"],
  ", ",
  ButtonBox["DiscreteFourierTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DFT"],

Cell[TextData[{
  "Discrete Hadamard transform (DHT)",
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete Hadamard transform"],

Cell[TextData[{
  StyleBox["DiscreteHadamardTransform", "MR"],
  ", ",
  ButtonBox["DiscreteHadamardTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteHadamardTransform"],

Cell[TextData[{
  StyleBox["DHT", "MR"],
  ", ",
  ButtonBox["DiscreteHadamardTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DHT"],

Cell[TextData[{
  "Discrete-time Fourier transform (DTFT)",
  ", ",
  ButtonBox["ImageProcessing 8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete-time Fourier transform (DTFT)"],

Cell[TextData[{
  "Discrete wavelet transform (DWT)",
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete wavelet transform"],

Cell[TextData[{
  StyleBox["DiscreteWaveletTransform", "MR"],
  ", ",
  ButtonBox["DiscreteWaveletTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteWaveletTransform"],

Cell[TextData[{
  StyleBox["DWT", "MR"],
  ", ",
  ButtonBox["DiscreteWaveletTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DWT"],

Cell[TextData[{
  StyleBox["DiscreteWindow", "MR"],
  ", ",
  ButtonBox["DiscreteWindow",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteWindow"],

Cell[TextData[{
  StyleBox["DiscreteWindow2D", "MR"],
  ", ",
  ButtonBox["DiscreteWindow2D",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiscreteWindow2D"],

Cell[TextData[{
  StyleBox["DistanceFunction", "MR"],
  ", ",
  ButtonBox["DistanceFunction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DistanceFunction"],

Cell[TextData[{
  "Distance measures",
  ", ",
  "Euclidean",
  ", ",
  ButtonBox["ImageProcessing 7.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Distance measures"],

Cell[TextData[{
  StyleBox["DownSample", "MR"],
  ", ",
  ButtonBox["DownSample",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DownSample"],

Cell[TextData[{
  "Downsampling",
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Downsampling"],

Cell[TextData[{
  "Edge detection",
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Edge detection"],

Cell[TextData[{
  "gradient method, ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Edge detection"],

Cell[TextData[{
  "Laplacian-of-Gaussian, ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Edge detection"],

Cell[TextData[{
  "morphological, ",
  ButtonBox["ImageProcessing 6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Edge detection"],

Cell[TextData[{
  StyleBox["EdgeMagnitude", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["EdgeMagnitude",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EdgeMagnitude"],

Cell[TextData[{
  StyleBox["EdgeOrientation", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["EdgeOrientation",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EdgeOrientation"],

Cell[TextData[{
  StyleBox["EquirippleFilter", "MR"],
  ", ",
  ButtonBox["EquirippleFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EquirippleFilter"],

Cell["Erosion", "Index",
  CellTags->"Erosion"],

Cell[TextData[{
  "binary, ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Erosion"],

Cell[TextData[{
  "duality with dilation, ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Erosion"],

Cell[TextData[{
  "grayscale, ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Erosion"],

Cell[TextData[{
  "matrix formulation, ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Erosion"],

Cell[TextData[{
  StyleBox["EvenSymmetry", "MR"],
  ", ",
  ButtonBox["EvenSymmetry",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EvenSymmetry"],

Cell[TextData[{
  "Fast Fourier transform (FFT)",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fast Fourier transform"],

Cell[TextData[{
  StyleBox["Filter2D", "MR"],
  ", ",
  ButtonBox["Filter2D",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Filter2D"],

Cell["Filter", "Index",
  CellTags->"Filter"],

Cell[TextData[{
  "Daubechies`",
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "finite impulse response (FIR), ",
  ButtonBox["ImageProcessing 9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "Gaussian, ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "Haar, ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "highpass, ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "Laplacian, ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "linear phase, ",
  ButtonBox["ImageProcessing 9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "moving average, ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "optimal, ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "Savitzky-Golay, ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "smoothing, ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Filter"],

Cell[TextData[{
  "Filtering",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Filtering"],

Cell[TextData[{
  StyleBox["FilterLength", "MR"],
  ", ",
  ButtonBox["FilterLength",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FilterLength"],

Cell[TextData[{
  "Finite impulse response",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Finite impulse response"],

Cell[TextData[{
  "Finite impulse response filter",
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Finite impulse response filter"],

Cell["FIR filter design", "Index",
  CellTags->"FIR filter design"],

Cell[TextData[{
  "equiripple",
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"FIR filter design"],

Cell[TextData[{
  "frequency sampling, ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"FIR filter design"],

Cell[TextData[{
  "window method, ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"FIR filter design"],

Cell[TextData[{
  StyleBox["FixedPad", "MR"],
  ", ",
  ButtonBox["FixedPad",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FixedPad"],

Cell[TextData[{
  "Fixed padding",
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fixed padding"],

Cell[TextData[{
  "Fourier",
  ", ",
  "DTFT",
  ", ",
  ButtonBox["ImageProcessing 8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fourier"],

Cell[TextData[{
  "Fourier matrix",
  ", ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fourier matrix"],

Cell[TextData[{
  StyleBox["FourierMatrix", "MR"],
  ", ",
  ButtonBox["FourierMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FourierMatrix"],

Cell[TextData[{
  "Fourier spectrum",
  ", ",
  ButtonBox["ImageProcessing 8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fourier spectrum"],

Cell[TextData[{
  StyleBox["FreiChenFilter", "MR"],
  ", ",
  ButtonBox["FreiChenFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FreiChenFilter"],

Cell[TextData[{
  StyleBox["FrequencySamplingFilter", "MR"],
  ", ",
  ButtonBox["FrequencySamplingFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FrequencySamplingFilter"],

Cell[TextData[{
  StyleBox["FrequencySamplingGrid", "MR"],
  ", ",
  ButtonBox["FrequencySamplingGrid",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FrequencySamplingGrid"],

Cell[TextData[{
  StyleBox["FrequencyTransformation", "MR"],
  ", ",
  ButtonBox["FrequencyTransformation",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FrequencyTransformation"],

Cell[TextData[{
  StyleBox["FromChannels", "MR"],
  ", ",
  ButtonBox["FromChannels",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FromChannels"],

Cell[TextData[{
  StyleBox["FromSet", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["FromSet",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FromSet"],

Cell[TextData[{
  "Fundamental frequency",
  ", ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fundamental frequency"],

Cell[TextData[{
  "Fundamental interval",
  ", ",
  ButtonBox["ImageProcessing 8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fundamental interval"],

Cell[TextData[{
  StyleBox["GaussianFilter", "MR"],
  ", ",
  ButtonBox["GaussianFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaussianFilter"],

Cell[TextData[{
  "Geometric operations",
  ", ",
  ButtonBox["ImageProcessing 4.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Geometric operations"],

Cell[TextData[{
  "Geometric transformation",
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Geometric transformation"],

Cell[TextData[{
  "Geometric warping",
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Geometric warping"],

Cell[TextData[{
  "GIF",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GIF"],

Cell[TextData[{
  StyleBox["GlobalSet", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["GlobalSet",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GlobalSet"],

Cell["Gradient edge operators", "Index",
  CellTags->"Gradient edge operators"],

Cell[TextData[{
  "Frei-Chen",
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Gradient edge operators"],

Cell[TextData[{
  "Prewitt, ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Gradient edge operators"],

Cell[TextData[{
  "Roberts, ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Gradient edge operators"],

Cell[TextData[{
  "Sobel, ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Gradient edge operators"],

Cell[TextData[{
  StyleBox["GradientType", "MR"],
  ", ",
  ButtonBox["GradientType",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GradientType"],

Cell[TextData[{
  StyleBox["GraphicsRotate", "MR"],
  ", ",
  ButtonBox["GraphicsRotate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphicsRotate"],

Cell[TextData[{
  StyleBox["GrayscaleClose", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["GrayscaleClose",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GrayscaleClose"],

Cell[TextData[{
  StyleBox["GrayscaleDilate", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["GrayscaleDilate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GrayscaleDilate"],

Cell[TextData[{
  StyleBox["GrayscaleErode", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["GrayscaleErode",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GrayscaleErode"],

Cell[TextData[{
  StyleBox["GrayscaleOpen", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["GrayscaleOpen",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GrayscaleOpen"],

Cell[TextData[{
  StyleBox["GrayscaleTopHat", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["GrayscaleTopHat",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GrayscaleTopHat"],

Cell[TextData[{
  StyleBox["GridDensity", "MR"],
  ", ",
  ButtonBox["GridDensity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GridDensity"],

Cell[TextData[{
  StyleBox["HaarFilter", "MR"],
  ", ",
  ButtonBox["HaarFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HaarFilter"],

Cell[TextData[{
  "Hadamard matrix",
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hadamard matrix"],

Cell[TextData[{
  StyleBox["HadamardMatrix", "MR"],
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["HadamardMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HadamardMatrix"],

Cell[TextData[{
  StyleBox["HighpassFilter", "MR"],
  ", ",
  ButtonBox["HighpassFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HighpassFilter"],

Cell[TextData[{
  "Histogram",
  ", ",
  ButtonBox["ImageProcessing 3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Histogram"],

Cell[TextData[{
  "Histogram equalization",
  ", ",
  ButtonBox["ImageProcessing 3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Histogram equalization"],

Cell[TextData[{
  StyleBox["HistogramEqualize", "MR"],
  ", ",
  ButtonBox["HistogramEqualize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HistogramEqualize"],

Cell[TextData[{
  "Histogram features",
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Histogram features"],

Cell[TextData[{
  "Hit-or-miss transform",
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hit-or-miss transform"],

Cell[TextData[{
  "HSV",
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HSV"],

Cell[TextData[{
  StyleBox["ImageData", "MR"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageData"],

Cell[TextData[{
  StyleBox["ImageDataQ", "MR"],
  ", ",
  ButtonBox["ImageDataQ",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageDataQ"],

Cell[TextData[{
  StyleBox["ImageDepth", "MR"],
  ", ",
  ButtonBox["ImageDepth",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageDepth"],

Cell[TextData[{
  StyleBox["ImageDimensions", "MR"],
  ", ",
  ButtonBox["ImageDimensions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageDimensions"],

Cell[TextData[{
  StyleBox["ImageDivide", "MR"],
  ", ",
  ButtonBox["ImageDivide",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageDivide"],

Cell[TextData[{
  StyleBox["ImageEnergy", "MR"],
  ", ",
  ButtonBox["ImageEnergy",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageEnergy"],

Cell[TextData[{
  StyleBox["ImageEntropy", "MR"],
  ", ",
  ButtonBox["ImageEntropy",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageEntropy"],

Cell[TextData[{
  StyleBox["ImageHistogram", "MR"],
  ", ",
  ButtonBox["ImageHistogram",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageHistogram"],

Cell[TextData[{
  StyleBox["ImageMean", "MR"],
  ", ",
  ButtonBox["ImageMean",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageMean"],

Cell[TextData[{
  StyleBox["ImageMedian", "MR"],
  ", ",
  ButtonBox["ImageMedian",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageMedian"],

Cell[TextData[{
  StyleBox["ImageOptions", "MR"],
  ", ",
  ButtonBox["ImageOptions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageOptions"],

Cell[TextData[{
  StyleBox["ImagePlus", "MR"],
  ", ",
  ButtonBox["ImagePlus",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImagePlus"],

Cell[TextData[{
  StyleBox["ImagePower", "MR"],
  ", ",
  ButtonBox["ImagePower",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImagePower"],

Cell[TextData[{
  StyleBox["ImageRange", "MR"],
  ", ",
  ButtonBox["ImageRange",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageRange"],

Cell[TextData[{
  StyleBox["ImageRead", "MR"],
  ", ",
  ButtonBox["ImageRead",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageRead"],

Cell[TextData[{
  StyleBox["ImageRotate", "MR"],
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageRotate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageRotate"],

Cell[TextData[{
  "Image segmentation",
  ", ",
  ButtonBox["ImageProcessing 7.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Image segmentation"],

Cell[TextData[{
  StyleBox["ImageSize", "MR"],
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageSize"],

Cell[TextData[{
  StyleBox["ImageSubtract", "MR"],
  ", ",
  ButtonBox["ImageSubtract",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageSubtract"],

Cell[TextData[{
  StyleBox["ImageTake", "MR"],
  ", ",
  ButtonBox["ImageTake",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageTake"],

Cell[TextData[{
  StyleBox["ImageThread", "MR"],
  ", ",
  ButtonBox["ImageThread",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageThread"],

Cell[TextData[{
  StyleBox["ImageTimes", "MR"],
  ", ",
  ButtonBox["ImageTimes",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageTimes"],

Cell[TextData[{
  StyleBox["ImageVariance", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageVariance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageVariance"],

Cell[TextData[{
  StyleBox["ImageWarp", "MR"],
  ", ",
  ButtonBox["ImageWarp",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageWarp"],

Cell[TextData[{
  StyleBox["ImageWrite", "MR"],
  ", ",
  ButtonBox["ImageWrite",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ImageWrite"],

Cell[TextData[{
  "Impulse response",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Impulse response"],

Cell[TextData[{
  "Intensity profile",
  ", ",
  ButtonBox["ImageProcessing 5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Intensity profile"],

Cell[TextData[{
  StyleBox["Interpolate", "MR"],
  ", ",
  ButtonBox["Interpolate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Interpolate"],

Cell[TextData[{
  "Interpolation",
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Interpolation"],

Cell[TextData[{
  "bilinear, ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Interpolation"],

Cell[TextData[{
  "nearest-neighbor, ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Interpolation"],

Cell[TextData[{
  "zero-order-hold, ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Interpolation"],

Cell[TextData[{
  StyleBox["InverseDiscreteCosineTransform", "MR"],
  ", ",
  ButtonBox["InverseDiscreteCosineTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InverseDiscreteCosineTransform"],

Cell[TextData[{
  StyleBox["IDCT", "MR"],
  ", ",
  ButtonBox["InverseDiscreteCosineTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IDCT"],

Cell[TextData[{
  StyleBox["InverseDiscreteFourierTransform", "MR"],
  ", ",
  ButtonBox["InverseDiscreteFourierTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InverseDiscreteFourierTransform"],

Cell[TextData[{
  StyleBox["IDFT", "MR"],
  ", ",
  ButtonBox["InverseDiscreteFourierTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IDFT"],

Cell[TextData[{
  StyleBox["InverseDiscreteHadamardTransform", "MR"],
  ", ",
  ButtonBox["InverseDiscreteHadamardTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InverseDiscreteHadamardTransform"],

Cell[TextData[{
  StyleBox["IDHT", "MR"],
  ", ",
  ButtonBox["InverseDiscreteHadamardTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IDHT"],

Cell[TextData[{
  "Inverse discrete wavelet transform",
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverse discrete wavelet transform"],

Cell[TextData[{
  StyleBox["InverseDiscreteWaveletTransform", "MR"],
  ", ",
  ButtonBox["InverseDiscreteWaveletTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InverseDiscreteWaveletTransform"],

Cell[TextData[{
  StyleBox["IDWT", "MR"],
  ", ",
  ButtonBox["InverseDiscreteWaveletTransform",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IDWT"],

Cell[TextData[{
  "Joint Photographic Experts Group",
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Joint Photographic Experts Group"],

Cell[TextData[{
  "JPEG",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JPEG"],

Cell[TextData[{
  StyleBox["KaiserLength", "MR"],
  ", ",
  ButtonBox["KaiserLength",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KaiserLength"],

Cell[TextData[{
  StyleBox["KaiserShape", "MR"],
  ", ",
  ButtonBox["KaiserShape",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KaiserShape"],

Cell[TextData[{
  StyleBox["KMeans", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 7.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["KMeans",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KMeans"],

Cell[TextData[{
  StyleBox["KMeansList", "MR"],
  ", ",
  ButtonBox["KMeansList",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KMeansList"],

Cell[TextData[{
  "Kronecker product",
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kronecker product"],

Cell[TextData[{
  StyleBox["KroneckerProduct", "MR"],
  ", ",
  ButtonBox["KroneckerProduct",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KroneckerProduct"],

Cell[TextData[{
  StyleBox["LaplacianFilter", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["LaplacianFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LaplacianFilter"],

Cell[TextData[{
  "Least-squares",
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Least-squares"],

Cell[TextData[{
  "Linear shift invariant filters",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linear shift invariant filters"],

Cell[TextData[{
  StyleBox["LinePlot", "MR"],
  ", ",
  ButtonBox["LinePlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinePlot"],

Cell[TextData[{
  StyleBox["LinePlot3D", "MR"],
  ", ",
  ButtonBox["LinePlot3D",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinePlot3D"],

Cell[TextData[{
  StyleBox["LineProfile", "MR"],
  ", ",
  ButtonBox["LineProfile",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LineProfile"],

Cell[TextData[{
  StyleBox["LineStyle", "MR"],
  ", ",
  ButtonBox["LineStyle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LineStyle"],

Cell[TextData[{
  StyleBox["ListConvolve", "MR"],
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ListConvolve"],

Cell[TextData[{
  StyleBox["ListCorrelate", "MR"],
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ListCorrelate"],

Cell[TextData[{
  StyleBox["LoGFilter", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["LoGFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LoGFilter"],

Cell["Luminance", "Index",
  CellTags->"Luminance"],

Cell[TextData[{
  "compression",
  ", ",
  ButtonBox["ImageProcessing 3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Luminance"],

Cell[TextData[{
  "negation, ",
  ButtonBox["ImageProcessing 3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Luminance"],

Cell[TextData[{
  "stretching, ",
  ButtonBox["ImageProcessing 3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Luminance"],

Cell[TextData[{
  "Mach bands",
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mach bands"],

Cell[TextData[{
  "Magnitude spectrum",
  ", ",
  ButtonBox["ImageProcessing 8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Magnitude spectrum"],

Cell[TextData[{
  "Mallat's algorithm",
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mallat's algorithm"],

Cell[TextData[{
  "Mathematical morphological",
  ", ",
  "gradient",
  ", ",
  ButtonBox["ImageProcessing 6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mathematical morphological"],

Cell[TextData[{
  "Mathematical morphology",
  ", ",
  ButtonBox["ImageProcessing 6.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mathematical morphology"],

Cell[TextData[{
  "reflection, ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mathematical morphology"],

Cell[TextData[{
  "set theory, ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mathematical morphology"],

Cell[TextData[{
  "skeleton, ",
  ButtonBox["ImageProcessing 6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mathematical morphology"],

Cell[TextData[{
  "thinning, ",
  ButtonBox["ImageProcessing 6.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Mathematical morphology"],

Cell[TextData[{
  StyleBox["MatrixJoin", "MR"],
  ", ",
  ButtonBox["MatrixJoin",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatrixJoin"],

Cell[TextData[{
  StyleBox["MatrixThread", "MR"],
  ", ",
  ButtonBox["MatrixThread",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatrixThread"],

Cell[TextData[{
  "McClellan transformation",
  ", ",
  ButtonBox["ImageProcessing 9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"McClellan transformation"],

Cell[TextData[{
  "Meshed color format",
  ", ",
  ButtonBox["ImageProcessing 2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Meshed color format"],

Cell[TextData[{
  StyleBox["MeshedImageData", "MR"],
  ", ",
  ButtonBox["MeshedImageData",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MeshedImageData"],

Cell[TextData[{
  "MGF",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MGF"],

Cell[TextData[{
  StyleBox["MinkowskiDistance", "MR"],
  ", ",
  ButtonBox["MinkowskiDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MinkowskiDistance"],

Cell[TextData[{
  "Monochrome digital image",
  ", ",
  ButtonBox["ImageProcessing 2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Monochrome digital image"],

Cell[TextData[{
  "Motion Picture Experts Group",
  ", ",
  ButtonBox["ImageProcessing 8.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Motion Picture Experts Group"],

Cell[TextData[{
  "Noise reduction",
  ", ",
  ButtonBox["ImageProcessing 5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Noise reduction"],

Cell[TextData[{
  "Nyquist filter",
  ", ",
  ButtonBox["ImageProcessing 9.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nyquist filter"],

Cell["Open", "Index",
  CellTags->"Open"],

Cell[TextData[{
  "binary",
  ", ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Open"],

Cell[TextData[{
  "duality with close, ",
  ButtonBox["ImageProcessing 6.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Open"],

Cell[TextData[{
  "grayscale, ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Open"],

Cell[TextData[{
  StyleBox["OptimumThreshold", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["OptimumThreshold",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OptimumThreshold"],

Cell[TextData[{
  "Orthogonality",
  ", ",
  "basis functions",
  ", ",
  ButtonBox["ImageProcessing 8.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Orthogonality"],

Cell[TextData[{
  "Passband",
  ", ",
  ButtonBox["ImageProcessing 9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Passband"],

Cell[TextData[{
  "PBM",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PBM"],

Cell[TextData[{
  StyleBox["PeriodicPad", "MR"],
  ", ",
  ButtonBox["PeriodicPad",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PeriodicPad"],

Cell[TextData[{
  "Periodic padding",
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Periodic padding"],

Cell[TextData[{
  "PGM",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PGM"],

Cell[TextData[{
  "Phase spectrum",
  ", ",
  ButtonBox["ImageProcessing 8.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Phase spectrum"],

Cell[TextData[{
  "Pixel",
  ", ",
  ButtonBox["ImageProcessing 2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pixel"],

Cell[TextData[{
  "Pixel-interleaved format",
  ", ",
  ButtonBox["ImageProcessing 2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pixel-interleaved format"],

Cell[TextData[{
  StyleBox["PixelInterleave", "MR"],
  ", ",
  ButtonBox["PixelInterleave",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PixelInterleave"],

Cell[TextData[{
  "Planar color format",
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Planar color format"],

Cell[TextData[{
  StyleBox["PlanarImageData", "MR"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlanarImageData"],

Cell[TextData[{
  "PNG",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PNG"],

Cell[TextData[{
  "PNM",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PNM"],

Cell[TextData[{
  "Point operations",
  ", ",
  ButtonBox["ImageProcessing 3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Point operations"],

Cell[TextData[{
  StyleBox["PointStyle", "MR"],
  ", ",
  ButtonBox["PointStyle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PointStyle"],

Cell[TextData[{
  "PPM",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PPM"],

Cell[TextData[{
  StyleBox["PrewittFilter", "MR"],
  ", ",
  ButtonBox["PrewittFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PrewittFilter"],

Cell[TextData[{
  "Primary colors",
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Primary colors"],

Cell[TextData[{
  "Pseudoinverse",
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pseudoinverse"],

Cell[TextData[{
  "PSImage",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PSImage"],

Cell[TextData[{
  "Quantization",
  ", ",
  ButtonBox["ImageProcessing 3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Quantization"],

Cell[TextData[{
  "Quantization table",
  ", ",
  ButtonBox["ImageProcessing 8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Quantization table"],

Cell[TextData[{
  StyleBox["Raster", "MR"],
  ", ",
  ButtonBox["ImageProcessing 2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Raster"],

Cell[TextData[{
  StyleBox["RawImageData", "MR"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RawImageData"],

Cell[TextData[{
  StyleBox["Reflect", "MR"],
  ", ",
  ButtonBox["Reflect",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Reflect"],

Cell[TextData[{
  "Reflection",
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Reflection"],

Cell[TextData[{
  StyleBox["RegionArea", "MR"],
  ", ",
  ButtonBox["RegionArea",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RegionArea"],

Cell[TextData[{
  StyleBox["RegionBorder", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["RegionBorder",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RegionBorder"],

Cell[TextData[{
  StyleBox["RegionCenter", "MR"],
  ", ",
  ButtonBox["RegionCenter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RegionCenter"],

Cell[TextData[{
  StyleBox["RegionCircle", "MR"],
  ", ",
  ButtonBox["RegionCircle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RegionCircle"],

Cell[TextData[{
  "Region-of-interest processing",
  ", ",
  ButtonBox["ImageProcessing 5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Region-of-interest processing"],

Cell[TextData[{
  StyleBox["RegionPoints", "MR"],
  ", ",
  ButtonBox["RegionPoints",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RegionPoints"],

Cell[TextData[{
  StyleBox["RegionProcessing", "MR"],
  ", ",
  ButtonBox["RegionProcessing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RegionProcessing"],

Cell[TextData[{
  StyleBox["RegionRectangle", "MR"],
  ", ",
  ButtonBox["RegionRectangle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RegionRectangle"],

Cell[TextData[{
  "Remez exchange algorithm",
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Remez exchange algorithm"],

Cell[TextData[{
  StyleBox["Replicate", "MR"],
  ", ",
  ButtonBox["Replicate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Replicate"],

Cell[TextData[{
  StyleBox["Resize", "MR"],
  ", ",
  ButtonBox["Resize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Resize"],

Cell["Resolution", "Index",
  CellTags->"Resolution"],

Cell[TextData[{
  "luminance",
  ", ",
  ButtonBox["ImageProcessing 3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Resolution"],

Cell[TextData[{
  "spatial, ",
  ButtonBox["ImageProcessing 2.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Resolution"],

Cell[TextData[{
  "RGB",
  ", ",
  ButtonBox["ImageProcessing 2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RGB"],

Cell[TextData[{
  StyleBox["RobertsFilter", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["RobertsFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RobertsFilter"],

Cell[TextData[{
  "Rotation",
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Rotation"],

Cell[TextData[{
  "Row profile",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Row profile"],

Cell[TextData[{
  StyleBox["RowThread", "MR"],
  ", ",
  ButtonBox["RowThread",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RowThread"],

Cell[TextData[{
  "Scaling filter",
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Scaling filter"],

Cell[TextData[{
  StyleBox["ScalingSequence", "MR"],
  ", ",
  ButtonBox["ScalingSequence",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScalingSequence"],

Cell[TextData[{
  "Secondary colors",
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Secondary colors"],

Cell[TextData[{
  StyleBox["Sequency", "MR"],
  ", ",
  ButtonBox["Sequency",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sequency"],

Cell[TextData[{
  "Sequency",
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sequency"],

Cell[TextData[{
  StyleBox["SequencyOrdered", "MR"],
  ", ",
  ButtonBox["SequencyOrdered",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SequencyOrdered"],

Cell[TextData[{
  "Set complement",
  ", ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Set complement"],

Cell[TextData[{
  "Set description",
  ", ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Set description"],

Cell[TextData[{
  StyleBox["ShowImageHistogram", "MR"],
  ", ",
  ButtonBox["ShowImageHistogram",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 3.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowImageHistogram"],

Cell[TextData[{
  StyleBox["ShowImageWarp", "MR"],
  ", ",
  ButtonBox["ShowImageWarp",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowImageWarp"],

Cell[TextData[{
  StyleBox["ShowLineProfile", "MR"],
  ", ",
  ButtonBox["ShowLineProfile",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowLineProfile"],

Cell[TextData[{
  StyleBox["ShowRegionOfInterest", "MR"],
  ", ",
  ButtonBox["ShowRegionOfInterest",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowRegionOfInterest"],

Cell[TextData[{
  "Signal-to-noise ratio",
  ", ",
  ButtonBox["ImageProcessing 5.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.7",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Signal-to-noise ratio"],

Cell[TextData[{
  "Similarity",
  ", ",
  ButtonBox["ImageProcessing 7.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Similarity"],

Cell[TextData[{
  StyleBox["SmoothingFilter", "MR"],
  ", ",
  ButtonBox["SmoothingFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SmoothingFilter"],

Cell[TextData[{
  StyleBox["SobelFilter", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SobelFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SobelFilter"],

Cell[TextData[{
  StyleBox["SqrtDistance", "MR"],
  ", ",
  ButtonBox["SqrtDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SqrtDistance"],

Cell[TextData[{
  "Stopband",
  ", ",
  ButtonBox["ImageProcessing 9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stopband"],

Cell[TextData[{
  StyleBox["CMYKtoGray", "MR"],
  ", ",
  ButtonBox["CMYKtoGray",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CMYKtoGray"],

Cell[TextData[{
  StyleBox["CMYKtoRGB", "MR"],
  ", ",
  ButtonBox["CMYKtoRGB",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CMYKtoRGB"],

Cell[TextData[{
  StyleBox["HSVtoGray", "MR"],
  ", ",
  ButtonBox["HSVtoGray",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HSVtoGray"],

Cell[TextData[{
  StyleBox["HSVtoRGB", "MR"],
  ", ",
  ButtonBox["HSVtoRGB",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HSVtoRGB"],

Cell[TextData[{
  StyleBox["RGBtoCMYK", "MR"],
  ", ",
  ButtonBox["RGBtoCMYK",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RGBtoCMYK"],

Cell[TextData[{
  StyleBox["RGBtoGray", "MR"],
  ", ",
  ButtonBox["RGBtoGray",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RGBtoGray, MR"],

Cell[TextData[{
  StyleBox["RGBtoHSV", "MR"],
  ", ",
  ButtonBox["RGBtoHSV",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RGBtoHSV"],

Cell[TextData[{
  StyleBox["ScaleClip", "MR"],
  ", ",
  ButtonBox["ScaleClip",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScaleClip"],

Cell[TextData[{
  StyleBox["ScaleLinear", "MR"],
  ", ",
  ButtonBox["ScaleLinear",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScaleLinear"],

Cell[TextData[{
  StyleBox["ScalePiecewiseLinear", "MR"],
  ", ",
  ButtonBox["ImageProcessing 3.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ScalePiecewiseLinear",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ScalePiecewiseLinear"],

Cell[TextData[{
  StyleBox["Threshold", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Threshold",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Threshold"],

Cell[TextData[{
  StyleBox["ToCMYKColor", "MR"],
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ToCMYKColor",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToCMYKColor"],

Cell[TextData[{
  StyleBox["ToGrayLevel", "MR"],
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ToGrayLevel",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToGrayLevel"],

Cell[TextData[{
  StyleBox["ToHSVColor", "MR"],
  ", ",
  ButtonBox["ImageProcessing 3.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ToHSVColor",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToHSVColor"],

Cell[TextData[{
  StyleBox["ToRGBColor", "MR"],
  ", ",
  ButtonBox["ImageProcessing 3.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ToRGBColor",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToRGBColor"],

Cell[TextData[{
  StyleBox["UniformQuantizer", "MR"],
  ", ",
  ButtonBox["ImageProcessing 3.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["UniformQuantizer",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UniformQuantizer"],

Cell[TextData[{
  "Thresholding",
  ", ",
  ButtonBox["ImageProcessing 7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Thresholding"],

Cell[TextData[{
  "Threshold",
  ", ",
  "optimum",
  ", ",
  ButtonBox["ImageProcessing 7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Threshold"],

Cell[TextData[{
  "TIFF",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TIFF"],

Cell[TextData[{
  StyleBox["ToChannels", "MR"],
  ", ",
  ButtonBox["ImageProcessing 2.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToChannels"],

Cell[TextData[{
  "Toeplitz matrix",
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Toeplitz matrix"],

Cell[TextData[{
  StyleBox["ToeplitzMatrix", "MR"],
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ToeplitzMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToeplitzMatrix"],

Cell[TextData[{
  "Top-hat transformation",
  ", ",
  ButtonBox["ImageProcessing 6.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Top-hat transformation"],

Cell[TextData[{
  StyleBox["ToSet", "MR"],
  ", ",
  ButtonBox["ImageProcessing 6.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ToSet",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToSet"],

Cell[TextData[{
  StyleBox["TransientSamples", "MR"],
  ", ",
  ButtonBox["TransientSamples",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TransientSamples"],

Cell[TextData[{
  "Transition band",
  ", ",
  ButtonBox["ImageProcessing 9.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transition band"],

Cell[TextData[{
  "Unitary matrices",
  ", ",
  ButtonBox["ImageProcessing 8.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unitary matrices"],

Cell[TextData[{
  StyleBox["UnsharpFilter", "MR"],
  ", ",
  ButtonBox["UnsharpFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UnsharpFilter"],

Cell[TextData[{
  StyleBox["UnsharpRatio", "MR"],
  ", ",
  ButtonBox["UnsharpRatio",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UnsharpRatio"],

Cell[TextData[{
  "Unsharp masking",
  ", ",
  ButtonBox["ImageProcessing 5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unsharp masking"],

Cell[TextData[{
  StyleBox["UpSample", "MR"],
  ", ",
  ButtonBox["UpSample",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UpSample"],

Cell[TextData[{
  "Upsampling",
  ", ",
  ButtonBox["ImageProcessing 4.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Upsampling"],

Cell[TextData[{
  "Walsh functions",
  ", ",
  ButtonBox["ImageProcessing 8.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Walsh functions"],

Cell[TextData[{
  StyleBox["WarpMatrix", "MR"],
  ", ",
  ButtonBox["ImageProcessing 4.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["WarpMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WarpMatrix"],

Cell[TextData[{
  StyleBox["WaveletDensityPlot", "MR"],
  ", ",
  ButtonBox["WaveletDensityPlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WaveletDensityPlot"],

Cell[TextData[{
  "Wavelet filter",
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Wavelet filter"],

Cell[TextData[{
  StyleBox["WaveletFlatten", "MR"],
  ", ",
  ButtonBox["WaveletFlatten",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WaveletFlatten"],

Cell[TextData[{
  "Wavelet matrix",
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Wavelet matrix"],

Cell[TextData[{
  StyleBox["WaveletMatrix", "MR"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["WaveletMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WaveletMatrix"],

Cell[TextData[{
  StyleBox["WaveletPartition", "MR"],
  ", ",
  ButtonBox["WaveletPartition",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WaveletPartition"],

Cell[TextData[{
  StyleBox["WaveletSequence", "MR"],
  ", ",
  ButtonBox["WaveletSequence",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 8.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WaveletSequence"],

Cell[TextData[{
  StyleBox["Where", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Where",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Where"],

Cell[TextData[{
  StyleBox["WindowFilter", "MR"],
  ", ",
  ButtonBox["WindowFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WindowFilter"],

Cell[TextData[{
  StyleBox["WindowFilter2D", "MR"],
  ", ",
  ButtonBox["WindowFilter2D",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WindowFilter2D"],

Cell["Windows", "Index",
  CellTags->"Windows"],

Cell[TextData[{
  "adjustable",
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Windows"],

Cell[TextData[{
  "Blackman-Harris, ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Windows"],

Cell[TextData[{
  "Hamming, ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Windows"],

Cell[TextData[{
  "Kaiser, ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Windows"],

Cell[TextData[{
  "rectangular, ",
  ButtonBox["ImageProcessing 9.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Windows"],

Cell[TextData[{
  "XBitmap",
  ", ",
  ButtonBox["ImageProcessing 2.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"XBitmap"],

Cell[TextData[{
  StyleBox["ZeroCrossing", "MR"],
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ZeroCrossing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroCrossing"],

Cell[TextData[{
  "Zero-crossings",
  ", ",
  ButtonBox["ImageProcessing 7.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero-crossings"],

Cell[TextData[{
  StyleBox["ZeroPad", "MR"],
  ", ",
  ButtonBox["ZeroPad",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroPad"],

Cell[TextData[{
  "Zero padding",
  ", ",
  ButtonBox["ImageProcessing 4.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero padding"],

Cell[TextData[{
  StyleBox["$ImageDataDirectory", "MR"],
  ", ",
  ButtonBox["$ImageDataDirectory",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing AppendixA",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ImageProcessing QuickTour",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$ImageDataDirectory"],

Cell[TextData[{
  StyleBox["$ImageTopDirectory", "MR"],
  ", ",
  ButtonBox["$ImageToDirectory",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Digital Image Processing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"$ImageTopDirectory"]
}, Closed]],

Cell[CellGroupData[{

Cell["Fuzzy Logic", "IndexSection",
  CellTags->{
  "AbsoluteDifference", "absorption by empty set", "addition", "aggregators", 
    "alpha cuts", "AlphaLevelSet", "ArithmeticMean", "associativity", 
    "averaging formula", "averaging operations", "bell shaped fuzzy sets", 
    "binary fuzzy relation", "binary fuzzy relations", "BisectorOfArea", 
    "BuildModel", "cardinality", "Cardinality", "CenterOfArea", 
    "characteristic function", "Chop", "clustering", "clustering algorithm", 
    "clustering functions", "commutativity", "comparability", "complement", 
    "Complement", "complementation", "composition", "Composition", 
    "CompositionBasedInference", "composition of fuzzy relations", 
    "composition of relations", "compositions of fuzzy relations", 
    "concentrate", "Concentrate", "contradiction, law of ", "contrast", 
    "control surface", "core", "CreateFuzzyRelation", "CreateFuzzySet", 
    "CreateFuzzySets", "creating digital fuzzy sets", 
    "creating fuzzy numbers", "creating fuzzy relations", 
    "creating fuzzy sets", "creating Ln sets", 
    "creating \[CapitalLSlash]ukasiewicz sets", "Crisp", "crisp sets", 
    "defuzzification", "difference", "Difference", "difference of fuzzy sets",
     "difference operations", "digital fuzzy sets", "DigitalSet", "dilate", 
    "Dilate", "dilation of membership grades", "discrete fuzzy arithmetic", 
    "DiscreteFuzzyImage", "DiscreteFuzzyMinus", "DiscreteFuzzyMultiply", 
    "DiscreteFuzzyPlus", "distributivity", "division", "Dombi", 
    "double-sided gaussian fuzzy set", "DuboisPrade", "empty set", "equality",
     "Equality", "EquilibriumSet", "FCMCluster", 
    "FCM (fuzzy C-means clustering)", "FirstProjection", 
    "first projection of fuzzy relation", "Frank", "FromMembershipMatrix", 
    "fuzzy arithmetic", "fuzzy arithmetic operations", " FuzzyBell", 
    "fuzzy cardinality", "FuzzyCardinality", "fuzzy clustering", 
    "fuzzy clusters", "fuzzy C-means clustering", "FuzzyConstantTimes", 
    "fuzzy control", "FuzzyDivide", "FuzzyGaussian", "FuzzyGraph", 
    "FuzzyImage", "fuzzy logic control", "Fuzzy Logic Index", "FuzzyMinus", 
    "fuzzy modelling", "FuzzyModify", "FuzzyMultiply", "fuzzy numbers", 
    "fuzzy operations", "fuzzy operations ", "fuzzy operator formulas", 
    "fuzzy operators", "FuzzyPlot", "FuzzyPlot3D", "FuzzyPlus", 
    " fuzzy relation", "fuzzy relation", "FuzzyRelation", "fuzzy relations", 
    "fuzzy set", "FuzzySet", "fuzzy sets", "FuzzySigmoid", "FuzzySurfacePlot",
     "FuzzyTrapezoid", "FuzzyTwoGaussian", "gaussian fuzzy numbers", 
    "GeneralAggregator", "GeometricMean", "GlobalProjection", "Hamacher", 
    "HammingDistance", "HarmonicMean", "Height", "idempotence", "identity", 
    "image of a fuzzy number", "implication", "Implication", "Included", 
    "inclusion", "inference", "InitializeU", "intensify contrast", 
    "IntensifyContrast", "intersection", "Intersection", 
    "intersection formulas", "intersection operations", "LargestOfMax", 
    "LevelSet", " Ln sets, creating", "Ln sets, operations on", "logic", 
    "\[CapitalLSlash]ukasiewicz logic", "\[CapitalLSlash]ukasiewicz sets", 
    "Mamdani", "MAX", "MaxMin", "MaxProduct", "MaxStar", "mean", "MeanOfMax", 
    "membership function", "membership matrix", "MIN", "multiplication", 
    "multiplication by a constant", "multivalued logic", "normalize", 
    "Normalize", "n valued logic", "operations", 
    "operations on gaussian fuzzy numbers", "operations on Ln sets", 
    "operations on \[CapitalLSlash]ukasiewicz sets", 
    "operations on triangular fuzzy numbers", "PlotJoined", "PrimitiveMatrix",
     "product", "product type", "projections of fuzzy relation", 
    "RandomFuzzyRelation", "RandomFuzzySet", "RelativeCardinality", 
    "RuleBasedInference", "SecondProjection", 
    "second projection of fuzzy relation", "sets", "SetsToRelation", 
    "ShowCenterProgression", "ShowCenters", "ShowDots", "ShowGraph", 
    "sigmoidal fuzzy sets", "SmallestOfMax", "s-norm operations", 
    "StrongAlphaLevel", "StrongAlphaLevelSet", "StyleBox[Core]", 
    "StyleBox[excluded middle, law of , Text]", "StyleBox[HammingDistance]", 
    "subsethood", "Subsethood", "subtraction", "Sugeno", "sum", "sum type", 
    "Support", "SymmetricDifference", "t-norm", "t-norm operations", 
    "ToDigital", "ToMembershipMatrix", "triangular fuzzy numbers", 
    "two-sided gaussian fuzzy set", "union", "Union", "union formulas", 
    "union operations", "universal set", "universal space", "UniversalSpace", 
    "user-defined aggregators", "visualization", "vizualization", "Yager"}],

Cell[TextData[{
  StyleBox["AbsoluteDifference", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"AbsoluteDifference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "absorption by empty set",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"absorption by empty set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "addition",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"addition", "Fuzzy Logic Index"}],

Cell[TextData[{
  "aggregators",
  ", ",
  "user-defined",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"aggregators", "Fuzzy Logic Index"}],

Cell[TextData[{
  "alpha cuts",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"alpha cuts", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["AlphaLevelSet", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"AlphaLevelSet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "associativity",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"associativity", "Fuzzy Logic Index"}],

Cell[TextData[{
  "averaging \n\tformula",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"averaging formula", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"averaging operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "bell shaped fuzzy sets, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"bell shaped fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "binary fuzzy relation",
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"binary fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t antisymmetry, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"binary fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "binary fuzzy relations, \n\treflexivity, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"binary fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsymmetry, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"binary fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\ttransivity, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"binary fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["BisectorOfArea", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"BisectorOfArea", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"BisectorOfArea", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["BuildModel", "MR"],
  ", ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"BuildModel", "Fuzzy Logic Index"}],

Cell[TextData[{
  "cardinality, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  "\n\tfuzzy, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"cardinality", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trelative, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"cardinality", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Cardinality", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Cardinality", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["CenterOfArea", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"CenterOfArea", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"CenterOfArea", "Fuzzy Logic Index"}],

Cell[TextData[{
  "characteristic function",
  ", ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"characteristic function", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["ChopValue", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Chop", "Fuzzy Logic Index"}],

Cell[TextData[{
  "clustering",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"clustering", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\talgorithm, ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"clustering algorithm", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfunctions, ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"clustering functions", "Fuzzy Logic Index"}],

Cell[TextData[{
  "commutativity",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"commutativity", "Fuzzy Logic Index"}],

Cell[TextData[{
  "comparability",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"comparability", "Fuzzy Logic Index"}],

Cell[TextData[{
  "complement",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"complement", "Fuzzy Logic Index"}],

Cell[TextData[{
  "complement",
  ", ",
  "\[CapitalLSlash]ukasiewicz sets",
  ", ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"complement", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Complement", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Complement", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tLn sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Complement", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t\[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Complement", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Complement", "Fuzzy Logic Index"}],

Cell[TextData[{
  "complementation",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"complementation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "composition",
  ", ",
  ButtonBox["Compositions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"composition", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfuzzy relations, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"composition of relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfuzzy relations, max-min, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"composition of fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfuzzy relations, max-star, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"compositions of fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Composition", "MR"],
  ", ",
  ButtonBox["Fuzzy Compositions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Composition", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Compositions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Composition", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["CompositionBasedInference", "MR"],
  ", ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"CompositionBasedInference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "concentrate",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"concentrate", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Concentrate", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Additional Examples",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Concentrate", "Fuzzy Logic Index"}],

Cell[TextData[{
  "contradiction, law of, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"contradiction, law of ", "Fuzzy Logic Index"}],

Cell[TextData[{
  "contrast",
  ", ",
  "intensify",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"contrast", "Fuzzy Logic Index"}],

Cell[TextData[{
  "contrast",
  ", ",
  "intensifying",
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"contrast", "Fuzzy Logic Index"}],

Cell[TextData[{
  "control surface",
  ", ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"control surface", "Fuzzy Logic Index"}],

Cell[TextData[{
  "core",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"core", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Core", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"StyleBox[Core]", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["CreateFuzzyRelation", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"CreateFuzzyRelation", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["CreateFuzzySet", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"CreateFuzzySet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"CreateFuzzySet", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["CreateFuzzySets", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"CreateFuzzySets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "creating,\n\tdigital fuzzy sets, ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"creating digital fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfuzzy numbers, ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"creating fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfuzzy relations, ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"creating fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfuzzy sets, ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"creating fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tLn sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"creating Ln sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t\[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"creating \[CapitalLSlash]ukasiewicz sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Crisp", "MR"],
  ", ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Crisp", "Fuzzy Logic Index"}],

Cell[TextData[{
  "crisp sets",
  ", ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"crisp sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "defuzzification",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"defuzzification", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tbisector of area, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"defuzzification", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcenter of area, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"defuzzification", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tlargest of maximum, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"defuzzification", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmean of maximum, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"defuzzification", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsmallest of maximum, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"defuzzification", "Fuzzy Logic Index"}],

Cell[TextData[{
  "difference",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"difference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tof fuzzy sets, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"difference of fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tof fuzzy sets, properties, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"difference of fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"difference operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Difference", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Difference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "digital fuzzy sets",
  ", ",
  "creating",
  ", ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"digital fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["DigitalSet", "MR"],
  ", ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"DigitalSet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "dilate",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"dilate", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Dilate", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Additional Examples",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Dilate", "Fuzzy Logic Index"}],

Cell[TextData[{
  "dilation of membership grades",
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"dilation of membership grades", "Fuzzy Logic Index"}],

Cell[TextData[{
  "discrete fuzzy arithmetic",
  ", ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"discrete fuzzy arithmetic", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["DiscreteFuzzyImage", "MR"],
  ", ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"DiscreteFuzzyImage", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["DiscreteFuzzyMinus", "MR"],
  ", ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"DiscreteFuzzyMinus", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["DiscreteFuzzyMultiply", "MR"],
  ", ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"DiscreteFuzzyMultiply", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["DiscreteFuzzyPlus", "MR"],
  ", ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"DiscreteFuzzyPlus", "Fuzzy Logic Index"}],

Cell[TextData[{
  "distributivity",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"distributivity", "Fuzzy Logic Index"}],

Cell[TextData[{
  "division",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"division", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Dombi", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Dombi", "Fuzzy Logic Index"}],

Cell[TextData[{
  "double-sided ",
  "Gaussian",
  " fuzzy set, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"double-sided gaussian fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["DuboisPrade", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"DuboisPrade", "Fuzzy Logic Index"}],

Cell[TextData[{
  "empty set",
  ", ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"empty set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "equality",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"equality", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Equality", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Equality", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["EquilibriumSet", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"EquilibriumSet", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["excluded middle, law of", "Text"],
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"StyleBox[excluded middle, law of , Text]", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FCMCluster", "MR"],
  ", ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FCMCluster", "Fuzzy Logic Index"}],

Cell[TextData[{
  "FCM (fuzzy C-means clustering)",
  ", ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FCM (fuzzy C-means clustering)", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FirstProjection", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FirstProjection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "first projection of fuzzy relation",
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"first projection of fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Frank", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Frank", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FromMembershipMatrix", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FromMembershipMatrix", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy arithmetic",
  ", ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy arithmetic", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy arithmetic operations",
  ", \n\t",
  "addition",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy arithmetic operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdivision, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy arithmetic operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmultiplication, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy arithmetic operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmultiplication by a constant, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy arithmetic operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsubtraction, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy arithmetic operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tusing infix form, ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy arithmetic", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyArithmeticMean", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"ArithmeticMean", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyBell", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{" FuzzyBell", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy cardinality",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy cardinality", "Fuzzy Logic Index"}],

Cell[TextData[{
  "FuzzyCardinality, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyCardinality", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy clustering",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy clustering", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy clusters",
  ", ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy clusters", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy C-means clustering",
  ", ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy C-means clustering", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyConstantTimes", "MR"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyConstantTimes", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy control",
  ", ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy control", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcontrol surface, ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy control", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdefining control rules, ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy control", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdefining input membership functions, ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy control", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdefining output membership functions, ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy control", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsimulation functions, ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy control", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyDivide", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyDivide", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyGaussian", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyGaussian", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyGeometricMean", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"GeometricMean", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyGraph", "MR"],
  ", ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyGraph", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyHarmonicMean", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"HarmonicMean", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyImage", "MR"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyImage", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy logic control",
  ", ",
  ButtonBox["Fuzzy Logic Control",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy logic control", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyMinus", "MR"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyMinus", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy modeling,\n\tbuilding the model, ",
  ButtonBox["Fuzzy Modeling",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy modelling", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcreating linguistic control rules, ",
  ButtonBox["Fuzzy Modeling",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy modelling", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tevaluating the model, ",
  ButtonBox["Fuzzy Modeling",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy modelling", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trepresenting the model input, ",
  ButtonBox["Fuzzy Modeling",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy modelling", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trepresenting the model output, ",
  ButtonBox["Fuzzy Modeling",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy modelling", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tusing the model, ",
  ButtonBox["Fuzzy Modeling",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy modelling", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyModify", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyModify", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyMultiply", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyMultiply", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy numbers",
  ", ",
  ButtonBox["Fuzzy Numbers",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\taddition, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdivision, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\timage, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmultiplication, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmultiplication by a constant, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsubtraction, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy operations",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trelations, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy operations ", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy operator formulas",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy operator formulas", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy operators",
  ", \n\t",
  "complement",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy operators", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdilate, ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy operators", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tintensify contrast, ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy operators", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tnormalize, ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy operators", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyPlot", "MR"],
  ", ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyPlot", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyPlot", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyPlot3D", "MR"],
  ", ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyPlot3D", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyPlot3D", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyPlus", "MR"],
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyPlus", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy relation",
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tbinary, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomplement, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tenvelope, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tequations, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfirst projection, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tnormalized, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tprojections, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trandom, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsecond projection, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{" fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyRelation", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyRelation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyRelation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy relations",
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tabsolute difference, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\talgebraic product, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tbasic objects, ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomposition, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcompositions, ",
  ButtonBox["Compositions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcreating, ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdifference, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdisjunctive sum, ",
  ButtonBox["Additional Examples",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdistinctions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tgeneral aggregator, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tHamming distance, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t",
  StyleBox["HammingDistance", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tintersection, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsubsethood, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsymmetric difference, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tunion, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tuniversal space, ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tvisualization, ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy relations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy set",
  ", \n\t",
  "cardinality",
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcore, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tequilibrium, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmodifying, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tnormalized, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trandom, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsigmoidal, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsupport, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzySet", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzySet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdefinition, ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzySet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzySet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "fuzzy sets",
  ", \n\t",
  "absolute difference",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tbasic objects, ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t",
  "bell-shaped, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomplementation, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdifference, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdistinctions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdouble-sided ",
  "Gaussian",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tequality, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tgeneral aggregator, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t",
  "Hamming distance",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t",
  StyleBox["Hamming distance", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tintersection, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsubsethood, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsymmetric difference, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tunion, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tvisualization, ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzySigmoid", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzySigmoid", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzySurfacePlot", "MR"],
  ", ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzySurfacePlot", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyTrapezoid", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyTrapezoid", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["FuzzyTwoGaussian", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"FuzzyTwoGaussian", "Fuzzy Logic Index"}],

Cell[TextData[{
  "Gaussian",
  " fuzzy numbers, image, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"gaussian fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["GeneralAggregator", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"GeneralAggregator", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["GlobalProjection", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"GlobalProjection", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Hamacher", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Hamacher", "Fuzzy Logic Index"}],

Cell[TextData[{
  "Hamming Distance",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"StyleBox[HammingDistance]", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["HammingDistance", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"HammingDistance", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Height", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Height", "Fuzzy Logic Index"}],

Cell[TextData[{
  "idempotence",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"idempotence", "Fuzzy Logic Index"}],

Cell[TextData[{
  "identity",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"identity", "Fuzzy Logic Index"}],

Cell[TextData[{
  "image of a fuzzy number",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"image of a fuzzy number", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Implication", "MR"],
  ", Ln sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Implication", "Fuzzy Logic Index"}],

Cell[TextData[{
  "implication, \[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"implication", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Included", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Included", "Fuzzy Logic Index"}],

Cell[TextData[{
  "inclusion",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inclusion", "Fuzzy Logic Index"}],

Cell[TextData[{
  "inference",
  ", ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomposition based, building model, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomposition based, defining inputs, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomposition based, defining outputs, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomposition based, defining rules, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcomposition based, inferencing, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfunctions, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trule based, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trule based, defining inputs, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trule based, defining outputs, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trule based, defining rules, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\trule based, inferencing, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"inference", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["InitializeU", "MR"],
  ", ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"InitializeU", "Fuzzy Logic Index"}],

Cell[TextData[{
  "intensify contrast",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"intensify contrast", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["IntensifyContrast", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"IntensifyContrast", "Fuzzy Logic Index"}],

Cell[TextData[{
  "intersection",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tformulas, ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"intersection formulas", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t\[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"intersection operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tproperties, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Intersection", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tLn sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t\[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "intersection",
  ", ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"intersection", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["LargestOfMax", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"LargestOfMax", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"LargestOfMax", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["LevelSet", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"LevelSet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "Ln sets, \n\tcreating, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{" Ln sets, creating", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations on, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Ln sets, operations on", "Fuzzy Logic Index"}],

Cell[TextData[{
  "logic",
  ", \n\t",
  "\[CapitalLSlash]ukasiewicz ",
  ", ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"logic", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmultivalued, ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"logic", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\[CapitalLSlash]ukasiewicz logic",
  ", ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"\[CapitalLSlash]ukasiewicz logic", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\[CapitalLSlash]ukasiewicz sets",
  ", \n\t",
  "creating",
  ", ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"\[CapitalLSlash]ukasiewicz sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations on, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"\[CapitalLSlash]ukasiewicz sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Mamdani", "MR"],
  ", ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Mamdani", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["MAX", "MR"],
  ", ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MAX", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["MaxMin", "MR"],
  ", ",
  ButtonBox["Compositions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MaxMin", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["MaxProduct", "MR"],
  ", ",
  ButtonBox["Compositions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MaxProduct", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["MaxStar", "MR"],
  ", ",
  ButtonBox["Compositions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MaxStar", "Fuzzy Logic Index"}],

Cell[TextData[{
  "mean",
  ", \n\t",
  "arithmetic",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"mean", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tgeometric, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"mean", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tharmonic, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"mean", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["MeanOfMax", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MeanOfMax", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MeanOfMax", "Fuzzy Logic Index"}],

Cell[TextData[{
  "membership,\n\tfunction, ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"membership function", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmatrix, ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"membership matrix", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["MIN", "MR"],
  ", ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MIN", "Fuzzy Logic Index"}],

Cell[TextData[{
  "multiplication",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"multiplication", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tby a constant, ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"multiplication by a constant", "Fuzzy Logic Index"}],

Cell[TextData[{
  "multivalued logic",
  ", ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"multivalued logic", "Fuzzy Logic Index"}],

Cell[TextData[{
  "normalize",
  ", ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"normalize", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Normalize", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Normalize", "Fuzzy Logic Index"}],

Cell[TextData[{
  "n-",
  "valued logic, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"n valued logic", "Fuzzy Logic Index"}],

Cell[TextData[{
  "operations",
  ", \n\t",
  "averaging",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdifference, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tintersection, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\ton Ln sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on Ln sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\ton \[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{
  "operations on \[CapitalLSlash]ukasiewicz sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\ts-norm, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tt-norm, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tunion, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "operations on ",
  "Gaussian",
  " fuzzy numbers, \n\taddition, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on gaussian fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmultiplication, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on gaussian fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsubtraction, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on gaussian fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "operations on triangular fuzzy numbers, \n\t",
  "addition, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on triangular fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmaximum, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on triangular fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tminimum, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on triangular fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tmultiplication, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on triangular fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tsubtraction, ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"operations on triangular fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["PlotJoined", "MR"],
  ", ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"PlotJoined", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["PrimitiveMatrix", "MR"],
  ", ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"PrimitiveMatrix", "Fuzzy Logic Index"}],

Cell[TextData[{
  "product",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"product", "Fuzzy Logic Index"}],

Cell[TextData[{
  "product type",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"product type", "Fuzzy Logic Index"}],

Cell[TextData[{
  "projections of fuzzy relation",
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"projections of fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["RandomFuzzyRelation", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"RandomFuzzyRelation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"RandomFuzzyRelation", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["RandomFuzzySet", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"RandomFuzzySet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"RandomFuzzySet", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["RelativeCardinality", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"RelativeCardinality", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["RuleBasedInference", "MR"],
  ", ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"RuleBasedInference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Inferencing",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"RuleBasedInference", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["SecondProjection", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"SecondProjection", "Fuzzy Logic Index"}],

Cell[TextData[{
  "second projection of fuzzy relation",
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"second projection of fuzzy relation", "Fuzzy Logic Index"}],

Cell[TextData[{
  "set, ",
  ButtonBox["\n",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  "\tcomplement, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "sets, \n\tcomparable, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tequal, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tgraphic representation, ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tinclusion, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["SetsToRelation", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"SetsToRelation", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["ShowCenterProgression", "MR"],
  ", ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"ShowCenterProgression", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["ShowCenters", "MR"],
  ", ",
  ButtonBox["Fuzzy Clustering",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"ShowCenters", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["ShowDots", "MR"],
  ", ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"ShowDots", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["ShowGraph", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"ShowGraph", "Fuzzy Logic Index"}],

Cell[TextData[{
  "sigmoidal fuzzy sets",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sigmoidal fuzzy sets", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["SmallestOfMax", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"SmallestOfMax", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"SmallestOfMax", "Fuzzy Logic Index"}],

Cell[TextData[{
  "s-norm operations",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"s-norm operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["StrongAlphaLevel", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"StrongAlphaLevel", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["StrongAlphaLevelSet", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"StrongAlphaLevelSet", "Fuzzy Logic Index"}],

Cell[TextData[{
  "subsethood",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"subsethood", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Subsethood", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Subsethood", "Fuzzy Logic Index"}],

Cell[TextData[{
  "subtraction",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"subtraction", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Sugeno", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Sugeno", "Fuzzy Logic Index"}],

Cell[TextData[{
  "sum",
  ", ",
  ButtonBox["Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sum", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdrastic, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sum", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\ttype, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"sum type", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Support", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Support", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["SymmetricDifference", "MR"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"SymmetricDifference", "Fuzzy Logic Index"}],

Cell[TextData[{
  "t-norm",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"t-norm", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"t-norm operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["ToDigital", "MR"],
  ", ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"ToDigital", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["ToMembershipMatrix", "MR"],
  ", ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"ToMembershipMatrix", "Fuzzy Logic Index"}],

Cell[TextData[{
  "triangular fuzzy numbers",
  ", ",
  "discrete arithmetic",
  ", ",
  ButtonBox["Discrete Fuzzy Arithmetic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"triangular fuzzy numbers", "Fuzzy Logic Index"}],

Cell[TextData[{
  "two-sided ",
  "Gaussian",
  " fuzzy set, ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"two-sided gaussian fuzzy set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "union",
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"union", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tformulas, ",
  ButtonBox["Appendix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"union formulas", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t\[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"union", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toperations, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"union operations", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tproperties, ",
  ButtonBox["Standard Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"union", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Union", "MR"],
  ", ",
  ButtonBox["New Features",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Union", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tLn sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Union", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\t\[CapitalLSlash]ukasiewicz sets, ",
  ButtonBox["\[CapitalLSlash]ukasiewicz Sets and Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Union", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\toptions, ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Union", "Fuzzy Logic Index"}],

Cell[TextData[{
  "universal set",
  ", ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"universal set", "Fuzzy Logic Index"}],

Cell[TextData[{
  "universal space",
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"universal space", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tcontinuous, ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"universal space", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tdiscrete, ",
  ButtonBox["Digital Fuzzy Sets and Multivalued Logic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"universal space", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tgraphical representation, ",
  ButtonBox["Sets Versus Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"universal space", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["UniversalSpace", "MR"],
  ", ",
  ButtonBox["Creating Fuzzy Sets",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Creating Fuzzy Relations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"UniversalSpace", "Fuzzy Logic Index"}],

Cell[TextData[{
  "user-defined aggregators",
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"user-defined aggregators", "Fuzzy Logic Index"}],

Cell[TextData[{
  "visualization",
  ", \n\t",
  "fuzzy relations",
  ", ",
  ButtonBox["Fuzzy Relation Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"visualization", "Fuzzy Logic Index"}],

Cell[TextData[{
  "\tfuzzy sets, ",
  ButtonBox["Fuzzy Set Visualization",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"vizualization", "Fuzzy Logic Index"}],

Cell[TextData[{
  StyleBox["Yager", "MR"],
  ", ",
  ButtonBox["Fuzzy Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"],
  ", ",
  ButtonBox["Aggregation Operations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Fuzzy Logic"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Yager", "Fuzzy Logic Index"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Mechanical Systems", "IndexSection",
  CellTags->{
  "Absolute", "Acceleration", "AccelerationTerms", "AddLoads", "Alpha", 
    "Angle", "Angular", "Applied", "ArcLength", "Arrow", "Bar", "Body", 
    "BodyEnergy", "Box", "BuildMech", "CamPlot", "CamToCam1", "CamToCircle1", 
    "CamToLine1", "CamToPlane1", "CamToPoint1", "CamToSphere1", "Centrifugal",
     "Centroid", "CheckRules", "CheckSystem", "ClearMech", "ClearParameters", 
    "Closed", "CompositeInertia", "ConstantVelocity4", "Constraint", 
    "ConstraintCorrection", "Constraints", "Coordinates", "Corrector", 
    "CoupleSystem", "Cross", "Cubic", "CurveToCam1", "CurveToCylinder1", 
    "CurveToPlane1", "CurveToPoint2", "CutOff", "Cylindrical4", 
    "CylindricalToXYZ", "D2DistanceDT2", "DDistanceDT", "Diagnostics", 
    "DirectedDistance1", "DirectedPosition2", "DirectedPosition3", 
    "Direction", "Distance", "Dynamic", "Edge", "EndConditions", "Ends", 
    "Euler", "EulerParameters", "Extrude", "Faces", "Facet", "FindSwitchTime",
     "FindTime", "FitDegree", "Force", "Free", "FreeSystem", "FunctionOfTime",
     "Generalized", "Global", "Gravity", "GyroFilter", "GyroMoment", 
    "HeadSize", "IMatrix", "IncludedAngle", "Inertia", "InitialCondition", 
    "InitialGuess", "Interference", "IntersectionPoint", "Involute", 
    "Jacobian", "KillMech", "Kinematic", "LambdaGuess", "LastSolve", 
    "LeadScrew5", "Line", "Linear", "LineOnCylinder3", "LineToCircle1", 
    "LineToLine1", "LineToPlane2", "Load", "Loads", "Local", "LocalAxes", 
    "Location", "LockMech", "LocusPlot", "Magnitude", "MakeRules", "Mass", 
    "MassMatrix", "MaxError", "Mech", "MechPrimitive", "Moment", "Natural", 
    "Omega", "OriginLock2", "OriginLock3", "Orthogonal1", "OrthogonalGears5", 
    "OrthoRevolute4", "Parallel1", "Parallel2", "ParallelAxis", 
    "ParallelGears4", "ParallelGears5", "Parameterize", "Parameters", 
    "ParaRevolute4", "PathSystem", "Plane", "PlaneToCircle1", "PlaneToPlane3",
     "Point", "PointAtIntersection3", "PointLabel", "PointList", 
    "PointOnCircle2", "PointOnCone1", "PointOnCylinder1", "PointOnLine1", 
    "PointOnLine2", "PointOnLines2", "PointOnPlane1", "PointOnPlanes2", 
    "PointOnTorus1", "PointToLineDistance", "PointToLocal", 
    "PointToPlaneDistance", "PolarToXY", "Predictor", "PrincipalAxes", 
    "ProjectedAngle", "ProjectedAngle1", "ProjectOnLine", "ProjectOnPlane", 
    "Quadratic", "Quartic", "RackAndPinion2", "RackAndPinion4", 
    "RackAndPinion5", "Reaction", "ReferenceDirection", "Relative", 
    "RelativeAngle1", "RelativeDistance1", "RelativeVelocity", "RelativeX1", 
    "RelativeY1", "RelativeZ1", "RequiredEquations", "Revolute2", "Revolute5",
     "Revolve", "RMatrix", "Rotation", "RotationLock1", "RotationLock3", 
    "RotationMatrix", "SaveMech", "SensitivitySystem", "SetBodies", 
    "SetConstraints", "SetCouple", "SetFree", "SetGuess", "SetLoads", 
    "SetParameters", "SetPath", "SetSensitivity", "SetSymbols", "SkewSym", 
    "Solution", "SolveCouple", "SolveFree", "SolveMech", "SolvePath", 
    "SolveSensitivity", "Sphere", "Spherical3", "SphericalToXYZ", "SplineFit",
     "SplineFunction", "StageSwitch", "Static", "Step", "StepMech", 
    "StepSize", "SymbolBasis", "SysBody", "SysCon", "SysLoad", "SysPlot", 
    "Tangent", "TangentConstraint", "Time", "TimeInterpolate", "TimeSwitch", 
    "Torus", "Translate2", "Translate5", "TwoGears1", "TwoGears2", 
    "TwoPulleys2", "TwoPulleys4", "TwoPulleys5", "Type", "Unit", "Vector", 
    "Velocity", "VelocityTerms", "Vertex", "Virtual", "Wheel", "XYToPolar", 
    "XYZ", "XYZToCylindrical", "XYZToSpherical", "YZX", "ZXY", 
    "$MechPostIterate", "$MechPreSolve", "$MechPrimeRules", 
    "$MechProcessFunction", "$MechTimeRules", "$MechUseEulerMassTerm", 
    "$MechVariables", "$MechVersion"}],

Cell[TextData[{
  StyleBox["Absolute",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Absolute",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Absolute"],

Cell[TextData[{
  StyleBox["Acceleration",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Acceleration",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Acceleration"],

Cell[TextData[{
  StyleBox["AccelerationTerms",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`AccelerationTerms",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"AccelerationTerms"],

Cell[TextData[{
  StyleBox["AddLoads",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`AddLoads",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"AddLoads"],

Cell[TextData[{
  StyleBox["Alpha",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Alpha",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Alpha"],

Cell[TextData[{
  StyleBox["Angle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Angle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Angle"],

Cell[TextData[{
  StyleBox["Angular",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Angular",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Angular"],

Cell[TextData[{
  StyleBox["Applied",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Applied",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Applied"],

Cell[TextData[{
  StyleBox["ArcLength",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ArcLength",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ArcLength"],

Cell[TextData[{
  StyleBox["Arrow",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Arrow",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Arrow"],

Cell[TextData[{
  StyleBox["Bar",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Bar",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Bar"],

Cell[TextData[{
  StyleBox["Body",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Body",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Body"],

Cell[TextData[{
  StyleBox["BodyEnergy",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`BodyEnergy",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"BodyEnergy"],

Cell[TextData[{
  StyleBox["Box",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Box",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Box"],

Cell[TextData[{
  StyleBox["BuildMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`BuildMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"BuildMech"],

Cell[TextData[{
  StyleBox["CamPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CamPlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamPlot"],

Cell[TextData[{
  StyleBox["CamToCam1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CamToCam1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToCam1"],

Cell[TextData[{
  StyleBox["CamToPlane1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CamToPlane1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToPlane1"],

Cell[TextData[{
  StyleBox["CamToPoint1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CamToPoint1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToPoint1"],

Cell[TextData[{
  StyleBox["CamToSphere1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CamToSphere1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToSphere1"],

Cell[TextData[{
  StyleBox["Centrifugal",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Centrifugal",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Centrifugal"],

Cell[TextData[{
  StyleBox["Centroid",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Centroid",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Centroid"],

Cell[TextData[{
  StyleBox["CheckRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CheckRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CheckRules"],

Cell[TextData[{
  StyleBox["CheckSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CheckSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CheckSystem"],

Cell[TextData[{
  StyleBox["ClearMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ClearMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ClearMech"],

Cell[TextData[{
  StyleBox["ClearParameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ClearParameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ClearParameters"],

Cell[TextData[{
  StyleBox["Closed",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Closed",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Closed"],

Cell[TextData[{
  StyleBox["CompositeInertia",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CompositeInertia",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CompositeInertia"],

Cell[TextData[{
  StyleBox["ConstantVelocity4",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ConstantVelocity4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ConstantVelocity4"],

Cell[TextData[{
  StyleBox["Constraint",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Constraint",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Constraint"],

Cell[TextData[{
  StyleBox["ConstraintCorrection",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ConstraintCorrection",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ConstraintCorrection"],

Cell[TextData[{
  StyleBox["Constraints",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Constraints",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Constraints"],

Cell[TextData[{
  StyleBox["Coordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Coordinates",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Coordinates"],

Cell[TextData[{
  StyleBox["Corrector",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Corrector",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Corrector"],

Cell[TextData[{
  StyleBox["CoupleSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CoupleSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CoupleSystem"],

Cell[TextData[{
  StyleBox["Cross",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Cross",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Cross"],

Cell[TextData[{
  StyleBox["Cubic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Cubic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Cubic"],

Cell[TextData[{
  StyleBox["CurveToCam1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CurveToCam1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CurveToCam1"],

Cell[TextData[{
  StyleBox["CurveToCylinder1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CurveToCylinder1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CurveToCylinder1"],

Cell[TextData[{
  StyleBox["CurveToPlane1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CurveToPlane1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CurveToPlane1"],

Cell[TextData[{
  StyleBox["CurveToPoint2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CurveToPoint2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CurveToPoint2"],

Cell[TextData[{
  StyleBox["CutOff",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CutOff",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CutOff"],

Cell[TextData[{
  StyleBox["Cylindrical4",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Cylindrical4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Cylindrical4"],

Cell[TextData[{
  StyleBox["CylindricalToXYZ",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`CylindricalToXYZ",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CylindricalToXYZ"],

Cell[TextData[{
  StyleBox["D2DistanceDT2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`D2DistanceDT2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"D2DistanceDT2"],

Cell[TextData[{
  StyleBox["DDistanceDT",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`DDistanceDT",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"DDistanceDT"],

Cell[TextData[{
  StyleBox["Diagnostics",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Diagnostics",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Diagnostics"],

Cell[TextData[{
  StyleBox["DirectedDistance1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`DirectedDistance1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"DirectedDistance1"],

Cell[TextData[{
  StyleBox["DirectedPosition3",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`DirectedPosition3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"DirectedPosition3"],

Cell[TextData[{
  StyleBox["Direction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Direction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Direction"],

Cell[TextData[{
  StyleBox["Distance",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Distance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Distance"],

Cell[TextData[{
  StyleBox["Dynamic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Dynamic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Dynamic"],

Cell[TextData[{
  StyleBox["Edge",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Edge",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Edge"],

Cell[TextData[{
  StyleBox["EndConditions",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`EndConditions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"EndConditions"],

Cell[TextData[{
  StyleBox["Ends",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Ends",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Ends"],

Cell[TextData[{
  StyleBox["Euler",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Euler",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Euler"],

Cell[TextData[{
  StyleBox["EulerParameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`EulerParameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"EulerParameters"],

Cell[TextData[{
  StyleBox["Extrude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Extrude",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Extrude"],

Cell[TextData[{
  StyleBox["Faces",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Faces",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Faces"],

Cell[TextData[{
  StyleBox["Facet",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Facet",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Facet"],

Cell[TextData[{
  StyleBox["FindSwitchTime",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`FindSwitchTime",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"FindSwitchTime"],

Cell[TextData[{
  StyleBox["FindTime",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`FindTime",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"FindTime"],

Cell[TextData[{
  StyleBox["FitDegree",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`FitDegree",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"FitDegree"],

Cell[TextData[{
  StyleBox["Force",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Force",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Force"],

Cell[TextData[{
  StyleBox["Free",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Free",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Free"],

Cell[TextData[{
  StyleBox["FreeSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`FreeSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"FreeSystem"],

Cell[TextData[{
  StyleBox["FunctionOfTime",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`FunctionOfTime",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"FunctionOfTime"],

Cell[TextData[{
  StyleBox["Generalized",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Generalized",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Generalized"],

Cell[TextData[{
  StyleBox["Global",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Global",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Global"],

Cell[TextData[{
  StyleBox["Gravity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Gravity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Gravity"],

Cell[TextData[{
  StyleBox["GyroFilter",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`GyroFilter",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"GyroFilter"],

Cell[TextData[{
  StyleBox["GyroMoment",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`GyroMoment",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"GyroMoment"],

Cell[TextData[{
  StyleBox["HeadSize",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`HeadSize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"HeadSize"],

Cell[TextData[{
  StyleBox["IMatrix",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`IMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"IMatrix"],

Cell[TextData[{
  StyleBox["IncludedAngle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`IncludedAngle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"IncludedAngle"],

Cell[TextData[{
  StyleBox["Inertia",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Inertia",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Inertia"],

Cell[TextData[{
  StyleBox["InitialCondition",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`InitialCondition",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"InitialCondition"],

Cell[TextData[{
  StyleBox["InitialGuess",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`InitialGuess",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"InitialGuess"],

Cell[TextData[{
  StyleBox["IntersectionPoint",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`IntersectionPoint",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"IntersectionPoint"],

Cell[TextData[{
  StyleBox["Jacobian",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Jacobian",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Jacobian"],

Cell[TextData[{
  StyleBox["KillMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`KillMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"KillMech"],

Cell[TextData[{
  StyleBox["Kinematic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Kinematic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Kinematic"],

Cell[TextData[{
  StyleBox["LambdaGuess",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LambdaGuess",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LambdaGuess"],

Cell[TextData[{
  StyleBox["LastSolve",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LastSolve",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LastSolve"],

Cell[TextData[{
  StyleBox["LeadScrew5",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LeadScrew5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LeadScrew5"],

Cell[TextData[{
  StyleBox["Line",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Line",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Line"],

Cell[TextData[{
  StyleBox["Linear",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Linear",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Linear"],

Cell[TextData[{
  StyleBox["LineOnCylinder3",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LineOnCylinder3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LineOnCylinder3"],

Cell[TextData[{
  StyleBox["LineToCircle1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LineToCircle1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LineToCircle1"],

Cell[TextData[{
  StyleBox["LineToLine1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LineToLine1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LineToLine1"],

Cell[TextData[{
  StyleBox["LineToPlane2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LineToPlane2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LineToPlane2"],

Cell[TextData[{
  StyleBox["Load",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Load",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Load"],

Cell[TextData[{
  StyleBox["Loads",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Loads",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Loads"],

Cell[TextData[{
  StyleBox["Local",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Local",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Local"],

Cell[TextData[{
  StyleBox["LocalAxes",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LocalAxes",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LocalAxes"],

Cell[TextData[{
  StyleBox["Location",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Location",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Location"],

Cell[TextData[{
  StyleBox["LockMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LockMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LockMech"],

Cell[TextData[{
  StyleBox["LocusPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`LocusPlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"LocusPlot"],

Cell[TextData[{
  StyleBox["Magnitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Magnitude",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Magnitude"],

Cell[TextData[{
  StyleBox["MakeRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`MakeRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"MakeRules"],

Cell[TextData[{
  StyleBox["Mass",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Mass",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Mass"],

Cell[TextData[{
  StyleBox["MassMatrix",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`MassMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"MassMatrix"],

Cell[TextData[{
  StyleBox["MaxError",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`MaxError",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"MaxError"],

Cell[TextData[{
  StyleBox["Mech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Mech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Mech"],

Cell[TextData[{
  StyleBox["MechPrimitive",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`MechPrimitive",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"MechPrimitive"],

Cell[TextData[{
  StyleBox["Moment",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Moment",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Moment"],

Cell[TextData[{
  StyleBox["Natural",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Natural",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Natural"],

Cell[TextData[{
  StyleBox["Omega",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Omega",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Omega"],

Cell[TextData[{
  StyleBox["OriginLock3",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`OriginLock3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"OriginLock3"],

Cell[TextData[{
  StyleBox["Orthogonal1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Orthogonal1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Orthogonal1"],

Cell[TextData[{
  StyleBox["OrthogonalGears5",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`OrthogonalGears5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"OrthogonalGears5"],

Cell[TextData[{
  StyleBox["OrthoRevolute4",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`OrthoRevolute4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"OrthoRevolute4"],

Cell[TextData[{
  StyleBox["Parallel2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Parallel2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Parallel2"],

Cell[TextData[{
  StyleBox["ParallelAxis",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ParallelAxis",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ParallelAxis"],

Cell[TextData[{
  StyleBox["ParallelGears4",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ParallelGears4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ParallelGears4"],

Cell[TextData[{
  StyleBox["ParallelGears5",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ParallelGears5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ParallelGears5"],

Cell[TextData[{
  StyleBox["Parameterize",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Parameterize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Parameterize"],

Cell[TextData[{
  StyleBox["Parameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Parameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Parameters"],

Cell[TextData[{
  StyleBox["ParaRevolute4",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ParaRevolute4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ParaRevolute4"],

Cell[TextData[{
  StyleBox["PathSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PathSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PathSystem"],

Cell[TextData[{
  StyleBox["Plane",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Plane",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Plane"],

Cell[TextData[{
  StyleBox["PlaneToCircle1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PlaneToCircle1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PlaneToCircle1"],

Cell[TextData[{
  StyleBox["PlaneToPlane3",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PlaneToPlane3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PlaneToPlane3"],

Cell[TextData[{
  StyleBox["Point",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Point",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Point"],

Cell[TextData[{
  StyleBox["PointAtIntersection3",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointAtIntersection3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointAtIntersection3"],

Cell[TextData[{
  StyleBox["PointLabel",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointLabel",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointLabel"],

Cell[TextData[{
  StyleBox["PointList",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointList",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointList"],

Cell[TextData[{
  StyleBox["PointOnCircle2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointOnCircle2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointOnCircle2"],

Cell[TextData[{
  StyleBox["PointOnCone1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointOnCone1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointOnCone1"],

Cell[TextData[{
  StyleBox["PointOnCylinder1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointOnCylinder1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointOnCylinder1"],

Cell[TextData[{
  StyleBox["PointOnLine2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointOnLine2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointOnLine2"],

Cell[TextData[{
  StyleBox["PointOnPlane1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointOnPlane1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointOnPlane1"],

Cell[TextData[{
  StyleBox["PointOnPlanes2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointOnPlanes2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointOnPlanes2"],

Cell[TextData[{
  StyleBox["PointOnTorus1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointOnTorus1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointOnTorus1"],

Cell[TextData[{
  StyleBox["PointToLineDistance",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointToLineDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointToLineDistance"],

Cell[TextData[{
  StyleBox["PointToLocal",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointToLocal",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointToLocal"],

Cell[TextData[{
  StyleBox["PointToPlaneDistance",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PointToPlaneDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PointToPlaneDistance"],

Cell[TextData[{
  StyleBox["Predictor",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Predictor",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Predictor"],

Cell[TextData[{
  StyleBox["PrincipalAxes",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`PrincipalAxes",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"PrincipalAxes"],

Cell[TextData[{
  StyleBox["ProjectedAngle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ProjectedAngle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ProjectedAngle"],

Cell[TextData[{
  StyleBox["ProjectedAngle1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ProjectedAngle1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ProjectedAngle1"],

Cell[TextData[{
  StyleBox["ProjectOnLine",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ProjectOnLine",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ProjectOnLine"],

Cell[TextData[{
  StyleBox["ProjectOnPlane",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ProjectOnPlane",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ProjectOnPlane"],

Cell[TextData[{
  StyleBox["Quadratic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Quadratic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Quadratic"],

Cell[TextData[{
  StyleBox["Quartic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Quartic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Quartic"],

Cell[TextData[{
  StyleBox["RackAndPinion4",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RackAndPinion4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RackAndPinion4"],

Cell[TextData[{
  StyleBox["RackAndPinion5",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RackAndPinion5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RackAndPinion5"],

Cell[TextData[{
  StyleBox["Reaction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Reaction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Reaction"],

Cell[TextData[{
  StyleBox["ReferenceDirection",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ReferenceDirection",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ReferenceDirection"],

Cell[TextData[{
  StyleBox["Relative",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Relative",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Relative"],

Cell[TextData[{
  StyleBox["RelativeAngle1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RelativeAngle1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RelativeAngle1"],

Cell[TextData[{
  StyleBox["RelativeDistance1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RelativeDistance1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RelativeDistance1"],

Cell[TextData[{
  StyleBox["RelativeVelocity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RelativeVelocity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RelativeVelocity"],

Cell[TextData[{
  StyleBox["RelativeX1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RelativeX1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RelativeX1"],

Cell[TextData[{
  StyleBox["RelativeY1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RelativeY1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RelativeY1"],

Cell[TextData[{
  StyleBox["RelativeZ1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RelativeZ1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RelativeZ1"],

Cell[TextData[{
  StyleBox["RequiredEquations",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RequiredEquations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RequiredEquations"],

Cell[TextData[{
  StyleBox["Revolute5",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Revolute5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Revolute5"],

Cell[TextData[{
  StyleBox["Revolve",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Revolve",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Revolve"],

Cell[TextData[{
  StyleBox["Rotation",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Rotation",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Rotation"],

Cell[TextData[{
  StyleBox["RotationLock3",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RotationLock3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RotationLock3"],

Cell[TextData[{
  StyleBox["RotationMatrix",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`RotationMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"RotationMatrix"],

Cell[TextData[{
  StyleBox["SaveMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SaveMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SaveMech"],

Cell[TextData[{
  StyleBox["SensitivitySystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SensitivitySystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SensitivitySystem"],

Cell[TextData[{
  StyleBox["SetBodies",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetBodies",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetBodies"],

Cell[TextData[{
  StyleBox["SetConstraints",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetConstraints",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetConstraints"],

Cell[TextData[{
  StyleBox["SetCouple",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetCouple",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetCouple"],

Cell[TextData[{
  StyleBox["SetFree",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetFree",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetFree"],

Cell[TextData[{
  StyleBox["SetGuess",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetGuess",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetGuess"],

Cell[TextData[{
  StyleBox["SetLoads",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetLoads",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetLoads"],

Cell[TextData[{
  StyleBox["SetParameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetParameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetParameters"],

Cell[TextData[{
  StyleBox["SetPath",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetPath",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetPath"],

Cell[TextData[{
  StyleBox["SetSensitivity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetSensitivity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetSensitivity"],

Cell[TextData[{
  StyleBox["SetSymbols",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SetSymbols",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SetSymbols"],

Cell[TextData[{
  StyleBox["SkewSym",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SkewSym",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SkewSym"],

Cell[TextData[{
  StyleBox["Solution",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Solution",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Solution"],

Cell[TextData[{
  StyleBox["SolveCouple",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SolveCouple",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SolveCouple"],

Cell[TextData[{
  StyleBox["SolveFree",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SolveFree",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SolveFree"],

Cell[TextData[{
  StyleBox["SolveMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SolveMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SolveMech"],

Cell[TextData[{
  StyleBox["SolvePath",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SolvePath",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SolvePath"],

Cell[TextData[{
  StyleBox["SolveSensitivity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SolveSensitivity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SolveSensitivity"],

Cell[TextData[{
  StyleBox["Sphere",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Sphere",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Sphere"],

Cell[TextData[{
  StyleBox["Spherical3",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Spherical3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Spherical3"],

Cell[TextData[{
  StyleBox["SphericalToXYZ",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SphericalToXYZ",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SphericalToXYZ"],

Cell[TextData[{
  StyleBox["SplineFit",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SplineFit",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SplineFit"],

Cell[TextData[{
  StyleBox["SplineFunction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SplineFunction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SplineFunction"],

Cell[TextData[{
  StyleBox["StageSwitch",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`StageSwitch",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"StageSwitch"],

Cell[TextData[{
  StyleBox["Static",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Static",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Static"],

Cell[TextData[{
  StyleBox["Step",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Step",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Step"],

Cell[TextData[{
  StyleBox["StepMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`StepMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"StepMech"],

Cell[TextData[{
  StyleBox["StepSize",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`StepSize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"StepSize"],

Cell[TextData[{
  StyleBox["SymbolBasis",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SymbolBasis",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SymbolBasis"],

Cell[TextData[{
  StyleBox["SysBody",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SysBody",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SysBody"],

Cell[TextData[{
  StyleBox["SysCon",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SysCon",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SysCon"],

Cell[TextData[{
  StyleBox["SysLoad",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SysLoad",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SysLoad"],

Cell[TextData[{
  StyleBox["SysPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`SysPlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"SysPlot"],

Cell[TextData[{
  StyleBox["TangentConstraint",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`TangentConstraint",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"TangentConstraint"],

Cell[TextData[{
  StyleBox["Time",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Time",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Time"],

Cell[TextData[{
  StyleBox["TimeInterpolate",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`TimeInterpolate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"TimeInterpolate"],

Cell[TextData[{
  StyleBox["TimeSwitch",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`TimeSwitch",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"TimeSwitch"],

Cell[TextData[{
  StyleBox["Torus",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Torus",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Torus"],

Cell[TextData[{
  StyleBox["Translate5",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Translate5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Translate5"],

Cell[TextData[{
  StyleBox["TwoPulleys4",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`TwoPulleys4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"TwoPulleys4"],

Cell[TextData[{
  StyleBox["TwoPulleys5",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`TwoPulleys5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"TwoPulleys5"],

Cell[TextData[{
  StyleBox["Type",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Type",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Type"],

Cell[TextData[{
  StyleBox["Unit",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Unit",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Unit"],

Cell[TextData[{
  StyleBox["Vector",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Vector",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Vector"],

Cell[TextData[{
  StyleBox["Velocity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Velocity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Velocity"],

Cell[TextData[{
  StyleBox["VelocityTerms",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`VelocityTerms",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"VelocityTerms"],

Cell[TextData[{
  StyleBox["Vertex",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Vertex",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Vertex"],

Cell[TextData[{
  StyleBox["Virtual",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Virtual",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Virtual"],

Cell[TextData[{
  StyleBox["Wheel",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`Wheel",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Wheel"],

Cell[TextData[{
  StyleBox["XYZ",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`XYZ",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"XYZ"],

Cell[TextData[{
  StyleBox["XYZToCylindrical",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`XYZToCylindrical",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"XYZToCylindrical"],

Cell[TextData[{
  StyleBox["XYZToSpherical",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`XYZToSpherical",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"XYZToSpherical"],

Cell[TextData[{
  StyleBox["YZX",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`YZX",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"YZX"],

Cell[TextData[{
  StyleBox["ZXY",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`ZXY",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ZXY"],

Cell[TextData[{
  StyleBox["$MechPostIterate",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechPostIterate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechPostIterate"],

Cell[TextData[{
  StyleBox["$MechPreSolve",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechPreSolve",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechPreSolve"],

Cell[TextData[{
  StyleBox["$MechPrimeRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechPrimeRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechPrimeRules"],

Cell[TextData[{
  StyleBox["$MechProcessFunction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechProcessFunction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechProcessFunction"],

Cell[TextData[{
  StyleBox["$MechTimeRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechTimeRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechTimeRules"],

Cell[TextData[{
  StyleBox["$MechUseEulerMassTerm",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechUseEulerMassTerm",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechUseEulerMassTerm"],

Cell[TextData[{
  StyleBox["$MechVariables",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechVariables",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechVariables"],

Cell[TextData[{
  StyleBox["$MechVersion",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech3D`$MechVersion",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"$MechVersion"],

Cell[TextData[{
  StyleBox["Absolute",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Absolute",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Absolute"],

Cell[TextData[{
  StyleBox["Acceleration",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Acceleration",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Acceleration"],

Cell[TextData[{
  StyleBox["AccelerationTerms",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`AccelerationTerms",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"AccelerationTerms"],

Cell[TextData[{
  StyleBox["AddLoads",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`AddLoads",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"AddLoads"],

Cell[TextData[{
  StyleBox["Alpha",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Alpha",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Alpha"],

Cell[TextData[{
  StyleBox["Angle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Angle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Angle"],

Cell[TextData[{
  StyleBox["Angular",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Angular",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Angular"],

Cell[TextData[{
  StyleBox["Applied",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Applied",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Applied"],

Cell[TextData[{
  StyleBox["ArcLength",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`ArcLength",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ArcLength"],

Cell[TextData[{
  StyleBox["Arrow",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Arrow",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Arrow"],

Cell[TextData[{
  StyleBox["Bar",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Bar",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Bar"],

Cell[TextData[{
  StyleBox["Body",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Body",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Body"],

Cell[TextData[{
  StyleBox["BodyEnergy",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`BodyEnergy",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"BodyEnergy"],

Cell[TextData[{
  StyleBox["Box",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Box",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Box"],

Cell[TextData[{
  StyleBox["BuildMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`BuildMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"BuildMech"],

Cell[TextData[{
  StyleBox["CamPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CamPlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamPlot"],

Cell[TextData[{
  StyleBox["CamToCam1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CamToCam1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToCam1"],

Cell[TextData[{
  StyleBox["CamToCircle1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CamToCircle1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToCircle1"],

Cell[TextData[{
  StyleBox["CamToLine1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CamToLine1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToLine1"],

Cell[TextData[{
  StyleBox["CamToPoint1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CamToPoint1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CamToPoint1"],

Cell[TextData[{
  StyleBox["Centrifugal",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Centrifugal",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Centrifugal"],

Cell[TextData[{
  StyleBox["Centroid",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Centroid",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Centroid"],

Cell[TextData[{
  StyleBox["CheckRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CheckRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CheckRules"],

Cell[TextData[{
  StyleBox["CheckSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CheckSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CheckSystem"],

Cell[TextData[{
  StyleBox["ClearMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`ClearMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ClearMech"],

Cell[TextData[{
  StyleBox["ClearParameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`ClearParameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ClearParameters"],

Cell[TextData[{
  StyleBox["Closed",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Closed",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Closed"],

Cell[TextData[{
  StyleBox["CompositeInertia",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CompositeInertia",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CompositeInertia"],

Cell[TextData[{
  StyleBox["Constraint",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Constraint",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Constraint"],

Cell[TextData[{
  StyleBox["ConstraintCorrection",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`ConstraintCorrection",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"ConstraintCorrection"],

Cell[TextData[{
  StyleBox["Constraints",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Constraints",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Constraints"],

Cell[TextData[{
  StyleBox["Coordinates",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Coordinates",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Coordinates"],

Cell[TextData[{
  StyleBox["Corrector",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Corrector",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Corrector"],

Cell[TextData[{
  StyleBox["CoupleSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CoupleSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CoupleSystem"],

Cell[TextData[{
  StyleBox["Cross",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Cross",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Cross"],

Cell[TextData[{
  StyleBox["Cubic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Cubic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Cubic"],

Cell[TextData[{
  StyleBox["CutOff",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`CutOff",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"CutOff"],

Cell[TextData[{
  StyleBox["D2DistanceDT2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`D2DistanceDT2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"D2DistanceDT2"],

Cell[TextData[{
  StyleBox["DDistanceDT",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`DDistanceDT",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"DDistanceDT"],

Cell[TextData[{
  StyleBox["Diagnostics",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Diagnostics",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Diagnostics"],

Cell[TextData[{
  StyleBox["DirectedDistance1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`DirectedDistance1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"DirectedDistance1"],

Cell[TextData[{
  StyleBox["DirectedPosition2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`DirectedPosition2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DirectedPosition2"],

Cell[TextData[{
  StyleBox["Direction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Direction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Direction"],

Cell[TextData[{
  StyleBox["Distance",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Distance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Distance"],

Cell[TextData[{
  StyleBox["Dynamic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Dynamic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dynamic"],

Cell[TextData[{
  StyleBox["Edge",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Edge",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Edge"],

Cell[TextData[{
  StyleBox["EndConditions",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`EndConditions",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EndConditions"],

Cell[TextData[{
  StyleBox["Euler",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Euler",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Euler"],

Cell[TextData[{
  StyleBox["EulerParameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`EulerParameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EulerParameters"],

Cell[TextData[{
  StyleBox["Faces",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Faces",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Faces"],

Cell[TextData[{
  StyleBox["Facet",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Facet",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Facet"],

Cell[TextData[{
  StyleBox["FindSwitchTime",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`FindSwitchTime",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindSwitchTime"],

Cell[TextData[{
  StyleBox["FindTime",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`FindTime",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindTime"],

Cell[TextData[{
  StyleBox["FitDegree",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`FitDegree",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FitDegree"],

Cell[TextData[{
  StyleBox["Force",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Force",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Force"],

Cell[TextData[{
  StyleBox["Free",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Free",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Free"],

Cell[TextData[{
  StyleBox["FreeSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`FreeSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FreeSystem"],

Cell[TextData[{
  StyleBox["FunctionOfTime",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`FunctionOfTime",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FunctionOfTime"],

Cell[TextData[{
  StyleBox["Generalized",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Generalized",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Generalized"],

Cell[TextData[{
  StyleBox["Global",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Global",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Global"],

Cell[TextData[{
  StyleBox["Gravity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Gravity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Gravity"],

Cell[TextData[{
  StyleBox["HeadSize",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`HeadSize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeadSize"],

Cell[TextData[{
  StyleBox["IMatrix",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`IMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IMatrix"],

Cell[TextData[{
  StyleBox["IncludedAngle",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`IncludedAngle",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IncludedAngle"],

Cell[TextData[{
  StyleBox["Inertia",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Inertia",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Inertia"],

Cell[TextData[{
  StyleBox["InitialCondition",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`InitialCondition",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InitialCondition"],

Cell[TextData[{
  StyleBox["InitialGuess",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`InitialGuess",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InitialGuess"],

Cell[TextData[{
  StyleBox["Interference",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Interference",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Interference"],

Cell[TextData[{
  StyleBox["IntersectionPoint",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`IntersectionPoint",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntersectionPoint"],

Cell[TextData[{
  StyleBox["Involute",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Involute",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Involute"],

Cell[TextData[{
  StyleBox["Jacobian",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Jacobian",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Jacobian"],

Cell[TextData[{
  StyleBox["KillMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`KillMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KillMech"],

Cell[TextData[{
  StyleBox["Kinematic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Kinematic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Kinematic"],

Cell[TextData[{
  StyleBox["LambdaGuess",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`LambdaGuess",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LambdaGuess"],

Cell[TextData[{
  StyleBox["LastSolve",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`LastSolve",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LastSolve"],

Cell[TextData[{
  StyleBox["Line",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Line",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Line"],

Cell[TextData[{
  StyleBox["Linear",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Linear",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Linear"],

Cell[TextData[{
  StyleBox["Load",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Load",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Load"],

Cell[TextData[{
  StyleBox["Loads",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Loads",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Loads"],

Cell[TextData[{
  StyleBox["Local",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Local",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Local"],

Cell[TextData[{
  StyleBox["LocalAxes",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`LocalAxes",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LocalAxes"],

Cell[TextData[{
  StyleBox["Location",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Location",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Location"],

Cell[TextData[{
  StyleBox["LockMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`LockMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LockMech"],

Cell[TextData[{
  StyleBox["LocusPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`LocusPlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LocusPlot"],

Cell[TextData[{
  StyleBox["Magnitude",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Magnitude",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Magnitude"],

Cell[TextData[{
  StyleBox["MakeRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`MakeRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"MakeRules"],

Cell[TextData[{
  StyleBox["Mass",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Mass",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Mass"],

Cell[TextData[{
  StyleBox["MassMatrix",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`MassMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MassMatrix"],

Cell[TextData[{
  StyleBox["MaxError",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`MaxError",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxError"],

Cell[TextData[{
  StyleBox["Mech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Mech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Mech"],

Cell[TextData[{
  StyleBox["MechPrimitive",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`MechPrimitive",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MechPrimitive"],

Cell[TextData[{
  StyleBox["Moment",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Moment",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Moment"],

Cell[TextData[{
  StyleBox["Natural",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Natural",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Natural"],

Cell[TextData[{
  StyleBox["Omega",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Omega",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Omega"],

Cell[TextData[{
  StyleBox["OriginLock2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`OriginLock2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OriginLock2"],

Cell[TextData[{
  StyleBox["Orthogonal1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Orthogonal1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Orthogonal1"],

Cell[TextData[{
  StyleBox["Parallel1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Parallel1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Parallel1"],

Cell[TextData[{
  StyleBox["ParallelAxis",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`ParallelAxis",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParallelAxis"],

Cell[TextData[{
  StyleBox["Parameterize",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Parameterize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Parameterize"],

Cell[TextData[{
  StyleBox["Parameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Parameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Parameters"],

Cell[TextData[{
  StyleBox["PathSystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PathSystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PathSystem"],

Cell[TextData[{
  StyleBox["Point",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Point",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellTags->"Point"],

Cell[TextData[{
  StyleBox["PointLabel",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PointLabel",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PointLabel"],

Cell[TextData[{
  StyleBox["PointList",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PointList",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PointList"],

Cell[TextData[{
  StyleBox["PointOnLine1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PointOnLine1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PointOnLine1"],

Cell[TextData[{
  StyleBox["PointOnLines2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PointOnLines2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PointOnLines2"],

Cell[TextData[{
  StyleBox["PointToLineDistance",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PointToLineDistance",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PointToLineDistance"],

Cell[TextData[{
  StyleBox["PointToLocal",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PointToLocal",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PointToLocal"],

Cell[TextData[{
  StyleBox["PolarToXY",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`PolarToXY",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolarToXY"],

Cell[TextData[{
  StyleBox["Predictor",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Predictor",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Predictor"],

Cell[TextData[{
  StyleBox["ProjectOnLine",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`ProjectOnLine",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ProjectOnLine"],

Cell[TextData[{
  StyleBox["Quadratic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Quadratic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quadratic"],

Cell[TextData[{
  StyleBox["Quartic",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Quartic",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quartic"],

Cell[TextData[{
  StyleBox["RackAndPinion2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RackAndPinion2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RackAndPinion2"],

Cell[TextData[{
  StyleBox["Reaction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Reaction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Reaction"],

Cell[TextData[{
  StyleBox["Relative",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Relative",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Relative"],

Cell[TextData[{
  StyleBox["RelativeAngle1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RelativeAngle1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RelativeAngle1"],

Cell[TextData[{
  StyleBox["RelativeDistance1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RelativeDistance1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RelativeDistance1"],

Cell[TextData[{
  StyleBox["RelativeVelocity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RelativeVelocity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RelativeVelocity"],

Cell[TextData[{
  StyleBox["RelativeX1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RelativeX1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RelativeX1"],

Cell[TextData[{
  StyleBox["RelativeY1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RelativeY1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RelativeY1"],

Cell[TextData[{
  StyleBox["RequiredEquations",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RequiredEquations",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RequiredEquations"],

Cell[TextData[{
  StyleBox["Revolute2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Revolute2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Revolute2"],

Cell[TextData[{
  StyleBox["RMatrix",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RMatrix"],

Cell[TextData[{
  StyleBox["Rotation",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Rotation",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rotation"],

Cell[TextData[{
  StyleBox["RotationLock1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RotationLock1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RotationLock1"],

Cell[TextData[{
  StyleBox["RotationMatrix",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`RotationMatrix",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RotationMatrix"],

Cell[TextData[{
  StyleBox["SaveMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SaveMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SaveMech"],

Cell[TextData[{
  StyleBox["SensitivitySystem",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SensitivitySystem",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SensitivitySystem"],

Cell[TextData[{
  StyleBox["SetBodies",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetBodies",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetBodies"],

Cell[TextData[{
  StyleBox["SetConstraints",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetConstraints",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetConstraints"],

Cell[TextData[{
  StyleBox["SetCouple",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetCouple",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetCouple"],

Cell[TextData[{
  StyleBox["SetFree",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetFree",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetFree"],

Cell[TextData[{
  StyleBox["SetGuess",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetGuess",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetGuess"],

Cell[TextData[{
  StyleBox["SetLoads",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetLoads",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetLoads"],

Cell[TextData[{
  StyleBox["SetParameters",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetParameters",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetParameters"],

Cell[TextData[{
  StyleBox["SetPath",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetPath",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetPath"],

Cell[TextData[{
  StyleBox["SetSensitivity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetSensitivity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetSensitivity"],

Cell[TextData[{
  StyleBox["SetSymbols",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SetSymbols",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetSymbols"],

Cell[TextData[{
  StyleBox["Solution",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Solution",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Solution"],

Cell[TextData[{
  StyleBox["SolveCouple",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SolveCouple",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SolveCouple"],

Cell[TextData[{
  StyleBox["SolveFree",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SolveFree",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SolveFree"],

Cell[TextData[{
  StyleBox["SolveMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SolveMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SolveMech"],

Cell[TextData[{
  StyleBox["SolvePath",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SolvePath",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SolvePath"],

Cell[TextData[{
  StyleBox["SolveSensitivity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SolveSensitivity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SolveSensitivity"],

Cell[TextData[{
  StyleBox["SplineFit",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SplineFit",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SplineFit"],

Cell[TextData[{
  StyleBox["SplineFunction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SplineFunction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SplineFunction"],

Cell[TextData[{
  StyleBox["StageSwitch",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`StageSwitch",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"StageSwitch"],

Cell[TextData[{
  StyleBox["Static",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Static",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Static"],

Cell[TextData[{
  StyleBox["Step",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Step",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Step"],

Cell[TextData[{
  StyleBox["StepMech",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`StepMech",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"StepMech"],

Cell[TextData[{
  StyleBox["StepSize",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`StepSize",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"StepSize"],

Cell[TextData[{
  StyleBox["SymbolBasis",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SymbolBasis",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SymbolBasis"],

Cell[TextData[{
  StyleBox["SysBody",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SysBody",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SysBody"],

Cell[TextData[{
  StyleBox["SysCon",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SysCon",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SysCon"],

Cell[TextData[{
  StyleBox["SysLoad",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SysLoad",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SysLoad"],

Cell[TextData[{
  StyleBox["SysPlot",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`SysPlot",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SysPlot"],

Cell[TextData[{
  StyleBox["Tangent",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Tangent",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Tangent"],

Cell[TextData[{
  StyleBox["TangentConstraint",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`TangentConstraint",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"TangentConstraint"],

Cell[TextData[{
  StyleBox["Time",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Time",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Time"],

Cell[TextData[{
  StyleBox["TimeInterpolate",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`TimeInterpolate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"TimeInterpolate"],

Cell[TextData[{
  StyleBox["TimeSwitch",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`TimeSwitch",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"TimeSwitch"],

Cell[TextData[{
  StyleBox["Translate2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Translate2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Translate2"],

Cell[TextData[{
  StyleBox["TwoGears1",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`TwoGears1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"TwoGears1"],

Cell[TextData[{
  StyleBox["TwoGears2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`TwoGears2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"TwoGears2"],

Cell[TextData[{
  StyleBox["TwoPulleys2",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`TwoPulleys2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"TwoPulleys2"],

Cell[TextData[{
  StyleBox["Type",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Type",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Type"],

Cell[TextData[{
  StyleBox["Unit",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Unit",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Unit"],

Cell[TextData[{
  StyleBox["Vector",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Vector",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Vector"],

Cell[TextData[{
  StyleBox["Velocity",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Velocity",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Velocity"],

Cell[TextData[{
  StyleBox["VelocityTerms",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`VelocityTerms",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"VelocityTerms"],

Cell[TextData[{
  StyleBox["Vertex",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Vertex",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Vertex"],

Cell[TextData[{
  StyleBox["Wheel",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`Wheel",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Wheel"],

Cell[TextData[{
  StyleBox["XYToPolar",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`XYToPolar",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"XYToPolar"],

Cell[TextData[{
  StyleBox["$MechPostIterate",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`$MechPostIterate",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$MechPostIterate"],

Cell[TextData[{
  StyleBox["$MechPreSolve",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`$MechPreSolve",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$MechPreSolve"],

Cell[TextData[{
  StyleBox["$MechPrimeRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`$MechPrimeRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$MechPrimeRules"],

Cell[TextData[{
  StyleBox["$MechProcessFunction",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`$MechProcessFunction",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$MechProcessFunction"],

Cell[TextData[{
  StyleBox["$MechTimeRules",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`$MechTimeRules",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$MechTimeRules"],

Cell[TextData[{
  StyleBox["$MechVariables",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`$MechVariables",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$MechVariables"],

Cell[TextData[{
  StyleBox["$MechVersion",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["Mech`Mech2D`$MechVersion",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Mechanical Systems"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$MechVersion"]
}, Closed]],

Cell[CellGroupData[{

Cell["Neural Networks", "IndexSection",
  CellTags->{
  "AccumulatedIterations", "Backpropagation", "BarChart", "BiasParameters", 
    "BoundaryDash", "CbvSymbol", "Classification", 
    "Classification of Paper Quality", "Classifier", "ClassPerformance", 
    "Clustering", "codebook vectors", "competitive", "Connect", "Continuous", 
    "CreationDate", "CriterionLog", "CriterionLogExtN", "CriterionPlot", 
    "CriterionValidationValues", "CriterionValues", "DataFormat", "DataMap", 
    "DataMapArray", "Data PreProcessing", "DeleteSOM", "Discrete", 
    "Dynamic models", "Dynamic neural networks", "Energy", 
    "ErrorDistribution", "FeedForwardNet", "FixedParameters", 
    "Function approximation", "FunctionPlot", "Gauss-Newton", "GaussNewton", 
    "HiddenNeurons", "Hopfield", "HopfieldEnergy", "HopfieldFit", 
    "Hopfield Networks", "InitialInput", "Initialization", 
    "InitializeFeedForwardNet", "InitializePerceptron", "InitializeRBFNet", 
    "InitializeUnsupervisedNet", "InitializeVQ", "InitialOutput", 
    "InitialRange", "Kohonen networks", "Learning Vector Quantization 1", 
    "Levenberg-Marquardt", "LinearizeNet", "Linear Models", 
    "LinearParameters", "LinearPart", "LVQ1", "MakeRegressor", "Method", 
    "MinIterations", "Momentum", "MoreTrainingPrompt", "Multilayer Networks", 
    "MultiplePrediction", "Neighbor", "NeighborStrength", 
    "NetClassificationPlot", "NetComparePlot", "NetInformation", "NetOutput", 
    "NetPlot", "NetPredict", "NetPredictionError", "NetSimulate", "NetType", 
    "NeuralARFit", "NeuralARX", "NeuralARXFit", "NeuralD", "NeuralFit", 
    "NeuralFitRecord", "Neural network", "Neuron", "NeuronDelete", 
    "Neuron Function", "NNModelInfo", "NumberOfInputs", "OutputNonlinearity", 
    "ParameterRecord", "ParameterValues", "ParametricPlot", "Perceptron", 
    "PerceptronFit", "PerceptronRecord", "PredictHorizon", 
    "Prediction of Currency Exchange Rate", "PreProcessing", 
    "Radial Basis Function Network", "RandomInitialization", "RBFNet", 
    "Recursive", "Regressor", "Regularization", "ReportFrequency", 
    "SaturatedLinear", "self-organizing feature maps", "self-organizing map", 
    "Separable", "SetNeuralD", "ShowRange", "Sigmoid", "SOM", "SOMOptions", 
    "steepest descent", "SteepestDescent", "StepLength", "Stopped Search", 
    "Surface", "System Identification", "Table", "Time series", 
    "ToFindMinimum", "Training", "Training neural networks with FindMinimum", 
    "Training Record", "Trajectories", "UnsupervisedNetDistance", 
    "UnsupervisedNetFit", "UnsupervisedNetRecord", "Unsupervised networks", 
    "UnUsedNeurons", "UseSOM", "UseUnsupervisedNet", "Vector Quantization", 
    "Voronoi", "VQ", "VQDistance", "VQFit", "VQPerformance", "VQRecord"}],

Cell[TextData[{
  StyleBox["AccumulatedIterations", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AccumulatedIterations"],

Cell[TextData[{
  StyleBox["Backpropagation", "Text"],
  ", ",
  ButtonBox["NeuralNetworks 2.5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Backpropagation"],

Cell[TextData[{
  "Backpropagation",
  ", ",
  "NeuralFit",
  ", ",
  ButtonBox["NeuralNetworks 7.2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Backpropagation"],

Cell[TextData[{
  StyleBox["BarChart", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BarChart"],

Cell[TextData[{
  StyleBox["BarChart", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BarChart"],

Cell[TextData[{
  StyleBox["BarChart", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", VQ ",
  ", ",
  ButtonBox["NeuralNetworks 11.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BarChart"],

Cell[TextData[{
  StyleBox["BiasParameters", "MR"],
  ", ",
  StyleBox["InitializeFeedForwardNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BiasParameters"],

Cell[TextData[{
  StyleBox["BoundaryDash", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BoundaryDash"],

Cell[TextData[{
  StyleBox["CbvSymbol", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Unsupervised Network",
  ", ",
  ButtonBox["NeuralNetworks 10.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CbvSymbol"],

Cell[TextData[{
  StyleBox["CbvSymbol", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", VQ ",
  ", ",
  ButtonBox["NeuralNetworks 11.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CbvSymbol"],

Cell[TextData[{
  "Classification",
  ", ",
  ButtonBox["NeuralNetworks 2.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Classification"],

Cell[TextData[{
  "Classification of Paper Quality",
  ", ",
  ButtonBox["NeuralNetworks 12.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Classification of Paper Quality"],

Cell[TextData[{
  StyleBox["Classifier", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Classifier"],

Cell[TextData[{
  StyleBox["ClassPerformance", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClassPerformance"],

Cell[TextData[{
  StyleBox["ClassPerformance", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClassPerformance"],

Cell[TextData[{
  StyleBox["ClassPerformance", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", VQ",
  ", ",
  ButtonBox["NeuralNetworks 11.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClassPerformance"],

Cell[TextData[{
  "Clustering",
  ", ",
  ButtonBox["NeuralNetworks 2.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Clustering"],

Cell[TextData[{
  "codebook vectors",
  ", ",
  "unsupervised network",
  ", ",
  ButtonBox["NeuralNetworks 2.8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"codebook vectors"],

Cell[TextData[{
  "codebook vectors",
  ", ",
  "Vector quantization networks",
  ", ",
  ButtonBox["NeuralNetworks 2.8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"codebook vectors"],

Cell[TextData[{
  "competitive",
  ", ",
  ButtonBox["NeuralNetworks 10.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"competitive"],

Cell[TextData[{
  StyleBox["Connect", "MR"],
  ", ",
  StyleBox["UnsupervisedNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Connect"],

Cell[TextData[{
  StyleBox["Connect", "MR"],
  ", ",
  StyleBox["UnsupervisedNetFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Connect"],

Cell[TextData[{
  StyleBox["Continuous",
    FontFamily->"Courier"],
  ", ",
  "Hopfield",
  ", ",
  ButtonBox["NeuralNetworks 9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Continuous"],

Cell[TextData[{
  StyleBox["CreationDate", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CreationDate"],

Cell[TextData[{
  StyleBox["CriterionLog", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CriterionLog"],

Cell[TextData[{
  StyleBox["CriterionLogExtN", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CriterionLogExtN"],

Cell[TextData[{
  StyleBox["CriterionPlot", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CriterionPlot"],

Cell[TextData[{
  StyleBox["CriterionValidationValues",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["NeuralNetworks 7.8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CriterionValidationValues"],

Cell[TextData[{
  StyleBox["CriterionValues", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CriterionValues"],

Cell[TextData[{
  StyleBox["DataFormat", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataFormat"],

Cell[TextData[{
  StyleBox["DataFormat", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataFormat"],

Cell[TextData[{
  StyleBox["DataFormat", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Hopfield Network",
  ", ",
  ButtonBox["NeuralNetworks 9.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataFormat"],

Cell[TextData[{
  StyleBox["DataFormat", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataFormat"],

Cell[TextData[{
  StyleBox["DataFormat", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Unsupervised Network",
  ", ",
  ButtonBox["NeuralNetworks 10.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataFormat"],

Cell[TextData[{
  StyleBox["DataFormat", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", VQ ",
  ", ",
  ButtonBox["NeuralNetworks 11.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataFormat"],

Cell[TextData[{
  StyleBox["DataMapArray", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataMapArray"],

Cell[TextData[{
  StyleBox["DataMapArray", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Unsupervised Network",
  ", ",
  ButtonBox["NeuralNetworks 10.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataMapArray"],

Cell[TextData[{
  StyleBox["DataMapArray", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", VQ",
  ", ",
  ButtonBox["NeuralNetworks 11.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataMapArray"],

Cell[TextData[{
  StyleBox["DataMap", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataMap"],

Cell[TextData[{
  StyleBox["DataMap", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Unsupervised Network",
  ", ",
  ButtonBox["NeuralNetworks 10.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DataMap"],

Cell[TextData[{
  "Data PreProcessing",
  ", ",
  ButtonBox["NeuralNetworks 2.2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Data PreProcessing"],

Cell[TextData[{
  StyleBox["DeleteSOM", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DeleteSOM"],

Cell[TextData[{
  StyleBox["Discrete",
    FontFamily->"Courier"],
  ", ",
  "Hopfield",
  ", ",
  ButtonBox["NeuralNetworks 9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Discrete"],

Cell[TextData[{
  "Dynamic models",
  ", ",
  ButtonBox["NeuralNetworks 2.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dynamic models"],

Cell[TextData[{
  "Dynamic neural networks",
  ", ",
  ButtonBox["NeuralNetworks 8.0.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dynamic neural networks"],

Cell[TextData[{
  StyleBox["Energy", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Hopfield Network",
  ", ",
  ButtonBox["NeuralNetworks 9.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Energy"],

Cell[TextData[{
  StyleBox["ErrorDistribution", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ErrorDistribution"],

Cell[TextData[{
  StyleBox["ErrorDistribution", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ErrorDistribution"],

Cell[TextData[{
  StyleBox["FeedForwardNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FeedForwardNet"],

Cell[TextData[{
  StyleBox["FixedParameters", "MR"],
  ", ",
  StyleBox["InitializeFeedForwardNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FixedParameters"],

Cell[TextData[{
  StyleBox["FixedParameters", "MR"],
  ", ",
  StyleBox["InitializeRBFNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 6.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FixedParameters"],

Cell[TextData[{
  StyleBox["FixedParameters", "MR"],
  ", ",
  StyleBox["NeuralFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FixedParameters"],

Cell[TextData[{
  "Function approximation",
  ", ",
  ButtonBox["NeuralNetworks 2.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Function approximation"],

Cell[TextData[{
  StyleBox["FunctionPlot", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FunctionPlot"],

Cell[TextData[{
  StyleBox["FunctionPlot", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FunctionPlot"],

Cell[TextData[{
  "Gauss-Newton",
  ", ",
  ButtonBox["NeuralNetworks 7.2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gauss-Newton"],

Cell[TextData[{
  StyleBox["Gauss-Newton", "Text"],
  ", ",
  ButtonBox["NeuralNetworks 2.5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Gauss-Newton"],

Cell[TextData[{
  StyleBox["GaussNewton",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["NeuralFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaussNewton"],

Cell[TextData[{
  StyleBox["HiddenNeurons", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HiddenNeurons"],

Cell[TextData[{
  StyleBox["HiddenNeurons", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HiddenNeurons"],

Cell[TextData[{
  StyleBox["Hopfield",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["NeuralNetworks 9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hopfield"],

Cell[TextData[{
  StyleBox["HopfieldEnergy", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 9.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HopfieldEnergy"],

Cell[TextData[{
  StyleBox["HopfieldFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HopfieldFit"],

Cell[TextData[{
  "Hopfield Networks",
  ", ",
  ButtonBox["NeuralNetworks 9.0.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Hopfield Networks"],

Cell[TextData[{
  StyleBox["InitialInput", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialInput"],

Cell[TextData[{
  "Initialization",
  ", ",
  "feedforward network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Initialization"],

Cell[TextData[{
  StyleBox["InitializeFeedForwardNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitializeFeedForwardNet"],

Cell[TextData[{
  StyleBox["InitializePerceptron", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 4.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitializePerceptron"],

Cell[TextData[{
  StyleBox["InitializeRBFNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 6.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitializeRBFNet"],

Cell[TextData[{
  StyleBox["InitializeUnsupervisedNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitializeUnsupervisedNet"],

Cell[TextData[{
  StyleBox["InitializeVQ", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 11.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitializeVQ"],

Cell[TextData[{
  StyleBox["InitialOutput", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialOutput"],

Cell[TextData[{
  StyleBox["InitialRange", "MR"],
  ", ",
  StyleBox["InitializeFeedForwardNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialRange"],

Cell[TextData[{
  StyleBox["InitialRange", "MR"],
  ", ",
  StyleBox["InitializeRBFNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 6.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialRange"],

Cell[TextData[{
  StyleBox["InitialRange", "MR"],
  ", ",
  StyleBox["Initialize", "MR",
    FontFamily->"Courier"],
  StyleBox["VQ", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 11.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InitialRange"],

Cell[TextData[{
  "Kohonen networks",
  ", ",
  ButtonBox["NeuralNetworks 10.0.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kohonen networks"],

Cell[TextData[{
  "Kohonen networks",
  ", ",
  ButtonBox["NeuralNetworks 2.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["NeuralNetworks 2.8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kohonen networks"],

Cell[TextData[{
  "Learning Vector Quantization",
  " ",
  "1",
  ", ",
  ButtonBox["NeuralNetworks 11.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Learning Vector Quantization 1"],

Cell[TextData[{
  StyleBox["Levenberg-Marquardt", "Text"],
  ", ",
  ButtonBox["NeuralNetworks 2.5.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Levenberg-Marquardt"],

Cell[TextData[{
  "Levenberg-Marquardt",
  ", ",
  StyleBox["NeuralFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.2.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Levenberg-Marquardt"],

Cell[TextData[{
  StyleBox["LinearizeNet", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearizeNet"],

Cell[TextData[{
  StyleBox["LinearizeNet", "MR"],
  ", ",
  "FeedForward Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearizeNet"],

Cell[TextData[{
  StyleBox["LinearizeNet", "MR"],
  ", ",
  "RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 6.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearizeNet"],

Cell[TextData[{
  "Linear Models",
  ", ",
  ButtonBox["NeuralNetworks 2.3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Linear Models"],

Cell[TextData[{
  StyleBox["LinearParameters", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearParameters"],

Cell[TextData[{
  StyleBox["LinearParameters", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearParameters"],

Cell[TextData[{
  StyleBox["LinearPart", "MR"],
  ", ",
  StyleBox["InitializeFeedForwardNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 5.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearPart"],

Cell[TextData[{
  StyleBox["LinearPart", "MR"],
  ", ",
  StyleBox["InitializeRBFNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 6.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LinearPart"],

Cell[TextData[{
  "LVQ1",
  ", ",
  ButtonBox["NeuralNetworks 11.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LVQ1"],

Cell[TextData[{
  StyleBox["MakeRegressor", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MakeRegressor"],

Cell[TextData[{
  StyleBox["Method", "MR"],
  ", ",
  StyleBox["NeuralFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Method"],

Cell[TextData[{
  StyleBox["Method", "MR"],
  ", ",
  StyleBox["VQFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 11.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Method"],

Cell[TextData[{
  StyleBox["MinIterations", "MR"],
  ", ",
  StyleBox["NeuralFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MinIterations"],

Cell[TextData[{
  StyleBox["Momentum", "MR"],
  ", ",
  StyleBox["NeuralFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Momentum"],

Cell[TextData[{
  StyleBox["MoreTrainingPrompt", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.7.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MoreTrainingPrompt"],

Cell[TextData[{
  "Multilayer Networks",
  ", ",
  ButtonBox["NeuralNetworks 2.5.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multilayer Networks"],

Cell[TextData[{
  StyleBox["MultiplePrediction", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplePrediction"],

Cell[TextData[{
  StyleBox["NeighborStrength", "MR"],
  ", ",
  StyleBox["UnsupervisedNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeighborStrength"],

Cell[TextData[{
  StyleBox["NeighborStrength", "MR"],
  ", ",
  StyleBox["UnsupervisedNetFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeighborStrength"],

Cell[TextData[{
  StyleBox["Neighbor", "MR"],
  ", ",
  StyleBox["UnsupervisedNet", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Neighbor"],

Cell[TextData[{
  StyleBox["Neighbor", "MR"],
  ", ",
  StyleBox["UnsupervisedNetFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 10.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Neighbor"],

Cell[TextData[{
  StyleBox["NetClassificationPlot", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 3.3.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetClassificationPlot"],

Cell[TextData[{
  StyleBox["NetComparePlot", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetComparePlot"],

Cell[TextData[{
  StyleBox["NetInformation", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetInformation"],

Cell[TextData[{
  StyleBox["NetInformation", "MR"],
  ", ",
  "FeedForward Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetInformation"],

Cell[TextData[{
  StyleBox["NetInformation", "MR"],
  ", ",
  "Hopfield Network",
  ", ",
  ButtonBox["NeuralNetworks 9.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetInformation"],

Cell[TextData[{
  StyleBox["NetInformation", "MR"],
  ", ",
  "Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetInformation"],

Cell[TextData[{
  StyleBox["NetInformation", "MR"],
  ", ",
  "RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 6.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetInformation"],

Cell[TextData[{
  StyleBox["NetInformation", "MR"],
  ", ",
  "Unsupervised Network",
  ", ",
  ButtonBox["NeuralNetworks 10.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetInformation"],

Cell[TextData[{
  StyleBox["NetInformation", "MR"],
  ", ",
  "VQ",
  ", ",
  ButtonBox["NeuralNetworks 11.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetInformation"],

Cell[TextData[{
  StyleBox["NetOutput", "MR"],
  ", ",
  StyleBox["NetPlot", "MR"],
  ", FF and RBF Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetOutput"],

Cell[TextData[{
  StyleBox["NetPlot", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPlot"],

Cell[TextData[{
  StyleBox["NetPlot", "MR"],
  ", ",
  "FeedForward and RBFNetworks",
  ", ",
  ButtonBox["NeuralNetworks 5.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPlot"],

Cell[TextData[{
  StyleBox["NetPlot", "MR"],
  ", ",
  "Hopfield Network",
  ", ",
  ButtonBox["NeuralNetworks 9.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPlot"],

Cell[TextData[{
  StyleBox["NetPlot", "MR"],
  ", ",
  "Perceptron Network",
  ", ",
  ButtonBox["NeuralNetworks 4.1.4",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPlot"],

Cell[TextData[{
  StyleBox["NetPlot", "MR"],
  ", ",
  "Unsupervised Network",
  ", ",
  ButtonBox["NeuralNetworks 10.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPlot"],

Cell[TextData[{
  StyleBox["NetPlot", "MR"],
  ", ",
  "VQ",
  ", ",
  ButtonBox["NeuralNetworks 11.1.5",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPlot"],

Cell[TextData[{
  StyleBox["NetPredict", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPredict"],

Cell[TextData[{
  StyleBox["NetPredictionError", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetPredictionError"],

Cell[TextData[{
  StyleBox["NetSimulate", "MR"],
  ", ",
  "Dynamic Network",
  ", ",
  ButtonBox["NeuralNetworks 8.1.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetSimulate"],

Cell[TextData[{
  StyleBox["NetType", "MR"],
  ", ",
  StyleBox["HopfieldFit",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["NeuralNetworks 9.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NetType"],

Cell[TextData[{
  StyleBox["NeuralARFit",
    FontFamily->"Courier"],
  ", ",
  ButtonBox["NeuralNetworks 8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralARFit"],

Cell[TextData[{
  StyleBox["NeuralARFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralARFit"],

Cell[TextData[{
  StyleBox["NeuralARX", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralARX"],

Cell[TextData[{
  StyleBox["NeuralARXFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 8.1.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralARXFit"],

Cell[TextData[{
  StyleBox["NeuralD", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 5.1.6",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralD"],

Cell[TextData[{
  StyleBox["NeuralFit", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralFit"],

Cell[TextData[{
  StyleBox["NeuralFit", "MR"],
  ", ",
  "FeedForward Network",
  ", ",
  ButtonBox["NeuralNetworks 5.1.2",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralFit"],

Cell[TextData[{
  StyleBox["NeuralFitRecord", "MR"],
  ", ",
  ButtonBox["NeuralNetworks 7.1.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["NeuralNetworks 7.8.0",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NeuralFitRecord"],

Cell[TextData[{
  "Neural network",
  ", ",
  "data format",
  ", ",
  ButtonBox["NeuralNetworks 3.2.1",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Neural network"],

Cell[TextData[{
  "Neural network",
  ", ",
  "network format",
  ", ",
  ButtonBox["NeuralNetworks 3.2.3",
    ButtonData:>{"Mathematica Applications from Wolfram Research", 
      "Neural Networks"},
    ButtonStyle->"AddOnsLink"