(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    137069,       4316]*)
(*NotebookOutlinePosition[    151774,       4623]*)
(*  CellTagsIndexPosition[    151479,       4611]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Introduction to Add-ons", "Section",
  CellTags->{"Installing", "AddOnsIntro"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comes equipped with hundreds of built-in functions. However, if you work \
in a specialized area, you may find that you need functions that are not \
built into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". You can extend ",
  StyleBox["Mathematica'",
    FontSlant->"Italic"],
  "s capabilities beyond the built-in functions by using add-ons."
}], "Text",
  CellTags->{"Installing", "AddOnsIntro"}],

Cell[TextData[{
  "An ",
  StyleBox["add-on",
    FontSlant->"Italic"],
  " is a collection of files that define new ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions. These files may include ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code as .m or .mx files, notebooks, ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs, and configuration files. The terms ",
  StyleBox["add-on, add-on package",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["package",
    FontSlant->"Italic"],
  " are often used interchangeably."
}], "Text",
  CellTags->{"Installing", "AddOnsIntro"}],

Cell[TextData[{
  "There are hundreds of add-ons available for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Add-ons that are part of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are called s",
  StyleBox["tandard packages", "TI"],
  ". There are some add-ons that are for sale by Wolfram Research and also by \
independent developers. Go to ",
  ButtonBox["www.wolfram.com/products",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products"], None},
    ButtonStyle->"Hyperlink"],
  " for a listing of currently available add-ons for sale. Finally, there are \
free add-ons that are available from many sources. One of the largest of \
these collections may be found at ",
  ButtonBox["library.wolfram.com",
    ButtonData:>{
      URL[ "http://library.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"Installing", "AddOnsIntro"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Add-ons", "Section",
  CellTags->{"Installing", "UsingAddOns", "InstallingAddOns"}],

Cell[CellGroupData[{

Cell["Loading An Add-on", "Subsection",
  CellTags->"UsingAddOns"],

Cell[TextData[{
  "In order to use the functions defined in an add-on, you must first load \
the add-on package into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". If you do not load the add-on first, you will generate multiple \
conflicting definitions for the same function (see ",
  ButtonBox["Shadowing Conflicts",
    ButtonData:>{"Using Add-ons", "Shadowing Conflicts"},
    ButtonStyle->"AddOnsLinkText"],
  "). To load an add-on, you need to know its name and the directory in which \
it is located. All the standard packages that come with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are located in several subdirectories inside the AddOns/StandardPackages \
directory. Other add-ons should be located in either the Applications or \
Autoload subdirectories of $",
  StyleBox["BaseDirectory", "MR"],
  " or $",
  StyleBox["UserBaseDirectory", "MR"],
  ". See ",
  ButtonBox["Installing New Add-Ons",
    ButtonData:>"Installing New Add-ons",
    ButtonStyle->"AddOnsLinkText"],
  " for more information about these installation locations."
}], "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[TextData[{
  "For example, the add-on ",
  StyleBox["ContourPlot3D.m", "MR"],
  " is located inside the Graphics directory in StandardPackages. To load ",
  StyleBox["ContourPlot3D.m", "MR"],
  ", use the command ",
  StyleBox["Needs", "MR"],
  "."
}], "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[BoxData[
    \(Needs["\<Graphics`ContourPlot3D`\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Installing", "UsingAddOns"}],

Cell["\<\
The two backquotes in the above command should not be confused with \
the single quote character. The backquote character can be found on the same \
key as the ~ character on most keyboards.\
\>", "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[TextData[{
  "In the above command, it was not necessary to specify the StandardPackages \
directory because it is on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s search path. You can get a list of directories on this search path at \
any time by evaluating ",
  StyleBox["$Path", "MR"],
  ". For more information about  and ",
  StyleBox["$Path", "MR"],
  ", see ",
  StyleBox["The Mathematica Book", "TI"],
  ": ",
  ButtonBox["Section 1.11.2",
    ButtonData:>{"1.11.2", "2.6"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.12.4",
    ButtonData:>{"2.12.4", "4.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($Path\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[BoxData[
    \({"C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\AddOns\\JLink", 
      "C:\\Documents and Settings\\thail.WRI\\Application \
Data\\Mathematica\\Kernel", 
      "C:\\Documents and Settings\\thail.WRI\\Application \
Data\\Mathematica\\Autoload", 
      "C:\\Documents and Settings\\thail.WRI\\Application \
Data\\Mathematica\\Applications", 
      "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Kernel", 
      "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Autoload", 
      "C:\\Documents and Settings\\All Users\\Application \
Data\\Mathematica\\Applications", ".", 
      "C:\\Documents and Settings\\thail.WRI", 
      "C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\AddOns\\StandardPackages", 
      "C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\AddOns\\StandardPackages\\StartUp", 
      "C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\AddOns\\Autoload", 
      "C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\AddOns\\Applications", 
      "C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\AddOns\\ExtraPackages", 
      "C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\SystemFiles\\Graphics\\Packages", 
      "C:\\Program Files\\Wolfram \
Research\\Mathematica\\4.2\\Configuration\\Kernel"}\)], "Output",
  CellLabel->"Out[1]="]
}, Closed]],

Cell[TextData[{
  "Now that ",
  StyleBox["ContourPlot3D.m", "MR"],
  " is loaded, its context appears on the search path, and we can use ",
  StyleBox["ContourPlot3D", "MR"],
  " as we would use any built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function."
}], "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot3D[
      Cos\ [x*y*z], \ {x, \(-2\), 2}, \ {y, \ \(-2\), 2}, \ {z, \ \(-2\), \ 
        2}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 5.12828e-017 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.47777 .60677 m .4295 .57924 L .45169 .53459 L closepath p .426 .429 .759 r
F P
0 g
s
.46722 .61979 m .39246 .60702 L .42193 .58851 L closepath p .682 .238 .191 r
F P
0 g
s
.38664 .59107 m .43532 .53165 L .41782 .57721 L closepath p .893 .986 .796 r
F P
0 g
s
.47777 .60677 m .51253 .55209 L .45169 .53459 L closepath p .772 .623 .694 r
F P
0 g
s
.41929 .66702 m .46722 .61979 L .39246 .60702 L closepath p .742 .629 .734 r
F P
0 g
s
.38664 .59107 m .43532 .53165 L .36798 .52625 L closepath p .726 .579 .69 r
F P
0 g
s
.59588 .57105 m .61239 .51944 L .5684 .49391 L closepath p .842 .656 .65 r
F P
0 g
s
.59202 .58027 m .59588 .57105 L .5684 .49391 L p .816 .644 .669 r
F P
0 g
s
.53957 .55092 m .59202 .58027 L .56269 .64534 L p .798 .657 .707 r
F P
0 g
s
.55978 .48984 m .53957 .55092 L .59202 .58027 L p .816 .644 .669 r
F P
0 g
s
.5684 .49391 m .55978 .48984 L p .59202 .58027 L .816 .644 .669 r
F P
0 g
s
.71956 .5317 m .69838 .49132 L .69182 .45262 L closepath p 0 0 .558 r
F P
0 g
s
.49699 .46209 m .55978 .48984 L .53957 .55092 L p .791 .612 .659 r
F P
0 g
s
.41605 .76329 m .46718 .73131 L .38639 .71846 L closepath p .726 .675 .8 r
F P
0 g
s
.44189 .67163 m .47594 .72487 L .46718 .73131 L p .734 .659 .776 r
F P
0 g
s
.38131 .70974 m .44189 .67163 L p .46718 .73131 L .734 .659 .776 r
F P
0 g
s
.46718 .73131 m .38639 .71846 L .38131 .70974 L p .734 .659 .776 r
F P
0 g
s
.53642 .67815 m .56269 .64534 L .50816 .62376 L closepath p .787 .671 .736 r
F P
0 g
s
.50331 .61285 m .53957 .55092 L p .56269 .64534 L .798 .657 .707 r
F P
0 g
s
.56269 .64534 m .50816 .62376 L .50331 .61285 L p .798 .657 .707 r
F P
0 g
s
.53642 .67815 m .47594 .72487 L .44189 .67163 L p .758 .668 .762 r
F P
0 g
s
.50816 .62376 m .53642 .67815 L p .44189 .67163 L .758 .668 .762 r
F P
0 g
s
.50331 .61285 m .53957 .55092 L .47327 .5295 L closepath p .784 .629 .689 r
F P
0 g
s
.46992 .51764 m .49699 .46209 L p .53957 .55092 L .791 .612 .659 r
F P
0 g
s
.53957 .55092 m .47327 .5295 L .46992 .51764 L p .791 .612 .659 r
F P
0 g
s
.31393 .52079 m .36729 .45652 L .30617 .46306 L closepath p .673 .5 .643 r
F P
0 g
s
.46992 .51764 m .49699 .46209 L .45585 .45436 L closepath p .756 .576 .652 r
F P
0 g
s
.7243 .53838 m .71956 .5317 L .69182 .45262 L p .055 .185 .683 r
F P
0 g
s
.44189 .67163 m .38131 .70974 L .34595 .64656 L p .72 .62 .746 r
F P
0 g
s
.36729 .45652 m .37833 .45605 L p .3159 .53133 L .694 .53 .661 r
F P
0 g
s
.3159 .53133 m .31393 .52079 L .36729 .45652 L p .694 .53 .661 r
F P
0 g
s
.84897 .48852 m .80559 .45627 L .82213 .41076 L closepath p .368 .39 .752 r
F P
0 g
s
.37833 .45605 m .45585 .45436 L p .4636 .52776 L .72 .532 .636 r
F P
0 g
s
.4636 .52776 m .38811 .52375 L .37833 .45605 L p .72 .532 .636 r
F P
0 g
s
.37833 .45605 m .38811 .52375 L .3159 .53133 L p .694 .53 .661 r
F P
0 g
s
.45585 .45436 m .46992 .51764 L .4636 .52776 L p .72 .532 .636 r
F P
0 g
s
.69182 .45262 m .69173 .44552 L p .7243 .53838 L .055 .185 .683 r
F P
0 g
s
.71688 .4932 m .7243 .53838 L .76042 .58483 L p .259 .36 .777 r
F P
0 g
s
.69173 .44552 m .71688 .4932 L .7243 .53838 L p .055 .185 .683 r
F P
0 g
s
.44189 .67163 m .49708 .62056 L .50816 .62376 L p .758 .668 .762 r
F P
0 g
s
.50816 .62376 m .50331 .61285 L .49708 .62056 L closepath p .771 .646 .724 r
F P
0 g
s
.47327 .5295 m .50331 .61285 L .49708 .62056 L p .749 .612 .706 r
F P
0 g
s
.44189 .67163 m .49708 .62056 L .41098 .60581 L closepath p .742 .637 .744 r
F P
0 g
s
.4636 .52776 m .47327 .5295 L p .49708 .62056 L .749 .612 .706 r
F P
0 g
s
.40754 .59636 m .4636 .52776 L p .49708 .62056 L .749 .612 .706 r
F P
0 g
s
.49708 .62056 m .41098 .60581 L .40754 .59636 L p .749 .612 .706 r
F P
0 g
s
.41098 .60581 m .44189 .67163 L p .34595 .64656 L .72 .62 .746 r
F P
0 g
s
.6937 .39416 m .69173 .44552 L .71688 .4932 L p .189 .237 .682 r
F P
0 g
s
.3159 .53133 m .38811 .52375 L p .39853 .605 L .702 .54 .666 r
F P
0 g
s
.39853 .605 m .33107 .60601 L .3159 .53133 L p .702 .54 .666 r
F P
0 g
s
.47327 .5295 m .46992 .51764 L .4636 .52776 L closepath p .754 .592 .676 r
F P
0 g
s
.40754 .59636 m .4636 .52776 L .38811 .52375 L closepath p .721 .569 .683 r
F P
0 g
s
.46499 .85178 m .38115 .83951 L .41321 .84787 L closepath p .111 .64 .871 r
F P
0 g
s
.38811 .52375 m .40754 .59636 L .39853 .605 L p .702 .54 .666 r
F P
0 g
s
.34595 .64656 m .39853 .605 L .41098 .60581 L p .72 .62 .746 r
F P
0 g
s
.34595 .64656 m .39853 .605 L .33107 .60601 L closepath p .703 .589 .725 r
F P
0 g
s
.41098 .60581 m .40754 .59636 L .39853 .605 L closepath p .723 .599 .717 r
F P
0 g
s
.90144 .42493 m .90689 .41673 L p .86206 .49475 L .573 .367 .563 r
F P
0 g
s
.86206 .49475 m .84897 .48852 L .90144 .42493 L p .573 .367 .563 r
F P
0 g
s
.90689 .41673 m .91115 .4292 L .86206 .49475 L p .573 .367 .563 r
F P
0 g
s
.46499 .85178 m .47394 .85351 L p .3755 .8391 L .23 0 0 r
F P
0 g
s
.3755 .8391 m .38115 .83951 L .46499 .85178 L p .23 0 0 r
F P
0 g
s
.79125 .60137 m .76042 .58483 L .76446 .54343 L closepath p .353 .45 .821 r
F P
0 g
s
.75972 .53187 m .71688 .4932 L p .76042 .58483 L .259 .36 .777 r
F P
0 g
s
.76042 .58483 m .76446 .54343 L .75972 .53187 L p .259 .36 .777 r
F P
0 g
s
.23469 .44204 m .29091 .3753 L .25122 .40689 L closepath p .039 0 .08 r
F P
0 g
s
.92184 .51103 m .86206 .49475 L .89608 .44391 L closepath p .499 .5 .789 r
F P
0 g
s
.75972 .53187 m .71688 .4932 L .72907 .4441 L closepath p .287 .34 .743 r
F P
0 g
s
.72544 .43169 m .6937 .39416 L p .71688 .4932 L .189 .237 .682 r
F P
0 g
s
.71688 .4932 m .72907 .4441 L .72544 .43169 L p .189 .237 .682 r
F P
0 g
s
.47394 .85351 m .53702 .8682 L .50674 .86934 L p .453 0 0 r
F P
0 g
s
.47394 .85351 m .43734 .84344 L .3755 .8391 L p .23 0 0 r
F P
0 g
s
.43734 .84344 m .47394 .85351 L p .50674 .86934 L .453 0 0 r
F P
0 g
s
.89003 .42626 m .82917 .39935 L .8685 .35534 L closepath p .484 .433 .725 r
F P
0 g
s
.72544 .43169 m .6937 .39416 L .70906 .36583 L closepath p .326 .298 .674 r
F P
0 g
s
.3755 .8391 m .43734 .84344 L .40186 .8529 L p .471 0 0 r
F P
0 g
s
.335 .83875 m .3755 .8391 L p .40186 .8529 L .471 0 0 r
F P
0 g
s
.83194 .55145 m .86209 .61067 L .79125 .60137 L p .454 .51 .826 r
F P
0 g
s
.767 .53561 m .83194 .55145 L p .79125 .60137 L .454 .51 .826 r
F P
0 g
s
.79125 .60137 m .76446 .54343 L .767 .53561 L p .454 .51 .826 r
F P
0 g
s
.4604 .98208 m .37687 .971 L .40959 .95557 L closepath p .632 .15 .089 r
F P
0 g
s
.29091 .3753 m .29712 .36911 L p .2311 .44749 L 0 0 0 r
F P
0 g
s
.2311 .44749 m .23469 .44204 L .29091 .3753 L p 0 0 0 r
F P
0 g
s
.33948 .3236 m .29712 .36911 L .2787 .41038 L p 0 0 0 r
F P
0 g
s
.29712 .36911 m .2787 .41038 L .2311 .44749 L p 0 0 0 r
F P
0 g
s
.70906 .36583 m .76148 .32016 L p .73281 .43762 L .422 .362 .685 r
F P
0 g
s
.73281 .43762 m .72544 .43169 L .70906 .36583 L p .422 .362 .685 r
F P
0 g
s
.5655 .88906 m .50674 .86934 L .53702 .8682 L closepath p .676 .143 0 r
F P
0 g
s
.76446 .54343 m .75972 .53187 L .767 .53561 L closepath p .393 .444 .794 r
F P
0 g
s
.767 .53561 m .75972 .53187 L .72907 .4441 L p .435 .433 .758 r
F P
0 g
s
.2787 .41038 m .2311 .44749 L .20387 .48466 L p .642 .93 .664 r
F P
0 g
s
.72907 .4441 m .72544 .43169 L .73281 .43762 L closepath p .377 .361 .714 r
F P
0 g
s
.83194 .55145 m .767 .53561 L .80239 .47942 L closepath p .493 .509 .801 r
F P
0 g
s
.79884 .46919 m .80239 .47942 L .767 .53561 L p .435 .433 .758 r
F P
0 g
s
.73281 .43762 m .79884 .46919 L p .767 .53561 L .435 .433 .758 r
F P
0 g
s
.72907 .4441 m .73281 .43762 L p .767 .53561 L .435 .433 .758 r
F P
0 g
s
.50674 .86934 m .49479 .86641 L .43734 .84344 L p .453 0 0 r
F P
0 g
s
.49479 .86641 m .40186 .8529 L .43734 .84344 L closepath p .548 .003 0 r
F P
0 g
s
.79884 .46919 m .73281 .43762 L .77648 .39147 L closepath p .472 .417 .714 r
F P
0 g
s
.76148 .32016 m .77648 .39147 L .73281 .43762 L p .422 .362 .685 r
F P
0 g
s
.8726 .61171 m .86209 .61067 L .83194 .55145 L p .525 .584 .856 r
F P
0 g
s
.4604 .98208 m .4718 .99141 L .43971 1.02433 L p .7 .294 .275 r
F P
0 g
s
.37687 .971 m .4604 .98208 L p .43971 1.02433 L .7 .294 .275 r
F P
0 g
s
.50674 .86934 m .5655 .88906 L .59981 .94771 L p .801 .336 .13 r
F P
0 g
s
.93502 .61192 m .8726 .61171 L .90984 .56025 L closepath p .563 .603 .851 r
F P
0 g
s
.90536 .55029 m .90984 .56025 L .8726 .61171 L p .525 .584 .856 r
F P
0 g
s
.83194 .55145 m .90536 .55029 L p .8726 .61171 L .525 .584 .856 r
F P
0 g
s
.14813 .35379 m .20509 .28725 L .18035 .33444 L closepath p .852 .996 .765 r
F P
0 g
s
.51035 1.03881 m .43971 1.02433 L .4718 .99141 L closepath p .756 .369 .322 r
F P
0 g
s
.41443 1.06118 m .40091 1.0595 L .40628 1.05402 L closepath p .705 .312 .302 \
r
F P
0 g
s
.40186 .8529 m .38841 .85216 L .335 .83875 L p .471 0 0 r
F P
0 g
s
.38841 .85216 m .31562 .85308 L .335 .83875 L closepath p .53 .059 .081 r
F P
0 g
s
.31846 .352 m .3498 .29306 L .33948 .3236 L closepath p .851 .927 .541 r
F P
0 g
s
.31846 .352 m .33948 .3236 L p .2787 .41038 L 0 0 0 r
F P
0 g
s
.36926 .97789 m .37687 .971 L p .43971 1.02433 L .7 .294 .275 r
F P
0 g
s
.77648 .39147 m .76148 .32016 L .76948 .3136 L p .474 .365 .65 r
F P
0 g
s
.2787 .41038 m .31129 .36282 L .31846 .352 L p 0 0 0 r
F P
0 g
s
.24886 .437 m .31129 .36282 L .2787 .41038 L closepath p .729 .945 .635 r
F P
0 g
s
.24886 .437 m .2787 .41038 L p .20387 .48466 L .642 .93 .664 r
F P
0 g
s
.76948 .3136 m .83433 .34059 L p .77648 .39147 L .474 .365 .65 r
F P
0 g
s
.83433 .34059 m .76948 .3136 L .82057 .2787 L closepath p .51 .39 .652 r
F P
0 g
s
.50141 .87135 m .50674 .86934 L p .59981 .94771 L .801 .336 .13 r
F P
0 g
s
.50141 .87135 m .49479 .86641 L .50674 .86934 L closepath p .692 .202 .079 r
F P
0 g
s
.87372 .4782 m .90536 .55029 L .83194 .55145 L p .546 .539 .798 r
F P
0 g
s
.80963 .47185 m .87372 .4782 L p .83194 .55145 L .546 .539 .798 r
F P
0 g
s
.83194 .55145 m .80239 .47942 L .80963 .47185 L p .546 .539 .798 r
F P
0 g
s
.43971 1.02433 m .42069 1.02189 L .36926 .97789 L p .7 .294 .275 r
F P
0 g
s
.42069 1.02189 m .34243 1.01742 L .36926 .97789 L closepath p .679 .315 .349 \
r
F P
0 g
s
.49479 .86641 m .50141 .87135 L .46676 .90327 L p .686 .255 .218 r
F P
0 g
s
.40186 .8529 m .49479 .86641 L p .46676 .90327 L .686 .255 .218 r
F P
0 g
s
.59981 .94771 m .54117 .92206 L .50141 .87135 L p .801 .336 .13 r
F P
0 g
s
.54117 .92206 m .46676 .90327 L .50141 .87135 L closepath p .767 .365 .29 r
F P
0 g
s
.77648 .39147 m .83719 .352 L p .80963 .47185 L .523 .449 .714 r
F P
0 g
s
.80963 .47185 m .79884 .46919 L .77648 .39147 L p .523 .449 .714 r
F P
0 g
s
.83433 .34059 m .83719 .352 L .77648 .39147 L p .474 .365 .65 r
F P
0 g
s
.1817 .49239 m .23895 .44646 L .20387 .48466 L closepath p .742 .993 .846 r
F P
0 g
s
.20387 .48466 m .23895 .44646 L .24886 .437 L p .642 .93 .664 r
F P
0 g
s
.3498 .29306 m .34135 .2325 L p .31363 .35574 L .957 .948 .67 r
F P
0 g
s
.31363 .35574 m .31846 .352 L .3498 .29306 L p .957 .948 .67 r
F P
0 g
s
.80239 .47942 m .79884 .46919 L .80963 .47185 L closepath p .506 .476 .758 r
F P
0 g
s
.59981 .94771 m .60456 .95658 L .57534 .99049 L p .833 .489 .405 r
F P
0 g
s
.54117 .92206 m .59981 .94771 L p .57534 .99049 L .833 .489 .405 r
F P
0 g
s
.29012 .90488 m .31562 .85308 L .38841 .85216 L p .648 .311 .388 r
F P
0 g
s
.39763 .85631 m .40186 .8529 L p .46676 .90327 L .686 .255 .218 r
F P
0 g
s
.39763 .85631 m .38841 .85216 L .40186 .8529 L closepath p .604 .149 .144 r
F P
0 g
s
.20509 .28725 m .20852 .27425 L p .13852 .35595 L .902 .958 .821 r
F P
0 g
s
.13852 .35595 m .14813 .35379 L .20509 .28725 L p .902 .958 .821 r
F P
0 g
s
.38841 .85216 m .39763 .85631 L p .29012 .90488 L .648 .311 .388 r
F P
0 g
s
.87372 .4782 m .80963 .47185 L .85819 .43308 L closepath p .544 .499 .756 r
F P
0 g
s
.83719 .352 m .85819 .43308 L .80963 .47185 L p .523 .449 .714 r
F P
0 g
s
.62634 1.01176 m .57534 .99049 L .60456 .95658 L closepath p .857 .499 .372 r
F P
0 g
s
.46676 .90327 m .4559 .90174 L .39763 .85631 L p .686 .255 .218 r
F P
0 g
s
.4559 .90174 m .3711 .89822 L .39763 .85631 L closepath p .663 .291 .331 r
F P
0 g
s
.39763 .85631 m .3711 .89822 L .29012 .90488 L p .648 .311 .388 r
F P
0 g
s
.16567 .28143 m .21003 .21888 L .20852 .27425 L closepath p .934 .924 .776 r
F P
0 g
s
.20852 .27425 m .16567 .28143 L p .13852 .35595 L .902 .958 .821 r
F P
0 g
s
.31129 .36282 m .31363 .35574 L .31846 .352 L closepath p .897 .978 .688 r
F P
0 g
s
.31129 .36282 m .31363 .35574 L p .24387 .4386 L .897 .979 .807 r
F P
0 g
s
.24387 .4386 m .24886 .437 L .31129 .36282 L p .897 .979 .807 r
F P
0 g
s
.10745 .26839 m .11677 .25763 L .11469 .26731 L closepath p .902 .946 .825 r
F P
0 g
s
.78407 .79554 m .80782 .7965 L .87645 .74448 L p .76 .992 .883 r
F P
0 g
s
.7792 .83364 m .78407 .79554 L .80782 .7965 L closepath p .91 .975 .791 r
F P
0 g
s
.09476 .3528 m .15262 .2966 L .13852 .35595 L closepath p .866 .926 .864 r
F P
0 g
s
.16567 .28143 m .15262 .2966 L .13852 .35595 L p .902 .958 .821 r
F P
0 g
s
.8865 .73727 m .87645 .74448 L .84973 .73013 L p .71 .972 .928 r
F P
0 g
s
.87645 .74448 m .84973 .73013 L p .78407 .79554 L .76 .992 .883 r
F P
0 g
s
.78407 .79554 m .7792 .83364 L .74845 .91107 L p .963 .931 .708 r
F P
0 g
s
.27049 .36706 m .31461 .29852 L .31363 .35574 L closepath p .948 .934 .749 r
F P
0 g
s
.34135 .2325 m .31461 .29852 L .31363 .35574 L p .957 .948 .67 r
F P
0 g
s
.31363 .35574 m .27049 .36706 L p .24387 .4386 L .897 .979 .807 r
F P
0 g
s
.23895 .44646 m .1817 .49239 L .13153 .47979 L p .766 .955 .935 r
F P
0 g
s
.92573 .68778 m .8865 .73727 L p .84973 .73013 L .71 .972 .928 r
F P
0 g
s
.8865 .73727 m .92573 .68778 L .94666 .70106 L closepath p .754 .942 .944 r
F P
0 g
s
.23895 .44646 m .24387 .4386 L .24886 .437 L closepath p .824 .998 .838 r
F P
0 g
s
.24387 .4386 m .23895 .44646 L p .13153 .47979 L .766 .955 .935 r
F P
0 g
s
.57534 .99049 m .56532 .98709 L .54117 .92206 L p .833 .489 .405 r
F P
0 g
s
.46676 .90327 m .54117 .92206 L .56532 .98709 L p .81 .426 .326 r
F P
0 g
s
.19962 .43446 m .26315 .37574 L .24387 .4386 L closepath p .855 .938 .876 r
F P
0 g
s
.27049 .36706 m .26315 .37574 L .24387 .4386 L p .897 .979 .807 r
F P
0 g
s
.13153 .47979 m .19962 .43446 L .24387 .4386 L p .766 .955 .935 r
F P
0 g
s
.74845 .91107 m .74081 .8713 L p .71986 .95587 L .93 .905 .51 r
F P
0 g
s
.71986 .95587 m .74432 .92239 L .74845 .91107 L p .93 .905 .51 r
F P
0 g
s
.78003 .79724 m .78407 .79554 L p .74845 .91107 L .963 .931 .708 r
F P
0 g
s
.74845 .91107 m .74081 .8713 L .78003 .79724 L p .963 .931 .708 r
F P
0 g
s
.3397 .22354 m .34135 .2325 L .31461 .29852 L p .955 .852 .699 r
F P
0 g
s
.7268 .98833 m .71986 .95587 L .74432 .92239 L closepath p .978 .876 .505 r
F P
0 g
s
.29012 .90488 m .3711 .89822 L .35331 .95876 L p .639 .31 .399 r
F P
0 g
s
.28653 .91288 m .29012 .90488 L p .35331 .95876 L .639 .31 .399 r
F P
0 g
s
.29901 .2292 m .32297 .17196 L .3397 .22354 L closepath p .976 .85 .652 r
F P
0 g
s
.29901 .2292 m .3397 .22354 L p .31461 .29852 L .955 .852 .699 r
F P
0 g
s
.60594 .22132 m .69387 .21916 L .68571 .25937 L p .639 .222 .237 r
F P
0 g
s
.59149 .24831 m .60594 .22132 L p .68571 .25937 L .639 .222 .237 r
F P
0 g
s
.59149 .24831 m .55976 .21136 L .60594 .22132 L closepath p .717 .292 .238 r
F P
0 g
s
.46263 .91013 m .46676 .90327 L p .56532 .98709 L .81 .426 .326 r
F P
0 g
s
.46263 .91013 m .4559 .90174 L .46676 .90327 L closepath p .726 .358 .354 r
F P
0 g
s
.68571 .25937 m .69387 .21916 L .70647 .21856 L p .608 .241 .319 r
F P
0 g
s
.4559 .90174 m .46263 .91013 L p .35331 .95876 L .696 .395 .461 r
F P
0 g
s
.35331 .95876 m .3711 .89822 L .4559 .90174 L p .696 .395 .461 r
F P
0 g
s
.77272 .2441 m .70647 .21856 L .77767 .2101 L closepath p .565 .199 .306 r
F P
0 g
s
.70647 .21856 m .77272 .2441 L p .68571 .25937 L .608 .241 .319 r
F P
0 g
s
.35331 .95876 m .34041 .95915 L .28653 .91288 L p .639 .31 .399 r
F P
0 g
s
.34041 .95915 m .26912 .96465 L .28653 .91288 L closepath p .621 .318 .435 r
F P
0 g
s
.55976 .21136 m .59149 .24831 L .58794 .25167 L p .799 .391 .277 r
F P
0 g
s
.48684 .17403 m .55976 .21136 L p .58794 .25167 L .799 .391 .277 r
F P
0 g
s
.56532 .98709 m .49206 .96384 L .46263 .91013 L p .81 .426 .326 r
F P
0 g
s
.49206 .96384 m .44392 .95734 L .46263 .91013 L closepath p .74 .409 .422 r
F P
0 g
s
.46263 .91013 m .44392 .95734 L .35331 .95876 L p .696 .395 .461 r
F P
0 g
s
.78003 .79724 m .78693 .78833 L .78407 .79554 L closepath p .851 .989 .72 r
F P
0 g
s
.84973 .73013 m .78693 .78833 L .78407 .79554 L p .76 .992 .883 r
F P
0 g
s
.31461 .29852 m .29372 .23956 L p .26342 .3663 L .935 .881 .756 r
F P
0 g
s
.26342 .3663 m .27049 .36706 L .31461 .29852 L p .935 .881 .756 r
F P
0 g
s
.31461 .29852 m .29372 .23956 L .29901 .2292 L p .955 .852 .699 r
F P
0 g
s
.84973 .73013 m .92219 .68657 L .92573 .68778 L p .71 .972 .928 r
F P
0 g
s
.82605 .73632 m .84973 .73013 L .92219 .68657 L p .53 .914 .776 r
F P
0 g
s
.78693 .78833 m .82605 .73632 L .84973 .73013 L closepath p .741 .986 .774 r
F P
0 g
s
.78693 .78833 m .82605 .73632 L p .75534 .82779 L .582 .828 .454 r
F P
0 g
s
.75534 .82779 m .78003 .79724 L .78693 .78833 L p .582 .828 .454 r
F P
0 g
s
.74081 .8713 m .75534 .82779 L .78003 .79724 L closepath p .809 .907 .504 r
F P
0 g
s
.124 .47753 m .13153 .47979 L .19962 .43446 L p .78 .899 .926 r
F P
0 g
s
.92219 .68657 m .89719 .68059 L p .82605 .73632 L .53 .914 .776 r
F P
0 g
s
.07902 .45745 m .13884 .41712 L .124 .47753 L closepath p .779 .863 .911 r
F P
0 g
s
.14921 .40916 m .13884 .41712 L .124 .47753 L p .78 .899 .926 r
F P
0 g
s
.19962 .43446 m .14921 .40916 L p .124 .47753 L .78 .899 .926 r
F P
0 g
s
.26315 .37574 m .26342 .3663 L .27049 .36706 L closepath p .903 .92 .821 r
F P
0 g
s
.90418 .87267 m .94399 .82763 L .96157 .81525 L closepath p .608 .898 .605 r
F P
0 g
s
.26315 .37574 m .19962 .43446 L .14921 .40916 L p .821 .906 .899 r
F P
0 g
s
.26342 .3663 m .26315 .37574 L p .14921 .40916 L .821 .906 .899 r
F P
0 g
s
.97529 .9203 m .90418 .87267 L .94399 .82763 L closepath p .401 .407 .751 r
F P
0 g
s
.58794 .25167 m .5105 .22197 L .48684 .17403 L p .799 .391 .277 r
F P
0 g
s
.47642 .16833 m .48684 .17403 L .5105 .22197 L p .78 .276 0 r
F P
0 g
s
.74081 .8713 m .71989 .94989 L .71986 .95587 L p .93 .905 .51 r
F P
0 g
s
.75534 .82779 m .74081 .8713 L .71989 .94989 L p .91 .913 .518 r
F P
0 g
s
.8528 .95894 m .87363 .9205 L .89194 .88882 L closepath p .634 .798 .36 r
F P
0 g
s
.96615 .93251 m .87363 .9205 L .89194 .88882 L closepath p .656 .194 .145 r
F P
0 g
s
.44019 .17189 m .47642 .16833 L p .5105 .22197 L .78 .276 0 r
F P
0 g
s
.44019 .17189 m .42091 .13127 L .47642 .16833 L closepath p .848 .399 .14 r
F P
0 g
s
.2212 .35168 m .25396 .31314 L .26342 .3663 L closepath p .891 .876 .814 r
F P
0 g
s
.29372 .23956 m .25396 .31314 L .26342 .3663 L p .935 .881 .756 r
F P
0 g
s
.14921 .40916 m .2212 .35168 L .26342 .3663 L p .821 .906 .899 r
F P
0 g
s
.68571 .25937 m .59901 .25402 L .59149 .24831 L p .639 .222 .237 r
F P
0 g
s
.59901 .25402 m .58794 .25167 L .59149 .24831 L closepath p .659 .166 .069 r
F P
0 g
s
.68571 .25937 m .77131 .2492 L .7599 .28366 L p .428 0 0 r
F P
0 g
s
.66763 .28295 m .68571 .25937 L p .7599 .28366 L .428 0 0 r
F P
0 g
s
.77272 .2441 m .77131 .2492 L .68571 .25937 L p .608 .241 .319 r
F P
0 g
s
.66763 .28295 m .59901 .25402 L .68571 .25937 L closepath p .552 .053 .024 r
F P
0 g
s
.59901 .25402 m .66763 .28295 L .66426 .28394 L p .477 0 0 r
F P
0 g
s
.58794 .25167 m .59901 .25402 L p .66426 .28394 L .477 0 0 r
F P
0 g
s
.5543 .25909 m .58794 .25167 L p .66426 .28394 L .477 0 0 r
F P
0 g
s
.5543 .25909 m .5105 .22197 L .58794 .25167 L closepath p .665 .122 0 r
F P
0 g
s
.75264 .8346 m .75534 .82779 L p .71989 .94989 L .91 .913 .518 r
F P
0 g
s
.71989 .94989 m .72315 .9064 L .75264 .8346 L p .91 .913 .518 r
F P
0 g
s
.19294 .83081 m .17632 .74118 L .21382 .70568 L p .376 .313 .659 r
F P
0 g
s
.17632 .74118 m .15862 .69401 L .21382 .70568 L closepath p .469 .46 .765 r
F P
0 g
s
.21382 .70568 m .15862 .69401 L .11323 .61873 L p .416 .52 .856 r
F P
0 g
s
.89719 .68059 m .83403 .72929 L .82605 .73632 L p .53 .914 .776 r
F P
0 g
s
.82605 .73632 m .8235 .73946 L p .75534 .82779 L .582 .828 .454 r
F P
0 g
s
.8235 .73946 m .83403 .72929 L .82605 .73632 L closepath p 0 0 0 r
F P
0 g
s
.70442 .13527 m .63953 .11267 L .72193 .12096 L closepath p .474 0 0 r
F P
0 g
s
.5105 .22197 m .5543 .25909 L .54856 .25763 L p .759 .256 .014 r
F P
0 g
s
.44478 .17848 m .5105 .22197 L p .54856 .25763 L .759 .256 .014 r
F P
0 g
s
.5105 .22197 m .44478 .17848 L .44019 .17189 L p .78 .276 0 r
F P
0 g
s
.83403 .72929 m .88745 .69323 L p .80996 .78082 L .073 0 .055 r
F P
0 g
s
.80996 .78082 m .8235 .73946 L .83403 .72929 L p .073 0 .055 r
F P
0 g
s
.83403 .72929 m .88745 .69323 L .89719 .68059 L closepath p 0 0 0 r
F P
0 g
s
.8235 .73946 m .75967 .82203 L .75534 .82779 L p .582 .828 .454 r
F P
0 g
s
.75967 .82203 m .80996 .78082 L .8235 .73946 L closepath p 0 0 0 r
F P
0 g
s
.70442 .13527 m .63953 .11267 L .66985 .03769 L closepath p .403 .421 .764 r
F P
0 g
s
.19294 .83081 m .24594 .79774 L p .249 .89033 L .396 .318 .651 r
F P
0 g
s
.249 .89033 m .1951 .84375 L .19294 .83081 L p .396 .318 .651 r
F P
0 g
s
.22326 .70965 m .24594 .79774 L .19294 .83081 L p .376 .313 .659 r
F P
0 g
s
.21382 .70568 m .22326 .70965 L p .19294 .83081 L .376 .313 .659 r
F P
0 g
s
.20321 .91722 m .1951 .84375 L .249 .89033 L closepath p .434 .318 .623 r
F P
0 g
s
.58958 .10918 m .54393 .08016 L .61952 .10811 L closepath p .546 0 0 r
F P
0 g
s
.58958 .10918 m .65477 .03411 L .61952 .10811 L closepath p .87 .995 .79 r
F P
0 g
s
.75264 .8346 m .75967 .82203 L .75534 .82779 L closepath p 0 0 0 r
F P
0 g
s
.97289 .92557 m .94042 .83406 L .88228 .91081 L closepath p .764 .628 .709 r
F P
0 g
s
.75967 .82203 m .80996 .78082 L p .74178 .88223 L 0 0 .13 r
F P
0 g
s
.74178 .88223 m .75264 .8346 L .75967 .82203 L p 0 0 .13 r
F P
0 g
s
.72315 .9064 m .74178 .88223 L .75264 .8346 L closepath p 0 0 .042 r
F P
0 g
s
.11323 .61873 m .1792 .61892 L p .21382 .70568 L .416 .52 .856 r
F P
0 g
s
.131 .55051 m .1792 .61892 L .11323 .61873 L p .441 .543 .864 r
F P
0 g
s
.12136 .54951 m .131 .55051 L p .11323 .61873 L .441 .543 .864 r
F P
0 g
s
.11323 .61873 m .10647 .60799 L .12136 .54951 L p .441 .543 .864 r
F P
0 g
s
.10647 .60799 m .06504 .55044 L .12136 .54951 L closepath p .494 .598 .886 r
F P
0 g
s
.88228 .91081 m .93019 .87325 L .94042 .83406 L closepath p 0 0 .033 r
F P
0 g
s
.7599 .28366 m .67899 .2851 L .66763 .28295 L p .428 0 0 r
F P
0 g
s
.67899 .2851 m .66426 .28394 L .66763 .28295 L closepath p .306 0 0 r
F P
0 g
s
.22326 .70965 m .21382 .70568 L .21905 .69837 L closepath p .393 .414 .763 r
F P
0 g
s
.1792 .61892 m .21905 .69837 L .21382 .70568 L p .416 .52 .856 r
F P
0 g
s
.74707 .28799 m .67899 .2851 L .7599 .28366 L closepath p .17 0 0 r
F P
0 g
s
.67899 .2851 m .74707 .28799 L p .63206 .27354 L .157 .679 .879 r
F P
0 g
s
.63206 .27354 m .66426 .28394 L .67899 .2851 L p .157 .679 .879 r
F P
0 g
s
.66426 .28394 m .56198 .26242 L .5543 .25909 L p .477 0 0 r
F P
0 g
s
.63206 .27354 m .56198 .26242 L .66426 .28394 L closepath p 0 .532 .788 r
F P
0 g
s
.54856 .25763 m .48038 .22424 L .44478 .17848 L p .759 .256 .014 r
F P
0 g
s
.24594 .79774 m .22326 .70965 L .28201 .75509 L closepath p .334 .319 .693 r
F P
0 g
s
.28201 .75509 m .22326 .70965 L .21905 .69837 L p .236 .315 .742 r
F P
0 g
s
.21905 .69837 m .23915 .63963 L p .28201 .75509 L .236 .315 .742 r
F P
0 g
s
.21905 .69837 m .1792 .61892 L .23915 .63963 L closepath p .357 .45 .819 r
F P
0 g
s
.88745 .69323 m .8798 .74535 L .80996 .78082 L p .073 0 .055 r
F P
0 g
s
.25616 .88504 m .24594 .79774 L .28201 .75509 L p .227 .168 .579 r
F P
0 g
s
.24594 .79774 m .25616 .88504 L .249 .89033 L p .396 .318 .651 r
F P
0 g
s
.56198 .26242 m .54856 .25763 L .5543 .25909 L closepath p .353 0 0 r
F P
0 g
s
.56198 .26242 m .63206 .27354 L p .51338 .23849 L .016 .537 .859 r
F P
0 g
s
.51338 .23849 m .54856 .25763 L .56198 .26242 L p .016 .537 .859 r
F P
0 g
s
.23915 .63963 m .1792 .61892 L .131 .55051 L p .271 .481 .879 r
F P
0 g
s
.51338 .23849 m .48038 .22424 L .54856 .25763 L closepath p 0 .331 .705 r
F P
0 g
s
.8798 .74535 m .80996 .78082 L .80481 .84298 L p .2 0 .247 r
F P
0 g
s
.80996 .78082 m .80481 .84298 L .74178 .88223 L p 0 0 .13 r
F P
0 g
s
.28863 .7637 m .30512 .84596 L .25616 .88504 L p .227 .168 .579 r
F P
0 g
s
.28201 .75509 m .28863 .7637 L p .25616 .88504 L .227 .168 .579 r
F P
0 g
s
.69862 .13575 m .66538 .0374 L .60376 .11421 L closepath p .761 .617 .699 r
F P
0 g
s
.6701 .12415 m .60376 .11421 L .69862 .13575 L closepath p 0 .553 .821 r
F P
0 g
s
.74707 .28799 m .71318 .26578 L .63206 .27354 L p .157 .679 .879 r
F P
0 g
s
.131 .55051 m .19901 .56039 L p .23915 .63963 L .271 .481 .879 r
F P
0 g
s
.28863 .7637 m .28201 .75509 L .28454 .74872 L closepath p .126 .187 .656 r
F P
0 g
s
.24588 .64452 m .28454 .74872 L .28201 .75509 L p .236 .315 .742 r
F P
0 g
s
.23915 .63963 m .24588 .64452 L p .28201 .75509 L .236 .315 .742 r
F P
0 g
s
.63206 .27354 m .71318 .26578 L .70801 .26203 L p .308 .722 .976 r
F P
0 g
s
.59273 .24007 m .63206 .27354 L p .70801 .26203 L .308 .722 .976 r
F P
0 g
s
.63206 .27354 m .59273 .24007 L .51338 .23849 L p .016 .537 .859 r
F P
0 g
s
.11717 .85529 m .09335 .76967 L .14471 .8145 L closepath p .257 .279 .693 r
F P
0 g
s
.14471 .8145 m .03637 .79714 L .09335 .76967 L closepath p .671 .204 .135 r
F P
0 g
s
.08549 .74891 m .04702 .6703 L .09969 .69523 L closepath p .274 .392 .802 r
F P
0 g
s
.03033 .78131 m .09969 .69523 L .08549 .74891 L closepath p .883 .992 .765 r
F P
0 g
s
.28454 .74872 m .28465 .69697 L p .31674 .81954 L 0 0 .544 r
F P
0 g
s
.31674 .81954 m .28863 .7637 L .28454 .74872 L p 0 0 .544 r
F P
0 g
s
.28454 .74872 m .24588 .64452 L .28465 .69697 L closepath p 0 .087 .632 r
F P
0 g
s
.24588 .64452 m .23915 .63963 L .23931 .63077 L closepath p .139 .307 .773 r
F P
0 g
s
.19901 .56039 m .23931 .63077 L .23915 .63963 L p .271 .481 .879 r
F P
0 g
s
.30512 .84596 m .28863 .7637 L .31674 .81954 L closepath p .034 .078 .576 r
F P
0 g
s
.87883 .75347 m .8798 .74535 L p .80481 .84298 L .2 0 .247 r
F P
0 g
s
.28465 .69697 m .24588 .64452 L .23931 .63077 L p 0 .014 .588 r
F P
0 g
s
.23931 .63077 m .22821 .58076 L p .28465 .69697 L 0 .014 .588 r
F P
0 g
s
.23931 .63077 m .19901 .56039 L .22821 .58076 L closepath p .05 .295 .784 r
F P
0 g
s
.80481 .84298 m .81446 .83732 L .87883 .75347 L p .2 0 .247 r
F P
0 g
s
.81446 .83732 m .87617 .80706 L .87883 .75347 L closepath p .321 .058 .349 r
F P
0 g
s
.676 .23257 m .60461 .23994 L .70801 .26203 L closepath p .449 .762 .996 r
F P
0 g
s
.70801 .26203 m .60461 .23994 L .59273 .24007 L p .308 .722 .976 r
F P
0 g
s
.28465 .69697 m .30542 .76669 L .31674 .81954 L p 0 0 .544 r
F P
0 g
s
.22821 .58076 m .25967 .64319 L .28465 .69697 L p 0 .014 .588 r
F P
0 g
s
.25967 .64319 m .28465 .69697 L .30542 .76669 L p 0 0 .37 r
F P
0 g
s
.1483 .80319 m .11114 .70466 L .1481 .75472 L closepath p 0 .065 .619 r
F P
0 g
s
.1483 .80319 m .11114 .70466 L .03839 .78869 L closepath p .754 .618 .708 r
F P
0 g
s
.69366 .55428 m .78235 .55292 L p .70878 .66131 L .693 .548 .685 r
F P
0 g
s
.70878 .66131 m .68189 .56559 L .69366 .55428 L p .693 .548 .685 r
F P
0 g
s
.78235 .55292 m .76371 .49944 L .69366 .55428 L closepath p .702 .592 .73 r
F P
0 g
s
.68189 .56559 m .69366 .55428 L .67751 .55318 L closepath p .728 .606 .721 r
F P
0 g
s
.72294 .41123 m .76371 .49944 L .69366 .55428 L p .721 .642 .769 r
F P
0 g
s
.6393 .46448 m .72294 .41123 L p .69366 .55428 L .721 .642 .769 r
F P
0 g
s
.69366 .55428 m .67751 .55318 L .6393 .46448 L p .721 .642 .769 r
F P
0 g
s
.70878 .66131 m .68189 .56559 L .60957 .65643 L closepath p .725 .566 .675 r
F P
0 g
s
.67751 .55318 m .68189 .56559 L .60957 .65643 L p .763 .624 .705 r
F P
0 g
s
.56545 .53281 m .67751 .55318 L p .60957 .65643 L .763 .624 .705 r
F P
0 g
s
.67751 .55318 m .6393 .46448 L .56545 .53281 L closepath p .753 .657 .755 r
F P
0 g
s
.78235 .55292 m .80699 .65201 L .70878 .66131 L p .693 .548 .685 r
F P
0 g
s
.70878 .66131 m .80699 .65201 L p .74175 .75444 L .686 .494 .621 r
F P
0 g
s
.74175 .75444 m .72667 .75497 L .70878 .66131 L p .686 .494 .621 r
F P
0 g
s
.70878 .66131 m .72667 .75497 L .62151 .75687 L p .735 .552 .645 r
F P
0 g
s
.60957 .65643 m .70878 .66131 L p .62151 .75687 L .735 .552 .645 r
F P
0 g
s
.62151 .75687 m .60143 .67014 L .60957 .65643 L p .735 .552 .645 r
F P
0 g
s
.60143 .67014 m .60957 .65643 L .5969 .65428 L closepath p .768 .596 .664 r
F P
0 g
s
.55716 .54307 m .56545 .53281 L p .60957 .65643 L .763 .624 .705 r
F P
0 g
s
.60957 .65643 m .5969 .65428 L .55716 .54307 L p .763 .624 .705 r
F P
0 g
s
.5969 .65428 m .50816 .62706 L p .56633 .7481 L .804 .615 .647 r
F P
0 g
s
.56633 .7481 m .60143 .67014 L .5969 .65428 L p .804 .615 .647 r
F P
0 g
s
.5969 .65428 m .55716 .54307 L .50816 .62706 L closepath p .809 .646 .68 r
F P
0 g
s
.62151 .75687 m .60143 .67014 L .56633 .7481 L closepath p .77 .574 .633 r
F P
0 g
s
.80699 .65201 m .8104 .66631 L .74175 .75444 L p .686 .494 .621 r
F P
0 g
s
.26396 .65274 m .25967 .64319 L p .30542 .76669 L 0 0 .37 r
F P
0 g
s
.30542 .76669 m .30325 .75882 L .26396 .65274 L p 0 0 .37 r
F P
0 g
s
.82714 .74699 m .8104 .66631 L .74175 .75444 L closepath p .663 .479 .626 r
F P
0 g
s
.72294 .41123 m .6393 .46448 L .59625 .38615 L p .74 .683 .796 r
F P
0 g
s
.59625 .38615 m .6393 .46448 L .56545 .53281 L p .778 .689 .766 r
F P
0 g
s
.55716 .54307 m .56545 .53281 L .55073 .52827 L closepath p .791 .668 .728 r
F P
0 g
s
.51238 .45187 m .59625 .38615 L p .56545 .53281 L .778 .689 .766 r
F P
0 g
s
.56545 .53281 m .55073 .52827 L .51238 .45187 L p .778 .689 .766 r
F P
0 g
s
.50816 .62706 m .55716 .54307 L .55073 .52827 L p .837 .685 .695 r
F P
0 g
s
.55073 .52827 m .47581 .49656 L p .50816 .62706 L .837 .685 .695 r
F P
0 g
s
.55073 .52827 m .51238 .45187 L .47581 .49656 L closepath p .811 .701 .743 r
F P
0 g
s
.30325 .75882 m .26396 .65274 L .28204 .71325 L closepath p .779 .441 0 r
F P
0 g
s
.71693 .39857 m .72294 .41123 L p .59625 .38615 L .74 .683 .796 r
F P
0 g
s
.59625 .38615 m .6085 .37697 L .71693 .39857 L p .74 .683 .796 r
F P
0 g
s
.71693 .39857 m .68129 .3297 L .6085 .37697 L closepath p .728 .7 .823 r
F P
0 g
s
.50816 .62706 m .4789 .71508 L .56633 .7481 L p .804 .615 .647 r
F P
0 g
s
.43243 .587 m .50816 .62706 L .4789 .71508 L p .849 .663 .651 r
F P
0 g
s
.47581 .49656 m .43243 .587 L .50816 .62706 L p .837 .685 .695 r
F P
0 g
s
.42648 .60024 m .43243 .587 L p .4789 .71508 L .849 .663 .651 r
F P
0 g
s
.4789 .71508 m .46636 .71002 L .42648 .60024 L p .849 .663 .651 r
F P
0 g
s
.46636 .71002 m .42648 .60024 L .39919 .67697 L closepath p .877 .674 .624 r
F P
0 g
s
.76246 .66773 m .73368 .57112 L .6631 .66029 L closepath p .736 .58 .68 r
F P
0 g
s
.72535 .54738 m .73368 .57112 L .6631 .66029 L p .768 .627 .705 r
F P
0 g
s
.61592 .52731 m .72535 .54738 L p .6631 .66029 L .768 .627 .705 r
F P
0 g
s
.72535 .54738 m .68816 .45604 L .61592 .52731 L closepath p .759 .655 .746 r
F P
0 g
s
.60012 .54695 m .61592 .52731 L p .6631 .66029 L .768 .627 .705 r
F P
0 g
s
.6631 .66029 m .63898 .65619 L .60012 .54695 L p .768 .627 .705 r
F P
0 g
s
.63898 .65619 m .60012 .54695 L .54767 .63099 L closepath p .805 .645 .684 r
F P
0 g
s
.70101 .59243 m .69459 .57422 L .68271 .58917 L closepath p .77 .63 .705 r
F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{265.312, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004900017a000`40O003h00O/7oo0P00Egoo002^
Ool200000goo0000001FOol00:]oo`<000=oo`8005Ioo`00ZGoo0P001Woo00<007oo0000EGoo002W
Ool20008Ool00`00Ool0001EOol00:Aoo`<000Yoo`04001oogoo001DOol00:9oo`8000eoo`05001o
ogooOol0001COol009moo`<000moo`05001oogooOol0001COol009eoo`80019oo`03001oogoo009o
o`03001oogoo051oo`00Vgoo0P0047oo00<007oo00000Woo00<007ooOol00Woo00<007ooOol0Cgoo
002HOol3000AOol01@00Ool00000Ool00P0017oo00<007ooOol0Cgoo002FOol2000COol30002HWH3
0005Ool00`00Oomoo`1>Ool009=oo`<001Aoo`800007Ool0069fHWH0036h00001Goo00<007ooOol0
CWoo002AOol2000FOol01000KoT000000f9f00<0036h00001Woo00<007ooOol0CGoo002?Ool2000G
Ool01000KoT000001F9f0P001goo00<007ooOol0C7oo002<Ool3000HOol01000KoU_n@001V9f0`00
1Woo00<007ooOol0C7oo002:Ool2000JOol00`00KoU_n@020006HWH30007Ool00`00Oomoo`1;Ool0
08Moo`<001]oo`05001_nFoiKoT00008HWH00`00<KP00007Ool00`00Oomoo`1:Ool008Eoo`8001eo
o`05001_nFoiKoT00009HWH00`00<KP00007Ool00`00Oomoo`1:Ool008=oo`8001moo`04001_nFoi
000:HWH00`00<KP00008Ool00`00Oomoo`19Ool0081oo`<0021oo`05001_nFoiKoT0000:HWH20000
0c6h001oo`06Ool00`00Oomoo`19Ool007ioo`8000moo`80015oo`05001_nFoiKoT0000;HWH20000
0c6h001oo`07Ool00`00Oomoo`18Ool007]oo`<0019oo`@000eoo`05001_nFoiKoT0000<HWH20000
0c6h001oo`08Ool00`00Oomoo`17Ool007Uoo`8001Moo`D000Uoo`05001_nFoiKoT0000=HWH01@00
HWH0036h000027oo00<007ooOol0Agoo001gOol2000KOol00`00A01400020006Ool00`00KoU_n@02
KoT00`00HWIRMP0;HWH01@00HWH0036h00002Goo00<007ooOol0AWoo001dOol3000NOol20002A003
0002Ool00`00KoU_n@02KoT00`00HWIRMP0<HWH00`00HWIRMP02000:Ool00`00Oomoo`15Ool0079o
o`8002=oo`8000=4008000A_n@03001RMV9f00iRMP05001RMP00<KP00009Ool00`00Oomoo`15Ool0
06moo`<002Moo`800003A00006oi00=_n@03001RMV9f00mRMP05001RMP00<KP0000:Ool00`00Oomo
o`14Ool006eoo`8002aoo`L0015RMP03001RMV9f008000Yoo`03001oogoo04Aoo`00Jgoo0P00<goo
00<0069fHWH0469f00H0069fHWH0036h000:Ool00`00Oomoo`13Ool006Qoo`<003Aoo`D000mRMP06
001RMV9f000a^0002goo00<007ooOol0@Woo001VOol2000jOol;0006HWH01P00HWIRMV9f000a^080
00Uoo`03001oogoo049oo`00Hgoo0`00@Goo1@0000<2>P0000001@000f9f00@0036h000l00@000Io
o`03001oogoo045oo`00HGoo0P00BGoo1@000P8j0P000V9f00<0036h00000c`000<007ooOol01Woo
00<007ooOol0@7oo001NOol3000>Ool00`00Oomoo`0oOol600000f9f000a^0030009Ool00`00Oomo
o`10Ool005aoo`80015oo`<0045oo`03001oogoo00D000aoo`03001oogoo03moo`00FWoo0P0057oo
00<006f40000@7oo00<007ooOol04Goo00<007ooOol0?goo001GOol3000FOol01000KHA]Q000?goo
00<007ooOol04Woo00<007ooOol0?Woo001EOol2000JOol00`00KHA]Q002000mOol00`00Oomoo`0C
Ool00`00Oomoo`0mOol0059oo`<001aoo`03001]Q6f4009]Q003001oogoo03Yoo`03001oogoo01=o
o`03001oogoo03eoo`00D7oo0P0087oo00<006f4KH@00Vf40P00>Woo00<007ooOol057oo00<007oo
Ool0?7oo001>Ool2000ROol00`00KHA]Q004KH@00`00Oomoo`0gOol00`00Oomoo`0EOol00`00Oomo
o`0kOol004]oo`<002Eoo`03001]Q6f400A]Q003001oogoo03Ioo`03001oogoo01Eoo`03001oogoo
03]oo`00BGoo0P00:7oo00<006f4KH@01Ff40P00=goo00<007ooOol05Goo00<007ooOol0>Woo0016
Ool3000[Ool00`00KHA]Q002KH@5000fOol00`00Oomoo`0EOol00`00Oomoo`0jOol004Aoo`8000mo
o`03001oogoo01aoo`D000EQ008003Aoo`03001oogoo01Ioo`03001oogoo03Uoo`00@Woo0P004Goo
00<007ooOol077oo00<00640H@002F400P00<Woo00<007ooOol05goo00<007ooOol0>7oo000oOol3
000BOol00`00Og@0000NOol00`00H@1Q0008H@001000IHP00000<7oo00<007ooOol05goo00<007oo
Ool0>7oo000mOol2000EOol00`00Og@0000OOol20009H@000`00IHQUR002000^Ool00`00Oomoo`0H
Ool00`00Oomoo`0gOol003Yoo`<001Ioo`04001oM7md000OOol00`00H@000008H@000`00IHQUR002
IHP2000/Ool00`00Oomoo`0IOol00`00Oomoo`0fOol003Qoo`8001Uoo`04001oM7md000POol01000
H@0000001f4000<006F8IHP00fF80P00:Woo00<007ooOol06Goo00<007ooOol0=Woo000fOol2000K
Ool01@00OgAoM7md000087oo00@00640H@0000IQ0003001UR6F800EUR08002Qoo`03001oogoo01Yo
o`03001oogoo03Eoo`00<goo0`0077oo00<007mdOg@00Wmd00<007ooOol07goo00<00640H@000P00
1F4000<006F8IHP01VF80P009Woo00<007ooOol06Woo00<007ooOol0=Goo000aOol2000OOol00`00
OgAoM002Og@00`00Oomoo`0OOol00`00H@1Q0002H@020003H@000`00IHQUR008IHP2000TOol00`00
Oomoo`0KOol00`00Oomoo`0dOol002ioo`<0021oo`03001oM7md00AoM003001oogoo01moo`03001Q
064000=Q0005001Q0640H@00000;IHP2000ROol00`00Oomoo`0LOol00`00Oomoo`0cOol002aoo`80
02=oo`03001oM7md00AoM003001oogoo021oo`03001Q064000=Q0080009Q00eUR0@001ioo`03001o
ogoo019oo`D000Eoo`03001oogoo03=oo`00:Woo0P009Goo00<007mdOg@017md00<007ooOol08Goo
00<00640H@00164000<0064000003VF800<005TW00000`006Woo00<007ooOol027oo2P0014S900<0
07ooOol017oo00<007ooOol0<Woo000WOol3000=Ool00`00Oomoo`0FOol00`00OgAoM005Og@00`00
Oomoo`0QOol00`00H@1Q0005H@02000?IHP00`00FBMI9`02FBL4000FOol00`00Oomoo`02Ool6000>
B<T00`00Oomoo`05Ool00`00Oomoo`0aOol002Eoo`8000moo`8001Qoo`03001oM7md00IoM003001o
ogoo025oo`03001Q064000IQ008000iUR003001I9eTW00EI9a/000=<jP8000m8b@03001oogoo00Eo
o`03001oogoo035oo`008Woo0`004Goo0P005goo00<007mdOg@00gmd1@0097oo0P001f400`003FF8
00<005TWFBL01ETW00<0053WD>L04U3W00@0053WD>L000I<jP<000a8b@03001oogoo00Ioo`03001o
ogoo031oo`0087oo0P004goo00<007Nh00005goo1P0017]f00<007ooOol08goo0`001V4000<005AP
00000P002VF800<005TWFBL01ETW00<0053WD>L04e3W00<0053W00002DcZ0P002DS900<007ooOol0
1goo00<007ooOol0<7oo000NOol2000DOol01000MkQg^0005Woo00<007]fNgH02G]f00<007ooOol0
97oo0`001F400P000UAP0`0026F800<005TWFBL00eTW00<0053WD>L03E3W1@000U3W0P0034cZ0`00
1TS900<007ooOol027oo00<007ooOol0;goo000KOol3000EOol01@00MkQg^7Nh00005Woo00<007]f
NgH02G]f00<007ooOol09Woo0`001F4000<005APE6000UAP0P001fF800<005TWFBL00UTW00<0053W
D>L00e3W2P001C/O00@0053W000000m<jP<000=8b@03001oogoo00Uoo`03001oogoo02ioo`006Goo
0P0067oo00D007NhMkQg^00001Eoo`03001kMW]f00UkMP8002Yooal0010k7`<0019<jP800003B<T0
07oo00Yoo`03001oogoo02ioo`005goo0P006Goo00<007NhMkP00WNh00<007ooOol04Woo0P002g]f
0P00;7oo0`004`8k00<002Ko9_l00RKo10003c/O0P0054cZ0P0037oo00<007ooOol0;Goo000GOol2
000HOol00`00MkQg^003MkP00`00Oomoo`0BOol00`00MiP00009NgH00`00NmD0000^Ool3000B0S/2
00069_l5000:>al3000@C>X4000>Ool00`00Oomoo`0/Ool001Moo`03001oo`0001Moo`03001g^7Nh
00=g^003001oogoo015oo`04001gV7NH0009NgH01000NmEke@00;goo0`004P8k00<002Ko9_l022Ko
1@001C/O00@003/O>al000Q<jPL000<d0003001oogoo00aoo`03001oogoo02aoo`005goo00@007oo
Ool001Eoo`03001g^7Nh00Ag^003001oogoo015oo`05001gV7NHMiP00008NgH01000NmEke@00<Goo
0`004@8k00<002Ko9_l032Ko100000<k7`00>al00S/O20002C@000<007ooOol03Woo00<007ooOol0
:goo000FOol00`00Oomoo`02Ool01000Oomoo`0047oo00<007NhMkP01GNh00<007ooOol047oo00<0
07NHMiP00WNH00<007]fNgH01G]f00D007_ENmEke@0003=oo`<00102>`03000VobKo00lVo`D00003
>al003@000hd0003001oogoo00ioo`03001oogoo02]oo`005Woo00<007ooOol00goo0`0047oo00<0
07NhMkP01GNh00<007ooOol047oo00<007NHMiP00WNH00<007]fNgH01G]f00D007_ENmEke@0003Io
o`H000/2>`03000VobKo00lVo`04000VobKo9_l3000>=0000`00Oomoo`0?Ool00`00Oomoo`0ZOol0
01Ioo`03001oogoo00Aoo`8000moo`03001g^7Nh00Ig^003001oogoo00moo`03001gV7NH00AgV003
001kMW]f00=kMP03001keG_E009ke@03001oogoo03Uoo`L000H2>`8000lVo`03000Vo`0000D000`d
0003001oogoo015oo`03001oogoo02Uoo`005Woo00<007ooOol00goo0`003Woo00<007NhMkP01gNh
00<007ooOol03goo00<007NHMiP017NH00<007]fNgH00g]f00<007_ENmD00W_E00<007ooOol0?Goo
2@000P8k00<002Ko9_l01BKo2@001QJl0P002S@000<007ooOol04Goo00<007ooOol0:Goo000FOol0
0`00Oomoo`06Ool00`00Oomoo`0:Ool00`00MkQg^006MkP3000@Ool00`00MiQgV006MiP01@00NgIk
MW]f00001G_E00<007ooOol0@Woo3@0021Jl00<001Jl5[`01aJl00<003@0=0001c@000<007ooOol0
4Woo00<007ooOol0:7oo000FOol00`00Oomoo`07Ool00`00Oomoo`09Ool00`00MkQg^0060002LmX0
0`00Oomoo`0>Ool00`00MiQgV006MiP01@00NgIkMW]f00001G_E00<007ooOol0AWoo1`002QJl00<0
01Jl5[`021Jl0P001c@000<007ooOol037oo00<007ooOol017oo00<007ooOol09goo000EOol00`00
Oomoo`09Ool00`00Oomoo`07Ool40007LmX00`00Oomoo`0>Ool00`00MiQgV007MiP01@00NgIkMW]f
00001W_E00<007ooOol0BWoo1@001aJl00<001Jl5[`02QJl00<003@0=0000c@000<007ooOol02goo
0`001Woo00<007ooOol09goo000EOol00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00LmYcfP09LmX0
0`00Oomoo`0>Ool00`00MiQgV008MiP00`00NgH00007NmD00`00Oomoo`1>Ool?00075[`6000<Ool0
1000@IA1U0001goo00<007ooOol09Woo000EOol00`00Oomoo`0;Ool00`00Oomoo`03Ool00`00LmYc
fP09LmX00`00Oomoo`0>Ool00`00MiQgV009MiP00`00NgH00007NmD00`00Oomoo`1FOol00`00Oomo
o`04Ool;000<Ool20004@I@00`00Oomoo`04Ool00`00Oomoo`0VOol001Eoo`03001oogoo00aoo`03
001oogoo009oo`03001cfW?J00QcfP80011oo`03001gV7NH00YgV003001keG_E00Ike@03001oogoo
05Ioo`03001oogoo01Yoo`030011U46D00A1U003001oogoo00Eoo`03001oogoo02Eoo`005Goo00<0
07ooOol03Goo00@007ooOol000YcfP80011oo`03001gV7NH00]gV003001keG_E00Eke@8005Uoo`03
001oogoo01Qoo`030011U46D00E1U003001oogoo00Ioo`03001oogoo02Aoo`005Goo00<007ooOol0
3Woo0`002W?J0P0047oo00<007NHMiP02WNH0P001g_E00<007ooOol0F7oo00<007ooOol05Woo0P00
246D00<007ooOol01Woo00<007ooOol097oo000EOol00`00Oomoo`0>Ool2000:LmX2000@Ool00`00
MiQgV00;MiP20006NmD2001JOol00`00Oomoo`0EOol00`00@IA1U009@I@00`00Oomoo`06Ool00`00
Oomoo`0SOol001Aoo`03001oogoo00ioo`03001_^`0000UcfP03001_n000011oo`03001gV7NH00Yg
V003001k]`0000Ike@03001oogoo05Uoo`03001oogoo01=oo`8000a1U003001oogoo00Moo`03001o
ogoo029oo`0057oo00<007ooOol03Goo00@006nkKk/000QcfP03001_n000011oo`03001gV7NH00Yg
V004001k]g^g0005NmD2001KOol00`00Oomoo`0BOol2000=@I@00`00Oomoo`07Ool00`00Oomoo`0R
Ool001Aoo`03001oogoo00aoo`05001_^fnkKk/00007LmX01000KoQ_n0003goo0P0037NH00@007^g
NkL000Eke@8005]oo`03001oogoo015oo`03000mM3ed008000]1U003001oogoo00Qoo`03001oogoo
025oo`0057oo00<007ooOol02goo00D006nkKk]_^`0000McfP04001_n6oh000?Ool00`00LiX0000;
MiP01@00NkMk]g^g000017_E0P00G7oo00<007ooOol047oo00<003ed?G@00ced0P002T6D00<007oo
Ool01goo00<007ooOol08Goo000DOol00`00Oomoo`0:Ool00`00Kk]_^`02Kk/00`00LmYcfP05LmX0
1000KoQ_n0003goo00<007>J00002gNH00D007^gNkMk]`0000Ake@8005aoo`03001oogoo00moo`80
00LmM08000Q1U003001oogoo00Qoo`03001oogoo021oo`0057oo00<007ooOol02Goo00<006nkKk/0
0fnk00<007?JLmX017?J00@006ohKoP000moo`05001cVW>JLiX00009MiP01@00NkMk]g^g000017_E
0P00GGoo00<007ooOol03Woo00<003Ee00002Ced0P001T6D00<007ooOol02Goo00<007ooOol07goo
000COol00`00Oomoo`09Ool00`00Kk]_^`04Kk/00`00LmYcfP03LmX01@00KoQ_n6oh00003Woo00<0
07>JLiX00W>J00<007NHMiP01WNH00<007^gNkL00W^g00<007_ENmD00W_E0P00Fgoo00<007oo0000
3Woo0P000cEe00<003ed?G@023ed0P00146D00<007ooOol02Goo00<007ooOol07goo000COol00`00
Oomoo`08Ool00`00Kk]_^`04Kk/00`00LmYcfP03LmX01@00KoQ_n6oh00003Woo00<007>JLiX00g>J
00<007NHMiP01WNH00<007^gNkL00W^g00@007_ENmEke@8005Yoo`<00003Ool007oo00aoo`03000e
MCEe00<eM@03000mM3ed00XmM08000=1U003001oogoo00Uoo`03001oogoo01ioo`004goo00<007oo
Ool01goo00<006nkKk/01Fnk00<007?JLmX00W?J00<006ohKoP00`003Goo00<007>JLiX017>J00<0
07NHMiP01GNH00<007^gNkL00g^g00D007_ENmEke@0005Uoo`8000=NfP8000aoo`03000eMCEe00@e
M@03000mM3ed00`mM0800003@I@007oo00]oo`03001oogoo01eoo`004goo00<007ooOol01Woo00<0
06nkKk/01Vnk00D007?JLmYcfP00009_n005001oogooOol0000;Ool00`00LiYcVP05LiX00`00MiQg
V004MiP00`00NkMk]`04NkL00`00NmEke@02001HOol00`00G]YNfP03G]X2000;Ool00`00=GDeM@05
=GD00`00?G@mM00>?G@2000<Ool00`00Oomoo`0MOol001=oo`03001oogoo00Eoo`03001_^fnk00M_
^`04001cfW?JLmX30005Ool00`00Oomoo`08Ool00`00LiYcVP05LiX00`00MiQgV004MiP00`00NkMk
]`04NkL01000NmEke@00Egoo0P001ekJ00<007ooOol027oo00<003Ee=GD01SEe00<003ed?G@03ced
00<007ooOol02goo00<007ooOol077oo000COol00`00Oomoo`04Ool00`00Kk]_^`07Kk/01000LmYc
fW?J0P0027oo00<007ooOol01Woo00<007>JLiX01W>J00<007NHMiP00gNH00<007^gNkL01G^g00@0
07_E000005Eoo`8000UNfP03001oogoo00Moo`03000eMCEe00PeM@03000mM3ed00lmM003001oogoo
00Yoo`03001oogoo01aoo`004Woo00<007ooOol017oo1P001Fnk00@007?J000000]oo`03001oogoo
00Aoo`8000UcVP03001gV7NH009gV003001k]g^g00Ek]`03001ke@0005Eoo`03001NfUkJ00UNfP80
00Ioo`8000/eM@03000mM3ed00lmM003001oogoo00Eoo`03001oogoo00=oo`03001oogoo01]oo`00
4Woo00<007ooOol02Woo1`003Woo00<007ooOol00Woo00<006^LJi`010001G>J00D007NHMiQgV000
00Mk]`<005Aoo`8000aNfP8000Eoo`03000eMCEe00/eM@03000mM3ed00dmM0<000Ioo`8000Ioo`03
001oogoo01Yoo`004Woo00<007ooOol087oo00@007oo000000M[W0@00005LiX007NHMiP00004NkL4
00000g?i001oo`1BOol2000?G]X20003Ool00`00=GDeM@0<=GD00`00?G@mM00<?G@01000@MI1eP00
1Goo00@003fg?KL000Eoo`03001oogoo01Yoo`004Woo00<007ooOol08Goo00<006^LJi`02f^L0P00
0WNH1@0017?i00<007ooOol0DGoo00<005kJG]X03ekJ0P000Woo00<003Ee=GD03SEe00<003ed?G@0
2Ced0P00147F00D007ooOomoo`0000<m]`03001oogoo00Aoo`03001oogoo01Uoo`004Woo00<007oo
Ool087oo00<006^LJi`03F^L10001g?i0P00DGoo0P004UkJ00<005kJ00000P0043Ee00<003ed?G@0
1ced0P001T7F00D007ooOomoo`0000<m]`03001oogoo00Eoo`03001oogoo01Qoo`004Woo00<007oo
Ool07goo00<006^LJi`03V^L0P0027?i0P00D7oo0P0055kJ00<005kJ00000P0043Ee00<003ed?G@0
1Sed00<0047F@MH01T7F00@007ooOol000Dm]`03001oogoo00Aoo`03001oogoo01Qoo`004Woo00<0
07ooOol07Goo0P004F^L00<007?iLoT01g?i00<007ooOol0CWoo0`0055kJ00H005kJG]X002Te000?
=GD00`00?G@mM004?G@20009@MH00`00Ool00006?KL00`00Oomoo`05Ool00`00Oomoo`0GOol0015o
o`03001oogoo01eoo`03001[W6^L011[W08000Qcn@8004moo`04001N^EjiG[T5000?G]X01P00G]YN
fP00:CD000leM@03000mM3ed00<mM0030011eT7F00Y1eP03000m]cfg00Dm]`03001oogoo00Eoo`03
001oogoo01Moo`004Goo00<007ooOol077oo00<006^LJi`046^L0P0027?i0P00Cgoo00<005jiG[T0
1eji1@002UkJ00@005kJG]YNfP80010eM@<mM08000e1eP03000m]cfg00Hm]`03001oogoo00Eoo`03
001oogoo01Ioo`004Goo00<007ooOol06Woo0P004V^L00<006oL00001g?i0P00Cgoo00<005jiG[T0
3Eji10001UkJ00@005kJG]YNfP80010eM@03?G@0000000m1eP03000m]cfg00Hm]`03001oogoo00Io
o`03001oogoo01Eoo`004Goo00<007ooOol06Goo00<006^LJi`046^L0P000VoL00<007?iLoT017?i
0P00Cgoo00<006;H00004Uji1@0000=NfP00G]X00ekJ0P003cEe00<0047F@MH03d7F00<003fg?KL0
1Sfg00<007ooOol01Woo00<007ooOol05Goo000AOol00`00Oomoo`0HOol00`00Jia[W00@Ji`00`00
Kma_g002Km`00`00LoUcn@03LoT00`00Gm@0001=Ool20002H]P00`00G[UN^@0EG[T500000ekJ0000
000>=GD2000B@MH00`00?KLm]`05?KL00`00Oomoo`07Ool00`00Oomoo`0DOol0015oo`03001oogoo
01Moo`03001[W6^L011[W003001_g6oL009_g003001cnG?i00=cn@03001Oe00004eoo`03001Rf6;H
00=Rf003001N^Eji01EN^@04001N^EjiG[T3000==GD01000?KHm]P004D7F00<003fg?KL01Sfg00<0
07ooOol01goo00<007ooOol04goo000@Ool00`00Oomoo`0FOol2000BJi`00`00Kma_g003Km`00`00
LoUcn@03LoT2001=Ool00`00H]QRf004H]P00`00G[UN^@0EG[T00`00G[UN^@04G[T00`00=GDeM@09
=GD01@00?KHm]Sff00004D7F00<003fg?KL01Sfg00<007ooOol01goo00<007ooOol04goo000@Ool0
0`00Oomoo`0EOol00`00Jia[W00AJi`00`00Kma_g004Km`00`00LoUcn@02LoT00`00Gm@0001;Ool2
0008H]P00`00G[UN^@0DG[T00`00G[UN^@04G[T00`00=GDeM@08=GD00`00?KHm]P02?KH00`00@MI1
eP0?@MH00`00?KLm]`06?KL00`00Oomoo`08Ool00`00Oomoo`0BOol0011oo`03001oogoo01Aoo`80
019[W003001_g6oL00A_g003001cnG?i009cn@03001Oe00004]oo`03001Rf6;H00QRf003001N^Eji
01AN^@03001N^Eji00EN^@03000eMCEe00HeM@03000m]Sff00<m]P030011eT7F0111eP8000Lm]`03
001oogoo00Moo`03001oogoo019oo`0047oo00<007ooOol04Woo0P000V>M0P003f^L00<006oLKm`0
1FoL00L007?iLoUcn@00Gm@0001;Ool00`00H]QRf00:H]P00`00G[UN^@0CG[T00`00G[UN^@03G[T3
0007=GD00`00?KHm]P05?KH00`00@MI1eP0?@MH00`00Ool000020004?KL00`00Oomoo`07Ool2000C
Ool0011oo`03001oogoo015oo`03001SWF>M00ASW@8000][W08000Q_g006001cnG?i001Oe000Bgoo
00<006;HH]P02f;H00<005jiG[T04eji00@005jiG[UN^@8000=NV003000eMCEe00<eM@03000m]Sff
00Hm]P030011eT7F00m1eP03001oogoo009oo`80008m]`03001oogoo009oo`03001oo`0000800003
Ool007oo019oo`0047oo00<007ooOol03goo0`0026>M0P0026^L00<006oLKm`01foL00H007?iLoUc
nEoD001:Ool2000?H]P00`00G[UN^@0BG[T01000G[UN^@001EjH00<003Ee=GD00SEe00<003ff?KH0
1cff00<0047F@MH03d7F00<007ooOol017oo0P0000@m]`00Oomoo`<000Aoo`03001oogoo015oo`00
47oo00<007ooOol03Woo00<006=m00002f>M0P001F^L00<006oLKm`026oL00<007?iLoT00`00BGoo
00<006;HH]P03f;H00<005jiG[T04eji0P001ejH00@003Ee=GD000/m]P030011eT7F00m1eP03001o
ogoo00Eoo`@00099LP03001oogoo009oo`03001oogoo015oo`003goo00<007ooOol03Goo0P000V=m
00<006>MHid02f>M0P000V^L00<006oLKm`02FoL00<007?i00000goo00<007ooOol0AGoo00<006;H
H]P04F;H00<005jiG[T045ji0`0025jH00<003Ee000033ff00<0047F@MH03d7F00<007ooOol00goo
0`000Woo00@004UbBG8000Eoo`03001oogoo011oo`003goo00<007ooOol02goo0P0016=m00<006>M
Hid03F>M10002VoL0P001Goo00<007ooOol0@Woo0P005F;H00<005jiG[T03Uji00@005jHGYP000QN
V08000dm]P030011eT7F00m1eP03001oogoo00<000Aoo`040019LTUb0006Ool00`00Oomoo`0@Ool0
00moo`03001oogoo00Yoo`03001SOF=m00ASO@03001SWF>M00eSW@04001SgF?MHmd60003Km`20007
Ool00`00Oomoo`10Ool00`00H]QRf00EH]P00`00G[UN^@0<G[T20003GYP00`00GYQNV007GYP00`00
?KHm]P0;?KH00`00@MI1eP0>@MH40007Ool2BG800`00Oomoo`05Ool00`00Oomoo`0@Ool000moo`03
001oogoo00Qoo`8000ISO@03001SWF>M00aSW@03001SgF?M00USg@@000Uoo`03001oogoo03ioo`03
001Rf6;H01MRf003001N^Eji00YN^@03001NV5jH00=NV003001NV5jH00MNV08000dm]P030011eT7F
00]1eP800095n003001oogoo00Eoo`040019LTUb0007Ool00`00Oomoo`0@Ool000moo`03001oogoo
00Moo`03001SOF=m00ISO@03001SWF>M00YSW@8000iSg@8000Yoo`03001oogoo03]oo`8001YRf003
001N^Eji00QN^@8000INV003001NV5jH00QNV0<000/m]P030011eT7F00Y1eP030015n4Gh0095n003
001oogoo00Aoo`040019LP000008Ool00`00Oomoo`0@Ool000moo`03001oogoo00Eoo`8000USO@03
001SWF>M00USW@03001SgF?M00iSg@03001oogoo00Yoo`03001oogoo03Uoo`03001Rf6;H01]Rf003
001N^Eji00EN^@8000QNV003001NV5jH00QNV003000e^3Fh008000Tm]P030011eT7F00U1eP030015
n4Gh00=5n003001oogoo00=oo`040019LP000009Ool00`00Oomoo`0@Ool000ioo`03001oogoo00Ao
o`8000]SO@03001SWF>M00MSW@80011Sg@03001oogoo00aoo`03001oogoo03Moo`03001Rf6;H01aR
f003001N^Eji00AN^@03001NV5jH00QNV003001NV5jH00UNV004000e^3Fh=KP20008?KH00`00@MI1
eP06@MH20007AOP01@00Oomoogoo00000TUb00<003gi000027oo00<007ooOol047oo000>Ool00`00
Oomoo`03Ool00`00HgeSO@0:Hgd00`00HieSW@07Hid00`00HmeSg@0>Hmd2000@Ool00`00Oomoo`0<
OolN000;Ool2000OH]P01000G[UN^Eji0P0025jH00@005jHGYP000]NV003000e^3Fh00<e^08000Hm
]P030011eT7F00E1eP030015n4Gh00M5n004001oogoo0002BG801000?OTmn@0027oo00<007ooOol0
47oo000>Ool00`00Oomoo`04Ool2000:Hgd00`00HieSW@05Hid2000@Hmd2000BOol00`00Oomoo`03
Ool80003EO@01000FQEJ5@0055hd00<0069DHU@01P0017oo00@006KGI]L001iRf004001N^@000009
GYP20002GYP00`00GYQNV009GYP00`00=KPe^005=KP20004?KH00`00@MI1eP04@MH00`00AOQ5n008
AOP01P00Oomoo`00BG8000@mn@03001oogoo00Ioo`03001oogoo00moo`003Woo00<007ooOol01Woo
0P0026=m00<006>MHid016>M00<006?MHmd03f?M0P0057oo1@002UGd00D005XEFQEJ5@0001AN=003
001RE69D00IRE0@000=Ve`03001Rf6;H01eRf003001NV5jH00QNV006001RUf:G001NV00035jH00<0
03Fh=KP01SFh0P000Sff00<0047F@MH00T7F0P0034Gh0P000TUb00<003gi?OT00Sgi00<007ooOol0
1Woo00<007ooOol03goo000>Ool00`00Oomoo`08Ool20006Hgd00`00HieSW@02Hid2000AHmd2000E
Ool00`00EOAEm00;EO@00`00FQEJ5@02FQD00`00GSAN=00CGS@00`00HUARE006HU@00`00IWD00004
I]L00`00H]QRf00KH]P20009GYP01`00HYMRUf:G001NV00000aNV003000e^3Fh00Pe^0800005?KH0
047F@MH0000>AOP01000BG99LP001Cgi00<007ooOol01Woo00<007ooOol03goo000>Ool00`00Oomo
o`0:Ool20003Hgd00`00HieSW@02Hid00`00HmeSg@0?Hmd3000FOol00`00EOAEm00:EO@00`00FQEJ
5@04FQD00`00GSAN=00BGS@00`00HUARE006HU@20005I]L00`00H]QRf00JH]P01000H[QR^0001ejH
00<006:GHYL00f:G0P003EjH00<003Fh=KP02CFh20002dGh00<004Ub00001cgi00<007ooOol01Goo
00<007ooOol03goo000>Ool00`00Oomoo`0<Ool2000016=m001SWF>M0P004F?M00<005ok00005goo
00<005GdEO@02UGd00<005XEFQD015XE00<005hdGS@04Uhd00<0069DHU@01F9D0P001fKG00<006;H
H]P066;H00D006:hH[QR^00000INV003001RUf:G00ARU`8000eNV003000e^3Fh00Xe^08000E6>@P0
00A5n003000mnCgi00Hmn@03001oogoo00Eoo`03001oogoo00moo`003Goo00<007ooOol03goo1@00
4F?M00<005ok00006Goo00<005GdEO@025Gd00<005XEFQD01EXE00<005hdGS@04Uhd00<0069DHU@0
1F9D00<006KGI]L01VKG00<006;HH]P05f;H00<006:hH[P00f:h00<005jHGYP00UjH00<006:GHYL0
1F:G0P003EjH00<003Fh=KP02cFh00<004HiAST02dHi1@0023gi00<007ooOol01Goo00<007ooOol0
3goo000=Ool00`00Oomoo`0DOol4000<Hmd00`00Go/0000JOol00`00EOAEm007EO@00`00FQEJ5@06
FQD00`00GSAN=00CGS@00`00HUARE003HU@00`00I]MVe`08I]L00`00H]QRf00EH]P00`00H[QR^004
H[P01@00GYQNV5jH00002F:G00<005jHGYP035jH00<003Fh=KP02CFh0P004DHi00<003gi?OT01cgi
00<007ooOol017oo00<007ooOol03goo000=Ool00`00Oomoo`0HOol30007Hmd4000KOol00`00EOAE
m006EO@00`00FQEJ5@07FQD00`00GSAN=00CGS@00`00HUARE002HU@00`00I]MVe`09I]L00`00H]QR
f00DH]P00`00H[QR^006H[P00`00GYP0000:HYL00`00GYQNV00<GYP00`00=KPe^009=KP00`00?QT0
000AAST00`00?OTmn@06?OT00`00Oomoo`05Ool00`00Oomoo`0>Ool000eoo`03001oogoo01]oo`@0
009Sg@<001eoo`03001Em5Gd00EEm003001J5EXE00QJ5@03001N=5hd01=N=003001RE69D009RE003
001VefKG00YVe`03001Rf6;H019Rf003001R^6:h00MR^08000aRU`03001NV5jH00aNV003000e^3Fh
00Le^004000n6ChI000AAST00`00?OTmn@07?OT00`00Oomoo`04Ool00`00Oomoo`0>Ool000eoo`03
001oogoo01moo`<001moo`03001Em5Gd00AEm003001J5EXE00YJ5@03001N=5hd019N=005001RE69D
HU@0000=I]L00`00H]QRf00AH]P00`00H[QR^008H[P00`00HYMRU`0;HYL00`00GYQNV00<GYP00`00
=KPe^006=KP01@00?QTn6ChI00004THi00<003gi?OT01Sgi00<007ooOol017oo00<007ooOol03Woo
000=Ool00`00Oomoo`11Ool00`00EOAEm003EO@00`00FQEJ5@0;FQD00`00GSAN=00CGS@01000HU@0
00003VKG00<006;HH]P03V;H0P002V:h00<006:GHYL036:G0P003UjH00<003Fh=KP01CFh00<003hI
?QT00ShI00<004HiAST03dHi00<003gi?OT01Sgi00<007ooOol017oo00<007ooOol03Woo000<Ool0
0`00Oomoo`12Ool00`00EOAEm002EO@00`00FQEJ5@0<FQD00`00GSAN=00CGS@01000HU@006Zf0P00
36KG00<006;HH]P03F;H00<006:hH[P02F:h00<006:GHYL03F:G0P003UjH00<003Fh=KP013Fh00<0
03hI?QT00chI00<004HiAST044Hi0P001cgi00<007ooOol00goo00<007ooOol03Woo000<Ool00`00
Oomoo`12Ool00`00EOAEm002EO@00`00FQEJ5@0<FQD00`00GSAN=00CGS@20004J[H3000:I]L00`00
H]QRf00;H]P00`00H[QR^009H[P00`00HYMRU`0>HYL2000=GYP20005=KP00`00?QTn6@05?QT00`00
ASU6>@0?AST00`00Ool000030003?OT00`00Oomoo`03Ool00`00Oomoo`0>Ool000aoo`03001oogoo
04=oo`04001Em5Gd000?FQD00`00GSAN=00CGS@20007J[H20008I]L00`00H]QRf00:H]P00`00H[QR
^009H[P00`00HYMRU`0?HYL00`00HYL0000:GYP20002FUL00`00=KPe^002=KP00`00?QTn6@05?QT0
0`00ASU6>@0@AST00`00Oomoo`02Ool300000cgi001oo`03Ool00`00Oomoo`0>Ool000aoo`03001o
ogoo04=oo`03001Em000011J5@03001N=5hd01=N=003001Z]VZf00QZ]P<000IVe`03001Rf6;H00QR
f003001R^6:h00UR^003001RUf:G011RU`03001RU`0000UNV003001JEeYG009JE`05000e^3Fh=KP0
0008?QT00`00ASU6>@0@AST00`00Oomoo`05Ool20005Ool00`00Oomoo`0=Ool000aoo`03001oogoo
04=oo`80019J5@03001N=5hd019N=003001Z]VZf00]Z]P8000AVe`03001Rf6;H00MRf003001R^6:h
00UR^003001RUf:G015RU`04001RUf:G0007GYP00`00FUMJE`03FUL01000=KPe^0002ShI00<004Hi
AST044Hi00<007ooOol02goo00<007ooOol03Goo000<Ool00`00Oomoo`13Ool00`00FQEJ5@0AFQD0
0`00GSAN=00AGS@00`00J[IZ]P0>J[H30002I]L00`00H]QRf005H]P00`00H[QR^009H[P00`00HYMR
U`0BHYL01000HYMRU`001EjH0P001eYG00<003Fh00002ShI00<004HiAST044Hi00<007ooOol02goo
00<007ooOol03Goo000;Ool00`00Oomoo`14Ool00`00FQEJ5@0=FQD>000:GS@00`00J[IZ]P0AJ[H3
0006H]P00`00H[QR^009H[P00`00HYMRU`0CHYL01000HYMRU`0015jH00<005YGFUL01eYG0P002chI
00<004HiAST04DHi00<007ooOol02Woo00<007ooOol03Goo000;Ool00`00Oomoo`15Ool00`00FQEJ
5@02FQD:0004FSD00`00GUENE@07GUD:000FJ[H30003H]P00`00H[QR^009H[P3000DHYL01@00HYMR
Uf:G00000UjH00<005YGFUL025YG00<003hI?QT02chI00<004HiAST044Hi00<007ooOol02Woo00<0
07ooOol03Goo000;Ool00`00Oomoo`15Ool5000?FSD00`00GUENE@0?GUD00`00J[IZ]P0EJ[H00`00
I[L000040009H[P01000HYIRUV:F1P003V:G00L006:GHYMRU`00GYP0000<FUL00`00?QTn6@0:?QT0
0`00ASU6>@0AAST00`00Oomoo`09Ool00`00Oomoo`0=Ool000]oo`03001oogoo04Eoo`03001J=EXe
015J=@03001NEEiE00iNE@03001Z]VZf01MZ]P03001V]`0000=RMPD000=R^003001RUV:F00QRUPH0
00QRU`03001RUf:G009RU`03001JEeYG00]JE`03000n6ChI00/n6@030016>DHi0116>@03001oogoo
00Uoo`03001oogoo00eoo`002goo00<007ooOol0AGoo00<005XeFSD04EXe00<005iEGUD03EiE0P00
6FZf00<006Jg0000269f100046:F1P000V:G00<006:GHYL00V:G00<005YGFUL035YG10002ChI00<0
04HiAST04DHi00<007ooOol027oo00<007ooOol03Goo000;Ool00`00Oomoo`16Ool00`00FSEJ=@0@
FSD00`00GUENE@0=GUD00`00J[IZ]P0IJ[H00`00HWIRMP09HWH00`00HYIRUP0EHYH60002HYL00`00
FUMJE`0;FUL01000>QXj6SXJ10001ChI00<004HiAST04DHi00<007ooOol02Goo00<007ooOol037oo
000;Ool00`00Oomoo`16Ool00`00FSEJ=@0AFSD00`00GUENE@0;GUD2000JJ[H2000:HWH00`00HYIR
UP0HHYH01000HYIRUV:F0`003EYG00<003XJ>QX01CXJ10000ShI00<004HiAST04DHi00<007ooOol0
27oo00<007ooOol037oo000:Ool00`00Oomoo`04OolD000_Ool00`00FSEJ=@0AFSD00`00GUENE@0:
GUD00`00GWH0000JJ[H00`00IYD00008HWH2000JHYH00`00HYIRUP03HYH00`00FUMJE`0<FUL00`00
>QXj6P08>QXG000:Ool00`00Oomoo`0<Ool000Yoo`03001oogoo00Eoo`03000nO3il00/nO005000j
>cXk000Qo006000YOol00`00FSEJ=@0AFSD00`00GUENE@09GUD00`00GWH0000JJ[H01000IYEVU@00
269f00<006JE00006V:F00<006:FHYH00f:F3`0033XJ00<0049K@U/04D9K00<007ooOol027oo00<0
07ooOol037oo000:Ool00`00Oomoo`05Ool00`00?W`nO00:?W`01@00>S/j>cXk00001b7l1P008goo
00<005XeFSD04EXe00<005iEGUD025iE00@005ifGWH001YZ]P04001VUFJE0007HWH01000IYEVU@00
6V:F00<006:FHYH00f:F00<005XeFSD02eXe00<003XJ>QX02cXJ00<0049K@U/04D9K00<007ooOol0
1goo00<007ooOol037oo000:Ool00`00Oomoo`06Ool00`00?W`nO009?W`00`00>S/j>`02>S/00`00
8O`Qo00:8O`4000POol00`00FSEJ=@0AFSD00`00GUENE@06GUD01000GWINMP006VZf00<006JEIYD0
0VJE00<0069fHWH00f9f00D006JEIYEVU@0001YRUP03001RUV:F00=RUP03001J=EXe00aJ=@03000j
6SXJ00Xj6P030012Fd9K0152F`03001oogoo00Moo`03001oogoo00aoo`002Woo00<007ooOol01goo
00<003il?W`023il00<003Xk>S/00cXk00<0027l8O`03B7l0P007Woo00<005XeFSD04EXe00<005iE
GUD01UiE00@005ifGWH001UZ]P03001VUFJE00=VU@03001RMV9f00=RMP03001VUFJE009VU@03001R
UV:F01MRUP03001RUV:F00=RUP03001J=EXe00aJ=@03000j6SXJ00/j6P030012Fd9K00m2F`03001:
N`0000Qoo`03001oogoo00aoo`002Woo00<007ooOol027oo00<003il?W`01cil00<003Xk>S/013Xk
00<0027l8O`0327l00<000Di00007Goo00<005XeFSD04EXe00<005iEGUD01EiE00@005ifGWH001YZ
]P03001VUFJE00=VU@03001RMV9f009RMP03001VUFJE00=VU@03001RUV:F01MRUP03001RUV:F00AR
UP03001J=EXe00]J=@03000j6SXJ00/j6P030012Fd9K00i2F`04001:NdYk0009Ool00`00Oomoo`0;
Ool000Uoo`03001oogoo00Uoo`03000nO3il00HnO003000j>cXk00Dj>`03000Qo27l00dQo0040005
>@00000KOol00`00FSEJ=@0AFSD00`00GUENE@04GUD01@00GWINMUif00006FZf00<006JEIYD01FJE
00D0069fHWIRMP0000EVU@03001RUV:F01ARUP04001RUV:F0006HYH00`00FSEJ=@0;FSD00`00>QXj
6P0<>QX00`00@U]2F`0=@U/01@00BW]:NdYk000027oo00<007ooOol02goo0009Ool00`00Oomoo`0:
Ool00`00?W`nO005?W`00`00>S/j>`06>S/00`008O`Qo00<8O`010001CT5>@Di0P006Goo00<005Xe
FSD04UXe00<005iEGUD00UiE00D005ifGWINMP0001YZ]P03001VUFJE00EVU@04001RMV9f0007IYD0
0`00HYIRUP0BHYH20002HYH00`00HYIRUP03HYH2000>FSD00`00>QXj6P0;>QX00`00@U]2F`0<@U/0
0`00BW]:N`02BW/00`00Oomoo`06Ool00`00Oomoo`0;Ool000Uoo`03001oogoo00]oo`03000nO3il
00@nO003000j>cXk00Lj>`03000Qo27l00`Qo0030005>@Di0085>@03001oogoo01Moo`03001J=EXe
015J=@05001NEEiEGUD00004GWH00`00J[IZ]P0GJ[H00`00IYEVU@06IYD00`00HWH00008IYD00`00
HYIRUP0AHYH01P00HYIRUP00HYH000ARUP04001NEEiE000=FSD00`00>QXj6P0<>QX00`00@U]2F`0:
@U/00`00BW]:N`04BW/00`00Oomoo`05Ool00`00Oomoo`0;Ool000Uoo`03001oogoo00aoo`03000n
O3il00<nO003000j>cXk00Lj>`03000Qo27l00dQo0050005>@Di1CT0000IOol00`00FSEJ=@0AFSD0
1000GUENE@0015if00<006ZfJ[H05fZf00<006JEIYD026JE0P0026JE00<006:FHYH04F:F00<006:F
HYH00`0016:F00@005iEGUD000eJ=@03000j6SXJ00`j6P030012Fd9K00U2F`03001:NdYk00E:N`03
001oogoo00Eoo`03001oogoo00]oo`002Goo00<007ooOol037oo00<003il?W`00Sil00<003Xk>S/0
2CXk00<0027l8O`0327l00@000Di1CT5>@8001Qoo`03001J=EXe015J=@04001NEEiE0004GWH00`00
J[IZ]P0GJ[H00`00IYEVU@08IYD00`00IYEVU@08IYD00`00HYIRUP0?HYH600001F:F001RUV:F0000
0eiE00<005XeFSD02eXe00<003XJ>QX03CXJ00<0049K@U/0249K00<004YkBW/01TYk00<007ooOol0
17oo00<007ooOol02goo0009Ool00`00Oomoo`0=Ool01@00?W`nO3il000033Xk00<0027l8O`0327l
00D000Di1CT5>@0001Qoo`03001J=EXe019J=@8000ANMP04001^]000000FJ[H00`00IYEVU@08IYD0
0`00IYEVU@09IYD00`00HYIRUP0=HYH4000016:F000000000V:F0P001EiE00<005XeFSD02eXe00<0
03XJ>QX033XJ00<0049K@U/01d9K00<004YkBW/01dYk00<007ooOol017oo00<007ooOol02goo0009
Ool00`00Oomoo`0>Ool01000?W`nO0003CXk00<0027l8O`02b7l00@000Di1CT5>@8001Moo`03001J
=EXe019J=@03001NMUif00=NMP04001^]6jdK[@2000DJ[H00`00IYEVU@08IYD00`00IYEVU@09IYD0
0`00HYIRUP0:HYH3000:HYH00`00GUENE@04GUD00`00FSEJ=@0;FSD00`00>QXj6P0=>QX00`00@U]2
F`05@U/00`00BW]:N`09BW/00`00Oomoo`03Ool00`00Oomoo`0;Ool000Qoo`03001oogoo011oo`03
000nO00000dj>`03000Qo27l00`Qo0030005>@Di008001Qoo`03001J=EXe011J=@8000ANMP03001^
]6jd00A^]080015Z]P03001VUFJE00QVU@03001VUFJE00]VU@03001RUV:F00IRUP<000eRUP8000EN
E@03001J=EXe00]J=@03000j6SXJ00dj6P030012Fd9K00A2F`03001:NdYk00Y:N`03001oogoo00Ao
o`03001oogoo00Yoo`0027oo00<007ooOol047oo0P003cXk00<0027l8O`0327l00D000Di00004P00
01Moo`03001J=EXe00MJ=@X00003GWH005if009NMP03001^]6jd00I^]08000mZ]P03001VUFJE00MV
U@03001VUFJE00aVU@03001RUV:F00=RUP<000mRUP04001NEEiE0005GUD00`00FSEJ=@0:FSD5000<
>QX00`00@U]2F`03@U/00`00BW]:N`0;BW/00`00Oomoo`03Ool00`00Oomoo`0:Ool000Qoo`03001o
ogoo015oo`03000j>cXk00hj>`03000Qo27l00/Qo0030005>@Di008001Moo`X000MJE`03001NMeig
00D00003L[<006jd00Q^]08000aZ]P03001VUFJE00QVU@03001VUFJE00eVU@03001RUP000080015R
UP03001NEEiE009NE@03001NEEiE009NE@03001J=EXe00]J=@04001oogooOol90003>QX00`00@U]2
F`02@U/00`00BW]:N`0<BW/00`00Oomoo`03Ool00`00Oomoo`0:Ool000Qoo`03001oogoo015oo`03
000j>cXk00lj>`03000Qo27l00/Qo0050005>@000180000FOol00`00FUMJE`0<FUL20004GWL01P00
GYMNU`00L[<000]^]08000UZ]P03001VUFJE00QVU@03001VUFJE00aVU@@001=RUP03001NEEiE00AN
E@05001NEEiEGUD0000=FSD00`00Oomoo`0:OolI0004Ool00`00Oomoo`0:Ool000Qoo`03001oogoo
019oo`03000j>cXk00hj>`03000Qo27l00`Qo0800003018007oo01Ioo`03001JEeYG00YJE`03001N
Meig00ENM`03001NU`00009b/`03001^]6jd00Y^]08000MZ]P03001VUFJE00QVU@03001VUFJE00UV
U@<0009VU@03001RUV:F015RUP03001NEEiE00ENE@03001NEEiE009NE@03001J=EXe00YJ=@03001o
ogoo02Moo`03001oogoo00Yoo`0027oo00<007ooOol04Woo5000327l0P000P0B00<007ooOol057oo
00<005YGFUL02EYG00<005igGWL01Uig0P000g:c00<006jdK[@036jd0P0016Zf00<006JEIYD026JE
00<006JEIYD01fJE0`001VJE00<006:FHYH046:F00<005iEGUD01UiE00D005iEGUENE@0000eJ=@03
001oogoo02Ioo`03001oogoo00Yoo`001goo00<007ooOol057oo00<003HK=Q/03SHK00@002gJ0000
00/Qo0800003018007oo01Ioo`03001JEeYG00MJE`03001NMeig00QNM`05001b/g:cL[<0000@K[@2
0002J[H00`00IYEVU@07IYD00`00IYEVU@05IYD30009IYD00`00HYIRUP0?HYH00`00GUENE@08GUD0
1000GUENE@003EXe00<007ooOol09Woo00<007ooOol02Woo0007Ool00`00Oomoo`0DOol00`00=Q/f
6`0?=Q/00`00;MX]fP0300088O`2000201800`00Oomoo`0DOol00`00FUMJE`05FUL2000;GWL00`00
L[=b/`02L[<00`00K[A^]00?K[@30009IYD00`00IYEVU@02IYD3000<IYD00`00HYIRUP0>HYH00`00
GUENE@0:GUD00`00GUD0000=FSD00`00Oomoo`0WOol00`00Oomoo`09Ool000Moo`03001oogoo01Eo
o`03000f6cHK00hf6`03000]fRgJ00<]fP<000HQo00400004P0B000FOol00`00FUMJE`04FUL00`00
GWMNM`0:GWL00`00L[=b/`03L[<00`00K[A^]00@K[@00`00IW@000020005IYD6000@IYD00`00HYIR
UP0<HYH00`00GUENE@0<GUD00`00GUD0000<FSD00`00Oomoo`0WOol00`00Oomoo`09Ool000Moo`03
001oogoo01Eoo`03000f6cHK00lf6`03000]fRgJ00D]fP8000@Qo00500004P0B0180000FOol00`00
FUMJE`02FUL00`00GWMNM`0;GWL00`00L[=b/`03L[<00`00K[A^]00?K[@00`00IWAVM003IW@30000
0fJE00000005000@IYD00`00HYIRUP0;HYH00`00GUENE@0>GUD2000=FSD00`00Oomoo`0VOol00`00
Oomoo`09Ool000Moo`03001oogoo01Ioo`03000f6cHK00hf6`03000]fRgJ00L]fP<000038O`0000B
00804P03001oogoo01Aoo`03001JEeYG008000iNM`03001b/g:c00Ab/`03001^]6jd00i^]003001V
M6Id00AVM0D000EVU@<000eVU@03001RUV:F00]RUP03001NEEiE00iNE@8000eJ=@03001oogoo02Io
o`03001oogoo00Uoo`001goo00<007ooOol05goo00<003HK=Q/03SHK00<002gJ;MX02BgJ0`000`0B
00<007ooOol057oo0P003eig00<007:cL[<01G:c00<006jdK[@03Vjd00@006IdIWAVM0<000EVM080
00IVU@<000]VU@03001RUV:F00URUP03001NEEiE011NE@8000aJ=@03001oogoo02Ioo`03001oogoo
00Uoo`001goo00<007ooOol05goo00<003HK=Q/03SHK00<002gJ;MX02RgJ0P000`0B00<007ooOol0
57oo00<005igGWL03Uig00<007:cL[<01W:c00<006jdK[@036jd00<006Id00000P002VId0`001VJE
10001fJE00<006:FHYH026:F00<005iEGUD04UiE00<005XeFSD02UXe00<007ooOol09Woo00<007oo
Ool02Goo0006Ool00`00Oomoo`0IOol00`00=Q/f6`0>=Q/00`00;MX]fP08;MX010007EL000000P0B
00<007ooOol05Goo00<005igGWL03Eig00<007:cL[<01W:c00<006jdK[@02Vjd100046Id0`000fJE
00@0069fHWIRMP<000AVU@03001RUV:F00MRUP03001NEEiE01=NE@8000aJ=@03001oogoo02Eoo`03
001oogoo00Uoo`001Woo00<007ooOol06Goo00<003HK=Q/03SHK00<002gJ;MX022gJ00<001eG7EL0
0P000P0B00<007ooOol057oo00<005igGWL035ig00<007:cL[<01g:c00<006jdK[@01fjd0`000Vjd
00<006IdIW@04VId0`0000=VU@00HWH00f9f1@0000=VU@00HYH01f:F00<005iEGUD055iE0P001EXe
1`009goo00<007ooOol02Goo0006Ool00`00Oomoo`0JOol00`00=Q/f6`0>=Q/00`00;MX]fP06;MX0
10007ELMEaeG0P000P0B00<007ooOol05Goo00<005igGWL02eig00<007:cL[<027:c00<006jdK[@0
0fjd0`0016jd00<006IdIW@05VId400016:F00<005iEGUD05EiE1`001UGc00<007ooOol09Woo00<0
07ooOol027oo0006Ool00`00Oomoo`0KOol00`00=Q/f6`0==Q/00`00;MX]fP06;MX00`007ELME`02
7EL2000201800`00Oomoo`0DOol00`00GWMNM`0;GWL00`00L[=b/`08L[<00`00K[A^]0030007K[@0
0`00IWAVM00GIW@01000HWERM@002ehd2P004UiE00<005Gc00002UGc00<007ooOol09Woo00<007oo
Ool027oo0006Ool00`00Oomoo`0KOol00`00=Q/f6`0>=Q/00`00;MX]fP05;MX00`007ELME`027EL0
1@0005@0000B00005goo00<005igGWL02Eig00<007:cL[<02G:c0`002Vjd00<006IdIW@05fId00<0
069e00005Uhd3@001UiE00<005Gc00002UGc00<007ooOol09Goo00<007ooOol027oo0006Ool00`00
Oomoo`0LOol00`00=Q/f6`0==Q/00`00;MX]fP04;MX00`007ELME`037EL00`0005@0E003000FOol0
0`00GWMNM`09GWL00`00L[=b/`05L[<400000g:c001^]009K[@00`00IWAVM00IIW@2000KGS@00`00
EO=El`05EO<70002EO<00`00EO=El`07EO<00`00Oomoo`0UOol00`00Oomoo`08Ool000Eoo`03001o
ogoo00Aoo`8001Moo`03000f6cHK00hf6`03000]fRgJ00<]fP03000MEaeG00@ME`050000E0000180
000GOol00`00GWMNM`08GWL00`00L[=b/`02L[<30005L[<00`00K[A^]008K[@00`00IWAVM00IIW@0
0`00GSAN=00KGS@00`00EO=El`0>EO<00`00EO=El`05EO<2000WOol00`00Oomoo`08Ool000Eoo`03
001oogoo00Aoo`04000QV@00000FOol00`00=Q/f6`0==Q/00`00;MX]fP02;MX00`007ELME`057EL0
0`0005@0E003000FOol00`00GWMNM`07GWL00`00L[=b/`030009L[<00`00K[A^]007K[@00`00IWAV
M00IIW@00`00GSAN=00KGS@00`00EO=El`0>EO<00`00EO=El`04EO<00`00EO@0000WOol00`00Oomo
o`08Ool000Eoo`03001oogoo00Eoo`03000QVB6I008001Eoo`03000f6cHK00df6`05000]fRgJ;MX0
00087EL00`0005@0E002000GOol00`00GWMNM`06GWL3000<L[<00`00K[A^]006K[@00`00IWAVM00I
IW@00`00HU@0000LGS@00`00EO=El`0?EO<00`00EO=El`03EO<01000EOAEm0005Goo0P003goo00<0
07ooOol027oo0005Ool00`00Oomoo`05Ool00`008ITQV@028IT3000BOol00`00=Q/f6`0==Q/01@00
;MX]fRgJ000021eG00<0001D05@00`005Woo00<005igGWL00eig0`000Uig0P002g:c00<006jdK[@0
1Vjd00<006IdIW@06FId00<0069D000075hd00<005GcEO<045Gc00D005GcEO=El`0000=Em003001o
ogoo019oo`030013^4>h00<000eoo`03001oogoo00Moo`001Goo00<007ooOol01Woo00<0026I8IT0
126I0P004Goo00<003HK=Q/03CHK00<002gJ00002AeG00@0001D05@0E08001Moo`D000MNM`8000Yb
/`03001^]6jd00E^]003001VM6Id01QVM004001RE69D000LGS@00`00EO=El`0AEO<00`00EO<00004
EO@00`00Oomoo`0@Ool20006@kP3000:Ool00`00Oomoo`07Ool000Eoo`03001oogoo00Ioo`03000Q
VB6I00HQV@8000moo`03000f6cHK00df6`03000]fP0000XME`030000E01D00<001Aoo`<000YNM`03
001N^5jh008000Qb/`03001^]6jd00A^]003001VM6Id01UVM004001RE69D000MGS@00`00EO=El`0A
EO<00`00EOAEm003EO@00`00Oomoo`0?Ool30006@kP200000f?N00000008Ool00`00Oomoo`07Ool0
00Eoo`03001oogoo00Moo`03000QVB6I00LQV@8000ioo`<000df6`03000MEaeG00TME`030000E01D
00<0015oo`<000=oo`03001NMeig00ENM`8000EN^0<000Eb/`03001^]6jd00A^]003001VM6Id01QV
M003001RE69D009RE003001N=5hd01YN=003001EleGc015El`8000AEm003001oogoo00ioo`<000E3
^003001Ko@0000ASgP03001oogoo00Eoo`03001oogoo00Moo`0017oo00<007ooOol027oo00<0026I
8IT01b6I0P003Woo00<003gH?MP01@0023HK00<001eG7EL02QeG00<0001D05@00`003Goo0`001Woo
00<005igGWL015ig00<005jhG[P025jh0P0017:c00<006jdK[@00fjd00<006IdIW@066Id00<0069D
HU@00V9D00<005hdGS@06Uhd00<005GcEO<045Gc00<005Gd00001EGd00<007ooOol02goo1@000d>h
0P000U_m00<006?NHmh00f?N0P001Goo00<007ooOol01goo0004Ool00`00Oomoo`09Ool00`008ITQ
V@058IT2000@Ool00`00?MPmf004?MP50002=Q/00`00<KP0000;7EL00`0005@0E0030009Ool4000:
Ool01000GWMNMeig0P003Ejh0P000W:c00<006jdK[@00Vjd00<006IdIW@066Id00<0069DHU@00f9D
00<005hdGS@06Uhd00<005GcEO<03eGc00D005GdEOAEm00000AEm003001oogoo00Yoo`<000880@04
0013^0000003Fod00`00HmiSgP06Hmh00`00Oomoo`02Ool00`00Oomoo`07Ool000Aoo`03001oogoo
00Uoo`03000QVB6I00DQV@8000=oo`03001oogoo00Yoo`03000mf3gH00Tmf0D000`ME`060000E000
00002`001Goo0`003Woo00@005ig0000015N^0800003L[<006jd009^]003001VM6Id01QVM003001R
E69D00=RE003001N=5hd01YN=003001EleGc00iEl`03001Em5Gd00=Em005001Em5GdEO@0000;Ool3
000320420004Fod00`00HmiSgP05Hmh20005Ool00`00Oomoo`07Ool000Aoo`03001oogoo00Yoo`03
000QVB6I00<QV@03001cn000009oo`<000aoo`03000mf3gH00Tmf003000aEC5E008000/ME`030000
E01D00<0009oo`<0019oo`03001N^5jh01=N^08000=^]003001VM6Id01MVM003001RE69D00ERE003
001N=5hd01YN=003001EleGc00aEl`03001Em5Gd00EEm004001Em5Gd0009Ool3000420420004Fod0
0`00HmiSgP04Hmh20008Ool00`00Oomoo`06Ool000Aoo`03001oogoo00Yoo`03000QVB6I008QV@06
001cn7?h001oo`000V9f0P002goo00<003gH?MP023gH00<0035E<ED00S5E0P002QeG00<0001D05@0
1@005Woo00<005jhG[P04ejh10006VId00<0069DHU@01F9D00<005hdGS@06Uhd00<005GcEO<035Gc
00<005GdEO@01UGd00<005Gd000027oo0`001@P100<005_mFod00e_m00<006?NHmh00V?N0P002Woo
00<007ooOol01Woo0004Ool00`00Oomoo`0;Ool010008ITQV@000W?h00<007oo00000f9f0P002goo
00<003gH?MP01cgH00<0035E<ED0135E0`002AeG1@006Goo0`004ejh00@006:h000001UVM003001R
E69D00ERE003001N=5hd01YN=003001EleGc00]El`03001Em5Gd00MEm003001Em00000Moo`8000L8
0@03001KoE_m009Ko@03001SgV?N009SgP03001oogoo00Yoo`03001oogoo00Ioo`000goo00<007oo
Ool037oo00@0026I8IT0009cn003001oo`0000ARMP8000]oo`03000mf3gH00Dmf003000aEC5E00Da
E@04000YERUF00057EL4000205@3000IOol00`00G[T00004000>G[P00`00H[P00004000EIW@00`00
HUARE006HU@00`00GSAN=00JGS@00`00EO=El`0:EO<00`00EOAEm009EO@00`00EO@00004Ool20009
20401@00FoeKoE_m00000f?N0P003Goo00<007ooOol01Woo0003Ool00`00Oomoo`0=Ool20003LoP2
0005HWH00`0005<0000:Ool00`00?MPmf003?MP20008<ED01P00:EHYERUF000ME`<000@ME`030000
E000008001Uoo`03001N^Eji00AN^@H000UN^003001oogoo00=oo`<0019VM003001RE69D00MRE003
001N=5hd01UN=003001EleGc00UEl`03001Em5Gd00]Em08000=oo`8000X80@04001KoE_m0002Hmh2
000?Ool00`00Oomoo`06Ool000=oo`03001oogoo00eoo`03001cn7?h009cn003001RMV9f00ARMP04
0000D`1C000:Ool01@00?MPmf3gH00002S5E00<002UF:EH00`001aeG00<0001D00000P006Woo00<0
05jiG[T02Eji1@000ejh00<007ooOol01goo0`003VId00<0069DHU@0269D00<005hdGS@06Uhd00<0
05GcEO<01eGc00<005GdEO@03EGd00@007ooOol000`80@03001KoE_m00<0015oo`03001oogoo00Io
o`000goo00<007ooOol037oo00<007?hLoP00W?h00<0069fHWH01V9f00<0001C00002Woo00@003gH
?MP000/aE@<000<YEP8000DME`030000E000008001Yoo`03001N^Eji00iN^@<000eoo`8000aVM003
001RE69D00QRE003001N=5hd01YN=003001EleGc00MEl`03001Em5Gd00eEm0<000d80@04001Ko@00
000COol00`00Oomoo`06Ool000=oo`03001oogoo00]oo`03001cn7?h009cn003001RMV9f00MRMP04
0000D`1C000:Ool20009<ED300000c5E000YEP05:EH00`007ELME`037EL200000`0A0000000JOol0
0`00G[UN^@0=G[T2000@Ool30008IW@00`00HUARE009HU@00`00GSAN=00JGS@00`00EO=El`06EO<0
0`00EOAEm00>EO@2000=20400`00Fod0000EOol00`00Oomoo`06Ool000=oo`03001oogoo00]oo`05
001cn7?hLoP0000:HWH01@0005<0D`1C00002Goo00<0035E<ED0135E1000135E00<002UF:EH01BUF
00<001eG7EL00QeG0P0000<04@0000006Woo00<005jiG[T02eji0P005Goo0`001FId00<0069DHU@0
2V9D00<005hdGS@06Ehd00<005GcEO<01EGc00<005GdEO@045Gd0P0030P10P005goo00<007ooOol0
1Goo0002Ool00`00Oomoo`0;Ool01@00LoQcn7?h0000369f00D0001C05<0D`0000Qoo`04000aEC5E
<ED30008<ED00`00:EHYEP06:EH00`007ELME`027EL0100001404@006goo00<005jiG[T025ji0P00
6Woo0`0000=VM000HU@0369D00<005hdGS@06Ehd00<005GcEO<015Gc00<005GdEO@04EGd00<000P1
00002`P100<007ooOol05Woo00<007ooOol01Goo0002Ool00`00Oomoo`0:Ool01@00LoQcn7?h0000
3F9f00D0001C05<0D`0000Qoo`@000`aE@03000YERUF00HYEP05000MEaeG7EL000020142000KOol0
0`00G[UN^@06G[T00`00Oomoo`0MOol4000;HU@00`00GSAN=00JGS@00`00EO=El`03EO<00`00EOAE
m00<EO@6000220400`0020480@0820400`00Oomoo`0FOol00`00Oomoo`05Ool0009oo`03001oogoo
00Uoo`03001cn7?h009cn003001RMV9f00aRMP050000D`1C05<00005Ool3000?<ED00`00:EHYEP08
:EH00aeG0000000301400`00Oomoo`0IOol00`00G[UN^@04G[T2000TOol50006HU@00`00GSAN=00J
GS@00`00EO=El`02EO<00`00EOAEm002EO@;0002Ool2000520400`0020480@052043000HOol00`00
Oomoo`05Ool0009oo`03001oogoo00Qoo`03001cn7?h009cn003001RMV9f00eRMP030000D`1C0080
D`03001oo`00008000=oo`03000aEC5E00`aE@03000YERUF00TYEP8000<04@8001]oo`04001N^Eji
G[T2000[Ool50002HU@00`00GSAN=00<GS@G000<Ool3000620400`0020480@022042000260L00`00
Oomoo`0FOol00`00Oomoo`05Ool0009oo`03001oogoo00Qoo`05001cn7?hLoP0000@HWH00`0005<0
D`040006Ool00`00<EDaE@0<<ED00`00:EHYEP08:EH010007;8000000P0A0P006goo00@005ji0000
039ooa40029oo`@000H80@0300080@P1008000<H1`8001Qoo`03001oogoo00Eoo`000Woo00<007oo
Ool01goo00D007?hLoQcn000015RMP<00080D`03001oogoo00Eoo`03000aEC5E00daE@03000YERUF
00HYEP05000L/Qbb7;80000301400`00Oomoo`0IOol2001VOol400082042000460L00`00:2/0000H
Ool00`00Oomoo`05Ool0009oo`03001oogoo00Ioo`05001cn7?hLoP0000?HWH300000f9f0000D`02
05<00`00Oomoo`05Ool00`00<EDaE@0=<ED00`00:EHYEP06:EH01@007;8L/Qbb00000`0A00<007oo
Ool06Goo00<007ooOol0IGoo10001PP10P0000<H1`0060L00aP700<002P[00006Goo00<007ooOol0
17oo00000goo001oo`07Ool00`00LoQcn002000=HWH30005HWH0100005<0D`001goo00<0035E<ED0
3C5E00<002UF:EH01BUF00<001bb7;800Qbb0P000P0A00<007ooOol06Goo00<007ooOol0I7oo1@00
10P10P0011P700@001P760L0008X:`03001oogoo01Moo`03001oogoo00Aoo`0000=oo`00Ool01goo
10002f9f0`00269f00@0001C05<000Moo`03000aEC5E00daE@03000YERUF00@YEP03000L/Qbb00@L
/P0400004@0A000KOol00`00Oomoo`1SOol600022042000760L20003:2/00`00Oomoo`0GOol00`00
Oomoo`04Ool00003Ool007oo00Ioo`80009oo`03001RMV9f00ERMP@000]RMP040000D`1C0008Ool0
0`00<EDaE@0=<ED00`00:EHYEP02:EH00`007;8L/P057;82000201400`00Oomoo`0HOol00`00Oomo
o`1ROol600000`P10000000960L00`00:2/X:`02:2/00`00Oomoo`0GOol00`00Oomoo`04Ool00003
Ool007oo00Eoo`05001oogooOol00005HWH3000@HWH00`0005<00008Ool00`00<EDaE@0=<ED01@00
:EHYERUF000021bb0P000P0A00<007ooOol067oo00<007ooOol0HGoo20002aP70P000RP[00<007oo
Ool067oo00<007ooOol017oo00000goo001oo`08Ool01000HWIRMV9f0`004f9f00<0001C000027oo
00<0035E<ED03C5E00@002UF:EH000TL/P050004DP000140000JOol00`00Oomoo`1QOol7000;60L0
1P00:2/X:`00:2/001Yoo`03001oogoo00Aoo`0000=oo`00Ool01goo1@005V9f00<0001C000027oo
00<0035E<ED03C5E00@002UF:EH000TL/P050004DP000140000JOol00`00Oomoo`1POol600000`04
000H1`0960L00`00:2/X:`02:2/2000JOol00`00Oomoo`04Ool00003001oogoo00Ioo`@00003E<@0
000000D0015RMP8000Qoo`03000aEC5E00haE@8000XL/P030004DPAB008001Yoo`03001oogoo05mo
o`D000<01003000H1aP700LH1`03000X:bP[00@X:`03001oogoo01Qoo`03001oogoo00Aoo`0000<0
07ooOol00Woo1`002EC420002F9f0P0027oo00<0035E<ED03S5E00<001bb7;802Qbb00D000AB0000
4@0001Uoo`03001oogoo05ioo`D000<01003000H1aP700LH1`03000X:bP[00DX:`03001oogoo01Uo
o`03001oogoo00=oo`0000<007oo00000P001goo1P002eC41`000f9f00<007ooOol01goo00<0035E
<ED02c5E0`0031bb00<000AB15800P006Goo00<007ooOol0GWoo1000100400<001P760L01aP700<0
02P[:2/01BP[0P006Woo00<007ooOol00goo0002000@Ool6000:E<@60009Ool00`00<EDaE@09<ED2
0002<E@00`007;8L/P0:7;800`001584DP02000IOol00`00Oomoo`1MOol4000500@00`0060LH1`06
60L00`00:2/X:`06:2/00`00Ool0000IOol00`00Oomoo`03Ool00003Ool0000001Eoo`H000IDa003
001oogoo00Yoo`03000aEC5E00PaE@03000aE35D008aE003000L/Qbb00XL/P050004DPAB1580000I
Ool00`00Oomoo`1LOol3000700@00`0060LH1`0560L00`00:2/X:`07:2/01000Oomoo`0067oo00<0
07ooOol00goo0003Ool00`00Oomoo`0EOol00`008AHQ5P0600000eC4001oo`0:Ool00`00<EDaE@06
<ED20005<E@00`007;8L/P0:7;8010001584DPAB0P0067oo00<007ooOol0Fgoo0`00200400<001P7
60L011P700<002P[:2/01RP[0P0017oo00<007ooOol05Goo00<007ooOol00goo0004Ool00`00Oomo
o`0DOol00`008AHQ5P068AH3000:Ool00`00<EDaE@04<ED20007<E@00`007;8L/P0;7;801@001584
DPAB000067oo00<007ooOol0Fgoo0P002@0400<001P760L011P700<002P[:2/012P[0P001goo00<0
07ooOol03goo00<007ooOol00Woo00<007ooOol00goo0005Ool2000DOol00`008AHQ5P078AH00`00
Oomoo`09Ool00`00<EDaE@03<ED00`00<E@aE008<E@00`007;8L/P0:7;801@001584DPAB000067oo
00<007ooOol0FWoo00<0000400@02@0400<001P760L00aP700<002P[:2/00bP[0P002Goo00<007oo
Ool03Goo0P001Goo00<007ooOol00goo0007Ool00`00Oomoo`0BOol00`008AHQ5P068AH00`00Oomo
o`0:Ool00`00<EDaE@02000;<E@00`007;8L/P0:7;801@001584DPAB000067oo00<007ooOol0FGoo
00<0000400@02P0400<001P760L00QP700<002P[:2/00RP[0P0037oo00<007ooOol02Woo0`001goo
00<007ooOol00Woo0008Ool2000BOol00`008AHQ5P058AH00`00Oomoo`0;Ool3000=<E@00`007;8L
/P0:7;8010001584DP006Goo00<007ooOol0F7oo00<0000400@02P0400<001P760L00QP700@002P[
:2/X:`8000moo`03001oogoo00Qoo`03001?T`0000Qoo`03001oogoo009oo`002Woo00<007ooOol0
3goo00<0024F8AH0124F00<007ooOol037oo00<0035D<E@03C5D00<001bb7;802Qbb00@000AB1580
01Uoo`03001oogoo05Moo`8000`01003000H1aP7008H1`04000X:`00000BOol00`00Oomoo`06Ool3
0009Ool00`00Oomoo`02Ool000]oo`8000moo`03000Q5R4F00<Q5P03001oogoo00eoo`03000aE35D
00daE003000L/Qbb00XL/P030004DP0001Uoo`03001oogoo05Qoo`030000100400/01004000H1aP7
60L3000EOol00`00Oomoo`04Ool200000c6h001oo`08Ool00`00Oomoo`02Ool000eoo`03001oogoo
00eoo`03000Q5R4F008Q5P03001oogoo00eoo`03000aE35D00daE003000L/Qbb00/L/P8000Ioo`l0
00Aoo`03001oogoo05Qoo`030000100400/01003000H1`00008001Moo`03001oogoo00=oo`<00003
<KP007oo00Qoo`03001oogoo009oo`003Woo00<007ooOol037oo00D0024F8AHQ5P00015oo`03000a
E35D00`aE003000L/Qbb00/L/P03001oogoo00Aoo`0300108T0R00@000Tl00P005Ioo`8000d01080
01]oo`04001oogooOol300000f:F00000009Ool00`00Oomoo`02Ool000moo`8000aoo`04000Q5R4F
000BOol00`00<E@aE00<<E@00`007;8L/P0;7;800`00Oomoo`02Ool20007@283000>?007001?Ool2
000;00@2000NOol01000Ool0036h0P0000ARUP00<KP000Qoo`03001oogoo009oo`004Goo00<007oo
Ool02Goo00<0024F00004goo0P003C5D00<001bb7;802Qbb00<007ooOol00Woo00<0040R@2802T0R
100023`0100014@01P00BWoo00<0000400@02@0400<007ooOol07goo00T0036h00000@00HYH0036h
000027oo00<007ooOol00Woo000BOol2000:Ool2000COol00`00=E<0000<<E@00`007;8L/P087;82
0004OolJ000:A00300000cP0000000020015Ool2000900@2000ROol200000`01001RUP02HYH20009
Ool00`00Oomoo`01Ool001Aoo`03001oogoo00Moo`03001oogoo019oo`03000eDcEC008000XaE003
000L/Qbb00LL/P03001oogoo00=oo`03001A;54/01=A;08000=E1PH000M4008000<h00@0045oo`80
00P01003001oogoo025oo`<00003004006:F009RUP03000a^00000Qoo`03001oogoo005oo`005Goo
00<007ooOol06goo00<003EC=E<00SEC00<0035D<E@01c5D00<001bb7;801Qbb00<007ooOol017oo
00<0054/DB`04e4/00<005DZ000025D61P000d@00`0013P01000?7oo00<0000100001`0400<007oo
Ool08Goo00@0036h00000@8000ARUP8000Qoo`03001oogoo005oo`005Woo0P0077oo00<003EC=E<0
0SEC00<0035D<E@01c5D00<001bb7;800abb0P001Woo00<0054/DB`0554/00<005DZEBX00P0035D6
20001SP01000>7oo00<0000100001@040P008goo00<0036h00000`0100<006:FHYH00V:F0P0027oo
00<007ooOol00Goo000HOol00`00Oomoo`0IOol00`00=E<eD`03=E<00`00<E@aE006<E@00`007;8L
/P027;800`00Oomoo`06Ool00`00DBaA;00CDB`00`00EBYE:P03EBX00`00E@IE1P0?E@H?000eOol0
0`000040000400@00`00Oomoo`0ROol00`00<KP0000300400`00HYH00003HYH00`00<KP00007Ool0
0`00Oomoo`01Ool001Uoo`8001Uoo`03000eDcEC00@eD`03000aE35D00DaE005000L/Qbb7;800008
Ool00`00DBaA;00CDB`00`00EBYE:P05EBX00`00E@IE1P0BE@H20002ID@20005E8000`00Oomoo`0a
Ool00`000040000300@2000TOol00`00<KP0000400401000HYIRUP000f:F0P001goo00<007ooOol0
0Goo000KOol00`00Oomoo`0FOol00`00=E<eD`05=E<00`00<E@aE004<E@010007;8000002Goo00<0
054/DB`04e4/00<005DZEBX01UDZ00<005D6E@H04ED600<0065Y00000fE40`000eB00P00<Goo00<0
000100000P0400<007^f00009Goo0P000`0100<006:FHYH00V:F00<006:FHYH00P001goo00<007oo
Ool00Goo000LOol2000FOol00`00=E<eD`06=E<20004<E@2000:Ool00`00DBaA;00CDB`00`00EBYE
:P08EBX2000@E@H01@00HFUQJF5Y00001FE40`000UB000<007ooOol0;Woo00<0000100000P0000=k
]P00Ool09Goo00D0000100400@0000ERUP03001RUV:F008000Qoo`40005oo`5oo`007Woo00<007oo
Ool04goo00<003EC=E<023EC00D0035D<E@aE00000]oo`03001A;54/01=A;003001E:UDZ00YE:P03
001E1UD600aE1P03001QJF5Y00=QJ@03001UA6E400EUA0800003E80007oo02eoo`0400000@010003
NkH00`00Oomoo`0SOol00`0000400@020007HYH00`00HYIRUP020007Ool10001Ool1Ool001moo`03
001oogoo019oo`03000eDcEC00TeD`03000aE00000]oo`03001A;54/01=A;003001E:UDZ00aE:P03
001E1UD600UE1P8000IQJ@03001UA6E400MUA0@002aoo`0400000@000002NkH00`00Oomoo`0QOol0
0`00Ool0000200400`00HYIRUP08HYH01000HYH000001goo0@000Goo0Goo000POol2000BOol00`00
=E<eD`0:=E<00`00Oomoo`0:Ool00`00DBaA;00BDB`00`00EBYE:P0>EBX00`00E@IE1P07E@H00`00
HFUQJ@07HFT00`00IDAUA009ID@2000ZOol01@00004007N@00000W^f00<007ooOol087oo00H00534
00000001000<HYH00`00HYH00007Ool10001Ool1Ool0029oo`03001oogoo00moo`03000eDcEC00Pe
D`8000aoo`03001A;54/01=A;003001E:UDZ00mE:P8000IE1P03001QJF5Y00UQJ@03001UA6E400YU
A003001oogoo02Moo`800003Mk1gT000009k]P03001oogoo021oo`05001@a0000040000>HYH30006
Ool10001Ool1Ool002=oo`8000moo`03000eDcEC00HeD`8000ioo`03001A;54/00eA;10000YE:P03
001E1UD6009E1P03001QJF5Y00]QJ@03001UA6E400UUA003001oogoo02Moo`80009gT003001k]P00
029oo`05001@a0000040000?HYH30006Ool10001Ool1Ool002Eoo`03001oogoo00eoo`03000eDcEC
00@eD`03001oogoo00eoo`03001A;54/00=A;0/000EA;003001ISUV>00QISQ0000iQJ@03001UA6E4
00UUA003001oogoo02Eoo`800004Mk1gT7N@Mi02000ROol4000AHYH20006Ool10001Ool1Ool002Io
o`8000eoo`03000eDcEC008eD`80011oo`H000mA;003001ISUV>01EISP80009UZP@000]QJ@03001U
A6E400QUA003001oogoo02Eoo`03001g/7N`00=gT003001oogoo021oo`03001@a00001ARUP8000Io
o`40005oo`00:7oo00<007ooOol02Woo00<003EC=E<00P004Goo00<0054/DB`04e4/00<005V>FHh0
5UV>00<006FZIJX016FZ10001f5Y00<006E4ID@02FE400<007ooOol097oo00<007N`00000gN@00<0
07ooOol087oo10004f:F0P001Woo0@000Goo000YOol00`00Oomoo`09Ool3000COol00`00DBaA;00C
DB`00`00FHiISP0FFHh20009IJX40004HFT00`00IDAUA009ID@00`00Oomoo`0SOol00`00Mk1gT003
Mi000`00Oomoo`0OOol00`00D<A@a002D<@6000>HYH20005Ool10001Ool002Yoo`8000Uoo`03001o
ogoo01=oo`8001=A;003001ISUV>01IISP03001M[@0000eUZP@00003HFT006E400UUA003001oogoo
02=oo`03001g/7N@009gT003001oogoo021oo`03001@a53400Q@a0H000QRUP8000Eoo`40005oo`00
;7oo00<007ooOol06goo00@004e=CDd0019A;003001ISUV>01IISP04001M[Ef]000@IJX40009ID@0
0`00Oomoo`0ROol00`00Mk1gT002Mi000`00Oomoo`0OOol5000=D<@60003HYH20004Ool10001Ool0
02eoo`8001]oo`04001=CDe=CDd2000@DB`00`00FHiISP0EFHh01@00GJeM[Ef]00004VFZ00@006W/
000000MUA003001oogoo029oo`80009gT080021oo`8000Aoo`P000Q@a0800003Ool0000000800003
Ool007oo009oo`40005oo`00;goo00<007ooOol067oo00<004e=CDd00de=00<0054/DB`0354/00<0
05V>FHh05UV>00<005f]GJd00Uf]00<006FZIJX046FZ00<006W/JN`00P001VE400<007ooOol087oo
00<007N`Mi000WN@0P0087oo00<007ooOol02goo20000U340P001Goo00@007ooOol0005oo`00<7oo
00<007ooOol05goo00<004e=CDd014e=00<0054/DB`02e4/00<005V>FHh05UV>00<005f]GJd00Uf]
00<006FZIJX046FZ00<006W/JN`00VW/0P001FE400<007ooOol07goo00@007N`Mi1gT080021oo`80
01Eoo`D000Eoo`03001oo`00005oo`00<Goo0P005Woo00<004e=CDd01Te=00<0054/DB`02U4/00<0
05V>FHh05EV>00<005f]GJd015f]00<006FZIJX03fFZ00<006W/JN`016W/0P000fE400<007ooOol0
7goo00H007N`Mi0007n@000POol00`00Oomoo`0OOol10001Ool1000003=oo`03001oogoo01=oo`03
001=CDe=00M=C@03001A;54/00UA;003001ISUV>01EISP03001M[Ef]00EM[@03001UZVFZ00mUZP03
001Yk6W/00EYk080009UA003001oogoo01ioo`800004Mi0007n@000OOol2000QOol10001Ool10000
03Aoo`8001=oo`03001=CDe=00Q=C@03001A;54/00MA;003001ISUV>01IISP03001M[Ef]00EM[@03
001UZVFZ00mUZP03001Yk6W/00MYk0<0021oo`03001gT000009oT003001oogoo01eoo`03001oogoo
025oo`800000=Woo00<007ooOol03goo00<004e=CDd02Te=0P001e4/00<005V>FHh05EV>00<005f]
GJd01ef]00<006FZIJX03VFZ00<006W/JN`02FW/0P007goo0P000Wn@00<007ooOol07Goo0P008Woo
0`00000gOol2000?Ool00`00CDe=C@0<CDd00`00DBaA;004DB`00`00FHiISP0EFHh00`00GJeM[@07
GJd00`00IJYUZP0?IJX00`00JNaYk009JN`00`00Oomoo`0MOol20002Oi000`00Oomoo`0MOol00`00
Oomoo`0MOol40003Ool003Uoo`03001oogoo00aoo`03001=CDe=00e=C@03001A;54/009A;003001I
SUV>01EISP03001M[Ef]00UM[@03001UZVFZ00iUZP03001Yk6W/00YYk003001oogoo01aoo`05001o
T7n@Oi00000NOol2000JOol50007Ool003Yoo`03001oogoo00]oo`03001=CDe=00Y=CBL000EM[@03
001UZVFZ00mUZP03001Yk6W/00QYk08001ioo`05001oT7n@Oi00000NOol00`00Oomoo`0EOol4000<
Ool003]oo`8000Yoo`03001=CDe=009=C@T0019oo`8000I@PP8000]oo`P000mUZP03001Yk6W/00MY
k004001]jfg[000MOol01@00Oi1oT7n@0000<Woo100047oo000mOol00`00Oomoo`07Ool5000IOol2
000:D882000AOol3000<IJX00`00JNaYk007JN`01000KN]]j`007Woo00<007n@0000;Woo1@0057oo
000nOol2000SOol4000<D882000BOol3000:IJX00`00JNaYk005JN`00`00KN]]j`02KN/00`00Oomo
o`0KOol00`00Oi00000ZOol4000IOol0041oo`03001oogoo01moo`03001I:5TX009I:0L000M@PP80
01=oo`@000IUZP03001Yk6W/00AYk003001]jfg[00=]j`03001oogoo01]oo`03001oT00002Eoo`D0
01eoo`00@Goo00<007ooOol07Goo00<005TXFBP02UTX200000=@PP0000005Goo0`000fFZ00<006W/
JN`00fW/00<006g[KN/016g[00<007ooOol06goo00<007n@00008Goo10008Woo0012Ool2000LOol0
0`00ED/0000CFBP4000GOol300000fFZ001Yk003JN`00`00KN]]j`05KN/00`00Oomoo`0KOol00`00
Oomoo`0LOol4000VOol004Aoo`03001oogoo01Uoo`04001EBeE;000FFBP00`00Oomoo`0GOol30002
JN`00`00KN]]j`06KN/00`00Oomoo`0KOol00`00Oomoo`0GOol5000ZOol004Eoo`8001Qoo`03001E
BeE;009EB`8001EI:003001oogoo01Uoo`<000U]j`03001oogoo01Yoo`03001oogoo01=oo`@002mo
o`00Agoo00<007ooOol057oo00<005E;ED/01EE;00<005TXFBP04eTX00<007ooOol06goo0P001fg[
00<007ooOol0:goo1@00<goo0018Ool2000COol00`00ED]EB`07ED/00`00FBQI:00AFBP00`00HFX0
000NOol20005KN/00`00Oomoo`0WOol4000hOol004Yoo`03001oogoo011oo`03001EBeE;00QEB`03
001I:5TX00mI:005001QJV5ZHFX0000OOol20004KN/00`00Oomoo`0QOol5000lOol004]oo`03001o
ogoo00ioo`03001EBeE;00YEB`03001I:5TX00eI:003001QJV5Z009QJP03001oogoo01moo`80009]
j`03001oogoo01eoo`@0045oo`00C7oo0P003Goo00<005E;ED/035E;00<005TXFBP02eTX00<0065Z
HFX0165Z00<007ooOol087oo0P0000=]j`00Ool06Goo1000AGoo001>Ool00`00Oomoo`0:Ool00`00
ED]EB`0=ED/2000:FBP00`00HFYQJP06HFX00`00Oomoo`0QOol2000EOol50019Ool004moo`8000Uo
o`H000eEB`03001I:5TX00II:003001QJV5Z00QQJP03001oogoo03=oo`@004ioo`00DGoo00<007oo
Ool037oo2P0015E;00<005TXFBP015TX00<0065ZHFX02V5Z00<007ooOol0;Goo1@00DWoo001BOol2
000FOol=000<HFX00`00Oomoo`0XOol4001GOol005Aoo`03001oogoo01=oo`03001oogoo00Yoo`@0
00QQJP03001oogoo02Aoo`@005]oo`00EGoo00<007ooOol04Woo00<007ooOol03Woo1@00165Z00<0
07ooOol07Woo1@00Ggoo001FOol2000AOol00`00Oomoo`0DOol400000f5Z001oo`0JOol4001TOol0
05Qoo`03001oogoo00ioo`03001oogoo01Qoo`<001Eoo`D006Qoo`00FGoo0P003Woo00<007ooOol0
;7oo1000KGoo001KOol00`00Oomoo`0;Ool00`00Oomoo`0WOol5001aOol005aoo`03001oogoo00Yo
o`03001oogoo02=oo`@007Ioo`00GGoo0P002Woo00<007oo00007goo1000NWoo001OOol00`00Oomo
o`07Ool200000eTY001oo`0HOol5001nOol0061oo`8000Moo`D001Aoo`@008=oo`00HWoo00<007oo
Ool017oo00<007ooOol04Goo1@00Qgoo001SOol20004Ool00`00Oomoo`0=Ool4002<Ool006Eoo`05
001oogooOol0000;Ool4002@Ool006Ioo`04001oogoo0006Ool5002DOol006Moo`<0009oo`@009Uo
o`00JGoo0`00WGoo0000\
\>"],
  ImageRangeCache->{{{80.0625, 344.375}, {371, 84.0625}} -> {-0.211129, \
0.2727, 0.00324458, 0.00324458}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]="]
}, Closed]],

Cell[TextData[{
  "The command ",
  StyleBox["Needs", "MR"],
  " will load the specified add-on only if it has not already been loaded \
during a session. You can also use the ",
  StyleBox["Get", "MR"],
  " command, which is represented by ",
  StyleBox["<<", "MR"],
  ". This command will also load the ",
  StyleBox["ContourPlot3D.m", "MR"],
  " add-on."
}], "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[BoxData[
    \(<< Graphics`ContourPlot3D`\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[TextData[{
  "The ",
  StyleBox["<<", "MR"],
  " command always loads the specified add-on, even if has already been \
loaded during a session. You should be careful not to load the same add-on \
twice during a session since this may cause problems using the add-on. You \
can check what add-ons you have loaded at any time by evaluating ",
  StyleBox["$Packages", "MR"],
  "."
}], "Text",
  CellTags->"UsingAddOns"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Packages\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[BoxData[
    \({"Graphics`ContourPlot3D`", "Utilities`FilterOptions`", "Global`", 
      "System`"}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"Installing", "UsingAddOns"}]
}, Closed]],

Cell[TextData[{
  "If you find that you frequently use a standard package, you may want to \
set up the add-on so that it will load automatically every time you start ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". See",
  ButtonBox[" Installing New Add-ons",
    ButtonData:>"Installing New Add-ons",
    ButtonStyle->"AddOnsLinkText"],
  " for more information."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Shadowing Conflicts", "Subsection",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[TextData[{
  "Shadowing conflicts between function names are created when you try to use \
an add-on function without first loading the corresponding package. For \
example, you might try to fill in the area between two curves by using ",
  StyleBox["FilledPlot", "MR"],
  StyleBox[".",
    FontFamily->"Times New Roman"],
  " "
}], "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FilledPlot[{x, \ Sin[x]}, \ {x, \ \(-5\), \ 5}]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[BoxData[
    \(FilledPlot[{x, Sin[x]}, {x, \(-5\), 5}]\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}]
}, Closed]],

Cell[TextData[{
  "However, ",
  StyleBox["FilledPlot", "MR"],
  " is not a built-in function, and so ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not recognize it. Instead, it creates an empty symbol within the ",
  StyleBox["Global`", "MR"],
  " context called ",
  StyleBox["FilledPlot", "MR"],
  ". If you now load the package ",
  StyleBox["FilledPlot.m", "MR"],
  ", the generated error message will inform you that ",
  StyleBox["FilledPlot", "MR"],
  " is \"shadowed\" by its ",
  StyleBox["Global`", "MR"],
  " context definition, since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " starts from the ",
  StyleBox["Global`", "MR"],
  " context and moves to other contexts only if a definition does not exist \
in the ",
  StyleBox["Global`", "MR"],
  "context."
}], "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[BoxData[
    \(Needs["\<Graphics`FilledPlot`\>"]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[TextData[{
  "To fix this problem, use the command ",
  StyleBox["Remove", "MR"],
  " in order to clear empty definitions from the ",
  StyleBox["Global`", "MR"],
  " context."
}], "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[BoxData[
    \(Remove[FilledPlot]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " finds the correct definition and ",
  StyleBox["FilledPlot", "MR"],
  " behaves as expected."
}], "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FilledPlot[{x^2, \ Cos[x]}, \ {x, \ \(-10\), \ 10}]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.132889 0.118174 [
[.02381 .12039 -9 -9 ]
[.02381 .12039 9 0 ]
[.2619 .12039 -6 -9 ]
[.2619 .12039 6 0 ]
[.7381 .12039 -3 -9 ]
[.7381 .12039 3 0 ]
[.97619 .12039 -6 -9 ]
[.97619 .12039 6 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .25106 -6 -4.5 ]
[.4875 .25106 0 4.5 ]
[.4875 .36924 -6 -4.5 ]
[.4875 .36924 0 4.5 ]
[.4875 .48741 -6 -4.5 ]
[.4875 .48741 0 4.5 ]
[.4875 .60559 -6 -4.5 ]
[.4875 .60559 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .13289 m
.02381 .13914 L
s
[(-10)] .02381 .12039 0 1 Mshowa
.2619 .13289 m
.2619 .13914 L
s
[(-5)] .2619 .12039 0 1 Mshowa
.7381 .13289 m
.7381 .13914 L
s
[(5)] .7381 .12039 0 1 Mshowa
.97619 .13289 m
.97619 .13914 L
s
[(10)] .97619 .12039 0 1 Mshowa
.125 Mabswid
.07143 .13289 m
.07143 .13664 L
s
.11905 .13289 m
.11905 .13664 L
s
.16667 .13289 m
.16667 .13664 L
s
.21429 .13289 m
.21429 .13664 L
s
.30952 .13289 m
.30952 .13664 L
s
.35714 .13289 m
.35714 .13664 L
s
.40476 .13289 m
.40476 .13664 L
s
.45238 .13289 m
.45238 .13664 L
s
.54762 .13289 m
.54762 .13664 L
s
.59524 .13289 m
.59524 .13664 L
s
.64286 .13289 m
.64286 .13664 L
s
.69048 .13289 m
.69048 .13664 L
s
.78571 .13289 m
.78571 .13664 L
s
.83333 .13289 m
.83333 .13664 L
s
.88095 .13289 m
.88095 .13664 L
s
.92857 .13289 m
.92857 .13664 L
s
.25 Mabswid
0 .13289 m
1 .13289 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .25106 m
.50625 .25106 L
s
[(1)] .4875 .25106 1 0 Mshowa
.5 .36924 m
.50625 .36924 L
s
[(2)] .4875 .36924 1 0 Mshowa
.5 .48741 m
.50625 .48741 L
s
[(3)] .4875 .48741 1 0 Mshowa
.5 .60559 m
.50625 .60559 L
s
[(4)] .4875 .60559 1 0 Mshowa
.125 Mabswid
.5 .03835 m
.50375 .03835 L
s
.5 .06198 m
.50375 .06198 L
s
.5 .08562 m
.50375 .08562 L
s
.5 .10925 m
.50375 .10925 L
s
.5 .15652 m
.50375 .15652 L
s
.5 .18016 m
.50375 .18016 L
s
.5 .20379 m
.50375 .20379 L
s
.5 .22743 m
.50375 .22743 L
s
.5 .2747 m
.50375 .2747 L
s
.5 .29833 m
.50375 .29833 L
s
.5 .32197 m
.50375 .32197 L
s
.5 .3456 m
.50375 .3456 L
s
.5 .39287 m
.50375 .39287 L
s
.5 .41651 m
.50375 .41651 L
s
.5 .44014 m
.50375 .44014 L
s
.5 .46378 m
.50375 .46378 L
s
.5 .51105 m
.50375 .51105 L
s
.5 .53468 m
.50375 .53468 L
s
.5 .55832 m
.50375 .55832 L
s
.5 .58195 m
.50375 .58195 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.40379 .61803 m
.42237 .44699 L
.44268 .3041 L
.45178 .25405 L
.46172 .20927 L
.4671 .1893 L
.4721 .17347 L
.47727 .15981 L
.48196 .14984 L
.48658 .14227 L
.4887 .13955 L
.49093 .13718 L
.49332 .13521 L
.49438 .13453 L
.49552 .13393 L
.49675 .13344 L
.49789 .13312 L
.49859 .13299 L
.49925 .13292 L
.50049 .1329 L
.50163 .13303 L
.50286 .13331 L
.50401 .13373 L
.50508 .13423 L
.50754 .13585 L
.51014 .13825 L
.51268 .14127 L
.51504 .14468 L
.5204 .15457 L
.5293 .17764 L
.53882 .21142 L
.54906 .25833 L
.56016 .32153 L
.58032 .46906 L
s
.58032 .46906 m
.59615 .61803 L
s
.02381 .03373 m
.02846 .02794 L
.03279 .02344 L
.03754 .01955 L
.0402 .01786 L
.04262 .01663 L
.04385 .01612 L
.04516 .01566 L
.04629 .01534 L
.0475 .01507 L
.04881 .01486 L
.05003 .01475 L
.05077 .01472 L
.05148 .01472 L
.05212 .01474 L
.05281 .01478 L
.05408 .01493 L
.05523 .01514 L
.05656 .01546 L
.05781 .01585 L
.06003 .01674 L
.06244 .01799 L
.06753 .0216 L
.07312 .02701 L
.08439 .04227 L
.09483 .06094 L
.10458 .0815 L
.14349 .17532 L
.15366 .19774 L
.16473 .21875 L
.1698 .22689 L
.17518 .23437 L
.18022 .2402 L
.18485 .24449 L
.18941 .2477 L
.19171 .24892 L
.19422 .24994 L
.19554 .25034 L
.19675 .25064 L
.19742 .25076 L
.19814 .25088 L
.19945 .25102 L
.20068 .25106 L
.20198 .25103 L
.2031 .25093 L
.20432 .25074 L
.20554 .25048 L
.2067 .25016 L
.20887 .24937 L
.21121 .24825 L
Mistroke
.21376 .24671 L
.21835 .24313 L
.2226 .23889 L
.23319 .22476 L
.24316 .20731 L
.26178 .1667 L
.30038 .07412 L
.31072 .05342 L
.32036 .03746 L
.33042 .02497 L
.33574 .02027 L
.33872 .01825 L
.34144 .0168 L
.34373 .01587 L
.34504 .01546 L
.34626 .01516 L
.34755 .01493 L
.34873 .01479 L
.35002 .01472 L
.35067 .01472 L
.35138 .01474 L
.35259 .01484 L
.35368 .015 L
.35495 .01525 L
.35614 .01557 L
.35826 .01632 L
.36056 .0174 L
.36582 .02086 L
.37138 .026 L
.38134 .03879 L
.3908 .05475 L
.40095 .07528 L
.41928 .11823 L
.43906 .16681 L
.44951 .19062 L
.46061 .21288 L
.47043 .229 L
.47565 .23594 L
.48128 .24205 L
.48378 .24428 L
.48642 .24629 L
.48887 .24785 L
.49115 .24903 L
.49329 .24989 L
.49438 .25024 L
.49557 .25055 L
.49688 .25081 L
.49811 .25097 L
.49931 .25105 L
.50042 .25106 L
Mistroke
.50167 .25099 L
.50286 .25085 L
.50392 .25066 L
.50508 .25039 L
.50768 .24953 L
.5101 .24842 L
.51448 .24564 L
.51916 .24163 L
.52473 .23548 L
.52998 .2284 L
.53979 .21215 L
.57836 .12406 L
.59792 .07774 L
.60828 .05648 L
.61938 .03772 L
.62488 .03029 L
.63008 .02451 L
.63475 .02042 L
.63716 .01873 L
.63982 .0172 L
.6423 .0161 L
.64463 .01536 L
.64591 .01507 L
.64708 .01488 L
.64837 .01475 L
.64902 .01472 L
.64973 .01472 L
.65093 .01476 L
.65202 .01487 L
.65329 .01507 L
.65448 .01533 L
.6566 .01599 L
.65889 .01696 L
.66125 .01824 L
.66379 .01992 L
.66837 .02377 L
.67878 .03622 L
.68978 .05435 L
.69983 .07459 L
.73961 .17 L
.74996 .19332 L
.7597 .21268 L
.76917 .22834 L
.77788 .23941 L
.78249 .24386 L
.78736 .24743 L
.78989 .24881 L
.79225 .24981 L
.7936 .25025 L
.79483 .25057 L
Mistroke
.79552 .25071 L
.79626 .25084 L
.79696 .25093 L
.7976 .251 L
.79881 .25106 L
.8001 .25104 L
.80133 .25094 L
.80245 .25079 L
.80376 .25052 L
.80519 .25013 L
.80779 .24915 L
.8105 .24775 L
.81339 .24585 L
.81859 .2414 L
.82395 .23546 L
.82887 .22885 L
.84 .21028 L
.86016 .16674 L
.88058 .11662 L
.89964 .07229 L
.90904 .05356 L
.91796 .03865 L
.92288 .0318 L
.92823 .02557 L
.93309 .02108 L
.9376 .01797 L
.93997 .01674 L
.94215 .01587 L
.94339 .01548 L
.94454 .01519 L
.94574 .01496 L
.94706 .01479 L
.94821 .01472 L
.94931 .01472 L
.95029 .01477 L
.95135 .01488 L
.95251 .01507 L
.95374 .01535 L
.95594 .01604 L
.95834 .01708 L
.96092 .01852 L
.96558 .02198 L
.97112 .02747 L
.97619 .03373 L
Mfstroke
0 1 1 r
.02381 11.9503 m
.06244 10.1105 L
.10458 8.28141 L
.14415 6.73208 L
.18221 5.39605 L
.22272 4.13979 L
.26171 3.09208 L
.30316 2.15222 L
.34309 1.41607 L
.3815 .86471 L
.40095 .64422 L
.42237 .44699 L
.44268 .3041 L
.45178 .25405 L
.46172 .20927 L
.4671 .1893 L
.4721 .17347 L
.47727 .15981 L
.48196 .14984 L
.48658 .14227 L
.4887 .13955 L
.49093 .13718 L
.49332 .13521 L
.49438 .13453 L
.49552 .13393 L
.49675 .13344 L
.49789 .13312 L
.49859 .13299 L
.49925 .13292 L
.50049 .1329 L
.50163 .13303 L
.50286 .13331 L
.50401 .13373 L
.50508 .13423 L
.50754 .13585 L
.51014 .13825 L
.51268 .14127 L
.51504 .14468 L
.5204 .15457 L
.5293 .17764 L
.53882 .21142 L
.54906 .25833 L
.56016 .32153 L
.58032 .46906 L
.60019 .65603 L
.62123 .89886 L
.65912 1.45242 L
.69946 2.20627 L
.73829 3.09197 L
.77956 4.20592 L
.81932 5.44689 L
.85757 6.79602 L
.89827 8.39911 L
.93745 10.1056 L
.97619 11.9503 L
.97619 .03373 L
.97112 .02747 L
.96558 .02198 L
.96092 .01852 L
.95834 .01708 L
.95594 .01604 L
.95374 .01535 L
.95251 .01507 L
.95135 .01488 L
.95029 .01477 L
.94931 .01472 L
.94821 .01472 L
.94706 .01479 L
.94574 .01496 L
.94454 .01519 L
.94339 .01548 L
.94215 .01587 L
.93997 .01674 L
.9376 .01797 L
.93309 .02108 L
.92823 .02557 L
.92288 .0318 L
.91796 .03865 L
.90904 .05356 L
.89964 .07229 L
.88058 .11662 L
.86016 .16674 L
.84 .21028 L
.82887 .22885 L
.82395 .23546 L
.81859 .2414 L
.81339 .24585 L
.8105 .24775 L
.80779 .24915 L
.80519 .25013 L
.80376 .25052 L
.80245 .25079 L
.80133 .25094 L
.8001 .25104 L
.79881 .25106 L
.7976 .251 L
.79696 .25093 L
.79626 .25084 L
.79552 .25071 L
.79483 .25057 L
.7936 .25025 L
.79225 .24981 L
.78989 .24881 L
.78736 .24743 L
.78249 .24386 L
.77788 .23941 L
.76917 .22834 L
.7597 .21268 L
.74996 .19332 L
.73961 .17 L
.69983 .07459 L
.68978 .05435 L
.67878 .03622 L
.66837 .02377 L
.66379 .01992 L
.66125 .01824 L
.65889 .01696 L
.6566 .01599 L
.65448 .01533 L
.65329 .01507 L
.65202 .01487 L
.65093 .01476 L
.64973 .01472 L
.64902 .01472 L
.64837 .01475 L
.64708 .01488 L
.64591 .01507 L
.64463 .01536 L
.6423 .0161 L
.63982 .0172 L
.63716 .01873 L
.63475 .02042 L
.63008 .02451 L
.62488 .03029 L
.61938 .03772 L
.60828 .05648 L
.59792 .07774 L
.57836 .12406 L
.53979 .21215 L
.52998 .2284 L
.52473 .23548 L
.51916 .24163 L
.51448 .24564 L
.5101 .24842 L
.50768 .24953 L
.50508 .25039 L
.50392 .25066 L
.50286 .25085 L
.50167 .25099 L
.50042 .25106 L
.49931 .25105 L
.49811 .25097 L
.49688 .25081 L
.49557 .25055 L
.49438 .25024 L
.49329 .24989 L
.49115 .24903 L
.48887 .24785 L
.48642 .24629 L
.48378 .24428 L
.48128 .24205 L
.47565 .23594 L
.47043 .229 L
.46061 .21288 L
.44951 .19062 L
.43906 .16681 L
.41928 .11823 L
.40095 .07528 L
.3908 .05475 L
.38134 .03879 L
.37138 .026 L
.36582 .02086 L
.36056 .0174 L
.35826 .01632 L
.35614 .01557 L
.35495 .01525 L
.35368 .015 L
.35259 .01484 L
.35138 .01474 L
.35067 .01472 L
.35002 .01472 L
.34873 .01479 L
.34755 .01493 L
.34626 .01516 L
.34504 .01546 L
.34373 .01587 L
.34144 .0168 L
.33872 .01825 L
.33574 .02027 L
.33042 .02497 L
.32036 .03746 L
.31072 .05342 L
.30038 .07412 L
.26178 .1667 L
.24316 .20731 L
.23319 .22476 L
.2226 .23889 L
.21835 .24313 L
.21376 .24671 L
.21121 .24825 L
.20887 .24937 L
.2067 .25016 L
.20554 .25048 L
.20432 .25074 L
.2031 .25093 L
.20198 .25103 L
.20068 .25106 L
.19945 .25102 L
.19814 .25088 L
.19742 .25076 L
.19675 .25064 L
.19554 .25034 L
.19422 .24994 L
.19171 .24892 L
.18941 .2477 L
.18485 .24449 L
.18022 .2402 L
.17518 .23437 L
.1698 .22689 L
.16473 .21875 L
.15366 .19774 L
.14349 .17532 L
.10458 .0815 L
.09483 .06094 L
.08439 .04227 L
.07312 .02701 L
.06753 .0216 L
.06244 .01799 L
.06003 .01674 L
.05781 .01585 L
.05656 .01546 L
.05523 .01514 L
.05408 .01493 L
.05281 .01478 L
.05212 .01474 L
.05148 .01472 L
.05077 .01472 L
.05003 .01475 L
.04881 .01486 L
.0475 .01507 L
.04629 .01534 L
.04516 .01566 L
.04385 .01612 L
.04262 .01663 L
.0402 .01786 L
.03754 .01955 L
.03279 .02344 L
.02846 .02794 L
.02381 .03373 L
F
0 g
.40379 .61803 m
.42237 .44699 L
.44268 .3041 L
.45178 .25405 L
.46172 .20927 L
.4671 .1893 L
.4721 .17347 L
.47727 .15981 L
.48196 .14984 L
.48658 .14227 L
.4887 .13955 L
.49093 .13718 L
.49332 .13521 L
.49438 .13453 L
.49552 .13393 L
.49675 .13344 L
.49789 .13312 L
.49859 .13299 L
.49925 .13292 L
.50049 .1329 L
.50163 .13303 L
.50286 .13331 L
.50401 .13373 L
.50508 .13423 L
.50754 .13585 L
.51014 .13825 L
.51268 .14127 L
.51504 .14468 L
.5204 .15457 L
.5293 .17764 L
.53882 .21142 L
.54906 .25833 L
.56016 .32153 L
.58032 .46906 L
s
.58032 .46906 m
.59615 .61803 L
s
.02381 .03373 m
.02846 .02794 L
.03279 .02344 L
.03754 .01955 L
.0402 .01786 L
.04262 .01663 L
.04385 .01612 L
.04516 .01566 L
.04629 .01534 L
.0475 .01507 L
.04881 .01486 L
.05003 .01475 L
.05077 .01472 L
.05148 .01472 L
.05212 .01474 L
.05281 .01478 L
.05408 .01493 L
.05523 .01514 L
.05656 .01546 L
.05781 .01585 L
.06003 .01674 L
.06244 .01799 L
.06753 .0216 L
.07312 .02701 L
.08439 .04227 L
.09483 .06094 L
.10458 .0815 L
.14349 .17532 L
.15366 .19774 L
.16473 .21875 L
.1698 .22689 L
.17518 .23437 L
.18022 .2402 L
.18485 .24449 L
.18941 .2477 L
.19171 .24892 L
.19422 .24994 L
.19554 .25034 L
.19675 .25064 L
.19742 .25076 L
.19814 .25088 L
.19945 .25102 L
.20068 .25106 L
.20198 .25103 L
.2031 .25093 L
.20432 .25074 L
.20554 .25048 L
.2067 .25016 L
.20887 .24937 L
.21121 .24825 L
Mistroke
.21376 .24671 L
.21835 .24313 L
.2226 .23889 L
.23319 .22476 L
.24316 .20731 L
.26178 .1667 L
.30038 .07412 L
.31072 .05342 L
.32036 .03746 L
.33042 .02497 L
.33574 .02027 L
.33872 .01825 L
.34144 .0168 L
.34373 .01587 L
.34504 .01546 L
.34626 .01516 L
.34755 .01493 L
.34873 .01479 L
.35002 .01472 L
.35067 .01472 L
.35138 .01474 L
.35259 .01484 L
.35368 .015 L
.35495 .01525 L
.35614 .01557 L
.35826 .01632 L
.36056 .0174 L
.36582 .02086 L
.37138 .026 L
.38134 .03879 L
.3908 .05475 L
.40095 .07528 L
.41928 .11823 L
.43906 .16681 L
.44951 .19062 L
.46061 .21288 L
.47043 .229 L
.47565 .23594 L
.48128 .24205 L
.48378 .24428 L
.48642 .24629 L
.48887 .24785 L
.49115 .24903 L
.49329 .24989 L
.49438 .25024 L
.49557 .25055 L
.49688 .25081 L
.49811 .25097 L
.49931 .25105 L
.50042 .25106 L
Mistroke
.50167 .25099 L
.50286 .25085 L
.50392 .25066 L
.50508 .25039 L
.50768 .24953 L
.5101 .24842 L
.51448 .24564 L
.51916 .24163 L
.52473 .23548 L
.52998 .2284 L
.53979 .21215 L
.57836 .12406 L
.59792 .07774 L
.60828 .05648 L
.61938 .03772 L
.62488 .03029 L
.63008 .02451 L
.63475 .02042 L
.63716 .01873 L
.63982 .0172 L
.6423 .0161 L
.64463 .01536 L
.64591 .01507 L
.64708 .01488 L
.64837 .01475 L
.64902 .01472 L
.64973 .01472 L
.65093 .01476 L
.65202 .01487 L
.65329 .01507 L
.65448 .01533 L
.6566 .01599 L
.65889 .01696 L
.66125 .01824 L
.66379 .01992 L
.66837 .02377 L
.67878 .03622 L
.68978 .05435 L
.69983 .07459 L
.73961 .17 L
.74996 .19332 L
.7597 .21268 L
.76917 .22834 L
.77788 .23941 L
.78249 .24386 L
.78736 .24743 L
.78989 .24881 L
.79225 .24981 L
.7936 .25025 L
.79483 .25057 L
Mistroke
.79552 .25071 L
.79626 .25084 L
.79696 .25093 L
.7976 .251 L
.79881 .25106 L
.8001 .25104 L
.80133 .25094 L
.80245 .25079 L
.80376 .25052 L
.80519 .25013 L
.80779 .24915 L
.8105 .24775 L
.81339 .24585 L
.81859 .2414 L
.82395 .23546 L
.82887 .22885 L
.84 .21028 L
.86016 .16674 L
.88058 .11662 L
.89964 .07229 L
.90904 .05356 L
.91796 .03865 L
.92288 .0318 L
.92823 .02557 L
.93309 .02108 L
.9376 .01797 L
.93997 .01674 L
.94215 .01587 L
.94339 .01548 L
.94454 .01519 L
.94574 .01496 L
.94706 .01479 L
.94821 .01472 L
.94931 .01472 L
.95029 .01477 L
.95135 .01488 L
.95251 .01507 L
.95374 .01535 L
.95594 .01604 L
.95834 .01708 L
.96092 .01852 L
.96558 .02198 L
.97112 .02747 L
.97619 .03373 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.132889 0.118174 [
[.02381 .12039 -9 -9 ]
[.02381 .12039 9 0 ]
[.2619 .12039 -6 -9 ]
[.2619 .12039 6 0 ]
[.7381 .12039 -3 -9 ]
[.7381 .12039 3 0 ]
[.97619 .12039 -6 -9 ]
[.97619 .12039 6 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .25106 -6 -4.5 ]
[.4875 .25106 0 4.5 ]
[.4875 .36924 -6 -4.5 ]
[.4875 .36924 0 4.5 ]
[.4875 .48741 -6 -4.5 ]
[.4875 .48741 0 4.5 ]
[.4875 .60559 -6 -4.5 ]
[.4875 .60559 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .13289 m
.02381 .13914 L
s
[(-10)] .02381 .12039 0 1 Mshowa
.2619 .13289 m
.2619 .13914 L
s
[(-5)] .2619 .12039 0 1 Mshowa
.7381 .13289 m
.7381 .13914 L
s
[(5)] .7381 .12039 0 1 Mshowa
.97619 .13289 m
.97619 .13914 L
s
[(10)] .97619 .12039 0 1 Mshowa
.125 Mabswid
.07143 .13289 m
.07143 .13664 L
s
.11905 .13289 m
.11905 .13664 L
s
.16667 .13289 m
.16667 .13664 L
s
.21429 .13289 m
.21429 .13664 L
s
.30952 .13289 m
.30952 .13664 L
s
.35714 .13289 m
.35714 .13664 L
s
.40476 .13289 m
.40476 .13664 L
s
.45238 .13289 m
.45238 .13664 L
s
.54762 .13289 m
.54762 .13664 L
s
.59524 .13289 m
.59524 .13664 L
s
.64286 .13289 m
.64286 .13664 L
s
.69048 .13289 m
.69048 .13664 L
s
.78571 .13289 m
.78571 .13664 L
s
.83333 .13289 m
.83333 .13664 L
s
.88095 .13289 m
.88095 .13664 L
s
.92857 .13289 m
.92857 .13664 L
s
.25 Mabswid
0 .13289 m
1 .13289 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .25106 m
.50625 .25106 L
s
[(1)] .4875 .25106 1 0 Mshowa
.5 .36924 m
.50625 .36924 L
s
[(2)] .4875 .36924 1 0 Mshowa
.5 .48741 m
.50625 .48741 L
s
[(3)] .4875 .48741 1 0 Mshowa
.5 .60559 m
.50625 .60559 L
s
[(4)] .4875 .60559 1 0 Mshowa
.125 Mabswid
.5 .03835 m
.50375 .03835 L
s
.5 .06198 m
.50375 .06198 L
s
.5 .08562 m
.50375 .08562 L
s
.5 .10925 m
.50375 .10925 L
s
.5 .15652 m
.50375 .15652 L
s
.5 .18016 m
.50375 .18016 L
s
.5 .20379 m
.50375 .20379 L
s
.5 .22743 m
.50375 .22743 L
s
.5 .2747 m
.50375 .2747 L
s
.5 .29833 m
.50375 .29833 L
s
.5 .32197 m
.50375 .32197 L
s
.5 .3456 m
.50375 .3456 L
s
.5 .39287 m
.50375 .39287 L
s
.5 .41651 m
.50375 .41651 L
s
.5 .44014 m
.50375 .44014 L
s
.5 .46378 m
.50375 .46378 L
s
.5 .51105 m
.50375 .51105 L
s
.5 .53468 m
.50375 .53468 L
s
.5 .55832 m
.50375 .55832 L
s
.5 .58195 m
.50375 .58195 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[23]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00OT7oo00<007ooOol0
SGoo002@Ool00`00Oomoo`2=Ool008Qoo`D000=oo`03001oogoo08eoo`00RWoo00<007ooOol00goo
00<007ooOol0SGoo000?Ool4001AOol4000ROol00`00Oomoo`03Ool3000VOol5001@Ool5000=Ool0
00eoo`<000<3o`8004eoo`8000@3o`03001oogoo01Moo`@000Aoo`03001oogoo00=oo`03001oogoo
02Aoo`8000@3o`8004eoo`8000@3o`8000aoo`0037oo00<000?o0ol01P?o00<007ooOol0BGoo00<0
00?o0ol01@?o0P007goo00<007ooOol00goo00<007ooOol08goo00<000?o0ol01P?o00<007ooOol0
BGoo00<000?o0ol01P?o00<007ooOol02Goo000;Ool00`000ol3o`080ol00`00Oomoo`17Ool00`00
0ol3o`080ol2000LOol20005Ool00`00Oomoo`0ROol00`000ol3o`080ol00`00Oomoo`17Ool00`00
0ol3o`080ol00`00Oomoo`08Ool000Yoo`030003o`?o00X3o`03001oogoo04Eoo`030003o`?o00X3
o`03001oogoo025oo`03001oogoo025oo`030003o`?o00X3o`03001oogoo04Eoo`030003o`?o00X3
o`03001oogoo00Moo`002Goo00<000?o0ol030?o00<007ooOol0@goo00<000?o0ol030?o00<007oo
Ool087oo00<007ooOol08Goo00<000?o0ol02`?o00<007ooOol0@goo00<000?o0ol02`?o00<007oo
Ool01goo0009Ool00`000ol3o`0<0ol00`00Oomoo`13Ool00`000ol3o`0<0ol00`00Oomoo`0POol0
0`00Oomoo`0POol00`000ol3o`0=0ol00`00Oomoo`11Ool00`000ol3o`0=0ol00`00Oomoo`06Ool0
00Uooa03o`03001oogoo045oo`030003o`?o00h3o`03001oogoo01moo`80021oo`030003o`?o00l3
o`03001oogoo041oo`030003o`?o00d3o`Uoo`002Goo4@?o00<007ooOol0?goo00<000?o0ol040?o
00<007ooOol07Woo00<007ooOol07Woo00<000?o0ol040?o00<007ooOol0?goo00<000?o0ol03P?o
2Goo0009OolB0ol00`00Oomoo`0mOol00`000ol3o`0A0ol00`00Oomoo`0NOol00`00Oomoo`0NOol0
0`000ol3o`0A0ol00`00Oomoo`0mOol00`000ol3o`0?0ol9Ool000Uooa83o`03001oogoo03eoo`03
0003o`?o0183o`03001oogoo01eoo`03001oogoo01eoo`030003o`?o0183o`03001oogoo03eoo`03
0003o`?o00l3o`Uoo`002Goo4`?o00<007ooOol0>goo00<000?o0ol050?o00<007ooOol077oo00<0
07ooOol07Goo00<000?o0ol04`?o00<007ooOol0>goo00<000?o0ol040?o2Goo0009OolC0ol00`00
Oomoo`0jOol00`000ol3o`0E0ol00`00Oomoo`0LOol00`00Oomoo`0LOol00`000ol3o`0D0ol00`00
Oomoo`0kOol00`000ol3o`0@0ol9Ool000Uooa@3o`03001oogoo03Uoo`030003o`?o01H3o`03001o
ogoo01]oo`03001oogoo01]oo`030003o`?o01H3o`03001oogoo03Uoo`030003o`?o0143o`Uoo`00
2Goo50?o00<007ooOol0>7oo00<000?o0ol05`?o00<007ooOol06goo0P0077oo00<000?o0ol05P?o
00<007ooOol0>Goo00<000?o0ol04@?o2Goo0009OolE0ol00`00Oomoo`0gOol00`000ol3o`0H0ol0
0`00Oomoo`0JOol00`00Oomoo`0JOol00`000ol3o`0H0ol00`00Oomoo`0gOol00`000ol3o`0B0ol9
Ool000UooaD3o`03001oogoo03Ioo`030003o`?o01T3o`03001oogoo01Yoo`03001oogoo01Yoo`03
0003o`?o01P3o`03001oogoo03Moo`030003o`?o0183o`Uoo`002Goo5P?o00<007ooOol0=Goo00<0
00?o0ol06P?o00<007ooOol06Goo00<007ooOol06Goo00<000?o0ol06P?o00<007ooOol0=Woo00<0
00?o0ol04P?o2Goo0009OolF0ol00`00Oomoo`0eOol00`000ol3o`0J0ol00`00Oomoo`0IOol00`00
Oomoo`0IOol00`000ol3o`0J0ol00`00Oomoo`0eOol00`000ol3o`0C0ol9Ool000UooaL3o`03001o
ogoo03=oo`030003o`?o01`3o`03001oogoo01Qoo`03001oogoo01Uoo`030003o`?o01/3o`03001o
ogoo03Aoo`030003o`?o01<3o`Uoo`002Goo5`?o00<007ooOol0<goo00<000?o0ol070?o00<007oo
Ool067oo0P006Goo00<000?o0ol070?o00<007ooOol0<goo00<000?o0ol050?o2Goo0009OolH0ol0
0`00Oomoo`0aOol00`000ol3o`0N0ol00`00Oomoo`0GOol00`00Oomoo`0HOol00`000ol3o`0M0ol0
0`00Oomoo`0bOol00`000ol3o`0D0ol9Ool000Moo`D00083o`800143o`03001oogoo02Yoo`8000Eo
o`030003o`?o01h3o`03001oogoo01Moo`03001oogoo01Moo`030003o`?o01h3o`03001oogoo00Eo
o`8002Yoo`030003o`?o0103o`D0009oo`8000Eoo`002Goo00D000?o0ol3o`000083o`030003o`?o
00l3o`03001oogoo02Qoo`04001oogoo0003Ool00`000ol3o`0O0ol00`00Oomoo`0GOol00`00Oomo
o`0GOol00`000ol3o`0N0ol00`00Oomoo`04Ool01000Oomoo`00:Goo00<000?o0ol04P?o00D000?o
0omoo`00009oo`03001oogoo009oo`002Goo00D000?o0ol3o`000083o`030003o`?o00l3o`03001o
ogoo02]oo`05001oogooOol0000R0ol00`00Oomoo`0FOol00`00Oomoo`0FOol00`000ol3o`0P0ol0
0`00Oomoo`06Ool00`00Oomoo`0VOol00`000ol3o`0C0ol01@000ol3ogoo00000Woo00<007ooOol0
0Woo00000goo000000020004Ool01@000ol3o`?o00000P?o00<000?o0ol03`?o00<007ooOol08Woo
10000goo0P0017oo00<000?o0ol080?o00<007ooOol05Woo00<007ooOol05Woo00<000?o0ol080?o
00<007ooOol017oo0P00:Goo00<000?o0ol04`?o00D000?o0omoo`00009oo`03001oogoo009oo`00
2Goo00D000?o0ol3o`000083o`030003o`?o0103o`03001oogoo02Qoo`03001oogoo009oo`030003
o`?o0243o`03001oogoo01Ioo`03001oogoo01Eoo`030003o`?o0283o`03001oogoo00=oo`03001o
ogoo02Moo`030003o`?o01@3o`050003o`?oOol00002Ool00`00Oomoo`02Ool000Qoo`8000@3o`80
01<3o`03001oogoo02Qoo`<0009oo`030003o`?o0283o`03001oogoo01Eoo`8001Ioo`030003o`?o
0283o`03001oogoo00=oo`<002Moo`030003o`?o01<3o`800083o`9oo`8000Eoo`002Goo6`?o00<0
07ooOol0:goo00<000?o0ol08`?o00<007ooOol05Goo00<007ooOol057oo00<000?o0ol08`?o00<0
07ooOol0;7oo00<000?o0ol060?o2Goo0009OolK0ol00`00Oomoo`0[Ool00`000ol3o`0T0ol00`00
Oomoo`0DOol00`00Oomoo`0DOol00`000ol3o`0T0ol00`00Oomoo`0[Ool00`000ol3o`0H0ol9Ool0
00Uooa/3o`03001oogoo02Yoo`030003o`?o02D3o`03001oogoo01Aoo`03001oogoo01=oo`030003
o`?o02D3o`03001oogoo02]oo`030003o`?o01P3o`Uoo`002Goo70?o00<007ooOol0:Goo00<000?o
0ol09@?o00<007ooOol057oo00<007ooOol04goo00<000?o0ol09P?o00<007ooOol0:Goo00<000?o
0ol06@?o2Goo0009OolL0ol00`00Oomoo`0YOol00`000ol3o`0V0ol00`00Oomoo`0COol00`00Oomo
o`0COol00`000ol3o`0V0ol00`00Oomoo`0YOol00`000ol3o`0I0ol9Ool000Uooad3o`03001oogoo
02Moo`030003o`?o02L3o`03001oogoo01=oo`03001oogoo019oo`030003o`?o02P3o`03001oogoo
02Moo`030003o`?o01X3o`Uoo`000Wooo`007P000Goo0009Ool00`000ol3o`0:0ol00`000ol3o`0;
0ol010000ol3o`002Goo00<007ooOol02goo00<007ooOol02Woo00@007ooOol000X3o`030003o`?o
00/3o`030003o`?o00X3o`030003o`?o00<3o`03001oogoo00Eoo`03001oogoo00Qoo`040003o`00
0ol2000:Ool00`00Oomoo`03Ool00`000ol3o`040ol00`000ol3o`0;0ol00`000ol3o`0:0ol00`00
0ol3o`070ol01@00Oomoogoo000037oo00<007ooOol02goo00<007ooOol01goo00@000?o0ol000d3
o`030003o`?o00X3o`03001oogoo00Ioo`002Goo7P?o00<007ooOol09Goo00<000?o0ol0:P?o00<0
07ooOol03Goo0P000P?o00D000?o0ol3o`0000moo`030003o`?o02X3o`03001oogoo02Eoo`030003
o`?o01/3o`Uoo`002Goo7P?o00<007ooOol09Goo00<000?o0ol0:P?o00<007ooOol037oo00<000?o
0ol00P?o00D000?o0ol3o`0000ioo`030003o`?o02/3o`03001oogoo02Eoo`030003o`?o01/3o`Uo
o`002Goo7`?o00<007ooOol08goo00<000?o0ol0;0?o00<007ooOol02goo00<000?o0ol00P?o00<0
00?o0ol00P?o00<007ooOol02goo00<000?o0ol0;0?o00<007ooOol08goo00<000?o0ol070?o2Goo
0009OolO0ol00`00Oomoo`0SOol00`000ol3o`0/0ol00`00Oomoo`0;Ool00`000ol3o`020ol00`00
0ol3o`020ol00`00Oomoo`0:Ool00`000ol3o`0]0ol00`00Oomoo`0SOol00`000ol3o`0L0ol9Ool0
00Uoob03o`03001oogoo025oo`030003o`?o02h3o`03001oogoo00Uoo`030003o`?o00<3o`8000@3
o`03001oogoo00Uoo`030003o`?o02d3o`03001oogoo029oo`030003o`?o01d3o`Uoo`002Goo80?o
00<007ooOol08Goo00<000?o0ol0;P?o00<007ooOol02Goo00<000?o0ol00`?o00<000?o0ol00`?o
00<007ooOol02Goo00<000?o0ol0;P?o00<007ooOol08Goo00<000?o0ol07@?o2Goo0009OolP0ol0
0`00Oomoo`0POol00`000ol3o`0`0ol00`00Oomoo`07Ool00`000ol3o`040ol00`000ol3o`040ol0
0`00Oomoo`07Ool00`000ol3o`0_0ol00`00Oomoo`0POol00`000ol3o`0N0ol9Ool000Uoob43o`03
001oogoo01moo`030003o`?o0303o`03001oogoo00Moo`030003o`?o00@3o`030003o`?o00@3o`03
001oogoo00Moo`030003o`?o0303o`03001oogoo01moo`030003o`?o01h3o`Uoo`002Goo8@?o00<0
07ooOol07goo00<000?o0ol0<0?o00<007ooOol01Woo00<000?o0ol01@?o00<000?o0ol010?o00<0
07ooOol01Woo00<000?o0ol0<@?o00<007ooOol07goo00<000?o0ol07P?o2Goo0009OolR0ol00`00
Oomoo`0MOol00`000ol3o`0b0ol00`00Oomoo`05Ool00`000ol3o`050ol00`000ol3o`050ol00`00
Oomoo`05Ool00`000ol3o`0a0ol00`00Oomoo`0NOol00`000ol3o`0O0ol9Ool000Uoob83o`03001o
ogoo01eoo`030003o`?o0383o`03001oogoo00Eoo`030003o`?o00D3o`030003o`?o00D3o`03001o
ogoo00Aoo`030003o`?o03<3o`03001oogoo01eoo`030003o`?o01l3o`Uoo`002Goo8P?o00<007oo
Ool077oo00<000?o0ol0=0?o00<007ooOol017oo00<000?o0ol01@?o0P001P?o00<007ooOol017oo
00<000?o0ol0<`?o00<007ooOol077oo00<000?o0ol080?o2Goo0009OolS0ol00`00Oomoo`0KOol0
0`000ol3o`0d0ol00`00Oomoo`03Ool00`000ol3o`060ol00`000ol3o`060ol00`00Oomoo`03Ool0
0`000ol3o`0d0ol00`00Oomoo`0KOol00`000ol3o`0P0ol9Ool000Uoob<3o`03001oogoo01Yoo`03
0003o`?o03H3o`03001oogoo009oo`030003o`?o00H3o`030003o`?o00H3o`03001oogoo009oo`03
0003o`?o03D3o`03001oogoo01]oo`030003o`?o0203o`Uoo`002Goo90?o00<007ooOol06Goo00<0
00?o0ol0=P?o00<007ooOol00Woo00<000?o0ol01P?o00<000?o0ol01P?o00<007ooOol00Woo00<0
00?o0ol0=P?o00<007ooOol06Goo00<000?o0ol08@?o2Goo0009OolT0ol00`00Oomoo`0IOol00`00
0ol3o`0f0ol00`00Oomoo`02Ool00`000ol3o`060ol00`000ol3o`060ol01@00Oomoogoo0000>@?o
00<007ooOol06Goo00<000?o0ol08@?o2Goo0009OolU0ol00`00Oomoo`0GOol00`000ol3o`0h0ol0
1000Oomoo`002@?o00<000?o0ol01`?o00@007ooOol003X3o`03001oogoo01Qoo`030003o`?o0243
o`Uoo`002Goo9@?o00<007ooOol05goo00<000?o0ol0>0?o00@007ooOol000T3o`030003o`?o00L3
o`03001oo`0003/3o`03001oogoo01Moo`030003o`?o0283o`Uoo`002Goo9P?o00<007ooOol05Goo
00<000?o0ol0>P?o0P002P?o0P0020?o00<007oo0000?0?o00<007ooOol05Woo00<000?o0ol08P?o
2Goo0009OolV0ol00`00Oomoo`0EOol00`000ol3o`0j0ol2000:0ol00`000ol3o`080ol00`000ol3
o`0k0ol00`00Oomoo`0EOol00`000ol3o`0S0ol9Ool000UoobL3o`03001oogoo01=oo`030003o`?o
03`3o`030003o`?o00P3o`030003o`?o00P3o`030003o`?o03`3o`03001oogoo01Aoo`030003o`?o
02<3o`Uoo`002Goo9`?o00<007ooOol04goo00<000?o0ol0?0?o0P002@?o00<000?o0ol020?o00<0
00?o0ol0?@?o00<007ooOol04Woo00<000?o0ol090?o2Goo0009OolX0ol00`00Oomoo`0AOol00`00
0ol3o`0l0ol00`00Ool000090ol00`000ol3o`070ol2000o0ol00`00Oomoo`0BOol00`000ol3o`0T
0ol9Ool000UoobP3o`03001oogoo015oo`030003o`?o03`3o`04001oogoo00080ol00`000ol3o`07
0ol00`00Ool0000o0ol00`00Oomoo`0@Ool00`000ol3o`0U0ol9Ool000UoobT3o`03001oogoo00mo
o`030003o`?o03d3o`04001oogoo00080ol00`000ol3o`060ol01000Oomoo`00?`?o00<007ooOol0
47oo00<000?o0ol09@?o2Goo0009OolZ0ol00`00Oomoo`0=Ool00`000ol3o`0n0ol01@00Oomoogoo
00001`?o0P001`?o00@007ooOol00403o`03001oogoo00ioo`030003o`?o02H3o`Uoo`002Goo:P?o
00<007ooOol037oo00<000?o0ol0?P?o00<007ooOol00Woo00<000?o0ol01@?o00<000?o0ol01@?o
00D007ooOomoo`000443o`03001oogoo00aoo`030003o`?o02L3o`Uoo`002Goo:`?o00<007ooOol0
2goo00<000?o0ol0?P?o00<007ooOol00goo00<000?o0ol010?o00<000?o0ol010?o00<007ooOol0
0goo00<000?o0ol0?P?o00<007ooOol02goo00<000?o0ol0:0?o2Goo0009Ool/0ol00`00Oomoo`09
Ool00`000ol3o`0o0ol00`00Oomoo`04Ool00`000ol3o`030ol00`000ol3o`030ol00`00Oomoo`04
Ool00`000ol3o`0o0ol00`00Oomoo`09Ool00`000ol3o`0Y0ol9Ool000Uoobd3o`8000Qoo`030003
o`?o0403o`03001oogoo009oo`D000<3o`030003o`?o00<3o`03001oogoo00Aoo`030003o`?o0403
o`03001oogoo00Moo`030003o`?o02X3o`Uoo`002Goo;`?o00<007ooOol00goo0P00@P?o00<007oo
Ool01Goo00@007oo00000083o`030003o`?o00<000Moo`030003o`?o0443o`8000Eoo`8002d3o`Uo
o`002Goo<0?o1@00A0?o00<007ooOol01Goo00@007ooOomoo`D000]oo`030003o`?o0443o`L002h3
o`Uoo`002GooN@?o00<007ooOol01Goo00<007ooOol00goo00<007ooOol02goo00<000?o0ol0MP?o
2Goo0009Oomi0ol00`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`0;Ool00`000ol3o`1f0ol9
Ool000UoogT3o`03001oogoo00Aoo`8000Eoo`03001oogoo00]oo`030003o`?o07H3o`Uoo`002Goo
N@?o00<007ooOol02goo00<007ooOol02goo00<000?o0ol0MP?o2Goo0009Oomh0ol00`00Oomoo`0<
Ool00`00Oomoo`0;Ool00`000ol3o`1f0ol9Ool000UoogP3o`03001oogoo00aoo`03001oogoo00ao
o`030003o`?o07D3o`Uoo`002GooN0?o00<007ooOol037oo0P003Goo00<000?o0ol0M@?o2Goo0009
Oomh0ol00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`000ol3o`1e0ol9Ool000UoogP3o`03001oogoo
00aoo`03001oogoo00aoo`030003o`?o07D3o`Uoo`002GooN0?o00<007ooOol037oo00<007ooOol0
37oo00<000?o0ol0M@?o2Goo0009Oomh0ol00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`000ol3o`1e
0ol9Ool000UoogL3o`03001oogoo00eoo`03001oogoo00eoo`030003o`?o07@3o`Uoo`002GooM`?o
00<007ooOol03Goo00<007ooOol03Goo00<000?o0ol0M0?o2Goo0009Oomg0ol00`00Oomoo`0=Ool2
000>Ool00`000ol3o`1d0ol9Ool000UoogL3o`03001oogoo00eoo`03001oogoo00eoo`030003o`?o
07@3o`Uoo`002GooM`?o00<007ooOol03Goo00<007ooOol03Goo00<000?o0ol0M0?o2Goo0009Oomg
0ol00`00Oomoo`0=Ool00`00Oomoo`0=Ool00`000ol3o`1d0ol9Ool000UoogL3o`03001oogoo00eo
o`03001oogoo00ioo`030003o`?o07<3o`Uoo`002GooMP?o00<007ooOol03Woo00<007ooOol03Woo
00<000?o0ol0L`?o2Goo0009Oomf0ol00`00Oomoo`0>Ool2000?Ool00`000ol3o`1c0ol9Ool000Uo
ogH3o`03001oogoo00ioo`03001oogoo00ioo`030003o`?o07<3o`Uoo`002GooMP?o00<007ooOol0
3Woo00<007ooOol03Woo00<000?o0ol0L`?o2Goo0009Oomf0ol00`00Oomoo`0>Ool00`00Oomoo`0>
Ool00`000ol3o`1c0ol9Ool000UoogH3o`03001oogoo00ioo`03001oogoo00moo`030003o`?o0783
o`Uoo`002GooMP?o00<007ooOol03Woo00<007ooOol03goo00<000?o0ol0LP?o2Goo0009Oome0ol0
0`00Oomoo`0?Ool00`00Oomoo`0?Ool00`000ol3o`1b0ol9Ool000UoogD3o`03001oogoo00moo`80
011oo`030003o`?o0783o`Uoo`002GooM@?o00<007ooOol03goo00<007ooOol03goo00<000?o0ol0
LP?o2Goo0009Oome0ol00`00Oomoo`0?Ool00`00Oomoo`0?Ool00`000ol3o`1b0ol9Ool000UoogD3
o`03001oogoo00moo`03001oogoo00moo`030003o`?o0783o`Uoo`002GooM@?o00<007ooOol03goo
00<007ooOol047oo00<000?o0ol0L@?o2Goo0009Oome0ol00`00Oomoo`07Ool40004Ool00`00Oomo
o`0@Ool00`000ol3o`1a0ol9Ool000Uoog@3o`03001oogoo00Qoo`03001oogoo00Eoo`03001oogoo
011oo`030003o`?o0743o`Uoo`002GooM0?o00<007ooOol02Goo00<007ooOol017oo0`0047oo00<0
00?o0ol0L@?o2Goo0009Oomd0ol00`00Oomoo`0:Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00
0ol3o`1a0ol9Ool000Uoog@3o`03001oogoo00Qoo`04001oogoo0004Ool00`00Oomoo`0@Ool00`00
0ol3o`1a0ol9Ool000Uoog@3o`03001oogoo00Uoo`8000Eoo`03001oogoo011oo`030003o`?o0743
o`Uoo`002GooM0?o00<007ooOol047oo00<007ooOol04Goo00<000?o0ol0L0?o2Goo0009Oomc0ol0
0`00Oomoo`0AOol00`00Oomoo`0AOol00`000ol3o`1`0ol9Ool000Uoog<3o`03001oogoo015oo`03
001oogoo015oo`030003o`?o0703o`Uoo`002GooL`?o00<007ooOol04Goo0P004Woo00<000?o0ol0
L0?o2Goo0009Oomc0ol00`00Oomoo`0AOol00`00Oomoo`0AOol00`000ol3o`1`0ol9Ool000Uoog<3
o`03001oogoo015oo`03001oogoo015oo`030003o`?o0703o`Uoo`002GooL`?o00<007ooOol04Goo
00<007ooOol04Goo00<000?o0ol0L0?o2Goo0009Oomc0ol00`00Oomoo`0AOol00`00Oomoo`0BOol0
0`000ol3o`1_0ol9Ool000Uoog83o`03001oogoo019oo`03001oogoo019oo`030003o`?o06l3o`Uo
o`002GooLP?o00<007ooOol04Woo0P004goo00<000?o0ol0K`?o2Goo0009Oomb0ol00`00Oomoo`0B
Ool00`00Oomoo`0BOol00`000ol3o`1_0ol9Ool000Uoog83o`03001oogoo019oo`03001oogoo019o
o`030003o`?o06l3o`Uoo`002GooLP?o00<007ooOol04Woo00<007ooOol04Woo00<000?o0ol0K`?o
2Goo0009Oomb0ol00`00Oomoo`0BOol00`00Oomoo`0BOol00`000ol3o`1_0ol9Ool000Uoog83o`03
001oogoo019oo`03001oogoo01=oo`030003o`?o06h3o`Uoo`002GooL@?o00<007ooOol04goo00<0
07ooOol04goo00<000?o0ol0KP?o2Goo0009Ooma0ol00`00Oomoo`0COol2000DOol00`000ol3o`1^
0ol9Ool000Uoog43o`03001oogoo01=oo`03001oogoo01=oo`030003o`?o06h3o`Uoo`002GooL@?o
00<007ooOol04goo00<007ooOol04goo00<000?o0ol0KP?o2Goo0009Ooma0ol00`00Oomoo`0COol0
0`00Oomoo`0COol00`000ol3o`1^0ol9Ool000Uoog43o`03001oogoo01=oo`03001oogoo01=oo`03
0003o`?o06h3o`Uoo`002GooL@?o00<007ooOol04goo00<007ooOol057oo00<000?o0ol0K@?o2Goo
0009Ooma0ol00`00Oomoo`0COol00`00Oomoo`0DOol00`000ol3o`1]0ol9Ool000Uoog03o`03001o
ogoo01Aoo`8001Eoo`030003o`?o06d3o`Uoo`002GooL0?o00<007ooOol057oo00<007ooOol057oo
00<000?o0ol0K@?o2Goo0009Oom`0ol00`00Oomoo`0DOol00`00Oomoo`0DOol00`000ol3o`1]0ol9
Ool000Uoog03o`03001oogoo01Aoo`03001oogoo01Aoo`030003o`?o06d3o`Uoo`002GooL0?o00<0
07ooOol03Goo0P001Goo00<007ooOol057oo00<000?o0ol0K@?o2Goo0009Oom`0ol00`00Oomoo`0<
Ool01000Oomoo`0017oo00<007ooOol057oo00<000?o0ol0K@?o2Goo0009Oom`0ol00`00Oomoo`0>
Ool00`00Oomoo`03Ool3000DOol00`000ol3o`1]0ol9Ool000Uoog03o`03001oogoo00moo`03001o
ogoo009oo`03001oogoo01Eoo`030003o`?o06`3o`Uoo`002GooL0?o00<007ooOol037oo00@007oo
Ool000Aoo`03001oogoo01Eoo`030003o`?o06`3o`Uoo`002GooL0?o00<007ooOol03Goo0P001Goo
00<007ooOol05Goo00<000?o0ol0K0?o2Goo0009Oom_0ol00`00Oomoo`0EOol00`00Oomoo`0EOol0
0`000ol3o`1/0ol9Ool000Uoofl3o`03001oogoo01Eoo`03001oogoo01Eoo`030003o`?o06`3o`Uo
o`002GooK`?o00<007ooOol05Goo00<007ooOol05Goo00<000?o0ol0K0?o2Goo0009Oom_0ol00`00
Oomoo`0EOol2000FOol00`000ol3o`1/0ol9Ool000Uoofl3o`03001oogoo01Eoo`03001oogoo01Eo
o`030003o`?o06`3o`Uoo`002GooK`?o00<007ooOol05Goo00<007ooOol05Goo00<000?o0ol0K0?o
2Goo0009Oom_0ol00`00Oomoo`0EOol00`00Oomoo`0EOol00`000ol3o`1/0ol9Ool000Uoofl3o`03
001oogoo01Eoo`03001oogoo01Ioo`030003o`?o06/3o`Uoo`002GooK`?o00<007ooOol05Goo00<0
07ooOol05Woo00<000?o0ol0J`?o2Goo0009Oom^0ol00`00Oomoo`0FOol00`00Oomoo`0FOol00`00
0ol3o`1[0ol9Ool000Uoofh3o`03001oogoo01Ioo`8001Moo`030003o`?o06/3o`Uoo`002GooKP?o
00<007ooOol05Woo00<007ooOol05Woo00<000?o0ol0J`?o2Goo0009Oom^0ol00`00Oomoo`0FOol0
0`00Oomoo`0FOol00`000ol3o`1[0ol9Ool000Uoofh3o`03001oogoo01Ioo`03001oogoo01Ioo`03
0003o`?o06/3o`Uoo`002GooKP?o00<007ooOol05Woo00<007ooOol05Woo00<000?o0ol0J`?o2Goo
0009Oom^0ol00`00Oomoo`0FOol00`00Oomoo`0FOol00`000ol3o`1[0ol9Ool000Uoofh3o`03001o
ogoo01Ioo`03001oogoo01Ioo`030003o`?o06/3o`Uoo`002GooKP?o00<007ooOol05Woo0P005goo
00<000?o0ol0J`?o2Goo0009Oom^0ol00`00Oomoo`0FOol00`00Oomoo`0GOol00`000ol3o`1Z0ol9
Ool000Uoofd3o`03001oogoo01Moo`03001oogoo01Moo`030003o`?o06X3o`Uoo`002GooK@?o00<0
07ooOol05goo00<007ooOol05goo00<000?o0ol0JP?o2Goo0009Oom]0ol00`00Oomoo`0GOol00`00
Oomoo`0GOol00`000ol3o`1Z0ol9Ool000Uoofd3o`03001oogoo01Moo`03001oogoo01Moo`030003
o`?o06X3o`Uoo`002GooK@?o00<007ooOol05goo0P0067oo00<000?o0ol0JP?o2Goo0009Oom]0ol0
0`00Oomoo`0GOol00`00Oomoo`0GOol00`000ol3o`1Z0ol9Ool000Uoofd3o`03001oogoo01Moo`03
001oogoo01Moo`030003o`?o06X3o`Uoo`002GooK@?o00<007ooOol05goo00<007ooOol05goo00<0
00?o0ol0JP?o2Goo0009Oom]0ol00`00Oomoo`0GOol00`00Oomoo`0GOol00`00Ool3o`1Z0ol9Ool0
00Uoofd3o`03001oogoo015oo`<000=oo`03001oogoo01Qoo`030003o`?o06T3o`Uoo`002GooK0?o
00<007ooOol04goo00<007ooOol00Woo00<007ooOol067oo00<000?o0ol0J@?o2Goo0009Oom/0ol0
0`00Oomoo`0@Ool50003Ool3000HOol00`000ol3o`1Y0ol9Ool000Uoof`3o`03001oogoo011oo`04
001oogoo0004Ool00`00Oomoo`0HOol00`000ol3o`1Y0ol9Ool000Uoof`3o`03001oogoo015oo`03
001oo`0000Aoo`03001oogoo01Qoo`030003o`?o06T3o`Uoo`002GooK0?o00<007ooOol04Woo0P00
17oo00<007ooOol067oo00<000?o0ol0J@?o2Goo0009Oom/0olgOom[0ol9Ool00001\
\>"],
  ImageRangeCache->{{{80.0625, 367.062}, {461.312, 284.375}} -> {-0.280896, \
1.60721, 0.00349296, 0.00565173}, {{80.375, 366.688}, {461.312, 284.375}} -> \
{-16.6071, 7.33574, 0.0739244, 0.0297884}},
  CellTags->{"Shadowing Conflicts", "UsingAddOns"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[23]=",
  CellTags->{"Shadowing Conflicts", "UsingAddOns"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Installing New Add-ons", "Section",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],

Cell[CellGroupData[{

Cell["Installation locations", "Subsection",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],

Cell[TextData[{
  "Add-ons that are not part of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution are typically installed in the directory specified by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " global variable $",
  StyleBox["BaseDirectory", "MR"],
  ". Add-ons intended for one particular user are typically located in the \
user-specific directory specified by $",
  StyleBox["UserBaseDirectory", "MR"],
  ". To see the exact location for either of these directories, evaluate $",
  StyleBox["BaseDirectory", "MR"],
  " or $",
  StyleBox["UserBaseDirectory", "MR"],
  ". See ",
  ButtonBox["A.8.1",
    ButtonData:>{"A.8.1"},
    ButtonStyle->"MainBookLink"],
  " for more information."
}], "Text",
  CellTags->{"InstallingAddOns", "Installing", "AddOnInstall"}],

Cell[TextData[{
  "Add-ons can be installed in either the Applications or Autoload \
subdirectories of $",
  StyleBox["BaseDirectory", "MR"],
  " or $",
  StyleBox["UserBaseDirectory", "MR"],
  ". Add-ons installed in the Autoload subdirectory are automatically loaded \
when the front end and kernel are started (see ",
  ButtonBox["Autoloaded Add-ons",
    ButtonData:>{"Installing New Add-ons", "AutoloadedAddOns"},
    ButtonStyle->"AddOnsLinkText"],
  "). Add-ons installed in the Applications subdirectory can be loaded \
manually when needed (see ",
  ButtonBox["Using Add-ons",
    ButtonData:>"Using Add-ons",
    ButtonStyle->"AddOnsLinkText"],
  ")."
}], "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall", "UsingAddOns"}],

Cell[TextData[{
  "If an add-on is installed in $",
  StyleBox["BaseDirectory", "MR"],
  ", the application is available to all users. If it is installed in $",
  StyleBox["UserBaseDirectory", "MR"],
  ", the application is available only to that user."
}], "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Installing An Add-on", "Subsection",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],

Cell[TextData[{
  "To install an add-on, copy it into either the Applications or Autoload \
subdirectories of $",
  StyleBox["BaseDirectory", "MR"],
  " or $",
  StyleBox["UserBaseDirectory", "MR"],
  ". If it came as an installer archive, it should come with instructions on \
unpacking the files. Otherwise, you can simply copy the add-on directory as \
you would any other directory."
}], "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],

Cell[TextData[{
  "After installing the files, use the ",
  StyleBox["Rebuild Help Index",
    FontFamily->"Arial"],
  " command in the ",
  StyleBox["Help",
    FontFamily->"Arial"],
  " menu. This tells the front end to add any help files that the add-on may \
contain and to incorporate them into the Help Browser's categories and index. \
These files will be then accessible in the Add-ons section of the Help \
Browser. Open the Help Browser and click the Add-ons button. The add-on's \
help files will be listed under the add-on's name at the bottom of the \
left-hand column."
}], "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Autoloaded Add-ons", "Subsection",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],

Cell["\<\
Add-ons installed in the Autoload subdirectory will be loaded \
automatically on startup by both the kernel and the front end.\
\>", "Text",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],

Cell["\<\
Ordinarily a package will declare one or more functions in the \
kernel. In order to save time and memory on startup, these functions are \
usually declared as function stubs; the full package is loaded when one of \
the functions is used for the first time.\
\>", "Text",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],

Cell["\<\
An add-on may also install new menu items or evaluators in the \
front end, or reset configuration options in the front end. Check the \
documentation for the add-on to find out about any changes it makes to the \
front end.\
\>", "Text",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Installing pre-3.0 Packages", "Subsection",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],

Cell[TextData[{
  "If the add-on you are installing is not optimized for Version 3 or later, \
the Help Browser will not be able to display its help files, but you can \
still open the help files manually by using the ",
  StyleBox["Open",
    FontFamily->"Arial"],
  " menu command in the ordinary way."
}], "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],

Cell["\<\
If the add-on does not contain the files necessary for it to be \
autoloaded, it makes no difference whether it is installed in the \
Applications or Autoload subdirectory.\
\>", "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1152}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{578, 654},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Installing"->{
    Cell[1776, 53, 85, 1, 61, "Section",
      CellTags->{"Installing", "AddOnsIntro"}],
    Cell[1864, 56, 485, 13, 56, "Text",
      CellTags->{"Installing", "AddOnsIntro"}],
    Cell[2352, 71, 624, 21, 56, "Text",
      CellTags->{"Installing", "AddOnsIntro"}],
    Cell[2979, 94, 901, 24, 88, "Text",
      CellTags->{"Installing", "AddOnsIntro"}],
    Cell[3917, 123, 95, 1, 35, "Section",
      CellTags->{"Installing", "UsingAddOns", "InstallingAddOns"}],
    Cell[4106, 131, 1131, 26, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5240, 159, 308, 9, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5551, 170, 136, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5690, 175, 257, 5, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5950, 182, 725, 22, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[6700, 208, 105, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[8200, 246, 333, 10, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[8558, 260, 203, 5, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[92502, 2618, 412, 12, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[92917, 2632, 126, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[93492, 2651, 109, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[93604, 2656, 185, 4, 70, "Output",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[94229, 2678, 107, 1, 70, "Subsection",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94339, 2681, 411, 9, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94775, 2694, 171, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94949, 2699, 164, 3, 70, "Output",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[95128, 2705, 879, 26, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96010, 2733, 157, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96170, 2738, 259, 7, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96432, 2747, 142, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96577, 2752, 253, 8, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96855, 2764, 175, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[131723, 4164, 105, 1, 35, "Section",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[131853, 4169, 108, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[131964, 4172, 809, 22, 88, "Text",
      CellTags->{"InstallingAddOns", "Installing", "AddOnInstall"}],
    Cell[132776, 4196, 752, 18, 72, "Text",
      CellTags->{
      "Installing", "InstallingAddOns", "AddOnInstall", "UsingAddOns"}],
    Cell[133531, 4216, 329, 7, 40, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[133897, 4228, 106, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[134006, 4231, 463, 10, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[134472, 4243, 659, 14, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[135168, 4262, 127, 2, 36, "Subsection",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135298, 4266, 237, 5, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135538, 4273, 369, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135910, 4282, 335, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[136282, 4294, 113, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[136398, 4297, 380, 8, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[136781, 4307, 260, 5, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]},
  "AddOnsIntro"->{
    Cell[1776, 53, 85, 1, 61, "Section",
      CellTags->{"Installing", "AddOnsIntro"}],
    Cell[1864, 56, 485, 13, 56, "Text",
      CellTags->{"Installing", "AddOnsIntro"}],
    Cell[2352, 71, 624, 21, 56, "Text",
      CellTags->{"Installing", "AddOnsIntro"}],
    Cell[2979, 94, 901, 24, 88, "Text",
      CellTags->{"Installing", "AddOnsIntro"}]},
  "UsingAddOns"->{
    Cell[3917, 123, 95, 1, 35, "Section",
      CellTags->{"Installing", "UsingAddOns", "InstallingAddOns"}],
    Cell[4037, 128, 66, 1, 70, "Subsection",
      CellTags->"UsingAddOns"],
    Cell[4106, 131, 1131, 26, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5240, 159, 308, 9, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5551, 170, 136, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5690, 175, 257, 5, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[5950, 182, 725, 22, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[6700, 208, 105, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[8200, 246, 333, 10, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[8558, 260, 203, 5, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[92502, 2618, 412, 12, 70, "Text",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[92917, 2632, 126, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[93046, 2637, 421, 10, 70, "Text",
      CellTags->"UsingAddOns"],
    Cell[93492, 2651, 109, 3, 70, "Input",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[93604, 2656, 185, 4, 70, "Output",
      CellTags->{"Installing", "UsingAddOns"}],
    Cell[94229, 2678, 107, 1, 70, "Subsection",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94339, 2681, 411, 9, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94775, 2694, 171, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94949, 2699, 164, 3, 70, "Output",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[95128, 2705, 879, 26, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96010, 2733, 157, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96170, 2738, 259, 7, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96432, 2747, 142, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96577, 2752, 253, 8, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96855, 2764, 175, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[97033, 2769, 34419, 1381, 70, 17155, 1163, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Shadowing Conflicts", "UsingAddOns"}],
    Cell[131455, 4152, 207, 5, 70, "Output",
      CellTags->{"Shadowing Conflicts", "UsingAddOns"}],
    Cell[132776, 4196, 752, 18, 72, "Text",
      CellTags->{
      "Installing", "InstallingAddOns", "AddOnInstall", "UsingAddOns"}]},
  "InstallingAddOns"->{
    Cell[3917, 123, 95, 1, 35, "Section",
      CellTags->{"Installing", "UsingAddOns", "InstallingAddOns"}],
    Cell[131723, 4164, 105, 1, 35, "Section",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[131853, 4169, 108, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[131964, 4172, 809, 22, 88, "Text",
      CellTags->{"InstallingAddOns", "Installing", "AddOnInstall"}],
    Cell[132776, 4196, 752, 18, 72, "Text",
      CellTags->{
      "Installing", "InstallingAddOns", "AddOnInstall", "UsingAddOns"}],
    Cell[133531, 4216, 329, 7, 40, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[133897, 4228, 106, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[134006, 4231, 463, 10, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[134472, 4243, 659, 14, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[135168, 4262, 127, 2, 36, "Subsection",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135298, 4266, 237, 5, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135538, 4273, 369, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135910, 4282, 335, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[136282, 4294, 113, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[136398, 4297, 380, 8, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[136781, 4307, 260, 5, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]},
  "Shadowing Conflicts"->{
    Cell[94229, 2678, 107, 1, 70, "Subsection",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94339, 2681, 411, 9, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94775, 2694, 171, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[94949, 2699, 164, 3, 70, "Output",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[95128, 2705, 879, 26, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96010, 2733, 157, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96170, 2738, 259, 7, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96432, 2747, 142, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96577, 2752, 253, 8, 70, "Text",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[96855, 2764, 175, 3, 70, "Input",
      CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
    Cell[97033, 2769, 34419, 1381, 70, 17155, 1163, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Shadowing Conflicts", "UsingAddOns"}],
    Cell[131455, 4152, 207, 5, 70, "Output",
      CellTags->{"Shadowing Conflicts", "UsingAddOns"}]},
  "AddOnInstall"->{
    Cell[131723, 4164, 105, 1, 35, "Section",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[131853, 4169, 108, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[131964, 4172, 809, 22, 88, "Text",
      CellTags->{"InstallingAddOns", "Installing", "AddOnInstall"}],
    Cell[132776, 4196, 752, 18, 72, "Text",
      CellTags->{
      "Installing", "InstallingAddOns", "AddOnInstall", "UsingAddOns"}],
    Cell[133531, 4216, 329, 7, 40, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[133897, 4228, 106, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[134006, 4231, 463, 10, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[134472, 4243, 659, 14, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[135168, 4262, 127, 2, 36, "Subsection",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135298, 4266, 237, 5, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135538, 4273, 369, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135910, 4282, 335, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[136282, 4294, 113, 1, 36, "Subsection",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[136398, 4297, 380, 8, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
    Cell[136781, 4307, 260, 5, 70, "Text",
      CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]},
  "AutoloadedAddOns"->{
    Cell[135168, 4262, 127, 2, 36, "Subsection",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135298, 4266, 237, 5, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135538, 4273, 369, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
    Cell[135910, 4282, 335, 7, 70, "Text",
      CellTags->{
      "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Installing", 137809, 4336},
  {"AddOnsIntro", 142352, 4426},
  {"UsingAddOns", 142725, 4435},
  {"InstallingAddOns", 145624, 4494},
  {"Shadowing Conflicts", 147603, 4532},
  {"AddOnInstall", 149025, 4558},
  {"AutoloadedAddOns", 150891, 4594}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 85, 1, 61, "Section",
  CellTags->{"Installing", "AddOnsIntro"}],
Cell[1864, 56, 485, 13, 56, "Text",
  CellTags->{"Installing", "AddOnsIntro"}],
Cell[2352, 71, 624, 21, 56, "Text",
  CellTags->{"Installing", "AddOnsIntro"}],
Cell[2979, 94, 901, 24, 88, "Text",
  CellTags->{"Installing", "AddOnsIntro"}]
}, Closed]],

Cell[CellGroupData[{
Cell[3917, 123, 95, 1, 35, "Section",
  CellTags->{"Installing", "UsingAddOns", "InstallingAddOns"}],

Cell[CellGroupData[{
Cell[4037, 128, 66, 1, 70, "Subsection",
  CellTags->"UsingAddOns"],
Cell[4106, 131, 1131, 26, 70, "Text",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[5240, 159, 308, 9, 70, "Text",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[5551, 170, 136, 3, 70, "Input",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[5690, 175, 257, 5, 70, "Text",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[5950, 182, 725, 22, 70, "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[CellGroupData[{
Cell[6700, 208, 105, 3, 70, "Input",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[6808, 213, 1377, 30, 70, "Output"]
}, Closed]],
Cell[8200, 246, 333, 10, 70, "Text",
  CellTags->{"Installing", "UsingAddOns"}],

Cell[CellGroupData[{
Cell[8558, 260, 203, 5, 70, "Input",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[8764, 267, 83564, 2342, 70, 32551, 1707, "GraphicsData", "PostScript", \
"Graphics"],
Cell[92331, 2611, 156, 4, 70, "Output"]
}, Closed]],
Cell[92502, 2618, 412, 12, 70, "Text",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[92917, 2632, 126, 3, 70, "Input",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[93046, 2637, 421, 10, 70, "Text",
  CellTags->"UsingAddOns"],

Cell[CellGroupData[{
Cell[93492, 2651, 109, 3, 70, "Input",
  CellTags->{"Installing", "UsingAddOns"}],
Cell[93604, 2656, 185, 4, 70, "Output",
  CellTags->{"Installing", "UsingAddOns"}]
}, Closed]],
Cell[93804, 2663, 388, 10, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[94229, 2678, 107, 1, 70, "Subsection",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
Cell[94339, 2681, 411, 9, 70, "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[CellGroupData[{
Cell[94775, 2694, 171, 3, 70, "Input",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
Cell[94949, 2699, 164, 3, 70, "Output",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}]
}, Closed]],
Cell[95128, 2705, 879, 26, 70, "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
Cell[96010, 2733, 157, 3, 70, "Input",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
Cell[96170, 2738, 259, 7, 70, "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
Cell[96432, 2747, 142, 3, 70, "Input",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
Cell[96577, 2752, 253, 8, 70, "Text",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],

Cell[CellGroupData[{
Cell[96855, 2764, 175, 3, 70, "Input",
  CellTags->{"Installing", "Shadowing Conflicts", "UsingAddOns"}],
Cell[97033, 2769, 34419, 1381, 70, 17155, 1163, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"Shadowing Conflicts", "UsingAddOns"}],
Cell[131455, 4152, 207, 5, 70, "Output",
  CellTags->{"Shadowing Conflicts", "UsingAddOns"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[131723, 4164, 105, 1, 35, "Section",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],

Cell[CellGroupData[{
Cell[131853, 4169, 108, 1, 36, "Subsection",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
Cell[131964, 4172, 809, 22, 88, "Text",
  CellTags->{"InstallingAddOns", "Installing", "AddOnInstall"}],
Cell[132776, 4196, 752, 18, 72, "Text",
  CellTags->{
  "Installing", "InstallingAddOns", "AddOnInstall", "UsingAddOns"}],
Cell[133531, 4216, 329, 7, 40, "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]
}, Closed]],

Cell[CellGroupData[{
Cell[133897, 4228, 106, 1, 36, "Subsection",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
Cell[134006, 4231, 463, 10, 70, "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
Cell[134472, 4243, 659, 14, 70, "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]
}, Closed]],

Cell[CellGroupData[{
Cell[135168, 4262, 127, 2, 36, "Subsection",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
Cell[135298, 4266, 237, 5, 70, "Text",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
Cell[135538, 4273, 369, 7, 70, "Text",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}],
Cell[135910, 4282, 335, 7, 70, "Text",
  CellTags->{
  "Installing", "AutoloadedAddOns", "InstallingAddOns", "AddOnInstall"}]
}, Closed]],

Cell[CellGroupData[{
Cell[136282, 4294, 113, 1, 36, "Subsection",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
Cell[136398, 4297, 380, 8, 70, "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}],
Cell[136781, 4307, 260, 5, 70, "Text",
  CellTags->{"Installing", "InstallingAddOns", "AddOnInstall"}]
}, Closed]]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

