(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5232,        171]*)
(*NotebookOutlinePosition[      7054,        232]*)
(*  CellTagsIndexPosition[      6935,        224]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Using the Standard ",
  StyleBox["Mathematica", "SBO"],
  " Packages"
}], "Subsection",
  CellTags->"S5.0.2"],

Cell[TextData[{
  "If you want to use a function from a particular package, you must first \
read the package into ",
  StyleBox["Mathematica", "TI"],
  ". After you have loaded the package, you can use the function in the same \
way you use a built\[Hyphen]in function. "
}], "Text",
  CellTags->{"S5.0.2", "5.0.5"}],

Cell[BoxData[
    FormBox[
      StyleBox[
        FrameBox[
          AdjustmentBox[
            StyleBox[GridBox[{
                 
                   {"\<\"\\!\\(\\*StyleBox[\\\"<<\\\", \
\\\"MR\\\"]\\)\\!\\(\\*StyleBox[\\\"name\\\", \\\"TI\\\"]\\) \"\>", 
                    "\<\"read in a \\!\\(\\*StyleBox[\\\"Mathematica\\\", \
\\\"TI\\\"]\\) package \"\>"}
                  },
                ColumnAlignments->{Right, Left}],
              GridBoxOptions->{RowLines->False}],
            BoxMargins->{{1, 1}, {1, 1}}]],
        "2ColumnBox"], TraditionalForm]], "Text",
  CellTags->"S5.0.2"],

Cell[TextData[{
  "Reading in ",
  StyleBox["Mathematica", "SO"],
  " packages. "
}], "Caption",
  CellTags->"S5.0.2"],

Cell[TextData[{
  "This command reads in a ",
  StyleBox["Mathematica", "TI"],
  " package that contains various combinatorial functions. "
}], "MathCaption",
  CellTags->"S5.0.2"],

Cell["<<DiscreteMath`CombinatorialFunctions`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S5.0.2"],

Cell[TextData[{
  "The ",
  StyleBox["Subfactorial", "MR"],
  " function is defined in the package. "
}], "MathCaption",
  CellTags->"S5.0.2"],

Cell[CellGroupData[{

Cell["Subfactorial[10]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S5.0.2"],

Cell[BoxData[
    \(1334961\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S5.0.2"]
}, Open  ]],

Cell[TextData[{
  "There are a number of subtleties associated with such issues as conflicts \
between the names of functions in different packages. These are briefly \
discussed below and in more detail in ",
  StyleBox["The",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Book",
    FontSlant->"Italic"],
  ". One important point to note, however, is that you must not refer to a \
function that you will read from a package before actually reading in the \
package. If you do this by mistake, you will have to execute the command ",
  StyleBox["Remove[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " to get rid of the function before you read in the package that defines \
it. If you do not call ",
  StyleBox["Remove", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will use \"your\" version of the function, rather than the one from the \
package. "
}], "Text",
  CellTags->{"S5.0.2", "5.0.9"}],

Cell[BoxData[
    FormBox[
      StyleBox[
        FrameBox[
          AdjustmentBox[
            StyleBox[GridBox[{
                 
                   {"\<\"\\!\\(\\*StyleBox[\\\"Remove[\\\", \\\"MR\\\"]\\)\\!\
\\(\\*StyleBox[\\\"s\\\", \\\"TI\\\"]\\)\\!\\(\\*StyleBox[\\\"]\\\", \\\"MR\\\
\"]\\) \"\>", \("remove a symbol completely from the system "\)}
                  },
                ColumnAlignments->{Right, Left}],
              GridBoxOptions->{RowLines->False}],
            BoxMargins->{{1, 1}, {1, 1}}]],
        "2ColumnBox"], TraditionalForm]], "Text",
  CellTags->"S5.0.2"],

Cell[TextData[{
  "Clearing and removing symbols in ",
  StyleBox["Mathematica", "SO"],
  "."
}], "Caption",
  CellTags->"S5.0.2"]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{207, Automatic}, {48, Automatic}},
Visible->True,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.0.2"->{
    Cell[1717, 49, 128, 5, 40, "Subsection",
      CellTags->"S5.0.2"],
    Cell[1848, 56, 317, 7, 56, "Text",
      CellTags->{"S5.0.2", "5.0.5"}],
    Cell[2168, 65, 603, 16, 55, "Text",
      CellTags->"S5.0.2"],
    Cell[2774, 83, 118, 5, 17, "Caption",
      CellTags->"S5.0.2"],
    Cell[2895, 90, 180, 5, 46, "MathCaption",
      CellTags->"S5.0.2"],
    Cell[3078, 97, 102, 2, 28, "Input",
      CellTags->"S5.0.2"],
    Cell[3183, 101, 142, 5, 30, "MathCaption",
      CellTags->"S5.0.2"],
    Cell[3350, 110, 80, 2, 28, "Input",
      CellTags->"S5.0.2"],
    Cell[3433, 114, 88, 3, 21, "Output",
      CellTags->"S5.0.2"],
    Cell[3536, 120, 962, 25, 120, "Text",
      CellTags->{"S5.0.2", "5.0.9"}],
    Cell[4501, 147, 594, 15, 55, "Text",
      CellTags->"S5.0.2"],
    Cell[5098, 164, 130, 5, 17, "Caption",
      CellTags->"S5.0.2"]},
  "5.0.5"->{
    Cell[1848, 56, 317, 7, 56, "Text",
      CellTags->{"S5.0.2", "5.0.5"}]},
  "5.0.9"->{
    Cell[3536, 120, 962, 25, 120, "Text",
      CellTags->{"S5.0.2", "5.0.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.0.2", 5872, 189},
  {"5.0.5", 6738, 214},
  {"5.0.9", 6829, 217}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 128, 5, 40, "Subsection",
  CellTags->"S5.0.2"],
Cell[1848, 56, 317, 7, 56, "Text",
  CellTags->{"S5.0.2", "5.0.5"}],
Cell[2168, 65, 603, 16, 55, "Text",
  CellTags->"S5.0.2"],
Cell[2774, 83, 118, 5, 17, "Caption",
  CellTags->"S5.0.2"],
Cell[2895, 90, 180, 5, 46, "MathCaption",
  CellTags->"S5.0.2"],
Cell[3078, 97, 102, 2, 28, "Input",
  CellTags->"S5.0.2"],
Cell[3183, 101, 142, 5, 30, "MathCaption",
  CellTags->"S5.0.2"],

Cell[CellGroupData[{
Cell[3350, 110, 80, 2, 28, "Input",
  CellTags->"S5.0.2"],
Cell[3433, 114, 88, 3, 21, "Output",
  CellTags->"S5.0.2"]
}, Open  ]],
Cell[3536, 120, 962, 25, 120, "Text",
  CellTags->{"S5.0.2", "5.0.9"}],
Cell[4501, 147, 594, 15, 55, "Text",
  CellTags->"S5.0.2"],
Cell[5098, 164, 130, 5, 17, "Caption",
  CellTags->"S5.0.2"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

