(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     67142,       2233]*)
(*NotebookOutlinePosition[     95989,       2927]*)
(*  CellTagsIndexPosition[     94942,       2894]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Applications"
}], "Chapter"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Applications from Wolfram Research"
}], "Section",
  CellTags->"WolframApplications"],

Cell[TextData[{
  "Giving you direct access to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s powerful programming language and expansive collection \
of computational commands, each application package provides an incredibly \
rich and flexible working environment."
}], "Text",
  CellTags->"WolframApplications"],

Cell[CellGroupData[{

Cell["Advanced Numerical Methods", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Advanced Numerical Methods"}],

Cell[TextData[ButtonBox["State-of-the-Art Algorithms for Systems and Control",
  
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/anm/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Advanced Numerical Methods"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Calculus WIZ for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Users"
}], "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Calculus WIZ"}],

Cell[TextData[ButtonBox["Solves Your Toughest Homework Problems",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/student/calcwiz/app.html"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Calculus WIZ"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Control System Professional", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Control System Professional"}],

Cell[TextData[ButtonBox["Comprehensive Control System Environment with \
Integrated Symbolic Capability",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/control/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Control System Professional"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Control System Professional Suite", "Subsubsection",
  FontSlant->"Italic",
  CellTags->"WolframApplications"],

Cell[TextData[ButtonBox["Powerful, Integrated Tools for Control",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/csps/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Digital Image Processing", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Digital Image Processing"}],

Cell[TextData[{
  ButtonBox["Powerful, Fast Image Processing and Analysis with ",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/digitalimage/"], 
      None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Digital Image Processing",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/digitalimage/"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" and ",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/digitalimage/"], 
      None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/digitalimage/"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"]
}], "Text",
  CellTags->{"WolframApplications", "Digital Image Processing"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Electrical Engineering Examples", "Subsubsection",
  FontSlant->"Italic",
  CellTags->"WolframApplications"],

Cell[TextData[{
  ButtonBox["Circuit Analysis, Transmission Lines, and Antenna Design with \
the Power of ",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/ee/"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/ee/"], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"]
}], "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental Data Analyst", "Subsubsection",
  FontSlant->"Italic",
  CellTags->"WolframApplications"],

Cell[TextData[{
  ButtonBox["Fitting, Visualization, and Error Analysis with the Power of ",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/eda/"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/eda/"], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"]
}], "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finance Essentials", "Subsubsection",
  FontSlant->"Italic",
  CellTags->"WolframApplications"],

Cell[TextData[ButtonBox["Design and Analyze Proprietary Financial Systems",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/finance/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fuzzy Logic", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Fuzzy Logic"}],

Cell[TextData[ButtonBox["The Most Flexible Environment for Exploring Fuzzy \
Systems",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/fuzzylogic/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Fuzzy Logic"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Link for Excel"
}], "Subsubsection",
  FontSlant->"Italic",
  CellTags->"WolframApplications"],

Cell[TextData[ButtonBox["Break out of Your Cells!",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/excel_link/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mechanical Systems", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Mechanical Systems"}],

Cell[TextData[ButtonBox["Motion Analysis of Rigid Body Systems",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mechsystems/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Mechanical Systems"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Neural Networks", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Neural Networks"}],

Cell[TextData[ButtonBox["Train and Analyze Neural Networks to Fit Your Data",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/neuralnetworks/"], 
    None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Neural Networks"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["A New Kind of Science Explorer: Mathematica Kit",
  FontSlant->"Italic"]], "Subsubsection",
  CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}],

Cell[TextData[{
  ButtonBox["Use Your ",
    ButtonData:>{
      URL[ "http://www.wolframscience.com/nksx/nksxmk.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      URL[ "http://www.wolframscience.com/nksx/nksxmk.html"], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" to Extend the Discoveries of ",
    ButtonData:>{
      URL[ "http://www.wolframscience.com/nksx/nksxmk.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["A New Kind of Science",
    ButtonData:>{
      URL[ "http://www.wolframscience.com/nksx/nksxmk.html"], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"]
}], "Text",
  CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parallel Computing Toolkit", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Parallel Computing Toolkit"}],

Cell[TextData[ButtonBox["Unleash the Power of Parallel Computing",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/parallel/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Parallel Computing Toolkit"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scientific Astronomer", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Scientific Astronomer"}],

Cell[TextData[ButtonBox["The World\[CloseCurlyQuote]s Most Sophisticated \
General Astronomy System",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/astronomer/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Scientific Astronomer"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Signals and Systems", "Subsubsection",
  FontSlant->"Italic",
  CellTags->"WolframApplications"],

Cell[TextData[ButtonBox["The Only Signal Processing and Analysis Tool with \
Complete Symbolic Power",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/signals/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Structural Mechanics", "Subsubsection",
  FontSlant->"Italic",
  CellTags->"WolframApplications"],

Cell[TextData[ButtonBox["Elastic Systems and Finite Elements with Full \
Symbolic Capability",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/structural/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Time Series", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Time Series"}],

Cell[TextData[ButtonBox["A Fully Integrated Environment for Time-Dependent \
Data Analysis",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/timeseries/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Time Series"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wavelet Explorer", "Subsubsection",
  FontSlant->"Italic",
  CellTags->{"WolframApplications", "Wavelet Explorer"}],

Cell[TextData[ButtonBox["New Generation Signal and Image Analysis",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/wavelet/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"WolframApplications", "Wavelet Explorer"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Packages from Independent Developers"
}], "Section",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[{
  "Giving you direct access to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s powerful programming language and expansive collection \
of computational commands, each application package provides an incredibly \
rich and flexible working environment."
}], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Analog Insydes",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/insydes/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Derivatives Expert",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/derivatives/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[{
  StyleBox[ButtonBox["Geometrica",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/geometrica/"], None},
    
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox["02",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/applications/geometrica/"], None},
    
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Global Optimization",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/globalopt/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Industrial Electromagnetism",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/electromagnetism/"], 
    None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Industrial Optimization",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/optimization/"], None},
  
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Industrial Thermics",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/industrial/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["machine learning framework",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mlf/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Magnetica",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/magnetica/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["MathCode C++",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mathcode/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Mathematica Link for LabVIEW",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/labview/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["MathModelica",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mathmodelica/"], None},
  
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["MathOptimizer",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mathoptimizer/"], 
    None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["MathOptimizer Professional",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mathoptpro/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["MathTensor",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mathtensor/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Operations Research",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/operationsresearch/"], 
    None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["PrimeKit",
  ButtonData:>{
    URL[ "http://store.wolfram.com/view/book/ISBN0387947779.str"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["SchematicSolver",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/schematicsolver/"], 
    None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["Tensors in Physics",
  ButtonData:>{
    URL[ "http://store.wolfram.com/view/book/D0709.str"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["TSi ProPac",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/tsipropac/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["UnRisk PRICING ENGINE",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/unrisk/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["UnRisk STANDARD",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/unriskstandard/"], 
    None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"],

Cell[TextData[StyleBox[ButtonBox["VisualDSolve",
  ButtonData:>{
    URL[ "http://store.wolfram.com/view/book/D0706.str"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"IndependentDeveloperApps"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Other ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(Applications\^*\)\)]]
}], "Section",
  CellTags->"OtherApplications"],

Cell[TextData[{
  "Giving you direct access to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s powerful programming language and expansive collection \
of computational commands, each application package provides an incredibly \
rich and flexible working environment."
}], "Text",
  CellTags->"OtherApplications"],

Cell[TextData[StyleBox[ButtonBox["Artlandia",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/artlandia/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"OtherApplications"],

Cell[TextData[StyleBox[ButtonBox["Mathematica for ActiveX",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/max/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"OtherApplications"],

Cell[TextData[StyleBox[ButtonBox["MathEverywhere Courseware Series",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/matheverywhere/"], 
    None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"OtherApplications"],

Cell[TextData[StyleBox[ButtonBox["mathStatica",
  ButtonData:>{
    URL[ "http://www.wolfram.com/products/applications/mathstatica/"], None},
  ButtonStyle->"Hyperlink"],
  FontSlant->"Italic"]], "Text",
  CellTags->"OtherApplications"],

Cell[TextData[{
  "*Supported and distributed by independent ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " developers "
}], "Text",
  CellTags->"OtherApplications"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wolfram Education Training", "Chapter"],

Cell[CellGroupData[{

Cell["Wolfram Education Training", "Section",
  CellTags->{
  "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
    "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
    "WEG: M330", "WEG: M355", "WEG: M455"}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["M100: An Introduction to Mathematica",
  FontSlant->"Italic"]], "Subsection",
  CellTags->"WEG: M100"],

Cell[TextData[{
  "This one-day training course gives students direct experience with the \
basic ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " features they need to become proficient ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users. The course is designed primarily for people who are interested in \
becoming proficient ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users but have little or no experience with the system. This course can \
also be helpful for experienced users who would like to broaden their basic \
understanding of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and for those interested in learning exactly what the system can do."
}], "Text",
  CellTags->"WEG: M100"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M100"],

Cell[TextData[{
  StyleBox["Introduction",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " step-by-step instruction on performing basic operations, description of \
sources for additional information, and a tour of the features of the system"
}], "BulletedList",
  CellTags->"WEG: M100"],

Cell[TextData[{
  StyleBox["Notebooks and Typesetting",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " discussion and practice with interactive input, output, typesetting, and \
formatting features"
}], "BulletedList",
  CellTags->"WEG: M100"],

Cell[TextData[{
  StyleBox["Graphics",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " examples and exercises related to plotting, labeling plots, and \
manipulating graphical expressions"
}], "BulletedList",
  CellTags->"WEG: M100"],

Cell[TextData[{
  StyleBox["Programming",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " introduction to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language with emphasis on familiar programming tasks"
}], "BulletedList",
  CellTags->"WEG: M100"],

Cell[TextData[{
  StyleBox["Mathematics",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " tour of mathematical features of the system "
}], "BulletedList",
  CellTags->"WEG: M100"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M100"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["M101: A First Course in Mathematica",
  FontSlant->"Italic"]], "Subsection",
  CellTags->"WEG: M101"],

Cell[TextData[{
  "This two-day training course gives students direct experience with all of \
the basic features of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and provides a comprehensive foundation for developing advanced \
applications of the system. The course is designed primarily for people who \
are interested in becoming expert ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users but have little or no experience with the system. This course can \
also be helpful for experienced users who would like to broaden their basic \
understanding of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and for those interested in learning exactly what the system can do."
}], "Text",
  CellTags->"WEG: M101"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Introduction",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " step-by-step instruction on performing basic operations, building up \
computations, navigating the user interface, description of sources for \
additional information, and a tour of the features of the system"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Programming I",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " introduction to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language with emphasis on familiar programming tasks using \
procedural, functional, and rule-based styles of programming"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Graphics",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " two- and three-dimensional plotting, plotting data, using options, \
labeling plots, and manipulating graphical expressions"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Notebooks and Typesetting:",
    FontWeight->"Bold"],
  " introduction to the notebook interface, cells and cell styles, \
stylesheets, typesetting, and formatting features"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Mathematics:",
    FontWeight->"Bold"],
  " tour of the mathematical features of the system with a focus on symbolic \
and numerical calculations"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Programming II",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " a deeper look at the syntax and structure of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language, functional programming, and developing larger and \
more efficient programs"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Packages and Files:",
    FontWeight->"Bold"],
  " writing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages, importing and exporting expressions, files, and data"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  StyleBox["Examples and Applications",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " a set of extended projects designed to give the student practice at using \
the topics from this course to develop real-world applications"
}], "BulletedList",
  CellTags->"WEG: M101"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M101"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["M110: Working with Data Using Mathematica",
  FontSlant->"Italic"]], "Subsection",
  CellTags->"WEG: M110"],

Cell[TextData[{
  "This one-day course provides the foundation for using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to perform basic tasks in manipulating and analyzing data, including \
import and export of data, manipulation of data sets, basic data analysis, \
and visualization of data with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The course is designed for people who work with data and wish to improve \
their skills at using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for manipulation of data. Typical students include engineers, physicists, \
analysts in finance, and those in the physical, life, and medical sciences."
}], "Text",
  CellTags->"WEG: M110"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M110"],

Cell[TextData[{
  StyleBox["Introduction",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " brief overview of the basic components of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that will be needed in the rest of the course, including list and matrix \
manipulation, use of packages, introduction to statistics and regression \
tools, and programming in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "BulletedList",
  CellTags->"WEG: M110"],

Cell[TextData[{
  StyleBox["Importing and Exporting Data:",
    FontWeight->"Bold"],
  " reading and writing to files, giving file format specifications, \
formatting input, and working with nonnumeric data"
}], "BulletedList",
  CellTags->"WEG: M110"],

Cell[TextData[{
  StyleBox["Data Manipulation and Analysis",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " descriptive statistics, statistical distributions, random numbers, \
confidence intervals, hypothesis tests, linear and nonlinear regression, \
interpolation, resampling of data, data smoothing, and sorting"
}], "BulletedList",
  CellTags->"WEG: M110"],

Cell[TextData[{
  StyleBox["Data Visualization:",
    FontWeight->"Bold"],
  " basic plots and options, logarithmic plots, error bars, plots of multiple \
data sets, bar charts, surface and density plots of data, and plot legends\
\[LongDash]including text in graphics, arrays of plots, and plots of scaled \
data"
}], "BulletedList",
  CellTags->"WEG: M110"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M110"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
M125: Applied Programming: A Problem-Solving Approach (mini-course)\
\
\>", "Subsection",
  FontSlant->"Italic",
  CellTags->"WEG: M125"],

Cell[TextData[{
  "Students completing the course will gain a deeper understanding of the \
various styles of programming available in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[LongDash]functional, procedural, recursive, rule-based, and so on\
\[LongDash]and strategies for employing one approach over another. Students \
will also learn how to debug and to write more efficient programs. This \
course is intended for anyone who wishes to extend his or her understanding \
of programming in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " via a problem-solving approach."
}], "Text",
  CellTags->"WEG: M125"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M125"],

Cell[TextData[{
  "This mini-course is given online in one three to four hour session. For \
information about mini-courses, see ",
  ButtonBox["www.wolfram.com/weg/minicourses",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg/minicourses/"], None},
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->"WEG: M125"],

Cell["\<\
Two or three topics will be chosen by the instructor from the \
following list:\
\>", "Text",
  CellTags->"WEG: M125"],

Cell[TextData[{
  StyleBox["Programming Style:",
    FontWeight->"Bold"],
  " solving simply stated problems by a variety of programming paradigms \
(procedural, functional, recursive, rule-based, etc.) in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "BulletedList",
  CellTags->"WEG: M125"],

Cell[TextData[{
  StyleBox["Manipulating Data Files:",
    FontWeight->"Bold"],
  " an \[OpenCurlyDoubleQuote]A-Z\[CloseCurlyDoubleQuote] approach to working \
with data in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", including importing real data sets, working with the path, extracting \
parts of data, converting data to other forms, and analyzing/visualizing \
data, plus extensive use of ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["ReadList", "MR"]
}], "BulletedList",
  CellTags->"WEG: M125"],

Cell[TextData[{
  StyleBox["Numerical Computations and Working with Options:",
    FontWeight->"Bold"],
  " working with precision and accuracy in built-in functions (",
  StyleBox["WorkingPrecision", "MR"],
  ", ",
  StyleBox["PrecisionGoal", "MR"],
  ", ",
  StyleBox["MaxIterations", "MR"],
  ") and creating numerical functions that incorporate these options"
}], "BulletedList",
  CellTags->"WEG: M125"],

Cell[TextData[{
  StyleBox["Efficiency Issues:",
    FontWeight->"Bold"],
  " efficiency analysis through implementation of various classical \
algorithms; discussion of low-level versus high-level functions, algorithmic \
efficiency, and metrics for measuring efficiency"
}], "BulletedList",
  CellTags->"WEG: M125"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M125"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["M185: Numerical Computation in Mathematica (mini-course)", "Subsection",
  FontSlant->"Italic",
  CellTags->"WEG: M185"],

Cell[TextData[{
  "Students completing the course will gain a deeper understanding of the \
extensive numerical capabilities of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", with a focus on how to obtain results efficiently and how to gauge the \
quality of those results. This course is intended for anyone who uses \
numerical approximations in their work."
}], "Text",
  CellTags->"WEG: M185"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M185"],

Cell[TextData[{
  "This mini-course consists of two independent sections, M185A and M185B. \
Each section is three to four hours long. Students may take one or both of \
these sections in either order they wish. For information about mini-courses, \
see ",
  ButtonBox["www.wolfram.com/weg/minicourses",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg/minicourses/"], None},
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->"WEG: M185"],

Cell["M185A: Numerical Computation: Numbers, Vectors, and Matrices", "Text",
  FontWeight->"Bold",
  CellTags->"WEG: M185"],

Cell["Exact and approximate numbers and operations on them", "ItemizedText",
  FontWeight->"Bold",
  CellTags->"WEG: M185"],

Cell["Propagation of error", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Precision, accuracy, and automatic error tracking", "BulletedList",
  CellTags->"WEG: M185"],

Cell[TextData[{
  "Working effectively with vectors and matrices in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "ItemizedText",
  FontWeight->"Bold",
  CellTags->"WEG: M185"],

Cell["Listable operations", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Numerical linear algebra", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Sparse representations", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Programming with vectors for efficiency", "BulletedList",
  CellTags->"WEG: M185"],

Cell["\<\
M185B: Numerical Computation: Numerical Functions and \
Operations\
\>", "Text",
  FontWeight->"Bold",
  CellTags->"WEG: M185"],

Cell["Overview of numerical operations with functions", "ItemizedText",
  FontWeight->"Bold",
  CellTags->"WEG: M185"],

Cell["Numerical integration", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Finding roots numerically", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Numerical optimization", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Numerical solutions of differential equations", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Advanced aspects of numerical operations with functions", "ItemizedText",
  FontWeight->"Bold",
  CellTags->"WEG: M185"],

Cell["Methods of error estimation and control", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Specifying error tolerances", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Monitoring algorithms", "BulletedList",
  CellTags->"WEG: M185"],

Cell["Function evaluation semantics", "BulletedList",
  CellTags->"WEG: M185"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M185"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["M195: Authoring in Mathematica (mini-course)", "Subsection",
  FontSlant->"Italic",
  CellTags->"WEG: M195"],

Cell[TextData[{
  "This course is designed to make students aware of the many tools available \
for creating and managing technical documents in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This course is intended for anyone who wishes to work with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to create high-quality electronic and/or printed technical documents."
}], "Text",
  CellTags->"WEG: M195"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M195"],

Cell[TextData[{
  "This mini-course consists of three sections: M195A, M195B, and M195C. Each \
section is three to four hours long. M195A introduces the student to \
technical document writing in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". M195B is at an intermediate level and is appropriate for those who wish \
to use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to develop projects such as courseware, applications, or books. M195C is \
at an advanced level and is for those wishing to understand the underlying \
front-end structure so as to effectively program the user interface. ",
  ButtonBox["Additional online training information",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/education/onlineqa.html"], None},
    ButtonStyle->"Hyperlink"],
  " is available."
}], "Text",
  CellTags->"WEG: M195"],

Cell["M195A: Authoring: Introduction to Technical Document Writing", "Text",
  FontWeight->"Bold",
  CellTags->"WEG: M195"],

Cell["Palettes: using and creating", "BulletedList",
  CellTags->"WEG: M195"],

Cell["\<\
Formatting mathematical expressions: input, output, and inline \
cells\
\>", "BulletedList",
  CellTags->"WEG: M195"],

Cell["\<\
Cells and notebooks: styles, options, and programming the user \
interface\
\>", "BulletedList",
  CellTags->"WEG: M195"],

Cell[TextData[{
  "Hyperlinks: links to web pages, notebooks, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " documentation"
}], "BulletedList",
  CellTags->"WEG: M195"],

Cell["Cell tags, automatic numbering, and cross referencing", "BulletedList",
  CellTags->"WEG: M195"],

Cell["Style sheets: using, editing, and creating", "BulletedList",
  CellTags->"WEG: M195"],

Cell["\<\
Importing and exporting: importing images, exporting notebooks, \
notebooks vs. packages\
\>", "BulletedList",
  CellTags->"WEG: M195"],

Cell["M195B: Authoring: Building and Managing Projects", "Text",
  FontWeight->"Bold",
  CellTags->"WEG: M195"],

Cell["Documentation: Help Browser, indexing", "BulletedList",
  CellTags->"WEG: M195"],

Cell["Slide show presentations: creating, editing, modifying", "BulletedList",
  CellTags->"WEG: M195"],

Cell[TextData[{
  StyleBox["AuthorTools",
    FontSlant->"Italic"],
  ": projects, indexing, table of contents, referencing, pagination, printing \
options"
}], "BulletedList",
  CellTags->"WEG: M195"],

Cell[TextData[{
  StyleBox["Publicon",
    FontSlant->"Italic"],
  ": creating documents, typesetting, notes, references, bibliographies, \
exporting notebooks"
}], "BulletedList",
  CellTags->"WEG: M195"],

Cell["M195C: Authoring: Advanced Topics", "Text",
  FontWeight->"Bold",
  CellTags->"WEG: M195"],

Cell["Structure of notebooks and cells", "BulletedList",
  CellTags->"WEG: M195"],

Cell["Cells: constructing, writing, and cell data types", "BulletedList",
  CellTags->"WEG: M195"],

Cell["\<\
Box structures: box data, grid boxes, fraction boxes, formatted \
tables, etc.\
\>", "BulletedList",
  CellTags->"WEG: M195"],

Cell["Printing options", "BulletedList",
  CellTags->"WEG: M195"],

Cell[TextData[{
  "HTML/XML/MathML/",
  Cell[BoxData[
      StyleBox[
        RowBox[{"T", 
          AdjustmentBox["E",
            BoxMargins->{{-0.075, -0.085}, {0, 0}},
            BoxBaselineShift->0.5], "X"}]]]],
  "/La",
  Cell[BoxData[
      StyleBox[
        RowBox[{"T", 
          AdjustmentBox["E",
            BoxMargins->{{-0.075, -0.085}, {0, 0}},
            BoxBaselineShift->0.5], "X"}]]]]
}], "BulletedList",
  CellTags->"WEG: M195"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M195"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "M215: Applied Statistical Analysis with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (mini-course)"
}], "Subsection",
  FontSlant->"Italic",
  CellTags->"WEG: M215"],

Cell[TextData[{
  "This mini-course series is designed to give experience with the \
statistical tools that are available in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Using real-world and simulated data sets, students will import data, \
extract parts of the data based on various criteria sets, analyze the data, \
and visualize the results. The course is designed for people who work with \
data and wish to improve their skills at using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for performing statistical analyses of data. Typical students include \
engineers, physicists, analysts in finance, and professionals in the \
physical, life, and medical sciences."
}], "Text",
  CellTags->"WEG: M215"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M215"],

Cell[TextData[{
  "This mini-course consists of two independent sections: M215A and M215B. \
Each section is three to four hours long. Students may take one or both of \
these sections in whichever order they wish. ",
  ButtonBox["Additional online training information",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/education/onlineqa.html"], None},
    ButtonStyle->"Hyperlink"],
  " is available."
}], "Text",
  CellTags->"WEG: M215"],

Cell[TextData[{
  " ",
  StyleBox["M215A: Applied Statistical Analysis with ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": Descriptive and Mathematical Statistics",
    FontWeight->"Bold"]
}], "Text",
  CellTags->"WEG: M215"],

Cell["\<\
Computing basic descriptive statistics of data (mean, median, \
variance, etc.)\
\>", "BulletedList",
  CellTags->"WEG: M215"],

Cell["\<\
Visualizing statistical data (including box plots, scatter plots, \
and histograms)\
\>", "BulletedList",
  CellTags->"WEG: M215"],

Cell["\<\
Computing and visualizing properties of continuous and discrete \
distributions, such as mean, PDF, CDF, expectations, and quantiles\
\>", \
"BulletedList",
  CellTags->"WEG: M215"],

Cell["\<\
Random number generation from continuous and discrete distributions\
\
\>", "BulletedList",
  CellTags->"WEG: M215"],

Cell["\<\
Hypothesis testing (including t-tests, z-tests, and chi-squared \
tests) and confidence intervals\
\>", "BulletedList",
  CellTags->"WEG: M215"],

Cell["Analysis of variance (ANOVA)", "BulletedList",
  CellTags->"WEG: M215"],

Cell[TextData[{
  StyleBox["M215B: Applied Statistical Analysis with ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": Regression",
    FontWeight->"Bold"]
}], "Text",
  CellTags->"WEG: M215"],

Cell["\<\
Curve fitting via ordinary least squares, alternative metrics, and \
merit functions\
\>", "BulletedList",
  CellTags->"WEG: M215"],

Cell["Linear and nonlinear regression", "BulletedList",
  CellTags->"WEG: M215"],

Cell["Obtaining and visualizing regression diagnostics", "BulletedList",
  CellTags->"WEG: M215"],

Cell["Data transformations", "BulletedList",
  CellTags->"WEG: M215"],

Cell["Robust regression via iterative reweighting", "BulletedList",
  CellTags->"WEG: M215"],

Cell["Maximum likelihood estimation", "BulletedList",
  CellTags->"WEG: M215"],

Cell["Fitting generalized linear models", "BulletedList",
  CellTags->"WEG: M215"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M215"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["M220: Programming in Mathematica",
  FontSlant->"Italic"]], "Subsection",
  CellTags->"WEG: M220"],

Cell[TextData[{
  "This course emphasizes program structure as well as functional and \
rule-based programming. These styles of programming are compared to more \
traditional procedural programming methods to help students understand and \
use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s unique features to their advantage. Students will \
learn how to develop applications, large and small, in a systematic manner \
and how to solve particular problems more efficiently by choosing the \
appropriate programming paradigm. The course includes practical hands-on \
exercises to help students understand the material and to provide a focused \
and practical learning experience."
}], "Text",
  CellTags->"WEG: M220"],

Cell[TextData[{
  "The course is intended for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users who wish to solve problems in their own areas of application and to \
harness the full power of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by combining its many built-in features in new ways."
}], "Text",
  CellTags->"WEG: M220"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Introduction:",
    FontWeight->"Bold"],
  " review of fundamental data types, rules, and definitions; discussion of \
various programming styles and the differences between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and traditional programming languages"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Patterns and Rules:",
    FontWeight->"Bold"],
  " treatment of rule-based programming, which is fundamental to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s design; discussion of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s evaluator"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Functional Programming",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " functions as objects, iteration and recursion, and elegant programs"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Procedural Programming:",
    FontWeight->"Bold"],
  " presentation of the more traditional programming features, such as loops, \
iterators, and conditionals"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Data Types",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " concepts and design of data types, operators, and overloading"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Program Design:",
    FontWeight->"Bold"],
  " discussion of the software engineering aspects of program development in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", package design, and localization of data"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Special Topics",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " a look at various more advanced techniques for writing better programs, \
such as dynamic programming, defaults, efficiency, and error messages"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  StyleBox["Outlook:",
    FontWeight->"Bold"],
  " discussion of existing programs, literature, and topics of interest"
}], "BulletedList",
  CellTags->"WEG: M220"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M220"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["M245: Parallel Computation",
  FontSlant->"Italic"]], "Subsection",
  CellTags->"WEG: M245"],

Cell[TextData[{
  "This one-day course covers the use of the ",
  StyleBox["Parallel Computing Toolkit",
    FontSlant->"Italic"],
  " for developing parallel programs in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and provides practical, hands-on exercises to give the student concrete \
examples. This course is intended for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users who want to develop programs for solving problems in parallel on \
multiprocessor machines, networks or workstations, or dedicated computing \
grids."
}], "Text",
  CellTags->"WEG: M245"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M245"],

Cell[TextData[{
  StyleBox["Introduction",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " prerequisites for parallel computation with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", installation issues of ",
  StyleBox["Parallel Computing Toolkit",
    FontSlant->"Italic"],
  " and grid",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and basic remote and parallel evaluations"
}], "BulletedList",
  CellTags->"WEG: M245"],

Cell[TextData[{
  StyleBox["Parallel Evaluation",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " coarse-grain parallelism, process initialization, debugging, and \
performance measurements "
}], "BulletedList",
  CellTags->"WEG: M245"],

Cell[TextData[{
  StyleBox["Concurrency and Scheduling",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " virtual shared memory and synchronization"
}], "BulletedList",
  CellTags->"WEG: M245"],

Cell[TextData[{
  StyleBox["Applications",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " examples and practical tips"
}], "BulletedList",
  CellTags->"WEG: M245"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M245"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["M310: Digital Image Processing",
  FontSlant->"Italic"]], "Subsection",
  CellTags->"WEG: M310"],

Cell[TextData[{
  "This course presents the theory and practice of digital image processing \
with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and focuses on the ",
  StyleBox["Digital Image Processing",
    FontSlant->"Italic"],
  " package. The features and capabilities of the package are demonstrated, \
and numerous examples and practical hands-on exercises are included. The \
material is presented as a sequence of eight one-hour lectures. Each lecture \
covers a major image processing topic, typically consisting of a discussion \
of the basic theoretical concepts and including examples that illustrate \
relevant, practical imaging problems. The lectures are followed by exercise \
sessions to help students understand the material and to provide a focused \
and practical learning experience."
}], "Text",
  CellTags->"WEG: M310"],

Cell[TextData[{
  "The course is designed primarily for people who need to analyze and \
process imaging data with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Students typically have wide-ranging backgrounds and include engineers \
and professionals in the physical, life, and medical sciences."
}], "Text",
  CellTags->"WEG: M310"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Introduction",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " lists, matrices, and images; basics of programming with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "; image representation and display"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Image Histogram and Point Operations:",
    FontWeight->"Bold"],
  " first- and second-order image histograms, contrast enhancement ",
  StyleBox["via", "TI",
    FontSlant->"Plain"],
  " point transformations, histogram equalization, and color transformations"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Geometric Operations",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " image resizing, interpolation and decimation, affine spatial \
transformations (rotation), and higher-order spatial transformations (warp)"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Linear Processing",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " convolution and correlation, linear filtering, FIR filters, blurring, \
sharpening, and edge detection"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Selective Processing",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " block processing, region-of-interest processing, and line profiles"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Nonlinear Processing:",
    FontWeight->"Bold"],
  " nonlinear noise reducing filters (e.g., median, outlier, and adaptive) \
and image morphology"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Frequency Domain Processing:",
    FontWeight->"Bold"],
  " Fourier analysis and unitary image transforms: DFT, DCT, DHT, and DWT"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  StyleBox["Performance and Extensions",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " packed arrays, Compile, ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ", and Java Advanced Programming (JAI)"
}], "BulletedList",
  CellTags->"WEG: M310"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M310"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["M330: Neural Networks",
  FontSlant->"Italic"]], "Subsection",
  CellTags->"WEG: M330"],

Cell[TextData[{
  "This course presents the theory and practice of neural networks with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and focuses on the ",
  StyleBox["Neural Networks",
    FontSlant->"Italic"],
  " package. The features and capabilities of the package are demonstrated, \
and numerous examples and practical hands-on exercises are included. The \
material is presented as a sequence of five lectures, each one followed by a \
problem session to help students understand the material and to provide a \
focused and practical learning experience. The lectures cover the different \
kinds of neural networks and the types of problems for which neural networks \
are used. Basic theoretical concepts, illustrated with graphs, figures, and \
examples, are covered to support practical neural network training."
}], "Text",
  CellTags->"WEG: M330"],

Cell[TextData[{
  "The course is designed primarily for people who need to estimate relations \
in data using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Students typically have wide-ranging backgrounds and include engineers \
and professionals who work with all kinds of data, including technical, \
medical, and economic data."
}], "Text",
  CellTags->"WEG: M330"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M330"],

Cell[TextData[{
  StyleBox["Introduction",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " overview of neural network history and types of problems: function \
approximation, classification, data clustering, time series, and dynamic \
systems"
}], "BulletedList",
  CellTags->"WEG: M330"],

Cell[TextData[{
  StyleBox["Feedforward Neural Networks and Radial Basis Functions:",
    FontWeight->"Bold"],
  " learning, overlearning, and initialization of neural networks"
}], "BulletedList",
  CellTags->"WEG: M330"],

Cell[TextData[{
  StyleBox["Theory and Background of Neural Networks",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " description of the inherited problems when functions are fitted to data, \
possibilities for handling these problems using neural networks, and \
practical aspects"
}], "BulletedList",
  CellTags->"WEG: M330"],

Cell[TextData[{
  StyleBox["Nonlinear Dynamic Black-Box Modeling",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " modeling of time series and dynamic systems using linear and nonlinear \
models"
}], "BulletedList",
  CellTags->"WEG: M330"],

Cell[TextData[{
  StyleBox["Classification and Clustering with Neural Networks",
    FontWeight->"Bold"],
  StyleBox[":",
    FontWeight->"Bold"],
  " two classes, many classes, neural network classifiers and relations to \
other classifiers, the perceptron as classifier, nearest-neighbor \
classification, vector quantization, unsupervised methods, self-organizing \
maps, and the Hopfield network"
}], "BulletedList",
  CellTags->"WEG: M330"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M330"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["M355: A First Course in webMathematica (mini-course)", "Subsection",
  FontSlant->"Italic",
  CellTags->"WEG: M355"],

Cell[TextData[{
  "This mini-course provides an overview of all the capabilities that make \
web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " the ideal tool for interactive computation and visualization. The course \
is designed primarily for anyone who is interested in developing web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-powered websites that offer access to specific ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications through a web browser. Each student will be provided with \
instructions, in the form of short FAQs, on setting up the necessary \
components for a web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-powered website. Downloadable course materials and exercises will also be \
made available."
}], "Text",
  CellTags->"WEG: M355"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M355"],

Cell[TextData[{
  "This mini-course is given online in one three- to four-hour session. For \
information about mini-courses, see ",
  ButtonBox["www.wolfram.com/weg/minicourses",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg/minicourses/"], None},
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->"WEG: M355"],

Cell["This basic course is organized as follows:", "Text",
  CellTags->"WEG: M355"],

Cell[TextData[{
  StyleBox["Introduction:",
    FontWeight->"Bold"],
  " underlying technology of web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", JavaServer Pages and HTML form information"
}], "BulletedList",
  CellTags->"WEG: M355"],

Cell[TextData[{
  StyleBox["Installation:",
    FontWeight->"Bold"],
  " preparing your web server for installation of web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", installing, checking, and customizing web",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "BulletedList",
  CellTags->"WEG: M355"],

Cell[TextData[{
  StyleBox["Authoring web",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Pages:",
    FontWeight->"Bold"],
  " using the web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "Author package, using a text editor, debugging your code"
}], "BulletedList",
  CellTags->"WEG: M355"],

Cell[TextData[{
  StyleBox["Tips and Tricks:",
    FontWeight->"Bold"],
  " ",
  "flow of control in a web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " page, monitoring your web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " site"
}], "BulletedList",
  CellTags->"WEG: M355"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M355"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
M455: An Introduction to Web Services with Mathematica \
(mini-course)\
\>", "Subsection",
  FontSlant->"Italic",
  CellTags->"WEG: M455"],

Cell[TextData[{
  "This course is designed to present ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s web services features in depth, enabling students to \
integrate web services to extend ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s capabilities using standard web technology. Web \
services provide data and functionality to applications using standard web \
technology, such as HTTP and XML. This course introduces users to web \
services and explains how they can be beneficial to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users. Demonstrations will be presented that explain how to dynamically \
load web services into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Fully functional ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications will be presented to give a larger picture of the impact web \
services can have on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"WEG: M455"],

Cell[CellGroupData[{

Cell["Syllabus", "Subsubsection",
  CellTags->"WEG: M455"],

Cell[TextData[{
  "This mini-course is given online in one three- to four-hour session. For \
information about mini-courses, see ",
  ButtonBox["www.wolfram.com/weg/minicourses",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg/minicourses/"], None},
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->"WEG: M455"],

Cell["The course is organized into eight segments.", "Text",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["Introduction:",
    FontWeight->"Bold"],
  " ",
  "an introduction to the key technologies that make web services possible"
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["Stock Data\[LongDash]A Simple Example:",
    FontWeight->"Bold"],
  " an example that demonstrates how simple and natural it can be to use a \
web service with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["Google Web Service\[LongDash]Compound Data Types:",
    FontWeight->"Bold"],
  " ",
  "an example that demonstrates how complex data structures are dealt with \
while using web services"
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["Under the Hood\[LongDash]Working with Messages Directly:",
    FontWeight->"Bold"],
  " ",
  "some web services may not conform to specific standards and may not \
immediately work with the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " web services functionality. This section demonstrates how a developer can \
get under the hood and make these web services work"
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["XMethods\[LongDash]Discovering What Web Services Are Out There:",
    FontWeight->"Bold"],
  " a segment that allows students to interactively discover and learn about \
the web services available publicly"
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["Integrator Web Service\[LongDash]A Pure ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" example:",
    FontWeight->"Bold"],
  " an example that demonstrates how to create a web service with web",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and use features that make integration with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " very convenient"
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["Wolfram Search Web Service:",
    FontWeight->"Bold"],
  " a complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " example that demonstrates how to completely integrate a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application with a web service"
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  StyleBox["Outlook:",
    FontWeight->"Bold"],
  " a discussion of existing programs, literature, and topics of interest"
}], "BulletedList",
  CellTags->"WEG: M455"],

Cell[TextData[{
  "All Wolfram Education Group offerings are \[OpenCurlyDoubleQuote]hands-on\
\[CloseCurlyDoubleQuote] interactive courses taught by certified instructors. \
For more information, visit ",
  ButtonBox["www.wolfram.com/weg",
    ButtonData:>{
      URL[ "http://www.wolfram.com/weg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"WEG: M455"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{47, 1440}, {0, 878}},
ScreenStyleEnvironment->"Working",
WindowSize->{551, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "WolframApplications"->{
    Cell[1901, 61, 157, 5, 83, "Section",
      CellTags->"WolframApplications"],
    Cell[2061, 68, 345, 8, 56, "Text",
      CellTags->"WolframApplications"],
    Cell[2431, 80, 141, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Advanced Numerical Methods"}],
    Cell[2575, 84, 272, 5, 24, "Text",
      CellTags->{"WolframApplications", "Advanced Numerical Methods"}],
    Cell[2884, 94, 198, 7, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Calculus WIZ"}],
    Cell[3085, 103, 249, 4, 24, "Text",
      CellTags->{"WolframApplications", "Calculus WIZ"}],
    Cell[3371, 112, 143, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Control System Professional"}],
    Cell[3517, 116, 301, 5, 24, "Text",
      CellTags->{"WolframApplications", "Control System Professional"}],
    Cell[3855, 126, 116, 2, 34, "Subsubsection",
      CellTags->"WolframApplications"],
    Cell[3974, 130, 225, 4, 24, "Text",
      CellTags->"WolframApplications"],
    Cell[4236, 139, 137, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Digital Image Processing"}],
    Cell[4376, 143, 863, 24, 24, "Text",
      CellTags->{"WolframApplications", "Digital Image Processing"}],
    Cell[5276, 172, 114, 2, 34, "Subsubsection",
      CellTags->"WolframApplications"],
    Cell[5393, 176, 456, 12, 24, "Text",
      CellTags->"WolframApplications"],
    Cell[5886, 193, 108, 2, 34, "Subsubsection",
      CellTags->"WolframApplications"],
    Cell[5997, 197, 442, 11, 24, "Text",
      CellTags->"WolframApplications"],
    Cell[6476, 213, 101, 2, 34, "Subsubsection",
      CellTags->"WolframApplications"],
    Cell[6580, 217, 238, 4, 24, "Text",
      CellTags->"WolframApplications"],
    Cell[6855, 226, 111, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Fuzzy Logic"}],
    Cell[6969, 230, 269, 5, 24, "Text",
      CellTags->{"WolframApplications", "Fuzzy Logic"}],
    Cell[7275, 240, 166, 6, 34, "Subsubsection",
      CellTags->"WolframApplications"],
    Cell[7444, 248, 217, 4, 24, "Text",
      CellTags->"WolframApplications"],
    Cell[7698, 257, 125, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Mechanical Systems"}],
    Cell[7826, 261, 255, 4, 24, "Text",
      CellTags->{"WolframApplications", "Mechanical Systems"}],
    Cell[8118, 270, 119, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Neural Networks"}],
    Cell[8240, 274, 273, 5, 24, "Text",
      CellTags->{"WolframApplications", "Neural Networks"}],
    Cell[8550, 284, 185, 2, 34, "Subsubsection",
      CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}],
    Cell[8738, 288, 773, 20, 24, "Text",
      CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}],
    Cell[9548, 313, 141, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Parallel Computing Toolkit"}],
    Cell[9692, 317, 262, 4, 24, "Text",
      CellTags->{"WolframApplications", "Parallel Computing Toolkit"}],
    Cell[9991, 326, 131, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Scientific Astronomer"}],
    Cell[10125, 330, 294, 5, 24, "Text",
      CellTags->{"WolframApplications", "Scientific Astronomer"}],
    Cell[10456, 340, 102, 2, 34, "Subsubsection",
      CellTags->"WolframApplications"],
    Cell[10561, 344, 265, 5, 24, "Text",
      CellTags->"WolframApplications"],
    Cell[10863, 354, 103, 2, 34, "Subsubsection",
      CellTags->"WolframApplications"],
    Cell[10969, 358, 260, 5, 24, "Text",
      CellTags->"WolframApplications"],
    Cell[11266, 368, 111, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Time Series"}],
    Cell[11380, 372, 275, 5, 24, "Text",
      CellTags->{"WolframApplications", "Time Series"}],
    Cell[11692, 382, 121, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Wavelet Explorer"}],
    Cell[11816, 386, 252, 4, 24, "Text",
      CellTags->{"WolframApplications", "Wavelet Explorer"}]},
  "Advanced Numerical Methods"->{
    Cell[2431, 80, 141, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Advanced Numerical Methods"}],
    Cell[2575, 84, 272, 5, 24, "Text",
      CellTags->{"WolframApplications", "Advanced Numerical Methods"}]},
  "Calculus WIZ"->{
    Cell[2884, 94, 198, 7, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Calculus WIZ"}],
    Cell[3085, 103, 249, 4, 24, "Text",
      CellTags->{"WolframApplications", "Calculus WIZ"}]},
  "Control System Professional"->{
    Cell[3371, 112, 143, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Control System Professional"}],
    Cell[3517, 116, 301, 5, 24, "Text",
      CellTags->{"WolframApplications", "Control System Professional"}]},
  "Digital Image Processing"->{
    Cell[4236, 139, 137, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Digital Image Processing"}],
    Cell[4376, 143, 863, 24, 24, "Text",
      CellTags->{"WolframApplications", "Digital Image Processing"}]},
  "Fuzzy Logic"->{
    Cell[6855, 226, 111, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Fuzzy Logic"}],
    Cell[6969, 230, 269, 5, 24, "Text",
      CellTags->{"WolframApplications", "Fuzzy Logic"}]},
  "Mechanical Systems"->{
    Cell[7698, 257, 125, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Mechanical Systems"}],
    Cell[7826, 261, 255, 4, 24, "Text",
      CellTags->{"WolframApplications", "Mechanical Systems"}]},
  "Neural Networks"->{
    Cell[8118, 270, 119, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Neural Networks"}],
    Cell[8240, 274, 273, 5, 24, "Text",
      CellTags->{"WolframApplications", "Neural Networks"}]},
  "NKS Explorer: Mathematica Kit"->{
    Cell[8550, 284, 185, 2, 34, "Subsubsection",
      CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}],
    Cell[8738, 288, 773, 20, 24, "Text",
      CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}]},
  "Parallel Computing Toolkit"->{
    Cell[9548, 313, 141, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Parallel Computing Toolkit"}],
    Cell[9692, 317, 262, 4, 24, "Text",
      CellTags->{"WolframApplications", "Parallel Computing Toolkit"}]},
  "Scientific Astronomer"->{
    Cell[9991, 326, 131, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Scientific Astronomer"}],
    Cell[10125, 330, 294, 5, 24, "Text",
      CellTags->{"WolframApplications", "Scientific Astronomer"}]},
  "Time Series"->{
    Cell[11266, 368, 111, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Time Series"}],
    Cell[11380, 372, 275, 5, 24, "Text",
      CellTags->{"WolframApplications", "Time Series"}]},
  "Wavelet Explorer"->{
    Cell[11692, 382, 121, 2, 34, "Subsubsection",
      CellTags->{"WolframApplications", "Wavelet Explorer"}],
    Cell[11816, 386, 252, 4, 24, "Text",
      CellTags->{"WolframApplications", "Wavelet Explorer"}]},
  "IndependentDeveloperApps"->{
    Cell[12117, 396, 164, 5, 83, "Section",
      CellTags->"IndependentDeveloperApps"],
    Cell[12284, 403, 350, 8, 56, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[12637, 413, 242, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[12882, 420, 250, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[13135, 427, 411, 13, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[13549, 442, 249, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[13801, 449, 269, 6, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[14073, 457, 259, 6, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[14335, 465, 250, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[14588, 472, 250, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[14841, 479, 239, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[15083, 486, 241, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[15327, 493, 256, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[15586, 500, 248, 6, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[15837, 508, 252, 6, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[16092, 516, 257, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[16352, 523, 241, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[16596, 530, 263, 6, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[16862, 538, 236, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[17101, 545, 256, 6, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[17360, 553, 237, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[17600, 560, 240, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[17843, 567, 248, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[18094, 574, 255, 6, 24, "Text",
      CellTags->"IndependentDeveloperApps"],
    Cell[18352, 582, 231, 5, 24, "Text",
      CellTags->"IndependentDeveloperApps"]},
  "OtherApplications"->{
    Cell[18620, 592, 199, 8, 61, "Section",
      CellTags->"OtherApplications"],
    Cell[18822, 602, 343, 8, 56, "Text",
      CellTags->"OtherApplications"],
    Cell[19168, 612, 232, 5, 24, "Text",
      CellTags->"OtherApplications"],
    Cell[19403, 619, 240, 5, 24, "Text",
      CellTags->"OtherApplications"],
    Cell[19646, 626, 265, 6, 24, "Text",
      CellTags->"OtherApplications"],
    Cell[19914, 634, 236, 5, 24, "Text",
      CellTags->"OtherApplications"],
    Cell[20153, 641, 177, 6, 24, "Text",
      CellTags->"OtherApplications"]},
  "WEG: M100"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[20715, 665, 126, 2, 36, "Subsection",
      CellTags->"WEG: M100"],
    Cell[20844, 669, 744, 19, 88, "Text",
      CellTags->"WEG: M100"],
    Cell[21613, 692, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M100"],
    Cell[21674, 695, 309, 8, 44, "BulletedList",
      CellTags->"WEG: M100"],
    Cell[21986, 705, 266, 8, 44, "BulletedList",
      CellTags->"WEG: M100"],
    Cell[22255, 715, 255, 8, 44, "BulletedList",
      CellTags->"WEG: M100"],
    Cell[22513, 725, 301, 10, 44, "BulletedList",
      CellTags->"WEG: M100"],
    Cell[22817, 737, 202, 7, 26, "BulletedList",
      CellTags->"WEG: M100"],
    Cell[23022, 746, 380, 10, 40, "Text",
      CellTags->"WEG: M100"]},
  "WEG: M101"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[23451, 762, 125, 2, 36, "Subsection",
      CellTags->"WEG: M101"],
    Cell[23579, 766, 747, 17, 104, "Text",
      CellTags->"WEG: M101"],
    Cell[24351, 787, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M101"],
    Cell[24412, 790, 368, 9, 62, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[24783, 801, 372, 11, 62, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[25158, 814, 278, 8, 44, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[25439, 824, 246, 6, 44, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[25688, 832, 219, 6, 44, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[25910, 840, 366, 11, 44, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[26279, 853, 254, 8, 44, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[26536, 863, 310, 8, 44, "BulletedList",
      CellTags->"WEG: M101"],
    Cell[26849, 873, 380, 10, 40, "Text",
      CellTags->"WEG: M101"]},
  "WEG: M110"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[27278, 889, 131, 2, 36, "Subsection",
      CellTags->"WEG: M110"],
    Cell[27412, 893, 716, 16, 104, "Text",
      CellTags->"WEG: M110"],
    Cell[28153, 913, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M110"],
    Cell[28214, 916, 488, 14, 62, "BulletedList",
      CellTags->"WEG: M110"],
    Cell[28705, 932, 252, 6, 44, "BulletedList",
      CellTags->"WEG: M110"],
    Cell[28960, 940, 383, 9, 62, "BulletedList",
      CellTags->"WEG: M110"],
    Cell[29346, 951, 359, 8, 62, "BulletedList",
      CellTags->"WEG: M110"],
    Cell[29708, 961, 380, 10, 40, "Text",
      CellTags->"WEG: M110"]},
  "WEG: M125"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[30137, 977, 147, 5, 54, "Subsection",
      CellTags->"WEG: M125"],
    Cell[30287, 984, 638, 14, 88, "Text",
      CellTags->"WEG: M125"],
    Cell[30950, 1002, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M125"],
    Cell[31011, 1005, 333, 9, 40, "Text",
      CellTags->"WEG: M125"],
    Cell[31347, 1016, 128, 4, 24, "Text",
      CellTags->"WEG: M125"],
    Cell[31478, 1022, 304, 8, 44, "BulletedList",
      CellTags->"WEG: M125"],
    Cell[31785, 1032, 523, 14, 79, "BulletedList",
      CellTags->"WEG: M125"],
    Cell[32311, 1048, 408, 11, 62, "BulletedList",
      CellTags->"WEG: M125"],
    Cell[32722, 1061, 317, 7, 62, "BulletedList",
      CellTags->"WEG: M125"],
    Cell[33042, 1070, 380, 10, 40, "Text",
      CellTags->"WEG: M125"]},
  "WEG: M185"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[33471, 1086, 126, 2, 36, "Subsection",
      CellTags->"WEG: M185"],
    Cell[33600, 1090, 410, 9, 72, "Text",
      CellTags->"WEG: M185"],
    Cell[34035, 1103, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M185"],
    Cell[34096, 1106, 458, 11, 56, "Text",
      CellTags->"WEG: M185"],
    Cell[34557, 1119, 123, 2, 24, "Text",
      CellTags->"WEG: M185"],
    Cell[34683, 1123, 123, 2, 26, "ItemizedText",
      CellTags->"WEG: M185"],
    Cell[34809, 1127, 69, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[34881, 1130, 98, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[34982, 1133, 188, 6, 26, "ItemizedText",
      CellTags->"WEG: M185"],
    Cell[35173, 1141, 68, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[35244, 1144, 73, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[35320, 1147, 71, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[35394, 1150, 88, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[35485, 1153, 137, 5, 24, "Text",
      CellTags->"WEG: M185"],
    Cell[35625, 1160, 118, 2, 26, "ItemizedText",
      CellTags->"WEG: M185"],
    Cell[35746, 1164, 70, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[35819, 1167, 74, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[35896, 1170, 71, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[35970, 1173, 94, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[36067, 1176, 126, 2, 26, "ItemizedText",
      CellTags->"WEG: M185"],
    Cell[36196, 1180, 88, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[36287, 1183, 76, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[36366, 1186, 70, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[36439, 1189, 78, 1, 26, "BulletedList",
      CellTags->"WEG: M185"],
    Cell[36520, 1192, 380, 10, 40, "Text",
      CellTags->"WEG: M185"]},
  "WEG: M195"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[36949, 1208, 114, 2, 36, "Subsection",
      CellTags->"WEG: M195"],
    Cell[37066, 1212, 430, 10, 56, "Text",
      CellTags->"WEG: M195"],
    Cell[37521, 1226, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M195"],
    Cell[37582, 1229, 857, 19, 104, "Text",
      CellTags->"WEG: M195"],
    Cell[38442, 1250, 123, 2, 24, "Text",
      CellTags->"WEG: M195"],
    Cell[38568, 1254, 77, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[38648, 1257, 127, 4, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[38778, 1263, 131, 4, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[38912, 1269, 180, 6, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[39095, 1277, 102, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[39200, 1280, 91, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[39294, 1283, 145, 4, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[39442, 1289, 111, 2, 24, "Text",
      CellTags->"WEG: M195"],
    Cell[39556, 1293, 86, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[39645, 1296, 103, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[39751, 1299, 201, 6, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[39955, 1307, 205, 6, 44, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[40163, 1315, 96, 2, 24, "Text",
      CellTags->"WEG: M195"],
    Cell[40262, 1319, 81, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[40346, 1322, 98, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[40447, 1325, 135, 4, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[40585, 1331, 65, 1, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[40653, 1334, 452, 16, 26, "BulletedList",
      CellTags->"WEG: M195"],
    Cell[41108, 1352, 380, 10, 40, "Text",
      CellTags->"WEG: M195"]},
  "WEG: M220"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[45509, 1508, 122, 2, 36, "Subsection",
      CellTags->"WEG: M220"],
    Cell[45634, 1512, 748, 14, 120, "Text",
      CellTags->"WEG: M220"],
    Cell[46385, 1528, 356, 10, 56, "Text",
      CellTags->"WEG: M220"],
    Cell[46766, 1542, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M220"],
    Cell[46827, 1545, 344, 9, 62, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[47174, 1556, 373, 11, 44, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[47550, 1569, 236, 7, 44, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[47789, 1578, 232, 6, 44, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[48024, 1586, 218, 7, 26, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[48245, 1595, 296, 9, 44, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[48544, 1606, 304, 8, 44, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[48851, 1616, 181, 5, 26, "BulletedList",
      CellTags->"WEG: M220"],
    Cell[49035, 1623, 380, 10, 40, "Text",
      CellTags->"WEG: M220"]},
  "WEG: M215"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[41537, 1368, 198, 7, 54, "Subsection",
      CellTags->"WEG: M215"],
    Cell[41738, 1377, 735, 15, 104, "Text",
      CellTags->"WEG: M215"],
    Cell[42498, 1396, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M215"],
    Cell[42559, 1399, 454, 10, 56, "Text",
      CellTags->"WEG: M215"],
    Cell[43016, 1411, 296, 10, 40, "Text",
      CellTags->"WEG: M215"],
    Cell[43315, 1423, 136, 4, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[43454, 1429, 140, 4, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[43597, 1435, 191, 5, 44, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[43791, 1442, 126, 4, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[43920, 1448, 154, 4, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44077, 1454, 77, 1, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44157, 1457, 260, 9, 24, "Text",
      CellTags->"WEG: M215"],
    Cell[44420, 1468, 141, 4, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44564, 1474, 80, 1, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44647, 1477, 97, 1, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44747, 1480, 69, 1, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44819, 1483, 92, 1, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44914, 1486, 78, 1, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[44995, 1489, 82, 1, 26, "BulletedList",
      CellTags->"WEG: M215"],
    Cell[45080, 1492, 380, 10, 40, "Text",
      CellTags->"WEG: M215"]},
  "WEG: M245"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[49464, 1639, 116, 2, 36, "Subsection",
      CellTags->"WEG: M245"],
    Cell[49583, 1643, 594, 15, 88, "Text",
      CellTags->"WEG: M245"],
    Cell[50202, 1662, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M245"],
    Cell[50263, 1665, 469, 16, 44, "BulletedList",
      CellTags->"WEG: M245"],
    Cell[50735, 1683, 258, 8, 44, "BulletedList",
      CellTags->"WEG: M245"],
    Cell[50996, 1693, 214, 7, 26, "BulletedList",
      CellTags->"WEG: M245"],
    Cell[51213, 1702, 186, 7, 26, "BulletedList",
      CellTags->"WEG: M245"],
    Cell[51402, 1711, 380, 10, 40, "Text",
      CellTags->"WEG: M245"]},
  "WEG: M310"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[51831, 1727, 120, 2, 36, "Subsection",
      CellTags->"WEG: M310"],
    Cell[51954, 1731, 857, 17, 120, "Text",
      CellTags->"WEG: M310"],
    Cell[52814, 1750, 348, 8, 56, "Text",
      CellTags->"WEG: M310"],
    Cell[53187, 1762, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M310"],
    Cell[53248, 1765, 307, 10, 44, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[53558, 1777, 334, 8, 62, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[53895, 1787, 305, 8, 44, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[54203, 1797, 266, 8, 44, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[54472, 1807, 233, 7, 26, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[54708, 1816, 220, 6, 44, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[54931, 1824, 203, 5, 44, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[55137, 1831, 287, 10, 44, "BulletedList",
      CellTags->"WEG: M310"],
    Cell[55427, 1843, 380, 10, 40, "Text",
      CellTags->"WEG: M310"]},
  "WEG: M330"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[55856, 1859, 111, 2, 36, "Subsection",
      CellTags->"WEG: M330"],
    Cell[55970, 1863, 873, 16, 136, "Text",
      CellTags->"WEG: M330"],
    Cell[56846, 1881, 382, 9, 56, "Text",
      CellTags->"WEG: M330"],
    Cell[57253, 1894, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M330"],
    Cell[57314, 1897, 310, 9, 44, "BulletedList",
      CellTags->"WEG: M330"],
    Cell[57627, 1908, 222, 5, 44, "BulletedList",
      CellTags->"WEG: M330"],
    Cell[57852, 1915, 350, 9, 62, "BulletedList",
      CellTags->"WEG: M330"],
    Cell[58205, 1926, 262, 8, 44, "BulletedList",
      CellTags->"WEG: M330"],
    Cell[58470, 1936, 445, 10, 80, "BulletedList",
      CellTags->"WEG: M330"],
    Cell[58918, 1948, 380, 10, 40, "Text",
      CellTags->"WEG: M330"]},
  "WEG: M355"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[59347, 1964, 122, 2, 36, "Subsection",
      CellTags->"WEG: M355"],
    Cell[59472, 1968, 815, 20, 104, "Text",
      CellTags->"WEG: M355"],
    Cell[60312, 1992, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M355"],
    Cell[60373, 1995, 334, 9, 40, "Text",
      CellTags->"WEG: M355"],
    Cell[60710, 2006, 83, 1, 24, "Text",
      CellTags->"WEG: M355"],
    Cell[60796, 2009, 249, 8, 44, "BulletedList",
      CellTags->"WEG: M355"],
    Cell[61048, 2019, 321, 10, 44, "BulletedList",
      CellTags->"WEG: M355"],
    Cell[61372, 2031, 369, 13, 44, "BulletedList",
      CellTags->"WEG: M355"],
    Cell[61744, 2046, 299, 12, 44, "BulletedList",
      CellTags->"WEG: M355"],
    Cell[62046, 2060, 380, 10, 40, "Text",
      CellTags->"WEG: M355"]},
  "WEG: M455"->{
    Cell[20449, 657, 241, 4, 61, "Section",
      CellTags->{
      "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
        "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
        "WEG: M330", "WEG: M355", "WEG: M455"}],
    Cell[62475, 2076, 148, 5, 54, "Subsection",
      CellTags->"WEG: M455"],
    Cell[62626, 2083, 1035, 27, 120, "Text",
      CellTags->"WEG: M455"],
    Cell[63686, 2114, 58, 1, 34, "Subsubsection",
      CellTags->"WEG: M455"],
    Cell[63747, 2117, 334, 9, 40, "Text",
      CellTags->"WEG: M455"],
    Cell[64084, 2128, 85, 1, 25, "Text",
      CellTags->"WEG: M455"],
    Cell[64172, 2131, 196, 6, 27, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[64371, 2139, 286, 8, 46, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[64660, 2149, 259, 7, 46, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[64922, 2158, 450, 11, 84, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[65375, 2171, 279, 6, 46, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[65657, 2179, 513, 16, 65, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[66173, 2197, 348, 11, 46, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[66524, 2210, 183, 5, 27, "BulletedList",
      CellTags->"WEG: M455"],
    Cell[66710, 2217, 380, 10, 42, "Text",
      CellTags->"WEG: M455"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"WolframApplications", 67891, 2253},
  {"Advanced Numerical Methods", 71924, 2334},
  {"Calculus WIZ", 72176, 2339},
  {"Control System Professional", 72416, 2344},
  {"Digital Image Processing", 72684, 2349},
  {"Fuzzy Logic", 72934, 2354},
  {"Mechanical Systems", 73164, 2359},
  {"Neural Networks", 73405, 2364},
  {"NKS Explorer: Mathematica Kit", 73654, 2369},
  {"Parallel Computing Toolkit", 73929, 2374},
  {"Scientific Astronomer", 74192, 2379},
  {"Time Series", 74436, 2384},
  {"Wavelet Explorer", 74666, 2389},
  {"IndependentDeveloperApps", 74914, 2394},
  {"OtherApplications", 77094, 2445},
  {"WEG: M100", 77668, 2460},
  {"WEG: M101", 78639, 2484},
  {"WEG: M110", 79849, 2514},
  {"WEG: M125", 80742, 2536},
  {"WEG: M185", 81785, 2562},
  {"WEG: M195", 84006, 2618},
  {"WEG: M220", 86149, 2672},
  {"WEG: M215", 87443, 2704},
  {"WEG: M245", 89274, 2750},
  {"WEG: M310", 90174, 2772},
  {"WEG: M330", 91468, 2804},
  {"WEG: M355", 92521, 2830},
  {"WEG: M455", 93567, 2856}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 100, 4, 88, "Chapter"],

Cell[CellGroupData[{
Cell[1901, 61, 157, 5, 83, "Section",
  CellTags->"WolframApplications"],
Cell[2061, 68, 345, 8, 56, "Text",
  CellTags->"WolframApplications"],

Cell[CellGroupData[{
Cell[2431, 80, 141, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Advanced Numerical Methods"}],
Cell[2575, 84, 272, 5, 24, "Text",
  CellTags->{"WolframApplications", "Advanced Numerical Methods"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[2884, 94, 198, 7, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Calculus WIZ"}],
Cell[3085, 103, 249, 4, 24, "Text",
  CellTags->{"WolframApplications", "Calculus WIZ"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3371, 112, 143, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Control System Professional"}],
Cell[3517, 116, 301, 5, 24, "Text",
  CellTags->{"WolframApplications", "Control System Professional"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3855, 126, 116, 2, 34, "Subsubsection",
  CellTags->"WolframApplications"],
Cell[3974, 130, 225, 4, 24, "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4236, 139, 137, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Digital Image Processing"}],
Cell[4376, 143, 863, 24, 24, "Text",
  CellTags->{"WolframApplications", "Digital Image Processing"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5276, 172, 114, 2, 34, "Subsubsection",
  CellTags->"WolframApplications"],
Cell[5393, 176, 456, 12, 24, "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5886, 193, 108, 2, 34, "Subsubsection",
  CellTags->"WolframApplications"],
Cell[5997, 197, 442, 11, 24, "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6476, 213, 101, 2, 34, "Subsubsection",
  CellTags->"WolframApplications"],
Cell[6580, 217, 238, 4, 24, "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6855, 226, 111, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Fuzzy Logic"}],
Cell[6969, 230, 269, 5, 24, "Text",
  CellTags->{"WolframApplications", "Fuzzy Logic"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7275, 240, 166, 6, 34, "Subsubsection",
  CellTags->"WolframApplications"],
Cell[7444, 248, 217, 4, 24, "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7698, 257, 125, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Mechanical Systems"}],
Cell[7826, 261, 255, 4, 24, "Text",
  CellTags->{"WolframApplications", "Mechanical Systems"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8118, 270, 119, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Neural Networks"}],
Cell[8240, 274, 273, 5, 24, "Text",
  CellTags->{"WolframApplications", "Neural Networks"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8550, 284, 185, 2, 34, "Subsubsection",
  CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}],
Cell[8738, 288, 773, 20, 24, "Text",
  CellTags->{"NKS Explorer: Mathematica Kit", "WolframApplications"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9548, 313, 141, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Parallel Computing Toolkit"}],
Cell[9692, 317, 262, 4, 24, "Text",
  CellTags->{"WolframApplications", "Parallel Computing Toolkit"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9991, 326, 131, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Scientific Astronomer"}],
Cell[10125, 330, 294, 5, 24, "Text",
  CellTags->{"WolframApplications", "Scientific Astronomer"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10456, 340, 102, 2, 34, "Subsubsection",
  CellTags->"WolframApplications"],
Cell[10561, 344, 265, 5, 24, "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10863, 354, 103, 2, 34, "Subsubsection",
  CellTags->"WolframApplications"],
Cell[10969, 358, 260, 5, 24, "Text",
  CellTags->"WolframApplications"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11266, 368, 111, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Time Series"}],
Cell[11380, 372, 275, 5, 24, "Text",
  CellTags->{"WolframApplications", "Time Series"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11692, 382, 121, 2, 34, "Subsubsection",
  CellTags->{"WolframApplications", "Wavelet Explorer"}],
Cell[11816, 386, 252, 4, 24, "Text",
  CellTags->{"WolframApplications", "Wavelet Explorer"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12117, 396, 164, 5, 83, "Section",
  CellTags->"IndependentDeveloperApps"],
Cell[12284, 403, 350, 8, 56, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[12637, 413, 242, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[12882, 420, 250, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[13135, 427, 411, 13, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[13549, 442, 249, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[13801, 449, 269, 6, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[14073, 457, 259, 6, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[14335, 465, 250, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[14588, 472, 250, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[14841, 479, 239, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[15083, 486, 241, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[15327, 493, 256, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[15586, 500, 248, 6, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[15837, 508, 252, 6, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[16092, 516, 257, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[16352, 523, 241, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[16596, 530, 263, 6, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[16862, 538, 236, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[17101, 545, 256, 6, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[17360, 553, 237, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[17600, 560, 240, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[17843, 567, 248, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[18094, 574, 255, 6, 24, "Text",
  CellTags->"IndependentDeveloperApps"],
Cell[18352, 582, 231, 5, 24, "Text",
  CellTags->"IndependentDeveloperApps"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18620, 592, 199, 8, 61, "Section",
  CellTags->"OtherApplications"],
Cell[18822, 602, 343, 8, 56, "Text",
  CellTags->"OtherApplications"],
Cell[19168, 612, 232, 5, 24, "Text",
  CellTags->"OtherApplications"],
Cell[19403, 619, 240, 5, 24, "Text",
  CellTags->"OtherApplications"],
Cell[19646, 626, 265, 6, 24, "Text",
  CellTags->"OtherApplications"],
Cell[19914, 634, 236, 5, 24, "Text",
  CellTags->"OtherApplications"],
Cell[20153, 641, 177, 6, 24, "Text",
  CellTags->"OtherApplications"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20379, 653, 45, 0, 88, "Chapter"],

Cell[CellGroupData[{
Cell[20449, 657, 241, 4, 61, "Section",
  CellTags->{
  "WEG: M100", "WEG: M101", "WEG: M110", "WEG: M125", "WEG: M185", 
    "WEG: M195", "WEG: M220", "WEG: M215", "WEG: M245", "WEG: M310", 
    "WEG: M330", "WEG: M355", "WEG: M455"}],

Cell[CellGroupData[{
Cell[20715, 665, 126, 2, 36, "Subsection",
  CellTags->"WEG: M100"],
Cell[20844, 669, 744, 19, 88, "Text",
  CellTags->"WEG: M100"],

Cell[CellGroupData[{
Cell[21613, 692, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M100"],
Cell[21674, 695, 309, 8, 44, "BulletedList",
  CellTags->"WEG: M100"],
Cell[21986, 705, 266, 8, 44, "BulletedList",
  CellTags->"WEG: M100"],
Cell[22255, 715, 255, 8, 44, "BulletedList",
  CellTags->"WEG: M100"],
Cell[22513, 725, 301, 10, 44, "BulletedList",
  CellTags->"WEG: M100"],
Cell[22817, 737, 202, 7, 26, "BulletedList",
  CellTags->"WEG: M100"],
Cell[23022, 746, 380, 10, 40, "Text",
  CellTags->"WEG: M100"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23451, 762, 125, 2, 36, "Subsection",
  CellTags->"WEG: M101"],
Cell[23579, 766, 747, 17, 104, "Text",
  CellTags->"WEG: M101"],

Cell[CellGroupData[{
Cell[24351, 787, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M101"],
Cell[24412, 790, 368, 9, 62, "BulletedList",
  CellTags->"WEG: M101"],
Cell[24783, 801, 372, 11, 62, "BulletedList",
  CellTags->"WEG: M101"],
Cell[25158, 814, 278, 8, 44, "BulletedList",
  CellTags->"WEG: M101"],
Cell[25439, 824, 246, 6, 44, "BulletedList",
  CellTags->"WEG: M101"],
Cell[25688, 832, 219, 6, 44, "BulletedList",
  CellTags->"WEG: M101"],
Cell[25910, 840, 366, 11, 44, "BulletedList",
  CellTags->"WEG: M101"],
Cell[26279, 853, 254, 8, 44, "BulletedList",
  CellTags->"WEG: M101"],
Cell[26536, 863, 310, 8, 44, "BulletedList",
  CellTags->"WEG: M101"],
Cell[26849, 873, 380, 10, 40, "Text",
  CellTags->"WEG: M101"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27278, 889, 131, 2, 36, "Subsection",
  CellTags->"WEG: M110"],
Cell[27412, 893, 716, 16, 104, "Text",
  CellTags->"WEG: M110"],

Cell[CellGroupData[{
Cell[28153, 913, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M110"],
Cell[28214, 916, 488, 14, 62, "BulletedList",
  CellTags->"WEG: M110"],
Cell[28705, 932, 252, 6, 44, "BulletedList",
  CellTags->"WEG: M110"],
Cell[28960, 940, 383, 9, 62, "BulletedList",
  CellTags->"WEG: M110"],
Cell[29346, 951, 359, 8, 62, "BulletedList",
  CellTags->"WEG: M110"],
Cell[29708, 961, 380, 10, 40, "Text",
  CellTags->"WEG: M110"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30137, 977, 147, 5, 54, "Subsection",
  CellTags->"WEG: M125"],
Cell[30287, 984, 638, 14, 88, "Text",
  CellTags->"WEG: M125"],

Cell[CellGroupData[{
Cell[30950, 1002, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M125"],
Cell[31011, 1005, 333, 9, 40, "Text",
  CellTags->"WEG: M125"],
Cell[31347, 1016, 128, 4, 24, "Text",
  CellTags->"WEG: M125"],
Cell[31478, 1022, 304, 8, 44, "BulletedList",
  CellTags->"WEG: M125"],
Cell[31785, 1032, 523, 14, 79, "BulletedList",
  CellTags->"WEG: M125"],
Cell[32311, 1048, 408, 11, 62, "BulletedList",
  CellTags->"WEG: M125"],
Cell[32722, 1061, 317, 7, 62, "BulletedList",
  CellTags->"WEG: M125"],
Cell[33042, 1070, 380, 10, 40, "Text",
  CellTags->"WEG: M125"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33471, 1086, 126, 2, 36, "Subsection",
  CellTags->"WEG: M185"],
Cell[33600, 1090, 410, 9, 72, "Text",
  CellTags->"WEG: M185"],

Cell[CellGroupData[{
Cell[34035, 1103, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M185"],
Cell[34096, 1106, 458, 11, 56, "Text",
  CellTags->"WEG: M185"],
Cell[34557, 1119, 123, 2, 24, "Text",
  CellTags->"WEG: M185"],
Cell[34683, 1123, 123, 2, 26, "ItemizedText",
  CellTags->"WEG: M185"],
Cell[34809, 1127, 69, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[34881, 1130, 98, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[34982, 1133, 188, 6, 26, "ItemizedText",
  CellTags->"WEG: M185"],
Cell[35173, 1141, 68, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[35244, 1144, 73, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[35320, 1147, 71, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[35394, 1150, 88, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[35485, 1153, 137, 5, 24, "Text",
  CellTags->"WEG: M185"],
Cell[35625, 1160, 118, 2, 26, "ItemizedText",
  CellTags->"WEG: M185"],
Cell[35746, 1164, 70, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[35819, 1167, 74, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[35896, 1170, 71, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[35970, 1173, 94, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[36067, 1176, 126, 2, 26, "ItemizedText",
  CellTags->"WEG: M185"],
Cell[36196, 1180, 88, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[36287, 1183, 76, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[36366, 1186, 70, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[36439, 1189, 78, 1, 26, "BulletedList",
  CellTags->"WEG: M185"],
Cell[36520, 1192, 380, 10, 40, "Text",
  CellTags->"WEG: M185"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36949, 1208, 114, 2, 36, "Subsection",
  CellTags->"WEG: M195"],
Cell[37066, 1212, 430, 10, 56, "Text",
  CellTags->"WEG: M195"],

Cell[CellGroupData[{
Cell[37521, 1226, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M195"],
Cell[37582, 1229, 857, 19, 104, "Text",
  CellTags->"WEG: M195"],
Cell[38442, 1250, 123, 2, 24, "Text",
  CellTags->"WEG: M195"],
Cell[38568, 1254, 77, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[38648, 1257, 127, 4, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[38778, 1263, 131, 4, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[38912, 1269, 180, 6, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[39095, 1277, 102, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[39200, 1280, 91, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[39294, 1283, 145, 4, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[39442, 1289, 111, 2, 24, "Text",
  CellTags->"WEG: M195"],
Cell[39556, 1293, 86, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[39645, 1296, 103, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[39751, 1299, 201, 6, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[39955, 1307, 205, 6, 44, "BulletedList",
  CellTags->"WEG: M195"],
Cell[40163, 1315, 96, 2, 24, "Text",
  CellTags->"WEG: M195"],
Cell[40262, 1319, 81, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[40346, 1322, 98, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[40447, 1325, 135, 4, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[40585, 1331, 65, 1, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[40653, 1334, 452, 16, 26, "BulletedList",
  CellTags->"WEG: M195"],
Cell[41108, 1352, 380, 10, 40, "Text",
  CellTags->"WEG: M195"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[41537, 1368, 198, 7, 54, "Subsection",
  CellTags->"WEG: M215"],
Cell[41738, 1377, 735, 15, 104, "Text",
  CellTags->"WEG: M215"],

Cell[CellGroupData[{
Cell[42498, 1396, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M215"],
Cell[42559, 1399, 454, 10, 56, "Text",
  CellTags->"WEG: M215"],
Cell[43016, 1411, 296, 10, 40, "Text",
  CellTags->"WEG: M215"],
Cell[43315, 1423, 136, 4, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[43454, 1429, 140, 4, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[43597, 1435, 191, 5, 44, "BulletedList",
  CellTags->"WEG: M215"],
Cell[43791, 1442, 126, 4, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[43920, 1448, 154, 4, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44077, 1454, 77, 1, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44157, 1457, 260, 9, 24, "Text",
  CellTags->"WEG: M215"],
Cell[44420, 1468, 141, 4, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44564, 1474, 80, 1, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44647, 1477, 97, 1, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44747, 1480, 69, 1, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44819, 1483, 92, 1, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44914, 1486, 78, 1, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[44995, 1489, 82, 1, 26, "BulletedList",
  CellTags->"WEG: M215"],
Cell[45080, 1492, 380, 10, 40, "Text",
  CellTags->"WEG: M215"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45509, 1508, 122, 2, 36, "Subsection",
  CellTags->"WEG: M220"],
Cell[45634, 1512, 748, 14, 120, "Text",
  CellTags->"WEG: M220"],
Cell[46385, 1528, 356, 10, 56, "Text",
  CellTags->"WEG: M220"],

Cell[CellGroupData[{
Cell[46766, 1542, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M220"],
Cell[46827, 1545, 344, 9, 62, "BulletedList",
  CellTags->"WEG: M220"],
Cell[47174, 1556, 373, 11, 44, "BulletedList",
  CellTags->"WEG: M220"],
Cell[47550, 1569, 236, 7, 44, "BulletedList",
  CellTags->"WEG: M220"],
Cell[47789, 1578, 232, 6, 44, "BulletedList",
  CellTags->"WEG: M220"],
Cell[48024, 1586, 218, 7, 26, "BulletedList",
  CellTags->"WEG: M220"],
Cell[48245, 1595, 296, 9, 44, "BulletedList",
  CellTags->"WEG: M220"],
Cell[48544, 1606, 304, 8, 44, "BulletedList",
  CellTags->"WEG: M220"],
Cell[48851, 1616, 181, 5, 26, "BulletedList",
  CellTags->"WEG: M220"],
Cell[49035, 1623, 380, 10, 40, "Text",
  CellTags->"WEG: M220"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49464, 1639, 116, 2, 36, "Subsection",
  CellTags->"WEG: M245"],
Cell[49583, 1643, 594, 15, 88, "Text",
  CellTags->"WEG: M245"],

Cell[CellGroupData[{
Cell[50202, 1662, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M245"],
Cell[50263, 1665, 469, 16, 44, "BulletedList",
  CellTags->"WEG: M245"],
Cell[50735, 1683, 258, 8, 44, "BulletedList",
  CellTags->"WEG: M245"],
Cell[50996, 1693, 214, 7, 26, "BulletedList",
  CellTags->"WEG: M245"],
Cell[51213, 1702, 186, 7, 26, "BulletedList",
  CellTags->"WEG: M245"],
Cell[51402, 1711, 380, 10, 40, "Text",
  CellTags->"WEG: M245"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51831, 1727, 120, 2, 36, "Subsection",
  CellTags->"WEG: M310"],
Cell[51954, 1731, 857, 17, 120, "Text",
  CellTags->"WEG: M310"],
Cell[52814, 1750, 348, 8, 56, "Text",
  CellTags->"WEG: M310"],

Cell[CellGroupData[{
Cell[53187, 1762, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M310"],
Cell[53248, 1765, 307, 10, 44, "BulletedList",
  CellTags->"WEG: M310"],
Cell[53558, 1777, 334, 8, 62, "BulletedList",
  CellTags->"WEG: M310"],
Cell[53895, 1787, 305, 8, 44, "BulletedList",
  CellTags->"WEG: M310"],
Cell[54203, 1797, 266, 8, 44, "BulletedList",
  CellTags->"WEG: M310"],
Cell[54472, 1807, 233, 7, 26, "BulletedList",
  CellTags->"WEG: M310"],
Cell[54708, 1816, 220, 6, 44, "BulletedList",
  CellTags->"WEG: M310"],
Cell[54931, 1824, 203, 5, 44, "BulletedList",
  CellTags->"WEG: M310"],
Cell[55137, 1831, 287, 10, 44, "BulletedList",
  CellTags->"WEG: M310"],
Cell[55427, 1843, 380, 10, 40, "Text",
  CellTags->"WEG: M310"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55856, 1859, 111, 2, 36, "Subsection",
  CellTags->"WEG: M330"],
Cell[55970, 1863, 873, 16, 136, "Text",
  CellTags->"WEG: M330"],
Cell[56846, 1881, 382, 9, 56, "Text",
  CellTags->"WEG: M330"],

Cell[CellGroupData[{
Cell[57253, 1894, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M330"],
Cell[57314, 1897, 310, 9, 44, "BulletedList",
  CellTags->"WEG: M330"],
Cell[57627, 1908, 222, 5, 44, "BulletedList",
  CellTags->"WEG: M330"],
Cell[57852, 1915, 350, 9, 62, "BulletedList",
  CellTags->"WEG: M330"],
Cell[58205, 1926, 262, 8, 44, "BulletedList",
  CellTags->"WEG: M330"],
Cell[58470, 1936, 445, 10, 80, "BulletedList",
  CellTags->"WEG: M330"],
Cell[58918, 1948, 380, 10, 40, "Text",
  CellTags->"WEG: M330"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59347, 1964, 122, 2, 36, "Subsection",
  CellTags->"WEG: M355"],
Cell[59472, 1968, 815, 20, 104, "Text",
  CellTags->"WEG: M355"],

Cell[CellGroupData[{
Cell[60312, 1992, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M355"],
Cell[60373, 1995, 334, 9, 40, "Text",
  CellTags->"WEG: M355"],
Cell[60710, 2006, 83, 1, 24, "Text",
  CellTags->"WEG: M355"],
Cell[60796, 2009, 249, 8, 44, "BulletedList",
  CellTags->"WEG: M355"],
Cell[61048, 2019, 321, 10, 44, "BulletedList",
  CellTags->"WEG: M355"],
Cell[61372, 2031, 369, 13, 44, "BulletedList",
  CellTags->"WEG: M355"],
Cell[61744, 2046, 299, 12, 44, "BulletedList",
  CellTags->"WEG: M355"],
Cell[62046, 2060, 380, 10, 40, "Text",
  CellTags->"WEG: M355"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62475, 2076, 148, 5, 54, "Subsection",
  CellTags->"WEG: M455"],
Cell[62626, 2083, 1035, 27, 120, "Text",
  CellTags->"WEG: M455"],

Cell[CellGroupData[{
Cell[63686, 2114, 58, 1, 34, "Subsubsection",
  CellTags->"WEG: M455"],
Cell[63747, 2117, 334, 9, 40, "Text",
  CellTags->"WEG: M455"],
Cell[64084, 2128, 85, 1, 25, "Text",
  CellTags->"WEG: M455"],
Cell[64172, 2131, 196, 6, 27, "BulletedList",
  CellTags->"WEG: M455"],
Cell[64371, 2139, 286, 8, 46, "BulletedList",
  CellTags->"WEG: M455"],
Cell[64660, 2149, 259, 7, 46, "BulletedList",
  CellTags->"WEG: M455"],
Cell[64922, 2158, 450, 11, 84, "BulletedList",
  CellTags->"WEG: M455"],
Cell[65375, 2171, 279, 6, 46, "BulletedList",
  CellTags->"WEG: M455"],
Cell[65657, 2179, 513, 16, 65, "BulletedList",
  CellTags->"WEG: M455"],
Cell[66173, 2197, 348, 11, 46, "BulletedList",
  CellTags->"WEG: M455"],
Cell[66524, 2210, 183, 5, 27, "BulletedList",
  CellTags->"WEG: M455"],
Cell[66710, 2217, 380, 10, 42, "Text",
  CellTags->"WEG: M455"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

