(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    456744,      14463]*)
(*NotebookOutlinePosition[    549949,      16950]*)
(*  CellTagsIndexPosition[    546466,      16848]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " User Guide"
}], "Title",
  TextAlignment->Center],

Cell[TextData[StyleBox["\nTodd Gayley\nVersion 1.2\nSeptember, 2004", "SB"]],
  TextAlignment->Center],

Cell[TextData[{
  "\n\n\n\n\n\n\n\nCopyright (C) 2004 by Wolfram Research, Inc. All rights \
reserved.\n",
  StyleBox["Mathematica", "TI"],
  " and ",
  StyleBox["MathLink", "TI"],
  " are trademarks of Wolfram Research."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction", "Chapter"],

Cell[CellGroupData[{

Cell[TextData[StyleBox[".NET/Link",
  FontSlant->"Italic"]], "Section",
  CellTags->{".NET/Link", "nlug:1.0"}],

Cell[TextData[{
  "Welcome to ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", a product that integrates ",
  StyleBox["Mathematica", "TI"],
  " and Microsoft's .NET platform. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " lets you call .NET from ",
  StyleBox["Mathematica", "TI"],
  " in a completely transparent way, and allows you to use and control the ",
  StyleBox["Mathematica", "TI"],
  " kernel from a .NET program. For ",
  StyleBox["Mathematica", "TI"],
  " users, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " makes the entire .NET world an automatic extension to the ",
  StyleBox["Mathematica", "TI"],
  " environment. For .NET programmers, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " turns ",
  StyleBox["Mathematica", "TI"],
  " into a scripting shell that lets you experiment with, build, and test \
.NET classes a line at a time. It also makes .NET an ideal environment for \
writing programs that use the computational services of ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->"nlug:1.0"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s most unique feature is that it lets you load arbitrary \
.NET types into ",
  StyleBox["Mathematica", "TI"],
  " and then create .NET objects, call methods, properties, and so on, \
directly from the ",
  StyleBox["Mathematica", "TI"],
  " language. Thus, you can use ",
  StyleBox["Mathematica", "TI"],
  " to \[OpenCurlyDoubleQuote]script\[CloseCurlyDoubleQuote] the \
functionality of an arbitrary .NET program\[LongDash]in effect, write a .NET \
program in ",
  StyleBox["Mathematica", "TI"],
  ". Essentially anything you can do from .NET, you can now do from ",
  StyleBox["Mathematica", "TI"],
  " perhaps even more easily because you are working in a true interpreted \
environment."
}], "Text",
  CellTags->"nlug:1.0"],

Cell[TextData[{
  ".NET/Link also lets you do some very useful things that do not appear to \
directly involve the .NET runtime. These include calling C-style DLL \
functions directly from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and creating and scripting COM objects, much like Visual Basic can do."
}], "Text",
  CellTags->"nlug:1.0"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is designed for end-users and developers alike. The same features that \
let ",
  StyleBox["Mathematica", "TI"],
  " users transparently call any .NET method also let developers create \
sophisticated commercial add-ons to ",
  StyleBox["Mathematica", "TI"],
  ". Programmers who want to write custom front ends for ",
  StyleBox["Mathematica", "TI"],
  " or use ",
  StyleBox["Mathematica", "TI"],
  " as a computational engine for another program will find using .NET with \
",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is easier than using the traditional ",
  StyleBox["MathLink", "TI"],
  " interface from C or C++."
}], "Text",
  CellTags->"nlug:1.0"],

Cell[TextData[{
  StyleBox["Finally, ",
    FormatType->InputForm],
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  StyleBox[" comes with full source code. You can examine the code to \
supplement the documentation, get tips for your own programs, better \
understand how to use advanced features, or just see how it works.",
    FormatType->InputForm]
}], "Text",
  CellTags->"nlug:1.0"],

Cell[TextData[{
  "Some familiarity with both the .NET Framework and ",
  StyleBox["Mathematica", "TI"],
  " is assumed in this manual. In Part 2, which covers writing .NET programs \
that call ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", major examples are generally provided in both C# and Visual Basic .NET \
versions, although overall the documentation is perhaps slightly more \
C#-centric. Naturally, when writing .NET programs that use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", you can use any .NET-aware languiage, not just C# and Visual Basic \
.NET."
}], "Text",
  CellTags->"nlug:1.0"],

Cell[TextData[{
  "Part 1 of this User Guide describes how you use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to call .NET from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and Part 2 describes how to call ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from .NET."
}], "Text",
  CellTags->"nlug:1.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["What is .NET?", "Section",
  CellTags->"nlug:1.1"],

Cell["\<\
.NET is a new development platform for Windows programming. It replaces \
essentially everything that came before it, including an entire alphabet soup \
of programming technologies such as MFC, COM, ActiveX, ATL, ASP, ADO, and \
many others. Although Microsoft emphasizes XML Web Services in conjunction \
with .NET, XML Web Services are only a small part of the .NET platform, and \
the success of .NET is not dependent on the widespread adoption of XML Web \
Services.\
\>", "Text",
  CellTags->"nlug:1.1"],

Cell["\<\
.NET represents the future of Windows programming, and Microsoft is rapidly \
shifting more and more of its technology and products to a .NET foundation.\
\>", "Text",
  CellTags->"nlug:1.1"],

Cell["\<\
At the core of .NET is a runtime engine, similar to that used by Java, that \
loads and executes programs compiled into special bytecodes that the runtime \
understands. This runtime is called the Common Language Runtime (CLR), but we \
will often refer to it as the .NET runtime. A key feature of this system is \
that many languages can be compiled into CLR bytecodes and executed by the \
runtime. This means that .NET is language-neutral, supporting any programming \
language for which a .NET compiler is available. Microsoft provides compilers \
for C#, Visual Basic .NET, JScript, Visual J# .NET, and C++ With Managed \
Extensions. Many other compilers exist, including ones for Fortran, Perl, \
Python, Eiffel, COBOL. You can even create a class in one .NET language, say \
Visual Basic .NET, and subclass it in another language.\
\>", "Text",
  CellTags->"nlug:1.1"],

Cell["\<\
Although .NET is language-neutral, probably the two most important .NET \
languages are Visual Basic .NET, a modification of the Visual Basic language, \
and C#, a new language that is similar in many ways to Java.\
\>", "Text",
  CellTags->"nlug:1.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "What is ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "?"
}], "Section",
  CellTags->"nlug:1.2"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " is Wolfram Research\[CloseCurlyQuote]s protocol for sending data and \
commands back and forth between ",
  StyleBox["Mathematica", "TI"],
  " and other programs. ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is the underlying glue that lets .NET and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " talk to each other. When calling .NET from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " completely hides the low-level details of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " communication, allowing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programmers to load and use .NET classes as if they were part of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " environment itself. When writing .NET programs that call ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides a higher-level layer of functionality than the traditional C ",
  StyleBox["MathLink", "TI"],
  " programming interface."
}], "Text",
  CellTags->"nlug:1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How Does ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " Compare to ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  "?"
}], "Section",
  CellTags->"nlug:1.3"],

Cell[TextData[{
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " is an existing Wolfram Research product that integrates Java and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in almost exactly the same way that ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " integrates .NET and ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " You will find the ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " User Guide right above this ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " User Guide in the ",
  StyleBox["Add-ons & Links", "SR"],
  " category of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Help Browser. You can use ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " to do many of the same things you can do with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " and vice versa. Because it is based on Java, ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " has the advantage of being cross-platform. If you want to write programs \
that run on every ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " platform, you should use ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". On the other hand, .NET integrates more tightly with the Windows \
operating system than Java does, so if you want to do Windows-specific \
things, or you want a very native Windows look and feel, you should use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". On Windows, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " also does some things that ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " cannot, such as allowing you to call C-style DLL functions directly from \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or controlling COM objects."
}], "Text",
  CellTags->"nlug:1.3"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " and ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " provide a very similar programming model. Familiarity with one will be \
very helpful when working with the other."
}], "Text",
  CellTags->"nlug:1.3"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installation", "Chapter",
  CellTags->"nlug:2"],

Cell[CellGroupData[{

Cell["Install the NETLink directory into your AddOns directory", \
"Subsubsection",
  CellTags->"nlug:2"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is already installed in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.0 and later. If you download an update to ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " for use with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.0 and later, simply replace the existing ",
  StyleBox["<", "MR"],
  StyleBox["Mathematica", "MR",
    FontSlant->"Italic"],
  StyleBox[" dir>\\AddOns\\NETLink", "MR"],
  " directory with the new one."
}], "Text",
  CellTags->"nlug:2"],

Cell[TextData[{
  "If you downloaded ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to install into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.x, place the ",
  StyleBox["NETLink", "MR"],
  " directory into your ",
  StyleBox["<", "MR"],
  StyleBox["Mathematica", "MR",
    FontSlant->"Italic"],
  StyleBox[" dir>\\AddOns\\Applications", "MR"],
  " directory. Note that this location is different than in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.0."
}], "Text",
  CellTags->"nlug:2"],

Cell[TextData[{
  "You also need to be sure that you have ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " 3.0 or later, which first became available in September 2004 and shipped \
with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1. Although .",
  StyleBox["NET/Link",
    FontSlant->"Italic"],
  " does not use Java in any way, it shares some ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code with ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ". You can get the latest ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " for any version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from the ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " ",
  ButtonBox["home page",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/mathlink/jlink"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"nlug:2"],

Cell[TextData[{
  "The ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " assembly, ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  ", is not a strong-named assembly and therefore cannot be placed into the \
Global Assembly Cache (GAC). In previous versions of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", the assembly was strong-named and was placed into the GAC by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer."
}], "Text",
  CellTags->"nlug:2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Get the .NET Framework", "Subsubsection",
  CellTags->"nlug:2"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " requires Version 1.1 of the .NET Framework. The easiest way to install \
the .NET Framework, if you do not already have it, is to get it from the ",
  ButtonBox["Windows Update",
    ButtonData:>{
      URL[ "http://windowsupdate.microsoft.com"], None},
    ButtonStyle->"Hyperlink"],
  " website. If you do not have the correct version of the .NET Framework, \
you will get a message telling you so when you first call ",
  StyleBox["InstallNET", "MR"],
  "."
}], "Text",
  CellTags->"nlug:2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Part 1.  Calling .NET from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ": ",
  "\[OpenCurlyDoubleQuote]",
  "Installable .NET\[CloseCurlyDoubleQuote]"
}], "Chapter"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"nlug:3.0"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides ",
  StyleBox["Mathematica", "TI"],
  " users with the ability to interact with arbitrary .NET types directly \
from ",
  StyleBox["Mathematica", "TI"],
  ". You can create objects and call methods and properties directly in the \
",
  StyleBox["Mathematica", "TI"],
  " language. You do not need to write any .NET code, or prepare in any way \
the .NET types you want to use. You also do not need to know anything about \
",
  StyleBox["MathLink", "TI"],
  ". In effect, all of .NET becomes a transparent extension to ",
  StyleBox["Mathematica", "TI"],
  ", almost as if every existing and future .NET type were written in the ",
  StyleBox["Mathematica", "TI"],
  " language itself."
}], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[{
  "We call this facility \[OpenCurlyDoubleQuote]installable .NET\
\[CloseCurlyDoubleQuote] because it generalizes the ability that ",
  StyleBox["Mathematica", "TI"],
  " has always had to plug in extensions written in other languages through \
the ",
  StyleBox["Install", "MR"],
  " function. Compared to other languages like C or C++, however, .NET",
  StyleBox["/Link",
    FontSlant->"Italic"],
  " makes the intermediate steps go away completely, which is why we say that \
.NET becomes a ",
  StyleBox["transparent",
    FontSlant->"Italic"],
  " extension to ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[{
  "Although .NET is sometimes referred to as an interpreted environment, this \
is really a misnomer. To use .NET you must write a complete program in a \
language like C#, compile it, and then execute it. ",
  StyleBox["Mathematica", "TI"],
  " users have the luxury of working in a true interpreted, interactive \
environment that lets them experiment with functions and build and test \
programs a line at a time. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " brings this same productive environment to .NET programmers. You could \
say that ",
  StyleBox["Mathematica", "TI"],
  " becomes a scripting language for .NET."
}], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[{
  "To ",
  StyleBox["Mathematica", "TI"],
  " users, then, the \[OpenCurlyDoubleQuote]installable .NET\
\[CloseCurlyDoubleQuote] feature of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " opens up the universe of .NET types as an extension to ",
  StyleBox["Mathematica", "TI"],
  "; for .NET users, it allows the extraordinarily powerful and versatile ",
  StyleBox["Mathematica", "TI"],
  " environment to be used as a shell for interactively developing, \
experimenting with, and testing .NET programs."
}], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[{
  "This section of the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " User Guide discusses calling from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " into the .NET runtime. You will see how to load .NET assemblies and types \
into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", create objects of these types, call methods and properties, and so on. \
You will also learn how to use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to call COM objects as well as standard C-style DLL functions."
}], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[StyleBox["Simple Examples:",
  FontWeight->"Bold"]], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["ProcessPriority.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", 
        "Part1"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[StyleBox["GUI Examples:",
  FontWeight->"Bold"]], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["Circumcircle.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["PackageHelper.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["SimpleAnimationWindow.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["RealTimeAlgebra.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["AsteroidsGame.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs", "AsteroidsGame"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[StyleBox["Calling DLLs:",
  FontWeight->"Bold"]], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["BZip2Compression.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling DLLs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["EnumWindows.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling DLLs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["WindowsAPI.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling DLLs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"],

Cell[TextData[StyleBox["Calling COM Objects:",
  FontWeight->"Bold"]], "Text",
  CellTags->"nlug:3.0"],

Cell[TextData[ButtonBox["ExcelPieChart.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling COM"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " Basics"
}], "Section"],

Cell[CellGroupData[{

Cell["Loading the NETLink` Package", "Subsection",
  CellTags->"nlug:3.1.0"],

Cell[TextData[{
  "You must load the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " package before you can use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.1.0"],

Cell["Needs[\"NETLink`\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.1.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Launching the .NET Runtime", "Subsection",
  CellTags->"nlug:3.1.1"],

Cell[TextData[{
  "The ",
  StyleBox["InstallNET", "MR"],
  " function is used to launch the .NET runtime."
}], "Text",
  CellTags->"nlug:3.1.1"],

Cell["InstallNET[];", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.1.1"],

Cell[TextData[{
  "If you are actively developing .NET classes and other types to use in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you will need to restart the .NET runtime before you can reload a \
modified version of a class. Use the ",
  StyleBox["ReinstallNET", "MR"],
  " function to quit and restart the .NET runtime. Most users will have no \
need to ever quit or restart .NET and should avoid calling ",
  StyleBox["ReinstallNET", "MR"],
  " or ",
  StyleBox["UninstallNET", "MR"],
  ". Remember that the .NET runtime is shared by potentially many programs in \
your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session. Shutting down or restarting the .NET runtime could have \
unexpected consequences for those programs."
}], "Text",
  CellTags->"nlug:3.1.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(InstallNET[]\),
              "MR"], Cell[TextData[{
              "launch the .NET runtime and prepare it for use from ",
              StyleBox["Mathematica",
                FontSlant->"Italic"]
            }], "Text",
              CellTags->"jlug:5.2.2.1"]},
          {
            StyleBox[\(ReinstallNET[]\),
              "MR"], Cell["quit and restart the .NET runtime", "Text",
              CellTags->"jlug:5.2.2.1"]},
          {
            StyleBox[\(NETLink[]\),
              "MR"], Cell[TextData[{
              "give the ",
              StyleBox["LinkObject", "MR"],
              " that is being used to communicate with the .NET runtime"
            }], "Text",
              CellTags->"jlug:5.2.2.1"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.1.1"],

Cell["Launching the .NET runtime.", "Caption",
  CellTags->"nlug:3.1.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Loading .NET Assemblies and Types", "Subsection",
  CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"}],

Cell[CellGroupData[{

Cell[".NET Assemblies", "Subsubsection",
  CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"}],

Cell[TextData[{
  "Programs and libraries for .NET are packaged into units called ",
  StyleBox["assemblies",
    FontSlant->"Italic"],
  ". An assembly can be defined as a versioned, self-describing binary (DLL \
or EXE) containing a collection of types (classes, interfaces, structs, and \
so on) and optional resources. An assembly can span multiple files (a ",
  StyleBox["multi-file assembly",
    FontSlant->"Italic"],
  "), or a single file can contain more than one assembly, but in the typical \
case an assembly consists of a single DLL or EXE file. Although .NET \
assemblies can have the DLL extension, internally they are quite different \
from old C-style DLLs. Conceptually, though, a .NET DLL is similar to a \
C-style DLL in that they are both libraries of code intended to be loaded and \
called by other programs. An EXE assembly is an executable program that can \
be launched directly, but it also can export types like a DLL for use by \
other programs."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Assemblies can be located anywhere on your system. The .NET Framework \
maintains a special location on your system where assemblies can be stored so \
that they can easily be found by all .NET programs on the system. This \
location is called the Global Assembly Cache (GAC), and is found in the ",
  StyleBox["assembly", "MR"],
  " subdirectory of your root Windows directory. The assemblies that are part \
of the .NET Framework itself are located in the GAC, and many .NET programs \
that you install will put assemblies there. There is no requirement that an \
assembly be placed into the GAC, and ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " can use assemblies located anywhere on your system."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Because all .NET types are packaged into assemblies, to load a type into \
",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "you first need to load its assembly. You use the ",
  StyleBox["LoadNETAssembly", "MR"],
  " function to load an assembly into ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". Assemblies can be loaded by specifying various types of information \
about the assembly, such as a full path to the assembly file, or by a full or \
partial name of the assembly. Assembly names will be discussed in more detail \
later, but for now it suffices to say that assembly names are assigned by \
their creators, and may bear no resemblance to the name of the actual \
assembly file. An example of a simple assembly name is ",
  StyleBox["System.XML", "MR"],
  ", which is the assembly in the .NET Framework that handles XML-related \
functionality. Assemblies are often named after the most important namespace \
they define. The actual file name of the ",
  StyleBox["System.XML", "MR"],
  " assembly is ",
  StyleBox["System.XML.dll", "MR"],
  ", and it is located somewhere nested deep down inside the GAC."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " does not need to be explicitly instructed to load all assemblies. It will \
automatically load any of the .NET Framework assemblies, meaning all of the \
assemblies containing types whose names start with ",
  StyleBox["System", "MR"],
  ". (e.g., ",
  StyleBox["System.Windows.Forms.Form", "MR"],
  ", ",
  StyleBox["System.Drawing.Rectangle", "MR"],
  ", ",
  StyleBox["System.Data.DataSet", "MR"],
  ", and so on). Most of the types that you will use in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " programming are found in the system assemblies. You will have to manually \
load other assemblies. The ",
  StyleBox["LoadNETAssembly", "MR"],
  " function, described later in this section, is the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function you use to load assemblies into ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " and prepare them to be used from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell[".NET Types", "Subsubsection",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "A ",
  StyleBox["type",
    FontSlant->"Italic"],
  " is the fundamental unit of .NET programming. Every type falls into one of \
the following categories: classes, interfaces, structs (\"value types\"), \
enumerations, and delegates. Every object in .NET is an instance of some \
type. Although the set of types is broader than just classes, you might find \
it easier to think of types as being classes."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Types are defined in assemblies. To load and use a type in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", you must first load the assembly in which it resides and then load the \
type itself. Often these steps can be combined into a single operation. ",
  StyleBox["LoadNETType", "MR"],
  ", described later in this section, is the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that you use to load types into ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " so they can be used from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["LoadNETAssembly", "Subsubsection",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  StyleBox["LoadNETAssembly", "MR"],
  " is the function you use to load assemblies into ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " so that the types they contain can be used from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". ",
  StyleBox["LoadNETAssembly", "MR"],
  " has a number of different argument sequences. Although all these \
different possible arguments might seem confusing, the basic principle is to \
allow virtually any way of specifying enough information about the assembly \
so that ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " can locate it. "
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["LoadNETAssembly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["assemblyName",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], Cell["\<\
load the specified assembly based on its name, such as \"System.Web\"\
\>"]},
          {
            RowBox[{
              StyleBox["LoadNETAssembly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["path",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                
                "MR"]}], \(load\ the\ assembly\ based\ on\ its\ full\ file\ \
path\)},
          {
            RowBox[{
              StyleBox["LoadNETAssembly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(url \*"\<\"\"\>"\),
                "\n\"MR\"",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], Cell[
            "load the assembly pointed to by this URL", "Text"]},
          {
            RowBox[{
              StyleBox["LoadNETAssembly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["\<\"assemblyName\"\>",
                  "\n\"MR\"",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["dir",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], Cell["\<\
load the assembly based on its name and the directory in which it resides\
\>", "Text"]},
          {
            RowBox[{
              StyleBox["LoadNETAssembly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["assemblyName",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["context`",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR",
                FontSlant->"Italic"]}], 
            RowBox[{Cell["\<\
load the assembly based on its name and the application context in which it \
resides\
\>", "Text"], "\n"}]},
          {
            RowBox[{
              StyleBox["LoadNETAssembly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["dir",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                
                "MR"]}], \(load\ all\ the\ assemblies\ in\ this\ \
directory\)},
          {
            RowBox[{
              StyleBox["LoadNETAssembly",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["context`",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                
                "MR"]}], \(load\ all\ the\ assemblies\ in\ this\ application\ \
context\)}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.4, 0.6}},
  CellTags->"nlug:3.1.2"],

Cell["Loading assemblies.", "Caption",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Here is an example of using ",
  StyleBox["LoadNETAssembly", "MR"],
  " to load an assembly that is part of the .NET Framework."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[CellGroupData[{

Cell["LoadNETAssembly[\"System.Web\"]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.1.2"],

Cell[BoxData[
    \(NETAssembly["System.Web", 1]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.1.2"]
}, Open  ]],

Cell[TextData[{
  "The return value of ",
  StyleBox["LoadNETAssembly", "MR"],
  " is a ",
  StyleBox["NETAssembly", "MR"],
  " expression. This is not a .NET object itself, just a special expression \
that can be used in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to refer to a loaded assembly in various functions that take an assembly \
specification as an argument."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "The name used in the previous example is the ",
  StyleBox["simple name",
    FontSlant->"Italic"],
  " of the assembly. The actual ",
  StyleBox["full name",
    FontSlant->"Italic"],
  ", or ",
  StyleBox["display name",
    FontSlant->"Italic"],
  ", of the assembly is longer and contains version information, among other \
things. You can use the full name if you want to force a certain version to \
be loaded (note that if you execute this on your machine, it will fail unless \
you have exactly the same version of the .NET Framework installed)."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[CellGroupData[{

Cell["\<\
LoadNETAssembly[\"System.Web, Version=1.0.5000.0, Culture=neutral, \
PublicKeyToken=b03f5f7f11d50a3a\"]\
\>", "Input",
  CellLabel->"In[4]:=",
  CellTags->"nlug:3.1.2"],

Cell[BoxData[
    \(NETAssembly["System.Web", 1]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.1.2"]
}, Open  ]],

Cell["\<\
We were able to load this assembly based on only its name, without any \
location information, because it is located in the GAC.\
\>", "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "As another example of ",
  StyleBox["LoadNETAssembly", "MR"],
  ", say you have obtained an assembly or created one of your own in some \
.NET language and want to load it into ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to use from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The assembly is in the file ",
  StyleBox["c:\\MyProgram\\Bin\\Debug\\MyAssembly.dll", "MR"],
  ". Here is how you would load it."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell["LoadNETAssembly[\"c:\\\\MyProgram\\\\Bin\\\\Debug\\\\MyAssembly.dll\"]",\
 "Input",
  CellTags->"nlug:3.1.2"],

Cell["\<\
Loading an assembly by specifying its path is useful for assemblies that you \
have created yourself.\
\>", "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  StyleBox["LoadNETAssembly", "MR"],
  " can also load assemblies from an ",
  StyleBox["assembly", "MR"],
  " subdirectory in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application directory. This is intended for developers who are creating \
applications that use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". If you have a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application directory called ",
  StyleBox["MyApp", "MR"],
  ", and it is installed into one of the standard locations for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications (e.g., ",
  StyleBox["<", "MR"],
  StyleBox["Mathematica", "MR",
    FontSlant->"Italic"],
  StyleBox[" dir>\\AddOns\\Applications", "MR"],
  "), you can give the ",
  StyleBox["MyApp", "MR"],
  " directory a subdirectory named ",
  StyleBox["assembly", "MR"],
  " and place all the extra assemblies that your application needs into the \
",
  StyleBox["assembly", "MR"],
  " directory. Your application",
  "\[CloseCurlyQuote]",
  "s ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code can then load one of these application assemblies by supplying the \
assembly name and the context that corresponds to your application."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell["LoadNETAssembly[\"My.Special.Assembly\", \"MyApp`\"]", "Input",
  CellTags->"nlug:3.1.2"],

Cell["\<\
In this way, application developers can bundle private assemblies in their \
application layout and not require that their users perform any special \
installation steps such as copying assemblies into the GAC.\
\>", "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["LoadNETType", "Subsubsection",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  StyleBox["LoadNETType", "MR"],
  " is the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that loads .NET types so that they can be used from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". It is often not necessary to explicitly call ",
  StyleBox["LoadNETType", "MR"],
  ". Whenever a .NET object is returned to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", its type is loaded. This means that if you want to create a new object \
of a certain type, you can just call ",
  StyleBox["NETNew", "MR"],
  " and the type will be loaded when the object is returned to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The most common reason for calling ",
  StyleBox["LoadNETType", "MR"],
  " directly is if you want to use a static method or property from a type. \
In that case, you are not creating an object with ",
  StyleBox["NETNew", "MR"],
  ", so you must manually load the type."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["LoadNETType",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["typeName",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], \(load\ the\ specified\ type\)},
          {
            RowBox[{
              StyleBox["LoadNETType",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["typeName",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["assemblyName",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], Cell[
            "load the type from the specified assembly", "Text"]},
          {
            RowBox[{
              StyleBox["LoadNETType",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["typeName",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["NETAssembly",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "load", " ", "the", " ", "type", " ", "from", " ", "the", " ", 
              "assembly", " ", "identified", " ", "by", " ", "a", " ", 
              StyleBox["NETAssembly",
                "MR"], " ", "expression"}]},
          {
            RowBox[{
              StyleBox["LoadNETType",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["typeName",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["assemblyName",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["context`",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], Cell["\<\
load the type from the specified assembly residing in the specified \
application context\
\>", "Text"]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->0.5},
  CellTags->"nlug:3.1.2"],

Cell["Loading types.", "Caption",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Here is a simple example of ",
  StyleBox["LoadNETType", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[CellGroupData[{

Cell["LoadNETType[\"System.Windows.Forms.Form\"]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"nlug:3.1.2"],

Cell[BoxData[
    \(NETType["System.Windows.Forms.Form", 1]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"nlug:3.1.2"]
}, Open  ]],

Cell[TextData[{
  "The return value of ",
  StyleBox["LoadNETType", "MR"],
  " is a ",
  StyleBox["NETType", "MR"],
  " expression. This is not a .NET object itself, just a special expression \
that can be used in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to refer to a .NET type in various functions that take a type \
specification as an argument."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Note that you must supply the full type name, including the namespace \
prefix (",
  StyleBox["System.Windows.Forms", "MR"],
  " in this example). For the load to succeed, the assembly in which the type \
resides must be already loaded using ",
  StyleBox["LoadNETAssembly", "MR"],
  ". As mentioned earlier, assemblies for all System types are automatically \
loaded as needed by ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", so there was no need to load the ",
  StyleBox["System.Windows.Forms", "MR"],
  " assembly manually in the previous example."
}], "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Viewing Loaded Assemblies and Types", "Subsubsection",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "You can use the utility functions ",
  StyleBox["LoadedNETAssemblies", "MR"],
  " and ",
  StyleBox["LoadedNETTypes", "MR"],
  " to see what assemblies and types have been loaded into the current ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session. These are intended mainly for debugging purposes."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(LoadedNETAssemblies[]\),
              "MR"], 
            
            StyleBox[\(return\ a\ list\ of\ all\ assemblies\ loaded\ into\ \
Mathematica\),
              "Text"]},
          {
            StyleBox[\(LoadedNETTypes[]\),
              "MR"], 
            
            StyleBox[\(return\ a\ list\ of\ all\ types\ loaded\ into\ \
Mathematica\),
              "Text"]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->0.5},
  CellTags->"nlug:3.1.2"],

Cell["Viewing loaded assemblies and types.", "Caption",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Contexts and Visibility of Static Type Members", "Subsubsection",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  StyleBox["LoadNETType", "MR"],
  " has two options that let you control the naming and visibility of static \
methods and fields. To understand these options, you need to understand the \
problems they help to solve. We have to get a bit ahead of ourselves to \
explain the issues, since we have not yet discussed how to call .NET methods. \
When a type is loaded, definitions are created in ",
  StyleBox["Mathematica", "TI"],
  " that allow you to call methods, properties, and fields of objects of that \
class. Static members are treated quite differently from nonstatic ones. Say \
you have a class named ",
  StyleBox["MyClass", "MR"],
  " in the namespace ",
  StyleBox["MyCompany.Utilities", "MR"],
  ", and this class contains a static method named ",
  StyleBox["Foo", "MR"],
  ". When you load this class, a definition must be set up for ",
  StyleBox["Foo", "MR"],
  " so that it can be called by name, something like ",
  StyleBox["Foo[args]", "MR"],
  ". The question becomes: In what context do you want the symbol ",
  StyleBox["Foo", "MR"],
  " defined, and do you want this context to be visible (i.e., on ",
  StyleBox["$ContextPath", "MR"],
  ")?"
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " always creates a definition for ",
  StyleBox["Foo", "MR"],
  " in a context that mirrors its fully qualified classname: ",
  StyleBox["MyCompany`Utilities`MyClass`Foo", "MR"],
  ". This is done to avoid conflicting with symbols named ",
  StyleBox["Foo", "MR"],
  " that might be present in other contexts. However, you might find it \
clumsy to have to call ",
  StyleBox["Foo", "MR"],
  " by typing the full context name every time, as in ",
  StyleBox["MyCompany`Utilities`MyClass`Foo[args]", "MR"],
  ". The option ",
  StyleBox["AllowShortContext->True", "MR"],
  " (this is the default setting) causes ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to also make definitions for ",
  StyleBox["Foo", "MR"],
  " accessible in a shortened context, one that consists of just the class \
name without the hierarchical namespace prefix. In our example, this means \
that you could call ",
  StyleBox["Foo", "MR"],
  " as simply ",
  StyleBox["MyClass`Foo[args]", "MR"],
  ". If you need to avoid use of the short context because there is already a \
context of the same name in your ",
  StyleBox["Mathematica", "TI"],
  " session, you can use ",
  StyleBox["AllowShortContext->False", "MR"],
  ". This forces all names to be put only in the \[OpenCurlyDoubleQuote]deep\
\[CloseCurlyDoubleQuote] context. Note that even with ",
  StyleBox["AllowShortContext->True", "MR"],
  ", names for statics are also put into the deep context, so you can always \
use the deep context to refer to a symbol if you desire."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  StyleBox["AllowShortContext", "MR"],
  ", then, lets you control the context where the symbol names are defined. \
The other option, ",
  StyleBox["StaticsVisible", "MR"],
  ", controls whether this context is made visible (put on ",
  StyleBox["$ContextPath", "MR"],
  ") or not. The default is ",
  StyleBox["StaticsVisible->False", "MR"],
  ", so you have to use a context name when referring to a symbol, as in ",
  StyleBox["MyClass`Foo[args]", "MR"],
  ". With ",
  StyleBox["StaticsVisible->True, MyClass`", "MR"],
  " will be put on ",
  StyleBox["$ContextPath", "MR"],
  ", so you could just write ",
  StyleBox["Foo[args]", "MR"],
  ". Having the default be ",
  StyleBox["True", "MR"],
  " would be a bit dangerous\[LongDash]every time you load a class a \
potentially large number of names would suddenly be created and made visible \
in your ",
  StyleBox["Mathematica", "TI"],
  " session, opening up the possibility for all sorts of \
\[OpenCurlyDoubleQuote]shadowing\[CloseCurlyDoubleQuote] problems if symbols \
of the same names were already present (see Section ",
  ButtonBox["2.6.8",
    ButtonData:>{"2.6.8", "TAG"},
    ButtonStyle->"MainBookLink"],
  " in ",
  StyleBox["The Mathematica Book", "TI"],
  " for a discussion of contexts and shadowing problems)."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "For these reasons ",
  StyleBox["StaticsVisible->True", "MR"],
  " is recommended only for classes that you have written, or ones whose \
contents you are familiar with. In such cases, it can save you some typing, \
make your code more readable, and prevent the all-too-easy bug of forgetting \
to type the classname prefix. A classic example would be implementing the \
venerable \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] ",
  StyleBox["MathLink", "TI"],
  " example program. In C#, it might look like this."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell["\<\
public class AddTwo {
\tpublic static int AddTwo(int i, int j) {return i + j;}
}\
\>", "Program",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "With the default ",
  StyleBox["StaticsVisible->False", "MR"],
  ", you would have to call addtwo as ",
  StyleBox["AddTwo`AddTwo[3, 4]", "MR"],
  ". Setting",
  StyleBox[" StaticsVisible->True", "MR"],
  " lets you write the more obvious ",
  StyleBox["AddTwo[3, 4]", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Be reminded that these options are only for ",
  StyleBox["static", "TI"],
  " methods and fields. As discussed later, ",
  "nonstatic",
  "s are handled in a way that makes context and visibility issues go away \
completely."
}], "Text",
  CellTags->"nlug:3.1.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(StaticsVisible\  \[Rule] \ True\),
              "MR"], 
            StyleBox[Cell["\<\
make static methods and fields accessible by just their names, not in a \
special context\
\>"],
              "Text"]},
          {
            StyleBox[\(AllowShortContext\  \[Rule] \ False\),
              "MR"], 
            StyleBox[
              RowBox[{Cell["\<\
make static methods and fields accessible only in the context\
\>"], "that", " ", "mirrors", " ", "the", " ", "full", " ", "hierarchical", 
                " ", "namespace", " ", "name"}],
              "Text"]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.1.2"],

Cell[TextData[{
  "Options for ",
  StyleBox["LoadNETType", "MR"],
  "."
}], "Caption",
  CellTags->"nlug:3.1.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Conversion of Types Between .NET and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Subsection",
  CellTags->{
  "Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"}],

Cell[TextData[{
  "Before we encounter the operations of creating .NET objects and calling \
methods, we should examine the mapping of types between ",
  StyleBox["Mathematica", "TI"],
  " and .NET. When a .NET method returns a result to ",
  StyleBox["Mathematica", "TI"],
  ", the result is automatically converted into a ",
  StyleBox["Mathematica", "TI"],
  " expression. For example, .NET integer types (e.g., ",
  StyleBox["Int32", "MR"],
  ", ",
  StyleBox["Byte", "MR"],
  ", and so on), are converted into ",
  StyleBox["Mathematica", "TI"],
  " integers, and .NET real number types (",
  StyleBox["Single", "MR"],
  ", ",
  StyleBox["Double", "MR"],
  ") are converted into ",
  StyleBox["Mathematica", "TI"],
  " reals. The table below shows the complete set of conversions. These \
conversions work both ways\[LongDash]for example, when a ",
  StyleBox["Mathematica", "TI"],
  " integer is sent to a .NET method that requires a ",
  StyleBox["Byte", "MR"],
  " value, the integer is automatically converted to a .NET ",
  StyleBox["Byte", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.3"],

Cell[TextData[{
  "Note that this table gives type names as they are used in the .NET \
Framework. Different languages often have their own keywords that map to \
these underlying types. In C#, for example, the keyword ",
  StyleBox["int", "MR"],
  " is an alias to the ",
  StyleBox["Int32", "MR"],
  " type, and in Visual Basic .NET the ",
  StyleBox["Int32", "MR"],
  " type is called ",
  StyleBox["Integer", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.3"],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {
              RowBox[{\(\(.\)\(NET\)\), 
                StyleBox[" ",
                  "SO10"], 
                StyleBox["type",
                  "SO10"]}], 
              StyleBox[\(Mathematica\ Type\),
                "SO10"]},
            {\(Byte, \ SByte, \ Char, \ Int16, \ UInt16, \ Int32, \ UInt32, \ 
              Int64, \ UInt64\), Cell["Integer"]},
            {"Decimal", 
              RowBox[{Cell["Integer"], "or", " ", "Real"}]},
            {\(Single, \ Double\), Cell["Real"]},
            {"Boolean", Cell["True or False"]},
            {"String", Cell["String"]},
            {"Array", Cell["List"]},
            {\(controlled\ by\ user\), Cell["Complex"]},
            {"Object", Cell["NETObject"]},
            {"Expr", Cell["any expression"]},
            {"null", Cell["Null"]}
            }],
        "MR"], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  GridBoxOptions->{RowLines->{0.5, False}},
  CellTags->"nlug:3.1.3"],

Cell[TextData[{
  "Corresponding types in .NET and ",
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  StyleBox[".", "TI"]
}], "Caption",
  CellTags->"nlug:3.1.3"],

Cell[TextData[{
  ".NET arrays are mapped to ",
  StyleBox["Mathematica", "TI"],
  " lists of the appropriate depth. Thus, when you call a method that takes a \
",
  StyleBox["double[]", "MR"],
  " (in C# notation), you might pass it ",
  StyleBox["{1.0, 2.0, N[Pi], 1.23}", "MR"],
  ". Similarly, a method that returns a two-deep array of integers (",
  StyleBox["int[,]", "MR"],
  " in C# notation) might return to ",
  StyleBox["Mathematica", "TI"],
  " the expression ",
  StyleBox["{{1, 2, 3}, {5, 3, 1}}", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating Objects", "Subsection",
  CellTags->"nlug:3.1.4"],

Cell[TextData[{
  "To construct .NET objects, use the ",
  StyleBox["NETNew", "MR"],
  " function. The first argument to ",
  StyleBox["NETNew", "MR"],
  " is the object\[CloseCurlyQuote]s type, specified either as a ",
  StyleBox["NETType", "MR"],
  " expression returned from ",
  StyleBox["LoadNETType", "MR"],
  " or as a string giving the fully qualified type name (i.e., including the \
namespace prefix). If you wish to supply any arguments to the object\
\[CloseCurlyQuote]s constructor, they follow as a sequence after the type."
}], "Text",
  CellTags->"nlug:3.1.4"],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {
              RowBox[{
                StyleBox["NETNew",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["typeName",
                    "MR",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        "MR"], 
                      StyleBox[" ",
                        "TI"]}]], 
                  StyleBox["arg1",
                    "TI"], 
                  StyleBox[",",
                    "TI"], 
                  StyleBox[" ",
                    "TI"], 
                  StyleBox["...",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}], Cell[TextData[{
                
                "construct a new object of the specified class and return it \
to ",
                StyleBox["Mathematica",
                  FontSlant->"Italic"]
              }]]},
            {
              RowBox[{
                StyleBox["NETNew",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox[\(NETType, \ arg1, \  ... \),
                  "TI"], 
                StyleBox["]",
                  "MR"]}], Cell[TextData[{
                
                "construct a new object of the specified class and return it \
to ",
                StyleBox["Mathematica",
                  FontSlant->"Italic"]
              }]]}
            }],
        "Text"], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.1.4"],

Cell["Constructing .NET objects.", "Caption",
  CellTags->"nlug:3.1.4"],

Cell[TextData[{
  "For example, this will create a new ",
  StyleBox["Form", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(form = NETNew["\<System.Windows.Forms.Form\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"nlug:3.1.4"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Windows.Forms.Form"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$100663297]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"nlug:3.1.4"]
}, Open  ]],

Cell[TextData[{
  "The return value from ",
  StyleBox["NETNew", "MR"],
  " is a strange expression that looks like it has the head ",
  StyleBox["NETObject", "MR"],
  ", except that it is enclosed in angle brackets. The angle brackets are \
used to indicate that the form in which the expression is displayed is quite \
different from its internal representation. These expressions will be \
referred to as ",
  StyleBox["NETObject", "MR"],
  " expressions. ",
  StyleBox["NETObject", "MR"],
  " expressions are displayed in a way that shows their type name, but you \
should consider them opaque, meaning that you cannot pick them apart or peer \
into their insides. You can only use them in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " functions that take ",
  StyleBox["NETObject", "MR"],
  " expressions."
}], "Text",
  CellTags->"nlug:3.1.4"],

Cell[TextData[{
  StyleBox["NETNew", "MR"],
  " invokes a .NET constructor appropriate for the types of the arguments \
being passed in, and then returns to ",
  StyleBox["Mathematica", "TI"],
  " what is, in effect, a reference to the object. That is how you should \
think of ",
  StyleBox["NETObject", "MR"],
  " expressions\[LongDash]as references to .NET objects very much like object \
references in a .NET language like C# or Visual Basic .NET. What is returned \
to ",
  StyleBox["Mathematica", "TI"],
  " is not large no matter what type of object you are constructing. In \
particular, the object\[CloseCurlyQuote]s data (that is, its fields) are not \
sent back to ",
  StyleBox["Mathematica", "TI"],
  ". The actual object remains on the .NET side, and ",
  StyleBox["Mathematica", "TI"],
  " gets a reference to it."
}], "Text",
  CellTags->"nlug:3.1.4"],

Cell[TextData[{
  "The previous examples specified the class by giving its name as a string. \
You can also use a ",
  StyleBox["NETType", "MR"],
  " expression, which is a special expression returned by ",
  StyleBox["LoadNETType", "MR"],
  " that identifies a class. When you specify the class name as a string, the \
class is loaded if it has not already been."
}], "Text",
  CellTags->"nlug:3.1.4"],

Cell[BoxData[{
    \(\(formType = LoadNETType["\<System.Windows.Forms.Form\>"];\)\), "\n", 
    \(\(form = NETNew[formType];\)\)}], "Input",
  CellLabel->"In[7]:=",
  CellTags->"nlug:3.1.4"],

Cell[TextData[{
  StyleBox["NETNew", "MR"],
  " is not the only way to get a reference to a .NET object in ",
  StyleBox["Mathematica", "TI"],
  ". Many methods and properties return objects, and when you call such a \
method or property, a ",
  StyleBox["NETObject", "MR"],
  " expression is created. Such objects can be used in the same way as ones \
you explicitly construct with ",
  StyleBox["NETNew", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Calling Methods, Properties, and Fields", "Subsection",
  CellTags->"nlug:3.1.5"],

Cell[CellGroupData[{

Cell["Syntax", "Subsubsection",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " syntax for calling .NET methods and accessing fields is very similar to \
the syntax used in C# and Visual Basic .NET. The box below compares the ",
  StyleBox["Mathematica", "TI"],
  " and C# ways of calling constructors, methods, properties, fields, static \
methods, static properties, and static fields. You can see that ",
  StyleBox["Mathematica", "TI"],
  " programs that use .NET are written in almost exactly the same way as C# \
(or VB .NET) programs, except ",
  StyleBox["Mathematica", "TI"],
  " uses [] instead of () for arguments and @ instead of the . (dot) as the \
\[OpenCurlyDoubleQuote]member access\[CloseCurlyDoubleQuote] operator."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "An exception is that for static methods, ",
  StyleBox["Mathematica", "TI"],
  " uses the context mark ` in place of the dot used by C# and VB. This \
parallels the usage in those languages also, as their use of the dot in this \
circumstance is really as a scope resolution operator (like :: in C++). \
Although ",
  StyleBox["Mathematica", "TI"],
  " does not use this terminology, its scope resolution operator is the \
context mark. .NET namespace names map directly to ",
  StyleBox["Mathematica", "TI"],
  "\[CloseCurlyQuote]s hierarchical contexts."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {" ", 
              StyleBox["Constructors",
                "SBO"]},
            {
              StyleBox[\(\(C  #\)\(:\)\),
                "TR"], Cell["MyClass obj = new MyClass(args);"]},
            {
              StyleBox[\(\(Mathematica\)\(:\)\),
                "TR"], Cell["obj = NETNew[\"MyClass\", args];"]},
            {
              StyleBox[" ",
                "TR"], 
              FormBox[
                StyleBox["Methods",
                  "SBO"],
                "TraditionalForm"]},
            {
              StyleBox[\(\(C  #\)\(:\)\),
                "TR"], Cell["obj.MethodName(args);"]},
            {
              StyleBox[\(\(Mathematica\)\(:\)\),
                "TR"], Cell["obj@MethodName[args]"]},
            {
              StyleBox[" ",
                "TR"], Cell[TextData[StyleBox[
              "Properties and fields", "SBO"]]]},
            {
              StyleBox[\(\(C  #\)\(:\)\),
                "TR"], 
              RowBox[{
              Cell["obj.PropertyOrFieldName = 1;"], 
                "\n", \(value\  = \ obj . PropertyOrFieldName;\)}]},
            {
              StyleBox[\(\(Mathematica\)\(:\)\),
                "TR"], 
              RowBox[{
              Cell["obj@PropertyOrFieldName = 1;"], 
                "\n", \(value\  = \ obj@PropertyOrFieldName;\), " "}]},
            {
              StyleBox[" ",
                "TR"], Cell[TextData[StyleBox["Static methods", "SBO"]]]},
            {
              StyleBox[\(\(C  #\)\(:\)\),
                "TR"], Cell["MyClass.StaticMethod(args);"]},
            {
              StyleBox[\(\(Mathematica\)\(:\)\),
                "TR"], Cell["MyClass`StaticMethod[args];"]},
            {
              StyleBox[" ",
                "TR"], 
              StyleBox[\(Static\ properties\ and\ fields\),
                "SBO"]},
            {
              StyleBox[\(\(C  #\)\(:\)\),
                "TR"], \(\(MyClass . StaticPropertyOrField\  = \ 1;\)\n
              \(value\  = \ MyClass . StaticPropertyOrField;\)\)},
            {
              StyleBox[\(\(Mathematica\)\(:\)\),
                "TR"], \(\(MyClass`StaticPropertyOrField\  = \ 1;\)\n
              \(value\  = \ MyClass`StaticPropertyOrField;\)\)}
            },
          
          RowLines->{
            False, False, True, False, False, True, False, False, True, False,
               False, True, False}],
        "MR"], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "C# and ",
  StyleBox["Mathematica", "TI"],
  " syntax comparison."
}], "Caption",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "You may already be familiar with ",
  StyleBox["@", "MR"],
  " as a ",
  StyleBox["Mathematica", "TI"],
  " operator for applying a function to an argument: ",
  StyleBox["f @ x ", "MR"],
  "is equivalent to the more commonly used ",
  StyleBox["f[x]", "MR"],
  ". ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " does not usurp ",
  StyleBox["@", "MR"],
  " for some special operation\[LongDash]it is really just normal function \
application slightly disguised. This means that you do not have to use @ at \
all. The following are equivalent ways of invoking a method."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    \(\(\( (*\ These\ are\ equivalent\ *) \)\(\n\)\(\(obj@Method[args];\)\n
    \(obj[Method[args]];\)\)\)\)], "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "The first form preserves the natural mapping of the syntax of most .NET \
languages into ",
  StyleBox["Mathematica", "TI"],
  " and will be used exclusively in this manual."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "When you call methods, properties, or fields and get results back, .",
  StyleBox["NET",
    FontSlant->"Italic"],
  StyleBox["/Link",
    FontSlant->"Italic"],
  " automatically converts arguments and results to and from their ",
  StyleBox["Mathematica", "TI"],
  " representations according to the table presented earlier."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "In object-oriented languages, method and field names are scoped by the \
object on which they are called. In other words, when you write ",
  StyleBox["obj.Meth()", "MR"],
  ", .NET languages know that you are calling the method named ",
  StyleBox["Meth", "MR"],
  " that resides in ",
  StyleBox["obj", "MR"],
  "\[CloseCurlyQuote]s class, even though there may be other methods named ",
  StyleBox["Meth", "MR"],
  " in other classes. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " preserves this scoping for ",
  StyleBox["Mathematica", "TI"],
  " symbols so that there is never a conflict with existing symbols of the \
same name. When you write ",
  StyleBox["obj@Meth[]", "MR"],
  ", there is no conflict with any other symbols named ",
  StyleBox["Meth", "MR"],
  " in the system\[LongDash]the symbol ",
  StyleBox["Meth", "MR"],
  " used by ",
  StyleBox["Mathematica", "TI"],
  " in the evaluation of this call is the one set up by ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " for this class. Here is an example using a field. First, we create a ",
  StyleBox["Point", "MR"],
  " object."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pt = NETNew["\<System.Drawing.Point\>"]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Drawing.Point"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$1]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"nlug:3.1.5"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Point", "MR"],
  " class has fields named ",
  StyleBox["X", "MR"],
  " and ",
  StyleBox["Y", "MR"],
  ", which hold its coordinates. A user\[CloseCurlyQuote]s session might also \
have symbols named ",
  StyleBox["X", "MR"],
  " or ",
  StyleBox["Y", "MR"],
  " in it, however. Let us set up a definition for ",
  StyleBox["X", "MR"],
  " that will tell us when it is evaluated."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    \(X := Print["\<gotcha\>"]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "Now set a value for the field named ",
  StyleBox["X", "MR"],
  " (this would be written as ",
  StyleBox["pt.X = 42", "MR"],
  " in C# or VB)."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    StyleBox[\(pt@X = 42;\),
      "MB"]], "Input",
  CellLabel->"In[11]:=",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "You will notice that \[OpenCurlyDoubleQuote]gotcha\[CloseCurlyDoubleQuote] \
was not printed. There is no conflict between the symbol ",
  StyleBox["X", "MR"],
  " in the ",
  StyleBox["Global`", "MR"],
  " context that has the ",
  StyleBox["Print", "MR"],
  " definition and the symbol ",
  StyleBox["X", "MR"],
  " that is used during the evaluation of this line of code. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " protects the names of members on the right-hand side of ",
  StyleBox["@", "MR"],
  " so that they do not conflict with, or rely on, any definitions that might \
exist for these symbols in visible contexts. You will typically see a lot of \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " spelling warning messages in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " programming, as many .NET types have members with names similar to \
existing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbols. Because the .NET names are scoped to the objects on which they \
operate, you can almost always ignore these warnings."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "In summary, for nonstatic methods, properties, and fields, you never have \
to worry about name conflicts and shadowing, no matter what context you are \
in or what the ",
  StyleBox["$ContextPath", "MR"],
  " is at the moment. This is not true for static members, however. Static \
methods and fields are called by their full name, without an object \
reference, so there is no object out front to scope the name. Here is a \
simple example of a static method call that invokes the .NET garbage \
collector. We need to call ",
  StyleBox["LoadNETType", "MR"],
  " before we call a static method to make sure the class has been loaded."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[{
    \(\(LoadNETType["\<System.GC\>"];\)\), "\n", 
    \(\(GC`Collect[];\)\)}], "Input",
  CellLabel->"In[12]:=",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "The name scoping issue is not usually a problem with static members \
because they are defined in their own contexts (",
  StyleBox["GC`", "MR"],
  " in this example). These contexts are usually not on ",
  StyleBox["$ContextPath", "MR"],
  ", so you do not have to worry that there is a symbol of the same name in \
the ",
  StyleBox["Global`", "MR"],
  " context or in a package that has been read. If there is already a context \
named ",
  StyleBox["GC`", "MR"],
  " in your session, and it has its own function ",
  StyleBox["Collect", "MR"],
  ", you can always avoid a conflict by using the fully-hierarchical context \
name that corresponds to the full type name for a static member."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    \(\(System`GC`Collect[];\)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"nlug:3.1.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Underscores in .NET Names", "Subsubsection",
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  ".NET names can have characters in them that are not legal in ",
  StyleBox["Mathematica", "TI"],
  " symbols. The only common one is the underscore. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " maps underscores in type, method, property, and field names to \
\[OpenCurlyQuote]U\[CloseCurlyQuote]. Note that this mapping is only used \
where it is necessary\[LongDash]when names are used in symbolic form, not as \
strings. For example, assume you have a class named ",
  StyleBox["My_Class", "MR"],
  ". When you refer to this class name as a string, you use the underscore:"
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[{
    \(\(LoadNETType["\<My_Class\>"];\)\), "\[IndentingNewLine]", 
    \(\(NETNew["\<My_Class\>"];\)\)}], "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"],

Cell["\<\
But when you call a static method in such a class, the hierarchical context \
name is symbolic, so you must convert the underscore to U.\
\>", "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    \(\(MyUClass`StaticMethod[];\)\)], "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"],

Cell[TextData[{
  "The same rule applies to method and field names. To refer to such names in \
code, use the U. Here is how to call a property named ",
  StyleBox["Some_Property", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.1.5"],

Cell[BoxData[
    \(obj@SomeUProperty\)], "Input",
  CellLabel->"In[1]:=",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Getting Information About Types and Objects", "Subsection",
  CellTags->"nlug:3.1.6"],

Cell[CellGroupData[{

Cell["NETTypeInfo", "Subsubsection",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  "It is often convenient to be able to quickly display information about the \
methods, properties, fields, and so on that exist in a given .NET type. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides the ",
  StyleBox["NETTypeInfo", "MR"],
  " function to obtain this information."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NETTypeInfo",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["typeName",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[Cell[
              "print information about all the members in the given type"],
              "Text"]},
          {
            RowBox[{
              StyleBox["NETTypeInfo",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["typeName",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["members",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[Cell["\<\
print information about just the desired types of members in the given type\
\>"],
              "Text"]},
          {
            RowBox[{
              StyleBox["NETTypeInfo",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["typeName",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["members",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox["\<\"pat\"\>",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[Cell["\<\
print information about the desired types of members whose names match a \
string pattern\
\>"],
              "Text"]},
          {
            RowBox[{
              StyleBox["NETTypeInfo",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["obj",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
              Cell["print information about all the members in the object's \
type"], "\n"}],
              "Text"]},
          {
            RowBox[{
              StyleBox["NETTypeInfo",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["NETAssembly",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[Cell[
              "print information about all the types in the given assembly"],
              "Text"]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  GridBoxOptions->{ColumnWidths->{0.4, 0.6}},
  CellTags->"nlug:3.1.6"],

Cell["Getting information about types and objects.", "Caption",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  StyleBox["NETTypeInfo", "MR"],
  " will load the type if it has not already been loaded."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  "This will display a lot of information about the ",
  StyleBox["Process", "MR"],
  " class."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell["NETTypeInfo[\"System.Diagnostics.Process\"]", "Input",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  "The second argument to ",
  StyleBox["NETTypeInfo", "MR"],
  " is an optional list of the members you want to see displayed. The \
possible values are ",
  StyleBox["\"Type\"", "MR"],
  " (gives general info about the type itself), ",
  StyleBox["\"Constructors\"", "MR"],
  ", ",
  StyleBox["\"Methods\"", "MR"],
  ", ",
  StyleBox["\"Properties\"", "MR"],
  ", ",
  StyleBox["\"Fields\"", "MR"],
  ", and ",
  StyleBox["\"Events\"", "MR"],
  ". This will show just the properties and methods."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell["\<\
NETTypeInfo[\"System.Diagnostics.Process\", {\"Methods\", \"Properties\"}]\
\>", "Input",
  CellTags->"nlug:3.1.6"],

Cell["\<\
This will show just properties with names that begin with \"Peak\".\
\>", "Text",
  CellTags->"nlug:3.1.6"],

Cell["\<\
NETTypeInfo[\"System.Diagnostics.Process\", \"Properties\", \"Peak*\"]\
\>", "Input",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  "The default behavior is to display the members in C# syntax. If you want \
to see them in Visual Basic .NET syntax, use the ",
  StyleBox["LanguageSyntax", "MR"],
  " option."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell["\<\
NETTypeInfo[\"System.Diagnostics.Process\", \
LanguageSyntax->\"VisualBasic\"]\
\>", "Input",
  CellTags->"nlug:3.1.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["LanguageSyntax",
              "MR"], Cell[TextData[StyleBox["\"CSharp\"", "MR"]]], 
            RowBox[{
            "the", " ", "language", " ", "syntax", " ", "in", " ", "which", 
              " ", "output", " ", "should", " ", "be", " ", "formatted", " ", 
              
              RowBox[{"(", 
                RowBox[{
                "must", " ", "be", " ", Cell["\"CSharp\""], " ", "or", " ", 
                  Cell["\"VisualBasic\""]}], ")"}]}]},
          {
            StyleBox["Inherited",
              "MR"], 
            StyleBox["True",
              "MR"], \(whether\ to\ include\ inherited\ members\)},
          {
            StyleBox["IgnoreCase",
              "MR"], 
            StyleBox["False",
              "MR"], Cell[
            "whether to ignore case in matching names to a string pattern", 
              "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}},
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  "Options to ",
  StyleBox["NETTypeInfo", "MR"],
  ". "
}], "Caption",
  CellTags->"nlug:3.1.6"],

Cell["\<\
NETTypeInfo is also useful for seeing what types are in an assembly. To \
investigate an assembly, pass a NETAssembly expression as the first argument. \
The easiest way to get a NETAssembly expression is to call LoadNETAssembly \
(even if the assembly is already loaded). The following line will show a lot \
of types.\
\>", "Text",
  CellTags->"nlug:3.1.6"],

Cell["NETTypeInfo[LoadNETAssembly[\"System.Data\"]]", "Input",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  "When acting on a NETAssembly, the second argument to ",
  StyleBox["NETTypeInfo", "MR"],
  " is an optional list of the types you want to see displayed. The possible \
values are ",
  StyleBox["\"Classes\"", "MR"],
  ", ",
  StyleBox["\"Interfaces\"", "MR"],
  ", ",
  StyleBox["\"Structures\"", "MR"],
  ", ",
  StyleBox["\"Delegates\"", "MR"],
  ", and ",
  StyleBox["\"Enums\"", "MR"],
  ". This will show just the classes and interfaces with the word \"Data\" in \
their names."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell["\<\
NETTypeInfo[LoadNETAssembly[\"System.Data\"], {\"Classes\", \"Interfaces\"}, \
\"*Data*\"]\
\>", "Input",
  CellTags->"nlug:3.1.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Useful Functions", "Subsubsection",
  CellTags->"nlug:3.1.6"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NETObjectQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["expr",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"return", " ", 
                StyleBox["True",
                  "MR"], " ", "if", " ", 
                StyleBox["expr",
                  FontSlant->"Italic"], " ", "is", " ", "a", " ", "valid", 
                " ", "reference", " ", "to", " ", \(a\  . NET\), " ", 
                "object"}], ",", " ", 
              RowBox[{
                StyleBox["False",
                  "MR"], " ", "otherwise"}]}]},
          {
            RowBox[{
              StyleBox["InstanceOf",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["obj",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["type",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"return", " ", 
                StyleBox["True",
                  "MR"], " ", "if", " ", "this", " ", "object", " ", "is", 
                " ", "an", " ", "instance", " ", "of", " ", 
                StyleBox["type",
                  FontSlant->"Italic"]}], ",", " ", 
              RowBox[{
                StyleBox["False",
                  "MR"], " ", "otherwise"}]}]},
          {
            RowBox[{
              StyleBox["GetTypeObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["NETType",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "return the ",
              StyleBox["Type", "MR"],
              " object corresponding to a ",
              StyleBox["NETType", "MR"],
              " expression"
            }], "Text"]},
          {
            RowBox[{
              StyleBox["GetAssemblyObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["NETAssembly",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"return", " ", "the", " ", 
              StyleBox["Assembly",
                "MR"], " ", "object", " ", "corresponding", " ", "to", " ", 
              "a", " ", 
              StyleBox["NETAssembly",
                "MR"], " ", "expression"}]}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.1.6"],

Cell["Utility functions for objects and types. ", "Caption",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  StyleBox["NETObjectQ", "MR"],
  " is convenient when you need to test whether an expression is a .NET \
object reference. It is often used as a pattern test in function \
definitions."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell["f[x_?NETObjectQ] := ...", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " uses special expressions with heads ",
  StyleBox["NETType", "MR"],
  " (returned by ",
  StyleBox["LoadNETType", "MR"],
  ") and ",
  StyleBox["NETAssembly", "MR"],
  " (returned by ",
  StyleBox["LoadNETAssembly", "MR"],
  ") to represent .NET types and assemblies in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". As noted earlier, you can pass these expressions to functions that take \
types or assemblies as arguments (such as ",
  StyleBox["NETNew", "MR"],
  "). There are times when you might want not a ",
  StyleBox["NETType", "MR"],
  " expression, but an actual .NET ",
  StyleBox["Type", "MR"],
  " object reference for a given type, and likewise for an assembly. You can \
use ",
  StyleBox["GetTypeObject", "MR"],
  " to get the ",
  StyleBox["Type", "MR"],
  " object corresponding to a ",
  StyleBox["NETType", "MR"],
  " expression, and ",
  StyleBox["GetAssemblyObject", "MR"],
  " to get the .NET ",
  StyleBox["Assembly", "MR"],
  " object."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell[CellGroupData[{

Cell["netType = LoadNETType[\"System.Data.DataRow\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.1.6"],

Cell[BoxData[
    \(NETType["System.Data.DataRow", 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.1.6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["typeObj = GetTypeObject[netType]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.1.6"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.RuntimeType"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$2130356660600833]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.1.6"]
}, Open  ]],

Cell[TextData[{
  "Notice above that the ",
  StyleBox["NETType", "MR"],
  " expression is much more informative about what type it represents than \
the ",
  StyleBox["Type", "MR"],
  " object. This is one reason why ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " uses special ",
  StyleBox["NETType", "MR"],
  " and ",
  StyleBox["NETAssembly", "MR"],
  " expressions instead of just ",
  StyleBox["Type", "MR"],
  " and ",
  StyleBox["Assembly", "MR"],
  " objects."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell[TextData[{
  "Once you have a ",
  StyleBox["Type", "MR"],
  " object, you can use methods and properties of the ",
  StyleBox["Type", "MR"],
  " class to learn about it."
}], "Text",
  CellTags->"nlug:3.1.6"],

Cell[CellGroupData[{

Cell["typeObj@FullName", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.1.6"],

Cell[BoxData[
    \("System.Data.DataRow"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.1.6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["typeObj@IsSerializable", "Input",
  CellLabel->"In[4]:=",
  CellTags->"nlug:3.1.6"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.1.6"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Topics", "Section"],

Cell[CellGroupData[{

Cell["Reference Counts and Memory Management", "Subsection",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell[TextData[{
  "Object References in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsubsection",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "In our earlier treatment of ",
  StyleBox["NETObject", "MR"],
  " expressions we avoided discussing deeper issues such as reference counts \
and uniqueness. Every time a .NET object reference is returned to ",
  StyleBox["Mathematica", "TI"],
  ", either as a result of a method or property or an explicit call to ",
  StyleBox["NETNew", "MR"],
  ", ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " looks to see if a reference to this object has been sent previously in \
this session. If not, it creates a ",
  StyleBox["NETObject", "MR"],
  " expression in ",
  StyleBox["Mathematica", "TI"],
  " and sets up a number of definitions for it. This is a comparatively \
time-consuming process. If this object has already been sent to ",
  StyleBox["Mathematica", "TI"],
  ", in most cases ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " simply creates a ",
  StyleBox["NETObject", "MR"],
  " expression that is identical to the one created previously, which is a \
much faster operation."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "There are some exceptions to this last rule, meaning that sometimes when \
an object is returned to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " a new and different ",
  StyleBox["NETObject", "MR"],
  " expression is created for it, even though this same object has previously \
been sent to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Specifically, any time an object\[CloseCurlyQuote]s hash value (as \
determined by the object\[CloseCurlyQuote]s built-in ",
  StyleBox["GetHashCode()", "MR"],
  " method) has changed since the last time it was seen in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the ",
  StyleBox["NETObject", "MR"],
  " expression created will be different. You do not really need to be \
concerned with the details of this, except to remember that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s ",
  StyleBox["SameQ", "MR"],
  " function is not a valid way to compare ",
  StyleBox["NETObject", "MR"],
  " expressions to decide whether they refer to the same object. You must use \
the ",
  StyleBox["SameObjectQ", "MR"],
  " function."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SameObjectQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["obj1",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox["obj2",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "return ",
              StyleBox["True", "MR"],
              " if the ",
              StyleBox["NETObject", "MR"],
              " expressions ",
              StyleBox["obj1", "MR"],
              " and ",
              StyleBox["obj2", "MR"],
              " refer to the same .NET object, return ",
              StyleBox["False", "MR"],
              " otherwise"
            }], "Text",
              CellTags->"jlug:5.3.3.1"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Comparing ",
  StyleBox["NETObject", "MR"],
  " expressions. "
}], "Caption",
  CellTags->"nlug:3.2.0"],

Cell["Here is an example.", "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pt\  = NETNew["\<System.Drawing.Point\>", \ 1, \ 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Drawing.Point"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$3]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.0"]
}, Open  ]],

Cell[TextData[{
  "The variable ",
  StyleBox["pt", "MR"],
  " refers to a .NET ",
  StyleBox["Point", "MR"],
  " object. Now put it into a container so you can get it back out later."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[{
    \(\(vec\  = \ NETNew["\<System.Collections.ArrayList\>"];\)\), "\n", 
    \(\(vec@Add[pt];\)\)}], "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Now change the value of one of its coordinates. For a ",
  StyleBox["Point", "MR"],
  " object, this changes its hash value."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(\(pt@X\  = \ 2;\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Now compare the ",
  StyleBox["NETObject", "MR"],
  " expression given by ",
  StyleBox["pt", "MR"],
  " and the ",
  StyleBox["NETObject", "MR"],
  " expression created when you ask for the first element of the ",
  StyleBox["ArrayList", "MR"],
  " to be returned to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Even though these are both references to the same .NET object, the ",
  StyleBox["NETObject", "MR"],
  " expressions are different. Recall that the ",
  StyleBox["ArrayList", "MR"],
  " class defines an indexer (in C# terminology), so you can use the ",
  StyleBox["[]", "MR"],
  " notation to refer to an element by index."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell["pt === vec[0]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"nlug:3.2.0"]
}, Open  ]],

Cell[TextData[{
  "Because you cannot use ",
  StyleBox["SameQ", "MR"],
  " (",
  StyleBox["===", "MR"],
  ") to decide whether two object references in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " refer to the same .NET object, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides the ",
  StyleBox["SameObjectQ", "MR"],
  " function for this purpose."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell["SameObjectQ[pt, vec[0]]", "Input",
  CellLabel->"In[6]:=",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"nlug:3.2.0"]
}, Open  ]],

Cell[TextData[{
  "You may be wondering why the ",
  StyleBox["SameObjectQ", "MR"],
  " function is useful. Can\[CloseCurlyQuote]t you just call an object\
\[CloseCurlyQuote]s ",
  StyleBox["Equals()", "MR"],
  " method? It certainly gives the correct result for this example."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell["pt@Equals[vec[0]]", "Input",
  CellLabel->"In[7]:=",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"nlug:3.2.0"]
}, Open  ]],

Cell[TextData[{
  "The problem with this technique is that ",
  StyleBox["Equals()", "MR"],
  " does not always compare object references. Any class is free to override \
",
  StyleBox["Equals()", "MR"],
  " to provide any desired behavior for comparing two objects of that class. \
Some classes make ",
  StyleBox["Equals()", "MR"],
  " compare the \[OpenCurlyDoubleQuote]contents\[CloseCurlyDoubleQuote] of \
the objects, such as the ",
  StyleBox["String", "MR"],
  " class, which uses it for string comparison. The function that provides \
the correct test is the static method ",
  StyleBox["ReferenceEquals()", "MR"],
  ". "
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell["Point`ReferenceEquals[pt, vec[0]]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"nlug:3.2.0"]
}, Open  ]],

Cell[TextData[{
  "You can think of ",
  StyleBox["SameObjectQ", "MR"],
  " as a convenience function that does the same thing as explicitly calling \
",
  StyleBox["ReferenceEquals()", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "In an unusual case where you need to compare object references for \
equality a very large number of times, the slowness of ",
  StyleBox["SameObjectQ", "MR"],
  " compared to ",
  StyleBox["SameQ", "MR"],
  " could become an issue. The only thing that could cause two ",
  StyleBox["NETObject", "MR"],
  " expressions that refer to the exact same .NET object to not be ",
  StyleBox["SameQ", "MR"],
  " is if the hash value of the object changed between the times that the two \
",
  StyleBox["NETObject", "MR"],
  " expressions were created. If you know this has not happened, you can \
safely use ",
  StyleBox["SameQ", "MR"],
  " to test whether they refer to the same object."
}], "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["ReleaseNETObject", "Subsubsection",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "The .NET runtime has a built-in facility called \
\[OpenCurlyDoubleQuote]garbage collection\[CloseCurlyDoubleQuote] for freeing \
up memory occupied by objects that are no longer in use by a program. Objects \
become eligible for garbage collection when no references to them exist \
anywhere, except perhaps in other objects that are also unreferenced. When an \
object is returned to ",
  StyleBox["Mathematica", "TI"],
  ", either as a result of a call to ",
  StyleBox["NETNew", "MR"],
  " or as the return value of a method or property, the ",
  StyleBox[".NET/Lin",
    FontSlant->"Italic"],
  "k code holds a special reference to the object on the .NET side to ensure \
that it cannot be garbage-collected while it is in use by ",
  StyleBox["Mathematica", "TI"],
  ". If you know that you no longer need to use a given .NET object in your \
",
  StyleBox["Mathematica", "TI"],
  " session, you can explicitly tell ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to release its reference. The function that does this is ",
  StyleBox["ReleaseNETObject", "MR"],
  ". In addition to releasing the ",
  StyleBox["Mathematica", "TI"],
  "-specific reference in .NET, ",
  StyleBox["ReleaseNETObject", "MR"],
  " clears out internal definitions that were created in ",
  StyleBox["Mathematica", "TI"],
  " for the object. Any subsequent attempt to use this object in ",
  StyleBox["Mathematica", "TI"],
  " will fail."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell[BoxData[
    \(frm = NETNew["\<System.Windows.Forms.Form\>"]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Windows.Forms.Form"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$184549377]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"nlug:3.2.0"]
}, Open  ]],

Cell[TextData[{
  "Now tell .NET that you no longer need to use this object from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(ReleaseNETObject[frm]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "It is now an error to refer to ",
  StyleBox["frm", "MR"],
  " because the object\[CloseCurlyQuote]s symbolis representation has been \
removed from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session. This is what you see if you try to use the released object."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{

Cell["frm@Text", "Input",
  CellLabel->"In[11]:=",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    RowBox[{
      TagBox[\(Removed["NETObject$83886081"]\),
        False,
        Editable->False], "[", "Text", "]"}]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"nlug:3.2.0"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ReleaseNETObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["obj",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              StyleBox["let .NET know that you are done using ", "Text"],
              StyleBox["obj", "Text",
                FontSlant->"Italic"],
              StyleBox[" in ", "Text"],
              StyleBox["Mathematica", "Text",
                FontSlant->"Italic"]
            }]]},
          {
            RowBox[{
              StyleBox["NETBlock",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["expr",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              StyleBox["all novel .NET objects returned to ", "Text"],
              StyleBox["Mathematica", "Text",
                FontSlant->"Italic"],
              StyleBox[" during the evaluation of ", "Text"],
              StyleBox["expr", "Text",
                FontSlant->"Italic"],
              StyleBox[" will be released when ", "Text"],
              StyleBox["expr", "Text",
                FontSlant->"Italic"],
              StyleBox[" finishes", "Text"]
            }]]},
          {
            StyleBox[\(BeginNETBlock[]\),
              "MR"], Cell[TextData[{
              StyleBox["all novel .NET objects returned to ", "Text"],
              StyleBox["Mathematica", "Text",
                FontSlant->"Italic"],
              StyleBox[" between now and the matching ", "Text"],
              StyleBox["EndNETBlock[]", "MR"],
              StyleBox[" will be released", "Text"]
            }]]},
          {
            StyleBox[\(EndNETBlock[]\),
              "MR"], Cell[TextData[{
              StyleBox[
              "release all novel objects seen since the matching ", "Text"],
              StyleBox["BeginNETBlock[]", "MR"]
            }]]},
          {
            StyleBox[\(LoadedNETObjects[]\),
              "MR"], 
            
            StyleBox[\(return\ a\ list\ of\ all\ objects\ that\ are\ in\ use\ \
in\ Mathematica\),
              "Text"]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.2.0"],

Cell["Memory management functions.", "Caption",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Calling ",
  StyleBox["ReleaseNETObject", "MR"],
  " will not necessarily cause the object to be garbage-collected. It is \
quite possible that other references to it exist in .NET. ",
  StyleBox["ReleaseNETObject", "MR"],
  " does not tell .NET to throw the object away, only that it does not need \
to be kept around solely for ",
  StyleBox["Mathematica", "TI"],
  "\[CloseCurlyQuote]s sake."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "An important fact about the references ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " maintains for objects sent to ",
  StyleBox["Mathematica", "TI"],
  " is that only one reference is kept for each object, no matter how many \
times it is returned to ",
  StyleBox["Mathematica", "TI"],
  ". It is your responsibility to make sure that after you call ",
  StyleBox["ReleaseNETObject", "MR"],
  ", you never attempt to use that object through any reference that might \
exist to it in your ",
  StyleBox["Mathematica", "TI"],
  " session."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[{
    \(\(frm1 = NETNew["\<System.Windows.Forms.Form\>"];\)\), "\n", 
    \(\(frm2\  = \ frm1;\)\)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "If you call ",
  StyleBox["ReleaseNETObject[frm1]", "MR"],
  ", it is not the ",
  StyleBox["Mathematica", "TI"],
  " symbol ",
  StyleBox["frm1", "MR"],
  " that is affected but the .NET object that ",
  StyleBox["frm1", "MR"],
  " refers to. Therefore, using ",
  StyleBox["frm2", "MR"],
  " is also an error (or any other way to refer to this same ",
  StyleBox["Form", "MR"],
  " object)."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Calling ",
  StyleBox["ReleaseNETObject", "MR"],
  " is often unnecessary in casual use. If you are not making heavy use of \
.NET in your session, then you will not usually need to be concerned about \
keeping track of what objects may or may not be needed anymore\[LongDash]you \
can just let them pile up. There are times, though, when memory use in .NET \
will be important, and you may need the extra control that ",
  StyleBox["ReleaseNETObject", "MR"],
  " provides."
}], "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["NETBlock", "Subsubsection",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  StyleBox["ReleaseNETObject", "MR"],
  " is provided mainly for developers who are writing code for others to use. \
Because it is not possible to predict how code will be used, developers \
should always be sure that their code cleans up any unnecessary references it \
creates. Probably the most useful function for this is ",
  StyleBox["NETBlock", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  StyleBox["NETBlock", "MR"],
  " automates the process of releasing objects encountered during the \
evaluation of an expression. Often, a ",
  StyleBox["Mathematica", "TI"],
  " program will need to create some .NET objects with ",
  StyleBox["NETNew", "MR"],
  "; operate with them, perhaps causing other objects to be returned to ",
  StyleBox["Mathematica", "TI"],
  " as the results of method calls; and finally return some result such as a \
number or string. Every .NET object encountered by ",
  StyleBox["Mathematica", "TI"],
  " during this operation is needed only during the lifetime of the program, \
much like the local variables provided in ",
  StyleBox["Mathematica", "TI"],
  " by ",
  StyleBox["Block", "MR"],
  " and ",
  StyleBox["Module", "MR"],
  ", and in C#, C++, Java, and many other languages by block scoping \
constructs (e.g., {}). ",
  StyleBox["NETBlock", "MR"],
  " allows you to mark a block of code as having the property that any new \
objects returned to ",
  StyleBox["Mathematica", "TI"],
  " during the evaluation are to be treated as temporary and released when ",
  StyleBox["NETBlock", "MR"],
  " finishes."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "It is important to note that the preceding sentence said \
\[OpenCurlyDoubleQuote]new objects.\[CloseCurlyDoubleQuote] NET",
  StyleBox["Block", "MR"],
  " will not cause every object encountered during the evaluation to be \
released\[LongDash]only those that are being encountered for the first time. \
Objects that have already been seen by ",
  StyleBox["Mathematica", "TI"],
  " will not be affected. This means that you do not have to worry that ",
  StyleBox["NETBlock", "MR"],
  " will aggressively release an object that is not truly temporary to that \
evaluation."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "It is not enough simply to call ",
  StyleBox["ReleaseNETObject", "MR"],
  " on every object you create with ",
  StyleBox["NETNew", "MR"],
  ", because many .NET methods and properties return objects. You might not \
be interested in these return values. You might never assign them to a named \
variable because they may be chained together with other calls (as in ",
  StyleBox["obj@ReturnsObject[]@Foo[]", "MR"],
  "), but you still need to release them. Using ",
  StyleBox["NETBlock", "MR"],
  " is an easy way to be sure that all novel objects are released when a \
block of code finishes."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  StyleBox["NETBlock[expr]", "MR"],
  " returns whatever ",
  StyleBox["expr", "MR"],
  " returns."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Many ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica", "TI"],
  " programs will have the following structure."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(MyFunc[args__] := \[IndentingNewLine]\t
      NETBlock[\[IndentingNewLine]\t\tModule[{locals}, \[IndentingNewLine]\t\t\
\t ... \t\t\[IndentingNewLine]\t\t]\[IndentingNewLine]\t]\)], "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "It is very common to write a function that creates a number of ",
  StyleBox["NETObject", "MR"],
  " expressions and then returns one of them, the rest being temporary. To \
facilitate this, if the return value of a ",
  StyleBox["NETBlock", "MR"],
  " is a single ",
  StyleBox["NETObject", "MR"],
  ", it will not be released."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    \(MyOtherFunc[args__] := \n\t
      NETBlock[\n\t\tModule[{obj}, \n\t\t\t\(\(\(\(...\)\(\n\)
                  \(\t\t\t\)\(obj\)\) = 
                NETNew["\<System.Windows.Forms.Form\>"];\)\n
            \t\t\t ... \)\ \n\t\t\tReturn[obj]\ \  (*\ 
            OK : \ obj\ will\ not\ be\ released\ when\ NETBlock\ \(\(finishes\
\)\(.\)\)\ *) \n\t\t]\n\t]\)], "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "If you want more control over which objects are allowed to escape from a \
",
  StyleBox["NETBlock", "MR"],
  ", you can use the ",
  StyleBox["KeepNETObject", "MR"],
  " function. Calling ",
  StyleBox["KeepNETObject", "MR"],
  " on a single object or sequence of objects means they will not be released \
when the first enclosing ",
  StyleBox["NETBlock", "MR"],
  " ends. If there is an outer enclosing ",
  StyleBox["NETBlock", "MR"],
  ", the objects will be freed when ",
  StyleBox["it",
    FontSlant->"Italic"],
  " ends, however, so if you want the objects to escape a nested set of ",
  StyleBox["NETBlock", "MR"],
  "s, you must call ",
  StyleBox["KeepNETObject", "MR"],
  " at each level. Alternatively, you can call ",
  StyleBox["KeepNETObject[obj, Manual]", "MR"],
  ", where the ",
  StyleBox["Manual", "MR"],
  " argument tells ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " that the object should not be released by any enclosing ",
  StyleBox["NETBlock", "MR"],
  "s. The only way such object will be released is if you manually call ",
  StyleBox["ReleaseObject", "MR"],
  " on it."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(KeepNETObject[obj1, \ obj2, \  ... ]\),
              "MR"], 
            RowBox[{
              StyleBox["do",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["not",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["release",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["the",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["given",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["objects",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["when",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["the",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["NETBlock",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["ends",
                "Text"]}]},
          {
            StyleBox[\(KeepNETObject[obj1, \ Manual]\),
              "MR"], 
            RowBox[{
              StyleBox["do",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["not",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["release",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["the",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["given",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["object",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["when",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["any",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["NETBlock",
                "MR"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["ends",
                "Text"]}]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Keeping .NET objects after a ",
  StyleBox["NETBLock", "MR"],
  " ends."
}], "Caption",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  "Here is an example that uses ",
  StyleBox["KeepNETObject", "MR"],
  " to allow you to return a list of two objects without releasing them."
}], "Text",
  CellTags->"nlug:3.2.0"],

Cell["\<\
MyOtherFunc[args__] :=
\tModule[{obj1, obj2, obj3}, 
\t\tNETBlock[
\t\t\tobj1 = NETNew[\"System.Windows.Forms.Form\"; 
\t\t\tobj2 = NETNew[\"System.Windows.Forms.Button\"]; 
     \t\tobj3 = NETNew[\"SomeTemporaryObject\"];
     \t\t...
     \t\tKeepNETObject[obj1, obj2];
     \t\t{obj1, obj2}
     \t]
     ]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  StyleBox["BeginNETBlock", "MR"],
  " and ",
  StyleBox["EndNETBlock", "MR"],
  " can be used to provide the same functionality as ",
  StyleBox["NETBlock", "MR"],
  " across more than one evaluation. ",
  StyleBox["EndNETBlock", "MR"],
  " releases all novel .NET objects returned to ",
  StyleBox["Mathematica", "TI"],
  " since the previous matching ",
  StyleBox["BeginNETBlock", "MR"],
  ". These functions are mainly of use during development, when you might \
want to set a mark in your session, do some work, and then release all novel \
objects returned to ",
  StyleBox["Mathematica", "TI"],
  " since that point. ",
  StyleBox["BeginNETBlock", "MR"],
  " and ",
  StyleBox["EndNETBlock", "MR"],
  " can be nested. Every ",
  StyleBox["BeginNETBlock", "MR"],
  " should have a matching ",
  StyleBox["EndNETBlock", "MR"],
  ", although it is not a serious error to forget to call ",
  StyleBox["EndNETBlock", "MR"],
  ", even if you have nested levels of them\[LongDash]you will only fail to \
release some objects."
}], "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["LoadedNETObjects", "Subsubsection",
  CellTags->"nlug:3.2.0"],

Cell[TextData[{
  StyleBox["LoadedNETObjects[]", "MR"],
  " returns a list of all .NET objects that are currently referenced in ",
  StyleBox["Mathematica", "TI"],
  ". This includes all objects explicitly created with ",
  StyleBox["NETNew", "MR"],
  " and all those that were returned to ",
  StyleBox["Mathematica", "TI"],
  " as the result of a .NET method or property. It does not include objects \
that have been released with ",
  StyleBox["ReleaseNETObject", "MR"],
  " or through ",
  StyleBox["NETBlock", "MR"],
  ". ",
  StyleBox["LoadedNETObjects", "MR"],
  " is intended mainly for debugging. It is very useful to call it before and \
after some function you are working on. If the list grows, your function \
leaks references, and you need to examine its use of ",
  StyleBox["NET", "MR"],
  StyleBox["Block", "MR"],
  " and/or ",
  StyleBox["ReleaseNETObject", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Enums", "Subsection",
  CellTags->{"Enums", "nlug:3.2.1"}],

Cell[TextData[{
  "Enumerations in .NET are a special kind of class, with each member of the \
enumeration represented as a static constant field in the class. Although the \
values of enumeration constants are integers, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " does not convert them into integers when they are returned to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This is because enum values are probably only going to be passed back \
into some other .NET method\[LongDash]it is not likely that you will want to \
operate on them as integers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In this case, it is more meaningful to have them appear in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as objects of a class instead of just cryptic integer values."
}], "Text",
  CellTags->"nlug:3.2.1"],

Cell[TextData[{
  "Suppose you have a ",
  StyleBox["Button", "MR"],
  " object ",
  StyleBox["btn", "MR"],
  " that you want to anchor in a form so that it stays in a fixed position \
with respect to one or more edges as the form is resized. To do this, you set \
the button\[CloseCurlyQuote]s ",
  StyleBox["Anchor", "MR"],
  " property to a value from the ",
  StyleBox["AnchorStyles", "MR"],
  " enum. First load the ",
  StyleBox["AnchorStyles", "MR"],
  " type, as is always necessary when you want to access a static member of \
the type."
}], "Text",
  CellTags->"nlug:3.2.1"],

Cell[CellGroupData[{

Cell["LoadNETType[\"System.Windows.Forms.AnchorStyles\"]", "Input",
  CellLabel->"In[16]:=",
  CellTags->"nlug:3.2.1"],

Cell[BoxData[
    \(NETType["System.Windows.Forms.AnchorStyles", 6]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"nlug:3.2.1"]
}, Open  ]],

Cell["\<\
You refer to a member of this enum just like any other static field.\
\>", "Text",
  CellTags->"nlug:3.2.1"],

Cell[CellGroupData[{

Cell["AnchorStyles`Top", "Input",
  CellLabel->"In[17]:=",
  CellTags->"nlug:3.2.1"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Windows.Forms.AnchorStyles"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$16777217]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"nlug:3.2.1"]
}, Open  ]],

Cell[TextData[{
  "The enum is represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by a strongly typed object reference that is more meaningful to a \
programmer than the raw integer value, which happens to be 1. We can use the \
",
  StyleBox["NETObjectToExpression", "MR"],
  " function to convert the object reference to its integer value."
}], "Text",
  CellTags->"nlug:3.2.1"],

Cell[CellGroupData[{

Cell["NETObjectToExpression[AnchorStyles`Top]", "Input",
  CellLabel->"In[18]:=",
  CellTags->"nlug:3.2.1"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"nlug:3.2.1"]
}, Open  ]],

Cell["Now apply it to the button.", "Text",
  CellTags->"nlug:3.2.1"],

Cell["btn@Anchor = AnchorStyles`Top;", "Input",
  CellLabel->"In[19]:=",
  CellTags->"nlug:3.2.1"],

Cell["\<\
For any argument that is typed as an enum, you can pass either an instance of \
the enum class or a raw integer value. This means that the above line could \
also be written as the following, although it is obviously much less \
readable.\
\>", "Text",
  CellTags->"nlug:3.2.1"],

Cell["btn@Anchor = 1;", "Input",
  CellLabel->"In[21]:=",
  CellTags->"nlug:3.2.1"],

Cell[TextData[{
  "Some enums have the ",
  StyleBox["[Flags]", "MR"],
  " attribute, which indicates that its values can be combined by a bitwise \
",
  StyleBox["OR", "MR"],
  ". The ",
  StyleBox["AnchorStyles", "MR"],
  " enum has this attribute because you might want to anchor a component to \
more than one edge of its parent container. Here is an  example of what that \
looks like in C#."
}], "Text",
  CellTags->"nlug:3.2.1"],

Cell["\<\
// C# code
btn.Anchor = AnchorStyles.Top | AnchorStyles.Left;\
\>", "Program",
  CellTags->"nlug:3.2.1"],

Cell[TextData[{
  "To do this in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you need to get the integer values of the enum, so you use ",
  StyleBox["NETObjectToExpression", "MR"],
  ". (This is just about the only case where you would want to operate on \
enum values as integers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". )"
}], "Text",
  CellTags->"nlug:3.2.1"],

Cell["\<\
btn@Anchor = BitOr[NETObjectToExpression[AnchorStyles`Top], \
NETObjectToExpression[AnchorStyles`Left]];\
\>", "Input",
  CellLabel->"In[20]:=",
  CellTags->"nlug:3.2.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
  "Out",
  StyleBox["\[CloseCurlyDoubleQuote]", "TB"],
  " and ",
  StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
  "Ref",
  StyleBox["\[CloseCurlyDoubleQuote]", "TB"],
  " Parameters"
}], "Subsection",
  CellTags->{"Out and Ref Parameters", "nlug:3.2.2"}],

Cell[TextData[{
  ".NET allows parameters to be passed by reference, so that changes to their \
values can be propagated back to the caller. Such \
\[OpenCurlyDoubleQuote]by-reference\[CloseCurlyDoubleQuote] parameters are \
very rarely used in the .NET Framework classes, but are used more commonly in \
some third-party libraries. In C# notation, such parameters are marked as ",
  StyleBox["out", "MR"],
  " or ",
  StyleBox["ref", "MR"],
  ", the difference being that a ",
  StyleBox["ref", "MR"],
  " parameter needs an initial value on entry to the method, whereas an ",
  StyleBox["out", "MR"],
  " parameter does not. In Visual Basic .NET, the keyword ",
  StyleBox["ByRef", "MR"],
  " is used to indicate a parameter passed by reference. ",
  StyleBox["ByRef", "MR"],
  " parameters in Visual Basic are like ",
  StyleBox["ref", "MR"],
  " parameters in C#; there is no notion of an ",
  StyleBox["out", "MR"],
  "-only parameter in Visual Basic. In IDL notation, ",
  StyleBox["ref", "MR"],
  " parameters are written as ",
  StyleBox["[in, out]", "MR"],
  " and ",
  StyleBox["out", "MR"],
  "-only parameters are written as ",
  StyleBox["[out]", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell[TextData[{
  "Here is an example of a ",
  StyleBox["ref", "MR"],
  " parameter in a method from the ",
  StyleBox["System.Uri", "MR"],
  " class."
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell["\<\
// C#
public static char HexUnescape(string pattern, ref int index);

// Visual Basic
Public Shared Function HexUnescape(ByVal pattern As String, ByRef index As \
Integer) As Char\
\>", "Program",
  CellTags->"nlug:3.2.2"],

Cell[TextData[{
  "This method takes a string (the ",
  StyleBox["pattern", "MR"],
  " parameter) and a starting ",
  StyleBox["index", "MR"],
  " and reads the next character in the string, decoding a %xx-format \
hexadecimal representation if necessary. It also advances the ",
  StyleBox["index", "MR"],
  " value to just past the end of the decoded character. Like most methods \
that use ",
  StyleBox["ref", "MR"],
  " or ",
  StyleBox["out", "MR"],
  " parameters, this method needs to return more than one piece of \
information\[LongDash]the decoded character and also the next position in the \
string. Because the ",
  StyleBox["index", "MR"],
  " parameter's starting value is used by the method, it must be a ",
  StyleBox["ref", "MR"],
  " parameter and not merely an ",
  StyleBox["out", "MR"],
  " parameter."
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell[TextData[{
  "You call methods with ",
  StyleBox["out", "MR"],
  " or ",
  StyleBox["ref", "MR"],
  " parameters from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in exactly the same way they are called from most .NET languages, \
including C# and Visual Basic .NET. For a ",
  StyleBox["ref", "MR"],
  " parameter, you call the method with a symbol that has an initial value of \
the correct type (an integer in this case). When the method returns, the \
symbol will have a new value assigned to it. "
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell["\<\
This decodes the %20 character (the familiar encoding for a space character \
[decimal 32] in a URL).\
\>", "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{

Cell["\<\
LoadNETType[\"System.Uri\"];

pos = 3;
Uri`HexUnescape[\"abc%20def\", pos]\
\>", "Input",
  CellLabel->"In[50]:=",
  CellTags->"nlug:3.2.2"],

Cell[BoxData[
    \(32\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->"nlug:3.2.2"]
}, Open  ]],

Cell[TextData[{
  "Because pos was passed to a ",
  StyleBox["ref", "MR"],
  " parameter slot, it has been assigned a new value, that of the index of \
the first character after the %20."
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{

Cell["pos", "Input",
  CellLabel->"In[53]:=",
  CellTags->"nlug:3.2.2"],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"nlug:3.2.2"]
}, Open  ]],

Cell[TextData[{
  "A common mistake when calling ",
  StyleBox["ref", "MR"],
  " parameters is to forget to assign an initial value. Here is an example of \
this error."
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{

Cell["\<\
Clear[pos];
Uri`HexUnescape[\"abc%20def\", pos]\
\>", "Input",
  CellLabel->"In[54]:=",
  CellTags->"nlug:3.2.2"],

Cell[BoxData[
    \(NET::"methodargs" \(\(:\)\(\ \)\) 
      "Improper arguments supplied for method named HexUnescape."\)], \
"Message",
  CellLabel->"From In[54]:=",
  CellTags->"nlug:3.2.2"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"nlug:3.2.2"]
}, Open  ]],

Cell[TextData[{
  "If a parameter is marked as ",
  StyleBox["out", "MR"],
  " instead of ",
  StyleBox["ref", "MR"],
  ", the initial value is ignored, so it doesn\[CloseCurlyQuote]t matter what \
value, if any, the symbol had upon entering the method. As mentioned above, \
Visual Basic .NET has no notion of an ",
  StyleBox["out", "MR"],
  "-only parameter, so ",
  StyleBox["ByRef", "MR"],
  " parameters in methods written in Visual Basic will always need an initial \
value of the correct type, even if the method does not use the incoming \
value."
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell[TextData[{
  "Like Visual Basic .NET (but unlike C#), ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " allows you to pass a literal value instead of a symbol to an ",
  StyleBox["out", "MR"],
  " or ",
  StyleBox["ref", "MR"],
  " parameter. In such cases, any changes made to the parameter\
\[CloseCurlyQuote]s value are lost. Here is an example."
}], "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{

Cell["Uri`HexUnescape[\"abc%20def\", 3]", "Input",
  CellLabel->"In[56]:=",
  CellTags->"nlug:3.2.2"],

Cell[BoxData[
    \(32\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"nlug:3.2.2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Returning Objects ",
  StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
  "By Value",
  StyleBox["\[CloseCurlyDoubleQuote]", "TB"],
  " and ",
  StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
  "By Reference",
  StyleBox["\[CloseCurlyDoubleQuote]", "TB"]
}], "Subsection",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell["References and Values", "Subsubsection",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides a mapping between certain ",
  StyleBox["Mathematica", "TI"],
  " expressions and their .NET counterparts. What this means is that these ",
  StyleBox["Mathematica", "TI"],
  " expressions are automatically converted to and from their .NET \
counterparts as they are passed between ",
  StyleBox["Mathematica", "TI"],
  " and .NET. For example, .NET integer types (",
  StyleBox["Int32", "MR"],
  ", ",
  StyleBox["Int16", "MR"],
  ", ",
  StyleBox["Byte", "MR"],
  ", and so on) are converted to ",
  StyleBox["Mathematica", "TI"],
  " integers and .NET real types (",
  StyleBox["Single", "MR"],
  " and ",
  StyleBox["Double", "MR"],
  ") are converted to ",
  StyleBox["Mathematica", "TI"],
  " real numbers. Another mapping is that .NET objects are converted to ",
  StyleBox["NETObject", "MR"],
  " expressions in ",
  StyleBox["Mathematica", "TI"],
  ". These ",
  StyleBox["NETObject", "MR"],
  " expressions are ",
  StyleBox["references", "TI"],
  " to .NET objects\[LongDash]they have no meaning in ",
  StyleBox["Mathematica", "TI"],
  " except as they are manipulated by ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". However, some .NET objects are things that have meaningful values in ",
  StyleBox["Mathematica", "TI"],
  ", and these objects are by default converted to values. Examples of such \
objects are strings and arrays."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  "You could say, then, that .NET objects are by default returned to ",
  StyleBox["Mathematica", "TI"],
  " \[OpenCurlyDoubleQuote]by reference,\[CloseCurlyDoubleQuote] except for a \
few special cases. These special cases are numbers, strings, arrays, and \
booleans. You could say that these exceptional cases are returned \
\[OpenCurlyDoubleQuote]by value.\[CloseCurlyDoubleQuote] The table in the \
section on ",
  ButtonBox["Conversion of Types Between .NET and Mathematica",
    ButtonData:>"Conversion of Types Between .NET and Mathematica",
    ButtonStyle->"AddOnsLinkText"],
  " shows how these special .NET object types are mapped into ",
  StyleBox["Mathematica", "TI"],
  " values."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  "In summary, every .NET object that has a meaningful value representation \
in ",
  StyleBox["Mathematica", "TI"],
  " is converted into this value, simply because that is the most useful \
behavior. There are times, however, when you might want to override this \
default behavior. Probably the most common reason for doing this is to avoid \
unnecessary traffic of large expressions over ",
  StyleBox["MathLink", "TI"],
  "."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ReturnAsNETObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["expr",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[Cell[TextData[{
                StyleBox["a .NET object returned by ", "TR"],
                StyleBox["expr", "TR",
                  FontSlant->"Italic"],
                StyleBox[" will be in the form of a reference", "TR"]
              }]],
              "MR"]},
          {
            RowBox[{
              StyleBox["NETObjectToExpression",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["obj",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["the",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["value",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["of",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox[\(the\  . NET\),
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["object",
                "TR"], 
              StyleBox[" ",
                "TR"], 
              StyleBox["obj",
                "TR",
                FontSlant->"Italic"], 
              StyleBox[" ",
                "TR",
                FontSlant->"Plain"], "as", " ", "a", " ", "Mathematica", " ", 
              "expression"}]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  StyleBox["\[OpenCurlyDoubleQuote]", "TR"],
  "By reference",
  StyleBox["\[CloseCurlyDoubleQuote]", "TR"],
  " and ",
  StyleBox["\[OpenCurlyDoubleQuote]", "TR"],
  "by value",
  StyleBox["\[CloseCurlyDoubleQuote]", "TR"],
  " control."
}], "Caption",
  CellTags->"nlug:3.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["ReturnAsNETObject", "Subsubsection",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  "Consider the case where you have a static method in class ",
  StyleBox["MyClass", "MR"],
  " called ",
  StyleBox["arrayAbs()", "MR"],
  " that takes an array of doubles and returns a new array where each element \
is the absolute value of the corresponding element in the argument array. The \
declaration of this method in C# syntax thus looks like ",
  StyleBox["double[] ArrayAbs(double[] a)", "MR"],
  ". This is how you would call such a method from ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(LoadJNETType["\<MyClass\>", StaticsVisible \[Rule] True];\)\), "\n", 
    \(ArrayAbs[{1. , \(-2. \), 3. , 4. }]\)}], "Input",
  CellLabel->"In[1]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    StyleBox[\({1. , 2. , 3. , 4. }\),
      "MR"]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]],

Cell[TextData[{
  "The above example is how you probably want the method to work: you pass a \
",
  StyleBox["Mathematica", "TI"],
  " list and get back a list. Now assume you have another method named ",
  StyleBox["ArraySqrt()", "MR"],
  " that acts like ",
  StyleBox["ArrayAbs()", "MR"],
  " except that it performs the S",
  StyleBox["qrt()", "MR"],
  " function instead of ",
  StyleBox["Abs()", "MR"],
  ". "
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArraySqrt[ArrayAbs[{1. , \(-2. \), 3. , 4. }]]\)], "Input",
  CellLabel->"In[3]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    StyleBox[\({1. , 1.41421, 1.73205, 2. }\),
      "MR"]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]],

Cell[TextData[{
  "In this computation, the original list is sent over ",
  StyleBox["MathLink", "TI"],
  " to .NET and a .NET array is created with these values. That array is \
passed as an argument to ",
  StyleBox["ArrayAbs()", "MR"],
  ", which itself creates and returns another array. This array is then sent \
back to ",
  StyleBox["Mathematica", "TI"],
  " via ",
  StyleBox["MathLink", "TI"],
  " to create a list, which is then promptly sent back to .NET as the \
argument for ",
  StyleBox["ArraySqrt()", "MR"],
  ". You can see that it was a waste of time to send the array data back to \
",
  StyleBox["Mathematica", "TI"],
  "\[LongDash]you had a perfectly good array (the one returned by the ",
  StyleBox["ArrayAbs()", "MR"],
  " method) living on the .NET side, ready to be passed to ",
  StyleBox["ArraySqrt()", "MR"],
  ", but instead you sent its contents back to ",
  StyleBox["Mathematica", "TI"],
  " only to have it immediately come back to .NET again as a new array with \
the same values! For this example, the cost is negligible, but what if the \
array had 200,000 elements?"
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  "What is needed is a way to let the array data remain in .NET and return \
only a reference to the array, not the actual data itself. This can be \
accomplished with the ",
  StyleBox["ReturnAsNETObject", "MR"],
  " function."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReturnAsNETObject[ArrayAbs[{1. , \(-2. \), 3. , 4. }]]\)], "Input",
  CellLabel->"In[4]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Double[]"] \[RightGuillemet]\),
      JLink`Objects`JavaObject4579100917761]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]],

Cell[TextData[{
  "Here is how the computation looks using ",
  StyleBox["ReturnAsNETObject", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArraySqrt[
      ReturnAsNETObject[ArrayAbs[{1. , \(-2. \), 3. , 4. }]]]\)], "Input",
  CellLabel->"In[5]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    StyleBox[\({1. , 1.41421, 1.73205, 2. }\),
      "MR"]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]],

Cell[TextData[{
  "Earlier you saw ",
  StyleBox["ArraySqrt()", "MR"],
  " being called with an argument that was a ",
  StyleBox["Mathematica", "TI"],
  " list of reals. Here it is being called with a reference to a .NET object \
that is a one-dimensional array of doubles. All arguments can be called from \
",
  StyleBox["Mathematica", "TI"],
  " with either a ",
  StyleBox["Mathematica", "TI"],
  " value or a reference to a .NET object of the appropriate type."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  "In summary, the ",
  StyleBox["ReturnAsNETObject", "MR"],
  " function causes methods and properties that return objects that would \
normally be converted into ",
  StyleBox["Mathematica", "TI"],
  " values to return references instead. It is often used as an optimization \
to avoid unnecessarily passing large amounts of data between ",
  StyleBox["Mathematica", "TI"],
  " and .NET, and as such it will be useful primarily for very large arrays \
and strings. Objects of most .NET types have no meaningful \
\[OpenCurlyDoubleQuote]by value\[CloseCurlyDoubleQuote] representation in ",
  StyleBox["Mathematica", "TI"],
  ", and they are always returned \[OpenCurlyDoubleQuote]by reference.\
\[CloseCurlyDoubleQuote] ",
  StyleBox["ReturnAsNETObject", "MR"],
  " is redundant these cases."
}], "Text",
  CellTags->"nlug:3.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["NETObjectToExpression", "Subsubsection",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  "In the previous subsection, you saw how the ",
  StyleBox["ReturnAsNETObject", "MR"],
  " function can be used to cause objects normally returned to ",
  StyleBox["Mathematica", "TI"],
  " by value to be returned by reference. It is necessary to have a function \
that does the reverse\[LongDash]takes a reference and converts it to its \
value representation. That function is ",
  StyleBox["NETObjectToExpression", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  "Keep in mind that almost always when you are dealing with a .NET object \
that has a meaningful \[OpenCurlyDoubleQuote]value\[CloseCurlyDoubleQuote] \
representation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the object will be automatically converted to this value when it is sent \
to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". There are some exceptions to this rule, and these are where ",
  StyleBox["NETObjectToExpression", "MR"],
  " becomes useful. You saw earlier that the ",
  StyleBox["ReturnAsNETObject", "MR"],
  " function can be used to force an object to be returned as a reference. \
Another way to get a reference is to call ",
  StyleBox["NETNew", "MR"],
  " or ",
  StyleBox["MakeNETObject", "MR"],
  ", as these functions always return an object reference. Here we create a \
",
  StyleBox["String", "MR"],
  " object explicitly."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NETNew["\<System.String\>", {65, \ 66, \ 67}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.String"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$3245443265855490]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]],

Cell[TextData[{
  "This converts the string reference to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " string."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell["NETObjectToExpression[%]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    \("ABC"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]],

Cell[TextData[{
  "The next section introduces the ",
  StyleBox["MakeNETObject", "MR"],
  " function, which is easier than using ",
  StyleBox["NETNew", "MR"],
  " to construct .NET objects out of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " strings, numbers, and arrays."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  StyleBox["NETObjectToExpression", "MR"],
  " also converts into their value representations some object types that are \
normally returned by reference: enumerations and collections (objects that \
implement the ",
  StyleBox["ICollection", "MR"],
  " interface). Enumeration types are discussed in the ",
  ButtonBox["Enums",
    ButtonData:>"Enums",
    ButtonStyle->"AddOnsLinkText"],
  " section. Collections can be usefully operated on in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as lists, but unlike arrays, collections might be expensive to iterate \
through, so ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " leaves them as references and does not automatically convert them to \
lists. If you want a list, use ",
  StyleBox["NETObjectToExpression", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell["This creates a collection object:", "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell["arrayList = NETNew[\"System.Collections.ArrayList\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Collections.ArrayList"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$100663297]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]],

Cell["Now populate it with values.", "Text",
  CellTags->"nlug:3.2.3"],

Cell["arrayList@Add[#]& /@ Range[10];", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.2.3"],

Cell[TextData[{
  StyleBox["NETObjectToExpression", "MR"],
  " converts the object reference to a list."
}], "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{

Cell["NETObjectToExpression[arrayList]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.2.3"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.3"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Overloaded Operators", "Subsection",
  CellTags->{"Overloaded Operators", "nlug:3.2.4"}],

Cell[TextData[{
  "Some .NET languages allow you to define overloaded operators such as ",
  StyleBox["+", "MR"],
  ", ",
  StyleBox[">", "MR"],
  ", and so on for a class. Support for overloading of operators is not \
required in a .NET language. C# and C++ allow it; Visual Basic .NET does not. \
An example of a class that defines a number of overloaded operators is ",
  StyleBox["System.TimeSpan", "MR"],
  ". For instance, it defines a ",
  StyleBox["+", "MR"],
  " operator so that you can add two ",
  StyleBox["TimeSpan", "MR"],
  " objects just like they were numbers. Here is what it looks like in C# \
code."
}], "Text",
  CellTags->"nlug:3.2.4"],

Cell["\<\
// C# code
TimeSpan t1 = new TimeSpan(2, 45, 55);  // 2 hrs, 45 mins, 55 secs.
TimeSpan t2 = new TimeSpan(3, 10, 25);  // 3 hrs, 10 mins, 25 secs.
TimeSpan sum = t1 + t2;\
\>", "Program",
  CellTags->"nlug:3.2.4"],

Cell[TextData[{
  "Because .NET languages are not required to support overloaded operators, \
any class that defines them should always provide some other means to \
accomplish the same operation, generally via a method call. The ",
  StyleBox["TimeSpan", "MR"],
  " class provides an ",
  StyleBox["Add()", "MR"],
  " method that you can use in languages like Visual Basic .NET that do not \
allow overloaded operators."
}], "Text",
  CellTags->"nlug:3.2.4"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " does not support overloaded operators in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " syntax, so you should seek out the method that performs the same \
operation. Here is the ",
  StyleBox["Add()", "MR"],
  " method to add two ",
  StyleBox["TimeSpan", "MR"],
  " objects."
}], "Text",
  CellTags->"nlug:3.2.4"],

Cell[CellGroupData[{

Cell["\<\
t1 = NETNew[\"System.TimeSpan\", 2, 4, 55];
t2 = NETNew[\"System.TimeSpan\", 3, 10, 25];
sum = t1@Add[t2];
sum@ToString[]\
\>", "Input",
  CellLabel->"In[63]:=",
  CellTags->"nlug:3.2.4"],

Cell[BoxData[
    \("05:15:20"\)], "Output",
  CellLabel->"Out[66]=",
  CellTags->"nlug:3.2.4"]
}, Open  ]],

Cell[TextData[{
  "Even if the class author ignored the .NET guidelines and failed to provide \
an alternative method for accomplishing the same operation as an overloaded \
operator, you could still invoke the operation from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This is because overloaded operators in C# and C++ are achieved \
internally through special static methods with names like ",
  StyleBox["op_XXX", "MR"],
  " where ",
  StyleBox["XXX", "MR"],
  " is the name of the operation. The class author does not write these \
methods directly\[LongDash]they are created by the compiler. Nonetheless, \
they can be called directly from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " like any other method. Here are all these cryptically-named methods in \
the ",
  StyleBox["TimeSpan", "MR"],
  " class."
}], "Text",
  CellTags->"nlug:3.2.4"],

Cell[CellGroupData[{

Cell["NETTypeInfo[\"System.TimeSpan\", \"Methods\", \"op_*\"]", "Input",
  CellLabel->"In[60]:=",
  CellTags->"nlug:3.2.4"],

Cell[BoxData[GridBox[{
        {""},
        {Cell[BoxData[
              RowBox[{\(\(\[FilledCircle]\)\(\ \)\), 
                StyleBox["Methods",
                  FontSize->18,
                  FontWeight->"Bold",
                  
                  FontSlant->
                    "Italic"], "\<\" (matching string pattern \
op_*)\"\>"}]]]},
        {
          RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
            StyleBox["op_Addition",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"bool\"\>", " ", 
            StyleBox["op_Equality",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"bool\"\>", " ", 
            StyleBox["op_GreaterThan",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"bool\"\>", " ", 
            StyleBox["op_GreaterThanOrEqual",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"bool\"\>", " ", 
            StyleBox["op_Inequality",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"bool\"\>", " ", 
            StyleBox["op_LessThan",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"bool\"\>", " ", 
            StyleBox["op_LessThanOrEqual",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
            StyleBox["op_Subtraction",
              FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
            StyleBox["op_UnaryNegation",
              FontWeight->"Bold"], "\<\"(TimeSpan t)\"\>"}]},
        {
          RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
            StyleBox["op_UnaryPlus",
              FontWeight->"Bold"], "\<\"(TimeSpan t)\"\>"}]}
        },
      ColumnAlignments->{Left},
      RowMinHeight->1.2]], "Output",
  AutoSpacing->False,
  CellTags->"nlug:3.2.4"]
}, Open  ]],

Cell[TextData[{
  "Even if there was no ",
  StyleBox["Add()", "MR"],
  " method in the ",
  StyleBox["TimeSpan", "MR"],
  " class, you could still add them together by invoking the ",
  StyleBox["op_Addition()", "MR"],
  " method. Note that as always when calling .NET names from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you map the underscore character to a U because underscore is not a \
legal character in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol."
}], "Text",
  CellTags->"nlug:3.2.4"],

Cell[CellGroupData[{

Cell["TimeSpan`opUAddition[t1, t2]@ToString[]", "Input",
  CellLabel->"In[62]:=",
  CellTags->"nlug:3.2.4"],

Cell[BoxData[
    \("05:15:20"\)], "Output",
  CellLabel->"Out[62]=",
  CellTags->"nlug:3.2.4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Casting", "Subsection",
  CellTags->{"Casting", "nlug:3.2.5"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  ".NET programs often include ",
  StyleBox["casts",
    FontSlant->"Italic"],
  ", where an object of one type is converted to another type. A typical \
example is where a programmer has a variable of type ",
  StyleBox["Object", "MR"],
  ", probably obtained as the result of a method call typed to return ",
  StyleBox["Object", "MR"],
  ", and wants to cast it to a derived type so that methods from that type \
can be called on it. This often occurs when dealing with collection classes, \
as they can hold objects of any type and thus their methods are typed to \
return nothing more specific than ",
  StyleBox["Object", "MR"],
  ". Here is the signature of the ",
  StyleBox["IList.Item", "MR"],
  " property, which extracts from a list the object at a given index."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
' Visual Basic .NET
Default Property Item(index As Integer) As Object

// C#
object this[int index] {get; set;}\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "In C# the ",
  StyleBox["Item", "MR"],
  " property is the indexer for the class, so it can be written with the \
above unusual syntax or as a property named ",
  StyleBox["Item", "MR"],
  ", like in Visual Basic. If you are putting, say, strings into an ",
  StyleBox["IList", "MR"],
  " and later extract one using the ",
  StyleBox["Item", "MR"],
  " property, you would have to cast it to a string to be able to assign it \
to a string variable."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
// C#
ArrayList aList = new ArrayList;
aList.Add(\"abc\");
...
string s = (string) aList[0];

' Visual Basic .NET
Dim aList As New ArrayList
aList.Add(\"abc\")
...
Dim s as String
s = CType(aList(0), String)\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "In Visual Basic .NET, a cast is performed using the ",
  StyleBox["CType()", "MR"],
  " function, and it is only necessary if ",
  StyleBox["Option Strict", "MR"],
  " is set."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "This type of cast is called a ",
  StyleBox["downcast",
    FontSlant->"Italic"],
  " because you are casting down the inheritance hierarchy (from a parent \
type to a derived type). Such downcasting is probably the most common form of \
casting (aside from the casting used to convert numbers of one type to \
another, such as ",
  StyleBox["int", "MR"],
  " to ",
  StyleBox["byte", "MR"],
  ")."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "Although you will see downcasting scattered throughout the C# and Visual \
Basic .NET programs that you might be trying to duplicate in ",
  StyleBox[".NET/Lin",
    FontSlant->"Italic"],
  StyleBox["k",
    FontSlant->"Italic"],
  ", downcasting is virtually ",
  StyleBox["never",
    FontSlant->"Italic"],
  " relevant in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". This is because casting between reference types is primarily a \
compile-time operation. In the above sample code, the programmer is telling \
the compiler that they know the object they just extracted from the ",
  StyleBox["ArrayList", "MR"],
  " is a string, and they want the compiler to allow them to treat it as one. \
But in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " objects are always returned to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as their true runtime types, so when you call the ",
  StyleBox["Item", "MR"],
  " property, you get back an object of type ",
  StyleBox["String", "MR"],
  ". It is completely irrelevant that the ",
  StyleBox["Item", "MR"],
  " property is typed to return ",
  StyleBox["Object", "MR"],
  ". In effect, downcasting is irrelevant and even impossible in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " because every object has its true runtime type\[LongDash]there is no type \
further down the inheritance hierarchy to cast an object to!"
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "The point of this preamble is to make it clear that the vast majority of \
casts you see in .NET programs are irrelevant in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". They are either conversions between numeric types (which are easily done \
in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by other means if they are even necessary at all), or downcasts from some \
general type, like ",
  StyleBox["Object", "MR"],
  ", to a more specific type (which are pointless because they are done for \
the sake of the compiler and there is no compilation stage in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ")."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "There are some places in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", however, where casting is necessary. One case is when working with COM \
objects. This is discussed in the section on ",
  ButtonBox["COM",
    ButtonData:>"COM",
    ButtonStyle->"AddOnsLinkText"],
  ", and will not be dealt with here. All the other cases where casting is \
necessary in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " are ",
  StyleBox["upcasts",
    FontSlant->"Italic"],
  ", where you are casting an object to a parent class or interface. The \
three situations where upcasting is necessary are as follows."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
   \[FilledSmallSquare]  to call a hidden parent-class implementation of a \
method
   \[FilledSmallSquare]  to call methods written using so-called \
\[OpenCurlyDoubleQuote]explicit interface implementation\
\[CloseCurlyDoubleQuote]
   \[FilledSmallSquare]  to call methods on a private class that implements a \
public interface\
\>", "ItemizedText",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "Note that these are relatively rare circumstances, and many programmers \
will never encounter them. Although these are nontrivial aspects of .NET \
programming, there is really no extra complexity introduced by ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "\[LongDash]these are precisely the cases where upcasting is required in \
C#, Visual Basic .NET, and other .NET languages. These three cases will be \
discussed individually in the following subsections."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "The function that casts a .NET object reference is ",
  StyleBox["CastNETObject", "MR"],
  ". You will see examples in the following subsections. ",
  StyleBox["CastNETObject", "MR"],
  " does not create a new object reference, just an \
\[OpenCurlyDoubleQuote]alias\[CloseCurlyDoubleQuote] of an existing object \
reference. This means that if you call ",
  StyleBox["ReleaseNETObject", "MR"],
  " on an object, the object and all casted references to it are freed. In \
other words, an object and its casted versions are really just different ways \
of viewing the same object, not separate references."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["CastNETObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["obj",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], Cell[TextData[{
                  "\"",
                  StyleBox["type",
                    FontSlant->"Italic"],
                  "\""
                }]]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"cast", " ", "the", " ", "object", " ", 
                StyleBox["obj",
                  FontSlant->"Italic"], " ", "to", " ", "the", " ", "given", 
                " ", "type"}], ",", " ", \(specified\ as\ a\ string\)}]},
          {
            RowBox[{
              StyleBox["CastNETObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["obj",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["NETType",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"cast", " ", "the", " ", "object", " ", 
                StyleBox["obj",
                  FontSlant->"Italic"], " ", "to", " ", "the", " ", "given", 
                " ", "type"}], ",", " ", 
              RowBox[{"specified", " ", "as", " ", "a", " ", 
                StyleBox["NETType",
                  "MR"], " ", "expression"}]}]}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "Casting ",
  StyleBox["NETObject", "MR"],
  " expressions. "
}], "Caption",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "The ",
  StyleBox["CastNETObject", "MR"],
  " function was introduced in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " 1.1."
}], "Text",
  CellTags->"nlug:3.2.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Calling Hidden Members from a Parent Class", "Subsubsection",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "A child class can hide members of its parent class by declaring members \
with the same name using the ",
  StyleBox["new", "MR"],
  " keyword (in C#) or ",
  StyleBox["Shadows", "MR"],
  " keyword (in Visual Basic .NET). Consider the following classes."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
// C# code
public class Parent {
\tpublic string Foo() { return \"from parent\"; }
}

public class Child : Parent {
\tpublic new string Foo() { return \"from child\"; }
}\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "If you had an instance of the ",
  StyleBox["Child", "MR"],
  " class, but wanted to call the ",
  StyleBox["Parent", "MR"],
  " implementation of ",
  StyleBox["Foo()", "MR"],
  ", you could do this by casting the ",
  StyleBox["Child", "MR"],
  " instance to the ",
  StyleBox["Parent", "MR"],
  " class."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
// C# code
Child c = new Child();
string s1 = c.Foo();             // s1 gets the value \"from child\"
string s2 = ((Parent) c).Foo();  // s2 gets the value \"from parent\"\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "The behavior is the same whether the ",
  StyleBox["Foo()", "MR"],
  " method is declared ",
  StyleBox["virtual", "MR"],
  " or not in the ",
  StyleBox["Parent", "MR"],
  " class. Note that the ",
  StyleBox["new", "MR"],
  " keyword (",
  StyleBox["Shadows", "MR"],
  " in Visual Basic .NET) is not strictly required, although the compiler \
will generate a warning if it is left out."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "To call the ",
  StyleBox["Parent", "MR"],
  " class implementation of ",
  StyleBox["Foo()", "MR"],
  " using ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", use ",
  StyleBox["CastNETObject", "MR"],
  " to cast the object to the ",
  StyleBox["Parent", "MR"],
  " class, exactly as was done in the C# code."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{

Cell["child = NETNew[\"Child\"]", "Input",
  CellLabel->"In[1]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Child"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$2067774557913089]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["parentCast = CastNETObject[child, \"Parent\"]", "Input",
  CellLabel->"In[2]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Parent"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$2067774557913089]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["parentCast@Foo[]", "Input",
  CellLabel->"In[3]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \(from\ parent\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell["Of course the two references refer to the same object.", "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{

Cell["SameObjectQ[parentCast, child]", "Input",
  CellLabel->"In[4]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Explicit Interface Implementation", "Subsubsection",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "If a class implements two interfaces that each have a method of the same \
name, it can choose to give each interface member a separate implementation. \
This is called ",
  StyleBox["explicit interface implementation",
    FontSlant->"Italic"],
  ". This technique is generally only used when the methods from the two \
interfaces are so different conceptually that there is no way to provide a \
single implementation that satisfies the contracts of both interfaces. Here \
is a simplified example from the .NET SDK documentation. The ",
  StyleBox["Box", "MR"],
  " class implements ",
  StyleBox["IEnglishDimensions", "MR"],
  " and ",
  StyleBox["IMetricDimensions", "MR"],
  ", which both have a ",
  StyleBox["Length()", "MR"],
  " method, and of course there is no single implementation of ",
  StyleBox["Length()", "MR"],
  " that can work for both interfaces."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
// C# code

interface IEnglishDimensions {
   double Length();
}

interface IMetricDimensions {
   double Length();
}

class Box : IEnglishDimensions, IMetricDimensions {

   double lengthInches;
   
   public Box(double length) {
      lengthInches = length;
   }
   
   // Explicitly implement for IEnglishDimensions:
   double IEnglishDimensions.Length() {
      return lengthInches;
   }

   // Explicitly implement for IMetricDimensions:
   double IMetricDimensions.Length() {
      return lengthInches * 2.54;
   }
}\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "Here is how you would call these methods. You must cast the ",
  StyleBox["Box", "MR"],
  " object to either the ",
  StyleBox["IMetricDimensions", "MR"],
  " or ",
  StyleBox["IEnglishDimensions", "MR"],
  " interface before you can call the ",
  StyleBox["Length()", "MR"],
  " method."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
Box myBox = new Box(30.0);
double englishLength = ((IEnglishDimensions) myBox).Length();
double metricLength = ((IMetricDimensions) myBox).Length();\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "Here is how you would do the same thing in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
myBox = NETNew[\"Box\"];
englishLength = CastNETObject[myBox, \"IEnglishDimensions\"]@Length[];
metricLength = CastNETObject[myBox, \"IMetricDimensions\"]@Length[];\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "Here is a real-world example. The ",
  StyleBox["Array", "MR"],
  " class (which is the parent class for all arrays in .NET) uses explicit \
interface implementation for methods from the ",
  StyleBox["IList", "MR"],
  " interface. If a class uses explicit interface implementation for some of \
its methods this should be mentioned clearly in the documentation, and this \
is true for the ",
  StyleBox["Array", "MR"],
  " class. One method from the ",
  StyleBox["IList", "MR"],
  " interface is ",
  StyleBox["Contains()", "MR"],
  ". You cannot call this directly on an array object, even though ",
  StyleBox["Array", "MR"],
  " implements ",
  StyleBox["IList", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{

Cell["arr = MakeNETObject[{2, 4, 6, 8}]", "Input",
  CellLabel->"In[6]:=",
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Int32[]"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$100663297]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["arr@Contains[6]", "Input",
  CellLabel->"In[9]:=",
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \(NET::"nomethod" \(\(:\)\(\ \)\) 
      "No public instance method named Contains exists for the .NET type \
System.Int32[]."\)], "Message",
  CellLabel->"From In[9]:=",
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[TextData[{
  "It works if you cast to ",
  StyleBox["IList", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{

Cell["CastNETObject[arr, \"System.Collections.IList\"]@Contains[6]", "Input",
  CellLabel->"In[10]:=",
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Private Class, Public Interface", "Subsubsection",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "A final case where upcasting is necessary in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " can occur when you have a method that is typed to return an interface, \
and the implementation of the method returns an object of a  ",
  StyleBox["non-public",
    FontSlant->"Italic"],
  " class that implements that interface. This is perfectly legal, but it can \
cause problems for ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". When you reflect on a non-public class to obtain all its public members \
(",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " calls all methods via reflection), you only see the methods that are \
implemented by some public parent class. Just because a class implements a \
public interface does not mean that you can call those methods on an instance \
of that class. If the class itself is not public, even though its methods are \
public, you can call them only on an instance of the class that is typed as a \
public parent class or interface."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "This may sound confusing, so consider the following example. Assume an \
interface called ",
  StyleBox["IFoo", "MR"],
  " and an internal class that implements ",
  StyleBox["IFoo", "MR"],
  " (internal classes are visible only to other types within the same \
assembly)."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
interface IFoo {
\tint Foo();
}

internal class InternalIFooImpl : IFoo {
\tpublic int Foo() { return 42; }
}\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "Now assume there is some other class that has a method type to return ",
  StyleBox["IFoo", "MR"],
  " that returns an instance of the ",
  StyleBox["InternalIFooImpl", "MR"],
  " class."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
public class FooFactory {
\tpublic static IFoo CreateIFoo() { return new InternalIFooImpl(); }
}\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{

Cell["\<\
LoadNETType[\"FooFactory\"];
foo = FooFactory`CreateIFoo[]\
\>", "Input",
  CellLabel->"In[1]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "InternalIFooImpl"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$2067774557913089]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[TextData[{
  "It doesn\[CloseCurlyQuote]t work to call the ",
  StyleBox["Foo()", "MR"],
  " method on the ",
  StyleBox["foo", "MR"],
  " object because it is typed as a non-public class. "
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{

Cell["foo@Foo[]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \(NET::"nomethod" \(\(:\)\(\ \)\) 
      "No public instance method named Foo exists for the .NET type \
InternalIFooImpl."\)], "Message",
  CellLabel->"From In[3]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The error message isn\[CloseCurlyQuote]t very accurate \
above\[LongDash]there ",
  StyleBox["is",
    FontSlant->"Italic"],
  " a public method named ",
  StyleBox["Foo()", "MR"],
  " in the ",
  StyleBox["InternalIFooImpl", "MR"],
  " class, it just cannot be seen via reflection because the class itself is \
not public. This sort of thing never shows up in C# or Visual Basic .NET \
because the variable that holds the result of ",
  StyleBox["CreateIFoo()", "MR"],
  " will be typed as the public interface ",
  StyleBox["IFoo", "MR"],
  ". The programmer would never have any reason to see or even know about the \
",
  StyleBox["InternalIFooImpl", "MR"],
  " class. The code looks like the following."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell["\<\
// C# code
IFoo foo = FooFactory`CreateIFoo();
int result = foo.Foo();\
\>", "Program",
  CellTags->"nlug:3.2.5"],

Cell[TextData[{
  "In ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", however, objects are seen by default as their true runtime types, so we \
end up with an instance of an object that is typed as a non-public class. The \
solution is to do what is done in C# and Visual Basic .NET: upcast the object \
to the ",
  StyleBox["IFoo", "MR"],
  " interface."
}], "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{

Cell["\<\
ifoo = CastNETObject[foo, \"IFoo\"];
ifoo@Foo[]\
\>", "Input",
  CellLabel->"In[3]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],

Cell[BoxData[
    \(42\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[TextData[{
  "The \[OpenCurlyDoubleQuote]factory\[CloseCurlyDoubleQuote] design pattern \
in the above example is relatively common. A special object-creation method \
returns objects typed only as some interface. This allows the designer of the \
library to document an interface only, and hide the implementation details in \
private classes. Clients of the library write only to the interface and are \
kept completely isolated from details like the actual names of the \
implementation classes. This suggests that the need for upcasting a \
non-public class to an interface type would not be rare for ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " programmers. In practice, however, it is often the case that the \
non-public class inherits implementations of at least some of its methods \
from a public parent class. If this is the case, these methods will be found \
and can be invoked on the non-public child class without casting."
}], "Text",
  CellTags->"nlug:3.2.5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Indexers", "Subsection",
  CellTags->"nlug:3.2.6"],

Cell[TextData[{
  "Some .NET classes define a special member that permits instances of the \
class to be accessed in the same way as arrays. This special member is called \
an ",
  StyleBox["indexer",
    FontSlant->"Italic"],
  " in C# terminology, and a ",
  StyleBox["default parameterized property",
    FontSlant->"Italic"],
  " in Visual Basic .NET terminology. Here are skeleton definitions of \
example members in C# and Visual Basic .NET."
}], "Text",
  CellTags->"nlug:3.2.6"],

Cell["\<\
// C# indexer
public int this[int i] {
\tget { ... }
\tset { ... }
}

// VB default parameterized property
Default Public Property Item(ByVal i As Integer) As Integer
    Get
    \t...
    End Get
    Set(ByVal Value As Integer)
    \t...
    End Set
End Property\
\>", "Program",
  CellTags->"nlug:3.2.6"],

Cell[TextData[{
  "Indexers allow a class to act as if it were an array even though it is \
not. Most of the .NET collection classes (classes that implement the ",
  StyleBox["ICollection", "MR"],
  " interface) support an indexer so that elements can be set and retrieved \
using a simple array-like syntax. If a class had a definition like one of the \
above, you could access the \[OpenCurlyDoubleQuote]",
  StyleBox["i",
    FontSlant->"Italic"],
  "th element\[CloseCurlyDoubleQuote] using code like the following."
}], "Text",
  CellTags->"nlug:3.2.6"],

Cell["\<\
// C#
int firstElement = obj[0];

' VB
firstElement = obj(0)\
\>", "Program",
  CellTags->"nlug:3.2.6"],

Cell[TextData[{
  "If a class defines an indexer, you can call the indexer in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using function brackets."
}], "Text",
  CellTags->"nlug:3.2.6"],

Cell["\<\
(* Call indexer *)
firstElement = obj[0];\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.6"],

Cell[TextData[{
  "Note that there is no method or property name in the above \
code\[LongDash]just an \
\[OpenCurlyDoubleQuote]argument\[CloseCurlyDoubleQuote] to the object itself, \
as if it were a function. It could be argued that ",
  StyleBox["Part", "MR"],
  "-based syntax (i.e., using ",
  StyleBox["obj[[0]]", "MR"],
  ") would be more suitable for calling indexers in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", as it is the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " equivalent of array access, but that syntax was rejected for various \
philosophical and technical reasons."
}], "Text",
  CellTags->"nlug:3.2.6"],

Cell[TextData[{
  "Here is another example of calling an indexer using the ",
  StyleBox["BitArray", "MR"],
  " class, which is a collection of true/false values that is stored in a \
very compact way. This class defines an indexer so that it can be treated \
like an array."
}], "Text",
  CellTags->"nlug:3.2.6"],

Cell[CellGroupData[{

Cell["\<\
bitArray = NETNew[\"System.Collections.BitArray\", {True, False, True}]\
\>", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.2.6"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Collections.BitArray"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$100663297]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.6"]
}, Open  ]],

Cell["\<\
This calls the indexer to get the second element (because it is a zero-based \
index).\
\>", "Text",
  CellTags->"nlug:3.2.6"],

Cell[CellGroupData[{

Cell["bitArray[1]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.2.6"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.2.6"]
}, Open  ]],

Cell[TextData[{
  "If you write a class in C# and give it an indexer, the compiler creates a \
public property named ",
  StyleBox["Item", "MR"],
  " for you. This is a parameterized property, meaning that it takes an \
argument like a method call. The indexer syntax is just a shorthand for \
calling the ",
  StyleBox["Item", "MR"],
  " property. If you are writing in Visual Basic .NET, the convention is that \
your default parameterized property should be named ",
  StyleBox["Item", "MR"],
  ", but this is not a requirement. Whatever the default parameterized \
property is named, you can skip the indexer-style syntax and call the poperty \
directly from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " if you wish."
}], "Text",
  CellTags->"nlug:3.2.6"],

Cell[CellGroupData[{

Cell["bitArray@Item[1]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.2.6"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exceptions", "Subsection",
  CellTags->{"Exceptions", "nlug:3.2.7"}],

Cell[CellGroupData[{

Cell["How Exceptions Are Handled", "Subsubsection",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " handles .NET exceptions automatically. If an uncaught exception is thrown \
during any call into .NET, you will get a message in ",
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  StyleBox[".", "TI"],
  " Here is an example that tries to format a real number as an integer."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(LoadNETType["\<System.Int32\>"];\)\), "\[IndentingNewLine]", 
    \(Int32`Parse["\<1234.5\>"]\)}], "Input",
  CellLabel->"In[26]:=",
  CellTags->"nlug:3.2.7"],

Cell[BoxData[
    \(NET::"netexcptn" \(\(:\)\(\ \)\) 
      "A .NET exception occurred: System.FormatException: Input string was \
not in a correct format.\n   at System.Number.ParseInt32(String s, \
NumberStyles style, NumberFormatInfo info)\n   at System.Int32.Parse(String \
s, NumberStyles style, IFormatProvider provider)\n   at \
System.Int32.Parse(String s)."\)], "Message",
  CellLabel->"From In[26]:=",
  CellTags->"nlug:3.2.7"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"nlug:3.2.7"]
}, Open  ]],

Cell[TextData[{
  "If an exception is thrown, the result of the call will be ",
  StyleBox["$Failed", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  "If the .NET code was compiled with debugging information included, the ",
  StyleBox["Mathematica", "TI"],
  " message you get as a result of an exception will show the full stack \
trace to the point where the exception occurred, with the exact line numbers \
in each file."
}], "Text",
  CellTags->"nlug:3.2.7"]
}, Closed]],

Cell[CellGroupData[{

Cell["GetNETException", "Subsubsection",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  "You can use the function ",
  StyleBox["GetNETException", "MR"],
  " to get the ",
  StyleBox["Exception", "MR"],
  " object for the exception thrown in the last call from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to .NET. It returns ",
  StyleBox["Null", "MR"],
  " if no exception was thrown. Most programmers will have no use for this \
function, but you could use it to implement a special exception-handling \
feature in your programs. Below you see the exception thrown by the previous \
call to ",
  StyleBox["Int32.Parse()", "MR"],
  ". You can see that most exceptions that occur will come back wrapped in a \
special ",
  StyleBox["CallNETException", "MR"],
  " object that wraps the actual exception thrown using the standard .NET \
design pattern for \[OpenCurlyDoubleQuote]inner exceptions\
\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{

Cell["exc = GetNETException[]", "Input",
  CellLabel->"In[28]:=",
  CellTags->"nlug:3.2.7"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Wolfram.NETLink.Internal.CallNETException"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$369098753]], "Output",
  CellLabel->"Out[28]=",
  CellTags->"nlug:3.2.7"]
}, Open  ]],

Cell[TextData[{
  "To get the actual exception thrown, you must examine the ",
  StyleBox["InnerException", "MR"],
  " property."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{

Cell["innerExc = exc@InnerException", "Input",
  CellLabel->"In[29]:=",
  CellTags->"nlug:3.2.7"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Reflection.TargetInvocationException"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$385875969]], "Output",
  CellLabel->"Out[29]=",
  CellTags->"nlug:3.2.7"]
}, Open  ]],

Cell["\<\
In this example the .NET reflection system has wrapped the exception in \
another exception, so you have to dig one level deeper to see the \
\[OpenCurlyDoubleQuote]real\[CloseCurlyDoubleQuote] one.\
\>", "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{

Cell["innerExc@InnerException", "Input",
  CellLabel->"In[30]:=",
  CellTags->"nlug:3.2.7"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.FormatException"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$402653185]], "Output",
  CellLabel->"Out[30]=",
  CellTags->"nlug:3.2.7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Custom Exception Handling", "Subsubsection",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  "Very advanced programmers might want to implement their own system for \
exception handling and/or reporting. For example, you might want to use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s ",
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  " functions to handle .NET exceptions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code, using the same programming style that is used in .NET languages. An \
even simpler example is the desire to silence exception messages in a certain \
block of code."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  "To implement custom handling for .NET exceptions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", use the symbol ",
  StyleBox["$NETExceptionHandler", "MR"],
  ". The value of ",
  StyleBox["$NETExceptionHandler", "MR"],
  " is treated as a function that will be passed three arguments: the symbol \
associated with the message (this will usually be the symbol ",
  StyleBox["NET", "MR"],
  "), the message tag (this will typically be the string \
\[OpenCurlyDoubleQuote]netexcptn\[CloseCurlyDoubleQuote]), and the \
descriptive string of text associated with the message."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  "You will usually set ",
  StyleBox["$NETExceptionHandler", "MR"],
  " within a ",
  StyleBox["Block", "MR"],
  " so that its effect will be limited to a precisely defined segment of \
code, as in the following example that silences messages."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell["\<\
   Block[{$NETExceptionHandler = Null&},
      obj@Method[]
   ]\
\>", "Input",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  "You can use ",
  StyleBox["GetNETException", "MR"],
  " within your handler function to obtain the actual .NET exception object \
that was thrown. Here is an example."
}], "Text",
  CellTags->"nlug:3.2.7"],

Cell["\<\
   exceptionThrower = Throw[GetNETException[]]&;

   Block[{$NETExceptionHandler = exceptionThrower},
      ... code that calls .NET ...
   ]\
\>", "Input",
  CellTags->"nlug:3.2.7"],

Cell[TextData[{
  "You should avoid setting ",
  StyleBox["$NETExceptionHandler", "MR"],
  " outside of a ",
  StyleBox["Block", "MR"],
  ", as you are almost sure to inadvertently create situations where its \
value does not get cleared, leaving users scratching their heads wondering \
why their exceptions are not being handled like they expect."
}], "Text",
  CellTags->"nlug:3.2.7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Nested Types", "Subsection",
  CellTags->"nlug:3.2.8"],

Cell["\<\
Some .NET types have declarations of other types nested within them. Here is \
an example in C#.\
\>", "Text",
  CellTags->"nlug:3.2.8"],

Cell["\<\
namespace SomeNamespace {
\t
\tpublic class Outer {
\t
\t\tpublic int Foo() { return 42; }
\t\tpublic static int StaticFoo() { return 42; }
\t\t
\t\tpublic class Inner {
\t\t\tpublic int InnerFoo() { return 42; }
\t\t\tpublic static int StaticInnerFoo() { return 42; }
\t\t}
\t}
}\
\>", "Program",
  CellTags->"nlug:3.2.8"],

Cell[TextData[{
  "In .NET, the ",
  StyleBox["+", "MR"],
  " character is used in a type name to separate the name of an inner class \
from its outer class. In the above example, the actual type name of the ",
  StyleBox["Inner", "MR"],
  " class is ",
  StyleBox["SomeNamespace.Outer+Inner", "MR"],
  ". This is the name you must use in ",
  StyleBox["LoadNETType", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{

Cell["innerClass = LoadNETType[\"SomeNamespace.Outer+Inner\"]", "Input",
  CellLabel->"In[1]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.8"],

Cell[BoxData[
    \(NETType["SomeNamespace.Outer+Inner", 25]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.8"]
}, Open  ]],

Cell[TextData[{
  "You also use type names in ",
  StyleBox["NETNew", "MR"],
  ". Here is how you construct an instance of the ",
  StyleBox["Inner", "MR"],
  " class."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{

Cell["innerObj = NETNew[\"SomeNamespace.Outer+Inner\"]", "Input",
  CellLabel->"In[2]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.8"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "SomeNamespace.Outer+Inner"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$436207618]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.2.8"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["+", "MR"],
  " character only appears in type ",
  StyleBox["names",
    FontSlant->"Italic"],
  ". When referring to a nested type in ",
  StyleBox["code",
    FontSlant->"Italic"],
  ", use the standard scope resolution operator (the period in C# and Visual \
Basic .NET) to separate the inner class from the outer class."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell["\<\
// C# code
Outer.Inner obj = new Outer.Inner();\
\>", "Program",
  CellTags->"nlug:3.2.8"],

Cell[TextData[{
  "Although most .NET languages allow the above syntax for nested types, keep \
in mind that the actual type names use the ",
  StyleBox["+", "MR"],
  " character to separate the inner type from the outer one. In ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", whenever you enter a type name ",
  StyleBox["as a string",
    FontSlant->"Italic"],
  ", you must use the ",
  StyleBox["+", "MR"],
  " notation."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell["\<\
You call instance methods on objects of nested types in the usual way.\
\>", "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{

Cell["innerObj@InnerFoo[]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.2.8"],

Cell[BoxData[
    \(42\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.8"]
}, Open  ]],

Cell[TextData[{
  "Here is how to call a static member. Notice that as in C# and Visual Basic \
.NET, the ",
  StyleBox["+", "MR"],
  " character disappears and is replaced by the scope resolution operator (",
  StyleBox["`", "MR"],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{

Cell["Outer`Inner`StaticInnerFoo[]", "Input",
  CellLabel->"In[4]:=",
  CellTags->"nlug:3.2.8"],

Cell[BoxData[
    \(42\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.2.8"]
}, Open  ]],

Cell[TextData[{
  "Another point to note about the above line is that you cannot refer to a \
static member of a nested class using simply the inner class name, as in ",
  StyleBox["Inner`StaticInnerFoo[", "MR"],
  StyleBox["]", "MR"],
  ". This is to be expected, since you cannot do this in other .NET languages \
either. You always need to prefix the inner class name with the outer one."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell[TextData[{
  "Here is a real-world example. The ",
  StyleBox["System.Environment", "MR"],
  " class has a nested enum called ",
  StyleBox["SpecialFolder", "MR"],
  ". This enum contains constants that designate special locations within the \
Windows operating system (it has values that include ",
  StyleBox["ProgramFiles", "MR"],
  ", ",
  StyleBox["Recent", "MR"],
  ", ",
  StyleBox["System", "MR"],
  ", ",
  StyleBox["StartMenu", "MR"],
  ", and so on). Here is how to determine the path to the user\
\[CloseCurlyQuote]s Favorites folder. You need to call static members from \
the ",
  StyleBox["System.Environment", "MR"],
  " class and the ",
  StyleBox["System.Environment.SpecialFolder", "MR"],
  " enum (members of an enum are static), so first you load these two types. \
Note the ",
  StyleBox["+", "MR"],
  " in the type name."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell["\<\
LoadNETType[\"System.Environment\"];
LoadNETType[\"System.Environment+SpecialFolder\"];\
\>", "Input",
  CellLabel->"In[5]:=",
  CellTags->"nlug:3.2.8"],

Cell[TextData[{
  "The ",
  StyleBox["GetFolderPath()", "MR"],
  " method takes members of the ",
  StyleBox["SpecialFolder", "MR"],
  " enumeration and gets the appropriate path as a string. Note how we refer \
to the ",
  StyleBox["Favorites", "MR"],
  " member of the ",
  StyleBox["SpecialFolder", "MR"],
  " enum."
}], "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{

Cell["\<\
Environment`GetFolderPath[Environment`SpecialFolder`Favorites]\
\>", "Input",
  CellLabel->"In[7]:=",
  CellTags->"nlug:3.2.8"],

Cell[BoxData[
    \("C:\\Documents and Settings\\tgayley\\Favorites"\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"nlug:3.2.8"]
}, Open  ]],

Cell[TextData[{
  "In summary, the important point to remember about nested types is that \
when you need to refer to the name of one in a ",
  StyleBox["string",
    FontSlant->"Italic"],
  ", you use the ",
  StyleBox["+", "MR"],
  " character to separate the outer type from the inner type. When you refer \
to a type in ",
  StyleBox["code",
    FontSlant->"Italic"],
  ", you go back to using the familiar ",
  StyleBox["`", "MR"],
  " to separate the outer and inner names."
}], "Text",
  CellTags->"nlug:3.2.8"]
}, Closed]],

Cell[CellGroupData[{

Cell["MakeNETObject", "Subsection",
  CellTags->"nlug:3.2.9"],

Cell[TextData[{
  "The most common way to create a .NET object is to call a constructor via \
",
  StyleBox["NETNew", "MR"],
  ". Sometimes, however, you have a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression that you want to convert into a .NET object but the class does \
not have a convenient constructor. A common example is if you want to create \
an array object out of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list. You can call an array constructor via ",
  StyleBox["NETNew", "MR"],
  ", but you cannot initialize the array with values via the constructor. \
This example creates an array object with ",
  StyleBox["NETNew", "MR"],
  " and fills it manually."
}], "Text",
  CellTags->"nlug:3.2.9"],

Cell[CellGroupData[{

Cell["intArray = NETNew[\"System.Int32[]\", 3]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.2.9"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Int32[]"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$234881025]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.9"]
}, Open  ]],

Cell["\<\
intArray@SetValue[42, 0];
intArray@SetValue[43, 1];
intArray@SetValue[44, 2];\
\>", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.2.9"],

Cell[TextData[{
  "You can do this much more easily using ",
  StyleBox["MakeNETObject", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.2.9"],

Cell[CellGroupData[{

Cell["intArray2 = MakeNETObject[{42, 43, 44}]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"nlug:3.2.9"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Int32[]"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$251658241]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"nlug:3.2.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MakeNETObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["val",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[Cell[TextData[{
                
                "construct an object of the appropriate type to represent the \
",
                StyleBox["Mathematica",
                  FontSlant->"Italic"],
                StyleBox[" ", "TR"],
                " expression ",
                StyleBox["val",
                  FontSlant->"Italic"],
                " (numbers, strings, lists, and so on",
                ")."
              }]],
              "Text"]},
          {
            RowBox[{
              StyleBox["MakeNETObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["val",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["type",
                  "TI",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], \(construct\ an\ object\ of\ the\ specified\ type\)}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.2.9"],

Cell[TextData[{
  StyleBox["MakeNETObject", "MR"],
  "."
}], "Caption",
  CellTags->"nlug:3.2.9"],

Cell[TextData[{
  "Keep in mind that you rarely have to call ",
  StyleBox["MakeNETObject", "MR"],
  ". When you call a method that takes an array, for example, you can just \
pass a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list and ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will create the .NET array for you. There are times, however, when you \
want to explicitly create a .NET object that must be populated with data from \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and there is no convenient constructor. An example of a circumstance \
where ",
  StyleBox["MakeNETObject", "MR"],
  " is useful is the following method, which reverses a list passed in as an \
argument. Note that it does not return the reversed list, but rather reverses \
it",
  " in place",
  "."
}], "Text",
  CellTags->"nlug:3.2.9"],

Cell["public static void ReverseArray(int[] a);", "Program",
  CellTags->"nlug:3.2.9"],

Cell[TextData[{
  "You could call this method with a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list, but there would be no way to get back the reversed list. The way \
around this problem is to create an array object populated with the initial \
list values, pass the object reference, let its internal data be reversed, \
and then convert the object reference back to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "Text",
  CellTags->"nlug:3.2.9"],

Cell["MyClass`ReverseArray[intArray2]", "Input",
  CellLabel->"In[7]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.9"],

Cell[CellGroupData[{

Cell["NETObjectToExpression[intArray2]", "Input",
  CellLabel->"In[8]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.9"],

Cell[BoxData[
    \({44, 43, 42}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"nlug:3.2.9"]
}, Open  ]],

Cell[TextData[{
  "Another case where is useful is if you need to give ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " a little help in choosing the correct signature of an overloaded method. \
Consider the following two overloads of a method."
}], "Text",
  CellTags->"nlug:3.2.9"],

Cell["\<\
public void Foo(byte b);
public void Foo(long l);\
\>", "Program",
  CellTags->"nlug:3.2.9"],

Cell[TextData[{
  "If you called ",
  StyleBox["Foo()", "MR"],
  " from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with an integer, the overload with the ",
  StyleBox["long", "MR"],
  " parameter would be called. This is because ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " generally tries to call the method with the widest possible type at each \
slot (but there is no formal guarantee, especially in complicated cases). If \
you want to call the ",
  StyleBox["byte", "MR"],
  " version, you can do this by creating a .NET object of the ",
  StyleBox["Byte", "MR"],
  " type, because ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " always gives preference to a method signature that is an exact match for \
the incoming argument types."
}], "Text",
  CellTags->"nlug:3.2.9"],

Cell["obj@Foo[MakeNETObject[42, \"System.Byte\"]]", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.9"],

Cell[TextData[{
  "Remember that ",
  StyleBox["MakeNETObject", "MR"],
  " is a rarely used function. You do not need to explicitly construct .NET \
objects from ",
  StyleBox["Mathematica", "TI"],
  " strings, arrays, and so on, just to pass them to .NET \
methods\[LongDash]",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " does this automatically for you. There are a few special circumstances \
outlined above where it is useful."
}], "Text",
  CellTags->"nlug:3.2.9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Complex Numbers", "Subsection",
  CellTags->"nlug:3.2.10"],

Cell[TextData[{
  ".NET number types (e.g., ",
  StyleBox["byte", "MR"],
  ", ",
  StyleBox["int", "MR"],
  ", ",
  StyleBox["double", "MR"],
  ") are returned to ",
  StyleBox["Mathematica", "TI"],
  " as integers and reals, and integers and reals are converted to the \
appropriate types when sent as arguments to .NET. What about complex numbers? \
It would be nice to have a .NET type representing complex numbers that mapped \
directly to ",
  StyleBox["Mathematica", "TI"],
  "\[CloseCurlyQuote]s ",
  StyleBox["Complex", "MR"],
  " type, so that automatic conversions would occur as they were passed back \
and forth between ",
  StyleBox["Mathematica", "TI"],
  " and .NET. .NET does not have a standard type for complex numbers, so ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " lets you name the type that you want to participate in this mapping."
}], "Text",
  CellTags->"nlug:3.2.10"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SetComplexType",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["\<\"classname\"\>",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "set the class to be mapped to complex numbers in ",
              StyleBox["Mathematica",
                FontSlant->"Italic"]
            }]]},
          {
            StyleBox[\(GetComplexType[]\),
              
              "MR"], \(return\ the\ class\ currently\ used\ for\ complex\ \
numbers\)}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.2.10"],

Cell["Setting the type for complex numbers.", "Caption",
  CellTags->"nlug:3.2.10"],

Cell["\<\
You can use any class or struct you like as long as it has the following \
properties:\
\>", "Text",
  CellTags->"nlug:3.2.10"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  A public constructor that takes two doubles or two floats (the real and \
imaginary parts, in that order)"
}], "ItemizedText",
  CellTags->"nlug:3.2.10"],

Cell[TextData[{
  StyleBox["2.",
    FontWeight->"Bold"],
  "  Public methods, properties, or fields for the real and imaginary parts, \
having one of the following signatures:"
}], "ItemizedText",
  CellTags->"nlug:3.2.10"],

Cell[TextData[{
  StyleBox["One of:\n",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdouble Re()\n\tdouble Real()\n\tfloat Re()\n\tfloat Real()\n\n",
  StyleBox["And one of:",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontFamily->"Times New Roman"],
  "\n\tdouble Im()\n\tdouble Imag()\n\tdouble Imaginary()\n\tfloat Im()\n\t\
float Imag()\n\tfloat Imaginary()\n\n",
  StyleBox["Or a property or field:",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontFamily->"Times New Roman"],
  "\n\tdouble Re\n\tdouble Real\n\tfloat Re\n\tfloat Real\n\n",
  StyleBox["And one of:",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontFamily->"Times New Roman"],
  "\n\tdouble Im\n\tdouble Imag\n\tdouble Imaginary\n\tfloat Im\n\tfloat Imag\
\n\tfloat Imaginary"
}], "Program",
  CellTags->"nlug:3.2.10"],

Cell["Here is a trivial complex number class in C#.", "Text",
  CellTags->"nlug:3.2.10"],

Cell["\<\
namespace MyCompany {

\tpublic struct Complex {

\t\tpublic double Re, Im;

\t\tpublic Complex(double re, double im) {
\t\t\tRe = re;
\t\t\tIm = im;
\t\t}

\t\tpublic Complex Add(Complex c) {
\t\t\treturn this + c;
\t\t}

\t\tpublic static Complex operator+(Complex a, Complex b) {
\t\t\treturn new Complex(a.Re + b.Re, a.Im + b.Im);
\t\t}
\t}
}\
\>", "Program",
  CellTags->"nlug:3.2.10"],

Cell[TextData[{
  "Assume that you compiled this class into the assembly ",
  StyleBox["MyCompany.Complex.dll", "MR"],
  ". Here is an example of using it."
}], "Text",
  CellTags->"nlug:3.2.10"],

Cell[BoxData[{
    \(LoadNETAssembly["\<c:\\MyCompany.Complex.dll\>"]; \), "\
\[IndentingNewLine]", 
    \(SetComplexType["\<MyCompany.Complex\>"]; \)}], "Input",
  CellLabel->"In[1]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{

Cell["c = NETNew[\"MyCompany.Complex\", 2, 1]", "Input",
  CellLabel->"In[3]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "MyCompany.Complex"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$18014398509481985]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[TextData[{
  "Once you have used ",
  StyleBox["SetComplexType", "MR"],
  ", ",
  StyleBox["NETObjectToExpression", "MR"],
  " will convert object references of that type to complex numbers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (objects of type ",
  StyleBox["Complex", "MR"],
  " will normally be converted to complex numbers when returned to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", but a call to a constructor always returns a ",
  StyleBox["NETObject", "MR"],
  ")."
}], "Text",
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{

Cell["NETObjectToExpression[c]", "Input",
  CellLabel->"In[4]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[BoxData[
    \(\(\(46.`\)\(\[InvisibleSpace]\)\) + 2.`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[TextData[{
  "Here are three examples of calling the ",
  StyleBox["Add()", "MR"],
  " method. This method takes one argument of type ",
  StyleBox["Complex", "MR"],
  ". Note that you can pass a ",
  StyleBox["Complex", "MR"],
  " object, a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " complex number, or a real number for this argument. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " handles any necessary conversions."
}], "Text",
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{

Cell["c@Add[c]", "Input",
  CellLabel->"In[5]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[BoxData[
    \(\(\(4.`\)\(\[InvisibleSpace]\)\) + 2.`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[CellGroupData[{

Cell["c@Add[42 + 15 I]", "Input",
  CellLabel->"In[6]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[BoxData[
    \(\(\(44.`\)\(\[InvisibleSpace]\)\) + 16.`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[CellGroupData[{

Cell["c@Add[42]", "Input",
  CellLabel->"In[7]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[BoxData[
    \(\(\(44.`\)\(\[InvisibleSpace]\)\) + 1.`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Complex", "MR"],
  " class has an overloaded ",
  StyleBox["+", "MR"],
  " operator, and overloaded operators would be expected in any real \
implementation of a complex number class. As discussed in the section ",
  ButtonBox["Overloaded Operators",
    ButtonData:>"Overloaded Operators",
    ButtonStyle->"AddOnsLinkText"],
  ", you can call these operators from ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " by using the special static method equivalents that always exist in the \
class. For the ",
  StyleBox["+", "MR"],
  " operator, the special method is called ",
  StyleBox["op_Addition()", "MR"],
  ". Here is how to call it (note the required _ to U conversion)."
}], "Text",
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{

Cell["Complex`opUAddition[c, c]", "Input",
  CellLabel->"In[8]:=",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[BoxData[
    \(\(\(4.`\)\(\[InvisibleSpace]\)\) + 2.`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[TextData[{
  "Because some .NET languages (such as Visual Basic .NET) do not support \
overloaded operators, class designers usually provide a documented \
alternative method, such as the ",
  StyleBox["Add()", "MR"],
  " method in the ",
  StyleBox["Complex", "MR"],
  " class."
}], "Text",
  CellTags->"nlug:3.2.10"]
}, Closed]],

Cell[CellGroupData[{

Cell["The .NET Console Window", "Subsection",
  CellTags->{".NET Console", "nlug:3.2.11"}],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides a convenient means to display the .NET \
\[OpenCurlyDoubleQuote]console\[CloseCurlyDoubleQuote] window. Any output \
written to the standard ",
  StyleBox["Console.Out", "MR"],
  " and ",
  StyleBox["Console.Error", "MR"],
  " streams will be directed to this window. If you are calling .NET code \
that writes diagnostic information to the console, then you can see this \
output while your program runs. Like most ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " features, the console window can be used easily from either ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or .NET programs (its use from .NET code is described in Part 2). To use \
it from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", call the ",
  StyleBox["ShowNETConsole", "MR"],
  " function."
}], "Text",
  CellTags->"nlug:3.2.11"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(ShowNETConsole[]\),
              "MR"], 
            StyleBox[Cell[TextData[{
                
                "display the .NET console window and begin capturing output \
written to ",
                StyleBox["Console.Out", "MR"],
                " and ",
                StyleBox["Console.Error", "MR"]
              }]],
              "Text"]},
          {
            RowBox[{
              StyleBox["ShowNETConsole",
                "MR"], 
              StyleBox["[",
                "MR"], Cell[TextData[{
                "\"",
                StyleBox["stream",
                  FontSlant->"Italic"],
                "\""
              }]], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[Cell[TextData[{
                
                "display the .NET console window and begin capturing output \
written to the specified stream, which should be \"stdout\" for ",
                StyleBox["Console.Out", "MR"],
                " or \"stderr\" for ",
                StyleBox["Console.Error", "MR"]
              }]],
              "Text"]},
          {
            StyleBox[\(ShowNETConsole[None]\),
              "MR"], 
            StyleBox[\(stop\ all\ capturing\ of\ output\),
              "Text"]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.2.11"],

Cell["Showing the console window.", "Caption",
  CellTags->"nlug:3.2.11"],

Cell[CellGroupData[{

Cell["ShowNETConsole[]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.2.11"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Wolfram.NETLink.UI.ConsoleWindow"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$452984833]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.11"]
}, Open  ]],

Cell[TextData[{
  "Capturing of output only begins when you call ",
  StyleBox["ShowNETConsole", "MR"],
  ". When the window first appears, it will not have any content that might \
have been previously written to ",
  StyleBox["Console.Out", "MR"],
  " or ",
  StyleBox["Console.Error", "MR"],
  ". Calling ",
  StyleBox["ShowNETConsole", "MR"],
  " when the window is already open will cause it to come to the foreground."
}], "Text",
  CellTags->"nlug:3.2.11"],

Cell[TextData[{
  "The next example writes some output from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". If you executed the ",
  StyleBox["ShowNETConsole[]", "MR"],
  " above, then you will see \[OpenCurlyDoubleQuote]Hello from .NET\
\[CloseCurlyDoubleQuote] printed in the window. "
}], "Text",
  CellTags->"nlug:3.2.11"],

Cell["\<\
LoadNETType[\"System.Console\"];
Console`Out@WriteLine[\"Hello from .NET\"]\
\>", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.2.11"],

Cell[TextData[{
  "Although it is convenient to demonstrate writing to the window using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code like this, this is typically done instead from .NET code that writes \
diagnostic information to the console."
}], "Text",
  CellTags->"nlug:3.2.11"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Distributing Applications that Use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"]
}], "Subsection",
  CellTags->{"Distributing Applications", "nlug:3.2.12"}],

Cell[TextData[{
  "This section discusses some issues relevant to ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " developers who are creating add-ons for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.2.12"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is designed to make it easy for application developers to distribute \
applications that have parts of their implementation in .NET. If you \
structure your application directory properly, your users will be able to \
install it simply by copying it into any standard location for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications. In particular, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will be able to find your .NET assemblies without users having to perform \
any special operations or even restart the .NET runtime. "
}], "Text",
  CellTags->"nlug:3.2.12"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications are typically deployed as single directories (with \
subdirectories), installed into one of several standard locations where ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expects to find them. These standard locations can be written as ",
  StyleBox["$InstallationDirectory\\AddOns\\Applications", "MR"],
  ", ",
  StyleBox["$BaseDirectory\\Applications", "MR"],
  ", and ",
  StyleBox["$UserBaseDirectory\\Applications", "MR"],
  ", where ",
  StyleBox["$InstallationDirectory", "MR"],
  ", ",
  StyleBox["$BaseDirectory", "MR"],
  ", and ",
  StyleBox["$UserBaseDirectory", "MR"],
  " refer to the locations given by these built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbols."
}], "Text",
  CellTags->"nlug:3.2.12"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " applications might include .NET assemblies or legacy Windows DLLs (which \
can be called from .NET as described in the section ",
  ButtonBox["Calling DLLs from Mathematica",
    ButtonData:>"Calling DLLS from Mathematica",
    ButtonStyle->"AddOnsLinkText"],
  "). If your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application uses ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " and includes its own .NET assemblies, you should create an ",
  StyleBox["assembly", "MR"],
  " subdirectory in your application directory. You can place any assemblies \
that your application needs into this ",
  StyleBox["assembly", "MR"],
  " subdirectory. Legacy Windows DLLs (so-called \
\[OpenCurlyDoubleQuote]unmanaged\[CloseCurlyDoubleQuote] DLLs) should be \
placed into into a ",
  StyleBox["Libraries\\Windows", "MR"],
  " subdirectory of your application directory."
}], "Text",
  CellTags->"nlug:3.2.12"],

Cell[TextData[{
  "Here is an example directory structure for an application that uses ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.2.12"],

Cell["\<\
\t\tMyApp/
\t\t\t... other files and directories used by the application ...
\t\t\tassembly/
\t\t\t\tMyAssembly.dll
\t\t\tLibraries/
\t\t\t\tWindows/
\t\t\t\t\tMyLegacyDLL.dll\
\>", "Program",
  CellTags->"nlug:3.2.12"],

Cell[TextData[{
  "Remember that even if you use the above directory structure, your \
application code will still have to load its assemblies explicitly. All \
assemblies, other than ones that make up the .NET Framework itself, must be \
manually loaded before they can be used, as described in the section ",
  ButtonBox["Loading .NET Assemblies and Types",
    ButtonData:>"Loading .NET Assemblies",
    ButtonStyle->"AddOnsLinkText"],
  ". Having the assemblies in the proper location merely means that they can \
be found by ",
  StyleBox["LoadNETAssembly", "MR"],
  " when only a filename or assembly name is supplied."
}], "Text",
  CellTags->"nlug:3.2.12"],

Cell["\<\
LoadNETAssembly[\"MyAssembly.dll\"]
    (* or *)
LoadNETAssembly[\"My.Assembly.Name\"]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.12"]
}, Closed]],

Cell[CellGroupData[{

Cell["Version Information", "Subsection",
  CellTags->"nlug:3.2.13"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides three symbols that supply version information. These symbols \
provide the same type of information as their counterparts in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " itself, except that they are in the ",
  StyleBox["NETLink`Information`", "MR"],
  " context, which is not on ",
  StyleBox["$ContextPath", "MR"],
  ", so you must specify them by their full names. "
}], "Text",
  CellTags->"nlug:3.2.13"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["NETLink`Information`$Version",
              "MR"], 
            StyleBox[\(a\ string\ giving\ full\ version\ information\),
              "Text"]},
          {
            StyleBox["NETLink`Information`$VersionNumber",
              "MR"], 
            StyleBox[
              RowBox[{
              Cell["a real number giving the current version"], "number"}],
              "Text"]},
          {
            StyleBox["NETLink`Information`$ReleaseNumber",
              
              "MR"], \(an\ integer\ giving\ the\ release\ \(number\ \((the\ \
last\ digit\ in\ a\ full\ x . x . x\ version\ specification)\)\)\)},
          {
            StyleBox[\(ShowNETConsole[]\),
              "MR"], 
            RowBox[{
            "the", " ", "console", " ", "window", " ", "will", " ", "show", 
              " ", "version", " ", "information", " ", "for", " ", 
              RowBox[{
                RowBox[{"the", " ", 
                  StyleBox[".",
                    FontSlant->"Italic"], 
                  StyleBox["NET",
                    FontSlant->"Italic"]}], 
                StyleBox["/",
                  FontSlant->"Italic"], 
                StyleBox["Link",
                  FontSlant->"Italic"]}], " ", "assembly"}]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.2.13"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " version information."
}], "Caption",
  CellTags->"nlug:3.2.13"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NETLink`Information`$Version\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.2.13"],

Cell[BoxData[
    \("NET/Link Version 1.2.0 (September, 2004)"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.2.13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NETLink`Information`$VersionNumber\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.2.13"],

Cell[BoxData[
    \(1.2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.2.13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NETLink`Information`$ReleaseNumber\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.2.13"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"nlug:3.2.13"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["ShowNETConsole[]", "MR"],
  " function, described in an earlier section, will display the version \
number of the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " assembly file. This version should match the version of the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-language component. "
}], "Text",
  CellTags->"nlug:3.2.13"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating User Interfaces", "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->"nlug:3.3.0"],

Cell[TextData[{
  "One application of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is to write user interfaces for ",
  StyleBox["Mathematica", "TI"],
  " programs. Examples of such interfaces would be a progress bar monitoring \
the completion of a computation, a window that displays an image or \
animation, a dialog box that prompts users for input or helps them compose a \
proper call of an unfamiliar function, or a mini-application that leads users \
through the steps of an analysis. These types of user interfaces are distinct \
from what you might write for a .NET program that uses ",
  StyleBox["Mathematica", "TI"],
  " in the background in that they \[OpenCurlyDoubleQuote]pop up\
\[CloseCurlyDoubleQuote] when the user invokes some ",
  StyleBox["Mathematica", "TI"],
  " code. These user interfaces do not replace the notebook front end; they \
just augment it. In this way, they are like an extension of the palettes and \
other specialty notebook elements that you can create in the front end."
}], "Text",
  CellTags->"nlug:3.3.0"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " with",
  StyleBox[" .NET/Link",
    FontSlant->"Italic"],
  " is an extremely powerful and productive environment for creating user \
interfaces. The complexity of user interface code is ideally suited to the \
interactive line-at-a-time nature of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " development. You can build, modify, and experiment with your user \
interface ",
  StyleBox["while", "TI",
    FontSlant->"Plain"],
  " it is running",
  "."
}], "Text",
  CellTags->"nlug:3.3.0"],

Cell[TextData[{
  "You can use either ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " or ",
  StyleBox[ButtonBox["J/Link",
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  " to build user interfaces for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programs. ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " has the advantage of being cross-platform, so your interface will run on \
all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " systems. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " integrates more tightly with Windows than ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " does, so if you only need your users interfaces to work on Windows \
machines, then ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is probably the best choice."
}], "Text",
  CellTags->"nlug:3.3.0"],

Cell[TextData[{
  "If you have used ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " to build user intefaces in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", please note that there are significant differences between ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " and ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " in this area. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is generally simpler than ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ", not because of any superiority of .NET over Java, but because ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is a second-generation design. The design simplifications in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will eventually be brought to ",
  StyleBox["J/Link.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"nlug:3.3.0"],

Cell[TextData[{
  "Anyone considering writing user interfaces for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programs should also look at the ",
  StyleBox[ButtonBox["GUIKit",
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  " add-on, which is bundled with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1 and later, and available for download for users with earlier versions \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". GUIKit is built on top of ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ", and provides an extremely high-level means of creating interfaces. "
}], "Text",
  CellTags->"nlug:3.3.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Modal versus Modeless Operation", "Subsection",
  CellTags->{"Modal versus Modeless", "nlug:3.3.1"}],

Cell[TextData[{
  "Writing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programs that display .NET user interface elements, such as windows or \
buttons, requires some knowledge of special issues that are not present in \
typical ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sessions, where only the notebook front end is being used to communicate \
with the kernel. To help understand these special issues, it is useful to \
examine some basic considerations about the kernel\[CloseCurlyQuote]s \
\[OpenCurlyDoubleQuote]main loop\[CloseCurlyDoubleQuote] in which it acquires \
input, evaluates it, and sends off any output."
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "When the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel is being used from the front end, it spends most of its life \
waiting for input to arrive on the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " that it uses to communicate with the front end. This ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is given by ",
  StyleBox["$ParentLink", "MR"],
  ", and it is therefore ",
  StyleBox["$ParentLink", "MR"],
  " that has the kernel\[CloseCurlyQuote]s attention. When input arrives on \
",
  StyleBox["$ParentLink", "MR"],
  ", it is evaluated, any results are sent back on the link, and the kernel \
goes back to waiting for more input on ",
  StyleBox["$ParentLink", "MR"],
  ". When ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is being used, the kernel has another ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " open\[LongDash]the one that connects to the .NET runtime. When you \
execute some code that calls into .NET, the kernel sends something to .NET \
and then blocks waiting for the return value from .NET. During this period \
when the kernel is waiting for a return value from .NET, the .NET link has \
the kernel\[CloseCurlyQuote]s attention. It is only during this period of \
time that the kernel is paying attention to the .NET link. A more general way \
of saying this is that the kernel is only listening for input arriving from \
.NET when it has been specifically instructed to do so. The rest of the time \
it is listening only to ",
  StyleBox["$ParentLink", "MR"],
  ", which is typically the notebook front end."
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "Consider what happens when the user clicks a button in your .NET window \
and that button tries to execute some code that calls into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The .NET side sends something to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and then waits for the result, but the kernel will never get the request \
because it is only paying attention to the notebook front end link, not the \
.NET link. It is necessary to use some means to tell the kernel to look for \
input arriving on the .NET link. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides two main ways to manage the kernel\[CloseCurlyQuote]s attention \
to the .NET link and thereby control its readiness to accept requests for \
evaluations initiated by the .NET side."
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "These two ways can be called \[OpenCurlyDoubleQuote]modal\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]modeless.\
\[CloseCurlyDoubleQuote] In modal interaction, characterized by the use of \
the ",
  StyleBox["DoNETModal", "MR"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function, the kernel is pointed at the .NET link until the .NET side \
releases it. The kernel is a complete slave to the .NET side, and is \
unavailable for any other computations. In modeless interaction, \
characterized by the use of the ",
  StyleBox["DoNETModeless", "MR"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function, the kernel is kept in a state where it is receptive to \
evaluation requests arriving from either the notebook front end or .NET, \
evenly sharing its attention between these two programs."
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "A common type of user interface element is analogous to a modal dialog: \
once it is displayed, the ",
  StyleBox["Mathematica", "TI"],
  " program hangs waiting for the user to dismiss the window. Typically, this \
is because the window returns a result to ",
  StyleBox["Mathematica", "TI"],
  ", so it is not meaningful for ",
  StyleBox["Mathematica", "TI"],
  " to continue until the window is closed. An example of such a window is a \
simple input window that asks the user for some value, which it returns to ",
  StyleBox["Mathematica", "TI"],
  " when the ",
  StyleBox["OK", "SR"],
  " button is clicked."
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "It is important to understand the slightly generalized use of the term \
\[OpenCurlyDoubleQuote]modal\[CloseCurlyDoubleQuote] to describe these \
windows. They may not be modal in the traditional sense that they must be \
dismissed before anything else can be done in the user interface. Rather, \
they are modal with respect to the ",
  StyleBox["Mathematica", "TI"],
  " kernel\[LongDash]the kernel cannot do anything else until they are \
closed. A .NET window that you create might not be modal with respect to \
other .NET windows on the screen, but it ties up the \
kernel\[CloseCurlyQuote]s attention until it is dismissed."
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "Another type of user interface element is analogous to a modeless dialog: \
after it is displayed, the ",
  StyleBox["Mathematica", "TI"],
  " program that created it will finish, leaving the window visible and \
usable while the user continues working in the notebook front end. An example \
would be a window that lets users load packages into ",
  StyleBox["Mathematica", "TI"],
  " by selecting them from a scrolling list. You write a ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " program that creates this window, displays it, and returns. The window is \
left open and usable until the user clicks its close box. In the meantime, \
the user is free to continue working in the front end, going back to use this \
.NET window whenever it is convenient."
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "Such a window is almost like another type of notebook or palette window in \
the front end. You can have any number of front end or .NET modeless windows \
open and active at once, meaning that they can be used to initiate \
computations in ",
  StyleBox["Mathematica", "TI"],
  ". They are each their own little interface onto the same kernel. What is \
different about the .NET window is that it is much more general than a \
notebook window, and, importantly, it exists in a different application layer \
than the front end. This last fact makes the .NET window, in effect, a second \
front end, rather than an extension of the notebook front end. To accommodate \
such a second front end, the kernel must be kept in a special state that \
allows it to handle requests for evaluations arriving from either the \
notebook front end or .NET. "
}], "Text",
  CellTags->"nlug:3.3.1"],

Cell[TextData[{
  "Before presenting examples of how to implement modal and modeless windows, \
it is necessary to jump ahead a little bit and explain the mechanism by which \
.NET user interface elements communicate events to ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->"nlug:3.3.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Handling Events", "Subsection",
  CellTags->{"Handling Events", "nlug:3.3.2"}],

Cell[TextData[{
  "User interface elements typically have active components such as buttons, \
scrollbars, menus, and text fields, that need to trigger certain actions when \
they are used. In the .NET event model, components fire events in response to \
user actions, and other components indicate their interest in these events by \
supplying a delegate that connects an event with its handler. The concept of \
a delegate is covered in detail in the .NET Framework documentation, but ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " users can generally ignore the details of delegates because you use a \
very simple syntax for assigning a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function to be called when an event fires."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "It is useful to compare the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " technique for assigning event handler functions with the C# and Visual \
Basic .NET techniques. The following shows C# and Visual Basic .NET syntax \
for adding an event handler to the ",
  StyleBox["KeyPress", "MR"],
  " event in a ",
  StyleBox["TextBox", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["\<\
// C#
myTextBox.KeyPress += new KeyEventHandler(MyKeyPressHandlerMethod);

' Visual Basic .NET
AddHandler myTextBox.KeyPress, AddressOf MyKeyPressHandlerMethod\
\>", "Program",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "After executing either of the above lines, the ",
  StyleBox["MyKeyPressHandlerMethod()", "MR"],
  " method will be called whenever a key is pressed while the ",
  StyleBox["myTextBox", "MR"],
  " component has the focus. The C# syntax is a little cryptic, as the ",
  StyleBox["+=", "MR"],
  " operator is overloaded for adding a delegate to an event."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "The preceding code does not show the definition of ",
  StyleBox["MyKeyPressHandlerMethod()", "MR"],
  ". The signature of this method must be the same as the delegate that \
corresponds to the ",
  StyleBox["KeyPress", "MR"],
  " event. As you can see in the C# code, the delegate type is ",
  StyleBox["KeyEventHandler", "MR"],
  ", and here is the declaration."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["\<\
public delegate void KeyEventHandler(object sender, KeyEventArgs \
eventArgs);\
\>", "Program",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "Because ",
  StyleBox["MyKeyPressHandlerMethod()", "MR"],
  " must have the same signature, it would look something like this."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["\<\
void MyKeyPressHandlerMethod(object sender, KeyEventArgs eventArgs) {
\t// Here you respond to the event in some way. The sender object
\t// will be the TextBox, and eventArgs will tell you about the event
\t// (such as what key was pressed).
}\
\>", "Program",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "Here is what it looks like in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to assign a ",
  StyleBox["myKeyPressHandler", "MR"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function to the ",
  StyleBox["KeyPress", "MR"],
  " event."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["AddEventHandler[myTextBox@KeyPress, myKeyPressHandler]", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "Note that it looks almost exactly like the Visual Basic .NET version. Once \
you have executed the line above, whenever a key is pressed while ",
  StyleBox["myTextBox", "MR"],
  " has the input focus, .NET will call back to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and execute the ",
  StyleBox["myKeyPressHandler", "MR"],
  " function. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function will be called with the same arguments as the ",
  StyleBox["KeyEventHandler", "MR"],
  " delegate, and it should return the same type of value (although most \
event handlers return ",
  StyleBox["void", "MR"],
  ", so the return value is ignored). Here is what it might look like."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["\<\
myKeyPressHandler[sender_, keyEventArgs_] :=
\tPrint[\"The \" <> keyEventArgs@KeyCode@ToString[] <> \"key was pressed\"]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {
              RowBox[{
                StyleBox["AddEventHandler",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["\<\"obj@eventName\"\>",
                    "TI"], ",", " ", 
                  StyleBox["\<\"funcName\"\>",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}], Cell[TextData[{
                "set the ",
                StyleBox["Mathematica",
                  FontSlant->"Italic"],
                " function that will be called when the object ",
                StyleBox["obj", "MO"],
                " fires the ",
                StyleBox["eventName", "MO"],
                " event"
              }]]},
            {
              RowBox[{
                StyleBox["RemoveEventHandler",
                  "MR"], "[", 
                StyleBox["delegate",
                  FontSlant->"Italic"], "]"}], 
              RowBox[{
              "remove", " ", "an", " ", "event", " ", "handler", " ", 
                "assigned", " ", "by", " ", "a", " ", "previous", " ", "call",
                 " ", "to", " ", 
                StyleBox["AddEventHandler",
                  "MR"]}]}
            }],
        "Text"], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "Assigning the ",
  StyleBox["Mathematica", "TI"],
  " function that will be called in response to an event notification."
}], "Caption",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "Wiring up your application\[CloseCurlyQuote]s event logic via calls to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions is vastly more flexible than writing a traditional application \
in .NET. When you write in a compiled .NET language, or use a drag-and-drop \
GUI builder, you hard code the event logic. You have to decide at compile \
time what every click, scroll, and keystroke will do. But when you use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", you decide how your program is wired together at run time. You can even \
change the behavior on the fly simply by typing a few lines of code."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "You can remove an event handler using the ",
  StyleBox["RemoveEventHandler", "MR"],
  " function. When you call ",
  StyleBox["AddEventHandler", "MR"],
  ", it returns a ",
  StyleBox["NETObject", "MR"],
  ". This object is the delegate created for you by the internals of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". You can save this object and later pass it into ",
  StyleBox["RemoveEventHandler", "MR"],
  " to remove the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " callback that it represents. This is just about the only use you would \
have for the return value of ",
  StyleBox["AddEventHandler", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["\<\
dlg = AddEventHandler[myTextBox@KeyPress, myKeyPressHandler];
...
RemoveEventHandler[dlg];\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " event handler functions called in response to events are automatically \
wrapped in ",
  StyleBox["NETBlock", "MR"],
  ". This means that the objects sent as arguments to the function, as well \
as any new objects you create during the execution of the function, are \
released after the function returns. You do not have to use ",
  StyleBox["NETBlock", "MR"],
  " or ",
  StyleBox["ReleaseNETObject", "MR"],
  " manually. If you want an object from your handler function to persist in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " after the function returns, you must use ",
  StyleBox["KeepNETObject", "MR"],
  " to allow it to escape the unseen ",
  StyleBox["NETBlock", "MR"],
  " that wraps the function call. Here is a modified version of ",
  StyleBox["myKeyPressHandler", "MR"],
  " that stores the ",
  StyleBox["KeyCode", "MR"],
  " objects in a list for later inspection."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["\<\
myKeyPressHandler2[sender_, keyEventArgs_] :=
\tModule[{keyCode}
\t\tkeyCode = keyEventArgs@KeyCode;
\t\tAppendTo[keysPressed, keyCode];
\t\tKeepNETObject[keyCode]
\t]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  StyleBox["AddEventHandler", "MR"],
  " takes two options that control its behavior. ",
  StyleBox["SendDelegateArguments", "MR"],
  " allows you to specify which of the delegate arguments you want to send to \
your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " handler function and in which order. By default, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " sends all the delegate arguments, but as an optimization, you might not \
want to send them all. Creation of a new ",
  StyleBox["NETObject", "MR"],
  " expression in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is comparatively expensive, and the arguments to most event delegates are \
objects. In the case of the ",
  StyleBox["KeyPress", "MR"],
  " event example above, the first argument is the ",
  StyleBox["TextBox", "MR"],
  " object, which probably already exists in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", so it is not a significant optimization to avoid sending it. The ",
  StyleBox["KeyEventArgs", "MR"],
  " object, however, is definitely new to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", so you might want to avoid sending it if you do not need it. Here is an \
example of setting up an event handler that sends only the first argument to \
the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " callback function."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["\<\
AddEventHandler[myTextBox@KeyPress, myKeyPressHandler3, SendDelegateArguments \
-> {1}]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "This is what the ",
  StyleBox["myKeyPressHandler3", "MR"],
  " function would look like."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell["myKeyPressHandler3[sender_] := Print[\"A key was pressed\"]", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "The values you can specify for the ",
  StyleBox["SendDelegateArguments", "MR"],
  " option are ",
  StyleBox["All", "MR"],
  " (the default), ",
  StyleBox["None", "MR"],
  ", or a list of integers giving the indices of the arguments you want to \
send."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["SendDelegateArguments",
              "MR"], 
            StyleBox["All",
              "MR"], Cell[TextData[{
              "which delegate arguments to send to the ",
              StyleBox["Mathematica",
                FontSlant->"Italic"],
              " event handler function"
            }], "Text"]},
          {
            StyleBox["CallsUnshare",
              "MR"], 
            StyleBox["False",
              "MR"], Cell[TextData[{
              
              "whether or not your event handler function calls the advanced \
function ",
              StyleBox["UnshareKernel", "MR"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}},
  CellTags->"nlug:3.3.2"],

Cell["Options to AddEventHandler. ", "Caption",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "The ",
  StyleBox["CallsUnshare", "MR"],
  " option is for advanced programmers who are using the ",
  StyleBox["ShareKernel", "MR"],
  " and ",
  StyleBox["UnshareKernel", "MR"],
  " functions to manually control kernel sharing, instead of using ",
  StyleBox["DoNETModeless", "MR"],
  ". The sharing functions are discussed in the section ",
  ButtonBox["Manually Sharing the Kernel and Front End with .NET",
    ButtonData:>"Sharing the Kernel",
    ButtonStyle->"AddOnsLinkText"],
  ". If your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " callback function calls ",
  StyleBox["UnshareKernel", "MR"],
  ", you must set ",
  StyleBox["CallsUnshare", "MR"],
  " to ",
  StyleBox["True", "MR"],
  " in the call to ",
  StyleBox["AddEventHandler", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  StyleBox["AddEventHandler", "MR"],
  " is a convenience function that allows you to easily assign a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that will be called when an event fires. As part of its \
operation, ",
  StyleBox["AddEventHandler", "MR"],
  " creates a .NET delegate object that is assigned to the event, and whose \
action is to call the specified ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function. In some cases, you might want to create such a delegate object \
manually, but not attach it to an event. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides the ",
  StyleBox["NETNewDelegate", "MR"],
  " function for this purpose. ",
  StyleBox["NETNewDelegate", "MR"],
  " creates a delegate of the specified type whose action is to call the \
designated ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function. The main use for ",
  StyleBox["NETNewDelegate", "MR"],
  " is to create a delegate object that will be supplied to an external C \
function invoked via .NET\[CloseCurlyQuote]s PInvoke facilities. It is often \
used in conjunction with ",
  StyleBox["DefineNETDelegate", "MR"],
  " for this purpose. The ",
  ButtonBox["EnumWindows.nb",
    ButtonFunction:>(NotebookOpen[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
          "Calling DLLs"}, #]]&),
    ButtonEvaluator->Automatic,
    ButtonStyle->"Hyperlink"],
  " example file demonstrates using ",
  StyleBox["DefineNETDelegate", "MR"],
  " and ",
  StyleBox["NETNewDelegate", "MR"],
  " to call a C function that takes a callback function pointer as an \
argument."
}], "Text",
  CellTags->"nlug:3.3.2"],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {
              RowBox[{
                StyleBox["NETNewDelegate",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["\<\"type\"\>",
                    "TI"], ",", " ", 
                  StyleBox["\<\"funcName\"\>",
                    "TI"]}], 
                StyleBox["]",
                  
                  "MR"]}], \(create\ a\ new\ instance\ of\ the\ specified\ \
delegate\ type\ whose\ action\ is\ to\ call\ the\ specified\ Mathematica\ \
function\)},
            {
              RowBox[{
                StyleBox["DefineNETDelegate",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["\<\"name\"\>",
                    "TI"], ",", " ", 
                  StyleBox["\<\"returnType, {argType,...}\"\>",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}], \(create\ a\ new\ delegate\ type, \ 
              for\ when\ there\ is\ no\ existing\  . 
                  NET\ delegate\ of\ the\ appropriate\ signature\)}
            }],
        "Text"], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "Creating delegate objects that call ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Caption",
  CellTags->"nlug:3.3.2"],

Cell[TextData[{
  "Now that you have seen how to specify ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " event handler callbacks, recall that the kernel must be in a special \
state to be receptive to calls originating from user events in .NET. The two \
main ways of doing this are the functions ",
  StyleBox["DoNETModal", "MR"],
  " and ",
  StyleBox["DoNETModeless", "MR"],
  ", discussed in the next sections."
}], "Text",
  CellTags->"nlug:3.3.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Modal Windows", "Subsection",
  CellTags->{"Modal Windows", "nlug:3.3.3"}],

Cell[TextData[{
  "The basic concepts of modal and modeless ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " interfaces are discussed in the earlier section ",
  ButtonBox["Modal versus Modeless Operation",
    ButtonData:>"Modal versus Modeless",
    ButtonStyle->"AddOnsLinkText"],
  ". Here is an example of a simple modal window. The window is a simple ",
  StyleBox["Form", "MR"],
  " object that changes its background color to a new random color each time \
it is clicked."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(frm = NETNew["\<System.Windows.Forms.Form\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.3.3"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.Windows.Forms.Form"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$83886081]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.3.3"]
}, Open  ]],

Cell[TextData[{
  "Note that simply creating a new ",
  StyleBox["Form", "MR"],
  " object does not make it visible. Use the ",
  StyleBox["ShowNETWindow", "MR"],
  " function to make a window visible and to bring it in front of all other \
windows. The ",
  StyleBox["DoNETModal", "MR"],
  " function, used later, will make a form visible, but ",
  StyleBox["ShowNETWindow", "MR"],
  " is useful while you are just tinkering with an interface, before you want \
to actually run it modally."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell["ShowNETWindow[frm];", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "At this point, you should see a small frame window centered on the screen. \
Drag it to the side so that it is not hidden by ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "windows when you bring the current notebook window to the foreground. A \
huge advantage of using ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " for user interface development, compared to a typical compiled .NET \
language, is that you can experiment with your interface while it is running. \
Now change the color of the background."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[BoxData[{
    \(\(LoadNETType["\<System.Drawing.Color\>"];\)\), "\[IndentingNewLine]", 
    \(\(frm@BackColor\  = \ Color`Red;\)\)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "Now add a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " handler for the form\[CloseCurlyQuote]s ",
  StyleBox["Click", "MR"],
  " event."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[BoxData[
    \(\(AddEventHandler[frm@Click, \ onClick];\)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "This is the definition of the ",
  StyleBox["onClick", "MR"],
  " function. It sets the form\[CloseCurlyQuote]s ",
  StyleBox["BackColor", "MR"],
  " property to a random color. This function ignores the event arguments, \
but you can learn what they are from the signature of the ",
  StyleBox["Click", "MR"],
  " event."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[BoxData[
    \(onClick[
        args___]\  := \[IndentingNewLine]\(frm@
          BackColor\  = \[IndentingNewLine]\ 
        Color`FromArgb[Random[Integer, \ {0, \ 255}], 
          Random[Integer, \ {0, \ 255}], 
          Random[Integer, \ {0, \ 255}]]\)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "At this point, if you click the form, you will get a beep and nothing will \
happen to the color. When the ",
  StyleBox["Click", "MR"],
  " event fires, .NET tries to call ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to execute the ",
  StyleBox["onClick", "MR"],
  " function, but it is not safe to make this call because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is not listening for input on the .NET link. The call to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " would hang forever. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " knows the kernel is not ready, so it refuses to make the call and issues \
a beep warning instead."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "What you need is a way to put the kernel into a state where it is \
continuously reading from the .NET link. This is what makes the window \
\[OpenCurlyDoubleQuote]modal\[CloseCurlyDoubleQuote]\[LongDash]the kernel \
cannot do anything else until the window is closed. The function that \
implements this modal state is ",
  StyleBox["DoNETModal", "MR"],
  ". The first argument to ",
  StyleBox["DoNETModal", "MR"],
  " is a top-level window object (in the .NET Framework, this means a ",
  StyleBox["System.Windows.Forms.Form", "MR"],
  " or any class that inherits from it)."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DoNETModal",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["form",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                "MR"]}], 
            
            RowBox[{\(put\ the\ kernel\ into\ a\ state\ where\ its\ attention\
\ is\ solely\ directed\ at\ the\  . NET\ link\), ",", " ", 
              RowBox[{"until", " ", "the", " ", "specified", " ", 
                StyleBox["Form",
                  "MR"], " ", "window", " ", "is", " ", "closed"}]}]},
          {
            RowBox[{
              StyleBox["DoNETModal",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["form",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["returnValue",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"run", " ", "the", " ", 
                StyleBox["Form",
                  "MR"], " ", "modally"}], ",", " ", 
              RowBox[{
              "and", " ", "return", " ", "the", " ", "result", " ", "of", " ",
                 "the", " ", 
                StyleBox["returnValue",
                  FontSlant->"Italic"], " ", "computation", 
                " ", \((this\ is\ executed\ before\ the\ window\ is\ \
destroyed)\)}]}]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.3.3"],

Cell["Running modal windows.", "Caption",
  CellTags->"nlug:3.3.3"],

Cell["\<\
Now that everything is ready, you can enter the modal state and use the \
window.\
\>", "Text",
  CellTags->"nlug:3.3.3"],

Cell[BoxData[
    \(DoNETModal[form]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  StyleBox["DoNETModal", "MR"],
  " will not return until the .NET form window is closed. Click the window a \
few times to see the color change, then click the close box in the title bar \
to destroy the form and cause ",
  StyleBox["DoNETModal", "MR"],
  " to return."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "You often want to get some information from a modal dialog box when it is \
closed, such as the value from a text box, or whether the form was closed by \
clicking an ",
  StyleBox["OK", "SR"],
  " or ",
  StyleBox["Cancel", "SR"],
  " button. When ",
  StyleBox["DoNETModal", "MR"],
  " returns, the form object has been destroyed, so it is too late to call \
methods on it. If you need to get some information out of a form before it is \
destroyed, use the optional second argument ",
  StyleBox["DoNETModal", "MR"],
  ". This argument specifies a computation that will be executed just before \
the form is destroyed (it is held unevaluated until this time). ",
  StyleBox["DoNETModal", "MR"],
  " will return the result of this computation. The ",
  ButtonBox["PackageHelper.nb",
    ButtonFunction:>(NotebookOpen[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
          "Windows and Dialogs"}, #]]&),
    ButtonEvaluator->Automatic,
    ButtonStyle->"Hyperlink"],
  " example file shows how to use the second argument to ",
  StyleBox["DoNETModal", "MR"],
  " to determine whether a form was closed by clicking the ",
  StyleBox["OK", "SR"],
  " or ",
  StyleBox["Cancel", "SR"],
  " button."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell["\<\
Here is how the entire example looks when packaged into a single program.\
\>", "Text",
  CellTags->"nlug:3.3.3"],

Cell["\<\
SimpleModal[] :=
\tNETBlock[
\t\tModule[{frm, onClick},
\t\t\tfrm = NETNew[\"System.Windows.Forms.Form\"];
\t\t\tLoadNETType[\"System.Drawing.Color\"];
\t\t\tfrm@BackColor = Color`Red;
\t\t\tAddEventHandler[frm@Click, onClick];
\t\t\tonClick[args___] :=
\t\t\t\tfrm@BackColor = 
\t\t\t\t\tColor`FromArgb[Random[Integer, {0, 255}],Random[Integer, {0, 255}], \
Random[Integer, {0, 255}]];
\t\t\tDoNETModal[frm]
\t\t]
\t]\
\>", "Input",
  CellLabel->"In[8]:=",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "The .NET Framework documentation discusses how to implement modal windows \
using the ",
  StyleBox["ShowDialog()", "MR"],
  " method. There are some advantages and disadvantages to using this \
technique instead of ",
  StyleBox["DoNETModal", "MR"],
  ". One disadvantage is that a .NET window is not guaranteed to come in \
front of notebook windows if you use ",
  StyleBox["ShowDialog()", "MR"],
  ". However, this failure seems to happen only for the very first window \
displayed in a session. Windows displayed with ",
  StyleBox["ShowDialog()", "MR"],
  " are truly modal in the sense that other .NET windows cannot be used until \
the modal one is closed. The ",
  StyleBox["ShowDialog()", "MR"],
  " method makes it easy to determine how the window was closed (whether the \
",
  StyleBox["OK", "SR"],
  " or ",
  StyleBox["Cancel", "SR"],
  " button was clicked), because it returns one of the ",
  StyleBox["DialogResult", "MR"],
  " enumeration values. You can get the same result by using the second \
argument to ",
  StyleBox["DoNETModal", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell["\<\
(* Returns the DialogResult value. *)
DoNETModal[someFormWindow, someFormWindow@DialogResult]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  "The ",
  ButtonBox["PackageHelper.nb",
    ButtonFunction:>(NotebookOpen[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
          "Windows and Dialogs"}, #]]&),
    ButtonEvaluator->Automatic,
    ButtonStyle->"Hyperlink"],
  " example file demonstrates a classic modal dialog with ",
  StyleBox["OK", "SR"],
  " and ",
  StyleBox["Cancel", "SR"],
  " buttons implemented with ",
  StyleBox["DoNETModal", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[TextData[{
  StyleBox["DoNETModal", "MR"],
  " takes one option, ",
  StyleBox["FormStartPosition", "MR"],
  ", that specifies the position in which the window will appear on screen. \
The possible values are ",
  StyleBox["Center", "MR"],
  " (the default), ",
  StyleBox["Automatic", "MR"],
  " (the form will have the Windows default location), and ",
  StyleBox["Manual", "MR"],
  " (the form will appear at a location specified elsewhere, for example, by \
setting the form\[CloseCurlyQuote]s ",
  StyleBox["Location", "MR"],
  " property)."
}], "Text",
  CellTags->"nlug:3.3.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["FormStartPosition",
              "MR"], 
            StyleBox["Center",
              "MR"], Cell[
            "the position in which the window will be displayed on screen", 
              "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}},
  CellTags->"nlug:3.3.3"],

Cell["Options for DoNETModal.", "Caption",
  CellTags->"nlug:3.3.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Modeless Windows", "Subsection",
  CellTags->{"Modeless Windows", "nlug:3.3.4"}],

Cell[TextData[{
  "The previous section demonstrated how to use the ",
  StyleBox["DoNETModal", "MR"],
  " function to display and run modal windows, which cause the kernel to \
remain busy until the window is closed. Another type of window, which could \
be called modeless, remains open and usable without completely tying up the \
kernel. The basic concepts of modal and modeless ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " interfaces are discussed in more detail in the earlier section ",
  ButtonBox["Modal Versus Modeless Operation",
    ButtonData:>"Modal versus Modeless",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides the ",
  StyleBox["DoNETModeless", "MR"],
  " function to run a window modelessly. The first argument to ",
  StyleBox["DoNETModeless", "MR"],
  " is a top-level window (specifically, a ",
  StyleBox["Form", "MR"],
  " or any class that inherits from it). The window is made visible and \
brought in front of all notebook windows."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DoNETModeless",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["form",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "display the specified ",
              StyleBox["Form", "MR"],
              " window and return immediately, leaving the window active"
            }], "Text"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.3.4"],

Cell["Modeless windows.", "Caption",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  "Here is the ",
  StyleBox["SimpleModal", "MR"],
  " example from the previous section implemented as a modeless window."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell["\<\
SimpleModeless[] :=
\tNETBlock[
\t\tModule[{frm},
\t\t\tfrm = NETNew[\"System.Windows.Forms.Form\"];
\t\t\tLoadNETType[\"System.Drawing.Color\"];
\t\t\tfrm@BackColor = Color`Red;
\t\t\tAddEventHandler[frm@Click, onClick];
\t\t\tDoNETModeless[frm]
\t\t]
\t]

onClick[sender_, eventArgs_] := sender@BackColor = 
\t\tColor`FromArgb[Random[Integer, {0, 255}],Random[Integer, {0, 255}], \
Random[Integer, {0, 255}]];\
\>", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  "Executing ",
  StyleBox["SimpleModeless[]", "MR"],
  " will make the window visible and then return immediately. You can click \
the window to change its background color and also continue to use the kernel \
for other computations via the notebook front end."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell["SimpleModeless[]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  "There are several important differences in the code of ",
  StyleBox["SimpleModeless", "MR"],
  " and ",
  StyleBox["SimpleModal", "MR"],
  ", beyond the obvious call to ",
  StyleBox["DoNETModeless", "MR"],
  " instead of ",
  StyleBox["DoNETModal", "MR"],
  ". These differences revolve around the fact that the form runs after the \
",
  StyleBox["SimpleModeless", "MR"],
  " function returns. The ",
  StyleBox["onClick", "MR"],
  " function must be not be local to the Module, because the function\
\[CloseCurlyQuote]s definition would be cleared when the ",
  StyleBox["Module", "MR"],
  " ends. A ",
  StyleBox["NETBlock", "MR"],
  " is used to automatically release all .NET objects created when ",
  StyleBox["SimpleModeless", "MR"],
  " runs, but that means that you cannot refer to ",
  StyleBox["frm", "MR"],
  " by name in the code for ",
  StyleBox["onClick", "MR"],
  ", because the ",
  StyleBox["NETBlock", "MR"],
  " has ended by the time ",
  StyleBox["onClick", "MR"],
  " is executed (the symbol ",
  StyleBox["frm", "MR"],
  " is also local to the ",
  StyleBox["Module", "MR"],
  " so its value is cleared anyway). The first argument to the ",
  StyleBox["onClick", "MR"],
  " function is the object that fired the event, which is the ",
  StyleBox["Form", "MR"],
  " object, so you can use the first argument to refer to it instead of the \
symbol ",
  StyleBox["frm", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  StyleBox["DoNETModeless", "MR"],
  " is very useful during development, even for a window that will be run \
modally in its final form. Because ",
  StyleBox["DoNETModal", "MR"],
  " does not return until the window is closed, you cannot modify your event \
logic or anything else about your window while it is running. You can use ",
  StyleBox["DoNETModeless", "MR"],
  " to make your event callbacks \[OpenCurlyDoubleQuote]live\
\[CloseCurlyDoubleQuote] without tying up the kernel, so that you can tinker \
with your window while it is being displayed. When you are satisfied that it \
works as desired, you can package a complete program that runs with ",
  StyleBox["DoNETModal", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["FormStartPosition",
              "MR"], 
            StyleBox["Center",
              "MR"], Cell[
            "the position in which the window will be displayed on screen", 
              "Text"]},
          {
            StyleBox["ActivateWindow",
              "MR"], 
            StyleBox["True",
              "MR"], \(whether\ to\ make\ the\ window\ visible\)},
          {
            StyleBox["ShareFrontEnd",
              "MR"], 
            StyleBox["False",
              
              "MR"], \(whether\ the\ front\ end\ in\ addition\ to\ the\ \
kernel\ should\ be\ shared\ \(\(with\)\(\ \)\(.\)\(NET\)\(\ \)\)\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}},
  CellTags->"nlug:3.3.4"],

Cell["Options for DoNETModeless.", "Caption",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  StyleBox["DoNETModeless", "MR"],
  " takes several options. ",
  StyleBox["FormStartPosition", "MR"],
  " specifies the position in which the window will appear on screen. The \
possible values are ",
  StyleBox["Center", "MR"],
  " (the default), ",
  StyleBox["Automatic", "MR"],
  " (the form will be in the Windows default location), and ",
  StyleBox["Manual", "MR"],
  " (the form will appear at a location specified elsewhere, for example, by \
setting the form\[CloseCurlyQuote]s ",
  StyleBox["Location", "MR"],
  " property). ",
  StyleBox["ActivateWindow", "MR"],
  " controls whether the window should be made visible and brought to the \
foreground. Set ",
  StyleBox["ActivateWindow", "MR"],
  " to ",
  StyleBox["False", "MR"],
  " in the rare cases where you want to call ",
  StyleBox["DoNETModeless", "MR"],
  " to enter the modeless state, but only later make the window visible."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  "The final option, ",
  StyleBox["ShareFrontEnd", "MR"],
  ", is used to allow .NET interfaces to interact with the notebook front \
end. The functions ",
  StyleBox["ShareKernel", "MR"],
  " and ",
  StyleBox["ShareFrontEnd", "MR"],
  " are discussed in the next section, and programmers using ",
  StyleBox["DoNETModeless", "MR"],
  " are generally shielded from those low-level functions. ",
  StyleBox["DoNETModeless", "MR"],
  " is essentially a means of encapsulating calls to ",
  StyleBox["ShareKernel", "MR"],
  " and ",
  StyleBox["UnshareKernel", "MR"],
  ", starting sharing when the window first appears and ending it when the \
window is closed. If you want your modeless interface to cause actions in the \
notebook front end (such as printing some text or making graphics appear), \
you need to force ",
  StyleBox["DoNETModeless", "MR"],
  " to turn on front end as well as kernel sharing. This can be done by \
setting the ",
  StyleBox["ShareFrontEnd", "MR"],
  " option to ",
  StyleBox["True", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.4"],

Cell[TextData[{
  "One common circumstance where the ",
  StyleBox["ShareFrontEnd", "MR"],
  " option is useful is when you want to debug your program by inserting ",
  StyleBox["Print", "MR"],
  " statements in event handler functions. In a modeless interface, ",
  StyleBox["Print", "MR"],
  " output and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " warning messages triggered by event handler functions are sent to the \
.NET side and therefore do not appear in the notebook. If you want to see \
this information, setting ",
  StyleBox["ShareFrontEnd", "MR"],
  " to ",
  StyleBox["True", "MR"],
  " will cause it to appear in the frontmost notebook window. If you use this \
option during development, but do not need it in the final version of your \
program, be sure to remove it, as front end sharing is expensive to turn on \
and off, and can delay the initial appearance of your window."
}], "Text",
  CellTags->"nlug:3.3.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Manually Sharing the Kernel and Front End with .NET", "Subsection",
  CellTags->{"Sharing the Kernel", "nlug:3.3.5"}],

Cell[TextData[{
  StyleBox["Note:",
    FontWeight->"Bold"],
  " In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1 and later, the kernel is always shared with the .NET link. This means \
that the functions ",
  StyleBox["ShareKernel", "MR"],
  " and ",
  StyleBox["UnshareKernel", "MR"],
  " are not necessary and, in fact, do nothing at all. If you are writing \
programs that only need to run in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1 and later, you never need to call ",
  StyleBox["ShareKernel", "MR"],
  " or ",
  StyleBox["UnshareKernel", "MR"],
  ". If your programs need to work on all versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", then you will need to use these functions as described below."
}], "Text",
  CellTags->"nlug:3.3.5"],

Cell[TextData[{
  "The previous sections described the ",
  StyleBox["DoNETModal", "MR"],
  " and ",
  StyleBox["DoNETModeless", "MR"],
  " functions, which are ways of putting the kernel into a state where it is \
receptive to calls from events originating in .NET. Most programmers will \
only need to use those two functions to display and run .NET windows. Recall \
that ",
  StyleBox["DoNETModeless", "MR"],
  " makes the kernel receptive to input either from .NET or from the notebook \
front end. In effect, the kernel is \[OpenCurlyDoubleQuote]shared\
\[CloseCurlyDoubleQuote] between the front end and .NET. In some \
circumstances you might want to initiate kernel sharing, but find that ",
  StyleBox["DoNETModeless", "MR"],
  " is not appropriate for your needs. You can take direct control of kernel \
sharing by calling the ",
  StyleBox["ShareKernel", "MR"],
  " function."
}], "Text",
  CellTags->"nlug:3.3.5"],

Cell[TextData[{
  StyleBox["ShareKernel", "MR"],
  " was introduced with ",
  StyleBox[ButtonBox["J/Link",
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  ", and is defined in the ",
  StyleBox["JLink`", "MR"],
  " context. Loading ",
  StyleBox["NETLink`", "MR"],
  " loads ",
  StyleBox["JLink`", "MR"],
  ", so you do not have to worry about the different contexts unless you are \
uisng ",
  StyleBox["ShareKernel", "MR"],
  " or related functions in your own package. When you call ",
  StyleBox["BeginPackage", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " only makes available to the code in your package the contexts explicitly \
named in the ",
  StyleBox["BeginPackage", "MR"],
  " statement, not other contexts that are needed by those packages. This \
means that for every symbol that you want to use within a package, you must \
always explicitly include that symbol\[CloseCurlyQuote]s context in your ",
  StyleBox["BeginPackage", "MR"],
  " statement. Here is an outline of a package that uses ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " and also calls ",
  StyleBox["ShareKernel", "MR"],
  " directly."
}], "Text",
  CellTags->"nlug:3.3.5"],

Cell["\<\
BeginPackage[\"SomePackageThatUsesSharing`\", {\"NETLink`\", \"JLink`\"}]

... code that calls ShareKernel/UnshareKernel/ShareFrontEnd/UnshareFrontEnd \
...

EndPackage[]\
\>", "Program",
  CellTags->"nlug:3.3.5"],

Cell[TextData[{
  "The ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " User Guide discusses ",
  ButtonBox["ShareKernel",
    ButtonStyle->"AddOnsLink"],
  " and ",
  ButtonBox["ShareFrontEnd",
    ButtonStyle->"AddOnsLink"],
  " in detail, and you should refer to those sections for full information. \
One thing to remember about using ",
  StyleBox["ShareKernel", "MR"],
  " or ",
  StyleBox["ShareFrontEnd", "MR"],
  " with .NET is that you must supply the link to .NET as the argument, \
otherwise they will use the Java link by default."
}], "Text",
  CellTags->"nlug:3.3.5"],

Cell["tok = ShareKernel[NETLink[]];", "Input",
  CellTags->"nlug:3.3.5"],

Cell[TextData[{
  "Always save the result from ",
  StyleBox["ShareKernel", "MR"],
  " to later pass into ",
  StyleBox["UnshareKernel", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.3.5"],

Cell["UnshareKernel[tok];", "Input",
  CellTags->"nlug:3.3.5"],

Cell[TextData[{
  "As mentioned earlier, ",
  StyleBox["DoNETModeless", "MR"],
  " calls ",
  StyleBox["ShareKernel", "MR"],
  " to initiate sharing, and arranges for ",
  StyleBox["UnshareKernel", "MR"],
  " to be called when the window is closed. In ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ", programmers have to call ",
  StyleBox["ShareKernel", "MR"],
  " and ",
  StyleBox["UnshareKernel", "MR"],
  " directly to create a modeless window. Having a special function like ",
  StyleBox["DoNETModeless", "MR"],
  " that turns sharing on and off automatically is much simpler."
}], "Text",
  CellTags->"nlug:3.3.5"],

Cell[TextData[{
  "One example of a program that needs to call ",
  StyleBox["ShareKernel", "MR"],
  " directly is presented in the section ",
  ButtonBox["Handling COM Events",
    ButtonData:>"Handling COM Events",
    ButtonStyle->"AddOnsLinkText"],
  ". That program sets up event handlers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for COM events fired by the Internet Explorer application. There is no \
top-level .NET ",
  StyleBox["Form", "MR"],
  " window to pass into ",
  StyleBox["DoNETModeless", "MR"],
  ", so sharing has to be managed explicitly."
}], "Text",
  CellTags->"nlug:3.3.5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Displaying ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Graphics and Typeset Expressions"
}], "Subsection",
  CellTags->{"ShowNETWindow", "nlug:3.3.6"}],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " includes a special subclass of the standard ",
  StyleBox["PictureBox", "MR"],
  " class, called ",
  StyleBox["Wolfram.NETLink.UI.MathPictureBox", "MR"],
  ", that makes it easy to display ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics or typeset expressions in a .NET window. The example file ",
  ButtonBox["SimpleAnimationWindow.nb",
    ButtonFunction:>(NotebookOpen[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
          "Windows and Dialogs"}, #]]&),
    ButtonEvaluator->Automatic,
    ButtonStyle->"Hyperlink"],
  " demonstrates how to use it. You will find complete documentation for this \
class in the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " ",
  ButtonBox["API help file",
    ButtonEvaluator->Automatic,
    ButtonData:>{
      URL[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Documentation"}, 
          ".netlink api.chm"]], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"nlug:3.3.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bringing .NET Windows to the Foreground", "Subsection",
  CellTags->{"ShowNETWindow", "nlug:3.3.7"}],

Cell[TextData[{
  "If you are creating a .NET window with a ",
  StyleBox["Mathematica", "TI"],
  " program, you probably want that window to pop up in front of the notebook \
the user is working in so that its presence becomes apparent. The functions \
",
  StyleBox["DoNETModal", "MR"],
  " and ",
  StyleBox["DoNETModeless", "MR"],
  " automatically make the form visible and bring it to the foreground. You \
might expect that the ",
  StyleBox["Show()", "MR"],
  " or ",
  StyleBox["Activate()", "MR"],
  " methods of the ",
  StyleBox["Form", "MR"],
  " class would also do this for you, but they do not always work because the \
.NET windows live in a different application than the notebook front end."
}], "Text",
  CellTags->"nlug:3.3.7"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides a ",
  StyleBox["Mathematica", "TI"],
  " function, ",
  StyleBox["ShowNETWindow", "MR"],
  ", that performs all the necessary steps to make a .NET window visible and \
appear in front of all other windows. You do not need to call ",
  StyleBox["ShowNETWindow", "MR"],
  " if you are using ",
  StyleBox["DoNETModal", "MR"],
  " or ",
  StyleBox["DoNETModeless", "MR"],
  ", as it is called automatically. Even when using ",
  StyleBox["DoNETModeless", "MR"],
  ", however, ",
  StyleBox["ShowNETWindow", "MR"],
  " can be useful to bring a window back to the foreground if the user has \
brought other windows in front of it since it was first displayed."
}], "Text",
  CellTags->"nlug:3.3.7"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ShowNETWindow",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["form",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              StyleBox["make the specified .NET ", "Text"],
              StyleBox["Form", "MR"],
              StyleBox[
              " window visible and bring it in front of all other windows, \
including notebook windows", "Text"]
            }]]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  CellTags->"nlug:3.3.7"],

Cell["Bringing a .NET window to the foreground.", "Caption",
  CellTags->"nlug:3.3.7"],

Cell[TextData[{
  "Like ",
  StyleBox["DoNETModal", "MR"],
  " and ",
  StyleBox["DoNETModeless", "MR"],
  ", ",
  StyleBox["ShowNETWindow", "MR"],
  " takes the ",
  StyleBox["FormStartPosition", "MR"],
  " option, which specifies the position in which the window will appear on \
screen. The possible values are ",
  StyleBox["Center", "MR"],
  " (the default), ",
  StyleBox["Automatic", "MR"],
  " (the form will be in the Windows default location), and ",
  StyleBox["Manual", "MR"],
  " (the form will appear at a location specified elsewhere, for example, by \
setting the form\[CloseCurlyQuote]s ",
  StyleBox["Location", "MR"],
  " property)."
}], "Text",
  CellTags->"nlug:3.3.7"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example Files", "Subsection",
  CellTags->"nlug:3.3.8"],

Cell[TextData[{
  "The following GUI example programs are included with ",
  StyleBox[".NET/Link.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"nlug:3.3.8"],

Cell[TextData[ButtonBox["Circumcircle.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.3.8"],

Cell[TextData[ButtonBox["PackageHelper.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.3.8"],

Cell[TextData[ButtonBox["SimpleAnimationWindow.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.3.8"],

Cell[TextData[ButtonBox["RealTimeAlgebra.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.3.8"],

Cell[TextData[ButtonBox["AsteroidsGame.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Windows and Dialogs", "AsteroidsGame"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.3.8"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Writing Your Own .NET Types to Use from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->"nlug:3.4.0"],

Cell[TextData[{
  "This User Guide has shown you how to load and use existing .NET types. \
This gives ",
  StyleBox["Mathematica", "TI"],
  " programmers immediate access to the entire universe of .NET types. \
Sometimes, though, existing types are not enough, and you need to write your \
own."
}], "Text",
  CellTags->"nlug:3.4.0"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " essentially obliterates the boundary between .NET and ",
  StyleBox["Mathematica", "TI"],
  ", allowing you to pass expressions of any type back and forth and use .NET \
objects in ",
  StyleBox["Mathematica", "TI"],
  " in a meaningful way. This means that when writing your own .NET types to \
call from ",
  StyleBox["Mathematica", "TI"],
  ", you usually do not need to do anything special. You write the code in \
exactly the same way you would if you wanted to use the type only from .NET, \
and you can use any .NET language you like."
}], "Text",
  CellTags->"nlug:3.4.0"],

Cell[TextData[{
  "In some cases, you might want to exert more direct control over the \
interaction with ",
  StyleBox["Mathematica", "TI"],
  ". For example, you might want a method to send a result to ",
  StyleBox["Mathematica", "TI"],
  " that is different from what the method actually returns. Or you might \
want the method to not only return something, but also trigger a side effect \
in ",
  StyleBox["Mathematica\[LongDash]", "TI",
    FontSlant->"Italic"],
  "for example, printing something or displaying a message under certain \
conditions. You can even have an extended \[OpenCurlyDoubleQuote]dialog\
\[CloseCurlyDoubleQuote] with ",
  StyleBox["Mathematica", "TI"],
  " before your method returns, perhaps invoking multiple computations in ",
  StyleBox["Mathematica", "TI"],
  " and reading their results. You might also want to write code that calls \
into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as the result of some event triggered in .NET."
}], "Text",
  CellTags->"nlug:3.4.0"],

Cell[TextData[{
  "If you do not want to do any of these things, then you can happily ignore \
this section. The whole point of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is to make concern about the interaction with ",
  StyleBox["Mathematica", "TI"],
  " through ",
  StyleBox["MathLink", "TI"],
  " unnecessary. Most programmers who want to write .NET types to be used \
from ",
  StyleBox["Mathematica", "TI"],
  " will just write .NET types, period, without thinking about ",
  StyleBox["Mathematica", "TI"],
  " or ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". For those programmers who want more control or want to know more about \
the possibilities available with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", read on."
}], "Text",
  CellTags->"nlug:3.4.0"],

Cell[TextData[{
  "One point to remember when creating your own types to use with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is that you must use ",
  StyleBox["LoadNETAssembly", "MR"],
  " to load the assembly that contains the types. Assemblies must always be \
loaded before the types they contain can be used in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", but it is easy to forget this because ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " automatically loads assemblies that are part of the .NET Framework as \
they are needed."
}], "Text",
  CellTags->"nlug:3.4.0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Manually Returning a Result to ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->"nlug:3.4.1"],

Cell[TextData[{
  "The default behavior of a .NET method or property called from ",
  StyleBox["Mathematica", "TI"],
  " is to return to ",
  StyleBox["Mathematica", "TI"],
  " exactly what the method or property itself returns. There are times, \
however, when you want to return something else. For example, you might want \
to return an integer in some circumstances and a symbol in others. Or you \
might want a method to return one thing when it is being called from .NET but \
return something different when called from ",
  StyleBox["Mathematica", "TI"],
  ". In these cases, you will need to manually send a result to ",
  StyleBox["Mathematica", "TI"],
  " before the method returns."
}], "Text",
  CellTags->"nlug:3.4.1"],

Cell[TextData[{
  "Say you are writing a file-reading class that you want to call from ",
  StyleBox["Mathematica", "TI"],
  ". Because you want behavior that is almost identical to the standard class \
",
  StyleBox["System.IO.StreamReader", "MR"],
  ", your class will be a subclass of it. The only changes you want to make \
are to provide some more ",
  StyleBox["Mathematica", "TI"],
  "-like behavior. One example is that you want the ",
  StyleBox["Read()", "MR"],
  " method to return not -1 when it reaches the end of the file, but rather \
the symbol ",
  StyleBox["EndOfFile", "MR"],
  ", which is what ",
  StyleBox["Mathematica", "TI"],
  "\[CloseCurlyQuote]s built-in file-reading functions return."
}], "Text",
  CellTags->"nlug:3.4.1"],

Cell["\<\
// C# code
using System.IO;
using Wolfram.NETLink;

public class MyFileReader : StreamReader {

\t... constructors, other methods deleted ...

\tpublic override int Read() {

\t\tint i = base.Read();
\t\tif (i == -1) {
\t\t\tIKernelLink link = StdLink.Link;
\t\t\tif (link != null) {
\t\t\t\tlink.BeginManual();
\t\t\t\tlink.PutSymbol(\"EndOfFile\");
\t\t\t}
\t\t}
\t\treturn i;
\t}
}\
\>", "Program",
  CellTags->"nlug:3.4.1"],

Cell[TextData[{
  "If the file has reached the end, ",
  StyleBox["i", "MR"],
  " will be -1, and you want to manually return something to ",
  StyleBox["Mathematica", "TI"],
  ". The first thing you need to do is get an ",
  StyleBox["IKernelLink", "MR"],
  " object that can be used to communicate with ",
  StyleBox["Mathematica", "TI"],
  ". This is obtained by calling the static property ",
  StyleBox["StdLink.Link", "MR"],
  ". If you have written installable ",
  StyleBox["MathLink", "TI"],
  " programs in C, you will recognize the choice of names here. A C program \
has a global variable named ",
  StyleBox["stdlink", "MR"],
  " that holds the link back to ",
  StyleBox["Mathematica", "TI"],
  ". ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " has a ",
  StyleBox["StdLink", "MR"],
  " class that has a few methods related to this link object."
}], "Text",
  CellTags->"nlug:3.4.1"],

Cell[TextData[{
  "The next thing you do is check whether ",
  StyleBox["Link", "MR"],
  " returns ",
  StyleBox["null", "MR"],
  ". It will never be ",
  StyleBox["null", "MR"],
  " if the method is being called from ",
  StyleBox["Mathematica", "TI"],
  ", so you can use this test to determine whether the method is being called \
from ",
  StyleBox["Mathematica", "TI"],
  ", or as part of a normal .NET program. In this way, you can have a method \
that can be used from .NET in the usual way when a ",
  StyleBox["Mathematica", "TI"],
  " kernel is nowhere in sight."
}], "Text",
  CellTags->"nlug:3.4.1"],

Cell[TextData[{
  "Once you have verified that a link back to the kernel exists, the first \
thing you do is inform ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " that you will be sending the result back to ",
  StyleBox["Mathematica", "TI"],
  " yourself, so it should not try to automatically send the method\
\[CloseCurlyQuote]s return value. This is accomplished by calling the ",
  StyleBox["BeginManual()", "MR"],
  " method on the ",
  StyleBox["IKernelLink", "MR"],
  " object. "
}], "Text",
  CellTags->"nlug:3.4.1"],

Cell[TextData[{
  "You must call ",
  StyleBox["BeginManual()", "MR"],
  " before you send any part of a result back to ",
  StyleBox["Mathematica", "TI"],
  ". If you fail to do this, the link will get out of sync and the next ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " call you make from ",
  StyleBox["Mathematica", "TI"],
  " will probably hang. It is safe to call ",
  StyleBox["BeginManual()", "MR"],
  " more than once, so you do not have to worry that your method might be \
called from another method that has already called ",
  StyleBox["BeginManual()", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.4.1"],

Cell[TextData[{
  "Returning to the example program, the next thing after ",
  StyleBox["BeginManual()", "MR"],
  " is to make the required \
\[OpenCurlyDoubleQuote]put\[CloseCurlyDoubleQuote]-type calls to send the \
result back to ",
  StyleBox["Mathematica", "TI"],
  " (in this case, just a single ",
  StyleBox["PutSymbol()", "MR"],
  "). The internal ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " code that wraps all method calls will handle the cleanup and recovery \
from any ",
  StyleBox["MathLink", "TI"],
  " error that might have occurred calling ",
  StyleBox["PutSymbol()", "MR"],
  ". You do not need to do anything for ",
  StyleBox["MathLinkExceptions", "MR"],
  " that occur while you are putting a result manually\[LongDash]the method \
call will return ",
  StyleBox["$Failed", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  " automatically."
}], "Text",
  CellTags->"nlug:3.4.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Requesting Evaluations by ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "So far, you have seen only cases where a .NET method has a very simple \
interaction with ",
  StyleBox["Mathematica", "TI"],
  ". It is called and returns a result, either automatically or manually. \
There are many circumstances, however, where you might want to have a more \
complex interaction with ",
  StyleBox["Mathematica", "TI"],
  ". You might want a message to appear in ",
  StyleBox["Mathematica", "TI"],
  ", or some ",
  StyleBox["Print", "MR"],
  " output, or you might want to have ",
  StyleBox["Mathematica", "TI"],
  " evaluate something and return the answer to you. This is a completely \
separate issue from what you want to return to ",
  StyleBox["Mathematica", "TI"],
  " at the ",
  StyleBox["end", "TI"],
  " of your method\[LongDash]you can request evaluations during the body of a \
method whether it returns its final result manually or not."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "In some sense, when you perform this type of interaction with ",
  StyleBox["Mathematica", "TI"],
  " you are turning the tables on ",
  StyleBox["Mathematica", "TI"],
  ", reversing the \[OpenCurlyDoubleQuote]master\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]slave\[CloseCurlyDoubleQuote] roles for a moment. When \
",
  StyleBox["Mathematica", "TI"],
  " calls into .NET, the .NET code is acting as the slave, performing a \
computation and returning control to ",
  StyleBox["Mathematica", "TI"],
  ". In the middle of a .NET method, however, you can call back into ",
  StyleBox["Mathematica", "TI"],
  ", temporarily turning it into a computational server for the .NET side. \
Thus you would expect to encounter essentially all the same issues that are \
discussed in Part 2 of this User Guide, and you would need to understand the \
full ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " API as seen by .NET programmers."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "The full treatment of the ",
  StyleBox["IMathLink", "MR"],
  " and ",
  StyleBox["IKernelLink", "MR"],
  " interfaces is presented in Part 2. This section will discuss a few \
special methods in ",
  StyleBox["IKernelLink", "MR"],
  " interface that are specifically intended for use by \
\[OpenCurlyDoubleQuote]installed\[CloseCurlyDoubleQuote] methods. You have \
already seen one, the ",
  StyleBox["BeginManual()", "MR"],
  " method. This section will present the ",
  StyleBox["Message()", "MR"],
  ", ",
  StyleBox["Print()", "MR"],
  ", and ",
  StyleBox["Evaluate()", "MR"],
  " methods."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "The tasks of issuing a ",
  StyleBox["Mathematica", "TI"],
  " message from a .NET method or triggering some ",
  StyleBox["Print", "MR"],
  " output are so commonly done that the ",
  StyleBox["IKernelLink", "MR"],
  " interface has special methods for these operations. The method ",
  StyleBox["Message()", "MR"],
  " performs all the steps of issuing a ",
  StyleBox["Mathematica", "TI"],
  " message."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell["void Message(string symtag, params string[] args);", "Program",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "The ",
  StyleBox["Print()", "MR"],
  " method performs all the steps necessary to invoke ",
  StyleBox["Mathematica", "TI"],
  "\[CloseCurlyQuote]s ",
  StyleBox["Print", "MR"],
  " function."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell["public void Print(string s);", "Program",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "Here is an example method that uses both. Assume that the following \
messages are defined in ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell[TextData[StyleBox["Foo::arg = \"The `1` argument to foo must be greater \
than or equal to 0.\"", "MR"]], "Program",
  CellTags->"nlug:3.4.2"],

Cell["Here is the C# code.", "Text",
  CellTags->"nlug:3.4.2"],

Cell["\<\
public static double Foo(double x, double y) {

\tIKernelLink link = StdLink.Link;
\tif (link != null) {
\t\tlink.Print(\"inside foo\");
\t\tif (x < 0) 
\t\t\tlink.Message(\"Foo::arg\", \"first\");
\t\tif (y < 0) 
\t\t\tlink.Message(\"Foo::arg\", \"second\");
\t}
\treturn Math.Sqrt(x) * Math.Sqrt(y);
}\
\>", "Program",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "Note that ",
  StyleBox["Print()", "MR"],
  " and ",
  StyleBox["Message()", "MR"],
  " send the required code to ",
  StyleBox["Mathematica", "TI"],
  " and also read the result from the link (it will always be the symbol ",
  StyleBox["Null", "MR"],
  ")."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "Here is what happens when you call ",
  StyleBox["Foo()", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(LoadNETAssembly["\<c:\\path\\to\\FooAssembly\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(LoadNETType["\<FooClass\>"];\)\), "\n", 
    \(FooClass`Foo[1.0, \(-2.0\)]\)}], "Input",
  Evaluatable->False,
  CellTags->"nlug:3.4.2"],

Cell[BoxData[
    \(inside\ foo\)], "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"nlug:3.4.2"],

Cell[BoxData[
    \(Foo::\(arg : 
        The\ second\ argument\ to\ foo\ must\ be\ greater\ than\ or\ equal\ \
to\ 0. \)\)], "Message",
  CellTags->"nlug:3.4.2"],

Cell[BoxData[
    StyleBox["Indeterminate",
      "MR"]], "Output",
  CellTags->"nlug:3.4.2"]
}, Open  ]],

Cell[TextData[{
  "Note that you automatically get ",
  StyleBox["Indeterminate", "MR"],
  " returned to ",
  StyleBox["Mathematica", "TI"],
  " when a floating-point result from .NET is NaN \
(\[OpenCurlyDoubleQuote]Not-a-Number\[CloseCurlyDoubleQuote])."
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell[TextData[{
  "The methods ",
  StyleBox["Print()", "MR"],
  " and ",
  StyleBox["Message()", "MR"],
  " are convenience functions for two special cases of the more general \
notion of sending intermediate evaluations to ",
  StyleBox["Mathematica", "TI"],
  " before your method returns a result. The general means of doing this is \
to wrap whatever you send to ",
  StyleBox["Mathematica", "TI"],
  " in ",
  StyleBox["EvaluatePacket", "MR"],
  ", which is a signal to the kernel that this is not the final result, but \
rather something that it should evaluate and send the result back to .NET. \
You can explicitly send the ",
  StyleBox["EvaluatePacket", "MR"],
  " head, or you can use one of the methods in ",
  StyleBox["IKernelLink", "MR"],
  " that uses ",
  StyleBox["EvaluatePacket", "MR"],
  " for you. These methods are ",
  StyleBox["Evaluate()", "MR"],
  ", ",
  StyleBox["EvaluateToInputForm()", "MR"],
  ", ",
  StyleBox["EvaluateToOutputForm()", "MR"],
  ", ",
  StyleBox["EvaluateToImage()", "MR"],
  ", and ",
  StyleBox["EvaluateToTypeset()", "MR"],
  ". They are discussed in detail in the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " ",
  ButtonBox["API help file",
    ButtonEvaluator->Automatic,
    ButtonData:>{
      URL[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Documentation"}, 
          ".netlink api.chm"]], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"nlug:3.4.2"],

Cell["Here is a simple example.", "Text",
  CellTags->"nlug:3.4.2"],

Cell["\<\
public static double Foo(double x, double y) {

\tIKernelLink link = StdLink.Link;
\tif (link != null) {
\t\tlink.Evaluate(\"2+2\");
\t\t// Wait for, and then read, the answer.
\t\tlink.WaitForAnswer();
\t\tint sum1 = link.GetInteger();
\t\t\t
\t\t// EvaluateToOutputForm makes the result come back as a
\t\t// string formatted in OutputForm, and all in one step
\t\t// (no WaitForAnswer call needed).
\t\tstring s = link.EvaluateToOutputForm(\"3+3\", 0);
\t\tint sum2 = Int32.Parse(s);

\t\t// If you want, put the whole evaluation piece by piece,
\t\t// including the EvaluatePacket head.
\t\tlink.PutFunction(\"EvaluatePacket\");
\t\tlink.PutFunction(\"Plus\", 2);
\t\tlink.Put(4);
\t\tlink.Put(4);
\t\tlink.WaitForAnswer();
\t\tint sum3 = link.GetInteger();
\t}
\treturn Math.Sqrt(x) * Math.Sqrt(y);
}
\
\>", "Program",
  CellTags->"nlug:3.4.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Throwing Exceptions", "Subsection",
  CellTags->"nlug:3.4.3"],

Cell[TextData[{
  "Any exceptions that your method throws will be handled gracefully by ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", resulting in the printing of a message in ",
  StyleBox["Mathematica", "TI"],
  " describing the exception. This was discussed in the section ",
  ButtonBox["Exceptions",
    ButtonData:>"Exceptions",
    ButtonStyle->"AddOnsLinkText"],
  ". If you are sending computations to ",
  StyleBox["Mathematica", "TI"],
  ", as described in the previous section, you need to make sure that an \
exception does not interrupt your code unexpectedly. In other words, if you \
start a transaction with ",
  StyleBox["Mathematica", "TI"],
  ", make sure you complete it or you will leave the link out of sync and \
future calls to .NET will probably hang."
}], "Text",
  CellTags->"nlug:3.4.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Making a Method Interruptible", "Subsection",
  CellTags->"nlug:3.4.4"],

Cell[TextData[{
  "If you are writing a method that may take a while to complete, you should \
consider making it interruptible from ",
  StyleBox["Mathematica", "TI"],
  ". In C ",
  StyleBox["MathLink", "TI"],
  " programs, a global variable named ",
  StyleBox["MLAbort", "MR"],
  " is provided for this purpose. In ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " programs, you call the ",
  StyleBox["WasInterrupted", "MR"],
  " property in the ",
  StyleBox["IKernelLink", "MR"],
  " interface."
}], "Text",
  CellTags->"nlug:3.4.4"],

Cell[TextData[{
  "Here is an example method that performs a long computation, checking every \
100 iterations whether the user tried to abort it (using the ",
  StyleBox["Interrupt Evaluation", "SR"],
  " or ",
  StyleBox["Abort Evaluation", "SR"],
  " commands in the ",
  StyleBox["Kernel", "SR"],
  " menu)."
}], "Text",
  CellTags->"nlug:3.4.4"],

Cell["\<\
public int Foo() {

\tIKernelLink link = StdLink.Link;
\tfor (int i = 0; i < 10000, i++) {
\t\t... perform one step ...
\t\tif (i % 100 == 0 && link.WasInterrupted)
\t\t\treturn 0;  // Return value will not be seen by Mathematica.
\t}
\treturn 42;
}\
\>", "Program",
  CellTags->"nlug:3.4.4"],

Cell[TextData[{
  "This method returns 0 if it detects an attempt by the user to abort, but \
this value will never be seen by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This is because ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " causes a method, property, or constructor call that is aborted to return \
",
  StyleBox["Abort[]", "MR"],
  ", whether or not you detect the abort in your code. Therefore, if you \
detect an abort and want to honor the user\[CloseCurlyQuote]s request, just \
return some value right away. When ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " returns ",
  StyleBox["Abort[]", "MR"],
  ", the user\[CloseCurlyQuote]s entire computation is aborted, just as if \
the ",
  StyleBox["Abort[]", "MR"],
  " was embedded in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code. This means that you do not have to be concerned with any details of \
propagating the abort back to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[LongDash]all you have to do is return prematurely if you detect an abort \
request, and the rest is handled for you."
}], "Text",
  CellTags->"nlug:3.4.4"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " makes no distinction between an interrupt request and an abort request; \
they each cause ",
  StyleBox["WasInterrupted", "MR"],
  " to return ",
  StyleBox["true", "MR"],
  ". Recall that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has separate commands for interrupting and aborting computations. The \
\[OpenCurlyDoubleQuote]Abort\[CloseCurlyDoubleQuote] operation (\[AltKey]-. \
on Windows) causes the entire computation to end as soon as possible and \
return ",
  StyleBox["$Aborted", "MR"],
  ". The \[OpenCurlyDoubleQuote]Interrupt\[CloseCurlyDoubleQuote] operation (\
\[AltKey]-, on Windows) brings up a dialog box with further choices. If this \
Interrupt dialog box is triggered when a .NET method is executing, it has a \
different set of buttons than when normal ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code is executing. One of the options is ",
  StyleBox["Send Abort to Linked Program", "SR"],
  " and another is ",
  StyleBox["Send Interrupt to Linked Program", "SR"],
  ". Both of these choices have the same effect for .NET methods, which is to \
cause ",
  StyleBox["WasInterrupted", "MR"],
  " to return ",
  StyleBox["true", "MR"],
  " and the call to return ",
  StyleBox["Abort[]", "MR"],
  " when it completes. The third button is ",
  StyleBox["Kill Linked Program", "SR"],
  ", which will cause the .NET runtime to quit. If you call a .NET method \
that is not interruptible, killing the .NET runtime in this way is the only \
way to make the method call terminate. You can also kill the .NET runtime \
using the Windows Task Manager."
}], "Text",
  CellTags->"nlug:3.4.4"],

Cell[TextData[{
  "Sometimes you might want a .NET method to detect an abort and do something \
other than cause the entire ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " computation to abort. For example, you might want a loop to stop and \
return its results up to that point. Note that this is not generally \
recommended. Users expect a program to abort and return ",
  StyleBox["$Aborted", "MR"],
  " when they issue an abort request. In some cases, however, especially if \
the code is not intended for use by a large community, you might find it \
useful to use an abort as a \[OpenCurlyDoubleQuote]message\
\[CloseCurlyDoubleQuote] to communicate some information to your .NET code \
instead of just having the computation aborted. This idea is similar to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s ",
  StyleBox["CheckAbort", "MR"],
  " function, which allows you to detect an abort and absorb it so that it \
does not propagate further and abort the entire computation. To \
\[OpenCurlyDoubleQuote]absorb\[CloseCurlyDoubleQuote] the abort in your .NET \
code so that ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " does not return ",
  StyleBox["Abort[]", "MR"],
  ", simply reset the ",
  StyleBox["WasInterrupted", "MR"],
  " property to ",
  StyleBox["false", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.4.4"],

Cell["Here is an example.", "Text",
  CellTags->"nlug:3.4.4"],

Cell["\<\
public int Foo() {

\tIKernelLink link = StdLink.Link;
\tfor (int i = 0; i < 10000, i++) {
\t\t... perform one step ...
\t\tif (i % 100 == 0 && link.WasInterrupted) {
\t\t\tlink.WasInterrupted = false;
\t\t\treturn resultSoFar; // This is the value that will be returned to \
Mathematica
\t\t}
\t}
\t...
\treturn 42;
}\
\>", "Program",
  CellTags->"nlug:3.4.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Writing Your Own Event Handler Code", "Subsection",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  "The section ",
  ButtonBox["Handling Events",
    ButtonData:>"Handling Events",
    ButtonStyle->"AddOnsLinkText"],
  " introduced the topic of triggering calls into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a response to events fired in .NET, such as clicking a button. The ",
  StyleBox["AddEventHandler", "MR"],
  " function provides an easy means of setting up event handlers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". You are not required to use ",
  StyleBox["AddEventHandler", "MR"],
  ", of course. You can create your own delegates in any .NET language to \
handle events and insert calls into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directly into their code. If you choose to do this, there is one very \
important rule that must be adhered to when writing event handler code that \
calls into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". You must always call ",
  StyleBox["StdLink.RequestTransaction()", "MR"],
  " before sending a computation to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". ",
  StyleBox["RequestTransaction()", "MR"],
  " will throw an exception if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is not in a state where it is receptive to calls originating in .NET. You \
can catch this exception if you wish, or you can ignore it and ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will catch it for you and issue a warning beep. In other words, ",
  StyleBox["RequestTransaction()", "MR"],
  " prevents you from interfering with the internals of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " by trying to call the kernel when the kernel and ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " are not ready."
}], "Text",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  "To be precise, ",
  StyleBox["RequestTransaction()", "MR"],
  " will throw an exception unless one of the following conditions holds."
}], "Text",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1 or later is being used (in 5.1 and later the kernel is always shared \
with .NET)"
}], "BulletText",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is executing ",
  StyleBox["DoNETModal", "MR"]
}], "BulletText",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is executing ",
  StyleBox["DoNETModeless", "MR"],
  ", and the kernel is not busy servicing a computation from the front end"
}], "BulletText",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  "Kernel sharing has been turned on via ",
  StyleBox["ShareKernel", "MR"],
  " or ",
  StyleBox["ShareFrontEnd", "MR"],
  ", and the kernel is not busy with another computation"
}], "BulletText",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is already in the middle of a call to .NET"
}], "BulletText",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  ".NET is not being used from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (that is, the code is called in a standalone .NET program that is using \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for computations; ",
  StyleBox["InstallNET", "MR"],
  " has not been called)"
}], "BulletText",
  CellTags->"nlug:3.4.5"],

Cell[TextData[{
  "The fifth bullet point above warrants further discussion. Recall that \
whenever ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has called into .NET, it is reading from the .NET link and therefore is \
receptive to calls that arrive from .NET. This means that callbacks to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from code that is itself called from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " do not need to call ",
  StyleBox["RequestTransaction()", "MR"],
  " (although it is harmless to do so). Event handlers, however, are \
typically called as the result of some user action on the .NET side, and thus \
they originate in .NET."
}], "Text",
  CellTags->"nlug:3.4.5"],

Cell["\<\
The code below shows a prototypical event handler method written in C#.\
\>", "Text",
  CellTags->"nlug:3.4.5"],

Cell["\<\
// Add a delegate to the KeyPress event.
myTextBox.KeyPress += new KeyEventHandler(MyKeyPressHandler);
...

// Elsewhere, define MyKeyPressHandler as follows.
public void MyKeyPressHandler(object sender, KeyEventArgs eventArgs) { 

\tIKernelLink ml = StdLink.Link;
\tStdLink.RequestTransaction();
\t// Send a single computation to Mathematica to react to the KeyPress event.
\tml.PutFunction(\"EvaluatePacket\", 1);
\t... code to put rest of expression to evaluate goes here ...
\tml.EndPacket();
\tml.WaitAndDiscardAnswer();
}\
\>", "Program",
  CellTags->"nlug:3.4.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Debugging Your .NET Classes", "Subsection",
  CellTags->"nlug:3.4.6"],

Cell[TextData[{
  "You can use your favorite debugger to debug .NET code that is called from \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The only issue is that you typically have to launch a .NET program \
inside the debugger to do this. The .NET program that you need to launch is \
",
  StyleBox["InstallableNET.exe", "MR"],
  ", which is the program that is normally launched for you when you call ",
  StyleBox["InstallNET", "MR"],
  ". This program resides in the ",
  StyleBox["NETLink", "MR"],
  " directory right next to the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " assembly file."
}], "Text",
  CellTags->"nlug:3.4.6"],

Cell[TextData[{
  "If you are using Visual Studio .NET and you want to debug a class library \
project that you are using with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", the exact steps depend on the language you are using. Select the \
project, and choose ",
  StyleBox["Properties", "SR"],
  " from the ",
  StyleBox["Project", "SR"],
  " menu. In the ",
  StyleBox["Debugging", "SR"],
  " panel of the ",
  StyleBox["Configuration Properties", "SR"],
  " section, set the startup application to be the ",
  StyleBox["InstallableNET.exe", "MR"],
  " program. Set the command-line arguments to something like ",
  StyleBox["-linkmode listen -linkname foo", "MR"],
  ". Then start the debugger. The ",
  StyleBox["InstallableNET", "MR"],
  " program will launch and wait for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to connect. In your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session, execute the following."
}], "Text",
  CellTags->"nlug:3.4.6"],

Cell["InstallNET[LinkConnect[\"foo\"]]", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.4.6"],

Cell[TextData[{
  "This works because ",
  StyleBox["InstallNET", "MR"],
  " can take a ",
  StyleBox["LinkObject", "MR"],
  " as its argument, in which case it will not try to launch .NET itself. \
This allows you to manually establish the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection between .NET and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", then feed that link to ",
  StyleBox["InstallNET", "MR"],
  " and let it do the rest of the work of preparing the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and .NET sides to interact with each other."
}], "Text",
  CellTags->"nlug:3.4.6"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Calling DLLs from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"}],

Cell[TextData[{
  "This section describes how you can use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to call DLL functions from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". These are traditional Windows DLLs, typically C-language libraries \
(although many languages have the capability to create such DLLs). In .NET \
terminology, these types of DLLs are called \[OpenCurlyDoubleQuote]unmanaged\
\[CloseCurlyDoubleQuote] because they do not execute within the .NET runtime. \
Although the task of calling unmanaged functions does not appear to have \
anything to do with .NET, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " can leverage existing facilities in .NET for calling such functions. In \
other words, because .NET can call DLLs, and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can call .NET, you can now easily call DLLs in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[TextData[{
  "The capability to easily call external C functions from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " means that Windows programmers have virtually no reason to ever write \
another so-called \[OpenCurlyDoubleQuote]template\[CloseCurlyDoubleQuote] ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program that wraps an external function and directly handles ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " communication. Earlier chapters of this User Guide have shown how ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " eliminates the need for special programming to call .NET code. In this \
chapter we see how ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " also eliminates those extra steps for calling legacy DLLs."
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[TextData[{
  "Many programming languages allow you to call DLL functions by simply \
\[OpenCurlyDoubleQuote]declaring\[CloseCurlyDoubleQuote] them with a line of \
code. Here are examples of such a declaration in several languages. The \
function is ",
  StyleBox["GetTickCount()", "MR"],
  ", which is part of the Windows API that is defined in ",
  StyleBox["kernel32.dll", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[TextData[{
  StyleBox["// Visual Basic 6\nDeclare Function GetTickCount Lib \"kernel32\" \
() As Long \n\n// Visual Basic .NET\n",
    FormatType->InputForm],
  "<DLLImport(\"kernel32.dll\")>\nShared Function GetTickCount() As Integer \n\
\n// C#",
  StyleBox["\n",
    FormatType->InputForm],
  "[DllImport(\"kernel32.dll\")]\nstatic extern int GetTickCount();"
}], "Program",
  CellTags->"nlug:3.5.0"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["DefineDLLFunction", "MR"],
  " is analogous to the above declarations. You specify the name of the DLL, \
the name of the function, and the types of the return value and arguments."
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[CellGroupData[{

Cell["\<\
getTickCount = DefineDLLFunction[\"GetTickCount\", \"kernel32.dll\", \"int\", \
{}]\
\>", "Input",
  CellLabel->"In[142]:=",
  CellTags->"nlug:3.5.0"],

Cell[BoxData[
    \(Function[Null, 
      If[NETLink`DLL`Private`checkArgCount["GetTickCount", {##1}, 0], 
        Wolfram`NETLink`DynamicDLLNamespace`DLLWrapper2`GetTickCount[##1], \
$Failed], {HoldAll}]\)], "Output",
  CellLabel->"Out[142]=",
  CellTags->"nlug:3.5.0"]
}, Open  ]],

Cell[TextData[{
  "Note that ",
  StyleBox["DefineDLLFunction", "MR"],
  " returns a function. You should assign it to a symbol and then use that \
symbol as the name of the function:"
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[CellGroupData[{

Cell["getTickCount[]", "Input",
  CellLabel->"In[147]:=",
  CellTags->"nlug:3.5.0"],

Cell[BoxData[
    \(789292652\)], "Output",
  CellLabel->"Out[147]=",
  CellTags->"nlug:3.5.0"]
}, Open  ]],

Cell[TextData[{
  "There are four arguments to ",
  StyleBox["DefineDLLFunction", "MR"],
  ". The first argument is the name of the function in the DLL. The second \
argument is the name of the DLL, and you can give either the full pathname to \
the DLL or just its filename. (The ",
  ButtonBox["next section",
    ButtonData:>"How DLLs are Found",
    ButtonStyle->"AddOnsLinkText"],
  " discusses in detail how DLLs are found by ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ".) The third argument is the return type, given as a string. The fourth \
argument is a list of the types of the arguments. If the function takes zero \
arguments, like ",
  StyleBox["GetTickCount()", "MR"],
  ", you specify an empty list. The type specifications are strings, and ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " supports a number of ways to specify types. Type specifications are \
discussed in greater detail in the section ",
  ButtonBox["Specifying Arguments and Return Values",
    ButtonData:>"Specifying Arguments and Return Values",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DefineDLLFunction",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{Cell[TextData[{
                  "\"",
                  StyleBox["funcName",
                    FontSlant->"Italic"],
                  "\""
                }]], 
                StyleBox[",",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  "MR",
                  FontSlant->"Italic"], Cell[TextData[{
                  "\"",
                  StyleBox["dllName",
                    FontSlant->"Italic"],
                  "\""
                }]], 
                StyleBox[",",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  "MR",
                  FontSlant->"Italic"], Cell[TextData[{
                  "\"",
                  StyleBox["returnType",
                    FontSlant->"Italic"],
                  "\""
                }]], 
                StyleBox[",",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  "MR",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["{",
                    "MR",
                    FontSlant->"Italic"], 
                  RowBox[{Cell[TextData[{
                      "\"",
                      StyleBox["argType",
                        FontSlant->"Italic"],
                      "\""
                    }]], 
                    StyleBox[",",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      "MR",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      "MR",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    "MR",
                    FontSlant->"Italic"]}]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[Cell[TextData[{
                "create a ",
                StyleBox["Mathematica",
                  FontSlant->"Italic"],
                
                " function suitable for calling the named function from the \
named DLL"
              }]],
              "Text"]},
          {
            StyleBox[
              RowBox[{"DefineDLLFunction", "[", Cell[TextData[{
                  "\"",
                  StyleBox["declaration",
                    FontSlant->"Italic"],
                  "\""
                }]], "]"}],
              "MR"], 
            RowBox[{"create", " ", "a", " ", 
              StyleBox["Mathematica",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], "function", " ", "from", " ", "a", " ", 
              "complete", " ", "external", " ", "function", " ", 
              "delcaration", " ", "given", " ", "in", " ", "C", "#", " ", 
              "syntax"}]}
          }], TextForm]], "DefinitionBox",
  FormatType->StandardForm,
  GridBoxOptions->{ColumnWidths->{0.45, 0.55}},
  CellTags->"nlug:3.5.0"],

Cell["Defining DLL functions.", "Caption",
  CellTags->"nlug:3.5.0"],

Cell[TextData[{
  StyleBox["DefineDLLFunction", "MR"],
  " supports several options. The first is ",
  StyleBox["CallingConvention", "MR"],
  ", which you need to use if the DLL function uses a calling convention \
different from the standard convention, which is \
\[OpenCurlyDoubleQuote]stdcall\[CloseCurlyDoubleQuote] on versions of Windows \
other than Windows CE. In rare cases, functions use the \
\[OpenCurlyDoubleQuote]cdecl\[CloseCurlyDoubleQuote] calling convention. The \
\[OpenCurlyDoubleQuote]thiscall\[CloseCurlyDoubleQuote] convention can be \
used when calling methods in C++ classes. See the .NET Framework \
documentation for the ",
  StyleBox["System.Runtime.InteropServices.CallingConvention", "MR"],
  " enumeration for more information on these values. For most uses, you \
leave the ",
  StyleBox["CallingConvention", "MR"],
  " option at its default setting."
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[TextData[{
  "The ",
  StyleBox["MarshalStringsAs", "MR"],
  " option is discussed in the section ",
  ButtonBox["Strings",
    ButtonData:>"strings in DLLs",
    ButtonStyle->"AddOnsLinkText"],
  ". The ",
  StyleBox["ReferencedAssemblies", "MR"],
  " option is discussed in the section ",
  ButtonBox["Declarations Requiring Special Attributes",
    ButtonData:>"Declarations Requiring Special Attributes",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"nlug:3.5.0"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["CallingConvention",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell["\<\
the calling convention expected by the DLL function (possible values are \
\"StdCall\", \"CDecl\", \"ThisCall\", and Automatic.\
\>", "Text"]},
          {
            StyleBox["MarshalStringsAs",
              "MR"], Cell["\"ANSI\"", "MR"], Cell["\<\
how string arguments (char*, string, String) should be marshaled to and from \
the DLL function (possible values are \"ANSI\", \"Unicode\", and Automatic)\
\>", "Text"]},
          {
            StyleBox["ReferencedAssemblies",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell["\<\
a list of the names of assemblies referenced by your declaration\
\>", "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}},
  CellTags->"nlug:3.5.0"],

Cell[TextData[{
  "Options for ",
  StyleBox["DefineDLLFunction", "MR"],
  "."
}], "Caption",
  CellTags->"nlug:3.5.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["How DLLs are Found", "Subsection",
  CellTags->{"How DLLs are Found", "nlug:3.5.1"}],

Cell[TextData[{
  "The second argument to ",
  StyleBox["DefineDLLFunction", "MR"],
  " is the name of the DLL in which the function resides. You can specify a \
full pathname to the DLL or just give the filename and rely on ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s automatic search mechanism to find it. DLLs can be \
found by just their filename if they are located on your system\
\[CloseCurlyQuote]s ",
  StyleBox["PATH", "MR"],
  " or if they are in special subdirectories within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application directories. This automatic search of application directories \
allows you to distribute ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications that include one or more DLLs without requiring your users \
to install the DLL files in a separate location outside your application \
directory."
}], "Text",
  CellTags->"nlug:3.5.1"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applications are typically deployed as single directories (with \
subdirectories), installed into one of several standard locations where ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expects to find them. These standard locations can be written as ",
  StyleBox["$InstallationDirectory\\AddOns\\Applications", "MR"],
  ", ",
  StyleBox["$BaseDirectory\\Applications", "MR"],
  ", and ",
  StyleBox["$UserBaseDirectory\\Applications", "MR"],
  ", where ",
  StyleBox["$InstallationDirectory", "MR"],
  ", ",
  StyleBox["$BaseDirectory", "MR"],
  ", and ",
  StyleBox["$UserBaseDirectory", "MR"],
  " refer to the locations given by these built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbols. If your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application includes DLLs that are intended to be called via ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", your application directory needs to be installed into one of these \
standard locations, and the DLLs need to be placed into a ",
  StyleBox["Libraries\\Windows", "MR"],
  " subdirectory of your application directory. The section ",
  ButtonBox["Distributing Applications that use ",
    ButtonData:>"Distributing Applications",
    ButtonStyle->"AddOnsLinkText"],
  StyleBox[ButtonBox[".NET/Link",
    ButtonData:>"Distributing Applications",
    ButtonStyle->"AddOnsLinkText"],
    FontSlant->"Italic"],
  " discusses the layout of an application directory in more detail."
}], "Text",
  CellTags->"nlug:3.5.1"],

Cell[TextData[{
  "When you call ",
  StyleBox["DefineDLLFunction", "MR"],
  ", no attempt is made to locate the DLL\[LongDash]that happens only when \
the function is first called. This means that if ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " cannot find the DLL or the named function within it, you will see an \
error message only when the function is called, not when it is defined."
}], "Text",
  CellTags->"nlug:3.5.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Specifying Arguments and Return Values", "Subsection",
  CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "To specify the types of the return value and arguments you use strings \
such as \[OpenCurlyDoubleQuote]int\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]double\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]void\[CloseCurlyDoubleQuote].  You can use type names \
that conform to the syntax of whichever language you are most comfortable \
with (C, C#, or Visual Basic .NET). You can also use many type names used in \
the Windows API, such as \[OpenCurlyDoubleQuote]WORD\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]BOOL\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]LPSTR\[CloseCurlyDoubleQuote]. In most cases, you will \
be working from a function prototype in the C language, and it will be most \
convenient to use the names directly from the prototype. For example, \
consider the following declaration for the ",
  StyleBox["floor()", "MR"],
  " function from the ",
  StyleBox["math.h", "MR"],
  " header file in the Standard C library."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["double floor(double x);", "Program",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "It is not likely that you would want to call this particular mathematical \
function from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", but it serves as a simple example from a DLL that everyone will have. On \
Windows, the C runtime library is in the DLL ",
  StyleBox["msvcrt.dll", "MR"],
  ". Here is one way to use ",
  StyleBox["DefineDLLFunction", "MR"],
  " to create a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that calls the ",
  StyleBox["floor()", "MR"],
  " function."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
externalFloor = DefineDLLFunction[\"floor\", \"msvcrt.dll\", \"double\", \
{\"double\"}];\
\>", "Input",
  CellLabel->"In[158]:=",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["externalFloor[4.2]", "Input",
  CellLabel->"In[161]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \(4.`\)], "Output",
  CellLabel->"Out[161]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DefineDLLFuntion", "MR"],
  " allows you to use the C type names directly, which is handy when you are \
looking at a C-language prototype from a header file. The following are \
equivalent ways of making the same definition."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
(* Using Visual Basic-style names. *)
DefineDLLFunction[\"floor\", \"msvcrt.dll\", \"Double\", {\"Double\"}];

(* Using Visual Basic-style names with full VB syntax. *)
DefineDLLFunction[\"floor\", \"msvcrt.dll\", \"Double\", {\"ByVal d As Double\
\"}];

(* Using .NET Framework names. *)
DefineDLLFunction[\"floor\", \"msvcrt.dll\", \"System.Double\", \
{\"System.Double\"}];\
\>", "Input",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Using C# or Visual Basic .NET syntax for type names is convenient if you \
are copying an external function declaration from some sample code in one of \
those languages. In fact, the easiest way to use ",
  StyleBox["DefineDLLFunction", "MR"],
  " is to find an existing declaration for the external function in some C# \
or Visual Basic .NET sample code, and just copy the type names used in that \
declaration. Here is what declarations for ",
  StyleBox["floor()", "MR"],
  " would look like in those languages."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  StyleBox["// Visual Basic .NET\n",
    FormatType->InputForm],
  "<DLLImport(\"msvcrt.dll\")>\nShared Function floor(ByVal d As Double) As \
Double \n\n// C#",
  StyleBox["\n",
    FormatType->InputForm],
  "[DllImport(\"msvcrt.dll\")]\nstatic extern double floor(double);"
}], "Program",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "You can also use a Visual Basic 6 ",
  StyleBox["Declare Function", "MR"],
  " statement as a guide to the correct type names, but keep in mind some \
important differences between VB 6 and VB .NET. First, in VB 6 parameters are \
",
  StyleBox["ByRef", "MR"],
  " by default (they are ",
  StyleBox["ByVal", "MR"],
  " by default in VB .NET), so a type name like ",
  StyleBox["Double", "MR"],
  " in a VB 6 declaration should be translated to ",
  StyleBox["ByRef Double", "MR"],
  ". Also, ",
  StyleBox["Integer", "MR"],
  " in VB 6 is equivalent to ",
  StyleBox["Short", "MR"],
  " in VB .NET, and ",
  StyleBox["Long", "MR"],
  " in VB 6 is equivalent to ",
  StyleBox["Integer", "MR"],
  " in VB .NET. You must use type names that are appropriate for VB .NET."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
The following subsections discuss allowed type names in greater detail.\
\>", "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Primitive Types", "Subsubsection",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "The following table shows what type names are legal to use for primitive \
types (i.e., integers, reals, booleans) and what types they map to in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {
              StyleBox[\(Type\ in\ External\ Function\ Declaration\),
                "SO10"], 
              StyleBox[\(Mathematica\ Type\),
                "SO10"]},
            {
              StyleBox[\(C - language\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], "Integer"},
            {\(\(\ \ \ \ \)\(char, \ int, \ short, \n\t
              long\ \((and\ unsigned\ versions)\)\)\), ""},
            {
              StyleBox[\(C  #\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(byte, \ sbyte, \ char, \ short, \n\t
              int\ \((and\ unsigned\ versions)\)\)\), ""},
            {
              StyleBox[\(Visual\ Basic\  . NET\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(Short, \ Integer, \n\t
              Long\ \ \ \((these\ are\ all\ ByVal)\)\)\), ""},
            {
              StyleBox[\(\(\(.\)\(NET\)\)\ Framework\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(Byte, \ SByte, \ Char, \ Int16, \ 
              UInt16, \ \n\ \ \ \ Int32, \ UInt32, \ Int64, \ UInt64\)\), 
              ""},
            {
              StyleBox[\(Win32\ API\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(BOOL, \ BYTE, \ SHORT, \ INT, \ 
              UINT, \n\ \ \ \ LONG, \ WORD, \ DWORD, \ LPARAM, \ WPARAM\)\), 
              ""},
            {" ", " "},
            {\(float, \ double, \ Single, \ Double\), "Real"},
            {" ", " "},
            {\(bool, \ Boolean\), \(True\ or\ False\)},
            {" ", " "},
            {\(void, \ Void\), \(Null, \ when\ used\ for\ a\ return\ value; \ 
              for\ zero - argument\ functions, \ 
              use\ {}\ as\ the\ argument\ type\ list\)}
            }],
        "MR"], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.55, 0.45},
  RowLines->{
    0.5, False, False, False, False, False, False, False, False, False, False,
       True, False, True, False, True, False}},
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Legal type specifications for primitive types in ",
  StyleBox["DefineDLLFunction", "MR"],
  "."
}], "Caption",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "The use of the above type names should be straightforward. Note that \
\[OpenCurlyDoubleQuote]long\[CloseCurlyDoubleQuote] means a standard Windows \
C long (4 bytes), not the C# long, which is 8 bytes. Also, the Windows API ",
  StyleBox["BOOL", "MR"],
  " type is mapped to an integer (0 and non-zero) rather than ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  ". Pointers to, and arrays of, primitive types are discussed in a later \
subsection."
}], "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Strings", "Subsubsection",
  CellTags->{"strings in DLLs", "nlug:3.5.2"}],

Cell[TextData[{
  "There are some subtleties you need to be aware of when calling DLL \
functions that take and return strings. These center on how the DLL function \
expects strings to be represented: either as ANSI-style, single-byte, \
null-terminated strings or as Unicode, double-byte, null-terminated strings. \
The process of converting data from one representation to another as it moves \
across system boundaries is called ",
  StyleBox["marshaling",
    FontSlant->"Italic"],
  ". The default behavior of .NET when calling unmanaged code is to marshal \
strings as single-byte, null-terminated strings, because most DLL funtions \
are written to handle this common C string format. If you need different \
behavior than the default, you can use the ",
  StyleBox["MarshalStringsAs", "MR"],
  " option to ",
  StyleBox["DefineDLLFunction", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Here are examples of two DLL functions from the Windows C runtime library \
that operate on different types of strings. Each converts a string to \
lowercase; the ",
  StyleBox["_strlwr()", "MR"],
  " function takes an ANSI string and the ",
  StyleBox["_wcslwr()", "MR"],
  " function takes a wide-character string."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
char *_strlwr(char *string);

wchar_t *_wcslwr(wchar_t *string);\
\>", "Program",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Here are calls to ",
  StyleBox["DefineDLLFunction", "MR"],
  " for both of these functions. Because the ",
  StyleBox["_wcslwr()", "MR"],
  " function takes and returns a wide-character string, you need to override \
the default marshaling of strings."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
strlwr = DefineDLLFunction[\"_strlwr\", \"msvcrt.dll\", \"string\", {\"string\
\"}];
wcslwr = DefineDLLFunction[\"_wcslwr\", \"msvcrt.dll\", \"string\", {\"string\
\"}, MarshalStringsAs->\"Unicode\"];\
\>", "Input",
  CellLabel->"In[197]:=",
  CellTags->"nlug:3.5.2"],

Cell["\<\
Both functions behave identically on a string with characters that fit into a \
single byte.\
\>", "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["strlwr[\"ABC\"] == wcslwr[\"ABC\"] == \"abc\"", "Input",
  CellLabel->"In[199]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[199]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[TextData[{
  "As expected, the ",
  StyleBox["strlwr", "MR"],
  " function fails on a string with characters that require two bytes. Note \
that the \[Pi] character is truncated to a single byte (in this example the \
truncation occurs as the string is passed from .NET into the DLL, but it \
would also happen on the way back out of the DLL)."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["strlwr[\"A\[Pi]B\"]", "Input",
  CellLabel->"In[200]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \("apb"\)], "Output",
  CellLabel->"Out[200]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell["Things work when you call the wide-character version:", "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["wcslwr[\"A\[Pi]B\"]", "Input",
  CellLabel->"In[202]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \("a\[Pi]b"\)], "Output",
  CellLabel->"Out[202]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[TextData[{
  "If you have more than one string as a parameter or return type and the \
strings must be marshaled differently, then you cannot use the ",
  StyleBox["MarshalStringsAs", "MR"],
  " option, as this applies to all strings in the function. You can use the \
special \[OpenCurlyDoubleQuote]full declaration\[CloseCurlyDoubleQuote] form \
for ",
  StyleBox["DefineDLLFunction", "MR"],
  ", as discussed in the section ",
  ButtonBox["Declarations Requiring Special Attributes",
    ButtonData:>"Declarations Requiring Special Attributes",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {
              StyleBox[\(Type\ in\ External\ Function\ Declaration\),
                "SO10"], 
              StyleBox[\(Mathematica\ Type\),
                "SO10"]},
            {
              StyleBox[\(C - language\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], "String"},
            {\(\(\ \ \ \ \)\(\(char\)\(*\)\)\), ""},
            {
              StyleBox[\(C  #\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(string\)\), ""},
            {
              StyleBox[\(Visual\ Basic\  . NET\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(String\)\), ""},
            {
              StyleBox[\(\(\(.\)\(NET\)\)\ Framework\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(String\)\), ""},
            {
              StyleBox[\(Win32\ API\ \(\(names\)\(:\)\)\),
                FontSlant->"Italic"], ""},
            {\(\(\ \ \ \ \)\(LPSTR, \ LPCSTR\)\), ""}
            }],
        "MR"], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.45, 0.55},
  RowLines->{0.5, False}},
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Legal type specifications for strings in ",
  StyleBox["DefineDLLFunction", "MR"],
  ". These are all equivalent."
}], "Caption",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "In ",
  StyleBox["DefineDLLFunction", "MR"],
  " for ",
  StyleBox["_strlwr()", "MR"],
  " and ",
  StyleBox["_wcslwr()", "MR"],
  ", we used the type name \[OpenCurlyDoubleQuote]string,\
\[CloseCurlyDoubleQuote] which is C# syntax, to indicate a string. As the \
table above shows, the following are completely equivalent declarations."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
(* C syntax: *)
DefineDLLFunction[\"_strlwr\", \"msvcrt.dll\", \"char*\", {\"char*\"}];

(* C# syntax: *)
DefineDLLFunction[\"_strlwr\", \"msvcrt.dll\", \"string\", {\"string\"}];

(* VB .NET syntax: *)
DefineDLLFunction[\"_strlwr\", \"msvcrt.dll\", \"String\", {\"String\"}];

(* Alternate VB .NET syntax: *)
DefineDLLFunction[\"_strlwr\", \"msvcrt.dll\", \"String\", {\"ByVal As String\
\"}];

(* .NET Framework names: *)
DefineDLLFunction[\"_strlwr\", \"msvcrt.dll\", \"System.String\", \
{\"System.String\"}];\
\>", "Input",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "So far we have only dicussed strings used as \[OpenCurlyDoubleQuote][in]\
\[CloseCurlyDoubleQuote] parameters to functions\[LongDash]that is, where \
character data is being sent ",
  StyleBox["into",
    FontSlant->"Italic"],
  " the function. Some functions that are typed to take ",
  StyleBox["char*", "MR"],
  " use the string as an \[OpenCurlyDoubleQuote][out]\[CloseCurlyDoubleQuote] \
parameter, meaning that it is actually a buffer that is written into by the \
function. Functions that use strings as [out] parameters typically require \
you to pass in an extra argument that gives the length of the string buffer \
you have allocated, or they have a documented maximum number of characters \
that they will write into your buffer. An example of a function that writes \
data into a string is the familiar Standard C library function ",
  StyleBox["sprintf()", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
int sprintf(char *buffer, const char *format [,argument] ...);\
\>", "Program",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "The ",
  StyleBox["buffer", "MR"],
  " argument is a string into which the function writes. It is an [out] \
parameter, and although you could pass a string of data into this function to \
be overwritten  (provided it was long enough so that the written data did not \
overrun the length of the string), you would have no way of geting the \
modified string back out. The .NET runtime supports a special trick for \
working with [out] string parameters, which is to use an instance of the ",
  StyleBox["System.Text.StringBuilder", "MR"],
  " class. A ",
  StyleBox["StringBuilder", "MR"],
  " is marshaled to an unmanaged function as a character buffer. After the \
function returns, the ",
  StyleBox["StringBuilder", "MR"],
  " object will hold the data that was written into the buffer. You can \
extract the data as a string using the ",
  StyleBox["StringBuffer.ToString()", "MR"],
  " method."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s see how this is done with the ",
  StyleBox["sprintf()", "MR"],
  " function. This function takes a variable argument count, but ",
  StyleBox["DefineDLLFunction", "MR"],
  " cannot handle that, so we will define a version specifically for the case \
of one integer argument after the format string (three total arguments). "
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[TextData[StyleBox["sprintf = DefineDLLFunction[\"sprintf\", \"msvcrt.dll\
\", \"int\", {\"System.Text.StringBuilder\", \"const char*\", \"int\"}];",
  FormatType->InputForm,
  FontFamily->"Courier New"]], "Input",
  CellLabel->"In[222]:=",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "One small point to note in the above call to ",
  StyleBox["DefineDLLFunction", "MR"],
  " is that you can specify a ",
  StyleBox["const", "MR"],
  " qualifier on any argument slot. It is ignored by ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " because it is not relevant for ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s purposes, but you can use it if you think it makes \
your declarations more self-documenting or if you are just blindly copying a \
C function prototype."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "To call ",
  StyleBox["sprintf", "MR"],
  " you first create a ",
  StyleBox["StringBuilder", "MR"],
  " object that has a buffer large enough to hold all the data that might be \
written into it. This example will use a small string, so 20 bytes is more \
than enough."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["\<\
sb = NETNew[\"System.Text.StringBuilder\", 20];
sprintf[sb, \"xxx%daaa\", 42]\
\>", "Input",
  CellLabel->"In[223]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[224]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[TextData[{
  "The return value is the number of characters written into the buffer. To \
see the string, call ",
  StyleBox["ToString()", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["sb@ToString[]", "Input",
  CellLabel->"In[225]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \("xxx42xxx"\)], "Output",
  CellLabel->"Out[225]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Arrays and Pointers", "Subsubsection",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "When dealing with functions that take or return pointers or arrays, you \
need to be a little careful and make sure you understand how the parameter is \
treated by the function you are calling. For example, if you see a parameter \
of type ",
  StyleBox["int*", "MR"],
  ", it could be any of the following:"
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
   \[FilledSmallSquare]  an array of integers passed in to the function (an \
[in] array)
   \[FilledSmallSquare]  an array of integers that will be written into by \
the function (an [out] array), that possibly also requires initial values in \
the array (an [in, out] array)
   \[FilledSmallSquare]  the address of an integer variable that will have a \
value written into it by the function (an [out] int), that possibly also \
requires an initial value (an [in, out] int)\
\>", "ItemizedText",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Each of these possibilities requires a different type specification in ",
  StyleBox["DefineDLLFunction", "MR"],
  ". As an example, consider the ",
  StyleBox["modf()", "MR"],
  " function from the Standard C library:"
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["double modf(double d, double* pint);", "Program",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "This function breaks up the double ",
  StyleBox["d", "MR"],
  " into an integer plus a fraction. The fraction is the return value, and \
the integer value is stored in the double pointed to by ",
  StyleBox["pint", "MR"],
  ". From this description you can see that the ",
  StyleBox["double*", "MR"],
  " parameter is not an array, but the address of a double that will get \
written into (an [out] ",
  StyleBox["double", "MR"],
  "). Try calling ",
  StyleBox["DefineDLLFunction", "MR"],
  " using the type names directly from the prototype and see what you get."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
modf = DefineDLLFunction[\"modf\", \"msvcrt.dll\", \"double\", {\"double\", \
\"double*\"}];\
\>", "Input",
  CellLabel->"In[251]:=",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "When you use a pointer type like ",
  StyleBox["double*", "MR"],
  " directly in ",
  StyleBox["DefineDLLFunction", "MR"],
  ", as in the above example, ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " assumes that the parameter is an [in, out] ",
  StyleBox["double", "MR"],
  " (the last item in the bullet list above). In C# notation this type of \
parameter is called ",
  StyleBox["ref double", "MR"],
  ", and in Visual Basic .NET notation it is ",
  StyleBox["ByRef As Double", "MR"],
  ". From the earlier section ",
  ButtonBox["\[OpenCurlyDoubleQuote]Out\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]Ref\[CloseCurlyDoubleQuote] Parameters",
    ButtonData:>"Out and Ref Parameters",
    ButtonStyle->"AddOnsLinkText"],
  ", you know that what you need to pass to a ",
  StyleBox["ref", "MR"],
  " parameter slot is a symbol that has a value of the correct type going in, \
and that this symbol will also be assigned a possibly modified value on the \
way out. This means that to call ",
  StyleBox["modf", "MR"],
  " and have it assign the second argument to a symbol called ",
  StyleBox["integerPart", "MR"],
  ", we need to give ",
  StyleBox["integerPart", "MR"],
  " a numerical value before the call or ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will complain about bad arguments."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["\<\
integerPart = 0;
modf[3.5, integerPart]\
\>", "Input",
  CellLabel->"In[253]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \(0.5`\)], "Output",
  CellLabel->"Out[254]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["integerPart", "Input",
  CellLabel->"In[255]:=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \(3.`\)], "Output",
  CellLabel->"Out[255]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[TextData[{
  "This is not ideal because the second argument is conceptually an [out] ",
  StyleBox["double", "MR"],
  ", not an [in, out] ",
  StyleBox["double", "MR"],
  "\[LongDash]its value going into the function is not used, so there is no \
point in having to give it any value before the call. To improve the \
definition you can use ",
  StyleBox["\"out double\"", "MR"],
  " instead of ",
  StyleBox["\"double*\"", "MR"],
  " as the type specification."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
betterModf = DefineDLLFunction[\"modf\", \"msvcrt.dll\", \"double\", \
{\"double\", \"out double\"}];\
\>", "Input",
  CellLabel->"In[256]:=",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{

Cell["\<\
Clear[integerPart];
betterModf[3.5, integerPart]
integerPart\
\>", "Input",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \(0.5`\)], "Output",
  CellLabel->"Out[258]=",
  CellTags->"nlug:3.5.2"],

Cell[BoxData[
    \(3.`\)], "Output",
  CellLabel->"Out[259]=",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[TextData[{
  "In summary, if you use a pointer type directly in ",
  StyleBox["DefineDLLFunction", "MR"],
  ", ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will treat this as a ",
  StyleBox["ref", "MR"],
  " (C# notation) or ",
  StyleBox["ByRef", "MR"],
  " (VB notation) parameter. If this does not correctly capture the use of \
the parameter, you should use a different type specification. I prefer to use \
C# notation for type names, so that an ",
  StyleBox["int*", "MR"],
  " parameter that is treated as an address of an integer that will be \
written into is specified as ",
  StyleBox["\"out int\"", "MR"],
  ". If the value is both read and written by the function it is a ",
  StyleBox["\"ref int\"", "MR"],
  ". Visual Basic .NET does not have a syntax for a \
\[OpenCurlyDoubleQuote]pure\[CloseCurlyDoubleQuote] [out] parameter, so using \
C# notation is the best choice for that case."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "So far we have not considered the case of an array parameter. In a C \
function prototype, ",
  StyleBox["int*", "MR"],
  " could mean an array of ",
  StyleBox["int", "MR"],
  "s, although this would often be written as ",
  StyleBox["int[]", "MR"],
  ". If you need to pass an array of data to a DLL function, the parameter \
type must be written with array brackets, as in ",
  StyleBox["\"int[]\"", "MR"],
  ", not as ",
  StyleBox["\"int*\"", "MR"],
  " (you have already seen how ",
  StyleBox["DefineDLLFunction", "MR"],
  " treats types declared explicitly as pointers). Consider the following two \
(fictitious) DLL function prototypes."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
int SumArray(int[] array, int length);

void ReverseArray(int[] array, int length);\
\>", "Program",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "The ",
  StyleBox["SumArray()", "MR"],
  " function takes an array of integers and the length of the array, and it \
returns the sum. Here is how you would write ",
  StyleBox["DefineDLLFunction", "MR"],
  " and the call to the function."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
SumArray = DefineDLLFunction[\"SumArray\", \"SomeDLL.dll\", \"int\", {\"int[]\
\", \"int\"}];

(* Alternate version using VB .NET syntax:
\tSumArray = DefineDLLFunction[\"SumArray\", \"SomeDLL.dll\", \"Integer\", \
{\"x() As Integer\", \"Integer\"}];
*)

result = SumArray[{2,4,6,8,10}, 5];\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Note that bracket notation is used to indicate an array passed into the \
function, and you call it from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with a list of integers."
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "The ",
  StyleBox["ReverseArray()", "MR"],
  " function is quite different. It reverses the array of data ",
  StyleBox["in place",
    FontSlant->"Italic"],
  ", so the array is used as an [in, out] parameter. You can define it as \
follows:"
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
ReverseArray = DefineDLLFunction[\"ReverseArray\", \"SomeDLL.dll\", \"void\", \
{\"int[]\", \"int\"}];\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],

Cell["But consider what would happen if you called it like this:", "Text",
  CellTags->"nlug:3.5.2"],

Cell["ReverseArray[{2,4,6,8,10}, 5];", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "This would succeed in the sense that the DLL function would receive an \
array of ",
  StyleBox["int", "MR"],
  "s and reverse it, but there is no way to propagate the modified array back \
out of the function. You might guess that ",
  StyleBox["\"ref int[]\"", "MR"],
  " would be the correct type to use, but that actually translates to ",
  StyleBox["(int[])*", "MR"],
  " because adding ",
  StyleBox["ref", "MR"],
  " or ",
  StyleBox["out", "MR"],
  " to a type is effectively adding a level of indirection. The trick is to \
create a .NET array object and pass that object into the function. After the \
function returns, you can get the array data as a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list. This works because anywhere in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " if you have an argument slot typed to take an array you can call it from \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with either a list or a reference to a .NET object that is an array of \
the appropriate type. Here is the proper way to call a DLL function that \
writes into an array:"
}], "Text",
  CellTags->"nlug:3.5.2"],

Cell["\<\
(* This creates a .NET object of type Int32[] and fills it with the data.
   If you didn't care about the initial values in the array, you could use
   NETNew[\"System.Int32[]\", 5].
*)
intArray = MakeNETObject[{2,4,6,8,10}];

ReverseArray[intArray, 5];

(* This converts the object reference to its value as a Mathematica list. *)
NETObjectToExpression[intArray]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],

Cell["But consider what would happen if you called it like this:", "Text",
  CellTags->"nlug:3.5.2"],

Cell["ReverseArray[{2,4,6,8,10}, 5];", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "The ",
  ButtonBox["example files",
    ButtonData:>"DLL Example Files",
    ButtonStyle->"AddOnsLinkText"],
  " include more pointer-related techniques, including the use of the .NET \
Framework ",
  StyleBox["IntPtr", "MR"],
  " type to represent a generic pointer."
}], "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function Pointers", "Subsubsection",
  CellTags->"nlug:3.5.2"],

Cell[TextData[{
  "Some DLL functions take a callback function pointer as an argument. .NET \
maps function pointers to delegates, so you pass a delegate object of the \
appropriate type for a function pointer argument. The section ",
  ButtonBox["Handling Events",
    ButtonData:>"Handling Events",
    ButtonStyle->"AddOnsLinkText"],
  " introduced the ",
  StyleBox["NETNewDelegate", "MR"],
  " function, and its main use is for creating delegate objects for function \
pointers in DLL calls. It is often the case that there is no existing .NET \
delegate type with the correct signature for the function pointer. You can \
use the ",
  StyleBox["DefineNETDelegate", "MR"],
  " function to create a .NET delegate type with the appropriate signature. \
The ",
  ButtonBox["EnumWindows.nb",
    ButtonFunction:>(NotebookOpen[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
          "Calling DLLs"}, #]]&),
    ButtonEvaluator->Automatic,
    ButtonStyle->"Hyperlink"],
  " example file demonstrates using ",
  StyleBox["DefineNETDelegate", "MR"],
  " and ",
  StyleBox["NETNewDelegate", "MR"],
  " to call a DLL function that takes a callback function pointer as an \
argument."
}], "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Declarations Requiring Special Attributes", "Subsection",
  CellTags->{"Declarations Requiring Special Attributes", "nlug:3.5.3"}],

Cell[TextData[{
  "The .NET runtime supports a large number of attributes to control \
precisely how a function is called and how arguments are marshaled. The ",
  StyleBox["CallingConvention", "MR"],
  " and ",
  StyleBox["MarshalStringsAs", "MR"],
  " options to ",
  StyleBox["DefineDLLFunction", "MR"],
  " give you some control over these aspects, but they do not support \
anywhere near all of the available attributes. Here is an example from the \
.NET Framework documentation of a complicated C# declaration for the ",
  StyleBox["MoveFile()", "MR"],
  " function from the Windows API. Although this declaration was made \
deliberately over-complicated, it demonstrates some of the possible \
attributes."
}], "Text",
  CellTags->"nlug:3.5.3"],

Cell["\<\
[DllImport(\"KERNEL32.DLL\", EntryPoint=\"MoveFileW\", SetLastError=true,
CharSet=CharSet.Unicode, ExactSpelling=true,
CallingConvention=CallingConvention.StdCall)]
public static extern bool MoveFile(String src, String dst);\
\>", "Program",
  CellTags->"nlug:3.5.3"],

Cell[TextData[{
  "When faced with the need to specify attributes beyond what can be done \
with options to ",
  StyleBox["DefineDLLFunction", "MR"],
  ", you can use an alternative form where you specify a full declaration as \
a string in C# syntax."
}], "Text",
  CellTags->"nlug:3.5.3"],

Cell["\<\
MoveFile = DefineDLLFunction[\"[DllImport(\\\"KERNEL32.DLL\\\", EntryPoint=\\\
\"MoveFileW\\\", SetLastError=true, CharSet=CharSet.Unicode, \
ExactSpelling=true,
CallingConvention=CallingConvention.StdCall)] public static extern bool \
MoveFile(String src, String dst);\"];\
\>", "Input",
  CellTags->"nlug:3.5.3"],

Cell[TextData[{
  "In this version of ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", only C# syntax is supported not Visual Basic .NET."
}], "Text",
  CellTags->"nlug:3.5.3"],

Cell["\<\
Another example of a function that would need this type of full declaration \
would be one that had two string arguments that needed separate marshaling \
conventions.\
\>", "Text",
  CellTags->"nlug:3.5.3"],

Cell["void TwoStrings(char* ansiString, wchar_t* unicodeString);", "Program",
  CellTags->"nlug:3.5.3"],

Cell[TextData[{
  "Here is how you would define it in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"nlug:3.5.3"],

Cell["\<\
TwoStrings = DefineDLLFunction[\"[DllImport(\\\"SomeDLL.dll\\\")] public \
static extern void TwoStrings([MarshalAs(UnmanagedType.LPStr)] string \
ansiString, [MarshalAs(UnmanagedType.LPWStr)] string unicodeString);\"];\
\>", "Input",
  CellTags->"nlug:3.5.3"],

Cell[TextData[{
  "If your DLL declaration uses a type that is not in the System assembly, \
you need to use the ",
  StyleBox["ReferencedAssemblies", "MR"],
  " option to specify its assembly. This is analogous to adding a reference \
to an assembly in a Visual Studio project. Here is an example of using this \
option. The ",
  StyleBox["Rectangle", "MR"],
  " class is found in the ",
  StyleBox["System.Drawing", "MR"],
  " assembly, so you will get an error unless you explicitly name it as a \
referenced assembly."
}], "Text",
  CellTags->"nlug:3.5.3"],

Cell["\<\
GetWindowRect = DefineDLLFunction[\"GetWindowRect\", \"user32.dll\", \
\"BOOL\", {\"HWND\", \"ref System.Drawing.Rectangle\"}, \
ReferencedAssemblies->{\"System.Drawing.dll\"}];\
\>", "Input",
  CellTags->"nlug:3.5.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example Files", "Subsection",
  CellTags->{"DLL Example Files", "nlug:3.5.4"}],

Cell[TextData[{
  "The following example programs, included with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", demonstrate calling C-style DLLs from ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"nlug:3.5.4"],

Cell[TextData[ButtonBox["BZip2Compression.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling DLLs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.5.4"],

Cell[TextData[ButtonBox["WindowsAPI.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling DLLs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.5.4"],

Cell[TextData[ButtonBox["EnumWindows.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling DLLs"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.5.4"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Calling COM from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Section",
  CellTags->"COM"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"COM Introduction", "nlug:3.6.0"}],

Cell[TextData[{
  "The .NET runtime has many features that support interoperability with COM \
(the Component Object Model, also referred to as ActiveX). Although the \
arrival of .NET makes COM/ActiveX officially a \[OpenCurlyDoubleQuote]legacy\
\[CloseCurlyDoubleQuote] technology, there are still a huge number of COM \
objects and libraries in use, and COM remains an important part of the \
Windows programming world. Because COM objects are easily called from .NET, \
they are easily called from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " via ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.6.0"],

Cell["\<\
COM programming is a complex subject (one reason, no doubt, that Microsoft \
replaced it with .NET), and readers are assumed to have some familiarity with \
the basics of COM. There is considerable discussion of COM and .NET \
interoperability issues in the .NET SDK documentation.\
\>", "Text",
  CellTags->"nlug:3.6.0"],

Cell["\<\
The central element in .NET-to-COM interoperability is a special proxy object \
called a Runtime Callable Wrapper. Whenever you create a COM object and want \
to import it into the .NET environment, the .NET runtime creates an RCW \
object that represents the COM object in the .NET environment. The RCW \
mediates calls from .NET into COM, marshaling arguments and return values \
back and forth between the .NET and COM worlds. You will see examples of RCW \
objects in the sections that follow.\
\>", "Text",
  CellTags->"nlug:3.6.0"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides two main ways of calling COM objects from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The first technique is to use so-called COM Automation (late binding). \
This is convenient because it requires no preparation, but it is not ideal \
for various reasons discussed later. The second, preferred, technique is to \
create or obtain an ",
  "interop assembly",
  " for the COM objects you want to call. An interop assembly is a special \
.NET assembly that wraps a COM library and makes that library\
\[CloseCurlyQuote]s types and interfaces look like native .NET types. These \
two methods for calling COM objects are discussed in the next two sections."
}], "Text",
  CellTags->"nlug:3.6.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Automation (Late Binding)", "Subsection",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "A COM interface is essentially just a table of function pointers. This is \
ideal for C++ programmers to use, but there needs to be a way for scripting \
languages, which have no compilation stage and no access to C++ header files, \
to use COM objects. The solution to this problem is a special COM interface \
called ",
  StyleBox["IDispatch", "MR"],
  ". A COM object that implements ",
  StyleBox["IDispatch", "MR"],
  " allows the user of the object to determine at runtime the methods and \
properties available, and then invoke them. ",
  StyleBox["IDispatch", "MR"],
  " is the COM equivalent to the \[OpenCurlyDoubleQuote]reflection\
\[CloseCurlyDoubleQuote] capabilities in .NET. Using  COM objects via their \
",
  StyleBox["IDispatch", "MR"],
  " interface is often referred to as late binding, Automation, or Dispatch. \
We will use the term Automation."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "Not all COM objects support Automation but many do, including all those \
that want to be usable from the widest variety of programming languages and \
environments. Visual Basic 6 is capable of using COM objects via either \
Automation or early binding (discussed later). Most scripting languages, \
including VBScript, however, can only use Automation. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " can use either Automation or early binding. Early binding is the \
preferred technique, and it is discussed in the next section. Here, we focus \
on Automation. Using COM objects via Automation in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is almost exactly like using Automation in Visual Basic or VBScript. If \
you can find sample code in either of those languages that uses the COM \
objects you are interested in, then you can generally translate that code \
verbatim into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "As an example of a COM library, this section will use the Microsoft Speech \
API. Although Microsoft will eventually move all its APIs to pure .NET \
implementations, many are still available only as COM objects, and the Speech \
API is an example. (Note that Microsoft has a .NET-based speech tool called \
the Speech Application SDK. This is targeted at ASP .NET developers creating \
telephony applications and should not be confused with the older COM-based \
Speech API, which will be used in the next examples.) You do not need to have \
the Speech API installed to understand this section, as you can simply read \
the inputs and outputs, but if you want to reevaluate the input or play \
around yourself, you can download the Speech API from ",
  ButtonBox["http://www.microsoft.com/speech/download/sdk51/",
    ButtonData:>{
      URL[ "http://www.microsoft.com/speech/download/sdk51/"], None},
    ButtonStyle->"Hyperlink"],
  ". If the line that calls ",
  StyleBox["CreateCOMObject", "MR"],
  " fails, you do not have the Speech API installed."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "The basic function for creating COM objects for control via Automation is \
",
  StyleBox["CreateCOMObject", "MR"],
  ". This function is analogous to the ",
  StyleBox["CreateObject()", "MR"],
  " function in Visual Basic. The argument to ",
  StyleBox["CreateCOMObject", "MR"],
  " is a string that provides either the ProgID or CLSID of a COM coclass. A \
ProgID is a human-readable string, such as \
\[OpenCurlyDoubleQuote]Excel.Application\[CloseCurlyDoubleQuote], whereas the \
CLSID is a sequence of hex digits, such as \
\[OpenCurlyDoubleQuote]{000208d5-0000-0000-c000-000000000046}\
\[CloseCurlyDoubleQuote]. You can obtain the CLSID or ProgID of a COM object \
from its documentation, or, even better, from some sample code in Visual \
Basic that uses it."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"CreateCOMObject", "[", Cell[TextData[{
                  "\"",
                  StyleBox["ProgID",
                    FontSlant->"Italic"],
                  "\""
                }]], "]"}],
              "MR"], Cell["\<\
create a COM object with the given ProgID (e.g., Excel.Application)\
\>", "Text"]},
          {
            StyleBox[
              RowBox[{"CreateCOMObject", "[", Cell[TextData[{
                  "\"",
                  StyleBox["CLSID",
                    FontSlant->"Italic"],
                  "\""
                }]], "]"}],
              
              "MR"], \(create\ a\ COM\ object\ with\ the\ given\ CLSID\ \((e \
. g . , \ {000208  d5 - 0000 - 0000 - c000 - 000000000046})\)\)},
          {
            StyleBox[
              RowBox[{"GetActiveCOMObject", "[", Cell[TextData[{
                  "\"",
                  StyleBox["ProgID",
                    FontSlant->"Italic"],
                  "\""
                }]], "]"}],
              "MR"], Cell["\<\
acquire a reference to an already-active COM object with the given ProgID \
(e.g., Excel.Application)\
\>", "Text"]},
          {
            StyleBox[
              RowBox[{"GetActiveCOMObject", "[", Cell[TextData[{
                  "\"",
                  StyleBox["CLSID",
                    FontSlant->"Italic"],
                  "\""
                }]], "]"}],
              "MR"], Cell["\<\
acquire a reference to an already-active COM object with the given CLSID \
(e.g., {000208d5-0000-0000-c000-000000000046})\
\>", "Text"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.6.1"],

Cell["Obtaining COM objects. ", "Caption",
  CellTags->"nlug:3.6.1"],

Cell["This creates an instance of the SpVoice COM object.", "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{

Cell["voice = CreateCOMObject[\"Sapi.SpVoice\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.6.1"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          COMInterface["SpeechLib.ISpeechVoice"]] \[RightGuillemet]\),
      NETLink`Objects`NETObject$802588947$134217729]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.6.1"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["voice", "MR"],
  " object is unlike any .NET object you have seen yet. This object is a \
Runtime Callable Wrapper (RCW), a class of objects that was mentioned in the \
",
  ButtonBox["Introduction",
    ButtonData:>"COM Introduction",
    ButtonStyle->"AddOnsLinkText"],
  ". You can think of it as a proxy object that represents the COM object in \
the .NET world. For most .NET objects, the string inside the brackets in the \
",
  StyleBox["OutputForm", "MR"],
  " representation of the object gives the name of the object\
\[CloseCurlyQuote]s .NET type. The ",
  StyleBox["voice", "MR"],
  " object is different\[LongDash]the string shows the name of the default \
COM interface supported by the object (",
  StyleBox["SpeechLib.ISpeechVoice", "MR"],
  "). Here is the actual type name of the object."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{

Cell["voice@GetType[]@ToString[]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.6.1"],

Cell[BoxData[
    \("System.__ComObject"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.6.1"]
}, Open  ]],

Cell[TextData[{
  "As you might have guessed, ",
  StyleBox["System.__ComObject", "MR"],
  " is the name of the RCW class. Seeing a .NET object represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as ",
  StyleBox["<<NETObject[System.__ComObject]>>", "MR"],
  " would not be very informative, as this could be ",
  "any",
  " COM object and thus tells you nothing about the object. When ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " returns an RCW object to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", it tries to determine the name of the default COM interface that the \
object supports. If this is successful, then ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " reports the object as ",
  StyleBox["<<NETObject[COMInterface[Default.COM.Interface]]>>", "MR"],
  ". Remember that this is the name of a COM interface and has no meaning \
whatsoever to .NET or ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". It is displayed simply to help you know something about the COM object \
that this .NET object represents. For ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to be able to determine the default COM interface name, the object must \
provide sufficiently detailed type information via a COM type library. Most \
COM objects provide this feature, so you will often see RCW objects formatted \
with a COM interface name. In some cases, however, the search for a default \
interface name will fail, and you will see a COM object formatted only as ",
  StyleBox["<<NETObject[System.__ComObject]>>", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "One drawback to using COM objects via Automation is that you cannot get \
information about COM methods and properties using ",
  StyleBox["NETTypeInfo", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{

Cell["NETTypeInfo[voice]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.6.1"],

Cell[BoxData[
    \(NETTypeInfo::"com" \(\(:\)\(\ \)\) 
      "Type information is not currently available for \"raw\" COM \
objects."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"nlug:3.6.1"],

Cell[BoxData[
    InterpretationBox[
      InterpretationBox["\<\"\"\>",
        {}],
      TableForm[ {}]]], "Output",
  CellLabel->"Out[3]//TableForm=",
  CellTags->"nlug:3.6.1"]
}, Open  ]],

Cell[TextData[{
  "Although you can call methods and properties on the COM object, you cannot \
see these methods directly from .NET. For information about methods and \
properties and their arguments, you will need to turn to the documentation \
for the COM object. Often you can find sample code in Visual Basic for using \
a COM object, and using it from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " via ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will look almost exactly the same."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "The ",
  StyleBox["ISpeechVoice", "MR"],
  " COM interface includes a property called ",
  StyleBox["Volume", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{

Cell["voice@Volume", "Input",
  CellLabel->"In[4]:=",
  CellTags->"nlug:3.6.1"],

Cell[BoxData[
    \(100\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"nlug:3.6.1"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Speak()", "MR"],
  " method speaks a string of text. Here is the declaration for the ",
  StyleBox["Speak()", "MR"],
  " method from the IDL file for the ",
  StyleBox["SpeechLib", "MR"],
  " type library."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell["\<\
long Speak([in] BSTR Text, [in, optional, defaultvalue(0)] \
SpeechVoiceSpeakFlags Flags);\
\>", "Program",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "Experienced COM programmers will recognize the elements of this \
declaration. The first argument is a ",
  StyleBox["BSTR", "MR"],
  ", which is a string in the COM world. Such arguments are called with a \
string from .NET, and thus with a string from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The second argument is marked as optional, with a default value of 0. \
This means that the ",
  StyleBox["Speak()", "MR"],
  " method can be called without the second argument."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell["\<\
voice@Speak[\"This is an example of using the SpVoice object via \
Automation\"];\
\>", "Input",
  CellLabel->"In[5]:=",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "The second argument is listed as being of the type ",
  StyleBox["SpeechVoiceSpeakFlags", "MR"],
  ", which is a COM enumeration containing constants that control how the \
text is spoken. One drawback to using COM objects via Automation is that \
there is no way to access COM enumerations. To use the second argument, you \
have to supply an integer value that corresponds to the correct value of the \
enum. You can get this information from the documentation or from the type \
library itself using a tool like OLE View, which is bundled with Microsoft \
Visual Studio. To speak the voice asynchronously, meaning the ",
  StyleBox["Speak()", "MR"],
  " method will return before the text finishes speaking, you use the flag ",
  StyleBox["SVSFlagsAsync", "MR"],
  ", which has the value 1."
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell["\<\
voice@Speak[\"This is an example of using the SpVoice object via Automation. \
This text is spoken asynchronously\", 1];\
\>", "Input",
  CellLabel->"In[6]:=",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{

Cell["Drawbacks to Using Automation", "Subsubsection",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "You have seen how ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " allows you to use COM objects via their ",
  StyleBox["IDispatch", "MR"],
  " interface. This has the advantage of requiring no preparation at all, but \
there are several drawbacks:"
}], "Text",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "   \[FilledSmallSquare]  You can only call methods on an object\
\[CloseCurlyQuote]s default interface.\n   \[FilledSmallSquare]  You cannot \
use ",
  StyleBox["NETTypeInfo", "MR"],
  " to get information about the methods and properties of an object.\n   \
\[FilledSmallSquare]  You cannot access COM enumerations or structs.\n   \
\[FilledSmallSquare]  You cannot use COM events."
}], "ItemizedText",
  CellTags->"nlug:3.6.1"],

Cell[TextData[{
  "These drawbacks are the same as you would encounter using COM from a pure \
scripting language like VBScript. The next section discusses a better way to \
use COM with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.6.1"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using an Interop Assembly (Early Binding)", "Subsection",
  CellTags->{"Interop Assembly", "nlug:3.6.2"}],

Cell[TextData[{
  "The previous section described using COM objects in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " via their ",
  StyleBox["IDispatch", "MR"],
  " interface, often called late binding or Automation. There are drawbacks \
to that technique, but luckily .NET supports calling COM objects via a more \
sophisticated and efficient technique called early binding. This is similar \
to how COM objects are used in C++, as method dispatch happens via the vtable \
interface, not ",
  StyleBox["IDispatch", "MR"],
  ". To use early binding in .NET, you must first create or find a so-called \
",
  "interop assembly",
  ". An interop assembly is a special assembly that contains metadata that \
describes the types and methods in a COM type library. Once you have an \
interop assembly, it can be loaded and used like any other .NET assembly, and \
the COM types it describes look like native .NET types to clients."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "Interop assemblies can be created with a tool called ",
  StyleBox["tlbimp.exe", "MR"],
  " (\[OpenCurlyDoubleQuote]type library importer\[CloseCurlyDoubleQuote]), \
which is included with the .NET Framework SDK, and also with Visual Studio \
.NET. You will find ample documentation on how to run ",
  StyleBox["tlbimp", "MR"],
  ", and you will see an example later. It is also possible to create an \
interop assembly programmatically, and ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides the ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " function for this purpose. ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " takes a COM type library, creates an interop aassembly from it, and loads \
this assembly into ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". You can think of it as analogous to ",
  StyleBox["LoadNETAssembly", "MR"],
  ", except that it takes a path to a COM type library instead."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["LoadCOMTypeLibrary",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["typeLibPath",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                
                "MR"]}], \(create\ an\ interop\ assembly\ from\ the\ given\ \
type\ library\ and\ load\ it\)}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.6.2"],

Cell["Loading COM  type libraries.", "Caption",
  CellTags->"nlug:3.6.2"],

Cell["\<\
Earlier you used the COM-based Microsoft Speech API via Automation. The \
preferred method is to load the type library to allow earliy binding.\
\>", "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["\<\
speechAsm = LoadCOMTypeLibrary[\"C:\\\\Program Files\\\\Common \
Files\\\\Microsoft Shared\\\\Speech\\\\sapi.dll\"]\
\>", "Input",
  CellLabel->"In[7]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[
    \(NETAssembly["interop.SpeechLib", 25]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[TextData[{
  "Interop assemblies created by ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " are created with default rules for naming of namespaces and types, and it \
is useful to use ",
  StyleBox["NETTypeInfo", "MR"],
  " on the assembly to see what types are available. For each coclass in the \
COM type library, a class will be created in the interop assembly with the \
name of the coclass with the word \[OpenCurlyDoubleQuote]Class\
\[CloseCurlyDoubleQuote] appended. You saw earlier that there was a coclass \
called ",
  StyleBox["SpVoice", "MR"],
  ", so you expect to find a .NET class called ",
  StyleBox["SpVoiceClass", "MR"],
  " in the interop assembly. There are a lot of types in this assembly; this \
shows just the classes."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["NETTypeInfo[speechAsm, \"Classes\"]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{\(\(Assembly\)\(:\)\(\ \)\), 
            StyleBox["\<\"interop.SpeechLib\"\>",
              FontWeight->"Bold"]}]},
        {"\<\"Full Name: interop.SpeechLib, Version=5.0.0.0\"\>"},
        {\(\(Location\)\(:\)\(\ \)\)},
        {""},
        {Cell[BoxData[
              RowBox[{\(\(\[FilledCircle]\)\(\ \)\), 
                StyleBox["Classes",
                  FontSize->18,
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]]]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox[\(_ISpeechRecoContextEvents  _SinkHelper\),
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox[\(_ISpeechVoiceEvents  _SinkHelper\),
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpAudioFormatClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpCompressedLexiconClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpCustomStreamClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpeechConstants",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpeechStringConstants",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpFileStreamClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpInProcRecoContextClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpInprocRecognizerClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpLexiconClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpMemoryStreamClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpMMAudioEnumClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpMMAudioInClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpMMAudioOutClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpNotifyTranslatorClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpNullPhoneConverterClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpObjectTokenCategoryClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpObjectTokenClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpPhoneConverterClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpPhraseInfoBuilderClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpRecPlayAudioClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpResourceManagerClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpSharedRecoContextClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpSharedRecognizerClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpStreamClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpStreamFormatConverterClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpTextSelectionInformationClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpUnCompressedLexiconClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpVoiceClass",
              FontWeight->"Bold"]}]},
        {
          RowBox[{\(\(class\)\(\ \)\), "\<\"SpeechLib.\"\>", 
            StyleBox["SpWaveFormatExClass",
              FontWeight->"Bold"]}]}
        },
      ColumnAlignments->{Left},
      RowMinHeight->1.2]], "Output",
  AutoSpacing->False,
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[TextData[{
  "You will find ",
  StyleBox["NETTypeInfo", "MR"],
  " very useful when exploring an interop assembly. When creating a COM \
object earlier using Automation, you used the ",
  StyleBox["CreateCOMObject", "MR"],
  " function. Now that you have .NET classes that represent the COM \
coclasses, you can call ",
  StyleBox["NETNew", "MR"],
  " instead."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["voice = NETNew[\"SpeechLib.SpVoiceClass\"]", "Input",
  CellLabel->"In[9]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "SpeechLib.SpVoiceClass"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$100663297]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[TextData[{
  "You use this object just like any other .NET object. Here is the ",
  StyleBox["Speak()", "MR"],
  " method. For some reason, the optional nature of the second argument is \
not preserved in the interop assembly, so you have to call ",
  StyleBox["Speak()", "MR"],
  " with two arguments."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["\<\
voice@Speak[\"Using COM objects is easier with an interop assembly\", 1]\
\>", "Input",
  CellLabel->"In[10]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[TextData[{
  "When using Automation, you saw that the second argument is a COM \
enumeration called ",
  StyleBox["SpeechVoiceSpeakFlags", "MR"],
  ". When using Automation, however, there is no way to access an \
enumeration, so you had to pass an integer value. But with an interop \
assembly there is a .NET enumeration you can use to make your code more \
readable."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell["\<\
LoadNETType[\"SpeechLib.SpeechVoiceSpeakFlags\"];
voice@Speak[\"Using COM objects is easier with an interop assembly\", \
SpeechVoiceSpeakFlags`SVSFlagsAsync];\
\>", "Input",
  CellLabel->"In[11]:=",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "One great advantage of having an interop assembly is that you can use ",
  StyleBox["NETTypeInfo", "MR"],
  " to get information about the methods and properties supported by objects. \
This shows the properties of the ",
  StyleBox["voice", "MR"],
  " object."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["NETTypeInfo[voice, \"Properties\"]", "Input",
  CellLabel->"In[12]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[GridBox[{
        {""},
        {Cell[BoxData[
              RowBox[{\(\(\[FilledCircle]\)\(\ \)\), 
                StyleBox["Properties",
                  FontSize->18,
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]]]},
        {
          RowBox[{
          "virtual", " ", "\<\"SpeechLib.SpeechVoiceEvents\"\>", " ", 
            StyleBox["AlertBoundary",
              FontWeight->"Bold"]}]},
        {
          RowBox[{"virtual", " ", "\<\"bool\"\>", " ", 
            StyleBox["AllowAudioOutputFormatChangesOnNextSet",
              FontWeight->"Bold"]}]},
        {
          RowBox[{"virtual", " ", "\<\"SpeechLib.SpObjectToken\"\>", " ", 
            StyleBox["AudioOutput",
              FontWeight->"Bold"]}]},
        {
          RowBox[{
          "virtual", " ", "\<\"SpeechLib.ISpeechBaseStream\"\>", " ", 
            StyleBox["AudioOutputStream",
              FontWeight->"Bold"]}]},
        {
          RowBox[{
          "virtual", " ", "\<\"SpeechLib.SpeechVoiceEvents\"\>", " ", 
            StyleBox["EventInterests",
              FontWeight->"Bold"]}]},
        {
          RowBox[{
          "virtual", " ", "\<\"SpeechLib.SpeechVoicePriority\"\>", " ", 
            StyleBox["Priority",
              FontWeight->"Bold"]}]},
        {
          RowBox[{"virtual", " ", "\<\"int\"\>", " ", 
            StyleBox["Rate",
              FontWeight->"Bold"]}]},
        {
          RowBox[{
          "virtual", " ", "\<\"SpeechLib.ISpeechVoiceStatus\"\>", " ", 
            StyleBox["Status",
              FontWeight->"Bold"], \(\(\ \ \)\([read\ only]\)\)}]},
        {
          RowBox[{"virtual", " ", "\<\"int\"\>", " ", 
            StyleBox["SynchronousSpeakTimeout",
              FontWeight->"Bold"]}]},
        {
          RowBox[{"virtual", " ", "\<\"SpeechLib.SpObjectToken\"\>", " ", 
            StyleBox["Voice",
              FontWeight->"Bold"]}]},
        {
          RowBox[{"virtual", " ", "\<\"int\"\>", " ", 
            StyleBox["Volume",
              FontWeight->"Bold"]}]}
        },
      ColumnAlignments->{Left},
      RowMinHeight->1.2]], "Output",
  AutoSpacing->False,
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[TextData[{
  "Note that once an interop assembly is loaded for a type library, if you \
call ",
  StyleBox["CreateCOMObject", "MR"],
  " with the name of a COM coclass, you get back a native .NET object of the \
class that corresponds to the COM coclass, not a raw RCW as before. This \
means that ",
  StyleBox["CreateCOMObject", "MR"],
  " and ",
  StyleBox["NETNew", "MR"],
  " become equivalent ways of creating an instance of a COM coclass."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["voice2 = CreateCOMObject[\"Sapi.SpVoice\"]", "Input",
  CellLabel->"In[13]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "SpeechLib.SpVoiceClass"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$83886081]], "Output",
  CellLabel->"Out[13]=",
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["SaveAssemblyAs",
              "MR"], 
            StyleBox["None",
              "MR"], Cell[
            "a full pathname to the assembly file you want created", 
              "Text"]},
          {
            StyleBox["SafeArrayAsArray",
              "MR"], 
            StyleBox["False",
              "MR"], Cell[TextData[{
              "whether to marshal ",
              StyleBox["SAFEARRAY", "MR"],
              " types as ",
              StyleBox["System.Array", "MR"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}},
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "Options to ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  "."
}], "Caption",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " takes two options that control the assembly-creation process. The first \
is ",
  StyleBox["SaveAssemblyAs", "MR"],
  ", which allows you to specify a filename into which you want the created \
assembly saved. ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " can take a while to execute, so it is useful to save the assembly in a \
file and load it using ",
  StyleBox["LoadNETAssembly", "MR"],
  " in the future. This makes ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " the programmatic equivalent to running the ",
  StyleBox["tlbimp.exe", "MR"],
  " tool, in that it can write out the generated assembly. The second option \
to ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " is ",
  StyleBox["SafeArrayAsArray", "MR"],
  ", which specifies whether to import all COM ",
  StyleBox["SAFEARRAY", "MR"],
  "'s as the ",
  StyleBox["System.Array", "MR"],
  " class rather than a typed, single dimensional managed array. The default \
is ",
  StyleBox["False", "MR"],
  ". See the .NET Framework documentation for the ",
  StyleBox["System.Runtime.InteropServices.TypeLibImporterFlags", "MR"],
  " enumeration for more details on this advanced option. If you need more \
control over the generated assembly, use the ",
  StyleBox["tlbimp.exe", "MR"],
  " tool as described in the next section."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "In the earlier discussion of using COM objects via Automation, the role of \
the RCW was described. You saw that the class name of a \
\[OpenCurlyDoubleQuote]raw\[CloseCurlyDoubleQuote] RCW is ",
  StyleBox["System.__ComObject", "MR"],
  ". It is important to remember that ",
  "all",
  " COM objects are represented in .NET as RCWs, even when using an interop \
assembly. You can see below that the ",
  StyleBox["SpVoiceClass", "MR"],
  " derives from ",
  StyleBox["__ComObject", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["NETTypeInfo[voice, \"Type\"]", "Input",
  CellLabel->"In[14]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[GridBox[{
        {Cell[BoxData[
              RowBox[{\(\(\[FilledCircle]\)\(\ \)\), 
                StyleBox["Type",
                  FontSize->18,
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]]]},
        {
          RowBox[{\(\(class\)\(\ \)\), 
            StyleBox["\<\"SpeechLib.SpVoiceClass\"\>",
              FontWeight->"Bold"]}]},
        {GridBox[{
              {\(\(Inheritance\)\(:\)\)},
              {\(\(\ \ \ \)\(\ \ \ \)\("System.Object"\)\)},
              {\(\(\ \ \ \)\(\ \ \ \)\(\ \ \ \
\)\("System.MarshalByRefObject"\)\)},
              {\(\(\ \ \ \)\(\ \ \ \)\(\ \ \ \)\(\ \ \ \
\)\("System.__ComObject"\)\)},
              {
                RowBox[{"   ", "   ", "   ", "   ", "   ", 
                  StyleBox["\<\"SpeechLib.SpVoiceClass\"\>",
                    FontWeight->"Bold"]}]}
              },
            ColumnAlignments->{Left}]},
        {\(Interfaces\ \(Implemented : \ "SpeechLib.ISpeechVoice"\), \ 
          "SpeechLib.SpVoice", \ "SpeechLib._ISpeechVoiceEvents_Event", \ 
          "SpeechLib.ISpVoice", \ "SpeechLib.ISpEventSource", \ 
          "SpeechLib.ISpNotifySource"\)},
        {"\<\"Assembly-Qualified Name: SpeechLib.SpVoiceClass, \
interop.SpeechLib, Version=5.0.0.0\"\>"},
        {\(Assembly\ \(Location : \ Dynamically\ generated\)\)}
        },
      ColumnAlignments->{Left},
      RowMinHeight->1.2]], "Output",
  AutoSpacing->False,
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell["Here is another way to prove the inheritance relationship.", "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["InstanceOf[voice, \"System.__ComObject\"]", "Input",
  CellLabel->"In[15]:=",
  CellTags->"nlug:3.6.2"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using tlbimp.exe to Create an Interop Assembly", "Subsubsection",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "As mentioned earlier, the .NET Framework SDK includes a tool called ",
  StyleBox["tlbimp.exe", "MR"],
  " (type library importer) that creates an interop assembly from a COM type \
library. You can use this tool to create an interop assembly and load it \
using ",
  StyleBox["LoadNETAssembly", "MR"],
  ", instead of using the ",
  StyleBox["LoadCOMTypeLibrary", "MR"],
  " function. The ",
  StyleBox["tlbimp", "MR"],
  " program has many options to control how the assembly is generated, so if \
you need this level of control, you will definitely want to run it manually. \
The .NET Framework SDK documentation describes how to use ",
  StyleBox["tlbimp", "MR"],
  " in detail, but here is an example of how it could be used to create an \
interop assembly for the ",
  StyleBox["SpeechLib", "MR"],
  " type library."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell["\<\
tlbimp \"C:\\Program Files\\Common Files\\Microsoft \
Shared\\Speech\\sapi.dll\"  /out:c:\\interop.SpeechLib.dll \
\>", "Program",
  CellTags->"nlug:3.6.2"],

Cell["\<\
Once the assembly has been created, load it like any other assembly.\
\>", "Text",
  CellTags->"nlug:3.6.2"],

Cell["LoadNETAssembly[\"c:\\\\interop.SpeechLib.dll\"];", "Input",
  CellTags->"nlug:3.6.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Primary Interop Assemblies", "Subsubsection",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "A primary interop assembly (PIA) is a special interop assembly that is \
signed by the vendor and given a strong name so that it can be placed into \
the global assembly cache (GAC). The idea behind a PIA is that a vendor of a \
COM type library will create an \[OpenCurlyDoubleQuote]official\
\[CloseCurlyDoubleQuote] interop assembly that represents the ideal interface \
to their type library. The .NET runtime recognizes PIAs as being special \
\[OpenCurlyDoubleQuote]blessed\[CloseCurlyDoubleQuote] assemblies, and it \
will load one automatically when you call ",
  StyleBox["CreateCOMObject", "MR"],
  " on a coclass for which the associated PIA has been installed. If you are \
using a COM library, you should check to see if the vendor has created a PIA \
for it. If so, you should install it."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "A good example of PIAs is the set created by Microsoft to accommodate the \
Office XP suite, which exposes a rich object model for Automation. Anyone \
trying to control an Office XP component like Word or Excel from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should obtain the Office PIAs from ",
  ButtonBox["http://msdn.microsoft.com/library/default.asp?url=/downloads/\
list/office.asp",
    ButtonData:>{
      URL[ 
      "http://msdn.microsoft.com/library/default.asp?url=/downloads/list/\
office.asp"], None},
    ButtonStyle->"Hyperlink"],
  ". These PIAs are installed by default with Office 2003, but you can \
install them for use with Office XP and perhaps earlier versions of Office as \
well."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[TextData[{
  "The ",
  ButtonBox["ExcelPieChart.nb",
    ButtonFunction:>(NotebookOpen[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
          "Calling COM"}, #]]&),
    ButtonEvaluator->Automatic,
    ButtonStyle->"Hyperlink"],
  " example file shows how to call Excel from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ". That example will work whether or not you have the Office PIAs \
installed, but if the PIAs are present, you have the advantages of working \
with strongly typed .NET objects instead of raw RCW objects. If the PIAs are \
installed on your machine, and ",
  StyleBox["CreateCOMObject", "MR"],
  " is called to start an instance of Excel, it automatically returns a .NET \
type from the Excel interop assembly, not a raw RCW like ",
  StyleBox["<<NETObject[COMInterface[Excel._Application]]>>", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{

Cell["excel = CreateCOMObject[\"Excel.Application\"]", "Input",
  CellLabel->"In[16]:=",
  Evaluatable->False,
  CellTags->"nlug:3.6.2"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Microsoft.Office.Interop.Excel.ApplicationClass"] \
\[RightGuillemet]\),
      NETLink`Objects`NETObject$134217729]], "Output",
  CellLabel->"Out[16]=",
  CellTags->"nlug:3.6.2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Releasing COM Resources", "Subsection",
  CellTags->"nlug:3.6.3"],

Cell[TextData[{
  "One of the roles of the RCW object in .NET is to manage the life cycle of \
the COM object it wraps. The COM object is destroyed when the RCW object is \
freed by the .NET garbage collector. Often, this level of control over the \
lifetime of the COM object is fine. Remember, though, that the .NET garabage \
collector may run infrequently, and generally only when the .NET memory space \
(the \[OpenCurlyDoubleQuote]managed\[CloseCurlyDoubleQuote] heap) fills up. \
RCW objects have a small footprint in the managed heap, but they may hold \
onto very large objects (such as an instance of Excel) in the unmanaged COM \
world. In some COM usage scenarios, the .NET garbage collector may not run \
even though there are a large number of unfreed and unused RCW objects that \
are keeping alive a large amount of memory and other resources in the COM \
world. For this reason, it is important to have a function that forces the \
COM resources held by an object to be released. That function is ",
  StyleBox["ReleaseCOMObject", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ReleaseCOMObject",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["obj",
                "MR",
                FontSlant->"Italic"], 
              StyleBox["]",
                
                "MR"]}], \(releases\ the\ COM\ resources\ owned\ by\ the\ \
given\ COM\ object\)}
          }], TextForm]], "DefinitionBox",
  CellTags->"nlug:3.6.3"],

Cell["Releasing COM resources.", "Caption",
  CellTags->"nlug:3.6.3"],

Cell[TextData[{
  "Every COM object in .NET is represented by a single unique RCW. If you \
acquire a reference to the same COM object through two different means, you \
will get the same RCW each time. This sole RCW keeps a reference count on the \
COM object. This reference count is internal to COM and should not be \
confused with the reference count of a .NET object. Calling ",
  StyleBox["ReleaseCOMObject", "MR"],
  " does not actually force the immediate release of COM \
resources\[LongDash]it just decrements this internal COM reference count. \
Often this count will be just one, ",
  StyleBox["ReleaseCOMobject", "MR"],
  " will cause it to go to zero, and then the resources will be freed. ",
  StyleBox["ReleaseCOMObject", "MR"],
  " returns the new reference count, so you can see if it has gone to zero \
yet."
}], "Text",
  CellTags->"nlug:3.6.3"],

Cell["\<\
Here is an example of acquiring multiple references to the same COM object. \
The following line launches a new instance of Excel. It will not become \
visible, but you can see it in the Task Manager listing of processes.\
\>", "Text",
  CellTags->"nlug:3.6.3"],

Cell[CellGroupData[{

Cell["excel1 = CreateCOMObject[\"Excel.Application\"]", "Input",
  CellLabel->"In[17]:=",
  CellTags->"nlug:3.6.3"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Microsoft.Office.Interop.Excel.ApplicationClass"] \
\[RightGuillemet]\),
      NETLink`Objects`NETObject$83886081]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"nlug:3.6.3"]
}, Open  ]],

Cell[TextData[{
  "Now acquire two more references to that same instance of Excel. The ",
  StyleBox["GetActiveCOMObject", "MR"],
  " function is like ",
  StyleBox["CreateCOMObject", "MR"],
  " except that instead of creating a new object, it acquires an \
already-active one. It is analogous to the ",
  StyleBox["GetActiveObject()", "MR"],
  " function in the COM API and Visual Basic 6. The ",
  StyleBox["Pause", "MR"],
  " is necessary here because COM apparently needs to catch its breath a bit \
between calls to ",
  StyleBox["GetActiveObject()", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.3"],

Cell["\<\
excel2 = GetActiveCOMObject[\"Excel.Application\"];
Pause[1];
excel3 = GetActiveCOMObject[\"Excel.Application\"];\
\>", "Input",
  CellLabel->"In[18]:=",
  CellTags->"nlug:3.6.3"],

Cell[TextData[{
  "If you called ",
  StyleBox["ReleaseCOMObject[excel1]", "MR"],
  " now, you probably would not want Excel to quit, because there are other \
outstanding references to Excel via the ",
  StyleBox["excel2", "MR"],
  " and ",
  StyleBox["excel3", "MR"],
  " objects. Note how calling ",
  StyleBox["ReleaseCOMObject", "MR"],
  " decrements the COM reference count on the instance of Excel until it \
finally goes to zero. Only when it reaches zero will the Excel process quit."
}], "Text",
  CellTags->"nlug:3.6.3"],

Cell[CellGroupData[{

Cell["\<\
{ReleaseCOMObject[excel1], ReleaseCOMObject[excel2], \
ReleaseCOMObject[excel3]}\
\>", "Input",
  CellLabel->"In[21]:=",
  CellTags->"nlug:3.6.3"],

Cell[BoxData[
    \({2, 1, 0}\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"nlug:3.6.3"]
}, Open  ]],

Cell[TextData[{
  "You have now seen how to use ",
  StyleBox["ReleaseCOMObject", "MR"],
  " to force the timely release of COM resources. It is never strictly \
necessary to do this, as the .NET garbage collector will get around to it \
eventually, but often it is not timely enough. An alternative to using ",
  StyleBox["ReleaseCOMObject", "MR"],
  " is simply to make sure that you use ",
  StyleBox["NETBlock", "MR"],
  " or ",
  StyleBox["ReleaseNETObject", "MR"],
  " to allow the .NET objects you create to be released. Then you can \
manually force the .NET garbage collector to run. This is especially \
convenient if you have code that creates a lot of COM objects. Rather than \
keeping track of all of them and calling ",
  StyleBox["ReleaseCOMObject", "MR"],
  " on each one, it is easier to use ",
  StyleBox["NETBlock", "MR"],
  " to ensure that the objects all have .NET reference counts of zero when \
you are done with them, and then call the garbage collector. Here is an \
outline of what that looks like."
}], "Text",
  CellTags->"nlug:3.6.3"],

Cell["\<\
SomeFunction[args__] :=
\tModule[{result},
\t\tNETBlock[
\t\t\t... some code here that creates and manipulates COM objects
\t\t\tresult = ...
\t\t];
\t\tLoadNETType[\"System.GC\"];
\t\tGC`Collect[];
\t\tresult
\t]\
\>", "Input",
  Evaluatable->False,
  CellTags->"nlug:3.6.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Casting COM Objects", "Subsection",
  CellTags->"nlug:3.6.4"],

Cell[TextData[{
  "In the earlier section ",
  ButtonBox["Casting",
    ButtonData:>"Casting",
    ButtonStyle->"AddOnsLinkText"],
  ", you encountered the ",
  StyleBox["CastNETObject", "MR"],
  " function. This function is rarely used for normal .NET objects, but it \
has special duties with respect to COM objects. The following example \
requires that you have the Microsoft Office XP primary interop assemblies \
installed on your machine. The next line will create a new instance of the \
Excel application, although it will not be visible."
}], "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{

Cell["\<\
excel = NETNew[\"Microsoft.Office.Interop.Excel.ApplicationClass\"]\
\>", "Input",
  CellLabel->"In[22]:=",
  CellTags->"nlug:3.6.4"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Microsoft.Office.Interop.Excel.ApplicationClass"] \
\[RightGuillemet]\),
      NETLink`Objects`NETObject$318767105]], "Output",
  CellLabel->"Out[22]=",
  CellTags->"nlug:3.6.4"]
}, Open  ]],

Cell["Now create a new workbook.", "Text",
  CellTags->"nlug:3.6.4"],

Cell["excel@Workbooks@Add[];", "Input",
  CellLabel->"In[23]:=",
  CellTags->"nlug:3.6.4"],

Cell[TextData[{
  "The ",
  StyleBox["ApplicationClass", "MR"],
  " class has a property called ",
  StyleBox["ActiveSheet", "MR"],
  " that will return the worksheet in the workbook you just created."
}], "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{

Cell["activeSheet = excel@ActiveSheet", "Input",
  CellLabel->"In[24]:=",
  CellTags->"nlug:3.6.4"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          COMInterface["Excel._Worksheet"]] \[RightGuillemet]\),
      NETLink`Objects`NETObject$1892867373$369098753]], "Output",
  CellLabel->"Out[24]=",
  CellTags->"nlug:3.6.4"]
}, Open  ]],

Cell[TextData[{
  "Notice that the result from ",
  StyleBox["ActiveSheet", "MR"],
  " is a raw RCW object, not a strongly typed .NET object (recall that raw \
RCW objects are of the class ",
  StyleBox["System.__ComObject", "MR"],
  ", and ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " tries to format them with the name of the default COM interface that they \
support). There is a ",
  StyleBox["Microsoft.Office.Interop.Excel.WorksheetClass", "MR"],
  " class in the Excel interop assembly that represents worksheets, so why \
was the result of ",
  StyleBox["ActiveSheet", "MR"],
  " not an instance of that class? To see the answer, look at the declaration \
of the ",
  StyleBox["ActiveSheet", "MR"],
  " property."
}], "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{

Cell["NETTypeInfo[excel, \"Properties\", \"ActiveSheet\"]", "Input",
  CellLabel->"In[25]:=",
  CellTags->"nlug:3.6.4"],

Cell[BoxData[GridBox[{
        {""},
        {Cell[BoxData[
              RowBox[{\(\(\[FilledCircle]\)\(\ \)\), 
                StyleBox["Properties",
                  FontSize->18,
                  FontWeight->"Bold",
                  
                  FontSlant->
                    "Italic"], "\<\" (matching string pattern \
ActiveSheet)\"\>"}]]]},
        {
          RowBox[{"virtual", " ", "\<\"object\"\>", " ", 
            StyleBox["ActiveSheet",
              FontWeight->"Bold"], \(\(\ \ \)\([read\ only]\)\)}]}
        },
      ColumnAlignments->{Left},
      RowMinHeight->1.2]], "Output",
  AutoSpacing->False,
  CellTags->"nlug:3.6.4"]
}, Open  ]],

Cell[TextData[{
  "Note that this property is typed to return only ",
  StyleBox["object", "MR"],
  ", not ",
  StyleBox["WorksheetClass", "MR"],
  ". That is because the active sheet could be a chart or a worksheet, and \
these are different classes. In an interop assembly, methods or properties \
that are typed to return ",
  StyleBox["object", "MR"],
  " will return a raw RCW. This reminds you that COM objects in .NET are \
different animals than normal .NET objects. When any object is marshaled from \
COM into .NET, it always arrives as a raw RCW. With the help of type \
information from an interop assembly, the .NET runtime can cast a raw RCW to \
a specific managed type. For example, if a method is typed to return class ",
  StyleBox["X", "MR"],
  ", and the method returns a COM object (as an RCW), .NET casts the RCW to \
the type ",
  StyleBox["X", "MR"],
  " before returning it from the method. If a method is typed to return only \
",
  StyleBox["object", "MR"],
  ", like the ",
  StyleBox["ActiveSheet", "MR"],
  " property, then there is no type information that .NET can use to cast the \
object, so you end up with a raw RCW."
}], "Text",
  CellTags->"nlug:3.6.4"],

Cell[TextData[{
  "You can use the object returned by ",
  StyleBox["ActiveSheet", "MR"],
  ", but you will be calling it via late binding because it has no type \
information. If you want to make a strongly typed object that you can call \
via early binding, then you do exactly what you would do in C# or Visual \
Basic .NET\[LongDash]you cast the object to the desired type. Once you have \
cast to the desired managed type, you once again have all the advantages that \
come from using an interop assembly instead of using late binding. In this \
example, you know that the active sheet is a worksheet, so you can cast it to \
",
  StyleBox["WorksheetClass", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{

Cell["\<\
activeSheet = CastNETObject[excel@ActiveSheet, \
\"Microsoft.Office.Interop.Excel.WorksheetClass\"]\
\>", "Input",
  CellLabel->"In[26]:=",
  CellTags->"nlug:3.6.4"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "Microsoft.Office.Interop.Excel.WorksheetClass"] \
\[RightGuillemet]\),
      NETLink`Objects`NETObject$402653185]], "Output",
  CellLabel->"Out[262]=",
  CellTags->"nlug:3.6.4"]
}, Open  ]],

Cell["\<\
If this sounds confusing, remember that this is exactly what is done in C# or \
Visual Basic .NET. Here is what it would look like in C#.\
\>", "Text",
  CellTags->"nlug:3.6.4"],

Cell["\<\
ApplicationClass excel = new ApplicationClass();
excel.Workbooks.Add();
WorksheetClass activeSheet = (WorksheetClass) excel.ActiveSheet;\
\>", "Program",
  CellTags->"nlug:3.6.4"],

Cell[TextData[{
  "If the COM object cannot be cast to the specified managed type, ",
  StyleBox["CastNETObject", "MR"],
  " will issue a message and return ",
  StyleBox["$Failed", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.4"],

Cell[TextData[{
  "In the earlier section ",
  ButtonBox["Casting",
    ButtonData:>"Casting",
    ButtonStyle->"AddOnsLinkText"],
  ", it was stated that there is never a need to downcast in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", because objects always have their true runtime type\[LongDash]there is \
never a type lower in the inheritance hierarchy to downcast to. This rule \
does not apply for casting COM objects, because in some sense the runtime \
type of all COM objects is just the raw RCW class ",
  StyleBox["__ComObject", "MR"],
  ". In the presence of type information, the .NET runtime can downcast \
automatically to more derived managed types. When a property or method is \
typed to return only ",
  StyleBox["object", "MR"],
  ", you can downcast the object yourself, provided you know the correct \
type."
}], "Text",
  CellTags->"nlug:3.6.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Handling COM Events", "Subsection",
  CellTags->{"Handling COM Events", "nlug:3.6.5"}],

Cell[TextData[{
  "The .NET runtime knows how to map COM events to .NET events, which means \
that responding to events fired by COM objects is just like responding to \
events fired by .NET objects. You must use an ",
  ButtonBox["interop assembly",
    ButtonData:>"Interop Assembly",
    ButtonStyle->"AddOnsLinkText"],
  " to handle COM events in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code\[LongDash]you cannot use late binding."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell[TextData[{
  "The following example shows how to handle COM events fired by Internet \
Explorer. Internet Explorer supports a rich object model for the content of \
an HTML window. This is called the document object model, and it is exposed \
to clients via the ",
  StyleBox["mshtml", "MR"],
  " COM library. Microsoft bundles with the .NET Framework a primary interop \
assembly for ",
  StyleBox["mshtml", "MR"],
  ", to make it easier to use from .NET programs. Presumably, there will \
eventually be a native .NET version of Internet Explorer and ",
  StyleBox["mshtml", "MR"],
  ", but for now, as with many other COM-based Microsoft technologies, you \
use them from .NET via an interop assembly. The example developed below will \
display a web page in an Internet Explorer window, and as the user moves the \
mouse over elements in the page, the elements will have their font size \
changed randomly."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell[TextData[{
  "The ",
  StyleBox["mshtml", "MR"],
  " COM component and its associated primary interop assembly only manage the \
content of an Internet Explorer window. The Internet Explorer application is \
a separate COM object that must be created in the usual way for raw COM \
objects."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell[CellGroupData[{

Cell["ie = CreateCOMObject[\"InternetExplorer.Application\"]", "Input",
  CellLabel->"In[27]:=",
  CellTags->"nlug:3.6.5"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          COMInterface["SHDocVw.IWebBrowser2"]] \[RightGuillemet]\),
      NETLink`Objects`NETObject$16336286$14008975361]], "Output",
  CellLabel->"Out[27]=",
  CellTags->"nlug:3.6.5"]
}, Open  ]],

Cell[TextData[{
  "The fact that this object is formatted with ",
  StyleBox["COMInterface[...", "MR"],
  "] indicates that it is a raw RCW and you can only interact with it via \
Automation. This is fine, as only a few simple properties are needed. To get \
documentation for COM objects, look them up in the MSDN Library, either \
online or in the Visual Studio help system."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell["First, navigate to a URL.", "Text",
  CellTags->"nlug:3.6.5"],

Cell["ie@navigate[\"www.wolfram.com/solutions/mathlink\"]", "Input",
  CellLabel->"In[28]:=",
  CellTags->"nlug:3.6.5"],

Cell["\<\
Now make the browser window visible and loop until the page has completely \
loaded.\
\>", "Text",
  CellTags->"nlug:3.6.5"],

Cell["\<\
ie@Visible = True;
While[ie@Busy, Pause[1]];\
\>", "Input",
  CellLabel->"In[29]:=",
  CellTags->"nlug:3.6.5"],

Cell["\<\
You want to interact not with the Internet Explorer application but with the \
document object that it contains, so acquire that object. \
\>", "Text",
  CellTags->"nlug:3.6.5"],

Cell[CellGroupData[{

Cell["doc = ie@Document", "Input",
  CellLabel->"In[31]:=",
  CellTags->"nlug:3.6.5"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "mshtml.HTMLDocumentClass"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$1157627905]], "Output",
  CellLabel->"Out[31]=",
  CellTags->"nlug:3.6.5"]
}, Open  ]],

Cell["\<\
Note that this object is a strongly typed .NET object, not a raw RCW. Because \
there is a primary interop assembly for the document object model, whenever \
such a COM object is imported into .NET it can be automatically wrapped in \
the .NET class that is mapped to the document COM coclass. You are now in the \
cozy world of using strongly typed objects from an interop assembly.\
\>", "Text",
  CellTags->"nlug:3.6.5"],

Cell[TextData[{
  "COM events fired by an object are mapped to .NET events in the interop \
assembly. You will see a .NET event member for each method in every ",
  StyleBox["[source]", "MR"],
  " COM interface that a .NET class implements. You can use ",
  StyleBox["NETTypeInfo", "MR"],
  " to see the events that are fired by the ",
  StyleBox["HTMLDocumentClass", "MR"],
  " class. There are quite a few for this class, so this just shows the one \
you need."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell[CellGroupData[{

Cell["NETTypeInfo[doc, \"Events\", \"*onmouseover*\"]", "Input",
  CellLabel->"In[32]:=",
  CellTags->"nlug:3.6.5"],

Cell[BoxData[GridBox[{
        {""},
        {Cell[BoxData[
              RowBox[{\(\(\[FilledCircle]\)\(\ \)\), 
                StyleBox["Events",
                  FontSize->18,
                  FontWeight->"Bold",
                  
                  FontSlant->
                    "Italic"], "\<\" (matching string pattern \
*onmouseover*)\"\>"}]]]},
        {
          RowBox[{
          "virtual", " ", "event", 
            " ", "\<\"mshtml.HTMLDocumentEvents2_onmouseoverEventHandler\"\>",
             " ", 
            StyleBox[\(HTMLDocumentEvents2_Event  _onmouseover\),
              
              FontWeight->
                "Bold"], "\<\"  [arguments to delegate: \"\>", \
"\<\"(mshtml.IHTMLEventObj pEvtObj)\"\>", "\<\"]\"\>"}]},
        {
          RowBox[{
          "virtual", " ", "event", 
            " ", "\<\"mshtml.HTMLDocumentEvents_onmouseoverEventHandler\"\>", 
            " ", 
            StyleBox[\(HTMLDocumentEvents_Event  _onmouseover\),
              
              FontWeight->
                "Bold"], "\<\"  [arguments to delegate: \"\>", "\<\"()\"\>", \
"\<\"]\"\>"}]}
        },
      ColumnAlignments->{Left},
      RowMinHeight->1.2]], "Output",
  AutoSpacing->False,
  CellTags->"nlug:3.6.5"]
}, Open  ]],

Cell[TextData[{
  "There are two ",
  StyleBox["onmouseover", "MR"],
  " events inherited from two different interfaces. You want to use the one \
named ",
  StyleBox["HTMLDocumentEvents2_Event_onmouseover", "MR"],
  ", which supplies an argument. There is no separate documentation for the \
",
  StyleBox["mshtml", "MR"],
  " primary interop assembly, so you have to use the documentation for the \
COM version and make the appropriate mental translations, which are usually \
quite straightforward. You can find full documentation on the ",
  StyleBox["mshtml", "MR"],
  " component at ",
  ButtonBox["http://msdn.microsoft.com/library/default.asp?url=/workshop/\
browser/mshtml/reference/reference.asp",
    ButtonData:>{
      URL[ 
      "http://msdn.microsoft.com/library/default.asp?url=/workshop/browser/\
mshtml/reference/reference.asp"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell[TextData[{
  "The section ",
  ButtonBox["Handling Events",
    ButtonData:>"Handling Events",
    ButtonStyle->"AddOnsLinkText"],
  " showed you how to use the ",
  StyleBox["AddEventHandler", "MR"],
  " function to assign ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions to be called when events are fired in .NET. You use the same \
function for COM events, as they are made to look just like .NET events by \
the interop assembly. Note that as always you must change ",
  StyleBox["_", "MR"],
  " characters to ",
  StyleBox["U", "MR"],
  " when using .NET names as symbols."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell["\<\
AddEventHandler[doc@HTMLDocumentEvents2UEventUonmouseover, onMouseOver];\
\>", "Input",
  CellLabel->"In[33]:=",
  CellTags->"nlug:3.6.5"],

Cell[TextData[{
  "Now define the ",
  StyleBox["onMouseOver", "MR"],
  " function. The ",
  StyleBox["NETTypeInfo", "MR"],
  " call above told you that the argument to the event is of interface type \
",
  StyleBox["mshtml.IHTMLEventObj", "MR"],
  ". This is the managed equivalent of the ",
  StyleBox["IHTMLEventObj", "MR"],
  " COM interface, and from the documentation for that interface you can cook \
up the following simple function that wraps every element in a ",
  StyleBox["<FONT>", "MR"],
  " element that specifies a random font size."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell["\<\
onMouseOver[evt_] :=
\tModule[{element},
\t\telement = evt@srcElement;
\t\telement@innerHTML = \"<FONT size='\" <> ToString[Random[Integer, {1,7}]] \
<> \"'>\" <> element@innerHTML <> \"</FONT>\";
\t]\
\>", "Input",
  CellLabel->"In[34]:=",
  CellTags->"nlug:3.6.5"],

Cell[TextData[{
  "Before you actually try moving the mouse over the web page, there is one \
more detail that must be handled. In the earlier section ",
  ButtonBox["Sharing the Kernel with .NET",
    ButtonData:>"Sharing the Kernel",
    ButtonStyle->"AddOnsLinkText"],
  ", you saw how to use the ",
  StyleBox["ShareKernel", "MR"],
  " function to put the kernel into a state where it was receptive to calls \
arriving from .NET. ",
  StyleBox["ShareKernel", "MR"],
  " is not often needed in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", because you can usually enter and leave the sharing state automatically \
using the ",
  StyleBox["DoNETModeless", "MR"],
  " function. ",
  StyleBox["DoNETModeless", "MR"],
  " requires a top-level window as its argument, however. Here you have no \
such window, just an instance of Internet Explorer. Therefore you have to use \
",
  StyleBox["ShareKernel", "MR"],
  " to manually enter the sharing state. As always, you save the result from \
",
  StyleBox["ShareKernel", "MR"],
  " to pass into ",
  StyleBox["UnshareKernel", "MR"],
  " later."
}], "Text",
  CellTags->"nlug:3.6.5"],

Cell["tok = ShareKernel[NETLink[]];", "Input",
  CellLabel->"In[35]:=",
  CellTags->"nlug:3.6.5"],

Cell["\<\
Now bring the Internet Explorer window to the foreground and move the mouse \
over it (without pressing the mouse button). It might take a second or two \
for the first font effect to occur.\
\>", "Text",
  CellTags->"nlug:3.6.5"],

Cell["Make sure you clean things up when you are done.", "Text",
  CellTags->"nlug:3.6.5"],

Cell["\<\
ie@Quit[];
UnshareKernel[tok];\
\>", "Input",
  CellLabel->"(sharing) In[36]:=",
  CellTags->"nlug:3.6.5"],

Cell[TextData[{
  "This is a frivolous example, but you can imagine many more useful and \
sophisticated ways to interact with a browser window using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"nlug:3.6.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["Displaying ActiveX Controls", "Subsection",
  CellTags->"nlug:3.6.6"],

Cell[TextData[{
  "Many COM objects have a visual representation, such as a toolbar, grid \
box, or other window element. Although the term \
\[OpenCurlyDoubleQuote]ActiveX control\[CloseCurlyDoubleQuote] is really just \
a synonym for \[OpenCurlyDoubleQuote]COM object,\[CloseCurlyDoubleQuote] \
visual COM objects are usually referred to as ActiveX controls. If you want \
to display an ActiveX control in a .NET program, you must create a special \
type of interop assembly for the control. This assembly is created with the \
",
  StyleBox["aximp.exe", "MR"],
  " tool (ActiveX importer), which is similar to the ",
  StyleBox["tlbimp", "MR"],
  " tool discussed earlier, except that it is specific to ActiveX controls \
that must be hosted within a .NET window. If a control is to be hosted within \
a .NET window, it needs a special wrapper class that inherits from ",
  StyleBox["System.Windows.Forms.Control", "MR"],
  ". The ",
  StyleBox["aximp", "MR"],
  " tool creates this wrapper class."
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell[TextData[{
  "There is full documentation for ",
  StyleBox["aximp", "MR"],
  " in the .NET Framework SDK, but here is a simple example. Say you want to \
use the Microsoft Calendar Control in a .NET window (you probably have this \
control installed on your machine). Assume that the type library for this \
control is in the file ",
  StyleBox["d:\\OfficeXP\\Office10\\mscal.ocx", "MR"],
  " on your machine. (One way to get information like this is by looking up \
the control using the OLE View tool that is bundled with Visual Studio.) The \
following command line runs ",
  StyleBox["aximp", "MR"],
  " (of course, ",
  StyleBox["aximp.exe", "MR"],
  " has to be on your ",
  StyleBox["PATH", "MR"],
  " for this to work as written)."
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell["c:\\> aximp d:\\OfficeXp\\Office10\\mscal.ocx", "Program",
  CellTags->"nlug:3.6.6"],

Cell[TextData[{
  "The above invocation of ",
  StyleBox["aximp", "MR"],
  " creates two assemblies in the current directory: ",
  StyleBox["MSACAL.dll", "MR"],
  " and ",
  StyleBox["AxMSACAL.dll", "MR"],
  " (the \"MSACAL\" comes from the ",
  StyleBox["library MSACAL", "MR"],
  " statement in the control\[CloseCurlyQuote]s type library definition). The \
",
  StyleBox["MSACAL.dll", "MR"],
  " assembly contains managed types for the ",
  StyleBox["ICalendar", "MR"],
  " interface and ",
  StyleBox["CalendarClass", "MR"],
  " class, along with a few others. This is the same interop assembly that \
would be created by using the ",
  StyleBox["tlbimp", "MR"],
  " tool. The second assembly, ",
  StyleBox["AxMSACAL.dll", "MR"],
  ", contains the special wrapper class that makes the Calendar control into \
a .NET control that can be hosted in a .NET window. This wrapper class is \
called ",
  StyleBox["AxCalendar", "MR"],
  ", named according to the convention \[OpenCurlyDoubleQuote]Ax\
\[CloseCurlyDoubleQuote] followed by the name of the COM coclass (Calendar). \
The ",
  StyleBox["ildasm.exe", "MR"],
  " tool (intermediate language disassembler) is very useful for examining \
the created assemblies. The ",
  StyleBox["ildasm.exe", "MR"],
  " program is bundled with the .NET Framework SDK and resides in the same \
directory as ",
  StyleBox["aximp.exe", "MR"],
  " and ",
  StyleBox["tlbimp.exe", "MR"],
  "."
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell[TextData[{
  "When you load the ",
  StyleBox["AxMSACAL.dll", "MR"],
  " assembly, the ",
  StyleBox["MSACAL.dll", "MR"],
  " assembly will be loaded as well, because ",
  StyleBox["AxMSACAL.dll", "MR"],
  " is dependent on it and it resides in the same directory. "
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{

Cell["LoadNETAssembly[\"c:\\\\AxMSACAL.dll\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"nlug:3.6.6"],

Cell[BoxData[
    \(NETAssembly["AxMSACAL", 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"nlug:3.6.6"]
}, Open  ]],

Cell[TextData[{
  "Now create an instance of the ",
  StyleBox["AxCalendar", "MR"],
  " wrapper class. This class has all the methods and properties of the \
Calendar COM object, and it also inherits from the ",
  StyleBox["System.Windows.Forms.Control", "MR"],
  " class, so it can be used like any other .NET control."
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{

Cell["cal = NETNew[\"AxMSACAL.AxCalendar\"]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"nlug:3.6.6"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "AxMSACAL.AxCalendar"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$83886081]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"nlug:3.6.6"]
}, Open  ]],

Cell[TextData[{
  "Now create a .NET form to host the control and display it. The ",
  StyleBox["DoNETModal", "MR"],
  " function at the end will display the form and return the calendar\
\[CloseCurlyQuote]s ",
  StyleBox["Value", "MR"],
  " property when the form is closed. This property will hold the date the \
user selected."
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{

Cell["\<\
form = NETNew[\"System.Windows.Forms.Form\"];
cal@Parent = form;
LoadNETType[\"System.Windows.Forms.DockStyle\"];
cal@Dock = DockStyle`Fill;
calDate = DoNETModal[form, cal@Value]\
\>", "Input",
  CellLabel->"In[3]:=",
  CellTags->"nlug:3.6.6"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]NETObject[
          "System.DateTime"] \[RightGuillemet]\),
      NETLink`Objects`NETObject$70880026211385345]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"nlug:3.6.6"]
}, Open  ]],

Cell[TextData[{
  "The .NET runtime has conveniently mapped the result of the ",
  StyleBox["Value", "MR"],
  " property to a ",
  StyleBox["DateTime", "MR"],
  " object. This is easily manipulated to get the selected date as a string."
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{

Cell["calDate@ToString[]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"nlug:3.6.6"],

Cell[BoxData[
    \("9/6/2003 12:00:00 AM"\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"nlug:3.6.6"]
}, Open  ]],

Cell[TextData[{
  "Now clean up by releasing the calendar object. Note that you do not call \
",
  StyleBox["ReleaseCOMObject", "MR"],
  " on the ",
  StyleBox["AxCalendar", "MR"],
  " object, because it is not a COM object\[LongDash]it is a pure .NET class \
that merely holds a reference to a COM object. The actual COM object is of \
class ",
  StyleBox["MSACAL.CalendarClass", "MR"],
  ", but you never directly create an instance of that class, just the ",
  StyleBox["AxCalendar", "MR"],
  " wrapper."
}], "Text",
  CellTags->"nlug:3.6.6"],

Cell["ReleaseNETObject[cal]", "Input",
  CellLabel->"In[9]:=",
  CellTags->"nlug:3.6.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example Files", "Subsection",
  CellTags->"nlug:3.6.7"],

Cell[TextData[{
  "The following example program included with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " demonstrates calling COM components from ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"nlug:3.6.7"],

Cell[TextData[ButtonBox["ExcelPieChart.nb",
  ButtonFunction:>(NotebookOpen[ 
      ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part1", 
        "Calling COM"}, #]]&),
  ButtonEvaluator->Automatic,
  ButtonStyle->"Hyperlink"]], "Input",
  CellTags->"nlug:3.6.7"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Part 2.  Calling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from .NET"
}], "Chapter"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"nlug:4.0"],

Cell[TextData[{
  "The first part of this User Guide describes using ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " to allow you to call from ",
  StyleBox["Mathematica", "TI"],
  " into .NET, thereby extending the ",
  StyleBox["Mathematica", "TI"],
  " environment to include the functionality in all existing and future .NET \
classes. This part shows you how to use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " in the opposite direction, as a means to write .NET programs that use the \
",
  StyleBox["Mathematica", "TI"],
  " kernel as a computational engine."
}], "Text",
  CellTags->"nlug:4.0"],

Cell[TextData[{
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " uses ",
  StyleBox["MathLink", "TI"],
  ", Wolfram Research\[CloseCurlyQuote]s protocol for sending data and \
commands between programs. Many of the concepts and techniques in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " programming are the same as those for programming with the ",
  StyleBox["MathLink", "TI"],
  " C-language API. The ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " documentation is not intended to be an encyclopedic compendium of \
everything you need to know to write .NET programs that use ",
  StyleBox["MathLink", "TI"],
  ". Programmers may have to rely a little on the general documentation of ",
  StyleBox["MathLink", "TI"],
  " programming in ",
  StyleBox["The ",
    FontSlant->"Italic"],
  StyleBox["Mathematica", "TI"],
  StyleBox[" Book",
    FontSlant->"Italic"],
  ". They should also consult the ",
  StyleBox["MathLink", "TI"],
  " Tutorial, available on MathSource (",
  ButtonBox["http://www.mathsource.com/Content/Enhancements/MathLink/0206-\
693",
    ButtonData:>{
      URL[ 
      "http://www.mathsource.com/Content/Enhancements/MathLink/0206-693"], 
      None},
    ButtonStyle->"Hyperlink"],
  "), although some sections of that document (such as about graphics) are \
out of date. The Tutorial is divided into two major sections along the same \
lines as this User Guide. You will want to read the second part. Many of the \
functions ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " provides have C-language counterparts that are identical or nearly so."
}], "Text",
  CellTags->"nlug:4.0"],

Cell[TextData[{
  "If you have not read Part 1, \[OpenCurlyDoubleQuote]Calling .NET from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ",\[CloseCurlyDoubleQuote] you should at least skim it at some point. Your \
.NET \[OpenCurlyDoubleQuote]front end\[CloseCurlyDoubleQuote] can use the \
same techniques for calling .NET methods from ",
  StyleBox["Mathematica", "TI"],
  " code and passing .NET objects as arguments that programmers use when \
running the kernel from the notebook front end. This allows you to have a \
very high-level interface between .NET and ",
  StyleBox["Mathematica", "TI"],
  ". When you are writing ",
  StyleBox["MathLink", "TI"],
  " programs in C, you have to think about passing and returning simple \
things like strings and integers. With ",
  StyleBox[".NET",
    FontSlant->"Italic"],
  StyleBox["/Link",
    FontSlant->"Italic"],
  " you can pass .NET objects back and forth between .NET and ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->"nlug:4.0"],

Cell[TextData[{
  "The sections below merely provide an overview of topics in ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " programming. The main class-by-class reference for ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is the ",
  ButtonBox["API help file",
    ButtonEvaluator->Automatic,
    ButtonData:>{
      URL[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Documentation"}, 
          ".netlink api.chm"]], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "You should also look at the ",
  ButtonBox["example programs",
    ButtonEvaluator->Automatic,
    ButtonData:>{
      URL[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", 
          "Part2"}]], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"nlug:4.0"],

Cell[TextData[{
  "When you are reading this text, or programming in .NET or ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", remember that the entire source code for ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " is provided. If you want to see how anything works (or why it doesn\
\[CloseCurlyQuote]t), you can always consult the source code directly."
}], "Text",
  CellTags->"nlug:4.0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "What Is ",
  StyleBox["MathLink", "SBO"],
  "?"
}], "Section",
  CellTags->"nlug:4.1"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " is a platform-independent protocol for communicating between programs. In \
more concrete terms, it is a means to send and receive ",
  StyleBox["Mathematica", "TI"],
  " expressions. ",
  StyleBox["MathLink", "TI"],
  " is the means by which the notebook front end and kernel communicate with \
each other. It is also used by a large number of commercial and freeware \
applications and utilities that link ",
  StyleBox["Mathematica", "TI"],
  " and other programs or languages. It is implemented as a library of \
C-language functions. ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " brings the capabilities of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " into .NET in a way that is simpler to use and much more powerful than the \
raw C-level API."
}], "Text",
  CellTags->"nlug:4.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Overview of the Main ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " Interfaces and Classes"
}], "Section"],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->"nlug:4.2.0"],

Cell[TextData[{
  "The ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " class library is written in an object-oriented style intended to maximize \
its extensibility in the future without requiring users\[CloseCurlyQuote] \
code to change. This requires a clean separation between interface and \
implementation. This is accomplished by exposing the main link functionality \
through interfaces, not classes. The names of the concrete classes that \
implement these interfaces will hardly be mentioned because programmers do \
not need to know or care what they are. Rather, you will use objects that \
belong to one of the interface types. You do not need to know what the actual \
classes are because you will never create an instance directly; instead, you \
use a \[OpenCurlyDoubleQuote]factory method\[CloseCurlyDoubleQuote] to create \
an instance of a link class. This will become clear further on."
}], "Text",
  CellTags->"nlug:4.2.0"],

Cell[TextData[{
  "This section gives a brief overview of the main interfaces and classes. \
They will be discussed in more detail later. In addition, there is full \
documentation for the class library in the ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " ",
  ButtonBox["API help file",
    ButtonEvaluator->Automatic,
    ButtonData:>{
      URL[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Documentation"}, 
          ".netlink api.chm"]], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[".",
    FontSlant->"Italic"],
  " Most of these classes and interfaces are in the ",
  StyleBox["Wolfram.NETLink", "MR"],
  " namespace; others are in ",
  StyleBox["Wolfram.NETLink.UI", "MR"],
  "."
}], "Text",
  CellTags->"nlug:4.2.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["IMathLink and IKernelLink", "Subsection",
  CellTags->"nlug:4.2.1"],

Cell[TextData[{
  "The two most important link interfaces you need to know about are ",
  StyleBox["IMathLink", "MR"],
  " and ",
  StyleBox["IKernelLink", "MR"],
  ". The ",
  StyleBox["IMathLink", "MR"],
  " interface is essentially a port of the ",
  StyleBox["MathLink", "TI"],
  " C API into .NET. Most of the method names will be familiar to experienced \
",
  StyleBox["MathLink", "TI"],
  " programmers. ",
  StyleBox["IKernelLink", "MR"],
  " extends ",
  StyleBox["IMathLink", "MR"],
  " and adds some important high-level convenience methods that are only \
meaningful if the other side of the link is a ",
  StyleBox["Mathematica", "TI"],
  " kernel (for example, the method ",
  StyleBox["WaitForAnswer()", "MR"],
  ", which assumes the other side of the link will respond with a defined \
series of packets)."
}], "Text",
  CellTags->"nlug:4.2.1"],

Cell[TextData[{
  "The basic idea is that the ",
  StyleBox["IMathLink", "MR"],
  " interface encompasses all the operations that can be performed on a link \
without making any assumptions about what program is on the other side of the \
link. ",
  StyleBox["IKernelLink", "MR"],
  " adds the assumption that the other side is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel."
}], "Text",
  CellTags->"nlug:4.2.1"],

Cell[TextData[{
  StyleBox["IKernelLink", "MR"],
  " is the most important interface, as most programmers will work \
exclusively with ",
  StyleBox["IKernelLinks", "MR"],
  ". Of course, since ",
  StyleBox["IKernelLink", "MR"],
  " extends ",
  StyleBox["IMathLink", "MR"],
  ", many of the methods you will use on your ",
  StyleBox["IKernelLink", "MR"],
  " objects are declared and documented in the ",
  StyleBox["IMathLink", "MR"],
  " interface."
}], "Text",
  CellTags->"nlug:4.2.1"],

Cell[TextData[{
  "The most important class that implements ",
  StyleBox["IMathLink", "MR"],
  " is ",
  StyleBox["NativeLink", "MR"],
  ", so named because it calls directly into Wolfram Research\
\[CloseCurlyQuote]s ",
  StyleBox["MathLink", "TI"],
  " library. In the future, other classes could be added that do not rely on \
native methods\[LongDash]for example, one that uses .NET remoting to \
communicate across a network. As discussed above, programmers do not need to \
be concerned about what these classes are, because they will never type a \
link class name in their code."
}], "Text",
  CellTags->"nlug:4.2.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["MathLinkFactory", "Subsection",
  CellTags->"nlug:4.2.2"],

Cell[TextData[{
  StyleBox["MathLinkFactory", "MR"],
  " is the class that you use to create link objects. It contains the static \
methods ",
  StyleBox["CreateMathLink()", "MR"],
  ", ",
  StyleBox["CreateKernelLink()", "MR"],
  ", and ",
  StyleBox["CreateLoopbackLink()", "MR"],
  ", which take various argument sequences. These are the equivalents of \
calling ",
  StyleBox["MLOpen", "MR"],
  " in a C program."
}], "Text",
  CellTags->"nlug:4.2.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["MathLinkException", "Subsection",
  CellTags->"nlug:4.2.3"],

Cell[TextData[{
  StyleBox["MathLinkException", "MR"],
  " is the exception class that is thrown by many of the methods in ",
  StyleBox["IMathLink", "MR"],
  " and ",
  StyleBox["IKernelLink", "MR"],
  ". The ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " API uses exceptions to indicate errors, rather than function return \
values like the ",
  StyleBox["MathLink", "TI"],
  " C API. In C, you write code that checks the return values like this:"
}], "Text",
  CellTags->"nlug:4.2.3"],

Cell["\<\
\t// C code
\tif (!MLPutInteger(link, 42)) {
\t\t// was error; print message and clean up.
\t}\
\>", "Program",
  CellTags->"nlug:4.2.3"],

Cell[TextData[{
  "In ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", you can wrap ",
  StyleBox["MathLink", "TI"],
  " calls in a ",
  StyleBox["try", "MR"],
  " block and catch ",
  StyleBox["MathLinkException", "MR"],
  "."
}], "Text",
  CellTags->"nlug:4.2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Expr", "Subsection",
  CellTags->"nlug:4.2.4"],

Cell[TextData[{
  "The ",
  StyleBox["Expr", "MR"],
  " class provides a direct representation of ",
  StyleBox["Mathematica", "TI"],
  " expressions in .NET. ",
  StyleBox["Expr", "MR"],
  " has a number of methods that provide information about the structure of \
the expression and that let you extract components. These methods have names \
and behaviors that will be familiar to ",
  StyleBox["Mathematica", "TI"],
  " programmers\[LongDash]for example, ",
  StyleBox["Length()", "MR"],
  ", ",
  StyleBox["Part()", "MR"],
  ", ",
  StyleBox["NumberQ()", "MR"],
  ", ",
  StyleBox["VectorQ()", "MR"],
  ", ",
  StyleBox["Take()", "MR"],
  ", ",
  StyleBox["Delete()", "MR"],
  ", and so on. When reading from a link, instead of using the low-level ",
  StyleBox["IMathLink", "MR"],
  " interface methods for discovering the structure and properties of the \
incoming expression, you can just read an entire expression from the link \
using ",
  StyleBox["GetExpr()", "MR"],
  ", and then use ",
  StyleBox["Expr", "MR"],
  " methods to inspect it or decompose it. For writing to a link, ",
  StyleBox["Exprs", "MR"],
  " can be used as arguments to some of the most important ",
  StyleBox["IKernelLink", "MR"],
  " methods."
}], "Text",
  CellTags->"nlug:4.2.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["MathKernel", "Subsection",
  CellTags->"nlug:4.2.5"],

Cell[TextData[{
  StyleBox["MathKernel", "MR"],
  " is a non-visual component that provides a very high-level interface for \
interacting with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". It is especially intended for use in visual programming environments, as \
it is highly configurable via properties. For many types of .NET programs \
that use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for computations, the ",
  StyleBox["IKernelLink", "MR"],
  " interface provides ideal functionality. For some types of programs, \
however, programmers might find the ",
  StyleBox["MathKernel", "MR"],
  " object even easier to use. This is especially true for programs that want \
to capture not just the result of a computation, but also messages, ",
  StyleBox["Print", "MR"],
  " output, or graphics generated as side effects of the computation. "
}], "Text",
  CellTags->"nlug:4.2.5"]
}, Closed]],

Cell[CellGroupData[{

Cell["MathPictureBox", "Subsection",
  CellTags->"nlug:4.2.6"],

Cell[TextData[{
  "The ",
  StyleBox["MathPictureBox", "MR"],
  " class provides an easy way to display ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics and typeset expressions. This class is often used from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code, but it is just as useful in .NET programs."
}], "Text",
  CellTags->"nlug:4.2.6"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Sample Program", "Section",
  CellTags->"nlug:4.3"],

Cell[TextData[{
  "The ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " distribution includes a ",
  ButtonBox["SimpleLink",
    ButtonEvaluator->Automatic,
    ButtonData:>{
      URL[ 
        ToFileName[ {$TopDirectory, "AddOns", "NETLink", "Examples", "Part2", 
          "SimpleLink"}]], None},
    ButtonStyle->"Hyperlink"],
  " sample program that demonstrates simple techniques for launching ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and performing computations. The code is available in both C# and Visual \
Basic .NET."
}], "Text",
  CellTags->"nlug:4.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Building and Deploying Programs", "Section"],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " Assembly"
}], "Subsection",
  CellTags->"nlug:4.4.0"],

Cell[TextData[{
  "The ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " assembly file is ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  ", and it is found in the ",
  StyleBox["<", "MR"],
  StyleBox["Mathematica", "MR",
    FontSlant->"Italic"],
  StyleBox[" dir>\\AddOns\\Applications\\NETLink", "MR"],
  " directory. When you compile .NET programs that use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  ", you will need to add a reference to this file. In previous versions of \
",
  StyleBox[".NET/Lin",
    FontSlant->"Italic"],
  "k, this assembly was placed into the .NET global assembly cache (GAC) by \
the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer. Starting with ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " 1.2, however, the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " assembly is no longer strong-named and therefore cannot be placed into \
the GAC. .NET programs that use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " will therefore need to have a copy of this assembly in their application \
directory (that is, right next to their ",
  StyleBox[".exe", "MR"],
  " file). Alternatively, the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " assembly can be located in a subdirectory of the application\
\[CloseCurlyQuote]s directory, according to the standard rules for how .NET \
probes for assemblies that are not strong-named."
}], "Text",
  CellTags->"nlug:4.4.0"],

Cell[TextData[{
  "A consequence of the fact that ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " is not strong-named is that you can replace your application\
\[CloseCurlyQuote]s copy with an updated version, and the updated version \
will be used without requiring the application to be recompiled. In contrast, \
strong-named assemblies in .NET are strictly versioned, so that when a \
program is compiled against a specific version of the assembly, the program \
can only run with that precise version. Of course, this strict versioning is \
touted as a benefit of .NET, and it is advantageous in certain circumstances, \
but for various technical reasons it is not desirable for ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " to be strong-named."
}], "Text",
  CellTags->"nlug:4.4.0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Compiling from the Command Line", "Subsection",
  CellTags->"nlug:4.4.1"],

Cell["\<\
The .NET Framework SDK includes command-line compilers for several .NET \
languages, including C# and Visual Basic .NET. You can use these free tools \
without purchasing Visual Studio .NET, and you might want to use them to \
build simple programs even if you do have Visual Studio .NET.\
\>", "Text",
  CellTags->"nlug:4.4.1"],

Cell[TextData[{
  "The command-line compilers rely on several DOS environment variables being \
set correctly, so the .NET Framework SDK comes with a batch file named ",
  StyleBox["sdkvars.bat", "MR"],
  " that you can run in your DOS session to set these variables. If you own \
Visual Studio .NET and want to use any command-line tools, use the ",
  StyleBox["Microsoft Visual Studio .NET/Visual Studio .NET Tools/Visual \
Studio .NET Command Promp", "SR"],
  "t item on the Windows ",
  StyleBox["Start", "SR"],
  " menu to launch a DOS session with all the required settings."
}], "Text",
  CellTags->"nlug:4.4.1"],

Cell[TextData[{
  "It is convenient to place a copy of ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " into your build directory before you compile, as you would otherwise need \
to include the full path to this assembly on the compiler command line, and \
you will need a copy of it to be present in the program\[CloseCurlyQuote]s \
directory anyway. The examples below assume that you have copied (not moved!) \
the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " file from ",
  StyleBox["<", "MR"],
  StyleBox["Mathematica", "MR",
    FontSlant->"Italic"],
  StyleBox[" dir>\\AddOns\\Applications\\NETLink", "MR"],
  " into the directory in which you are performing the build. Here is a \
sample command for a C# program:"
}], "Text",
  CellTags->"nlug:4.4.1"],

Cell["\<\
csc /target:winexe /reference:Wolfram.NETLink.dll MyProgram.cs\
\>", "Program",
  CellTags->"nlug:4.4.1"],

Cell["Here is a comparable example for Visual Basic .NET:", "Text",
  CellTags->"nlug:4.4.1"],

Cell["\<\
vbc /target:winexe /reference:Wolfram.NETLink.dll MyProgram.vb\
\>", "Program",
  CellTags->"nlug:4.4.1"],

Cell[TextData[{
  "Either of the above commands will result in the creation of a ",
  StyleBox["MyProgram.exe", "MR"],
  " file in the current directory. This program will need to have a copy of \
",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " alongside it to run."
}], "Text",
  CellTags->"nlug:4.4.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Visual Studio .NET", "Subsection",
  CellTags->"nlug:4.4.2"],

Cell[TextData[{
  "Programs that use ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " need to have a reference to the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " assembly in their project settings. You add a reference to an assembly by \
selecting ",
  StyleBox["Add ", "SR"],
  StyleBox["Reference", "SR"],
  " from the ",
  StyleBox["Project", "SR"],
  " menu. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer makes the necessary settings so that the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " assembly shows up in the ",
  StyleBox["Add Reference", "SR"],
  " dialog box. It will be listed as ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " 1.2 in the ",
  StyleBox[".NET", "SR"],
  " tab. If for some reason it does not show up there, you can simply use the \
",
  StyleBox["Browse", "SR"],
  " button to locate the file manually (it will be in the ",
  StyleBox["<", "MR"],
  StyleBox["Mathematica", "MR",
    FontSlant->"Italic"],
  StyleBox[" dir>\\AddOns\\Applications\\NETLink", "MR"],
  " directory, or perhaps in another more convenient locaation if you put a \
copy elsewhere)."
}], "Text",
  CellTags->"nlug:4.4.2"],

Cell[TextData[{
  "When Visual Studio .NET builds your program it will automatically place a \
copy of ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " in the output directory, alongside your ",
  StyleBox[".exe", "MR"],
  " file. Your program will require a copy of ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " alongside it to run, so if you deploy your program to another location or \
distribute it to other users, you must keep the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " file with it."
}], "Text",
  CellTags->"nlug:4.4.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Deploying Programs", "Subsection",
  CellTags->"nlug:4.4.3"],

Cell[TextData[{
  "If you build a .NET program that uses ",
  StyleBox[".NET/Link",
    FontSlant->"Italic"],
  " and want to distribute it to others, you will need to include a copy of \
the ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " assembly alongside your application\[CloseCurlyQuote]s ",
  StyleBox[".exe", "MR"],
  " file. Alternatively, you can put ",
  StyleBox["Wolfram.NETLink.dll", "MR"],
  " in a subdirectory of the application\[CloseCurlyQuote]s directory, \
according to the standard rules for how .NET probes for assemblies that are \
not strong-named."
}], "Text",
  CellTags->"nlug:4.4.3"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
ScreenStyleEnvironment->"AllBrackets",
WindowToolbars->"RulerBar",
WindowSize->{832, 843},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrintingOptions->{"PrintingMargins"->{{72, 72}, {72, 64}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->True,
"PrintMultipleHorizontalPages"->False},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  ".NET/Link"->{
    Cell[2329, 79, 110, 2, 56, "Section",
      CellTags->{".NET/Link", "nlug:1.0"}]},
  "nlug:1.0"->{
    Cell[2329, 79, 110, 2, 56, "Section",
      CellTags->{".NET/Link", "nlug:1.0"}],
    Cell[2442, 83, 1071, 31, 93, "Text",
      CellTags->"nlug:1.0"],
    Cell[3516, 116, 816, 20, 76, "Text",
      CellTags->"nlug:1.0"],
    Cell[4335, 138, 356, 8, 42, "Text",
      CellTags->"nlug:1.0"],
    Cell[4694, 148, 739, 21, 76, "Text",
      CellTags->"nlug:1.0"],
    Cell[5436, 171, 392, 10, 42, "Text",
      CellTags->"nlug:1.0"],
    Cell[5831, 183, 627, 15, 76, "Text",
      CellTags->"nlug:1.0"],
    Cell[6461, 200, 340, 12, 42, "Text",
      CellTags->"nlug:1.0"]},
  "nlug:1.1"->{
    Cell[6838, 217, 56, 1, 42, "Section",
      CellTags->"nlug:1.1"],
    Cell[6897, 220, 519, 9, 76, "Text",
      CellTags->"nlug:1.1"],
    Cell[7419, 231, 201, 4, 42, "Text",
      CellTags->"nlug:1.1"],
    Cell[7623, 237, 885, 13, 110, "Text",
      CellTags->"nlug:1.1"],
    Cell[8511, 252, 262, 5, 42, "Text",
      CellTags->"nlug:1.1"]},
  "nlug:1.2"->{
    Cell[8810, 262, 123, 6, 42, "Section",
      CellTags->"nlug:1.2"],
    Cell[8936, 270, 1183, 36, 93, "Text",
      CellTags->"nlug:1.2"]},
  "nlug:1.3"->{
    Cell[10156, 311, 190, 9, 42, "Section",
      CellTags->"nlug:1.3"],
    Cell[10349, 322, 1790, 56, 127, "Text",
      CellTags->"nlug:1.3"],
    Cell[12142, 380, 279, 9, 25, "Text",
      CellTags->"nlug:1.3"]},
  "nlug:2"->{
    Cell[12470, 395, 53, 1, 87, "Chapter",
      CellTags->"nlug:2"],
    Cell[12548, 400, 105, 2, 35, "Subsubsection",
      CellTags->"nlug:2"],
    Cell[12656, 404, 563, 19, 43, "Text",
      CellTags->"nlug:2"],
    Cell[13222, 425, 531, 19, 43, "Text",
      CellTags->"nlug:2"],
    Cell[13756, 446, 895, 33, 59, "Text",
      CellTags->"nlug:2"],
    Cell[14654, 481, 492, 15, 42, "Text",
      CellTags->"nlug:2"],
    Cell[15183, 501, 69, 1, 35, "Subsubsection",
      CellTags->"nlug:2"],
    Cell[15255, 504, 564, 14, 59, "Text",
      CellTags->"nlug:2"]},
  "nlug:3.0"->{
    Cell[16090, 535, 55, 1, 56, "Section",
      CellTags->"nlug:3.0"],
    Cell[16148, 538, 801, 21, 76, "Text",
      CellTags->"nlug:3.0"],
    Cell[16952, 561, 660, 18, 59, "Text",
      CellTags->"nlug:3.0"],
    Cell[17615, 581, 687, 15, 76, "Text",
      CellTags->"nlug:3.0"],
    Cell[18305, 598, 567, 14, 59, "Text",
      CellTags->"nlug:3.0"],
    Cell[18875, 614, 590, 17, 59, "Text",
      CellTags->"nlug:3.0"],
    Cell[19468, 633, 98, 2, 25, "Text",
      CellTags->"nlug:3.0"],
    Cell[19569, 637, 265, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[19837, 645, 95, 2, 25, "Text",
      CellTags->"nlug:3.0"],
    Cell[19935, 649, 285, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[20223, 657, 286, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[20512, 665, 294, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[20809, 673, 288, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[21100, 681, 303, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[21406, 689, 95, 2, 25, "Text",
      CellTags->"nlug:3.0"],
    Cell[21504, 693, 282, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[21789, 701, 277, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[22069, 709, 276, 6, 31, "Input",
      CellTags->"nlug:3.0"],
    Cell[22348, 717, 102, 2, 25, "Text",
      CellTags->"nlug:3.0"],
    Cell[22453, 721, 278, 6, 31, "Input",
      CellTags->"nlug:3.0"]},
  "nlug:3.1.0"->{
    Cell[22885, 740, 76, 1, 39, "Subsection",
      CellTags->"nlug:3.1.0"],
    Cell[22964, 743, 217, 9, 25, "Text",
      CellTags->"nlug:3.1.0"],
    Cell[23184, 754, 86, 2, 31, "Input",
      CellTags->"nlug:3.1.0"]},
  "nlug:3.1.1"->{
    Cell[23307, 761, 74, 1, 39, "Subsection",
      CellTags->"nlug:3.1.1"],
    Cell[23384, 764, 145, 5, 25, "Text",
      CellTags->"nlug:3.1.1"],
    Cell[23532, 771, 80, 2, 31, "Input",
      CellTags->"nlug:3.1.1"],
    Cell[23615, 775, 801, 19, 76, "Text",
      CellTags->"nlug:3.1.1"],
    Cell[24419, 796, 863, 23, 96, "DefinitionBox",
      CellTags->"nlug:3.1.1"],
    Cell[25285, 821, 72, 1, 17, "Caption",
      CellTags->"nlug:3.1.1"]},
  "Loading .NET Assemblies and Types"->{
    Cell[25394, 827, 120, 1, 39, "Subsection",
      CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"}]},
  "nlug:3.1.2"->{
    Cell[25394, 827, 120, 1, 39, "Subsection",
      CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"}],
    Cell[25539, 832, 95, 1, 35, "Subsubsection",
      CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"}],
    Cell[25637, 835, 1014, 18, 110, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[26654, 855, 769, 14, 93, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[27426, 871, 1196, 25, 127, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[28625, 898, 1069, 30, 93, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[29731, 933, 61, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.2"],
    Cell[29795, 936, 463, 10, 59, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[30261, 948, 642, 18, 59, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[30940, 971, 66, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.2"],
    Cell[31009, 974, 657, 18, 59, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[31669, 994, 3441, 113, 202, "DefinitionBox",
      CellTags->"nlug:3.1.2"],
    Cell[35113, 1109, 64, 1, 17, "Caption",
      CellTags->"nlug:3.1.2"],
    Cell[35180, 1112, 185, 5, 25, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[35390, 1121, 98, 2, 31, "Input",
      CellTags->"nlug:3.1.2"],
    Cell[35491, 1125, 112, 3, 27, "Output",
      CellTags->"nlug:3.1.2"],
    Cell[35618, 1131, 422, 12, 42, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[36043, 1145, 611, 15, 59, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[36679, 1164, 178, 5, 31, "Input",
      CellTags->"nlug:3.1.2"],
    Cell[36860, 1171, 112, 3, 27, "Output",
      CellTags->"nlug:3.1.2"],
    Cell[36987, 1177, 178, 4, 25, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[37168, 1183, 493, 14, 59, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[37664, 1199, 115, 2, 31, "Input",
      CellTags->"nlug:3.1.2"],
    Cell[37782, 1203, 151, 4, 25, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[37936, 1209, 1300, 39, 111, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[39239, 1250, 95, 1, 31, "Input",
      CellTags->"nlug:3.1.2"],
    Cell[39337, 1253, 260, 5, 42, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[39634, 1263, 62, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.2"],
    Cell[39699, 1266, 997, 26, 93, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[40699, 1294, 2761, 88, 148, "DefinitionBox",
      CellTags->"nlug:3.1.2"],
    Cell[43463, 1384, 59, 1, 17, "Caption",
      CellTags->"nlug:3.1.2"],
    Cell[43525, 1387, 126, 5, 25, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[43676, 1396, 109, 2, 31, "Input",
      CellTags->"nlug:3.1.2"],
    Cell[43788, 1400, 123, 3, 27, "Output",
      CellTags->"nlug:3.1.2"],
    Cell[43926, 1406, 403, 12, 42, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[44332, 1420, 621, 15, 76, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[44990, 1440, 86, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.2"],
    Cell[45079, 1443, 371, 10, 42, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[45453, 1455, 554, 18, 60, "DefinitionBox",
      CellTags->"nlug:3.1.2"],
    Cell[46010, 1475, 81, 1, 17, "Caption",
      CellTags->"nlug:3.1.2"],
    Cell[46128, 1481, 97, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.2"],
    Cell[46228, 1484, 1223, 26, 127, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[47454, 1512, 1628, 38, 144, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[49085, 1552, 1339, 33, 110, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[50427, 1587, 578, 11, 59, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[51008, 1600, 133, 5, 65, "Program",
      CellTags->"nlug:3.1.2"],
    Cell[51144, 1607, 338, 11, 42, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[51485, 1620, 283, 8, 42, "Text",
      CellTags->"nlug:3.1.2"],
    Cell[51771, 1630, 738, 21, 86, "DefinitionBox",
      CellTags->"nlug:3.1.2"],
    Cell[52512, 1653, 113, 5, 17, "Caption",
      CellTags->"nlug:3.1.2"]},
  "Loading .NET Assemblies"->{
    Cell[25539, 832, 95, 1, 35, "Subsubsection",
      CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"}]},
  "Conversion of Types Between .NET and Mathematica"->{
    Cell[52674, 1664, 217, 7, 39, "Subsection",
      CellTags->{
      "Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"}]},
  "nlug:3.1.3"->{
    Cell[52674, 1664, 217, 7, 39, "Subsection",
      CellTags->{
      "Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"}],
    Cell[52894, 1673, 1101, 29, 93, "Text",
      CellTags->"nlug:3.1.3"],
    Cell[53998, 1704, 463, 13, 42, "Text",
      CellTags->"nlug:3.1.3"],
    Cell[54464, 1719, 1029, 27, 314, "DefinitionBox",
      CellTags->"nlug:3.1.3"],
    Cell[55496, 1748, 174, 6, 17, "Caption",
      CellTags->"nlug:3.1.3"],
    Cell[55673, 1756, 562, 16, 59, "Text",
      CellTags->"nlug:3.1.3"]},
  "nlug:3.1.4"->{
    Cell[56272, 1777, 64, 1, 39, "Subsection",
      CellTags->"nlug:3.1.4"],
    Cell[56339, 1780, 576, 13, 59, "Text",
      CellTags->"nlug:3.1.4"],
    Cell[56918, 1795, 1739, 56, 70, "DefinitionBox",
      CellTags->"nlug:3.1.4"],
    Cell[58660, 1853, 71, 1, 17, "Caption",
      CellTags->"nlug:3.1.4"],
    Cell[58734, 1856, 127, 5, 25, "Text",
      CellTags->"nlug:3.1.4"],
    Cell[58886, 1865, 129, 3, 29, "Input",
      CellTags->"nlug:3.1.4"],
    Cell[59018, 1870, 229, 5, 27, "Output",
      CellTags->"nlug:3.1.4"],
    Cell[59262, 1878, 860, 21, 93, "Text",
      CellTags->"nlug:3.1.4"],
    Cell[60125, 1901, 867, 20, 93, "Text",
      CellTags->"nlug:3.1.4"],
    Cell[60995, 1923, 402, 9, 42, "Text",
      CellTags->"nlug:3.1.4"],
    Cell[61400, 1934, 190, 4, 49, "Input",
      CellTags->"nlug:3.1.4"],
    Cell[61593, 1940, 457, 12, 42, "Text",
      CellTags->"nlug:3.1.4"]},
  "nlug:3.1.5"->{
    Cell[62087, 1957, 87, 1, 39, "Subsection",
      CellTags->"nlug:3.1.5"],
    Cell[62199, 1962, 57, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.5"],
    Cell[62259, 1965, 755, 15, 76, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[63017, 1982, 613, 13, 59, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[63633, 1997, 2563, 70, 454, "DefinitionBox",
      CellTags->"nlug:3.1.5"],
    Cell[66199, 2069, 126, 5, 17, "Caption",
      CellTags->"nlug:3.1.5"],
    Cell[66328, 2076, 636, 18, 59, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[66967, 2096, 181, 4, 69, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.1.5"],
    Cell[67151, 2102, 231, 6, 25, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[67385, 2110, 383, 10, 42, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[67771, 2122, 1177, 31, 110, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[68973, 2157, 122, 3, 29, "Input",
      CellTags->"nlug:3.1.5"],
    Cell[69098, 2162, 216, 5, 27, "Output",
      CellTags->"nlug:3.1.5"],
    Cell[69329, 2170, 457, 16, 42, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[69789, 2188, 108, 3, 29, "Input",
      CellTags->"nlug:3.1.5"],
    Cell[69900, 2193, 201, 7, 25, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[70104, 2202, 116, 4, 29, "Input",
      CellTags->"nlug:3.1.5"],
    Cell[70223, 2208, 1140, 30, 93, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[71366, 2240, 693, 13, 76, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[72062, 2255, 153, 4, 49, "Input",
      CellTags->"nlug:3.1.5"],
    Cell[72218, 2261, 749, 17, 76, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[72970, 2280, 108, 3, 29, "Input",
      CellTags->"nlug:3.1.5"],
    Cell[73115, 2288, 76, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.5"],
    Cell[73194, 2291, 644, 13, 76, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[73841, 2306, 176, 4, 49, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.1.5"],
    Cell[74020, 2312, 186, 4, 25, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[74209, 2318, 109, 3, 29, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.1.5"],
    Cell[74321, 2323, 231, 6, 25, "Text",
      CellTags->"nlug:3.1.5"],
    Cell[74555, 2331, 122, 4, 29, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.1.5"]},
  "nlug:3.1.6"->{
    Cell[74726, 2341, 91, 1, 39, "Subsection",
      CellTags->"nlug:3.1.6"],
    Cell[74842, 2346, 62, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.6"],
    Cell[74907, 2349, 353, 9, 42, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[75263, 2360, 3139, 106, 182, "DefinitionBox",
      CellTags->"nlug:3.1.6"],
    Cell[78405, 2468, 89, 1, 17, "Caption",
      CellTags->"nlug:3.1.6"],
    Cell[78497, 2471, 145, 4, 25, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[78645, 2477, 149, 5, 25, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[78797, 2484, 86, 1, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[78886, 2487, 552, 18, 59, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[79441, 2507, 125, 3, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[79569, 2512, 117, 3, 25, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[79689, 2517, 121, 3, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[79813, 2522, 232, 6, 42, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[80048, 2530, 129, 4, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[80180, 2536, 1169, 29, 134, "DefinitionBox3Col",
      CellTags->"nlug:3.1.6"],
    Cell[81352, 2567, 113, 5, 17, "Caption",
      CellTags->"nlug:3.1.6"],
    Cell[81468, 2574, 369, 7, 59, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[81840, 2583, 88, 1, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[81931, 2586, 539, 17, 59, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[82473, 2605, 141, 4, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[82651, 2614, 73, 1, 35, "Subsubsection",
      CellTags->"nlug:3.1.6"],
    Cell[82727, 2617, 2825, 86, 108, "DefinitionBox",
      CellTags->"nlug:3.1.6"],
    Cell[85555, 2705, 86, 1, 17, "Caption",
      CellTags->"nlug:3.1.6"],
    Cell[85644, 2708, 240, 6, 42, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[85887, 2716, 88, 2, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.1.6"],
    Cell[85978, 2720, 1083, 34, 93, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[87086, 2758, 113, 2, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[87202, 2762, 117, 3, 27, "Output",
      CellTags->"nlug:3.1.6"],
    Cell[87356, 2770, 99, 2, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[87458, 2774, 229, 5, 27, "Output",
      CellTags->"nlug:3.1.6"],
    Cell[87702, 2782, 517, 19, 42, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[88222, 2803, 214, 7, 25, "Text",
      CellTags->"nlug:3.1.6"],
    Cell[88461, 2814, 83, 2, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[88547, 2818, 105, 3, 27, "Output",
      CellTags->"nlug:3.1.6"],
    Cell[88689, 2826, 89, 2, 31, "Input",
      CellTags->"nlug:3.1.6"],
    Cell[88781, 2830, 88, 3, 27, "Output",
      CellTags->"nlug:3.1.6"]},
  "nlug:3.2.0"->{
    Cell[89000, 2845, 86, 1, 39, "Subsection",
      CellTags->"nlug:3.2.0"],
    Cell[89111, 2850, 140, 5, 35, "Subsubsection",
      CellTags->"nlug:3.2.0"],
    Cell[89254, 2857, 1061, 27, 93, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[90318, 2886, 1175, 32, 110, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[91496, 2920, 969, 31, 62, "DefinitionBox",
      CellTags->"nlug:3.2.0"],
    Cell[92468, 2953, 122, 5, 17, "Caption",
      CellTags->"nlug:3.2.0"],
    Cell[92593, 2960, 61, 1, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[92679, 2965, 134, 3, 29, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[92816, 2970, 216, 5, 27, "Output",
      CellTags->"nlug:3.2.0"],
    Cell[93047, 2978, 222, 7, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[93272, 2987, 175, 4, 49, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[93450, 2993, 182, 5, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[93635, 3000, 100, 3, 29, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[93738, 3005, 709, 20, 59, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[94472, 3029, 80, 2, 31, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[94555, 3033, 89, 3, 27, "Output",
      CellTags->"nlug:3.2.0"],
    Cell[94659, 3039, 418, 15, 42, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[95102, 3058, 90, 2, 31, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[95195, 3062, 88, 3, 27, "Output",
      CellTags->"nlug:3.2.0"],
    Cell[95298, 3068, 315, 8, 42, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[95638, 3080, 84, 2, 31, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[95725, 3084, 88, 3, 27, "Output",
      CellTags->"nlug:3.2.0"],
    Cell[95828, 3090, 668, 17, 59, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[96521, 3111, 100, 2, 31, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[96624, 3115, 88, 3, 27, "Output",
      CellTags->"nlug:3.2.0"],
    Cell[96727, 3121, 236, 8, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[96966, 3131, 738, 18, 76, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[97741, 3154, 67, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.0"],
    Cell[97811, 3157, 1486, 34, 127, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[99322, 3195, 128, 3, 29, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[99453, 3200, 229, 5, 27, "Output",
      CellTags->"nlug:3.2.0"],
    Cell[99697, 3208, 179, 6, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[99879, 3216, 105, 3, 29, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[99987, 3221, 338, 9, 42, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[100350, 3234, 76, 2, 31, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[100429, 3238, 197, 6, 27, "Output",
      CellTags->"nlug:3.2.0"],
    Cell[100641, 3247, 2357, 66, 178, "DefinitionBox",
      CellTags->"nlug:3.2.0"],
    Cell[103001, 3315, 73, 1, 17, "Caption",
      CellTags->"nlug:3.2.0"],
    Cell[103077, 3318, 452, 11, 59, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[103532, 3331, 607, 16, 59, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[104142, 3349, 173, 4, 49, "Input",
      CellTags->"nlug:3.2.0"],
    Cell[104318, 3355, 450, 15, 42, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[104771, 3372, 531, 11, 59, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[105339, 3388, 59, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.0"],
    Cell[105401, 3391, 419, 9, 59, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[105823, 3402, 1205, 29, 110, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[107031, 3433, 632, 13, 59, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[107666, 3448, 654, 14, 76, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[108323, 3464, 153, 6, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[108479, 3472, 203, 8, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[108685, 3482, 258, 5, 129, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.0"],
    Cell[108946, 3489, 386, 10, 42, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[109335, 3501, 435, 9, 189, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.0"],
    Cell[109773, 3512, 1171, 33, 110, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[110947, 3547, 2483, 88, 60, "DefinitionBox",
      CellTags->"nlug:3.2.0"],
    Cell[113433, 3637, 132, 5, 17, "Caption",
      CellTags->"nlug:3.2.0"],
    Cell[113568, 3644, 197, 5, 25, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[113768, 3651, 382, 14, 231, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.0"],
    Cell[114153, 3667, 1081, 29, 93, "Text",
      CellTags->"nlug:3.2.0"],
    Cell[115271, 3701, 67, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.0"],
    Cell[115341, 3704, 926, 24, 93, "Text",
      CellTags->"nlug:3.2.0"]},
  "Enums"->{
    Cell[116316, 3734, 64, 1, 39, "Subsection",
      CellTags->{"Enums", "nlug:3.2.1"}]},
  "nlug:3.2.1"->{
    Cell[116316, 3734, 64, 1, 39, "Subsection",
      CellTags->{"Enums", "nlug:3.2.1"}],
    Cell[116383, 3737, 860, 19, 93, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[117246, 3758, 584, 16, 59, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[117855, 3778, 118, 2, 31, "Input",
      CellTags->"nlug:3.2.1"],
    Cell[117976, 3782, 132, 3, 27, "Output",
      CellTags->"nlug:3.2.1"],
    Cell[118123, 3788, 118, 3, 25, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[118266, 3795, 84, 2, 31, "Input",
      CellTags->"nlug:3.2.1"],
    Cell[118353, 3799, 237, 5, 27, "Output",
      CellTags->"nlug:3.2.1"],
    Cell[118605, 3807, 403, 10, 42, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[119033, 3821, 107, 2, 31, "Input",
      CellTags->"nlug:3.2.1"],
    Cell[119143, 3825, 86, 3, 27, "Output",
      CellTags->"nlug:3.2.1"],
    Cell[119244, 3831, 69, 1, 25, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[119316, 3834, 98, 2, 31, "Input",
      CellTags->"nlug:3.2.1"],
    Cell[119417, 3838, 288, 6, 42, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[119708, 3846, 83, 2, 31, "Input",
      CellTags->"nlug:3.2.1"],
    Cell[119794, 3850, 435, 12, 59, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[120232, 3864, 114, 4, 48, "Program",
      CellTags->"nlug:3.2.1"],
    Cell[120349, 3870, 401, 12, 42, "Text",
      CellTags->"nlug:3.2.1"],
    Cell[120753, 3884, 180, 5, 31, "Input",
      CellTags->"nlug:3.2.1"]},
  "Out and Ref Parameters"->{
    Cell[120970, 3894, 314, 10, 39, "Subsection",
      CellTags->{"Out and Ref Parameters", "nlug:3.2.2"}]},
  "nlug:3.2.2"->{
    Cell[120970, 3894, 314, 10, 39, "Subsection",
      CellTags->{"Out and Ref Parameters", "nlug:3.2.2"}],
    Cell[121287, 3906, 1210, 31, 110, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[122500, 3939, 190, 7, 25, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[122693, 3948, 232, 8, 99, "Program",
      CellTags->"nlug:3.2.2"],
    Cell[122928, 3958, 863, 23, 76, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[123794, 3983, 560, 15, 59, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[124357, 4000, 151, 4, 25, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[124533, 4008, 150, 7, 91, "Input",
      CellTags->"nlug:3.2.2"],
    Cell[124686, 4017, 87, 3, 27, "Output",
      CellTags->"nlug:3.2.2"],
    Cell[124788, 4023, 225, 6, 25, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[125038, 4033, 71, 2, 31, "Input",
      CellTags->"nlug:3.2.2"],
    Cell[125112, 4037, 86, 3, 27, "Output",
      CellTags->"nlug:3.2.2"],
    Cell[125213, 4043, 207, 6, 25, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[125445, 4053, 123, 5, 51, "Input",
      CellTags->"nlug:3.2.2"],
    Cell[125571, 4060, 193, 5, 20, "Message",
      CellTags->"nlug:3.2.2"],
    Cell[125767, 4067, 92, 3, 27, "Output",
      CellTags->"nlug:3.2.2"],
    Cell[125874, 4073, 594, 15, 59, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[126471, 4090, 399, 11, 42, "Text",
      CellTags->"nlug:3.2.2"],
    Cell[126895, 4105, 101, 2, 31, "Input",
      CellTags->"nlug:3.2.2"],
    Cell[126999, 4109, 87, 3, 27, "Output",
      CellTags->"nlug:3.2.2"]},
  "nlug:3.2.3"->{
    Cell[127135, 4118, 307, 10, 39, "Subsection",
      CellTags->"nlug:3.2.3"],
    Cell[127467, 4132, 72, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.3"],
    Cell[127542, 4135, 1474, 42, 127, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[129019, 4179, 750, 15, 59, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[129772, 4196, 484, 11, 59, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[130259, 4209, 1870, 63, 66, "DefinitionBox",
      CellTags->"nlug:3.2.3"],
    Cell[132132, 4274, 295, 10, 18, "Caption",
      CellTags->"nlug:3.2.3"],
    Cell[132464, 4289, 68, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.3"],
    Cell[132535, 4292, 555, 13, 59, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[133115, 4309, 220, 5, 49, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.3"],
    Cell[133338, 4316, 126, 4, 27, "Output",
      CellTags->"nlug:3.2.3"],
    Cell[133479, 4323, 453, 14, 42, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[133957, 4341, 151, 4, 29, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.3"],
    Cell[134111, 4347, 134, 4, 27, "Output",
      CellTags->"nlug:3.2.3"],
    Cell[134260, 4354, 1142, 27, 110, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[135405, 4383, 282, 7, 42, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[135712, 4394, 159, 4, 29, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.3"],
    Cell[135874, 4400, 221, 5, 27, "Output",
      CellTags->"nlug:3.2.3"],
    Cell[136110, 4408, 144, 5, 25, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[136279, 4417, 177, 5, 29, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.3"],
    Cell[136459, 4424, 134, 4, 27, "Output",
      CellTags->"nlug:3.2.3"],
    Cell[136608, 4431, 505, 13, 59, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[137116, 4446, 848, 18, 76, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[138001, 4469, 72, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.3"],
    Cell[138076, 4472, 486, 11, 59, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[138565, 4485, 944, 24, 93, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[139534, 4513, 128, 3, 29, "Input",
      CellTags->"nlug:3.2.3"],
    Cell[139665, 4518, 224, 5, 27, "Output",
      CellTags->"nlug:3.2.3"],
    Cell[139904, 4526, 164, 6, 25, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[140093, 4536, 91, 2, 31, "Input",
      CellTags->"nlug:3.2.3"],
    Cell[140187, 4540, 89, 3, 27, "Output",
      CellTags->"nlug:3.2.3"],
    Cell[140291, 4546, 325, 10, 42, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[140619, 4558, 854, 22, 76, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[141476, 4582, 75, 1, 25, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[141576, 4587, 119, 2, 31, "Input",
      CellTags->"nlug:3.2.3"],
    Cell[141698, 4591, 232, 5, 27, "Output",
      CellTags->"nlug:3.2.3"],
    Cell[141945, 4599, 70, 1, 25, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[142018, 4602, 98, 2, 31, "Input",
      CellTags->"nlug:3.2.3"],
    Cell[142119, 4606, 142, 4, 25, "Text",
      CellTags->"nlug:3.2.3"],
    Cell[142286, 4614, 99, 2, 31, "Input",
      CellTags->"nlug:3.2.3"],
    Cell[142388, 4618, 115, 3, 27, "Output",
      CellTags->"nlug:3.2.3"]},
  "Overloaded Operators"->{
    Cell[142564, 4628, 94, 1, 39, "Subsection",
      CellTags->{"Overloaded Operators", "nlug:3.2.4"}]},
  "nlug:3.2.4"->{
    Cell[142564, 4628, 94, 1, 39, "Subsection",
      CellTags->{"Overloaded Operators", "nlug:3.2.4"}],
    Cell[142661, 4631, 658, 16, 76, "Text",
      CellTags->"nlug:3.2.4"],
    Cell[143322, 4649, 223, 6, 82, "Program",
      CellTags->"nlug:3.2.4"],
    Cell[143548, 4657, 459, 10, 59, "Text",
      CellTags->"nlug:3.2.4"],
    Cell[144010, 4669, 396, 13, 42, "Text",
      CellTags->"nlug:3.2.4"],
    Cell[144431, 4686, 197, 7, 91, "Input",
      CellTags->"nlug:3.2.4"],
    Cell[144631, 4695, 95, 3, 27, "Output",
      CellTags->"nlug:3.2.4"],
    Cell[144741, 4701, 880, 21, 93, "Text",
      CellTags->"nlug:3.2.4"],
    Cell[145646, 4726, 123, 2, 31, "Input",
      CellTags->"nlug:3.2.4"],
    Cell[145772, 4730, 2265, 55, 247, "Output",
      CellTags->"nlug:3.2.4"],
    Cell[148052, 4788, 537, 16, 59, "Text",
      CellTags->"nlug:3.2.4"],
    Cell[148614, 4808, 107, 2, 31, "Input",
      CellTags->"nlug:3.2.4"],
    Cell[148724, 4812, 95, 3, 27, "Output",
      CellTags->"nlug:3.2.4"]},
  "Casting"->{
    Cell[148868, 4821, 68, 1, 39, "Subsection",
      CellTags->{"Casting", "nlug:3.2.5"}]},
  "nlug:3.2.5"->{
    Cell[148868, 4821, 68, 1, 39, "Subsection",
      CellTags->{"Casting", "nlug:3.2.5"}],
    Cell[148961, 4826, 63, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.5"],
    Cell[149027, 4829, 829, 18, 93, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[149859, 4849, 164, 7, 99, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[150026, 4858, 507, 13, 59, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[150536, 4873, 260, 14, 218, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[150799, 4889, 233, 7, 25, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[151035, 4898, 455, 13, 59, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[151493, 4913, 1467, 38, 127, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[152963, 4953, 701, 18, 76, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[153667, 4973, 678, 19, 59, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[154348, 4994, 388, 9, 65, "ItemizedText",
      CellTags->"nlug:3.2.5"],
    Cell[154739, 5005, 529, 10, 59, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[155271, 5017, 662, 13, 76, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[155936, 5032, 1773, 53, 66, "DefinitionBox",
      CellTags->"nlug:3.2.5"],
    Cell[157712, 5087, 120, 5, 17, "Caption",
      CellTags->"nlug:3.2.5"],
    Cell[157835, 5094, 192, 8, 25, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[158064, 5107, 93, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.5"],
    Cell[158160, 5110, 311, 8, 42, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[158474, 5120, 223, 10, 150, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[158700, 5132, 364, 13, 42, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[159067, 5147, 225, 6, 82, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[159295, 5155, 445, 14, 42, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[159743, 5171, 376, 14, 42, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[160144, 5189, 114, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.5"],
    Cell[160261, 5194, 216, 5, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[160514, 5204, 134, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.5"],
    Cell[160651, 5209, 217, 5, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[160905, 5219, 105, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.5"],
    Cell[161013, 5224, 96, 3, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[161124, 5230, 96, 1, 25, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[161245, 5235, 119, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.5"],
    Cell[161367, 5240, 88, 3, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[161504, 5249, 84, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.5"],
    Cell[161591, 5252, 927, 21, 93, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[162521, 5275, 575, 30, 490, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[163099, 5307, 345, 11, 42, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[163447, 5320, 201, 5, 65, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[163651, 5327, 158, 6, 25, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[163812, 5335, 237, 6, 71, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.5"],
    Cell[164052, 5343, 737, 20, 76, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[164814, 5367, 100, 2, 31, "Input",
      CellTags->"nlug:3.2.5"],
    Cell[164917, 5371, 218, 5, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[165172, 5381, 82, 2, 31, "Input",
      CellTags->"nlug:3.2.5"],
    Cell[165257, 5385, 214, 5, 20, "Message",
      CellTags->"nlug:3.2.5"],
    Cell[165474, 5392, 91, 3, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[165580, 5398, 116, 5, 25, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[165721, 5407, 128, 2, 31, "Input",
      CellTags->"nlug:3.2.5"],
    Cell[165852, 5411, 89, 3, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[165990, 5420, 82, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.5"],
    Cell[166075, 5423, 1058, 23, 110, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[167136, 5448, 330, 9, 42, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[167469, 5459, 162, 9, 133, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[167634, 5470, 244, 7, 25, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[167881, 5479, 149, 5, 65, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[168055, 5488, 155, 6, 51, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.5"],
    Cell[168213, 5496, 227, 5, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[168455, 5504, 233, 7, 25, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[168713, 5515, 76, 2, 31, "Input",
      CellTags->"nlug:3.2.5"],
    Cell[168792, 5519, 263, 7, 20, "Message",
      CellTags->"nlug:3.2.5"],
    Cell[169058, 5528, 91, 3, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[169164, 5534, 765, 20, 76, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[169932, 5556, 123, 5, 65, "Program",
      CellTags->"nlug:3.2.5"],
    Cell[170058, 5563, 403, 11, 42, "Text",
      CellTags->"nlug:3.2.5"],
    Cell[170486, 5578, 144, 6, 51, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.5"],
    Cell[170633, 5586, 86, 3, 27, "Output",
      CellTags->"nlug:3.2.5"],
    Cell[170734, 5592, 993, 16, 110, "Text",
      CellTags->"nlug:3.2.5"]},
  "nlug:3.2.6"->{
    Cell[171776, 5614, 56, 1, 39, "Subsection",
      CellTags->"nlug:3.2.6"],
    Cell[171835, 5617, 486, 12, 59, "Text",
      CellTags->"nlug:3.2.6"],
    Cell[172324, 5631, 316, 17, 269, "Program",
      CellTags->"nlug:3.2.6"],
    Cell[172643, 5650, 558, 11, 59, "Text",
      CellTags->"nlug:3.2.6"],
    Cell[173204, 5663, 113, 7, 99, "Program",
      CellTags->"nlug:3.2.6"],
    Cell[173320, 5672, 200, 6, 25, "Text",
      CellTags->"nlug:3.2.6"],
    Cell[173523, 5680, 114, 5, 51, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.6"],
    Cell[173640, 5687, 655, 17, 59, "Text",
      CellTags->"nlug:3.2.6"],
    Cell[174298, 5706, 313, 7, 42, "Text",
      CellTags->"nlug:3.2.6"],
    Cell[174636, 5717, 146, 4, 31, "Input",
      CellTags->"nlug:3.2.6"],
    Cell[174785, 5723, 231, 5, 27, "Output",
      CellTags->"nlug:3.2.6"],
    Cell[175031, 5731, 136, 4, 25, "Text",
      CellTags->"nlug:3.2.6"],
    Cell[175192, 5739, 78, 2, 31, "Input",
      CellTags->"nlug:3.2.6"],
    Cell[175273, 5743, 89, 3, 27, "Output",
      CellTags->"nlug:3.2.6"],
    Cell[175377, 5749, 773, 18, 76, "Text",
      CellTags->"nlug:3.2.6"],
    Cell[176175, 5771, 83, 2, 31, "Input",
      CellTags->"nlug:3.2.6"],
    Cell[176261, 5775, 89, 3, 27, "Output",
      CellTags->"nlug:3.2.6"]},
  "Exceptions"->{
    Cell[176399, 5784, 74, 1, 39, "Subsection",
      CellTags->{"Exceptions", "nlug:3.2.7"}]},
  "nlug:3.2.7"->{
    Cell[176399, 5784, 74, 1, 39, "Subsection",
      CellTags->{"Exceptions", "nlug:3.2.7"}],
    Cell[176498, 5789, 77, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.7"],
    Cell[176578, 5792, 394, 10, 42, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[176997, 5806, 181, 4, 49, "Input",
      CellTags->"nlug:3.2.7"],
    Cell[177181, 5812, 437, 8, 65, "Message",
      CellTags->"nlug:3.2.7"],
    Cell[177621, 5822, 92, 3, 27, "Output",
      CellTags->"nlug:3.2.7"],
    Cell[177728, 5828, 152, 5, 25, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[177883, 5835, 332, 7, 42, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[178252, 5847, 66, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.7"],
    Cell[178321, 5850, 904, 22, 93, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[179250, 5876, 91, 2, 31, "Input",
      CellTags->"nlug:3.2.7"],
    Cell[179344, 5880, 246, 5, 27, "Output",
      CellTags->"nlug:3.2.7"],
    Cell[179605, 5888, 167, 5, 25, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[179797, 5897, 97, 2, 31, "Input",
      CellTags->"nlug:3.2.7"],
    Cell[179897, 5901, 248, 5, 27, "Output",
      CellTags->"nlug:3.2.7"],
    Cell[180160, 5909, 248, 5, 25, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[180433, 5918, 91, 2, 31, "Input",
      CellTags->"nlug:3.2.7"],
    Cell[180527, 5922, 227, 5, 27, "Output",
      CellTags->"nlug:3.2.7"],
    Cell[180803, 5933, 76, 1, 35, "Subsubsection",
      CellTags->"nlug:3.2.7"],
    Cell[180882, 5936, 604, 16, 59, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[181489, 5954, 644, 15, 59, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[182136, 5971, 299, 8, 42, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[182438, 5981, 115, 5, 71, "Input",
      CellTags->"nlug:3.2.7"],
    Cell[182556, 5988, 224, 6, 25, "Text",
      CellTags->"nlug:3.2.7"],
    Cell[182783, 5996, 192, 7, 111, "Input",
      CellTags->"nlug:3.2.7"],
    Cell[182978, 6005, 387, 9, 42, "Text",
      CellTags->"nlug:3.2.7"]},
  "nlug:3.2.8"->{
    Cell[183414, 6020, 60, 1, 39, "Subsection",
      CellTags->"nlug:3.2.8"],
    Cell[183477, 6023, 146, 4, 25, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[183626, 6029, 333, 15, 235, "Program",
      CellTags->"nlug:3.2.8"],
    Cell[183962, 6046, 418, 12, 42, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[184405, 6062, 144, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.8"],
    Cell[184552, 6067, 124, 3, 27, "Output",
      CellTags->"nlug:3.2.8"],
    Cell[184691, 6073, 206, 7, 25, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[184922, 6084, 137, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.8"],
    Cell[185062, 6089, 229, 5, 27, "Output",
      CellTags->"nlug:3.2.8"],
    Cell[185306, 6097, 400, 12, 42, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[185709, 6111, 100, 4, 48, "Program",
      CellTags->"nlug:3.2.8"],
    Cell[185812, 6117, 473, 14, 42, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[186288, 6133, 120, 3, 25, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[186433, 6140, 86, 2, 31, "Input",
      CellTags->"nlug:3.2.8"],
    Cell[186522, 6144, 86, 3, 27, "Output",
      CellTags->"nlug:3.2.8"],
    Cell[186623, 6150, 339, 11, 42, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[186987, 6165, 95, 2, 31, "Input",
      CellTags->"nlug:3.2.8"],
    Cell[187085, 6169, 86, 3, 27, "Output",
      CellTags->"nlug:3.2.8"],
    Cell[187186, 6175, 429, 8, 59, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[187618, 6185, 887, 25, 76, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[188508, 6212, 162, 5, 51, "Input",
      CellTags->"nlug:3.2.8"],
    Cell[188673, 6219, 357, 12, 42, "Text",
      CellTags->"nlug:3.2.8"],
    Cell[189055, 6235, 137, 4, 31, "Input",
      CellTags->"nlug:3.2.8"],
    Cell[189195, 6241, 132, 3, 27, "Output",
      CellTags->"nlug:3.2.8"],
    Cell[189342, 6247, 518, 15, 59, "Text",
      CellTags->"nlug:3.2.8"]},
  "nlug:3.2.9"->{
    Cell[189897, 6267, 61, 1, 39, "Subsection",
      CellTags->"nlug:3.2.9"],
    Cell[189961, 6270, 748, 19, 76, "Text",
      CellTags->"nlug:3.2.9"],
    Cell[190734, 6293, 107, 2, 31, "Input",
      CellTags->"nlug:3.2.9"],
    Cell[190844, 6297, 218, 5, 27, "Output",
      CellTags->"nlug:3.2.9"],
    Cell[191077, 6305, 152, 6, 71, "Input",
      CellTags->"nlug:3.2.9"],
    Cell[191232, 6313, 139, 5, 25, "Text",
      CellTags->"nlug:3.2.9"],
    Cell[191396, 6322, 106, 2, 31, "Input",
      CellTags->"nlug:3.2.9"],
    Cell[191505, 6326, 218, 5, 27, "Output",
      CellTags->"nlug:3.2.9"],
    Cell[191738, 6334, 1415, 46, 82, "DefinitionBox",
      CellTags->"nlug:3.2.9"],
    Cell[193156, 6382, 97, 4, 17, "Caption",
      CellTags->"nlug:3.2.9"],
    Cell[193256, 6388, 857, 24, 93, "Text",
      CellTags->"nlug:3.2.9"],
    Cell[194116, 6414, 86, 1, 31, "Program",
      CellTags->"nlug:3.2.9"],
    Cell[194205, 6417, 491, 12, 59, "Text",
      CellTags->"nlug:3.2.9"],
    Cell[194699, 6431, 120, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.9"],
    Cell[194844, 6438, 121, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.9"],
    Cell[194968, 6443, 96, 3, 27, "Output",
      CellTags->"nlug:3.2.9"],
    Cell[195079, 6449, 291, 7, 42, "Text",
      CellTags->"nlug:3.2.9"],
    Cell[195373, 6458, 102, 4, 48, "Program",
      CellTags->"nlug:3.2.9"],
    Cell[195478, 6464, 815, 23, 76, "Text",
      CellTags->"nlug:3.2.9"],
    Cell[196296, 6489, 108, 2, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.9"],
    Cell[196407, 6493, 479, 13, 59, "Text",
      CellTags->"nlug:3.2.9"]},
  "nlug:3.2.10"->{
    Cell[196923, 6511, 64, 1, 39, "Subsection",
      CellTags->"nlug:3.2.10"],
    Cell[196990, 6514, 906, 24, 93, "Text",
      CellTags->"nlug:3.2.10"],
    Cell[197899, 6540, 737, 23, 66, "DefinitionBox",
      CellTags->"nlug:3.2.10"],
    Cell[198639, 6565, 83, 1, 17, "Caption",
      CellTags->"nlug:3.2.10"],
    Cell[198725, 6568, 137, 4, 25, "Text",
      CellTags->"nlug:3.2.10"],
    Cell[198865, 6574, 216, 6, 27, "ItemizedText",
      CellTags->"nlug:3.2.10"],
    Cell[199084, 6582, 224, 6, 27, "ItemizedText",
      CellTags->"nlug:3.2.10"],
    Cell[199311, 6590, 1023, 30, 541, "Program",
      CellTags->"nlug:3.2.10"],
    Cell[200337, 6622, 88, 1, 25, "Text",
      CellTags->"nlug:3.2.10"],
    Cell[200428, 6625, 400, 22, 354, "Program",
      CellTags->"nlug:3.2.10"],
    Cell[200831, 6649, 195, 5, 25, "Text",
      CellTags->"nlug:3.2.10"],
    Cell[201029, 6656, 235, 6, 49, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.10"],
    Cell[201289, 6666, 129, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.10"],
    Cell[201421, 6671, 230, 5, 27, "Output",
      CellTags->"nlug:3.2.10"],
    Cell[201666, 6679, 557, 17, 59, "Text",
      CellTags->"nlug:3.2.10"],
    Cell[202248, 6700, 114, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.10"],
    Cell[202365, 6705, 139, 3, 27, "Output",
      CellTags->"nlug:3.2.10"],
    Cell[202519, 6711, 489, 15, 42, "Text",
      CellTags->"nlug:3.2.10"],
    Cell[203033, 6730, 98, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.10"],
    Cell[203134, 6735, 138, 3, 27, "Output",
      CellTags->"nlug:3.2.10"],
    Cell[203309, 6743, 106, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.10"],
    Cell[203418, 6748, 140, 3, 27, "Output",
      CellTags->"nlug:3.2.10"],
    Cell[203595, 6756, 99, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.10"],
    Cell[203697, 6761, 139, 3, 27, "Output",
      CellTags->"nlug:3.2.10"],
    Cell[203851, 6767, 763, 20, 76, "Text",
      CellTags->"nlug:3.2.10"],
    Cell[204639, 6791, 115, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.10"],
    Cell[204757, 6796, 138, 3, 27, "Output",
      CellTags->"nlug:3.2.10"],
    Cell[204910, 6802, 323, 9, 42, "Text",
      CellTags->"nlug:3.2.10"]},
  ".NET Console"->{
    Cell[205270, 6816, 90, 1, 39, "Subsection",
      CellTags->{".NET Console", "nlug:3.2.11"}]},
  "nlug:3.2.11"->{
    Cell[205270, 6816, 90, 1, 39, "Subsection",
      CellTags->{".NET Console", "nlug:3.2.11"}],
    Cell[205363, 6819, 915, 25, 76, "Text",
      CellTags->"nlug:3.2.11"],
    Cell[206281, 6846, 1415, 43, 126, "DefinitionBox",
      CellTags->"nlug:3.2.11"],
    Cell[207699, 6891, 73, 1, 17, "Caption",
      CellTags->"nlug:3.2.11"],
    Cell[207797, 6896, 84, 2, 31, "Input",
      CellTags->"nlug:3.2.11"],
    Cell[207884, 6900, 237, 5, 27, "Output",
      CellTags->"nlug:3.2.11"],
    Cell[208136, 6908, 463, 12, 59, "Text",
      CellTags->"nlug:3.2.11"],
    Cell[208602, 6922, 338, 9, 42, "Text",
      CellTags->"nlug:3.2.11"],
    Cell[208943, 6933, 151, 5, 51, "Input",
      CellTags->"nlug:3.2.11"],
    Cell[209097, 6940, 301, 7, 42, "Text",
      CellTags->"nlug:3.2.11"]},
  "Distributing Applications"->{
    Cell[209435, 6952, 181, 5, 39, "Subsection",
      CellTags->{"Distributing Applications", "nlug:3.2.12"}]},
  "nlug:3.2.12"->{
    Cell[209435, 6952, 181, 5, 39, "Subsection",
      CellTags->{"Distributing Applications", "nlug:3.2.12"}],
    Cell[209619, 6959, 262, 9, 25, "Text",
      CellTags->"nlug:3.2.12"],
    Cell[209884, 6970, 669, 15, 76, "Text",
      CellTags->"nlug:3.2.12"],
    Cell[210556, 6987, 839, 24, 76, "Text",
      CellTags->"nlug:3.2.12"],
    Cell[211398, 7013, 994, 25, 76, "Text",
      CellTags->"nlug:3.2.12"],
    Cell[212395, 7040, 184, 6, 25, "Text",
      CellTags->"nlug:3.2.12"],
    Cell[212582, 7048, 229, 9, 133, "Program",
      CellTags->"nlug:3.2.12"],
    Cell[212814, 7059, 664, 13, 76, "Text",
      CellTags->"nlug:3.2.12"],
    Cell[213481, 7074, 160, 6, 71, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.2.12"]},
  "nlug:3.2.13"->{
    Cell[213678, 7085, 68, 1, 39, "Subsection",
      CellTags->"nlug:3.2.13"],
    Cell[213749, 7088, 501, 13, 59, "Text",
      CellTags->"nlug:3.2.13"],
    Cell[214253, 7103, 1409, 37, 108, "DefinitionBox",
      CellTags->"nlug:3.2.13"],
    Cell[215665, 7142, 133, 5, 17, "Caption",
      CellTags->"nlug:3.2.13"],
    Cell[215823, 7151, 112, 3, 29, "Input",
      CellTags->"nlug:3.2.13"],
    Cell[215938, 7156, 127, 3, 27, "Output",
      CellTags->"nlug:3.2.13"],
    Cell[216102, 7164, 118, 3, 29, "Input",
      CellTags->"nlug:3.2.13"],
    Cell[216223, 7169, 88, 3, 27, "Output",
      CellTags->"nlug:3.2.13"],
    Cell[216348, 7177, 118, 3, 29, "Input",
      CellTags->"nlug:3.2.13"],
    Cell[216469, 7182, 86, 3, 27, "Output",
      CellTags->"nlug:3.2.13"],
    Cell[216570, 7188, 445, 15, 42, "Text",
      CellTags->"nlug:3.2.13"]},
  "nlug:3.3.0"->{
    Cell[217132, 7213, 60, 1, 39, "Subsection",
      CellTags->"nlug:3.3.0"],
    Cell[217195, 7216, 1063, 20, 110, "Text",
      CellTags->"nlug:3.3.0"],
    Cell[218261, 7238, 553, 17, 59, "Text",
      CellTags->"nlug:3.3.0"],
    Cell[218817, 7257, 858, 30, 59, "Text",
      CellTags->"nlug:3.3.0"],
    Cell[219678, 7289, 857, 29, 59, "Text",
      CellTags->"nlug:3.3.0"],
    Cell[220538, 7320, 673, 20, 59, "Text",
      CellTags->"nlug:3.3.0"]},
  "Modal versus Modeless"->{
    Cell[221248, 7345, 106, 1, 39, "Subsection",
      CellTags->{"Modal versus Modeless", "nlug:3.3.1"}]},
  "nlug:3.3.1"->{
    Cell[221248, 7345, 106, 1, 39, "Subsection",
      CellTags->{"Modal versus Modeless", "nlug:3.3.1"}],
    Cell[221357, 7348, 691, 15, 76, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[222051, 7365, 1653, 39, 144, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[223707, 7406, 854, 18, 93, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[224564, 7426, 899, 21, 76, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[225466, 7449, 673, 16, 76, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[226142, 7467, 688, 12, 76, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[226833, 7481, 825, 16, 93, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[227661, 7499, 901, 15, 110, "Text",
      CellTags->"nlug:3.3.1"],
    Cell[228565, 7516, 306, 7, 42, "Text",
      CellTags->"nlug:3.3.1"]},
  "Handling Events"->{
    Cell[228908, 7528, 84, 1, 39, "Subsection",
      CellTags->{"Handling Events", "nlug:3.3.2"}]},
  "nlug:3.3.2"->{
    Cell[228908, 7528, 84, 1, 39, "Subsection",
      CellTags->{"Handling Events", "nlug:3.3.2"}],
    Cell[228995, 7531, 791, 15, 93, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[229789, 7548, 412, 12, 42, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[230204, 7562, 212, 7, 99, "Program",
      CellTags->"nlug:3.3.2"],
    Cell[230419, 7571, 410, 9, 42, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[230832, 7582, 421, 10, 42, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[231256, 7594, 131, 4, 31, "Program",
      CellTags->"nlug:3.3.2"],
    Cell[231390, 7600, 184, 5, 25, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[231577, 7607, 297, 7, 99, "Program",
      CellTags->"nlug:3.3.2"],
    Cell[231877, 7616, 323, 13, 25, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[232203, 7631, 119, 2, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.3.2"],
    Cell[232325, 7635, 768, 19, 76, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[233096, 7656, 193, 5, 51, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.3.2"],
    Cell[233292, 7663, 1407, 40, 84, "DefinitionBox",
      CellTags->"nlug:3.3.2"],
    Cell[234702, 7705, 181, 5, 17, "Caption",
      CellTags->"nlug:3.3.2"],
    Cell[234886, 7712, 688, 13, 76, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[235577, 7727, 704, 20, 59, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[236284, 7749, 163, 6, 71, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.3.2"],
    Cell[236450, 7757, 1009, 26, 93, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[237462, 7785, 240, 9, 131, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.3.2"],
    Cell[237705, 7796, 1426, 37, 127, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[239134, 7835, 160, 5, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.3.2"],
    Cell[239297, 7842, 147, 5, 25, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[239447, 7849, 124, 2, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.3.2"],
    Cell[239574, 7853, 312, 10, 42, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[239889, 7865, 942, 26, 130, "DefinitionBox3Col",
      CellTags->"nlug:3.3.2"],
    Cell[240834, 7893, 73, 1, 17, "Caption",
      CellTags->"nlug:3.3.2"],
    Cell[240910, 7896, 831, 26, 59, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[241744, 7924, 1708, 44, 127, "Text",
      CellTags->"nlug:3.3.2"],
    Cell[243455, 7970, 1308, 37, 98, "DefinitionBox",
      CellTags->"nlug:3.3.2"],
    Cell[244766, 8009, 156, 6, 17, "Caption",
      CellTags->"nlug:3.3.2"],
    Cell[244925, 8017, 464, 12, 59, "Text",
      CellTags->"nlug:3.3.2"]},
  "Modal Windows"->{
    Cell[245426, 8034, 80, 1, 39, "Subsection",
      CellTags->{"Modal Windows", "nlug:3.3.3"}]},
  "nlug:3.3.3"->{
    Cell[245426, 8034, 80, 1, 39, "Subsection",
      CellTags->{"Modal Windows", "nlug:3.3.3"}],
    Cell[245509, 8037, 526, 13, 59, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[246060, 8054, 128, 3, 29, "Input",
      CellTags->"nlug:3.3.3"],
    Cell[246191, 8059, 228, 5, 27, "Output",
      CellTags->"nlug:3.3.3"],
    Cell[246434, 8067, 529, 13, 59, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[246966, 8082, 86, 2, 31, "Input",
      CellTags->"nlug:3.3.3"],
    Cell[247055, 8086, 586, 13, 59, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[247644, 8101, 197, 4, 49, "Input",
      CellTags->"nlug:3.3.3"],
    Cell[247844, 8107, 207, 8, 25, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[248054, 8117, 125, 3, 29, "Input",
      CellTags->"nlug:3.3.3"],
    Cell[248182, 8122, 379, 10, 42, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[248564, 8134, 325, 8, 69, "Input",
      CellTags->"nlug:3.3.3"],
    Cell[248892, 8144, 746, 21, 59, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[249641, 8167, 635, 13, 76, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[250279, 8182, 1764, 51, 98, "DefinitionBox",
      CellTags->"nlug:3.3.3"],
    Cell[252046, 8235, 67, 1, 17, "Caption",
      CellTags->"nlug:3.3.3"],
    Cell[252116, 8238, 131, 4, 25, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[252250, 8244, 99, 3, 29, "Input",
      CellTags->"nlug:3.3.3"],
    Cell[252352, 8249, 324, 8, 42, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[252679, 8259, 1289, 31, 110, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[253971, 8292, 123, 3, 25, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[254097, 8297, 493, 17, 291, "Input",
      CellTags->"nlug:3.3.3"],
    Cell[254593, 8316, 1125, 28, 110, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[255721, 8346, 166, 5, 51, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.3.3"],
    Cell[255890, 8353, 508, 16, 25, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[256401, 8371, 589, 16, 59, "Text",
      CellTags->"nlug:3.3.3"],
    Cell[256993, 8389, 516, 13, 70, "DefinitionBox3Col",
      CellTags->"nlug:3.3.3"],
    Cell[257512, 8404, 68, 1, 17, "Caption",
      CellTags->"nlug:3.3.3"]},
  "Modeless Windows"->{
    Cell[257617, 8410, 86, 1, 39, "Subsection",
      CellTags->{"Modeless Windows", "nlug:3.3.4"}]},
  "nlug:3.3.4"->{
    Cell[257617, 8410, 86, 1, 39, "Subsection",
      CellTags->{"Modeless Windows", "nlug:3.3.4"}],
    Cell[257706, 8413, 673, 15, 59, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[258382, 8430, 448, 12, 42, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[258833, 8444, 554, 17, 44, "DefinitionBox",
      CellTags->"nlug:3.3.4"],
    Cell[259390, 8463, 62, 1, 17, "Caption",
      CellTags->"nlug:3.3.4"],
    Cell[259455, 8466, 177, 5, 25, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[259635, 8473, 486, 17, 291, "Input",
      CellTags->"nlug:3.3.4"],
    Cell[260124, 8492, 317, 7, 42, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[260444, 8501, 83, 2, 31, "Input",
      CellTags->"nlug:3.3.4"],
    Cell[260530, 8505, 1462, 42, 127, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[261995, 8549, 754, 15, 76, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[262752, 8566, 945, 25, 130, "DefinitionBox3Col",
      CellTags->"nlug:3.3.4"],
    Cell[263700, 8593, 71, 1, 17, "Caption",
      CellTags->"nlug:3.3.4"],
    Cell[263774, 8596, 955, 25, 93, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[264732, 8623, 1083, 28, 110, "Text",
      CellTags->"nlug:3.3.4"],
    Cell[265818, 8653, 949, 21, 93, "Text",
      CellTags->"nlug:3.3.4"]},
  "Sharing the Kernel"->{
    Cell[266804, 8679, 123, 1, 39, "Subsection",
      CellTags->{"Sharing the Kernel", "nlug:3.3.5"}]},
  "nlug:3.3.5"->{
    Cell[266804, 8679, 123, 1, 39, "Subsection",
      CellTags->{"Sharing the Kernel", "nlug:3.3.5"}],
    Cell[266930, 8682, 806, 24, 76, "Text",
      CellTags->"nlug:3.3.5"],
    Cell[267739, 8708, 926, 20, 93, "Text",
      CellTags->"nlug:3.3.5"],
    Cell[268668, 8730, 1210, 34, 93, "Text",
      CellTags->"nlug:3.3.5"],
    Cell[269881, 8766, 223, 8, 99, "Program",
      CellTags->"nlug:3.3.5"],
    Cell[270107, 8776, 587, 18, 59, "Text",
      CellTags->"nlug:3.3.5"],
    Cell[270697, 8796, 72, 1, 31, "Input",
      CellTags->"nlug:3.3.5"],
    Cell[270772, 8799, 187, 7, 25, "Text",
      CellTags->"nlug:3.3.5"],
    Cell[270962, 8808, 62, 1, 31, "Input",
      CellTags->"nlug:3.3.5"],
    Cell[271027, 8811, 628, 18, 59, "Text",
      CellTags->"nlug:3.3.5"],
    Cell[271658, 8831, 619, 17, 59, "Text",
      CellTags->"nlug:3.3.5"]},
  "ShowNETWindow"->{
    Cell[272314, 8853, 185, 6, 39, "Subsection",
      CellTags->{"ShowNETWindow", "nlug:3.3.6"}],
    Cell[273655, 8898, 106, 1, 39, "Subsection",
      CellTags->{"ShowNETWindow", "nlug:3.3.7"}]},
  "nlug:3.3.6"->{
    Cell[272314, 8853, 185, 6, 39, "Subsection",
      CellTags->{"ShowNETWindow", "nlug:3.3.6"}],
    Cell[272502, 8861, 1116, 32, 59, "Text",
      CellTags->"nlug:3.3.6"]},
  "nlug:3.3.7"->{
    Cell[273655, 8898, 106, 1, 39, "Subsection",
      CellTags->{"ShowNETWindow", "nlug:3.3.7"}],
    Cell[273764, 8901, 748, 19, 76, "Text",
      CellTags->"nlug:3.3.7"],
    Cell[274515, 8922, 773, 21, 76, "Text",
      CellTags->"nlug:3.3.7"],
    Cell[275291, 8945, 658, 20, 62, "DefinitionBox",
      CellTags->"nlug:3.3.7"],
    Cell[275952, 8967, 86, 1, 17, "Caption",
      CellTags->"nlug:3.3.7"],
    Cell[276041, 8970, 690, 21, 59, "Text",
      CellTags->"nlug:3.3.7"]},
  "nlug:3.3.8"->{
    Cell[276768, 8996, 61, 1, 39, "Subsection",
      CellTags->"nlug:3.3.8"],
    Cell[276832, 8999, 162, 5, 25, "Text",
      CellTags->"nlug:3.3.8"],
    Cell[276997, 9006, 287, 6, 31, "Input",
      CellTags->"nlug:3.3.8"],
    Cell[277287, 9014, 288, 6, 31, "Input",
      CellTags->"nlug:3.3.8"],
    Cell[277578, 9022, 296, 6, 31, "Input",
      CellTags->"nlug:3.3.8"],
    Cell[277877, 9030, 290, 6, 31, "Input",
      CellTags->"nlug:3.3.8"],
    Cell[278170, 9038, 305, 6, 31, "Input",
      CellTags->"nlug:3.3.8"]},
  "nlug:3.4.0"->{
    Cell[278676, 9058, 60, 1, 39, "Subsection",
      CellTags->"nlug:3.4.0"],
    Cell[278739, 9061, 334, 8, 42, "Text",
      CellTags->"nlug:3.4.0"],
    Cell[279076, 9071, 650, 15, 76, "Text",
      CellTags->"nlug:3.4.0"],
    Cell[279729, 9088, 1021, 23, 93, "Text",
      CellTags->"nlug:3.4.0"],
    Cell[280753, 9113, 804, 23, 76, "Text",
      CellTags->"nlug:3.4.0"],
    Cell[281560, 9138, 610, 16, 59, "Text",
      CellTags->"nlug:3.4.0"]},
  "nlug:3.4.1"->{
    Cell[282207, 9159, 129, 4, 39, "Subsection",
      CellTags->"nlug:3.4.1"],
    Cell[282339, 9165, 732, 15, 76, "Text",
      CellTags->"nlug:3.4.1"],
    Cell[283074, 9182, 751, 18, 76, "Text",
      CellTags->"nlug:3.4.1"],
    Cell[283828, 9202, 437, 23, 371, "Program",
      CellTags->"nlug:3.4.1"],
    Cell[284268, 9227, 907, 25, 76, "Text",
      CellTags->"nlug:3.4.1"],
    Cell[285178, 9254, 611, 17, 59, "Text",
      CellTags->"nlug:3.4.1"],
    Cell[285792, 9273, 535, 14, 59, "Text",
      CellTags->"nlug:3.4.1"],
    Cell[286330, 9289, 629, 17, 59, "Text",
      CellTags->"nlug:3.4.1"],
    Cell[286962, 9308, 917, 26, 76, "Text",
      CellTags->"nlug:3.4.1"]},
  "nlug:3.4.2"->{
    Cell[287916, 9339, 124, 4, 39, "Subsection",
      CellTags->"nlug:3.4.2"],
    Cell[288043, 9345, 931, 22, 93, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[288977, 9369, 1001, 22, 93, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[289981, 9393, 654, 20, 59, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[290638, 9415, 463, 13, 42, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[291104, 9430, 95, 1, 31, "Program",
      CellTags->"nlug:3.4.2"],
    Cell[291202, 9433, 250, 9, 25, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[291455, 9444, 73, 1, 31, "Program",
      CellTags->"nlug:3.4.2"],
    Cell[291531, 9447, 192, 6, 25, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[291726, 9455, 147, 2, 31, "Program",
      CellTags->"nlug:3.4.2"],
    Cell[291876, 9459, 62, 1, 25, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[291941, 9462, 356, 14, 218, "Program",
      CellTags->"nlug:3.4.2"],
    Cell[292300, 9478, 315, 11, 42, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[292618, 9491, 127, 5, 25, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[292770, 9500, 248, 6, 69, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.4.2"],
    Cell[293021, 9508, 122, 4, 23, "Print",
      CellTags->"nlug:3.4.2"],
    Cell[293146, 9514, 162, 4, 20, "Message",
      CellTags->"nlug:3.4.2"],
    Cell[293311, 9520, 93, 3, 27, "Output",
      CellTags->"nlug:3.4.2"],
    Cell[293419, 9526, 294, 8, 25, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[293716, 9536, 1493, 45, 110, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[295212, 9583, 67, 1, 25, "Text",
      CellTags->"nlug:3.4.2"],
    Cell[295282, 9586, 859, 29, 473, "Program",
      CellTags->"nlug:3.4.2"]},
  "nlug:3.4.3"->{
    Cell[296178, 9620, 67, 1, 39, "Subsection",
      CellTags->"nlug:3.4.3"],
    Cell[296248, 9623, 828, 19, 76, "Text",
      CellTags->"nlug:3.4.3"]},
  "nlug:3.4.4"->{
    Cell[297113, 9647, 77, 1, 39, "Subsection",
      CellTags->"nlug:3.4.4"],
    Cell[297193, 9650, 547, 17, 59, "Text",
      CellTags->"nlug:3.4.4"],
    Cell[297743, 9669, 350, 10, 42, "Text",
      CellTags->"nlug:3.4.4"],
    Cell[298096, 9681, 302, 12, 184, "Program",
      CellTags->"nlug:3.4.4"],
    Cell[298401, 9695, 1165, 31, 93, "Text",
      CellTags->"nlug:3.4.4"],
    Cell[299569, 9728, 1704, 40, 144, "Text",
      CellTags->"nlug:3.4.4"],
    Cell[301276, 9770, 1379, 32, 127, "Text",
      CellTags->"nlug:3.4.4"],
    Cell[302658, 9804, 61, 1, 25, "Text",
      CellTags->"nlug:3.4.4"],
    Cell[302722, 9807, 371, 16, 235, "Program",
      CellTags->"nlug:3.4.4"]},
  "nlug:3.4.5"->{
    Cell[303130, 9828, 83, 1, 39, "Subsection",
      CellTags->"nlug:3.4.5"],
    Cell[303216, 9831, 1825, 48, 144, "Text",
      CellTags->"nlug:3.4.5"],
    Cell[305044, 9881, 191, 5, 25, "Text",
      CellTags->"nlug:3.4.5"],
    Cell[305238, 9888, 202, 6, 27, "BulletText",
      CellTags->"nlug:3.4.5"],
    Cell[305443, 9896, 162, 6, 27, "BulletText",
      CellTags->"nlug:3.4.5"],
    Cell[305608, 9904, 242, 7, 27, "BulletText",
      CellTags->"nlug:3.4.5"],
    Cell[305853, 9913, 239, 7, 27, "BulletText",
      CellTags->"nlug:3.4.5"],
    Cell[306095, 9922, 159, 5, 27, "BulletText",
      CellTags->"nlug:3.4.5"],
    Cell[306257, 9929, 361, 12, 46, "BulletText",
      CellTags->"nlug:3.4.5"],
    Cell[306621, 9943, 737, 18, 76, "Text",
      CellTags->"nlug:3.4.5"],
    Cell[307361, 9963, 121, 3, 25, "Text",
      CellTags->"nlug:3.4.5"],
    Cell[307485, 9968, 580, 17, 269, "Program",
      CellTags->"nlug:3.4.5"]},
  "nlug:3.4.6"->{
    Cell[308102, 9990, 75, 1, 39, "Subsection",
      CellTags->"nlug:3.4.6"],
    Cell[308180, 9993, 652, 17, 76, "Text",
      CellTags->"nlug:3.4.6"],
    Cell[308835, 10012, 998, 28, 93, "Text",
      CellTags->"nlug:3.4.6"],
    Cell[309836, 10042, 97, 2, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.4.6"],
    Cell[309936, 10046, 640, 19, 59, "Text",
      CellTags->"nlug:3.4.6"]},
  "Calling DLLS from Mathematica"->{
    Cell[310762, 10080, 95, 1, 39, "Subsection",
      CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"}]},
  "nlug:3.5.0"->{
    Cell[310762, 10080, 95, 1, 39, "Subsection",
      CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"}],
    Cell[310860, 10083, 987, 24, 93, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[311850, 10109, 822, 20, 76, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[312675, 10131, 431, 10, 42, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[313109, 10143, 408, 10, 184, "Program",
      CellTags->"nlug:3.5.0"],
    Cell[313520, 10155, 325, 9, 42, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[313870, 10168, 160, 5, 31, "Input",
      CellTags->"nlug:3.5.0"],
    Cell[314033, 10175, 270, 6, 46, "Output",
      CellTags->"nlug:3.5.0"],
    Cell[314318, 10184, 222, 6, 25, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[314565, 10194, 83, 2, 31, "Input",
      CellTags->"nlug:3.5.0"],
    Cell[314651, 10198, 95, 3, 27, "Output",
      CellTags->"nlug:3.5.0"],
    Cell[314761, 10204, 1133, 26, 93, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[315897, 10232, 3214, 95, 106, "DefinitionBox",
      CellTags->"nlug:3.5.0"],
    Cell[319114, 10329, 68, 1, 17, "Caption",
      CellTags->"nlug:3.5.0"],
    Cell[319185, 10332, 921, 18, 93, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[320109, 10352, 493, 15, 42, "Text",
      CellTags->"nlug:3.5.0"],
    Cell[320605, 10369, 1070, 27, 172, "DefinitionBox3Col",
      CellTags->"nlug:3.5.0"],
    Cell[321678, 10398, 119, 5, 17, "Caption",
      CellTags->"nlug:3.5.0"]},
  "How DLLs are Found"->{
    Cell[321834, 10408, 90, 1, 39, "Subsection",
      CellTags->{"How DLLs are Found", "nlug:3.5.1"}]},
  "nlug:3.5.1"->{
    Cell[321834, 10408, 90, 1, 39, "Subsection",
      CellTags->{"How DLLs are Found", "nlug:3.5.1"}],
    Cell[321927, 10411, 937, 22, 93, "Text",
      CellTags->"nlug:3.5.1"],
    Cell[322867, 10435, 1599, 41, 127, "Text",
      CellTags->"nlug:3.5.1"],
    Cell[324469, 10478, 439, 10, 42, "Text",
      CellTags->"nlug:3.5.1"]},
  "Specifying Arguments and Return Values"->{
    Cell[324945, 10493, 130, 1, 39, "Subsection",
      CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"}]},
  "nlug:3.5.2"->{
    Cell[324945, 10493, 130, 1, 39, "Subsection",
      CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"}],
    Cell[325100, 10498, 63, 1, 35, "Subsubsection",
      CellTags->"nlug:3.5.2"],
    Cell[325166, 10501, 1027, 18, 93, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[326196, 10521, 68, 1, 31, "Program",
      CellTags->"nlug:3.5.2"],
    Cell[326267, 10524, 577, 17, 59, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[326847, 10543, 166, 5, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[327038, 10552, 87, 2, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[327128, 10556, 89, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[327232, 10562, 292, 6, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[327527, 10570, 427, 12, 171, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[327957, 10584, 573, 11, 76, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[328533, 10597, 332, 9, 133, "Program",
      CellTags->"nlug:3.5.2"],
    Cell[328868, 10608, 825, 23, 76, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[329696, 10633, 121, 3, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[329854, 10641, 66, 1, 35, "Subsubsection",
      CellTags->"nlug:3.5.2"],
    Cell[329923, 10644, 262, 7, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[330188, 10653, 2167, 49, 490, "DefinitionBox",
      CellTags->"nlug:3.5.2"],
    Cell[332358, 10704, 156, 5, 17, "Caption",
      CellTags->"nlug:3.5.2"],
    Cell[332517, 10711, 528, 12, 59, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[333082, 10728, 79, 1, 35, "Subsubsection",
      CellTags->{"strings in DLLs", "nlug:3.5.2"}],
    Cell[333164, 10731, 900, 18, 93, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[334067, 10751, 374, 9, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[334444, 10762, 117, 5, 65, "Program",
      CellTags->"nlug:3.5.2"],
    Cell[334564, 10769, 310, 8, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[334877, 10779, 277, 7, 51, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[335157, 10788, 142, 4, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[335324, 10796, 114, 2, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[335441, 10800, 90, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[335546, 10806, 387, 8, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[335958, 10818, 88, 2, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[336049, 10822, 91, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[336155, 10828, 95, 1, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[336275, 10833, 88, 2, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[336366, 10837, 95, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[336476, 10843, 632, 14, 59, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[337111, 10859, 1248, 32, 230, "DefinitionBox",
      CellTags->"nlug:3.5.2"],
    Cell[338362, 10893, 174, 5, 17, "Caption",
      CellTags->"nlug:3.5.2"],
    Cell[338539, 10900, 394, 11, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[338936, 10913, 564, 18, 291, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[339503, 10933, 940, 18, 76, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[340446, 10953, 115, 3, 31, "Program",
      CellTags->"nlug:3.5.2"],
    Cell[340564, 10958, 957, 20, 93, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[341524, 10980, 405, 8, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[341932, 10990, 270, 5, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[342205, 10997, 575, 15, 59, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[342783, 11014, 327, 9, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[343135, 11027, 154, 5, 51, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[343292, 11034, 87, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[343394, 11040, 193, 6, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[343612, 11050, 82, 2, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[343697, 11054, 96, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[343842, 11063, 70, 1, 35, "Subsubsection",
      CellTags->"nlug:3.5.2"],
    Cell[343915, 11066, 366, 8, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[344284, 11076, 533, 10, 103, "ItemizedText",
      CellTags->"nlug:3.5.2"],
    Cell[344820, 11088, 276, 7, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[345099, 11097, 81, 1, 31, "Program",
      CellTags->"nlug:3.5.2"],
    Cell[345183, 11100, 624, 15, 59, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[345810, 11117, 169, 5, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[345982, 11124, 1384, 35, 110, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[347391, 11163, 116, 5, 51, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[347510, 11170, 90, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[347637, 11178, 80, 2, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[347720, 11182, 89, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[347824, 11188, 505, 13, 59, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[348332, 11203, 178, 5, 31, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[348535, 11212, 111, 5, 71, "Input",
      CellTags->"nlug:3.5.2"],
    Cell[348649, 11219, 90, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[348742, 11224, 89, 3, 27, "Output",
      CellTags->"nlug:3.5.2"],
    Cell[348846, 11230, 957, 23, 93, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[349806, 11255, 703, 18, 76, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[350512, 11275, 136, 5, 65, "Program",
      CellTags->"nlug:3.5.2"],
    Cell[350651, 11282, 295, 8, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[350949, 11292, 363, 12, 171, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.5.2"],
    Cell[351315, 11306, 246, 7, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[351564, 11315, 300, 9, 42, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[351867, 11326, 175, 5, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.5.2"],
    Cell[352045, 11333, 100, 1, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[352148, 11336, 95, 2, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.5.2"],
    Cell[352246, 11340, 1176, 29, 110, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[353425, 11371, 436, 13, 211, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.5.2"],
    Cell[353864, 11386, 100, 1, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[353967, 11389, 95, 2, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.5.2"],
    Cell[354065, 11393, 325, 10, 25, "Text",
      CellTags->"nlug:3.5.2"],
    Cell[354427, 11408, 68, 1, 35, "Subsubsection",
      CellTags->"nlug:3.5.2"],
    Cell[354498, 11411, 1252, 29, 110, "Text",
      CellTags->"nlug:3.5.2"]},
  "strings in DLLs"->{
    Cell[333082, 10728, 79, 1, 35, "Subsubsection",
      CellTags->{"strings in DLLs", "nlug:3.5.2"}]},
  "Declarations Requiring Special Attributes"->{
    Cell[355799, 11446, 136, 1, 39, "Subsection",
      CellTags->{
      "Declarations Requiring Special Attributes", "nlug:3.5.3"}]},
  "nlug:3.5.3"->{
    Cell[355799, 11446, 136, 1, 39, "Subsection",
      CellTags->{"Declarations Requiring Special Attributes", "nlug:3.5.3"}],
    Cell[355938, 11449, 752, 16, 93, "Text",
      CellTags->"nlug:3.5.3"],
    Cell[356693, 11467, 277, 6, 82, "Program",
      CellTags->"nlug:3.5.3"],
    Cell[356973, 11475, 290, 7, 42, "Text",
      CellTags->"nlug:3.5.3"],
    Cell[357266, 11484, 324, 7, 91, "Input",
      CellTags->"nlug:3.5.3"],
    Cell[357593, 11493, 185, 6, 25, "Text",
      CellTags->"nlug:3.5.3"],
    Cell[357781, 11501, 217, 5, 42, "Text",
      CellTags->"nlug:3.5.3"],
    Cell[358001, 11508, 103, 1, 31, "Program",
      CellTags->"nlug:3.5.3"],
    Cell[358107, 11511, 146, 5, 25, "Text",
      CellTags->"nlug:3.5.3"],
    Cell[358256, 11518, 270, 5, 71, "Input",
      CellTags->"nlug:3.5.3"],
    Cell[358529, 11525, 560, 13, 59, "Text",
      CellTags->"nlug:3.5.3"],
    Cell[359092, 11540, 228, 5, 51, "Input",
      CellTags->"nlug:3.5.3"]},
  "DLL Example Files"->{
    Cell[359357, 11550, 84, 1, 39, "Subsection",
      CellTags->{"DLL Example Files", "nlug:3.5.4"}]},
  "nlug:3.5.4"->{
    Cell[359357, 11550, 84, 1, 39, "Subsection",
      CellTags->{"DLL Example Files", "nlug:3.5.4"}],
    Cell[359444, 11553, 253, 8, 25, "Text",
      CellTags->"nlug:3.5.4"],
    Cell[359700, 11563, 284, 6, 31, "Input",
      CellTags->"nlug:3.5.4"],
    Cell[359987, 11571, 278, 6, 31, "Input",
      CellTags->"nlug:3.5.4"],
    Cell[360268, 11579, 279, 6, 31, "Input",
      CellTags->"nlug:3.5.4"]},
  "COM"->{
    Cell[360596, 11591, 130, 6, 56, "Section",
      CellTags->"COM"]},
  "COM Introduction"->{
    Cell[360751, 11601, 82, 1, 39, "Subsection",
      CellTags->{"COM Introduction", "nlug:3.6.0"}]},
  "nlug:3.6.0"->{
    Cell[360751, 11601, 82, 1, 39, "Subsection",
      CellTags->{"COM Introduction", "nlug:3.6.0"}],
    Cell[360836, 11604, 661, 15, 76, "Text",
      CellTags->"nlug:3.6.0"],
    Cell[361500, 11621, 331, 6, 42, "Text",
      CellTags->"nlug:3.6.0"],
    Cell[361834, 11629, 547, 9, 76, "Text",
      CellTags->"nlug:3.6.0"],
    Cell[362384, 11640, 786, 16, 93, "Text",
      CellTags->"nlug:3.6.0"]},
  "nlug:3.6.1"->{
    Cell[363207, 11661, 79, 1, 39, "Subsection",
      CellTags->"nlug:3.6.1"],
    Cell[363289, 11664, 924, 19, 110, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[364216, 11685, 1021, 21, 127, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[365240, 11708, 1113, 19, 144, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[366356, 11729, 823, 17, 93, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[367182, 11748, 1700, 49, 172, "DefinitionBox",
      CellTags->"nlug:3.6.1"],
    Cell[368885, 11799, 68, 1, 17, "Caption",
      CellTags->"nlug:3.6.1"],
    Cell[368956, 11802, 93, 1, 25, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[369074, 11807, 108, 2, 31, "Input",
      CellTags->"nlug:3.6.1"],
    Cell[369185, 11811, 250, 5, 27, "Output",
      CellTags->"nlug:3.6.1"],
    Cell[369450, 11819, 882, 21, 93, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[370357, 11844, 93, 2, 31, "Input",
      CellTags->"nlug:3.6.1"],
    Cell[370453, 11848, 104, 3, 27, "Output",
      CellTags->"nlug:3.6.1"],
    Cell[370572, 11854, 1629, 38, 178, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[372204, 11894, 223, 6, 42, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[372452, 11904, 85, 2, 31, "Input",
      CellTags->"nlug:3.6.1"],
    Cell[372540, 11908, 204, 5, 20, "Message",
      CellTags->"nlug:3.6.1"],
    Cell[372747, 11915, 180, 6, 41, "Output",
      CellTags->"nlug:3.6.1"],
    Cell[372942, 11924, 551, 13, 59, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[373496, 11939, 179, 7, 25, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[373700, 11950, 79, 2, 31, "Input",
      CellTags->"nlug:3.6.1"],
    Cell[373782, 11954, 87, 3, 27, "Output",
      CellTags->"nlug:3.6.1"],
    Cell[373884, 11960, 282, 9, 42, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[374169, 11971, 143, 4, 31, "Program",
      CellTags->"nlug:3.6.1"],
    Cell[374315, 11977, 549, 13, 59, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[374867, 11992, 156, 5, 31, "Input",
      CellTags->"nlug:3.6.1"],
    Cell[375026, 11999, 851, 15, 110, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[375880, 12016, 195, 5, 51, "Input",
      CellTags->"nlug:3.6.1"],
    Cell[376100, 12025, 80, 1, 35, "Subsubsection",
      CellTags->"nlug:3.6.1"],
    Cell[376183, 12028, 315, 9, 42, "Text",
      CellTags->"nlug:3.6.1"],
    Cell[376501, 12039, 448, 9, 84, "ItemizedText",
      CellTags->"nlug:3.6.1"],
    Cell[376952, 12050, 283, 8, 42, "Text",
      CellTags->"nlug:3.6.1"]},
  "Interop Assembly"->{
    Cell[377284, 12064, 111, 1, 39, "Subsection",
      CellTags->{"Interop Assembly", "nlug:3.6.2"}]},
  "nlug:3.6.2"->{
    Cell[377284, 12064, 111, 1, 39, "Subsection",
      CellTags->{"Interop Assembly", "nlug:3.6.2"}],
    Cell[377398, 12067, 975, 20, 110, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[378376, 12089, 983, 23, 93, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[379362, 12114, 512, 16, 42, "DefinitionBox",
      CellTags->"nlug:3.6.2"],
    Cell[379877, 12132, 73, 1, 17, "Caption",
      CellTags->"nlug:3.6.2"],
    Cell[379953, 12135, 193, 4, 25, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[380171, 12143, 190, 5, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[380364, 12150, 120, 3, 27, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[380499, 12156, 787, 17, 76, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[381311, 12177, 102, 2, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[381416, 12181, 5501, 142, 695, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[386932, 12326, 405, 11, 42, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[387362, 12341, 109, 2, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[387474, 12345, 226, 5, 27, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[387715, 12353, 346, 8, 42, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[388086, 12365, 148, 4, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[388237, 12371, 86, 3, 27, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[388338, 12377, 413, 9, 59, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[388754, 12388, 235, 6, 71, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[388992, 12396, 318, 8, 42, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[389335, 12408, 102, 2, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[389440, 12412, 2196, 61, 255, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[391651, 12476, 489, 12, 59, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[392165, 12492, 110, 2, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[392278, 12496, 226, 5, 27, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[392519, 12504, 825, 23, 96, "DefinitionBox3Col",
      CellTags->"nlug:3.6.2"],
    Cell[393347, 12529, 119, 5, 17, "Caption",
      CellTags->"nlug:3.6.2"],
    Cell[393469, 12536, 1388, 34, 127, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[394860, 12572, 553, 14, 59, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[395438, 12590, 96, 2, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[395537, 12594, 1475, 35, 185, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[397027, 12632, 100, 1, 25, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[397152, 12637, 109, 2, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[397264, 12641, 89, 3, 27, "Output",
      CellTags->"nlug:3.6.2"],
    Cell[397390, 12649, 97, 1, 35, "Subsubsection",
      CellTags->"nlug:3.6.2"],
    Cell[397490, 12652, 879, 20, 93, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[398372, 12674, 166, 4, 31, "Program",
      CellTags->"nlug:3.6.2"],
    Cell[398541, 12680, 118, 3, 25, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[398662, 12685, 92, 1, 31, "Input",
      CellTags->"nlug:3.6.2"],
    Cell[398791, 12691, 77, 1, 35, "Subsubsection",
      CellTags->"nlug:3.6.2"],
    Cell[398871, 12694, 860, 14, 93, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[399734, 12710, 781, 18, 76, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[400518, 12730, 981, 24, 76, "Text",
      CellTags->"nlug:3.6.2"],
    Cell[401524, 12758, 136, 3, 31, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.6.2"],
    Cell[401663, 12763, 254, 6, 27, "Output",
      CellTags->"nlug:3.6.2"]},
  "nlug:3.6.3"->{
    Cell[401978, 12776, 71, 1, 39, "Subsection",
      CellTags->"nlug:3.6.3"],
    Cell[402052, 12779, 1098, 17, 93, "Text",
      CellTags->"nlug:3.6.3"],
    Cell[403153, 12798, 490, 16, 42, "DefinitionBox",
      CellTags->"nlug:3.6.3"],
    Cell[403646, 12816, 69, 1, 17, "Caption",
      CellTags->"nlug:3.6.3"],
    Cell[403718, 12819, 866, 16, 76, "Text",
      CellTags->"nlug:3.6.3"],
    Cell[404587, 12837, 271, 5, 42, "Text",
      CellTags->"nlug:3.6.3"],
    Cell[404883, 12846, 115, 2, 31, "Input",
      CellTags->"nlug:3.6.3"],
    Cell[405001, 12850, 253, 6, 27, "Output",
      CellTags->"nlug:3.6.3"],
    Cell[405269, 12859, 606, 15, 59, "Text",
      CellTags->"nlug:3.6.3"],
    Cell[405878, 12876, 189, 6, 71, "Input",
      CellTags->"nlug:3.6.3"],
    Cell[406070, 12884, 531, 13, 59, "Text",
      CellTags->"nlug:3.6.3"],
    Cell[406626, 12901, 156, 5, 31, "Input",
      CellTags->"nlug:3.6.3"],
    Cell[406785, 12908, 94, 3, 27, "Output",
      CellTags->"nlug:3.6.3"],
    Cell[406894, 12914, 1065, 22, 110, "Text",
      CellTags->"nlug:3.6.3"],
    Cell[407962, 12938, 286, 13, 211, "Input",
      Evaluatable->False,
      CellTags->"nlug:3.6.3"]},
  "nlug:3.6.4"->{
    Cell[408285, 12956, 67, 1, 39, "Subsection",
      CellTags->"nlug:3.6.4"],
    Cell[408355, 12959, 586, 13, 59, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[408966, 12976, 143, 4, 31, "Input",
      CellTags->"nlug:3.6.4"],
    Cell[409112, 12982, 254, 6, 27, "Output",
      CellTags->"nlug:3.6.4"],
    Cell[409381, 12991, 68, 1, 25, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[409452, 12994, 90, 2, 31, "Input",
      CellTags->"nlug:3.6.4"],
    Cell[409545, 12998, 239, 7, 25, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[409809, 13009, 99, 2, 31, "Input",
      CellTags->"nlug:3.6.4"],
    Cell[409911, 13013, 246, 5, 27, "Output",
      CellTags->"nlug:3.6.4"],
    Cell[410172, 13021, 771, 20, 76, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[410968, 13045, 119, 2, 31, "Input",
      CellTags->"nlug:3.6.4"],
    Cell[411090, 13049, 658, 19, 65, "Output",
      CellTags->"nlug:3.6.4"],
    Cell[411763, 13071, 1191, 26, 110, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[412957, 13099, 713, 14, 76, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[413695, 13117, 175, 5, 31, "Input",
      CellTags->"nlug:3.6.4"],
    Cell[413873, 13124, 253, 6, 27, "Output",
      CellTags->"nlug:3.6.4"],
    Cell[414141, 13133, 187, 4, 25, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[414331, 13139, 189, 5, 65, "Program",
      CellTags->"nlug:3.6.4"],
    Cell[414523, 13146, 232, 7, 25, "Text",
      CellTags->"nlug:3.6.4"],
    Cell[414758, 13155, 882, 20, 76, "Text",
      CellTags->"nlug:3.6.4"]},
  "Handling COM Events"->{
    Cell[415677, 13180, 92, 1, 39, "Subsection",
      CellTags->{"Handling COM Events", "nlug:3.6.5"}]},
  "nlug:3.6.5"->{
    Cell[415677, 13180, 92, 1, 39, "Subsection",
      CellTags->{"Handling COM Events", "nlug:3.6.5"}],
    Cell[415772, 13183, 492, 12, 42, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[416267, 13197, 953, 18, 93, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[417223, 13217, 334, 8, 42, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[417582, 13229, 122, 2, 31, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[417707, 13233, 250, 5, 27, "Output",
      CellTags->"nlug:3.6.5"],
    Cell[417972, 13241, 415, 8, 42, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[418390, 13251, 67, 1, 25, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[418460, 13254, 119, 2, 31, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[418582, 13258, 134, 4, 25, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[418719, 13264, 120, 5, 51, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[418842, 13271, 187, 4, 25, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[419054, 13279, 85, 2, 31, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[419142, 13283, 230, 5, 27, "Output",
      CellTags->"nlug:3.6.5"],
    Cell[419387, 13291, 433, 7, 42, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[419823, 13300, 501, 11, 59, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[420349, 13315, 115, 2, 31, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[420467, 13319, 1242, 35, 87, "Output",
      CellTags->"nlug:3.6.5"],
    Cell[421724, 13357, 930, 23, 76, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[422657, 13382, 642, 18, 59, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[423302, 13402, 148, 4, 31, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[423453, 13408, 587, 15, 59, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[424043, 13425, 276, 9, 131, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[424322, 13436, 1141, 30, 93, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[425466, 13468, 97, 2, 31, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[425566, 13472, 240, 5, 42, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[425809, 13479, 90, 1, 25, "Text",
      CellTags->"nlug:3.6.5"],
    Cell[425902, 13482, 116, 5, 65, "Input",
      CellTags->"nlug:3.6.5"],
    Cell[426021, 13489, 248, 7, 25, "Text",
      CellTags->"nlug:3.6.5"]},
  "nlug:3.6.6"->{
    Cell[426306, 13501, 75, 1, 39, "Subsection",
      CellTags->"nlug:3.6.6"],
    Cell[426384, 13504, 1039, 20, 93, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[427426, 13526, 783, 18, 76, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[428212, 13546, 90, 1, 31, "Program",
      CellTags->"nlug:3.6.6"],
    Cell[428305, 13549, 1466, 39, 127, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[429774, 13590, 309, 9, 42, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[430108, 13603, 106, 2, 31, "Input",
      CellTags->"nlug:3.6.6"],
    Cell[430217, 13607, 110, 3, 27, "Output",
      CellTags->"nlug:3.6.6"],
    Cell[430342, 13613, 358, 8, 42, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[430725, 13625, 104, 2, 31, "Input",
      CellTags->"nlug:3.6.6"],
    Cell[430832, 13629, 222, 5, 27, "Output",
      CellTags->"nlug:3.6.6"],
    Cell[431069, 13637, 368, 9, 42, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[431462, 13650, 253, 8, 111, "Input",
      CellTags->"nlug:3.6.6"],
    Cell[431718, 13660, 227, 5, 27, "Output",
      CellTags->"nlug:3.6.6"],
    Cell[431960, 13668, 274, 7, 25, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[432259, 13679, 85, 2, 31, "Input",
      CellTags->"nlug:3.6.6"],
    Cell[432347, 13683, 106, 3, 27, "Output",
      CellTags->"nlug:3.6.6"],
    Cell[432468, 13689, 545, 14, 59, "Text",
      CellTags->"nlug:3.6.6"],
    Cell[433016, 13705, 88, 2, 31, "Input",
      CellTags->"nlug:3.6.6"]},
  "nlug:3.6.7"->{
    Cell[433141, 13712, 61, 1, 39, "Subsection",
      CellTags->"nlug:3.6.7"],
    Cell[433205, 13715, 253, 8, 25, "Text",
      CellTags->"nlug:3.6.7"],
    Cell[433461, 13725, 280, 6, 31, "Input",
      CellTags->"nlug:3.6.7"]},
  "nlug:4.0"->{
    Cell[433947, 13747, 55, 1, 56, "Section",
      CellTags->"nlug:4.0"],
    Cell[434005, 13750, 623, 17, 59, "Text",
      CellTags->"nlug:4.0"],
    Cell[434631, 13769, 1641, 43, 127, "Text",
      CellTags->"nlug:4.0"],
    Cell[436275, 13814, 1016, 24, 93, "Text",
      CellTags->"nlug:4.0"],
    Cell[437294, 13840, 832, 27, 42, "Text",
      CellTags->"nlug:4.0"],
    Cell[438129, 13869, 411, 10, 42, "Text",
      CellTags->"nlug:4.0"]},
  "nlug:4.1"->{
    Cell[438577, 13884, 105, 5, 42, "Section",
      CellTags->"nlug:4.1"],
    Cell[438685, 13891, 858, 21, 93, "Text",
      CellTags->"nlug:4.1"]},
  "nlug:4.2.0"->{
    Cell[439740, 13926, 60, 1, 39, "Subsection",
      CellTags->"nlug:4.2.0"],
    Cell[439803, 13929, 952, 16, 110, "Text",
      CellTags->"nlug:4.2.0"],
    Cell[440758, 13947, 756, 22, 59, "Text",
      CellTags->"nlug:4.2.0"]},
  "nlug:4.2.1"->{
    Cell[441551, 13974, 73, 1, 39, "Subsection",
      CellTags->"nlug:4.2.1"],
    Cell[441627, 13977, 861, 24, 76, "Text",
      CellTags->"nlug:4.2.1"],
    Cell[442491, 14003, 435, 12, 42, "Text",
      CellTags->"nlug:4.2.1"],
    Cell[442929, 14017, 492, 15, 42, "Text",
      CellTags->"nlug:4.2.1"],
    Cell[443424, 14034, 626, 14, 76, "Text",
      CellTags->"nlug:4.2.1"]},
  "nlug:4.2.2"->{
    Cell[444087, 14053, 63, 1, 39, "Subsection",
      CellTags->"nlug:4.2.2"],
    Cell[444153, 14056, 455, 14, 42, "Text",
      CellTags->"nlug:4.2.2"]},
  "nlug:4.2.3"->{
    Cell[444645, 14075, 65, 1, 39, "Subsection",
      CellTags->"nlug:4.2.3"],
    Cell[444713, 14078, 497, 14, 42, "Text",
      CellTags->"nlug:4.2.3"],
    Cell[445213, 14094, 147, 6, 82, "Program",
      CellTags->"nlug:4.2.3"],
    Cell[445363, 14102, 274, 12, 25, "Text",
      CellTags->"nlug:4.2.3"]},
  "nlug:4.2.4"->{
    Cell[445674, 14119, 52, 1, 39, "Subsection",
      CellTags->"nlug:4.2.4"],
    Cell[445729, 14122, 1268, 37, 110, "Text",
      CellTags->"nlug:4.2.4"]},
  "nlug:4.2.5"->{
    Cell[447034, 14164, 58, 1, 39, "Subsection",
      CellTags->"nlug:4.2.5"],
    Cell[447095, 14167, 912, 21, 93, "Text",
      CellTags->"nlug:4.2.5"]},
  "nlug:4.2.6"->{
    Cell[448044, 14193, 62, 1, 39, "Subsection",
      CellTags->"nlug:4.2.6"],
    Cell[448109, 14196, 373, 11, 42, "Text",
      CellTags->"nlug:4.2.6"]},
  "nlug:4.3"->{
    Cell[448531, 14213, 57, 1, 42, "Section",
      CellTags->"nlug:4.3"],
    Cell[448591, 14216, 590, 18, 42, "Text",
      CellTags->"nlug:4.3"]},
  "nlug:4.4.0"->{
    Cell[449293, 14243, 133, 6, 39, "Subsection",
      CellTags->"nlug:4.4.0"],
    Cell[449429, 14251, 1449, 40, 128, "Text",
      CellTags->"nlug:4.4.0"],
    Cell[450881, 14293, 790, 14, 93, "Text",
      CellTags->"nlug:4.4.0"]},
  "nlug:4.4.1"->{
    Cell[451708, 14312, 79, 1, 39, "Subsection",
      CellTags->"nlug:4.4.1"],
    Cell[451790, 14315, 338, 6, 42, "Text",
      CellTags->"nlug:4.4.1"],
    Cell[452131, 14323, 619, 12, 76, "Text",
      CellTags->"nlug:4.4.1"],
    Cell[452753, 14337, 763, 17, 77, "Text",
      CellTags->"nlug:4.4.1"],
    Cell[453519, 14356, 115, 3, 31, "Program",
      CellTags->"nlug:4.4.1"],
    Cell[453637, 14361, 93, 1, 25, "Text",
      CellTags->"nlug:4.4.1"],
    Cell[453733, 14364, 115, 3, 31, "Program",
      CellTags->"nlug:4.4.1"],
    Cell[453851, 14369, 304, 8, 42, "Text",
      CellTags->"nlug:4.4.1"]},
  "nlug:4.4.2"->{
    Cell[454192, 14382, 72, 1, 39, "Subsection",
      CellTags->"nlug:4.4.2"],
    Cell[454267, 14385, 1178, 35, 94, "Text",
      CellTags->"nlug:4.4.2"],
    Cell[455448, 14422, 538, 13, 59, "Text",
      CellTags->"nlug:4.4.2"]},
  "nlug:4.4.3"->{
    Cell[456023, 14440, 66, 1, 39, "Subsection",
      CellTags->"nlug:4.4.3"],
    Cell[456092, 14443, 612, 15, 59, "Text",
      CellTags->"nlug:4.4.3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {".NET/Link", 457601, 14485},
  {"nlug:1.0", 457704, 14488},
  {"nlug:1.1", 458296, 14505},
  {"nlug:1.2", 458662, 14516},
  {"nlug:1.3", 458822, 14521},
  {"nlug:2", 459053, 14528},
  {"nlug:3.0", 459638, 14545},
  {"nlug:3.1.0", 461071, 14586},
  {"nlug:3.1.1", 461311, 14593},
  {"Loading .NET Assemblies and Types", 461803, 14606},
  {"nlug:3.1.2", 461939, 14609},
  {"Loading .NET Assemblies", 465830, 14710},
  {"Conversion of Types Between .NET and Mathematica", 465996, 14713},
  {"nlug:3.1.3", 466155, 14717},
  {"nlug:3.1.4", 466698, 14731},
  {"nlug:3.1.5", 467619, 14756},
  {"nlug:3.1.6", 469919, 14819},
  {"nlug:3.2.0", 472678, 14893},
  {"Enums", 477380, 15019},
  {"nlug:3.2.1", 477489, 15022},
  {"Out and Ref Parameters", 478957, 15061},
  {"nlug:3.2.2", 479085, 15064},
  {"nlug:3.2.3", 480639, 15105},
  {"Overloaded Operators", 483887, 15192},
  {"nlug:3.2.4", 484011, 15195},
  {"Casting", 485038, 15222},
  {"nlug:3.2.5", 485149, 15225},
  {"nlug:3.2.6", 490465, 15367},
  {"Exceptions", 491791, 15403},
  {"nlug:3.2.7", 491905, 15406},
  {"nlug:3.2.8", 493911, 15459},
  {"nlug:3.2.9", 495864, 15512},
  {"nlug:3.2.10", 497555, 15558},
  {".NET Console", 499922, 15622},
  {"nlug:3.2.11", 500040, 15625},
  {"Distributing Applications", 500866, 15646},
  {"nlug:3.2.12", 500998, 15649},
  {"nlug:3.2.13", 501765, 15669},
  {"nlug:3.3.0", 502638, 15692},
  {"Modal versus Modeless", 503124, 15705},
  {"nlug:3.3.1", 503250, 15708},
  {"Handling Events", 504058, 15729},
  {"nlug:3.3.2", 504177, 15732},
  {"Modal Windows", 506828, 15803},
  {"nlug:3.3.3", 506945, 15806},
  {"Modeless Windows", 509145, 15864},
  {"nlug:3.3.4", 509265, 15867},
  {"Sharing the Kernel", 510546, 15900},
  {"nlug:3.3.5", 510669, 15903},
  {"ShowNETWindow", 511545, 15926},
  {"nlug:3.3.6", 511762, 15931},
  {"nlug:3.3.7", 511956, 15936},
  {"nlug:3.3.8", 512459, 15949},
  {"nlug:3.4.0", 513006, 15964},
  {"nlug:3.4.1", 513479, 15977},
  {"nlug:3.4.2", 514182, 15996},
  {"nlug:3.4.3", 515891, 16042},
  {"nlug:3.4.4", 516064, 16047},
  {"nlug:3.4.5", 516773, 16066},
  {"nlug:3.4.6", 517731, 16091},
  {"Calling DLLS from Mathematica", 518176, 16103},
  {"nlug:3.5.0", 518310, 16106},
  {"How DLLs are Found", 519776, 16143},
  {"nlug:3.5.1", 519899, 16146},
  {"Specifying Arguments and Return Values", 520280, 16155},
  {"nlug:3.5.2", 520424, 16158},
  {"strings in DLLs", 527178, 16334},
  {"Declarations Requiring Special Attributes", 527332, 16337},
  {"nlug:3.5.3", 527486, 16341},
  {"DLL Example Files", 528476, 16366},
  {"nlug:3.5.4", 528598, 16369},
  {"COM", 529016, 16380},
  {"COM Introduction", 529112, 16383},
  {"nlug:3.6.0", 529233, 16386},
  {"nlug:3.6.1", 529656, 16397},
  {"Interop Assembly", 532148, 16462},
  {"nlug:3.6.2", 532270, 16465},
  {"nlug:3.6.3", 535815, 16557},
  {"nlug:3.6.4", 537019, 16589},
  {"Handling COM Events", 538573, 16630},
  {"nlug:3.6.5", 538697, 16633},
  {"nlug:3.6.6", 540943, 16692},
  {"nlug:3.6.7", 542413, 16731},
  {"nlug:4.0", 542661, 16738},
  {"nlug:4.1", 543126, 16751},
  {"nlug:4.2.0", 543295, 16756},
  {"nlug:4.2.1", 543547, 16763},
  {"nlug:4.2.2", 543950, 16774},
  {"nlug:4.2.3", 544125, 16779},
  {"nlug:4.2.4", 544454, 16788},
  {"nlug:4.2.5", 544631, 16793},
  {"nlug:4.2.6", 544806, 16798},
  {"nlug:4.3", 544979, 16803},
  {"nlug:4.4.0", 545147, 16808},
  {"nlug:4.4.1", 545401, 16815},
  {"nlug:4.4.2", 546032, 16832},
  {"nlug:4.4.3", 546284, 16839}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 119, 5, 105, "Title"],
Cell[1898, 60, 102, 1, 76, InheritFromParent],
Cell[2003, 63, 233, 7, 250, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2273, 75, 31, 0, 87, "Chapter"],

Cell[CellGroupData[{
Cell[2329, 79, 110, 2, 56, "Section",
  CellTags->{".NET/Link", "nlug:1.0"}],
Cell[2442, 83, 1071, 31, 93, "Text",
  CellTags->"nlug:1.0"],
Cell[3516, 116, 816, 20, 76, "Text",
  CellTags->"nlug:1.0"],
Cell[4335, 138, 356, 8, 42, "Text",
  CellTags->"nlug:1.0"],
Cell[4694, 148, 739, 21, 76, "Text",
  CellTags->"nlug:1.0"],
Cell[5436, 171, 392, 10, 42, "Text",
  CellTags->"nlug:1.0"],
Cell[5831, 183, 627, 15, 76, "Text",
  CellTags->"nlug:1.0"],
Cell[6461, 200, 340, 12, 42, "Text",
  CellTags->"nlug:1.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[6838, 217, 56, 1, 42, "Section",
  CellTags->"nlug:1.1"],
Cell[6897, 220, 519, 9, 76, "Text",
  CellTags->"nlug:1.1"],
Cell[7419, 231, 201, 4, 42, "Text",
  CellTags->"nlug:1.1"],
Cell[7623, 237, 885, 13, 110, "Text",
  CellTags->"nlug:1.1"],
Cell[8511, 252, 262, 5, 42, "Text",
  CellTags->"nlug:1.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[8810, 262, 123, 6, 42, "Section",
  CellTags->"nlug:1.2"],
Cell[8936, 270, 1183, 36, 93, "Text",
  CellTags->"nlug:1.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[10156, 311, 190, 9, 42, "Section",
  CellTags->"nlug:1.3"],
Cell[10349, 322, 1790, 56, 127, "Text",
  CellTags->"nlug:1.3"],
Cell[12142, 380, 279, 9, 25, "Text",
  CellTags->"nlug:1.3"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12470, 395, 53, 1, 87, "Chapter",
  CellTags->"nlug:2"],

Cell[CellGroupData[{
Cell[12548, 400, 105, 2, 35, "Subsubsection",
  CellTags->"nlug:2"],
Cell[12656, 404, 563, 19, 43, "Text",
  CellTags->"nlug:2"],
Cell[13222, 425, 531, 19, 43, "Text",
  CellTags->"nlug:2"],
Cell[13756, 446, 895, 33, 59, "Text",
  CellTags->"nlug:2"],
Cell[14654, 481, 492, 15, 42, "Text",
  CellTags->"nlug:2"]
}, Closed]],

Cell[CellGroupData[{
Cell[15183, 501, 69, 1, 35, "Subsubsection",
  CellTags->"nlug:2"],
Cell[15255, 504, 564, 14, 59, "Text",
  CellTags->"nlug:2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15868, 524, 197, 7, 52, "Chapter"],

Cell[CellGroupData[{
Cell[16090, 535, 55, 1, 56, "Section",
  CellTags->"nlug:3.0"],
Cell[16148, 538, 801, 21, 76, "Text",
  CellTags->"nlug:3.0"],
Cell[16952, 561, 660, 18, 59, "Text",
  CellTags->"nlug:3.0"],
Cell[17615, 581, 687, 15, 76, "Text",
  CellTags->"nlug:3.0"],
Cell[18305, 598, 567, 14, 59, "Text",
  CellTags->"nlug:3.0"],
Cell[18875, 614, 590, 17, 59, "Text",
  CellTags->"nlug:3.0"],
Cell[19468, 633, 98, 2, 25, "Text",
  CellTags->"nlug:3.0"],
Cell[19569, 637, 265, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[19837, 645, 95, 2, 25, "Text",
  CellTags->"nlug:3.0"],
Cell[19935, 649, 285, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[20223, 657, 286, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[20512, 665, 294, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[20809, 673, 288, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[21100, 681, 303, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[21406, 689, 95, 2, 25, "Text",
  CellTags->"nlug:3.0"],
Cell[21504, 693, 282, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[21789, 701, 277, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[22069, 709, 276, 6, 31, "Input",
  CellTags->"nlug:3.0"],
Cell[22348, 717, 102, 2, 25, "Text",
  CellTags->"nlug:3.0"],
Cell[22453, 721, 278, 6, 31, "Input",
  CellTags->"nlug:3.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[22768, 732, 92, 4, 42, "Section"],

Cell[CellGroupData[{
Cell[22885, 740, 76, 1, 39, "Subsection",
  CellTags->"nlug:3.1.0"],
Cell[22964, 743, 217, 9, 25, "Text",
  CellTags->"nlug:3.1.0"],
Cell[23184, 754, 86, 2, 31, "Input",
  CellTags->"nlug:3.1.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[23307, 761, 74, 1, 39, "Subsection",
  CellTags->"nlug:3.1.1"],
Cell[23384, 764, 145, 5, 25, "Text",
  CellTags->"nlug:3.1.1"],
Cell[23532, 771, 80, 2, 31, "Input",
  CellTags->"nlug:3.1.1"],
Cell[23615, 775, 801, 19, 76, "Text",
  CellTags->"nlug:3.1.1"],
Cell[24419, 796, 863, 23, 96, "DefinitionBox",
  CellTags->"nlug:3.1.1"],
Cell[25285, 821, 72, 1, 17, "Caption",
  CellTags->"nlug:3.1.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[25394, 827, 120, 1, 39, "Subsection",
  CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"}],

Cell[CellGroupData[{
Cell[25539, 832, 95, 1, 35, "Subsubsection",
  CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"}],
Cell[25637, 835, 1014, 18, 110, "Text",
  CellTags->"nlug:3.1.2"],
Cell[26654, 855, 769, 14, 93, "Text",
  CellTags->"nlug:3.1.2"],
Cell[27426, 871, 1196, 25, 127, "Text",
  CellTags->"nlug:3.1.2"],
Cell[28625, 898, 1069, 30, 93, "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[29731, 933, 61, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.2"],
Cell[29795, 936, 463, 10, 59, "Text",
  CellTags->"nlug:3.1.2"],
Cell[30261, 948, 642, 18, 59, "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[30940, 971, 66, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.2"],
Cell[31009, 974, 657, 18, 59, "Text",
  CellTags->"nlug:3.1.2"],
Cell[31669, 994, 3441, 113, 202, "DefinitionBox",
  CellTags->"nlug:3.1.2"],
Cell[35113, 1109, 64, 1, 17, "Caption",
  CellTags->"nlug:3.1.2"],
Cell[35180, 1112, 185, 5, 25, "Text",
  CellTags->"nlug:3.1.2"],

Cell[CellGroupData[{
Cell[35390, 1121, 98, 2, 31, "Input",
  CellTags->"nlug:3.1.2"],
Cell[35491, 1125, 112, 3, 27, "Output",
  CellTags->"nlug:3.1.2"]
}, Open  ]],
Cell[35618, 1131, 422, 12, 42, "Text",
  CellTags->"nlug:3.1.2"],
Cell[36043, 1145, 611, 15, 59, "Text",
  CellTags->"nlug:3.1.2"],

Cell[CellGroupData[{
Cell[36679, 1164, 178, 5, 31, "Input",
  CellTags->"nlug:3.1.2"],
Cell[36860, 1171, 112, 3, 27, "Output",
  CellTags->"nlug:3.1.2"]
}, Open  ]],
Cell[36987, 1177, 178, 4, 25, "Text",
  CellTags->"nlug:3.1.2"],
Cell[37168, 1183, 493, 14, 59, "Text",
  CellTags->"nlug:3.1.2"],
Cell[37664, 1199, 115, 2, 31, "Input",
  CellTags->"nlug:3.1.2"],
Cell[37782, 1203, 151, 4, 25, "Text",
  CellTags->"nlug:3.1.2"],
Cell[37936, 1209, 1300, 39, 111, "Text",
  CellTags->"nlug:3.1.2"],
Cell[39239, 1250, 95, 1, 31, "Input",
  CellTags->"nlug:3.1.2"],
Cell[39337, 1253, 260, 5, 42, "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[39634, 1263, 62, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.2"],
Cell[39699, 1266, 997, 26, 93, "Text",
  CellTags->"nlug:3.1.2"],
Cell[40699, 1294, 2761, 88, 148, "DefinitionBox",
  CellTags->"nlug:3.1.2"],
Cell[43463, 1384, 59, 1, 17, "Caption",
  CellTags->"nlug:3.1.2"],
Cell[43525, 1387, 126, 5, 25, "Text",
  CellTags->"nlug:3.1.2"],

Cell[CellGroupData[{
Cell[43676, 1396, 109, 2, 31, "Input",
  CellTags->"nlug:3.1.2"],
Cell[43788, 1400, 123, 3, 27, "Output",
  CellTags->"nlug:3.1.2"]
}, Open  ]],
Cell[43926, 1406, 403, 12, 42, "Text",
  CellTags->"nlug:3.1.2"],
Cell[44332, 1420, 621, 15, 76, "Text",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[44990, 1440, 86, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.2"],
Cell[45079, 1443, 371, 10, 42, "Text",
  CellTags->"nlug:3.1.2"],
Cell[45453, 1455, 554, 18, 60, "DefinitionBox",
  CellTags->"nlug:3.1.2"],
Cell[46010, 1475, 81, 1, 17, "Caption",
  CellTags->"nlug:3.1.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[46128, 1481, 97, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.2"],
Cell[46228, 1484, 1223, 26, 127, "Text",
  CellTags->"nlug:3.1.2"],
Cell[47454, 1512, 1628, 38, 144, "Text",
  CellTags->"nlug:3.1.2"],
Cell[49085, 1552, 1339, 33, 110, "Text",
  CellTags->"nlug:3.1.2"],
Cell[50427, 1587, 578, 11, 59, "Text",
  CellTags->"nlug:3.1.2"],
Cell[51008, 1600, 133, 5, 65, "Program",
  CellTags->"nlug:3.1.2"],
Cell[51144, 1607, 338, 11, 42, "Text",
  CellTags->"nlug:3.1.2"],
Cell[51485, 1620, 283, 8, 42, "Text",
  CellTags->"nlug:3.1.2"],
Cell[51771, 1630, 738, 21, 86, "DefinitionBox",
  CellTags->"nlug:3.1.2"],
Cell[52512, 1653, 113, 5, 17, "Caption",
  CellTags->"nlug:3.1.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52674, 1664, 217, 7, 39, "Subsection",
  CellTags->{
  "Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"}],
Cell[52894, 1673, 1101, 29, 93, "Text",
  CellTags->"nlug:3.1.3"],
Cell[53998, 1704, 463, 13, 42, "Text",
  CellTags->"nlug:3.1.3"],
Cell[54464, 1719, 1029, 27, 314, "DefinitionBox",
  CellTags->"nlug:3.1.3"],
Cell[55496, 1748, 174, 6, 17, "Caption",
  CellTags->"nlug:3.1.3"],
Cell[55673, 1756, 562, 16, 59, "Text",
  CellTags->"nlug:3.1.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[56272, 1777, 64, 1, 39, "Subsection",
  CellTags->"nlug:3.1.4"],
Cell[56339, 1780, 576, 13, 59, "Text",
  CellTags->"nlug:3.1.4"],
Cell[56918, 1795, 1739, 56, 70, "DefinitionBox",
  CellTags->"nlug:3.1.4"],
Cell[58660, 1853, 71, 1, 17, "Caption",
  CellTags->"nlug:3.1.4"],
Cell[58734, 1856, 127, 5, 25, "Text",
  CellTags->"nlug:3.1.4"],

Cell[CellGroupData[{
Cell[58886, 1865, 129, 3, 29, "Input",
  CellTags->"nlug:3.1.4"],
Cell[59018, 1870, 229, 5, 27, "Output",
  CellTags->"nlug:3.1.4"]
}, Open  ]],
Cell[59262, 1878, 860, 21, 93, "Text",
  CellTags->"nlug:3.1.4"],
Cell[60125, 1901, 867, 20, 93, "Text",
  CellTags->"nlug:3.1.4"],
Cell[60995, 1923, 402, 9, 42, "Text",
  CellTags->"nlug:3.1.4"],
Cell[61400, 1934, 190, 4, 49, "Input",
  CellTags->"nlug:3.1.4"],
Cell[61593, 1940, 457, 12, 42, "Text",
  CellTags->"nlug:3.1.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[62087, 1957, 87, 1, 39, "Subsection",
  CellTags->"nlug:3.1.5"],

Cell[CellGroupData[{
Cell[62199, 1962, 57, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.5"],
Cell[62259, 1965, 755, 15, 76, "Text",
  CellTags->"nlug:3.1.5"],
Cell[63017, 1982, 613, 13, 59, "Text",
  CellTags->"nlug:3.1.5"],
Cell[63633, 1997, 2563, 70, 454, "DefinitionBox",
  CellTags->"nlug:3.1.5"],
Cell[66199, 2069, 126, 5, 17, "Caption",
  CellTags->"nlug:3.1.5"],
Cell[66328, 2076, 636, 18, 59, "Text",
  CellTags->"nlug:3.1.5"],
Cell[66967, 2096, 181, 4, 69, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"],
Cell[67151, 2102, 231, 6, 25, "Text",
  CellTags->"nlug:3.1.5"],
Cell[67385, 2110, 383, 10, 42, "Text",
  CellTags->"nlug:3.1.5"],
Cell[67771, 2122, 1177, 31, 110, "Text",
  CellTags->"nlug:3.1.5"],

Cell[CellGroupData[{
Cell[68973, 2157, 122, 3, 29, "Input",
  CellTags->"nlug:3.1.5"],
Cell[69098, 2162, 216, 5, 27, "Output",
  CellTags->"nlug:3.1.5"]
}, Open  ]],
Cell[69329, 2170, 457, 16, 42, "Text",
  CellTags->"nlug:3.1.5"],
Cell[69789, 2188, 108, 3, 29, "Input",
  CellTags->"nlug:3.1.5"],
Cell[69900, 2193, 201, 7, 25, "Text",
  CellTags->"nlug:3.1.5"],
Cell[70104, 2202, 116, 4, 29, "Input",
  CellTags->"nlug:3.1.5"],
Cell[70223, 2208, 1140, 30, 93, "Text",
  CellTags->"nlug:3.1.5"],
Cell[71366, 2240, 693, 13, 76, "Text",
  CellTags->"nlug:3.1.5"],
Cell[72062, 2255, 153, 4, 49, "Input",
  CellTags->"nlug:3.1.5"],
Cell[72218, 2261, 749, 17, 76, "Text",
  CellTags->"nlug:3.1.5"],
Cell[72970, 2280, 108, 3, 29, "Input",
  CellTags->"nlug:3.1.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[73115, 2288, 76, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.5"],
Cell[73194, 2291, 644, 13, 76, "Text",
  CellTags->"nlug:3.1.5"],
Cell[73841, 2306, 176, 4, 49, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"],
Cell[74020, 2312, 186, 4, 25, "Text",
  CellTags->"nlug:3.1.5"],
Cell[74209, 2318, 109, 3, 29, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"],
Cell[74321, 2323, 231, 6, 25, "Text",
  CellTags->"nlug:3.1.5"],
Cell[74555, 2331, 122, 4, 29, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[74726, 2341, 91, 1, 39, "Subsection",
  CellTags->"nlug:3.1.6"],

Cell[CellGroupData[{
Cell[74842, 2346, 62, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.6"],
Cell[74907, 2349, 353, 9, 42, "Text",
  CellTags->"nlug:3.1.6"],
Cell[75263, 2360, 3139, 106, 182, "DefinitionBox",
  CellTags->"nlug:3.1.6"],
Cell[78405, 2468, 89, 1, 17, "Caption",
  CellTags->"nlug:3.1.6"],
Cell[78497, 2471, 145, 4, 25, "Text",
  CellTags->"nlug:3.1.6"],
Cell[78645, 2477, 149, 5, 25, "Text",
  CellTags->"nlug:3.1.6"],
Cell[78797, 2484, 86, 1, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[78886, 2487, 552, 18, 59, "Text",
  CellTags->"nlug:3.1.6"],
Cell[79441, 2507, 125, 3, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[79569, 2512, 117, 3, 25, "Text",
  CellTags->"nlug:3.1.6"],
Cell[79689, 2517, 121, 3, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[79813, 2522, 232, 6, 42, "Text",
  CellTags->"nlug:3.1.6"],
Cell[80048, 2530, 129, 4, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[80180, 2536, 1169, 29, 134, "DefinitionBox3Col",
  CellTags->"nlug:3.1.6"],
Cell[81352, 2567, 113, 5, 17, "Caption",
  CellTags->"nlug:3.1.6"],
Cell[81468, 2574, 369, 7, 59, "Text",
  CellTags->"nlug:3.1.6"],
Cell[81840, 2583, 88, 1, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[81931, 2586, 539, 17, 59, "Text",
  CellTags->"nlug:3.1.6"],
Cell[82473, 2605, 141, 4, 31, "Input",
  CellTags->"nlug:3.1.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[82651, 2614, 73, 1, 35, "Subsubsection",
  CellTags->"nlug:3.1.6"],
Cell[82727, 2617, 2825, 86, 108, "DefinitionBox",
  CellTags->"nlug:3.1.6"],
Cell[85555, 2705, 86, 1, 17, "Caption",
  CellTags->"nlug:3.1.6"],
Cell[85644, 2708, 240, 6, 42, "Text",
  CellTags->"nlug:3.1.6"],
Cell[85887, 2716, 88, 2, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.1.6"],
Cell[85978, 2720, 1083, 34, 93, "Text",
  CellTags->"nlug:3.1.6"],

Cell[CellGroupData[{
Cell[87086, 2758, 113, 2, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[87202, 2762, 117, 3, 27, "Output",
  CellTags->"nlug:3.1.6"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87356, 2770, 99, 2, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[87458, 2774, 229, 5, 27, "Output",
  CellTags->"nlug:3.1.6"]
}, Open  ]],
Cell[87702, 2782, 517, 19, 42, "Text",
  CellTags->"nlug:3.1.6"],
Cell[88222, 2803, 214, 7, 25, "Text",
  CellTags->"nlug:3.1.6"],

Cell[CellGroupData[{
Cell[88461, 2814, 83, 2, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[88547, 2818, 105, 3, 27, "Output",
  CellTags->"nlug:3.1.6"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88689, 2826, 89, 2, 31, "Input",
  CellTags->"nlug:3.1.6"],
Cell[88781, 2830, 88, 3, 27, "Output",
  CellTags->"nlug:3.1.6"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[88942, 2841, 33, 0, 56, "Section"],

Cell[CellGroupData[{
Cell[89000, 2845, 86, 1, 39, "Subsection",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[89111, 2850, 140, 5, 35, "Subsubsection",
  CellTags->"nlug:3.2.0"],
Cell[89254, 2857, 1061, 27, 93, "Text",
  CellTags->"nlug:3.2.0"],
Cell[90318, 2886, 1175, 32, 110, "Text",
  CellTags->"nlug:3.2.0"],
Cell[91496, 2920, 969, 31, 62, "DefinitionBox",
  CellTags->"nlug:3.2.0"],
Cell[92468, 2953, 122, 5, 17, "Caption",
  CellTags->"nlug:3.2.0"],
Cell[92593, 2960, 61, 1, 25, "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[92679, 2965, 134, 3, 29, "Input",
  CellTags->"nlug:3.2.0"],
Cell[92816, 2970, 216, 5, 27, "Output",
  CellTags->"nlug:3.2.0"]
}, Open  ]],
Cell[93047, 2978, 222, 7, 25, "Text",
  CellTags->"nlug:3.2.0"],
Cell[93272, 2987, 175, 4, 49, "Input",
  CellTags->"nlug:3.2.0"],
Cell[93450, 2993, 182, 5, 25, "Text",
  CellTags->"nlug:3.2.0"],
Cell[93635, 3000, 100, 3, 29, "Input",
  CellTags->"nlug:3.2.0"],
Cell[93738, 3005, 709, 20, 59, "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[94472, 3029, 80, 2, 31, "Input",
  CellTags->"nlug:3.2.0"],
Cell[94555, 3033, 89, 3, 27, "Output",
  CellTags->"nlug:3.2.0"]
}, Open  ]],
Cell[94659, 3039, 418, 15, 42, "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[95102, 3058, 90, 2, 31, "Input",
  CellTags->"nlug:3.2.0"],
Cell[95195, 3062, 88, 3, 27, "Output",
  CellTags->"nlug:3.2.0"]
}, Open  ]],
Cell[95298, 3068, 315, 8, 42, "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[95638, 3080, 84, 2, 31, "Input",
  CellTags->"nlug:3.2.0"],
Cell[95725, 3084, 88, 3, 27, "Output",
  CellTags->"nlug:3.2.0"]
}, Open  ]],
Cell[95828, 3090, 668, 17, 59, "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[96521, 3111, 100, 2, 31, "Input",
  CellTags->"nlug:3.2.0"],
Cell[96624, 3115, 88, 3, 27, "Output",
  CellTags->"nlug:3.2.0"]
}, Open  ]],
Cell[96727, 3121, 236, 8, 25, "Text",
  CellTags->"nlug:3.2.0"],
Cell[96966, 3131, 738, 18, 76, "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[97741, 3154, 67, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.0"],
Cell[97811, 3157, 1486, 34, 127, "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[99322, 3195, 128, 3, 29, "Input",
  CellTags->"nlug:3.2.0"],
Cell[99453, 3200, 229, 5, 27, "Output",
  CellTags->"nlug:3.2.0"]
}, Open  ]],
Cell[99697, 3208, 179, 6, 25, "Text",
  CellTags->"nlug:3.2.0"],
Cell[99879, 3216, 105, 3, 29, "Input",
  CellTags->"nlug:3.2.0"],
Cell[99987, 3221, 338, 9, 42, "Text",
  CellTags->"nlug:3.2.0"],

Cell[CellGroupData[{
Cell[100350, 3234, 76, 2, 31, "Input",
  CellTags->"nlug:3.2.0"],
Cell[100429, 3238, 197, 6, 27, "Output",
  CellTags->"nlug:3.2.0"]
}, Open  ]],
Cell[100641, 3247, 2357, 66, 178, "DefinitionBox",
  CellTags->"nlug:3.2.0"],
Cell[103001, 3315, 73, 1, 17, "Caption",
  CellTags->"nlug:3.2.0"],
Cell[103077, 3318, 452, 11, 59, "Text",
  CellTags->"nlug:3.2.0"],
Cell[103532, 3331, 607, 16, 59, "Text",
  CellTags->"nlug:3.2.0"],
Cell[104142, 3349, 173, 4, 49, "Input",
  CellTags->"nlug:3.2.0"],
Cell[104318, 3355, 450, 15, 42, "Text",
  CellTags->"nlug:3.2.0"],
Cell[104771, 3372, 531, 11, 59, "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[105339, 3388, 59, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.0"],
Cell[105401, 3391, 419, 9, 59, "Text",
  CellTags->"nlug:3.2.0"],
Cell[105823, 3402, 1205, 29, 110, "Text",
  CellTags->"nlug:3.2.0"],
Cell[107031, 3433, 632, 13, 59, "Text",
  CellTags->"nlug:3.2.0"],
Cell[107666, 3448, 654, 14, 76, "Text",
  CellTags->"nlug:3.2.0"],
Cell[108323, 3464, 153, 6, 25, "Text",
  CellTags->"nlug:3.2.0"],
Cell[108479, 3472, 203, 8, 25, "Text",
  CellTags->"nlug:3.2.0"],
Cell[108685, 3482, 258, 5, 129, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.0"],
Cell[108946, 3489, 386, 10, 42, "Text",
  CellTags->"nlug:3.2.0"],
Cell[109335, 3501, 435, 9, 189, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.0"],
Cell[109773, 3512, 1171, 33, 110, "Text",
  CellTags->"nlug:3.2.0"],
Cell[110947, 3547, 2483, 88, 60, "DefinitionBox",
  CellTags->"nlug:3.2.0"],
Cell[113433, 3637, 132, 5, 17, "Caption",
  CellTags->"nlug:3.2.0"],
Cell[113568, 3644, 197, 5, 25, "Text",
  CellTags->"nlug:3.2.0"],
Cell[113768, 3651, 382, 14, 231, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.0"],
Cell[114153, 3667, 1081, 29, 93, "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[115271, 3701, 67, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.0"],
Cell[115341, 3704, 926, 24, 93, "Text",
  CellTags->"nlug:3.2.0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[116316, 3734, 64, 1, 39, "Subsection",
  CellTags->{"Enums", "nlug:3.2.1"}],
Cell[116383, 3737, 860, 19, 93, "Text",
  CellTags->"nlug:3.2.1"],
Cell[117246, 3758, 584, 16, 59, "Text",
  CellTags->"nlug:3.2.1"],

Cell[CellGroupData[{
Cell[117855, 3778, 118, 2, 31, "Input",
  CellTags->"nlug:3.2.1"],
Cell[117976, 3782, 132, 3, 27, "Output",
  CellTags->"nlug:3.2.1"]
}, Open  ]],
Cell[118123, 3788, 118, 3, 25, "Text",
  CellTags->"nlug:3.2.1"],

Cell[CellGroupData[{
Cell[118266, 3795, 84, 2, 31, "Input",
  CellTags->"nlug:3.2.1"],
Cell[118353, 3799, 237, 5, 27, "Output",
  CellTags->"nlug:3.2.1"]
}, Open  ]],
Cell[118605, 3807, 403, 10, 42, "Text",
  CellTags->"nlug:3.2.1"],

Cell[CellGroupData[{
Cell[119033, 3821, 107, 2, 31, "Input",
  CellTags->"nlug:3.2.1"],
Cell[119143, 3825, 86, 3, 27, "Output",
  CellTags->"nlug:3.2.1"]
}, Open  ]],
Cell[119244, 3831, 69, 1, 25, "Text",
  CellTags->"nlug:3.2.1"],
Cell[119316, 3834, 98, 2, 31, "Input",
  CellTags->"nlug:3.2.1"],
Cell[119417, 3838, 288, 6, 42, "Text",
  CellTags->"nlug:3.2.1"],
Cell[119708, 3846, 83, 2, 31, "Input",
  CellTags->"nlug:3.2.1"],
Cell[119794, 3850, 435, 12, 59, "Text",
  CellTags->"nlug:3.2.1"],
Cell[120232, 3864, 114, 4, 48, "Program",
  CellTags->"nlug:3.2.1"],
Cell[120349, 3870, 401, 12, 42, "Text",
  CellTags->"nlug:3.2.1"],
Cell[120753, 3884, 180, 5, 31, "Input",
  CellTags->"nlug:3.2.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[120970, 3894, 314, 10, 39, "Subsection",
  CellTags->{"Out and Ref Parameters", "nlug:3.2.2"}],
Cell[121287, 3906, 1210, 31, 110, "Text",
  CellTags->"nlug:3.2.2"],
Cell[122500, 3939, 190, 7, 25, "Text",
  CellTags->"nlug:3.2.2"],
Cell[122693, 3948, 232, 8, 99, "Program",
  CellTags->"nlug:3.2.2"],
Cell[122928, 3958, 863, 23, 76, "Text",
  CellTags->"nlug:3.2.2"],
Cell[123794, 3983, 560, 15, 59, "Text",
  CellTags->"nlug:3.2.2"],
Cell[124357, 4000, 151, 4, 25, "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{
Cell[124533, 4008, 150, 7, 91, "Input",
  CellTags->"nlug:3.2.2"],
Cell[124686, 4017, 87, 3, 27, "Output",
  CellTags->"nlug:3.2.2"]
}, Open  ]],
Cell[124788, 4023, 225, 6, 25, "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{
Cell[125038, 4033, 71, 2, 31, "Input",
  CellTags->"nlug:3.2.2"],
Cell[125112, 4037, 86, 3, 27, "Output",
  CellTags->"nlug:3.2.2"]
}, Open  ]],
Cell[125213, 4043, 207, 6, 25, "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{
Cell[125445, 4053, 123, 5, 51, "Input",
  CellTags->"nlug:3.2.2"],
Cell[125571, 4060, 193, 5, 20, "Message",
  CellTags->"nlug:3.2.2"],
Cell[125767, 4067, 92, 3, 27, "Output",
  CellTags->"nlug:3.2.2"]
}, Open  ]],
Cell[125874, 4073, 594, 15, 59, "Text",
  CellTags->"nlug:3.2.2"],
Cell[126471, 4090, 399, 11, 42, "Text",
  CellTags->"nlug:3.2.2"],

Cell[CellGroupData[{
Cell[126895, 4105, 101, 2, 31, "Input",
  CellTags->"nlug:3.2.2"],
Cell[126999, 4109, 87, 3, 27, "Output",
  CellTags->"nlug:3.2.2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[127135, 4118, 307, 10, 39, "Subsection",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[127467, 4132, 72, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.3"],
Cell[127542, 4135, 1474, 42, 127, "Text",
  CellTags->"nlug:3.2.3"],
Cell[129019, 4179, 750, 15, 59, "Text",
  CellTags->"nlug:3.2.3"],
Cell[129772, 4196, 484, 11, 59, "Text",
  CellTags->"nlug:3.2.3"],
Cell[130259, 4209, 1870, 63, 66, "DefinitionBox",
  CellTags->"nlug:3.2.3"],
Cell[132132, 4274, 295, 10, 18, "Caption",
  CellTags->"nlug:3.2.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[132464, 4289, 68, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.3"],
Cell[132535, 4292, 555, 13, 59, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[133115, 4309, 220, 5, 49, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],
Cell[133338, 4316, 126, 4, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]],
Cell[133479, 4323, 453, 14, 42, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[133957, 4341, 151, 4, 29, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],
Cell[134111, 4347, 134, 4, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]],
Cell[134260, 4354, 1142, 27, 110, "Text",
  CellTags->"nlug:3.2.3"],
Cell[135405, 4383, 282, 7, 42, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[135712, 4394, 159, 4, 29, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],
Cell[135874, 4400, 221, 5, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]],
Cell[136110, 4408, 144, 5, 25, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[136279, 4417, 177, 5, 29, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.3"],
Cell[136459, 4424, 134, 4, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]],
Cell[136608, 4431, 505, 13, 59, "Text",
  CellTags->"nlug:3.2.3"],
Cell[137116, 4446, 848, 18, 76, "Text",
  CellTags->"nlug:3.2.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[138001, 4469, 72, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.3"],
Cell[138076, 4472, 486, 11, 59, "Text",
  CellTags->"nlug:3.2.3"],
Cell[138565, 4485, 944, 24, 93, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[139534, 4513, 128, 3, 29, "Input",
  CellTags->"nlug:3.2.3"],
Cell[139665, 4518, 224, 5, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]],
Cell[139904, 4526, 164, 6, 25, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[140093, 4536, 91, 2, 31, "Input",
  CellTags->"nlug:3.2.3"],
Cell[140187, 4540, 89, 3, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]],
Cell[140291, 4546, 325, 10, 42, "Text",
  CellTags->"nlug:3.2.3"],
Cell[140619, 4558, 854, 22, 76, "Text",
  CellTags->"nlug:3.2.3"],
Cell[141476, 4582, 75, 1, 25, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[141576, 4587, 119, 2, 31, "Input",
  CellTags->"nlug:3.2.3"],
Cell[141698, 4591, 232, 5, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]],
Cell[141945, 4599, 70, 1, 25, "Text",
  CellTags->"nlug:3.2.3"],
Cell[142018, 4602, 98, 2, 31, "Input",
  CellTags->"nlug:3.2.3"],
Cell[142119, 4606, 142, 4, 25, "Text",
  CellTags->"nlug:3.2.3"],

Cell[CellGroupData[{
Cell[142286, 4614, 99, 2, 31, "Input",
  CellTags->"nlug:3.2.3"],
Cell[142388, 4618, 115, 3, 27, "Output",
  CellTags->"nlug:3.2.3"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[142564, 4628, 94, 1, 39, "Subsection",
  CellTags->{"Overloaded Operators", "nlug:3.2.4"}],
Cell[142661, 4631, 658, 16, 76, "Text",
  CellTags->"nlug:3.2.4"],
Cell[143322, 4649, 223, 6, 82, "Program",
  CellTags->"nlug:3.2.4"],
Cell[143548, 4657, 459, 10, 59, "Text",
  CellTags->"nlug:3.2.4"],
Cell[144010, 4669, 396, 13, 42, "Text",
  CellTags->"nlug:3.2.4"],

Cell[CellGroupData[{
Cell[144431, 4686, 197, 7, 91, "Input",
  CellTags->"nlug:3.2.4"],
Cell[144631, 4695, 95, 3, 27, "Output",
  CellTags->"nlug:3.2.4"]
}, Open  ]],
Cell[144741, 4701, 880, 21, 93, "Text",
  CellTags->"nlug:3.2.4"],

Cell[CellGroupData[{
Cell[145646, 4726, 123, 2, 31, "Input",
  CellTags->"nlug:3.2.4"],
Cell[145772, 4730, 2265, 55, 247, "Output",
  CellTags->"nlug:3.2.4"]
}, Open  ]],
Cell[148052, 4788, 537, 16, 59, "Text",
  CellTags->"nlug:3.2.4"],

Cell[CellGroupData[{
Cell[148614, 4808, 107, 2, 31, "Input",
  CellTags->"nlug:3.2.4"],
Cell[148724, 4812, 95, 3, 27, "Output",
  CellTags->"nlug:3.2.4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[148868, 4821, 68, 1, 39, "Subsection",
  CellTags->{"Casting", "nlug:3.2.5"}],

Cell[CellGroupData[{
Cell[148961, 4826, 63, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.5"],
Cell[149027, 4829, 829, 18, 93, "Text",
  CellTags->"nlug:3.2.5"],
Cell[149859, 4849, 164, 7, 99, "Program",
  CellTags->"nlug:3.2.5"],
Cell[150026, 4858, 507, 13, 59, "Text",
  CellTags->"nlug:3.2.5"],
Cell[150536, 4873, 260, 14, 218, "Program",
  CellTags->"nlug:3.2.5"],
Cell[150799, 4889, 233, 7, 25, "Text",
  CellTags->"nlug:3.2.5"],
Cell[151035, 4898, 455, 13, 59, "Text",
  CellTags->"nlug:3.2.5"],
Cell[151493, 4913, 1467, 38, 127, "Text",
  CellTags->"nlug:3.2.5"],
Cell[152963, 4953, 701, 18, 76, "Text",
  CellTags->"nlug:3.2.5"],
Cell[153667, 4973, 678, 19, 59, "Text",
  CellTags->"nlug:3.2.5"],
Cell[154348, 4994, 388, 9, 65, "ItemizedText",
  CellTags->"nlug:3.2.5"],
Cell[154739, 5005, 529, 10, 59, "Text",
  CellTags->"nlug:3.2.5"],
Cell[155271, 5017, 662, 13, 76, "Text",
  CellTags->"nlug:3.2.5"],
Cell[155936, 5032, 1773, 53, 66, "DefinitionBox",
  CellTags->"nlug:3.2.5"],
Cell[157712, 5087, 120, 5, 17, "Caption",
  CellTags->"nlug:3.2.5"],
Cell[157835, 5094, 192, 8, 25, "Text",
  CellTags->"nlug:3.2.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[158064, 5107, 93, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.5"],
Cell[158160, 5110, 311, 8, 42, "Text",
  CellTags->"nlug:3.2.5"],
Cell[158474, 5120, 223, 10, 150, "Program",
  CellTags->"nlug:3.2.5"],
Cell[158700, 5132, 364, 13, 42, "Text",
  CellTags->"nlug:3.2.5"],
Cell[159067, 5147, 225, 6, 82, "Program",
  CellTags->"nlug:3.2.5"],
Cell[159295, 5155, 445, 14, 42, "Text",
  CellTags->"nlug:3.2.5"],
Cell[159743, 5171, 376, 14, 42, "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{
Cell[160144, 5189, 114, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],
Cell[160261, 5194, 216, 5, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160514, 5204, 134, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],
Cell[160651, 5209, 217, 5, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160905, 5219, 105, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],
Cell[161013, 5224, 96, 3, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],
Cell[161124, 5230, 96, 1, 25, "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{
Cell[161245, 5235, 119, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],
Cell[161367, 5240, 88, 3, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[161504, 5249, 84, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.5"],
Cell[161591, 5252, 927, 21, 93, "Text",
  CellTags->"nlug:3.2.5"],
Cell[162521, 5275, 575, 30, 490, "Program",
  CellTags->"nlug:3.2.5"],
Cell[163099, 5307, 345, 11, 42, "Text",
  CellTags->"nlug:3.2.5"],
Cell[163447, 5320, 201, 5, 65, "Program",
  CellTags->"nlug:3.2.5"],
Cell[163651, 5327, 158, 6, 25, "Text",
  CellTags->"nlug:3.2.5"],
Cell[163812, 5335, 237, 6, 71, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],
Cell[164052, 5343, 737, 20, 76, "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{
Cell[164814, 5367, 100, 2, 31, "Input",
  CellTags->"nlug:3.2.5"],
Cell[164917, 5371, 218, 5, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[165172, 5381, 82, 2, 31, "Input",
  CellTags->"nlug:3.2.5"],
Cell[165257, 5385, 214, 5, 20, "Message",
  CellTags->"nlug:3.2.5"],
Cell[165474, 5392, 91, 3, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],
Cell[165580, 5398, 116, 5, 25, "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{
Cell[165721, 5407, 128, 2, 31, "Input",
  CellTags->"nlug:3.2.5"],
Cell[165852, 5411, 89, 3, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[165990, 5420, 82, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.5"],
Cell[166075, 5423, 1058, 23, 110, "Text",
  CellTags->"nlug:3.2.5"],
Cell[167136, 5448, 330, 9, 42, "Text",
  CellTags->"nlug:3.2.5"],
Cell[167469, 5459, 162, 9, 133, "Program",
  CellTags->"nlug:3.2.5"],
Cell[167634, 5470, 244, 7, 25, "Text",
  CellTags->"nlug:3.2.5"],
Cell[167881, 5479, 149, 5, 65, "Program",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{
Cell[168055, 5488, 155, 6, 51, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],
Cell[168213, 5496, 227, 5, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],
Cell[168455, 5504, 233, 7, 25, "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{
Cell[168713, 5515, 76, 2, 31, "Input",
  CellTags->"nlug:3.2.5"],
Cell[168792, 5519, 263, 7, 20, "Message",
  CellTags->"nlug:3.2.5"],
Cell[169058, 5528, 91, 3, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],
Cell[169164, 5534, 765, 20, 76, "Text",
  CellTags->"nlug:3.2.5"],
Cell[169932, 5556, 123, 5, 65, "Program",
  CellTags->"nlug:3.2.5"],
Cell[170058, 5563, 403, 11, 42, "Text",
  CellTags->"nlug:3.2.5"],

Cell[CellGroupData[{
Cell[170486, 5578, 144, 6, 51, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.5"],
Cell[170633, 5586, 86, 3, 27, "Output",
  CellTags->"nlug:3.2.5"]
}, Open  ]],
Cell[170734, 5592, 993, 16, 110, "Text",
  CellTags->"nlug:3.2.5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[171776, 5614, 56, 1, 39, "Subsection",
  CellTags->"nlug:3.2.6"],
Cell[171835, 5617, 486, 12, 59, "Text",
  CellTags->"nlug:3.2.6"],
Cell[172324, 5631, 316, 17, 269, "Program",
  CellTags->"nlug:3.2.6"],
Cell[172643, 5650, 558, 11, 59, "Text",
  CellTags->"nlug:3.2.6"],
Cell[173204, 5663, 113, 7, 99, "Program",
  CellTags->"nlug:3.2.6"],
Cell[173320, 5672, 200, 6, 25, "Text",
  CellTags->"nlug:3.2.6"],
Cell[173523, 5680, 114, 5, 51, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.6"],
Cell[173640, 5687, 655, 17, 59, "Text",
  CellTags->"nlug:3.2.6"],
Cell[174298, 5706, 313, 7, 42, "Text",
  CellTags->"nlug:3.2.6"],

Cell[CellGroupData[{
Cell[174636, 5717, 146, 4, 31, "Input",
  CellTags->"nlug:3.2.6"],
Cell[174785, 5723, 231, 5, 27, "Output",
  CellTags->"nlug:3.2.6"]
}, Open  ]],
Cell[175031, 5731, 136, 4, 25, "Text",
  CellTags->"nlug:3.2.6"],

Cell[CellGroupData[{
Cell[175192, 5739, 78, 2, 31, "Input",
  CellTags->"nlug:3.2.6"],
Cell[175273, 5743, 89, 3, 27, "Output",
  CellTags->"nlug:3.2.6"]
}, Open  ]],
Cell[175377, 5749, 773, 18, 76, "Text",
  CellTags->"nlug:3.2.6"],

Cell[CellGroupData[{
Cell[176175, 5771, 83, 2, 31, "Input",
  CellTags->"nlug:3.2.6"],
Cell[176261, 5775, 89, 3, 27, "Output",
  CellTags->"nlug:3.2.6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[176399, 5784, 74, 1, 39, "Subsection",
  CellTags->{"Exceptions", "nlug:3.2.7"}],

Cell[CellGroupData[{
Cell[176498, 5789, 77, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.7"],
Cell[176578, 5792, 394, 10, 42, "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{
Cell[176997, 5806, 181, 4, 49, "Input",
  CellTags->"nlug:3.2.7"],
Cell[177181, 5812, 437, 8, 65, "Message",
  CellTags->"nlug:3.2.7"],
Cell[177621, 5822, 92, 3, 27, "Output",
  CellTags->"nlug:3.2.7"]
}, Open  ]],
Cell[177728, 5828, 152, 5, 25, "Text",
  CellTags->"nlug:3.2.7"],
Cell[177883, 5835, 332, 7, 42, "Text",
  CellTags->"nlug:3.2.7"]
}, Closed]],

Cell[CellGroupData[{
Cell[178252, 5847, 66, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.7"],
Cell[178321, 5850, 904, 22, 93, "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{
Cell[179250, 5876, 91, 2, 31, "Input",
  CellTags->"nlug:3.2.7"],
Cell[179344, 5880, 246, 5, 27, "Output",
  CellTags->"nlug:3.2.7"]
}, Open  ]],
Cell[179605, 5888, 167, 5, 25, "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{
Cell[179797, 5897, 97, 2, 31, "Input",
  CellTags->"nlug:3.2.7"],
Cell[179897, 5901, 248, 5, 27, "Output",
  CellTags->"nlug:3.2.7"]
}, Open  ]],
Cell[180160, 5909, 248, 5, 25, "Text",
  CellTags->"nlug:3.2.7"],

Cell[CellGroupData[{
Cell[180433, 5918, 91, 2, 31, "Input",
  CellTags->"nlug:3.2.7"],
Cell[180527, 5922, 227, 5, 27, "Output",
  CellTags->"nlug:3.2.7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[180803, 5933, 76, 1, 35, "Subsubsection",
  CellTags->"nlug:3.2.7"],
Cell[180882, 5936, 604, 16, 59, "Text",
  CellTags->"nlug:3.2.7"],
Cell[181489, 5954, 644, 15, 59, "Text",
  CellTags->"nlug:3.2.7"],
Cell[182136, 5971, 299, 8, 42, "Text",
  CellTags->"nlug:3.2.7"],
Cell[182438, 5981, 115, 5, 71, "Input",
  CellTags->"nlug:3.2.7"],
Cell[182556, 5988, 224, 6, 25, "Text",
  CellTags->"nlug:3.2.7"],
Cell[182783, 5996, 192, 7, 111, "Input",
  CellTags->"nlug:3.2.7"],
Cell[182978, 6005, 387, 9, 42, "Text",
  CellTags->"nlug:3.2.7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[183414, 6020, 60, 1, 39, "Subsection",
  CellTags->"nlug:3.2.8"],
Cell[183477, 6023, 146, 4, 25, "Text",
  CellTags->"nlug:3.2.8"],
Cell[183626, 6029, 333, 15, 235, "Program",
  CellTags->"nlug:3.2.8"],
Cell[183962, 6046, 418, 12, 42, "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{
Cell[184405, 6062, 144, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.8"],
Cell[184552, 6067, 124, 3, 27, "Output",
  CellTags->"nlug:3.2.8"]
}, Open  ]],
Cell[184691, 6073, 206, 7, 25, "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{
Cell[184922, 6084, 137, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.8"],
Cell[185062, 6089, 229, 5, 27, "Output",
  CellTags->"nlug:3.2.8"]
}, Open  ]],
Cell[185306, 6097, 400, 12, 42, "Text",
  CellTags->"nlug:3.2.8"],
Cell[185709, 6111, 100, 4, 48, "Program",
  CellTags->"nlug:3.2.8"],
Cell[185812, 6117, 473, 14, 42, "Text",
  CellTags->"nlug:3.2.8"],
Cell[186288, 6133, 120, 3, 25, "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{
Cell[186433, 6140, 86, 2, 31, "Input",
  CellTags->"nlug:3.2.8"],
Cell[186522, 6144, 86, 3, 27, "Output",
  CellTags->"nlug:3.2.8"]
}, Open  ]],
Cell[186623, 6150, 339, 11, 42, "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{
Cell[186987, 6165, 95, 2, 31, "Input",
  CellTags->"nlug:3.2.8"],
Cell[187085, 6169, 86, 3, 27, "Output",
  CellTags->"nlug:3.2.8"]
}, Open  ]],
Cell[187186, 6175, 429, 8, 59, "Text",
  CellTags->"nlug:3.2.8"],
Cell[187618, 6185, 887, 25, 76, "Text",
  CellTags->"nlug:3.2.8"],
Cell[188508, 6212, 162, 5, 51, "Input",
  CellTags->"nlug:3.2.8"],
Cell[188673, 6219, 357, 12, 42, "Text",
  CellTags->"nlug:3.2.8"],

Cell[CellGroupData[{
Cell[189055, 6235, 137, 4, 31, "Input",
  CellTags->"nlug:3.2.8"],
Cell[189195, 6241, 132, 3, 27, "Output",
  CellTags->"nlug:3.2.8"]
}, Open  ]],
Cell[189342, 6247, 518, 15, 59, "Text",
  CellTags->"nlug:3.2.8"]
}, Closed]],

Cell[CellGroupData[{
Cell[189897, 6267, 61, 1, 39, "Subsection",
  CellTags->"nlug:3.2.9"],
Cell[189961, 6270, 748, 19, 76, "Text",
  CellTags->"nlug:3.2.9"],

Cell[CellGroupData[{
Cell[190734, 6293, 107, 2, 31, "Input",
  CellTags->"nlug:3.2.9"],
Cell[190844, 6297, 218, 5, 27, "Output",
  CellTags->"nlug:3.2.9"]
}, Open  ]],
Cell[191077, 6305, 152, 6, 71, "Input",
  CellTags->"nlug:3.2.9"],
Cell[191232, 6313, 139, 5, 25, "Text",
  CellTags->"nlug:3.2.9"],

Cell[CellGroupData[{
Cell[191396, 6322, 106, 2, 31, "Input",
  CellTags->"nlug:3.2.9"],
Cell[191505, 6326, 218, 5, 27, "Output",
  CellTags->"nlug:3.2.9"]
}, Open  ]],
Cell[191738, 6334, 1415, 46, 82, "DefinitionBox",
  CellTags->"nlug:3.2.9"],
Cell[193156, 6382, 97, 4, 17, "Caption",
  CellTags->"nlug:3.2.9"],
Cell[193256, 6388, 857, 24, 93, "Text",
  CellTags->"nlug:3.2.9"],
Cell[194116, 6414, 86, 1, 31, "Program",
  CellTags->"nlug:3.2.9"],
Cell[194205, 6417, 491, 12, 59, "Text",
  CellTags->"nlug:3.2.9"],
Cell[194699, 6431, 120, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.9"],

Cell[CellGroupData[{
Cell[194844, 6438, 121, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.9"],
Cell[194968, 6443, 96, 3, 27, "Output",
  CellTags->"nlug:3.2.9"]
}, Open  ]],
Cell[195079, 6449, 291, 7, 42, "Text",
  CellTags->"nlug:3.2.9"],
Cell[195373, 6458, 102, 4, 48, "Program",
  CellTags->"nlug:3.2.9"],
Cell[195478, 6464, 815, 23, 76, "Text",
  CellTags->"nlug:3.2.9"],
Cell[196296, 6489, 108, 2, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.9"],
Cell[196407, 6493, 479, 13, 59, "Text",
  CellTags->"nlug:3.2.9"]
}, Closed]],

Cell[CellGroupData[{
Cell[196923, 6511, 64, 1, 39, "Subsection",
  CellTags->"nlug:3.2.10"],
Cell[196990, 6514, 906, 24, 93, "Text",
  CellTags->"nlug:3.2.10"],
Cell[197899, 6540, 737, 23, 66, "DefinitionBox",
  CellTags->"nlug:3.2.10"],
Cell[198639, 6565, 83, 1, 17, "Caption",
  CellTags->"nlug:3.2.10"],
Cell[198725, 6568, 137, 4, 25, "Text",
  CellTags->"nlug:3.2.10"],
Cell[198865, 6574, 216, 6, 27, "ItemizedText",
  CellTags->"nlug:3.2.10"],
Cell[199084, 6582, 224, 6, 27, "ItemizedText",
  CellTags->"nlug:3.2.10"],
Cell[199311, 6590, 1023, 30, 541, "Program",
  CellTags->"nlug:3.2.10"],
Cell[200337, 6622, 88, 1, 25, "Text",
  CellTags->"nlug:3.2.10"],
Cell[200428, 6625, 400, 22, 354, "Program",
  CellTags->"nlug:3.2.10"],
Cell[200831, 6649, 195, 5, 25, "Text",
  CellTags->"nlug:3.2.10"],
Cell[201029, 6656, 235, 6, 49, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{
Cell[201289, 6666, 129, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],
Cell[201421, 6671, 230, 5, 27, "Output",
  CellTags->"nlug:3.2.10"]
}, Open  ]],
Cell[201666, 6679, 557, 17, 59, "Text",
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{
Cell[202248, 6700, 114, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],
Cell[202365, 6705, 139, 3, 27, "Output",
  CellTags->"nlug:3.2.10"]
}, Open  ]],
Cell[202519, 6711, 489, 15, 42, "Text",
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{
Cell[203033, 6730, 98, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],
Cell[203134, 6735, 138, 3, 27, "Output",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[CellGroupData[{
Cell[203309, 6743, 106, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],
Cell[203418, 6748, 140, 3, 27, "Output",
  CellTags->"nlug:3.2.10"]
}, Open  ]],

Cell[CellGroupData[{
Cell[203595, 6756, 99, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],
Cell[203697, 6761, 139, 3, 27, "Output",
  CellTags->"nlug:3.2.10"]
}, Open  ]],
Cell[203851, 6767, 763, 20, 76, "Text",
  CellTags->"nlug:3.2.10"],

Cell[CellGroupData[{
Cell[204639, 6791, 115, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.10"],
Cell[204757, 6796, 138, 3, 27, "Output",
  CellTags->"nlug:3.2.10"]
}, Open  ]],
Cell[204910, 6802, 323, 9, 42, "Text",
  CellTags->"nlug:3.2.10"]
}, Closed]],

Cell[CellGroupData[{
Cell[205270, 6816, 90, 1, 39, "Subsection",
  CellTags->{".NET Console", "nlug:3.2.11"}],
Cell[205363, 6819, 915, 25, 76, "Text",
  CellTags->"nlug:3.2.11"],
Cell[206281, 6846, 1415, 43, 126, "DefinitionBox",
  CellTags->"nlug:3.2.11"],
Cell[207699, 6891, 73, 1, 17, "Caption",
  CellTags->"nlug:3.2.11"],

Cell[CellGroupData[{
Cell[207797, 6896, 84, 2, 31, "Input",
  CellTags->"nlug:3.2.11"],
Cell[207884, 6900, 237, 5, 27, "Output",
  CellTags->"nlug:3.2.11"]
}, Open  ]],
Cell[208136, 6908, 463, 12, 59, "Text",
  CellTags->"nlug:3.2.11"],
Cell[208602, 6922, 338, 9, 42, "Text",
  CellTags->"nlug:3.2.11"],
Cell[208943, 6933, 151, 5, 51, "Input",
  CellTags->"nlug:3.2.11"],
Cell[209097, 6940, 301, 7, 42, "Text",
  CellTags->"nlug:3.2.11"]
}, Closed]],

Cell[CellGroupData[{
Cell[209435, 6952, 181, 5, 39, "Subsection",
  CellTags->{"Distributing Applications", "nlug:3.2.12"}],
Cell[209619, 6959, 262, 9, 25, "Text",
  CellTags->"nlug:3.2.12"],
Cell[209884, 6970, 669, 15, 76, "Text",
  CellTags->"nlug:3.2.12"],
Cell[210556, 6987, 839, 24, 76, "Text",
  CellTags->"nlug:3.2.12"],
Cell[211398, 7013, 994, 25, 76, "Text",
  CellTags->"nlug:3.2.12"],
Cell[212395, 7040, 184, 6, 25, "Text",
  CellTags->"nlug:3.2.12"],
Cell[212582, 7048, 229, 9, 133, "Program",
  CellTags->"nlug:3.2.12"],
Cell[212814, 7059, 664, 13, 76, "Text",
  CellTags->"nlug:3.2.12"],
Cell[213481, 7074, 160, 6, 71, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.2.12"]
}, Closed]],

Cell[CellGroupData[{
Cell[213678, 7085, 68, 1, 39, "Subsection",
  CellTags->"nlug:3.2.13"],
Cell[213749, 7088, 501, 13, 59, "Text",
  CellTags->"nlug:3.2.13"],
Cell[214253, 7103, 1409, 37, 108, "DefinitionBox",
  CellTags->"nlug:3.2.13"],
Cell[215665, 7142, 133, 5, 17, "Caption",
  CellTags->"nlug:3.2.13"],

Cell[CellGroupData[{
Cell[215823, 7151, 112, 3, 29, "Input",
  CellTags->"nlug:3.2.13"],
Cell[215938, 7156, 127, 3, 27, "Output",
  CellTags->"nlug:3.2.13"]
}, Open  ]],

Cell[CellGroupData[{
Cell[216102, 7164, 118, 3, 29, "Input",
  CellTags->"nlug:3.2.13"],
Cell[216223, 7169, 88, 3, 27, "Output",
  CellTags->"nlug:3.2.13"]
}, Open  ]],

Cell[CellGroupData[{
Cell[216348, 7177, 118, 3, 29, "Input",
  CellTags->"nlug:3.2.13"],
Cell[216469, 7182, 86, 3, 27, "Output",
  CellTags->"nlug:3.2.13"]
}, Open  ]],
Cell[216570, 7188, 445, 15, 42, "Text",
  CellTags->"nlug:3.2.13"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[217064, 7209, 43, 0, 56, "Section"],

Cell[CellGroupData[{
Cell[217132, 7213, 60, 1, 39, "Subsection",
  CellTags->"nlug:3.3.0"],
Cell[217195, 7216, 1063, 20, 110, "Text",
  CellTags->"nlug:3.3.0"],
Cell[218261, 7238, 553, 17, 59, "Text",
  CellTags->"nlug:3.3.0"],
Cell[218817, 7257, 858, 30, 59, "Text",
  CellTags->"nlug:3.3.0"],
Cell[219678, 7289, 857, 29, 59, "Text",
  CellTags->"nlug:3.3.0"],
Cell[220538, 7320, 673, 20, 59, "Text",
  CellTags->"nlug:3.3.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[221248, 7345, 106, 1, 39, "Subsection",
  CellTags->{"Modal versus Modeless", "nlug:3.3.1"}],
Cell[221357, 7348, 691, 15, 76, "Text",
  CellTags->"nlug:3.3.1"],
Cell[222051, 7365, 1653, 39, 144, "Text",
  CellTags->"nlug:3.3.1"],
Cell[223707, 7406, 854, 18, 93, "Text",
  CellTags->"nlug:3.3.1"],
Cell[224564, 7426, 899, 21, 76, "Text",
  CellTags->"nlug:3.3.1"],
Cell[225466, 7449, 673, 16, 76, "Text",
  CellTags->"nlug:3.3.1"],
Cell[226142, 7467, 688, 12, 76, "Text",
  CellTags->"nlug:3.3.1"],
Cell[226833, 7481, 825, 16, 93, "Text",
  CellTags->"nlug:3.3.1"],
Cell[227661, 7499, 901, 15, 110, "Text",
  CellTags->"nlug:3.3.1"],
Cell[228565, 7516, 306, 7, 42, "Text",
  CellTags->"nlug:3.3.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[228908, 7528, 84, 1, 39, "Subsection",
  CellTags->{"Handling Events", "nlug:3.3.2"}],
Cell[228995, 7531, 791, 15, 93, "Text",
  CellTags->"nlug:3.3.2"],
Cell[229789, 7548, 412, 12, 42, "Text",
  CellTags->"nlug:3.3.2"],
Cell[230204, 7562, 212, 7, 99, "Program",
  CellTags->"nlug:3.3.2"],
Cell[230419, 7571, 410, 9, 42, "Text",
  CellTags->"nlug:3.3.2"],
Cell[230832, 7582, 421, 10, 42, "Text",
  CellTags->"nlug:3.3.2"],
Cell[231256, 7594, 131, 4, 31, "Program",
  CellTags->"nlug:3.3.2"],
Cell[231390, 7600, 184, 5, 25, "Text",
  CellTags->"nlug:3.3.2"],
Cell[231577, 7607, 297, 7, 99, "Program",
  CellTags->"nlug:3.3.2"],
Cell[231877, 7616, 323, 13, 25, "Text",
  CellTags->"nlug:3.3.2"],
Cell[232203, 7631, 119, 2, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],
Cell[232325, 7635, 768, 19, 76, "Text",
  CellTags->"nlug:3.3.2"],
Cell[233096, 7656, 193, 5, 51, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],
Cell[233292, 7663, 1407, 40, 84, "DefinitionBox",
  CellTags->"nlug:3.3.2"],
Cell[234702, 7705, 181, 5, 17, "Caption",
  CellTags->"nlug:3.3.2"],
Cell[234886, 7712, 688, 13, 76, "Text",
  CellTags->"nlug:3.3.2"],
Cell[235577, 7727, 704, 20, 59, "Text",
  CellTags->"nlug:3.3.2"],
Cell[236284, 7749, 163, 6, 71, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],
Cell[236450, 7757, 1009, 26, 93, "Text",
  CellTags->"nlug:3.3.2"],
Cell[237462, 7785, 240, 9, 131, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],
Cell[237705, 7796, 1426, 37, 127, "Text",
  CellTags->"nlug:3.3.2"],
Cell[239134, 7835, 160, 5, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],
Cell[239297, 7842, 147, 5, 25, "Text",
  CellTags->"nlug:3.3.2"],
Cell[239447, 7849, 124, 2, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.2"],
Cell[239574, 7853, 312, 10, 42, "Text",
  CellTags->"nlug:3.3.2"],
Cell[239889, 7865, 942, 26, 130, "DefinitionBox3Col",
  CellTags->"nlug:3.3.2"],
Cell[240834, 7893, 73, 1, 17, "Caption",
  CellTags->"nlug:3.3.2"],
Cell[240910, 7896, 831, 26, 59, "Text",
  CellTags->"nlug:3.3.2"],
Cell[241744, 7924, 1708, 44, 127, "Text",
  CellTags->"nlug:3.3.2"],
Cell[243455, 7970, 1308, 37, 98, "DefinitionBox",
  CellTags->"nlug:3.3.2"],
Cell[244766, 8009, 156, 6, 17, "Caption",
  CellTags->"nlug:3.3.2"],
Cell[244925, 8017, 464, 12, 59, "Text",
  CellTags->"nlug:3.3.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[245426, 8034, 80, 1, 39, "Subsection",
  CellTags->{"Modal Windows", "nlug:3.3.3"}],
Cell[245509, 8037, 526, 13, 59, "Text",
  CellTags->"nlug:3.3.3"],

Cell[CellGroupData[{
Cell[246060, 8054, 128, 3, 29, "Input",
  CellTags->"nlug:3.3.3"],
Cell[246191, 8059, 228, 5, 27, "Output",
  CellTags->"nlug:3.3.3"]
}, Open  ]],
Cell[246434, 8067, 529, 13, 59, "Text",
  CellTags->"nlug:3.3.3"],
Cell[246966, 8082, 86, 2, 31, "Input",
  CellTags->"nlug:3.3.3"],
Cell[247055, 8086, 586, 13, 59, "Text",
  CellTags->"nlug:3.3.3"],
Cell[247644, 8101, 197, 4, 49, "Input",
  CellTags->"nlug:3.3.3"],
Cell[247844, 8107, 207, 8, 25, "Text",
  CellTags->"nlug:3.3.3"],
Cell[248054, 8117, 125, 3, 29, "Input",
  CellTags->"nlug:3.3.3"],
Cell[248182, 8122, 379, 10, 42, "Text",
  CellTags->"nlug:3.3.3"],
Cell[248564, 8134, 325, 8, 69, "Input",
  CellTags->"nlug:3.3.3"],
Cell[248892, 8144, 746, 21, 59, "Text",
  CellTags->"nlug:3.3.3"],
Cell[249641, 8167, 635, 13, 76, "Text",
  CellTags->"nlug:3.3.3"],
Cell[250279, 8182, 1764, 51, 98, "DefinitionBox",
  CellTags->"nlug:3.3.3"],
Cell[252046, 8235, 67, 1, 17, "Caption",
  CellTags->"nlug:3.3.3"],
Cell[252116, 8238, 131, 4, 25, "Text",
  CellTags->"nlug:3.3.3"],
Cell[252250, 8244, 99, 3, 29, "Input",
  CellTags->"nlug:3.3.3"],
Cell[252352, 8249, 324, 8, 42, "Text",
  CellTags->"nlug:3.3.3"],
Cell[252679, 8259, 1289, 31, 110, "Text",
  CellTags->"nlug:3.3.3"],
Cell[253971, 8292, 123, 3, 25, "Text",
  CellTags->"nlug:3.3.3"],
Cell[254097, 8297, 493, 17, 291, "Input",
  CellTags->"nlug:3.3.3"],
Cell[254593, 8316, 1125, 28, 110, "Text",
  CellTags->"nlug:3.3.3"],
Cell[255721, 8346, 166, 5, 51, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.3.3"],
Cell[255890, 8353, 508, 16, 25, "Text",
  CellTags->"nlug:3.3.3"],
Cell[256401, 8371, 589, 16, 59, "Text",
  CellTags->"nlug:3.3.3"],
Cell[256993, 8389, 516, 13, 70, "DefinitionBox3Col",
  CellTags->"nlug:3.3.3"],
Cell[257512, 8404, 68, 1, 17, "Caption",
  CellTags->"nlug:3.3.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[257617, 8410, 86, 1, 39, "Subsection",
  CellTags->{"Modeless Windows", "nlug:3.3.4"}],
Cell[257706, 8413, 673, 15, 59, "Text",
  CellTags->"nlug:3.3.4"],
Cell[258382, 8430, 448, 12, 42, "Text",
  CellTags->"nlug:3.3.4"],
Cell[258833, 8444, 554, 17, 44, "DefinitionBox",
  CellTags->"nlug:3.3.4"],
Cell[259390, 8463, 62, 1, 17, "Caption",
  CellTags->"nlug:3.3.4"],
Cell[259455, 8466, 177, 5, 25, "Text",
  CellTags->"nlug:3.3.4"],
Cell[259635, 8473, 486, 17, 291, "Input",
  CellTags->"nlug:3.3.4"],
Cell[260124, 8492, 317, 7, 42, "Text",
  CellTags->"nlug:3.3.4"],
Cell[260444, 8501, 83, 2, 31, "Input",
  CellTags->"nlug:3.3.4"],
Cell[260530, 8505, 1462, 42, 127, "Text",
  CellTags->"nlug:3.3.4"],
Cell[261995, 8549, 754, 15, 76, "Text",
  CellTags->"nlug:3.3.4"],
Cell[262752, 8566, 945, 25, 130, "DefinitionBox3Col",
  CellTags->"nlug:3.3.4"],
Cell[263700, 8593, 71, 1, 17, "Caption",
  CellTags->"nlug:3.3.4"],
Cell[263774, 8596, 955, 25, 93, "Text",
  CellTags->"nlug:3.3.4"],
Cell[264732, 8623, 1083, 28, 110, "Text",
  CellTags->"nlug:3.3.4"],
Cell[265818, 8653, 949, 21, 93, "Text",
  CellTags->"nlug:3.3.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[266804, 8679, 123, 1, 39, "Subsection",
  CellTags->{"Sharing the Kernel", "nlug:3.3.5"}],
Cell[266930, 8682, 806, 24, 76, "Text",
  CellTags->"nlug:3.3.5"],
Cell[267739, 8708, 926, 20, 93, "Text",
  CellTags->"nlug:3.3.5"],
Cell[268668, 8730, 1210, 34, 93, "Text",
  CellTags->"nlug:3.3.5"],
Cell[269881, 8766, 223, 8, 99, "Program",
  CellTags->"nlug:3.3.5"],
Cell[270107, 8776, 587, 18, 59, "Text",
  CellTags->"nlug:3.3.5"],
Cell[270697, 8796, 72, 1, 31, "Input",
  CellTags->"nlug:3.3.5"],
Cell[270772, 8799, 187, 7, 25, "Text",
  CellTags->"nlug:3.3.5"],
Cell[270962, 8808, 62, 1, 31, "Input",
  CellTags->"nlug:3.3.5"],
Cell[271027, 8811, 628, 18, 59, "Text",
  CellTags->"nlug:3.3.5"],
Cell[271658, 8831, 619, 17, 59, "Text",
  CellTags->"nlug:3.3.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[272314, 8853, 185, 6, 39, "Subsection",
  CellTags->{"ShowNETWindow", "nlug:3.3.6"}],
Cell[272502, 8861, 1116, 32, 59, "Text",
  CellTags->"nlug:3.3.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[273655, 8898, 106, 1, 39, "Subsection",
  CellTags->{"ShowNETWindow", "nlug:3.3.7"}],
Cell[273764, 8901, 748, 19, 76, "Text",
  CellTags->"nlug:3.3.7"],
Cell[274515, 8922, 773, 21, 76, "Text",
  CellTags->"nlug:3.3.7"],
Cell[275291, 8945, 658, 20, 62, "DefinitionBox",
  CellTags->"nlug:3.3.7"],
Cell[275952, 8967, 86, 1, 17, "Caption",
  CellTags->"nlug:3.3.7"],
Cell[276041, 8970, 690, 21, 59, "Text",
  CellTags->"nlug:3.3.7"]
}, Closed]],

Cell[CellGroupData[{
Cell[276768, 8996, 61, 1, 39, "Subsection",
  CellTags->"nlug:3.3.8"],
Cell[276832, 8999, 162, 5, 25, "Text",
  CellTags->"nlug:3.3.8"],
Cell[276997, 9006, 287, 6, 31, "Input",
  CellTags->"nlug:3.3.8"],
Cell[277287, 9014, 288, 6, 31, "Input",
  CellTags->"nlug:3.3.8"],
Cell[277578, 9022, 296, 6, 31, "Input",
  CellTags->"nlug:3.3.8"],
Cell[277877, 9030, 290, 6, 31, "Input",
  CellTags->"nlug:3.3.8"],
Cell[278170, 9038, 305, 6, 31, "Input",
  CellTags->"nlug:3.3.8"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[278524, 9050, 127, 4, 56, "Section"],

Cell[CellGroupData[{
Cell[278676, 9058, 60, 1, 39, "Subsection",
  CellTags->"nlug:3.4.0"],
Cell[278739, 9061, 334, 8, 42, "Text",
  CellTags->"nlug:3.4.0"],
Cell[279076, 9071, 650, 15, 76, "Text",
  CellTags->"nlug:3.4.0"],
Cell[279729, 9088, 1021, 23, 93, "Text",
  CellTags->"nlug:3.4.0"],
Cell[280753, 9113, 804, 23, 76, "Text",
  CellTags->"nlug:3.4.0"],
Cell[281560, 9138, 610, 16, 59, "Text",
  CellTags->"nlug:3.4.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[282207, 9159, 129, 4, 39, "Subsection",
  CellTags->"nlug:3.4.1"],
Cell[282339, 9165, 732, 15, 76, "Text",
  CellTags->"nlug:3.4.1"],
Cell[283074, 9182, 751, 18, 76, "Text",
  CellTags->"nlug:3.4.1"],
Cell[283828, 9202, 437, 23, 371, "Program",
  CellTags->"nlug:3.4.1"],
Cell[284268, 9227, 907, 25, 76, "Text",
  CellTags->"nlug:3.4.1"],
Cell[285178, 9254, 611, 17, 59, "Text",
  CellTags->"nlug:3.4.1"],
Cell[285792, 9273, 535, 14, 59, "Text",
  CellTags->"nlug:3.4.1"],
Cell[286330, 9289, 629, 17, 59, "Text",
  CellTags->"nlug:3.4.1"],
Cell[286962, 9308, 917, 26, 76, "Text",
  CellTags->"nlug:3.4.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[287916, 9339, 124, 4, 39, "Subsection",
  CellTags->"nlug:3.4.2"],
Cell[288043, 9345, 931, 22, 93, "Text",
  CellTags->"nlug:3.4.2"],
Cell[288977, 9369, 1001, 22, 93, "Text",
  CellTags->"nlug:3.4.2"],
Cell[289981, 9393, 654, 20, 59, "Text",
  CellTags->"nlug:3.4.2"],
Cell[290638, 9415, 463, 13, 42, "Text",
  CellTags->"nlug:3.4.2"],
Cell[291104, 9430, 95, 1, 31, "Program",
  CellTags->"nlug:3.4.2"],
Cell[291202, 9433, 250, 9, 25, "Text",
  CellTags->"nlug:3.4.2"],
Cell[291455, 9444, 73, 1, 31, "Program",
  CellTags->"nlug:3.4.2"],
Cell[291531, 9447, 192, 6, 25, "Text",
  CellTags->"nlug:3.4.2"],
Cell[291726, 9455, 147, 2, 31, "Program",
  CellTags->"nlug:3.4.2"],
Cell[291876, 9459, 62, 1, 25, "Text",
  CellTags->"nlug:3.4.2"],
Cell[291941, 9462, 356, 14, 218, "Program",
  CellTags->"nlug:3.4.2"],
Cell[292300, 9478, 315, 11, 42, "Text",
  CellTags->"nlug:3.4.2"],
Cell[292618, 9491, 127, 5, 25, "Text",
  CellTags->"nlug:3.4.2"],

Cell[CellGroupData[{
Cell[292770, 9500, 248, 6, 69, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.4.2"],
Cell[293021, 9508, 122, 4, 23, "Print",
  CellTags->"nlug:3.4.2"],
Cell[293146, 9514, 162, 4, 20, "Message",
  CellTags->"nlug:3.4.2"],
Cell[293311, 9520, 93, 3, 27, "Output",
  CellTags->"nlug:3.4.2"]
}, Open  ]],
Cell[293419, 9526, 294, 8, 25, "Text",
  CellTags->"nlug:3.4.2"],
Cell[293716, 9536, 1493, 45, 110, "Text",
  CellTags->"nlug:3.4.2"],
Cell[295212, 9583, 67, 1, 25, "Text",
  CellTags->"nlug:3.4.2"],
Cell[295282, 9586, 859, 29, 473, "Program",
  CellTags->"nlug:3.4.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[296178, 9620, 67, 1, 39, "Subsection",
  CellTags->"nlug:3.4.3"],
Cell[296248, 9623, 828, 19, 76, "Text",
  CellTags->"nlug:3.4.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[297113, 9647, 77, 1, 39, "Subsection",
  CellTags->"nlug:3.4.4"],
Cell[297193, 9650, 547, 17, 59, "Text",
  CellTags->"nlug:3.4.4"],
Cell[297743, 9669, 350, 10, 42, "Text",
  CellTags->"nlug:3.4.4"],
Cell[298096, 9681, 302, 12, 184, "Program",
  CellTags->"nlug:3.4.4"],
Cell[298401, 9695, 1165, 31, 93, "Text",
  CellTags->"nlug:3.4.4"],
Cell[299569, 9728, 1704, 40, 144, "Text",
  CellTags->"nlug:3.4.4"],
Cell[301276, 9770, 1379, 32, 127, "Text",
  CellTags->"nlug:3.4.4"],
Cell[302658, 9804, 61, 1, 25, "Text",
  CellTags->"nlug:3.4.4"],
Cell[302722, 9807, 371, 16, 235, "Program",
  CellTags->"nlug:3.4.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[303130, 9828, 83, 1, 39, "Subsection",
  CellTags->"nlug:3.4.5"],
Cell[303216, 9831, 1825, 48, 144, "Text",
  CellTags->"nlug:3.4.5"],
Cell[305044, 9881, 191, 5, 25, "Text",
  CellTags->"nlug:3.4.5"],
Cell[305238, 9888, 202, 6, 27, "BulletText",
  CellTags->"nlug:3.4.5"],
Cell[305443, 9896, 162, 6, 27, "BulletText",
  CellTags->"nlug:3.4.5"],
Cell[305608, 9904, 242, 7, 27, "BulletText",
  CellTags->"nlug:3.4.5"],
Cell[305853, 9913, 239, 7, 27, "BulletText",
  CellTags->"nlug:3.4.5"],
Cell[306095, 9922, 159, 5, 27, "BulletText",
  CellTags->"nlug:3.4.5"],
Cell[306257, 9929, 361, 12, 46, "BulletText",
  CellTags->"nlug:3.4.5"],
Cell[306621, 9943, 737, 18, 76, "Text",
  CellTags->"nlug:3.4.5"],
Cell[307361, 9963, 121, 3, 25, "Text",
  CellTags->"nlug:3.4.5"],
Cell[307485, 9968, 580, 17, 269, "Program",
  CellTags->"nlug:3.4.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[308102, 9990, 75, 1, 39, "Subsection",
  CellTags->"nlug:3.4.6"],
Cell[308180, 9993, 652, 17, 76, "Text",
  CellTags->"nlug:3.4.6"],
Cell[308835, 10012, 998, 28, 93, "Text",
  CellTags->"nlug:3.4.6"],
Cell[309836, 10042, 97, 2, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.4.6"],
Cell[309936, 10046, 640, 19, 59, "Text",
  CellTags->"nlug:3.4.6"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[310625, 10071, 112, 5, 56, "Section"],

Cell[CellGroupData[{
Cell[310762, 10080, 95, 1, 39, "Subsection",
  CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"}],
Cell[310860, 10083, 987, 24, 93, "Text",
  CellTags->"nlug:3.5.0"],
Cell[311850, 10109, 822, 20, 76, "Text",
  CellTags->"nlug:3.5.0"],
Cell[312675, 10131, 431, 10, 42, "Text",
  CellTags->"nlug:3.5.0"],
Cell[313109, 10143, 408, 10, 184, "Program",
  CellTags->"nlug:3.5.0"],
Cell[313520, 10155, 325, 9, 42, "Text",
  CellTags->"nlug:3.5.0"],

Cell[CellGroupData[{
Cell[313870, 10168, 160, 5, 31, "Input",
  CellTags->"nlug:3.5.0"],
Cell[314033, 10175, 270, 6, 46, "Output",
  CellTags->"nlug:3.5.0"]
}, Open  ]],
Cell[314318, 10184, 222, 6, 25, "Text",
  CellTags->"nlug:3.5.0"],

Cell[CellGroupData[{
Cell[314565, 10194, 83, 2, 31, "Input",
  CellTags->"nlug:3.5.0"],
Cell[314651, 10198, 95, 3, 27, "Output",
  CellTags->"nlug:3.5.0"]
}, Open  ]],
Cell[314761, 10204, 1133, 26, 93, "Text",
  CellTags->"nlug:3.5.0"],
Cell[315897, 10232, 3214, 95, 106, "DefinitionBox",
  CellTags->"nlug:3.5.0"],
Cell[319114, 10329, 68, 1, 17, "Caption",
  CellTags->"nlug:3.5.0"],
Cell[319185, 10332, 921, 18, 93, "Text",
  CellTags->"nlug:3.5.0"],
Cell[320109, 10352, 493, 15, 42, "Text",
  CellTags->"nlug:3.5.0"],
Cell[320605, 10369, 1070, 27, 172, "DefinitionBox3Col",
  CellTags->"nlug:3.5.0"],
Cell[321678, 10398, 119, 5, 17, "Caption",
  CellTags->"nlug:3.5.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[321834, 10408, 90, 1, 39, "Subsection",
  CellTags->{"How DLLs are Found", "nlug:3.5.1"}],
Cell[321927, 10411, 937, 22, 93, "Text",
  CellTags->"nlug:3.5.1"],
Cell[322867, 10435, 1599, 41, 127, "Text",
  CellTags->"nlug:3.5.1"],
Cell[324469, 10478, 439, 10, 42, "Text",
  CellTags->"nlug:3.5.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[324945, 10493, 130, 1, 39, "Subsection",
  CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"}],

Cell[CellGroupData[{
Cell[325100, 10498, 63, 1, 35, "Subsubsection",
  CellTags->"nlug:3.5.2"],
Cell[325166, 10501, 1027, 18, 93, "Text",
  CellTags->"nlug:3.5.2"],
Cell[326196, 10521, 68, 1, 31, "Program",
  CellTags->"nlug:3.5.2"],
Cell[326267, 10524, 577, 17, 59, "Text",
  CellTags->"nlug:3.5.2"],
Cell[326847, 10543, 166, 5, 31, "Input",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[327038, 10552, 87, 2, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[327128, 10556, 89, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],
Cell[327232, 10562, 292, 6, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[327527, 10570, 427, 12, 171, "Input",
  CellTags->"nlug:3.5.2"],
Cell[327957, 10584, 573, 11, 76, "Text",
  CellTags->"nlug:3.5.2"],
Cell[328533, 10597, 332, 9, 133, "Program",
  CellTags->"nlug:3.5.2"],
Cell[328868, 10608, 825, 23, 76, "Text",
  CellTags->"nlug:3.5.2"],
Cell[329696, 10633, 121, 3, 25, "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[329854, 10641, 66, 1, 35, "Subsubsection",
  CellTags->"nlug:3.5.2"],
Cell[329923, 10644, 262, 7, 25, "Text",
  CellTags->"nlug:3.5.2"],
Cell[330188, 10653, 2167, 49, 490, "DefinitionBox",
  CellTags->"nlug:3.5.2"],
Cell[332358, 10704, 156, 5, 17, "Caption",
  CellTags->"nlug:3.5.2"],
Cell[332517, 10711, 528, 12, 59, "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[333082, 10728, 79, 1, 35, "Subsubsection",
  CellTags->{"strings in DLLs", "nlug:3.5.2"}],
Cell[333164, 10731, 900, 18, 93, "Text",
  CellTags->"nlug:3.5.2"],
Cell[334067, 10751, 374, 9, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[334444, 10762, 117, 5, 65, "Program",
  CellTags->"nlug:3.5.2"],
Cell[334564, 10769, 310, 8, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[334877, 10779, 277, 7, 51, "Input",
  CellTags->"nlug:3.5.2"],
Cell[335157, 10788, 142, 4, 25, "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[335324, 10796, 114, 2, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[335441, 10800, 90, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],
Cell[335546, 10806, 387, 8, 42, "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[335958, 10818, 88, 2, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[336049, 10822, 91, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],
Cell[336155, 10828, 95, 1, 25, "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[336275, 10833, 88, 2, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[336366, 10837, 95, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],
Cell[336476, 10843, 632, 14, 59, "Text",
  CellTags->"nlug:3.5.2"],
Cell[337111, 10859, 1248, 32, 230, "DefinitionBox",
  CellTags->"nlug:3.5.2"],
Cell[338362, 10893, 174, 5, 17, "Caption",
  CellTags->"nlug:3.5.2"],
Cell[338539, 10900, 394, 11, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[338936, 10913, 564, 18, 291, "Input",
  CellTags->"nlug:3.5.2"],
Cell[339503, 10933, 940, 18, 76, "Text",
  CellTags->"nlug:3.5.2"],
Cell[340446, 10953, 115, 3, 31, "Program",
  CellTags->"nlug:3.5.2"],
Cell[340564, 10958, 957, 20, 93, "Text",
  CellTags->"nlug:3.5.2"],
Cell[341524, 10980, 405, 8, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[341932, 10990, 270, 5, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[342205, 10997, 575, 15, 59, "Text",
  CellTags->"nlug:3.5.2"],
Cell[342783, 11014, 327, 9, 42, "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[343135, 11027, 154, 5, 51, "Input",
  CellTags->"nlug:3.5.2"],
Cell[343292, 11034, 87, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],
Cell[343394, 11040, 193, 6, 25, "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[343612, 11050, 82, 2, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[343697, 11054, 96, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[343842, 11063, 70, 1, 35, "Subsubsection",
  CellTags->"nlug:3.5.2"],
Cell[343915, 11066, 366, 8, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[344284, 11076, 533, 10, 103, "ItemizedText",
  CellTags->"nlug:3.5.2"],
Cell[344820, 11088, 276, 7, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[345099, 11097, 81, 1, 31, "Program",
  CellTags->"nlug:3.5.2"],
Cell[345183, 11100, 624, 15, 59, "Text",
  CellTags->"nlug:3.5.2"],
Cell[345810, 11117, 169, 5, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[345982, 11124, 1384, 35, 110, "Text",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[347391, 11163, 116, 5, 51, "Input",
  CellTags->"nlug:3.5.2"],
Cell[347510, 11170, 90, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[347637, 11178, 80, 2, 31, "Input",
  CellTags->"nlug:3.5.2"],
Cell[347720, 11182, 89, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],
Cell[347824, 11188, 505, 13, 59, "Text",
  CellTags->"nlug:3.5.2"],
Cell[348332, 11203, 178, 5, 31, "Input",
  CellTags->"nlug:3.5.2"],

Cell[CellGroupData[{
Cell[348535, 11212, 111, 5, 71, "Input",
  CellTags->"nlug:3.5.2"],
Cell[348649, 11219, 90, 3, 27, "Output",
  CellTags->"nlug:3.5.2"],
Cell[348742, 11224, 89, 3, 27, "Output",
  CellTags->"nlug:3.5.2"]
}, Open  ]],
Cell[348846, 11230, 957, 23, 93, "Text",
  CellTags->"nlug:3.5.2"],
Cell[349806, 11255, 703, 18, 76, "Text",
  CellTags->"nlug:3.5.2"],
Cell[350512, 11275, 136, 5, 65, "Program",
  CellTags->"nlug:3.5.2"],
Cell[350651, 11282, 295, 8, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[350949, 11292, 363, 12, 171, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],
Cell[351315, 11306, 246, 7, 25, "Text",
  CellTags->"nlug:3.5.2"],
Cell[351564, 11315, 300, 9, 42, "Text",
  CellTags->"nlug:3.5.2"],
Cell[351867, 11326, 175, 5, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],
Cell[352045, 11333, 100, 1, 25, "Text",
  CellTags->"nlug:3.5.2"],
Cell[352148, 11336, 95, 2, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],
Cell[352246, 11340, 1176, 29, 110, "Text",
  CellTags->"nlug:3.5.2"],
Cell[353425, 11371, 436, 13, 211, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],
Cell[353864, 11386, 100, 1, 25, "Text",
  CellTags->"nlug:3.5.2"],
Cell[353967, 11389, 95, 2, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.5.2"],
Cell[354065, 11393, 325, 10, 25, "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[354427, 11408, 68, 1, 35, "Subsubsection",
  CellTags->"nlug:3.5.2"],
Cell[354498, 11411, 1252, 29, 110, "Text",
  CellTags->"nlug:3.5.2"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[355799, 11446, 136, 1, 39, "Subsection",
  CellTags->{"Declarations Requiring Special Attributes", "nlug:3.5.3"}],
Cell[355938, 11449, 752, 16, 93, "Text",
  CellTags->"nlug:3.5.3"],
Cell[356693, 11467, 277, 6, 82, "Program",
  CellTags->"nlug:3.5.3"],
Cell[356973, 11475, 290, 7, 42, "Text",
  CellTags->"nlug:3.5.3"],
Cell[357266, 11484, 324, 7, 91, "Input",
  CellTags->"nlug:3.5.3"],
Cell[357593, 11493, 185, 6, 25, "Text",
  CellTags->"nlug:3.5.3"],
Cell[357781, 11501, 217, 5, 42, "Text",
  CellTags->"nlug:3.5.3"],
Cell[358001, 11508, 103, 1, 31, "Program",
  CellTags->"nlug:3.5.3"],
Cell[358107, 11511, 146, 5, 25, "Text",
  CellTags->"nlug:3.5.3"],
Cell[358256, 11518, 270, 5, 71, "Input",
  CellTags->"nlug:3.5.3"],
Cell[358529, 11525, 560, 13, 59, "Text",
  CellTags->"nlug:3.5.3"],
Cell[359092, 11540, 228, 5, 51, "Input",
  CellTags->"nlug:3.5.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[359357, 11550, 84, 1, 39, "Subsection",
  CellTags->{"DLL Example Files", "nlug:3.5.4"}],
Cell[359444, 11553, 253, 8, 25, "Text",
  CellTags->"nlug:3.5.4"],
Cell[359700, 11563, 284, 6, 31, "Input",
  CellTags->"nlug:3.5.4"],
Cell[359987, 11571, 278, 6, 31, "Input",
  CellTags->"nlug:3.5.4"],
Cell[360268, 11579, 279, 6, 31, "Input",
  CellTags->"nlug:3.5.4"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[360596, 11591, 130, 6, 56, "Section",
  CellTags->"COM"],

Cell[CellGroupData[{
Cell[360751, 11601, 82, 1, 39, "Subsection",
  CellTags->{"COM Introduction", "nlug:3.6.0"}],
Cell[360836, 11604, 661, 15, 76, "Text",
  CellTags->"nlug:3.6.0"],
Cell[361500, 11621, 331, 6, 42, "Text",
  CellTags->"nlug:3.6.0"],
Cell[361834, 11629, 547, 9, 76, "Text",
  CellTags->"nlug:3.6.0"],
Cell[362384, 11640, 786, 16, 93, "Text",
  CellTags->"nlug:3.6.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[363207, 11661, 79, 1, 39, "Subsection",
  CellTags->"nlug:3.6.1"],
Cell[363289, 11664, 924, 19, 110, "Text",
  CellTags->"nlug:3.6.1"],
Cell[364216, 11685, 1021, 21, 127, "Text",
  CellTags->"nlug:3.6.1"],
Cell[365240, 11708, 1113, 19, 144, "Text",
  CellTags->"nlug:3.6.1"],
Cell[366356, 11729, 823, 17, 93, "Text",
  CellTags->"nlug:3.6.1"],
Cell[367182, 11748, 1700, 49, 172, "DefinitionBox",
  CellTags->"nlug:3.6.1"],
Cell[368885, 11799, 68, 1, 17, "Caption",
  CellTags->"nlug:3.6.1"],
Cell[368956, 11802, 93, 1, 25, "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{
Cell[369074, 11807, 108, 2, 31, "Input",
  CellTags->"nlug:3.6.1"],
Cell[369185, 11811, 250, 5, 27, "Output",
  CellTags->"nlug:3.6.1"]
}, Open  ]],
Cell[369450, 11819, 882, 21, 93, "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{
Cell[370357, 11844, 93, 2, 31, "Input",
  CellTags->"nlug:3.6.1"],
Cell[370453, 11848, 104, 3, 27, "Output",
  CellTags->"nlug:3.6.1"]
}, Open  ]],
Cell[370572, 11854, 1629, 38, 178, "Text",
  CellTags->"nlug:3.6.1"],
Cell[372204, 11894, 223, 6, 42, "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{
Cell[372452, 11904, 85, 2, 31, "Input",
  CellTags->"nlug:3.6.1"],
Cell[372540, 11908, 204, 5, 20, "Message",
  CellTags->"nlug:3.6.1"],
Cell[372747, 11915, 180, 6, 41, "Output",
  CellTags->"nlug:3.6.1"]
}, Open  ]],
Cell[372942, 11924, 551, 13, 59, "Text",
  CellTags->"nlug:3.6.1"],
Cell[373496, 11939, 179, 7, 25, "Text",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{
Cell[373700, 11950, 79, 2, 31, "Input",
  CellTags->"nlug:3.6.1"],
Cell[373782, 11954, 87, 3, 27, "Output",
  CellTags->"nlug:3.6.1"]
}, Open  ]],
Cell[373884, 11960, 282, 9, 42, "Text",
  CellTags->"nlug:3.6.1"],
Cell[374169, 11971, 143, 4, 31, "Program",
  CellTags->"nlug:3.6.1"],
Cell[374315, 11977, 549, 13, 59, "Text",
  CellTags->"nlug:3.6.1"],
Cell[374867, 11992, 156, 5, 31, "Input",
  CellTags->"nlug:3.6.1"],
Cell[375026, 11999, 851, 15, 110, "Text",
  CellTags->"nlug:3.6.1"],
Cell[375880, 12016, 195, 5, 51, "Input",
  CellTags->"nlug:3.6.1"],

Cell[CellGroupData[{
Cell[376100, 12025, 80, 1, 35, "Subsubsection",
  CellTags->"nlug:3.6.1"],
Cell[376183, 12028, 315, 9, 42, "Text",
  CellTags->"nlug:3.6.1"],
Cell[376501, 12039, 448, 9, 84, "ItemizedText",
  CellTags->"nlug:3.6.1"],
Cell[376952, 12050, 283, 8, 42, "Text",
  CellTags->"nlug:3.6.1"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[377284, 12064, 111, 1, 39, "Subsection",
  CellTags->{"Interop Assembly", "nlug:3.6.2"}],
Cell[377398, 12067, 975, 20, 110, "Text",
  CellTags->"nlug:3.6.2"],
Cell[378376, 12089, 983, 23, 93, "Text",
  CellTags->"nlug:3.6.2"],
Cell[379362, 12114, 512, 16, 42, "DefinitionBox",
  CellTags->"nlug:3.6.2"],
Cell[379877, 12132, 73, 1, 17, "Caption",
  CellTags->"nlug:3.6.2"],
Cell[379953, 12135, 193, 4, 25, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[380171, 12143, 190, 5, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[380364, 12150, 120, 3, 27, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],
Cell[380499, 12156, 787, 17, 76, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[381311, 12177, 102, 2, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[381416, 12181, 5501, 142, 695, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],
Cell[386932, 12326, 405, 11, 42, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[387362, 12341, 109, 2, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[387474, 12345, 226, 5, 27, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],
Cell[387715, 12353, 346, 8, 42, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[388086, 12365, 148, 4, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[388237, 12371, 86, 3, 27, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],
Cell[388338, 12377, 413, 9, 59, "Text",
  CellTags->"nlug:3.6.2"],
Cell[388754, 12388, 235, 6, 71, "Input",
  CellTags->"nlug:3.6.2"],
Cell[388992, 12396, 318, 8, 42, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[389335, 12408, 102, 2, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[389440, 12412, 2196, 61, 255, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],
Cell[391651, 12476, 489, 12, 59, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[392165, 12492, 110, 2, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[392278, 12496, 226, 5, 27, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],
Cell[392519, 12504, 825, 23, 96, "DefinitionBox3Col",
  CellTags->"nlug:3.6.2"],
Cell[393347, 12529, 119, 5, 17, "Caption",
  CellTags->"nlug:3.6.2"],
Cell[393469, 12536, 1388, 34, 127, "Text",
  CellTags->"nlug:3.6.2"],
Cell[394860, 12572, 553, 14, 59, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[395438, 12590, 96, 2, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[395537, 12594, 1475, 35, 185, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],
Cell[397027, 12632, 100, 1, 25, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[397152, 12637, 109, 2, 31, "Input",
  CellTags->"nlug:3.6.2"],
Cell[397264, 12641, 89, 3, 27, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[397390, 12649, 97, 1, 35, "Subsubsection",
  CellTags->"nlug:3.6.2"],
Cell[397490, 12652, 879, 20, 93, "Text",
  CellTags->"nlug:3.6.2"],
Cell[398372, 12674, 166, 4, 31, "Program",
  CellTags->"nlug:3.6.2"],
Cell[398541, 12680, 118, 3, 25, "Text",
  CellTags->"nlug:3.6.2"],
Cell[398662, 12685, 92, 1, 31, "Input",
  CellTags->"nlug:3.6.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[398791, 12691, 77, 1, 35, "Subsubsection",
  CellTags->"nlug:3.6.2"],
Cell[398871, 12694, 860, 14, 93, "Text",
  CellTags->"nlug:3.6.2"],
Cell[399734, 12710, 781, 18, 76, "Text",
  CellTags->"nlug:3.6.2"],
Cell[400518, 12730, 981, 24, 76, "Text",
  CellTags->"nlug:3.6.2"],

Cell[CellGroupData[{
Cell[401524, 12758, 136, 3, 31, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.6.2"],
Cell[401663, 12763, 254, 6, 27, "Output",
  CellTags->"nlug:3.6.2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[401978, 12776, 71, 1, 39, "Subsection",
  CellTags->"nlug:3.6.3"],
Cell[402052, 12779, 1098, 17, 93, "Text",
  CellTags->"nlug:3.6.3"],
Cell[403153, 12798, 490, 16, 42, "DefinitionBox",
  CellTags->"nlug:3.6.3"],
Cell[403646, 12816, 69, 1, 17, "Caption",
  CellTags->"nlug:3.6.3"],
Cell[403718, 12819, 866, 16, 76, "Text",
  CellTags->"nlug:3.6.3"],
Cell[404587, 12837, 271, 5, 42, "Text",
  CellTags->"nlug:3.6.3"],

Cell[CellGroupData[{
Cell[404883, 12846, 115, 2, 31, "Input",
  CellTags->"nlug:3.6.3"],
Cell[405001, 12850, 253, 6, 27, "Output",
  CellTags->"nlug:3.6.3"]
}, Open  ]],
Cell[405269, 12859, 606, 15, 59, "Text",
  CellTags->"nlug:3.6.3"],
Cell[405878, 12876, 189, 6, 71, "Input",
  CellTags->"nlug:3.6.3"],
Cell[406070, 12884, 531, 13, 59, "Text",
  CellTags->"nlug:3.6.3"],

Cell[CellGroupData[{
Cell[406626, 12901, 156, 5, 31, "Input",
  CellTags->"nlug:3.6.3"],
Cell[406785, 12908, 94, 3, 27, "Output",
  CellTags->"nlug:3.6.3"]
}, Open  ]],
Cell[406894, 12914, 1065, 22, 110, "Text",
  CellTags->"nlug:3.6.3"],
Cell[407962, 12938, 286, 13, 211, "Input",
  Evaluatable->False,
  CellTags->"nlug:3.6.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[408285, 12956, 67, 1, 39, "Subsection",
  CellTags->"nlug:3.6.4"],
Cell[408355, 12959, 586, 13, 59, "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{
Cell[408966, 12976, 143, 4, 31, "Input",
  CellTags->"nlug:3.6.4"],
Cell[409112, 12982, 254, 6, 27, "Output",
  CellTags->"nlug:3.6.4"]
}, Open  ]],
Cell[409381, 12991, 68, 1, 25, "Text",
  CellTags->"nlug:3.6.4"],
Cell[409452, 12994, 90, 2, 31, "Input",
  CellTags->"nlug:3.6.4"],
Cell[409545, 12998, 239, 7, 25, "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{
Cell[409809, 13009, 99, 2, 31, "Input",
  CellTags->"nlug:3.6.4"],
Cell[409911, 13013, 246, 5, 27, "Output",
  CellTags->"nlug:3.6.4"]
}, Open  ]],
Cell[410172, 13021, 771, 20, 76, "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{
Cell[410968, 13045, 119, 2, 31, "Input",
  CellTags->"nlug:3.6.4"],
Cell[411090, 13049, 658, 19, 65, "Output",
  CellTags->"nlug:3.6.4"]
}, Open  ]],
Cell[411763, 13071, 1191, 26, 110, "Text",
  CellTags->"nlug:3.6.4"],
Cell[412957, 13099, 713, 14, 76, "Text",
  CellTags->"nlug:3.6.4"],

Cell[CellGroupData[{
Cell[413695, 13117, 175, 5, 31, "Input",
  CellTags->"nlug:3.6.4"],
Cell[413873, 13124, 253, 6, 27, "Output",
  CellTags->"nlug:3.6.4"]
}, Open  ]],
Cell[414141, 13133, 187, 4, 25, "Text",
  CellTags->"nlug:3.6.4"],
Cell[414331, 13139, 189, 5, 65, "Program",
  CellTags->"nlug:3.6.4"],
Cell[414523, 13146, 232, 7, 25, "Text",
  CellTags->"nlug:3.6.4"],
Cell[414758, 13155, 882, 20, 76, "Text",
  CellTags->"nlug:3.6.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[415677, 13180, 92, 1, 39, "Subsection",
  CellTags->{"Handling COM Events", "nlug:3.6.5"}],
Cell[415772, 13183, 492, 12, 42, "Text",
  CellTags->"nlug:3.6.5"],
Cell[416267, 13197, 953, 18, 93, "Text",
  CellTags->"nlug:3.6.5"],
Cell[417223, 13217, 334, 8, 42, "Text",
  CellTags->"nlug:3.6.5"],

Cell[CellGroupData[{
Cell[417582, 13229, 122, 2, 31, "Input",
  CellTags->"nlug:3.6.5"],
Cell[417707, 13233, 250, 5, 27, "Output",
  CellTags->"nlug:3.6.5"]
}, Open  ]],
Cell[417972, 13241, 415, 8, 42, "Text",
  CellTags->"nlug:3.6.5"],
Cell[418390, 13251, 67, 1, 25, "Text",
  CellTags->"nlug:3.6.5"],
Cell[418460, 13254, 119, 2, 31, "Input",
  CellTags->"nlug:3.6.5"],
Cell[418582, 13258, 134, 4, 25, "Text",
  CellTags->"nlug:3.6.5"],
Cell[418719, 13264, 120, 5, 51, "Input",
  CellTags->"nlug:3.6.5"],
Cell[418842, 13271, 187, 4, 25, "Text",
  CellTags->"nlug:3.6.5"],

Cell[CellGroupData[{
Cell[419054, 13279, 85, 2, 31, "Input",
  CellTags->"nlug:3.6.5"],
Cell[419142, 13283, 230, 5, 27, "Output",
  CellTags->"nlug:3.6.5"]
}, Open  ]],
Cell[419387, 13291, 433, 7, 42, "Text",
  CellTags->"nlug:3.6.5"],
Cell[419823, 13300, 501, 11, 59, "Text",
  CellTags->"nlug:3.6.5"],

Cell[CellGroupData[{
Cell[420349, 13315, 115, 2, 31, "Input",
  CellTags->"nlug:3.6.5"],
Cell[420467, 13319, 1242, 35, 87, "Output",
  CellTags->"nlug:3.6.5"]
}, Open  ]],
Cell[421724, 13357, 930, 23, 76, "Text",
  CellTags->"nlug:3.6.5"],
Cell[422657, 13382, 642, 18, 59, "Text",
  CellTags->"nlug:3.6.5"],
Cell[423302, 13402, 148, 4, 31, "Input",
  CellTags->"nlug:3.6.5"],
Cell[423453, 13408, 587, 15, 59, "Text",
  CellTags->"nlug:3.6.5"],
Cell[424043, 13425, 276, 9, 131, "Input",
  CellTags->"nlug:3.6.5"],
Cell[424322, 13436, 1141, 30, 93, "Text",
  CellTags->"nlug:3.6.5"],
Cell[425466, 13468, 97, 2, 31, "Input",
  CellTags->"nlug:3.6.5"],
Cell[425566, 13472, 240, 5, 42, "Text",
  CellTags->"nlug:3.6.5"],
Cell[425809, 13479, 90, 1, 25, "Text",
  CellTags->"nlug:3.6.5"],
Cell[425902, 13482, 116, 5, 65, "Input",
  CellTags->"nlug:3.6.5"],
Cell[426021, 13489, 248, 7, 25, "Text",
  CellTags->"nlug:3.6.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[426306, 13501, 75, 1, 39, "Subsection",
  CellTags->"nlug:3.6.6"],
Cell[426384, 13504, 1039, 20, 93, "Text",
  CellTags->"nlug:3.6.6"],
Cell[427426, 13526, 783, 18, 76, "Text",
  CellTags->"nlug:3.6.6"],
Cell[428212, 13546, 90, 1, 31, "Program",
  CellTags->"nlug:3.6.6"],
Cell[428305, 13549, 1466, 39, 127, "Text",
  CellTags->"nlug:3.6.6"],
Cell[429774, 13590, 309, 9, 42, "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{
Cell[430108, 13603, 106, 2, 31, "Input",
  CellTags->"nlug:3.6.6"],
Cell[430217, 13607, 110, 3, 27, "Output",
  CellTags->"nlug:3.6.6"]
}, Open  ]],
Cell[430342, 13613, 358, 8, 42, "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{
Cell[430725, 13625, 104, 2, 31, "Input",
  CellTags->"nlug:3.6.6"],
Cell[430832, 13629, 222, 5, 27, "Output",
  CellTags->"nlug:3.6.6"]
}, Open  ]],
Cell[431069, 13637, 368, 9, 42, "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{
Cell[431462, 13650, 253, 8, 111, "Input",
  CellTags->"nlug:3.6.6"],
Cell[431718, 13660, 227, 5, 27, "Output",
  CellTags->"nlug:3.6.6"]
}, Open  ]],
Cell[431960, 13668, 274, 7, 25, "Text",
  CellTags->"nlug:3.6.6"],

Cell[CellGroupData[{
Cell[432259, 13679, 85, 2, 31, "Input",
  CellTags->"nlug:3.6.6"],
Cell[432347, 13683, 106, 3, 27, "Output",
  CellTags->"nlug:3.6.6"]
}, Open  ]],
Cell[432468, 13689, 545, 14, 59, "Text",
  CellTags->"nlug:3.6.6"],
Cell[433016, 13705, 88, 2, 31, "Input",
  CellTags->"nlug:3.6.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[433141, 13712, 61, 1, 39, "Subsection",
  CellTags->"nlug:3.6.7"],
Cell[433205, 13715, 253, 8, 25, "Text",
  CellTags->"nlug:3.6.7"],
Cell[433461, 13725, 280, 6, 31, "Input",
  CellTags->"nlug:3.6.7"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[433802, 13738, 120, 5, 88, "Chapter"],

Cell[CellGroupData[{
Cell[433947, 13747, 55, 1, 56, "Section",
  CellTags->"nlug:4.0"],
Cell[434005, 13750, 623, 17, 59, "Text",
  CellTags->"nlug:4.0"],
Cell[434631, 13769, 1641, 43, 127, "Text",
  CellTags->"nlug:4.0"],
Cell[436275, 13814, 1016, 24, 93, "Text",
  CellTags->"nlug:4.0"],
Cell[437294, 13840, 832, 27, 42, "Text",
  CellTags->"nlug:4.0"],
Cell[438129, 13869, 411, 10, 42, "Text",
  CellTags->"nlug:4.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[438577, 13884, 105, 5, 42, "Section",
  CellTags->"nlug:4.1"],
Cell[438685, 13891, 858, 21, 93, "Text",
  CellTags->"nlug:4.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[439580, 13917, 135, 5, 42, "Section"],

Cell[CellGroupData[{
Cell[439740, 13926, 60, 1, 39, "Subsection",
  CellTags->"nlug:4.2.0"],
Cell[439803, 13929, 952, 16, 110, "Text",
  CellTags->"nlug:4.2.0"],
Cell[440758, 13947, 756, 22, 59, "Text",
  CellTags->"nlug:4.2.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[441551, 13974, 73, 1, 39, "Subsection",
  CellTags->"nlug:4.2.1"],
Cell[441627, 13977, 861, 24, 76, "Text",
  CellTags->"nlug:4.2.1"],
Cell[442491, 14003, 435, 12, 42, "Text",
  CellTags->"nlug:4.2.1"],
Cell[442929, 14017, 492, 15, 42, "Text",
  CellTags->"nlug:4.2.1"],
Cell[443424, 14034, 626, 14, 76, "Text",
  CellTags->"nlug:4.2.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[444087, 14053, 63, 1, 39, "Subsection",
  CellTags->"nlug:4.2.2"],
Cell[444153, 14056, 455, 14, 42, "Text",
  CellTags->"nlug:4.2.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[444645, 14075, 65, 1, 39, "Subsection",
  CellTags->"nlug:4.2.3"],
Cell[444713, 14078, 497, 14, 42, "Text",
  CellTags->"nlug:4.2.3"],
Cell[445213, 14094, 147, 6, 82, "Program",
  CellTags->"nlug:4.2.3"],
Cell[445363, 14102, 274, 12, 25, "Text",
  CellTags->"nlug:4.2.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[445674, 14119, 52, 1, 39, "Subsection",
  CellTags->"nlug:4.2.4"],
Cell[445729, 14122, 1268, 37, 110, "Text",
  CellTags->"nlug:4.2.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[447034, 14164, 58, 1, 39, "Subsection",
  CellTags->"nlug:4.2.5"],
Cell[447095, 14167, 912, 21, 93, "Text",
  CellTags->"nlug:4.2.5"]
}, Closed]],

Cell[CellGroupData[{
Cell[448044, 14193, 62, 1, 39, "Subsection",
  CellTags->"nlug:4.2.6"],
Cell[448109, 14196, 373, 11, 42, "Text",
  CellTags->"nlug:4.2.6"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[448531, 14213, 57, 1, 42, "Section",
  CellTags->"nlug:4.3"],
Cell[448591, 14216, 590, 18, 42, "Text",
  CellTags->"nlug:4.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[449218, 14239, 50, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[449293, 14243, 133, 6, 39, "Subsection",
  CellTags->"nlug:4.4.0"],
Cell[449429, 14251, 1449, 40, 128, "Text",
  CellTags->"nlug:4.4.0"],
Cell[450881, 14293, 790, 14, 93, "Text",
  CellTags->"nlug:4.4.0"]
}, Closed]],

Cell[CellGroupData[{
Cell[451708, 14312, 79, 1, 39, "Subsection",
  CellTags->"nlug:4.4.1"],
Cell[451790, 14315, 338, 6, 42, "Text",
  CellTags->"nlug:4.4.1"],
Cell[452131, 14323, 619, 12, 76, "Text",
  CellTags->"nlug:4.4.1"],
Cell[452753, 14337, 763, 17, 77, "Text",
  CellTags->"nlug:4.4.1"],
Cell[453519, 14356, 115, 3, 31, "Program",
  CellTags->"nlug:4.4.1"],
Cell[453637, 14361, 93, 1, 25, "Text",
  CellTags->"nlug:4.4.1"],
Cell[453733, 14364, 115, 3, 31, "Program",
  CellTags->"nlug:4.4.1"],
Cell[453851, 14369, 304, 8, 42, "Text",
  CellTags->"nlug:4.4.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[454192, 14382, 72, 1, 39, "Subsection",
  CellTags->"nlug:4.4.2"],
Cell[454267, 14385, 1178, 35, 94, "Text",
  CellTags->"nlug:4.4.2"],
Cell[455448, 14422, 538, 13, 59, "Text",
  CellTags->"nlug:4.4.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[456023, 14440, 66, 1, 39, "Subsection",
  CellTags->"nlug:4.4.3"],
Cell[456092, 14443, 612, 15, 59, "Text",
  CellTags->"nlug:4.4.3"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

