(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     41847,       1237]*)
(*NotebookOutlinePosition[     46622,       1406]*)
(*  CellTagsIndexPosition[     46578,       1402]*)
(*WindowFrame->Palette*)



Notebook[{

Cell[CellGroupData[{
Cell["Arithmetic and Numbers", "Section"],

Cell["Basic operations.", "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder] + \[Placeholder]\),
            ButtonData:>"\[SelectionPlaceholder]+\[Placeholder]"], 
          ButtonBox[\(\[SelectionPlaceholder] - \[Placeholder]\),
            ButtonData:>"\[SelectionPlaceholder]-\[Placeholder]"], 
          ButtonBox[\(\[SelectionPlaceholder]\[Times]\[Placeholder]\),
            ButtonData:>"\[SelectionPlaceholder]\[Times]\[Placeholder]"], 
          ButtonBox[\(\[SelectionPlaceholder]\/\[Placeholder]\),
            ButtonData:>"\!\(\[SelectionPlaceholder]\/\[Placeholder]\)"]},
        {
          ButtonBox[\(-\[SelectionPlaceholder]\),
            ButtonData:>"-\[SelectionPlaceholder]"], 
          ButtonBox[\(\[SelectionPlaceholder]\^\[Placeholder]\),
            ButtonData:>"\!\(\[SelectionPlaceholder]\^\[Placeholder]\)"], 
          ButtonBox[\(\@\[SelectionPlaceholder]\),
            ButtonData:>"\!\(\@\[SelectionPlaceholder]\)"], 
          ButtonBox[\(\@\[SelectionPlaceholder]\%\[Placeholder]\),
            ButtonData:>"\!\(\@\[SelectionPlaceholder]\%\[Placeholder]\)"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell["\<\
Numericalize to machine precision or to specified arbitrary precision.\
\[AutoOperand]\
\>", "Text",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}}],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(N[\[SelectionPlaceholder]]\),
            ButtonData:>"N[\[SelectionPlaceholder]]"], 
          ButtonBox[\(N[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"N[\[SelectionPlaceholder],\[Placeholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Algebra", "Section"],

Cell[CellGroupData[{

Cell["Solving Equations", "Subsection"],

Cell[TextData[{
  "Enter an equation of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["lhs",
            FontSlant->"Italic"], "\[Equal]", 
          StyleBox["rhs",
            FontSlant->"Italic"]}], TraditionalForm]]],
  ", or solve an equation or system of equations."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Equal] \[Placeholder]\),
            ButtonData:>"\[SelectionPlaceholder]\[Equal]\[Placeholder]"]},
        {
          
          ButtonBox[\(Solve[\[SelectionPlaceholder] \[Equal] \[Placeholder], \
\[Placeholder]]\),
            
            ButtonData:>
              "Solve[\[SelectionPlaceholder]\[Equal]\[Placeholder], \
\[Placeholder]]"]},
        {
          
          ButtonBox[\(Solve[{\[SelectionPlaceholder] \[Equal] \[Placeholder], \
\[Placeholder] \[Equal] \[Placeholder]}, \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ {\
\[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "Solve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},{\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(NSolve[\[SelectionPlaceholder] \[Equal] \[Placeholder], \
\[Placeholder]]\),
            
            ButtonData:>
              "NSolve[\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomial Manipulation", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Expand[\[SelectionPlaceholder]]\),
            ButtonData:>"Expand[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Factor[\[SelectionPlaceholder]]\),
            ButtonData:>"Factor[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Together[\[SelectionPlaceholder]]\),
            ButtonData:>"Together[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Apart[\[SelectionPlaceholder]]\),
            ButtonData:>"Apart[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Cancel[\[SelectionPlaceholder]]\),
            ButtonData:>"Cancel[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      RowLines->{
        False, False, False, False, True, False, True, False, False, False, 
          False, True, False}]], "Input",
  Active->True,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Simplification", "Subsection"],

Cell[TextData[{
  StyleBox["Simplify",
    FontFamily->"Courier"],
  " tries various manipulations to make expressions smaller. ",
  StyleBox["FullSimplify",
    FontFamily->"Courier"],
  " tries more manipulations, but takes longer. "
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Simplify[\[SelectionPlaceholder]]\),
            ButtonData:>"Simplify[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Simplify[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"Simplify[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(FullSimplify[\[SelectionPlaceholder]]\),
            ButtonData:>"FullSimplify[\[SelectionPlaceholder]]"]},
        {
          
          ButtonBox[\(FullSimplify[\[SelectionPlaceholder], \[Placeholder]]\),
            
            
            ButtonData:>
              "FullSimplify[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(FunctionExpand[\[SelectionPlaceholder]]\),
            ButtonData:>"FunctionExpand[\[SelectionPlaceholder]]"]},
        {
          
          ButtonBox[\(FunctionExpand[\[SelectionPlaceholder], \[Placeholder]]\
\),
            
            ButtonData:>
              "FunctionExpand[\[SelectionPlaceholder],\[Placeholder]]"]}
        },
      RowSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell["\<\
The two\[Hyphen]argument forms of the simplification functions take \
assumptions in the second argument, which can be formed from the items in the \
following palette.\
\>", "Text"],

Cell[BoxData[GridBox[{
        {GridBox[{
              {
                ButtonBox[\(\[SelectionPlaceholder] > \[Placeholder]\),
                  ButtonData:>"\[SelectionPlaceholder]>\[Placeholder]"], 
                ButtonBox[\(\[SelectionPlaceholder] < \[Placeholder]\),
                  ButtonData:>"\[SelectionPlaceholder]<\[Placeholder]"]},
              {
                
                ButtonBox[\(\[SelectionPlaceholder] \[GreaterEqual] \
\[Placeholder]\),
                  
                  ButtonData:>
                    "\[SelectionPlaceholder]\[GreaterEqual]\[Placeholder]"], 
                
                ButtonBox[\(\[SelectionPlaceholder] \[LessEqual] \
\[Placeholder]\),
                  
                  ButtonData:>
                    "\[SelectionPlaceholder]\[LessEqual]\[Placeholder]"]},
              {
                
                ButtonBox[\(\[SelectionPlaceholder] \[Equal] \[Placeholder]\),
                  
                  
                  ButtonData:>
                    "\[SelectionPlaceholder]\[Equal]\[Placeholder]"], 
                ButtonBox[\(\[SelectionPlaceholder] \[And] \[Placeholder]\),
                  ButtonData:>"\[SelectionPlaceholder]\[And]\[Placeholder]"]}
              },
            RowSpacings->0,
            ColumnSpacings->0,
            ColumnWidths->5,
            GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Element] Complexes\),
            ButtonData:>"\[SelectionPlaceholder]\[Element]Complexes"]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Element] Reals\),
            ButtonData:>"\[SelectionPlaceholder]\[Element]Reals"]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Element] Algebraics\),
            ButtonData:>"\[SelectionPlaceholder]\[Element]Algebraics"]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Element] Rationals\),
            ButtonData:>"\[SelectionPlaceholder]\[Element]Rationals"]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Element] Integers\),
            ButtonData:>"\[SelectionPlaceholder]\[Element]Integers"]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Element] Primes\),
            ButtonData:>"\[SelectionPlaceholder]\[Element]Primes"]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Element] Booleans\),
            ButtonData:>"\[SelectionPlaceholder]\[Element]Booleans"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Complex Numbers", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder] + \[Placeholder]  I\),
            ButtonData:>"\[SelectionPlaceholder]+\[Placeholder]I"]},
        {GridBox[{
              {
                ButtonBox[\(Re[\[SelectionPlaceholder]]\),
                  ButtonData:>"Re[\[SelectionPlaceholder]]"], 
                ButtonBox[\(Im[\[SelectionPlaceholder]]\),
                  ButtonData:>"Im[\[SelectionPlaceholder]]"]},
              {
                ButtonBox[\(Abs[\[SelectionPlaceholder]]\),
                  ButtonData:>"Abs[\[SelectionPlaceholder]]"], 
                ButtonBox[\(Arg[\[SelectionPlaceholder]]\),
                  ButtonData:>"Arg[\[SelectionPlaceholder]]"]}
              },
            RowSpacings->0,
            ColumnSpacings->0,
            GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]},
        {
          ButtonBox[\(Conjugate[\[SelectionPlaceholder]]\),
            ButtonData:>"Conjugate[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  FormatType->TextForm],

Cell[TextData[{
  StyleBox["PowerExpand",
    FontFamily->"Courier"],
  " assumes that variables are positive real with integer exponents, while ",
  StyleBox["ComplexExpand",
    FontFamily->"Courier"],
  " assumes all variables are real."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(PowerExpand[\[SelectionPlaceholder]]\),
            ButtonData:>"PowerExpand[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(ComplexExpand[\[SelectionPlaceholder]]\),
            ButtonData:>"ComplexExpand[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      RowLines->{
        False, False, False, False, True, False, True, False, False, False, 
          False, True, False}]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lists and Matrices", "Section"],

Cell[CellGroupData[{

Cell["Creating Lists and Matrices", "Subsection"],

Cell[TextData[{
  "When entering a vector or a matrix, add rows by typing ",
  StyleBox["\[ControlKey]\[LeftModified]\[ReturnIndicator]\[RightModified]", 
    "Output"],
  " and add columns by typing ",
  StyleBox["\[ControlKey]\[LeftModified],\[RightModified]", "Output"],
  "."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"(", GridBox[{
                  {"\[Placeholder]"},
                  {"\[Placeholder]"}
                  }], ")"}],
            
            ButtonData:>
              "\!\((\*GridBox[{{\"\[Placeholder]\"},{\"\[Placeholder]\"}}])\)\
"], 
          ButtonBox[
            RowBox[{"(", GridBox[{
                  {"\[Placeholder]", "\[Placeholder]"}
                  }], ")"}],
            
            ButtonData:>
              "\!\((\*GridBox[{{\"\[Placeholder]\",\"\[Placeholder]\"}}])\)"],
           "", 
          ButtonBox[
            RowBox[{"(", GridBox[{
                  {"\[Placeholder]", "\[Placeholder]"},
                  {"\[Placeholder]", "\[Placeholder]"}
                  }], ")"}],
            
            ButtonData:>
              "\!\((\*GridBox[{{\"\[Placeholder]\",\"\[Placeholder]\"},{\"\
\[Placeholder]\",\"\[Placeholder]\"}}])\)"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell[TextData[{
  "One way to create lists and matrices automatically is to iterate a \
variable over a range of values with ",
  StyleBox["Table",
    FontFamily->"Courier"],
  ", using the iterator {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  "} or {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  ", ",
  StyleBox["increment",
    FontSlant->"Italic"],
  "}. When given a list, many math functions operate on each element of the \
list."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(Table[\[SelectionPlaceholder], {\[Placeholder], \
\[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "Table[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]}]"]},
        {
          
          ButtonBox[\(Table[\[SelectionPlaceholder], {\[Placeholder], \
\[Placeholder], \[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "Table[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(Table[\[SelectionPlaceholder], {\[Placeholder], \
\[Placeholder], \[Placeholder]}, \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
{\[Placeholder], \[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "Table[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrix Operations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder] . \[Placeholder]\),
            ButtonData:>"\[SelectionPlaceholder].\[Placeholder]"]},
        {
          ButtonBox[\(Cross[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"Cross[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          
          ButtonBox[\(Outer[\[SelectionPlaceholder], \[Placeholder], \
\[Placeholder]]\),
            
            ButtonData:>
              "Outer[\[SelectionPlaceholder],\[Placeholder],\[Placeholder]]"]}\
,
        {
          
          ButtonBox[\(ListConvolve[\[SelectionPlaceholder], \[Placeholder]]\),
            
            
            ButtonData:>
              "ListConvolve[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          
          ButtonBox[\(ListCorrelate[\[SelectionPlaceholder], \
\[Placeholder]]\),
            
            ButtonData:>
              "ListCorrelate[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(Tr[\[SelectionPlaceholder]]\),
            ButtonData:>"Tr[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Det[\[SelectionPlaceholder]]\),
            ButtonData:>"Det[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Inverse[\[SelectionPlaceholder]]\),
            ButtonData:>"Inverse[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Transpose[\[SelectionPlaceholder]]\),
            ButtonData:>"Transpose[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Eigenvalues[\[SelectionPlaceholder]]\),
            ButtonData:>"Eigenvalues[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Eigenvectors[\[SelectionPlaceholder]]\),
            ButtonData:>"Eigenvectors[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(LinearSolve[\[SelectionPlaceholder], \[Placeholder]]\),
            
            ButtonData:>
              "LinearSolve[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(RowReduce[\[SelectionPlaceholder]]\),
            ButtonData:>"RowReduce[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell["\<\
A common variation of the convolution and correlation operations is to \
\[OpenCurlyDoubleQuote]pad\[CloseCurlyDoubleQuote] the data set with zeros. \
For vectors, the following forms can be used.\
\>", "Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(ListConvolve[\[SelectionPlaceholder], \[Placeholder], \
\[IndentingNewLine]\ \ \ \ {1, \(-1\)}, 0]\),
            
            ButtonData:>
              "ListConvolve[\[SelectionPlaceholder],\[Placeholder],{1,-1},0]"]\
},
        {
          
          ButtonBox[\(ListCorrelate[\[SelectionPlaceholder], \[Placeholder], \
\ \[IndentingNewLine]\ \ \ \ \ {1, \(-1\)}, 0]\),
            
            ButtonData:>
              "ListCorrelate[\[SelectionPlaceholder],\[Placeholder],{1,-1},0]\
"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Trigonometric and Exponential Functions", "Section"],

Cell[CellGroupData[{

Cell["Trigonometric", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Sin[\[SelectionPlaceholder]]\),
            ButtonData:>"Sin[\[SelectionPlaceholder]]"], 
          ButtonBox[\(ArcSin[\[SelectionPlaceholder]]\),
            ButtonData:>"ArcSin[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Cos[\[SelectionPlaceholder]]\),
            ButtonData:>"Cos[\[SelectionPlaceholder]]"], 
          ButtonBox[\(ArcCos[\[SelectionPlaceholder]]\),
            ButtonData:>"ArcCos[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Tan[\[SelectionPlaceholder]]\),
            ButtonData:>"Tan[\[SelectionPlaceholder]]"], 
          ButtonBox[\(ArcTan[\[SelectionPlaceholder]]\),
            ButtonData:>"ArcTan[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnsEqual->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell["\<\
Manipulation of trigonometric expressions to alternate forms.\
\>", "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(TrigExpand[\[SelectionPlaceholder]]\),
            ButtonData:>"TrigExpand[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(TrigFactor[\[SelectionPlaceholder]]\),
            ButtonData:>"TrigFactor[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(TrigReduce[\[SelectionPlaceholder]]\),
            ButtonData:>"TrigReduce[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(ExpToTrig[\[SelectionPlaceholder]]\),
            ButtonData:>"ExpToTrig[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(TrigToExp[\[SelectionPlaceholder]]\),
            ButtonData:>"TrigToExp[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      RowLines->{
        False, False, False, False, True, False, True, False, False, False, 
          False, True, False}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exponential and Logarithmic", "Subsection"],

Cell[TextData[{
  StyleBox["Log[10,\[ThinSpace]x]",
    FontFamily->"Courier"],
  " is the base 10 logarithm."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Log[\[SelectionPlaceholder]]\),
            ButtonData:>"Log[\[SelectionPlaceholder]]"], 
          ButtonBox[\(Log[10, \ \[SelectionPlaceholder]]\),
            ButtonData:>"Log[10,\[SelectionPlaceholder]]"], 
          ButtonBox[\(Exp[\[SelectionPlaceholder]]\),
            ButtonData:>"Exp[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperbolic", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Sinh[\[SelectionPlaceholder]]\),
            ButtonData:>"Sinh[\[SelectionPlaceholder]]"], 
          ButtonBox[\(ArcSinh[\[SelectionPlaceholder]]\),
            ButtonData:>"ArcSinh[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Cosh[\[SelectionPlaceholder]]\),
            ButtonData:>"Cosh[\[SelectionPlaceholder]]"], 
          ButtonBox[\(ArcCosh[\[SelectionPlaceholder]]\),
            ButtonData:>"ArcCosh[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Tanh[\[SelectionPlaceholder]]\),
            ButtonData:>"Tanh[\[SelectionPlaceholder]]"], 
          ButtonBox[\(ArcTanh[\[SelectionPlaceholder]]\),
            ButtonData:>"ArcTanh[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnsEqual->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Calculus", "Section"],

Cell[CellGroupData[{

Cell["Common Operations", "Subsection"],

Cell[TextData[{
  Cell[BoxData[
      \(\[PartialD]\_x f[x]\)]],
  " is the derivative of ",
  Cell[BoxData[
      \(\(\(\[InvisibleSpace]\)\(f[x]\)\)\)]],
  " with respect to ",
  StyleBox["x",
    FontFamily->"Courier"],
  ", while ",
  Cell[BoxData[
      \(\[PartialD]\_\(x, y\)f[x, y]\)]],
  " is the derivative with respect to ",
  StyleBox["x",
    FontFamily->"Courier"],
  " and ",
  StyleBox["y",
    FontFamily->"Courier"],
  "."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{
              StyleBox["\[Integral]",
                ScriptLevel->0], 
              RowBox[{"\[SelectionPlaceholder]", 
                StyleBox["\[ThinSpace]",
                  ScriptLevel->0], 
                StyleBox[\(\[DifferentialD]\[Placeholder]\),
                  ScriptLevel->0]}]}],
            
            ButtonData:>
              "\!\(\[Integral]\[SelectionPlaceholder] \[DifferentialD]\
\[Placeholder]\)"], 
          ButtonBox[\(\[PartialD]\_\[Placeholder]\ \[SelectionPlaceholder]\),
            
            ButtonData:>
              "\!\(\[PartialD]\_\[Placeholder] \[SelectionPlaceholder]\)"]},
        {
          ButtonBox[
            RowBox[{
              StyleBox[\(\[Integral]\_\[Placeholder]\%\[Placeholder]\),
                ScriptLevel->0], 
              RowBox[{"\[SelectionPlaceholder]", 
                StyleBox["\[ThinSpace]",
                  ScriptLevel->0], 
                StyleBox[\(\[DifferentialD]\[Placeholder]\),
                  ScriptLevel->0]}]}],
            
            ButtonData:>
              "\!\(\[Integral]\_\[Placeholder]\%\[Placeholder] \
\[SelectionPlaceholder] \[DifferentialD]\[Placeholder]\)"], 
          
          ButtonBox[\(\[PartialD]\_\(\[Placeholder], \[Placeholder]\)\
\[SelectionPlaceholder]\),
            
            ButtonData:>
              "\!\(\[PartialD]\_\(\[Placeholder], \[Placeholder]\)\
\[SelectionPlaceholder]\)"]},
        {
          ButtonBox[
            RowBox[{
              
              StyleBox[\(\[Sum]\+\(\[Placeholder] = \[Placeholder]\)\%\
\[Placeholder]\),
                ScriptLevel->0], 
              StyleBox[" ",
                ScriptLevel->0], "\[SelectionPlaceholder]"}],
            
            ButtonData:>
              "\!\(\[Sum]\+\(\[Placeholder] = \
\[Placeholder]\)\%\[Placeholder] \[SelectionPlaceholder]\)"], 
          ButtonBox[
            RowBox[{
              
              StyleBox[\(\[Product]\+\(\[Placeholder] = \[Placeholder]\)\%\
\[Placeholder]\),
                ScriptLevel->0], 
              StyleBox[" ",
                ScriptLevel->0], "\[SelectionPlaceholder]"}],
            
            ButtonData:>
              "\!\(\[Product]\+\(\[Placeholder] = \[Placeholder]\)\%\
\[Placeholder] \[SelectionPlaceholder]\)"]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"],

Cell[TextData[{
  "Series expansions are expressed in terms of a variable at a point for a \
given number of terms in the form {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["point",
    FontSlant->"Italic"],
  ", ",
  StyleBox["terms",
    FontSlant->"Italic"],
  "}."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(Limit[\[SelectionPlaceholder], \[Placeholder] \[Rule] \
\[Placeholder]]\),
            
            ButtonData:>
              "Limit[\[SelectionPlaceholder],\[Placeholder]\[Rule]\
\[Placeholder]]"]},
        {
          
          ButtonBox[\(Series[\[SelectionPlaceholder], {\[Placeholder], \ \
\[Placeholder], \ \[Placeholder]}]\),
            
            ButtonData:>
              "Series[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]}]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Differential Equations", "Subsection"],

Cell["\<\
Solve a differential equation, specifying the equation, the function to be \
found, and the variable. You may give initial conditions in the form of \
equations. \
\>", "Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(DSolve[\[SelectionPlaceholder]\  \[Equal] \ \
\[Placeholder], \ \[Placeholder], \ \[Placeholder]]\),
            
            ButtonData:>
              "DSolve[\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder],\[Placeholder]]"]},
        {
          
          ButtonBox[\(DSolve[{\[SelectionPlaceholder]\  \[Equal] \ \
\[Placeholder], \ \[Placeholder]\  \[Equal] \ \[Placeholder]}, \n\t\ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \[Placeholder], \ \[Placeholder]]\),
            
            ButtonData:>
              "DSolve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},\[Placeholder],\[Placeholder]]"]},
        {
          
          ButtonBox[\(DSolve[{\[SelectionPlaceholder]\  \[Equal] \ \
\[Placeholder], \ \[Placeholder]\  \[Equal] \ \[Placeholder]}, \n\t\ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ {\[Placeholder], \ \[Placeholder]}, \ \[Placeholder]]\),
            
            
            ButtonData:>
              "DSolve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},{\[Placeholder],\[Placeholder]},\
\[Placeholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"],

Cell[TextData[{
  "A numeric method can be used where a range is specified for the variable \
in the form ",
  StyleBox["{var,\[ThinSpace]min,\[ThinSpace]max}",
    FontFamily->"Courier"],
  "."
}], "Text"],

Cell[BoxData[
    ButtonBox[\(NDSolve[{\[SelectionPlaceholder]\  \[Equal] \ \[Placeholder], \
\ \[Placeholder]\  \[Equal] \ \[Placeholder]}, \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \[Placeholder], \ {\[Placeholder], \ \[Placeholder], \ \
\[Placeholder]}]\),
      ButtonData:>
        "NDSolve[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\[Placeholder]\
\[Equal]\[Placeholder]},\[Placeholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]}]"]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolic Transforms", "Subsection"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(ZTransform[\[SelectionPlaceholder], \[Placeholder], \
\[Placeholder]]\),
            
            ButtonData:>
              "ZTransform[\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]]"]},
        {
          
          ButtonBox[\(InverseZTransform[\[SelectionPlaceholder], \
\[Placeholder], \[Placeholder]]\),
            
            ButtonData:>
              "InverseZTransform[\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]]"]},
        {
          
          ButtonBox[\(LaplaceTransform[\[SelectionPlaceholder], \
\[Placeholder], \[Placeholder]]\),
            
            ButtonData:>
              "LaplaceTransform[\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]]"]},
        {
          
          ButtonBox[\(InverseLaplaceTransform[\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \t\[SelectionPlaceholder], \[Placeholder], \[Placeholder]]\),
            
            ButtonData:>
              "InverseLaplaceTransform[\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]]"]},
        {
          
          ButtonBox[\(FourierTransform[\[SelectionPlaceholder], \
\[Placeholder], \[Placeholder]]\),
            
            ButtonData:>
              "FourierTransform[\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]]"]},
        {
          
          ButtonBox[\(InverseFourierTransform[\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \t\[SelectionPlaceholder], \[Placeholder], \[Placeholder]]\),
            
            ButtonData:>
              "InverseFourierTransform[\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell["The following functions are found frequently in transforms.", "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(DiracDelta[\[SelectionPlaceholder]]\),
            ButtonData:>"DiracDelta[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(DiscreteDelta[\[SelectionPlaceholder]]\),
            ButtonData:>"DiscreteDelta[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(UnitStep[\[SelectionPlaceholder]]\),
            ButtonData:>"UnitStep[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numeric Root Finding", "Subsection"],

Cell["\<\
If you can't solve an equation exactly, you may be able to find particular \
numeric solutions using methods that require one or two starting points for \
finding the solution. You may also solve systems of equations this way.\
\>", "Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(FindRoot[\[SelectionPlaceholder] \[Equal] \
\[Placeholder], \ {\[Placeholder], \ \[Placeholder]}]\),
            
            ButtonData:>
              "FindRoot[\[SelectionPlaceholder]\[Equal]\[Placeholder],{\
\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(FindRoot[\[SelectionPlaceholder] \[Equal] \
\[Placeholder], \n\t\ \ \ \ \ \ \ \ \ {\[Placeholder], \ {\[Placeholder], \ \
\[Placeholder]}}]\),
            
            ButtonData:>
              "FindRoot[\[SelectionPlaceholder]\[Equal]\[Placeholder],{\
\[Placeholder],{\[Placeholder],\[Placeholder]}}]"]},
        {
          
          ButtonBox[\(FindRoot[{\[SelectionPlaceholder] \[Equal] \
\[Placeholder], \ \[Placeholder] \[Equal] \[Placeholder]}, \n\t\ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {\[Placeholder], \ \[Placeholder]}, \ {\
\[Placeholder], \ \[Placeholder]}]\),
            
            ButtonData:>
              "FindRoot[{\[SelectionPlaceholder]\[Equal]\[Placeholder],\
\[Placeholder]\[Equal]\[Placeholder]},{\[Placeholder],\[Placeholder]},{\
\[Placeholder],\[Placeholder]}]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Functions", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains a large number of functions, of which only a small fraction can \
be found in this palette. The following two sections contain a few of the \
additional math functions."
}], "Text"],

Cell[CellGroupData[{

Cell["Integer Functions", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Floor[\[SelectionPlaceholder]]\),
            ButtonData:>"Floor[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Ceiling[\[SelectionPlaceholder]]\),
            ButtonData:>"Ceiling[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Round[\[SelectionPlaceholder]]\),
            ButtonData:>"Round[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Chop[\[SelectionPlaceholder]]\),
            ButtonData:>"Chop[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Mod[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"Mod[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(Quotient[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"Quotient[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(GCD[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"GCD[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(LCM[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"LCM[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(FactorInteger[\[SelectionPlaceholder]]\),
            ButtonData:>"FactorInteger[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Rationalize[\[SelectionPlaceholder]]\),
            ButtonData:>"Rationalize[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(BitAnd[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"BitAnd[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(BitOr[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"BitOr[\[SelectionPlaceholder],\[Placeholder]]"]},
        {
          ButtonBox[\(BitXor[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonData:>"BitXor[\[SelectionPlaceholder],\[Placeholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Special Functions", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[SelectionPlaceholder]!\),
            ButtonData:>"\[SelectionPlaceholder]!"]},
        {
          ButtonBox[\(BesselI[\[Placeholder], \[SelectionPlaceholder]]\),
            ButtonData:>"BesselI[\[Placeholder],\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(BesselJ[\[Placeholder], \[SelectionPlaceholder]]\),
            ButtonData:>"BesselJ[\[Placeholder],\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(BesselK[\[Placeholder], \[SelectionPlaceholder]]\),
            ButtonData:>"BesselK[\[Placeholder],\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(BesselY[\[Placeholder], \[SelectionPlaceholder]]\),
            ButtonData:>"BesselY[\[Placeholder],\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Erf[\[SelectionPlaceholder]]\),
            ButtonData:>"Erf[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Gamma[\[SelectionPlaceholder]]\),
            ButtonData:>"Gamma[\[SelectionPlaceholder]]"]},
        {
          ButtonBox[\(Zeta[\[SelectionPlaceholder]]\),
            ButtonData:>"Zeta[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphics", "Section"],

Cell[TextData[{
  "Many plotting functions take a function or list of functions as the first \
argument, and variable ranges in the form of {",
  StyleBox["var",
    FontSlant->"Italic"],
  ", ",
  StyleBox["min",
    FontSlant->"Italic"],
  ", ",
  StyleBox["max",
    FontSlant->"Italic"],
  "} as additional arguments."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(Plot[\[SelectionPlaceholder], {\[Placeholder], \
\[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "Plot[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]}]"]},
        {
          
          ButtonBox[\(Plot[{\[SelectionPlaceholder], \[Placeholder]}, {\
\[Placeholder], \[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "Plot[{\[SelectionPlaceholder],\[Placeholder]},{\[Placeholder],\
\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(ParametricPlot[{\[SelectionPlaceholder], \
\[Placeholder]}, \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ {\[Placeholder], \
\[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "ParametricPlot[{\[SelectionPlaceholder],\[Placeholder]},{\
\[Placeholder],\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(Plot3D[\[SelectionPlaceholder], \n\t\ \ \
{\[Placeholder], \[Placeholder], \[Placeholder]}, {\[Placeholder], \
\[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "Plot3D[\[SelectionPlaceholder],{\[Placeholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(ParametricPlot3D[\n\t\ \ \ \ \ \ \ {\
\[SelectionPlaceholder], \[Placeholder], \[Placeholder]}, \n\ \ \ \ \ \ \ \t{\
\[Placeholder], \[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "ParametricPlot3D[{\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(ParametricPlot3D[\n\t\ \ \ \ {\[SelectionPlaceholder], \
\[Placeholder], \[Placeholder]}, \n\t\ \ \ \ {\[Placeholder], \[Placeholder], \
\[Placeholder]}, {\[Placeholder], \[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "ParametricPlot3D[{\[SelectionPlaceholder],\[Placeholder],\
\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]},{\[Placeholder]\
,\[Placeholder],\[Placeholder]}]"]},
        {
          
          ButtonBox[\(ContourPlot[\[SelectionPlaceholder], \n\t\ \ \ {\
\[Placeholder], \[Placeholder], \[Placeholder]}, {\[Placeholder], \
\[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "ContourPlot[\[SelectionPlaceholder],{\[Placeholder],\
\[Placeholder],\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]\
"]},
        {
          
          ButtonBox[\(DensityPlot[\[SelectionPlaceholder], \n\t\ \ \ {\
\[Placeholder], \[Placeholder], \[Placeholder]}, {\[Placeholder], \
\[Placeholder], \[Placeholder]}]\),
            
            ButtonData:>
              "DensityPlot[\[SelectionPlaceholder],{\[Placeholder],\
\[Placeholder],\[Placeholder]},{\[Placeholder],\[Placeholder],\[Placeholder]}]\
"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnAlignments->{Left},
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell[TextData[{
  "To plot data, or lists of numbers, use ",
  StyleBox["ListPlot",
    FontFamily->"Courier"],
  ". It takes a list of ",
  StyleBox["y",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  " values, or ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["x",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["y",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  " pairs. The points can be made into a line . ",
  StyleBox["ListPlot3D",
    FontFamily->"Courier"],
  " only accepts an array of z values."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(ListPlot[\[SelectionPlaceholder]]\),
            ButtonData:>"ListPlot[\[SelectionPlaceholder]]"]},
        {
          
          ButtonBox[\(ListPlot[\[SelectionPlaceholder], \n\t
              PlotJoined \[Rule] True]\),
            
            ButtonData:>
              "ListPlot[\[SelectionPlaceholder],PlotJoined\[Rule]True]"]},
        {
          ButtonBox[\(ListPlot3D[\[SelectionPlaceholder]]\),
            ButtonData:>"ListPlot3D[\[SelectionPlaceholder]]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnAlignments->{Left},
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"]
}, Closed]]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
ClosingAutoSave->True,
Editable->False,
WindowSize->{235, 461},
WindowMargins->{{Automatic, 5}, {Automatic, 2}},
WindowFrame->"Palette",
WindowElements->"VerticalScrollBar",
WindowFrameElements->{"CloseBox", "ZoomBox", "ResizeArea"},
WindowClickSelect->False,
WindowTitle->None,
ShowCellBracket->False,
Active->True,
Background->GrayLevel[1],
StyleDefinitions -> Notebook[{
  Cell["\<\
          Prototypes for the BasicCalculations Palette. This abbreviated \
style sheet is used to reduce the size of the notebook as a whole while still \
allowing the styles to be easily modifed. Remember that all other styles will \
be adopted from the default style sheet.          \
\>", "Text"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->16],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellBracketOptions->{"Margins"->{1, 1},
    "Widths"->{0, 5}},
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->None,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{19, Inherited}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 20}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 20}},
    FontSize->14],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{25, Inherited}, {Inherited, 8}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 15}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 15}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    ShowCellBracket->False,
    CellMargins->{{6, Inherited}, {0, Inherited}},
    FontFamily->"Times"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, Inherited}, {10, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{14, Inherited}, {0, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{4, Inherited}, {0, 2}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->False,
    CellMargins->{{5, Inherited}, {Inherited, Inherited}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{45, Inherited}, {20, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{30, Inherited}, {10, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->10]
  }, Closed]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1728, 52, 41, 0, 39, "Section"],
Cell[1772, 54, 33, 0, 70, "Text"],
Cell[1808, 56, 1221, 22, 70, "Input"],
Cell[3032, 80, 167, 4, 70, "Text"],
Cell[3202, 86, 404, 9, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3643, 100, 26, 0, 25, "Section"],

Cell[CellGroupData[{
Cell[3694, 104, 39, 0, 70, "Subsection"],
Cell[3736, 106, 317, 10, 70, "Text"],
Cell[4056, 118, 1137, 31, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5230, 154, 45, 0, 70, "Subsection"],
Cell[5278, 156, 1278, 35, 70, "Input",
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6593, 196, 36, 0, 70, "Subsection"],
Cell[6632, 198, 247, 7, 70, "Text"],
Cell[6882, 207, 1140, 29, 70, "Input"],
Cell[8025, 238, 192, 4, 70, "Text"],
Cell[8220, 244, 2575, 58, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[10832, 307, 37, 0, 70, "Subsection"],
Cell[10872, 309, 1136, 26, 70, "Input"],
Cell[12011, 337, 252, 7, 70, "Text"],
Cell[12266, 346, 471, 11, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12786, 363, 37, 0, 25, "Section"],

Cell[CellGroupData[{
Cell[12848, 367, 49, 0, 70, "Subsection"],
Cell[12900, 369, 291, 7, 70, "Text"],
Cell[13194, 378, 1068, 31, 70, "Input"],
Cell[14265, 411, 666, 28, 70, "Text"],
Cell[14934, 441, 1119, 29, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[16090, 475, 39, 0, 70, "Subsection"],
Cell[16132, 477, 2231, 58, 70, "Input"],
Cell[18366, 537, 220, 4, 70, "Text"],
Cell[18589, 543, 685, 20, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19323, 569, 58, 0, 43, "Section"],

Cell[CellGroupData[{
Cell[19406, 573, 35, 0, 70, "Subsection"],
Cell[19444, 575, 893, 20, 70, "Input"],
Cell[20340, 597, 85, 2, 70, "Text"],
Cell[20428, 601, 867, 20, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[21332, 626, 49, 0, 70, "Subsection"],
Cell[21384, 628, 122, 4, 70, "Text"],
Cell[21509, 634, 502, 11, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[22048, 650, 32, 0, 70, "Subsection"],
Cell[22083, 652, 905, 20, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23037, 678, 27, 0, 25, "Section"],

Cell[CellGroupData[{
Cell[23089, 682, 39, 0, 70, "Subsection"],
Cell[23131, 684, 452, 19, 70, "Text"],
Cell[23586, 705, 2417, 67, 70, "Input"],
Cell[26006, 774, 301, 12, 70, "Text"],
Cell[26310, 788, 606, 19, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[26953, 812, 44, 0, 70, "Subsection"],
Cell[27000, 814, 186, 4, 70, "Text"],
Cell[27189, 820, 1253, 31, 70, "Input"],
Cell[28445, 853, 206, 6, 70, "Text"],
Cell[28654, 861, 464, 8, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[29155, 874, 41, 0, 70, "Subsection"],
Cell[29199, 876, 1755, 52, 70, "Input"],
Cell[30957, 930, 75, 0, 70, "Text"],
Cell[31035, 932, 557, 13, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[31629, 950, 42, 0, 70, "Subsection"],
Cell[31674, 952, 250, 4, 70, "Text"],
Cell[31927, 958, 1229, 31, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33205, 995, 34, 0, 25, "Section"],
Cell[33242, 997, 262, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[33529, 1007, 39, 0, 70, "Subsection"],
Cell[33571, 1009, 2030, 43, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[35638, 1057, 39, 0, 70, "Subsection"],
Cell[35680, 1059, 1277, 28, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37006, 1093, 27, 0, 25, "Section"],
Cell[37036, 1095, 334, 12, 70, "Text"],
Cell[37373, 1109, 3117, 78, 70, "Input"],
Cell[40493, 1189, 651, 25, 70, "Text"],
Cell[41147, 1216, 684, 18, 70, "Input"]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

