(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    115819,       3059]*)
(*NotebookOutlinePosition[    117069,       3103]*)
(*  CellTagsIndexPosition[    117025,       3099]*)
(*WindowFrame->Palette*)



Notebook[{

Cell[CellGroupData[{
Cell["Letters", "Text",
  CellMargins->{{12, Inherited}, {Inherited, 4}},
  CellGroupingRules->{"SectionGrouping", 10},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Greek", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[Alpha]",
            ButtonNote->"\[EscapeKey]a\[EscapeKey], \[Backslash][Alpha]"], 
          ButtonBox["\[Beta]",
            ButtonNote->"\[EscapeKey]b\[EscapeKey], \[Backslash][Beta]"], 
          ButtonBox["\[Gamma]",
            ButtonNote->"\[EscapeKey]g\[EscapeKey], \[Backslash][Gamma]"], 
          ButtonBox["\[Delta]",
            ButtonNote->"\[EscapeKey]d\[EscapeKey], \[Backslash][Delta]"], 
          ButtonBox["\[Epsilon]",
            ButtonNote->"\[EscapeKey]e\[EscapeKey], \[Backslash][Epsilon]"], 
          ButtonBox["\[CurlyEpsilon]",
            
            ButtonNote->
              "\[EscapeKey]ce\[EscapeKey], \[Backslash][CurlyEpsilon]"], 
          ButtonBox["\[Zeta]",
            ButtonNote->"\[EscapeKey]z\[EscapeKey], \[Backslash][Zeta]"], 
          ButtonBox["\[Eta]",
            ButtonNote->"\[EscapeKey]et\[EscapeKey], \[Backslash][Eta]"], 
          ButtonBox["\[Theta]",
            ButtonNote->"\[EscapeKey]th\[EscapeKey], \[Backslash][Theta]"]},
        {
          ButtonBox["\[CurlyTheta]",
            
            ButtonNote->
              "\[EscapeKey]cq\[EscapeKey], \[Backslash][CurlyTheta]"], 
          ButtonBox["\[Iota]",
            ButtonNote->"\[EscapeKey]i\[EscapeKey], \[Backslash][Iota]"], 
          ButtonBox["\[Kappa]",
            ButtonNote->"\[EscapeKey]k\[EscapeKey], \[Backslash][Kappa]"], 
          ButtonBox["\[CurlyKappa]",
            
            ButtonNote->
              "\[EscapeKey]ck\[EscapeKey], \[Backslash][CurlyKappa]"], 
          ButtonBox["\[Lambda]",
            ButtonNote->"\[EscapeKey]l\[EscapeKey], \[Backslash][Lambda]"], 
          ButtonBox["\[Mu]",
            ButtonNote->"\[EscapeKey]m\[EscapeKey], \[Backslash][Mu]"], 
          ButtonBox["\[Nu]",
            ButtonNote->"\[EscapeKey]n\[EscapeKey], \[Backslash][Nu]"], 
          ButtonBox["\[Xi]",
            ButtonNote->"\[EscapeKey]x\[EscapeKey], \[Backslash][Xi]"], 
          ButtonBox["\[Omicron]",
            
            ButtonNote->
              "\[EscapeKey]om\[EscapeKey], \[Backslash][Omicron]"]},
        {
          ButtonBox["\[Pi]",
            ButtonNote->"\[EscapeKey]p\[EscapeKey], \[Backslash][Pi]"], 
          ButtonBox["\[CurlyPi]",
            ButtonNote->"\[EscapeKey]cp\[EscapeKey], \[Backslash][CurlyPi]"], 
          
          ButtonBox["\[Rho]",
            ButtonNote->"\[EscapeKey]r\[EscapeKey], \[Backslash][Rho]"], 
          ButtonBox["\[CurlyRho]",
            ButtonNote->"\[EscapeKey]cr\[EscapeKey], \[Backslash][CurlyRho]"],
           
          ButtonBox["\[Sigma]",
            ButtonNote->"\[EscapeKey]s\[EscapeKey], \[Backslash][Sigma]"], 
          ButtonBox["\[FinalSigma]",
            
            ButtonNote->
              "\[EscapeKey]fs\[EscapeKey], \[Backslash][FinalSigma]"], 
          ButtonBox["\[Tau]",
            ButtonNote->"\[EscapeKey]t\[EscapeKey], \[Backslash][Tau]"], 
          ButtonBox["\[Upsilon]",
            ButtonNote->"\[EscapeKey]u\[EscapeKey], \[Backslash][Upsilon]"], 
          ButtonBox["\[Phi]",
            ButtonNote->"\[EscapeKey]ph\[EscapeKey], \[Backslash][Phi]"]},
        {
          ButtonBox["\[CurlyPhi]",
            ButtonNote->"\[EscapeKey]j\[EscapeKey], \[Backslash][CurlyPhi]"], 
          
          ButtonBox["\[Chi]",
            ButtonNote->"\[EscapeKey]ch\[EscapeKey], \[Backslash][Chi]"], 
          ButtonBox["\[Psi]",
            ButtonNote->"\[EscapeKey]ps\[EscapeKey], \[Backslash][Psi]"], 
          ButtonBox["\[Omega]",
            ButtonNote->"\[EscapeKey]o\[EscapeKey], \[Backslash][Omega]"], 
          ButtonBox["\[Digamma]",
            ButtonNote->"\[EscapeKey]di\[EscapeKey], \[Backslash][Digamma]"], 
          
          ButtonBox["\[Koppa]",
            ButtonNote->"\[EscapeKey]ko\[EscapeKey], \[Backslash][Koppa]"], 
          ButtonBox["\[Stigma]",
            ButtonNote->"\[EscapeKey]sti\[EscapeKey], \[Backslash][Stigma]"], 
          
          ButtonBox["\[Sampi]",
            ButtonNote->"\[EscapeKey]sa\[EscapeKey], \[Backslash][Sampi]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[CapitalAlpha]",
            
            ButtonNote->
              "\[EscapeKey]A\[EscapeKey], \[Backslash][CapitalAlpha]"], 
          ButtonBox["\[CapitalBeta]",
            
            ButtonNote->
              "\[EscapeKey]B\[EscapeKey], \[Backslash][CapitalBeta]"], 
          ButtonBox["\[CapitalGamma]",
            
            ButtonNote->
              "\[EscapeKey]G\[EscapeKey], \[Backslash][CapitalGamma]"], 
          ButtonBox["\[CapitalDelta]",
            
            ButtonNote->
              "\[EscapeKey]D\[EscapeKey], \[Backslash][CapitalDelta]"], 
          ButtonBox["\[CapitalEpsilon]",
            
            ButtonNote->
              "\[EscapeKey]E\[EscapeKey], \[Backslash][CapitalEpsilon]"], 
          ButtonBox["\[CapitalZeta]",
            
            ButtonNote->
              "\[EscapeKey]Z\[EscapeKey], \[Backslash][CapitalZeta]"], 
          ButtonBox["\[CapitalEta]",
            
            ButtonNote->
              "\[EscapeKey]Et\[EscapeKey], \[Backslash][CapitalEta]"], 
          ButtonBox["\[CapitalTheta]",
            
            ButtonNote->
              "\[EscapeKey]Th\[EscapeKey], \[Backslash][CapitalTheta]"], 
          ButtonBox["\[CapitalIota]",
            
            ButtonNote->
              "\[EscapeKey]I\[EscapeKey], \[Backslash][CapitalIota]"]},
        {
          ButtonBox["\[CapitalKappa]",
            
            ButtonNote->
              "\[EscapeKey]K\[EscapeKey], \[Backslash][CapitalKappa]"], 
          ButtonBox["\[CapitalLambda]",
            
            ButtonNote->
              "\[EscapeKey]L\[EscapeKey], \[Backslash][CapitalLambda]"], 
          ButtonBox["\[CapitalMu]",
            ButtonNote->"\[EscapeKey]M\[EscapeKey], \[Backslash][CapitalMu]"],
           
          ButtonBox["\[CapitalNu]",
            ButtonNote->"\[EscapeKey]N\[EscapeKey], \[Backslash][CapitalNu]"],
           
          ButtonBox["\[CapitalXi]",
            ButtonNote->"\[EscapeKey]X\[EscapeKey], \[Backslash][CapitalXi]"],
           
          ButtonBox["\[CapitalOmicron]",
            
            ButtonNote->
              "\[EscapeKey]Om\[EscapeKey], \[Backslash][CapitalOmicron]"], 
          ButtonBox["\[CapitalPi]",
            ButtonNote->"\[EscapeKey]P\[EscapeKey], \[Backslash][CapitalPi]"],
           
          ButtonBox["\[CapitalRho]",
            
            ButtonNote->
              "\[EscapeKey]R\[EscapeKey], \[Backslash][CapitalRho]"], 
          ButtonBox["\[CapitalSigma]",
            
            ButtonNote->
              "\[EscapeKey]S\[EscapeKey], \[Backslash][CapitalSigma]"]},
        {
          ButtonBox["\[CapitalTau]",
            
            ButtonNote->
              "\[EscapeKey]T\[EscapeKey], \[Backslash][CapitalTau]"], 
          ButtonBox["\[CapitalUpsilon]",
            
            ButtonNote->
              "\[EscapeKey]U\[EscapeKey], \[Backslash][CapitalUpsilon]"], 
          ButtonBox["\[CurlyCapitalUpsilon]",
            
            ButtonNote->
              "\[EscapeKey]cU\[EscapeKey], \
\[Backslash][CurlyCapitalUpsilon]"], 
          ButtonBox["\[CapitalPhi]",
            
            ButtonNote->
              "\[EscapeKey]Ph\[EscapeKey], \[Backslash][CapitalPhi]"], 
          ButtonBox["\[CapitalChi]",
            
            ButtonNote->
              "\[EscapeKey]Ch\[EscapeKey], \[Backslash][CapitalChi]"], 
          ButtonBox["\[CapitalPsi]",
            
            ButtonNote->
              "\[EscapeKey]Ps\[EscapeKey], \[Backslash][CapitalPsi]"], 
          ButtonBox["\[CapitalOmega]",
            
            ButtonNote->
              "\[EscapeKey]O\[EscapeKey], \[Backslash][CapitalOmega]"], 
          ButtonBox["\[CapitalDigamma]",
            
            ButtonNote->
              "\[EscapeKey]Di\[EscapeKey], \[Backslash][CapitalDigamma]"], 
          ButtonBox["\[CapitalKoppa]",
            
            ButtonNote->
              "\[EscapeKey]Ko\[EscapeKey], \[Backslash][CapitalKoppa]"]},
        {
          ButtonBox["\[CapitalStigma]",
            ButtonNote->
              "\[EscapeKey]Sti\[EscapeKey], \[Backslash][CapitalStigma]"], 
          ButtonBox["\[CapitalSampi]",
            
            ButtonNote->
              "\[EscapeKey]Sa\[EscapeKey], \[Backslash][CapitalSampi]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]}
        },
      RowSpacings->{0, 0, 0, 1, 0},
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Script", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[ScriptA]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]sca\[EscapeKey], \[Backslash][ScriptA]"],
           
          ButtonBox["\[ScriptB]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scb\[EscapeKey], \[Backslash][ScriptB]"],
           
          ButtonBox["\[ScriptC]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scc\[EscapeKey], \[Backslash][ScriptC]"],
           
          ButtonBox["\[ScriptD]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scd\[EscapeKey], \[Backslash][ScriptD]"],
           
          ButtonBox["\[ScriptE]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]sce\[EscapeKey], \[Backslash][ScriptE]"],
           
          ButtonBox["\[ScriptF]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scf\[EscapeKey], \[Backslash][ScriptF]"],
           
          ButtonBox["\[ScriptG]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scg\[EscapeKey], \[Backslash][ScriptG]"]},
        {
          ButtonBox["\[ScriptH]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]sch\[EscapeKey], \[Backslash][ScriptH]"],
           
          ButtonBox["\[ScriptI]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]sci\[EscapeKey], \[Backslash][ScriptI]"],
           
          ButtonBox["\[ScriptJ]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scj\[EscapeKey], \[Backslash][ScriptJ]"],
           
          ButtonBox["\[ScriptK]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]sck\[EscapeKey], \[Backslash][ScriptK]"],
           
          ButtonBox["\[ScriptL]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scl\[EscapeKey], \[Backslash][ScriptL]"],
           
          ButtonBox["\[ScriptM]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scm\[EscapeKey], \[Backslash][ScriptM]"],
           
          ButtonBox["\[ScriptN]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scn\[EscapeKey], \[Backslash][ScriptN]"]},
        {
          ButtonBox["\[ScriptO]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]sco\[EscapeKey], \[Backslash][ScriptO]"],
           
          ButtonBox["\[ScriptP]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scp\[EscapeKey], \[Backslash][ScriptP]"],
           
          ButtonBox["\[ScriptQ]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scq\[EscapeKey], \[Backslash][ScriptQ]"],
           
          ButtonBox["\[ScriptR]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scr\[EscapeKey], \[Backslash][ScriptR]"],
           
          ButtonBox["\[ScriptS]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scs\[EscapeKey], \[Backslash][ScriptS]"],
           
          ButtonBox["\[ScriptT]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]sct\[EscapeKey], \[Backslash][ScriptT]"],
           
          ButtonBox["\[ScriptU]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scu\[EscapeKey], \[Backslash][ScriptU]"]},
        {
          ButtonBox["\[ScriptV]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scv\[EscapeKey], \[Backslash][ScriptV]"],
           
          ButtonBox["\[ScriptW]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scw\[EscapeKey], \[Backslash][ScriptW]"],
           
          ButtonBox["\[ScriptX]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scx\[EscapeKey], \[Backslash][ScriptX]"],
           
          ButtonBox["\[ScriptY]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scy\[EscapeKey], \[Backslash][ScriptY]"],
           
          ButtonBox["\[ScriptZ]",
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]scz\[EscapeKey], \[Backslash][ScriptZ]"],
           
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[ScriptCapitalA]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scA\[EscapeKey], \[Backslash][ScriptCapitalA]"], 
          ButtonBox["\[ScriptCapitalB]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scB\[EscapeKey], \[Backslash][ScriptCapitalB]"], 
          ButtonBox["\[ScriptCapitalC]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scC\[EscapeKey], \[Backslash][ScriptCapitalC]"], 
          ButtonBox["\[ScriptCapitalD]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scD\[EscapeKey], \[Backslash][ScriptCapitalD]"], 
          ButtonBox["\[ScriptCapitalE]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scE\[EscapeKey], \[Backslash][ScriptCapitalE]"], 
          ButtonBox["\[ScriptCapitalF]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scF\[EscapeKey], \[Backslash][ScriptCapitalF]"], 
          ButtonBox["\[ScriptCapitalG]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scG\[EscapeKey], \[Backslash][ScriptCapitalG]"]},
        {
          ButtonBox["\[ScriptCapitalH]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scH\[EscapeKey], \[Backslash][ScriptCapitalH]"], 
          ButtonBox["\[ScriptCapitalI]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scI\[EscapeKey], \[Backslash][ScriptCapitalI]"], 
          ButtonBox["\[ScriptCapitalJ]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scJ\[EscapeKey], \[Backslash][ScriptCapitalJ]"], 
          ButtonBox["\[ScriptCapitalK]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scK\[EscapeKey], \[Backslash][ScriptCapitalK]"], 
          ButtonBox["\[ScriptCapitalL]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scL\[EscapeKey], \[Backslash][ScriptCapitalL]"], 
          ButtonBox["\[ScriptCapitalM]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scM\[EscapeKey], \[Backslash][ScriptCapitalM]"], 
          ButtonBox["\[ScriptCapitalN]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scN\[EscapeKey], \[Backslash][ScriptCapitalN]"]},
        {
          ButtonBox["\[ScriptCapitalO]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scO\[EscapeKey], \[Backslash][ScriptCapitalO]"], 
          ButtonBox["\[ScriptCapitalP]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scP\[EscapeKey], \[Backslash][ScriptCapitalP]"], 
          ButtonBox["\[ScriptCapitalQ]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scQ\[EscapeKey], \[Backslash][ScriptCapitalQ]"], 
          ButtonBox["\[ScriptCapitalR]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scR\[EscapeKey], \[Backslash][ScriptCapitalR]"], 
          ButtonBox["\[ScriptCapitalS]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scS\[EscapeKey], \[Backslash][ScriptCapitalS]"], 
          ButtonBox["\[ScriptCapitalT]",
            ButtonStyle->"Paste",
            ButtonNote->
              "\[EscapeKey]scT\[EscapeKey], \[Backslash][ScriptCapitalT]"], 
          ButtonBox["\[ScriptCapitalU]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scU\[EscapeKey], \[Backslash][ScriptCapitalU]"]},
        {
          ButtonBox["\[ScriptCapitalV]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scV\[EscapeKey], \[Backslash][ScriptCapitalV]"], 
          ButtonBox["\[ScriptCapitalW]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scW\[EscapeKey], \[Backslash][ScriptCapitalW]"], 
          ButtonBox["\[ScriptCapitalX]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scX\[EscapeKey], \[Backslash][ScriptCapitalX]"], 
          ButtonBox["\[ScriptCapitalY]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scY\[EscapeKey], \[Backslash][ScriptCapitalY]"], 
          ButtonBox["\[ScriptCapitalZ]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]scZ\[EscapeKey], \[Backslash][ScriptCapitalZ]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[ScriptOne]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc1\[EscapeKey], \[Backslash][ScriptOne]"], 
          ButtonBox["\[ScriptTwo]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc2\[EscapeKey], \[Backslash][ScriptTwo]"], 
          ButtonBox["\[ScriptThree]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc3\[EscapeKey], \[Backslash][ScriptThree]"], 
          ButtonBox["\[ScriptFour]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc4\[EscapeKey], \[Backslash][ScriptFour]"], 
          ButtonBox["\[ScriptFive]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc5\[EscapeKey], \[Backslash][ScriptFive]"], 
          ButtonBox["\[ScriptSix]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc6\[EscapeKey], \[Backslash][ScriptSix]"], 
          ButtonBox["\[ScriptSeven]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc7\[EscapeKey], \[Backslash][ScriptSeven]"]},
        {
          ButtonBox["\[ScriptEight]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc8\[EscapeKey], \[Backslash][ScriptEight]"], 
          ButtonBox["\[ScriptNine]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc9\[EscapeKey], \[Backslash][ScriptNine]"], 
          ButtonBox["\[ScriptZero]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]sc0\[EscapeKey], \[Backslash][ScriptZero]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]}
        },
      RowSpacings->{0, 0, 0, 1, 0, 0, 0, 1, 0},
      ColumnSpacings->0]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Gothic", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[GothicA]",
            ButtonNote->"\[EscapeKey]goa\[EscapeKey], \[Backslash][GothicA]"],
           
          ButtonBox["\[GothicB]",
            ButtonNote->"\[EscapeKey]gob\[EscapeKey], \[Backslash][GothicB]"],
           
          ButtonBox["\[GothicC]",
            ButtonNote->"\[EscapeKey]goc\[EscapeKey], \[Backslash][GothicC]"],
           
          ButtonBox["\[GothicD]",
            ButtonNote->"\[EscapeKey]god\[EscapeKey], \[Backslash][GothicD]"],
           
          ButtonBox["\[GothicE]",
            ButtonNote->"\[EscapeKey]goe\[EscapeKey], \[Backslash][GothicE]"],
           
          ButtonBox["\[GothicF]",
            ButtonNote->"\[EscapeKey]gof\[EscapeKey], \[Backslash][GothicF]"],
           
          ButtonBox["\[GothicG]",
            
            ButtonNote->
              "\[EscapeKey]gog\[EscapeKey], \[Backslash][GothicG]"]},
        {
          ButtonBox["\[GothicH]",
            ButtonNote->"\[EscapeKey]goh\[EscapeKey], \[Backslash][GothicH]"],
           
          ButtonBox["\[GothicI]",
            ButtonNote->"\[EscapeKey]goi\[EscapeKey], \[Backslash][GothicI]"],
           
          ButtonBox["\[GothicJ]",
            ButtonNote->"\[EscapeKey]goj\[EscapeKey], \[Backslash][GothicJ]"],
           
          ButtonBox["\[GothicK]",
            ButtonNote->"\[EscapeKey]gok\[EscapeKey], \[Backslash][GothicK]"],
           
          ButtonBox["\[GothicL]",
            ButtonNote->"\[EscapeKey]gol\[EscapeKey], \[Backslash][GothicL]"],
           
          ButtonBox["\[GothicM]",
            ButtonNote->"\[EscapeKey]gom\[EscapeKey], \[Backslash][GothicM]"],
           
          ButtonBox["\[GothicN]",
            
            ButtonNote->
              "\[EscapeKey]gon\[EscapeKey], \[Backslash][GothicN]"]},
        {
          ButtonBox["\[GothicO]",
            ButtonNote->"\[EscapeKey]goo\[EscapeKey], \[Backslash][GothicO]"],
           
          ButtonBox["\[GothicP]",
            ButtonNote->"\[EscapeKey]gop\[EscapeKey], \[Backslash][GothicP]"],
           
          ButtonBox["\[GothicQ]",
            ButtonNote->"\[EscapeKey]goq\[EscapeKey], \[Backslash][GothicQ]"],
           
          ButtonBox["\[GothicR]",
            ButtonNote->"\[EscapeKey]gor\[EscapeKey], \[Backslash][GothicR]"],
           
          ButtonBox["\[GothicS]",
            ButtonNote->"\[EscapeKey]gos\[EscapeKey], \[Backslash][GothicS]"],
           
          ButtonBox["\[GothicT]",
            ButtonNote->"\[EscapeKey]got\[EscapeKey], \[Backslash][GothicT]"],
           
          ButtonBox["\[GothicU]",
            
            ButtonNote->
              "\[EscapeKey]gou\[EscapeKey], \[Backslash][GothicU]"]},
        {
          ButtonBox["\[GothicV]",
            ButtonNote->"\[EscapeKey]gov\[EscapeKey], \[Backslash][GothicV]"],
           
          ButtonBox["\[GothicW]",
            ButtonNote->"\[EscapeKey]gow\[EscapeKey], \[Backslash][GothicW]"],
           
          ButtonBox["\[GothicX]",
            ButtonNote->"\[EscapeKey]gox\[EscapeKey], \[Backslash][GothicX]"],
           
          ButtonBox["\[GothicY]",
            ButtonNote->"\[EscapeKey]goy\[EscapeKey], \[Backslash][GothicY]"],
           
          ButtonBox["\[GothicZ]",
            ButtonNote->"\[EscapeKey]goz\[EscapeKey], \[Backslash][GothicZ]"],
           
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[GothicCapitalA]",
            
            ButtonNote->
              "\[EscapeKey]goA\[EscapeKey], \[Backslash][GothicCapitalA]"], 
          ButtonBox["\[GothicCapitalB]",
            
            ButtonNote->
              "\[EscapeKey]goB\[EscapeKey], \[Backslash][GothicCapitalB]"], 
          ButtonBox["\[GothicCapitalC]",
            
            ButtonNote->
              "\[EscapeKey]goC\[EscapeKey], \[Backslash][GothicCapitalC]"], 
          ButtonBox["\[GothicCapitalD]",
            
            ButtonNote->
              "\[EscapeKey]goD\[EscapeKey], \[Backslash][GothicCapitalD]"], 
          ButtonBox["\[GothicCapitalE]",
            
            ButtonNote->
              "\[EscapeKey]goE\[EscapeKey], \[Backslash][GothicCapitalE]"], 
          ButtonBox["\[GothicCapitalF]",
            
            ButtonNote->
              "\[EscapeKey]goF\[EscapeKey], \[Backslash][GothicCapitalF]"], 
          ButtonBox["\[GothicCapitalG]",
            
            ButtonNote->
              "\[EscapeKey]goG\[EscapeKey], \[Backslash][GothicCapitalG]"]},
        {
          ButtonBox["\[GothicCapitalH]",
            
            ButtonNote->
              "\[EscapeKey]goH\[EscapeKey], \[Backslash][GothicCapitalH]"], 
          ButtonBox["\[GothicCapitalI]",
            
            ButtonNote->
              "\[EscapeKey]goI\[EscapeKey], \[Backslash][GothicCapitalI]"], 
          ButtonBox["\[GothicCapitalJ]",
            
            ButtonNote->
              "\[EscapeKey]goJ\[EscapeKey], \[Backslash][GothicCapitalJ]"], 
          ButtonBox["\[GothicCapitalK]",
            
            ButtonNote->
              "\[EscapeKey]goK\[EscapeKey], \[Backslash][GothicCapitalK]"], 
          ButtonBox["\[GothicCapitalL]",
            
            ButtonNote->
              "\[EscapeKey]goL\[EscapeKey], \[Backslash][GothicCapitalL]"], 
          ButtonBox["\[GothicCapitalM]",
            
            ButtonNote->
              "\[EscapeKey]goM\[EscapeKey], \[Backslash][GothicCapitalM]"], 
          ButtonBox["\[GothicCapitalN]",
            
            ButtonNote->
              "\[EscapeKey]goN\[EscapeKey], \[Backslash][GothicCapitalN]"]},
        {
          ButtonBox["\[GothicCapitalO]",
            
            ButtonNote->
              "\[EscapeKey]goO\[EscapeKey], \[Backslash][GothicCapitalO]"], 
          ButtonBox["\[GothicCapitalP]",
            
            ButtonNote->
              "\[EscapeKey]goP\[EscapeKey], \[Backslash][GothicCapitalP]"], 
          ButtonBox["\[GothicCapitalQ]",
            
            ButtonNote->
              "\[EscapeKey]goQ\[EscapeKey], \[Backslash][GothicCapitalQ]"], 
          ButtonBox["\[GothicCapitalR]",
            
            ButtonNote->
              "\[EscapeKey]goR\[EscapeKey], \[Backslash][GothicCapitalR]"], 
          ButtonBox["\[GothicCapitalS]",
            ButtonNote->
              "\[EscapeKey]goS\[EscapeKey], \[Backslash][GothicCapitalS]"], 
          ButtonBox["\[GothicCapitalT]",
            
            ButtonNote->
              "\[EscapeKey]goT\[EscapeKey], \[Backslash][GothicCapitalT]"], 
          ButtonBox["\[GothicCapitalU]",
            
            ButtonNote->
              "\[EscapeKey]goU\[EscapeKey], \[Backslash][GothicCapitalU]"]},
        {
          ButtonBox["\[GothicCapitalV]",
            
            ButtonNote->
              "\[EscapeKey]goV\[EscapeKey], \[Backslash][GothicCapitalV]"], 
          ButtonBox["\[GothicCapitalW]",
            
            ButtonNote->
              "\[EscapeKey]goW\[EscapeKey], \[Backslash][GothicCapitalW]"], 
          ButtonBox["\[GothicCapitalX]",
            
            ButtonNote->
              "\[EscapeKey]goX\[EscapeKey], \[Backslash][GothicCapitalX]"], 
          ButtonBox["\[GothicCapitalY]",
            
            ButtonNote->
              "\[EscapeKey]goY\[EscapeKey], \[Backslash][GothicCapitalY]"], 
          ButtonBox["\[GothicCapitalZ]",
            
            ButtonNote->
              "\[EscapeKey]goZ\[EscapeKey], \[Backslash][GothicCapitalZ]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[GothicOne]",
            
            ButtonNote->
              "\[EscapeKey]go1\[EscapeKey], \[Backslash][GothicOne]"], 
          ButtonBox["\[GothicTwo]",
            
            ButtonNote->
              "\[EscapeKey]go2\[EscapeKey], \[Backslash][GothicTwo]"], 
          ButtonBox["\[GothicThree]",
            
            ButtonNote->
              "\[EscapeKey]go3\[EscapeKey], \[Backslash][GothicThree]"], 
          ButtonBox["\[GothicFour]",
            
            ButtonNote->
              "\[EscapeKey]go4\[EscapeKey], \[Backslash][GothicFour]"], 
          ButtonBox["\[GothicFive]",
            
            ButtonNote->
              "\[EscapeKey]go5\[EscapeKey], \[Backslash][GothicFive]"], 
          ButtonBox["\[GothicSix]",
            ButtonNote->
              "\[EscapeKey]go6\[EscapeKey], \[Backslash][GothicSix]"], 
          ButtonBox["\[GothicSeven]",
            
            ButtonNote->
              "\[EscapeKey]go7\[EscapeKey], \[Backslash][GothicSeven]"]},
        {
          ButtonBox["\[GothicEight]",
            
            ButtonNote->
              "\[EscapeKey]go8\[EscapeKey], \[Backslash][GothicEight]"], 
          ButtonBox["\[GothicNine]",
            
            ButtonNote->
              "\[EscapeKey]go9\[EscapeKey], \[Backslash][GothicNine]"], 
          ButtonBox["\[GothicZero]",
            
            ButtonNote->
              "\[EscapeKey]go0\[EscapeKey], \[Backslash][GothicZero]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]}
        },
      RowSpacings->{0, 0, 0, 1, 0, 0, 0, 1, 0},
      ColumnSpacings->0]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Double\[Dash]Struck", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[DoubleStruckA]",
            
            ButtonNote->
              "\[EscapeKey]dsa\[EscapeKey], \[Backslash][DoubleStruckA]"], 
          ButtonBox["\[DoubleStruckB]",
            
            ButtonNote->
              "\[EscapeKey]dsb\[EscapeKey], \[Backslash][DoubleStruckB]"], 
          ButtonBox["\[DoubleStruckC]",
            
            ButtonNote->
              "\[EscapeKey]dsc\[EscapeKey], \[Backslash][DoubleStruckC]"], 
          ButtonBox["\[DoubleStruckD]",
            
            ButtonNote->
              "\[EscapeKey]dsd\[EscapeKey], \[Backslash][DoubleStruckD]"], 
          ButtonBox["\[DoubleStruckE]",
            
            ButtonNote->
              "\[EscapeKey]dse\[EscapeKey], \[Backslash][DoubleStruckE]"], 
          ButtonBox["\[DoubleStruckF]",
            
            ButtonNote->
              "\[EscapeKey]dsf\[EscapeKey], \[Backslash][DoubleStruckF]"], 
          ButtonBox["\[DoubleStruckG]",
            
            ButtonNote->
              "\[EscapeKey]dsg\[EscapeKey], \[Backslash][DoubleStruckG]"]},
        {
          ButtonBox["\[DoubleStruckH]",
            
            ButtonNote->
              "\[EscapeKey]dsh\[EscapeKey], \[Backslash][DoubleStruckH]"], 
          ButtonBox["\[DoubleStruckI]",
            
            ButtonNote->
              "\[EscapeKey]dsi\[EscapeKey], \[Backslash][DoubleStruckI]"], 
          ButtonBox["\[DoubleStruckJ]",
            
            ButtonNote->
              "\[EscapeKey]dsj\[EscapeKey], \[Backslash][DoubleStruckJ]"], 
          ButtonBox["\[DoubleStruckK]",
            
            ButtonNote->
              "\[EscapeKey]dsk\[EscapeKey], \[Backslash][DoubleStruckK]"], 
          ButtonBox["\[DoubleStruckL]",
            
            ButtonNote->
              "\[EscapeKey]dsl\[EscapeKey], \[Backslash][DoubleStruckL]"], 
          ButtonBox["\[DoubleStruckM]",
            
            ButtonNote->
              "\[EscapeKey]dsm\[EscapeKey], \[Backslash][DoubleStruckM]"], 
          ButtonBox["\[DoubleStruckN]",
            
            ButtonNote->
              "\[EscapeKey]dsn\[EscapeKey], \[Backslash][DoubleStruckN]"]},
        {
          ButtonBox["\[DoubleStruckO]",
            
            ButtonNote->
              "\[EscapeKey]dso\[EscapeKey], \[Backslash][DoubleStruckO]"], 
          ButtonBox["\[DoubleStruckP]",
            
            ButtonNote->
              "\[EscapeKey]dsp\[EscapeKey], \[Backslash][DoubleStruckP]"], 
          ButtonBox["\[DoubleStruckQ]",
            
            ButtonNote->
              "\[EscapeKey]dsq\[EscapeKey], \[Backslash][DoubleStruckQ]"], 
          ButtonBox["\[DoubleStruckR]",
            
            ButtonNote->
              "\[EscapeKey]dsr\[EscapeKey], \[Backslash][DoubleStruckR]"], 
          ButtonBox["\[DoubleStruckS]",
            
            ButtonNote->
              "\[EscapeKey]dss\[EscapeKey], \[Backslash][DoubleStruckS]"], 
          ButtonBox["\[DoubleStruckT]",
            
            ButtonNote->
              "\[EscapeKey]dst\[EscapeKey], \[Backslash][DoubleStruckT]"], 
          ButtonBox["\[DoubleStruckU]",
            
            ButtonNote->
              "\[EscapeKey]dsu\[EscapeKey], \[Backslash][DoubleStruckU]"]},
        {
          ButtonBox["\[DoubleStruckV]",
            
            ButtonNote->
              "\[EscapeKey]dsv\[EscapeKey], \[Backslash][DoubleStruckV]"], 
          ButtonBox["\[DoubleStruckW]",
            
            ButtonNote->
              "\[EscapeKey]dsw\[EscapeKey], \[Backslash][DoubleStruckW]"], 
          ButtonBox["\[DoubleStruckX]",
            
            ButtonNote->
              "\[EscapeKey]dsx\[EscapeKey], \[Backslash][DoubleStruckX]"], 
          ButtonBox["\[DoubleStruckY]",
            
            ButtonNote->
              "\[EscapeKey]dsy\[EscapeKey], \[Backslash][DoubleStruckY]"], 
          ButtonBox["\[DoubleStruckZ]",
            
            ButtonNote->
              "\[EscapeKey]dsz\[EscapeKey], \[Backslash][DoubleStruckZ]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[DoubleStruckCapitalA]",
            
            ButtonNote->
              "\[EscapeKey]dsA\[EscapeKey], \
\[Backslash][DoubleStruckCapitalA]"], 
          ButtonBox["\[DoubleStruckCapitalB]",
            
            ButtonNote->
              "\[EscapeKey]dsB\[EscapeKey], \
\[Backslash][DoubleStruckCapitalB]"], 
          ButtonBox["\[DoubleStruckCapitalC]",
            
            ButtonNote->
              "\[EscapeKey]dsC\[EscapeKey], \
\[Backslash][DoubleStruckCapitalC]"], 
          ButtonBox["\[DoubleStruckCapitalD]",
            
            ButtonNote->
              "\[EscapeKey]dsD\[EscapeKey], \
\[Backslash][DoubleStruckCapitalD]"], 
          ButtonBox["\[DoubleStruckCapitalE]",
            
            ButtonNote->
              "\[EscapeKey]dsE\[EscapeKey], \
\[Backslash][DoubleStruckCapitalE]"], 
          ButtonBox["\[DoubleStruckCapitalF]",
            
            ButtonNote->
              "\[EscapeKey]dsF\[EscapeKey], \
\[Backslash][DoubleStruckCapitalF]"], 
          ButtonBox["\[DoubleStruckCapitalG]",
            
            ButtonNote->
              "\[EscapeKey]dsG\[EscapeKey], \
\[Backslash][DoubleStruckCapitalG]"]},
        {
          ButtonBox["\[DoubleStruckCapitalH]",
            
            ButtonNote->
              "\[EscapeKey]dsH\[EscapeKey], \
\[Backslash][DoubleStruckCapitalH]"], 
          ButtonBox["\[DoubleStruckCapitalI]",
            
            ButtonNote->
              "\[EscapeKey]dsI\[EscapeKey], \
\[Backslash][DoubleStruckCapitalI]"], 
          ButtonBox["\[DoubleStruckCapitalJ]",
            
            ButtonNote->
              "\[EscapeKey]dsJ\[EscapeKey], \
\[Backslash][DoubleStruckCapitalJ]"], 
          ButtonBox["\[DoubleStruckCapitalK]",
            
            ButtonNote->
              "\[EscapeKey]dsK\[EscapeKey], \
\[Backslash][DoubleStruckCapitalK]"], 
          ButtonBox["\[DoubleStruckCapitalL]",
            
            ButtonNote->
              "\[EscapeKey]dsL\[EscapeKey], \
\[Backslash][DoubleStruckCapitalL]"], 
          ButtonBox["\[DoubleStruckCapitalM]",
            
            ButtonNote->
              "\[EscapeKey]dsM\[EscapeKey], \
\[Backslash][DoubleStruckCapitalM]"], 
          ButtonBox["\[DoubleStruckCapitalN]",
            
            ButtonNote->
              "\[EscapeKey]dsN\[EscapeKey], \
\[Backslash][DoubleStruckCapitalN]"]},
        {
          ButtonBox["\[DoubleStruckCapitalO]",
            
            ButtonNote->
              "\[EscapeKey]dsO\[EscapeKey], \
\[Backslash][DoubleStruckCapitalO]"], 
          ButtonBox["\[DoubleStruckCapitalP]",
            
            ButtonNote->
              "\[EscapeKey]dsP\[EscapeKey], \
\[Backslash][DoubleStruckCapitalP]"], 
          ButtonBox["\[DoubleStruckCapitalQ]",
            
            ButtonNote->
              "\[EscapeKey]dsQ\[EscapeKey], \
\[Backslash][DoubleStruckCapitalQ]"], 
          ButtonBox["\[DoubleStruckCapitalR]",
            
            ButtonNote->
              "\[EscapeKey]dsR\[EscapeKey], \
\[Backslash][DoubleStruckCapitalR]"], 
          ButtonBox["\[DoubleStruckCapitalS]",
            
            ButtonNote->
              "\[EscapeKey]dsS\[EscapeKey], \
\[Backslash][DoubleStruckCapitalS]"], 
          ButtonBox["\[DoubleStruckCapitalT]",
            
            ButtonNote->
              "\[EscapeKey]dsT\[EscapeKey], \
\[Backslash][DoubleStruckCapitalT]"], 
          ButtonBox["\[DoubleStruckCapitalU]",
            
            ButtonNote->
              "\[EscapeKey]dsU\[EscapeKey], \
\[Backslash][DoubleStruckCapitalU]"]},
        {
          ButtonBox["\[DoubleStruckCapitalV]",
            
            ButtonNote->
              "\[EscapeKey]dsV\[EscapeKey], \
\[Backslash][DoubleStruckCapitalV]"], 
          ButtonBox["\[DoubleStruckCapitalW]",
            
            ButtonNote->
              "\[EscapeKey]dsW\[EscapeKey], \
\[Backslash][DoubleStruckCapitalW]"], 
          ButtonBox["\[DoubleStruckCapitalX]",
            
            ButtonNote->
              "\[EscapeKey]dsX\[EscapeKey], \
\[Backslash][DoubleStruckCapitalX]"], 
          ButtonBox["\[DoubleStruckCapitalY]",
            
            ButtonNote->
              "\[EscapeKey]dsY\[EscapeKey], \
\[Backslash][DoubleStruckCapitalY]"], 
          ButtonBox["\[DoubleStruckCapitalZ]",
            
            ButtonNote->
              "\[EscapeKey]dsZ\[EscapeKey], \
\[Backslash][DoubleStruckCapitalZ]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[DoubleStruckOne]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds1\[EscapeKey], \[Backslash][DoubleStruckOne]"], 
          ButtonBox["\[DoubleStruckTwo]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds2\[EscapeKey], \[Backslash][DoubleStruckTwo]"], 
          ButtonBox["\[DoubleStruckThree]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds3\[EscapeKey], \[Backslash][DoubleStruckThree]"],
           
          ButtonBox["\[DoubleStruckFour]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds4\[EscapeKey], \[Backslash][DoubleStruckFour]"], 
          
          ButtonBox["\[DoubleStruckFive]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds5\[EscapeKey], \[Backslash][DoubleStruckFive]"], 
          
          ButtonBox["\[DoubleStruckSix]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds6\[EscapeKey], \[Backslash][DoubleStruckSix]"], 
          ButtonBox["\[DoubleStruckSeven]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds7\[EscapeKey], \
\[Backslash][DoubleStruckSeven]"]},
        {
          ButtonBox["\[DoubleStruckEight]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds8\[EscapeKey], \[Backslash][DoubleStruckEight]"],
           
          ButtonBox["\[DoubleStruckNine]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds9\[EscapeKey], \[Backslash][DoubleStruckNine]"], 
          
          ButtonBox["\[DoubleStruckZero]",
            ButtonStyle->"Paste",
            
            ButtonNote->
              "\[EscapeKey]ds0\[EscapeKey], \[Backslash][DoubleStruckZero]"], 
          
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]}
        },
      RowSpacings->{0, 0, 0, 1, 0, 0, 0, 1, 0},
      ColumnSpacings->0]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Extended Latin", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[AGrave]",
            ButtonNote->"\[EscapeKey]a`\[EscapeKey], \[Backslash][AGrave]"], 
          ButtonBox["\[AAcute]",
            ButtonNote->"\[EscapeKey]a'\[EscapeKey], \[Backslash][AAcute]"], 
          ButtonBox["\[AHat]",
            ButtonNote->"\[EscapeKey]a^\[EscapeKey], \[Backslash][AHat]"], 
          ButtonBox["\[ATilde]",
            ButtonNote->"\[EscapeKey]a~\[EscapeKey], \[Backslash][ATilde]"], 
          ButtonBox["\[ACup]",
            ButtonNote->"\[EscapeKey]au\[EscapeKey], \[Backslash][ACup]"], 
          ButtonBox["\[ADoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]a\"\[EscapeKey], \[Backslash][ADoubleDot]"], 
          ButtonBox["\[ABar]",
            ButtonNote->"\[EscapeKey]a-\[EscapeKey], \[Backslash][ABar]"]},
        {
          ButtonBox["\[ARing]",
            ButtonNote->"\[EscapeKey]ao\[EscapeKey], \[Backslash][ARing]"], 
          ButtonBox["\[AE]",
            ButtonNote->"\[EscapeKey]ae\[EscapeKey], \[Backslash][AE]"], 
          ButtonBox["\[CAcute]",
            ButtonNote->"\[EscapeKey]c'\[EscapeKey], \[Backslash][CAcute]"], 
          ButtonBox["\[CHacek]",
            ButtonNote->"\[EscapeKey]cv\[EscapeKey], \[Backslash][CHacek]"], 
          ButtonBox["\[CCedilla]",
            ButtonNote->"\[EscapeKey]c,\[EscapeKey], \[Backslash][CCedilla]"],
           
          ButtonBox["\[EGrave]",
            ButtonNote->"\[EscapeKey]e`\[EscapeKey], \[Backslash][EGrave]"], 
          ButtonBox["\[EAcute]",
            ButtonNote->"\[EscapeKey]e'\[EscapeKey], \[Backslash][EAcute]"]},
        {
          ButtonBox["\[EHat]",
            ButtonNote->"\[EscapeKey]e^\[EscapeKey], \[Backslash][EHat]"], 
          ButtonBox["\[ECup]",
            ButtonNote->"\[EscapeKey]eu\[EscapeKey], \[Backslash][ECup]"], 
          ButtonBox["\[EDoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]e\"\[EscapeKey], \[Backslash][EDoubleDot]"], 
          ButtonBox["\[EBar]",
            ButtonNote->"\[EscapeKey]e-\[EscapeKey], \[Backslash][EBar]"], 
          ButtonBox["\[IGrave]",
            ButtonNote->"\[EscapeKey]i`\[EscapeKey], \[Backslash][IGrave]"], 
          ButtonBox["\[IAcute]",
            ButtonNote->"\[EscapeKey]i'\[EscapeKey], \[Backslash][IAcute]"], 
          ButtonBox["\[IHat]",
            ButtonNote->"\[EscapeKey]i^\[EscapeKey], \[Backslash][IHat]"]},
        {
          ButtonBox["\[ICup]",
            ButtonNote->"\[EscapeKey]iu\[EscapeKey], \[Backslash][ICup]"], 
          ButtonBox["\[IDoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]i\"\[EscapeKey], \[Backslash][IDoubleDot]"], 
          ButtonBox["\[Eth]",
            ButtonNote->"\[EscapeKey]d-\[EscapeKey], \[Backslash][Eth]"], 
          ButtonBox["\[LSlash]",
            ButtonNote->"\[EscapeKey]l/\[EscapeKey], \[Backslash][LSlash]"], 
          ButtonBox["\[NTilde]",
            ButtonNote->"\[EscapeKey]n~\[EscapeKey], \[Backslash][NTilde]"], 
          ButtonBox["\[OGrave]",
            ButtonNote->"\[EscapeKey]o`\[EscapeKey], \[Backslash][OGrave]"], 
          ButtonBox["\[OAcute]",
            ButtonNote->"\[EscapeKey]o'\[EscapeKey], \[Backslash][OAcute]"]},
        {
          ButtonBox["\[OHat]",
            ButtonNote->"\[EscapeKey]o^\[EscapeKey], \[Backslash][OHat]"], 
          ButtonBox["\[OTilde]",
            ButtonNote->"\[EscapeKey]o~\[EscapeKey], \[Backslash][OTilde]"], 
          ButtonBox["\[ODoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]o\"\[EscapeKey], \[Backslash][ODoubleDot]"], 
          ButtonBox["\[ODoubleAcute]",
            
            ButtonNote->
              "\[EscapeKey]o''\[EscapeKey], \[Backslash][ODoubleAcute]"], 
          ButtonBox["\[OSlash]",
            ButtonNote->"\[EscapeKey]o/\[EscapeKey], \[Backslash][OSlash]"], 
          ButtonBox["\[SHacek]",
            ButtonNote->"\[EscapeKey]sv\[EscapeKey], \[Backslash][SHacek]"], 
          ButtonBox["\[UGrave]",
            ButtonNote->"\[EscapeKey]u`\[EscapeKey], \[Backslash][UGrave]"]},
        {
          ButtonBox["\[UAcute]",
            ButtonNote->"\[EscapeKey]u'\[EscapeKey], \[Backslash][UAcute]"], 
          ButtonBox["\[UHat]",
            ButtonNote->"\[EscapeKey]u^\[EscapeKey], \[Backslash][UHat]"], 
          ButtonBox["\[UDoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]u\"\[EscapeKey], \[Backslash][UDoubleDot]"], 
          ButtonBox["\[UDoubleAcute]",
            
            ButtonNote->
              "\[EscapeKey]u''\[EscapeKey], \[Backslash][UDoubleAcute]"], 
          ButtonBox["\[YAcute]",
            ButtonNote->"\[EscapeKey]y'\[EscapeKey], \[Backslash][YAcute]"], 
          ButtonBox["\[YDoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]y\"\[EscapeKey], \[Backslash][YDoubleDot]"], 
          ButtonBox["\[Thorn]",
            ButtonNote->"\[EscapeKey]thn\[EscapeKey], \[Backslash][Thorn]"]},
        {
          ButtonBox["\[CapitalAGrave]",
            
            ButtonNote->
              "\[EscapeKey]A`\[EscapeKey], \[Backslash][CapitalAGrave]"], 
          ButtonBox["\[CapitalAAcute]",
            
            ButtonNote->
              "\[EscapeKey]A'\[EscapeKey], \[Backslash][CapitalAAcute]"], 
          ButtonBox["\[CapitalAHat]",
            
            ButtonNote->
              "\[EscapeKey]A^\[EscapeKey], \[Backslash][CapitalAHat]"], 
          ButtonBox["\[CapitalATilde]",
            
            ButtonNote->
              "\[EscapeKey]A~\[EscapeKey], \[Backslash][CapitalATilde]"], 
          ButtonBox["\[CapitalACup]",
            
            ButtonNote->
              "\[EscapeKey]Au\[EscapeKey], \[Backslash][CapitalACup]"], 
          ButtonBox["\[CapitalADoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]A\"\[EscapeKey], \[Backslash][CapitalADoubleDot]"],
           
          ButtonBox["\[CapitalABar]",
            
            ButtonNote->
              "\[EscapeKey]A-\[EscapeKey], \[Backslash][CapitalABar]"]},
        {
          ButtonBox["\[CapitalARing]",
            
            ButtonNote->
              "\[EscapeKey]Ao\[EscapeKey], \[Backslash][CapitalARing]"], 
          ButtonBox["\[CapitalAE]",
            
            ButtonNote->
              "\[EscapeKey]AE\[EscapeKey], \[Backslash][CapitalAE]"], 
          ButtonBox["\[CapitalCAcute]",
            
            ButtonNote->
              "\[EscapeKey]C'\[EscapeKey], \[Backslash][CapitalCAcute]"], 
          ButtonBox["\[CapitalCHacek]",
            
            ButtonNote->
              "\[EscapeKey]Cv\[EscapeKey], \[Backslash][CapitalCHacek]"], 
          ButtonBox["\[CapitalCCedilla]",
            
            ButtonNote->
              "\[EscapeKey]C,\[EscapeKey], \[Backslash][CapitalCCedilla]"], 
          ButtonBox["\[CapitalEGrave]",
            
            ButtonNote->
              "\[EscapeKey]E`\[EscapeKey], \[Backslash][CapitalEGrave]"], 
          ButtonBox["\[CapitalEAcute]",
            
            ButtonNote->
              "\[EscapeKey]E'\[EscapeKey], \[Backslash][CapitalEAcute]"]},
        {
          ButtonBox["\[CapitalEHat]",
            
            ButtonNote->
              "\[EscapeKey]E^\[EscapeKey], \[Backslash][CapitalEHat]"], 
          ButtonBox["\[CapitalECup]",
            
            ButtonNote->
              "\[EscapeKey]Eu\[EscapeKey], \[Backslash][CapitalECup]"], 
          ButtonBox["\[CapitalEDoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]E\"\[EscapeKey], \[Backslash][CapitalEDoubleDot]"],
           
          ButtonBox["\[CapitalEBar]",
            
            ButtonNote->
              "\[EscapeKey]E-\[EscapeKey], \[Backslash][CapitalEBar]"], 
          ButtonBox["\[CapitalIGrave]",
            
            ButtonNote->
              "\[EscapeKey]I`\[EscapeKey], \[Backslash][CapitalIGrave]"], 
          ButtonBox["\[CapitalIAcute]",
            
            ButtonNote->
              "\[EscapeKey]I'\[EscapeKey], \[Backslash][CapitalIAcute]"], 
          ButtonBox["\[CapitalIHat]",
            
            ButtonNote->
              "\[EscapeKey]I^\[EscapeKey], \[Backslash][CapitalIHat]"]},
        {
          ButtonBox["\[CapitalICup]",
            
            ButtonNote->
              "\[EscapeKey]Iu\[EscapeKey], \[Backslash][CapitalICup]"], 
          ButtonBox["\[CapitalIDoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]I\"\[EscapeKey], \[Backslash][CapitalIDoubleDot]"],
           
          ButtonBox["\[CapitalEth]",
            
            ButtonNote->
              "\[EscapeKey]D-\[EscapeKey], \[Backslash][CapitalEth]"], 
          ButtonBox["\[CapitalLSlash]",
            
            ButtonNote->
              "\[EscapeKey]L/\[EscapeKey], \[Backslash][CapitalLSlash]"], 
          ButtonBox["\[CapitalNTilde]",
            
            ButtonNote->
              "\[EscapeKey]N~\[EscapeKey], \[Backslash][CapitalNTilde]"], 
          ButtonBox["\[CapitalOGrave]",
            
            ButtonNote->
              "\[EscapeKey]O`\[EscapeKey], \[Backslash][CapitalOGrave]"], 
          ButtonBox["\[CapitalOAcute]",
            
            ButtonNote->
              "\[EscapeKey]O'\[EscapeKey], \[Backslash][CapitalOAcute]"]},
        {
          ButtonBox["\[CapitalOHat]",
            
            ButtonNote->
              "\[EscapeKey]O^\[EscapeKey], \[Backslash][CapitalOHat]"], 
          ButtonBox["\[CapitalOTilde]",
            
            ButtonNote->
              "\[EscapeKey]O~\[EscapeKey], \[Backslash][CapitalOTilde]"], 
          ButtonBox["\[CapitalODoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]O\"\[EscapeKey], \[Backslash][CapitalODoubleDot]"],
           
          ButtonBox["\[CapitalODoubleAcute]",
            
            ButtonNote->
              "\[EscapeKey]O''\[EscapeKey], \
\[Backslash][CapitalODoubleAcute]"], 
          ButtonBox["\[CapitalOSlash]",
            
            ButtonNote->
              "\[EscapeKey]O/\[EscapeKey], \[Backslash][CapitalOSlash]"], 
          ButtonBox["\[CapitalSHacek]",
            
            ButtonNote->
              "\[EscapeKey]Sv\[EscapeKey], \[Backslash][CapitalSHacek]"], 
          ButtonBox["\[CapitalUGrave]",
            
            ButtonNote->
              "\[EscapeKey]U`\[EscapeKey], \[Backslash][CapitalUGrave]"]},
        {
          ButtonBox["\[CapitalUAcute]",
            ButtonNote->
              "\[EscapeKey]U'\[EscapeKey], \[Backslash][CapitalUAcute]"], 
          ButtonBox["\[CapitalUHat]",
            
            ButtonNote->
              "\[EscapeKey]U^\[EscapeKey], \[Backslash][CapitalUHat]"], 
          ButtonBox["\[CapitalUDoubleDot]",
            
            ButtonNote->
              "\[EscapeKey]U\"\[EscapeKey], \[Backslash][CapitalUDoubleDot]"],
           
          ButtonBox["\[CapitalUDoubleAcute]",
            
            ButtonNote->
              "\[EscapeKey]U''\[EscapeKey], \
\[Backslash][CapitalUDoubleAcute]"], 
          ButtonBox["\[CapitalYAcute]",
            
            ButtonNote->
              "\[EscapeKey]Y'\[EscapeKey], \[Backslash][CapitalYAcute]"], 
          ButtonBox["\[CapitalThorn]",
            
            ButtonNote->
              "\[EscapeKey]Thn\[EscapeKey], \[Backslash][CapitalThorn]"], 
          ButtonBox["\[SZ]",
            ButtonNote->"\[EscapeKey]sz\[EscapeKey], \[Backslash][SZ]"]}
        },
      RowSpacings->{0, 0, 0, 0, 0, 1, 0},
      ColumnSpacings->0,
      ColumnsEqual->True,
      GridDefaultElement:>ButtonBox[ "\\:f528"]]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}},
  GeneratedCell->True,
  CellAutoOverwrite->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Letter\[Dash]like Forms", "Text",
  CellMargins->{{12, Inherited}, {Inherited, 4}},
  CellGroupingRules->{"SectionGrouping", 10},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Technical Symbols", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[ConstantC]",
            
            ButtonNote->
              "\[EscapeKey]cc\[EscapeKey], \[Backslash][ConstantC]"], 
          ButtonBox["\[ExponentialE]",
            
            ButtonNote->
              "\[EscapeKey]ee\[EscapeKey], \[Backslash][ExponentialE]"], 
          ButtonBox["\[ImaginaryI]",
            
            ButtonNote->
              "\[EscapeKey]ii\[EscapeKey], \[Backslash][ImaginaryI]"], 
          ButtonBox["\[ImaginaryJ]",
            
            ButtonNote->
              "\[EscapeKey]jj\[EscapeKey], \[Backslash][ImaginaryJ]"], 
          ButtonBox["\[DoubledPi]",
            
            ButtonNote->
              "\[EscapeKey]pp\[EscapeKey], \[Backslash][DoubledPi]"], 
          ButtonBox["\[DoubledGamma]",
            
            ButtonNote->
              "\[EscapeKey]gg\[EscapeKey], \[Backslash][DoubledGamma]"]},
        {
          ButtonBox["\[Infinity]",
            
            ButtonNote->
              "\[EscapeKey]inf\[EscapeKey], \[Backslash][Infinity]"], 
          ButtonBox["\[Micro]",
            ButtonNote->"\[EscapeKey]mi\[EscapeKey], \[Backslash][Micro]"], 
          ButtonBox["\[Mho]",
            ButtonNote->"\[EscapeKey]mho\[EscapeKey], \[Backslash][Mho]"], 
          ButtonBox["\[Angstrom]",
            
            ButtonNote->
              "\[EscapeKey]Ang\[EscapeKey], \[Backslash][Angstrom]"], 
          ButtonBox["\[HBar]",
            ButtonNote->"\[EscapeKey]hb\[EscapeKey], \[Backslash][HBar]"], 
          ButtonBox["\[Diameter]",
            ButtonNote->"\[Backslash][Diameter]"]},
        {
          ButtonBox["\[Aleph]",
            ButtonNote->"\[EscapeKey]al\[EscapeKey], \[Backslash][Aleph]"], 
          ButtonBox["\[Bet]",
            ButtonNote->"\[EscapeKey]be\[EscapeKey], \[Backslash][Bet]"], 
          ButtonBox["\[Gimel]",
            ButtonNote->"\[EscapeKey]gi\[EscapeKey], \[Backslash][Gimel]"], 
          ButtonBox["\[Dalet]",
            ButtonNote->"\[EscapeKey]da\[EscapeKey], \[Backslash][Dalet]"], 
          ButtonBox["\[WeierstrassP]",
            
            ButtonNote->
              "\[EscapeKey]wp\[EscapeKey], \[Backslash][WeierstrassP]"], 
          ButtonBox["\[EmptySet]",
            
            ButtonNote->
              "\[EscapeKey]es\[EscapeKey], \[Backslash][EmptySet]"]},
        {
          ButtonBox["\[Degree]",
            ButtonNote->"\[EscapeKey]deg\[EscapeKey], \[Backslash][Degree]"], 
          
          ButtonBox["\[Angle]",
            ButtonNote->"\[Backslash][Angle]"], 
          ButtonBox["\[RightAngle]",
            ButtonNote->"\[Backslash][RightAngle]"], 
          ButtonBox["\[MeasuredAngle]",
            ButtonNote->"\[Backslash][MeasuredAngle]"], 
          ButtonBox["\[SphericalAngle]",
            ButtonNote->"\[Backslash][SphericalAngle]"], 
          ButtonBox["\[EmptyUpTriangle]",
            ButtonNote->"\[Backslash][EmptyUpTriangle]"]},
        {
          ButtonBox["\[Mercury]",
            ButtonNote->"\[Backslash][Mercury]"], 
          ButtonBox["\[Venus]",
            ButtonNote->"\[Backslash][Venus]"], 
          ButtonBox["\[Earth]",
            ButtonNote->"\[Backslash][Earth]"], 
          ButtonBox["\[Mars]",
            ButtonNote->"\[Backslash][Mars]"], 
          ButtonBox["\[Jupiter]",
            ButtonNote->"\[Backslash][Jupiter]"], 
          ButtonBox["\[Saturn]",
            ButtonNote->"\[Backslash][Saturn]"]},
        {
          ButtonBox["\[Uranus]",
            ButtonNote->"\[Backslash][Uranus]"], 
          ButtonBox["\[Neptune]",
            ButtonNote->"\[Backslash][Neptune]"], 
          ButtonBox["\[Pluto]",
            ButtonNote->"\[Backslash][Pluto]"], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[ThinSpace]",
            ButtonFunction:>Null,
            Active->False]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->False,
      ColumnsEqual->False,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Shapes and Icons", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[FilledSquare]",
            
            ButtonNote->
              "\[EscapeKey]fsq\[EscapeKey], \[Backslash][FilledSquare]"], 
          ButtonBox["\[FilledSmallCircle]",
            
            ButtonNote->
              "\[EscapeKey]fsci\[EscapeKey], \
\[Backslash][FilledSmallCircle]"], 
          ButtonBox["\[FilledCircle]",
            
            ButtonNote->
              "\[EscapeKey]fci\[EscapeKey], \[Backslash][FilledCircle]"], 
          ButtonBox["\[FilledRectangle]",
            ButtonNote->"\[Backslash][FilledRectangle]"], 
          ButtonBox["\[FilledUpTriangle]",
            ButtonNote->"\[Backslash][FilledUpTriangle]"], 
          ButtonBox["\[FilledDownTriangle]",
            ButtonNote->"\[Backslash][FilledDownTriangle]"]},
        {
          ButtonBox["\[EmptySquare]",
            
            ButtonNote->
              "\[EscapeKey]esq\[EscapeKey], \[Backslash][EmptySquare]"], 
          ButtonBox["\[EmptySmallCircle]",
            
            ButtonNote->
              "\[EscapeKey]esci\[EscapeKey], \[Backslash][EmptySmallCircle]"],
           
          ButtonBox["\[EmptyCircle]",
            
            ButtonNote->
              "\[EscapeKey]eci\[EscapeKey], \[Backslash][EmptyCircle]"], 
          ButtonBox["\[EmptyRectangle]",
            ButtonNote->"\[Backslash][EmptyRectangle]"], 
          ButtonBox["\[EmptyUpTriangle]",
            ButtonNote->"\[Backslash][EmptyUpTriangle]"], 
          ButtonBox["\[EmptyDownTriangle]",
            ButtonNote->"\[Backslash][EmptyDownTriangle]"]},
        {
          ButtonBox["\[FilledVerySmallSquare]",
            
            ButtonNote->
              "\[EscapeKey]fvssq\[EscapeKey], \
\[Backslash][FilledVerySmallSquare]"], 
          ButtonBox["\[FilledSmallSquare]",
            
            ButtonNote->
              "\[EscapeKey]fssq\[EscapeKey], \
\[Backslash][FilledSmallSquare]"], 
          ButtonBox["\[FilledDiamond]",
            ButtonNote->"\[Backslash][FilledDiamond]"], 
          ButtonBox["\[GraySquare]",
            ButtonNote->
              "\[EscapeKey]gsq\[EscapeKey], \[Backslash][GraySquare]"], 
          ButtonBox["\[GrayCircle]",
            
            ButtonNote->
              "\[EscapeKey]gci\[EscapeKey], \[Backslash][GrayCircle]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[EmptyVerySmallSquare]",
            
            ButtonNote->
              "\[EscapeKey]evssq\[EscapeKey], \
\[Backslash][EmptyVerySmallSquare]"], 
          ButtonBox["\[EmptySmallSquare]",
            
            ButtonNote->
              "\[EscapeKey]essq\[EscapeKey], \[Backslash][EmptySmallSquare]"],
           
          ButtonBox["\[EmptyDiamond]",
            ButtonNote->"\[Backslash][EmptyDiamond]"], 
          ButtonBox["\[DottedSquare]",
            ButtonNote->"\[Backslash][DottedSquare]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              FontSize->18],
            ButtonData:>"\[FirstPage]",
            ButtonNote->"\[Backslash][FirstPage]"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              FontSize->18],
            ButtonData:>"\[LeftPointer]",
            ButtonNote->"\[Backslash][LeftPointer]"], 
          ButtonBox[
            StyleBox["\[UpPointer]",
              FontSize->18],
            ButtonData:>"\[UpPointer]",
            ButtonNote->"\[Backslash][UpPointer]"], 
          ButtonBox[
            StyleBox["\[DownPointer]",
              FontSize->18],
            ButtonData:>"\[DownPointer]",
            ButtonNote->"\[Backslash][DownPointer]"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              FontSize->18],
            ButtonData:>"\[RightPointer]",
            ButtonNote->"\[Backslash][RightPointer]"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              FontSize->18],
            ButtonData:>"\[LastPage]",
            ButtonNote->"\[Backslash][LastPage]"]},
        {
          ButtonBox["\[FivePointedStar]",
            
            ButtonNote->
              "\[EscapeKey]*5\[EscapeKey], \[Backslash][FivePointedStar]"], 
          ButtonBox["\[SixPointedStar]",
            
            ButtonNote->
              "\[EscapeKey]*6\[EscapeKey], \[Backslash][SixPointedStar]"], 
          ButtonBox["\[DiamondSuit]",
            ButtonNote->"\[Backslash][DiamondSuit]"], 
          ButtonBox["\[ClubSuit]",
            ButtonNote->"\[Backslash][ClubSuit]"], 
          ButtonBox["\[HeartSuit]",
            ButtonNote->"\[Backslash][HeartSuit]"], 
          ButtonBox["\[SpadeSuit]",
            ButtonData:>"\[SpadeSuit]",
            ButtonNote->"\[Backslash][SpadeSuit]"]},
        {
          ButtonBox["\[MathematicaIcon]",
            
            ButtonNote->
              "\[EscapeKey]math\[EscapeKey], \[Backslash][MathematicaIcon]"], 
          
          ButtonBox["\[KernelIcon]",
            ButtonNote->"\[Backslash][KernelIcon]"], 
          ButtonBox["\[Checkmark]",
            ButtonNote->"\[Backslash][Checkmark]"], 
          ButtonBox["\[CheckmarkedBox]",
            ButtonNote->"\[Backslash][CheckmarkedBox]"], 
          ButtonBox["\[WatchIcon]",
            ButtonNote->"\[Backslash][WatchIcon]"], 
          ButtonBox["\[WarningSign]",
            ButtonNote->"\[Backslash][WarningSign]"]},
        {
          ButtonBox["\[HappySmiley]",
            
            ButtonNote->
              "\[EscapeKey]:-)\[EscapeKey], \[Backslash][HappySmiley]"], 
          ButtonBox["\[NeutralSmiley]",
            
            ButtonNote->
              "\[EscapeKey]:-|\[EscapeKey], \[Backslash][NeutralSmiley]"], 
          ButtonBox["\[SadSmiley]",
            
            ButtonNote->
              "\[EscapeKey]:-(\[EscapeKey], \[Backslash][SadSmiley]"], 
          ButtonBox["\[FreakedSmiley]",
            
            ButtonNote->
              "\[EscapeKey]:-@\[EscapeKey], \[Backslash][FreakedSmiley]"], 
          ButtonBox["\[LightBulb]",
            ButtonNote->"\[Backslash][LightBulb]"], 
          ButtonBox["\[Wolf]",
            ButtonNote->"\[EscapeKey]wolf\[EscapeKey], \[Backslash][Wolf]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Textual Forms", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[DotlessI]",
            ButtonNote->"\[Backslash][DotlessI]"], 
          ButtonBox["\[DotlessJ]",
            ButtonNote->"\[Backslash][DotlessJ]"], 
          ButtonBox["\[ScriptDotlessI]",
            ButtonNote->"\[Backslash][ScriptDotlessI]"], 
          ButtonBox["\[ScriptDotlessJ]",
            ButtonNote->"\[Backslash][ScriptDotlessJ]"], 
          ButtonBox["\[Dash]",
            ButtonNote->"\[EscapeKey]-\[EscapeKey], \[Backslash][Dash]"], 
          ButtonBox["\[LongDash]",
            ButtonNote->"\[EscapeKey]--\[EscapeKey], \[Backslash][LongDash]"],
           
          ButtonBox["\[Hyphen]",
            ButtonNote->"\[Backslash][Hyphen]"]},
        {
          ButtonBox["\[BeamedSixteenthNote]",
            ButtonNote->"\[Backslash][BeamedSixteenthNote]"], 
          ButtonBox["\[EighthNote]",
            ButtonNote->"\[Backslash][EighthNote]"], 
          ButtonBox["\[BeamedEighthNote]",
            ButtonNote->"\[Backslash][BeamedEighthNote]"], 
          ButtonBox["\[QuarterNote]",
            ButtonNote->"\[Backslash][QuarterNote]"], 
          ButtonBox["\[Flat]",
            ButtonNote->"\[Backslash][Flat]"], 
          ButtonBox["\[Natural]",
            ButtonNote->"\[Backslash][Natural]"], 
          ButtonBox["\[Sharp]",
            ButtonNote->"\[Backslash][Sharp]"]},
        {
          ButtonBox["\[Cent]",
            ButtonNote->"\[EscapeKey]cent\[EscapeKey], \[Backslash][Cent]"], 
          ButtonBox["\[Euro]",
            ButtonNote->"\[Backslash][Euro]"], 
          ButtonBox["\[Sterling]",
            ButtonNote->"\[Backslash][Sterling]"], 
          ButtonBox["\[Yen]",
            ButtonNote->"\[Backslash][Yen]"], 
          ButtonBox["\[Currency]",
            ButtonNote->"\[Backslash][Currency]"], 
          ButtonBox["\[DownQuestion]",
            
            ButtonNote->
              "\[EscapeKey]d?\[EscapeKey], \[Backslash][DownQuestion]"], 
          ButtonBox["\[DownExclamation]",
            
            ButtonNote->
              "\[EscapeKey]d!\[EscapeKey], \[Backslash][DownExclamation]"]},
        {
          ButtonBox["\[Copyright]",
            ButtonNote->"\[Backslash][Copyright]"], 
          ButtonBox["\[RegisteredTrademark]",
            ButtonNote->"\[Backslash][RegisteredTrademark]"], 
          ButtonBox["\[Trademark]",
            ButtonNote->"\[Backslash][Trademark]"], 
          ButtonBox["\[NumberSign]",
            
            ButtonNote->
              "\[EscapeKey]#\[EscapeKey], \[Backslash][NumberSign]"], 
          ButtonBox["\[Florin]",
            ButtonNote->"\[Backslash][Florin]"], 
          ButtonBox["\[LeftGuillemet]",
            
            ButtonNote->
              "\[EscapeKey]g<<\[EscapeKey], \[Backslash][LeftGuillemet]"], 
          ButtonBox["\[RightGuillemet]",
            
            ButtonNote->
              "\[EscapeKey]g>>\[EscapeKey], \[Backslash][RightGuillemet]"]},
        {
          ButtonBox["\[Paragraph]",
            ButtonNote->"\[Backslash][Paragraph]"], 
          ButtonBox["\[Section]",
            ButtonNote->"\[Backslash][Section]"], 
          ButtonBox["\[Bullet]",
            ButtonNote->"\[EscapeKey]bu\[EscapeKey], \[Backslash][Bullet]"], 
          ButtonBox["\[Dagger]",
            ButtonNote->"\[EscapeKey]dg\[EscapeKey], \[Backslash][Dagger]"], 
          ButtonBox["\[DoubleDagger]",
            
            ButtonNote->
              "\[EscapeKey]ddg\[EscapeKey], \[Backslash][DoubleDagger]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[Prime]",
            ButtonNote->"\[EscapeKey]'\[EscapeKey], \[Backslash][Prime]"], 
          ButtonBox["\[DoublePrime]",
            
            ButtonNote->
              "\[EscapeKey]''\[EscapeKey], \[Backslash][DoublePrime]"], 
          ButtonBox["\[ReversePrime]",
            
            ButtonNote->
              "\[EscapeKey]`\[EscapeKey], \[Backslash][ReversePrime]"], 
          ButtonBox["\[ReverseDoublePrime]",
            
            ButtonNote->
              "\[EscapeKey]``\[EscapeKey], \[Backslash][ReverseDoublePrime]"],
           
          ButtonBox["\[DoubleDot]",
            ButtonNote->"\[Backslash][DoubleDot]"], 
          ButtonBox["\[TripleDot]",
            ButtonNote->"\[Backslash][TripleDot]"], 
          ButtonBox["\[Hacek]",
            ButtonNote->"\[EscapeKey]hc\[EscapeKey], \[Backslash][Hacek]"]},
        {
          ButtonBox["\[Breve]",
            ButtonNote->"\[EscapeKey]bv\[EscapeKey], \[Backslash][Breve]"], 
          ButtonBox["\[DownBreve]",
            
            ButtonNote->
              "\[EscapeKey]dbv\[EscapeKey], \[Backslash][DownBreve]"], 
          ButtonBox["\[Cedilla]",
            ButtonNote->"\[EscapeKey]cd\[EscapeKey], \[Backslash][Cedilla]"], 
          
          ButtonBox["\[OpenCurlyQuote]",
            ButtonNote->"\[Backslash][OpenCurlyQuote]"], 
          ButtonBox["\[CloseCurlyQuote]",
            ButtonNote->"\[Backslash][CloseCurlyQuote]"], 
          ButtonBox["\[OpenCurlyDoubleQuote]",
            ButtonNote->"\[Backslash][OpenCurlyDoubleQuote]"], 
          ButtonBox["\[CloseCurlyDoubleQuote]",
            ButtonNote->"\[Backslash][CloseCurlyDoubleQuote]"]},
        {
          ButtonBox["\[Ellipsis]",
            
            ButtonNote->
              "\[EscapeKey]...\[EscapeKey], \[Backslash][Ellipsis]"], 
          ButtonBox["\[CenterEllipsis]",
            ButtonNote->"\[Backslash][CenterEllipsis]"], 
          ButtonBox["\[VerticalEllipsis]",
            ButtonNote->"\[Backslash][VerticalEllipsis]"], 
          ButtonBox["\[AscendingEllipsis]",
            ButtonNote->"\[Backslash][AscendingEllipsis]"], 
          ButtonBox["\[DescendingEllipsis]",
            ButtonNote->"\[Backslash][DescendingEllipsis]"], 
          ButtonBox[\(\[HorizontalLine]\&\ \ \),
            ButtonData:>"\[HorizontalLine]",
            
            ButtonNote->
              "\[EscapeKey]hline\[EscapeKey], \[Backslash][HorizontalLine]"], 
          
          ButtonBox[\(\(\[VerticalLine]\)\(\[ThinSpace]\)\),
            ButtonData:>"\[VerticalLine]",
            
            ButtonNote->
              "\[EscapeKey]vline\[EscapeKey], \[Backslash][VerticalLine]"]},
        {
          ButtonBox["\[UnderParenthesis]",
            
            ButtonNote->
              "\[EscapeKey]u(\[EscapeKey], \[Backslash][UnderParenthesis]"], 
          ButtonBox["\[OverParenthesis]",
            
            ButtonNote->
              "\[EscapeKey]o(\[EscapeKey], \[Backslash][OverParenthesis]"], 
          ButtonBox["\[UnderBracket]",
            
            ButtonNote->
              "\[EscapeKey]u[\[EscapeKey], \[Backslash][UnderBracket]"], 
          ButtonBox["\[OverBracket]",
            
            ButtonNote->
              "\[EscapeKey]o[\[EscapeKey], \[Backslash][OverBracket]"], 
          ButtonBox["\[UnderBrace]",
            
            ButtonNote->
              "\[EscapeKey]u{\[EscapeKey], \[Backslash][UnderBrace]"], 
          ButtonBox["\[OverBrace]",
            
            ButtonNote->
              "\[EscapeKey]o{\[EscapeKey], \[Backslash][OverBrace]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Keyboard Forms", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[SpaceIndicator]",
            
            ButtonNote->
              "\[EscapeKey]space\[EscapeKey], \[Backslash][SpaceIndicator]"], 
          
          ButtonBox["\[RoundSpaceIndicator]",
            ButtonNote->"\[Backslash][RoundSpaceIndicator]"], 
          ButtonBox["\[CloverLeaf]",
            
            ButtonNote->
              "\[EscapeKey]cl\[EscapeKey], \[Backslash][CloverLeaf]"], 
          ButtonBox["\[ReturnIndicator]",
            
            ButtonNote->
              "\[EscapeKey]ret\[EscapeKey], \[Backslash][ReturnIndicator]"]},
        {
          ButtonBox["\[AltKey]",
            ButtonNote->"\[EscapeKey]alt\[EscapeKey], \[Backslash][AltKey]"], 
          
          ButtonBox["\[CommandKey]",
            
            ButtonNote->
              "\[EscapeKey]cmd\[EscapeKey], \[Backslash][CommandKey]"], 
          ButtonBox["\[ControlKey]",
            
            ButtonNote->
              "\[EscapeKey]ctrl\[EscapeKey], \[Backslash][ControlKey]"], 
          ButtonBox["\[DeleteKey]",
            
            ButtonNote->
              "\[EscapeKey] del\[EscapeKey], \[Backslash][DeleteKey]"]},
        {
          ButtonBox["\[EnterKey]",
            
            ButtonNote->
              "\[EscapeKey]ent\[EscapeKey], \[Backslash][EnterKey]"], 
          ButtonBox["\[EscapeKey]",
            
            ButtonNote->
              "\[EscapeKey] esc\[EscapeKey], \[Backslash][EscapeKey]"], 
          ButtonBox["\[Mod1Key]",
            ButtonNote->"\[EscapeKey]m1\[EscapeKey], \[Backslash][Mod1Key]"], 
          
          ButtonBox["\[Mod2Key]",
            
            ButtonNote->
              "\[EscapeKey]m2\[EscapeKey], \[Backslash][Mod2Key]"]},
        {
          ButtonBox["\[OptionKey]",
            
            ButtonNote->
              "\[EscapeKey]opt\[EscapeKey], \[Backslash][OptionKey]"], 
          ButtonBox["\[ShiftKey]",
            ButtonNote->"\[EscapeKey]sh\[EscapeKey], \[Backslash][ShiftKey]"],
           
          ButtonBox["\[SpaceKey]",
            
            ButtonNote->
              "\[EscapeKey]spc\[EscapeKey], \[Backslash][SpaceKey]"], 
          ButtonBox["\[ReturnKey]",
            
            ButtonNote->
              "\[EscapeKey] ret\[EscapeKey], \[Backslash][ReturnKey]"]},
        {
          ButtonBox["\[TabKey]",
            ButtonNote->"\[EscapeKey]tab\[EscapeKey], \[Backslash][TabKey]"], 
          
          ButtonBox["\[KeyBar]",
            ButtonNote->"\[EscapeKey]kb\[EscapeKey], \[Backslash][KeyBar]"], 
          ButtonBox["\[LeftModified]",
            
            ButtonNote->
              "\[EscapeKey][\[EscapeKey], \[Backslash][LeftModified]"], 
          ButtonBox["\[RightModified]",
            
            ButtonNote->
              "\[EscapeKey]]\[EscapeKey], \[Backslash][RightModified]"]},
        {
          ButtonBox["\[EntityStart]",
            ButtonNote->"\[Backslash][EntityStart]"], 
          ButtonBox["\[EntityEnd]",
            ButtonNote->"\[Backslash][EntityEnd]"], 
          ButtonBox["\[SelectionPlaceholder]",
            ButtonFunction:>NotebookWrite[ 
                InputNotebook[ ], "\[SelectionPlaceholder]"],
            
            ButtonNote->
              "\[EscapeKey]spl\[EscapeKey], \
\[Backslash][SelectionPlaceholder]"], 
          ButtonBox["\[Placeholder]",
            ButtonFunction:>NotebookWrite[ 
                InputNotebook[ ], "\[Placeholder]"],
            
            ButtonNote->
              "\[EscapeKey]pl\[EscapeKey], \[Backslash][Placeholder]"]},
        {
          ButtonBox["\[LeftSkeleton]",
            ButtonNote->"\[Backslash][LeftSkeleton]"], 
          ButtonBox["\[RightSkeleton]",
            ButtonNote->"\[Backslash][RightSkeleton]"], 
          ButtonBox["\[SkeletonIndicator]",
            ButtonNote->"\[Backslash][SkeletonIndicator]"], 
          ButtonBox["\[Continuation]",
            
            ButtonNote->
              "\[EscapeKey]cont\[EscapeKey], \[Backslash][Continuation]"]},
        {
          ButtonBox["\[ErrorIndicator]",
            ButtonNote->"\[Backslash][ErrorIndicator]"], 
          ButtonBox["\[AliasIndicator]",
            ButtonNote->
              "\[EscapeKey]esc\[EscapeKey], \[Backslash][AliasIndicator]"], 
          ButtonBox["\[UnknownGlyph]",
            ButtonNote->"\[Backslash][UnknownGlyph]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowsEqual->True,
      ColumnsEqual->False,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Operators", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 10},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["General", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[Times]",
            ButtonNote->"\[EscapeKey]*\[EscapeKey], \[Backslash][Times]"], 
          ButtonBox["\[Divide]",
            ButtonNote->"\[EscapeKey]div\[EscapeKey], \[Backslash][Divide]"], 
          
          ButtonBox["\[Sqrt]",
            ButtonNote->"\[EscapeKey]sqrt\[EscapeKey], \[Backslash][Sqrt]"], 
          ButtonBox["\[Cross]",
            ButtonNote->"\[EscapeKey]cross\[EscapeKey], \[Backslash][Cross]"],
           
          ButtonBox["\[PlusMinus]",
            
            ButtonNote->
              "\[EscapeKey]+-\[EscapeKey], \[Backslash][PlusMinus]"], 
          ButtonBox["\[MinusPlus]",
            
            ButtonNote->
              "\[EscapeKey]-+\[EscapeKey], \[Backslash][MinusPlus]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[Sum]",
            ButtonNote->"\[EscapeKey]sum\[EscapeKey], \[Backslash][Sum]"], 
          ButtonBox["\[Product]",
            
            ButtonNote->
              "\[EscapeKey]prod\[EscapeKey], \[Backslash][Product]"], 
          ButtonBox["\[Del]",
            ButtonNote->"\[EscapeKey]del\[EscapeKey], \[Backslash][Del]"], 
          ButtonBox["\[DifferentialD]",
            
            ButtonNote->
              "\[EscapeKey]dd\[EscapeKey], \[Backslash][DifferentialD]"], 
          ButtonBox["\[PartialD]",
            ButtonNote->"\[EscapeKey]pd\[EscapeKey], \[Backslash][PartialD]"],
           
          ButtonBox["\[CapitalDifferentialD]",
            
            ButtonNote->
              "\[EscapeKey]DD\[EscapeKey], \
\[Backslash][CapitalDifferentialD]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[Integral]",
            
            ButtonNote->
              "\[EscapeKey]int\[EscapeKey], \[Backslash][Integral]"], 
          ButtonBox["\[ContourIntegral]",
            
            ButtonNote->
              "\[EscapeKey]cint\[EscapeKey], \[Backslash][ContourIntegral]"], 
          
          ButtonBox["\[ClockwiseContourIntegral]",
            
            ButtonNote->
              "\[EscapeKey]ccint\[EscapeKey], \
\[Backslash][ClockwiseContourIntegral]"], 
          ButtonBox["\[CounterClockwiseContourIntegral]",
            
            ButtonNote->
              "\[EscapeKey]cccint\[EscapeKey], \
\[Backslash][CounterClockwiseContourIntegral]"], 
          ButtonBox["\[DoubleContourIntegral]",
            ButtonNote->"\[Backslash][DoubleContourIntegral]"], 
          ButtonBox["\[Rule]",
            ButtonNote->"\[EscapeKey]->\[EscapeKey], \[Backslash][Rule]"], 
          ButtonBox["\[RuleDelayed]",
            
            ButtonNote->
              "\[EscapeKey]:>\[EscapeKey], \[Backslash][RuleDelayed]"]},
        {
          ButtonBox["\[Not]",
            ButtonNote->"\[EscapeKey]not\[EscapeKey], \[Backslash][Not]"], 
          ButtonBox["\[And]",
            ButtonNote->"\[EscapeKey]and\[EscapeKey], \[Backslash][And]"], 
          ButtonBox["\[Nand]",
            ButtonNote->"\[EscapeKey]nand\[EscapeKey], \[Backslash][Nand]"], 
          ButtonBox["\[Or]",
            ButtonNote->"\[EscapeKey]or\[EscapeKey], \[Backslash][Or]"], 
          ButtonBox["\[Nor]",
            ButtonNote->"\[EscapeKey]nor\[EscapeKey], \[Backslash][Nor]"], 
          ButtonBox["\[Xor]",
            ButtonNote->"\[EscapeKey]xor\[EscapeKey], \[Backslash][Xor]"], 
          ButtonBox["\[Implies]",
            
            ButtonNote->
              "\[EscapeKey]=>\[EscapeKey], \[Backslash][Implies]"]},
        {
          ButtonBox["\[ForAll]",
            ButtonNote->"\[EscapeKey]fa\[EscapeKey], \[Backslash][ForAll]"], 
          ButtonBox["\[Exists]",
            ButtonNote->"\[EscapeKey]ex\[EscapeKey], \[Backslash][Exists]"], 
          ButtonBox["\[NotExists]",
            
            ButtonNote->
              "\[EscapeKey]!ex\[EscapeKey], \[Backslash][NotExists]"], 
          ButtonBox["\[SuchThat]",
            ButtonNote->"\[EscapeKey]st\[EscapeKey], \[Backslash][SuchThat]"],
           
          ButtonBox["\[Therefore]",
            
            ButtonNote->
              "\[EscapeKey]tf\[EscapeKey], \[Backslash][Therefore]"], 
          ButtonBox["\[Because]",
            ButtonNote->"\[Backslash][Because]"], 
          ButtonBox["\[RoundImplies]",
            ButtonNote->"\[Backslash][RoundImplies]"]},
        {
          ButtonBox["\[SmallCircle]",
            
            ButtonNote->
              "\[EscapeKey]sc\[EscapeKey], \[Backslash][SmallCircle]"], 
          ButtonBox["\[CirclePlus]",
            
            ButtonNote->
              "\[EscapeKey]c+\[EscapeKey], \[Backslash][CirclePlus]"], 
          ButtonBox["\[CircleMinus]",
            
            ButtonNote->
              "\[EscapeKey]c-\[EscapeKey], \[Backslash][CircleMinus]"], 
          ButtonBox["\[CircleDot]",
            
            ButtonNote->
              "\[EscapeKey]c.\[EscapeKey], \[Backslash][CircleDot]"], 
          ButtonBox["\[CircleTimes]",
            
            ButtonNote->
              "\[EscapeKey]c*\[EscapeKey], \[Backslash][CircleTimes]"], 
          ButtonBox["\[Diamond]",
            ButtonNote->"\[EscapeKey]dia\[EscapeKey], \[Backslash][Diamond]"],
           
          ButtonBox["\[CenterDot]",
            
            ButtonNote->
              "\[EscapeKey].\[EscapeKey], \[Backslash][CenterDot]"]},
        {
          ButtonBox["\[Star]",
            ButtonNote->"\[EscapeKey]star\[EscapeKey], \[Backslash][Star]"], 
          ButtonBox["\[VerticalTilde]",
            ButtonNote->"\[Backslash][VerticalTilde]"], 
          ButtonBox["\[Backslash]",
            
            ButtonNote->
              "\[EscapeKey]\\\[EscapeKey], \[Backslash][Backslash]"], 
          ButtonBox["\[Wedge]",
            ButtonNote->"\[EscapeKey]^\[EscapeKey], \[Backslash][Wedge]"], 
          ButtonBox["\[Vee]",
            ButtonNote->"\[EscapeKey]v\[EscapeKey], \[Backslash][Vee]"], 
          ButtonBox["\[Cap]",
            ButtonNote->"\[Backslash][Cap]"], 
          ButtonBox["\[Cup]",
            ButtonNote->"\[Backslash][Cup]"]},
        {
          ButtonBox["\[Union]",
            ButtonNote->"\[EscapeKey]un\[EscapeKey], \[Backslash][Union]"], 
          ButtonBox["\[UnionPlus]",
            ButtonNote->"\[Backslash][UnionPlus]"], 
          ButtonBox["\[Intersection]",
            
            ButtonNote->
              "\[EscapeKey]inter\[EscapeKey], \[Backslash][Intersection]"], 
          ButtonBox["\[SquareIntersection]",
            ButtonNote->"\[Backslash][SquareIntersection]"], 
          ButtonBox["\[SquareUnion]",
            ButtonNote->"\[Backslash][SquareUnion]"], 
          ButtonBox["\[Coproduct]",
            
            ButtonNote->
              "\[EscapeKey]coprod\[EscapeKey], \[Backslash][Coproduct]"], 
          ButtonBox["\[Square]",
            ButtonNote->"\[EscapeKey]sq\[EscapeKey], \[Backslash][Square]"]},
        {
          ButtonBox["\[LeftFloor]",
            
            ButtonNote->
              "\[EscapeKey]lf\[EscapeKey], \[Backslash][LeftFloor]"], 
          ButtonBox["\[RightFloor]",
            
            ButtonNote->
              "\[EscapeKey]rf\[EscapeKey], \[Backslash][RightFloor]"], 
          ButtonBox["\[LeftCeiling]",
            
            ButtonNote->
              "\[EscapeKey]lc\[EscapeKey], \[Backslash][LeftCeiling]"], 
          ButtonBox["\[RightCeiling]",
            
            ButtonNote->
              "\[EscapeKey]rc\[EscapeKey], \[Backslash][RightCeiling]"], 
          ButtonBox["\[LeftDoubleBracket]",
            
            ButtonNote->
              "\[EscapeKey][[\[EscapeKey], \[Backslash][LeftDoubleBracket]"], 
          
          ButtonBox["\[RightDoubleBracket]",
            
            ButtonNote->
              "\[EscapeKey]]]\[EscapeKey], \[Backslash][RightDoubleBracket]"],
           
          ButtonBox["\[VerticalSeparator]",
            
            ButtonNote->
              "\[EscapeKey]|\[EscapeKey], \[Backslash][VerticalSeparator]"]},
        {
          ButtonBox["\[LeftAngleBracket]",
            
            ButtonNote->
              "\[EscapeKey]<\[EscapeKey], \[Backslash][LeftAngleBracket]"], 
          ButtonBox["\[RightAngleBracket]",
            ButtonNote->
              "\[EscapeKey]>\[EscapeKey], \[Backslash][RightAngleBracket]"], 
          ButtonBox["\[LeftBracketingBar]",
            
            ButtonNote->
              "\[EscapeKey]l|\[EscapeKey], \[Backslash][LeftBracketingBar]"], 
          
          ButtonBox["\[RightBracketingBar]",
            
            ButtonNote->
              "\[EscapeKey]r|\[EscapeKey], \[Backslash][RightBracketingBar]"],
           
          ButtonBox["\[LeftDoubleBracketingBar]",
            
            ButtonNote->
              "\[EscapeKey]l||\[EscapeKey], \
\[Backslash][LeftDoubleBracketingBar]"], 
          ButtonBox["\[RightDoubleBracketingBar]",
            
            ButtonNote->
              "\[EscapeKey]r||\[EscapeKey], \
\[Backslash][RightDoubleBracketingBar]"], 
          ButtonBox["\[Colon]",
            ButtonNote->"\[EscapeKey]:\[EscapeKey], \[Backslash][Colon]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->{False, False, True, False, True, False, False, True, False},
      ColumnsEqual->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Relational", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[NotEqual]",
            ButtonNote->"\[EscapeKey]!=\[EscapeKey], \[Backslash][NotEqual]"],
           
          ButtonBox["\[Equal]",
            ButtonNote->"\[EscapeKey]==\[EscapeKey], \[Backslash][Equal]"], 
          ButtonBox["\[Congruent]",
            
            ButtonNote->
              "\[EscapeKey]===\[EscapeKey], \[Backslash][Congruent]"], 
          ButtonBox["\[NotCongruent]",
            
            ButtonNote->
              "\[EscapeKey]!===\[EscapeKey], \[Backslash][NotCongruent]"], 
          ButtonBox["\[DotEqual]",
            ButtonNote->"\[EscapeKey].=\[EscapeKey], \[Backslash][DotEqual]"],
           
          ButtonBox["\[LongEqual]",
            
            ButtonNote->
              "\[EscapeKey]l==\[EscapeKey], \[Backslash][LongEqual]"], 
          ButtonBox["\[Proportional]",
            
            ButtonNote->
              "\[EscapeKey]prop\[EscapeKey], \[Backslash][Proportional]"], 
          ButtonBox["\[Proportion]",
            ButtonNote->"\[Backslash][Proportion]"]},
        {
          ButtonBox["\[NotTildeEqual]",
            
            ButtonNote->
              "\[EscapeKey]!~=\[EscapeKey], \[Backslash][NotTildeEqual]"], 
          ButtonBox["\[TildeEqual]",
            
            ButtonNote->
              "\[EscapeKey]~=\[EscapeKey], \[Backslash][TildeEqual]"], 
          ButtonBox["\[TildeFullEqual]",
            
            ButtonNote->
              "\[EscapeKey]~==\[EscapeKey], \[Backslash][TildeFullEqual]"], 
          ButtonBox["\[NotTildeFullEqual]",
            
            ButtonNote->
              "\[EscapeKey]!~==\[EscapeKey], \
\[Backslash][NotTildeFullEqual]"], 
          ButtonBox["\[NotTilde]",
            ButtonNote->"\[EscapeKey]!~\[EscapeKey], \[Backslash][NotTilde]"],
           
          ButtonBox["\[Tilde]",
            ButtonNote->"\[EscapeKey]~\[EscapeKey], \[Backslash][Tilde]"], 
          ButtonBox["\[TildeTilde]",
            
            ButtonNote->
              "\[EscapeKey]~~\[EscapeKey], \[Backslash][TildeTilde]"], 
          ButtonBox["\[NotTildeTilde]",
            ButtonNote->
              "\[EscapeKey]!~~\[EscapeKey], \[Backslash][NotTildeTilde]"]},
        {
          ButtonBox["\[NotEqualTilde]",
            
            ButtonNote->
              "\[EscapeKey]!=~\[EscapeKey], \[Backslash][NotEqualTilde]"], 
          ButtonBox["\[EqualTilde]",
            
            ButtonNote->
              "\[EscapeKey]=~\[EscapeKey], \[Backslash][EqualTilde]"], 
          ButtonBox["\[CupCap]",
            ButtonNote->"\[Backslash][CupCap]"], 
          ButtonBox["\[NotCupCap]",
            ButtonNote->"\[Backslash][NotCupCap]"], 
          ButtonBox["\[NotHumpEqual]",
            
            ButtonNote->
              "\[EscapeKey]!h=\[EscapeKey], \[Backslash][NotHumpEqual]"], 
          ButtonBox["\[HumpEqual]",
            
            ButtonNote->
              "\[EscapeKey]h=\[EscapeKey], \[Backslash][HumpEqual]"], 
          ButtonBox["\[HumpDownHump]",
            ButtonNote->"\[Backslash][HumpDownHump]"], 
          ButtonBox["\[NotHumpDownHump]",
            
            ButtonNote->
              "\[EscapeKey]!hvh\[EscapeKey], \
\[Backslash][NotHumpDownHump]"]},
        {
          ButtonBox["\[NotLess]",
            ButtonNote->"\[EscapeKey]!<\[EscapeKey], \[Backslash][NotLess]"], 
          
          ButtonBox["<",
            ButtonNote->"\[Backslash][RawLess]"], 
          ButtonBox[">",
            ButtonNote->"\[Backslash][RawGreater]"], 
          ButtonBox["\[NotGreater]",
            
            ButtonNote->
              "\[EscapeKey]!>\[EscapeKey], \[Backslash][NotGreater]"], 
          ButtonBox["\[NotLessLess]",
            ButtonNote->"\[Backslash][NotLessLess]"], 
          ButtonBox["\[LessLess]",
            ButtonNote->"\[Backslash][LessLess]"], 
          ButtonBox["\[GreaterGreater]",
            ButtonNote->"\[Backslash][GreaterGreater]"], 
          ButtonBox["\[NotGreaterGreater]",
            ButtonNote->"\[Backslash][NotGreaterGreater]"]},
        {
          ButtonBox["\[NotLessSlantEqual]",
            ButtonNote->
              "\[EscapeKey]!</\[EscapeKey], \[Backslash][NotLessSlantEqual]"],
           
          ButtonBox["\[LessSlantEqual]",
            
            ButtonNote->
              "\[EscapeKey]</\[EscapeKey], \[Backslash][LessSlantEqual]"], 
          ButtonBox["\[GreaterSlantEqual]",
            
            ButtonNote->
              "\[EscapeKey]>/\[EscapeKey], \[Backslash][GreaterSlantEqual]"], 
          
          ButtonBox["\[NotGreaterSlantEqual]",
            
            ButtonNote->
              "\[EscapeKey]!>/\[EscapeKey], \
\[Backslash][NotGreaterSlantEqual]"], 
          ButtonBox["\[NotNestedLessLess]",
            ButtonNote->"\[Backslash][NotNestedLessLess]"], 
          ButtonBox["\[NestedLessLess]",
            ButtonNote->"\[Backslash][NestedLessLess]"], 
          ButtonBox["\[NestedGreaterGreater]",
            ButtonNote->"\[Backslash][NestedGreaterGreater]"], 
          ButtonBox["\[NotNestedGreaterGreater]",
            ButtonNote->"\[Backslash][NotNestedGreaterGreater]"]},
        {
          ButtonBox["\[NotLessEqual]",
            
            ButtonNote->
              "\[EscapeKey]!<=\[EscapeKey], \[Backslash][NotLessEqual]"], 
          ButtonBox["\[LessEqual]",
            
            ButtonNote->
              "\[EscapeKey]<=\[EscapeKey], \[Backslash][LessEqual]"], 
          ButtonBox["\[GreaterEqual]",
            
            ButtonNote->
              "\[EscapeKey]>=\[EscapeKey], \[Backslash][GreaterEqual]"], 
          ButtonBox["\[NotGreaterEqual]",
            
            ButtonNote->
              "\[EscapeKey]!>=\[EscapeKey], \[Backslash][NotGreaterEqual]"], 
          ButtonBox["\[NotLessGreater]",
            ButtonNote->"\[Backslash][NotLessGreater]"], 
          ButtonBox["\[LessGreater]",
            ButtonNote->"\[Backslash][LessGreater]"], 
          ButtonBox["\[GreaterLess]",
            ButtonNote->"\[Backslash][GreaterLess]"], 
          ButtonBox["\[NotGreaterLess]",
            ButtonNote->"\[Backslash][NotGreaterLess]"]},
        {
          ButtonBox["\[NotLessFullEqual]",
            ButtonNote->"\[Backslash][NotLessFullEqual]"], 
          ButtonBox["\[LessFullEqual]",
            ButtonNote->"\[Backslash][LessFullEqual]"], 
          ButtonBox["\[GreaterFullEqual]",
            ButtonNote->"\[Backslash][GreaterFullEqual]"], 
          ButtonBox["\[NotGreaterFullEqual]",
            ButtonNote->"\[Backslash][NotGreaterFullEqual]"], 
          ButtonBox["\[NotLessTilde]",
            
            ButtonNote->
              "\[EscapeKey]!<~\[EscapeKey], \[Backslash][NotLessTilde]"], 
          ButtonBox["\[LessTilde]",
            
            ButtonNote->
              "\[EscapeKey]<~\[EscapeKey], \[Backslash][LessTilde]"], 
          ButtonBox["\[GreaterTilde]",
            
            ButtonNote->
              "\[EscapeKey]>~\[EscapeKey], \[Backslash][GreaterTilde]"], 
          ButtonBox["\[NotGreaterTilde]",
            
            ButtonNote->
              "\[EscapeKey]!>~\[EscapeKey], \[Backslash][NotGreaterTilde]"]},
        {
          ButtonBox["\[NotPrecedes]",
            ButtonNote->"\[Backslash][NotPrecedes]"], 
          ButtonBox["\[Precedes]",
            ButtonNote->"\[Backslash][Precedes]"], 
          ButtonBox["\[Succeeds]",
            ButtonNote->"\[Backslash][Succeeds]"], 
          ButtonBox["\[NotSucceeds]",
            ButtonNote->"\[Backslash][NotSucceeds]"], 
          ButtonBox["\[NotLeftTriangle]",
            ButtonNote->"\[Backslash][NotLeftTriangle]"], 
          ButtonBox["\[LeftTriangle]",
            ButtonNote->"\[Backslash][LeftTriangle]"], 
          ButtonBox["\[RightTriangle]",
            ButtonNote->"\[Backslash][RightTriangle]"], 
          ButtonBox["\[NotRightTriangle]",
            ButtonNote->"\[Backslash][NotRightTriangle]"]},
        {
          ButtonBox["\[NotPrecedesSlantEqual]",
            ButtonNote->"\[Backslash][NotPrecedesSlantEqual]"], 
          ButtonBox["\[PrecedesSlantEqual]",
            ButtonNote->"\[Backslash][PrecedesSlantEqual]"], 
          ButtonBox["\[SucceedsSlantEqual]",
            ButtonNote->"\[Backslash][SucceedsSlantEqual]"], 
          ButtonBox["\[NotSucceedsSlantEqual]",
            ButtonNote->"\[Backslash][NotSucceedsSlantEqual]"], 
          ButtonBox["\[NotLeftTriangleBar]",
            ButtonNote->"\[Backslash][NotLeftTriangleBar]"], 
          ButtonBox["\[LeftTriangleBar]",
            ButtonNote->"\[Backslash][LeftTriangleBar]"], 
          ButtonBox["\[RightTriangleBar]",
            ButtonNote->"\[Backslash][RightTriangleBar]"], 
          ButtonBox["\[NotRightTriangleBar]",
            ButtonNote->"\[Backslash][NotRightTriangleBar]"]},
        {
          ButtonBox["\[NotPrecedesEqual]",
            ButtonNote->"\[Backslash][NotPrecedesEqual]"], 
          ButtonBox["\[PrecedesEqual]",
            ButtonNote->"\[Backslash][PrecedesEqual]"], 
          ButtonBox["\[SucceedsEqual]",
            ButtonNote->"\[Backslash][SucceedsEqual]"], 
          ButtonBox["\[NotSucceedsEqual]",
            ButtonNote->"\[Backslash][NotSucceedsEqual]"], 
          ButtonBox["\[NotLeftTriangleEqual]",
            ButtonNote->"\[Backslash][NotLeftTriangleEqual]"], 
          ButtonBox["\[LeftTriangleEqual]",
            ButtonNote->"\[Backslash][LeftTriangleEqual]"], 
          ButtonBox["\[RightTriangleEqual]",
            ButtonNote->"\[Backslash][RightTriangleEqual]"], 
          ButtonBox["\[NotRightTriangleEqual]",
            ButtonNote->"\[Backslash][NotRightTriangleEqual]"]},
        {
          ButtonBox["\[NotPrecedesTilde]",
            ButtonNote->"\[Backslash][NotPrecedesTilde]"], 
          ButtonBox["\[PrecedesTilde]",
            ButtonNote->"\[Backslash][PrecedesTilde]"], 
          ButtonBox["\[SucceedsTilde]",
            ButtonNote->"\[Backslash][SucceedsTilde]"], 
          ButtonBox["\[NotSucceedsTilde]",
            ButtonNote->"\[Backslash][NotSucceedsTilde]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox["\[LessEqualGreater]",
            ButtonNote->"\[Backslash][LessEqualGreater]"], 
          ButtonBox["\[GreaterEqualLess]",
            ButtonNote->"\[Backslash][GreaterEqualLess]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[NotSubset]",
            
            ButtonNote->
              "\[EscapeKey]!sub\[EscapeKey], \[Backslash][NotSubset]"], 
          ButtonBox["\[Subset]",
            ButtonNote->"\[EscapeKey]sub\[EscapeKey], \[Backslash][Subset]"], 
          
          ButtonBox["\[Superset]",
            
            ButtonNote->
              "\[EscapeKey]sup\[EscapeKey], \[Backslash][Superset]"], 
          ButtonBox["\[NotSuperset]",
            
            ButtonNote->
              "\[EscapeKey]!sup\[EscapeKey], \[Backslash][NotSuperset]"], 
          ButtonBox["\[NotSubsetEqual]",
            
            ButtonNote->
              "\[EscapeKey]!sub=\[EscapeKey], \[Backslash][NotSubsetEqual]"], 
          
          ButtonBox["\[SubsetEqual]",
            
            ButtonNote->
              "\[EscapeKey]sub=\[EscapeKey], \[Backslash][SubsetEqual]"], 
          ButtonBox["\[SupersetEqual]",
            
            ButtonNote->
              "\[EscapeKey]sup=\[EscapeKey], \[Backslash][SupersetEqual]"], 
          ButtonBox["\[NotSupersetEqual]",
            
            ButtonNote->
              "\[EscapeKey]!sup=\[EscapeKey], \
\[Backslash][NotSupersetEqual]"]},
        {
          ButtonBox["\[NotSquareSubset]",
            ButtonNote->"\[Backslash][NotSquareSubset]"], 
          ButtonBox["\[SquareSubset]",
            ButtonNote->"\[Backslash][SquareSubset]"], 
          ButtonBox["\[SquareSuperset]",
            ButtonNote->"\[Backslash][SquareSuperset]"], 
          ButtonBox["\[NotSquareSuperset]",
            ButtonNote->"\[Backslash][NotSquareSuperset]"], 
          ButtonBox["\[NotSquareSubsetEqual]",
            ButtonNote->"\[Backslash][NotSquareSubsetEqual]"], 
          ButtonBox["\[SquareSubsetEqual]",
            ButtonNote->"\[Backslash][SquareSubsetEqual]"], 
          ButtonBox["\[SquareSupersetEqual]",
            ButtonNote->"\[Backslash][SquareSupersetEqual]"], 
          ButtonBox["\[NotSquareSupersetEqual]",
            ButtonNote->"\[Backslash][NotSquareSupersetEqual]"]},
        {
          ButtonBox["\[NotElement]",
            
            ButtonNote->
              "\[EscapeKey]!elem\[EscapeKey], \[Backslash][NotElement]"], 
          ButtonBox["\[Element]",
            
            ButtonNote->
              "\[EscapeKey]elem\[EscapeKey], \[Backslash][Element]"], 
          ButtonBox["\[ReverseElement]",
            
            ButtonNote->
              "\[EscapeKey]mem\[EscapeKey], \[Backslash][ReverseElement]"], 
          ButtonBox["\[NotReverseElement]",
            
            ButtonNote->
              "\[EscapeKey]!mem\[EscapeKey], \
\[Backslash][NotReverseElement]"], 
          ButtonBox["\[NotVerticalBar]",
            
            ButtonNote->
              "\[EscapeKey]!|\[EscapeKey], \[Backslash][NotVerticalBar]"], 
          ButtonBox["\[VerticalBar]",
            
            ButtonNote->
              "\[EscapeKey] |\[EscapeKey], \[Backslash][VerticalBar]"], 
          ButtonBox["\[DoubleVerticalBar]",
            
            ButtonNote->
              "\[EscapeKey] ||\[EscapeKey], \[Backslash][DoubleVerticalBar]"],
           
          ButtonBox["\[NotDoubleVerticalBar]",
            
            ButtonNote->
              "\[EscapeKey]!||\[EscapeKey], \
\[Backslash][NotDoubleVerticalBar]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->{
        False, False, True, False, False, False, True, False, False, False, 
          True, False},
      ColumnLines->{False, False, False, True, False},
      ColumnsEqual->False]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Arrows", "Text",
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->{"SectionGrouping", 20},
  FontSlant->"Italic"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["\[LeftArrow]",
            
            ButtonNote->
              "\[EscapeKey]<-\[EscapeKey], \[Backslash][LeftArrow]"], 
          ButtonBox["\[RightArrow]",
            
            ButtonNote->
              "\[EscapeKey] ->\[EscapeKey], \[Backslash][RightArrow]"], 
          ButtonBox["\[UpArrow]",
            ButtonNote->"\[Backslash][UpArrow]"], 
          ButtonBox["\[DownArrow]",
            ButtonNote->"\[Backslash][DownArrow]"], 
          ButtonBox["\[LeftRightArrow]",
            
            ButtonNote->
              "\[EscapeKey]<->\[EscapeKey], \[Backslash][LeftRightArrow]"], 
          ButtonBox["\[DoubleLeftRightArrow]",
            
            ButtonNote->
              "\[EscapeKey]<=>\[EscapeKey], \
\[Backslash][DoubleLeftRightArrow]"]},
        {
          ButtonBox["\[LowerLeftArrow]",
            ButtonNote->"\[Backslash][LowerLeftArrow]"], 
          ButtonBox["\[LowerRightArrow]",
            ButtonNote->"\[Backslash][LowerRightArrow]"], 
          ButtonBox[
            AdjustmentBox["\[UpperLeftArrow]",
              BoxMargins->{{0.2, 0.2}, {0, 0}}],
            ButtonData:>"\[UpperLeftArrow]",
            ButtonNote->"\[Backslash][UpperLeftArrow]"], 
          ButtonBox[
            AdjustmentBox["\[UpperRightArrow]",
              BoxMargins->{{0.2, 0.2}, {0, 0}}],
            ButtonData:>"\[UpperRightArrow]",
            ButtonNote->"\[Backslash][UpperRightArrow]"], 
          ButtonBox["\[UpDownArrow]",
            ButtonNote->"\[Backslash][UpDownArrow]"], 
          ButtonBox["\[DoubleUpDownArrow]",
            ButtonNote->"\[Backslash][DoubleUpDownArrow]"]},
        {
          ButtonBox["\[ShortLeftArrow]",
            ButtonNote->"\[Backslash][ShortLeftArrow]"], 
          ButtonBox["\[ShortRightArrow]",
            ButtonNote->"\[Backslash][ShortRightArrow]"], 
          ButtonBox["\[ShortUpArrow]",
            ButtonNote->"\[Backslash][ShortUpArrow]"], 
          ButtonBox["\[ShortDownArrow]",
            ButtonNote->"\[Backslash][ShortDownArrow]"], 
          ButtonBox["\[LongLeftRightArrow]",
            
            ButtonNote->
              "\[EscapeKey]<-->\[EscapeKey], \
\[Backslash][LongLeftRightArrow]"], 
          ButtonBox["\[DoubleLongLeftRightArrow]",
            
            ButtonNote->
              "\[EscapeKey]<==>\[EscapeKey], \
\[Backslash][DoubleLongLeftRightArrow]"]},
        {
          ButtonBox["\[DoubleLeftArrow]",
            
            ButtonNote->
              "\[EscapeKey] <=\[EscapeKey], \[Backslash][DoubleLeftArrow]"], 
          ButtonBox["\[DoubleRightArrow]",
            
            ButtonNote->
              "\[EscapeKey] =>\[EscapeKey], \[Backslash][DoubleRightArrow]"], 
          
          ButtonBox["\[DoubleUpArrow]",
            ButtonNote->"\[Backslash][DoubleUpArrow]"], 
          ButtonBox["\[DoubleDownArrow]",
            ButtonNote->"\[Backslash][DoubleDownArrow]"], 
          ButtonBox["\[LongLeftArrow]",
            
            ButtonNote->
              "\[EscapeKey]<--\[EscapeKey], \[Backslash][LongLeftArrow]"], 
          ButtonBox["\[DoubleLongLeftArrow]",
            
            ButtonNote->
              "\[EscapeKey]<==\[EscapeKey], \
\[Backslash][DoubleLongLeftArrow]"]},
        {
          ButtonBox["\[LeftArrowRightArrow]",
            ButtonNote->"\[Backslash][LeftArrowRightArrow]"], 
          ButtonBox["\[RightArrowLeftArrow]",
            ButtonNote->"\[Backslash][RightArrowLeftArrow]"], 
          ButtonBox["\[DownArrowUpArrow]",
            ButtonNote->"\[Backslash][DownArrowUpArrow]"], 
          ButtonBox["\[UpArrowDownArrow]",
            ButtonNote->"\[Backslash][UpArrowDownArrow]"], 
          ButtonBox["\[LongRightArrow]",
            
            ButtonNote->
              "\[EscapeKey]-->\[EscapeKey], \[Backslash][LongRightArrow]"], 
          ButtonBox["\[DoubleLongRightArrow]",
            
            ButtonNote->
              "\[EscapeKey]==>\[EscapeKey], \
\[Backslash][DoubleLongRightArrow]"]},
        {
          ButtonBox["\[LeftVector]",
            ButtonNote->"\[Backslash][LeftVector]"], 
          ButtonBox["\[RightVector]",
            
            ButtonNote->
              "\[EscapeKey]vec\[EscapeKey], \[Backslash][RightVector]"], 
          ButtonBox["\[LeftUpVector]",
            ButtonNote->"\[Backslash][LeftUpVector]"], 
          ButtonBox["\[LeftDownVector]",
            ButtonNote->"\[Backslash][LeftDownVector]"], 
          ButtonBox["\[LeftRightVector]",
            ButtonNote->"\[Backslash][LeftRightVector]"], 
          ButtonBox["\[LeftUpDownVector]",
            ButtonNote->"\[Backslash][LeftUpDownVector]"]},
        {
          ButtonBox["\[DownLeftVector]",
            ButtonNote->"\[Backslash][DownLeftVector]"], 
          ButtonBox["\[DownRightVector]",
            ButtonNote->"\[Backslash][DownRightVector]"], 
          ButtonBox["\[RightDownVector]",
            ButtonNote->"\[Backslash][RightDownVector]"], 
          ButtonBox["\[RightUpVector]",
            ButtonNote->"\[Backslash][RightUpVector]"], 
          ButtonBox["\[DownLeftRightVector]",
            ButtonNote->"\[Backslash][DownLeftRightVector]"], 
          ButtonBox["\[RightUpDownVector]",
            ButtonNote->"\[Backslash][RightUpDownVector]"]},
        {
          ButtonBox["\[LeftArrowBar]",
            ButtonNote->"\[Backslash][LeftArrowBar]"], 
          ButtonBox["\[RightArrowBar]",
            ButtonNote->"\[Backslash][RightArrowBar]"], 
          ButtonBox["\[UpArrowBar]",
            ButtonNote->"\[Backslash][UpArrowBar]"], 
          ButtonBox["\[DownArrowBar]",
            ButtonNote->"\[Backslash][DownArrowBar]"], 
          ButtonBox["\[ReverseEquilibrium]",
            ButtonNote->"\[Backslash][ReverseEquilibrium]"], 
          ButtonBox["\[Equilibrium]",
            ButtonNote->
              "\[EscapeKey]equi\[EscapeKey], \[Backslash][Equilibrium]"]},
        {
          ButtonBox["\[LeftVectorBar]",
            ButtonNote->"\[Backslash][LeftVectorBar]"], 
          ButtonBox["\[RightVectorBar]",
            ButtonNote->"\[Backslash][RightVectorBar]"], 
          ButtonBox["\[LeftUpVectorBar]",
            ButtonNote->"\[Backslash][LeftUpVectorBar]"], 
          ButtonBox["\[LeftDownVectorBar]",
            ButtonNote->"\[Backslash][LeftDownVectorBar]"], 
          ButtonBox["\[UpEquilibrium]",
            ButtonNote->"\[Backslash][UpEquilibrium]"], 
          ButtonBox["\[ReverseUpEquilibrium]",
            ButtonNote->"\[Backslash][ReverseUpEquilibrium]"]},
        {
          ButtonBox["\[DownLeftVectorBar]",
            ButtonNote->"\[Backslash][DownLeftVectorBar]"], 
          ButtonBox["\[DownRightVectorBar]",
            ButtonNote->"\[Backslash][DownRightVectorBar]"], 
          ButtonBox["\[RightUpVectorBar]",
            ButtonNote->"\[Backslash][RightUpVectorBar]"], 
          ButtonBox["\[RightDownVectorBar]",
            ButtonNote->"\[Backslash][RightDownVectorBar]"], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False], 
          ButtonBox[" ",
            ButtonFunction:>Null,
            Active->False]},
        {
          ButtonBox["\[LeftTeeArrow]",
            ButtonNote->"\[Backslash][LeftTeeArrow]"], 
          ButtonBox["\[RightTeeArrow]",
            ButtonNote->"\[Backslash][RightTeeArrow]"], 
          ButtonBox["\[UpTeeArrow]",
            ButtonNote->"\[Backslash][UpTeeArrow]"], 
          ButtonBox["\[DownTeeArrow]",
            ButtonNote->"\[Backslash][DownTeeArrow]"], 
          ButtonBox["\[DoubleRightTee]",
            ButtonNote->"\[Backslash][DoubleRightTee]"], 
          ButtonBox["\[DoubleLeftTee]",
            ButtonNote->"\[Backslash][DoubleLeftTee]"]},
        {
          ButtonBox["\[LeftTeeVector]",
            ButtonNote->"\[Backslash][LeftTeeVector]"], 
          ButtonBox["\[RightTeeVector]",
            ButtonNote->"\[Backslash][RightTeeVector]"], 
          ButtonBox["\[LeftUpTeeVector]",
            ButtonNote->"\[Backslash][LeftUpTeeVector]"], 
          ButtonBox["\[LeftDownTeeVector]",
            ButtonNote->"\[Backslash][LeftDownTeeVector]"], 
          ButtonBox["\[LeftTee]",
            ButtonNote->"\[EscapeKey]lT\[EscapeKey], \[Backslash][LeftTee]"], 
          
          ButtonBox["\[RightTee]",
            
            ButtonNote->
              "\[EscapeKey]rT\[EscapeKey], \[Backslash][RightTee]"]},
        {
          ButtonBox["\[DownLeftTeeVector]",
            ButtonNote->"\[Backslash][DownLeftTeeVector]"], 
          ButtonBox["\[DownRightTeeVector]",
            ButtonNote->"\[Backslash][DownRightTeeVector]"], 
          ButtonBox["\[RightUpTeeVector]",
            ButtonNote->"\[Backslash][RightUpTeeVector]"], 
          ButtonBox["\[RightDownTeeVector]",
            ButtonNote->"\[Backslash][RightDownTeeVector]"], 
          ButtonBox["\[UpTee]",
            ButtonNote->"\[EscapeKey]uT\[EscapeKey], \[Backslash][UpTee]"], 
          ButtonBox["\[DownTee]",
            ButtonNote->"\[EscapeKey]dT\[EscapeKey], \[Backslash][DownTee]"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridFrame->False,
      GridFrameMargins->False,
      RowLines->{
        False, False, False, False, True, False, True, False, False, True, 
          False},
      ColumnLines->{False, False, False, True, False},
      ColumnsEqual->False]], NotebookDefault,
  CellMargins->{{12, Inherited}, {6, Inherited}}]
}, Closed]]
}, Closed]],

Cell["Put your pointer over a character to see its alias or name.", "Text",
  PageWidth->WindowWidth,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"SectionGrouping",
  FontFamily->"Helvetica",
  FontSize->10]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
ClosingAutoSave->True,
Editable->False,
WindowToolbars->{},
PageWidth->355,
WindowSize->{170, 380},
WindowMargins->{{Automatic, 2}, {Automatic, 3}},
WindowFrame->"Palette",
WindowElements->{"StatusArea", "VerticalScrollBar"},
WindowFrameElements->{"CloseBox", "ZoomBox", "ResizeArea"},
WindowClickSelect->False,
WindowTitle->None,
ScrollingOptions->{"PagewiseScrolling"->False,
"VerticalScrollRange"->Fit},
ShowCellBracket->False,
ShowGroupOpenCloseIcon->True,
CellMargins->{{3, 0}, {0, 3}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ShowAutoStyles->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Background->GrayLevel[1],
Magnification->1
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1728, 52, 184, 5, 31, "Text",
  CellGroupingRules->{"SectionGrouping", 10}],

Cell[CellGroupData[{
Cell[1937, 61, 148, 3, 33, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[2088, 66, 9372, 234, 70, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[11497, 305, 149, 3, 30, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[11649, 310, 11998, 324, 204, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[23684, 639, 149, 3, 30, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[23836, 644, 9877, 261, 204, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[33750, 910, 162, 3, 30, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[33915, 915, 11498, 329, 204, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[45450, 1249, 157, 3, 30, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[45610, 1254, 11777, 293, 262, NotebookDefault]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[57436, 1553, 200, 5, 51, "Text",
  CellGroupingRules->{"SectionGrouping", 10}],

Cell[CellGroupData[{
Cell[57661, 1562, 160, 3, 33, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[57824, 1567, 4256, 109, 120, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[62117, 1681, 159, 3, 30, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[62279, 1686, 6600, 175, 158, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[68916, 1866, 156, 3, 30, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[69075, 1871, 7586, 187, 176, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[76698, 2063, 157, 3, 30, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[76858, 2068, 4719, 125, 172, NotebookDefault]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[81626, 2199, 194, 5, 31, "Text",
  CellGroupingRules->{"SectionGrouping", 10}],

Cell[CellGroupData[{
Cell[81845, 2208, 150, 3, 70, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[81998, 2213, 9543, 243, 70, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[91578, 2461, 153, 3, 70, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[91734, 2466, 14155, 348, 70, NotebookDefault]
}, Closed]],

Cell[CellGroupData[{
Cell[105926, 2819, 149, 3, 70, "Text",
  CellGroupingRules->{"SectionGrouping", 20}],
Cell[106078, 2824, 9469, 224, 70, NotebookDefault]
}, Closed]]
}, Closed]],
Cell[115574, 3052, 241, 5, 62, "Text",
  CellGroupingRules->"SectionGrouping"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

