(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     51158,       1795]*)
(*NotebookOutlinePosition[     51794,       1817]*)
(*  CellTagsIndexPosition[     51750,       1813]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->12,
  FontSize->16],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Condensed"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Margins"->{1, 1},
  "Widths"->{0, 5}},
  ScriptMinSize->8,
  FontSize->11],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageHeaderLines->{True, True},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  LineSpacing->{1, 11},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontSize->34,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{0, 0}, {0, 0}},
  CellFrameMargins->{{12, 10}, {24, 24}},
  LineSpacing->{1, 0},
  FontSize->46],

Cell[StyleData["Title", "Condensed"],
  CellMargins->{{0, 0}, {0, 0}},
  FontSize->20],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{0, 0}, {0, 0}},
  FontSize->24,
  FontTracking->"Plain",
  Background->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  LineSpacing->{1, 3},
  ParagraphIndent->-96,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.2, 0.700008, 0.700008]],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{0, 0}, {4, 0}},
  CellFrameMargins->{{12, 10}, {12, 8}},
  LineSpacing->{1, 6},
  ParagraphIndent->-157,
  FontSize->28],

Cell[StyleData["Subtitle", "Condensed"],
  CellMargins->{{0, 0}, {0, 0}},
  ParagraphIndent->-78,
  FontSize->14],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{0, 0}, {0, 0}},
  ParagraphIndent->-85,
  FontSize->16,
  Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {30, 10}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{15, 10}, {50, 10}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsubtitle", "Condensed"],
  CellMargins->{{8, 10}, {12, 8}},
  FontSize->12],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{9, 10}, {50, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{6, 0}, {0, 1}},
  CellDingbat->None,
  CellMargins->{{12, Inherited}, {4, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  LineSpacing->{1, 7},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Section", "Presentation"],
  CellFrame->{{8, 0}, {0, 2}},
  CellMargins->{{15, 10}, {14, 32}},
  CellFrameMargins->{{8, 10}, {10, 14}},
  LineSpacing->{1, 2},
  FontSize->24,
  FontTracking->"Condensed"],

Cell[StyleData["Section", "Condensed"],
  CellMargins->{{8, Inherited}, {2, 12}},
  FontSize->12],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{9, 0}, {2, 50}},
  FontSize->14,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellMargins->{{12, Inherited}, {8, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  LineSpacing->{1, 7},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->13,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{15, 10}, {12, 32}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsection", "Condensed"],
  CellMargins->{{8, Inherited}, {2, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {4, 40}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{25, Inherited}, {8, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  LineSpacing->{1, 9},
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->13,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{34, 10}, {18, 28}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Subsubsection", "Condensed"],
  CellMargins->{{22, Inherited}, {2, 12}},
  FontSize->10],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{21, 0}, {4, 20}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {5, 5}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 12},
  CounterIncrements->"Text",
  FontFamily->"Times"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{15, 10}, {8, 10}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12},
  FontSize->18],

Cell[StyleData["Text", "Condensed"],
  CellMargins->{{8, 10}, {4, 4}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  Hyphenation->True,
  ParagraphSpacing->{0, 6}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{12, 10}, {5, 5}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 6},
  CounterIncrements->"SmallText",
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{15, 10}, {8, 10}},
  LineSpacing->{1, 5},
  FontSize->14],

Cell[StyleData["SmallText", "Condensed"],
  CellMargins->{{8, 10}, {2, 2}},
  LineSpacing->{1, 2},
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  Hyphenation->True,
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{5, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  FontWeight->"Bold",
  Background->RGBColor[1, 0.700008, 0.4]],

Cell[StyleData["Input", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{74, 10}, {8, 10}},
  CellFrameMargins->{{10, 10}, {14, 14}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Input", "Condensed"],
  CellMargins->{{40, Inherited}, {1, 4}}],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{44, 0}, {2, 6}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["InlineInput", "Presentation"],
  FontSize->18],

Cell[StyleData["InlineInput", "Condensed"]],

Cell[StyleData["InlineInput", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  CounterIncrements->"Output",
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["Output", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{74, 10}, {12, 5}},
  CellFrameMargins->{{10, 10}, {14, 14}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Output", "Condensed"],
  CellMargins->{{40, Inherited}, {4, 1}}],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{44, 0}, {6, 2}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{62, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{86, 20}, {10, 10}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Message", "Condensed"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{54, Inherited}, {Inherited, Inherited}},
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{62, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{86, 20}, {4, 4}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Print", "Condensed"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{54, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{62, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  CellMargins->{{86, 20}, {8, 8}},
  FontSize->18],

Cell[StyleData["Graphics", "Condensed"],
  CellMargins->{{52, Inherited}, {Inherited, Inherited}},
  ImageSize->{175, 175}],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{54, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->11,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["CellLabel", "Condensed"],
  FontSize->8],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {2, 10}},
  LineSpacing->{1, 5},
  FontSize->16,
  FontSlant->"Italic"],

Cell[StyleData["Author", "Presentation"],
  CellMargins->{{15, 10}, {4, 16}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12},
  FontSize->24],

Cell[StyleData["Author", "Condensed"],
  CellMargins->{{8, 10}, {1, 4}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4},
  FontSize->12],

Cell[StyleData["Author", "Printout"],
  CellMargins->{{9, 0}, {4, 12}},
  ParagraphSpacing->{0, 6},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Copyright"],
  ShowCellBracket->False,
  CellMargins->{{10, 10}, {40, 2}},
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Copyright", "Presentation"],
  CellMargins->{{15, 10}, {50, 4}},
  LineSpacing->{1, 5},
  FontSize->14],

Cell[StyleData["Copyright", "Condensed"],
  CellMargins->{{8, 10}, {12, 1}},
  LineSpacing->{1, 2},
  FontSize->9],

Cell[StyleData["Copyright", "Printout"],
  CellMargins->{{9, 0}, {72, 4}},
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Example"],
  CellMargins->{{12, 10}, {5, 12}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 12},
  CounterIncrements->"Example",
  FontFamily->"Times",
  FontWeight->"Bold"],

Cell[StyleData["Example", "Presentation"],
  CellMargins->{{18, 10}, {8, 20}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12},
  FontSize->18],

Cell[StyleData["Example", "Condensed"],
  CellMargins->{{8, 10}, {4, 8}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4}],

Cell[StyleData["Example", "Printout"],
  CellMargins->{{9, 0}, {4, 10}},
  ParagraphSpacing->{0, 6}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Definition"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  ShowStringCharacters->True,
  CounterIncrements->"Definition",
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.2, 0.700008, 0.700008]],

Cell[StyleData["Definition", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{74, 10}, {8, 12}},
  CellFrameMargins->{{10, 10}, {14, 14}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Definition", "Condensed"],
  CellMargins->{{40, 10}, {1, 4}}],

Cell[StyleData["Definition", "Printout"],
  CellMargins->{{44, 0}, {2, 6}},
  Hyphenation->True,
  Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Theorem"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{52, 10}, {8, 8}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  ShowStringCharacters->True,
  CounterIncrements->"Theorem",
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Theorem", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{74, 10}, {8, 12}},
  CellFrameMargins->{{10, 10}, {14, 14}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Theorem", "Condensed"],
  CellMargins->{{40, 10}, {1, 4}}],

Cell[StyleData["Theorem", "Printout"],
  CellMargins->{{44, 0}, {2, 6}},
  Hyphenation->True,
  Background->GrayLevel[0.4]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExerciseMain"],
  CellFrame->{{6, 0}, {0, 1}},
  CellMargins->{{12, Inherited}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.571389, 0.19675, 0.570504],
  LineSpacing->{1, 7},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["ExerciseMain", "Presentation"],
  CellFrame->{{8, 0}, {0, 2}},
  CellMargins->{{18, 10}, {12, 32}},
  CellFrameMargins->{{10, 10}, {14, 14}},
  LineSpacing->{1, 2},
  FontSize->24,
  FontTracking->"Condensed"],

Cell[StyleData["ExerciseMain", "Condensed"],
  CellMargins->{{8, Inherited}, {2, 12}},
  FontSize->12],

Cell[StyleData["ExerciseMain", "Printout"],
  CellMargins->{{9, 0}, {2, 50}},
  CellFrameColor->GrayLevel[0.500008],
  FontSize->14,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Exercise"],
  CellDingbat->"\[FilledDownTriangle]",
  CellMargins->{{23, Inherited}, {4, 18}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  LineSpacing->{1, 7},
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->13,
  FontWeight->"Bold",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["Exercise", "Presentation"],
  CellMargins->{{28, 10}, {10, 34}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Exercise", "Condensed"],
  CellMargins->{{17, Inherited}, {2, 12}},
  FontSize->10],

Cell[StyleData["Exercise", "Printout"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellDingbat->None,
  CellMargins->{{9, 0}, {6, 20}},
  Hyphenation->True,
  FontSize->11,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExerciseText"],
  CellMargins->{{62, 10}, {5, 5}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"ExerciseText",
  FontFamily->"Times"],

Cell[StyleData["ExerciseText", "Presentation"],
  CellMargins->{{100, 10}, {8, 8}},
  LineSpacing->{1, 5},
  ParagraphSpacing->{0, 12},
  FontSize->18],

Cell[StyleData["ExerciseText", "Condensed"],
  CellMargins->{{52, 10}, {2, 2}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 4}],

Cell[StyleData["ExerciseText", "Printout"],
  CellMargins->{{54, 0}, {4, 4}},
  Hyphenation->True,
  ParagraphSpacing->{0, 6}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{62, 10}, {2, 10}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  ScriptLevel->0,
  SingleLetterItalics->True,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  CellMargins->{{100, 10}, {8, 16}},
  FontSize->18],

Cell[StyleData["DisplayFormula", "Condensed"],
  CellMargins->{{52, 10}, {2, 10}},
  FontSize->10],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{54, 10}, {2, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{62, 10}, {2, 10}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Presentation"],
  CellMargins->{{100, 10}, {8, 12}},
  FontSize->18],

Cell[StyleData["ChemicalFormula", "Condensed"],
  CellMargins->{{52, 10}, {2, 10}},
  FontSize->10],

Cell[StyleData["ChemicalFormula", "Printout"],
  CellMargins->{{54, 10}, {2, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{12, 10}, {Inherited, 6}},
  Hyphenation->False,
  LanguageCategory->"Formula",
  FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
  CellMargins->{{20, 30}, {4, 4}},
  FontSize->18],

Cell[StyleData["Program", "Condensed"],
  CellMargins->{{8, 10}, {Inherited, 4}},
  FontSize->9.5],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{9, 0}, {Inherited, 4}},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{62, 10}, {Inherited, Inherited}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Presentation"],
  CellMargins->{{100, 10}, {6, 8}},
  FontSize->18],

Cell[StyleData["NumberedEquation", "Condensed"],
  CellMargins->{{52, 10}, {Inherited, Inherited}}],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{54, 0}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{62, 145}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}]], None}},
  CounterIncrements->"NumberedFigure",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedFigure", "Presentation"],
  CellMargins->{{100, 145}, {8, 6}},
  FontSize->18],

Cell[StyleData["NumberedFigure", "Condensed"]],

Cell[StyleData["NumberedFigure", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{62, 145}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}]], None}},
  TextAlignment->Center,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedTable", "Presentation"],
  CellMargins->{{100, 145}, {8, 8}},
  FontSize->18],

Cell[StyleData["NumberedTable", "Condensed"]],

Cell[StyleData["NumberedTable", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"],
  FontSize->16],

Cell[StyleData["Hyperlink", "Condensed"],
  FontSize->11],

Cell[StyleData["Hyperlink", "SlideShow"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"],
  FontSize->16],

Cell[StyleData["MainBookLink", "Condensed"],
  FontSize->11],

Cell[StyleData["MainBookLink", "SlideShow"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"],
  FontSize->16],

Cell[StyleData["AddOnsLink", "Condensed"],
  FontSize->11],

Cell[StyleData["AddOnsLink", "SlideShow"]],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLink", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLink", "SlideShow"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLinkText", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLinkText", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLinkText", "SlideShow"]],

Cell[StyleData["RefGuideLinkText", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"],
  FontSize->16],

Cell[StyleData["GettingStartedLink", "Condensed"],
  FontSize->11],

Cell[StyleData["GettingStartedLink", "SlideShow"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "SlideShow"]],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "SlideShow"]],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"],
  FontSize->16],

Cell[StyleData["OtherInformationLink", "Condensed"],
  FontSize->11],

Cell[StyleData["OtherInformationLink", "SlideShow"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "SlideShow"]],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "Presentation"]],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica", "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  CellFrameMargins->{{18, 10}, {10, 16}},
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
  CellMargins->{{10, 10}, {8, 12}},
  FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
  CellMargins->{{35, 10}, {4, 6}},
  FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
  CellMargins->{{25, 10}, {8, 6}},
  FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
WindowSize->{515, 596},
WindowMargins->{{2, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 88, "Title"],
Cell[1813, 55, 193, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[2031, 63, 42, 0, 69, "Section"],
Cell[2076, 65, 77, 2, 38, 31, 0, "StyleData", "All", "Working"],
Cell[2156, 69, 99, 3, 40, 36, 0, "StyleData", "All", "Presentation"],
Cell[2258, 74, 182, 5, 38, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2443, 81, 158, 5, 35, 33, 0, "StyleData", "All", "Condensed"],
Cell[2604, 88, 140, 4, 34, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2781, 97, 35, 0, 39, "Section"],
Cell[2819, 99, 101, 3, 70, "Text"],
Cell[2923, 104, 529, 14, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3489, 123, 38, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[3552, 127, 1462, 33, 70, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[5017, 162, 154, 4, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[5174, 168, 86, 2, 70, 37, 0, "StyleData", "Title", "Condensed"],
Cell[5263, 172, 138, 4, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5438, 181, 1497, 35, 70, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[6938, 218, 181, 5, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[7122, 225, 113, 3, 70, 40, 0, "StyleData", "Subtitle", "Condensed"],
Cell[7238, 230, 142, 4, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7417, 239, 1379, 31, 70, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[8799, 272, 122, 3, 70, 46, 0, "StyleData", "Subsubtitle", \
"Presentation"],
Cell[8924, 277, 94, 2, 70, 43, 0, "StyleData", "Subsubtitle", "Condensed"],
Cell[9021, 281, 94, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9152, 288, 1540, 36, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[10695, 326, 219, 6, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[10917, 334, 97, 2, 70, 39, 0, "StyleData", "Section", "Condensed"],
Cell[11017, 338, 140, 4, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11194, 347, 1400, 32, 70, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[12597, 381, 121, 3, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[12721, 386, 100, 2, 70, 42, 0, "StyleData", "Subsection", "Condensed"],
Cell[12824, 390, 91, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12952, 397, 1390, 32, 70, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[14345, 431, 124, 3, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[14472, 436, 104, 2, 70, 45, 0, "StyleData", "Subsubsection", \
"Condensed"],
Cell[14579, 440, 95, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14723, 448, 39, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[14787, 452, 1250, 28, 40, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[16040, 482, 143, 4, 54, 39, 0, "StyleData", "Text", "Presentation"],
Cell[16186, 488, 121, 3, 38, 36, 0, "StyleData", "Text", "Condensed"],
Cell[16310, 493, 117, 3, 38, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16464, 501, 1278, 29, 35, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[17745, 532, 119, 3, 50, 44, 0, "StyleData", "SmallText", \
"Presentation"],
Cell[17867, 537, 113, 3, 30, 41, 0, "StyleData", "SmallText", "Condensed"],
Cell[17983, 542, 109, 3, 31, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18141, 551, 36, 0, 39, "Section"],
Cell[18180, 553, 121, 3, 50, "Text"],
Cell[18304, 558, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[18399, 563, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[18471, 567, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[18544, 571, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[18662, 577, 116, 4, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[18781, 583, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[18898, 589, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[19017, 595, 233, 6, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[19253, 603, 234, 6, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[19490, 611, 232, 6, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[19725, 619, 234, 6, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[19962, 627, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[20084, 633, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[20207, 639, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[20328, 645, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[20473, 653, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[20614, 660, 149, 5, 31, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[20800, 670, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[20907, 674, 90, 2, 38, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21046, 682, 42, 0, 39, "Section"],
Cell[21091, 684, 248, 5, 68, "Text"],

Cell[CellGroupData[{
Cell[21364, 693, 708, 19, 62, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[22075, 714, 188, 5, 83, 40, 0, "StyleData", "Input", "Presentation"],
Cell[22266, 721, 79, 1, 51, 37, 0, "StyleData", "Input", "Condensed"],
Cell[22348, 724, 105, 2, 54, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22490, 731, 491, 14, 38, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],
Cell[22984, 747, 62, 1, 45, 46, 0, "StyleData", "InlineInput", \
"Presentation"],
Cell[23049, 750, 43, 0, 38, 43, 0, "StyleData", "InlineInput", "Condensed"],
Cell[23095, 752, 58, 1, 35, 42, 0, "StyleData", "InlineInput", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23190, 758, 655, 17, 58, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[23848, 777, 189, 5, 81, 41, 0, "StyleData", "Output", "Presentation"],
Cell[24040, 784, 80, 1, 51, 38, 0, "StyleData", "Output", "Condensed"],
Cell[24123, 787, 106, 2, 54, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24266, 794, 531, 14, 38, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[24800, 810, 118, 3, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[24921, 815, 97, 1, 70, 39, 0, "StyleData", "Message", "Condensed"],
Cell[25021, 818, 123, 2, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25181, 825, 528, 14, 38, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[25712, 841, 114, 3, 44, 40, 0, "StyleData", "Print", "Presentation"],
Cell[25829, 846, 95, 1, 38, 37, 0, "StyleData", "Print", "Condensed"],
Cell[25927, 849, 94, 1, 38, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26058, 855, 389, 11, 38, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[26450, 868, 94, 2, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[26547, 872, 123, 2, 70, 40, 0, "StyleData", "Graphics", "Condensed"],
Cell[26673, 876, 122, 2, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26832, 883, 171, 5, 35, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[27006, 890, 60, 1, 38, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[27069, 893, 56, 1, 32, 41, 0, "StyleData", "CellLabel", "Condensed"],
Cell[27128, 896, 82, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27259, 904, 32, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[27316, 908, 148, 5, 70, 25, 0, "StyleData", "Author", "All"],
Cell[27467, 915, 145, 4, 70, 41, 0, "StyleData", "Author", "Presentation"],
Cell[27615, 921, 139, 4, 70, 38, 0, "StyleData", "Author", "Condensed"],
Cell[27757, 927, 115, 3, 70, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27909, 935, 132, 4, 70, 28, 0, "StyleData", "Copyright", "All"],
Cell[28044, 941, 119, 3, 70, 44, 0, "StyleData", "Copyright", \
"Presentation"],
Cell[28166, 946, 114, 3, 70, 41, 0, "StyleData", "Copyright", "Condensed"],
Cell[28283, 951, 89, 2, 70, 40, 0, "StyleData", "Copyright", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28409, 958, 191, 6, 70, 26, 0, "StyleData", "Example", "All",
  CounterIncrements->"Example"],
Cell[28603, 966, 146, 4, 70, 42, 0, "StyleData", "Example", "Presentation"],
Cell[28752, 972, 124, 3, 70, 39, 0, "StyleData", "Example", "Condensed"],
Cell[28879, 977, 100, 2, 70, 38, 0, "StyleData", "Example", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29016, 984, 405, 11, 70, 29, 0, "StyleData", "Definition", "All",
  CounterIncrements->"Definition"],
Cell[29424, 997, 193, 5, 70, 45, 0, "StyleData", "Definition", \
"Presentation"],
Cell[29620, 1004, 77, 1, 70, 42, 0, "StyleData", "Definition", "Condensed"],
Cell[29700, 1007, 126, 3, 70, 41, 0, "StyleData", "Definition", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29863, 1015, 403, 11, 70, 26, 0, "StyleData", "Theorem", "All",
  CounterIncrements->"Theorem"],
Cell[30269, 1028, 190, 5, 70, 42, 0, "StyleData", "Theorem", "Presentation"],
Cell[30462, 1035, 74, 1, 70, 39, 0, "StyleData", "Theorem", "Condensed"],
Cell[30539, 1038, 123, 3, 70, 38, 0, "StyleData", "Theorem", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30699, 1046, 454, 12, 70, 31, 0, "StyleData", "ExerciseMain", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[31156, 1060, 225, 6, 70, 47, 0, "StyleData", "ExerciseMain", \
"Presentation"],
Cell[31384, 1068, 102, 2, 70, 44, 0, "StyleData", "ExerciseMain", \
"Condensed"],
Cell[31489, 1072, 184, 5, 70, 43, 0, "StyleData", "ExerciseMain", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31710, 1082, 355, 10, 70, 27, 0, "StyleData", "Exercise", "All",
  CounterIncrements->"Subsubsection"],
Cell[32068, 1094, 119, 3, 70, 43, 0, "StyleData", "Exercise", \
"Presentation"],
Cell[32190, 1099, 99, 2, 70, 40, 0, "StyleData", "Exercise", "Condensed"],
Cell[32292, 1103, 191, 6, 70, 39, 0, "StyleData", "Exercise", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32520, 1114, 177, 5, 70, 31, 0, "StyleData", "ExerciseText", "All",
  CounterIncrements->"ExerciseText"],
Cell[32700, 1121, 151, 4, 70, 47, 0, "StyleData", "ExerciseText", \
"Presentation"],
Cell[32854, 1127, 130, 3, 70, 44, 0, "StyleData", "ExerciseText", \
"Condensed"],
Cell[32987, 1132, 126, 3, 70, 43, 0, "StyleData", "ExerciseText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33162, 1141, 43, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[33230, 1145, 397, 9, 70, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[33630, 1156, 102, 2, 70, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[33735, 1160, 98, 2, 70, 46, 0, "StyleData", "DisplayFormula", \
"Condensed"],
Cell[33836, 1164, 97, 2, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33970, 1171, 398, 10, 70, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[34371, 1183, 103, 2, 70, 50, 0, "StyleData", "ChemicalFormula", \
"Presentation"],
Cell[34477, 1187, 99, 2, 70, 47, 0, "StyleData", "ChemicalFormula", \
"Condensed"],
Cell[34579, 1191, 98, 2, 70, 46, 0, "StyleData", "ChemicalFormula", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34714, 1198, 147, 4, 70, 26, 0, "StyleData", "Program", "All"],
Cell[34864, 1204, 93, 2, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[34960, 1208, 98, 2, 70, 39, 0, "StyleData", "Program", "Condensed"],
Cell[35061, 1212, 96, 2, 70, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35206, 1220, 49, 0, 39, "Section"],
Cell[35258, 1222, 225, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[35508, 1230, 450, 9, 70, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[35961, 1241, 103, 2, 70, 51, 0, "StyleData", "NumberedEquation", \
"Presentation"],
Cell[36067, 1245, 99, 1, 70, 48, 0, "StyleData", "NumberedEquation", \
"Condensed"],
Cell[36169, 1248, 97, 1, 70, 47, 0, "StyleData", "NumberedEquation", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36303, 1254, 336, 7, 70, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[36642, 1263, 102, 2, 70, 49, 0, "StyleData", "NumberedFigure", \
"Presentation"],
Cell[36747, 1267, 46, 0, 70, 46, 0, "StyleData", "NumberedFigure", \
"Condensed"],
Cell[36796, 1269, 45, 0, 70, 45, 0, "StyleData", "NumberedFigure", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36878, 1274, 306, 7, 70, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[37187, 1283, 101, 2, 70, 48, 0, "StyleData", "NumberedTable", \
"Presentation"],
Cell[37291, 1287, 45, 0, 70, 45, 0, "StyleData", "NumberedTable", \
"Condensed"],
Cell[37339, 1289, 44, 0, 70, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37432, 1295, 49, 0, 39, "Section"],
Cell[37484, 1297, 149, 5, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[37636, 1304, 126, 4, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[37765, 1310, 152, 5, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[37954, 1320, 35, 0, 39, "Section"],
Cell[37992, 1322, 184, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[38201, 1330, 302, 8, 38, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[38506, 1340, 60, 1, 40, 44, 0, "StyleData", "Hyperlink", \
"Presentation"],
Cell[38569, 1343, 57, 1, 35, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[38629, 1346, 41, 0, 38, 41, 0, "StyleData", "Hyperlink", "SlideShow"],
Cell[38673, 1348, 123, 3, 35, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[38811, 1354, 104, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[38940, 1361, 293, 7, 38, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[39236, 1370, 63, 1, 40, 47, 0, "StyleData", "MainBookLink", \
"Presentation"],
Cell[39302, 1373, 60, 1, 35, 44, 0, "StyleData", "MainBookLink", \
"Condensed"],
Cell[39365, 1376, 44, 0, 38, 44, 0, "StyleData", "MainBookLink", \
"SlideShow"],
Cell[39412, 1378, 126, 3, 35, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39575, 1386, 314, 8, 37, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[39892, 1396, 61, 1, 40, 45, 0, "StyleData", "AddOnsLink", \
"Presentation"],
Cell[39956, 1399, 58, 1, 35, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[40017, 1402, 42, 0, 37, 42, 0, "StyleData", "AddOnsLink", "SlideShow"],
Cell[40062, 1404, 124, 3, 35, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40223, 1412, 318, 8, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[40544, 1422, 63, 1, 40, 47, 0, "StyleData", "RefGuideLink", \
"Presentation"],
Cell[40610, 1425, 60, 1, 35, 44, 0, "StyleData", "RefGuideLink", \
"Condensed"],
Cell[40673, 1428, 44, 0, 37, 44, 0, "StyleData", "RefGuideLink", \
"SlideShow"],
Cell[40720, 1430, 126, 3, 35, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40883, 1438, 297, 7, 38, 35, 0, "StyleData", "RefGuideLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[41183, 1447, 67, 1, 40, 51, 0, "StyleData", "RefGuideLinkText", \
"Presentation"],
Cell[41253, 1450, 64, 1, 35, 48, 0, "StyleData", "RefGuideLinkText", \
"Condensed"],
Cell[41320, 1453, 48, 0, 38, 48, 0, "StyleData", "RefGuideLinkText", \
"SlideShow"],
Cell[41371, 1455, 130, 3, 35, 47, 0, "StyleData", "RefGuideLinkText", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[41538, 1463, 305, 7, 38, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[41846, 1472, 69, 1, 40, 53, 0, "StyleData", "GettingStartedLink", \
"Presentation"],
Cell[41918, 1475, 66, 1, 35, 50, 0, "StyleData", "GettingStartedLink", \
"Condensed"],
Cell[41987, 1478, 50, 0, 38, 50, 0, "StyleData", "GettingStartedLink", \
"SlideShow"],
Cell[42040, 1480, 132, 3, 35, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42209, 1488, 287, 7, 38, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[42499, 1497, 41, 0, 38, 41, 0, "StyleData", "DemosLink", "SlideShow"],
Cell[42543, 1499, 107, 2, 38, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42687, 1506, 285, 7, 38, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[42975, 1515, 40, 0, 38, 40, 0, "StyleData", "TourLink", "SlideShow"],
Cell[43018, 1517, 106, 2, 38, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43161, 1524, 309, 7, 38, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[43473, 1533, 71, 1, 40, 55, 0, "StyleData", "OtherInformationLink", \
"Presentation"],
Cell[43547, 1536, 68, 1, 35, 52, 0, "StyleData", "OtherInformationLink", \
"Condensed"],
Cell[43618, 1539, 52, 0, 38, 52, 0, "StyleData", "OtherInformationLink", \
"SlideShow"],
Cell[43673, 1541, 134, 3, 35, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43844, 1549, 299, 7, 38, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[44146, 1558, 47, 0, 38, 47, 0, "StyleData", "MasterIndexLink", \
"SlideShow"],
Cell[44196, 1560, 113, 2, 38, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[44358, 1568, 33, 0, 39, "Section"],
Cell[44394, 1570, 121, 3, 70, "Text"],
Cell[44518, 1575, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[44747, 1582, 304, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[45054, 1591, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[45457, 1602, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[45847, 1613, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[46285, 1627, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[46346, 1631, 709, 21, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[47058, 1654, 57, 0, 70, 57, 0, "StyleData", "SlideShowNavigationBar", \
"Presentation"],
Cell[47118, 1656, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[47320, 1663, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[47483, 1671, 1566, 36, 70, 35, 0, "StyleData", "SlideShowSection", "All",
  
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[49052, 1709, 109, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[49164, 1713, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[49265, 1717, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[49424, 1725, 327, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[49754, 1737, 101, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[49858, 1741, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[49907, 1743, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[50072, 1751, 341, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[50416, 1762, 98, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[50517, 1766, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[50564, 1768, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[50711, 1775, 166, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[50880, 1781, 94, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[50977, 1785, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[51036, 1788, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

