(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     75573,       2763]*)
(*NotebookOutlinePosition[     76209,       2785]*)
(*  CellTagsIndexPosition[     76165,       2781]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
  CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->12],

Cell[StyleData[All, "Condensed"],
  PageWidth->WindowWidth,
  CellLabelMargins->{{8, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->8],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->5,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{27, Inherited}, {10, 30}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 11},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold"],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{27, 10}, {10, 30}},
  LineSpacing->{1, 0},
  FontSize->44],

Cell[StyleData["Title", "Condensed"],
  CellMargins->{{8, 10}, {4, 8}},
  FontSize->20],

Cell[StyleData["Title", "SlideShow"]],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{2, 10}, {12, 30}},
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{27, Inherited}, {20, 2}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{27, 10}, {20, 2}},
  LineSpacing->{1, 0},
  FontSize->36],

Cell[StyleData["Subtitle", "Condensed"],
  CellMargins->{{8, 10}, {4, 4}},
  FontSize->14],

Cell[StyleData["Subtitle", "SlideShow"]],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {12, 8}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{27, Inherited}, {8, 2}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->16],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{24, 10}, {20, 20}},
  LineSpacing->{1, 0},
  FontSize->24],

Cell[StyleData["Subsubtitle", "Condensed"],
  CellMargins->{{8, 10}, {8, 8}},
  FontSize->12],

Cell[StyleData["Subsubtitle", "SlideShow"]],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {12, 8}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0, 1}},
  CellMargins->{{27, Inherited}, {8, 34}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->4,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 2},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->20,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
  CellMargins->{{40, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->24],

Cell[StyleData["Section", "Condensed"],
  CellMargins->{{18, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Section", "SlideShow"]],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{2, 0}, {7, 22}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{60, Inherited}, {8, 12}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{36, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsection", "Condensed"],
  CellMargins->{{16, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "SlideShow"]],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {7, 22}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{60, Inherited}, {2, 10}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Subsubsection", "Condensed"],
  CellMargins->{{17, Inherited}, {6, 12}},
  FontSize->10],

Cell[StyleData["Subsubsection", "SlideShow"]],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{9, 0}, {7, 14}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{60, 10}, {7, 7}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 3},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["Text", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1},
  FontSize->11],

Cell[StyleData["Text", "SlideShow"]],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->0.5,
  Hyphenation->True,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{60, 10}, {6, 6}},
  DefaultNewInlineCellStyle->"None",
  LineSpacing->{1, 3},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"SmallText",
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->12],

Cell[StyleData["SmallText", "Condensed"],
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontSize->9],

Cell[StyleData["SmallText", "SlideShow"]],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  TextJustification->0.5,
  Hyphenation->True,
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{66, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Mathematica",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{72, Inherited}, {8, 10}},
  LineSpacing->{1, 0},
  FontSize->16],

Cell[StyleData["Input", "Condensed"],
  CellMargins->{{40, 10}, {2, 3}},
  FontSize->11],

Cell[StyleData["Input", "SlideShow"]],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellMargins->{{66, 10}, {7, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Mathematica",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["InputOnly", "Presentation"],
  CellMargins->{{72, Inherited}, {8, 10}},
  LineSpacing->{1, 0},
  FontSize->16],

Cell[StyleData["InputOnly", "Condensed"],
  CellMargins->{{40, 10}, {2, 3}},
  FontSize->11],

Cell[StyleData["InputOnly", "SlideShow"]],

Cell[StyleData["InputOnly", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{66, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->None,
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{72, Inherited}, {10, 8}},
  LineSpacing->{1, 0},
  FontSize->16],

Cell[StyleData["Output", "Condensed"],
  CellMargins->{{41, Inherited}, {3, 2}},
  FontSize->11],

Cell[StyleData["Output", "SlideShow"]],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{66, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->None,
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0.6, 0.100008, 0.100008]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0},
  FontSize->16],

Cell[StyleData["Message", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}},
  FontSize->11],

Cell[StyleData["Message", "SlideShow"]],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->7,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{66, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->None,
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0},
  FontSize->16],

Cell[StyleData["Print", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}},
  FontSize->11],

Cell[StyleData["Print", "SlideShow"]],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{4, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  LanguageCategory->None,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->10],

Cell[StyleData["Graphics", "Presentation"],
  ImageMargins->{{62, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Condensed"],
  ImageMargins->{{38, Inherited}, {Inherited, 0}},
  Magnification->0.6],

Cell[StyleData["Graphics", "SlideShow"]],

Cell[StyleData["Graphics", "Printout"],
  ImageMargins->{{30, Inherited}, {Inherited, 0}},
  Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  LanguageCategory->None,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0.269993, 0.308507, 0.6]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["CellLabel", "Condensed"],
  FontSize->9],

Cell[StyleData["CellLabel", "SlideShow"]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FrameLabel"],
  LanguageCategory->None,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["FrameLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["FrameLabel", "Condensed"],
  FontSize->9],

Cell[StyleData["FrameLabel", "SlideShow"]],

Cell[StyleData["FrameLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  ScriptLevel->1,
  SingleLetterItalics->True],

Cell[StyleData["InlineFormula", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["InlineFormula", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1},
  FontSize->11],

Cell[StyleData["InlineFormula", "SlideShow"]],

Cell[StyleData["InlineFormula", "Printout"],
  CellMargins->{{2, 0}, {6, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{60, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  ScriptLevel->0,
  SingleLetterItalics->True,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["DisplayFormula", "Condensed"],
  LineSpacing->{1, 1},
  FontSize->11],

Cell[StyleData["DisplayFormula", "SlideShow"]],

Cell[StyleData["DisplayFormula", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellFrame->{{0, 0}, {0.5, 0.5}},
  CellMargins->{{60, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  Hyphenation->False,
  LanguageCategory->"Formula",
  ScriptLevel->1,
  FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["Program", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1},
  FontSize->11],

Cell[StyleData["Program", "SlideShow"]],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{2, 0}, {6, 6}},
  FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
  CellMargins->{{60, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 50},
  ParagraphIndent->-38,
  CounterIncrements->"Outline1",
  CounterAssignments->{{"Outline2", 0}, {"Outline3", 0}, {"Outline4", 0}},
  FontSize->18,
  FontWeight->"Bold",
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "SlideShow"]],

Cell[StyleData["Outline1", "Printout"],
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
  CellMargins->{{90, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 60},
  ParagraphIndent->-27,
  CounterIncrements->"Outline2",
  CounterAssignments->{{"Outline3", 0}, {"Outline4", 0}},
  FontSize->15,
  FontWeight->"Bold",
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)}],

Cell[StyleData["Outline2", "SlideShow"]],

Cell[StyleData["Outline2", "Printout"],
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
  CellMargins->{{120, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 70},
  ParagraphIndent->-21,
  CounterIncrements->"Outline3",
  CounterAssignments->{{"Outline4", 0}},
  FontSize->12,
  CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "SlideShow"]],

Cell[StyleData["Outline3", "Printout"],
  CounterBoxOptions->{CounterFunction:>Identity}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
  CellMargins->{{150, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 80},
  ParagraphIndent->-18,
  CounterIncrements->"Outline4",
  FontSize->10,
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "a", "z"], #]&)}],

Cell[StyleData["Outline4", "SlideShow"]],

Cell[StyleData["Outline4", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"],
  FontSize->16],

Cell[StyleData["Hyperlink", "Condensed"],
  FontSize->11],

Cell[StyleData["Hyperlink", "SlideShow"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"],
  FontSize->16],

Cell[StyleData["MainBookLink", "Condensed"],
  FontSize->11],

Cell[StyleData["MainBookLink", "SlideShow"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"],
  FontSize->16],

Cell[StyleData["AddOnsLink", "Condensed"],
  FontSize->11],

Cell[StyleData["AddOnsLink", "SlideShow"]],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLink", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLink", "SlideShow"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLinkText", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLinkText", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLinkText", "SlideShow"]],

Cell[StyleData["RefGuideLinkText", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"],
  FontSize->16],

Cell[StyleData["GettingStartedLink", "Condensed"],
  FontSize->11],

Cell[StyleData["GettingStartedLink", "SlideShow"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "SlideShow"]],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "SlideShow"]],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"],
  FontSize->16],

Cell[StyleData["OtherInformationLink", "Condensed"],
  FontSize->11],

Cell[StyleData["OtherInformationLink", "SlideShow"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "SlideShow"]],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  DefaultNewInlineCellStyle->"None",
  LanguageCategory->"NaturalLanguage",
  StyleMenuListing->None,
  FontSize->10,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  DefaultNewInlineCellStyle->"None",
  LanguageCategory->"NaturalLanguage",
  StyleMenuListing->None,
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, Placeholder]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Placeholder->True,
  StyleMenuListing->None,
  FontSlant->"Italic",
  FontColor->RGBColor[0.890623, 0.864698, 0.384756],
  TagBoxOptions->{Editable->False,
  Selectable->False,
  StripWrapperBoxes->False}],

Cell[StyleData["Placeholder", "Presentation"]],

Cell[StyleData["Placeholder", "Condensed"]],

Cell[StyleData["Placeholder", "SlideShow"]],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PrimaryPlaceholder"],
  StyleMenuListing->None,
  DrawHighlighted->True,
  FontSlant->"Italic",
  Background->RGBColor[0.912505, 0.891798, 0.507774],
  TagBoxOptions->{Editable->False,
  Selectable->False,
  StripWrapperBoxes->False}],

Cell[StyleData["PrimaryPlaceholder", "Presentation"]],

Cell[StyleData["PrimaryPlaceholder", "Condensed"]],

Cell[StyleData["PrimaryPlaceholder", "SlideShow"]],

Cell[StyleData["PrimaryPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  Hyphenation->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  InputAutoReplacements->{},
  AllowInlineCells->False,
  Hyphenation->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{0.6, 1},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
  InputAutoReplacements->{
    "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
      ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
      Inherited},
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  InputAutoReplacements->{
    "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
      ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
      Inherited},
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  LanguageCategory->"Formula",
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216]]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic Styles", "Section"],

Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],

Cell[StyleData["UnmatchedBracket"],
  StyleMenuListing->None,
  FontColor->RGBColor[0.760006, 0.330007, 0.8]],

Cell[StyleData["Completions"],
  StyleMenuListing->None,
  FontFamily->"Courier"]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles from HelpBrowser", "Section"],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{66, 12}, {2, 24}},
  PageBreakBelow->False,
  CellFrameMargins->{{8, 8}, {8, 2}},
  CellFrameColor->GrayLevel[0.700008],
  CellFrameLabelMargins->4,
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None,
  FontColor->GrayLevel[0.2]],

Cell[StyleData["MathCaption", "Presentation"],
  FontSize->18],

Cell[StyleData["MathCaption", "SlideShow"]],

Cell[StyleData["MathCaption", "Printout"],
  CellMargins->{{39, 0}, {0, 14}},
  Hyphenation->True,
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ObjectName"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {8, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Mathematica",
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["ObjectName", "Presentation"],
  FontSize->18],

Cell[StyleData["ObjectName", "SlideShow"]],

Cell[StyleData["ObjectName", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Usage"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {8, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Mathematica",
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["Usage", "Presentation"],
  FontSize->18],

Cell[StyleData["Usage", "SlideShow"]],

Cell[StyleData["Usage", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Notes"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {8, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Mathematica",
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["Notes", "Presentation"],
  FontSize->18],

Cell[StyleData["Notes", "SlideShow"]],

Cell[StyleData["Notes", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineOutput"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {8, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Mathematica",
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["InlineOutput", "Presentation"],
  FontSize->18],

Cell[StyleData["InlineOutput", "SlideShow"]],

Cell[StyleData["InlineOutput", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Emphasis Boxes and Pictures", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Box"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["Box", "Presentation"],
  FontSize->18],

Cell[StyleData["Box", "SlideShow"]],

Cell[StyleData["Box", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->2,
  RowAlignments->Top}],

Cell[StyleData["DoubleBox", "Presentation"],
  FontSize->18],

Cell[StyleData["DoubleBox", "SlideShow"]],

Cell[StyleData["DoubleBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["1ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["1ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["1ColumnBox", "SlideShow"]],

Cell[StyleData["1ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  SingleLetterItalics->False,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->{0.31, 0.67}}],

Cell[StyleData["2ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnBox", "SlideShow"]],

Cell[StyleData["2ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->0.46}],

Cell[StyleData["2ColumnEvenBox", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnEvenBox", "SlideShow"]],

Cell[StyleData["2ColumnEvenBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnSmallBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.35,
  ColumnAlignments->{Right, Left}}],

Cell[StyleData["2ColumnSmallBox", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnSmallBox", "SlideShow"]],

Cell[StyleData["2ColumnSmallBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->0.32}],

Cell[StyleData["3ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["3ColumnBox", "SlideShow"]],

Cell[StyleData["3ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnSmallBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.24,
  ColumnAlignments->{Right, Center, Left}}],

Cell[StyleData["3ColumnSmallBox", "Presentation"],
  FontSize->18],

Cell[StyleData["3ColumnSmallBox", "SlideShow"]],

Cell[StyleData["3ColumnSmallBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  SingleLetterItalics->False,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->{0.13, 0.35, 0.13, 0.35}}],

Cell[StyleData["4ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["4ColumnBox", "SlideShow"]],

Cell[StyleData["4ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->0.202}],

Cell[StyleData["5ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["5ColumnBox", "SlideShow"]],

Cell[StyleData["5ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],

Cell[StyleData["6ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["6ColumnBox", "SlideShow"]],

Cell[StyleData["6ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FramedBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnAlignments->{Left}}],

Cell[StyleData["FramedBox", "Presentation"],
  FontSize->18],

Cell[StyleData["FramedBox", "SlideShow"]],

Cell[StyleData["FramedBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox", "SlideShow"]],

Cell[StyleData["DefinitionBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox3Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.35, 0.2, 0.45},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox3Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox3Col", "SlideShow"]],

Cell[StyleData["DefinitionBox3Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox4Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.15, 0.35, 0.15, 0.35},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox4Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox4Col", "SlideShow"]],

Cell[StyleData["DefinitionBox4Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox5Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->0.2,
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox5Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox5Col", "SlideShow"]],

Cell[StyleData["DefinitionBox5Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox6Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox6Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox6Col", "SlideShow"]],

Cell[StyleData["DefinitionBox6Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopBox", "Presentation"],
  FontSize->18],

Cell[StyleData["TopBox", "SlideShow"]],

Cell[StyleData["TopBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{27, 12}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleBox", "Presentation"],
  FontSize->18],

Cell[StyleData["MiddleBox", "SlideShow"]],

Cell[StyleData["MiddleBox", "Printout"],
  CellMargins->{{2, 0}, {0, 2}},
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BottomBox"],
  CellFrame->{{0.5, 0.5}, {0.5, 0}},
  CellMargins->{{27, 12}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["BottomBox", "Presentation"],
  FontSize->18],

Cell[StyleData["BottomBox", "SlideShow"]],

Cell[StyleData["BottomBox", "Printout"],
  CellMargins->{{2, 0}, {0, -5}},
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->2.2}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{27, 12}, {-2, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopSpanBox", "Presentation"],
  FontSize->18],

Cell[StyleData["TopSpanBox", "SlideShow"]],

Cell[StyleData["TopSpanBox", "Printout"],
  CellMargins->{{2, 0}, {-2, 8}},
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{27, 12}, {0, 0}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleSpanBox", "Presentation"],
  FontSize->18],

Cell[StyleData["MiddleSpanBox", "SlideShow"]],

Cell[StyleData["MiddleSpanBox", "Printout"],
  CellMargins->{{2, 0}, {-5, 0}},
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
  CellMargins->{{27, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["Picture", "Presentation"],
  FontSize->18],

Cell[StyleData["Picture", "SlideShow"]],

Cell[StyleData["Picture", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.65]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OpenCloseItemizedPicture"],
  CellMargins->{{88, 4}, {4, 4}},
  PrivateCellOptions->{"DefaultCellGroupOpen"->False},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["OpenCloseItemizedPicture", "Presentation"],
  FontSize->18],

Cell[StyleData["OpenCloseItemizedPicture", "SlideShow"]],

Cell[StyleData["OpenCloseItemizedPicture", "Printout"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedPicture"],
  CellMargins->{{88, 4}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemizedPicture", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedPicture", "SlideShow"]],

Cell[StyleData["ItemizedPicture", "Printout"],
  CellMargins->{{77, 2}, {4, -4}},
  Magnification->0.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListGraphic"],
  CellMargins->{{88, 4}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ListGraphic", "Presentation"],
  FontSize->18],

Cell[StyleData["ListGraphic", "SlideShow"]],

Cell[StyleData["ListGraphic", "Printout"],
  CellMargins->{{77, 2}, {4, -4}},
  Magnification->0.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListNoteBox"],
  CellFrame->0.5,
  CellMargins->{{88, 12}, {8, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["ListNoteBox", "Presentation"],
  FontSize->18],

Cell[StyleData["ListNoteBox", "SlideShow"]],

Cell[StyleData["ListNoteBox", "Printout"],
  CellMargins->{{77, 4}, {6, 2}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellMargins->{{41, 4}, {0, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureGroup", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureGroup", "SlideShow"]],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Sound"],
  ShowCellBracket->True,
  CellMargins->{{27, Inherited}, {0, 8}},
  StyleMenuListing->None],

Cell[StyleData["Sound", "Presentation"],
  FontSize->18],

Cell[StyleData["Sound", "SlideShow"]],

Cell[StyleData["Sound", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
  CellMargins->{{35, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->{0.34, 0.64},
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnTable", "SlideShow"]],

Cell[StyleData["2ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenTable"],
  CellMargins->{{35, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.49,
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnEvenTable", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnEvenTable", "SlideShow"]],

Cell[StyleData["2ColumnEvenTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
  CellMargins->{{35, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["3ColumnTable", "SlideShow"]],

Cell[StyleData["3ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "Presentation"]],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  CellFrameMargins->{{20, 10}, {10, 18}},
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
  CellMargins->{{14, 10}, {6, 12}},
  FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
  CellMargins->{{35, 10}, {8, 8}},
  FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
  CellMargins->{{25, 10}, {10, 5}},
  FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
WindowSize->{500, 500},
WindowMargins->{{1, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 88, "Title"],
Cell[1813, 55, 193, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[2031, 63, 42, 0, 69, "Section"],
Cell[2076, 65, 208, 4, 38, 31, 0, "StyleData", "All", "Working"],
Cell[2287, 71, 146, 3, 38, 36, 0, "StyleData", "All", "Presentation"],
Cell[2436, 76, 141, 3, 38, 33, 0, "StyleData", "All", "Condensed"],
Cell[2580, 81, 182, 5, 38, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2765, 88, 186, 4, 36, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2988, 97, 35, 0, 39, "Section"],
Cell[3026, 99, 101, 3, 32, "Text"],
Cell[3130, 104, 426, 11, 38, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3593, 120, 38, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[3656, 124, 1664, 39, 92, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[5323, 165, 116, 3, 100, 40, 0, "StyleData", "Title", "Presentation"],
Cell[5442, 170, 87, 2, 48, 37, 0, "StyleData", "Title", "Condensed"],
Cell[5532, 174, 37, 0, 92, 37, 0, "StyleData", "Title", "SlideShow"],
Cell[5572, 176, 88, 2, 87, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5697, 183, 1607, 37, 68, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[7307, 222, 118, 3, 74, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[7428, 227, 90, 2, 40, 40, 0, "StyleData", "Subtitle", "Condensed"],
Cell[7521, 231, 40, 0, 66, 40, 0, "StyleData", "Subtitle", "SlideShow"],
Cell[7564, 233, 90, 2, 57, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7691, 240, 1585, 36, 44, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[9279, 278, 122, 3, 84, 46, 0, "StyleData", "Subsubtitle", \
"Presentation"],
Cell[9404, 283, 93, 2, 46, 43, 0, "StyleData", "Subsubtitle", "Condensed"],
Cell[9500, 287, 43, 0, 42, 43, 0, "StyleData", "Subsubtitle", "SlideShow"],
Cell[9546, 289, 93, 2, 52, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9676, 296, 1672, 40, 53, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[11351, 338, 118, 3, 93, 42, 0, "StyleData", "Section", "Presentation"],
Cell[11472, 343, 98, 2, 53, 39, 0, "StyleData", "Section", "Condensed"],
Cell[11573, 347, 39, 0, 83, 39, 0, "StyleData", "Section", "SlideShow"],
Cell[11615, 349, 88, 2, 66, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11740, 356, 1621, 38, 44, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[13364, 396, 121, 3, 81, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[13488, 401, 101, 2, 48, 42, 0, "StyleData", "Subsection", "Condensed"],
Cell[13592, 405, 42, 0, 52, 42, 0, "StyleData", "Subsection", "SlideShow"],
Cell[13637, 407, 91, 2, 59, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13765, 414, 1561, 36, 36, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[15329, 452, 124, 3, 74, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[15456, 457, 104, 2, 45, 45, 0, "StyleData", "Subsubsection", \
"Condensed"],
Cell[15563, 461, 45, 0, 42, 45, 0, "StyleData", "Subsubsection", \
"SlideShow"],
Cell[15611, 463, 94, 2, 48, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15754, 471, 39, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[15818, 475, 1327, 30, 44, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[17148, 507, 115, 3, 52, 39, 0, "StyleData", "Text", "Presentation"],
Cell[17266, 512, 109, 3, 39, 36, 0, "StyleData", "Text", "Condensed"],
Cell[17378, 517, 36, 0, 44, 36, 0, "StyleData", "Text", "SlideShow"],
Cell[17417, 519, 131, 4, 39, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[17585, 528, 238, 7, 36, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[17826, 537, 118, 3, 46, 44, 0, "StyleData", "SmallText", \
"Presentation"],
Cell[17947, 542, 113, 3, 36, 41, 0, "StyleData", "SmallText", "Condensed"],
Cell[18063, 547, 41, 0, 38, 41, 0, "StyleData", "SmallText", "SlideShow"],
Cell[18107, 549, 135, 4, 33, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18291, 559, 42, 0, 39, "Section"],
Cell[18336, 561, 364, 6, 86, "Text"],

Cell[CellGroupData[{
Cell[18725, 571, 600, 17, 42, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[19328, 590, 122, 3, 50, 40, 0, "StyleData", "Input", "Presentation"],
Cell[19453, 595, 88, 2, 32, 37, 0, "StyleData", "Input", "Condensed"],
Cell[19544, 599, 37, 0, 42, 37, 0, "StyleData", "Input", "SlideShow"],
Cell[19584, 601, 130, 3, 36, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19751, 609, 573, 16, 41, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input",
  StyleMenuListing->None],
Cell[20327, 627, 126, 3, 50, 44, 0, "StyleData", "InputOnly", \
"Presentation"],
Cell[20456, 632, 92, 2, 32, 41, 0, "StyleData", "InputOnly", "Condensed"],
Cell[20551, 636, 41, 0, 44, 41, 0, "StyleData", "InputOnly", "SlideShow"],
Cell[20595, 638, 134, 3, 36, 40, 0, "StyleData", "InputOnly", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20766, 646, 533, 15, 41, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[21302, 663, 123, 3, 50, 41, 0, "StyleData", "Output", "Presentation"],
Cell[21428, 668, 96, 2, 32, 38, 0, "StyleData", "Output", "Condensed"],
Cell[21527, 672, 38, 0, 42, 38, 0, "StyleData", "Output", "SlideShow"],
Cell[21568, 674, 86, 2, 36, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21691, 681, 692, 19, 35, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[22386, 702, 139, 3, 40, 42, 0, "StyleData", "Message", "Presentation"],
Cell[22528, 707, 113, 2, 35, 39, 0, "StyleData", "Message", "Condensed"],
Cell[22644, 711, 39, 0, 35, 39, 0, "StyleData", "Message", "SlideShow"],
Cell[22686, 713, 138, 3, 31, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22861, 721, 577, 16, 38, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[23441, 739, 137, 3, 40, 40, 0, "StyleData", "Print", "Presentation"],
Cell[23581, 744, 111, 2, 35, 37, 0, "StyleData", "Print", "Condensed"],
Cell[23695, 748, 37, 0, 38, 37, 0, "StyleData", "Print", "SlideShow"],
Cell[23735, 750, 109, 2, 32, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23881, 757, 506, 15, 35, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[24390, 774, 94, 1, 35, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[24487, 777, 113, 2, 26, 40, 0, "StyleData", "Graphics", "Condensed"],
Cell[24603, 781, 40, 0, 35, 40, 0, "StyleData", "Graphics", "SlideShow"],
Cell[24646, 783, 112, 2, 30, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24795, 790, 170, 5, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[24968, 797, 60, 1, 38, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[25031, 800, 56, 1, 34, 41, 0, "StyleData", "CellLabel", "Condensed"],
Cell[25090, 803, 41, 0, 34, 41, 0, "StyleData", "CellLabel", "SlideShow"],
Cell[25134, 805, 130, 4, 32, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25301, 814, 123, 4, 34, 29, 0, "StyleData", "FrameLabel", "All",
  StyleMenuListing->None],
Cell[25427, 820, 61, 1, 38, 45, 0, "StyleData", "FrameLabel", \
"Presentation"],
Cell[25491, 823, 57, 1, 34, 42, 0, "StyleData", "FrameLabel", "Condensed"],
Cell[25551, 826, 42, 0, 34, 42, 0, "StyleData", "FrameLabel", "SlideShow"],
Cell[25596, 828, 131, 4, 32, 41, 0, "StyleData", "FrameLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[25776, 838, 36, 0, 39, "Section"],
Cell[25815, 840, 121, 3, 50, "Text"],
Cell[25939, 845, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[26034, 850, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[26106, 854, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[26179, 858, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[26297, 864, 116, 4, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[26416, 870, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[26533, 876, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[26652, 882, 233, 6, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[26888, 890, 234, 6, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[27125, 898, 232, 6, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[27360, 906, 234, 6, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[27597, 914, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[27719, 920, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[27842, 926, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[27963, 932, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[28108, 940, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[28249, 947, 149, 5, 31, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[28435, 957, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[28542, 961, 90, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28681, 969, 43, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[28749, 973, 244, 6, 38, 32, 0, "StyleData", "InlineFormula", "All"],
Cell[28996, 981, 124, 3, 52, 48, 0, "StyleData", "InlineFormula", \
"Presentation"],
Cell[29123, 986, 118, 3, 39, 45, 0, "StyleData", "InlineFormula", \
"Condensed"],
Cell[29244, 991, 45, 0, 38, 45, 0, "StyleData", "InlineFormula", \
"SlideShow"],
Cell[29292, 993, 93, 2, 39, 44, 0, "StyleData", "InlineFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29422, 1000, 370, 8, 38, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[29795, 1010, 88, 2, 40, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[29886, 1014, 85, 2, 35, 46, 0, "StyleData", "DisplayFormula", \
"Condensed"],
Cell[29974, 1018, 46, 0, 38, 46, 0, "StyleData", "DisplayFormula", \
"SlideShow"],
Cell[30023, 1020, 61, 1, 35, 45, 0, "StyleData", "DisplayFormula", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30121, 1026, 224, 7, 50, 26, 0, "StyleData", "Program", "All"],
Cell[30348, 1035, 118, 3, 69, 42, 0, "StyleData", "Program", "Presentation"],
Cell[30469, 1040, 112, 3, 56, 39, 0, "StyleData", "Program", "Condensed"],
Cell[30584, 1045, 39, 0, 54, 39, 0, "StyleData", "Program", "SlideShow"],
Cell[30626, 1047, 86, 2, 55, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30761, 1055, 33, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[30819, 1059, 339, 8, 51, 27, 0, "StyleData", "Outline1", "All",
  CounterIncrements->"Outline1",
  CounterAssignments->{{"Outline2", 0}, {"Outline3", 0}, {"Outline4", 0}}],
Cell[31161, 1069, 40, 0, 51, 40, 0, "StyleData", "Outline1", "SlideShow"],
Cell[31204, 1071, 100, 1, 51, 39, 0, "StyleData", "Outline1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31341, 1077, 348, 9, 42, 27, 0, "StyleData", "Outline2", "All",
  CounterIncrements->"Outline2",
  CounterAssignments->{{"Outline3", 0}, {"Outline4", 0}}],
Cell[31692, 1088, 40, 0, 45, 40, 0, "StyleData", "Outline2", "SlideShow"],
Cell[31735, 1090, 126, 2, 45, 39, 0, "StyleData", "Outline2", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31898, 1097, 273, 7, 41, 27, 0, "StyleData", "Outline3", "All",
  CounterIncrements->"Outline3",
  CounterAssignments->{{"Outline4", 0}}],
Cell[32174, 1106, 40, 0, 44, 40, 0, "StyleData", "Outline3", "SlideShow"],
Cell[32217, 1108, 89, 1, 44, 39, 0, "StyleData", "Outline3", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32343, 1114, 269, 7, 38, 27, 0, "StyleData", "Outline4", "All",
  CounterIncrements->"Outline4"],
Cell[32615, 1123, 40, 0, 70, 40, 0, "StyleData", "Outline4", "SlideShow"],
Cell[32658, 1125, 39, 0, 70, 39, 0, "StyleData", "Outline4", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[32746, 1131, 35, 0, 39, "Section"],
Cell[32784, 1133, 184, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[32993, 1141, 302, 8, 38, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[33298, 1151, 60, 1, 40, 44, 0, "StyleData", "Hyperlink", \
"Presentation"],
Cell[33361, 1154, 57, 1, 35, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[33421, 1157, 41, 0, 38, 41, 0, "StyleData", "Hyperlink", "SlideShow"],
Cell[33465, 1159, 123, 3, 35, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[33603, 1165, 104, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[33732, 1172, 293, 7, 38, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34028, 1181, 63, 1, 40, 47, 0, "StyleData", "MainBookLink", \
"Presentation"],
Cell[34094, 1184, 60, 1, 35, 44, 0, "StyleData", "MainBookLink", \
"Condensed"],
Cell[34157, 1187, 44, 0, 38, 44, 0, "StyleData", "MainBookLink", \
"SlideShow"],
Cell[34204, 1189, 126, 3, 35, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34367, 1197, 314, 8, 37, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34684, 1207, 61, 1, 40, 45, 0, "StyleData", "AddOnsLink", \
"Presentation"],
Cell[34748, 1210, 58, 1, 35, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[34809, 1213, 42, 0, 37, 42, 0, "StyleData", "AddOnsLink", "SlideShow"],
Cell[34854, 1215, 124, 3, 35, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[35015, 1223, 318, 8, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35336, 1233, 63, 1, 40, 47, 0, "StyleData", "RefGuideLink", \
"Presentation"],
Cell[35402, 1236, 60, 1, 35, 44, 0, "StyleData", "RefGuideLink", \
"Condensed"],
Cell[35465, 1239, 44, 0, 37, 44, 0, "StyleData", "RefGuideLink", \
"SlideShow"],
Cell[35512, 1241, 126, 3, 35, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[35675, 1249, 297, 7, 38, 35, 0, "StyleData", "RefGuideLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35975, 1258, 67, 1, 40, 51, 0, "StyleData", "RefGuideLinkText", \
"Presentation"],
Cell[36045, 1261, 64, 1, 35, 48, 0, "StyleData", "RefGuideLinkText", \
"Condensed"],
Cell[36112, 1264, 48, 0, 38, 48, 0, "StyleData", "RefGuideLinkText", \
"SlideShow"],
Cell[36163, 1266, 130, 3, 35, 47, 0, "StyleData", "RefGuideLinkText", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36330, 1274, 305, 7, 38, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[36638, 1283, 69, 1, 40, 53, 0, "StyleData", "GettingStartedLink", \
"Presentation"],
Cell[36710, 1286, 66, 1, 35, 50, 0, "StyleData", "GettingStartedLink", \
"Condensed"],
Cell[36779, 1289, 50, 0, 38, 50, 0, "StyleData", "GettingStartedLink", \
"SlideShow"],
Cell[36832, 1291, 132, 3, 35, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37001, 1299, 287, 7, 38, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[37291, 1308, 41, 0, 38, 41, 0, "StyleData", "DemosLink", "SlideShow"],
Cell[37335, 1310, 107, 2, 38, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37479, 1317, 285, 7, 38, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[37767, 1326, 40, 0, 38, 40, 0, "StyleData", "TourLink", "SlideShow"],
Cell[37810, 1328, 106, 2, 38, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37953, 1335, 309, 7, 38, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[38265, 1344, 71, 1, 40, 55, 0, "StyleData", "OtherInformationLink", \
"Presentation"],
Cell[38339, 1347, 68, 1, 35, 52, 0, "StyleData", "OtherInformationLink", \
"Condensed"],
Cell[38410, 1350, 52, 0, 38, 52, 0, "StyleData", "OtherInformationLink", \
"SlideShow"],
Cell[38465, 1352, 134, 3, 35, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38636, 1360, 299, 7, 38, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[38938, 1369, 47, 0, 38, 47, 0, "StyleData", "MasterIndexLink", \
"SlideShow"],
Cell[38988, 1371, 113, 2, 38, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39150, 1379, 49, 0, 39, "Section"],
Cell[39202, 1381, 199, 6, 32, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[39404, 1389, 198, 6, 30, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[39605, 1397, 127, 4, 32, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[39769, 1406, 33, 0, 39, "Section"],
Cell[39805, 1408, 121, 3, 50, "Text"],
Cell[39929, 1413, 232, 5, 38, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[40164, 1420, 304, 7, 38, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[40471, 1429, 400, 9, 38, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[40874, 1440, 387, 9, 38, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[41264, 1451, 401, 9, 38, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[41702, 1465, 37, 0, 39, "Section"],
Cell[41742, 1467, 115, 3, 50, "Text"],

Cell[CellGroupData[{
Cell[41882, 1474, 238, 7, 38, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[42123, 1483, 46, 0, 38, 46, 0, "StyleData", "Placeholder", \
"Presentation"],
Cell[42172, 1485, 43, 0, 38, 43, 0, "StyleData", "Placeholder", "Condensed"],
Cell[42218, 1487, 43, 0, 38, 43, 0, "StyleData", "Placeholder", "SlideShow"],
Cell[42264, 1489, 42, 0, 38, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42343, 1494, 250, 7, 54, 37, 0, "StyleData", "PrimaryPlaceholder", "All",
  
  StyleMenuListing->None],
Cell[42596, 1503, 53, 0, 54, 53, 0, "StyleData", "PrimaryPlaceholder", \
"Presentation"],
Cell[42652, 1505, 50, 0, 54, 50, 0, "StyleData", "PrimaryPlaceholder", \
"Condensed"],
Cell[42705, 1507, 50, 0, 54, 50, 0, "StyleData", "PrimaryPlaceholder", \
"SlideShow"],
Cell[42758, 1509, 49, 0, 54, 49, 0, "StyleData", "PrimaryPlaceholder", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[42856, 1515, 36, 0, 39, "Section"],
Cell[42895, 1517, 305, 5, 86, "Text"],
Cell[43203, 1524, 336, 11, 37, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[43542, 1537, 157, 5, 37, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[43702, 1544, 151, 5, 37, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[43856, 1551, 341, 8, 37, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[44200, 1561, 412, 10, 38, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[44615, 1573, 115, 3, 50, "Text"],
Cell[44733, 1578, 104, 3, 38, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[44840, 1583, 116, 2, 54, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[44993, 1590, 35, 0, 39, "Section"],
Cell[45031, 1592, 330, 6, 86, "Text"],
Cell[45364, 1600, 109, 2, 38, 35, 0, "StyleData", "UnmatchedBracket", "All",
  StyleMenuListing->None],
Cell[45476, 1604, 81, 2, 37, 30, 0, "StyleData", "Completions", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[45594, 1611, 42, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[45661, 1615, 335, 10, 58, 30, 0, "StyleData", "MathCaption", "All",
  StyleMenuListing->None],
Cell[45999, 1627, 62, 1, 64, 46, 0, "StyleData", "MathCaption", \
"Presentation"],
Cell[46064, 1630, 43, 0, 58, 43, 0, "StyleData", "MathCaption", "SlideShow"],
Cell[46110, 1632, 140, 4, 42, 42, 0, "StyleData", "MathCaption", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[46287, 1641, 656, 18, 42, 29, 0, "StyleData", "ObjectName", "All",
  StyleMenuListing->None],
Cell[46946, 1661, 61, 1, 53, 45, 0, "StyleData", "ObjectName", \
"Presentation"],
Cell[47010, 1664, 42, 0, 46, 42, 0, "StyleData", "ObjectName", "SlideShow"],
Cell[47055, 1666, 116, 3, 38, 41, 0, "StyleData", "ObjectName", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[47208, 1674, 651, 18, 42, 24, 0, "StyleData", "Usage", "All",
  StyleMenuListing->None],
Cell[47862, 1694, 56, 1, 53, 40, 0, "StyleData", "Usage", "Presentation"],
Cell[47921, 1697, 37, 0, 46, 37, 0, "StyleData", "Usage", "SlideShow"],
Cell[47961, 1699, 111, 3, 38, 36, 0, "StyleData", "Usage", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[48109, 1707, 651, 18, 42, 24, 0, "StyleData", "Notes", "All",
  StyleMenuListing->None],
Cell[48763, 1727, 56, 1, 53, 40, 0, "StyleData", "Notes", "Presentation"],
Cell[48822, 1730, 37, 0, 46, 37, 0, "StyleData", "Notes", "SlideShow"],
Cell[48862, 1732, 111, 3, 38, 36, 0, "StyleData", "Notes", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[49010, 1740, 658, 18, 42, 31, 0, "StyleData", "InlineOutput", "All",
  StyleMenuListing->None],
Cell[49671, 1760, 63, 1, 53, 47, 0, "StyleData", "InlineOutput", \
"Presentation"],
Cell[49737, 1763, 44, 0, 46, 44, 0, "StyleData", "InlineOutput", \
"SlideShow"],
Cell[49784, 1765, 118, 3, 38, 43, 0, "StyleData", "InlineOutput", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[49939, 1773, 49, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[50013, 1777, 340, 9, 55, 22, 0, "StyleData", "Box", "All",
  StyleMenuListing->None],
Cell[50356, 1788, 54, 1, 61, 38, 0, "StyleData", "Box", "Presentation"],
Cell[50413, 1791, 35, 0, 55, 35, 0, "StyleData", "Box", "SlideShow"],
Cell[50451, 1793, 118, 3, 52, 34, 0, "StyleData", "Box", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[50606, 1801, 368, 10, 55, 28, 0, "StyleData", "DoubleBox", "All",
  StyleMenuListing->None],
Cell[50977, 1813, 60, 1, 61, 44, 0, "StyleData", "DoubleBox", \
"Presentation"],
Cell[51040, 1816, 41, 0, 55, 41, 0, "StyleData", "DoubleBox", "SlideShow"],
Cell[51084, 1818, 124, 3, 52, 40, 0, "StyleData", "DoubleBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[51245, 1826, 364, 10, 55, 29, 0, "StyleData", "1ColumnBox", "All",
  StyleMenuListing->None],
Cell[51612, 1838, 61, 1, 70, 45, 0, "StyleData", "1ColumnBox", \
"Presentation"],
Cell[51676, 1841, 42, 0, 70, 42, 0, "StyleData", "1ColumnBox", "SlideShow"],
Cell[51721, 1843, 125, 3, 70, 41, 0, "StyleData", "1ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[51883, 1851, 403, 11, 70, 29, 0, "StyleData", "2ColumnBox", "All",
  StyleMenuListing->None],
Cell[52289, 1864, 61, 1, 70, 45, 0, "StyleData", "2ColumnBox", \
"Presentation"],
Cell[52353, 1867, 42, 0, 70, 42, 0, "StyleData", "2ColumnBox", "SlideShow"],
Cell[52398, 1869, 124, 3, 70, 41, 0, "StyleData", "2ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[52559, 1877, 369, 10, 70, 33, 0, "StyleData", "2ColumnEvenBox", "All",
  StyleMenuListing->None],
Cell[52931, 1889, 65, 1, 70, 49, 0, "StyleData", "2ColumnEvenBox", \
"Presentation"],
Cell[52999, 1892, 46, 0, 70, 46, 0, "StyleData", "2ColumnEvenBox", \
"SlideShow"],
Cell[53048, 1894, 129, 3, 70, 45, 0, "StyleData", "2ColumnEvenBox", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[53214, 1902, 428, 12, 70, 34, 0, "StyleData", "2ColumnSmallBox", "All",
  StyleMenuListing->None],
Cell[53645, 1916, 66, 1, 70, 50, 0, "StyleData", "2ColumnSmallBox", \
"Presentation"],
Cell[53714, 1919, 47, 0, 70, 47, 0, "StyleData", "2ColumnSmallBox", \
"SlideShow"],
Cell[53764, 1921, 130, 3, 70, 46, 0, "StyleData", "2ColumnSmallBox", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[53931, 1929, 365, 10, 70, 29, 0, "StyleData", "3ColumnBox", "All",
  StyleMenuListing->None],
Cell[54299, 1941, 61, 1, 70, 45, 0, "StyleData", "3ColumnBox", \
"Presentation"],
Cell[54363, 1944, 42, 0, 70, 42, 0, "StyleData", "3ColumnBox", "SlideShow"],
Cell[54408, 1946, 125, 3, 70, 41, 0, "StyleData", "3ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[54570, 1954, 436, 12, 70, 34, 0, "StyleData", "3ColumnSmallBox", "All",
  StyleMenuListing->None],
Cell[55009, 1968, 66, 1, 70, 50, 0, "StyleData", "3ColumnSmallBox", \
"Presentation"],
Cell[55078, 1971, 47, 0, 70, 47, 0, "StyleData", "3ColumnSmallBox", \
"SlideShow"],
Cell[55128, 1973, 130, 3, 70, 46, 0, "StyleData", "3ColumnSmallBox", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[55295, 1981, 415, 11, 70, 29, 0, "StyleData", "4ColumnBox", "All",
  StyleMenuListing->None],
Cell[55713, 1994, 61, 1, 70, 45, 0, "StyleData", "4ColumnBox", \
"Presentation"],
Cell[55777, 1997, 42, 0, 70, 42, 0, "StyleData", "4ColumnBox", "SlideShow"],
Cell[55822, 1999, 125, 3, 70, 41, 0, "StyleData", "4ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[55984, 2007, 366, 10, 70, 29, 0, "StyleData", "5ColumnBox", "All",
  StyleMenuListing->None],
Cell[56353, 2019, 61, 1, 70, 45, 0, "StyleData", "5ColumnBox", \
"Presentation"],
Cell[56417, 2022, 42, 0, 70, 42, 0, "StyleData", "5ColumnBox", "SlideShow"],
Cell[56462, 2024, 124, 3, 70, 41, 0, "StyleData", "5ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[56623, 2032, 397, 10, 70, 29, 0, "StyleData", "6ColumnBox", "All",
  StyleMenuListing->None],
Cell[57023, 2044, 61, 1, 70, 45, 0, "StyleData", "6ColumnBox", \
"Presentation"],
Cell[57087, 2047, 42, 0, 70, 42, 0, "StyleData", "6ColumnBox", "SlideShow"],
Cell[57132, 2049, 125, 3, 70, 41, 0, "StyleData", "6ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[57294, 2057, 426, 13, 70, 28, 0, "StyleData", "FramedBox", "All",
  StyleMenuListing->None],
Cell[57723, 2072, 60, 1, 70, 44, 0, "StyleData", "FramedBox", \
"Presentation"],
Cell[57786, 2075, 41, 0, 70, 41, 0, "StyleData", "FramedBox", "SlideShow"],
Cell[57830, 2077, 117, 3, 70, 40, 0, "StyleData", "FramedBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[57984, 2085, 479, 15, 70, 32, 0, "StyleData", "DefinitionBox", "All",
  StyleMenuListing->None],
Cell[58466, 2102, 64, 1, 70, 48, 0, "StyleData", "DefinitionBox", \
"Presentation"],
Cell[58533, 2105, 45, 0, 70, 45, 0, "StyleData", "DefinitionBox", \
"SlideShow"],
Cell[58581, 2107, 121, 3, 70, 44, 0, "StyleData", "DefinitionBox", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[58739, 2115, 490, 15, 70, 36, 0, "StyleData", "DefinitionBox3Col", "All",
  
  StyleMenuListing->None],
Cell[59232, 2132, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox3Col", \
"Presentation"],
Cell[59303, 2135, 49, 0, 70, 49, 0, "StyleData", "DefinitionBox3Col", \
"SlideShow"],
Cell[59355, 2137, 125, 3, 70, 48, 0, "StyleData", "DefinitionBox3Col", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[59517, 2145, 497, 15, 70, 36, 0, "StyleData", "DefinitionBox4Col", "All",
  
  StyleMenuListing->None],
Cell[60017, 2162, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox4Col", \
"Presentation"],
Cell[60088, 2165, 49, 0, 70, 49, 0, "StyleData", "DefinitionBox4Col", \
"SlideShow"],
Cell[60140, 2167, 125, 3, 70, 48, 0, "StyleData", "DefinitionBox4Col", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[60302, 2175, 476, 15, 70, 36, 0, "StyleData", "DefinitionBox5Col", "All",
  
  StyleMenuListing->None],
Cell[60781, 2192, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox5Col", \
"Presentation"],
Cell[60852, 2195, 49, 0, 70, 49, 0, "StyleData", "DefinitionBox5Col", \
"SlideShow"],
Cell[60904, 2197, 125, 3, 70, 48, 0, "StyleData", "DefinitionBox5Col", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[61066, 2205, 509, 15, 70, 36, 0, "StyleData", "DefinitionBox6Col", "All",
  
  StyleMenuListing->None],
Cell[61578, 2222, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox6Col", \
"Presentation"],
Cell[61649, 2225, 49, 0, 70, 49, 0, "StyleData", "DefinitionBox6Col", \
"SlideShow"],
Cell[61701, 2227, 125, 3, 70, 48, 0, "StyleData", "DefinitionBox6Col", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[61863, 2235, 492, 15, 70, 25, 0, "StyleData", "TopBox", "All",
  StyleMenuListing->None],
Cell[62358, 2252, 57, 1, 70, 41, 0, "StyleData", "TopBox", "Presentation"],
Cell[62418, 2255, 38, 0, 70, 38, 0, "StyleData", "TopBox", "SlideShow"],
Cell[62459, 2257, 98, 2, 70, 37, 0, "StyleData", "TopBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[62594, 2264, 519, 16, 70, 28, 0, "StyleData", "MiddleBox", "All",
  StyleMenuListing->None],
Cell[63116, 2282, 60, 1, 70, 44, 0, "StyleData", "MiddleBox", \
"Presentation"],
Cell[63179, 2285, 41, 0, 70, 41, 0, "StyleData", "MiddleBox", "SlideShow"],
Cell[63223, 2287, 101, 2, 70, 40, 0, "StyleData", "MiddleBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[63361, 2294, 521, 16, 70, 28, 0, "StyleData", "BottomBox", "All",
  StyleMenuListing->None],
Cell[63885, 2312, 60, 1, 70, 44, 0, "StyleData", "BottomBox", \
"Presentation"],
Cell[63948, 2315, 41, 0, 70, 41, 0, "StyleData", "BottomBox", "SlideShow"],
Cell[63992, 2317, 157, 4, 70, 40, 0, "StyleData", "BottomBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[64186, 2326, 496, 15, 70, 29, 0, "StyleData", "TopSpanBox", "All",
  StyleMenuListing->None],
Cell[64685, 2343, 61, 1, 70, 45, 0, "StyleData", "TopSpanBox", \
"Presentation"],
Cell[64749, 2346, 42, 0, 70, 42, 0, "StyleData", "TopSpanBox", "SlideShow"],
Cell[64794, 2348, 119, 3, 70, 41, 0, "StyleData", "TopSpanBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[64950, 2356, 521, 16, 70, 32, 0, "StyleData", "MiddleSpanBox", "All",
  StyleMenuListing->None],
Cell[65474, 2374, 64, 1, 70, 48, 0, "StyleData", "MiddleSpanBox", \
"Presentation"],
Cell[65541, 2377, 45, 0, 70, 45, 0, "StyleData", "MiddleSpanBox", \
"SlideShow"],
Cell[65589, 2379, 161, 4, 70, 44, 0, "StyleData", "MiddleSpanBox", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[65787, 2388, 168, 4, 70, 26, 0, "StyleData", "Picture", "All",
  StyleMenuListing->None],
Cell[65958, 2394, 58, 1, 70, 42, 0, "StyleData", "Picture", "Presentation"],
Cell[66019, 2397, 39, 0, 70, 39, 0, "StyleData", "Picture", "SlideShow"],
Cell[66061, 2399, 102, 2, 70, 38, 0, "StyleData", "Picture", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[66200, 2406, 232, 5, 70, 43, 0, "StyleData", "OpenCloseItemizedPicture", \
"All",
  StyleMenuListing->None],
Cell[66435, 2413, 75, 1, 70, 59, 0, "StyleData", "OpenCloseItemizedPicture", \
"Presentation"],
Cell[66513, 2416, 56, 0, 70, 56, 0, "StyleData", "OpenCloseItemizedPicture", \
"SlideShow"],
Cell[66572, 2418, 178, 4, 0, 55, 0, "StyleData", "OpenCloseItemizedPicture", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[66787, 2427, 168, 4, 70, 34, 0, "StyleData", "ItemizedPicture", "All",
  StyleMenuListing->None],
Cell[66958, 2433, 66, 1, 70, 50, 0, "StyleData", "ItemizedPicture", \
"Presentation"],
Cell[67027, 2436, 47, 0, 70, 47, 0, "StyleData", "ItemizedPicture", \
"SlideShow"],
Cell[67077, 2438, 103, 2, 70, 46, 0, "StyleData", "ItemizedPicture", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[67217, 2445, 164, 4, 70, 30, 0, "StyleData", "ListGraphic", "All",
  StyleMenuListing->None],
Cell[67384, 2451, 62, 1, 70, 46, 0, "StyleData", "ListGraphic", \
"Presentation"],
Cell[67449, 2454, 43, 0, 70, 43, 0, "StyleData", "ListGraphic", "SlideShow"],
Cell[67495, 2456, 99, 2, 70, 42, 0, "StyleData", "ListGraphic", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[67631, 2463, 364, 9, 70, 30, 0, "StyleData", "ListNoteBox", "All",
  StyleMenuListing->None],
Cell[67998, 2474, 62, 1, 70, 46, 0, "StyleData", "ListNoteBox", \
"Presentation"],
Cell[68063, 2477, 43, 0, 70, 43, 0, "StyleData", "ListNoteBox", "SlideShow"],
Cell[68109, 2479, 127, 3, 70, 42, 0, "StyleData", "ListNoteBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[68273, 2487, 165, 4, 70, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[68441, 2493, 63, 1, 70, 47, 0, "StyleData", "PictureGroup", \
"Presentation"],
Cell[68507, 2496, 44, 0, 70, 44, 0, "StyleData", "PictureGroup", \
"SlideShow"],
Cell[68554, 2498, 166, 4, 0, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[68757, 2507, 117, 3, 70, 24, 0, "StyleData", "Sound", "All",
  StyleMenuListing->None],
Cell[68877, 2512, 56, 1, 70, 40, 0, "StyleData", "Sound", "Presentation"],
Cell[68936, 2515, 37, 0, 70, 37, 0, "StyleData", "Sound", "SlideShow"],
Cell[68976, 2517, 85, 2, 35, 36, 0, "StyleData", "Sound", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[69110, 2525, 28, 0, 38, "Subsection"],

Cell[CellGroupData[{
Cell[69163, 2529, 217, 6, 38, 31, 0, "StyleData", "2ColumnTable", "All",
  StyleMenuListing->None],
Cell[69383, 2537, 63, 1, 44, 47, 0, "StyleData", "2ColumnTable", \
"Presentation"],
Cell[69449, 2540, 44, 0, 38, 44, 0, "StyleData", "2ColumnTable", \
"SlideShow"],
Cell[69496, 2542, 91, 2, 34, 43, 0, "StyleData", "2ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[69624, 2549, 213, 6, 38, 35, 0, "StyleData", "2ColumnEvenTable", "All",
  StyleMenuListing->None],
Cell[69840, 2557, 67, 1, 44, 51, 0, "StyleData", "2ColumnEvenTable", \
"Presentation"],
Cell[69910, 2560, 48, 0, 38, 48, 0, "StyleData", "2ColumnEvenTable", \
"SlideShow"],
Cell[69961, 2562, 95, 2, 34, 47, 0, "StyleData", "2ColumnEvenTable", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[70093, 2569, 223, 6, 38, 31, 0, "StyleData", "3ColumnTable", "All",
  StyleMenuListing->None],
Cell[70319, 2577, 63, 1, 44, 47, 0, "StyleData", "3ColumnTable", \
"Presentation"],
Cell[70385, 2580, 44, 0, 38, 44, 0, "StyleData", "3ColumnTable", \
"SlideShow"],
Cell[70432, 2582, 91, 2, 34, 43, 0, "StyleData", "3ColumnTable", "Printout"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[70584, 2591, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[70645, 2595, 709, 21, 33, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[71357, 2618, 57, 0, 70, 57, 0, "StyleData", "SlideShowNavigationBar", \
"Presentation"],
Cell[71417, 2620, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[71619, 2627, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[71782, 2635, 1681, 40, 69, 35, 0, "StyleData", "SlideShowSection", "All",
  
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[73466, 2677, 109, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[73578, 2681, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[73679, 2685, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[73838, 2693, 327, 10, 50, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[74168, 2705, 101, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[74272, 2709, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[74321, 2711, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[74486, 2719, 341, 9, 38, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[74830, 2730, 98, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[74931, 2734, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[74978, 2736, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[75125, 2743, 166, 4, 38, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[75294, 2749, 95, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[75392, 2753, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[75451, 2756, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

