(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     60207,       1785]*)
(*NotebookOutlinePosition[     60843,       1807]*)
(*  CellTagsIndexPosition[     60799,       1803]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageHeaderLines->{True, True},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellBracketOptions->{"Color"->RGBColor[0, 0, 0.466667]},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Header Graphic (to be pasted in)", "Section"],

Cell[CellGroupData[{

Cell[StyleData["HeaderCell"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  Evaluatable->False,
  PageBreakBelow->False,
  ImageSize->{350, 24},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  StyleMenuListing->None],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005N000061000`40O003h00OogooGgoo003oOomO
Ool00?mooemoo`00ogooGgoo000026jjL[aZ_7:kJ[ab_6ZkL[`3K[/01g:lK[a^^fjkK[a^^g:l00=^
^`09K[ab_6jlK[aZ_7;LK[a^^fjl009^^`03L[aZ_7:k009^^`05K[ab_6kKK[a^^`03K[`026jkK[a^
^fjlK]]^^fjlK[/2K[`01VjkL[a^^fjlK[]b_09^^`04K]ab^fZlL[`2K[/2K[`01fjjL]aZ_6jlK[]b
_6jk009^_009K[]b_6jlK[]^g6jkJ[]^_6jk009^_0A^^`08L[a^_6ZkK[a^^fkLK[ab_09^^`0;K]a^
_6kKL[]Z_6kKK[]^_7;LK[a^^`02K[`02FjkK]a^_6jkK[aZ_7:kK]a^_002K[/00fjlL[a^_002K[/0
1FkLL[a^^fjlL_d00W;l00YboGLML_ac7G<LLaeg77<lMaec?0=g?@08Mcig?GLmMeig?GMMNeigG@9g
GP0ENgmkGG]NMgikGG]oMgekOW]NNgikWW]nNeikWW]nNiikOg^NOgigWWnN009kWP0;Ogik_WnNNkik
WWnONiio_gnnNimoW`02Okl02G^nOkmo_gnoOmmo_g^nOkmog`02Okl2Oml2Okl2Oml2Okl6Oml01Woo
OmmoggooOmmoo`9og`03Oomoggoo009oo`03Ommoogoo06eoo`0000=44dPCB1<00TPC00I44dPCA1=8
4dPDA1<2B1<00d@CB1=84`02A1<2B1<014@CB1=44dPB0TPC01Q44dPBB1A84d@CB1=44dPCA1A84d@C
B1=44dPCA1=84dPBA1=84dPDB1=44dPCB1@2B1<01d@CB1=44dPCA1=44TPC00944`984`09A1=84dPC
A1=854PCA1=84d@C00=84`07A1984d@CB1=44dPCA1<00TPC00E44dPCB1=84d@C00984`04A1=84d@C
A1<2B1<01D@CB1<l4C`A@1000S`A00A043`A?150408l4@04@14l4C`@@142?1403D0@?14l4D0A?10l
4D0A?10l4D0A?10l4D0B00904@07@1944T@CA19@54`ED9@00U1e00=@]EBeD;H00UCf0UDG01II5eEG
FCMM>5UgFEMMUefHGGQM^5fgGKUQ^5gHHMQUf67IHOQQnF8IIQUR6@9V6@0OISYVFVHjISYZFVIjJUYZ
NVIjJWYZNfZJKY]ZNVjKJY]Z^fjKJY]^^fjlK]]^_6jkK[a^nfkLL[]^g7;lL]`00Vkl02YboG;lLaeb
o7<MMaac7G<LLaec?7<nMcag?G<lMeegGWMLMeig?G]NNeegGWMmMeikGG]nNgmgWG]nNeigWWmnNimk
OW^oNgio_W^nOimkggnONmh2Okl01GoOOkmoogoOOkl00WoO00=oogoOOml0G7oo00003U3fE?ED]UCg
E=EDmUBeE?I@mUCeE?I@]ECfD?H2E?H01UBfE?ED]UCgE?I@]@=DmP0@E;EDee3fE;IDmECfD?IDmUBe
E?IDmE3fE?ED]UCGE;D2E?H03eBgE?E@]UCeE?MDmE3FE?E@mUBfE?EDme3eE;IDm`02E?H04eCeE=MD
mECFD?ID]UCfE?EDmUBeE?IHmeCEE?ED]UCgD?IDmUCe009DmP08D?ID]ECfE=IDmeCeD;IDm@=DmP0B
E;MDmECfE?EDmUCFE?ID]UCFD?MLdEBfE?ID]U2eE;I@mUBf0UBe01m@mUBfD;ED]UCfE;ED]U2eE?ID
]U3eE;I@mUBeD;ID]eCfE?EDmeTGEAEE5eTgFEMEEUUHGGMMF5fGGIQQ^002GKP0667HIMQMn6GIHOUR
66GiHQYV6F8IJUYV>FHJJUYVFVYJJW]VFVZJJU]VVfYjKW]^V`9ZV`0?K[]ZVfjkKY]^ffjkK[a^fg:l
K]]bo6kLL]]boFkl00Abo00<Laec77;lLaac7GLLLaec77LmLceg7G<m1GLm0WMM00agGWLmNeigGG]N
NeegGgMMNgigOW]mNel2Ngh04W^NNgmkWW^ONgik_WnONiioWW^NNkmoWg_NOimoggnNOmmk_`=o_`9o
g`03OkmoogoO00=ogf9oo`0000AD]E2fD9A<509<5@08E;ID]E1fD7ED]EBfC1A@5@9<500aC1E@5D`D
D7ED]E2fD1A<5E0DD7E@54`EC1A@5EAeE;I@MD`ED1A<5E0DD;I@U4`DC1E<551eD7A<5E0DC1E@54`E
D1A@5E1eC1A@5E1eE;I@]50EE;EDMU0EC3A<5E0DC1D00T`D00=D]U2eD1D00T`D011@5E1fC1A@54`E
D1A@]UBfD7E@54`EC1A@UEBeE;I<5@=<500XD9A@MD`ED1A@MUBeD9E<550EC1A@MU3GE?E@]E2fE;I@
mE2fE;E@]UCfE;E@]UCFD?E@]UBfE;E@mUBeE;I@eUBeE;I@mUBeE?I@]ESfE=D2EAL07UUFFAMI=Udh
FGIIN5egFIQIUefGHKUM]f6iGKQQfF7HHOUUnF8HIOUR6FGjHQUVFVHiIUYZ>VHjIUYZNP9ZFP0GJW]Z
VfZJKWYZVfjkJY]^VVjkJY]b_6ZKK]]^_6kKK]a^^g;LK]abfg;MK_abg004L_`00g<ML_ac7002Lad0
37LMLaag?G<LMcec?GLmLceg?W<lMaigGP=gG@06NeicOG]nNeegOgMN0W]n00=gOG]nNgh00g]n00ik
WW^ONgikWW^nNimo_g^NOkmkWgnoNiiogg^n0Wno00=oggnoOml00WoO00=o_gooOml00WoO00AoogoO
Oomogeioo`0006YD]U1eHOUboFYjL_aE5E0FGIQQn50EE?E^g6jKISY^VfkKJW]^g67HD1EQ^6kLISU^
_5fhJW]^VfXjK]aMf50DGKQbo6IJJW]^Vd`EJUY^g6HiL[aQf6HIK[aV6VjkJY]^Vg;lHOYMMfkLK[]V
6E0DEAMUnD`EFIMbo6YKJWYZVfjKK[]^Nd`EE;I^g6IKKW]VNUfGL_aV>VjKKW]@MU1dIQUbo6HjJ[]Z
>TaeB1=bo7^oMaegGUTGGMQb_6klHKQ@5F6hK]aV>G;LHMQ@U52fE;IDm@9D]P0?E;E@mUBfE;ED]U3f
E;ED]UBeD?ID]UBeE;I@mUBe009D]P0KD;ED]U2eE?IDeUSgEAII5UTGFCIIF5UGGGQMEeUhGIMQN66I
GKMQV5gHHMQMf6GIHQQQfF7i009V6@09HQUVFFHIISYZ>VHjIUYZNFXj009ZN`9ZNP9ZV`08JYY^NfjK
KY]ZVfkLKY]^f`=^^`03K]]b_6kk009^g007Laa^fg;mL_ac77;lL_d00W<L00QboG<LLaec77<MLaag
?G<M1GLm00mgGGLlMcigGGMNMeekGWMMNeikGGMMNgigOG]oMgd00W]n00=gWG]oNgh00g^N00UoOg^o
Ogik_g^NOkikWgnnNkl00Wno00=oggnoOml00Wno0goO00IoogoOOomoggooOmmOOol0000RD;EDMUDf
L_aoof8IE;I<4fXjOom44e1eHOUkOWooNgmI5WooKY]DmE1fE?EZNgooOkm@M5DFNkioofYjE?M@METG
HQT2Ool06ETGD1EEEWLNOom^o5BfEAIg?GooKW]MMefGHMQooeUhMcaooeBfD1EMMgooB1=DmUUG009o
o`07E=Ig?GooE?ID]E2EFGL00Woo00=I5eBfGOP00Woo00UIEeAdD7IE5VYKOomoWeCeB1<00Woo01UH
mdadKY]oof6HOom^Ve3fD7IDmFYKOomoge2fE;ID]E3fE;ID]EBfE?ID]EBfD;IDm@02E;H01U2eE?ID
]EBfD;IDm@9D]P0TD;EDmUBfE;IDmUBeDAIDmETGE=MIEUDgFCII=eUfGGQIUeUhGIMM]f6iGKQQ^5fh
IOUMf6GIHQQUnF7iHQUUnFHJIUUV6VII0VYJ00QVFVYJIUYZNVYkJWYZNfik0VZK00A^VfZKKYY^V`9^
^`0<K[a^ffjlK_a^fW:lK_]bg6kLK_abnfkM0g;l00ac7G;lLaec7GKlLaeg7G<mLaeg?7<mMah2Mcd0
17MNMcegGWLm0WMM00akGWMMMeigOGMONgegGG]nNgekOgMmNgl3Nih03G]nNimkWW^nOgik_W^OOimk
_gnnNkmoWg^o009o_`05Nkmo_goOOkmkg`06Oml4Ool00goOOomoo`1JOol0001WE;I@mE2EA1=ogdPD
D;E<56jKOomQfD`DD1E@UGooHMQ44efGK[a<55BfB1AQV7ooE?E@5D`EGCQooeCFD1A@]U2eA19oogMN
B1=DmE0EC1Aoof6hC1E@550EOomIUd`DD7I855fgNgi857MNC1=<5F7hOom^^dPDB1=kOWooA1=84g^N
B1A@]UBeA19oog;lB1A@]D@COomoOT@CD;IDmU1e@19oofijA1=V>GooB1A@553EB1AVFWLMD;A^g4`D
E?E<55fHOomD]U0ED;D00UBf00MD]E3fE;E@]EBfD?ID]@02E;H01U3eE;ID]EBfD?ID]@9D]P0BD?ED
]UBeE;IDmE2eE;IHmeDFEAMI5UDGFAMMMeUGFGQIMeeH0UfG00MMN5fHHKQM^67HGMQQf@02HOT026Gi
HQUV6FHiHQYV6FIIJSX2ISX016IjJUYZNVYk0VYj00MZNfZjKW]Z^fZKKY]Z^`02K[/03FjLK]]^_7:k
K[]bg6kLL]a^o6kKL_aboG;k009bo00JL_ebo7;lL_ec77<MMcac7G<LMcac7GLmLcag?G<mMcegGWML
MeigGGMNMcekGWMmNcigO@9kOP0LNeikOgMmNgikWW]NNiikOW^NNgik_W]nNkmoWW^NNkioWg^oOkmo
WWoONkioggnoOmmo_gooOkl2Oml017ooOmmoogoO0Woo00=oggooOol0G7oo00002E2eE;IDmD`ELaeQ
f51fC1Ag?P02Ool03T`DD7A@5GooL]a<4dPDOom<5D`CA1=boGooB1@2D;D0K52DOomV>D`EE;ED]TPD
OimoodPDE;ID]DPDOom^g4`DE;I84gooL]a<4e2fFAI<5E2EC1=kOU1fC1A^W7ooOkm@5DPCL_eoodPD
C1EbffXjB1=855BfOomQnE0DE;I<57]nOom84eCfE;EDmTPCOomo_d0BNgiood@CE?ID]EBfC1=MfD`D
Omm@5D`D@1=foGooB1AD]E3hE?ID]UCgE;EDmeBfE?ID]UCgD;EDmeBfE?I@]UCfE;IDme2eE?MD]UCf
D;IDmUBfF=M@mECeF=MI5UTHFCIIE`9I=`0XGGQMMeVHGIMMV5fGHKQM^67HHKUQn67HHMUQn67iIOQR
6VGjIQUVFFHJHSYZNVHjJUUVNfIJJWYZNfZJKW]ZNfZjKW]^VfZkKY]ZVfjlK]/2K[/03FklK[]^g7;K
K]abg6kLL]]bo7;mLaa^o7<L009c7@05Maabo7<MLaeg7002Lad05WLlMcig?G<mMcecGGLmMcigG7MN
NeegGWMMNeicOG]NMeigOWMmNgikOg]M0W^N015kOW^ONgikWWmoNkikOW^oOimk_WnNNkmk_W^oOiio
ggnn009o_`04Oomo_gooOkl4Oml01GooOmmoogooOml0GGoo000025CfE;I@]U1eHOQc?50DB1@2Ool0
36HIL_a<54PDOomkGT`DD1EQf7ooMeikG@9oo`1:B1=@mUBeB1AoofjLC1ADmU2eC1Ag7Goo@19<550E
A19oognNB1ADeDPDOomg?T0BC1AoOd`CE;I@5G:lHMQ44goOOomI5WLmA1=^VgooB1=DMD`EOomgGW]M
Ommooe2eD9ED]D`DK]aoodPDE;ED]U2eB1Ao_goo@15o_gooB1A@]EBfD;E@mUBEC1EQf7ooMeekG@9o
o`09B1=@]U3HE?I@]U2eE;I@mUBe009@]P06E?ED]U2eE;IDmU2e0UBf00a@mEBfE;E@]UBfE;E@mU2f
E?ED]UCfE?D2EAL03EUGFAII=eeHFGIIF5egGIQIUf6hGIQQ^5fi009Qf003HMUQn68I009Qn@0<ISUR
6FIIIQYV>FYJISUZFVIJJU]ZFVYj0VYk00IZNVZKKW]ZVfZkKYX2KY/02VkKJ[]b^f[LK[]b_6kKK[]^
o7;L0Vkl01eboG;LL_abo7<LM_ac77;mLaac7GLLLaec?GLlLaeg?G<mMcegGGLMMcegGGMNMcegGWMM
MeigOW]N009gG@=kOP0@NeegWg]NMiikWW]mNimkWW^nOgik_WnNNkmoWW^oOih2Okl01G_ONimoggno
Oml00gno00AoggooOmmoo`=ogf1oo`0000i@]EBeE;I@]E0EOim854PCOomoWT0BOom<5DPC0Woo00U8
55BfB1Aoge0EB1Aoog<MC1@00UBf00e44gooOim84eBfE?I<56HkOomZ>VZKKY]V>P02Ool0?DPDE;I8
57^NOomb_7oOOom855BeD9EIUg<M@15oog]n@15o_dPDHKQooe1eD;E<57<MIQU857MNOom855BfD?I<
56HIOom@UE1fE?ED]T`DK]aooc`AMcioodPCE;IDmUBfE;E@]EBfB1Aooe0EB1AoogLMC1=@mU2g009D
]@0BE?ID]E2fE;IDmEBfD;ID]E3fE;E@]UBfD?ED]U2fE;E@mUBe0UBf00A@]EBfE;IDm@9De`0GEAEI
5eTFECMIEeTfGGQIMeUHFIMQN5VHGKQM]f6hGKUQf67iHMUUnF7iISUQn@02IQT03FHiIU]V>FHjIUYZ
NVHiJWYZFVIkJWYZVfij009ZV`0LKY]ZVfZkK[]^Vg:LJ[]b^fjlK]]^g7;LK]]^g7;kL_a^ng;mL_a^
o7;lLaec77;lLaec77<MMa`2Lad09GLlLceg?GLmLcag?WMMMcegGG/nMeekGWMMNeigGG]oMgigGG]m
MemkOW]mNimoGWNNNiikOW]oNiik_gmoNiioWW^oOimkggnO009o_P04Ommk_goOOkl4Oml01gnoOmmo
ggooOmmoogoO05moo`0000iD]U2fE?ED]T`DMeeDMUCfOom^fd@CKYabo40B0Woo03E84eBeD1EZVegH
B1=oofHIC1ADmU2eC1Ao_gooB1=DeU2eD1EMUgooIQUMN5ghFAMg?GooB1=D]D`DL_eooeCfJWYood`D
D;I@]E0EMce84gooJY]<55gHKY]@MWooFEM@5U3DE;Ig?C`A009oo`0[B1=D]UBeC1EMN7ooGEQ@U52f
E;E<5FYJOom44f6hOomD]E1eD;EDmE2fE;IDmU0DKW]MfDPCOomV6D`EE;ID]E2fE?ID]E2fE;IDmE2f
E;ID]ECfE;D00UBf00IDmEBfE;ID]ECfE;D2E;H0<53eE;ID]U3eE;IE5UCeFAMHmUDgFEII=eUHFEIM
N5fGGGMMV5fGHKQM^F6hGOQQf67IHQQUf68IHOUV6F8JIQUV>VHIISYZ>VIIJU]ZNVIJJW]^NVYjJY]Z
NfZJKY]ZV`9^V`0@J[]b_6ZkL]]^_6kKK]ab^fklK]afg6klK]abgFlKL_d3L_`01FkmMaac7G;mMc`0
0W<M01Ig?7<mMaig?7<mMcigGGLmMeegGW=LNeig?G]NMeekOWMMNeekOW]oNgekW@9kOP0AMiikOW]o
OiikWW^nNgik_WnNMkmoWW^oOiik_gnOOmmkW`02Okl01goONkmoggoOOkmoggoo009og`=oo`03Ommo
ogoo05aoo`0001m@]ECfD;I@]E0EJWYR6EehOomUnT`DB1=ood@BMeioodPDE;I@]EBeMciM>7ooFAM@
UE1eE;I<4g;mOom85002E;H0;U1dD7IooegiC1=@MD`CISYood`EE;I<4fYjOom44dPCNgiE5e1dE;I<
56jLISUoof6iD1A857]mE?Ioof7IC7ED]T`DLceDMWooL_e<552EE;ID]D`EOomVFU0E0UBf00Q<5EVG
OomIEd@COomg7DPD0UBf011D]E2fC1A@eE0EMceM>7ooFAM@55BfE?ID]E2fE;IDm@9D]P0>E;E@mUBf
E;E@]UCeE;I@]UBeE?I@]UBeE;I@m@9D]P08E;EDmUBfD;EHme4FFAIE5`9I5`05GGMI=eUhFGMIF002
GIL01F6IGKMQ^5gHHKP00V7H00MQfV7hHOUUnFHiIOUV>@02ISX056IIISYZ>VIjJUYZNfYJIW]^VVYk
K[]ZNfjKK[]ZVfjKKYYZVg;KJ[`2K[/066kKL]a^fW;LK]]bgG;kLaebg6klMaabo7<LL_aboG<LMaec
7G<LMcec7GLlLceg7P=g?@0@Mcig?GMMMeigGGMNMeegOW]MMgigOGMNNgekOg]nMgh2Ngh057^NMiek
Og^NOgmk_W]oNkioWW^oOimk_g^NOmmkWgoOOkmoggnoOml2Okl017ooOmmoggoo0WoO00=oogoOOol0
GWoo0002E;H04eBeE;ID]ECfL[a^VgooEAI@UE0DJY]VFVXjOom<552eE;I<56Hi009oo`0PB1=E5V5h
C1A<5FYjOom<4e2fD1AMN4PDOom^Vd`DE;I@MEfGOomIEe1dC7EQ^7ooFEM@5E2ED1EHmeCeD7IDmP9o
o`0XD9A@MU1eHOQ^_7ooISU@552eD7ED]WnnOomQnD`DHMU<4e2fB1=oog;LC1A@]E2fFAI@5GooIQU8
4fYJOom<550ED;E@eEBfLae@54`EIST2Ool0FD@CC1E@ME2eE?MD]UCfE;IDme2eE?MD]ECgE;IDmUBf
E?MD]ECgE;EDmeBfE?ID]UCgE;EDme2eF?MDeUCeF?ME5eTGFCMIEUTgFEMMMeeHGIMMV5fGFIMM^66H
GKQQf67iHMUQn67IIOUV>67iIQUR6FHjISUV>VYjISYVFVYjJUYVNVYjJW]VNVikJW]Z^VZKK[Y^VfZK
L]aZ_6jKK[]^ng:lK]abg6kLK_abo6kLL]`00g;l00U^oGKmLaabo7<MLaac7GLMLa`00W<M01=g?GLl
Mcec?GMMMcegGGMNNceg?WMmMeikGGMNMeekGg]mNgigG@02Ngh017^NOgigOWnO0g^N00aoWW^nOgik
_WnONkikWgoONiioggnNOml2Okl00goOOkmoo`05Oml00gooOmmoo`1OOol00007D;E@mUBfE?E@]TPD
L_/00Woo00a<552eE;I<57mnIUYooeSgD7EDeE2fB1<2Ool06DPCC1EooeSgA1=D]WooE;I855CfOolh
47ooOim04eBeC1E857ooIQY8550EB1Aoof6i00984`05C1Aooe2fE7Dl4002Ool0GT`DD;ED]TPDNeeo
og;LA1=D]U2eB1AkGWooE?I<57<lNem44T0AOomogd@CA19ogf7H>11oog;LA1=04WoOOom<54`EC1AQ
^7ooB1AD]DPCOomogeVGOomQ^52EE;EDmU2fE;ED]U3fE;ED]U2eE?ID]U2eE;IDmU2eE;ID]E3fE;ID
mE2fE?ID]E2fE;I@mUCfF=II5eDeEAMI=eUFFCMIN5UgHGQIMefHHIQM]efhHKQQ^EgHHOQQnF8H0V7i
00=V6F8iIQX00VHi0VHj00eZFVIJJUYZNVYJJW]VNVikJYY^VfYkKY]ZV`02K[/04FjKK[]^_6kKK[a^
nfjkK]abnfkLK]]c76kML_]c77;mL_/00W<M0W<L00Ic7G<LLaeg?G<LMcd2Lcd3Mcd03gMMLcegGGMN
NeegGW]MMeigOG]nLeekOg]NNgigOP02Ngh05WMnNiikOWNNOiikOW^OOiik_gnONkioWWoONimoggno
Nkmo_WoONkmo_goO0Wno00=oggooOml00WoO00=oogoOOol0GWoo0002E;H01E2eD;ID]U0DFGP00Woo
00E84eBfE?I<568I009oo`0CEEM<55BfE;I857KlOmm854`DK[]oog;LMceoogoOK[]oogoOJWX00Woo
00Ag?ECfFEMoW`9oo`03J_]I=gnN009oo`07L_aboGooOom84eTFMch00Woo00E855BfD=I@M5UG009o
o`09LaeDmEBfD9A@]WooC1=@]T`D009oo`08L[aoogooKYYkWgooE;Ig7@9oo`07LaeDeD@BMeioofYj
ISX00Woo04I<55BfC1Abg7^NHKUoof8ID1A@mU2fE;E@]U3fE;E@]U2eE?I@]U2eE;I@mU2eE;I@]E3f
E;I@]E2fE;I@]E3fE;E@mUBfE=EDmUDFEAMI=eTFFEMM>5UfGGQIEefHFIMMV5fhHKQMf5fhHMQQfFGI
HOQR6FHJHQUV6FHiIQYV>VIIJSYV>FYJIW]VFP9ZN`05KW]ZVfjKIWYZV`02KY/0<fjkKY]Z^g;KK[aZ
^g:lK[]^ng:lL]a^g7;lK]]bo7;mL_a^ngKmLaebng;mMaebo7<mMaec77LmLaag?WLmLcec?7LnMeeg
?GMNMeagGWMMMeigGG]NMgikGW]mMgekOg]mOeigWP02Ngh2Nih03G]nNimkWg^nOgik_gnOOkmkWW^o
OkioWgoO009o_`=og`03OkmoogoO009og`05OomoggooOomog`1NOol0000>D;EDmUBfE;I@]51fJWYo
ogoOB1AD]E2fE;I44`9oo`0[Nei@MEBeE;I@]DcEGCM@MEBfD7EM^5DFE=I855CfEAII=eehHKQ@]U2D
IQU@]UTFHOQ<55CFIMUDmV7HC1AD]F7iHKUIUeAeD7E@mV7iE?ED]U2eE;D00UBf00A@55CfEAIR6@9D
]P0XE?I<55TGD;ED]DbEGIMI=eDGC1A<5ETgE;EM^5BfHOU@5EBeIOUD]U2eC1A@]FYJJWYD]TPCE;ID
mE2fD7EE5T`DFAM@55BfE;ED]UCfE;D2E;H01UCeE;ID]EBfE?ID]@9D]P06E?ED]UBeE;IDmUBe0UBf
021D]EBfE;EDmUCgF=IE5UTGFAIIEeDgFEMMEeUhGGQIUf6HGGMQ^EfhHKQQ^EghHMUQnF7HIQUQn6Gi
HQ]V6FHi0VHj0VIJ0VYJ01QZNVYJIW]ZVVYjKW]^^fjKIY]^^fjJJY]bVfZkK]]b^fjkL[a^g6kkL]a^
g6klL]`2L_`03VklL_abo7;lLaec77;mLaec77<MMcec77LmLc`2Mcd04GLnMceg?WMMMaegGW]MMeig
GG]NMeekGWMmMgmkGG]nMgh00W]n0W^N00=kOW^NOil00g^N00Yk_gnNNkikWgnoOiio_g^nNkmog`9o
_`05Ommo_gooOkmoo`05Oml2Ool00goOOomoo`1KOol0000DE;ID]ECfD;E@5G^NNeibo6HjD1EDmUBe
E;I@567IMcebo7oOEAM@]@9D]P0ND7ED]U2fE;E@5E1eE=ED]U1eE7I@UE1dD7IDM51fD9EDME2fD7ED
]E1fD9A@]U2EE7E@MU2ED7A@5E2e0UBf015@U5AeD;I@]EBfE;E@mUBfD9A@MU1eE;E@]UBeE;I@eUBe
009D]P03D7A@MU2D009D]P1<D9ADMU1eD;E@5E2dD7I@UEBeD;ID]U2eD1E@552fD=ID]EBfD;ID]EAf
E;E@]UBfD;ED]UCfD;ED]UBeD?ID]UBeD;IDmUBeD;ID]ECfD;ID]EBfD?ID]EBfD;EDmUBfD;EDmUCF
EAE@mUTGF=IEEeDfGEMI=eUgGGMIUeeHGIMIV5fgHIUQf5gHIMQQfF7HHQQUnV7iHST2IQT03FHiISYZ
>FHjJS]VFVYjIUYZNfYjJUYZNfjk009ZN`0AK[Y^NfZkKYa^ffjKK[a^^fkkK[a^^fkLK_abg6kKL_eb
g002L_`036lLLaaboG<kM_ec7GLLLaeg77<LLaec?@9g?@04Lceg?GLmMcd2Med02GLnMeeg?W]MMgik
GW=MNemkG@02Ngh01g^NMeikWW]nNgmkWW]n00=kWP08OimkWW^oNiiogg^NOkmk_`Ao_`04Ommo_goO
Okl3Oml00gooOmmog`1QOol0002CE;E@]UBfE=I@]D`DC1E<550EE;I@]ECFE?I@]U0DC1A<5D`DE;I@
eUBeE;I@mUBfE;E@eUCfE;I@]EBfE?I@]UBeE=I@mUBfE;E@]UCfE;I@]ECFE?I@]UBeE;I@mUBfE;E@
eUCfE;I@]EBfE?I@]UBeE=I@mUBfE;E@]UCfE;I@]ECFE?I@]UBeE;I@mUBfE;E@eUCfE;I@]EBfE?I@
]UBeE=I@mUBfE;E@]UCfE;I@]ECFE?I@]UBeE;I@mUBfE;E@eUCfE;I@]EBfE?I@]UBeE=I@mUBfE;E@
]UCfE;I@]ECFE?I@]UBeE;I@mUBfE;E@eUCfE;I@]EBfE?ID]U2eF=ME5EDGFAMI5UTGFGQMEeEGGGQM
MeVGHIQMUefhGKMM^F6h009Mf00ZIQUQfF7hIOUV6V8iIQUV6VIIISYZ>VIIIUYZFVYkIUYZNfZJIWY^
NfZjJ[]ZVfjkKY]^^VZlK]a^^fkLK[]bg6kKL]a^ffkLL_a^ng;ML_ac7G;k0g;m00mc6g<MLaeg77<M
Mcec77LlMcig7GLmLcig?GMMMch00WMM019gGW]MMeigGGMnNgegOGMnNgigGW]mNiigOW]nNgek_W^N
Ogl3Nih01WnnNiio_g^OOkmk_P9o_`06OkioggnoNkmoggno1WoO00=oogoOOol0Ggoo0000Oe2fE=ID
]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID
]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID
]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID
]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID]UCFE;IDeUBfE=ID
]UCFE;IDeUBf009DeP06E?EHeeTGEAMI=eTf0UTg00EMMeeHFIMMV5Ug009Q^00:GKUQ^5gHHOUUfF7h
IOUQnFHiHQT2IQT02fIIJSUV>fYJIUYZFfYjJUY^NfZJJW/00VjK00=ZNfjKKY/00VjK00IZ^g:LK[]b
^f[KL[`2K]/02VkLL]abnfklL]a_6g;mL_]boG;l0W<L01IboG<MLaac7GLmLaag?W<MLceg?G=MMcag
?WMLMeikGGMNNeegGW]mMeikG@9gGP0BNgikGW]nNeikOW]NMimkWW]nNgmkWW^oNgio_g]oOkmkWg^n
0Wno00Ek_gnoNmmo_gnn00Eog`05OomoggooOomog`03Ool00goOOomoo`1KOol00025?10l4C`@?14l
43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l
43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l
43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l
43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l43`A?10l4C`@?14l
43`A?10l4D0A?1504D0BA1400T@C02U44T@CB1=84dPDB1=<54PCC1E@54adD7E@M52eD;I@eECeD=II
5UDFECMI=UDfFGIIEeUgFIIIMefGFKMMN5fgGMQM^67HGMQQn67iHOQQnF8H009R6@0?IQUR>FHiISYV
>FHjIUYZFVIJJUYVFVYjIWYZNVYk009ZVP9ZV`04JYY^VfZkJ[X2K[/036kKK[]^ffkKK]a^ffklK_]^
o7;lK_abo0Ec7009Lcac?G<lMcag7G=MMcecG7Lm00=gG@04Mgeg?GMmNeh2Mgd027]mMgikOGNNNiik
OW^NMih2Nih02W^ONkikWW^oOkmk_WoONkmogg_O0WoO00=oogoOOol0Egoo0000\
\>"], "Graphics",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {Inherited, 0}},
  Evaluatable->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{350, 24},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[StyleData["HeaderCell", "Presentation"],
  FontSize->18]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  ShowCellBracket->False,
  CellMargins->{{60, 0}, {0, 5}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{0.95, 11},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->36,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{60, 0}, {5, 10}},
  FontSize->54],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{9, 0}, {0, 0}},
  FontSize->24,
  FontTracking->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  ShowCellBracket->False,
  CellMargins->{{60, 0}, {0, 5}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{60, 0}, {4, 6}},
  FontSize->21],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{9, 0}, {0, 0}},
  ParagraphIndent->-85,
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  ShowCellBracket->False,
  CellMargins->{{60, 4}, {30, 10}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->12,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{60, 4}, {55, 8}},
  FontSize->18],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{9, 10}, {50, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{6, 0}, {0, 1}},
  CellDingbat->None,
  CellMargins->{{44, 0}, {10, 35}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{8, 4}, {0, 4}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{0.95, 9},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[0.6, 0.2, 0]],

Cell[StyleData["Section", "Presentation"],
  CellFrame->{{8, 0}, {0, 2}},
  CellMargins->{{44, 0}, {20, 40}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->30],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{9, 0}, {2, 50}},
  CellFrameMargins->{{5, 4}, {0, 4}},
  FontSize->14,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellMargins->{{60, 0}, {8, 10}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 7},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{60, 0}, {18, 14}},
  FontSize->24],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {6, 40}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{60, Inherited}, {8, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 7},
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->13,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{60, 10}, {16, 14}},
  FontSize->20],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{22, 0}, {4, 20}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{60, 20}, {10, 5}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 12},
  FontFamily->"Times"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{60, 20}, {16, 8}},
  FontSize->18],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  Hyphenation->True,
  ParagraphSpacing->{0, 6}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellMargins->{{60, 20}, {2, 8}},
  PageBreakBelow->False,
  TextJustification->1,
  LineSpacing->{1, 2},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["Commentary", "Presentation"],
  CellMargins->{{60, 20}, {10, 12}},
  FontSize->15],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  Hyphenation->True,
  LineSpacing->{1, 3},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Author"],
  ShowCellBracket->False,
  CellMargins->{{60, 4}, {30, 10}},
  PageBreakBelow->False,
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->12,
  FontSlant->"Italic"],

Cell[StyleData["Author", "Presentation"],
  CellMargins->{{60, 4}, {45, 12}},
  FontSize->18],

Cell[StyleData["Author", "Printout"],
  CellMargins->{{9, 10}, {50, 10}},
  FontSize->14]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, 20}, {0, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0.6, 0.2, 0],
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  FontWeight->"Bold",
  Background->RGBColor[1, 0.700008, 0.4]],

Cell[StyleData["Input", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{90, 20}, {0, 2}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["Input", "Printout"],
  CellFrame->False,
  CellMargins->{{37, 0}, {6, 6}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  Background->GrayLevel[0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, 20}, {15, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0.6, 0.2, 0],
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontWeight->"Bold",
  Background->RGBColor[1, 0.700008, 0.4]],

Cell[StyleData["InputOnly", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{90, 20}, {25, 0}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["InputOnly", "Printout"],
  CellFrame->False,
  CellMargins->{{37, 0}, {6, 6}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  Background->GrayLevel[0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["InlineInput", "Presentation"],
  CellMargins->{{10, 10}, {6, 4}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, 20}, {15, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0, 0.500008, 0.6],
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  CounterIncrements->"Output",
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["Output", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{90, 20}, {15, 0}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["Output", "Printout"],
  CellFrame->False,
  CellMargins->{{37, 0}, {6, 2}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, 20}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellFrameColor->RGBColor[0, 0.6, 0.6],
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageSize->{250, 250},
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["Graphics", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{90, 20}, {4, 6}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["Graphics", "Printout"],
  CellFrame->False,
  CellMargins->{{37, 0}, {6, 2}},
  ImageSize->{250, 250},
  ImageMargins->{{28, Inherited}, {Inherited, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{72, 20}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  StyleMenuListing->None,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{105, 20}, {6, 4}},
  FontSize->18],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{72, 20}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{105, 20}, {6, 6}},
  FontSize->18],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{44, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontTracking->"Extended",
  FontColor->RGBColor[0.571389, 0.19675, 0.570504]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->14],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayText"],
  CellFrame->0.5,
  CellMargins->{{60, 20}, {15, 5}},
  LineSpacing->{0, 12},
  ParagraphSpacing->{0, 6},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["DisplayText", "Presentation"],
  CellMargins->{{90, 20}, {12, 6}},
  CellFrameMargins->{{12, 12}, {16, 16}},
  FontSize->18],

Cell[StyleData["DisplayText", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  ParagraphSpacing->{0, 6},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{60, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  CellFrameColor->RGBColor[0, 0.6, 0.6],
  CounterIncrements->"Graphics",
  ImageSize->{250, 250},
  Background->RGBColor[1, 0.900008, 0.900008]],

Cell[StyleData["PictureGroup", "Presentation"],
  CellFrame->{{5, 0}, {0, 0}},
  CellMargins->{{90, 20}, {6, 8}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["PictureGroup", "Printout"],
  CellFrame->False,
  CellMargins->{{37, Inherited}, {6, 2}},
  ImageSize->{250, 250},
  ImageMargins->{{28, Inherited}, {Inherited, 0}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"],
  FontSize->16],

Cell[StyleData["Hyperlink", "Condensed"],
  FontSize->11],

Cell[StyleData["Hyperlink", "SlideShow"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"],
  FontSize->16],

Cell[StyleData["MainBookLink", "Condensed"],
  FontSize->11],

Cell[StyleData["MainBookLink", "SlideShow"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"],
  FontSize->16],

Cell[StyleData["AddOnsLink", "Condensed"],
  FontSize->11],

Cell[StyleData["AddOnsLink", "SlideShow"]],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLink", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLink", "SlideShow"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLinkText", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLinkText", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLinkText", "SlideShow"]],

Cell[StyleData["RefGuideLinkText", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"],
  FontSize->16],

Cell[StyleData["GettingStartedLink", "Condensed"],
  FontSize->11],

Cell[StyleData["GettingStartedLink", "SlideShow"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "SlideShow"]],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "SlideShow"]],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"],
  FontSize->16],

Cell[StyleData["OtherInformationLink", "Condensed"],
  FontSize->11],

Cell[StyleData["OtherInformationLink", "SlideShow"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "SlideShow"]],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->True,
  StyleMenuListing->None],

Cell[StyleData["Placeholder", "Condensed"]],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SelectionPlaceholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->PrimaryPlaceholder,
  StyleMenuListing->None,
  DrawHighlighted->True],

Cell[StyleData["SelectionPlaceholder", "Presentation"],
  FontSize->18],

Cell[StyleData["SelectionPlaceholder", "Condensed"]],

Cell[StyleData["SelectionPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  InputAutoReplacements->{},
  AllowInlineCells->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{1, -5},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
  InputAutoReplacements->{
    "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
      ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
      Inherited},
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  InputAutoReplacements->{
    "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
      ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
      Inherited},
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  TextAlignment->Left,
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[1, 0.749996, 0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  CellFrameMargins->{{18, 10}, {10, 18}},
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
  CellMargins->{{10, 10}, {8, 12}},
  FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
  CellMargins->{{35, 10}, {6, 4}},
  FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
  CellMargins->{{25, 10}, {6, 6}},
  FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
WindowSize->{517, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 88, "Title"],
Cell[1813, 55, 193, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[2031, 63, 42, 0, 69, "Section"],
Cell[2076, 65, 77, 2, 38, 31, 0, "StyleData", "All", "Working"],
Cell[2156, 69, 82, 2, 38, 36, 0, "StyleData", "All", "Presentation"],
Cell[2241, 73, 182, 5, 38, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2426, 80, 140, 4, 34, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2603, 89, 35, 0, 39, "Section"],
Cell[2641, 91, 101, 3, 70, "Text"],
Cell[2745, 96, 560, 14, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3342, 115, 51, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[3418, 119, 252, 8, 70, 29, 0, "StyleData", "HeaderCell", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[3695, 131, 14685, 187, 70, 14453, 179, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False],
Cell[18383, 320, 61, 1, 70, 45, 0, "StyleData", "HeaderCell", "Presentation"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18505, 328, 38, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[18568, 332, 1479, 35, 70, 24, 0, "StyleData", "Title", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[20050, 369, 91, 2, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[20144, 373, 110, 3, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20291, 381, 1503, 36, 70, 27, 0, "StyleData", "Subtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[21797, 419, 93, 2, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[21893, 423, 112, 3, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22042, 431, 1458, 34, 70, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[23503, 467, 97, 2, 70, 46, 0, "StyleData", "Subsubtitle", \
"Presentation"],
Cell[23603, 471, 94, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23734, 478, 1650, 40, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[25387, 520, 167, 4, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[25557, 526, 178, 5, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25772, 536, 1507, 36, 70, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[27282, 574, 97, 2, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[27382, 578, 91, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27510, 585, 1533, 37, 70, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[29046, 624, 101, 2, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[29150, 628, 95, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29294, 636, 39, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[29358, 640, 1337, 31, 70, 23, 0, "StyleData", "Text", "All"],
Cell[30698, 673, 91, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[30792, 677, 117, 3, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30946, 685, 213, 7, 70, 29, 0, "StyleData", "Commentary", "All"],
Cell[31162, 694, 98, 2, 70, 45, 0, "StyleData", "Commentary", \
"Presentation"],
Cell[31263, 698, 133, 4, 70, 41, 0, "StyleData", "Commentary", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31433, 707, 250, 7, 70, 25, 0, "StyleData", "Author", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[31686, 716, 93, 2, 70, 41, 0, "StyleData", "Author", "Presentation"],
Cell[31782, 720, 89, 2, 70, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[31920, 728, 36, 0, 39, "Section"],
Cell[31959, 730, 121, 3, 50, "Text"],
Cell[32083, 735, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[32178, 740, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[32250, 744, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[32323, 748, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[32441, 754, 116, 4, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[32560, 760, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[32677, 766, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[32796, 772, 233, 6, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[33032, 780, 234, 6, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[33269, 788, 232, 6, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[33504, 796, 234, 6, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[33741, 804, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[33863, 810, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[33986, 816, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[34107, 822, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[34252, 830, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[34393, 837, 149, 5, 31, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[34579, 847, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[34686, 851, 90, 2, 38, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[34825, 859, 42, 0, 39, "Section"],
Cell[34870, 861, 248, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[35143, 870, 773, 21, 70, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[35919, 893, 164, 4, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[36086, 899, 165, 4, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36288, 908, 804, 22, 70, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input",
  StyleMenuListing->None],
Cell[37095, 932, 169, 4, 70, 44, 0, "StyleData", "InputOnly", \
"Presentation"],
Cell[37267, 938, 169, 4, 70, 40, 0, "StyleData", "InputOnly", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37473, 947, 491, 14, 70, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],
Cell[37967, 963, 97, 2, 70, 46, 0, "StyleData", "InlineInput", \
"Presentation"]
}, Closed]],

Cell[CellGroupData[{
Cell[38101, 970, 726, 19, 70, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[38830, 991, 166, 4, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[38999, 997, 126, 3, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39162, 1005, 484, 14, 70, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics"],
Cell[39649, 1021, 167, 4, 70, 43, 0, "StyleData", "Graphics", \
"Presentation"],
Cell[39819, 1027, 169, 4, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40025, 1036, 555, 14, 70, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[40583, 1052, 94, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[40680, 1056, 123, 2, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40840, 1063, 554, 14, 70, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[41397, 1079, 92, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[41492, 1083, 94, 1, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[41623, 1089, 222, 7, 70, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[41848, 1098, 60, 1, 70, 44, 0, "StyleData", "CellLabel", \
"Presentation"],
Cell[41911, 1101, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[42090, 1111, 32, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[42147, 1115, 258, 9, 70, 30, 0, "StyleData", "DisplayText", "All"],
Cell[42408, 1126, 140, 3, 70, 46, 0, "StyleData", "DisplayText", \
"Presentation"],
Cell[42551, 1131, 154, 4, 70, 42, 0, "StyleData", "DisplayText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42742, 1140, 374, 10, 70, 31, 0, "StyleData", "PictureGroup", "All",
  CounterIncrements->"Graphics"],
Cell[43119, 1152, 171, 4, 70, 47, 0, "StyleData", "PictureGroup", \
"Presentation"],
Cell[43293, 1158, 181, 4, 70, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[43523, 1168, 49, 0, 39, "Section"],
Cell[43575, 1170, 149, 5, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[43727, 1177, 126, 4, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[43856, 1183, 152, 5, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[44045, 1193, 35, 0, 39, "Section"],
Cell[44083, 1195, 184, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[44292, 1203, 302, 8, 38, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[44597, 1213, 60, 1, 40, 44, 0, "StyleData", "Hyperlink", \
"Presentation"],
Cell[44660, 1216, 57, 1, 35, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[44720, 1219, 41, 0, 38, 41, 0, "StyleData", "Hyperlink", "SlideShow"],
Cell[44764, 1221, 123, 3, 35, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[44902, 1227, 104, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[45031, 1234, 293, 7, 38, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[45327, 1243, 63, 1, 40, 47, 0, "StyleData", "MainBookLink", \
"Presentation"],
Cell[45393, 1246, 60, 1, 35, 44, 0, "StyleData", "MainBookLink", \
"Condensed"],
Cell[45456, 1249, 44, 0, 38, 44, 0, "StyleData", "MainBookLink", \
"SlideShow"],
Cell[45503, 1251, 126, 3, 35, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[45666, 1259, 314, 8, 37, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[45983, 1269, 61, 1, 40, 45, 0, "StyleData", "AddOnsLink", \
"Presentation"],
Cell[46047, 1272, 58, 1, 35, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[46108, 1275, 42, 0, 37, 42, 0, "StyleData", "AddOnsLink", "SlideShow"],
Cell[46153, 1277, 124, 3, 35, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[46314, 1285, 318, 8, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[46635, 1295, 63, 1, 40, 47, 0, "StyleData", "RefGuideLink", \
"Presentation"],
Cell[46701, 1298, 60, 1, 35, 44, 0, "StyleData", "RefGuideLink", \
"Condensed"],
Cell[46764, 1301, 44, 0, 37, 44, 0, "StyleData", "RefGuideLink", \
"SlideShow"],
Cell[46811, 1303, 126, 3, 35, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[46974, 1311, 297, 7, 38, 35, 0, "StyleData", "RefGuideLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[47274, 1320, 67, 1, 40, 51, 0, "StyleData", "RefGuideLinkText", \
"Presentation"],
Cell[47344, 1323, 64, 1, 35, 48, 0, "StyleData", "RefGuideLinkText", \
"Condensed"],
Cell[47411, 1326, 48, 0, 38, 48, 0, "StyleData", "RefGuideLinkText", \
"SlideShow"],
Cell[47462, 1328, 130, 3, 35, 47, 0, "StyleData", "RefGuideLinkText", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[47629, 1336, 305, 7, 38, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[47937, 1345, 69, 1, 40, 53, 0, "StyleData", "GettingStartedLink", \
"Presentation"],
Cell[48009, 1348, 66, 1, 35, 50, 0, "StyleData", "GettingStartedLink", \
"Condensed"],
Cell[48078, 1351, 50, 0, 38, 50, 0, "StyleData", "GettingStartedLink", \
"SlideShow"],
Cell[48131, 1353, 132, 3, 35, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[48300, 1361, 287, 7, 38, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[48590, 1370, 41, 0, 38, 41, 0, "StyleData", "DemosLink", "SlideShow"],
Cell[48634, 1372, 107, 2, 38, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[48778, 1379, 285, 7, 38, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[49066, 1388, 40, 0, 38, 40, 0, "StyleData", "TourLink", "SlideShow"],
Cell[49109, 1390, 106, 2, 38, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[49252, 1397, 309, 7, 38, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[49564, 1406, 71, 1, 40, 55, 0, "StyleData", "OtherInformationLink", \
"Presentation"],
Cell[49638, 1409, 68, 1, 35, 52, 0, "StyleData", "OtherInformationLink", \
"Condensed"],
Cell[49709, 1412, 52, 0, 38, 52, 0, "StyleData", "OtherInformationLink", \
"SlideShow"],
Cell[49764, 1414, 134, 3, 35, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[49935, 1422, 299, 7, 38, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[50237, 1431, 47, 0, 38, 47, 0, "StyleData", "MasterIndexLink", \
"SlideShow"],
Cell[50287, 1433, 113, 2, 38, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[50449, 1441, 33, 0, 39, "Section"],
Cell[50485, 1443, 121, 3, 70, "Text"],
Cell[50609, 1448, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[50838, 1455, 304, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[51145, 1464, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[51548, 1475, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[51938, 1486, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[52376, 1500, 37, 0, 39, "Section"],
Cell[52416, 1502, 115, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[52556, 1509, 145, 5, 70, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[52704, 1516, 43, 0, 70, 43, 0, "StyleData", "Placeholder", "Condensed"],
Cell[52750, 1518, 42, 0, 70, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[52829, 1523, 193, 6, 70, 39, 0, "StyleData", "SelectionPlaceholder", \
"All",
  StyleMenuListing->None],
Cell[53025, 1531, 71, 1, 70, 55, 0, "StyleData", "SelectionPlaceholder", \
"Presentation"],
Cell[53099, 1534, 52, 0, 70, 52, 0, "StyleData", "SelectionPlaceholder", \
"Condensed"],
Cell[53154, 1536, 51, 0, 70, 51, 0, "StyleData", "SelectionPlaceholder", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[53254, 1542, 36, 0, 39, "Section"],
Cell[53293, 1544, 258, 5, 70, "Text"],
Cell[53554, 1551, 314, 10, 70, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[53871, 1563, 135, 4, 70, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[54009, 1569, 150, 5, 70, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[54162, 1576, 341, 8, 70, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[54506, 1586, 412, 10, 70, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[54921, 1598, 115, 3, 70, "Text"],
Cell[55039, 1603, 96, 3, 70, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[55138, 1608, 104, 2, 70, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[55279, 1615, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[55340, 1619, 709, 21, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[56052, 1642, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[56254, 1649, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[56417, 1657, 1681, 40, 70, 35, 0, "StyleData", "SlideShowSection", "All",
  
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[58101, 1699, 109, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[58213, 1703, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[58314, 1707, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[58473, 1715, 327, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[58803, 1727, 101, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[58907, 1731, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[58956, 1733, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[59121, 1741, 341, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[59465, 1752, 98, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[59566, 1756, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[59613, 1758, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[59760, 1765, 166, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[59929, 1771, 94, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[60026, 1775, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[60085, 1778, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

