(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40520,       1403]*)
(*NotebookOutlinePosition[     41156,       1425]*)
(*  CellTagsIndexPosition[     41112,       1421]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "SansSerif"],
  PageWidth->WindowWidth,
  ScriptMinSize->7,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "SansSerifPrintout"],
  PageWidth->PaperWidth,
  ScriptMinSize->5,
  FontFamily->"Helvetica",
  FontSize->8,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  DefaultNewCellStyle->"Text",
  DefaultDuplicateCellStyle->"Text",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["H1"],
  CellMargins->{{12, Inherited}, {20, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  ConversionRules:>{"HTML" -> {{"<span class='H1'>", "</span>"}, {
    "<h1 class='H1'>", "</h1>"}}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 13},
  CounterIncrements->"H1",
  CounterAssignments->{{"H2", 0}, {"H3", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H4", 0}, {"H5", 0}, {"H6", 0}},
  FontSize->36,
  FontWeight->"Bold"],

Cell[StyleData["H1", "Presentation"],
  CellMargins->{{18, 10}, {40, 62}},
  FontSize->54],

Cell[StyleData["H1", "SansSerif"],
  FontSize->30,
  FontWeight->"Bold"],

Cell[StyleData["H1", "SlideShow"]],

Cell[StyleData["H1", "Printout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->30],

Cell[StyleData["H1", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->26]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H2"],
  CellMargins->{{12, Inherited}, {10, 15}},
  CellGroupingRules->{"TitleGrouping", 10},
  ConversionRules:>{"HTML" -> {{"<span class='H2'>", "</span>"}, {
    "<h2 class='H2'>", "</h2>"}}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"H2",
  CounterAssignments->{{"H3", 0}, {"H4", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H5", 0}, {"H6", 0}},
  FontSize->24,
  FontWeight->"Bold"],

Cell[StyleData["H2", "Presentation"],
  CellMargins->{{18, 10}, {24, 18}},
  FontSize->36],

Cell[StyleData["H2", "SansSerif"],
  FontSize->20],

Cell[StyleData["H2", "SlideShow"]],

Cell[StyleData["H2", "Printout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontSize->20],

Cell[StyleData["H2", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H3"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  ConversionRules:>{"HTML" -> {{"<span class='H3'>", "</span>"}, {
    "<h3 class='H3'>", "</h3>"}}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"H3",
  CounterAssignments->{{"H4", 0}, {"H5", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H6", 0}},
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["H3", "Presentation"],
  CellMargins->{{18, 10}, {20, 22}},
  FontSize->27],

Cell[StyleData["H3", "SansSerif"],
  FontSize->16],

Cell[StyleData["H3", "SlideShow"]],

Cell[StyleData["H3", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->16],

Cell[StyleData["H3", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H4"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  ConversionRules:>{"HTML" -> {{"<span class='H4'>", "</span>"}, {
    "<h4 class='H4'>", "</h4>"}}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"H4",
  CounterAssignments->{{"H5", 0}, {"H6", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["H4", "Presentation"],
  CellMargins->{{16, 10}, {18, 22}},
  FontSize->21],

Cell[StyleData["H4", "SansSerif"],
  FontSize->12],

Cell[StyleData["H4", "SlideShow"]],

Cell[StyleData["H4", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->12],

Cell[StyleData["H4", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H5"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  ConversionRules:>{"HTML" -> {{"<span class='H5'>", "</span>"}, {
    "<h5 class='H5'>", "</h5>"}}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"H5",
  CounterAssignments->{{"H6", 0}},
  FontWeight->"Bold"],

Cell[StyleData["H5", "Presentation"],
  CellMargins->{{18, 10}, {20, 26}},
  FontSize->18],

Cell[StyleData["H5", "SansSerif"]],

Cell[StyleData["H5", "SlideShow"]],

Cell[StyleData["H5", "Printout"],
  CellMargins->{{2, 10}, {8, 10}}],

Cell[StyleData["H5", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H6"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 50},
  ConversionRules:>{"HTML" -> {{"<span class='H6'>", "</span>"}, {
    "<h6 class='H6'>", "</h6>"}}},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"H6",
  FontSize->10,
  FontWeight->"Bold"],

Cell[StyleData["H6", "Presentation"],
  CellMargins->{{18, 10}, {20, 26}},
  FontSize->15],

Cell[StyleData["H6", "SansSerif"],
  FontSize->9,
  FontTracking->"Extended"],

Cell[StyleData["H6", "SlideShow"]],

Cell[StyleData["H6", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->8.5],

Cell[StyleData["H6", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->7.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Body"],
  CellMargins->{{14, 10}, {7, 7}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 3},
  CounterIncrements->"Body"],

Cell[StyleData["Body", "Presentation"],
  CellMargins->{{20, 10}, {10, 10}},
  FontSize->18],

Cell[StyleData["Body", "SansSerif"]],

Cell[StyleData["Body", "SlideShow"]],

Cell[StyleData["Body", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}],

Cell[StyleData["Body", "SansSerifPrintout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LI"],
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{23, 10}, {7, 7}},
  ConversionRules:>{"HTML" -> {{"<span class='LI'>", "</span>"}, {
    "<ul class='LI'><li class='LI'>", "</li></ul>"}}},
  LineSpacing->{1, 3},
  CounterIncrements->"LI"],

Cell[StyleData["LI", "Presentation"],
  CellMargins->{{32, 10}, {10, 10}},
  FontSize->18],

Cell[StyleData["LI", "SansSerif"],
  CellMargins->{{25, 10}, {7, 7}}],

Cell[StyleData["LI", "SlideShow"]],

Cell[StyleData["LI", "Printout"],
  CellMargins->{{12, 2}, {6, 6}}],

Cell[StyleData["LI", "SansSerifPrintout"],
  CellMargins->{{12, 2}, {6, 6}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{64, 10}, {6, 10}},
  FontSize->18],

Cell[StyleData["Input", "SansSerif"],
  FontSize->12],

Cell[StyleData["Input", "SlideShow"]],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->9],

Cell[StyleData["Input", "SansSerifPrintout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{66, 10}, {10, 6}},
  FontSize->18],

Cell[StyleData["Output", "SansSerif"],
  FontSize->12],

Cell[StyleData["Output", "SlideShow"]],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9],

Cell[StyleData["Output", "SansSerifPrintout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{64, 10}, {6, 6}},
  FontSize->18],

Cell[StyleData["Message", "SansSerif"],
  FontSize->12],

Cell[StyleData["Message", "SlideShow"]],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "SansSerifPrintout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{64, 10}, {6, 6}},
  FontSize->18],

Cell[StyleData["Print", "SansSerif"],
  FontSize->12],

Cell[StyleData["Print", "SlideShow"]],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8],

Cell[StyleData["Print", "SansSerifPrintout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  CellMargins->{{64, 10}, {6, 6}},
  FontSize->18],

Cell[StyleData["Graphics", "SansSerif"],
  FontSize->12],

Cell[StyleData["Graphics", "SlideShow"]],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontSize->9],

Cell[StyleData["Graphics", "SansSerifPrintout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->14],

Cell[StyleData["CellLabel", "SansSerif"]],

Cell[StyleData["CellLabel", "SlideShow"]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "SansSerifPrintout"],
  FontSize->7,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"],
  FontSize->16],

Cell[StyleData["Hyperlink", "Condensed"],
  FontSize->11],

Cell[StyleData["Hyperlink", "SlideShow"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"],
  FontSize->16],

Cell[StyleData["MainBookLink", "Condensed"],
  FontSize->11],

Cell[StyleData["MainBookLink", "SlideShow"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"],
  FontSize->16],

Cell[StyleData["AddOnsLink", "Condensed"],
  FontSize->11],

Cell[StyleData["AddOnsLink", "SlideShow"]],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLink", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLink", "SlideShow"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLinkText", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLinkText", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLinkText", "SlideShow"]],

Cell[StyleData["RefGuideLinkText", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"],
  FontSize->16],

Cell[StyleData["GettingStartedLink", "Condensed"],
  FontSize->11],

Cell[StyleData["GettingStartedLink", "SlideShow"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "SlideShow"]],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "SlideShow"]],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"],
  FontSize->16],

Cell[StyleData["OtherInformationLink", "Condensed"],
  FontSize->11],

Cell[StyleData["OtherInformationLink", "SlideShow"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "SlideShow"]],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "Presentation"]],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  CellFrameMargins->{{20, 10}, {10, 18}},
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
  CellMargins->{{14, 10}, {6, 12}},
  FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
  CellMargins->{{35, 10}, {8, 8}},
  FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
  CellMargins->{{25, 10}, {10, 5}},
  FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
WindowSize->{500, 500},
WindowMargins->{{1, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 88, "Title"],
Cell[1813, 55, 193, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[2031, 63, 42, 0, 69, "Section"],
Cell[2076, 65, 77, 2, 38, 31, 0, "StyleData", "All", "Working"],
Cell[2156, 69, 82, 2, 38, 36, 0, "StyleData", "All", "Presentation"],
Cell[2241, 73, 122, 4, 35, 33, 0, "StyleData", "All", "SansSerif"],
Cell[2366, 79, 182, 5, 38, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2551, 86, 140, 4, 34, 32, 0, "StyleData", "All", "Printout"],
Cell[2694, 92, 175, 5, 32, 41, 0, "StyleData", "All", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2906, 102, 35, 0, 39, "Section"],
Cell[2944, 104, 101, 3, 32, "Text"],
Cell[3048, 109, 494, 13, 38, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3579, 127, 38, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[3642, 131, 1659, 38, 112, 21, 0, "StyleData", "H1", "All",
  CounterIncrements->"H1",
  CounterAssignments->{{"H2", 0}, {"H3", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H4", 0}, {"H5", 0}, {"H6", 0}}],
Cell[5304, 171, 90, 2, 172, 37, 0, "StyleData", "H1", "Presentation"],
Cell[5397, 175, 72, 2, 106, 34, 0, "StyleData", "H1", "SansSerif"],
Cell[5472, 179, 34, 0, 112, 34, 0, "StyleData", "H1", "SlideShow"],
Cell[5509, 181, 85, 2, 91, 33, 0, "StyleData", "H1", "Printout"],
Cell[5597, 185, 94, 2, 87, 42, 0, "StyleData", "H1", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5728, 192, 1625, 37, 69, 21, 0, "StyleData", "H2", "All",
  CounterIncrements->"H2",
  CounterAssignments->{{"H3", 0}, {"H4", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H5", 0}, {"H6", 0}}],
Cell[7356, 231, 90, 2, 94, 37, 0, "StyleData", "H2", "Presentation"],
Cell[7449, 235, 50, 1, 61, 34, 0, "StyleData", "H2", "SansSerif"],
Cell[7502, 238, 34, 0, 69, 34, 0, "StyleData", "H2", "SlideShow"],
Cell[7539, 240, 85, 2, 61, 33, 0, "StyleData", "H2", "Printout"],
Cell[7627, 244, 94, 2, 62, 42, 0, "StyleData", "H2", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7758, 251, 1614, 37, 67, 21, 0, "StyleData", "H3", "All",
  CounterIncrements->"H3",
  CounterAssignments->{{"H4", 0}, {"H5", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H6", 0}}],
Cell[9375, 290, 90, 2, 85, 37, 0, "StyleData", "H3", "Presentation"],
Cell[9468, 294, 50, 1, 62, 34, 0, "StyleData", "H3", "SansSerif"],
Cell[9521, 297, 34, 0, 67, 34, 0, "StyleData", "H3", "SlideShow"],
Cell[9558, 299, 84, 2, 50, 33, 0, "StyleData", "H3", "Printout"],
Cell[9645, 303, 93, 2, 50, 42, 0, "StyleData", "H3", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9775, 310, 1598, 36, 62, 21, 0, "StyleData", "H4", "All",
  CounterIncrements->"H4",
  CounterAssignments->{{"H5", 0}, {"H6", 0}, {"Equation", 0}, {
      "Figure", 0}}],
Cell[11376, 348, 90, 2, 77, 37, 0, "StyleData", "H4", "Presentation"],
Cell[11469, 352, 50, 1, 60, 34, 0, "StyleData", "H4", "SansSerif"],
Cell[11522, 355, 34, 0, 62, 34, 0, "StyleData", "H4", "SlideShow"],
Cell[11559, 357, 84, 2, 48, 33, 0, "StyleData", "H4", "Printout"],
Cell[11646, 361, 93, 2, 45, 42, 0, "StyleData", "H4", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11776, 368, 1539, 35, 60, 21, 0, "StyleData", "H5", "All",
  CounterIncrements->"H5",
  CounterAssignments->{{"H6", 0}}],
Cell[13318, 405, 90, 2, 83, 37, 0, "StyleData", "H5", "Presentation"],
Cell[13411, 409, 34, 0, 60, 34, 0, "StyleData", "H5", "SansSerif"],
Cell[13448, 411, 34, 0, 60, 34, 0, "StyleData", "H5", "SlideShow"],
Cell[13485, 413, 68, 1, 48, 33, 0, "StyleData", "H5", "Printout"],
Cell[13556, 416, 77, 1, 48, 42, 0, "StyleData", "H5", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13670, 422, 1520, 35, 57, 21, 0, "StyleData", "H6", "All",
  CounterIncrements->"H6"],
Cell[15193, 459, 90, 2, 77, 37, 0, "StyleData", "H6", "Presentation"],
Cell[15286, 463, 77, 2, 56, 34, 0, "StyleData", "H6", "SansSerif"],
Cell[15366, 467, 34, 0, 57, 34, 0, "StyleData", "H6", "SlideShow"],
Cell[15403, 469, 85, 2, 44, 33, 0, "StyleData", "H6", "Printout"],
Cell[15491, 473, 94, 2, 42, 42, 0, "StyleData", "H6", "SansSerifPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15634, 481, 39, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[15698, 485, 1327, 30, 44, 23, 0, "StyleData", "Body", "All",
  CounterIncrements->"Body"],
Cell[17028, 517, 92, 2, 56, 39, 0, "StyleData", "Body", "Presentation"],
Cell[17123, 521, 36, 0, 44, 36, 0, "StyleData", "Body", "SansSerif"],
Cell[17162, 523, 36, 0, 44, 36, 0, "StyleData", "Body", "SlideShow"],
Cell[17201, 525, 68, 1, 42, 35, 0, "StyleData", "Body", "Printout"],
Cell[17272, 528, 77, 1, 42, 44, 0, "StyleData", "Body", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[17386, 534, 267, 6, 44, 21, 0, "StyleData", "LI", "All",
  CounterIncrements->"LI"],
Cell[17656, 542, 90, 2, 56, 37, 0, "StyleData", "LI", "Presentation"],
Cell[17749, 546, 69, 1, 44, 34, 0, "StyleData", "LI", "SansSerif"],
Cell[17821, 549, 34, 0, 44, 34, 0, "StyleData", "LI", "SlideShow"],
Cell[17858, 551, 67, 1, 42, 33, 0, "StyleData", "LI", "Printout"],
Cell[17928, 554, 76, 1, 42, 42, 0, "StyleData", "LI", "SansSerifPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18053, 561, 36, 0, 39, "Section"],
Cell[18092, 563, 121, 3, 50, "Text"],
Cell[18216, 568, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[18311, 573, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[18383, 577, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[18456, 581, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[18574, 587, 116, 4, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[18693, 593, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[18810, 599, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[18929, 605, 233, 6, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[19165, 613, 234, 6, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[19402, 621, 232, 6, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[19637, 629, 234, 6, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[19874, 637, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[19996, 643, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[20119, 649, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[20240, 655, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[20385, 663, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[20526, 670, 149, 5, 31, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[20712, 680, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[20819, 684, 90, 2, 38, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20958, 692, 42, 0, 39, "Section"],
Cell[21003, 694, 248, 5, 68, "Text"],

Cell[CellGroupData[{
Cell[21276, 703, 659, 18, 42, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[21938, 723, 92, 2, 53, 40, 0, "StyleData", "Input", "Presentation"],
Cell[22033, 727, 53, 1, 42, 37, 0, "StyleData", "Input", "SansSerif"],
Cell[22089, 730, 37, 0, 42, 37, 0, "StyleData", "Input", "SlideShow"],
Cell[22129, 732, 130, 3, 36, 36, 0, "StyleData", "Input", "Printout"],
Cell[22262, 737, 94, 2, 36, 45, 0, "StyleData", "Input", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22393, 744, 601, 16, 42, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[22997, 762, 93, 2, 52, 41, 0, "StyleData", "Output", "Presentation"],
Cell[23093, 766, 54, 1, 42, 38, 0, "StyleData", "Output", "SansSerif"],
Cell[23150, 769, 38, 0, 42, 38, 0, "StyleData", "Output", "SlideShow"],
Cell[23191, 771, 86, 2, 36, 37, 0, "StyleData", "Output", "Printout"],
Cell[23280, 775, 95, 2, 36, 46, 0, "StyleData", "Output", \
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23412, 782, 670, 17, 38, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[24085, 801, 93, 2, 48, 42, 0, "StyleData", "Message", "Presentation"],
Cell[24181, 805, 55, 1, 38, 39, 0, "StyleData", "Message", "SansSerif"],
Cell[24239, 808, 39, 0, 38, 39, 0, "StyleData", "Message", "SlideShow"],
Cell[24281, 810, 138, 3, 32, 38, 0, "StyleData", "Message", "Printout"],
Cell[24422, 815, 147, 3, 32, 47, 0, "StyleData", "Message", \
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24606, 823, 614, 16, 38, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[25223, 841, 91, 2, 48, 40, 0, "StyleData", "Print", "Presentation"],
Cell[25317, 845, 53, 1, 38, 37, 0, "StyleData", "Print", "SansSerif"],
Cell[25373, 848, 37, 0, 38, 37, 0, "StyleData", "Print", "SlideShow"],
Cell[25413, 850, 109, 2, 32, 36, 0, "StyleData", "Print", "Printout"],
Cell[25525, 854, 118, 2, 32, 45, 0, "StyleData", "Print", \
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25680, 861, 440, 12, 38, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[26123, 875, 94, 2, 48, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[26220, 879, 56, 1, 38, 40, 0, "StyleData", "Graphics", "SansSerif"],
Cell[26279, 882, 40, 0, 38, 40, 0, "StyleData", "Graphics", "SlideShow"],
Cell[26322, 884, 137, 3, 34, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[26462, 889, 146, 3, 34, 48, 0, "StyleData", "Graphics", \
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26645, 897, 128, 4, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[26776, 903, 60, 1, 40, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[26839, 906, 41, 0, 34, 41, 0, "StyleData", "CellLabel", "SansSerif"],
Cell[26883, 908, 41, 0, 34, 41, 0, "StyleData", "CellLabel", "SlideShow"],
Cell[26927, 910, 130, 4, 32, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[27060, 916, 91, 2, 31, 49, 0, "StyleData", "CellLabel", \
"SansSerifPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27200, 924, 35, 0, 39, "Section"],
Cell[27238, 926, 184, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[27447, 934, 302, 8, 38, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[27752, 944, 60, 1, 40, 44, 0, "StyleData", "Hyperlink", "Presentation"],
Cell[27815, 947, 57, 1, 35, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[27875, 950, 41, 0, 38, 41, 0, "StyleData", "Hyperlink", "SlideShow"],
Cell[27919, 952, 123, 3, 35, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[28057, 958, 104, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[28186, 965, 293, 7, 38, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[28482, 974, 63, 1, 40, 47, 0, "StyleData", "MainBookLink", \
"Presentation"],
Cell[28548, 977, 60, 1, 35, 44, 0, "StyleData", "MainBookLink", "Condensed"],
Cell[28611, 980, 44, 0, 38, 44, 0, "StyleData", "MainBookLink", "SlideShow"],
Cell[28658, 982, 126, 3, 35, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28821, 990, 314, 8, 37, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[29138, 1000, 61, 1, 40, 45, 0, "StyleData", "AddOnsLink", \
"Presentation"],
Cell[29202, 1003, 58, 1, 35, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[29263, 1006, 42, 0, 37, 42, 0, "StyleData", "AddOnsLink", "SlideShow"],
Cell[29308, 1008, 124, 3, 35, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29469, 1016, 318, 8, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[29790, 1026, 63, 1, 40, 47, 0, "StyleData", "RefGuideLink", \
"Presentation"],
Cell[29856, 1029, 60, 1, 35, 44, 0, "StyleData", "RefGuideLink", \
"Condensed"],
Cell[29919, 1032, 44, 0, 37, 44, 0, "StyleData", "RefGuideLink", \
"SlideShow"],
Cell[29966, 1034, 126, 3, 35, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30129, 1042, 297, 7, 38, 35, 0, "StyleData", "RefGuideLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[30429, 1051, 67, 1, 40, 51, 0, "StyleData", "RefGuideLinkText", \
"Presentation"],
Cell[30499, 1054, 64, 1, 35, 48, 0, "StyleData", "RefGuideLinkText", \
"Condensed"],
Cell[30566, 1057, 48, 0, 38, 48, 0, "StyleData", "RefGuideLinkText", \
"SlideShow"],
Cell[30617, 1059, 130, 3, 35, 47, 0, "StyleData", "RefGuideLinkText", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30784, 1067, 305, 7, 38, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[31092, 1076, 69, 1, 40, 53, 0, "StyleData", "GettingStartedLink", \
"Presentation"],
Cell[31164, 1079, 66, 1, 35, 50, 0, "StyleData", "GettingStartedLink", \
"Condensed"],
Cell[31233, 1082, 50, 0, 38, 50, 0, "StyleData", "GettingStartedLink", \
"SlideShow"],
Cell[31286, 1084, 132, 3, 35, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31455, 1092, 287, 7, 38, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[31745, 1101, 41, 0, 38, 41, 0, "StyleData", "DemosLink", "SlideShow"],
Cell[31789, 1103, 107, 2, 38, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31933, 1110, 285, 7, 38, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[32221, 1119, 40, 0, 38, 40, 0, "StyleData", "TourLink", "SlideShow"],
Cell[32264, 1121, 106, 2, 38, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32407, 1128, 309, 7, 38, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[32719, 1137, 71, 1, 40, 55, 0, "StyleData", "OtherInformationLink", \
"Presentation"],
Cell[32793, 1140, 68, 1, 35, 52, 0, "StyleData", "OtherInformationLink", \
"Condensed"],
Cell[32864, 1143, 52, 0, 38, 52, 0, "StyleData", "OtherInformationLink", \
"SlideShow"],
Cell[32919, 1145, 134, 3, 35, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33090, 1153, 299, 7, 38, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[33392, 1162, 47, 0, 38, 47, 0, "StyleData", "MasterIndexLink", \
"SlideShow"],
Cell[33442, 1164, 113, 2, 38, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33604, 1172, 33, 0, 39, "Section"],
Cell[33640, 1174, 121, 3, 50, "Text"],
Cell[33764, 1179, 226, 5, 38, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[33993, 1186, 304, 7, 38, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34300, 1195, 400, 9, 38, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34703, 1206, 387, 9, 38, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35093, 1217, 401, 9, 38, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[35531, 1231, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[35592, 1235, 709, 21, 33, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[36304, 1258, 57, 0, 70, 57, 0, "StyleData", "SlideShowNavigationBar", \
"Presentation"],
Cell[36364, 1260, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[36566, 1267, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36729, 1275, 1681, 40, 69, 35, 0, "StyleData", "SlideShowSection", "All",
  
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[38413, 1317, 109, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[38525, 1321, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[38626, 1325, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38785, 1333, 327, 10, 50, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[39115, 1345, 101, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[39219, 1349, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[39268, 1351, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39433, 1359, 341, 9, 38, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[39777, 1370, 98, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[39878, 1374, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[39925, 1376, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40072, 1383, 166, 4, 38, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[40241, 1389, 95, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[40339, 1393, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[40398, 1396, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

