(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    237494,       8913]*)
(*NotebookOutlinePosition[    238555,       8948]*)
(*  CellTagsIndexPosition[    238435,       8941]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions for Online Help", "Title"],

Cell["\<\
These styles are carefully tuned for all aspects of the online help. It's \
recommended that they remain unchanged.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ShowCellBracket->False,
  CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
  ShowAutoStyles->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Brackets"],
  PageWidth->WindowWidth,
  ShowCellBracket->True,
  CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
  ShowAutoStyles->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ShowCellBracket->False,
  CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
  ShowAutoStyles->False,
  ScriptMinSize->9],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ShowCellBracket->False,
  ShowAutoStyles->False,
  ScriptMinSize->5,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "EnhancedPrintout"],
  PageWidth->PaperWidth,
  ShowCellBracket->True,
  ScriptMinSize->5,
  FontFamily->"Palatino",
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "EnhancedPrintoutNonGray"],
  PageWidth->PaperWidth,
  ShowCellBracket->False,
  ScriptMinSize->5,
  FontFamily->"Palatino",
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
  The options defined for the style below will be used at the Notebook level. \
 \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {"Printed from the ", 
            StyleBox[ "Mathematica", FontSlant -> "Italic"], 
            " Help Browser"}], "PageHeader"]}, {Cell[ 
          TextData[ {"Printed from the ", 
            StyleBox[ "Mathematica", FontSlant -> "Italic"], 
            " Help Browser"}], "PageHeader"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageFooters->{{None, Cell[ 
          
          TextData[ {
            "\[Copyright]1988-2005 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
          
          TextData[ {
            "\[Copyright]1988-2005 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
  PageHeaderLines->{True, True},
  PageFooterLines->{True, True},
  PrintingOptions->{"FacingPages"->True},
  CellLabelAutoDelete->False,
  CellFrameLabelMargins->6,
  StyleMenuListing->None],

Cell[StyleData["Notebook", "Printout"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {"Printed from the ", 
            StyleBox[ "Mathematica", FontSlant -> "Italic"], 
            " Help Browser"}], "PageHeader"]}, {Cell[ 
          TextData[ {"Printed from the ", 
            StyleBox[ "Mathematica", FontSlant -> "Italic"], 
            " Help Browser"}], "PageHeader"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageFooters->{{None, Cell[ 
          
          TextData[ {
            "\[Copyright]1988-2005 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
          
          TextData[ {
            "\[Copyright]1988-2005 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
  PageHeaderLines->{True, True},
  PageFooterLines->{True, True},
  PrintingOptions->{"FacingPages"->True}],

Cell[StyleData["Notebook", "EnhancedPrintout"],
  PageFooters->{{None, None, None}, {None, None, None}},
  PageHeaderLines->{True, True},
  PageFooterLines->{False, False},
  PrintingOptions->{"PrintingMargins"->{{54, 54}, {36, 72}},
  "PageSize"->{594, 657},
  "PrintRegistrationMarks"->True,
  "FirstPageHeader"->False,
  "FacingPages"->True,
  "FirstPageFace"->Right}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Chapter"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{27, 27}, {10, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Chapter",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->28,
  FontWeight->"Plain",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Chapter", "Presentation"],
  FontSize->36],

Cell[StyleData["Chapter", "Printout"],
  CellMargins->{{2, 10}, {6, 30}},
  FontSize->24],

Cell[StyleData["Chapter", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {6, 30}},
  FontFamily->"Frutiger-Roman",
  FontSize->24,
  FontColor->GrayLevel[0]],

Cell[StyleData["Chapter", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {6, 30}},
  FontFamily->"Frutiger-Roman",
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellMargins->{{27, 27}, {9, 30}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Section", "Presentation"],
  FontSize->30],

Cell[StyleData["Section", "SlideShow"],
  CellFrame->{{0, 0}, {0, 0.5}},
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {5, 0}},
  PageBreakBelow->False,
  CellFrameMargins->{{36, 36}, {Inherited, 15}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->18],

Cell[StyleData["Section", "EnhancedPrintout"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{2, 2}, {5, 30}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->8,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Frutiger-Bold",
  FontSize->16,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["Section", "EnhancedPrintoutNonGray"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{2, Inherited}, {5, 30}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->8,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Frutiger-Bold",
  FontSize->16,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->None,
  CellMargins->{{27, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Subsection", "Presentation"],
  FontSize->24],

Cell[StyleData["Subsection", "SlideShow"],
  CellDingbat->None,
  CellMargins->{{70, 0}, {4, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{2, 0}, {5, 24}},
  FontSize->12],

Cell[StyleData["Subsection", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {5, 20}},
  FontFamily->"Frutiger-Bold",
  FontSize->12,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["Subsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{9, 0}, {5, 20}},
  FontFamily->"Frutiger-Bold",
  FontSize->12,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{27, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Subsubsection", "Presentation"],
  FontSize->18],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{2, 0}, {3, 8}},
  FontSize->10],

Cell[StyleData["Subsubsection", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {3, 8}},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["Subsubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {3, 8}},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionColor"],
  CellMargins->{{27, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 50},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->RGBColor[0.297993, 0, 0.454994]],

Cell[StyleData["SubsubsectionColor", "Presentation"],
  FontSize->18],

Cell[StyleData["SubsubsectionColor", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionIcon"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{46, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->8},
  CellGroupingRules->{"SectionGrouping", 40},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  CounterIncrements->"Subsection",
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsectionIcon", "Presentation"],
  FontSize->24],

Cell[StyleData["SubsectionIcon", "Printout"],
  CellDingbat->"\[FilledSquare]",
  ShowGroupOpenCloseIcon->False,
  CellMargins->{{16, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionIcon"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{46, 27}, {0, 8}},
  CellElementSpacings->{"ClosedGroupTopMargin"->4},
  CellGroupingRules->{"SectionGrouping", 50},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsubsectionIcon", "Presentation"],
  FontSize->18],

Cell[StyleData["SubsubsectionIcon", "Printout"],
  ShowGroupOpenCloseIcon->False,
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{27, 27}, {0, 8}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text",
  FontSize->12],

Cell[StyleData["Text", "Presentation"],
  FontSize->18],

Cell[StyleData["Text", "SlideShow"],
  CellMargins->{{36, 24}, {4, 4}},
  Hyphenation->False,
  FontSize->14],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["Text", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Text", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CompactText"],
  CellMargins->{{27, 27}, {0, 8}},
  ParagraphSpacing->{0, 0},
  StyleMenuListing->None,
  FontSize->10],

Cell[StyleData["CompactText", "Presentation"],
  FontSize->15],

Cell[StyleData["CompactText", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontSize->8],

Cell[StyleData["CompactText", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->8],

Cell[StyleData["CompactText", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Compact12Text"],
  CellMargins->{{27, 27}, {0, 8}},
  ParagraphSpacing->{0, 0},
  StyleMenuListing->None],

Cell[StyleData["Compact12Text", "Presentation"],
  FontSize->18],

Cell[StyleData["Compact12Text", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["Compact12Text", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Compact12Text", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextSans"],
  CellMargins->{{27, 27}, {0, 8}},
  CellHorizontalScrolling->True,
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["TextSans", "Presentation"],
  FontSize->15],

Cell[StyleData["TextSans", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontSize->8],

Cell[StyleData["TextSans", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontFamily->"Frutiger-Roman",
  FontSize->8],

Cell[StyleData["TextSans", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontFamily->"Frutiger-Roman",
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedText"],
  CellMargins->{{66, 4}, {4, 4}},
  LineSpacing->{1, 3},
  ParagraphIndent->-22,
  CounterIncrements->"ItemizedText",
  StyleMenuListing->None],

Cell[StyleData["ItemizedText", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedText", "Printout"],
  CellMargins->{{16, 4}, {2, 4}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["ItemizedText", "EnhancedPrintout"],
  CellMargins->{{16, 4}, {2, 4}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedText", "EnhancedPrintoutNonGray"],
  Hyphenation->True,
  LineSpacing->{1, 1},
  ParagraphIndent->-18,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote"],
  CellMargins->{{88, 4}, {4, 0}},
  LineSpacing->{1, 2},
  CounterIncrements->"ItemizedTextNote",
  StyleMenuListing->None],

Cell[StyleData["ItemizedTextNote", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedTextNote", "Printout"],
  CellMargins->{{34, 4}, {4, 1}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["ItemizedTextNote", "EnhancedPrintout"],
  CellMargins->{{39, 4}, {4, 1}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 4}, {4, 1}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
  CellMargins->{{66, 4}, {0, 6}},
  LineSpacing->{1, 3},
  CounterIncrements->"IndentedText",
  StyleMenuListing->None],

Cell[StyleData["IndentedText", "Presentation"],
  FontSize->18],

Cell[StyleData["IndentedText", "SlideShow"],
  CellMargins->{{80, 24}, {5, 5}},
  Hyphenation->False,
  FontSize->13],

Cell[StyleData["IndentedText", "Printout"],
  CellMargins->{{16, 4}, {2, 4}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["IndentedText", "EnhancedPrintout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["IndentedText", "EnhancedPrintoutNonGray"],
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedList"],
  CellMargins->{{58, 4}, {4, 4}},
  CellFrameLabels->{{Cell[ 
          TextData[ {
            StyleBox[ 
              CounterBox[ "ItemizedList"], "TB"], 
            StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {24,
           Inherited}, TextAlignment -> Right], Inherited}, {
      Inherited, Inherited}},
  LineSpacing->{1, 3},
  CounterIncrements->"ItemizedList",
  StyleMenuListing->None],

Cell[StyleData["ItemizedList", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedList", "Printout"],
  CellMargins->{{9, 4}, {2, 4}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["ItemizedList", "EnhancedPrintout"],
  CellMargins->{{9, 4}, {2, 4}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedList", "EnhancedPrintoutNonGray"],
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedSubList"],
  CellMargins->{{92, 4}, {4, 4}},
  CellFrameLabels->{{Cell[ 
          TextData[ {
            StyleBox[ 
              CounterBox[ "ItemizedSubList"], "TB"], 
            StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {24,
           Inherited}, TextAlignment -> Right], Inherited}, {
      Inherited, Inherited}},
  CounterIncrements->"ItemizedSubList",
  StyleMenuListing->None,
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "a", "z"], #]&)}],

Cell[StyleData["ItemizedSubList", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedSubList", "Printout"],
  CellMargins->{{34, 4}, {4, 1}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["ItemizedSubList", "EnhancedPrintout"],
  CellMargins->{{26, 4}, {2, 4}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedSubList", "EnhancedPrintoutNonGray"],
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedSubListNote"],
  CellMargins->{{110, 4}, {4, 4}},
  CounterIncrements->"ItemizedSubList",
  StyleMenuListing->None,
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "a", "z"], #]&)}],

Cell[StyleData["ItemizedSubListNote", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedSubListNote", "Printout"],
  CellMargins->{{34, 4}, {4, 1}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["ItemizedSubListNote", "EnhancedPrintout"],
  CellMargins->{{56, 4}, {2, 4}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedSubListNote", "EnhancedPrintoutNonGray"],
  CellMargins->{{48, 4}, {2, 4}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BulletedList"],
  CellMargins->{{76, 4}, {4, 4}},
  CellFrameLabels->{{
    Cell[ "\[Bullet]", "BulletedList", CellBaseline -> Baseline], 
        Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 3},
  CounterIncrements->"BulletText",
  StyleMenuListing->None],

Cell[StyleData["BulletedList", "Presentation"],
  FontSize->18],

Cell[StyleData["BulletedList", "Printout"],
  CellMargins->{{16, 4}, {4, 1}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["BulletedList", "EnhancedPrintout"],
  CellMargins->{{26, 4}, {2, 4}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["BulletedList", "EnhancedPrintoutNonGray"],
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListNote"],
  CellMargins->{{88, 4}, {4, 0}},
  LineSpacing->{1, 2},
  CounterIncrements->"ListNote",
  StyleMenuListing->None],

Cell[StyleData["ListNote", "Presentation"],
  FontSize->18],

Cell[StyleData["ListNote", "Printout"],
  CellMargins->{{34, 4}, {4, 1}},
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["ListNote", "EnhancedPrintout"],
  CellMargins->{{39, 4}, {4, 1}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ListNote", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 4}, {4, 1}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{66, 12}, {2, 20}},
  PageBreakBelow->False,
  CellFrameMargins->{{8, 8}, {8, 2}},
  CellFrameColor->GrayLevel[0.700008],
  CellFrameLabelMargins->4,
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8},
  FontColor->GrayLevel[0.2]],

Cell[StyleData["MathCaption", "Presentation"],
  FontSize->18],

Cell[StyleData["MathCaption", "SlideShow"],
  ShowCellBracket->False,
  CellMargins->{{36, 36}, {6, 6}}],

Cell[StyleData["MathCaption", "Printout"],
  CellMargins->{{9, 0}, {0, 14}},
  Hyphenation->True,
  FontSize->9,
  FontColor->GrayLevel[0]],

Cell[StyleData["MathCaption", "EnhancedPrintout"],
  CellMargins->{{9, 0}, {0, 14}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->9,
  FontColor->GrayLevel[0]],

Cell[StyleData["MathCaption", "EnhancedPrintoutNonGray"],
  CellMargins->{{9, 0}, {0, 14}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{27, 27}, {0, 8}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"SmallText",
  FontSize->9],

Cell[StyleData["SmallText", "Presentation"],
  FontSize->14],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  TextJustification->1,
  Hyphenation->True,
  FontSize->7],

Cell[StyleData["SmallText", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {5, 5}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->7],

Cell[StyleData["SmallText", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {5, 5}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names.    \
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {3, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Mathematica",
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  FontSize->18],

Cell[StyleData["Input", "SlideShow"],
  ShowCellBracket->True,
  CellMargins->{{100, 50}, {0, 6}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellFrameMargins->{{8, 8}, {4, 8}},
  Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["Input", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9],

Cell[StyleData["Input", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9],

Cell[StyleData["Input", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {8, 2}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->None,
  FormatType->StandardForm],

Cell[StyleData["Output", "Presentation"],
  FontSize->18],

Cell[StyleData["Output", "SlideShow"],
  ShowCellBracket->True,
  CellMargins->{{100, 50}, {6, 0}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellFrameMargins->{{8, 8}, {8, 4}},
  Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["Output", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9],

Cell[StyleData["Output", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9],

Cell[StyleData["Output", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {8, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Mathematica",
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["InputOnly", "Presentation"],
  FontSize->18],

Cell[StyleData["InputOnly", "SlideShow"],
  ShowCellBracket->True,
  CellMargins->{{100, 50}, {6, 6}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["InputOnly", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9],

Cell[StyleData["InputOnly", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9],

Cell[StyleData["InputOnly", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {4, 2}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->None,
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0.6, 0.100008, 0.100008]],

Cell[StyleData["Message", "Presentation"],
  FontSize->18],

Cell[StyleData["Message", "SlideShow"],
  CellMargins->{{100, 50}, {6, 6}},
  FontSize->10,
  FontColor->RGBColor[0.699992, 0.4, 0]],

Cell[StyleData["Message", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->9,
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier",
  FontSize->9,
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier",
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {4, 2}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->None,
  FormatType->InputForm,
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  FontSize->18],

Cell[StyleData["Print", "SlideShow"],
  CellMargins->{{100, 50}, {6, 6}}],

Cell[StyleData["Print", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{57, Inherited}, {Inherited, Inherited}},
  FontSize->9],

Cell[StyleData["Print", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{57, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier Std",
  FontSize->9],

Cell[StyleData["Print", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{57, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier Std",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  ShowCellBracket->True,
  CellMargins->{{66, 4}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultFormatTypeForOutput,
  LanguageCategory->None,
  FormatType->InputForm,
  StyleMenuListing->None,
  FontWeight->"Plain"],

Cell[StyleData["Graphics", "Presentation"],
  FontSize->18],

Cell[StyleData["Graphics", "SlideShow"],
  ShowCellBracket->True,
  CellMargins->{{100, 50}, {6, 0}},
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellFrameMargins->{{8, 8}, {4, 4}},
  Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["Graphics", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontSize->9],

Cell[StyleData["Graphics", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{32, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontFamily->"Courier Std",
  FontSize->9],

Cell[StyleData["Graphics", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{32, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontFamily->"Courier Std",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  LanguageCategory->None,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Plain",
  FontColor->RGBColor[0.269993, 0.308507, 0.6]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->14],

Cell[StyleData["CellLabel", "SlideShow"],
  FontColor->RGBColor[0.699992, 0.4, 0]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "EnhancedPrintout"],
  FontFamily->"Courier Std",
  FontSize->8,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std",
  FontSize->8,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Name"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontColor->RGBColor[0.269993, 0.308507, 0.6]],

Cell[StyleData["Name", "Presentation"],
  FontSize->14],

Cell[StyleData["Name", "Printout"],
  FontSize->7,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]],

Cell[StyleData["Name", "EnhancedPrintout"],
  FontFamily->"Frutiger-Italic",
  FontSize->7,
  FontSlant->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["Name", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Italic",
  FontSize->7,
  FontSlant->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlinks", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks. The others point to the various sections of the help browser. \
These styles will modify individual words or letters in a cell exclusive of \
the cell tag.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["Hyperlink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["Hyperlink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MainBookLinkMR"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLinkMR", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLinkMR", "EnhancedPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLinkMR", "EnhancedPrintoutNonGray"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLink", "EnhancedPrintout"],
  FontFamily->"WRICourier",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLink", "EnhancedPrintoutNonGray"],
  FontFamily->"WRICourier",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Times",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLinkText", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLinkText", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["RefGuideLink", "EnhancedPrintout"],
  FontFamily->"WRICourier",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["RefGuideLink", "EnhancedPrintoutNonGray"],
  FontFamily->"WRICourier",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["GettingStartedLink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["DemosLink", "EnhancedPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["DemosLink", "EnhancedPrintoutNonGray"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["TourLink", "EnhancedPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["TourLink", "EnhancedPrintoutNonGray"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLinkMR"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLinkMR", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintoutNonGray"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MasterIndexLink", "EnhancedPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MasterIndexLink", "EnhancedPrintoutNonGray"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NotebookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Times",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["NotebookLink", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["NotebookLink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["NotebookLink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NotebookLinkMR"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["NotebookLinkMR", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["NotebookLinkMR", "EnhancedPrintout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["NotebookLinkMR", "EnhancedPrintoutNonGray"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["JT"],
  StyleMenuListing->None,
  FontFamily->"JFontText"],

Cell[StyleData["JT", "Printout"]],

Cell[StyleData["JT", "EnhancedPrintout"]],

Cell[StyleData["JT", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["JS"],
  StyleMenuListing->None,
  FontFamily->"JFontSans"],

Cell[StyleData["JS", "Printout"]],

Cell[StyleData["JS", "EnhancedPrintout"]],

Cell[StyleData["JS", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["JSB"],
  StyleMenuListing->None,
  FontFamily->"JFontSansBold"],

Cell[StyleData["JSB", "Printout"]],

Cell[StyleData["JSB", "EnhancedPrintout"]],

Cell[StyleData["JSB", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["RM", "Printout"]],

Cell[StyleData["RM", "EnhancedPrintout"]],

Cell[StyleData["RM", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["BF", "Printout"]],

Cell[StyleData["BF", "EnhancedPrintout"]],

Cell[StyleData["BF", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["IT", "Printout"]],

Cell[StyleData["IT", "EnhancedPrintout"]],

Cell[StyleData["IT", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TR", "Printout"]],

Cell[StyleData["TR", "EnhancedPrintout"],
  FontFamily->"Palatino"],

Cell[StyleData["TR", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSlant->"Italic"],

Cell[StyleData["TI", "Printout"]],

Cell[StyleData["TI", "EnhancedPrintout"],
  FontFamily->"Palatino"],

Cell[StyleData["TI", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TB", "Printout"]],

Cell[StyleData["TB", "EnhancedPrintout"],
  FontFamily->"Palatino"],

Cell[StyleData["TB", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["TBI", "Printout"]],

Cell[StyleData["TBI", "EnhancedPrintout"],
  FontFamily->"Palatino"],

Cell[StyleData["TBI", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MR"],
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MR", "Printout"]],

Cell[StyleData["MR", "EnhancedPrintout"],
  FontFamily->"Courier Std"],

Cell[StyleData["MR", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MO"],
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MO", "Printout"],
  FontSlant->"Oblique"],

Cell[StyleData["MO", "EnhancedPrintout"],
  FontFamily->"Courier Std",
  FontSlant->"Oblique"],

Cell[StyleData["MO", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std",
  FontSlant->"Oblique"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MB"],
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MB", "Printout"]],

Cell[StyleData["MB", "EnhancedPrintout"],
  FontFamily->"Courier Std"],

Cell[StyleData["MB", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MBO"],
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MBO", "Printout"],
  FontSlant->"Oblique"],

Cell[StyleData["MBO", "EnhancedPrintout"],
  FontFamily->"Courier Std",
  FontSlant->"Oblique"],

Cell[StyleData["MBO", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std",
  FontSlant->"Oblique"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SR", "Printout"]],

Cell[StyleData["SR", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman"],

Cell[StyleData["SR", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Roman"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO", "EnhancedPrintout"],
  FontFamily->"Frutiger-Italic",
  FontSlant->"Plain"],

Cell[StyleData["SO", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Italic",
  FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SB", "Printout"],
  StyleMenuListing->None],

Cell[StyleData["SB", "EnhancedPrintout"],
  FontFamily->"Frutiger-Bold",
  FontWeight->"Plain"],

Cell[StyleData["SB", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Bold",
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SBColor"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBColor", "Printout"],
  StyleMenuListing->None],

Cell[StyleData["SBColor", "EnhancedPrintout"],
  FontFamily->"Frutiger-Bold",
  FontWeight->"Plain"],

Cell[StyleData["SBColor", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Bold",
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SBO", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SBO", "EnhancedPrintout"],
  FontFamily->"Frutiger-BoldItalic",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SBO", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-BoldItalic",
  FontWeight->"Plain",
  FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["M4"],
  ShowCellBracket->True,
  StyleMenuListing->None,
  FontFamily->"Mathematica4",
  CharacterEncoding->"Mathematica4"],

Cell[StyleData["M4", "Printout"],
  ShowCellBracket->True,
  StyleMenuListing->None,
  FontFamily->"Mathematica4",
  CharacterEncoding->"Mathematica4"],

Cell[StyleData["M4", "EnhancedPrintout"],
  ShowCellBracket->True,
  StyleMenuListing->None,
  FontFamily->"Mathematica4",
  CharacterEncoding->"Mathematica4"],

Cell[StyleData["M4", "EnhancedPrintoutNonGray"],
  ShowCellBracket->True,
  StyleMenuListing->None,
  FontFamily->"Mathematica4",
  CharacterEncoding->"Mathematica4"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->8,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "EnhancedPrintout"],
  StyleMenuListing->None,
  FontFamily->"Frutiger-Italic",
  FontSize->8,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO10", "EnhancedPrintoutNonGray"],
  StyleMenuListing->None,
  FontFamily->"Frutiger-Italic",
  FontSize->8,
  FontWeight->"Plain",
  FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["S9"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Plain"],

Cell[StyleData["S9", "Printout"],
  FontSize->9,
  FontWeight->"Plain"],

Cell[StyleData["S9", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman",
  FontSize->9,
  FontWeight->"Plain"],

Cell[StyleData["S9", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Roman",
  FontSize->9,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["S10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain"],

Cell[StyleData["S10", "Printout"],
  FontSize->10,
  FontWeight->"Plain"],

Cell[StyleData["S10", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman",
  FontSize->10,
  FontWeight->"Plain"],

Cell[StyleData["S10", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Roman",
  FontSize->10,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SB9"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold",
  PrivateFontOptions->{"OperatorSubstitution"->False}],

Cell[StyleData["SB9", "Printout"],
  FontSize->7],

Cell[StyleData["SB9", "EnhancedPrintout"],
  FontFamily->"Frutiger-Bold",
  FontSize->7,
  FontWeight->"Plain"],

Cell[StyleData["SB9", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Bold",
  FontSize->7,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SB10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Bold"],

Cell[StyleData["SB10", "Printout"],
  FontSize->8],

Cell[StyleData["SB10", "EnhancedPrintout"],
  FontFamily->"Frutiger-Bold",
  FontSize->8,
  FontWeight->"Plain"],

Cell[StyleData["SB10", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Bold",
  FontSize->8,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MR10"],
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  SingleLetterItalics->False,
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MR10", "Printout"],
  FontSize->7],

Cell[StyleData["MR10", "EnhancedPrintout"],
  FontFamily->"Courier Std",
  FontSize->7],

Cell[StyleData["MR10", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std",
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MO10"],
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  SingleLetterItalics->False,
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->10,
  FontSlant->"Italic"],

Cell[StyleData["MO10", "Printout"],
  FontSize->7],

Cell[StyleData["MO10", "EnhancedPrintout"],
  FontFamily->"Courier Std",
  FontSize->7],

Cell[StyleData["MO10", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std",
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["C1"],
  StyleMenuListing->None,
  FontColor->RGBColor[0.4, 0, 1]],

Cell[StyleData["C1", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["C1", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["C1", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["C1MR"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0.4, 0, 1]],

Cell[StyleData["C1MR", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["C1MR", "EnhancedPrintout"],
  FontFamily->"Courier Std",
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["C1MR", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std",
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallCaps"],
  StyleMenuListing->None,
  Magnification->0.8],

Cell[StyleData["SmallCaps", "Printout"]],

Cell[StyleData["SmallCaps", "EnhancedPrintout"],
  FontFamily->"Palatino"],

Cell[StyleData["SmallCaps", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["KeyboardChars"],
  StyleMenuListing->None,
  FontSize->12],

Cell[StyleData["KeyboardChars", "Printout"],
  FontSize->10],

Cell[StyleData["KeyboardChars", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["KeyboardChars", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["TMB Specific", "Subsection"],

Cell[StyleData["HeadingNumber"],
  StyleMenuListing->None]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Emphasis Boxes and Pictures", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Box"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["Box", "Presentation"],
  FontSize->18],

Cell[StyleData["Box", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Box", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Box", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->2,
  RowAlignments->Top}],

Cell[StyleData["DoubleBox", "Presentation"],
  FontSize->18],

Cell[StyleData["DoubleBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DoubleBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DoubleBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["1ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["1ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["1ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["1ColumnBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["1ColumnBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  SingleLetterItalics->False,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->{0.31, 0.67}}],

Cell[StyleData["2ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->9,
  Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->9,
  Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->9,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->0.46}],

Cell[StyleData["2ColumnEvenBox", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnEvenBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnEvenBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnEvenBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnSmallBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.35,
  ColumnAlignments->{Right, Left}}],

Cell[StyleData["2ColumnSmallBox", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnSmallBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnSmallBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnSmallBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->0.32}],

Cell[StyleData["3ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["3ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnSmallBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.24,
  ColumnAlignments->{Right, Center, Left}}],

Cell[StyleData["3ColumnSmallBox", "Presentation"],
  FontSize->18],

Cell[StyleData["3ColumnSmallBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnSmallBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnSmallBox", "EnhancedPrintoutNonGray"],
  CellFrame->0.5,
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  SingleLetterItalics->False,
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->{0.13, 0.35, 0.13, 0.35}}],

Cell[StyleData["4ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["4ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["4ColumnBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["4ColumnBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->0.202}],

Cell[StyleData["5ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["5ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->9,
  Background->GrayLevel[0.900008]],

Cell[StyleData["5ColumnBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->9,
  Background->GrayLevel[0.900008]],

Cell[StyleData["5ColumnBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->9,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxFrame->0.5,
  BoxMargins->True},
  GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],

Cell[StyleData["6ColumnBox", "Presentation"],
  FontSize->18],

Cell[StyleData["6ColumnBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["6ColumnBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["6ColumnBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FramedBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnAlignments->{Left}}],

Cell[StyleData["FramedBox", "Presentation"],
  FontSize->18],

Cell[StyleData["FramedBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["FramedBox", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["FramedBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox3Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.35, 0.2, 0.45},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox3Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox3Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox3Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox4Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.15, 0.35, 0.15, 0.35},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox4Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox4Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox4Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PrecedenceTable"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.3, 0.45, 0.2, 0.05},
  ColumnAlignments->{Left}}],

Cell[StyleData["PrecedenceTable", "Presentation"],
  FontSize->18],

Cell[StyleData["PrecedenceTable", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["PrecedenceTable", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["PrecedenceTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox5Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->0.2,
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox5Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox5Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox5Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox6Col"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox6Col", "Presentation"],
  FontSize->18],

Cell[StyleData["DefinitionBox6Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox6Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{27, 12}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopBox", "Presentation"],
  FontSize->18],

Cell[StyleData["TopBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[StyleData["TopBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  Background->GrayLevel[1]],

Cell[StyleData["TopBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{27, 12}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleBox", "Presentation"],
  FontSize->18],

Cell[StyleData["MiddleBox", "Printout"],
  CellMargins->{{2, 0}, {0, 2}},
  CellFrameColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[StyleData["MiddleBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 4}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  Background->GrayLevel[1]],

Cell[StyleData["MiddleBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 4}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BottomBox"],
  CellFrame->{{0.5, 0.5}, {0.5, 0}},
  CellMargins->{{27, 12}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["BottomBox", "Presentation"],
  FontSize->18],

Cell[StyleData["BottomBox", "Printout"],
  CellMargins->{{2, 0}, {0, -5}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->2.2}],

Cell[StyleData["BottomBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, -5}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->2.2}],

Cell[StyleData["BottomBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, -5}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->2.2}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{27, 12}, {-2, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopSpanBox", "Presentation"],
  FontSize->18],

Cell[StyleData["TopSpanBox", "Printout"],
  CellMargins->{{2, 0}, {-2, 8}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["TopSpanBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {-4, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]],

Cell[StyleData["TopSpanBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {-4, 8}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{27, 12}, {0, 0}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleSpanBox", "Presentation"],
  FontSize->18],

Cell[StyleData["MiddleSpanBox", "Printout"],
  CellMargins->{{2, 0}, {-5, 0}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpanBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {-7, 0}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {-7, 0}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
  CellMargins->{{27, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["Picture", "Presentation"],
  FontSize->18],

Cell[StyleData["Picture", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.65],

Cell[StyleData["Picture", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.65],

Cell[StyleData["Picture", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.65]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OpenCloseItemizedPicture"],
  CellMargins->{{88, 4}, {4, 4}},
  PrivateCellOptions->{"DefaultCellGroupOpen"->False},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["OpenCloseItemizedPicture", "Presentation"],
  FontSize->18],

Cell[StyleData["OpenCloseItemizedPicture", "Printout"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False],

Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintout"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False],

Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintoutNonGray"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedPicture"],
  CellMargins->{{88, 4}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemizedPicture", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedPicture", "Printout"],
  CellMargins->{{77, 2}, {4, -4}},
  Magnification->0.5],

Cell[StyleData["ItemizedPicture", "EnhancedPrintout"],
  CellMargins->{{78, 2}, {12, -6}},
  Magnification->0.5],

Cell[StyleData["ItemizedPicture", "EnhancedPrintoutNonGray"],
  CellMargins->{{75, 2}, {4, -6}},
  Magnification->0.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListGraphic"],
  CellMargins->{{88, 4}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ListGraphic", "Presentation"],
  FontSize->18],

Cell[StyleData["ListGraphic", "Printout"],
  CellMargins->{{77, 2}, {4, -4}},
  Magnification->0.5],

Cell[StyleData["ListGraphic", "EnhancedPrintout"],
  CellMargins->{{78, 2}, {12, -6}},
  Magnification->0.5],

Cell[StyleData["ListGraphic", "EnhancedPrintoutNonGray"],
  CellMargins->{{75, 2}, {4, -6}},
  Magnification->0.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListNoteBox"],
  CellFrame->0.5,
  CellMargins->{{88, 12}, {8, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["ListNoteBox", "Presentation"],
  FontSize->18],

Cell[StyleData["ListNoteBox", "Printout"],
  CellMargins->{{77, 4}, {6, 2}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ListNoteBox", "EnhancedPrintout"],
  CellMargins->{{39, 4}, {6, 2}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ListNoteBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{77, 4}, {6, 2}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellMargins->{{41, 4}, {0, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureGroup", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False],

Cell[StyleData["PictureGroup", "EnhancedPrintout"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False],

Cell[StyleData["PictureGroup", "EnhancedPrintoutNonGray"],
  CellMargins->{{76, 2}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->0},
  CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Sound"],
  ShowCellBracket->True,
  CellMargins->{{27, Inherited}, {0, 8}},
  StyleMenuListing->None],

Cell[StyleData["Sound", "Presentation"],
  FontSize->18],

Cell[StyleData["Sound", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["Sound", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["Sound", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{27, 4}, {0, 3}},
  PageBreakAbove->False,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Presentation"],
  FontSize->14],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{2, 4}, {2, 0}},
  FontSize->7],

Cell[StyleData["Caption", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {2, 2}},
  FontFamily->"Frutiger-Roman",
  FontSize->7],

Cell[StyleData["Caption", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {2, -2}},
  FontFamily->"Frutiger-Roman",
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Section"],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
  CellMargins->{{35, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->{0.34, 0.64},
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9],

Cell[StyleData["2ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9],

Cell[StyleData["2ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenTable"],
  CellMargins->{{35, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.49,
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnEvenTable", "Presentation"],
  FontSize->18],

Cell[StyleData["2ColumnEvenTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9],

Cell[StyleData["2ColumnEvenTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9],

Cell[StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
  CellMargins->{{35, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["3ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9],

Cell[StyleData["3ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9],

Cell[StyleData["3ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  CellMargins->{{27, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  AutoSpacing->True,
  ScriptLevel->1,
  SingleLetterItalics->True,
  SpanMaxSize->Infinity,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->Automatic}],

Cell[StyleData["InlineFormula", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["InlineFormula", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["InlineFormula", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineOutput"],
  CellMargins->{{27, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->None,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["InlineOutput", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9.5],

Cell[StyleData["InlineOutput", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9.5],

Cell[StyleData["InlineOutput", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{66, Inherited}, {Inherited, 10}},
  CellHorizontalScrolling->True,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  ScriptLevel->0,
  SingleLetterItalics->True,
  SpanMaxSize->Infinity,
  StyleMenuListing->None,
  UnderoverscriptBoxOptions->{LimitsPositioning->True},
  GridBoxOptions->{ColumnWidths->Automatic}],

Cell[StyleData["DisplayFormula", "Presentation"],
  FontSize->18],

Cell[StyleData["DisplayFormula", "Printout"]],

Cell[StyleData["DisplayFormula", "EnhancedPrintout"],
  FontFamily->"Palatino"],

Cell[StyleData["DisplayFormula", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayMath"],
  CellMargins->{{66, 10}, {7, 7}},
  Evaluatable->False,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input"],

Cell[StyleData["DisplayMath", "Presentation"],
  FontSize->18],

Cell[StyleData["DisplayMath", "Printout"],
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9],

Cell[StyleData["DisplayMath", "EnhancedPrintout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontFamily->"WRICourier",
  FontSize->9],

Cell[StyleData["DisplayMath", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 0}, {4, 6}},
  FontFamily->"WRICourier",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{66, 27}, {7, 7}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  LanguageCategory->"Formula",
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Presentation"],
  FontSize->18],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{39, 55}, {0, 10}},
  FontSize->10],

Cell[StyleData["NumberedEquation", "EnhancedPrintout"],
  CellMargins->{{39, 55}, {0, 10}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["NumberedEquation", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 55}, {0, 10}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
  CellMargins->{{66, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1.83, 0},
  LanguageCategory->"Formula"],

Cell[StyleData["EquationNumber", "Presentation"],
  FontSize->18],

Cell[StyleData["EquationNumber", "Printout"],
  LineSpacing->{1.7, 0}],

Cell[StyleData["EquationNumber", "EnhancedPrintout"],
  LineSpacing->{1.7, 0},
  FontFamily->"Palatino"],

Cell[StyleData["EquationNumber", "EnhancedPrintoutNonGray"],
  LineSpacing->{1.7, 0},
  FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{66, Inherited}, {Inherited, 10}},
  CellHorizontalScrolling->True,
  ShowSpecialCharacters->Automatic,
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
  FontSize->18],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{42, 30}, {Inherited, 4}},
  FontSize->9.5],

Cell[StyleData["Program", "EnhancedPrintout"],
  CellMargins->{{42, 30}, {Inherited, 4}},
  FontFamily->"WRICourier",
  FontSize->9.5],

Cell[StyleData["Program", "EnhancedPrintoutNonGray"],
  CellMargins->{{42, 30}, {Inherited, 4}},
  FontFamily->"WRICourier",
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Help Browser Styles", "Section"],

Cell[CellGroupData[{

Cell["\<\
Standard Styles
\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["InspectorLevel1"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 10}, {2, 7}},
  CellGroupingRules->{"SectionGrouping", 60},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphIndent->-38,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["InspectorLevel1", "Presentation"],
  FontSize->24],

Cell[StyleData["InspectorLevel1", "SlideShow"],
  HyphenationOptions->{"HyphenationCharacter"->"-"}],

Cell[StyleData["InspectorLevel1", "Printout"],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InspectorLevel2"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {0, 14}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["InspectorLevel2", "Presentation"],
  FontSize->21],

Cell[StyleData["InspectorLevel2", "SlideShow"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{48, 10}, {2, 12}},
  CellGroupingRules->{"SectionGrouping", 70},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphIndent->-27,
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["InspectorLevel2", "Printout"],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ObjectName"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{0, 0}, {0, 0}},
  CellGroupingRules->{"SectionGrouping", 50},
  CellFrameMargins->{{27, 12}, {3, 15}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->18,
  FontWeight->"Bold",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[StyleData["ObjectName", "Presentation"],
  FontSize->24],

Cell[StyleData["ObjectName", "SlideShow"],
  CellMargins->{{72, 4}, {1, 14}},
  CellGroupingRules->{"SectionGrouping", 90},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["ObjectName", "Printout"],
  CellMargins->{{0, 0}, {0, 10}},
  CellFrameMargins->{{24, 8}, {Inherited, Inherited}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubObjectNameClosed"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {1, 10}},
  PrivateCellOptions->{"DefaultCellGroupOpen"->False},
  CellGroupingRules->{"SectionGrouping", 90},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["SubObjectNameClosed", "Presentation"],
  FontSize->21],

Cell[StyleData["SubObjectNameClosed", "SlideShow"],
  CellMargins->{{72, 4}, {1, 14}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["SubObjectNameClosed", "Printout"],
  CellMargins->{{2, 0}, {1, 10}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubObjectName"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {1, 10}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["SubObjectName", "Presentation"],
  FontSize->24],

Cell[StyleData["SubObjectName", "SlideShow"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{90, 4}, {1, 14}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontFamily->"Courier",
  FontSize->12],

Cell[StyleData["SubObjectName", "Printout"],
  CellMargins->{{2, 0}, {1, 10}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontFamily->"Courier",
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GroupObjectName"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {0, 14}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["GroupObjectName", "Presentation"],
  FontSize->24],

Cell[StyleData["GroupObjectName", "SlideShow"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{72, 10}, {2, 12}},
  CellGroupingRules->{"SectionGrouping", 70},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphIndent->-27,
  CounterIncrements->"Outline2",
  FontFamily->"Courier",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["GroupObjectName", "Printout"],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GroupObjectNameClosed"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {0, 14}},
  PrivateCellOptions->{"DefaultCellGroupOpen"->False},
  CellGroupingRules->{"SectionGrouping", 80},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["GroupObjectNameClosed", "Presentation"],
  FontSize->24],

Cell[StyleData["GroupObjectNameClosed", "SlideShow"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{72, 10}, {2, 12}},
  CellGroupingRules->{"SectionGrouping", 70},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphIndent->-27,
  CounterIncrements->"Outline2",
  FontFamily->"Courier",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["GroupObjectNameClosed", "Printout"],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ObjectNameWarningMessages"],
  CellMargins->{{27, 4}, {1, 10}},
  CellGroupingRules->{"SectionGrouping", 65},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["ObjectNameWarningMessages", "Presentation"],
  FontSize->24],

Cell[StyleData["ObjectNameWarningMessages", "SlideShow"],
  CellMargins->{{10, 4}, {1, 10}},
  CellGroupingRules->{"SectionGrouping", 65},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontFamily->"Courier",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["ObjectNameWarningMessages", "Printout"],
  CellMargins->{{2, 0}, {1, 10}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Command"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{0, 0}, {0, 0}},
  CellFrameMargins->{{27, 12}, {3, 15}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  CounterIncrements->"Section",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[StyleData["Command", "Presentation"],
  FontSize->24],

Cell[StyleData["Command", "Printout"],
  CellMargins->{{0, 0}, {0, 14}},
  PageBreakBelow->False,
  CellFrameMargins->{{24, 8}, {Inherited, Inherited}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CharacterName"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{0, 0}, {0, 0}},
  CellFrameMargins->{{27, 27}, {8, 8}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["CharacterName", "Presentation"],
  FontSize->18],

Cell[StyleData["CharacterName", "SlideShow"],
  CellMargins->{{72, 4}, {1, 14}},
  CellGroupingRules->{"SectionGrouping", 90},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["CharacterName", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Usage"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{0, 0}, {0, 0}},
  CellFrameMargins->{{27, 27}, {8, 8}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  Hyphenation->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphSpacing->{0, 6},
  ParagraphIndent->-10,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["Usage", "Presentation"],
  FontSize->18],

Cell[StyleData["Usage", "SlideShow"],
  CellFrame->{{0, 0}, {0.5, 0.5}},
  CellMargins->{{72, 4}, {0, 4}},
  CellFrameMargins->5,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphSpacing->{0, 6},
  ParagraphIndent->-10,
  StyleMenuListing->None],

Cell[StyleData["Usage", "Printout"],
  CellMargins->{{0, 0}, {0, 0}},
  CellFrameMargins->{{24, 8}, {Inherited, Inherited}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontSize->10,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ErrorMessage"],
  CellFrame->{{0, 0}, {0.5, 0.5}},
  ShowCellBracket->True,
  CellMargins->{{27, 4}, {0, 4}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
  CellFrameMargins->5,
  DefaultFormatType->DefaultOutputFormatType,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FormatType->InputForm,
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["ErrorMessage", "Presentation"],
  FontSize->18],

Cell[StyleData["ErrorMessage", "SlideShow"],
  CellMargins->{{72, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None],

Cell[StyleData["ErrorMessage", "Printout"],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Notes"],
  CellMargins->{{27, 27}, {0, 8}},
  CellHorizontalScrolling->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphSpacing->{0, 6},
  ParagraphIndent->-10,
  StyleMenuListing->None,
  FontFamily->"Times"],

Cell[StyleData["Notes", "Presentation"],
  FontSize->18],

Cell[StyleData["Notes", "SlideShow"],
  CellMargins->{{72, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphSpacing->{0, 6},
  ParagraphIndent->-10,
  StyleMenuListing->None,
  FontFamily->"Times"],

Cell[StyleData["Notes", "Printout"],
  CellMargins->{{24, 0}, {0, 8}},
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NotesList"],
  CellMargins->{{20, 4}, {2, 8}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  FontFamily->"Times"],

Cell[StyleData["NotesList", "Presentation"],
  FontSize->18],

Cell[StyleData["NotesList", "SlideShow"],
  CellMargins->{{82, 4}, {2, 8}},
  CellHorizontalScrolling->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ScriptLevel->1,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  FontFamily->"Times"],

Cell[StyleData["NotesList", "Printout"],
  CellMargins->{{12, 0}, {2, 8}},
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {0, 10}},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->12,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Presentation"],
  FontSize->20],

Cell[StyleData["ReferenceSection", "Printout"],
  CellMargins->{{3, 0}, {0, 10}},
  PageBreakBelow->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
  CellMargins->{{27, 27}, {0, 8}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Reference",
  FontSize->12],

Cell[StyleData["Reference", "Presentation"],
  FontSize->18],

Cell[StyleData["Reference", "SlideShow"],
  CellMargins->{{27, 27}, {4, 4}},
  Hyphenation->False,
  FontSize->14],

Cell[StyleData["Reference", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["Reference", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Reference", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {0, 10}},
  CellGroupingRules->{"SectionGrouping", 70},
  CellFrameMargins->12,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold"],

Cell[StyleData["ExampleSection", "Presentation"],
  FontSize->20],

Cell[StyleData["ExampleSection", "Printout"],
  CellMargins->{{3, 0}, {0, 10}},
  PageBreakBelow->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleText"],
  CellMargins->{{27, 40}, {0, 18}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphSpacing->{0, 6},
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["ExampleText", "Presentation"],
  FontSize->18],

Cell[StyleData["ExampleText", "Printout"],
  CellMargins->{{2, 80}, {0, 8}},
  PageBreakBelow->False,
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleSubsection"],
  ShowCellBracket->True,
  CellMargins->{{27, 4}, {0, 16}},
  CellGroupingRules->{"SectionGrouping", 80},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Bold"],

Cell[StyleData["ExampleSubsection", "Presentation"],
  FontSize->15],

Cell[StyleData["ExampleSubsection", "Printout"],
  CellMargins->{{12, 0}, {0, 16}},
  PageBreakBelow->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MessagesSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{27, 4}, {0, 10}},
  CellGroupingRules->{"SectionGrouping", 70},
  CellFrameMargins->12,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold"],

Cell[StyleData["MessagesSection", "Presentation"],
  FontSize->20],

Cell[StyleData["MessagesSection", "Printout"],
  CellMargins->{{3, 0}, {0, 10}},
  PageBreakBelow->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TemplateSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{27, 4}, {0, 10}},
  PrivateCellOptions->{"DefaultCellGroupOpen"->True},
  CellGroupingRules->{"SectionGrouping", 70},
  CellFrameMargins->12,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold"],

Cell[StyleData["TemplateSection", "Presentation"],
  FontSize->20],

Cell[StyleData["TemplateSection", "Printout"],
  CellMargins->{{3, 0}, {0, 10}},
  PageBreakBelow->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LineHead"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{27, 4}, {8, 18}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["LineHead", "Presentation"],
  FontSize->18],

Cell[StyleData["LineHead", "Printout"],
  CellMargins->{{2, 0}, {8, 18}},
  PageBreakBelow->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FlushInput"],
  CellMargins->{{27, 4}, {1, 4}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  ShowSpecialCharacters->Automatic,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["FlushInput", "Presentation"],
  FontSize->18],

Cell[StyleData["FlushInput", "Printout"],
  CellMargins->{{2, 0}, {1, 4}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FlushOutput"],
  CellMargins->{{27, Inherited}, {Inherited, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelAutoDelete->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FormatType->StandardForm,
  StyleMenuListing->None],

Cell[StyleData["FlushOutput", "Presentation"],
  FontSize->18],

Cell[StyleData["FlushOutput", "Printout"],
  CellMargins->{{2, Inherited}, {Inherited, Inherited}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DialogItem"],
  CellDingbat->"\[EmptyDiamond]",
  CellMargins->{{27, 4}, {0, 12}},
  CellGroupingRules->{"SectionGrouping", 70},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Bold"],

Cell[StyleData["DialogItem", "Presentation"],
  FontSize->15],

Cell[StyleData["DialogItem", "Printout"],
  CellMargins->{{12, 0}, {0, 12}},
  PageBreakBelow->False,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GroupDivider"],
  CellMargins->{{27, Inherited}, {Inherited, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->{"TitleGrouping", 0},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None],

Cell[StyleData["GroupDivider", "Presentation"],
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Highlight"],
  CellFrame->0.5,
  CellMargins->{{27, 4}, {0, 18}},
  CellFrameColor->GrayLevel[0.800015],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  Background->GrayLevel[0.950011]],

Cell[StyleData["Highlight", "Presentation"],
  FontSize->18],

Cell[StyleData["Highlight", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  LineSpacing->{1, 3},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserNotes"],
  CellFrame->{{3, 0}, {0, 0}},
  CellMargins->{{27, 4}, {0, 8}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  ParagraphIndent->-7,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["UserNotes", "Presentation"],
  FontSize->15],

Cell[StyleData["UserNotes", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  LineSpacing->{1, 3},
  FontSize->8],

Cell[StyleData["UserNotes", "EnhancedPrintout"],
  CellMargins->{{0, 0}, {0, 4}},
  Hyphenation->True,
  LineSpacing->{1, 3},
  FontFamily->"Frutiger-Roman",
  FontSize->8],

Cell[StyleData["UserNotes", "EnhancedPrintoutNonGray"],
  CellMargins->{{0, 0}, {0, 4}},
  Hyphenation->True,
  LineSpacing->{1, 3},
  FontFamily->"Frutiger-Roman",
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MoreInfo"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  ParagraphIndent->-7,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["MoreInfo", "Presentation"],
  FontSize->15],

Cell[StyleData["MoreInfo", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  LineSpacing->{1, 3},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserTips"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {0, 8}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  ParagraphIndent->-7,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["UserTips", "Presentation"],
  FontSize->15],

Cell[StyleData["UserTips", "Printout"],
  CellMargins->{{2, 0}, {0, 4}},
  CellFrameColor->GrayLevel[0.800015],
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  LineSpacing->{1, 3},
  FontSize->8,
  Background->GrayLevel[0.900008]],

Cell[StyleData["UserTips", "EnhancedPrintout"],
  CellMargins->{{0, 0}, {0, 4}},
  CellFrameColor->GrayLevel[0],
  Hyphenation->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  LineSpacing->{1, 3},
  FontFamily->"Frutiger-Roman",
  FontSize->8,
  Background->GrayLevel[0.700008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Theorem"],
  CellFrame->{{4, 0}, {0, 0}},
  CellMargins->{{27, 62}, {0, 14}},
  CellFrameMargins->4,
  CellFrameColor->RGBColor[0, 0, 0.8],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8}],

Cell[StyleData["Theorem", "Presentation"],
  FontSize->18],

Cell[StyleData["Theorem", "Printout"],
  CellMargins->{{2, 0}, {0, 14}},
  CellFrameMargins->3,
  CellFrameColor->GrayLevel[0.8],
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellFrame->{{2, 0}, {0, 0}},
  CellMargins->{{36, 10}, {7, 7}},
  PageBreakBelow->False,
  CellFrameMargins->8,
  CellFrameColor->RGBColor[0, 0.2, 1],
  LineSpacing->{1, 3},
  FontSlant->"Italic"],

Cell[StyleData["Commentary", "Presentation"],
  FontSize->18],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{36, 0}, {6, 6}},
  CellFrameColor->GrayLevel[0.8],
  FontSize->10],

Cell[StyleData["Commentary", "EnhancedPrintout"],
  CellMargins->{{36, 0}, {6, 6}},
  CellFrameColor->GrayLevel[0.8],
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Commentary", "EnhancedPrintoutNonGray"],
  CellMargins->{{36, 0}, {6, 6}},
  CellFrameColor->GrayLevel[0.8],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Level1Icon"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{48, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None],

Cell[StyleData["Level1Icon", "Presentation"],
  FontSize->18],

Cell[StyleData["Level1Icon", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Level2Icon"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{48, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None],

Cell[StyleData["Level2Icon", "Presentation"],
  FontSize->18],

Cell[StyleData["Level2Icon", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  HyphenationOptions->{"HyphenationCharacter"->"-"},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CopyrightHead"],
  CellMargins->{{27, 4}, {0, 8}},
  PageBreakAbove->False,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["CopyrightHead", "Presentation"],
  FontSize->18],

Cell[StyleData["CopyrightHead", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Copyright"],
  CellMargins->{{27, 4}, {0, 8}},
  PageBreakAbove->False,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["Copyright", "Presentation"],
  FontSize->15],

Cell[StyleData["Copyright", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontSize->8],

Cell[StyleData["Copyright", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Frutiger-Roman",
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RegisterSubsection"],
  CellDingbat->None,
  CellMargins->{{27, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 45},
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  FontFamily->"Helvetica",
  FontSize->16],

Cell[StyleData["RegisterSubsection", "Presentation"],
  FontSize->24],

Cell[StyleData["RegisterSubsection", "SlideShow"],
  CellDingbat->None,
  CellMargins->{{70, 0}, {4, 12}},
  FontSize->12],

Cell[StyleData["RegisterSubsection", "Printout"],
  CellMargins->{{9, 0}, {5, 24}},
  FontSize->12],

Cell[StyleData["RegisterSubsection", "EnhancedPrintout"],
  CellMargins->{{9, 0}, {5, 20}},
  FontFamily->"Frutiger-Roman",
  FontSize->12],

Cell[StyleData["RegisterSubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{9, 0}, {5, 20}},
  FontFamily->"Frutiger-Roman",
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RegisterSubsubsection"],
  CellMargins->{{27, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 50},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["RegisterSubsubsection", "Presentation"],
  FontSize->18],

Cell[StyleData["RegisterSubsubsection", "Printout"],
  CellMargins->{{2, 0}, {3, 8}},
  FontSize->10],

Cell[StyleData["RegisterSubsubsection", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {3, 8}},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["RegisterSubsubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {3, 8}},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RegisterText"],
  CellMargins->{{27, 4}, {0, 8}},
  PageBreakAbove->False,
  StyleMenuListing->None,
  FontSize->10],

Cell[StyleData["RegisterText", "Presentation"],
  FontSize->15],

Cell[StyleData["RegisterText", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontSize->8],

Cell[StyleData["RegisterText", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CaptionHead"],
  CellMargins->{{27, 4}, {0, 8}},
  PageBreakAbove->False,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["CaptionHead", "Presentation"],
  FontSize->15],

Cell[StyleData["CaptionHead", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontSize->8],

Cell[StyleData["CaptionHead", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CaptionText"],
  CellMargins->{{66, 4}, {0, 8}},
  PageBreakAbove->False,
  StyleMenuListing->None],

Cell[StyleData["CaptionText", "Presentation"],
  FontSize->15],

Cell[StyleData["CaptionText", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontSize->8],

Cell[StyleData["CaptionText", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BulletText"],
  CellMargins->{{76, 4}, {4, 4}},
  CellFrameLabels->{{
    Cell[ "\[Bullet]", "BulletText", CellBaseline -> Baseline], Inherited}, {
      Inherited, Inherited}},
  Hyphenation->False,
  LineSpacing->{1, 3},
  CounterIncrements->"BulletText",
  StyleMenuListing->None],

Cell[StyleData["BulletText", "Presentation"],
  FontSize->18],

Cell[StyleData["BulletText", "Printout"],
  FontSize->10],

Cell[StyleData["BulletText", "EnhancedPrintout"],
  CellMargins->{{16, 4}, {2, 4}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["BulletText", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["HelpLabels"],
  CellMargins->{{88, 4}, {0, 8}},
  StyleMenuListing->None],

Cell[StyleData["HelpLabels", "Presentation"],
  FontSize->15],

Cell[StyleData["HelpLabels", "Printout"],
  CellMargins->{{34, 2}, {6, 6}},
  FontSize->10],

Cell[StyleData["HelpLabels", "EnhancedPrintout"],
  CellMargins->{{34, 2}, {6, 6}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Manual.nb Merge", "Subsection"],

Cell[CellGroupData[{

Cell["Function List", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["FunctionName"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{24, 10}, {10, 12}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->14,
  FontWeight->"Bold",
  CellTags->"FunctionName"],

Cell[StyleData["FunctionName", "Presentation"],
  FontSize->21],

Cell[StyleData["FunctionName", "Printout"],
  CellMargins->{{9, 0}, {10, 10}},
  FontSize->12],

Cell[StyleData["FunctionName", "EnhancedPrintout"],
  CellMargins->{{9, 0}, {10, 10}},
  FontFamily->"Courier",
  FontSize->12],

Cell[StyleData["FunctionName", "EnhancedPrintoutNonGray"],
  CellMargins->{{9, 0}, {10, 10}},
  FontFamily->"Courier",
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionSubsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{36, 10}, {0, 6}},
  CellGroupingRules->{"SectionGrouping", 60},
  PageBreakBelow->False,
  StyleMenuListing->None,
  FontWeight->"Bold",
  CellTags->"FunctionSubsection"],

Cell[StyleData["FunctionSubsection", "Presentation"],
  FontSize->18],

Cell[StyleData["FunctionSubsection", "Printout"],
  CellMargins->{{30, 0}, {0, 6}}],

Cell[StyleData["FunctionSubsection", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {0, 6}},
  FontFamily->"Palatino",
  FontSize->11],

Cell[StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {0, 6}},
  FontFamily->"Palatino",
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescription"],
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"FunctionDescription",
  StyleMenuListing->None,
  FontWeight->"Plain"],

Cell[StyleData["FunctionDescription", "Presentation"],
  FontSize->18],

Cell[StyleData["FunctionDescription", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescription", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescription", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuled"],
  CellFrame->{{0, 0}, {0.25, 0.25}},
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"FunctionDescriptionRuled",
  StyleMenuListing->None],

Cell[StyleData["FunctionDescriptionRuled", "Presentation"],
  FontSize->18],

Cell[StyleData["FunctionDescriptionRuled", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuleTop"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"FunctionDescriptionRuleTop",
  StyleMenuListing->None],

Cell[StyleData["FunctionDescriptionRuleTop", "Presentation"],
  FontSize->18],

Cell[StyleData["FunctionDescriptionRuleTop", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuleBottom"],
  CellFrame->{{0, 0}, {0.25, 0}},
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"FunctionDescriptionRuleBottom",
  StyleMenuListing->None],

Cell[StyleData["FunctionDescriptionRuleBottom", "Presentation"],
  FontSize->18],

Cell[StyleData["FunctionDescriptionRuleBottom", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionExample"],
  CellMargins->{{36, 10}, {4, 0}},
  StyleMenuListing->None,
  FontSize->10],

Cell[StyleData["FunctionExample", "Presentation"],
  FontSize->15],

Cell[StyleData["FunctionExample", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->9],

Cell[StyleData["FunctionExample", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontFamily->"Palatino",
  FontSize->9],

Cell[StyleData["FunctionExample", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionTextNote"],
  CellMargins->{{36, 4}, {0, 4}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 4},
  LineIndent->0,
  StyleMenuListing->None],

Cell[StyleData["FunctionTextNote", "Presentation"],
  FontSize->18],

Cell[StyleData["FunctionTextNote", "Printout"],
  CellMargins->{{36, 4}, {0, 4}},
  FontSize->9],

Cell[StyleData["FunctionTextNote", "EnhancedPrintout"],
  CellMargins->{{36, 4}, {0, 4}},
  FontFamily->"Palatino",
  FontSize->8],

Cell[StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"],
  CellMargins->{{36, 4}, {0, 4}},
  FontFamily->"Palatino",
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnFunctionTable"],
  CellMargins->{{36, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->{0.28, 0.28, 0.43},
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnFunctionTable", "Presentation"],
  FontSize->18],

Cell[StyleData["3ColumnFunctionTable", "Printout"],
  CellMargins->{{30, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {0, 8}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Browser Emulation", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TextNormal"],
  CellMargins->{{12, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"TextNormal",
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["TextNormal", "Presentation"],
  FontSize->18],

Cell[StyleData["TextNormal", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BrowserEmulation"],
  CellMargins->{{12, 1}, {7, 24}},
  CellGroupingRules->{"SectionGrouping", 70},
  LineSpacing->{1, 3},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  GridBoxOptions->{ColumnWidths->0.25,
  ColumnAlignments->{Left},
  GridFrame->True,
  GridFrameMargins->0.5,
  ColumnLines->True}],

Cell[StyleData["BrowserEmulation", "Presentation"],
  FontSize->18],

Cell[StyleData["BrowserEmulation", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CategoryDefs"],
  CellMargins->{{300, 10}, {7, 7}},
  LineSpacing->{1, 3},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  Background->RGBColor[1, 0.8, 0.6],
  GridBoxOptions->{ColumnAlignments->{Left},
  GridFrame->False,
  RowLines->True,
  ColumnLines->True}],

Cell[StyleData["CategoryDefs", "Presentation"],
  FontSize->18],

Cell[StyleData["CategoryDefs", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category1"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{12, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 50},
  StyleMenuListing->None,
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Category1", "Presentation"],
  FontSize->24],

Cell[StyleData["Category1", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category2"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{85, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 60},
  StyleMenuListing->None,
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Category2", "Presentation"],
  FontSize->21],

Cell[StyleData["Category2", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category3"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{157, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 70},
  StyleMenuListing->None,
  FontSize->12,
  FontWeight->"Bold",
  FontColor->RGBColor[0.2, 0, 0.4]],

Cell[StyleData["Category3", "Presentation"],
  FontSize->18],

Cell[StyleData["Category3", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category4"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{230, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 80},
  StyleMenuListing->None,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0.300008, 0.4]],

Cell[StyleData["Category4", "Presentation"],
  FontSize->18],

Cell[StyleData["Category4", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Misc", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["4ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.25,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["4ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["4ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["4ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["4ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.2,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["5ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["5ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["5ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["5ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.16,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["6ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["6ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["6ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["6ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["7ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.14,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["7ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["7ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["7ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["7ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["8ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.12,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["8ColumnTable", "Presentation"],
  FontSize->18],

Cell[StyleData["8ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["8ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["8ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ABItemizedText"],
  CellMargins->{{20, 4}, {0, 5}},
  LineSpacing->{1, 3},
  ParagraphIndent->-21,
  CounterIncrements->"ItemizedText",
  StyleMenuListing->None],

Cell[StyleData["ABItemizedText", "Presentation"],
  FontSize->18],

Cell[StyleData["ABItemizedText", "Printout"],
  Hyphenation->True,
  ParagraphIndent->-21,
  FontSize->11],

Cell[StyleData["ABItemizedText", "EnhancedPrintout"],
  Hyphenation->True,
  ParagraphIndent->-21,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ABItemizedText", "EnhancedPrintoutNonGray"],
  Hyphenation->True,
  ParagraphIndent->-21,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChapNumber"],
  CellMargins->{{27, Inherited}, {20, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->42,
  FontWeight->"Plain",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["ChapNumber", "Presentation"],
  FontSize->63],

Cell[StyleData["ChapNumber", "Printout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->36],

Cell[StyleData["ChapNumber", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontFamily->"Frutiger-Roman",
  FontSize->36,
  FontColor->GrayLevel[0]],

Cell[StyleData["ChapNumber", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {15, 30}},
  FontFamily->"Frutiger-Roman",
  FontSize->36,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChapTitle"],
  CellMargins->{{27, Inherited}, {80, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["ChapTitle", "Presentation"],
  FontSize->54],

Cell[StyleData["ChapTitle", "Printout"],
  CellMargins->{{2, 10}, {80, 6}},
  FontSize->30],

Cell[StyleData["ChapTitle", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {80, 6}},
  FontFamily->"Frutiger-Bold",
  FontSize->30,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["ChapTitle", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {80, 6}},
  FontFamily->"Frutiger-Bold",
  FontSize->30,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemDingbat"],
  CellSize->{22, 14},
  TextAlignment->Right,
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["ItemDingbat", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemDingbat", "Printout"],
  CellSize->{22, 13.125}],

Cell[StyleData["ItemDingbat", "EnhancedPrintout"],
  CellSize->{22, 11}],

Cell[StyleData["ItemDingbat", "EnhancedPrintoutNonGray"],
  CellSize->{22, 11}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1"],
  CellMargins->{{19, 4}, {4, 4}},
  ParagraphIndent->-22,
  CounterIncrements->"Item1",
  StyleMenuListing->None],

Cell[StyleData["Item1", "Presentation"],
  FontSize->18],

Cell[StyleData["Item1", "Printout"],
  CellMargins->{{12, 0}, {2, 4}},
  FontSize->10],

Cell[StyleData["Item1", "EnhancedPrintout"],
  CellMargins->{{16, 0}, {2, 4}},
  FontSize->10],

Cell[StyleData["Item1", "EnhancedPrintoutNonGray"],
  CellMargins->{{16, 0}, {2, 4}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1Continued"],
  CellMargins->{{41, 4}, {4, 1}},
  CounterIncrements->"Item1Continued",
  StyleMenuListing->None],

Cell[StyleData["Item1Continued", "Presentation"],
  FontSize->18],

Cell[StyleData["Item1Continued", "Printout"],
  CellMargins->{{34, 0}, {4, 1}},
  FontSize->10],

Cell[StyleData["Item1Continued", "EnhancedPrintout"],
  CellMargins->{{39, 0}, {4, 1}},
  FontSize->10],

Cell[StyleData["Item1Continued", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 0}, {4, 1}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2"],
  CellMargins->{{32, 4}, {4, 4}},
  ParagraphIndent->-22,
  CounterIncrements->"Item2",
  StyleMenuListing->None],

Cell[StyleData["Item2", "Presentation"],
  FontSize->18],

Cell[StyleData["Item2", "Printout"],
  CellMargins->{{26, 0}, {4, 4}},
  ParagraphIndent->-22,
  FontSize->10],

Cell[StyleData["Item2", "EnhancedPrintout"],
  CellMargins->{{29, 0}, {2, 4}},
  ParagraphIndent->-22,
  FontSize->10],

Cell[StyleData["Item2", "EnhancedPrintoutNonGray"],
  CellMargins->{{29, 0}, {2, 4}},
  ParagraphIndent->-22,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Continued"],
  CellMargins->{{54, 4}, {4, 1}},
  CounterIncrements->"Item2Continued",
  StyleMenuListing->None],

Cell[StyleData["Item2Continued", "Presentation"],
  FontSize->18],

Cell[StyleData["Item2Continued", "Printout"],
  CellMargins->{{27, 0}, {4, 1}}],

Cell[StyleData["Item2Continued", "EnhancedPrintout"],
  CellMargins->{{52, 0}, {4, 1}},
  FontSize->10],

Cell[StyleData["Item2Continued", "EnhancedPrintoutNonGray"],
  CellMargins->{{52, 0}, {4, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3"],
  CellMargins->{{45, 4}, {4, 4}},
  ParagraphIndent->-23,
  CounterIncrements->"Item3",
  StyleMenuListing->None],

Cell[StyleData["Item3", "Presentation"],
  FontSize->18],

Cell[StyleData["Item3", "Printout"],
  CellMargins->{{27, 0}, {2, 4}}],

Cell[StyleData["Item3", "EnhancedPrintout"],
  CellMargins->{{42, 0}, {2, 4}},
  FontSize->10],

Cell[StyleData["Item3", "EnhancedPrintoutNonGray"],
  CellMargins->{{42, 0}, {2, 4}},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Continued"],
  CellMargins->{{67, 4}, {4, 1}},
  CounterIncrements->"Item3Continued",
  StyleMenuListing->None],

Cell[StyleData["Item3Continued", "Presentation"],
  FontSize->18],

Cell[StyleData["Item3Continued", "Printout"],
  CellMargins->{{27, 0}, {4, 1}}],

Cell[StyleData["Item3Continued", "EnhancedPrintout"],
  CellMargins->{{65, 0}, {4, 1}},
  FontSize->10],

Cell[StyleData["Item3Continued", "EnhancedPrintoutNonGray"],
  CellMargins->{{65, 0}, {4, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedBulletText"],
  CellMargins->{{19, 4}, {0, 5}},
  LineSpacing->{1, 3},
  ParagraphIndent->-22,
  CounterIncrements->"ItemizedBulletText",
  StyleMenuListing->None],

Cell[StyleData["ItemizedBulletText", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedBulletText", "Printout"],
  Hyphenation->True,
  ParagraphIndent->-20,
  FontSize->11],

Cell[StyleData["ItemizedBulletText", "EnhancedPrintout"],
  Hyphenation->True,
  ParagraphIndent->-19,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedBulletText", "EnhancedPrintoutNonGray"],
  Hyphenation->True,
  ParagraphIndent->-19,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NoteBox"],
  CellFrame->0.5,
  CellMargins->{{27, 12}, {8, 8}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["NoteBox", "Presentation"],
  FontSize->18],

Cell[StyleData["NoteBox", "Printout"],
  CellMargins->{{2, 4}, {6, 2}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["NoteBox", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 2}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["NoteBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {6, 2}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedNoteBox"],
  CellFrame->0.5,
  CellMargins->{{41, 4}, {8, 2}},
  CellHorizontalScrolling->True,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["ItemizedNoteBox", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedNoteBox", "Printout"],
  CellMargins->{{39, 4}, {6, 2}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedNoteBox", "EnhancedPrintout"],
  CellMargins->{{39, 4}, {6, 2}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedNoteBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 4}, {6, 2}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTopBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{37, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  CellFrameMargins->{{8, 8}, {0, 8}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["ItemizedTopBox", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedTopBox", "Printout"],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedTopBox", "EnhancedPrintout"],
  CellMargins->{{39, 4}, {0, 6}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedTopBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 4}, {0, 6}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedBottomBox"],
  CellFrame->{{0.5, 0.5}, {0.5, 0}},
  CellMargins->{{37, 4}, {4, 0}},
  CellHorizontalScrolling->True,
  CellFrameMargins->{{8, 8}, {8, 0}},
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  LineIndent->0,
  StyleMenuListing->None,
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["ItemizedBottomBox", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedBottomBox", "Printout"],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedBottomBox", "EnhancedPrintout"],
  CellMargins->{{39, 4}, {6, 0}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedBottomBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 4}, {6, 0}},
  CellFrameColor->GrayLevel[0],
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpacedBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{27, 12}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleSpacedBox", "Presentation"],
  FontSize->18],

Cell[StyleData["MiddleSpacedBox", "Printout"],
  CellMargins->{{2, 0}, {0, 0}},
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpacedBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 0}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 0}},
  CellFrameColor->GrayLevel[0],
  FontFamily->"Palatino",
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedNote"],
  CellMargins->{{41, 4}, {0, 12}},
  LineSpacing->{1, 2},
  CounterIncrements->"ItemizedNote",
  StyleMenuListing->None],

Cell[StyleData["ItemizedNote", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedNote", "Printout"],
  CellMargins->{{38, 4}, {0, 9}},
  Hyphenation->True,
  FontSize->11],

Cell[StyleData["ItemizedNote", "EnhancedPrintout"],
  CellMargins->{{38, 4}, {0, 0}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedNote", "EnhancedPrintoutNonGray"],
  CellMargins->{{38, 4}, {0, 0}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedNoteBelow"],
  CellMargins->{{41, 4}, {0, 8}},
  LineSpacing->{1, 2},
  CounterIncrements->"ItemizedNote",
  StyleMenuListing->None],

Cell[StyleData["ItemizedNoteBelow", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedNoteBelow", "Printout"],
  CellMargins->{{38, 4}, {0, 12}},
  Hyphenation->True,
  FontSize->11],

Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintout"],
  CellMargins->{{38, 4}, {0, 8}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintoutNonGray"],
  CellMargins->{{38, 4}, {0, 8}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextBelowPic"],
  CellMargins->{{19, 4}, {0, 8}},
  LineSpacing->{1, 3},
  ParagraphIndent->-22,
  CounterIncrements->"ItemizedText",
  StyleMenuListing->None],

Cell[StyleData["ItemizedTextBelowPic", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedTextBelowPic", "Printout"],
  CellMargins->{{20, 4}, {2, 12}},
  Hyphenation->True,
  ParagraphIndent->-18,
  FontSize->11],

Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintout"],
  CellMargins->{{20, 4}, {2, 12}},
  Hyphenation->True,
  ParagraphIndent->-17,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintoutNonGray"],
  CellMargins->{{20, 4}, {2, 12}},
  Hyphenation->True,
  ParagraphIndent->-17,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote2"],
  CellMargins->{{41, 4}, {0, 4}},
  LineSpacing->{1, 2},
  CounterIncrements->"ItemizedNote",
  StyleMenuListing->None],

Cell[StyleData["ItemizedTextNote2", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemizedTextNote2", "Printout"],
  CellMargins->{{38, 4}, {0, 2}},
  Hyphenation->True,
  FontSize->11],

Cell[StyleData["ItemizedTextNote2", "EnhancedPrintout"],
  CellMargins->{{38, 4}, {0, 2}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedTextNote2", "EnhancedPrintoutNonGray"],
  CellMargins->{{38, 4}, {0, 2}},
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedItem1"],
  CellMargins->{{48, 4}, {4, 4}},
  CellGroupingRules->{"SectionGrouping", 15},
  ParagraphIndent->-23,
  CounterIncrements->"NumberedItem1",
  StyleMenuListing->None],

Cell[StyleData["NumberedItem1", "Presentation"],
  FontSize->18],

Cell[StyleData["NumberedItem1", "Printout"],
  CellMargins->{{12, 0}, {0, 8}}],

Cell[StyleData["NumberedItem1", "EnhancedPrintout"],
  CellMargins->{{12, 0}, {0, 8}}],

Cell[StyleData["NumberedItem1", "EnhancedPrintoutNonGray"],
  CellMargins->{{12, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedItem2"],
  CellMargins->{{71, 4}, {3, 3}},
  CellGroupingRules->{"SectionGrouping", 15},
  ParagraphIndent->-21,
  CounterIncrements->"NumberedItem2",
  StyleMenuListing->None],

Cell[StyleData["NumberedItem2", "Presentation"],
  FontSize->18],

Cell[StyleData["NumberedItem2", "Printout"],
  CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem2", "EnhancedPrintout"],
  CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem2", "EnhancedPrintoutNonGray"],
  CellMargins->{{27, 0}, {0, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedItem3"],
  CellMargins->{{94, 4}, {2, 2}},
  CellGroupingRules->{"SectionGrouping", 15},
  ParagraphIndent->-23,
  CounterIncrements->"NumberedItem3",
  StyleMenuListing->None],

Cell[StyleData["NumberedItem3", "Presentation"],
  FontSize->18],

Cell[StyleData["NumberedItem3", "Printout"],
  CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem3", "EnhancedPrintout"],
  CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem3", "EnhancedPrintoutNonGray"],
  CellMargins->{{27, 0}, {0, 4}},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageHeaderBold"],
  CellMargins->{{0, 0}, {2, 0}},
  StyleMenuListing->None,
  FontSize->8,
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["PageHeaderBold", "Printout"]],

Cell[StyleData["PageHeaderBold", "EnhancedPrintout"],
  FontFamily->"Frutiger-BoldItalic",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["PageHeaderBold", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-BoldItalic",
  FontWeight->"Plain",
  FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SingleRowTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnAlignments->{Left}}],

Cell[StyleData["SingleRowTable", "Presentation"],
  FontSize->18],

Cell[StyleData["SingleRowTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["SingleRowTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["SingleRowTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsubsection"],
  CellMargins->{{27, 4}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  StyleMenuListing->None,
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsubsection", "Presentation"],
  FontSize->18],

Cell[StyleData["Subsubsubsection", "Printout"],
  CellMargins->{{2, 0}, {3, 8}},
  FontSize->10],

Cell[StyleData["Subsubsubsection", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {3, 8}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Subsubsubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {3, 8}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{27, Inherited}, {20, 15}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  FontSize->21],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->12],

Cell[StyleData["Subsubtitle", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontFamily->"Frutiger-Roman",
  FontSize->12],

Cell[StyleData["Subsubtitle", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {8, 10}},
  FontFamily->"Frutiger-Roman",
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{27, Inherited}, {20, 15}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
  FontSize->36],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontSize->24],

Cell[StyleData["Subtitle", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontFamily->"Frutiger-Roman",
  FontSize->24],

Cell[StyleData["Subtitle", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {10, 15}},
  FontFamily->"Frutiger-Roman",
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextBelow"],
  CellMargins->{{27, 4}, {0, 14}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  ParagraphSpacing->{0, 8},
  StyleMenuListing->None,
  FontSize->12],

Cell[StyleData["TextBelow", "Presentation"],
  FontSize->18],

Cell[StyleData["TextBelow", "Printout"],
  CellMargins->{{2, 2}, {6, 12}},
  TextJustification->1,
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["TextBelow", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 12}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["TextBelow", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {6, 12}},
  TextJustification->1,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{27, Inherited}, {20, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  DefaultNewInlineCellStyle->"None",
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  LanguageCategory->"NaturalLanguage",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Title", "Presentation"],
  FontSize->54],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->30],

Cell[StyleData["Title", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontFamily->"Frutiger-Bold",
  FontSize->30.5,
  FontWeight->"Plain"],

Cell[StyleData["Title", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {15, 30}},
  FontFamily->"Frutiger-Bold",
  FontSize->30.5,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Undersubsection"],
  CellMargins->{{10, 4}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
          TextForm]},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Undersubsection", "Presentation"],
  FontSize->18],

Cell[StyleData["Undersubsection", "Printout"],
  CellMargins->{{2, 0}, {7, 10}},
  FontSize->10],

Cell[StyleData["Undersubsection", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {7, 8}},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain"],

Cell[StyleData["Undersubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {7, 8}},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionFirst"],
  CellMargins->{{27, 27}, {12, 18}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SectionFirst", "Presentation"],
  FontSize->30],

Cell[StyleData["SectionFirst", "Printout"],
  CellMargins->{{2, 0}, {0, 6}},
  PageBreakBelow->False,
  FontSize->18],

Cell[StyleData["SectionFirst", "EnhancedPrintout"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{2, Inherited}, {5, 6}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->8,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Frutiger-Bold",
  FontSize->16,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["SectionFirst", "EnhancedPrintoutNonGray"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{2, Inherited}, {5, 6}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->8,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Frutiger-Bold",
  FontSize->16,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionFirst"],
  CellDingbat->None,
  CellMargins->{{27, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsectionFirst", "Presentation"],
  FontSize->24],

Cell[StyleData["SubsectionFirst", "SlideShow"],
  CellDingbat->None,
  CellMargins->{{70, 0}, {4, 6}},
  FontSize->12],

Cell[StyleData["SubsectionFirst", "Printout"],
  CellMargins->{{9, 0}, {5, 6}},
  CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
  FontSize->12],

Cell[StyleData["SubsectionFirst", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {5, 6}},
  CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
  FontFamily->"Frutiger-Bold",
  FontSize->12,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["SubsectionFirst", "EnhancedPrintoutNonGray"],
  CellMargins->{{9, 0}, {5, 6}},
  CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
  FontFamily->"Frutiger-Bold",
  FontSize->12,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionFirst"],
  CellMargins->{{27, 27}, {0, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsubsectionFirst", "Presentation"],
  FontSize->18],

Cell[StyleData["SubsubsectionFirst", "Printout"],
  CellMargins->{{2, 0}, {3, 3}},
  CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
  FontSize->10],

Cell[StyleData["SubsubsectionFirst", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {3, 3}},
  CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]],

Cell[StyleData["SubsubsectionFirst", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {3, 3}},
  CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsubsectionFirst"],
  CellMargins->{{10, 4}, {0, 12}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  StyleMenuListing->None,
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["SubsubsubsectionFirst", "Presentation"],
  FontSize->18],

Cell[StyleData["SubsubsubsectionFirst", "Printout"],
  CellMargins->{{2, 0}, {3, 3}},
  FontSize->10],

Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {3, 3}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {3, 3}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell["Spacer Cell", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Spacer"],
  CellMargins->{{10, 10}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->2,
  "ClosedCellHeight"->1},
  CellOpen->False,
  StyleMenuListing->None],

Cell[StyleData["Spacer", "Printout"],
  CellOpen->True,
  FontSize->3]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DiscretionaryHyphen"],
  StyleMenuListing->None,
  FontSize->0.0625,
  FontColor->GrayLevel[1]],

Cell[StyleData["DiscretionaryHyphen", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintout"],
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintoutNonGray"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller1"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureSmaller1", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureSmaller1", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.63],

Cell[StyleData["PictureSmaller1", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.63],

Cell[StyleData["PictureSmaller1", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.63]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller2"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureSmaller2", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureSmaller2", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.61],

Cell[StyleData["PictureSmaller2", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.61],

Cell[StyleData["PictureSmaller2", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.61]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller3"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureSmaller3", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureSmaller3", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.59],

Cell[StyleData["PictureSmaller3", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.59],

Cell[StyleData["PictureSmaller3", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.59]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller4"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureSmaller4", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureSmaller4", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.57],

Cell[StyleData["PictureSmaller4", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.57],

Cell[StyleData["PictureSmaller4", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.57]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller5"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureSmaller5", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureSmaller5", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.55],

Cell[StyleData["PictureSmaller5", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.55],

Cell[StyleData["PictureSmaller5", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.55]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller6"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureSmaller6", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureSmaller6", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.53],

Cell[StyleData["PictureSmaller6", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.53],

Cell[StyleData["PictureSmaller6", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.53]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPicture"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPicture", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPicture", "Printout"],
  CellMargins->{{55, Inherited}, {8, -4}},
  Magnification->0.65],

Cell[StyleData["ItemPicture", "EnhancedPrintout"],
  CellMargins->{{60, Inherited}, {10, -3}},
  Magnification->0.65],

Cell[StyleData["ItemPicture", "EnhancedPrintoutNonGray"],
  CellMargins->{{60, Inherited}, {10, -3}},
  Magnification->0.65]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller1"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller1", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureSmaller1", "Printout"],
  CellMargins->{{56, Inherited}, {9, -3}},
  Magnification->0.63],

Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintout"],
  CellMargins->{{63, Inherited}, {10, -3}},
  Magnification->0.63],

Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintoutNonGray"],
  CellMargins->{{63, Inherited}, {10, -3}},
  Magnification->0.63]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller2"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller2", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureSmaller2", "Printout"],
  CellMargins->{{58, Inherited}, {8, -4}},
  Magnification->0.61],

Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintout"],
  CellMargins->{{65, Inherited}, {11, -3}},
  Magnification->0.61],

Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintoutNonGray"],
  CellMargins->{{65, Inherited}, {11, -3}},
  Magnification->0.61]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller3"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller3", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureSmaller3", "Printout"],
  CellMargins->{{61, Inherited}, {10, -2}},
  Magnification->0.59],

Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintout"],
  CellMargins->{{67, Inherited}, {11, -3}},
  Magnification->0.59],

Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintoutNonGray"],
  CellMargins->{{67, Inherited}, {11, -3}},
  Magnification->0.59]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller4"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller4", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureSmaller4", "Printout"],
  CellMargins->{{63, Inherited}, {10, -2}},
  Magnification->0.57],

Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintout"],
  CellMargins->{{69, Inherited}, {12, -4}},
  Magnification->0.57],

Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintoutNonGray"],
  CellMargins->{{69, Inherited}, {12, -4}},
  Magnification->0.57]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller5"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller5", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureSmaller5", "Printout"],
  CellMargins->{{65, Inherited}, {11, -2}},
  Magnification->0.55],

Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintout"],
  CellMargins->{{71, Inherited}, {13, -2}},
  Magnification->0.55],

Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintoutNonGray"],
  CellMargins->{{71, Inherited}, {13, -2}},
  Magnification->0.55]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller6"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller6", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureSmaller6", "Printout"],
  CellMargins->{{67, Inherited}, {12, -2}},
  Magnification->0.53],

Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintout"],
  CellMargins->{{74, Inherited}, {13, -3}},
  Magnification->0.53],

Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintoutNonGray"],
  CellMargins->{{74, Inherited}, {13, -3}},
  Magnification->0.53]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger1"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureBigger1", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureBigger1", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.68],

Cell[StyleData["PictureBigger1", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.68],

Cell[StyleData["PictureBigger1", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.68]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger2"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureBigger2", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureBigger2", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.71],

Cell[StyleData["PictureBigger2", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.71],

Cell[StyleData["PictureBigger2", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.71]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger3"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureBigger3", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureBigger3", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.74],

Cell[StyleData["PictureBigger3", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.74],

Cell[StyleData["PictureBigger3", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.74]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger4"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureBigger4", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureBigger4", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.77],

Cell[StyleData["PictureBigger4", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.77],

Cell[StyleData["PictureBigger4", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.77]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger5"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureBigger5", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureBigger5", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.8],

Cell[StyleData["PictureBigger5", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.8],

Cell[StyleData["PictureBigger5", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger6"],
  CellMargins->{{10, Inherited}, {4, 4}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PictureBigger6", "Presentation"],
  FontSize->18],

Cell[StyleData["PictureBigger6", "Printout"],
  CellMargins->{{2, Inherited}, {4, 4}},
  Magnification->0.83],

Cell[StyleData["PictureBigger6", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.83],

Cell[StyleData["PictureBigger6", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {4, 2}},
  Magnification->0.83]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger1"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger1", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureBigger1", "Printout"],
  CellMargins->{{50, Inherited}, {9, -3}},
  Magnification->0.68],

Cell[StyleData["ItemPictureBigger1", "EnhancedPrintout"],
  CellMargins->{{57, Inherited}, {10, -3}},
  Magnification->0.68],

Cell[StyleData["ItemPictureBigger1", "EnhancedPrintoutNonGray"],
  CellMargins->{{57, Inherited}, {10, -3}},
  Magnification->0.68]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger2"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger2", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureBigger2", "Printout"],
  CellMargins->{{48, Inherited}, {8, -4}},
  Magnification->0.71],

Cell[StyleData["ItemPictureBigger2", "EnhancedPrintout"],
  CellMargins->{{54, Inherited}, {10, -3}},
  Magnification->0.71],

Cell[StyleData["ItemPictureBigger2", "EnhancedPrintoutNonGray"],
  CellMargins->{{54, Inherited}, {10, -3}},
  Magnification->0.71]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger3"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger3", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureBigger3", "Printout"],
  CellMargins->{{46, Inherited}, {10, -2}},
  Magnification->0.74],

Cell[StyleData["ItemPictureBigger3", "EnhancedPrintout"],
  CellMargins->{{52, Inherited}, {10, -3}},
  Magnification->0.74],

Cell[StyleData["ItemPictureBigger3", "EnhancedPrintoutNonGray"],
  CellMargins->{{52, Inherited}, {10, -3}},
  Magnification->0.74]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger4"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger4", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureBigger4", "Printout"],
  CellMargins->{{45, Inherited}, {10, -2}},
  Magnification->0.77],

Cell[StyleData["ItemPictureBigger4", "EnhancedPrintout"],
  CellMargins->{{50, Inherited}, {10, -3}},
  Magnification->0.77],

Cell[StyleData["ItemPictureBigger4", "EnhancedPrintoutNonGray"],
  CellMargins->{{50, Inherited}, {10, -3}},
  Magnification->0.77]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger5"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger5", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureBigger5", "Printout"],
  CellMargins->{{43, Inherited}, {11, -2}},
  Magnification->0.8],

Cell[StyleData["ItemPictureBigger5", "EnhancedPrintout"],
  CellMargins->{{49, Inherited}, {10, -3}},
  Magnification->0.8],

Cell[StyleData["ItemPictureBigger5", "EnhancedPrintoutNonGray"],
  CellMargins->{{49, Inherited}, {10, -3}},
  Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger6"],
  CellMargins->{{41, Inherited}, {4, 2}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger6", "Presentation"],
  FontSize->18],

Cell[StyleData["ItemPictureBigger6", "Printout"],
  CellMargins->{{43, Inherited}, {12, -2}},
  Magnification->0.83],

Cell[StyleData["ItemPictureBigger6", "EnhancedPrintout"],
  CellMargins->{{46, Inherited}, {8, -2}},
  Magnification->0.83],

Cell[StyleData["ItemPictureBigger6", "EnhancedPrintoutNonGray"],
  CellMargins->{{46, Inherited}, {8, -2}},
  Magnification->0.83]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ScreenGraphic"],
  CellMargins->{{12, Inherited}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["ScreenGraphic", "Presentation"],
  FontSize->18],

Cell[StyleData["ScreenGraphic", "Printout"],
  CellMargins->{{2, Inherited}, {0, 8}}],

Cell[StyleData["ScreenGraphic", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {0, 8}},
  CellElementSpacings->{"CellMinHeight"->2,
  "ClosedCellHeight"->2},
  CellOpen->False],

Cell[StyleData["ScreenGraphic", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {0, 8}},
  CellElementSpacings->{"CellMinHeight"->2,
  "ClosedCellHeight"->2},
  CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PrintGraphic"],
  CellMargins->{{12, Inherited}, {0, 8}},
  CellElementSpacings->{"CellMinHeight"->2,
  "ClosedCellHeight"->2},
  CellOpen->False,
  CellHorizontalScrolling->True,
  StyleMenuListing->None],

Cell[StyleData["PrintGraphic", "Presentation"],
  FontSize->18],

Cell[StyleData["PrintGraphic", "Printout"],
  CellMargins->{{2, Inherited}, {0, 8}},
  CellElementSpacings->{"CellMinHeight"->2,
  "ClosedCellHeight"->2},
  CellOpen->False],

Cell[StyleData["PrintGraphic", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {0, 8}},
  CellElementSpacings->{"CellMinHeight"->12},
  CellOpen->True],

Cell[StyleData["PrintGraphic", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {0, 8}},
  CellElementSpacings->{"CellMinHeight"->12},
  CellOpen->True]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallTextSans"],
  CellMargins->{{10, 4}, {8, 8}},
  TextJustification->1,
  LineSpacing->{1, 2},
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SmallTextSans", "Presentation"],
  FontSize->14],

Cell[StyleData["SmallTextSans", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  FontSize->7],

Cell[StyleData["SmallTextSans", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  Hyphenation->True,
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, -2},
  FontFamily->"Frutiger-Roman",
  FontSize->7]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["AuthorTools", "Section"],

Cell[CellGroupData[{

Cell[StyleData["BilateralCell"],
  CellMargins->{{27, 4}, {0, 8}},
  StyleMenuListing->None,
  FontSize->12,
  GridBoxOptions->{ColumnWidths->{0.33, 0.6},
  RowAlignments->Top,
  ColumnAlignments->{Left}}],

Cell[StyleData["BilateralCell", "Presentation"],
  FontSize->18],

Cell[StyleData["BilateralCell", "SlideShow"],
  CellMargins->{{36, 24}, {4, 4}},
  Background->GrayLevel[0.900008]],

Cell[StyleData["BilateralCell", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontSize->10],

Cell[StyleData["BilateralCell", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["BilateralCell", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RuledPageBreak"],
  CellFrame->{{0, 0}, {0.25, 0}},
  CellMargins->{{27, 4}, {12, 0}},
  CellFrameMargins->{{0, 0}, {1, 0}},
  FontSize->8],

Cell[StyleData["RuledPageBreak", "Presentation"],
  FontSize->12],

Cell[StyleData["RuledPageBreak", "SlideShow"],
  CellMargins->{{36, 24}, {4, 4}}],

Cell[StyleData["RuledPageBreak", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  PageBreakBelow->True,
  FontSize->1],

Cell[StyleData["RuledPageBreak", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  PageBreakBelow->True],

Cell[StyleData["RuledPageBreak", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {6, 6}},
  PageBreakBelow->True]
}, Closed]],

Cell[StyleData["PaletteTitle"],
  CellFrame->{{0, 0}, {1, 0}},
  CellMargins->{{4, 0}, {Inherited, 0}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0, 0.32549, 0.537255],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #2]}]&),
  ButtonEvaluator->None,
  ButtonStyle->"PaletteButton",
  ButtonMargins->3}],

Cell[StyleData["PaletteButton"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  ButtonBoxOptions->{ButtonEvaluator->"Local",
  Active->True,
  ButtonMargins->6,
  Background->RGBColor[0.329412, 0.584314, 0.694118]}],

Cell[StyleData["PaletteButton2"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  ButtonBoxOptions->{ButtonEvaluator->"Local",
  Active->True,
  ButtonMargins->4,
  Background->RGBColor[0.537255, 0.72549, 0.843137]}]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
  CellMargins->{{27, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 50},
  ParagraphIndent->-38,
  CounterIncrements->"Outline1",
  CounterAssignments->{{"Outline2", 0}, {"Outline3", 0}, {"Outline4", 0}},
  FontSize->18,
  FontWeight->"Bold",
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "Presentation"],
  FontSize->27],

Cell[StyleData["Outline1", "Printout"],
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
  CellMargins->{{57, 10}, {6, 6}},
  CellGroupingRules->{"SectionGrouping", 60},
  ParagraphIndent->-27,
  CounterIncrements->"Outline2",
  CounterAssignments->{{"Outline3", 0}, {"Outline4", 0}},
  FontSize->15,
  FontWeight->"Bold",
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)}],

Cell[StyleData["Outline2", "Presentation"],
  FontSize->23],

Cell[StyleData["Outline2", "Printout"],
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
  CellMargins->{{87, 10}, {5, 5}},
  CellGroupingRules->{"SectionGrouping", 70},
  ParagraphIndent->-21,
  CounterIncrements->"Outline3",
  CounterAssignments->{{"Outline4", 0}},
  FontSize->12,
  CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "Presentation"],
  FontSize->18],

Cell[StyleData["Outline3", "Printout"],
  CounterBoxOptions->{CounterFunction:>Identity}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
  CellMargins->{{117, 10}, {4, 4}},
  CellGroupingRules->{"SectionGrouping", 80},
  ParagraphIndent->-18,
  CounterIncrements->"Outline4",
  FontSize->10,
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "a", "z"], #]&)}],

Cell[StyleData["Outline4", "Presentation"],
  FontSize->15],

Cell[StyleData["Outline4", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", -5},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Title Page, Contents, and Index", "Section"],

Cell[CellGroupData[{

Cell[StyleData["ContentsTitle"],
  CellMargins->{{21, 4}, {12, 24}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontWeight->"Bold",
  FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["ContentsTitle", "Presentation"],
  FontSize->36],

Cell[StyleData["ContentsTitle", "Printout"],
  CellMargins->{{12, 0}, {102, 89}},
  PageBreakBelow->False,
  FontSize->30.5,
  FontColor->GrayLevel[0]],

Cell[StyleData["ContentsTitle", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {15, 30}},
  PageBreakBelow->False,
  FontFamily->"Frutiger-Bold",
  FontSize->30.5,
  FontWeight->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ContentsSection"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{35, 4}, {3, 18}},
  CellGroupingRules->{"SectionGrouping", 70},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["ContentsSection", "Presentation"],
  FontSize->18],

Cell[StyleData["ContentsSection", "Printout"],
  CellMargins->{{20, 0}, {3, 18}},
  PageBreakBelow->False,
  FontSize->11],

Cell[StyleData["ContentsSection", "EnhancedPrintout"],
  CellMargins->{{20, 0}, {3, 18}},
  PageBreakBelow->False,
  FontFamily->"Frutiger-Bold",
  FontSize->11,
  FontWeight->"Plain"],

Cell[StyleData["ContentsSection", "EnhancedPrintoutNonGray"],
  CellMargins->{{20, 0}, {3, 18}},
  PageBreakBelow->False,
  FontFamily->"Frutiger-Bold",
  FontSize->11,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{20, 4}, {5, 20}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["IndexSection", "Presentation"],
  FontSize->18],

Cell[StyleData["IndexSection", "Printout"],
  CellMargins->{{12, 0}, {5, 20}},
  PageBreakBelow->False,
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Contents"],
  ShowGroupOpenCloseIcon->False,
  CellMargins->{{50, 4}, {0, 5}},
  CellGroupingRules->{"SectionGrouping", 90},
  StyleMenuListing->None],

Cell[StyleData["Contents", "Presentation"],
  FontSize->18],

Cell[StyleData["Contents", "Printout"],
  CellMargins->{{40, 4}, {0, 5}},
  FontSize->11],

Cell[StyleData["Contents", "EnhancedPrintout"],
  CellMargins->{{40, 5}, {0, 5}},
  FontFamily->"Palatino",
  FontSize->11],

Cell[StyleData["Contents", "EnhancedPrintoutNonGray"],
  CellMargins->{{40, 5}, {0, 5}},
  FontFamily->"Palatino",
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Index"],
  CellMargins->{{21, 4}, {0, 0}},
  ParagraphIndent->-48,
  StyleMenuListing->None],

Cell[StyleData["Index", "Presentation"],
  FontSize->18],

Cell[StyleData["Index", "Printout"],
  CellMargins->{{13, 0}, {0, 0}},
  FontSize->9],

Cell[StyleData["Index", "EnhancedPrintout"],
  CellMargins->{{13, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->9],

Cell[StyleData["Index", "EnhancedPrintoutNonGray"],
  CellMargins->{{13, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSubentry"],
  CellMargins->{{36, 4}, {0, 0}},
  ParagraphIndent->-48],

Cell[StyleData["IndexSubentry", "Presentation"],
  FontSize->18],

Cell[StyleData["IndexSubentry", "Printout"],
  CellMargins->{{24, 0}, {0, 0}},
  FontSize->9],

Cell[StyleData["IndexSubentry", "EnhancedPrintout"],
  CellMargins->{{24, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Index2Column"],
  CellMargins->{{21, 4}, {0, 8}},
  ParagraphIndent->-20,
  TabSpacings->1,
  StyleMenuListing->None,
  FontSize->10,
  GridBoxOptions->{ColumnWidths->0.5,
  ColumnAlignments->{Left}}],

Cell[StyleData["Index2Column", "Presentation"],
  FontSize->15],

Cell[StyleData["Index2Column", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->8],

Cell[StyleData["Index2Column", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {1, 1}},
  LineSpacing->{1, 0.2},
  FontFamily->"Palatino",
  FontSize->8],

Cell[StyleData["Index2Column", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {1, 1}},
  LineSpacing->{1, 0.2},
  FontFamily->"Palatino",
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Leader"],
  TabFilling->".",
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Plain"],

Cell[StyleData["Leader", "Printout"],
  FontSize->10],

Cell[StyleData["Leader", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LeaderNoDots"],
  TabFilling->" ",
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Plain"],

Cell[StyleData["LeaderNoDots", "Printout"],
  FontSize->10],

Cell[StyleData["LeaderNoDots", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["PageLink", "Printout"],
  FontColor->GrayLevel[0]],

Cell[StyleData["PageLink", "EnhancedPrintout"],
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCPage"],
  CellSize->{22, Inherited},
  TextAlignment->Right,
  StyleMenuListing->None,
  FontSize->12,
  FontWeight->"Plain"],

Cell[StyleData["TOCPage", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCPage", "Printout"],
  FontSize->10],

Cell[StyleData["TOCPage", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTitle"],
  CellMargins->{{20, 0}, {1, 8}},
  CellGroupingRules->{"SectionGrouping", 70},
  TabSpacings->46,
  CounterIncrements->"TOCTitle",
  CounterAssignments->{{"TOCSection", 0}},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["TOCTitle", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCTitle", "Printout"],
  CellMargins->{{12, 0}, {1, 8}},
  PageBreakBelow->False,
  TabSpacings->47.4,
  FontSize->11],

Cell[StyleData["TOCTitle", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {2, 10}},
  PageBreakBelow->False,
  TabSpacings->49.3,
  FontFamily->"Frutiger-Bold",
  FontSize->10,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSection"],
  CellMargins->{{48, 0}, {1, 1}},
  CellGroupingRules->{"SectionGrouping", 75},
  TabSpacings->42.9,
  CounterIncrements->"TOCSection",
  CounterAssignments->{{"TOCSubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->12],

Cell[StyleData["TOCSection", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCSection", "Printout"],
  CellMargins->{{30, 0}, {1, 1}},
  PageBreakBelow->False,
  FontSize->12],

Cell[StyleData["TOCSection", "EnhancedPrintout"],
  CellMargins->{{26, 0}, {1, 3}},
  PageBreakBelow->False,
  TabSpacings->46.45,
  FontFamily->"Frutiger-Roman",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsection"],
  CellMargins->{{76, 0}, {1, 1}},
  CellGroupingRules->{"SectionGrouping", 80},
  TabSpacings->39.8,
  CounterIncrements->"TOCSubsection",
  CounterAssignments->{{"TOCSubsubsection", 0}},
  FontSize->12],

Cell[StyleData["TOCSubsection", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCSubsection", "Printout"],
  CellMargins->{{70, 0}, {1, 1}},
  PageBreakBelow->False,
  FontSize->10],

Cell[StyleData["TOCSubsection", "EnhancedPrintout"],
  CellMargins->{{38, 0}, {1, 1}},
  PageBreakBelow->False,
  TabSpacings->45.15,
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsubsection"],
  CellMargins->{{104, 0}, {1, 1}},
  CellGroupingRules->{"SectionGrouping", 85},
  TabSpacings->36.7,
  CounterIncrements->"TOCSubsubsection",
  FontSize->12],

Cell[StyleData["TOCSubsubsection", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCSubsubsection", "Printout"],
  CellMargins->{{96, 0}, {1, 1}},
  PageBreakBelow->False,
  FontSize->9],

Cell[StyleData["TOCSubsubsection", "EnhancedPrintout"],
  CellMargins->{{96, 0}, {1, 1}},
  PageBreakBelow->False,
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTitleDingbat"],
  CellSize->{34, Inherited},
  TextAlignment->Right],

Cell[StyleData["TOCTitleDingbat", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSectionDingbat"],
  CellSize->{38, Inherited},
  TextAlignment->Right],

Cell[StyleData["TOCSectionDingbat", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsectionDingbat"],
  CellSize->{54, Inherited},
  TextAlignment->Right],

Cell[StyleData["TOCSubsectionDingbat", "EnhancedPrintout"],
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTitleCondensed"],
  CellMargins->{{20, 0}, {1, 8}},
  CellGroupingRules->{"SectionGrouping", 70},
  TabSpacings->50.4,
  CounterIncrements->"TOCTitleCondensed",
  CounterAssignments->{{"TOCSectionCondensed", 0}, {
      "TOCSubsectionCondensed", 0}},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["TOCTitleCondensed", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCTitleCondensed", "Printout"],
  CellMargins->{{12, 0}, {1, 8}},
  PageBreakBelow->False,
  FontSize->11],

Cell[StyleData["TOCTitleCondensed", "EnhancedPrintout"],
  CellMargins->{{12, 0}, {1, 8}},
  PageBreakBelow->False,
  FontFamily->"Frutiger-Bold",
  FontSize->11,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSectionCondensed"],
  CellMargins->{{48, 0}, {1, 1}},
  CellGroupingRules->{"SectionGrouping", 75},
  TabSpacings->47.4,
  CounterIncrements->"TOCSectionCondensed",
  CounterAssignments->{{"TOCSubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Bold",
  FontColor->GrayLevel[0.2]],

Cell[StyleData["TOCSectionCondensed", "Presentation"],
  FontSize->15],

Cell[StyleData["TOCSectionCondensed", "Printout"],
  CellMargins->{{36, 0}, {1, 1}},
  PageBreakBelow->False,
  FontSize->11],

Cell[StyleData["TOCSectionCondensed", "EnhancedPrintout"],
  CellMargins->{{36, 0}, {1, 1}},
  PageBreakBelow->False,
  FontFamily->"Palatino",
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsectionCondensed"],
  PageWidth->470,
  CellMargins->{{76, 0}, {1, 1}},
  CellGroupingRules->{"SectionGrouping", 80},
  TextJustification->1,
  FontSize->12],

Cell[StyleData["TOCSubsectionCondensed", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCSubsectionCondensed", "Printout"],
  CellMargins->{{72, 0}, {1, 1}},
  PageBreakBelow->False,
  Hyphenation->True,
  FontSize->10],

Cell[StyleData["TOCSubsectionCondensed", "EnhancedPrintout"],
  CellMargins->{{72, 0}, {1, 1}},
  PageBreakBelow->False,
  Hyphenation->True,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsubsectionCondensed"],
  CellMargins->{{104, 0}, {1, 1}},
  CellGroupingRules->{"SectionGrouping", 85},
  TabSpacings->39.3,
  CounterIncrements->"TOCSubsubsectionCondensed",
  FontSize->12],

Cell[StyleData["TOCSubsubsectionCondensed", "Presentation"],
  FontSize->18],

Cell[StyleData["TOCSubsubsectionCondensed", "Printout"],
  CellMargins->{{96, 0}, {1, 1}},
  PageBreakBelow->False,
  FontSize->9],

Cell[StyleData["TOCSubsubsectionCondensed", "EnhancedPrintout"],
  CellMargins->{{96, 0}, {1, 1}},
  PageBreakBelow->False,
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TitlePageGraphic"],
  CellMargins->{{0, 0}, {100, 20}},
  Evaluatable->False,
  PageBreakBelow->False,
  TextAlignment->Center],

Cell[StyleData["TitlePageGraphic", "Presentation"],
  FontSize->18],

Cell[StyleData["TitlePageGraphic", "Printout"],
  CellMargins->{{0, 0}, {230, 88}}],

Cell[StyleData["TitlePageGraphic", "EnhancedPrintout"],
  CellMargins->{{0, 0}, {230, 88}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TitlePageLogo"],
  CellMargins->{{0, 0}, {0, 0}}],

Cell[StyleData["TitlePageLogo", "Presentation"],
  FontSize->18],

Cell[StyleData["TitlePageLogo", "Printout"]],

Cell[StyleData["TitlePageLogo", "EnhancedPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Horizontal Lines", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Line1"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{10, 4}, {-16, 9}},
  StyleMenuListing->None,
  FontSize->2],

Cell[StyleData["Line1", "Presentation"],
  FontSize->3],

Cell[StyleData["Line1", "Printout"],
  CellMargins->{{2, 0}, {-16, 9}}]
}, Closed]],

Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["ProgramTop"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{27, 4}, {-18, 18}},
  LineSpacing->{1, -4},
  StyleMenuListing->None,
  FontSize->4],

Cell[StyleData["ProgramTop", "Presentation"],
  FontSize->6],

Cell[StyleData["ProgramTop", "Printout"],
  CellMargins->{{2, 0}, {-18, 18}}]
}, Closed]],

Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["ProgramBottom"],
  CellFrame->{{0.5, 0.5}, {0.5, 0}},
  CellMargins->{{27, 4}, {-10, -2}},
  LineSpacing->{1, -4},
  StyleMenuListing->None,
  FontSize->4],

Cell[StyleData["ProgramBottom", "Presentation"],
  FontSize->6],

Cell[StyleData["ProgramBottom", "Printout"],
  CellMargins->{{2, 0}, {-10, -2}}]
}, Closed]],

Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["SessionLabel"],
  CellFrame->{{0.5, 0}, {0, 0.5}},
  CellMargins->{{27, 4}, {-4, 18}},
  LineSpacing->{1, 0},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SessionLabel", "Presentation"],
  FontSize->14],

Cell[StyleData["SessionLabel", "Printout"],
  CellMargins->{{2, 0}, {-4, 18}},
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Headers and Footers", "Section"],

Cell[CellGroupData[{

Cell[StyleData["PageHeader"],
  CellMargins->{{0, 0}, {2, 0}},
  StyleMenuListing->None,
  FontSize->8,
  FontSlant->"Italic"],

Cell[StyleData["PageHeader", "Printout"]],

Cell[StyleData["PageHeader", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman"],

Cell[StyleData["PageHeader", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Roman"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {2, 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->8,
  FontWeight->"Bold"],

Cell[StyleData["PageNumber", "Printout"]],

Cell[StyleData["PageNumber", "EnhancedPrintout"],
  FontFamily->"Frutiger-Bold",
  FontWeight->"Plain"],

Cell[StyleData["PageNumber", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Bold",
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageFooter"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6],

Cell[StyleData["PageFooter", "Printout"]],

Cell[StyleData["PageFooter", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman"],

Cell[StyleData["PageFooter", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Roman"]
}, Closed]],

Cell[CellGroupData[{

Cell["For compatibility", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {2, 0}},
  StyleMenuListing->None,
  FontSize->8,
  FontSlant->"Italic"],

Cell[StyleData["Header", "Printout"]],

Cell[StyleData["Header", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman",
  FontSlant->"Plain"],

Cell[StyleData["Header", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Roman",
  FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Footer"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6],

Cell[StyleData["Footer", "Printout"]],

Cell[StyleData["Footer", "EnhancedPrintout"],
  FontFamily->"Frutiger-Roman"],

Cell[StyleData["Footer", "EnhancedPrintoutNonGray"],
  FontFamily->"Frutiger-Roman"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of most \
cells.  If a cell's FormatType matches the name of one of the styles defined \
below, then that style is applied between the cell's style and its own \
options. This is particularly true of Input and Output.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  Hyphenation->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  Background->GrayLevel[1]],

Cell[StyleData["CellExpression", "EnhancedPrintout"],
  FontFamily->"Courier Std",
  FontSize->10],

Cell[StyleData["CellExpression", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputForm"],
  InputAutoReplacements->{},
  AllowInlineCells->False,
  Hyphenation->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["InputForm", "EnhancedPrintout"],
  FontFamily->"Courier Std"],

Cell[StyleData["InputForm", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{0.6, 1},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm", "EnhancedPrintout"],
  FontFamily->"Courier Std"],

Cell[StyleData["OutputForm", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["StandardForm"],
  InputAutoReplacements->{
    "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
      ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
      Inherited},
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm", "EnhancedPrintout"],
  FontFamily->"Courier Std"],

Cell[StyleData["StandardForm", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier Std"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic Styles", "Section"],

Cell["\<\
The cells below define styles that are used to affect the display of certain \
types of objects in typeset expressions.  For example, \"UnmatchedBracket\" \
style defines how unmatched bracket, curly bracket, and parenthesis \
characters are displayed (typically by coloring them to make them stand out).\
\
\>", "Text"],

Cell[StyleData["UnmatchedBracket"],
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 832}},
WindowSize->{500, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "FunctionName"->{
    Cell[140614, 5224, 290, 9, 70, 31, 0, "StyleData", "FunctionName", "All",
      StyleMenuListing->None,
      CellTags->"FunctionName"]},
  "FunctionSubsection"->{
    Cell[141371, 5255, 259, 7, 70, 37, 0, "StyleData", "FunctionSubsection", 
    "All",
      StyleMenuListing->None,
      CellTags->"FunctionSubsection"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"FunctionName", 238083, 8928},
  {"FunctionSubsection", 238251, 8932}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 50, 0, 136, "Title"],
Cell[1829, 55, 139, 3, 50, "Text"],

Cell[CellGroupData[{
Cell[1993, 62, 42, 0, 69, "Section"],
Cell[2038, 64, 196, 5, 38, 31, 0, "StyleData", "All", "Working"],
Cell[2237, 71, 196, 5, 38, 32, 0, "StyleData", "All", "Brackets"],
Cell[2436, 78, 201, 5, 38, 36, 0, "StyleData", "All", "Presentation"],
Cell[2640, 85, 182, 5, 38, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2825, 92, 175, 5, 36, 32, 0, "StyleData", "All", "Printout"],
Cell[3003, 99, 183, 5, 37, 40, 0, "StyleData", "All", "EnhancedPrintout"],
Cell[3189, 106, 191, 5, 37, 47, 0, "StyleData", "All", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[3417, 116, 35, 0, 39, "Section"],
Cell[3455, 118, 105, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[3585, 125, 1051, 26, 38, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None],
Cell[4639, 153, 979, 23, 38, 39, 0, "StyleData", "Notebook", "Printout"],
Cell[5621, 178, 371, 9, 38, 47, 0, "StyleData", "Notebook", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6041, 193, 27, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[6093, 197, 1703, 40, 70, 26, 0, "StyleData", "Chapter", "All",
  CounterIncrements->"Chapter",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[7799, 239, 58, 1, 70, 42, 0, "StyleData", "Chapter", "Presentation"],
Cell[7860, 242, 89, 2, 70, 38, 0, "StyleData", "Chapter", "Printout"],
Cell[7952, 246, 156, 4, 70, 46, 0, "StyleData", "Chapter", \
"EnhancedPrintout"],
Cell[8111, 252, 136, 3, 70, 53, 0, "StyleData", "Chapter", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[8284, 260, 1544, 36, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[9831, 298, 58, 1, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[9892, 301, 346, 10, 70, 39, 0, "StyleData", "Section", "SlideShow"],
Cell[10241, 313, 113, 3, 70, 38, 0, "StyleData", "Section", "Printout"],
Cell[10357, 318, 401, 11, 70, 46, 0, "StyleData", "Section", \
"EnhancedPrintout",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[10761, 331, 389, 10, 70, 53, 0, "StyleData", "Section", \
"EnhancedPrintoutNonGray",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}]
}, Closed]],

Cell[CellGroupData[{
Cell[11187, 346, 1633, 39, 70, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[12823, 387, 61, 1, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[12887, 390, 114, 3, 70, 42, 0, "StyleData", "Subsection", "SlideShow"],
Cell[13004, 395, 91, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[13098, 399, 180, 5, 70, 49, 0, "StyleData", "Subsection", \
"EnhancedPrintout"],
Cell[13281, 406, 160, 4, 70, 56, 0, "StyleData", "Subsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[13478, 415, 1506, 35, 70, 32, 0, "StyleData", "Subsubsection", "All"],
Cell[14987, 452, 64, 1, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[15054, 455, 93, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[15150, 459, 182, 5, 70, 52, 0, "StyleData", "Subsubsection", \
"EnhancedPrintout"],
Cell[15335, 466, 162, 4, 70, 59, 0, "StyleData", "Subsubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[15534, 475, 1505, 35, 70, 37, 0, "StyleData", "SubsubsectionColor", \
"All",
  StyleMenuListing->None],
Cell[17042, 512, 69, 1, 70, 53, 0, "StyleData", "SubsubsectionColor", \
"Presentation"],
Cell[17114, 515, 124, 3, 70, 49, 0, "StyleData", "SubsubsectionColor", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[17275, 523, 1548, 36, 70, 33, 0, "StyleData", "SubsectionIcon", "All",
  CounterIncrements->"Subsection"],
Cell[18826, 561, 65, 1, 70, 49, 0, "StyleData", "SubsectionIcon", \
"Presentation"],
Cell[18894, 564, 188, 5, 70, 45, 0, "StyleData", "SubsectionIcon", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19119, 574, 1553, 36, 70, 36, 0, "StyleData", "SubsubsectionIcon", "All",
  
  CounterIncrements->"Subsubsection"],
Cell[20675, 612, 68, 1, 70, 52, 0, "StyleData", "SubsubsectionIcon", \
"Presentation"],
Cell[20746, 615, 156, 4, 70, 48, 0, "StyleData", "SubsubsectionIcon", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20951, 625, 23, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[20999, 629, 1327, 31, 70, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[22329, 662, 55, 1, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[22387, 665, 109, 3, 70, 36, 0, "StyleData", "Text", "SlideShow"],
Cell[22499, 670, 129, 4, 70, 35, 0, "StyleData", "Text", "Printout"],
Cell[22631, 676, 163, 5, 70, 43, 0, "StyleData", "Text", "EnhancedPrintout"],
Cell[22797, 683, 170, 5, 70, 50, 0, "StyleData", "Text", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[23004, 693, 135, 4, 70, 30, 0, "StyleData", "CompactText", "All",
  StyleMenuListing->None],
Cell[23142, 699, 62, 1, 70, 46, 0, "StyleData", "CompactText", \
"Presentation"],
Cell[23207, 702, 111, 3, 70, 42, 0, "StyleData", "CompactText", "Printout"],
Cell[23321, 707, 145, 4, 70, 50, 0, "StyleData", "CompactText", \
"EnhancedPrintout"],
Cell[23469, 713, 152, 4, 70, 57, 0, "StyleData", "CompactText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[23658, 722, 121, 3, 70, 32, 0, "StyleData", "Compact12Text", "All",
  StyleMenuListing->None],
Cell[23782, 727, 64, 1, 70, 48, 0, "StyleData", "Compact12Text", \
"Presentation"],
Cell[23849, 730, 114, 3, 70, 44, 0, "StyleData", "Compact12Text", \
"Printout"],
Cell[23966, 735, 148, 4, 70, 52, 0, "StyleData", "Compact12Text", \
"EnhancedPrintout"],
Cell[24117, 741, 155, 4, 70, 59, 0, "StyleData", "Compact12Text", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[24309, 750, 192, 6, 70, 27, 0, "StyleData", "TextSans", "All",
  StyleMenuListing->None],
Cell[24504, 758, 59, 1, 70, 43, 0, "StyleData", "TextSans", "Presentation"],
Cell[24566, 761, 108, 3, 70, 39, 0, "StyleData", "TextSans", "Printout"],
Cell[24677, 766, 148, 4, 70, 47, 0, "StyleData", "TextSans", \
"EnhancedPrintout"],
Cell[24828, 772, 155, 4, 70, 54, 0, "StyleData", "TextSans", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[25020, 781, 175, 5, 70, 31, 0, "StyleData", "ItemizedText", "All",
  CounterIncrements->"ItemizedText",
  StyleMenuListing->None],
Cell[25198, 788, 63, 1, 70, 47, 0, "StyleData", "ItemizedText", \
"Presentation"],
Cell[25264, 791, 114, 3, 70, 43, 0, "StyleData", "ItemizedText", "Printout"],
Cell[25381, 796, 171, 5, 70, 51, 0, "StyleData", "ItemizedText", \
"EnhancedPrintout"],
Cell[25555, 803, 168, 5, 70, 58, 0, "StyleData", "ItemizedText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[25760, 813, 159, 4, 70, 35, 0, "StyleData", "ItemizedTextNote", "All",
  CounterIncrements->"ItemizedTextNote",
  StyleMenuListing->None],
Cell[25922, 819, 67, 1, 70, 51, 0, "StyleData", "ItemizedTextNote", \
"Presentation"],
Cell[25992, 822, 118, 3, 70, 47, 0, "StyleData", "ItemizedTextNote", \
"Printout"],
Cell[26113, 827, 175, 5, 70, 55, 0, "StyleData", "ItemizedTextNote", \
"EnhancedPrintout"],
Cell[26291, 834, 182, 5, 70, 62, 0, "StyleData", "ItemizedTextNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[26510, 844, 151, 4, 70, 31, 0, "StyleData", "IndentedText", "All",
  CounterIncrements->"IndentedText",
  StyleMenuListing->None],
Cell[26664, 850, 63, 1, 70, 47, 0, "StyleData", "IndentedText", \
"Presentation"],
Cell[26730, 853, 117, 3, 70, 44, 0, "StyleData", "IndentedText", \
"SlideShow"],
Cell[26850, 858, 114, 3, 70, 43, 0, "StyleData", "IndentedText", "Printout"],
Cell[26967, 863, 195, 5, 70, 51, 0, "StyleData", "IndentedText", \
"EnhancedPrintout"],
Cell[27165, 870, 144, 4, 70, 58, 0, "StyleData", "IndentedText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[27346, 879, 446, 11, 70, 31, 0, "StyleData", "ItemizedList", "All",
  CounterIncrements->"ItemizedList",
  StyleMenuListing->None],
Cell[27795, 892, 63, 1, 70, 47, 0, "StyleData", "ItemizedList", \
"Presentation"],
Cell[27861, 895, 113, 3, 70, 43, 0, "StyleData", "ItemizedList", "Printout"],
Cell[27977, 900, 170, 5, 70, 51, 0, "StyleData", "ItemizedList", \
"EnhancedPrintout"],
Cell[28150, 907, 144, 4, 70, 58, 0, "StyleData", "ItemizedList", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[28331, 916, 519, 12, 70, 34, 0, "StyleData", "ItemizedSubList", "All",
  CounterIncrements->"ItemizedSubList",
  StyleMenuListing->None],
Cell[28853, 930, 66, 1, 70, 50, 0, "StyleData", "ItemizedSubList", \
"Presentation"],
Cell[28922, 933, 117, 3, 70, 46, 0, "StyleData", "ItemizedSubList", \
"Printout"],
Cell[29042, 938, 151, 4, 70, 54, 0, "StyleData", "ItemizedSubList", \
"EnhancedPrintout"],
Cell[29196, 944, 124, 3, 70, 61, 0, "StyleData", "ItemizedSubList", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[29357, 952, 226, 5, 70, 38, 0, "StyleData", "ItemizedSubListNote", "All",
  
  CounterIncrements->"ItemizedSubList",
  StyleMenuListing->None],
Cell[29586, 959, 70, 1, 70, 54, 0, "StyleData", "ItemizedSubListNote", \
"Presentation"],
Cell[29659, 962, 121, 3, 70, 50, 0, "StyleData", "ItemizedSubListNote", \
"Printout"],
Cell[29783, 967, 155, 4, 70, 58, 0, "StyleData", "ItemizedSubListNote", \
"EnhancedPrintout"],
Cell[29941, 973, 162, 4, 70, 65, 0, "StyleData", "ItemizedSubListNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[30140, 982, 283, 7, 70, 31, 0, "StyleData", "BulletedList", "All",
  CounterIncrements->"BulletText",
  StyleMenuListing->None],
Cell[30426, 991, 63, 1, 70, 47, 0, "StyleData", "BulletedList", \
"Presentation"],
Cell[30492, 994, 114, 3, 70, 43, 0, "StyleData", "BulletedList", "Printout"],
Cell[30609, 999, 171, 5, 70, 51, 0, "StyleData", "BulletedList", \
"EnhancedPrintout"],
Cell[30783, 1006, 144, 4, 70, 58, 0, "StyleData", "BulletedList", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[30964, 1015, 143, 4, 70, 27, 0, "StyleData", "ListNote", "All",
  CounterIncrements->"ListNote",
  StyleMenuListing->None],
Cell[31110, 1021, 59, 1, 70, 43, 0, "StyleData", "ListNote", "Presentation"],
Cell[31172, 1024, 110, 3, 70, 39, 0, "StyleData", "ListNote", "Printout"],
Cell[31285, 1029, 167, 5, 70, 47, 0, "StyleData", "ListNote", \
"EnhancedPrintout"],
Cell[31455, 1036, 174, 5, 70, 54, 0, "StyleData", "ListNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[31666, 1046, 309, 9, 70, 30, 0, "StyleData", "MathCaption", "All"],
Cell[31978, 1057, 62, 1, 70, 46, 0, "StyleData", "MathCaption", \
"Presentation"],
Cell[32043, 1060, 104, 2, 70, 43, 0, "StyleData", "MathCaption", \
"SlideShow"],
Cell[32150, 1064, 139, 4, 70, 42, 0, "StyleData", "MathCaption", "Printout"],
Cell[32292, 1070, 173, 5, 70, 50, 0, "StyleData", "MathCaption", \
"EnhancedPrintout"],
Cell[32468, 1077, 180, 5, 70, 57, 0, "StyleData", "MathCaption", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[32685, 1087, 165, 5, 70, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[32853, 1094, 60, 1, 70, 44, 0, "StyleData", "SmallText", \
"Presentation"],
Cell[32916, 1097, 133, 4, 70, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[33052, 1103, 167, 5, 70, 48, 0, "StyleData", "SmallText", \
"EnhancedPrintout"],
Cell[33222, 1110, 174, 5, 70, 55, 0, "StyleData", "SmallText", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33445, 1121, 31, 0, 39, "Section"],
Cell[33479, 1123, 252, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[33756, 1132, 648, 18, 70, 24, 0, "StyleData", "Input", "All"],
Cell[34407, 1152, 56, 1, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[34466, 1155, 228, 6, 70, 37, 0, "StyleData", "Input", "SlideShow"],
Cell[34697, 1163, 111, 3, 70, 36, 0, "StyleData", "Input", "Printout"],
Cell[34811, 1168, 119, 3, 70, 44, 0, "StyleData", "Input", \
"EnhancedPrintout"],
Cell[34933, 1173, 126, 3, 70, 51, 0, "StyleData", "Input", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[35096, 1181, 622, 17, 70, 25, 0, "StyleData", "Output", "All"],
Cell[35721, 1200, 57, 1, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[35781, 1203, 229, 6, 70, 38, 0, "StyleData", "Output", "SlideShow"],
Cell[36013, 1211, 112, 3, 70, 37, 0, "StyleData", "Output", "Printout"],
Cell[36128, 1216, 120, 3, 70, 45, 0, "StyleData", "Output", \
"EnhancedPrintout"],
Cell[36251, 1221, 127, 3, 70, 52, 0, "StyleData", "Output", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[36415, 1229, 678, 19, 70, 28, 0, "StyleData", "InputOnly", "All",
  StyleMenuListing->None],
Cell[37096, 1250, 60, 1, 70, 44, 0, "StyleData", "InputOnly", \
"Presentation"],
Cell[37159, 1253, 194, 5, 70, 41, 0, "StyleData", "InputOnly", "SlideShow"],
Cell[37356, 1260, 115, 3, 70, 40, 0, "StyleData", "InputOnly", "Printout"],
Cell[37474, 1265, 123, 3, 70, 48, 0, "StyleData", "InputOnly", \
"EnhancedPrintout"],
Cell[37600, 1270, 130, 3, 70, 55, 0, "StyleData", "InputOnly", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[37767, 1278, 756, 21, 70, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[38526, 1301, 58, 1, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[38587, 1304, 132, 3, 70, 39, 0, "StyleData", "Message", "SlideShow"],
Cell[38722, 1309, 164, 4, 70, 38, 0, "StyleData", "Message", "Printout"],
Cell[38889, 1315, 197, 5, 70, 46, 0, "StyleData", "Message", \
"EnhancedPrintout"],
Cell[39089, 1322, 204, 5, 70, 53, 0, "StyleData", "Message", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[39330, 1332, 578, 16, 70, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[39911, 1350, 56, 1, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[39970, 1353, 73, 1, 70, 37, 0, "StyleData", "Print", "SlideShow"],
Cell[40046, 1356, 135, 3, 70, 36, 0, "StyleData", "Print", "Printout"],
Cell[40184, 1361, 172, 4, 70, 44, 0, "StyleData", "Print", \
"EnhancedPrintout"],
Cell[40359, 1367, 179, 4, 70, 51, 0, "StyleData", "Print", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[40575, 1376, 376, 12, 70, 27, 0, "StyleData", "Graphics", "All",
  StyleMenuListing->None],
Cell[40954, 1390, 59, 1, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[41016, 1393, 231, 6, 70, 40, 0, "StyleData", "Graphics", "SlideShow"],
Cell[41250, 1401, 163, 4, 70, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[41416, 1407, 200, 5, 70, 47, 0, "StyleData", "Graphics", \
"EnhancedPrintout"],
Cell[41619, 1414, 207, 5, 70, 54, 0, "StyleData", "Graphics", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[41863, 1424, 193, 6, 70, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[42059, 1432, 60, 1, 70, 44, 0, "StyleData", "CellLabel", \
"Presentation"],
Cell[42122, 1435, 82, 1, 70, 41, 0, "StyleData", "CellLabel", "SlideShow"],
Cell[42207, 1438, 131, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[42341, 1444, 143, 4, 70, 48, 0, "StyleData", "CellLabel", \
"EnhancedPrintout"],
Cell[42487, 1450, 150, 4, 70, 55, 0, "StyleData", "CellLabel", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[42674, 1459, 185, 6, 70, 23, 0, "StyleData", "Name", "All",
  StyleMenuListing->None],
Cell[42862, 1467, 55, 1, 70, 39, 0, "StyleData", "Name", "Presentation"],
Cell[42920, 1470, 101, 3, 70, 35, 0, "StyleData", "Name", "Printout"],
Cell[43024, 1475, 140, 4, 70, 43, 0, "StyleData", "Name", \
"EnhancedPrintout"],
Cell[43167, 1481, 147, 4, 70, 50, 0, "StyleData", "Name", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[43363, 1491, 29, 0, 39, "Section"],
Cell[43395, 1493, 340, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[43760, 1503, 279, 7, 70, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[44042, 1512, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"],
Cell[44152, 1516, 141, 3, 70, 48, 0, "StyleData", "Hyperlink", \
"EnhancedPrintout"],
Cell[44296, 1521, 148, 3, 70, 55, 0, "StyleData", "Hyperlink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[44481, 1529, 293, 7, 70, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[44777, 1538, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", \
"Printout"],
Cell[44890, 1542, 144, 3, 70, 51, 0, "StyleData", "MainBookLink", \
"EnhancedPrintout"],
Cell[45037, 1547, 151, 3, 70, 58, 0, "StyleData", "MainBookLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[45225, 1555, 320, 8, 70, 33, 0, "StyleData", "MainBookLinkMR", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[45548, 1565, 112, 2, 70, 45, 0, "StyleData", "MainBookLinkMR", \
"Printout"],
Cell[45663, 1569, 120, 2, 70, 53, 0, "StyleData", "MainBookLinkMR", \
"EnhancedPrintout"],
Cell[45786, 1573, 127, 2, 70, 60, 0, "StyleData", "MainBookLinkMR", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[45950, 1580, 314, 8, 70, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[46267, 1590, 108, 2, 70, 41, 0, "StyleData", "AddOnsLink", "Printout"],
Cell[46378, 1594, 144, 3, 70, 49, 0, "StyleData", "AddOnsLink", \
"EnhancedPrintout"],
Cell[46525, 1599, 151, 3, 70, 56, 0, "StyleData", "AddOnsLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[46713, 1607, 316, 8, 70, 33, 0, "StyleData", "AddOnsLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[47032, 1617, 112, 2, 70, 45, 0, "StyleData", "AddOnsLinkText", \
"Printout"],
Cell[47147, 1621, 146, 3, 70, 53, 0, "StyleData", "AddOnsLinkText", \
"EnhancedPrintout"],
Cell[47296, 1626, 153, 3, 70, 60, 0, "StyleData", "AddOnsLinkText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[47486, 1634, 318, 8, 70, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[47807, 1644, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", \
"Printout"],
Cell[47920, 1648, 146, 3, 70, 51, 0, "StyleData", "RefGuideLink", \
"EnhancedPrintout"],
Cell[48069, 1653, 153, 3, 70, 58, 0, "StyleData", "RefGuideLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[48259, 1661, 305, 7, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[48567, 1670, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"],
Cell[48686, 1674, 150, 3, 70, 57, 0, "StyleData", "GettingStartedLink", \
"EnhancedPrintout"],
Cell[48839, 1679, 157, 3, 70, 64, 0, "StyleData", "GettingStartedLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[49033, 1687, 287, 7, 70, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[49323, 1696, 107, 2, 70, 40, 0, "StyleData", "DemosLink", "Printout"],
Cell[49433, 1700, 115, 2, 70, 48, 0, "StyleData", "DemosLink", \
"EnhancedPrintout"],
Cell[49551, 1704, 122, 2, 70, 55, 0, "StyleData", "DemosLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[49710, 1711, 285, 7, 70, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[49998, 1720, 106, 2, 70, 39, 0, "StyleData", "TourLink", "Printout"],
Cell[50107, 1724, 114, 2, 70, 47, 0, "StyleData", "TourLink", \
"EnhancedPrintout"],
Cell[50224, 1728, 121, 2, 70, 54, 0, "StyleData", "TourLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[50382, 1735, 309, 7, 70, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[50694, 1744, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"],
Cell[50815, 1748, 152, 3, 70, 59, 0, "StyleData", "OtherInformationLink", \
"EnhancedPrintout"],
Cell[50970, 1753, 159, 3, 70, 66, 0, "StyleData", "OtherInformationLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[51166, 1761, 299, 7, 70, 41, 0, "StyleData", "OtherInformationLinkMR", \
"All",
  StyleMenuListing->None],
Cell[51468, 1770, 120, 2, 70, 53, 0, "StyleData", "OtherInformationLinkMR", \
"Printout"],
Cell[51591, 1774, 128, 2, 70, 61, 0, "StyleData", "OtherInformationLinkMR", \
"EnhancedPrintout"],
Cell[51722, 1778, 135, 2, 70, 68, 0, "StyleData", "OtherInformationLinkMR", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[51894, 1785, 299, 7, 70, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[52196, 1794, 113, 2, 70, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"],
Cell[52312, 1798, 121, 2, 70, 54, 0, "StyleData", "MasterIndexLink", \
"EnhancedPrintout"],
Cell[52436, 1802, 128, 2, 70, 61, 0, "StyleData", "MasterIndexLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[52601, 1809, 301, 8, 70, 31, 0, "StyleData", "NotebookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[52905, 1819, 126, 3, 70, 43, 0, "StyleData", "NotebookLink", \
"Printout"],
Cell[53034, 1824, 160, 4, 70, 51, 0, "StyleData", "NotebookLink", \
"EnhancedPrintout"],
Cell[53197, 1830, 167, 4, 70, 58, 0, "StyleData", "NotebookLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[53401, 1839, 305, 8, 70, 33, 0, "StyleData", "NotebookLinkMR", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[53709, 1849, 128, 3, 70, 45, 0, "StyleData", "NotebookLinkMR", \
"Printout"],
Cell[53840, 1854, 136, 3, 70, 53, 0, "StyleData", "NotebookLinkMR", \
"EnhancedPrintout"],
Cell[53979, 1859, 143, 3, 70, 60, 0, "StyleData", "NotebookLinkMR", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[54171, 1868, 33, 0, 39, "Section"],
Cell[54207, 1870, 121, 3, 70, "Text"],
Cell[54331, 1875, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[54560, 1882, 304, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[54867, 1891, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[55270, 1902, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[55660, 1913, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[56098, 1927, 36, 0, 39, "Section"],
Cell[56137, 1929, 121, 3, 50, "Text"],

Cell[CellGroupData[{
Cell[56283, 1936, 74, 2, 39, 21, 0, "StyleData", "JT", "All",
  StyleMenuListing->None],
Cell[56360, 1940, 33, 0, 70, 33, 0, "StyleData", "JT", "Printout"],
Cell[56396, 1942, 41, 0, 70, 41, 0, "StyleData", "JT", "EnhancedPrintout"],
Cell[56440, 1944, 48, 0, 70, 48, 0, "StyleData", "JT", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[56525, 1949, 74, 2, 39, 21, 0, "StyleData", "JS", "All",
  StyleMenuListing->None],
Cell[56602, 1953, 33, 0, 70, 33, 0, "StyleData", "JS", "Printout"],
Cell[56638, 1955, 41, 0, 70, 41, 0, "StyleData", "JS", "EnhancedPrintout"],
Cell[56682, 1957, 48, 0, 70, 48, 0, "StyleData", "JS", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[56767, 1962, 79, 2, 39, 22, 0, "StyleData", "JSB", "All",
  StyleMenuListing->None],
Cell[56849, 1966, 34, 0, 70, 34, 0, "StyleData", "JSB", "Printout"],
Cell[56886, 1968, 42, 0, 70, 42, 0, "StyleData", "JSB", "EnhancedPrintout"],
Cell[56931, 1970, 49, 0, 70, 49, 0, "StyleData", "JSB", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[57017, 1975, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[57112, 1980, 33, 0, 70, 33, 0, "StyleData", "RM", "Printout"],
Cell[57148, 1982, 41, 0, 70, 41, 0, "StyleData", "RM", "EnhancedPrintout"],
Cell[57192, 1984, 48, 0, 70, 48, 0, "StyleData", "RM", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[57277, 1989, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[57349, 1993, 33, 0, 70, 33, 0, "StyleData", "BF", "Printout"],
Cell[57385, 1995, 41, 0, 70, 41, 0, "StyleData", "BF", "EnhancedPrintout"],
Cell[57429, 1997, 48, 0, 70, 48, 0, "StyleData", "BF", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[57514, 2002, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[57587, 2006, 33, 0, 70, 33, 0, "StyleData", "IT", "Printout"],
Cell[57623, 2008, 41, 0, 70, 41, 0, "StyleData", "IT", "EnhancedPrintout"],
Cell[57667, 2010, 48, 0, 70, 48, 0, "StyleData", "IT", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[57752, 2015, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[57870, 2021, 33, 0, 70, 33, 0, "StyleData", "TR", "Printout"],
Cell[57906, 2023, 67, 1, 70, 41, 0, "StyleData", "TR", "EnhancedPrintout"],
Cell[57976, 2026, 74, 1, 70, 48, 0, "StyleData", "TR", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[58087, 2032, 93, 3, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[58183, 2037, 33, 0, 70, 33, 0, "StyleData", "TI", "Printout"],
Cell[58219, 2039, 67, 1, 70, 41, 0, "StyleData", "TI", "EnhancedPrintout"],
Cell[58289, 2042, 74, 1, 70, 48, 0, "StyleData", "TI", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[58400, 2048, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[58517, 2054, 33, 0, 70, 33, 0, "StyleData", "TB", "Printout"],
Cell[58553, 2056, 67, 1, 70, 41, 0, "StyleData", "TB", "EnhancedPrintout"],
Cell[58623, 2059, 74, 1, 70, 48, 0, "StyleData", "TB", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[58734, 2065, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[58853, 2071, 34, 0, 70, 34, 0, "StyleData", "TBI", "Printout"],
Cell[58890, 2073, 68, 1, 70, 42, 0, "StyleData", "TBI", "EnhancedPrintout"],
Cell[58961, 2076, 75, 1, 70, 49, 0, "StyleData", "TBI", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[59073, 2082, 228, 7, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[59304, 2091, 33, 0, 70, 33, 0, "StyleData", "MR", "Printout"],
Cell[59340, 2093, 70, 1, 70, 41, 0, "StyleData", "MR", "EnhancedPrintout"],
Cell[59413, 2096, 77, 1, 70, 48, 0, "StyleData", "MR", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[59527, 2102, 185, 5, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[59715, 2109, 57, 1, 70, 33, 0, "StyleData", "MO", "Printout"],
Cell[59775, 2112, 94, 2, 70, 41, 0, "StyleData", "MO", "EnhancedPrintout"],
Cell[59872, 2116, 101, 2, 70, 48, 0, "StyleData", "MO", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[60010, 2123, 183, 5, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[60196, 2130, 33, 0, 70, 33, 0, "StyleData", "MB", "Printout"],
Cell[60232, 2132, 70, 1, 70, 41, 0, "StyleData", "MB", "EnhancedPrintout"],
Cell[60305, 2135, 77, 1, 70, 48, 0, "StyleData", "MB", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[60419, 2141, 185, 5, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[60607, 2148, 58, 1, 70, 34, 0, "StyleData", "MBO", "Printout"],
Cell[60668, 2151, 95, 2, 70, 42, 0, "StyleData", "MBO", "EnhancedPrintout"],
Cell[60766, 2155, 102, 2, 70, 49, 0, "StyleData", "MBO", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[60905, 2162, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[61027, 2168, 33, 0, 70, 33, 0, "StyleData", "SR", "Printout"],
Cell[61063, 2170, 73, 1, 70, 41, 0, "StyleData", "SR", "EnhancedPrintout"],
Cell[61139, 2173, 80, 1, 70, 48, 0, "StyleData", "SR", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[61256, 2179, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[61379, 2185, 132, 4, 70, 33, 0, "StyleData", "SO", "Printout",
  StyleMenuListing->None],
Cell[61514, 2191, 96, 2, 70, 41, 0, "StyleData", "SO", "EnhancedPrintout"],
Cell[61613, 2195, 103, 2, 70, 48, 0, "StyleData", "SO", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[61753, 2202, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[61874, 2208, 59, 1, 70, 33, 0, "StyleData", "SB", "Printout",
  StyleMenuListing->None],
Cell[61936, 2211, 95, 2, 70, 41, 0, "StyleData", "SB", "EnhancedPrintout"],
Cell[62034, 2215, 102, 2, 70, 48, 0, "StyleData", "SB", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[62173, 2222, 123, 4, 38, 26, 0, "StyleData", "SBColor", "All",
  StyleMenuListing->None],
Cell[62299, 2228, 64, 1, 70, 38, 0, "StyleData", "SBColor", "Printout",
  StyleMenuListing->None],
Cell[62366, 2231, 100, 2, 70, 46, 0, "StyleData", "SBColor", \
"EnhancedPrintout"],
Cell[62469, 2235, 107, 2, 70, 53, 0, "StyleData", "SBColor", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[62613, 2242, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],
Cell[62736, 2248, 132, 4, 70, 34, 0, "StyleData", "SBO", "Printout",
  StyleMenuListing->None],
Cell[62871, 2254, 124, 3, 70, 42, 0, "StyleData", "SBO", "EnhancedPrintout"],
Cell[62998, 2259, 131, 3, 70, 49, 0, "StyleData", "SBO", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[63166, 2267, 139, 4, 38, 21, 0, "StyleData", "M4", "All",
  StyleMenuListing->None],
Cell[63308, 2273, 151, 4, 70, 33, 0, "StyleData", "M4", "Printout",
  StyleMenuListing->None],
Cell[63462, 2279, 159, 4, 70, 41, 0, "StyleData", "M4", "EnhancedPrintout",
  StyleMenuListing->None],
Cell[63624, 2285, 166, 4, 70, 48, 0, "StyleData", "M4", \
"EnhancedPrintoutNonGray",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[63827, 2294, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[63968, 2301, 149, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None],
Cell[64120, 2308, 162, 5, 70, 43, 0, "StyleData", "SO10", "EnhancedPrintout",
  StyleMenuListing->None],
Cell[64285, 2315, 169, 5, 70, 50, 0, "StyleData", "SO10", \
"EnhancedPrintoutNonGray",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[64491, 2325, 112, 4, 34, 21, 0, "StyleData", "S9", "All",
  StyleMenuListing->None],
Cell[64606, 2331, 71, 2, 70, 33, 0, "StyleData", "S9", "Printout"],
Cell[64680, 2335, 111, 3, 70, 41, 0, "StyleData", "S9", "EnhancedPrintout"],
Cell[64794, 2340, 118, 3, 70, 48, 0, "StyleData", "S9", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[64949, 2348, 114, 4, 35, 22, 0, "StyleData", "S10", "All",
  StyleMenuListing->None],
Cell[65066, 2354, 73, 2, 70, 34, 0, "StyleData", "S10", "Printout"],
Cell[65142, 2358, 113, 3, 70, 42, 0, "StyleData", "S10", "EnhancedPrintout"],
Cell[65258, 2363, 120, 3, 70, 49, 0, "StyleData", "S10", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[65415, 2371, 167, 5, 35, 22, 0, "StyleData", "SB9", "All",
  StyleMenuListing->None],
Cell[65585, 2378, 49, 1, 70, 34, 0, "StyleData", "SB9", "Printout"],
Cell[65637, 2381, 111, 3, 70, 42, 0, "StyleData", "SB9", "EnhancedPrintout"],
Cell[65751, 2386, 118, 3, 70, 49, 0, "StyleData", "SB9", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[65906, 2394, 114, 4, 35, 23, 0, "StyleData", "SB10", "All",
  StyleMenuListing->None],
Cell[66023, 2400, 50, 1, 70, 35, 0, "StyleData", "SB10", "Printout"],
Cell[66076, 2403, 112, 3, 70, 43, 0, "StyleData", "SB10", \
"EnhancedPrintout"],
Cell[66191, 2408, 119, 3, 70, 50, 0, "StyleData", "SB10", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[66347, 2416, 253, 8, 35, 23, 0, "StyleData", "MR10", "All",
  StyleMenuListing->None],
Cell[66603, 2426, 50, 1, 70, 35, 0, "StyleData", "MR10", "Printout"],
Cell[66656, 2429, 87, 2, 70, 43, 0, "StyleData", "MR10", "EnhancedPrintout"],
Cell[66746, 2433, 94, 2, 70, 50, 0, "StyleData", "MR10", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[66877, 2440, 231, 7, 35, 23, 0, "StyleData", "MO10", "All",
  StyleMenuListing->None],
Cell[67111, 2449, 50, 1, 70, 35, 0, "StyleData", "MO10", "Printout"],
Cell[67164, 2452, 87, 2, 70, 43, 0, "StyleData", "MO10", "EnhancedPrintout"],
Cell[67254, 2456, 94, 2, 70, 50, 0, "StyleData", "MO10", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[67385, 2463, 81, 2, 38, 21, 0, "StyleData", "C1", "All",
  StyleMenuListing->None],
Cell[67469, 2467, 76, 2, 70, 33, 0, "StyleData", "C1", "Printout"],
Cell[67548, 2471, 110, 3, 70, 41, 0, "StyleData", "C1", "EnhancedPrintout"],
Cell[67661, 2476, 117, 3, 70, 48, 0, "StyleData", "C1", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[67815, 2484, 108, 3, 37, 23, 0, "StyleData", "C1MR", "All",
  StyleMenuListing->None],
Cell[67926, 2489, 78, 2, 70, 35, 0, "StyleData", "C1MR", "Printout"],
Cell[68007, 2493, 115, 3, 70, 43, 0, "StyleData", "C1MR", \
"EnhancedPrintout"],
Cell[68125, 2498, 122, 3, 70, 50, 0, "StyleData", "C1MR", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[68284, 2506, 76, 2, 34, 28, 0, "StyleData", "SmallCaps", "All",
  StyleMenuListing->None],
Cell[68363, 2510, 40, 0, 70, 40, 0, "StyleData", "SmallCaps", "Printout"],
Cell[68406, 2512, 74, 1, 70, 48, 0, "StyleData", "SmallCaps", \
"EnhancedPrintout"],
Cell[68483, 2515, 81, 1, 70, 55, 0, "StyleData", "SmallCaps", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[68601, 2521, 74, 2, 38, 32, 0, "StyleData", "KeyboardChars", "All",
  StyleMenuListing->None],
Cell[68678, 2525, 60, 1, 70, 44, 0, "StyleData", "KeyboardChars", \
"Printout"],
Cell[68741, 2528, 94, 2, 70, 52, 0, "StyleData", "KeyboardChars", \
"EnhancedPrintout"],
Cell[68838, 2532, 101, 2, 70, 59, 0, "StyleData", "KeyboardChars", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[68976, 2539, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[69083, 2543, 90, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[69210, 2550, 34, 0, 30, "Subsection"],
Cell[69247, 2552, 58, 1, 38, 32, 0, "StyleData", "HeadingNumber", "All",
  StyleMenuListing->None]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[69354, 2559, 46, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[69425, 2563, 340, 9, 70, 22, 0, "StyleData", "Box", "All",
  StyleMenuListing->None],
Cell[69768, 2574, 54, 1, 70, 38, 0, "StyleData", "Box", "Presentation"],
Cell[69825, 2577, 150, 4, 70, 34, 0, "StyleData", "Box", "Printout"],
Cell[69978, 2583, 158, 4, 70, 42, 0, "StyleData", "Box", "EnhancedPrintout"],
Cell[70139, 2589, 158, 4, 70, 49, 0, "StyleData", "Box", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[70334, 2598, 368, 10, 70, 28, 0, "StyleData", "DoubleBox", "All",
  StyleMenuListing->None],
Cell[70705, 2610, 60, 1, 70, 44, 0, "StyleData", "DoubleBox", \
"Presentation"],
Cell[70768, 2613, 156, 4, 70, 40, 0, "StyleData", "DoubleBox", "Printout"],
Cell[70927, 2619, 164, 4, 70, 48, 0, "StyleData", "DoubleBox", \
"EnhancedPrintout"],
Cell[71094, 2625, 164, 4, 70, 55, 0, "StyleData", "DoubleBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[71295, 2634, 364, 10, 70, 29, 0, "StyleData", "1ColumnBox", "All",
  StyleMenuListing->None],
Cell[71662, 2646, 61, 1, 70, 45, 0, "StyleData", "1ColumnBox", \
"Presentation"],
Cell[71726, 2649, 157, 4, 70, 41, 0, "StyleData", "1ColumnBox", "Printout"],
Cell[71886, 2655, 165, 4, 70, 49, 0, "StyleData", "1ColumnBox", \
"EnhancedPrintout"],
Cell[72054, 2661, 165, 4, 70, 56, 0, "StyleData", "1ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[72256, 2670, 403, 11, 70, 29, 0, "StyleData", "2ColumnBox", "All",
  StyleMenuListing->None],
Cell[72662, 2683, 61, 1, 70, 45, 0, "StyleData", "2ColumnBox", \
"Presentation"],
Cell[72726, 2686, 156, 4, 70, 41, 0, "StyleData", "2ColumnBox", "Printout"],
Cell[72885, 2692, 164, 4, 70, 49, 0, "StyleData", "2ColumnBox", \
"EnhancedPrintout"],
Cell[73052, 2698, 164, 4, 70, 56, 0, "StyleData", "2ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[73253, 2707, 369, 10, 70, 33, 0, "StyleData", "2ColumnEvenBox", "All",
  StyleMenuListing->None],
Cell[73625, 2719, 65, 1, 70, 49, 0, "StyleData", "2ColumnEvenBox", \
"Presentation"],
Cell[73693, 2722, 161, 4, 70, 45, 0, "StyleData", "2ColumnEvenBox", \
"Printout"],
Cell[73857, 2728, 169, 4, 70, 53, 0, "StyleData", "2ColumnEvenBox", \
"EnhancedPrintout"],
Cell[74029, 2734, 169, 4, 70, 60, 0, "StyleData", "2ColumnEvenBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[74235, 2743, 428, 12, 70, 34, 0, "StyleData", "2ColumnSmallBox", "All",
  StyleMenuListing->None],
Cell[74666, 2757, 66, 1, 70, 50, 0, "StyleData", "2ColumnSmallBox", \
"Presentation"],
Cell[74735, 2760, 162, 4, 70, 46, 0, "StyleData", "2ColumnSmallBox", \
"Printout"],
Cell[74900, 2766, 170, 4, 70, 54, 0, "StyleData", "2ColumnSmallBox", \
"EnhancedPrintout"],
Cell[75073, 2772, 170, 4, 70, 61, 0, "StyleData", "2ColumnSmallBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[75280, 2781, 365, 10, 70, 29, 0, "StyleData", "3ColumnBox", "All",
  StyleMenuListing->None],
Cell[75648, 2793, 61, 1, 70, 45, 0, "StyleData", "3ColumnBox", \
"Presentation"],
Cell[75712, 2796, 157, 4, 70, 41, 0, "StyleData", "3ColumnBox", "Printout"],
Cell[75872, 2802, 165, 4, 70, 49, 0, "StyleData", "3ColumnBox", \
"EnhancedPrintout"],
Cell[76040, 2808, 165, 4, 70, 56, 0, "StyleData", "3ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[76242, 2817, 436, 12, 70, 34, 0, "StyleData", "3ColumnSmallBox", "All",
  StyleMenuListing->None],
Cell[76681, 2831, 66, 1, 70, 50, 0, "StyleData", "3ColumnSmallBox", \
"Presentation"],
Cell[76750, 2834, 162, 4, 70, 46, 0, "StyleData", "3ColumnSmallBox", \
"Printout"],
Cell[76915, 2840, 170, 4, 70, 54, 0, "StyleData", "3ColumnSmallBox", \
"EnhancedPrintout"],
Cell[77088, 2846, 188, 5, 70, 61, 0, "StyleData", "3ColumnSmallBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[77313, 2856, 415, 11, 70, 29, 0, "StyleData", "4ColumnBox", "All",
  StyleMenuListing->None],
Cell[77731, 2869, 61, 1, 70, 45, 0, "StyleData", "4ColumnBox", \
"Presentation"],
Cell[77795, 2872, 157, 4, 70, 41, 0, "StyleData", "4ColumnBox", "Printout"],
Cell[77955, 2878, 165, 4, 70, 49, 0, "StyleData", "4ColumnBox", \
"EnhancedPrintout"],
Cell[78123, 2884, 165, 4, 70, 56, 0, "StyleData", "4ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[78325, 2893, 366, 10, 70, 29, 0, "StyleData", "5ColumnBox", "All",
  StyleMenuListing->None],
Cell[78694, 2905, 61, 1, 70, 45, 0, "StyleData", "5ColumnBox", \
"Presentation"],
Cell[78758, 2908, 156, 4, 70, 41, 0, "StyleData", "5ColumnBox", "Printout"],
Cell[78917, 2914, 164, 4, 70, 49, 0, "StyleData", "5ColumnBox", \
"EnhancedPrintout"],
Cell[79084, 2920, 164, 4, 70, 56, 0, "StyleData", "5ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[79285, 2929, 397, 10, 70, 29, 0, "StyleData", "6ColumnBox", "All",
  StyleMenuListing->None],
Cell[79685, 2941, 61, 1, 70, 45, 0, "StyleData", "6ColumnBox", \
"Presentation"],
Cell[79749, 2944, 157, 4, 70, 41, 0, "StyleData", "6ColumnBox", "Printout"],
Cell[79909, 2950, 165, 4, 70, 49, 0, "StyleData", "6ColumnBox", \
"EnhancedPrintout"],
Cell[80077, 2956, 165, 4, 70, 56, 0, "StyleData", "6ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[80279, 2965, 400, 12, 70, 28, 0, "StyleData", "FramedBox", "All"],
Cell[80682, 2979, 60, 1, 70, 44, 0, "StyleData", "FramedBox", \
"Presentation"],
Cell[80745, 2982, 149, 4, 70, 40, 0, "StyleData", "FramedBox", "Printout"],
Cell[80897, 2988, 183, 5, 70, 48, 0, "StyleData", "FramedBox", \
"EnhancedPrintout"],
Cell[81083, 2995, 190, 5, 70, 55, 0, "StyleData", "FramedBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[81310, 3005, 453, 14, 70, 32, 0, "StyleData", "DefinitionBox", "All"],
Cell[81766, 3021, 64, 1, 70, 48, 0, "StyleData", "DefinitionBox", \
"Presentation"],
Cell[81833, 3024, 153, 4, 70, 44, 0, "StyleData", "DefinitionBox", \
"Printout"],
Cell[81989, 3030, 187, 5, 70, 52, 0, "StyleData", "DefinitionBox", \
"EnhancedPrintout"],
Cell[82179, 3037, 194, 5, 70, 59, 0, "StyleData", "DefinitionBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[82410, 3047, 464, 14, 70, 36, 0, "StyleData", "DefinitionBox3Col", \
"All"],
Cell[82877, 3063, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox3Col", \
"Presentation"],
Cell[82948, 3066, 157, 4, 70, 48, 0, "StyleData", "DefinitionBox3Col", \
"Printout"],
Cell[83108, 3072, 191, 5, 70, 56, 0, "StyleData", "DefinitionBox3Col", \
"EnhancedPrintout"],
Cell[83302, 3079, 198, 5, 70, 63, 0, "StyleData", "DefinitionBox3Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[83537, 3089, 471, 14, 70, 36, 0, "StyleData", "DefinitionBox4Col", \
"All"],
Cell[84011, 3105, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox4Col", \
"Presentation"],
Cell[84082, 3108, 157, 4, 70, 48, 0, "StyleData", "DefinitionBox4Col", \
"Printout"],
Cell[84242, 3114, 191, 5, 70, 56, 0, "StyleData", "DefinitionBox4Col", \
"EnhancedPrintout"],
Cell[84436, 3121, 198, 5, 70, 63, 0, "StyleData", "DefinitionBox4Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[84671, 3131, 467, 14, 70, 34, 0, "StyleData", "PrecedenceTable", "All"],
Cell[85141, 3147, 66, 1, 70, 50, 0, "StyleData", "PrecedenceTable", \
"Presentation"],
Cell[85210, 3150, 155, 4, 70, 46, 0, "StyleData", "PrecedenceTable", \
"Printout"],
Cell[85368, 3156, 189, 5, 70, 54, 0, "StyleData", "PrecedenceTable", \
"EnhancedPrintout"],
Cell[85560, 3163, 196, 5, 70, 61, 0, "StyleData", "PrecedenceTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[85793, 3173, 450, 14, 70, 36, 0, "StyleData", "DefinitionBox5Col", \
"All"],
Cell[86246, 3189, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox5Col", \
"Presentation"],
Cell[86317, 3192, 157, 4, 70, 48, 0, "StyleData", "DefinitionBox5Col", \
"Printout"],
Cell[86477, 3198, 191, 5, 70, 56, 0, "StyleData", "DefinitionBox5Col", \
"EnhancedPrintout"],
Cell[86671, 3205, 198, 5, 70, 63, 0, "StyleData", "DefinitionBox5Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[86906, 3215, 483, 14, 70, 36, 0, "StyleData", "DefinitionBox6Col", \
"All"],
Cell[87392, 3231, 68, 1, 70, 52, 0, "StyleData", "DefinitionBox6Col", \
"Presentation"],
Cell[87463, 3234, 157, 4, 70, 48, 0, "StyleData", "DefinitionBox6Col", \
"Printout"],
Cell[87623, 3240, 191, 5, 70, 56, 0, "StyleData", "DefinitionBox6Col", \
"EnhancedPrintout"],
Cell[87817, 3247, 198, 5, 70, 63, 0, "StyleData", "DefinitionBox6Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[88052, 3257, 492, 15, 70, 25, 0, "StyleData", "TopBox", "All",
  StyleMenuListing->None],
Cell[88547, 3274, 57, 1, 70, 41, 0, "StyleData", "TopBox", "Presentation"],
Cell[88607, 3277, 130, 3, 70, 37, 0, "StyleData", "TopBox", "Printout"],
Cell[88740, 3282, 164, 4, 70, 45, 0, "StyleData", "TopBox", \
"EnhancedPrintout"],
Cell[88907, 3288, 171, 4, 70, 52, 0, "StyleData", "TopBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[89115, 3297, 519, 16, 70, 28, 0, "StyleData", "MiddleBox", "All",
  StyleMenuListing->None],
Cell[89637, 3315, 60, 1, 70, 44, 0, "StyleData", "MiddleBox", \
"Presentation"],
Cell[89700, 3318, 133, 3, 70, 40, 0, "StyleData", "MiddleBox", "Printout"],
Cell[89836, 3323, 167, 4, 70, 48, 0, "StyleData", "MiddleBox", \
"EnhancedPrintout"],
Cell[90006, 3329, 174, 4, 70, 55, 0, "StyleData", "MiddleBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[90217, 3338, 521, 16, 70, 28, 0, "StyleData", "BottomBox", "All",
  StyleMenuListing->None],
Cell[90741, 3356, 60, 1, 70, 44, 0, "StyleData", "BottomBox", \
"Presentation"],
Cell[90804, 3359, 189, 5, 70, 40, 0, "StyleData", "BottomBox", "Printout"],
Cell[90996, 3366, 223, 6, 70, 48, 0, "StyleData", "BottomBox", \
"EnhancedPrintout"],
Cell[91222, 3374, 230, 6, 70, 55, 0, "StyleData", "BottomBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[91489, 3385, 496, 15, 70, 29, 0, "StyleData", "TopSpanBox", "All",
  StyleMenuListing->None],
Cell[91988, 3402, 61, 1, 70, 45, 0, "StyleData", "TopSpanBox", \
"Presentation"],
Cell[92052, 3405, 151, 4, 70, 41, 0, "StyleData", "TopSpanBox", "Printout"],
Cell[92206, 3411, 185, 5, 70, 49, 0, "StyleData", "TopSpanBox", \
"EnhancedPrintout"],
Cell[92394, 3418, 192, 5, 70, 56, 0, "StyleData", "TopSpanBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[92623, 3428, 521, 16, 70, 32, 0, "StyleData", "MiddleSpanBox", "All",
  StyleMenuListing->None],
Cell[93147, 3446, 64, 1, 70, 48, 0, "StyleData", "MiddleSpanBox", \
"Presentation"],
Cell[93214, 3449, 193, 5, 70, 44, 0, "StyleData", "MiddleSpanBox", \
"Printout"],
Cell[93410, 3456, 227, 6, 70, 52, 0, "StyleData", "MiddleSpanBox", \
"EnhancedPrintout"],
Cell[93640, 3464, 234, 6, 70, 59, 0, "StyleData", "MiddleSpanBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[93911, 3475, 168, 4, 70, 26, 0, "StyleData", "Picture", "All",
  StyleMenuListing->None],
Cell[94082, 3481, 58, 1, 70, 42, 0, "StyleData", "Picture", "Presentation"],
Cell[94143, 3484, 102, 2, 70, 38, 0, "StyleData", "Picture", "Printout"],
Cell[94248, 3488, 110, 2, 70, 46, 0, "StyleData", "Picture", \
"EnhancedPrintout"],
Cell[94361, 3492, 117, 2, 70, 53, 0, "StyleData", "Picture", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[94515, 3499, 232, 5, 70, 43, 0, "StyleData", "OpenCloseItemizedPicture", \
"All",
  StyleMenuListing->None],
Cell[94750, 3506, 75, 1, 70, 59, 0, "StyleData", "OpenCloseItemizedPicture", \
"Presentation"],
Cell[94828, 3509, 178, 4, 70, 55, 0, "StyleData", "OpenCloseItemizedPicture", \
"Printout"],
Cell[95009, 3515, 186, 4, 70, 63, 0, "StyleData", "OpenCloseItemizedPicture", \
"EnhancedPrintout"],
Cell[95198, 3521, 193, 4, 70, 70, 0, "StyleData", "OpenCloseItemizedPicture", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[95428, 3530, 168, 4, 70, 34, 0, "StyleData", "ItemizedPicture", "All",
  StyleMenuListing->None],
Cell[95599, 3536, 66, 1, 70, 50, 0, "StyleData", "ItemizedPicture", \
"Presentation"],
Cell[95668, 3539, 103, 2, 70, 46, 0, "StyleData", "ItemizedPicture", \
"Printout"],
Cell[95774, 3543, 112, 2, 70, 54, 0, "StyleData", "ItemizedPicture", \
"EnhancedPrintout"],
Cell[95889, 3547, 118, 2, 70, 61, 0, "StyleData", "ItemizedPicture", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[96044, 3554, 164, 4, 70, 30, 0, "StyleData", "ListGraphic", "All",
  StyleMenuListing->None],
Cell[96211, 3560, 62, 1, 70, 46, 0, "StyleData", "ListGraphic", \
"Presentation"],
Cell[96276, 3563, 99, 2, 70, 42, 0, "StyleData", "ListGraphic", "Printout"],
Cell[96378, 3567, 108, 2, 70, 50, 0, "StyleData", "ListGraphic", \
"EnhancedPrintout"],
Cell[96489, 3571, 114, 2, 70, 57, 0, "StyleData", "ListGraphic", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[96640, 3578, 364, 9, 70, 30, 0, "StyleData", "ListNoteBox", "All",
  StyleMenuListing->None],
Cell[97007, 3589, 62, 1, 70, 46, 0, "StyleData", "ListNoteBox", \
"Presentation"],
Cell[97072, 3592, 127, 3, 70, 42, 0, "StyleData", "ListNoteBox", "Printout"],
Cell[97202, 3597, 167, 4, 70, 50, 0, "StyleData", "ListNoteBox", \
"EnhancedPrintout"],
Cell[97372, 3603, 167, 4, 70, 57, 0, "StyleData", "ListNoteBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[97576, 3612, 165, 4, 70, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[97744, 3618, 63, 1, 70, 47, 0, "StyleData", "PictureGroup", \
"Presentation"],
Cell[97810, 3621, 166, 4, 70, 43, 0, "StyleData", "PictureGroup", \
"Printout"],
Cell[97979, 3627, 174, 4, 70, 51, 0, "StyleData", "PictureGroup", \
"EnhancedPrintout"],
Cell[98156, 3633, 181, 4, 70, 58, 0, "StyleData", "PictureGroup", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[98374, 3642, 117, 3, 70, 24, 0, "StyleData", "Sound", "All",
  StyleMenuListing->None],
Cell[98494, 3647, 56, 1, 70, 40, 0, "StyleData", "Sound", "Presentation"],
Cell[98553, 3650, 85, 2, 70, 36, 0, "StyleData", "Sound", "Printout"],
Cell[98641, 3654, 93, 2, 70, 44, 0, "StyleData", "Sound", \
"EnhancedPrintout"],
Cell[98737, 3658, 100, 2, 70, 51, 0, "StyleData", "Sound", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[98874, 3665, 153, 5, 70, 26, 0, "StyleData", "Caption", "All",
  StyleMenuListing->None],
Cell[99030, 3672, 58, 1, 70, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[99091, 3675, 86, 2, 70, 38, 0, "StyleData", "Caption", "Printout"],
Cell[99180, 3679, 126, 3, 70, 46, 0, "StyleData", "Caption", \
"EnhancedPrintout"],
Cell[99309, 3684, 134, 3, 70, 53, 0, "StyleData", "Caption", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[99492, 3693, 25, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[99542, 3697, 217, 6, 70, 31, 0, "StyleData", "2ColumnTable", "All",
  StyleMenuListing->None],
Cell[99762, 3705, 63, 1, 70, 47, 0, "StyleData", "2ColumnTable", \
"Presentation"],
Cell[99828, 3708, 91, 2, 70, 43, 0, "StyleData", "2ColumnTable", "Printout"],
Cell[99922, 3712, 99, 2, 70, 51, 0, "StyleData", "2ColumnTable", \
"EnhancedPrintout"],
Cell[100024, 3716, 106, 2, 70, 58, 0, "StyleData", "2ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[100167, 3723, 213, 6, 70, 35, 0, "StyleData", "2ColumnEvenTable", "All",
  StyleMenuListing->None],
Cell[100383, 3731, 67, 1, 70, 51, 0, "StyleData", "2ColumnEvenTable", \
"Presentation"],
Cell[100453, 3734, 95, 2, 70, 47, 0, "StyleData", "2ColumnEvenTable", \
"Printout"],
Cell[100551, 3738, 103, 2, 70, 55, 0, "StyleData", "2ColumnEvenTable", \
"EnhancedPrintout"],
Cell[100657, 3742, 110, 2, 70, 62, 0, "StyleData", "2ColumnEvenTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[100804, 3749, 223, 6, 70, 31, 0, "StyleData", "3ColumnTable", "All",
  StyleMenuListing->None],
Cell[101030, 3757, 63, 1, 70, 47, 0, "StyleData", "3ColumnTable", \
"Presentation"],
Cell[101096, 3760, 91, 2, 70, 43, 0, "StyleData", "3ColumnTable", \
"Printout"],
Cell[101190, 3764, 99, 2, 70, 51, 0, "StyleData", "3ColumnTable", \
"EnhancedPrintout"],
Cell[101292, 3768, 106, 2, 70, 58, 0, "StyleData", "3ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[101447, 3776, 43, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[101515, 3780, 410, 11, 70, 32, 0, "StyleData", "InlineFormula", "All",
  StyleMenuListing->None],
Cell[101928, 3793, 93, 2, 70, 44, 0, "StyleData", "InlineFormula", \
"Printout"],
Cell[102024, 3797, 101, 2, 70, 52, 0, "StyleData", "InlineFormula", \
"EnhancedPrintout"],
Cell[102128, 3801, 108, 2, 70, 59, 0, "StyleData", "InlineFormula", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[102273, 3808, 291, 7, 70, 31, 0, "StyleData", "InlineOutput", "All",
  StyleMenuListing->None],
Cell[102567, 3817, 93, 2, 70, 43, 0, "StyleData", "InlineOutput", \
"Printout"],
Cell[102663, 3821, 101, 2, 70, 51, 0, "StyleData", "InlineOutput", \
"EnhancedPrintout"],
Cell[102767, 3825, 108, 2, 70, 58, 0, "StyleData", "InlineOutput", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[102912, 3832, 463, 11, 70, 33, 0, "StyleData", "DisplayFormula", "All",
  StyleMenuListing->None],
Cell[103378, 3845, 65, 1, 70, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[103446, 3848, 45, 0, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"],
Cell[103494, 3850, 79, 1, 70, 53, 0, "StyleData", "DisplayFormula", \
"EnhancedPrintout"],
Cell[103576, 3853, 86, 1, 70, 60, 0, "StyleData", "DisplayFormula", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[103699, 3859, 536, 15, 70, 30, 0, "StyleData", "DisplayMath", "All",
  CounterIncrements->"Input"],
Cell[104238, 3876, 62, 1, 70, 46, 0, "StyleData", "DisplayMath", \
"Presentation"],
Cell[104303, 3879, 91, 2, 70, 42, 0, "StyleData", "DisplayMath", "Printout"],
Cell[104397, 3883, 127, 3, 70, 50, 0, "StyleData", "DisplayMath", \
"EnhancedPrintout"],
Cell[104527, 3888, 134, 3, 70, 57, 0, "StyleData", "DisplayMath", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[104698, 3896, 398, 9, 70, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[105099, 3907, 67, 1, 70, 51, 0, "StyleData", "NumberedEquation", \
"Presentation"],
Cell[105169, 3910, 99, 2, 70, 47, 0, "StyleData", "NumberedEquation", \
"Printout"],
Cell[105271, 3914, 133, 3, 70, 55, 0, "StyleData", "NumberedEquation", \
"EnhancedPrintout"],
Cell[105407, 3919, 140, 3, 70, 62, 0, "StyleData", "NumberedEquation", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[105584, 3927, 148, 3, 70, 33, 0, "StyleData", "EquationNumber", "All"],
Cell[105735, 3932, 65, 1, 70, 49, 0, "StyleData", "EquationNumber", \
"Presentation"],
Cell[105803, 3935, 70, 1, 70, 45, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[105876, 3938, 104, 2, 70, 53, 0, "StyleData", "EquationNumber", \
"EnhancedPrintout"],
Cell[105983, 3942, 111, 2, 70, 60, 0, "StyleData", "EquationNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[106131, 3949, 225, 6, 70, 26, 0, "StyleData", "Program", "All"],
Cell[106359, 3957, 58, 1, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[106420, 3960, 98, 2, 70, 38, 0, "StyleData", "Program", "Printout"],
Cell[106521, 3964, 134, 3, 70, 46, 0, "StyleData", "Program", \
"EnhancedPrintout"],
Cell[106658, 3969, 141, 3, 70, 53, 0, "StyleData", "Program", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[106848, 3978, 45, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[106918, 3982, 46, 3, 70, "Subsection"],

Cell[CellGroupData[{
Cell[106989, 3989, 315, 9, 70, 34, 0, "StyleData", "InspectorLevel1", "All",
  StyleMenuListing->None],
Cell[107307, 4000, 66, 1, 70, 50, 0, "StyleData", "InspectorLevel1", \
"Presentation"],
Cell[107376, 4003, 100, 1, 70, 47, 0, "StyleData", "InspectorLevel1", \
"SlideShow"],
Cell[107479, 4006, 115, 2, 70, 46, 0, "StyleData", "InspectorLevel1", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[107631, 4013, 245, 7, 70, 34, 0, "StyleData", "InspectorLevel2", "All",
  StyleMenuListing->None],
Cell[107879, 4022, 66, 1, 70, 50, 0, "StyleData", "InspectorLevel2", \
"Presentation"],
Cell[107948, 4025, 303, 8, 70, 47, 0, "StyleData", "InspectorLevel2", \
"SlideShow"],
Cell[108254, 4035, 115, 2, 70, 46, 0, "StyleData", "InspectorLevel2", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[108406, 4042, 435, 11, 70, 29, 0, "StyleData", "ObjectName", "All",
  StyleMenuListing->None],
Cell[108844, 4055, 61, 1, 70, 45, 0, "StyleData", "ObjectName", \
"Presentation"],
Cell[108908, 4058, 265, 7, 70, 42, 0, "StyleData", "ObjectName", "SlideShow",
  StyleMenuListing->None],
Cell[109176, 4067, 199, 4, 70, 41, 0, "StyleData", "ObjectName", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[109412, 4076, 348, 9, 70, 38, 0, "StyleData", "SubObjectNameClosed", \
"All",
  StyleMenuListing->None],
Cell[109763, 4087, 70, 1, 70, 54, 0, "StyleData", "SubObjectNameClosed", \
"Presentation"],
Cell[109836, 4090, 228, 6, 70, 51, 0, "StyleData", "SubObjectNameClosed", \
"SlideShow",
  StyleMenuListing->None],
Cell[110067, 4098, 153, 3, 70, 50, 0, "StyleData", "SubObjectNameClosed", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[110257, 4106, 241, 7, 70, 32, 0, "StyleData", "SubObjectName", "All",
  StyleMenuListing->None],
Cell[110501, 4115, 64, 1, 70, 48, 0, "StyleData", "SubObjectName", \
"Presentation"],
Cell[110568, 4118, 206, 5, 70, 45, 0, "StyleData", "SubObjectName", \
"SlideShow"],
Cell[110777, 4125, 172, 4, 70, 44, 0, "StyleData", "SubObjectName", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[110986, 4134, 243, 7, 70, 34, 0, "StyleData", "GroupObjectName", "All",
  StyleMenuListing->None],
Cell[111232, 4143, 66, 1, 70, 50, 0, "StyleData", "GroupObjectName", \
"Presentation"],
Cell[111301, 4146, 334, 9, 70, 47, 0, "StyleData", "GroupObjectName", \
"SlideShow",
  CounterIncrements->"Outline2"],
Cell[111638, 4157, 115, 2, 70, 46, 0, "StyleData", "GroupObjectName", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[111790, 4164, 350, 9, 70, 40, 0, "StyleData", "GroupObjectNameClosed", \
"All",
  StyleMenuListing->None],
Cell[112143, 4175, 72, 1, 70, 56, 0, "StyleData", "GroupObjectNameClosed", \
"Presentation"],
Cell[112218, 4178, 340, 9, 70, 53, 0, "StyleData", "GroupObjectNameClosed", \
"SlideShow",
  CounterIncrements->"Outline2"],
Cell[112561, 4189, 121, 2, 70, 52, 0, "StyleData", "GroupObjectNameClosed", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[112719, 4196, 267, 7, 70, 44, 0, "StyleData", \
"ObjectNameWarningMessages", "All",
  StyleMenuListing->None],
Cell[112989, 4205, 76, 1, 70, 60, 0, "StyleData", \
"ObjectNameWarningMessages", "Presentation"],
Cell[113068, 4208, 254, 6, 70, 57, 0, "StyleData", \
"ObjectNameWarningMessages", "SlideShow"],
Cell[113325, 4216, 159, 3, 70, 56, 0, "StyleData", \
"ObjectNameWarningMessages", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[113521, 4224, 420, 11, 70, 26, 0, "StyleData", "Command", "All",
  CounterIncrements->"Section",
  StyleMenuListing->None],
Cell[113944, 4237, 58, 1, 70, 42, 0, "StyleData", "Command", "Presentation"],
Cell[114005, 4240, 221, 5, 70, 38, 0, "StyleData", "Command", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[114263, 4250, 328, 7, 70, 32, 0, "StyleData", "CharacterName", "All",
  StyleMenuListing->None],
Cell[114594, 4259, 64, 1, 70, 48, 0, "StyleData", "CharacterName", \
"Presentation"],
Cell[114661, 4262, 268, 7, 70, 45, 0, "StyleData", "CharacterName", \
"SlideShow",
  StyleMenuListing->None],
Cell[114932, 4271, 146, 3, 70, 44, 0, "StyleData", "CharacterName", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[115115, 4279, 394, 10, 70, 24, 0, "StyleData", "Usage", "All",
  StyleMenuListing->None],
Cell[115512, 4291, 56, 1, 70, 40, 0, "StyleData", "Usage", "Presentation"],
Cell[115571, 4294, 260, 7, 70, 37, 0, "StyleData", "Usage", "SlideShow",
  StyleMenuListing->None],
Cell[115834, 4303, 242, 6, 70, 36, 0, "StyleData", "Usage", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[116113, 4314, 563, 16, 70, 31, 0, "StyleData", "ErrorMessage", "All",
  StyleMenuListing->None],
Cell[116679, 4332, 63, 1, 70, 47, 0, "StyleData", "ErrorMessage", \
"Presentation"],
Cell[116745, 4335, 190, 4, 70, 44, 0, "StyleData", "ErrorMessage", \
"SlideShow",
  StyleMenuListing->None],
Cell[116938, 4341, 138, 3, 70, 43, 0, "StyleData", "ErrorMessage", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[117113, 4349, 246, 7, 70, 24, 0, "StyleData", "Notes", "All",
  StyleMenuListing->None],
Cell[117362, 4358, 56, 1, 70, 40, 0, "StyleData", "Notes", "Presentation"],
Cell[117421, 4361, 258, 7, 70, 37, 0, "StyleData", "Notes", "SlideShow",
  StyleMenuListing->None],
Cell[117682, 4370, 159, 4, 70, 36, 0, "StyleData", "Notes", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[117878, 4379, 191, 6, 70, 28, 0, "StyleData", "NotesList", "All",
  StyleMenuListing->None],
Cell[118072, 4387, 60, 1, 70, 44, 0, "StyleData", "NotesList", \
"Presentation"],
Cell[118135, 4390, 257, 7, 70, 41, 0, "StyleData", "NotesList", "SlideShow",
  StyleMenuListing->None],
Cell[118395, 4399, 163, 4, 70, 40, 0, "StyleData", "NotesList", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[118595, 4408, 333, 9, 70, 35, 0, "StyleData", "ReferenceSection", "All",
  StyleMenuListing->None],
Cell[118931, 4419, 67, 1, 70, 51, 0, "StyleData", "ReferenceSection", \
"Presentation"],
Cell[119001, 4422, 201, 5, 70, 47, 0, "StyleData", "ReferenceSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[119239, 4432, 1337, 31, 70, 28, 0, "StyleData", "Reference", "All",
  CounterIncrements->"Reference"],
Cell[120579, 4465, 60, 1, 70, 44, 0, "StyleData", "Reference", \
"Presentation"],
Cell[120642, 4468, 114, 3, 70, 41, 0, "StyleData", "Reference", "SlideShow"],
Cell[120759, 4473, 134, 4, 70, 40, 0, "StyleData", "Reference", "Printout"],
Cell[120896, 4479, 168, 5, 70, 48, 0, "StyleData", "Reference", \
"EnhancedPrintout"],
Cell[121067, 4486, 175, 5, 70, 55, 0, "StyleData", "Reference", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[121279, 4496, 331, 9, 70, 33, 0, "StyleData", "ExampleSection", "All",
  StyleMenuListing->None],
Cell[121613, 4507, 65, 1, 70, 49, 0, "StyleData", "ExampleSection", \
"Presentation"],
Cell[121681, 4510, 199, 5, 70, 45, 0, "StyleData", "ExampleSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[121917, 4520, 207, 5, 70, 30, 0, "StyleData", "ExampleText", "All",
  StyleMenuListing->None],
Cell[122127, 4527, 62, 1, 70, 46, 0, "StyleData", "ExampleText", \
"Presentation"],
Cell[122192, 4530, 217, 6, 70, 42, 0, "StyleData", "ExampleText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[122446, 4541, 286, 8, 70, 36, 0, "StyleData", "ExampleSubsection", "All",
  
  StyleMenuListing->None],
Cell[122735, 4551, 68, 1, 70, 52, 0, "StyleData", "ExampleSubsection", \
"Presentation"],
Cell[122806, 4554, 176, 4, 70, 48, 0, "StyleData", "ExampleSubsection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[123019, 4563, 332, 9, 70, 34, 0, "StyleData", "MessagesSection", "All",
  StyleMenuListing->None],
Cell[123354, 4574, 66, 1, 70, 50, 0, "StyleData", "MessagesSection", \
"Presentation"],
Cell[123423, 4577, 200, 5, 70, 46, 0, "StyleData", "MessagesSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[123660, 4587, 354, 9, 70, 34, 0, "StyleData", "TemplateSection", "All",
  StyleMenuListing->None],
Cell[124017, 4598, 66, 1, 70, 50, 0, "StyleData", "TemplateSection", \
"Presentation"],
Cell[124086, 4601, 200, 5, 70, 46, 0, "StyleData", "TemplateSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[124323, 4611, 320, 9, 70, 27, 0, "StyleData", "LineHead", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[124646, 4622, 59, 1, 70, 43, 0, "StyleData", "LineHead", \
"Presentation"],
Cell[124708, 4625, 167, 4, 70, 39, 0, "StyleData", "LineHead", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[124912, 4634, 566, 16, 70, 29, 0, "StyleData", "FlushInput", "All",
  StyleMenuListing->None],
Cell[125481, 4652, 61, 1, 70, 45, 0, "StyleData", "FlushInput", \
"Presentation"],
Cell[125545, 4655, 143, 3, 70, 41, 0, "StyleData", "FlushInput", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[125725, 4663, 540, 14, 70, 30, 0, "StyleData", "FlushOutput", "All",
  StyleMenuListing->None],
Cell[126268, 4679, 62, 1, 70, 46, 0, "StyleData", "FlushOutput", \
"Presentation"],
Cell[126333, 4682, 168, 3, 70, 42, 0, "StyleData", "FlushOutput", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[126538, 4690, 288, 8, 70, 29, 0, "StyleData", "DialogItem", "All",
  StyleMenuListing->None],
Cell[126829, 4700, 61, 1, 70, 45, 0, "StyleData", "DialogItem", \
"Presentation"],
Cell[126893, 4703, 169, 4, 70, 41, 0, "StyleData", "DialogItem", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[127099, 4712, 238, 5, 70, 31, 0, "StyleData", "GroupDivider", "All",
  StyleMenuListing->None],
Cell[127340, 4719, 63, 1, 70, 47, 0, "StyleData", "GroupDivider", \
"Presentation"]
}, Closed]],

Cell[CellGroupData[{
Cell[127440, 4725, 277, 8, 70, 28, 0, "StyleData", "Highlight", "All",
  StyleMenuListing->None],
Cell[127720, 4735, 60, 1, 70, 44, 0, "StyleData", "Highlight", \
"Presentation"],
Cell[127783, 4738, 186, 5, 70, 40, 0, "StyleData", "Highlight", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[128006, 4748, 242, 7, 70, 28, 0, "StyleData", "UserNotes", "All",
  StyleMenuListing->None],
Cell[128251, 4757, 60, 1, 70, 44, 0, "StyleData", "UserNotes", \
"Presentation"],
Cell[128314, 4760, 185, 5, 70, 40, 0, "StyleData", "UserNotes", "Printout"],
Cell[128502, 4767, 172, 5, 70, 48, 0, "StyleData", "UserNotes", \
"EnhancedPrintout"],
Cell[128677, 4774, 179, 5, 70, 55, 0, "StyleData", "UserNotes", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[128893, 4784, 283, 8, 70, 27, 0, "StyleData", "MoreInfo", "All",
  StyleMenuListing->None],
Cell[129179, 4794, 59, 1, 70, 43, 0, "StyleData", "MoreInfo", \
"Presentation"],
Cell[129241, 4797, 184, 5, 70, 39, 0, "StyleData", "MoreInfo", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[129462, 4807, 283, 8, 70, 27, 0, "StyleData", "UserTips", "All",
  StyleMenuListing->None],
Cell[129748, 4817, 59, 1, 70, 43, 0, "StyleData", "UserTips", \
"Presentation"],
Cell[129810, 4820, 258, 7, 70, 39, 0, "StyleData", "UserTips", "Printout"],
Cell[130071, 4829, 291, 8, 70, 47, 0, "StyleData", "UserTips", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[130399, 4842, 259, 7, 70, 26, 0, "StyleData", "Theorem", "All"],
Cell[130661, 4851, 58, 1, 70, 42, 0, "StyleData", "Theorem", "Presentation"],
Cell[130722, 4854, 224, 6, 70, 38, 0, "StyleData", "Theorem", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[130983, 4865, 228, 7, 70, 29, 0, "StyleData", "Commentary", "All"],
Cell[131214, 4874, 61, 1, 70, 45, 0, "StyleData", "Commentary", \
"Presentation"],
Cell[131278, 4877, 125, 3, 70, 41, 0, "StyleData", "Commentary", "Printout"],
Cell[131406, 4882, 159, 4, 70, 49, 0, "StyleData", "Commentary", \
"EnhancedPrintout"],
Cell[131568, 4888, 166, 4, 70, 56, 0, "StyleData", "Commentary", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[131771, 4897, 235, 6, 70, 29, 0, "StyleData", "Level1Icon", "All",
  StyleMenuListing->None],
Cell[132009, 4905, 61, 1, 70, 45, 0, "StyleData", "Level1Icon", \
"Presentation"],
Cell[132073, 4908, 143, 3, 70, 41, 0, "StyleData", "Level1Icon", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[132253, 4916, 235, 6, 70, 29, 0, "StyleData", "Level2Icon", "All",
  StyleMenuListing->None],
Cell[132491, 4924, 61, 1, 70, 45, 0, "StyleData", "Level2Icon", \
"Presentation"],
Cell[132555, 4927, 143, 3, 70, 41, 0, "StyleData", "Level2Icon", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[132735, 4935, 182, 6, 70, 32, 0, "StyleData", "CopyrightHead", "All",
  StyleMenuListing->None],
Cell[132920, 4943, 64, 1, 70, 48, 0, "StyleData", "CopyrightHead", \
"Presentation"],
Cell[132987, 4946, 117, 3, 70, 44, 0, "StyleData", "CopyrightHead", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[133141, 4954, 156, 5, 70, 28, 0, "StyleData", "Copyright", "All",
  StyleMenuListing->None],
Cell[133300, 4961, 60, 1, 70, 44, 0, "StyleData", "Copyright", \
"Presentation"],
Cell[133363, 4964, 112, 3, 70, 40, 0, "StyleData", "Copyright", "Printout"],
Cell[133478, 4969, 152, 4, 70, 48, 0, "StyleData", "Copyright", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[133667, 4978, 1460, 34, 70, 37, 0, "StyleData", "RegisterSubsection", \
"All"],
Cell[135130, 5014, 69, 1, 70, 53, 0, "StyleData", "RegisterSubsection", \
"Presentation"],
Cell[135202, 5017, 122, 3, 70, 50, 0, "StyleData", "RegisterSubsection", \
"SlideShow"],
Cell[135327, 5022, 99, 2, 70, 49, 0, "StyleData", "RegisterSubsection", \
"Printout"],
Cell[135429, 5026, 139, 3, 70, 57, 0, "StyleData", "RegisterSubsection", \
"EnhancedPrintout"],
Cell[135571, 5031, 146, 3, 70, 64, 0, "StyleData", "RegisterSubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[135754, 5039, 1473, 33, 70, 40, 0, "StyleData", "RegisterSubsubsection", \
"All"],
Cell[137230, 5074, 72, 1, 70, 56, 0, "StyleData", "RegisterSubsubsection", \
"Presentation"],
Cell[137305, 5077, 101, 2, 70, 52, 0, "StyleData", "RegisterSubsubsection", \
"Printout"],
Cell[137409, 5081, 190, 5, 70, 60, 0, "StyleData", "RegisterSubsubsection", \
"EnhancedPrintout"],
Cell[137602, 5088, 197, 5, 70, 67, 0, "StyleData", "RegisterSubsubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[137836, 5098, 132, 4, 70, 31, 0, "StyleData", "RegisterText", "All",
  StyleMenuListing->None],
Cell[137971, 5104, 63, 1, 70, 47, 0, "StyleData", "RegisterText", \
"Presentation"],
Cell[138037, 5107, 115, 3, 70, 43, 0, "StyleData", "RegisterText", \
"Printout"],
Cell[138155, 5112, 149, 4, 70, 51, 0, "StyleData", "RegisterText", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[138341, 5121, 180, 6, 70, 30, 0, "StyleData", "CaptionHead", "All",
  StyleMenuListing->None],
Cell[138524, 5129, 62, 1, 70, 46, 0, "StyleData", "CaptionHead", \
"Presentation"],
Cell[138589, 5132, 114, 3, 70, 42, 0, "StyleData", "CaptionHead", \
"Printout"],
Cell[138706, 5137, 148, 4, 70, 50, 0, "StyleData", "CaptionHead", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[138891, 5146, 115, 3, 70, 30, 0, "StyleData", "CaptionText", "All",
  StyleMenuListing->None],
Cell[139009, 5151, 62, 1, 70, 46, 0, "StyleData", "CaptionText", \
"Presentation"],
Cell[139074, 5154, 114, 3, 70, 42, 0, "StyleData", "CaptionText", \
"Printout"],
Cell[139191, 5159, 148, 4, 70, 50, 0, "StyleData", "CaptionText", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[139376, 5168, 299, 8, 70, 29, 0, "StyleData", "BulletText", "All",
  CounterIncrements->"BulletText",
  StyleMenuListing->None],
Cell[139678, 5178, 61, 1, 70, 45, 0, "StyleData", "BulletText", \
"Presentation"],
Cell[139742, 5181, 57, 1, 70, 41, 0, "StyleData", "BulletText", "Printout"],
Cell[139802, 5184, 125, 3, 70, 49, 0, "StyleData", "BulletText", \
"EnhancedPrintout"],
Cell[139930, 5189, 98, 2, 70, 56, 0, "StyleData", "BulletText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[140065, 5196, 89, 2, 70, 29, 0, "StyleData", "HelpLabels", "All",
  StyleMenuListing->None],
Cell[140157, 5200, 61, 1, 70, 45, 0, "StyleData", "HelpLabels", \
"Presentation"],
Cell[140221, 5203, 91, 2, 70, 41, 0, "StyleData", "HelpLabels", "Printout"],
Cell[140315, 5207, 125, 3, 70, 49, 0, "StyleData", "HelpLabels", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[140489, 5216, 37, 0, 70, "Subsection"],

Cell[CellGroupData[{
Cell[140551, 5220, 38, 0, 70, "Subsubsection"],

Cell[CellGroupData[{
Cell[140614, 5224, 290, 9, 70, 31, 0, "StyleData", "FunctionName", "All",
  StyleMenuListing->None,
  CellTags->"FunctionName"],
Cell[140907, 5235, 63, 1, 70, 47, 0, "StyleData", "FunctionName", \
"Presentation"],
Cell[140973, 5238, 94, 2, 70, 43, 0, "StyleData", "FunctionName", \
"Printout"],
Cell[141070, 5242, 127, 3, 70, 51, 0, "StyleData", "FunctionName", \
"EnhancedPrintout"],
Cell[141200, 5247, 134, 3, 70, 58, 0, "StyleData", "FunctionName", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[141371, 5255, 259, 7, 70, 37, 0, "StyleData", "FunctionSubsection", \
"All",
  StyleMenuListing->None,
  CellTags->"FunctionSubsection"],
Cell[141633, 5264, 69, 1, 70, 53, 0, "StyleData", "FunctionSubsection", \
"Presentation"],
Cell[141705, 5267, 83, 1, 70, 49, 0, "StyleData", "FunctionSubsection", \
"Printout"],
Cell[141791, 5270, 133, 3, 70, 57, 0, "StyleData", "FunctionSubsection", \
"EnhancedPrintout"],
Cell[141927, 5275, 140, 3, 70, 64, 0, "StyleData", "FunctionSubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[142104, 5283, 219, 6, 70, 38, 0, "StyleData", "FunctionDescription", \
"All",
  CounterIncrements->"FunctionDescription",
  StyleMenuListing->None],
Cell[142326, 5291, 70, 1, 70, 54, 0, "StyleData", "FunctionDescription", \
"Presentation"],
Cell[142399, 5294, 100, 2, 70, 50, 0, "StyleData", "FunctionDescription", \
"Printout"],
Cell[142502, 5298, 158, 4, 70, 58, 0, "StyleData", "FunctionDescription", \
"EnhancedPrintout"],
Cell[142663, 5304, 165, 4, 70, 65, 0, "StyleData", "FunctionDescription", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[142865, 5313, 243, 6, 70, 43, 0, "StyleData", \
"FunctionDescriptionRuled", "All",
  CounterIncrements->"FunctionDescriptionRuled",
  StyleMenuListing->None],
Cell[143111, 5321, 75, 1, 70, 59, 0, "StyleData", "FunctionDescriptionRuled", \
"Presentation"],
Cell[143189, 5324, 105, 2, 70, 55, 0, "StyleData", \
"FunctionDescriptionRuled", "Printout"],
Cell[143297, 5328, 163, 4, 70, 63, 0, "StyleData", \
"FunctionDescriptionRuled", "EnhancedPrintout"],
Cell[143463, 5334, 170, 4, 70, 70, 0, "StyleData", \
"FunctionDescriptionRuled", "EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[143670, 5343, 244, 6, 70, 45, 0, "StyleData", \
"FunctionDescriptionRuleTop", "All",
  CounterIncrements->"FunctionDescriptionRuleTop",
  StyleMenuListing->None],
Cell[143917, 5351, 77, 1, 70, 61, 0, "StyleData", \
"FunctionDescriptionRuleTop", "Presentation"],
Cell[143997, 5354, 107, 2, 70, 57, 0, "StyleData", \
"FunctionDescriptionRuleTop", "Printout"],
Cell[144107, 5358, 165, 4, 70, 65, 0, "StyleData", \
"FunctionDescriptionRuleTop", "EnhancedPrintout"],
Cell[144275, 5364, 172, 4, 70, 72, 0, "StyleData", \
"FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[144484, 5373, 250, 6, 70, 48, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "All",
  CounterIncrements->"FunctionDescriptionRuleBottom",
  StyleMenuListing->None],
Cell[144737, 5381, 80, 1, 70, 64, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "Presentation"],
Cell[144820, 5384, 110, 2, 70, 60, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "Printout"],
Cell[144933, 5388, 168, 4, 70, 68, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "EnhancedPrintout"],
Cell[145104, 5394, 175, 4, 70, 75, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[145316, 5403, 111, 3, 70, 34, 0, "StyleData", "FunctionExample", "All",
  StyleMenuListing->None],
Cell[145430, 5408, 66, 1, 70, 50, 0, "StyleData", "FunctionExample", \
"Presentation"],
Cell[145499, 5411, 95, 2, 70, 46, 0, "StyleData", "FunctionExample", \
"Printout"],
Cell[145597, 5415, 129, 3, 70, 54, 0, "StyleData", "FunctionExample", \
"EnhancedPrintout"],
Cell[145729, 5420, 136, 3, 70, 61, 0, "StyleData", "FunctionExample", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[145902, 5428, 163, 5, 70, 35, 0, "StyleData", "FunctionTextNote", "All",
  StyleMenuListing->None],
Cell[146068, 5435, 67, 1, 70, 51, 0, "StyleData", "FunctionTextNote", \
"Presentation"],
Cell[146138, 5438, 96, 2, 70, 47, 0, "StyleData", "FunctionTextNote", \
"Printout"],
Cell[146237, 5442, 130, 3, 70, 55, 0, "StyleData", "FunctionTextNote", \
"EnhancedPrintout"],
Cell[146370, 5447, 137, 3, 70, 62, 0, "StyleData", "FunctionTextNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[146544, 5455, 341, 11, 70, 39, 0, "StyleData", "3ColumnFunctionTable", \
"All",
  StyleMenuListing->None],
Cell[146888, 5468, 71, 1, 70, 55, 0, "StyleData", "3ColumnFunctionTable", \
"Presentation"],
Cell[146962, 5471, 101, 2, 70, 51, 0, "StyleData", "3ColumnFunctionTable", \
"Printout"],
Cell[147066, 5475, 109, 2, 70, 59, 0, "StyleData", "3ColumnFunctionTable", \
"EnhancedPrintout"],
Cell[147178, 5479, 116, 2, 70, 66, 0, "StyleData", "3ColumnFunctionTable", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[147343, 5487, 42, 0, 70, "Subsubsection"],

Cell[CellGroupData[{
Cell[147410, 5491, 187, 6, 70, 29, 0, "StyleData", "TextNormal", "All",
  CounterIncrements->"TextNormal",
  StyleMenuListing->None],
Cell[147600, 5499, 61, 1, 70, 45, 0, "StyleData", "TextNormal", \
"Presentation"],
Cell[147664, 5502, 90, 2, 70, 41, 0, "StyleData", "TextNormal", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[147791, 5509, 325, 10, 70, 35, 0, "StyleData", "BrowserEmulation", "All",
  
  StyleMenuListing->None],
Cell[148119, 5521, 67, 1, 70, 51, 0, "StyleData", "BrowserEmulation", \
"Presentation"],
Cell[148189, 5524, 96, 2, 70, 47, 0, "StyleData", "BrowserEmulation", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[148322, 5531, 285, 9, 70, 31, 0, "StyleData", "CategoryDefs", "All",
  StyleMenuListing->None],
Cell[148610, 5542, 63, 1, 70, 47, 0, "StyleData", "CategoryDefs", \
"Presentation"],
Cell[148676, 5545, 92, 2, 70, 43, 0, "StyleData", "CategoryDefs", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[148805, 5552, 231, 7, 70, 28, 0, "StyleData", "Category1", "All",
  StyleMenuListing->None],
Cell[149039, 5561, 60, 1, 70, 44, 0, "StyleData", "Category1", \
"Presentation"],
Cell[149102, 5564, 73, 1, 70, 40, 0, "StyleData", "Category1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[149212, 5570, 270, 8, 70, 28, 0, "StyleData", "Category2", "All",
  StyleMenuListing->None],
Cell[149485, 5580, 60, 1, 70, 44, 0, "StyleData", "Category2", \
"Presentation"],
Cell[149548, 5583, 73, 1, 70, 40, 0, "StyleData", "Category2", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[149658, 5589, 268, 8, 70, 28, 0, "StyleData", "Category3", "All",
  StyleMenuListing->None],
Cell[149929, 5599, 60, 1, 70, 44, 0, "StyleData", "Category3", \
"Presentation"],
Cell[149992, 5602, 73, 1, 70, 40, 0, "StyleData", "Category3", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[150102, 5608, 257, 7, 70, 28, 0, "StyleData", "Category4", "All",
  StyleMenuListing->None],
Cell[150362, 5617, 60, 1, 70, 44, 0, "StyleData", "Category4", \
"Presentation"],
Cell[150425, 5620, 73, 1, 70, 40, 0, "StyleData", "Category4", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[150547, 5627, 29, 0, 70, "Subsubsection"],

Cell[CellGroupData[{
Cell[150601, 5631, 327, 11, 70, 31, 0, "StyleData", "4ColumnTable", "All",
  StyleMenuListing->None],
Cell[150931, 5644, 63, 1, 70, 47, 0, "StyleData", "4ColumnTable", \
"Presentation"],
Cell[150997, 5647, 76, 1, 70, 43, 0, "StyleData", "4ColumnTable", \
"Printout"],
Cell[151076, 5650, 84, 1, 70, 51, 0, "StyleData", "4ColumnTable", \
"EnhancedPrintout"],
Cell[151163, 5653, 91, 1, 70, 58, 0, "StyleData", "4ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[151291, 5659, 326, 11, 70, 31, 0, "StyleData", "5ColumnTable", "All",
  StyleMenuListing->None],
Cell[151620, 5672, 63, 1, 70, 47, 0, "StyleData", "5ColumnTable", \
"Presentation"],
Cell[151686, 5675, 76, 1, 70, 43, 0, "StyleData", "5ColumnTable", \
"Printout"],
Cell[151765, 5678, 84, 1, 70, 51, 0, "StyleData", "5ColumnTable", \
"EnhancedPrintout"],
Cell[151852, 5681, 91, 1, 70, 58, 0, "StyleData", "5ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[151980, 5687, 327, 11, 70, 31, 0, "StyleData", "6ColumnTable", "All",
  StyleMenuListing->None],
Cell[152310, 5700, 63, 1, 70, 47, 0, "StyleData", "6ColumnTable", \
"Presentation"],
Cell[152376, 5703, 76, 1, 70, 43, 0, "StyleData", "6ColumnTable", \
"Printout"],
Cell[152455, 5706, 84, 1, 70, 51, 0, "StyleData", "6ColumnTable", \
"EnhancedPrintout"],
Cell[152542, 5709, 91, 1, 70, 58, 0, "StyleData", "6ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[152670, 5715, 327, 11, 70, 31, 0, "StyleData", "7ColumnTable", "All",
  StyleMenuListing->None],
Cell[153000, 5728, 63, 1, 70, 47, 0, "StyleData", "7ColumnTable", \
"Presentation"],
Cell[153066, 5731, 76, 1, 70, 43, 0, "StyleData", "7ColumnTable", \
"Printout"],
Cell[153145, 5734, 84, 1, 70, 51, 0, "StyleData", "7ColumnTable", \
"EnhancedPrintout"],
Cell[153232, 5737, 91, 1, 70, 58, 0, "StyleData", "7ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[153360, 5743, 327, 11, 70, 31, 0, "StyleData", "8ColumnTable", "All",
  StyleMenuListing->None],
Cell[153690, 5756, 63, 1, 70, 47, 0, "StyleData", "8ColumnTable", \
"Presentation"],
Cell[153756, 5759, 76, 1, 70, 43, 0, "StyleData", "8ColumnTable", \
"Printout"],
Cell[153835, 5762, 84, 1, 70, 51, 0, "StyleData", "8ColumnTable", \
"EnhancedPrintout"],
Cell[153922, 5765, 91, 1, 70, 58, 0, "StyleData", "8ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[154050, 5771, 177, 5, 70, 33, 0, "StyleData", "ABItemizedText", "All",
  CounterIncrements->"ItemizedText",
  StyleMenuListing->None],
Cell[154230, 5778, 65, 1, 70, 49, 0, "StyleData", "ABItemizedText", \
"Presentation"],
Cell[154298, 5781, 106, 3, 70, 45, 0, "StyleData", "ABItemizedText", \
"Printout"],
Cell[154407, 5786, 140, 4, 70, 53, 0, "StyleData", "ABItemizedText", \
"EnhancedPrintout"],
Cell[154550, 5792, 147, 4, 70, 60, 0, "StyleData", "ABItemizedText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[154734, 5801, 1704, 40, 70, 29, 0, "StyleData", "ChapNumber", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  StyleMenuListing->None],
Cell[156441, 5843, 61, 1, 70, 45, 0, "StyleData", "ChapNumber", \
"Presentation"],
Cell[156505, 5846, 93, 2, 70, 41, 0, "StyleData", "ChapNumber", "Printout"],
Cell[156601, 5850, 160, 4, 70, 49, 0, "StyleData", "ChapNumber", \
"EnhancedPrintout"],
Cell[156764, 5856, 167, 4, 70, 56, 0, "StyleData", "ChapNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[156968, 5865, 1702, 40, 70, 28, 0, "StyleData", "ChapTitle", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  StyleMenuListing->None],
Cell[158673, 5907, 60, 1, 70, 44, 0, "StyleData", "ChapTitle", \
"Presentation"],
Cell[158736, 5910, 91, 2, 70, 40, 0, "StyleData", "ChapTitle", "Printout"],
Cell[158830, 5914, 180, 5, 70, 48, 0, "StyleData", "ChapTitle", \
"EnhancedPrintout"],
Cell[159013, 5921, 160, 4, 70, 55, 0, "StyleData", "ChapTitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[159210, 5930, 124, 4, 70, 30, 0, "StyleData", "ItemDingbat", "All",
  StyleMenuListing->None],
Cell[159337, 5936, 62, 1, 70, 46, 0, "StyleData", "ItemDingbat", \
"Presentation"],
Cell[159402, 5939, 68, 1, 70, 42, 0, "StyleData", "ItemDingbat", "Printout"],
Cell[159473, 5942, 72, 1, 70, 50, 0, "StyleData", "ItemDingbat", \
"EnhancedPrintout"],
Cell[159548, 5945, 79, 1, 70, 57, 0, "StyleData", "ItemDingbat", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[159664, 5951, 138, 4, 70, 24, 0, "StyleData", "Item1", "All",
  CounterIncrements->"Item1",
  StyleMenuListing->None],
Cell[159805, 5957, 56, 1, 70, 40, 0, "StyleData", "Item1", "Presentation"],
Cell[159864, 5960, 86, 2, 70, 36, 0, "StyleData", "Item1", "Printout"],
Cell[159953, 5964, 94, 2, 70, 44, 0, "StyleData", "Item1", \
"EnhancedPrintout"],
Cell[160050, 5968, 101, 2, 70, 51, 0, "StyleData", "Item1", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[160188, 5975, 132, 3, 70, 33, 0, "StyleData", "Item1Continued", "All",
  CounterIncrements->"Item1Continued",
  StyleMenuListing->None],
Cell[160323, 5980, 65, 1, 70, 49, 0, "StyleData", "Item1Continued", \
"Presentation"],
Cell[160391, 5983, 95, 2, 70, 45, 0, "StyleData", "Item1Continued", \
"Printout"],
Cell[160489, 5987, 103, 2, 70, 53, 0, "StyleData", "Item1Continued", \
"EnhancedPrintout"],
Cell[160595, 5991, 110, 2, 70, 60, 0, "StyleData", "Item1Continued", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[160742, 5998, 138, 4, 70, 24, 0, "StyleData", "Item2", "All",
  CounterIncrements->"Item2",
  StyleMenuListing->None],
Cell[160883, 6004, 56, 1, 70, 40, 0, "StyleData", "Item2", "Presentation"],
Cell[160942, 6007, 110, 3, 70, 36, 0, "StyleData", "Item2", "Printout"],
Cell[161055, 6012, 118, 3, 70, 44, 0, "StyleData", "Item2", \
"EnhancedPrintout"],
Cell[161176, 6017, 125, 3, 70, 51, 0, "StyleData", "Item2", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[161338, 6025, 132, 3, 70, 33, 0, "StyleData", "Item2Continued", "All",
  CounterIncrements->"Item2Continued",
  StyleMenuListing->None],
Cell[161473, 6030, 65, 1, 70, 49, 0, "StyleData", "Item2Continued", \
"Presentation"],
Cell[161541, 6033, 79, 1, 70, 45, 0, "StyleData", "Item2Continued", \
"Printout"],
Cell[161623, 6036, 103, 2, 70, 53, 0, "StyleData", "Item2Continued", \
"EnhancedPrintout"],
Cell[161729, 6040, 94, 1, 70, 60, 0, "StyleData", "Item2Continued", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[161860, 6046, 138, 4, 70, 24, 0, "StyleData", "Item3", "All",
  CounterIncrements->"Item3",
  StyleMenuListing->None],
Cell[162001, 6052, 56, 1, 70, 40, 0, "StyleData", "Item3", "Presentation"],
Cell[162060, 6055, 70, 1, 70, 36, 0, "StyleData", "Item3", "Printout"],
Cell[162133, 6058, 94, 2, 70, 44, 0, "StyleData", "Item3", \
"EnhancedPrintout"],
Cell[162230, 6062, 111, 2, 70, 51, 0, "StyleData", "Item3", \
"EnhancedPrintoutNonGray",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[162378, 6069, 132, 3, 70, 33, 0, "StyleData", "Item3Continued", "All",
  CounterIncrements->"Item3Continued",
  StyleMenuListing->None],
Cell[162513, 6074, 65, 1, 70, 49, 0, "StyleData", "Item3Continued", \
"Presentation"],
Cell[162581, 6077, 79, 1, 70, 45, 0, "StyleData", "Item3Continued", \
"Printout"],
Cell[162663, 6080, 103, 2, 70, 53, 0, "StyleData", "Item3Continued", \
"EnhancedPrintout"],
Cell[162769, 6084, 94, 1, 70, 60, 0, "StyleData", "Item3Continued", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[162900, 6090, 187, 5, 70, 37, 0, "StyleData", "ItemizedBulletText", \
"All",
  CounterIncrements->"ItemizedBulletText",
  StyleMenuListing->None],
Cell[163090, 6097, 69, 1, 70, 53, 0, "StyleData", "ItemizedBulletText", \
"Presentation"],
Cell[163162, 6100, 110, 3, 70, 49, 0, "StyleData", "ItemizedBulletText", \
"Printout"],
Cell[163275, 6105, 144, 4, 70, 57, 0, "StyleData", "ItemizedBulletText", \
"EnhancedPrintout"],
Cell[163422, 6111, 151, 4, 70, 64, 0, "StyleData", "ItemizedBulletText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[163610, 6120, 360, 9, 70, 26, 0, "StyleData", "NoteBox", "All",
  StyleMenuListing->None],
Cell[163973, 6131, 58, 1, 70, 42, 0, "StyleData", "NoteBox", "Presentation"],
Cell[164034, 6134, 122, 3, 70, 38, 0, "StyleData", "NoteBox", "Printout"],
Cell[164159, 6139, 162, 4, 70, 46, 0, "StyleData", "NoteBox", \
"EnhancedPrintout"],
Cell[164324, 6145, 162, 4, 70, 53, 0, "StyleData", "NoteBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[164523, 6154, 367, 9, 70, 34, 0, "StyleData", "ItemizedNoteBox", "All",
  StyleMenuListing->None],
Cell[164893, 6165, 66, 1, 70, 50, 0, "StyleData", "ItemizedNoteBox", \
"Presentation"],
Cell[164962, 6168, 131, 3, 70, 46, 0, "StyleData", "ItemizedNoteBox", \
"Printout"],
Cell[165096, 6173, 171, 4, 70, 54, 0, "StyleData", "ItemizedNoteBox", \
"EnhancedPrintout"],
Cell[165270, 6179, 171, 4, 70, 61, 0, "StyleData", "ItemizedNoteBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[165478, 6188, 446, 12, 70, 33, 0, "StyleData", "ItemizedTopBox", "All",
  StyleMenuListing->None],
Cell[165927, 6202, 65, 1, 70, 49, 0, "StyleData", "ItemizedTopBox", \
"Presentation"],
Cell[165995, 6205, 96, 2, 70, 45, 0, "StyleData", "ItemizedTopBox", \
"Printout"],
Cell[166094, 6209, 170, 4, 70, 53, 0, "StyleData", "ItemizedTopBox", \
"EnhancedPrintout"],
Cell[166267, 6215, 170, 4, 70, 60, 0, "StyleData", "ItemizedTopBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[166474, 6224, 449, 12, 70, 36, 0, "StyleData", "ItemizedBottomBox", \
"All",
  StyleMenuListing->None],
Cell[166926, 6238, 68, 1, 70, 52, 0, "StyleData", "ItemizedBottomBox", \
"Presentation"],
Cell[166997, 6241, 99, 2, 70, 48, 0, "StyleData", "ItemizedBottomBox", \
"Printout"],
Cell[167099, 6245, 173, 4, 70, 56, 0, "StyleData", "ItemizedBottomBox", \
"EnhancedPrintout"],
Cell[167275, 6251, 173, 4, 70, 63, 0, "StyleData", "ItemizedBottomBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[167485, 6260, 525, 16, 70, 34, 0, "StyleData", "MiddleSpacedBox", "All",
  StyleMenuListing->None],
Cell[168013, 6278, 66, 1, 70, 50, 0, "StyleData", "MiddleSpacedBox", \
"Presentation"],
Cell[168082, 6281, 146, 3, 70, 46, 0, "StyleData", "MiddleSpacedBox", \
"Printout"],
Cell[168231, 6286, 212, 5, 70, 54, 0, "StyleData", "MiddleSpacedBox", \
"EnhancedPrintout"],
Cell[168446, 6293, 219, 5, 70, 61, 0, "StyleData", "MiddleSpacedBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[168702, 6303, 152, 4, 70, 31, 0, "StyleData", "ItemizedNote", "All",
  CounterIncrements->"ItemizedNote",
  StyleMenuListing->None],
Cell[168857, 6309, 63, 1, 70, 47, 0, "StyleData", "ItemizedNote", \
"Presentation"],
Cell[168923, 6312, 114, 3, 70, 43, 0, "StyleData", "ItemizedNote", \
"Printout"],
Cell[169040, 6317, 172, 5, 70, 51, 0, "StyleData", "ItemizedNote", \
"EnhancedPrintout"],
Cell[169215, 6324, 179, 5, 70, 58, 0, "StyleData", "ItemizedNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[169431, 6334, 156, 4, 70, 36, 0, "StyleData", "ItemizedNoteBelow", "All",
  
  CounterIncrements->"ItemizedNote",
  StyleMenuListing->None],
Cell[169590, 6340, 68, 1, 70, 52, 0, "StyleData", "ItemizedNoteBelow", \
"Presentation"],
Cell[169661, 6343, 120, 3, 70, 48, 0, "StyleData", "ItemizedNoteBelow", \
"Printout"],
Cell[169784, 6348, 177, 5, 70, 56, 0, "StyleData", "ItemizedNoteBelow", \
"EnhancedPrintout"],
Cell[169964, 6355, 184, 5, 70, 63, 0, "StyleData", "ItemizedNoteBelow", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[170185, 6365, 183, 5, 70, 39, 0, "StyleData", "ItemizedTextBelowPic", \
"All",
  CounterIncrements->"ItemizedText",
  StyleMenuListing->None],
Cell[170371, 6372, 71, 1, 70, 55, 0, "StyleData", "ItemizedTextBelowPic", \
"Presentation"],
Cell[170445, 6375, 147, 4, 70, 51, 0, "StyleData", "ItemizedTextBelowPic", \
"Printout"],
Cell[170595, 6381, 181, 5, 70, 59, 0, "StyleData", "ItemizedTextBelowPic", \
"EnhancedPrintout"],
Cell[170779, 6388, 188, 5, 70, 66, 0, "StyleData", "ItemizedTextBelowPic", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[171004, 6398, 156, 4, 70, 36, 0, "StyleData", "ItemizedTextNote2", "All",
  
  CounterIncrements->"ItemizedNote",
  StyleMenuListing->None],
Cell[171163, 6404, 68, 1, 70, 52, 0, "StyleData", "ItemizedTextNote2", \
"Presentation"],
Cell[171234, 6407, 119, 3, 70, 48, 0, "StyleData", "ItemizedTextNote2", \
"Printout"],
Cell[171356, 6412, 153, 4, 70, 56, 0, "StyleData", "ItemizedTextNote2", \
"EnhancedPrintout"],
Cell[171512, 6418, 160, 4, 70, 63, 0, "StyleData", "ItemizedTextNote2", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[171709, 6427, 200, 5, 70, 32, 0, "StyleData", "NumberedItem1", "All",
  CounterIncrements->"NumberedItem1",
  StyleMenuListing->None],
Cell[171912, 6434, 64, 1, 70, 48, 0, "StyleData", "NumberedItem1", \
"Presentation"],
Cell[171979, 6437, 78, 1, 70, 44, 0, "StyleData", "NumberedItem1", \
"Printout"],
Cell[172060, 6440, 86, 1, 70, 52, 0, "StyleData", "NumberedItem1", \
"EnhancedPrintout"],
Cell[172149, 6443, 93, 1, 70, 59, 0, "StyleData", "NumberedItem1", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[172279, 6449, 200, 5, 70, 32, 0, "StyleData", "NumberedItem2", "All",
  CounterIncrements->"NumberedItem2",
  StyleMenuListing->None],
Cell[172482, 6456, 64, 1, 70, 48, 0, "StyleData", "NumberedItem2", \
"Presentation"],
Cell[172549, 6459, 78, 1, 70, 44, 0, "StyleData", "NumberedItem2", \
"Printout"],
Cell[172630, 6462, 86, 1, 70, 52, 0, "StyleData", "NumberedItem2", \
"EnhancedPrintout"],
Cell[172719, 6465, 93, 1, 70, 59, 0, "StyleData", "NumberedItem2", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[172849, 6471, 200, 5, 70, 32, 0, "StyleData", "NumberedItem3", "All",
  CounterIncrements->"NumberedItem3",
  StyleMenuListing->None],
Cell[173052, 6478, 64, 1, 70, 48, 0, "StyleData", "NumberedItem3", \
"Presentation"],
Cell[173119, 6481, 78, 1, 70, 44, 0, "StyleData", "NumberedItem3", \
"Printout"],
Cell[173200, 6484, 86, 1, 70, 52, 0, "StyleData", "NumberedItem3", \
"EnhancedPrintout"],
Cell[173289, 6487, 119, 2, 70, 59, 0, "StyleData", "NumberedItem3", \
"EnhancedPrintoutNonGray",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[173445, 6494, 152, 5, 70, 33, 0, "StyleData", "PageHeaderBold", "All",
  StyleMenuListing->None],
Cell[173600, 6501, 45, 0, 70, 45, 0, "StyleData", "PageHeaderBold", \
"Printout"],
Cell[173648, 6503, 135, 3, 70, 53, 0, "StyleData", "PageHeaderBold", \
"EnhancedPrintout"],
Cell[173786, 6508, 142, 3, 70, 60, 0, "StyleData", "PageHeaderBold", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[173965, 6516, 299, 10, 70, 33, 0, "StyleData", "SingleRowTable", "All",
  StyleMenuListing->None],
Cell[174267, 6528, 65, 1, 70, 49, 0, "StyleData", "SingleRowTable", \
"Presentation"],
Cell[174335, 6531, 78, 1, 70, 45, 0, "StyleData", "SingleRowTable", \
"Printout"],
Cell[174416, 6534, 86, 1, 70, 53, 0, "StyleData", "SingleRowTable", \
"EnhancedPrintout"],
Cell[174505, 6537, 93, 1, 70, 60, 0, "StyleData", "SingleRowTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[174635, 6543, 187, 5, 70, 35, 0, "StyleData", "Subsubsubsection", "All",
  StyleMenuListing->None],
Cell[174825, 6550, 67, 1, 70, 51, 0, "StyleData", "Subsubsubsection", \
"Presentation"],
Cell[174895, 6553, 96, 2, 70, 47, 0, "StyleData", "Subsubsubsection", \
"Printout"],
Cell[174994, 6557, 130, 3, 70, 55, 0, "StyleData", "Subsubsubsection", \
"EnhancedPrintout"],
Cell[175127, 6562, 137, 3, 70, 62, 0, "StyleData", "Subsubsubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[175301, 6570, 1615, 38, 70, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  StyleMenuListing->None],
Cell[176919, 6610, 62, 1, 70, 46, 0, "StyleData", "Subsubtitle", \
"Presentation"],
Cell[176984, 6613, 93, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[177080, 6617, 133, 3, 70, 50, 0, "StyleData", "Subsubtitle", \
"EnhancedPrintout"],
Cell[177216, 6622, 140, 3, 70, 57, 0, "StyleData", "Subsubtitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[177393, 6630, 1613, 38, 70, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  StyleMenuListing->None],
Cell[179009, 6670, 59, 1, 70, 43, 0, "StyleData", "Subtitle", \
"Presentation"],
Cell[179071, 6673, 91, 2, 70, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[179165, 6677, 131, 3, 70, 47, 0, "StyleData", "Subtitle", \
"EnhancedPrintout"],
Cell[179299, 6682, 138, 3, 70, 54, 0, "StyleData", "Subtitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[179474, 6690, 1329, 31, 70, 28, 0, "StyleData", "TextBelow", "All",
  StyleMenuListing->None],
Cell[180806, 6723, 60, 1, 70, 44, 0, "StyleData", "TextBelow", \
"Presentation"],
Cell[180869, 6726, 135, 4, 70, 40, 0, "StyleData", "TextBelow", "Printout"],
Cell[181007, 6732, 169, 5, 70, 48, 0, "StyleData", "TextBelow", \
"EnhancedPrintout"],
Cell[181179, 6739, 176, 5, 70, 55, 0, "StyleData", "TextBelow", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[181392, 6749, 1698, 40, 70, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  StyleMenuListing->None],
Cell[183093, 6791, 56, 1, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[183152, 6794, 88, 2, 70, 36, 0, "StyleData", "Title", "Printout"],
Cell[183243, 6798, 152, 4, 70, 44, 0, "StyleData", "Title", \
"EnhancedPrintout"],
Cell[183398, 6804, 159, 4, 70, 51, 0, "StyleData", "Title", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[183594, 6813, 1409, 33, 70, 34, 0, "StyleData", "Undersubsection", "All",
  
  StyleMenuListing->None],
Cell[185006, 6848, 66, 1, 70, 50, 0, "StyleData", "Undersubsection", \
"Presentation"],
Cell[185075, 6851, 96, 2, 70, 46, 0, "StyleData", "Undersubsection", \
"Printout"],
Cell[185174, 6855, 157, 4, 70, 54, 0, "StyleData", "Undersubsection", \
"EnhancedPrintout"],
Cell[185334, 6861, 164, 4, 70, 61, 0, "StyleData", "Undersubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[185535, 6870, 315, 9, 70, 31, 0, "StyleData", "SectionFirst", "All",
  CounterIncrements->"Section",
  StyleMenuListing->None],
Cell[185853, 6881, 63, 1, 70, 47, 0, "StyleData", "SectionFirst", \
"Presentation"],
Cell[185919, 6884, 117, 3, 70, 43, 0, "StyleData", "SectionFirst", \
"Printout"],
Cell[186039, 6889, 413, 11, 70, 51, 0, "StyleData", "SectionFirst", \
"EnhancedPrintout",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[186455, 6902, 393, 10, 70, 58, 0, "StyleData", "SectionFirst", \
"EnhancedPrintoutNonGray",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}]
}, Closed]],

Cell[CellGroupData[{
Cell[186885, 6917, 359, 10, 70, 34, 0, "StyleData", "SubsectionFirst", "All",
  StyleMenuListing->None],
Cell[187247, 6929, 66, 1, 70, 50, 0, "StyleData", "SubsectionFirst", \
"Presentation"],
Cell[187316, 6932, 118, 3, 70, 47, 0, "StyleData", "SubsectionFirst", \
"SlideShow"],
Cell[187437, 6937, 147, 3, 70, 46, 0, "StyleData", "SubsectionFirst", \
"Printout"],
Cell[187587, 6942, 236, 6, 70, 54, 0, "StyleData", "SubsectionFirst", \
"EnhancedPrintout"],
Cell[187826, 6950, 216, 5, 70, 61, 0, "StyleData", "SubsectionFirst", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[188079, 6960, 341, 9, 70, 37, 0, "StyleData", "SubsubsectionFirst", \
"All",
  StyleMenuListing->None],
Cell[188423, 6971, 69, 1, 70, 53, 0, "StyleData", "SubsubsectionFirst", \
"Presentation"],
Cell[188495, 6974, 150, 3, 70, 49, 0, "StyleData", "SubsubsectionFirst", \
"Printout"],
Cell[188648, 6979, 239, 6, 70, 57, 0, "StyleData", "SubsubsectionFirst", \
"EnhancedPrintout"],
Cell[188890, 6987, 219, 5, 70, 64, 0, "StyleData", "SubsubsectionFirst", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[189146, 6997, 192, 5, 70, 40, 0, "StyleData", "SubsubsubsectionFirst", \
"All",
  StyleMenuListing->None],
Cell[189341, 7004, 72, 1, 70, 56, 0, "StyleData", "SubsubsubsectionFirst", \
"Presentation"],
Cell[189416, 7007, 101, 2, 70, 52, 0, "StyleData", "SubsubsubsectionFirst", \
"Printout"],
Cell[189520, 7011, 135, 3, 70, 60, 0, "StyleData", "SubsubsubsectionFirst", \
"EnhancedPrintout"],
Cell[189658, 7016, 142, 3, 70, 67, 0, "StyleData", "SubsubsubsectionFirst", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[189815, 7022, 27, 0, 70, "Text"],

Cell[CellGroupData[{
Cell[189867, 7026, 175, 5, 70, 25, 0, "StyleData", "Spacer", "All",
  StyleMenuListing->None],
Cell[190045, 7033, 70, 2, 70, 37, 0, "StyleData", "Spacer", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[190152, 7040, 111, 3, 70, 38, 0, "StyleData", "DiscretionaryHyphen", \
"All",
  StyleMenuListing->None],
Cell[190266, 7045, 93, 2, 70, 50, 0, "StyleData", "DiscretionaryHyphen", \
"Printout"],
Cell[190362, 7049, 101, 2, 70, 58, 0, "StyleData", "DiscretionaryHyphen", \
"EnhancedPrintout"],
Cell[190466, 7053, 108, 2, 70, 65, 0, "StyleData", "DiscretionaryHyphen", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[190611, 7060, 176, 4, 70, 34, 0, "StyleData", "PictureSmaller1", "All",
  StyleMenuListing->None],
Cell[190790, 7066, 66, 1, 70, 50, 0, "StyleData", "PictureSmaller1", \
"Presentation"],
Cell[190859, 7069, 110, 2, 70, 46, 0, "StyleData", "PictureSmaller1", \
"Printout"],
Cell[190972, 7073, 118, 2, 70, 54, 0, "StyleData", "PictureSmaller1", \
"EnhancedPrintout"],
Cell[191093, 7077, 125, 2, 70, 61, 0, "StyleData", "PictureSmaller1", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[191255, 7084, 176, 4, 70, 34, 0, "StyleData", "PictureSmaller2", "All",
  StyleMenuListing->None],
Cell[191434, 7090, 66, 1, 70, 50, 0, "StyleData", "PictureSmaller2", \
"Presentation"],
Cell[191503, 7093, 110, 2, 70, 46, 0, "StyleData", "PictureSmaller2", \
"Printout"],
Cell[191616, 7097, 118, 2, 70, 54, 0, "StyleData", "PictureSmaller2", \
"EnhancedPrintout"],
Cell[191737, 7101, 125, 2, 70, 61, 0, "StyleData", "PictureSmaller2", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[191899, 7108, 176, 4, 70, 34, 0, "StyleData", "PictureSmaller3", "All",
  StyleMenuListing->None],
Cell[192078, 7114, 66, 1, 70, 50, 0, "StyleData", "PictureSmaller3", \
"Presentation"],
Cell[192147, 7117, 110, 2, 70, 46, 0, "StyleData", "PictureSmaller3", \
"Printout"],
Cell[192260, 7121, 118, 2, 70, 54, 0, "StyleData", "PictureSmaller3", \
"EnhancedPrintout"],
Cell[192381, 7125, 125, 2, 70, 61, 0, "StyleData", "PictureSmaller3", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[192543, 7132, 176, 4, 70, 34, 0, "StyleData", "PictureSmaller4", "All",
  StyleMenuListing->None],
Cell[192722, 7138, 66, 1, 70, 50, 0, "StyleData", "PictureSmaller4", \
"Presentation"],
Cell[192791, 7141, 110, 2, 70, 46, 0, "StyleData", "PictureSmaller4", \
"Printout"],
Cell[192904, 7145, 118, 2, 70, 54, 0, "StyleData", "PictureSmaller4", \
"EnhancedPrintout"],
Cell[193025, 7149, 125, 2, 70, 61, 0, "StyleData", "PictureSmaller4", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[193187, 7156, 176, 4, 70, 34, 0, "StyleData", "PictureSmaller5", "All",
  StyleMenuListing->None],
Cell[193366, 7162, 66, 1, 70, 50, 0, "StyleData", "PictureSmaller5", \
"Presentation"],
Cell[193435, 7165, 110, 2, 70, 46, 0, "StyleData", "PictureSmaller5", \
"Printout"],
Cell[193548, 7169, 118, 2, 70, 54, 0, "StyleData", "PictureSmaller5", \
"EnhancedPrintout"],
Cell[193669, 7173, 125, 2, 70, 61, 0, "StyleData", "PictureSmaller5", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[193831, 7180, 176, 4, 70, 34, 0, "StyleData", "PictureSmaller6", "All",
  StyleMenuListing->None],
Cell[194010, 7186, 66, 1, 70, 50, 0, "StyleData", "PictureSmaller6", \
"Presentation"],
Cell[194079, 7189, 110, 2, 70, 46, 0, "StyleData", "PictureSmaller6", \
"Printout"],
Cell[194192, 7193, 118, 2, 70, 54, 0, "StyleData", "PictureSmaller6", \
"EnhancedPrintout"],
Cell[194313, 7197, 125, 2, 70, 61, 0, "StyleData", "PictureSmaller6", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[194475, 7204, 172, 4, 70, 30, 0, "StyleData", "ItemPicture", "All",
  StyleMenuListing->None],
Cell[194650, 7210, 62, 1, 70, 46, 0, "StyleData", "ItemPicture", \
"Presentation"],
Cell[194715, 7213, 108, 2, 70, 42, 0, "StyleData", "ItemPicture", \
"Printout"],
Cell[194826, 7217, 117, 2, 70, 50, 0, "StyleData", "ItemPicture", \
"EnhancedPrintout"],
Cell[194946, 7221, 124, 2, 70, 57, 0, "StyleData", "ItemPicture", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[195107, 7228, 180, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller1", \
"All",
  StyleMenuListing->None],
Cell[195290, 7234, 70, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller1", \
"Presentation"],
Cell[195363, 7237, 116, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller1", \
"Printout"],
Cell[195482, 7241, 125, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller1", \
"EnhancedPrintout"],
Cell[195610, 7245, 132, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller1", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[195779, 7252, 180, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller2", \
"All",
  StyleMenuListing->None],
Cell[195962, 7258, 70, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller2", \
"Presentation"],
Cell[196035, 7261, 116, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller2", \
"Printout"],
Cell[196154, 7265, 125, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller2", \
"EnhancedPrintout"],
Cell[196282, 7269, 132, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller2", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[196451, 7276, 180, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller3", \
"All",
  StyleMenuListing->None],
Cell[196634, 7282, 70, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller3", \
"Presentation"],
Cell[196707, 7285, 117, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller3", \
"Printout"],
Cell[196827, 7289, 125, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller3", \
"EnhancedPrintout"],
Cell[196955, 7293, 132, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller3", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[197124, 7300, 180, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller4", \
"All",
  StyleMenuListing->None],
Cell[197307, 7306, 70, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller4", \
"Presentation"],
Cell[197380, 7309, 117, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller4", \
"Printout"],
Cell[197500, 7313, 125, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller4", \
"EnhancedPrintout"],
Cell[197628, 7317, 132, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller4", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[197797, 7324, 180, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller5", \
"All",
  StyleMenuListing->None],
Cell[197980, 7330, 70, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller5", \
"Presentation"],
Cell[198053, 7333, 117, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller5", \
"Printout"],
Cell[198173, 7337, 125, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller5", \
"EnhancedPrintout"],
Cell[198301, 7341, 132, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller5", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[198470, 7348, 180, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller6", \
"All",
  StyleMenuListing->None],
Cell[198653, 7354, 70, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller6", \
"Presentation"],
Cell[198726, 7357, 117, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller6", \
"Printout"],
Cell[198846, 7361, 125, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller6", \
"EnhancedPrintout"],
Cell[198974, 7365, 132, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller6", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[199143, 7372, 175, 4, 70, 33, 0, "StyleData", "PictureBigger1", "All",
  StyleMenuListing->None],
Cell[199321, 7378, 65, 1, 70, 49, 0, "StyleData", "PictureBigger1", \
"Presentation"],
Cell[199389, 7381, 109, 2, 70, 45, 0, "StyleData", "PictureBigger1", \
"Printout"],
Cell[199501, 7385, 117, 2, 70, 53, 0, "StyleData", "PictureBigger1", \
"EnhancedPrintout"],
Cell[199621, 7389, 124, 2, 70, 60, 0, "StyleData", "PictureBigger1", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[199782, 7396, 175, 4, 70, 33, 0, "StyleData", "PictureBigger2", "All",
  StyleMenuListing->None],
Cell[199960, 7402, 65, 1, 70, 49, 0, "StyleData", "PictureBigger2", \
"Presentation"],
Cell[200028, 7405, 109, 2, 70, 45, 0, "StyleData", "PictureBigger2", \
"Printout"],
Cell[200140, 7409, 117, 2, 70, 53, 0, "StyleData", "PictureBigger2", \
"EnhancedPrintout"],
Cell[200260, 7413, 124, 2, 70, 60, 0, "StyleData", "PictureBigger2", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[200421, 7420, 175, 4, 70, 33, 0, "StyleData", "PictureBigger3", "All",
  StyleMenuListing->None],
Cell[200599, 7426, 65, 1, 70, 49, 0, "StyleData", "PictureBigger3", \
"Presentation"],
Cell[200667, 7429, 109, 2, 70, 45, 0, "StyleData", "PictureBigger3", \
"Printout"],
Cell[200779, 7433, 117, 2, 70, 53, 0, "StyleData", "PictureBigger3", \
"EnhancedPrintout"],
Cell[200899, 7437, 124, 2, 70, 60, 0, "StyleData", "PictureBigger3", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[201060, 7444, 175, 4, 70, 33, 0, "StyleData", "PictureBigger4", "All",
  StyleMenuListing->None],
Cell[201238, 7450, 65, 1, 70, 49, 0, "StyleData", "PictureBigger4", \
"Presentation"],
Cell[201306, 7453, 109, 2, 70, 45, 0, "StyleData", "PictureBigger4", \
"Printout"],
Cell[201418, 7457, 117, 2, 70, 53, 0, "StyleData", "PictureBigger4", \
"EnhancedPrintout"],
Cell[201538, 7461, 124, 2, 70, 60, 0, "StyleData", "PictureBigger4", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[201699, 7468, 175, 4, 70, 33, 0, "StyleData", "PictureBigger5", "All",
  StyleMenuListing->None],
Cell[201877, 7474, 65, 1, 70, 49, 0, "StyleData", "PictureBigger5", \
"Presentation"],
Cell[201945, 7477, 108, 2, 70, 45, 0, "StyleData", "PictureBigger5", \
"Printout"],
Cell[202056, 7481, 116, 2, 70, 53, 0, "StyleData", "PictureBigger5", \
"EnhancedPrintout"],
Cell[202175, 7485, 123, 2, 70, 60, 0, "StyleData", "PictureBigger5", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[202335, 7492, 175, 4, 70, 33, 0, "StyleData", "PictureBigger6", "All",
  StyleMenuListing->None],
Cell[202513, 7498, 65, 1, 70, 49, 0, "StyleData", "PictureBigger6", \
"Presentation"],
Cell[202581, 7501, 109, 2, 70, 45, 0, "StyleData", "PictureBigger6", \
"Printout"],
Cell[202693, 7505, 117, 2, 70, 53, 0, "StyleData", "PictureBigger6", \
"EnhancedPrintout"],
Cell[202813, 7509, 124, 2, 70, 60, 0, "StyleData", "PictureBigger6", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[202974, 7516, 179, 4, 70, 37, 0, "StyleData", "ItemPictureBigger1", \
"All",
  StyleMenuListing->None],
Cell[203156, 7522, 69, 1, 70, 53, 0, "StyleData", "ItemPictureBigger1", \
"Presentation"],
Cell[203228, 7525, 115, 2, 70, 49, 0, "StyleData", "ItemPictureBigger1", \
"Printout"],
Cell[203346, 7529, 124, 2, 70, 57, 0, "StyleData", "ItemPictureBigger1", \
"EnhancedPrintout"],
Cell[203473, 7533, 131, 2, 70, 64, 0, "StyleData", "ItemPictureBigger1", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[203641, 7540, 179, 4, 70, 37, 0, "StyleData", "ItemPictureBigger2", \
"All",
  StyleMenuListing->None],
Cell[203823, 7546, 69, 1, 70, 53, 0, "StyleData", "ItemPictureBigger2", \
"Presentation"],
Cell[203895, 7549, 115, 2, 70, 49, 0, "StyleData", "ItemPictureBigger2", \
"Printout"],
Cell[204013, 7553, 124, 2, 70, 57, 0, "StyleData", "ItemPictureBigger2", \
"EnhancedPrintout"],
Cell[204140, 7557, 131, 2, 70, 64, 0, "StyleData", "ItemPictureBigger2", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[204308, 7564, 179, 4, 70, 37, 0, "StyleData", "ItemPictureBigger3", \
"All",
  StyleMenuListing->None],
Cell[204490, 7570, 69, 1, 70, 53, 0, "StyleData", "ItemPictureBigger3", \
"Presentation"],
Cell[204562, 7573, 116, 2, 70, 49, 0, "StyleData", "ItemPictureBigger3", \
"Printout"],
Cell[204681, 7577, 124, 2, 70, 57, 0, "StyleData", "ItemPictureBigger3", \
"EnhancedPrintout"],
Cell[204808, 7581, 131, 2, 70, 64, 0, "StyleData", "ItemPictureBigger3", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[204976, 7588, 179, 4, 70, 37, 0, "StyleData", "ItemPictureBigger4", \
"All",
  StyleMenuListing->None],
Cell[205158, 7594, 69, 1, 70, 53, 0, "StyleData", "ItemPictureBigger4", \
"Presentation"],
Cell[205230, 7597, 116, 2, 70, 49, 0, "StyleData", "ItemPictureBigger4", \
"Printout"],
Cell[205349, 7601, 124, 2, 70, 57, 0, "StyleData", "ItemPictureBigger4", \
"EnhancedPrintout"],
Cell[205476, 7605, 131, 2, 70, 64, 0, "StyleData", "ItemPictureBigger4", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[205644, 7612, 179, 4, 70, 37, 0, "StyleData", "ItemPictureBigger5", \
"All",
  StyleMenuListing->None],
Cell[205826, 7618, 69, 1, 70, 53, 0, "StyleData", "ItemPictureBigger5", \
"Presentation"],
Cell[205898, 7621, 115, 2, 70, 49, 0, "StyleData", "ItemPictureBigger5", \
"Printout"],
Cell[206016, 7625, 123, 2, 70, 57, 0, "StyleData", "ItemPictureBigger5", \
"EnhancedPrintout"],
Cell[206142, 7629, 130, 2, 70, 64, 0, "StyleData", "ItemPictureBigger5", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[206309, 7636, 179, 4, 70, 37, 0, "StyleData", "ItemPictureBigger6", \
"All",
  StyleMenuListing->None],
Cell[206491, 7642, 69, 1, 70, 53, 0, "StyleData", "ItemPictureBigger6", \
"Presentation"],
Cell[206563, 7645, 116, 2, 70, 49, 0, "StyleData", "ItemPictureBigger6", \
"Printout"],
Cell[206682, 7649, 123, 2, 70, 57, 0, "StyleData", "ItemPictureBigger6", \
"EnhancedPrintout"],
Cell[206808, 7653, 130, 2, 70, 64, 0, "StyleData", "ItemPictureBigger6", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[206975, 7660, 133, 3, 70, 32, 0, "StyleData", "ScreenGraphic", "All",
  StyleMenuListing->None],
Cell[207111, 7665, 64, 1, 70, 48, 0, "StyleData", "ScreenGraphic", \
"Presentation"],
Cell[207178, 7668, 85, 1, 70, 44, 0, "StyleData", "ScreenGraphic", \
"Printout"],
Cell[207266, 7671, 182, 4, 70, 52, 0, "StyleData", "ScreenGraphic", \
"EnhancedPrintout"],
Cell[207451, 7677, 189, 4, 70, 59, 0, "StyleData", "ScreenGraphic", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[207677, 7686, 221, 6, 70, 31, 0, "StyleData", "PrintGraphic", "All",
  StyleMenuListing->None],
Cell[207901, 7694, 63, 1, 70, 47, 0, "StyleData", "PrintGraphic", \
"Presentation"],
Cell[207967, 7697, 173, 4, 70, 43, 0, "StyleData", "PrintGraphic", \
"Printout"],
Cell[208143, 7703, 156, 3, 70, 51, 0, "StyleData", "PrintGraphic", \
"EnhancedPrintout"],
Cell[208302, 7708, 163, 3, 70, 58, 0, "StyleData", "PrintGraphic", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[208502, 7716, 155, 5, 70, 32, 0, "StyleData", "SmallTextSans", "All"],
Cell[208660, 7723, 64, 1, 70, 48, 0, "StyleData", "SmallTextSans", \
"Presentation"],
Cell[208727, 7726, 113, 3, 70, 44, 0, "StyleData", "SmallTextSans", \
"Printout"],
Cell[208843, 7731, 205, 6, 70, 52, 0, "StyleData", "SmallTextSans", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[209121, 7745, 30, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[209176, 7749, 205, 6, 70, 32, 0, "StyleData", "BilateralCell", "All",
  StyleMenuListing->None],
Cell[209384, 7757, 64, 1, 70, 48, 0, "StyleData", "BilateralCell", \
"Presentation"],
Cell[209451, 7760, 115, 2, 70, 45, 0, "StyleData", "BilateralCell", \
"SlideShow"],
Cell[209569, 7764, 117, 3, 70, 44, 0, "StyleData", "BilateralCell", \
"Printout"],
Cell[209689, 7769, 151, 4, 70, 52, 0, "StyleData", "BilateralCell", \
"EnhancedPrintout"],
Cell[209843, 7775, 158, 4, 70, 59, 0, "StyleData", "BilateralCell", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[210038, 7784, 155, 4, 70, 33, 0, "StyleData", "RuledPageBreak", "All"],
Cell[210196, 7790, 65, 1, 70, 49, 0, "StyleData", "RuledPageBreak", \
"Presentation"],
Cell[210264, 7793, 81, 1, 70, 46, 0, "StyleData", "RuledPageBreak", \
"SlideShow"],
Cell[210348, 7796, 117, 3, 70, 45, 0, "StyleData", "RuledPageBreak", \
"Printout"],
Cell[210468, 7801, 110, 2, 70, 53, 0, "StyleData", "RuledPageBreak", \
"EnhancedPrintout"],
Cell[210581, 7805, 117, 2, 70, 60, 0, "StyleData", "RuledPageBreak", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[210713, 7810, 487, 14, 70, 31, 0, "StyleData", "PaletteTitle", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->None],
Cell[211203, 7826, 320, 10, 70, 32, 0, "StyleData", "PaletteButton", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->None],
Cell[211526, 7838, 320, 10, 70, 33, 0, "StyleData", "PaletteButton2", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[211883, 7853, 33, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[211941, 7857, 339, 8, 70, 27, 0, "StyleData", "Outline1", "All",
  CounterIncrements->"Outline1",
  CounterAssignments->{{"Outline2", 0}, {"Outline3", 0}, {"Outline4", 0}}],
Cell[212283, 7867, 59, 1, 70, 43, 0, "StyleData", "Outline1", \
"Presentation"],
Cell[212345, 7870, 100, 1, 70, 39, 0, "StyleData", "Outline1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[212482, 7876, 348, 9, 70, 27, 0, "StyleData", "Outline2", "All",
  CounterIncrements->"Outline2",
  CounterAssignments->{{"Outline3", 0}, {"Outline4", 0}}],
Cell[212833, 7887, 59, 1, 70, 43, 0, "StyleData", "Outline2", \
"Presentation"],
Cell[212895, 7890, 126, 2, 70, 39, 0, "StyleData", "Outline2", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[213058, 7897, 272, 7, 70, 27, 0, "StyleData", "Outline3", "All",
  CounterIncrements->"Outline3",
  CounterAssignments->{{"Outline4", 0}}],
Cell[213333, 7906, 59, 1, 70, 43, 0, "StyleData", "Outline3", \
"Presentation"],
Cell[213395, 7909, 89, 1, 70, 39, 0, "StyleData", "Outline3", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[213521, 7915, 269, 7, 70, 27, 0, "StyleData", "Outline4", "All",
  CounterIncrements->"Outline4"],
Cell[213793, 7924, 59, 1, 70, 43, 0, "StyleData", "Outline4", \
"Presentation"],
Cell[213855, 7927, 39, 0, 70, 39, 0, "StyleData", "Outline4", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[213943, 7933, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[214004, 7937, 709, 21, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[214716, 7960, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[214918, 7967, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[215081, 7975, 1681, 40, 70, 35, 0, "StyleData", "SlideShowSection", \
"All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[216765, 8017, 67, 1, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[216835, 8020, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[216936, 8024, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[217095, 8032, 327, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[217425, 8044, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[217474, 8046, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[217639, 8054, 341, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[217983, 8065, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[218030, 8067, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[218177, 8074, 166, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[218346, 8080, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[218405, 8083, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[218536, 8091, 50, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[218611, 8095, 186, 5, 70, 32, 0, "StyleData", "ContentsTitle", "All"],
Cell[218800, 8102, 64, 1, 70, 48, 0, "StyleData", "ContentsTitle", \
"Presentation"],
Cell[218867, 8105, 151, 4, 70, 44, 0, "StyleData", "ContentsTitle", \
"Printout"],
Cell[219021, 8111, 219, 6, 70, 52, 0, "StyleData", "ContentsTitle", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[219277, 8122, 238, 7, 70, 34, 0, "StyleData", "ContentsSection", "All",
  StyleMenuListing->None],
Cell[219518, 8131, 66, 1, 70, 50, 0, "StyleData", "ContentsSection", \
"Presentation"],
Cell[219587, 8134, 122, 3, 70, 46, 0, "StyleData", "ContentsSection", \
"Printout"],
Cell[219712, 8139, 184, 5, 70, 54, 0, "StyleData", "ContentsSection", \
"EnhancedPrintout"],
Cell[219899, 8146, 191, 5, 70, 61, 0, "StyleData", "ContentsSection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[220127, 8156, 191, 6, 70, 31, 0, "StyleData", "IndexSection", "All",
  StyleMenuListing->None],
Cell[220321, 8164, 63, 1, 70, 47, 0, "StyleData", "IndexSection", \
"Presentation"],
Cell[220387, 8167, 119, 3, 70, 43, 0, "StyleData", "IndexSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[220543, 8175, 166, 4, 70, 27, 0, "StyleData", "Contents", "All",
  StyleMenuListing->None],
Cell[220712, 8181, 59, 1, 70, 43, 0, "StyleData", "Contents", \
"Presentation"],
Cell[220774, 8184, 89, 2, 70, 39, 0, "StyleData", "Contents", "Printout"],
Cell[220866, 8188, 123, 3, 70, 47, 0, "StyleData", "Contents", \
"EnhancedPrintout"],
Cell[220992, 8193, 130, 3, 70, 54, 0, "StyleData", "Contents", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[221159, 8201, 108, 3, 70, 24, 0, "StyleData", "Index", "All",
  StyleMenuListing->None],
Cell[221270, 8206, 56, 1, 70, 40, 0, "StyleData", "Index", "Presentation"],
Cell[221329, 8209, 85, 2, 70, 36, 0, "StyleData", "Index", "Printout"],
Cell[221417, 8213, 119, 3, 70, 44, 0, "StyleData", "Index", \
"EnhancedPrintout"],
Cell[221539, 8218, 126, 3, 70, 51, 0, "StyleData", "Index", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[221702, 8226, 90, 2, 70, 32, 0, "StyleData", "IndexSubentry", "All"],
Cell[221795, 8230, 64, 1, 70, 48, 0, "StyleData", "IndexSubentry", \
"Presentation"],
Cell[221862, 8233, 93, 2, 70, 44, 0, "StyleData", "IndexSubentry", \
"Printout"],
Cell[221958, 8237, 127, 3, 70, 52, 0, "StyleData", "IndexSubentry", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[222122, 8245, 216, 7, 70, 31, 0, "StyleData", "Index2Column", "All",
  StyleMenuListing->None],
Cell[222341, 8254, 63, 1, 70, 47, 0, "StyleData", "Index2Column", \
"Presentation"],
Cell[222407, 8257, 91, 2, 70, 43, 0, "StyleData", "Index2Column", \
"Printout"],
Cell[222501, 8261, 150, 4, 70, 51, 0, "StyleData", "Index2Column", \
"EnhancedPrintout"],
Cell[222654, 8267, 157, 4, 70, 58, 0, "StyleData", "Index2Column", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[222848, 8276, 132, 5, 70, 25, 0, "StyleData", "Leader", "All",
  StyleMenuListing->None],
Cell[222983, 8283, 53, 1, 70, 37, 0, "StyleData", "Leader", "Printout"],
Cell[223039, 8286, 87, 2, 70, 45, 0, "StyleData", "Leader", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[223163, 8293, 138, 5, 70, 31, 0, "StyleData", "LeaderNoDots", "All",
  StyleMenuListing->None],
Cell[223304, 8300, 59, 1, 70, 43, 0, "StyleData", "LeaderNoDots", \
"Printout"],
Cell[223366, 8303, 93, 2, 70, 51, 0, "StyleData", "LeaderNoDots", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[223496, 8310, 275, 7, 70, 27, 0, "StyleData", "PageLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[223774, 8319, 66, 1, 70, 39, 0, "StyleData", "PageLink", "Printout"],
Cell[223843, 8322, 74, 1, 70, 47, 0, "StyleData", "PageLink", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[223954, 8328, 144, 5, 70, 26, 0, "StyleData", "TOCPage", "All",
  StyleMenuListing->None],
Cell[224101, 8335, 58, 1, 70, 42, 0, "StyleData", "TOCPage", "Presentation"],
Cell[224162, 8338, 54, 1, 70, 38, 0, "StyleData", "TOCPage", "Printout"],
Cell[224219, 8341, 88, 2, 70, 46, 0, "StyleData", "TOCPage", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[224344, 8348, 267, 8, 70, 27, 0, "StyleData", "TOCTitle", "All",
  CounterIncrements->"TOCTitle",
  CounterAssignments->{{"TOCSection", 0}}],
Cell[224614, 8358, 59, 1, 70, 43, 0, "StyleData", "TOCTitle", \
"Presentation"],
Cell[224676, 8361, 135, 4, 70, 39, 0, "StyleData", "TOCTitle", "Printout"],
Cell[224814, 8367, 197, 6, 70, 47, 0, "StyleData", "TOCTitle", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[225048, 8378, 254, 7, 70, 29, 0, "StyleData", "TOCSection", "All",
  CounterIncrements->"TOCSection",
  CounterAssignments->{{"TOCSubsection", 0}}],
Cell[225305, 8387, 61, 1, 70, 45, 0, "StyleData", "TOCSection", \
"Presentation"],
Cell[225369, 8390, 116, 3, 70, 41, 0, "StyleData", "TOCSection", "Printout"],
Cell[225488, 8395, 177, 5, 70, 49, 0, "StyleData", "TOCSection", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[225702, 8405, 236, 6, 70, 32, 0, "StyleData", "TOCSubsection", "All",
  CounterIncrements->"TOCSubsection",
  CounterAssignments->{{"TOCSubsubsection", 0}}],
Cell[225941, 8413, 64, 1, 70, 48, 0, "StyleData", "TOCSubsection", \
"Presentation"],
Cell[226008, 8416, 119, 3, 70, 44, 0, "StyleData", "TOCSubsection", \
"Printout"],
Cell[226130, 8421, 174, 5, 70, 52, 0, "StyleData", "TOCSubsection", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[226341, 8431, 194, 5, 70, 35, 0, "StyleData", "TOCSubsubsection", "All",
  CounterIncrements->"TOCSubsubsection"],
Cell[226538, 8438, 67, 1, 70, 51, 0, "StyleData", "TOCSubsubsection", \
"Presentation"],
Cell[226608, 8441, 121, 3, 70, 47, 0, "StyleData", "TOCSubsubsection", \
"Printout"],
Cell[226732, 8446, 155, 4, 70, 55, 0, "StyleData", "TOCSubsubsection", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[226924, 8455, 87, 2, 70, 34, 0, "StyleData", "TOCTitleDingbat", "All"],
Cell[227014, 8459, 102, 2, 70, 54, 0, "StyleData", "TOCTitleDingbat", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[227153, 8466, 89, 2, 70, 36, 0, "StyleData", "TOCSectionDingbat", \
"All"],
Cell[227245, 8470, 103, 2, 70, 56, 0, "StyleData", "TOCSectionDingbat", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[227385, 8477, 92, 2, 70, 39, 0, "StyleData", "TOCSubsectionDingbat", \
"All"],
Cell[227480, 8481, 74, 1, 70, 59, 0, "StyleData", "TOCSubsectionDingbat", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[227591, 8487, 334, 9, 70, 36, 0, "StyleData", "TOCTitleCondensed", "All",
  
  CounterIncrements->"TOCTitleCondensed",
  CounterAssignments->{{"TOCSectionCondensed", 0}, {
      "TOCSubsectionCondensed", 0}}],
Cell[227928, 8498, 68, 1, 70, 52, 0, "StyleData", "TOCTitleCondensed", \
"Presentation"],
Cell[227999, 8501, 123, 3, 70, 48, 0, "StyleData", "TOCTitleCondensed", \
"Printout"],
Cell[228125, 8506, 185, 5, 70, 56, 0, "StyleData", "TOCTitleCondensed", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[228347, 8516, 323, 9, 70, 38, 0, "StyleData", "TOCSectionCondensed", \
"All",
  CounterIncrements->"TOCSectionCondensed",
  CounterAssignments->{{"TOCSubsection", 0}}],
Cell[228673, 8527, 70, 1, 70, 54, 0, "StyleData", "TOCSectionCondensed", \
"Presentation"],
Cell[228746, 8530, 125, 3, 70, 50, 0, "StyleData", "TOCSectionCondensed", \
"Printout"],
Cell[228874, 8535, 159, 4, 70, 58, 0, "StyleData", "TOCSectionCondensed", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[229070, 8544, 179, 5, 70, 41, 0, "StyleData", "TOCSubsectionCondensed", \
"All"],
Cell[229252, 8551, 73, 1, 70, 57, 0, "StyleData", "TOCSubsectionCondensed", \
"Presentation"],
Cell[229328, 8554, 149, 4, 70, 53, 0, "StyleData", "TOCSubsectionCondensed", \
"Printout"],
Cell[229480, 8560, 183, 5, 70, 61, 0, "StyleData", "TOCSubsectionCondensed", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[229700, 8570, 212, 5, 70, 44, 0, "StyleData", \
"TOCSubsubsectionCondensed", "All",
  CounterIncrements->"TOCSubsubsectionCondensed"],
Cell[229915, 8577, 76, 1, 70, 60, 0, "StyleData", \
"TOCSubsubsectionCondensed", "Presentation"],
Cell[229994, 8580, 130, 3, 70, 56, 0, "StyleData", \
"TOCSubsubsectionCondensed", "Printout"],
Cell[230127, 8585, 164, 4, 70, 64, 0, "StyleData", \
"TOCSubsubsectionCondensed", "EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[230328, 8594, 143, 4, 70, 35, 0, "StyleData", "TitlePageGraphic", \
"All"],
Cell[230474, 8600, 67, 1, 70, 51, 0, "StyleData", "TitlePageGraphic", \
"Presentation"],
Cell[230544, 8603, 83, 1, 70, 47, 0, "StyleData", "TitlePageGraphic", \
"Printout"],
Cell[230630, 8606, 91, 1, 70, 55, 0, "StyleData", "TitlePageGraphic", \
"EnhancedPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[230758, 8612, 65, 1, 70, 32, 0, "StyleData", "TitlePageLogo", "All"],
Cell[230826, 8615, 64, 1, 70, 48, 0, "StyleData", "TitlePageLogo", \
"Presentation"],
Cell[230893, 8618, 44, 0, 70, 44, 0, "StyleData", "TitlePageLogo", \
"Printout"],
Cell[230940, 8620, 52, 0, 70, 52, 0, "StyleData", "TitlePageLogo", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[231041, 8626, 35, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[231101, 8630, 134, 4, 70, 24, 0, "StyleData", "Line1", "All",
  StyleMenuListing->None],
Cell[231238, 8636, 55, 1, 70, 40, 0, "StyleData", "Line1", "Presentation"],
Cell[231296, 8639, 71, 1, 70, 36, 0, "StyleData", "Line1", "Printout"]
}, Closed]],
Cell[231382, 8643, 65, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[231472, 8650, 168, 5, 70, 29, 0, "StyleData", "ProgramTop", "All",
  StyleMenuListing->None],
Cell[231643, 8657, 60, 1, 70, 45, 0, "StyleData", "ProgramTop", \
"Presentation"],
Cell[231706, 8660, 77, 1, 70, 41, 0, "StyleData", "ProgramTop", "Printout"]
}, Closed]],
Cell[231798, 8664, 61, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[231884, 8672, 171, 5, 70, 32, 0, "StyleData", "ProgramBottom", "All",
  StyleMenuListing->None],
Cell[232058, 8679, 63, 1, 70, 48, 0, "StyleData", "ProgramBottom", \
"Presentation"],
Cell[232124, 8682, 80, 1, 70, 44, 0, "StyleData", "ProgramBottom", \
"Printout"]
}, Closed]],
Cell[232219, 8686, 64, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[232308, 8694, 193, 6, 70, 31, 0, "StyleData", "SessionLabel", "All",
  StyleMenuListing->None],
Cell[232504, 8702, 63, 1, 70, 47, 0, "StyleData", "SessionLabel", \
"Presentation"],
Cell[232570, 8705, 93, 2, 70, 43, 0, "StyleData", "SessionLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[232712, 8713, 43, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[232780, 8717, 126, 4, 70, 29, 0, "StyleData", "PageHeader", "All",
  StyleMenuListing->None],
Cell[232909, 8723, 41, 0, 70, 41, 0, "StyleData", "PageHeader", "Printout"],
Cell[232953, 8725, 81, 1, 70, 49, 0, "StyleData", "PageHeader", \
"EnhancedPrintout"],
Cell[233037, 8728, 88, 1, 70, 56, 0, "StyleData", "PageHeader", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[233162, 8734, 152, 5, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None],
Cell[233317, 8741, 41, 0, 70, 41, 0, "StyleData", "PageNumber", "Printout"],
Cell[233361, 8743, 103, 2, 70, 49, 0, "StyleData", "PageNumber", \
"EnhancedPrintout"],
Cell[233467, 8747, 110, 2, 70, 56, 0, "StyleData", "PageNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[233614, 8754, 97, 3, 70, 29, 0, "StyleData", "PageFooter", "All",
  StyleMenuListing->None],
Cell[233714, 8759, 41, 0, 70, 41, 0, "StyleData", "PageFooter", "Printout"],
Cell[233758, 8761, 81, 1, 70, 49, 0, "StyleData", "PageFooter", \
"EnhancedPrintout"],
Cell[233842, 8764, 88, 1, 70, 56, 0, "StyleData", "PageFooter", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[233967, 8770, 39, 0, 70, "Subsection"],

Cell[CellGroupData[{
Cell[234031, 8774, 122, 4, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[234156, 8780, 37, 0, 70, 37, 0, "StyleData", "Header", "Printout"],
Cell[234196, 8782, 99, 2, 70, 45, 0, "StyleData", "Header", \
"EnhancedPrintout"],
Cell[234298, 8786, 106, 2, 70, 52, 0, "StyleData", "Header", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[234441, 8793, 93, 3, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[234537, 8798, 37, 0, 70, 37, 0, "StyleData", "Footer", "Printout"],
Cell[234577, 8800, 77, 1, 70, 45, 0, "StyleData", "Footer", \
"EnhancedPrintout"],
Cell[234657, 8803, 84, 1, 70, 52, 0, "StyleData", "Footer", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[234802, 8811, 36, 0, 39, "Section"],
Cell[234841, 8813, 305, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[235171, 8822, 336, 11, 70, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[235510, 8835, 98, 2, 70, 53, 0, "StyleData", "CellExpression", \
"EnhancedPrintout"],
Cell[235611, 8839, 105, 2, 70, 60, 0, "StyleData", "CellExpression", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[235753, 8846, 157, 5, 70, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[235913, 8853, 77, 1, 70, 48, 0, "StyleData", "InputForm", \
"EnhancedPrintout"],
Cell[235993, 8856, 84, 1, 70, 55, 0, "StyleData", "InputForm", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[236114, 8862, 151, 5, 70, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[236268, 8869, 78, 1, 70, 49, 0, "StyleData", "OutputForm", \
"EnhancedPrintout"],
Cell[236349, 8872, 85, 1, 70, 56, 0, "StyleData", "OutputForm", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[236471, 8878, 341, 8, 70, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[236815, 8888, 80, 1, 70, 51, 0, "StyleData", "StandardForm", \
"EnhancedPrintout"],
Cell[236898, 8891, 87, 1, 70, 58, 0, "StyleData", "StandardForm", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[237034, 8898, 35, 0, 39, "Section"],
Cell[237072, 8900, 330, 6, 70, "Text"],
Cell[237405, 8908, 61, 1, 70, 35, 0, "StyleData", "UnmatchedBracket", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

