(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43452,       1469]*)
(*NotebookOutlinePosition[     44088,       1491]*)
(*  CellTagsIndexPosition[     44044,       1487]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style. Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->GrayLevel[0]},
  ScriptMinSize->9,
  Background->RGBColor[0.91104, 0.923705, 0.119799]],

Cell[StyleData[All, "Presentation"],
  CellBracketOptions->{"Color"->GrayLevel[0]},
  ScriptMinSize->9,
  Background->RGBColor[0.91104, 0.923705, 0.119799]],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  ScriptMinSize->9,
  Background->RGBColor[0.91104, 0.923705, 0.119799]],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "ColorPrintout"],
  PageWidth->PaperWidth,
  Background->RGBColor[0.91104, 0.923705, 0.119799],
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{10, 20}, {8, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->{{100, 4}, {8, 10}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  TextAlignment->Left,
  LineSpacing->{1, 16},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->48,
  FontWeight->"Bold",
  FontColor->RGBColor[0.920012, 0.0220188, 0.0587472]],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{18, 20}, {8, 20}},
  FontSize->72],

Cell[StyleData["Title", "Printout"],
  LineSpacing->{1, 0},
  FontSize->36,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Title", "ColorPrintout"],
  LineSpacing->{1, 0},
  FontSize->36]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{100, Inherited}, {2, 50}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontWeight->"Bold",
  FontColor->RGBColor[0.418997, 0.370581, 0.933791]],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{150, 20}, {4, 82}},
  FontSize->36],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{50, Inherited}, {0, 37}},
  FontSize->18,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Subtitle", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {0, 37}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{100, Inherited}, {6, 2}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{150, 20}, {8, 4}},
  FontSize->21],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{50, Inherited}, {6, 0}}],

Cell[StyleData["Subsubtitle", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {6, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellDingbat->None,
  CellMargins->{{25, 10}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{10, 4}, {6, 6}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[0.912505, 0.367178, 0.000564584]],

Cell[StyleData["Section", "Presentation"],
  CellMargins->{{35, 10}, {6, 30}},
  FontSize->21],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{20, 20}, {4, 20}},
  FontSize->12,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Section", "ColorPrintout"],
  CellMargins->{{20, 20}, {4, 20}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{100, 20}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{2, 12}, {0, 12}},
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{150, 20}, {6, 30}},
  FontSize->21],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{50, 20}, {4, 20}},
  FontSize->12],

Cell[StyleData["Subsection", "ColorPrintout"],
  CellMargins->{{50, 20}, {4, 20}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{100, Inherited}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subsubsection",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{150, 10}, {12, 30}},
  FontSize->18],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{50, Inherited}, {4, 20}},
  FontSize->10],

Cell[StyleData["Subsubsection", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {4, 20}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellFrame->False,
  CellMargins->{{100, 20}, {7, 12}},
  CellFrameMargins->{{4, 10}, {6, 0}},
  CellFrameLabelMargins->4,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 7},
  FontSize->14],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{150, 20}, {10, 16}},
  FontSize->21],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{50, 20}, {4, 8}},
  Hyphenation->True,
  LineSpacing->{1, 5},
  FontSize->10],

Cell[StyleData["Text", "ColorPrintout"],
  CellMargins->{{50, 20}, {4, 8}},
  Hyphenation->True,
  LineSpacing->{1, 5},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{100, Inherited}, {Inherited, Inherited}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 2},
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{150, 10}, {6, 8}},
  FontSize->15],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}},
  Hyphenation->True,
  FontSize->8],

Cell[StyleData["SmallText", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}},
  Hyphenation->True,
  FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{1, 1}, {0, 1}},
  CellMargins->{{100, 0}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  FontSize->18,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.187182, 0.813901, 0.186114]],

Cell[StyleData["Input", "Presentation"],
  CellFrame->{{2, 2}, {0, 2}},
  CellMargins->{{150, 0}, {0, 8}},
  CellFrameMargins->{{12, 12}, {12, 10}},
  FontSize->27],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->16,
  Background->GrayLevel[0.6]],

Cell[StyleData["Input", "ColorPrintout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["InlineInput", "Presentation"],
  CellMargins->{{10, 8}, {6, 6}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{1, 1}, {1, 0}},
  CellMargins->{{100, 0}, {Inherited, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  FontSize->18,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.0958877, 0.0436561, 0.956359]],

Cell[StyleData["Output", "Presentation"],
  CellFrame->{{2, 2}, {2, 0}},
  CellMargins->{{150, 0}, {6, 0}},
  CellFrameMargins->12,
  FontSize->27],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{50, 0}, {Inherited, 0}},
  FontSize->12,
  Background->GrayLevel[0.4]],

Cell[StyleData["Output", "ColorPrintout"],
  CellMargins->{{50, 0}, {Inherited, 0}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->1,
  CellMargins->{{100, 0}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  FontSize->18,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.187182, 0.813901, 0.186114]],

Cell[StyleData["InputOnly", "Presentation"],
  CellFrame->2,
  CellMargins->{{150, 0}, {4, 6}},
  CellFrameMargins->12,
  FontSize->27],

Cell[StyleData["InputOnly", "Printout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->16,
  Background->GrayLevel[0.6]],

Cell[StyleData["InputOnly", "ColorPrintout"],
  CellMargins->{{50, 0}, {0, Inherited}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellDingbat->"\[LongDash]",
  CellMargins->{{100, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{150, 10}, {2, 2}},
  FontSize->15],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{100, 20}, {3, 3}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{67, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  TextAlignment->Left,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  StyleMenuListing->None,
  Background->RGBColor[0.967727, 0.972747, 0.534508]],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{150, 0}, {6, 8}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{50, 20}, {2, 2}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Print", "ColorPrintout"],
  CellMargins->{{50, 20}, {2, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{100, 0}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[1]],

Cell[StyleData["Graphics", "Presentation"],
  CellFrame->{{2, 2}, {0, 0}},
  CellMargins->{{150, 0}, {0, 0}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{50, 0}, {0, 0}},
  FontSize->10],

Cell[StyleData["Graphics", "ColorPrintout"],
  CellMargins->{{50, 0}, {0, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{100, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[1]],

Cell[StyleData["PictureGroup", "Presentation"],
  CellFrame->{{2, 2}, {0, 0}},
  CellMargins->{{150, 0}, {0, 0}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{50, Inherited}, {0, 0}},
  FontSize->10],

Cell[StyleData["PictureGroup", "ColorPrintout"],
  CellMargins->{{50, Inherited}, {0, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->14],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "ColorPrintout"],
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"],
  FontSize->16],

Cell[StyleData["Hyperlink", "Condensed"],
  FontSize->11],

Cell[StyleData["Hyperlink", "SlideShow"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"],
  FontSize->16],

Cell[StyleData["MainBookLink", "Condensed"],
  FontSize->11],

Cell[StyleData["MainBookLink", "SlideShow"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"],
  FontSize->16],

Cell[StyleData["AddOnsLink", "Condensed"],
  FontSize->11],

Cell[StyleData["AddOnsLink", "SlideShow"]],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLink", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLink", "SlideShow"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLinkText", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLinkText", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLinkText", "SlideShow"]],

Cell[StyleData["RefGuideLinkText", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"],
  FontSize->16],

Cell[StyleData["GettingStartedLink", "Condensed"],
  FontSize->11],

Cell[StyleData["GettingStartedLink", "SlideShow"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "SlideShow"]],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "SlideShow"]],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"],
  FontSize->16],

Cell[StyleData["OtherInformationLink", "Condensed"],
  FontSize->11],

Cell[StyleData["OtherInformationLink", "SlideShow"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "SlideShow"]],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  CellFrameMargins->{{18, 10}, {10, 18}},
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
  CellMargins->{{10, 10}, {10, 12}},
  FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
  CellMargins->{{35, 10}, {5, 10}},
  FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
  CellMargins->{{25, 10}, {10, 5}},
  FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
WindowSize->{500, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 88, "Title"],
Cell[1813, 55, 192, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[2030, 63, 42, 0, 69, "Section"],
Cell[2075, 65, 151, 3, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2229, 70, 156, 3, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[2388, 75, 235, 6, 70, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2626, 83, 104, 2, 70, 32, 0, "StyleData", "All", "Printout"],
Cell[2733, 87, 162, 3, 70, 37, 0, "StyleData", "All", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2932, 95, 35, 0, 39, "Section"],
Cell[2970, 97, 101, 3, 70, "Text"],
Cell[3074, 102, 398, 10, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3509, 117, 38, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[3572, 121, 1685, 40, 70, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[5260, 163, 92, 2, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[5355, 167, 104, 3, 70, 36, 0, "StyleData", "Title", "Printout"],
Cell[5462, 172, 80, 2, 70, 41, 0, "StyleData", "Title", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5579, 179, 1593, 37, 70, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[7175, 218, 96, 2, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[7274, 222, 127, 3, 70, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[7404, 227, 103, 2, 70, 44, 0, "StyleData", "Subtitle", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7544, 234, 1519, 35, 70, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[9066, 271, 98, 2, 70, 46, 0, "StyleData", "Subsubtitle", \
"Presentation"],
Cell[9167, 275, 84, 1, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[9254, 278, 89, 1, 70, 47, 0, "StyleData", "Subsubtitle", \
"ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9380, 284, 1647, 39, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[11030, 325, 94, 2, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[11127, 329, 119, 3, 70, 38, 0, "StyleData", "Section", "Printout"],
Cell[11249, 334, 95, 2, 70, 43, 0, "StyleData", "Section", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11381, 341, 1566, 37, 70, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[12950, 380, 98, 2, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[13051, 384, 93, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[13147, 388, 98, 2, 70, 46, 0, "StyleData", "Subsection", \
"ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13282, 395, 1461, 34, 70, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[14746, 431, 102, 2, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[14851, 435, 103, 2, 70, 44, 0, "StyleData", "Subsubsection", \
"Printout"],
Cell[14957, 439, 108, 2, 70, 49, 0, "StyleData", "Subsubsection", \
"ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15114, 447, 39, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[15178, 451, 1389, 33, 70, 23, 0, "StyleData", "Text", "All"],
Cell[16570, 486, 93, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[16666, 490, 130, 4, 70, 35, 0, "StyleData", "Text", "Printout"],
Cell[16799, 496, 135, 4, 70, 40, 0, "StyleData", "Text", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16971, 505, 1356, 31, 70, 28, 0, "StyleData", "SmallText", "All"],
Cell[18330, 538, 96, 2, 70, 44, 0, "StyleData", "SmallText", "Presentation"],
Cell[18429, 542, 134, 3, 70, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[18566, 547, 139, 3, 70, 45, 0, "StyleData", "SmallText", \
"ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18754, 556, 36, 0, 39, "Section"],
Cell[18793, 558, 121, 3, 50, "Text"],
Cell[18917, 563, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[19012, 568, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[19084, 572, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[19157, 576, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[19275, 582, 116, 4, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[19394, 588, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[19511, 594, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[19630, 600, 233, 6, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[19866, 608, 234, 6, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[20103, 616, 232, 6, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[20338, 624, 234, 6, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[20575, 632, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[20697, 638, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[20820, 644, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[20941, 650, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[21086, 658, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[21227, 665, 149, 5, 31, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[21413, 675, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[21520, 679, 90, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21659, 687, 42, 0, 39, "Section"],
Cell[21704, 689, 248, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[21977, 698, 742, 20, 70, 24, 0, "StyleData", "Input", "All"],
Cell[22722, 720, 164, 4, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[22889, 726, 169, 4, 70, 36, 0, "StyleData", "Input", "Printout"],
Cell[23061, 732, 144, 3, 70, 41, 0, "StyleData", "Input", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23242, 740, 491, 14, 70, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],
Cell[23736, 756, 96, 2, 70, 46, 0, "StyleData", "InlineInput", \
"Presentation"]
}, Closed]],

Cell[CellGroupData[{
Cell[23869, 763, 685, 18, 70, 25, 0, "StyleData", "Output", "All"],
Cell[24557, 783, 147, 4, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[24707, 789, 125, 3, 70, 37, 0, "StyleData", "Output", "Printout"],
Cell[24835, 794, 100, 2, 70, 42, 0, "StyleData", "Output", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24972, 801, 731, 20, 70, 28, 0, "StyleData", "InputOnly", "All"],
Cell[25706, 823, 135, 4, 70, 44, 0, "StyleData", "InputOnly", \
"Presentation"],
Cell[25844, 829, 173, 4, 70, 40, 0, "StyleData", "InputOnly", "Printout"],
Cell[26020, 835, 148, 3, 70, 45, 0, "StyleData", "InputOnly", \
"ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26205, 843, 708, 19, 70, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[26916, 864, 94, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[27013, 868, 96, 1, 70, 38, 0, "StyleData", "Message", "Printout"],
Cell[27112, 871, 101, 1, 70, 43, 0, "StyleData", "Message", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27250, 877, 616, 16, 70, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[27869, 895, 115, 3, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[27987, 900, 122, 3, 70, 36, 0, "StyleData", "Print", "Printout"],
Cell[28112, 905, 92, 2, 70, 41, 0, "StyleData", "Print", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28241, 912, 443, 13, 70, 27, 0, "StyleData", "Graphics", "All",
  StyleMenuListing->None],
Cell[28687, 927, 149, 4, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[28839, 933, 89, 2, 70, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[28931, 937, 94, 2, 70, 44, 0, "StyleData", "Graphics", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29062, 944, 334, 9, 70, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[29399, 955, 153, 4, 70, 47, 0, "StyleData", "PictureGroup", \
"Presentation"],
Cell[29555, 961, 101, 2, 70, 43, 0, "StyleData", "PictureGroup", "Printout"],
Cell[29659, 965, 106, 2, 70, 48, 0, "StyleData", "PictureGroup", \
"ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29802, 972, 128, 4, 70, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[29933, 978, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[29996, 981, 82, 2, 70, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[30081, 985, 60, 1, 70, 45, 0, "StyleData", "CellLabel", "ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30190, 992, 35, 0, 39, "Section"],
Cell[30228, 994, 184, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[30437, 1002, 302, 8, 38, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[30742, 1012, 60, 1, 40, 44, 0, "StyleData", "Hyperlink", \
"Presentation"],
Cell[30805, 1015, 57, 1, 35, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[30865, 1018, 41, 0, 38, 41, 0, "StyleData", "Hyperlink", "SlideShow"],
Cell[30909, 1020, 123, 3, 35, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[31047, 1026, 104, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[31176, 1033, 293, 7, 38, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[31472, 1042, 63, 1, 40, 47, 0, "StyleData", "MainBookLink", \
"Presentation"],
Cell[31538, 1045, 60, 1, 35, 44, 0, "StyleData", "MainBookLink", \
"Condensed"],
Cell[31601, 1048, 44, 0, 38, 44, 0, "StyleData", "MainBookLink", \
"SlideShow"],
Cell[31648, 1050, 126, 3, 35, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31811, 1058, 314, 8, 37, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[32128, 1068, 61, 1, 40, 45, 0, "StyleData", "AddOnsLink", \
"Presentation"],
Cell[32192, 1071, 58, 1, 35, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[32253, 1074, 42, 0, 37, 42, 0, "StyleData", "AddOnsLink", "SlideShow"],
Cell[32298, 1076, 124, 3, 35, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32459, 1084, 318, 8, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[32780, 1094, 63, 1, 40, 47, 0, "StyleData", "RefGuideLink", \
"Presentation"],
Cell[32846, 1097, 60, 1, 35, 44, 0, "StyleData", "RefGuideLink", \
"Condensed"],
Cell[32909, 1100, 44, 0, 37, 44, 0, "StyleData", "RefGuideLink", \
"SlideShow"],
Cell[32956, 1102, 126, 3, 35, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33119, 1110, 297, 7, 38, 35, 0, "StyleData", "RefGuideLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[33419, 1119, 67, 1, 40, 51, 0, "StyleData", "RefGuideLinkText", \
"Presentation"],
Cell[33489, 1122, 64, 1, 35, 48, 0, "StyleData", "RefGuideLinkText", \
"Condensed"],
Cell[33556, 1125, 48, 0, 38, 48, 0, "StyleData", "RefGuideLinkText", \
"SlideShow"],
Cell[33607, 1127, 130, 3, 35, 47, 0, "StyleData", "RefGuideLinkText", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33774, 1135, 305, 7, 38, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34082, 1144, 69, 1, 40, 53, 0, "StyleData", "GettingStartedLink", \
"Presentation"],
Cell[34154, 1147, 66, 1, 35, 50, 0, "StyleData", "GettingStartedLink", \
"Condensed"],
Cell[34223, 1150, 50, 0, 38, 50, 0, "StyleData", "GettingStartedLink", \
"SlideShow"],
Cell[34276, 1152, 132, 3, 35, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34445, 1160, 287, 7, 38, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34735, 1169, 41, 0, 38, 41, 0, "StyleData", "DemosLink", "SlideShow"],
Cell[34779, 1171, 107, 2, 38, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34923, 1178, 285, 7, 38, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35211, 1187, 40, 0, 38, 40, 0, "StyleData", "TourLink", "SlideShow"],
Cell[35254, 1189, 106, 2, 38, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[35397, 1196, 309, 7, 38, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35709, 1205, 71, 1, 40, 55, 0, "StyleData", "OtherInformationLink", \
"Presentation"],
Cell[35783, 1208, 68, 1, 35, 52, 0, "StyleData", "OtherInformationLink", \
"Condensed"],
Cell[35854, 1211, 52, 0, 38, 52, 0, "StyleData", "OtherInformationLink", \
"SlideShow"],
Cell[35909, 1213, 134, 3, 35, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36080, 1221, 299, 7, 38, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[36382, 1230, 47, 0, 38, 47, 0, "StyleData", "MasterIndexLink", \
"SlideShow"],
Cell[36432, 1232, 113, 2, 38, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[36594, 1240, 33, 0, 39, "Section"],
Cell[36630, 1242, 121, 3, 70, "Text"],
Cell[36754, 1247, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[36983, 1254, 304, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[37290, 1263, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[37693, 1274, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[38083, 1285, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[38521, 1299, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[38582, 1303, 709, 21, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[39294, 1326, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[39496, 1333, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39659, 1341, 1681, 40, 70, 35, 0, "StyleData", "SlideShowSection", "All",
  
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[41343, 1383, 109, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[41455, 1387, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[41556, 1391, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[41715, 1399, 327, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[42045, 1411, 102, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[42150, 1415, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[42199, 1417, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42364, 1425, 341, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[42708, 1436, 99, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[42810, 1440, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[42857, 1442, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43004, 1449, 166, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[43173, 1455, 95, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[43271, 1459, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[43330, 1462, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

