(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     47134,       1653]*)
(*NotebookOutlinePosition[     47770,       1675]*)
(*  CellTagsIndexPosition[     47726,       1671]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style. Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Color"->RGBColor[0.4, 0, 0.239994]},
  ScriptMinSize->9,
  Background->RGBColor[1, 0.960006, 0.900008]],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Color"->RGBColor[0.744411, 0.47155, 0.371542]},
  ScriptMinSize->9,
  Background->RGBColor[1, 0.960006, 0.900008]],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  CellBracketOptions->{"Color"->RGBColor[0.744411, 0.47155, 0.371542]},
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ShowCellLabel->False,
  ImageSize->{200, 200},
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{18, 10}, {0, 20}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->6,
  CellFrameColor->GrayLevel[0],
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{0.95, 13},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold",
  FontColor->RGBColor[0.4, 0, 0.239994]],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{28, 10}, {2, 30}},
  CellFrameMargins->{{0, 0}, {0, 12}},
  FontSize->54],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{18, 30}, {0, 0}},
  CellFrameMargins->4,
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{20, 30}, {2, 10}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 4}, {8, 4}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{30, 30}, {4, 16}},
  FontSize->36],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{18, 30}, {0, 10}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section 1"],
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{18, 10}, {10, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 4}, {8, 4}},
  CellFrameColor->RGBColor[0.4, 0, 0.239994],
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section 1", "Presentation"],
  CellFrame->{{0, 0}, {0, 5}},
  CellMargins->{{28, 10}, {16, 44}},
  CellFrameMargins->{{0, 0}, {0, 6}},
  FontSize->27],

Cell[StyleData["Section 1", "Printout"],
  CellMargins->{{18, 30}, {4, 30}},
  CellFrameMargins->4,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{18, 10}, {10, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->4,
  CellFrameColor->RGBColor[0.4, 0, 0.239994],
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
  CellMargins->{{28, 10}, {14, 42}},
  CellFrameMargins->{{0, 0}, {0, 6}},
  FontSize->27],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{38, 30}, {2, 20}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{58, 30}, {6, 34}},
  FontSize->21],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{18, 30}, {0, 10}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{55, 30}, {4, 10}},
  CellGroupingRules->{"SectionGrouping", 60},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{80, 30}, {8, 12}},
  FontSize->18],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{18, 30}, {0, 12}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{55, 10}, {6, 6}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  TextJustification->1,
  LineSpacing->{1, 2},
  FontFamily->"Times"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{80, 10}, {10, 8}},
  FontSize->18],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  Hyphenation->True,
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellMargins->{{55, 10}, {2, 6}},
  TextJustification->1,
  LineSpacing->{1, 2},
  FontFamily->"Helvetica",
  FontSize->10,
  FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["Commentary", "Presentation"],
  CellMargins->{{80, 10}, {2, 10}},
  FontSize->15],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{18, 30}, {3, 0}},
  Hyphenation->True,
  LineSpacing->{1, 3},
  FontFamily->"Times",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{1, 1}, {0, 1}},
  CellMargins->{{55, 10}, {0, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelPositioning->Automatic,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  FontSize->12,
  FontWeight->"Bold",
  Background->GrayLevel[0.966674]],

Cell[StyleData["Input", "Presentation"],
  CellFrame->{{2, 2}, {0, 2}},
  CellMargins->{{80, 18}, {0, 2}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{55, 10}, {0, 10}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->10,
  Background->GrayLevel[0.850004]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["InlineInput", "Presentation"],
  CellMargins->{{10, 18}, {6, 4}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{1, 1}, {1, 0}},
  CellMargins->{{55, 10}, {15, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  FontSize->12,
  Background->GrayLevel[0.850004]],

Cell[StyleData["Output", "Presentation"],
  CellFrame->{{2, 2}, {2, 0}},
  CellMargins->{{80, 18}, {16, 0}},
  CellFrameMargins->{{12, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{55, Inherited}, {10, 0}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->1,
  CellMargins->{{55, 10}, {15, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelPositioning->Automatic,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  FontSize->12,
  FontWeight->"Bold",
  Background->GrayLevel[0.966674]],

Cell[StyleData["InputOnly", "Presentation"],
  CellFrame->2,
  CellMargins->{{80, 18}, {24, 4}},
  CellFrameMargins->{{10, 10}, {12, 12}},
  FontSize->18],

Cell[StyleData["InputOnly", "Printout"],
  CellMargins->{{55, Inherited}, {10, 10}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellFrame->{{1, 1}, {0, 0}},
  CellDingbat->"\[LongDash]",
  CellMargins->{{55, 10}, {0, 0}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[StyleData["Message", "Presentation"],
  CellFrame->{{2, 2}, {0, 0}},
  CellMargins->{{80, 18}, {0, 0}},
  CellFrameMargins->12,
  FontSize->15],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{55, Inherited}, {0, 0}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{55, 26}, {1, 6}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  TextAlignment->Left,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  StyleMenuListing->None,
  Background->GrayLevel[0.700008]],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{80, 42}, {1, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{54, Inherited}, {2, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{55, 10}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[0.850004]],

Cell[StyleData["Graphics", "Presentation"],
  CellFrame->{{2, 2}, {0, 0}},
  CellMargins->{{80, 18}, {0, 0}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{55, Inherited}, {0, 0}},
  ImageSize->{0.0625, 0.0625}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique",
  FontColor->RGBColor[0.6, 0, 0.6]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->15],

Cell[StyleData["CellLabel", "Printout"],
  CellMargins->{{0, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
  CellMargins->{{20, 30}, {45, 5}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 4}, {8, 4}},
  LineSpacing->{1, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Author", "Presentation"],
  CellMargins->{{28, 40}, {68, 8}},
  FontSize->21],

Cell[StyleData["Author", "Printout"],
  CellMargins->{{18, 30}, {45, 5}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Abstract"],
  CellFrame->False,
  CellMargins->{{18, 140}, {4, 30}},
  LineSpacing->{0.9, 0},
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["Abstract", "Presentation"],
  CellMargins->{{28, 180}, {6, 42}},
  FontSize->18],

Cell[StyleData["Abstract", "Printout"],
  Hyphenation->True,
  LineSpacing->{1, 2},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{55, 10}, {5, 3}},
  PageBreakAbove->False,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Presentation"],
  CellMargins->{{80, 18}, {6, 6}},
  FontSize->14],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{55, 55}, {5, 4}},
  Hyphenation->True,
  LineSpacing->{1, 2},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
  CellMargins->{{24, 40}, {6, 6}},
  TextJustification->1,
  LineSpacing->{1, 0},
  FontFamily->"Times"],

Cell[StyleData["Reference", "Presentation"],
  CellMargins->{{38, 40}, {10, 10}},
  FontSize->18],

Cell[StyleData["Reference", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  Hyphenation->True,
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{55, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[0.850004]],

Cell[StyleData["PictureGroup", "Presentation"],
  CellFrame->{{2, 2}, {0, 0}},
  CellMargins->{{80, 6}, {0, 0}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{55, Inherited}, {0, 0}},
  ImageSize->{0.0625, 0.0625}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"],
  FontSize->16],

Cell[StyleData["Hyperlink", "Condensed"],
  FontSize->11],

Cell[StyleData["Hyperlink", "SlideShow"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"],
  FontSize->16],

Cell[StyleData["MainBookLink", "Condensed"],
  FontSize->11],

Cell[StyleData["MainBookLink", "SlideShow"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"],
  FontSize->16],

Cell[StyleData["AddOnsLink", "Condensed"],
  FontSize->11],

Cell[StyleData["AddOnsLink", "SlideShow"]],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLink", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLink", "SlideShow"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLinkText", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLinkText", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLinkText", "SlideShow"]],

Cell[StyleData["RefGuideLinkText", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"],
  FontSize->16],

Cell[StyleData["GettingStartedLink", "Condensed"],
  FontSize->11],

Cell[StyleData["GettingStartedLink", "SlideShow"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "SlideShow"]],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "SlideShow"]],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"],
  FontSize->16],

Cell[StyleData["OtherInformationLink", "Condensed"],
  FontSize->11],

Cell[StyleData["OtherInformationLink", "SlideShow"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "SlideShow"]],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  ScriptLevel->0,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  CellMargins->{{80, 18}, {6, 6}},
  FontSize->18],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{18, 4}, {4, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{55, 10}, {Inherited, 0}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  TextJustification->1,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Presentation"],
  CellMargins->{{80, 18}, {6, 0}},
  FontSize->18],

Cell[StyleData["ChemicalFormula", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{55, 10}, {Inherited, 0}},
  CellHorizontalScrolling->True,
  Hyphenation->False,
  LanguageCategory->"Formula",
  FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
  CellMargins->{{80, 18}, {6, 0}},
  FontSize->18],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{55, 85}, {Inherited, Inherited}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False,
  FontFamily->"Times"],

Cell[StyleData["NumberedEquation", "Presentation"],
  CellMargins->{{80, 125}, {6, 6}},
  FontSize->18],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{55, 95}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}], FontWeight -> "Bold"], None}},
  CounterIncrements->"NumberedFigure",
  FormatTypeAutoConvert->False,
  FontFamily->"Times"],

Cell[StyleData["NumberedFigure", "Presentation"],
  CellMargins->{{80, 145}, {6, 6}},
  FontSize->18],

Cell[StyleData["NumberedFigure", "Printout"],
  CellMargins->{{18, 80}, {4, 4}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{55, 95}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}], FontWeight -> "Bold"], None}},
  TextAlignment->Center,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False,
  FontFamily->"Times"],

Cell[StyleData["NumberedTable", "Presentation"],
  CellMargins->{{80, 145}, {10, 6}},
  FontSize->18],

Cell[StyleData["NumberedTable", "Printout"],
  CellMargins->{{18, 80}, {4, 4}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Header"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Header", "Presentation"],
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageNumber"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"],

Cell[StyleData["PageNumber", "Presentation"],
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Footer"],
  TextAlignment->Center,
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Footer", "Presentation"],
  FontSize->14]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  CellFrameMargins->{{18, 10}, {10, 18}},
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
  CellMargins->{{10, 10}, {10, 12}},
  FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
  CellMargins->{{35, 10}, {5, 10}},
  FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
  CellMargins->{{25, 10}, {10, 5}},
  FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
WindowSize->{501, 607},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 88, "Title"],
Cell[1813, 55, 192, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[2030, 63, 42, 0, 69, "Section"],
Cell[2075, 65, 185, 4, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2263, 71, 201, 4, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[2467, 77, 254, 6, 70, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2724, 85, 153, 4, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2914, 94, 35, 0, 39, "Section"],
Cell[2952, 96, 101, 3, 70, "Text"],
Cell[3056, 101, 426, 11, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3519, 117, 38, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[3582, 121, 1625, 39, 70, 24, 0, "StyleData", "Title", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[5210, 162, 131, 3, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[5344, 167, 110, 3, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5491, 175, 1511, 35, 70, 27, 0, "StyleData", "Subtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[7005, 212, 95, 2, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[7103, 216, 91, 2, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7231, 223, 1616, 38, 70, 28, 0, "StyleData", "Section 1", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[8850, 263, 166, 4, 70, 44, 0, "StyleData", "Section 1", "Presentation"],
Cell[9019, 269, 115, 3, 70, 40, 0, "StyleData", "Section 1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9171, 277, 1602, 38, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[10776, 317, 133, 3, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[10912, 322, 113, 3, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11062, 330, 1515, 36, 70, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[12580, 368, 97, 2, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[12680, 372, 93, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12810, 379, 1480, 35, 70, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[14293, 416, 100, 2, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[14396, 420, 96, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14541, 428, 39, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[14605, 432, 1331, 31, 70, 23, 0, "StyleData", "Text", "All"],
Cell[15939, 465, 91, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[16033, 469, 129, 4, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16199, 478, 188, 6, 70, 29, 0, "StyleData", "Commentary", "All"],
Cell[16390, 486, 97, 2, 70, 45, 0, "StyleData", "Commentary", \
"Presentation"],
Cell[16490, 490, 159, 5, 70, 41, 0, "StyleData", "Commentary", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16698, 501, 36, 0, 39, "Section"],
Cell[16737, 503, 121, 3, 50, "Text"],
Cell[16861, 508, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[16956, 513, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[17028, 517, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[17101, 521, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[17219, 527, 116, 4, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[17338, 533, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[17455, 539, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[17574, 545, 233, 6, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[17810, 553, 234, 6, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[18047, 561, 232, 6, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[18282, 569, 234, 6, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[18519, 577, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[18641, 583, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[18764, 589, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[18885, 595, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[19030, 603, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[19171, 610, 149, 5, 31, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[19357, 620, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[19464, 624, 90, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19603, 632, 42, 0, 39, "Section"],
Cell[19648, 634, 248, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[19921, 643, 723, 20, 70, 24, 0, "StyleData", "Input", "All"],
Cell[20647, 665, 164, 4, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[20814, 671, 168, 4, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21019, 680, 491, 14, 70, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],
Cell[21513, 696, 97, 2, 70, 46, 0, "StyleData", "InlineInput", \
"Presentation"]
}, Closed]],

Cell[CellGroupData[{
Cell[21647, 703, 630, 17, 70, 25, 0, "StyleData", "Output", "All"],
Cell[22280, 722, 166, 4, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[22449, 728, 96, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22582, 735, 713, 20, 70, 28, 0, "StyleData", "InputOnly", "All"],
Cell[23298, 757, 154, 4, 70, 44, 0, "StyleData", "InputOnly", \
"Presentation"],
Cell[23455, 763, 145, 3, 70, 40, 0, "StyleData", "InputOnly", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23637, 771, 743, 21, 70, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[24383, 794, 148, 4, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[24534, 800, 95, 2, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24666, 807, 596, 16, 70, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[25265, 825, 116, 3, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[25384, 830, 94, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25515, 837, 450, 13, 70, 27, 0, "StyleData", "Graphics", "All",
  StyleMenuListing->None],
Cell[25968, 852, 149, 4, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[26120, 858, 112, 2, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26269, 865, 157, 5, 70, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[26429, 872, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[26492, 875, 112, 2, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[26653, 883, 32, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[26710, 887, 329, 9, 70, 25, 0, "StyleData", "Author", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[27042, 898, 93, 2, 70, 41, 0, "StyleData", "Author", "Presentation"],
Cell[27138, 902, 73, 1, 70, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27248, 908, 148, 5, 70, 27, 0, "StyleData", "Abstract", "All"],
Cell[27399, 915, 96, 2, 70, 43, 0, "StyleData", "Abstract", "Presentation"],
Cell[27498, 919, 99, 3, 70, 39, 0, "StyleData", "Abstract", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27634, 927, 128, 4, 70, 26, 0, "StyleData", "Caption", "All"],
Cell[27765, 933, 93, 2, 70, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[27861, 937, 132, 4, 70, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28030, 946, 133, 4, 70, 28, 0, "StyleData", "Reference", "All"],
Cell[28166, 952, 97, 2, 70, 44, 0, "StyleData", "Reference", "Presentation"],
Cell[28266, 956, 110, 3, 70, 40, 0, "StyleData", "Reference", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28413, 964, 340, 9, 70, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[28756, 975, 152, 4, 70, 47, 0, "StyleData", "PictureGroup", \
"Presentation"],
Cell[28911, 981, 116, 2, 70, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29076, 989, 35, 0, 39, "Section"],
Cell[29114, 991, 184, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[29323, 999, 302, 8, 38, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[29628, 1009, 60, 1, 40, 44, 0, "StyleData", "Hyperlink", \
"Presentation"],
Cell[29691, 1012, 57, 1, 35, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[29751, 1015, 41, 0, 38, 41, 0, "StyleData", "Hyperlink", "SlideShow"],
Cell[29795, 1017, 123, 3, 35, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[29933, 1023, 104, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[30062, 1030, 293, 7, 38, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[30358, 1039, 63, 1, 40, 47, 0, "StyleData", "MainBookLink", \
"Presentation"],
Cell[30424, 1042, 60, 1, 35, 44, 0, "StyleData", "MainBookLink", \
"Condensed"],
Cell[30487, 1045, 44, 0, 38, 44, 0, "StyleData", "MainBookLink", \
"SlideShow"],
Cell[30534, 1047, 126, 3, 35, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30697, 1055, 314, 8, 37, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[31014, 1065, 61, 1, 40, 45, 0, "StyleData", "AddOnsLink", \
"Presentation"],
Cell[31078, 1068, 58, 1, 35, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[31139, 1071, 42, 0, 37, 42, 0, "StyleData", "AddOnsLink", "SlideShow"],
Cell[31184, 1073, 124, 3, 35, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31345, 1081, 318, 8, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[31666, 1091, 63, 1, 40, 47, 0, "StyleData", "RefGuideLink", \
"Presentation"],
Cell[31732, 1094, 60, 1, 35, 44, 0, "StyleData", "RefGuideLink", \
"Condensed"],
Cell[31795, 1097, 44, 0, 37, 44, 0, "StyleData", "RefGuideLink", \
"SlideShow"],
Cell[31842, 1099, 126, 3, 35, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32005, 1107, 297, 7, 38, 35, 0, "StyleData", "RefGuideLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[32305, 1116, 67, 1, 40, 51, 0, "StyleData", "RefGuideLinkText", \
"Presentation"],
Cell[32375, 1119, 64, 1, 35, 48, 0, "StyleData", "RefGuideLinkText", \
"Condensed"],
Cell[32442, 1122, 48, 0, 38, 48, 0, "StyleData", "RefGuideLinkText", \
"SlideShow"],
Cell[32493, 1124, 130, 3, 35, 47, 0, "StyleData", "RefGuideLinkText", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32660, 1132, 305, 7, 38, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[32968, 1141, 69, 1, 40, 53, 0, "StyleData", "GettingStartedLink", \
"Presentation"],
Cell[33040, 1144, 66, 1, 35, 50, 0, "StyleData", "GettingStartedLink", \
"Condensed"],
Cell[33109, 1147, 50, 0, 38, 50, 0, "StyleData", "GettingStartedLink", \
"SlideShow"],
Cell[33162, 1149, 132, 3, 35, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33331, 1157, 287, 7, 38, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[33621, 1166, 41, 0, 38, 41, 0, "StyleData", "DemosLink", "SlideShow"],
Cell[33665, 1168, 107, 2, 38, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33809, 1175, 285, 7, 38, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34097, 1184, 40, 0, 38, 40, 0, "StyleData", "TourLink", "SlideShow"],
Cell[34140, 1186, 106, 2, 38, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34283, 1193, 309, 7, 38, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[34595, 1202, 71, 1, 40, 55, 0, "StyleData", "OtherInformationLink", \
"Presentation"],
Cell[34669, 1205, 68, 1, 35, 52, 0, "StyleData", "OtherInformationLink", \
"Condensed"],
Cell[34740, 1208, 52, 0, 38, 52, 0, "StyleData", "OtherInformationLink", \
"SlideShow"],
Cell[34795, 1210, 134, 3, 35, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34966, 1218, 299, 7, 38, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35268, 1227, 47, 0, 38, 47, 0, "StyleData", "MasterIndexLink", \
"SlideShow"],
Cell[35318, 1229, 113, 2, 38, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35480, 1237, 33, 0, 39, "Section"],
Cell[35516, 1239, 121, 3, 70, "Text"],
Cell[35640, 1244, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35869, 1251, 304, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[36176, 1260, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[36579, 1271, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[36969, 1282, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[37407, 1296, 43, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[37475, 1300, 445, 10, 70, 33, 0, "StyleData", "DisplayFormula", "All",
  StyleMenuListing->None],
Cell[37923, 1312, 100, 2, 70, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[38026, 1316, 79, 1, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38142, 1322, 462, 12, 70, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[38607, 1336, 101, 2, 70, 50, 0, "StyleData", "ChemicalFormula", \
"Presentation"],
Cell[38711, 1340, 119, 3, 70, 46, 0, "StyleData", "ChemicalFormula", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38867, 1348, 180, 5, 70, 26, 0, "StyleData", "Program", "All"],
Cell[39050, 1355, 93, 2, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[39146, 1359, 112, 3, 70, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39307, 1368, 49, 0, 39, "Section"],
Cell[39359, 1370, 225, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[39609, 1378, 473, 10, 70, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[40085, 1390, 103, 2, 70, 51, 0, "StyleData", "NumberedEquation", \
"Presentation"],
Cell[40191, 1394, 96, 2, 70, 47, 0, "StyleData", "NumberedEquation", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40324, 1401, 329, 7, 70, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[40656, 1410, 101, 2, 70, 49, 0, "StyleData", "NumberedFigure", \
"Presentation"],
Cell[40760, 1414, 95, 2, 70, 45, 0, "StyleData", "NumberedFigure", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40892, 1421, 350, 8, 70, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[41245, 1431, 101, 2, 70, 48, 0, "StyleData", "NumberedTable", \
"Presentation"],
Cell[41349, 1435, 94, 2, 70, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[41492, 1443, 49, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[41566, 1447, 93, 3, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[41662, 1452, 57, 1, 70, 41, 0, "StyleData", "Header", "Presentation"]
}, Closed]],

Cell[CellGroupData[{
Cell[41756, 1458, 119, 4, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None],
Cell[41878, 1464, 61, 1, 70, 45, 0, "StyleData", "PageNumber", \
"Presentation"]
}, Closed]],

Cell[CellGroupData[{
Cell[41976, 1470, 118, 4, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[42097, 1476, 57, 1, 70, 41, 0, "StyleData", "Footer", "Presentation"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[42203, 1483, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[42264, 1487, 709, 21, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[42976, 1510, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[43178, 1517, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43341, 1525, 1681, 40, 70, 35, 0, "StyleData", "SlideShowSection", "All",
  
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[45025, 1567, 109, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[45137, 1571, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[45238, 1575, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[45397, 1583, 327, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[45727, 1595, 102, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[45832, 1599, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[45881, 1601, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[46046, 1609, 341, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[46390, 1620, 99, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[46492, 1624, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[46539, 1626, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[46686, 1633, 166, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[46855, 1639, 95, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[46953, 1643, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[47012, 1646, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

