(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     47796,       1700]*)
(*NotebookOutlinePosition[     48432,       1722]*)
(*  CellTagsIndexPosition[     48388,       1718]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->RGBColor[0, 0.2, 1]},
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  CellBracketOptions->{"Color"->RGBColor[0, 0.2, 1]},
  ScriptMinSize->9],

Cell[StyleData[All, "SlideShow"],
  PageWidth->WindowWidth,
  ScrollingOptions->{"PagewiseDisplay"->True,
  "VerticalScrollRange"->Fit},
  ShowCellBracket->False,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            OptionValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            OptionValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellLabelAutoDelete->False,
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{12, Inherited}, {2, 20}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 11},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->30,
  FontWeight->"Bold"],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{20, 18}, {4, 32}},
  FontSize->45],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{2, 10}, {2, 30}},
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{12, Inherited}, {2, 2}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{20, 18}, {4, 4}},
  FontSize->36],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {2, 4}},
  FontSize->18,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{12, Inherited}, {2, 12}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 0.6]],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{20, 18}, {4, 18}},
  FontSize->21],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {2, 8}},
  FontSize->12,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {2, 0}},
  CellMargins->{{10, 4}, {2, 50}},
  CellElementSpacings->{"ClosedGroupTopMargin"->18},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
  CellFrame->{{0, 0}, {3, 0}},
  CellMargins->{{18, 6}, {4, 74}},
  CellFrameMargins->{{0, 0}, {12, 0}},
  FontSize->27],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{2, 4}, {2, 80}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{24, 4}, {2, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->12},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  LineSpacing->{1, 5},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->15,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{38, 6}, {4, 28}},
  FontSize->23],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{2, 4}, {2, 18}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{10, 4}, {2, 18}},
  CellElementSpacings->{"ClosedGroupTopMargin"->12},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{20, 6}, {6, 26}},
  FontSize->18],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{2, 4}, {2, 18}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{10, 4}, {0, 8}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{20, 8}, {4, 10}},
  FontSize->18],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  Hyphenation->True,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
  CellFrame->{{4, 0}, {0, 0}},
  CellMargins->{{47, 62}, {0, 14}},
  CellFrameMargins->5,
  CellFrameColor->RGBColor[0, 0.2, 1],
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8},
  FontColor->RGBColor[0, 0, 0.6]],

Cell[StyleData["MathCaption", "Presentation"],
  CellFrame->{{6, 0}, {0, 0}},
  CellMargins->{{76, 72}, {2, 16}},
  CellFrameMargins->{{10, 0}, {0, 0}},
  FontSize->18],

Cell[StyleData["MathCaption", "Printout"],
  CellMargins->{{34, 62}, {0, 14}},
  CellFrameColor->GrayLevel[0.700008],
  Hyphenation->True,
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
  StyleMenuListing->None,
  Background->RGBColor[0.870588, 0.905882, 0.972549]],

Cell[StyleData["Inert", "Printout"],
  StyleMenuListing->None,
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{56, 4}, {3, 9}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->StandardForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{92, 8}, {4, 12}},
  FontSize->18],

Cell[StyleData["Input", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {3, 8}},
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{57, 4}, {5, 2}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  LanguageCategory->"Formula",
  FormatType->StandardForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{92, 8}, {8, 4}},
  FontSize->18],

Cell[StyleData["Output", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {4, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{56, 4}, {3, 8}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0.2, 1]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{92, 8}, {8, 10}},
  FontSize->18],

Cell[StyleData["Message", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {4, 2}},
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{56, 4}, {3, 8}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{92, 8}, {6, 10}},
  FontSize->18],

Cell[StyleData["Print", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{42, 4}, {4, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{56, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  CellMargins->{{92, 8}, {4, 4}},
  FontSize->18],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{40, 4}, {4, 2}},
  ImageSize->{250, 250},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0.2, 1]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->14],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->7,
  FontSlant->"Oblique",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["TextTop"],
  CellFrame->{{0, 0}, {0, 2}},
  CellMargins->{{10, 4}, {2, 80}},
  CellHorizontalScrolling->True,
  CellFrameMargins->4,
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text"],

Cell[StyleData["TextTop", "Presentation"],
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{20, 8}, {4, 124}},
  FontSize->18],

Cell[StyleData["TextTop", "Printout"],
  CellMargins->{{2, 4}, {2, 80}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedText"],
  CellMargins->{{20, 4}, {0, 8}},
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  ParagraphIndent->-15,
  CounterIncrements->"Text"],

Cell[StyleData["ItemizedText", "Presentation"],
  CellMargins->{{36, 8}, {0, 14}},
  FontSize->18],

Cell[StyleData["ItemizedText", "Printout"],
  Hyphenation->True,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote"],
  CellMargins->{{35, 4}, {0, 4}},
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 4},
  CounterIncrements->"Text"],

Cell[StyleData["ItemizedTextNote", "Presentation"],
  CellMargins->{{56, 8}, {0, 6}},
  FontSize->18],

Cell[StyleData["ItemizedTextNote", "Printout"],
  Hyphenation->True,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
  CellMargins->{{20, 4}, {0, 6}},
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text"],

Cell[StyleData["IndentedText", "Presentation"],
  CellMargins->{{36, 8}, {0, 8}},
  FontSize->18],

Cell[StyleData["IndentedText", "Printout"],
  Hyphenation->True,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Note"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ShowSpecialCharacters->Automatic,
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text",
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["Note", "Presentation"],
  CellMargins->{{16, 8}, {2, 12}},
  CellFrameMargins->12,
  FontSize->15],

Cell[StyleData["Note", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["1ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1}],

Cell[StyleData["1ColumnBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["1ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.39, 0.59}}],

Cell[StyleData["2ColumnBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["2ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnSmallBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.35,
  ColumnAlignments->{Right, Left}}],

Cell[StyleData["2ColumnSmallBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["2ColumnSmallBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->0.325}],

Cell[StyleData["3ColumnBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["3ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnSmallBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnSpacings->1.5,
  ColumnWidths->0.23,
  ColumnAlignments->{Right, Center, Left}}],

Cell[StyleData["3ColumnSmallBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["3ColumnSmallBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.145, 0.345, 0.145, 0.345}}],

Cell[StyleData["4ColumnBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["4ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->0.195}],

Cell[StyleData["5ColumnBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["5ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnBox"],
  CellFrame->True,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  LineIndent->0,
  Background->GrayLevel[0.8],
  FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
  GridBoxOptions->{ColumnWidths->{0.13, 0.23, 0.13, 0.13, 0.23, 0.13}}],

Cell[StyleData["6ColumnBox", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  CellFrameMargins->12,
  FontSize->18],

Cell[StyleData["6ColumnBox", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
  CellMargins->{{10, Inherited}, {0, 8}},
  CellHorizontalScrolling->True],

Cell[StyleData["Picture", "Presentation"],
  CellMargins->{{16, 8}, {0, 10}},
  FontSize->18],

Cell[StyleData["Picture", "Printout"],
  CellMargins->{{2, Inherited}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{10, 50}, {0, 3}},
  PageBreakAbove->False,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Presentation"],
  CellMargins->{{16, 65}, {0, 4}},
  FontSize->14],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{2, 50}, {2, 4}},
  Hyphenation->True,
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Section"],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  GridBoxOptions->{ColumnWidths->{0.39, 0.59},
  ColumnAlignments->{Left}}],

Cell[StyleData["2ColumnTable", "Presentation"],
  CellMargins->{{16, 8}, {2, 14}},
  FontSize->18],

Cell[StyleData["2ColumnTable", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.325,
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnTable", "Presentation"],
  CellMargins->{{16, 8}, {2, 10}},
  FontSize->18],

Cell[StyleData["3ColumnTable", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Presentation"],
  CellMargins->{{64, 30}, {2, 4}},
  FontSize->18],

Cell[StyleData["ChemicalFormula", "Printout"],
  CellMargins->{{34, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  "TwoByteSyntaxCharacterAutoReplacement"->True,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  ScriptLevel->0,
  SingleLetterItalics->True,
  SpanMaxSize->Infinity,
  UnderoverscriptBoxOptions->{LimitsPositioning->True},
  GridBoxOptions->{ColumnWidths->Automatic}],

Cell[StyleData["DisplayFormula", "Presentation"],
  CellMargins->{{64, 30}, {4, 8}},
  FontSize->18],

Cell[StyleData["DisplayFormula", "Printout"],
  CellMargins->{{34, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  Hyphenation->False,
  LanguageCategory->"Formula",
  FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
  CellMargins->{{16, 8}, {0, 14}},
  FontSize->18],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{2, Inherited}, {Inherited, Inherited}},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonFrame->"None",
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"],
  FontSize->16],

Cell[StyleData["Hyperlink", "Condensed"],
  FontSize->11],

Cell[StyleData["Hyperlink", "SlideShow"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"],
  FontSize->16],

Cell[StyleData["MainBookLink", "Condensed"],
  FontSize->11],

Cell[StyleData["MainBookLink", "SlideShow"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"],
  FontSize->16],

Cell[StyleData["AddOnsLink", "Condensed"],
  FontSize->11],

Cell[StyleData["AddOnsLink", "SlideShow"]],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLink", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLink", "SlideShow"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLinkText", "Presentation"],
  FontSize->16],

Cell[StyleData["RefGuideLinkText", "Condensed"],
  FontSize->11],

Cell[StyleData["RefGuideLinkText", "SlideShow"]],

Cell[StyleData["RefGuideLinkText", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"],
  FontSize->16],

Cell[StyleData["GettingStartedLink", "Condensed"],
  FontSize->11],

Cell[StyleData["GettingStartedLink", "SlideShow"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["DemosLink", "SlideShow"]],

Cell[StyleData["DemosLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["TourLink", "SlideShow"]],

Cell[StyleData["TourLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"],
  FontSize->16],

Cell[StyleData["OtherInformationLink", "Condensed"],
  FontSize->11],

Cell[StyleData["OtherInformationLink", "SlideShow"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.269993, 0.308507, 0.6],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MasterIndexLink", "SlideShow"]],

Cell[StyleData["MasterIndexLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
  Editable->False,
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellElementSpacings->{"CellMinHeight"->0.8125},
  CellGroupingRules->{"SectionGrouping", 30},
  CellFrameMargins->False,
  CellFrameColor->GrayLevel[1],
  CellFrameLabelMargins->False,
  TextAlignment->Center,
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None,
  FontSize->10,
  Background->GrayLevel[0.8],
  Magnification->1,
  GridBoxOptions->{GridBaseline->Center,
  RowSpacings->0,
  ColumnSpacings->0,
  ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
  RowAlignments->Baseline,
  ColumnAlignments->{
    Center, Center, Center, Center, Center, Center, Right, Center}}],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
  Deletable->False,
  ShowCellBracket->False,
  CellMargins->{{-1, -1}, {-1, -1}},
  PageBreakAbove->True,
  CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
  CellMargins->{{18, 4}, {4, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{0, 0}, {10, 0}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{12, 4}, {6, 12}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
              FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
      "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
      "gridMathematica"->FormBox[ 
          RowBox[ {"grid", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
      "webMathematica"->FormBox[ 
          RowBox[ {"web", 
            AdjustmentBox[ 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], TextForm],
       Inherited},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Plain",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
  CellFrameMargins->{{18, 10}, {10, 18}},
  FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
  ShowCellBracket->False,
  PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
  CellMargins->{{18, 30}, {0, 30}},
  CellFrameMargins->5,
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontSize->26,
  FontColor->GrayLevel[0.400015],
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMinHeight->0.85,
  ButtonMargins->0.5,
  ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
  CellMargins->{{10, 10}, {10, 12}},
  FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
  CellMargins->{{24, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Helvetica",
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonMargins->1.5,
  ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
  CellMargins->{{35, 10}, {5, 10}},
  FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
  CellMargins->{{25, 10}, {10, 5}},
  FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
  FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
WindowSize->{493, 514},
WindowMargins->{{2, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 88, "Title"],
Cell[1813, 55, 193, 4, 68, "Text"],

Cell[CellGroupData[{
Cell[2031, 63, 42, 0, 69, "Section"],
Cell[2076, 65, 105, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2184, 69, 110, 2, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[2297, 73, 182, 5, 70, 33, 0, "StyleData", "All", "SlideShow"],
Cell[2482, 80, 104, 2, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2623, 87, 35, 0, 39, "Section"],
Cell[2661, 89, 105, 3, 70, "Text"],
Cell[2769, 94, 538, 14, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3344, 113, 27, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[3396, 117, 1573, 37, 70, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[4972, 156, 92, 2, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[5067, 160, 87, 2, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5191, 167, 1550, 36, 70, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[6744, 205, 94, 2, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[6841, 209, 116, 3, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6994, 217, 1553, 36, 70, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[8550, 255, 98, 2, 70, 46, 0, "StyleData", "Subsubtitle", \
"Presentation"],
Cell[8651, 259, 119, 3, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8807, 267, 1581, 37, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[10391, 306, 163, 4, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[10557, 312, 88, 2, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10682, 319, 1622, 39, 70, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[12307, 360, 96, 2, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[12406, 364, 91, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12534, 371, 1481, 34, 70, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[14018, 407, 99, 2, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[14120, 411, 94, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14263, 419, 23, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[14311, 423, 1317, 30, 70, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[15631, 455, 90, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[15724, 459, 105, 3, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15866, 467, 244, 7, 70, 30, 0, "StyleData", "MathCaption", "All"],
Cell[16113, 476, 168, 4, 70, 46, 0, "StyleData", "MathCaption", \
"Presentation"],
Cell[16284, 482, 181, 5, 70, 42, 0, "StyleData", "MathCaption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16514, 493, 36, 0, 39, "Section"],
Cell[16553, 495, 121, 3, 50, "Text"],
Cell[16677, 500, 92, 3, 38, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[16772, 505, 69, 2, 38, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[16844, 509, 70, 2, 38, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[16917, 513, 115, 4, 38, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[17035, 519, 116, 4, 38, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[17154, 525, 114, 4, 38, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[17271, 531, 116, 4, 38, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[17390, 537, 233, 6, 37, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[17626, 545, 234, 6, 37, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[17863, 553, 232, 6, 37, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[18098, 561, 234, 6, 37, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[18335, 569, 119, 4, 38, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[18457, 575, 120, 4, 38, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[18580, 581, 118, 4, 38, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[18701, 587, 120, 4, 38, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[18846, 595, 138, 5, 35, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[18987, 602, 149, 5, 31, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[19173, 612, 104, 2, 54, 24, 0, "StyleData", "Inert", "All",
  StyleMenuListing->None],
Cell[19280, 616, 90, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19419, 624, 31, 0, 39, "Section"],
Cell[19453, 626, 252, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[19730, 635, 628, 17, 70, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[20361, 654, 91, 2, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[20455, 658, 157, 4, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20649, 667, 570, 15, 70, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[21222, 684, 91, 2, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[21316, 688, 113, 3, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21466, 696, 648, 17, 70, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[22117, 715, 93, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[22213, 719, 141, 4, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22391, 728, 557, 15, 70, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[22951, 745, 91, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[23045, 749, 112, 3, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23194, 757, 389, 11, 70, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[23586, 770, 93, 2, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[23682, 774, 113, 3, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23832, 782, 130, 4, 70, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[23965, 788, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[24028, 791, 106, 3, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24183, 800, 32, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[24240, 804, 241, 7, 70, 26, 0, "StyleData", "TextTop", "All",
  CounterIncrements->"Text"],
Cell[24484, 813, 125, 3, 70, 42, 0, "StyleData", "TextTop", "Presentation"],
Cell[24612, 818, 88, 2, 70, 38, 0, "StyleData", "TextTop", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24737, 825, 182, 5, 70, 31, 0, "StyleData", "ItemizedText", "All",
  CounterIncrements->"Text"],
Cell[24922, 832, 98, 2, 70, 47, 0, "StyleData", "ItemizedText", \
"Presentation"],
Cell[25023, 836, 80, 2, 70, 43, 0, "StyleData", "ItemizedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25140, 843, 162, 4, 70, 35, 0, "StyleData", "ItemizedTextNote", "All",
  CounterIncrements->"Text"],
Cell[25305, 849, 101, 2, 70, 51, 0, "StyleData", "ItemizedTextNote", \
"Presentation"],
Cell[25409, 853, 84, 2, 70, 47, 0, "StyleData", "ItemizedTextNote", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25530, 860, 158, 4, 70, 31, 0, "StyleData", "IndentedText", "All",
  CounterIncrements->"Text"],
Cell[25691, 866, 97, 2, 70, 47, 0, "StyleData", "IndentedText", \
"Presentation"],
Cell[25791, 870, 80, 2, 70, 43, 0, "StyleData", "IndentedText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[25908, 877, 245, 8, 70, 23, 0, "StyleData", "Note", "All",
  CounterIncrements->"Text"],
Cell[26156, 887, 114, 3, 70, 39, 0, "StyleData", "Note", "Presentation"],
Cell[26273, 892, 83, 2, 70, 35, 0, "StyleData", "Note", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26393, 899, 256, 7, 70, 29, 0, "StyleData", "1ColumnBox", "All"],
Cell[26652, 908, 120, 3, 70, 45, 0, "StyleData", "1ColumnBox", \
"Presentation"],
Cell[26775, 913, 125, 3, 70, 41, 0, "StyleData", "1ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26937, 921, 265, 7, 70, 29, 0, "StyleData", "2ColumnBox", "All"],
Cell[27205, 930, 120, 3, 70, 45, 0, "StyleData", "2ColumnBox", \
"Presentation"],
Cell[27328, 935, 125, 3, 70, 41, 0, "StyleData", "2ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[27490, 943, 320, 9, 70, 34, 0, "StyleData", "2ColumnSmallBox", "All"],
Cell[27813, 954, 125, 3, 70, 50, 0, "StyleData", "2ColumnSmallBox", \
"Presentation"],
Cell[27941, 959, 130, 3, 70, 46, 0, "StyleData", "2ColumnSmallBox", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28108, 967, 258, 7, 70, 29, 0, "StyleData", "3ColumnBox", "All"],
Cell[28369, 976, 120, 3, 70, 45, 0, "StyleData", "3ColumnBox", \
"Presentation"],
Cell[28492, 981, 125, 3, 70, 41, 0, "StyleData", "3ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28654, 989, 328, 9, 70, 34, 0, "StyleData", "3ColumnSmallBox", "All"],
Cell[28985, 1000, 125, 3, 70, 50, 0, "StyleData", "3ColumnSmallBox", \
"Presentation"],
Cell[29113, 1005, 130, 3, 70, 46, 0, "StyleData", "3ColumnSmallBox", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29280, 1013, 281, 7, 70, 29, 0, "StyleData", "4ColumnBox", "All"],
Cell[29564, 1022, 120, 3, 70, 45, 0, "StyleData", "4ColumnBox", \
"Presentation"],
Cell[29687, 1027, 125, 3, 70, 41, 0, "StyleData", "4ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[29849, 1035, 258, 7, 70, 29, 0, "StyleData", "5ColumnBox", "All"],
Cell[30110, 1044, 120, 3, 70, 45, 0, "StyleData", "5ColumnBox", \
"Presentation"],
Cell[30233, 1049, 125, 3, 70, 41, 0, "StyleData", "5ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30395, 1057, 289, 7, 70, 29, 0, "StyleData", "6ColumnBox", "All"],
Cell[30687, 1066, 120, 3, 70, 45, 0, "StyleData", "6ColumnBox", \
"Presentation"],
Cell[30810, 1071, 125, 3, 70, 41, 0, "StyleData", "6ColumnBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[30972, 1079, 101, 2, 70, 26, 0, "StyleData", "Picture", "All"],
Cell[31076, 1083, 93, 2, 70, 42, 0, "StyleData", "Picture", "Presentation"],
Cell[31172, 1087, 79, 1, 70, 38, 0, "StyleData", "Picture", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[31288, 1093, 128, 4, 70, 26, 0, "StyleData", "Caption", "All"],
Cell[31419, 1099, 93, 2, 70, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[31515, 1103, 108, 3, 70, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[31672, 1112, 25, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[31722, 1116, 174, 4, 70, 31, 0, "StyleData", "2ColumnTable", "All"],
Cell[31899, 1122, 98, 2, 70, 47, 0, "StyleData", "2ColumnTable", \
"Presentation"],
Cell[32000, 1126, 92, 2, 70, 43, 0, "StyleData", "2ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[32129, 1133, 193, 5, 70, 31, 0, "StyleData", "3ColumnTable", "All",
  StyleMenuListing->None],
Cell[32325, 1140, 98, 2, 70, 47, 0, "StyleData", "3ColumnTable", \
"Presentation"],
Cell[32426, 1144, 92, 2, 70, 43, 0, "StyleData", "3ColumnTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[32567, 1152, 43, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[32635, 1156, 453, 11, 70, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[33091, 1169, 101, 2, 70, 50, 0, "StyleData", "ChemicalFormula", \
"Presentation"],
Cell[33195, 1173, 120, 2, 70, 46, 0, "StyleData", "ChemicalFormula", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[33352, 1180, 489, 11, 70, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[33844, 1193, 100, 2, 70, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[33947, 1197, 119, 2, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[34103, 1204, 171, 5, 70, 26, 0, "StyleData", "Program", "All"],
Cell[34277, 1211, 93, 2, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[34373, 1215, 112, 2, 70, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[34534, 1223, 35, 0, 39, "Section"],
Cell[34572, 1225, 184, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[34781, 1233, 302, 8, 38, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35086, 1243, 60, 1, 40, 44, 0, "StyleData", "Hyperlink", \
"Presentation"],
Cell[35149, 1246, 57, 1, 35, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[35209, 1249, 41, 0, 38, 41, 0, "StyleData", "Hyperlink", "SlideShow"],
Cell[35253, 1251, 123, 3, 35, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[35391, 1257, 104, 3, 29, "Text"],

Cell[CellGroupData[{
Cell[35520, 1264, 293, 7, 38, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[35816, 1273, 63, 1, 40, 47, 0, "StyleData", "MainBookLink", \
"Presentation"],
Cell[35882, 1276, 60, 1, 35, 44, 0, "StyleData", "MainBookLink", \
"Condensed"],
Cell[35945, 1279, 44, 0, 38, 44, 0, "StyleData", "MainBookLink", \
"SlideShow"],
Cell[35992, 1281, 126, 3, 35, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36155, 1289, 314, 8, 37, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[36472, 1299, 61, 1, 40, 45, 0, "StyleData", "AddOnsLink", \
"Presentation"],
Cell[36536, 1302, 58, 1, 35, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[36597, 1305, 42, 0, 37, 42, 0, "StyleData", "AddOnsLink", "SlideShow"],
Cell[36642, 1307, 124, 3, 35, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36803, 1315, 318, 8, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[37124, 1325, 63, 1, 40, 47, 0, "StyleData", "RefGuideLink", \
"Presentation"],
Cell[37190, 1328, 60, 1, 35, 44, 0, "StyleData", "RefGuideLink", \
"Condensed"],
Cell[37253, 1331, 44, 0, 37, 44, 0, "StyleData", "RefGuideLink", \
"SlideShow"],
Cell[37300, 1333, 126, 3, 35, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37463, 1341, 297, 7, 38, 35, 0, "StyleData", "RefGuideLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[37763, 1350, 67, 1, 40, 51, 0, "StyleData", "RefGuideLinkText", \
"Presentation"],
Cell[37833, 1353, 64, 1, 35, 48, 0, "StyleData", "RefGuideLinkText", \
"Condensed"],
Cell[37900, 1356, 48, 0, 38, 48, 0, "StyleData", "RefGuideLinkText", \
"SlideShow"],
Cell[37951, 1358, 130, 3, 35, 47, 0, "StyleData", "RefGuideLinkText", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38118, 1366, 305, 7, 38, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[38426, 1375, 69, 1, 40, 53, 0, "StyleData", "GettingStartedLink", \
"Presentation"],
Cell[38498, 1378, 66, 1, 35, 50, 0, "StyleData", "GettingStartedLink", \
"Condensed"],
Cell[38567, 1381, 50, 0, 38, 50, 0, "StyleData", "GettingStartedLink", \
"SlideShow"],
Cell[38620, 1383, 132, 3, 35, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38789, 1391, 287, 7, 38, 28, 0, "StyleData", "DemosLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[39079, 1400, 41, 0, 38, 41, 0, "StyleData", "DemosLink", "SlideShow"],
Cell[39123, 1402, 107, 2, 38, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39267, 1409, 285, 7, 38, 27, 0, "StyleData", "TourLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[39555, 1418, 40, 0, 38, 40, 0, "StyleData", "TourLink", "SlideShow"],
Cell[39598, 1420, 106, 2, 38, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39741, 1427, 309, 7, 38, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[40053, 1436, 71, 1, 40, 55, 0, "StyleData", "OtherInformationLink", \
"Presentation"],
Cell[40127, 1439, 68, 1, 35, 52, 0, "StyleData", "OtherInformationLink", \
"Condensed"],
Cell[40198, 1442, 52, 0, 38, 52, 0, "StyleData", "OtherInformationLink", \
"SlideShow"],
Cell[40253, 1444, 134, 3, 35, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[40424, 1452, 299, 7, 38, 34, 0, "StyleData", "MasterIndexLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[40726, 1461, 47, 0, 38, 47, 0, "StyleData", "MasterIndexLink", \
"SlideShow"],
Cell[40776, 1463, 113, 2, 38, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[40938, 1471, 33, 0, 39, "Section"],
Cell[40974, 1473, 121, 3, 70, "Text"],
Cell[41098, 1478, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[41327, 1485, 304, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[41634, 1494, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[42037, 1505, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[42427, 1516, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[42865, 1530, 36, 0, 39, "Section"],

Cell[CellGroupData[{
Cell[42926, 1534, 709, 21, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
  CounterIncrements->"SlideShowNavigationBar",
  StyleMenuListing->None],
Cell[43638, 1557, 199, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[43840, 1564, 126, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[44003, 1572, 1681, 40, 70, 35, 0, "StyleData", "SlideShowSection", "All",
  
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  StyleMenuListing->None],
Cell[45687, 1614, 109, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[45799, 1618, 98, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[45900, 1622, 122, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[46059, 1630, 327, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[46389, 1642, 102, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[46494, 1646, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[46543, 1648, 128, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[46708, 1656, 341, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[47052, 1667, 99, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[47154, 1671, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[47201, 1673, 110, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[47348, 1680, 166, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
  StyleMenuListing->None],
Cell[47517, 1686, 95, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[47615, 1690, 56, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[47674, 1693, 82, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

