(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     81915,       3510]*)
(*NotebookOutlinePosition[    116707,       4438]*)
(*  CellTagsIndexPosition[    112823,       4328]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer Guide"
}], "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[CellGroupData[{

Cell["Windows", "Subsubsection"],

Cell[TextData[{
  "addtwo",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"addtwo"],

Cell[TextData[{
  "running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"addtwo"],

Cell[TextData[{
  "API",
  ", changes to ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "changes"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"API"],

Cell[TextData[{
  "ASCII, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ASCII"],

Cell[TextData[{
  "Borland C/C++ ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "Borland"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Borland C/C++"],

Cell[TextData[{
  "building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with ",
  ButtonBox["Building",
    ButtonData:>{"Building", "Borland"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Borland C/C++"],

Cell[TextData[{
  "installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components for ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Borland"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Borland C/C++"],

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Building MathLink programs"],

Cell[TextData[{
  "Calling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from external programs, running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Calling Mathematica from external programs"],

Cell[TextData[{
  "C Compilers, compiling ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"C Compilers"],

Cell[TextData[{
  "supported by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"C Compilers"],

Cell[TextData[{
  "C source code, ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "sample code"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"C source code"],

Cell[TextData[{
  "Character codes, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Character codes"],

Cell[TextData[{
  "Character encoding, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Character encoding"],

Cell[TextData[{
  "Child processes",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Child processes"],

Cell[TextData[{
  "CodeWarrior ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "CodeWarrior"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CodeWarrior"],

Cell[TextData[{
  "building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with ",
  ButtonBox["Building",
    ButtonData:>{"Building", "CodeWarrior"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"CodeWarrior"],

Cell[TextData[{
  "installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components for ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "CodeWarrior"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"CodeWarrior"],

Cell[TextData[{
  "Compatibility, of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " with Version 2 ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "changes"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Compatibility"],

Cell[TextData[{
  "Compiling ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Compiling MathLink programs"],

Cell[TextData[{
  "Console programs",
  ", building factor ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Console programs"],

Cell[TextData[{
  "running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Console programs"],

Cell[TextData[{
  "Developer kits, ",
  StyleBox["MathLink,",
    FontSlant->"Italic"],
  " parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Developer kits, MathLink"],

Cell[TextData[{
  "Developer's Kit, ",
  StyleBox["MathLink,",
    FontSlant->"Italic"],
  " parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Developer's Kit"],

Cell[TextData[{
  "Development environments, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Development environments"],

Cell[TextData[{
  "supported by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Development environments"],

Cell[TextData[{
  "Dynamically linked libraries, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "Packaging"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dynamically linked libraries"],

Cell[TextData[{
  "Evaluating ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions, running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Evaluating Mathematica expressions"],

Cell[TextData[{
  "External functions",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"External functions"],

Cell[TextData[{
  "factor",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"factor"],

Cell[TextData[{
  "running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"factor"],

Cell[TextData[{
  "Filemap protocol ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "FileMap"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Filemap protocol"],

Cell[TextData[ButtonBox["Running",
  ButtonData:>{"Running", "protocols"},
  ButtonStyle->"AddOnsLink"]], "IndexSubentry",
  CellTags->"Filemap protocol"],

Cell[TextData[{
  "Generated files, mprep ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generated files"],

Cell[TextData[{
  "building addtwo ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generated files"],

Cell[TextData[{
  "using mprep ",
  ButtonBox["Building",
    ButtonData:>{"Building", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generated files"],

Cell[TextData[{
  "Header files",
  ", mathlink.h ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mathlink.h"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Header files"],

Cell[TextData[{
  "IDE, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IDE"],

Cell[TextData[{
  "supported by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"IDE"],

Cell[TextData[{
  "Include files",
  ", mathlink.h ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mathlink.h"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Include files"],

Cell[TextData[{
  "Install, running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Install"],

Cell[TextData[{
  "Installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Installing MathLink"],

Cell[TextData[{
  "Launching programs, running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Launching programs"],

Cell[TextData[{
  "Library, ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "MathLinkLibraries"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Library"],

Cell[TextData[{
  "Link protocols, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "devices"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Link protocols"],

Cell[TextData[{
  "supported by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Link Protocols"],

Cell[TextData[{
  "Local protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Local"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Local protocol"],

Cell[TextData[{
  "in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Local Protocol"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", building programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink"],

Cell[TextData[{
  "compilers supported by Developer's Kit ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "Developer Guide ",
  ButtonBox["Introduction",
    ButtonData:>{"Introduction"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "Developer's Kit parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "installing components ",
  ButtonBox["Installing",
    ButtonData:>{"Installing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "libraries ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "MathLinkLibraries"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "porting Version 2.2 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Porting",
    ButtonData:>{"Porting"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "running programs ",
  ButtonBox["Running",
    ButtonData:>{"Running"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", compatibility, connecting to Version 2.2 programs ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "V2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink, compatibility"],

Cell[TextData[{
  "with Version 2.2 ",
  ButtonBox["Porting",
    ButtonData:>{"Porting"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink, compatibility"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kits, parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink Developer's Kits"],

Cell[TextData[{
  "mathlink.h",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mathlink.h"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"mathlink.h"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " files, parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink files"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Interface, changes to ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "changes"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink Interface"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "MathLinkLibraries"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink library"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", sample projects, building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink, sample projects"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", sample programs ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "prebuilt"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "addtwo, running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "factor, running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "Metrowerks CodeWarrior C/C++ ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "CodeWarrior"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Metrowerks CodeWarrior C/C++"],

Cell[TextData[{
  "building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with ",
  ButtonBox["Building",
    ButtonData:>{"Building", "CodeWarrior"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Metrowerks CodeWarrior C/C++"],

Cell[TextData[{
  "installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components for ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "CodeWarrior"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Metrowerks CodeWarrior C/C++"],

Cell[TextData[{
  "Microsoft Visual C/C++ ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "Microsoft"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Microsoft Visual C/C++"],

Cell[TextData[{
  "building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with ",
  ButtonBox["Building",
    ButtonData:>{"Building", "Microsoft"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Microsoft Visual C/C++"],

Cell[TextData[{
  "installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components for ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Microsoft"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Microsoft Visual C/C++"],

Cell[TextData[{
  "Microsoft Windows, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs for ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Microsoft Windows"],

Cell[TextData[{
  "MLBegin",
  ", calling with non-zero argument ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLInitialize"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLBegin"],

Cell[TextData[{
  "MLBytesToGet",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLBytesToGet"],

Cell[TextData[{
  "calling after MLGetData ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetData"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLBytesToGet"],

Cell[TextData[{
  "MLCheckFunction",
  ", using to get argument count ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetArgCount"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLCheckFunction"],

Cell[TextData[{
  "MLConvertUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLConvertUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLConvertUnicodeString"],

Cell[TextData[{
  "MLDisownByteString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownByteString"],

Cell[TextData[{
  "MLDisownByteSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownByteSymbol"],

Cell[TextData[{
  "MLDisownUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownUnicodeString"],

Cell[TextData[{
  "MLDisownUnicodeSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownUnicodeSymbol"],

Cell[TextData[{
  "MLforString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLforString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLforString"],

Cell[TextData[{
  "MLGetArgCount",
  ", calling after MLGetFunction or MLCheckFunction ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetArgCount"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetArgCount"],

Cell[TextData[{
  "MLGetByteString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetByteString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetByteString"],

Cell[TextData[{
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLGetByteString"],

Cell[TextData[{
  "MLGetByteSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetByteSymbol"],

Cell[TextData[{
  "MLGetData",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetData"],

Cell[TextData[{
  "calling before MLBytesToGet ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetData"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLGetData"],

Cell[TextData[{
  "MLGetFunction",
  ", using to get argument count ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetArgCount"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetFunction"],

Cell[TextData[{
  "MLGetString",
  ", preprocessing strings before calling ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetString"],

Cell[TextData[{
  "MLGetUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetUnicodeString"],

Cell[TextData[{
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLGetUnicodeString"],

Cell[TextData[{
  "MLGetUnicodeSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetUnicodeSymbol"],

Cell[TextData[{
  "MLInitialize",
  ", calling with non-zero argument ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLInitialize"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLInitialize"],

Cell[TextData[{
  "MLNextCharacter",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLNextCharacter"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLNextCharacter"],

Cell[TextData[{
  "MLPutByteString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutByteString"],

Cell[TextData[{
  "MLPutByteSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutByteSymbol"],

Cell[TextData[{
  "MLPutCharToString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutCharToString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutCharToString"],

Cell[TextData[{
  "MLPutData",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutData"],

Cell[TextData[{
  "MLPutFunction",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutFunction"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutFunction"],

Cell[TextData[{
  "MLPutNext",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutNext"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutNext"],

Cell[TextData[{
  "MLPutSize",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutSize"],

Cell[TextData[{
  "MLPutString",
  ", postprocessing strings after calling ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutString"],

Cell[TextData[{
  "MLPutUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutUnicodeString"],

Cell[TextData[{
  "MLPutUnicodeSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutUnicodeSymbol"],

Cell[TextData[{
  "MLStringChar ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLforString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLStringChar"],

Cell[TextData[{
  "MLStringPosition",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLforString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLStringPosition"],

Cell[TextData[{
  "mprep",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"mprep"],

Cell[TextData[{
  "building addtwo ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"mprep"],

Cell[TextData[{
  "using ",
  ButtonBox["Building",
    ButtonData:>{"Building", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"mprep"],

Cell[TextData[{
  "Preprocess ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs, using mprep ",
  ButtonBox["Building",
    ButtonData:>{"Building", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Preprocess MathLink programs"],

Cell[TextData[{
  "Programming languages, languages other than C/C++ ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "languages"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Programming languages"],

Cell[TextData[{
  "Programs, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Programs"],

Cell[TextData[{
  "running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Programs"],

Cell[TextData[{
  "Projects, building sample ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Projects"],

Cell[TextData[{
  "Protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Protocol"],

Cell[TextData[{
  "Running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Running",
    ButtonData:>{"Running"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Running MathLink programs"],

Cell[TextData[{
  "Sample projects of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sample projects of MathLink"],

Cell[TextData[{
  "Shared libraries, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "Packaging"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Shared libraries"],

Cell[TextData[{
  "on Microsoft Windows ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Windows shared"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Shared libraries"],

Cell[TextData[{
  "Special characters, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Special characters"],

Cell[TextData[{
  "Strings, representation in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Strings"],

Cell[TextData[{
  "Subsidiary processes, running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subsidiary processes"],

Cell[TextData[{
  "Symantec C/C++ ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "Symantec"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Symantec C/C++"],

Cell[TextData[{
  "building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with ",
  ButtonBox["Building",
    ButtonData:>{"Building", "Symantec"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Symantec C/C++"],

Cell[TextData[{
  "installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components for ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Symantec"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Symantec C/C++"],

Cell[TextData[{
  "Symbols, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Symbols"],

Cell[TextData[{
  "TCP protocol",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "TCP"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TCP protocol"],

Cell[TextData[{
  "in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"TCP protocol"],

Cell[TextData[{
  "Template programs",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Template programs"],

Cell[TextData[{
  "Unicode, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " strings ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unicode"],

Cell[TextData[{
  "Uninstall",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Uninstall"],

Cell[TextData[{
  "Visual C/C++ ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "Microsoft"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Visual C/C++"],

Cell[TextData[{
  "building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with ",
  ButtonBox["Building",
    ButtonData:>{"Building", "Microsoft"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Visual C/C++"],

Cell[TextData[{
  "installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components for ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Microsoft"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Visual C/C++"],

Cell[TextData[{
  "Watcom C/C++ ",
  ButtonBox["Compilers",
    ButtonData:>{"Compilers", "Watcom"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Watcom C/C++"],

Cell[TextData[{
  "building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with ",
  ButtonBox["Building",
    ButtonData:>{"Building", "Watcom"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Watcom C/C++"],

Cell[TextData[{
  "installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components for ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Watcom"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Watcom C/C++"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mac OS X", "Subsubsection"],

Cell[TextData[{
  "addtwo",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"addtwo"],

Cell[TextData[{
  "running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0101"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"addtwo"],

Cell[TextData[{
  "API",
  ", changes to ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"API"],

Cell[TextData[{
  "ASCII, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"ASCII"],

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Building MathLink programs"],

Cell[TextData[{
  "Calling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from external programs, running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0124"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Calling Mathematica from external programs"],

Cell[TextData[{
  "C Compilers, compiling ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"C Compilers"],

Cell[TextData[{
  "Character codes, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Character codes"],

Cell[TextData[{
  "Character encoding, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Character encoding"],

Cell[TextData[{
  "Child processes",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0101"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Child processes"],

Cell[TextData[{
  "Compatibility, of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " with Version 2 ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Compatibility"],

Cell[TextData[{
  "Compiling ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Compiling MathLink programs"],

Cell[TextData[{
  "Console programs",
  ", building factor ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Console programs"],

Cell[TextData[{
  "running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0124"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Console programs"],

Cell[TextData[{
  "Developer's Kit, ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0039"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Developer's Kit"],

Cell[TextData[{
  "Evaluating ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions, running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0124"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Evaluating Mathematica expressions"],

Cell[TextData[{
  "External functions",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0101"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"External functions"],

Cell[TextData[{
  "factor",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"factor"],

Cell[TextData[{
  "running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0124"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"factor"],

Cell[TextData[{
  "Header files",
  ", mathlink.h ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0042"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Header files"],

Cell[TextData[{
  "Include files",
  ", mathlink.h ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0042"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Include files"],

Cell[TextData[{
  "Install",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0101"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Install"],

Cell[TextData[{
  "Installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0031"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Installing MathLink"],

Cell[TextData[{
  "libML.a",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0044"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"libML.a"],

Cell[TextData[{
  "Library, MathLinkLibraries ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0044"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Library"],

Cell[TextData[{
  "Link protocols, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0132"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Link protocols"],

Cell[TextData[{
  "Local protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0132"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Local protocol"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", building programs ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink"],

Cell[TextData[{
  "Developer's Guide ",
  ButtonBox["Introduction",
    ButtonData:>{"Introduction", "DevGuide0001"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink"],

Cell[TextData[{
  "Developer's Kit parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0039"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink"],

Cell[TextData[{
  "installing components ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0030"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink"],

Cell[TextData[{
  "running programs ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0099"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink"],

Cell[TextData[{
  "what's new in Version 3 ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", compatibility, with Version 2 ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink, compatibility"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kits, parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0039"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink Developer's Kits"],

Cell[TextData[{
  "mathlink.h",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0042"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"mathlink.h"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Interface, changes to ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink Interface"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", sample programs, addtwo, running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0101"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "building ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "factor, running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0124"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "MLBegin",
  ", calling with non-zero argument ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLBegin"],

Cell[TextData[{
  "MLBytesToGet",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLBytesToGet"],

Cell[TextData[{
  "calling after MLGetData ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLBytesToGet"],

Cell[TextData[{
  "MLCheckFunction",
  ", using to get argument count ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLCheckFunction"],

Cell[TextData[{
  "MLConvertUnicodeString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLConvertUnicodeString"],

Cell[TextData[{
  "MLDisownByteString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLDisownByteString"],

Cell[TextData[{
  "MLDisownByteSymbol",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLDisownByteSymbol"],

Cell[TextData[{
  "MLDisownUnicodeString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLDisownUnicodeString"],

Cell[TextData[{
  "MLDisownUnicodeSymbol",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLDisownUnicodeSymbol"],

Cell[TextData[{
  "MLforString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLforString"],

Cell[TextData[{
  "MLGetArgCount",
  ", calling after MLGetFunction or MLCheckFunction ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetArgCount"],

Cell[TextData[{
  "MLGetByteString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetByteString"],

Cell[TextData[{
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetByteString"],

Cell[TextData[{
  "MLGetByteSymbol",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetByteSymbol"],

Cell[TextData[{
  "MLGetData",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetData"],

Cell[TextData[{
  "calling before MLBytesToGet ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetData"],

Cell[TextData[{
  "value returned ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetData"],

Cell[TextData[{
  "MLGetFunction",
  ", using to get argument count ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetFunction"],

Cell[TextData[{
  "MLGetString",
  ", preprocessing strings before calling ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetString"],

Cell[TextData[{
  "MLGetUnicodeString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetUnicodeString"],

Cell[TextData[{
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetUnicodeString"],

Cell[TextData[{
  "MLGetUnicodeSymbol",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLGetUnicodeSymbol"],

Cell[TextData[{
  "MLInitialize",
  ", calling with non-zero argument ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLInitialize"],

Cell[TextData[{
  "MLNextCharacter",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLNextCharacter"],

Cell[TextData[{
  "MLPutByteString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutByteString"],

Cell[TextData[{
  "MLPutByteSymbol",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutByteSymbol"],

Cell[TextData[{
  "MLPutCharToString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutCharToString"],

Cell[TextData[{
  "MLPutData",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutData"],

Cell[TextData[{
  "MLPutFunction",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutFunction"],

Cell[TextData[{
  "MLPutNext",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutNext"],

Cell[TextData[{
  "MLPutSize",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutSize"],

Cell[TextData[{
  "MLPutString",
  ", postprocessing strings after calling ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutString"],

Cell[TextData[{
  "MLPutUnicodeString",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutUnicodeString"],

Cell[TextData[{
  "MLPutUnicodeSymbol",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLPutUnicodeSymbol"],

Cell[TextData[{
  "MLStringPosition",
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"MLStringPosition"],

Cell[TextData[{
  "mprep",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "DevGuide0046"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"mprep"],

Cell[TextData[{
  "building addtwo ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"mprep"],

Cell[TextData[{
  "using ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0074"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"mprep"],

Cell[TextData[{
  "Pipes protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0132"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Pipes protocol"],

Cell[TextData[{
  "Preprocess ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs, mprep ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0074"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Preprocess MathLink programs"],

Cell[TextData[{
  "Programs, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Programs"],

Cell[TextData[{
  "running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0099"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Programs"],

Cell[TextData[{
  "Protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0132"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Protocol"],

Cell[TextData[{
  "Running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0099"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Running MathLink programs"],

Cell[TextData[{
  "Special characters, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Special characters"],

Cell[TextData[{
  "Strings, representation in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Strings"],

Cell[TextData[{
  "Symbols, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Symbols"],

Cell[TextData[{
  "TCP protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0132"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"TCP protocol"],

Cell[TextData[{
  "Template programs",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building", "DevGuide0052"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Template programs"],

Cell[TextData[{
  "Unicode, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " strings ",
  ButtonBox["What's New",
    ButtonData:>{"MathLink Introduction: Mac OS X"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Unicode"],

Cell[TextData[{
  "Uninstall",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "DevGuide0101"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  GeneratedCell->True,
  AutoItalicWords->{"MathLink", "Mathematica"},
  CellTags->"Uninstall"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unix", "Subsubsection"],

Cell[TextData[{
  "addtwo",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"addtwo"],

Cell[TextData[{
  "running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"addtwo"],

Cell[TextData[{
  "ANSI prototypes, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using a pre-ANSI C compiler ",
  ButtonBox["Building",
    ButtonData:>{"Building", "preANSI"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ANSI prototypes"],

Cell[TextData[{
  "API",
  ", changes to ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "changes"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"API"],

Cell[TextData[{
  "ASCII, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ASCII"],

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Building MathLink programs"],

Cell[TextData[{
  "Calling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from external programs, running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Calling Mathematica from external programs"],

Cell[TextData[{
  "C Compilers, compiling ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"C Compilers"],

Cell[TextData[{
  "C source code, ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "sample code"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"C source code"],

Cell[TextData[{
  "Character codes, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Character codes"],

Cell[TextData[{
  "Character encoding, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Character encoding"],

Cell[TextData[{
  "Child processes",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Child processes"],

Cell[TextData[{
  "Compatibility, of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " with Version 2 ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "changes"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Compatibility"],

Cell[TextData[{
  "Compiling ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Compiling MathLink programs"],

Cell[TextData[{
  "Console programs",
  ", building factor ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Console programs"],

Cell[TextData[{
  "running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Console programs"],

Cell[TextData[{
  "Developer kits, ",
  StyleBox["MathLink,",
    FontSlant->"Italic"],
  " parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Developer kits, MathLink"],

Cell[TextData[{
  "Developer's Kit, ",
  StyleBox["MathLink,",
    FontSlant->"Italic"],
  " parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Developer's Kit"],

Cell[TextData[{
  "Evaluating ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions, running factor ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Evaluating Mathematica expressions"],

Cell[TextData[{
  "External functions",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"External functions"],

Cell[TextData[{
  "factor",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"factor"],

Cell[TextData[{
  "running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"factor"],

Cell[TextData[{
  "Generated files, mprep ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generated files"],

Cell[TextData[{
  "building addtwo ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generated files"],

Cell[TextData[{
  "using mprep ",
  ButtonBox["Building",
    ButtonData:>{"Building", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Generated files"],

Cell[TextData[{
  "Header files",
  ", mathlink.h ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mathlink.h"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Header files"],

Cell[TextData[{
  "Include files",
  ", mathlink.h ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mathlink.h"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Include files"],

Cell[TextData[{
  "Install, running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Install"],

Cell[TextData[{
  "Installing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Installing MathLink"],

Cell[TextData[{
  "Launching programs, running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Launching programs"],

Cell[TextData[{
  "libML.a ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "MathLinkLibraries"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"libML.a"],

Cell[TextData[{
  "Library, ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "MathLinkLibraries"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Library"],

Cell[TextData[{
  "Link protocols, supported by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Link protocols"],

Cell[TextData[{
  "Local protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Local protocol"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", building programs ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink"],

Cell[TextData[{
  "Developer Guide ",
  ButtonBox["Introduction",
    ButtonData:>{"Introduction"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "Developer's Kit parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "installing components ",
  ButtonBox["Installing",
    ButtonData:>{"Installing"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "libraries ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "MathLinkLibraries"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "porting Version 2.2 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Porting",
    ButtonData:>{"Porting"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  "running programs ",
  ButtonBox["Running",
    ButtonData:>{"Running"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", compatibility, with Version 2.2 ",
  ButtonBox["Porting",
    ButtonData:>{"Porting"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink, compatibility"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kits, parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink Developer's Kits"],

Cell[TextData[{
  "mathlink.h",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mathlink.h"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"mathlink.h"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " files, parts list ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "parts"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink files"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Interface, changes to ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "changes"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink Interface"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "MathLinkLibraries"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink library"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", sample projects, building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink, sample projects"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", sample programs ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "prebuilt"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "addtwo, running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "factor, running ",
  ButtonBox["Running",
    ButtonData:>{"Running", "factor"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MathLink, sample programs"],

Cell[TextData[{
  "mcc ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mcc"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"mcc"],

Cell[TextData[{
  "building addtwo ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"mcc"],

Cell[TextData[{
  "using ",
  ButtonBox["Building",
    ButtonData:>{"Building", "mcc"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"mcc"],

Cell[TextData[{
  "MLBegin",
  ", calling with non-zero argument ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLInitialize"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLBegin"],

Cell[TextData[{
  "MLBytesToGet",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLBytesToGet"],

Cell[TextData[{
  "calling after MLGetData ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetData"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLBytesToGet"],

Cell[TextData[{
  "MLCheckFunction",
  ", using to get argument count ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetArgCount"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLCheckFunction"],

Cell[TextData[{
  "MLConvertUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLConvertUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLConvertUnicodeString"],

Cell[TextData[{
  "MLDisownByteString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownByteString"],

Cell[TextData[{
  "MLDisownByteSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownByteSymbol"],

Cell[TextData[{
  "MLDisownUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownUnicodeString"],

Cell[TextData[{
  "MLDisownUnicodeSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLDisownUnicodeSymbol"],

Cell[TextData[{
  "MLforString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLforString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLforString"],

Cell[TextData[{
  "MLGetArgCount",
  ", calling after MLGetFunction or MLCheckFunction ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetArgCount"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetArgCount"],

Cell[TextData[{
  "MLGetByteString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetByteString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetByteString"],

Cell[TextData[{
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLGetByteString"],

Cell[TextData[{
  "MLGetByteSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetByteSymbol"],

Cell[TextData[{
  "MLGetData",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetData"],

Cell[TextData[{
  "calling before MLBytesToGet ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetData"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLGetData"],

Cell[TextData[{
  "MLGetFunction",
  ", using to get argument count ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetArgCount"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetFunction"],

Cell[TextData[{
  "MLGetString",
  ", preprocessing strings before calling ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetString"],

Cell[TextData[{
  "MLGetUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLGetUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetUnicodeString"],

Cell[TextData[{
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"MLGetUnicodeString"],

Cell[TextData[{
  "MLGetUnicodeSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLGetUnicodeSymbol"],

Cell[TextData[{
  "MLInitialize",
  ", calling with non-zero argument ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLInitialize"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLInitialize"],

Cell[TextData[{
  "MLNextCharacter",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLNextCharacter"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLNextCharacter"],

Cell[TextData[{
  "MLPROTOTYPES, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using a pre-ANSI C compiler ",
  ButtonBox["Building",
    ButtonData:>{"Building", "preANSI"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPROTOTYPES"],

Cell[TextData[{
  "MLPutByteString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutByteString"],

Cell[TextData[{
  "MLPutByteSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutByteSymbol"],

Cell[TextData[{
  "MLPutCharToString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutCharToString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutCharToString"],

Cell[TextData[{
  "MLPutData",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutData"],

Cell[TextData[{
  "MLPutFunction",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutFunction"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutFunction"],

Cell[TextData[{
  "MLPutNext",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutNext"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutNext"],

Cell[TextData[{
  "MLPutSize",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLBytesToGet"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutSize"],

Cell[TextData[{
  "MLPutString",
  ", postprocessing strings after calling ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutString"],

Cell[TextData[{
  "MLPutUnicodeString",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutUnicodeString"],

Cell[TextData[{
  "MLPutUnicodeSymbol",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLPutUnicodeString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLPutUnicodeSymbol"],

Cell[TextData[{
  "MLStringChar ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLforString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLStringChar"],

Cell[TextData[{
  "MLStringPosition",
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "MLforString"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MLStringPosition"],

Cell[TextData[{
  "mprep",
  " ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"mprep"],

Cell[TextData[{
  "building addtwo ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"mprep"],

Cell[TextData[{
  "using ",
  ButtonBox["Building",
    ButtonData:>{"Building", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"mprep"],

Cell[TextData[{
  "Pipes protocol ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Pipes protocol"],

Cell[TextData[{
  "Preprocess ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs, using mprep ",
  ButtonBox["Building",
    ButtonData:>{"Building", "mprep"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Preprocess MathLink programs"],

Cell[TextData[{
  "Programs, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Programs"],

Cell[TextData[{
  "running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Programs"],

Cell[TextData[{
  "Projects, building sample ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Projects"],

Cell[TextData[{
  "Protocol, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Protocol"],

Cell[TextData[{
  "Prototypes, building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using a pre-ANSI C compiler ",
  ButtonBox["Building",
    ButtonData:>{"Building", "preANSI"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Prototypes"],

Cell[TextData[{
  "Running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Running",
    ButtonData:>{"Running"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Running MathLink programs"],

Cell[TextData[{
  "Sample projects of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sample projects of MathLink"],

Cell[TextData[{
  "Shared libraries, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "Packaging"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Shared libraries"],

Cell[TextData[{
  "on Microsoft Windows ",
  ButtonBox["Installing",
    ButtonData:>{"Installing", "Windows shared"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->"Shared libraries"],

Cell[TextData[{
  "Special characters, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Special characters"],

Cell[TextData[{
  "Strings, representation in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Strings"],

Cell[TextData[{
  "Subsidiary processes, running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subsidiary processes"],

Cell[TextData[{
  "Symbols, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Symbols"],

Cell[TextData[{
  "TCP protocol ",
  ButtonBox["Running",
    ButtonData:>{"Running", "protocols"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TCP protocol"],

Cell[TextData[{
  "Template programs",
  ", building ",
  ButtonBox["Building",
    ButtonData:>{"Building"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Template programs"],

Cell[TextData[{
  "Unicode, in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " strings ",
  ButtonBox["Porting",
    ButtonData:>{"Porting", "strings"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unicode"],

Cell[TextData[{
  "Uninstall",
  ", running addtwo ",
  ButtonBox["Running",
    ButtonData:>{"Running", "addtwo"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Uninstall"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1152}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{520, 624},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1754, 51, 139, 5, 41, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "addtwo"->{
    Cell[1953, 62, 164, 7, 16, "Index",
      CellTags->"addtwo"],
    Cell[2120, 71, 165, 6, 16, "IndexSubentry",
      CellTags->"addtwo"],
    Cell[32160, 1410, 251, 9, 16, "Index",
      CellTags->"addtwo"],
    Cell[32414, 1421, 242, 8, 16, "IndexSubentry",
      CellTags->"addtwo"],
    Cell[58368, 2451, 164, 7, 16, "Index",
      CellTags->"addtwo"],
    Cell[58535, 2460, 165, 6, 16, "IndexSubentry",
      CellTags->"addtwo"]},
  "API"->{
    Cell[2288, 79, 169, 7, 16, "Index",
      CellTags->"API"],
    Cell[32659, 1431, 256, 9, 16, "Index",
      CellTags->"API"],
    Cell[58986, 2479, 169, 7, 16, "Index",
      CellTags->"API"]},
  "ASCII"->{
    Cell[2460, 88, 215, 9, 16, "Index",
      CellTags->"ASCII"],
    Cell[32918, 1442, 302, 11, 16, "Index",
      CellTags->"ASCII"],
    Cell[59158, 2488, 215, 9, 16, "Index",
      CellTags->"ASCII"]},
  "Borland C/C++"->{
    Cell[2678, 99, 175, 6, 16, "Index",
      CellTags->"Borland C/C++"],
    Cell[2856, 107, 246, 9, 16, "IndexSubentry",
      CellTags->"Borland C/C++"],
    Cell[3105, 118, 253, 9, 16, "IndexSubentry",
      CellTags->"Borland C/C++"]},
  "Building MathLink programs"->{
    Cell[3361, 129, 235, 9, 16, "Index",
      CellTags->"Building MathLink programs"],
    Cell[33223, 1455, 322, 11, 16, "Index",
      CellTags->"Building MathLink programs"],
    Cell[59376, 2499, 235, 9, 16, "Index",
      CellTags->"Building MathLink programs"]},
  "Calling Mathematica from external programs"->{
    Cell[3599, 140, 291, 9, 16, "Index",
      CellTags->"Calling Mathematica from external programs"],
    Cell[33548, 1468, 368, 11, 16, "Index",
      CellTags->"Calling Mathematica from external programs"],
    Cell[59614, 2510, 291, 9, 16, "Index",
      CellTags->"Calling Mathematica from external programs"]},
  "C Compilers"->{
    Cell[3893, 151, 234, 9, 16, "Index",
      CellTags->"C Compilers"],
    Cell[4130, 162, 225, 9, 16, "IndexSubentry",
      CellTags->"C Compilers"],
    Cell[33919, 1481, 321, 11, 16, "Index",
      CellTags->"C Compilers"],
    Cell[59908, 2521, 234, 9, 16, "Index",
      CellTags->"C Compilers"]},
  "C source code"->{
    Cell[4358, 173, 238, 9, 16, "Index",
      CellTags->"C source code"],
    Cell[60145, 2532, 238, 9, 16, "Index",
      CellTags->"C source code"]},
  "Character codes"->{
    Cell[4599, 184, 235, 9, 16, "Index",
      CellTags->"Character codes"],
    Cell[34243, 1494, 322, 11, 16, "Index",
      CellTags->"Character codes"],
    Cell[60386, 2543, 235, 9, 16, "Index",
      CellTags->"Character codes"]},
  "Character encoding"->{
    Cell[4837, 195, 241, 9, 16, "Index",
      CellTags->"Character encoding"],
    Cell[34568, 1507, 328, 11, 16, "Index",
      CellTags->"Character encoding"],
    Cell[60624, 2554, 241, 9, 16, "Index",
      CellTags->"Character encoding"]},
  "Child processes"->{
    Cell[5081, 206, 196, 7, 16, "Index",
      CellTags->"Child processes"],
    Cell[34899, 1520, 273, 9, 16, "Index",
      CellTags->"Child processes"],
    Cell[60868, 2565, 196, 7, 16, "Index",
      CellTags->"Child processes"]},
  "CodeWarrior"->{
    Cell[5280, 215, 175, 6, 16, "Index",
      CellTags->"CodeWarrior"],
    Cell[5458, 223, 248, 9, 16, "IndexSubentry",
      CellTags->"CodeWarrior"],
    Cell[5709, 234, 255, 9, 16, "IndexSubentry",
      CellTags->"CodeWarrior"]},
  "Compatibility"->{
    Cell[5967, 245, 246, 9, 16, "Index",
      CellTags->"Compatibility"],
    Cell[35175, 1531, 333, 11, 16, "Index",
      CellTags->"Compatibility"],
    Cell[61067, 2574, 246, 9, 16, "Index",
      CellTags->"Compatibility"]},
  "Compiling MathLink programs"->{
    Cell[6216, 256, 237, 9, 16, "Index",
      CellTags->"Compiling MathLink programs"],
    Cell[35511, 1544, 324, 11, 16, "Index",
      CellTags->"Compiling MathLink programs"],
    Cell[61316, 2585, 237, 9, 16, "Index",
      CellTags->"Compiling MathLink programs"]},
  "Console programs"->{
    Cell[6456, 267, 191, 7, 16, "Index",
      CellTags->"Console programs"],
    Cell[6650, 276, 182, 6, 16, "IndexSubentry",
      CellTags->"Console programs"],
    Cell[35838, 1557, 278, 9, 16, "Index",
      CellTags->"Console programs"],
    Cell[36119, 1568, 259, 8, 16, "IndexSubentry",
      CellTags->"Console programs"],
    Cell[61556, 2596, 191, 7, 16, "Index",
      CellTags->"Console programs"],
    Cell[61750, 2605, 182, 6, 16, "IndexSubentry",
      CellTags->"Console programs"]},
  "Developer kits, MathLink"->{
    Cell[6835, 284, 256, 9, 16, "Index",
      CellTags->"Developer kits, MathLink"],
    Cell[61935, 2613, 256, 9, 16, "Index",
      CellTags->"Developer kits, MathLink"]},
  "Developer's Kit"->{
    Cell[7094, 295, 248, 9, 16, "Index",
      CellTags->"Developer's Kit"],
    Cell[36381, 1578, 325, 11, 16, "Index",
      CellTags->"Developer's Kit"],
    Cell[62194, 2624, 248, 9, 16, "Index",
      CellTags->"Developer's Kit"]},
  "Development environments"->{
    Cell[7345, 306, 259, 9, 16, "Index",
      CellTags->"Development environments"],
    Cell[7607, 317, 238, 9, 16, "IndexSubentry",
      CellTags->"Development environments"]},
  "Dynamically linked libraries"->{
    Cell[7848, 328, 272, 9, 16, "Index",
      CellTags->"Dynamically linked libraries"]},
  "Evaluating Mathematica expressions"->{
    Cell[8123, 339, 275, 9, 16, "Index",
      CellTags->"Evaluating Mathematica expressions"],
    Cell[36709, 1591, 352, 11, 16, "Index",
      CellTags->"Evaluating Mathematica expressions"],
    Cell[62445, 2635, 275, 9, 16, "Index",
      CellTags->"Evaluating Mathematica expressions"]},
  "External functions"->{
    Cell[8401, 350, 202, 7, 16, "Index",
      CellTags->"External functions"],
    Cell[37064, 1604, 279, 9, 16, "Index",
      CellTags->"External functions"],
    Cell[62723, 2646, 202, 7, 16, "Index",
      CellTags->"External functions"]},
  "factor"->{
    Cell[8606, 359, 164, 7, 16, "Index",
      CellTags->"factor"],
    Cell[8773, 368, 165, 6, 16, "IndexSubentry",
      CellTags->"factor"],
    Cell[37346, 1615, 251, 9, 16, "Index",
      CellTags->"factor"],
    Cell[37600, 1626, 242, 8, 16, "IndexSubentry",
      CellTags->"factor"],
    Cell[62928, 2655, 164, 7, 16, "Index",
      CellTags->"factor"],
    Cell[63095, 2664, 165, 6, 16, "IndexSubentry",
      CellTags->"factor"]},
  "Filemap protocol"->{
    Cell[8941, 376, 183, 6, 16, "Index",
      CellTags->"Filemap protocol"],
    Cell[9127, 384, 154, 3, 15, "IndexSubentry",
      CellTags->"Filemap protocol"]},
  "Generated files"->{
    Cell[9284, 389, 186, 6, 16, "Index",
      CellTags->"Generated files"],
    Cell[9473, 397, 174, 6, 16, "IndexSubentry",
      CellTags->"Generated files"],
    Cell[9650, 405, 179, 6, 16, "IndexSubentry",
      CellTags->"Generated files"],
    Cell[63263, 2672, 186, 6, 16, "Index",
      CellTags->"Generated files"],
    Cell[63452, 2680, 174, 6, 16, "IndexSubentry",
      CellTags->"Generated files"],
    Cell[63629, 2688, 179, 6, 16, "IndexSubentry",
      CellTags->"Generated files"]},
  "Header files"->{
    Cell[9832, 413, 196, 7, 16, "Index",
      CellTags->"Header files"],
    Cell[37845, 1636, 269, 9, 16, "Index",
      CellTags->"Header files"],
    Cell[63811, 2696, 196, 7, 16, "Index",
      CellTags->"Header files"]},
  "IDE"->{
    Cell[10031, 422, 217, 9, 16, "Index",
      CellTags->"IDE"],
    Cell[10251, 433, 217, 9, 16, "IndexSubentry",
      CellTags->"IDE"]},
  "Include files"->{
    Cell[10471, 444, 198, 7, 16, "Index",
      CellTags->"Include files"],
    Cell[38117, 1647, 271, 9, 16, "Index",
      CellTags->"Include files"],
    Cell[64010, 2705, 198, 7, 16, "Index",
      CellTags->"Include files"]},
  "Install"->{
    Cell[10672, 453, 174, 6, 16, "Index",
      CellTags->"Install"],
    Cell[38391, 1658, 257, 9, 16, "Index",
      CellTags->"Install"],
    Cell[64211, 2714, 174, 6, 16, "Index",
      CellTags->"Install"]},
  "Installing MathLink"->{
    Cell[10849, 461, 225, 9, 16, "Index",
      CellTags->"Installing MathLink"],
    Cell[38651, 1669, 312, 11, 16, "Index",
      CellTags->"Installing MathLink"],
    Cell[64388, 2722, 225, 9, 16, "Index",
      CellTags->"Installing MathLink"]},
  "Launching programs"->{
    Cell[11077, 472, 196, 6, 16, "Index",
      CellTags->"Launching programs"],
    Cell[64616, 2733, 196, 6, 16, "Index",
      CellTags->"Launching programs"]},
  "Library"->{
    Cell[11276, 480, 232, 9, 16, "Index",
      CellTags->"Library"],
    Cell[39216, 1693, 260, 8, 16, "Index",
      CellTags->"Library"],
    Cell[64993, 2749, 232, 9, 16, "Index",
      CellTags->"Library"]},
  "Link protocols"->{
    Cell[11511, 491, 239, 9, 16, "Index",
      CellTags->"Link protocols"],
    Cell[39479, 1703, 309, 11, 16, "Index",
      CellTags->"Link protocols"],
    Cell[65228, 2760, 245, 9, 16, "Index",
      CellTags->"Link protocols"]},
  "Link Protocols"->{
    Cell[11753, 502, 237, 9, 16, "IndexSubentry",
      CellTags->"Link Protocols"]},
  "Local protocol"->{
    Cell[11993, 513, 237, 9, 16, "Index",
      CellTags->"Local protocol"],
    Cell[39791, 1716, 309, 11, 16, "Index",
      CellTags->"Local protocol"],
    Cell[65476, 2771, 235, 9, 16, "Index",
      CellTags->"Local protocol"]},
  "Local Protocol"->{
    Cell[12233, 524, 227, 9, 16, "IndexSubentry",
      CellTags->"Local Protocol"]},
  "MathLink"->{
    Cell[12463, 535, 212, 8, 16, "Index",
      CellTags->"MathLink"],
    Cell[12678, 545, 192, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[12873, 553, 175, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[13051, 561, 191, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[13245, 569, 177, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[13425, 577, 186, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[13614, 585, 234, 9, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[13851, 596, 166, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[40103, 1729, 299, 10, 16, "Index",
      CellTags->"MathLink"],
    Cell[40405, 1741, 264, 8, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[40672, 1751, 269, 8, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[40944, 1761, 264, 8, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[41211, 1771, 253, 8, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[41467, 1781, 271, 8, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[65714, 2782, 212, 8, 16, "Index",
      CellTags->"MathLink"],
    Cell[65929, 2792, 175, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[66107, 2800, 191, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[66301, 2808, 177, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[66481, 2816, 186, 6, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[66670, 2824, 234, 9, 16, "IndexSubentry",
      CellTags->"MathLink"],
    Cell[66907, 2835, 166, 6, 16, "IndexSubentry",
      CellTags->"MathLink"]},
  "MathLink, compatibility"->{
    Cell[14020, 604, 269, 8, 16, "Index",
      CellTags->"MathLink, compatibility"],
    Cell[14292, 614, 181, 6, 16, "IndexSubentry",
      CellTags->"MathLink, compatibility"],
    Cell[41741, 1791, 335, 10, 16, "Index",
      CellTags->"MathLink, compatibility"],
    Cell[67076, 2843, 239, 8, 16, "Index",
      CellTags->"MathLink, compatibility"]},
  "MathLink Developer's Kits"->{
    Cell[14476, 622, 252, 8, 16, "Index",
      CellTags->"MathLink Developer's Kits"],
    Cell[42079, 1803, 330, 10, 16, "Index",
      CellTags->"MathLink Developer's Kits"],
    Cell[67318, 2853, 252, 8, 70, "Index",
      CellTags->"MathLink Developer's Kits"]},
  "mathlink.h"->{
    Cell[14731, 632, 180, 7, 16, "Index",
      CellTags->"mathlink.h"],
    Cell[42412, 1815, 253, 9, 16, "Index",
      CellTags->"mathlink.h"],
    Cell[67573, 2863, 180, 7, 70, "Index",
      CellTags->"mathlink.h"]},
  "MathLink files"->{
    Cell[14914, 641, 230, 8, 16, "Index",
      CellTags->"MathLink files"],
    Cell[67756, 2872, 230, 8, 70, "Index",
      CellTags->"MathLink files"]},
  "MathLink Interface"->{
    Cell[15147, 651, 234, 8, 16, "Index",
      CellTags->"MathLink Interface"],
    Cell[42668, 1826, 321, 10, 16, "Index",
      CellTags->"MathLink Interface"],
    Cell[67989, 2882, 234, 8, 70, "Index",
      CellTags->"MathLink Interface"]},
  "MathLink library"->{
    Cell[15384, 661, 234, 8, 16, "Index",
      CellTags->"MathLink library"],
    Cell[68226, 2892, 234, 8, 70, "Index",
      CellTags->"MathLink library"]},
  "MathLink, sample projects"->{
    Cell[15621, 671, 237, 8, 16, "Index",
      CellTags->"MathLink, sample projects"],
    Cell[68463, 2902, 237, 8, 70, "Index",
      CellTags->"MathLink, sample projects"]},
  "MathLink, sample programs"->{
    Cell[15861, 681, 243, 8, 16, "Index",
      CellTags->"MathLink, sample programs"],
    Cell[16107, 691, 192, 6, 16, "IndexSubentry",
      CellTags->"MathLink, sample programs"],
    Cell[16302, 699, 177, 6, 16, "IndexSubentry",
      CellTags->"MathLink, sample programs"],
    Cell[16482, 707, 192, 6, 16, "IndexSubentry",
      CellTags->"MathLink, sample programs"],
    Cell[42992, 1838, 329, 10, 16, "Index",
      CellTags->"MathLink, sample programs"],
    Cell[43324, 1850, 264, 8, 16, "IndexSubentry",
      CellTags->"MathLink, sample programs"],
    Cell[43591, 1860, 269, 8, 16, "IndexSubentry",
      CellTags->"MathLink, sample programs"],
    Cell[68703, 2912, 243, 8, 70, "Index",
      CellTags->"MathLink, sample programs"],
    Cell[68949, 2922, 192, 6, 70, "IndexSubentry",
      CellTags->"MathLink, sample programs"],
    Cell[69144, 2930, 177, 6, 70, "IndexSubentry",
      CellTags->"MathLink, sample programs"],
    Cell[69324, 2938, 192, 6, 70, "IndexSubentry",
      CellTags->"MathLink, sample programs"]},
  "Metrowerks CodeWarrior C/C++"->{
    Cell[16677, 715, 209, 6, 16, "Index",
      CellTags->"Metrowerks CodeWarrior C/C++"],
    Cell[16889, 723, 265, 9, 16, "IndexSubentry",
      CellTags->"Metrowerks CodeWarrior C/C++"],
    Cell[17157, 734, 272, 9, 16, "IndexSubentry",
      CellTags->"Metrowerks CodeWarrior C/C++"]},
  "Microsoft Visual C/C++"->{
    Cell[17432, 745, 195, 6, 16, "Index",
      CellTags->"Microsoft Visual C/C++"],
    Cell[17630, 753, 257, 9, 16, "IndexSubentry",
      CellTags->"Microsoft Visual C/C++"],
    Cell[17890, 764, 264, 9, 16, "IndexSubentry",
      CellTags->"Microsoft Visual C/C++"]},
  "Microsoft Windows"->{
    Cell[18157, 775, 249, 9, 16, "Index",
      CellTags->"Microsoft Windows"]},
  "MLBegin"->{
    Cell[18409, 786, 202, 7, 16, "Index",
      CellTags->"MLBegin"],
    Cell[43863, 1870, 284, 9, 16, "Index",
      CellTags->"MLBegin"],
    Cell[70002, 2970, 202, 7, 70, "Index",
      CellTags->"MLBegin"]},
  "MLBytesToGet"->{
    Cell[18614, 795, 180, 7, 16, "Index",
      CellTags->"MLBytesToGet"],
    Cell[18797, 804, 190, 6, 16, "IndexSubentry",
      CellTags->"MLBytesToGet"],
    Cell[44150, 1881, 262, 9, 16, "Index",
      CellTags->"MLBytesToGet"],
    Cell[44415, 1892, 275, 8, 16, "IndexSubentry",
      CellTags->"MLBytesToGet"],
    Cell[70207, 2979, 180, 7, 70, "Index",
      CellTags->"MLBytesToGet"],
    Cell[70390, 2988, 190, 6, 70, "IndexSubentry",
      CellTags->"MLBytesToGet"]},
  "MLCheckFunction"->{
    Cell[18990, 812, 216, 7, 16, "Index",
      CellTags->"MLCheckFunction"],
    Cell[44693, 1902, 297, 9, 16, "Index",
      CellTags->"MLCheckFunction"],
    Cell[70583, 2996, 216, 7, 70, "Index",
      CellTags->"MLCheckFunction"]},
  "MLConvertUnicodeString"->{
    Cell[19209, 821, 210, 7, 16, "Index",
      CellTags->"MLConvertUnicodeString"],
    Cell[44993, 1913, 282, 9, 16, "Index",
      CellTags->"MLConvertUnicodeString"],
    Cell[70802, 3005, 210, 7, 70, "Index",
      CellTags->"MLConvertUnicodeString"]},
  "MLDisownByteString"->{
    Cell[19422, 830, 198, 7, 16, "Index",
      CellTags->"MLDisownByteString"],
    Cell[45278, 1924, 274, 9, 16, "Index",
      CellTags->"MLDisownByteString"],
    Cell[71015, 3014, 198, 7, 70, "Index",
      CellTags->"MLDisownByteString"]},
  "MLDisownByteSymbol"->{
    Cell[19623, 839, 198, 7, 16, "Index",
      CellTags->"MLDisownByteSymbol"],
    Cell[45555, 1935, 274, 9, 16, "Index",
      CellTags->"MLDisownByteSymbol"],
    Cell[71216, 3023, 198, 7, 70, "Index",
      CellTags->"MLDisownByteSymbol"]},
  "MLDisownUnicodeString"->{
    Cell[19824, 848, 204, 7, 16, "Index",
      CellTags->"MLDisownUnicodeString"],
    Cell[45832, 1946, 280, 9, 16, "Index",
      CellTags->"MLDisownUnicodeString"],
    Cell[71417, 3032, 204, 7, 70, "Index",
      CellTags->"MLDisownUnicodeString"]},
  "MLDisownUnicodeSymbol"->{
    Cell[20031, 857, 204, 7, 16, "Index",
      CellTags->"MLDisownUnicodeSymbol"],
    Cell[46115, 1957, 280, 9, 16, "Index",
      CellTags->"MLDisownUnicodeSymbol"],
    Cell[71624, 3041, 204, 7, 70, "Index",
      CellTags->"MLDisownUnicodeSymbol"]},
  "MLforString"->{
    Cell[20238, 866, 177, 7, 16, "Index",
      CellTags->"MLforString"],
    Cell[46398, 1968, 260, 9, 16, "Index",
      CellTags->"MLforString"],
    Cell[71831, 3050, 177, 7, 70, "Index",
      CellTags->"MLforString"]},
  "MLGetArgCount"->{
    Cell[20418, 875, 231, 7, 16, "Index",
      CellTags->"MLGetArgCount"],
    Cell[46661, 1979, 312, 9, 16, "Index",
      CellTags->"MLGetArgCount"],
    Cell[72011, 3059, 231, 7, 70, "Index",
      CellTags->"MLGetArgCount"]},
  "MLGetByteString"->{
    Cell[20652, 884, 189, 7, 16, "Index",
      CellTags->"MLGetByteString"],
    Cell[20844, 893, 179, 6, 16, "IndexSubentry",
      CellTags->"MLGetByteString"],
    Cell[46976, 1990, 268, 9, 16, "Index",
      CellTags->"MLGetByteString"],
    Cell[47247, 2001, 255, 8, 16, "IndexSubentry",
      CellTags->"MLGetByteString"],
    Cell[72245, 3068, 189, 7, 70, "Index",
      CellTags->"MLGetByteString"],
    Cell[72437, 3077, 179, 6, 70, "IndexSubentry",
      CellTags->"MLGetByteString"]},
  "MLGetByteSymbol"->{
    Cell[21026, 901, 192, 7, 16, "Index",
      CellTags->"MLGetByteSymbol"],
    Cell[47505, 2011, 268, 9, 16, "Index",
      CellTags->"MLGetByteSymbol"],
    Cell[72619, 3085, 192, 7, 70, "Index",
      CellTags->"MLGetByteSymbol"]},
  "MLGetData"->{
    Cell[21221, 910, 174, 7, 16, "Index",
      CellTags->"MLGetData"],
    Cell[21398, 919, 191, 6, 16, "IndexSubentry",
      CellTags->"MLGetData"],
    Cell[47776, 2022, 256, 9, 16, "Index",
      CellTags->"MLGetData"],
    Cell[48035, 2033, 276, 8, 16, "IndexSubentry",
      CellTags->"MLGetData"],
    Cell[48314, 2043, 263, 8, 16, "IndexSubentry",
      CellTags->"MLGetData"],
    Cell[72814, 3094, 174, 7, 70, "Index",
      CellTags->"MLGetData"],
    Cell[72991, 3103, 191, 6, 70, "IndexSubentry",
      CellTags->"MLGetData"]},
  "MLGetFunction"->{
    Cell[21592, 927, 212, 7, 16, "Index",
      CellTags->"MLGetFunction"],
    Cell[48580, 2053, 293, 9, 16, "Index",
      CellTags->"MLGetFunction"],
    Cell[73185, 3111, 212, 7, 70, "Index",
      CellTags->"MLGetFunction"]},
  "MLGetString"->{
    Cell[21807, 936, 211, 7, 16, "Index",
      CellTags->"MLGetString"],
    Cell[48876, 2064, 298, 9, 16, "Index",
      CellTags->"MLGetString"],
    Cell[73400, 3120, 211, 7, 70, "Index",
      CellTags->"MLGetString"]},
  "MLGetUnicodeString"->{
    Cell[22021, 945, 198, 7, 16, "Index",
      CellTags->"MLGetUnicodeString"],
    Cell[22222, 954, 182, 6, 16, "IndexSubentry",
      CellTags->"MLGetUnicodeString"],
    Cell[49177, 2075, 274, 9, 16, "Index",
      CellTags->"MLGetUnicodeString"],
    Cell[49454, 2086, 258, 8, 16, "IndexSubentry",
      CellTags->"MLGetUnicodeString"],
    Cell[73614, 3129, 198, 7, 70, "Index",
      CellTags->"MLGetUnicodeString"],
    Cell[73815, 3138, 182, 6, 70, "IndexSubentry",
      CellTags->"MLGetUnicodeString"]},
  "MLGetUnicodeSymbol"->{
    Cell[22407, 962, 198, 7, 16, "Index",
      CellTags->"MLGetUnicodeSymbol"],
    Cell[49715, 2096, 274, 9, 16, "Index",
      CellTags->"MLGetUnicodeSymbol"],
    Cell[74000, 3146, 198, 7, 70, "Index",
      CellTags->"MLGetUnicodeSymbol"]},
  "MLInitialize"->{
    Cell[22608, 971, 212, 7, 16, "Index",
      CellTags->"MLInitialize"],
    Cell[49992, 2107, 294, 9, 16, "Index",
      CellTags->"MLInitialize"],
    Cell[74201, 3155, 212, 7, 70, "Index",
      CellTags->"MLInitialize"]},
  "MLNextCharacter"->{
    Cell[22823, 980, 189, 7, 16, "Index",
      CellTags->"MLNextCharacter"],
    Cell[50289, 2118, 268, 9, 16, "Index",
      CellTags->"MLNextCharacter"],
    Cell[74416, 3164, 189, 7, 70, "Index",
      CellTags->"MLNextCharacter"]},
  "MLPutByteString"->{
    Cell[23015, 989, 192, 7, 16, "Index",
      CellTags->"MLPutByteString"],
    Cell[50560, 2129, 268, 9, 16, "Index",
      CellTags->"MLPutByteString"],
    Cell[74885, 3184, 192, 7, 70, "Index",
      CellTags->"MLPutByteString"]},
  "MLPutByteSymbol"->{
    Cell[23210, 998, 192, 7, 16, "Index",
      CellTags->"MLPutByteSymbol"],
    Cell[50831, 2140, 268, 9, 16, "Index",
      CellTags->"MLPutByteSymbol"],
    Cell[75080, 3193, 192, 7, 70, "Index",
      CellTags->"MLPutByteSymbol"]},
  "MLPutCharToString"->{
    Cell[23405, 1007, 195, 7, 16, "Index",
      CellTags->"MLPutCharToString"],
    Cell[51102, 2151, 272, 9, 16, "Index",
      CellTags->"MLPutCharToString"],
    Cell[75275, 3202, 195, 7, 70, "Index",
      CellTags->"MLPutCharToString"]},
  "MLPutData"->{
    Cell[23603, 1016, 174, 7, 16, "Index",
      CellTags->"MLPutData"],
    Cell[51377, 2162, 256, 9, 16, "Index",
      CellTags->"MLPutData"],
    Cell[75473, 3211, 174, 7, 70, "Index",
      CellTags->"MLPutData"]},
  "MLPutFunction"->{
    Cell[23780, 1025, 183, 7, 16, "Index",
      CellTags->"MLPutFunction"],
    Cell[51636, 2173, 264, 9, 16, "Index",
      CellTags->"MLPutFunction"],
    Cell[75650, 3220, 183, 7, 70, "Index",
      CellTags->"MLPutFunction"]},
  "MLPutNext"->{
    Cell[23966, 1034, 171, 7, 16, "Index",
      CellTags->"MLPutNext"],
    Cell[51903, 2184, 256, 9, 16, "Index",
      CellTags->"MLPutNext"],
    Cell[75836, 3229, 171, 7, 70, "Index",
      CellTags->"MLPutNext"]},
  "MLPutSize"->{
    Cell[24140, 1043, 174, 7, 16, "Index",
      CellTags->"MLPutSize"],
    Cell[52162, 2195, 256, 9, 16, "Index",
      CellTags->"MLPutSize"],
    Cell[76010, 3238, 174, 7, 70, "Index",
      CellTags->"MLPutSize"]},
  "MLPutString"->{
    Cell[24317, 1052, 211, 7, 16, "Index",
      CellTags->"MLPutString"],
    Cell[52421, 2206, 298, 9, 16, "Index",
      CellTags->"MLPutString"],
    Cell[76187, 3247, 211, 7, 70, "Index",
      CellTags->"MLPutString"]},
  "MLPutUnicodeString"->{
    Cell[24531, 1061, 198, 7, 16, "Index",
      CellTags->"MLPutUnicodeString"],
    Cell[52722, 2217, 274, 9, 16, "Index",
      CellTags->"MLPutUnicodeString"],
    Cell[76401, 3256, 198, 7, 70, "Index",
      CellTags->"MLPutUnicodeString"]},
  "MLPutUnicodeSymbol"->{
    Cell[24732, 1070, 198, 7, 16, "Index",
      CellTags->"MLPutUnicodeSymbol"],
    Cell[52999, 2228, 274, 9, 16, "Index",
      CellTags->"MLPutUnicodeSymbol"],
    Cell[76602, 3265, 198, 7, 70, "Index",
      CellTags->"MLPutUnicodeSymbol"]},
  "MLStringChar"->{
    Cell[24933, 1079, 173, 6, 16, "Index",
      CellTags->"MLStringChar"],
    Cell[76803, 3274, 173, 6, 70, "Index",
      CellTags->"MLStringChar"]},
  "MLStringPosition"->{
    Cell[25109, 1087, 187, 7, 16, "Index",
      CellTags->"MLStringPosition"],
    Cell[53276, 2239, 270, 9, 16, "Index",
      CellTags->"MLStringPosition"],
    Cell[76979, 3282, 187, 7, 70, "Index",
      CellTags->"MLStringPosition"]},
  "mprep"->{
    Cell[25299, 1096, 165, 7, 16, "Index",
      CellTags->"mprep"],
    Cell[25467, 1105, 164, 6, 16, "IndexSubentry",
      CellTags->"mprep"],
    Cell[25634, 1113, 163, 6, 16, "IndexSubentry",
      CellTags->"mprep"],
    Cell[53549, 2250, 243, 9, 16, "Index",
      CellTags->"mprep"],
    Cell[53795, 2261, 251, 8, 16, "IndexSubentry",
      CellTags->"mprep"],
    Cell[54049, 2271, 241, 8, 16, "IndexSubentry",
      CellTags->"mprep"],
    Cell[77169, 3291, 165, 7, 70, "Index",
      CellTags->"mprep"],
    Cell[77337, 3300, 164, 6, 70, "IndexSubentry",
      CellTags->"mprep"],
    Cell[77504, 3308, 163, 6, 70, "IndexSubentry",
      CellTags->"mprep"]},
  "Preprocess MathLink programs"->{
    Cell[25800, 1121, 261, 9, 16, "Index",
      CellTags->"Preprocess MathLink programs"],
    Cell[54605, 2294, 333, 11, 16, "Index",
      CellTags->"Preprocess MathLink programs"],
    Cell[77848, 3324, 261, 9, 70, "Index",
      CellTags->"Preprocess MathLink programs"]},
  "Programming languages"->{
    Cell[26064, 1132, 221, 6, 16, "Index",
      CellTags->"Programming languages"]},
  "Programs"->{
    Cell[26288, 1140, 218, 9, 16, "Index",
      CellTags->"Programs"],
    Cell[26509, 1151, 213, 9, 16, "IndexSubentry",
      CellTags->"Programs"],
    Cell[54941, 2307, 305, 11, 16, "Index",
      CellTags->"Programs"],
    Cell[55249, 2320, 300, 11, 16, "IndexSubentry",
      CellTags->"Programs"],
    Cell[78112, 3335, 218, 9, 70, "Index",
      CellTags->"Programs"],
    Cell[78333, 3346, 213, 9, 70, "IndexSubentry",
      CellTags->"Programs"]},
  "Projects"->{
    Cell[26725, 1162, 225, 9, 16, "Index",
      CellTags->"Projects"],
    Cell[78549, 3357, 225, 9, 70, "Index",
      CellTags->"Projects"]},
  "Protocol"->{
    Cell[26953, 1173, 223, 9, 16, "Index",
      CellTags->"Protocol"],
    Cell[55552, 2333, 297, 11, 16, "Index",
      CellTags->"Protocol"],
    Cell[78777, 3368, 223, 9, 70, "Index",
      CellTags->"Protocol"]},
  "Running MathLink programs"->{
    Cell[27179, 1184, 231, 9, 16, "Index",
      CellTags->"Running MathLink programs"],
    Cell[55852, 2346, 318, 11, 16, "Index",
      CellTags->"Running MathLink programs"],
    Cell[79276, 3390, 231, 9, 70, "Index",
      CellTags->"Running MathLink programs"]},
  "Sample projects of MathLink"->{
    Cell[27413, 1195, 247, 9, 16, "Index",
      CellTags->"Sample projects of MathLink"],
    Cell[79510, 3401, 247, 9, 70, "Index",
      CellTags->"Sample projects of MathLink"]},
  "Shared libraries"->{
    Cell[27663, 1206, 248, 9, 16, "Index",
      CellTags->"Shared libraries"],
    Cell[27914, 1217, 202, 6, 16, "IndexSubentry",
      CellTags->"Shared libraries"],
    Cell[79760, 3412, 248, 9, 70, "Index",
      CellTags->"Shared libraries"],
    Cell[80011, 3423, 202, 6, 70, "IndexSubentry",
      CellTags->"Shared libraries"]},
  "Special characters"->{
    Cell[28119, 1225, 241, 9, 16, "Index",
      CellTags->"Special characters"],
    Cell[56173, 2359, 328, 11, 16, "Index",
      CellTags->"Special characters"],
    Cell[80216, 3431, 241, 9, 70, "Index",
      CellTags->"Special characters"]},
  "Strings"->{
    Cell[28363, 1236, 234, 9, 16, "Index",
      CellTags->"Strings"],
    Cell[56504, 2372, 321, 11, 16, "Index",
      CellTags->"Strings"],
    Cell[80460, 3442, 234, 9, 70, "Index",
      CellTags->"Strings"]},
  "Subsidiary processes"->{
    Cell[28600, 1247, 200, 6, 16, "Index",
      CellTags->"Subsidiary processes"],
    Cell[80697, 3453, 200, 6, 70, "Index",
      CellTags->"Subsidiary processes"]},
  "Symantec C/C++"->{
    Cell[28803, 1255, 178, 6, 16, "Index",
      CellTags->"Symantec C/C++"],
    Cell[28984, 1263, 248, 9, 16, "IndexSubentry",
      CellTags->"Symantec C/C++"],
    Cell[29235, 1274, 255, 9, 16, "IndexSubentry",
      CellTags->"Symantec C/C++"]},
  "Symbols"->{
    Cell[29493, 1285, 219, 9, 16, "Index",
      CellTags->"Symbols"],
    Cell[56828, 2385, 306, 11, 16, "Index",
      CellTags->"Symbols"],
    Cell[80900, 3461, 219, 9, 70, "Index",
      CellTags->"Symbols"]},
  "TCP protocol"->{
    Cell[29715, 1296, 177, 7, 16, "Index",
      CellTags->"TCP protocol"],
    Cell[29895, 1305, 225, 9, 16, "IndexSubentry",
      CellTags->"TCP protocol"],
    Cell[57137, 2398, 305, 11, 16, "Index",
      CellTags->"TCP protocol"],
    Cell[81122, 3472, 171, 6, 70, "Index",
      CellTags->"TCP protocol"]},
  "Template programs"->{
    Cell[30123, 1316, 186, 7, 16, "Index",
      CellTags->"Template programs"],
    Cell[57445, 2411, 273, 9, 16, "Index",
      CellTags->"Template programs"],
    Cell[81296, 3480, 186, 7, 70, "Index",
      CellTags->"Template programs"]},
  "Unicode"->{
    Cell[30312, 1325, 227, 9, 16, "Index",
      CellTags->"Unicode"],
    Cell[57721, 2422, 314, 11, 16, "Index",
      CellTags->"Unicode"],
    Cell[81485, 3489, 227, 9, 70, "Index",
      CellTags->"Unicode"]},
  "Uninstall"->{
    Cell[30542, 1336, 184, 7, 16, "Index",
      CellTags->"Uninstall"],
    Cell[58038, 2435, 261, 9, 16, "Index",
      CellTags->"Uninstall"],
    Cell[81715, 3500, 184, 7, 70, "Index",
      CellTags->"Uninstall"]},
  "Visual C/C++"->{
    Cell[30729, 1345, 175, 6, 16, "Index",
      CellTags->"Visual C/C++"],
    Cell[30907, 1353, 247, 9, 16, "IndexSubentry",
      CellTags->"Visual C/C++"],
    Cell[31157, 1364, 254, 9, 16, "IndexSubentry",
      CellTags->"Visual C/C++"]},
  "Watcom C/C++"->{
    Cell[31414, 1375, 172, 6, 16, "Index",
      CellTags->"Watcom C/C++"],
    Cell[31589, 1383, 244, 9, 16, "IndexSubentry",
      CellTags->"Watcom C/C++"],
    Cell[31836, 1394, 251, 9, 16, "IndexSubentry",
      CellTags->"Watcom C/C++"]},
  "libML.a"->{
    Cell[38966, 1682, 247, 9, 16, "Index",
      CellTags->"libML.a"],
    Cell[64815, 2741, 175, 6, 16, "Index",
      CellTags->"libML.a"]},
  "Pipes protocol"->{
    Cell[54293, 2281, 309, 11, 16, "Index",
      CellTags->"Pipes protocol"],
    Cell[77670, 3316, 175, 6, 70, "Index",
      CellTags->"Pipes protocol"]},
  "ANSI prototypes"->{
    Cell[58703, 2468, 280, 9, 16, "Index",
      CellTags->"ANSI prototypes"]},
  "mcc"->{
    Cell[69519, 2946, 153, 6, 70, "Index",
      CellTags->"mcc"],
    Cell[69675, 2954, 162, 6, 70, "IndexSubentry",
      CellTags->"mcc"],
    Cell[69840, 2962, 159, 6, 70, "IndexSubentry",
      CellTags->"mcc"]},
  "MLPROTOTYPES"->{
    Cell[74608, 3173, 274, 9, 70, "Index",
      CellTags->"MLPROTOTYPES"]},
  "Prototypes"->{
    Cell[79003, 3379, 270, 9, 70, "Index",
      CellTags->"Prototypes"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 82583, 3527},
  {"addtwo", 82684, 3530},
  {"API", 83134, 3543},
  {"ASCII", 83346, 3550},
  {"Borland C/C++", 83573, 3557},
  {"Building MathLink programs", 83848, 3564},
  {"Calling Mathematica from external programs", 84168, 3571},
  {"C Compilers", 84505, 3578},
  {"C source code", 84832, 3587},
  {"Character codes", 85008, 3592},
  {"Character encoding", 85271, 3599},
  {"Child processes", 85540, 3606},
  {"CodeWarrior", 85795, 3613},
  {"Compatibility", 86052, 3620},
  {"Compiling MathLink programs", 86318, 3627},
  {"Console programs", 86615, 3634},
  {"Developer kits, MathLink", 87148, 3647},
  {"Developer's Kit", 87346, 3652},
  {"Development environments", 87615, 3659},
  {"Dynamically linked libraries", 87832, 3664},
  {"Evaluating Mathematica expressions", 87965, 3667},
  {"External functions", 88285, 3674},
  {"factor", 88544, 3681},
  {"Filemap protocol", 89009, 3694},
  {"Generated files", 89197, 3699},
  {"Header files", 89718, 3712},
  {"IDE", 89956, 3719},
  {"Include files", 90118, 3724},
  {"Install", 90364, 3731},
  {"Installing MathLink", 90604, 3738},
  {"Launching programs", 90880, 3745},
  {"Library", 91059, 3750},
  {"Link protocols", 91294, 3757},
  {"Link Protocols", 91551, 3764},
  {"Local protocol", 91659, 3767},
  {"Local Protocol", 91916, 3774},
  {"MathLink", 92018, 3777},
  {"MathLink, compatibility", 93699, 3820},
  {"MathLink Developer's Kits", 94088, 3829},
  {"mathlink.h", 94374, 3836},
  {"MathLink files", 94618, 3843},
  {"MathLink Interface", 94800, 3848},
  {"MathLink library", 95071, 3855},
  {"MathLink, sample projects", 95264, 3860},
  {"MathLink, sample programs", 95475, 3865},
  {"Metrowerks CodeWarrior C/C++", 96552, 3888},
  {"Microsoft Visual C/C++", 96872, 3895},
  {"Microsoft Windows", 97169, 3902},
  {"MLBegin", 97265, 3905},
  {"MLBytesToGet", 97498, 3912},
  {"MLCheckFunction", 98000, 3925},
  {"MLConvertUnicodeString", 98267, 3932},
  {"MLDisownByteString", 98551, 3939},
  {"MLDisownByteSymbol", 98823, 3946},
  {"MLDisownUnicodeString", 99098, 3953},
  {"MLDisownUnicodeSymbol", 99382, 3960},
  {"MLforString", 99656, 3967},
  {"MLGetArgCount", 99902, 3974},
  {"MLGetByteString", 100156, 3981},
  {"MLGetByteSymbol", 100676, 3994},
  {"MLGetData", 100930, 4001},
  {"MLGetFunction", 101493, 4016},
  {"MLGetString", 101743, 4023},
  {"MLGetUnicodeString", 101994, 4030},
  {"MLGetUnicodeSymbol", 102535, 4043},
  {"MLInitialize", 102801, 4050},
  {"MLNextCharacter", 103052, 4057},
  {"MLPutByteString", 103312, 4064},
  {"MLPutByteSymbol", 103572, 4071},
  {"MLPutCharToString", 103834, 4078},
  {"MLPutData", 104095, 4085},
  {"MLPutFunction", 104336, 4092},
  {"MLPutNext", 104585, 4099},
  {"MLPutSize", 104822, 4106},
  {"MLPutString", 105061, 4113},
  {"MLPutUnicodeString", 105313, 4120},
  {"MLPutUnicodeSymbol", 105586, 4127},
  {"MLStringChar", 105853, 4134},
  {"MLStringPosition", 106030, 4139},
  {"mprep", 106284, 4146},
  {"Preprocess MathLink programs", 106990, 4165},
  {"Programming languages", 107297, 4172},
  {"Programs", 107399, 4175},
  {"Projects", 107874, 4188},
  {"Protocol", 108035, 4193},
  {"Running MathLink programs", 108286, 4200},
  {"Sample projects of MathLink", 108590, 4207},
  {"Shared libraries", 108797, 4212},
  {"Special characters", 109160, 4221},
  {"Strings", 109423, 4228},
  {"Subsidiary processes", 109666, 4235},
  {"Symantec C/C++", 109857, 4240},
  {"Symbols", 110123, 4247},
  {"TCP protocol", 110358, 4254},
  {"Template programs", 110697, 4263},
  {"Unicode", 110956, 4270},
  {"Uninstall", 111188, 4277},
  {"Visual C/C++", 111428, 4284},
  {"Watcom C/C++", 111693, 4291},
  {"libML.a", 111953, 4298},
  {"Pipes protocol", 112118, 4303},
  {"ANSI prototypes", 112299, 4308},
  {"mcc", 112390, 4311},
  {"MLPROTOTYPES", 112628, 4318},
  {"Prototypes", 112723, 4321}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 139, 5, 41, "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[CellGroupData[{
Cell[1918, 60, 32, 0, 34, "Subsubsection"],
Cell[1953, 62, 164, 7, 16, "Index",
  CellTags->"addtwo"],
Cell[2120, 71, 165, 6, 16, "IndexSubentry",
  CellTags->"addtwo"],
Cell[2288, 79, 169, 7, 16, "Index",
  CellTags->"API"],
Cell[2460, 88, 215, 9, 16, "Index",
  CellTags->"ASCII"],
Cell[2678, 99, 175, 6, 16, "Index",
  CellTags->"Borland C/C++"],
Cell[2856, 107, 246, 9, 16, "IndexSubentry",
  CellTags->"Borland C/C++"],
Cell[3105, 118, 253, 9, 16, "IndexSubentry",
  CellTags->"Borland C/C++"],
Cell[3361, 129, 235, 9, 16, "Index",
  CellTags->"Building MathLink programs"],
Cell[3599, 140, 291, 9, 16, "Index",
  CellTags->"Calling Mathematica from external programs"],
Cell[3893, 151, 234, 9, 16, "Index",
  CellTags->"C Compilers"],
Cell[4130, 162, 225, 9, 16, "IndexSubentry",
  CellTags->"C Compilers"],
Cell[4358, 173, 238, 9, 16, "Index",
  CellTags->"C source code"],
Cell[4599, 184, 235, 9, 16, "Index",
  CellTags->"Character codes"],
Cell[4837, 195, 241, 9, 16, "Index",
  CellTags->"Character encoding"],
Cell[5081, 206, 196, 7, 16, "Index",
  CellTags->"Child processes"],
Cell[5280, 215, 175, 6, 16, "Index",
  CellTags->"CodeWarrior"],
Cell[5458, 223, 248, 9, 16, "IndexSubentry",
  CellTags->"CodeWarrior"],
Cell[5709, 234, 255, 9, 16, "IndexSubentry",
  CellTags->"CodeWarrior"],
Cell[5967, 245, 246, 9, 16, "Index",
  CellTags->"Compatibility"],
Cell[6216, 256, 237, 9, 16, "Index",
  CellTags->"Compiling MathLink programs"],
Cell[6456, 267, 191, 7, 16, "Index",
  CellTags->"Console programs"],
Cell[6650, 276, 182, 6, 16, "IndexSubentry",
  CellTags->"Console programs"],
Cell[6835, 284, 256, 9, 16, "Index",
  CellTags->"Developer kits, MathLink"],
Cell[7094, 295, 248, 9, 16, "Index",
  CellTags->"Developer's Kit"],
Cell[7345, 306, 259, 9, 16, "Index",
  CellTags->"Development environments"],
Cell[7607, 317, 238, 9, 16, "IndexSubentry",
  CellTags->"Development environments"],
Cell[7848, 328, 272, 9, 16, "Index",
  CellTags->"Dynamically linked libraries"],
Cell[8123, 339, 275, 9, 16, "Index",
  CellTags->"Evaluating Mathematica expressions"],
Cell[8401, 350, 202, 7, 16, "Index",
  CellTags->"External functions"],
Cell[8606, 359, 164, 7, 16, "Index",
  CellTags->"factor"],
Cell[8773, 368, 165, 6, 16, "IndexSubentry",
  CellTags->"factor"],
Cell[8941, 376, 183, 6, 16, "Index",
  CellTags->"Filemap protocol"],
Cell[9127, 384, 154, 3, 15, "IndexSubentry",
  CellTags->"Filemap protocol"],
Cell[9284, 389, 186, 6, 16, "Index",
  CellTags->"Generated files"],
Cell[9473, 397, 174, 6, 16, "IndexSubentry",
  CellTags->"Generated files"],
Cell[9650, 405, 179, 6, 16, "IndexSubentry",
  CellTags->"Generated files"],
Cell[9832, 413, 196, 7, 16, "Index",
  CellTags->"Header files"],
Cell[10031, 422, 217, 9, 16, "Index",
  CellTags->"IDE"],
Cell[10251, 433, 217, 9, 16, "IndexSubentry",
  CellTags->"IDE"],
Cell[10471, 444, 198, 7, 16, "Index",
  CellTags->"Include files"],
Cell[10672, 453, 174, 6, 16, "Index",
  CellTags->"Install"],
Cell[10849, 461, 225, 9, 16, "Index",
  CellTags->"Installing MathLink"],
Cell[11077, 472, 196, 6, 16, "Index",
  CellTags->"Launching programs"],
Cell[11276, 480, 232, 9, 16, "Index",
  CellTags->"Library"],
Cell[11511, 491, 239, 9, 16, "Index",
  CellTags->"Link protocols"],
Cell[11753, 502, 237, 9, 16, "IndexSubentry",
  CellTags->"Link Protocols"],
Cell[11993, 513, 237, 9, 16, "Index",
  CellTags->"Local protocol"],
Cell[12233, 524, 227, 9, 16, "IndexSubentry",
  CellTags->"Local Protocol"],
Cell[12463, 535, 212, 8, 16, "Index",
  CellTags->"MathLink"],
Cell[12678, 545, 192, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[12873, 553, 175, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[13051, 561, 191, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[13245, 569, 177, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[13425, 577, 186, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[13614, 585, 234, 9, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[13851, 596, 166, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[14020, 604, 269, 8, 16, "Index",
  CellTags->"MathLink, compatibility"],
Cell[14292, 614, 181, 6, 16, "IndexSubentry",
  CellTags->"MathLink, compatibility"],
Cell[14476, 622, 252, 8, 16, "Index",
  CellTags->"MathLink Developer's Kits"],
Cell[14731, 632, 180, 7, 16, "Index",
  CellTags->"mathlink.h"],
Cell[14914, 641, 230, 8, 16, "Index",
  CellTags->"MathLink files"],
Cell[15147, 651, 234, 8, 16, "Index",
  CellTags->"MathLink Interface"],
Cell[15384, 661, 234, 8, 16, "Index",
  CellTags->"MathLink library"],
Cell[15621, 671, 237, 8, 16, "Index",
  CellTags->"MathLink, sample projects"],
Cell[15861, 681, 243, 8, 16, "Index",
  CellTags->"MathLink, sample programs"],
Cell[16107, 691, 192, 6, 16, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[16302, 699, 177, 6, 16, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[16482, 707, 192, 6, 16, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[16677, 715, 209, 6, 16, "Index",
  CellTags->"Metrowerks CodeWarrior C/C++"],
Cell[16889, 723, 265, 9, 16, "IndexSubentry",
  CellTags->"Metrowerks CodeWarrior C/C++"],
Cell[17157, 734, 272, 9, 16, "IndexSubentry",
  CellTags->"Metrowerks CodeWarrior C/C++"],
Cell[17432, 745, 195, 6, 16, "Index",
  CellTags->"Microsoft Visual C/C++"],
Cell[17630, 753, 257, 9, 16, "IndexSubentry",
  CellTags->"Microsoft Visual C/C++"],
Cell[17890, 764, 264, 9, 16, "IndexSubentry",
  CellTags->"Microsoft Visual C/C++"],
Cell[18157, 775, 249, 9, 16, "Index",
  CellTags->"Microsoft Windows"],
Cell[18409, 786, 202, 7, 16, "Index",
  CellTags->"MLBegin"],
Cell[18614, 795, 180, 7, 16, "Index",
  CellTags->"MLBytesToGet"],
Cell[18797, 804, 190, 6, 16, "IndexSubentry",
  CellTags->"MLBytesToGet"],
Cell[18990, 812, 216, 7, 16, "Index",
  CellTags->"MLCheckFunction"],
Cell[19209, 821, 210, 7, 16, "Index",
  CellTags->"MLConvertUnicodeString"],
Cell[19422, 830, 198, 7, 16, "Index",
  CellTags->"MLDisownByteString"],
Cell[19623, 839, 198, 7, 16, "Index",
  CellTags->"MLDisownByteSymbol"],
Cell[19824, 848, 204, 7, 16, "Index",
  CellTags->"MLDisownUnicodeString"],
Cell[20031, 857, 204, 7, 16, "Index",
  CellTags->"MLDisownUnicodeSymbol"],
Cell[20238, 866, 177, 7, 16, "Index",
  CellTags->"MLforString"],
Cell[20418, 875, 231, 7, 16, "Index",
  CellTags->"MLGetArgCount"],
Cell[20652, 884, 189, 7, 16, "Index",
  CellTags->"MLGetByteString"],
Cell[20844, 893, 179, 6, 16, "IndexSubentry",
  CellTags->"MLGetByteString"],
Cell[21026, 901, 192, 7, 16, "Index",
  CellTags->"MLGetByteSymbol"],
Cell[21221, 910, 174, 7, 16, "Index",
  CellTags->"MLGetData"],
Cell[21398, 919, 191, 6, 16, "IndexSubentry",
  CellTags->"MLGetData"],
Cell[21592, 927, 212, 7, 16, "Index",
  CellTags->"MLGetFunction"],
Cell[21807, 936, 211, 7, 16, "Index",
  CellTags->"MLGetString"],
Cell[22021, 945, 198, 7, 16, "Index",
  CellTags->"MLGetUnicodeString"],
Cell[22222, 954, 182, 6, 16, "IndexSubentry",
  CellTags->"MLGetUnicodeString"],
Cell[22407, 962, 198, 7, 16, "Index",
  CellTags->"MLGetUnicodeSymbol"],
Cell[22608, 971, 212, 7, 16, "Index",
  CellTags->"MLInitialize"],
Cell[22823, 980, 189, 7, 16, "Index",
  CellTags->"MLNextCharacter"],
Cell[23015, 989, 192, 7, 16, "Index",
  CellTags->"MLPutByteString"],
Cell[23210, 998, 192, 7, 16, "Index",
  CellTags->"MLPutByteSymbol"],
Cell[23405, 1007, 195, 7, 16, "Index",
  CellTags->"MLPutCharToString"],
Cell[23603, 1016, 174, 7, 16, "Index",
  CellTags->"MLPutData"],
Cell[23780, 1025, 183, 7, 16, "Index",
  CellTags->"MLPutFunction"],
Cell[23966, 1034, 171, 7, 16, "Index",
  CellTags->"MLPutNext"],
Cell[24140, 1043, 174, 7, 16, "Index",
  CellTags->"MLPutSize"],
Cell[24317, 1052, 211, 7, 16, "Index",
  CellTags->"MLPutString"],
Cell[24531, 1061, 198, 7, 16, "Index",
  CellTags->"MLPutUnicodeString"],
Cell[24732, 1070, 198, 7, 16, "Index",
  CellTags->"MLPutUnicodeSymbol"],
Cell[24933, 1079, 173, 6, 16, "Index",
  CellTags->"MLStringChar"],
Cell[25109, 1087, 187, 7, 16, "Index",
  CellTags->"MLStringPosition"],
Cell[25299, 1096, 165, 7, 16, "Index",
  CellTags->"mprep"],
Cell[25467, 1105, 164, 6, 16, "IndexSubentry",
  CellTags->"mprep"],
Cell[25634, 1113, 163, 6, 16, "IndexSubentry",
  CellTags->"mprep"],
Cell[25800, 1121, 261, 9, 16, "Index",
  CellTags->"Preprocess MathLink programs"],
Cell[26064, 1132, 221, 6, 16, "Index",
  CellTags->"Programming languages"],
Cell[26288, 1140, 218, 9, 16, "Index",
  CellTags->"Programs"],
Cell[26509, 1151, 213, 9, 16, "IndexSubentry",
  CellTags->"Programs"],
Cell[26725, 1162, 225, 9, 16, "Index",
  CellTags->"Projects"],
Cell[26953, 1173, 223, 9, 16, "Index",
  CellTags->"Protocol"],
Cell[27179, 1184, 231, 9, 16, "Index",
  CellTags->"Running MathLink programs"],
Cell[27413, 1195, 247, 9, 16, "Index",
  CellTags->"Sample projects of MathLink"],
Cell[27663, 1206, 248, 9, 16, "Index",
  CellTags->"Shared libraries"],
Cell[27914, 1217, 202, 6, 16, "IndexSubentry",
  CellTags->"Shared libraries"],
Cell[28119, 1225, 241, 9, 16, "Index",
  CellTags->"Special characters"],
Cell[28363, 1236, 234, 9, 16, "Index",
  CellTags->"Strings"],
Cell[28600, 1247, 200, 6, 16, "Index",
  CellTags->"Subsidiary processes"],
Cell[28803, 1255, 178, 6, 16, "Index",
  CellTags->"Symantec C/C++"],
Cell[28984, 1263, 248, 9, 16, "IndexSubentry",
  CellTags->"Symantec C/C++"],
Cell[29235, 1274, 255, 9, 16, "IndexSubentry",
  CellTags->"Symantec C/C++"],
Cell[29493, 1285, 219, 9, 16, "Index",
  CellTags->"Symbols"],
Cell[29715, 1296, 177, 7, 16, "Index",
  CellTags->"TCP protocol"],
Cell[29895, 1305, 225, 9, 16, "IndexSubentry",
  CellTags->"TCP protocol"],
Cell[30123, 1316, 186, 7, 16, "Index",
  CellTags->"Template programs"],
Cell[30312, 1325, 227, 9, 16, "Index",
  CellTags->"Unicode"],
Cell[30542, 1336, 184, 7, 16, "Index",
  CellTags->"Uninstall"],
Cell[30729, 1345, 175, 6, 16, "Index",
  CellTags->"Visual C/C++"],
Cell[30907, 1353, 247, 9, 16, "IndexSubentry",
  CellTags->"Visual C/C++"],
Cell[31157, 1364, 254, 9, 16, "IndexSubentry",
  CellTags->"Visual C/C++"],
Cell[31414, 1375, 172, 6, 16, "Index",
  CellTags->"Watcom C/C++"],
Cell[31589, 1383, 244, 9, 16, "IndexSubentry",
  CellTags->"Watcom C/C++"],
Cell[31836, 1394, 251, 9, 16, "IndexSubentry",
  CellTags->"Watcom C/C++"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32124, 1408, 33, 0, 34, "Subsubsection"],
Cell[32160, 1410, 251, 9, 16, "Index",
  CellTags->"addtwo"],
Cell[32414, 1421, 242, 8, 16, "IndexSubentry",
  CellTags->"addtwo"],
Cell[32659, 1431, 256, 9, 16, "Index",
  CellTags->"API"],
Cell[32918, 1442, 302, 11, 16, "Index",
  CellTags->"ASCII"],
Cell[33223, 1455, 322, 11, 16, "Index",
  CellTags->"Building MathLink programs"],
Cell[33548, 1468, 368, 11, 16, "Index",
  CellTags->"Calling Mathematica from external programs"],
Cell[33919, 1481, 321, 11, 16, "Index",
  CellTags->"C Compilers"],
Cell[34243, 1494, 322, 11, 16, "Index",
  CellTags->"Character codes"],
Cell[34568, 1507, 328, 11, 16, "Index",
  CellTags->"Character encoding"],
Cell[34899, 1520, 273, 9, 16, "Index",
  CellTags->"Child processes"],
Cell[35175, 1531, 333, 11, 16, "Index",
  CellTags->"Compatibility"],
Cell[35511, 1544, 324, 11, 16, "Index",
  CellTags->"Compiling MathLink programs"],
Cell[35838, 1557, 278, 9, 16, "Index",
  CellTags->"Console programs"],
Cell[36119, 1568, 259, 8, 16, "IndexSubentry",
  CellTags->"Console programs"],
Cell[36381, 1578, 325, 11, 16, "Index",
  CellTags->"Developer's Kit"],
Cell[36709, 1591, 352, 11, 16, "Index",
  CellTags->"Evaluating Mathematica expressions"],
Cell[37064, 1604, 279, 9, 16, "Index",
  CellTags->"External functions"],
Cell[37346, 1615, 251, 9, 16, "Index",
  CellTags->"factor"],
Cell[37600, 1626, 242, 8, 16, "IndexSubentry",
  CellTags->"factor"],
Cell[37845, 1636, 269, 9, 16, "Index",
  CellTags->"Header files"],
Cell[38117, 1647, 271, 9, 16, "Index",
  CellTags->"Include files"],
Cell[38391, 1658, 257, 9, 16, "Index",
  CellTags->"Install"],
Cell[38651, 1669, 312, 11, 16, "Index",
  CellTags->"Installing MathLink"],
Cell[38966, 1682, 247, 9, 16, "Index",
  CellTags->"libML.a"],
Cell[39216, 1693, 260, 8, 16, "Index",
  CellTags->"Library"],
Cell[39479, 1703, 309, 11, 16, "Index",
  CellTags->"Link protocols"],
Cell[39791, 1716, 309, 11, 16, "Index",
  CellTags->"Local protocol"],
Cell[40103, 1729, 299, 10, 16, "Index",
  CellTags->"MathLink"],
Cell[40405, 1741, 264, 8, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[40672, 1751, 269, 8, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[40944, 1761, 264, 8, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[41211, 1771, 253, 8, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[41467, 1781, 271, 8, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[41741, 1791, 335, 10, 16, "Index",
  CellTags->"MathLink, compatibility"],
Cell[42079, 1803, 330, 10, 16, "Index",
  CellTags->"MathLink Developer's Kits"],
Cell[42412, 1815, 253, 9, 16, "Index",
  CellTags->"mathlink.h"],
Cell[42668, 1826, 321, 10, 16, "Index",
  CellTags->"MathLink Interface"],
Cell[42992, 1838, 329, 10, 16, "Index",
  CellTags->"MathLink, sample programs"],
Cell[43324, 1850, 264, 8, 16, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[43591, 1860, 269, 8, 16, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[43863, 1870, 284, 9, 16, "Index",
  CellTags->"MLBegin"],
Cell[44150, 1881, 262, 9, 16, "Index",
  CellTags->"MLBytesToGet"],
Cell[44415, 1892, 275, 8, 16, "IndexSubentry",
  CellTags->"MLBytesToGet"],
Cell[44693, 1902, 297, 9, 16, "Index",
  CellTags->"MLCheckFunction"],
Cell[44993, 1913, 282, 9, 16, "Index",
  CellTags->"MLConvertUnicodeString"],
Cell[45278, 1924, 274, 9, 16, "Index",
  CellTags->"MLDisownByteString"],
Cell[45555, 1935, 274, 9, 16, "Index",
  CellTags->"MLDisownByteSymbol"],
Cell[45832, 1946, 280, 9, 16, "Index",
  CellTags->"MLDisownUnicodeString"],
Cell[46115, 1957, 280, 9, 16, "Index",
  CellTags->"MLDisownUnicodeSymbol"],
Cell[46398, 1968, 260, 9, 16, "Index",
  CellTags->"MLforString"],
Cell[46661, 1979, 312, 9, 16, "Index",
  CellTags->"MLGetArgCount"],
Cell[46976, 1990, 268, 9, 16, "Index",
  CellTags->"MLGetByteString"],
Cell[47247, 2001, 255, 8, 16, "IndexSubentry",
  CellTags->"MLGetByteString"],
Cell[47505, 2011, 268, 9, 16, "Index",
  CellTags->"MLGetByteSymbol"],
Cell[47776, 2022, 256, 9, 16, "Index",
  CellTags->"MLGetData"],
Cell[48035, 2033, 276, 8, 16, "IndexSubentry",
  CellTags->"MLGetData"],
Cell[48314, 2043, 263, 8, 16, "IndexSubentry",
  CellTags->"MLGetData"],
Cell[48580, 2053, 293, 9, 16, "Index",
  CellTags->"MLGetFunction"],
Cell[48876, 2064, 298, 9, 16, "Index",
  CellTags->"MLGetString"],
Cell[49177, 2075, 274, 9, 16, "Index",
  CellTags->"MLGetUnicodeString"],
Cell[49454, 2086, 258, 8, 16, "IndexSubentry",
  CellTags->"MLGetUnicodeString"],
Cell[49715, 2096, 274, 9, 16, "Index",
  CellTags->"MLGetUnicodeSymbol"],
Cell[49992, 2107, 294, 9, 16, "Index",
  CellTags->"MLInitialize"],
Cell[50289, 2118, 268, 9, 16, "Index",
  CellTags->"MLNextCharacter"],
Cell[50560, 2129, 268, 9, 16, "Index",
  CellTags->"MLPutByteString"],
Cell[50831, 2140, 268, 9, 16, "Index",
  CellTags->"MLPutByteSymbol"],
Cell[51102, 2151, 272, 9, 16, "Index",
  CellTags->"MLPutCharToString"],
Cell[51377, 2162, 256, 9, 16, "Index",
  CellTags->"MLPutData"],
Cell[51636, 2173, 264, 9, 16, "Index",
  CellTags->"MLPutFunction"],
Cell[51903, 2184, 256, 9, 16, "Index",
  CellTags->"MLPutNext"],
Cell[52162, 2195, 256, 9, 16, "Index",
  CellTags->"MLPutSize"],
Cell[52421, 2206, 298, 9, 16, "Index",
  CellTags->"MLPutString"],
Cell[52722, 2217, 274, 9, 16, "Index",
  CellTags->"MLPutUnicodeString"],
Cell[52999, 2228, 274, 9, 16, "Index",
  CellTags->"MLPutUnicodeSymbol"],
Cell[53276, 2239, 270, 9, 16, "Index",
  CellTags->"MLStringPosition"],
Cell[53549, 2250, 243, 9, 16, "Index",
  CellTags->"mprep"],
Cell[53795, 2261, 251, 8, 16, "IndexSubentry",
  CellTags->"mprep"],
Cell[54049, 2271, 241, 8, 16, "IndexSubentry",
  CellTags->"mprep"],
Cell[54293, 2281, 309, 11, 16, "Index",
  CellTags->"Pipes protocol"],
Cell[54605, 2294, 333, 11, 16, "Index",
  CellTags->"Preprocess MathLink programs"],
Cell[54941, 2307, 305, 11, 16, "Index",
  CellTags->"Programs"],
Cell[55249, 2320, 300, 11, 16, "IndexSubentry",
  CellTags->"Programs"],
Cell[55552, 2333, 297, 11, 16, "Index",
  CellTags->"Protocol"],
Cell[55852, 2346, 318, 11, 16, "Index",
  CellTags->"Running MathLink programs"],
Cell[56173, 2359, 328, 11, 16, "Index",
  CellTags->"Special characters"],
Cell[56504, 2372, 321, 11, 16, "Index",
  CellTags->"Strings"],
Cell[56828, 2385, 306, 11, 16, "Index",
  CellTags->"Symbols"],
Cell[57137, 2398, 305, 11, 16, "Index",
  CellTags->"TCP protocol"],
Cell[57445, 2411, 273, 9, 16, "Index",
  CellTags->"Template programs"],
Cell[57721, 2422, 314, 11, 16, "Index",
  CellTags->"Unicode"],
Cell[58038, 2435, 261, 9, 16, "Index",
  CellTags->"Uninstall"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58336, 2449, 29, 0, 34, "Subsubsection"],
Cell[58368, 2451, 164, 7, 16, "Index",
  CellTags->"addtwo"],
Cell[58535, 2460, 165, 6, 16, "IndexSubentry",
  CellTags->"addtwo"],
Cell[58703, 2468, 280, 9, 16, "Index",
  CellTags->"ANSI prototypes"],
Cell[58986, 2479, 169, 7, 16, "Index",
  CellTags->"API"],
Cell[59158, 2488, 215, 9, 16, "Index",
  CellTags->"ASCII"],
Cell[59376, 2499, 235, 9, 16, "Index",
  CellTags->"Building MathLink programs"],
Cell[59614, 2510, 291, 9, 16, "Index",
  CellTags->"Calling Mathematica from external programs"],
Cell[59908, 2521, 234, 9, 16, "Index",
  CellTags->"C Compilers"],
Cell[60145, 2532, 238, 9, 16, "Index",
  CellTags->"C source code"],
Cell[60386, 2543, 235, 9, 16, "Index",
  CellTags->"Character codes"],
Cell[60624, 2554, 241, 9, 16, "Index",
  CellTags->"Character encoding"],
Cell[60868, 2565, 196, 7, 16, "Index",
  CellTags->"Child processes"],
Cell[61067, 2574, 246, 9, 16, "Index",
  CellTags->"Compatibility"],
Cell[61316, 2585, 237, 9, 16, "Index",
  CellTags->"Compiling MathLink programs"],
Cell[61556, 2596, 191, 7, 16, "Index",
  CellTags->"Console programs"],
Cell[61750, 2605, 182, 6, 16, "IndexSubentry",
  CellTags->"Console programs"],
Cell[61935, 2613, 256, 9, 16, "Index",
  CellTags->"Developer kits, MathLink"],
Cell[62194, 2624, 248, 9, 16, "Index",
  CellTags->"Developer's Kit"],
Cell[62445, 2635, 275, 9, 16, "Index",
  CellTags->"Evaluating Mathematica expressions"],
Cell[62723, 2646, 202, 7, 16, "Index",
  CellTags->"External functions"],
Cell[62928, 2655, 164, 7, 16, "Index",
  CellTags->"factor"],
Cell[63095, 2664, 165, 6, 16, "IndexSubentry",
  CellTags->"factor"],
Cell[63263, 2672, 186, 6, 16, "Index",
  CellTags->"Generated files"],
Cell[63452, 2680, 174, 6, 16, "IndexSubentry",
  CellTags->"Generated files"],
Cell[63629, 2688, 179, 6, 16, "IndexSubentry",
  CellTags->"Generated files"],
Cell[63811, 2696, 196, 7, 16, "Index",
  CellTags->"Header files"],
Cell[64010, 2705, 198, 7, 16, "Index",
  CellTags->"Include files"],
Cell[64211, 2714, 174, 6, 16, "Index",
  CellTags->"Install"],
Cell[64388, 2722, 225, 9, 16, "Index",
  CellTags->"Installing MathLink"],
Cell[64616, 2733, 196, 6, 16, "Index",
  CellTags->"Launching programs"],
Cell[64815, 2741, 175, 6, 16, "Index",
  CellTags->"libML.a"],
Cell[64993, 2749, 232, 9, 16, "Index",
  CellTags->"Library"],
Cell[65228, 2760, 245, 9, 16, "Index",
  CellTags->"Link protocols"],
Cell[65476, 2771, 235, 9, 16, "Index",
  CellTags->"Local protocol"],
Cell[65714, 2782, 212, 8, 16, "Index",
  CellTags->"MathLink"],
Cell[65929, 2792, 175, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[66107, 2800, 191, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[66301, 2808, 177, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[66481, 2816, 186, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[66670, 2824, 234, 9, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[66907, 2835, 166, 6, 16, "IndexSubentry",
  CellTags->"MathLink"],
Cell[67076, 2843, 239, 8, 16, "Index",
  CellTags->"MathLink, compatibility"],
Cell[67318, 2853, 252, 8, 70, "Index",
  CellTags->"MathLink Developer's Kits"],
Cell[67573, 2863, 180, 7, 70, "Index",
  CellTags->"mathlink.h"],
Cell[67756, 2872, 230, 8, 70, "Index",
  CellTags->"MathLink files"],
Cell[67989, 2882, 234, 8, 70, "Index",
  CellTags->"MathLink Interface"],
Cell[68226, 2892, 234, 8, 70, "Index",
  CellTags->"MathLink library"],
Cell[68463, 2902, 237, 8, 70, "Index",
  CellTags->"MathLink, sample projects"],
Cell[68703, 2912, 243, 8, 70, "Index",
  CellTags->"MathLink, sample programs"],
Cell[68949, 2922, 192, 6, 70, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[69144, 2930, 177, 6, 70, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[69324, 2938, 192, 6, 70, "IndexSubentry",
  CellTags->"MathLink, sample programs"],
Cell[69519, 2946, 153, 6, 70, "Index",
  CellTags->"mcc"],
Cell[69675, 2954, 162, 6, 70, "IndexSubentry",
  CellTags->"mcc"],
Cell[69840, 2962, 159, 6, 70, "IndexSubentry",
  CellTags->"mcc"],
Cell[70002, 2970, 202, 7, 70, "Index",
  CellTags->"MLBegin"],
Cell[70207, 2979, 180, 7, 70, "Index",
  CellTags->"MLBytesToGet"],
Cell[70390, 2988, 190, 6, 70, "IndexSubentry",
  CellTags->"MLBytesToGet"],
Cell[70583, 2996, 216, 7, 70, "Index",
  CellTags->"MLCheckFunction"],
Cell[70802, 3005, 210, 7, 70, "Index",
  CellTags->"MLConvertUnicodeString"],
Cell[71015, 3014, 198, 7, 70, "Index",
  CellTags->"MLDisownByteString"],
Cell[71216, 3023, 198, 7, 70, "Index",
  CellTags->"MLDisownByteSymbol"],
Cell[71417, 3032, 204, 7, 70, "Index",
  CellTags->"MLDisownUnicodeString"],
Cell[71624, 3041, 204, 7, 70, "Index",
  CellTags->"MLDisownUnicodeSymbol"],
Cell[71831, 3050, 177, 7, 70, "Index",
  CellTags->"MLforString"],
Cell[72011, 3059, 231, 7, 70, "Index",
  CellTags->"MLGetArgCount"],
Cell[72245, 3068, 189, 7, 70, "Index",
  CellTags->"MLGetByteString"],
Cell[72437, 3077, 179, 6, 70, "IndexSubentry",
  CellTags->"MLGetByteString"],
Cell[72619, 3085, 192, 7, 70, "Index",
  CellTags->"MLGetByteSymbol"],
Cell[72814, 3094, 174, 7, 70, "Index",
  CellTags->"MLGetData"],
Cell[72991, 3103, 191, 6, 70, "IndexSubentry",
  CellTags->"MLGetData"],
Cell[73185, 3111, 212, 7, 70, "Index",
  CellTags->"MLGetFunction"],
Cell[73400, 3120, 211, 7, 70, "Index",
  CellTags->"MLGetString"],
Cell[73614, 3129, 198, 7, 70, "Index",
  CellTags->"MLGetUnicodeString"],
Cell[73815, 3138, 182, 6, 70, "IndexSubentry",
  CellTags->"MLGetUnicodeString"],
Cell[74000, 3146, 198, 7, 70, "Index",
  CellTags->"MLGetUnicodeSymbol"],
Cell[74201, 3155, 212, 7, 70, "Index",
  CellTags->"MLInitialize"],
Cell[74416, 3164, 189, 7, 70, "Index",
  CellTags->"MLNextCharacter"],
Cell[74608, 3173, 274, 9, 70, "Index",
  CellTags->"MLPROTOTYPES"],
Cell[74885, 3184, 192, 7, 70, "Index",
  CellTags->"MLPutByteString"],
Cell[75080, 3193, 192, 7, 70, "Index",
  CellTags->"MLPutByteSymbol"],
Cell[75275, 3202, 195, 7, 70, "Index",
  CellTags->"MLPutCharToString"],
Cell[75473, 3211, 174, 7, 70, "Index",
  CellTags->"MLPutData"],
Cell[75650, 3220, 183, 7, 70, "Index",
  CellTags->"MLPutFunction"],
Cell[75836, 3229, 171, 7, 70, "Index",
  CellTags->"MLPutNext"],
Cell[76010, 3238, 174, 7, 70, "Index",
  CellTags->"MLPutSize"],
Cell[76187, 3247, 211, 7, 70, "Index",
  CellTags->"MLPutString"],
Cell[76401, 3256, 198, 7, 70, "Index",
  CellTags->"MLPutUnicodeString"],
Cell[76602, 3265, 198, 7, 70, "Index",
  CellTags->"MLPutUnicodeSymbol"],
Cell[76803, 3274, 173, 6, 70, "Index",
  CellTags->"MLStringChar"],
Cell[76979, 3282, 187, 7, 70, "Index",
  CellTags->"MLStringPosition"],
Cell[77169, 3291, 165, 7, 70, "Index",
  CellTags->"mprep"],
Cell[77337, 3300, 164, 6, 70, "IndexSubentry",
  CellTags->"mprep"],
Cell[77504, 3308, 163, 6, 70, "IndexSubentry",
  CellTags->"mprep"],
Cell[77670, 3316, 175, 6, 70, "Index",
  CellTags->"Pipes protocol"],
Cell[77848, 3324, 261, 9, 70, "Index",
  CellTags->"Preprocess MathLink programs"],
Cell[78112, 3335, 218, 9, 70, "Index",
  CellTags->"Programs"],
Cell[78333, 3346, 213, 9, 70, "IndexSubentry",
  CellTags->"Programs"],
Cell[78549, 3357, 225, 9, 70, "Index",
  CellTags->"Projects"],
Cell[78777, 3368, 223, 9, 70, "Index",
  CellTags->"Protocol"],
Cell[79003, 3379, 270, 9, 70, "Index",
  CellTags->"Prototypes"],
Cell[79276, 3390, 231, 9, 70, "Index",
  CellTags->"Running MathLink programs"],
Cell[79510, 3401, 247, 9, 70, "Index",
  CellTags->"Sample projects of MathLink"],
Cell[79760, 3412, 248, 9, 70, "Index",
  CellTags->"Shared libraries"],
Cell[80011, 3423, 202, 6, 70, "IndexSubentry",
  CellTags->"Shared libraries"],
Cell[80216, 3431, 241, 9, 70, "Index",
  CellTags->"Special characters"],
Cell[80460, 3442, 234, 9, 70, "Index",
  CellTags->"Strings"],
Cell[80697, 3453, 200, 6, 70, "Index",
  CellTags->"Subsidiary processes"],
Cell[80900, 3461, 219, 9, 70, "Index",
  CellTags->"Symbols"],
Cell[81122, 3472, 171, 6, 70, "Index",
  CellTags->"TCP protocol"],
Cell[81296, 3480, 186, 7, 70, "Index",
  CellTags->"Template programs"],
Cell[81485, 3489, 227, 9, 70, "Index",
  CellTags->"Unicode"],
Cell[81715, 3500, 184, 7, 70, "Index",
  CellTags->"Uninstall"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

