(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    369292,      11317]*)
(*NotebookOutlinePosition[    817428,      24185]*)
(*  CellTagsIndexPosition[    815517,      24127]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " for Windows\nDeveloper Guide"
}], "Chapter",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Version 4, Revision 14
December 15, 2004\
\>", "CopyrightHead",
  CellTags->"WindowsIntroduction"],

Cell["\<\
This document is organized so that you will be most successful if \
you read the sections in order.\
\>", "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "This document describes how to compile and run ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs written in the C language on computers running a Microsoft \
Windows operating system.",
  StyleBox["  ",
    FontSlant->"Italic"],
  "(",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  " describes how to write ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs in both the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " language and the C language.)  This document also describes how ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is implemented for Windows."
}], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "This document does not teach you, in general, how to use your compiler and \
other development tools, nor does it teach you how to program in C or \
generally how to use a Windows-based computer.  It is assumed that you have \
at least worked through the tutorial introduction that came with your set of \
tools.  If you have any trouble building or running your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs, see the troubleshooting section at the end of this document."
}], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Most of what is described in this document is Windows specific.  To learn \
how to compile and run ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs for another platform, see the Developer Guide for that \
platform."
}], "Text",
  CellTags->"WindowsIntroduction"],

Cell[CellGroupData[{

Cell["Revision History", "Subsection",
  CellTags->"WindowsIntroduction"],

Cell[CellGroupData[{

Cell["Changes in Revision 13", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a crash that can occur when using Link objects with multiple \
threads of execution.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "MLGetDouble will now correctly fail when trying to read a floating point \
number larger than a machine double value(",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " can transmit a floating point number with arbitrary precision using \
numbers represented as strings).  Previously MLGetDouble would truncate the \
number to the closest machine size floating point number."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Fixed a significant memory leak in MLTransferExpression.", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Fixed a problem with unecessary CPU usage in MLGetType.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The TCPIP protocol will now correctly handle changing machine \
network interfaces on the fly.  Previously the TCPIP protocol bound very \
tightly with the first, primary, network interface available on a system.  \
When users(particularly of notebooks) switch network interfaces, for example \
between an ethernet cable connection and a wireless connection, the TCPIP \
protocol incorrectly continued to use the now unavailable primary network \
connection causing link connection problems.  TCPIP will now correctly \
recognize network interface changes and use the best available interface.  \
Previous versions of the TCPIP protocol also bound interfaces very closely \
with the DNS resolved hostnames for the primary interface.  The DNS name \
would appear in the link names generated by the TCPIP protocol.  The strong \
DNS binding caused problems when switching machines with a statically \
assigned hostname to a new subnet thereby invalidating the machine's DNS to \
interface mapping and causing connection problems due to incorrect hostnames \
in the link name.  TCPIP now uses the IP address of the current interface as \
the primary portion of the link name and will only switch to DNS link names \
if it can resolve the IP number to a correct DNS name.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a significant memory leak seen in MLPutIntegerArray and \
MLGetIntegerArray.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 11", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Revision 11 includes one new communication protocol, the TCPIP protocol.  \
TCPIP replaces the older protocol TCP.  TCPIP runs significantly faster than \
its predecessor and has some other useful features such as the ability to \
specify the urgent message port number at link creation time.  The TCP \
protocol will remain in the library to enable  communication with older \
versions of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library.  Programmers who plan to use a TCP/IP based protocol in a new \
program should use the TCPIP protocol."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library now uses the SharedMemory protocol as the default protocol on \
Windows.  In addition the SharedMemory device has had numerous bugfixes."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " API functions MLSetEnvIDString0 and MLGetEnvIDString0.  These functions \
allow the programmer to assign a string name to their ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment(perhaps serving as an identifier)prior to opening and \
connecting any link.  The remote side of the connection can then get the \
local program's string after establishing the link.  The programmer may find \
these functions useful if he/she needs to identify a program prior to \
exchanging ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " packets.  The names, functionality, and existence of these functions may \
change in a future release."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " function MLVersionNumber0.  This function exists to allow the programmer \
to return the interface number and revision number of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library used at runtime.  The name, functionality and existence of this \
function may change in a future release."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "MLName now correctly returns the complete path in the linknames.  Previous \
versions of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library incorrectly truncated linknames if the name contained a path with \
a space character.  For example \"C:\\Program Files\\Wolfram Research\\",
  StyleBox["Mathematica\\",
    FontVariations->{"CompatibilityType"->0}],
  "5.1",
  StyleBox["\\AddOns\\MathLink\\DeveloperKit\\Windows\\PrebuiltExamples\\\
addtwo.exe\" truncated to \"C:\\Program\".  The linkname will now contain the \
full path.  However due to limitations in the Windows filesystem interface,  \
users may still experience problems in the odd case where they have a path \
and an executabe file with the same name.  For example if a user has a file \
\"C:\\Program.exe\" as well as a directory \"C:\\Program Files\", then \
linknames that contain \"C:\\Program Files\" will not display correctly, \
however the link will still function correctly.  If you need to have the full \
path included in the linkname in this case, you can always enclose your \
linkname in quotes to retain the full path.",
    FontVariations->{"CompatibilityType"->0}]
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "MLPutMessage will only accept messages whose value will fit inside a 32 \
bit unsigned integer.  A future version of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " will remove this limitation."
}], "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 10", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["Added a Shared Memory device for Windows.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Added a Mac OS X version in revision 9.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Internal bug fixes (many).", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Revision 6", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["Shared Library changes", "Subsubsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " could fail in some circumstances when a binary number was on the link.  \
This bug was fixed."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Changes to \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]", \
"Subsubsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The value of ",
  StyleBox["MLREVISION",
    FontFamily->"Courier"],
  " in \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] was changed \
from 6 to 7."
}], "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Revision 5", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["Shared Library changes", "Subsubsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Getting and putting symbols and strings is now, on average, faster.\
\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Getting and putting arrays of numbers is now faster.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["The library was built with an improved optimizing compiler.", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLCreateMark",
    FontFamily->"Courier"],
  "() is now more efficient."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "There are now functions for putting and getting numbers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s *^ and ` notations."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The array functions in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " have been generalized to handle arrays with leaves other than machine \
numbers and with leaves that are not all the same type."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLToLinkID",
    FontFamily->"Courier"],
  "() was added as a synonym for ",
  StyleBox["MLNumber",
    FontFamily->"Courier"],
  "().  This function returns a unique identifier for each link object that \
has been opened within the given ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment.  The function ",
  StyleBox["MLFromLinkID",
    FontFamily->"Courier"],
  "() was added.  It returns the link object for a given identifier if that \
link is still open.  Otherwise it returns ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  ".  This function returns the open link object with the minimum identifier \
if 0 is passed in."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is more compatible with threaded programs."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A debug version of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library is now released with the standard ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " distribution."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The debug shared library now detects more programming errors.\
\>", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLReady",
    FontFamily->"Courier"],
  "() now detects more cases when the link has died because the other process \
terminated without calling ",
  StyleBox["MLClose",
    FontFamily->"Courier"],
  "()."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "When ",
  StyleBox["MLTransferExpression",
    FontFamily->"Courier"],
  "() failed, it would sometimes clear the error reported by ",
  StyleBox["MLError",
    FontFamily->"Courier"],
  "().  This has been fixed."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "When ",
  StyleBox["MLDuplicateLink",
    FontFamily->"Courier"],
  "() was called on a loopback link that had not had its input buffer filled \
(e.g. by calling ",
  StyleBox["MLFlush()",
    FontFamily->"Courier"],
  "), it could cause a crash.  This has been fixed."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Creating marks when compact arrays were on the link sometimes \
caused a crash.  This has been fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLErrorString",
    FontFamily->"Courier"],
  "() has a more complete list of error strings."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The semantics of ",
  StyleBox["MLNewParameters()",
    FontFamily->"Courier"],
  " and how ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " does versioning was changed.  See the section in the Macintosh or Windows \
Developer Guides entitled \[OpenCurlyDoubleQuote]Versioning with MathLink\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A bug was fixed that had caused ",
  StyleBox["MLLoopbackOpen()",
    FontFamily->"Courier"],
  " to crash when passed zero as its first argument."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLGetByteString()",
    FontFamily->"Courier"],
  " now always returns a null terminated string.  (A Mac compiler bug \
sometimes prevented this.)  Of course there may be other null characters in \
the string and one should use the output length parameter to determine the \
string length."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLTransferExpression()",
    FontFamily->"Courier"],
  " now properly handles raw data, uses less stack space and doesn't convert \
strings unless required."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Calls to ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLDeinitialize()",
    FontFamily->"Courier"],
  " can now be nested.  Only the outer ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  "/",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  " pair actually has any effect, and every call to ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  " will return the same value.  This has the potential to break incorrect \
programs that call ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  " multiple times but only call ",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  " once.  Such programs will no longer be deinitializing the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment when they call ",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MLTransferToEndOfLoopbackLink()",
    FontFamily->"Courier"],
  " now allows ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  " as the destination link."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A bug caused ",
  StyleBox["MLNewPacket()",
    FontFamily->"Courier"],
  " to fail after an overflow error (",
  StyleBox["MLEOVFL",
    FontFamily->"Courier"],
  ") was cleared by ",
  StyleBox["MLClearError()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Classic 680x0 Macintosh programs no longer need the \
\[OpenCurlyDoubleQuote] CFM Runtime Enabler\[CloseCurlyDoubleQuote] installed \
in the \[OpenCurlyDoubleQuote]Extensions\[CloseCurlyDoubleQuote] folder in \
order to use the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library.  However, they can take advantage of it if it is \
installed."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Two new stub files were added in the \
\[OpenCurlyDoubleQuote]Compiler Additions\[CloseCurlyDoubleQuote] folder.  \
See the section in the Macintosh Developer Guide entitled \
\[OpenCurlyDoubleQuote]Versioning with \
MathLink\[CloseCurlyDoubleQuote].\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "On Windows platforms, the message handling and yielding facilities within \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now work more effectively with threaded programs and programs that have \
no user interface (i.e., programs that don't dispatch user events)."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLName()",
    FontFamily->"Courier"],
  " now properly deals with filenames containing spaces on Microsoft \
Windows."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLConfirm",
    FontFamily->"Courier"],
  "() now works properly on Windows."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device changes"
}], "Subsubsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Server programs that need to open several links using the same link \
name are now supported by some link protocols.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The mechanism for finding and loading low-level ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices was generalized for MacOS platforms."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
When the user canceled the browser dialog box of the \
\[OpenCurlyDoubleQuote]PPC\[CloseCurlyDoubleQuote] link protocol, the \
Macintosh FrontEnd would give a misleading message.  This has been \
fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Some missing numeric conversions were added that may be needed by \
classic 68K applications running on a PowerPC computer.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Specifying an internet host using a domain name rather than an IP \
address on PowerPC-based computers did not work.  This has been fixed.\
\>", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A bug was discovered in JavaSoft's Java Runner v1.0.2 for Macintosh when \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " was used in multiple threads of a Java application.  ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now works around this bug."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["The FileMap link protocol on Windows is now faster.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The algorithm used by the Windows FileMap protocol for generating a \
link name when none is provided has changed.  The old algorithm was based on \
the system clock.  The new algorithm uses random numbers.\
\>", "BulletedList",\

  CellTags->"WindowsIntroduction"],

Cell["\<\
The Windows FileMap protocol could only open one link object per \
second.  This has been fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The Windows FileMap protocol now supports link names of up to 31 \
characters.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Specifying an internet host using an IP address on Intel-based \
computers (Windows and Unix) required that the 4 octets of the address be \
given in reverse order.  This has been fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The 16-bit Windows \[OpenCurlyDoubleQuote]Local\
\[CloseCurlyDoubleQuote] protocol now detects a request to use a link name \
that is already in use.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The Windows FileMap protocol had a bug that could cause ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " communication to be slower if a program called ",
  StyleBox["MLEnd()",
    FontFamily->"Courier"],
  " while a second link was still open.  This has been fixed."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Unix",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The mechanism for finding and loading low-level ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices was generalized for Unix platforms."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Specifying an internet host using an IP address on Intel-based \
computers (Windows and Unix) required that the 4 octets of the address be \
given in reverse order.  This has been fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The \[OpenCurlyDoubleQuote]TCP\[CloseCurlyDoubleQuote] protocol is \
now compatible with versions of Linux using libc.6 and libc.5.\
\>", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Changes to \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]", \
"Subsubsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The value of ",
  StyleBox["MLREVISION",
    FontFamily->"Courier"],
  " in \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] was changed \
from 5 to 6."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
All functions in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] are now properly declared for use from C++.\
\>", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "To enable Windows ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " to communicate more efficiently with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " on other platforms, some internal changes were made that required some \
constants to change in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The macros ",
  StyleBox["MLTK_MLSHORT, MLTK_MLINT, MLTK_MLLONG, MLTK_MLFLOAT, \
MLTK_MLDOUBLE, ",
    FontFamily->"Courier"],
  "and",
  StyleBox[" MLTK_MLLONGDOUBLE ",
    FontFamily->"Courier"],
  "were added as an indication of what representation the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library assumes for these C arithmetic types.  The macros ",
  StyleBox["MLTK_CSHORT",
    FontFamily->"Courier"],
  ", etc., are defined using heuristics that attempt to determine the \
representation that your compiler uses for these C arithmetic types when \
compiling code that includes \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "All declarations using the ",
  StyleBox["long double",
    FontFamily->"Courier"],
  " type are now protected by the ",
  StyleBox["CC_SUPPORTS_LONG_DOUBLE",
    FontFamily->"Courier"],
  " macro."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] \
was cleaned up a little.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] changes", \
"Subsubsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] now generates the \
following macro for the benefit of code that may rely on a particular \
revision of \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote].\n\t",
  StyleBox["#define MPREP_REVISION 6",
    FontFamily->"Courier"]
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The argument to the ",
  StyleBox[":Evaluate:",
    FontFamily->"Courier"],
  " keyword is now put on ",
  StyleBox["stdlink",
    FontFamily->"Courier"],
  " using ",
  StyleBox["MLPutByteString()",
    FontFamily->"Courier"],
  " rather than ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " as this is more convenient in this context.  So, for example\n",
  StyleBox[":Evaluate: x=\"a\\nb\"",
    FontFamily->"Courier"],
  "\nwill cause ",
  StyleBox["MLPutByteString()",
    FontFamily->"Courier"],
  " to be called with a string of 8 characters (represented by 8 bytes) to be \
sent to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for parsing and evaluation.  Whereas, with",
  StyleBox[" MLPutString(),",
    FontFamily->"Courier"],
  " the 8 bytes would represent 7 characters because ",
  StyleBox["\"\\n\"",
    FontFamily->"Courier"],
  " is interpreted as a single newline character by ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " .  This is likely not what you want as the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " parser interprets actual newline characters within strings as space \
characters.\n(Compare ",
  StyleBox["ToExpression[\"\\\"a\\nb\\\"\"]",
    FontFamily->"Courier"],
  " to ",
  StyleBox["ToExpression[\"\\\"a\\\\nb\\\"\"]",
    FontFamily->"Courier"],
  ".)"
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] can now generate ",
  StyleBox["#line",
    FontFamily->"Courier"],
  " directives so that compilers and debuggers can refer to the original \
source files.  This feature is controlled by the ",
  StyleBox["-line",
    FontFamily->"Courier"],
  " and ",
  StyleBox["-noline",
    FontFamily->"Courier"],
  " command-line options.  The default is ",
  StyleBox["-noline",
    FontFamily->"Courier"],
  " for the MacOS versions of \[OpenCurlyDoubleQuote]mprep\
\[CloseCurlyDoubleQuote] and ",
  StyleBox["-line",
    FontFamily->"Courier"],
  " for all other platforms."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The mprep-generated functions ",
  StyleBox["MLMainString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLMainArgv()",
    FontFamily->"Courier"],
  " are now correctly defined when",
  StyleBox[" MLPROTOTYPES == 0",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] no longer \
generates very long string literals.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox[":ReturnType: String",
    FontFamily->"Courier"],
  " functions can now return ",
  StyleBox["0",
    FontFamily->"Courier"],
  " to indicate failure."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Windows \
generates programs that use a custom icon in the task bar.\
\>", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Macintosh \
generates modern names for system calls.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Macintosh \
generates apps with a bigger default heap.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The applications generated by the MacOS versions of \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] now display the correct \
copyright notice.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Recording \[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] \
AppleScripts now results in correct scripts.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] had a bug \
that could cause it to crash if it was run twice without quitting.  This was \
fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Miscellaneous", "Subsubsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["Various edits were made to this document.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Some sample code in the section below entitled \
\[OpenCurlyDoubleQuote]The Biggest Compatibility \
Issue\[CloseCurlyDoubleQuote] had a bug that could prevent it from working.  \
This was fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The installation instructions for CodeWarrior users have changed.\
\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The AppleScripts used to create project files were modified for the \
latest Metrowerks tools.  The utility source file \
\[OpenCurlyDoubleQuote]mlmactty.c\[CloseCurlyDoubleQuote] was modified to be \
compatible with Apple's latest SIOW library.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The files \[OpenCurlyDoubleQuote]mlimport.rsrc\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] used by classic 68K \
applications were modified to conform to the new semantics for",
  StyleBox[" MLNewParameters()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic 68K applications works around a code generation bug in some \
versions of Metrowerks' C compiler.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic 68K applications now use modern names for MacOS system calls.\
\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] used by \
classic 68K applications was fixed so that ",
  StyleBox["#define LAZY 1",
    FontFamily->"Courier"],
  " now works."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Java programmers can now easily use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " once again supports 16-bit Windows programs."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs linked with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " for Windows Version 3 can now interoperate with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs built with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "  for Windows Version 2.2.  (Only the Windows platform had this temporary \
gap in interoperability.)"
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " can now work around a bug in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 2.2 that prevented compatibility with Windows 95 and Windows NT."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["CodeWarrior support for Windows was added.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Microsoft Visual C++ V5.0 and V6.0 support for Windows was added.\
\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Java programmers can now easily use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Unix",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "There was a bug in Version 3.0.0 of the Unix kernels that caused it to \
unnecessarily sleep when using ",
  StyleBox["MathLink.",
    FontSlant->"Italic"],
  " This was fixed in Version 3.0.1 kernels.  This bug caused very poor ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " performance."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernels Version 4.0 and later have several optimizations that make \
LinkRead significantly faster."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A resource leak in Version 3.0 of the kernel when it was reading from ",
  StyleBox["MathLink ",
    FontSlant->"Italic"],
  "was fixed."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Several other bugs, resource leaks and performance problems were \
fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now is available on the UltraSPARC platform."
}], "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Revision 1 (also known as Beta 4)", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The value of MLREVISION in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] was changed from 1 to 5.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["This document was renamed again.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Some floating point rounding problems were fixed.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The output of \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] was \
modified to suppress some compiler warnings and to more flexibly handle ",
  StyleBox[":ByteString:",
    FontFamily->"Courier"],
  " and ",
  StyleBox[":ByteSymbol:",
    FontFamily->"Courier"],
  " argument types."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Some example files were changed to be consistent with other \
platforms.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A bug was fixed that caused ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " to hang in some circumstances."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Some internal limits on the parameters passed to ",
  StyleBox["MLOpenArgv",
    FontFamily->"Courier"],
  " were removed."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The functions ",
  StyleBox["MLNextCharacter",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLCharacterOffset",
    FontFamily->"Courier"],
  " were generalized to allow a ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  " value for the end parameter."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A bug was fixed that was encountered when putting zero-length strings with \
the obsolete functions ",
  StyleBox["MLPutSize",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutData",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Another bug was fixed that was encountered when ",
  StyleBox["MLGetString",
    FontFamily->"Courier"],
  " was called when a function was next on the link."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Some exceptions caught by the QC programmer's debugging utility \
were fixed.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Beta 3", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell["This document was renamed.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "A discussion of the ",
  StyleBox["long double",
    FontFamily->"Courier"],
  " type was added to the ",
  ButtonBox["Known Problems",
    ButtonData:>"Known Problems",
    ButtonStyle->"Hyperlink"],
  " section."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] now properly handle ",
  StyleBox[":ArgumentTypes: {ByteString}",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The header file \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] was cleaned up a little.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "More functions have arguments declared using the ",
  StyleBox["const",
    FontFamily->"Courier"],
  " type qualifier."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The argument to ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " was made opaque."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  StyleBox["MLPutIntegerList()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutRealList()",
    FontFamily->"Courier"],
  " now work."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Calling ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " when a function is next on the link now correctly fails with error ",
  StyleBox["MLEGSEQ",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Various other bugs were fixed.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Various edits were made to this document.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Some unsupported goodies were added.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "All callback functions are now declared \[OpenCurlyQuote]",
  StyleBox["pascal",
    FontFamily->"Courier"],
  "\[CloseCurlyQuote].  See the ",
  ButtonBox["Porting Version 2.2 ",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
  " section."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic-68k applications now does version checking.\
\>", \
"BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Beta 2", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The function pointers passed to the undocumented functions ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLSetUserData()",
    FontFamily->"Courier"],
  " were changed to ",
  StyleBox["UniversalProcPtrs ",
    FontFamily->"Courier"],
  "wrapping ",
  StyleBox["pascal",
    FontFamily->"Courier"],
  " functions.  Moreover, the prototypes for the functions registered with ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  " have changed.  The \[OpenCurlyDoubleQuote]Old Definition\
\[CloseCurlyDoubleQuote] version number of the \
\[OpenCurlyDoubleQuote]MathLinkLibraries\[CloseCurlyDoubleQuote] file was not \
incremented for Beta 3, however, so that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end and kernel would still bind to this new library.  Neither the \
front end nor the kernel call these ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " functions and are thus unaffected by the change.  If you call these \
functions in your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program, your program cannot be simultaneously compatible with the Beta 3 \
and Beta 2 or Beta 1 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries.  Be careful that your application is using the shared library \
that matches your use of these functions.  When the next ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Beta becomes available, the \[OpenCurlyDoubleQuote]Old Definition\
\[CloseCurlyDoubleQuote] version number of the \
\[OpenCurlyDoubleQuote]MathLinkLibraries\[CloseCurlyDoubleQuote] file will be \
changed so that applications linked with the Beta 1 or Beta 2 library will no \
longer bind with any newer ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Minor edits were made to this document.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "Minor edits were made to some ",
  StyleBox["typedef",
    FontFamily->"Courier"],
  " declarations in \
\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] now \
works for classic 68K projects that use two bytes to represent variable of \
type ",
  StyleBox["int",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Minor edits were made to the AppleScripts that create project \
documents.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Minor changes were made to the code generated by \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] to make projects that \
use precompiled headers build faster and to fix some incorrect \
declarations.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Overview", "Section",
  CellTags->"WindowsOverview"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is implemented as a collection of dynamically linked, shared libraries.  \
When a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program is launched, the main shared library, ML32I2.DLL, is found in a \
standard place on disk, loaded by the operating system, and bound to the \
client ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program so that calls to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " functions are directed to code within the shared library.  On a Windows \
computer, ML32I2.DLL is typically placed in the Windows system directory.  \
Any additional shared libraries (such as MLSHM32.MLP, MLTCPIP32.MLP, \
MLTCP32.MLP and MLMAP32.MLP) are found by ML32I2.DLL by reading their \
locations from the configuration file MATHLINK.INI.  If MATHLINK.INI is not \
present, the additional shared libraries are found by an algorithm internal \
to ML32I2.DLL.  This configuration file is typically located in the Windows \
directory."
}], "Text",
  CellTags->"WindowsOverview"],

Cell[TextData[{
  "An import library (a .LIB file) is used when a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program is built.  This import library is added to a project file or \
included in the link command in a makefile.  (This import library contains no \
code; it simply exports the same function names as the shared library in \
order to satisfy the linker.)  "
}], "Text",
  CellTags->"WindowsOverview"],

Cell[TextData[{
  "The C interface to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is specified in the header file \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote].  This file is included in any C or C++ source files \
that call functions in the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library."
}], "Text",
  CellTags->"WindowsOverview"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library ML32I2.DLL is needed at the time a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program is run and needs to be placed where the Windows operating system \
can find it.  The import library and header file are needed at the time a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program is built and need to be placed where your compiler and linker can \
find them.  The installation and use of these components and others are \
described in more detail below."
}], "Text",
  CellTags->"WindowsOverview"]
}, Closed]],

Cell[CellGroupData[{

Cell["Supported Compilers", "Section",
  CellTags->"WindowsCompilers"],

Cell[TextData[{
  "As a shared library, ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " can be used with any development environment that adheres to the standard \
calling conventions and binary interface for DLLs specified by Microsoft.  \
However, this document only describes how to build C programs that use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " using Microsoft C++ development environment."
}], "Text",
  CellTags->"WindowsCompilers"],

Cell["\<\
Each development environment supports the notion of a \
\[OpenCurlyDoubleQuote]project document\[CloseCurlyDoubleQuote] whereby \
source files and options for the compiler, linker and debugger are managed \
using a project window, a collection of dialog boxes and other interactive \
interface elements.  In addition to this integrated development environment \
(IDE), all the vendors supply tools that can be run from the command prompt \
or invoked by a make utility.\
\>", "Text",
  CellTags->"WindowsCompilers"],

Cell[CellGroupData[{

Cell["Microsoft Visual C++ and Visual Basic", "Subsection",
  CellTags->{"Microsoft", "WindowsCompilers"}],

Cell["For product information on Visual C++:", "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}],

Cell[TextData[{
  ButtonBox["http://msdn.microsoft.com/developer/",
    ButtonData:>{
      URL[ "http://msdn.microsoft.com/developer/"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://msdn.microsoft.com/visualc/",
    ButtonData:>{
      URL[ "http://msdn.microsoft.com/visualc/"], None},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["http://www.microsoft.com/products/",
    ButtonData:>{
      URL[ "http://www.microsoft.com/products/"], None},
    ButtonStyle->"Hyperlink"]
}], "SmallText",
  CellTags->{"Microsoft", "WindowsCompilers"}],

Cell["Or in the US, contact Microsoft at:", "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}],

Cell["800-621-7930", "SmallText",
  CellTags->{"Microsoft", "WindowsCompilers"}],

Cell["Elsewhere worldwide, call your local Microsoft subsidiary:", "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}],

Cell[TextData[ButtonBox["http://www.microsoft.com/worldwide/",
  ButtonData:>{
    URL[ "http://www.microsoft.com/worldwide/"], None},
  ButtonStyle->"Hyperlink"]], "SmallText",
  CellTags->{"Microsoft", "WindowsCompilers"}],

Cell["To buy Microsoft products, see a local software reseller.", "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Languages Other Than C/C++", "Subsection",
  CellTags->{"languages", "WindowsCompilers"}],

Cell[TextData[{
  "The header file \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] \
is an interface file for the C and C++ programming languages.  Although no \
interface file is provided for other programming languages, it is still \
possible to call ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " from source code written in other languages\[LongDash]it is just somewhat \
less convenient.  You may, for example, have to translate any declarations \
you require from the C declarations in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote].  Moreover, the \[OpenCurlyDoubleQuote]mprep\
\[CloseCurlyDoubleQuote] program is currently designed for use with C and \
C++."
}], "Text",
  CellTags->{"languages", "WindowsCompilers"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Installing the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Components"
}], "Section",
  CellTags->"WindowsInstalling"],

Cell[TextData[{
  "This section describes how to install the components from the MathLink \
Developer Kit so that you can build and run ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  The ",
  "MathLink Developer Kit",
  " is copied to your hard disk when you install ",
  StyleBox["Mathematica. ",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"WindowsInstalling"],

Cell[TextData[{
  "The following instructions assume that the MathLink Developer Kit has been \
installed in the location ",
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["\\5.1\\AddOns\\MathLink\\DeveloperKit\\\\Windows\\",
    FontFamily->"Courier"],
  " by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer as part of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1 layout.  ",
  StyleBox[" ",
    FontSlant->"Italic"],
  "If you have received the DeveloperKit as a component separate from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", copy the folder ",
  StyleBox["Windows",
    FontFamily->"Courier"],
  " to your hard drive, for example to ",
  StyleBox["C:\\MathLink",
    FontFamily->"Courier"],
  ".  In this case, you will need to modify the following installation \
instructions to reflect the location of your Developer's Kit."
}], "Text",
  CellTags->"WindowsInstalling"],

Cell[TextData[{
  "By default, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer installs ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and hence the MathLink Developer Kit in a location that is particularly \
deep.  You may find it much more convenient to copy the ",
  "MathLink Developer Kit",
  " to the root level of your disk drive.  Although the discussions below \
don't assume you have done so, you may want to execute the following commands \
at an MS-DOS command prompt."
}], "Text",
  CellTags->"WindowsInstalling"],

Cell["\<\
cd \"C:\\Program Files\\Wolfram Research\\Mathematica\\5.1\\\"
xcopy Windows   C:\\mathlink\\  /E\
\>", "FramedBox",
  CellTags->"WindowsInstalling"],

Cell[TextData[{
  "You should familiarize yourself with the contents of the MathLink \
Developer Kit by going to its location in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " application directory.  You can evaluate the following cell:"
}], "Text",
  CellTags->"WindowsInstalling"],

Cell[BoxData[
    \(\(Run["\<explorer \>"\  <> \ $TopDirectory\  <> \ "\<\\AddOns\\MathLink\
\\DeveloperKit\\Windows\>"];\)\)], "Input",
  CellTags->"WindowsInstalling"],

Cell["Or, Using the Windows shell:", "Text",
  CellTags->"WindowsInstalling"],

Cell["\<\
\texplorer  \"C:\\Program Files\\Wolfram Research\\Mathematica\\5.1\
\\AddOns\\MathLink\\DeveloperKit\\Windows\\\"\
\>", "SmallText",
  PageWidth->Infinity,
  CellTags->"WindowsInstalling"],

Cell["\<\
In addition, you can look at files and directories from the MS-DOS \
command prompt:\
\>", "Text",
  CellTags->"WindowsInstalling"],

Cell[BoxData[
    \(cd\ \*"\"\<C:\\Program Files\\Wolfram \
Research\\Mathematica\\5.1\\AddOns\\MathLink\\DeveloperKit\\Windows\\\"\>"\)],\
 "Input",
  CellTags->"WindowsInstalling"],

Cell[CellGroupData[{

Cell["Recommended Installation", "Subsection",
  CellTags->{"Recommended Installation", "WindowsInstalling"}],

Cell[CellGroupData[{

Cell["SystemAdditions Installation for All Users", "Subsubsection",
  CellTags->{"Recommended Installation", "WindowsInstalling"}],

Cell[TextData[{
  "If this Developer's Kit is part of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " layout, then the runtime ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components have already been installed into your Windows system directory \
by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer.  However, as a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " developer, you should be aware of how to properly install these \
components.  See the sections below on The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Device Architecture, and ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " as Windows shared libraries for a detailed discussion of how DLLs and \
installers work in the Windows environment.  See the ",
  ButtonBox["Parts List",
    ButtonData:>"parts",
    ButtonStyle->"Hyperlink"],
  " below to find out which of the SystemAddition components should be \
installed in your Windows system directory."
}], "Text",
  CellTags->{"Recommended Installation", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CompilerAdditions Installation for Microsoft Users", "Subsubsection",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell[TextData[{
  "Note that the following instructions assume that you have installed \
Microsoft's Developer Studio .NET in the directory ",
  StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Vc7",
    FontFamily->"Courier"],
  ". This is the default directory for V7.0 of the Developer Studio.  For \
V6.0, the default directory is ",
  StyleBox["C:\\Program Files\\Microsoft Visual Studio\\VC98",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Select the \[OpenCurlyDoubleQuote]Lib\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]Include\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]Bin\[CloseCurlyDoubleQuote] directories within the \
\[OpenCurlyDoubleQuote]MLDev32\[CloseCurlyDoubleQuote] folder within the \
CompilerAdditions folder.  You can open a window containing these folders by \
running the following command:"
}], "NumberedGesture",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell["\<\
\texplorer  \"C:\\Program Files\\Wolfram Research\\Mathematica\\5.1\
\\AddOns\\MathLink\\DeveloperKit\\Windows\\CompilerAdditions\\MLDev32\"\
\>", \
"SmallText",
  PageWidth->Infinity,
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell[TextData[{
  "The word ",
  StyleBox["explorer",
    FontFamily->"Helvetica"],
  " is optional but the quotation marks are not."
}], "NumberedGestureRemark",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  While holding down the ",
  StyleBox["\[ControlKey]",
    FontSize->18],
  " key, drag and drop these three folders into your ",
  StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET \
2003\\Vc7\\PlatformSDK",
    FontFamily->"Courier"],
  " folder."
}], "NumberedGesture",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Click \[OpenCurlyQuote]Yes\[CloseCurlyQuote] or \[OpenCurlyQuote]Yes to \
All\[CloseCurlyQuote] in any confirmation boxes that appear."
}], "NumberedGesture",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell["\<\
This will copy the files from these subdirectories of the \
\[OpenCurlyDoubleQuote]MLDev32\[CloseCurlyDoubleQuote] directory into the \
appropriate subdirectories of your \[OpenCurlyDoubleQuote]PlatformSDK\
\[CloseCurlyDoubleQuote] directory.\
\>", "NumberedGestureRemark",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["CompilerAdditions for non-Microsoft Users", "Subsubsection",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],

Cell[TextData[{
  "Alternative .lib files for other compilers such as Watcom and Borland's \
compiler suits exist in C:\\Program Files\\Wolfram Research\\",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\\5.1\\AddOns\\",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\lib.  As of the time \
of this writing Wolfram Research does not provide .lib files for the lcc \
compiler system."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Device Architecture"
}], "Subsection",
  CellTags->"WindowsInstalling"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is a layered software system consisting of components that are \
independent of the operating system and components that make direct use of \
the communication mechanisms provided by the operating system."
}], "Text",
  CellTags->"WindowsInstalling"],

Cell[TextData[{
  "The primary role of the system-independent component is to encode \
expressions as a string of bytes.  This software is implemented in the shared \
library called ML32I2.DLL (for 32-bit programs).  The role of the OS-specific \
component is to transfer the bytes from one program to another.  There may be \
several implementations of this service.  Each implementation is called a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device and is implemented in a shared library with the .MLP or .MLL \
extension."
}], "Text",
  CellTags->"WindowsInstalling"]
}, Closed]],

Cell[CellGroupData[{

Cell["Parts List", "Subsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "The following is a description of each file or directory in the ",
  "MathLink Developer Kit",
  " (MLDK).  See the section ",
  ButtonBox["Recommended Installation",
    ButtonData:>"Recommended Installation",
    ButtonStyle->"Hyperlink"],
  " above to install these components.  (The 8.3 directory and filenames are \
given in parentheses.)"
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]SystemAdditions/\[CloseCurlyDoubleQuote]   \
(OSADDONS/)\
\>", "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "The files in the ",
  StyleBox["SystemAdditions",
    FontFamily->"Courier"],
  " directory are shared libraries which implement ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", and are usually installed into a place where the system can find them \
whenever ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs are executed.  (See the section ",
  ButtonBox["Recommended Installation",
    ButtonData:>"Recommended Installation",
    ButtonStyle->"Hyperlink"],
  " above to install these components.)  The six shared libraries needed by \
most ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs are at the top level of this directory.  These six files are \
\[OpenCurlyDoubleQuote]",
  StyleBox["ML32I2.DLL",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]",
  StyleBox["ML32I1.DLL",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]MLSHM32.MLP\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]MLTCPIP32.MLP\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]",
  StyleBox["MLMAP32.MLP",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote], and \[OpenCurlyDoubleQuote]",
  StyleBox["MLTCP32.MLP",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote].  "
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]ML32I2.DLL\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is the shared library used by 32-bit V3 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Windows programs that implements Interface 2 of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " application programming interface (API).  It should be placed where the \
operating system's loader will find it when your 32-bit ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program is run.  (It is not needed to build 32-bit ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs\[LongDash]only to run them.)  You could place this file next to \
your built ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program, or in the Windows system directory, or someplace on your PATH.  \
See the discussion below for more information and alternative installation \
options.  The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer places this file in your Windows system directory and (for the \
convenience of installers and uninstallers) adds a reference to it in the \
system registry under \
[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\SharedDLLs]\
"
}], "Text",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]ML32I1.DLL\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "This shared library is similar to \[OpenCurlyDoubleQuote]ML32I2.DLL\
\[CloseCurlyDoubleQuote] but implements Interface 1 of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " API instead of Interface 2.  Like \[OpenCurlyDoubleQuote]ML32I2.DLL\
\[CloseCurlyDoubleQuote], it is used by 32-bit V3 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs."
}], "Text",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Devices"
}], "Subsubsubsection",
  CellTags->{"devices", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "The following shared libraries appropriate for your operating system \
should be placed where the operating system's loader will find them when your \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program is run.  (They are not needed to build ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs\[LongDash]only to run them.)  Typically they are placed next to \
the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries (any of the above .DLL files) in the Windows system directory.  \
"
}], "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "All devices and libraries in the SystemAdditions folder should be copied \
to the Windows system directory.  On some versions of Microsoft Windows,  the \
Windows system directory is ",
  StyleBox["C:\\WINDOWS\\SYSTEM",
    FontFamily->"Courier"],
  ", whereas on others versions it is ",
  StyleBox["C:\\WINNT\\SYSTEM32 or C:\\WINDOWS\\SYSTEM32",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "All of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices follow a naming scheme that describes what protocol they \
implement and what type of programs may use them.  The number 32 describes \
that the devices are used by 32-bit programs."
}], "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],

Cell[TextData[{
  StyleBox["\[WarningSign] ",
    FontSize->24],
  "Some ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices, when loaded, in turn load other ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices \[LongDash] they will not work on their own.  Therefore it is not \
recommended to install only some of the appropriate components \[LongDash] \
you should make all of the appropriate devices available to your operating \
system."
}], "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],

Cell["SharedMemory Device", "Text",
  FontWeight->"Bold",
  FontSlant->"Italic",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]MLSHM32.MLP\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device that uses the Win32 memory-mapped file mechanism to transfer data \
between processes.  These shared libraries are used when the \
\[OpenCurlyDoubleQuote]SharedMemory\[CloseCurlyDoubleQuote] protocol is \
specified when opening a link.  In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1, it is the default device for local connections."
}], "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell["For example, a C program that executes:", "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"foo\", \
\"-linkprotocol\", \"SharedMemory\", \"-linkmode\", \"connect\"};\nlink = \
MLOpenArgv( stdenv, argv, argv + 6, 0);", "MR"]], "FramedBox",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "will connect to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " program that evaluates:"
}], "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[BoxData[
    \(\(\(\ \)\(LinkOpen["\<foo\>", \ LinkProtocol -> "\<SharedMemory\>", \ 
      LinkMode -> Listen]\)\)\)], "Input",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell["TCPIP Device", "Text",
  FontWeight->"Bold",
  FontSlant->"Italic",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]MLTCPIP32.MLP\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device that uses the services of the TCP internet protocol to transfer \
data between processes.  These shared libraries are used when the \
\[OpenCurlyDoubleQuote]TCPIP\[CloseCurlyDoubleQuote] protocol is specified \
when opening a link.  In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1, it is the preferred device for remote connections."
}], "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell["For example, a C program that executes:", "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"6000\", \
\"-linkprotocol\", \"TCPIP\", \"-linkmode\", \"connect\"};\nlink = \
MLOpenArgv( stdenv, argv, argv + 6, 0);", "MR"]], "FramedBox",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "will connect to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " program that evaluates:"
}], "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[BoxData[
    \(\(\(\ \)\(LinkOpen["\<6000\>", \ LinkProtocol -> "\<TCPIP\>", \ 
      LinkMode -> Listen]\)\)\)], "Input",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "The \[OpenCurlyDoubleQuote]TCPIP\[CloseCurlyDoubleQuote] linkprotocol can \
be used to connect ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs running on different computers on a network."
}], "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell["FileMap Device", "Text",
  FontWeight->"Bold",
  FontSlant->"Italic",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]MLMAP32.MLP\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device that uses the Win32 memory-mapped file mechanism to transfer data \
between processes.  These shared libraries are used when the \
\[OpenCurlyDoubleQuote]FileMap\[CloseCurlyDoubleQuote] protocol is specified \
when opening a link."
}], "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell["For example, a C program that executes:", "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"foo\", \
\"-linkprotocol\", \"FileMap\", \"-linkmode\", \"connect\"};\nlink = \
MLOpenArgv( stdenv, argv, argv + 6, 0);", "MR"]], "FramedBox",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "will connect to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " program that evaluates:"
}], "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[BoxData[
    \(\(\(\ \)\(LinkOpen["\<foo\>", \ LinkProtocol -> "\<FileMap\>", \ 
      LinkMode -> Listen]\)\)\)], "Input",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "These devices are used by default by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs when no linkprotocol is specified."
}], "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],

Cell["TCP Device", "Text",
  FontWeight->"Bold",
  FontSlant->"Italic",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]MLTCP32.MLP\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device that uses the services of the TCP internet protocol to transfer \
data between processes.  These shared libraries are used when the \
\[OpenCurlyDoubleQuote]TCP\[CloseCurlyDoubleQuote] protocol is specified when \
opening a link."
}], "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell["For example, a C program that executes:", "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"6000\", \
\"-linkprotocol\", \"TCP\", \"-linkmode\", \"connect\"};\nlink = MLOpenArgv( \
stdenv, argv, argv + 6, 0);", "MR"]], "FramedBox",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "will connect to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " program that evaluates:"
}], "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[BoxData[
    \(\(\(\ \)\(LinkOpen["\<6000\>", \ LinkProtocol -> "\<TCP\>", \ 
      LinkMode -> Listen]\)\)\)], "Input",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "The \[OpenCurlyDoubleQuote]TCP\[CloseCurlyDoubleQuote] linkprotocol can be \
used to connect ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs running on different computers on a network."
}], "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "The \"TCP\" linkprotocol is considered obsolete in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5.1 and only continues to exist for backwards compatibility.  Users of \
\"TCP\" should convert their code to use \"TCPIP.\""
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]CompilerAdditions/\[CloseCurlyDoubleQuote]  \
(CCADDONS/)\
\>", "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\<\
\[OpenCurlyDoubleQuote]MLDev32/INCLUDE/\[CloseCurlyDoubleQuote]  \
(MLDEV32/INCLUDE/)\
\>", "Subsubsubsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],

Cell["\<\
\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] is the \
header file that must be included in your C and C++ source files.  It should \
be placed where your compiler can find it.  You could place this header file \
in the same directory as your source files that include it, or in the same \
location as the standard header files provided with your development tools.  \
Alternatively,  you could add the location of \
\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] to the search path \
for header files.  (This is typically done using command-line switches, an \
environment variable, or a setting in a dialog box.)\
\>", "Text",
  CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]MLDev32/LIB/\[CloseCurlyDoubleQuote]  \
(MLDEV32/LIB/)", "Subsubsubsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This folder contains import libraries that your linker would use to \
resolve references in your code to functions in the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library.  One of these .LIB files would be referenced in your \
project file, makefile, or link commandline.  Because the format of an import \
library is not standardized, one import library is supplied for each of the \
most popular development environments."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]ML32I2M.LIB\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is the import library for use with the Microsoft C/C++ development \
tools including Microsoft Developer Studio.  (It is a COFF import library \
created by the Microsoft linker.)  This file should be placed where it will \
be found by the Microsoft linker.  To avoid having to specify a path, place \
this file in your ",
  StyleBox["Program Files\\Microsoft Visual Studio\\VC98\\LIB",
    FontFamily->"Courier"],
  " directory."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\<\
The following import libraries are provided for those who wish to \
use compilers other than Microsoft Visual C++.\
\>", "Text",
  FontFamily->"Times",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]ML32I2C.LIB\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is the import library for use with the Metrowerks CodeWarrior C/C++ \
development tools.  (It is a COFF import library identical to the Microsoft \
import library ",
  StyleBox["ML32I2M.LIB",
    FontFamily->"Courier"],
  ".)  In the CodeWarrior IDE, when you add a file to a project, you must \
give the full path to that file, so there is no need to install this file \
\[LongDash] there is no notion of installing the file somewhere where the \
CodeWarrior linker will find it."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]ML32I2B.LIB\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is the import library for use with the Borland C/C++ development \
tools.  (It is an OMF import library created from ML32I2.DLL using the \
following command ",
  StyleBox["\\BC5\\BIN\\IMPLIB -f ML32I2B.LIB ML32I2.DLL",
    FontFamily->"Courier"],
  ")  This file should be placed where it will be found by the Borland \
linker.  To avoid having to specify a path, place this file in your ",
  StyleBox["BC5\\LIB",
    FontFamily->"Courier"],
  " directory."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]ML32I2S.LIB\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is the import library for use with the Symantec C/C++ development \
tools.  (It is an OMF import library created from the Microsoft import \
library using the following commands ",
  StyleBox["COPY ML32I2M.LIB ML32I2S.LIB; \\SC\\BIN\\COFF2OMF ML32I2S.LIB",
    FontFamily->"Courier"],
  ")  This file should be placed where it will be found by the Symantec \
linker.  To avoid having to specify a path, place this file in your ",
  StyleBox["SC\\LIB",
    FontFamily->"Courier"],
  " directory."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]ML32I2W.LIB\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is the import library for use with the Watcom C/C++ development \
tools.  (It is a COFF import library identical to the Microsoft import \
library ",
  StyleBox["ML32I2M.LIB",
    FontFamily->"Courier"],
  ".)  This file should be placed where it will be found by the Watcom \
linker.  To avoid having to specify a path, place this file in your ",
  StyleBox["WATCOM\\LIB386\\NT",
    FontFamily->"Courier"],
  " directory."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\<\
\[OpenCurlyDoubleQuote]ML32I1M.LIB\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ML32I1C.LIB\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ML32I1B.LIB\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ML32I1S.LIB\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ML32I1W.LIB\[CloseCurlyDoubleQuote]\
\>", "Text",
  FontFamily->"Courier",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "These import libraries are similar to the import libraries described \
above, except that they refer to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries that export Interface 1 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", rather than Interface 2."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]MLDev32/BIN/\[CloseCurlyDoubleQuote]  \
(MLDEV32/BIN/)", "Subsubsubsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]MPREP.EXE\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"mprep", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]MPREP\[CloseCurlyDoubleQuote] is a 32-bit console \
program that writes ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs automatically by processing \[OpenCurlyDoubleQuote]template\
\[CloseCurlyDoubleQuote] files.  It may be convenient to place this file in \
the \[OpenCurlyDoubleQuote]Bin\[CloseCurlyDoubleQuote] directory of your \
development tools."
}], "Text",
  CellTags->{"mprep", "parts", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]PrebuiltExamples/\[CloseCurlyDoubleQuote]  \
(PREBUILT/)\
\>", "Subsubsection",
  CellTags->{"prebuilt", "parts", "WindowsInstalling"}],

Cell[TextData[{
  "This folder contains prebuilt versions of the example programs.  The \
section ",
  ButtonBox["Running ",
    ButtonData:>"Running",
    ButtonStyle->"AddOnsLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Running",
    ButtonStyle->"AddOnsLink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Running",
    ButtonStyle->"AddOnsLink"],
  " describes how to run these programs.  The section ",
  ButtonBox["Building ",
    ButtonData:>"Building",
    ButtonStyle->"AddOnsLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Building",
    ButtonStyle->"AddOnsLink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Building",
    ButtonStyle->"AddOnsLink"],
  " describes how to build them yourself using the source code in the \
\[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] folder."
}], "Text",
  CellTags->{"prebuilt", "parts", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]MathLinkExamples/\[CloseCurlyDoubleQuote]  \
(EXAMPLES/)\
\>", "Subsubsection",
  CellTags->{"parts", "sample code", "WindowsInstalling"}],

Cell[TextData[{
  "This folder contains the source code for some very simple ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  By using this source code, you can learn how to build and run \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs without having to write any code yourself."
}], "Text",
  CellTags->{"parts", "sample code", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]UnsupportedGoodies/\[CloseCurlyDoubleQuote]  \
(GOODIES/)\
\>", "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\<\
This folder contains contributed sample programs and utilities that \
you may find useful.\
\>", "Text",
  CellTags->{"parts", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[OpenCurlyDoubleQuote]Alternative Components/\
\[CloseCurlyDoubleQuote]  (STANDINS/)\
\>", "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This folder contains code and utilities for those with special needs.  For \
example, here you will find sample code you can use to bind to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library after your program is already running."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell["\[OpenCurlyDoubleQuote]DebugLibraries\[CloseCurlyDoubleQuote]", "Text",
  FontFamily->"Courier",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[TextData[{
  "This is a copy of \[OpenCurlyDoubleQuote]MathLinkLibraries\
\[CloseCurlyDoubleQuote] that does extensive error checking and logs \
information that may be useful.  See the ",
  ButtonBox["Troubleshooting",
    ButtonData:>"Troubleshooting",
    ButtonStyle->"AddOnsLink"],
  " section below for a description of how to use this library."
}], "Text",
  CellTags->{"parts", "WindowsInstalling"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"WindowsRunning"],

Cell[TextData[{
  "The instructions in the next section describe how to build two ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using source code in the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory.  These two programs, \
\[OpenCurlyDoubleQuote]addtwo.exe\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]factor.exe\[CloseCurlyDoubleQuote], are already built \
for you in the \
\[OpenCurlyDoubleQuote]PrebuiltExamples\[CloseCurlyDoubleQuote] folder.  \
Before building them on your own, you should try to run the prebuilt examples \
to verify that the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " system additions are installed and working and to learn what to expect \
from these examples when they are properly built. "
}], "Text",
  CellTags->"WindowsRunning"],

Cell[TextData[{
  "After trying out the two examples, you should read the following \
subsections to learn about other issues you will confront running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs on a Windows computer."
}], "Text",
  CellTags->"WindowsRunning"],

Cell[TextData[{
  "There are two basic types of MathLink program, epitomized by the \
\"addtwo\" and \"factor\".  The first is an Installable program.  An \
Installable program provides new functionality to the kernel by linking a C \
program to the kernel through a calling mechanism.  In order to get this new \
functaionality, the user of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " must run the Install function.  With the addtwo example we'll be adding a \
new function called AddTwo that adds two number (provided as arguments) \
together.  The Kernel and Installable programs have a special relationship \
that allows them only to communicate with one another.  When an installable \
program is run it requires that you provide some information in order for it \
to connect. The other type of program is a Front End. FrontEnds do all of the \
work of creating and managing their own links.  In addition to the \"factor\" \
example, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Front End and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Kernel are also example of the Front End type.  A Front End does not \
require any extra information in order to run, but it will usually make a \
connection at some point during its execution."
}], "Text",
  CellTags->"WindowsRunning"],

Cell[CellGroupData[{

Cell["Running \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[TextData[{
  "The first example program, \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote], is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template program that is installed into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  That is, this program runs in the background, providing, as a service \
to ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " one or more externally compiled functions.  To the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " user, these functions appear to be built-in.  The \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] program uses a template \
file that defines the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "function ",
  StyleBox["AddTwo[]",
    FontFamily->"Courier"],
  " as a call to the C function ",
  StyleBox["addtwo()",
    FontFamily->"Courier"],
  ".  (The template mechanism is described in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ".)  The source code for this program looks likes this:"
}], "Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[TextData[StyleBox[":Begin:\n:Function:       addtwo\n:Pattern:        \
AddTwo[i_Integer, j_Integer]\n:Arguments:      { i, j }\n:ArgumentTypes:  { \
Integer, Integer }\n:ReturnType:     Integer\n:End:\n\n:Evaluate: \
AddTwo::usage = \"AddTwo[x, y] gives the sum of two machine integers x and y.\
\"\n\nint addtwo( int i, int j)\n{\n    return i+j;\n}\n\nint PASCAL WinMain( \
HINSTANCE hinstCurrent, HINSTANCE hinstPrevious, LPSTR lpszCmdLine, int \
nCmdShow)\n{\n\tchar  buff[512];\n\tchar FAR * buff_start = buff;\n\tchar FAR \
* argv[32];\n\tchar FAR * FAR * argv_end = argv + 32;\n\n\tif( \
!MLInitializeIcon( hinstCurrent, nCmdShow)) return 1;\n\tMLScanString( argv, \
&argv_end, &lpszCmdLine, &buff_start);\n\treturn MLMain( argv_end - argv, \
argv);\n}\n", "MR"]], "FramedBox",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["\<\
If you evaluate the following cell, a directory dialog box will \
appear.  Select the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] \
program in the \
\[OpenCurlyDoubleQuote]PrebuiltExamples\[CloseCurlyDoubleQuote] directory and \
click the Open button.\
\>", "Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(link\  = \ Install[LinkLaunch["\<\>"]]\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["\<\
To see a list of the newly available functions, evaluate the \
following cell.\
\>", "Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(LinkPatterns[link]\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[TextData[{
  "This displays the usage message for the ",
  StyleBox["AddTwo[]",
    FontFamily->"Courier"],
  " function as defined in the file \[OpenCurlyDoubleQuote]addtwo.tm\
\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(\(?AddTwo\)\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["Now try it.", "Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(AddTwo[2, \ 3]\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["\<\
See what happens if the sum of the two machine integers won't fit \
in a machine integer or if either argument is not a machine integer:\
\>", \
"Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[2^31 - 1, \ 1]\)\(\ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["\<\
(* 2^31-1 is the largest machine integer.
   If your compiler uses 2-byte ints, then 2^15-1 is the largest C int. \
*)\
\>", "Caption",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[2^31, \ 1]\)\(\ \ \ \ \ \ \ \ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["(* The addtwo program is not prepared for big integers. *)", "Caption",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[x, \ 
      1]\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["(* This doesn't match AddTwo[_Integer, _Integer]. *)", "Caption",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[TextData[{
  StyleBox["Install[]",
    FontFamily->"Courier"],
  " called ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  " and then exchanged information with the external program to set up the \
definition for ",
  StyleBox["AddTwo[]",
    FontFamily->"Courier"],
  ".  You really don't have to worry about these details, but if you are \
curious, evaluate:"
}], "Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(?? AddTwo\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell["When you are finished using the external program evaluate:", "Text",
  CellTags->{"addtwo", "WindowsRunning"}],

Cell[BoxData[
    \(Uninstall[link]\)], "Input",
  CellTags->{"addtwo", "WindowsRunning"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Running \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  "The second example program, \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote], is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end in the sense that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel runs in the background providing, as a service to \
\[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote], the computational \
services of the kernel\[LongDash]in this case the ability to factor an \
integer typed by the user."
}], "Text",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  "This example program, like several of the others, is a console program.  \
That is, rather than presenting a graphical user interface, it interacts with \
the user in a console window using the standard error, input and output \
streams defined by ANSI C.  (As you experiment with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", you may find it convenient, initially, to use a console window.  This is \
discussed in detail in the section ",
  ButtonBox["Building ",
    ButtonData:>"Building",
    ButtonStyle->"AddOnsLink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Building",
    ButtonStyle->"AddOnsLink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Building",
    ButtonStyle->"AddOnsLink"],
  ".)"
}], "Text",
  CellTags->{"factor", "WindowsRunning"}],

Cell["To run the example program FACTOR.EXE", "NumberedGestureHead",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start an MS-DOS command prompt."
}], "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change to the \[OpenCurlyDoubleQuote]PrebuiltExamples\
\[CloseCurlyDoubleQuote] directory."
}], "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type the following commands."
}], "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[StyleBox["factor -linklaunch", "MR"]], "FramedBox",
  CellTags->{"factor", "WindowsRunning"}],

Cell["The Choose a MathLink Program To Launch dialog box appears.", \
"NumberedGestureRemark",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Open MathKernel.exe"
}], "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],

Cell["\<\
After a moment, a prompt will appear requesting that you type an \
integer.\
\>", "NumberedGestureRemark",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type an integer with fewer than 10 digits and press the ",
  StyleBox["\[EnterKey]",
    FontSize->16],
  " key.  (The other factor examples relax the restriction on the size of \
integer you may type in.)"
}], "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[StyleBox["Integer to factor: 123456789", "MR"]], "FramedBox",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  "The prime factors returned by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are printed and \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
closes its link with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "NumberedGestureRemark",
  CellTags->{"factor", "WindowsRunning"}],

Cell[TextData[{
  StyleBox["Integer to factor: 123456789\n3 ", "MR"],
  StyleBox["^", "MR",
    FontFamily->"Courier"],
  StyleBox[" 2\n3607 ", "MR"],
  StyleBox["^", "MR",
    FontFamily->"Courier"],
  StyleBox[" 1\n3803 ", "MR"],
  StyleBox["^", "MR",
    FontFamily->"Courier"],
  StyleBox[" 1", "MR"]
}], "FramedBox",
  CellTags->{"factor", "WindowsRunning"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Supported Link Protocols", "Subsection",
  CellTags->{"protocols", "WindowsRunning"}],

Cell[TextData[{
  "The C function ",
  StyleBox["MLOpenArgv()",
    FontFamily->"Courier"],
  " and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  " are documented in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ".  On Win32 platforms, the legal values for the LinkProtocol option are \
\[OpenCurlyDoubleQuote]SharedMemory\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]TCPIP\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]FileMap\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]TCP\[CloseCurlyDoubleQuote].  A linkprotocol is the \
mechanism used to transport data from one end of a connection to the other.  \
The default is \[OpenCurlyDoubleQuote]SharedMemory\[CloseCurlyDoubleQuote] \
for all LinkModes except LoopBack."
}], "Text",
  CellTags->{"protocols", "WindowsRunning"}],

Cell[TextData[{
  "Note that the \[OpenCurlyDoubleQuote]FileMap\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]SharedMemory\[CloseCurlyDoubleQuote] protocols allow \
link names to be arbitrary words with 31 or fewer characters, while link \
names are unsigned 16-bit integers for the \[OpenCurlyDoubleQuote]TCPIP\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]TCP\
\[CloseCurlyDoubleQuote] protocols.  Even though \[OpenCurlyDoubleQuote]TCPIP\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]TCP\
\[CloseCurlyDoubleQuote] link names are integers, they are still given as \
strings (of digits) to ",
  StyleBox["MLOpenArgv()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"protocols", "WindowsRunning"}],

Cell[TextData[{
  "Note that for ",
  StyleBox["LinkMode->Launch",
    FontFamily->"Courier"],
  ", the link name is not just a pathname to a file to launch, but a \
commandline with space-separated arguments.  Hence, spaces in filenames need \
to be properly quoted.  For example"
}], "Text",
  CellTags->{"protocols", "WindowsRunning"}],

Cell[BoxData[
    \(\(\(LinkOpen[\ "\<My Prog.exe\>"]\)\(\ \ \)\( (*\(wrong!\)*) \)\)\)], \
"Input",
  FontWeight->"Bold",
  CellTags->{"protocols", "WindowsRunning"}],

Cell["\<\
would try to launch the program \[OpenCurlyDoubleQuote]My\
\[CloseCurlyDoubleQuote] with command-line argument of \
\[OpenCurlyDoubleQuote]Prog.exe\[CloseCurlyDoubleQuote].  Whereas, \
\>", \
"Text",
  CellTags->{"protocols", "WindowsRunning"}],

Cell[BoxData[
    \(LinkOpen[\ "\<\"My Prog.exe\"\>"]\)], "Input",
  FontWeight->"Bold",
  CellTags->{"protocols", "WindowsRunning"}],

Cell[" would launch \[OpenCurlyDoubleQuote]My \
Prog.exe\[CloseCurlyDoubleQuote].", "Text",
  CellTags->{"protocols", "WindowsRunning"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"WindowsBuilding"],

Cell[TextData[{
  "The general procedure for building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs is to include \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] in any C or C++ source files that make ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " function calls, to compile your source files, and then to link the \
resulting object code with the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " import library and any other standard libraries required by your \
application.  If your application uses the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template mechanism, then your template files must first be processed into \
a C source file using \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote].  \
The details for several popular development environments are provided below."
}], "Text",
  CellTags->"WindowsBuilding"],

Cell[TextData[{
  "The build instructions below assume you have followed the recommended \
installation instructions for the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " compiler additions.  If you have placed the compiler additions elsewhere \
on your hard disk, you may need to modify the instructions below by setting \
environment variables, specifying additional command-line arguments, or \
specifying full pathnames when referring to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " compiler additions."
}], "Text",
  CellTags->"WindowsBuilding"],

Cell[CellGroupData[{

Cell[TextData[{
  "Versioning with  ",
  StyleBox["MathLink",
    FontSlant->"Italic"]
}], "Subsection",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  "As a shared library, each revision of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " must maintain compatibility with previous revisions.  Yet, at times, new \
functionality needs to be added.  ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " adopts a simple versioning strategy that can be adapted to many \
compile-time and run-time environments."
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[CellGroupData[{

Cell["Strategy", "Subsubsection",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " evolves by improving its implementation and by improving its interface.  \
The values of ",
  StyleBox["MLREVISION",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLINTERFACE",
    FontFamily->"Courier"],
  " defined in \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] are \
incremented whenever an improvement is made and released."
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["MLREVISION",
    FontFamily->"Courier"],
  " is the current revision number. It is incremented every time a change is \
made to the source and ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is rebuilt and distributed on any platform.  (Bug fixes, optimizations, \
or other improvements transparent to the interface increment only this \
number.)"
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["MLINTERFACE",
    FontFamily->"Courier"],
  " is a name for a documented interface to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ".  This number is incremented whenever a named constant or function is \
added, removed, or its behavior is changed in a way that could break existing \
correct client programs.  It is expected that the interface to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "  will be improved over time so that implementations of higher numbered  \
interfaces are more complete or more convenient to use for writing effective \
client programs.  In particular, a specific interface provides all the useful \
functionality of an earlier interface."
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  "If a distributed ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " implementation were labeled with its revision and interface numbers in \
dotted notation so that, say, ML.1.6 means the  sixth revision of interface \
one, then the following may represent a hypothetical distribution history of \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell["first distribution", "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"ML.1.5\"\>", "\<\"(Perhaps earlier revisions were never \
distributed for this platform.)\"\>"}
        },
      ColumnWidths->{0.18, 0.67},
      ColumnAlignments->{Right, Left}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell["second distribution", "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"ML.1.6\"\>", \("(Bug fixes or other improvements were  made \
that don't affect the interface.)"\)}
        },
      ColumnWidths->{0.18, 0.67},
      ColumnAlignments->{Right, Left}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell["third distribution", "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"ML.2.7\"\>", "\<\"(Perhaps some new functions were \
added.)\"\>"},
        {"\<\"ML.1.7\"\>", "\<\" (And improvements were made that don't \
affect the old interface.)\"\>"}
        },
      ColumnWidths->{0.18, 0.67},
      ColumnAlignments->{Right, Left}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell["fourth distribution", "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"ML.3.8\"\>", "\<\"(Perhaps the return values of an existing \
function changed.)\"\>"},
        {"\<\"ML.2.8\"\>", "\<\" (Revision 8 also adds improvements \
transparent to interface 2.)\"\>"},
        {"\<\"ML.1.7\"\>", "\<\" (Clients of interface 1 see no improvements \
in this eighth revision.)\"\>"}
        },
      ColumnWidths->{0.18, 0.67},
      ColumnAlignments->{Right, Left}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell["\<\
Note that the distribution history may not be the same on different \
platforms.  But revision numbers represent a named body of source code across \
all platforms.\
\>", "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  "The mechanism for deploying this strategy differs between platforms \
because of differing platform-specific facilities and conventions.  The \
interface and revision numbers may form part of the filename of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library, or they may not.  This information is always available in some \
conventional form so that it is easy and natural for client programs to bind \
with and use the best available implementation of a particular ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " interface."
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Microsoft Windows details", "Subsubsection",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  "For Windows, the different interfaces of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries are implemented in different shared libraries.  The file \
\[OpenCurlyDoubleQuote]ml32i1.dll\[CloseCurlyDoubleQuote] contains the \
implementation of interface 1 of the latest ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " revision, and the file \[OpenCurlyDoubleQuote]ml32i2.dll\
\[CloseCurlyDoubleQuote] contains the implementation of interface 2.  You \
need only keep the latest revision (as shown in the Properties box for the \
shared library) of these files in your Windows system folder to run any ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program."
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  "In addition, each ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " interface has a separate import library to link against so that \
developers make a conscious decision as to which interface they require at \
compile time.  So, for example, a developer using Microsoft's Developer \
Studio who needs functionality that was added for interface 2 must link with \
\[OpenCurlyDoubleQuote]ml32i2m.lib\[CloseCurlyDoubleQuote] rather than \
\[OpenCurlyDoubleQuote]ml32i1m.lib\[CloseCurlyDoubleQuote].  "
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Calling MLNewParameters()", "Subsubsection",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[TextData[{
  "If you have discovered and use the undocumented function ",
  StyleBox["MLNewParameters()",
    FontFamily->"Courier"],
  " note that its behavior has changed.  (Also note that any undocumented \
functions are subject to change in ways that may not be handled by the \
versioning mechanisms described above.)  If you link against \
\[OpenCurlyDoubleQuote]ml32i1.dll\[CloseCurlyDoubleQuote], you should pass ",
  StyleBox["MLAPI1REVISION",
    FontFamily->"Courier"],
  " as the second and third arguments to ",
  StyleBox["MLNewParameters()",
    FontFamily->"Courier"],
  ".  If you link against \[OpenCurlyDoubleQuote]ml32i2.dll\
\[CloseCurlyDoubleQuote], you should pass ",
  StyleBox["MLAPI2REVISION",
    FontFamily->"Courier"],
  " as the second and third arguments to ",
  StyleBox["MLNewParameters()",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"Versioning", "WindowsBuilding"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"mprep", "WindowsBuilding"}],

Cell[TextData[{
  "If your program uses the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template mechanism as described in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ", you must preprocess (all at once) your source files that contain \
template entries using the \[OpenCurlyDoubleQuote]mprep\
\[CloseCurlyDoubleQuote] console program.  A template entry is a sequence of \
lines that contain template keywords.  (Each entry defines a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that when evaluated calls an associated C function.)  When \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] processes such source \
files, it converts template entries into C functions, passes other text \
through unmodified, and writes out additional C functions that implement a \
remote procedure call mechanism using ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ".  The result is a C source file that is ready for compilation."
}], "Text",
  CellTags->{"mprep", "WindowsBuilding"}],

Cell["For example, the command:", "Text",
  CellTags->{"mprep", "WindowsBuilding"}],

Cell[TextData[StyleBox["mprep  addtwo.tm  -o addtwotm.c", "MR"]], "FramedBox",
  CellTags->{"mprep", "WindowsBuilding"}],

Cell["\<\
will produce a C source file \[OpenCurlyDoubleQuote]addtwotm.c\
\[CloseCurlyDoubleQuote] from the template entries and other text in \
\[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote].  You would then \
compile the output file using the C compiler.  If you use the \
\[OpenCurlyDoubleQuote]Make\[CloseCurlyDoubleQuote] utility to build your \
program, you could add a rule similar to the following one to your \
makefile.\
\>", "Text",
  CellTags->{"mprep", "WindowsBuilding"}],

Cell[TextData[StyleBox["addtwotm.c  :  addtwo.tm\n    mprep  addtwo.tm  -o \
addtwotm.c", "MR"]], "FramedBox",
  CellTags->{"mprep", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with Microsoft C/C++"
}], "Subsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[CellGroupData[{

Cell["Using the command-line tools from a command prompt", "Subsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "When Visual Studio .NET is installed, it does not automatically configure \
your environment so that you can conveniently run the command-line tools from \
the command prompt.  To set up the PATH, INCLUDE, and LIB environment \
variables, you can run the VSVARS32.BAT batch file provided by Microsoft in \
C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\Tools.  Users \
of versions of Microsoft Developer Studio prior to Version 7.0(Visual Studio \
.NET) will have to modify this path to reflect the location of equivalent \
file VCVARS32.BAT.  The location of this file under the default installation \
in V6.0 is ",
  StyleBox["C:\\PROGRAM FILES\\Microsoft Visual \
Studio\\VC\\BIN\\VCVARS32.BAT",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["Debug version of \[OpenCurlyDoubleQuote]addtwo.exe\
\[CloseCurlyDoubleQuote]", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To build a debug version of ADDTWO.EXE", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start an MS-DOS command prompt."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change to the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] \
directory within the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["C:\ncd \"C:\\Program Files\\Wolfram Research\\Mathematica\\", 
    "MR"],
  "5.1",
  StyleBox["\\\"\ncd \
AddOns\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\addtwo\\", "MR"]
}], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type the following six commands."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[StyleBox["\"C:\\PROGRAM FILES\\MICROSOFT VISUAL STUDIO .NET \
2003\\Common7\\Tools\\VSVARS32\"  x86\nSET CL=/nologo /c /DWIN32 /D_WINDOWS \
/W3 /MLd /Z7 /Od /D_DEBUG\nSET LINK=/NOLOGO /SUBSYSTEM:windows /DEBUG \
/PDB:NONE /INCREMENTAL:no  kernel32.lib user32.lib gdi32.lib\nMPREP addtwo.tm \
-o addtwotm.c\nCL addtwo.c addtwotm.c\nLINK addtwo.obj addtwotm.obj \
ml32i2m.lib /OUT:addtwo.exe", "MR"]], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To debug ADDTWO.EXE ", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start Microsoft Visual Studio .NET."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  From the File menu, choose Open Solution."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The Open Solution dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  ",
  "Select Executable Files from the drop-down list to display .EXE files in \
the File Name list."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Select the drive and directory containing ADDTWO.EXE."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Select ADDTWO.EXE and click the Open button."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  To start debugging, press F5 or choose the Start command under the Debug \
menu."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
When you are done debugging and close the project solution, you \
will be asked if you want to save the new solution associated with \
ADDTWO.EXE.  Choose OK if you want to retain your breakpoints and other \
debugger settings.\
\>", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["Debug version of \[OpenCurlyDoubleQuote]factor.exe\
\[CloseCurlyDoubleQuote]", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To build a debug version of FACTOR.EXE", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start an MS-DOS command prompt."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change to the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
directory within the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["C:\ncd \"C:\\Program Files\\Wolfram Research\\Mathematica\\", 
    "MR"],
  "5.1",
  StyleBox["\\\"\ncd \
AddOns\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\factor\\", "MR"]
}], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type the following five commands."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[StyleBox["\"C:\\PROGRAM FILES\\MICROSOFT VISUAL STUDIO .NET \
2003\\Common6\\Tools\\VSVARS32\"  x86\nSET CL=/nologo /c /DWIN32 /D_CONSOLE \
/W3 /MLd /Z7 /Od /D_DEBUG\nSET LINK=/NOLOGO /SUBSYSTEM:console \
/INCREMENTAL:no /PDB:NONE /DEBUG kernel32.lib user32.lib\nCL  factor.c\nLINK  \
 factor.obj  ml32i2m.lib  /OUT:factor.exe", "MR"]], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To debug FACTOR.EXE ", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start Microsoft Developer Studio."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  From the File menu, choose Open Solution."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The Open Solution dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  ",
  "Select Executable Files from the drop-down list to display .EXE files in \
the File Name list."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Select the drive and directory containing FACTOR.EXE."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Select FACTOR.EXE and click the Open button."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  From the Project menu, choose Properties."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The Project Settings dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Click the Debug item under Configuration Properties."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The Debug Settings page appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  In the Command Arguments textbox, type: ",
  StyleBox["-linklaunch",
    FontFamily->"Courier"],
  "."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Click the OK button."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  To start debugging, press F5 or choose the Start command under the Debug \
menu."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  When ",
  StyleBox["MLOpenArgv()",
    FontFamily->"Courier"],
  " is executed, the Choose a MathLink Program to Launch dialog box appears.  \
Open \[OpenCurlyDoubleQuote]MathKernel.exe\[CloseCurlyDoubleQuote]."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
When you are done debugging and close the project solution, you \
will be asked if you want to save the new solution associated with \
FACTOR.EXE.  Choose OK if you want to retain your breakpoints and other \
debugger settings.\
\>", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
Optimized version of \[OpenCurlyDoubleQuote]addtwo.exe\
\[CloseCurlyDoubleQuote]\
\>", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To build an optimized version of ADDTWO.EXE", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start an MS-DOS command prompt."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change to the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] \
directory within the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["C:\ncd \"C:\\Program Files\\Wolfram Research\\Mathematica\\", 
    "MR"],
  "5.1",
  StyleBox["\\\"\ncd \
AddOns\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\addtwo\\", "MR"]
}], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type the following six commands."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[StyleBox["\"C:\\PROGRAM FILES\\MICROSOFT VISUAL STUDIO .NET \
2003\\Common7\\Tools\\VSVARS32\"  x86\nSET CL=/nologo /c /DWIN32 /D_WINDOWS \
/W3 /ML /O2 /DNDEBUG\nSET LINK=/NOLOGO /SUBSYSTEM:windows /INCREMENTAL:no \
/PDB:NONE  kernel32.lib user32.lib gdi32.lib\nMPREP addtwo.tm -o addtwotm.c\n\
CL addtwo.c addtwotm.c\nLINK  addtwo.obj addtwotm.obj ml32i2m.lib \
/OUT:addtwo.exe", "MR"]], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
Optimized version of \[OpenCurlyDoubleQuote]factor.exe\
\[CloseCurlyDoubleQuote]\
\>", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To build an optimized version of FACTOR.EXE", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start an MS-DOS command prompt."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change to the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
directory within the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["C:\ncd \"C:\\Program Files\\Wolfram Research\\Mathematica\\", 
    "MR"],
  "5.1",
  StyleBox["\\\"\ncd \
AddOns\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\factor\\", "MR"]
}], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type the following five commands."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[StyleBox["\"C:\\PROGRAM FILES\\MICROSOFT VISUAL STUDIO .NET \
2003\\Common7\\Tools\\VSVARS32\"  x86\nSET CL=/nologo /c /DWIN32 /D_CONSOLE \
/W3 /ML /O2 /DNDEBUG\nSET LINK=/NOLOGO /SUBSYSTEM:console /INCREMENTAL:no \
/PDB:NONE kernel32.lib user32.lib\nCL  factor.c\nLINK factor.obj ml32i2m.lib \
/OUT:factor.exe", "MR"]], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["Short summary of Compiler switches", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"Switch", "Action"},
        {"\<\"/nologo\"\>", "\<\"don't display the copyright notice\"\>"},
        {"\<\"/ML\"\>", \("places the name of the standard C library \
(LIBC.LIB) in the object code so that it doesn't need to be added to the LINK \
command"\)},
        {"\<\"/MLd\"\>", \("places the name of the standard C library with \
debugging information (LIBCD.LIB) into the object code\[LongDash]also defines \
_DEBUG"\)},
        {"\<\"/W3\"\>", "\<\"display extended warnings\"\>"},
        {"\<\"/Z7\"\>", "\<\"store debugging information in the object \
files\"\>"},
        {"\<\"/Zi\"\>", "\<\"store debugging information in a separate \
project database file\"\>"},
        {"\<\"/Fdaddtwo.pdb\"\>", "\<\"specify name of the project database \
file\[LongDash]used with /Zi\"\>"},
        {"\<\"/Od\"\>", "\<\"turn off optimization (default)\"\>"},
        {"\<\"/O2\"\>", "\<\"optimizer prefers faster code over smaller \
code\"\>"},
        {"\<\"/D\"\>", "\<\"defines used by some standard header files and \
mathlink.h\"\>"},
        {"\<\"/c\"\>", "\<\"compile only without linking\"\>"},
        {"\<\"@filename\"\>", "\<\"read more command-line arguments from the \
file\"\>"},
        {"CFLAGS", "\<\"environment variable containing more command-line \
arguments\"\>"}
        },
      ColumnWidths->{0.2, 0.65},
      ColumnAlignments->{Right, Left},
      RowLines->{True, False}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["Short summary of Linker switches", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"Switch", "Action"},
        {"\<\"/NOLOGO\"\>", "\<\"don't display the copyright notice\"\>"},
        {"\<\"/DEBUG\"\>", \("store debugging information into the executable \
or project database"\)},
        {"\<\"/PDB:NONE\"\>", \("store debugging information in the \
executable\[LongDash]used with /DEBUG"\)},
        {"\<\"/PDB:addtwo.pdb\"\>", "\<\"override the default name for the \
project database\"\>"},
        {"\<\"/OUT:addtwo.exe\"\>", "\<\"name the output file\"\>"},
        {"\<\"/INCREMENTAL:no\"\>", "\<\"links more slowly but keeps things \
smaller and neater\"\>"},
        {"\<\"/SUBSYSTEM:windows\"\>", \("the application doesn't need a \
console because it creates its own windows (default when WinMain() is \
defined"\)},
        {"\<\"/SUBSYSTEM:console\"\>", "\<\"a console is provided (default \
when main() is defined)\"\>"}
        },
      ColumnWidths->{0.28, 0.57},
      ColumnAlignments->{Right, Left},
      RowLines->{True, False}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["Standard system  Libraries", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"Import library\"\>", "\<\"Base system services\"\>"},
        {"\<\"kernel32.lib\"\>", \("base OS support such as the file system, \
interprocess communication, process control, memory, and the console"\)},
        {"\<\"advapi32.lib\"\>", "\<\"support for security and Registry calls\
\"\>"}
        },
      ColumnWidths->{0.2, 0.65},
      ColumnAlignments->{Right, Left},
      RowLines->{True, False}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[""], "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"Import library\"\>", "\<\"GUI system services\"\>"},
        {"\<\"user32.lib\"\>", \("support for user interface elements such as \
windows, messages, menus, controls, and dialog boxes"\)},
        {"\<\"gdi32.lib\"\>", "\<\"support for drawing text and \
graphics\"\>"},
        {"\<\"winspool.lib\"\>", "\<\"support for printing and print \
jobs\"\>"},
        {"\<\"comdlg32.lib\"\>", \("support for the common dialogs such as \
those for opening and saving files and printing"\)}
        },
      ColumnWidths->{0.2, 0.65},
      ColumnAlignments->{Right, Left},
      RowLines->{True, False}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[""], "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"Import library\"\>", "\<\"Shell system services\"\>"},
        {"\<\"shell32.lib\"\>", \("support for drag and drop, associations \
between executables and filename extensions, and icon extraction from \
executables"\)}
        },
      ColumnWidths->{0.2, 0.65},
      ColumnAlignments->{Right, Left},
      RowLines->{True, False}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[""], "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"Import library\"\>", "\<\"OLE system services\"\>"},
        {"\<\"ole32.lib\"\>", "\<\"support OLE v2.1\"\>"},
        {"\<\"oleaut32.lib\"\>", "\<\"support for OLE automation\"\>"},
        {"\<\"uuid.lib\"\>", \("support for universally unique identifiers \
used in OLE and RPC (static library)"\)}
        },
      ColumnWidths->{0.2, 0.65},
      ColumnAlignments->{Right, Left},
      RowLines->{True, False}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[""], "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[BoxData[GridBox[{
        {"\<\"Import library\"\>", "\<\"Database system services\"\>"},
        {"\<\"odbc32.lib\"\>", "\<\"access to database management systems \
through ODBC\"\>"},
        {"\<\"odbccp32.lib\"\>", "\<\"ODBC setup and administration\"\>"}
        },
      ColumnWidths->{0.2, 0.65},
      ColumnAlignments->{Right, Left},
      RowLines->{True, False}]], "Text",
  ShowSpecialCharacters->True,
  AutoSpacing->False,
  ShowStringCharacters->False,
  FontFamily->"Helvetica",
  CellTags->{"Microsoft", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Using the program build utility NMAKE", "Subsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
NMAKE is a utility provided with Microsoft's development tools that \
manages the process of building programs.  NMAKE reads a makefile which \
describes the dependencies and commands required to build and rebuild one or \
more programs.  NMAKE rebuilds any components that have become out of date \
when one or more prerequisite files have been updated.  This document does \
not describe NMAKE or makefiles in detail.  A simple makefile is provided \
below that illustrates how the build commands listed above can be \
automatically executed by simply typing NMAKE at a command prompt.  To learn \
more about NMAKE, its general and powerful mechanisms and how to use macros \
or special forms, see the NMAKE Reference in your \
\[OpenCurlyDoubleQuote]Visual C++ User's Guide\[CloseCurlyDoubleQuote].\
\>", \
"Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["A makefile for \
\[OpenCurlyDoubleQuote]addtwo.exe\[CloseCurlyDoubleQuote]", "Subsubsubsection",\

  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To build ADDTWO.EXE using the NMAKE utility.", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Using a text editor, create a file containing the following text."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[StyleBox["# addtwo.mak  a makefile for building the addtwo.exe \
example program\n\nCFLAGS = /nologo /c /MLd /W3 /Z7 /Od /DWIN32 /D_DEBUG \
/D_WINDOWS\nLFLAGS = /DEBUG /PDB:NONE /NOLOGO /SUBSYSTEM:windows \
/INCREMENTAL:no  kernel32.lib user32.lib gdi32.lib\n\naddtwo.exe : addtwo.obj \
addtwotm.obj\n    LINK addtwo.obj addtwotm.obj ml32i2m.lib /OUT:addtwo.exe \
@<<\n$(LFLAGS)\n<<\n\naddtwo.obj : addtwo.c\n    CL  @<< addtwo.c\n$(CFLAGS)\n\
<<\n\naddtwotm.obj : addtwotm.c\n    CL @<< addtwotm.c\n$(CFLAGS)\n<<\n\n\
addtwotm.c : addtwo.tm\n    mprep addtwo.tm -o addtwotm.c", "MR"]], \
"FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Save the file as \[OpenCurlyDoubleQuote]addtwo.mak\
\[CloseCurlyDoubleQuote] in the \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote] directory within the \
\[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start an MS-DOS command prompt."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change to the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] \
directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type the following two commands."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["\"C:\\PROGRAM FILES\\MICROSOFT VISUAL STUDIO .NET \
2003\\Common7\\Tools\\VSVARS32\"  x86", "MR",
    FontFamily->"Courier"],
  StyleBox["\nNMAKE /f addtwo.mak", "MR"]
}], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
Makefiles consist of a collection of build rules, macros and other \
special forms.\
\>", "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "A build rule consists of a target file, followed by a colon, followed by a \
list of the target's prerequisite files (which must either exist or can be \
built by other build rules in the makefile), followed by one or more indented \
lines containing the commands required to build the target from its \
prerequisites.  For example, the makefile above states that the file \
\[OpenCurlyDoubleQuote]addtwotm.c\[CloseCurlyDoubleQuote] depends on \
\[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote] and should be \
rebuilt any time \[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote] is \
modified.  The build command ",
  StyleBox["mprep addtwo.tm -o addtwotm.c",
    FontFamily->"Courier"],
  " is used to rebuild the target \[OpenCurlyDoubleQuote]addtwotm.c\
\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "Macros are named strings of text that can be inserted into the makefile \
using the notation $(",
  StyleBox["name",
    FontSlant->"Italic"],
  ").  For example, in this makefile, $(CFLAGS) is expanded by NMAKE wherever \
it appears into the string ",
  StyleBox["/nologo /c /MLd /W3 /Z7 /Od /DWIN32 /D_DEBUG /D_WINDOWS",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "You might expect that the command to compile \
\[OpenCurlyDoubleQuote]addtwo.c\[CloseCurlyDoubleQuote] would appear in the \
makefile simply as ",
  StyleBox["CL $(CFLAGS) addtwo.c",
    FontFamily->"Courier"],
  ".  However it would then be possible for you to edit the definition of \
CFLAGS so that the resulting compiler command exceeds the maximum allowable \
length of a commandline.   Because commandlines are restricted in length, \
command-line tools often provide a mechanism to read command-line arguments \
from so-called response files.  The syntax is generally @",
  StyleBox["responsefile.",
    FontSlant->"Italic"],
  "  This mechanism is used above along with NMAKE's ability to produce \
temporary files using the following special form.\n",
  StyleBox["<<",
    FontFamily->"Courier"],
  "\n",
  StyleBox["text to put in temporary file\n",
    FontSlant->"Italic"],
  StyleBox["<<",
    FontFamily->"Courier"]
}], "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["A makefile for \
\[OpenCurlyDoubleQuote]factor.exe\[CloseCurlyDoubleQuote]", "Subsubsubsection",\

  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["To build FACTOR.EXE using the NMAKE utility.", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Using a text editor, create a file containing the following text."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[StyleBox["# factor.mak  a makefile for building the factor.exe \
example program\n\nCFLAGS = /nologo /c /MLd /W3 /Z7 /Od /DWIN32 /D_DEBUG \
/D_CONSOLE\nLFLAGS = /DEBUG /PDB:NONE /NOLOGO /SUBSYSTEM:console \
/INCREMENTAL:no  kernel32.lib user32.lib\n\nfactor.exe : factor.obj\n    LINK \
factor.obj  ml32i2m.lib /OUT:factor.exe @<<\n$(LFLAGS)\n<<\n\nfactor.obj : \
factor.c\n    CL  @<< factor.c\n$(CFLAGS)\n<<", "MR"]], "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Save the file as \[OpenCurlyDoubleQuote]factor.mak\
\[CloseCurlyDoubleQuote] in the \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote] directory within the \
\[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start an MS-DOS command prompt."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change to the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
directory."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Type the following two commands."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["\"C:\\PROGRAM FILES\\MICROSOFT VISUAL STUDIO .NET \
2003\\Common7\\Tools\\VSVARS32\"  x86", "MR",
    FontFamily->"Courier"],
  StyleBox["\nNMAKE /f factor.mak", "MR"]
}], "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Using the integrated development environment, Visual Studio \
.NET\
\>", "Subsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["Steps common to all projects", "Text",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "Steps required to use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " with Microsoft Visual Studio .NET 2003"
}], "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["1. ",
    FontWeight->"Bold"],
  StyleBox["Copy mathlink.h from the ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["MathLink",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" Developer Kit to the Microsoft Visual Studio .NET Include \
directory.\nDeveloper kit path: ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\\5.1\\AddOns\\",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["MathLink",
    FontFamily->"Courier",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\include\n",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Visual Studio .NET Include directory: ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET \
2003\\Vc7\\PlatformSDK\\Include",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}]
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["2. ",
    FontWeight->"Bold"],
  StyleBox["Copy ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["ml32i1m.lib",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ml32i2m.lib",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", and",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ml32i3m.lib ",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["from:\n",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\\5.1\\AddOns\\",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["MathLink",
    FontFamily->"Courier",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\lib\n",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["to:\n",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET \
2003\\Vc7\\PlatformSDK\\Lib",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}]
}], "NumberedGesture",
  CellDingbat->None,
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["3. ",
    FontWeight->"Bold"],
  "Rename the three .lib files as follows:\n",
  StyleBox["ml32i1m.lib -> ml32i1.lib\nml32i2m.lib -> ml32i2.lib",
    FontFamily->"Courier"]
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "4. ",
  StyleBox["Copy ",
    FontWeight->"Plain"],
  StyleBox["mprep.exe",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox[" from:\n",
    FontWeight->"Plain"],
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\\5.1\\AddOns\\",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["MathLink",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\bin",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["\nto:\n",
    FontWeight->"Plain"],
  StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET \
2003\\Vc7\\PlatformSDK\\bin",
    FontFamily->"Courier",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["Creating a project solution for \"addtwo.exe\"", "Text",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
To create a project solution that can be used to edit, build, and \
debug, \"addtwo.exe\"\
\>", "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "1. ",
  StyleBox["Start Microsoft Visual Studio .NET.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "2. ",
  StyleBox["Click File->New->Project.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The \"New Project\" dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "3. ",
  StyleBox["In the 'Project Types' pane click the tree expand icon next to \
the 'Visual C++ Projects.'  Select Win32.  In the 'Templates' pane click on \
the 'Win32 Project' icon.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "4. ",
  StyleBox["In the 'Location' text field type ",
    FontWeight->"Plain"],
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\\5.1\\AddOns\\",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["MathLink",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\\DeveloperKit\\Windows\\MathLinkExamples\n",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["In the 'Name' text field type 'addtwo'\nClick 'OK'",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'Win32 Application Wizard' dialog box appears.", \
"NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "5. ",
  StyleBox["Click on 'Application Settings.'  Under the 'Additional options' \
set, click on the 'Empty Project' text box.  Click 'Finish.'",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["6. ",
    FontWeight->"Bold"],
  "Select the addtwo project in the 'Solution Explorer' by clicking once.  \
From the Project menu select Project->Add Existing Item."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'Add Existing Item' dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "7. ",
  StyleBox["In the 'File name:' text box enter: \"addtwo.c\" \"addtwo.tm\" \
separated by spaces.  Click 'Open'.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["8. ",
    FontFamily->"Lucida Grande",
    FontSize->11,
    FontWeight->"Bold"],
  StyleBox["Select the addtwo project in the 'Solution Explorer' by clicking \
once.  From the Project menu select Project->Add New Item.",
    FontSize->11]
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'Add New Item' dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "9. ",
  StyleBox["In the 'Name:' text field type 'addtwotm.c.' Click 'Open'",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "10. ",
  StyleBox["Select the addtwo project in the 'Solution Explorer' by clicking \
once.  From the Project menu select Project->Add Existing Item.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'Add Existing Item' dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["11. ",
    FontWeight->"Bold"],
  "In the 'File name:' text field type: ",
  StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET \
2003\\Vc7\\PlatformSDK\\Lib\\ml32i2.lib. ",
    FontFamily->"Courier"],
  "Click 'Open'"
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "12. ",
  StyleBox["Click on addtwo.tm in the 'Solution Explorer.'  From the Project \
menu select Project->Properties.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'addtwo.tm Property Pages' dialog box appears.", \
"NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["13. ",
    FontWeight->"Bold"],
  "Click on the 'Custom Build Step' icon in the leftmost pane.  In the \
rightmost pane click on the empty box across from the 'Command Line.'  In \
this text box type(include the quotes):\n\
\"$(VCInstallDir)PlatformSDK\\bin\\mprep.exe\" \"$(InputPath)\" -o \
\"$(ProjectDir)addtwotm.c\""
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "14. ",
  StyleBox["In the text field across from the 'Outputs' text type: \
.\\addtwotm.c.  Click 'OK'",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["15. ",
    FontWeight->"Bold"],
  "From the Build menu, select Build->Build Solution."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "16. ",
  StyleBox["After the project builds, Microsoft Visual Studio .NET will \
display a dialog box informing you that the file addtwotm.c has changed and \
asking you if you would like to reload the file.  Click 'Yes'",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["17. ",
    FontWeight->"Bold"],
  "The addtwo.exe binary is now in ",
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["\\5.1\\AddOns\\",
    FontFamily->"Courier"],
  StyleBox["MathLink",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["\\DeveloperKit\\Windows\\MathLinkExamples\\addtwo\\Debug.",
    FontFamily->"Courier"]
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
Creating a project solution for \[OpenCurlyDoubleQuote]factor.exe\
\[CloseCurlyDoubleQuote]\
\>", "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["\<\
To create a project solution that can be used to edit, build, and \
debug \[OpenCurlyDoubleQuote]factor.exe\[CloseCurlyDoubleQuote]\
\>", \
"NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "1. ",
  StyleBox["Start Microsoft Visual Studio .NET.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "2. ",
  StyleBox["Click File->New->Project.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The \"New Project\" dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "3. ",
  StyleBox["In the 'Project Types' pane click the tree expand icon next to \
the 'Visual C++ Projects.'  Select Win32.  In the 'Templates' pane click on \
the 'Win32 Project' icon.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "4. ",
  StyleBox["In the 'Location' text field type ",
    FontWeight->"Plain"],
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\\5.1\\AddOns\\",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["MathLink",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\\DeveloperKit\\Windows\\MathLinkExamples\n",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox["In the 'Name' text field type 'factor'\nClick 'OK'",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'Win32 Application Wizard' dialog box appears.", \
"NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "5. ",
  StyleBox["Click on 'Application Settings.'  Under the 'Additional options' \
set, click on the 'Empty Project' text box.  Click 'Finish.'",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["6. ",
    FontWeight->"Bold"],
  "Select the factor project in the 'Solution Explorer' by clicking once.  \
From the Project menu select Project->Add Existing Item."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'Add Existing Item' dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "7. ",
  StyleBox["In the 'File name:' text box enter: factor.c  Click 'Open'.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  "8. ",
  StyleBox["Select the factor project in the 'Solution Explorer' by clicking \
once.  From the Project menu select Project->Add Existing Item.",
    FontWeight->"Plain"]
}], "NumberedGesture",
  FontWeight->"Bold",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell["The 'Add Existing Item' dialog box appears.", "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["9. ",
    FontWeight->"Bold"],
  "In the 'File name:' text field type: ",
  StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET \
2003\\Vc7\\PlatformSDK\\Lib\\ml32i2.lib. ",
    FontFamily->"Courier"],
  "Click 'Open'"
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["10. ",
    FontWeight->"Bold"],
  "From the Build menu, select Build->Build Solution."
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[TextData[{
  StyleBox["11. ",
    FontWeight->"Bold"],
  "The factor.exe binary is now in ",
  StyleBox["C:\\Program Files\\Wolfram Research\\",
    FontFamily->"Courier"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["\\5.1\\AddOns\\",
    FontFamily->"Courier"],
  StyleBox["MathLink",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["\\DeveloperKit\\Windows\\MathLinkExamples\\factor\\Debug.",
    FontFamily->"Courier"]
}], "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Troubleshooting", "Section",
  CellTags->"WindowsTroubleshooting"],

Cell[TextData[{
  "Check that the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " system additions are placed in the Windows system directory or are placed \
next to your executable.  For Windows XP use C:\\Windows\\system32."
}], "BulletedList",
  CellTags->"WindowsTroubleshooting"],

Cell[TextData[{
  "Make sure that the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " system additions you are using are from the latest Developer Kit.  Two \
programs that are using runtime components from different Revisions of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " may not work, or if they do work may be slower than using the latest \
components."
}], "BulletedList",
  CellTags->"WindowsTroubleshooting"],

Cell["\<\
Turn off compiler optimization until your program is working.  This \
makes compiling faster, debugging easier, and, besides, the optimizer may be \
broken and the cause of some problems.  (Don't automatically blame the \
optimizer, however, if your program fails when it is turned on.  Optimized \
code uses the stack and registers differently than unoptimized code in such a \
way that may expose or mask a bug in your code.  For example, the common \
mistake of returning a pointer to a local variable may or may not cause a \
problem depending on stack and register use.)\
\>", "BulletedList",
  CellTags->"WindowsTroubleshooting"],

Cell["\<\
Use your debugger.  If you are a new user of your development \
tools, don't put off learning to use the debugger.  It will save you from \
many hours of frustration.\
\>", "BulletedList",
  CellTags->"WindowsTroubleshooting"],

Cell[TextData[{
  "Check the return values from the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library functions or call ",
  StyleBox["MLError()",
    FontFamily->"Courier"],
  " at key points in your program.  ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " will often be able to tell you what has gone wrong.  (If you don't assign \
the return value to a variable, you can still check the return value of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " functions using your debugger's register window.  The 32-bit library \
returns its results in register EAX.)"
}], "BulletedList",
  CellTags->"WindowsTroubleshooting"],

Cell["\<\
While developing your program, place the debug version \
\[OpenCurlyDoubleQuote]ML32I2.DLL\[CloseCurlyDoubleQuote] in the same folder. \
 This library will do more extensive error checking and log information that \
may be useful.\
\>", "BulletedList",
  CellTags->"WindowsTroubleshooting"],

Cell[TextData[{
  "The files \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ML32I2.DLL\[CloseCurlyDoubleQuote], and the .LIB \
import libraries are a matched set.  If you have used an earlier release of \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", or a different interface of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", you should take care that you don't mix components when building your \
application."
}], "BulletedList",
  CellTags->"WindowsTroubleshooting"],

Cell[TextData[{
  "The network control panel must show that TCP/IP is installed before you \
can use ",
  StyleBox["LinkProtocol->\"TCPIP\" or LinkProtocol->\"TCP\"",
    FontFamily->"Courier"],
  ".  Try typing \[OpenCurlyDoubleQuote]telnet\[CloseCurlyDoubleQuote] at a \
command prompt.  Telnet will not function without TCP/IP installed."
}], "BulletedList",
  CellTags->"WindowsTroubleshooting"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " for Mac OS X\nDeveloper Guide"
}], "Chapter",
  CellTags->"MacIntroduction"],

Cell["\<\
Version 4, Revision 14
December 15, 2004\
\>", "CopyrightHead",
  CellTags->"MacIntroduction"],

Cell["\<\
This document is organized so that you will be most successful if \
you read the sections in order.\
\>", "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "This document describes how to compile and run ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs written in the C language on Unix systems.",
  StyleBox["  ",
    FontSlant->"Italic"],
  "(",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  " describes how to write ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs in both the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " language and the C language.)"
}], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "This document does not teach you, in general, how to use your compiler and \
other development tools, nor does it teach you how to program in C.  If you \
have any trouble building or running your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs, see the troubleshooting section at the end of this document."
}], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Most of what is described in this document is Unix specific and is \
applicable to all supported Unix platforms.  However, there may be some \
information which is specific to Mac OS X machines.  To learn how to compile \
and run ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs for another platform, see the Developer Guide for that \
platform."
}], "Text",
  CellTags->"MacIntroduction"],

Cell[CellGroupData[{

Cell["Revision History", "Subsection",
  CellTags->"MacIntroduction"],

Cell[CellGroupData[{

Cell["Changes in Revision 14", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a problem with the library's signal handling code that caused \
programs using SA_SIGINFO type handlers to crash.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a crash that can occur when using TCP links followed by TCPIP \
links in the same session.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 13", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a crash that can occur when using Link objects with multiple \
threads of execution.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "MLGetDouble will now correctly fail when trying to read a floating point \
number larger than a machine double value(",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " can transmit a floating point number with arbitrary precision using \
numbers represented as strings).  Previously MLGetDouble would truncate the \
number to the closest machine size floating point number."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Fixed a significant memory leak in MLTransferExpression.", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Fixed a problem with unecessary CPU usage in MLGetType.", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The Pipes protocol will now correctly return MLELAUNCHNAME if the \
program to launch passed by argument as the linkname to one of the MLOpen* \
functions cannot be found by the operating system.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The TCPIP protocol will now correctly handle changing machine \
network interfaces on the fly.  Previously the TCPIP protocol bound very \
tightly with the first, primary, network interface available on a system.  \
When users(particularly of notebooks) switch network interfaces, for example \
between an ethernet cable connection and a wireless connection, the TCPIP \
protocol incorrectly continued to use the now unavailable primary network \
connection causing link connection problems.  TCPIP will now correctly \
recognize network interface changes and use the best available interface.  \
Previous versions of the TCPIP protocol also bound interfaces very closely \
with the DNS resolved hostnames for the primary interface.  The DNS name \
would appear in the link names generated by the TCPIP protocol.  The strong \
DNS binding caused problems when switching machines with a statically \
assigned hostname to a new subnet thereby invalidating the machine's DNS to \
interface mapping and causing connection problems due to incorrect hostnames \
in the link name.  TCPIP now uses the IP address of the current interface as \
the primary portion of the link name and will only switch to DNS link names \
if it can resolve the IP number to a correct DNS name.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a significant memory leak seen in MLPutIntegerArray and \
MLGetIntegerArray.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 11", "Subsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Revision 11 includes one new communication protocol, the TCPIP protocol.  \
TCPIP replaces the older protocol TCP.  TCPIP runs significantly faster than \
its predecessor and has some other useful features such as the ability to \
specify the urgent message port number at link creation time.  The TCP \
protocol will remain in the library to enable  communication with older \
versions of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library.  Programmers who plan to use a TCP/IP based protocol in a new \
program should use the TCPIP protocol."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " API functions MLSetEnvIDString0 and MLGetEnvIDString0.  These functions \
allow the programmer to assign a string name to their ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment(perhaps serving as an identifier)prior to opening and \
connecting any link.  The remote side of the connection can then get the \
local program's string after establishing the link.  The programmer may find \
these functions useful if he/she needs to identify a program prior to \
exchanging ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " packets.  The names, functionality, and existence of these functions may \
change in a future release."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " function MLVersionNumber0.  This function exists to allow the programmer \
to query the interface number and revision number of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library used at runtime.  The name, functionality and existence of this \
function may change in a future release."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " functions MLSetSignalHandler0 and MLUnsetSignalHandler0.  These functions \
exist to allow the programmer to install a signal handler call back function \
if the programmer needs a signal handler for a signal that the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library also uses.  For example, the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library makes use of SIGINT, SIGABRT, SIGIO, SIGURG, SIGTERM, and other \
signals."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "This revision contains important bugfixes in the Pipes protocol code.  In \
certain circumstances earlier versions of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library forced a crash if the client application opened and closed many \
Pipes protocol links in rapid succession.  This problem no longer exists."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "MLPutMessage will only accept messages whose value will fit inside a 32 \
bit unsigned integer.  A future version of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " will remove this limitation."
}], "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 10", "Subsubsection",
  CellTags->"MacIntroduction"],

Cell["Added a Mac OS X version in revision 9.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Internal bug fixes (many).", "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Revision 5", "Subsubsection",
  CellTags->"MacIntroduction"],

Cell["Shared Library changes", "Subsubsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["\<\
Getting and putting symbols and strings is now, on average, faster.\
\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Getting and putting arrays of numbers is now faster.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["The library was built with an improved optimizing compiler.", \
"BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLCreateMark",
    FontFamily->"Courier"],
  "() is now more efficient."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "There are now functions for putting and getting numbers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s *^ and ` notations."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The array functions in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " have been generalized to handle arrays with leaves other than machine \
numbers and with leaves that are not all the same type."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLToLinkID",
    FontFamily->"Courier"],
  "() was added as a synonym for ",
  StyleBox["MLNumber",
    FontFamily->"Courier"],
  "().  This function returns a unique identifier for each link object that \
has been opened within the given ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment.  The function ",
  StyleBox["MLFromLinkID",
    FontFamily->"Courier"],
  "() was added.  It returns the link object for a given identifier if that \
link is still open.  Otherwise it returns ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  ".  This function returns the open link object with the minimum identifier \
if 0 is passed in."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is more compatible with threaded programs."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A debug version of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library is now released with the standard ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " distribution."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The debug shared library now detects more programming errors.\
\>", \
"BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLReady",
    FontFamily->"Courier"],
  "() now detects more cases when the link has died because the other process \
terminated without calling ",
  StyleBox["MLClose",
    FontFamily->"Courier"],
  "()."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "When ",
  StyleBox["MLTransferExpression",
    FontFamily->"Courier"],
  "() failed, it would sometimes clear the error reported by ",
  StyleBox["MLError",
    FontFamily->"Courier"],
  "().  This has been fixed."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "When ",
  StyleBox["MLDuplicateLink",
    FontFamily->"Courier"],
  "() was called on a loopback link that had not had its input buffer filled \
(e.g. by calling ",
  StyleBox["MLFlush()",
    FontFamily->"Courier"],
  "), it could cause a crash.  This has been fixed."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Creating marks when compact arrays were on the link sometimes \
caused a crash.  This has been fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLErrorString",
    FontFamily->"Courier"],
  "() has a more complete list of error strings."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The semantics of ",
  StyleBox["MLNewParameters()",
    FontFamily->"Courier"],
  " and how ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " does versioning was changed.  See the section in the Macintosh or Windows \
Developer Guides entitled \[OpenCurlyDoubleQuote]Versioning with MathLink\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A bug was fixed that had caused ",
  StyleBox["MLLoopbackOpen()",
    FontFamily->"Courier"],
  " to crash when passed zero as its first argument."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLGetByteString()",
    FontFamily->"Courier"],
  " now always returns a null terminated string.  (A Mac compiler bug \
sometimes prevented this.)  Of course there may be other null characters in \
the string and one should use the output length parameter to determine the \
string length."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLTransferExpression()",
    FontFamily->"Courier"],
  " now properly handles raw data, uses less stack space and doesn't convert \
strings unless required."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Calls to ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLDeinitialize()",
    FontFamily->"Courier"],
  " can now be nested.  Only the outer ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  "/",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  " pair actually has any effect, and every call to ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  " will return the same value.  This has the potential to break incorrect \
programs that call ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  " multiple times but only call ",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  " once.  Such programs will no longer be deinitializing the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment when they call ",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MLTransferToEndOfLoopbackLink()",
    FontFamily->"Courier"],
  " now allows ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  " as the destination link."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A bug caused ",
  StyleBox["MLNewPacket()",
    FontFamily->"Courier"],
  " to fail after an overflow error (",
  StyleBox["MLEOVFL",
    FontFamily->"Courier"],
  ") was cleared by ",
  StyleBox["MLClearError()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Classic 680x0 Macintosh programs no longer need the \
\[OpenCurlyDoubleQuote] CFM Runtime Enabler\[CloseCurlyDoubleQuote] installed \
in the \[OpenCurlyDoubleQuote]Extensions\[CloseCurlyDoubleQuote] folder in \
order to use the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library.  However, they can take advantage of it if it is \
installed."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Two new stub files were added in the \
\[OpenCurlyDoubleQuote]Compiler Additions\[CloseCurlyDoubleQuote] folder.  \
See the section in the Macintosh Developer Guide entitled \
\[OpenCurlyDoubleQuote]Versioning with \
MathLink\[CloseCurlyDoubleQuote].\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "On Windows platforms, the message handling and yielding facilities within \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now work more effectively with threaded programs and programs that have \
no user interface (i.e., programs that don't dispatch user events)."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLName()",
    FontFamily->"Courier"],
  " now properly deals with filenames containing spaces on Windows 95 and \
Windows NT."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLConfirm",
    FontFamily->"Courier"],
  "() now works properly on Windows."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device changes"
}], "Subsubsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["\<\
Server programs that need to open several links using the same link \
name are now supported by some link protocols.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The mechanism for finding and loading low-level ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices was generalized for MacOS platforms."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
When the user canceled the browser dialog box of the \
\[OpenCurlyDoubleQuote]PPC\[CloseCurlyDoubleQuote] link protocol, the \
Macintosh FrontEnd would give a misleading message.  This has been \
fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Some missing numeric conversions were added that may be needed by \
classic 68K applications running on a PowerPC computer.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Specifying an internet host using a domain name rather than an IP \
address on PowerPC-based computers did not work.  This has been fixed.\
\>", \
"BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A bug was discovered in JavaSoft's Java Runner v1.0.2 for Macintosh when \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " was used in multiple threads of a Java application.  ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now works around this bug."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["The FileMap link protocol on Windows is now faster.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The algorithm used by the Windows FileMap protocol for generating a \
link name when none is provided has changed.  The old algorithm was based on \
the system clock.  The new algorithm uses random numbers.\
\>", "BulletedList",\

  CellTags->"MacIntroduction"],

Cell["\<\
The Windows FileMap protocol could only open one link object per \
second.  This has been fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The Windows FileMap protocol now supports link names of up to 31 \
characters.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Specifying an internet host using an IP address on Intel-based \
computers (Windows and Unix) required that the 4 octets of the address be \
given in reverse order.  This has been fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The 16-bit Windows \[OpenCurlyDoubleQuote]Local\
\[CloseCurlyDoubleQuote] protocol now detects a request to use a link name \
that is already in use.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The Windows FileMap protocol had a bug that could cause ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " communication to be slower if a program called ",
  StyleBox["MLEnd()",
    FontFamily->"Courier"],
  " while a second link was still open.  This has been fixed."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Unix",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The mechanism for finding and loading low-level ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices was generalized for Unix platforms."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Specifying an internet host using an IP address on Intel-based \
computers (Windows and Unix) required that the 4 octets of the address be \
given in reverse order.  This has been fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The \[OpenCurlyDoubleQuote]TCP\[CloseCurlyDoubleQuote] protocol is \
now compatible with versions of Linux using libc.6 and libc.5.\
\>", \
"BulletedList",
  CellTags->"MacIntroduction"],

Cell["Changes to \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]", \
"Subsubsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The value of ",
  StyleBox["MLREVISION",
    FontFamily->"Courier"],
  " in \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] was changed \
from 5 to 6."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
All functions in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] are now properly declared for use from C++.\
\>", \
"BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "To enable Windows ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " to communicate more efficiently with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " on other platforms, some internal changes were made that required some \
constants to change in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The macros ",
  StyleBox["MLTK_MLSHORT, MLTK_MLINT, MLTK_MLLONG, MLTK_MLFLOAT, \
MLTK_MLDOUBLE, ",
    FontFamily->"Courier"],
  "and",
  StyleBox[" MLTK_MLLONGDOUBLE ",
    FontFamily->"Courier"],
  "were added as an indication of what representation the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library assumes for these C arithmetic types.  The macros ",
  StyleBox["MLTK_CSHORT",
    FontFamily->"Courier"],
  ", etc., are defined using heuristics that attempt to determine the \
representation that your compiler uses for these C arithmetic types when \
compiling code that includes \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "All declarations using the ",
  StyleBox["long double",
    FontFamily->"Courier"],
  " type are now protected by the ",
  StyleBox["CC_SUPPORTS_LONG_DOUBLE",
    FontFamily->"Courier"],
  " macro."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] \
was cleaned up a little.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] changes", \
"Subsubsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] now generates the \
following macro for the benefit of code that may rely on a particular \
revision of \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote].\n\t",
  StyleBox["#define MPREP_REVISION 6",
    FontFamily->"Courier"]
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The argument to the ",
  StyleBox[":Evaluate:",
    FontFamily->"Courier"],
  " keyword is now put on ",
  StyleBox["stdlink",
    FontFamily->"Courier"],
  " using ",
  StyleBox["MLPutByteString()",
    FontFamily->"Courier"],
  " rather than ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " as this is more convenient in this context.  So, for example\n",
  StyleBox[":Evaluate: x=\"a\\nb\"",
    FontFamily->"Courier"],
  "\nwill cause ",
  StyleBox["MLPutByteString()",
    FontFamily->"Courier"],
  " to be called with a string of 8 characters (represented by 8 bytes) to be \
sent to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for parsing and evaluation.  Whereas, with",
  StyleBox[" MLPutString(),",
    FontFamily->"Courier"],
  " the 8 bytes would represent 7 characters because ",
  StyleBox["\"\\n\"",
    FontFamily->"Courier"],
  " is interpreted as a single newline character by ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " .  This is likely not what you want as the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " parser interprets actual newline characters within strings as space \
characters.\n(Compare ",
  StyleBox["ToExpression[\"\\\"a\\nb\\\"\"]",
    FontFamily->"Courier"],
  " to ",
  StyleBox["ToExpression[\"\\\"a\\\\nb\\\"\"]",
    FontFamily->"Courier"],
  ".)"
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] can now generate ",
  StyleBox["#line",
    FontFamily->"Courier"],
  " directives so that compilers and debuggers can refer to the original \
source files.  This feature is controlled by the ",
  StyleBox["-line",
    FontFamily->"Courier"],
  " and ",
  StyleBox["-noline",
    FontFamily->"Courier"],
  " command-line options.  The default is ",
  StyleBox["-noline",
    FontFamily->"Courier"],
  " for the MacOS versions of \[OpenCurlyDoubleQuote]mprep\
\[CloseCurlyDoubleQuote] and ",
  StyleBox["-line",
    FontFamily->"Courier"],
  " for all other platforms."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The mprep-generated functions ",
  StyleBox["MLMainString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLMainArgv()",
    FontFamily->"Courier"],
  " are now correctly defined when",
  StyleBox[" MLPROTOTYPES == 0",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] no longer \
generates very long string literals.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox[":ReturnType: String",
    FontFamily->"Courier"],
  " functions can now return ",
  StyleBox["0",
    FontFamily->"Courier"],
  " to indicate failure."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Windows \
generates programs that use a custom icon in the task bar.\
\>", \
"BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Macintosh \
generates modern names for system calls.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Macintosh \
generates apps with a bigger default heap.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The applications generated by the MacOS versions of \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] now display the correct \
copyright notice.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Recording \[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] \
AppleScripts now results in correct scripts.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] had a bug \
that could cause it to crash if it was run twice without quitting.  This was \
fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Miscellaneous", "Subsubsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["Various edits were made to this document.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Some sample code in the section below entitled \
\[OpenCurlyDoubleQuote]The Biggest Compatibility \
Issue\[CloseCurlyDoubleQuote] had a bug that could prevent it from working.  \
This was fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["\<\
The installation instructions for CodeWarrior users have changed.\
\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The AppleScripts used to create project files were modified for the \
latest Metrowerks tools.  The utility source file \
\[OpenCurlyDoubleQuote]mlmactty.c\[CloseCurlyDoubleQuote] was modified to be \
compatible with Apple's latest SIOW library.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The files \[OpenCurlyDoubleQuote]mlimport.rsrc\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] used by classic 68K \
applications were modified to conform to the new semantics for",
  StyleBox[" MLNewParameters()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic 68K applications works around a code generation bug in some \
versions of Metrowerks' C compiler.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic 68K applications now use modern names for MacOS system calls.\
\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] used by \
classic 68K applications was fixed so that ",
  StyleBox["#define LAZY 1",
    FontFamily->"Courier"],
  " now works."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Java programmers can now easily use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " once again supports 16-bit Windows programs."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs linked with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " for Windows Version 3 can now interoperate with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs built with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "  for Windows Version 2.2.  (Only the Windows platform had this temporary \
gap in interoperability.)"
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " can now work around a bug in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 2.2 that prevented compatibility with Windows 95 and Windows NT."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["CodeWarrior support for Windows was added.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Microsoft Visual C++ V5.0 and V6.0 support for Windows was added.\
\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Java programmers can now easily use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Unix",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "There was a bug in Version 3.0.0 of the Unix kernels that caused it to \
unnecessarily sleep when using ",
  StyleBox["MathLink.",
    FontSlant->"Italic"],
  " This was fixed in Version 3.0.1 kernels.  This bug caused very poor ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " performance."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernels Version 4.0 and later have several optimizations that make \
LinkRead significantly faster."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A resource leak in Version 3.0 of the kernel when it was reading from ",
  StyleBox["MathLink ",
    FontSlant->"Italic"],
  "was fixed."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Several other bugs, resource leaks and performance problems were \
fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now is available on the UltraSPARC platform."
}], "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Revision 1 (also known as Beta 4)", "Subsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["\<\
The value of MLREVISION in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] was changed from 1 to 5.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["This document was renamed again.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Some floating point rounding problems were fixed.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The output of \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] was \
modified to suppress some compiler warnings and to more flexibly handle ",
  StyleBox[":ByteString:",
    FontFamily->"Courier"],
  " and ",
  StyleBox[":ByteSymbol:",
    FontFamily->"Courier"],
  " argument types."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Some example files were changed to be consistent with other \
platforms.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A bug was fixed that caused ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " to hang in some circumstances."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Some internal limits on the parameters passed to ",
  StyleBox["MLOpenArgv",
    FontFamily->"Courier"],
  " were removed."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The functions ",
  StyleBox["MLNextCharacter",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLCharacterOffset",
    FontFamily->"Courier"],
  " were generalized to allow a ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  " value for the end parameter."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A bug was fixed that was encountered when putting zero-length strings with \
the obsolete functions ",
  StyleBox["MLPutSize",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutData",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Another bug was fixed that was encountered when ",
  StyleBox["MLGetString",
    FontFamily->"Courier"],
  " was called when a function was next on the link."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["\<\
Some exceptions caught by the QC programmer's debugging utility \
were fixed.\
\>", "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Beta 3", "Subsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell["This document was renamed.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "A discussion of the ",
  StyleBox["long double",
    FontFamily->"Courier"],
  " type was added to the ",
  ButtonBox["Known Problems",
    ButtonData:>"Known Problems",
    ButtonStyle->"Hyperlink"],
  " section."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] now properly handle ",
  StyleBox[":ArgumentTypes: {ByteString}",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The header file \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] was cleaned up a little.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "More functions have arguments declared using the ",
  StyleBox["const",
    FontFamily->"Courier"],
  " type qualifier."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The argument to ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " was made opaque."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  StyleBox["MLPutIntegerList()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutRealList()",
    FontFamily->"Courier"],
  " now work."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Calling ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " when a function is next on the link now correctly fails with error ",
  StyleBox["MLEGSEQ",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Various other bugs were fixed.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Various edits were made to this document.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Some unsupported goodies were added.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "All callback functions are now declared \[OpenCurlyQuote]",
  StyleBox["pascal",
    FontFamily->"Courier"],
  "\[CloseCurlyQuote].  See the ",
  ButtonBox["Porting Version 2.2 ",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
  " section."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic-68k applications now does version checking.\
\>", \
"BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Beta 2", "Subsubsection",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The function pointers passed to the undocumented functions ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLSetUserData()",
    FontFamily->"Courier"],
  " were changed to ",
  StyleBox["UniversalProcPtrs ",
    FontFamily->"Courier"],
  "wrapping ",
  StyleBox["pascal",
    FontFamily->"Courier"],
  " functions.  Moreover, the prototypes for the functions registered with ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  " have changed.  The \[OpenCurlyDoubleQuote]Old Definition\
\[CloseCurlyDoubleQuote] version number of the \
\[OpenCurlyDoubleQuote]MathLinkLibraries\[CloseCurlyDoubleQuote] file was not \
incremented for Beta 3, however, so that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end and kernel would still bind to this new library.  Neither the \
front end nor the kernel call these ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " functions and are thus unaffected by the change.  If you call these \
functions in your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program, your program cannot be simultaneously compatible with the Beta 3 \
and Beta 2 or Beta 1 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries.  Be careful that your application is using the shared library \
that matches your use of these functions.  When the next ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Beta becomes available, the \[OpenCurlyDoubleQuote]Old Definition\
\[CloseCurlyDoubleQuote] version number of the \
\[OpenCurlyDoubleQuote]MathLinkLibraries\[CloseCurlyDoubleQuote] file will be \
changed so that applications linked with the Beta 1 or Beta 2 library will no \
longer bind with any newer ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["Minor edits were made to this document.", "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "Minor edits were made to some ",
  StyleBox["typedef",
    FontFamily->"Courier"],
  " declarations in \
\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"MacIntroduction"],

Cell[TextData[{
  "The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] now \
works for classic 68K projects that use two bytes to represent variable of \
type ",
  StyleBox["int",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Minor edits were made to the AppleScripts that create project \
documents.\
\>", "BulletedList",
  CellTags->"MacIntroduction"],

Cell["\<\
Minor changes were made to the code generated by \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] to make projects that \
use precompiled headers build faster and to fix some incorrect \
declarations.\
\>", "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Installing the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Components"
}], "Section",
  CellTags->"MacInstalling"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kit is located in the \
\[OpenCurlyDoubleQuote]AddOns/MathLink/DeveloperKit/Darwin",
  "\[CloseCurlyDoubleQuote]",
  " directory within your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory."
}], "Text",
  CellTags->"MacInstalling"],

Cell[CellGroupData[{

Cell["Recommended Installation", "Subsection",
  CellTags->"MacInstalling"],

Cell["CompilerAdditions Installation", "Text",
  FontVariations->{"Underline"->True},
  CellTags->"MacInstalling"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components that you will need to build ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs have already been installed by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer.  One way to use these components is to leave them in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory and specify their full path name when you call your compiler.  \
This approach is taken in the example \[OpenCurlyDoubleQuote]makefiles",
  "\[CloseCurlyDoubleQuote]",
  " in the section \[OpenCurlyDoubleQuote]Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->"MacInstalling"],

Cell[TextData[{
  "An alternative is to copy these components \
(\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]libML.a\[CloseCurlyDoubleQuote]) into directories in \
which your compiler will automatically search for such files.  These \
directories are commonly ",
  StyleBox["/usr/include",
    FontFamily->"Courier"],
  " and ",
  StyleBox["/usr/lib",
    FontFamily->"Courier"],
  ", but may be different on your system.  On many systems not all users have \
write access to these directories."
}], "Text",
  CellTags->"MacInstalling"],

Cell["MathLinkExamples Installation", "Text",
  FontVariations->{"Underline"->True},
  CellTags->"MacInstalling"],

Cell["\<\
Copy the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory to your home directory.\
\>", "Text",
  CellTags->"MacInstalling"]
}, Closed]],

Cell[CellGroupData[{

Cell["Parts List", "Subsection",
  CellTags->{"parts", "MacInstalling"}],

Cell[TextData[{
  "The following is a description of each file or directory in the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kit (MLDK)."
}], "Text",
  CellTags->{"parts", "MacInstalling"}],

Cell[CellGroupData[{

Cell["\[OpenCurlyDoubleQuote]CompilerAdditions\[CloseCurlyDoubleQuote] \
Directory", "Subsubsection",
  CellTags->{"parts", "MacInstalling"}],

Cell["mathlink.h", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "mathlink.h", "MacInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] is the header \
file that must be included in your C and C++ source files.  It should be \
placed where your compiler can find it.  You could copy this header file into \
the same directory as your source files,  copy it into the same location as \
the standard header files, or leave it where it is if you added the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " directory to the search path for header files."
}], "Text",
  CellTags->{"parts", "mathlink.h", "MacInstalling"}],

Cell["libML.a", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]libML.a\[CloseCurlyDoubleQuote] is the static \
library that contains all of the ",
  StyleBox["MathLink ",
    FontSlant->"Italic"],
  "functions.  It should be included in your project.  You could copy this \
library into the same directory as your source files or leave it where it is \
if you added the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " directory to the search path for libraries."
}], "Text",
  CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],

Cell["mprep", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "mprep", "MacInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] is an application \
that writes ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs automatically by processing \[OpenCurlyDoubleQuote]template\
\[CloseCurlyDoubleQuote] files.  It may be convenient to copy this \
application into the same directory as your project or to create an alias to \
it."
}], "Text",
  CellTags->{"parts", "mprep", "MacInstalling"}],

Cell["mcc", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "mcc", "MacInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] is a script that \
preprocesses and compiles your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " source files."
}], "Text",
  CellTags->{"parts", "mcc", "MacInstalling"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] \
Directory", "Subsubsection",
  CellTags->{"parts", "MacInstalling"}],

Cell[TextData[{
  "This directory contains the source code for some very simple ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  By using this source code, you can learn how to build and run \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs without having to write any code yourself."
}], "Text",
  CellTags->{"parts", "MacInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\[OpenCurlyDoubleQuote]PrebuiltExamples\[CloseCurlyDoubleQuote] \
Directory", "Subsubsection",
  CellTags->{"parts", "prebuilt", "MacInstalling"}],

Cell[TextData[{
  "This directory contains prebuilt versions of the example programs.  The \
section ",
  ButtonBox["Running ",
    ButtonData:>"Running",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Running",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Running",
    ButtonStyle->"Hyperlink"],
  " describes how to run two of these programs.  The section ",
  ButtonBox["Building ",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
  " describes how to build them yourself using the source code in the \
\[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] directory."
}], "Text",
  CellTags->{"parts", "prebuilt", "MacInstalling"}]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"MacBuilding"],

Cell[TextData[{
  "The general procedure for building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs is to include \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] in any C or C++ source files that make ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " function calls, to compile your source files, and then to link the \
resulting object code with the \[OpenCurlyDoubleQuote]libML.a\
\[CloseCurlyDoubleQuote] library and any other standard libraries required by \
your application.  If your application uses the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template mechanism, then your template files must first be processed into \
a C source file using \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->"MacBuilding"],

Cell[CellGroupData[{

Cell["Using \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"mprep", "MacBuilding"}],

Cell[TextData[{
  "If your program uses the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template mechanism as described in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ", you must simultaneously preprocess source files containing template \
entries using the \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] \
application.  (A template entry is a sequence of lines that contain template \
keywords.  Each entry defines a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that when evaluated calls an associated C function.)  When \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] processes such source \
files, it converts template entries into C functions, without changing other \
text, and writes out additional C functions that implement a remote procedure \
call mechanism using ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ".  The result is a C source file that is ready for compilation."
}], "Text",
  CellTags->{"mprep", "MacBuilding"}],

Cell["For example, the command", "Text",
  CellTags->{"mprep", "MacBuilding"}],

Cell[TextData[StyleBox["mprep addtwo.tm -o addtwotm.c", "MR"]], "FramedBox",
  CellTags->{"mprep", "MacBuilding"}],

Cell["\<\
will produce a C source file \[OpenCurlyDoubleQuote]addtwotm.c\
\[CloseCurlyDoubleQuote] from the template entries and the other text remains \
in \[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote].  You would then \
compile the output file using the C compiler.  If you use the \
\[OpenCurlyDoubleQuote]Make\[CloseCurlyDoubleQuote] utility to build your \
program, you could add a rule similar to the following to your \
makefile.\
\>", "Text",
  CellTags->{"mprep", "MacBuilding"}],

Cell[TextData[StyleBox["addtwotm.c  :  addtwo.tm\n    mprep  addtwo.tm  -o \
addtwotm.c", "MR"]], "FramedBox",
  CellTags->{"mprep", "MacBuilding"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs from the Command Line"
}], "Subsection",
  CellTags->"MacBuilding"],

Cell[TextData[{
  "What follows is a sample makefile needed to build the sample programs in \
the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kit, including \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote].  To build a sample program, in this case \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote], evaluate the following \
command in the MathLinkExamples directory."
}], "Text",
  CellTags->"MacBuilding"],

Cell[TextData[StyleBox["make addtwo", "MR"]], "FramedBox",
  CellTags->"MacBuilding"],

Cell[CellGroupData[{

Cell["Makefile", "Subsubsection",
  CellTags->"MacBuilding"],

Cell[TextData[StyleBox["# This makefile can be used to build all or some of \
the sample\n# programs.  To build all of them, use the command\n# 'make all'. \
 To build one, say addtwo, use the command\n# 'make addtwo'.\n\nMLINKDIR = \
/usr/local/mathematica/AddOns/MathLink/DeveloperKit\nSYS = Darwin\nCADDSDIR = \
${MLINKDIR}/${SYS}/CompilerAdditions\n\nINCDIR = ${CADDSDIR}\nLIBDIR = \
${CADDSDIR}\n\nMPREP = ${CADDSDIR}/mprep\n\nall : addtwo bitops counter \
factor factor2 factor3 quotient reverse sumalist\n\naddtwo : addtwotm.o \
addtwo.o\n\t${CC} -I${INCDIR} addtwotm.o addtwo.o -L${LIBDIR} -lML -lm -o $@\n\
\nbitops : bitopstm.o bitops.o\n\t${CC} -I${INCDIR} bitopstm.o bitops.o \
-L${LIBDIR} -lML -lm -o $@\n\ncounter : countertm.o\n\t${CC} -I${INCDIR} \
countertm.o -L${LIBDIR} -lML -lm -o $@\n\nfactor : factor.o\n\t${CC} \
-I${INCDIR} factor.o -L${LIBDIR} -lML -lm -o $@\n\nfactor2 : factor2.o\n\t\
${CC} -I${INCDIR} factor2.o -L${LIBDIR} -lML -lm -o $@\n\nfactor3 : factor3.o\
\n\t${CC} -I${INCDIR} factor3.o -L${LIBDIR} -lML -lm -o $@\n\nquotient : \
quotient.o\n\t${CC} -I${INCDIR} quotient.o -L${LIBDIR} -lML -lm -o $@\n\n\
reverse : reversetm.o\n\t${CC} -I${INCDIR} reversetm.o -L${LIBDIR} -lML -lm \
-o $@\n\nsumalist : sumalisttm.o sumalist.o\n\t${CC} -I${INCDIR} sumalisttm.o \
sumalist.o -L${LIBDIR} -lML -lm -o $@\n\n.c.o :\n\t${CC} -c -I${INCDIR} $<\n\n\
addtwotm.c : addtwo.tm\n\t${MPREP} $? -o $@\n\nbitopstm.c : bitops.tm\n\t\
${MPREP} $? -o $@\n\ncountertm.c : counter.tm\n\t${MPREP} $? -o $@\n\n\
reversetm.c : reverse.tm\n\t${MPREP} $? -o $@\n\nsumalisttm.c : sumalist.tm\n\
\t${MPREP} $? -o $@", "MR"]], "FramedBox",
  CellTags->"MacBuilding"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building Darwin ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs with Project Builder"
}], "Subsection",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Creating a project for \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote]\
\>", "Subsubsubsection",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
To create a project that can be used to edit, build, and debug \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote]:\
\>", \
"NumberedGestureHead",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start Project Builder."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  From the File menu, choose New Project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["The New Project dialog box appears.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox["3",
    FontWeight->"Bold"],
  "  In the New Project box, select Standard Tool and then click Next."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["The New Standard Tool dialog box appears.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Create the Project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
In the New Standard Tool dialog box, enter addtwo as the project \
name, and hit the tab key.  The default location for your project will be \
~/addtwo/.  This is a directory in your home directory called addtwo (e.g. \
/Users/<login name>/addtwo).  Later steps assume that you use this default \
directory.  Click Finish.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Copy the source files to the project directory."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  "Start the Terminal application and change the directory (cd) to where ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "was installed.  When you reach that directory, cd to ",
  StyleBox["Mathematica.app/Addons/MathLink/",
    FontFamily->"Courier"],
  "DeveloperKit",
  StyleBox["/Darwin/MathLinkExamples",
    FontFamily->"Courier"],
  "."
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox["cd <path to ",
    FontFamily->"Courier"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[">\ncd Mathematica.app/Addons/MathLink/",
    FontFamily->"Courier"],
  "DeveloperKit",
  StyleBox["/Darwin/MathLinkExamples",
    FontFamily->"Courier"]
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Copy the addtwo source files to your project directory that you \
chose in step 4 using the copy (cp) command.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[StyleBox["cp addtwo.tm addtwo.c ~/addtwo/",
  FontFamily->"Courier"]], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Run mprep on the template file."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["Change directory to the project directory.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[StyleBox["cd ~/addtwo/",
  FontFamily->"Courier"]], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["Use mprep to generate a source file.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[StyleBox["./mprep addtwo.tm -o addtwo.tm.c",
  FontFamily->"Courier"]], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change the directory to the project directory."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Add files to the project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Click the Finder icon in the Dock to make the Finder active.  Press \
the Home button and open the addtwo directory.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Drag the file addtwo.c from the Finder window to the Source group \
of the Groups & Files list in Project Builder.  Click Add in the sheet that \
appears.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Drag the file addtwo.tm.c from the Finder window to the Source \
group of the Groups & Files list in Project Builder.  Click Add in the sheet \
that appears.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  "Click the Finder icon in the Dock to make the Finder active.  Go to the \
folder where ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is installed."
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  "Click on the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " icon while pressing the Control key.  A pop-up menu will appear.  Select \
Show Package Contents to view the contents of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  Open the folders AddOns/MathLink/",
  "DeveloperKit",
  StyleBox["/Darwin/CompilerAdditions.",
    FontFamily->"Lucida Grande"]
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Drag the file mathlink.h from the Finder window to the Source group \
to the Groups & Files list in Project Builder.  Make sure that Copy items \
into destination folder is not checked and click the Add button.\
\>", \
"NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Drag the file libML.a from the Finder window to the Source group to \
the Groups & Files list in Project Builder.  Make sure that Copy items into \
destination folder is not checked and click the Add button.\
\>", \
"NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Remove main.c from the project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Select main.c in the Groups & Files list of Project Builder and \
choose Delete from the Edit menu.  Press Delete in the Sheet that \
appears.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Build the project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["From the Build menu, select Build.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Creating a project for \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote]\
\>", "Subsubsubsection",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
To create a project that can be used to edit, build, and debug \
\[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote]:\
\>", \
"NumberedGestureHead",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Start Project Builder."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  From the File menu, choose New Project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["The New Project dialog box appears.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  In the New Project box, select Standard Tool and then click Next."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["The New Standard Tool dialog box appears.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Create the Project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
In the New Standard Tool dialog, enter factor as the project name \
and hit the tab key.  The default location for your project will be \
~/factor/.  This is a directory in your home directory called factor (e.g. \
/Users/<login name>/factor).  Later steps assume that you use this default \
directory.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["Click Finish.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Copy the source files to the project directory."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  "Start the Terminal application and change the directory (cd) to where ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "was installed.  When you reach that directory, cd to ",
  StyleBox["Mathematica.app/Addons/MathLink/",
    FontFamily->"Courier"],
  "DeveloperKit",
  StyleBox["/Darwin/MathLinkExamples",
    FontFamily->"Courier"],
  "."
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox["cd <path to ",
    FontFamily->"Courier"],
  StyleBox["Mathematica",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[">\ncd Mathematica.app/Addons/MathLink/",
    FontFamily->"Courier"],
  "DeveloperKit",
  StyleBox["/Darwin/MathLinkExamples",
    FontFamily->"Courier"]
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Copy the factor source files to your project directory that you \
chose in step 4 using the copy (cp) command.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox["cp ",
    FontFamily->"Courier"],
  "factor",
  StyleBox[".tm ",
    FontFamily->"Courier"],
  "factor",
  StyleBox[".c ~/",
    FontFamily->"Courier"],
  "factor",
  StyleBox["/",
    FontFamily->"Courier"]
}], "NumberedGestureRemark",
  FontFamily->"Courier",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Change directory to the project directory."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox["7",
    FontWeight->"Bold"],
  "  Add files to the project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Click the Finder icon in the Dock to make the Finder active.  Press \
the Home button and open the factor directory.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Drag the file factor.c from the Finder window to the Source group \
of the Groups & Files list in Project Builder.  Click Add in the sheet that \
appears.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  "Click the Finder icon in the Dock to make the Finder active.  Go to the \
folder where ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is installed."
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  "Click on the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " icon while pressing the Control key.  A pop-up menu will appear.  Select \
Show Package Contents to view the contents of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  Open the folders AddOns/MathLink/",
  "DeveloperKit",
  StyleBox["/Darwin/CompilerAdditions.",
    FontFamily->"Lucida Grande"]
}], "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Drag the file mathlink.h from the Finder window to the Source group \
to the Groups & Files list in Project Builder.  Make sure that Copy items \
into destinations folder is not checked and click the Add button.\
\>", \
"NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Drag the file libML.a from the Finder window to the Source group to \
the Groups & Files list in Project Builder.  Make sure that Copy items into \
destinations folder is not checked and click the Add button.\
\>", \
"NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Remove main.c from the project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["\<\
Select main.c in the Groups & Files list of Project Builder and \
choose Delete from the Edit menu.  Press the Delete button in the dialog box \
that appears.\
\>", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell[TextData[{
  StyleBox[
  CounterBox["NumberedGesture"],
    FontWeight->"Bold"],
  "  Build the project."
}], "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],

Cell["From the Build menu, select Build.", "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote]", "Subsection",
  CellTags->{"mcc", "MacBuilding"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] is a script that \
preprocesses and compiles your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " source files.  It will preprocess ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " templates in any file whose name ends with .tm, and then call \
\[OpenCurlyDoubleQuote]cc\[CloseCurlyDoubleQuote] on the resulting C source \
code.  \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] will pass \
command-line options and other files directly to cc.  Following is a command \
that would build the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] \
application using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"mcc", "MacBuilding"}],

Cell[TextData[StyleBox["mcc addtwo.tm addtwo.c -o addtwo", "MR"]], "FramedBox",
  CellTags->{"mcc", "MacBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using a pre-ANSI C compiler"
}], "Subsection",
  CellTags->{"preANSI", "MacBuilding"}],

Cell[TextData[{
  "If you are using a pre-ANSI C compiler, you will have to modify the way \
you build ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  To build an application using a C compiler that does not \
support prototypes, set the macro ",
  StyleBox["MLPROTOTYPES",
    FontFamily->"Courier"],
  " to 0 in your code.  One way to do this is to include the following line \
in your code (before the line ",
  StyleBox["#include \"mathlink.h\"",
    FontFamily->"Courier"],
  ")"
}], "Text",
  CellTags->{"preANSI", "MacBuilding"}],

Cell[TextData[StyleBox["#define MLPROTOTYPES 0", "MR"]], "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}],

Cell[TextData[{
  "If you are building a template-based program, the above step won't work \
since mprep will not add this line to the C files it generates.  In this \
case, you can pass the flag ",
  StyleBox["-DMLPROTOTYPES=0",
    FontFamily->"Courier"],
  " to your C compiler.  Here are two ways to do that: one with a makefile, \
the other using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"preANSI", "MacBuilding"}],

Cell[CellGroupData[{

Cell["Makefile", "Subsubsection",
  CellTags->{"preANSI", "MacBuilding"}],

Cell[TextData[StyleBox["# This makefile can be used to build all or some of \
the sample\n# programs.  To build all of them, use the command\n# 'make all'. \
 To build one, say addtwo, use the command\n# 'make addtwo'.\n\nMLINKDIR = \
/usr/local/mathematica/AddOns/MathLink/DeveloperKit\nSYS = Darwin\nCADDSDIR = \
${MLINKDIR}/${SYS}/CompilerAdditions\n\nINCDIR = ${CADDSDIR}\nLIBDIR = \
${CADDSDIR}\n\nMPREP = ${CADDSDIR}/mprep\n\nall : addtwo bitops counter \
factor factor2 factor3 quotient reverse sumalist\n\naddtwo : addtwotm.o \
addtwo.o\n\t${CC} -I${INCDIR} addtwotm.o addtwo.o -L${LIBDIR} -lML -lm -o $@\n\
\nbitops : bitopstm.o bitops.o\n\t${CC} -I${INCDIR} bitopstm.o bitops.o \
-L${LIBDIR} -lML -lm -o $@\n\ncounter : countertm.o\n\t${CC} -I${INCDIR} \
countertm.o -L${LIBDIR} -lML -lm -o $@\n\nfactor : factor.o\n\t${CC} \
-I${INCDIR} factor.o -L${LIBDIR} -lML -lm -o $@\n\nfactor2 : factor2.o\n\t\
${CC} -I${INCDIR} factor2.o -L${LIBDIR} -lML -lm -o $@\n\nfactor3 : factor3.o\
\n\t${CC} -I${INCDIR} factor3.o -L${LIBDIR} -lML -lm -o $@\n\nquotient : \
quotient.o\n\t${CC} -I${INCDIR} quotient.o -L${LIBDIR} -lML -lm -o $@\n\n\
reverse : reversetm.o\n\t${CC} -I${INCDIR} reversetm.o -L${LIBDIR} -lML -lm \
-o $@\n\nsumalist : sumalisttm.o sumalist.o\n\t${CC} -I${INCDIR} sumalisttm.o \
sumalist.o -L${LIBDIR} -lML -lm -o $@\n\n.c.o :\n\t${CC} -DMLPROTOTYPES=0 -c \
-I${INCDIR} $<\n\naddtwotm.c : addtwo.tm\n\t${MPREP} $? -o $@\n\nbitopstm.c : \
bitops.tm\n\t${MPREP} $? -o $@\n\ncountertm.c : counter.tm\n\t${MPREP} $? -o \
$@\n\nreversetm.c : reverse.tm\n\t${MPREP} $? -o $@\n\nsumalisttm.c : \
sumalist.tm\n\t${MPREP} $? -o $@", "MR"]], "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] to build \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote]", "Subsubsection",
  CellTags->{"preANSI", "MacBuilding"}],

Cell["\<\
Following is a command that would build \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] with a pre-ANSI \
compiler using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote].\
\>", \
"Text",
  CellTags->{"preANSI", "MacBuilding"}],

Cell[TextData[StyleBox["mcc -DMLPROTOTYPES=0 addtwo.tm addtwo.c -o addtwo", \
"MR"]], "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}],

Cell["\<\
Don't forget to modify the sample C files so they don't use \
prototypes.  For example, here is a modified version of addtwo.c.\
\>", "Text",\

  CellTags->{"preANSI", "MacBuilding"}],

Cell[TextData[StyleBox["#include \"mathlink.h\"\n\nint addtwo(i,j) int i, j;\n\
{\n        return i + j;\n}\n\nint main(argc, argv) int argc; char *argv[];\n\
{\n        return MLMain(argc, argv);\n}", "MR"]], "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"MacRunning"],

Cell[TextData[{
  "The instructions in the previous section describe how to build two ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using source code in the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory.  This section shows how to run those \
programs."
}], "Text",
  CellTags->"MacRunning"],

Cell[CellGroupData[{

Cell["Running \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"addtwo", "MacRunning"}],

Cell[TextData[{
  "The first example program, \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote], is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template program that is installed into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  That is, this program runs in the background, providing, as a service \
to ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " one or more externally compiled functions.  To the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " user, these functions appear to be built-in.  The \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] program uses a template \
file that defines the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "function ",
  StyleBox["AddTwo[]",
    FontFamily->"Courier"],
  " as a call to the C function ",
  StyleBox["addtwo()",
    FontFamily->"Courier"],
  ".  (The template mechanism is described in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ".)  The source code for this program looks likes this."
}], "Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[TextData[StyleBox[":Begin:\n:Function:       addtwo\n:Pattern:        \
AddTwo[i_Integer, j_Integer]\n:Arguments:      { i, j }\n:ArgumentTypes:  { \
Integer, Integer }\n:ReturnType:     Integer\n:End:\n\n:Evaluate: \
AddTwo::usage = \"AddTwo[x, y] gives the sum of two machine integers x and y.\
\"\n\nint addtwo( int i, int j)\n{\n\treturn i+j;\n}\n\nint main(int argc; \
char* argv[])\n{\n\treturn MLMain(argc, argv);\n}", "MR"]], "FramedBox",
  CellTags->{"addtwo", "MacRunning"}],

Cell["\<\
Edit the path string below and evaluate the following two \
cells:\
\>", "Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(SetDirectory[\ "\<path to addtwo program\>"]\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(link\  = \ Install["\<./addtwo\>", \ LinkMode -> Launch]\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell["\<\
To see a list of the newly available functions, evaluate the \
following cell.\
\>", "Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(LinkPatterns[link]\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell[TextData[{
  "This displays the usage message for the ",
  StyleBox["AddTwo",
    FontFamily->"Courier"],
  " function as defined in the file \[OpenCurlyDoubleQuote]addtwo.tm\
\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(\(?AddTwo\)\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell["Now try it.", "Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(AddTwo[2, \ 3]\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell["\<\
See what happens if the sum of the two machine integers won't fit \
in a machine integer or if either argument is not a machine integer:\
\>", \
"Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[2^31 - 1, \ 1]\)\(\ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell[TextData[StyleBox["2^31-1 is the largest machine integer.\n   If your \
compiler uses 2-byte ints, then 2^15-1 is the largest C int.", "MR"]], \
"FramedBox",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[2^31, \ 1]\)\(\ \ \ \ \ \ \ \ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell[TextData[StyleBox["The addtwo program is not prepared for big \
integers.", "MR"]], "FramedBox",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[x, \ 
      1]\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell[TextData[StyleBox["This doesn't match AddTwo[_Integer, _Integer].", \
"MR"]], "FramedBox",
  CellTags->{"addtwo", "MacRunning"}],

Cell[TextData[{
  StyleBox["Install[]",
    FontFamily->"Courier"],
  " called ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  " and then exchanged information with the external program to set up the \
definition for ",
  StyleBox["AddTwo[]",
    FontFamily->"Courier"],
  ".  You really don't have to worry about these details, but if you are \
curious, evaluate:"
}], "Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(?? AddTwo\)], "Input",
  CellTags->{"addtwo", "MacRunning"}],

Cell["When you are finished using the external program, evaluate:", "Text",
  CellTags->{"addtwo", "MacRunning"}],

Cell[BoxData[
    \(Uninstall[link]\)], "Input",
  CellTags->{"addtwo", "MacRunning"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Running \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"factor", "MacRunning"}],

Cell[TextData[{
  "The second example program, \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote], is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end in the sense that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel runs in the background providing, as a service to \
\[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote], the computational \
services of the kernel\[LongDash]in this case, the ability to factor an \
integer typed by the user."
}], "Text",
  CellTags->{"factor", "MacRunning"}],

Cell["\<\
Launch the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
application by executing the following command.\
\>", "Text",
  CellTags->{"factor", "MacRunning"}],

Cell[TextData[StyleBox["factor -linkmode launch -linkname 'math -mathlink'", \
"MR"]], "FramedBox",
  CellTags->{"factor", "MacRunning"}],

Cell["\<\
After a moment, a prompt will appear requesting that you type an \
integer.  Type an integer with fewer than 10 digits and press the Return key. \
 (The other factor examples relax the restriction on the size of integer you \
may type in.)\
\>", "Text",
  CellTags->{"factor", "MacRunning"}],

Cell[TextData[StyleBox["Integer to factor:", "MR"]], "FramedBox",
  CellTags->{"factor", "MacRunning"}],

Cell[TextData[{
  "The prime factors returned by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are printed, and \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
closes its link with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"factor", "MacRunning"}],

Cell[TextData[StyleBox["Integer to factor: 123456789\n3 ^ 2\n3607 ^ 1\n3803 ^ \
1", "MR"]], "FramedBox",
  CellTags->{"factor", "MacRunning"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Supported Link Protocols", "Subsection",
  CellTags->{"protocols", "MacRunning"}],

Cell[TextData[{
  "The C function ",
  StyleBox["MLOpenArgv()",
    FontFamily->"Courier"],
  " and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  " are documented in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ".  On Macintosh OS X machines, the legal values for the LinkProtocol \
option are \"TCPIP\", \"TCP\", \"Pipes\", and \"Local\".  A LinkProtocol is \
the mechanism used to transport data from one end of a connection to the \
other.  The default is \"TCPIP\" for all LinkModes except LoopBack and \
Launch.  LinkMode->Launch uses the \"Pipes\" LinkProtocol. (The \
\[OpenCurlyDoubleQuote]Local\[CloseCurlyDoubleQuote] protocol is most useful \
in C programs for storing expressions or for inter-thread communication.)"
}], "Text",
  CellTags->{"protocols", "MacRunning"}],

Cell[TextData[{
  "Note that link names are unsigned 16-bit integers for the \"TCPIP\" and \
\"TCP\" protocols.  Even though \"TCPIP\" link names are integers, they are \
still given as strings (of digits) to ",
  StyleBox["MLOpenArgv()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"protocols", "MacRunning"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Porting Version 2.2 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"MacPorting"],

Cell[CellGroupData[{

Cell[TextData[{
  "Changes to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " API since Version 2.2 (Interface 0)"
}], "Subsection",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "Several changes have been made to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " application programming interface (API).  To the extent possible, the new \
interface is compatible with the old.  If you intend to use existing code \
written to the old interface, with a new ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library, then you ",
  StyleBox["must",
    FontSlant->"Italic"],
  " read the following."
}], "Text",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "The new ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library is both source code compatible and \[OpenCurlyDoubleQuote]runtime\
\[CloseCurlyDoubleQuote] compatible with older libraries.  (Source code \
compatible means that \
\[OpenCurlyDoubleQuote]correctly\[CloseCurlyDoubleQuote] written ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs are still correct when recompiled and linked with the new \
library.  Runtime compatible means that programs linked with the new library \
are able to connect to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs linked with any previous ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library.  Note that the new libraries are not \[OpenCurlyDoubleQuote]link\
\[CloseCurlyDoubleQuote] compatible with old ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries.  That is, if you want to relink your program you must also \
recompile it.  For this reason, shared library implementations of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " have had their version information changed.)"
}], "Text",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "The problem is that many working programs may not be strictly correct and \
will not continue to work, unless unmodified.  You can choose to leave these \
programs as they are\[LongDash]linked with an older ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library\[LongDash]or edit, recompile, and relink them.  The reason a \
number of such programs may exist is because the old interface was not \
carefully described."
}], "Text",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "You can, after considering the following points, choose to make your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs correct by properly using the old API.  Or you may want to just \
use some features of the new API that are more convenient and more \
efficient."
}], "Text",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "The following is a discussion of the issue most likely needing your \
attention in porting existing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  Read this and then the list of points to consider."
}], "Text",
  CellTags->{"changes", "MacPorting"}],

Cell[CellGroupData[{

Cell["The Biggest Compatibility Issue", "Subsubsection",
  CellTags->{"changes", "strings", "MacPorting"}],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " strings and symbols can contain characters with codes ranging from 0 to \
65535\[LongDash]that is, characters that can be represented by unsigned \
16-bit integers.  Previously, the arguments to the string and symbol \
functions in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " were not represented with arrays of unsigned 16-bit integers, but rather \
with sequences of 8-bit bytes.  How ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " encoded 16-bit characters as a sequence of bytes was private.  Hence, to \
construct or interpret the arguments to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " string and symbol functions as a sequence of characters required some \
preprocessing before calling, for example, ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " or some postprocessing after calling ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"changes", "strings", "MacPorting"}],

Cell[TextData[{
  "If this additional processing was not done when putting and getting \
strings and symbols, the program was likely not to be correct even if it \
appeared to work.  It worked if the strings and symbols used in the program \
happened to be represented in the same way as ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " represented them in the private encoding.  In Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", this private encoding has changed in such a way that it is far more \
likely to cause incorrect programs to fail.  (In previous versions of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", characters with codes from 1 to 247 were represented literally by a \
single byte with that value, and a byte with value zero was not used in the \
encoding of any character.)  In Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", only 94 characters are represented literally when using the same \
function calls."
}], "Text",
  CellTags->{"changes", "strings", "MacPorting"}],

Cell[TextData[{
  "The following code shows a correct way to extract and interpret the \
individual characters encoded in the byte sequence returned by ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  ".  This source code will work with Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " as well as previous versions."
}], "Text",
  CellTags->{"changes", "strings", "MLforString", "MacPorting"}],

Cell[TextData[StyleBox["void get_characters( MLINK link)\n{\n\t\
MLStringPosition pos;\n\tunsigned short char_code;\n\tchar* s;\n\n\tif( \
MLGetString( link, &s)){\n\t\tMLforString( s, pos){\n\t\t\tchar_code = \
MLStringChar( pos);\n\t\t\tuse_the_character_code( char_code);\n\t\t}\n\t\t\
MLDisownString( link, s);\n\t}\n}", "MR"]], "FramedBox",
  CellTags->{"changes", "strings", "MLforString", "MacPorting"}],

Cell[TextData[{
  "Now with Version 3 of ",
  StyleBox["MathLink ",
    FontSlant->"Italic"],
  "(Interface 1 or later), you can extract characters from a byte sequence \
that is not necessarily terminated with a zero byte.  The new function ",
  StyleBox["MLNextCharacter()",
    FontFamily->"Courier"],
  " takes a pointer to the end of the byte sequence (and that pointer need \
not point to a zero byte).  This function returns a negative number when it \
gets to the end.  The source code below does the same thing as the source \
code in the preceding paragraph."
}], "Text",
  CellTags->{"MLNextCharacter", "changes", "strings", "MacPorting"}],

Cell[TextData[StyleBox["#if MLVERSION < 3\n#error MLNextCharacter is not \
available before Version 3.\n#endif\n\nvoid get_characters( MLINK link)\n{\n\t\
long char_code;\n\tchar* s;\n\n\tif( MLGetString( link, &s)){\n\t\tchar* p = \
s;\n\t\tchar* end = s + strlen(s);\n\t\twhile( (char_code = MLNextCharacter( \
&p, end)) >= 0){\n\t\t\tuse_the_character_code( char_code);\n\t\t}\n\t\t\
MLDisownString( link, s);\n\t}\n}", "MR"]], "FramedBox",
  CellTags->{"changes", "strings", "MLNextCharacter", "MacPorting"}],

Cell[TextData[{
  "To construct a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " string from a sequence of character codes, you would call ",
  StyleBox["MLPutCharToString()",
    FontFamily->"Courier"],
  " in a loop.  The code below uses two loops, one to measure the size of the \
private ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " representation, and another to actually encode the characters of the \
string before calling ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"MLPutCharToString", "changes", "strings", "MacPorting"}],

Cell[TextData[StyleBox["void put_characters( MLINK link, unsigned short \
char_codes[], long len)\n{\n\tlong i, size;\n\tchar* s;\n\n\tfor( i = 0, size \
= 0; i < len; ++i){\n\t\tsize += MLPutCharToString( char_codes[i], NULL);\n\t\
}\n\n\ts = (char*)malloc( size + 1);\n\n\tif( s){\n\t\tchar* p;\n\t\tfor( i = \
0, p = s; i < len; ++i){\n\t\t\tMLPutCharToString( char_codes[i], &p);\n\t\t}\
\n\t\t*p = '\\0';\n\t\tMLPutString( link, s);\n\t\tfree(s);\n\t}\n}", "MR"]], \
"FramedBox",
  CellTags->{"changes", "strings", "MLPutCharToString", "MacPorting"}],

Cell[TextData[{
  "Now with Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", you can replace the two loops with two function calls.  The function ",
  StyleBox["MLConvertUnicodeString()",
    FontFamily->"Courier"],
  ", when passed a zero pointer as its last argument, returns in ",
  StyleBox["s",
    FontFamily->"Courier"],
  " the size required to encode the given characters.  When passed a non-zero \
pointer to the end of a buffer, ",
  StyleBox["MLConvertUnicodeString()",
    FontFamily->"Courier"],
  " actually encodes the characters.  The source code below does the same \
thing as the source code in the preceding paragraph."
}], "Text",
  CellTags->{"MLConvertUnicodeString", "changes", "strings", "MacPorting"}],

Cell[TextData[StyleBox["#if MLVERSION < 3\n#error MLConvertUnicodeString is \
not available before Version 3.\n#endif\n\nvoid put_characters( MLINK link, \
unsigned short char_codes[], long len)\n{\n\tlong size;\n\tchar* s;\n\n\t\
MLConvertUnicodeString( char_codes, len, &s, 0);\n\tsize = s - (char*)0;\n\n\t\
s = (char*)malloc( size + 1) ;\n\n\tif( s){\n\t\tchar* p = s;\n\t\t\
MLConvertUnicodeString( char_codes, len, &p, p + size);\n\t\t*p = '\\0';\n\t\t\
MLPutString( link, s);\n\t\tfree(s);\n\t}\n}", "MR"]], "FramedBox",
  CellTags->{"changes", "strings", "MLConvertUnicodeString", "MacPorting"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Points to Consider", "Subsubsection",
  CellTags->{"changes", "MacPorting"}],

Cell["\<\
This list of considerations may change from one revision to the \
next.\
\>", "Text",
  CellTags->"MacPorting"],

Cell[TextData[{
  "Some undocumented functions may have changed.  If you discover and use any \
undocumented functions, you should check their declarations and behavior with \
any new release.   Functions are undocumented if they are experimental.  You, \
of course, are free to use them, provided you understand that they may change \
in subsequent ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " releases.  An undocumented function may become documented in a future \
release, become documented in a modified form, become unnecessary, be \
provided in source code only, or on rare occasions be removed altogether.  \
The header file \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote], \
although sometimes enlightening, does not constitute documentation."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "If you care to make your source compatible with the old ",
  StyleBox["and",
    FontSlant->"Italic"],
  " new APIs and still take advantage of new features, note that the new \
header file defines the macro ",
  StyleBox["#define\[NonBreakingSpace]MLVERSION\[NonBreakingSpace]3",
    FontFamily->"Courier",
    FontSize->10],
  "  which you can test for."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[StyleBox["#if MLVERSION < 3\n\t...old cumbersome stuff if you \
want\n#else\n\t...new more convenient stuff\n#endif", "MR"]], "FramedBox",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "Some pointer declarations have had the ",
  StyleBox["const",
    FontFamily->"Courier"],
  " type qualifier added to indicate either that ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " does not modify your data or that you should not modify ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "'s data.  You may have to add the ",
  StyleBox["const",
    FontFamily->"Courier"],
  " type qualifier to some of your variable declarations."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "If you called ",
  StyleBox["MLGetArgCount()",
    FontFamily->"Courier"],
  " after calling ",
  StyleBox["MLGetFunction()",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLCheckFunction()",
    FontFamily->"Courier"],
  " or otherwise began to read the head of the composite expression, this is \
an error and it will no longer work.  If you need the argument count of the \
current composite expression, then you must remember it from when it was \
first returned by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->{"MLGetArgCount", "changes", "MacPorting"}],

Cell[TextData[{
  "If you called ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " before calling ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  " when getting the data of symbols, strings, or numbers, this is an error \
and it will no longer work.  Simply add a call to ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  " before your first call to ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->{"MLGetData", "changes", "MacPorting"}],

Cell[TextData[{
  "If you assume that ",
  StyleBox["MLGetData( link, buff, len, &got)",
    FontFamily->"Courier"],
  " will return ",
  StyleBox["got == len",
    FontFamily->"Courier"],
  " as long as ",
  StyleBox["len",
    FontFamily->"Courier"],
  " was no greater than indicated by ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  ", then this is an error.  ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " may choose to deliver fewer than len bytes if required to preserve \
character boundaries.  And note that it may take several bytes to encode some \
characters."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "Again note the way that strings are represented by ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  ", ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " and related functions has changed.  Now, the only characters represented \
literally are the characters from ASCII 32 (space) to ASCII 126 (tilde) \
except ASCII 92 (backslash).  All other characters (0...31, 92, 127...65535) \
are represented by multibyte escape sequences.  Previous versions of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " represented more characters literally (codes 1...247)."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "So, for example, ",
  StyleBox["MLPutString( link, \"hello\")",
    FontFamily->"Courier"],
  " was and is OK.  But ",
  StyleBox["MLPutString( link, \"C:\\\\winmath\\\\\")",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLPutString( link, \"\\n\")",
    FontFamily->"Courier"],
  " will no longer work."
}], "IndentedText",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "If your string literals used only characters in the new more restricted \
range and if you always used the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " iterator functions ",
  StyleBox["MLPutCharToString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLStringChar()",
    FontFamily->"Courier"],
  " in a loop as described above to encode and decode other ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " strings, then your program was correct and still is.  If not, your \
program will have to be modified to work with the new library."
}], "IndentedText",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "You cannot assume that ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " represents a given string in a unique canonical way.  So, for example, \
you cannot:"
}], "BulletedList",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],

Cell[TextData[StyleBox["MLGetString( link, &s);\nif( strcmp( \"hello\", s) != \
0)\n\tdidnt_get_hello();  /* error! */", "MR"]], "FramedBox",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],

Cell[TextData[{
  "Instead you must extract the characters from ",
  StyleBox["s",
    FontFamily->"Courier"],
  " using the iterator and compare them one by one to the characters of ",
  StyleBox["\"hello\"",
    FontFamily->"Courier"],
  ".  There currently is no function in the library for doing this.  \
Alternatively, you could use one of the new string functions that represents \
",
  StyleBox["all",
    FontSlant->"Italic"],
  " characters literally.  For example, the following code is correct."
}], "IndentedText",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],

Cell[TextData[StyleBox["MLGetByteString( link, &s, &len, '\\0');\nif( len != \
5 || strcmp( \"hello\", s) != 0)\n\tdidnt_get_hello();", "MR"]], "FramedBox",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],

Cell[TextData[{
  "If instead of calling ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " you called ",
  StyleBox["MLPutSize()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  ", realize that the use of these functions is now strongly discouraged as \
there are improved means to do these things.  Further, their implementation \
is now rather inefficient as they exist only for backward compatibility.  \
Further still, everything mentioned above about ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " regarding the representation of characters applies to ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->{"MLBytesToGet", "changes", "MacPorting"}],

Cell[TextData[{
  "All points in this section regarding strings apply equally to symbols.  \
Moreover, it is easy to forget that the second argument to ",
  StyleBox["MLPutFunction()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLCheckFunction()",
    FontFamily->"Courier"],
  " must also be properly encoded, although these are most often called with \
a string literal containing only characters within the restricted range."
}], "BulletedList",
  CellTags->{"MLPutFunction", "changes", "MacPorting"}],

Cell[TextData[{
  "If you call ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLBegin()",
    FontFamily->"Courier"],
  " with a non-zero argument, the structure of that argument has changed."
}], "BulletedList",
  CellTags->{"MLInitialize", "changes", "MacPorting"}],

Cell[TextData[{
  "If you call the undocumented functions ",
  StyleBox["MLSetUserData()",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  ", the behavior of these functions has changed."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "If you used ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " to deal with numbers textually, realize that you can still do that but, \
as mentioned above, there is now a better way."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "The values of the macros ",
  StyleBox["MLTKINT",
    FontFamily->"Courier"],
  ", etc., have changed.  If you used their literal values rather than these \
macros, your program will need to be corrected."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "All function pointers passed to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " must point to code that follows the standard \
\[OpenCurlyDoubleQuote]callback\[CloseCurlyDoubleQuote] calling conventions.  \
These conventions differ considerably between platforms.  On a Macintosh, for \
example, all callback functions are declared ",
  StyleBox["pascal",
    FontFamily->"Courier"],
  ".  On a Windows computer, callbacks must be declared ",
  StyleBox["__stdcall",
    FontFamily->"Courier"],
  ".  To make it easier to write portable code, \
\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] defines macros you \
can use to declare, define, and install your callback functions.  As an \
example, the following code sets up a function called ",
  StyleBox["myhandler",
    FontFamily->"Courier"],
  " to be called whenever a message arrives on a link."
}], "BulletedList",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  StyleBox["MLINK link;\nMLENV env;\nMLMessageHandlerObject handler_object;\n\
\n", "MR"],
  StyleBox["MLMDECL", "MR",
    FontWeight->"Bold"],
  StyleBox["( void, myhandler, ( MLINK mlp, unsigned long m, unsigned long \
n));\n\n", "MR"],
  StyleBox["MLMDEFN", "MR",
    FontWeight->"Bold"],
  StyleBox["( void, myhandler, ( MLINK mlp, unsigned long m, unsigned long \
n))\n{\n\t...\n}\n\nvoid foo(void)\n{\n\thandler_object = \
MLCreateMessageHandler( env, ", "MR"],
  StyleBox["NewMLHandlerProc", "MR",
    FontWeight->"Bold"],
  StyleBox["( myhandler), 0);\n\tMLSetMessageHandler( link, handler_object);\n\
}", "MR"]
}], "FramedBox",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "The macros ",
  StyleBox["MLMDECL",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLMDEFN",
    FontFamily->"Courier"],
  " (highlighted above in bold face) take care of any qualifiers that need to \
be added to the function's prototype.  The macro ",
  StyleBox["NewMLHandlerProc",
    FontFamily->"Courier"],
  " creates any structure necessary to transfer control between two \
potentially different runtime environments.  (On a Macintosh, for example, \
the OS may need to switch between the native PowerPC environment and the \
emulated 68K environment when ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " calls your function.  On a 16-bit Windows system, the \
\[OpenCurlyDoubleQuote]data segment\[CloseCurlyDoubleQuote] must be switched \
in order for the callback function to access its own global world.)  You \
should not use any casts in these calls so that the compiler can help you \
find type-mismatches.  For 16-bit Windows systems, the macro ",
  StyleBox["NewMLHandlerProc",
    FontFamily->"Courier"],
  " and its relatives require that the variable ",
  StyleBox["MLInstance",
    FontFamily->"Courier"],
  " (declared in \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]) \
be defined and assigned the current instance value passed to ",
  StyleBox["WinMain",
    FontFamily->"Courier"],
  "."
}], "IndentedText",
  CellTags->{"changes", "MacPorting"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Some Advice", "Subsubsection",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "Rather than going back and adding iterators to all your text-based ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " calls, consider using the following new functions."
}], "Text",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],

Cell["\<\
The following are useful if you use Unicode to store your strings.  \
Obviously, no iterators are necessary, as all characters are represented \
literally in the array of unsigned shorts.\
\>", "Text",
  CellTags->{"MLPutUnicodeString", "changes", "MacPorting"}],

Cell[TextData[StyleBox["int MLPutUnicodeString( MLINK mlp, const unsigned \
short* s, long len);\nint MLGetUnicodeString( MLINK mlp, const unsigned \
short** sp, long* lenp);\nvoid MLDisownUnicodeString( MLINK mlp, const \
unsigned short* s, long len);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],

Cell[TextData[{
  "The following are useful for strings that you represent literally as an \
array of bytes and for receiving strings that you ",
  StyleBox["know",
    FontSlant->"Italic"],
  " contain only characters with codes less than 256.  (Your source code that \
puts or gets a ",
  StyleBox["DisplayPacket[]",
    FontFamily->"Courier"],
  " could reasonably use these functions.)  Again, no iterators are necessary \
as all characters are represented literally in the array of type ",
  StyleBox["unsigned char[]",
    FontFamily->"Courier"],
  ".  Note that if ",
  StyleBox["MLGetByteString()",
    FontFamily->"Courier"],
  " encounters a character with code >= 256, it will use the value of ",
  StyleBox["missing",
    FontSlant->"Italic"],
  " in that byte position in the string."
}], "Text",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],

Cell[TextData[StyleBox["int MLPutByteString( MLINK mlp, const unsigned char* \
s, long len);\nint MLGetByteString( MLINK mlp, const unsigned char** sp, \
long* lenp, long missing);\nvoid MLDisownByteString( MLINK mlp, const \
unsigned char* s, long len);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],

Cell["There are symbol analogs to these functions, too.", "Text",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],

Cell[TextData[{
  "If you want to put numbers textually, you can now, unlike in previous \
versions of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ",  precede any of the ",
  StyleBox["MLPut*String()",
    FontFamily->"Courier"],
  " calls with a call to ",
  StyleBox["MLPutNext()",
    FontFamily->"Courier"],
  ".  For example,"
}], "Text",
  CellTags->{"MLPutNext", "changes", "MacPorting"}],

Cell[TextData[StyleBox["MLPutNext( link, MLTKREAL);\nMLPutByteString( link, \
\"1.2\", 3);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLPutNext", "MacPorting"}],

Cell["and, as before, you can get a number as a string.", "Text",
  CellTags->{"MLGetUnicodeString", "changes", "MacPorting"}],

Cell[TextData[StyleBox["unsigned short* s;\nlong len;\nif( MLGetType( link) \
== MLTKREAL)\n\tMLGetUnicodeString(link, &s, &len);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLGetUnicodeString", "MacPorting"}],

Cell[TextData[{
  "If you want to put or get characters ",
  StyleBox["some",
    FontSlant->"Italic"],
  " at a time, there are experimental functions for doing so which are \
preferred over ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  ".  If you want to get textual data into your own memory and not have to \
\[OpenCurlyDoubleQuote]Disown\[CloseCurlyDoubleQuote] anything, there are \
experimental functions for doing so."
}], "Text",
  CellTags->{"changes", "MacPorting"}],

Cell[TextData[{
  "There is now a way to have ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " deal with translating newline characters automatically."
}], "Text",
  CellTags->{"changes", "MacPorting"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Troubleshooting", "Section",
  CellTags->"MacTroubleshooting"],

Cell["\<\
Turn off compiler optimization until your program is working.  This \
makes compiling faster, debugging easier, and, besides, the optimizer may be \
broken and the cause of some problems.  (Don't automatically blame the \
optimizer, however, if your program fails when it is turned on.  Optimized \
code uses the stack and registers differently than unoptimized code in such a \
way that may expose or mask a bug in your code.  For example, the common \
mistake of returning a pointer to a local variable may or may not cause a \
problem depending on stack and register use.)\
\>", "BulletedList",
  CellTags->"MacTroubleshooting"],

Cell[TextData[{
  "Check the return values from the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library functions or call ",
  StyleBox["MLError()",
    FontFamily->"Courier"],
  " at key points in your program.  ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " will often be able to tell you what has gone wrong."
}], "BulletedList",
  CellTags->"MacTroubleshooting"],

Cell[TextData[{
  "The files \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]libML.a\[CloseCurlyDoubleQuote] are a matched set.  If \
you have used an earlier release of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", you should take care that you don't mix components when building your \
application."
}], "BulletedList",
  CellTags->"MacTroubleshooting"],

Cell[TextData[{
  "Check whether the C compiler you are using supports prototypes.  If it \
does not, you will need to change your code and the way you build your \
project.  This is explained in the section ",
  ButtonBox["Building MathLink Programs",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
  "."
}], "BulletedList",
  CellTags->"MacTroubleshooting"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " for UNIX\nDeveloper Guide"
}], "Chapter",
  CellTags->"UnixIntroduction"],

Cell["\<\
Version 4, Revision 14
December 15, 2004\
\>", "CopyrightHead",
  CellTags->"UnixIntroduction"],

Cell["\<\
This document is organized so that you will be most successful if \
you read the sections in order.\
\>", "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "This document describes how to compile and run ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs written in the C language on Unix systems.",
  StyleBox["  ",
    FontSlant->"Italic"],
  "(",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  " describes how to write ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs in both the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " language and the C language.)"
}], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "This document does not teach you, in general, how to use your compiler and \
other development tools, nor does it teach you how to program in C.  If you \
have any trouble building or running your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs, see the troubleshooting section at the end of this document."
}], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Most of what is described in this document is Unix specific, and is \
applicable to all supported Unix platforms.  However, there may be some \
information which is specific to ",
  "UNIX",
  " machines.  To learn how to compile and run ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs for another platform, see the Developer Guide for that \
platform."
}], "Text",
  CellTags->"UnixIntroduction"],

Cell[CellGroupData[{

Cell["Revision History", "Subsection",
  CellTags->"UnixIntroduction"],

Cell[CellGroupData[{

Cell["Changes in Revision 14", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a problem with the library's signal handling code that caused \
programs using SA_SIGINFO type handlers to crash.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a crash that can occur when using TCP links followed by TCPIP \
links in the same session.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 13", "Subsubsection",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a crash that can occur when using Link objects with multiple \
threads of execution.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell[TextData[{
  "MLGetDouble will now correctly fail when trying to read a floating point \
number larger than a machine double value(",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " can transmit a floating point number with arbitrary precision using \
numbers represented as strings).  Previously MLGetDouble would truncate the \
number to the closest machine size floating point number."
}], "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Fixed a significant memory leak in MLTransferExpression.", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Fixed a problem with unnecessary CPU usage in MLGetType.", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["Fixed the broken TCPIP urgent message mechanism on HPUX.", \
"BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The Pipes protocol will now correctly return MLELAUNCHNAME if the \
program to launch passed by argument as the link name to one of the MLOpen* \
functions cannot be found by the operating system.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
The TCPIP protocol will now correctly handle changing machine \
network interfaces on the fly.  Previously the TCPIP protocol bound very \
tightly with the first, primary, network interface available on a system.  \
When users(particularly of notebooks) switch network interfaces, for example \
between an ethernet cable connection and a wireless connection, the TCPIP \
protocol incorrectly continued to use the now unavailable primary network \
connection causing link connection problems.  TCPIP will now correctly \
recognize network interface changes and use the best available interface.  \
Previous versions of the TCPIP protocol also bound interfaces very closely \
with the DNS resolved hostnames for the primary interface.  The DNS name \
would appear in the link names generated by the TCPIP protocol.  The strong \
DNS binding caused problems when switching machines with a statically \
assigned hostname to a new subnet thereby invalidating the machine's DNS to \
interface mapping and causing connection problems due to incorrect hostnames \
in the link name.  TCPIP now uses the IP address of the current interface as \
the primary portion of the link name and will only switch to DNS link names \
if it can resolve the IP number to a correct DNS name.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"],

Cell["\<\
Fixed a significant memory leak seen in MLPutIntegerArray and \
MLGetIntegerArray.\
\>", "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 11", "Subsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Revision 11 includes one new communication protocol, the TCPIP protocol.  \
TCPIP replaces the older protocol TCP.  TCPIP runs significantly faster than \
its predecessor and has some other useful features such as the ability to \
specify the urgent message port number at link creation time.  The TCP \
protocol will remain in the library to enable  communication with older \
versions of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library.  Programmers who plan to use a TCP/IP based protocol in a new \
program should use the TCPIP protocol."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " API functions MLSetEnvIDString0 and MLGetEnvIDString0.  These functions \
allow the programmer to assign a string name to their ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment(perhaps serving as an identifier)prior to opening and \
connecting any link.  The remote side of the connection can then get the \
local program's string after establishing the link.  The programmer may find \
these functions useful if he/she needs to identify a program prior to \
exchanging ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " packets.  The names, functionality, and existence of these functions may \
change in a future release."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " function MLVersionNumber0.  This function exists to allow the programmer \
to query the interface number and revision number of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library used at runtime.  The name, functionality and existence of this \
function may change in a future release."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Added new ",
  StyleBox["experimental",
    FontWeight->"Bold"],
  " functions MLSetSignalHandler0 and MLUnsetSignalHandler0.  These functions \
exist to allow the programmer to install a signal handler call back function \
if the programmer needs a signal handler for a signal that the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library also uses.  For example, the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library makes use of SIGINT, SIGABRT, SIGIO, SIGURG(or SIGPOLL for System \
4 based platforms), SIGTERM, and other signals."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "This revision contains important bug fixes in the Pipes protocol code.  In \
certain circumstances earlier versions of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library forced a crash if the client application opened and closed many \
Pipes protocol links in rapid succession.  This problem no longer exists."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "MLPutMessage will only accept messages whose value will fit inside a 32 \
bit unsigned integer.  A future version of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " will remove this limitation."
}], "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes in Revision 10", "Subsubsection",
  CellTags->"UnixIntroduction"],

Cell["Added a Shared Memory device for Windows in revision 10.", \
"BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Added a Mac OS X version in revision 9.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Internal bug fixes (many).", "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Revision 5", "Subsubsection",
  CellTags->"UnixIntroduction"],

Cell["Shared Library changes", "Subsubsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["\<\
Getting and putting symbols and strings is now, on average, faster.\
\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Getting and putting arrays of numbers is now faster.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["The library was built with an improved optimizing compiler.", \
"BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLCreateMark",
    FontFamily->"Courier"],
  "() is now more efficient."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "There are now functions for putting and getting numbers in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s *^ and ` notations."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The array functions in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " have been generalized to handle arrays with leaves other than machine \
numbers and with leaves that are not all the same type."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLToLinkID",
    FontFamily->"Courier"],
  "() was added as a synonym for ",
  StyleBox["MLNumber",
    FontFamily->"Courier"],
  "().  This function returns a unique identifier for each link object that \
has been opened within the given ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment.  The function ",
  StyleBox["MLFromLinkID",
    FontFamily->"Courier"],
  "() was added.  It returns the link object for a given identifier if that \
link is still open.  Otherwise it returns ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  ".  This function returns the open link object with the minimum identifier \
if 0 is passed in."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " is more compatible with threaded programs."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A debug version of the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library is now released with the standard ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " distribution."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The debug shared library now detects more programming errors.\
\>", \
"BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLReady",
    FontFamily->"Courier"],
  "() now detects more cases when the link has died because the other process \
terminated without calling ",
  StyleBox["MLClose",
    FontFamily->"Courier"],
  "()."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "When ",
  StyleBox["MLTransferExpression",
    FontFamily->"Courier"],
  "() failed, it would sometimes clear the error reported by ",
  StyleBox["MLError",
    FontFamily->"Courier"],
  "().  This has been fixed."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "When ",
  StyleBox["MLDuplicateLink",
    FontFamily->"Courier"],
  "() was called on a loopback link that had not had its input buffer filled \
(e.g. by calling ",
  StyleBox["MLFlush()",
    FontFamily->"Courier"],
  "), it could cause a crash.  This has been fixed."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Creating marks when compact arrays were on the link sometimes \
caused a crash.  This has been fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLErrorString",
    FontFamily->"Courier"],
  "() has a more complete list of error strings."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The semantics of ",
  StyleBox["MLNewParameters()",
    FontFamily->"Courier"],
  " and how ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " does versioning was changed.  See the section in the Macintosh or Windows \
Developer Guides entitled \[OpenCurlyDoubleQuote]Versioning with MathLink\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A bug was fixed that had caused ",
  StyleBox["MLLoopbackOpen()",
    FontFamily->"Courier"],
  " to crash when passed zero as its first argument."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLGetByteString()",
    FontFamily->"Courier"],
  " now always returns a null terminated string.  (A Mac compiler bug \
sometimes prevented this.)  Of course there may be other null characters in \
the string and one should use the output length parameter to determine the \
string length."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLTransferExpression()",
    FontFamily->"Courier"],
  " now properly handles raw data, uses less stack space and doesn't convert \
strings unless required."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Calls to ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLDeinitialize()",
    FontFamily->"Courier"],
  " can now be nested.  Only the outer ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  "/",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  " pair actually has any effect, and every call to ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  " will return the same value.  This has the potential to break incorrect \
programs that call ",
  StyleBox["MLInitialize",
    FontFamily->"Courier"],
  " multiple times but only call ",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  " once.  Such programs will no longer be deinitializing the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " environment when they call ",
  StyleBox["MLDeinitialize",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MLTransferToEndOfLoopbackLink()",
    FontFamily->"Courier"],
  " now allows ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  " as the destination link."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A bug caused ",
  StyleBox["MLNewPacket()",
    FontFamily->"Courier"],
  " to fail after an overflow error (",
  StyleBox["MLEOVFL",
    FontFamily->"Courier"],
  ") was cleared by ",
  StyleBox["MLClearError()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Classic 680x0 Macintosh programs no longer need the \
\[OpenCurlyDoubleQuote] CFM Runtime Enabler\[CloseCurlyDoubleQuote] installed \
in the \[OpenCurlyDoubleQuote]Extensions\[CloseCurlyDoubleQuote] folder in \
order to use the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library.  However, they can take advantage of it if it is \
installed."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Two new stub files were added in the \
\[OpenCurlyDoubleQuote]Compiler Additions\[CloseCurlyDoubleQuote] folder.  \
See the section in the Macintosh Developer Guide entitled \
\[OpenCurlyDoubleQuote]Versioning with \
MathLink\[CloseCurlyDoubleQuote].\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "On Windows platforms, the message handling and yielding facilities within \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now work more effectively with threaded programs and programs that have \
no user interface (i.e., programs that don't dispatch user events)."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLName()",
    FontFamily->"Courier"],
  " now properly deals with filenames containing spaces on Windows 95 and \
Windows NT."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function ",
  StyleBox["MLConfirm",
    FontFamily->"Courier"],
  "() now works properly on Windows."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " device changes"
}], "Subsubsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["\<\
Server programs that need to open several links using the same link \
name are now supported by some link protocols.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The mechanism for finding and loading low-level ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices was generalized for MacOS platforms."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
When the user canceled the browser dialog box of the \
\[OpenCurlyDoubleQuote]PPC\[CloseCurlyDoubleQuote] link protocol, the \
Macintosh FrontEnd would give a misleading message.  This has been \
fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Some missing numeric conversions were added that may be needed by \
classic 68K applications running on a PowerPC computer.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Specifying an internet host using a domain name rather than an IP \
address on PowerPC-based computers did not work.  This has been fixed.\
\>", \
"BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A bug was discovered in JavaSoft's Java Runner v1.0.2 for Macintosh when \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " was used in multiple threads of a Java application.  ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now works around this bug."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["The FileMap link protocol on Windows is now faster.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The algorithm used by the Windows FileMap protocol for generating a \
link name when none is provided has changed.  The old algorithm was based on \
the system clock.  The new algorithm uses random numbers.\
\>", "BulletedList",\

  CellTags->"UnixIntroduction"],

Cell["\<\
The Windows FileMap protocol could only open one link object per \
second.  This has been fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The Windows FileMap protocol now supports link names of up to 31 \
characters.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Specifying an internet host using an IP address on Intel-based \
computers (Windows and Unix) required that the 4 octets of the address be \
given in reverse order.  This has been fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The 16-bit Windows \[OpenCurlyDoubleQuote]Local\
\[CloseCurlyDoubleQuote] protocol now detects a request to use a link name \
that is already in use.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The Windows FileMap protocol had a bug that could cause ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " communication to be slower if a program called ",
  StyleBox["MLEnd()",
    FontFamily->"Courier"],
  " while a second link was still open.  This has been fixed."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Unix",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The mechanism for finding and loading low-level ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " devices was generalized for Unix platforms."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Specifying an internet host using an IP address on Intel-based \
computers (Windows and Unix) required that the 4 octets of the address be \
given in reverse order.  This has been fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The \[OpenCurlyDoubleQuote]TCP\[CloseCurlyDoubleQuote] protocol is \
now compatible with versions of Linux using libc.6 and libc.5.\
\>", \
"BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Changes to \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]", \
"Subsubsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The value of ",
  StyleBox["MLREVISION",
    FontFamily->"Courier"],
  " in \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] was changed \
from 5 to 6."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
All functions in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] are now properly declared for use from C++.\
\>", \
"BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "To enable Windows ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " to communicate more efficiently with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " on other platforms, some internal changes were made that required some \
constants to change in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The macros ",
  StyleBox["MLTK_MLSHORT, MLTK_MLINT, MLTK_MLLONG, MLTK_MLFLOAT, \
MLTK_MLDOUBLE, ",
    FontFamily->"Courier"],
  "and",
  StyleBox[" MLTK_MLLONGDOUBLE ",
    FontFamily->"Courier"],
  "were added as an indication of what representation the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library assumes for these C arithmetic types.  The macros ",
  StyleBox["MLTK_CSHORT",
    FontFamily->"Courier"],
  ", etc., are defined using heuristics that attempt to determine the \
representation that your compiler uses for these C arithmetic types when \
compiling code that includes \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "All declarations using the ",
  StyleBox["long double",
    FontFamily->"Courier"],
  " type are now protected by the ",
  StyleBox["CC_SUPPORTS_LONG_DOUBLE",
    FontFamily->"Courier"],
  " macro."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] \
was cleaned up a little.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] changes", \
"Subsubsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] now generates the \
following macro for the benefit of code that may rely on a particular \
revision of \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote].\n\t",
  StyleBox["#define MPREP_REVISION 6",
    FontFamily->"Courier"]
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The argument to the ",
  StyleBox[":Evaluate:",
    FontFamily->"Courier"],
  " keyword is now put on ",
  StyleBox["stdlink",
    FontFamily->"Courier"],
  " using ",
  StyleBox["MLPutByteString()",
    FontFamily->"Courier"],
  " rather than ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " as this is more convenient in this context.  So, for example\n",
  StyleBox[":Evaluate: x=\"a\\nb\"",
    FontFamily->"Courier"],
  "\nwill cause ",
  StyleBox["MLPutByteString()",
    FontFamily->"Courier"],
  " to be called with a string of 8 characters (represented by 8 bytes) to be \
sent to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for parsing and evaluation.  Whereas, with",
  StyleBox[" MLPutString(),",
    FontFamily->"Courier"],
  " the 8 bytes would represent 7 characters because ",
  StyleBox["\"\\n\"",
    FontFamily->"Courier"],
  " is interpreted as a single newline character by ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " .  This is likely not what you want as the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " parser interprets actual newline characters within strings as space \
characters.\n(Compare ",
  StyleBox["ToExpression[\"\\\"a\\nb\\\"\"]",
    FontFamily->"Courier"],
  " to ",
  StyleBox["ToExpression[\"\\\"a\\\\nb\\\"\"]",
    FontFamily->"Courier"],
  ".)"
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] can now generate ",
  StyleBox["#line",
    FontFamily->"Courier"],
  " directives so that compilers and debuggers can refer to the original \
source files.  This feature is controlled by the ",
  StyleBox["-line",
    FontFamily->"Courier"],
  " and ",
  StyleBox["-noline",
    FontFamily->"Courier"],
  " command-line options.  The default is ",
  StyleBox["-noline",
    FontFamily->"Courier"],
  " for the MacOS versions of \[OpenCurlyDoubleQuote]mprep\
\[CloseCurlyDoubleQuote] and ",
  StyleBox["-line",
    FontFamily->"Courier"],
  " for all other platforms."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The mprep-generated functions ",
  StyleBox["MLMainString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLMainArgv()",
    FontFamily->"Courier"],
  " are now correctly defined when",
  StyleBox[" MLPROTOTYPES == 0",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] no longer \
generates very long string literals.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox[":ReturnType: String",
    FontFamily->"Courier"],
  " functions can now return ",
  StyleBox["0",
    FontFamily->"Courier"],
  " to indicate failure."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Windows \
generates programs that use a custom icon in the task bar.\
\>", \
"BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Macintosh \
generates modern names for system calls.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]Mprep\[CloseCurlyDoubleQuote] for Macintosh \
generates apps with a bigger default heap.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The applications generated by the MacOS versions of \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] now display the correct \
copyright notice.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Recording \[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] \
AppleScripts now results in correct scripts.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] had a bug \
that could cause it to crash if it was run twice without quitting.  This was \
fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Miscellaneous", "Subsubsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["Various edits were made to this document.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Some sample code in the section below entitled \
\[OpenCurlyDoubleQuote]The Biggest Compatibility \
Issue\[CloseCurlyDoubleQuote] had a bug that could prevent it from working.  \
This was fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["\<\
The installation instructions for CodeWarrior users have changed.\
\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The AppleScripts used to create project files were modified for the \
latest Metrowerks tools.  The utility source file \
\[OpenCurlyDoubleQuote]mlmactty.c\[CloseCurlyDoubleQuote] was modified to be \
compatible with Apple's latest SIOW library.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The files \[OpenCurlyDoubleQuote]mlimport.rsrc\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] used by classic 68K \
applications were modified to conform to the new semantics for",
  StyleBox[" MLNewParameters()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic 68K applications works around a code generation bug in some \
versions of Metrowerks' C compiler.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic 68K applications now use modern names for MacOS system calls.\
\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] used by \
classic 68K applications was fixed so that ",
  StyleBox["#define LAZY 1",
    FontFamily->"Courier"],
  " now works."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Java programmers can now easily use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Windows",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " once again supports 16-bit Windows programs."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs linked with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " for Windows Version 3 can now interoperate with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs built with ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "  for Windows Version 2.2.  (Only the Windows platform had this temporary \
gap in interoperability.)"
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " can now work around a bug in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 2.2 that prevented compatibility with Windows 95 and Windows NT."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["CodeWarrior support for Windows was added.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Microsoft Visual C++ V5.0 and V6.0 support for Windows was added.\
\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Java programmers can now easily use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Unix",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "There was a bug in Version 3.0.0 of the Unix kernels that caused it to \
unnecessarily sleep when using ",
  StyleBox["MathLink.",
    FontSlant->"Italic"],
  " This was fixed in Version 3.0.1 kernels.  This bug caused very poor ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " performance."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernels Version 4.0 and later have several optimizations that make \
LinkRead significantly faster."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A resource leak in Version 3.0 of the kernel when it was reading from ",
  StyleBox["MathLink ",
    FontSlant->"Italic"],
  "was fixed."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Several other bugs, resource leaks and performance problems were \
fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " now is available on the UltraSPARC platform."
}], "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Revision 1 (also known as Beta 4)", "Subsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["\<\
The value of MLREVISION in \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] was changed from 1 to 5.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["This document was renamed again.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Some floating point rounding problems were fixed.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The output of \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] was \
modified to suppress some compiler warnings and to more flexibly handle ",
  StyleBox[":ByteString:",
    FontFamily->"Courier"],
  " and ",
  StyleBox[":ByteSymbol:",
    FontFamily->"Courier"],
  " argument types."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Some example files were changed to be consistent with other \
platforms.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A bug was fixed that caused ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " to hang in some circumstances."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Some internal limits on the parameters passed to ",
  StyleBox["MLOpenArgv",
    FontFamily->"Courier"],
  " were removed."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The functions ",
  StyleBox["MLNextCharacter",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLCharacterOffset",
    FontFamily->"Courier"],
  " were generalized to allow a ",
  StyleBox["NULL",
    FontFamily->"Courier"],
  " value for the end parameter."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A bug was fixed that was encountered when putting zero-length strings with \
the obsolete functions ",
  StyleBox["MLPutSize",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutData",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Another bug was fixed that was encountered when ",
  StyleBox["MLGetString",
    FontFamily->"Courier"],
  " was called when a function was next on the link."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["\<\
Some exceptions caught by the QC programmer's debugging utility \
were fixed.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Beta 3", "Subsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell["This document was renamed.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "A discussion of the ",
  StyleBox["long double",
    FontFamily->"Courier"],
  " type was added to the ",
  ButtonBox["Known Problems",
    ButtonData:>"Known Problems",
    ButtonStyle->"Hyperlink"],
  " section."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] now properly handle ",
  StyleBox[":ArgumentTypes: {ByteString}",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The header file \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] was cleaned up a little.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "More functions have arguments declared using the ",
  StyleBox["const",
    FontFamily->"Courier"],
  " type qualifier."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The argument to ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " was made opaque."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  StyleBox["MLPutIntegerList()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutRealList()",
    FontFamily->"Courier"],
  " now work."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Calling ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " when a function is next on the link now correctly fails with error ",
  StyleBox["MLEGSEQ",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Various other bugs were fixed.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Various edits were made to this document.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Some unsupported goodies were added.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "All callback functions are now declared \[OpenCurlyQuote]",
  StyleBox["pascal",
    FontFamily->"Courier"],
  "\[CloseCurlyQuote].  See the ",
  ButtonBox["Porting Version 2.2 ",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Porting",
    ButtonStyle->"Hyperlink"],
  " section."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] \
used by classic-68k applications now does version checking.\
\>", \
"BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changes since Beta 2", "Subsubsection",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["All Platforms",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The function pointers passed to the undocumented functions ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLSetUserData()",
    FontFamily->"Courier"],
  " were changed to ",
  StyleBox["UniversalProcPtrs ",
    FontFamily->"Courier"],
  "wrapping ",
  StyleBox["pascal",
    FontFamily->"Courier"],
  " functions.  Moreover, the prototypes for the functions registered with ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  " have changed.  The \[OpenCurlyDoubleQuote]Old Definition\
\[CloseCurlyDoubleQuote] version number of the \
\[OpenCurlyDoubleQuote]MathLinkLibraries\[CloseCurlyDoubleQuote] file was not \
incremented for Beta 3, however, so that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end and kernel would still bind to this new library.  Neither the \
front end nor the kernel call these ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " functions and are thus unaffected by the change.  If you call these \
functions in your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program, your program cannot be simultaneously compatible with the Beta 3 \
and Beta 2 or Beta 1 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries.  Be careful that your application is using the shared library \
that matches your use of these functions.  When the next ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Beta becomes available, the \[OpenCurlyDoubleQuote]Old Definition\
\[CloseCurlyDoubleQuote] version number of the \
\[OpenCurlyDoubleQuote]MathLinkLibraries\[CloseCurlyDoubleQuote] file will be \
changed so that applications linked with the Beta 1 or Beta 2 library will no \
longer bind with any newer ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " shared library."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["Minor edits were made to this document.", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "Minor edits were made to some ",
  StyleBox["typedef",
    FontFamily->"Courier"],
  " declarations in \
\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell[TextData[StyleBox["Macintosh",
  FontSize->10,
  FontVariations->{"Underline"->True}]], "Text",
  CellTags->"UnixIntroduction"],

Cell[TextData[{
  "The file \[OpenCurlyDoubleQuote]mlimport.c\[CloseCurlyDoubleQuote] now \
works for classic 68K projects that use two bytes to represent variable of \
type ",
  StyleBox["int",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Minor edits were made to the AppleScripts that create project \
documents.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"],

Cell["\<\
Minor changes were made to the code generated by \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]SAmprep\[CloseCurlyDoubleQuote] to make projects that \
use precompiled headers build faster and to fix some incorrect \
declarations.\
\>", "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Installing the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Components"
}], "Section",
  CellTags->"UnixInstalling"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kit is located in the directory \
\"AddOns/MathLink/DeveloperKit/",
  "UNIX",
  "\" within your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory."
}], "Text",
  CellTags->"UnixInstalling"],

Cell[CellGroupData[{

Cell["Recommended Installation", "Subsection",
  CellTags->"UnixInstalling"],

Cell["CompilerAdditions Installation", "Text",
  FontVariations->{"Underline"->True},
  CellTags->"UnixInstalling"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " components that you will need to build ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs have already been installed by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " installer.  One way to use these components is to leave them in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory and specify their full path name when you call your compiler.  \
This approach is taken in the example makefiles in the section \
\[OpenCurlyDoubleQuote]Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->"UnixInstalling"],

Cell[TextData[{
  "An alternative is to copy these components \
(\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]libML.a\[CloseCurlyDoubleQuote]) into directories in \
which your compiler will automatically search for such files.  These \
directories are commonly ",
  StyleBox["/usr/include",
    FontFamily->"Courier"],
  " and ",
  StyleBox["/usr/lib",
    FontFamily->"Courier"],
  ", but may be different on your system.  On many systems not all users have \
write access to these directories."
}], "Text",
  CellTags->"UnixInstalling"],

Cell["MathLinkExamples Installation", "Text",
  FontVariations->{"Underline"->True},
  CellTags->"UnixInstalling"],

Cell["\<\
Copy the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory to your home directory.\
\>", "Text",
  CellTags->"UnixInstalling"]
}, Closed]],

Cell[CellGroupData[{

Cell["Parts List", "Subsection",
  CellTags->{"parts", "UnixInstalling"}],

Cell[TextData[{
  "The following is a description of each file or directory in the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kit (MLDK)."
}], "Text",
  CellTags->{"parts", "UnixInstalling"}],

Cell[CellGroupData[{

Cell["\[OpenCurlyDoubleQuote]CompilerAdditions\[CloseCurlyDoubleQuote] \
Directory", "Subsubsection",
  CellTags->{"parts", "UnixInstalling"}],

Cell["mathlink.h", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "mathlink.h", "UnixInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] is the header \
file that must be included in your C and C++ source files.  It should be \
placed where your compiler can find it.  You could copy this header file into \
the same directory as your source files that include it, or in the same \
location as the standard header files, or leave it where it is if you added \
the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " directory to the search path for header files."
}], "Text",
  CellTags->{"parts", "mathlink.h", "UnixInstalling"}],

Cell["libML.a", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],

Cell[TextData[{
  "This is the static library that contains all of the ",
  StyleBox["MathLink ",
    FontSlant->"Italic"],
  "functions.  It should be included in your project.  You could copy this \
library into the same directory as your source files, or leave it where it is \
if you added the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " directory to the search path for libraries."
}], "Text",
  CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],

Cell["mprep", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "mprep", "UnixInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] is an application \
that writes ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs automatically by processing \[OpenCurlyDoubleQuote]template\
\[CloseCurlyDoubleQuote] files.  It may be convenient to copy this \
application into the same directory as your project or to create an alias to \
it."
}], "Text",
  CellTags->{"parts", "mprep", "UnixInstalling"}],

Cell["mcc", "Text",
  FontVariations->{"Underline"->True},
  CellTags->{"parts", "mcc", "UnixInstalling"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] is a script that \
preprocesses and compiles your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " source files."
}], "Text",
  CellTags->{"parts", "mcc", "UnixInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] \
Directory", "Subsubsection",
  CellTags->{"parts", "UnixInstalling"}],

Cell[TextData[{
  "This directory contains the source code for some very simple ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  By using this source code, you can learn how to build and run \
",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs without having to write any code yourself."
}], "Text",
  CellTags->{"parts", "UnixInstalling"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\[OpenCurlyDoubleQuote]PrebuiltExamples\[CloseCurlyDoubleQuote] \
Folder", "Subsubsection",
  CellTags->{"parts", "prebuilt", "UnixInstalling"}],

Cell[TextData[{
  "This folder contains prebuilt versions of the example programs.  The \
section ",
  ButtonBox["Running ",
    ButtonData:>"Running",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Running",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Running",
    ButtonStyle->"Hyperlink"],
  " describes how to run two of these programs.  The section ",
  ButtonBox["Building ",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["MathLink",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Programs",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
  " describes how to build them yourself using the source code in the \
\[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] folder."
}], "Text",
  CellTags->{"parts", "prebuilt", "UnixInstalling"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"UnixBuilding"],

Cell[TextData[{
  "The general procedure for building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs is to include \[OpenCurlyDoubleQuote]mathlink.h\
\[CloseCurlyDoubleQuote] in any C or C++ source files that make ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " function calls, to compile your source files, and then to link the \
resulting object code with the \[OpenCurlyDoubleQuote]libML.a\
\[CloseCurlyDoubleQuote] library and any other standard libraries required by \
your application.  If your application uses the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template mechanism, then your template files must first be processed into \
a C source file using \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->"UnixBuilding"],

Cell[CellGroupData[{

Cell["Using \[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"mprep", "UnixBuilding"}],

Cell[TextData[{
  "If your program uses the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template mechanism as described in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ", you must simultaneously preprocess your source files that contain \
template entries using the \[OpenCurlyDoubleQuote]mprep\
\[CloseCurlyDoubleQuote] application.  (A template entry is a sequence of \
lines that contain template keywords.  Each entry defines a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that when evaluated calls an associated C function.)  When \
\[OpenCurlyDoubleQuote]mprep\[CloseCurlyDoubleQuote] processes such source \
files, it converts template entries into C functions, passes other text \
through unmodified, and writes out additional C functions that implement a \
remote procedure call mechanism using ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ".  The result is a C source file that is ready for compilation."
}], "Text",
  CellTags->{"mprep", "UnixBuilding"}],

Cell["For example, the command", "Text",
  CellTags->{"mprep", "UnixBuilding"}],

Cell[TextData[StyleBox["mprep  addtwo.tm  -o addtwotm.c", "MR"]], "FramedBox",
  CellTags->{"mprep", "UnixBuilding"}],

Cell["\<\
will produce a C source file \[OpenCurlyDoubleQuote]addtwotm.c\
\[CloseCurlyDoubleQuote] from the template entries and other text in \
\[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote].  You would then \
compile the output file using the C compiler.  If you use the \
\[OpenCurlyDoubleQuote]Make\[CloseCurlyDoubleQuote] utility to build your \
program, you could add a rule similar to the following one to your \
makefile.\
\>", "Text",
  CellTags->{"mprep", "UnixBuilding"}],

Cell[TextData[StyleBox["addtwotm.c  :  addtwo.tm\n    mprep  addtwo.tm  -o \
addtwotm.c", "MR"]], "FramedBox",
  CellTags->{"mprep", "UnixBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs"
}], "Subsection",
  CellTags->"UnixBuilding"],

Cell[TextData[{
  "What follows is a sample makefile needed to build the sample programs in \
the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Developer's Kit, including \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote].  To build a sample program, in this case \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote], evaluate the following \
command in the MathLinkExamples directory."
}], "Text",
  CellTags->"UnixBuilding"],

Cell[TextData[StyleBox["make addtwo", "MR"]], "FramedBox",
  CellTags->"UnixBuilding"],

Cell[CellGroupData[{

Cell["Makefile", "Subsubsection",
  CellTags->"UnixBuilding"],

Cell[TextData[StyleBox["# This makefile can be used to build all or some of \
the sample\n# programs.  To build all of them, use the command\n# 'make all'. \
 To build one, say addtwo, use the command\n# 'make addtwo'.\n\nMLINKDIR = \
/usr/local/mathematica/AddOns/MathLink/DeveloperKit\nSYS = UNIX\nCADDSDIR = \
${MLINKDIR}/${SYS}/CompilerAdditions\n\nINCDIR = ${CADDSDIR}\nLIBDIR = \
${CADDSDIR}\n\nMPREP = ${CADDSDIR}/mprep\n\nall : addtwo bitops counter \
factor factor2 factor3 quotient reverse sumalist\n\naddtwo : addtwotm.o \
addtwo.o\n\t${CC} -I${INCDIR} addtwotm.o addtwo.o -L${LIBDIR} -lML -lm -o $@\n\
\nbitops : bitopstm.o bitops.o\n\t${CC} -I${INCDIR} bitopstm.o bitops.o \
-L${LIBDIR} -lML -lm -o $@\n\ncounter : countertm.o\n\t${CC} -I${INCDIR} \
countertm.o -L${LIBDIR} -lML -lm -o $@\n\nfactor : factor.o\n\t${CC} \
-I${INCDIR} factor.o -L${LIBDIR} -lML -lm -o $@\n\nfactor2 : factor2.o\n\t\
${CC} -I${INCDIR} factor2.o -L${LIBDIR} -lML -lm -o $@\n\nfactor3 : factor3.o\
\n\t${CC} -I${INCDIR} factor3.o -L${LIBDIR} -lML -lm -o $@\n\nquotient : \
quotient.o\n\t${CC} -I${INCDIR} quotient.o -L${LIBDIR} -lML -lm -o $@\n\n\
reverse : reversetm.o\n\t${CC} -I${INCDIR} reversetm.o -L${LIBDIR} -lML -lm \
-o $@\n\nsumalist : sumalisttm.o sumalist.o\n\t${CC} -I${INCDIR} sumalisttm.o \
sumalist.o -L${LIBDIR} -lML -lm -o $@\n\n.c.o :\n\t${CC} -c -I${INCDIR} $<\n\n\
addtwotm.c : addtwo.tm\n\t${MPREP} $? -o $@\n\nbitopstm.c : bitops.tm\n\t\
${MPREP} $? -o $@\n\ncountertm.c : counter.tm\n\t${MPREP} $? -o $@\n\n\
reversetm.c : reverse.tm\n\t${MPREP} $? -o $@\n\nsumalisttm.c : sumalist.tm\n\
\t${MPREP} $? -o $@", "MR"]], "FramedBox",
  CellTags->"UnixBuilding"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote]", "Subsection",
  CellTags->{"mcc", "UnixBuilding"}],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] is a script that \
preprocesses and compiles your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " source files.  It will preprocess ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " templates in any file whose name ends with .tm, and then call \
\[OpenCurlyDoubleQuote]cc\[CloseCurlyDoubleQuote] on the resulting C source \
code.  \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] will pass \
command-line options and other files directly to cc.  Following is a command \
that would build the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] \
application using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"mcc", "UnixBuilding"}],

Cell[TextData[StyleBox["mcc addtwo.tm addtwo.c -o addtwo", "MR"]], "FramedBox",
  CellTags->{"mcc", "UnixBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Building ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using a pre-ANSI C compiler"
}], "Subsection",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[TextData[{
  "If you are using a pre-ANSI C compiler, you will have to modify the way \
you build ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  To build an application using a C compiler that does not \
support prototypes, set the macro ",
  StyleBox["MLPROTOTYPES",
    FontFamily->"Courier"],
  " to 0 in your code.  One way to do this is to include the following line \
in your code (before the line ",
  StyleBox["#include \"mathlink.h\"",
    FontFamily->"Courier"],
  ")"
}], "Text",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[TextData[StyleBox["#define MLPROTOTYPES 0", "MR"]], "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[TextData[{
  "If you are building a template-based program, the above step won't work \
since mprep will not add this line to the C files it generates.  In this \
case, you can pass the flag ",
  StyleBox["-DMLPROTOTYPES=0",
    FontFamily->"Courier"],
  " to your C compiler.  Following are two ways to do that: one with a \
makefile, the other using \
\[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[CellGroupData[{

Cell["Makefile", "Subsubsection",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[TextData[StyleBox["# This makefile can be used to build all or some of \
the sample\n# programs.  To build all of them, use the command\n# 'make all'. \
 To build one, say addtwo, use the command\n# 'make addtwo'.\n\nMLINKDIR = \
/usr/local/mathematica/AddOns/MathLink/DeveloperKit\nSYS = UNIX\nCADDSDIR = \
${MLINKDIR}/${SYS}/CompilerAdditions\n\nINCDIR = ${CADDSDIR}\nLIBDIR = \
${CADDSDIR}\n\nMPREP = ${CADDSDIR}/mprep\n\nall : addtwo bitops counter \
factor factor2 factor3 quotient reverse sumalist\n\naddtwo : addtwotm.o \
addtwo.o\n\t${CC} -I${INCDIR} addtwotm.o addtwo.o -L${LIBDIR} -lML -lm -o $@\n\
\nbitops : bitopstm.o bitops.o\n\t${CC} -I${INCDIR} bitopstm.o bitops.o \
-L${LIBDIR} -lML -lm -o $@\n\ncounter : countertm.o\n\t${CC} -I${INCDIR} \
countertm.o -L${LIBDIR} -lML -lm -o $@\n\nfactor : factor.o\n\t${CC} \
-I${INCDIR} factor.o -L${LIBDIR} -lML -lm -o $@\n\nfactor2 : factor2.o\n\t\
${CC} -I${INCDIR} factor2.o -L${LIBDIR} -lML -lm -o $@\n\nfactor3 : factor3.o\
\n\t${CC} -I${INCDIR} factor3.o -L${LIBDIR} -lML -lm -o $@\n\nquotient : \
quotient.o\n\t${CC} -I${INCDIR} quotient.o -L${LIBDIR} -lML -lm -o $@\n\n\
reverse : reversetm.o\n\t${CC} -I${INCDIR} reversetm.o -L${LIBDIR} -lML -lm \
-o $@\n\nsumalist : sumalisttm.o sumalist.o\n\t${CC} -I${INCDIR} sumalisttm.o \
sumalist.o -L${LIBDIR} -lML -lm -o $@\n\n.c.o :\n\t${CC} -DMLPROTOTYPES=0 -c \
-I${INCDIR} $<\n\naddtwotm.c : addtwo.tm\n\t${MPREP} $? -o $@\n\nbitopstm.c : \
bitops.tm\n\t${MPREP} $? -o $@\n\ncountertm.c : counter.tm\n\t${MPREP} $? -o \
$@\n\nreversetm.c : reverse.tm\n\t${MPREP} $? -o $@\n\nsumalisttm.c : \
sumalist.tm\n\t${MPREP} $? -o $@", "MR"]], "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote] to build \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote]", "Subsubsection",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell["\<\
Following is a command that would build \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] with a pre-ANSI \
compiler using \[OpenCurlyDoubleQuote]mcc\[CloseCurlyDoubleQuote].\
\>", \
"Text",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[TextData[StyleBox["mcc -DMLPROTOTYPES=0 addtwo.tm addtwo.c -o addtwo", \
"MR"]], "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell["\<\
Don't forget to modify the sample C files so they don't use \
prototypes.  For example, following is a modified version of addtwo.c.\
\>", \
"Text",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[TextData[StyleBox["#include \"mathlink.h\"\n\nint addtwo(i,j) int i, j;\n\
{\n        return i + j;\n}\n\nint main(argc, argv) int argc; char *argv[];\n\
{\n        return MLMain(argc, argv);\n}", "MR"]], "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Running ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"UnixRunning"],

Cell[TextData[{
  "The instructions in the previous section describe how to build two ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs using source code in the \[OpenCurlyDoubleQuote]MathLinkExamples\
\[CloseCurlyDoubleQuote] directory.  This section shows how to run those \
programs."
}], "Text",
  CellTags->"UnixRunning"],

Cell[CellGroupData[{

Cell["Running \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[TextData[{
  "The first example program, \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote], is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template program that is installed into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  That is, this program runs in the background, providing, as a service \
to ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " one or more externally compiled functions.  To the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " user, these functions appear to be built-in.  The \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] program uses a template \
file that defines the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "function ",
  StyleBox["AddTwo[]",
    FontFamily->"Courier"],
  " as a call to the C function ",
  StyleBox["addtwo()",
    FontFamily->"Courier"],
  ".  (The template mechanism is described in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ".)  The source code for this program looks likes this:"
}], "Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[TextData[StyleBox[":Begin:\n:Function:       addtwo\n:Pattern:        \
AddTwo[i_Integer, j_Integer]\n:Arguments:      { i, j }\n:ArgumentTypes:  { \
Integer, Integer }\n:ReturnType:     Integer\n:End:\n\n:Evaluate: \
AddTwo::usage = \"AddTwo[x, y] gives the sum of two machine integers x and y.\
\"\n\nint addtwo( int i, int j)\n{\n\treturn i+j;\n}\n\nint main(int argc; \
char* argv[])\n{\n\treturn MLMain(argc, argv);\n}", "MR"]], "FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],

Cell["\<\
Edit the path string below and evaluate the following two cells \
\
\>", "Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(SetDirectory[\ "\<path to addtwo program\>"]\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(link\  = \ Install["\<./addtwo\>", \ LinkMode -> Launch]\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell["\<\
To see a list of the newly available functions, evaluate the \
following cell.\
\>", "Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(LinkPatterns[link]\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[TextData[{
  "This displays the usage message for the ",
  StyleBox["AddTwo",
    FontFamily->"Courier"],
  " function as defined in the file \[OpenCurlyDoubleQuote]addtwo.tm\
\[CloseCurlyDoubleQuote]."
}], "Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(\(?AddTwo\)\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell["Now try it.", "Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(AddTwo[2, \ 3]\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell["\<\
See what happens if the sum of the two machine integers won't fit \
in a machine integer or if either argument is not a machine integer:\
\>", \
"Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[2^31 - 1, \ 1]\)\(\ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[TextData[StyleBox["(* 2^31-1 is the largest machine integer.\n   If your \
compiler uses 2-byte ints, then 2^15-1 is the largest C int. *)", "MR"]], \
"FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[2^31, \ 1]\)\(\ \ \ \ \ \ \ \ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[TextData[StyleBox["(* The addtwo program is not prepared for big \
integers. *)", "MR"]], "FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(\(\(AddTwo[x, \ 
      1]\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[TextData[StyleBox["(* This doesn't match AddTwo[_Integer, _Integer]. \
*)", "MR"]], "FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[TextData[{
  StyleBox["Install[]",
    FontFamily->"Courier"],
  " called ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  " and then exchanged information with the external program to set up the \
definition for ",
  StyleBox["AddTwo[]",
    FontFamily->"Courier"],
  ".  You really don't have to worry about these details, but if you are \
curious, evaluate:"
}], "Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(?? AddTwo\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}],

Cell["When you are finished using the external program, evaluate:", "Text",
  CellTags->{"addtwo", "UnixRunning"}],

Cell[BoxData[
    \(Uninstall[link]\)], "Input",
  CellTags->{"addtwo", "UnixRunning"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Running \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote]", \
"Subsection",
  CellTags->{"factor", "UnixRunning"}],

Cell[TextData[{
  "The second example program, \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote], is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end in the sense that the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel runs in the background providing, as a service to \
\[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote], the computational \
services of the kernel\[LongDash]in this case the ability to factor an \
integer typed by the user."
}], "Text",
  CellTags->{"factor", "UnixRunning"}],

Cell["\<\
Launch the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
application by executing the following command:\
\>", "Text",
  CellTags->{"factor", "UnixRunning"}],

Cell[TextData[StyleBox["factor -linkmode launch -linkname 'math -mathlink'", \
"MR"]], "FramedBox",
  CellTags->{"factor", "UnixRunning"}],

Cell["\<\
After a moment, a prompt will appear requesting that you type an \
integer.  Type an integer with fewer than 10 digits and press the Return key. \
 (The other factor examples relax the restriction on the size of integer you \
may type in.)\
\>", "Text",
  CellTags->{"factor", "UnixRunning"}],

Cell[TextData[StyleBox["Integer to factor:", "MR"]], "FramedBox",
  CellTags->{"factor", "UnixRunning"}],

Cell[TextData[{
  "The prime factors returned by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are printed and \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
closes its link with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"factor", "UnixRunning"}],

Cell[TextData[StyleBox["Integer to factor: 123456789\n3 ^ 2\n3607 ^ 1\n3803 ^ \
1", "MR"]], "FramedBox",
  CellTags->{"factor", "UnixRunning"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Supported Link Protocols", "Subsection",
  CellTags->{"protocols", "UnixRunning"}],

Cell[TextData[{
  "The C function ",
  StyleBox["MLOpenArgv()",
    FontFamily->"Courier"],
  " and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  " are documented in ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ".  On Unix machines, the legal values for the LinkProtocol option are \
\"TCPIP\", \"TCP\", \"Pipes\", and \"Local\".  A LinkProtocol is the \
mechanism used to transport data from one end of a connection to the other.  \
The default is \"TCPIP\" for all LinkModes except LoopBack and Launch.  \
LinkMode Launch uses the \"Pipes\" LinkProtocol.  (The \
\[OpenCurlyDoubleQuote]Local\[CloseCurlyDoubleQuote] protocol is most useful \
in C programs for storing expressions or for inter-thread communication.)"
}], "Text",
  CellTags->{"protocols", "UnixRunning"}],

Cell[TextData[{
  "Note that link names are unsigned 16-bit integers for the \"TCPIP\"  and \
\"TCP\" protocols.  Even though \"TCPIP\" link names are integers, they are \
still given as strings (of digits) to ",
  StyleBox["MLOpenArgv()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["LinkOpen[]",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"protocols", "UnixRunning"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Porting Version 2.2 ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " Programs"
}], "Section",
  CellTags->"UnixPorting"],

Cell[CellGroupData[{

Cell[TextData[{
  "Changes to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " API since Version 2.2 (Interface 0)"
}], "Subsection",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "Several changes have been made to the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " application programming interface (API).  To the extent possible, the new \
interface is compatible with the old.  If you intend to use existing code \
written to the old interface, with a new ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library, then you ",
  StyleBox["must",
    FontSlant->"Italic"],
  " read the following."
}], "Text",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "The new ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library is both source code compatible and \[OpenCurlyDoubleQuote]runtime\
\[CloseCurlyDoubleQuote] compatible with older libraries.  (Source code \
compatible means that \
\[OpenCurlyDoubleQuote]correctly\[CloseCurlyDoubleQuote] written ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs are still correct when recompiled and linked with the new \
library.  Runtime compatible means that programs linked with the new library \
are able to connect to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs linked with any previous ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library.  Note that the new libraries are not \[OpenCurlyDoubleQuote]link\
\[CloseCurlyDoubleQuote] compatible with old ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " libraries.  That is, if you want to relink your program you must also \
recompile it.  For this reason, shared library implementations of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " have had their version information changed.)"
}], "Text",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "The problem is that many working programs may not be strictly correct and \
will not continue to work, if unmodified.  You can choose to leave these \
programs as they are\[LongDash]linked with an older ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library\[LongDash]or edit, recompile and relink them.  The reason a \
number of such programs may exist is because the old interface was not \
carefully described."
}], "Text",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "You can, after considering the following points, choose to make your ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs correct by properly using the old API.  Or you may want to just \
use some features of the new API that are more convenient and more \
efficient."
}], "Text",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "The following is a discussion of the issue most likely to need your \
attention in porting existing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs.  Read this and then the list of points to consider."
}], "Text",
  CellTags->{"changes", "UnixPorting"}],

Cell[CellGroupData[{

Cell["The Biggest Compatibility Issue", "Subsubsection",
  CellTags->{"changes", "strings", "UnixPorting"}],

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " strings and symbols can contain characters with codes ranging from 0 to \
65535\[LongDash]that is, characters that can be represented by unsigned \
16-bit integers.  Previously, the arguments to the string and symbol \
functions in ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " were not represented with  arrays of unsigned 16-bit integers, but rather \
with sequences of 8-bit bytes.  How ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " encoded 16-bit characters as a sequence of bytes was private.  Hence, to \
construct or interpret the arguments to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " string and symbol functions as a sequence of characters required some \
preprocessing before calling, say, ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " or some postprocessing after calling, say, ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"changes", "strings", "UnixPorting"}],

Cell[TextData[{
  "If this additional processing was not done when putting and getting \
strings and symbols, the program was likely not correct even if it appeared \
to work.  It worked if the strings and symbols used in the program happened \
to be represented in the same way as ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " represented them in the private encoding.  In Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", this private encoding has changed in such a way that it is far more \
likely to cause incorrect programs to fail.  (In previous versions of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", characters with codes from 1 to 247 were represented literally by a \
single byte with that value, and a byte with value zero was not used in the \
encoding of any character.  In Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", only 94 characters are represented literally when using the same \
function calls."
}], "Text",
  CellTags->{"changes", "strings", "UnixPorting"}],

Cell[TextData[{
  "The following code shows a correct way to extract and interpret the \
individual characters encoded in the byte sequence returned by ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  ".  This source code will work with Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " as well as previous versions."
}], "Text",
  CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],

Cell[TextData[StyleBox["void get_characters( MLINK link)\n{\n\t\
MLStringPosition pos;\n\tunsigned short char_code;\n\tchar* s;\n\n\tif( \
MLGetString( link, &s)){\n\t\tMLforString( s, pos){\n\t\t\tchar_code = \
MLStringChar( pos);\n\t\t\tuse_the_character_code( char_code);\n\t\t}\n\t\t\
MLDisownString( link, s);\n\t}\n}", "MR"]], "FramedBox",
  CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],

Cell[TextData[{
  "Now with Version 3 of ",
  StyleBox["MathLink ",
    FontSlant->"Italic"],
  "(Interface 1 or later), you can extract characters from a byte sequence \
that is not necessarily terminated with a zero byte.  The new function ",
  StyleBox["MLNextCharacter()",
    FontFamily->"Courier"],
  " takes a pointer to the end of the byte sequence (and that pointer need \
not point to a zero byte).  This function returns a negative number when it \
gets to the end.  The source code below does the same thing as the source \
code in the preceding paragraph."
}], "Text",
  CellTags->{"MLNextCharacter", "changes", "strings", "UnixPorting"}],

Cell[TextData[StyleBox["#if MLVERSION < 3\n#error MLNextCharacter is not \
available before Version 3.\n#endif\n\nvoid get_characters( MLINK link)\n{\n\t\
long char_code;\n\tchar* s;\n\n\tif( MLGetString( link, &s)){\n\t\tchar* p = \
s;\n\t\tchar* end = s + strlen(s);\n\t\twhile( (char_code = MLNextCharacter( \
&p, end)) >= 0){\n\t\t\tuse_the_character_code( char_code);\n\t\t}\n\t\t\
MLDisownString( link, s);\n\t}\n}", "MR"]], "FramedBox",
  CellTags->{"changes", "strings", "MLNextCharacter", "UnixPorting"}],

Cell[TextData[{
  "To construct a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " string from a sequence of character codes, you would call ",
  StyleBox["MLPutCharToString()",
    FontFamily->"Courier"],
  " in a loop.  The code below uses two loops, one to measure the size of the \
private ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " representation, and another to actually encode the characters of the \
string before calling ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"MLPutCharToString", "changes", "strings", "UnixPorting"}],

Cell[TextData[StyleBox["void put_characters( MLINK link, unsigned short \
char_codes[], long len)\n{\n\tlong i, size;\n\tchar* s;\n\n\tfor( i = 0, size \
= 0; i < len; ++i){\n\t\tsize += MLPutCharToString( char_codes[i], NULL);\n\t\
}\n\n\ts = (char*)malloc( size + 1);\n\n\tif( s){\n\t\tchar* p;\n\t\tfor( i = \
0, p = s; i < len; ++i){\n\t\t\tMLPutCharToString( char_codes[i], &p);\n\t\t}\
\n\t\t*p = '\\0';\n\t\tMLPutString( link, s);\n\t\tfree(s);\n\t}\n}", "MR"]], \
"FramedBox",
  CellTags->{"changes", "strings", "MLPutCharToString", "UnixPorting"}],

Cell[TextData[{
  "Now with Version 3 of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", you can replace the two loops with two function calls.  The function ",
  StyleBox["MLConvertUnicodeString()",
    FontFamily->"Courier"],
  ", when passed a zero pointer as its last argument, returns in ",
  StyleBox["s",
    FontFamily->"Courier"],
  " the size required to encode the given characters.  When passed a non-zero \
pointer to the end of a buffer, ",
  StyleBox["MLConvertUnicodeString()",
    FontFamily->"Courier"],
  " actually encodes the characters.  The source code below does the same \
thing as the source code in the preceding paragraph."
}], "Text",
  CellTags->{"MLConvertUnicodeString", "changes", "strings", "UnixPorting"}],

Cell[TextData[StyleBox["#if MLVERSION < 3\n#error MLConvertUnicodeString is \
not available before Version 3.\n#endif\n\nvoid put_characters( MLINK link, \
unsigned short char_codes[], long len)\n{\n\tlong size;\n\tchar* s;\n\n\t\
MLConvertUnicodeString( char_codes, len, &s, 0);\n\tsize = s - (char*)0;\n\n\t\
s = (char*)malloc( size + 1) ;\n\n\tif( s){\n\t\tchar* p = s;\n\t\t\
MLConvertUnicodeString( char_codes, len, &p, p + size);\n\t\t*p = '\\0';\n\t\t\
MLPutString( link, s);\n\t\tfree(s);\n\t}\n}", "MR"]], "FramedBox",
  CellTags->{"changes", "strings", "MLConvertUnicodeString", "UnixPorting"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Points to Consider", "Subsubsection",
  CellTags->{"changes", "UnixPorting"}],

Cell["\<\
This list of considerations may change from one revision to the \
next.\
\>", "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "Some undocumented functions may have changed.  If  you have discovered and \
use any undocumented functions, you should check their declarations and \
behavior with any new release.   Functions are undocumented if they are \
experimental.  You, of course, are free to use them provided you understand \
that they may change in subsequent ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " releases.  An undocumented function may become documented in a future \
release, become documented in a modified form, become unnecessary, be \
provided in source code only, or on rare occasions be removed altogether.  \
The header file \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote], \
although sometimes enlightening, does not constitute documentation."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "If you care to make your source compatible with the old ",
  StyleBox["and",
    FontSlant->"Italic"],
  " new APIs and still take advantage of new features, note that the new \
header file defines the macro ",
  StyleBox["#define\[NonBreakingSpace]MLVERSION\[NonBreakingSpace]3",
    FontFamily->"Courier",
    FontSize->10],
  "  which you can test for:"
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[StyleBox["#if MLVERSION < 3\n\t...old cumbersome stuff if you \
want\n#else\n\t...new more convenient stuff\n#endif", "MR"]], "FramedBox",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "Some pointer declarations have had the ",
  StyleBox["const",
    FontFamily->"Courier"],
  " type qualifier added to indicate either that ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " does not modify your data or that you should not modify ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "'s data.  You may have to add the ",
  StyleBox["const",
    FontFamily->"Courier"],
  " type qualifier to some of your variable declarations."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "If you called ",
  StyleBox["MLGetArgCount()",
    FontFamily->"Courier"],
  " after calling ",
  StyleBox["MLGetFunction()",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLCheckFunction()",
    FontFamily->"Courier"],
  " or otherwise began to read the head of the composite expression, this is \
an error and will no longer work.  If you need the argument count of the \
current composite expression, then you must remember it from when it was \
first returned by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  "."
}], "BulletedList",
  CellTags->{"MLGetArgCount", "changes", "UnixPorting"}],

Cell[TextData[{
  "When getting the data of symbols, strings, or numbers, if you called ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " before calling ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  ", this is an error and will no longer work.  Simply add a call to ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  " before your first call to ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->{"MLGetData", "changes", "UnixPorting"}],

Cell[TextData[{
  "If you assume that ",
  StyleBox["MLGetData( link, buff, len, &got)",
    FontFamily->"Courier"],
  " will return ",
  StyleBox["got == len",
    FontFamily->"Courier"],
  " as long as ",
  StyleBox["len",
    FontFamily->"Courier"],
  " was no greater than indicated by ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  ", then this is an error.  ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " may choose to deliver fewer than len bytes if required to preserve \
character boundaries.  And note that it may take several bytes to encode some \
characters."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "Again note that the way that strings are represented by ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  ", ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " and related functions has changed.  Now, the only characters represented \
literally are the characters from ASCII 32 (space) to ASCII 126 (tilde) \
except ASCII 92 (backslash).  All other characters (0...31, 92, 127...65535) \
are represented by multibyte escape sequences.  Previous versions of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " represented more characters literally (codes 1...247)."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "So, for example, ",
  StyleBox["MLPutString( link, \"hello\")",
    FontFamily->"Courier"],
  " was and is OK.  But ",
  StyleBox["MLPutString( link, \"C:\\\\winmath\\\\\")",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLPutString( link, \"\\n\")",
    FontFamily->"Courier"],
  " will no longer work."
}], "IndentedText",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "If your string literals used only characters in the new more restricted \
range and if you always used the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " iterator functions ",
  StyleBox["MLPutCharToString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLStringChar()",
    FontFamily->"Courier"],
  " in a loop as described above to encode and decode other ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " strings, then your program was correct and still is.  If not, your \
program will have to be modified to work with the new library."
}], "IndentedText",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "You cannot assume that ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " represents a given string in a unique canonical way.  So, for example, \
you cannot:"
}], "BulletedList",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],

Cell[TextData[StyleBox["MLGetString( link, &s);\nif( strcmp( \"hello\", s) != \
0)\n\tdidnt_get_hello();  /* error! */", "MR"]], "FramedBox",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],

Cell[TextData[{
  "Instead you must extract the characters from ",
  StyleBox["s",
    FontFamily->"Courier"],
  " using the iterator and compare them one by one to the characters of ",
  StyleBox["\"hello\"",
    FontFamily->"Courier"],
  ".  There currently is no function in the library for doing this.  \
Alternatively, you could use one of the new string functions that represents \
",
  StyleBox["all",
    FontSlant->"Italic"],
  " characters literally.  For example, the following code is correct:"
}], "IndentedText",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],

Cell[TextData[StyleBox["MLGetByteString( link, &s, &len, '\\0');\nif( len != \
5 || strcmp( \"hello\", s) != 0)\n\tdidnt_get_hello();", "MR"]], "FramedBox",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],

Cell[TextData[{
  "If instead of calling ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " you called ",
  StyleBox["MLPutSize()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLBytesToGet()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  ", realize that the use of these functions is now strongly discouraged as \
there are improved means to do these things.  Further, their implementation \
is now rather inefficient as they exist only for backward compatibility.  \
Further still, everything mentioned above about ",
  StyleBox["MLGetString()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutString()",
    FontFamily->"Courier"],
  " regarding the representation of characters applies to ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  "."
}], "BulletedList",
  CellTags->{"MLBytesToGet", "changes", "UnixPorting"}],

Cell[TextData[{
  "All points in this section regarding strings apply equally to symbols.  \
Moreover, it is easy to forget that the second argument to ",
  StyleBox["MLPutFunction()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLCheckFunction()",
    FontFamily->"Courier"],
  " must also be properly encoded, although these are most often called with \
a string literal containing only characters within the restricted range."
}], "BulletedList",
  CellTags->{"MLPutFunction", "changes", "UnixPorting"}],

Cell[TextData[{
  "If you call ",
  StyleBox["MLInitialize()",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLBegin()",
    FontFamily->"Courier"],
  " with a non-zero argument, the structure of that argument has changed."
}], "BulletedList",
  CellTags->{"MLInitialize", "changes", "UnixPorting"}],

Cell[TextData[{
  "If you call the undocumented functions ",
  StyleBox["MLSetUserData()",
    FontFamily->"Courier"],
  " or ",
  StyleBox["MLSetDialogFunction()",
    FontFamily->"Courier"],
  ", the behavior of these functions has changed."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "If you used ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  " to deal with numbers textually, realize that you can still do that but, \
as mentioned above, there is now a better way."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "The values of the macros ",
  StyleBox["MLTKINT",
    FontFamily->"Courier"],
  ", etc., have changed.  If you used their literal values rather than these \
macros, your program will need to be corrected."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "All function pointers passed to ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " must point to code that follows the standard \
\[OpenCurlyDoubleQuote]callback\[CloseCurlyDoubleQuote] calling conventions.  \
These conventions differ considerably between platforms.  On a Macintosh, for \
example, all callback functions are declared ",
  StyleBox["pascal",
    FontFamily->"Courier"],
  ".  On a Windows computer, callbacks must be declared ",
  StyleBox["__stdcall",
    FontFamily->"Courier"],
  ".  To make it easier to write portable code, \
\[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] defines macros you \
can use to declare, define and install your callback functions.  As an \
example, the following code sets up a function called ",
  StyleBox["myhandler",
    FontFamily->"Courier"],
  " to be called whenever a message arrives on a link."
}], "BulletedList",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  StyleBox["MLINK link;\nMLENV env;\nMLMessageHandlerObject handler_object;\n\
\n", "MR"],
  StyleBox["MLMDECL", "MR",
    FontWeight->"Bold"],
  StyleBox["( void, myhandler, ( MLINK mlp, unsigned long m, unsigned long \
n));\n\n", "MR"],
  StyleBox["MLMDEFN", "MR",
    FontWeight->"Bold"],
  StyleBox["( void, myhandler, ( MLINK mlp, unsigned long m, unsigned long \
n))\n{\n\t...\n}\n\nvoid foo(void)\n{\n\thandler_object = \
MLCreateMessageHandler( env, ", "MR"],
  StyleBox["NewMLHandlerProc", "MR",
    FontWeight->"Bold"],
  StyleBox["( myhandler), 0);\n\tMLSetMessageHandler( link, handler_object);\n\
}", "MR"]
}], "FramedBox",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "The macros ",
  StyleBox["MLMDECL",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLMDEFN",
    FontFamily->"Courier"],
  " (highlighted above in bold face) take care of any qualifiers that need to \
be added to the function's prototype.  The macro ",
  StyleBox["NewMLHandlerProc",
    FontFamily->"Courier"],
  " creates any structure necessary to transfer control between two \
potentially different runtime environments.  (On a Macintosh, for example, \
the OS may need to switch between the native PowerPC environment and the  \
emulated 68K environment when ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " calls your function.  On a 16-bit Windows system, the \
\[OpenCurlyDoubleQuote]data segment\[CloseCurlyDoubleQuote] must be switched \
in order for the callback function to access its own global world.)  You \
should not use any casts in these calls so that the compiler can help you \
find type-mismatches.  For 16-bit Windows systems, the macro ",
  StyleBox["NewMLHandlerProc",
    FontFamily->"Courier"],
  " and its relatives require that the variable ",
  StyleBox["MLInstance",
    FontFamily->"Courier"],
  " (declared in \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote]) \
be defined and assigned the current instance value passed to ",
  StyleBox["WinMain",
    FontFamily->"Courier"],
  "."
}], "IndentedText",
  CellTags->{"changes", "UnixPorting"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Some Advice", "Subsubsection",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "Rather than going back and adding iterators to all your text-based ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " calls, consider using the following new functions."
}], "Text",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],

Cell["\<\
The following are useful if you use Unicode to store your strings.  \
Obviously, no iterators are necessary, as all characters are represented \
literally in the array of unsigned shorts.\
\>", "Text",
  CellTags->{"MLPutUnicodeString", "changes", "UnixPorting"}],

Cell[TextData[StyleBox["int MLPutUnicodeString( MLINK mlp, const unsigned \
short* s, long len);\nint MLGetUnicodeString( MLINK mlp, const unsigned \
short** sp, long* lenp);\nvoid MLDisownUnicodeString( MLINK mlp, const \
unsigned short* s, long len);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],

Cell[TextData[{
  "The following are useful for strings that you represent literally as an \
array of bytes and for receiving strings that you ",
  StyleBox["know",
    FontSlant->"Italic"],
  " contain only characters with codes less than 256.  (Your source code that \
puts or gets a ",
  StyleBox["DisplayPacket[]",
    FontFamily->"Courier"],
  " could reasonably use these functions.)  Again, no iterators are necessary \
as all characters are represented literally in the array of type ",
  StyleBox["unsigned char[]",
    FontFamily->"Courier"],
  ".  Note that if ",
  StyleBox["MLGetByteString()",
    FontFamily->"Courier"],
  " encounters a character with code >= 256, it will use the value of ",
  StyleBox["missing",
    FontSlant->"Italic"],
  " in that byte position in the string."
}], "Text",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],

Cell[TextData[StyleBox["int MLPutByteString( MLINK mlp, const unsigned char* \
s, long len);\nint MLGetByteString( MLINK mlp, const unsigned char** sp, \
long* lenp, long missing);\nvoid MLDisownByteString( MLINK mlp, const \
unsigned char* s, long len);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],

Cell["There are symbol analogs to these functions, too.", "Text",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],

Cell[TextData[{
  "If you want to put numbers textually, you can now, unlike in previous \
versions of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ",  precede any of the ",
  StyleBox["MLPut*String()",
    FontFamily->"Courier"],
  " calls with a call to ",
  StyleBox["MLPutNext()",
    FontFamily->"Courier"],
  ".  For example:"
}], "Text",
  CellTags->{"MLPutNext", "changes", "UnixPorting"}],

Cell[TextData[StyleBox["MLPutNext( link, MLTKREAL);\nMLPutByteString( link, \
\"1.2\", 3);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLPutNext", "UnixPorting"}],

Cell["and, as before, you can get a number as a string:", "Text",
  CellTags->{"MLGetUnicodeString", "changes", "UnixPorting"}],

Cell[TextData[StyleBox["unsigned short* s;\nlong len;\nif( MLGetType( link) \
== MLTKREAL)\n\tMLGetUnicodeString(link, &s, &len);", "MR"]], "FramedBox",
  CellTags->{"changes", "MLGetUnicodeString", "UnixPorting"}],

Cell[TextData[{
  "If you want to put or get characters ",
  StyleBox["some",
    FontSlant->"Italic"],
  " at a time, there are experimental functions for doing so which are \
preferred over ",
  StyleBox["MLPutData()",
    FontFamily->"Courier"],
  " and ",
  StyleBox["MLGetData()",
    FontFamily->"Courier"],
  ".  If you want to get textual data into your own memory and not have to \
\[OpenCurlyDoubleQuote]Disown\[CloseCurlyDoubleQuote] anything, there are \
experimental functions for doing so."
}], "Text",
  CellTags->{"changes", "UnixPorting"}],

Cell[TextData[{
  "There is now a way to have ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " deal with translating newline characters automatically."
}], "Text",
  CellTags->{"changes", "UnixPorting"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Troubleshooting", "Section",
  CellTags->"UnixTroubleshooting"],

Cell["\<\
Turn off compiler optimization until your program is working.  This \
makes compiling faster, debugging easier, and, besides, the optimizer may be \
broken and the cause of some problems.  (Don't automatically blame the \
optimizer, however, if your program fails when it is turned on.  Optimized \
code uses the stack and registers differently than unoptimized code in such a \
way that may expose or mask a bug in your code.  For example, the common \
mistake of returning a pointer to a local variable may or may not cause a \
problem depending on stack and register use.)\
\>", "BulletedList",
  CellTags->"UnixTroubleshooting"],

Cell[TextData[{
  "Check the return values from the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " library functions or call ",
  StyleBox["MLError()",
    FontFamily->"Courier"],
  " at key points in your program.  ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " will often be able to tell you what has gone wrong."
}], "BulletedList",
  CellTags->"UnixTroubleshooting"],

Cell[TextData[{
  "The files \[OpenCurlyDoubleQuote]mathlink.h\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]libML.a\[CloseCurlyDoubleQuote] are a matched set.  If \
you have used an earlier release of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", you should take care that you don't mix components when building your \
application."
}], "BulletedList",
  CellTags->"UnixTroubleshooting"],

Cell[TextData[{
  "Check whether the C compiler you are using supports prototypes.  If it \
does not, you will need to change your code and the way you build your \
project.  This is explained in the section ",
  ButtonBox["Building MathLink Programs",
    ButtonData:>"Building",
    ButtonStyle->"Hyperlink"],
  "."
}], "BulletedList",
  CellTags->"UnixTroubleshooting"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 828}},
ScreenStyleEnvironment->"Brackets",
WindowToolbars->"EditBar",
WindowSize->{550, 750},
WindowMargins->{{Automatic, 94}, {Automatic, 0}},
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions for On-line Help", "Subtitle"],
  
  Cell["\<\
These styles are carefully tuned for all aspects of the online \
help. It's recommended that they remain unchanged.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Brackets"],
    PageWidth->WindowWidth,
    ShowCellBracket->True,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "SlideShow"],
    PageWidth->WindowWidth,
    ScrollingOptions->{"PagewiseDisplay"->True},
    ShowCellBracket->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ShowAutoStyles->False,
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintout"],
    PageWidth->PaperWidth,
    ShowCellBracket->True,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintoutNonGray"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True},
    CellLabelAutoDelete->False,
    CellFrameLabelMargins->6,
    StyleMenuListing->None],
  
  Cell[StyleData["Notebook", "Printout"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True}],
  
  Cell[StyleData["Notebook", "EnhancedPrintout"],
    PageFooters->{{None, None, None}, {None, None, None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{False, False},
    PrintingOptions->{"PrintingMargins"->{{54, 54}, {36, 72}},
    "PageSize"->{594, 657},
    "PrintRegistrationMarks"->True,
    "FirstPageHeader"->False,
    "FacingPages"->True,
    "FirstPageFace"->Right}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Chapter"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{27, 27}, {10, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Plain",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Chapter", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["Chapter", "Printout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontSize->14],
  
  Cell[StyleData["Chapter", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->14,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Chapter", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellMargins->{{27, 27}, {12, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Section", "Presentation"],
    FontSize->30],
  
  Cell[StyleData["Section", "SlideShow"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {5, 0}},
    PageBreakBelow->False,
    CellFrameMargins->{{36, 36}, {Inherited, 15}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["Section", "EnhancedPrintout"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, 2}, {5, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Section", "EnhancedPrintoutNonGray"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CellFrameLabelMargins->6,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Subsection", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Subsection", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{2, 0}, {5, 24}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {5, 20}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Subsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionColor"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.297993, 0, 0.454994]],
  
  Cell[StyleData["SubsubsectionColor", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionColor", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{46, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->8},
    CellGroupingRules->{"SectionGrouping", 40},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsectionIcon", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubsectionIcon", "Printout"],
    CellDingbat->"\[FilledSquare]",
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{46, 27}, {0, 8}},
    CellElementSpacings->{"ClosedGroupTopMargin"->4},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsubsectionIcon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionIcon", "Printout"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{27, 27}, {0, 8}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    ParagraphSpacing->{0, 8},
    FontSize->12],
  
  Cell[StyleData["Text", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Text", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Hyphenation->False,
    FontSize->14],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CompactText"],
    CellMargins->{{27, 27}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["CompactText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CompactText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Compact12Text"],
    CellMargins->{{27, 27}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None],
  
  Cell[StyleData["Compact12Text", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Compact12Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextSans"],
    CellMargins->{{27, 27}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["TextSans", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["TextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Frutiger 55 Roman",
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Frutiger 55 Roman",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedText"],
    CellMargins->{{66, 4}, {4, 4}},
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedText", "Printout"],
    CellMargins->{{16, 4}, {2, 4}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintout"],
    CellMargins->{{16, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    ParagraphIndent->-18,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote"],
    CellMargins->{{88, 4}, {4, 0}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndentedText"],
    CellMargins->{{66, 4}, {0, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["IndentedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndentedText", "SlideShow"],
    CellMargins->{{80, 24}, {5, 5}},
    Hyphenation->False,
    FontSize->13],
  
  Cell[StyleData["IndentedText", "Printout"],
    CellMargins->{{16, 4}, {2, 4}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["IndentedText", "EnhancedPrintout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["IndentedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedList"],
    CellMargins->{{58, 4}, {4, 4}},
    CellFrameLabels->{{Cell[ 
            TextData[ {
              StyleBox[ 
                CounterBox[ "ItemizedList"], "TB"], 
              StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {
            24, Inherited}, TextAlignment -> Right], Inherited}, {
        Inherited, Inherited}},
    LineSpacing->{1, 3},
    CounterIncrements->"ItemizedList",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedList", "Printout"],
    CellMargins->{{9, 4}, {2, 4}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedList", "EnhancedPrintout"],
    CellMargins->{{9, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedSubList"],
    CellMargins->{{92, 4}, {4, 4}},
    CellFrameLabels->{{Cell[ 
            TextData[ {
              StyleBox[ 
                CounterBox[ "ItemizedSubList"], "TB"], 
              StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {
            24, Inherited}, TextAlignment -> Right], Inherited}, {
        Inherited, Inherited}},
    CounterIncrements->"ItemizedSubList",
    StyleMenuListing->None,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["ItemizedSubList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedSubList", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedSubList", "EnhancedPrintout"],
    CellMargins->{{26, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedSubList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedSubListNote"],
    CellMargins->{{110, 4}, {4, 4}},
    CounterIncrements->"ItemizedSubList",
    StyleMenuListing->None,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["ItemizedSubListNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedSubListNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedSubListNote", "EnhancedPrintout"],
    CellMargins->{{56, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedSubListNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{48, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BulletedList"],
    CellMargins->{{76, 4}, {4, 4}},
    CellFrameLabels->{{
      Cell[ "\[Bullet]", "BulletedList", CellBaseline -> Baseline], 
          Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 3},
    CounterIncrements->"BulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["BulletedList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BulletedList", "Printout"],
    CellMargins->{{16, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["BulletedList", "EnhancedPrintout"],
    CellMargins->{{26, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BulletedList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListNote"],
    CellMargins->{{88, 4}, {4, 0}},
    LineSpacing->{1, 2},
    CounterIncrements->"ListNote",
    StyleMenuListing->None],
  
  Cell[StyleData["ListNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ListNote", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ListNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathCaption"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{66, 12}, {2, 20}},
    PageBreakBelow->False,
    CellFrameMargins->{{8, 8}, {8, 2}},
    CellFrameColor->GrayLevel[0.700008],
    CellFrameLabelMargins->4,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8},
    FontColor->GrayLevel[0.2]],
  
  Cell[StyleData["MathCaption", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MathCaption", "SlideShow"],
    ShowCellBracket->False,
    CellMargins->{{36, 36}, {6, 6}}],
  
  Cell[StyleData["MathCaption", "Printout"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{27, 27}, {0, 8}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"SmallText",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {3, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Input", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {0, 6}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {4, 8}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Input", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->StandardForm],
  
  Cell[StyleData["Output", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Output", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {8, 4}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Output", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputOnly"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InputOnly", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["InputOnly", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 6}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["InputOnly", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["Message", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Message", "SlideShow"],
    CellMargins->{{100, 50}, {6, 6}},
    FontSize->10,
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["Message", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Print", "SlideShow"],
    CellMargins->{{100, 50}, {6, 6}}],
  
  Cell[StyleData["Print", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier Std",
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier Std",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultFormatTypeForOutput,
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["Graphics", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Graphics", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {4, 4}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Graphics", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{32, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier Std",
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{32, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier Std",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["CellLabel", "SlideShow"],
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Name"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["Name", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["Name", "Printout"],
    FontSize->7,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintout"],
    FontFamily->"Frutiger 56 Italic",
    FontSize->7,
    FontSlant->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 56 Italic",
    FontSize->7,
    FontSlant->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlinks", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks. The others point to the various sections of the help \
browser. These styles will modify individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLinkMR"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLinkText"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Times",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLinkText", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DemosLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["DemosLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["DemosLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["DemosLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TourLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["TourLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["TourLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["TourLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLinkMR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MasterIndexLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MasterIndexLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MasterIndexLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MasterIndexLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JT"],
    StyleMenuListing->None,
    FontFamily->"JFontText"],
  
  Cell[StyleData["JT", "Printout"]],
  
  Cell[StyleData["JT", "EnhancedPrintout"]],
  
  Cell[StyleData["JT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JS"],
    StyleMenuListing->None,
    FontFamily->"JFontSans"],
  
  Cell[StyleData["JS", "Printout"]],
  
  Cell[StyleData["JS", "EnhancedPrintout"]],
  
  Cell[StyleData["JS", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JSB"],
    StyleMenuListing->None,
    FontFamily->"JFontSansBold"],
  
  Cell[StyleData["JSB", "Printout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["RM", "Printout"]],
  
  Cell[StyleData["RM", "EnhancedPrintout"]],
  
  Cell[StyleData["RM", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["BF", "Printout"]],
  
  Cell[StyleData["BF", "EnhancedPrintout"]],
  
  Cell[StyleData["BF", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["IT", "Printout"]],
  
  Cell[StyleData["IT", "EnhancedPrintout"]],
  
  Cell[StyleData["IT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TR", "Printout"]],
  
  Cell[StyleData["TR", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TR", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSlant->"Italic"],
  
  Cell[StyleData["TI", "Printout"]],
  
  Cell[StyleData["TI", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TI", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TB", "Printout"]],
  
  Cell[StyleData["TB", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TB", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["TBI", "Printout"]],
  
  Cell[StyleData["TBI", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TBI", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MR"],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MR", "Printout"]],
  
  Cell[StyleData["MR", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["MR", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MO", "Printout"],
    FontSlant->"Oblique"],
  
  Cell[StyleData["MO", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"],
  
  Cell[StyleData["MO", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MB"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MB", "Printout"]],
  
  Cell[StyleData["MB", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["MB", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MBO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MBO", "Printout"],
    FontSlant->"Oblique"],
  
  Cell[StyleData["MBO", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"],
  
  Cell[StyleData["MBO", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SR", "Printout"]],
  
  Cell[StyleData["SR", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["SR", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "EnhancedPrintout"],
    FontFamily->"Frutiger 56 Italic",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 56 Italic",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SB", "Printout"],
    StyleMenuListing->None],
  
  Cell[StyleData["SB", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["SB", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SBColor"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBColor", "Printout"],
    StyleMenuListing->None],
  
  Cell[StyleData["SBColor", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["SBColor", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "EnhancedPrintout"],
    FontFamily->"Frutiger 66 BoldItalic",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 66 BoldItalic",
    FontWeight->"Plain",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["M4"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "Printout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "EnhancedPrintout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "EnhancedPrintoutNonGray"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Frutiger 56 Italic",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO10", "EnhancedPrintoutNonGray"],
    StyleMenuListing->None,
    FontFamily->"Frutiger 56 Italic",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S9"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "Printout"],
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->9,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "Printout"],
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB9"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Bold",
    PrivateFontOptions->{"OperatorSubstitution"->False}],
  
  Cell[StyleData["SB9", "Printout"],
    FontSize->7],
  
  Cell[StyleData["SB9", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->7,
    FontWeight->"Plain"],
  
  Cell[StyleData["SB9", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->7,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["SB10", "Printout"],
    FontSize->8],
  
  Cell[StyleData["SB10", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->8,
    FontWeight->"Plain"],
  
  Cell[StyleData["SB10", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->8,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MR10"],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    SingleLetterItalics->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MR10", "Printout"],
    FontSize->7],
  
  Cell[StyleData["MR10", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->7],
  
  Cell[StyleData["MR10", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1MR", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallCaps"],
    StyleMenuListing->None,
    Magnification->0.8],
  
  Cell[StyleData["SmallCaps", "Printout"]],
  
  Cell[StyleData["SmallCaps", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["SmallCaps", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["KeyboardChars"],
    StyleMenuListing->None,
    FontSize->12],
  
  Cell[StyleData["KeyboardChars", "Printout"],
    FontSize->10],
  
  Cell[StyleData["KeyboardChars", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["KeyboardChars", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Emphasis Boxes and Pictures", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Box"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["Box", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Box", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DoubleBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->2,
    RowAlignments->Top}],
  
  Cell[StyleData["DoubleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DoubleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["1ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["1ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["1ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.31, 0.67}}],
  
  Cell[StyleData["2ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.46}],
  
  Cell[StyleData["2ColumnEvenBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.35,
    ColumnAlignments->{Right, Left}}],
  
  Cell[StyleData["2ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.32}],
  
  Cell[StyleData["3ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.24,
    ColumnAlignments->{Right, Center, Left}}],
  
  Cell[StyleData["3ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellFrame->0.5,
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.13, 0.35, 0.13, 0.35}}],
  
  Cell[StyleData["4ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["4ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.202}],
  
  Cell[StyleData["5ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["5ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],
  
  Cell[StyleData["6ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["6ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FramedBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["FramedBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FramedBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["FramedBox", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["FramedBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox3Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox3Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox3Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox4Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.15, 0.35, 0.15, 0.35},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox4Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox4Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox5Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->0.2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox5Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox5Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox6Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox6Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox6Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 2}},
    CellFrameColor->GrayLevel[0],
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BottomBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BottomBox", "Printout"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {-2, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-2, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-4, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-4, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, 0}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-5, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-7, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-7, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Picture"],
    CellMargins->{{27, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Picture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Picture", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OpenCloseItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedPicture", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintout"],
    CellMargins->{{78, 2}, {12, -6}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListGraphic"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ListGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListGraphic", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5],
  
  Cell[StyleData["ListGraphic", "EnhancedPrintout"],
    CellMargins->{{78, 2}, {12, -6}},
    Magnification->0.5],
  
  Cell[StyleData["ListGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListNoteBox"],
    CellFrame->0.5,
    CellMargins->{{88, 12}, {8, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ListNoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListNoteBox", "Printout"],
    CellMargins->{{77, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ListNoteBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ListNoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{77, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellMargins->{{41, 4}, {0, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureGroup", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureGroup", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintoutNonGray"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Sound"],
    ShowCellBracket->True,
    CellMargins->{{27, Inherited}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Sound", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Sound", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Caption"],
    CellMargins->{{27, 4}, {0, 3}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["Caption", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["Caption", "Printout"],
    CellMargins->{{2, 4}, {2, 0}},
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {2, 2}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {2, -2}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Tables", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.34, 0.64},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->0.49,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnEvenTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{27, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    AutoSpacing->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineOutput"],
    CellMargins->{{27, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InlineOutput", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{66, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True},
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DisplayFormula", "Printout"]],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayMath"],
    CellMargins->{{66, 10}, {7, 7}},
    Evaluatable->False,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input"],
  
  Cell[StyleData["DisplayMath", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DisplayMath", "Printout"],
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{66, 10}, {7, 7}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LanguageCategory->"Formula",
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["EquationNumber"],
    CellMargins->{{66, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1.83, 0},
    LanguageCategory->"Formula"],
  
  Cell[StyleData["EquationNumber", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["EquationNumber", "Printout"],
    LineSpacing->{1.7, 0}],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintout"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintoutNonGray"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellMargins->{{66, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    ShowSpecialCharacters->Automatic,
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintoutNonGray"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Unique Help Browser Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell["\<\
Standard Styles
\
\>", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel1"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 10}, {2, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-38,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel1", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["InspectorLevel1", "SlideShow"],
    HyphenationOptions->{"HyphenationCharacter"->"-"}],
  
  Cell[StyleData["InspectorLevel1", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel2"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["InspectorLevel2", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectName"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellGroupingRules->{"SectionGrouping", 50},
    CellFrameMargins->{{27, 12}, {3, 15}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold",
    Background->RGBColor[0.960784, 0.878431, 0.666667]],
  
  Cell[StyleData["ObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["ObjectName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {1, 10}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["SubObjectNameClosed", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{90, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["SubObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["GroupObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["GroupObjectNameClosed", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectNameWarningMessages"],
    CellMargins->{{27, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["ObjectNameWarningMessages", "SlideShow"],
    CellMargins->{{10, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Command"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 12}, {3, 15}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Section",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    Background->RGBColor[0.960784, 0.878431, 0.666667]],
  
  Cell[StyleData["Command", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Command", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CharacterName"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 27}, {8, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["CharacterName", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CharacterName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CharacterName", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Usage"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 27}, {8, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    Hyphenation->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["Usage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Usage", "SlideShow"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{72, 4}, {0, 4}},
    CellFrameMargins->5,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ErrorMessage"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    ShowCellBracket->True,
    CellMargins->{{27, 4}, {0, 4}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    CellFrameMargins->5,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["ErrorMessage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ErrorMessage", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["ErrorMessage", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notes"],
    CellMargins->{{27, 27}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Notes", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NotesList"],
    CellMargins->{{20, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NotesList", "SlideShow"],
    CellMargins->{{82, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Printout"],
    CellMargins->{{12, 0}, {2, 8}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ReferenceSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 30},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["ReferenceSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["ReferenceSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Reference"],
    CellMargins->{{10, 4}, {0, 8}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    ParagraphSpacing->{0, 8},
    FontSize->12],
  
  Cell[StyleData["Reference", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Reference", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Hyphenation->False,
    FontSize->14],
  
  Cell[StyleData["Reference", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["Reference", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Reference", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["ExampleSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleText"],
    CellMargins->{{27, 40}, {0, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ExampleText", "Printout"],
    CellMargins->{{2, 80}, {0, 8}},
    PageBreakBelow->False,
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSubsection"],
    ShowCellBracket->True,
    CellMargins->{{27, 4}, {0, 16}},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSubsection", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["ExampleSubsection", "Printout"],
    CellMargins->{{12, 0}, {0, 16}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MessagesSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["MessagesSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["MessagesSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TemplateSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{27, 4}, {0, 10}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->True},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["TemplateSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["TemplateSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LineHead"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{27, 4}, {8, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["LineHead", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["LineHead", "Printout"],
    CellMargins->{{2, 0}, {8, 18}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushInput"],
    CellMargins->{{27, 4}, {1, 4}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["FlushInput", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FlushInput", "Printout"],
    CellMargins->{{2, 0}, {1, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushOutput"],
    CellMargins->{{27, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    StyleMenuListing->None],
  
  Cell[StyleData["FlushOutput", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FlushOutput", "Printout"],
    CellMargins->{{2, Inherited}, {Inherited, Inherited}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DialogItem"],
    CellDingbat->"\[EmptyDiamond]",
    CellMargins->{{27, 4}, {0, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["DialogItem", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["DialogItem", "Printout"],
    CellMargins->{{12, 0}, {0, 12}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupDivider"],
    CellMargins->{{27, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->{"TitleGrouping", 0},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["GroupDivider", "Presentation"],
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Highlight"],
    CellFrame->0.5,
    CellMargins->{{27, 4}, {0, 18}},
    CellFrameColor->GrayLevel[0.800015],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.950011]],
  
  Cell[StyleData["Highlight", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Highlight", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserNotes"],
    CellFrame->{{3, 0}, {0, 0}},
    CellMargins->{{27, 4}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["UserNotes", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["UserNotes", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8],
  
  Cell[StyleData["UserNotes", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {0, 4}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8],
  
  Cell[StyleData["UserNotes", "EnhancedPrintoutNonGray"],
    CellMargins->{{0, 0}, {0, 4}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MoreInfo"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["MoreInfo", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["MoreInfo", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserTips"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["UserTips", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["UserTips", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0.800015],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["UserTips", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8,
    Background->GrayLevel[0.700008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Theorem"],
    CellFrame->{{4, 0}, {0, 0}},
    CellMargins->{{27, 62}, {0, 14}},
    CellFrameMargins->4,
    CellFrameColor->RGBColor[0, 0, 0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Theorem", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Theorem", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    CellFrameMargins->3,
    CellFrameColor->GrayLevel[0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Commentary"],
    CellFrame->{{2, 0}, {0, 0}},
    CellMargins->{{36, 10}, {7, 7}},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CellFrameColor->RGBColor[0, 0.2, 1],
    LineSpacing->{1, 3},
    FontSlant->"Italic"],
  
  Cell[StyleData["Commentary", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Commentary", "Printout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level1Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level1Icon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Level1Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level2Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level2Icon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Level2Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CopyrightHead"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CopyrightHead", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CopyrightHead", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Copyright"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["Copyright", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Copyright", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["Copyright", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterSubsection"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 45},
    CellFrameLabelMargins->6,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->16],
  
  Cell[StyleData["RegisterSubsection", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["RegisterSubsection", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 12}},
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "Printout"],
    CellMargins->{{9, 0}, {5, 24}},
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterSubsubsection"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["RegisterSubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["RegisterSubsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["RegisterSubsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["RegisterSubsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterText"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["RegisterText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["RegisterText", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["RegisterText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CaptionHead"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CaptionHead", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CaptionHead", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["CaptionHead", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CaptionText"],
    CellMargins->{{66, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None],
  
  Cell[StyleData["CaptionText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CaptionText", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["CaptionText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BulletText"],
    CellMargins->{{76, 4}, {4, 4}},
    CellFrameLabels->{{
      Cell[ "\[Bullet]", "BulletText", CellBaseline -> Baseline], 
          Inherited}, {Inherited, Inherited}},
    Hyphenation->False,
    LineSpacing->{1, 3},
    CounterIncrements->"BulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["BulletText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BulletText", "Printout"],
    FontSize->10],
  
  Cell[StyleData["BulletText", "EnhancedPrintout"],
    CellMargins->{{16, 4}, {2, 4}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BulletText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["HelpLabels"],
    CellMargins->{{88, 4}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["HelpLabels", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["HelpLabels", "Printout"],
    CellMargins->{{34, 2}, {6, 6}},
    FontSize->10],
  
  Cell[StyleData["HelpLabels", "EnhancedPrintout"],
    CellMargins->{{34, 2}, {6, 6}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Manual.nb Merge", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell["Function List", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionName"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{24, 10}, {10, 12}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold",
    CellTags->"FunctionName"],
  
  Cell[StyleData["FunctionName", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["FunctionName", "Printout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionSubsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{36, 10}, {0, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontWeight->"Bold",
    CellTags->"FunctionSubsection"],
  
  Cell[StyleData["FunctionSubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionSubsection", "Printout"],
    CellMargins->{{30, 0}, {0, 6}}],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescription"],
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["FunctionDescription", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescription", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuled"],
    CellFrame->{{0, 0}, {0.25, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuled", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuled", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleTop"],
    CellFrame->{{0, 0}, {0, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleBottom"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionExample"],
    CellMargins->{{36, 10}, {4, 0}},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["FunctionExample", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["FunctionExample", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionTextNote"],
    CellMargins->{{36, 4}, {0, 4}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 4},
    LineIndent->0,
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionTextNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionTextNote", "Printout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontSize->9],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnFunctionTable"],
    CellMargins->{{36, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnFunctionTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnFunctionTable", "Printout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Browser Emulation", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextNormal"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["TextNormal", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TextNormal", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BrowserEmulation"],
    CellMargins->{{12, 1}, {7, 24}},
    CellGroupingRules->{"SectionGrouping", 70},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    GridBoxOptions->{ColumnWidths->0.25,
    ColumnAlignments->{Left},
    GridFrame->True,
    GridFrameMargins->0.5,
    ColumnLines->True}],
  
  Cell[StyleData["BrowserEmulation", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BrowserEmulation", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CategoryDefs"],
    CellMargins->{{300, 10}, {7, 7}},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    Background->RGBColor[1, 0.8, 0.6],
    GridBoxOptions->{ColumnAlignments->{Left},
    GridFrame->False,
    RowLines->True,
    ColumnLines->True}],
  
  Cell[StyleData["CategoryDefs", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CategoryDefs", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category1"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    StyleMenuListing->None,
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Category1", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Category1", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category2"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{85, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    StyleMenuListing->None,
    FontSize->14,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 0.500008]],
  
  Cell[StyleData["Category2", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["Category2", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category3"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{157, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.2, 0, 0.4]],
  
  Cell[StyleData["Category3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Category3", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category4"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{230, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    StyleMenuListing->None,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0.300008, 0.4]],
  
  Cell[StyleData["Category4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Category4", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Misc", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.25,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["4ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["4ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.2,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["5ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["5ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.16,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["6ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["6ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["7ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.14,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["7ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["7ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["8ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.12,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["8ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["8ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ABItemizedText"],
    CellMargins->{{20, 4}, {0, 5}},
    LineSpacing->{1, 3},
    ParagraphIndent->-21,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ABItemizedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ABItemizedText", "Printout"],
    Hyphenation->True,
    ParagraphIndent->-21,
    FontSize->11],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintout"],
    Hyphenation->True,
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapNumber"],
    CellMargins->{{27, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->42,
    FontWeight->"Plain",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ChapNumber", "Presentation"],
    FontSize->63],
  
  Cell[StyleData["ChapNumber", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->36],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->36,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->36,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapTitle"],
    CellMargins->{{27, Inherited}, {80, 10}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ChapTitle", "Presentation"],
    FontSize->54],
  
  Cell[StyleData["ChapTitle", "Printout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontSize->30],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemDingbat"],
    CellSize->{22, 14},
    TextAlignment->Right,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["ItemDingbat", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemDingbat", "Printout"],
    CellSize->{22, 13.125}],
  
  Cell[StyleData["ItemDingbat", "EnhancedPrintout"],
    CellSize->{22, 11}],
  
  Cell[StyleData["ItemDingbat", "EnhancedPrintoutNonGray"],
    CellSize->{22, 11}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1"],
    CellMargins->{{19, 4}, {4, 4}},
    ParagraphIndent->-22,
    CounterIncrements->"Item1",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item1", "Printout"],
    CellMargins->{{12, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item1", "EnhancedPrintout"],
    CellMargins->{{16, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item1", "EnhancedPrintoutNonGray"],
    CellMargins->{{16, 0}, {2, 4}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1Continued"],
    CellMargins->{{41, 4}, {4, 1}},
    CounterIncrements->"Item1Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item1Continued", "Printout"],
    CellMargins->{{34, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintout"],
    CellMargins->{{39, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 0}, {4, 1}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2"],
    CellMargins->{{32, 4}, {4, 4}},
    ParagraphIndent->-22,
    CounterIncrements->"Item2",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item2", "Printout"],
    CellMargins->{{26, 0}, {4, 4}},
    ParagraphIndent->-22,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintout"],
    CellMargins->{{29, 0}, {2, 4}},
    ParagraphIndent->-22,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintoutNonGray"],
    CellMargins->{{29, 0}, {2, 4}},
    ParagraphIndent->-22,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2Continued"],
    CellMargins->{{54, 4}, {4, 1}},
    CounterIncrements->"Item2Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item2Continued", "Printout"],
    CellMargins->{{27, 0}, {4, 1}}],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintout"],
    CellMargins->{{52, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{52, 0}, {4, 1}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3"],
    CellMargins->{{45, 4}, {4, 4}},
    ParagraphIndent->-23,
    CounterIncrements->"Item3",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item3", "Printout"],
    CellMargins->{{27, 0}, {2, 4}}],
  
  Cell[StyleData["Item3", "EnhancedPrintout"],
    CellMargins->{{42, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item3", "EnhancedPrintoutNonGray"],
    CellMargins->{{42, 0}, {2, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3Continued"],
    CellMargins->{{67, 4}, {4, 1}},
    CounterIncrements->"Item3Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item3Continued", "Printout"],
    CellMargins->{{27, 0}, {4, 1}}],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintout"],
    CellMargins->{{65, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{65, 0}, {4, 1}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBulletText"],
    CellMargins->{{19, 4}, {0, 5}},
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedBulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedBulletText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedBulletText", "Printout"],
    Hyphenation->True,
    ParagraphIndent->-20,
    FontSize->11],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintout"],
    Hyphenation->True,
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NoteBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {8, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["NoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NoteBox", "Printout"],
    CellMargins->{{2, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["NoteBox", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["NoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBox"],
    CellFrame->0.5,
    CellMargins->{{41, 4}, {8, 2}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ItemizedNoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNoteBox", "Printout"],
    CellMargins->{{39, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{37, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameMargins->{{8, 8}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedTopBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTopBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {0, 6}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {0, 6}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{37, 4}, {4, 0}},
    CellHorizontalScrolling->True,
    CellFrameMargins->{{8, 8}, {8, 0}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedBottomBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedBottomBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {6, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpacedBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpacedBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleSpacedBox", "Printout"],
    CellMargins->{{2, 0}, {0, 0}},
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNote"],
    CellMargins->{{41, 4}, {0, 12}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNote", "Printout"],
    CellMargins->{{38, 4}, {0, 9}},
    Hyphenation->True,
    FontSize->11],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBelow"],
    CellMargins->{{41, 4}, {0, 8}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNoteBelow", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNoteBelow", "Printout"],
    CellMargins->{{38, 4}, {0, 12}},
    Hyphenation->True,
    FontSize->11],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextBelowPic"],
    CellMargins->{{19, 4}, {0, 8}},
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextBelowPic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextBelowPic", "Printout"],
    CellMargins->{{20, 4}, {2, 12}},
    Hyphenation->True,
    ParagraphIndent->-18,
    FontSize->11],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintout"],
    CellMargins->{{20, 4}, {2, 12}},
    Hyphenation->True,
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 4}, {2, 12}},
    Hyphenation->True,
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote2"],
    CellMargins->{{41, 4}, {0, 4}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextNote2", "Printout"],
    CellMargins->{{38, 4}, {0, 2}},
    Hyphenation->True,
    FontSize->11],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 2}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 2}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem1"],
    CellMargins->{{48, 4}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem1",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem1", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintoutNonGray"],
    CellMargins->{{12, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem2"],
    CellMargins->{{71, 4}, {3, 3}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-21,
    CounterIncrements->"NumberedItem2",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem2", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem3"],
    CellMargins->{{94, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem3",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem3", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeaderBold"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["PageHeaderBold", "Printout"]],
  
  Cell[StyleData["PageHeaderBold", "EnhancedPrintout"],
    FontFamily->"Frutiger"],
  
  Cell[StyleData["PageHeaderBold", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SingleRowTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["SingleRowTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SingleRowTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsubsection"],
    CellMargins->{{27, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Subsubsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{27, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{27, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextBelow"],
    CellMargins->{{27, 4}, {0, 14}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontSize->12],
  
  Cell[StyleData["TextBelow", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TextBelow", "Printout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{27, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    FontSize->54],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->30],
  
  Cell[StyleData["Title", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain"],
  
  Cell[StyleData["Title", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Undersubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Undersubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Undersubsection", "Printout"],
    CellMargins->{{2, 0}, {7, 10}},
    FontSize->10],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SectionFirst"],
    CellMargins->{{27, 27}, {12, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SectionFirst", "Presentation"],
    FontSize->30],
  
  Cell[StyleData["SectionFirst", "Printout"],
    CellMargins->{{2, 0}, {0, 6}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["SectionFirst", "EnhancedPrintout"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 6}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SectionFirst", "EnhancedPrintoutNonGray"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 6}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionFirst"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsectionFirst", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubsectionFirst", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 6}},
    FontSize->12],
  
  Cell[StyleData["SubsectionFirst", "Printout"],
    CellMargins->{{9, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontSize->12],
  
  Cell[StyleData["SubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionFirst"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsubsectionFirst", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionFirst", "Printout"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontSize->10],
  
  Cell[StyleData["SubsubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SubsubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsubsectionFirst"],
    CellMargins->{{10, 4}, {0, 12}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsubsubsectionFirst", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsubsectionFirst", "Printout"],
    CellMargins->{{2, 0}, {3, 3}},
    FontSize->10],
  
  Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 3}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 3}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell["Spacer Cell", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Spacer"],
    CellMargins->{{10, 10}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->1},
    CellOpen->False,
    StyleMenuListing->None],
  
  Cell[StyleData["Spacer", "Printout"],
    CellOpen->True,
    FontSize->3]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DiscretionaryHyphen"],
    StyleMenuListing->None,
    FontSize->0.0625,
    FontColor->GrayLevel[1]],
  
  Cell[StyleData["DiscretionaryHyphen", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintoutNonGray"],
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller1"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller1", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.63],
  
  Cell[StyleData["PictureSmaller1", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.63],
  
  Cell[StyleData["PictureSmaller1", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.63]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller2"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller2", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.61],
  
  Cell[StyleData["PictureSmaller2", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.61],
  
  Cell[StyleData["PictureSmaller2", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.61]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller3"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller3", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.59],
  
  Cell[StyleData["PictureSmaller3", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.59],
  
  Cell[StyleData["PictureSmaller3", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.59]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller4"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller4", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.57],
  
  Cell[StyleData["PictureSmaller4", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.57],
  
  Cell[StyleData["PictureSmaller4", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.57]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller5"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller5", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.55],
  
  Cell[StyleData["PictureSmaller5", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.55],
  
  Cell[StyleData["PictureSmaller5", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.55]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller6"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller6", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.53],
  
  Cell[StyleData["PictureSmaller6", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.53],
  
  Cell[StyleData["PictureSmaller6", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.53]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPicture"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPicture", "Printout"],
    CellMargins->{{55, Inherited}, {8, -4}},
    Magnification->0.65],
  
  Cell[StyleData["ItemPicture", "EnhancedPrintout"],
    CellMargins->{{60, Inherited}, {10, -3}},
    Magnification->0.65],
  
  Cell[StyleData["ItemPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{60, Inherited}, {10, -3}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller1"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller1", "Printout"],
    CellMargins->{{56, Inherited}, {9, -3}},
    Magnification->0.63],
  
  Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintout"],
    CellMargins->{{63, Inherited}, {10, -3}},
    Magnification->0.63],
  
  Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintoutNonGray"],
    CellMargins->{{63, Inherited}, {10, -3}},
    Magnification->0.63]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller2"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller2", "Printout"],
    CellMargins->{{58, Inherited}, {8, -4}},
    Magnification->0.61],
  
  Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintout"],
    CellMargins->{{65, Inherited}, {11, -3}},
    Magnification->0.61],
  
  Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintoutNonGray"],
    CellMargins->{{65, Inherited}, {11, -3}},
    Magnification->0.61]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller3"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller3", "Printout"],
    CellMargins->{{61, Inherited}, {10, -2}},
    Magnification->0.59],
  
  Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintout"],
    CellMargins->{{67, Inherited}, {11, -3}},
    Magnification->0.59],
  
  Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintoutNonGray"],
    CellMargins->{{67, Inherited}, {11, -3}},
    Magnification->0.59]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller4"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller4", "Printout"],
    CellMargins->{{63, Inherited}, {10, -2}},
    Magnification->0.57],
  
  Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintout"],
    CellMargins->{{69, Inherited}, {12, -4}},
    Magnification->0.57],
  
  Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintoutNonGray"],
    CellMargins->{{69, Inherited}, {12, -4}},
    Magnification->0.57]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller5"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller5", "Printout"],
    CellMargins->{{65, Inherited}, {11, -2}},
    Magnification->0.55],
  
  Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintout"],
    CellMargins->{{71, Inherited}, {13, -2}},
    Magnification->0.55],
  
  Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintoutNonGray"],
    CellMargins->{{71, Inherited}, {13, -2}},
    Magnification->0.55]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller6"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller6", "Printout"],
    CellMargins->{{67, Inherited}, {12, -2}},
    Magnification->0.53],
  
  Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintout"],
    CellMargins->{{74, Inherited}, {13, -3}},
    Magnification->0.53],
  
  Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintoutNonGray"],
    CellMargins->{{74, Inherited}, {13, -3}},
    Magnification->0.53]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger1"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger1", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.68],
  
  Cell[StyleData["PictureBigger1", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.68],
  
  Cell[StyleData["PictureBigger1", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.68]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger2"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger2", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.71],
  
  Cell[StyleData["PictureBigger2", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.71],
  
  Cell[StyleData["PictureBigger2", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.71]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger3"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger3", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.74],
  
  Cell[StyleData["PictureBigger3", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.74],
  
  Cell[StyleData["PictureBigger3", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.74]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger4"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger4", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.77],
  
  Cell[StyleData["PictureBigger4", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.77],
  
  Cell[StyleData["PictureBigger4", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.77]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger5"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger5", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.8],
  
  Cell[StyleData["PictureBigger5", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.8],
  
  Cell[StyleData["PictureBigger5", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger6"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger6", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.83],
  
  Cell[StyleData["PictureBigger6", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.83],
  
  Cell[StyleData["PictureBigger6", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.83]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger1"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger1", "Printout"],
    CellMargins->{{50, Inherited}, {9, -3}},
    Magnification->0.68],
  
  Cell[StyleData["ItemPictureBigger1", "EnhancedPrintout"],
    CellMargins->{{57, Inherited}, {10, -3}},
    Magnification->0.68],
  
  Cell[StyleData["ItemPictureBigger1", "EnhancedPrintoutNonGray"],
    CellMargins->{{57, Inherited}, {10, -3}},
    Magnification->0.68]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger2"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger2", "Printout"],
    CellMargins->{{48, Inherited}, {8, -4}},
    Magnification->0.71],
  
  Cell[StyleData["ItemPictureBigger2", "EnhancedPrintout"],
    CellMargins->{{54, Inherited}, {10, -3}},
    Magnification->0.71],
  
  Cell[StyleData["ItemPictureBigger2", "EnhancedPrintoutNonGray"],
    CellMargins->{{54, Inherited}, {10, -3}},
    Magnification->0.71]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger3"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger3", "Printout"],
    CellMargins->{{46, Inherited}, {10, -2}},
    Magnification->0.74],
  
  Cell[StyleData["ItemPictureBigger3", "EnhancedPrintout"],
    CellMargins->{{52, Inherited}, {10, -3}},
    Magnification->0.74],
  
  Cell[StyleData["ItemPictureBigger3", "EnhancedPrintoutNonGray"],
    CellMargins->{{52, Inherited}, {10, -3}},
    Magnification->0.74]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger4"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger4", "Printout"],
    CellMargins->{{45, Inherited}, {10, -2}},
    Magnification->0.77],
  
  Cell[StyleData["ItemPictureBigger4", "EnhancedPrintout"],
    CellMargins->{{50, Inherited}, {10, -3}},
    Magnification->0.77],
  
  Cell[StyleData["ItemPictureBigger4", "EnhancedPrintoutNonGray"],
    CellMargins->{{50, Inherited}, {10, -3}},
    Magnification->0.77]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger5"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger5", "Printout"],
    CellMargins->{{43, Inherited}, {11, -2}},
    Magnification->0.8],
  
  Cell[StyleData["ItemPictureBigger5", "EnhancedPrintout"],
    CellMargins->{{49, Inherited}, {10, -3}},
    Magnification->0.8],
  
  Cell[StyleData["ItemPictureBigger5", "EnhancedPrintoutNonGray"],
    CellMargins->{{49, Inherited}, {10, -3}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger6"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger6", "Printout"],
    CellMargins->{{43, Inherited}, {12, -2}},
    Magnification->0.83],
  
  Cell[StyleData["ItemPictureBigger6", "EnhancedPrintout"],
    CellMargins->{{46, Inherited}, {8, -2}},
    Magnification->0.83],
  
  Cell[StyleData["ItemPictureBigger6", "EnhancedPrintoutNonGray"],
    CellMargins->{{46, Inherited}, {8, -2}},
    Magnification->0.83]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ScreenGraphic"],
    CellMargins->{{12, Inherited}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ScreenGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ScreenGraphic", "Printout"],
    CellMargins->{{2, Inherited}, {0, 8}}],
  
  Cell[StyleData["ScreenGraphic", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False],
  
  Cell[StyleData["ScreenGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrintGraphic"],
    CellMargins->{{12, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False,
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PrintGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PrintGraphic", "Printout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False],
  
  Cell[StyleData["PrintGraphic", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->12},
    CellOpen->True],
  
  Cell[StyleData["PrintGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->12},
    CellOpen->True]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallTextSans"],
    CellMargins->{{10, 4}, {8, 8}},
    TextJustification->1,
    LineSpacing->{1, 2},
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallTextSans", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SmallTextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->7],
  
  Cell[StyleData["SmallTextSans", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, -2},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["AuthorTools", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BilateralCell"],
    CellMargins->{{27, 4}, {0, 8}},
    StyleMenuListing->None,
    FontSize->12,
    GridBoxOptions->{ColumnWidths->{0.33, 0.6},
    RowAlignments->Top,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BilateralCell", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BilateralCell", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["BilateralCell", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RuledPageBreak"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{27, 4}, {12, 0}},
    CellFrameMargins->{{0, 0}, {1, 0}},
    FontSize->8],
  
  Cell[StyleData["RuledPageBreak", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["RuledPageBreak", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}}],
  
  Cell[StyleData["RuledPageBreak", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True,
    FontSize->1],
  
  Cell[StyleData["RuledPageBreak", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True],
  
  Cell[StyleData["RuledPageBreak", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True]
  }, Closed]],
  
  Cell[StyleData["PaletteTitle"],
    CellFrame->{{0, 0}, {1, 0}},
    CellMargins->{{4, 0}, {Inherited, 0}},
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->RGBColor[0, 0.32549, 0.537255],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #2]}]&),
    ButtonEvaluator->None,
    ButtonStyle->"PaletteButton",
    ButtonMargins->3}],
  
  Cell[StyleData["PaletteButton"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonEvaluator->"Local",
    Active->True,
    ButtonMargins->6,
    Background->RGBColor[0.329412, 0.584314, 0.694118]}],
  
  Cell[StyleData["PaletteButton2"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonEvaluator->"Local",
    Active->True,
    ButtonMargins->4,
    Background->RGBColor[0.537255, 0.72549, 0.843137]}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{27, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "Presentation"],
    FontSize->27],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{57, 10}, {6, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "Presentation"],
    FontSize->23],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{87, 10}, {5, 5}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{117, 10}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Slide Show Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowNavigationBar"],
    Editable->False,
    CellFrame->True,
    CellMargins->{{0, 0}, {3, 3}},
    CellElementSpacings->{"CellMinHeight"->0.8125},
    CellGroupingRules->{"SectionGrouping", 30},
    CellFrameMargins->False,
    CellFrameColor->GrayLevel[1],
    CellFrameLabelMargins->False,
    TextAlignment->Center,
    CounterIncrements->"SlideShowNavigationBar",
    StyleMenuListing->None,
    FontSize->10,
    Background->GrayLevel[0.8],
    Magnification->1,
    GridBoxOptions->{GridBaseline->Center,
    RowSpacings->0,
    ColumnSpacings->0,
    ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
    RowAlignments->Baseline,
    ColumnAlignments->{
      Center, Center, Center, Center, Center, Center, Right, Center}}],
  
  Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
    Deletable->False,
    ShowCellBracket->False,
    CellMargins->{{-1, -1}, {-1, -1}},
    PageBreakAbove->True,
    CellFrameMargins->{{1, 1}, {0, 0}}],
  
  Cell[StyleData["SlideShowNavigationBar", "Printout"],
    CellMargins->{{18, 4}, {4, 4}},
    LineSpacing->{1, 3},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{0, 0}, {10, 0}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CellFrameMargins->{{12, 4}, {6, 12}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["SlideShowSection", "Presentation"],
    FontSize->27],
  
  Cell[StyleData["SlideShowSection", "SlideShow"],
    ShowCellBracket->False,
    PageBreakAbove->True],
  
  Cell[StyleData["SlideShowSection", "Printout"],
    CellMargins->{{18, 30}, {0, 30}},
    CellFrameMargins->5,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideHyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontSize->26,
    FontColor->GrayLevel[0.400015],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMinHeight->0.85,
    ButtonMargins->0.5,
    ButtonNote->None}],
  
  Cell[StyleData["SlideHyperlink", "SlideShow"]],
  
  Cell[StyleData["SlideHyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOCLink"],
    CellMargins->{{24, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMargins->1.5,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["SlideTOCLink", "SlideShow"]],
  
  Cell[StyleData["SlideTOCLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOC"],
    CellDingbat->"\[Bullet]",
    CellMargins->{{18, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    FontFamily->"Helvetica"],
  
  Cell[StyleData["SlideTOC", "SlideShow"],
    FontSize->14],
  
  Cell[StyleData["SlideTOC", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Title Page, Contents, and Index", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsTitle"],
    CellMargins->{{21, 4}, {12, 24}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ContentsTitle", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["ContentsTitle", "Printout"],
    CellMargins->{{12, 0}, {102, 89}},
    PageBreakBelow->False,
    FontSize->30.5,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ContentsTitle", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {15, 30}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsSection"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{35, 4}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ContentsSection", "Printout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{20, 4}, {5, 20}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["IndexSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndexSection", "Printout"],
    CellMargins->{{12, 0}, {5, 20}},
    PageBreakBelow->False,
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Contents"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{50, 4}, {0, 5}},
    CellGroupingRules->{"SectionGrouping", 90},
    StyleMenuListing->None],
  
  Cell[StyleData["Contents", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Contents", "Printout"],
    CellMargins->{{40, 4}, {0, 5}},
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintout"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintoutNonGray"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index"],
    CellMargins->{{21, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["Index", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Index", "Printout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontSize->9],
  
  Cell[StyleData["Index", "EnhancedPrintout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["Index", "EnhancedPrintoutNonGray"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSubentry"],
    CellMargins->{{36, 4}, {0, 0}},
    ParagraphIndent->-48],
  
  Cell[StyleData["IndexSubentry", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndexSubentry", "Printout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontSize->9],
  
  Cell[StyleData["IndexSubentry", "EnhancedPrintout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index2Column"],
    CellMargins->{{21, 4}, {0, 8}},
    ParagraphIndent->-20,
    TabSpacings->1,
    StyleMenuListing->None,
    FontSize->10,
    GridBoxOptions->{ColumnWidths->0.5,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["Index2Column", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Index2Column", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->8],
  
  Cell[StyleData["Index2Column", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {1, 1}},
    LineSpacing->{1, 0.2},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["Index2Column", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {1, 1}},
    LineSpacing->{1, 0.2},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Leader"],
    TabFilling->".",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["Leader", "Printout"],
    FontSize->10],
  
  Cell[StyleData["Leader", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LeaderNoDots"],
    TabFilling->" ",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["LeaderNoDots", "Printout"],
    FontSize->10],
  
  Cell[StyleData["LeaderNoDots", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["PageLink", "Printout"],
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["PageLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCPage"],
    CellSize->{22, Inherited},
    TextAlignment->Right,
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["TOCPage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCPage", "Printout"],
    FontSize->10],
  
  Cell[StyleData["TOCPage", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitle"],
    CellMargins->{{20, 0}, {1, 8}},
    CellGroupingRules->{"SectionGrouping", 70},
    TabSpacings->46,
    CounterIncrements->"TOCTitle",
    CounterAssignments->{{"TOCSection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["TOCTitle", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCTitle", "Printout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    TabSpacings->47.4,
    FontSize->11],
  
  Cell[StyleData["TOCTitle", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {2, 10}},
    PageBreakBelow->False,
    TabSpacings->49.3,
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSection"],
    CellMargins->{{48, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 75},
    TabSpacings->42.9,
    CounterIncrements->"TOCSection",
    CounterAssignments->{{"TOCSubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->12],
  
  Cell[StyleData["TOCSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSection", "Printout"],
    CellMargins->{{30, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->12],
  
  Cell[StyleData["TOCSection", "EnhancedPrintout"],
    CellMargins->{{26, 0}, {1, 3}},
    PageBreakBelow->False,
    TabSpacings->46.45,
    FontFamily->"Frutiger",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsection"],
    CellMargins->{{76, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 80},
    TabSpacings->39.8,
    CounterIncrements->"TOCSubsection",
    CounterAssignments->{{"TOCSubsubsection", 0}},
    FontSize->12],
  
  Cell[StyleData["TOCSubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsection", "Printout"],
    CellMargins->{{70, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->10],
  
  Cell[StyleData["TOCSubsection", "EnhancedPrintout"],
    CellMargins->{{38, 0}, {1, 1}},
    PageBreakBelow->False,
    TabSpacings->45.15,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsubsection"],
    CellMargins->{{104, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 85},
    TabSpacings->36.7,
    CounterIncrements->"TOCSubsubsection",
    FontSize->12],
  
  Cell[StyleData["TOCSubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsubsection", "Printout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->9],
  
  Cell[StyleData["TOCSubsubsection", "EnhancedPrintout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitleDingbat"],
    CellSize->{34, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCTitleDingbat", "EnhancedPrintout"],
    FontFamily->"Frutiger",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSectionDingbat"],
    CellSize->{38, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCSectionDingbat", "EnhancedPrintout"],
    FontFamily->"Frutiger",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsectionDingbat"],
    CellSize->{54, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCSubsectionDingbat", "EnhancedPrintout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitleCondensed"],
    CellMargins->{{20, 0}, {1, 8}},
    CellGroupingRules->{"SectionGrouping", 70},
    TabSpacings->50.4,
    CounterIncrements->"TOCTitleCondensed",
    CounterAssignments->{{"TOCSectionCondensed", 0}, {
        "TOCSubsectionCondensed", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["TOCTitleCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCTitleCondensed", "Printout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["TOCTitleCondensed", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSectionCondensed"],
    CellMargins->{{48, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 75},
    TabSpacings->47.4,
    CounterIncrements->"TOCSectionCondensed",
    CounterAssignments->{{"TOCSubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold",
    FontColor->GrayLevel[0.2]],
  
  Cell[StyleData["TOCSectionCondensed", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["TOCSectionCondensed", "Printout"],
    CellMargins->{{36, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["TOCSectionCondensed", "EnhancedPrintout"],
    CellMargins->{{36, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsectionCondensed"],
    PageWidth->470,
    CellMargins->{{76, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 80},
    TextJustification->1,
    FontSize->12],
  
  Cell[StyleData["TOCSubsectionCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsectionCondensed", "Printout"],
    CellMargins->{{72, 0}, {1, 1}},
    PageBreakBelow->False,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["TOCSubsectionCondensed", "EnhancedPrintout"],
    CellMargins->{{72, 0}, {1, 1}},
    PageBreakBelow->False,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsubsectionCondensed"],
    CellMargins->{{104, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 85},
    TabSpacings->39.3,
    CounterIncrements->"TOCSubsubsectionCondensed",
    FontSize->12],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "Printout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->9],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "EnhancedPrintout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TitlePageGraphic"],
    CellMargins->{{0, 0}, {100, 20}},
    Evaluatable->False,
    PageBreakBelow->False,
    TextAlignment->Center],
  
  Cell[StyleData["TitlePageGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TitlePageGraphic", "Printout"],
    CellMargins->{{0, 0}, {230, 88}}],
  
  Cell[StyleData["TitlePageGraphic", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {230, 88}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TitlePageLogo"],
    CellMargins->{{0, 0}, {0, 0}}],
  
  Cell[StyleData["TitlePageLogo", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TitlePageLogo", "Printout"]],
  
  Cell[StyleData["TitlePageLogo", "EnhancedPrintout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Horizontal Lines", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Line1"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-16, 9}},
    StyleMenuListing->None,
    FontSize->2],
  
  Cell[StyleData["Line1", "Presentation"],
    FontSize->3],
  
  Cell[StyleData["Line1", "Printout"],
    CellMargins->{{2, 0}, {-16, 9}}]
  }, Closed]],
  
  Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramTop"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 4}, {-18, 18}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramTop", "Presentation"],
    FontSize->6],
  
  Cell[StyleData["ProgramTop", "Printout"],
    CellMargins->{{2, 0}, {-18, 18}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramBottom"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{27, 4}, {-10, -2}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramBottom", "Presentation"],
    FontSize->6],
  
  Cell[StyleData["ProgramBottom", "Printout"],
    CellMargins->{{2, 0}, {-10, -2}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SessionLabel"],
    CellFrame->{{0.5, 0}, {0, 0.5}},
    CellMargins->{{27, 4}, {-4, 18}},
    LineSpacing->{1, 0},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SessionLabel", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SessionLabel", "Printout"],
    CellMargins->{{2, 0}, {-4, 18}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Page Headers and Footers", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeader"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageHeader", "Printout"]],
  
  Cell[StyleData["PageHeader", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["PageHeader", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Bold"],
  
  Cell[StyleData["PageNumber", "Printout"]],
  
  Cell[StyleData["PageNumber", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["PageNumber", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageFooter"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["PageFooter", "Printout"]],
  
  Cell[StyleData["PageFooter", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["PageFooter", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["For compatibility", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["Header", "Printout"]],
  
  Cell[StyleData["Header", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSlant->"Plain"],
  
  Cell[StyleData["Header", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Footer"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["Footer", "Printout"]],
  
  Cell[StyleData["Footer", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["Footer", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["CellExpression", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->10],
  
  Cell[StyleData["CellExpression", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InputForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["InputForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["OutputForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["StandardForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["NumberedGesture Styles", "Section"],
  
  Cell[StyleData["NumberedGestureHead"],
    CellDingbat->"\[EmptyDiamond]",
    CellMargins->{{36, 36}, {Inherited, Inherited}},
    CounterAssignments->{{"NumberedGesture", 0}}],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedGesture"],
    CellMargins->{{36, 36}, {Inherited, Inherited}},
    CounterIncrements->"NumberedGesture"],
  
  Cell[StyleData["NumberedGesture", "Presentation"],
    CellMargins->{{36, 36}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    ParagraphIndent->-15],
  
  Cell[StyleData["NumberedGesture", "Printout"],
    CellMargins->{{36, 36}, {Inherited, Inherited}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedGestureRemark"],
    CellMargins->{{54, 54}, {Inherited, Inherited}},
    CellFrameLabels->{{Cell[ 
            TextData[ {"  "}]], None}, {None, None}}],
  
  Cell[StyleData["NumberedGestureRemark", "Presentation"],
    CellMargins->{{54, 54}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["NumberedGestureRemark", "Printout"],
    CellMargins->{{54, 54}, {Inherited, Inherited}},
    FontSize->10]
  }, Closed]]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "WindowsIntroduction"->{
    Cell[1776, 53, 148, 5, 118, "Chapter",
      CellTags->"WindowsIntroduction"],
    Cell[1927, 60, 108, 4, 40, "CopyrightHead",
      CellTags->"WindowsIntroduction"],
    Cell[2038, 66, 158, 4, 22, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[2199, 72, 689, 22, 72, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[2891, 96, 556, 10, 80, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[3450, 108, 297, 8, 38, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[3772, 120, 73, 1, 36, "Subsection",
      CellTags->"WindowsIntroduction"],
    Cell[3870, 125, 82, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[3955, 128, 157, 4, 40, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[4115, 134, 453, 9, 74, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[4571, 145, 117, 2, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[4691, 149, 114, 1, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[4808, 152, 1334, 19, 248, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[6145, 173, 149, 4, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[6331, 182, 82, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[6416, 185, 636, 12, 98, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[7055, 199, 279, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[7337, 208, 791, 18, 98, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[8131, 228, 447, 11, 62, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[8581, 241, 1239, 22, 152, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[9823, 265, 276, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[10136, 277, 82, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[10221, 280, 100, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[10324, 283, 98, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[10425, 286, 85, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[10547, 292, 84, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[10634, 295, 85, 1, 34, "Subsubsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[10722, 298, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[10864, 303, 244, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[11111, 312, 133, 2, 34, "Subsubsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[11247, 316, 235, 7, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[11519, 328, 84, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[11606, 331, 85, 1, 34, "Subsubsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[11694, 334, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[11836, 339, 136, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[11975, 345, 111, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[12089, 348, 120, 2, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[12212, 352, 174, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[12389, 360, 214, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[12606, 368, 281, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[12890, 377, 750, 21, 80, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[13643, 400, 167, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[13813, 407, 272, 9, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[14088, 418, 130, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[14221, 424, 307, 10, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[14531, 436, 288, 9, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[14822, 447, 343, 10, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[15168, 459, 168, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[15339, 465, 195, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[15537, 473, 399, 11, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[15939, 486, 221, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[16163, 494, 392, 9, 62, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[16558, 505, 259, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[16820, 514, 941, 31, 98, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[17764, 547, 239, 8, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[18006, 557, 321, 12, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[18330, 571, 135, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[18468, 576, 436, 10, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[18907, 588, 317, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[19227, 597, 133, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[19363, 602, 348, 8, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[19714, 612, 221, 7, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[19938, 621, 179, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[20120, 629, 143, 5, 34, "Subsubsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[20266, 636, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[20408, 641, 183, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[20594, 647, 135, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[20732, 652, 223, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[20958, 660, 269, 6, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[21230, 668, 190, 4, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[21423, 674, 207, 5, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[21633, 681, 341, 10, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[21977, 693, 133, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[22113, 698, 110, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[22226, 701, 275, 6, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[22504, 709, 163, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[22670, 715, 145, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[22818, 721, 253, 5, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[23074, 728, 216, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[23293, 735, 348, 9, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[23644, 746, 130, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[23777, 751, 222, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[24002, 759, 253, 5, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[24258, 766, 200, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[24461, 773, 133, 2, 34, "Subsubsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[24597, 777, 235, 7, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[24835, 786, 189, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[25027, 793, 398, 11, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[25428, 806, 738, 19, 80, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[26169, 827, 272, 9, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[26444, 838, 160, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[26607, 844, 125, 2, 34, "Subsubsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[26735, 848, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[26877, 853, 356, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[27236, 862, 1424, 44, 151, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[28663, 908, 695, 20, 62, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[29361, 930, 333, 12, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[29697, 944, 168, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[29868, 950, 234, 8, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[30105, 960, 133, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[30241, 965, 194, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[30438, 972, 135, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[30576, 977, 176, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[30755, 983, 178, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[30936, 989, 217, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[31156, 996, 178, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[31337, 1002, 219, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[31559, 1009, 76, 1, 34, "Subsubsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[31638, 1012, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[31780, 1017, 100, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[31883, 1020, 261, 6, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[32147, 1028, 135, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[32285, 1033, 134, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[32422, 1039, 312, 6, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[32737, 1047, 362, 8, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[33102, 1057, 249, 5, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[33354, 1064, 215, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[33572, 1071, 269, 7, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[33844, 1080, 167, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[34014, 1088, 133, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[34150, 1093, 169, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[34322, 1100, 482, 15, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[34807, 1117, 277, 8, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[35087, 1127, 101, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[35191, 1130, 134, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[35328, 1136, 167, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[35498, 1144, 130, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[35631, 1149, 372, 10, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[36006, 1161, 227, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[36236, 1169, 211, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[36450, 1177, 140, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[36593, 1183, 169, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[36799, 1193, 107, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[36909, 1196, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[37051, 1201, 178, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[37232, 1207, 91, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[37326, 1210, 108, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[37437, 1213, 363, 10, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[37803, 1225, 139, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[37945, 1231, 189, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[38137, 1239, 197, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[38337, 1247, 335, 12, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[38675, 1261, 297, 10, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[38975, 1273, 232, 6, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[39210, 1281, 135, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[39348, 1286, 144, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[39529, 1295, 80, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[39612, 1298, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[39754, 1303, 85, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[39842, 1306, 288, 10, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[40133, 1318, 287, 7, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[40423, 1327, 167, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[40593, 1333, 194, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[40790, 1341, 171, 6, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[40964, 1349, 215, 8, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[41182, 1359, 270, 9, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[41455, 1370, 89, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[41547, 1373, 100, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[41650, 1376, 95, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[41748, 1379, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[41890, 1384, 525, 17, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[42418, 1403, 197, 5, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[42652, 1413, 80, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[42735, 1416, 139, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[42877, 1421, 1883, 47, 206, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[44763, 1470, 98, 1, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[44864, 1473, 238, 7, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[45105, 1482, 135, 3, 21, "Text",
      CellTags->"WindowsIntroduction"],
    Cell[45243, 1487, 283, 8, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[45529, 1497, 141, 4, 26, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[45673, 1503, 334, 7, 44, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[161766, 4925, 82, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[161851, 4928, 186, 4, 40, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[162040, 4934, 163, 4, 40, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[162240, 4943, 82, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[162325, 4946, 157, 4, 40, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[162485, 4952, 453, 9, 74, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[162941, 4963, 117, 2, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[163061, 4967, 114, 1, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[163178, 4970, 262, 5, 56, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[163443, 4977, 1334, 19, 248, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[164780, 4998, 149, 4, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[273138, 8380, 82, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[273223, 8383, 186, 4, 40, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[273412, 8389, 163, 4, 40, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[273612, 8398, 82, 1, 34, "Subsubsection",
      CellTags->"WindowsIntroduction"],
    Cell[273697, 8401, 157, 4, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[273857, 8407, 453, 9, 58, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[274313, 8418, 117, 2, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[274433, 8422, 117, 2, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[274553, 8426, 117, 2, 24, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[274673, 8430, 263, 5, 40, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[274939, 8437, 1334, 19, 184, "BulletedList",
      CellTags->"WindowsIntroduction"],
    Cell[276276, 8458, 149, 4, 24, "BulletedList",
      CellTags->"WindowsIntroduction"]},
  "WindowsOverview"->{
    Cell[46056, 1516, 58, 1, 38, "Section",
      CellTags->"WindowsOverview"],
    Cell[46117, 1519, 1082, 24, 136, "Text",
      CellTags->"WindowsOverview"],
    Cell[47202, 1545, 423, 9, 56, "Text",
      CellTags->"WindowsOverview"],
    Cell[47628, 1556, 383, 11, 40, "Text",
      CellTags->"WindowsOverview"],
    Cell[48014, 1569, 615, 15, 72, "Text",
      CellTags->"WindowsOverview"]},
  "WindowsCompilers"->{
    Cell[48666, 1589, 70, 1, 38, "Section",
      CellTags->"WindowsCompilers"],
    Cell[48739, 1592, 465, 11, 56, "Text",
      CellTags->"WindowsCompilers"],
    Cell[49207, 1605, 525, 9, 72, "Text",
      CellTags->"WindowsCompilers"],
    Cell[49757, 1618, 106, 1, 36, "Subsection",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[49866, 1621, 101, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[49970, 1624, 566, 16, 64, "SmallText",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50539, 1642, 98, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50640, 1645, 80, 1, 22, "SmallText",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50723, 1648, 121, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50847, 1651, 224, 4, 22, "SmallText",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[51074, 1657, 120, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[51231, 1663, 95, 1, 36, "Subsection",
      CellTags->{"languages", "WindowsCompilers"}],
    Cell[51329, 1666, 757, 14, 72, "Text",
      CellTags->{"languages", "WindowsCompilers"}]},
  "Microsoft"->{
    Cell[49757, 1618, 106, 1, 36, "Subsection",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[49866, 1621, 101, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[49970, 1624, 566, 16, 64, "SmallText",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50539, 1642, 98, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50640, 1645, 80, 1, 22, "SmallText",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50723, 1648, 121, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[50847, 1651, 224, 4, 22, "SmallText",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[51074, 1657, 120, 1, 24, "Text",
      CellTags->{"Microsoft", "WindowsCompilers"}],
    Cell[56953, 1842, 151, 1, 34, "Subsubsection",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[57107, 1845, 537, 11, 56, "Text",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[57647, 1858, 578, 11, 40, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58228, 1871, 270, 6, 22, "SmallText",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58501, 1879, 238, 6, 24, "NumberedGestureRemark",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58742, 1887, 446, 13, 46, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59191, 1902, 325, 7, 24, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59519, 1911, 359, 6, 40, "NumberedGestureRemark",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59915, 1922, 142, 1, 34, "Subsubsection",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[112334, 3435, 178, 6, 36, "Subsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[112537, 3445, 121, 1, 34, "Subsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[112661, 3448, 825, 15, 104, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113489, 3465, 150, 2, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113642, 3469, 115, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113760, 3472, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113955, 3480, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[114286, 3490, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[114561, 3499, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[114757, 3507, 472, 6, 130, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115232, 3515, 97, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115332, 3518, 196, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115531, 3526, 202, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115736, 3534, 116, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115855, 3537, 261, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116119, 3547, 214, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116336, 3555, 205, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116544, 3563, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116788, 3572, 314, 6, 56, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117105, 3580, 150, 2, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117258, 3584, 115, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117376, 3587, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117571, 3595, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117902, 3605, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118177, 3614, 194, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118374, 3622, 409, 5, 115, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118786, 3629, 97, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118886, 3632, 194, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119083, 3640, 202, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119288, 3648, 116, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119407, 3651, 261, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119671, 3661, 214, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119888, 3669, 205, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120096, 3677, 202, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120301, 3685, 119, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120423, 3688, 213, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120639, 3696, 111, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120753, 3699, 262, 9, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121018, 3710, 181, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121202, 3718, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121446, 3727, 371, 10, 40, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121820, 3739, 314, 6, 56, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122137, 3747, 162, 4, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122302, 3753, 120, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122425, 3756, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122620, 3764, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122951, 3774, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[123226, 3783, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[123422, 3791, 461, 6, 130, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[123886, 3799, 162, 4, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124051, 3805, 120, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124174, 3808, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124369, 3816, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124700, 3826, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124975, 3835, 194, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[125172, 3843, 393, 5, 100, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[125568, 3850, 108, 1, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[125679, 3853, 1601, 34, 311, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[127283, 3889, 106, 1, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[127392, 3892, 1168, 25, 235, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[128563, 3919, 100, 1, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[128666, 3922, 610, 14, 81, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[129279, 3938, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[129354, 3941, 802, 18, 139, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130159, 3961, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130234, 3964, 537, 13, 63, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130774, 3979, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130849, 3982, 619, 14, 101, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[131471, 3998, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[131546, 4001, 545, 13, 61, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[132128, 4019, 108, 1, 34, "Subsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[132239, 4022, 873, 14, 120, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133115, 4038, 150, 3, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133268, 4043, 121, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133392, 4046, 226, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133621, 4054, 661, 9, 370, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[134285, 4065, 398, 9, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[134686, 4076, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[134881, 4084, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135125, 4093, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135321, 4101, 258, 6, 55, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135582, 4109, 153, 4, 24, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135738, 4115, 874, 15, 88, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[136615, 4132, 433, 11, 56, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[137051, 4145, 1006, 23, 174, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138060, 4170, 150, 3, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138213, 4175, 121, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138337, 4178, 226, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138566, 4186, 492, 6, 250, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139061, 4194, 398, 9, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139462, 4205, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139657, 4213, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139901, 4222, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140097, 4230, 253, 6, 46, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140387, 4241, 145, 4, 34, "Subsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140535, 4247, 112, 2, 24, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140650, 4251, 209, 6, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140862, 4259, 1361, 35, 117, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[142226, 4296, 1573, 45, 115, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[143802, 4343, 268, 7, 54, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[144073, 4352, 996, 34, 113, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145072, 4388, 130, 2, 24, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145205, 4392, 174, 4, 22, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145382, 4398, 190, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145575, 4406, 180, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145758, 4414, 118, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145879, 4417, 323, 8, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[146205, 4427, 784, 25, 82, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[146992, 4454, 131, 2, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147126, 4458, 282, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147411, 4467, 262, 6, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147676, 4475, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147801, 4478, 255, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148059, 4487, 336, 9, 37, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148398, 4498, 117, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148518, 4501, 212, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148733, 4509, 286, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149022, 4518, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149147, 4521, 322, 9, 39, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149472, 4532, 255, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149730, 4541, 131, 2, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149864, 4545, 418, 9, 80, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[150285, 4556, 239, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[150527, 4565, 183, 5, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[150713, 4572, 357, 8, 52, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[151073, 4582, 558, 17, 54, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[151634, 4601, 173, 4, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[151810, 4607, 218, 5, 22, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152031, 4614, 190, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152224, 4622, 180, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152407, 4630, 118, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152528, 4633, 323, 8, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152854, 4643, 784, 25, 82, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[153641, 4670, 131, 2, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[153775, 4674, 282, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154060, 4683, 262, 6, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154325, 4691, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154450, 4694, 214, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154667, 4702, 285, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154955, 4711, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[155080, 4714, 321, 9, 39, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[155404, 4725, 183, 5, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[155590, 4732, 558, 17, 54, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}]},
  "languages"->{
    Cell[51231, 1663, 95, 1, 36, "Subsection",
      CellTags->{"languages", "WindowsCompilers"}],
    Cell[51329, 1666, 757, 14, 72, "Text",
      CellTags->{"languages", "WindowsCompilers"}]},
  "WindowsInstalling"->{
    Cell[52135, 1686, 149, 6, 38, "Section",
      CellTags->"WindowsInstalling"],
    Cell[52287, 1694, 387, 11, 40, "Text",
      CellTags->"WindowsInstalling"],
    Cell[52677, 1707, 1065, 31, 88, "Text",
      CellTags->"WindowsInstalling"],
    Cell[53745, 1740, 563, 14, 72, "Text",
      CellTags->"WindowsInstalling"],
    Cell[54311, 1756, 159, 4, 57, "FramedBox",
      CellTags->"WindowsInstalling"],
    Cell[54473, 1762, 298, 7, 40, "Text",
      CellTags->"WindowsInstalling"],
    Cell[54774, 1771, 169, 3, 42, "Input",
      CellTags->"WindowsInstalling"],
    Cell[54946, 1776, 77, 1, 24, "Text",
      CellTags->"WindowsInstalling"],
    Cell[55026, 1779, 199, 5, 22, "SmallText",
      CellTags->"WindowsInstalling"],
    Cell[55228, 1786, 141, 4, 24, "Text",
      CellTags->"WindowsInstalling"],
    Cell[55372, 1792, 182, 4, 42, "Input",
      CellTags->"WindowsInstalling"],
    Cell[55579, 1800, 109, 1, 36, "Subsection",
      CellTags->{"Recommended Installation", "WindowsInstalling"}],
    Cell[55713, 1805, 130, 1, 34, "Subsubsection",
      CellTags->{"Recommended Installation", "WindowsInstalling"}],
    Cell[55846, 1808, 1070, 29, 88, "Text",
      CellTags->{"Recommended Installation", "WindowsInstalling"}],
    Cell[56953, 1842, 151, 1, 34, "Subsubsection",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[57107, 1845, 537, 11, 56, "Text",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[57647, 1858, 578, 11, 40, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58228, 1871, 270, 6, 22, "SmallText",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58501, 1879, 238, 6, 24, "NumberedGestureRemark",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58742, 1887, 446, 13, 46, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59191, 1902, 325, 7, 24, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59519, 1911, 359, 6, 40, "NumberedGestureRemark",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59915, 1922, 142, 1, 34, "Subsubsection",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[60571, 1942, 150, 6, 36, "Subsection",
      CellTags->"WindowsInstalling"],
    Cell[60724, 1950, 319, 7, 40, "Text",
      CellTags->"WindowsInstalling"],
    Cell[61046, 1959, 583, 11, 72, "Text",
      CellTags->"WindowsInstalling"],
    Cell[61666, 1975, 76, 1, 36, "Subsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[61745, 1978, 419, 10, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[62189, 1992, 156, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[62348, 1998, 1334, 36, 88, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[63685, 2036, 163, 2, 23, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[63851, 2040, 1221, 29, 120, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65075, 2071, 163, 2, 23, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65241, 2075, 465, 11, 40, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65709, 2088, 166, 6, 34, "Subsubsubsection",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[65878, 2096, 608, 16, 56, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[66489, 2114, 467, 11, 56, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[66959, 2127, 343, 8, 40, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[67305, 2137, 531, 14, 69, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[67839, 2153, 146, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[67988, 2158, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68156, 2162, 522, 12, 56, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68681, 2176, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68805, 2179, 270, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69078, 2184, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69279, 2192, 199, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69481, 2197, 135, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69619, 2202, 163, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69785, 2206, 517, 12, 56, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70305, 2220, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70425, 2223, 260, 3, 70, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70688, 2228, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70885, 2236, 189, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[71077, 2241, 298, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[71378, 2250, 141, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71522, 2255, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71690, 2259, 401, 9, 40, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72094, 2270, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72218, 2273, 265, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72486, 2278, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72687, 2286, 194, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72884, 2291, 234, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[73121, 2299, 133, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73257, 2304, 161, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73421, 2308, 396, 9, 40, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73820, 2319, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73940, 2322, 258, 3, 55, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74201, 2327, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74398, 2335, 187, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74588, 2340, 296, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[75190, 2360, 157, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[75350, 2366, 165, 4, 34, "Subsubsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[75518, 2372, 156, 2, 23, "Text",
      CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
    Cell[75677, 2376, 719, 11, 88, "Text",
      CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
    Cell[76399, 2389, 149, 2, 34, "Subsubsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[76551, 2393, 521, 10, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77075, 2405, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77221, 2409, 509, 10, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77733, 2421, 205, 5, 24, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77941, 2428, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[78087, 2432, 561, 11, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[78651, 2445, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[78797, 2449, 538, 12, 56, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[79338, 2463, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[79484, 2467, 575, 12, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[80062, 2481, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[80208, 2485, 504, 12, 56, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[80715, 2499, 399, 8, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[81117, 2509, 358, 10, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[81478, 2521, 149, 2, 34, "Subsubsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[81630, 2525, 150, 2, 23, "Text",
      CellTags->{"mprep", "parts", "WindowsInstalling"}],
    Cell[81783, 2529, 477, 10, 40, "Text",
      CellTags->{"mprep", "parts", "WindowsInstalling"}],
    Cell[82297, 2544, 168, 4, 34, "Subsubsection",
      CellTags->{"prebuilt", "parts", "WindowsInstalling"}],
    Cell[82468, 2550, 944, 27, 56, "Text",
      CellTags->{"prebuilt", "parts", "WindowsInstalling"}],
    Cell[83449, 2582, 171, 4, 34, "Subsubsection",
      CellTags->{"parts", "sample code", "WindowsInstalling"}],
    Cell[83623, 2588, 387, 10, 40, "Text",
      CellTags->{"parts", "sample code", "WindowsInstalling"}],
    Cell[84047, 2603, 157, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84207, 2609, 158, 4, 24, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84402, 2618, 162, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84567, 2624, 322, 7, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84892, 2633, 146, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[85041, 2637, 412, 9, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}]},
  "Recommended Installation"->{
    Cell[55579, 1800, 109, 1, 36, "Subsection",
      CellTags->{"Recommended Installation", "WindowsInstalling"}],
    Cell[55713, 1805, 130, 1, 34, "Subsubsection",
      CellTags->{"Recommended Installation", "WindowsInstalling"}],
    Cell[55846, 1808, 1070, 29, 88, "Text",
      CellTags->{"Recommended Installation", "WindowsInstalling"}],
    Cell[56953, 1842, 151, 1, 34, "Subsubsection",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[57107, 1845, 537, 11, 56, "Text",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[57647, 1858, 578, 11, 40, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58228, 1871, 270, 6, 22, "SmallText",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58501, 1879, 238, 6, 24, "NumberedGestureRemark",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[58742, 1887, 446, 13, 46, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59191, 1902, 325, 7, 24, "NumberedGesture",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59519, 1911, 359, 6, 40, "NumberedGestureRemark",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}],
    Cell[59915, 1922, 142, 1, 34, "Subsubsection",
      CellTags->{
      "Recommended Installation", "Microsoft", "WindowsInstalling"}]},
  "parts"->{
    Cell[61666, 1975, 76, 1, 36, "Subsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[61745, 1978, 419, 10, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[62189, 1992, 156, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[62348, 1998, 1334, 36, 88, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[63685, 2036, 163, 2, 23, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[63851, 2040, 1221, 29, 120, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65075, 2071, 163, 2, 23, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65241, 2075, 465, 11, 40, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65709, 2088, 166, 6, 34, "Subsubsubsection",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[65878, 2096, 608, 16, 56, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[66489, 2114, 467, 11, 56, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[66959, 2127, 343, 8, 40, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[67305, 2137, 531, 14, 69, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[67839, 2153, 146, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[67988, 2158, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68156, 2162, 522, 12, 56, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68681, 2176, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68805, 2179, 270, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69078, 2184, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69279, 2192, 199, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69481, 2197, 135, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69619, 2202, 163, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69785, 2206, 517, 12, 56, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70305, 2220, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70425, 2223, 260, 3, 70, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70688, 2228, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70885, 2236, 189, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[71077, 2241, 298, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[71378, 2250, 141, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71522, 2255, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71690, 2259, 401, 9, 40, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72094, 2270, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72218, 2273, 265, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72486, 2278, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72687, 2286, 194, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72884, 2291, 234, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[73121, 2299, 133, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73257, 2304, 161, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73421, 2308, 396, 9, 40, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73820, 2319, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73940, 2322, 258, 3, 55, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74201, 2327, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74398, 2335, 187, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74588, 2340, 296, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[75190, 2360, 157, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[75350, 2366, 165, 4, 34, "Subsubsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[75518, 2372, 156, 2, 23, "Text",
      CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
    Cell[75677, 2376, 719, 11, 88, "Text",
      CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
    Cell[76399, 2389, 149, 2, 34, "Subsubsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[76551, 2393, 521, 10, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77075, 2405, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77221, 2409, 509, 10, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77733, 2421, 205, 5, 24, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[77941, 2428, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[78087, 2432, 561, 11, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[78651, 2445, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[78797, 2449, 538, 12, 56, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[79338, 2463, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[79484, 2467, 575, 12, 72, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[80062, 2481, 143, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[80208, 2485, 504, 12, 56, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[80715, 2499, 399, 8, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[81117, 2509, 358, 10, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[81478, 2521, 149, 2, 34, "Subsubsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[81630, 2525, 150, 2, 23, "Text",
      CellTags->{"mprep", "parts", "WindowsInstalling"}],
    Cell[81783, 2529, 477, 10, 40, "Text",
      CellTags->{"mprep", "parts", "WindowsInstalling"}],
    Cell[82297, 2544, 168, 4, 34, "Subsubsection",
      CellTags->{"prebuilt", "parts", "WindowsInstalling"}],
    Cell[82468, 2550, 944, 27, 56, "Text",
      CellTags->{"prebuilt", "parts", "WindowsInstalling"}],
    Cell[83449, 2582, 171, 4, 34, "Subsubsection",
      CellTags->{"parts", "sample code", "WindowsInstalling"}],
    Cell[83623, 2588, 387, 10, 40, "Text",
      CellTags->{"parts", "sample code", "WindowsInstalling"}],
    Cell[84047, 2603, 157, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84207, 2609, 158, 4, 24, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84402, 2618, 162, 4, 34, "Subsubsection",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84567, 2624, 322, 7, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[84892, 2633, 146, 2, 23, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[85041, 2637, 412, 9, 40, "Text",
      CellTags->{"parts", "WindowsInstalling"}],
    Cell[204872, 6379, 72, 1, 36, "Subsection",
      CellTags->{"parts", "MacInstalling"}],
    Cell[204947, 6382, 215, 6, 24, "Text",
      CellTags->{"parts", "MacInstalling"}],
    Cell[205187, 6392, 141, 2, 34, "Subsubsection",
      CellTags->{"parts", "MacInstalling"}],
    Cell[205331, 6396, 119, 2, 24, "Text",
      CellTags->{"parts", "mathlink.h", "MacInstalling"}],
    Cell[205453, 6400, 563, 10, 56, "Text",
      CellTags->{"parts", "mathlink.h", "MacInstalling"}],
    Cell[206019, 6412, 123, 2, 24, "Text",
      CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
    Cell[206145, 6416, 522, 12, 56, "Text",
      CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
    Cell[206670, 6430, 109, 2, 24, "Text",
      CellTags->{"parts", "mprep", "MacInstalling"}],
    Cell[206782, 6434, 443, 10, 40, "Text",
      CellTags->{"parts", "mprep", "MacInstalling"}],
    Cell[207228, 6446, 105, 2, 24, "Text",
      CellTags->{"parts", "mcc", "MacInstalling"}],
    Cell[207336, 6450, 249, 7, 24, "Text",
      CellTags->{"parts", "mcc", "MacInstalling"}],
    Cell[207622, 6462, 140, 2, 34, "Subsubsection",
      CellTags->{"parts", "MacInstalling"}],
    Cell[207765, 6466, 371, 10, 40, "Text",
      CellTags->{"parts", "MacInstalling"}],
    Cell[208173, 6481, 152, 2, 34, "Subsubsection",
      CellTags->{"parts", "prebuilt", "MacInstalling"}],
    Cell[208328, 6485, 947, 27, 56, "Text",
      CellTags->{"parts", "prebuilt", "MacInstalling"}],
    Cell[316583, 9842, 73, 1, 36, "Subsection",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[316659, 9845, 216, 6, 24, "Text",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[316900, 9855, 142, 2, 34, "Subsubsection",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[317045, 9859, 120, 2, 24, "Text",
      CellTags->{"parts", "mathlink.h", "UnixInstalling"}],
    Cell[317168, 9863, 574, 11, 52, "Text",
      CellTags->{"parts", "mathlink.h", "UnixInstalling"}],
    Cell[317745, 9876, 124, 2, 24, "Text",
      CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],
    Cell[317872, 9880, 472, 11, 54, "Text",
      CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],
    Cell[318347, 9893, 110, 2, 24, "Text",
      CellTags->{"parts", "mprep", "UnixInstalling"}],
    Cell[318460, 9897, 444, 10, 38, "Text",
      CellTags->{"parts", "mprep", "UnixInstalling"}],
    Cell[318907, 9909, 106, 2, 24, "Text",
      CellTags->{"parts", "mcc", "UnixInstalling"}],
    Cell[319016, 9913, 250, 7, 24, "Text",
      CellTags->{"parts", "mcc", "UnixInstalling"}],
    Cell[319303, 9925, 141, 2, 34, "Subsubsection",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[319447, 9929, 372, 10, 40, "Text",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[319856, 9944, 150, 2, 34, "Subsubsection",
      CellTags->{"parts", "prebuilt", "UnixInstalling"}],
    Cell[320009, 9948, 942, 27, 56, "Text",
      CellTags->{"parts", "prebuilt", "UnixInstalling"}]},
  "MathLinkLibraries"->{
    Cell[63685, 2036, 163, 2, 23, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[63851, 2040, 1221, 29, 120, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65075, 2071, 163, 2, 23, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[65241, 2075, 465, 11, 40, "Text",
      CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
    Cell[206019, 6412, 123, 2, 24, "Text",
      CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
    Cell[206145, 6416, 522, 12, 56, "Text",
      CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
    Cell[317745, 9876, 124, 2, 24, "Text",
      CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],
    Cell[317872, 9880, 472, 11, 54, "Text",
      CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}]},
  "devices"->{
    Cell[65709, 2088, 166, 6, 34, "Subsubsubsection",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[65878, 2096, 608, 16, 56, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[66489, 2114, 467, 11, 56, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[66959, 2127, 343, 8, 40, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[67305, 2137, 531, 14, 69, "Text",
      CellTags->{"devices", "parts", "WindowsInstalling"}],
    Cell[67839, 2153, 146, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[67988, 2158, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68156, 2162, 522, 12, 56, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68681, 2176, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68805, 2179, 270, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69078, 2184, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69279, 2192, 199, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69481, 2197, 135, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69619, 2202, 163, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69785, 2206, 517, 12, 56, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70305, 2220, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70425, 2223, 260, 3, 70, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70688, 2228, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70885, 2236, 189, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[71077, 2241, 298, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[71378, 2250, 141, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71522, 2255, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71690, 2259, 401, 9, 40, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72094, 2270, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72218, 2273, 265, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72486, 2278, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72687, 2286, 194, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72884, 2291, 234, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[73121, 2299, 133, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73257, 2304, 161, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73421, 2308, 396, 9, 40, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73820, 2319, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73940, 2322, 258, 3, 55, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74201, 2327, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74398, 2335, 187, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74588, 2340, 296, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}]},
  "FileMap"->{
    Cell[67839, 2153, 146, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[67988, 2158, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68156, 2162, 522, 12, 56, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68681, 2176, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[68805, 2179, 270, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69078, 2184, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[69279, 2192, 199, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71378, 2250, 141, 3, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71522, 2255, 165, 2, 23, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[71690, 2259, 401, 9, 40, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72094, 2270, 121, 1, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72218, 2273, 265, 3, 70, "FramedBox",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72486, 2278, 198, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72687, 2286, 194, 3, 26, "Input",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
    Cell[72884, 2291, 234, 6, 24, "Text",
      CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}]},
  "TCP"->{
    Cell[69481, 2197, 135, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69619, 2202, 163, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[69785, 2206, 517, 12, 56, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70305, 2220, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70425, 2223, 260, 3, 70, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70688, 2228, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[70885, 2236, 189, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[71077, 2241, 298, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73121, 2299, 133, 3, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73257, 2304, 161, 2, 23, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73421, 2308, 396, 9, 40, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73820, 2319, 117, 1, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[73940, 2322, 258, 3, 55, "FramedBox",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74201, 2327, 194, 6, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74398, 2335, 187, 3, 26, "Input",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
    Cell[74588, 2340, 296, 7, 24, "Text",
      CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}]},
  "mathlink.h"->{
    Cell[75518, 2372, 156, 2, 23, "Text",
      CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
    Cell[75677, 2376, 719, 11, 88, "Text",
      CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
    Cell[205331, 6396, 119, 2, 24, "Text",
      CellTags->{"parts", "mathlink.h", "MacInstalling"}],
    Cell[205453, 6400, 563, 10, 56, "Text",
      CellTags->{"parts", "mathlink.h", "MacInstalling"}],
    Cell[317045, 9859, 120, 2, 24, "Text",
      CellTags->{"parts", "mathlink.h", "UnixInstalling"}],
    Cell[317168, 9863, 574, 11, 52, "Text",
      CellTags->{"parts", "mathlink.h", "UnixInstalling"}]},
  "mprep"->{
    Cell[81630, 2525, 150, 2, 23, "Text",
      CellTags->{"mprep", "parts", "WindowsInstalling"}],
    Cell[81783, 2529, 477, 10, 40, "Text",
      CellTags->{"mprep", "parts", "WindowsInstalling"}],
    Cell[110272, 3383, 124, 2, 36, "Subsection",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[110399, 3387, 1036, 22, 104, "Text",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[111438, 3411, 83, 1, 24, "Text",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[111524, 3414, 120, 1, 40, "FramedBox",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[111647, 3417, 495, 9, 56, "Text",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[112145, 3428, 152, 2, 55, "FramedBox",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[206670, 6430, 109, 2, 24, "Text",
      CellTags->{"parts", "mprep", "MacInstalling"}],
    Cell[206782, 6434, 443, 10, 40, "Text",
      CellTags->{"parts", "mprep", "MacInstalling"}],
    Cell[210294, 6548, 120, 2, 41, "Subsection",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[210417, 6552, 1013, 22, 120, "Text",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[211433, 6576, 78, 1, 24, "Text",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[211514, 6579, 114, 1, 40, "FramedBox",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[211631, 6582, 499, 9, 56, "Text",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[212133, 6593, 148, 2, 55, "FramedBox",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[318347, 9893, 110, 2, 24, "Text",
      CellTags->{"parts", "mprep", "UnixInstalling"}],
    Cell[318460, 9897, 444, 10, 38, "Text",
      CellTags->{"parts", "mprep", "UnixInstalling"}],
    Cell[321972, 10011, 121, 2, 36, "Subsection",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[322096, 10015, 1030, 22, 98, "Text",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323129, 10039, 79, 1, 22, "Text",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323211, 10042, 117, 1, 40, "FramedBox",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323331, 10045, 492, 9, 50, "Text",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323826, 10056, 149, 2, 55, "FramedBox",
      CellTags->{"mprep", "UnixBuilding"}]},
  "prebuilt"->{
    Cell[82297, 2544, 168, 4, 34, "Subsubsection",
      CellTags->{"prebuilt", "parts", "WindowsInstalling"}],
    Cell[82468, 2550, 944, 27, 56, "Text",
      CellTags->{"prebuilt", "parts", "WindowsInstalling"}],
    Cell[208173, 6481, 152, 2, 34, "Subsubsection",
      CellTags->{"parts", "prebuilt", "MacInstalling"}],
    Cell[208328, 6485, 947, 27, 56, "Text",
      CellTags->{"parts", "prebuilt", "MacInstalling"}],
    Cell[319856, 9944, 150, 2, 34, "Subsubsection",
      CellTags->{"parts", "prebuilt", "UnixInstalling"}],
    Cell[320009, 9948, 942, 27, 56, "Text",
      CellTags->{"parts", "prebuilt", "UnixInstalling"}]},
  "sample code"->{
    Cell[83449, 2582, 171, 4, 34, "Subsubsection",
      CellTags->{"parts", "sample code", "WindowsInstalling"}],
    Cell[83623, 2588, 387, 10, 40, "Text",
      CellTags->{"parts", "sample code", "WindowsInstalling"}]},
  "WindowsRunning"->{
    Cell[85514, 2653, 137, 6, 38, "Section",
      CellTags->"WindowsRunning"],
    Cell[85654, 2661, 828, 17, 93, "Text",
      CellTags->"WindowsRunning"],
    Cell[86485, 2680, 282, 7, 42, "Text",
      CellTags->"WindowsRunning"],
    Cell[86770, 2689, 1330, 25, 161, "Text",
      CellTags->"WindowsRunning"],
    Cell[88125, 2718, 127, 2, 39, "Subsection",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[88255, 2722, 1094, 31, 93, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[89352, 2755, 832, 11, 518, "FramedBox",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90187, 2768, 327, 7, 42, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90517, 2777, 113, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90633, 2781, 144, 4, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90780, 2787, 93, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90876, 2791, 263, 7, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91142, 2800, 86, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91231, 2804, 69, 1, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91303, 2807, 89, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91395, 2811, 204, 5, 42, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91602, 2818, 114, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91719, 2822, 187, 5, 31, "Caption",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91909, 2829, 124, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92036, 2833, 119, 1, 17, "Caption",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92158, 2836, 146, 3, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92307, 2841, 113, 1, 17, "Caption",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92423, 2844, 429, 13, 42, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92855, 2859, 84, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92942, 2863, 116, 1, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[93061, 2866, 90, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[93188, 2873, 127, 2, 39, "Subsection",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[93318, 2877, 547, 13, 59, "Text",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[93868, 2892, 819, 21, 77, "Text",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[94690, 2915, 110, 1, 25, "NumberedGestureHead",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[94803, 2918, 188, 6, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[94994, 2926, 247, 7, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95244, 2935, 185, 6, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95432, 2943, 107, 1, 42, "FramedBox",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95542, 2946, 136, 2, 25, "NumberedGestureRemark",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95681, 2950, 176, 6, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95860, 2958, 158, 4, 25, "NumberedGestureRemark",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96021, 2964, 362, 10, 46, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96386, 2976, 117, 1, 42, "FramedBox",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96506, 2979, 332, 10, 25, "NumberedGestureRemark",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96841, 2991, 363, 12, 93, "FramedBox",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[97241, 3008, 91, 1, 39, "Subsection",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[97335, 3011, 897, 22, 72, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[98235, 3035, 796, 17, 72, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99034, 3054, 338, 8, 40, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99375, 3064, 167, 4, 26, "Input",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99545, 3070, 254, 6, 24, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99802, 3078, 133, 3, 26, "Input",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99938, 3083, 136, 2, 24, "Text",
      CellTags->{"protocols", "WindowsRunning"}]},
  "addtwo"->{
    Cell[88125, 2718, 127, 2, 39, "Subsection",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[88255, 2722, 1094, 31, 93, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[89352, 2755, 832, 11, 518, "FramedBox",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90187, 2768, 327, 7, 42, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90517, 2777, 113, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90633, 2781, 144, 4, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90780, 2787, 93, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[90876, 2791, 263, 7, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91142, 2800, 86, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91231, 2804, 69, 1, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91303, 2807, 89, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91395, 2811, 204, 5, 42, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91602, 2818, 114, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91719, 2822, 187, 5, 31, "Caption",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[91909, 2829, 124, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92036, 2833, 119, 1, 17, "Caption",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92158, 2836, 146, 3, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92307, 2841, 113, 1, 17, "Caption",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92423, 2844, 429, 13, 42, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92855, 2859, 84, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[92942, 2863, 116, 1, 25, "Text",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[93061, 2866, 90, 2, 29, "Input",
      CellTags->{"addtwo", "WindowsRunning"}],
    Cell[234417, 7262, 123, 2, 41, "Subsection",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[234543, 7266, 1090, 31, 104, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[235636, 7299, 489, 6, 325, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236128, 7307, 128, 4, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236259, 7313, 115, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236377, 7317, 127, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236507, 7321, 140, 4, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236650, 7327, 89, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236742, 7331, 257, 7, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237002, 7340, 82, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237087, 7344, 65, 1, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237155, 7347, 85, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237243, 7351, 200, 5, 40, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237446, 7358, 110, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237559, 7362, 200, 3, 55, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237762, 7367, 120, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237885, 7371, 139, 2, 40, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238027, 7375, 142, 3, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238172, 7380, 133, 2, 40, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238308, 7384, 425, 13, 40, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238736, 7399, 80, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238819, 7403, 113, 1, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238935, 7406, 86, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[332357, 10271, 124, 2, 36, "Subsection",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[332484, 10275, 1091, 31, 86, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[333578, 10308, 490, 6, 325, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334071, 10316, 129, 4, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334203, 10322, 116, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334322, 10326, 128, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334453, 10330, 141, 4, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334597, 10336, 90, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334690, 10340, 258, 7, 23, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334951, 10349, 83, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335037, 10353, 66, 1, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335106, 10356, 86, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335195, 10360, 201, 5, 36, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335399, 10367, 111, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335513, 10371, 207, 3, 55, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335723, 10376, 121, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335847, 10380, 146, 2, 40, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335996, 10384, 143, 3, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336142, 10389, 140, 2, 40, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336285, 10393, 426, 13, 38, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336714, 10408, 81, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336798, 10412, 114, 1, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336915, 10415, 87, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}]},
  "factor"->{
    Cell[93188, 2873, 127, 2, 39, "Subsection",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[93318, 2877, 547, 13, 59, "Text",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[93868, 2892, 819, 21, 77, "Text",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[94690, 2915, 110, 1, 25, "NumberedGestureHead",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[94803, 2918, 188, 6, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[94994, 2926, 247, 7, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95244, 2935, 185, 6, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95432, 2943, 107, 1, 42, "FramedBox",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95542, 2946, 136, 2, 25, "NumberedGestureRemark",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95681, 2950, 176, 6, 25, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[95860, 2958, 158, 4, 25, "NumberedGestureRemark",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96021, 2964, 362, 10, 46, "NumberedGesture",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96386, 2976, 117, 1, 42, "FramedBox",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96506, 2979, 332, 10, 25, "NumberedGestureRemark",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[96841, 2991, 363, 12, 93, "FramedBox",
      CellTags->{"factor", "WindowsRunning"}],
    Cell[239058, 7413, 123, 2, 41, "Subsection",
      CellTags->{"factor", "MacRunning"}],
    Cell[239184, 7417, 544, 13, 56, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[239731, 7432, 176, 4, 24, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[239910, 7438, 137, 2, 40, "FramedBox",
      CellTags->{"factor", "MacRunning"}],
    Cell[240050, 7442, 301, 6, 56, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[240354, 7450, 103, 1, 40, "FramedBox",
      CellTags->{"factor", "MacRunning"}],
    Cell[240460, 7453, 312, 10, 24, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[240775, 7465, 142, 2, 85, "FramedBox",
      CellTags->{"factor", "MacRunning"}],
    Cell[337039, 10422, 124, 2, 36, "Subsection",
      CellTags->{"factor", "UnixRunning"}],
    Cell[337166, 10426, 544, 13, 56, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[337713, 10441, 177, 4, 24, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[337893, 10447, 138, 2, 40, "FramedBox",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338034, 10451, 302, 6, 56, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338339, 10459, 104, 1, 40, "FramedBox",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338446, 10462, 312, 10, 24, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338761, 10474, 143, 2, 85, "FramedBox",
      CellTags->{"factor", "UnixRunning"}]},
  "protocols"->{
    Cell[97241, 3008, 91, 1, 39, "Subsection",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[97335, 3011, 897, 22, 72, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[98235, 3035, 796, 17, 72, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99034, 3054, 338, 8, 40, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99375, 3064, 167, 4, 26, "Input",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99545, 3070, 254, 6, 24, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99802, 3078, 133, 3, 26, "Input",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[99938, 3083, 136, 2, 24, "Text",
      CellTags->{"protocols", "WindowsRunning"}],
    Cell[240954, 7472, 87, 1, 41, "Subsection",
      CellTags->{"protocols", "MacRunning"}],
    Cell[241044, 7475, 886, 21, 104, "Text",
      CellTags->{"protocols", "MacRunning"}],
    Cell[241933, 7498, 389, 11, 40, "Text",
      CellTags->{"protocols", "MacRunning"}],
    Cell[338941, 10481, 88, 1, 36, "Subsection",
      CellTags->{"protocols", "UnixRunning"}],
    Cell[339032, 10484, 877, 21, 104, "Text",
      CellTags->{"protocols", "UnixRunning"}],
    Cell[339912, 10507, 391, 11, 40, "Text",
      CellTags->{"protocols", "UnixRunning"}]},
  "WindowsBuilding"->{
    Cell[100123, 3091, 139, 6, 38, "Section",
      CellTags->"WindowsBuilding"],
    Cell[100265, 3099, 885, 20, 100, "Text",
      CellTags->"WindowsBuilding"],
    Cell[101153, 3121, 575, 13, 82, "Text",
      CellTags->"WindowsBuilding"],
    Cell[101753, 3138, 151, 5, 36, "Subsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[101907, 3145, 443, 11, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[102375, 3160, 80, 1, 34, "Subsubsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[102458, 3163, 474, 13, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[102935, 3178, 442, 11, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[103380, 3191, 772, 16, 104, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[104155, 3209, 438, 12, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[104596, 3223, 89, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[104688, 3226, 384, 10, 43, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105075, 3238, 90, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105168, 3241, 388, 10, 43, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105559, 3253, 89, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105651, 3256, 463, 12, 61, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[106117, 3270, 90, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[106210, 3273, 593, 14, 81, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[106806, 3289, 235, 5, 40, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[107044, 3296, 629, 13, 88, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[107710, 3314, 97, 1, 34, "Subsubsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[107810, 3317, 769, 17, 88, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[108582, 3336, 583, 11, 72, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[109202, 3352, 97, 1, 34, "Subsubsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[109302, 3355, 921, 22, 104, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[110272, 3383, 124, 2, 36, "Subsection",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[110399, 3387, 1036, 22, 104, "Text",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[111438, 3411, 83, 1, 24, "Text",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[111524, 3414, 120, 1, 40, "FramedBox",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[111647, 3417, 495, 9, 56, "Text",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[112145, 3428, 152, 2, 55, "FramedBox",
      CellTags->{"mprep", "WindowsBuilding"}],
    Cell[112334, 3435, 178, 6, 36, "Subsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[112537, 3445, 121, 1, 34, "Subsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[112661, 3448, 825, 15, 104, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113489, 3465, 150, 2, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113642, 3469, 115, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113760, 3472, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[113955, 3480, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[114286, 3490, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[114561, 3499, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[114757, 3507, 472, 6, 130, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115232, 3515, 97, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115332, 3518, 196, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115531, 3526, 202, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115736, 3534, 116, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[115855, 3537, 261, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116119, 3547, 214, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116336, 3555, 205, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116544, 3563, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[116788, 3572, 314, 6, 56, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117105, 3580, 150, 2, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117258, 3584, 115, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117376, 3587, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117571, 3595, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[117902, 3605, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118177, 3614, 194, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118374, 3622, 409, 5, 115, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118786, 3629, 97, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[118886, 3632, 194, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119083, 3640, 202, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119288, 3648, 116, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119407, 3651, 261, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119671, 3661, 214, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[119888, 3669, 205, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120096, 3677, 202, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120301, 3685, 119, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120423, 3688, 213, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120639, 3696, 111, 1, 24, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[120753, 3699, 262, 9, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121018, 3710, 181, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121202, 3718, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121446, 3727, 371, 10, 40, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[121820, 3739, 314, 6, 56, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122137, 3747, 162, 4, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122302, 3753, 120, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122425, 3756, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122620, 3764, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[122951, 3774, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[123226, 3783, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[123422, 3791, 461, 6, 130, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[123886, 3799, 162, 4, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124051, 3805, 120, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124174, 3808, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124369, 3816, 328, 8, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124700, 3826, 272, 7, 71, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[124975, 3835, 194, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[125172, 3843, 393, 5, 100, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[125568, 3850, 108, 1, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[125679, 3853, 1601, 34, 311, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[127283, 3889, 106, 1, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[127392, 3892, 1168, 25, 235, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[128563, 3919, 100, 1, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[128666, 3922, 610, 14, 81, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[129279, 3938, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[129354, 3941, 802, 18, 139, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130159, 3961, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130234, 3964, 537, 13, 63, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130774, 3979, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[130849, 3982, 619, 14, 101, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[131471, 3998, 72, 1, 26, "Input",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[131546, 4001, 545, 13, 61, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[132128, 4019, 108, 1, 34, "Subsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[132239, 4022, 873, 14, 120, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133115, 4038, 150, 3, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133268, 4043, 121, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133392, 4046, 226, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[133621, 4054, 661, 9, 370, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[134285, 4065, 398, 9, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[134686, 4076, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[134881, 4084, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135125, 4093, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135321, 4101, 258, 6, 55, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135582, 4109, 153, 4, 24, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[135738, 4115, 874, 15, 88, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[136615, 4132, 433, 11, 56, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[137051, 4145, 1006, 23, 174, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138060, 4170, 150, 3, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138213, 4175, 121, 1, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138337, 4178, 226, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[138566, 4186, 492, 6, 250, "FramedBox",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139061, 4194, 398, 9, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139462, 4205, 192, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139657, 4213, 241, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[139901, 4222, 193, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140097, 4230, 253, 6, 46, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140387, 4241, 145, 4, 34, "Subsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140535, 4247, 112, 2, 24, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140650, 4251, 209, 6, 24, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[140862, 4259, 1361, 35, 117, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[142226, 4296, 1573, 45, 115, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[143802, 4343, 268, 7, 54, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[144073, 4352, 996, 34, 113, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145072, 4388, 130, 2, 24, "Text",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145205, 4392, 174, 4, 22, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145382, 4398, 190, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145575, 4406, 180, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145758, 4414, 118, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[145879, 4417, 323, 8, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[146205, 4427, 784, 25, 82, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[146992, 4454, 131, 2, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147126, 4458, 282, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147411, 4467, 262, 6, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147676, 4475, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[147801, 4478, 255, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148059, 4487, 336, 9, 37, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148398, 4498, 117, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148518, 4501, 212, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[148733, 4509, 286, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149022, 4518, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149147, 4521, 322, 9, 39, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149472, 4532, 255, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149730, 4541, 131, 2, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[149864, 4545, 418, 9, 80, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[150285, 4556, 239, 7, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[150527, 4565, 183, 5, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[150713, 4572, 357, 8, 52, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[151073, 4582, 558, 17, 54, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[151634, 4601, 173, 4, 34, "Subsubsubsection",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[151810, 4607, 218, 5, 22, "NumberedGestureHead",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152031, 4614, 190, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152224, 4622, 180, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152407, 4630, 118, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152528, 4633, 323, 8, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[152854, 4643, 784, 25, 82, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[153641, 4670, 131, 2, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[153775, 4674, 282, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154060, 4683, 262, 6, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154325, 4691, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154450, 4694, 214, 6, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154667, 4702, 285, 7, 38, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[154955, 4711, 122, 1, 22, "NumberedGestureRemark",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[155080, 4714, 321, 9, 39, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[155404, 4725, 183, 5, 24, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}],
    Cell[155590, 4732, 558, 17, 54, "NumberedGesture",
      CellTags->{"Microsoft", "WindowsBuilding"}]},
  "Versioning"->{
    Cell[101753, 3138, 151, 5, 36, "Subsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[101907, 3145, 443, 11, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[102375, 3160, 80, 1, 34, "Subsubsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[102458, 3163, 474, 13, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[102935, 3178, 442, 11, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[103380, 3191, 772, 16, 104, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[104155, 3209, 438, 12, 56, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[104596, 3223, 89, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[104688, 3226, 384, 10, 43, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105075, 3238, 90, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105168, 3241, 388, 10, 43, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105559, 3253, 89, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[105651, 3256, 463, 12, 61, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[106117, 3270, 90, 1, 26, "BulletedList",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[106210, 3273, 593, 14, 81, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[106806, 3289, 235, 5, 40, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[107044, 3296, 629, 13, 88, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[107710, 3314, 97, 1, 34, "Subsubsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[107810, 3317, 769, 17, 88, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[108582, 3336, 583, 11, 72, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[109202, 3352, 97, 1, 34, "Subsubsection",
      CellTags->{"Versioning", "WindowsBuilding"}],
    Cell[109302, 3355, 921, 22, 104, "Text",
      CellTags->{"Versioning", "WindowsBuilding"}]},
  "WindowsTroubleshooting"->{
    Cell[156209, 4756, 72, 1, 38, "Section",
      CellTags->"WindowsTroubleshooting"],
    Cell[156284, 4759, 292, 7, 42, "BulletedList",
      CellTags->"WindowsTroubleshooting"],
    Cell[156579, 4768, 435, 11, 76, "BulletedList",
      CellTags->"WindowsTroubleshooting"],
    Cell[157017, 4781, 645, 10, 120, "BulletedList",
      CellTags->"WindowsTroubleshooting"],
    Cell[157665, 4793, 236, 5, 40, "BulletedList",
      CellTags->"WindowsTroubleshooting"],
    Cell[157904, 4800, 652, 17, 94, "BulletedList",
      CellTags->"WindowsTroubleshooting"],
    Cell[158559, 4819, 300, 6, 56, "BulletedList",
      CellTags->"WindowsTroubleshooting"],
    Cell[158862, 4827, 583, 14, 76, "BulletedList",
      CellTags->"WindowsTroubleshooting"],
    Cell[159448, 4843, 399, 8, 57, "BulletedList",
      CellTags->"WindowsTroubleshooting"]},
  "MacIntroduction"->{
    Cell[159896, 4857, 145, 5, 82, "Chapter",
      CellTags->"MacIntroduction"],
    Cell[160044, 4864, 104, 4, 40, "CopyrightHead",
      CellTags->"MacIntroduction"],
    Cell[160151, 4870, 154, 4, 22, "Text",
      CellTags->"MacIntroduction"],
    Cell[160308, 4876, 523, 18, 56, "Text",
      CellTags->"MacIntroduction"],
    Cell[160834, 4896, 386, 8, 52, "Text",
      CellTags->"MacIntroduction"],
    Cell[161223, 4906, 424, 10, 66, "Text",
      CellTags->"MacIntroduction"],
    Cell[161672, 4920, 69, 1, 36, "Subsection",
      CellTags->"MacIntroduction"],
    Cell[164966, 5007, 78, 1, 34, "Subsubsection",
      CellTags->"MacIntroduction"],
    Cell[165047, 5010, 632, 12, 98, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[165682, 5024, 787, 18, 98, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[166472, 5044, 442, 11, 62, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[166917, 5057, 589, 15, 80, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[167509, 5074, 396, 8, 62, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[167908, 5084, 272, 7, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[168217, 5096, 78, 1, 34, "Subsubsection",
      CellTags->"MacIntroduction"],
    Cell[168298, 5099, 94, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[168395, 5102, 81, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[168513, 5108, 80, 1, 34, "Subsubsection",
      CellTags->"MacIntroduction"],
    Cell[168596, 5111, 81, 1, 34, "Subsubsubsection",
      CellTags->"MacIntroduction"],
    Cell[168680, 5114, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[168818, 5119, 132, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[168953, 5125, 107, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[169063, 5128, 116, 2, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[169182, 5132, 170, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[169355, 5140, 210, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[169568, 5148, 277, 7, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[169848, 5157, 746, 21, 80, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[170597, 5180, 163, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[170763, 5187, 268, 9, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[171034, 5198, 126, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[171163, 5204, 303, 10, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[171469, 5216, 284, 9, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[171756, 5227, 339, 10, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[172098, 5239, 164, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[172265, 5245, 191, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[172459, 5253, 395, 11, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[172857, 5266, 217, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[173077, 5274, 388, 9, 62, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[173468, 5285, 255, 7, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[173726, 5294, 937, 31, 98, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[174666, 5327, 235, 8, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[174904, 5337, 317, 12, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[175224, 5351, 131, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[175358, 5356, 432, 10, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[175793, 5368, 313, 7, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[176109, 5377, 129, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[176241, 5382, 344, 8, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[176588, 5392, 225, 7, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[176816, 5401, 175, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[176994, 5409, 139, 5, 34, "Subsubsubsection",
      CellTags->"MacIntroduction"],
    Cell[177136, 5416, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[177274, 5421, 179, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[177456, 5427, 131, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[177590, 5432, 219, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[177812, 5440, 265, 6, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[178080, 5448, 186, 4, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[178269, 5454, 203, 5, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[178475, 5461, 337, 10, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[178815, 5473, 129, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[178947, 5478, 106, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[179056, 5481, 271, 6, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[179330, 5489, 159, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[179492, 5495, 141, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[179636, 5501, 249, 5, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[179888, 5508, 212, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[180103, 5515, 344, 9, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[180450, 5526, 126, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[180579, 5531, 218, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[180800, 5539, 249, 5, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[181052, 5546, 196, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[181251, 5553, 129, 2, 34, "Subsubsubsection",
      CellTags->"MacIntroduction"],
    Cell[181383, 5557, 231, 7, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[181617, 5566, 185, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[181805, 5573, 394, 11, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[182202, 5586, 734, 19, 80, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[182939, 5607, 268, 9, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[183210, 5618, 156, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[183369, 5624, 121, 2, 34, "Subsubsubsection",
      CellTags->"MacIntroduction"],
    Cell[183493, 5628, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[183631, 5633, 352, 7, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[183986, 5642, 1420, 44, 151, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[185409, 5688, 691, 20, 62, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[186103, 5710, 329, 12, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[186435, 5724, 164, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[186602, 5730, 230, 8, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[186835, 5740, 129, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[186967, 5745, 190, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[187160, 5752, 131, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[187294, 5757, 172, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[187469, 5763, 174, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[187646, 5769, 213, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[187862, 5776, 174, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[188039, 5782, 215, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[188257, 5789, 72, 1, 34, "Subsubsubsection",
      CellTags->"MacIntroduction"],
    Cell[188332, 5792, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[188470, 5797, 96, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[188569, 5800, 257, 6, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[188829, 5808, 131, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[188963, 5813, 130, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[189096, 5819, 308, 6, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[189407, 5827, 358, 8, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[189768, 5837, 245, 5, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[190016, 5844, 211, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[190230, 5851, 265, 7, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[190498, 5860, 163, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[190664, 5868, 129, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[190796, 5873, 165, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[190964, 5880, 478, 15, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[191445, 5897, 273, 8, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[191721, 5907, 97, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[191821, 5910, 130, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[191954, 5916, 163, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[192120, 5924, 126, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[192249, 5929, 368, 10, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[192620, 5941, 223, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[192846, 5949, 207, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[193056, 5957, 136, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[193195, 5963, 165, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[193397, 5973, 103, 1, 34, "Subsubsection",
      CellTags->"MacIntroduction"],
    Cell[193503, 5976, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[193641, 5981, 174, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[193818, 5987, 87, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[193908, 5990, 104, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[194015, 5993, 359, 10, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[194377, 6005, 135, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[194515, 6011, 185, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[194703, 6019, 193, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[194899, 6027, 331, 12, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[195233, 6041, 293, 10, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[195529, 6053, 228, 6, 44, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[195760, 6061, 131, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[195894, 6066, 140, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[196071, 6075, 76, 1, 34, "Subsubsection",
      CellTags->"MacIntroduction"],
    Cell[196150, 6078, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[196288, 6083, 81, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[196372, 6086, 284, 10, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[196659, 6098, 283, 7, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[196945, 6107, 163, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[197111, 6113, 190, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[197304, 6121, 167, 6, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[197474, 6129, 211, 8, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[197688, 6139, 266, 9, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[197957, 6150, 85, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[198045, 6153, 96, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[198144, 6156, 91, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[198238, 6159, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[198376, 6164, 521, 17, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[198900, 6183, 193, 5, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[199130, 6193, 76, 1, 34, "Subsubsection",
      CellTags->"MacIntroduction"],
    Cell[199209, 6196, 135, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[199347, 6201, 1879, 47, 206, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[201229, 6250, 94, 1, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[201326, 6253, 234, 7, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[201563, 6262, 131, 3, 21, "Text",
      CellTags->"MacIntroduction"],
    Cell[201697, 6267, 279, 8, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[201979, 6277, 137, 4, 26, "BulletedList",
      CellTags->"MacIntroduction"],
    Cell[202119, 6283, 330, 7, 44, "BulletedList",
      CellTags->"MacIntroduction"]},
  "MacInstalling"->{
    Cell[202498, 6296, 145, 6, 38, "Section",
      CellTags->"MacInstalling"],
    Cell[202646, 6304, 343, 12, 40, "Text",
      CellTags->"MacInstalling"],
    Cell[203014, 6320, 75, 1, 36, "Subsection",
      CellTags->"MacInstalling"],
    Cell[203092, 6323, 114, 2, 24, "Text",
      CellTags->"MacInstalling"],
    Cell[203209, 6327, 764, 21, 72, "Text",
      CellTags->"MacInstalling"],
    Cell[203976, 6350, 579, 14, 56, "Text",
      CellTags->"MacInstalling"],
    Cell[204558, 6366, 113, 2, 24, "Text",
      CellTags->"MacInstalling"],
    Cell[204674, 6370, 161, 4, 24, "Text",
      CellTags->"MacInstalling"],
    Cell[204872, 6379, 72, 1, 36, "Subsection",
      CellTags->{"parts", "MacInstalling"}],
    Cell[204947, 6382, 215, 6, 24, "Text",
      CellTags->{"parts", "MacInstalling"}],
    Cell[205187, 6392, 141, 2, 34, "Subsubsection",
      CellTags->{"parts", "MacInstalling"}],
    Cell[205331, 6396, 119, 2, 24, "Text",
      CellTags->{"parts", "mathlink.h", "MacInstalling"}],
    Cell[205453, 6400, 563, 10, 56, "Text",
      CellTags->{"parts", "mathlink.h", "MacInstalling"}],
    Cell[206019, 6412, 123, 2, 24, "Text",
      CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
    Cell[206145, 6416, 522, 12, 56, "Text",
      CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
    Cell[206670, 6430, 109, 2, 24, "Text",
      CellTags->{"parts", "mprep", "MacInstalling"}],
    Cell[206782, 6434, 443, 10, 40, "Text",
      CellTags->{"parts", "mprep", "MacInstalling"}],
    Cell[207228, 6446, 105, 2, 24, "Text",
      CellTags->{"parts", "mcc", "MacInstalling"}],
    Cell[207336, 6450, 249, 7, 24, "Text",
      CellTags->{"parts", "mcc", "MacInstalling"}],
    Cell[207622, 6462, 140, 2, 34, "Subsubsection",
      CellTags->{"parts", "MacInstalling"}],
    Cell[207765, 6466, 371, 10, 40, "Text",
      CellTags->{"parts", "MacInstalling"}],
    Cell[208173, 6481, 152, 2, 34, "Subsubsection",
      CellTags->{"parts", "prebuilt", "MacInstalling"}],
    Cell[208328, 6485, 947, 27, 56, "Text",
      CellTags->{"parts", "prebuilt", "MacInstalling"}]},
  "mcc"->{
    Cell[207228, 6446, 105, 2, 24, "Text",
      CellTags->{"parts", "mcc", "MacInstalling"}],
    Cell[207336, 6450, 249, 7, 24, "Text",
      CellTags->{"parts", "mcc", "MacInstalling"}],
    Cell[228644, 7112, 114, 1, 41, "Subsection",
      CellTags->{"mcc", "MacBuilding"}],
    Cell[228761, 7115, 752, 15, 72, "Text",
      CellTags->{"mcc", "MacBuilding"}],
    Cell[229516, 7132, 115, 1, 40, "FramedBox",
      CellTags->{"mcc", "MacBuilding"}],
    Cell[318907, 9909, 106, 2, 24, "Text",
      CellTags->{"parts", "mcc", "UnixInstalling"}],
    Cell[319016, 9913, 250, 7, 24, "Text",
      CellTags->{"parts", "mcc", "UnixInstalling"}],
    Cell[326558, 10120, 115, 1, 36, "Subsection",
      CellTags->{"mcc", "UnixBuilding"}],
    Cell[326676, 10123, 753, 15, 52, "Text",
      CellTags->{"mcc", "UnixBuilding"}],
    Cell[327432, 10140, 116, 1, 40, "FramedBox",
      CellTags->{"mcc", "UnixBuilding"}]},
  "MacBuilding"->{
    Cell[209336, 6519, 135, 6, 38, "Section",
      CellTags->"MacBuilding"],
    Cell[209474, 6527, 795, 17, 88, "Text",
      CellTags->"MacBuilding"],
    Cell[210294, 6548, 120, 2, 41, "Subsection",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[210417, 6552, 1013, 22, 120, "Text",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[211433, 6576, 78, 1, 24, "Text",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[211514, 6579, 114, 1, 40, "FramedBox",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[211631, 6582, 499, 9, 56, "Text",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[212133, 6593, 148, 2, 55, "FramedBox",
      CellTags->{"mprep", "MacBuilding"}],
    Cell[212318, 6600, 160, 6, 41, "Subsection",
      CellTags->"MacBuilding"],
    Cell[212481, 6608, 503, 11, 56, "Text",
      CellTags->"MacBuilding"],
    Cell[212987, 6621, 85, 1, 40, "FramedBox",
      CellTags->"MacBuilding"],
    Cell[213097, 6626, 60, 1, 34, "Subsubsection",
      CellTags->"MacBuilding"],
    Cell[213160, 6629, 1674, 22, 925, "FramedBox",
      CellTags->"MacBuilding"],
    Cell[214883, 6657, 186, 6, 41, "Subsection",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215072, 6665, 161, 4, 34, "Subsubsubsection",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215236, 6671, 207, 5, 24, "NumberedGestureHead",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215446, 6678, 184, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215633, 6686, 201, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215837, 6694, 115, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215955, 6697, 198, 5, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216156, 6704, 121, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216280, 6707, 181, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216464, 6715, 410, 7, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216877, 6724, 209, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[217089, 6732, 445, 12, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[217537, 6746, 390, 12, 39, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[217930, 6760, 198, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218131, 6766, 156, 2, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218290, 6770, 193, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218486, 6778, 122, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218611, 6781, 137, 2, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218751, 6785, 116, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218870, 6788, 157, 2, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219030, 6792, 208, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219241, 6800, 187, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219431, 6808, 204, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219638, 6814, 242, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219883, 6821, 245, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[220131, 6828, 255, 7, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[220389, 6837, 476, 13, 57, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[220868, 6852, 300, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221171, 6860, 297, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221471, 6868, 193, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221667, 6876, 230, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221900, 6883, 180, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222083, 6891, 114, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222200, 6894, 161, 4, 34, "Subsubsubsection",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222364, 6900, 207, 5, 24, "NumberedGestureHead",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222574, 6907, 184, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222761, 6915, 201, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222965, 6923, 115, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223083, 6926, 227, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223313, 6934, 121, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223437, 6937, 181, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223621, 6945, 390, 7, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224014, 6954, 93, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224110, 6957, 209, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224322, 6965, 445, 12, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224770, 6979, 390, 12, 39, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225163, 6993, 198, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225364, 6999, 336, 14, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225703, 7015, 204, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225910, 7023, 158, 5, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226071, 7030, 204, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226278, 7036, 242, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226523, 7043, 255, 7, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226781, 7052, 476, 13, 57, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[227260, 7067, 301, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[227564, 7075, 298, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[227865, 7083, 193, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[228061, 7091, 246, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[228310, 7098, 180, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[228493, 7106, 114, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[228644, 7112, 114, 1, 41, "Subsection",
      CellTags->{"mcc", "MacBuilding"}],
    Cell[228761, 7115, 752, 15, 72, "Text",
      CellTags->{"mcc", "MacBuilding"}],
    Cell[229516, 7132, 115, 1, 40, "FramedBox",
      CellTags->{"mcc", "MacBuilding"}],
    Cell[229668, 7138, 179, 6, 41, "Subsection",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[229850, 7146, 555, 15, 72, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[230408, 7163, 109, 1, 40, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[230520, 7166, 456, 9, 56, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[231001, 7179, 73, 1, 34, "Subsubsection",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[231077, 7182, 1704, 22, 925, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[232818, 7209, 186, 2, 34, "Subsubsection",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233007, 7213, 246, 6, 24, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233256, 7221, 138, 2, 40, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233397, 7225, 193, 5, 40, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233593, 7232, 262, 3, 190, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}]},
  "ProjectBuilder"->{
    Cell[214883, 6657, 186, 6, 41, "Subsection",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215072, 6665, 161, 4, 34, "Subsubsubsection",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215236, 6671, 207, 5, 24, "NumberedGestureHead",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215446, 6678, 184, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215633, 6686, 201, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215837, 6694, 115, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[215955, 6697, 198, 5, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216156, 6704, 121, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216280, 6707, 181, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216464, 6715, 410, 7, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[216877, 6724, 209, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[217089, 6732, 445, 12, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[217537, 6746, 390, 12, 39, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[217930, 6760, 198, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218131, 6766, 156, 2, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218290, 6770, 193, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218486, 6778, 122, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218611, 6781, 137, 2, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218751, 6785, 116, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[218870, 6788, 157, 2, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219030, 6792, 208, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219241, 6800, 187, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219431, 6808, 204, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219638, 6814, 242, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[219883, 6821, 245, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[220131, 6828, 255, 7, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[220389, 6837, 476, 13, 57, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[220868, 6852, 300, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221171, 6860, 297, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221471, 6868, 193, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221667, 6876, 230, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[221900, 6883, 180, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222083, 6891, 114, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222200, 6894, 161, 4, 34, "Subsubsubsection",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222364, 6900, 207, 5, 24, "NumberedGestureHead",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222574, 6907, 184, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222761, 6915, 201, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[222965, 6923, 115, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223083, 6926, 227, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223313, 6934, 121, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223437, 6937, 181, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[223621, 6945, 390, 7, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224014, 6954, 93, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224110, 6957, 209, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224322, 6965, 445, 12, 56, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[224770, 6979, 390, 12, 39, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225163, 6993, 198, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225364, 6999, 336, 14, 23, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225703, 7015, 204, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[225910, 7023, 158, 5, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226071, 7030, 204, 4, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226278, 7036, 242, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226523, 7043, 255, 7, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[226781, 7052, 476, 13, 57, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[227260, 7067, 301, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[227564, 7075, 298, 6, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[227865, 7083, 193, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[228061, 7091, 246, 5, 40, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[228310, 7098, 180, 6, 24, "NumberedGesture",
      CellTags->{"ProjectBuilder", "MacBuilding"}],
    Cell[228493, 7106, 114, 1, 24, "NumberedGestureRemark",
      CellTags->{"ProjectBuilder", "MacBuilding"}]},
  "preANSI"->{
    Cell[229668, 7138, 179, 6, 41, "Subsection",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[229850, 7146, 555, 15, 72, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[230408, 7163, 109, 1, 40, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[230520, 7166, 456, 9, 56, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[231001, 7179, 73, 1, 34, "Subsubsection",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[231077, 7182, 1704, 22, 925, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[232818, 7209, 186, 2, 34, "Subsubsection",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233007, 7213, 246, 6, 24, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233256, 7221, 138, 2, 40, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233397, 7225, 193, 5, 40, "Text",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[233593, 7232, 262, 3, 190, "FramedBox",
      CellTags->{"preANSI", "MacBuilding"}],
    Cell[327585, 10146, 180, 6, 36, "Subsection",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[327768, 10154, 556, 15, 54, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[328327, 10171, 110, 1, 40, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[328440, 10174, 464, 10, 51, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[328929, 10188, 74, 1, 34, "Subsubsection",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[329006, 10191, 1703, 22, 925, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[330746, 10218, 187, 2, 34, "Subsubsection",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[330936, 10222, 247, 6, 22, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[331186, 10230, 139, 2, 40, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[331328, 10234, 199, 5, 36, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[331530, 10241, 263, 3, 190, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}]},
  "MacRunning"->{
    Cell[233916, 7242, 133, 6, 38, "Section",
      CellTags->"MacRunning"],
    Cell[234052, 7250, 340, 8, 40, "Text",
      CellTags->"MacRunning"],
    Cell[234417, 7262, 123, 2, 41, "Subsection",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[234543, 7266, 1090, 31, 104, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[235636, 7299, 489, 6, 325, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236128, 7307, 128, 4, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236259, 7313, 115, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236377, 7317, 127, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236507, 7321, 140, 4, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236650, 7327, 89, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[236742, 7331, 257, 7, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237002, 7340, 82, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237087, 7344, 65, 1, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237155, 7347, 85, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237243, 7351, 200, 5, 40, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237446, 7358, 110, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237559, 7362, 200, 3, 55, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237762, 7367, 120, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[237885, 7371, 139, 2, 40, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238027, 7375, 142, 3, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238172, 7380, 133, 2, 40, "FramedBox",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238308, 7384, 425, 13, 40, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238736, 7399, 80, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238819, 7403, 113, 1, 24, "Text",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[238935, 7406, 86, 2, 26, "Input",
      CellTags->{"addtwo", "MacRunning"}],
    Cell[239058, 7413, 123, 2, 41, "Subsection",
      CellTags->{"factor", "MacRunning"}],
    Cell[239184, 7417, 544, 13, 56, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[239731, 7432, 176, 4, 24, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[239910, 7438, 137, 2, 40, "FramedBox",
      CellTags->{"factor", "MacRunning"}],
    Cell[240050, 7442, 301, 6, 56, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[240354, 7450, 103, 1, 40, "FramedBox",
      CellTags->{"factor", "MacRunning"}],
    Cell[240460, 7453, 312, 10, 24, "Text",
      CellTags->{"factor", "MacRunning"}],
    Cell[240775, 7465, 142, 2, 85, "FramedBox",
      CellTags->{"factor", "MacRunning"}],
    Cell[240954, 7472, 87, 1, 41, "Subsection",
      CellTags->{"protocols", "MacRunning"}],
    Cell[241044, 7475, 886, 21, 104, "Text",
      CellTags->{"protocols", "MacRunning"}],
    Cell[241933, 7498, 389, 11, 40, "Text",
      CellTags->{"protocols", "MacRunning"}]},
  "MacPorting"->{
    Cell[242371, 7515, 145, 6, 38, "Section",
      CellTags->"MacPorting"],
    Cell[242541, 7525, 183, 6, 41, "Subsection",
      CellTags->{"changes", "MacPorting"}],
    Cell[242727, 7533, 503, 14, 56, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[243233, 7549, 1160, 28, 120, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[244396, 7579, 498, 10, 72, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[244897, 7591, 350, 8, 56, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[245250, 7601, 288, 7, 40, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[245563, 7612, 106, 1, 34, "Subsubsection",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[245672, 7615, 1036, 26, 120, "Text",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[246711, 7643, 1052, 22, 136, "Text",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[247766, 7667, 425, 10, 56, "Text",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[248194, 7679, 410, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[248607, 7686, 650, 13, 88, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "MacPorting"}],
    Cell[249260, 7701, 512, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "MacPorting"}],
    Cell[249775, 7709, 597, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "MacPorting"}],
    Cell[250375, 7728, 555, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "MacPorting"}],
    Cell[250933, 7737, 748, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "MacPorting"}],
    Cell[251684, 7756, 603, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "MacPorting"}],
    Cell[252324, 7768, 82, 1, 34, "Subsubsection",
      CellTags->{"changes", "MacPorting"}],
    Cell[252409, 7771, 121, 4, 24, "Text",
      CellTags->"MacPorting"],
    Cell[252533, 7777, 831, 14, 134, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[253367, 7793, 434, 11, 62, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[253804, 7806, 191, 2, 100, "FramedBox",
      CellTags->{"changes", "MacPorting"}],
    Cell[253998, 7810, 527, 15, 62, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[254528, 7827, 626, 18, 80, "BulletedList",
      CellTags->{"MLGetArgCount", "changes", "MacPorting"}],
    Cell[255157, 7847, 521, 16, 62, "BulletedList",
      CellTags->{"MLGetData", "changes", "MacPorting"}],
    Cell[255681, 7865, 660, 20, 80, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[256344, 7887, 664, 15, 98, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[257011, 7904, 386, 12, 42, "IndentedText",
      CellTags->{"changes", "MacPorting"}],
    Cell[257400, 7918, 641, 17, 78, "IndentedText",
      CellTags->{"changes", "MacPorting"}],
    Cell[258044, 7937, 268, 7, 44, "BulletedList",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[258315, 7946, 199, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[258517, 7950, 584, 14, 78, "IndentedText",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[259104, 7966, 214, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[259321, 7970, 1103, 36, 116, "BulletedList",
      CellTags->{"MLBytesToGet", "changes", "MacPorting"}],
    Cell[260427, 8008, 512, 11, 80, "BulletedList",
      CellTags->{"MLPutFunction", "changes", "MacPorting"}],
    Cell[260942, 8021, 302, 9, 44, "BulletedList",
      CellTags->{"MLInitialize", "changes", "MacPorting"}],
    Cell[261247, 8032, 302, 9, 44, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[261552, 8043, 337, 10, 44, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[261892, 8055, 283, 7, 44, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[262178, 8064, 948, 21, 116, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[263129, 8087, 691, 17, 280, "FramedBox",
      CellTags->{"changes", "MacPorting"}],
    Cell[263823, 8106, 1412, 33, 168, "IndentedText",
      CellTags->{"changes", "MacPorting"}],
    Cell[265272, 8144, 75, 1, 34, "Subsubsection",
      CellTags->{"changes", "MacPorting"}],
    Cell[265350, 8147, 266, 6, 40, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[265619, 8155, 272, 5, 40, "Text",
      CellTags->{"MLPutUnicodeString", "changes", "MacPorting"}],
    Cell[265894, 8162, 336, 4, 70, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[266233, 8168, 870, 21, 104, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267106, 8191, 338, 4, 85, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267447, 8197, 126, 1, 24, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267576, 8200, 405, 13, 40, "Text",
      CellTags->{"MLPutNext", "changes", "MacPorting"}],
    Cell[267984, 8215, 165, 2, 55, "FramedBox",
      CellTags->{"changes", "MLPutNext", "MacPorting"}],
    Cell[268152, 8219, 126, 1, 24, "Text",
      CellTags->{"MLGetUnicodeString", "changes", "MacPorting"}],
    Cell[268281, 8222, 213, 2, 85, "FramedBox",
      CellTags->{"changes", "MLGetUnicodeString", "MacPorting"}],
    Cell[268497, 8226, 555, 15, 56, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[269055, 8243, 209, 6, 24, "Text",
      CellTags->{"changes", "MacPorting"}]},
  "changes"->{
    Cell[242541, 7525, 183, 6, 41, "Subsection",
      CellTags->{"changes", "MacPorting"}],
    Cell[242727, 7533, 503, 14, 56, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[243233, 7549, 1160, 28, 120, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[244396, 7579, 498, 10, 72, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[244897, 7591, 350, 8, 56, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[245250, 7601, 288, 7, 40, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[245563, 7612, 106, 1, 34, "Subsubsection",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[245672, 7615, 1036, 26, 120, "Text",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[246711, 7643, 1052, 22, 136, "Text",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[247766, 7667, 425, 10, 56, "Text",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[248194, 7679, 410, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[248607, 7686, 650, 13, 88, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "MacPorting"}],
    Cell[249260, 7701, 512, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "MacPorting"}],
    Cell[249775, 7709, 597, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "MacPorting"}],
    Cell[250375, 7728, 555, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "MacPorting"}],
    Cell[250933, 7737, 748, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "MacPorting"}],
    Cell[251684, 7756, 603, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "MacPorting"}],
    Cell[252324, 7768, 82, 1, 34, "Subsubsection",
      CellTags->{"changes", "MacPorting"}],
    Cell[252533, 7777, 831, 14, 134, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[253367, 7793, 434, 11, 62, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[253804, 7806, 191, 2, 100, "FramedBox",
      CellTags->{"changes", "MacPorting"}],
    Cell[253998, 7810, 527, 15, 62, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[254528, 7827, 626, 18, 80, "BulletedList",
      CellTags->{"MLGetArgCount", "changes", "MacPorting"}],
    Cell[255157, 7847, 521, 16, 62, "BulletedList",
      CellTags->{"MLGetData", "changes", "MacPorting"}],
    Cell[255681, 7865, 660, 20, 80, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[256344, 7887, 664, 15, 98, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[257011, 7904, 386, 12, 42, "IndentedText",
      CellTags->{"changes", "MacPorting"}],
    Cell[257400, 7918, 641, 17, 78, "IndentedText",
      CellTags->{"changes", "MacPorting"}],
    Cell[258044, 7937, 268, 7, 44, "BulletedList",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[258315, 7946, 199, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[258517, 7950, 584, 14, 78, "IndentedText",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[259104, 7966, 214, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[259321, 7970, 1103, 36, 116, "BulletedList",
      CellTags->{"MLBytesToGet", "changes", "MacPorting"}],
    Cell[260427, 8008, 512, 11, 80, "BulletedList",
      CellTags->{"MLPutFunction", "changes", "MacPorting"}],
    Cell[260942, 8021, 302, 9, 44, "BulletedList",
      CellTags->{"MLInitialize", "changes", "MacPorting"}],
    Cell[261247, 8032, 302, 9, 44, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[261552, 8043, 337, 10, 44, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[261892, 8055, 283, 7, 44, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[262178, 8064, 948, 21, 116, "BulletedList",
      CellTags->{"changes", "MacPorting"}],
    Cell[263129, 8087, 691, 17, 280, "FramedBox",
      CellTags->{"changes", "MacPorting"}],
    Cell[263823, 8106, 1412, 33, 168, "IndentedText",
      CellTags->{"changes", "MacPorting"}],
    Cell[265272, 8144, 75, 1, 34, "Subsubsection",
      CellTags->{"changes", "MacPorting"}],
    Cell[265350, 8147, 266, 6, 40, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[265619, 8155, 272, 5, 40, "Text",
      CellTags->{"MLPutUnicodeString", "changes", "MacPorting"}],
    Cell[265894, 8162, 336, 4, 70, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[266233, 8168, 870, 21, 104, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267106, 8191, 338, 4, 85, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267447, 8197, 126, 1, 24, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267576, 8200, 405, 13, 40, "Text",
      CellTags->{"MLPutNext", "changes", "MacPorting"}],
    Cell[267984, 8215, 165, 2, 55, "FramedBox",
      CellTags->{"changes", "MLPutNext", "MacPorting"}],
    Cell[268152, 8219, 126, 1, 24, "Text",
      CellTags->{"MLGetUnicodeString", "changes", "MacPorting"}],
    Cell[268281, 8222, 213, 2, 85, "FramedBox",
      CellTags->{"changes", "MLGetUnicodeString", "MacPorting"}],
    Cell[268497, 8226, 555, 15, 56, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[269055, 8243, 209, 6, 24, "Text",
      CellTags->{"changes", "MacPorting"}],
    Cell[340523, 10534, 184, 6, 41, "Subsection",
      CellTags->{"changes", "UnixPorting"}],
    Cell[340710, 10542, 504, 14, 56, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[341217, 10558, 1161, 28, 120, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[342381, 10588, 494, 10, 72, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[342878, 10600, 351, 8, 56, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[343232, 10610, 289, 7, 40, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[343546, 10621, 107, 1, 34, "Subsubsection",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[343656, 10624, 1036, 26, 104, "Text",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[344695, 10652, 1046, 22, 120, "Text",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[345744, 10676, 426, 10, 40, "Text",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
    Cell[346173, 10688, 411, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
    Cell[346587, 10695, 651, 13, 72, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "UnixPorting"}],
    Cell[347241, 10710, 513, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "UnixPorting"}],
    Cell[347757, 10718, 598, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "UnixPorting"}],
    Cell[348358, 10737, 556, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "UnixPorting"}],
    Cell[348917, 10746, 749, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "UnixPorting"}],
    Cell[349669, 10765, 604, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "UnixPorting"}],
    Cell[350310, 10777, 83, 1, 34, "Subsubsection",
      CellTags->{"changes", "UnixPorting"}],
    Cell[350396, 10780, 143, 4, 26, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[350542, 10786, 839, 14, 134, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[351384, 10802, 435, 11, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[351822, 10815, 192, 2, 100, "FramedBox",
      CellTags->{"changes", "UnixPorting"}],
    Cell[352017, 10819, 528, 15, 62, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[352548, 10836, 624, 18, 80, "BulletedList",
      CellTags->{"MLGetArgCount", "changes", "UnixPorting"}],
    Cell[353175, 10856, 518, 15, 62, "BulletedList",
      CellTags->{"MLGetData", "changes", "UnixPorting"}],
    Cell[353696, 10873, 661, 20, 80, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[354360, 10895, 670, 15, 98, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[355033, 10912, 387, 12, 42, "IndentedText",
      CellTags->{"changes", "UnixPorting"}],
    Cell[355423, 10926, 642, 17, 78, "IndentedText",
      CellTags->{"changes", "UnixPorting"}],
    Cell[356068, 10945, 269, 7, 44, "BulletedList",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[356340, 10954, 200, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[356543, 10958, 585, 14, 60, "IndentedText",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[357131, 10974, 215, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[357349, 10978, 1104, 36, 116, "BulletedList",
      CellTags->{"MLBytesToGet", "changes", "UnixPorting"}],
    Cell[358456, 11016, 513, 11, 62, "BulletedList",
      CellTags->{"MLPutFunction", "changes", "UnixPorting"}],
    Cell[358972, 11029, 303, 9, 44, "BulletedList",
      CellTags->{"MLInitialize", "changes", "UnixPorting"}],
    Cell[359278, 11040, 303, 9, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[359584, 11051, 338, 10, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[359925, 11063, 284, 7, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[360212, 11072, 948, 21, 116, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[361163, 11095, 692, 17, 280, "FramedBox",
      CellTags->{"changes", "UnixPorting"}],
    Cell[361858, 11114, 1414, 33, 168, "IndentedText",
      CellTags->{"changes", "UnixPorting"}],
    Cell[363309, 11152, 76, 1, 34, "Subsubsection",
      CellTags->{"changes", "UnixPorting"}],
    Cell[363388, 11155, 267, 6, 40, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[363658, 11163, 273, 5, 40, "Text",
      CellTags->{"MLPutUnicodeString", "changes", "UnixPorting"}],
    Cell[363934, 11170, 337, 4, 70, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[364274, 11176, 871, 21, 88, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365148, 11199, 339, 4, 85, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365490, 11205, 127, 1, 24, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365620, 11208, 406, 13, 40, "Text",
      CellTags->{"MLPutNext", "changes", "UnixPorting"}],
    Cell[366029, 11223, 166, 2, 55, "FramedBox",
      CellTags->{"changes", "MLPutNext", "UnixPorting"}],
    Cell[366198, 11227, 127, 1, 24, "Text",
      CellTags->{"MLGetUnicodeString", "changes", "UnixPorting"}],
    Cell[366328, 11230, 214, 2, 85, "FramedBox",
      CellTags->{"changes", "MLGetUnicodeString", "UnixPorting"}],
    Cell[366545, 11234, 556, 15, 56, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[367104, 11251, 210, 6, 24, "Text",
      CellTags->{"changes", "UnixPorting"}]},
  "strings"->{
    Cell[245563, 7612, 106, 1, 34, "Subsubsection",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[245672, 7615, 1036, 26, 120, "Text",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[246711, 7643, 1052, 22, 136, "Text",
      CellTags->{"changes", "strings", "MacPorting"}],
    Cell[247766, 7667, 425, 10, 56, "Text",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[248194, 7679, 410, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[248607, 7686, 650, 13, 88, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "MacPorting"}],
    Cell[249260, 7701, 512, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "MacPorting"}],
    Cell[249775, 7709, 597, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "MacPorting"}],
    Cell[250375, 7728, 555, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "MacPorting"}],
    Cell[250933, 7737, 748, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "MacPorting"}],
    Cell[251684, 7756, 603, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "MacPorting"}],
    Cell[343546, 10621, 107, 1, 34, "Subsubsection",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[343656, 10624, 1036, 26, 104, "Text",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[344695, 10652, 1046, 22, 120, "Text",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[345744, 10676, 426, 10, 40, "Text",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
    Cell[346173, 10688, 411, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
    Cell[346587, 10695, 651, 13, 72, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "UnixPorting"}],
    Cell[347241, 10710, 513, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "UnixPorting"}],
    Cell[347757, 10718, 598, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "UnixPorting"}],
    Cell[348358, 10737, 556, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "UnixPorting"}],
    Cell[348917, 10746, 749, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "UnixPorting"}],
    Cell[349669, 10765, 604, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "UnixPorting"}]},
  "MLforString"->{
    Cell[247766, 7667, 425, 10, 56, "Text",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[248194, 7679, 410, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
    Cell[345744, 10676, 426, 10, 40, "Text",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
    Cell[346173, 10688, 411, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}]},
  "MLNextCharacter"->{
    Cell[248607, 7686, 650, 13, 88, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "MacPorting"}],
    Cell[249260, 7701, 512, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "MacPorting"}],
    Cell[346587, 10695, 651, 13, 72, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "UnixPorting"}],
    Cell[347241, 10710, 513, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "UnixPorting"}]},
  "MLPutCharToString"->{
    Cell[249775, 7709, 597, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "MacPorting"}],
    Cell[250375, 7728, 555, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "MacPorting"}],
    Cell[347757, 10718, 598, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "UnixPorting"}],
    Cell[348358, 10737, 556, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "UnixPorting"}]},
  "MLConvertUnicodeString"->{
    Cell[250933, 7737, 748, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "MacPorting"}],
    Cell[251684, 7756, 603, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "MacPorting"}],
    Cell[348917, 10746, 749, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "UnixPorting"}],
    Cell[349669, 10765, 604, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "UnixPorting"}]},
  "MLGetArgCount"->{
    Cell[254528, 7827, 626, 18, 80, "BulletedList",
      CellTags->{"MLGetArgCount", "changes", "MacPorting"}],
    Cell[352548, 10836, 624, 18, 80, "BulletedList",
      CellTags->{"MLGetArgCount", "changes", "UnixPorting"}]},
  "MLGetData"->{
    Cell[255157, 7847, 521, 16, 62, "BulletedList",
      CellTags->{"MLGetData", "changes", "MacPorting"}],
    Cell[353175, 10856, 518, 15, 62, "BulletedList",
      CellTags->{"MLGetData", "changes", "UnixPorting"}]},
  "MLGetByteString"->{
    Cell[258044, 7937, 268, 7, 44, "BulletedList",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[258315, 7946, 199, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[258517, 7950, 584, 14, 78, "IndentedText",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[259104, 7966, 214, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "MacPorting"}],
    Cell[356068, 10945, 269, 7, 44, "BulletedList",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[356340, 10954, 200, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[356543, 10958, 585, 14, 60, "IndentedText",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[357131, 10974, 215, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}]},
  "MLBytesToGet"->{
    Cell[259321, 7970, 1103, 36, 116, "BulletedList",
      CellTags->{"MLBytesToGet", "changes", "MacPorting"}],
    Cell[357349, 10978, 1104, 36, 116, "BulletedList",
      CellTags->{"MLBytesToGet", "changes", "UnixPorting"}]},
  "MLPutFunction"->{
    Cell[260427, 8008, 512, 11, 80, "BulletedList",
      CellTags->{"MLPutFunction", "changes", "MacPorting"}],
    Cell[358456, 11016, 513, 11, 62, "BulletedList",
      CellTags->{"MLPutFunction", "changes", "UnixPorting"}]},
  "MLInitialize"->{
    Cell[260942, 8021, 302, 9, 44, "BulletedList",
      CellTags->{"MLInitialize", "changes", "MacPorting"}],
    Cell[358972, 11029, 303, 9, 44, "BulletedList",
      CellTags->{"MLInitialize", "changes", "UnixPorting"}]},
  "MLPutUnicodeString"->{
    Cell[265350, 8147, 266, 6, 40, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[265619, 8155, 272, 5, 40, "Text",
      CellTags->{"MLPutUnicodeString", "changes", "MacPorting"}],
    Cell[265894, 8162, 336, 4, 70, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[266233, 8168, 870, 21, 104, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267106, 8191, 338, 4, 85, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[267447, 8197, 126, 1, 24, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
    Cell[363388, 11155, 267, 6, 40, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[363658, 11163, 273, 5, 40, "Text",
      CellTags->{"MLPutUnicodeString", "changes", "UnixPorting"}],
    Cell[363934, 11170, 337, 4, 70, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[364274, 11176, 871, 21, 88, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365148, 11199, 339, 4, 85, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365490, 11205, 127, 1, 24, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}]},
  "MLPutNext"->{
    Cell[267576, 8200, 405, 13, 40, "Text",
      CellTags->{"MLPutNext", "changes", "MacPorting"}],
    Cell[267984, 8215, 165, 2, 55, "FramedBox",
      CellTags->{"changes", "MLPutNext", "MacPorting"}],
    Cell[365620, 11208, 406, 13, 40, "Text",
      CellTags->{"MLPutNext", "changes", "UnixPorting"}],
    Cell[366029, 11223, 166, 2, 55, "FramedBox",
      CellTags->{"changes", "MLPutNext", "UnixPorting"}]},
  "MLGetUnicodeString"->{
    Cell[268152, 8219, 126, 1, 24, "Text",
      CellTags->{"MLGetUnicodeString", "changes", "MacPorting"}],
    Cell[268281, 8222, 213, 2, 85, "FramedBox",
      CellTags->{"changes", "MLGetUnicodeString", "MacPorting"}],
    Cell[366198, 11227, 127, 1, 24, "Text",
      CellTags->{"MLGetUnicodeString", "changes", "UnixPorting"}],
    Cell[366328, 11230, 214, 2, 85, "FramedBox",
      CellTags->{"changes", "MLGetUnicodeString", "UnixPorting"}]},
  "MacTroubleshooting"->{
    Cell[269325, 8256, 68, 1, 38, "Section",
      CellTags->"MacTroubleshooting"],
    Cell[269396, 8259, 641, 10, 116, "BulletedList",
      CellTags->"MacTroubleshooting"],
    Cell[270040, 8271, 387, 12, 44, "BulletedList",
      CellTags->"MacTroubleshooting"],
    Cell[270430, 8285, 405, 9, 44, "BulletedList",
      CellTags->"MacTroubleshooting"],
    Cell[270838, 8296, 371, 9, 62, "BulletedList",
      CellTags->"MacTroubleshooting"]},
  "UnixIntroduction"->{
    Cell[271258, 8311, 142, 5, 82, "Chapter",
      CellTags->"UnixIntroduction"],
    Cell[271403, 8318, 105, 4, 40, "CopyrightHead",
      CellTags->"UnixIntroduction"],
    Cell[271511, 8324, 155, 4, 22, "Text",
      CellTags->"UnixIntroduction"],
    Cell[271669, 8330, 524, 18, 56, "Text",
      CellTags->"UnixIntroduction"],
    Cell[272196, 8350, 387, 8, 52, "Text",
      CellTags->"UnixIntroduction"],
    Cell[272586, 8360, 432, 11, 66, "Text",
      CellTags->"UnixIntroduction"],
    Cell[273043, 8375, 70, 1, 36, "Subsection",
      CellTags->"UnixIntroduction"],
    Cell[276462, 8467, 79, 1, 34, "Subsubsection",
      CellTags->"UnixIntroduction"],
    Cell[276544, 8470, 633, 12, 90, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[277180, 8484, 788, 18, 94, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[277971, 8504, 443, 11, 60, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[278417, 8517, 631, 15, 76, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[279051, 8534, 398, 8, 58, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[279452, 8544, 273, 7, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[279762, 8556, 79, 1, 34, "Subsubsection",
      CellTags->"UnixIntroduction"],
    Cell[279844, 8559, 114, 2, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[279961, 8563, 95, 1, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[280059, 8566, 82, 1, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[280178, 8572, 81, 1, 34, "Subsubsection",
      CellTags->"UnixIntroduction"],
    Cell[280262, 8575, 82, 1, 34, "Subsubsubsection",
      CellTags->"UnixIntroduction"],
    Cell[280347, 8578, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[280486, 8583, 133, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[280622, 8589, 108, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[280733, 8592, 117, 2, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[280853, 8596, 171, 6, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[281027, 8604, 211, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[281241, 8612, 278, 7, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[281522, 8621, 747, 21, 76, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[282272, 8644, 164, 5, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[282439, 8651, 269, 9, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[282711, 8662, 127, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[282841, 8668, 304, 10, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[283148, 8680, 285, 9, 41, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[283436, 8691, 340, 10, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[283779, 8703, 165, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[283947, 8709, 192, 6, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[284142, 8717, 396, 11, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[284541, 8730, 218, 6, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[284762, 8738, 389, 9, 57, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[285154, 8749, 256, 7, 41, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[285413, 8758, 938, 31, 94, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[286354, 8791, 236, 8, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[286593, 8801, 318, 12, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[286914, 8815, 132, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[287049, 8820, 433, 10, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[287485, 8832, 314, 7, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[287802, 8841, 130, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[287935, 8846, 345, 8, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[288283, 8856, 226, 7, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[288512, 8865, 176, 6, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[288691, 8873, 140, 5, 34, "Subsubsubsection",
      CellTags->"UnixIntroduction"],
    Cell[288834, 8880, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[288973, 8885, 180, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[289156, 8891, 132, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[289291, 8896, 220, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[289514, 8904, 266, 6, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[289783, 8912, 187, 4, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[289973, 8918, 204, 5, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[290180, 8925, 338, 10, 44, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[290521, 8937, 130, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[290654, 8942, 107, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[290764, 8945, 272, 6, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[291039, 8953, 160, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[291202, 8959, 142, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[291347, 8965, 250, 5, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[291600, 8972, 213, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[291816, 8979, 345, 9, 43, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[292164, 8990, 127, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[292294, 8995, 219, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[292516, 9003, 250, 5, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[292769, 9010, 197, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[292969, 9017, 130, 2, 34, "Subsubsubsection",
      CellTags->"UnixIntroduction"],
    Cell[293102, 9021, 232, 7, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[293337, 9030, 186, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[293526, 9037, 395, 11, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[293924, 9050, 735, 19, 76, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[294662, 9071, 269, 9, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[294934, 9082, 157, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[295094, 9088, 122, 2, 34, "Subsubsubsection",
      CellTags->"UnixIntroduction"],
    Cell[295219, 9092, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[295358, 9097, 353, 7, 41, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[295714, 9106, 1421, 44, 146, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[297138, 9152, 692, 20, 59, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[297833, 9174, 330, 12, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[298166, 9188, 165, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[298334, 9194, 231, 8, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[298568, 9204, 130, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[298701, 9209, 191, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[298895, 9216, 132, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[299030, 9221, 173, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[299206, 9227, 175, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[299384, 9233, 214, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[299601, 9240, 175, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[299779, 9246, 216, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[299998, 9253, 73, 1, 34, "Subsubsubsection",
      CellTags->"UnixIntroduction"],
    Cell[300074, 9256, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[300213, 9261, 97, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[300313, 9264, 258, 6, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[300574, 9272, 132, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[300709, 9277, 131, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[300843, 9283, 309, 6, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[301155, 9291, 359, 8, 41, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[301517, 9301, 246, 5, 40, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[301766, 9308, 212, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[301981, 9315, 266, 7, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[302250, 9324, 164, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[302417, 9332, 130, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[302550, 9337, 166, 5, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[302719, 9344, 479, 15, 44, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[303201, 9361, 274, 8, 42, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[303478, 9371, 98, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[303579, 9374, 131, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[303713, 9380, 164, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[303880, 9388, 127, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[304010, 9393, 369, 10, 44, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[304382, 9405, 224, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[304609, 9413, 208, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[304820, 9421, 137, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[304960, 9427, 166, 5, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[305163, 9437, 104, 1, 34, "Subsubsection",
      CellTags->"UnixIntroduction"],
    Cell[305270, 9440, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[305409, 9445, 175, 4, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[305587, 9451, 88, 1, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[305678, 9454, 105, 1, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[305786, 9457, 360, 10, 44, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[306149, 9469, 136, 4, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[306288, 9475, 186, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[306477, 9483, 194, 6, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[306674, 9491, 332, 12, 44, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[307009, 9505, 294, 10, 44, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[307306, 9517, 229, 6, 44, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[307538, 9525, 132, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[307673, 9530, 141, 4, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[307851, 9539, 77, 1, 34, "Subsubsection",
      CellTags->"UnixIntroduction"],
    Cell[307931, 9542, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[308070, 9547, 82, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[308155, 9550, 285, 10, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[308443, 9562, 284, 7, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[308730, 9571, 164, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[308897, 9577, 191, 6, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[309091, 9585, 168, 6, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[309262, 9593, 212, 8, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[309477, 9603, 267, 9, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[309747, 9614, 86, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[309836, 9617, 97, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[309936, 9620, 92, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[310031, 9623, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[310170, 9628, 522, 17, 26, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[310695, 9647, 194, 5, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[310926, 9657, 77, 1, 34, "Subsubsection",
      CellTags->"UnixIntroduction"],
    Cell[311006, 9660, 136, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[311145, 9665, 1880, 47, 183, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[313028, 9714, 95, 1, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[313126, 9717, 235, 7, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[313364, 9726, 132, 3, 21, "Text",
      CellTags->"UnixIntroduction"],
    Cell[313499, 9731, 280, 8, 25, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[313782, 9741, 138, 4, 24, "BulletedList",
      CellTags->"UnixIntroduction"],
    Cell[313923, 9747, 331, 7, 40, "BulletedList",
      CellTags->"UnixIntroduction"]},
  "UnixInstalling"->{
    Cell[314303, 9760, 146, 6, 38, "Section",
      CellTags->"UnixInstalling"],
    Cell[314452, 9768, 299, 12, 38, "Text",
      CellTags->"UnixInstalling"],
    Cell[314776, 9784, 76, 1, 36, "Subsection",
      CellTags->"UnixInstalling"],
    Cell[314855, 9787, 115, 2, 24, "Text",
      CellTags->"UnixInstalling"],
    Cell[314973, 9791, 708, 20, 56, "Text",
      CellTags->"UnixInstalling"],
    Cell[315684, 9813, 580, 14, 51, "Text",
      CellTags->"UnixInstalling"],
    Cell[316267, 9829, 114, 2, 24, "Text",
      CellTags->"UnixInstalling"],
    Cell[316384, 9833, 162, 4, 22, "Text",
      CellTags->"UnixInstalling"],
    Cell[316583, 9842, 73, 1, 36, "Subsection",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[316659, 9845, 216, 6, 24, "Text",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[316900, 9855, 142, 2, 34, "Subsubsection",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[317045, 9859, 120, 2, 24, "Text",
      CellTags->{"parts", "mathlink.h", "UnixInstalling"}],
    Cell[317168, 9863, 574, 11, 52, "Text",
      CellTags->{"parts", "mathlink.h", "UnixInstalling"}],
    Cell[317745, 9876, 124, 2, 24, "Text",
      CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],
    Cell[317872, 9880, 472, 11, 54, "Text",
      CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],
    Cell[318347, 9893, 110, 2, 24, "Text",
      CellTags->{"parts", "mprep", "UnixInstalling"}],
    Cell[318460, 9897, 444, 10, 38, "Text",
      CellTags->{"parts", "mprep", "UnixInstalling"}],
    Cell[318907, 9909, 106, 2, 24, "Text",
      CellTags->{"parts", "mcc", "UnixInstalling"}],
    Cell[319016, 9913, 250, 7, 24, "Text",
      CellTags->{"parts", "mcc", "UnixInstalling"}],
    Cell[319303, 9925, 141, 2, 34, "Subsubsection",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[319447, 9929, 372, 10, 40, "Text",
      CellTags->{"parts", "UnixInstalling"}],
    Cell[319856, 9944, 150, 2, 34, "Subsubsection",
      CellTags->{"parts", "prebuilt", "UnixInstalling"}],
    Cell[320009, 9948, 942, 27, 56, "Text",
      CellTags->{"parts", "prebuilt", "UnixInstalling"}]},
  "UnixBuilding"->{
    Cell[321012, 9982, 136, 6, 38, "Section",
      CellTags->"UnixBuilding"],
    Cell[321151, 9990, 796, 17, 70, "Text",
      CellTags->"UnixBuilding"],
    Cell[321972, 10011, 121, 2, 36, "Subsection",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[322096, 10015, 1030, 22, 98, "Text",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323129, 10039, 79, 1, 22, "Text",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323211, 10042, 117, 1, 40, "FramedBox",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323331, 10045, 492, 9, 50, "Text",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[323826, 10056, 149, 2, 55, "FramedBox",
      CellTags->{"mprep", "UnixBuilding"}],
    Cell[324012, 10063, 139, 6, 36, "Subsection",
      CellTags->"UnixBuilding"],
    Cell[324154, 10071, 504, 11, 52, "Text",
      CellTags->"UnixBuilding"],
    Cell[324661, 10084, 86, 1, 40, "FramedBox",
      CellTags->"UnixBuilding"],
    Cell[324772, 10089, 61, 1, 34, "Subsubsection",
      CellTags->"UnixBuilding"],
    Cell[324836, 10092, 1673, 22, 925, "FramedBox",
      CellTags->"UnixBuilding"],
    Cell[326558, 10120, 115, 1, 36, "Subsection",
      CellTags->{"mcc", "UnixBuilding"}],
    Cell[326676, 10123, 753, 15, 52, "Text",
      CellTags->{"mcc", "UnixBuilding"}],
    Cell[327432, 10140, 116, 1, 40, "FramedBox",
      CellTags->{"mcc", "UnixBuilding"}],
    Cell[327585, 10146, 180, 6, 36, "Subsection",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[327768, 10154, 556, 15, 54, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[328327, 10171, 110, 1, 40, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[328440, 10174, 464, 10, 51, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[328929, 10188, 74, 1, 34, "Subsubsection",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[329006, 10191, 1703, 22, 925, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[330746, 10218, 187, 2, 34, "Subsubsection",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[330936, 10222, 247, 6, 22, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[331186, 10230, 139, 2, 40, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[331328, 10234, 199, 5, 36, "Text",
      CellTags->{"preANSI", "UnixBuilding"}],
    Cell[331530, 10241, 263, 3, 190, "FramedBox",
      CellTags->{"preANSI", "UnixBuilding"}]},
  "UnixRunning"->{
    Cell[331854, 10251, 134, 6, 38, "Section",
      CellTags->"UnixRunning"],
    Cell[331991, 10259, 341, 8, 38, "Text",
      CellTags->"UnixRunning"],
    Cell[332357, 10271, 124, 2, 36, "Subsection",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[332484, 10275, 1091, 31, 86, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[333578, 10308, 490, 6, 325, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334071, 10316, 129, 4, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334203, 10322, 116, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334322, 10326, 128, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334453, 10330, 141, 4, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334597, 10336, 90, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334690, 10340, 258, 7, 23, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[334951, 10349, 83, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335037, 10353, 66, 1, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335106, 10356, 86, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335195, 10360, 201, 5, 36, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335399, 10367, 111, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335513, 10371, 207, 3, 55, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335723, 10376, 121, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335847, 10380, 146, 2, 40, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[335996, 10384, 143, 3, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336142, 10389, 140, 2, 40, "FramedBox",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336285, 10393, 426, 13, 38, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336714, 10408, 81, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336798, 10412, 114, 1, 22, "Text",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[336915, 10415, 87, 2, 26, "Input",
      CellTags->{"addtwo", "UnixRunning"}],
    Cell[337039, 10422, 124, 2, 36, "Subsection",
      CellTags->{"factor", "UnixRunning"}],
    Cell[337166, 10426, 544, 13, 56, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[337713, 10441, 177, 4, 24, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[337893, 10447, 138, 2, 40, "FramedBox",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338034, 10451, 302, 6, 56, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338339, 10459, 104, 1, 40, "FramedBox",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338446, 10462, 312, 10, 24, "Text",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338761, 10474, 143, 2, 85, "FramedBox",
      CellTags->{"factor", "UnixRunning"}],
    Cell[338941, 10481, 88, 1, 36, "Subsection",
      CellTags->{"protocols", "UnixRunning"}],
    Cell[339032, 10484, 877, 21, 104, "Text",
      CellTags->{"protocols", "UnixRunning"}],
    Cell[339912, 10507, 391, 11, 40, "Text",
      CellTags->{"protocols", "UnixRunning"}]},
  "UnixPorting"->{
    Cell[340352, 10524, 146, 6, 38, "Section",
      CellTags->"UnixPorting"],
    Cell[340523, 10534, 184, 6, 41, "Subsection",
      CellTags->{"changes", "UnixPorting"}],
    Cell[340710, 10542, 504, 14, 56, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[341217, 10558, 1161, 28, 120, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[342381, 10588, 494, 10, 72, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[342878, 10600, 351, 8, 56, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[343232, 10610, 289, 7, 40, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[343546, 10621, 107, 1, 34, "Subsubsection",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[343656, 10624, 1036, 26, 104, "Text",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[344695, 10652, 1046, 22, 120, "Text",
      CellTags->{"changes", "strings", "UnixPorting"}],
    Cell[345744, 10676, 426, 10, 40, "Text",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
    Cell[346173, 10688, 411, 5, 235, "FramedBox",
      CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
    Cell[346587, 10695, 651, 13, 72, "Text",
      CellTags->{"MLNextCharacter", "changes", "strings", "UnixPorting"}],
    Cell[347241, 10710, 513, 6, 295, "FramedBox",
      CellTags->{"changes", "strings", "MLNextCharacter", "UnixPorting"}],
    Cell[347757, 10718, 598, 17, 56, "Text",
      CellTags->{"MLPutCharToString", "changes", "strings", "UnixPorting"}],
    Cell[348358, 10737, 556, 7, 340, "FramedBox",
      CellTags->{"changes", "strings", "MLPutCharToString", "UnixPorting"}],
    Cell[348917, 10746, 749, 17, 88, "Text",
      CellTags->{
      "MLConvertUnicodeString", "changes", "strings", "UnixPorting"}],
    Cell[349669, 10765, 604, 7, 355, "FramedBox",
      CellTags->{
      "changes", "strings", "MLConvertUnicodeString", "UnixPorting"}],
    Cell[350310, 10777, 83, 1, 34, "Subsubsection",
      CellTags->{"changes", "UnixPorting"}],
    Cell[350396, 10780, 143, 4, 26, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[350542, 10786, 839, 14, 134, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[351384, 10802, 435, 11, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[351822, 10815, 192, 2, 100, "FramedBox",
      CellTags->{"changes", "UnixPorting"}],
    Cell[352017, 10819, 528, 15, 62, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[352548, 10836, 624, 18, 80, "BulletedList",
      CellTags->{"MLGetArgCount", "changes", "UnixPorting"}],
    Cell[353175, 10856, 518, 15, 62, "BulletedList",
      CellTags->{"MLGetData", "changes", "UnixPorting"}],
    Cell[353696, 10873, 661, 20, 80, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[354360, 10895, 670, 15, 98, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[355033, 10912, 387, 12, 42, "IndentedText",
      CellTags->{"changes", "UnixPorting"}],
    Cell[355423, 10926, 642, 17, 78, "IndentedText",
      CellTags->{"changes", "UnixPorting"}],
    Cell[356068, 10945, 269, 7, 44, "BulletedList",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[356340, 10954, 200, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[356543, 10958, 585, 14, 60, "IndentedText",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[357131, 10974, 215, 2, 70, "FramedBox",
      CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
    Cell[357349, 10978, 1104, 36, 116, "BulletedList",
      CellTags->{"MLBytesToGet", "changes", "UnixPorting"}],
    Cell[358456, 11016, 513, 11, 62, "BulletedList",
      CellTags->{"MLPutFunction", "changes", "UnixPorting"}],
    Cell[358972, 11029, 303, 9, 44, "BulletedList",
      CellTags->{"MLInitialize", "changes", "UnixPorting"}],
    Cell[359278, 11040, 303, 9, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[359584, 11051, 338, 10, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[359925, 11063, 284, 7, 44, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[360212, 11072, 948, 21, 116, "BulletedList",
      CellTags->{"changes", "UnixPorting"}],
    Cell[361163, 11095, 692, 17, 280, "FramedBox",
      CellTags->{"changes", "UnixPorting"}],
    Cell[361858, 11114, 1414, 33, 168, "IndentedText",
      CellTags->{"changes", "UnixPorting"}],
    Cell[363309, 11152, 76, 1, 34, "Subsubsection",
      CellTags->{"changes", "UnixPorting"}],
    Cell[363388, 11155, 267, 6, 40, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[363658, 11163, 273, 5, 40, "Text",
      CellTags->{"MLPutUnicodeString", "changes", "UnixPorting"}],
    Cell[363934, 11170, 337, 4, 70, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[364274, 11176, 871, 21, 88, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365148, 11199, 339, 4, 85, "FramedBox",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365490, 11205, 127, 1, 24, "Text",
      CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
    Cell[365620, 11208, 406, 13, 40, "Text",
      CellTags->{"MLPutNext", "changes", "UnixPorting"}],
    Cell[366029, 11223, 166, 2, 55, "FramedBox",
      CellTags->{"changes", "MLPutNext", "UnixPorting"}],
    Cell[366198, 11227, 127, 1, 24, "Text",
      CellTags->{"MLGetUnicodeString", "changes", "UnixPorting"}],
    Cell[366328, 11230, 214, 2, 85, "FramedBox",
      CellTags->{"changes", "MLGetUnicodeString", "UnixPorting"}],
    Cell[366545, 11234, 556, 15, 56, "Text",
      CellTags->{"changes", "UnixPorting"}],
    Cell[367104, 11251, 210, 6, 24, "Text",
      CellTags->{"changes", "UnixPorting"}]},
  "UnixTroubleshooting"->{
    Cell[367375, 11264, 69, 1, 38, "Section",
      CellTags->"UnixTroubleshooting"],
    Cell[367447, 11267, 642, 10, 116, "BulletedList",
      CellTags->"UnixTroubleshooting"],
    Cell[368092, 11279, 388, 12, 44, "BulletedList",
      CellTags->"UnixTroubleshooting"],
    Cell[368483, 11293, 406, 9, 44, "BulletedList",
      CellTags->"UnixTroubleshooting"],
    Cell[368892, 11304, 372, 9, 62, "BulletedList",
      CellTags->"UnixTroubleshooting"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"WindowsIntroduction", 615743, 19987},
  {"WindowsOverview", 632973, 20376},
  {"WindowsCompilers", 633395, 20387},
  {"Microsoft", 634619, 20414},
  {"languages", 651579, 20744},
  {"WindowsInstalling", 651799, 20749},
  {"Recommended Installation", 662514, 20963},
  {"parts", 664138, 20997},
  {"MathLinkLibraries", 675072, 21210},
  {"devices", 675980, 21227},
  {"FileMap", 679986, 21300},
  {"TCP", 681706, 21331},
  {"mathlink.h", 683482, 21364},
  {"mprep", 684119, 21377},
  {"prebuilt", 686366, 21426},
  {"sample code", 687024, 21439},
  {"WindowsRunning", 687269, 21444},
  {"addtwo", 691812, 21543},
  {"factor", 697884, 21680},
  {"protocols", 700822, 21743},
  {"WindowsBuilding", 702147, 21772},
  {"Versioning", 720037, 22121},
  {"WindowsTroubleshooting", 722231, 22166},
  {"MacIntroduction", 723100, 22185},
  {"MacInstalling", 736622, 22500},
  {"mcc", 738744, 22547},
  {"MacBuilding", 739680, 22568},
  {"ProjectBuilder", 748660, 22743},
  {"preANSI", 755263, 22864},
  {"MacRunning", 757337, 22909},
  {"MacPorting", 760506, 22982},
  {"changes", 766315, 23097},
  {"strings", 777819, 23320},
  {"MLforString", 780455, 23369},
  {"MLNextCharacter", 780949, 23378},
  {"MLPutCharToString", 781461, 23387},
  {"MLConvertUnicodeString", 781986, 23396},
  {"MLGetArgCount", 782550, 23409},
  {"MLGetData", 782796, 23414},
  {"MLGetByteString", 783040, 23419},
  {"MLBytesToGet", 783971, 23436},
  {"MLPutFunction", 784223, 23441},
  {"MLInitialize", 784472, 23446},
  {"MLPutUnicodeString", 784723, 23451},
  {"MLPutNext", 786084, 23476},
  {"MLGetUnicodeString", 786527, 23485},
  {"MacTroubleshooting", 787004, 23494},
  {"UnixIntroduction", 787476, 23505},
  {"UnixInstalling", 801244, 23822},
  {"UnixBuilding", 803398, 23869},
  {"UnixRunning", 805840, 23924},
  {"UnixPorting", 809081, 23997},
  {"UnixTroubleshooting", 815034, 24112}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 148, 5, 118, "Chapter",
  CellTags->"WindowsIntroduction"],
Cell[1927, 60, 108, 4, 40, "CopyrightHead",
  CellTags->"WindowsIntroduction"],
Cell[2038, 66, 158, 4, 22, "Text",
  CellTags->"WindowsIntroduction"],
Cell[2199, 72, 689, 22, 72, "Text",
  CellTags->"WindowsIntroduction"],
Cell[2891, 96, 556, 10, 80, "Text",
  CellTags->"WindowsIntroduction"],
Cell[3450, 108, 297, 8, 38, "Text",
  CellTags->"WindowsIntroduction"],

Cell[CellGroupData[{
Cell[3772, 120, 73, 1, 36, "Subsection",
  CellTags->"WindowsIntroduction"],

Cell[CellGroupData[{
Cell[3870, 125, 82, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[3955, 128, 157, 4, 40, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[4115, 134, 453, 9, 74, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[4571, 145, 117, 2, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[4691, 149, 114, 1, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[4808, 152, 1334, 19, 248, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[6145, 173, 149, 4, 24, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[6331, 182, 82, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[6416, 185, 636, 12, 98, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[7055, 199, 279, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[7337, 208, 791, 18, 98, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[8131, 228, 447, 11, 62, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[8581, 241, 1239, 22, 152, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[9823, 265, 276, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[10136, 277, 82, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[10221, 280, 100, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[10324, 283, 98, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[10425, 286, 85, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[10547, 292, 84, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[10634, 295, 85, 1, 34, "Subsubsubsection",
  CellTags->"WindowsIntroduction"],
Cell[10722, 298, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[10864, 303, 244, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[11111, 312, 133, 2, 34, "Subsubsubsection",
  CellTags->"WindowsIntroduction"],
Cell[11247, 316, 235, 7, 26, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[11519, 328, 84, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[11606, 331, 85, 1, 34, "Subsubsubsection",
  CellTags->"WindowsIntroduction"],
Cell[11694, 334, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[11836, 339, 136, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[11975, 345, 111, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[12089, 348, 120, 2, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[12212, 352, 174, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[12389, 360, 214, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[12606, 368, 281, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[12890, 377, 750, 21, 80, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[13643, 400, 167, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[13813, 407, 272, 9, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[14088, 418, 130, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[14221, 424, 307, 10, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[14531, 436, 288, 9, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[14822, 447, 343, 10, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[15168, 459, 168, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[15339, 465, 195, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[15537, 473, 399, 11, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[15939, 486, 221, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[16163, 494, 392, 9, 62, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[16558, 505, 259, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[16820, 514, 941, 31, 98, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[17764, 547, 239, 8, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[18006, 557, 321, 12, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[18330, 571, 135, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[18468, 576, 436, 10, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[18907, 588, 317, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[19227, 597, 133, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[19363, 602, 348, 8, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[19714, 612, 221, 7, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[19938, 621, 179, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[20120, 629, 143, 5, 34, "Subsubsubsection",
  CellTags->"WindowsIntroduction"],
Cell[20266, 636, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[20408, 641, 183, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[20594, 647, 135, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[20732, 652, 223, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[20958, 660, 269, 6, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[21230, 668, 190, 4, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[21423, 674, 207, 5, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[21633, 681, 341, 10, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[21977, 693, 133, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[22113, 698, 110, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[22226, 701, 275, 6, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[22504, 709, 163, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[22670, 715, 145, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[22818, 721, 253, 5, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[23074, 728, 216, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[23293, 735, 348, 9, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[23644, 746, 130, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[23777, 751, 222, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[24002, 759, 253, 5, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[24258, 766, 200, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[24461, 773, 133, 2, 34, "Subsubsubsection",
  CellTags->"WindowsIntroduction"],
Cell[24597, 777, 235, 7, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[24835, 786, 189, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[25027, 793, 398, 11, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[25428, 806, 738, 19, 80, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[26169, 827, 272, 9, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[26444, 838, 160, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[26607, 844, 125, 2, 34, "Subsubsubsection",
  CellTags->"WindowsIntroduction"],
Cell[26735, 848, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[26877, 853, 356, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[27236, 862, 1424, 44, 151, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[28663, 908, 695, 20, 62, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[29361, 930, 333, 12, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[29697, 944, 168, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[29868, 950, 234, 8, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[30105, 960, 133, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[30241, 965, 194, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[30438, 972, 135, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[30576, 977, 176, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[30755, 983, 178, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[30936, 989, 217, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[31156, 996, 178, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[31337, 1002, 219, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[31559, 1009, 76, 1, 34, "Subsubsubsection",
  CellTags->"WindowsIntroduction"],
Cell[31638, 1012, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[31780, 1017, 100, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[31883, 1020, 261, 6, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[32147, 1028, 135, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[32285, 1033, 134, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[32422, 1039, 312, 6, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[32737, 1047, 362, 8, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[33102, 1057, 249, 5, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[33354, 1064, 215, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[33572, 1071, 269, 7, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[33844, 1080, 167, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[34014, 1088, 133, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[34150, 1093, 169, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[34322, 1100, 482, 15, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[34807, 1117, 277, 8, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[35087, 1127, 101, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[35191, 1130, 134, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[35328, 1136, 167, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[35498, 1144, 130, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[35631, 1149, 372, 10, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[36006, 1161, 227, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[36236, 1169, 211, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[36450, 1177, 140, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[36593, 1183, 169, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[36799, 1193, 107, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[36909, 1196, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[37051, 1201, 178, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[37232, 1207, 91, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[37326, 1210, 108, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[37437, 1213, 363, 10, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[37803, 1225, 139, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[37945, 1231, 189, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[38137, 1239, 197, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[38337, 1247, 335, 12, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[38675, 1261, 297, 10, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[38975, 1273, 232, 6, 44, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[39210, 1281, 135, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[39348, 1286, 144, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[39529, 1295, 80, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[39612, 1298, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[39754, 1303, 85, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[39842, 1306, 288, 10, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[40133, 1318, 287, 7, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[40423, 1327, 167, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[40593, 1333, 194, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[40790, 1341, 171, 6, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[40964, 1349, 215, 8, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[41182, 1359, 270, 9, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[41455, 1370, 89, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[41547, 1373, 100, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[41650, 1376, 95, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[41748, 1379, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[41890, 1384, 525, 17, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[42418, 1403, 197, 5, 26, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[42652, 1413, 80, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[42735, 1416, 139, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[42877, 1421, 1883, 47, 206, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[44763, 1470, 98, 1, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[44864, 1473, 238, 7, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[45105, 1482, 135, 3, 21, "Text",
  CellTags->"WindowsIntroduction"],
Cell[45243, 1487, 283, 8, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[45529, 1497, 141, 4, 26, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[45673, 1503, 334, 7, 44, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[46056, 1516, 58, 1, 38, "Section",
  CellTags->"WindowsOverview"],
Cell[46117, 1519, 1082, 24, 136, "Text",
  CellTags->"WindowsOverview"],
Cell[47202, 1545, 423, 9, 56, "Text",
  CellTags->"WindowsOverview"],
Cell[47628, 1556, 383, 11, 40, "Text",
  CellTags->"WindowsOverview"],
Cell[48014, 1569, 615, 15, 72, "Text",
  CellTags->"WindowsOverview"]
}, Closed]],

Cell[CellGroupData[{
Cell[48666, 1589, 70, 1, 38, "Section",
  CellTags->"WindowsCompilers"],
Cell[48739, 1592, 465, 11, 56, "Text",
  CellTags->"WindowsCompilers"],
Cell[49207, 1605, 525, 9, 72, "Text",
  CellTags->"WindowsCompilers"],

Cell[CellGroupData[{
Cell[49757, 1618, 106, 1, 36, "Subsection",
  CellTags->{"Microsoft", "WindowsCompilers"}],
Cell[49866, 1621, 101, 1, 24, "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}],
Cell[49970, 1624, 566, 16, 64, "SmallText",
  CellTags->{"Microsoft", "WindowsCompilers"}],
Cell[50539, 1642, 98, 1, 24, "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}],
Cell[50640, 1645, 80, 1, 22, "SmallText",
  CellTags->{"Microsoft", "WindowsCompilers"}],
Cell[50723, 1648, 121, 1, 24, "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}],
Cell[50847, 1651, 224, 4, 22, "SmallText",
  CellTags->{"Microsoft", "WindowsCompilers"}],
Cell[51074, 1657, 120, 1, 24, "Text",
  CellTags->{"Microsoft", "WindowsCompilers"}]
}, Closed]],

Cell[CellGroupData[{
Cell[51231, 1663, 95, 1, 36, "Subsection",
  CellTags->{"languages", "WindowsCompilers"}],
Cell[51329, 1666, 757, 14, 72, "Text",
  CellTags->{"languages", "WindowsCompilers"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52135, 1686, 149, 6, 38, "Section",
  CellTags->"WindowsInstalling"],
Cell[52287, 1694, 387, 11, 40, "Text",
  CellTags->"WindowsInstalling"],
Cell[52677, 1707, 1065, 31, 88, "Text",
  CellTags->"WindowsInstalling"],
Cell[53745, 1740, 563, 14, 72, "Text",
  CellTags->"WindowsInstalling"],
Cell[54311, 1756, 159, 4, 57, "FramedBox",
  CellTags->"WindowsInstalling"],
Cell[54473, 1762, 298, 7, 40, "Text",
  CellTags->"WindowsInstalling"],
Cell[54774, 1771, 169, 3, 42, "Input",
  CellTags->"WindowsInstalling"],
Cell[54946, 1776, 77, 1, 24, "Text",
  CellTags->"WindowsInstalling"],
Cell[55026, 1779, 199, 5, 22, "SmallText",
  CellTags->"WindowsInstalling"],
Cell[55228, 1786, 141, 4, 24, "Text",
  CellTags->"WindowsInstalling"],
Cell[55372, 1792, 182, 4, 42, "Input",
  CellTags->"WindowsInstalling"],

Cell[CellGroupData[{
Cell[55579, 1800, 109, 1, 36, "Subsection",
  CellTags->{"Recommended Installation", "WindowsInstalling"}],

Cell[CellGroupData[{
Cell[55713, 1805, 130, 1, 34, "Subsubsection",
  CellTags->{"Recommended Installation", "WindowsInstalling"}],
Cell[55846, 1808, 1070, 29, 88, "Text",
  CellTags->{"Recommended Installation", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[56953, 1842, 151, 1, 34, "Subsubsection",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[57107, 1845, 537, 11, 56, "Text",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[57647, 1858, 578, 11, 40, "NumberedGesture",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[58228, 1871, 270, 6, 22, "SmallText",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[58501, 1879, 238, 6, 24, "NumberedGestureRemark",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[58742, 1887, 446, 13, 46, "NumberedGesture",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[59191, 1902, 325, 7, 24, "NumberedGesture",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[59519, 1911, 359, 6, 40, "NumberedGestureRemark",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[59915, 1922, 142, 1, 34, "Subsubsection",
  CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"}],
Cell[60060, 1925, 462, 11, 56, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[60571, 1942, 150, 6, 36, "Subsection",
  CellTags->"WindowsInstalling"],
Cell[60724, 1950, 319, 7, 40, "Text",
  CellTags->"WindowsInstalling"],
Cell[61046, 1959, 583, 11, 72, "Text",
  CellTags->"WindowsInstalling"]
}, Closed]],

Cell[CellGroupData[{
Cell[61666, 1975, 76, 1, 36, "Subsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[61745, 1978, 419, 10, 40, "Text",
  CellTags->{"parts", "WindowsInstalling"}],

Cell[CellGroupData[{
Cell[62189, 1992, 156, 4, 34, "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[62348, 1998, 1334, 36, 88, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[63685, 2036, 163, 2, 23, "Text",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
Cell[63851, 2040, 1221, 29, 120, "Text",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
Cell[65075, 2071, 163, 2, 23, "Text",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
Cell[65241, 2075, 465, 11, 40, "Text",
  CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"}],
Cell[65709, 2088, 166, 6, 34, "Subsubsubsection",
  CellTags->{"devices", "parts", "WindowsInstalling"}],
Cell[65878, 2096, 608, 16, 56, "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],
Cell[66489, 2114, 467, 11, 56, "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],
Cell[66959, 2127, 343, 8, 40, "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],
Cell[67305, 2137, 531, 14, 69, "Text",
  CellTags->{"devices", "parts", "WindowsInstalling"}],
Cell[67839, 2153, 146, 3, 24, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[67988, 2158, 165, 2, 23, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[68156, 2162, 522, 12, 56, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[68681, 2176, 121, 1, 24, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[68805, 2179, 270, 3, 70, "FramedBox",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[69078, 2184, 198, 6, 24, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[69279, 2192, 199, 3, 26, "Input",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[69481, 2197, 135, 3, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[69619, 2202, 163, 2, 23, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[69785, 2206, 517, 12, 56, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[70305, 2220, 117, 1, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[70425, 2223, 260, 3, 70, "FramedBox",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[70688, 2228, 194, 6, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[70885, 2236, 189, 3, 26, "Input",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[71077, 2241, 298, 7, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[71378, 2250, 141, 3, 24, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[71522, 2255, 165, 2, 23, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[71690, 2259, 401, 9, 40, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[72094, 2270, 121, 1, 24, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[72218, 2273, 265, 3, 70, "FramedBox",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[72486, 2278, 198, 6, 24, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[72687, 2286, 194, 3, 26, "Input",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[72884, 2291, 234, 6, 24, "Text",
  CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"}],
Cell[73121, 2299, 133, 3, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[73257, 2304, 161, 2, 23, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[73421, 2308, 396, 9, 40, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[73820, 2319, 117, 1, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[73940, 2322, 258, 3, 55, "FramedBox",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[74201, 2327, 194, 6, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[74398, 2335, 187, 3, 26, "Input",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[74588, 2340, 296, 7, 24, "Text",
  CellTags->{"devices", "TCP", "parts", "WindowsInstalling"}],
Cell[74887, 2349, 266, 6, 40, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[75190, 2360, 157, 4, 34, "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[75350, 2366, 165, 4, 34, "Subsubsubsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[75518, 2372, 156, 2, 23, "Text",
  CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
Cell[75677, 2376, 719, 11, 88, "Text",
  CellTags->{"mathlink.h", "parts", "WindowsInstalling"}],
Cell[76399, 2389, 149, 2, 34, "Subsubsubsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[76551, 2393, 521, 10, 72, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[77075, 2405, 143, 2, 23, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[77221, 2409, 509, 10, 72, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[77733, 2421, 205, 5, 24, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[77941, 2428, 143, 2, 23, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[78087, 2432, 561, 11, 72, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[78651, 2445, 143, 2, 23, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[78797, 2449, 538, 12, 56, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[79338, 2463, 143, 2, 23, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[79484, 2467, 575, 12, 72, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[80062, 2481, 143, 2, 23, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[80208, 2485, 504, 12, 56, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[80715, 2499, 399, 8, 23, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[81117, 2509, 358, 10, 40, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[81478, 2521, 149, 2, 34, "Subsubsubsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[81630, 2525, 150, 2, 23, "Text",
  CellTags->{"mprep", "parts", "WindowsInstalling"}],
Cell[81783, 2529, 477, 10, 40, "Text",
  CellTags->{"mprep", "parts", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[82297, 2544, 168, 4, 34, "Subsubsection",
  CellTags->{"prebuilt", "parts", "WindowsInstalling"}],
Cell[82468, 2550, 944, 27, 56, "Text",
  CellTags->{"prebuilt", "parts", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[83449, 2582, 171, 4, 34, "Subsubsection",
  CellTags->{"parts", "sample code", "WindowsInstalling"}],
Cell[83623, 2588, 387, 10, 40, "Text",
  CellTags->{"parts", "sample code", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[84047, 2603, 157, 4, 34, "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[84207, 2609, 158, 4, 24, "Text",
  CellTags->{"parts", "WindowsInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[84402, 2618, 162, 4, 34, "Subsubsection",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[84567, 2624, 322, 7, 40, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[84892, 2633, 146, 2, 23, "Text",
  CellTags->{"parts", "WindowsInstalling"}],
Cell[85041, 2637, 412, 9, 40, "Text",
  CellTags->{"parts", "WindowsInstalling"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[85514, 2653, 137, 6, 38, "Section",
  CellTags->"WindowsRunning"],
Cell[85654, 2661, 828, 17, 93, "Text",
  CellTags->"WindowsRunning"],
Cell[86485, 2680, 282, 7, 42, "Text",
  CellTags->"WindowsRunning"],
Cell[86770, 2689, 1330, 25, 161, "Text",
  CellTags->"WindowsRunning"],

Cell[CellGroupData[{
Cell[88125, 2718, 127, 2, 39, "Subsection",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[88255, 2722, 1094, 31, 93, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[89352, 2755, 832, 11, 518, "FramedBox",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[90187, 2768, 327, 7, 42, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[90517, 2777, 113, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[90633, 2781, 144, 4, 25, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[90780, 2787, 93, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[90876, 2791, 263, 7, 25, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[91142, 2800, 86, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[91231, 2804, 69, 1, 25, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[91303, 2807, 89, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[91395, 2811, 204, 5, 42, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[91602, 2818, 114, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[91719, 2822, 187, 5, 31, "Caption",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[91909, 2829, 124, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[92036, 2833, 119, 1, 17, "Caption",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[92158, 2836, 146, 3, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[92307, 2841, 113, 1, 17, "Caption",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[92423, 2844, 429, 13, 42, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[92855, 2859, 84, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[92942, 2863, 116, 1, 25, "Text",
  CellTags->{"addtwo", "WindowsRunning"}],
Cell[93061, 2866, 90, 2, 29, "Input",
  CellTags->{"addtwo", "WindowsRunning"}]
}, Closed]],

Cell[CellGroupData[{
Cell[93188, 2873, 127, 2, 39, "Subsection",
  CellTags->{"factor", "WindowsRunning"}],
Cell[93318, 2877, 547, 13, 59, "Text",
  CellTags->{"factor", "WindowsRunning"}],
Cell[93868, 2892, 819, 21, 77, "Text",
  CellTags->{"factor", "WindowsRunning"}],
Cell[94690, 2915, 110, 1, 25, "NumberedGestureHead",
  CellTags->{"factor", "WindowsRunning"}],
Cell[94803, 2918, 188, 6, 25, "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],
Cell[94994, 2926, 247, 7, 25, "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],
Cell[95244, 2935, 185, 6, 25, "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],
Cell[95432, 2943, 107, 1, 42, "FramedBox",
  CellTags->{"factor", "WindowsRunning"}],
Cell[95542, 2946, 136, 2, 25, "NumberedGestureRemark",
  CellTags->{"factor", "WindowsRunning"}],
Cell[95681, 2950, 176, 6, 25, "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],
Cell[95860, 2958, 158, 4, 25, "NumberedGestureRemark",
  CellTags->{"factor", "WindowsRunning"}],
Cell[96021, 2964, 362, 10, 46, "NumberedGesture",
  CellTags->{"factor", "WindowsRunning"}],
Cell[96386, 2976, 117, 1, 42, "FramedBox",
  CellTags->{"factor", "WindowsRunning"}],
Cell[96506, 2979, 332, 10, 25, "NumberedGestureRemark",
  CellTags->{"factor", "WindowsRunning"}],
Cell[96841, 2991, 363, 12, 93, "FramedBox",
  CellTags->{"factor", "WindowsRunning"}]
}, Closed]],

Cell[CellGroupData[{
Cell[97241, 3008, 91, 1, 39, "Subsection",
  CellTags->{"protocols", "WindowsRunning"}],
Cell[97335, 3011, 897, 22, 72, "Text",
  CellTags->{"protocols", "WindowsRunning"}],
Cell[98235, 3035, 796, 17, 72, "Text",
  CellTags->{"protocols", "WindowsRunning"}],
Cell[99034, 3054, 338, 8, 40, "Text",
  CellTags->{"protocols", "WindowsRunning"}],
Cell[99375, 3064, 167, 4, 26, "Input",
  CellTags->{"protocols", "WindowsRunning"}],
Cell[99545, 3070, 254, 6, 24, "Text",
  CellTags->{"protocols", "WindowsRunning"}],
Cell[99802, 3078, 133, 3, 26, "Input",
  CellTags->{"protocols", "WindowsRunning"}],
Cell[99938, 3083, 136, 2, 24, "Text",
  CellTags->{"protocols", "WindowsRunning"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[100123, 3091, 139, 6, 38, "Section",
  CellTags->"WindowsBuilding"],
Cell[100265, 3099, 885, 20, 100, "Text",
  CellTags->"WindowsBuilding"],
Cell[101153, 3121, 575, 13, 82, "Text",
  CellTags->"WindowsBuilding"],

Cell[CellGroupData[{
Cell[101753, 3138, 151, 5, 36, "Subsection",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[101907, 3145, 443, 11, 56, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],

Cell[CellGroupData[{
Cell[102375, 3160, 80, 1, 34, "Subsubsection",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[102458, 3163, 474, 13, 56, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[102935, 3178, 442, 11, 56, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[103380, 3191, 772, 16, 104, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[104155, 3209, 438, 12, 56, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[104596, 3223, 89, 1, 26, "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[104688, 3226, 384, 10, 43, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[105075, 3238, 90, 1, 26, "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[105168, 3241, 388, 10, 43, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[105559, 3253, 89, 1, 26, "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[105651, 3256, 463, 12, 61, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[106117, 3270, 90, 1, 26, "BulletedList",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[106210, 3273, 593, 14, 81, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[106806, 3289, 235, 5, 40, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[107044, 3296, 629, 13, 88, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[107710, 3314, 97, 1, 34, "Subsubsection",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[107810, 3317, 769, 17, 88, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[108582, 3336, 583, 11, 72, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[109202, 3352, 97, 1, 34, "Subsubsection",
  CellTags->{"Versioning", "WindowsBuilding"}],
Cell[109302, 3355, 921, 22, 104, "Text",
  CellTags->{"Versioning", "WindowsBuilding"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[110272, 3383, 124, 2, 36, "Subsection",
  CellTags->{"mprep", "WindowsBuilding"}],
Cell[110399, 3387, 1036, 22, 104, "Text",
  CellTags->{"mprep", "WindowsBuilding"}],
Cell[111438, 3411, 83, 1, 24, "Text",
  CellTags->{"mprep", "WindowsBuilding"}],
Cell[111524, 3414, 120, 1, 40, "FramedBox",
  CellTags->{"mprep", "WindowsBuilding"}],
Cell[111647, 3417, 495, 9, 56, "Text",
  CellTags->{"mprep", "WindowsBuilding"}],
Cell[112145, 3428, 152, 2, 55, "FramedBox",
  CellTags->{"mprep", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[112334, 3435, 178, 6, 36, "Subsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],

Cell[CellGroupData[{
Cell[112537, 3445, 121, 1, 34, "Subsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[112661, 3448, 825, 15, 104, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[113489, 3465, 150, 2, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[113642, 3469, 115, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[113760, 3472, 192, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[113955, 3480, 328, 8, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[114286, 3490, 272, 7, 71, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[114561, 3499, 193, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[114757, 3507, 472, 6, 130, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[115232, 3515, 97, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[115332, 3518, 196, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[115531, 3526, 202, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[115736, 3534, 116, 1, 24, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[115855, 3537, 261, 8, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[116119, 3547, 214, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[116336, 3555, 205, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[116544, 3563, 241, 7, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[116788, 3572, 314, 6, 56, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[117105, 3580, 150, 2, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[117258, 3584, 115, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[117376, 3587, 192, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[117571, 3595, 328, 8, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[117902, 3605, 272, 7, 71, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[118177, 3614, 194, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[118374, 3622, 409, 5, 115, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[118786, 3629, 97, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[118886, 3632, 194, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[119083, 3640, 202, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[119288, 3648, 116, 1, 24, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[119407, 3651, 261, 8, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[119671, 3661, 214, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[119888, 3669, 205, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[120096, 3677, 202, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[120301, 3685, 119, 1, 24, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[120423, 3688, 213, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[120639, 3696, 111, 1, 24, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[120753, 3699, 262, 9, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[121018, 3710, 181, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[121202, 3718, 241, 7, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[121446, 3727, 371, 10, 40, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[121820, 3739, 314, 6, 56, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[122137, 3747, 162, 4, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[122302, 3753, 120, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[122425, 3756, 192, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[122620, 3764, 328, 8, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[122951, 3774, 272, 7, 71, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[123226, 3783, 193, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[123422, 3791, 461, 6, 130, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[123886, 3799, 162, 4, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[124051, 3805, 120, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[124174, 3808, 192, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[124369, 3816, 328, 8, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[124700, 3826, 272, 7, 71, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[124975, 3835, 194, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[125172, 3843, 393, 5, 100, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[125568, 3850, 108, 1, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[125679, 3853, 1601, 34, 311, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[127283, 3889, 106, 1, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[127392, 3892, 1168, 25, 235, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[128563, 3919, 100, 1, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[128666, 3922, 610, 14, 81, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[129279, 3938, 72, 1, 26, "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[129354, 3941, 802, 18, 139, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[130159, 3961, 72, 1, 26, "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[130234, 3964, 537, 13, 63, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[130774, 3979, 72, 1, 26, "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[130849, 3982, 619, 14, 101, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[131471, 3998, 72, 1, 26, "Input",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[131546, 4001, 545, 13, 61, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[132128, 4019, 108, 1, 34, "Subsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[132239, 4022, 873, 14, 120, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[133115, 4038, 150, 3, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[133268, 4043, 121, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[133392, 4046, 226, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[133621, 4054, 661, 9, 370, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[134285, 4065, 398, 9, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[134686, 4076, 192, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[134881, 4084, 241, 7, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[135125, 4093, 193, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[135321, 4101, 258, 6, 55, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[135582, 4109, 153, 4, 24, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[135738, 4115, 874, 15, 88, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[136615, 4132, 433, 11, 56, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[137051, 4145, 1006, 23, 174, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[138060, 4170, 150, 3, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[138213, 4175, 121, 1, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[138337, 4178, 226, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[138566, 4186, 492, 6, 250, "FramedBox",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[139061, 4194, 398, 9, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[139462, 4205, 192, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[139657, 4213, 241, 7, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[139901, 4222, 193, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[140097, 4230, 253, 6, 46, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[140387, 4241, 145, 4, 34, "Subsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[140535, 4247, 112, 2, 24, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[140650, 4251, 209, 6, 24, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[140862, 4259, 1361, 35, 117, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[142226, 4296, 1573, 45, 115, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[143802, 4343, 268, 7, 54, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[144073, 4352, 996, 34, 113, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[145072, 4388, 130, 2, 24, "Text",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[145205, 4392, 174, 4, 22, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[145382, 4398, 190, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[145575, 4406, 180, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[145758, 4414, 118, 1, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[145879, 4417, 323, 8, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[146205, 4427, 784, 25, 82, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[146992, 4454, 131, 2, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[147126, 4458, 282, 7, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[147411, 4467, 262, 6, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[147676, 4475, 122, 1, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[147801, 4478, 255, 7, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[148059, 4487, 336, 9, 37, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[148398, 4498, 117, 1, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[148518, 4501, 212, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[148733, 4509, 286, 7, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[149022, 4518, 122, 1, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[149147, 4521, 322, 9, 39, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[149472, 4532, 255, 7, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[149730, 4541, 131, 2, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[149864, 4545, 418, 9, 80, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[150285, 4556, 239, 7, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[150527, 4565, 183, 5, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[150713, 4572, 357, 8, 52, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[151073, 4582, 558, 17, 54, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[151634, 4601, 173, 4, 34, "Subsubsubsection",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[151810, 4607, 218, 5, 22, "NumberedGestureHead",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[152031, 4614, 190, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[152224, 4622, 180, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[152407, 4630, 118, 1, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[152528, 4633, 323, 8, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[152854, 4643, 784, 25, 82, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[153641, 4670, 131, 2, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[153775, 4674, 282, 7, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[154060, 4683, 262, 6, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[154325, 4691, 122, 1, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[154450, 4694, 214, 6, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[154667, 4702, 285, 7, 38, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[154955, 4711, 122, 1, 22, "NumberedGestureRemark",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[155080, 4714, 321, 9, 39, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[155404, 4725, 183, 5, 24, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}],
Cell[155590, 4732, 558, 17, 54, "NumberedGesture",
  CellTags->{"Microsoft", "WindowsBuilding"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[156209, 4756, 72, 1, 38, "Section",
  CellTags->"WindowsTroubleshooting"],
Cell[156284, 4759, 292, 7, 42, "BulletedList",
  CellTags->"WindowsTroubleshooting"],
Cell[156579, 4768, 435, 11, 76, "BulletedList",
  CellTags->"WindowsTroubleshooting"],
Cell[157017, 4781, 645, 10, 120, "BulletedList",
  CellTags->"WindowsTroubleshooting"],
Cell[157665, 4793, 236, 5, 40, "BulletedList",
  CellTags->"WindowsTroubleshooting"],
Cell[157904, 4800, 652, 17, 94, "BulletedList",
  CellTags->"WindowsTroubleshooting"],
Cell[158559, 4819, 300, 6, 56, "BulletedList",
  CellTags->"WindowsTroubleshooting"],
Cell[158862, 4827, 583, 14, 76, "BulletedList",
  CellTags->"WindowsTroubleshooting"],
Cell[159448, 4843, 399, 8, 57, "BulletedList",
  CellTags->"WindowsTroubleshooting"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[159896, 4857, 145, 5, 82, "Chapter",
  CellTags->"MacIntroduction"],
Cell[160044, 4864, 104, 4, 40, "CopyrightHead",
  CellTags->"MacIntroduction"],
Cell[160151, 4870, 154, 4, 22, "Text",
  CellTags->"MacIntroduction"],
Cell[160308, 4876, 523, 18, 56, "Text",
  CellTags->"MacIntroduction"],
Cell[160834, 4896, 386, 8, 52, "Text",
  CellTags->"MacIntroduction"],
Cell[161223, 4906, 424, 10, 66, "Text",
  CellTags->"MacIntroduction"],

Cell[CellGroupData[{
Cell[161672, 4920, 69, 1, 36, "Subsection",
  CellTags->"MacIntroduction"],

Cell[CellGroupData[{
Cell[161766, 4925, 82, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[161851, 4928, 186, 4, 40, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[162040, 4934, 163, 4, 40, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[162240, 4943, 82, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[162325, 4946, 157, 4, 40, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[162485, 4952, 453, 9, 74, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[162941, 4963, 117, 2, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[163061, 4967, 114, 1, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[163178, 4970, 262, 5, 56, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[163443, 4977, 1334, 19, 248, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[164780, 4998, 149, 4, 24, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[164966, 5007, 78, 1, 34, "Subsubsection",
  CellTags->"MacIntroduction"],
Cell[165047, 5010, 632, 12, 98, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[165682, 5024, 787, 18, 98, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[166472, 5044, 442, 11, 62, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[166917, 5057, 589, 15, 80, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[167509, 5074, 396, 8, 62, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[167908, 5084, 272, 7, 44, "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[168217, 5096, 78, 1, 34, "Subsubsection",
  CellTags->"MacIntroduction"],
Cell[168298, 5099, 94, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[168395, 5102, 81, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[168513, 5108, 80, 1, 34, "Subsubsection",
  CellTags->"MacIntroduction"],
Cell[168596, 5111, 81, 1, 34, "Subsubsubsection",
  CellTags->"MacIntroduction"],
Cell[168680, 5114, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[168818, 5119, 132, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[168953, 5125, 107, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[169063, 5128, 116, 2, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[169182, 5132, 170, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[169355, 5140, 210, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[169568, 5148, 277, 7, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[169848, 5157, 746, 21, 80, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[170597, 5180, 163, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[170763, 5187, 268, 9, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[171034, 5198, 126, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[171163, 5204, 303, 10, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[171469, 5216, 284, 9, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[171756, 5227, 339, 10, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[172098, 5239, 164, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[172265, 5245, 191, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[172459, 5253, 395, 11, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[172857, 5266, 217, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[173077, 5274, 388, 9, 62, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[173468, 5285, 255, 7, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[173726, 5294, 937, 31, 98, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[174666, 5327, 235, 8, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[174904, 5337, 317, 12, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[175224, 5351, 131, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[175358, 5356, 432, 10, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[175793, 5368, 313, 7, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[176109, 5377, 129, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[176241, 5382, 344, 8, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[176588, 5392, 225, 7, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[176816, 5401, 175, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[176994, 5409, 139, 5, 34, "Subsubsubsection",
  CellTags->"MacIntroduction"],
Cell[177136, 5416, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[177274, 5421, 179, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[177456, 5427, 131, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[177590, 5432, 219, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[177812, 5440, 265, 6, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[178080, 5448, 186, 4, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[178269, 5454, 203, 5, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[178475, 5461, 337, 10, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[178815, 5473, 129, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[178947, 5478, 106, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[179056, 5481, 271, 6, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[179330, 5489, 159, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[179492, 5495, 141, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[179636, 5501, 249, 5, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[179888, 5508, 212, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[180103, 5515, 344, 9, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[180450, 5526, 126, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[180579, 5531, 218, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[180800, 5539, 249, 5, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[181052, 5546, 196, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[181251, 5553, 129, 2, 34, "Subsubsubsection",
  CellTags->"MacIntroduction"],
Cell[181383, 5557, 231, 7, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[181617, 5566, 185, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[181805, 5573, 394, 11, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[182202, 5586, 734, 19, 80, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[182939, 5607, 268, 9, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[183210, 5618, 156, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[183369, 5624, 121, 2, 34, "Subsubsubsection",
  CellTags->"MacIntroduction"],
Cell[183493, 5628, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[183631, 5633, 352, 7, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[183986, 5642, 1420, 44, 151, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[185409, 5688, 691, 20, 62, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[186103, 5710, 329, 12, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[186435, 5724, 164, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[186602, 5730, 230, 8, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[186835, 5740, 129, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[186967, 5745, 190, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[187160, 5752, 131, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[187294, 5757, 172, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[187469, 5763, 174, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[187646, 5769, 213, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[187862, 5776, 174, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[188039, 5782, 215, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[188257, 5789, 72, 1, 34, "Subsubsubsection",
  CellTags->"MacIntroduction"],
Cell[188332, 5792, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[188470, 5797, 96, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[188569, 5800, 257, 6, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[188829, 5808, 131, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[188963, 5813, 130, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[189096, 5819, 308, 6, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[189407, 5827, 358, 8, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[189768, 5837, 245, 5, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[190016, 5844, 211, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[190230, 5851, 265, 7, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[190498, 5860, 163, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[190664, 5868, 129, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[190796, 5873, 165, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[190964, 5880, 478, 15, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[191445, 5897, 273, 8, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[191721, 5907, 97, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[191821, 5910, 130, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[191954, 5916, 163, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[192120, 5924, 126, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[192249, 5929, 368, 10, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[192620, 5941, 223, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[192846, 5949, 207, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[193056, 5957, 136, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[193195, 5963, 165, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[193397, 5973, 103, 1, 34, "Subsubsection",
  CellTags->"MacIntroduction"],
Cell[193503, 5976, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[193641, 5981, 174, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[193818, 5987, 87, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[193908, 5990, 104, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[194015, 5993, 359, 10, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[194377, 6005, 135, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[194515, 6011, 185, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[194703, 6019, 193, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[194899, 6027, 331, 12, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[195233, 6041, 293, 10, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[195529, 6053, 228, 6, 44, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[195760, 6061, 131, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[195894, 6066, 140, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[196071, 6075, 76, 1, 34, "Subsubsection",
  CellTags->"MacIntroduction"],
Cell[196150, 6078, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[196288, 6083, 81, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[196372, 6086, 284, 10, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[196659, 6098, 283, 7, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[196945, 6107, 163, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[197111, 6113, 190, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[197304, 6121, 167, 6, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[197474, 6129, 211, 8, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[197688, 6139, 266, 9, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[197957, 6150, 85, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[198045, 6153, 96, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[198144, 6156, 91, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[198238, 6159, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[198376, 6164, 521, 17, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[198900, 6183, 193, 5, 26, "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[199130, 6193, 76, 1, 34, "Subsubsection",
  CellTags->"MacIntroduction"],
Cell[199209, 6196, 135, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[199347, 6201, 1879, 47, 206, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[201229, 6250, 94, 1, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[201326, 6253, 234, 7, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[201563, 6262, 131, 3, 21, "Text",
  CellTags->"MacIntroduction"],
Cell[201697, 6267, 279, 8, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[201979, 6277, 137, 4, 26, "BulletedList",
  CellTags->"MacIntroduction"],
Cell[202119, 6283, 330, 7, 44, "BulletedList",
  CellTags->"MacIntroduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[202498, 6296, 145, 6, 38, "Section",
  CellTags->"MacInstalling"],
Cell[202646, 6304, 343, 12, 40, "Text",
  CellTags->"MacInstalling"],

Cell[CellGroupData[{
Cell[203014, 6320, 75, 1, 36, "Subsection",
  CellTags->"MacInstalling"],
Cell[203092, 6323, 114, 2, 24, "Text",
  CellTags->"MacInstalling"],
Cell[203209, 6327, 764, 21, 72, "Text",
  CellTags->"MacInstalling"],
Cell[203976, 6350, 579, 14, 56, "Text",
  CellTags->"MacInstalling"],
Cell[204558, 6366, 113, 2, 24, "Text",
  CellTags->"MacInstalling"],
Cell[204674, 6370, 161, 4, 24, "Text",
  CellTags->"MacInstalling"]
}, Closed]],

Cell[CellGroupData[{
Cell[204872, 6379, 72, 1, 36, "Subsection",
  CellTags->{"parts", "MacInstalling"}],
Cell[204947, 6382, 215, 6, 24, "Text",
  CellTags->{"parts", "MacInstalling"}],

Cell[CellGroupData[{
Cell[205187, 6392, 141, 2, 34, "Subsubsection",
  CellTags->{"parts", "MacInstalling"}],
Cell[205331, 6396, 119, 2, 24, "Text",
  CellTags->{"parts", "mathlink.h", "MacInstalling"}],
Cell[205453, 6400, 563, 10, 56, "Text",
  CellTags->{"parts", "mathlink.h", "MacInstalling"}],
Cell[206019, 6412, 123, 2, 24, "Text",
  CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
Cell[206145, 6416, 522, 12, 56, "Text",
  CellTags->{"parts", "MathLinkLibraries", "MacInstalling"}],
Cell[206670, 6430, 109, 2, 24, "Text",
  CellTags->{"parts", "mprep", "MacInstalling"}],
Cell[206782, 6434, 443, 10, 40, "Text",
  CellTags->{"parts", "mprep", "MacInstalling"}],
Cell[207228, 6446, 105, 2, 24, "Text",
  CellTags->{"parts", "mcc", "MacInstalling"}],
Cell[207336, 6450, 249, 7, 24, "Text",
  CellTags->{"parts", "mcc", "MacInstalling"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[207622, 6462, 140, 2, 34, "Subsubsection",
  CellTags->{"parts", "MacInstalling"}],
Cell[207765, 6466, 371, 10, 40, "Text",
  CellTags->{"parts", "MacInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[208173, 6481, 152, 2, 34, "Subsubsection",
  CellTags->{"parts", "prebuilt", "MacInstalling"}],
Cell[208328, 6485, 947, 27, 56, "Text",
  CellTags->{"parts", "prebuilt", "MacInstalling"}]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[209336, 6519, 135, 6, 38, "Section",
  CellTags->"MacBuilding"],
Cell[209474, 6527, 795, 17, 88, "Text",
  CellTags->"MacBuilding"],

Cell[CellGroupData[{
Cell[210294, 6548, 120, 2, 41, "Subsection",
  CellTags->{"mprep", "MacBuilding"}],
Cell[210417, 6552, 1013, 22, 120, "Text",
  CellTags->{"mprep", "MacBuilding"}],
Cell[211433, 6576, 78, 1, 24, "Text",
  CellTags->{"mprep", "MacBuilding"}],
Cell[211514, 6579, 114, 1, 40, "FramedBox",
  CellTags->{"mprep", "MacBuilding"}],
Cell[211631, 6582, 499, 9, 56, "Text",
  CellTags->{"mprep", "MacBuilding"}],
Cell[212133, 6593, 148, 2, 55, "FramedBox",
  CellTags->{"mprep", "MacBuilding"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[212318, 6600, 160, 6, 41, "Subsection",
  CellTags->"MacBuilding"],
Cell[212481, 6608, 503, 11, 56, "Text",
  CellTags->"MacBuilding"],
Cell[212987, 6621, 85, 1, 40, "FramedBox",
  CellTags->"MacBuilding"],

Cell[CellGroupData[{
Cell[213097, 6626, 60, 1, 34, "Subsubsection",
  CellTags->"MacBuilding"],
Cell[213160, 6629, 1674, 22, 925, "FramedBox",
  CellTags->"MacBuilding"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[214883, 6657, 186, 6, 41, "Subsection",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[215072, 6665, 161, 4, 34, "Subsubsubsection",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[215236, 6671, 207, 5, 24, "NumberedGestureHead",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[215446, 6678, 184, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[215633, 6686, 201, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[215837, 6694, 115, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[215955, 6697, 198, 5, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[216156, 6704, 121, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[216280, 6707, 181, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[216464, 6715, 410, 7, 56, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[216877, 6724, 209, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[217089, 6732, 445, 12, 56, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[217537, 6746, 390, 12, 39, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[217930, 6760, 198, 4, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[218131, 6766, 156, 2, 23, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[218290, 6770, 193, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[218486, 6778, 122, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[218611, 6781, 137, 2, 23, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[218751, 6785, 116, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[218870, 6788, 157, 2, 23, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[219030, 6792, 208, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[219241, 6800, 187, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[219431, 6808, 204, 4, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[219638, 6814, 242, 5, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[219883, 6821, 245, 5, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[220131, 6828, 255, 7, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[220389, 6837, 476, 13, 57, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[220868, 6852, 300, 6, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[221171, 6860, 297, 6, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[221471, 6868, 193, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[221667, 6876, 230, 5, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[221900, 6883, 180, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[222083, 6891, 114, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[222200, 6894, 161, 4, 34, "Subsubsubsection",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[222364, 6900, 207, 5, 24, "NumberedGestureHead",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[222574, 6907, 184, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[222761, 6915, 201, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[222965, 6923, 115, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[223083, 6926, 227, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[223313, 6934, 121, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[223437, 6937, 181, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[223621, 6945, 390, 7, 56, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[224014, 6954, 93, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[224110, 6957, 209, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[224322, 6965, 445, 12, 56, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[224770, 6979, 390, 12, 39, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[225163, 6993, 198, 4, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[225364, 6999, 336, 14, 23, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[225703, 7015, 204, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[225910, 7023, 158, 5, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[226071, 7030, 204, 4, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[226278, 7036, 242, 5, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[226523, 7043, 255, 7, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[226781, 7052, 476, 13, 57, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[227260, 7067, 301, 6, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[227564, 7075, 298, 6, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[227865, 7083, 193, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[228061, 7091, 246, 5, 40, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[228310, 7098, 180, 6, 24, "NumberedGesture",
  CellTags->{"ProjectBuilder", "MacBuilding"}],
Cell[228493, 7106, 114, 1, 24, "NumberedGestureRemark",
  CellTags->{"ProjectBuilder", "MacBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[228644, 7112, 114, 1, 41, "Subsection",
  CellTags->{"mcc", "MacBuilding"}],
Cell[228761, 7115, 752, 15, 72, "Text",
  CellTags->{"mcc", "MacBuilding"}],
Cell[229516, 7132, 115, 1, 40, "FramedBox",
  CellTags->{"mcc", "MacBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[229668, 7138, 179, 6, 41, "Subsection",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[229850, 7146, 555, 15, 72, "Text",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[230408, 7163, 109, 1, 40, "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[230520, 7166, 456, 9, 56, "Text",
  CellTags->{"preANSI", "MacBuilding"}],

Cell[CellGroupData[{
Cell[231001, 7179, 73, 1, 34, "Subsubsection",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[231077, 7182, 1704, 22, 925, "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[232818, 7209, 186, 2, 34, "Subsubsection",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[233007, 7213, 246, 6, 24, "Text",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[233256, 7221, 138, 2, 40, "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[233397, 7225, 193, 5, 40, "Text",
  CellTags->{"preANSI", "MacBuilding"}],
Cell[233593, 7232, 262, 3, 190, "FramedBox",
  CellTags->{"preANSI", "MacBuilding"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[233916, 7242, 133, 6, 38, "Section",
  CellTags->"MacRunning"],
Cell[234052, 7250, 340, 8, 40, "Text",
  CellTags->"MacRunning"],

Cell[CellGroupData[{
Cell[234417, 7262, 123, 2, 41, "Subsection",
  CellTags->{"addtwo", "MacRunning"}],
Cell[234543, 7266, 1090, 31, 104, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[235636, 7299, 489, 6, 325, "FramedBox",
  CellTags->{"addtwo", "MacRunning"}],
Cell[236128, 7307, 128, 4, 24, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[236259, 7313, 115, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[236377, 7317, 127, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[236507, 7321, 140, 4, 24, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[236650, 7327, 89, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[236742, 7331, 257, 7, 24, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237002, 7340, 82, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237087, 7344, 65, 1, 24, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237155, 7347, 85, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237243, 7351, 200, 5, 40, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237446, 7358, 110, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237559, 7362, 200, 3, 55, "FramedBox",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237762, 7367, 120, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[237885, 7371, 139, 2, 40, "FramedBox",
  CellTags->{"addtwo", "MacRunning"}],
Cell[238027, 7375, 142, 3, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[238172, 7380, 133, 2, 40, "FramedBox",
  CellTags->{"addtwo", "MacRunning"}],
Cell[238308, 7384, 425, 13, 40, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[238736, 7399, 80, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}],
Cell[238819, 7403, 113, 1, 24, "Text",
  CellTags->{"addtwo", "MacRunning"}],
Cell[238935, 7406, 86, 2, 26, "Input",
  CellTags->{"addtwo", "MacRunning"}]
}, Closed]],

Cell[CellGroupData[{
Cell[239058, 7413, 123, 2, 41, "Subsection",
  CellTags->{"factor", "MacRunning"}],
Cell[239184, 7417, 544, 13, 56, "Text",
  CellTags->{"factor", "MacRunning"}],
Cell[239731, 7432, 176, 4, 24, "Text",
  CellTags->{"factor", "MacRunning"}],
Cell[239910, 7438, 137, 2, 40, "FramedBox",
  CellTags->{"factor", "MacRunning"}],
Cell[240050, 7442, 301, 6, 56, "Text",
  CellTags->{"factor", "MacRunning"}],
Cell[240354, 7450, 103, 1, 40, "FramedBox",
  CellTags->{"factor", "MacRunning"}],
Cell[240460, 7453, 312, 10, 24, "Text",
  CellTags->{"factor", "MacRunning"}],
Cell[240775, 7465, 142, 2, 85, "FramedBox",
  CellTags->{"factor", "MacRunning"}]
}, Closed]],

Cell[CellGroupData[{
Cell[240954, 7472, 87, 1, 41, "Subsection",
  CellTags->{"protocols", "MacRunning"}],
Cell[241044, 7475, 886, 21, 104, "Text",
  CellTags->{"protocols", "MacRunning"}],
Cell[241933, 7498, 389, 11, 40, "Text",
  CellTags->{"protocols", "MacRunning"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[242371, 7515, 145, 6, 38, "Section",
  CellTags->"MacPorting"],

Cell[CellGroupData[{
Cell[242541, 7525, 183, 6, 41, "Subsection",
  CellTags->{"changes", "MacPorting"}],
Cell[242727, 7533, 503, 14, 56, "Text",
  CellTags->{"changes", "MacPorting"}],
Cell[243233, 7549, 1160, 28, 120, "Text",
  CellTags->{"changes", "MacPorting"}],
Cell[244396, 7579, 498, 10, 72, "Text",
  CellTags->{"changes", "MacPorting"}],
Cell[244897, 7591, 350, 8, 56, "Text",
  CellTags->{"changes", "MacPorting"}],
Cell[245250, 7601, 288, 7, 40, "Text",
  CellTags->{"changes", "MacPorting"}],

Cell[CellGroupData[{
Cell[245563, 7612, 106, 1, 34, "Subsubsection",
  CellTags->{"changes", "strings", "MacPorting"}],
Cell[245672, 7615, 1036, 26, 120, "Text",
  CellTags->{"changes", "strings", "MacPorting"}],
Cell[246711, 7643, 1052, 22, 136, "Text",
  CellTags->{"changes", "strings", "MacPorting"}],
Cell[247766, 7667, 425, 10, 56, "Text",
  CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
Cell[248194, 7679, 410, 5, 235, "FramedBox",
  CellTags->{"changes", "strings", "MLforString", "MacPorting"}],
Cell[248607, 7686, 650, 13, 88, "Text",
  CellTags->{"MLNextCharacter", "changes", "strings", "MacPorting"}],
Cell[249260, 7701, 512, 6, 295, "FramedBox",
  CellTags->{"changes", "strings", "MLNextCharacter", "MacPorting"}],
Cell[249775, 7709, 597, 17, 56, "Text",
  CellTags->{"MLPutCharToString", "changes", "strings", "MacPorting"}],
Cell[250375, 7728, 555, 7, 340, "FramedBox",
  CellTags->{"changes", "strings", "MLPutCharToString", "MacPorting"}],
Cell[250933, 7737, 748, 17, 88, "Text",
  CellTags->{"MLConvertUnicodeString", "changes", "strings", "MacPorting"}],
Cell[251684, 7756, 603, 7, 355, "FramedBox",
  CellTags->{"changes", "strings", "MLConvertUnicodeString", "MacPorting"}]
}, Closed]],

Cell[CellGroupData[{
Cell[252324, 7768, 82, 1, 34, "Subsubsection",
  CellTags->{"changes", "MacPorting"}],
Cell[252409, 7771, 121, 4, 24, "Text",
  CellTags->"MacPorting"],
Cell[252533, 7777, 831, 14, 134, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[253367, 7793, 434, 11, 62, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[253804, 7806, 191, 2, 100, "FramedBox",
  CellTags->{"changes", "MacPorting"}],
Cell[253998, 7810, 527, 15, 62, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[254528, 7827, 626, 18, 80, "BulletedList",
  CellTags->{"MLGetArgCount", "changes", "MacPorting"}],
Cell[255157, 7847, 521, 16, 62, "BulletedList",
  CellTags->{"MLGetData", "changes", "MacPorting"}],
Cell[255681, 7865, 660, 20, 80, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[256344, 7887, 664, 15, 98, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[257011, 7904, 386, 12, 42, "IndentedText",
  CellTags->{"changes", "MacPorting"}],
Cell[257400, 7918, 641, 17, 78, "IndentedText",
  CellTags->{"changes", "MacPorting"}],
Cell[258044, 7937, 268, 7, 44, "BulletedList",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],
Cell[258315, 7946, 199, 2, 70, "FramedBox",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],
Cell[258517, 7950, 584, 14, 78, "IndentedText",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],
Cell[259104, 7966, 214, 2, 70, "FramedBox",
  CellTags->{"changes", "MLGetByteString", "MacPorting"}],
Cell[259321, 7970, 1103, 36, 116, "BulletedList",
  CellTags->{"MLBytesToGet", "changes", "MacPorting"}],
Cell[260427, 8008, 512, 11, 80, "BulletedList",
  CellTags->{"MLPutFunction", "changes", "MacPorting"}],
Cell[260942, 8021, 302, 9, 44, "BulletedList",
  CellTags->{"MLInitialize", "changes", "MacPorting"}],
Cell[261247, 8032, 302, 9, 44, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[261552, 8043, 337, 10, 44, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[261892, 8055, 283, 7, 44, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[262178, 8064, 948, 21, 116, "BulletedList",
  CellTags->{"changes", "MacPorting"}],
Cell[263129, 8087, 691, 17, 280, "FramedBox",
  CellTags->{"changes", "MacPorting"}],
Cell[263823, 8106, 1412, 33, 168, "IndentedText",
  CellTags->{"changes", "MacPorting"}]
}, Closed]],

Cell[CellGroupData[{
Cell[265272, 8144, 75, 1, 34, "Subsubsection",
  CellTags->{"changes", "MacPorting"}],
Cell[265350, 8147, 266, 6, 40, "Text",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
Cell[265619, 8155, 272, 5, 40, "Text",
  CellTags->{"MLPutUnicodeString", "changes", "MacPorting"}],
Cell[265894, 8162, 336, 4, 70, "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
Cell[266233, 8168, 870, 21, 104, "Text",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
Cell[267106, 8191, 338, 4, 85, "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
Cell[267447, 8197, 126, 1, 24, "Text",
  CellTags->{"changes", "MLPutUnicodeString", "MacPorting"}],
Cell[267576, 8200, 405, 13, 40, "Text",
  CellTags->{"MLPutNext", "changes", "MacPorting"}],
Cell[267984, 8215, 165, 2, 55, "FramedBox",
  CellTags->{"changes", "MLPutNext", "MacPorting"}],
Cell[268152, 8219, 126, 1, 24, "Text",
  CellTags->{"MLGetUnicodeString", "changes", "MacPorting"}],
Cell[268281, 8222, 213, 2, 85, "FramedBox",
  CellTags->{"changes", "MLGetUnicodeString", "MacPorting"}],
Cell[268497, 8226, 555, 15, 56, "Text",
  CellTags->{"changes", "MacPorting"}],
Cell[269055, 8243, 209, 6, 24, "Text",
  CellTags->{"changes", "MacPorting"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[269325, 8256, 68, 1, 38, "Section",
  CellTags->"MacTroubleshooting"],
Cell[269396, 8259, 641, 10, 116, "BulletedList",
  CellTags->"MacTroubleshooting"],
Cell[270040, 8271, 387, 12, 44, "BulletedList",
  CellTags->"MacTroubleshooting"],
Cell[270430, 8285, 405, 9, 44, "BulletedList",
  CellTags->"MacTroubleshooting"],
Cell[270838, 8296, 371, 9, 62, "BulletedList",
  CellTags->"MacTroubleshooting"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[271258, 8311, 142, 5, 82, "Chapter",
  CellTags->"UnixIntroduction"],
Cell[271403, 8318, 105, 4, 40, "CopyrightHead",
  CellTags->"UnixIntroduction"],
Cell[271511, 8324, 155, 4, 22, "Text",
  CellTags->"UnixIntroduction"],
Cell[271669, 8330, 524, 18, 56, "Text",
  CellTags->"UnixIntroduction"],
Cell[272196, 8350, 387, 8, 52, "Text",
  CellTags->"UnixIntroduction"],
Cell[272586, 8360, 432, 11, 66, "Text",
  CellTags->"UnixIntroduction"],

Cell[CellGroupData[{
Cell[273043, 8375, 70, 1, 36, "Subsection",
  CellTags->"UnixIntroduction"],

Cell[CellGroupData[{
Cell[273138, 8380, 82, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[273223, 8383, 186, 4, 40, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[273412, 8389, 163, 4, 40, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[273612, 8398, 82, 1, 34, "Subsubsection",
  CellTags->"WindowsIntroduction"],
Cell[273697, 8401, 157, 4, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[273857, 8407, 453, 9, 58, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[274313, 8418, 117, 2, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[274433, 8422, 117, 2, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[274553, 8426, 117, 2, 24, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[274673, 8430, 263, 5, 40, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[274939, 8437, 1334, 19, 184, "BulletedList",
  CellTags->"WindowsIntroduction"],
Cell[276276, 8458, 149, 4, 24, "BulletedList",
  CellTags->"WindowsIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[276462, 8467, 79, 1, 34, "Subsubsection",
  CellTags->"UnixIntroduction"],
Cell[276544, 8470, 633, 12, 90, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[277180, 8484, 788, 18, 94, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[277971, 8504, 443, 11, 60, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[278417, 8517, 631, 15, 76, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[279051, 8534, 398, 8, 58, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[279452, 8544, 273, 7, 42, "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[279762, 8556, 79, 1, 34, "Subsubsection",
  CellTags->"UnixIntroduction"],
Cell[279844, 8559, 114, 2, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[279961, 8563, 95, 1, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[280059, 8566, 82, 1, 26, "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[280178, 8572, 81, 1, 34, "Subsubsection",
  CellTags->"UnixIntroduction"],
Cell[280262, 8575, 82, 1, 34, "Subsubsubsection",
  CellTags->"UnixIntroduction"],
Cell[280347, 8578, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[280486, 8583, 133, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[280622, 8589, 108, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[280733, 8592, 117, 2, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[280853, 8596, 171, 6, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[281027, 8604, 211, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[281241, 8612, 278, 7, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[281522, 8621, 747, 21, 76, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[282272, 8644, 164, 5, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[282439, 8651, 269, 9, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[282711, 8662, 127, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[282841, 8668, 304, 10, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[283148, 8680, 285, 9, 41, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[283436, 8691, 340, 10, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[283779, 8703, 165, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[283947, 8709, 192, 6, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[284142, 8717, 396, 11, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[284541, 8730, 218, 6, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[284762, 8738, 389, 9, 57, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[285154, 8749, 256, 7, 41, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[285413, 8758, 938, 31, 94, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[286354, 8791, 236, 8, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[286593, 8801, 318, 12, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[286914, 8815, 132, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[287049, 8820, 433, 10, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[287485, 8832, 314, 7, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[287802, 8841, 130, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[287935, 8846, 345, 8, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[288283, 8856, 226, 7, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[288512, 8865, 176, 6, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[288691, 8873, 140, 5, 34, "Subsubsubsection",
  CellTags->"UnixIntroduction"],
Cell[288834, 8880, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[288973, 8885, 180, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[289156, 8891, 132, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[289291, 8896, 220, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[289514, 8904, 266, 6, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[289783, 8912, 187, 4, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[289973, 8918, 204, 5, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[290180, 8925, 338, 10, 44, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[290521, 8937, 130, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[290654, 8942, 107, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[290764, 8945, 272, 6, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[291039, 8953, 160, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[291202, 8959, 142, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[291347, 8965, 250, 5, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[291600, 8972, 213, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[291816, 8979, 345, 9, 43, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[292164, 8990, 127, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[292294, 8995, 219, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[292516, 9003, 250, 5, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[292769, 9010, 197, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[292969, 9017, 130, 2, 34, "Subsubsubsection",
  CellTags->"UnixIntroduction"],
Cell[293102, 9021, 232, 7, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[293337, 9030, 186, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[293526, 9037, 395, 11, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[293924, 9050, 735, 19, 76, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[294662, 9071, 269, 9, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[294934, 9082, 157, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[295094, 9088, 122, 2, 34, "Subsubsubsection",
  CellTags->"UnixIntroduction"],
Cell[295219, 9092, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[295358, 9097, 353, 7, 41, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[295714, 9106, 1421, 44, 146, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[297138, 9152, 692, 20, 59, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[297833, 9174, 330, 12, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[298166, 9188, 165, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[298334, 9194, 231, 8, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[298568, 9204, 130, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[298701, 9209, 191, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[298895, 9216, 132, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[299030, 9221, 173, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[299206, 9227, 175, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[299384, 9233, 214, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[299601, 9240, 175, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[299779, 9246, 216, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[299998, 9253, 73, 1, 34, "Subsubsubsection",
  CellTags->"UnixIntroduction"],
Cell[300074, 9256, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[300213, 9261, 97, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[300313, 9264, 258, 6, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[300574, 9272, 132, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[300709, 9277, 131, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[300843, 9283, 309, 6, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[301155, 9291, 359, 8, 41, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[301517, 9301, 246, 5, 40, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[301766, 9308, 212, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[301981, 9315, 266, 7, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[302250, 9324, 164, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[302417, 9332, 130, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[302550, 9337, 166, 5, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[302719, 9344, 479, 15, 44, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[303201, 9361, 274, 8, 42, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[303478, 9371, 98, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[303579, 9374, 131, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[303713, 9380, 164, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[303880, 9388, 127, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[304010, 9393, 369, 10, 44, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[304382, 9405, 224, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[304609, 9413, 208, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[304820, 9421, 137, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[304960, 9427, 166, 5, 26, "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[305163, 9437, 104, 1, 34, "Subsubsection",
  CellTags->"UnixIntroduction"],
Cell[305270, 9440, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[305409, 9445, 175, 4, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[305587, 9451, 88, 1, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[305678, 9454, 105, 1, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[305786, 9457, 360, 10, 44, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[306149, 9469, 136, 4, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[306288, 9475, 186, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[306477, 9483, 194, 6, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[306674, 9491, 332, 12, 44, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[307009, 9505, 294, 10, 44, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[307306, 9517, 229, 6, 44, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[307538, 9525, 132, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[307673, 9530, 141, 4, 26, "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[307851, 9539, 77, 1, 34, "Subsubsection",
  CellTags->"UnixIntroduction"],
Cell[307931, 9542, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[308070, 9547, 82, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[308155, 9550, 285, 10, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[308443, 9562, 284, 7, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[308730, 9571, 164, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[308897, 9577, 191, 6, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[309091, 9585, 168, 6, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[309262, 9593, 212, 8, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[309477, 9603, 267, 9, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[309747, 9614, 86, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[309836, 9617, 97, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[309936, 9620, 92, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[310031, 9623, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[310170, 9628, 522, 17, 26, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[310695, 9647, 194, 5, 24, "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[310926, 9657, 77, 1, 34, "Subsubsection",
  CellTags->"UnixIntroduction"],
Cell[311006, 9660, 136, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[311145, 9665, 1880, 47, 183, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[313028, 9714, 95, 1, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[313126, 9717, 235, 7, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[313364, 9726, 132, 3, 21, "Text",
  CellTags->"UnixIntroduction"],
Cell[313499, 9731, 280, 8, 25, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[313782, 9741, 138, 4, 24, "BulletedList",
  CellTags->"UnixIntroduction"],
Cell[313923, 9747, 331, 7, 40, "BulletedList",
  CellTags->"UnixIntroduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[314303, 9760, 146, 6, 38, "Section",
  CellTags->"UnixInstalling"],
Cell[314452, 9768, 299, 12, 38, "Text",
  CellTags->"UnixInstalling"],

Cell[CellGroupData[{
Cell[314776, 9784, 76, 1, 36, "Subsection",
  CellTags->"UnixInstalling"],
Cell[314855, 9787, 115, 2, 24, "Text",
  CellTags->"UnixInstalling"],
Cell[314973, 9791, 708, 20, 56, "Text",
  CellTags->"UnixInstalling"],
Cell[315684, 9813, 580, 14, 51, "Text",
  CellTags->"UnixInstalling"],
Cell[316267, 9829, 114, 2, 24, "Text",
  CellTags->"UnixInstalling"],
Cell[316384, 9833, 162, 4, 22, "Text",
  CellTags->"UnixInstalling"]
}, Closed]],

Cell[CellGroupData[{
Cell[316583, 9842, 73, 1, 36, "Subsection",
  CellTags->{"parts", "UnixInstalling"}],
Cell[316659, 9845, 216, 6, 24, "Text",
  CellTags->{"parts", "UnixInstalling"}],

Cell[CellGroupData[{
Cell[316900, 9855, 142, 2, 34, "Subsubsection",
  CellTags->{"parts", "UnixInstalling"}],
Cell[317045, 9859, 120, 2, 24, "Text",
  CellTags->{"parts", "mathlink.h", "UnixInstalling"}],
Cell[317168, 9863, 574, 11, 52, "Text",
  CellTags->{"parts", "mathlink.h", "UnixInstalling"}],
Cell[317745, 9876, 124, 2, 24, "Text",
  CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],
Cell[317872, 9880, 472, 11, 54, "Text",
  CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"}],
Cell[318347, 9893, 110, 2, 24, "Text",
  CellTags->{"parts", "mprep", "UnixInstalling"}],
Cell[318460, 9897, 444, 10, 38, "Text",
  CellTags->{"parts", "mprep", "UnixInstalling"}],
Cell[318907, 9909, 106, 2, 24, "Text",
  CellTags->{"parts", "mcc", "UnixInstalling"}],
Cell[319016, 9913, 250, 7, 24, "Text",
  CellTags->{"parts", "mcc", "UnixInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[319303, 9925, 141, 2, 34, "Subsubsection",
  CellTags->{"parts", "UnixInstalling"}],
Cell[319447, 9929, 372, 10, 40, "Text",
  CellTags->{"parts", "UnixInstalling"}]
}, Closed]],

Cell[CellGroupData[{
Cell[319856, 9944, 150, 2, 34, "Subsubsection",
  CellTags->{"parts", "prebuilt", "UnixInstalling"}],
Cell[320009, 9948, 942, 27, 56, "Text",
  CellTags->{"parts", "prebuilt", "UnixInstalling"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[321012, 9982, 136, 6, 38, "Section",
  CellTags->"UnixBuilding"],
Cell[321151, 9990, 796, 17, 70, "Text",
  CellTags->"UnixBuilding"],

Cell[CellGroupData[{
Cell[321972, 10011, 121, 2, 36, "Subsection",
  CellTags->{"mprep", "UnixBuilding"}],
Cell[322096, 10015, 1030, 22, 98, "Text",
  CellTags->{"mprep", "UnixBuilding"}],
Cell[323129, 10039, 79, 1, 22, "Text",
  CellTags->{"mprep", "UnixBuilding"}],
Cell[323211, 10042, 117, 1, 40, "FramedBox",
  CellTags->{"mprep", "UnixBuilding"}],
Cell[323331, 10045, 492, 9, 50, "Text",
  CellTags->{"mprep", "UnixBuilding"}],
Cell[323826, 10056, 149, 2, 55, "FramedBox",
  CellTags->{"mprep", "UnixBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[324012, 10063, 139, 6, 36, "Subsection",
  CellTags->"UnixBuilding"],
Cell[324154, 10071, 504, 11, 52, "Text",
  CellTags->"UnixBuilding"],
Cell[324661, 10084, 86, 1, 40, "FramedBox",
  CellTags->"UnixBuilding"],

Cell[CellGroupData[{
Cell[324772, 10089, 61, 1, 34, "Subsubsection",
  CellTags->"UnixBuilding"],
Cell[324836, 10092, 1673, 22, 925, "FramedBox",
  CellTags->"UnixBuilding"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[326558, 10120, 115, 1, 36, "Subsection",
  CellTags->{"mcc", "UnixBuilding"}],
Cell[326676, 10123, 753, 15, 52, "Text",
  CellTags->{"mcc", "UnixBuilding"}],
Cell[327432, 10140, 116, 1, 40, "FramedBox",
  CellTags->{"mcc", "UnixBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[327585, 10146, 180, 6, 36, "Subsection",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[327768, 10154, 556, 15, 54, "Text",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[328327, 10171, 110, 1, 40, "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[328440, 10174, 464, 10, 51, "Text",
  CellTags->{"preANSI", "UnixBuilding"}],

Cell[CellGroupData[{
Cell[328929, 10188, 74, 1, 34, "Subsubsection",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[329006, 10191, 1703, 22, 925, "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}]
}, Closed]],

Cell[CellGroupData[{
Cell[330746, 10218, 187, 2, 34, "Subsubsection",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[330936, 10222, 247, 6, 22, "Text",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[331186, 10230, 139, 2, 40, "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[331328, 10234, 199, 5, 36, "Text",
  CellTags->{"preANSI", "UnixBuilding"}],
Cell[331530, 10241, 263, 3, 190, "FramedBox",
  CellTags->{"preANSI", "UnixBuilding"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[331854, 10251, 134, 6, 38, "Section",
  CellTags->"UnixRunning"],
Cell[331991, 10259, 341, 8, 38, "Text",
  CellTags->"UnixRunning"],

Cell[CellGroupData[{
Cell[332357, 10271, 124, 2, 36, "Subsection",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[332484, 10275, 1091, 31, 86, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[333578, 10308, 490, 6, 325, "FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[334071, 10316, 129, 4, 22, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[334203, 10322, 116, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[334322, 10326, 128, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[334453, 10330, 141, 4, 22, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[334597, 10336, 90, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[334690, 10340, 258, 7, 23, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[334951, 10349, 83, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335037, 10353, 66, 1, 22, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335106, 10356, 86, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335195, 10360, 201, 5, 36, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335399, 10367, 111, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335513, 10371, 207, 3, 55, "FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335723, 10376, 121, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335847, 10380, 146, 2, 40, "FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[335996, 10384, 143, 3, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[336142, 10389, 140, 2, 40, "FramedBox",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[336285, 10393, 426, 13, 38, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[336714, 10408, 81, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[336798, 10412, 114, 1, 22, "Text",
  CellTags->{"addtwo", "UnixRunning"}],
Cell[336915, 10415, 87, 2, 26, "Input",
  CellTags->{"addtwo", "UnixRunning"}]
}, Closed]],

Cell[CellGroupData[{
Cell[337039, 10422, 124, 2, 36, "Subsection",
  CellTags->{"factor", "UnixRunning"}],
Cell[337166, 10426, 544, 13, 56, "Text",
  CellTags->{"factor", "UnixRunning"}],
Cell[337713, 10441, 177, 4, 24, "Text",
  CellTags->{"factor", "UnixRunning"}],
Cell[337893, 10447, 138, 2, 40, "FramedBox",
  CellTags->{"factor", "UnixRunning"}],
Cell[338034, 10451, 302, 6, 56, "Text",
  CellTags->{"factor", "UnixRunning"}],
Cell[338339, 10459, 104, 1, 40, "FramedBox",
  CellTags->{"factor", "UnixRunning"}],
Cell[338446, 10462, 312, 10, 24, "Text",
  CellTags->{"factor", "UnixRunning"}],
Cell[338761, 10474, 143, 2, 85, "FramedBox",
  CellTags->{"factor", "UnixRunning"}]
}, Closed]],

Cell[CellGroupData[{
Cell[338941, 10481, 88, 1, 36, "Subsection",
  CellTags->{"protocols", "UnixRunning"}],
Cell[339032, 10484, 877, 21, 104, "Text",
  CellTags->{"protocols", "UnixRunning"}],
Cell[339912, 10507, 391, 11, 40, "Text",
  CellTags->{"protocols", "UnixRunning"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[340352, 10524, 146, 6, 38, "Section",
  CellTags->"UnixPorting"],

Cell[CellGroupData[{
Cell[340523, 10534, 184, 6, 41, "Subsection",
  CellTags->{"changes", "UnixPorting"}],
Cell[340710, 10542, 504, 14, 56, "Text",
  CellTags->{"changes", "UnixPorting"}],
Cell[341217, 10558, 1161, 28, 120, "Text",
  CellTags->{"changes", "UnixPorting"}],
Cell[342381, 10588, 494, 10, 72, "Text",
  CellTags->{"changes", "UnixPorting"}],
Cell[342878, 10600, 351, 8, 56, "Text",
  CellTags->{"changes", "UnixPorting"}],
Cell[343232, 10610, 289, 7, 40, "Text",
  CellTags->{"changes", "UnixPorting"}],

Cell[CellGroupData[{
Cell[343546, 10621, 107, 1, 34, "Subsubsection",
  CellTags->{"changes", "strings", "UnixPorting"}],
Cell[343656, 10624, 1036, 26, 104, "Text",
  CellTags->{"changes", "strings", "UnixPorting"}],
Cell[344695, 10652, 1046, 22, 120, "Text",
  CellTags->{"changes", "strings", "UnixPorting"}],
Cell[345744, 10676, 426, 10, 40, "Text",
  CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
Cell[346173, 10688, 411, 5, 235, "FramedBox",
  CellTags->{"changes", "strings", "MLforString", "UnixPorting"}],
Cell[346587, 10695, 651, 13, 72, "Text",
  CellTags->{"MLNextCharacter", "changes", "strings", "UnixPorting"}],
Cell[347241, 10710, 513, 6, 295, "FramedBox",
  CellTags->{"changes", "strings", "MLNextCharacter", "UnixPorting"}],
Cell[347757, 10718, 598, 17, 56, "Text",
  CellTags->{"MLPutCharToString", "changes", "strings", "UnixPorting"}],
Cell[348358, 10737, 556, 7, 340, "FramedBox",
  CellTags->{"changes", "strings", "MLPutCharToString", "UnixPorting"}],
Cell[348917, 10746, 749, 17, 88, "Text",
  CellTags->{"MLConvertUnicodeString", "changes", "strings", "UnixPorting"}],
Cell[349669, 10765, 604, 7, 355, "FramedBox",
  CellTags->{"changes", "strings", "MLConvertUnicodeString", "UnixPorting"}]
}, Closed]],

Cell[CellGroupData[{
Cell[350310, 10777, 83, 1, 34, "Subsubsection",
  CellTags->{"changes", "UnixPorting"}],
Cell[350396, 10780, 143, 4, 26, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[350542, 10786, 839, 14, 134, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[351384, 10802, 435, 11, 44, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[351822, 10815, 192, 2, 100, "FramedBox",
  CellTags->{"changes", "UnixPorting"}],
Cell[352017, 10819, 528, 15, 62, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[352548, 10836, 624, 18, 80, "BulletedList",
  CellTags->{"MLGetArgCount", "changes", "UnixPorting"}],
Cell[353175, 10856, 518, 15, 62, "BulletedList",
  CellTags->{"MLGetData", "changes", "UnixPorting"}],
Cell[353696, 10873, 661, 20, 80, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[354360, 10895, 670, 15, 98, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[355033, 10912, 387, 12, 42, "IndentedText",
  CellTags->{"changes", "UnixPorting"}],
Cell[355423, 10926, 642, 17, 78, "IndentedText",
  CellTags->{"changes", "UnixPorting"}],
Cell[356068, 10945, 269, 7, 44, "BulletedList",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
Cell[356340, 10954, 200, 2, 70, "FramedBox",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
Cell[356543, 10958, 585, 14, 60, "IndentedText",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
Cell[357131, 10974, 215, 2, 70, "FramedBox",
  CellTags->{"changes", "MLGetByteString", "UnixPorting"}],
Cell[357349, 10978, 1104, 36, 116, "BulletedList",
  CellTags->{"MLBytesToGet", "changes", "UnixPorting"}],
Cell[358456, 11016, 513, 11, 62, "BulletedList",
  CellTags->{"MLPutFunction", "changes", "UnixPorting"}],
Cell[358972, 11029, 303, 9, 44, "BulletedList",
  CellTags->{"MLInitialize", "changes", "UnixPorting"}],
Cell[359278, 11040, 303, 9, 44, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[359584, 11051, 338, 10, 44, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[359925, 11063, 284, 7, 44, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[360212, 11072, 948, 21, 116, "BulletedList",
  CellTags->{"changes", "UnixPorting"}],
Cell[361163, 11095, 692, 17, 280, "FramedBox",
  CellTags->{"changes", "UnixPorting"}],
Cell[361858, 11114, 1414, 33, 168, "IndentedText",
  CellTags->{"changes", "UnixPorting"}]
}, Closed]],

Cell[CellGroupData[{
Cell[363309, 11152, 76, 1, 34, "Subsubsection",
  CellTags->{"changes", "UnixPorting"}],
Cell[363388, 11155, 267, 6, 40, "Text",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
Cell[363658, 11163, 273, 5, 40, "Text",
  CellTags->{"MLPutUnicodeString", "changes", "UnixPorting"}],
Cell[363934, 11170, 337, 4, 70, "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
Cell[364274, 11176, 871, 21, 88, "Text",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
Cell[365148, 11199, 339, 4, 85, "FramedBox",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
Cell[365490, 11205, 127, 1, 24, "Text",
  CellTags->{"changes", "MLPutUnicodeString", "UnixPorting"}],
Cell[365620, 11208, 406, 13, 40, "Text",
  CellTags->{"MLPutNext", "changes", "UnixPorting"}],
Cell[366029, 11223, 166, 2, 55, "FramedBox",
  CellTags->{"changes", "MLPutNext", "UnixPorting"}],
Cell[366198, 11227, 127, 1, 24, "Text",
  CellTags->{"MLGetUnicodeString", "changes", "UnixPorting"}],
Cell[366328, 11230, 214, 2, 85, "FramedBox",
  CellTags->{"changes", "MLGetUnicodeString", "UnixPorting"}],
Cell[366545, 11234, 556, 15, 56, "Text",
  CellTags->{"changes", "UnixPorting"}],
Cell[367104, 11251, 210, 6, 24, "Text",
  CellTags->{"changes", "UnixPorting"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[367375, 11264, 69, 1, 38, "Section",
  CellTags->"UnixTroubleshooting"],
Cell[367447, 11267, 642, 10, 116, "BulletedList",
  CellTags->"UnixTroubleshooting"],
Cell[368092, 11279, 388, 12, 44, "BulletedList",
  CellTags->"UnixTroubleshooting"],
Cell[368483, 11293, 406, 9, 44, "BulletedList",
  CellTags->"UnixTroubleshooting"],
Cell[368892, 11304, 372, 9, 62, "BulletedList",
  CellTags->"UnixTroubleshooting"]
}, Closed]]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

