(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     50592,       1542]*)
(*NotebookOutlinePosition[     56788,       1727]*)
(*  CellTagsIndexPosition[     56248,       1702]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "ANOVA",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.95.1", "1.1"}],

Cell[TextData[{
 "This package provides functions for performing a univariate Analysis of \
Variance (ANOVA) to examine the differences between groups of means. The \
function ",
 StyleBox["ANOVA", "MR"],
 " can handle models with any number of fixed factors in a crossed design. It \
can also handle both balanced and unbalanced data with or without missing \
elements. All results are given as type I sums of squares. ANOVA also \
provides a number of post\[Hyphen]hoc tests and comparisons. "
}], "Text",
 CellTags->{"S5.95.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ANOVA[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Performs a one\[Hyphen]way ANOVA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ANOVA[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["model", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["factors", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Performs a general ANOVA specified by the given ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["model", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["factors", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.95.1"],

Cell[TextData[{
 "The ",
 StyleBox["ANOVA", "MR"],
 " function."
}], "Caption",
 CellTags->"S5.95.1"],

Cell[TextData[{
 "The ",
 StyleBox["data", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " must be of the form ",
 StyleBox["{{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}, {", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}, ", "MR"],
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and so on are the values of the factors associated with the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["i",
     "TI"], "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " response, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.95.1", "1.3"}],

Cell[TextData[{
 "The ",
 StyleBox["factors", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " argument of ",
 StyleBox["ANOVA", "MR"],
 " must be a list of names representing the factors of the model, one name \
for each factor. "
}], "Text",
 CellTags->{"S5.95.1", "1.4"}],

Cell[TextData[{
 "The ",
 StyleBox["model", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " argument of ",
 StyleBox["ANOVA", "MR"],
 " must be a list of main effects and interaction effects that together \
specify the model. The interaction terms are given as the multiplication of \
factors. For example, the full factorial model for a three\[Hyphen]way ANOVA \
can be written as ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the main effects, ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the two\[Hyphen]way interactions, and ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the three\[Hyphen]way interaction. For simplicity, models can also be \
written using ",
 StyleBox["All", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " to represent all interaction terms between the specified main effects. The \
full factorial model for a three\[Hyphen]way ANOVA can therefore also be \
written as ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 StyleBox["All", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["}", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.95.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.95.1", "1.6"}],

Cell["<<Statistics`ANOVA`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.95.1"],

Cell["\<\
In this data set, the first element in each pair gives the value of the \
factor and the second element gives the response. There are four levels of \
the factor, each having five responses. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.7"}],

Cell["\<\
onewaydata = {{1,7.0}, {1,5.3}, {1,5.9}, {1,6.6}, {1,4.9}, {2,4.4}, {2,6.8}, \
{2,7.7}, {2,8.3}, {2,6.6}, {3,8.1}, {3,10.4}, {3,8.0}, {3,6.8}, {3,9.2}, \
{4,5.7}, {4,3.9}, {4,6.2}, {4,5.5}, {4,6.2}};\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.95.1"],

Cell["\<\
This performs a one\[Hyphen]way ANOVA. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.8"}],

Cell[CellGroupData[{

Cell["ANOVA[onewaydata]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.95.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "3", "26.29349999999999`", "8.764499999999996`", 
        "6.127949659150494`", "0.005616104919811349`"},
       {"\<\"Error\"\>", "16", "22.884000000000004`", 
        "1.4302500000000002`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "19", 
        "49.177499999999995`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{3, 26.2935, 8.7645, 6.12794965915049, 0.00561610491981135}, {
       16, 22.884, 1.43025}, {19, 49.1775}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"All\"\>", GridBox[{
          {"6.675000000000001`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], GridBox[{
          {"5.94`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], GridBox[{
          {"6.76`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "3", "]"}], GridBox[{
          {"8.5`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "4", "]"}], GridBox[{
          {"5.5`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{"All", {6.675}}, {
        "Model"[1], {5.94}}, {
        "Model"[2], {6.76}}, {
        "Model"[3], {8.5}}, {
        "Model"[4], {5.5}}}]]}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.95.1"]
}, Open  ]],

Cell["\<\
In this unbalanced two\[Hyphen]way data set, the first element in each \
triplet gives the value of the first factor, the second element gives the \
value of the second factor, and the third element gives the response. There \
are two levels of the first factor and three levels of the second factor. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.9"}],

Cell["\<\
twowaydata = {{1,1,10.1}, {1,1,10.5}, {1,1,11.3}, {1,2,13.1}, {1,2,14.7}, \
{1,3,14.1}, {1,3,12.6}, {2,1,10.7}, {2,1,15.3}, {2,1,17.9}, {2,1,18.0}, \
{2,2,28.7}, {2,3,16.0}, {2,3,9.2}, {2,3,12.1}};\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.95.1"],

Cell["\<\
This performs a full factorial two\[Hyphen]way ANOVA. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
ANOVA[twowaydata,{factor1, factor2, All}, {factor1, factor2}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.95.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"factor1", "1", "49.59144047619043`", "49.59144047619043`", 
        "7.254236799486078`", "0.02466005901056134`"},
       {"factor2", "2", "110.31823328267473`", "55.15911664133736`", 
        "8.06867656846641`", "0.009832259544792832`"},
       {
        RowBox[{"factor1", " ", "factor2"}], "2", "105.88182624113477`", 
        "52.94091312056739`", "7.7441977177896515`", 
        "0.011060373917016864`"},
       {"\<\"Error\"\>", "9", "61.52583333333334`", 
        "6.836203703703704`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "14", 
        "327.3173333333333`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{
       1, 49.5914404761904, 49.5914404761904, 7.25423679948608, 
        0.0246600590105613}, {
       2, 110.318233282675, 55.1591166413374, 8.06867656846641, 
        0.00983225954479283}, {
       2, 105.881826241135, 52.9409131205674, 7.74419771778965, 
        0.0110603739170169}, {9, 61.5258333333333, 6.8362037037037}, {
       14, 327.317333333333}}, 
      TableHeadings -> {{
        factor1, factor2, factor1 factor2, "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"All\"\>", GridBox[{
          {"14.286666666666665`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor1", "[", "1", "]"}], GridBox[{
          {"12.342857142857143`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor1", "[", "2", "]"}], GridBox[{
          {"15.987499999999999`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor2", "[", "1", "]"}], GridBox[{
          {"13.399999999999999`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor2", "[", "2", "]"}], GridBox[{
          {"18.833333333333332`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor2", "[", "3", "]"}], GridBox[{
          {"12.8`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], GridBox[{
          {"10.633333333333333`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "2", "]"}]}], GridBox[{
          {"13.899999999999999`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], GridBox[{
          {"13.35`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], GridBox[{
          {"15.475`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "2", "]"}]}], GridBox[{
          {"28.7`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], GridBox[{
          {"12.433333333333332`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{"All", {14.2866666666667}}, {
        factor1[1], {12.3428571428571}}, {
        factor1[2], {15.9875}}, {
        factor2[1], {13.4}}, {
        factor2[2], {18.8333333333333}}, {
        factor2[3], {12.8}}, {factor1[1] factor2[1], {10.6333333333333}}, {
       factor1[1] factor2[2], {13.9}}, {factor1[1] factor2[3], {13.35}}, {
       factor1[2] factor2[1], {15.475}}, {factor1[2] factor2[2], {28.7}}, {
       factor1[2] factor2[3], {12.4333333333333}}}]]}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.95.1"]
}, Open  ]],

Cell[TextData[{
 "Dropping the data point ",
 StyleBox["{2,", "MR"],
 " ",
 StyleBox["2,", "MR"],
 " ",
 StyleBox["28.7}", "MR"],
 " gives an unbalanced two\[Hyphen]way ANOVA with an empty cell. "
}], "MathCaption",
 CellTags->{"S5.95.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
ANOVA[Drop[twowaydata, {-4}], {factor1, factor2, All}, {factor1, factor2}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.95.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"factor1", "1", "11.702857142857141`", "11.702857142857141`", 
        "1.71189415208865`", "0.2231650390153398`"},
       {"factor2", "2", "8.09966386554622`", "4.04983193277311`", 
        "0.5924094875316545`", "0.5731936603055147`"},
       {
        RowBox[{"factor1", " ", "factor2"}], "1", "23.40593137254902`", 
        "23.40593137254902`", "3.4238200596433668`", "0.09729572033085232`"},
       {"\<\"Error\"\>", "9", "61.52583333333334`", 
        "6.836203703703704`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "13", 
        "104.73428571428572`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{
       1, 11.7028571428571, 11.7028571428571, 1.71189415208865, 
        0.22316503901534}, {
       2, 8.09966386554622, 4.04983193277311, 0.592409487531654, 
        0.573193660305515}, {
       1, 23.405931372549, 23.405931372549, 3.42382005964337, 
        0.0972957203308523}, {9, 61.5258333333333, 6.8362037037037}, {
       13, 104.734285714286}}, 
      TableHeadings -> {{
        factor1, factor2, factor1 factor2, "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"All\"\>", GridBox[{
          {"13.257142857142856`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor1", "[", "1", "]"}], GridBox[{
          {"12.342857142857143`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor1", "[", "2", "]"}], GridBox[{
          {"14.17142857142857`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor2", "[", "1", "]"}], GridBox[{
          {"13.399999999999999`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor2", "[", "2", "]"}], GridBox[{
          {"13.899999999999999`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"factor2", "[", "3", "]"}], GridBox[{
          {"12.8`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], GridBox[{
          {"10.633333333333333`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "2", "]"}]}], GridBox[{
          {"13.899999999999999`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], GridBox[{
          {"13.35`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], GridBox[{
          {"15.475`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], GridBox[{
          {"12.433333333333332`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{"All", {13.2571428571429}}, {
        factor1[1], {12.3428571428571}}, {
        factor1[2], {14.1714285714286}}, {
        factor2[1], {13.4}}, {
        factor2[2], {13.9}}, {
        factor2[3], {12.8}}, {factor1[1] factor2[1], {10.6333333333333}}, {
       factor1[1] factor2[2], {13.9}}, {factor1[1] factor2[3], {13.35}}, {
       factor1[2] factor2[1], {15.475}}, {
       factor1[2] factor2[3], {12.4333333333333}}}]]}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.95.1"]
}, Open  ]],

Cell["\<\
Here is a balanced three\[Hyphen]way data set. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.12"}],

Cell["\<\
threewaydata = {{1, 1, 1, 50}, {1, 1, 1, 50}, {1, 1, 1, 54}, {1, 1, 2, 40}, \
{1, 1, 2, 36}, {1, 1, 2, 40}, {1, 2, 1, 48}, {1, 2, 1, 48}, {1, 2, 1, 44}, \
{1, 2, 2, 14}, {1, 2, 2, 18}, {1, 2, 2, 14}, {2, 1, 1, 40}, {2, 1, 1, 36}, \
{2, 1, 1, 36}, {2, 1, 2, 18}, {2, 1, 2, 14}, {2, 1, 2, 18}, {2, 2, 1, 6}, {2, \
2, 1, 2}, {2, 2, 1, 2}, {2, 2, 2, 20}, {2, 2, 2, 16}, {2, 2, 2, 20}};\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.95.1"],

Cell["\<\
Here is a three\[Hyphen]way ANOVA without the three\[Hyphen]way interaction \
included. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.13"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"threewaydata", ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", 
     RowBox[{"\[Alpha]", "\[Beta]"}], ",", 
     RowBox[{"\[Alpha]", "\[Gamma]"}], ",", 
     RowBox[{"\[Beta]", "\[Gamma]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.95.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\[Alpha]", "1", "2166.`", "2166.`", "30.53233830845771`", 
        "0.00003705699705391918`"},
       {"\[Beta]", "1", "1350.`", "1350.`", "19.029850746268657`", 
        "0.0004241469507222373`"},
       {"\[Gamma]", "1", "912.6666666666661`", "912.6666666666661`", 
        "12.865118850193468`", "0.0022731109550425677`"},
       {
        RowBox[{"\[Alpha]", " ", "\[Beta]"}], "1", "6.0000000000009095`", 
        "6.0000000000009095`", "0.08457711442787352`", 
        "0.7747060407679582`"},
       {
        RowBox[{"\[Alpha]", " ", "\[Gamma]"}], "1", "560.6666666666661`", 
        "560.6666666666661`", "7.903261470425641`", "0.01201676217104275`"},
       {
        RowBox[{"\[Beta]", " ", "\[Gamma]"}], "1", "112.66666666666697`", 
        "112.66666666666697`", "1.588170259812055`", "0.22461261582845582`"},
       {"\<\"Error\"\>", "17", "1206.`", 
        "70.94117647058823`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "23", "6314.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{1, 2166, 2166, 30.5323383084577, 3.70569970539192*^-5}, {
       1, 1350, 1350, 19.0298507462687, 0.000424146950722237}, {
       1, 912.666666666666, 912.666666666666, 12.8651188501935, 
        0.00227311095504257}, {
       1, 6.00000000000091, 6.00000000000091, 0.0845771144278735, 
        0.774706040767958}, {
       1, 560.666666666666, 560.666666666666, 7.90326147042564, 
        0.0120167621710427}, {
       1, 112.666666666667, 112.666666666667, 1.58817025981206, 
        0.224612615828456}, {17, 1206, 70.9411764705882}, {23, 6314}}, 
      TableHeadings -> {{\[Alpha], \[Beta], \[Gamma], \[Alpha] \[Beta], \
\[Alpha] \[Gamma], \[Beta] \[Gamma], "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"All\"\>", GridBox[{
          {"28.5`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\[Alpha]", "[", "1", "]"}], GridBox[{
          {"38.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\[Alpha]", "[", "2", "]"}], GridBox[{
          {"19.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\[Beta]", "[", "1", "]"}], GridBox[{
          {"36.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\[Beta]", "[", "2", "]"}], GridBox[{
          {"21.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\[Gamma]", "[", "1", "]"}], GridBox[{
          {"34.666666666666664`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\[Gamma]", "[", "2", "]"}], GridBox[{
          {"22.333333333333332`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "1", "]"}]}], GridBox[{
          {"45.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "2", "]"}]}], GridBox[{
          {"31.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "1", "]"}]}], GridBox[{
          {"27.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "2", "]"}]}], GridBox[{
          {"11.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], GridBox[{
          {"49.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], GridBox[{
          {"27.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], GridBox[{
          {"20.333333333333332`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], GridBox[{
          {"17.666666666666664`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], GridBox[{
          {"44.33333333333333`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], GridBox[{
          {"27.666666666666664`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], GridBox[{
          {"25.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], GridBox[{
          {"17.`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{"All", {28.5}}, {
        \[Alpha][1], {38}}, {
        \[Alpha][2], {19}}, {
        \[Beta][1], {36}}, {
        \[Beta][2], {21}}, {
        \[Gamma][1], {34.6666666666667}}, {
        \[Gamma][2], {22.3333333333333}}, {\[Alpha][1] \[Beta][1], {
        45}}, {\[Alpha][1] \[Beta][2], {31}}, {\[Alpha][2] \[Beta][1], {
        27}}, {\[Alpha][2] \[Beta][2], {11}}, {\[Alpha][1] \[Gamma][1], {
        49}}, {\[Alpha][1] \[Gamma][2], {27}}, {\[Alpha][2] \[Gamma][1], {
        20.3333333333333}}, {\[Alpha][2] \[Gamma][2], {
        17.6666666666667}}, {\[Beta][1] \[Gamma][1], {
        44.3333333333333}}, {\[Beta][1] \[Gamma][2], {
        27.6666666666667}}, {\[Beta][2] \[Gamma][1], {
        25}}, {\[Beta][2] \[Gamma][2], {17}}}]]}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.95.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "SO10",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CellMeans ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to give a list of means for each group",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["WorkingPrecision ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["$MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "precision of the arithmetic to use in calculations",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PostTests ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "list of post\[Hyphen]hoc tests to perform",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SignificanceLevel ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0.05", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "significance level criteria for post\[Hyphen]hoc tests",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.95.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["ANOVA", "MR"],
 "."
}], "Caption",
 CellTags->"S5.95.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Bonferroni ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["mean comparison test based on the Student ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distribution with modified ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Alpha]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" based on the number of groups",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Duncan ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "liberal range test based on the Studentized range distribution",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["StudentNewmanKeuls ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "conservative range test based on the Studentized range distribution",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tukey ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "mean comparison test based on the Studentized range distribution",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Dunnett ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "comparison test of group means against a control, taken to be the first \
group",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.95.1"],

Cell["Available tests to include in the PostTests option.", "Caption",
 CellTags->"S5.95.1"],

Cell["\<\
This performs a one\[Hyphen]way ANOVA with a Tukey post\[Hyphen]hoc test. In \
this example, both groups one and four are significantly different from group \
three at the five\[Hyphen]percent level. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.14"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"onewaydata", ",", 
   RowBox[{"PostTests", "\[Rule]", "Tukey"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.95.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "3", "26.29349999999999`", "8.764499999999996`", 
        "6.127949659150494`", "0.005616104919811349`"},
       {"\<\"Error\"\>", "16", "22.884000000000004`", 
        "1.4302500000000002`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "19", 
        "49.177499999999995`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{3, 26.2935, 8.7645, 6.12794965915049, 0.00561610491981135}, {
       16, 22.884, 1.43025}, {19, 49.1775}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"All\"\>", GridBox[{
          {"6.675000000000001`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], GridBox[{
          {"5.94`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], GridBox[{
          {"6.76`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "3", "]"}], GridBox[{
          {"8.5`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]},
       {
        RowBox[{"\<\"Model\"\>", "[", "4", "]"}], GridBox[{
          {"5.5`"}
          },
         RowSpacings->0.25,
         ColumnSpacings->1,
         RowAlignments->Baseline,
         ColumnAlignments->{Left}]}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{"All", {6.675}}, {
        "Model"[1], {5.94}}, {
        "Model"[2], {6.76}}, {
        "Model"[3], {8.5}}, {
        "Model"[4], {5.5}}}]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Tukey", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}
         },
        RowSpacings->3,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
       Function[BoxForm`e$, 
        TableForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.95.1"]
}, Open  ]],

Cell["\<\
This performs the same one\[Hyphen]way ANOVA as the previous example but with \
Bonferroni and Tukey post\[Hyphen]hoc tests being computed at the \
one\[Hyphen]percent level. The cell means are not being displayed again. In \
this case, only groups three and four are significantly different. \
\>", "MathCaption",
 CellTags->{"S5.95.1", "1.15"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"onewaydata", ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Tukey", ",", "Bonferroni"}], "}"}]}], ",", 
   RowBox[{"SignificanceLevel", "\[Rule]", ".01"}], ",", 
   RowBox[{"CellMeans", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.95.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "3", "26.29349999999999`", "8.764499999999996`", 
        "6.127949659150494`", "0.005616104919811349`"},
       {"\<\"Error\"\>", "16", "22.884000000000004`", 
        "1.4302500000000002`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "19", 
        "49.177499999999995`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
       },
      RowSpacings->1,
      ColumnSpacings->3,
      RowAlignments->Baseline,
      ColumnAlignments->{Left}],
     TableForm[{{3, 26.2935, 8.7645, 6.12794965915049, 0.00561610491981135}, {
       16, 22.884, 1.43025}, {19, 49.1775}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Bonferroni", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}]},
         {"Tukey", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}]}
         },
        RowSpacings->3,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
       Function[BoxForm`e$, 
        TableForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.95.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Subsubsection",
 CellTags->{"S5.95.1", "1.16"}],

Cell[TextData[{
 "Jobson, J. D. (1991). ",
 StyleBox["Applied Multivariate Data Analysis Volume 1: Regression and \
Experimental Design,", "TI"],
 " Springer\[Hyphen]Verlag, New York. "
}], "Text",
 CellTags->{"S5.95.1", "1.17"}],

Cell[TextData[{
 "Sahai, H. and Ageel, M. (2000). ",
 StyleBox["The Analysis of Variance: Fixed, Random and Mixed Models,", "TI"],
 " Birkhauser, Boston. "
}], "Text",
 CellTags->{"S5.95.1", "1.18"}],

Cell[TextData[{
 "Searle, S. R. (1987). ",
 StyleBox["Linear Models for Unbalanced Data,", "TI"],
 " John Wiley & Sons, New York. "
}], "Text",
 CellTags->{"S5.95.1", "1.19"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.95.1"->{
    Cell[1776, 53, 132, 6, 36, "Subsection",
      CellTags->{"S5.95.1", "1.1"}],
    Cell[1911, 61, 538, 10, 88, "Text",
      CellTags->{"S5.95.1", "1.2"}],
    Cell[2452, 73, 2237, 70, 84, "DefinitionBox",
      CellTags->"S5.95.1"],
    Cell[4692, 145, 101, 5, 15, "Caption",
      CellTags->"S5.95.1"],
    Cell[4796, 152, 2453, 85, 42, "Text",
      CellTags->{"S5.95.1", "1.3"}],
    Cell[7252, 239, 292, 10, 40, "Text",
      CellTags->{"S5.95.1", "1.4"}],
    Cell[7547, 251, 4778, 135, 120, "Text",
      CellTags->{"S5.95.1", "1.5"}],
    Cell[12328, 388, 78, 1, 40, "MathCaption",
      CellTags->{"S5.95.1", "1.6"}],
    Cell[12409, 391, 82, 2, 28, "Input",
      CellTags->"S5.95.1"],
    Cell[12494, 395, 253, 5, 56, "MathCaption",
      CellTags->{"S5.95.1", "1.7"}],
    Cell[12750, 402, 270, 6, 79, "Input",
      CellTags->"S5.95.1"],
    Cell[13023, 410, 101, 3, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.8"}],
    Cell[13149, 417, 80, 2, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[13232, 421, 2457, 74, 70, "Output",
      CellTags->"S5.95.1"],
    Cell[15704, 498, 363, 6, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.9"}],
    Cell[16070, 506, 268, 6, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[16341, 514, 117, 3, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.10"}],
    Cell[16483, 521, 132, 4, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[16618, 527, 5418, 159, 70, "Output",
      CellTags->"S5.95.1"],
    Cell[22051, 689, 247, 9, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.11"}],
    Cell[22323, 702, 145, 4, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[22471, 708, 5069, 148, 70, "Output",
      CellTags->"S5.95.1"],
    Cell[27555, 859, 110, 3, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.12"}],
    Cell[27668, 864, 452, 8, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[28123, 874, 151, 4, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.13"}],
    Cell[28299, 882, 442, 12, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[28744, 896, 8268, 242, 70, "Output",
      CellTags->"S5.95.1"],
    Cell[37027, 1141, 3902, 105, 70, "DefinitionBox3Col",
      CellTags->"S5.95.1"],
    Cell[40932, 1248, 100, 5, 70, "Caption",
      CellTags->"S5.95.1"],
    Cell[41035, 1255, 2905, 76, 70, "DefinitionBox",
      CellTags->"S5.95.1"],
    Cell[43943, 1333, 92, 1, 70, "Caption",
      CellTags->"S5.95.1"],
    Cell[44038, 1336, 263, 5, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.14"}],
    Cell[44326, 1345, 178, 5, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[44507, 1352, 3054, 93, 70, "Output",
      CellTags->"S5.95.1"],
    Cell[47576, 1448, 356, 6, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.15"}],
    Cell[47957, 1458, 349, 9, 70, "Input",
      CellTags->"S5.95.1"],
    Cell[48309, 1469, 1539, 41, 70, "Output",
      CellTags->"S5.95.1"],
    Cell[49885, 1515, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.95.1", "1.16"}],
    Cell[49955, 1518, 229, 6, 70, "Text",
      CellTags->{"S5.95.1", "1.17"}],
    Cell[50187, 1526, 199, 5, 70, "Text",
      CellTags->{"S5.95.1", "1.18"}],
    Cell[50389, 1533, 175, 5, 70, "Text",
      CellTags->{"S5.95.1", "1.19"}]},
  "1.1"->{
    Cell[1776, 53, 132, 6, 36, "Subsection",
      CellTags->{"S5.95.1", "1.1"}]},
  "1.2"->{
    Cell[1911, 61, 538, 10, 88, "Text",
      CellTags->{"S5.95.1", "1.2"}]},
  "1.3"->{
    Cell[4796, 152, 2453, 85, 42, "Text",
      CellTags->{"S5.95.1", "1.3"}]},
  "1.4"->{
    Cell[7252, 239, 292, 10, 40, "Text",
      CellTags->{"S5.95.1", "1.4"}]},
  "1.5"->{
    Cell[7547, 251, 4778, 135, 120, "Text",
      CellTags->{"S5.95.1", "1.5"}]},
  "1.6"->{
    Cell[12328, 388, 78, 1, 40, "MathCaption",
      CellTags->{"S5.95.1", "1.6"}]},
  "1.7"->{
    Cell[12494, 395, 253, 5, 56, "MathCaption",
      CellTags->{"S5.95.1", "1.7"}]},
  "1.8"->{
    Cell[13023, 410, 101, 3, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.8"}]},
  "1.9"->{
    Cell[15704, 498, 363, 6, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.9"}]},
  "1.10"->{
    Cell[16341, 514, 117, 3, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.10"}]},
  "1.11"->{
    Cell[22051, 689, 247, 9, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.11"}]},
  "1.12"->{
    Cell[27555, 859, 110, 3, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.12"}]},
  "1.13"->{
    Cell[28123, 874, 151, 4, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.13"}]},
  "1.14"->{
    Cell[44038, 1336, 263, 5, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.14"}]},
  "1.15"->{
    Cell[47576, 1448, 356, 6, 70, "MathCaption",
      CellTags->{"S5.95.1", "1.15"}]},
  "1.16"->{
    Cell[49885, 1515, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.95.1", "1.16"}]},
  "1.17"->{
    Cell[49955, 1518, 229, 6, 70, "Text",
      CellTags->{"S5.95.1", "1.17"}]},
  "1.18"->{
    Cell[50187, 1526, 199, 5, 70, "Text",
      CellTags->{"S5.95.1", "1.18"}]},
  "1.19"->{
    Cell[50389, 1533, 175, 5, 70, "Text",
      CellTags->{"S5.95.1", "1.19"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.95.1", 51215, 1558},
  {"1.1", 54414, 1641},
  {"1.2", 54508, 1644},
  {"1.3", 54597, 1647},
  {"1.4", 54688, 1650},
  {"1.5", 54778, 1653},
  {"1.6", 54871, 1656},
  {"1.7", 54967, 1659},
  {"1.8", 55064, 1662},
  {"1.9", 55161, 1665},
  {"1.10", 55259, 1668},
  {"1.11", 55358, 1671},
  {"1.12", 55457, 1674},
  {"1.13", 55556, 1677},
  {"1.14", 55655, 1680},
  {"1.15", 55755, 1683},
  {"1.16", 55855, 1686},
  {"1.17", 55956, 1689},
  {"1.18", 56049, 1692},
  {"1.19", 56142, 1695}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 132, 6, 36, "Subsection",
  CellTags->{"S5.95.1", "1.1"}],
Cell[1911, 61, 538, 10, 88, "Text",
  CellTags->{"S5.95.1", "1.2"}],
Cell[2452, 73, 2237, 70, 84, "DefinitionBox",
  CellTags->"S5.95.1"],
Cell[4692, 145, 101, 5, 15, "Caption",
  CellTags->"S5.95.1"],
Cell[4796, 152, 2453, 85, 42, "Text",
  CellTags->{"S5.95.1", "1.3"}],
Cell[7252, 239, 292, 10, 40, "Text",
  CellTags->{"S5.95.1", "1.4"}],
Cell[7547, 251, 4778, 135, 120, "Text",
  CellTags->{"S5.95.1", "1.5"}],
Cell[12328, 388, 78, 1, 40, "MathCaption",
  CellTags->{"S5.95.1", "1.6"}],
Cell[12409, 391, 82, 2, 28, "Input",
  CellTags->"S5.95.1"],
Cell[12494, 395, 253, 5, 56, "MathCaption",
  CellTags->{"S5.95.1", "1.7"}],
Cell[12750, 402, 270, 6, 79, "Input",
  CellTags->"S5.95.1"],
Cell[13023, 410, 101, 3, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.8"}],

Cell[CellGroupData[{
Cell[13149, 417, 80, 2, 70, "Input",
  CellTags->"S5.95.1"],
Cell[13232, 421, 2457, 74, 70, "Output",
  CellTags->"S5.95.1"]
}, Open  ]],
Cell[15704, 498, 363, 6, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.9"}],
Cell[16070, 506, 268, 6, 70, "Input",
  CellTags->"S5.95.1"],
Cell[16341, 514, 117, 3, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.10"}],

Cell[CellGroupData[{
Cell[16483, 521, 132, 4, 70, "Input",
  CellTags->"S5.95.1"],
Cell[16618, 527, 5418, 159, 70, "Output",
  CellTags->"S5.95.1"]
}, Open  ]],
Cell[22051, 689, 247, 9, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.11"}],

Cell[CellGroupData[{
Cell[22323, 702, 145, 4, 70, "Input",
  CellTags->"S5.95.1"],
Cell[22471, 708, 5069, 148, 70, "Output",
  CellTags->"S5.95.1"]
}, Open  ]],
Cell[27555, 859, 110, 3, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.12"}],
Cell[27668, 864, 452, 8, 70, "Input",
  CellTags->"S5.95.1"],
Cell[28123, 874, 151, 4, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.13"}],

Cell[CellGroupData[{
Cell[28299, 882, 442, 12, 70, "Input",
  CellTags->"S5.95.1"],
Cell[28744, 896, 8268, 242, 70, "Output",
  CellTags->"S5.95.1"]
}, Open  ]],
Cell[37027, 1141, 3902, 105, 70, "DefinitionBox3Col",
  CellTags->"S5.95.1"],
Cell[40932, 1248, 100, 5, 70, "Caption",
  CellTags->"S5.95.1"],
Cell[41035, 1255, 2905, 76, 70, "DefinitionBox",
  CellTags->"S5.95.1"],
Cell[43943, 1333, 92, 1, 70, "Caption",
  CellTags->"S5.95.1"],
Cell[44038, 1336, 263, 5, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.14"}],

Cell[CellGroupData[{
Cell[44326, 1345, 178, 5, 70, "Input",
  CellTags->"S5.95.1"],
Cell[44507, 1352, 3054, 93, 70, "Output",
  CellTags->"S5.95.1"]
}, Open  ]],
Cell[47576, 1448, 356, 6, 70, "MathCaption",
  CellTags->{"S5.95.1", "1.15"}],

Cell[CellGroupData[{
Cell[47957, 1458, 349, 9, 70, "Input",
  CellTags->"S5.95.1"],
Cell[48309, 1469, 1539, 41, 70, "Output",
  CellTags->"S5.95.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49885, 1515, 67, 1, 70, "Subsubsection",
  CellTags->{"S5.95.1", "1.16"}],
Cell[49955, 1518, 229, 6, 70, "Text",
  CellTags->{"S5.95.1", "1.17"}],
Cell[50187, 1526, 199, 5, 70, "Text",
  CellTags->{"S5.95.1", "1.18"}],
Cell[50389, 1533, 175, 5, 70, "Text",
  CellTags->{"S5.95.1", "1.19"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

