(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7896,        287]*)
(*NotebookOutlinePosition[     10431,        368]*)
(*  CellTagsIndexPosition[     10226,        356]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "AlgebraicInequalities",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.1.1", "1.1"}],

Cell[TextData[{
 "The package provides a function for solving systems of strong polynomial \
inequalities in one or more unknowns. To be precise, ",
 StyleBox["SemialgebraicComponents[", "MR"],
 StyleBox["ineqs", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["vars", "TI"],
 StyleBox["]", "MR"],
 " gives a finite set of solutions of the system of inequalities. That is, \
within the set of solutions, any solution can be connected by a continuous \
path to a solution in the finite set. The variable ",
 StyleBox["ineqs", "TI"],
 " is a list of strong inequalities, where both sides of each inequality are \
polynomials in variables ",
 StyleBox["vars", "TI"],
 " with rational coefficients. In other words, ",
 StyleBox["SemialgebraicComponents[", "MR"],
 StyleBox["ineqs", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["vars", "TI"],
 StyleBox["]", "MR"],
 " gives at least one point in each connected component of the open \
semialgebraic set defined by inequalities ",
 StyleBox["ineqs", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.1.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SemialgebraicComponents[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give at least one point in each component of the set of solutions of \
inequalities ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ineqs", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.1.1"],

Cell["Solutions of inequalities. ", "Caption",
 CellTags->"S5.1.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.1.1", "1.3"}],

Cell["<<Algebra`AlgebraicInequalities`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.1.1"],

Cell[TextData[{
 "Here is a point from each of the three intervals forming the set of \
solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       StyleBox["x",
        "TI"], "2"], "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       StyleBox["x",
        "TI"], "2"], "-", "3"}], ")"}], ">", "0"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.1.1", "1.4"}],

Cell[CellGroupData[{

Cell["SemialgebraicComponents[{x (x^2 - 2) (x^2 - 3) > 0}, x]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.1.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "2"]}], ",", "1", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.1.1"]
}, Open  ]],

Cell[TextData[{
 "This gives one point in each of the two connected components of the set \
bounded by the circle ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "=", "=", "4"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the hyperbola ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], 
    StyleBox["y",
     "TI"], "=", "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.1.1", "1.5"}],

Cell[CellGroupData[{

Cell["SemialgebraicComponents[{x^2 + y^2 < 4, x y > 1}, {x, y}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.1.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", 
      FractionBox["17", "16"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["17", "16"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.1.1"]
}, Open  ]],

Cell[TextData[{
 "This proves that the ball ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["y",
        "TI"], "-", "1"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       StyleBox["z",
        "TI"], "-", "2"}], ")"}], "2"], "<", "1", "/", "9"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is contained in the ellipsoid ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"], "/", "4", "+", 
    SuperscriptBox[
     StyleBox["z",
      "TI"], "2"], "/", "9", "<", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.1.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
SemialgebraicComponents[{x^2 + y^2/4 + z^2/9 > 1,
 x^2 + (y - 1)^2 + (z - 2)^2 < 1/9},
 {x, y, z}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.1.1"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.1.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.1.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.1.1", "1.1"}],
    Cell[1923, 61, 1035, 26, 120, "Text",
      CellTags->{"S5.1.1", "1.2"}],
    Cell[2961, 89, 1440, 45, 64, "DefinitionBox",
      CellTags->"S5.1.1"],
    Cell[4404, 136, 67, 1, 15, "Caption",
      CellTags->"S5.1.1"],
    Cell[4474, 139, 77, 1, 40, "MathCaption",
      CellTags->{"S5.1.1", "1.3"}],
    Cell[4554, 142, 94, 2, 28, "Input",
      CellTags->"S5.1.1"],
    Cell[4651, 146, 555, 22, 56, "MathCaption",
      CellTags->{"S5.1.1", "1.4"}],
    Cell[5231, 172, 117, 2, 28, "Input",
      CellTags->"S5.1.1"],
    Cell[5351, 176, 170, 6, 40, "Output",
      CellTags->"S5.1.1"],
    Cell[5536, 185, 652, 24, 56, "MathCaption",
      CellTags->{"S5.1.1", "1.5"}],
    Cell[6213, 213, 119, 2, 45, "Input",
      CellTags->"S5.1.1"],
    Cell[6335, 217, 311, 12, 40, "Output",
      CellTags->"S5.1.1"],
    Cell[6661, 232, 921, 36, 56, "MathCaption",
      CellTags->{"S5.1.1", "1.6"}],
    Cell[7607, 272, 168, 6, 70, "Input",
      CellTags->"S5.1.1"],
    Cell[7778, 280, 90, 3, 70, "Output",
      CellTags->"S5.1.1"]},
  "1.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.1.1", "1.1"}]},
  "1.2"->{
    Cell[1923, 61, 1035, 26, 120, "Text",
      CellTags->{"S5.1.1", "1.2"}]},
  "1.3"->{
    Cell[4474, 139, 77, 1, 40, "MathCaption",
      CellTags->{"S5.1.1", "1.3"}]},
  "1.4"->{
    Cell[4651, 146, 555, 22, 56, "MathCaption",
      CellTags->{"S5.1.1", "1.4"}]},
  "1.5"->{
    Cell[5536, 185, 652, 24, 56, "MathCaption",
      CellTags->{"S5.1.1", "1.5"}]},
  "1.6"->{
    Cell[6661, 232, 921, 36, 56, "MathCaption",
      CellTags->{"S5.1.1", "1.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.1.1", 8518, 303},
  {"1.1", 9647, 334},
  {"1.2", 9740, 337},
  {"1.3", 9830, 340},
  {"1.4", 9924, 343},
  {"1.5", 10020, 346},
  {"1.6", 10116, 349}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 144, 6, 36, "Subsection",
  CellTags->{"S5.1.1", "1.1"}],
Cell[1923, 61, 1035, 26, 120, "Text",
  CellTags->{"S5.1.1", "1.2"}],
Cell[2961, 89, 1440, 45, 64, "DefinitionBox",
  CellTags->"S5.1.1"],
Cell[4404, 136, 67, 1, 15, "Caption",
  CellTags->"S5.1.1"],
Cell[4474, 139, 77, 1, 40, "MathCaption",
  CellTags->{"S5.1.1", "1.3"}],
Cell[4554, 142, 94, 2, 28, "Input",
  CellTags->"S5.1.1"],
Cell[4651, 146, 555, 22, 56, "MathCaption",
  CellTags->{"S5.1.1", "1.4"}],

Cell[CellGroupData[{
Cell[5231, 172, 117, 2, 28, "Input",
  CellTags->"S5.1.1"],
Cell[5351, 176, 170, 6, 40, "Output",
  CellTags->"S5.1.1"]
}, Open  ]],
Cell[5536, 185, 652, 24, 56, "MathCaption",
  CellTags->{"S5.1.1", "1.5"}],

Cell[CellGroupData[{
Cell[6213, 213, 119, 2, 45, "Input",
  CellTags->"S5.1.1"],
Cell[6335, 217, 311, 12, 40, "Output",
  CellTags->"S5.1.1"]
}, Open  ]],
Cell[6661, 232, 921, 36, 56, "MathCaption",
  CellTags->{"S5.1.1", "1.6"}],

Cell[CellGroupData[{
Cell[7607, 272, 168, 6, 70, "Input",
  CellTags->"S5.1.1"],
Cell[7778, 280, 90, 3, 70, "Output",
  CellTags->"S5.1.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

