(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    106829,       3946]*)
(*NotebookOutlinePosition[    122717,       4319]*)
(*  CellTagsIndexPosition[    122628,       4313]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["NumberTheory`AlgebraicNumberFields`", "Subsection",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This package introduces functions for computation within finite algebraic \
extensions of rationals. For more information on the notions and algorithms \
used, see for instance H.\[NonBreakingSpace]Cohen, ",
 StyleBox["A Course In Computational Algebraic Number Theory", "TI"],
 ", Springer-Verlag, 1993. "
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides representation of algebraic numbers as ",
 StyleBox["Root", "MR"],
 " objects. A  ",
 StyleBox["Root", "MR"],
 " object contains the minimal polynomial of the algebraic number and the \
root number\[LongDash]an integer indicating which of the roots of the minimal \
polynomial the ",
 StyleBox["Root", "MR"],
 " object represents. This allows for unique representation of arbitrary \
complex algebraic numbers. A disadvantage is that performing arithmetic \
operations in this representation is quite costly. That is why ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " requires the use of an additional function, ",
 StyleBox["RootReduce", "MR"],
 ", in order to simplify arithmetic expressions. If we restrict ourselves to \
computations within a fixed finite algebraic extension, \
\[DoubleStruckCapitalQ](\[Theta]), of rationals, we can use a more convenient \
representation of elements of \[DoubleStruckCapitalQ](\[Theta]), namely as \
polynomials in \[Theta]. "
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["Algebraic",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["f",
        "TI"], 
       StyleBox[",",
        "TI"], 
       StyleBox[" ",
        "TI"], 
       RowBox[{
        StyleBox["{",
         "TI"], 
        RowBox[{
         SubscriptBox[
          StyleBox["c",
           "TI"], "0"], ",", "\[Ellipsis]", ",", 
         SubscriptBox[
          StyleBox["c",
           FontSlant->"Italic"], "l"]}], "}"}], ",", " ", 
       StyleBox["k",
        FontSlant->"Italic"]}], "]"}], Cell[TextData[{
      StyleBox["represent the algebraic number ",
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox["c", "0"], "+", 
         RowBox[{
          SubscriptBox["c", "1"], "\[Theta]"}], "+", "\[Ellipsis]", "+", 
         RowBox[{
          SubscriptBox["c", "l"], 
          SuperscriptBox["\[Theta]", "l"]}]}], TraditionalForm]],
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
      StyleBox[", where \[Theta] = ",
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
      StyleBox["Root", "MR",
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
      StyleBox["[",
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
      StyleBox["f",
       FontSlant->"Italic"],
      StyleBox[", ",
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}],
      StyleBox["k",
       FontSlant->"Italic"],
      StyleBox["]",
       GridBoxOptions->{ColumnWidths->{0.35, 0.65}}]
     }], "Text",
      GridBoxOptions->{ColumnWidths->{0.35, 0.65}}]}
    }], TextForm]], "DefinitionBox",
 GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
 CellTags->"AlgebraicNumberFields"],

Cell["\<\
Representation of algebraic numbers as elements of a finite extension of \
rationals.\
\>", "Caption",
 CellTags->"AlgebraicNumberFields"],

Cell["This loads the package.", "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"<<", " ", "NumberTheory`AlgebraicNumberFields`"}]], "Input",
 CellLabel->"In[1]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "If ",
 StyleBox["f",
  FontSlant->"Italic"],
 " is a monic irreducible polynomial function of degree ",
 StyleBox["l",
  FontSlant->"Italic"],
 " with integer coefficients, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["c", "0"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["c", "l"]}], "}"}], TraditionalForm]]],
 " are rational numbers, then ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Algebraic",
    "MR"], 
   StyleBox["[",
    "MR"], 
   RowBox[{
    StyleBox["f",
     "TI"], 
    StyleBox[",",
     "TI"], 
    RowBox[{
     StyleBox["{",
      "TI"], 
     RowBox[{
      SubscriptBox[
       StyleBox["c",
        "TI"], 
       StyleBox["0",
        FontSlant->"Italic"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["c",
        "TI"], 
       StyleBox["l",
        FontSlant->"Italic"]]}], "}"}], ",", 
    StyleBox["k",
     FontSlant->"Italic"]}], "]"}]],
  GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
 " is an inert numeric object. "
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["#1", "3"], "-", "#1", "+", "1"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", "#1", "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1"}], "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 StyleBox["N", "MR"],
 " can be used to find a numeric approximation of an ",
 StyleBox["Algebraic", "MR"],
 " object."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"a", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["3.61519708425058622822670898011939139422`20."], "Output",
 CellLabel->"Out[3]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "For any ",
 StyleBox["f",
  FontSlant->"Italic"],
 " and ",
 StyleBox["k",
  FontSlant->"Italic"],
 " for which \[Theta] = ",
 StyleBox["Root[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " evaluates to an algebraic number, and for any list of rational numbers ",
 Cell[BoxData[
  RowBox[{
   StyleBox["{",
    "TI"], 
   RowBox[{
    SubscriptBox[
     StyleBox["c",
      "TI"], 
     StyleBox["0",
      FontSlant->"Italic"]], ",", "\[Ellipsis]", ",", 
    SubscriptBox[
     StyleBox["c",
      "TI"], 
     StyleBox["l",
      FontSlant->"Italic"]]}], "}"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Algebraic",
    "MR"], 
   StyleBox["[",
    "MR"], 
   RowBox[{
    StyleBox["f",
     "TI"], 
    StyleBox[",",
     "TI"], 
    RowBox[{
     StyleBox["{",
      "TI"], 
     RowBox[{
      SubscriptBox[
       StyleBox["c",
        "TI"], 
       StyleBox["0",
        FontSlant->"Italic"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["c",
        "TI"], 
       StyleBox["l",
        FontSlant->"Italic"]]}], "}"}], ",", 
    StyleBox["k",
     FontSlant->"Italic"]}], "]"}]],
  GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
 " evaluates to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Algebraic",
    "MR"], 
   StyleBox["[",
    "MR"], 
   RowBox[{
    StyleBox["g",
     "TI"], 
    StyleBox[",",
     "TI"], 
    RowBox[{
     StyleBox["{",
      "TI"], 
     RowBox[{
      SubscriptBox[
       StyleBox["d",
        "TI"], 
       StyleBox["0",
        FontSlant->"Italic"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["d",
        "TI"], 
       StyleBox["m",
        FontSlant->"Italic"]]}], "}"}], ",", 
    StyleBox["n",
     FontSlant->"Italic"]}], 
   StyleBox["]",
    FontSlant->"Italic"]}]],
  GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
 ", such that \[Xi] = ",
 StyleBox["Root[", "MR"],
 StyleBox["g",
  FontSlant->"Italic"],
 ", ",
 StyleBox["n",
  FontSlant->"Italic"],
 StyleBox["] ", "MR"],
 "\[Equal]  ",
 StyleBox["d",
  FontSlant->"Italic"],
 " \[Theta], where ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is a factor of the leading coefficient of the minimal polynomial of \
\[Theta], such that \[Xi] is an algebraic integer, ",
 StyleBox["m",
  FontSlant->"Italic"],
 " is the degree of ",
 StyleBox["g",
  FontSlant->"Italic"],
 ", and"
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["c", "0"], "+", 
    RowBox[{
     SubscriptBox["c", "1"], "\[Theta]"}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["c", "l"], 
     SuperscriptBox["\[Theta]", "l"]}]}], "\[Equal]", 
   RowBox[{
    SubscriptBox["d", "0"], "+", 
    RowBox[{
     SubscriptBox["d", "1"], "\[Xi]"}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["d", "m"], 
     RowBox[{
      SuperscriptBox["\[Xi]", "m"], "."}]}]}]}], 
  TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 StyleBox["Algebraic", "MR"],
 " automatically makes the polynomial defining the extension monic and the \
coefficient list equal in length to the degree of the extension."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"3", " ", "#1"}], "+", "2"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "-", 
     RowBox[{"12", " ", "#1"}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", 
     FractionBox["7", "4"], ",", "3", ",", 
     FractionBox["1", "2"]}], "}"}], ",", "1"}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "If the polynomial ",
 StyleBox["f",
  FontSlant->"Italic"],
 " specified in ",
 StyleBox["Algebraic", "MR"],
 " is reducible, we get the field extension specified by the irreducible \
factor of ",
 StyleBox["f",
  FontSlant->"Italic"],
 " whose root is ",
 StyleBox["Root[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["#1", "8"], "-", "4"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", "1"}], 
  "]"}]], "Output",
 CellLabel->"Out[5]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 " ",
 StyleBox["Algebraic", "MR"],
 " objects representing rational numbers reduce automatically to numbers."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["#1", "5"], "-", 
     RowBox[{"7", " ", "#1"}], "+", "1"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "7", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[6]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "Adding or multiplying ",
 StyleBox["Algebraic", "MR"],
 " objects that explicitly belong to the same field (i.e. have the same first \
and third elements), adding or multiplying a rational number and an ",
 StyleBox["Algebraic", "MR"],
 " object, or raising an ",
 StyleBox["Algebraic", "MR"],
 " object to an integer power yields an ",
 StyleBox["Algebraic", "MR"],
 " object."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#1", "4"], "+", 
       RowBox[{"7", " ", "#1"}], "-", "21"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "1"}], "]"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#1", "4"], "+", 
       RowBox[{"7", " ", "#1"}], "-", "21"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "8", ",", "7", ",", "5"}], "}"}], ",", "1"}], "]"}]}],
   ";"}], "\n", 
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"]}], "-", 
    RowBox[{"3", " ", "a", " ", "b"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "5"]}], "-", "3"}], 
   RowBox[{
    SuperscriptBox["a", "8"], "-", 
    SuperscriptBox["b", "4"], "+", 
    FractionBox["1", "2"]}]], "+", "9"}]}], "Input",
 CellLabel->"In[7]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "21"}], "+", 
     RowBox[{"7", " ", "#1"}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["41286695899369558776723710439212189982056327290172063", 
      "4586375026009762651263976115838375027468985058462049"], ",", 
     FractionBox["6520802026300441952691134470541521717177617572114", 
      "13759125078029287953791928347515125082406955175386147"], ",", 
     FractionBox["3688721281596550115065494536738395724701865336152", 
      "13759125078029287953791928347515125082406955175386147"], ",", 
     FractionBox["2274021184276897634212701763901059483341282983762", 
      "13759125078029287953791928347515125082406955175386147"]}], "}"}], ",", 
   "1"}], "]"}]], "Output",
 CellLabel->"Out[9]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 StyleBox["RootReduce", "MR"],
 " transforms ",
 StyleBox["Algebraic", "MR"],
 " objects to ",
 StyleBox["Root", "MR"],
 " objects."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "a", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3062597"}], "-", 
     RowBox[{"82303", " ", "#1"}], "+", 
     RowBox[{"1182", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"80", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]], "Output",
 CellLabel->"Out[10]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       StyleBox["ToCommonField",
        "MR"], 
       StyleBox["[",
        "MR"], 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a",
           FontSlant->"Italic"], "1"], ",", " ", "\[Ellipsis]", ",", " ", 
         SubscriptBox[
          StyleBox["a",
           FontSlant->"Italic"], 
          StyleBox["n",
           FontSlant->"Italic"]]}], "}"}], 
       StyleBox["]",
        "MR"]}], " "}], 
     RowBox[{
      RowBox[{"give", " ", "a", " ", "list", " ", "of", " ", 
       StyleBox["Algebraic",
        "MR"], " ", "objects", " ", "representing", " ", "the", " ", 
       "algebraic", " ", "numbers", " ", 
       SubscriptBox[
        StyleBox["a",
         FontSlant->"Italic"], "1"]}], ",", " ", "\[Ellipsis]", ",", " ", 
      RowBox[{
       SubscriptBox[
        StyleBox["a",
         FontSlant->"Italic"], 
        StyleBox["n",
         FontSlant->"Italic"]], "as", " ", "elements", " ", "of", " ", "a", 
       " ", "common", " ", "finite", " ", "extension", " ", "of", " ", 
       "rationals"}]}]},
    {
     RowBox[{
      StyleBox["ToNumberFieldElement",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox[
       RowBox[{"a", ",", " ", "f", ",", " ", "k"}],
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      StyleBox["write the algebraic number ",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
      StyleBox["a",
       FontSlant->"Italic"],
      StyleBox[" as an ",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
      StyleBox["Algebraic", "MR",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
      StyleBox[" object in the number field specified by ",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
      StyleBox["Root", "MR",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
      StyleBox["[",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
      StyleBox["f",
       FontSlant->"Italic"],
      StyleBox[", ",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
      StyleBox["k",
       FontSlant->"Italic"],
      StyleBox["]",
       GridBoxOptions->{ColumnWidths->{0.4, 0.6}}]
     }], "Text",
      GridBoxOptions->{ColumnWidths->{0.4, 0.6}}]}
    }], TextForm]], "DefinitionBox",
 GridBoxOptions->{ColumnWidths->{0.4, 0.6}},
 CellTags->"AlgebraicNumberFields"],

Cell["\<\
Functions for representing arbitrary algebraic numbers as elements of \
algebraic number fields. \
\>", "Caption",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 StyleBox["ToCommonField", "MR"],
 " can be used to find a common finite extension of rationals containing the \
given algebraic numbers."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCommonField", "[", 
  RowBox[{"{", 
   RowBox[{
    SqrtBox["2"], ",", 
    SqrtBox["3"]}], "}"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["9", "2"]}], ",", "0", ",", 
       FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["11", "2"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", "4"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[11]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This represents ",
 Cell[BoxData[
  FormBox[
   SqrtBox["6"], TraditionalForm]]],
 "as an element of the field generated by ",
 StyleBox["Root[", "MR"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ","}]]],
 StyleBox["4]", "MR"],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberFieldElement", "[", 
  RowBox[{
   SqrtBox["6"], ",", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Algebraic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", "0", ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}], ",", "4"}], "]"}]], "Output",
 CellLabel->"Out[12]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell["\<\
Arithmetic within a fixed finite extension of rationals is much faster than \
arithmetic within the field of all complex algebraic numbers. \
\>", "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "Suppose we need to find the value of rational function ",
 StyleBox["f",
  FontSlant->"Italic"],
 " with {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 ", ",
 StyleBox["z",
  FontSlant->"Italic"],
 "} replaced by algebraic numbers {",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", ",
 StyleBox["c",
  FontSlant->"Italic"],
 "}."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"\[ImaginaryI]", ",", 
     SqrtBox["2"], ",", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#1", "3"], "-", 
         RowBox[{"2", " ", "#1"}], "+", "3"}], "&"}], ",", "1"}], "]"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "y", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{"7", "+", "x", "-", "y", "+", 
        SuperscriptBox["z", "2"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", "+", 
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "y"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "11"}], "+", 
        RowBox[{"x", " ", "y"}], "+", 
        SuperscriptBox["z", "2"]}], ")"}]}]}], 
    RowBox[{
     RowBox[{"2", " ", "y", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "-", "x", "+", 
        RowBox[{"3", " ", "y", " ", "z"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", "+", 
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "y"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"2", " ", "x"}], "+", 
        SuperscriptBox["z", "3"]}], ")"}]}]}]]}], ";"}]}], "Input",
 CellLabel->"In[13]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "A direct computation of the value of ",
 StyleBox["f",
  FontSlant->"Italic"],
 " at {",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", ",
 StyleBox["c",
  FontSlant->"Italic"],
 "} using ",
 StyleBox["RootReduce", "MR"],
 " takes a rather long time."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{"f", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "a"}], ",", 
      RowBox[{"y", "\[Rule]", "b"}], ",", 
      RowBox[{"z", "\[Rule]", "c"}]}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[15]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"134.121094`", " ", "Second"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"127463137729603858692", "+", 
       RowBox[{"15069520316552576640", " ", "#1"}], "+", 
       RowBox[{"3151085417830482145156", " ", 
        SuperscriptBox["#1", "2"]}], "-", 
       RowBox[{"10938243534840099267928", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"14492589303525156688533", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"7171605298335082808820", " ", 
        SuperscriptBox["#1", "5"]}], "-", 
       RowBox[{"947445370794828405814", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       RowBox[{"2510661531113587622448", " ", 
        SuperscriptBox["#1", "7"]}], "-", 
       RowBox[{"606316032776880635517", " ", 
        SuperscriptBox["#1", "8"]}], "-", 
       RowBox[{"100899537810316084288", " ", 
        SuperscriptBox["#1", "9"]}], "+", 
       RowBox[{"74049398920051042942", " ", 
        SuperscriptBox["#1", "10"]}], "-", 
       RowBox[{"12985018306589245140", " ", 
        SuperscriptBox["#1", "11"]}], "+", 
       RowBox[{"879298673075259913", " ", 
        SuperscriptBox["#1", "12"]}]}], "&"}], ",", "4"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[15]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "A faster alternative is to do the computation in a common algebraic number \
field containing {",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", ",
 StyleBox["c",
  FontSlant->"Italic"],
 "}."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"aa", ",", "bb", ",", "cc"}], "}"}], "=", 
    RowBox[{"ToCommonField", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], ")"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[16]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.16796900000000126`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Algebraic", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"648", "+", 
         RowBox[{"2592", " ", "#1"}], "+", 
         RowBox[{"3492", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"1524", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"217", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"1152", " ", 
          SuperscriptBox["#1", "5"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "6"]}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["#1", "7"]}], "+", 
         RowBox[{"87", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "9"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         SuperscriptBox["#1", "12"]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["244141", "94827"], ",", 
         FractionBox["12086198", "1991367"], ",", 
         FractionBox["7515071", "3982734"], ",", 
         FractionBox["42845617", "35844606"], ",", 
         RowBox[{"-", 
          FractionBox["26501665", "11948202"]}], ",", 
         FractionBox["1373087", "17922303"], ",", 
         RowBox[{"-", 
          FractionBox["718309", "3982734"]}], ",", 
         FractionBox["890062", "5974101"], ",", 
         FractionBox["8969", "284481"], ",", 
         RowBox[{"-", 
          FractionBox["926321", "35844606"]}], ",", 
         RowBox[{"-", 
          FractionBox["3503", "5974101"]}], ",", 
         FractionBox["34196", "17922303"]}], "}"}], ",", "4"}], "]"}], ",", 
     RowBox[{"Algebraic", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"648", "+", 
         RowBox[{"2592", " ", "#1"}], "+", 
         RowBox[{"3492", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"1524", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"217", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"1152", " ", 
          SuperscriptBox["#1", "5"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "6"]}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["#1", "7"]}], "+", 
         RowBox[{"87", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "9"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         SuperscriptBox["#1", "12"]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["196718", "94827"]}], ",", 
         RowBox[{"-", 
          FractionBox["688153", "284481"]}], ",", 
         RowBox[{"-", 
          FractionBox["1293697", "568962"]}], ",", 
         FractionBox["3857569", "5120658"], ",", 
         FractionBox["3032287", "5120658"], ",", 
         FractionBox["1444985", "7680987"], ",", 
         FractionBox["4897", "1706886"], ",", 
         RowBox[{"-", 
          FractionBox["224722", "2560329"]}], ",", 
         FractionBox["2477", "853443"], ",", 
         FractionBox["55031", "5120658"], ",", 
         RowBox[{"-", 
          FractionBox["2143", "2560329"]}], ",", 
         RowBox[{"-", 
          FractionBox["5212", "7680987"]}]}], "}"}], ",", "4"}], "]"}], ",", 
     RowBox[{"Algebraic", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"648", "+", 
         RowBox[{"2592", " ", "#1"}], "+", 
         RowBox[{"3492", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"1524", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"217", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"1152", " ", 
          SuperscriptBox["#1", "5"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "6"]}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["#1", "7"]}], "+", 
         RowBox[{"87", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "9"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         SuperscriptBox["#1", "12"]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["47423", "94827"]}], ",", 
         RowBox[{"-", 
          FractionBox["5277760", "1991367"]}], ",", 
         FractionBox["770404", "1991367"], ",", 
         RowBox[{"-", 
          FractionBox["34924300", "17922303"]}], ",", 
         FractionBox["29139493", "17922303"], ",", 
         RowBox[{"-", 
          FractionBox["14234156", "53766909"]}], ",", 
         FractionBox["1060324", "5974101"], ",", 
         RowBox[{"-", 
          FractionBox["1097132", "17922303"]}], ",", 
         RowBox[{"-", 
          FractionBox["29384", "853443"]}], ",", 
         FractionBox["90184", "5974101"], ",", 
         FractionBox["25510", "17922303"], ",", 
         RowBox[{"-", 
          FractionBox["66104", "53766909"]}]}], "}"}], ",", "4"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 CellLabel->"Out[16]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell["Arithmetic within the common number field is much faster.", \
"MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"d", "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "y", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "x", "-", "y", "+", 
          SuperscriptBox["z", "2"]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", 
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"2", " ", "y"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "11"}], "+", 
          RowBox[{"x", " ", "y"}], "+", 
          SuperscriptBox["z", "2"]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"2", " ", "y", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "-", "x", "+", 
          RowBox[{"3", " ", "y", " ", "z"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", 
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"2", " ", "y"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"2", " ", "x"}], "+", 
          SuperscriptBox["z", "3"]}], ")"}]}]}]], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "aa"}], ",", 
       RowBox[{"y", "\[Rule]", "bb"}], ",", 
       RowBox[{"z", "\[Rule]", "cc"}]}], "}"}]}]}], ")"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[17]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.12109400000000126`", " ", "Second"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"648", "+", 
       RowBox[{"2592", " ", "#1"}], "+", 
       RowBox[{"3492", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"1524", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"217", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"1152", " ", 
        SuperscriptBox["#1", "5"]}], "-", 
       RowBox[{"14", " ", 
        SuperscriptBox["#1", "6"]}], "-", 
       RowBox[{"72", " ", 
        SuperscriptBox["#1", "7"]}], "+", 
       RowBox[{"87", " ", 
        SuperscriptBox["#1", "8"]}], "+", 
       RowBox[{"12", " ", 
        SuperscriptBox["#1", "9"]}], "-", 
       RowBox[{"14", " ", 
        SuperscriptBox["#1", "10"]}], "+", 
       SuperscriptBox["#1", "12"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3860776239867194137278", "3970535965319412941431"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["53260812035714120989033", "11911607895958238824293"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["109038458622656664030115", "71469647375749432945758"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["192381933793750243587991", "107204471063624149418637"]}],
        ",", 
       FractionBox["70556676211663475835676", "35734823687874716472879"], ",",
        
       RowBox[{"-", 
        FractionBox["106803727028468004471691", "964840239572617344767733"]}],
        ",", 
       FractionBox["7665080170226573969564", "35734823687874716472879"], ",", 
       
       RowBox[{"-", 
        FractionBox["36535823424460554318055", "321613413190872448255911"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["124880404825784359957", "3403316541702353949798"]}], ",",
        
       FractionBox["7067040798332263363508", "321613413190872448255911"], ",",
        
       FractionBox["7357016108927986451", "5104974812553530924697"], ",", 
       RowBox[{"-", 
        FractionBox["1522619721558874444783", "964840239572617344767733"]}]}],
       "}"}], ",", "4"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[17]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "Converting the resulting ",
 StyleBox["Algebraic", "MR"],
 " object to a ",
 StyleBox["Root", "MR"],
 " object is fast as well."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", "d", "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[18]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.13671900000000126`", " ", "Second"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"127463137729603858692", "+", 
       RowBox[{"15069520316552576640", " ", "#1"}], "+", 
       RowBox[{"3151085417830482145156", " ", 
        SuperscriptBox["#1", "2"]}], "-", 
       RowBox[{"10938243534840099267928", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"14492589303525156688533", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"7171605298335082808820", " ", 
        SuperscriptBox["#1", "5"]}], "-", 
       RowBox[{"947445370794828405814", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       RowBox[{"2510661531113587622448", " ", 
        SuperscriptBox["#1", "7"]}], "-", 
       RowBox[{"606316032776880635517", " ", 
        SuperscriptBox["#1", "8"]}], "-", 
       RowBox[{"100899537810316084288", " ", 
        SuperscriptBox["#1", "9"]}], "+", 
       RowBox[{"74049398920051042942", " ", 
        SuperscriptBox["#1", "10"]}], "-", 
       RowBox[{"12985018306589245140", " ", 
        SuperscriptBox["#1", "11"]}], "+", 
       RowBox[{"879298673075259913", " ", 
        SuperscriptBox["#1", "12"]}]}], "&"}], ",", "4"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[18]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["option name", "SO10",
      GridBoxOptions->{RowLines->{0.5, False},
      ColumnWidths->{0.2, 0.2, 0.6}}]],
      GridBoxOptions->{RowLines->{0.5, False},
      ColumnWidths->{0.2, 0.2, 0.6}}], Cell[TextData[StyleBox[
     "default value", "SO10",
      GridBoxOptions->{RowLines->{0.5, False},
      ColumnWidths->{0.2, 0.2, 0.6}}]],
      GridBoxOptions->{RowLines->{0.5, False},
      ColumnWidths->{0.2, 0.2, 0.6}}], " "},
    {
     StyleBox["SmallestField",
      "MR"], 
     StyleBox["False",
      "MR"], 
     RowBox[{
     "whether", " ", "the", " ", "common", " ", "field", " ", "in", " ", 
      "which", " ", 
      StyleBox["ToCommonField",
       "MR"], " ", "represents", " ", "the", " ", "given", " ", "algebraic", 
      " ", "numbers", " ", "needs", " ", "to", " ", "be", " ", "the", " ", 
      "smallest", " ", "possible"}]}
    }], TextForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{0.5, False},
 ColumnWidths->{0.2, 0.2, 0.6}},
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "Options of ",
 StyleBox["ToCommonField", "MR"],
 ". "
}], "Caption",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "With the default option setting, ",
 StyleBox["SmallestField -> False", "MR"],
 " ",
 StyleBox["ToCommonField", "MR"],
 " does not check whether ",
 StyleBox["Algebraic", "MR"],
 " objects in the input generate their number fields, and therefore it may \
find a common field that is not the smallest possible."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "Here the first ",
 StyleBox["Algebraic", "MR"],
 " object is equal to  ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]]],
 " so it does not generate the 4th degree field \[DoubleStruckCapitalQ](",
 StyleBox["Root[", "MR"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ","}]]],
 StyleBox["4]", "MR"],
 ") it is represented in. However the common field found by ",
 StyleBox["ToCommonField", "MR"],
 " contains the whole field \[DoubleStruckCapitalQ](",
 StyleBox["Root[", "MR"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ","}]]],
 StyleBox["4]", "MR"],
 ")."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCommonField", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Algebraic", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        SuperscriptBox["#1", "4"]}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         FractionBox["9", "2"]}], ",", "0", ",", 
        FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], ",", 
    SqrtBox["5"]}], "}"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"576", "-", 
       RowBox[{"960", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"352", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"40", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["5", "3"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["7", "72"]}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["7", "144"]}], ",", "0", ",", 
       FractionBox["1", "576"]}], "}"}], ",", "8"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"576", "-", 
       RowBox[{"960", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"352", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"40", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["53", "12"]}], ",", "0", ",", 
       FractionBox["95", "36"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["97", "288"]}], ",", "0", ",", 
       FractionBox["5", "576"]}], "}"}], ",", "8"}], "]"}]}], "}"}]], "Output",\

 CellLabel->"Out[19]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 StyleBox["SmallestField -> True", "MR"],
 " makes  ",
 StyleBox["ToCommonField", "MR"],
 " find the smallest field possible."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCommonField", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Algebraic", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", 
          FractionBox["9", "2"]}], ",", "0", ",", 
         FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], ",", 
     SqrtBox["5"]}], "}"}], ",", 
   RowBox[{"SmallestField", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"14", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["11", "6"]}], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}], ",", "4"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"14", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["17", "6"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}], ",", "4"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[20]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["MinimalPolynomial",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], Cell[TextData[{
      StyleBox[
      "give a pure function representation of the minimal polynomial over the \
integers of the algebraic number ",
       GridBoxOptions->{RowSpacings->1.5,
       ColumnSpacings->1,
       ColumnWidths->{0.4, 0.6},
       ColumnAlignments->{Left}}],
      StyleBox["a",
       FontSlant->"Italic"]
     }], "Text",
      GridBoxOptions->{RowSpacings->1.5,
      ColumnSpacings->1,
      ColumnWidths->{0.4, 0.6},
      ColumnAlignments->{Left}}]},
    {
     RowBox[{
      StyleBox["MinimalPolynomial",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox[
       RowBox[{"a", ",", " ", "x"}],
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
      "give", " ", "the", " ", "minimal", " ", "polynomial", " ", "of", " ", 
       "the", " ", "algebraic", " ", "number", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], ",", 
      RowBox[{
      "expressed", " ", "as", " ", "a", " ", "polynomial", " ", "in", " ", 
       StyleBox["x",
        FontSlant->"Italic"]}]}]},
    {
     RowBox[{
      StyleBox["AlgebraicIntegerQ",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{"give", " ", 
      StyleBox["True",
       "MR"], " ", "if", " ", "the", " ", "algebraic", " ", "number", " ", 
      StyleBox["a",
       FontSlant->"Italic"], " ", "is", " ", "an", " ", "algebraic", " ", 
      "integer", " ", "and", " ", 
      StyleBox["False",
       "MR"], " ", "otherwise"}]},
    {
     RowBox[{
      StyleBox["AlgebraicNumberDenominator",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
     "give", " ", "the", " ", "smallest", " ", "positive", " ", "integer", 
      " ", 
      StyleBox["n",
       FontSlant->"Italic"], " ", "such", " ", "that", " ", 
      StyleBox["n",
       FontSlant->"Italic"], 
      StyleBox[" ",
       FontSlant->"Italic"], 
      StyleBox["a",
       FontSlant->"Italic"], " ", "is", " ", "an", " ", "algebraic", " ", 
      "integer"}]},
    {
     RowBox[{
      StyleBox["AlgebraicNumberTrace",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
     "give", " ", "the", " ", "trace", " ", "of", " ", "the", " ", 
      "algebraic", " ", "number", " ", 
      StyleBox["a",
       FontSlant->"Italic"]}]},
    {
     RowBox[{
      StyleBox["AlgebraicNumberNorm",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
     "give", " ", "the", " ", "norm", " ", "of", " ", "the", " ", "algebraic",
       " ", "number", " ", 
      StyleBox["a",
       FontSlant->"Italic"]}]},
    {
     RowBox[{
      StyleBox["AlgebraicUnitQ",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{"give", " ", 
      StyleBox["True",
       "MR"], " ", "if", " ", "the", " ", "algebraic", " ", "number", " ", 
      StyleBox["a",
       FontSlant->"Italic"], " ", "is", " ", "an", " ", "algebraic", " ", 
      "unit", " ", "and", " ", 
      StyleBox["False",
       "MR"], " ", "otherwise"}]},
    {
     RowBox[{
      StyleBox["RootOfUnityQ",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{"give", " ", 
      StyleBox["True",
       "MR"], " ", "if", " ", "the", " ", "algebraic", " ", "number", " ", 
      StyleBox["a",
       FontSlant->"Italic"], " ", "is", " ", "a", " ", "root", " ", "of", " ",
       "unity", " ", "and", " ", 
      StyleBox["False",
       "MR"], " ", "otherwise"}]}
    }], TextForm]], "DefinitionBox",
 GridBoxOptions->{RowSpacings->1.5,
 ColumnSpacings->1,
 ColumnWidths->{0.4, 0.6},
 ColumnAlignments->{Left}},
 CellTags->"AlgebraicNumberFields"],

Cell["Functions for computing algebraic number properties. ", "Caption",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "The minimal polynomial of an algebraic number ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is the lowest degree polynomial ",
 StyleBox["f",
  FontSlant->"Italic"],
 " with integer coefficients and the smallest positive leading coefficient, \
such that  ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["a) ",
  FontSlant->"Italic"],
 "\[Equal] 0."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This gives the minimal polynomial of ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}]]],
 "expressed as a pure function."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["#1", "2"]}], "+", 
   SuperscriptBox["#1", "4"]}], "&"}]], "Output",
 CellLabel->"Out[21]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This gives the minimal polynomial of ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["#1", "5"], "-", 
        RowBox[{"2", " ", "#1"}], "+", "7"}], "&"}], ",", "1"}], "]"}], "2"], 
   "+", "1"}]]],
 " expressed as a polynomial in ",
 StyleBox["x",
  FontSlant->"Italic"],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#1", "5"], "-", 
         RowBox[{"2", " ", "#1"}], "+", "7"}], "&"}], ",", "1"}], "]"}], "2"],
     "+", "1"}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "50"}], "-", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 CellLabel->"Out[22]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "An algebraic number is an algebraic integer iff its ",
 StyleBox["MinimalPolynomial", "MR"],
 " is monic."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}]]],
 "is an algebraic integer."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[23]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}]]],
 "is not an algebraic integer."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[24]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This gives the smallest positive integer ",
 StyleBox["n",
  FontSlant->"Italic"],
 " for which ",
 StyleBox["n",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}], "/", "4"}]]],
 " is an algebraic integer."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[25]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "The trace of an algebraic number ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is the sum of all roots of ",
 StyleBox["MinimalPolynomial[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 "."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This gives the trace of",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"1", "/", "7"}]]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"1", "/", "7"}]], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[26]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "The norm of an algebraic number ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is the product of all roots of ",
 StyleBox["MinimalPolynomial[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 "."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This gives the norm of ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["3"], "+", 
   SqrtBox["5"]}]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "[", 
  RowBox[{
   SqrtBox["3"], "+", 
   SqrtBox["5"]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[27]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "An algebraic number ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is an algebraic unit iff both ",
 StyleBox["a",
  FontSlant->"Italic"],
 " and 1/",
 StyleBox["a",
  FontSlant->"Italic"],
 " are algebraic integers, or equivalently, iff ",
 StyleBox["AlgebraicNumberNorm[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " is 1 or -1."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This shows that ",
 StyleBox["GoldenRatio", "MR"],
 " is an algebraic unit."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", "GoldenRatio", "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[28]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["#1", "3"], "-", 
      RowBox[{"4", " ", "#1"}], "+", "17"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1"}], "]"}]]],
 "is not an algebraic unit."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["#1", "3"], "-", 
      RowBox[{"4", " ", "#1"}], "+", "17"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[29]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "An algebraic number ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is a root of unity iff ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["a", "n"], "\[Equal]", "1"}], TraditionalForm]]],
 " for some integer ",
 StyleBox["n",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["2"]}]]}]}], ")"}], "/", "2"}]]],
 " is a root of unity."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["2"]}]]}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[30]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["NumberFieldCharacteristicPolynomial",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
      "give", " ", "a", " ", "pure", " ", "function", " ", "representation", 
       " ", "of", " ", "the", " ", "characteristic", " ", "polynomial", " ", 
       "of", " ", "the", " ", 
       StyleBox["Algebraic",
        "MR"], " ", "object", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], ",", " ", 
      RowBox[{
      "relative", " ", "to", " ", "its", " ", "number", " ", "field"}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldCharacteristicPolynomial",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox[
       RowBox[{"a", ",", " ", "x"}],
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
      "give", " ", "the", " ", "characteristic", " ", "polynomial", " ", "of",
        " ", "the", " ", 
       StyleBox["Algebraic",
        "MR"], " ", "object", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], 
      StyleBox[",",
       FontSlant->"Italic"], " ", 
      RowBox[{
      "relative", " ", "to", " ", "its", " ", "number", " ", "field"}], ",", 
      " ", 
      RowBox[{
      "expressed", " ", "as", " ", "a", " ", "polynomial", " ", "in", " ", 
       StyleBox["x",
        FontSlant->"Italic"]}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldTrace",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"give", " ", "the", " ", "trace", " ", "of", " ", "the", " ", 
       StyleBox["Algebraic",
        "MR"], " ", "object", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], ",", " ", 
      RowBox[{
      "relative", " ", "to", " ", "its", " ", "number", " ", "field"}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldNorm",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"give", " ", "the", " ", "norm", " ", "of", " ", "the", " ", 
       StyleBox["Algebraic",
        "MR"], " ", "object", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], ",", " ", 
      RowBox[{
      "relative", " ", "to", " ", "its", " ", "number", " ", "field"}]}]}
    }], TextForm]], "DefinitionBox",
 GridBoxOptions->{RowSpacings->1.5,
 ColumnSpacings->1,
 ColumnWidths->{0.4, 0.6},
 ColumnAlignments->{Left}},
 CellTags->"AlgebraicNumberFields"],

Cell["\<\
Functions for computing properties of elements of algebraic number fields. \
\>", "Caption",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "If ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is ",
 StyleBox["Algebraic[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["coeffs",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["],", "MR"],
 " then ",
 StyleBox["NumberFieldCharacteristicPolynomial[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["x",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{
     StyleBox["MinimalPolynomial",
      "MR"], "[", 
     RowBox[{"a", ",", " ", "x"}], "]"}], "d"], TraditionalForm]]],
 ", where ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the extension degree of \[DoubleStruckCapitalQ](",
 StyleBox["Root[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 ")/\[DoubleStruckCapitalQ](",
 StyleBox["a",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 StyleBox["NumberFieldCharacteristicPolynomial", "MR"],
 " of ",
 Cell[BoxData[
  SqrtBox["2"]]],
 ", represented as an element of an extension of rationals of degree 4, is \
the square of ",
 StyleBox["MinimalPolynomial", "MR"],
 " of ",
 Cell[BoxData[
  SqrtBox["2"]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NumberFieldCharacteristicPolynomial", "[", 
   RowBox[{
    RowBox[{"Algebraic", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        SuperscriptBox["#1", "4"]}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         FractionBox["9", "2"]}], ",", "0", ",", 
        FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], ",", " ", "x"}], 
   "]"}], "//", "Factor"}]], "Input",
 CellLabel->"In[31]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], "2"]], "Output",
 CellLabel->"Out[31]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 StyleBox["NumberFieldTrace[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " is the sum of all roots of ",
 StyleBox["NumberFieldCharacteristicPolynomial[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 ". If ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is ",
 StyleBox["Algebraic[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["coeffs",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["],", "MR"],
 " then ",
 StyleBox["NumberFieldTrace[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", " ", 
    RowBox[{
     StyleBox["AlgebraicNumberTrace",
      "MR"], "[", "a", "]"}]}], TraditionalForm]]],
 ", where ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the extension degree of \[DoubleStruckCapitalQ](",
 StyleBox["Root[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 ")/\[DoubleStruckCapitalQ](",
 StyleBox["a",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 StyleBox["NumberFieldTrace", "MR"],
 " of ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", "1"}]]],
 ", represented as an element of an extension of rationals of degree 4, is \
twice the ",
 StyleBox["AlgebraicNumberTrace", "MR"],
 " of ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", "1"}]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldTrace", "[", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", 
       FractionBox["9", "2"]}], ",", "0", ",", 
      FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[32]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", 
       FractionBox["9", "2"]}], ",", "0", ",", 
      FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[33]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 StyleBox["NumberFieldNorm[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " is the product of all roots of ",
 StyleBox["NumberFieldCharacteristicPolynomial[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 ". If ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is ",
 StyleBox["Algebraic[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["coeffs",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 ", then ",
 StyleBox["NumberFieldNorm[", "MR"],
 StyleBox["a",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{
     StyleBox["AlgebraicNumberNorm",
      "MR"], "[", "a", "]"}], "d"], TraditionalForm]]],
 ", where ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the extension degree of \[DoubleStruckCapitalQ](",
 StyleBox["Root[", "MR"],
 StyleBox["f",
  FontSlant->"Italic"],
 ", ",
 StyleBox["k",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 ")/\[DoubleStruckCapitalQ](",
 StyleBox["a",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 StyleBox["NumberFieldNorm", "MR"],
 " of ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", "5"}]]],
 ", represented as an element of an extension of rationals of degree 4, is \
the square of ",
 StyleBox["AlgebraicNumberNorm", "MR"],
 " of ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", "5"}]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldNorm", "[", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", 
      RowBox[{"-", 
       FractionBox["9", "2"]}], ",", "0", ",", 
      FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["529"], "Output",
 CellLabel->"Out[34]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "[", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", 
      RowBox[{"-", 
       FractionBox["9", "2"]}], ",", "0", ",", 
      FractionBox["1", "2"]}], "}"}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["23"], "Output",
 CellLabel->"Out[35]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["IntegralBasis",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["f",
        FontSlant->"Italic"], ",", " ", 
       StyleBox["k",
        FontSlant->"Italic"]}], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
     "give", " ", "an", " ", "integral", " ", "basis", " ", "of", " ", "the", 
      " ", "field", " ", "\[DoubleStruckCapitalQ]", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["Root",
         "MR"], 
        StyleBox["[",
         "MR"], 
        RowBox[{
         StyleBox["f",
          FontSlant->"Italic"], ",", " ", 
         StyleBox["k",
          FontSlant->"Italic"]}], 
        StyleBox["]",
         "MR"]}], ")"}]}]},
    {
     RowBox[{
      StyleBox["IntegralBasis",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"for", " ", "an", " ", "algebraic", " ", "number", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], 
      StyleBox[",",
       FontSlant->"Italic"], " ", 
      RowBox[{
      "give", " ", "an", " ", "integral", " ", "basis", " ", "of", " ", "the",
        " ", "field", " ", "\[DoubleStruckCapitalQ]", 
       RowBox[{"(", 
        StyleBox["a",
         FontSlant->"Italic"], ")"}]}]}]},
    {
     RowBox[{
      StyleBox["RootsOfUnity",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["f",
        FontSlant->"Italic"], ",", " ", 
       StyleBox["k",
        FontSlant->"Italic"]}], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
     "give", " ", "the", " ", "roots", " ", "of", " ", "unity", " ", "in", 
      " ", "the", " ", "field", " ", "\[DoubleStruckCapitalQ]", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["Root",
         "MR"], 
        StyleBox["[",
         "MR"], 
        RowBox[{
         StyleBox["f",
          FontSlant->"Italic"], ",", " ", 
         StyleBox["k",
          FontSlant->"Italic"]}], 
        StyleBox["]",
         "MR"]}], ")"}]}]},
    {
     RowBox[{
      StyleBox["RootsOfUnity",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"for", " ", "an", " ", "algebraic", " ", "number", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], 
      StyleBox[",",
       FontSlant->"Italic"], " ", 
      RowBox[{
      "give", " ", "the", " ", "roots", " ", "of", " ", "unity", " ", "in", 
       " ", "the", " ", "field", " ", "\[DoubleStruckCapitalQ]", 
       RowBox[{"(", 
        StyleBox["a",
         FontSlant->"Italic"], ")"}]}]}]},
    {
     RowBox[{
      StyleBox["FundamentalUnits",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["f",
        FontSlant->"Italic"], ",", " ", 
       StyleBox["k",
        FontSlant->"Italic"]}], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
     "give", " ", "a", " ", "list", " ", "of", " ", "fundamental", " ", 
      "units", " ", "of", " ", "the", " ", "field", " ", 
      "\[DoubleStruckCapitalQ]", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["Root",
         "MR"], 
        StyleBox["[",
         "MR"], 
        RowBox[{
         StyleBox["f",
          FontSlant->"Italic"], ",", " ", 
         StyleBox["k",
          FontSlant->"Italic"]}], 
        StyleBox["]",
         "MR"]}], ")"}]}]},
    {
     RowBox[{
      StyleBox["FundamentalUnits",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       "TI"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"for", " ", "an", " ", "algebraic", " ", "number", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], 
      StyleBox[",",
       FontSlant->"Italic"], 
      StyleBox[" ",
       FontSlant->"Italic"], 
      RowBox[{
      "give", " ", "a", " ", "list", " ", "of", " ", "fundamental", " ", 
       "units", " ", "of", " ", "the", " ", "field", " ", 
       "\[DoubleStruckCapitalQ]", 
       RowBox[{"(", 
        StyleBox["a",
         FontSlant->"Italic"], ")"}]}]}]},
    {
     RowBox[{
      StyleBox["NormRepresentatives",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["m",
        FontSlant->"Italic"], ",", " ", 
       StyleBox["f",
        FontSlant->"Italic"], ",", " ", 
       StyleBox["k",
        FontSlant->"Italic"]}], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
       RowBox[{
       "give", " ", "representatives", " ", "of", " ", "classes", " ", "of", 
        " ", "algebraic", " ", "integers", " ", "of", " ", "norm"}], " ", 
       "\[PlusMinus]", 
       RowBox[{
        StyleBox["m",
         FontSlant->"Italic"], " ", "in", " ", "the", " ", "field", " ", 
        "\[DoubleStruckCapitalQ]", 
        RowBox[{"(", 
         RowBox[{
          StyleBox["Root",
           "MR"], 
          StyleBox["[",
           "MR"], 
          RowBox[{
           StyleBox["f",
            FontSlant->"Italic"], ",", " ", 
           StyleBox["k",
            FontSlant->"Italic"]}], 
          StyleBox["]",
           "MR"]}], ")"}]}]}], ",", "  ", 
      RowBox[{
      "up", " ", "to", " ", "multiplication", " ", "by", " ", "a", " ", 
       "unit"}]}]},
    {
     RowBox[{
      StyleBox["NormRepresentatives",
       "MR"], 
      StyleBox["[",
       "MR"], 
      RowBox[{
       StyleBox["m",
        FontSlant->"Italic"], ",", " ", 
       StyleBox["a",
        "TI"]}], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
       RowBox[{
       "give", " ", "representatives", " ", "of", " ", "classes", " ", "of", 
        " ", "algebraic", " ", "integers", " ", "of", " ", "norm"}], " ", 
       "\[PlusMinus]", 
       RowBox[{
        StyleBox["m",
         FontSlant->"Italic"], " ", "in", " ", "the", " ", "field", " ", 
        "\[DoubleStruckCapitalQ]", 
        RowBox[{"(", 
         StyleBox["a",
          FontSlant->"Italic"], ")"}]}]}], ",", " ", 
      RowBox[{
      "up", " ", "to", " ", "multiplication", " ", "by", " ", "a", " ", 
       "unit"}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldSignature",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["f",
       FontSlant->"Italic"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
      "for", " ", "an", " ", "irreducible", " ", "polynomial", " ", 
       "function", " ", 
       StyleBox["f",
        FontSlant->"Italic"], " ", "with", " ", "rational", " ", 
       "coefficients"}], ",", " ", 
      RowBox[{"return", " ", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["s",
          FontSlant->"Italic"], ",", " ", 
         StyleBox["t",
          FontSlant->"Italic"]}], "}"}]}], ",", " ", 
      RowBox[{"where", " ", 
       StyleBox["s",
        FontSlant->"Italic"], " ", "is", " ", "the", " ", "number", " ", "of",
        " ", "real", " ", "roots", " ", "of", " ", 
       StyleBox["f",
        FontSlant->"Italic"], " ", "and", " ", 
       StyleBox["t",
        FontSlant->"Italic"], " ", "is", " ", "the", " ", "number", " ", "of",
        " ", "conjugate", " ", "pairs", " ", "of", " ", "complex", " ", 
       "roots", " ", "of", " ", 
       StyleBox["f",
        FontSlant->"Italic"]}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldSignature",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       FontSlant->"Italic"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"for", " ", "an", " ", "algebraic", " ", "number", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], 
      StyleBox[",",
       FontSlant->"Italic"], " ", 
      RowBox[{"return", " ", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["s",
          FontSlant->"Italic"], ",", " ", 
         StyleBox["t",
          FontSlant->"Italic"]}], "}"}]}], ",", 
      RowBox[{"where", " ", 
       StyleBox["s",
        FontSlant->"Italic"], " ", "is", " ", "the", " ", "number", " ", "of",
        " ", "real", " ", "embeddings", " ", "of", " ", 
       "\[DoubleStruckCapitalQ]", 
       RowBox[{"(", 
        StyleBox["a",
         FontSlant->"Italic"], ")"}], " ", "in", " ", 
       "\[DoubleStruckCapitalC]"}], ",", " ", 
      RowBox[{"and", " ", 
       StyleBox["t",
        FontSlant->"Italic"], " ", "is", " ", "the", " ", "number", " ", "of",
        " ", "conjugate", " ", "pairs", " ", "of", " ", "complex", " ", 
       "embeddings", " ", "of", " ", "\[DoubleStruckCapitalQ]", 
       RowBox[{"(", 
        StyleBox["a",
         FontSlant->"Italic"], ")"}], " ", "in", " ", 
       "\[DoubleStruckCapitalC]"}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldDiscriminant",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["f",
       FontSlant->"Italic"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
      "for", " ", "an", " ", "irreducible", " ", "polynomial", " ", 
       "function", " ", 
       StyleBox["f",
        FontSlant->"Italic"], " ", "with", " ", "rational", " ", 
       "coefficients"}], ",", " ", 
      RowBox[{
      "give", " ", "the", " ", "discriminant", " ", "of", " ", "the", " ", 
       "number", " ", "field", " ", "generated", " ", "by", " ", "a", " ", 
       "root", " ", "of", " ", 
       StyleBox["f",
        FontSlant->"Italic"]}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldDiscriminant",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       FontSlant->"Italic"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"for", " ", "an", " ", "algebraic", " ", "number", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], 
      StyleBox[",",
       FontSlant->"Italic"], " ", 
      RowBox[{
      "give", " ", "the", " ", "discriminant", " ", "of", " ", "the", " ", 
       "field", " ", "\[DoubleStruckCapitalQ]", 
       RowBox[{"(", 
        StyleBox["a",
         FontSlant->"Italic"], ")"}]}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldRegulator",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["f",
       FontSlant->"Italic"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{
      "for", " ", "an", " ", "irreducible", " ", "polynomial", " ", 
       "function", " ", 
       StyleBox["f",
        FontSlant->"Italic"], " ", "with", " ", "rational", " ", 
       "coefficients"}], ",", " ", 
      RowBox[{
      "give", " ", "the", " ", "regulator", " ", "of", " ", "the", " ", 
       "number", " ", "field", " ", "generated", " ", "by", " ", "a", " ", 
       "root", " ", "of", " ", 
       StyleBox["f",
        FontSlant->"Italic"]}]}]},
    {
     RowBox[{
      StyleBox["NumberFieldRegulator",
       "MR"], 
      StyleBox["[",
       "MR"], 
      StyleBox["a",
       FontSlant->"Italic"], 
      StyleBox["]",
       "MR"]}], 
     RowBox[{
      RowBox[{"for", " ", "an", " ", "algebraic", " ", "number", " ", 
       StyleBox["a",
        FontSlant->"Italic"]}], 
      StyleBox[",",
       FontSlant->"Italic"], " ", 
      RowBox[{
      "give", " ", "the", " ", "regulator", " ", "of", " ", "the", " ", 
       "field", " ", "\[DoubleStruckCapitalQ]", 
       RowBox[{"(", 
        StyleBox["a",
         FontSlant->"Italic"], ")"}]}]}]}
    }], TextForm]], "DefinitionBox",
 GridBoxOptions->{RowSpacings->1.5,
 ColumnSpacings->1,
 ColumnWidths->{0.4, 0.6},
 ColumnAlignments->{Left}},
 CellTags->"AlgebraicNumberFields"],

Cell["\<\
Functions of computing properties of algebraic number fields. \
\>", "Caption",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "An integral basis of an algebraic number field ",
 StyleBox["K",
  FontSlant->"Italic"],
 " is a list of algebraic numbers forming a basis of the \
\[DoubleStruckCapitalZ]\[Hyphen]module of algebraic integers of ",
 StyleBox["K",
  FontSlant->"Italic"],
 ". ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["a", "n"]}], "}"}], TraditionalForm]]],
 " is an integral basis of an algebraic number field ",
 StyleBox["K",
  FontSlant->"Italic"],
 " iff  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "i"], TraditionalForm]]],
 StyleBox[" ",
  FontSlant->"Italic"],
 "\[Epsilon] ",
 StyleBox["K",
  FontSlant->"Italic"],
 " are algebraic integers, and every algebraic integer ",
 StyleBox["z ",
  FontSlant->"Italic"],
 "\[Epsilon] ",
 StyleBox["K",
  FontSlant->"Italic"],
 " can be uniquely represented as"
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 FormBox[
  RowBox[{"z", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["k", "1"], " ", 
     SubscriptBox["a", "1"]}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["k", "n"], 
     SubscriptBox["a", "n"]}]}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "with integer coefficients ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "i"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "This gives an integral basis of the field generated by the first root of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"533", "+", 
    RowBox[{"429", " ", "#1"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["#1", "2"]}], "+", 
    SuperscriptBox["#1", "3"]}], "&"}]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegralBasis", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"533", "+", 
     RowBox[{"429", " ", "#1"}], "+", 
     RowBox[{"18", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", " ", "1"}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"533", "+", 
       RowBox[{"429", " ", "#1"}], "+", 
       RowBox[{"18", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"533", "+", 
       RowBox[{"429", " ", "#1"}], "+", 
       RowBox[{"18", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["742", "759"], ",", 
       FractionBox["94", "759"], ",", 
       FractionBox["1", "759"]}], "}"}], ",", "1"}], "]"}]}], "}"}]], "Output",\

 CellLabel->"Out[36]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "Here is an integral basis of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", 
    SuperscriptBox["18", 
     RowBox[{"1", "/", "3"}]]}], TraditionalForm]]],
 ")."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegralBasis", "[", 
  SuperscriptBox["18", 
   RowBox[{"1", "/", "3"}]], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "18"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "18"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox["1", "3"]}], "}"}], ",", "1"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[37]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This gives the roots of unity in the field generated by the fourth root of \
",
 Cell[BoxData[
  RowBox[{
   RowBox[{"9", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["#1", "2"]}], "+", 
    SuperscriptBox["#1", "4"]}], "&"}]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootsOfUnity", "[", 
  RowBox[{
   RowBox[{"9", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["#1", "2"]}], "+", 
    SuperscriptBox["#1", "4"]}], "&"}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "12"]}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["5", "12"], ",", 
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "6"], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["1", "12"]}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       FractionBox["5", "12"], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[38]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "Here are all roots of unity in the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "("}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", " ", 
    RowBox[{"\[ImaginaryI]", 
     SqrtBox["3"]}]}], TraditionalForm]]],
 ")."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootsOfUnity", "[", 
  RowBox[{"1", "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["3"]}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "-", 
       RowBox[{"2", " ", "#1"}], "+", 
       SuperscriptBox["#1", "2"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       FractionBox["1", "2"]}], "}"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "-", 
       RowBox[{"2", " ", "#1"}], "+", 
       SuperscriptBox["#1", "2"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "-", 
       RowBox[{"2", " ", "#1"}], "+", 
       SuperscriptBox["#1", "2"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "2"]}], "}"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "-", 
       RowBox[{"2", " ", "#1"}], "+", 
       SuperscriptBox["#1", "2"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", "2"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[39]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["u", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["u", "n"]}], "}"}], TraditionalForm]]],
 " is a list of fundamental units of an algebraic number field ",
 StyleBox["K",
  FontSlant->"Italic"],
 " iff ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "i"], TraditionalForm]]],
 "\[Epsilon] ",
 StyleBox["K",
  FontSlant->"Italic"],
 " are algebraic units, and every algebraic unit ",
 StyleBox["u ",
  FontSlant->"Italic"],
 "\[Epsilon] ",
 StyleBox["K",
  FontSlant->"Italic"],
 " can be uniquely represented as"
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 FormBox[
  RowBox[{"u", "=", 
   RowBox[{"\[Xi]", " ", 
    SuperscriptBox[
     SubscriptBox["u", "1"], 
     SubscriptBox["n", "1"]], 
    SuperscriptBox[
     SubscriptBox["\[CenterEllipsis]u", "t"], 
     SubscriptBox["n", "t"]]}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "with a root of unity \[Xi] and integer exponents ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "Here is a set of fundamental units of the field generated by the third root \
of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#1", "4"], "-", 
    RowBox[{"10", " ", 
     SuperscriptBox["#1", "2"]}], "+", "1"}], "&"}]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FundamentalUnits", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["#1", "4"], "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", "1"}], "&"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["9", "4"], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}], "}"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       FractionBox["9", "2"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", "3"}], "]"}]}],
   "}"}]], "Output",
 CellLabel->"Out[40]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This gives a fundamental unit of the quadratic field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "("}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SqrtBox["21"], TraditionalForm]]],
 ")."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FundamentalUnits", "[", 
  SqrtBox["21"], "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "21"}], "+", 
      SuperscriptBox["#1", "2"]}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["5", "2"], ",", 
      FractionBox["1", "2"]}], "}"}], ",", "2"}], "]"}], "}"}]], "Output",
 CellLabel->"Out[41]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This gives a set of representatives of classes of elements of norm 9 in the \
field generated by the first root of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#1", "2"], "-", "7"}], "&"}]]],
 "."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormRepresentatives", "[", 
  RowBox[{"9", ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["#1", "2"], "-", "7"}], "&"}], ",", "1"}], "]"}]], "Input",\

 CellLabel->"In[42]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       SuperscriptBox["#1", "2"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "+", 
       SuperscriptBox["#1", "2"]}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "1"}], "}"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[42]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "Here is a set of representatives of classes of elements of norm 2 in the \
field ",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "("}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", " ", 
    SqrtBox["3"]}], TraditionalForm]]],
 ")."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormRepresentatives", "[", 
  RowBox[{"2", ",", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Algebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["9", "4"]}], ",", 
      FractionBox["9", "4"], ",", 
      FractionBox["1", "4"], ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], "}"}], ",", "4"}], "]"}], "}"}]], "Output",
 CellLabel->"Out[43]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This shows that the polynomial ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "5"], "+", 
    SuperscriptBox["#", "4"], "+", 
    SuperscriptBox["#", "3"], "+", 
    SuperscriptBox["#", "2"], "+", "1"}], "&"}]]],
 " has 1 real root and 2 conjugate pairs of complex roots."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "5"], "+", 
    SuperscriptBox["#", "4"], "+", 
    SuperscriptBox["#", "3"], "+", 
    SuperscriptBox["#", "2"], "+", "1"}], "&"}], "]"}]], "Input",
 CellLabel->"In[44]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[44]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This shows that the field  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "("}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", 
    StyleBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "3"], "-", 
         RowBox[{"11", " ", "#"}], "-", "2"}], "&"}], ",", "1"}], "]"}],
     "MR"], " ", "+", " ", 
    StyleBox[
     RowBox[{"Algebraic", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "4"], "-", 
         RowBox[{"3", " ", "#"}], "+", "1"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "2"}], "]"}],
     "MR"]}], TraditionalForm]]],
 ") has 12 real embeddings and 6 conjugate pairs of complex embeddings."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{
   SqrtBox["2"], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#", "3"], "-", 
       RowBox[{"11", " ", "#"}], "-", "2"}], "&"}], ",", "1"}], "]"}], "+", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#", "4"], "-", 
       RowBox[{"3", " ", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "2"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", ",", "6"}], "}"}]], "Output",
 CellLabel->"Out[45]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "The discriminant of a number field ",
 StyleBox["K",
  FontSlant->"Italic"],
 " is the discriminant of an integral basis ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["a", "n"]}], "}"}], TraditionalForm]]],
 " of ",
 StyleBox["K",
  FontSlant->"Italic"],
 " (i.e. the determinant of the matrix with elements ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["NumberFieldTrace",
     "MR"], "[", 
    RowBox[{
     SubscriptBox["a", "i"], " ", 
     SubscriptBox["a", "j"]}], 
    StyleBox["]",
     "MR"]}], TraditionalForm]]],
 "). The value of the determinant does not depend on the choice of integral \
basis."
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "Here is the discriminant of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "("}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "-", 
    SqrtBox["3"], "+", 
    SuperscriptBox["5", 
     RowBox[{"1", "/", "4"}]]}], TraditionalForm]]],
 ")."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{"2", "-", 
   SqrtBox["3"], "+", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "4"}]]}], "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["5184000000"], "Output",
 CellLabel->"Out[46]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This gives the discriminant of the field generated by a root of the \
polynomial ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "5"], "+", 
    SuperscriptBox["#", "4"], "+", 
    SuperscriptBox["#", "3"], "+", 
    SuperscriptBox["#", "2"], "+", "1"}], "&"}]]],
 ". The value of the discriminant does not depend on the choice of the root."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "5"], "+", 
    SuperscriptBox["#", "4"], "+", 
    SuperscriptBox["#", "3"], "+", 
    SuperscriptBox["#", "2"], "+", "1"}], "&"}], "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData["2297"], "Output",
 CellLabel->"Out[47]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "The regulator of a number field ",
 StyleBox["K",
  FontSlant->"Italic"],
 " is the lattice volume of the image of the group of units of ",
 StyleBox["K",
  FontSlant->"Italic"],
 " under the logarithmic embedding"
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"K", "\\", " ", 
    RowBox[{"{", "0", "}"}]}], "\[ReverseElement]", 
   RowBox[{"x", "\[LongRightArrow]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["Log",
        FontFamily->"Courier"], "[", 
       RowBox[{
        StyleBox["Abs",
         FontFamily->"Courier"], "[", 
        RowBox[{
         SubscriptBox["\[Sigma]", "1"], "(", "x", ")"}], "]"}], "]"}], ",", 
      "\[Ellipsis]", ",", 
      RowBox[{
       StyleBox["Log",
        FontFamily->"Courier"], "[", 
       RowBox[{
        StyleBox["Abs",
         FontFamily->"Courier"], "[", 
        RowBox[{
         SubscriptBox["\[Sigma]", "s"], "(", "x", ")"}], "]"}], "]"}], ",", 
      RowBox[{"2", 
       RowBox[{
        StyleBox["Log",
         FontFamily->"Courier"], "[", 
        RowBox[{
         StyleBox["Abs",
          FontFamily->"Courier"], "[", 
         RowBox[{
          SubscriptBox["\[Sigma]", 
           RowBox[{"s", "+", "1"}]], "(", "x", ")"}], "]"}], "]"}]}], ",", 
      "\[Ellipsis]", ",", 
      RowBox[{"2", 
       RowBox[{
        StyleBox["Log",
         FontFamily->"Courier"], "[", 
        RowBox[{
         StyleBox["Abs",
          FontFamily->"Courier"], "[", 
         RowBox[{
          SubscriptBox["\[Sigma]", 
           RowBox[{"s", "+", "t"}]], "(", "x", ")"}], "]"}], "]"}]}]}], 
     "}"}]}], "\[Element]", 
   SuperscriptBox["\[DoubleStruckCapitalR]", 
    RowBox[{"s", "+", "t"}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 StyleBox["where ",
  FontSlant->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", 
     StyleBox["1",
      FontSlant->"Italic"]], ",", "\[Ellipsis]", ",", 
    SubscriptBox["\[Sigma]", "s"]}], TraditionalForm]]],
 StyleBox["are the real embeddings of ",
  FontSlant->"Plain"],
 StyleBox["K",
  FontSlant->"Italic"],
 StyleBox[" in \[DoubleStruckCapitalC], and ",
  FontSlant->"Plain"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", 
     RowBox[{"s", "+", 
      StyleBox["1",
       FontSlant->"Plain"]}]], ",", "\[Ellipsis]", ",", 
    SubscriptBox["\[Sigma]", 
     RowBox[{"s", "+", "t"}]]}], TraditionalForm]]],
 StyleBox["are one of each conjugate pair of",
  FontSlant->"Plain"],
 " ",
 StyleBox["the complex embeddings of ",
  FontSlant->"Plain"],
 StyleBox["K",
  FontSlant->"Italic"],
 StyleBox[" in \[DoubleStruckCapitalC].",
  FontSlant->"Plain"]
}], "Text",
 CellTags->"AlgebraicNumberFields"],

Cell[TextData[{
 "Here is the regulator of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "("}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SqrtBox["61"], TraditionalForm]]],
 ")."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  SqrtBox["61"], "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"Abs", "[", 
    RowBox[{"Algebraic", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "61"}], "+", 
        SuperscriptBox["#1", "2"]}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["39", "2"]}], ",", 
        FractionBox["5", "2"]}], "}"}], ",", "1"}], "]"}], "]"}], "]"}], 
  "]"}]], "Output",
 CellLabel->"Out[48]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[TextData[{
 "This gives the regulator of the field generated by a root of the polynomial \
",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#1", "3"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["#1", "2"]}], "+", "1"}], "&"}]]],
 ". The value of the regulator does not depend on the choice of the root."
}], "MathCaption",
 CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["#1", "3"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["#1", "2"]}], "+", "1"}], "&"}], "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellTags->"AlgebraicNumberFields"],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Algebraic", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "2"}], "]"}], "]"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Algebraic", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "]"}], "]"}], "]"}]}], "-",
    
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Algebraic", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "1"}], "]"}], "]"}], "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Algebraic", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "2"}], "]"}], "]"}], "]"}]}]}], 
  "]"}]], "Output",
 CellLabel->"Out[49]=",
 CellTags->"AlgebraicNumberFields"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "AlgebraicNumberFields"->{
    Cell[1776, 53, 93, 1, 36, "Subsection",
      CellTags->"AlgebraicNumberFields"],
    Cell[1872, 56, 372, 7, 56, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[2247, 65, 1099, 24, 152, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[3349, 91, 1816, 58, 60, "DefinitionBox",
      CellTags->"AlgebraicNumberFields"],
    Cell[5168, 151, 148, 4, 15, "Caption",
      CellTags->"AlgebraicNumberFields"],
    Cell[5319, 157, 82, 1, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[5404, 160, 143, 3, 26, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[5550, 165, 1074, 45, 72, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[6649, 214, 325, 10, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[6977, 226, 297, 9, 27, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[7289, 238, 190, 6, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[7504, 248, 137, 4, 26, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[7644, 254, 130, 2, 25, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[7789, 259, 2453, 114, 88, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[10245, 375, 666, 21, 31, "DisplayFormula",
      CellTags->"AlgebraicNumberFields"],
    Cell[10914, 398, 243, 5, 56, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[11182, 407, 383, 12, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[11568, 421, 404, 13, 40, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[11987, 437, 466, 20, 56, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[12478, 461, 275, 9, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[12756, 472, 299, 10, 22, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[13070, 485, 181, 5, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[13276, 494, 373, 11, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[13652, 507, 87, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[13754, 512, 451, 12, 56, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[14230, 528, 1057, 36, 96, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[15290, 566, 886, 20, 146, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[16191, 589, 203, 8, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[16419, 601, 123, 3, 26, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[16545, 606, 415, 13, 22, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[16975, 622, 2377, 74, 94, "DefinitionBox",
      CellTags->"AlgebraicNumberFields"],
    Cell[19355, 698, 160, 4, 15, "Caption",
      CellTags->"AlgebraicNumberFields"],
    Cell[19518, 704, 209, 5, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[19752, 713, 201, 7, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[19956, 722, 875, 29, 64, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[20846, 754, 430, 17, 25, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[21301, 775, 317, 10, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[21621, 787, 433, 14, 34, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[22069, 804, 200, 4, 36, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[22272, 810, 487, 24, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[22762, 836, 1525, 50, 71, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[24290, 888, 366, 17, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[24681, 909, 340, 11, 26, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[25024, 922, 1332, 33, 140, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[26371, 958, 307, 13, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[26703, 975, 334, 11, 26, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[27040, 988, 5207, 139, 409, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[32262, 1130, 118, 2, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[32405, 1136, 1415, 44, 64, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[33823, 1182, 2281, 62, 242, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[36119, 1247, 201, 7, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[36345, 1258, 152, 4, 26, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[36500, 1264, 1341, 33, 140, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[37856, 1300, 1061, 27, 76, "DefinitionBox3Col",
      CellTags->"AlgebraicNumberFields"],
    Cell[38920, 1329, 122, 5, 15, "Caption",
      CellTags->"AlgebraicNumberFields"],
    Cell[39045, 1336, 376, 10, 40, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[39424, 1348, 894, 31, 73, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[40343, 1383, 568, 18, 41, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[40914, 1403, 1407, 43, 105, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[42336, 1449, 210, 7, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[42571, 1460, 651, 20, 61, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[43225, 1482, 876, 29, 64, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[44116, 1514, 4215, 158, 250, "DefinitionBox",
      CellTags->"AlgebraicNumberFields"],
    Cell[48334, 1674, 108, 1, 15, "Caption",
      CellTags->"AlgebraicNumberFields"],
    Cell[48445, 1677, 423, 16, 40, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[48871, 1695, 215, 8, 41, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[49111, 1707, 179, 6, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[49293, 1715, 216, 7, 22, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[49524, 1725, 444, 17, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[49993, 1746, 399, 13, 31, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[50395, 1761, 360, 12, 22, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[50770, 1776, 172, 5, 20, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[50945, 1783, 249, 10, 45, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[51219, 1797, 239, 8, 41, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[51461, 1807, 91, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[51567, 1812, 253, 10, 29, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[51845, 1826, 239, 8, 41, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[52087, 1836, 92, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[52194, 1841, 347, 14, 26, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[52566, 1859, 248, 8, 41, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[52817, 1869, 88, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[52920, 1874, 278, 11, 20, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[53201, 1887, 216, 9, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[53442, 1900, 225, 7, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[53670, 1909, 88, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[53773, 1914, 281, 11, 20, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[54057, 1927, 173, 8, 41, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[54255, 1939, 181, 6, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[54439, 1947, 88, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[54542, 1952, 422, 17, 36, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[54967, 1971, 149, 5, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[55141, 1980, 137, 3, 26, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[55281, 1985, 91, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[55387, 1990, 386, 13, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[55798, 2007, 375, 12, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[56176, 2021, 92, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[56283, 2026, 330, 14, 20, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[56616, 2042, 367, 15, 54, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[57008, 2061, 378, 14, 43, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[57389, 2077, 91, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[57495, 2082, 2607, 92, 130, "DefinitionBox",
      CellTags->"AlgebraicNumberFields"],
    Cell[60105, 2176, 138, 3, 15, "Caption",
      CellTags->"AlgebraicNumberFields"],
    Cell[60246, 2181, 1000, 47, 40, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[61249, 2230, 347, 13, 58, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[61621, 2247, 591, 18, 61, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[62215, 2267, 204, 7, 23, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[62434, 2277, 1158, 52, 52, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[63595, 2331, 375, 15, 58, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[63995, 2350, 486, 15, 41, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[64484, 2367, 88, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[64609, 2374, 490, 15, 37, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[65102, 2391, 88, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[65205, 2396, 1160, 52, 52, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[66368, 2450, 377, 15, 58, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[66770, 2469, 485, 15, 41, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[67258, 2486, 90, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[67385, 2493, 489, 15, 37, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[67877, 2510, 89, 2, 20, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[67981, 2515, 11486, 401, 436, "DefinitionBox",
      CellTags->"AlgebraicNumberFields"],
    Cell[79470, 2918, 125, 3, 15, "Caption",
      CellTags->"AlgebraicNumberFields"],
    Cell[79598, 2923, 961, 35, 56, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[80562, 2960, 411, 12, 30, "DisplayFormula",
      CellTags->"AlgebraicNumberFields"],
    Cell[80976, 2974, 172, 7, 24, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[81151, 2983, 347, 11, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[81523, 2998, 333, 10, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[81859, 3010, 884, 28, 65, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[82758, 3041, 259, 9, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[83042, 3054, 175, 5, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[83220, 3061, 643, 21, 40, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[83878, 3085, 310, 11, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[84213, 3100, 257, 8, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[84473, 3110, 2735, 90, 210, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[87223, 3203, 339, 12, 41, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[87587, 3219, 198, 6, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[87788, 3227, 1338, 45, 125, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[89141, 3275, 668, 26, 36, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[89812, 3303, 424, 12, 30, "DisplayFormula",
      CellTags->"AlgebraicNumberFields"],
    Cell[90239, 3317, 195, 7, 24, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[90437, 3326, 315, 11, 40, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[90777, 3341, 293, 10, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[91073, 3353, 1276, 42, 84, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[92364, 3398, 289, 10, 25, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[92678, 3412, 142, 4, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[92823, 3418, 379, 13, 34, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[93217, 3434, 285, 9, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[93527, 3447, 239, 8, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[93769, 3457, 667, 24, 40, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[94451, 3484, 366, 14, 25, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[94842, 3502, 207, 7, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[95052, 3511, 540, 18, 34, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[95607, 3532, 363, 11, 24, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[95995, 3547, 309, 9, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[96307, 3558, 133, 4, 25, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[96455, 3565, 877, 29, 57, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[97357, 3598, 605, 20, 50, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[97965, 3620, 134, 4, 25, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[98114, 3627, 774, 28, 40, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[98891, 3657, 350, 13, 41, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[99266, 3674, 232, 7, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[99501, 3683, 97, 2, 25, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[99613, 3688, 431, 12, 56, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[100069, 3704, 312, 9, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[100384, 3715, 91, 2, 25, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[100490, 3720, 280, 9, 24, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[100773, 3731, 1635, 51, 30, "DisplayFormula",
      CellTags->"AlgebraicNumberFields"],
    Cell[102411, 3784, 972, 35, 40, "Text",
      CellTags->"AlgebraicNumberFields"],
    Cell[103386, 3821, 261, 10, 41, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[103672, 3835, 146, 4, 32, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[103821, 3841, 496, 17, 40, "Output",
      CellTags->"AlgebraicNumberFields"],
    Cell[104332, 3861, 381, 11, 56, "MathCaption",
      CellTags->"AlgebraicNumberFields"],
    Cell[104738, 3876, 265, 8, 30, "Input",
      CellTags->"AlgebraicNumberFields"],
    Cell[105006, 3886, 1795, 56, 81, "Output",
      CellTags->"AlgebraicNumberFields"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"AlgebraicNumberFields", 107520, 3964}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 93, 1, 36, "Subsection",
  CellTags->"AlgebraicNumberFields"],
Cell[1872, 56, 372, 7, 56, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[2247, 65, 1099, 24, 152, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[3349, 91, 1816, 58, 60, "DefinitionBox",
  CellTags->"AlgebraicNumberFields"],
Cell[5168, 151, 148, 4, 15, "Caption",
  CellTags->"AlgebraicNumberFields"],
Cell[5319, 157, 82, 1, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],
Cell[5404, 160, 143, 3, 26, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[5550, 165, 1074, 45, 72, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[6649, 214, 325, 10, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[6977, 226, 297, 9, 27, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[7289, 238, 190, 6, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[7504, 248, 137, 4, 26, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[7644, 254, 130, 2, 25, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[7789, 259, 2453, 114, 88, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[10245, 375, 666, 21, 31, "DisplayFormula",
  CellTags->"AlgebraicNumberFields"],
Cell[10914, 398, 243, 5, 56, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[11182, 407, 383, 12, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[11568, 421, 404, 13, 40, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[11987, 437, 466, 20, 56, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[12478, 461, 275, 9, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[12756, 472, 299, 10, 22, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[13070, 485, 181, 5, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[13276, 494, 373, 11, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[13652, 507, 87, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[13754, 512, 451, 12, 56, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[14230, 528, 1057, 36, 96, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[15290, 566, 886, 20, 146, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[16191, 589, 203, 8, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[16419, 601, 123, 3, 26, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[16545, 606, 415, 13, 22, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[16975, 622, 2377, 74, 94, "DefinitionBox",
  CellTags->"AlgebraicNumberFields"],
Cell[19355, 698, 160, 4, 15, "Caption",
  CellTags->"AlgebraicNumberFields"],
Cell[19518, 704, 209, 5, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[19752, 713, 201, 7, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[19956, 722, 875, 29, 64, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[20846, 754, 430, 17, 25, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[21301, 775, 317, 10, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[21621, 787, 433, 14, 34, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[22069, 804, 200, 4, 36, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[22272, 810, 487, 24, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],
Cell[22762, 836, 1525, 50, 71, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[24290, 888, 366, 17, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[24681, 909, 340, 11, 26, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[25024, 922, 1332, 33, 140, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[26371, 958, 307, 13, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[26703, 975, 334, 11, 26, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[27040, 988, 5207, 139, 409, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[32262, 1130, 118, 2, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[32405, 1136, 1415, 44, 64, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[33823, 1182, 2281, 62, 242, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[36119, 1247, 201, 7, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[36345, 1258, 152, 4, 26, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[36500, 1264, 1341, 33, 140, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[37856, 1300, 1061, 27, 76, "DefinitionBox3Col",
  CellTags->"AlgebraicNumberFields"],
Cell[38920, 1329, 122, 5, 15, "Caption",
  CellTags->"AlgebraicNumberFields"],
Cell[39045, 1336, 376, 10, 40, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[39424, 1348, 894, 31, 73, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[40343, 1383, 568, 18, 41, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[40914, 1403, 1407, 43, 105, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[42336, 1449, 210, 7, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[42571, 1460, 651, 20, 61, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[43225, 1482, 876, 29, 64, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[44116, 1514, 4215, 158, 250, "DefinitionBox",
  CellTags->"AlgebraicNumberFields"],
Cell[48334, 1674, 108, 1, 15, "Caption",
  CellTags->"AlgebraicNumberFields"],
Cell[48445, 1677, 423, 16, 40, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[48871, 1695, 215, 8, 41, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[49111, 1707, 179, 6, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[49293, 1715, 216, 7, 22, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[49524, 1725, 444, 17, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[49993, 1746, 399, 13, 31, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[50395, 1761, 360, 12, 22, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[50770, 1776, 172, 5, 20, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[50945, 1783, 249, 10, 45, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[51219, 1797, 239, 8, 41, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[51461, 1807, 91, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[51567, 1812, 253, 10, 29, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[51845, 1826, 239, 8, 41, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[52087, 1836, 92, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[52194, 1841, 347, 14, 26, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[52566, 1859, 248, 8, 41, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[52817, 1869, 88, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[52920, 1874, 278, 11, 20, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[53201, 1887, 216, 9, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[53442, 1900, 225, 7, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[53670, 1909, 88, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[53773, 1914, 281, 11, 20, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[54057, 1927, 173, 8, 41, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[54255, 1939, 181, 6, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[54439, 1947, 88, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[54542, 1952, 422, 17, 36, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[54967, 1971, 149, 5, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[55141, 1980, 137, 3, 26, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[55281, 1985, 91, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[55387, 1990, 386, 13, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[55798, 2007, 375, 12, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[56176, 2021, 92, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[56283, 2026, 330, 14, 20, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[56616, 2042, 367, 15, 54, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[57008, 2061, 378, 14, 43, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[57389, 2077, 91, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[57495, 2082, 2607, 92, 130, "DefinitionBox",
  CellTags->"AlgebraicNumberFields"],
Cell[60105, 2176, 138, 3, 15, "Caption",
  CellTags->"AlgebraicNumberFields"],
Cell[60246, 2181, 1000, 47, 40, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[61249, 2230, 347, 13, 58, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[61621, 2247, 591, 18, 61, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[62215, 2267, 204, 7, 23, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[62434, 2277, 1158, 52, 52, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[63595, 2331, 375, 15, 58, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[63995, 2350, 486, 15, 41, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[64484, 2367, 88, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64609, 2374, 490, 15, 37, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[65102, 2391, 88, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[65205, 2396, 1160, 52, 52, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[66368, 2450, 377, 15, 58, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[66770, 2469, 485, 15, 41, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[67258, 2486, 90, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],

Cell[CellGroupData[{
Cell[67385, 2493, 489, 15, 37, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[67877, 2510, 89, 2, 20, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[67981, 2515, 11486, 401, 436, "DefinitionBox",
  CellTags->"AlgebraicNumberFields"],
Cell[79470, 2918, 125, 3, 15, "Caption",
  CellTags->"AlgebraicNumberFields"],
Cell[79598, 2923, 961, 35, 56, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[80562, 2960, 411, 12, 30, "DisplayFormula",
  CellTags->"AlgebraicNumberFields"],
Cell[80976, 2974, 172, 7, 24, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[81151, 2983, 347, 11, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[81523, 2998, 333, 10, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[81859, 3010, 884, 28, 65, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[82758, 3041, 259, 9, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[83042, 3054, 175, 5, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[83220, 3061, 643, 21, 40, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[83878, 3085, 310, 11, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[84213, 3100, 257, 8, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[84473, 3110, 2735, 90, 210, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[87223, 3203, 339, 12, 41, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[87587, 3219, 198, 6, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[87788, 3227, 1338, 45, 125, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[89141, 3275, 668, 26, 36, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[89812, 3303, 424, 12, 30, "DisplayFormula",
  CellTags->"AlgebraicNumberFields"],
Cell[90239, 3317, 195, 7, 24, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[90437, 3326, 315, 11, 40, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[90777, 3341, 293, 10, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[91073, 3353, 1276, 42, 84, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[92364, 3398, 289, 10, 25, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[92678, 3412, 142, 4, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[92823, 3418, 379, 13, 34, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[93217, 3434, 285, 9, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[93527, 3447, 239, 8, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[93769, 3457, 667, 24, 40, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[94451, 3484, 366, 14, 25, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[94842, 3502, 207, 7, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[95052, 3511, 540, 18, 34, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[95607, 3532, 363, 11, 24, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[95995, 3547, 309, 9, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[96307, 3558, 133, 4, 25, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[96455, 3565, 877, 29, 57, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[97357, 3598, 605, 20, 50, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[97965, 3620, 134, 4, 25, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[98114, 3627, 774, 28, 40, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[98891, 3657, 350, 13, 41, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[99266, 3674, 232, 7, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[99501, 3683, 97, 2, 25, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[99613, 3688, 431, 12, 56, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[100069, 3704, 312, 9, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[100384, 3715, 91, 2, 25, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[100490, 3720, 280, 9, 24, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[100773, 3731, 1635, 51, 30, "DisplayFormula",
  CellTags->"AlgebraicNumberFields"],
Cell[102411, 3784, 972, 35, 40, "Text",
  CellTags->"AlgebraicNumberFields"],
Cell[103386, 3821, 261, 10, 41, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[103672, 3835, 146, 4, 32, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[103821, 3841, 496, 17, 40, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]],
Cell[104332, 3861, 381, 11, 56, "MathCaption",
  CellTags->"AlgebraicNumberFields"],

Cell[CellGroupData[{
Cell[104738, 3876, 265, 8, 30, "Input",
  CellTags->"AlgebraicNumberFields"],
Cell[105006, 3886, 1795, 56, 81, "Output",
  CellTags->"AlgebraicNumberFields"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

