(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    766805,      40850]*)
(*NotebookOutlinePosition[    773303,      41037]*)
(*  CellTagsIndexPosition[    772885,      41018]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Graphics",
  StyleBox["`", "MB"],
  "Animation",
  StyleBox["`", "MB"]
}], "Subsection",
  CellTags->{"S5.25.1", "1.1"}],

Cell["\<\
The ability to view dynamic effects with an animated sequence of \
graphics is often highly instructive. The effect of motion is produced by \
displaying a sequence of frames in rapid succession. \
\>", "Text",
  CellTags->{"S5.25.1", "1.2"}],

Cell[TextData[{
  "A collection of useful routines is supplied in the package ",
  StyleBox["Graphics`Animation`", "MR"],
  ". These provide tools for generating sequences of graphical images and \
displaying them on a variety of computer platforms. "
}], "Text",
  CellTags->{"S5.25.1", "1.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Animate[\"\>",
                      "MR"], 
                    StyleBox["\<\"grcom\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmax\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"dt\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"execute the graphics command \"\>", 
                    StyleBox["\<\"grcom\"\>",
                      
                      "TI"], "\<\" for the range of values of the parameter \
\"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], "\<\" using steps of \"\>", 
                    StyleBox["\<\"dt\"\>",
                      "TI"], "\<\" and animate the resulting sequence \"\>"}],
                   TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ShowAnimation[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"p\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"p\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"p\"\>",
                              "TI"], "\<\"3\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"animate the sequence of graphics objects, \
\"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"p\"\>",
                              "TI"], 
                            StyleBox["\<\"i\"\>",
                              "TI"]], TraditionalForm]], "InlineFormula"]}], 
                  TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.25.1"],

Cell["The basic animation commands. ", "Caption",
  CellTags->"S5.25.1"],

Cell[TextData[{
  "In this section animations are represented by arrays of the pictures. If \
you evaluate the ",
  StyleBox["Mathematica", "TI"],
  " commands on your computer, each image will be displayed in rapid \
succession giving the appearance of motion. "
}], "Text",
  CellTags->{"S5.25.1", "1.4"}],

Cell["This loads the package. ", "MathCaption",
  CellTags->{"S5.25.1", "1.5"}],

Cell["<<Graphics`Animation`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S5.25.1"],

Cell["\<\
This gives an animation of sine waves with various frequencies. \
\
\>", "MathCaption",
  CellTags->{"S5.25.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
Animate[Plot[Sin[n x], {x, 0, 2 Pi}, Axes -> False], {n, 1, 6, \
1}]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .40558 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00965678 0.31746 [
[ 0 0 0 0 ]
[ 1 .40558 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .40558 L
0 .40558 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00965678 0.321429 0.193595 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151653 0.309025 0.294311 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30903 m
.02533 .32079 L
.02684 .33255 L
.02836 .34426 L
.02988 .35591 L
.03139 .3675 L
.03291 .37898 L
.03443 .39036 L
.03594 .40161 L
.03746 .4127 L
.03897 .42364 L
.04049 .43438 L
.04201 .44493 L
.04352 .45526 L
.04504 .46536 L
.04656 .47521 L
.04807 .48479 L
.04959 .49409 L
.05111 .50309 L
.05262 .51178 L
.05414 .52015 L
.05566 .52818 L
.05717 .53586 L
.05869 .54318 L
.06021 .55012 L
.06172 .55668 L
.06324 .56284 L
.06476 .56859 L
.06627 .57393 L
.06779 .57885 L
.06931 .58333 L
.07082 .58738 L
.07234 .59098 L
.07386 .59413 L
.07537 .59682 L
.07689 .59905 L
.0784 .60082 L
.07992 .60212 L
.08144 .60296 L
.08295 .60332 L
.08447 .60321 L
.08599 .60263 L
.0875 .60158 L
.08902 .60007 L
.09054 .59808 L
.09205 .59564 L
.09357 .59274 L
.09509 .58938 L
.0966 .58557 L
.09812 .58133 L
Mistroke
.09964 .57664 L
.10115 .57153 L
.10267 .566 L
.10419 .56005 L
.1057 .55371 L
.10722 .54697 L
.10874 .53986 L
.11025 .53237 L
.11177 .52453 L
.11328 .51634 L
.1148 .50782 L
.11632 .49898 L
.11783 .48984 L
.11935 .48041 L
.12087 .47071 L
.12238 .46074 L
.1239 .45054 L
.12542 .4401 L
.12693 .42946 L
.12845 .41863 L
.12997 .40762 L
.13148 .39645 L
.133 .38514 L
.13452 .37371 L
.13603 .36218 L
.13755 .35056 L
.13907 .33887 L
.14058 .32714 L
.1421 .31538 L
.14362 .30361 L
.14513 .29185 L
.14665 .28011 L
.14816 .26842 L
.14968 .2568 L
.1512 .24526 L
.15271 .23382 L
.15423 .2225 L
.15575 .21132 L
.15726 .2003 L
.15878 .18945 L
.1603 .17879 L
.16181 .16834 L
.16333 .15811 L
.16485 .14813 L
.16636 .1384 L
.16788 .12895 L
.1694 .11978 L
.17091 .11092 L
.17243 .10238 L
.17395 .09416 L
Mistroke
.17546 .08629 L
.17698 .07878 L
.1785 .07163 L
.18001 .06486 L
.18153 .05849 L
.18305 .05251 L
.18456 .04695 L
.18608 .0418 L
.18759 .03708 L
.18911 .0328 L
.19063 .02896 L
.19214 .02557 L
.19366 .02263 L
.19518 .02014 L
.19669 .01813 L
.19821 .01657 L
.19973 .01549 L
.20124 .01487 L
.20276 .01472 L
.20428 .01505 L
.20579 .01584 L
.20731 .01711 L
.20883 .01884 L
.21034 .02103 L
.21186 .02369 L
.21338 .0268 L
.21489 .03037 L
.21641 .03438 L
.21793 .03883 L
.21944 .04371 L
.22096 .04902 L
.22247 .05474 L
.22399 .06087 L
.22551 .06739 L
.22702 .0743 L
.22854 .08159 L
.23006 .08924 L
.23157 .09725 L
.23309 .10559 L
.23461 .11426 L
.23612 .12324 L
.23764 .13251 L
.23916 .14207 L
.24067 .1519 L
.24219 .16198 L
.24371 .17229 L
.24522 .18282 L
.24674 .19355 L
.24826 .20447 L
.24977 .21556 L
Mistroke
.25129 .22679 L
.25281 .23816 L
.25432 .24964 L
.25584 .26121 L
.25736 .27286 L
.25887 .28457 L
.26039 .29632 L
.2619 .30809 L
.26342 .31986 L
.26494 .33161 L
.26645 .34333 L
.26797 .35499 L
.26949 .36658 L
.271 .37807 L
.27252 .38946 L
.27404 .40072 L
.27555 .41183 L
.27707 .42277 L
.27859 .43354 L
.2801 .4441 L
.28162 .45445 L
.28314 .46456 L
.28465 .47443 L
.28617 .48403 L
.28769 .49336 L
.2892 .50238 L
.29072 .5111 L
.29224 .5195 L
.29375 .52755 L
.29527 .53526 L
.29678 .54261 L
.2983 .54958 L
.29982 .55617 L
.30133 .56236 L
.30285 .56815 L
.30437 .57352 L
.30588 .57847 L
.3074 .58299 L
.30892 .58707 L
.31043 .59071 L
.31195 .59389 L
.31347 .59662 L
.31498 .59889 L
.3165 .6007 L
.31802 .60204 L
.31953 .60291 L
.32105 .60331 L
.32257 .60324 L
.32408 .60269 L
.3256 .60168 L
Mistroke
.32712 .6002 L
.32863 .59826 L
.33015 .59585 L
.33167 .59298 L
.33318 .58966 L
.3347 .58589 L
.33621 .58168 L
.33773 .57703 L
.33925 .57195 L
.34076 .56645 L
.34228 .56054 L
.3438 .55423 L
.34531 .54753 L
.34683 .54044 L
.34835 .53298 L
.34986 .52517 L
.35138 .51701 L
.3529 .50851 L
.35441 .4997 L
.35593 .49058 L
.35745 .48117 L
.35896 .47149 L
.36048 .46155 L
.362 .45136 L
.36351 .44094 L
.36503 .43032 L
.36655 .4195 L
.36806 .4085 L
.36958 .39734 L
.37109 .38605 L
.37261 .37462 L
.37413 .3631 L
.37564 .35149 L
.37716 .33981 L
.37868 .32808 L
.38019 .31632 L
.38171 .30455 L
.38323 .29278 L
.38474 .28104 L
.38626 .26935 L
.38778 .25772 L
.38929 .24617 L
.39081 .23472 L
.39233 .2234 L
.39384 .2122 L
.39536 .20117 L
.39688 .1903 L
.39839 .17963 L
.39991 .16916 L
.40143 .15892 L
Mistroke
.40294 .14891 L
.40446 .13917 L
.40598 .12969 L
.40749 .1205 L
.40901 .11162 L
.41052 .10304 L
.41204 .0948 L
.41356 .0869 L
.41507 .07936 L
.41659 .07218 L
.41811 .06539 L
.41962 .05898 L
.42114 .05297 L
.42266 .04737 L
.42417 .0422 L
.42569 .03744 L
.42721 .03312 L
.42872 .02925 L
.43024 .02582 L
.43176 .02284 L
.43327 .02033 L
.43479 .01827 L
.43631 .01668 L
.43782 .01555 L
.43934 .0149 L
.44086 .01472 L
.44237 .01501 L
.44389 .01576 L
.4454 .01699 L
.44692 .01868 L
.44844 .02084 L
.44995 .02346 L
.45147 .02654 L
.45299 .03007 L
.4545 .03404 L
.45602 .03846 L
.45754 .0433 L
.45905 .04858 L
.46057 .05427 L
.46209 .06036 L
.4636 .06686 L
.46512 .07374 L
.46664 .081 L
.46815 .08862 L
.46967 .0966 L
.47119 .10491 L
.4727 .11356 L
.47422 .12251 L
.47574 .13176 L
.47725 .1413 L
Mistroke
.47877 .15111 L
.48029 .16116 L
.4818 .17146 L
.48332 .18197 L
.48483 .19269 L
.48635 .20359 L
.48787 .21467 L
.48938 .22589 L
.4909 .23725 L
.49242 .24872 L
.49393 .26029 L
.49545 .27193 L
.49697 .28364 L
.49848 .29538 L
.5 .30715 L
.50152 .31892 L
.50303 .33068 L
.50455 .3424 L
.50607 .35406 L
.50758 .36566 L
.5091 .37716 L
.51062 .38856 L
.51213 .39982 L
.51365 .41095 L
.51517 .42191 L
.51668 .43269 L
.5182 .44327 L
.51971 .45363 L
.52123 .46377 L
.52275 .47365 L
.52426 .48328 L
.52578 .49262 L
.5273 .50168 L
.52881 .51042 L
.53033 .51884 L
.53185 .52693 L
.53336 .53466 L
.53488 .54204 L
.5364 .54904 L
.53791 .55566 L
.53943 .56189 L
.54095 .56771 L
.54246 .57311 L
.54398 .5781 L
.5455 .58265 L
.54701 .58677 L
.54853 .59044 L
.55005 .59366 L
.55156 .59642 L
.55308 .59873 L
Mistroke
.5546 .60057 L
.55611 .60195 L
.55763 .60286 L
.55914 .60329 L
.56066 .60326 L
.56218 .60276 L
.56369 .60178 L
.56521 .60034 L
.56673 .59843 L
.56824 .59606 L
.56976 .59323 L
.57128 .58994 L
.57279 .58621 L
.57431 .58203 L
.57583 .57742 L
.57734 .57237 L
.57886 .56691 L
.58038 .56103 L
.58189 .55475 L
.58341 .54807 L
.58493 .54102 L
.58644 .53359 L
.58796 .5258 L
.58948 .51767 L
.59099 .5092 L
.59251 .50041 L
.59402 .49132 L
.59554 .48193 L
.59706 .47227 L
.59857 .46235 L
.60009 .45218 L
.60161 .44178 L
.60312 .43117 L
.60464 .42036 L
.60616 .40938 L
.60767 .39824 L
.60919 .38695 L
.61071 .37554 L
.61222 .36402 L
.61374 .35241 L
.61526 .34074 L
.61677 .32901 L
.61829 .31725 L
.61981 .30548 L
.62132 .29372 L
.62284 .28198 L
.62436 .27028 L
.62587 .25864 L
.62739 .24709 L
.62891 .23563 L
Mistroke
.63042 .22429 L
.63194 .21309 L
.63345 .20204 L
.63497 .19116 L
.63649 .18047 L
.638 .16999 L
.63952 .15972 L
.64104 .1497 L
.64255 .13993 L
.64407 .13044 L
.64559 .12122 L
.6471 .11231 L
.64862 .10372 L
.65014 .09545 L
.65165 .08752 L
.65317 .07995 L
.65469 .07274 L
.6562 .06591 L
.65772 .05948 L
.65924 .05344 L
.66075 .04781 L
.66227 .04259 L
.66379 .03781 L
.6653 .03345 L
.66682 .02954 L
.66833 .02608 L
.66985 .02306 L
.67137 .02051 L
.67288 .01842 L
.6744 .01679 L
.67592 .01563 L
.67743 .01494 L
.67895 .01472 L
.68047 .01497 L
.68198 .01569 L
.6835 .01688 L
.68502 .01853 L
.68653 .02065 L
.68805 .02324 L
.68957 .02628 L
.69108 .02977 L
.6926 .03371 L
.69412 .03809 L
.69563 .0429 L
.69715 .04814 L
.69867 .0538 L
.70018 .05986 L
.7017 .06633 L
.70322 .07318 L
.70473 .08041 L
Mistroke
.70625 .088 L
.70776 .09595 L
.70928 .10424 L
.7108 .11286 L
.71231 .12179 L
.71383 .13102 L
.71535 .14053 L
.71686 .15032 L
.71838 .16035 L
.7199 .17063 L
.72141 .18113 L
.72293 .19183 L
.72445 .20272 L
.72596 .21378 L
.72748 .22499 L
.729 .23634 L
.73051 .2478 L
.73203 .25936 L
.73355 .271 L
.73506 .2827 L
.73658 .29445 L
.7381 .30621 L
.73961 .31798 L
.74113 .32974 L
.74264 .34146 L
.74416 .35314 L
.74568 .36474 L
.74719 .37625 L
.74871 .38765 L
.75023 .39893 L
.75174 .41007 L
.75326 .42104 L
.75478 .43183 L
.75629 .44243 L
.75781 .45282 L
.75933 .46297 L
.76084 .47288 L
.76236 .48252 L
.76388 .49189 L
.76539 .50097 L
.76691 .50973 L
.76843 .51818 L
.76994 .52629 L
.77146 .53406 L
.77298 .54146 L
.77449 .5485 L
.77601 .55515 L
.77753 .5614 L
.77904 .56726 L
.78056 .5727 L
Mistroke
.78207 .57771 L
.78359 .5823 L
.78511 .58645 L
.78662 .59016 L
.78814 .59342 L
.78966 .59622 L
.79117 .59856 L
.79269 .60044 L
.79421 .60186 L
.79572 .6028 L
.79724 .60328 L
.79876 .60328 L
.80027 .60281 L
.80179 .60188 L
.80331 .60047 L
.80482 .5986 L
.80634 .59627 L
.80786 .59347 L
.80937 .59022 L
.81089 .58652 L
.81241 .58238 L
.81392 .5778 L
.81544 .57279 L
.81695 .56736 L
.81847 .56151 L
.81999 .55526 L
.8215 .54862 L
.82302 .54159 L
.82454 .53419 L
.82605 .52643 L
.82757 .51833 L
.82909 .50989 L
.8306 .50112 L
.83212 .49205 L
.83364 .48269 L
.83515 .47305 L
.83667 .46315 L
.83819 .453 L
.8397 .44262 L
.84122 .43202 L
.84274 .42123 L
.84425 .41026 L
.84577 .39913 L
.84729 .38785 L
.8488 .37645 L
.85032 .36494 L
.85184 .35334 L
.85335 .34167 L
.85487 .32995 L
.85638 .31819 L
Mistroke
.8579 .30642 L
.85942 .29465 L
.86093 .28291 L
.86245 .27121 L
.86397 .25957 L
.86548 .248 L
.867 .23654 L
.86852 .22519 L
.87003 .21398 L
.87155 .20291 L
.87307 .19202 L
.87458 .18131 L
.8761 .17081 L
.87762 .16053 L
.87913 .15049 L
.88065 .1407 L
.88217 .13118 L
.88368 .12195 L
.8852 .11301 L
.88672 .10439 L
.88823 .09609 L
.88975 .08814 L
.89126 .08054 L
.89278 .0733 L
.8943 .06644 L
.89581 .05997 L
.89733 .0539 L
.89885 .04824 L
.90036 .04299 L
.90188 .03817 L
.9034 .03378 L
.90491 .02984 L
.90643 .02634 L
.90795 .02329 L
.90946 .0207 L
.91098 .01857 L
.9125 .0169 L
.91401 .0157 L
.91553 .01497 L
.91705 .01472 L
.91856 .01493 L
.92008 .01561 L
.9216 .01676 L
.92311 .01838 L
.92463 .02047 L
.92614 .02301 L
.92766 .02602 L
.92918 .02948 L
.93069 .03338 L
.93221 .03773 L
Mistroke
.93373 .0425 L
.93524 .04771 L
.93676 .05333 L
.93828 .05937 L
.93979 .0658 L
.94131 .07262 L
.94283 .07982 L
.94434 .08738 L
.94586 .0953 L
.94738 .10357 L
.94889 .11216 L
.95041 .12106 L
.95193 .13027 L
.95344 .13976 L
.95496 .14953 L
.95648 .15955 L
.95799 .1698 L
.95951 .18028 L
.96103 .19097 L
.96254 .20185 L
.96406 .21289 L
.96557 .22409 L
.96709 .23543 L
.96861 .24688 L
.97012 .25844 L
.97164 .27007 L
.97316 .28177 L
.97467 .29351 L
.97619 .30528 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00965678 0.64881 0.193595 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151653 0.309016 0.294304 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02533 .32373 L
.02684 .3384 L
.02836 .353 L
.02988 .36749 L
.03139 .38183 L
.03291 .39599 L
.03443 .40993 L
.03594 .42362 L
.03746 .43703 L
.03897 .45011 L
.04049 .46285 L
.04201 .47519 L
.04352 .48713 L
.04504 .49861 L
.04656 .50963 L
.04807 .52014 L
.04959 .53012 L
.05111 .53955 L
.05262 .54841 L
.05414 .55666 L
.05566 .5643 L
.05717 .5713 L
.05869 .57765 L
.06021 .58332 L
.06172 .58831 L
.06324 .5926 L
.06476 .59618 L
.06627 .59904 L
.06779 .60118 L
.06931 .60258 L
.07082 .60326 L
.07234 .6032 L
.07386 .6024 L
.07537 .60087 L
.07689 .59861 L
.0784 .59562 L
.07992 .59192 L
.08144 .58752 L
.08295 .58241 L
.08447 .57663 L
.08599 .57017 L
.0875 .56306 L
.08902 .55532 L
.09054 .54696 L
.09205 .53801 L
.09357 .52848 L
.09509 .51841 L
.0966 .50781 L
.09812 .49671 L
Mistroke
.09964 .48515 L
.10115 .47315 L
.10267 .46073 L
.10419 .44794 L
.1057 .4348 L
.10722 .42134 L
.10874 .4076 L
.11025 .39362 L
.11177 .37943 L
.11328 .36506 L
.1148 .35055 L
.11632 .33593 L
.11783 .32125 L
.11935 .30654 L
.12087 .29184 L
.12238 .27717 L
.1239 .26259 L
.12542 .24812 L
.12693 .23381 L
.12845 .21968 L
.12997 .20578 L
.13148 .19213 L
.133 .17878 L
.13452 .16575 L
.13603 .15308 L
.13755 .1408 L
.13907 .12894 L
.14058 .11753 L
.1421 .1066 L
.14362 .09618 L
.14513 .08629 L
.14665 .07695 L
.14816 .06819 L
.14968 .06004 L
.1512 .05251 L
.15271 .04562 L
.15423 .03938 L
.15575 .03383 L
.15726 .02896 L
.15878 .02479 L
.1603 .02133 L
.16181 .01858 L
.16333 .01657 L
.16485 .01528 L
.16636 .01473 L
.16788 .01492 L
.1694 .01584 L
.17091 .01749 L
.17243 .01988 L
.17395 .02298 L
Mistroke
.17546 .0268 L
.17698 .03133 L
.1785 .03655 L
.18001 .04245 L
.18153 .04901 L
.18305 .05623 L
.18456 .06408 L
.18608 .07254 L
.18759 .08159 L
.18911 .09121 L
.19063 .10137 L
.19214 .11206 L
.19366 .12323 L
.19518 .13487 L
.19669 .14695 L
.19821 .15943 L
.19973 .17228 L
.20124 .18548 L
.20276 .19898 L
.20428 .21276 L
.20579 .22678 L
.20731 .24101 L
.20883 .25541 L
.21034 .26994 L
.21186 .28456 L
.21338 .29925 L
.21489 .31396 L
.21641 .32867 L
.21793 .34332 L
.21944 .35788 L
.22096 .37233 L
.22247 .38661 L
.22399 .4007 L
.22551 .41457 L
.22702 .42817 L
.22854 .44147 L
.23006 .45444 L
.23157 .46704 L
.23309 .47925 L
.23461 .49104 L
.23612 .50237 L
.23764 .51322 L
.23916 .52356 L
.24067 .53336 L
.24219 .5426 L
.24371 .55125 L
.24522 .5593 L
.24674 .56673 L
.24826 .57351 L
.24977 .57963 L
Mistroke
.25129 .58507 L
.25281 .58983 L
.25432 .59388 L
.25584 .59722 L
.25736 .59984 L
.25887 .60173 L
.26039 .60289 L
.2619 .60332 L
.26342 .60301 L
.26494 .60197 L
.26645 .60019 L
.26797 .59768 L
.26949 .59446 L
.271 .59052 L
.27252 .58588 L
.27404 .58054 L
.27555 .57453 L
.27707 .56785 L
.27859 .56053 L
.2801 .55258 L
.28162 .54401 L
.28314 .53487 L
.28465 .52515 L
.28617 .5149 L
.28769 .50413 L
.2892 .49288 L
.29072 .48116 L
.29224 .46901 L
.29375 .45647 L
.29527 .44356 L
.29678 .4303 L
.2983 .41675 L
.29982 .40293 L
.30133 .38887 L
.30285 .37461 L
.30437 .36019 L
.30588 .34564 L
.3074 .331 L
.30892 .31631 L
.31043 .30159 L
.31195 .2869 L
.31347 .27226 L
.31498 .25771 L
.3165 .24329 L
.31802 .22904 L
.31953 .21498 L
.32105 .20116 L
.32257 .18761 L
.32408 .17436 L
.3256 .16145 L
Mistroke
.32712 .14891 L
.32863 .13677 L
.33015 .12506 L
.33167 .1138 L
.33318 .10304 L
.3347 .09279 L
.33621 .08308 L
.33773 .07394 L
.33925 .06538 L
.34076 .05744 L
.34228 .05012 L
.3438 .04345 L
.34531 .03744 L
.34683 .03211 L
.34835 .02747 L
.34986 .02354 L
.35138 .02032 L
.3529 .01783 L
.35441 .01606 L
.35593 .01502 L
.35745 .01472 L
.35896 .01515 L
.36048 .01632 L
.362 .01821 L
.36351 .02084 L
.36503 .02419 L
.36655 .02824 L
.36806 .033 L
.36958 .03845 L
.37109 .04458 L
.37261 .05137 L
.37413 .0588 L
.37564 .06685 L
.37716 .07552 L
.37868 .08476 L
.38019 .09457 L
.38171 .10491 L
.38323 .11576 L
.38474 .1271 L
.38626 .13889 L
.38778 .1511 L
.38929 .16371 L
.39081 .17668 L
.39233 .18999 L
.39384 .20359 L
.39536 .21745 L
.39688 .23155 L
.39839 .24583 L
.39991 .26028 L
.40143 .27485 L
Mistroke
.40294 .2895 L
.40446 .3042 L
.40598 .31891 L
.40749 .3336 L
.40901 .34823 L
.41052 .36276 L
.41204 .37715 L
.41356 .39138 L
.41507 .40539 L
.41659 .41917 L
.41811 .43267 L
.41962 .44587 L
.42114 .45872 L
.42266 .47119 L
.42417 .48327 L
.42569 .4949 L
.42721 .50607 L
.42872 .51675 L
.43024 .52691 L
.43176 .53653 L
.43327 .54557 L
.43479 .55403 L
.43631 .56187 L
.43782 .56908 L
.43934 .57564 L
.44086 .58154 L
.44237 .58675 L
.44389 .59127 L
.4454 .59508 L
.44692 .59818 L
.44844 .60056 L
.44995 .6022 L
.45147 .60312 L
.45299 .6033 L
.4545 .60274 L
.45602 .60145 L
.45754 .59943 L
.45905 .59668 L
.46057 .59321 L
.46209 .58904 L
.4636 .58416 L
.46512 .5786 L
.46664 .57236 L
.46815 .56546 L
.46967 .55792 L
.47119 .54976 L
.4727 .541 L
.47422 .53166 L
.47574 .52176 L
.47725 .51133 L
Mistroke
.47877 .5004 L
.48029 .48899 L
.4818 .47712 L
.48332 .46484 L
.48483 .45217 L
.48635 .43913 L
.48787 .42578 L
.48938 .41213 L
.4909 .39823 L
.49242 .3841 L
.49393 .36978 L
.49545 .35531 L
.49697 .34073 L
.49848 .32607 L
.5 .31136 L
.50152 .29665 L
.50303 .28197 L
.50455 .26735 L
.50607 .25285 L
.50758 .23848 L
.5091 .22429 L
.51062 .2103 L
.51213 .19657 L
.51365 .18312 L
.51517 .16998 L
.51668 .15719 L
.5182 .14478 L
.51971 .13278 L
.52123 .12122 L
.52275 .11013 L
.52426 .09954 L
.52578 .08947 L
.5273 .07994 L
.52881 .071 L
.53033 .06264 L
.53185 .0549 L
.53336 .0478 L
.53488 .04135 L
.5364 .03557 L
.53791 .03047 L
.53943 .02607 L
.54095 .02238 L
.54246 .0194 L
.54398 .01715 L
.5455 .01562 L
.54701 .01483 L
.54853 .01478 L
.55005 .01546 L
.55156 .01687 L
.55308 .01902 L
Mistroke
.5546 .02189 L
.55611 .02547 L
.55763 .02977 L
.55914 .03476 L
.56066 .04044 L
.56218 .04679 L
.56369 .0538 L
.56521 .06144 L
.56673 .0697 L
.56824 .07856 L
.56976 .088 L
.57128 .09799 L
.57279 .1085 L
.57431 .11952 L
.57583 .13101 L
.57734 .14295 L
.57886 .1553 L
.58038 .16803 L
.58189 .18112 L
.58341 .19453 L
.58493 .20822 L
.58644 .22217 L
.58796 .23633 L
.58948 .25068 L
.59099 .26517 L
.59251 .27977 L
.59402 .29444 L
.59554 .30915 L
.59706 .32386 L
.59857 .33853 L
.60009 .35313 L
.60161 .36761 L
.60312 .38196 L
.60464 .39611 L
.60616 .41006 L
.60767 .42374 L
.60919 .43715 L
.61071 .45023 L
.61222 .46296 L
.61374 .4753 L
.61526 .48723 L
.61677 .49871 L
.61829 .50972 L
.61981 .52023 L
.62132 .53021 L
.62284 .53963 L
.62436 .54848 L
.62587 .55674 L
.62739 .56437 L
.62891 .57136 L
Mistroke
.63042 .5777 L
.63194 .58337 L
.63345 .58835 L
.63497 .59263 L
.63649 .5962 L
.638 .59906 L
.63952 .60119 L
.64104 .60259 L
.64255 .60326 L
.64407 .60319 L
.64559 .60239 L
.6471 .60085 L
.64862 .59858 L
.65014 .59559 L
.65165 .59189 L
.65317 .58747 L
.65469 .58236 L
.6562 .57657 L
.65772 .57011 L
.65924 .563 L
.66075 .55525 L
.66227 .54688 L
.66379 .53792 L
.6653 .52839 L
.66682 .51831 L
.66833 .50771 L
.66985 .49661 L
.67137 .48504 L
.67288 .47304 L
.6744 .46062 L
.67592 .44782 L
.67743 .43468 L
.67895 .42122 L
.68047 .40748 L
.68198 .3935 L
.6835 .3793 L
.68502 .36493 L
.68653 .35042 L
.68805 .3358 L
.68957 .32112 L
.69108 .30641 L
.6926 .29171 L
.69412 .27704 L
.69563 .26246 L
.69715 .248 L
.69867 .23368 L
.70018 .21956 L
.7017 .20566 L
.70322 .19201 L
.70473 .17866 L
Mistroke
.70625 .16564 L
.70776 .15297 L
.70928 .1407 L
.7108 .12884 L
.71231 .11744 L
.71383 .10651 L
.71535 .09609 L
.71686 .0862 L
.71838 .07687 L
.7199 .06812 L
.72141 .05997 L
.72293 .05244 L
.72445 .04556 L
.72596 .03933 L
.72748 .03378 L
.729 .02892 L
.73051 .02475 L
.73203 .0213 L
.73355 .01856 L
.73506 .01655 L
.73658 .01528 L
.7381 .01473 L
.73961 .01493 L
.74113 .01585 L
.74264 .01751 L
.74416 .0199 L
.74568 .02301 L
.74719 .02684 L
.74871 .03137 L
.75023 .03659 L
.75174 .0425 L
.75326 .04907 L
.75478 .0563 L
.75629 .06415 L
.75781 .07261 L
.75933 .08167 L
.76084 .0913 L
.76236 .10147 L
.76388 .11215 L
.76539 .12333 L
.76691 .13498 L
.76843 .14706 L
.76994 .15954 L
.77146 .1724 L
.77298 .1856 L
.77449 .1991 L
.77601 .21289 L
.77753 .22691 L
.77904 .24114 L
.78056 .25553 L
Mistroke
.78207 .27006 L
.78359 .28469 L
.78511 .29938 L
.78662 .3141 L
.78814 .3288 L
.78966 .34345 L
.79117 .35801 L
.79269 .37245 L
.79421 .38674 L
.79572 .40083 L
.79724 .41469 L
.79876 .42829 L
.80027 .44158 L
.80179 .45455 L
.80331 .46715 L
.80482 .47936 L
.80634 .49114 L
.80786 .50247 L
.80937 .51331 L
.81089 .52364 L
.81241 .53344 L
.81392 .54268 L
.81544 .55133 L
.81695 .55937 L
.81847 .56679 L
.81999 .57357 L
.8215 .57968 L
.82302 .58512 L
.82454 .58987 L
.82605 .59391 L
.82757 .59725 L
.82909 .59986 L
.8306 .60174 L
.83212 .6029 L
.83364 .60332 L
.83515 .603 L
.83667 .60195 L
.83819 .60017 L
.8397 .59766 L
.84122 .59443 L
.84274 .59048 L
.84425 .58583 L
.84577 .58049 L
.84729 .57447 L
.8488 .56779 L
.85032 .56046 L
.85184 .5525 L
.85335 .54394 L
.85487 .53478 L
.85638 .52506 L
Mistroke
.8579 .51481 L
.85942 .50403 L
.86093 .49277 L
.86245 .48105 L
.86397 .4689 L
.86548 .45636 L
.867 .44344 L
.86852 .43019 L
.87003 .41663 L
.87155 .4028 L
.87307 .38875 L
.87458 .37449 L
.8761 .36006 L
.87762 .34551 L
.87913 .33087 L
.88065 .31618 L
.88217 .30146 L
.88368 .28677 L
.8852 .27213 L
.88672 .25758 L
.88823 .24316 L
.88975 .22891 L
.89126 .21486 L
.89278 .20104 L
.8943 .18749 L
.89581 .17425 L
.89733 .16134 L
.89885 .1488 L
.90036 .13666 L
.90188 .12495 L
.9034 .11371 L
.90491 .10295 L
.90643 .0927 L
.90795 .083 L
.90946 .07386 L
.91098 .06531 L
.9125 .05737 L
.91401 .05006 L
.91553 .04339 L
.91705 .03739 L
.91856 .03207 L
.92008 .02744 L
.9216 .02351 L
.92311 .0203 L
.92463 .01781 L
.92614 .01604 L
.92766 .01501 L
.92918 .01472 L
.93069 .01516 L
.93221 .01633 L
Mistroke
.93373 .01823 L
.93524 .02087 L
.93676 .02422 L
.93828 .02828 L
.93979 .03305 L
.94131 .03851 L
.94283 .04464 L
.94434 .05143 L
.94586 .05887 L
.94738 .06693 L
.94889 .0756 L
.95041 .08485 L
.95193 .09466 L
.95344 .105 L
.95496 .11586 L
.95648 .1272 L
.95799 .13899 L
.95951 .15121 L
.96103 .16382 L
.96254 .1768 L
.96406 .19011 L
.96557 .20371 L
.96709 .21758 L
.96861 .23167 L
.97012 .24596 L
.97164 .26041 L
.97316 .27498 L
.97467 .28963 L
.97619 .30433 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00965678 0.97619 0.193595 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151653 0.309018 0.294303 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02533 .32667 L
.02684 .34425 L
.02836 .36171 L
.02988 .37897 L
.03139 .39599 L
.03291 .41269 L
.03443 .42902 L
.03594 .44492 L
.03746 .46033 L
.03897 .47519 L
.04049 .48946 L
.04201 .50308 L
.04352 .51599 L
.04504 .52817 L
.04656 .53955 L
.04807 .55011 L
.04959 .5598 L
.05111 .56858 L
.05262 .57643 L
.05414 .58332 L
.05566 .58922 L
.05717 .59411 L
.05869 .59798 L
.06021 .60081 L
.06172 .60258 L
.06324 .6033 L
.06476 .60296 L
.06627 .60157 L
.06779 .59912 L
.06931 .59562 L
.07082 .5911 L
.07234 .58556 L
.07386 .57902 L
.07537 .57152 L
.07689 .56306 L
.0784 .5537 L
.07992 .54345 L
.08144 .53236 L
.08295 .52046 L
.08447 .50781 L
.08599 .49444 L
.0875 .4804 L
.08902 .46574 L
.09054 .45053 L
.09205 .4348 L
.09357 .41862 L
.09509 .40204 L
.0966 .38513 L
.09812 .36795 L
Mistroke
.09964 .35055 L
.10115 .333 L
.10267 .31537 L
.10419 .29772 L
.1057 .2801 L
.10722 .26259 L
.10874 .24525 L
.11025 .22814 L
.11177 .21131 L
.11328 .19484 L
.1148 .17878 L
.11632 .16319 L
.11783 .14813 L
.11935 .13364 L
.12087 .11978 L
.12238 .10661 L
.1239 .09416 L
.12542 .08249 L
.12693 .07163 L
.12845 .06162 L
.12997 .05251 L
.13148 .04432 L
.133 .03708 L
.13452 .03082 L
.13603 .02557 L
.13755 .02133 L
.13907 .01813 L
.14058 .01597 L
.1421 .01487 L
.14362 .01483 L
.14513 .01584 L
.14665 .01792 L
.14816 .02103 L
.14968 .02519 L
.1512 .03037 L
.15271 .03655 L
.15423 .04371 L
.15575 .05182 L
.15726 .06087 L
.15878 .0708 L
.1603 .08159 L
.16181 .0932 L
.16333 .10559 L
.16485 .11871 L
.16636 .13251 L
.16788 .14695 L
.1694 .16197 L
.17091 .17752 L
.17243 .19355 L
.17395 .20999 L
Mistroke
.17546 .22679 L
.17698 .24388 L
.1785 .2612 L
.18001 .2787 L
.18153 .29631 L
.18305 .31397 L
.18456 .3316 L
.18608 .34916 L
.18759 .36657 L
.18911 .38377 L
.19063 .40071 L
.19214 .41731 L
.19366 .43352 L
.19518 .44929 L
.19669 .46455 L
.19821 .47925 L
.19973 .49334 L
.20124 .50677 L
.20276 .51948 L
.20428 .53144 L
.20579 .5426 L
.20731 .55291 L
.20883 .56235 L
.21034 .57088 L
.21186 .57846 L
.21338 .58507 L
.21489 .59069 L
.21641 .5953 L
.21793 .59888 L
.21944 .60141 L
.22096 .60289 L
.22247 .60332 L
.22399 .60268 L
.22551 .60099 L
.22702 .59824 L
.22854 .59446 L
.23006 .58965 L
.23157 .58383 L
.23309 .57702 L
.23461 .56924 L
.23612 .56053 L
.23764 .55091 L
.23916 .54042 L
.24067 .5291 L
.24219 .51699 L
.24371 .50413 L
.24522 .49057 L
.24674 .47635 L
.24826 .46153 L
.24977 .44617 L
Mistroke
.25129 .43031 L
.25281 .41401 L
.25432 .39733 L
.25584 .38034 L
.25736 .36309 L
.25887 .34565 L
.26039 .32807 L
.2619 .31042 L
.26342 .29277 L
.26494 .27518 L
.26645 .25771 L
.26797 .24043 L
.26949 .22339 L
.271 .20666 L
.27252 .1903 L
.27404 .17436 L
.27555 .15891 L
.27707 .144 L
.27859 .12969 L
.2801 .11602 L
.28162 .10304 L
.28314 .09081 L
.28465 .07936 L
.28617 .06874 L
.28769 .05898 L
.2892 .05012 L
.29072 .04219 L
.29224 .03523 L
.29375 .02925 L
.29527 .02427 L
.29678 .02033 L
.2983 .01742 L
.29982 .01555 L
.30133 .01475 L
.30285 .01501 L
.30437 .01632 L
.30588 .01868 L
.3074 .0221 L
.30892 .02654 L
.31043 .032 L
.31195 .03846 L
.31347 .04589 L
.31498 .05427 L
.3165 .06356 L
.31802 .07374 L
.31953 .08476 L
.32105 .0966 L
.32257 .10919 L
.32408 .12251 L
.3256 .13649 L
Mistroke
.32712 .1511 L
.32863 .16628 L
.33015 .18197 L
.33167 .19812 L
.33318 .21466 L
.3347 .23155 L
.33621 .24871 L
.33773 .26609 L
.33925 .28363 L
.34076 .30126 L
.34228 .31891 L
.3438 .33653 L
.34531 .35405 L
.34683 .37141 L
.34835 .38855 L
.34986 .40539 L
.35138 .4219 L
.3529 .43799 L
.35441 .45362 L
.35593 .46873 L
.35745 .48327 L
.35896 .49718 L
.36048 .51041 L
.362 .52291 L
.36351 .53465 L
.36503 .54557 L
.36655 .55565 L
.36806 .56483 L
.36958 .5731 L
.37109 .58041 L
.37261 .58675 L
.37413 .59209 L
.37564 .59641 L
.37716 .59969 L
.37868 .60193 L
.38019 .60312 L
.38171 .60324 L
.38323 .60231 L
.38474 .60032 L
.38626 .59729 L
.38778 .59321 L
.38929 .58812 L
.39081 .58202 L
.39233 .57493 L
.39384 .56689 L
.39536 .55792 L
.39688 .54806 L
.39839 .53733 L
.39991 .52579 L
.40143 .51346 L
Mistroke
.40294 .5004 L
.40446 .48665 L
.40598 .47226 L
.40749 .45728 L
.40901 .44177 L
.41052 .42578 L
.41204 .40937 L
.41356 .3926 L
.41507 .37553 L
.41659 .35822 L
.41811 .34073 L
.41962 .32313 L
.42114 .30548 L
.42266 .28784 L
.42417 .27027 L
.42569 .25285 L
.42721 .23563 L
.42872 .21867 L
.43024 .20203 L
.43176 .18579 L
.43327 .16998 L
.43479 .15468 L
.43631 .13993 L
.43782 .12579 L
.43934 .11231 L
.44086 .09954 L
.44237 .08752 L
.44389 .0763 L
.4454 .06591 L
.44692 .0564 L
.44844 .0478 L
.44995 .04014 L
.45147 .03345 L
.45299 .02775 L
.4545 .02306 L
.45602 .0194 L
.45754 .01679 L
.45905 .01522 L
.46057 .01472 L
.46209 .01527 L
.4636 .01688 L
.46512 .01954 L
.46664 .02324 L
.46815 .02797 L
.46967 .03371 L
.47119 .04044 L
.4727 .04814 L
.47422 .05678 L
.47574 .06633 L
.47725 .07674 L
Mistroke
.47877 .088 L
.48029 .10005 L
.4818 .11285 L
.48332 .12636 L
.48483 .14053 L
.48635 .1553 L
.48787 .17063 L
.48938 .18645 L
.4909 .20272 L
.49242 .21936 L
.49393 .23633 L
.49545 .25356 L
.49697 .271 L
.49848 .28856 L
.5 .30621 L
.50152 .32386 L
.50303 .34146 L
.50455 .35894 L
.50607 .37624 L
.50758 .3933 L
.5091 .41006 L
.51062 .42645 L
.51213 .44242 L
.51365 .45791 L
.51517 .47287 L
.51668 .48723 L
.5182 .50095 L
.51971 .51399 L
.52123 .52628 L
.52275 .53779 L
.52426 .54848 L
.52578 .55831 L
.5273 .56724 L
.52881 .57524 L
.53033 .58229 L
.53185 .58835 L
.53336 .5934 L
.53488 .59743 L
.5364 .60043 L
.53791 .60237 L
.53943 .60326 L
.54095 .60309 L
.54246 .60186 L
.54398 .59958 L
.5455 .59625 L
.54701 .59189 L
.54853 .58651 L
.55005 .58013 L
.55156 .57277 L
.55308 .56447 L
Mistroke
.5546 .55525 L
.55611 .54514 L
.55763 .53418 L
.55914 .52241 L
.56066 .50987 L
.56218 .49661 L
.56369 .48268 L
.56521 .46812 L
.56673 .45298 L
.56824 .43733 L
.56976 .42122 L
.57128 .4047 L
.57279 .38784 L
.57431 .3707 L
.57583 .35333 L
.57734 .33581 L
.57886 .31818 L
.58038 .30053 L
.58189 .2829 L
.58341 .26537 L
.58493 .248 L
.58644 .23084 L
.58796 .21397 L
.58948 .19744 L
.59099 .18131 L
.59251 .16564 L
.59402 .15049 L
.59554 .1359 L
.59706 .12194 L
.59857 .10866 L
.60009 .09609 L
.60161 .08429 L
.60312 .0733 L
.60464 .06316 L
.60616 .0539 L
.60767 .04556 L
.60919 .03817 L
.61071 .03175 L
.61222 .02634 L
.61374 .02193 L
.61526 .01857 L
.61677 .01624 L
.61829 .01497 L
.61981 .01476 L
.62132 .01561 L
.62284 .01752 L
.62436 .02047 L
.62587 .02446 L
.62739 .02948 L
.62891 .0355 L
Mistroke
.63042 .0425 L
.63194 .05047 L
.63345 .05936 L
.63497 .06916 L
.63649 .07982 L
.638 .0913 L
.63952 .10356 L
.64104 .11657 L
.64255 .13027 L
.64407 .14461 L
.64559 .15954 L
.6471 .17501 L
.64862 .19097 L
.65014 .20734 L
.65165 .22409 L
.65317 .24114 L
.65469 .25843 L
.6562 .27591 L
.65772 .2935 L
.65924 .31115 L
.66075 .3288 L
.66227 .34637 L
.66379 .36381 L
.6653 .38105 L
.66682 .39803 L
.66833 .41469 L
.66985 .43097 L
.67137 .44681 L
.67288 .46216 L
.6744 .47695 L
.67592 .49114 L
.67743 .50468 L
.67895 .51751 L
.68047 .52959 L
.68198 .54088 L
.6835 .55133 L
.68502 .56091 L
.68653 .56958 L
.68805 .57732 L
.68957 .58409 L
.69108 .58987 L
.6926 .59464 L
.69412 .59838 L
.69563 .60108 L
.69715 .60273 L
.69867 .60332 L
.70018 .60285 L
.7017 .60133 L
.70322 .59875 L
.70473 .59513 L
Mistroke
.70625 .59048 L
.70776 .58482 L
.70928 .57817 L
.7108 .57054 L
.71231 .56198 L
.71383 .5525 L
.71535 .54215 L
.71686 .53096 L
.71838 .51897 L
.7199 .50623 L
.72141 .49277 L
.72293 .47866 L
.72445 .46393 L
.72596 .44865 L
.72748 .43286 L
.729 .41663 L
.73051 .40001 L
.73203 .38306 L
.73355 .36585 L
.73506 .34843 L
.73658 .33087 L
.7381 .31324 L
.73961 .29558 L
.74113 .27798 L
.74264 .26048 L
.74416 .24317 L
.74568 .22608 L
.74719 .2093 L
.74871 .19288 L
.75023 .17687 L
.75174 .16134 L
.75326 .14634 L
.75478 .13193 L
.75629 .11815 L
.75781 .10506 L
.75933 .09271 L
.76084 .08113 L
.76236 .07037 L
.76388 .06047 L
.76539 .05147 L
.76691 .04339 L
.76843 .03627 L
.76994 .03013 L
.77146 .025 L
.77298 .02089 L
.77449 .01781 L
.77601 .01578 L
.77753 .01481 L
.77904 .01489 L
.78056 .01604 L
Mistroke
.78207 .01824 L
.78359 .02148 L
.78511 .02576 L
.78662 .03106 L
.78814 .03736 L
.78966 .04464 L
.79117 .05287 L
.79269 .06202 L
.79421 .07206 L
.79572 .08295 L
.79724 .09466 L
.79876 .10714 L
.80027 .12034 L
.80179 .13422 L
.80331 .14874 L
.80482 .16383 L
.80634 .17944 L
.80786 .19552 L
.80937 .212 L
.81089 .22884 L
.81241 .24596 L
.81392 .26331 L
.81544 .28083 L
.81695 .29845 L
.81847 .3161 L
.81999 .33373 L
.8215 .35127 L
.82302 .36866 L
.82454 .38584 L
.82605 .40273 L
.82757 .41929 L
.82909 .43546 L
.8306 .45117 L
.83212 .46636 L
.83364 .48099 L
.83515 .495 L
.83667 .50835 L
.83819 .52097 L
.8397 .53283 L
.84122 .54389 L
.84274 .5541 L
.84425 .56343 L
.84577 .57184 L
.84729 .57931 L
.8488 .58581 L
.85032 .59131 L
.85184 .59579 L
.85335 .59924 L
.85487 .60165 L
.85638 .603 L
Mistroke
.8579 .60329 L
.85942 .60253 L
.86093 .60071 L
.86245 .59784 L
.86397 .59393 L
.86548 .589 L
.867 .58305 L
.86852 .57613 L
.87003 .56824 L
.87155 .55941 L
.87307 .54969 L
.87458 .5391 L
.8761 .52768 L
.87762 .51548 L
.87913 .50253 L
.88065 .48888 L
.88217 .47459 L
.88368 .4597 L
.8852 .44427 L
.88672 .42836 L
.88823 .41201 L
.88975 .39529 L
.89126 .37826 L
.89278 .36099 L
.8943 .34352 L
.89581 .32594 L
.89733 .30829 L
.89885 .29064 L
.90036 .27306 L
.90188 .25561 L
.9034 .23835 L
.90491 .22135 L
.90643 .20466 L
.90795 .18835 L
.90946 .17247 L
.91098 .15708 L
.9125 .14224 L
.91401 .128 L
.91553 .11441 L
.91705 .10152 L
.91856 .08938 L
.92008 .07803 L
.9216 .06751 L
.92311 .05786 L
.92463 .04911 L
.92614 .0413 L
.92766 .03445 L
.92918 .02859 L
.93069 .02374 L
.93221 .01992 L
Mistroke
.93373 .01713 L
.93524 .0154 L
.93676 .01473 L
.93828 .01511 L
.93979 .01655 L
.94131 .01904 L
.94283 .02258 L
.94434 .02715 L
.94586 .03273 L
.94738 .0393 L
.94889 .04685 L
.95041 .05534 L
.95193 .06475 L
.95344 .07503 L
.95496 .08615 L
.95648 .09808 L
.95799 .11077 L
.95951 .12417 L
.96103 .13823 L
.96254 .15291 L
.96406 .16815 L
.96557 .1839 L
.96709 .2001 L
.96861 .21669 L
.97012 .23361 L
.97164 .25081 L
.97316 .26821 L
.97467 .28576 L
.97619 .30339 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.211989 0.321429 0.395928 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151653 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02533 .31196 L
.02684 .3149 L
.02836 .31784 L
.02988 .32079 L
.03139 .32373 L
.03291 .32666 L
.03443 .3296 L
.03594 .33254 L
.03746 .33547 L
.03897 .3384 L
.04049 .34132 L
.04201 .34425 L
.04352 .34717 L
.04504 .35008 L
.04656 .353 L
.04807 .3559 L
.04959 .35881 L
.05111 .36171 L
.05262 .3646 L
.05414 .36749 L
.05566 .37037 L
.05717 .37324 L
.05869 .37611 L
.06021 .37897 L
.06172 .38183 L
.06324 .38468 L
.06476 .38752 L
.06627 .39035 L
.06779 .39317 L
.06931 .39599 L
.07082 .3988 L
.07234 .40159 L
.07386 .40438 L
.07537 .40716 L
.07689 .40993 L
.0784 .41269 L
.07992 .41544 L
.08144 .41818 L
.08295 .42091 L
.08447 .42362 L
.08599 .42633 L
.0875 .42902 L
.08902 .4317 L
.09054 .43437 L
.09205 .43703 L
.09357 .43967 L
.09509 .4423 L
.0966 .44492 L
.09812 .44752 L
Mistroke
.09964 .45011 L
.10115 .45269 L
.10267 .45525 L
.10419 .4578 L
.1057 .46033 L
.10722 .46284 L
.10874 .46535 L
.11025 .46783 L
.11177 .4703 L
.11328 .47275 L
.1148 .47519 L
.11632 .47761 L
.11783 .48002 L
.11935 .4824 L
.12087 .48477 L
.12238 .48712 L
.1239 .48946 L
.12542 .49177 L
.12693 .49407 L
.12845 .49635 L
.12997 .49861 L
.13148 .50085 L
.133 .50308 L
.13452 .50528 L
.13603 .50746 L
.13755 .50962 L
.13907 .51177 L
.14058 .51389 L
.1421 .51599 L
.14362 .51808 L
.14513 .52014 L
.14665 .52218 L
.14816 .52419 L
.14968 .52619 L
.1512 .52817 L
.15271 .53012 L
.15423 .53205 L
.15575 .53396 L
.15726 .53585 L
.15878 .53771 L
.1603 .53955 L
.16181 .54137 L
.16333 .54316 L
.16485 .54494 L
.16636 .54668 L
.16788 .54841 L
.1694 .55011 L
.17091 .55178 L
.17243 .55343 L
.17395 .55506 L
Mistroke
.17546 .55666 L
.17698 .55824 L
.1785 .55979 L
.18001 .56132 L
.18153 .56282 L
.18305 .5643 L
.18456 .56575 L
.18608 .56718 L
.18759 .56858 L
.18911 .56995 L
.19063 .5713 L
.19214 .57262 L
.19366 .57392 L
.19518 .57519 L
.19669 .57643 L
.19821 .57765 L
.19973 .57883 L
.20124 .58 L
.20276 .58113 L
.20428 .58224 L
.20579 .58332 L
.20731 .58437 L
.20883 .5854 L
.21034 .58639 L
.21186 .58736 L
.21338 .58831 L
.21489 .58922 L
.21641 .59011 L
.21793 .59096 L
.21944 .59179 L
.22096 .59259 L
.22247 .59337 L
.22399 .59411 L
.22551 .59483 L
.22702 .59552 L
.22854 .59617 L
.23006 .5968 L
.23157 .59741 L
.23309 .59798 L
.23461 .59852 L
.23612 .59904 L
.23764 .59952 L
.23916 .59998 L
.24067 .60041 L
.24219 .60081 L
.24371 .60117 L
.24522 .60151 L
.24674 .60183 L
.24826 .60211 L
.24977 .60236 L
Mistroke
.25129 .60258 L
.25281 .60278 L
.25432 .60294 L
.25584 .60307 L
.25736 .60318 L
.25887 .60326 L
.26039 .6033 L
.2619 .60332 L
.26342 .60331 L
.26494 .60326 L
.26645 .60319 L
.26797 .60309 L
.26949 .60296 L
.271 .6028 L
.27252 .60261 L
.27404 .6024 L
.27555 .60215 L
.27707 .60187 L
.27859 .60157 L
.2801 .60123 L
.28162 .60087 L
.28314 .60047 L
.28465 .60005 L
.28617 .5996 L
.28769 .59912 L
.2892 .59861 L
.29072 .59807 L
.29224 .5975 L
.29375 .5969 L
.29527 .59628 L
.29678 .59562 L
.2983 .59494 L
.29982 .59423 L
.30133 .59349 L
.30285 .59272 L
.30437 .59192 L
.30588 .5911 L
.3074 .59024 L
.30892 .58936 L
.31043 .58845 L
.31195 .58751 L
.31347 .58655 L
.31498 .58556 L
.3165 .58454 L
.31802 .58349 L
.31953 .58241 L
.32105 .58131 L
.32257 .58018 L
.32408 .57902 L
.3256 .57784 L
Mistroke
.32712 .57663 L
.32863 .57539 L
.33015 .57412 L
.33167 .57283 L
.33318 .57151 L
.3347 .57017 L
.33621 .5688 L
.33773 .5674 L
.33925 .56598 L
.34076 .56453 L
.34228 .56306 L
.3438 .56156 L
.34531 .56004 L
.34683 .55849 L
.34835 .55692 L
.34986 .55532 L
.35138 .55369 L
.3529 .55205 L
.35441 .55038 L
.35593 .54868 L
.35745 .54696 L
.35896 .54522 L
.36048 .54345 L
.362 .54166 L
.36351 .53984 L
.36503 .53801 L
.36655 .53615 L
.36806 .53426 L
.36958 .53236 L
.37109 .53043 L
.37261 .52848 L
.37413 .52651 L
.37564 .52451 L
.37716 .5225 L
.37868 .52046 L
.38019 .5184 L
.38171 .51633 L
.38323 .51423 L
.38474 .51211 L
.38626 .50997 L
.38778 .50781 L
.38929 .50563 L
.39081 .50343 L
.39233 .50121 L
.39384 .49897 L
.39536 .49671 L
.39688 .49444 L
.39839 .49214 L
.39991 .48983 L
.40143 .4875 L
Mistroke
.40294 .48515 L
.40446 .48278 L
.40598 .4804 L
.40749 .478 L
.40901 .47558 L
.41052 .47314 L
.41204 .47069 L
.41356 .46823 L
.41507 .46574 L
.41659 .46324 L
.41811 .46073 L
.41962 .4582 L
.42114 .45566 L
.42266 .4531 L
.42417 .45052 L
.42569 .44794 L
.42721 .44533 L
.42872 .44272 L
.43024 .44009 L
.43176 .43745 L
.43327 .4348 L
.43479 .43213 L
.43631 .42945 L
.43782 .42676 L
.43934 .42405 L
.44086 .42134 L
.44237 .41861 L
.44389 .41588 L
.4454 .41313 L
.44692 .41037 L
.44844 .4076 L
.44995 .40483 L
.45147 .40204 L
.45299 .39924 L
.4545 .39644 L
.45602 .39362 L
.45754 .3908 L
.45905 .38797 L
.46057 .38513 L
.46209 .38228 L
.4636 .37943 L
.46512 .37657 L
.46664 .3737 L
.46815 .37083 L
.46967 .36794 L
.47119 .36506 L
.4727 .36217 L
.47422 .35927 L
.47574 .35637 L
.47725 .35346 L
Mistroke
.47877 .35055 L
.48029 .34763 L
.4818 .34471 L
.48332 .34179 L
.48483 .33886 L
.48635 .33593 L
.48787 .333 L
.48938 .33007 L
.4909 .32713 L
.49242 .32419 L
.49393 .32125 L
.49545 .31831 L
.49697 .31537 L
.49848 .31243 L
.5 .30949 L
.50152 .30654 L
.50303 .3036 L
.50455 .30066 L
.50607 .29772 L
.50758 .29478 L
.5091 .29184 L
.51062 .2889 L
.51213 .28596 L
.51365 .28303 L
.51517 .2801 L
.51668 .27717 L
.5182 .27425 L
.51971 .27133 L
.52123 .26841 L
.52275 .2655 L
.52426 .26259 L
.52578 .25969 L
.5273 .25679 L
.52881 .2539 L
.53033 .25101 L
.53185 .24812 L
.53336 .24525 L
.53488 .24238 L
.5364 .23952 L
.53791 .23666 L
.53943 .23381 L
.54095 .23097 L
.54246 .22814 L
.54398 .22531 L
.5455 .22249 L
.54701 .21968 L
.54853 .21688 L
.55005 .21409 L
.55156 .21131 L
.55308 .20854 L
Mistroke
.5546 .20578 L
.55611 .20303 L
.55763 .20029 L
.55914 .19756 L
.56066 .19484 L
.56218 .19213 L
.56369 .18944 L
.56521 .18676 L
.56673 .18409 L
.56824 .18143 L
.56976 .17878 L
.57128 .17615 L
.57279 .17353 L
.57431 .17092 L
.57583 .16833 L
.57734 .16575 L
.57886 .16319 L
.58038 .16064 L
.58189 .15811 L
.58341 .15559 L
.58493 .15308 L
.58644 .1506 L
.58796 .14812 L
.58948 .14567 L
.59099 .14323 L
.59251 .1408 L
.59402 .1384 L
.59554 .13601 L
.59706 .13364 L
.59857 .13128 L
.60009 .12895 L
.60161 .12663 L
.60312 .12433 L
.60464 .12204 L
.60616 .11978 L
.60767 .11754 L
.60919 .11531 L
.61071 .1131 L
.61222 .11092 L
.61374 .10875 L
.61526 .10661 L
.61677 .10448 L
.61829 .10237 L
.61981 .10029 L
.62132 .09822 L
.62284 .09618 L
.62436 .09416 L
.62587 .09216 L
.62739 .09018 L
.62891 .08822 L
Mistroke
.63042 .08629 L
.63194 .08438 L
.63345 .08249 L
.63497 .08062 L
.63649 .07877 L
.638 .07695 L
.63952 .07515 L
.64104 .07338 L
.64255 .07163 L
.64407 .0699 L
.64559 .0682 L
.6471 .06652 L
.64862 .06486 L
.65014 .06323 L
.65165 .06162 L
.65317 .06004 L
.65469 .05848 L
.6562 .05695 L
.65772 .05545 L
.65924 .05397 L
.66075 .05251 L
.66227 .05108 L
.66379 .04968 L
.6653 .0483 L
.66682 .04695 L
.66833 .04562 L
.66985 .04432 L
.67137 .04305 L
.67288 .0418 L
.6744 .04058 L
.67592 .03939 L
.67743 .03822 L
.67895 .03708 L
.68047 .03597 L
.68198 .03489 L
.6835 .03383 L
.68502 .0328 L
.68653 .0318 L
.68805 .03082 L
.68957 .02988 L
.69108 .02896 L
.6926 .02807 L
.69412 .02721 L
.69563 .02637 L
.69715 .02556 L
.69867 .02479 L
.70018 .02404 L
.7017 .02332 L
.70322 .02263 L
.70473 .02196 L
Mistroke
.70625 .02133 L
.70776 .02072 L
.70928 .02014 L
.7108 .0196 L
.71231 .01908 L
.71383 .01859 L
.71535 .01812 L
.71686 .01769 L
.71838 .01729 L
.7199 .01692 L
.72141 .01657 L
.72293 .01626 L
.72445 .01597 L
.72596 .01571 L
.72748 .01549 L
.729 .01529 L
.73051 .01512 L
.73203 .01498 L
.73355 .01487 L
.73506 .01479 L
.73658 .01474 L
.7381 .01472 L
.73961 .01472 L
.74113 .01476 L
.74264 .01483 L
.74416 .01492 L
.74568 .01505 L
.74719 .0152 L
.74871 .01539 L
.75023 .0156 L
.75174 .01584 L
.75326 .01612 L
.75478 .01642 L
.75629 .01675 L
.75781 .01711 L
.75933 .0175 L
.76084 .01791 L
.76236 .01836 L
.76388 .01884 L
.76539 .01934 L
.76691 .01988 L
.76843 .02044 L
.76994 .02103 L
.77146 .02166 L
.77298 .0223 L
.77449 .02298 L
.77601 .02369 L
.77753 .02443 L
.77904 .02519 L
.78056 .02598 L
Mistroke
.78207 .0268 L
.78359 .02765 L
.78511 .02853 L
.78662 .02943 L
.78814 .03037 L
.78966 .03133 L
.79117 .03232 L
.79269 .03333 L
.79421 .03438 L
.79572 .03545 L
.79724 .03655 L
.79876 .03767 L
.80027 .03883 L
.80179 .04001 L
.80331 .04121 L
.80482 .04245 L
.80634 .04371 L
.80786 .04499 L
.80937 .04631 L
.81089 .04765 L
.81241 .04901 L
.81392 .05041 L
.81544 .05182 L
.81695 .05327 L
.81847 .05474 L
.81999 .05623 L
.8215 .05775 L
.82302 .05929 L
.82454 .06086 L
.82605 .06246 L
.82757 .06408 L
.82909 .06572 L
.8306 .06739 L
.83212 .06908 L
.83364 .0708 L
.83515 .07254 L
.83667 .0743 L
.83819 .07609 L
.8397 .0779 L
.84122 .07973 L
.84274 .08159 L
.84425 .08347 L
.84577 .08537 L
.84729 .0873 L
.8488 .08924 L
.85032 .09121 L
.85184 .0932 L
.85335 .09521 L
.85487 .09724 L
.85638 .0993 L
Mistroke
.8579 .10137 L
.85942 .10347 L
.86093 .10559 L
.86245 .10772 L
.86397 .10988 L
.86548 .11206 L
.867 .11425 L
.86852 .11647 L
.87003 .11871 L
.87155 .12096 L
.87307 .12323 L
.87458 .12553 L
.8761 .12784 L
.87762 .13016 L
.87913 .13251 L
.88065 .13487 L
.88217 .13725 L
.88368 .13965 L
.8852 .14207 L
.88672 .1445 L
.88823 .14695 L
.88975 .14941 L
.89126 .15189 L
.89278 .15439 L
.8943 .1569 L
.89581 .15943 L
.89733 .16197 L
.89885 .16453 L
.90036 .1671 L
.90188 .16968 L
.9034 .17228 L
.90491 .1749 L
.90643 .17752 L
.90795 .18016 L
.90946 .18281 L
.91098 .18548 L
.9125 .18816 L
.91401 .19085 L
.91553 .19355 L
.91705 .19626 L
.91856 .19898 L
.92008 .20172 L
.9216 .20446 L
.92311 .20722 L
.92463 .20999 L
.92614 .21276 L
.92766 .21555 L
.92918 .21834 L
.93069 .22115 L
.93221 .22396 L
Mistroke
.93373 .22678 L
.93524 .22961 L
.93676 .23245 L
.93828 .2353 L
.93979 .23815 L
.94131 .24101 L
.94283 .24388 L
.94434 .24675 L
.94586 .24963 L
.94738 .25251 L
.94889 .25541 L
.95041 .2583 L
.95193 .2612 L
.95344 .26411 L
.95496 .26702 L
.95648 .26994 L
.95799 .27285 L
.95951 .27578 L
.96103 .2787 L
.96254 .28163 L
.96406 .28456 L
.96557 .2875 L
.96709 .29043 L
.96861 .29337 L
.97012 .29631 L
.97164 .29925 L
.97316 .30219 L
.97467 .30514 L
.97619 .30808 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.211989 0.64881 0.395928 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151653 0.309018 0.294306 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02533 .3149 L
.02684 .32079 L
.02836 .32667 L
.02988 .33254 L
.03139 .3384 L
.03291 .34425 L
.03443 .35009 L
.03594 .35591 L
.03746 .36171 L
.03897 .36749 L
.04049 .37324 L
.04201 .37898 L
.04352 .38468 L
.04504 .39035 L
.04656 .39599 L
.04807 .4016 L
.04959 .40717 L
.05111 .41269 L
.05262 .41818 L
.05414 .42363 L
.05566 .42902 L
.05717 .43437 L
.05869 .43967 L
.06021 .44492 L
.06172 .45012 L
.06324 .45525 L
.06476 .46033 L
.06627 .46535 L
.06779 .4703 L
.06931 .4752 L
.07082 .48002 L
.07234 .48478 L
.07386 .48946 L
.07537 .49408 L
.07689 .49862 L
.0784 .50308 L
.07992 .50747 L
.08144 .51177 L
.08295 .516 L
.08447 .52014 L
.08599 .5242 L
.0875 .52817 L
.08902 .53206 L
.09054 .53585 L
.09205 .53956 L
.09357 .54317 L
.09509 .54669 L
.0966 .55011 L
.09812 .55344 L
Mistroke
.09964 .55667 L
.10115 .5598 L
.10267 .56283 L
.10419 .56576 L
.1057 .56858 L
.10722 .57131 L
.10874 .57392 L
.11025 .57643 L
.11177 .57884 L
.11328 .58114 L
.1148 .58332 L
.11632 .5854 L
.11783 .58737 L
.11935 .58922 L
.12087 .59097 L
.12238 .5926 L
.1239 .59412 L
.12542 .59552 L
.12693 .59681 L
.12845 .59798 L
.12997 .59904 L
.13148 .59998 L
.133 .60081 L
.13452 .60152 L
.13603 .60211 L
.13755 .60259 L
.13907 .60294 L
.14058 .60318 L
.1421 .60331 L
.14362 .60331 L
.14513 .6032 L
.14665 .60297 L
.14816 .60262 L
.14968 .60215 L
.1512 .60157 L
.15271 .60087 L
.15423 .60005 L
.15575 .59912 L
.15726 .59807 L
.15878 .59691 L
.1603 .59563 L
.16181 .59423 L
.16333 .59272 L
.16485 .5911 L
.16636 .58937 L
.16788 .58752 L
.1694 .58556 L
.17091 .58349 L
.17243 .58131 L
.17395 .57903 L
Mistroke
.17546 .57663 L
.17698 .57413 L
.1785 .57152 L
.18001 .5688 L
.18153 .56599 L
.18305 .56307 L
.18456 .56004 L
.18608 .55692 L
.18759 .5537 L
.18911 .55038 L
.19063 .54696 L
.19214 .54345 L
.19366 .53985 L
.19518 .53615 L
.19669 .53236 L
.19821 .52848 L
.19973 .52452 L
.20124 .52047 L
.20276 .51633 L
.20428 .51211 L
.20579 .50781 L
.20731 .50343 L
.20883 .49897 L
.21034 .49444 L
.21186 .48983 L
.21338 .48515 L
.21489 .4804 L
.21641 .47558 L
.21793 .4707 L
.21944 .46575 L
.22096 .46073 L
.22247 .45566 L
.22399 .45053 L
.22551 .44534 L
.22702 .44009 L
.22854 .4348 L
.23006 .42945 L
.23157 .42406 L
.23309 .41862 L
.23461 .41313 L
.23612 .40761 L
.23764 .40204 L
.23916 .39644 L
.24067 .3908 L
.24219 .38513 L
.24371 .37943 L
.24522 .3737 L
.24674 .36795 L
.24826 .36217 L
.24977 .35637 L
Mistroke
.25129 .35055 L
.25281 .34472 L
.25432 .33887 L
.25584 .333 L
.25736 .32713 L
.25887 .32126 L
.26039 .31537 L
.2619 .30949 L
.26342 .3036 L
.26494 .29772 L
.26645 .29184 L
.26797 .28597 L
.26949 .2801 L
.271 .27425 L
.27252 .26841 L
.27404 .26259 L
.27555 .25679 L
.27707 .25101 L
.27859 .24525 L
.2801 .23952 L
.28162 .23381 L
.28314 .22814 L
.28465 .22249 L
.28617 .21688 L
.28769 .21131 L
.2892 .20578 L
.29072 .20029 L
.29224 .19484 L
.29375 .18944 L
.29527 .18409 L
.29678 .17878 L
.2983 .17353 L
.29982 .16833 L
.30133 .16319 L
.30285 .15811 L
.30437 .15308 L
.30588 .14812 L
.3074 .14323 L
.30892 .1384 L
.31043 .13364 L
.31195 .12894 L
.31347 .12433 L
.31498 .11978 L
.3165 .11531 L
.31802 .11092 L
.31953 .1066 L
.32105 .10237 L
.32257 .09822 L
.32408 .09416 L
.3256 .09018 L
Mistroke
.32712 .08629 L
.32863 .08248 L
.33015 .07877 L
.33167 .07515 L
.33318 .07163 L
.3347 .06819 L
.33621 .06486 L
.33773 .06162 L
.33925 .05848 L
.34076 .05545 L
.34228 .05251 L
.3438 .04967 L
.34531 .04694 L
.34683 .04432 L
.34835 .0418 L
.34986 .03939 L
.35138 .03708 L
.3529 .03488 L
.35441 .0328 L
.35593 .03082 L
.35745 .02896 L
.35896 .0272 L
.36048 .02556 L
.362 .02404 L
.36351 .02262 L
.36503 .02133 L
.36655 .02014 L
.36806 .01907 L
.36958 .01812 L
.37109 .01729 L
.37261 .01657 L
.37413 .01597 L
.37564 .01548 L
.37716 .01512 L
.37868 .01487 L
.38019 .01473 L
.38171 .01472 L
.38323 .01482 L
.38474 .01505 L
.38626 .01538 L
.38778 .01584 L
.38929 .01641 L
.39081 .01711 L
.39233 .01791 L
.39384 .01884 L
.39536 .01988 L
.39688 .02103 L
.39839 .0223 L
.39991 .02369 L
.40143 .02519 L
Mistroke
.40294 .0268 L
.40446 .02853 L
.40598 .03037 L
.40749 .03231 L
.40901 .03438 L
.41052 .03655 L
.41204 .03882 L
.41356 .04121 L
.41507 .04371 L
.41659 .04631 L
.41811 .04901 L
.41962 .05182 L
.42114 .05473 L
.42266 .05775 L
.42417 .06086 L
.42569 .06408 L
.42721 .06739 L
.42872 .0708 L
.43024 .0743 L
.43176 .0779 L
.43327 .08159 L
.43479 .08537 L
.43631 .08924 L
.43782 .0932 L
.43934 .09724 L
.44086 .10137 L
.44237 .10559 L
.44389 .10988 L
.4454 .11425 L
.44692 .11871 L
.44844 .12323 L
.44995 .12783 L
.45147 .13251 L
.45299 .13725 L
.4545 .14207 L
.45602 .14695 L
.45754 .15189 L
.45905 .1569 L
.46057 .16197 L
.46209 .1671 L
.4636 .17228 L
.46512 .17752 L
.46664 .18281 L
.46815 .18816 L
.46967 .19355 L
.47119 .19898 L
.4727 .20446 L
.47422 .20999 L
.47574 .21555 L
.47725 .22115 L
Mistroke
.47877 .22678 L
.48029 .23245 L
.4818 .23815 L
.48332 .24388 L
.48483 .24963 L
.48635 .25541 L
.48787 .2612 L
.48938 .26702 L
.4909 .27286 L
.49242 .2787 L
.49393 .28456 L
.49545 .29043 L
.49697 .29631 L
.49848 .3022 L
.5 .30808 L
.50152 .31397 L
.50303 .31985 L
.50455 .32573 L
.50607 .3316 L
.50758 .33747 L
.5091 .34332 L
.51062 .34916 L
.51213 .35498 L
.51365 .36079 L
.51517 .36657 L
.51668 .37233 L
.5182 .37806 L
.51971 .38377 L
.52123 .38945 L
.52275 .3951 L
.52426 .40071 L
.52578 .40628 L
.5273 .41182 L
.52881 .41731 L
.53033 .42276 L
.53185 .42817 L
.53336 .43353 L
.53488 .43883 L
.5364 .44409 L
.53791 .44929 L
.53943 .45444 L
.54095 .45953 L
.54246 .46455 L
.54398 .46952 L
.5455 .47442 L
.54701 .47926 L
.54853 .48402 L
.55005 .48872 L
.55156 .49335 L
.55308 .4979 L
Mistroke
.5546 .50237 L
.55611 .50677 L
.55763 .51109 L
.55914 .51533 L
.56066 .51949 L
.56218 .52356 L
.56369 .52754 L
.56521 .53144 L
.56673 .53525 L
.56824 .53897 L
.56976 .5426 L
.57128 .54613 L
.57279 .54957 L
.57431 .55292 L
.57583 .55616 L
.57734 .55931 L
.57886 .56235 L
.58038 .5653 L
.58189 .56814 L
.58341 .57088 L
.58493 .57351 L
.58644 .57604 L
.58796 .57846 L
.58948 .58078 L
.59099 .58298 L
.59251 .58508 L
.59402 .58706 L
.59554 .58894 L
.59706 .5907 L
.59857 .59235 L
.60009 .59388 L
.60161 .5953 L
.60312 .59661 L
.60464 .5978 L
.60616 .59888 L
.60767 .59984 L
.60919 .60069 L
.61071 .60141 L
.61222 .60203 L
.61374 .60252 L
.61526 .6029 L
.61677 .60315 L
.61829 .6033 L
.61981 .60332 L
.62132 .60322 L
.62284 .60301 L
.62436 .60268 L
.62587 .60224 L
.62739 .60167 L
.62891 .60099 L
Mistroke
.63042 .60019 L
.63194 .59928 L
.63345 .59825 L
.63497 .5971 L
.63649 .59584 L
.638 .59446 L
.63952 .59297 L
.64104 .59137 L
.64255 .58965 L
.64407 .58782 L
.64559 .58588 L
.6471 .58383 L
.64862 .58167 L
.65014 .5794 L
.65165 .57702 L
.65317 .57453 L
.65469 .57194 L
.6562 .56924 L
.65772 .56644 L
.65924 .56354 L
.66075 .56053 L
.66227 .55743 L
.66379 .55422 L
.6653 .55091 L
.66682 .54751 L
.66833 .54402 L
.66985 .54043 L
.67137 .53674 L
.67288 .53297 L
.6744 .52911 L
.67592 .52516 L
.67743 .52112 L
.67895 .51699 L
.68047 .51279 L
.68198 .5085 L
.6835 .50413 L
.68502 .49969 L
.68653 .49517 L
.68805 .49057 L
.68957 .4859 L
.69108 .48116 L
.6926 .47635 L
.69412 .47148 L
.69563 .46654 L
.69715 .46154 L
.69867 .45647 L
.70018 .45135 L
.7017 .44617 L
.70322 .44093 L
.70473 .43565 L
Mistroke
.70625 .43031 L
.70776 .42492 L
.70928 .41949 L
.7108 .41401 L
.71231 .40849 L
.71383 .40293 L
.71535 .39733 L
.71686 .3917 L
.71838 .38604 L
.7199 .38034 L
.72141 .37462 L
.72293 .36887 L
.72445 .36309 L
.72596 .35729 L
.72748 .35148 L
.729 .34565 L
.73051 .3398 L
.73203 .33394 L
.73355 .32807 L
.73506 .32219 L
.73658 .31631 L
.7381 .31042 L
.73961 .30454 L
.74113 .29865 L
.74264 .29277 L
.74416 .2869 L
.74568 .28104 L
.74719 .27518 L
.74871 .26934 L
.75023 .26352 L
.75174 .25771 L
.75326 .25193 L
.75478 .24616 L
.75629 .24043 L
.75781 .23472 L
.75933 .22904 L
.76084 .22339 L
.76236 .21778 L
.76388 .2122 L
.76539 .20666 L
.76691 .20116 L
.76843 .19571 L
.76994 .1903 L
.77146 .18494 L
.77298 .17962 L
.77449 .17436 L
.77601 .16916 L
.77753 .16401 L
.77904 .15891 L
.78056 .15388 L
Mistroke
.78207 .14891 L
.78359 .144 L
.78511 .13916 L
.78662 .13439 L
.78814 .12969 L
.78966 .12506 L
.79117 .1205 L
.79269 .11602 L
.79421 .11161 L
.79572 .10729 L
.79724 .10304 L
.79876 .09888 L
.80027 .0948 L
.80179 .09081 L
.80331 .0869 L
.80482 .08308 L
.80634 .07936 L
.80786 .07572 L
.80937 .07218 L
.81089 .06873 L
.81241 .06538 L
.81392 .06213 L
.81544 .05898 L
.81695 .05592 L
.81847 .05297 L
.81999 .05012 L
.8215 .04737 L
.82302 .04473 L
.82454 .04219 L
.82605 .03976 L
.82757 .03744 L
.82909 .03523 L
.8306 .03312 L
.83212 .03113 L
.83364 .02925 L
.83515 .02747 L
.83667 .02582 L
.83819 .02427 L
.8397 .02284 L
.84122 .02152 L
.84274 .02032 L
.84425 .01924 L
.84577 .01827 L
.84729 .01741 L
.8488 .01668 L
.85032 .01606 L
.85184 .01555 L
.85335 .01517 L
.85487 .0149 L
.85638 .01475 L
Mistroke
.8579 .01472 L
.85942 .0148 L
.86093 .015 L
.86245 .01532 L
.86397 .01576 L
.86548 .01632 L
.867 .01699 L
.86852 .01778 L
.87003 .01868 L
.87155 .0197 L
.87307 .02084 L
.87458 .02209 L
.8761 .02346 L
.87762 .02494 L
.87913 .02654 L
.88065 .02824 L
.88217 .03006 L
.88368 .032 L
.8852 .03404 L
.88672 .03619 L
.88823 .03845 L
.88975 .04082 L
.89126 .0433 L
.89278 .04589 L
.8943 .04857 L
.89581 .05137 L
.89733 .05426 L
.89885 .05726 L
.90036 .06036 L
.90188 .06356 L
.9034 .06685 L
.90491 .07025 L
.90643 .07374 L
.90795 .07732 L
.90946 .081 L
.91098 .08476 L
.9125 .08862 L
.91401 .09256 L
.91553 .09659 L
.91705 .10071 L
.91856 .10491 L
.92008 .10919 L
.9216 .11355 L
.92311 .11799 L
.92463 .12251 L
.92614 .1271 L
.92766 .13176 L
.92918 .13649 L
.93069 .1413 L
.93221 .14617 L
Mistroke
.93373 .1511 L
.93524 .1561 L
.93676 .16116 L
.93828 .16628 L
.93979 .17145 L
.94131 .17668 L
.94283 .18197 L
.94434 .1873 L
.94586 .19269 L
.94738 .19812 L
.94889 .20359 L
.95041 .20911 L
.95193 .21466 L
.95344 .22026 L
.95496 .22588 L
.95648 .23155 L
.95799 .23724 L
.95951 .24296 L
.96103 .24871 L
.96254 .25449 L
.96406 .26028 L
.96557 .26609 L
.96709 .27193 L
.96861 .27777 L
.97012 .28363 L
.97164 .2895 L
.97316 .29538 L
.97467 .30126 L
.97619 .30714 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.211989 0.97619 0.395928 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151653 0.30902 0.294305 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02533 .31785 L
.02684 .32667 L
.02836 .33547 L
.02988 .34425 L
.03139 .353 L
.03291 .36171 L
.03443 .37037 L
.03594 .37898 L
.03746 .38752 L
.03897 .39599 L
.04049 .40439 L
.04201 .4127 L
.04352 .42091 L
.04504 .42903 L
.04656 .43703 L
.04807 .44492 L
.04959 .45269 L
.05111 .46033 L
.05262 .46784 L
.05414 .4752 L
.05566 .48241 L
.05717 .48946 L
.05869 .49636 L
.06021 .50308 L
.06172 .50963 L
.06324 .516 L
.06476 .52218 L
.06627 .52817 L
.06779 .53397 L
.06931 .53956 L
.07082 .54494 L
.07234 .55011 L
.07386 .55507 L
.07537 .5598 L
.07689 .56431 L
.0784 .56858 L
.07992 .57263 L
.08144 .57643 L
.08295 .58 L
.08447 .58332 L
.08599 .5864 L
.0875 .58922 L
.08902 .5918 L
.09054 .59412 L
.09205 .59618 L
.09357 .59798 L
.09509 .59953 L
.0966 .60081 L
.09812 .60183 L
Mistroke
.09964 .60259 L
.10115 .60308 L
.10267 .60331 L
.10419 .60327 L
.1057 .60297 L
.10722 .6024 L
.10874 .60157 L
.11025 .60048 L
.11177 .59912 L
.11328 .5975 L
.1148 .59563 L
.11632 .59349 L
.11783 .5911 L
.11935 .58846 L
.12087 .58556 L
.12238 .58242 L
.1239 .57903 L
.12542 .57539 L
.12693 .57152 L
.12845 .56741 L
.12997 .56307 L
.13148 .5585 L
.133 .5537 L
.13452 .54868 L
.13603 .54345 L
.13755 .53801 L
.13907 .53236 L
.14058 .52651 L
.1421 .52047 L
.14362 .51423 L
.14513 .50781 L
.14665 .50121 L
.14816 .49444 L
.14968 .4875 L
.1512 .4804 L
.15271 .47315 L
.15423 .46575 L
.15575 .4582 L
.15726 .45053 L
.15878 .44272 L
.1603 .4348 L
.16181 .42676 L
.16333 .41862 L
.16485 .41038 L
.16636 .40204 L
.16788 .39363 L
.1694 .38513 L
.17091 .37657 L
.17243 .36795 L
.17395 .35927 L
Mistroke
.17546 .35055 L
.17698 .34179 L
.1785 .33301 L
.18001 .3242 L
.18153 .31537 L
.18305 .30655 L
.18456 .29772 L
.18608 .2889 L
.18759 .2801 L
.18911 .27133 L
.19063 .26259 L
.19214 .2539 L
.19366 .24525 L
.19518 .23666 L
.19669 .22814 L
.19821 .21969 L
.19973 .21131 L
.20124 .20303 L
.20276 .19484 L
.20428 .18676 L
.20579 .17878 L
.20731 .17093 L
.20883 .16319 L
.21034 .15559 L
.21186 .14813 L
.21338 .14081 L
.21489 .13364 L
.21641 .12663 L
.21793 .11978 L
.21944 .11311 L
.22096 .10661 L
.22247 .10029 L
.22399 .09416 L
.22551 .08822 L
.22702 .08249 L
.22854 .07695 L
.23006 .07163 L
.23157 .06652 L
.23309 .06162 L
.23461 .05695 L
.23612 .05251 L
.23764 .0483 L
.23916 .04432 L
.24067 .04058 L
.24219 .03708 L
.24371 .03383 L
.24522 .03082 L
.24674 .02807 L
.24826 .02557 L
.24977 .02332 L
Mistroke
.25129 .02133 L
.25281 .0196 L
.25432 .01813 L
.25584 .01692 L
.25736 .01597 L
.25887 .01529 L
.26039 .01487 L
.2619 .01472 L
.26342 .01483 L
.26494 .0152 L
.26645 .01584 L
.26797 .01675 L
.26949 .01792 L
.271 .01934 L
.27252 .02103 L
.27404 .02298 L
.27555 .02519 L
.27707 .02765 L
.27859 .03037 L
.2801 .03333 L
.28162 .03655 L
.28314 .04001 L
.28465 .04371 L
.28617 .04765 L
.28769 .05182 L
.2892 .05623 L
.29072 .06087 L
.29224 .06572 L
.29375 .0708 L
.29527 .07609 L
.29678 .08159 L
.2983 .0873 L
.29982 .0932 L
.30133 .0993 L
.30285 .10559 L
.30437 .11206 L
.30588 .11871 L
.3074 .12553 L
.30892 .13251 L
.31043 .13965 L
.31195 .14695 L
.31347 .15439 L
.31498 .16197 L
.3165 .16969 L
.31802 .17752 L
.31953 .18548 L
.32105 .19355 L
.32257 .20172 L
.32408 .20999 L
.3256 .21835 L
Mistroke
.32712 .22679 L
.32863 .2353 L
.33015 .24388 L
.33167 .25252 L
.33318 .26121 L
.3347 .26994 L
.33621 .27871 L
.33773 .2875 L
.33925 .29631 L
.34076 .30514 L
.34228 .31397 L
.3438 .32279 L
.34531 .3316 L
.34683 .3404 L
.34835 .34916 L
.34986 .35789 L
.35138 .36657 L
.3529 .3752 L
.35441 .38377 L
.35593 .39228 L
.35745 .40071 L
.35896 .40905 L
.36048 .41731 L
.362 .42547 L
.36351 .43353 L
.36503 .44147 L
.36655 .44929 L
.36806 .45699 L
.36958 .46456 L
.37109 .47198 L
.37261 .47926 L
.37413 .48638 L
.37564 .49335 L
.37716 .50015 L
.37868 .50677 L
.38019 .51322 L
.38171 .51949 L
.38323 .52556 L
.38474 .53144 L
.38626 .53712 L
.38778 .5426 L
.38929 .54787 L
.39081 .55292 L
.39233 .55775 L
.39384 .56235 L
.39536 .56673 L
.39688 .57088 L
.39839 .57479 L
.39991 .57846 L
.40143 .58189 L
Mistroke
.40294 .58508 L
.40446 .58801 L
.40598 .5907 L
.40749 .59313 L
.40901 .5953 L
.41052 .59722 L
.41204 .59888 L
.41356 .60028 L
.41507 .60141 L
.41659 .60229 L
.41811 .6029 L
.41962 .60324 L
.42114 .60332 L
.42266 .60313 L
.42417 .60268 L
.42569 .60197 L
.42721 .60099 L
.42872 .59975 L
.43024 .59825 L
.43176 .59648 L
.43327 .59446 L
.43479 .59218 L
.43631 .58965 L
.43782 .58687 L
.43934 .58383 L
.44086 .58055 L
.44237 .57702 L
.44389 .57325 L
.4454 .56924 L
.44692 .565 L
.44844 .56053 L
.44995 .55583 L
.45147 .55092 L
.45299 .54578 L
.4545 .54043 L
.45602 .53487 L
.45754 .52911 L
.45905 .52315 L
.46057 .517 L
.46209 .51066 L
.4636 .50413 L
.46512 .49744 L
.46664 .49057 L
.46815 .48354 L
.46967 .47636 L
.47119 .46902 L
.4727 .46154 L
.47422 .45392 L
.47574 .44617 L
.47725 .4383 L
Mistroke
.47877 .43031 L
.48029 .42221 L
.4818 .41401 L
.48332 .40572 L
.48483 .39733 L
.48635 .38887 L
.48787 .38034 L
.48938 .37174 L
.4909 .36309 L
.49242 .35439 L
.49393 .34565 L
.49545 .33687 L
.49697 .32807 L
.49848 .31925 L
.5 .31043 L
.50152 .3016 L
.50303 .29278 L
.50455 .28397 L
.50607 .27518 L
.50758 .26643 L
.5091 .25771 L
.51062 .24904 L
.51213 .24043 L
.51365 .23188 L
.51517 .22339 L
.51668 .21498 L
.5182 .20666 L
.51971 .19843 L
.52123 .1903 L
.52275 .18227 L
.52426 .17436 L
.52578 .16658 L
.5273 .15891 L
.52881 .15139 L
.53033 .14401 L
.53185 .13677 L
.53336 .12969 L
.53488 .12277 L
.5364 .11602 L
.53791 .10944 L
.53943 .10304 L
.54095 .09683 L
.54246 .09081 L
.54398 .08498 L
.5455 .07936 L
.54701 .07394 L
.54853 .06874 L
.55005 .06375 L
.55156 .05898 L
.55308 .05444 L
Mistroke
.5546 .05012 L
.55611 .04604 L
.55763 .04219 L
.55914 .03859 L
.56066 .03523 L
.56218 .03211 L
.56369 .02925 L
.56521 .02663 L
.56673 .02427 L
.56824 .02217 L
.56976 .02033 L
.57128 .01874 L
.57279 .01742 L
.57431 .01635 L
.57583 .01555 L
.57734 .01502 L
.57886 .01475 L
.58038 .01475 L
.58189 .01501 L
.58341 .01553 L
.58493 .01632 L
.58644 .01737 L
.58796 .01868 L
.58948 .02026 L
.59099 .0221 L
.59251 .02419 L
.59402 .02654 L
.59554 .02914 L
.59706 .032 L
.59857 .0351 L
.60009 .03846 L
.60161 .04205 L
.60312 .04589 L
.60464 .04996 L
.60616 .05427 L
.60767 .0588 L
.60919 .06356 L
.61071 .06854 L
.61222 .07374 L
.61374 .07915 L
.61526 .08476 L
.61677 .09058 L
.61829 .0966 L
.61981 .1028 L
.62132 .10919 L
.62284 .11576 L
.62436 .12251 L
.62587 .12942 L
.62739 .1365 L
.62891 .14373 L
Mistroke
.63042 .1511 L
.63194 .15862 L
.63345 .16628 L
.63497 .17406 L
.63649 .18197 L
.638 .18999 L
.63952 .19812 L
.64104 .20634 L
.64255 .21466 L
.64407 .22307 L
.64559 .23155 L
.6471 .2401 L
.64862 .24871 L
.65014 .25738 L
.65165 .2661 L
.65317 .27485 L
.65469 .28363 L
.6562 .29244 L
.65772 .30126 L
.65924 .31009 L
.66075 .31891 L
.66227 .32773 L
.66379 .33653 L
.6653 .34531 L
.66682 .35406 L
.66833 .36276 L
.66985 .37141 L
.67137 .38001 L
.67288 .38855 L
.6744 .39701 L
.67592 .4054 L
.67743 .41369 L
.67895 .4219 L
.68047 .43 L
.68198 .43799 L
.6835 .44587 L
.68502 .45362 L
.68653 .46125 L
.68805 .46873 L
.68957 .47608 L
.69108 .48327 L
.6926 .49031 L
.69412 .49718 L
.69563 .50388 L
.69715 .51041 L
.69867 .51676 L
.70018 .52292 L
.7017 .52888 L
.70322 .53465 L
.70473 .54022 L
Mistroke
.70625 .54558 L
.70776 .55072 L
.70928 .55565 L
.7108 .56036 L
.71231 .56484 L
.71383 .56909 L
.71535 .5731 L
.71686 .57688 L
.71838 .58042 L
.7199 .58371 L
.72141 .58675 L
.72293 .58955 L
.72445 .59209 L
.72596 .59438 L
.72748 .59641 L
.729 .59818 L
.73051 .5997 L
.73203 .60095 L
.73355 .60194 L
.73506 .60266 L
.73658 .60312 L
.7381 .60332 L
.73961 .60325 L
.74113 .60291 L
.74264 .60232 L
.74416 .60145 L
.74568 .60033 L
.74719 .59894 L
.74871 .59729 L
.75023 .59538 L
.75174 .59322 L
.75326 .5908 L
.75478 .58812 L
.75629 .58519 L
.75781 .58202 L
.75933 .5786 L
.76084 .57494 L
.76236 .57103 L
.76388 .5669 L
.76539 .56253 L
.76691 .55793 L
.76843 .5531 L
.76994 .54806 L
.77146 .54281 L
.77298 .53734 L
.77449 .53166 L
.77601 .52579 L
.77753 .51972 L
.77904 .51346 L
.78056 .50702 L
Mistroke
.78207 .5004 L
.78359 .49361 L
.78511 .48665 L
.78662 .47953 L
.78814 .47226 L
.78966 .46484 L
.79117 .45728 L
.79269 .44959 L
.79421 .44177 L
.79572 .43383 L
.79724 .42578 L
.79876 .41763 L
.80027 .40937 L
.80179 .40103 L
.80331 .3926 L
.80482 .3841 L
.80634 .37553 L
.80786 .3669 L
.80937 .35822 L
.81089 .34949 L
.81241 .34073 L
.81392 .33194 L
.81544 .32313 L
.81695 .31431 L
.81847 .30548 L
.81999 .29665 L
.8215 .28784 L
.82302 .27904 L
.82454 .27027 L
.82605 .26154 L
.82757 .25285 L
.82909 .24421 L
.8306 .23563 L
.83212 .22711 L
.83364 .21867 L
.83515 .21031 L
.83667 .20204 L
.83819 .19386 L
.8397 .18579 L
.84122 .17783 L
.84274 .16998 L
.84425 .16227 L
.84577 .15468 L
.84729 .14723 L
.8488 .13993 L
.85032 .13278 L
.85184 .12579 L
.85335 .11897 L
.85487 .11231 L
.85638 .10583 L
Mistroke
.8579 .09954 L
.85942 .09343 L
.86093 .08752 L
.86245 .08181 L
.86397 .0763 L
.86548 .071 L
.867 .06591 L
.86852 .06105 L
.87003 .0564 L
.87155 .05199 L
.87307 .0478 L
.87458 .04386 L
.8761 .04014 L
.87762 .03668 L
.87913 .03345 L
.88065 .03048 L
.88217 .02775 L
.88368 .02528 L
.8852 .02306 L
.88672 .0211 L
.88823 .0194 L
.88975 .01797 L
.89126 .01679 L
.89278 .01587 L
.8943 .01522 L
.89581 .01484 L
.89733 .01472 L
.89885 .01486 L
.90036 .01527 L
.90188 .01594 L
.9034 .01688 L
.90491 .01807 L
.90643 .01954 L
.90795 .02126 L
.90946 .02324 L
.91098 .02547 L
.9125 .02797 L
.91401 .03071 L
.91553 .03371 L
.91705 .03695 L
.91856 .04044 L
.92008 .04417 L
.9216 .04814 L
.92311 .05235 L
.92463 .05678 L
.92614 .06144 L
.92766 .06633 L
.92918 .07143 L
.93069 .07675 L
.93221 .08227 L
Mistroke
.93373 .088 L
.93524 .09393 L
.93676 .10005 L
.93828 .10636 L
.93979 .11285 L
.94131 .11952 L
.94283 .12636 L
.94434 .13337 L
.94586 .14053 L
.94738 .14784 L
.94889 .1553 L
.95041 .1629 L
.95193 .17063 L
.95344 .17848 L
.95496 .18645 L
.95648 .19453 L
.95799 .20272 L
.95951 .211 L
.96103 .21936 L
.96254 .22781 L
.96406 .23633 L
.96557 .24492 L
.96709 .25357 L
.96861 .26226 L
.97012 .271 L
.97164 .27977 L
.97316 .28857 L
.97467 .29738 L
.97619 .30621 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]],

Cell[TextData[{
  "This is an example of the use of ",
  StyleBox["ShowAnimation", "MR"],
  ". To ensure the same scale for each image, it is necessary to specify a \
value for the ",
  StyleBox["PlotRange", "MR"],
  " option. "
}], "MathCaption",
  CellTags->{"S5.25.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
ShowAnimation[Table[ Graphics[Line[{{0, 0}, {Cos[ t], Sin[t]}}], \
PlotRange -> {{-1, 1}, {-1, 1}}], {t, 0, 2Pi, Pi/8}]]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .14918 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.119048 0.00355192 0.119048 [
[ 0 0 0 0 ]
[ 1 .14918 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .14918 L
0 .14918 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00355192 0.133279 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
0 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.144226 0.00355192 0.253695 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.03806 .19076 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.264641 0.00355192 0.374111 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.14645 .09051 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.385057 0.00355192 0.494527 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.30866 .02352 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.505473 0.00355192 0.614943 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.5 0 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.625889 0.00355192 0.735359 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.69134 .02352 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.746305 0.00355192 0.855774 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.85355 .09051 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.866721 0.00355192 0.97619 0.0712075 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.96194 .19076 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.0779731 0.133279 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
1 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.144226 0.0779731 0.253695 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.96194 .42727 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.264641 0.0779731 0.374111 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.85355 .52753 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.385057 0.0779731 0.494527 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.69134 .59451 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.505473 0.0779731 0.614943 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.5 .61803 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.625889 0.0779731 0.735359 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.30866 .59451 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.746305 0.0779731 0.855774 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.14645 .52753 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.866721 0.0779731 0.97619 0.145629 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.309017 0.309017 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .30902 m
.03806 .42727 L
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]],

Cell[TextData[{
  "In addition to ",
  StyleBox["Animate", "MR"],
  " and ",
  StyleBox["ShowAnimation", "MR"],
  ", there are a number of other functions in the packages that are designed \
to make more specific types of pictures. "
}], "Text",
  CellTags->{"S5.25.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MoviePlot[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox["\<\"[\"\>",
                      "MR"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"],\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"animate \"\>", 
                    StyleBox["\<\"Plot[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox["\<\"[\"\>",
                      "MR"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"],\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" for the given range of the variable \"\>", 
                    
                    StyleBox["\<\"t\"\>",
                      "TI"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MoviePlot3D[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox["\<\"[\"\>",
                      "MR"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"y\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"],\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"y\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"]}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"animate the three\[Hyphen]dimensional \
plots"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MovieDensityPlot[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox["\<\"[\"\>",
                      "MR"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"y\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"],\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"y\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"]}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"animate the density plots"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MovieContourPlot[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox["\<\"[\"\>",
                      "MR"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"y\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"],\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"x\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"xmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"y\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"ymax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"]}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"animate the contour plots"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MovieParametricPlot[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox["\<\"[\"\>",
                      "MR"], 
                    StyleBox["\<\"s\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"],\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"g\"\>",
                      "TI"], 
                    StyleBox["\<\"[\"\>",
                      "MR"], 
                    StyleBox["\<\"s\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"s\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"smin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"smax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmin\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"tmax\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"]}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"animate the parametric plots"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SpinShow[graphics]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"rotate the three\[Hyphen]dimensional \
graphics object"\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.25.1"],

Cell["Animation of various plots. ", "Caption",
  CellTags->"S5.25.1"],

Cell[TextData[{
  "For the purposes of display, only ten frames are plotted. To show the true \
proportions of the image, give the option ",
  StyleBox["AspectRatio", "MR"],
  " the value ",
  StyleBox["Automatic", "MR"],
  " and give explicit ranges for the ",
  StyleBox["PlotRange", "MR"],
  " option to ensure that all the images have the same scale. "
}], "MathCaption",
  CellTags->{"S5.25.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
MovieParametricPlot[
     {s Cos[2 Pi s + t], s Sin[2 Pi s + t]},
             {s, 0, 4}, {t, 0, 2Pi},
     Frames -> 10, Axes -> False,
     AspectRatio -> Automatic,
     PlotRange -> {{-4, 4}, {-4, 4}}]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S5.25.1"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.50062 .50002 L
.50118 .50007 L
.50182 .50017 L
.50242 .5003 L
.50347 .50062 L
.50458 .50111 L
.50574 .50179 L
.50689 .50269 L
.50779 .50358 L
.50868 .5047 L
.50949 .506 L
.5101 .50731 L
.51038 .50807 L
.51064 .50893 L
.51084 .50977 L
.51098 .51058 L
.51109 .51141 L
.51114 .5122 L
.51116 .51293 L
.51115 .51373 L
.51108 .51462 L
.51103 .51507 L
.51097 .51556 L
.51081 .51645 L
.51062 .51728 L
.51004 .51919 L
.50917 .52126 L
.5081 .52319 L
.50691 .52493 L
.50413 .52803 L
.50045 .53096 L
.49828 .53226 L
.49574 .5335 L
.49317 .53447 L
.49068 .53519 L
.4892 .53552 L
.48779 .53577 L
.4862 .53598 L
.4853 .53607 L
.48447 .53613 L
.4836 .53617 L
.48278 .5362 L
.48187 .5362 L
.48091 .53618 L
.48007 .53614 L
.47927 .53609 L
.4784 .53602 L
.47745 .53591 L
.47581 .53568 L
Mistroke
.47431 .5354 L
.47092 .53456 L
.46779 .53351 L
.46485 .53228 L
.45839 .52863 L
.4549 .52605 L
.45184 .52334 L
.44702 .51804 L
.44243 .51126 L
.44046 .50749 L
.43862 .50321 L
.43718 .49896 L
.43613 .49493 L
.43536 .49091 L
.43503 .48857 L
.43481 .48635 L
.43465 .48398 L
.43459 .48179 L
.4346 .47937 L
.43464 .47814 L
.43471 .4768 L
.43489 .4745 L
.43512 .4724 L
.43548 .46997 L
.4359 .46767 L
.43684 .46358 L
.43816 .45915 L
.44233 .44916 L
.44505 .44427 L
.4485 .43905 L
.45578 .43036 L
.46388 .42303 L
.47352 .41645 L
.47906 .41347 L
.48528 .41071 L
.49093 .40867 L
.4974 .40684 L
.50031 .40619 L
.50348 .40558 L
.50649 .40511 L
.50933 .40476 L
.51213 .4045 L
.51515 .40432 L
.51852 .40422 L
.52161 .40424 L
.52485 .40437 L
.52669 .40449 L
.52839 .40463 L
.53151 .40497 L
.53483 .40544 L
Mistroke
.54067 .40655 L
.54613 .40792 L
.55841 .41223 L
.56506 .41533 L
.5711 .41865 L
.58413 .42777 L
.59464 .43754 L
.60457 .44963 L
.61279 .46302 L
.6162 .47008 L
.61894 .47683 L
.62105 .48304 L
.62299 .49005 L
.62453 .49726 L
.62519 .50126 L
.6257 .50504 L
.62612 .50927 L
.62628 .51142 L
.62641 .5138 L
.62654 .51803 L
.62653 .52202 L
.62646 .52431 L
.62635 .52672 L
.62604 .53105 L
.6258 .53346 L
.62553 .53571 L
.62478 .54081 L
.62303 .54948 L
.62091 .5573 L
.61435 .57452 L
.60637 .58932 L
.59555 .60438 L
.58336 .61738 L
.57055 .62809 L
.55515 .63809 L
.54605 .6428 L
.53706 .64672 L
.52843 .64985 L
.51875 .65267 L
.50974 .65469 L
.50124 .65609 L
.49586 .65672 L
.49282 .657 L
.49001 .6572 L
.48481 .65743 L
.47931 .6575 L
.47434 .65739 L
.4697 .65715 L
.4646 .65672 L
.45914 .65608 L
Mistroke
.45331 .65519 L
.44698 .65398 L
.43557 .6511 L
.42459 .64749 L
.41462 .64344 L
.39619 .63383 L
.37759 .62084 L
.36154 .60617 L
.34839 .59088 L
.33522 .57096 L
.32931 .55965 L
.32387 .54705 L
.31953 .53451 L
.31637 .5228 L
.31511 .51704 L
.31396 .51076 L
.31308 .50485 L
.31242 .49921 L
.31189 .49305 L
.31159 .4874 L
.31146 .4813 L
.31147 .47783 L
.31154 .47463 L
.31177 .46929 L
.3122 .46339 L
.31286 .45723 L
.31365 .45145 L
.31614 .43826 L
.31925 .42627 L
.32357 .41327 L
.32914 .39986 L
.34232 .3757 L
.35769 .35478 L
.37775 .33404 L
.40254 .315 L
.41483 .30754 L
.42847 .30054 L
.4543 .29045 L
.4693 .28628 L
.48366 .28336 L
.49202 .28212 L
.49972 .28128 L
.50399 .28092 L
.50866 .28064 L
.51309 .28046 L
.51721 .28037 L
.52462 .2804 L
.5288 .28054 L
.53265 .28073 L
.53973 .28125 L
Mistroke
.54721 .28206 L
.55391 .283 L
.56015 .28407 L
.57426 .28715 L
.58936 .29154 L
.6029 .29647 L
.63225 .31075 L
.65688 .32717 L
.68077 .34813 L
.69894 .36865 L
.71625 .39381 L
.73124 .4233 L
.73791 .44084 L
.74284 .45741 L
.74623 .47235 L
.74774 .48092 L
.74887 .48896 L
.74979 .49754 L
.75037 .50537 L
.75058 .50973 L
.75073 .51445 L
.75077 .52305 L
.75053 .5313 L
.75007 .53883 L
.74926 .54753 L
.74821 .55577 L
.74567 .57035 L
.74194 .58611 L
.73667 .60318 L
.72973 .62098 L
.71392 .65174 L
.69334 .6812 L
.67027 .70634 L
.64121 .7305 L
.606 .75194 L
.59033 .7593 L
.57301 .76609 L
.55763 .77102 L
.54056 .77537 L
.52998 .77749 L
.52012 .77909 L
.51062 .7803 L
.50575 .78078 L
.50049 .78121 L
.49139 .78173 L
.48283 .78194 L
.4776 .78194 L
.47263 .78185 L
.46328 .78145 L
.45816 .78109 L
Mistroke
.45333 .78067 L
.44432 .77967 L
.43463 .77827 L
.42419 .77637 L
.4055 .77195 L
.38852 .76677 L
.35065 .75084 L
.33239 .74075 L
.31315 .72815 L
.28144 .70207 L
.25478 .67328 L
.23408 .64442 L
.21546 .61023 L
.20754 .59158 L
.20023 .57036 L
.19714 .55946 L
.19425 .54757 L
.19213 .53718 L
.19021 .52572 L
.18881 .51492 L
.18784 .50482 L
.18718 .49409 L
.18697 .48807 L
.18688 .48259 L
.18696 .47274 L
.18739 .46205 L
.18814 .45196 L
.18912 .44266 L
.19054 .43227 L
.19221 .42243 L
.1962 .40409 L
.20171 .38458 L
.20915 .36367 L
.22619 .32736 L
.24605 .29561 L
.27481 .2605 L
.30506 .23221 L
.34438 .20434 L
.36501 .19284 L
.38502 .18341 L
.42428 .16929 L
.44581 .16377 L
.46928 .15942 L
.48124 .15785 L
.48756 .1572 L
.4943 .15663 L
.50019 .15624 L
.50669 .15593 L
.51818 .15568 L
.52935 .15581 L
Mistroke
.54137 .15635 L
.55273 .15725 L
.56311 .1584 L
.57344 .15986 L
.58443 .16176 L
.60409 .16609 L
.62717 .17272 L
.64775 .18012 L
.68699 .19848 L
.7219 .22022 L
.75619 .24776 L
.78989 .28284 L
.81992 .32427 L
.84262 .36675 L
.85154 .38824 L
.85875 .40917 L
.86422 .4286 L
.86887 .4496 L
.8708 .46055 L
.87255 .47272 L
.87379 .48386 L
.87466 .49437 L
.8753 .50674 L
.87552 .51812 L
.87537 .53063 L
.87514 .53693 L
.87476 .54383 L
.8737 .55692 L
.87231 .56899 L
.87033 .58219 L
.86773 .59612 L
.86218 .61934 L
.85437 .64452 L
.83538 .68954 L
.8124 .72943 L
.77955 .77248 L
.74429 .80772 L
.6981 .84268 L
.67361 .85731 L
.64957 .86947 L
.62608 .87947 L
.59995 .88859 L
.57562 .89532 L
.55285 .90016 L
.5408 .90217 L
.5278 .90393 L
.52031 .90474 L
.51346 .90537 L
.50002 .90625 L
.48614 .90669 L
Mistroke
.47828 .90673 L
.47102 .90663 L
.45767 .90612 L
.44351 .90509 L
.43132 .9038 L
.42017 .9023 L
.39518 .8978 L
.37336 .89254 L
.35068 .8857 L
.30384 .86687 L
.2554 .83978 L
.20854 .80441 L
.16902 .7651 L
.13803 .72542 L
.10987 .67835 L
.08614 .62301 L
.07714 .59386 L
.07289 .57681 L
.06961 .56107 L
.06727 .54749 L
.06521 .5326 L
.0643 .5244 L
.06359 .51678 L
.06258 .5017 L
.06211 .48742 L
.06208 .47448 L
.06253 .45953 L
.06342 .44547 L
.06471 .43192 L
.06655 .41746 L
.07108 .39152 L
.07849 .361 L
.08713 .33367 L
.112 .27621 L
.14289 .22529 L
.17715 .18229 L
.21338 .14636 L
.25775 .11172 L
.30935 .08109 L
.33713 .06812 L
.36436 .05749 L
.3897 .04933 L
.41727 .04222 L
.43311 .03894 L
.44759 .03644 L
.46241 .03437 L
.47611 .03288 L
.49222 .03165 L
.50071 .03122 L
.50971 .03094 L
Mistroke
.52485 .03085 L
.53346 .03103 L
.5415 .03133 L
.5556 .03219 L
.57092 .03361 L
.58536 .03541 L
.59869 .03748 L
.62374 .04243 L
.65008 .04918 L
.70344 .068 L
.75958 .09611 L
.80844 .1289 L
.85539 .16981 L
.89121 .20947 L
.9253 .25729 L
.95554 .31343 L
.96927 .34656 L
.97964 .37755 L
.98749 .40712 L
.99088 .4229 L
.99392 .43975 L
.99611 .45457 L
.998 .47097 L
.99924 .48594 L
1 .5 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.50086 .50081 L
.50166 .50179 L
.50231 .5028 L
.5028 .50379 L
.50324 .50503 L
.50342 .50576 L
.50355 .50646 L
.50362 .50707 L
.50367 .50776 L
.50367 .50849 L
.50363 .50918 L
.50355 .5099 L
.50348 .51031 L
.50341 .51069 L
.50323 .51144 L
.50303 .51212 L
.50253 .51342 L
.50185 .51477 L
.50093 .5162 L
.49973 .51766 L
.49703 .52007 L
.49535 .52116 L
.49363 .52205 L
.49159 .52287 L
.48924 .52355 L
.48801 .5238 L
.48734 .5239 L
.48663 .524 L
.48599 .52407 L
.48528 .52412 L
.48463 .52416 L
.48402 .52418 L
.48341 .52418 L
.48276 .52417 L
.48158 .52411 L
.48092 .52405 L
.4803 .52399 L
.47889 .52378 L
.47765 .52355 L
.4763 .52323 L
.47384 .52248 L
.47145 .52153 L
.46926 .52046 L
.46441 .51734 L
.45964 .51302 L
.45575 .50814 L
.45274 .50298 L
.45134 .49987 L
.45005 .49628 L
Mistroke
.44908 .49273 L
.44842 .4893 L
.44818 .48759 L
.44798 .48572 L
.44786 .48393 L
.4478 .48227 L
.4478 .48075 L
.44784 .47907 L
.44794 .47731 L
.44809 .47565 L
.44833 .47369 L
.44863 .47183 L
.44936 .46832 L
.45041 .46454 L
.45187 .46045 L
.45558 .45275 L
.46015 .44583 L
.46637 .43876 L
.47438 .43197 L
.4836 .4263 L
.48866 .42392 L
.49447 .42174 L
.49968 .42022 L
.50262 .41953 L
.50543 .41899 L
.50809 .41857 L
.51102 .41821 L
.5137 .41798 L
.51619 .41785 L
.51906 .41779 L
.5218 .41782 L
.52428 .41793 L
.52698 .41814 L
.52993 .41846 L
.53307 .41892 L
.53873 .42005 L
.54393 .42144 L
.54878 .42306 L
.55964 .42786 L
.57092 .43482 L
.58055 .44276 L
.59008 .45309 L
.59864 .46566 L
.60204 .47206 L
.60486 .47839 L
.60709 .48435 L
.60907 .49087 L
.60994 .49432 L
.61077 .49818 L
.61141 .50177 L
Mistroke
.6119 .50509 L
.61235 .50904 L
.61253 .51123 L
.61267 .51332 L
.61281 .51706 L
.61284 .51918 L
.61283 .52116 L
.61273 .52471 L
.61249 .52857 L
.61214 .53222 L
.61171 .53559 L
.61063 .54198 L
.60909 .5487 L
.60697 .5559 L
.60456 .56255 L
.59755 .57726 L
.58834 .59134 L
.57601 .60538 L
.56231 .61708 L
.54804 .6263 L
.53406 .63309 L
.52558 .63629 L
.51756 .63875 L
.50892 .64082 L
.5044 .64168 L
.4994 .64244 L
.49499 .64297 L
.49085 .64334 L
.48646 .64359 L
.48174 .64372 L
.47697 .64369 L
.47425 .6436 L
.4717 .64347 L
.46901 .64329 L
.46655 .64307 L
.46102 .64244 L
.45631 .64173 L
.45119 .64078 L
.44192 .63858 L
.4312 .63523 L
.42 .63075 L
.40064 .62038 L
.38228 .60681 L
.36673 .59147 L
.35448 .57576 L
.34337 .55697 L
.33889 .54735 L
.33476 .53669 L
.33176 .5272 L
.32913 .51664 L
Mistroke
.32785 .51008 L
.32689 .50396 L
.32618 .49805 L
.32589 .49505 L
.32564 .49174 L
.32536 .486 L
.32528 .48276 L
.32526 .47978 L
.32537 .47401 L
.32566 .4685 L
.3259 .46529 L
.32618 .46227 L
.32686 .45662 L
.32779 .45054 L
.32903 .44398 L
.33192 .43221 L
.33529 .4215 L
.34563 .39755 L
.35218 .38598 L
.36038 .37375 L
.37733 .35362 L
.3961 .33665 L
.41496 .32349 L
.43737 .31167 L
.4496 .30667 L
.46355 .30209 L
.47072 .30017 L
.47855 .29838 L
.4854 .29709 L
.49297 .29595 L
.50009 .29513 L
.50676 .2946 L
.51385 .29427 L
.51783 .29419 L
.52146 .29419 L
.52797 .29434 L
.53505 .29475 L
.54174 .29535 L
.54791 .2961 L
.5613 .29838 L
.57346 .30124 L
.58733 .30545 L
.60029 .31035 L
.62258 .32116 L
.64554 .33596 L
.66862 .35557 L
.69026 .38004 L
.7074 .40612 L
.71982 .43188 L
.72478 .44523 L
Mistroke
.72928 .46027 L
.73117 .468 L
.7329 .47636 L
.73416 .48366 L
.73526 .49165 L
.73608 .49966 L
.7366 .50711 L
.73688 .51426 L
.73694 .52187 L
.73678 .52868 L
.73645 .53507 L
.7359 .54209 L
.73507 .54965 L
.73387 .55792 L
.73251 .5656 L
.72847 .58288 L
.72329 .59948 L
.71643 .61685 L
.70054 .64709 L
.68244 .67266 L
.66047 .69655 L
.63382 .71875 L
.60861 .73485 L
.57868 .74915 L
.56099 .75552 L
.5444 .76024 L
.53507 .76238 L
.52481 .76434 L
.51502 .76581 L
.50589 .76686 L
.49748 .76754 L
.48954 .76793 L
.48081 .7681 L
.47588 .76806 L
.47136 .76795 L
.46277 .76753 L
.45337 .76676 L
.44863 .76624 L
.44356 .7656 L
.43445 .76419 L
.41621 .76041 L
.39712 .75502 L
.36379 .74185 L
.32985 .7228 L
.29561 .6963 L
.26939 .66919 L
.24524 .63612 L
.22681 .60173 L
.21403 .56806 L
.20887 .54928 L
Mistroke
.20526 .53191 L
.2037 .52217 L
.20238 .51155 L
.20149 .50147 L
.20097 .49215 L
.20075 .48347 L
.20077 .47535 L
.20104 .46643 L
.20163 .45687 L
.20258 .44684 L
.20379 .43736 L
.20688 .41966 L
.21157 .40008 L
.218 .37957 L
.23319 .34385 L
.2546 .30759 L
.28395 .27103 L
.31389 .24289 L
.34937 .21754 L
.38242 .19977 L
.42097 .18478 L
.44368 .17848 L
.46475 .17418 L
.47656 .1724 L
.48282 .17163 L
.48946 .17094 L
.49529 .17046 L
.50172 .17004 L
.51306 .16961 L
.52451 .16957 L
.53499 .16989 L
.54077 .1702 L
.54708 .17066 L
.55856 .17181 L
.56923 .17324 L
.58056 .17514 L
.6008 .17956 L
.62317 .186 L
.64632 .19448 L
.6862 .21392 L
.72621 .24066 L
.7656 .2764 L
.79517 .31221 L
.82143 .35488 L
.83198 .37695 L
.84055 .39853 L
.84751 .41996 L
.8528 .44048 L
.85684 .4611 L
.85858 .47281 L
Mistroke
.85983 .48359 L
.86083 .4954 L
.86122 .50211 L
.86147 .50835 L
.86166 .5198 L
.86145 .53204 L
.86117 .53869 L
.8608 .5448 L
.86027 .55152 L
.85958 .55861 L
.8581 .57052 L
.85602 .58356 L
.85093 .60748 L
.84472 .62955 L
.82843 .67191 L
.80901 .70878 L
.78145 .74857 L
.75058 .78293 L
.716 .81306 L
.6736 .8414 L
.65084 .8535 L
.62536 .86484 L
.60263 .87316 L
.57714 .88065 L
.55284 .88606 L
.54107 .8881 L
.52988 .88969 L
.51707 .89112 L
.50537 .89205 L
.49272 .89266 L
.48557 .89283 L
.47897 .89286 L
.46803 .89268 L
.45778 .89223 L
.44654 .89143 L
.43447 .89021 L
.42187 .88853 L
.40995 .88656 L
.3877 .88188 L
.36137 .87458 L
.33701 .86605 L
.29299 .84587 L
.2484 .81822 L
.20438 .78187 L
.17006 .74492 L
.13886 .70139 L
.11676 .66104 L
.09773 .61401 L
.08976 .58736 L
.08627 .57307 L
Mistroke
.08311 .55775 L
.08082 .54428 L
.07879 .52932 L
.07741 .51564 L
.07653 .50276 L
.07604 .49 L
.07594 .47656 L
.07619 .46507 L
.07682 .4525 L
.07793 .43892 L
.07959 .42445 L
.08161 .41083 L
.08383 .39851 L
.09073 .36882 L
.09896 .34188 L
.12406 .2831 L
.15336 .23454 L
.19117 .1875 L
.23285 .14794 L
.27534 .11666 L
.30043 .10156 L
.32891 .08698 L
.35712 .07496 L
.38337 .06575 L
.40871 .05854 L
.43656 .05241 L
.45208 .04979 L
.46643 .04786 L
.48021 .04644 L
.4948 .0454 L
.50743 .04487 L
.52096 .04471 L
.53375 .04492 L
.54539 .04542 L
.55906 .04639 L
.57389 .04791 L
.58785 .0498 L
.6007 .05192 L
.62959 .05807 L
.65569 .06534 L
.71283 .08732 L
.76304 .1144 L
.80759 .14584 L
.85445 .18866 L
.89264 .23399 L
.92784 .2891 L
.94309 .31957 L
.95683 .35295 L
.96626 .38123 L
.97459 .41296 L
Mistroke
.97756 .42708 L
.98028 .44233 L
.98239 .45671 L
.98396 .47009 L
.9854 .4869 L
.98592 .4958 L
.9863 .50526 L
.98652 .52117 L
.98641 .53024 L
.98615 .53876 L
.98528 .55453 L
.98404 .56898 L
.98217 .58481 L
.97965 .60143 L
.97401 .62964 L
.96616 .65943 L
.94729 .71182 L
.91721 .77115 L
.88302 .82139 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.50009 .50061 L
.50014 .50117 L
.50015 .50182 L
.50013 .50244 L
.50007 .50301 L
.49999 .50353 L
.49987 .5041 L
.49971 .5047 L
.49925 .50593 L
.49868 .50705 L
.49789 .50821 L
.49688 .50937 L
.49575 .51037 L
.49436 .51133 L
.49289 .5121 L
.49142 .51268 L
.49063 .51292 L
.48986 .51311 L
.48915 .51325 L
.48837 .51337 L
.4875 .51346 L
.48656 .5135 L
.48574 .5135 L
.48483 .51346 L
.4843 .51342 L
.48381 .51336 L
.48269 .51319 L
.48169 .51299 L
.48063 .51271 L
.47878 .51209 L
.47674 .51118 L
.47462 .50997 L
.47239 .50838 L
.47054 .50677 L
.46864 .50476 L
.46557 .50049 L
.46415 .49784 L
.46302 .49519 L
.46214 .49255 L
.46151 .49003 L
.46123 .48859 L
.46099 .487 L
.46082 .48546 L
.46072 .48403 L
.46067 .48247 L
.46067 .48097 L
.46073 .47962 L
.46084 .47812 L
.46102 .47649 L
Mistroke
.46129 .47474 L
.46196 .47156 L
.4629 .46833 L
.46403 .46529 L
.46676 .45968 L
.47113 .45322 L
.47617 .44771 L
.48278 .44231 L
.48681 .43974 L
.49089 .43757 L
.49474 .43587 L
.49911 .4343 L
.50325 .43314 L
.5072 .4323 L
.50945 .43194 L
.51158 .43166 L
.51396 .43144 L
.5153 .43135 L
.51654 .43129 L
.51891 .43124 L
.52027 .43125 L
.52153 .43128 L
.5241 .43142 L
.52554 .43153 L
.52685 .43167 L
.52915 .43196 L
.53158 .43235 L
.53595 .43326 L
.54065 .43457 L
.54577 .43638 L
.55478 .44061 L
.56287 .44572 L
.57165 .45302 L
.58022 .46254 L
.58712 .47293 L
.58994 .47832 L
.59228 .48361 L
.59578 .49395 L
.59716 .49969 L
.59774 .50271 L
.59826 .50605 L
.59866 .50937 L
.59893 .51248 L
.59912 .51581 L
.59919 .51939 L
.59913 .52274 L
.59898 .52593 L
.59875 .5288 L
.59841 .53193 L
.59793 .53532 L
Mistroke
.59739 .53842 L
.59581 .5454 L
.5939 .55183 L
.59169 .55788 L
.58533 .57105 L
.57622 .58462 L
.56527 .59669 L
.55152 .60795 L
.53677 .61675 L
.52213 .62295 L
.51469 .62529 L
.50628 .62734 L
.50197 .62815 L
.49729 .62886 L
.49283 .62938 L
.48873 .62971 L
.48462 .62991 L
.48081 .62998 L
.4766 .62993 L
.47211 .62972 L
.46822 .62942 L
.46456 .62903 L
.46054 .62848 L
.45622 .62775 L
.44728 .62577 L
.43759 .62288 L
.42763 .61907 L
.41857 .6148 L
.40296 .60541 L
.38751 .59304 L
.37318 .57779 L
.36183 .56178 L
.35173 .54232 L
.34768 .53187 L
.34408 .51996 L
.34277 .51447 L
.3417 .5092 L
.34088 .50436 L
.34018 .49917 L
.33985 .49619 L
.3396 .49349 L
.33925 .48819 L
.33913 .4852 L
.33907 .48197 L
.33906 .47891 L
.33911 .47609 L
.33932 .47102 L
.33966 .46629 L
.3402 .46109 L
.34095 .45553 L
Mistroke
.34311 .4442 L
.34577 .43396 L
.35323 .41361 L
.35803 .40364 L
.3641 .39296 L
.37693 .37486 L
.39081 .35965 L
.40954 .34377 L
.43228 .32951 L
.4431 .32424 L
.45537 .31927 L
.4674 .31536 L
.47875 .31247 L
.49135 .31013 L
.49807 .30924 L
.50151 .30888 L
.50522 .30856 L
.51149 .30818 L
.51737 .30802 L
.52096 .30801 L
.52438 .30806 L
.5308 .30832 L
.5366 .30874 L
.54276 .30938 L
.54803 .31008 L
.55383 .31102 L
.56668 .31376 L
.57863 .31714 L
.60462 .32742 L
.62727 .34013 L
.65033 .35751 L
.67202 .37943 L
.6887 .40189 L
.70131 .42432 L
.70715 .43745 L
.71251 .4522 L
.7166 .46653 L
.71952 .48005 L
.72054 .48615 L
.72145 .49275 L
.72213 .49902 L
.7226 .50477 L
.72295 .51154 L
.7231 .51894 L
.72302 .52595 L
.72275 .53247 L
.72221 .53983 L
.72148 .54676 L
.72064 .55298 L
.71953 .55968 L
Mistroke
.71631 .57468 L
.71243 .58832 L
.70199 .6152 L
.68702 .6426 L
.66946 .66666 L
.65075 .6867 L
.62577 .70749 L
.59538 .72625 L
.58048 .73338 L
.56409 .73986 L
.54962 .7445 L
.53343 .74857 L
.5178 .75144 L
.50917 .75258 L
.50111 .75338 L
.49348 .7539 L
.48653 .75417 L
.47849 .75424 L
.47089 .75408 L
.46257 .75364 L
.45378 .75288 L
.44628 .75199 L
.43805 .75075 L
.41981 .74703 L
.40295 .74234 L
.37308 .73088 L
.34699 .7172 L
.31874 .69773 L
.29426 .67585 L
.27257 .65112 L
.2521 .62068 L
.24334 .60431 L
.23511 .58593 L
.22905 .56952 L
.22359 .55107 L
.21963 .53348 L
.21696 .51683 L
.2159 .50753 L
.21521 .49903 L
.21473 .48917 L
.21459 .47982 L
.21471 .47174 L
.21509 .46317 L
.21562 .45584 L
.21642 .44779 L
.21754 .43915 L
.21903 .42988 L
.2225 .41322 L
.22769 .39436 L
.23463 .3746 L
Mistroke
.25072 .34027 L
.27564 .30221 L
.30328 .27105 L
.33349 .24511 L
.37001 .22157 L
.38794 .21249 L
.40757 .20416 L
.4249 .19808 L
.44419 .19263 L
.45486 .19018 L
.46481 .18824 L
.47421 .18672 L
.48466 .18537 L
.49404 .18446 L
.50289 .18386 L
.51226 .18349 L
.52239 .18341 L
.53275 .18367 L
.53862 .18396 L
.54409 .18433 L
.55513 .18537 L
.5669 .18691 L
.58814 .19082 L
.60725 .19563 L
.64381 .20845 L
.66378 .21763 L
.68167 .22731 L
.71529 .24976 L
.74359 .27391 L
.77155 .30418 L
.79737 .34053 L
.81694 .37728 L
.83131 .41439 L
.83749 .43603 L
.84027 .44809 L
.8425 .45954 L
.84424 .47034 L
.84573 .48208 L
.84674 .49281 L
.84737 .50271 L
.84775 .51459 L
.84774 .52569 L
.84758 .53208 L
.84732 .53789 L
.84691 .5446 L
.8464 .55095 L
.84503 .56363 L
.84335 .57532 L
.8381 .60158 L
.8321 .62346 L
Mistroke
.82536 .64319 L
.80591 .68616 L
.78279 .72363 L
.75653 .75661 L
.72134 .7909 L
.68452 .81843 L
.64018 .84323 L
.61388 .85444 L
.58924 .86286 L
.56709 .86884 L
.54231 .87384 L
.52968 .87573 L
.52269 .87659 L
.51605 .87729 L
.50311 .8783 L
.49126 .87883 L
.48013 .87899 L
.46828 .87881 L
.45816 .87836 L
.44698 .87754 L
.43503 .87631 L
.42217 .87455 L
.39901 .87024 L
.37416 .86395 L
.34741 .85515 L
.29552 .83147 L
.25072 .80275 L
.21262 .77055 L
.17712 .73159 L
.14462 .68407 L
.13202 .66069 L
.12036 .63499 L
.11172 .61209 L
.10399 .58685 L
.09807 .56195 L
.09403 .53882 L
.09256 .52761 L
.09131 .51531 L
.09047 .50366 L
.08999 .49281 L
.0898 .479 L
.09004 .46598 L
.09061 .45428 L
.0916 .44164 L
.09314 .42784 L
.09526 .41331 L
.10036 .38747 L
.10757 .36039 L
.1161 .33518 L
.13641 .28943 L
Mistroke
.16438 .243 L
.2015 .19677 L
.23913 .16078 L
.28383 .1277 L
.32534 .10411 L
.3741 .08348 L
.3999 .07527 L
.42872 .06812 L
.44347 .06526 L
.45935 .06276 L
.47443 .06093 L
.48818 .05972 L
.50202 .05894 L
.51481 .05861 L
.52886 .05867 L
.54374 .05923 L
.55667 .06011 L
.56874 .06129 L
.58196 .06296 L
.59611 .0652 L
.62698 .07172 L
.6601 .08133 L
.69071 .09276 L
.71834 .10535 L
.76819 .13422 L
.817 .17185 L
.8625 .21831 L
.89829 .26654 L
.93017 .32469 L
.94304 .35567 L
.95457 .39068 L
.96245 .42241 L
.9677 .45177 L
.9698 .46818 L
.97068 .47687 L
.97143 .4861 L
.97194 .49417 L
.97234 .50309 L
.97264 .51882 L
.97241 .53463 L
.97174 .5491 L
.97118 .55708 L
.97041 .56579 L
.9686 .58162 L
.96643 .59633 L
.96361 .61194 L
.95723 .63981 L
.94782 .67137 L
.93552 .70401 L
.90757 .76016 L
Mistroke
.86941 .81628 L
.81865 .8714 L
.76809 .91255 L
.70801 .949 L
.67704 .96356 L
.64675 .97538 L
.58795 .99216 L
.58682 .9924 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.49935 .50098 L
.49853 .50195 L
.49764 .50276 L
.49675 .50341 L
.49561 .50406 L
.49496 .50435 L
.49426 .50461 L
.49362 .50481 L
.4929 .50498 L
.49223 .50509 L
.49159 .50517 L
.49087 .50521 L
.49045 .50522 L
.49007 .50521 L
.48936 .50517 L
.48859 .50509 L
.48783 .50496 L
.48711 .50479 L
.48577 .50438 L
.48419 .50372 L
.48277 .50293 L
.48126 .50189 L
.47972 .50056 L
.47835 .49909 L
.47719 .49758 L
.47526 .4942 L
.4744 .49209 L
.47402 .49091 L
.47367 .48962 L
.47342 .48847 L
.47319 .48715 L
.47305 .48593 L
.47296 .48476 L
.47291 .48353 L
.47291 .48282 L
.47293 .48215 L
.47296 .48144 L
.473 .48079 L
.47307 .48003 L
.47315 .47931 L
.47334 .47803 L
.47356 .47684 L
.47425 .47412 L
.47519 .47139 L
.47652 .46839 L
.47811 .46554 L
.48017 .46252 L
.48457 .45758 L
.48966 .45339 L
Mistroke
.49542 .44994 L
.5014 .4474 L
.50534 .44621 L
.50733 .44574 L
.5092 .44537 L
.5109 .44509 L
.51279 .44485 L
.51471 .44467 L
.51677 .44455 L
.51794 .44452 L
.51906 .44452 L
.52117 .44456 L
.52236 .44463 L
.52346 .4447 L
.52467 .44482 L
.52597 .44496 L
.53013 .44564 L
.53251 .44616 L
.53474 .44675 L
.54267 .44958 L
.54709 .4517 L
.55112 .45401 L
.55891 .45967 L
.56652 .46712 L
.57275 .47531 L
.57767 .48402 L
.58118 .49257 L
.58274 .49765 L
.58388 .50248 L
.58442 .5053 L
.58483 .50802 L
.58513 .51048 L
.58537 .51319 L
.58553 .51616 L
.58558 .51767 L
.5856 .51934 L
.58555 .52231 L
.58541 .52512 L
.58519 .52779 L
.58487 .53061 L
.58406 .53567 L
.58286 .54112 L
.58113 .54707 L
.57611 .55933 L
.57249 .56599 L
.56869 .57186 L
.55996 .58263 L
.55017 .59182 L
.53953 .5995 L
.5265 .60648 L
Mistroke
.51949 .60935 L
.51166 .61191 L
.50401 .61381 L
.50056 .61448 L
.49684 .61509 L
.49307 .61557 L
.48962 .6159 L
.48612 .61612 L
.48281 .61624 L
.47892 .61626 L
.47532 .61616 L
.47135 .61592 L
.46715 .61552 L
.46373 .61508 L
.46007 .6145 L
.45347 .61315 L
.44566 .61106 L
.43861 .60867 L
.42383 .60205 L
.40892 .59279 L
.39708 .58316 L
.38523 .57078 L
.37421 .55565 L
.36922 .547 L
.36462 .53745 L
.36115 .52869 L
.35802 .51877 L
.35579 .50949 L
.35426 .50067 L
.35365 .49573 L
.35339 .49302 L
.35319 .49047 L
.35294 .48594 L
.35283 .48093 L
.35285 .47813 L
.35291 .47547 L
.35316 .47046 L
.35337 .46765 L
.35362 .46505 L
.35435 .45916 L
.35518 .45397 L
.35614 .4491 L
.35837 .44004 L
.36141 .43039 L
.36543 .42012 L
.37443 .40251 L
.38644 .38506 L
.39863 .37133 L
.41389 .35779 L
.43332 .3447 L
Mistroke
.44362 .33922 L
.45353 .33478 L
.47292 .32815 L
.48353 .32556 L
.4895 .32442 L
.49502 .32355 L
.50094 .32281 L
.5066 .3223 L
.51262 .32196 L
.51604 .32185 L
.51922 .32181 L
.52505 .32189 L
.53035 .32213 L
.53648 .32259 L
.54225 .32323 L
.54864 .32415 L
.55537 .32538 L
.56736 .32822 L
.58011 .3322 L
.59385 .33767 L
.61701 .34997 L
.63746 .36471 L
.65422 .38033 L
.67042 .39969 L
.68522 .4232 L
.69148 .43594 L
.69736 .45058 L
.70147 .46343 L
.70329 .47031 L
.70496 .47765 L
.7062 .48417 L
.70733 .49137 L
.70813 .49797 L
.70869 .50414 L
.7091 .5112 L
.70921 .51476 L
.70927 .5187 L
.70919 .52567 L
.70891 .53221 L
.70864 .53617 L
.70831 .53992 L
.70751 .54697 L
.70639 .55454 L
.70485 .56278 L
.7015 .57659 L
.6969 .5911 L
.686 .61647 L
.67101 .64172 L
.65374 .66371 L
.63581 .68166 L
Mistroke
.61407 .69882 L
.58831 .71433 L
.56237 .72576 L
.54678 .73091 L
.53222 .73467 L
.52404 .73635 L
.51506 .73785 L
.50651 .73895 L
.49855 .7397 L
.49088 .74017 L
.48259 .74039 L
.47475 .74034 L
.46754 .74007 L
.45954 .73952 L
.45501 .73909 L
.4508 .73861 L
.43325 .73581 L
.42426 .73385 L
.41582 .7317 L
.40022 .72685 L
.36633 .71217 L
.33987 .69614 L
.31304 .6747 L
.28812 .6484 L
.26819 .62057 L
.25287 .59211 L
.24195 .56442 L
.23725 .54854 L
.23516 .54002 L
.23324 .53087 L
.23183 .52283 L
.23055 .51388 L
.22964 .50569 L
.22902 .49795 L
.2286 .48955 L
.22844 .48054 L
.22856 .47201 L
.22891 .46425 L
.22959 .45512 L
.23012 .44997 L
.23069 .44522 L
.23361 .4273 L
.23753 .41025 L
.24312 .39173 L
.2584 .35541 L
.27578 .32573 L
.29856 .29617 L
.32365 .271 L
.34938 .25069 L
.38084 .23148 L
Mistroke
.39918 .2226 L
.41706 .2154 L
.43424 .2097 L
.45325 .20472 L
.46177 .20291 L
.47085 .20127 L
.47925 .20001 L
.48726 .19903 L
.49751 .19809 L
.50689 .19754 L
.51703 .19728 L
.52278 .19728 L
.52809 .19738 L
.53693 .19775 L
.54669 .19845 L
.55687 .19953 L
.56641 .20085 L
.58812 .20502 L
.60781 .21024 L
.62906 .21747 L
.6509 .22678 L
.68712 .24691 L
.7177 .26939 L
.74959 .29992 L
.77576 .3328 L
.79613 .36633 L
.81128 .39945 L
.81774 .41748 L
.82363 .43777 L
.8261 .44815 L
.82839 .45941 L
.83017 .46998 L
.83153 .47998 L
.83216 .48559 L
.83273 .49167 L
.83346 .5023 L
.83373 .50837 L
.83389 .51477 L
.83386 .52625 L
.83349 .53691 L
.83283 .54685 L
.83177 .55775 L
.83024 .5694 L
.82813 .58194 L
.82529 .59549 L
.8187 .61985 L
.81053 .64314 L
.80146 .66415 L
.78113 .70116 L
.75346 .73901 L
Mistroke
.71912 .77444 L
.68241 .80316 L
.64236 .82674 L
.61992 .83709 L
.59515 .84642 L
.57071 .85366 L
.54805 .85873 L
.53698 .86066 L
.52491 .86236 L
.51345 .8636 L
.50286 .86442 L
.49255 .86491 L
.48147 .86512 L
.471 .86501 L
.46143 .86465 L
.45022 .8639 L
.43803 .86269 L
.42654 .86118 L
.41594 .85946 L
.39497 .8551 L
.37208 .84886 L
.32694 .83172 L
.28406 .8087 L
.24222 .77844 L
.20984 .74809 L
.17852 .71056 L
.15018 .6656 L
.13725 .63921 L
.12687 .61335 L
.11886 .58854 L
.11204 .56101 L
.10966 .54868 L
.10757 .53552 L
.10613 .52422 L
.10493 .51172 L
.10408 .49824 L
.10371 .48571 L
.10375 .47192 L
.10399 .46421 L
.10433 .45722 L
.10528 .44437 L
.106 .43714 L
.10678 .43051 L
.11074 .40548 L
.11565 .38321 L
.12251 .35906 L
.14095 .31167 L
.16797 .26258 L
.20435 .21433 L
.24514 .17389 L
Mistroke
.28714 .14211 L
.33321 .1157 L
.35988 .10372 L
.38568 .09417 L
.41001 .08687 L
.43271 .08146 L
.45829 .07692 L
.47185 .07516 L
.48619 .07378 L
.50086 .07288 L
.51422 .07249 L
.52163 .07246 L
.52967 .07257 L
.54425 .07315 L
.55793 .07415 L
.57238 .07568 L
.58469 .07738 L
.59818 .07967 L
.62831 .08638 L
.66014 .09599 L
.71566 .11953 L
.76797 .15088 L
.81238 .18636 L
.85568 .23178 L
.89447 .28666 L
.9095 .31381 L
.92362 .34431 L
.93419 .37209 L
.94334 .40216 L
.94984 .42994 L
.95257 .44483 L
.95495 .46087 L
.95663 .47573 L
.95774 .48932 L
.95845 .50302 L
.95875 .516 L
.95865 .52992 L
.95808 .5449 L
.95709 .55904 L
.9558 .57196 L
.95383 .58702 L
.95112 .6034 L
.94465 .63301 L
.93584 .66342 L
.92416 .69519 L
.89733 .75014 L
.86314 .80171 L
.82479 .84604 L
.78573 .8817 L
.73907 .9153 L
Mistroke
.68623 .94423 L
.63371 .96518 L
.60247 .97441 L
.57341 .981 L
.55717 .98388 L
.53936 .98639 L
.52245 .98815 L
.50673 .98926 L
.49168 .98985 L
.47543 .98996 L
.46007 .98958 L
.44598 .9888 L
.43037 .98746 L
.41334 .98542 L
.39562 .98266 L
.3792 .97951 L
.34547 .9712 L
.31531 .96158 L
.25 .93301 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.49941 .50019 L
.49887 .50034 L
.49823 .50046 L
.49762 .50055 L
.49705 .50059 L
.49652 .5006 L
.49594 .50058 L
.49532 .50053 L
.49469 .50043 L
.49403 .50029 L
.4934 .50011 L
.49283 .49992 L
.49147 .49931 L
.49023 .49855 L
.48912 .49768 L
.48802 .49659 L
.48715 .49553 L
.48631 .49425 L
.48546 .49259 L
.48513 .49178 L
.48482 .49089 L
.48459 .49006 L
.48437 .48912 L
.48422 .48824 L
.48411 .4874 L
.48406 .4869 L
.48403 .48637 L
.484 .4854 L
.48401 .48486 L
.48402 .48435 L
.48406 .48378 L
.48412 .48316 L
.48425 .4821 L
.48446 .48097 L
.48498 .47894 L
.48568 .47696 L
.4865 .47513 L
.48899 .47107 L
.49076 .46889 L
.49268 .46694 L
.49688 .46364 L
.49957 .46203 L
.50224 .46073 L
.50538 .45953 L
.50704 .45902 L
.50891 .45854 L
.5105 .45821 L
.51202 .45795 L
.51349 .45776 L
Mistroke
.51508 .45761 L
.51667 .45752 L
.51818 .45749 L
.51955 .45751 L
.52105 .45758 L
.52272 .45771 L
.52367 .45782 L
.52456 .45794 L
.52652 .45826 L
.52831 .45863 L
.53157 .45948 L
.53506 .46068 L
.54125 .46355 L
.54774 .46774 L
.55348 .47269 L
.55832 .47809 L
.56293 .48482 L
.56504 .48868 L
.56699 .49296 L
.56848 .49691 L
.56983 .5014 L
.5708 .50562 L
.57147 .50965 L
.57176 .51219 L
.57189 .51364 L
.57198 .51498 L
.57209 .51747 L
.5721 .52012 L
.57203 .52252 L
.5719 .52478 L
.57167 .52726 L
.57132 .52994 L
.57085 .53279 L
.5702 .53591 L
.56867 .54156 L
.56675 .54703 L
.56458 .55204 L
.55946 .56125 L
.55247 .57063 L
.54453 .57874 L
.53616 .58538 L
.5258 .59168 L
.51329 .59708 L
.50658 .59916 L
.50279 .6001 L
.49916 .60086 L
.49572 .60144 L
.49195 .60194 L
.48849 .60228 L
.48527 .60248 L
Mistroke
.48178 .60259 L
.47845 .60257 L
.47544 .60247 L
.47215 .60226 L
.46858 .60191 L
.46476 .6014 L
.45788 .60012 L
.45093 .59834 L
.44444 .59622 L
.43254 .59112 L
.41889 .58305 L
.40719 .57381 L
.39559 .56178 L
.38508 .54711 L
.37739 .53236 L
.37205 .51786 L
.36984 .50947 L
.3689 .50496 L
.36807 .50011 L
.3675 .49584 L
.36725 .49356 L
.36702 .49109 L
.36674 .48673 L
.36661 .48261 L
.3666 .47846 L
.36671 .47459 L
.36696 .47032 L
.36738 .46576 L
.36799 .46096 L
.36872 .45642 L
.37052 .44796 L
.3727 .44008 L
.37514 .43289 L
.38214 .417 L
.39144 .40147 L
.40372 .38596 L
.41735 .37275 L
.43139 .36212 L
.44954 .35168 L
.46052 .34683 L
.47109 .34307 L
.48158 .34014 L
.49131 .33811 L
.49678 .33723 L
.50275 .33649 L
.50843 .336 L
.51368 .33572 L
.51926 .33561 L
.52455 .33568 L
.52932 .33589 L
Mistroke
.5345 .33627 L
.54014 .33687 L
.54613 .33772 L
.55684 .33981 L
.56665 .34236 L
.57574 .34529 L
.59595 .35394 L
.61684 .36639 L
.63453 .38042 L
.6528 .39953 L
.66764 .42031 L
.67921 .44236 L
.68718 .46382 L
.69049 .47621 L
.6919 .48284 L
.69314 .48992 L
.69402 .49618 L
.69439 .49952 L
.69474 .50311 L
.69518 .50945 L
.6954 .5154 L
.69544 .5218 L
.69529 .52773 L
.69492 .53426 L
.69465 .53755 L
.69428 .5412 L
.69352 .54727 L
.69249 .55381 L
.69005 .56561 L
.68695 .57711 L
.68293 .58907 L
.67383 .60991 L
.65988 .63349 L
.64441 .65339 L
.62347 .67408 L
.60095 .69098 L
.57803 .70401 L
.55539 .71358 L
.54308 .71758 L
.52921 .72116 L
.52212 .72263 L
.51443 .72395 L
.50721 .72494 L
.50037 .72566 L
.49654 .72597 L
.4924 .72623 L
.48514 .72651 L
.48101 .72656 L
.47664 .72654 L
.46881 .72628 L
Mistroke
.46154 .7258 L
.45476 .72514 L
.44733 .72418 L
.43938 .72288 L
.4216 .71892 L
.405 .71386 L
.37485 .701 L
.3478 .68479 L
.32467 .66655 L
.30183 .6432 L
.28102 .61498 L
.26561 .58667 L
.25472 .55891 L
.25032 .54378 L
.24658 .52688 L
.24513 .51822 L
.2439 .50891 L
.24306 .50006 L
.24256 .49199 L
.24232 .48419 L
.24232 .47592 L
.24254 .46884 L
.243 .46106 L
.24375 .45269 L
.24487 .44372 L
.24768 .42758 L
.25155 .41145 L
.25618 .39634 L
.26733 .3687 L
.2829 .3402 L
.30418 .3109 L
.33064 .28335 L
.35906 .26084 L
.3882 .24326 L
.41689 .23026 L
.43256 .22473 L
.45012 .21971 L
.45913 .21761 L
.46885 .21568 L
.47798 .21418 L
.48659 .21305 L
.49588 .21212 L
.50083 .21175 L
.50617 .21145 L
.51176 .21124 L
.51708 .21114 L
.52709 .21121 L
.53643 .2116 L
.54509 .21222 L
.5546 .21321 L
Mistroke
.56471 .21461 L
.5757 .21655 L
.58752 .21912 L
.60872 .22503 L
.62897 .23232 L
.64718 .24036 L
.67944 .25845 L
.71225 .28293 L
.74292 .31325 L
.76763 .34549 L
.78809 .3811 L
.79757 .40246 L
.80492 .4229 L
.81019 .44117 L
.81472 .46175 L
.81649 .47222 L
.818 .4836 L
.81905 .49441 L
.81969 .50436 L
.82 .51351 L
.82004 .5233 L
.81981 .53256 L
.81937 .54098 L
.81856 .55088 L
.81734 .5616 L
.8142 .58098 L
.80963 .60114 L
.80338 .6222 L
.78859 .65893 L
.7676 .69658 L
.74411 .72856 L
.71226 .76194 L
.67778 .78951 L
.64284 .81088 L
.60813 .82692 L
.58768 .83428 L
.56799 .84004 L
.55691 .84273 L
.54483 .84523 L
.53392 .8471 L
.52352 .84856 L
.51206 .8498 L
.50157 .8506 L
.49024 .85111 L
.48383 .85124 L
.4779 .85125 L
.46802 .85105 L
.45712 .8505 L
.44574 .84957 L
.43509 .84836 L
Mistroke
.4226 .84653 L
.41077 .84437 L
.38871 .83921 L
.3653 .83208 L
.34026 .82245 L
.2954 .79939 L
.25125 .7679 L
.21402 .7322 L
.18467 .69531 L
.15993 .65437 L
.14863 .63062 L
.13958 .60769 L
.13254 .58594 L
.12727 .56568 L
.12273 .54282 L
.12082 .53009 L
.11942 .51795 L
.11841 .50598 L
.11775 .49271 L
.11758 .48602 L
.11754 .47881 L
.11781 .46572 L
.11847 .45339 L
.1196 .44041 L
.12092 .42935 L
.12273 .41727 L
.12825 .39007 L
.13633 .3614 L
.14598 .33489 L
.15645 .31137 L
.18122 .26764 L
.21355 .22489 L
.24571 .19192 L
.28549 .16002 L
.33265 .13151 L
.36085 .11834 L
.38754 .10818 L
.41298 .10044 L
.42664 .09701 L
.44134 .09387 L
.45558 .09137 L
.46857 .08953 L
.48171 .08809 L
.49413 .08713 L
.50683 .08653 L
.52047 .08633 L
.53336 .08655 L
.54511 .0871 L
.55889 .08817 L
.56667 .08898 L
Mistroke
.57385 .08986 L
.60091 .09432 L
.62656 .10026 L
.65444 .1087 L
.70901 .13171 L
.75341 .15772 L
.79759 .19174 L
.83512 .2291 L
.86539 .26736 L
.89385 .31378 L
.907 .34081 L
.91771 .36716 L
.92615 .39241 L
.93358 .42036 L
.93627 .43287 L
.93873 .4462 L
.94063 .45855 L
.94212 .47031 L
.94354 .4853 L
.9444 .49904 L
.94485 .51387 L
.94488 .52227 L
.94477 .53006 L
.94422 .54434 L
.94332 .55725 L
.94181 .57214 L
.93994 .5861 L
.93402 .61779 L
.92656 .64653 L
.91618 .67753 L
.9028 .70941 L
.87401 .76191 L
.84185 .80627 L
.7982 .85252 L
.75117 .89053 L
.70335 .9201 L
.65609 .94221 L
.6282 .95239 L
.60147 .96033 L
.57306 .96692 L
.55774 .96973 L
.54128 .97216 L
.53265 .9732 L
.52449 .97404 L
.50918 .97522 L
.49479 .97588 L
.47918 .97611 L
.47094 .97602 L
.4619 .97576 L
.45246 .97531 L
Mistroke
.44365 .97471 L
.42789 .97324 L
.41104 .97108 L
.39517 .96849 L
.37799 .96506 L
.34705 .95721 L
.29053 .93698 L
.23714 .91001 L
.18423 .87421 L
.14289 .83822 L
.10203 .7932 L
.06318 .73716 L
.03015 .67101 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.49892 .49953 L
.49783 .49889 L
.49687 .49816 L
.49607 .49739 L
.49524 .49638 L
.49446 .49515 L
.49387 .49387 L
.49345 .49261 L
.49329 .49196 L
.49316 .49124 L
.49307 .49054 L
.49302 .4899 L
.493 .48913 L
.49301 .48869 L
.49303 .48828 L
.4931 .48752 L
.49322 .4867 L
.4934 .48584 L
.49364 .48491 L
.49425 .48322 L
.49503 .4816 L
.49593 .48013 L
.49704 .47864 L
.49842 .47712 L
.50141 .47463 L
.50353 .47331 L
.50573 .47223 L
.50786 .47142 L
.5091 .47103 L
.51031 .47072 L
.51161 .47045 L
.51282 .47024 L
.51421 .47008 L
.51494 .47001 L
.51573 .46997 L
.51645 .46994 L
.51723 .46993 L
.51796 .46994 L
.51864 .46996 L
.51944 .47 L
.52032 .47007 L
.52115 .47016 L
.52192 .47026 L
.52458 .47075 L
.5261 .47112 L
.52752 .47153 L
.53062 .47265 L
.53347 .47397 L
.53885 .47726 L
Mistroke
.54434 .48196 L
.54869 .48704 L
.55068 .48996 L
.55264 .49335 L
.55434 .49691 L
.55569 .50037 L
.55676 .50382 L
.55766 .5076 L
.55798 .50928 L
.55825 .51111 L
.55846 .51285 L
.55861 .51446 L
.55873 .51637 L
.55878 .51847 L
.55876 .52046 L
.55868 .52232 L
.55853 .52438 L
.5583 .52656 L
.55803 .52843 L
.55767 .53048 L
.55661 .53507 L
.5553 .53933 L
.5521 .54698 L
.54753 .55488 L
.54056 .56371 L
.53253 .5712 L
.52419 .57704 L
.51945 .57971 L
.51409 .58223 L
.50863 .58434 L
.50346 .58594 L
.49809 .58722 L
.49287 .58812 L
.48988 .58849 L
.48823 .58865 L
.48666 .58878 L
.48389 .58892 L
.48081 .58899 L
.47917 .58897 L
.47744 .58893 L
.47434 .58877 L
.4726 .58863 L
.47098 .58847 L
.46729 .588 L
.464 .58745 L
.46042 .58672 L
.45395 .58501 L
.44769 .58288 L
.44199 .58051 L
.42945 .57367 L
Mistroke
.41705 .56428 L
.4072 .55431 L
.39925 .54387 L
.39537 .53762 L
.39158 .53043 L
.38842 .52324 L
.38598 .51646 L
.38406 .50989 L
.38241 .5026 L
.3817 .49851 L
.38118 .49471 L
.38079 .49105 L
.3805 .48715 L
.38036 .48377 L
.38031 .48013 L
.38037 .47668 L
.3805 .47353 L
.38077 .46982 L
.3812 .46577 L
.38172 .46195 L
.38232 .45842 L
.38404 .45049 L
.3861 .44327 L
.39237 .42732 L
.39978 .41381 L
.40941 .40043 L
.42207 .38696 L
.43564 .37591 L
.45233 .36569 L
.46238 .36095 L
.47191 .3573 L
.48124 .35445 L
.4902 .35234 L
.49516 .35142 L
.49974 .35073 L
.50488 .35013 L
.50772 .34987 L
.51043 .34968 L
.51488 .34947 L
.51963 .34939 L
.52414 .34945 L
.52823 .34963 L
.53307 .34998 L
.5383 .35053 L
.54324 .35122 L
.54778 .352 L
.55792 .35426 L
.56729 .35698 L
.57827 .36102 L
.58807 .36542 L
Mistroke
.60729 .37657 L
.62627 .39156 L
.64114 .4071 L
.6548 .4258 L
.66448 .44336 L
.67281 .46415 L
.67632 .47635 L
.67878 .48779 L
.67982 .4942 L
.68028 .49762 L
.68069 .50127 L
.68102 .50479 L
.68126 .508 L
.68156 .51429 L
.68164 .52056 L
.68152 .52635 L
.68118 .53272 L
.68092 .53593 L
.68057 .53946 L
.67983 .54539 L
.67882 .55175 L
.67643 .56317 L
.67299 .57547 L
.6684 .58835 L
.65774 .61075 L
.64292 .63338 L
.62278 .65603 L
.60256 .67306 L
.5781 .68844 L
.56605 .69437 L
.55289 .69977 L
.54125 .7037 L
.52831 .70718 L
.52105 .70875 L
.51429 .70997 L
.50791 .71091 L
.50083 .71173 L
.49445 .71225 L
.48845 .71257 L
.48209 .71272 L
.47523 .71267 L
.46781 .71237 L
.46361 .71209 L
.45971 .71175 L
.45257 .71094 L
.44498 .70981 L
.43054 .7069 L
.41759 .7034 L
.39268 .69417 L
.36695 .68074 L
Mistroke
.3442 .66491 L
.32496 .64781 L
.30591 .62632 L
.28847 .60058 L
.27516 .57406 L
.26594 .54835 L
.26176 .5321 L
.25891 .51676 L
.25781 .50865 L
.25692 .49966 L
.25659 .49511 L
.25634 .4902 L
.25619 .48555 L
.25614 .48129 L
.25623 .47342 L
.25654 .4661 L
.25714 .45806 L
.25807 .44948 L
.25937 .44047 L
.26092 .43199 L
.2646 .41624 L
.26921 .40102 L
.27442 .38702 L
.28941 .35626 L
.30807 .32822 L
.33226 .30085 L
.35825 .27849 L
.38567 .26044 L
.41225 .24713 L
.44296 .23602 L
.45907 .23181 L
.46766 .23 L
.4768 .22838 L
.48488 .22722 L
.49378 .22622 L
.50192 .22556 L
.50954 .22517 L
.51424 .22503 L
.51935 .22498 L
.52866 .22512 L
.53773 .22556 L
.5461 .22623 L
.55514 .22724 L
.56508 .22871 L
.58506 .23277 L
.60459 .23825 L
.62215 .24452 L
.6602 .26293 L
.69299 .28507 L
.72131 .31034 L
Mistroke
.74668 .33986 L
.76627 .36957 L
.7756 .38712 L
.78439 .40684 L
.79084 .42443 L
.79667 .44425 L
.80087 .46306 L
.80371 .48089 L
.80482 .49084 L
.80555 .49995 L
.80606 .51052 L
.8062 .52055 L
.80606 .52919 L
.80564 .53837 L
.80507 .54621 L
.8042 .55485 L
.803 .5641 L
.80139 .57404 L
.79764 .59192 L
.79241 .61101 L
.78547 .63107 L
.76949 .66605 L
.74492 .70504 L
.71768 .73732 L
.68466 .76717 L
.64426 .79428 L
.62434 .8047 L
.60244 .81426 L
.58306 .82121 L
.56141 .82741 L
.55013 .83002 L
.53958 .8321 L
.52856 .83389 L
.51853 .8352 L
.50859 .83619 L
.49919 .83685 L
.48925 .83727 L
.47847 .83739 L
.4675 .83715 L
.46127 .83686 L
.45547 .83649 L
.44375 .83543 L
.43122 .83384 L
.40865 .82976 L
.38831 .82472 L
.34949 .81129 L
.32826 .80164 L
.3092 .79143 L
.2734 .76776 L
.2432 .74222 L
Mistroke
.21351 .71041 L
.18599 .6721 L
.16506 .63337 L
.1496 .59415 L
.14293 .57136 L
.1399 .55865 L
.13746 .54654 L
.13555 .53515 L
.13388 .52273 L
.13274 .51139 L
.13199 .5009 L
.1315 .48836 L
.13143 .47661 L
.13177 .46371 L
.13217 .45647 L
.13265 .44986 L
.13398 .4366 L
.13598 .42219 L
.14106 .39616 L
.14696 .3739 L
.15488 .35027 L
.17323 .30883 L
.20151 .26253 L
.23326 .22372 L
.26944 .18968 L
.31401 .15789 L
.33823 .14424 L
.36521 .13155 L
.38916 .1223 L
.41625 .11392 L
.44255 .10777 L
.45714 .10517 L
.4709 .10322 L
.48383 .10183 L
.4957 .10093 L
.50945 .10034 L
.52255 .10021 L
.52995 .10033 L
.53666 .10055 L
.54441 .10095 L
.5517 .10147 L
.56468 .10271 L
.57868 .10454 L
.59411 .10713 L
.61031 .11052 L
.63899 .11826 L
.68893 .13741 L
.73316 .16118 L
.77821 .19346 L
.82149 .23468 L
Mistroke
.85766 .28058 L
.88529 .32742 L
.90852 .3828 L
.91725 .41202 L
.92107 .428 L
.92444 .44499 L
.92667 .45891 L
.92859 .47423 L
.92985 .48824 L
.93061 .50131 L
.93088 .5093 L
.931 .51684 L
.93087 .53098 L
.93059 .5389 L
.93021 .54621 L
.92965 .55422 L
.92889 .56269 L
.92737 .57586 L
.92529 .58996 L
.92036 .61526 L
.91254 .645 L
.90355 .67169 L
.88086 .72246 L
.84971 .77316 L
.81411 .81701 L
.77714 .8527 L
.72825 .88927 L
.70056 .90582 L
.67008 .92112 L
.64234 .93267 L
.61107 .94322 L
.58195 .95084 L
.55434 .95622 L
.53908 .95845 L
.53069 .95945 L
.52281 .96026 L
.50886 .96134 L
.49343 .96204 L
.48483 .96221 L
.47665 .96222 L
.46128 .96185 L
.45269 .96142 L
.44473 .96088 L
.42668 .95914 L
.41089 .95703 L
.39606 .95455 L
.36854 .94861 L
.33929 .94036 L
.30822 .92927 L
.25527 .90434 L
Mistroke
.20286 .8709 L
.1617 .83695 L
.12101 .79442 L
.08359 .74377 L
.05437 .69138 L
.03375 .64135 L
.02458 .61205 L
.01772 .58441 L
.01483 .57006 L
.01219 .55447 L
.01031 .54091 L
.00869 .52602 L
.00742 .50943 L
.00696 .50036 L
.00668 .4919 L
.00656 .47672 L
.00693 .46048 L
.00792 .44327 L
.00874 .43358 L
.00967 .42464 L
.01179 .40826 L
.01464 .39098 L
.02103 .36125 L
.03015 .32899 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.49947 .49895 L
.49924 .49834 L
.49905 .49775 L
.49891 .4972 L
.49879 .49658 L
.49871 .49601 L
.49867 .49548 L
.49865 .49485 L
.49867 .49425 L
.49873 .49359 L
.49884 .49288 L
.49892 .49252 L
.49901 .49213 L
.49922 .49143 L
.49973 .49013 L
.50047 .48877 L
.5013 .48758 L
.50244 .48629 L
.50369 .48518 L
.5049 .48431 L
.50631 .48349 L
.50799 .48272 L
.50965 .48216 L
.51064 .48191 L
.5116 .48171 L
.51249 .48157 L
.51347 .48146 L
.51398 .48142 L
.51456 .48139 L
.51517 .48138 L
.51574 .48138 L
.51678 .48142 L
.51737 .48147 L
.51792 .48152 L
.51892 .48166 L
.51986 .48182 L
.52201 .48234 L
.52412 .48305 L
.52637 .48402 L
.52883 .48537 L
.53143 .48716 L
.53363 .489 L
.53584 .49123 L
.5377 .49348 L
.53958 .4962 L
.54238 .50157 L
.54348 .50449 L
.54399 .50609 L
.54445 .50784 L
Mistroke
.54484 .50957 L
.54513 .51116 L
.54537 .51279 L
.54553 .51435 L
.54564 .5159 L
.54571 .51755 L
.54571 .51898 L
.54567 .52056 L
.54556 .52228 L
.54537 .52414 L
.54513 .5259 L
.54485 .52751 L
.54394 .53142 L
.5428 .53504 L
.54122 .53899 L
.53916 .54313 L
.53481 .54983 L
.52875 .55671 L
.52201 .56241 L
.51383 .56749 L
.50607 .57096 L
.50138 .57252 L
.49687 .57369 L
.49428 .57423 L
.49142 .5747 L
.48869 .57505 L
.48614 .57527 L
.48381 .57541 L
.48124 .57547 L
.47852 .57544 L
.47597 .57532 L
.47453 .57522 L
.47296 .57507 L
.4701 .57473 L
.46731 .57429 L
.46472 .57379 L
.45885 .57232 L
.45265 .57025 L
.44233 .56551 L
.43326 .55982 L
.42396 .55215 L
.41513 .54252 L
.40844 .53293 L
.40321 .5231 L
.39872 .51144 L
.39682 .50457 L
.39609 .50128 L
.3955 .49815 L
.39498 .4948 L
.3946 .49171 L
Mistroke
.39428 .48825 L
.39407 .48449 L
.39399 .48087 L
.39401 .47881 L
.39405 .47689 L
.39423 .47336 L
.39454 .4696 L
.39496 .4661 L
.39554 .46231 L
.39693 .45545 L
.39873 .4488 L
.40076 .44273 L
.40681 .42907 L
.41563 .41482 L
.42718 .40114 L
.43996 .3898 L
.45408 .38039 L
.46212 .37615 L
.47106 .37225 L
.47916 .36938 L
.48839 .36682 L
.49252 .3659 L
.49701 .36506 L
.50127 .3644 L
.50526 .36392 L
.50921 .36355 L
.51346 .36329 L
.5182 .36316 L
.52253 .36318 L
.52707 .36335 L
.52963 .36351 L
.532 .3637 L
.53636 .36416 L
.54097 .3648 L
.54909 .36631 L
.55664 .36816 L
.57358 .37398 L
.58277 .37817 L
.59108 .38265 L
.60896 .39489 L
.62336 .40795 L
.63692 .42403 L
.6482 .4418 L
.6529 .45114 L
.65668 .46004 L
.66236 .47746 L
.66457 .48694 L
.6663 .49713 L
.66695 .50252 L
.66722 .50538 L
Mistroke
.66746 .50843 L
.66774 .51404 L
.66784 .51924 L
.66778 .52425 L
.66759 .52895 L
.66723 .53412 L
.66666 .53969 L
.66585 .54557 L
.66474 .55199 L
.66207 .56362 L
.65868 .57482 L
.65483 .58507 L
.64522 .60484 L
.6343 .62183 L
.61921 .64001 L
.60273 .65541 L
.58402 .669 L
.56142 .6813 L
.54932 .68635 L
.5359 .69087 L
.52287 .69424 L
.51701 .69545 L
.51072 .69654 L
.50492 .69736 L
.49847 .69806 L
.49256 .69852 L
.48699 .69879 L
.48043 .69891 L
.47439 .69882 L
.46775 .69852 L
.46075 .69796 L
.45503 .69731 L
.44892 .69644 L
.43795 .6944 L
.42499 .69117 L
.41336 .68748 L
.38881 .67705 L
.3642 .66249 L
.3447 .64733 L
.32522 .62793 L
.30703 .60423 L
.29837 .59002 L
.29112 .57587 L
.28528 .56223 L
.27994 .54686 L
.27604 .53249 L
.27327 .51889 L
.27208 .5112 L
.27111 .50301 L
.27052 .49598 L
Mistroke
.27012 .48823 L
.27 .48384 L
.26998 .47984 L
.27003 .47521 L
.27017 .47083 L
.27061 .46302 L
.27099 .45862 L
.2714 .45454 L
.27341 .44046 L
.27495 .43248 L
.27664 .42502 L
.28085 .40996 L
.28639 .39436 L
.29897 .36751 L
.31348 .34423 L
.33212 .32097 L
.35581 .29813 L
.38406 .27754 L
.41342 .26176 L
.44163 .25091 L
.45815 .24626 L
.4737 .24295 L
.48187 .24161 L
.49071 .24046 L
.49911 .23965 L
.50681 .23915 L
.51587 .23886 L
.521 .23883 L
.52576 .23889 L
.5345 .23924 L
.53892 .23952 L
.5438 .23993 L
.55348 .241 L
.56234 .24229 L
.58221 .24634 L
.59952 .25118 L
.61746 .25756 L
.6497 .27289 L
.67729 .29057 L
.70649 .31515 L
.73095 .34215 L
.75042 .37002 L
.7654 .3979 L
.77824 .43047 L
.78321 .44755 L
.78557 .45746 L
.78746 .46675 L
.78912 .47661 L
.79032 .4856 L
.79134 .49566 L
Mistroke
.79175 .5012 L
.79203 .50644 L
.79232 .516 L
.7923 .52481 L
.79198 .5345 L
.79128 .54475 L
.79043 .55332 L
.78923 .56249 L
.78633 .57897 L
.78166 .59841 L
.77625 .61588 L
.76037 .65352 L
.74911 .67387 L
.73728 .69195 L
.71218 .72296 L
.68108 .75227 L
.64832 .77574 L
.6156 .79351 L
.57724 .80851 L
.55718 .81418 L
.5457 .81679 L
.53476 .81887 L
.52511 .82038 L
.51457 .82169 L
.50495 .82257 L
.49604 .82314 L
.48637 .82347 L
.4757 .8235 L
.46455 .82315 L
.45411 .82248 L
.44434 .82154 L
.43508 .82038 L
.41777 .81748 L
.39927 .81331 L
.37936 .80754 L
.33604 .79001 L
.29761 .76794 L
.26562 .74375 L
.23436 .71334 L
.2047 .67547 L
.19075 .653 L
.1793 .63106 L
.16289 .5902 L
.1563 .56769 L
.15353 .55604 L
.15092 .54307 L
.14905 .53169 L
.14746 .51936 L
.14676 .51252 L
.14624 .50625 L
Mistroke
.14554 .4939 L
.14529 .48265 L
.14541 .47034 L
.14592 .45869 L
.14674 .44788 L
.1474 .44135 L
.14824 .43429 L
.15014 .42151 L
.15493 .39777 L
.16256 .37044 L
.17151 .34577 L
.19086 .3053 L
.21786 .26368 L
.25204 .22424 L
.28897 .19187 L
.33014 .16445 L
.35335 .15217 L
.37899 .14089 L
.40203 .13261 L
.42813 .12518 L
.43974 .12251 L
.45236 .12004 L
.46429 .1181 L
.47546 .11664 L
.48645 .11552 L
.49824 .11468 L
.51137 .11416 L
.52334 .11409 L
.53586 .1144 L
.54292 .11476 L
.54943 .1152 L
.56139 .11631 L
.57404 .11788 L
.59619 .12167 L
.61676 .12638 L
.66263 .14126 L
.68729 .15196 L
.70954 .1634 L
.75724 .19455 L
.79548 .22764 L
.8315 .26816 L
.86149 .31265 L
.88427 .3581 L
.89985 .40129 L
.90649 .4264 L
.91121 .44988 L
.91332 .46358 L
.91489 .47662 L
.91595 .48839 L
.91672 .50122 L
Mistroke
.91711 .51522 L
.91713 .5223 L
.91702 .53011 L
.91645 .54391 L
.9155 .55686 L
.91423 .56914 L
.9125 .58203 L
.9084 .60495 L
.90257 .6294 L
.89451 .65576 L
.87197 .70941 L
.85615 .73807 L
.83986 .76306 L
.80612 .80519 L
.76301 .84648 L
.71784 .87947 L
.66555 .90793 L
.64094 .91835 L
.61379 .92787 L
.58775 .9352 L
.5632 .94057 L
.5482 .94315 L
.53212 .94533 L
.52288 .94631 L
.51417 .94706 L
.50634 .94759 L
.49786 .94801 L
.49027 .94824 L
.48195 .94835 L
.47326 .94831 L
.46515 .94811 L
.45062 .94739 L
.43509 .94609 L
.41993 .94431 L
.40352 .94178 L
.37393 .93565 L
.3455 .92777 L
.31968 .91884 L
.26847 .89569 L
.21672 .86379 L
.17188 .82746 L
.13493 .78935 L
.09741 .73958 L
.08028 .71127 L
.06423 .67974 L
.05104 .64831 L
.04105 .61898 L
.03294 .58881 L
.02711 .55987 L
.0249 .54542 L
Mistroke
.02301 .52983 L
.0217 .51504 L
.0209 .50151 L
.02045 .48561 L
.02043 .47661 L
.02057 .46828 L
.02119 .45299 L
.02238 .43676 L
.02403 .42136 L
.02636 .4048 L
.03205 .37501 L
.04125 .34004 L
.05198 .30857 L
.07456 .25799 L
.1058 .20573 L
.14525 .15549 L
.18773 .11348 L
.25 .06699 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.50013 .4994 L
.50027 .49885 L
.50071 .49767 L
.50126 .49662 L
.50188 .49568 L
.50275 .49467 L
.50367 .49382 L
.5048 .493 L
.50614 .49227 L
.50743 .49174 L
.50819 .49151 L
.50891 .49133 L
.5096 .4912 L
.51036 .4911 L
.5111 .49104 L
.5118 .49102 L
.51222 .49102 L
.51269 .49103 L
.51355 .4911 L
.51439 .49121 L
.51517 .49135 L
.51603 .49155 L
.51697 .49182 L
.51886 .49254 L
.52078 .49352 L
.52255 .49468 L
.52568 .49745 L
.52727 .49931 L
.52861 .50124 L
.53 .50372 L
.5311 .50625 L
.53182 .50839 L
.53243 .51082 L
.53268 .51218 L
.53279 .51294 L
.53288 .51365 L
.53301 .51492 L
.53309 .51634 L
.53311 .51707 L
.53311 .51786 L
.53307 .51932 L
.53297 .52075 L
.53282 .52209 L
.53261 .52355 L
.5323 .52516 L
.53145 .52844 L
.53042 .53139 L
.52901 .53458 L
.52566 .54026 L
Mistroke
.52142 .54548 L
.51667 .5499 L
.51004 .55448 L
.5032 .55784 L
.49911 .55932 L
.49687 .55998 L
.49446 .56059 L
.4923 .56104 L
.4899 .56144 L
.48767 .56173 L
.48557 .56192 L
.48334 .56205 L
.4822 .56208 L
.48094 .56209 L
.4787 .56205 L
.47658 .56194 L
.47536 .56184 L
.47407 .56172 L
.47177 .56142 L
.46928 .56101 L
.46655 .56044 L
.46195 .55922 L
.45707 .55753 L
.44844 .55348 L
.43978 .54785 L
.43218 .54128 L
.42597 .53439 L
.42006 .52593 L
.4174 .5212 L
.41485 .51587 L
.41293 .51106 L
.41116 .50563 L
.41025 .50224 L
.40952 .49904 L
.40894 .496 L
.40842 .4926 L
.40806 .48953 L
.40782 .48661 L
.40767 .48351 L
.40763 .48175 L
.40762 .48013 L
.40769 .477 L
.40788 .47364 L
.40817 .47045 L
.40853 .46754 L
.40907 .46411 L
.4098 .4604 L
.41152 .45367 L
.41387 .44667 L
.41696 .43936 L
Mistroke
.42404 .42671 L
.43256 .41548 L
.44181 .40607 L
.45408 .39651 L
.46717 .38894 L
.47341 .3861 L
.48029 .38346 L
.48642 .38152 L
.49322 .37978 L
.49747 .37891 L
.50143 .37825 L
.50525 .37773 L
.50933 .37732 L
.51301 .37706 L
.51647 .37692 L
.52028 .37688 L
.52439 .37697 L
.52848 .3772 L
.53081 .37739 L
.53301 .3776 L
.53742 .37816 L
.54219 .37894 L
.55076 .38082 L
.55857 .38308 L
.57618 .39025 L
.58473 .39487 L
.59376 .40068 L
.60816 .41234 L
.62191 .42709 L
.63302 .44299 L
.64129 .4589 L
.6479 .47689 L
.65036 .48637 L
.6515 .49192 L
.65236 .49704 L
.65296 .50146 L
.65347 .50632 L
.65383 .51148 L
.65402 .51641 L
.65405 .52103 L
.65393 .52596 L
.65367 .53063 L
.65331 .53486 L
.65268 .5403 L
.65181 .54604 L
.6497 .55628 L
.64666 .56721 L
.64241 .579 L
.63241 .59945 L
.62042 .61736 L
Mistroke
.60546 .63434 L
.58651 .65057 L
.5663 .66343 L
.55597 .6686 L
.54593 .67286 L
.52645 .67917 L
.51575 .68163 L
.50969 .68272 L
.50401 .68355 L
.49808 .68423 L
.49493 .6845 L
.49156 .68474 L
.48529 .68502 L
.47958 .68509 L
.47399 .68499 L
.46793 .68468 L
.4622 .68422 L
.45692 .68363 L
.45067 .68273 L
.44475 .68169 L
.43371 .67921 L
.42193 .67579 L
.40931 .67118 L
.38733 .66062 L
.36809 .64831 L
.34866 .63226 L
.32952 .61158 L
.31259 .58702 L
.30562 .57411 L
.29993 .56159 L
.2951 .5488 L
.29143 .53684 L
.28817 .52326 L
.28676 .51567 L
.28567 .50844 L
.28485 .50135 L
.28453 .49776 L
.28424 .49379 L
.28391 .48675 L
.28381 .48013 L
.28385 .47613 L
.28395 .47232 L
.28433 .46517 L
.28465 .46117 L
.285 .45747 L
.28605 .44907 L
.28713 .44236 L
.28853 .43514 L
.29169 .42212 L
.29974 .39824 L
Mistroke
.30555 .38502 L
.31262 .37144 L
.32765 .34824 L
.34726 .32504 L
.36787 .30612 L
.39455 .28734 L
.42228 .27297 L
.43537 .26769 L
.44965 .26292 L
.46227 .25951 L
.47611 .25659 L
.48394 .2553 L
.49116 .25435 L
.49811 .25363 L
.50545 .25309 L
.51356 .25275 L
.52113 .25268 L
.52945 .25286 L
.53412 .25309 L
.53835 .25337 L
.54624 .25408 L
.5536 .25498 L
.5703 .25785 L
.58642 .26174 L
.6035 .26711 L
.63349 .27995 L
.65949 .29506 L
.68752 .3165 L
.71473 .34421 L
.73665 .37411 L
.75322 .40457 L
.76531 .4355 L
.77045 .45361 L
.77408 .47058 L
.77638 .48574 L
.77732 .49441 L
.77795 .50252 L
.77835 .51114 L
.77849 .519 L
.77836 .5281 L
.77798 .53671 L
.77731 .5455 L
.77625 .55516 L
.77478 .56523 L
.77307 .57464 L
.76921 .59133 L
.76393 .60907 L
.75626 .6294 L
.74752 .64823 L
.7274 .68189 L
Mistroke
.70316 .7123 L
.67764 .73706 L
.64444 .7618 L
.61 .78083 L
.5936 .78795 L
.57577 .79442 L
.56001 .79913 L
.54279 .80323 L
.53298 .80511 L
.52396 .80654 L
.51474 .80772 L
.50617 .80857 L
.49614 .80925 L
.49084 .80948 L
.4852 .80962 L
.47571 .80963 L
.46523 .80931 L
.45522 .80866 L
.44592 .80777 L
.43572 .80647 L
.42486 .80471 L
.40282 .79991 L
.38305 .79416 L
.3459 .77938 L
.31255 .7611 L
.27666 .73493 L
.24681 .70642 L
.21828 .67076 L
.20485 .6497 L
.19358 .62873 L
.18499 .60981 L
.17696 .58854 L
.17085 .56847 L
.1664 .54994 L
.16432 .5392 L
.16246 .52751 L
.16161 .52104 L
.16094 .51508 L
.15993 .50331 L
.15939 .49313 L
.15915 .48195 L
.15929 .47025 L
.15978 .45933 L
.16056 .44901 L
.16177 .43783 L
.16325 .42729 L
.16491 .41758 L
.16882 .3993 L
.17406 .38012 L
.18847 .34124 L
Mistroke
.20973 .30043 L
.23767 .26084 L
.26928 .22682 L
.30143 .19984 L
.34014 .17472 L
.38561 .15319 L
.41235 .1439 L
.43727 .13726 L
.46104 .13263 L
.47459 .13071 L
.48714 .12939 L
.49819 .12857 L
.51037 .12806 L
.52313 .12796 L
.53506 .12825 L
.54746 .12896 L
.55373 .12948 L
.56064 .13018 L
.58423 .13353 L
.59741 .13608 L
.61154 .13936 L
.63683 .14669 L
.68484 .16617 L
.72646 .1898 L
.76176 .21586 L
.79693 .24899 L
.82916 .28822 L
.8545 .32848 L
.87663 .37619 L
.8863 .40442 L
.89335 .43114 L
.89799 .45494 L
.89999 .46862 L
.90143 .48149 L
.90251 .49511 L
.90308 .50761 L
.90323 .51453 L
.90326 .52208 L
.90295 .53584 L
.90219 .54931 L
.90107 .56198 L
.89972 .57334 L
.89789 .58559 L
.89242 .61294 L
.88573 .63779 L
.86946 .68208 L
.84675 .72673 L
.81613 .7718 L
.7831 .80927 L
.73948 .8475 L
Mistroke
.69341 .87801 L
.6474 .90077 L
.60246 .91683 L
.57827 .92321 L
.55114 .92863 L
.53735 .93069 L
.52241 .93242 L
.50823 .93357 L
.4952 .93422 L
.4805 .93448 L
.46661 .93427 L
.45414 .93371 L
.44063 .93269 L
.42592 .93109 L
.41039 .92886 L
.38274 .92347 L
.35747 .91689 L
.33418 .90938 L
.28277 .88745 L
.22997 .85614 L
.18567 .82124 L
.14021 .77413 L
.10359 .72348 L
.07493 .66978 L
.05527 .61799 L
.04706 .58822 L
.04354 .57233 L
.04044 .55543 L
.03823 .54049 L
.03726 .53255 L
.03637 .52403 L
.03519 .50898 L
.03453 .49492 L
.0343 .47973 L
.03452 .46568 L
.03526 .45026 L
.03582 .44248 L
.03659 .43392 L
.03824 .41961 L
.04051 .40425 L
.0459 .37665 L
.05324 .34838 L
.06185 .32191 L
.08225 .2736 L
.11373 .21879 L
.14851 .17284 L
.19542 .1252 L
.24555 .08646 L
.29649 .0565 L
.34649 .03447 L
Mistroke
.37364 .02517 L
.4041 .0168 L
.41966 .01331 L
.43649 .01014 L
.45237 .00769 L
.46715 .00588 L
.48133 .00457 L
.49646 .00363 L
.51168 .00314 L
.52851 .00315 L
.543 .00361 L
.55862 .00459 L
.57335 .00595 L
.58682 .0076 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.50095 .4993 L
.50205 .49867 L
.50261 .49842 L
.50316 .49821 L
.50366 .49805 L
.50422 .4979 L
.50485 .49778 L
.50553 .49768 L
.50618 .49764 L
.50678 .49762 L
.50751 .49765 L
.50817 .49772 L
.50854 .49778 L
.50894 .49785 L
.50967 .49802 L
.51043 .49825 L
.51115 .49851 L
.51246 .49912 L
.51382 .49996 L
.51524 .50106 L
.51639 .5022 L
.51752 .50357 L
.51846 .50496 L
.51924 .50641 L
.52003 .50825 L
.5206 .51004 L
.52085 .51109 L
.52104 .51209 L
.5212 .51322 L
.52126 .51379 L
.52131 .51444 L
.52135 .51552 L
.52135 .51654 L
.52129 .51766 L
.52125 .51823 L
.52118 .51886 L
.52103 .51994 L
.52083 .52109 L
.52031 .52319 L
.51941 .52585 L
.5181 .52872 L
.51667 .53121 L
.51486 .53377 L
.51062 .53832 L
.50581 .542 L
.50309 .54362 L
.50033 .54499 L
.49768 .54608 L
.49473 .54706 L
Mistroke
.49299 .54754 L
.49138 .54791 L
.48972 .54823 L
.48816 .54848 L
.4863 .5487 L
.48532 .54879 L
.48427 .54887 L
.48248 .54894 L
.48146 .54895 L
.4805 .54894 L
.4788 .54888 L
.47694 .54875 L
.47516 .54856 L
.47352 .54833 L
.47038 .54774 L
.46704 .5469 L
.46347 .54575 L
.46014 .54442 L
.45269 .54053 L
.44597 .53572 L
.4392 .52924 L
.43298 .52121 L
.43039 .51694 L
.4282 .51268 L
.4264 .50852 L
.42472 .50383 L
.42356 .49979 L
.42253 .49522 L
.42208 .4926 L
.42173 .49013 L
.42146 .48748 L
.42134 .48599 L
.42126 .48461 L
.42118 .48215 L
.42117 .47945 L
.42125 .47688 L
.4214 .47449 L
.42165 .47186 L
.42201 .46907 L
.42289 .46409 L
.4242 .45872 L
.42607 .45287 L
.43054 .44256 L
.436 .43333 L
.44414 .42297 L
.45299 .41442 L
.46478 .40585 L
.4711 .40226 L
.47732 .39929 L
.48949 .39487 L
Mistroke
.49626 .39312 L
.50012 .39234 L
.50374 .39174 L
.50755 .39124 L
.50975 .39102 L
.51175 .39086 L
.51549 .39065 L
.51755 .3906 L
.5195 .39058 L
.52317 .39064 L
.52656 .3908 L
.5303 .3911 L
.53425 .39156 L
.54089 .39264 L
.54798 .39426 L
.55464 .39623 L
.56065 .39838 L
.575 .40511 L
.5879 .41338 L
.59964 .42317 L
.6113 .43582 L
.62173 .4509 L
.62583 .45837 L
.62963 .46658 L
.6325 .47397 L
.63515 .48231 L
.6371 .49009 L
.6385 .49747 L
.63917 .50204 L
.63965 .50638 L
.63997 .51031 L
.64019 .51459 L
.64029 .51929 L
.64021 .52428 L
.64001 .52856 L
.63963 .53327 L
.63907 .53821 L
.63839 .54279 L
.6363 .55313 L
.6338 .56217 L
.63049 .57169 L
.62228 .58935 L
.61276 .60453 L
.5992 .62102 L
.58183 .63681 L
.56312 .6494 L
.55341 .65455 L
.54422 .65868 L
.53492 .6622 L
.52453 .6654 L
Mistroke
.5187 .66687 L
.51326 .66805 L
.50766 .66906 L
.50237 .66985 L
.49782 .67038 L
.4929 .67082 L
.4874 .67114 L
.48235 .67127 L
.47709 .67126 L
.47133 .67106 L
.46587 .67069 L
.46081 .67019 L
.45483 .6694 L
.44836 .66832 L
.4367 .66572 L
.42546 .66241 L
.41526 .65869 L
.39279 .64784 L
.37058 .63289 L
.35232 .6165 L
.33749 .59934 L
.32288 .5772 L
.31718 .56629 L
.31186 .55423 L
.30795 .54365 L
.30434 .53164 L
.30171 .52048 L
.29983 .50981 L
.29901 .50365 L
.29835 .49712 L
.29795 .49151 L
.2977 .48535 L
.29764 .47867 L
.29771 .47491 L
.29782 .4715 L
.29822 .46485 L
.29879 .45857 L
.29956 .45233 L
.30059 .44564 L
.30303 .4336 L
.30689 .41941 L
.3113 .40664 L
.3238 .37979 L
.33924 .35584 L
.3562 .33571 L
.37421 .31882 L
.39624 .30259 L
.42201 .28829 L
.4364 .2821 L
.45211 .27664 L
Mistroke
.46588 .27288 L
.48131 .26973 L
.49014 .26842 L
.49825 .26752 L
.50275 .26714 L
.50766 .26683 L
.51232 .26664 L
.51663 .26654 L
.52432 .26656 L
.52871 .26669 L
.53283 .26688 L
.53716 .26716 L
.54112 .26749 L
.55005 .26847 L
.55738 .26954 L
.56517 .27094 L
.57913 .27412 L
.59552 .279 L
.61015 .28448 L
.64085 .29974 L
.66786 .31816 L
.69067 .33846 L
.71288 .36406 L
.73237 .39406 L
.74023 .40948 L
.74674 .42464 L
.75188 .439 L
.75652 .45503 L
.75986 .4699 L
.76217 .48388 L
.76313 .49172 L
.76382 .49912 L
.76434 .50727 L
.76461 .51611 L
.76459 .52489 L
.76425 .53417 L
.7637 .54209 L
.76283 .55077 L
.76158 .56 L
.76014 .56851 L
.75587 .58761 L
.75093 .60424 L
.74452 .62156 L
.73059 .65057 L
.71126 .68065 L
.68633 .70994 L
.65497 .73756 L
.6216 .75932 L
.60446 .76812 L
.58837 .77511 L
Mistroke
.57188 .78111 L
.55361 .78649 L
.54338 .78894 L
.53387 .79087 L
.52412 .79251 L
.51496 .79375 L
.50704 .79458 L
.49851 .79524 L
.48901 .79567 L
.48032 .79581 L
.47125 .79567 L
.46138 .79521 L
.45206 .79447 L
.44344 .79353 L
.43414 .79222 L
.42415 .79048 L
.4062 .78647 L
.38512 .78025 L
.36615 .77318 L
.32851 .75456 L
.29172 .72935 L
.26133 .70163 L
.23693 .67293 L
.21309 .63615 L
.20386 .61814 L
.19532 .5984 L
.18905 .58097 L
.18331 .56135 L
.17916 .54315 L
.17623 .52588 L
.17491 .51535 L
.17398 .50529 L
.1734 .49623 L
.17307 .48633 L
.17304 .47556 L
.17318 .46953 L
.1734 .46408 L
.1741 .45344 L
.17507 .44343 L
.17637 .43332 L
.1781 .42253 L
.18215 .40319 L
.18847 .38046 L
.19564 .36012 L
.21581 .31749 L
.24041 .27983 L
.26738 .2482 L
.29574 .22192 L
.33028 .19678 L
.3703 .17482 L
Mistroke
.39174 .16568 L
.41274 .1583 L
.43225 .15274 L
.45345 .14804 L
.46562 .14595 L
.47673 .14442 L
.48797 .14323 L
.49861 .14244 L
.51109 .14192 L
.52261 .14182 L
.52864 .14192 L
.53528 .14214 L
.5422 .14251 L
.54867 .14297 L
.55944 .144 L
.57113 .14549 L
.59231 .14918 L
.61274 .154 L
.63144 .15952 L
.67274 .17577 L
.71442 .19854 L
.75311 .2267 L
.78535 .25692 L
.81656 .29447 L
.84407 .33836 L
.86311 .37968 L
.87636 .42019 L
.88194 .44416 L
.88568 .46629 L
.88721 .47866 L
.88841 .49215 L
.88911 .50493 L
.88938 .51677 L
.88927 .52965 L
.88877 .5419 L
.888 .55289 L
.88679 .56487 L
.88507 .57782 L
.88276 .59157 L
.87736 .61612 L
.87028 .64071 L
.86214 .66347 L
.8432 .70466 L
.81432 .75109 L
.78221 .7902 L
.74136 .82837 L
.69264 .8624 L
.64455 .88691 L
.59799 .90368 L
.57136 .91056 L
Mistroke
.55711 .91348 L
.54187 .91604 L
.52848 .91782 L
.52134 .91858 L
.51363 .91927 L
.50006 .92014 L
.4873 .92055 L
.47446 .92057 L
.4625 .92024 L
.44938 .91949 L
.43539 .91823 L
.4207 .9164 L
.40688 .9142 L
.38121 .90886 L
.3574 .90239 L
.33577 .89521 L
.28833 .87472 L
.24231 .84775 L
.19675 .81252 L
.15815 .77376 L
.12723 .73419 L
.09689 .68346 L
.08363 .65505 L
.07173 .62376 L
.06251 .59281 L
.05609 .5642 L
.05365 .55021 L
.05152 .535 L
.04999 .52056 L
.04899 .50725 L
.04833 .49211 L
.04818 .47776 L
.04843 .46486 L
.04912 .45086 L
.05037 .43562 L
.05119 .42795 L
.05225 .4195 L
.05708 .39072 L
.06326 .3641 L
.07171 .33586 L
.09159 .28622 L
.12472 .22732 L
.1641 .17606 L
.20544 .13487 L
.25632 .09595 L
.28344 .07929 L
.31406 .06331 L
.34204 .05107 L
.37248 .04009 L
.40063 .03196 L
Mistroke
.41576 .02834 L
.43213 .02501 L
.44729 .02245 L
.4612 .02054 L
.47524 .01902 L
.4886 .01797 L
.50391 .01722 L
.51263 .01701 L
.52084 .01695 L
.53736 .01727 L
.54666 .01769 L
.55518 .01824 L
.56951 .0195 L
.58516 .02138 L
.61654 .02669 L
.63457 .03072 L
.65083 .03497 L
.68681 .04656 L
.74922 .07443 L
.78568 .0959 L
.81765 .11848 L
.88302 .17861 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.125 0.5 0.125 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.50062 .50002 L
.50118 .50007 L
.50182 .50017 L
.50242 .5003 L
.50347 .50062 L
.50458 .50111 L
.50574 .50179 L
.50689 .50269 L
.50779 .50358 L
.50868 .5047 L
.50949 .506 L
.5101 .50731 L
.51038 .50807 L
.51064 .50893 L
.51084 .50977 L
.51098 .51058 L
.51109 .51141 L
.51114 .5122 L
.51116 .51293 L
.51115 .51373 L
.51108 .51462 L
.51103 .51507 L
.51097 .51556 L
.51081 .51645 L
.51062 .51728 L
.51004 .51919 L
.50917 .52126 L
.5081 .52319 L
.50691 .52493 L
.50413 .52803 L
.50045 .53096 L
.49828 .53226 L
.49574 .5335 L
.49317 .53447 L
.49068 .53519 L
.4892 .53552 L
.48779 .53577 L
.4862 .53598 L
.4853 .53607 L
.48447 .53613 L
.4836 .53617 L
.48278 .5362 L
.48187 .5362 L
.48091 .53618 L
.48007 .53614 L
.47927 .53609 L
.4784 .53602 L
.47745 .53591 L
.47581 .53568 L
Mistroke
.47431 .5354 L
.47092 .53456 L
.46779 .53351 L
.46485 .53228 L
.45839 .52863 L
.4549 .52605 L
.45184 .52334 L
.44702 .51804 L
.44243 .51126 L
.44046 .50749 L
.43862 .50321 L
.43718 .49896 L
.43613 .49493 L
.43536 .49091 L
.43503 .48857 L
.43481 .48635 L
.43465 .48398 L
.43459 .48179 L
.4346 .47937 L
.43464 .47814 L
.43471 .4768 L
.43489 .4745 L
.43512 .4724 L
.43548 .46997 L
.4359 .46767 L
.43684 .46358 L
.43816 .45915 L
.44233 .44916 L
.44505 .44427 L
.4485 .43905 L
.45578 .43036 L
.46388 .42303 L
.47352 .41645 L
.47906 .41347 L
.48528 .41071 L
.49093 .40867 L
.4974 .40684 L
.50031 .40619 L
.50348 .40558 L
.50649 .40511 L
.50933 .40476 L
.51213 .4045 L
.51515 .40432 L
.51852 .40422 L
.52161 .40424 L
.52485 .40437 L
.52669 .40449 L
.52839 .40463 L
.53151 .40497 L
.53483 .40544 L
Mistroke
.54067 .40655 L
.54613 .40792 L
.55841 .41223 L
.56506 .41533 L
.5711 .41865 L
.58413 .42777 L
.59464 .43754 L
.60457 .44963 L
.61279 .46302 L
.6162 .47008 L
.61894 .47683 L
.62105 .48304 L
.62299 .49005 L
.62453 .49726 L
.62519 .50126 L
.6257 .50504 L
.62612 .50927 L
.62628 .51142 L
.62641 .5138 L
.62654 .51803 L
.62653 .52202 L
.62646 .52431 L
.62635 .52672 L
.62604 .53105 L
.6258 .53346 L
.62553 .53571 L
.62478 .54081 L
.62303 .54948 L
.62091 .5573 L
.61435 .57452 L
.60637 .58932 L
.59555 .60438 L
.58336 .61738 L
.57055 .62809 L
.55515 .63809 L
.54605 .6428 L
.53706 .64672 L
.52843 .64985 L
.51875 .65267 L
.50974 .65469 L
.50124 .65609 L
.49586 .65672 L
.49282 .657 L
.49001 .6572 L
.48481 .65743 L
.47931 .6575 L
.47434 .65739 L
.4697 .65715 L
.4646 .65672 L
.45914 .65608 L
Mistroke
.45331 .65519 L
.44698 .65398 L
.43557 .6511 L
.42459 .64749 L
.41462 .64344 L
.39619 .63383 L
.37759 .62084 L
.36154 .60617 L
.34839 .59088 L
.33522 .57096 L
.32931 .55965 L
.32387 .54705 L
.31953 .53451 L
.31637 .5228 L
.31511 .51704 L
.31396 .51076 L
.31308 .50485 L
.31242 .49921 L
.31189 .49305 L
.31159 .4874 L
.31146 .4813 L
.31147 .47783 L
.31154 .47463 L
.31177 .46929 L
.3122 .46339 L
.31286 .45723 L
.31365 .45145 L
.31614 .43826 L
.31925 .42627 L
.32357 .41327 L
.32914 .39986 L
.34232 .3757 L
.35769 .35478 L
.37775 .33404 L
.40254 .315 L
.41483 .30754 L
.42847 .30054 L
.4543 .29045 L
.4693 .28628 L
.48366 .28336 L
.49202 .28212 L
.49972 .28128 L
.50399 .28092 L
.50866 .28064 L
.51309 .28046 L
.51721 .28037 L
.52462 .2804 L
.5288 .28054 L
.53265 .28073 L
.53973 .28125 L
Mistroke
.54721 .28206 L
.55391 .283 L
.56015 .28407 L
.57426 .28715 L
.58936 .29154 L
.6029 .29647 L
.63225 .31075 L
.65688 .32717 L
.68077 .34813 L
.69894 .36865 L
.71625 .39381 L
.73124 .4233 L
.73791 .44084 L
.74284 .45741 L
.74623 .47235 L
.74774 .48092 L
.74887 .48896 L
.74979 .49754 L
.75037 .50537 L
.75058 .50973 L
.75073 .51445 L
.75077 .52305 L
.75053 .5313 L
.75007 .53883 L
.74926 .54753 L
.74821 .55577 L
.74567 .57035 L
.74194 .58611 L
.73667 .60318 L
.72973 .62098 L
.71392 .65174 L
.69334 .6812 L
.67027 .70634 L
.64121 .7305 L
.606 .75194 L
.59033 .7593 L
.57301 .76609 L
.55763 .77102 L
.54056 .77537 L
.52998 .77749 L
.52012 .77909 L
.51062 .7803 L
.50575 .78078 L
.50049 .78121 L
.49139 .78173 L
.48283 .78194 L
.4776 .78194 L
.47263 .78185 L
.46328 .78145 L
.45816 .78109 L
Mistroke
.45333 .78067 L
.44432 .77967 L
.43463 .77827 L
.42419 .77637 L
.4055 .77195 L
.38852 .76677 L
.35065 .75084 L
.33239 .74075 L
.31315 .72815 L
.28144 .70207 L
.25478 .67328 L
.23408 .64442 L
.21546 .61023 L
.20754 .59158 L
.20023 .57036 L
.19714 .55946 L
.19425 .54757 L
.19213 .53718 L
.19021 .52572 L
.18881 .51492 L
.18784 .50482 L
.18718 .49409 L
.18697 .48807 L
.18688 .48259 L
.18696 .47274 L
.18739 .46205 L
.18814 .45196 L
.18912 .44266 L
.19054 .43227 L
.19221 .42243 L
.1962 .40409 L
.20171 .38458 L
.20915 .36367 L
.22619 .32736 L
.24605 .29561 L
.27481 .2605 L
.30506 .23221 L
.34438 .20434 L
.36501 .19284 L
.38502 .18341 L
.42428 .16929 L
.44581 .16377 L
.46928 .15942 L
.48124 .15785 L
.48756 .1572 L
.4943 .15663 L
.50019 .15624 L
.50669 .15593 L
.51818 .15568 L
.52935 .15581 L
Mistroke
.54137 .15635 L
.55273 .15725 L
.56311 .1584 L
.57344 .15986 L
.58443 .16176 L
.60409 .16609 L
.62717 .17272 L
.64775 .18012 L
.68699 .19848 L
.7219 .22022 L
.75619 .24776 L
.78989 .28284 L
.81992 .32427 L
.84262 .36675 L
.85154 .38824 L
.85875 .40917 L
.86422 .4286 L
.86887 .4496 L
.8708 .46055 L
.87255 .47272 L
.87379 .48386 L
.87466 .49437 L
.8753 .50674 L
.87552 .51812 L
.87537 .53063 L
.87514 .53693 L
.87476 .54383 L
.8737 .55692 L
.87231 .56899 L
.87033 .58219 L
.86773 .59612 L
.86218 .61934 L
.85437 .64452 L
.83538 .68954 L
.8124 .72943 L
.77955 .77248 L
.74429 .80772 L
.6981 .84268 L
.67361 .85731 L
.64957 .86947 L
.62608 .87947 L
.59995 .88859 L
.57562 .89532 L
.55285 .90016 L
.5408 .90217 L
.5278 .90393 L
.52031 .90474 L
.51346 .90537 L
.50002 .90625 L
.48614 .90669 L
Mistroke
.47828 .90673 L
.47102 .90663 L
.45767 .90612 L
.44351 .90509 L
.43132 .9038 L
.42017 .9023 L
.39518 .8978 L
.37336 .89254 L
.35068 .8857 L
.30384 .86687 L
.2554 .83978 L
.20854 .80441 L
.16902 .7651 L
.13803 .72542 L
.10987 .67835 L
.08614 .62301 L
.07714 .59386 L
.07289 .57681 L
.06961 .56107 L
.06727 .54749 L
.06521 .5326 L
.0643 .5244 L
.06359 .51678 L
.06258 .5017 L
.06211 .48742 L
.06208 .47448 L
.06253 .45953 L
.06342 .44547 L
.06471 .43192 L
.06655 .41746 L
.07108 .39152 L
.07849 .361 L
.08713 .33367 L
.112 .27621 L
.14289 .22529 L
.17715 .18229 L
.21338 .14636 L
.25775 .11172 L
.30935 .08109 L
.33713 .06812 L
.36436 .05749 L
.3897 .04933 L
.41727 .04222 L
.43311 .03894 L
.44759 .03644 L
.46241 .03437 L
.47611 .03288 L
.49222 .03165 L
.50071 .03122 L
.50971 .03094 L
Mistroke
.52485 .03085 L
.53346 .03103 L
.5415 .03133 L
.5556 .03219 L
.57092 .03361 L
.58536 .03541 L
.59869 .03748 L
.62374 .04243 L
.65008 .04918 L
.70344 .068 L
.75958 .09611 L
.80844 .1289 L
.85539 .16981 L
.89121 .20947 L
.9253 .25729 L
.95554 .31343 L
.96927 .34656 L
.97964 .37755 L
.98749 .40712 L
.99088 .4229 L
.99392 .43975 L
.99611 .45457 L
.998 .47097 L
.99924 .48594 L
1 .5 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SpinOrigin\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"{0,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"0,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"1.5}\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"used with \"\>", 
                    StyleBox["\<\"SpinDistance\"\>",
                      "MR"], "\<\" to determine the \"\>", 
                    StyleBox["\<\"ViewPoint\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SpinDistance\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"2\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"used with \"\>", 
                    StyleBox["\<\"SpinOrigin\"\>",
                      "MR"], "\<\" to determine the \"\>", 
                    StyleBox["\<\"ViewPoint\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SpinTilt\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"{0,0}\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"specifies Euler angles \"\>", Cell[BoxData[
                        \(TraditionalForm\`\[Beta]\)], 
                      "InlineFormula"], "\<\" and \"\>", Cell[BoxData[
                        \(TraditionalForm\`\[Gamma]\)], 
                      "InlineFormula"], "\<\" to give a tilt to the \
rotation\"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SpinRange\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"0\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"Degree,\"\>",
                      "MR"], "\<\"  \"\>", 
                    StyleBox["\<\"360\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"Degree\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]], 
            Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"the range of angles over which the first Euler \
angle \"\>", Cell[BoxData[
                        \(TraditionalForm\`\[Alpha]\)], 
                      "InlineFormula"], "\<\" will be varied \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"RotateLights\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"whether the light sources should rotate \
with the object "\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S5.25.1"],

Cell[TextData[{
  "Options to ",
  StyleBox["SpinShow", "MR"],
  "."
}], "Caption",
  CellTags->"S5.25.1"],

Cell[TextData[{
  StyleBox["SpinShow", "MR"],
  " works by changing the viewpoint of the image. It generates a ",
  StyleBox["ViewPoint", "MR"],
  " by rotating around a sphere of radius ",
  StyleBox["SpinDistance", "MR"],
  " and shifting the result by the ",
  StyleBox["SpinOrigin", "MR"],
  ". The actual rotation uses the first Euler angle ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  " with initial and final values determined by the settings of the ",
  StyleBox["SpinRange", "MR"],
  ". A final amount of freedom is provided by the ",
  StyleBox["SpinTilt", "MR"],
  " option that gives the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)], "InlineFormula"],
  " Euler angles of the rotation, which can give the rotation an amount of \
wobble. "
}], "Text",
  CellTags->{"S5.25.1", "1.10"}],

Cell["This gives a parametric plot that will be animated. ", "MathCaption",
  CellTags->{"S5.25.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
g = ParametricPlot3D[
 {x, Cos[t] Sin[x] , Sin[t] Sin[x]},
      {x, -Pi, Pi}, {t, 0, 2Pi},
      Axes -> False, Boxed -> False]\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .66509 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0241262 1.02413 -0.15878 1.02413 [
[ 0 0 0 0 ]
[ 1 .66509 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .66509 L
0 .66509 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.697 .564 .702 r
.32435 .42624 m .29466 .43403 L .28738 .40963 L p F P
0 g
s
.697 .564 .702 r
.28738 .40963 m .3164 .39963 L .32435 .42624 L p F P
0 g
s
.726 .581 .693 r
.25611 .42072 m .28738 .40963 L .29466 .43403 L p F P
0 g
s
.709 .605 .739 r
.3164 .39963 m .28738 .40963 L .27787 .38629 L p F P
0 g
s
.737 .619 .727 r
.28738 .40963 m .25611 .42072 L .24786 .40057 L p F P
0 g
s
.737 .619 .727 r
.24786 .40057 m .27787 .38629 L .28738 .40963 L p F P
0 g
s
.685 .523 .661 r
.32958 .45286 m .29939 .45844 L .29466 .43403 L p F P
0 g
s
.685 .523 .661 r
.29466 .43403 m .32435 .42624 L .32958 .45286 L p F P
0 g
s
.715 .543 .655 r
.26238 .44179 m .29466 .43403 L .29939 .45844 L p F P
0 g
s
.726 .581 .693 r
.29466 .43403 m .26238 .44179 L .25611 .42072 L p F P
0 g
s
.658 .542 .711 r
.35138 .41838 m .32435 .42624 L .3164 .39963 L p F P
0 g
s
.658 .542 .711 r
.3164 .39963 m .34311 .39075 L .35138 .41838 L p F P
0 g
s
.671 .586 .752 r
.34311 .39075 m .3164 .39963 L .30606 .37414 L p F P
0 g
s
.709 .605 .739 r
.27787 .38629 m .30606 .37414 L .3164 .39963 L p F P
0 g
s
.644 .496 .667 r
.35687 .44602 m .32958 .45286 L .32435 .42624 L p F P
0 g
s
.644 .496 .667 r
.32435 .42624 m .35138 .41838 L .35687 .44602 L p F P
0 g
s
.746 .593 .685 r
.22275 .43278 m .25611 .42072 L .26238 .44179 L p F P
0 g
s
.757 .628 .717 r
.25611 .42072 m .22275 .43278 L .21616 .41675 L p F P
0 g
s
.757 .628 .717 r
.21616 .41675 m .24786 .40057 L .25611 .42072 L p F P
0 g
s
.723 .648 .774 r
.30606 .37414 m .27787 .38629 L .26652 .36497 L p F P
0 g
s
.751 .659 .759 r
.27787 .38629 m .24786 .40057 L .23799 .3822 L p F P
0 g
s
.751 .659 .759 r
.23799 .3822 m .26652 .36497 L .27787 .38629 L p F P
0 g
s
.715 .543 .655 r
.29939 .45844 m .26642 .46288 L .26238 .44179 L p F P
0 g
s
.737 .557 .649 r
.22774 .44956 m .26238 .44179 L .26642 .46288 L p F P
0 g
s
.746 .593 .685 r
.26238 .44179 m .22774 .44956 L .22275 .43278 L p F P
0 g
s
.671 .586 .752 r
.30606 .37414 m .33241 .36426 L .34311 .39075 L p F P
0 g
s
.684 .632 .791 r
.33241 .36426 m .30606 .37414 L .29376 .35084 L p F P
0 g
s
.723 .648 .774 r
.26652 .36497 m .29376 .35084 L .30606 .37414 L p F P
0 g
s
.673 .478 .613 r
.33185 .47839 m .30137 .48184 L .29939 .45844 L p F P
0 g
s
.673 .478 .613 r
.29939 .45844 m .32958 .45286 L .33185 .47839 L p F P
0 g
s
.706 .502 .611 r
.26642 .46288 m .29939 .45844 L .30137 .48184 L p F P
0 g
s
.771 .666 .747 r
.24786 .40057 m .21616 .41675 L .20825 .40218 L p F P
0 g
s
.771 .666 .747 r
.20825 .40218 m .23799 .3822 L .24786 .40057 L p F P
0 g
s
.607 .512 .72 r
.37577 .4104 m .35138 .41838 L .34311 .39075 L p F P
0 g
s
.607 .512 .72 r
.34311 .39075 m .36756 .38299 L .37577 .4104 L p F P
0 g
s
.621 .56 .765 r
.36756 .38299 m .34311 .39075 L .33241 .36426 L p F P
0 g
s
.627 .444 .615 r
.35934 .4725 m .33185 .47839 L .32958 .45286 L p F P
0 g
s
.627 .444 .615 r
.32958 .45286 m .35687 .44602 L .35934 .4725 L p F P
0 g
s
.59 .46 .672 r
.38127 .43781 m .35687 .44602 L .35138 .41838 L p F P
0 g
s
.59 .46 .672 r
.35138 .41838 m .37577 .4104 L .38127 .43781 L p F P
0 g
s
.706 .502 .611 r
.30137 .48184 m .26803 .48309 L .26642 .46288 L p F P
0 g
s
.729 .52 .608 r
.23091 .46635 m .26642 .46288 L .26803 .48309 L p F P
0 g
s
.737 .557 .649 r
.26642 .46288 m .23091 .46635 L .22774 .44956 L p F P
0 g
s
.76 .6 .679 r
.18758 .44568 m .22275 .43278 L .22774 .44956 L p F P
0 g
s
.771 .635 .71 r
.22275 .43278 m .18758 .44568 L .18297 .43453 L p F P
0 g
s
.771 .635 .71 r
.18297 .43453 m .21616 .41675 L .22275 .43278 L p F P
0 g
s
.621 .56 .765 r
.33241 .36426 m .35698 .3567 L .36756 .38299 L p F P
0 g
s
.631 .609 .809 r
.35698 .3567 m .33241 .36426 L .31972 .34003 L p F P
0 g
s
.684 .632 .791 r
.29376 .35084 m .31972 .34003 L .33241 .36426 L p F P
0 g
s
.752 .567 .645 r
.19105 .45736 m .22774 .44956 L .23091 .46635 L p F P
0 g
s
.76 .6 .679 r
.22774 .44956 m .19105 .45736 L .18758 .44568 L p F P
0 g
s
.738 .695 .81 r
.29376 .35084 m .26652 .36497 L .25379 .34662 L p F P
0 g
s
.768 .703 .791 r
.26652 .36497 m .23799 .3822 L .22691 .36643 L p F P
0 g
s
.768 .703 .791 r
.22691 .36643 m .25379 .34662 L .26652 .36497 L p F P
0 g
s
.785 .671 .738 r
.21616 .41675 m .18297 .43453 L .17742 .42441 L p F P
0 g
s
.785 .671 .738 r
.17742 .42441 m .20825 .40218 L .21616 .41675 L p F P
0 g
s
.788 .707 .775 r
.23799 .3822 m .20825 .40218 L .19935 .3897 L p F P
0 g
s
.788 .707 .775 r
.19935 .3897 m .22691 .36643 L .23799 .3822 L p F P
0 g
s
.697 .682 .832 r
.31972 .34003 m .29376 .35084 L .27999 .33073 L p F P
0 g
s
.738 .695 .81 r
.25379 .34662 m .27999 .33073 L .29376 .35084 L p F P
0 g
s
.567 .399 .614 r
.38381 .46405 m .35934 .4725 L .35687 .44602 L p F P
0 g
s
.567 .399 .614 r
.35687 .44602 m .38127 .43781 L .38381 .46405 L p F P
0 g
s
.729 .52 .608 r
.26803 .48309 m .2321 .48243 L .23091 .46635 L p F P
0 g
s
.745 .532 .606 r
.19322 .46906 m .23091 .46635 L .2321 .48243 L p F P
0 g
s
.752 .567 .645 r
.23091 .46635 m .19322 .46906 L .19105 .45736 L p F P
0 g
s
.659 .425 .555 r
.33104 .50171 m .30048 .50321 L .30137 .48184 L p F P
0 g
s
.659 .425 .555 r
.30137 .48184 m .33185 .47839 L .33104 .50171 L p F P
0 g
s
.696 .457 .557 r
.26803 .48309 m .30137 .48184 L .30048 .50321 L p F P
0 g
s
.696 .457 .557 r
.30048 .50321 m .26713 .50153 L .26803 .48309 L p F P
0 g
s
.723 .48 .558 r
.2321 .48243 m .26803 .48309 L .26713 .50153 L p F P
0 g
s
.543 .473 .727 r
.39766 .40227 m .37577 .4104 L .36756 .38299 L p F P
0 g
s
.543 .473 .727 r
.36756 .38299 m .38988 .37631 L .39766 .40227 L p F P
0 g
s
.557 .525 .775 r
.38988 .37631 m .36756 .38299 L .35698 .3567 L p F P
0 g
s
.606 .381 .549 r
.35864 .4967 m .33104 .50171 L .33185 .47839 L p F P
0 g
s
.606 .381 .549 r
.33185 .47839 m .35934 .4725 L .35864 .4967 L p F P
0 g
s
.801 .71 .764 r
.20825 .40218 m .17742 .42441 L .17117 .41578 L p F P
0 g
s
.801 .71 .764 r
.17117 .41578 m .19935 .3897 L .20825 .40218 L p F P
0 g
s
.522 .414 .673 r
.40291 .42819 m .38127 .43781 L .37577 .4104 L p F P
0 g
s
.522 .414 .673 r
.37577 .4104 m .39766 .40227 L .40291 .42819 L p F P
0 g
s
.631 .609 .809 r
.31972 .34003 m .34446 .33263 L .35698 .3567 L p F P
0 g
s
.64 .661 .855 r
.34446 .33263 m .31972 .34003 L .30554 .31909 L p F P
0 g
s
.697 .682 .832 r
.27999 .33073 m .30554 .31909 L .31972 .34003 L p F P
0 g
s
.769 .605 .676 r
.15098 .45923 m .18758 .44568 L .19105 .45736 L p F P
0 g
s
.78 .638 .705 r
.18758 .44568 m .15098 .45923 L .1486 .4535 L p F P
0 g
s
.78 .638 .705 r
.1486 .4535 m .18297 .43453 L .18758 .44568 L p F P
0 g
s
.761 .573 .643 r
.15276 .46524 m .19105 .45736 L .19322 .46906 L p F P
0 g
s
.769 .605 .676 r
.19105 .45736 m .15276 .46524 L .15098 .45923 L p F P
0 g
s
.723 .48 .558 r
.26713 .50153 m .23127 .49708 L .2321 .48243 L p F P
0 g
s
.741 .495 .558 r
.19399 .48025 m .2321 .48243 L .23127 .49708 L p F P
0 g
s
.745 .532 .606 r
.2321 .48243 m .19399 .48025 L .19322 .46906 L p F P
0 g
s
.557 .525 .775 r
.35698 .3567 m .37989 .35141 L .38988 .37631 L p F P
0 g
s
.565 .576 .824 r
.37989 .35141 m .35698 .3567 L .34446 .33263 L p F P
0 g
s
.793 .673 .732 r
.18297 .43453 m .1486 .4535 L .14572 .44831 L p F P
0 g
s
.793 .673 .732 r
.14572 .44831 m .17742 .42441 L .18297 .43453 L p F P
0 g
s
.756 .749 .846 r
.27999 .33073 m .25379 .34662 L .24023 .33205 L p F P
0 g
s
.788 .753 .822 r
.25379 .34662 m .22691 .36643 L .21509 .35397 L p F P
0 g
s
.788 .753 .822 r
.21509 .35397 m .24023 .33205 L .25379 .34662 L p F P
0 g
s
.809 .754 .802 r
.22691 .36643 m .19935 .3897 L .18986 .37989 L p F P
0 g
s
.809 .754 .802 r
.18986 .37989 m .21509 .35397 L .22691 .36643 L p F P
0 g
s
.755 .54 .604 r
.15386 .47125 m .19322 .46906 L .19399 .48025 L p F P
0 g
s
.761 .573 .643 r
.19322 .46906 m .15386 .47125 L .15276 .46524 L p F P
0 g
s
.534 .323 .54 r
.38325 .48801 m .35864 .4967 L .35934 .4725 L p F P
0 g
s
.534 .323 .54 r
.35934 .4725 m .38381 .46405 L .38325 .48801 L p F P
0 g
s
.49 .343 .608 r
.40539 .453 m .38381 .46405 L .38127 .43781 L p F P
0 g
s
.49 .343 .608 r
.38127 .43781 m .40291 .42819 L .40539 .453 L p F P
0 g
s
.81 .711 .756 r
.17742 .42441 m .14572 .44831 L .14248 .44391 L p F P
0 g
s
.81 .711 .756 r
.14248 .44391 m .17117 .41578 L .17742 .42441 L p F P
0 g
s
.709 .74 .875 r
.30554 .31909 m .27999 .33073 L .26533 .31473 L p F P
0 g
s
.756 .749 .846 r
.24023 .33205 m .26533 .31473 L .27999 .33073 L p F P
0 g
s
.822 .754 .788 r
.19935 .3897 m .17117 .41578 L .16451 .40904 L p F P
0 g
s
.822 .754 .788 r
.16451 .40904 m .18986 .37989 L .19935 .3897 L p F P
0 g
s
.741 .495 .558 r
.23127 .49708 m .19332 .49042 L .19399 .48025 L p F P
0 g
s
.751 .505 .559 r
.15422 .477 m .19399 .48025 L .19332 .49042 L p F P
0 g
s
.755 .54 .604 r
.19399 .48025 m .15422 .477 L .15386 .47125 L p F P
0 g
s
.686 .402 .487 r
.29672 .5216 m .26372 .51736 L .26713 .50153 L p F P
0 g
s
.686 .402 .487 r
.26713 .50153 m .30048 .50321 L .29672 .5216 L p F P
0 g
s
.717 .432 .494 r
.23127 .49708 m .26713 .50153 L .26372 .51736 L p F P
0 g
s
.64 .359 .476 r
.32713 .52179 m .29672 .5216 L .30048 .50321 L p F P
0 g
s
.64 .359 .476 r
.30048 .50321 m .33104 .50171 L .32713 .52179 L p F P
0 g
s
.717 .432 .494 r
.26372 .51736 m .22842 .50963 L .23127 .49708 L p F P
0 g
s
.737 .453 .498 r
.19332 .49042 m .23127 .49708 L .22842 .50963 L p F P
0 g
s
.565 .576 .824 r
.34446 .33263 m .36811 .32862 L .37989 .35141 L p F P
0 g
s
.564 .629 .874 r
.36811 .32862 m .34446 .33263 L .33052 .31182 L p F P
0 g
s
.64 .661 .855 r
.30554 .31909 m .33052 .31182 L .34446 .33263 L p F P
0 g
s
.831 .754 .779 r
.17117 .41578 m .14248 .44391 L .13903 .44049 L p F P
0 g
s
.831 .754 .779 r
.13903 .44049 m .16451 .40904 L .17117 .41578 L p F P
0 g
s
.575 .298 .459 r
.35476 .51754 m .32713 .52179 L .33104 .50171 L p F P
0 g
s
.575 .298 .459 r
.33104 .50171 m .35864 .4967 L .35476 .51754 L p F P
0 g
s
.773 .608 .674 r
.11343 .47318 m .15098 .45923 L .15276 .46524 L closepath p F P
0 g
s
.784 .64 .703 r
.11343 .47318 m .1486 .4535 L .15098 .45923 L closepath p F P
0 g
s
.643 .721 .905 r
.33052 .31182 m .30554 .31909 L .29047 .30238 L p F P
0 g
s
.709 .74 .875 r
.26533 .31473 m .29047 .30238 L .30554 .31909 L p F P
0 g
s
.766 .576 .641 r
.11343 .47318 m .15276 .46524 L .15386 .47125 L closepath p F P
0 g
s
.797 .674 .729 r
.11343 .47318 m .14572 .44831 L .1486 .4535 L closepath p F P
0 g
s
.468 .426 .728 r
.41727 .39393 m .39766 .40227 L .38988 .37631 L p F P
0 g
s
.468 .426 .728 r
.38988 .37631 m .41028 .37064 L .41727 .39393 L p F P
0 g
s
.482 .482 .781 r
.41028 .37064 m .38988 .37631 L .37989 .35141 L p F P
0 g
s
.737 .453 .498 r
.22842 .50963 m .19124 .49912 L .19332 .49042 L p F P
0 g
s
.749 .465 .501 r
.15383 .48222 m .19332 .49042 L .19124 .49912 L p F P
0 g
s
.751 .505 .559 r
.19332 .49042 m .15383 .48222 L .15422 .477 L p F P
0 g
s
.76 .544 .604 r
.11343 .47318 m .15386 .47125 L .15422 .477 L closepath p F P
0 g
s
.441 .36 .669 r
.42202 .41718 m .40291 .42819 L .39766 .40227 L p F P
0 g
s
.441 .36 .669 r
.39766 .40227 m .41727 .39393 L .42202 .41718 L p F P
0 g
s
.441 .249 .522 r
.40497 .47562 m .38325 .48801 L .38381 .46405 L p F P
0 g
s
.441 .249 .522 r
.38381 .46405 m .40539 .453 L .40497 .47562 L p F P
0 g
s
.814 .712 .753 r
.11343 .47318 m .14248 .44391 L .14572 .44831 L closepath p F P
0 g
s
.812 .813 .852 r
.24023 .33205 m .21509 .35397 L .20305 .34541 L p F P
0 g
s
.834 .809 .827 r
.21509 .35397 m .18986 .37989 L .1802 .37322 L p F P
0 g
s
.834 .809 .827 r
.1802 .37322 m .20305 .34541 L .21509 .35397 L p F P
0 g
s
.848 .806 .809 r
.18986 .37989 m .16451 .40904 L .15773 .4045 L p F P
0 g
s
.848 .806 .809 r
.15773 .4045 m .1802 .37322 L .18986 .37989 L p F P
0 g
s
.757 .509 .559 r
.11343 .47318 m .15422 .477 L .15383 .48222 L closepath p F P
0 g
s
.482 .482 .781 r
.37989 .35141 m .40134 .34828 L .41028 .37064 L p F P
0 g
s
.484 .534 .833 r
.40134 .34828 m .37989 .35141 L .36811 .32862 L p F P
0 g
s
.776 .815 .884 r
.26533 .31473 m .24023 .33205 L .22641 .32198 L p F P
0 g
s
.812 .813 .852 r
.20305 .34541 m .22641 .32198 L .24023 .33205 L p F P
0 g
s
.834 .753 .774 r
.11343 .47318 m .13903 .44049 L .14248 .44391 L closepath p F P
0 g
s
.856 .803 .797 r
.16451 .40904 m .13903 .44049 L .13552 .43822 L p F P
0 g
s
.856 .803 .797 r
.13552 .43822 m .15773 .4045 L .16451 .40904 L p F P
0 g
s
.483 .215 .432 r
.37957 .50863 m .35476 .51754 L .35864 .4967 L p F P
0 g
s
.483 .215 .432 r
.35864 .4967 m .38325 .48801 L .37957 .50863 L p F P
0 g
s
.749 .465 .501 r
.19124 .49912 m .1527 .48666 L .15383 .48222 L p F P
0 g
s
.755 .471 .502 r
.11343 .47318 m .15383 .48222 L .1527 .48666 L closepath p F P
0 g
s
.398 .276 .596 r
.42431 .4394 m .40539 .453 L .40291 .42819 L p F P
0 g
s
.398 .276 .596 r
.40291 .42819 m .42202 .41718 L .42431 .4394 L p F P
0 g
s
.709 .372 .406 r
.25791 .52986 m .22365 .5195 L .22842 .50963 L p F P
0 g
s
.709 .372 .406 r
.22842 .50963 m .26372 .51736 L .25791 .52986 L p F P
0 g
s
.733 .4 .418 r
.19124 .49912 m .22842 .50963 L .22365 .5195 L p F P
0 g
s
.733 .4 .418 r
.22365 .5195 m .18781 .50592 L .19124 .49912 L p F P
0 g
s
.748 .418 .425 r
.1527 .48666 m .19124 .49912 L .18781 .50592 L p F P
0 g
s
.67 .329 .387 r
.2902 .53615 m .25791 .52986 L .26372 .51736 L p F P
0 g
s
.67 .329 .387 r
.26372 .51736 m .29672 .5216 L .2902 .53615 L p F P
0 g
s
.86 .801 .791 r
.11343 .47318 m .13552 .43822 L .13903 .44049 L closepath p F P
0 g
s
.72 .81 .921 r
.29047 .30238 m .26533 .31473 L .2504 .30359 L p F P
0 g
s
.776 .815 .884 r
.22641 .32198 m .2504 .30359 L .26533 .31473 L p F P
0 g
s
.564 .629 .874 r
.33052 .31182 m .35502 .30891 L .36811 .32862 L p F P
0 g
s
.55 .686 .929 r
.35502 .30891 m .33052 .31182 L .31571 .29521 L p F P
0 g
s
.643 .721 .905 r
.29047 .30238 m .31571 .29521 L .33052 .31182 L p F P
0 g
s
.748 .418 .425 r
.18781 .50592 m .15089 .49012 L .1527 .48666 L p F P
0 g
s
.754 .426 .428 r
.11343 .47318 m .1527 .48666 L .15089 .49012 L closepath p F P
0 g
s
.612 .266 .36 r
.32023 .53769 m .2902 .53615 L .29672 .5216 L p F P
0 g
s
.612 .266 .36 r
.29672 .5216 m .32713 .52179 L .32023 .53769 L p F P
0 g
s
.484 .534 .833 r
.36811 .32862 m .39083 .32782 L .40134 .34828 L p F P
0 g
s
.471 .584 .886 r
.39083 .32782 m .36811 .32862 L .35502 .30891 L p F P
0 g
s
.923 .914 .792 r
.11343 .47318 m .12897 .4375 L .13211 .4372 L closepath p F P
0 g
s
.94 .961 .738 r
.11343 .47318 m .12624 .4391 L .12897 .4375 L closepath p F P
0 g
s
.896 .945 .586 r
.11343 .47318 m .12405 .44193 L .12624 .4391 L closepath p F P
0 g
s
0 0 .31 r
.11343 .47318 m .12166 .45631 L .12171 .45074 L closepath p F P
0 g
s
.891 .855 .801 r
.11343 .47318 m .13211 .4372 L .13552 .43822 L closepath p F P
0 g
s
0 0 .484 r
.11343 .47318 m .12239 .46231 L .12166 .45631 L closepath p F P
0 g
s
.023 .096 .601 r
.11343 .47318 m .12385 .46846 L .12239 .46231 L closepath p F P
0 g
s
.057 .186 .684 r
.11343 .47318 m .12598 .47446 L .12385 .46846 L closepath p F P
0 g
s
.045 .245 .744 r
.11343 .47318 m .12868 .48003 L .12598 .47446 L closepath p F P
0 g
s
.697 .169 0 r
.11343 .47318 m .14555 .49349 L .14227 .49322 L closepath p F P
0 g
s
.74 .287 .175 r
.11343 .47318 m .14847 .49243 L .14555 .49349 L closepath p F P
0 g
s
.752 .368 .326 r
.11343 .47318 m .15089 .49012 L .14847 .49243 L closepath p F P
0 g
s
0 .272 .776 r
.11343 .47318 m .13181 .48489 L .12868 .48003 L closepath p F P
0 g
s
.577 .005 0 r
.11343 .47318 m .14227 .49322 L .13877 .49165 L closepath p F P
0 g
s
0 .253 .755 r
.11343 .47318 m .13523 .48883 L .13181 .48489 L closepath p F P
0 g
s
0 .159 .62 r
.11343 .47318 m .13877 .49165 L .13523 .48883 L closepath p F P
0 g
s
.722 .783 .296 r
.11343 .47318 m .12252 .44587 L .12405 .44193 L closepath p F P
0 g
s
0 0 .045 r
.11343 .47318 m .12171 .45074 L .12252 .44587 L closepath p F P
0 g
s
.887 .859 .808 r
.15773 .4045 m .13552 .43822 L .13211 .4372 L p F P
0 g
s
.879 .865 .822 r
.1802 .37322 m .15773 .4045 L .15114 .4024 L p F P
0 g
s
.887 .859 .808 r
.13211 .4372 m .15114 .4024 L .15773 .4045 L p F P
0 g
s
.744 .356 .318 r
.1832 .51051 m .14847 .49243 L .15089 .49012 L p F P
0 g
s
.744 .356 .318 r
.15089 .49012 m .18781 .50592 L .1832 .51051 L p F P
0 g
s
.864 .875 .844 r
.20305 .34541 m .1802 .37322 L .17079 .37003 L p F P
0 g
s
.879 .865 .822 r
.15114 .4024 m .17079 .37003 L .1802 .37322 L p F P
0 g
s
.633 .792 .958 r
.31571 .29521 m .29047 .30238 L .27514 .29072 L p F P
0 g
s
.72 .81 .921 r
.2504 .30359 m .27514 .29072 L .29047 .30238 L p F P
0 g
s
.358 .108 .392 r
.40163 .49504 m .37957 .50863 L .38325 .48801 L p F P
0 g
s
.358 .108 .392 r
.38325 .48801 m .40497 .47562 L .40163 .49504 L p F P
0 g
s
.522 .174 .318 r
.3478 .53404 m .32023 .53769 L .32713 .52179 L p F P
0 g
s
.522 .174 .318 r
.32713 .52179 m .35476 .51754 L .3478 .53404 L p F P
0 g
s
.327 .16 .495 r
.42402 .45962 m .40497 .47562 L .40539 .453 L p F P
0 g
s
.327 .16 .495 r
.40539 .453 m .42431 .4394 L .42402 .45962 L p F P
0 g
s
.725 .331 .302 r
.21716 .5262 m .1832 .51051 L .18781 .50592 L p F P
0 g
s
.725 .331 .302 r
.18781 .50592 m .22365 .5195 L .21716 .5262 L p F P
0 g
s
.919 .919 .799 r
.15114 .4024 m .13211 .4372 L .12897 .4375 L p F P
0 g
s
.838 .886 .875 r
.22641 .32198 m .20305 .34541 L .19132 .34122 L p F P
0 g
s
.864 .875 .844 r
.17079 .37003 m .19132 .34122 L .20305 .34541 L p F P
0 g
s
.729 .269 .159 r
.1776 .51264 m .14555 .49349 L .14847 .49243 L p F P
0 g
s
.729 .269 .159 r
.14847 .49243 m .1832 .51051 L .1776 .51264 L p F P
0 g
s
.693 .289 .275 r
.24994 .53838 m .21716 .5262 L .22365 .5195 L p F P
0 g
s
.693 .289 .275 r
.22365 .5195 m .25791 .52986 L .24994 .53838 L p F P
0 g
s
.386 .374 .723 r
.43494 .38536 m .41727 .39393 L .41028 .37064 L p F P
0 g
s
.386 .374 .723 r
.41028 .37064 m .42907 .36583 L .43494 .38536 L p F P
0 g
s
.399 .433 .78 r
.42907 .36583 m .41028 .37064 L .40134 .34828 L p F P
0 g
s
.354 .301 .658 r
.43895 .40484 m .42202 .41718 L .41727 .39393 L p F P
0 g
s
.354 .301 .658 r
.41727 .39393 m .43494 .38536 L .43895 .40484 L p F P
0 g
s
.793 .895 .916 r
.2504 .30359 m .22641 .32198 L .21294 .31693 L p F P
0 g
s
.838 .886 .875 r
.19132 .34122 m .21294 .31693 L .22641 .32198 L p F P
0 g
s
.919 .919 .799 r
.12897 .4375 m .14505 .40285 L .15114 .4024 L p F P
0 g
s
.933 .967 .743 r
.14505 .40285 m .12897 .4375 L .12624 .4391 L p F P
0 g
s
.909 .93 .815 r
.17079 .37003 m .15114 .4024 L .14505 .40285 L p F P
0 g
s
.399 .433 .78 r
.40134 .34828 m .4216 .34709 L .42907 .36583 L p F P
0 g
s
.395 .484 .833 r
.4216 .34709 m .40134 .34828 L .39083 .32782 L p F P
0 g
s
.389 .045 .256 r
.37286 .52492 m .3478 .53404 L .35476 .51754 L p F P
0 g
s
.389 .045 .256 r
.35476 .51754 m .37957 .50863 L .37286 .52492 L p F P
0 g
s
.471 .584 .886 r
.35502 .30891 m .37918 .31014 L .39083 .32782 L p F P
0 g
s
.432 .633 .939 r
.37918 .31014 m .35502 .30891 L .34116 .29317 L p F P
0 g
s
.55 .686 .929 r
.31571 .29521 m .34116 .29317 L .35502 .30891 L p F P
0 g
s
.641 .222 .234 r
.28117 .5461 m .24994 .53838 L .25791 .52986 L p F P
0 g
s
.641 .222 .234 r
.25791 .52986 m .2902 .53615 L .28117 .5461 L p F P
0 g
s
.676 .139 0 r
.17126 .51219 m .14227 .49322 L .14555 .49349 L p F P
0 g
s
.676 .139 0 r
.14555 .49349 m .1776 .51264 L .17126 .51219 L p F P
0 g
s
.298 .204 .576 r
.44091 .42342 m .42431 .4394 L .42202 .41718 L p F P
0 g
s
.298 .204 .576 r
.42202 .41718 m .43895 .40484 L .44091 .42342 L p F P
0 g
s
.702 .23 .126 r
.20923 .52937 m .1776 .51264 L .1832 .51051 L p F P
0 g
s
.702 .23 .126 r
.1832 .51051 m .21716 .5262 L .20923 .52937 L p F P
0 g
s
.505 .747 .982 r
.34116 .29317 m .31571 .29521 L .30069 .28358 L p F P
0 g
s
.633 .792 .958 r
.27514 .29072 m .30069 .28358 L .31571 .29521 L p F P
0 g
s
.933 .967 .743 r
.12624 .4391 m .13975 .40587 L .14505 .40285 L p F P
0 g
s
.877 .944 .58 r
.13975 .40587 m .12624 .4391 L .12405 .44193 L p F P
0 g
s
.715 .895 .961 r
.27514 .29072 m .2504 .30359 L .23586 .29793 L p F P
0 g
s
.793 .895 .916 r
.21294 .31693 m .23586 .29793 L .2504 .30359 L p F P
0 g
s
.89 .946 .839 r
.19132 .34122 m .17079 .37003 L .16208 .37052 L p F P
0 g
s
.909 .93 .815 r
.14505 .40285 m .16208 .37052 L .17079 .37003 L p F P
0 g
s
.539 0 0 r
.16448 .50915 m .13877 .49165 L .14227 .49322 L p F P
0 g
s
.539 0 0 r
.14227 .49322 m .17126 .51219 L .16448 .50915 L p F P
0 g
s
.555 .12 .17 r
.31059 .5486 m .28117 .5461 L .2902 .53615 L p F P
0 g
s
.555 .12 .17 r
.2902 .53615 m .32023 .53769 L .31059 .5486 L p F P
0 g
s
.203 0 .337 r
.42113 .47693 m .40163 .49504 L .40497 .47562 L p F P
0 g
s
.203 0 .337 r
.40497 .47562 m .42402 .45962 L .42113 .47693 L p F P
0 g
s
.395 .484 .833 r
.39083 .32782 m .41283 .32994 L .4216 .34709 L p F P
0 g
s
.367 .529 .885 r
.41283 .32994 m .39083 .32782 L .37918 .31014 L p F P
0 g
s
.877 .944 .58 r
.12405 .44193 m .1355 .41133 L .13975 .40587 L p F P
0 g
s
.679 .76 .269 r
.1355 .41133 m .12405 .44193 L .12252 .44587 L p F P
0 g
s
.916 .979 .753 r
.16208 .37052 m .14505 .40285 L .13975 .40587 L p F P
0 g
s
0 .207 .666 r
.15757 .50365 m .13523 .48883 L .13877 .49165 L p F P
0 g
s
0 .207 .666 r
.13877 .49165 m .16448 .50915 L .15757 .50365 L p F P
0 g
s
.653 .161 .069 r
.24012 .54247 m .20923 .52937 L .21716 .5262 L p F P
0 g
s
.653 .161 .069 r
.21716 .5262 m .24994 .53838 L .24012 .54247 L p F P
0 g
s
.854 .965 .873 r
.21294 .31693 m .19132 .34122 L .18044 .34165 L p F P
0 g
s
.89 .946 .839 r
.16208 .37052 m .18044 .34165 L .19132 .34122 L p F P
0 g
s
.202 0 .168 r
.39544 .51035 m .37286 .52492 L .37957 .50863 L p F P
0 g
s
.202 0 .168 r
.37957 .50863 m .40163 .49504 L .39544 .51035 L p F P
0 g
s
.202 .064 .459 r
.44073 .44028 m .42402 .45962 L .42431 .4394 L p F P
0 g
s
.202 .064 .459 r
.42431 .4394 m .44091 .42342 L .44073 .44028 L p F P
0 g
s
.582 .865 .995 r
.30069 .28358 m .27514 .29072 L .26022 .28472 L p F P
0 g
s
.715 .895 .961 r
.23586 .29793 m .26022 .28472 L .27514 .29072 L p F P
0 g
s
.63 .075 0 r
.2002 .5288 m .17126 .51219 L .1776 .51264 L p F P
0 g
s
.63 .075 0 r
.1776 .51264 m .20923 .52937 L .2002 .5288 L p F P
0 g
s
.679 .76 .269 r
.12252 .44587 m .1325 .41901 L .1355 .41133 L p F P
0 g
s
0 0 .078 r
.1325 .41901 m .12252 .44587 L .12171 .45074 L p F P
0 g
s
.414 0 .073 r
.33801 .54535 m .31059 .5486 L .32023 .53769 L p F P
0 g
s
.414 0 .073 r
.32023 .53769 m .3478 .53404 L .33801 .54535 L p F P
0 g
s
0 .294 .786 r
.15088 .49592 m .13181 .48489 L .13523 .48883 L p F P
0 g
s
0 .294 .786 r
.13523 .48883 m .15757 .50365 L .15088 .49592 L p F P
0 g
s
0 0 .337 r
.13093 .42855 m .12171 .45074 L .12166 .45631 L p F P
0 g
s
0 0 .078 r
.12171 .45074 m .13093 .42855 L .1325 .41901 L p F P
0 g
s
.432 .633 .939 r
.34116 .29317 m .36688 .29604 L .37918 .31014 L p F P
0 g
s
.336 .667 .975 r
.36688 .29604 m .34116 .29317 L .32712 .28216 L p F P
0 g
s
.505 .747 .982 r
.30069 .28358 m .32712 .28216 L .34116 .29317 L p F P
0 g
s
.03 .306 .796 r
.14472 .48633 m .12868 .48003 L .13181 .48489 L p F P
0 g
s
.03 .306 .796 r
.13181 .48489 m .15088 .49592 L .14472 .48633 L p F P
0 g
s
.783 .977 .911 r
.23586 .29793 m .21294 .31693 L .20046 .31725 L p F P
0 g
s
.854 .965 .873 r
.18044 .34165 m .20046 .31725 L .21294 .31693 L p F P
0 g
s
.568 .05 0 r
.26998 .55092 m .24012 .54247 L .24994 .53838 L p F P
0 g
s
.568 .05 0 r
.24994 .53838 m .28117 .5461 L .26998 .55092 L p F P
0 g
s
.916 .979 .753 r
.13975 .40587 m .15449 .37472 L .16208 .37052 L p F P
0 g
s
.831 .935 .562 r
.15449 .37472 m .13975 .40587 L .1355 .41133 L p F P
0 g
s
.367 .529 .885 r
.37918 .31014 m .40315 .31514 L .41283 .32994 L p F P
0 g
s
.298 .562 .929 r
.40315 .31514 m .37918 .31014 L .36688 .29604 L p F P
0 g
s
.88 .992 .765 r
.18044 .34165 m .16208 .37052 L .15449 .37472 L p F P
0 g
s
0 0 .337 r
.12166 .45631 m .13085 .43949 L .13093 .42855 L p F P
0 g
s
0 0 .504 r
.13085 .43949 m .12166 .45631 L .12239 .46231 L p F P
0 g
s
.091 .276 .758 r
.13941 .47533 m .12598 .47446 L .12868 .48003 L p F P
0 g
s
.091 .276 .758 r
.12868 .48003 m .14472 .48633 L .13941 .47533 L p F P
0 g
s
0 0 .504 r
.12239 .46231 m .1323 .45133 L .13085 .43949 L p F P
0 g
s
.068 .127 .617 r
.1323 .45133 m .12239 .46231 L .12385 .46846 L p F P
0 g
s
.101 .216 .698 r
.1352 .46348 m .12385 .46846 L .12598 .47446 L p F P
0 g
s
.101 .216 .698 r
.12598 .47446 m .13941 .47533 L .1352 .46348 L p F P
0 g
s
.193 0 0 r
.36336 .53607 m .33801 .54535 L .3478 .53404 L p F P
0 g
s
.193 0 0 r
.3478 .53404 m .37286 .52492 L .36336 .53607 L p F P
0 g
s
.068 .127 .617 r
.12385 .46846 m .1352 .46348 L .1323 .45133 L p F P
0 g
s
.307 .322 .713 r
.45106 .37654 m .43494 .38536 L .42907 .36583 L p F P
0 g
s
.307 .322 .713 r
.42907 .36583 m .44662 .36174 L .45106 .37654 L p F P
0 g
s
.319 .384 .772 r
.44662 .36174 m .42907 .36583 L .4216 .34709 L p F P
0 g
s
.453 0 0 r
.19049 .52446 m .16448 .50915 L .17126 .51219 L p F P
0 g
s
.453 0 0 r
.17126 .51219 m .2002 .5288 L .19049 .52446 L p F P
0 g
s
.27 .243 .643 r
.45412 .39127 m .43895 .40484 L .43494 .38536 L p F P
0 g
s
.27 .243 .643 r
.43494 .38536 m .45106 .37654 L .45412 .39127 L p F P
0 g
s
.375 .777 .984 r
.32712 .28216 m .30069 .28358 L .2861 .27758 L p F P
0 g
s
.582 .865 .995 r
.26022 .28472 m .2861 .27758 L .30069 .28358 L p F P
0 g
s
0 0 .058 r
.41572 .49052 m .39544 .51035 L .40163 .49504 L p F P
0 g
s
0 0 .058 r
.40163 .49504 m .42113 .47693 L .41572 .49052 L p F P
0 g
s
.035 0 .27 r
.43839 .45467 m .42113 .47693 L .42402 .45962 L p F P
0 g
s
.035 0 .27 r
.42402 .45962 m .44073 .44028 L .43839 .45467 L p F P
0 g
s
.541 0 0 r
.22889 .54183 m .2002 .5288 L .20923 .52937 L p F P
0 g
s
.541 0 0 r
.20923 .52937 m .24012 .54247 L .22889 .54183 L p F P
0 g
s
.319 .384 .772 r
.4216 .34709 m .44097 .34754 L .44662 .36174 L p F P
0 g
s
.308 .433 .825 r
.44097 .34754 m .4216 .34709 L .41283 .32994 L p F P
0 g
s
.644 .956 .935 r
.26022 .28472 m .23586 .29793 L .22239 .29812 L p F P
0 g
s
.783 .977 .911 r
.20046 .31725 m .22239 .29812 L .23586 .29793 L p F P
0 g
s
.419 0 0 r
.29859 .55389 m .26998 .55092 L .28117 .5461 L p F P
0 g
s
.419 0 0 r
.28117 .5461 m .31059 .5486 L .29859 .55389 L p F P
0 g
s
.201 .134 .552 r
.45563 .4053 m .44091 .42342 L .43895 .40484 L p F P
0 g
s
.201 .134 .552 r
.43895 .40484 m .45412 .39127 L .45563 .4053 L p F P
0 g
s
.831 .935 .562 r
.1355 .41133 m .14839 .3825 L .15449 .37472 L p F P
0 g
s
0 0 0 r
.14839 .3825 m .1355 .41133 L .1325 .41901 L p F P
0 g
s
.804 .996 .772 r
.20046 .31725 m .18044 .34165 L .17095 .34678 L p F P
0 g
s
.88 .992 .765 r
.15449 .37472 m .17095 .34678 L .18044 .34165 L p F P
0 g
s
.308 .433 .825 r
.41283 .32994 m .43437 .33456 L .44097 .34754 L p F P
0 g
s
.265 .47 .872 r
.43437 .33456 m .41283 .32994 L .40315 .31514 L p F P
0 g
s
0 .302 .751 r
.18057 .51652 m .15757 .50365 L .16448 .50915 L p F P
0 g
s
0 .302 .751 r
.16448 .50915 m .19049 .52446 L .18057 .51652 L p F P
0 g
s
0 0 0 r
.38664 .52076 m .36336 .53607 L .37286 .52492 L p F P
0 g
s
0 0 0 r
.37286 .52492 m .39544 .51035 L .38664 .52076 L p F P
0 g
s
.737 .903 .522 r
.17095 .34678 m .15449 .37472 L .14839 .3825 L p F P
0 g
s
.298 .562 .929 r
.36688 .29604 m .39297 .30337 L .40315 .31514 L p F P
0 g
s
.147 .556 .927 r
.39297 .30337 m .36688 .29604 L .35447 .2862 L p F P
0 g
s
.336 .667 .975 r
.32712 .28216 m .35447 .2862 L .36688 .29604 L p F P
0 g
s
.083 0 .419 r
.45554 .418 m .44073 .44028 L .44091 .42342 L p F P
0 g
s
.083 0 .419 r
.44091 .42342 m .45563 .4053 L .45554 .418 L p F P
0 g
s
.395 .849 .895 r
.2861 .27758 m .26022 .28472 L .24641 .2848 L p F P
0 g
s
.644 .956 .935 r
.22239 .29812 m .24641 .2848 L .26022 .28472 L p F P
0 g
s
.168 0 0 r
.32577 .55082 m .29859 .55389 L .31059 .5486 L p F P
0 g
s
.168 0 0 r
.31059 .5486 m .33801 .54535 L .32577 .55082 L p F P
0 g
s
.114 .62 .899 r
.35447 .2862 m .32712 .28216 L .31354 .27648 L p F P
0 g
s
.375 .777 .984 r
.2861 .27758 m .31354 .27648 L .32712 .28216 L p F P
0 g
s
.383 0 0 r
.25712 .55024 m .22889 .54183 L .24012 .54247 L p F P
0 g
s
.383 0 0 r
.24012 .54247 m .26998 .55092 L .25712 .55024 L p F P
0 g
s
0 0 0 r
.1325 .41901 m .1441 .39352 L .14839 .3825 L p F P
0 g
s
0 0 .142 r
.1441 .39352 m .1325 .41901 L .13093 .42855 L p F P
0 g
s
.3 0 0 r
.21675 .53642 m .19049 .52446 L .2002 .5288 L p F P
0 g
s
.3 0 0 r
.2002 .5288 m .22889 .54183 L .21675 .53642 L p F P
0 g
s
.646 .954 .747 r
.22239 .29812 m .20046 .31725 L .18955 .32304 L p F P
0 g
s
.804 .996 .772 r
.17095 .34678 m .18955 .32304 L .20046 .31725 L p F P
0 g
s
.009 .37 .838 r
.1709 .50532 m .15088 .49592 L .15757 .50365 L p F P
0 g
s
.009 .37 .838 r
.15757 .50365 m .18057 .51652 L .1709 .50532 L p F P
0 g
s
0 0 0 r
.43397 .4659 m .41572 .49052 L .42113 .47693 L p F P
0 g
s
0 0 0 r
.42113 .47693 m .43839 .45467 L .43397 .4659 L p F P
0 g
s
.265 .47 .872 r
.40315 .31514 m .4271 .32338 L .43437 .33456 L p F P
0 g
s
.167 .484 .9 r
.4271 .32338 m .40315 .31514 L .39297 .30337 L p F P
0 g
s
0 0 .142 r
.13093 .42855 m .14185 .40729 L .1441 .39352 L p F P
0 g
s
0 0 .385 r
.14185 .40729 m .13093 .42855 L .13085 .43949 L p F P
0 g
s
0 0 0 r
.40799 .4997 m .38664 .52076 L .39544 .51035 L p F P
0 g
s
0 0 0 r
.39544 .51035 m .41572 .49052 L .40799 .4997 L p F P
0 g
s
0 0 0 r
.35143 .54142 m .32577 .55082 L .33801 .54535 L p F P
0 g
s
0 0 0 r
.33801 .54535 m .36336 .53607 L .35143 .54142 L p F P
0 g
s
0 0 .203 r
.45383 .42879 m .43839 .45467 L .44073 .44028 L p F P
0 g
s
0 0 .203 r
.44073 .44028 m .45554 .418 L .45383 .42879 L p F P
0 g
s
.061 .626 .744 r
.31354 .27648 m .2861 .27758 L .27263 .2776 L p F P
0 g
s
.395 .849 .895 r
.24641 .2848 m .27263 .2776 L .2861 .27758 L p F P
0 g
s
.125 .367 .827 r
.16199 .49138 m .14472 .48633 L .15088 .49592 L p F P
0 g
s
.125 .367 .827 r
.15088 .49592 m .1709 .50532 L .16199 .49138 L p F P
0 g
s
.737 .903 .522 r
.14839 .3825 m .16332 .35646 L .17095 .34678 L p F P
0 g
s
0 0 0 r
.16332 .35646 m .14839 .3825 L .1441 .39352 L p F P
0 g
s
.56 .813 .44 r
.18955 .32304 m .17095 .34678 L .16332 .35646 L p F P
0 g
s
.121 0 0 r
.28473 .55318 m .25712 .55024 L .26998 .55092 L p F P
0 g
s
.121 0 0 r
.26998 .55092 m .29859 .55389 L .28473 .55318 L p F P
0 g
s
.362 .802 .642 r
.24641 .2848 m .22239 .29812 L .21063 .3043 L p F P
0 g
s
.646 .954 .747 r
.18955 .32304 m .21063 .3043 L .22239 .29812 L p F P
0 g
s
0 0 .385 r
.13085 .43949 m .14178 .42318 L .14185 .40729 L p F P
0 g
s
.076 .063 .538 r
.14178 .42318 m .13085 .43949 L .1323 .45133 L p F P
0 g
s
.147 .556 .927 r
.35447 .2862 m .38273 .29518 L .39297 .30337 L p F P
0 g
s
0 .433 .759 r
.38273 .29518 m .35447 .2862 L .3425 .28113 L p F P
0 g
s
.114 .62 .899 r
.31354 .27648 m .3425 .28113 L .35447 .2862 L p F P
0 g
s
.241 .279 .701 r
.46613 .36744 m .45106 .37654 L .44662 .36174 L p F P
0 g
s
.241 .279 .701 r
.44662 .36174 m .46334 .35817 L .46613 .36744 L p F P
0 g
s
.253 .342 .762 r
.46334 .35817 m .44662 .36174 L .44097 .34754 L p F P
0 g
s
.175 .33 .781 r
.15427 .47536 m .13941 .47533 L .14472 .48633 L p F P
0 g
s
.175 .33 .781 r
.14472 .48633 m .16199 .49138 L .15427 .47536 L p F P
0 g
s
.199 .194 .627 r
.46805 .37666 m .45412 .39127 L .45106 .37654 L p F P
0 g
s
.199 .194 .627 r
.45106 .37654 m .46613 .36744 L .46805 .37666 L p F P
0 g
s
0 .433 .854 r
.20429 .5264 m .18057 .51652 L .19049 .52446 L p F P
0 g
s
0 .433 .854 r
.19049 .52446 m .21675 .53642 L .20429 .5264 L p F P
0 g
s
.167 .484 .9 r
.39297 .30337 m .41949 .31451 L .4271 .32338 L p F P
0 g
s
0 .44 .853 r
.41949 .31451 m .39297 .30337 L .38273 .29518 L p F P
0 g
s
.076 .063 .538 r
.1323 .45133 m .1439 .44039 L .14178 .42318 L p F P
0 g
s
.149 .184 .642 r
.1439 .44039 m .1323 .45133 L .1352 .46348 L p F P
0 g
s
.253 .342 .762 r
.44097 .34754 m .45981 .34927 L .46334 .35817 L p F P
0 g
s
.236 .389 .813 r
.45981 .34927 m .44097 .34754 L .43437 .33456 L p F P
0 g
s
.181 .269 .719 r
.14814 .45808 m .1352 .46348 L .13941 .47533 L p F P
0 g
s
.181 .269 .719 r
.13941 .47533 m .15427 .47536 L .14814 .45808 L p F P
0 g
s
0 .48 .809 r
.24316 .54399 m .21675 .53642 L .22889 .54183 L p F P
0 g
s
0 .48 .809 r
.22889 .54183 m .25712 .55024 L .24316 .54399 L p F P
0 g
s
.149 .184 .642 r
.1352 .46348 m .14814 .45808 L .1439 .44039 L p F P
0 g
s
.121 .076 .529 r
.46902 .38542 m .45563 .4053 L .45412 .39127 L p F P
0 g
s
.121 .076 .529 r
.45412 .39127 m .46805 .37666 L .46902 .38542 L p F P
0 g
s
.513 .899 .738 r
.37556 .52569 m .35143 .54142 L .36336 .53607 L p F P
0 g
s
.513 .899 .738 r
.36336 .53607 m .38664 .52076 L .37556 .52569 L p F P
0 g
s
.061 .626 .744 r
.27263 .2776 m .30103 .27649 L .31354 .27648 L p F P
0 g
s
.239 0 0 r
.3425 .28113 m .31354 .27648 L .30103 .27649 L p F P
0 g
s
.236 .389 .813 r
.43437 .33456 m .4557 .34115 L .45981 .34927 L p F P
0 g
s
.18 .418 .854 r
.4557 .34115 m .43437 .33456 L .4271 .32338 L p F P
0 g
s
.622 .857 .49 r
.42762 .47342 m .40799 .4997 L .41572 .49052 L p F P
0 g
s
.622 .857 .49 r
.41572 .49052 m .43397 .4659 L .42762 .47342 L p F P
0 g
s
0 0 0 r
.45055 .43715 m .43397 .4659 L .43839 .45467 L p F P
0 g
s
0 0 0 r
.43839 .45467 m .45383 .42879 L .45055 .43715 L p F P
0 g
s
.223 .741 .852 r
.31158 .55005 m .28473 .55318 L .29859 .55389 L p F P
0 g
s
.223 .741 .852 r
.29859 .55389 m .32577 .55082 L .31158 .55005 L p F P
0 g
s
.362 .802 .642 r
.21063 .3043 m .23439 .29112 L .24641 .2848 L p F P
0 g
s
.001 0 0 r
.27263 .2776 m .24641 .2848 L .23439 .29112 L p F P
0 g
s
0 0 0 r
.1441 .39352 m .15796 .3703 L .16332 .35646 L p F P
0 g
s
0 0 .227 r
.15796 .3703 m .1441 .39352 L .14185 .40729 L p F P
0 g
s
.56 .813 .44 r
.16332 .35646 m .1808 .33415 L .18955 .32304 L p F P
0 g
s
0 0 0 r
.21063 .3043 m .18955 .32304 L .1808 .33415 L p F P
0 g
s
0 0 .382 r
.46898 .39332 m .45554 .418 L .45563 .4053 L p F P
0 g
s
0 0 .382 r
.45563 .4053 m .46902 .38542 L .46898 .39332 L p F P
0 g
s
.158 .465 .89 r
.19211 .51221 m .1709 .50532 L .18057 .51652 L p F P
0 g
s
.158 .465 .89 r
.18057 .51652 m .20429 .5264 L .19211 .51221 L p F P
0 g
s
0 0 .007 r
.1808 .33415 m .16332 .35646 L .15796 .3703 L p F P
0 g
s
.18 .418 .854 r
.4271 .32338 m .45119 .33417 L .4557 .34115 L p F P
0 g
s
.062 .416 .864 r
.45119 .33417 m .4271 .32338 L .41949 .31451 L p F P
0 g
s
.724 .984 .785 r
.39824 .50395 m .37556 .52569 L .38664 .52076 L p F P
0 g
s
.724 .984 .785 r
.38664 .52076 m .40799 .4997 L .39824 .50395 L p F P
0 g
s
0 .44 .853 r
.38273 .29518 m .41186 .30838 L .41949 .31451 L p F P
0 g
s
0 .433 .759 r
.3425 .28113 m .3729 .291 L .38273 .29518 L p F P
0 g
s
.312 0 0 r
.41186 .30838 m .38273 .29518 L .3729 .291 L p F P
0 g
s
0 0 .148 r
.46794 .4 m .45383 .42879 L .45554 .418 L p F P
0 g
s
0 0 .148 r
.45554 .418 m .46898 .39332 L .46794 .4 L p F P
0 g
s
.218 .677 .947 r
.26964 .54634 m .24316 .54399 L .25712 .55024 L p F P
0 g
s
.218 .677 .947 r
.25712 .55024 m .28473 .55318 L .26964 .54634 L p F P
0 g
s
.527 .908 .944 r
.33758 .54057 m .31158 .55005 L .32577 .55082 L p F P
0 g
s
.527 .908 .944 r
.32577 .55082 m .35143 .54142 L .33758 .54057 L p F P
0 g
s
.302 0 0 r
.30103 .27649 m .27263 .2776 L .26093 .2838 L p F P
0 g
s
.001 0 0 r
.23439 .29112 m .26093 .2838 L .27263 .2776 L p F P
0 g
s
.439 0 0 r
.3729 .291 m .3425 .28113 L .33153 .28118 L p F P
0 g
s
.239 0 0 r
.30103 .27649 m .33153 .28118 L .3425 .28113 L p F P
0 g
s
0 0 .227 r
.14185 .40729 m .15517 .38768 L .15796 .3703 L p F P
0 g
s
.08 0 .441 r
.15517 .38768 m .14185 .40729 L .14178 .42318 L p F P
0 g
s
.191 .572 .938 r
.22878 .53234 m .20429 .5264 L .21675 .53642 L p F P
0 g
s
.191 .572 .938 r
.21675 .53642 m .24316 .54399 L .22878 .53234 L p F P
0 g
s
.047 0 0 r
.23439 .29112 m .21063 .3043 L .2012 .31632 L p F P
0 g
s
0 0 0 r
.1808 .33415 m .2012 .31632 L .21063 .3043 L p F P
0 g
s
.75 .912 .537 r
.44585 .44268 m .42762 .47342 L .43397 .4659 L p F P
0 g
s
.75 .912 .537 r
.43397 .4659 m .45055 .43715 L .44585 .44268 L p F P
0 g
s
.247 .442 .856 r
.18084 .4945 m .16199 .49138 L .1709 .50532 L p F P
0 g
s
.247 .442 .856 r
.1709 .50532 m .19211 .51221 L .18084 .4945 L p F P
0 g
s
.062 .416 .864 r
.41949 .31451 m .44648 .32865 L .45119 .33417 L p F P
0 g
s
0 .344 .782 r
.44648 .32865 m .41949 .31451 L .41186 .30838 L p F P
0 g
s
.833 .998 .781 r
.41962 .4768 m .39824 .50395 L .40799 .4997 L p F P
0 g
s
.833 .998 .781 r
.40799 .4997 m .42762 .47342 L .41962 .4768 L p F P
0 g
s
.08 0 .441 r
.14178 .42318 m .15513 .4078 L .15517 .38768 L p F P
0 g
s
.192 .147 .575 r
.15513 .4078 m .14178 .42318 L .1439 .44039 L p F P
0 g
s
0 0 0 r
.46594 .40514 m .45055 .43715 L .45383 .42879 L p F P
0 g
s
0 0 0 r
.45383 .42879 m .46794 .4 L .46594 .40514 L p F P
0 g
s
.715 .965 .94 r
.36268 .52477 m .33758 .54057 L .35143 .54142 L p F P
0 g
s
.715 .965 .94 r
.35143 .54142 m .37556 .52569 L .36268 .52477 L p F P
0 g
s
.493 0 0 r
.33153 .28118 m .30103 .27649 L .29022 .28233 L p F P
0 g
s
.302 0 0 r
.26093 .2838 m .29022 .28233 L .30103 .27649 L p F P
0 g
s
0 0 .007 r
.15796 .3703 m .17466 .35015 L .1808 .33415 L p F P
0 g
s
.08 0 .314 r
.17466 .35015 m .15796 .3703 L .15517 .38768 L p F P
0 g
s
.071 0 .137 r
.2012 .31632 m .1808 .33415 L .17466 .35015 L p F P
0 g
s
.282 .396 .802 r
.17106 .47414 m .15427 .47536 L .16199 .49138 L p F P
0 g
s
.282 .396 .802 r
.16199 .49138 m .18084 .4945 L .17106 .47414 L p F P
0 g
s
.472 .81 .999 r
.29609 .54291 m .26964 .54634 L .28473 .55318 L p F P
0 g
s
.472 .81 .999 r
.28473 .55318 m .31158 .55005 L .29609 .54291 L p F P
0 g
s
.312 0 0 r
.3729 .291 m .40458 .30529 L .41186 .30838 L p F P
0 g
s
.556 0 0 r
.40458 .30529 m .3729 .291 L .36393 .2911 L p F P
0 g
s
.439 0 0 r
.33153 .28118 m .36393 .2911 L .3729 .291 L p F P
0 g
s
.197 .25 .691 r
.48068 .35807 m .46613 .36744 L .46334 .35817 L p F P
0 g
s
.197 .25 .691 r
.46334 .35817 m .47972 .35489 L .48068 .35807 L p F P
0 g
s
.209 .314 .753 r
.47972 .35489 m .46334 .35817 L .45981 .34927 L p F P
0 g
s
.313 0 .043 r
.26093 .2838 m .23439 .29112 L .22477 .30353 L p F P
0 g
s
.047 0 0 r
.2012 .31632 m .22477 .30353 L .23439 .29112 L p F P
0 g
s
.192 .147 .575 r
.1439 .44039 m .15787 .42965 L .15513 .4078 L p F P
0 g
s
.254 .256 .668 r
.15787 .42965 m .1439 .44039 L .14814 .45808 L p F P
0 g
s
.154 .162 .615 r
.48134 .36122 m .46805 .37666 L .46613 .36744 L p F P
0 g
s
.154 .162 .615 r
.46613 .36744 m .48068 .35807 L .48134 .36122 L p F P
0 g
s
.209 .314 .753 r
.45981 .34927 m .47851 .35184 L .47972 .35489 L p F P
0 g
s
.188 .359 .803 r
.47851 .35184 m .45981 .34927 L .4557 .34115 L p F P
0 g
s
.283 .335 .74 r
.16327 .45215 m .14814 .45808 L .15427 .47536 L p F P
0 g
s
.283 .335 .74 r
.15427 .47536 m .17106 .47414 L .16327 .45215 L p F P
0 g
s
0 .344 .782 r
.41186 .30838 m .44179 .32486 L .44648 .32865 L p F P
0 g
s
.423 0 0 r
.44179 .32486 m .41186 .30838 L .40458 .30529 L p F P
0 g
s
.069 .039 .512 r
.48168 .36422 m .46902 .38542 L .46805 .37666 L p F P
0 g
s
.069 .039 .512 r
.46805 .37666 m .48134 .36122 L .48168 .36422 L p F P
0 g
s
.254 .256 .668 r
.14814 .45808 m .16327 .45215 L .15787 .42965 L p F P
0 g
s
.671 .531 .685 r
.7223 .31595 m .69167 .32349 L .6845 .29648 L p F P
0 g
s
.671 .531 .685 r
.6845 .29648 m .71462 .28723 L .7223 .31595 L p F P
0 g
s
.707 .552 .676 r
.65243 .30608 m .6845 .29648 L .69167 .32349 L p F P
0 g
s
.684 .575 .727 r
.71462 .28723 m .6845 .29648 L .67536 .26984 L p F P
0 g
s
.719 .594 .716 r
.6845 .29648 m .65243 .30608 L .64427 .28234 L p F P
0 g
s
.719 .594 .716 r
.64427 .28234 m .67536 .26984 L .6845 .29648 L p F P
0 g
s
.32 .559 .922 r
.21468 .51579 m .19211 .51221 L .20429 .5264 L p F P
0 g
s
.32 .559 .922 r
.20429 .5264 m .22878 .53234 L .21468 .51579 L p F P
0 g
s
.707 .552 .676 r
.69167 .32349 m .65879 .33017 L .65243 .30608 L p F P
0 g
s
.734 .568 .668 r
.61848 .31604 m .65243 .30608 L .65879 .33017 L p F P
0 g
s
.745 .608 .705 r
.65243 .30608 m .61848 .31604 L .61167 .29628 L p F P
0 g
s
.745 .608 .705 r
.61167 .29628 m .64427 .28234 L .65243 .30608 L p F P
0 g
s
.684 .575 .727 r
.67536 .26984 m .70491 .25889 L .71462 .28723 L p F P
0 g
s
.697 .62 .766 r
.70491 .25889 m .67536 .26984 L .66463 .24469 L p F P
0 g
s
.732 .636 .752 r
.67536 .26984 m .64427 .28234 L .63465 .25995 L p F P
0 g
s
.732 .636 .752 r
.63465 .25995 m .66463 .24469 L .67536 .26984 L p F P
0 g
s
.188 .359 .803 r
.4557 .34115 m .47711 .34906 L .47851 .35184 L p F P
0 g
s
.125 .383 .839 r
.47711 .34906 m .4557 .34115 L .45119 .33417 L p F P
0 g
s
.758 .648 .74 r
.64427 .28234 m .61167 .29628 L .60361 .27767 L p F P
0 g
s
.758 .648 .74 r
.60361 .27767 m .63465 .25995 L .64427 .28234 L p F P
0 g
s
.396 .683 .976 r
.25404 .53358 m .22878 .53234 L .24316 .54399 L p F P
0 g
s
.396 .683 .976 r
.24316 .54399 m .26964 .54634 L .25404 .53358 L p F P
0 g
s
.815 .967 .902 r
.3869 .50297 m .36268 .52477 L .37556 .52569 L p F P
0 g
s
.815 .967 .902 r
.37556 .52569 m .39824 .50395 L .3869 .50297 L p F P
0 g
s
.657 .483 .638 r
.72762 .34386 m .69659 .34975 L .69167 .32349 L p F P
0 g
s
.657 .483 .638 r
.69167 .32349 m .7223 .31595 L .72762 .34386 L p F P
0 g
s
.695 .509 .631 r
.65879 .33017 m .69167 .32349 L .69659 .34975 L p F P
0 g
s
0 0 .357 r
.48167 .3669 m .46898 .39332 L .46902 .38542 L p F P
0 g
s
0 0 .357 r
.46902 .38542 m .48168 .36422 L .48167 .3669 L p F P
0 g
s
.626 .503 .693 r
.75067 .30743 m .7223 .31595 L .71462 .28723 L p F P
0 g
s
.626 .503 .693 r
.71462 .28723 m .74284 .27829 L .75067 .30743 L p F P
0 g
s
.64 .551 .738 r
.74284 .27829 m .71462 .28723 L .70491 .25889 L p F P
0 g
s
.603 .099 .026 r
.36393 .2911 m .33153 .28118 L .32209 .28644 L p F P
0 g
s
.493 0 0 r
.29022 .28233 m .32209 .28644 L .33153 .28118 L p F P
0 g
s
.888 .991 .765 r
.43991 .44509 m .41962 .4768 L .42762 .47342 L p F P
0 g
s
.888 .991 .765 r
.42762 .47342 m .44585 .44268 L .43991 .44509 L p F P
0 g
s
.817 .931 .556 r
.46306 .40849 m .44585 .44268 L .45055 .43715 L p F P
0 g
s
.817 .931 .556 r
.45055 .43715 m .46594 .40514 L .46306 .40849 L p F P
0 g
s
.695 .509 .631 r
.69659 .34975 m .66308 .35358 L .65879 .33017 L p F P
0 g
s
.724 .528 .625 r
.62375 .33609 m .65879 .33017 L .66308 .35358 L p F P
0 g
s
.734 .568 .668 r
.65879 .33017 m .62375 .33609 L .61848 .31604 L p F P
0 g
s
.64 .551 .738 r
.70491 .25889 m .733 .24952 L .74284 .27829 L p F P
0 g
s
.653 .598 .78 r
.733 .24952 m .70491 .25889 L .69358 .2321 L p F P
0 g
s
.697 .62 .766 r
.66463 .24469 m .69358 .2321 L .70491 .25889 L p F P
0 g
s
.125 .383 .839 r
.45119 .33417 m .47558 .34668 L .47711 .34906 L p F P
0 g
s
0 .371 .837 r
.47558 .34668 m .45119 .33417 L .44648 .32865 L p F P
0 g
s
.753 .58 .661 r
.5828 .32633 m .61848 .31604 L .62375 .33609 L p F P
0 g
s
.764 .617 .697 r
.61848 .31604 m .5828 .32633 L .57767 .31147 L p F P
0 g
s
.764 .617 .697 r
.57767 .31147 m .61167 .29628 L .61848 .31604 L p F P
0 g
s
.609 .451 .643 r
.75616 .33575 m .72762 .34386 L .7223 .31595 L p F P
0 g
s
.609 .451 .643 r
.7223 .31595 m .75067 .30743 L .75616 .33575 L p F P
0 g
s
.646 .868 .983 r
.32243 .53341 m .29609 .54291 L .31158 .55005 L p F P
0 g
s
.646 .868 .983 r
.31158 .55005 m .33758 .54057 L .32243 .53341 L p F P
0 g
s
.49 .061 .152 r
.29022 .28233 m .26093 .2838 L .25161 .29604 L p F P
0 g
s
.313 0 .043 r
.22477 .30353 m .25161 .29604 L .26093 .2838 L p F P
0 g
s
.712 .667 .805 r
.69358 .2321 m .66463 .24469 L .65276 .22208 L p F P
0 g
s
.748 .682 .788 r
.66463 .24469 m .63465 .25995 L .62397 .23986 L p F P
0 g
s
.748 .682 .788 r
.62397 .23986 m .65276 .22208 L .66463 .24469 L p F P
0 g
s
.777 .656 .729 r
.61167 .29628 m .57767 .31147 L .57156 .2975 L p F P
0 g
s
.777 .656 .729 r
.57156 .2975 m .60361 .27767 L .61167 .29628 L p F P
0 g
s
.08 0 .314 r
.15517 .38768 m .17149 .37034 L .17466 .35015 L p F P
0 g
s
.231 .104 .493 r
.17149 .37034 m .15517 .38768 L .15513 .4078 L p F P
0 g
s
.775 .692 .772 r
.63465 .25995 m .60361 .27767 L .59464 .26101 L p F P
0 g
s
.775 .692 .772 r
.59464 .26101 m .62397 .23986 L .63465 .25995 L p F P
0 g
s
0 0 .114 r
.48133 .36916 m .46794 .4 L .46898 .39332 L p F P
0 g
s
0 0 .114 r
.46898 .39332 m .48167 .3669 L .48133 .36916 L p F P
0 g
s
.296 0 .244 r
.22477 .30353 m .2012 .31632 L .19461 .33375 L p F P
0 g
s
.071 0 .137 r
.17466 .35015 m .19461 .33375 L .2012 .31632 L p F P
0 g
s
.724 .528 .625 r
.66308 .35358 m .62724 .35559 L .62375 .33609 L p F P
0 g
s
.744 .541 .62 r
.58673 .34142 m .62375 .33609 L .62724 .35559 L p F P
0 g
s
.753 .58 .661 r
.62375 .33609 m .58673 .34142 L .5828 .32633 L p F P
0 g
s
.423 0 0 r
.40458 .30529 m .43734 .32298 L .44179 .32486 L p F P
0 g
s
.621 .062 0 r
.43734 .32298 m .40458 .30529 L .39798 .30543 L p F P
0 g
s
.556 0 0 r
.36393 .2911 m .39798 .30543 L .40458 .30529 L p F P
0 g
s
.683 .46 .577 r
.699 .37415 m .6651 .37532 L .66308 .35358 L p F P
0 g
s
.683 .46 .577 r
.66308 .35358 m .69659 .34975 L .699 .37415 L p F P
0 g
s
.715 .483 .574 r
.62724 .35559 m .66308 .35358 L .6651 .37532 L p F P
0 g
s
.641 .429 .58 r
.73034 .3698 m .699 .37415 L .69659 .34975 L p F P
0 g
s
.641 .429 .58 r
.69659 .34975 m .72762 .34386 L .73034 .3698 L p F P
0 g
s
.653 .598 .78 r
.69358 .2321 m .72156 .2223 L .733 .24952 L p F P
0 g
s
.664 .647 .822 r
.72156 .2223 m .69358 .2321 L .68107 .20798 L p F P
0 g
s
.712 .667 .805 r
.65276 .22208 m .68107 .20798 L .69358 .2321 L p F P
0 g
s
0 .371 .837 r
.44648 .32865 m .47399 .3448 L .47558 .34668 L p F P
0 g
s
0 .285 .733 r
.47399 .3448 m .44648 .32865 L .44179 .32486 L p F P
0 g
s
.868 .954 .863 r
.4103 .47582 m .3869 .50297 L .39824 .50395 L p F P
0 g
s
.868 .954 .863 r
.39824 .50395 m .41962 .4768 L .4103 .47582 L p F P
0 g
s
.571 .47 .7 r
.7769 .29788 m .75067 .30743 L .74284 .27829 L p F P
0 g
s
.571 .47 .7 r
.74284 .27829 m .76927 .26963 L .7769 .29788 L p F P
0 g
s
.587 .52 .747 r
.76927 .26963 m .74284 .27829 L .733 .24952 L p F P
0 g
s
.793 .698 .76 r
.60361 .27767 m .57156 .2975 L .56476 .28503 L p F P
0 g
s
.793 .698 .76 r
.56476 .28503 m .59464 .26101 L .60361 .27767 L p F P
0 g
s
.376 .516 .87 r
.20159 .4951 m .18084 .4945 L .19211 .51221 L p F P
0 g
s
.376 .516 .87 r
.19211 .51221 m .21468 .51579 L .20159 .4951 L p F P
0 g
s
.266 .049 .387 r
.19461 .33375 m .17466 .35015 L .17149 .37034 L p F P
0 g
s
.667 .181 .087 r
.39798 .30543 m .36393 .2911 L .35627 .29554 L p F P
0 g
s
.603 .099 .026 r
.32209 .28644 m .35627 .29554 L .36393 .2911 L p F P
0 g
s
.587 .52 .747 r
.733 .24952 m .75975 .24172 L .76927 .26963 L p F P
0 g
s
.599 .569 .792 r
.75975 .24172 m .733 .24952 L .72156 .2223 L p F P
0 g
s
0 0 0 r
.48065 .37089 m .46594 .40514 L .46794 .4 L p F P
0 g
s
0 0 0 r
.46794 .4 m .48133 .36916 L .48065 .37089 L p F P
0 g
s
.715 .483 .574 r
.6651 .37532 m .62879 .37367 L .62724 .35559 L p F P
0 g
s
.737 .5 .57 r
.58929 .35608 m .62724 .35559 L .62879 .37367 L p F P
0 g
s
.744 .541 .62 r
.62724 .35559 m .58929 .35608 L .58673 .34142 L p F P
0 g
s
.586 .389 .581 r
.75907 .36204 m .73034 .3698 L .72762 .34386 L p F P
0 g
s
.586 .389 .581 r
.72762 .34386 m .75616 .33575 L .75907 .36204 L p F P
0 g
s
.766 .587 .656 r
.54564 .33694 m .5828 .32633 L .58673 .34142 L p F P
0 g
s
.776 .624 .691 r
.5828 .32633 m .54564 .33694 L .54244 .3277 L p F P
0 g
s
.776 .624 .691 r
.54244 .3277 m .57767 .31147 L .5828 .32633 L p F P
0 g
s
.55 .412 .646 r
.78231 .32531 m .75616 .33575 L .75067 .30743 L p F P
0 g
s
.55 .412 .646 r
.75067 .30743 m .7769 .29788 L .78231 .32531 L p F P
0 g
s
.598 .181 .221 r
.32209 .28644 m .29022 .28233 L .28165 .29388 L p F P
0 g
s
.49 .061 .152 r
.25161 .29604 m .28165 .29388 L .29022 .28233 L p F P
0 g
s
.915 .98 .75 r
.45942 .40989 m .43991 .44509 L .44585 .44268 L p F P
0 g
s
.915 .98 .75 r
.44585 .44268 m .46306 .40849 L .45942 .40989 L p F P
0 g
s
.789 .661 .722 r
.57767 .31147 m .54244 .3277 L .53862 .31902 L p F P
0 g
s
.789 .661 .722 r
.53862 .31902 m .57156 .2975 L .57767 .31147 L p F P
0 g
s
.75 .884 .94 r
.34857 .51789 m .32243 .53341 L .33758 .54057 L p F P
0 g
s
.75 .884 .94 r
.33758 .54057 m .36268 .52477 L .34857 .51789 L p F P
0 g
s
.558 .751 .968 r
.28004 .5296 m .25404 .53358 L .26964 .54634 L p F P
0 g
s
.558 .751 .968 r
.26964 .54634 m .29609 .54291 L .28004 .5296 L p F P
0 g
s
.766 .734 .823 r
.65276 .22208 m .62397 .23986 L .61268 .22297 L p F P
0 g
s
.794 .741 .804 r
.62397 .23986 m .59464 .26101 L .58514 .24706 L p F P
0 g
s
.794 .741 .804 r
.58514 .24706 m .61268 .22297 L .62397 .23986 L p F P
0 g
s
.758 .551 .616 r
.54807 .34633 m .58673 .34142 L .58929 .35608 L p F P
0 g
s
.766 .587 .656 r
.58673 .34142 m .54807 .34633 L .54564 .33694 L p F P
0 g
s
.231 .104 .493 r
.15513 .4078 m .17152 .39378 L .17149 .37034 L p F P
0 g
s
.316 .237 .606 r
.17152 .39378 m .15513 .4078 L .15787 .42965 L p F P
0 g
s
.727 .721 .845 r
.68107 .20798 m .65276 .22208 L .64024 .203 L p F P
0 g
s
.766 .734 .823 r
.61268 .22297 m .64024 .203 L .65276 .22208 L p F P
0 g
s
0 .285 .733 r
.44179 .32486 m .47241 .34352 L .47399 .3448 L p F P
0 g
s
.481 0 0 r
.47241 .34352 m .44179 .32486 L .43734 .32298 L p F P
0 g
s
.467 .633 .926 r
.23871 .51542 m .21468 .51579 L .22878 .53234 L p F P
0 g
s
.467 .633 .926 r
.22878 .53234 m .25404 .53358 L .23871 .51542 L p F P
0 g
s
.806 .702 .75 r
.57156 .2975 m .53862 .31902 L .53434 .31131 L p F P
0 g
s
.806 .702 .75 r
.53434 .31131 m .56476 .28503 L .57156 .2975 L p F P
0 g
s
.814 .746 .788 r
.59464 .26101 m .56476 .28503 L .55754 .27463 L p F P
0 g
s
.814 .746 .788 r
.55754 .27463 m .58514 .24706 L .59464 .26101 L p F P
0 g
s
.46 .129 .317 r
.25161 .29604 m .22477 .30353 L .2181 .32157 L p F P
0 g
s
.296 0 .244 r
.19461 .33375 m .2181 .32157 L .22477 .30353 L p F P
0 g
s
.599 .569 .792 r
.72156 .2223 m .74871 .2153 L .75975 .24172 L p F P
0 g
s
.606 .619 .838 r
.74871 .2153 m .72156 .2223 L .70898 .19778 L p F P
0 g
s
.664 .647 .822 r
.68107 .20798 m .70898 .19778 L .72156 .2223 L p F P
0 g
s
.896 .94 .832 r
.43301 .44421 m .4103 .47582 L .41962 .4768 L p F P
0 g
s
.896 .94 .832 r
.41962 .4768 m .43991 .44509 L .43301 .44421 L p F P
0 g
s
.394 .463 .813 r
.1902 .4713 m .17106 .47414 L .18084 .4945 L p F P
0 g
s
.394 .463 .813 r
.18084 .4945 m .20159 .4951 L .1902 .4713 L p F P
0 g
s
.849 .937 .563 r
.47969 .372 m .46306 .40849 L .46594 .40514 L p F P
0 g
s
.849 .937 .563 r
.46594 .40514 m .48065 .37089 L .47969 .372 L p F P
0 g
s
.737 .5 .57 r
.62879 .37367 m .59037 .36967 L .58929 .35608 L p F P
0 g
s
.752 .512 .568 r
.54962 .35544 m .58929 .35608 L .59037 .36967 L p F P
0 g
s
.758 .551 .616 r
.58929 .35608 m .54962 .35544 L .54807 .34633 L p F P
0 g
s
.669 .401 .507 r
.69878 .39562 m .66473 .39443 L .6651 .37532 L p F P
0 g
s
.669 .401 .507 r
.6651 .37532 m .699 .37415 L .69878 .39562 L p F P
0 g
s
.705 .431 .507 r
.62879 .37367 m .6651 .37532 L .66473 .39443 L p F P
0 g
s
.674 .702 .867 r
.70898 .19778 m .68107 .20798 L .66789 .1876 L p F P
0 g
s
.727 .721 .845 r
.64024 .203 m .66789 .1876 L .68107 .20798 L p F P
0 g
s
.621 .062 0 r
.39798 .30543 m .43333 .32312 L .43734 .32298 L p F P
0 g
s
.704 .231 .124 r
.43333 .32312 m .39798 .30543 L .39237 .30883 L p F P
0 g
s
.667 .181 .087 r
.35627 .29554 m .39237 .30883 L .39798 .30543 L p F P
0 g
s
.665 .258 .264 r
.35627 .29554 m .32209 .28644 L .31466 .29677 L p F P
0 g
s
.598 .181 .221 r
.28165 .29388 m .31466 .29677 L .32209 .28644 L p F P
0 g
s
.619 .36 .504 r
.73031 .39263 m .69878 .39562 L .699 .37415 L p F P
0 g
s
.619 .36 .504 r
.699 .37415 m .73034 .3698 L .73031 .39263 L p F P
0 g
s
.705 .431 .507 r
.66473 .39443 m .62832 .38954 L .62879 .37367 L p F P
0 g
s
.73 .453 .507 r
.59037 .36967 m .62879 .37367 L .62832 .38954 L p F P
0 g
s
.519 .341 .58 r
.78525 .35076 m .75907 .36204 L .75616 .33575 L p F P
0 g
s
.519 .341 .58 r
.75616 .33575 m .78231 .32531 L .78525 .35076 L p F P
0 g
s
.316 .237 .606 r
.15787 .42965 m .17476 .41929 L .17152 .39378 L p F P
0 g
s
.365 .33 .687 r
.17476 .41929 m .15787 .42965 L .16327 .45215 L p F P
0 g
s
.811 .882 .897 r
.37447 .49669 m .34857 .51789 L .36268 .52477 L p F P
0 g
s
.811 .882 .897 r
.36268 .52477 m .3869 .50297 L .37447 .49669 L p F P
0 g
s
.481 0 0 r
.43734 .32298 m .47092 .3429 L .47241 .34352 L p F P
0 g
s
.653 .105 0 r
.47092 .3429 m .43734 .32298 L .43333 .32312 L p F P
0 g
s
.827 .748 .777 r
.56476 .28503 m .53434 .31131 L .52981 .3049 L p F P
0 g
s
.827 .748 .777 r
.52981 .3049 m .55754 .27463 L .56476 .28503 L p F P
0 g
s
.51 .431 .703 r
.80119 .28726 m .7769 .29788 L .76927 .26963 L p F P
0 g
s
.51 .431 .703 r
.76927 .26963 m .79411 .26118 L .80119 .28726 L p F P
0 g
s
.527 .485 .752 r
.79411 .26118 m .76927 .26963 L .75975 .24172 L p F P
0 g
s
.389 .403 .753 r
.1811 .44558 m .16327 .45215 L .17106 .47414 L p F P
0 g
s
.389 .403 .753 r
.17106 .47414 m .1902 .4713 L .1811 .44558 L p F P
0 g
s
.365 .33 .687 r
.16327 .45215 m .1811 .44558 L .17476 .41929 L p F P
0 g
s
.773 .592 .653 r
.50736 .34779 m .54564 .33694 L .54807 .34633 L p F P
0 g
s
.783 .627 .687 r
.54564 .33694 m .50736 .34779 L .50627 .34465 L p F P
0 g
s
.783 .627 .687 r
.50627 .34465 m .54244 .3277 L .54564 .33694 L p F P
0 g
s
.527 .485 .752 r
.75975 .24172 m .78533 .23541 L .79411 .26118 L p F P
0 g
s
.537 .535 .8 r
.78533 .23541 m .75975 .24172 L .74871 .2153 L p F P
0 g
s
.796 .664 .717 r
.54244 .3277 m .50627 .34465 L .50496 .3417 L p F P
0 g
s
.796 .664 .717 r
.50496 .3417 m .53862 .31902 L .54244 .3277 L p F P
0 g
s
.266 .049 .387 r
.17149 .37034 m .19126 .3558 L .19461 .33375 L p F P
0 g
s
.37 .211 .531 r
.19126 .3558 m .17149 .37034 L .17152 .39378 L p F P
0 g
s
.418 .176 .438 r
.2181 .32157 m .19461 .33375 L .19126 .3558 L p F P
0 g
s
.912 .93 .811 r
.45519 .40924 m .43301 .44421 L .43991 .44509 L p F P
0 g
s
.912 .93 .811 r
.43991 .44509 m .45942 .40989 L .45519 .40924 L p F P
0 g
s
.766 .556 .614 r
.50818 .35099 m .54807 .34633 L .54962 .35544 L p F P
0 g
s
.773 .592 .653 r
.54807 .34633 m .50818 .35099 L .50736 .34779 L p F P
0 g
s
.928 .972 .741 r
.47847 .37244 m .45942 .40989 L .46306 .40849 L p F P
0 g
s
.928 .972 .741 r
.46306 .40849 m .47969 .372 L .47847 .37244 L p F P
0 g
s
.553 .308 .499 r
.75922 .38517 m .73031 .39263 L .73034 .3698 L p F P
0 g
s
.553 .308 .499 r
.73034 .3698 m .75907 .36204 L .75922 .38517 L p F P
0 g
s
.752 .512 .568 r
.59037 .36967 m .55022 .36387 L .54962 .35544 L p F P
0 g
s
.73 .453 .507 r
.62832 .38954 m .58989 .38156 L .59037 .36967 L p F P
0 g
s
.747 .467 .507 r
.55022 .36387 m .59037 .36967 L .58989 .38156 L p F P
0 g
s
.669 .785 .936 r
.3067 .52015 m .28004 .5296 L .29609 .54291 L p F P
0 g
s
.669 .785 .936 r
.29609 .54291 m .32243 .53341 L .3067 .52015 L p F P
0 g
s
.483 .367 .645 r
.80625 .31255 m .78231 .32531 L .7769 .29788 L p F P
0 g
s
.483 .367 .645 r
.7769 .29788 m .80119 .28726 L .80625 .31255 L p F P
0 g
s
.57 .236 .363 r
.28165 .29388 m .25161 .29604 L .24519 .31388 L p F P
0 g
s
.46 .129 .317 r
.2181 .32157 m .24519 .31388 L .25161 .29604 L p F P
0 g
s
.707 .308 .29 r
.39237 .30883 m .35627 .29554 L .35029 .30419 L p F P
0 g
s
.665 .258 .264 r
.31466 .29677 m .35029 .30419 L .35627 .29554 L p F P
0 g
s
.813 .704 .745 r
.53862 .31902 m .50496 .3417 L .50349 .33909 L p F P
0 g
s
.813 .704 .745 r
.50349 .33909 m .53434 .31131 L .53862 .31902 L p F P
0 g
s
.788 .796 .859 r
.64024 .203 m .61268 .22297 L .60127 .21005 L p F P
0 g
s
.819 .8 .834 r
.61268 .22297 m .58514 .24706 L .57553 .23645 L p F P
0 g
s
.819 .8 .834 r
.57553 .23645 m .60127 .21005 L .61268 .22297 L p F P
0 g
s
0 0 .349 r
.48591 .35591 m .48704 .3537 L .48639 .35529 L F
0 0 .103 r
.48659 .35563 m .48751 .35352 L .48687 .35515 L F
0 0 0 r
.48483 .36071 m .48787 .35339 L .48623 .35736 L F
.48787 .35339 m .48797 .35315 L .48794 .35328 L F
.49527 .33556 m .48794 .35328 L p .48797 .35315 L F P
0 g
s
.858 .938 .565 r
.48065 .37089 m .48794 .35328 L p .48808 .35352 L F P
0 g
s
0 0 0 r
.48133 .36916 m .48794 .35328 L p .48787 .35339 L F P
0 g
s
0 0 0 r
.48794 .35328 m .48065 .37089 L p .48787 .35339 L F P
0 g
s
0 0 .103 r
.48602 .35693 m .48794 .35328 L .48751 .35352 L F
.48167 .3669 m .48794 .35328 L p .48602 .35693 L F P
0 g
s
.858 .938 .565 r
.48794 .35328 m .48897 .3513 L .48826 .35307 L F
.48794 .35328 m .48826 .35307 L .48808 .35352 L F
.49227 .34373 m .49097 .34639 L .49623 .33448 L F
.48899 .35139 m .49037 .34793 L .49227 .34373 L F
.49037 .34793 m .49097 .34639 L .49227 .34373 L F
.48887 .35169 m .48881 .35173 L .48899 .35139 L F
.48818 .35329 m .48872 .35193 L .48887 .35169 L F
.48872 .35193 m .48881 .35173 L .48887 .35169 L F
.48881 .35173 m .49527 .33556 L .48899 .35139 L F
.48794 .35328 m .49527 .33556 L p .48897 .3513 L F P
0 g
s
.858 .938 .565 r
.48887 .35155 m .49527 .33556 L .4889 .3515 L F
.48878 .35176 m .48887 .35155 L .48879 .35176 L F
.48878 .35176 m .48879 .35176 L .48818 .35329 L F
.48887 .35155 m .4889 .3515 L .48818 .35329 L F
0 0 0 r
.48065 .37089 m .48133 .36916 L p .48483 .36071 L F P
0 g
s
0 0 0 r
.48483 .36071 m .48623 .35736 L .48065 .37089 L F
0 0 .103 r
.48133 .36916 m .48167 .3669 L p .48659 .35563 L F P
0 g
s
0 0 .103 r
.48659 .35563 m .48687 .35515 L .48133 .36916 L F
.48794 .35328 m .48133 .36916 L p .4862 .35685 L F P
0 g
s
0 0 .103 r
.48751 .35352 m .48794 .35328 L .4862 .35685 L F
.858 .938 .565 r
.48701 .35602 m .48797 .35379 L .48794 .35328 L F
.48794 .35328 m .47969 .372 L p .48701 .35602 L F P
0 g
s
.858 .938 .565 r
.48797 .35379 m .48808 .35352 L .48794 .35328 L F
.47969 .372 m .48065 .37089 L p .48701 .35602 L F P
0 g
s
.931 .97 .737 r
.47969 .372 m .48816 .35389 L .48794 .35328 L F
.4892 .35167 m .49141 .34695 L .48861 .35242 L F
.49141 .34695 m .49743 .33408 L .49006 .34941 L F
.49141 .34695 m .49006 .34941 L .48861 .35242 L F
.858 .938 .565 r
.48808 .35352 m .48828 .35306 L .48794 .35328 L F
.48828 .35306 m .48876 .35195 L .48794 .35328 L F
.48808 .35352 m .48818 .35329 L .48818 .35329 L F
.931 .97 .737 r
.48816 .35389 m .48849 .35318 L .48794 .35328 L F
.858 .938 .565 r
.48818 .35329 m .48878 .35176 L .48818 .35329 L F
.931 .97 .737 r
.48849 .35318 m .4892 .35167 L .48794 .35328 L F
.858 .938 .565 r
.49623 .33448 m .48794 .35328 L p .48914 .35105 L F P
0 g
s
0 0 0 r
.4946 .33727 m .49527 .33556 L p .48892 .35087 L F P
0 g
s
0 0 0 r
.48794 .35328 m .4946 .33727 L p .48797 .35316 L F P
0 g
s
0 0 0 r
.48794 .35328 m .48797 .35316 L .48787 .35339 L F
.922 .921 .795 r
.4887 .35331 m .48982 .35083 L .49048 .34998 L F
0 0 .349 r
.48167 .3669 m .48168 .36422 L p .48591 .35591 L F P
0 g
s
0 0 .349 r
.48591 .35591 m .48639 .35529 L .48167 .3669 L F
.48794 .35328 m .48167 .3669 L p .48704 .3537 L F P
0 g
s
.931 .97 .737 r
.48794 .35328 m .47847 .37244 L .47969 .372 L p F P
0 g
s
0 0 0 r
.48857 .3517 m .48868 .35145 L .48892 .35087 L F
.48815 .35272 m .48846 .35198 L .48857 .3517 L F
.48787 .35339 m .48813 .35277 L .48815 .35272 L F
.48813 .35277 m .48846 .35198 L .48815 .35272 L F
.48868 .35145 m .4946 .33727 L .48892 .35087 L F
.858 .938 .565 r
.49527 .33556 m .49623 .33448 L p .49097 .34639 L F P
0 g
s
.931 .97 .737 r
.49293 .3437 m .49191 .34525 L .49743 .33408 L F
.49015 .34964 m .4912 .34702 L .49293 .3437 L F
.4912 .34702 m .49191 .34525 L .49293 .3437 L F
.48905 .35198 m .48944 .3508 L .49015 .34964 L F
.48881 .3525 m .48878 .35241 L .48893 .35225 L F
.48816 .35389 m .48853 .35299 L .4886 .35296 L F
.4886 .35296 m .48869 .3526 L .48881 .3525 L F
.48853 .35299 m .48869 .3526 L .4886 .35296 L F
.48803 .35417 m .48815 .35388 L .48816 .35389 L F
0 0 .103 r
.48774 .35301 m .48919 .35001 L .4902 .34736 L F
.931 .97 .737 r
.4894 .35087 m .49623 .33448 L .48944 .3508 L F
.49623 .33448 m .49743 .33408 L p .49191 .34525 L F P
0 g
s
.931 .97 .737 r
.48944 .3508 m .49623 .33448 L .49015 .34964 L F
.48955 .35048 m .49623 .33448 L .4896 .3504 L F
.4879 .35422 m .48801 .35396 L .48789 .35447 L F
0 0 .103 r
.48794 .35328 m .48784 .35279 L .48774 .35301 L F
.931 .97 .737 r
.48927 .35097 m .49623 .33448 L .48955 .35048 L F
.48723 .35555 m .48791 .35397 L .48694 .3565 L F
0 0 0 r
.48846 .35198 m .48868 .35145 L .48857 .3517 L F
0 0 .103 r
.48763 .35325 m .48799 .35242 L .48794 .35328 L F
.4946 .33727 m .48794 .35328 L p .48799 .35242 L F P
0 g
s
0 0 .349 r
.48757 .35265 m .48794 .35328 L .48766 .35247 L F
0 0 .103 r
.48763 .35325 m .48794 .35328 L .48774 .35301 L F
.48751 .35352 m .48794 .35328 L .48763 .35325 L F
.836 .749 .768 r
.50193 .33693 m .50349 .33909 L p .48936 .35369 L F P
0 g
s
0 0 .103 r
.48751 .35352 m .48763 .35325 L .48794 .35328 L F
0 0 .349 r
.48704 .3537 m .48794 .35328 L .48747 .35285 L F
.48168 .36422 m .48794 .35328 L p .48704 .3537 L F P
0 g
s
0 0 .349 r
.48747 .35285 m .48794 .35328 L .48757 .35265 L F
.48766 .35247 m .48794 .35328 L .48775 .35231 L F
.052 .026 .506 r
.48168 .36422 m .48134 .36122 L p .48458 .35646 L F P
0 g
s
.052 .026 .506 r
.48458 .35646 m .48557 .35552 L .48168 .36422 L F
.48794 .35328 m .48168 .36422 L p .48625 .35401 L F P
0 g
s
.922 .921 .795 r
.48794 .35328 m .47705 .37218 L .47847 .37244 L p F P
0 g
s
0 0 .349 r
.48704 .3537 m .48721 .35335 L .48794 .35328 L F
.931 .97 .737 r
.48913 .3511 m .49623 .33448 L .48949 .35044 L F
0 0 .103 r
.48794 .35328 m .4888 .35082 L .48784 .35279 L F
.858 .938 .565 r
.48876 .35195 m .48914 .35105 L .48794 .35328 L F
0 0 .349 r
.48721 .35335 m .48942 .34903 L .48794 .35328 L F
.052 .026 .506 r
.4866 .3535 m .48794 .35328 L .48729 .35248 L F
.48568 .35484 m .48794 .35328 L .4866 .3535 L F
.931 .97 .737 r
.48794 .35328 m .49623 .33448 L p .4894 .35047 L F P
0 g
s
.931 .97 .737 r
.48794 .35328 m .4894 .35047 L .48812 .35348 L F
.892 .858 .801 r
.47551 .37125 m .47705 .37218 L p .48295 .36286 L F P
0 g
s
.931 .97 .737 r
.48794 .35328 m .48812 .35348 L .48799 .35378 L F
.48806 .35362 m .48836 .3529 L .4881 .35374 L F
.48836 .3529 m .48913 .3511 L .48847 .35281 L F
.48836 .3529 m .48847 .35281 L .4881 .35374 L F
.48913 .3511 m .48949 .35044 L .4881 .35374 L F
.48806 .35362 m .4881 .35374 L .4879 .35422 L F
.48801 .35396 m .48927 .35097 L .48803 .35414 L F
.48927 .35097 m .48955 .35048 L .48803 .35414 L F
.48803 .35414 m .48858 .35282 L .48803 .35417 L F
.48858 .35282 m .48955 .35048 L .48859 .35281 L F
.48858 .35282 m .48859 .35281 L .48803 .35417 L F
.48955 .35048 m .4896 .3504 L .48803 .35417 L F
.48815 .35388 m .48875 .35243 L .48816 .35389 L F
.48875 .35243 m .4894 .35087 L .48877 .35242 L F
.48875 .35243 m .48877 .35242 L .48816 .35389 L F
.4894 .35087 m .48944 .3508 L .48816 .35389 L F
.48794 .35328 m .48799 .35378 L .48676 .35665 L F
.48794 .35328 m .48676 .35665 L .48568 .35919 L F
.48791 .35397 m .4879 .35422 L .48694 .3565 L F
.48694 .3565 m .4879 .35422 L .48789 .35447 L F
.48568 .35919 m .48723 .35555 L .48694 .3565 L F
.47969 .372 m .48794 .35328 L p .48568 .35919 L F P
0 g
s
.922 .921 .795 r
.47847 .37244 m .48789 .35482 L .48794 .35328 L F
.931 .97 .737 r
.48791 .35397 m .48806 .35362 L .4879 .35422 L F
.48801 .35396 m .48803 .35414 L .48789 .35447 L F
.48789 .35447 m .48803 .35414 L .48803 .35417 L F
.922 .921 .795 r
.48789 .35482 m .48833 .35399 L .48794 .35328 L F
.48833 .35399 m .48939 .35201 L .48794 .35328 L F
.931 .97 .737 r
.48869 .3526 m .48878 .35241 L .48881 .3525 L F
.48893 .35225 m .48886 .35221 L .48905 .35198 L F
.48878 .35241 m .48886 .35221 L .48893 .35225 L F
.48886 .35221 m .48944 .3508 L .48905 .35198 L F
.49743 .33408 m .48794 .35328 L p .48861 .35242 L F P
0 g
s
.922 .921 .795 r
.49883 .33437 m .48794 .35328 L p .48939 .35201 L F P
0 g
s
.922 .921 .795 r
.4882 .35424 m .48819 .35329 L .4887 .35331 L F
.48805 .35452 m .48812 .35395 L .4882 .35424 L F
.48812 .35395 m .48819 .35329 L .4882 .35424 L F
.48802 .35416 m .48819 .35329 L .48805 .35452 L F
.48792 .35386 m .48819 .35329 L .48789 .35482 L F
.49743 .33408 m .49883 .33437 L p .49048 .34998 L F P
0 g
s
.922 .921 .795 r
.48982 .35083 m .49743 .33408 L .49048 .34998 L F
.48819 .35329 m .49743 .33408 L .4887 .35331 L F
.48794 .35328 m .49743 .33408 L p .48827 .35314 L F P
0 g
s
0 0 .349 r
.48775 .35231 m .48794 .35328 L .4879 .35201 L F
.052 .026 .506 r
.48729 .35248 m .48794 .35328 L .48779 .35174 L F
.4866 .3535 m .48684 .35314 L .48794 .35328 L F
0 0 .103 r
.48794 .35328 m .49426 .33953 L p .4888 .35082 L F P
0 g
s
0 0 .103 r
.48919 .35001 m .49426 .33953 L .48999 .34791 L F
.48999 .34791 m .49426 .33953 L .4902 .34736 L F
0 0 .349 r
.49426 .33953 m .48794 .35328 L p .48942 .34903 L F P
0 g
s
0 0 .349 r
.4879 .35201 m .48794 .35328 L .49106 .34582 L F
.48794 .35328 m .49427 .34223 L p .49106 .34582 L F P
0 g
s
.052 .026 .506 r
.49427 .34223 m .48794 .35328 L p .48684 .35314 L F P
0 g
s
.922 .921 .795 r
.48794 .35328 m .48823 .35322 L .48816 .35337 L F
.48794 .35328 m .48816 .35337 L .48361 .36282 L F
.138 .152 .611 r
.48597 .3532 m .48794 .35328 L .48773 .35158 L F
.052 .026 .506 r
.48625 .35401 m .4866 .3535 L .48794 .35328 L F
.48458 .35646 m .48625 .35401 L .48557 .35552 L F
.138 .152 .611 r
.48068 .35807 m .48794 .35328 L p .48597 .3532 L F P
0 g
s
.138 .152 .611 r
.48417 .35485 m .48536 .35376 L .48794 .35328 L F
.48536 .35376 m .48597 .3532 L .48794 .35328 L F
.922 .921 .795 r
.48794 .35328 m .48827 .35314 L .48823 .35322 L F
.138 .152 .611 r
.48597 .3532 m .48825 .3511 L .48794 .35328 L F
.892 .858 .801 r
.50035 .33533 m .48794 .35328 L p .4882 .35456 L F P
0 g
s
.922 .921 .795 r
.48789 .35482 m .48802 .35416 L .48805 .35452 L F
.48361 .36282 m .48792 .35386 L .48789 .35482 L F
.47847 .37244 m .48794 .35328 L p .48361 .36282 L F P
0 g
s
.892 .858 .801 r
.49883 .33437 m .50035 .33533 L p .4882 .35456 L F P
0 g
s
.892 .858 .801 r
.48818 .35448 m .49883 .33437 L .4882 .35456 L F
.4879 .35397 m .48803 .35374 L .48784 .35512 L F
.48803 .35374 m .49883 .33437 L .48818 .35448 L F
.48803 .35374 m .48818 .35448 L .48784 .35512 L F
.052 .026 .506 r
.48779 .35174 m .48794 .35328 L .48894 .35006 L F
.138 .152 .611 r
.48773 .35158 m .48794 .35328 L .4886 .35078 L F
.48068 .35807 m .48417 .35485 L .48794 .35328 L F
.182 .24 .688 r
.48068 .35807 m .47972 .35489 L p .48803 .35145 L F P
0 g
s
.182 .24 .688 r
.48803 .35145 m .48797 .35259 L .48068 .35807 L F
.892 .858 .801 r
.48794 .35328 m .49883 .33437 L p .4883 .35326 L F P
0 g
s
.182 .24 .688 r
.48754 .35291 m .48794 .35328 L .48723 .35315 L F
.48794 .35328 m .48068 .35807 L p .48723 .35315 L F P
0 g
s
.052 .026 .506 r
.48894 .35006 m .48794 .35328 L .49097 .34707 L F
.861 .799 .788 r
.50035 .33533 m .50193 .33693 L p .48816 .35482 L F P
0 g
s
.861 .799 .788 r
.48797 .35507 m .48815 .35477 L .48816 .35482 L F
.48815 .35477 m .50035 .33533 L .48816 .35482 L F
.182 .24 .688 r
.47972 .35489 m .48794 .35328 L p .4879 .3515 L F P
0 g
s
.194 .304 .749 r
.47972 .35489 m .47851 .35184 L p .48772 .35174 L F P
0 g
s
.892 .858 .801 r
.48784 .35512 m .48818 .35448 L .4882 .35456 L F
.48803 .35482 m .4882 .35456 L .48794 .35328 L F
.48295 .36286 m .48803 .35482 L .48794 .35328 L F
.861 .799 .788 r
.48796 .35428 m .50035 .33533 L .48797 .35507 L F
.892 .858 .801 r
.48794 .35328 m .4883 .35326 L .48822 .35341 L F
.48794 .35328 m .48822 .35341 L .48295 .36286 L F
.48295 .36286 m .4879 .35397 L .48784 .35512 L F
.48794 .35328 m .47551 .37125 L p .48295 .36286 L F P
0 g
s
.892 .858 .801 r
.47705 .37218 m .48794 .35328 L p .48295 .36286 L F P
0 g
s
.861 .799 .788 r
.48794 .35328 m .48531 .35832 L .48447 .35962 L F
.194 .304 .749 r
.48772 .35174 m .48786 .35273 L .47972 .35489 L F
.48655 .35355 m .47972 .35489 L p .48588 .35326 L F P
0 g
s
.052 .026 .506 r
.48134 .36122 m .48794 .35328 L p .48568 .35484 L F P
0 g
s
.138 .152 .611 r
.48794 .35328 m .48134 .36122 L .48068 .35807 L p F P
0 g
s
.861 .799 .788 r
.48794 .35328 m .47391 .36967 L p .48338 .36065 L F P
0 g
s
.861 .799 .788 r
.48447 .35962 m .48794 .35328 L .48338 .36065 L F
.47551 .37125 m .48794 .35328 L p .48447 .35962 L F P
0 g
s
.836 .749 .768 r
.48794 .35328 m .47233 .36753 L p .48524 .35795 L F P
0 g
s
.836 .749 .768 r
.47391 .36967 m .48794 .35328 L p .48524 .35795 L F P
0 g
s
.815 .705 .743 r
.48794 .35328 m .47084 .36492 L p .48573 .35692 L F P
0 g
s
.799 .665 .716 r
.48794 .35328 m .46951 .36196 L p .48264 .35752 L F P
0 g
s
.815 .705 .743 r
.48061 .36097 m .48794 .35328 L .48573 .35692 L F
.47233 .36753 m .48794 .35328 L p .48061 .36097 L F P
0 g
s
.799 .665 .716 r
.48539 .35659 m .48794 .35328 L .48264 .35752 L F
.861 .799 .788 r
.48447 .35962 m .49184 .35004 L .48794 .35328 L F
.50193 .33693 m .48794 .35328 L p .49184 .35004 L F P
0 g
s
.861 .799 .788 r
.48794 .35328 m .50035 .33533 L p .48907 .35258 L F P
0 g
s
.861 .799 .788 r
.48794 .35328 m .48907 .35258 L .48531 .35832 L F
.48447 .35962 m .48796 .35428 L .48797 .35507 L F
.836 .749 .768 r
.48794 .35328 m .50193 .33693 L p .4902 .35171 L F P
0 g
s
.836 .749 .768 r
.48794 .35328 m .48985 .35215 L .48524 .35795 L F
.48524 .35795 m .4922 .35076 L .48794 .35328 L F
.4922 .35076 m .49602 .34681 L .48794 .35328 L F
.50349 .33909 m .48794 .35328 L p .49602 .34681 L F P
0 g
s
.836 .749 .768 r
.48794 .35328 m .4902 .35171 L .48985 .35215 L F
.48524 .35795 m .48876 .35352 L .48936 .35369 L F
.48876 .35352 m .50193 .33693 L .48936 .35369 L F
.815 .705 .743 r
.48794 .35328 m .50349 .33909 L p .49021 .35242 L F P
0 g
s
.815 .705 .743 r
.48794 .35328 m .49021 .35242 L .48573 .35692 L F
.50496 .3417 m .48794 .35328 L p .48573 .35692 L F P
0 g
s
.799 .665 .716 r
.47983 .35977 m .48794 .35328 L .48656 .35592 L F
.47084 .36492 m .48794 .35328 L p .47983 .35977 L F P
0 g
s
.786 .628 .686 r
.48794 .35328 m .46842 .35881 L p .48402 .356 L F P
0 g
s
.786 .628 .686 r
.46951 .36196 m .48794 .35328 L p .48403 .35653 L F P
0 g
s
.776 .593 .652 r
.48367 .3558 m .48794 .35328 L .48456 .35563 L F
.815 .705 .743 r
.50349 .33909 m .50496 .3417 L p .48573 .35692 L F P
0 g
s
.799 .665 .716 r
.48539 .35659 m .48696 .35569 L .48794 .35328 L F
.786 .628 .686 r
.48674 .35551 m .48794 .35328 L .48614 .35562 L F
.48614 .35562 m .48794 .35328 L .48402 .356 L F
.48403 .35653 m .48794 .35328 L .48674 .35551 L F
.776 .593 .652 r
.48456 .35563 m .48794 .35328 L .48688 .35517 L F
.48688 .35517 m .48794 .35328 L .48466 .35522 L F
.768 .558 .613 r
.48589 .35492 m .48794 .35328 L .48701 .35488 L F
.776 .593 .652 r
.46842 .35881 m .48794 .35328 L p .48367 .3558 L F P
0 g
s
.776 .593 .652 r
.48794 .35328 m .4676 .35559 L p .48466 .35522 L F P
0 g
s
.768 .558 .613 r
.48336 .35501 m .48794 .35328 L .48589 .35492 L F
.4676 .35559 m .48794 .35328 L p .48336 .35501 L F P
0 g
s
.768 .558 .613 r
.48794 .35328 m .46709 .35248 L p .48568 .35468 L F P
0 g
s
.799 .665 .716 r
.50627 .34465 m .48712 .3553 L p .48696 .35569 L F P
0 g
s
.799 .665 .716 r
.48794 .35328 m .50496 .3417 L p .48899 .35405 L F P
0 g
s
.799 .665 .716 r
.48794 .35328 m .48899 .35405 L .48656 .35592 L F
.48656 .35592 m .49316 .35082 L .50627 .34465 L F
.50496 .3417 m .50627 .34465 L p .49316 .35082 L F P
0 g
s
.786 .628 .686 r
.48794 .35328 m .50627 .34465 L p .48674 .35551 L F P
0 g
s
.786 .628 .686 r
.48674 .35551 m .49365 .35167 L .50736 .34779 L F
.50627 .34465 m .50736 .34779 L p .49365 .35167 L F P
0 g
s
.786 .628 .686 r
.50736 .34779 m .48794 .35328 L p .48674 .35551 L F P
0 g
s
.776 .593 .652 r
.50818 .35099 m .48794 .35328 L p .48688 .35517 L F P
0 g
s
.776 .593 .652 r
.48794 .35328 m .50736 .34779 L p .48688 .35517 L F P
0 g
s
.768 .558 .613 r
.4873 .35487 m .48794 .35328 L .48568 .35468 L F
.052 .026 .506 r
.48794 .35328 m .49462 .34525 L p .49097 .34707 L F P
0 g
s
.138 .152 .611 r
.49462 .34525 m .48794 .35328 L p .48825 .3511 L F P
0 g
s
.138 .152 .611 r
.48886 .35054 m .48794 .35328 L .48986 .34962 L F
.4886 .35078 m .48794 .35328 L .48886 .35054 L F
.48794 .35328 m .49529 .34844 L p .48986 .34962 L F P
0 g
s
.182 .24 .688 r
.4879 .3515 m .48794 .35328 L .49529 .34844 L F
.4886 .35212 m .48794 .35328 L .48804 .35254 L F
.48803 .35145 m .49131 .35009 L .48797 .35259 L F
.48915 .35171 m .48794 .35328 L .4886 .35212 L F
.49131 .35009 m .48794 .35328 L .48915 .35171 L F
.49529 .34844 m .48794 .35328 L p .49131 .35009 L F P
0 g
s
.182 .24 .688 r
.48794 .35328 m .49626 .35166 L .49529 .34844 L p F P
0 g
s
.194 .304 .749 r
.48772 .35174 m .49173 .3517 L .48786 .35273 L F
.48794 .35328 m .48708 .35294 L p .48712 .35293 L F P
0 g
s
.194 .304 .749 r
.47851 .35184 m .48794 .35328 L p .48631 .35176 L F P
0 g
s
.172 .348 .799 r
.48794 .35328 m .47851 .35184 L p .48714 .35253 L F P
0 g
s
.194 .304 .749 r
.48631 .35176 m .48794 .35328 L .48799 .35174 L F
.172 .348 .799 r
.48776 .35243 m .48779 .35258 L .47851 .35184 L F
.47851 .35184 m .47711 .34906 L p .48768 .35201 L F P
0 g
s
.172 .348 .799 r
.48768 .35201 m .48776 .35243 L .47851 .35184 L F
.194 .304 .749 r
.4879 .35272 m .48794 .35328 L .48712 .35293 L F
.172 .348 .799 r
.48779 .35258 m .48794 .35328 L .48714 .35253 L F
.47711 .34906 m .48794 .35328 L p .48782 .35205 L F P
0 g
s
.106 .371 .833 r
.48794 .35328 m .47711 .34906 L p .48786 .3526 L F P
0 g
s
.763 .52 .566 r
.48794 .35328 m .46693 .34961 L p .48682 .35459 L F P
0 g
s
.763 .52 .566 r
.46709 .35248 m .48794 .35328 L p .48712 .35462 L F P
0 g
s
.759 .478 .507 r
.48794 .35328 m .46712 .34711 L p .48695 .35432 L F P
0 g
s
.106 .371 .833 r
.48786 .35255 m .48786 .3526 L .47711 .34906 L F
.759 .478 .507 r
.46693 .34961 m .48794 .35328 L p .48695 .35432 L F P
0 g
s
.106 .371 .833 r
.47711 .34906 m .47558 .34668 L p .48784 .3524 L F P
0 g
s
.106 .371 .833 r
.48784 .3524 m .48786 .35255 L .47711 .34906 L F
.756 .427 .428 r
.48794 .35328 m .46764 .34512 L p .48706 .35407 L F P
0 g
s
.756 .427 .428 r
.46712 .34711 m .48794 .35328 L p .48706 .35407 L F P
0 g
s
.75 .361 .317 r
.4777 .34961 m .48794 .35328 L .48693 .35372 L F
.46764 .34512 m .48794 .35328 L p .4777 .34961 L F P
0 g
s
.106 .371 .833 r
.47558 .34668 m .48794 .35328 L p .48768 .35232 L F P
0 g
s
0 .355 .827 r
.48759 .35266 m .4876 .35269 L .47558 .34668 L F
.47558 .34668 m .47399 .3448 L p .48771 .35267 L F P
0 g
s
0 .355 .827 r
.48771 .35267 m .48774 .35273 L .47558 .34668 L F
.75 .361 .317 r
.48794 .35328 m .46848 .34371 L p .48717 .35383 L F P
0 g
s
0 .355 .827 r
.48794 .35328 m .47558 .34668 L p .48775 .35276 L F P
0 g
s
.729 .265 .149 r
.48794 .35328 m .46959 .34296 L p .48692 .35336 L F P
0 g
s
0 .355 .827 r
.47399 .3448 m .48794 .35328 L p .48771 .35267 L F P
0 g
s
0 .265 .716 r
.47399 .3448 m .47241 .34352 L p .4876 .35292 L F P
0 g
s
0 .265 .716 r
.4876 .35292 m .48762 .35294 L .47399 .3448 L F
.729 .265 .149 r
.46848 .34371 m .48794 .35328 L p .48728 .35361 L F P
0 g
s
.776 .593 .652 r
.50736 .34779 m .50818 .35099 L p .48688 .35517 L F P
0 g
s
.768 .558 .613 r
.48891 .35481 m .48739 .35465 L p .4873 .35487 L F P
0 g
s
.768 .558 .613 r
.49351 .35464 m .50869 .35409 L .48794 .35328 L F
.50818 .35099 m .50869 .35409 L p .48701 .35488 L F P
0 g
s
.768 .558 .613 r
.48794 .35328 m .50818 .35099 L p .48701 .35488 L F P
0 g
s
.763 .52 .566 r
.48682 .35459 m .49834 .35582 L .48794 .35328 L F
.48794 .35328 m .50869 .35409 L p .48712 .35462 L F P
0 g
s
.759 .478 .507 r
.48695 .35432 m .48797 .35456 L .48794 .35328 L F
.763 .52 .566 r
.50869 .35409 m .50888 .35695 L p .48712 .35462 L F P
0 g
s
.759 .478 .507 r
.50872 .35944 m .48794 .35328 L p .48797 .35456 L F P
0 g
s
.763 .52 .566 r
.50888 .35695 m .48794 .35328 L p .49834 .35582 L F P
0 g
s
.759 .478 .507 r
.50888 .35695 m .50872 .35944 L p .48695 .35432 L F P
0 g
s
.759 .478 .507 r
.48794 .35328 m .50888 .35695 L p .48695 .35432 L F P
0 g
s
.756 .427 .428 r
.50823 .36145 m .48794 .35328 L p .48706 .35407 L F P
0 g
s
.756 .427 .428 r
.48794 .35328 m .50872 .35944 L p .48706 .35407 L F P
0 g
s
.75 .361 .317 r
.48693 .35372 m .48794 .35328 L .48788 .35415 L F
.48717 .35383 m .48813 .35426 L .48794 .35328 L F
.729 .265 .149 r
.48773 .35384 m .48794 .35328 L .48692 .35336 L F
.663 .119 0 r
.46959 .34296 m .48794 .35328 L p .48759 .35351 L F P
0 g
s
0 .265 .716 r
.48794 .35328 m .47399 .3448 L p .4878 .35306 L F P
0 g
s
.182 .24 .688 r
.48804 .35254 m .48794 .35328 L .48796 .3526 L F
.194 .304 .749 r
.48929 .35235 m .48794 .35328 L .48842 .35258 L F
.48842 .35258 m .48794 .35328 L .48795 .3527 L F
.49173 .3517 m .48794 .35328 L .48929 .35235 L F
.756 .427 .428 r
.50872 .35944 m .50823 .36145 L p .48706 .35407 L F P
0 g
s
.194 .304 .749 r
.48794 .35328 m .49748 .35474 L p .48799 .35174 L F P
0 g
s
.194 .304 .749 r
.49626 .35166 m .48794 .35328 L p .49173 .3517 L F P
0 g
s
.172 .348 .799 r
.48794 .35328 m .49889 .35756 L p .48798 .35213 L F P
0 g
s
.194 .304 .749 r
.48795 .3527 m .48794 .35328 L .4879 .35272 L F
.172 .348 .799 r
.48794 .35328 m .48798 .35213 L .48782 .35205 L F
0 .265 .716 r
.488 .35317 m .488 .35318 L .47399 .3448 L F
.663 .119 0 r
.48794 .35328 m .47092 .3429 L p .48759 .35351 L F P
0 g
s
.499 0 0 r
.48794 .35328 m .47241 .34352 L p .48718 .35295 L F P
0 g
s
.499 0 0 r
.4879 .35341 m .48794 .35328 L .48718 .35295 L F
.172 .348 .799 r
.49053 .3528 m .48794 .35328 L .48779 .35258 L F
.48963 .35255 m .48928 .3527 L .48779 .35258 L F
.48963 .35255 m .48779 .35258 L .48776 .35243 L F
.48768 .35201 m .48963 .35255 L .48776 .35243 L F
.49748 .35474 m .48794 .35328 L p .49053 .3528 L F P
0 g
s
.106 .371 .833 r
.48991 .35337 m .48989 .35365 L .49094 .35384 L F
.48768 .35232 m .48938 .35334 L .48991 .35337 L F
.48938 .35334 m .48989 .35365 L .48991 .35337 L F
.75 .361 .317 r
.50823 .36145 m .50742 .36287 L p .48788 .35415 L F P
0 g
s
.75 .361 .317 r
.48794 .35328 m .50823 .36145 L p .48788 .35415 L F P
0 g
s
.75 .361 .317 r
.50742 .36287 m .48794 .35328 L p .48813 .35426 L F P
0 g
s
.729 .265 .149 r
.48794 .35328 m .50742 .36287 L p .48819 .35402 L F P
0 g
s
.729 .265 .149 r
.50742 .36287 m .50635 .36364 L p .48728 .35361 L F P
0 g
s
.106 .371 .833 r
.50042 .35996 m .49889 .35756 L p .49094 .35384 L F P
0 g
s
.106 .371 .833 r
.48989 .35365 m .50042 .35996 L .49094 .35384 L F
.499 0 0 r
.47241 .34352 m .47092 .3429 L p .48193 .34971 L F P
0 g
s
.499 0 0 r
.48193 .34971 m .48729 .35303 L .48432 .35113 L F
.48193 .34971 m .48432 .35113 L .47241 .34352 L F
.48729 .35303 m .4879 .35341 L .48734 .35305 L F
.48729 .35303 m .48734 .35305 L .47241 .34352 L F
.106 .371 .833 r
.48794 .35328 m .50042 .35996 L p .48938 .35334 L F P
0 g
s
.106 .371 .833 r
.49889 .35756 m .48794 .35328 L p .48928 .35307 L F P
0 g
s
0 .355 .827 r
.48794 .35328 m .4902 .35427 L .48886 .3534 L F
.106 .371 .833 r
.48794 .35328 m .48938 .35334 L .48768 .35232 L F
.48876 .3529 m .48794 .35328 L .48786 .3526 L F
0 .355 .827 r
.48794 .35328 m .48886 .3534 L .48771 .35267 L F
.729 .265 .149 r
.46959 .34296 m .46848 .34371 L p .48705 .35349 L F P
0 g
s
.729 .265 .149 r
.48705 .35349 m .48773 .35384 L .48711 .35347 L F
.48705 .35349 m .48711 .35347 L .46959 .34296 L F
0 .355 .827 r
.48836 .35304 m .48834 .35305 L .4876 .35269 L F
.48836 .35304 m .4876 .35269 L .48759 .35266 L F
.729 .265 .149 r
.50635 .36364 m .48794 .35328 L p .48773 .35384 L F P
0 g
s
.663 .119 0 r
.48794 .35328 m .50635 .36364 L p .48827 .35387 L F P
0 g
s
.663 .119 0 r
.50635 .36364 m .50504 .36373 L p .48859 .35409 L F P
0 g
s
.663 .119 0 r
.48852 .35401 m .50635 .36364 L .48859 .35409 L F
0 .355 .827 r
.48794 .35328 m .50201 .36184 L p .4902 .35427 L F P
0 g
s
0 .265 .716 r
.4876 .35292 m .488 .35317 L .48762 .35294 L F
.756 .427 .428 r
.46764 .34512 m .46712 .34711 L p .48706 .35407 L F P
0 g
s
.861 .799 .788 r
.47391 .36967 m .47551 .37125 L p .48447 .35962 L F P
0 g
s
.106 .371 .833 r
.48928 .35307 m .48794 .35328 L .48876 .3529 L F
.729 .265 .149 r
.48794 .35328 m .48819 .35402 L .48728 .35361 L F
.663 .119 0 r
.50504 .36373 m .48794 .35328 L p .48759 .35351 L F P
0 g
s
.499 0 0 r
.48794 .35328 m .50504 .36373 L p .48837 .35369 L F P
0 g
s
.663 .119 0 r
.48794 .35328 m .48827 .35387 L .48759 .35351 L F
.499 0 0 r
.48794 .35328 m .48837 .35369 L .48769 .35328 L F
0 .355 .827 r
.48771 .35267 m .48836 .35304 L .48774 .35273 L F
.106 .371 .833 r
.48884 .35286 m .48876 .3529 L .48786 .3526 L F
.48884 .35286 m .48786 .3526 L .48786 .35255 L F
.75 .361 .317 r
.46848 .34371 m .46764 .34512 L p .48717 .35383 L F P
0 g
s
.836 .749 .768 r
.47233 .36753 m .47391 .36967 L p .48524 .35795 L F P
0 g
s
.759 .478 .507 r
.46712 .34711 m .46693 .34961 L p .48695 .35432 L F P
0 g
s
.763 .52 .566 r
.46693 .34961 m .46709 .35248 L p .48682 .35459 L F P
0 g
s
.815 .705 .743 r
.47084 .36492 m .47233 .36753 L p .48573 .35692 L F P
0 g
s
0 .355 .827 r
.50201 .36184 m .50042 .35996 L p .48771 .35267 L F P
0 g
s
.106 .371 .833 r
.48784 .3524 m .48884 .35286 L .48786 .35255 L F
.172 .348 .799 r
.49889 .35756 m .49748 .35474 L p .48799 .35209 L F P
0 g
s
.172 .348 .799 r
.48782 .35205 m .48798 .35213 L .48799 .35209 L F
.48798 .35213 m .49889 .35756 L .48799 .35209 L F
0 0 .103 r
.49426 .33953 m .4946 .33727 L p .4902 .34736 L F P
0 g
s
.194 .304 .749 r
.49748 .35474 m .49626 .35166 L p .48799 .35174 L F P
0 g
s
.499 0 0 r
.50504 .36373 m .50358 .36312 L p .4879 .35341 L F P
0 g
s
.499 0 0 r
.48769 .35328 m .48791 .35341 L .4879 .35341 L F
.48791 .35341 m .50504 .36373 L .4879 .35341 L F
.768 .558 .613 r
.46709 .35248 m .4676 .35559 L p .4873 .35487 L F P
0 g
s
.663 .119 0 r
.48759 .35351 m .48852 .35401 L .48859 .35409 L F
.799 .665 .716 r
.46951 .36196 m .47084 .36492 L p .48539 .35659 L F P
0 g
s
0 .355 .827 r
.48834 .35305 m .48794 .35328 L .48791 .35284 L F
0 .265 .716 r
.48779 .35304 m .48794 .35328 L .48824 .35332 L F
.48651 .35225 m .48794 .35328 L .48779 .35304 L F
0 .355 .827 r
.48791 .35284 m .48794 .35328 L .48775 .35276 L F
.052 .026 .506 r
.49462 .34525 m .49427 .34223 L p .49097 .34707 L F P
0 g
s
.776 .593 .652 r
.4676 .35559 m .46842 .35881 L p .48688 .35517 L F P
0 g
s
.786 .628 .686 r
.46842 .35881 m .46951 .36196 L p .48674 .35551 L F P
0 g
s
0 .265 .716 r
.47241 .34352 m .48794 .35328 L p .48651 .35225 L F P
0 g
s
.138 .152 .611 r
.49529 .34844 m .49462 .34525 L p .48986 .34962 L F P
0 g
s
0 .355 .827 r
.50042 .35996 m .48794 .35328 L p .48866 .35321 L F P
0 g
s
0 .265 .716 r
.50358 .36312 m .50201 .36184 L p .48824 .35332 L F P
0 g
s
0 .265 .716 r
.48794 .35328 m .50358 .36312 L p .48824 .35332 L F P
0 g
s
0 .355 .827 r
.48866 .35321 m .48794 .35328 L .48834 .35305 L F
.663 .119 0 r
.47092 .3429 m .46959 .34296 L p .48759 .35351 L F P
0 g
s
.499 0 0 r
.47092 .3429 m .48794 .35328 L p .48769 .35328 L F P
0 g
s
0 .265 .716 r
.488 .35318 m .48794 .35328 L .4878 .35306 L F
.48824 .35332 m .48794 .35328 L .488 .35318 L F
.499 0 0 r
.50358 .36312 m .48794 .35328 L p .4879 .35341 L F P
0 g
s
0 0 .349 r
.49427 .34223 m .49426 .33953 L p .49106 .34582 L F P
0 g
s
0 .265 .716 r
.488 .35317 m .48824 .35332 L .488 .35318 L F
.50201 .36184 m .48794 .35328 L p .48824 .35332 L F P
0 g
s
0 .355 .827 r
.48836 .35304 m .48866 .35321 L .48834 .35305 L F
.106 .371 .833 r
.48884 .35286 m .48928 .35307 L .48876 .3529 L F
.172 .348 .799 r
.48963 .35255 m .49053 .3528 L .48928 .3527 L F
.839 .801 .814 r
.58514 .24706 m .55754 .27463 L .55023 .26678 L p F P
0 g
s
.839 .801 .814 r
.55023 .26678 m .57553 .23645 L .58514 .24706 L p F P
0 g
s
.848 .875 .861 r
.4001 .47044 m .37447 .49669 L .3869 .50297 L p F P
0 g
s
.848 .875 .861 r
.3869 .50297 m .4103 .47582 L .4001 .47044 L p F P
0 g
s
.76 .518 .567 r
.50869 .35409 m .54962 .35544 L .55022 .36387 L p F P
0 g
s
.766 .556 .614 r
.54962 .35544 m .50869 .35409 L .50818 .35099 L p F P
0 g
s
.606 .619 .838 r
.70898 .19778 m .73662 .19149 L .74871 .2153 L p F P
0 g
s
.608 .673 .887 r
.73662 .19149 m .70898 .19778 L .69577 .17702 L p F P
0 g
s
.674 .702 .867 r
.66789 .1876 m .69577 .17702 L .70898 .19778 L p F P
0 g
s
.743 .786 .888 r
.66789 .1876 m .64024 .203 L .62758 .18834 L p F P
0 g
s
.788 .796 .859 r
.60127 .21005 m .62758 .18834 L .64024 .203 L p F P
0 g
s
.653 .105 0 r
.43333 .32312 m .46959 .34296 L .47092 .3429 L p F P
0 g
s
.723 .257 .143 r
.46959 .34296 m .43333 .32312 L .42995 .32528 L p F P
0 g
s
.704 .231 .124 r
.39237 .30883 m .42995 .32528 L .43333 .32312 L p F P
0 g
s
.493 .577 .868 r
.22444 .4927 m .20159 .4951 L .21468 .51579 L p F P
0 g
s
.493 .577 .868 r
.21468 .51579 m .23871 .51542 L .22444 .4927 L p F P
0 g
s
.834 .749 .77 r
.53434 .31131 m .50349 .33909 L .50193 .33693 L p F P
0 g
s
.834 .749 .77 r
.50193 .33693 m .52981 .3049 L .53434 .31131 L p F P
0 g
s
.852 .8 .8 r
.55754 .27463 m .52981 .3049 L .52522 .30011 L p F P
0 g
s
.852 .8 .8 r
.52522 .30011 m .55023 .26678 L .55754 .27463 L p F P
0 g
s
.537 .535 .8 r
.74871 .2153 m .7752 .21101 L .78533 .23541 L p F P
0 g
s
.538 .584 .848 r
.7752 .21101 m .74871 .2153 L .73662 .19149 L p F P
0 g
s
.583 .683 .909 r
.26423 .51066 m .23871 .51542 L .25404 .53358 L p F P
0 g
s
.583 .683 .909 r
.25404 .53358 m .28004 .5296 L .26423 .51066 L p F P
0 g
s
.76 .518 .567 r
.55022 .36387 m .50888 .35695 L .50869 .35409 L p F P
0 g
s
.747 .467 .507 r
.58989 .38156 m .54984 .37124 L .55022 .36387 L p F P
0 g
s
.756 .475 .507 r
.50888 .35695 m .55022 .36387 L .54984 .37124 L p F P
0 g
s
.732 .339 .306 r
.42995 .32528 m .39237 .30883 L .38805 .31538 L p F P
0 g
s
.707 .308 .29 r
.35029 .30419 m .38805 .31538 L .39237 .30883 L p F P
0 g
s
.692 .364 .416 r
.66194 .41003 m .62582 .40246 L .62832 .38954 L p F P
0 g
s
.692 .364 .416 r
.62832 .38954 m .66473 .39443 L .66194 .41003 L p F P
0 g
s
.722 .393 .421 r
.58989 .38156 m .62832 .38954 L .62582 .40246 L p F P
0 g
s
.92 .923 .799 r
.47705 .37218 m .45519 .40924 L .45942 .40989 L p F P
0 g
s
.92 .923 .799 r
.45942 .40989 m .47847 .37244 L .47705 .37218 L p F P
0 g
s
.869 .868 .834 r
.42546 .44004 m .4001 .47044 L .4103 .47582 L p F P
0 g
s
.869 .868 .834 r
.4103 .47582 m .43301 .44421 L .42546 .44004 L p F P
0 g
s
.648 .322 .407 r
.6959 .41317 m .66194 .41003 L .66473 .39443 L p F P
0 g
s
.648 .322 .407 r
.66473 .39443 m .69878 .39562 L .6959 .41317 L p F P
0 g
s
.643 .309 .391 r
.31466 .29677 m .28165 .29388 L .27581 .31069 L p F P
0 g
s
.57 .236 .363 r
.24519 .31388 m .27581 .31069 L .28165 .29388 L p F P
0 g
s
.471 .245 .488 r
.78556 .37311 m .75922 .38517 L .75907 .36204 L p F P
0 g
s
.471 .245 .488 r
.75907 .36204 m .78525 .35076 L .78556 .37311 L p F P
0 g
s
.722 .393 .421 r
.62582 .40246 m .58786 .3912 L .58989 .38156 L p F P
0 g
s
.742 .413 .425 r
.54984 .37124 m .58989 .38156 L .58786 .3912 L p F P
0 g
s
.442 .286 .573 r
.80907 .33597 m .78525 .35076 L .78231 .32531 L p F P
0 g
s
.442 .286 .573 r
.78231 .32531 m .80625 .31255 L .80907 .33597 L p F P
0 g
s
.681 .767 .917 r
.69577 .17702 m .66789 .1876 L .65462 .17188 L p F P
0 g
s
.743 .786 .888 r
.62758 .18834 m .65462 .17188 L .66789 .1876 L p F P
0 g
s
.742 .799 .898 r
.33391 .50527 m .3067 .52015 L .32243 .53341 L p F P
0 g
s
.742 .799 .898 r
.32243 .53341 m .34857 .51789 L .33391 .50527 L p F P
0 g
s
.859 .8 .791 r
.52981 .3049 m .50193 .33693 L .50035 .33533 L p F P
0 g
s
.859 .8 .791 r
.50035 .33533 m .52522 .30011 L .52981 .3049 L p F P
0 g
s
.585 .265 .394 r
.72747 .4113 m .6959 .41317 L .69878 .39562 L p F P
0 g
s
.585 .265 .394 r
.69878 .39562 m .73031 .39263 L .72747 .4113 L p F P
0 g
s
.37 .211 .531 r
.17152 .39378 m .19138 .38146 L .19126 .3558 L p F P
0 g
s
.43 .318 .626 r
.19138 .38146 m .17152 .39378 L .17476 .41929 L p F P
0 g
s
.883 .862 .815 r
.45057 .40657 m .42546 .44004 L .43301 .44421 L p F P
0 g
s
.883 .862 .815 r
.43301 .44421 m .45519 .40924 L .45057 .40657 L p F P
0 g
s
.531 .273 .47 r
.24519 .31388 m .2181 .32157 L .21476 .34446 L p F P
0 g
s
.418 .176 .438 r
.19126 .3558 m .21476 .34446 L .2181 .32157 L p F P
0 g
s
.723 .257 .143 r
.42995 .32528 m .46848 .34371 L .46959 .34296 L p F P
0 g
s
.745 .356 .314 r
.46848 .34371 m .42995 .32528 L .42737 .32938 L p F P
0 g
s
.732 .339 .306 r
.38805 .31538 m .42737 .32938 L .42995 .32528 L p F P
0 g
s
.742 .413 .425 r
.58786 .3912 m .54849 .37718 L .54984 .37124 L p F P
0 g
s
.753 .424 .428 r
.50872 .35944 m .54984 .37124 L .54849 .37718 L p F P
0 g
s
.756 .475 .507 r
.54984 .37124 m .50872 .35944 L .50888 .35695 L p F P
0 g
s
.691 .358 .408 r
.35029 .30419 m .31466 .29677 L .30966 .31179 L p F P
0 g
s
.643 .309 .391 r
.27581 .31069 m .30966 .31179 L .31466 .29677 L p F P
0 g
s
.497 .521 .812 r
.21198 .46655 m .1902 .4713 L .20159 .4951 L p F P
0 g
s
.497 .521 .812 r
.20159 .4951 m .22444 .4927 L .21198 .46655 L p F P
0 g
s
.869 .866 .833 r
.57553 .23645 m .55023 .26678 L .54316 .26186 L p F P
0 g
s
.882 .862 .815 r
.55023 .26678 m .52522 .30011 L .52078 .29715 L p F P
0 g
s
.882 .862 .815 r
.52078 .29715 m .54316 .26186 L .55023 .26678 L p F P
0 g
s
.889 .859 .805 r
.47551 .37125 m .45057 .40657 L .45519 .40924 L p F P
0 g
s
.889 .859 .805 r
.45519 .40924 m .47705 .37218 L .47551 .37125 L p F P
0 g
s
.846 .87 .859 r
.60127 .21005 m .57553 .23645 L .56623 .22971 L p F P
0 g
s
.869 .866 .833 r
.54316 .26186 m .56623 .22971 L .57553 .23645 L p F P
0 g
s
.889 .859 .805 r
.52522 .30011 m .50035 .33533 L .49883 .33437 L p F P
0 g
s
.889 .859 .805 r
.49883 .33437 m .52078 .29715 L .52522 .30011 L p F P
0 g
s
.444 .389 .701 r
.8238 .27557 m .80119 .28726 L .79411 .26118 L p F P
0 g
s
.444 .389 .701 r
.79411 .26118 m .81762 .25289 L .8238 .27557 L p F P
0 g
s
.463 .446 .754 r
.81762 .25289 m .79411 .26118 L .78533 .23541 L p F P
0 g
s
.484 .3 .555 r
.21476 .34446 m .19126 .3558 L .19138 .38146 L p F P
0 g
s
.538 .584 .848 r
.73662 .19149 m .76414 .18902 L .7752 .21101 L p F P
0 g
s
.529 .635 .899 r
.76414 .18902 m .73662 .19149 L .72397 .17133 L p F P
0 g
s
.608 .673 .887 r
.69577 .17702 m .72397 .17133 L .73662 .19149 L p F P
0 g
s
.789 .803 .864 r
.36155 .48531 m .33391 .50527 L .34857 .51789 L p F P
0 g
s
.789 .803 .864 r
.34857 .51789 m .37447 .49669 L .36155 .48531 L p F P
0 g
s
.753 .424 .428 r
.54849 .37718 m .50823 .36145 L .50872 .35944 L p F P
0 g
s
.722 .391 .419 r
.38805 .31538 m .35029 .30419 L .34632 .31671 L p F P
0 g
s
.691 .358 .408 r
.30966 .31179 m .34632 .31671 L .35029 .30419 L p F P
0 g
s
.745 .356 .314 r
.42737 .32938 m .46764 .34512 L .46848 .34371 L p F P
0 g
s
.5 .191 .374 r
.75656 .40407 m .72747 .4113 L .73031 .39263 L p F P
0 g
s
.5 .191 .374 r
.73031 .39263 m .75922 .38517 L .75656 .40407 L p F P
0 g
s
.81 .871 .892 r
.62758 .18834 m .60127 .21005 L .59023 .20174 L p F P
0 g
s
.846 .87 .859 r
.56623 .22971 m .59023 .20174 L .60127 .21005 L p F P
0 g
s
.463 .446 .754 r
.78533 .23541 m .80999 .23045 L .81762 .25289 L p F P
0 g
s
.471 .496 .803 r
.80999 .23045 m .78533 .23541 L .7752 .21101 L p F P
0 g
s
.742 .412 .425 r
.42737 .32938 m .38805 .31538 L .38522 .3248 L p F P
0 g
s
.722 .391 .419 r
.34632 .31671 m .38522 .3248 L .38805 .31538 L p F P
0 g
s
.598 .736 .941 r
.72397 .17133 m .69577 .17702 L .68249 .16098 L p F P
0 g
s
.681 .767 .917 r
.65462 .17188 m .68249 .16098 L .69577 .17702 L p F P
0 g
s
.43 .318 .626 r
.17476 .41929 m .19501 .40944 L .19138 .38146 L p F P
0 g
s
.466 .398 .696 r
.19501 .40944 m .17476 .41929 L .1811 .44558 L p F P
0 g
s
.732 .34 .307 r
.58437 .39814 m .54623 .38144 L .54849 .37718 L p F P
0 g
s
.732 .34 .307 r
.54849 .37718 m .58786 .3912 L .58437 .39814 L p F P
0 g
s
.745 .356 .314 r
.50823 .36145 m .54849 .37718 L .54623 .38144 L p F P
0 g
s
.745 .356 .314 r
.54623 .38144 m .50742 .36287 L .50823 .36145 L p F P
0 g
s
.753 .424 .428 r
.46764 .34512 m .42737 .32938 L .42572 .33524 L p F P
0 g
s
.753 .424 .428 r
.42572 .33524 m .46712 .34711 L .46764 .34512 L p F P
0 g
s
.742 .412 .425 r
.38522 .3248 m .42572 .33524 L .42737 .32938 L p F P
0 g
s
.412 .32 .641 r
.82826 .29754 m .80625 .31255 L .80119 .28726 L p F P
0 g
s
.412 .32 .641 r
.80119 .28726 m .8238 .27557 L .82826 .29754 L p F P
0 g
s
.668 .713 .882 r
.29117 .50132 m .26423 .51066 L .28004 .5296 L p F P
0 g
s
.668 .713 .882 r
.28004 .5296 m .3067 .52015 L .29117 .50132 L p F P
0 g
s
.708 .312 .295 r
.62138 .4118 m .58437 .39814 L .58786 .3912 L p F P
0 g
s
.708 .312 .295 r
.58786 .3912 m .62582 .40246 L .62138 .4118 L p F P
0 g
s
.859 .8 .791 r
.45057 .40657 m .47551 .37125 L .47391 .36967 L p F P
0 g
s
.92 .923 .799 r
.52078 .29715 m .49883 .33437 L .49743 .33408 L p F P
0 g
s
.488 .463 .756 r
.202 .43831 m .1811 .44558 L .1902 .4713 L p F P
0 g
s
.488 .463 .756 r
.1902 .4713 m .21198 .46655 L .202 .43831 L p F P
0 g
s
.82 .803 .836 r
.38949 .46086 m .36155 .48531 L .37447 .49669 L p F P
0 g
s
.82 .803 .836 r
.37447 .49669 m .4001 .47044 L .38949 .46086 L p F P
0 g
s
.611 .344 .488 r
.27581 .31069 m .24519 .31388 L .24206 .33653 L p F P
0 g
s
.531 .273 .47 r
.21476 .34446 m .24206 .33653 L .24519 .31388 L p F P
0 g
s
.723 .257 .143 r
.54315 .38378 m .50635 .36364 L .50742 .36287 L p F P
0 g
s
.723 .257 .143 r
.50742 .36287 m .54623 .38144 L .54315 .38378 L p F P
0 g
s
.669 .268 .277 r
.65683 .42136 m .62138 .4118 L .62582 .40246 L p F P
0 g
s
.669 .268 .277 r
.62582 .40246 m .66194 .41003 L .65683 .42136 L p F P
0 g
s
.756 .475 .507 r
.46712 .34711 m .42572 .33524 L .42508 .34259 L p F P
0 g
s
.756 .475 .507 r
.42508 .34259 m .46693 .34961 L .46712 .34711 L p F P
0 g
s
.755 .866 .929 r
.65462 .17188 m .62758 .18834 L .61536 .17883 L p F P
0 g
s
.81 .871 .892 r
.59023 .20174 m .61536 .17883 L .62758 .18834 L p F P
0 g
s
.587 .622 .853 r
.24947 .48698 m .22444 .4927 L .23871 .51542 L p F P
0 g
s
.587 .622 .853 r
.23871 .51542 m .26423 .51066 L .24947 .48698 L p F P
0 g
s
.375 .172 .472 r
.80949 .3565 m .78556 .37311 L .78525 .35076 L p F P
0 g
s
.375 .172 .472 r
.78525 .35076 m .80907 .33597 L .80949 .3565 L p F P
0 g
s
.466 .398 .696 r
.1811 .44558 m .202 .43831 L .19501 .40944 L p F P
0 g
s
.859 .8 .791 r
.47391 .36967 m .44578 .40199 L .45057 .40657 L p F P
0 g
s
.852 .801 .8 r
.42546 .44004 m .45057 .40657 L .44578 .40199 L p F P
0 g
s
.834 .749 .77 r
.44578 .40199 m .47391 .36967 L .47233 .36753 L p F P
0 g
s
.84 .802 .814 r
.41761 .43275 m .38949 .46086 L .4001 .47044 L p F P
0 g
s
.84 .802 .814 r
.4001 .47044 m .42546 .44004 L .41761 .43275 L p F P
0 g
s
.92 .923 .799 r
.49743 .33408 m .5167 .29619 L .52078 .29715 L p F P
0 g
s
.928 .972 .741 r
.5167 .29619 m .49743 .33408 L .49623 .33448 L p F P
0 g
s
.912 .929 .811 r
.54316 .26186 m .52078 .29715 L .5167 .29619 L p F P
0 g
s
.852 .801 .8 r
.44578 .40199 m .41761 .43275 L .42546 .44004 L p F P
0 g
s
.76 .518 .567 r
.46693 .34961 m .42508 .34259 L .42549 .3511 L p F P
0 g
s
.76 .518 .567 r
.42549 .3511 m .46709 .35248 L .46693 .34961 L p F P
0 g
s
.471 .496 .803 r
.7752 .21101 m .80122 .20922 L .80999 .23045 L p F P
0 g
s
.466 .543 .852 r
.80122 .20922 m .7752 .21101 L .76414 .18902 L p F P
0 g
s
.813 .704 .745 r
.44104 .3957 m .47233 .36753 L .47084 .36492 L p F P
0 g
s
.834 .749 .77 r
.47233 .36753 m .44104 .3957 L .44578 .40199 L p F P
0 g
s
.653 .106 0 r
.53938 .38409 m .50504 .36373 L .50635 .36364 L p F P
0 g
s
.653 .106 0 r
.50635 .36364 m .54315 .38378 L .53938 .38409 L p F P
0 g
s
.766 .556 .614 r
.46709 .35248 m .42549 .3511 L .42694 .36034 L p F P
0 g
s
.766 .556 .614 r
.42694 .36034 m .4676 .35559 L .46709 .35248 L p F P
0 g
s
.61 .205 .251 r
.69042 .42594 m .65683 .42136 L .66194 .41003 L p F P
0 g
s
.61 .205 .251 r
.66194 .41003 m .6959 .41317 L .69042 .42594 L p F P
0 g
s
.796 .664 .717 r
.43658 .388 m .47084 .36492 L .46951 .36196 L p F P
0 g
s
.813 .704 .745 r
.47084 .36492 m .43658 .388 L .44104 .3957 L p F P
0 g
s
.928 .972 .741 r
.49623 .33448 m .51318 .29728 L .5167 .29619 L p F P
0 g
s
.849 .937 .564 r
.51318 .29728 m .49623 .33448 L .49527 .33556 L p F P
0 g
s
.773 .592 .653 r
.4676 .35559 m .42694 .36034 L .42935 .36988 L p F P
0 g
s
.773 .592 .653 r
.42935 .36988 m .46842 .35881 L .4676 .35559 L p F P
0 g
s
.747 .467 .507 r
.42572 .33524 m .38522 .3248 L .38405 .33667 L p F P
0 g
s
.747 .467 .507 r
.38405 .33667 m .42508 .34259 L .42572 .33524 L p F P
0 g
s
.783 .627 .687 r
.43262 .37925 m .46951 .36196 L .46842 .35881 L p F P
0 g
s
.796 .664 .717 r
.46951 .36196 m .43262 .37925 L .43658 .388 L p F P
0 g
s
.783 .627 .687 r
.46842 .35881 m .42935 .36988 L .43262 .37925 L p F P
0 g
s
.704 .232 .126 r
.57955 .40202 m .54315 .38378 L .54623 .38144 L p F P
0 g
s
.704 .232 .126 r
.54623 .38144 m .58437 .39814 L .57955 .40202 L p F P
0 g
s
.389 .099 .347 r
.78318 .39134 m .75656 .40407 L .75922 .38517 L p F P
0 g
s
.389 .099 .347 r
.75922 .38517 m .78556 .37311 L .78318 .39134 L p F P
0 g
s
.896 .938 .833 r
.56623 .22971 m .54316 .26186 L .53666 .26014 L p F P
0 g
s
.912 .929 .811 r
.5167 .29619 m .53666 .26014 L .54316 .26186 L p F P
0 g
s
.481 0 0 r
.53511 .38234 m .50358 .36312 L .50504 .36373 L p F P
0 g
s
.481 0 0 r
.50504 .36373 m .53938 .38409 L .53511 .38234 L p F P
0 g
s
.36 .228 .563 r
.83079 .31784 m .80907 .33597 L .80625 .31255 L p F P
0 g
s
.36 .228 .563 r
.80625 .31255 m .82826 .29754 L .83079 .31784 L p F P
0 g
s
.666 .393 .498 r
.30966 .31179 m .27581 .31069 L .27304 .33204 L p F P
0 g
s
.611 .344 .488 r
.24206 .33653 m .27304 .33204 L .27581 .31069 L p F P
0 g
s
.849 .937 .564 r
.49527 .33556 m .51037 .30039 L .51318 .29728 L p F P
0 g
s
0 0 0 r
.51037 .30039 m .49527 .33556 L .4946 .33727 L p F P
0 g
s
.827 .748 .777 r
.41761 .43275 m .44578 .40199 L .44104 .3957 L p F P
0 g
s
.673 .846 .966 r
.68249 .16098 m .65462 .17188 L .64182 .16161 L p F P
0 g
s
.755 .866 .929 r
.61536 .17883 m .64182 .16161 L .65462 .17188 L p F P
0 g
s
.727 .73 .853 r
.31942 .48743 m .29117 .50132 L .3067 .52015 L p F P
0 g
s
.727 .73 .853 r
.3067 .52015 m .33391 .50527 L .31942 .48743 L p F P
0 g
s
.484 .3 .555 r
.19138 .38146 m .215 .37113 L .21476 .34446 L p F P
0 g
s
.525 .386 .635 r
.215 .37113 m .19138 .38146 L .19501 .40944 L p F P
0 g
s
0 .285 .733 r
.53052 .37859 m .50201 .36184 L .50358 .36312 L p F P
0 g
s
0 .285 .733 r
.50358 .36312 m .53511 .38234 L .53052 .37859 L p F P
0 g
s
.73 .452 .506 r
.38522 .3248 m .34632 .31671 L .34458 .33253 L p F P
0 g
s
.73 .452 .506 r
.34458 .33253 m .38405 .33667 L .38522 .3248 L p F P
0 g
s
.572 .368 .567 r
.24206 .33653 m .21476 .34446 L .215 .37113 L p F P
0 g
s
.522 .116 .213 r
.7219 .4249 m .69042 .42594 L .6959 .41317 L p F P
0 g
s
.522 .116 .213 r
.6959 .41317 m .72747 .4113 L .7219 .4249 L p F P
0 g
s
.704 .428 .503 r
.34632 .31671 m .30966 .31179 L .30737 .33082 L p F P
0 g
s
.666 .393 .498 r
.27304 .33204 m .30737 .33082 L .30966 .31179 L p F P
0 g
s
0 0 0 r
.4946 .33727 m .50844 .30538 L .51037 .30039 L p F P
0 g
s
0 0 .114 r
.50844 .30538 m .4946 .33727 L .49426 .33953 L p F P
0 g
s
.868 .948 .864 r
.59023 .20174 m .56623 .22971 L .55767 .22721 L p F P
0 g
s
.896 .938 .833 r
.53666 .26014 m .55767 .22721 L .56623 .22971 L p F P
0 g
s
.915 .98 .751 r
.53666 .26014 m .5167 .29619 L .51318 .29728 L p F P
0 g
s
.704 .428 .503 r
.30737 .33082 m .34458 .33253 L .34632 .31671 L p F P
0 g
s
0 .37 .837 r
.52585 .373 m .50042 .35996 L .50201 .36184 L p F P
0 g
s
0 .37 .837 r
.50201 .36184 m .53052 .37859 L .52585 .373 L p F P
0 g
s
.67 .187 .096 r
.61515 .41708 m .57955 .40202 L .58437 .39814 L p F P
0 g
s
.67 .187 .096 r
.58437 .39814 m .62138 .4118 L .61515 .41708 L p F P
0 g
s
.752 .511 .568 r
.42508 .34259 m .38405 .33667 L .38461 .35043 L p F P
0 g
s
.752 .511 .568 r
.38461 .35043 m .42549 .3511 L .42508 .34259 L p F P
0 g
s
.529 .635 .899 r
.72397 .17133 m .75262 .17041 L .76414 .18902 L p F P
0 g
s
.496 .688 .953 r
.75262 .17041 m .72397 .17133 L .7113 .15575 L p F P
0 g
s
.598 .736 .941 r
.68249 .16098 m .7113 .15575 L .72397 .17133 L p F P
0 g
s
0 0 .114 r
.49426 .33953 m .50746 .31205 L .50844 .30538 L p F P
0 g
s
0 0 .357 r
.50746 .31205 m .49426 .33953 L .49427 .34223 L p F P
0 g
s
.582 .566 .801 r
.23655 .45972 m .21198 .46655 L .22444 .4927 L p F P
0 g
s
.582 .566 .801 r
.22444 .4927 m .24947 .48698 L .23655 .45972 L p F P
0 g
s
.827 .748 .777 r
.44104 .3957 m .40985 .42266 L .41761 .43275 L p F P
0 g
s
.815 .747 .788 r
.38949 .46086 m .41761 .43275 L .40985 .42266 L p F P
0 g
s
.125 .383 .839 r
.5213 .36584 m .49889 .35756 L .50042 .35996 L p F P
0 g
s
.125 .383 .839 r
.50042 .35996 m .52585 .373 L .5213 .36584 L p F P
0 g
s
.806 .702 .75 r
.40985 .42266 m .44104 .3957 L .43658 .388 L p F P
0 g
s
.466 .543 .852 r
.76414 .18902 m .79169 .19009 L .80122 .20922 L p F P
0 g
s
.442 .589 .903 r
.79169 .19009 m .76414 .18902 L .75262 .17041 L p F P
0 g
s
.622 .065 0 r
.57361 .40261 m .53938 .38409 L .54315 .38378 L p F P
0 g
s
.622 .065 0 r
.54315 .38378 m .57955 .40202 L .57361 .40261 L p F P
0 g
s
0 0 .357 r
.49427 .34223 m .50749 .32006 L .50746 .31205 L p F P
0 g
s
.069 .039 .512 r
.50749 .32006 m .49427 .34223 L .49462 .34525 L p F P
0 g
s
.768 .739 .827 r
.34877 .46931 m .31942 .48743 L .33391 .50527 L p F P
0 g
s
.768 .739 .827 r
.33391 .50527 m .36155 .48531 L .34877 .46931 L p F P
0 g
s
.188 .359 .803 r
.51711 .35744 m .49748 .35474 L .49889 .35756 L p F P
0 g
s
.188 .359 .803 r
.49889 .35756 m .5213 .36584 L .51711 .35744 L p F P
0 g
s
.659 .652 .832 r
.27666 .4778 m .24947 .48698 L .26423 .51066 L p F P
0 g
s
.659 .652 .832 r
.26423 .51066 m .29117 .50132 L .27666 .4778 L p F P
0 g
s
.069 .039 .512 r
.49462 .34525 m .50855 .32905 L .50749 .32006 L p F P
0 g
s
.154 .162 .615 r
.50855 .32905 m .49462 .34525 L .49529 .34844 L p F P
0 g
s
.758 .551 .616 r
.42549 .3511 m .38461 .35043 L .38689 .36541 L p F P
0 g
s
.758 .551 .616 r
.38689 .36541 m .42694 .36034 L .42549 .3511 L p F P
0 g
s
.821 .956 .903 r
.61536 .17883 m .59023 .20174 L .58007 .19852 L p F P
0 g
s
.868 .948 .864 r
.55767 .22721 m .58007 .19852 L .59023 .20174 L p F P
0 g
s
.209 .313 .753 r
.51348 .34821 m .49626 .35166 L .49748 .35474 L p F P
0 g
s
.209 .313 .753 r
.49748 .35474 m .51711 .35744 L .51348 .34821 L p F P
0 g
s
.154 .162 .615 r
.49529 .34844 m .51057 .33859 L .50855 .32905 L p F P
0 g
s
.197 .25 .691 r
.51057 .33859 m .49529 .34844 L .49626 .35166 L p F P
0 g
s
.815 .747 .788 r
.40985 .42266 m .379 .44748 L .38949 .46086 L p F P
0 g
s
.796 .744 .805 r
.36155 .48531 m .38949 .46086 L .379 .44748 L p F P
0 g
s
.197 .25 .691 r
.49626 .35166 m .51348 .34821 L .51057 .33859 L p F P
0 g
s
.796 .744 .805 r
.379 .44748 m .34877 .46931 L .36155 .48531 L p F P
0 g
s
.79 .661 .722 r
.40255 .41024 m .43658 .388 L .43262 .37925 L p F P
0 g
s
.806 .702 .75 r
.43658 .388 m .40255 .41024 L .40985 .42266 L p F P
0 g
s
.613 .117 .05 r
.64958 .4278 m .61515 .41708 L .62138 .4118 L p F P
0 g
s
.613 .117 .05 r
.62138 .4118 m .65683 .42136 L .64958 .4278 L p F P
0 g
s
.396 0 .162 r
.75115 .41782 m .7219 .4249 L .72747 .4113 L p F P
0 g
s
.396 0 .162 r
.72747 .4113 m .75656 .40407 L .75115 .41782 L p F P
0 g
s
.525 .386 .635 r
.19501 .40944 m .21886 .40024 L .215 .37113 L p F P
0 g
s
.551 .453 .697 r
.21886 .40024 m .19501 .40944 L .202 .43831 L p F P
0 g
s
.557 .804 .991 r
.7113 .15575 m .68249 .16098 L .66972 .15046 L p F P
0 g
s
.673 .846 .966 r
.64182 .16161 m .66972 .15046 L .68249 .16098 L p F P
0 g
s
.737 .5 .569 r
.38405 .33667 m .34458 .33253 L .3452 .35092 L p F P
0 g
s
.737 .5 .569 r
.3452 .35092 m .38461 .35043 L .38405 .33667 L p F P
0 g
s
.636 .419 .571 r
.27304 .33204 m .24206 .33653 L .24243 .36293 L p F P
0 g
s
.572 .368 .567 r
.215 .37113 m .24243 .36293 L .24206 .33653 L p F P
0 g
s
.915 .98 .751 r
.51318 .29728 m .53103 .26174 L .53666 .26014 L p F P
0 g
s
.819 .933 .559 r
.53103 .26174 m .51318 .29728 L .51037 .30039 L p F P
0 g
s
.766 .587 .656 r
.42694 .36034 m .38689 .36541 L .39078 .38089 L p F P
0 g
s
.766 .587 .656 r
.39078 .38089 m .42935 .36988 L .42694 .36034 L p F P
0 g
s
.89 .99 .769 r
.55767 .22721 m .53666 .26014 L .53103 .26174 L p F P
0 g
s
.258 0 .31 r
.80746 .37319 m .78318 .39134 L .78556 .37311 L p F P
0 g
s
.258 0 .31 r
.78556 .37311 m .80949 .3565 L .80746 .37319 L p F P
0 g
s
.272 .096 .45 r
.83127 .33558 m .80949 .3565 L .80907 .33597 L p F P
0 g
s
.272 .096 .45 r
.80907 .33597 m .83079 .31784 L .83127 .33558 L p F P
0 g
s
.776 .624 .691 r
.39608 .39608 m .43262 .37925 L .42935 .36988 L p F P
0 g
s
.79 .661 .722 r
.43262 .37925 m .39608 .39608 L .40255 .41024 L p F P
0 g
s
.57 .511 .751 r
.22617 .4303 m .202 .43831 L .21198 .46655 L p F P
0 g
s
.57 .511 .751 r
.21198 .46655 m .23655 .45972 L .22617 .4303 L p F P
0 g
s
.776 .624 .691 r
.42935 .36988 m .39078 .38089 L .39608 .39608 L p F P
0 g
s
.382 .349 .697 r
.84508 .26286 m .8238 .27557 L .81762 .25289 L p F P
0 g
s
.382 .349 .697 r
.81762 .25289 m .84011 .24467 L .84508 .26286 L p F P
0 g
s
.402 .408 .751 r
.84011 .24467 m .81762 .25289 L .80999 .23045 L p F P
0 g
s
.402 .408 .751 r
.80999 .23045 m .83399 .22667 L .84011 .24467 L p F P
0 g
s
.407 .458 .801 r
.83399 .22667 m .80999 .23045 L .80122 .20922 L p F P
0 g
s
.551 .453 .697 r
.202 .43831 m .22617 .4303 L .21886 .40024 L p F P
0 g
s
.794 .699 .76 r
.379 .44748 m .40985 .42266 L .40255 .41024 L p F P
0 g
s
.427 0 0 r
.56681 .39984 m .53511 .38234 L .53938 .38409 L p F P
0 g
s
.427 0 0 r
.53938 .38409 m .57361 .40261 L .56681 .39984 L p F P
0 g
s
.741 .952 .946 r
.64182 .16161 m .61536 .17883 L .60413 .17501 L p F P
0 g
s
.821 .956 .903 r
.58007 .19852 m .60413 .17501 L .61536 .17883 L p F P
0 g
s
.344 .274 .633 r
.8487 .28044 m .82826 .29754 L .8238 .27557 L p F P
0 g
s
.344 .274 .633 r
.8238 .27557 m .84508 .26286 L .8487 .28044 L p F P
0 g
s
.598 .439 .636 r
.24243 .36293 m .215 .37113 L .21886 .40024 L p F P
0 g
s
.714 .482 .571 r
.34458 .33253 m .30737 .33082 L .30796 .35298 L p F P
0 g
s
.714 .482 .571 r
.30796 .35298 m .3452 .35092 L .34458 .33253 L p F P
0 g
s
.682 .456 .572 r
.30737 .33082 m .27304 .33204 L .27353 .35691 L p F P
0 g
s
.636 .419 .571 r
.24243 .36293 m .27353 .35691 L .27304 .33204 L p F P
0 g
s
.521 .011 0 r
.68253 .43324 m .64958 .4278 L .65683 .42136 L p F P
0 g
s
.521 .011 0 r
.65683 .42136 m .69042 .42594 L .68253 .43324 L p F P
0 g
s
.563 0 0 r
.60741 .41796 m .57361 .40261 L .57955 .40202 L p F P
0 g
s
.563 0 0 r
.57955 .40202 m .61515 .41708 L .60741 .41796 L p F P
0 g
s
.711 .672 .81 r
.30584 .4652 m .27666 .4778 L .29117 .50132 L p F P
0 g
s
.711 .672 .81 r
.29117 .50132 m .31942 .48743 L .30584 .4652 L p F P
0 g
s
.682 .456 .572 r
.27353 .35691 m .30796 .35298 L .30737 .33082 L p F P
0 g
s
.744 .541 .619 r
.38461 .35043 m .3452 .35092 L .34815 .37098 L p F P
0 g
s
.744 .541 .619 r
.34815 .37098 m .38689 .36541 L .38461 .35043 L p F P
0 g
s
.819 .933 .559 r
.51037 .30039 m .52656 .26663 L .53103 .26174 L p F P
0 g
s
0 0 0 r
.52656 .26663 m .51037 .30039 L .50844 .30538 L p F P
0 g
s
.407 .458 .801 r
.80122 .20922 m .827 .20963 L .83399 .22667 L p F P
0 g
s
.395 .502 .85 r
.827 .20963 m .80122 .20922 L .79169 .19009 L p F P
0 g
s
.843 .999 .792 r
.58007 .19852 m .55767 .22721 L .55026 .22915 L p F P
0 g
s
.89 .99 .769 r
.53103 .26174 m .55026 .22915 L .55767 .22721 L p F P
0 g
s
.647 .599 .786 r
.26391 .45075 m .23655 .45972 L .24947 .48698 L p F P
0 g
s
.647 .599 .786 r
.24947 .48698 m .27666 .4778 L .26391 .45075 L p F P
0 g
s
.23 0 .096 r
.77816 .40455 m .75115 .41782 L .75656 .40407 L p F P
0 g
s
.23 0 .096 r
.75656 .40407 m .78318 .39134 L .77816 .40455 L p F P
0 g
s
.794 .699 .76 r
.40255 .41024 m .36915 .43093 L .379 .44748 L p F P
0 g
s
.776 .694 .773 r
.34877 .46931 m .379 .44748 L .36915 .43093 L p F P
0 g
s
.777 .657 .73 r
.36915 .43093 m .40255 .41024 L .39608 .39608 L p F P
0 g
s
.442 .589 .903 r
.75262 .17041 m .7818 .17393 L .79169 .19009 L p F P
0 g
s
.384 .628 .95 r
.7818 .17393 m .75262 .17041 L .74112 .15603 L p F P
0 g
s
.496 .688 .953 r
.7113 .15575 m .74112 .15603 L .75262 .17041 L p F P
0 g
s
0 .342 .779 r
.55948 .3938 m .53052 .37859 L .53511 .38234 L p F P
0 g
s
0 .342 .779 r
.53511 .38234 m .56681 .39984 L .55948 .3938 L p F P
0 g
s
.749 .685 .79 r
.33679 .44944 m .30584 .4652 L .31942 .48743 L p F P
0 g
s
.749 .685 .79 r
.31942 .48743 m .34877 .46931 L .33679 .44944 L p F P
0 g
s
.281 .173 .549 r
.85079 .29665 m .83079 .31784 L .82826 .29754 L p F P
0 g
s
.281 .173 .549 r
.82826 .29754 m .8487 .28044 L .85079 .29665 L p F P
0 g
s
.753 .58 .661 r
.38689 .36541 m .34815 .37098 L .35332 .39169 L p F P
0 g
s
.753 .58 .661 r
.35332 .39169 m .39078 .38089 L .38689 .36541 L p F P
0 g
s
.776 .694 .773 r
.36915 .43093 m .33679 .44944 L .34877 .46931 L p F P
0 g
s
.411 .733 .991 r
.74112 .15603 m .7113 .15575 L .69915 .14551 L p F P
0 g
s
.557 .804 .991 r
.66972 .15046 m .69915 .14551 L .7113 .15575 L p F P
0 g
s
.611 .918 .977 r
.66972 .15046 m .64182 .16161 L .63008 .15739 L p F P
0 g
s
.741 .952 .946 r
.60413 .17501 m .63008 .15739 L .64182 .16161 L p F P
0 g
s
.764 .618 .697 r
.36044 .41202 m .39608 .39608 L .39078 .38089 L p F P
0 g
s
.777 .657 .73 r
.39608 .39608 m .36044 .41202 L .36915 .43093 L p F P
0 g
s
.76 .919 .548 r
.55026 .22915 m .53103 .26174 L .52656 .26663 L p F P
0 g
s
.378 0 0 r
.71377 .43267 m .68253 .43324 L .69042 .42594 L p F P
0 g
s
.378 0 0 r
.69042 .42594 m .7219 .4249 L .71377 .43267 L p F P
0 g
s
.598 .439 .636 r
.21886 .40024 m .24635 .39177 L .24243 .36293 L p F P
0 g
s
.618 .496 .692 r
.24635 .39177 m .21886 .40024 L .22617 .4303 L p F P
0 g
s
.764 .618 .697 r
.39078 .38089 m .35332 .39169 L .36044 .41202 L p F P
0 g
s
.654 .478 .633 r
.27353 .35691 m .24243 .36293 L .24635 .39177 L p F P
0 g
s
.724 .527 .624 r
.3452 .35092 m .30796 .35298 L .31142 .37717 L p F P
0 g
s
.724 .527 .624 r
.31142 .37717 m .34815 .37098 L .3452 .35092 L p F P
0 g
s
0 0 0 r
.50844 .30538 m .52347 .27462 L .52656 .26663 L p F P
0 g
s
0 0 .145 r
.52347 .27462 m .50844 .30538 L .50746 .31205 L p F P
0 g
s
.634 .548 .74 r
.25363 .42156 m .22617 .4303 L .23655 .45972 L p F P
0 g
s
.634 .548 .74 r
.23655 .45972 m .26391 .45075 L .25363 .42156 L p F P
0 g
s
.463 0 0 r
.64047 .42895 m .60741 .41796 L .61515 .41708 L p F P
0 g
s
.463 0 0 r
.61515 .41708 m .64958 .4278 L .64047 .42895 L p F P
0 g
s
.119 0 .268 r
.82964 .34994 m .80746 .37319 L .80949 .3565 L p F P
0 g
s
.119 0 .268 r
.80949 .3565 m .83127 .33558 L .82964 .34994 L p F P
0 g
s
.395 .502 .85 r
.79169 .19009 m .81943 .19431 L .827 .20963 L p F P
0 g
s
.358 .54 .897 r
.81943 .19431 m .79169 .19009 L .7818 .17393 L p F P
0 g
s
.759 .649 .74 r
.33679 .44944 m .36915 .43093 L .36044 .41202 L p F P
0 g
s
.618 .496 .692 r
.22617 .4303 m .25363 .42156 L .24635 .39177 L p F P
0 g
s
.757 .994 .815 r
.60413 .17501 m .58007 .19852 L .57128 .20064 L p F P
0 g
s
.843 .999 .792 r
.55026 .22915 m .57128 .20064 L .58007 .19852 L p F P
0 g
s
.059 .414 .863 r
.55195 .38474 m .52585 .373 L .53052 .37859 L p F P
0 g
s
.059 .414 .863 r
.53052 .37859 m .55948 .3938 L .55195 .38474 L p F P
0 g
s
.697 .622 .769 r
.2939 .43967 m .26391 .45075 L .27666 .4778 L p F P
0 g
s
.697 .622 .769 r
.27666 .4778 m .30584 .4652 L .2939 .43967 L p F P
0 g
s
.694 .506 .629 r
.30796 .35298 m .27353 .35691 L .27732 .38408 L p F P
0 g
s
.654 .478 .633 r
.24635 .39177 m .27732 .38408 L .27353 .35691 L p F P
0 g
s
.694 .506 .629 r
.27732 .38408 m .31142 .37717 L .30796 .35298 L p F P
0 g
s
.326 0 0 r
.59848 .41433 m .56681 .39984 L .57361 .40261 L p F P
0 g
s
.326 0 0 r
.57361 .40261 m .60741 .41796 L .59848 .41433 L p F P
0 g
s
.734 .568 .667 r
.34815 .37098 m .31142 .37717 L .31761 .40216 L p F P
0 g
s
.734 .568 .667 r
.31761 .40216 m .35332 .39169 L .34815 .37098 L p F P
0 g
s
.035 0 .02 r
.80302 .38522 m .77816 .40455 L .78318 .39134 L p F P
0 g
s
.035 0 .02 r
.78318 .39134 m .80746 .37319 L .80302 .38522 L p F P
0 g
s
0 0 .145 r
.50746 .31205 m .52193 .28536 L .52347 .27462 L p F P
0 g
s
0 0 .38 r
.52193 .28536 m .50746 .31205 L .50749 .32006 L p F P
0 g
s
.759 .649 .74 r
.36044 .41202 m .32621 .42667 L .33679 .44944 L p F P
0 g
s
.733 .638 .754 r
.30584 .4652 m .33679 .44944 L .32621 .42667 L p F P
0 g
s
.175 .026 .426 r
.85126 .31077 m .83127 .33558 L .83079 .31784 L p F P
0 g
s
.175 .026 .426 r
.83079 .31784 m .85079 .29665 L .85126 .31077 L p F P
0 g
s
.745 .608 .705 r
.32621 .42667 m .36044 .41202 L .35332 .39169 L p F P
0 g
s
.733 .638 .754 r
.32621 .42667 m .2939 .43967 L .30584 .4652 L p F P
0 g
s
.17 0 0 r
.74316 .42564 m .71377 .43267 L .7219 .4249 L p F P
0 g
s
.17 0 0 r
.7219 .4249 m .75115 .41782 L .74316 .42564 L p F P
0 g
s
.422 .833 .972 r
.69915 .14551 m .66972 .15046 L .65805 .14608 L p F P
0 g
s
.611 .918 .977 r
.63008 .15739 m .65805 .14608 L .66972 .15046 L p F P
0 g
s
.669 .528 .684 r
.27732 .38408 m .24635 .39177 L .25363 .42156 L p F P
0 g
s
.745 .608 .705 r
.35332 .39169 m .31761 .40216 L .32621 .42667 L p F P
0 g
s
.178 .417 .854 r
.5446 .37308 m .5213 .36584 L .52585 .373 L p F P
0 g
s
.178 .417 .854 r
.52585 .373 m .55195 .38474 L .5446 .37308 L p F P
0 g
s
.683 .575 .728 r
.28422 .41215 m .25363 .42156 L .26391 .45075 L p F P
0 g
s
.683 .575 .728 r
.26391 .45075 m .2939 .43967 L .28422 .41215 L p F P
0 g
s
.707 .551 .675 r
.31142 .37717 m .27732 .38408 L .28422 .41215 L p F P
0 g
s
.707 .551 .675 r
.28422 .41215 m .31761 .40216 L .31142 .37717 L p F P
0 g
s
.76 .919 .548 r
.52656 .26663 m .54438 .23551 L .55026 .22915 L p F P
0 g
s
0 0 0 r
.54438 .23551 m .52656 .26663 L .52347 .27462 L p F P
0 g
s
.654 .881 .522 r
.57128 .20064 m .55026 .22915 L .54438 .23551 L p F P
0 g
s
.302 0 0 r
.67253 .43458 m .64047 .42895 L .64958 .4278 L p F P
0 g
s
.302 0 0 r
.64958 .4278 m .68253 .43324 L .67253 .43458 L p F P
0 g
s
.669 .528 .684 r
.25363 .42156 m .28422 .41215 L .27732 .38408 L p F P
0 g
s
0 0 .38 r
.50749 .32006 m .52204 .29837 L .52193 .28536 L p F P
0 g
s
.119 .074 .528 r
.52204 .29837 m .50749 .32006 L .50855 .32905 L p F P
0 g
s
.606 .951 .819 r
.63008 .15739 m .60413 .17501 L .59443 .17721 L p F P
0 g
s
.757 .994 .815 r
.57128 .20064 m .59443 .17721 L .60413 .17501 L p F P
0 g
s
.384 .628 .95 r
.74112 .15603 m .77198 .16147 L .7818 .17393 L p F P
0 g
s
.251 .639 .962 r
.77198 .16147 m .74112 .15603 L .73015 .1466 L p F P
0 g
s
.411 .733 .991 r
.69915 .14551 m .73015 .1466 L .74112 .15603 L p F P
0 g
s
.719 .594 .716 r
.2939 .43967 m .32621 .42667 L .31761 .40216 L p F P
0 g
s
.234 .388 .813 r
.53779 .35938 m .51711 .35744 L .5213 .36584 L p F P
0 g
s
.234 .388 .813 r
.5213 .36584 m .5446 .37308 L .53779 .35938 L p F P
0 g
s
.719 .594 .716 r
.31761 .40216 m .28422 .41215 L .2939 .43967 L p F P
0 g
s
.358 .54 .897 r
.7818 .17393 m .81161 .18138 L .81943 .19431 L p F P
0 g
s
.275 .563 .933 r
.81161 .18138 m .7818 .17393 L .77198 .16147 L p F P
0 g
s
.328 .314 .69 r
.86545 .24921 m .84508 .26286 L .84011 .24467 L p F P
0 g
s
.328 .314 .69 r
.84011 .24467 m .86194 .23645 L .86545 .24921 L p F P
0 g
s
.35 .375 .746 r
.86194 .23645 m .84011 .24467 L .83399 .22667 L p F P
0 g
s
.119 .074 .528 r
.50855 .32905 m .52379 .31301 L .52204 .29837 L p F P
0 g
s
.198 .193 .627 r
.52379 .31301 m .50855 .32905 L .51057 .33859 L p F P
0 g
s
0 .432 .847 r
.58879 .40629 m .55948 .3938 L .56681 .39984 L p F P
0 g
s
0 .432 .847 r
.56681 .39984 m .59848 .41433 L .58879 .40629 L p F P
0 g
s
.35 .375 .746 r
.83399 .22667 m .85765 .22381 L .86194 .23645 L p F P
0 g
s
.353 .425 .796 r
.85765 .22381 m .83399 .22667 L .827 .20963 L p F P
0 g
s
.251 .341 .761 r
.53187 .34429 m .51348 .34821 L .51711 .35744 L p F P
0 g
s
.251 .341 .761 r
.51711 .35744 m .53779 .35938 L .53187 .34429 L p F P
0 g
s
.198 .193 .627 r
.51057 .33859 m .52712 .32857 L .52379 .31301 L p F P
0 g
s
.239 .278 .701 r
.52712 .32857 m .51057 .33859 L .51348 .34821 L p F P
0 g
s
.286 .235 .623 r
.86801 .26152 m .8487 .28044 L .84508 .26286 L p F P
0 g
s
.286 .235 .623 r
.84508 .26286 m .86545 .24921 L .86801 .26152 L p F P
0 g
s
0 0 0 r
.77066 .41202 m .74316 .42564 L .75115 .41782 L p F P
0 g
s
0 0 0 r
.75115 .41782 m .77816 .40455 L .77066 .41202 L p F P
0 g
s
.239 .278 .701 r
.51348 .34821 m .53187 .34429 L .52712 .32857 L p F P
0 g
s
0 .406 .728 r
.6299 .42464 m .59848 .41433 L .60741 .41796 L p F P
0 g
s
0 .406 .728 r
.60741 .41796 m .64047 .42895 L .6299 .42464 L p F P
0 g
s
.194 .694 .912 r
.73015 .1466 m .69915 .14551 L .6881 .14122 L p F P
0 g
s
.422 .833 .972 r
.65805 .14608 m .6881 .14122 L .69915 .14551 L p F P
0 g
s
.353 .425 .796 r
.827 .20963 m .85277 .21186 L .85765 .22381 L p F P
0 g
s
.334 .466 .844 r
.85277 .21186 m .827 .20963 L .81943 .19431 L p F P
0 g
s
0 0 0 r
.82594 .36022 m .80302 .38522 L .80746 .37319 L p F P
0 g
s
0 0 0 r
.80746 .37319 m .82964 .34994 L .82594 .36022 L p F P
0 g
s
0 0 .226 r
.85005 .32213 m .82964 .34994 L .83127 .33558 L p F P
0 g
s
0 0 .226 r
.83127 .33558 m .85126 .31077 L .85005 .32213 L p F P
0 g
s
.064 0 0 r
.70339 .4341 m .67253 .43458 L .68253 .43324 L p F P
0 g
s
.064 0 0 r
.68253 .43324 m .71377 .43267 L .70339 .4341 L p F P
0 g
s
.371 .834 .774 r
.65805 .14608 m .63008 .15739 L .61997 .15957 L p F P
0 g
s
.606 .951 .819 r
.59443 .17721 m .61997 .15957 L .63008 .15739 L p F P
0 g
s
0 0 0 r
.52347 .27462 m .54033 .24607 L .54438 .23551 L p F P
0 g
s
0 0 .193 r
.54033 .24607 m .52347 .27462 L .52193 .28536 L p F P
0 g
s
.214 .126 .535 r
.86952 .27284 m .85079 .29665 L .8487 .28044 L p F P
0 g
s
.214 .126 .535 r
.8487 .28044 m .86801 .26152 L .86952 .27284 L p F P
0 g
s
.654 .881 .522 r
.54438 .23551 m .56432 .20813 L .57128 .20064 L p F P
0 g
s
0 0 0 r
.59443 .17721 m .57128 .20064 L .56432 .20813 L p F P
0 g
s
.158 .48 .898 r
.57879 .39415 m .55195 .38474 L .55948 .3938 L p F P
0 g
s
.158 .48 .898 r
.55948 .3938 m .58879 .40629 L .57879 .39415 L p F P
0 g
s
.334 .466 .844 r
.81943 .19431 m .84752 .20112 L .85277 .21186 L p F P
0 g
s
.286 .496 .886 r
.84752 .20112 m .81943 .19431 L .81161 .18138 L p F P
0 g
s
0 0 0 r
.56432 .20813 m .54438 .23551 L .54033 .24607 L p F P
0 g
s
0 0 0 r
.79632 .39194 m .77066 .41202 L .77816 .40455 L p F P
0 g
s
0 0 0 r
.77816 .40455 m .80302 .38522 L .79632 .39194 L p F P
0 g
s
.275 .563 .933 r
.77198 .16147 m .80389 .17145 L .81161 .18138 L p F P
0 g
s
.103 .539 .912 r
.80389 .17145 m .77198 .16147 L .76266 .15332 L p F P
0 g
s
.251 .639 .962 r
.73015 .1466 m .76266 .15332 L .77198 .16147 L p F P
0 g
s
.093 0 .403 r
.8699 .28265 m .85126 .31077 L .85079 .29665 L p F P
0 g
s
.093 0 .403 r
.85079 .29665 m .86952 .27284 L .8699 .28265 L p F P
0 g
s
.048 .582 .857 r
.66087 .42976 m .6299 .42464 L .64047 .42895 L p F P
0 g
s
.048 .582 .857 r
.64047 .42895 m .67253 .43458 L .66087 .42976 L p F P
0 g
s
.226 .745 .758 r
.73289 .42703 m .70339 .4341 L .71377 .43267 L p F P
0 g
s
.226 .745 .758 r
.71377 .43267 m .74316 .42564 L .73289 .42703 L p F P
0 g
s
.371 .834 .774 r
.61997 .15957 m .64803 .14819 L .65805 .14608 L p F P
0 g
s
0 0 0 r
.6881 .14122 m .65805 .14608 L .64803 .14819 L p F P
0 g
s
0 .531 .812 r
.76266 .15332 m .73015 .1466 L .72021 .14266 L p F P
0 g
s
.194 .694 .912 r
.6881 .14122 m .72021 .14266 L .73015 .1466 L p F P
0 g
s
0 0 .193 r
.52193 .28536 m .53834 .26038 L .54033 .24607 L p F P
0 g
s
.074 0 .413 r
.53834 .26038 m .52193 .28536 L .52204 .29837 L p F P
0 g
s
.12 .544 .918 r
.61835 .41495 m .58879 .40629 L .59848 .41433 L p F P
0 g
s
.12 .544 .918 r
.59848 .41433 m .6299 .42464 L .61835 .41495 L p F P
0 g
s
0 0 0 r
.61997 .15957 m .59443 .17721 L .58677 .18546 L p F P
0 g
s
0 0 0 r
.56432 .20813 m .58677 .18546 L .59443 .17721 L p F P
0 g
s
.258 .467 .872 r
.56898 .37847 m .5446 .37308 L .55195 .38474 L p F P
0 g
s
.258 .467 .872 r
.55195 .38474 m .57879 .39415 L .56898 .37847 L p F P
0 g
s
0 0 0 r
.8472 .33018 m .82594 .36022 L .82964 .34994 L p F P
0 g
s
0 0 0 r
.82964 .34994 m .85005 .32213 L .8472 .33018 L p F P
0 g
s
.286 .496 .886 r
.81161 .18138 m .84211 .19208 L .84752 .20112 L p F P
0 g
s
.183 .504 .91 r
.84211 .19208 m .81161 .18138 L .80389 .17145 L p F P
0 g
s
.074 0 .413 r
.52204 .29837 m .53855 .2778 L .53834 .26038 L p F P
0 g
s
.194 .128 .549 r
.53855 .2778 m .52204 .29837 L .52379 .31301 L p F P
0 g
s
.549 .84 .512 r
.82029 .36586 m .79632 .39194 L .80302 .38522 L p F P
0 g
s
.549 .84 .512 r
.80302 .38522 m .82594 .36022 L .82029 .36586 L p F P
0 g
s
0 0 .19 r
.86911 .2905 m .85005 .32213 L .85126 .31077 L p F P
0 g
s
0 0 .19 r
.85126 .31077 m .8699 .28265 L .86911 .2905 L p F P
0 g
s
.494 .904 .833 r
.76096 .41324 m .73289 .42703 L .74316 .42564 L p F P
0 g
s
.494 .904 .833 r
.74316 .42564 m .77066 .41202 L .76096 .41324 L p F P
0 g
s
.178 0 0 r
.72021 .14266 m .6881 .14122 L .67867 .14322 L p F P
0 g
s
0 0 0 r
.64803 .14819 m .67867 .14322 L .6881 .14122 L p F P
0 g
s
0 0 0 r
.54033 .24607 m .55955 .22074 L .56432 .20813 L p F P
0 g
s
.009 0 .25 r
.55955 .22074 m .54033 .24607 L .53834 .26038 L p F P
0 g
s
0 0 0 r
.58677 .18546 m .56432 .20813 L .55955 .22074 L p F P
0 g
s
.303 .431 .825 r
.55986 .36 m .53779 .35938 L .5446 .37308 L p F P
0 g
s
.303 .431 .825 r
.5446 .37308 m .56898 .37847 L .55986 .36 L p F P
0 g
s
.293 .75 .953 r
.69121 .42895 m .66087 .42976 L .67253 .43458 L p F P
0 g
s
.293 .75 .953 r
.67253 .43458 m .70339 .4341 L .69121 .42895 L p F P
0 g
s
.043 0 0 r
.64803 .14819 m .61997 .15957 L .61201 .16822 L p F P
0 g
s
0 0 0 r
.58677 .18546 m .61201 .16822 L .61997 .15957 L p F P
0 g
s
.194 .128 .549 r
.52379 .31301 m .54096 .29748 L .53855 .2778 L p F P
0 g
s
.264 .238 .642 r
.54096 .29748 m .52379 .31301 L .52712 .32857 L p F P
0 g
s
.29 .288 .685 r
.88534 .23475 m .86545 .24921 L .86194 .23645 L p F P
0 g
s
.29 .288 .685 r
.86194 .23645 m .88352 .22814 L .88534 .23475 L p F P
0 g
s
.312 .351 .741 r
.88352 .22814 m .86194 .23645 L .85765 .22381 L p F P
0 g
s
.103 .539 .912 r
.76266 .15332 m .79661 .165 L .80389 .17145 L p F P
0 g
s
0 .384 .705 r
.79661 .165 m .76266 .15332 L .75428 .14995 L p F P
0 g
s
0 .531 .812 r
.72021 .14266 m .75428 .14995 L .76266 .15332 L p F P
0 g
s
.312 .351 .741 r
.85765 .22381 m .8813 .22159 L .88352 .22814 L p F P
0 g
s
.313 .4 .791 r
.8813 .22159 m .85765 .22381 L .85277 .21186 L p F P
0 g
s
.315 .381 .772 r
.55189 .33965 m .53187 .34429 L .53779 .35938 L p F P
0 g
s
.315 .381 .772 r
.53779 .35938 m .55986 .36 L .55189 .33965 L p F P
0 g
s
.244 .206 .615 r
.88668 .24112 m .86801 .26152 L .86545 .24921 L p F P
0 g
s
.244 .206 .615 r
.86545 .24921 m .88534 .23475 L .88668 .24112 L p F P
0 g
s
.281 .556 .928 r
.60639 .40027 m .57879 .39415 L .58879 .40629 L p F P
0 g
s
.281 .556 .928 r
.58879 .40629 m .61835 .41495 L .60639 .40027 L p F P
0 g
s
.183 .504 .91 r
.80389 .17145 m .83681 .18517 L .84211 .19208 L p F P
0 g
s
0 .452 .859 r
.83681 .18517 m .80389 .17145 L .79661 .165 L p F P
0 g
s
.264 .238 .642 r
.52712 .32857 m .54548 .31845 L .54096 .29748 L p F P
0 g
s
.302 .319 .712 r
.54548 .31845 m .52712 .32857 L .53187 .34429 L p F P
0 g
s
.313 .4 .791 r
.85277 .21186 m .87878 .21539 L .8813 .22159 L p F P
0 g
s
.291 .438 .837 r
.87878 .21539 m .85277 .21186 L .84752 .20112 L p F P
0 g
s
.302 .319 .712 r
.53187 .34429 m .55189 .33965 L .54548 .31845 L p F P
0 g
s
.298 .657 .971 r
.64806 .41886 m .61835 .41495 L .6299 .42464 L p F P
0 g
s
.298 .657 .971 r
.6299 .42464 m .66087 .42976 L .64806 .41886 L p F P
0 g
s
.166 .093 .523 r
.88748 .24696 m .86952 .27284 L .86801 .26152 L p F P
0 g
s
.166 .093 .523 r
.86801 .26152 m .88668 .24112 L .88748 .24696 L p F P
0 g
s
.682 .979 .842 r
.78761 .3929 m .76096 .41324 L .77066 .41202 L p F P
0 g
s
.682 .979 .842 r
.77066 .41202 m .79632 .39194 L .78761 .3929 L p F P
0 g
s
.367 0 0 r
.75428 .14995 m .72021 .14266 L .7118 .14451 L p F P
0 g
s
.178 0 0 r
.67867 .14322 m .7118 .14451 L .72021 .14266 L p F P
0 g
s
.677 .893 .534 r
.84282 .33451 m .82029 .36586 L .82594 .36022 L p F P
0 g
s
.677 .893 .534 r
.82594 .36022 m .8472 .33018 L .84282 .33451 L p F P
0 g
s
0 0 0 r
.8672 .296 m .8472 .33018 L .85005 .32213 L p F P
0 g
s
0 0 0 r
.85005 .32213 m .86911 .2905 L .8672 .296 L p F P
0 g
s
.291 .438 .837 r
.84752 .20112 m .87608 .20984 L .87878 .21539 L p F P
0 g
s
.234 .463 .875 r
.87608 .20984 m .84752 .20112 L .84211 .19208 L p F P
0 g
s
.512 .867 .988 r
.72077 .42174 m .69121 .42895 L .70339 .4341 L p F P
0 g
s
.512 .867 .988 r
.70339 .4341 m .73289 .42703 L .72077 .42174 L p F P
0 g
s
.009 0 .25 r
.53834 .26038 m .55725 .23796 L .55955 .22074 L p F P
0 g
s
.185 .048 .449 r
.55725 .23796 m .53834 .26038 L .53855 .2778 L p F P
0 g
s
.28 0 0 r
.67867 .14322 m .64803 .14819 L .64021 .15687 L p F P
0 g
s
.043 0 0 r
.61201 .16822 m .64021 .15687 L .64803 .14819 L p F P
0 g
s
.124 0 .087 r
.61201 .16822 m .58677 .18546 L .58156 .19952 L p F P
0 g
s
0 0 0 r
.55955 .22074 m .58156 .19952 L .58677 .18546 L p F P
0 g
s
.035 0 .386 r
.88771 .25199 m .8699 .28265 L .86952 .27284 L p F P
0 g
s
.035 0 .386 r
.86952 .27284 m .88748 .24696 L .88771 .25199 L p F P
0 g
s
.355 .525 .886 r
.5946 .38125 m .56898 .37847 L .57879 .39415 L p F P
0 g
s
.355 .525 .886 r
.57879 .39415 m .60639 .40027 L .5946 .38125 L p F P
0 g
s
.165 0 .306 r
.58156 .19952 m .55955 .22074 L .55725 .23796 L p F P
0 g
s
.234 .463 .875 r
.84211 .19208 m .87333 .20518 L .87608 .20984 L p F P
0 g
s
.119 .46 .888 r
.87333 .20518 m .84211 .19208 L .83681 .18517 L p F P
0 g
s
.794 .999 .818 r
.81293 .3665 m .78761 .3929 L .79632 .39194 L p F P
0 g
s
.794 .999 .818 r
.79632 .39194 m .82029 .36586 L .81293 .3665 L p F P
0 g
s
0 .452 .859 r
.79661 .165 m .83184 .18071 L .83681 .18517 L p F P
0 g
s
0 .384 .705 r
.75428 .14995 m .79012 .16237 L .79661 .165 L p F P
0 g
s
.311 0 0 r
.83184 .18071 m .79661 .165 L .79012 .16237 L p F P
0 g
s
0 0 .165 r
.88733 .25598 m .86911 .2905 L .8699 .28265 L p F P
0 g
s
0 0 .165 r
.8699 .28265 m .88771 .25199 L .88733 .25598 L p F P
0 g
s
.489 0 0 r
.79012 .16237 m .75428 .14995 L .74725 .15161 L p F P
0 g
s
.367 0 0 r
.7118 .14451 m .74725 .15161 L .75428 .14995 L p F P
0 g
s
.467 .749 .99 r
.67776 .4173 m .64806 .41886 L .66087 .42976 L p F P
0 g
s
.467 .749 .99 r
.66087 .42976 m .69121 .42895 L .67776 .4173 L p F P
0 g
s
.451 0 0 r
.7118 .14451 m .67867 .14322 L .67136 .15158 L p F P
0 g
s
.28 0 0 r
.64021 .15687 m .67136 .15158 L .67867 .14322 L p F P
0 g
s
.673 .927 .972 r
.74947 .40799 m .72077 .42174 L .73289 .42703 L p F P
0 g
s
.673 .927 .972 r
.73289 .42703 m .76096 .41324 L .74947 .40799 L p F P
0 g
s
.185 .048 .449 r
.53855 .2778 m .5576 .25899 L .55725 .23796 L p F P
0 g
s
.286 .193 .571 r
.5576 .25899 m .53855 .2778 L .54096 .29748 L p F P
0 g
s
.41 .63 .944 r
.63472 .40228 m .60639 .40027 L .61835 .41495 L p F P
0 g
s
.41 .63 .944 r
.61835 .41495 m .64806 .41886 L .63472 .40228 L p F P
0 g
s
.752 .914 .54 r
.86422 .29888 m .84282 .33451 L .8472 .33018 L p F P
0 g
s
.752 .914 .54 r
.8472 .33018 m .8672 .296 L .86422 .29888 L p F P
0 g
s
.315 0 .162 r
.64021 .15687 m .61201 .16822 L .60666 .18309 L p F P
0 g
s
.124 0 .087 r
.58156 .19952 m .60666 .18309 L .61201 .16822 L p F P
0 g
s
.119 .46 .888 r
.83681 .18517 m .87064 .20163 L .87333 .20518 L p F P
0 g
s
0 .392 .817 r
.87064 .20163 m .83681 .18517 L .83184 .18071 L p F P
0 g
s
.386 .48 .834 r
.58358 .35881 m .55986 .36 L .56898 .37847 L p F P
0 g
s
.386 .48 .834 r
.56898 .37847 m .5946 .38125 L .58358 .35881 L p F P
0 g
s
.857 .997 .788 r
.83708 .33485 m .81293 .3665 L .82029 .36586 L p F P
0 g
s
.857 .997 .788 r
.82029 .36586 m .84282 .33451 L .83708 .33485 L p F P
0 g
s
0 0 0 r
.88638 .25875 m .8672 .296 L .86911 .2905 L p F P
0 g
s
0 0 0 r
.86911 .2905 m .88733 .25598 L .88638 .25875 L p F P
0 g
s
.286 .193 .571 r
.54096 .29748 m .5606 .28284 L .5576 .25899 L p F P
0 g
s
.344 .293 .656 r
.5606 .28284 m .54096 .29748 L .54548 .31845 L p F P
0 g
s
.563 .063 .027 r
.74725 .15161 m .7118 .14451 L .70535 .15222 L p F P
0 g
s
.451 0 0 r
.67136 .15158 m .70535 .15222 L .7118 .14451 L p F P
0 g
s
.777 .947 .932 r
.77726 .38791 m .74947 .40799 L .76096 .41324 L p F P
0 g
s
.777 .947 .932 r
.76096 .41324 m .78761 .3929 L .77726 .38791 L p F P
0 g
s
.391 .429 .78 r
.57393 .33407 m .55189 .33965 L .55986 .36 L p F P
0 g
s
.391 .429 .78 r
.55986 .36 m .58358 .35881 L .57393 .33407 L p F P
0 g
s
.311 0 0 r
.79012 .16237 m .82745 .17894 L .83184 .18071 L p F P
0 g
s
.562 0 0 r
.82745 .17894 m .79012 .16237 L .78472 .16376 L p F P
0 g
s
.489 0 0 r
.74725 .15161 m .78472 .16376 L .79012 .16237 L p F P
0 g
s
.165 0 .306 r
.55725 .23796 m .57912 .21883 L .58156 .19952 L p F P
0 g
s
.304 .135 .48 r
.57912 .21883 m .55725 .23796 L .5576 .25899 L p F P
0 g
s
.316 .057 .353 r
.60666 .18309 m .58156 .19952 L .57912 .21883 L p F P
0 g
s
.606 .809 .978 r
.70735 .40984 m .67776 .4173 L .69121 .42895 L p F P
0 g
s
.606 .809 .978 r
.69121 .42895 m .72077 .42174 L .70735 .40984 L p F P
0 g
s
.344 .293 .656 r
.54548 .31845 m .56613 .3083 L .5606 .28284 L p F P
0 g
s
.377 .368 .722 r
.56613 .3083 m .54548 .31845 L .55189 .33965 L p F P
0 g
s
0 .392 .817 r
.83184 .18071 m .86814 .19936 L .87064 .20163 L p F P
0 g
s
.379 0 0 r
.86814 .19936 m .83184 .18071 L .82745 .17894 L p F P
0 g
s
.377 .368 .722 r
.55189 .33965 m .57393 .33407 L .56613 .3083 L p F P
0 g
s
.27 .275 .681 r
.88352 .22814 m .90526 .21968 L .88534 .23475 L closepath p F P
0 g
s
.292 .338 .738 r
.8813 .22159 m .90526 .21968 L .88352 .22814 L closepath p F P
0 g
s
.462 .075 .218 r
.67136 .15158 m .64021 .15687 L .63501 .17189 L p F P
0 g
s
.315 0 .162 r
.60666 .18309 m .63501 .17189 L .64021 .15687 L p F P
0 g
s
.292 .387 .788 r
.87878 .21539 m .90526 .21968 L .8813 .22159 L closepath p F P
0 g
s
.223 .192 .611 r
.88534 .23475 m .90526 .21968 L .88668 .24112 L closepath p F P
0 g
s
.268 .424 .833 r
.87608 .20984 m .90526 .21968 L .87878 .21539 L closepath p F P
0 g
s
.142 .077 .517 r
.88668 .24112 m .90526 .21968 L .88748 .24696 L closepath p F P
0 g
s
.893 .989 .762 r
.86032 .29898 m .83708 .33485 L .84282 .33451 L p F P
0 g
s
.893 .989 .762 r
.84282 .33451 m .86422 .29888 L .86032 .29898 L p F P
0 g
s
.456 .581 .89 r
.62152 .38078 m .5946 .38125 L .60639 .40027 L p F P
0 g
s
.456 .581 .89 r
.60639 .40027 m .63472 .40228 L .62152 .38078 L p F P
0 g
s
.792 .92 .539 r
.88489 .26016 m .86422 .29888 L .8672 .296 L p F P
0 g
s
.792 .92 .539 r
.8672 .296 m .88638 .25875 L .88489 .26016 L p F P
0 g
s
.634 .143 .07 r
.78472 .16376 m .74725 .15161 L .74192 .15832 L p F P
0 g
s
.563 .063 .027 r
.70535 .15222 m .74192 .15832 L .74725 .15161 L p F P
0 g
s
.84 .949 .889 r
.80415 .36202 m .77726 .38791 L .78761 .3929 L p F P
0 g
s
.84 .949 .889 r
.78761 .3929 m .81293 .3665 L .80415 .36202 L p F P
0 g
s
.207 .445 .869 r
.87333 .20518 m .90526 .21968 L .87608 .20984 L closepath p F P
0 g
s
.53 .69 .941 r
.66371 .39958 m .63472 .40228 L .64806 .41886 L p F P
0 g
s
.53 .69 .941 r
.64806 .41886 m .67776 .4173 L .66371 .39958 L p F P
0 g
s
.006 0 .377 r
.88748 .24696 m .90526 .21968 L .88771 .25199 L closepath p F P
0 g
s
.086 .437 .876 r
.87064 .20163 m .90526 .21968 L .87333 .20518 L closepath p F P
0 g
s
.567 .173 .254 r
.70535 .15222 m .67136 .15158 L .66659 .16608 L p F P
0 g
s
.462 .075 .218 r
.63501 .17189 m .66659 .16608 L .67136 .15158 L p F P
0 g
s
0 0 .153 r
.88771 .25199 m .90526 .21968 L .88733 .25598 L closepath p F P
0 g
s
.379 0 0 r
.82745 .17894 m .86596 .19849 L .86814 .19936 L p F P
0 g
s
.604 .039 0 r
.86596 .19849 m .82745 .17894 L .82384 .17997 L p F P
0 g
s
.562 0 0 r
.78472 .16376 m .82384 .17997 L .82745 .17894 L p F P
0 g
s
.707 .842 .947 r
.73671 .39637 m .70735 .40984 L .72077 .42174 L p F P
0 g
s
.707 .842 .947 r
.72077 .42174 m .74947 .40799 L .73671 .39637 L p F P
0 g
s
.304 .135 .48 r
.5576 .25899 m .57963 .24252 L .57912 .21883 L p F P
0 g
s
.382 .261 .588 r
.57963 .24252 m .5576 .25899 L .5606 .28284 L p F P
0 g
s
.444 .16 .387 r
.63501 .17189 m .60666 .18309 L .60424 .2036 L p F P
0 g
s
.316 .057 .353 r
.57912 .21883 m .60424 .2036 L .60666 .18309 L p F P
0 g
s
.879 .943 .853 r
.83024 .33111 m .80415 .36202 L .81293 .3665 L p F P
0 g
s
.879 .943 .853 r
.81293 .3665 m .83708 .33485 L .83024 .33111 L p F P
0 g
s
.678 .195 .097 r
.82384 .17997 m .78472 .16376 L .78068 .16916 L p F P
0 g
s
.634 .143 .07 r
.74192 .15832 m .78068 .16916 L .78472 .16376 L p F P
0 g
s
0 .361 .795 r
.86814 .19936 m .90526 .21968 L .87064 .20163 L closepath p F P
0 g
s
.911 .982 .744 r
.88293 .26013 m .86032 .29898 L .86422 .29888 L p F P
0 g
s
.911 .982 .744 r
.86422 .29888 m .88489 .26016 L .88293 .26013 L p F P
0 g
s
0 0 0 r
.88733 .25598 m .90526 .21968 L .88638 .25875 L closepath p F P
0 g
s
.472 .53 .836 r
.60915 .35538 m .58358 .35881 L .5946 .38125 L p F P
0 g
s
.472 .53 .836 r
.5946 .38125 m .62152 .38078 L .60915 .35538 L p F P
0 g
s
.415 .219 .503 r
.60424 .2036 m .57912 .21883 L .57963 .24252 L p F P
0 g
s
.639 .243 .278 r
.74192 .15832 m .70535 .15222 L .70122 .16554 L p F P
0 g
s
.567 .173 .254 r
.66659 .16608 m .70122 .16554 L .70535 .15222 L p F P
0 g
s
.41 0 0 r
.86596 .19849 m .90526 .21968 L .86814 .19936 L closepath p F P
0 g
s
.902 .936 .825 r
.85566 .29625 m .83024 .33111 L .83708 .33485 L p F P
0 g
s
.902 .936 .825 r
.83708 .33485 m .86032 .29898 L .85566 .29625 L p F P
0 g
s
.778 .857 .91 r
.76573 .37709 m .73671 .39637 L .74947 .40799 L p F P
0 g
s
.778 .857 .91 r
.74947 .40799 m .77726 .38791 L .76573 .37709 L p F P
0 g
s
.81 .922 .537 r
.88638 .25875 m .90526 .21968 L .88489 .26016 L closepath p F P
0 g
s
.628 .733 .923 r
.69328 .39178 m .66371 .39958 L .67776 .4173 L p F P
0 g
s
.628 .733 .923 r
.67776 .4173 m .70735 .40984 L .69328 .39178 L p F P
0 g
s
.604 .039 0 r
.82384 .17997 m .86418 .19906 L .86596 .19849 L p F P
0 g
s
.703 .225 .112 r
.86418 .19906 m .82384 .17997 L .82119 .18379 L p F P
0 g
s
.678 .195 .097 r
.78068 .16916 m .82119 .18379 L .82384 .17997 L p F P
0 g
s
.382 .261 .588 r
.5606 .28284 m .58311 .26943 L .57963 .24252 L p F P
0 g
s
.428 .349 .665 r
.58311 .26943 m .5606 .28284 L .56613 .3083 L p F P
0 g
s
.623 .062 0 r
.86418 .19906 m .90526 .21968 L .86596 .19849 L closepath p F P
0 g
s
.688 .292 .292 r
.78068 .16916 m .74192 .15832 L .73859 .16986 L p F P
0 g
s
.639 .243 .278 r
.70122 .16554 m .73859 .16986 L .74192 .15832 L p F P
0 g
s
.55 .63 .884 r
.64976 .37657 m .62152 .38078 L .63472 .40228 L p F P
0 g
s
.55 .63 .884 r
.63472 .40228 m .66371 .39958 L .64976 .37657 L p F P
0 g
s
.544 .244 .408 r
.66659 .16608 m .63501 .17189 L .63276 .19264 L p F P
0 g
s
.444 .16 .387 r
.60424 .2036 m .63276 .19264 L .63501 .17189 L p F P
0 g
s
.471 .477 .782 r
.59826 .32737 m .57393 .33407 L .58358 .35881 L p F P
0 g
s
.471 .477 .782 r
.58358 .35881 m .60915 .35538 L .59826 .32737 L p F P
0 g
s
.915 .931 .806 r
.88059 .25865 m .85566 .29625 L .86032 .29898 L p F P
0 g
s
.915 .931 .806 r
.86032 .29898 m .88293 .26013 L .88059 .25865 L p F P
0 g
s
.92 .978 .735 r
.88489 .26016 m .90526 .21968 L .88293 .26013 L closepath p F P
0 g
s
.825 .863 .875 r
.79437 .35251 m .76573 .37709 L .77726 .38791 L p F P
0 g
s
.825 .863 .875 r
.77726 .38791 m .80415 .36202 L .79437 .35251 L p F P
0 g
s
.428 .349 .665 r
.56613 .3083 m .58943 .29821 L .58311 .26943 L p F P
0 g
s
.456 .418 .727 r
.58943 .29821 m .56613 .3083 L .57393 .33407 L p F P
0 g
s
.456 .418 .727 r
.57393 .33407 m .59826 .32737 L .58943 .29821 L p F P
0 g
s
.719 .324 .301 r
.82119 .18379 m .78068 .16916 L .77824 .17839 L p F P
0 g
s
.688 .292 .292 r
.73859 .16986 m .77824 .17839 L .78068 .16916 L p F P
0 g
s
.715 .24 .119 r
.8629 .20105 m .90526 .21968 L .86418 .19906 L closepath p F P
0 g
s
.703 .225 .112 r
.82119 .18379 m .8629 .20105 L .86418 .19906 L p F P
0 g
s
.856 .863 .846 r
.82261 .32341 m .79437 .35251 L .80415 .36202 L p F P
0 g
s
.856 .863 .846 r
.80415 .36202 m .83024 .33111 L .82261 .32341 L p F P
0 g
s
.921 .929 .797 r
.88293 .26013 m .90526 .21968 L .88059 .25865 L closepath p F P
0 g
s
.738 .344 .305 r
.8629 .20105 m .82119 .18379 L .81964 .19024 L p F P
0 g
s
.719 .324 .301 r
.77824 .17839 m .81964 .19024 L .82119 .18379 L p F P
0 g
s
.415 .219 .503 r
.57963 .24252 m .60494 .22882 L .60424 .2036 L p F P
0 g
s
.472 .325 .599 r
.60494 .22882 m .57963 .24252 L .58311 .26943 L p F P
0 g
s
.619 .307 .42 r
.70122 .16554 m .66659 .16608 L .66464 .18612 L p F P
0 g
s
.544 .244 .408 r
.63276 .19264 m .66464 .18612 L .66659 .16608 L p F P
0 g
s
.511 .291 .517 r
.63276 .19264 m .60424 .2036 L .60494 .22882 L p F P
0 g
s
.704 .761 .896 r
.72329 .3788 m .69328 .39178 L .70735 .40984 L p F P
0 g
s
.704 .761 .896 r
.70735 .40984 m .73671 .39637 L .72329 .3788 L p F P
0 g
s
.875 .862 .824 r
.85045 .29079 m .82261 .32341 L .83024 .33111 L p F P
0 g
s
.875 .862 .824 r
.83024 .33111 m .85566 .29625 L .85045 .29079 L p F P
0 g
s
.747 .353 .307 r
.86219 .20439 m .90526 .21968 L .8629 .20105 L closepath p F P
0 g
s
.738 .344 .305 r
.81964 .19024 m .86219 .20439 L .8629 .20105 L p F P
0 g
s
.887 .861 .809 r
.87797 .2558 m .85045 .29079 L .85566 .29625 L p F P
0 g
s
.887 .861 .809 r
.85566 .29625 m .88059 .25865 L .87797 .2558 L p F P
0 g
s
.893 .861 .802 r
.88059 .25865 m .90526 .21968 L .87797 .2558 L closepath p F P
0 g
s
.758 .429 .428 r
.86207 .20891 m .90526 .21968 L .86219 .20439 L closepath p F P
0 g
s
.765 .486 .512 r
.86256 .2144 m .90526 .21968 L .86207 .20891 L closepath p F P
0 g
s
.771 .533 .575 r
.86363 .22062 m .90526 .21968 L .86256 .2144 L closepath p F P
0 g
s
.778 .574 .624 r
.86524 .22726 m .90526 .21968 L .86363 .22062 L closepath p F P
0 g
s
.788 .614 .665 r
.86731 .234 m .90526 .21968 L .86524 .22726 L closepath p F P
0 g
s
.8 .654 .7 r
.86974 .24053 m .90526 .21968 L .86731 .234 L closepath p F P
0 g
s
.817 .696 .732 r
.87241 .24652 m .90526 .21968 L .86974 .24053 L closepath p F P
0 g
s
.837 .744 .76 r
.8752 .25169 m .90526 .21968 L .87241 .24652 L closepath p F P
0 g
s
.863 .798 .785 r
.87797 .2558 m .90526 .21968 L .8752 .25169 L closepath p F P
0 g
s
.553 .574 .83 r
.63664 .3494 m .60915 .35538 L .62152 .38078 L p F P
0 g
s
.553 .574 .83 r
.62152 .38078 m .64976 .37657 L .63664 .3494 L p F P
0 g
s
.672 .354 .426 r
.73859 .16986 m .70122 .16554 L .69966 .18394 L p F P
0 g
s
.619 .307 .42 r
.66464 .18612 m .69966 .18394 L .70122 .16554 L p F P
0 g
s
.751 .423 .429 r
.86219 .20439 m .81964 .19024 L .81927 .19905 L p F P
0 g
s
.751 .423 .429 r
.81927 .19905 m .86207 .20891 L .86219 .20439 L p F P
0 g
s
.63 .668 .868 r
.67926 .36836 m .64976 .37657 L .66371 .39958 L p F P
0 g
s
.63 .668 .868 r
.66371 .39958 m .69328 .39178 L .67926 .36836 L p F P
0 g
s
.76 .778 .868 r
.75359 .36084 m .72329 .3788 L .73671 .39637 L p F P
0 g
s
.76 .778 .868 r
.73671 .39637 m .76573 .37709 L .75359 .36084 L p F P
0 g
s
.857 .797 .791 r
.85045 .29079 m .87797 .2558 L .8752 .25169 L p F P
0 g
s
.71 .387 .429 r
.77824 .17839 m .73859 .16986 L .73746 .18577 L p F P
0 g
s
.672 .354 .426 r
.69966 .18394 m .73746 .18577 L .73859 .16986 L p F P
0 g
s
.735 .409 .429 r
.81964 .19024 m .77824 .17839 L .77752 .19105 L p F P
0 g
s
.735 .409 .429 r
.77752 .19105 m .81927 .19905 L .81964 .19024 L p F P
0 g
s
.71 .387 .429 r
.73746 .18577 m .77752 .19105 L .77824 .17839 L p F P
0 g
s
.472 .325 .599 r
.58311 .26943 m .60877 .25753 L .60494 .22882 L p F P
0 g
s
.508 .402 .669 r
.60877 .25753 m .58311 .26943 L .58943 .29821 L p F P
0 g
s
.758 .481 .514 r
.86207 .20891 m .81927 .19905 L .82012 .2098 L p F P
0 g
s
.758 .481 .514 r
.82012 .2098 m .86256 .2144 L .86207 .20891 L p F P
0 g
s
.588 .35 .523 r
.66464 .18612 m .63276 .19264 L .63364 .21821 L p F P
0 g
s
.511 .291 .517 r
.60494 .22882 m .63364 .21821 L .63276 .19264 L p F P
0 g
s
.857 .797 .791 r
.8752 .25169 m .84495 .28284 L .85045 .29079 L p F P
0 g
s
.846 .796 .802 r
.82261 .32341 m .85045 .29079 L .84495 .28284 L p F P
0 g
s
.832 .742 .765 r
.84495 .28284 m .8752 .25169 L .87241 .24652 L p F P
0 g
s
.8 .788 .841 r
.78405 .33836 m .75359 .36084 L .76573 .37709 L p F P
0 g
s
.8 .788 .841 r
.76573 .37709 m .79437 .35251 L .78405 .33836 L p F P
0 g
s
.546 .521 .779 r
.62504 .31945 m .59826 .32737 L .60915 .35538 L p F P
0 g
s
.546 .521 .779 r
.60915 .35538 m .63664 .3494 L .62504 .31945 L p F P
0 g
s
.764 .529 .577 r
.86256 .2144 m .82012 .2098 L .82215 .22199 L p F P
0 g
s
.764 .529 .577 r
.82215 .22199 m .86363 .22062 L .86256 .2144 L p F P
0 g
s
.846 .796 .802 r
.84495 .28284 m .81454 .31207 L .82261 .32341 L p F P
0 g
s
.827 .793 .819 r
.79437 .35251 m .82261 .32341 L .81454 .31207 L p F P
0 g
s
.827 .793 .819 r
.81454 .31207 m .78405 .33836 L .79437 .35251 L p F P
0 g
s
.811 .694 .736 r
.83941 .27277 m .87241 .24652 L .86974 .24053 L p F P
0 g
s
.832 .742 .765 r
.87241 .24652 m .83941 .27277 L .84495 .28284 L p F P
0 g
s
.551 .38 .603 r
.63364 .21821 m .60494 .22882 L .60877 .25753 L p F P
0 g
s
.508 .402 .669 r
.58943 .29821 m .61559 .28828 L .60877 .25753 L p F P
0 g
s
.531 .465 .727 r
.61559 .28828 m .58943 .29821 L .59826 .32737 L p F P
0 g
s
.772 .571 .626 r
.86363 .22062 m .82215 .22199 L .82527 .23502 L p F P
0 g
s
.772 .571 .626 r
.82527 .23502 m .86524 .22726 L .86363 .22062 L p F P
0 g
s
.744 .471 .516 r
.81927 .19905 m .77752 .19105 L .77859 .20656 L p F P
0 g
s
.744 .471 .516 r
.77859 .20656 m .82012 .2098 L .81927 .19905 L p F P
0 g
s
.531 .465 .727 r
.59826 .32737 m .62504 .31945 L .61559 .28828 L p F P
0 g
s
.795 .651 .703 r
.83412 .26105 m .86974 .24053 L .86731 .234 L p F P
0 g
s
.811 .694 .736 r
.86974 .24053 m .83412 .26105 L .83941 .27277 L p F P
0 g
s
.782 .611 .667 r
.86524 .22726 m .82527 .23502 L .82933 .24826 L p F P
0 g
s
.782 .611 .667 r
.82933 .24826 m .86731 .234 L .86524 .22726 L p F P
0 g
s
.693 .695 .847 r
.70988 .35608 m .67926 .36836 L .69328 .39178 L p F P
0 g
s
.693 .695 .847 r
.69328 .39178 m .72329 .3788 L .70988 .35608 L p F P
0 g
s
.795 .651 .703 r
.86731 .234 m .82933 .24826 L .83412 .26105 L p F P
0 g
s
.647 .395 .524 r
.69966 .18394 m .66464 .18612 L .66568 .21082 L p F P
0 g
s
.588 .35 .523 r
.63364 .21821 m .66568 .21082 L .66464 .18612 L p F P
0 g
s
.821 .739 .774 r
.81454 .31207 m .84495 .28284 L .83941 .27277 L p F P
0 g
s
.623 .61 .817 r
.66603 .34071 m .63664 .3494 L .64976 .37657 L p F P
0 g
s
.623 .61 .817 r
.64976 .37657 m .67926 .36836 L .66603 .34071 L p F P
0 g
s
.722 .454 .519 r
.77752 .19105 m .73746 .18577 L .73862 .20531 L p F P
0 g
s
.722 .454 .519 r
.73862 .20531 m .77859 .20656 L .77752 .19105 L p F P
0 g
s
.691 .429 .522 r
.73746 .18577 m .69966 .18394 L .70081 .2066 L p F P
0 g
s
.647 .395 .524 r
.66568 .21082 m .70081 .2066 L .69966 .18394 L p F P
0 g
s
.691 .429 .522 r
.70081 .2066 m .73862 .20531 L .73746 .18577 L p F P
0 g
s
.752 .52 .58 r
.82012 .2098 m .77859 .20656 L .78142 .22418 L p F P
0 g
s
.752 .52 .58 r
.78142 .22418 m .82215 .22199 L .82012 .2098 L p F P
0 g
s
.821 .739 .774 r
.83941 .27277 m .80644 .2976 L .81454 .31207 L p F P
0 g
s
.803 .734 .788 r
.78405 .33836 m .81454 .31207 L .80644 .2976 L p F P
0 g
s
.741 .713 .825 r
.74144 .3399 m .70988 .35608 L .72329 .3788 L p F P
0 g
s
.741 .713 .825 r
.72329 .3788 m .75359 .36084 L .74144 .3399 L p F P
0 g
s
.8 .69 .743 r
.80644 .2976 m .83941 .27277 L .83412 .26105 L p F P
0 g
s
.551 .38 .603 r
.60877 .25753 m .63767 .24734 L .63364 .21821 L p F P
0 g
s
.578 .448 .667 r
.63767 .24734 m .60877 .25753 L .61559 .28828 L p F P
0 g
s
.615 .425 .602 r
.66568 .21082 m .63364 .21821 L .63767 .24734 L p F P
0 g
s
.761 .564 .631 r
.82215 .22199 m .78142 .22418 L .78587 .24305 L p F P
0 g
s
.761 .564 .631 r
.78587 .24305 m .82527 .23502 L .82215 .22199 L p F P
0 g
s
.803 .734 .788 r
.80644 .2976 m .7737 .32022 L .78405 .33836 L p F P
0 g
s
.777 .726 .805 r
.75359 .36084 m .78405 .33836 L .7737 .32022 L p F P
0 g
s
.777 .726 .805 r
.7737 .32022 m .74144 .3399 L .75359 .36084 L p F P
0 g
s
.784 .646 .71 r
.79871 .28071 m .83412 .26105 L .82933 .24826 L p F P
0 g
s
.8 .69 .743 r
.83412 .26105 m .79871 .28071 L .80644 .2976 L p F P
0 g
s
.612 .558 .77 r
.65429 .31025 m .62504 .31945 L .63664 .3494 L p F P
0 g
s
.612 .558 .77 r
.63664 .3494 m .66603 .34071 L .65429 .31025 L p F P
0 g
s
.732 .507 .585 r
.77859 .20656 m .73862 .20531 L .74205 .22756 L p F P
0 g
s
.732 .507 .585 r
.74205 .22756 m .78142 .22418 L .77859 .20656 L p F P
0 g
s
.771 .605 .673 r
.82527 .23502 m .78587 .24305 L .79173 .26221 L p F P
0 g
s
.771 .605 .673 r
.79173 .26221 m .82933 .24826 L .82527 .23502 L p F P
0 g
s
.784 .646 .71 r
.82933 .24826 m .79173 .26221 L .79871 .28071 L p F P
0 g
s
.68 .638 .801 r
.69719 .32929 m .66603 .34071 L .67926 .36836 L p F P
0 g
s
.68 .638 .801 r
.67926 .36836 m .70988 .35608 L .69719 .32929 L p F P
0 g
s
.578 .448 .667 r
.61559 .28828 m .64467 .27857 L .63767 .24734 L p F P
0 g
s
.597 .505 .721 r
.64467 .27857 m .61559 .28828 L .62504 .31945 L p F P
0 g
s
.783 .683 .754 r
.7737 .32022 m .80644 .2976 L .79871 .28071 L p F P
0 g
s
.666 .461 .597 r
.70081 .2066 m .66568 .21082 L .66971 .23897 L p F P
0 g
s
.615 .425 .602 r
.63767 .24734 m .66971 .23897 L .66568 .21082 L p F P
0 g
s
.597 .505 .721 r
.62504 .31945 m .65429 .31025 L .64467 .27857 L p F P
0 g
s
.704 .487 .591 r
.73862 .20531 m .70081 .2066 L .70464 .23242 L p F P
0 g
s
.704 .487 .591 r
.70464 .23242 m .74205 .22756 L .73862 .20531 L p F P
0 g
s
.666 .461 .597 r
.66971 .23897 m .70464 .23242 L .70081 .2066 L p F P
0 g
s
.742 .552 .637 r
.78142 .22418 m .74205 .22756 L .7476 .25139 L p F P
0 g
s
.742 .552 .637 r
.7476 .25139 m .78587 .24305 L .78142 .22418 L p F P
0 g
s
.635 .485 .661 r
.66971 .23897 m .63767 .24734 L .64467 .27857 L p F P
0 g
s
.724 .659 .784 r
.72989 .31527 m .69719 .32929 L .70988 .35608 L p F P
0 g
s
.724 .659 .784 r
.70988 .35608 m .74144 .3399 L .72989 .31527 L p F P
0 g
s
.783 .683 .754 r
.79871 .28071 m .76384 .29894 L .7737 .32022 L p F P
0 g
s
.758 .673 .768 r
.74144 .3399 m .7737 .32022 L .76384 .29894 L p F P
0 g
s
.767 .638 .719 r
.76384 .29894 m .79871 .28071 L .79173 .26221 L p F P
0 g
s
.758 .673 .768 r
.76384 .29894 m .72989 .31527 L .74144 .3399 L p F P
0 g
s
.754 .595 .681 r
.78587 .24305 m .7476 .25139 L .75499 .2756 L p F P
0 g
s
.754 .595 .681 r
.75499 .2756 m .79173 .26221 L .78587 .24305 L p F P
0 g
s
.666 .587 .757 r
.68588 .2998 m .65429 .31025 L .66603 .34071 L p F P
0 g
s
.666 .587 .757 r
.66603 .34071 m .69719 .32929 L .68588 .2998 L p F P
0 g
s
.767 .638 .719 r
.79173 .26221 m .75499 .2756 L .76384 .29894 L p F P
0 g
s
.716 .536 .645 r
.74205 .22756 m .70464 .23242 L .711 .26009 L p F P
0 g
s
.716 .536 .645 r
.711 .26009 m .7476 .25139 L .74205 .22756 L p F P
0 g
s
.635 .485 .661 r
.64467 .27857 m .67656 .26916 L .66971 .23897 L p F P
0 g
s
.652 .537 .712 r
.67656 .26916 m .64467 .27857 L .65429 .31025 L p F P
0 g
s
.681 .514 .654 r
.70464 .23242 m .66971 .23897 L .67656 .26916 L p F P
0 g
s
.652 .537 .712 r
.65429 .31025 m .68588 .2998 L .67656 .26916 L p F P
0 g
s
.742 .626 .73 r
.72989 .31527 m .76384 .29894 L .75499 .2756 L p F P
0 g
s
.681 .514 .654 r
.67656 .26916 m .711 .26009 L .70464 .23242 L p F P
0 g
s
.709 .61 .743 r
.71957 .2882 m .68588 .2998 L .69719 .32929 L p F P
0 g
s
.709 .61 .743 r
.69719 .32929 m .72989 .31527 L .71957 .2882 L p F P
0 g
s
.729 .581 .69 r
.7476 .25139 m .711 .26009 L .71957 .2882 L p F P
0 g
s
.729 .581 .69 r
.71957 .2882 m .75499 .2756 L .7476 .25139 L p F P
0 g
s
.742 .626 .73 r
.75499 .2756 m .71957 .2882 L .72989 .31527 L p F P
0 g
s
.695 .563 .701 r
.711 .26009 m .67656 .26916 L .68588 .2998 L p F P
0 g
s
.695 .563 .701 r
.68588 .2998 m .71957 .2882 L .711 .26009 L p F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S5.25.1"]
}, Open  ]],

Cell[TextData[{
  "This demonstrates the use of ",
  StyleBox["SpinShow", "MR"],
  " on the parametric plot. Due to the symmetry of the image we need only \
animate half a cycle. The animation of the projection of a \
three\[Hyphen]dimensional object often enhances the depth effect. "
}], "MathCaption",
  CellTags->{"S5.25.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
SpinShow[ g, Frames -> 10, SpinRange -> {0 Degree, 180 Degree} \
]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S5.25.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.136054 0.0147151 0.346238 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.257081 0.159864 0.603319 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-7.8171e-17 1.07205 -0.0183018 1.07205 [
[ 0 0 0 0 ]
[ 1 .93328 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .93328 L
0 .93328 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.86 .634 .593 r
.49978 .74308 m .54735 .78334 L .49668 .75749 L closepath p F P
0 g
s
.831 .655 .663 r
.50843 .73039 m .54735 .78334 L .49978 .74308 L closepath p F P
0 g
s
.793 .652 .707 r
.52156 .72093 m .54735 .78334 L .50843 .73039 L closepath p F P
0 g
s
.75 .633 .731 r
.5376 .71579 m .54735 .78334 L .52156 .72093 L closepath p F P
0 g
s
.703 .601 .739 r
.55465 .71556 m .54735 .78334 L .5376 .71579 L closepath p F P
0 g
s
.653 .555 .732 r
.57072 .72027 m .54735 .78334 L .55465 .71556 L closepath p F P
0 g
s
.599 .496 .709 r
.5839 .72937 m .54735 .78334 L .57072 .72027 L closepath p F P
0 g
s
.54 .42 .664 r
.59261 .74183 m .54735 .78334 L .5839 .72937 L closepath p F P
0 g
s
.476 .322 .592 r
.59578 .75616 m .54735 .78334 L .59261 .74183 L closepath p F P
0 g
s
.407 .198 .481 r
.59297 .77067 m .54735 .78334 L .59578 .75616 L closepath p F P
0 g
s
.344 .056 .324 r
.58447 .78358 m .54735 .78334 L .59297 .77067 L closepath p F P
0 g
s
.309 0 .134 r
.57127 .7933 m .54735 .78334 L .58447 .78358 L closepath p F P
0 g
s
.335 0 0 r
.55499 .79861 m .54735 .78334 L .57127 .7933 L closepath p F P
0 g
s
.443 0 0 r
.53763 .79884 m .54735 .78334 L .55499 .79861 L closepath p F P
0 g
s
.604 .085 0 r
.52133 .79396 m .54735 .78334 L .53763 .79884 L closepath p F P
0 g
s
.753 .292 .153 r
.5081 .78459 m .54735 .78334 L .52133 .79396 L closepath p F P
0 g
s
.842 .465 .337 r
.49955 .77191 m .54735 .78334 L .5081 .78459 L closepath p F P
0 g
s
.87 .576 .487 r
.49668 .75749 m .54735 .78334 L .49955 .77191 L closepath p F P
0 g
s
.753 .646 .742 r
.5288 .65261 m .5376 .71579 L .52156 .72093 L p F P
0 g
s
.703 .61 .751 r
.5376 .71579 m .5288 .65261 L .56101 .65216 L p F P
0 g
s
.703 .61 .751 r
.56101 .65216 m .55465 .71556 L .5376 .71579 L p F P
0 g
s
.649 .562 .744 r
.55465 .71556 m .56101 .65216 L .5914 .66091 L p F P
0 g
s
.649 .562 .744 r
.5914 .66091 m .57072 .72027 L .55465 .71556 L p F P
0 g
s
.8 .667 .717 r
.49848 .66221 m .52156 .72093 L .50843 .73039 L p F P
0 g
s
.753 .646 .742 r
.52156 .72093 m .49848 .66221 L .5288 .65261 L p F P
0 g
s
.59 .498 .719 r
.57072 .72027 m .5914 .66091 L .61644 .67792 L p F P
0 g
s
.59 .498 .719 r
.61644 .67792 m .5839 .72937 L .57072 .72027 L p F P
0 g
s
.842 .671 .67 r
.47353 .6799 m .50843 .73039 L .49978 .74308 L p F P
0 g
s
.8 .667 .717 r
.50843 .73039 m .47353 .6799 L .49848 .66221 L p F P
0 g
s
.523 .415 .672 r
.5839 .72937 m .61644 .67792 L .63316 .7013 L p F P
0 g
s
.523 .415 .672 r
.63316 .7013 m .59261 .74183 L .5839 .72937 L p F P
0 g
s
.759 .674 .769 r
.52185 .59789 m .5288 .65261 L .49848 .66221 L p F P
0 g
s
.7 .633 .778 r
.5288 .65261 m .52185 .59789 L .56554 .59726 L p F P
0 g
s
.7 .633 .778 r
.56554 .59726 m .56101 .65216 L .5288 .65261 L p F P
0 g
s
.637 .577 .77 r
.56101 .65216 m .56554 .59726 L .60681 .60898 L p F P
0 g
s
.637 .577 .77 r
.60681 .60898 m .5914 .66091 L .56101 .65216 L p F P
0 g
s
.876 .65 .593 r
.45694 .70371 m .49978 .74308 L .49668 .75749 L p F P
0 g
s
.842 .671 .67 r
.49978 .74308 m .45694 .70371 L .47353 .6799 L p F P
0 g
s
.448 .304 .592 r
.59261 .74183 m .63316 .7013 L .63943 .72835 L p F P
0 g
s
.448 .304 .592 r
.63943 .72835 m .59578 .75616 L .59261 .74183 L p F P
0 g
s
.815 .702 .74 r
.48066 .61078 m .49848 .66221 L .47353 .6799 L p F P
0 g
s
.759 .674 .769 r
.49848 .66221 m .48066 .61078 L .52185 .59789 L p F P
0 g
s
.566 .503 .743 r
.5914 .66091 m .60681 .60898 L .64094 .63183 L p F P
0 g
s
.566 .503 .743 r
.64094 .63183 m .61644 .67792 L .5914 .66091 L p F P
0 g
s
.876 .65 .593 r
.49668 .75749 m .45079 .73091 L .45694 .70371 L p F P
0 g
s
.888 .587 .472 r
.45079 .73091 m .49668 .75749 L .49955 .77191 L p F P
0 g
s
.363 .159 .464 r
.59578 .75616 m .63943 .72835 L .63432 .75589 L p F P
0 g
s
.363 .159 .464 r
.63432 .75589 m .59297 .77067 L .59578 .75616 L p F P
0 g
s
.867 .711 .687 r
.44667 .63458 m .47353 .6799 L .45694 .70371 L p F P
0 g
s
.815 .702 .74 r
.47353 .6799 m .44667 .63458 L .48066 .61078 L p F P
0 g
s
.481 .401 .689 r
.61644 .67792 m .64094 .63183 L .66389 .66333 L p F P
0 g
s
.481 .401 .689 r
.66389 .66333 m .63316 .7013 L .61644 .67792 L p F P
0 g
s
.767 .728 .817 r
.5174 .55461 m .52185 .59789 L .48066 .61078 L p F P
0 g
s
.693 .674 .827 r
.52185 .59789 m .5174 .55461 L .56756 .55388 L p F P
0 g
s
.693 .674 .827 r
.56756 .55388 m .56554 .59726 L .52185 .59789 L p F P
0 g
s
.611 .604 .819 r
.56554 .59726 m .56756 .55388 L .61497 .56719 L p F P
0 g
s
.611 .604 .819 r
.61497 .56719 m .60681 .60898 L .56554 .59726 L p F P
0 g
s
.854 .459 .292 r
.456 .75827 m .49955 .77191 L .5081 .78459 L p F P
0 g
s
.888 .587 .472 r
.49955 .77191 m .456 .75827 L .45079 .73091 L p F P
0 g
s
.276 0 .274 r
.59297 .77067 m .63432 .75589 L .61826 .78053 L p F P
0 g
s
.276 0 .274 r
.61826 .78053 m .58447 .78358 L .59297 .77067 L p F P
0 g
s
.839 .768 .784 r
.47008 .5693 m .48066 .61078 L .44667 .63458 L p F P
0 g
s
.767 .728 .817 r
.48066 .61078 m .47008 .5693 L .5174 .55461 L p F P
0 g
s
.741 .247 .062 r
.47212 .78246 m .5081 .78459 L .52133 .79396 L p F P
0 g
s
.854 .459 .292 r
.5081 .78459 m .47212 .78246 L .456 .75827 L p F P
0 g
s
.513 .508 .788 r
.60681 .60898 m .61497 .56719 L .65427 .5932 L p F P
0 g
s
.513 .508 .788 r
.65427 .5932 m .64094 .63183 L .60681 .60898 L p F P
0 g
s
.215 0 .036 r
.58447 .78358 m .61826 .78053 L .59309 .79916 L p F P
0 g
s
.215 0 .036 r
.59309 .79916 m .57127 .7933 L .58447 .78358 L p F P
0 g
s
.911 .691 .592 r
.4239 .66668 m .45694 .70371 L .45079 .73091 L p F P
0 g
s
.867 .711 .687 r
.45694 .70371 m .4239 .66668 L .44667 .63458 L p F P
0 g
s
.375 .257 .589 r
.63316 .7013 m .66389 .66333 L .67271 .69996 L p F P
0 g
s
.375 .257 .589 r
.67271 .69996 m .63943 .72835 L .63316 .7013 L p F P
0 g
s
.55 0 0 r
.49733 .80041 m .52133 .79396 L .53763 .79884 L p F P
0 g
s
.741 .247 .062 r
.52133 .79396 m .49733 .80041 L .47212 .78246 L p F P
0 g
s
.229 0 0 r
.57127 .7933 m .59309 .79916 L .56188 .80936 L p F P
0 g
s
.229 0 0 r
.56188 .80936 m .55499 .79861 L .57127 .7933 L p F P
0 g
s
.351 0 0 r
.52855 .80979 m .53763 .79884 L .55499 .79861 L p F P
0 g
s
.55 0 0 r
.53763 .79884 m .52855 .80979 L .49733 .80041 L p F P
0 g
s
.351 0 0 r
.55499 .79861 m .56188 .80936 L .52855 .80979 L p F P
0 g
s
.91 .789 .715 r
.43095 .59641 m .44667 .63458 L .4239 .66668 L p F P
0 g
s
.839 .768 .784 r
.44667 .63458 m .43095 .59641 L .47008 .5693 L p F P
0 g
s
.382 .367 .718 r
.64094 .63183 m .65427 .5932 L .6808 .62914 L p F P
0 g
s
.382 .367 .718 r
.6808 .62914 m .66389 .66333 L .64094 .63183 L p F P
0 g
s
.765 .82 .896 r
.51585 .52445 m .5174 .55461 L .47008 .5693 L p F P
0 g
s
.663 .743 .909 r
.5174 .55461 m .51585 .52445 L .56666 .52369 L p F P
0 g
s
.663 .743 .909 r
.56666 .52369 m .56756 .55388 L .5174 .55461 L p F P
0 g
s
.911 .691 .592 r
.45079 .73091 m .41524 .70349 L .4239 .66668 L p F P
0 g
s
.927 .613 .428 r
.41524 .70349 m .45079 .73091 L .456 .75827 L p F P
0 g
s
.543 .645 .9 r
.56756 .55388 m .56666 .52369 L .6147 .53707 L p F P
0 g
s
.543 .645 .9 r
.6147 .53707 m .61497 .56719 L .56756 .55388 L p F P
0 g
s
.236 .05 .413 r
.63943 .72835 m .67271 .69996 L .66599 .7374 L p F P
0 g
s
.236 .05 .413 r
.66599 .7374 m .63432 .75589 L .63943 .72835 L p F P
0 g
s
.863 .884 .851 r
.46791 .53924 m .47008 .5693 L .43095 .59641 L p F P
0 g
s
.765 .82 .896 r
.47008 .5693 m .46791 .53924 L .51585 .52445 L p F P
0 g
s
.38 .503 .857 r
.61497 .56719 m .6147 .53707 L .65451 .56323 L p F P
0 g
s
.38 .503 .857 r
.65451 .56323 m .65427 .5932 L .61497 .56719 L p F P
0 g
s
.972 .771 .575 r
.40462 .63305 m .4239 .66668 L .41524 .70349 L p F P
0 g
s
.91 .789 .715 r
.4239 .66668 m .40462 .63305 L .43095 .59641 L p F P
0 g
s
.866 .428 .156 r
.42207 .74069 m .456 .75827 L .47212 .78246 L p F P
0 g
s
.927 .613 .428 r
.456 .75827 m .42207 .74069 L .41524 .70349 L p F P
0 g
s
.187 .138 .567 r
.66389 .66333 m .6808 .62914 L .69111 .67102 L p F P
0 g
s
.187 .138 .567 r
.69111 .67102 m .67271 .69996 L .66389 .66333 L p F P
0 g
s
.067 0 .121 r
.63432 .75589 m .66599 .7374 L .6442 .77105 L p F P
0 g
s
.067 0 .121 r
.6442 .77105 m .61826 .78053 L .63432 .75589 L p F P
0 g
s
.954 .924 .737 r
.42825 .56653 m .43095 .59641 L .40462 .63305 L p F P
0 g
s
.863 .884 .851 r
.43095 .59641 m .42825 .56653 L .46791 .53924 L p F P
0 g
s
.116 .259 .735 r
.65427 .5932 m .65451 .56323 L .68139 .5994 L p F P
0 g
s
.116 .259 .735 r
.68139 .5994 m .6808 .62914 L .65427 .5932 L p F P
0 g
s
.655 .099 0 r
.44391 .77371 m .47212 .78246 L .49733 .80041 L p F P
0 g
s
.866 .428 .156 r
.47212 .78246 m .44391 .77371 L .42207 .74069 L p F P
0 g
s
0 0 0 r
.61826 .78053 m .6442 .77105 L .60978 .79656 L p F P
0 g
s
0 0 0 r
.60978 .79656 m .59309 .79916 L .61826 .78053 L p F P
0 g
s
.972 .771 .575 r
.41524 .70349 m .39446 .67515 L .40462 .63305 L p F P
0 g
s
.966 .64 .281 r
.39446 .67515 m .41524 .70349 L .42207 .74069 L p F P
0 g
s
.682 .929 .97 r
.5173 .50761 m .51585 .52445 L .46791 .53924 L p F P
0 g
s
.541 .817 .997 r
.51585 .52445 m .5173 .50761 L .56272 .50693 L p F P
0 g
s
.541 .817 .997 r
.56272 .50693 m .56666 .52369 L .51585 .52445 L p F P
0 g
s
.339 .661 .972 r
.56666 .52369 m .56272 .50693 L .60563 .51884 L p F P
0 g
s
.339 .661 .972 r
.60563 .51884 m .6147 .53707 L .56666 .52369 L p F P
0 g
s
0 0 .241 r
.67271 .69996 m .69111 .67102 L .68353 .71395 L p F P
0 g
s
0 0 .241 r
.68353 .71395 m .66599 .7374 L .67271 .69996 L p F P
0 g
s
.328 0 0 r
.47834 .79829 m .49733 .80041 L .52855 .80979 L p F P
0 g
s
.655 .099 0 r
.49733 .80041 m .47834 .79829 L .44391 .77371 L p F P
0 g
s
.774 .996 .86 r
.47446 .52079 m .46791 .53924 L .42825 .56653 L p F P
0 g
s
.682 .929 .97 r
.46791 .53924 m .47446 .52079 L .5173 .50761 L p F P
0 g
s
0 0 0 r
.59309 .79916 m .60978 .79656 L .56695 .81057 L p F P
0 g
s
0 0 0 r
.56695 .81057 m .56188 .80936 L .59309 .79916 L p F P
0 g
s
.962 .849 .434 r
.40155 .60341 m .40462 .63305 L .39446 .67515 L p F P
0 g
s
.954 .924 .737 r
.40462 .63305 m .40155 .60341 L .42825 .56653 L p F P
0 g
s
.014 .398 .852 r
.6147 .53707 m .60563 .51884 L .64113 .54209 L p F P
0 g
s
.014 .398 .852 r
.64113 .54209 m .65451 .56323 L .6147 .53707 L p F P
0 g
s
.043 0 0 r
.52117 .81117 m .52855 .80979 L .56188 .80936 L p F P
0 g
s
.328 0 0 r
.52855 .80979 m .52117 .81117 L .47834 .79829 L p F P
0 g
s
.043 0 0 r
.56188 .80936 m .56695 .81057 L .52117 .81117 L p F P
0 g
s
0 0 .388 r
.6808 .62914 m .68139 .5994 L .69185 .64156 L p F P
0 g
s
0 0 .388 r
.69185 .64156 m .69111 .67102 L .6808 .62914 L p F P
0 g
s
.717 .257 0 r
.40214 .71779 m .42207 .74069 L .44391 .77371 L p F P
0 g
s
.966 .64 .281 r
.42207 .74069 m .40214 .71779 L .39446 .67515 L p F P
0 g
s
.724 .906 .537 r
.43908 .54506 m .42825 .56653 L .40155 .60341 L p F P
0 g
s
.774 .996 .86 r
.42825 .56653 m .43908 .54506 L .47446 .52079 L p F P
0 g
s
0 0 0 r
.66599 .7374 m .68353 .71395 L .65851 .75262 L p F P
0 g
s
0 0 0 r
.65851 .75262 m .6442 .77105 L .66599 .7374 L p F P
0 g
s
0 0 .484 r
.65451 .56323 m .64113 .54209 L .66501 .57419 L p F P
0 g
s
0 0 .484 r
.66501 .57419 m .68139 .5994 L .65451 .56323 L p F P
0 g
s
.962 .849 .434 r
.39446 .67515 m .39123 .6458 L .40155 .60341 L p F P
0 g
s
0 0 .19 r
.39123 .6458 m .39446 .67515 L .40214 .71779 L p F P
0 g
s
.853 .767 .259 r
.69111 .67102 m .69185 .64156 L .68417 .68479 L p F P
0 g
s
.853 .767 .259 r
.68417 .68479 m .68353 .71395 L .69111 .67102 L p F P
0 g
s
.717 .257 0 r
.44391 .77371 m .42719 .75572 L .40214 .71779 L p F P
0 g
s
0 .266 .739 r
.42719 .75572 m .44391 .77371 L .47834 .79829 L p F P
0 g
s
.339 .818 .791 r
.52155 .50287 m .5173 .50761 L .47446 .52079 L p F P
0 g
s
.191 .714 .865 r
.5173 .50761 m .52155 .50287 L .55593 .50235 L p F P
0 g
s
.191 .714 .865 r
.55593 .50235 m .56272 .50693 L .5173 .50761 L p F P
0 g
s
.668 .965 .767 r
.6442 .77105 m .65851 .75262 L .6188 .78201 L p F P
0 g
s
.668 .965 .767 r
.6188 .78201 m .60978 .79656 L .6442 .77105 L p F P
0 g
s
0 .474 .774 r
.56272 .50693 m .55593 .50235 L .58836 .51134 L p F P
0 g
s
0 .474 .774 r
.58836 .51134 m .60563 .51884 L .56272 .50693 L p F P
0 g
s
.724 .906 .537 r
.40155 .60341 m .41533 .57782 L .43908 .54506 L p F P
0 g
s
0 0 .057 r
.41533 .57782 m .40155 .60341 L .39123 .6458 L p F P
0 g
s
.919 .577 .118 r
.68139 .5994 m .66501 .57419 L .67419 .61156 L p F P
0 g
s
.919 .577 .118 r
.67419 .61156 m .69185 .64156 L .68139 .5994 L p F P
0 g
s
.339 .818 .791 r
.47446 .52079 m .48915 .51282 L .52155 .50287 L p F P
0 g
s
0 0 0 r
.48915 .51282 m .47446 .52079 L .43908 .54506 L p F P
0 g
s
.487 0 0 r
.60563 .51884 m .58836 .51134 L .6151 .52887 L p F P
0 g
s
.487 0 0 r
.6151 .52887 m .64113 .54209 L .60563 .51884 L p F P
0 g
s
.199 .616 .948 r
.46688 .78401 m .47834 .79829 L .52117 .81117 L p F P
0 g
s
0 .266 .739 r
.47834 .79829 m .46688 .78401 L .42719 .75572 L p F P
0 g
s
.61 .939 .951 r
.60978 .79656 m .6188 .78201 L .5693 .79816 L p F P
0 g
s
.61 .939 .951 r
.5693 .79816 m .56695 .81057 L .60978 .79656 L p F P
0 g
s
0 .152 .683 r
.39898 .68873 m .40214 .71779 L .42719 .75572 L p F P
0 g
s
0 0 .19 r
.40214 .71779 m .39898 .68873 L .39123 .6458 L p F P
0 g
s
.954 .952 .696 r
.68353 .71395 m .68417 .68479 L .65881 .72374 L p F P
0 g
s
.954 .952 .696 r
.65881 .72374 m .65851 .75262 L .68353 .71395 L p F P
0 g
s
.452 .816 .995 r
.51637 .79885 m .52117 .81117 L .56695 .81057 L p F P
0 g
s
.199 .616 .948 r
.52117 .81117 m .51637 .79885 L .46688 .78401 L p F P
0 g
s
0 0 0 r
.46248 .53113 m .43908 .54506 L .41533 .57782 L p F P
0 g
s
0 0 0 r
.43908 .54506 m .46248 .53113 L .48915 .51282 L p F P
0 g
s
.452 .816 .995 r
.56695 .81057 m .5693 .79816 L .51637 .79885 L p F P
0 g
s
.818 .338 0 r
.64113 .54209 m .6151 .52887 L .63295 .553 L p F P
0 g
s
.818 .338 0 r
.63295 .553 m .66501 .57419 L .64113 .54209 L p F P
0 g
s
0 0 .057 r
.39123 .6458 m .40625 .61538 L .41533 .57782 L p F P
0 g
s
.055 .028 .506 r
.40625 .61538 m .39123 .6458 L .39898 .68873 L p F P
0 g
s
.992 .783 .523 r
.69185 .64156 m .67419 .61156 L .66721 .64979 L p F P
0 g
s
.992 .783 .523 r
.66721 .64979 m .68417 .68479 L .69185 .64156 L p F P
0 g
s
.301 .472 .863 r
.42435 .72692 m .42719 .75572 L .46688 .78401 L p F P
0 g
s
0 .152 .683 r
.42719 .75572 m .42435 .72692 L .39898 .68873 L p F P
0 g
s
.113 0 .323 r
.44469 .55576 m .41533 .57782 L .40625 .61538 L p F P
0 g
s
0 0 0 r
.41533 .57782 m .44469 .55576 L .46248 .53113 L p F P
0 g
s
.872 .923 .857 r
.65851 .75262 m .65881 .72374 L .61857 .75336 L p F P
0 g
s
.872 .923 .857 r
.61857 .75336 m .6188 .78201 L .65851 .75262 L p F P
0 g
s
.94 .597 .348 r
.66501 .57419 m .63295 .553 L .63965 .58097 L p F P
0 g
s
.94 .597 .348 r
.63965 .58097 m .67419 .61156 L .66501 .57419 L p F P
0 g
s
.319 .324 .708 r
.41328 .65336 m .39898 .68873 L .42435 .72692 L p F P
0 g
s
.055 .028 .506 r
.39898 .68873 m .41328 .65336 L .40625 .61538 L p F P
0 g
s
.022 0 0 r
.52806 .50756 m .52155 .50287 L .48915 .51282 L p F P
0 g
s
.151 0 0 r
.52155 .50287 m .52806 .50756 L .54676 .50728 L p F P
0 g
s
.151 0 0 r
.54676 .50728 m .55593 .50235 L .52155 .50287 L p F P
0 g
s
.396 0 0 r
.55593 .50235 m .54676 .50728 L .56438 .51217 L p F P
0 g
s
.396 0 0 r
.56438 .51217 m .58836 .51134 L .55593 .50235 L p F P
0 g
s
.506 .646 .92 r
.46456 .75542 m .46688 .78401 L .51637 .79885 L p F P
0 g
s
.301 .472 .863 r
.46688 .78401 m .46456 .75542 L .42435 .72692 L p F P
0 g
s
.932 .814 .706 r
.68417 .68479 m .66721 .64979 L .64453 .68418 L p F P
0 g
s
.932 .814 .706 r
.64453 .68418 m .65881 .72374 L .68417 .68479 L p F P
0 g
s
.032 0 0 r
.51046 .51297 m .48915 .51282 L .46248 .53113 L p F P
0 g
s
.022 0 0 r
.48915 .51282 m .51046 .51297 L .52806 .50756 L p F P
0 g
s
.764 .85 .915 r
.6188 .78201 m .61857 .75336 L .56838 .76964 L p F P
0 g
s
.764 .85 .915 r
.56838 .76964 m .5693 .79816 L .6188 .78201 L p F P
0 g
s
.667 .118 0 r
.58836 .51134 m .56438 .51217 L .57882 .52168 L p F P
0 g
s
.667 .118 0 r
.57882 .52168 m .6151 .52887 L .58836 .51134 L p F P
0 g
s
.113 0 .323 r
.40625 .61538 m .43804 .58389 L .44469 .55576 L p F P
0 g
s
.308 .195 .558 r
.43804 .58389 m .40625 .61538 L .41328 .65336 L p F P
0 g
s
.647 .761 .932 r
.51472 .77035 m .51637 .79885 L .5693 .79816 L p F P
0 g
s
.506 .646 .92 r
.51637 .79885 m .51472 .77035 L .46456 .75542 L p F P
0 g
s
.647 .761 .932 r
.5693 .79816 m .56838 .76964 L .51472 .77035 L p F P
0 g
s
.933 .701 .564 r
.67419 .61156 m .63965 .58097 L .63419 .60948 L p F P
0 g
s
.933 .701 .564 r
.63419 .60948 m .66721 .64979 L .67419 .61156 L p F P
0 g
s
.144 0 .142 r
.49603 .52291 m .46248 .53113 L .44469 .55576 L p F P
0 g
s
.032 0 0 r
.46248 .53113 m .49603 .52291 L .51046 .51297 L p F P
0 g
s
.845 .404 .172 r
.6151 .52887 m .57882 .52168 L .58837 .53471 L p F P
0 g
s
.845 .404 .172 r
.58837 .53471 m .63295 .553 L .6151 .52887 L p F P
0 g
s
.482 .495 .794 r
.43596 .68706 m .42435 .72692 L .46456 .75542 L p F P
0 g
s
.319 .324 .708 r
.42435 .72692 m .43596 .68706 L .41328 .65336 L p F P
0 g
s
.852 .79 .79 r
.65881 .72374 m .64453 .68418 L .60868 .71029 L p F P
0 g
s
.852 .79 .79 r
.60868 .71029 m .61857 .75336 L .65881 .72374 L p F P
0 g
s
.281 .067 .401 r
.4865 .53621 m .44469 .55576 L .43804 .58389 L p F P
0 g
s
.144 0 .142 r
.44469 .55576 m .4865 .53621 L .49603 .52291 L p F P
0 g
s
.445 .373 .682 r
.44353 .61221 m .41328 .65336 L .43596 .68706 L p F P
0 g
s
.308 .195 .558 r
.41328 .65336 m .44353 .61221 L .43804 .58389 L p F P
0 g
s
.904 .576 .415 r
.63295 .553 m .58837 .53471 L .59183 .54973 L p F P
0 g
s
.904 .576 .415 r
.59183 .54973 m .63965 .58097 L .63295 .553 L p F P
0 g
s
.885 .726 .68 r
.66721 .64979 m .63419 .60948 L .61701 .63503 L p F P
0 g
s
.885 .726 .68 r
.61701 .63503 m .64453 .68418 L .66721 .64979 L p F P
0 g
s
.597 .605 .831 r
.47177 .71216 m .46456 .75542 L .51472 .77035 L p F P
0 g
s
.482 .495 .794 r
.46456 .75542 m .47177 .71216 L .43596 .68706 L p F P
0 g
s
.772 .744 .828 r
.61857 .75336 m .60868 .71029 L .56406 .72464 L p F P
0 g
s
.772 .744 .828 r
.56406 .72464 m .56838 .76964 L .61857 .75336 L p F P
0 g
s
.281 .067 .401 r
.43804 .58389 m .48306 .55133 L .4865 .53621 L p F P
0 g
s
.4 .255 .566 r
.48306 .55133 m .43804 .58389 L .44353 .61221 L p F P
0 g
s
.689 .684 .84 r
.51637 .72529 m .51472 .77035 L .56838 .76964 L p F P
0 g
s
.597 .605 .831 r
.51472 .77035 m .51637 .72529 L .47177 .71216 L p F P
0 g
s
.895 .656 .57 r
.63965 .58097 m .59183 .54973 L .58873 .56496 L p F P
0 g
s
.895 .656 .57 r
.58873 .56496 m .63419 .60948 L .63965 .58097 L p F P
0 g
s
.689 .684 .84 r
.56838 .76964 m .56406 .72464 L .51637 .72529 L p F P
0 g
s
.547 .492 .746 r
.4607 .63724 m .43596 .68706 L .47177 .71216 L p F P
0 g
s
.445 .373 .682 r
.43596 .68706 m .4607 .63724 L .44353 .61221 L p F P
0 g
s
.826 .715 .743 r
.64453 .68418 m .61701 .63503 L .59007 .65437 L p F P
0 g
s
.826 .715 .743 r
.59007 .65437 m .60868 .71029 L .64453 .68418 L p F P
0 g
s
.165 0 0 r
.53603 .51772 m .52806 .50756 L .51046 .51297 L closepath p F P
0 g
s
.284 0 0 r
.53603 .51772 m .54676 .50728 L .52806 .50756 L closepath p F P
0 g
s
.491 0 0 r
.53603 .51772 m .56438 .51217 L .54676 .50728 L closepath p F P
0 g
s
.16 0 0 r
.53603 .51772 m .51046 .51297 L .49603 .52291 L closepath p F P
0 g
s
.705 .185 0 r
.53603 .51772 m .57882 .52168 L .56438 .51217 L closepath p F P
0 g
s
.496 .39 .664 r
.48616 .56645 m .44353 .61221 L .4607 .63724 L p F P
0 g
s
.4 .255 .566 r
.44353 .61221 m .48616 .56645 L .48306 .55133 L p F P
0 g
s
.857 .682 .663 r
.63419 .60948 m .58873 .56496 L .57938 .57853 L p F P
0 g
s
.857 .682 .663 r
.57938 .57853 m .61701 .63503 L .63419 .60948 L p F P
0 g
s
.236 0 .212 r
.53603 .51772 m .49603 .52291 L .4865 .53621 L closepath p F P
0 g
s
.629 .576 .777 r
.48762 .6558 m .47177 .71216 L .51637 .72529 L p F P
0 g
s
.547 .492 .746 r
.47177 .71216 m .48762 .6558 L .4607 .63724 L p F P
0 g
s
.84 .419 .234 r
.53603 .51772 m .58837 .53471 L .57882 .52168 L closepath p F P
0 g
s
.764 .684 .775 r
.60868 .71029 m .59007 .65437 L .55667 .66499 L p F P
0 g
s
.764 .684 .775 r
.55667 .66499 m .56406 .72464 L .60868 .71029 L p F P
0 g
s
.337 .117 .425 r
.53603 .51772 m .4865 .53621 L .48306 .55133 L closepath p F P
0 g
s
.886 .565 .436 r
.53603 .51772 m .59183 .54973 L .58837 .53471 L closepath p F P
0 g
s
.699 .639 .785 r
.52101 .66548 m .51637 .72529 L .56406 .72464 L p F P
0 g
s
.629 .576 .777 r
.51637 .72529 m .52101 .66548 L .48762 .6558 L p F P
0 g
s
.699 .639 .785 r
.56406 .72464 m .55667 .66499 L .52101 .66548 L p F P
0 g
s
.574 .488 .719 r
.49551 .57974 m .4607 .63724 L .48762 .6558 L p F P
0 g
s
.496 .39 .664 r
.4607 .63724 m .49551 .57974 L .48616 .56645 L p F P
0 g
s
.81 .677 .717 r
.61701 .63503 m .57938 .57853 L .56487 .58876 L p F P
0 g
s
.81 .677 .717 r
.56487 .58876 m .59007 .65437 L .61701 .63503 L p F P
0 g
s
.433 .276 .568 r
.53603 .51772 m .48306 .55133 L .48616 .56645 L closepath p F P
0 g
s
.878 .638 .571 r
.53603 .51772 m .58873 .56496 L .59183 .54973 L closepath p F P
0 g
s
.642 .56 .747 r
.51001 .58955 m .48762 .6558 L .52101 .66548 L p F P
0 g
s
.574 .488 .719 r
.48762 .6558 m .51001 .58955 L .49551 .57974 L p F P
0 g
s
.757 .653 .746 r
.59007 .65437 m .56487 .58876 L .54698 .59437 L p F P
0 g
s
.757 .653 .746 r
.54698 .59437 m .55667 .66499 L .59007 .65437 L p F P
0 g
s
.515 .396 .656 r
.53603 .51772 m .48616 .56645 L .49551 .57974 L closepath p F P
0 g
s
.846 .663 .655 r
.53603 .51772 m .57938 .57853 L .58873 .56496 L closepath p F P
0 g
s
.702 .614 .755 r
.5279 .59464 m .52101 .66548 L .55667 .66499 L p F P
0 g
s
.642 .56 .747 r
.52101 .66548 m .5279 .59464 L .51001 .58955 L p F P
0 g
s
.702 .614 .755 r
.55667 .66499 m .54698 .59437 L .5279 .59464 L p F P
0 g
s
.585 .486 .708 r
.53603 .51772 m .49551 .57974 L .51001 .58955 L closepath p F P
0 g
s
.802 .66 .706 r
.53603 .51772 m .56487 .58876 L .57938 .57853 L closepath p F P
0 g
s
.647 .553 .734 r
.53603 .51772 m .51001 .58955 L .5279 .59464 L closepath p F P
0 g
s
.754 .639 .733 r
.53603 .51772 m .54698 .59437 L .56487 .58876 L closepath p F P
0 g
s
.702 .603 .742 r
.53603 .51772 m .5279 .59464 L .54698 .59437 L closepath p F P
0 g
s
.337 .117 .425 r
.58736 .49856 m .53603 .51772 L .59055 .48313 L closepath p F P
0 g
s
.236 0 .212 r
.57773 .51232 m .53603 .51772 L .58736 .49856 L closepath p F P
0 g
s
.16 0 0 r
.5628 .5227 m .53603 .51772 L .57773 .51232 L closepath p F P
0 g
s
.165 0 0 r
.54439 .5284 m .53603 .51772 L .5628 .5227 L closepath p F P
0 g
s
.284 0 0 r
.52476 .52869 m .53603 .51772 L .54439 .5284 L closepath p F P
0 g
s
.491 0 0 r
.50635 .52354 m .53603 .51772 L .52476 .52869 L closepath p F P
0 g
s
.705 .185 0 r
.49145 .5136 m .53603 .51772 L .50635 .52354 L closepath p F P
0 g
s
.84 .419 .234 r
.48184 .50014 m .53603 .51772 L .49145 .5136 L closepath p F P
0 g
s
.886 .565 .436 r
.47866 .48482 m .53603 .51772 L .48184 .50014 L closepath p F P
0 g
s
.878 .638 .571 r
.48222 .4695 m .53603 .51772 L .47866 .48482 L closepath p F P
0 g
s
.846 .663 .655 r
.49203 .45602 m .53603 .51772 L .48222 .4695 L closepath p F P
0 g
s
.802 .66 .706 r
.50688 .44595 m .53603 .51772 L .49203 .45602 L closepath p F P
0 g
s
.754 .639 .733 r
.52499 .44045 m .53603 .51772 L .50688 .44595 L closepath p F P
0 g
s
.702 .603 .742 r
.54422 .44016 m .53603 .51772 L .52499 .44045 L closepath p F P
0 g
s
.647 .553 .734 r
.56233 .4451 m .53603 .51772 L .54422 .44016 L closepath p F P
0 g
s
.585 .486 .708 r
.57718 .45472 m .53603 .51772 L .56233 .4451 L closepath p F P
0 g
s
.515 .396 .656 r
.587 .46791 m .53603 .51772 L .57718 .45472 L closepath p F P
0 g
s
.433 .276 .568 r
.59055 .48313 m .53603 .51772 L .587 .46791 L closepath p F P
0 g
s
.757 .652 .746 r
.51499 .36767 m .52499 .44045 L .50688 .44595 L p F P
0 g
s
.702 .614 .755 r
.52499 .44045 m .51499 .36767 L .55134 .3671 L p F P
0 g
s
.702 .614 .755 r
.55134 .3671 m .54422 .44016 L .52499 .44045 L p F P
0 g
s
.642 .56 .747 r
.54422 .44016 m .55134 .3671 L .58562 .37626 L p F P
0 g
s
.642 .56 .747 r
.58562 .37626 m .56233 .4451 L .54422 .44016 L p F P
0 g
s
.809 .676 .717 r
.48073 .37792 m .50688 .44595 L .49203 .45602 L p F P
0 g
s
.757 .652 .746 r
.50688 .44595 m .48073 .37792 L .51499 .36767 L p F P
0 g
s
.575 .488 .719 r
.56233 .4451 m .58562 .37626 L .61388 .39419 L p F P
0 g
s
.575 .488 .719 r
.61388 .39419 m .57718 .45472 L .56233 .4451 L p F P
0 g
s
.857 .681 .663 r
.45249 .39672 m .49203 .45602 L .48222 .4695 L p F P
0 g
s
.809 .676 .717 r
.49203 .45602 m .45249 .39672 L .48073 .37792 L p F P
0 g
s
.497 .391 .664 r
.57718 .45472 m .61388 .39419 L .63276 .41891 L p F P
0 g
s
.497 .391 .664 r
.63276 .41891 m .587 .46791 L .57718 .45472 L p F P
0 g
s
.763 .683 .774 r
.50703 .30366 m .51499 .36767 L .48073 .37792 L p F P
0 g
s
.699 .638 .784 r
.51499 .36767 m .50703 .30366 L .55637 .30286 L p F P
0 g
s
.699 .638 .784 r
.55637 .30286 m .55134 .3671 L .51499 .36767 L p F P
0 g
s
.63 .576 .775 r
.55134 .3671 m .55637 .30286 L .60298 .3151 L p F P
0 g
s
.63 .576 .775 r
.60298 .3151 m .58562 .37626 L .55134 .3671 L p F P
0 g
s
.894 .656 .571 r
.43362 .422 m .48222 .4695 L .47866 .48482 L p F P
0 g
s
.857 .681 .663 r
.48222 .4695 m .43362 .422 L .45249 .39672 L p F P
0 g
s
.401 .257 .567 r
.587 .46791 m .63276 .41891 L .63985 .44761 L p F P
0 g
s
.401 .257 .567 r
.63985 .44761 m .59055 .48313 L .587 .46791 L p F P
0 g
s
.824 .713 .742 r
.46045 .31741 m .48073 .37792 L .45249 .39672 L p F P
0 g
s
.763 .683 .774 r
.48073 .37792 m .46045 .31741 L .50703 .30366 L p F P
0 g
s
.55 .494 .745 r
.58562 .37626 m .60298 .3151 L .64156 .33913 L p F P
0 g
s
.55 .494 .745 r
.64156 .33913 m .61388 .39419 L .58562 .37626 L p F P
0 g
s
.904 .577 .417 r
.4265 .45088 m .47866 .48482 L .48184 .50014 L p F P
0 g
s
.894 .656 .571 r
.47866 .48482 m .4265 .45088 L .43362 .422 L p F P
0 g
s
.284 .071 .403 r
.59055 .48313 m .63985 .44761 L .63407 .47689 L p F P
0 g
s
.284 .071 .403 r
.63407 .47689 m .58736 .49856 L .59055 .48313 L p F P
0 g
s
.881 .723 .681 r
.42191 .34265 m .45249 .39672 L .43362 .422 L p F P
0 g
s
.824 .713 .742 r
.45249 .39672 m .42191 .34265 L .46045 .31741 L p F P
0 g
s
.452 .378 .683 r
.61388 .39419 m .64156 .33913 L .66754 .3724 L p F P
0 g
s
.452 .378 .683 r
.66754 .3724 m .63276 .41891 L .61388 .39419 L p F P
0 g
s
.769 .736 .822 r
.50183 .2515 m .50703 .30366 L .46045 .31741 L p F P
0 g
s
.691 .679 .834 r
.50703 .30366 m .50183 .2515 L .55856 .25056 L p F P
0 g
s
.691 .679 .834 r
.55856 .25056 m .55637 .30286 L .50703 .30366 L p F P
0 g
s
.604 .605 .825 r
.55637 .30286 m .55856 .25056 L .61218 .26443 L p F P
0 g
s
.604 .605 .825 r
.61218 .26443 m .60298 .3151 L .55637 .30286 L p F P
0 g
s
.846 .406 .176 r
.43223 .47995 m .48184 .50014 L .49145 .5136 L p F P
0 g
s
.904 .577 .417 r
.48184 .50014 m .43223 .47995 L .4265 .45088 L p F P
0 g
s
.149 0 .147 r
.58736 .49856 m .63407 .47689 L .61588 .50316 L p F P
0 g
s
.149 0 .147 r
.61588 .50316 m .57773 .51232 L .58736 .49856 L p F P
0 g
s
.846 .779 .787 r
.44825 .26714 m .46045 .31741 L .42191 .34265 L p F P
0 g
s
.769 .736 .822 r
.46045 .31741 m .44825 .26714 L .50183 .2515 L p F P
0 g
s
.67 .123 0 r
.45035 .50564 m .49145 .5136 L .50635 .52354 L p F P
0 g
s
.846 .406 .176 r
.49145 .5136 m .45035 .50564 L .43223 .47995 L p F P
0 g
s
.498 .502 .791 r
.60298 .3151 m .61218 .26443 L .65666 .29174 L p F P
0 g
s
.498 .502 .791 r
.65666 .29174 m .64156 .33913 L .60298 .3151 L p F P
0 g
s
.039 0 0 r
.57773 .51232 m .61588 .50316 L .58734 .52309 L p F P
0 g
s
.039 0 0 r
.58734 .52309 m .5628 .5227 L .57773 .51232 L p F P
0 g
s
.929 .699 .569 r
.39594 .37669 m .43362 .422 L .4265 .45088 L p F P
0 g
s
.881 .723 .681 r
.43362 .422 m .39594 .37669 L .42191 .34265 L p F P
0 g
s
.32 .206 .564 r
.63276 .41891 m .66754 .3724 L .67756 .41121 L p F P
0 g
s
.32 .206 .564 r
.67756 .41121 m .63985 .44761 L .63276 .41891 L p F P
0 g
s
.402 0 0 r
.47881 .5247 m .50635 .52354 L .52476 .52869 L p F P
0 g
s
.67 .123 0 r
.50635 .52354 m .47881 .5247 L .45035 .50564 L p F P
0 g
s
.029 0 0 r
.5628 .5227 m .58734 .52309 L .55194 .53405 L p F P
0 g
s
.029 0 0 r
.55194 .53405 m .54439 .5284 L .5628 .5227 L p F P
0 g
s
.158 0 0 r
.51416 .53461 m .52476 .52869 L .54439 .5284 L p F P
0 g
s
.402 0 0 r
.52476 .52869 m .51416 .53461 L .47881 .5247 L p F P
0 g
s
.158 0 0 r
.54439 .5284 m .55194 .53405 L .51416 .53461 L p F P
0 g
s
.921 .802 .711 r
.4038 .29587 m .42191 .34265 L .39594 .37669 L p F P
0 g
s
.846 .779 .787 r
.42191 .34265 m .4038 .29587 L .44825 .26714 L p F P
0 g
s
.352 .347 .713 r
.64156 .33913 m .65666 .29174 L .68676 .32965 L p F P
0 g
s
.352 .347 .713 r
.68676 .32965 m .66754 .3724 L .64156 .33913 L p F P
0 g
s
.765 .82 .896 r
.49985 .21285 m .50183 .2515 L .44825 .26714 L p F P
0 g
s
.663 .743 .909 r
.50183 .2515 m .49985 .21285 L .55741 .21188 L p F P
0 g
s
.663 .743 .909 r
.55741 .21188 m .55856 .25056 L .50183 .2515 L p F P
0 g
s
.938 .601 .363 r
.38587 .41575 m .4265 .45088 L .43223 .47995 L p F P
0 g
s
.929 .699 .569 r
.4265 .45088 m .38587 .41575 L .39594 .37669 L p F P
0 g
s
.543 .645 .9 r
.55856 .25056 m .55741 .21188 L .61182 .22581 L p F P
0 g
s
.543 .645 .9 r
.61182 .22581 m .61218 .26443 L .55856 .25056 L p F P
0 g
s
.136 0 .341 r
.63985 .44761 m .67756 .41121 L .66998 .45102 L p F P
0 g
s
.136 0 .341 r
.66998 .45102 m .63407 .47689 L .63985 .44761 L p F P
0 g
s
.863 .884 .851 r
.44546 .22859 m .44825 .26714 L .4038 .29587 L p F P
0 g
s
.765 .82 .896 r
.44825 .26714 m .44546 .22859 L .49985 .21285 L p F P
0 g
s
.38 .503 .857 r
.61218 .26443 m .61182 .22581 L .65697 .25324 L p F P
0 g
s
.38 .503 .857 r
.65697 .25324 m .65666 .29174 L .61218 .26443 L p F P
0 g
s
.983 .778 .552 r
.37371 .33468 m .39594 .37669 L .38587 .41575 L p F P
0 g
s
.921 .802 .711 r
.39594 .37669 m .37371 .33468 L .4038 .29587 L p F P
0 g
s
.83 .356 .011 r
.39334 .45526 m .43223 .47995 L .45035 .50564 L p F P
0 g
s
.938 .601 .363 r
.43223 .47995 m .39334 .45526 L .38587 .41575 L p F P
0 g
s
.125 .087 .54 r
.66754 .3724 m .68676 .32965 L .69853 .37399 L p F P
0 g
s
.125 .087 .54 r
.69853 .37399 m .67756 .41121 L .66754 .3724 L p F P
0 g
s
0 0 0 r
.63407 .47689 m .66998 .45102 L .64528 .48691 L p F P
0 g
s
0 0 0 r
.64528 .48691 m .61588 .50316 L .63407 .47689 L p F P
0 g
s
.954 .924 .737 r
.40033 .25749 m .4038 .29587 L .37371 .33468 L p F P
0 g
s
.863 .884 .851 r
.4038 .29587 m .40033 .25749 L .44546 .22859 L p F P
0 g
s
.116 .259 .735 r
.65666 .29174 m .65697 .25324 L .68752 .29135 L p F P
0 g
s
.116 .259 .735 r
.68752 .29135 m .68676 .32965 L .65666 .29174 L p F P
0 g
s
.521 0 0 r
.4179 .49034 m .45035 .50564 L .47881 .5247 L p F P
0 g
s
.83 .356 .011 r
.45035 .50564 m .4179 .49034 L .39334 .45526 L p F P
0 g
s
0 0 0 r
.61588 .50316 m .64528 .48691 L .60617 .51423 L p F P
0 g
s
0 0 0 r
.60617 .51423 m .58734 .52309 L .61588 .50316 L p F P
0 g
s
.949 .614 .206 r
.36186 .37931 m .38587 .41575 L .39334 .45526 L p F P
0 g
s
.983 .778 .552 r
.38587 .41575 m .36186 .37931 L .37371 .33468 L p F P
0 g
s
.704 .915 .967 r
.5012 .18788 m .49985 .21285 L .44546 .22859 L p F P
0 g
s
.571 .811 .989 r
.49985 .21285 m .5012 .18788 L .55277 .18701 L p F P
0 g
s
.571 .811 .989 r
.55277 .18701 m .55741 .21188 L .49985 .21285 L p F P
0 g
s
.391 .671 .971 r
.55741 .21188 m .55277 .18701 L .60147 .19939 L p F P
0 g
s
.391 .671 .971 r
.60147 .19939 m .61182 .22581 L .55741 .21188 L p F P
0 g
s
0 0 .154 r
.67756 .41121 m .69853 .37399 L .68999 .41962 L p F P
0 g
s
0 0 .154 r
.68999 .41962 m .66998 .45102 L .67756 .41121 L p F P
0 g
s
.521 0 0 r
.47881 .5247 m .45685 .51646 L .4179 .49034 L p F P
0 g
s
0 .445 .739 r
.45685 .51646 m .47881 .5247 L .51416 .53461 L p F P
0 g
s
.802 .99 .881 r
.4525 .20191 m .44546 .22859 L .40033 .25749 L p F P
0 g
s
.704 .915 .967 r
.44546 .22859 m .4525 .20191 L .5012 .18788 L p F P
0 g
s
.303 .793 .758 r
.58734 .52309 m .60617 .51423 L .55748 .52931 L p F P
0 g
s
.303 .793 .758 r
.55748 .52931 m .55194 .53405 L .58734 .52309 L p F P
0 g
s
.962 .849 .434 r
.36976 .29653 m .37371 .33468 L .36186 .37931 L p F P
0 g
s
.954 .924 .737 r
.37371 .33468 m .36976 .29653 L .40033 .25749 L p F P
0 g
s
.108 .445 .88 r
.61182 .22581 m .60147 .19939 L .64181 .22377 L p F P
0 g
s
.108 .445 .88 r
.64181 .22377 m .65697 .25324 L .61182 .22581 L p F P
0 g
s
.155 .692 .838 r
.50545 .53008 m .51416 .53461 L .55194 .53405 L p F P
0 g
s
0 .445 .739 r
.51416 .53461 m .50545 .53008 L .45685 .51646 L p F P
0 g
s
.155 .692 .838 r
.55194 .53405 m .55748 .52931 L .50545 .53008 L p F P
0 g
s
0 0 .388 r
.68676 .32965 m .68752 .29135 L .69948 .33596 L p F P
0 g
s
0 0 .388 r
.69948 .33596 m .69853 .37399 L .68676 .32965 L p F P
0 g
s
.614 .165 0 r
.37023 .42457 m .39334 .45526 L .4179 .49034 L p F P
0 g
s
.949 .614 .206 r
.39334 .45526 m .37023 .42457 L .36186 .37931 L p F P
0 g
s
.803 .956 .624 r
.41215 .22762 m .40033 .25749 L .36976 .29653 L p F P
0 g
s
.802 .99 .881 r
.40033 .25749 m .41215 .22762 L .4525 .20191 L p F P
0 g
s
.626 .833 .434 r
.66998 .45102 m .68999 .41962 L .66158 .46087 L p F P
0 g
s
.626 .833 .434 r
.66158 .46087 m .64528 .48691 L .66998 .45102 L p F P
0 g
s
0 .025 .585 r
.65697 .25324 m .64181 .22377 L .66898 .25759 L p F P
0 g
s
0 .025 .585 r
.66898 .25759 m .68752 .29135 L .65697 .25324 L p F P
0 g
s
.962 .849 .434 r
.36186 .37931 m .35768 .34144 L .36976 .29653 L p F P
0 g
s
0 0 .19 r
.35768 .34144 m .36186 .37931 L .37023 .42457 L p F P
0 g
s
.853 .767 .259 r
.69853 .37399 m .69948 .33596 L .69082 .38187 L p F P
0 g
s
.853 .767 .259 r
.69082 .38187 m .68999 .41962 L .69853 .37399 L p F P
0 g
s
.614 .165 0 r
.4179 .49034 m .39842 .46487 L .37023 .42457 L p F P
0 g
s
0 .341 .808 r
.39842 .46487 m .4179 .49034 L .45685 .51646 L p F P
0 g
s
.494 .902 .91 r
.50567 .17528 m .5012 .18788 L .4525 .20191 L p F P
0 g
s
.35 .791 .961 r
.5012 .18788 m .50567 .17528 L .54481 .17461 L p F P
0 g
s
.35 .791 .961 r
.54481 .17461 m .55277 .18701 L .5012 .18788 L p F P
0 g
s
.732 .99 .825 r
.64528 .48691 m .66158 .46087 L .61639 .49234 L p F P
0 g
s
.732 .99 .825 r
.61639 .49234 m .60617 .51423 L .64528 .48691 L p F P
0 g
s
.099 .591 .903 r
.55277 .18701 m .54481 .17461 L .58171 .18397 L p F P
0 g
s
.099 .591 .903 r
.58171 .18397 m .60147 .19939 L .55277 .18701 L p F P
0 g
s
.803 .956 .624 r
.36976 .29653 m .38491 .26228 L .41215 .22762 L p F P
0 g
s
0 0 0 r
.38491 .26228 m .36976 .29653 L .35768 .34144 L p F P
0 g
s
.864 .521 .011 r
.68752 .29135 m .66898 .25759 L .67948 .29709 L p F P
0 g
s
.864 .521 .011 r
.67948 .29709 m .69948 .33596 L .68752 .29135 L p F P
0 g
s
.521 .896 .71 r
.46874 .18589 m .4525 .20191 L .41215 .22762 L p F P
0 g
s
.494 .902 .91 r
.4525 .20191 m .46874 .18589 L .50567 .17528 L p F P
0 g
s
0 .249 .678 r
.60147 .19939 m .58171 .18397 L .61215 .20235 L p F P
0 g
s
0 .249 .678 r
.61215 .20235 m .64181 .22377 L .60147 .19939 L p F P
0 g
s
.278 .644 .966 r
.4434 .49494 m .45685 .51646 L .50545 .53008 L p F P
0 g
s
0 .341 .808 r
.45685 .51646 m .4434 .49494 L .39842 .46487 L p F P
0 g
s
.653 .938 .966 r
.60617 .51423 m .61639 .49234 L .55998 .50974 L p F P
0 g
s
.653 .938 .966 r
.55998 .50974 m .55748 .52931 L .60617 .51423 L p F P
0 g
s
0 .152 .683 r
.36614 .38698 m .37023 .42457 L .39842 .46487 L p F P
0 g
s
0 0 .19 r
.37023 .42457 m .36614 .38698 L .35768 .34144 L p F P
0 g
s
.954 .952 .696 r
.68999 .41962 m .69082 .38187 L .66197 .42341 L p F P
0 g
s
.954 .952 .696 r
.66197 .42341 m .66158 .46087 L .68999 .41962 L p F P
0 g
s
.503 .82 1 r
.49968 .51064 m .50545 .53008 L .55748 .52931 L p F P
0 g
s
.278 .644 .966 r
.50545 .53008 m .49968 .51064 L .4434 .49494 L p F P
0 g
s
.521 .896 .71 r
.41215 .22762 m .43826 .20529 L .46874 .18589 L p F P
0 g
s
0 0 0 r
.43826 .20529 m .41215 .22762 L .38491 .26228 L p F P
0 g
s
.503 .82 1 r
.55748 .52931 m .55998 .50974 L .49968 .51064 L p F P
0 g
s
.724 .221 0 r
.64181 .22377 m .61215 .20235 L .63249 .22776 L p F P
0 g
s
.724 .221 0 r
.63249 .22776 m .66898 .25759 L .64181 .22377 L p F P
0 g
s
0 0 .461 r
.37427 .30205 m .35768 .34144 L .36614 .38698 L p F P
0 g
s
0 0 0 r
.35768 .34144 m .37427 .30205 L .38491 .26228 L p F P
0 g
s
.998 .786 .485 r
.69948 .33596 m .67948 .29709 L .67157 .33766 L p F P
0 g
s
.998 .786 .485 r
.67157 .33766 m .69082 .38187 L .69948 .33596 L p F P
0 g
s
.301 .472 .863 r
.39473 .42754 m .39842 .46487 L .4434 .49494 L p F P
0 g
s
0 .152 .683 r
.39842 .46487 m .39473 .42754 L .36614 .38698 L p F P
0 g
s
0 0 .212 r
.41783 .23135 m .38491 .26228 L .37427 .30205 L p F P
0 g
s
0 0 0 r
.38491 .26228 m .41783 .23135 L .43826 .20529 L p F P
0 g
s
.872 .923 .857 r
.66158 .46087 m .66197 .42341 L .61608 .45511 L p F P
0 g
s
.872 .923 .857 r
.61608 .45511 m .61639 .49234 L .66158 .46087 L p F P
0 g
s
.938 .568 .25 r
.66898 .25759 m .63249 .22776 L .64014 .25731 L p F P
0 g
s
.938 .568 .25 r
.64014 .25731 m .67948 .29709 L .66898 .25759 L p F P
0 g
s
.277 .295 .7 r
.38197 .3423 m .36614 .38698 L .39473 .42754 L p F P
0 g
s
0 0 .461 r
.36614 .38698 m .38197 .3423 L .37427 .30205 L p F P
0 g
s
.223 .736 .705 r
.5127 .17223 m .50567 .17528 L .46874 .18589 L p F P
0 g
s
.089 .647 .781 r
.50567 .17528 m .5127 .17223 L .53406 .17187 L p F P
0 g
s
.089 .647 .781 r
.53406 .17187 m .54481 .17461 L .50567 .17528 L p F P
0 g
s
0 .418 .686 r
.54481 .17461 m .53406 .17187 L .55416 .17696 L p F P
0 g
s
0 .418 .686 r
.55416 .17696 m .58171 .18397 L .54481 .17461 L p F P
0 g
s
.506 .646 .92 r
.44039 .4578 m .4434 .49494 L .49968 .51064 L p F P
0 g
s
.301 .472 .863 r
.4434 .49494 m .44039 .4578 L .39473 .42754 L p F P
0 g
s
.944 .829 .7 r
.69082 .38187 m .67157 .33766 L .6457 .37429 L p F P
0 g
s
.944 .829 .7 r
.6457 .37429 m .66197 .42341 L .69082 .38187 L p F P
0 g
s
.223 .736 .705 r
.46874 .18589 m .49258 .17801 L .5127 .17223 L p F P
0 g
s
0 0 0 r
.49258 .17801 m .46874 .18589 L .43826 .20529 L p F P
0 g
s
.764 .85 .915 r
.61639 .49234 m .61608 .45511 L .55878 .47266 L p F P
0 g
s
.764 .85 .915 r
.55878 .47266 m .55998 .50974 L .61639 .49234 L p F P
0 g
s
.522 0 0 r
.58171 .18397 m .55416 .17696 L .57063 .18694 L p F P
0 g
s
.522 0 0 r
.57063 .18694 m .61215 .20235 L .58171 .18397 L p F P
0 g
s
.231 .123 .519 r
.41005 .26112 m .37427 .30205 L .38197 .3423 L p F P
0 g
s
0 0 .212 r
.37427 .30205 m .41005 .26112 L .41783 .23135 L p F P
0 g
s
.647 .761 .932 r
.49753 .47359 m .49968 .51064 L .55998 .50974 L p F P
0 g
s
.506 .646 .92 r
.49968 .51064 m .49753 .47359 L .44039 .4578 L p F P
0 g
s
.647 .761 .932 r
.55998 .50974 m .55878 .47266 L .49753 .47359 L p F P
0 g
s
.953 .708 .529 r
.67948 .29709 m .64014 .25731 L .6339 .28753 L p F P
0 g
s
.953 .708 .529 r
.6339 .28753 m .67157 .33766 L .67948 .29709 L p F P
0 g
s
0 0 0 r
.47605 .18855 m .43826 .20529 L .41783 .23135 L p F P
0 g
s
0 0 0 r
.43826 .20529 m .47605 .18855 L .49258 .17801 L p F P
0 g
s
.804 .314 0 r
.61215 .20235 m .57063 .18694 L .58152 .20066 L p F P
0 g
s
.804 .314 0 r
.58152 .20066 m .63249 .22776 L .61215 .20235 L p F P
0 g
s
.462 .486 .798 r
.40759 .37805 m .39473 .42754 L .44039 .4578 L p F P
0 g
s
.277 .295 .7 r
.39473 .42754 m .40759 .37805 L .38197 .3423 L p F P
0 g
s
.86 .803 .793 r
.66197 .42341 m .6457 .37429 L .60474 .40221 L p F P
0 g
s
.86 .803 .793 r
.60474 .40221 m .61608 .45511 L .66197 .42341 L p F P
0 g
s
.165 0 .308 r
.46509 .20263 m .41783 .23135 L .41005 .26112 L p F P
0 g
s
0 0 0 r
.41783 .23135 m .46509 .20263 L .47605 .18855 L p F P
0 g
s
.406 .342 .672 r
.4161 .29109 m .38197 .3423 L .40759 .37805 L p F P
0 g
s
.231 .123 .519 r
.38197 .3423 m .4161 .29109 L .41005 .26112 L p F P
0 g
s
.916 .555 .332 r
.63249 .22776 m .58152 .20066 L .58545 .21653 L p F P
0 g
s
.916 .555 .332 r
.58545 .21653 m .64014 .25731 L .63249 .22776 L p F P
0 g
s
.902 .741 .672 r
.67157 .33766 m .6339 .28753 L .61426 .3147 L p F P
0 g
s
.902 .741 .672 r
.61426 .3147 m .6457 .37429 L .67157 .33766 L p F P
0 g
s
.588 .606 .838 r
.44833 .40466 m .44039 .4578 L .49753 .47359 L p F P
0 g
s
.462 .486 .798 r
.44039 .4578 m .44833 .40466 L .40759 .37805 L p F P
0 g
s
.775 .754 .834 r
.61608 .45511 m .60474 .40221 L .55372 .41766 L p F P
0 g
s
.775 .754 .834 r
.55372 .41766 m .55878 .47266 L .61608 .45511 L p F P
0 g
s
.335 .189 .53 r
.46107 .21862 m .41005 .26112 L .4161 .29109 L p F P
0 g
s
.165 0 .308 r
.41005 .26112 m .46107 .21862 L .46509 .20263 L p F P
0 g
s
.687 .69 .847 r
.49921 .41851 m .49753 .47359 L .55878 .47266 L p F P
0 g
s
.588 .606 .838 r
.49753 .47359 m .49921 .41851 L .44833 .40466 L p F P
0 g
s
.917 .661 .537 r
.64014 .25731 m .58545 .21653 L .58188 .23265 L p F P
0 g
s
.917 .661 .537 r
.58188 .23265 m .6339 .28753 L .64014 .25731 L p F P
0 g
s
.687 .69 .847 r
.55878 .47266 m .55372 .41766 L .49921 .41851 L p F P
0 g
s
.527 .481 .748 r
.43556 .31759 m .40759 .37805 L .44833 .40466 L p F P
0 g
s
.406 .342 .672 r
.40759 .37805 m .43556 .31759 L .4161 .29109 L p F P
0 g
s
.837 .729 .745 r
.6457 .37429 m .61426 .3147 L .58342 .33535 L p F P
0 g
s
.837 .729 .745 r
.58342 .33535 m .60474 .40221 L .6457 .37429 L p F P
0 g
s
0 0 0 r
.5214 .17458 m .5127 .17223 L .49258 .17801 L closepath p F P
0 g
s
.048 0 0 r
.5214 .17458 m .53406 .17187 L .5127 .17223 L closepath p F P
0 g
s
.293 0 0 r
.5214 .17458 m .55416 .17696 L .53406 .17187 L closepath p F P
0 g
s
0 0 0 r
.5214 .17458 m .49258 .17801 L .47605 .18855 L closepath p F P
0 g
s
.593 .019 0 r
.5214 .17458 m .57063 .18694 L .55416 .17696 L closepath p F P
0 g
s
.46 .359 .653 r
.46453 .2346 m .4161 .29109 L .43556 .31759 L p F P
0 g
s
.335 .189 .53 r
.4161 .29109 m .46453 .2346 L .46107 .21862 L p F P
0 g
s
.875 .694 .653 r
.6339 .28753 m .58188 .23265 L .57115 .24705 L p F P
0 g
s
.875 .694 .653 r
.57115 .24705 m .61426 .3147 L .6339 .28753 L p F P
0 g
s
.07 0 .041 r
.5214 .17458 m .47605 .18855 L .46509 .20263 L closepath p F P
0 g
s
.62 .576 .783 r
.46623 .33722 m .44833 .40466 L .49921 .41851 L p F P
0 g
s
.527 .481 .748 r
.44833 .40466 m .46623 .33722 L .43556 .31759 L p F P
0 g
s
.815 .34 .077 r
.5214 .17458 m .58152 .20066 L .57063 .18694 L closepath p F P
0 g
s
.769 .695 .781 r
.60474 .40221 m .58342 .33535 L .54518 .34676 L p F P
0 g
s
.769 .695 .781 r
.54518 .34676 m .55372 .41766 L .60474 .40221 L p F P
0 g
s
.234 0 .339 r
.5214 .17458 m .46509 .20263 L .46107 .21862 L closepath p F P
0 g
s
.901 .545 .358 r
.5214 .17458 m .58545 .21653 L .58152 .20066 L closepath p F P
0 g
s
.698 .644 .792 r
.50437 .34741 m .49921 .41851 L .55372 .41766 L p F P
0 g
s
.62 .576 .783 r
.49921 .41851 m .50437 .34741 L .46623 .33722 L p F P
0 g
s
.698 .644 .792 r
.55372 .41766 m .54518 .34676 L .50437 .34741 L p F P
0 g
s
.555 .475 .719 r
.47516 .24864 m .43556 .31759 L .46623 .33722 L p F P
0 g
s
.46 .359 .653 r
.43556 .31759 m .47516 .24864 L .46453 .2346 L p F P
0 g
s
.821 .688 .717 r
.61426 .3147 m .57115 .24705 L .55452 .25794 L p F P
0 g
s
.821 .688 .717 r
.55452 .25794 m .58342 .33535 L .61426 .3147 L p F P
0 g
s
.373 .213 .532 r
.5214 .17458 m .46107 .21862 L .46453 .2346 L closepath p F P
0 g
s
.9 .641 .538 r
.5214 .17458 m .58188 .23265 L .58545 .21653 L closepath p F P
0 g
s
.633 .558 .752 r
.4917 .25898 m .46623 .33722 L .50437 .34741 L p F P
0 g
s
.555 .475 .719 r
.46623 .33722 m .4917 .25898 L .47516 .24864 L p F P
0 g
s
.763 .661 .75 r
.58342 .33535 m .55452 .25794 L .53401 .26395 L p F P
0 g
s
.763 .661 .75 r
.53401 .26395 m .54518 .34676 L .58342 .33535 L p F P
0 g
s
.481 .365 .644 r
.5214 .17458 m .46453 .2346 L .47516 .24864 L closepath p F P
0 g
s
.863 .673 .644 r
.5214 .17458 m .57115 .24705 L .58188 .23265 L closepath p F P
0 g
s
.701 .618 .761 r
.51217 .26431 m .50437 .34741 L .54518 .34676 L p F P
0 g
s
.633 .558 .752 r
.50437 .34741 m .51217 .26431 L .4917 .25898 L p F P
0 g
s
.701 .618 .761 r
.54518 .34676 m .53401 .26395 L .51217 .26431 L p F P
0 g
s
.567 .472 .706 r
.5214 .17458 m .47516 .24864 L .4917 .25898 L closepath p F P
0 g
s
.814 .671 .705 r
.5214 .17458 m .55452 .25794 L .57115 .24705 L closepath p F P
0 g
s
.638 .549 .737 r
.5214 .17458 m .4917 .25898 L .51217 .26431 L closepath p F P
0 g
s
.76 .647 .736 r
.5214 .17458 m .53401 .26395 L .55452 .25794 L closepath p F P
0 g
s
.702 .606 .746 r
.5214 .17458 m .51217 .26431 L .53401 .26395 L closepath p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.227891 0.257081 0.363946 0.603319 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.55601e-17 1.04994 -0.0593075 1.04994 [
[ 0 0 0 0 ]
[ 1 .82899 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .82899 L
0 .82899 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.93 .713 .588 r
.3776 .65705 m .40725 .6997 L .37434 .67003 L closepath p F P
0 g
s
.887 .725 .675 r
.38578 .64656 m .40725 .6997 L .3776 .65705 L closepath p F P
0 g
s
.838 .708 .721 r
.39784 .63977 m .40725 .6997 L .38578 .64656 L closepath p F P
0 g
s
.789 .676 .74 r
.41232 .63745 m .40725 .6997 L .39784 .63977 L closepath p F P
0 g
s
.743 .635 .741 r
.42751 .63983 m .40725 .6997 L .41232 .63745 L closepath p F P
0 g
s
.7 .588 .727 r
.44163 .64662 m .40725 .6997 L .42751 .63983 L closepath p F P
0 g
s
.659 .534 .701 r
.45304 .65702 m .40725 .6997 L .44163 .64662 L closepath p F P
0 g
s
.621 .473 .659 r
.46039 .66983 m .40725 .6997 L .45304 .65702 L closepath p F P
0 g
s
.585 .402 .6 r
.46279 .68356 m .40725 .6997 L .46039 .66983 L closepath p F P
0 g
s
.551 .319 .516 r
.45989 .69658 m .40725 .6997 L .46279 .68356 L closepath p F P
0 g
s
.523 .223 .399 r
.45199 .70732 m .40725 .6997 L .45989 .69658 L closepath p F P
0 g
s
.506 .121 .244 r
.43999 .71444 m .40725 .6997 L .45199 .70732 L closepath p F P
0 g
s
.515 .041 .068 r
.42533 .71702 m .40725 .6997 L .43999 .71444 L closepath p F P
0 g
s
.565 .031 0 r
.40979 .7147 m .40725 .6997 L .42533 .71702 L closepath p F P
0 g
s
.669 .129 0 r
.39533 .70776 m .40725 .6997 L .40979 .7147 L closepath p F P
0 g
s
.802 .315 .034 r
.38374 .69705 m .40725 .6997 L .39533 .70776 L closepath p F P
0 g
s
.908 .512 .243 r
.37646 .68393 m .40725 .6997 L .38374 .69705 L closepath p F P
0 g
s
.946 .65 .444 r
.37434 .67003 m .40725 .6997 L .37646 .68393 L closepath p F P
0 g
s
.694 .592 .738 r
.47353 .59675 m .44163 .64662 L .42751 .63983 L p F P
0 g
s
.65 .534 .709 r
.44163 .64662 m .47353 .59675 L .49517 .61628 L p F P
0 g
s
.65 .534 .709 r
.49517 .61628 m .45304 .65702 L .44163 .64662 L p F P
0 g
s
.74 .643 .752 r
.44688 .58393 m .42751 .63983 L .41232 .63745 L p F P
0 g
s
.694 .592 .738 r
.42751 .63983 m .44688 .58393 L .47353 .59675 L p F P
0 g
s
.608 .468 .665 r
.45304 .65702 m .49517 .61628 L .50931 .64035 L p F P
0 g
s
.608 .468 .665 r
.50931 .64035 m .46039 .66983 L .45304 .65702 L p F P
0 g
s
.79 .688 .752 r
.41822 .57927 m .41232 .63745 L .39784 .63977 L p F P
0 g
s
.74 .643 .752 r
.41232 .63745 m .41822 .57927 L .44688 .58393 L p F P
0 g
s
.567 .39 .601 r
.46039 .66983 m .50931 .64035 L .51419 .66624 L p F P
0 g
s
.567 .39 .601 r
.51419 .66624 m .46279 .68356 L .46039 .66983 L p F P
0 g
s
.843 .724 .733 r
.39081 .58337 m .39784 .63977 L .38578 .64656 L p F P
0 g
s
.79 .688 .752 r
.39784 .63977 m .39081 .58337 L .41822 .57927 L p F P
0 g
s
.68 .601 .761 r
.50071 .55301 m .47353 .59675 L .44688 .58393 L p F P
0 g
s
.629 .535 .729 r
.47353 .59675 m .50071 .55301 L .5302 .57938 L p F P
0 g
s
.629 .535 .729 r
.5302 .57938 m .49517 .61628 L .47353 .59675 L p F P
0 g
s
.733 .661 .779 r
.46455 .5356 m .44688 .58393 L .41822 .57927 L p F P
0 g
s
.68 .601 .761 r
.44688 .58393 m .46455 .5356 L .50071 .55301 L p F P
0 g
s
.577 .456 .678 r
.49517 .61628 m .5302 .57938 L .54967 .61189 L p F P
0 g
s
.577 .456 .678 r
.54967 .61189 m .50931 .64035 L .49517 .61628 L p F P
0 g
s
.525 .295 .508 r
.46279 .68356 m .51419 .66624 L .50908 .69095 L p F P
0 g
s
.525 .295 .508 r
.50908 .69095 m .45989 .69658 L .46279 .68356 L p F P
0 g
s
.79 .715 .781 r
.42568 .52908 m .41822 .57927 L .39081 .58337 L p F P
0 g
s
.733 .661 .779 r
.41822 .57927 m .42568 .52908 L .46455 .5356 L p F P
0 g
s
.898 .745 .683 r
.36782 .59588 m .38578 .64656 L .3776 .65705 L p F P
0 g
s
.843 .724 .733 r
.38578 .64656 m .36782 .59588 L .39081 .58337 L p F P
0 g
s
.486 .18 .372 r
.45989 .69658 m .50908 .69095 L .49434 .71147 L p F P
0 g
s
.486 .18 .372 r
.49434 .71147 m .45199 .70732 L .45989 .69658 L p F P
0 g
s
.649 .617 .804 r
.52155 .51744 m .50071 .55301 L .46455 .5356 L p F P
0 g
s
.583 .532 .763 r
.50071 .55301 m .52155 .51744 L .55555 .54764 L p F P
0 g
s
.583 .532 .763 r
.55555 .54764 m .5302 .57938 L .50071 .55301 L p F P
0 g
s
.522 .36 .602 r
.50931 .64035 m .54967 .61189 L .55671 .64694 L p F P
0 g
s
.522 .36 .602 r
.55671 .64694 m .51419 .66624 L .50931 .64035 L p F P
0 g
s
.715 .692 .827 r
.47997 .49742 m .46455 .5356 L .42568 .52908 L p F P
0 g
s
.649 .617 .804 r
.46455 .5356 m .47997 .49742 L .52155 .51744 L p F P
0 g
s
.946 .735 .585 r
.35207 .61551 m .3776 .65705 L .37434 .67003 L p F P
0 g
s
.898 .745 .683 r
.3776 .65705 m .35207 .61551 L .36782 .59588 L p F P
0 g
s
.853 .762 .761 r
.38842 .5343 m .39081 .58337 L .36782 .59588 L p F P
0 g
s
.79 .715 .781 r
.39081 .58337 m .38842 .5343 L .42568 .52908 L p F P
0 g
s
.511 .43 .701 r
.5302 .57938 m .55555 .54764 L .57816 .58482 L p F P
0 g
s
.511 .43 .701 r
.57816 .58482 m .54967 .61189 L .5302 .57938 L p F P
0 g
s
.453 .05 .183 r
.45199 .70732 m .49434 .71147 L .47159 .72518 L p F P
0 g
s
.453 .05 .183 r
.47159 .72518 m .43999 .71444 L .45199 .70732 L p F P
0 g
s
.785 .765 .834 r
.43533 .48975 m .42568 .52908 L .38842 .5343 L p F P
0 g
s
.715 .692 .827 r
.42568 .52908 m .43533 .48975 L .47997 .49742 L p F P
0 g
s
.946 .735 .585 r
.37434 .67003 m .34563 .64004 L .35207 .61551 L p F P
0 g
s
.962 .661 .413 r
.34563 .64004 m .37434 .67003 L .37646 .68393 L p F P
0 g
s
.458 .234 .485 r
.51419 .66624 m .55671 .64694 L .55016 .68053 L p F P
0 g
s
.458 .234 .485 r
.55016 .68053 m .50908 .69095 L .51419 .66624 L p F P
0 g
s
.442 0 0 r
.43999 .71444 m .47159 .72518 L .44351 .7302 L p F P
0 g
s
.442 0 0 r
.44351 .7302 m .42533 .71702 L .43999 .71444 L p F P
0 g
s
.921 .794 .703 r
.35704 .55091 m .36782 .59588 L .35207 .61551 L p F P
0 g
s
.853 .762 .761 r
.36782 .59588 m .35704 .55091 L .38842 .5343 L p F P
0 g
s
.903 .49 .16 r
.34949 .66655 m .37646 .68393 L .38374 .69705 L p F P
0 g
s
.962 .661 .413 r
.37646 .68393 m .34949 .66655 L .34563 .64004 L p F P
0 g
s
.42 .293 .6 r
.54967 .61189 m .57816 .58482 L .58658 .62495 L p F P
0 g
s
.42 .293 .6 r
.58658 .62495 m .55671 .64694 L .54967 .61189 L p F P
0 g
s
.48 0 0 r
.42533 .71702 m .44351 .7302 L .4136 .72578 L p F P
0 g
s
.48 0 0 r
.4136 .72578 m .40979 .7147 L .42533 .71702 L p F P
0 g
s
.757 .242 0 r
.36339 .69174 m .38374 .69705 L .39533 .70776 L p F P
0 g
s
.903 .49 .16 r
.38374 .69705 m .36339 .69174 L .34949 .66655 L p F P
0 g
s
.578 .635 .872 r
.53512 .49115 m .52155 .51744 L .47997 .49742 L p F P
0 g
s
.483 .518 .817 r
.52155 .51744 m .53512 .49115 L .5697 .52171 L p F P
0 g
s
.483 .518 .817 r
.5697 .52171 m .55555 .54764 L .52155 .51744 L p F P
0 g
s
.866 .835 .814 r
.3925 .49544 m .38842 .5343 L .35704 .55091 L p F P
0 g
s
.785 .765 .834 r
.38842 .5343 m .3925 .49544 L .43533 .48975 L p F P
0 g
s
.664 .74 .907 r
.49291 .47081 m .47997 .49742 L .43533 .48975 L p F P
0 g
s
.578 .635 .872 r
.47997 .49742 m .49291 .47081 L .53512 .49115 L p F P
0 g
s
.591 .017 0 r
.40979 .7147 m .4136 .72578 L .38569 .71238 L p F P
0 g
s
.591 .017 0 r
.38569 .71238 m .39533 .70776 L .40979 .7147 L p F P
0 g
s
.757 .242 0 r
.39533 .70776 m .38569 .71238 L .36339 .69174 L p F P
0 g
s
.381 .063 .296 r
.50908 .69095 m .55016 .68053 L .5304 .70857 L p F P
0 g
s
.381 .063 .296 r
.5304 .70857 m .49434 .71147 L .50908 .69095 L p F P
0 g
s
.359 .365 .73 r
.55555 .54764 m .5697 .52171 L .59278 .55927 L p F P
0 g
s
.359 .365 .73 r
.59278 .55927 m .57816 .58482 L .55555 .54764 L p F P
0 g
s
.751 .846 .922 r
.44763 .4629 m .43533 .48975 L .3925 .49544 L p F P
0 g
s
.664 .74 .907 r
.43533 .48975 m .44763 .4629 L .49291 .47081 L p F P
0 g
s
.98 .786 .571 r
.33537 .57728 m .35207 .61551 L .34563 .64004 L p F P
0 g
s
.921 .794 .703 r
.35207 .61551 m .33537 .57728 L .35704 .55091 L p F P
0 g
s
.29 .086 .421 r
.55671 .64694 m .58658 .62495 L .57939 .66348 L p F P
0 g
s
.29 .086 .421 r
.57939 .66348 m .55016 .68053 L .55671 .64694 L p F P
0 g
s
.952 .89 .733 r
.35635 .51417 m .35704 .55091 L .33537 .57728 L p F P
0 g
s
.866 .835 .814 r
.35704 .55091 m .35635 .51417 L .3925 .49544 L p F P
0 g
s
.164 .125 .564 r
.57816 .58482 m .59278 .55927 L .60149 .59976 L p F P
0 g
s
.164 .125 .564 r
.60149 .59976 m .58658 .62495 L .57816 .58482 L p F P
0 g
s
.286 0 0 r
.49434 .71147 m .5304 .70857 L .49945 .7274 L p F P
0 g
s
.286 0 0 r
.49945 .7274 m .47159 .72518 L .49434 .71147 L p F P
0 g
s
.98 .786 .571 r
.34563 .64004 m .32634 .61053 L .33537 .57728 L p F P
0 g
s
.975 .672 .307 r
.32634 .61053 m .34563 .64004 L .34949 .66655 L p F P
0 g
s
.839 .954 .889 r
.40423 .46846 m .3925 .49544 L .35635 .51417 L p F P
0 g
s
.751 .846 .922 r
.3925 .49544 m .40423 .46846 L .44763 .4629 L p F P
0 g
s
.398 .629 .947 r
.54127 .47422 m .53512 .49115 L .49291 .47081 L p F P
0 g
s
.242 .449 .862 r
.53512 .49115 m .54127 .47422 L .5723 .50157 L p F P
0 g
s
.242 .449 .862 r
.5723 .50157 m .5697 .52171 L .53512 .49115 L p F P
0 g
s
.506 .776 .993 r
.5034 .45597 m .49291 .47081 L .44763 .4629 L p F P
0 g
s
.398 .629 .947 r
.49291 .47081 m .5034 .45597 L .54127 .47422 L p F P
0 g
s
.194 0 0 r
.47159 .72518 m .49945 .7274 L .46095 .73434 L p F P
0 g
s
.194 0 0 r
.46095 .73434 m .44351 .7302 L .47159 .72518 L p F P
0 g
s
.077 0 .075 r
.55016 .68053 m .57939 .66348 L .5569 .6957 L p F P
0 g
s
.077 0 .075 r
.5569 .6957 m .5304 .70857 L .55016 .68053 L p F P
0 g
s
0 .18 .698 r
.5697 .52171 m .5723 .50157 L .593 .53507 L p F P
0 g
s
0 .18 .698 r
.593 .53507 m .59278 .55927 L .5697 .52171 L p F P
0 g
s
.813 .382 0 r
.33147 .64673 m .34949 .66655 L .36339 .69174 L p F P
0 g
s
.975 .672 .307 r
.34949 .66655 m .33147 .64673 L .32634 .61053 L p F P
0 g
s
.571 .902 .981 r
.46285 .44882 m .44763 .4629 L .40423 .46846 L p F P
0 g
s
.506 .776 .993 r
.44763 .4629 m .46285 .44882 L .5034 .45597 L p F P
0 g
s
.987 .857 .489 r
.33131 .54417 m .33537 .57728 L .32634 .61053 L p F P
0 g
s
.952 .89 .733 r
.33537 .57728 m .33131 .54417 L .35635 .51417 L p F P
0 g
s
0 0 .193 r
.58658 .62495 m .60149 .59976 L .59438 .63858 L p F P
0 g
s
0 0 .193 r
.59438 .63858 m .57939 .66348 L .58658 .62495 L p F P
0 g
s
.854 .978 .678 r
.36764 .48719 m .35635 .51417 L .33131 .54417 L p F P
0 g
s
.839 .954 .889 r
.35635 .51417 m .36764 .48719 L .40423 .46846 L p F P
0 g
s
.175 0 0 r
.44351 .7302 m .46095 .73434 L .41975 .72825 L p F P
0 g
s
.175 0 0 r
.41975 .72825 m .4136 .72578 L .44351 .7302 L p F P
0 g
s
.526 .005 0 r
.35051 .68132 m .36339 .69174 L .38569 .71238 L p F P
0 g
s
.813 .382 0 r
.36339 .69174 m .35051 .68132 L .33147 .64673 L p F P
0 g
s
0 0 .325 r
.59278 .55927 m .593 .53507 L .6008 .57107 L p F P
0 g
s
0 0 .325 r
.6008 .57107 m .60149 .59976 L .59278 .55927 L p F P
0 g
s
.526 .005 0 r
.38569 .71238 m .38124 .70977 L .35051 .68132 L p F P
0 g
s
0 .286 .657 r
.4136 .72578 m .41975 .72825 L .38124 .70977 L p F P
0 g
s
0 .286 .657 r
.38124 .70977 m .38569 .71238 L .4136 .72578 L p F P
0 g
s
.51 .904 .768 r
.42409 .4537 m .40423 .46846 L .36764 .48719 L p F P
0 g
s
.571 .902 .981 r
.40423 .46846 m .42409 .4537 L .46285 .44882 L p F P
0 g
s
0 0 0 r
.5304 .70857 m .5569 .6957 L .52134 .71737 L p F P
0 g
s
0 0 0 r
.52134 .71737 m .49945 .7274 L .5304 .70857 L p F P
0 g
s
.987 .857 .489 r
.32634 .61053 m .32081 .58223 L .33131 .54417 L p F P
0 g
s
.76 .531 0 r
.32081 .58223 m .32634 .61053 L .33147 .64673 L p F P
0 g
s
.669 .863 .471 r
.57939 .66348 m .59438 .63858 L .57171 .671 L p F P
0 g
s
.669 .863 .471 r
.57171 .671 m .5569 .6957 L .57939 .66348 L p F P
0 g
s
.017 .487 .875 r
.54059 .46575 m .54127 .47422 L .5034 .45597 L p F P
0 g
s
0 .229 .73 r
.54127 .47422 m .54059 .46575 L .56417 .4865 L p F P
0 g
s
0 .229 .73 r
.56417 .4865 m .5723 .50157 L .54127 .47422 L p F P
0 g
s
.122 .641 .887 r
.5118 .45187 m .5034 .45597 L .46285 .44882 L p F P
0 g
s
.017 .487 .875 r
.5034 .45597 m .5118 .45187 L .54059 .46575 L p F P
0 g
s
.854 .978 .678 r
.33131 .54417 m .34235 .51732 L .36764 .48719 L p F P
0 g
s
0 0 0 r
.34235 .51732 m .33131 .54417 L .32081 .58223 L p F P
0 g
s
.891 .788 .299 r
.60149 .59976 m .6008 .57107 L .59443 .60545 L p F P
0 g
s
.891 .788 .299 r
.59443 .60545 m .59438 .63858 L .60149 .59976 L p F P
0 g
s
0 0 .407 r
.5723 .50157 m .56417 .4865 L .57982 .51184 L p F P
0 g
s
0 0 .407 r
.57982 .51184 m .593 .53507 L .5723 .50157 L p F P
0 g
s
.51 .904 .768 r
.36764 .48719 m .39155 .47031 L .42409 .4537 L p F P
0 g
s
0 0 0 r
.39155 .47031 m .36764 .48719 L .34235 .51732 L p F P
0 g
s
.093 .649 .706 r
.48102 .44643 m .46285 .44882 L .42409 .4537 L p F P
0 g
s
.122 .641 .887 r
.46285 .44882 m .48102 .44643 L .5118 .45187 L p F P
0 g
s
.406 .855 .899 r
.49945 .7274 m .52134 .71737 L .47686 .72534 L p F P
0 g
s
.406 .855 .899 r
.47686 .72534 m .46095 .73434 L .49945 .7274 L p F P
0 g
s
.76 .531 0 r
.33147 .64673 m .3267 .62386 L .32081 .58223 L p F P
0 g
s
0 0 .571 r
.3267 .62386 m .33147 .64673 L .35051 .68132 L p F P
0 g
s
.899 .584 .09 r
.593 .53507 m .57982 .51184 L .58563 .53891 L p F P
0 g
s
.899 .584 .09 r
.58563 .53891 m .6008 .57107 L .593 .53507 L p F P
0 g
s
.093 .649 .706 r
.42409 .4537 m .45173 .45011 L .48102 .44643 L p F P
0 g
s
.075 0 0 r
.45173 .45011 m .42409 .4537 L .39155 .47031 L p F P
0 g
s
.385 .766 .991 r
.46095 .73434 m .47686 .72534 L .42911 .71822 L p F P
0 g
s
.385 .766 .991 r
.42911 .71822 m .41975 .72825 L .46095 .73434 L p F P
0 g
s
.809 .993 .87 r
.5569 .6957 m .57171 .671 L .53574 .69274 L p F P
0 g
s
.809 .993 .87 r
.53574 .69274 m .52134 .71737 L .5569 .6957 L p F P
0 g
s
.06 .362 .832 r
.34874 .66382 m .35051 .68132 L .38124 .70977 L p F P
0 g
s
0 0 .571 r
.35051 .68132 m .34874 .66382 L .3267 .62386 L p F P
0 g
s
0 0 0 r
.32081 .58223 m .33182 .55565 L .34235 .51732 L p F P
0 g
s
0 0 .475 r
.33182 .55565 m .32081 .58223 L .3267 .62386 L p F P
0 g
s
.967 .93 .696 r
.59438 .63858 m .59443 .60545 L .5742 .63401 L p F P
0 g
s
.967 .93 .696 r
.5742 .63401 m .57171 .671 L .59438 .63858 L p F P
0 g
s
.266 .596 .95 r
.41975 .72825 m .42911 .71822 L .38441 .69676 L p F P
0 g
s
.266 .596 .95 r
.38441 .69676 m .38124 .70977 L .41975 .72825 L p F P
0 g
s
.06 .362 .832 r
.38124 .70977 m .38441 .69676 L .34874 .66382 L p F P
0 g
s
.156 0 .317 r
.36921 .49704 m .34235 .51732 L .33182 .55565 L p F P
0 g
s
0 0 0 r
.34235 .51732 m .36921 .49704 L .39155 .47031 L p F P
0 g
s
.999 .798 .491 r
.6008 .57107 m .58563 .53891 L .58069 .56458 L p F P
0 g
s
.999 .798 .491 r
.58069 .56458 m .59443 .60545 L .6008 .57107 L p F P
0 g
s
.262 0 .156 r
.42732 .46265 m .39155 .47031 L .36921 .49704 L p F P
0 g
s
.075 0 0 r
.39155 .47031 m .42732 .46265 L .45173 .45011 L p F P
0 g
s
.739 .888 .947 r
.52134 .71737 m .53574 .69274 L .49066 .70063 L p F P
0 g
s
.739 .888 .947 r
.49066 .70063 m .47686 .72534 L .52134 .71737 L p F P
0 g
s
.342 0 0 r
.53446 .46384 m .54059 .46575 L .5118 .45187 L p F P
0 g
s
.555 .02 0 r
.54059 .46575 m .53446 .46384 L .54733 .47518 L p F P
0 g
s
.555 .02 0 r
.54733 .47518 m .56417 .4865 L .54059 .46575 L p F P
0 g
s
.241 0 0 r
.51871 .45625 m .5118 .45187 L .48102 .44643 L p F P
0 g
s
.342 0 0 r
.5118 .45187 m .51871 .45625 L .53446 .46384 L p F P
0 g
s
.264 .303 .715 r
.33793 .59767 m .3267 .62386 L .34874 .66382 L p F P
0 g
s
0 0 .475 r
.3267 .62386 m .33793 .59767 L .33182 .55565 L p F P
0 g
s
.808 .357 0 r
.56417 .4865 m .54733 .47518 L .55581 .48896 L p F P
0 g
s
.808 .357 0 r
.55581 .48896 m .57982 .51184 L .56417 .4865 L p F P
0 g
s
.253 0 0 r
.5019 .45328 m .48102 .44643 L .45173 .45011 L p F P
0 g
s
.241 0 0 r
.48102 .44643 m .5019 .45328 L .51871 .45625 L p F P
0 g
s
.884 .876 .823 r
.57171 .671 m .5742 .63401 L .54216 .653 L p F P
0 g
s
.884 .876 .823 r
.54216 .653 m .53574 .69274 L .57171 .671 L p F P
0 g
s
.156 0 .317 r
.33182 .55565 m .36012 .53102 L .36921 .49704 L p F P
0 g
s
.352 .228 .568 r
.36012 .53102 m .33182 .55565 L .33793 .59767 L p F P
0 g
s
.95 .827 .686 r
.59443 .60545 m .58069 .56458 L .56535 .58571 L p F P
0 g
s
.95 .827 .686 r
.56535 .58571 m .5742 .63401 L .59443 .60545 L p F P
0 g
s
.645 .763 .935 r
.47686 .72534 m .49066 .70063 L .44218 .69327 L p F P
0 g
s
.645 .763 .935 r
.44218 .69327 m .42911 .71822 L .47686 .72534 L p F P
0 g
s
.962 .629 .271 r
.57982 .51184 m .55581 .48896 L .55887 .50357 L p F P
0 g
s
.962 .629 .271 r
.55887 .50357 m .58563 .53891 L .57982 .51184 L p F P
0 g
s
.429 .498 .829 r
.36043 .63807 m .34874 .66382 L .38441 .69676 L p F P
0 g
s
.264 .303 .715 r
.34874 .66382 m .36043 .63807 L .33793 .59767 L p F P
0 g
s
.394 .152 .426 r
.41078 .48276 m .36921 .49704 L .36012 .53102 L p F P
0 g
s
.262 0 .156 r
.36921 .49704 m .41078 .48276 L .42732 .46265 L p F P
0 g
s
.329 0 0 r
.48601 .45531 m .45173 .45011 L .42732 .46265 L p F P
0 g
s
.253 0 0 r
.45173 .45011 m .48601 .45531 L .5019 .45328 L p F P
0 g
s
.546 .639 .894 r
.42911 .71822 m .44218 .69327 L .39674 .67145 L p F P
0 g
s
.546 .639 .894 r
.39674 .67145 m .38441 .69676 L .42911 .71822 L p F P
0 g
s
.429 .498 .829 r
.38441 .69676 m .39674 .67145 L .36043 .63807 L p F P
0 g
s
.794 .793 .851 r
.53574 .69274 m .54216 .653 L .50206 .65972 L p F P
0 g
s
.794 .793 .851 r
.50206 .65972 m .49066 .70063 L .53574 .69274 L p F P
0 g
s
.977 .751 .53 r
.58563 .53891 m .55887 .50357 L .55608 .5173 L p F P
0 g
s
.977 .751 .53 r
.55608 .5173 m .58069 .56458 L .58563 .53891 L p F P
0 g
s
.412 .069 .271 r
.47289 .46214 m .42732 .46265 L .41078 .48276 L p F P
0 g
s
.329 0 0 r
.42732 .46265 m .47289 .46214 L .48601 .45531 L p F P
0 g
s
.473 .402 .696 r
.36585 .56822 m .33793 .59767 L .36043 .63807 L p F P
0 g
s
.352 .228 .568 r
.33793 .59767 m .36585 .56822 L .36012 .53102 L p F P
0 g
s
.873 .79 .765 r
.5742 .63401 m .56535 .58571 L .54123 .5996 L p F P
0 g
s
.873 .79 .765 r
.54123 .5996 m .54216 .653 L .5742 .63401 L p F P
0 g
s
.394 .152 .426 r
.36012 .53102 m .4043 .50819 L .41078 .48276 L p F P
0 g
s
.485 .318 .58 r
.4043 .50819 m .36012 .53102 L .36585 .56822 L p F P
0 g
s
.926 .771 .669 r
.58069 .56458 m .55608 .5173 L .54769 .52847 L p F P
0 g
s
.926 .771 .669 r
.54769 .52847 m .56535 .58571 L .58069 .56458 L p F P
0 g
s
.714 .708 .843 r
.49066 .70063 m .50206 .65972 L .45895 .653 L p F P
0 g
s
.714 .708 .843 r
.45895 .653 m .44218 .69327 L .49066 .70063 L p F P
0 g
s
.562 .524 .77 r
.3861 .60398 m .36043 .63807 L .39674 .67145 L p F P
0 g
s
.473 .402 .696 r
.36043 .63807 m .3861 .60398 L .36585 .56822 L p F P
0 g
s
.481 .233 .46 r
.46416 .47301 m .41078 .48276 L .4043 .50819 L p F P
0 g
s
.412 .069 .271 r
.41078 .48276 m .46416 .47301 L .47289 .46214 L p F P
0 g
s
.484 0 0 r
.52497 .46566 m .53446 .46384 L .51871 .45625 L closepath p F P
0 g
s
.667 .129 0 r
.52497 .46566 m .54733 .47518 L .53446 .46384 L closepath p F P
0 g
s
.383 0 0 r
.52497 .46566 m .51871 .45625 L .5019 .45328 L closepath p F P
0 g
s
.639 .621 .816 r
.44218 .69327 m .45895 .653 L .41852 .63356 L p F P
0 g
s
.639 .621 .816 r
.41852 .63356 m .39674 .67145 L .44218 .69327 L p F P
0 g
s
.801 .734 .79 r
.54216 .653 m .54123 .5996 L .51118 .60432 L p F P
0 g
s
.801 .734 .79 r
.51118 .60432 m .50206 .65972 L .54216 .653 L p F P
0 g
s
.562 .524 .77 r
.39674 .67145 m .41852 .63356 L .3861 .60398 L p F P
0 g
s
.859 .413 .021 r
.52497 .46566 m .55581 .48896 L .54733 .47518 L closepath p F P
0 g
s
.37 0 0 r
.52497 .46566 m .5019 .45328 L .48601 .45531 L closepath p F P
0 g
s
.556 .437 .672 r
.40893 .53594 m .36585 .56822 L .3861 .60398 L p F P
0 g
s
.485 .318 .58 r
.36585 .56822 m .40893 .53594 L .4043 .50819 L p F P
0 g
s
.961 .629 .325 r
.52497 .46566 m .55887 .50357 L .55581 .48896 L closepath p F P
0 g
s
.862 .746 .733 r
.56535 .58571 m .54769 .52847 L .53467 .53569 L p F P
0 g
s
.862 .746 .733 r
.53467 .53569 m .54123 .5996 L .56535 .58571 L p F P
0 g
s
.409 0 .078 r
.52497 .46566 m .48601 .45531 L .47289 .46214 L closepath p F P
0 g
s
.481 .233 .46 r
.4043 .50819 m .46091 .48667 L .46416 .47301 L p F P
0 g
s
.54 .356 .58 r
.46091 .48667 m .4043 .50819 L .40893 .53594 L p F P
0 g
s
.962 .728 .539 r
.52497 .46566 m .55608 .5173 L .55887 .50357 L closepath p F P
0 g
s
.736 .672 .788 r
.50206 .65972 m .51118 .60432 L .47896 .59911 L p F P
0 g
s
.736 .672 .788 r
.47896 .59911 m .45895 .653 L .50206 .65972 L p F P
0 g
s
.461 .125 .31 r
.52497 .46566 m .47289 .46214 L .46416 .47301 L closepath p F P
0 g
s
.617 .528 .731 r
.42434 .56254 m .3861 .60398 L .41852 .63356 L p F P
0 g
s
.556 .437 .672 r
.3861 .60398 m .42434 .56254 L .40893 .53594 L p F P
0 g
s
.801 .703 .758 r
.54123 .5996 m .53467 .53569 L .51855 .53802 L p F P
0 g
s
.801 .703 .758 r
.51855 .53802 m .51118 .60432 L .54123 .5996 L p F P
0 g
s
.915 .747 .66 r
.52497 .46566 m .54769 .52847 L .55608 .5173 L closepath p F P
0 g
s
.676 .604 .768 r
.45895 .653 m .47896 .59911 L .4487 .58456 L p F P
0 g
s
.676 .604 .768 r
.4487 .58456 m .41852 .63356 L .45895 .653 L p F P
0 g
s
.592 .451 .658 r
.46363 .50148 m .40893 .53594 L .42434 .56254 L p F P
0 g
s
.54 .356 .58 r
.40893 .53594 m .46363 .50148 L .46091 .48667 L p F P
0 g
s
.617 .528 .731 r
.41852 .63356 m .4487 .58456 L .42434 .56254 L p F P
0 g
s
.513 .262 .471 r
.52497 .46566 m .46416 .47301 L .46091 .48667 L closepath p F P
0 g
s
.857 .728 .72 r
.52497 .46566 m .53467 .53569 L .54769 .52847 L closepath p F P
0 g
s
.744 .652 .758 r
.51118 .60432 m .51855 .53802 L .50133 .53512 L p F P
0 g
s
.744 .652 .758 r
.50133 .53512 m .47896 .59911 L .51118 .60432 L p F P
0 g
s
.561 .37 .579 r
.52497 .46566 m .46091 .48667 L .46363 .50148 L closepath p F P
0 g
s
.642 .528 .709 r
.47204 .51563 m .42434 .56254 L .4487 .58456 L p F P
0 g
s
.592 .451 .658 r
.42434 .56254 m .47204 .51563 L .46363 .50148 L p F P
0 g
s
.692 .594 .742 r
.47896 .59911 m .50133 .53512 L .48515 .52733 L p F P
0 g
s
.692 .594 .742 r
.48515 .52733 m .4487 .58456 L .47896 .59911 L p F P
0 g
s
.642 .528 .709 r
.4487 .58456 m .48515 .52733 L .47204 .51563 L p F P
0 g
s
.8 .69 .744 r
.52497 .46566 m .51855 .53802 L .53467 .53569 L closepath p F P
0 g
s
.607 .456 .651 r
.52497 .46566 m .46363 .50148 L .47204 .51563 L closepath p F P
0 g
s
.747 .643 .745 r
.52497 .46566 m .50133 .53512 L .51855 .53802 L closepath p F P
0 g
s
.652 .528 .699 r
.52497 .46566 m .47204 .51563 L .48515 .52733 L closepath p F P
0 g
s
.699 .589 .73 r
.52497 .46566 m .48515 .52733 L .50133 .53512 L closepath p F P
0 g
s
.513 .262 .471 r
.58786 .45806 m .52497 .46566 L .5906 .44414 L closepath p F P
0 g
s
.461 .125 .31 r
.57934 .46934 m .52497 .46566 L .58786 .45806 L closepath p F P
0 g
s
.409 0 .078 r
.56599 .47656 m .52497 .46566 L .57934 .46934 L closepath p F P
0 g
s
.37 0 0 r
.5494 .47878 m .52497 .46566 L .56599 .47656 L closepath p F P
0 g
s
.383 0 0 r
.53163 .47567 m .52497 .46566 L .5494 .47878 L closepath p F P
0 g
s
.484 0 0 r
.51488 .4676 m .52497 .46566 L .53163 .47567 L closepath p F P
0 g
s
.667 .129 0 r
.50127 .45557 m .52497 .46566 L .51488 .4676 L closepath p F P
0 g
s
.859 .413 .021 r
.49247 .44112 m .52497 .46566 L .50127 .45557 L closepath p F P
0 g
s
.961 .629 .325 r
.48954 .42604 m .52497 .46566 L .49247 .44112 L closepath p F P
0 g
s
.962 .728 .539 r
.49276 .4122 m .52497 .46566 L .48954 .42604 L closepath p F P
0 g
s
.915 .747 .66 r
.50166 .40124 m .52497 .46566 L .49276 .4122 L closepath p F P
0 g
s
.857 .728 .72 r
.51511 .39443 m .52497 .46566 L .50166 .40124 L closepath p F P
0 g
s
.8 .69 .744 r
.53146 .39253 m .52497 .46566 L .51511 .39443 L closepath p F P
0 g
s
.747 .643 .745 r
.54879 .3957 m .52497 .46566 L .53146 .39253 L closepath p F P
0 g
s
.699 .589 .73 r
.56507 .40356 m .52497 .46566 L .54879 .3957 L closepath p F P
0 g
s
.652 .528 .699 r
.57844 .41519 m .52497 .46566 L .56507 .40356 L closepath p F P
0 g
s
.607 .456 .651 r
.5873 .42926 m .52497 .46566 L .57844 .41519 L closepath p F P
0 g
s
.561 .37 .579 r
.5906 .44414 m .52497 .46566 L .5873 .42926 L closepath p F P
0 g
s
.692 .594 .742 r
.60257 .34469 m .56507 .40356 L .54879 .3957 L p F P
0 g
s
.642 .528 .709 r
.56507 .40356 m .60257 .34469 L .62796 .36652 L p F P
0 g
s
.642 .528 .709 r
.62796 .36652 m .57844 .41519 L .56507 .40356 L p F P
0 g
s
.744 .652 .758 r
.5718 .32983 m .54879 .3957 L .53146 .39253 L p F P
0 g
s
.692 .594 .742 r
.54879 .3957 m .5718 .32983 L .60257 .34469 L p F P
0 g
s
.593 .451 .658 r
.57844 .41519 m .62796 .36652 L .64506 .39293 L p F P
0 g
s
.593 .451 .658 r
.64506 .39293 m .5873 .42926 L .57844 .41519 L p F P
0 g
s
.8 .703 .758 r
.53909 .3236 m .53146 .39253 L .51511 .39443 L p F P
0 g
s
.744 .652 .758 r
.53146 .39253 m .53909 .3236 L .5718 .32983 L p F P
0 g
s
.541 .357 .581 r
.5873 .42926 m .64506 .39293 L .65179 .42097 L p F P
0 g
s
.541 .357 .581 r
.65179 .42097 m .5906 .44414 L .5873 .42926 L p F P
0 g
s
.861 .745 .733 r
.50811 .32681 m .51511 .39443 L .50166 .40124 L p F P
0 g
s
.8 .703 .758 r
.51511 .39443 m .50811 .32681 L .53909 .3236 L p F P
0 g
s
.677 .604 .767 r
.63508 .29199 m .60257 .34469 L .5718 .32983 L p F P
0 g
s
.619 .529 .731 r
.60257 .34469 m .63508 .29199 L .66974 .32147 L p F P
0 g
s
.619 .529 .731 r
.66974 .32147 m .62796 .36652 L .60257 .34469 L p F P
0 g
s
.735 .67 .787 r
.59329 .27178 m .5718 .32983 L .53909 .3236 L p F P
0 g
s
.677 .604 .767 r
.5718 .32983 m .59329 .27178 L .63508 .29199 L p F P
0 g
s
.56 .44 .673 r
.62796 .36652 m .66974 .32147 L .69337 .35712 L p F P
0 g
s
.56 .44 .673 r
.69337 .35712 m .64506 .39293 L .62796 .36652 L p F P
0 g
s
.483 .235 .462 r
.5906 .44414 m .65179 .42097 L .64711 .44738 L p F P
0 g
s
.483 .235 .462 r
.64711 .44738 m .58786 .45806 L .5906 .44414 L p F P
0 g
s
.799 .731 .789 r
.54889 .26306 m .53909 .3236 L .50811 .32681 L p F P
0 g
s
.735 .67 .787 r
.53909 .3236 m .54889 .26306 L .59329 .27178 L p F P
0 g
s
.925 .77 .669 r
.48244 .33923 m .50166 .40124 L .49276 .4122 L p F P
0 g
s
.861 .745 .733 r
.50166 .40124 m .48244 .33923 L .50811 .32681 L p F P
0 g
s
.414 .073 .275 r
.58786 .45806 m .64711 .44738 L .63128 .46894 L p F P
0 g
s
.414 .073 .275 r
.63128 .46894 m .57934 .46934 L .58786 .45806 L p F P
0 g
s
.644 .619 .81 r
.66093 .24746 m .63508 .29199 L .59329 .27178 L p F P
0 g
s
.573 .528 .767 r
.63508 .29199 m .66093 .24746 L .70099 .28123 L p F P
0 g
s
.573 .528 .767 r
.70099 .28123 m .66974 .32147 L .63508 .29199 L p F P
0 g
s
.492 .326 .584 r
.64506 .39293 m .69337 .35712 L .70309 .39505 L p F P
0 g
s
.492 .326 .584 r
.70309 .39505 m .65179 .42097 L .64506 .39293 L p F P
0 g
s
.714 .7 .835 r
.61281 .22417 m .59329 .27178 L .54889 .26306 L p F P
0 g
s
.644 .619 .81 r
.59329 .27178 m .61281 .22417 L .66093 .24746 L p F P
0 g
s
.976 .75 .533 r
.46523 .35962 m .49276 .4122 L .48954 .42604 L p F P
0 g
s
.925 .77 .669 r
.49276 .4122 m .46523 .35962 L .48244 .33923 L p F P
0 g
s
.87 .785 .764 r
.50673 .26693 m .50811 .32681 L .48244 .33923 L p F P
0 g
s
.799 .731 .789 r
.50811 .32681 m .50673 .26693 L .54889 .26306 L p F P
0 g
s
.493 .417 .699 r
.66974 .32147 m .70099 .28123 L .72854 .32199 L p F P
0 g
s
.493 .417 .699 r
.72854 .32199 m .69337 .35712 L .66974 .32147 L p F P
0 g
s
.334 0 0 r
.57934 .46934 m .63128 .46894 L .60598 .48286 L p F P
0 g
s
.334 0 0 r
.60598 .48286 m .56599 .47656 L .57934 .46934 L p F P
0 g
s
.79 .778 .843 r
.56174 .21387 m .54889 .26306 L .50673 .26693 L p F P
0 g
s
.714 .7 .835 r
.54889 .26306 m .56174 .21387 L .61281 .22417 L p F P
0 g
s
.963 .631 .276 r
.45879 .38574 m .48954 .42604 L .49247 .44112 L p F P
0 g
s
.976 .75 .533 r
.48954 .42604 m .45879 .38574 L .46523 .35962 L p F P
0 g
s
.406 .168 .437 r
.65179 .42097 m .70309 .39505 L .69731 .43094 L p F P
0 g
s
.406 .168 .437 r
.69731 .43094 m .64711 .44738 L .65179 .42097 L p F P
0 g
s
.26 0 0 r
.56599 .47656 m .60598 .48286 L .57416 .48719 L p F P
0 g
s
.26 0 0 r
.57416 .48719 m .5494 .47878 L .56599 .47656 L p F P
0 g
s
.945 .821 .69 r
.47163 .28325 m .48244 .33923 L .46523 .35962 L p F P
0 g
s
.87 .785 .764 r
.48244 .33923 m .47163 .28325 L .50673 .26693 L p F P
0 g
s
.813 .363 0 r
.4642 .4145 m .49247 .44112 L .50127 .45557 L p F P
0 g
s
.963 .631 .276 r
.49247 .44112 m .4642 .4145 L .45879 .38574 L p F P
0 g
s
.389 .263 .585 r
.69337 .35712 m .72854 .32199 L .7402 .36539 L p F P
0 g
s
.389 .263 .585 r
.7402 .36539 m .70309 .39505 L .69337 .35712 L p F P
0 g
s
.25 0 0 r
.5494 .47878 m .57416 .48719 L .5398 .4812 L p F P
0 g
s
.25 0 0 r
.5398 .4812 m .53163 .47567 L .5494 .47878 L p F P
0 g
s
.563 .028 0 r
.48105 .44231 m .50127 .45557 L .51488 .4676 L p F P
0 g
s
.813 .363 0 r
.50127 .45557 m .48105 .44231 L .4642 .4145 L p F P
0 g
s
.578 .635 .872 r
.6792 .21208 m .66093 .24746 L .61281 .22417 L p F P
0 g
s
.483 .518 .817 r
.66093 .24746 m .6792 .21208 L .72006 .2463 L p F P
0 g
s
.483 .518 .817 r
.72006 .2463 m .70099 .28123 L .66093 .24746 L p F P
0 g
s
.875 .855 .819 r
.51321 .21787 m .50673 .26693 L .47163 .28325 L p F P
0 g
s
.79 .778 .843 r
.50673 .26693 m .51321 .21787 L .56174 .21387 L p F P
0 g
s
.664 .74 .907 r
.63022 .18837 m .61281 .22417 L .56174 .21387 L p F P
0 g
s
.578 .635 .872 r
.61281 .22417 m .63022 .18837 L .6792 .21208 L p F P
0 g
s
.351 0 0 r
.53163 .47567 m .5398 .4812 L .50736 .46556 L p F P
0 g
s
.351 0 0 r
.50736 .46556 m .51488 .4676 L .53163 .47567 L p F P
0 g
s
.563 .028 0 r
.51488 .4676 m .50736 .46556 L .48105 .44231 L p F P
0 g
s
.286 0 .183 r
.64711 .44738 m .69731 .43094 L .67618 .4604 L p F P
0 g
s
.286 0 .183 r
.67618 .4604 m .63128 .46894 L .64711 .44738 L p F P
0 g
s
.359 .365 .73 r
.70099 .28123 m .72006 .2463 L .74828 .28748 L p F P
0 g
s
.359 .365 .73 r
.74828 .28748 m .72854 .32199 L .70099 .28123 L p F P
0 g
s
.751 .846 .922 r
.57832 .17769 m .56174 .21387 L .51321 .21787 L p F P
0 g
s
.664 .74 .907 r
.56174 .21387 m .57832 .17769 L .63022 .18837 L p F P
0 g
s
.998 .797 .508 r
.44788 .31052 m .46523 .35962 L .45879 .38574 L p F P
0 g
s
.945 .821 .69 r
.46523 .35962 m .44788 .31052 L .47163 .28325 L p F P
0 g
s
.229 .02 .375 r
.70309 .39505 m .7402 .36539 L .73404 .40652 L p F P
0 g
s
.229 .02 .375 r
.73404 .40652 m .69731 .43094 L .70309 .39505 L p F P
0 g
s
.962 .911 .718 r
.47271 .23611 m .47163 .28325 L .44788 .31052 L p F P
0 g
s
.875 .855 .819 r
.47163 .28325 m .47271 .23611 L .51321 .21787 L p F P
0 g
s
.164 .125 .564 r
.72854 .32199 m .74828 .28748 L .76041 .33124 L p F P
0 g
s
.164 .125 .564 r
.76041 .33124 m .7402 .36539 L .72854 .32199 L p F P
0 g
s
.116 0 0 r
.63128 .46894 m .67618 .4604 L .64175 .47951 L p F P
0 g
s
.116 0 0 r
.64175 .47951 m .60598 .48286 L .63128 .46894 L p F P
0 g
s
.921 .605 .133 r
.43879 .34586 m .45879 .38574 L .4642 .4145 L p F P
0 g
s
.998 .797 .508 r
.45879 .38574 m .43879 .34586 L .44788 .31052 L p F P
0 g
s
.839 .954 .889 r
.52907 .18141 m .51321 .21787 L .47271 .23611 L p F P
0 g
s
.751 .846 .922 r
.51321 .21787 m .52907 .18141 L .57832 .17769 L p F P
0 g
s
.443 .635 .937 r
.68974 .18582 m .6792 .21208 L .63022 .18837 L p F P
0 g
s
.307 .476 .863 r
.6792 .21208 m .68974 .18582 L .72654 .2165 L p F P
0 g
s
.307 .476 .863 r
.72654 .2165 m .72006 .2463 L .6792 .21208 L p F P
0 g
s
.545 .77 .981 r
.64566 .16448 m .63022 .18837 L .57832 .17769 L p F P
0 g
s
.443 .635 .937 r
.63022 .18837 m .64566 .16448 L .68974 .18582 L p F P
0 g
s
0 0 0 r
.60598 .48286 m .64175 .47951 L .59804 .48547 L p F P
0 g
s
0 0 0 r
.59804 .48547 m .57416 .48719 L .60598 .48286 L p F P
0 g
s
0 0 0 r
.69731 .43094 m .73404 .40652 L .71007 .44034 L p F P
0 g
s
0 0 0 r
.71007 .44034 m .67618 .4604 L .69731 .43094 L p F P
0 g
s
.095 .246 .73 r
.72006 .2463 m .72654 .2165 L .75196 .25326 L p F P
0 g
s
.095 .246 .73 r
.75196 .25326 m .74828 .28748 L .72006 .2463 L p F P
0 g
s
.613 .201 0 r
.44603 .38512 m .4642 .4145 L .48105 .44231 L p F P
0 g
s
.921 .605 .133 r
.4642 .4145 m .44603 .38512 L .43879 .34586 L p F P
0 g
s
.619 .896 .987 r
.59905 .15476 m .57832 .17769 L .52907 .18141 L p F P
0 g
s
.545 .77 .981 r
.57832 .17769 m .59905 .15476 L .64566 .16448 L p F P
0 g
s
.955 .836 .405 r
.44523 .26701 m .44788 .31052 L .43879 .34586 L p F P
0 g
s
.962 .911 .718 r
.44788 .31052 m .44523 .26701 L .47271 .23611 L p F P
0 g
s
0 0 .193 r
.7402 .36539 m .76041 .33124 L .75444 .37264 L p F P
0 g
s
0 0 .193 r
.75444 .37264 m .73404 .40652 L .7402 .36539 L p F P
0 g
s
.854 .978 .678 r
.48803 .19952 m .47271 .23611 L .44523 .26701 L p F P
0 g
s
.839 .954 .889 r
.47271 .23611 m .48803 .19952 L .52907 .18141 L p F P
0 g
s
.076 .614 .856 r
.57416 .48719 m .59804 .48547 L .55056 .47716 L p F P
0 g
s
.076 .614 .856 r
.55056 .47716 m .5398 .4812 L .57416 .48719 L p F P
0 g
s
.613 .201 0 r
.48105 .44231 m .4692 .42336 L .44603 .38512 L p F P
0 g
s
0 .195 .698 r
.4692 .42336 m .48105 .44231 L .50736 .46556 L p F P
0 g
s
0 0 .434 r
.74828 .28748 m .75196 .25326 L .76288 .29215 L p F P
0 g
s
0 0 .434 r
.76288 .29215 m .76041 .33124 L .74828 .28748 L p F P
0 g
s
0 .462 .851 r
.5398 .4812 m .55056 .47716 L .50561 .4555 L p F P
0 g
s
0 .462 .851 r
.50561 .4555 m .50736 .46556 L .5398 .4812 L p F P
0 g
s
0 .195 .698 r
.50736 .46556 m .50561 .4555 L .4692 .42336 L p F P
0 g
s
.614 .957 .855 r
.55497 .15791 m .52907 .18141 L .48803 .19952 L p F P
0 g
s
.619 .896 .987 r
.52907 .18141 m .55497 .15791 L .59905 .15476 L p F P
0 g
s
.381 .813 .646 r
.67618 .4604 m .71007 .44034 L .67051 .46229 L p F P
0 g
s
.381 .813 .646 r
.67051 .46229 m .64175 .47951 L .67618 .4604 L p F P
0 g
s
.955 .836 .405 r
.43879 .34586 m .43464 .30738 L .44523 .26701 L p F P
0 g
s
0 0 .195 r
.43464 .30738 m .43879 .34586 L .44603 .38512 L p F P
0 g
s
.669 .863 .471 r
.73404 .40652 m .75444 .37264 L .73031 .40659 L p F P
0 g
s
.669 .863 .471 r
.73031 .40659 m .71007 .44034 L .73404 .40652 L p F P
0 g
s
.212 .576 .941 r
.6932 .16765 m .68974 .18582 L .64566 .16448 L p F P
0 g
s
.026 .366 .836 r
.68974 .18582 m .6932 .16765 L .72128 .19099 L p F P
0 g
s
.026 .366 .836 r
.72128 .19099 m .72654 .2165 L .68974 .18582 L p F P
0 g
s
.315 .726 .977 r
.65955 .15135 m .64566 .16448 L .59905 .15476 L p F P
0 g
s
.212 .576 .941 r
.64566 .16448 m .65955 .15135 L .6932 .16765 L p F P
0 g
s
.854 .978 .678 r
.44523 .26701 m .46026 .23045 L .48803 .19952 L p F P
0 g
s
0 0 0 r
.46026 .23045 m .44523 .26701 L .43464 .30738 L p F P
0 g
s
.782 .702 .162 r
.76041 .33124 m .76288 .29215 L .75756 .32873 L p F P
0 g
s
.782 .702 .162 r
.75756 .32873 m .75444 .37264 L .76041 .33124 L p F P
0 g
s
0 .043 .611 r
.72654 .2165 m .72128 .19099 L .7406 .21881 L p F P
0 g
s
0 .043 .611 r
.7406 .21881 m .75196 .25326 L .72654 .2165 L p F P
0 g
s
.614 .957 .855 r
.48803 .19952 m .51845 .17388 L .55497 .15791 L p F P
0 g
s
0 0 0 r
.51845 .17388 m .48803 .19952 L .46026 .23045 L p F P
0 g
s
.326 .804 .901 r
.62406 .14389 m .59905 .15476 L .55497 .15791 L p F P
0 g
s
.315 .726 .977 r
.59905 .15476 m .62406 .14389 L .65955 .15135 L p F P
0 g
s
.504 .892 .956 r
.64175 .47951 m .67051 .46229 L .61991 .46905 L p F P
0 g
s
.504 .892 .956 r
.61991 .46905 m .59804 .48547 L .64175 .47951 L p F P
0 g
s
0 .098 .649 r
.44301 .35253 m .44603 .38512 L .4692 .42336 L p F P
0 g
s
0 0 .195 r
.44603 .38512 m .44301 .35253 L .43464 .30738 L p F P
0 g
s
.719 .424 0 r
.75196 .25326 m .7406 .21881 L .74879 .24804 L p F P
0 g
s
.719 .424 0 r
.74879 .24804 m .76288 .29215 L .75196 .25326 L p F P
0 g
s
.326 .804 .901 r
.55497 .15791 m .59068 .14621 L .62406 .14389 L p F P
0 g
s
0 0 0 r
.59068 .14621 m .55497 .15791 L .51845 .17388 L p F P
0 g
s
.456 .776 .998 r
.59804 .48547 m .61991 .46905 L .56473 .45928 L p F P
0 g
s
.456 .776 .998 r
.56473 .45928 m .55056 .47716 L .59804 .48547 L p F P
0 g
s
.809 .993 .87 r
.71007 .44034 m .73031 .40659 L .69027 .4285 L p F P
0 g
s
.809 .993 .87 r
.69027 .4285 m .67051 .46229 L .71007 .44034 L p F P
0 g
s
.164 .413 .854 r
.46995 .39673 m .4692 .42336 L .50561 .4555 L p F P
0 g
s
0 .098 .649 r
.4692 .42336 m .46995 .39673 L .44301 .35253 L p F P
0 g
s
0 0 .475 r
.44969 .27104 m .43464 .30738 L .44301 .35253 L p F P
0 g
s
0 0 0 r
.43464 .30738 m .44969 .27104 L .46026 .23045 L p F P
0 g
s
.962 .942 .658 r
.75444 .37264 m .75756 .32873 L .73602 .35852 L p F P
0 g
s
.962 .942 .658 r
.73602 .35852 m .73031 .40659 L .75444 .37264 L p F P
0 g
s
.342 .617 .952 r
.55056 .47716 m .56473 .45928 L .51237 .43404 L p F P
0 g
s
.342 .617 .952 r
.51237 .43404 m .50561 .4555 L .55056 .47716 L p F P
0 g
s
.164 .413 .854 r
.50561 .4555 m .51237 .43404 L .46995 .39673 L p F P
0 g
s
.058 0 .24 r
.49397 .20126 m .46026 .23045 L .44969 .27104 L p F P
0 g
s
0 0 0 r
.46026 .23045 m .49397 .20126 L .51845 .17388 L p F P
0 g
s
.982 .78 .371 r
.76288 .29215 m .74879 .24804 L .74463 .27529 L p F P
0 g
s
.982 .78 .371 r
.74463 .27529 m .75756 .32873 L .76288 .29215 L p F P
0 g
s
.103 0 0 r
.56327 .15823 m .51845 .17388 L .49397 .20126 L p F P
0 g
s
0 0 0 r
.51845 .17388 m .56327 .15823 L .59068 .14621 L p F P
0 g
s
.739 .888 .947 r
.67051 .46229 m .69027 .4285 L .6389 .43505 L p F P
0 g
s
.739 .888 .947 r
.6389 .43505 m .61991 .46905 L .67051 .46229 L p F P
0 g
s
0 .459 .849 r
.69104 .15553 m .6932 .16765 L .65955 .15135 L p F P
0 g
s
0 .221 .715 r
.6932 .16765 m .69104 .15553 L .70645 .16832 L p F P
0 g
s
0 .221 .715 r
.70645 .16832 m .72128 .19099 L .6932 .16765 L p F P
0 g
s
.062 .597 .858 r
.67254 .14657 m .65955 .15135 L .62406 .14389 L p F P
0 g
s
0 .459 .849 r
.65955 .15135 m .67254 .14657 L .69104 .15553 L p F P
0 g
s
.264 .303 .715 r
.45842 .31657 m .44301 .35253 L .46995 .39673 L p F P
0 g
s
0 0 .475 r
.44301 .35253 m .45842 .31657 L .44969 .27104 L p F P
0 g
s
0 0 .419 r
.72128 .19099 m .70645 .16832 L .71697 .18348 L p F P
0 g
s
0 0 .419 r
.71697 .18348 m .7406 .21881 L .72128 .19099 L p F P
0 g
s
.062 .597 .858 r
.62406 .14389 m .65309 .14247 L .67254 .14657 L p F P
0 g
s
0 0 0 r
.65309 .14247 m .62406 .14389 L .59068 .14621 L p F P
0 g
s
.893 .901 .825 r
.73031 .40659 m .73602 .35852 L .7003 .37752 L p F P
0 g
s
.893 .901 .825 r
.7003 .37752 m .69027 .4285 L .73031 .40659 L p F P
0 g
s
.305 .183 .544 r
.48497 .23718 m .44969 .27104 L .45842 .31657 L p F P
0 g
s
.058 0 .24 r
.44969 .27104 m .48497 .23718 L .49397 .20126 L p F P
0 g
s
.975 .857 .659 r
.75756 .32873 m .74463 .27529 L .72824 .29722 L p F P
0 g
s
.975 .857 .659 r
.72824 .29722 m .73602 .35852 L .75756 .32873 L p F P
0 g
s
.645 .763 .935 r
.61991 .46905 m .6389 .43505 L .58274 .42489 L p F P
0 g
s
.645 .763 .935 r
.58274 .42489 m .56473 .45928 L .61991 .46905 L p F P
0 g
s
.881 .528 .037 r
.7406 .21881 m .71697 .18348 L .72133 .19925 L p F P
0 g
s
.881 .528 .037 r
.72133 .19925 m .74879 .24804 L .7406 .21881 L p F P
0 g
s
.429 .498 .829 r
.48604 .36129 m .46995 .39673 L .51237 .43404 L p F P
0 g
s
.264 .303 .715 r
.46995 .39673 m .48604 .36129 L .45842 .31657 L p F P
0 g
s
.312 .053 .35 r
.54521 .17879 m .49397 .20126 L .48497 .23718 L p F P
0 g
s
.103 0 0 r
.49397 .20126 m .54521 .17879 L .56327 .15823 L p F P
0 g
s
.118 0 0 r
.63493 .14373 m .59068 .14621 L .56327 .15823 L p F P
0 g
s
0 0 0 r
.59068 .14621 m .63493 .14373 L .65309 .14247 L p F P
0 g
s
.546 .639 .894 r
.56473 .45928 m .58274 .42489 L .52937 .39914 L p F P
0 g
s
.546 .639 .894 r
.52937 .39914 m .51237 .43404 L .56473 .45928 L p F P
0 g
s
.429 .498 .829 r
.51237 .43404 m .52937 .39914 L .48604 .36129 L p F P
0 g
s
.798 .81 .861 r
.69027 .4285 m .7003 .37752 L .65454 .3829 L p F P
0 g
s
.798 .81 .861 r
.65454 .3829 m .6389 .43505 L .69027 .4285 L p F P
0 g
s
.995 .753 .432 r
.74879 .24804 m .72133 .19925 L .71892 .21377 L p F P
0 g
s
.995 .753 .432 r
.71892 .21377 m .74463 .27529 L .74879 .24804 L p F P
0 g
s
.29 0 .113 r
.62021 .15027 m .56327 .15823 L .54521 .17879 L p F P
0 g
s
.118 0 0 r
.56327 .15823 m .62021 .15027 L .63493 .14373 L p F P
0 g
s
.449 .383 .691 r
.49318 .27746 m .45842 .31657 L .48604 .36129 L p F P
0 g
s
.305 .183 .544 r
.45842 .31657 m .49318 .27746 L .48497 .23718 L p F P
0 g
s
.894 .819 .767 r
.73602 .35852 m .72824 .29722 L .70131 .31095 L p F P
0 g
s
.894 .819 .767 r
.70131 .31095 m .7003 .37752 L .73602 .35852 L p F P
0 g
s
.442 .271 .552 r
.53894 .20565 m .48497 .23718 L .49318 .27746 L p F P
0 g
s
.312 .053 .35 r
.48497 .23718 m .53894 .20565 L .54521 .17879 L p F P
0 g
s
.959 .801 .642 r
.74463 .27529 m .71892 .21377 L .70993 .22528 L p F P
0 g
s
.959 .801 .642 r
.70993 .22528 m .72824 .29722 L .74463 .27529 L p F P
0 g
s
.713 .718 .853 r
.6389 .43505 m .65454 .3829 L .60453 .37358 L p F P
0 g
s
.713 .718 .853 r
.60453 .37358 m .58274 .42489 L .6389 .43505 L p F P
0 g
s
.549 .518 .773 r
.51813 .31702 m .48604 .36129 L .52937 .39914 L p F P
0 g
s
.449 .383 .691 r
.48604 .36129 m .51813 .31702 L .49318 .27746 L p F P
0 g
s
.415 .142 .389 r
.61072 .16138 m .54521 .17879 L .53894 .20565 L p F P
0 g
s
.29 0 .113 r
.54521 .17879 m .61072 .16138 L .62021 .15027 L p F P
0 g
s
0 .374 .76 r
.6855 .1465 m .69104 .15553 L .67254 .14657 L closepath p F P
0 g
s
0 .134 .617 r
.6855 .1465 m .70645 .16832 L .69104 .15553 L closepath p F P
0 g
s
0 .501 .754 r
.6855 .1465 m .67254 .14657 L .65309 .14247 L closepath p F P
0 g
s
.632 .624 .824 r
.58274 .42489 m .60453 .37358 L .55693 .35059 L p F P
0 g
s
.632 .624 .824 r
.55693 .35059 m .52937 .39914 L .58274 .42489 L p F P
0 g
s
.811 .755 .8 r
.7003 .37752 m .70131 .31095 L .66698 .31453 L p F P
0 g
s
.811 .755 .8 r
.66698 .31453 m .65454 .3829 L .7003 .37752 L p F P
0 g
s
.549 .518 .773 r
.52937 .39914 m .55693 .35059 L .51813 .31702 L p F P
0 g
s
.669 .21 0 r
.6855 .1465 m .71697 .18348 L .70645 .16832 L closepath p F P
0 g
s
.106 0 0 r
.6855 .1465 m .65309 .14247 L .63493 .14373 L closepath p F P
0 g
s
.532 .415 .665 r
.54559 .23565 m .49318 .27746 L .51813 .31702 L p F P
0 g
s
.442 .271 .552 r
.49318 .27746 m .54559 .23565 L .53894 .20565 L p F P
0 g
s
.916 .551 .111 r
.6855 .1465 m .72133 .19925 L .71697 .18348 L closepath p F P
0 g
s
.886 .774 .732 r
.72824 .29722 m .70993 .22528 L .69535 .23232 L p F P
0 g
s
.886 .774 .732 r
.69535 .23232 m .70131 .31095 L .72824 .29722 L p F P
0 g
s
.227 0 0 r
.6855 .1465 m .63493 .14373 L .62021 .15027 L closepath p F P
0 g
s
.503 .309 .55 r
.6077 .17579 m .53894 .20565 L .54559 .23565 L p F P
0 g
s
.415 .142 .389 r
.53894 .20565 m .6077 .17579 L .61072 .16138 L p F P
0 g
s
.988 .734 .449 r
.6855 .1465 m .71892 .21377 L .72133 .19925 L closepath p F P
0 g
s
.738 .684 .798 r
.65454 .3829 m .66698 .31453 L .62955 .30728 L p F P
0 g
s
.738 .684 .798 r
.62955 .30728 m .60453 .37358 L .65454 .3829 L p F P
0 g
s
.355 0 .162 r
.6855 .1465 m .62021 .15027 L .61072 .16138 L closepath p F P
0 g
s
.605 .521 .733 r
.56465 .26506 m .51813 .31702 L .55693 .35059 L p F P
0 g
s
.532 .415 .665 r
.51813 .31702 m .56465 .26506 L .54559 .23565 L p F P
0 g
s
.814 .723 .764 r
.70131 .31095 m .69535 .23232 L .67692 .23394 L p F P
0 g
s
.814 .723 .764 r
.67692 .23394 m .66698 .31453 L .70131 .31095 L p F P
0 g
s
.949 .776 .633 r
.6855 .1465 m .70993 .22528 L .71892 .21377 L closepath p F P
0 g
s
.671 .607 .775 r
.60453 .37358 m .62955 .30728 L .59388 .29004 L p F P
0 g
s
.671 .607 .775 r
.59388 .29004 m .55693 .35059 L .60453 .37358 L p F P
0 g
s
.571 .428 .648 r
.6116 .19178 m .54559 .23565 L .56465 .26506 L p F P
0 g
s
.503 .309 .55 r
.54559 .23565 m .6116 .19178 L .6077 .17579 L p F P
0 g
s
.605 .521 .733 r
.55693 .35059 m .59388 .29004 L .56465 .26506 L p F P
0 g
s
.453 .176 .402 r
.6855 .1465 m .61072 .16138 L .6077 .17579 L closepath p F P
0 g
s
.882 .754 .717 r
.6855 .1465 m .69535 .23232 L .70993 .22528 L closepath p F P
0 g
s
.749 .663 .766 r
.66698 .31453 m .67692 .23394 L .65689 .2299 L p F P
0 g
s
.749 .663 .766 r
.65689 .2299 m .62955 .30728 L .66698 .31453 L p F P
0 g
s
.526 .324 .548 r
.6855 .1465 m .6077 .17579 L .6116 .19178 L closepath p F P
0 g
s
.632 .52 .709 r
.62205 .20739 m .56465 .26506 L .59388 .29004 L p F P
0 g
s
.571 .428 .648 r
.56465 .26506 m .62205 .20739 L .6116 .19178 L p F P
0 g
s
.69 .597 .747 r
.62955 .30728 m .65689 .2299 L .63781 .22066 L p F P
0 g
s
.69 .597 .747 r
.63781 .22066 m .59388 .29004 L .62955 .30728 L p F P
0 g
s
.632 .52 .709 r
.59388 .29004 m .63781 .22066 L .62205 .20739 L p F P
0 g
s
.815 .709 .748 r
.6855 .1465 m .67692 .23394 L .69535 .23232 L closepath p F P
0 g
s
.587 .433 .64 r
.6855 .1465 m .6116 .19178 L .62205 .20739 L closepath p F P
0 g
s
.754 .654 .751 r
.6855 .1465 m .65689 .2299 L .67692 .23394 L closepath p F P
0 g
s
.643 .519 .698 r
.6855 .1465 m .62205 .20739 L .63781 .22066 L closepath p F P
0 g
s
.697 .591 .734 r
.6855 .1465 m .63781 .22066 L .65689 .2299 L closepath p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.431973 0.257081 0.568027 0.603319 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.66443e-17 1.00796 -0.103262 1.00796 [
[ 0 0 0 0 ]
[ 1 .73459 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .73459 L
0 .73459 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.743 .626 .73 r
.32038 .55055 m .27705 .59546 L .30845 .54179 L closepath p F P
0 g
s
.709 .572 .698 r
.32989 .56229 m .27705 .59546 L .32038 .55055 L closepath p F P
0 g
s
.735 .628 .74 r
.36127 .50866 m .32038 .55055 L .30845 .54179 L p F P
0 g
s
.7 .57 .706 r
.32038 .55055 m .36127 .50866 L .37916 .53073 L p F P
0 g
s
.7 .57 .706 r
.37916 .53073 m .32989 .56229 L .32038 .55055 L p F P
0 g
s
.682 .516 .655 r
.33585 .57565 m .27705 .59546 L .32989 .56229 L closepath p F P
0 g
s
.67 .51 .66 r
.32989 .56229 m .37916 .53073 L .39053 .55579 L p F P
0 g
s
.67 .51 .66 r
.39053 .55579 m .33585 .57565 L .32989 .56229 L p F P
0 g
s
.735 .628 .74 r
.30845 .54179 m .3389 .49208 L .36127 .50866 L p F P
0 g
s
.717 .632 .761 r
.39785 .47217 m .36127 .50866 L .3389 .49208 L p F P
0 g
s
.678 .567 .722 r
.36127 .50866 m .39785 .47217 L .42204 .50198 L p F P
0 g
s
.678 .567 .722 r
.42204 .50198 m .37916 .53073 L .36127 .50866 L p F P
0 g
s
.643 .498 .671 r
.37916 .53073 m .42204 .50198 L .4376 .53578 L p F P
0 g
s
.643 .498 .671 r
.4376 .53578 m .39053 .55579 L .37916 .53073 L p F P
0 g
s
.999 .816 .525 r
.2652 .55019 m .27705 .59546 L .26212 .56207 L closepath p F P
0 g
s
.954 .828 .68 r
.27245 .54147 m .27705 .59546 L .2652 .55019 L closepath p F P
0 g
s
.89 .788 .742 r
.28298 .53693 m .27705 .59546 L .27245 .54147 L closepath p F P
0 g
s
.831 .735 .758 r
.29547 .53706 m .27705 .59546 L .28298 .53693 L closepath p F P
0 g
s
.782 .68 .751 r
.30845 .54179 m .27705 .59546 L .29547 .53706 L closepath p F P
0 g
s
.658 .455 .598 r
.33757 .58907 m .27705 .59546 L .33585 .57565 L closepath p F P
0 g
s
.639 .385 .519 r
.33479 .60096 m .27705 .59546 L .33757 .58907 L closepath p F P
0 g
s
.623 .302 .406 r
.32781 .60989 m .27705 .59546 L .33479 .60096 L closepath p F P
0 g
s
.61 .198 .238 r
.31741 .61475 m .27705 .59546 L .32781 .60989 L closepath p F P
0 g
s
.592 .078 0 r
.30484 .61489 m .27705 .59546 L .31741 .61475 L closepath p F P
0 g
s
.563 0 0 r
.29161 .61025 m .27705 .59546 L .30484 .61489 L closepath p F P
0 g
s
.552 0 0 r
.27937 .60138 m .27705 .59546 L .29161 .61025 L closepath p F P
0 g
s
.626 .15 0 r
.26965 .58935 m .27705 .59546 L .27937 .60138 L closepath p F P
0 g
s
.793 .412 0 r
.26366 .57568 m .27705 .59546 L .26965 .58935 L closepath p F P
0 g
s
.955 .679 .235 r
.26212 .56207 m .27705 .59546 L .26366 .57568 L closepath p F P
0 g
s
.777 .686 .763 r
.3389 .49208 m .30845 .54179 L .29547 .53706 L p F P
0 g
s
.644 .445 .599 r
.33585 .57565 m .39053 .55579 L .39405 .58102 L p F P
0 g
s
.644 .445 .599 r
.39405 .58102 m .33757 .58907 L .33585 .57565 L p F P
0 g
s
.777 .686 .763 r
.29547 .53706 m .31456 .48292 L .3389 .49208 L p F P
0 g
s
.764 .699 .79 r
.36771 .44963 m .3389 .49208 L .31456 .48292 L p F P
0 g
s
.717 .632 .761 r
.3389 .49208 m .36771 .44963 L .39785 .47217 L p F P
0 g
s
.681 .636 .798 r
.42887 .4427 m .39785 .47217 L .36771 .44963 L p F P
0 g
s
.635 .557 .75 r
.39785 .47217 m .42887 .4427 L .45658 .47681 L p F P
0 g
s
.635 .557 .75 r
.45658 .47681 m .42204 .50198 L .39785 .47217 L p F P
0 g
s
.609 .42 .601 r
.39053 .55579 m .4376 .53578 L .44269 .56982 L p F P
0 g
s
.609 .42 .601 r
.44269 .56982 m .39405 .58102 L .39053 .55579 L p F P
0 g
s
.829 .746 .773 r
.31456 .48292 m .29547 .53706 L .28298 .53693 L p F P
0 g
s
.59 .473 .688 r
.42204 .50198 m .45658 .47681 L .47456 .51541 L p F P
0 g
s
.59 .473 .688 r
.47456 .51541 m .4376 .53578 L .42204 .50198 L p F P
0 g
s
.62 .367 .513 r
.33757 .58907 m .39405 .58102 L .38917 .60348 L p F P
0 g
s
.62 .367 .513 r
.38917 .60348 m .33479 .60096 L .33757 .58907 L p F P
0 g
s
.764 .699 .79 r
.31456 .48292 m .33492 .43695 L .36771 .44963 L p F P
0 g
s
.734 .719 .837 r
.39447 .41679 m .36771 .44963 L .33492 .43695 L p F P
0 g
s
.681 .636 .798 r
.36771 .44963 m .39447 .41679 L .42887 .4427 L p F P
0 g
s
.892 .806 .757 r
.29105 .48233 m .28298 .53693 L .27245 .54147 L p F P
0 g
s
.829 .746 .773 r
.28298 .53693 m .29105 .48233 L .31456 .48292 L p F P
0 g
s
.821 .771 .805 r
.33492 .43695 m .31456 .48292 L .29105 .48233 L p F P
0 g
s
.539 .372 .603 r
.4376 .53578 m .47456 .51541 L .48069 .55429 L p F P
0 g
s
.539 .372 .603 r
.48069 .55429 m .44269 .56982 L .4376 .53578 L p F P
0 g
s
.597 .269 .386 r
.33479 .60096 m .38917 .60348 L .37632 .62047 L p F P
0 g
s
.597 .269 .386 r
.37632 .62047 m .32781 .60989 L .33479 .60096 L p F P
0 g
s
.573 .323 .499 r
.39405 .58102 m .44269 .56982 L .43651 .60024 L p F P
0 g
s
.573 .323 .499 r
.43651 .60024 m .38917 .60348 L .39405 .58102 L p F P
0 g
s
.608 .635 .853 r
.45378 .42108 m .42887 .4427 L .39447 .41679 L p F P
0 g
s
.551 .534 .789 r
.42887 .4427 m .45378 .42108 L .4818 .45555 L p F P
0 g
s
.551 .534 .789 r
.4818 .45555 m .45658 .47681 L .42887 .4427 L p F P
0 g
s
.486 .422 .71 r
.45658 .47681 m .4818 .45555 L .50008 .49447 L p F P
0 g
s
.486 .422 .71 r
.50008 .49447 m .47456 .51541 L .45658 .47681 L p F P
0 g
s
.961 .853 .689 r
.27113 .49054 m .27245 .54147 L .2652 .55019 L p F P
0 g
s
.892 .806 .757 r
.27245 .54147 m .27113 .49054 L .29105 .48233 L p F P
0 g
s
.569 .14 .187 r
.32781 .60989 m .37632 .62047 L .35687 .62982 L p F P
0 g
s
.569 .14 .187 r
.35687 .62982 m .31741 .61475 L .32781 .60989 L p F P
0 g
s
.821 .771 .805 r
.29105 .48233 m .30317 .43574 L .33492 .43695 L p F P
0 g
s
.798 .814 .865 r
.35708 .40201 m .33492 .43695 L .30317 .43574 L p F P
0 g
s
.734 .719 .837 r
.33492 .43695 m .35708 .40201 L .39447 .41679 L p F P
0 g
s
.663 .743 .909 r
.4191 .39481 m .39447 .41679 L .35708 .40201 L p F P
0 g
s
.608 .635 .853 r
.39447 .41679 m .4191 .39481 L .45378 .42108 L p F P
0 g
s
.893 .849 .793 r
.30317 .43574 m .29105 .48233 L .27113 .49054 L p F P
0 g
s
.47 .229 .466 r
.44269 .56982 m .48069 .55429 L .47401 .58904 L p F P
0 g
s
.47 .229 .466 r
.47401 .58904 m .43651 .60024 L .44269 .56982 L p F P
0 g
s
.394 .272 .593 r
.47456 .51541 m .50008 .49447 L .50649 .5336 L p F P
0 g
s
.394 .272 .593 r
.50649 .5336 m .48069 .55429 L .47456 .51541 L p F P
0 g
s
.999 .834 .502 r
.25729 .50676 m .2652 .55019 L .26212 .56207 L p F P
0 g
s
.961 .853 .689 r
.2652 .55019 m .25729 .50676 L .27113 .49054 L p F P
0 g
s
.527 .187 .335 r
.38917 .60348 m .43651 .60024 L .4195 .62336 L p F P
0 g
s
.527 .187 .335 r
.4195 .62336 m .37632 .62047 L .38917 .60348 L p F P
0 g
s
.521 0 0 r
.31741 .61475 m .35687 .62982 L .33307 .63019 L p F P
0 g
s
.521 0 0 r
.33307 .63019 m .30484 .61489 L .31741 .61475 L p F P
0 g
s
.999 .834 .502 r
.26212 .56207 m .25136 .52917 L .25729 .50676 L p F P
0 g
s
.902 .645 .138 r
.25136 .52917 m .26212 .56207 L .26366 .57568 L p F P
0 g
s
.441 0 0 r
.30484 .61489 m .33307 .63019 L .30784 .62137 L p F P
0 g
s
.441 0 0 r
.30784 .62137 m .29161 .61025 L .30484 .61489 L p F P
0 g
s
.454 .607 .912 r
.47268 .4073 m .45378 .42108 L .4191 .39481 L p F P
0 g
s
.389 .475 .827 r
.45378 .42108 m .47268 .4073 L .4977 .43806 L p F P
0 g
s
.389 .475 .827 r
.4977 .43806 m .4818 .45555 L .45378 .42108 L p F P
0 g
s
.798 .814 .865 r
.30317 .43574 m .32086 .40026 L .35708 .40201 L p F P
0 g
s
.717 .87 .953 r
.38149 .37971 m .35708 .40201 L .32086 .40026 L p F P
0 g
s
.663 .743 .909 r
.35708 .40201 m .38149 .37971 L .4191 .39481 L p F P
0 g
s
.283 .314 .717 r
.4818 .45555 m .4977 .43806 L .51407 .47272 L p F P
0 g
s
.283 .314 .717 r
.51407 .47272 m .50008 .49447 L .4818 .45555 L p F P
0 g
s
.967 .911 .704 r
.27617 .44643 m .27113 .49054 L .25729 .50676 L p F P
0 g
s
.893 .849 .793 r
.27113 .49054 m .27617 .44643 L .30317 .43574 L p F P
0 g
s
.662 .308 0 r
.25425 .55509 m .26366 .57568 L .26965 .58935 L p F P
0 g
s
.902 .645 .138 r
.26366 .57568 m .25425 .55509 L .25136 .52917 L p F P
0 g
s
.874 .924 .855 r
.32086 .40026 m .30317 .43574 L .27617 .44643 L p F P
0 g
s
0 .148 .595 r
.29161 .61025 m .30784 .62137 L .28439 .60435 L p F P
0 g
s
0 .148 .595 r
.28439 .60435 m .27937 .60138 L .29161 .61025 L p F P
0 g
s
.229 .022 .377 r
.48069 .55429 m .50649 .5336 L .50001 .56852 L p F P
0 g
s
.229 .022 .377 r
.50001 .56852 m .47401 .58904 L .48069 .55429 L p F P
0 g
s
.662 .308 0 r
.26965 .58935 m .26572 .58127 L .25425 .55509 L p F P
0 g
s
0 0 .527 r
.26572 .58127 m .26965 .58935 L .27937 .60138 L p F P
0 g
s
.448 0 .045 r
.37632 .62047 m .4195 .62336 L .39337 .63615 L p F P
0 g
s
.448 0 .045 r
.39337 .63615 m .35687 .62982 L .37632 .62047 L p F P
0 g
s
0 0 .527 r
.27937 .60138 m .28439 .60435 L .26572 .58127 L p F P
0 g
s
.35 0 .21 r
.43651 .60024 m .47401 .58904 L .45489 .61549 L p F P
0 g
s
.35 0 .21 r
.45489 .61549 m .4195 .62336 L .43651 .60024 L p F P
0 g
s
.487 .735 .981 r
.44179 .38382 m .4191 .39481 L .38149 .37971 L p F P
0 g
s
.454 .607 .912 r
.4191 .39481 m .44179 .38382 L .47268 .4073 L p F P
0 g
s
.092 .065 .531 r
.50008 .49447 m .51407 .47272 L .51988 .50744 L p F P
0 g
s
.092 .065 .531 r
.51988 .50744 m .50649 .5336 L .50008 .49447 L p F P
0 g
s
.946 .844 .411 r
.25733 .46811 m .25729 .50676 L .25136 .52917 L p F P
0 g
s
.967 .911 .704 r
.25729 .50676 m .25733 .46811 L .27617 .44643 L p F P
0 g
s
.287 0 0 r
.35687 .62982 m .39337 .63615 L .36112 .63672 L p F P
0 g
s
.287 0 0 r
.36112 .63672 m .33307 .63019 L .35687 .62982 L p F P
0 g
s
.874 .924 .855 r
.27617 .44643 m .29004 .41214 L .32086 .40026 L p F P
0 g
s
.719 .984 .896 r
.34512 .37772 m .32086 .40026 L .29004 .41214 L p F P
0 g
s
.717 .87 .953 r
.32086 .40026 m .34512 .37772 L .38149 .37971 L p F P
0 g
s
.44 .84 .977 r
.40841 .37028 m .38149 .37971 L .34512 .37772 L p F P
0 g
s
.487 .735 .981 r
.38149 .37971 m .40841 .37028 L .44179 .38382 L p F P
0 g
s
.896 .977 .685 r
.29004 .41214 m .27617 .44643 L .25733 .46811 L p F P
0 g
s
0 0 0 r
.47401 .58904 m .50001 .56852 L .481 .59501 L p F P
0 g
s
0 0 0 r
.481 .59501 m .45489 .61549 L .47401 .58904 L p F P
0 g
s
0 0 .123 r
.50649 .5336 m .51988 .50744 L .51424 .53828 L p F P
0 g
s
0 0 .123 r
.51424 .53828 m .50001 .56852 L .50649 .5336 L p F P
0 g
s
.087 0 0 r
.4195 .62336 m .45489 .61549 L .42523 .63013 L p F P
0 g
s
.087 0 0 r
.42523 .63013 m .39337 .63615 L .4195 .62336 L p F P
0 g
s
.178 .502 .909 r
.48634 .40052 m .47268 .4073 L .44179 .38382 L p F P
0 g
s
.113 .346 .813 r
.47268 .4073 m .48634 .40052 L .50526 .42379 L p F P
0 g
s
.113 .346 .813 r
.50526 .42379 m .4977 .43806 L .47268 .4073 L p F P
0 g
s
.946 .844 .411 r
.25136 .52917 m .24921 .49843 L .25733 .46811 L p F P
0 g
s
0 0 .122 r
.24921 .49843 m .25136 .52917 L .25425 .55509 L p F P
0 g
s
0 .118 .651 r
.4977 .43806 m .50526 .42379 L .51766 .44992 L p F P
0 g
s
0 .118 .651 r
.51766 .44992 m .51407 .47272 L .4977 .43806 L p F P
0 g
s
0 .471 .79 r
.33307 .63019 m .36112 .63672 L .32669 .62466 L p F P
0 g
s
0 .471 .79 r
.32669 .62466 m .30784 .62137 L .33307 .63019 L p F P
0 g
s
.139 .6 .926 r
.46303 .38276 m .44179 .38382 L .40841 .37028 L p F P
0 g
s
.178 .502 .909 r
.44179 .38382 m .46303 .38276 L .48634 .40052 L p F P
0 g
s
0 0 .337 r
.51407 .47272 m .51766 .44992 L .52206 .47599 L p F P
0 g
s
0 0 .337 r
.52206 .47599 m .51988 .50744 L .51407 .47272 L p F P
0 g
s
0 0 .54 r
.25316 .53375 m .25425 .55509 L .26572 .58127 L p F P
0 g
s
0 0 .122 r
.25425 .55509 m .25316 .53375 L .24921 .49843 L p F P
0 g
s
.719 .984 .896 r
.29004 .41214 m .31425 .38946 L .34512 .37772 L p F P
0 g
s
.44 .84 .977 r
.34512 .37772 m .37627 .36842 L .40841 .37028 L p F P
0 g
s
0 0 0 r
.37627 .36842 m .34512 .37772 L .31425 .38946 L p F P
0 g
s
0 .414 .854 r
.30784 .62137 m .32669 .62466 L .29454 .6013 L p F P
0 g
s
0 .414 .854 r
.29454 .6013 m .28439 .60435 L .30784 .62137 L p F P
0 g
s
.896 .977 .685 r
.25733 .46811 m .26852 .43668 L .29004 .41214 L p F P
0 g
s
0 0 0 r
.26852 .43668 m .25733 .46811 L .24921 .49843 L p F P
0 g
s
0 0 0 r
.31425 .38946 m .29004 .41214 L .26852 .43668 L p F P
0 g
s
0 .24 .757 r
.26891 .56961 m .26572 .58127 L .28439 .60435 L p F P
0 g
s
0 0 .54 r
.26572 .58127 m .26891 .56961 L .25316 .53375 L p F P
0 g
s
.793 .926 .553 r
.50001 .56852 m .51424 .53828 L .4975 .5615 L p F P
0 g
s
.793 .926 .553 r
.4975 .5615 m .481 .59501 L .50001 .56852 L p F P
0 g
s
0 .24 .757 r
.28439 .60435 m .29454 .6013 L .26891 .56961 L p F P
0 g
s
.274 .772 .886 r
.39337 .63615 m .42523 .63013 L .38836 .63072 L p F P
0 g
s
.274 .772 .886 r
.38836 .63072 m .36112 .63672 L .39337 .63615 L p F P
0 g
s
.139 .6 .926 r
.40841 .37028 m .43794 .37254 L .46303 .38276 L p F P
0 g
s
.065 0 0 r
.43794 .37254 m .40841 .37028 L .37627 .36842 L p F P
0 g
s
.604 .949 .808 r
.45489 .61549 m .481 .59501 L .45132 .60957 L p F P
0 g
s
.604 .949 .808 r
.45132 .60957 m .42523 .63013 L .45489 .61549 L p F P
0 g
s
.811 .741 .218 r
.51988 .50744 m .52206 .47599 L .51783 .49897 L p F P
0 g
s
.811 .741 .218 r
.51783 .49897 m .51424 .53828 L .51988 .50744 L p F P
0 g
s
0 0 0 r
.24921 .49843 m .25928 .47129 L .26852 .43668 L p F P
0 g
s
0 0 .444 r
.25928 .47129 m .24921 .49843 L .25316 .53375 L p F P
0 g
s
0 0 0 r
.26852 .43668 m .29277 .414 L .31425 .38946 L p F P
0 g
s
.241 0 .075 r
.34914 .37876 m .31425 .38946 L .29277 .414 L p F P
0 g
s
0 0 0 r
.31425 .38946 m .34914 .37876 L .37627 .36842 L p F P
0 g
s
.402 .73 .991 r
.36112 .63672 m .38836 .63072 L .34883 .61675 L p F P
0 g
s
.402 .73 .991 r
.34883 .61675 m .32669 .62466 L .36112 .63672 L p F P
0 g
s
.333 0 0 r
.41394 .37115 m .37627 .36842 L .34914 .37876 L p F P
0 g
s
.065 0 0 r
.37627 .36842 m .41394 .37115 L .43794 .37254 L p F P
0 g
s
0 .331 .791 r
.49613 .39912 m .48634 .40052 L .46303 .38276 L p F P
0 g
s
0 .173 .707 r
.48634 .40052 m .49613 .39912 L .50642 .41177 L p F P
0 g
s
0 .173 .707 r
.50642 .41177 m .50526 .42379 L .48634 .40052 L p F P
0 g
s
.103 0 .278 r
.29277 .414 m .26852 .43668 L .25928 .47129 L p F P
0 g
s
0 0 .496 r
.50526 .42379 m .50642 .41177 L .51316 .42594 L p F P
0 g
s
0 0 .496 r
.51316 .42594 m .51766 .44992 L .50526 .42379 L p F P
0 g
s
.875 .963 .853 r
.481 .59501 m .4975 .5615 L .47132 .57407 L p F P
0 g
s
.875 .963 .853 r
.47132 .57407 m .45132 .60957 L .481 .59501 L p F P
0 g
s
.968 .935 .655 r
.51424 .53828 m .51783 .49897 L .50529 .51608 L p F P
0 g
s
.968 .935 .655 r
.50529 .51608 m .4975 .5615 L .51424 .53828 L p F P
0 g
s
0 .368 .709 r
.48348 .38946 m .46303 .38276 L .43794 .37254 L p F P
0 g
s
0 .331 .791 r
.46303 .38276 m .48348 .38946 L .49613 .39912 L p F P
0 g
s
.692 .901 .971 r
.42523 .63013 m .45132 .60957 L .41431 .60994 L p F P
0 g
s
.692 .901 .971 r
.41431 .60994 m .38836 .63072 L .42523 .63013 L p F P
0 g
s
.712 .483 0 r
.51766 .44992 m .51316 .42594 L .51553 .43999 L p F P
0 g
s
.712 .483 0 r
.51553 .43999 m .52206 .47599 L .51766 .44992 L p F P
0 g
s
.183 .247 .696 r
.26393 .51183 m .25316 .53375 L .26891 .56961 L p F P
0 g
s
0 0 .444 r
.25316 .53375 m .26393 .51183 L .25928 .47129 L p F P
0 g
s
.388 .595 .927 r
.32669 .62466 m .34883 .61675 L .31178 .58974 L p F P
0 g
s
.388 .595 .927 r
.31178 .58974 m .29454 .6013 L .32669 .62466 L p F P
0 g
s
0 .368 .709 r
.43794 .37254 m .46993 .38394 L .48348 .38946 L p F P
0 g
s
.376 0 0 r
.46993 .38394 m .43794 .37254 L .41394 .37115 L p F P
0 g
s
.316 .443 .831 r
.28217 .55315 m .26891 .56961 L .29454 .6013 L p F P
0 g
s
.183 .247 .696 r
.26891 .56961 m .28217 .55315 L .26393 .51183 L p F P
0 g
s
.962 .807 .372 r
.52206 .47599 m .51553 .43999 L .51322 .45226 L p F P
0 g
s
.962 .807 .372 r
.51322 .45226 m .51783 .49897 L .52206 .47599 L p F P
0 g
s
.316 .443 .831 r
.29454 .6013 m .31178 .58974 L .28217 .55315 L p F P
0 g
s
.241 0 .075 r
.29277 .414 m .33045 .40044 L .34914 .37876 L p F P
0 g
s
.478 .105 .253 r
.39387 .37894 m .34914 .37876 L .33045 .40044 L p F P
0 g
s
.333 0 0 r
.34914 .37876 m .39387 .37894 L .41394 .37115 L p F P
0 g
s
.103 0 .278 r
.25928 .47129 m .28371 .44874 L .29277 .414 L p F P
0 g
s
.334 .215 .565 r
.28371 .44874 m .25928 .47129 L .26393 .51183 L p F P
0 g
s
.423 .167 .419 r
.33045 .40044 m .29277 .414 L .28371 .44874 L p F P
0 g
s
.911 .883 .794 r
.4975 .5615 m .50529 .51608 L .48576 .52511 L p F P
0 g
s
.911 .883 .794 r
.48576 .52511 m .47132 .57407 L .4975 .5615 L p F P
0 g
s
.647 .761 .932 r
.38836 .63072 m .41431 .60994 L .37452 .59565 L p F P
0 g
s
.647 .761 .932 r
.37452 .59565 m .34883 .61675 L .38836 .63072 L p F P
0 g
s
.804 .843 .88 r
.45132 .60957 m .47132 .57407 L .43868 .57407 L p F P
0 g
s
.804 .843 .88 r
.43868 .57407 m .41431 .60994 L .45132 .60957 L p F P
0 g
s
.503 .022 .045 r
.45708 .38323 m .41394 .37115 L .39387 .37894 L p F P
0 g
s
.376 0 0 r
.41394 .37115 m .45708 .38323 L .46993 .38394 L p F P
0 g
s
.981 .883 .656 r
.51783 .49897 m .51322 .45226 L .50646 .46126 L p F P
0 g
s
.981 .883 .656 r
.50646 .46126 m .50529 .51608 L .51783 .49897 L p F P
0 g
s
.451 .397 .706 r
.28861 .48956 m .26393 .51183 L .28217 .55315 L p F P
0 g
s
.334 .215 .565 r
.26393 .51183 m .28861 .48956 L .28371 .44874 L p F P
0 g
s
.59 .64 .868 r
.34883 .61675 m .37452 .59565 L .33715 .56825 L p F P
0 g
s
.59 .64 .868 r
.33715 .56825 m .31178 .58974 L .34883 .61675 L p F P
0 g
s
.423 .167 .419 r
.28371 .44874 m .32278 .43113 L .33045 .40044 L p F P
0 g
s
.549 .283 .465 r
.38024 .39518 m .33045 .40044 L .32278 .43113 L p F P
0 g
s
.478 .105 .253 r
.33045 .40044 m .38024 .39518 L .39387 .37894 L p F P
0 g
s
0 .215 .679 r
.50398 .40072 m .49613 .39912 L .48348 .38946 L closepath p F P
0 g
s
0 .062 .608 r
.50398 .40072 m .50642 .41177 L .49613 .39912 L closepath p F P
0 g
s
.566 .208 .32 r
.44646 .38748 m .39387 .37894 L .38024 .39518 L p F P
0 g
s
.503 .022 .045 r
.39387 .37894 m .44646 .38748 L .45708 .38323 L p F P
0 g
s
0 0 .381 r
.50398 .40072 m .51316 .42594 L .50642 .41177 L closepath p F P
0 g
s
.514 .343 .586 r
.32278 .43113 m .28371 .44874 L .28861 .48956 L p F P
0 g
s
.362 0 0 r
.50398 .40072 m .48348 .38946 L .46993 .38394 L closepath p F P
0 g
s
.833 .794 .815 r
.47132 .57407 m .48576 .52511 L .4615 .52477 L p F P
0 g
s
.833 .794 .815 r
.4615 .52477 m .43868 .57407 L .47132 .57407 L p F P
0 g
s
.825 .56 .009 r
.50398 .40072 m .51553 .43999 L .51316 .42594 L closepath p F P
0 g
s
.913 .836 .756 r
.50529 .51608 m .50646 .46126 L .49599 .46587 L p F P
0 g
s
.913 .836 .756 r
.49599 .46587 m .48576 .52511 L .50529 .51608 L p F P
0 g
s
.528 .526 .797 r
.30718 .53124 m .28217 .55315 L .31178 .58974 L p F P
0 g
s
.451 .397 .706 r
.28217 .55315 m .30718 .53124 L .28861 .48956 L p F P
0 g
s
.735 .735 .851 r
.41431 .60994 m .43868 .57407 L .4036 .56116 L p F P
0 g
s
.735 .735 .851 r
.4036 .56116 m .37452 .59565 L .41431 .60994 L p F P
0 g
s
.528 .526 .797 r
.31178 .58974 m .33715 .56825 L .30718 .53124 L p F P
0 g
s
.481 0 0 r
.50398 .40072 m .46993 .38394 L .45708 .38323 L closepath p F P
0 g
s
.988 .807 .417 r
.50398 .40072 m .51322 .45226 L .51553 .43999 L closepath p F P
0 g
s
.559 .096 .111 r
.50398 .40072 m .45708 .38323 L .44646 .38748 L closepath p F P
0 g
s
.549 .283 .465 r
.32278 .43113 m .37488 .41806 L .38024 .39518 L p F P
0 g
s
.604 .334 .482 r
.43938 .39622 m .38024 .39518 L .37488 .41806 L p F P
0 g
s
.566 .208 .32 r
.38024 .39518 m .43938 .39622 L .44646 .38748 L p F P
0 g
s
.979 .857 .65 r
.50398 .40072 m .50646 .46126 L .51322 .45226 L closepath p F P
0 g
s
.575 .46 .685 r
.32742 .46718 m .28861 .48956 L .30718 .53124 L p F P
0 g
s
.514 .343 .586 r
.28861 .48956 m .32742 .46718 L .32278 .43113 L p F P
0 g
s
.596 .4 .587 r
.37488 .41806 m .32278 .43113 L .32742 .46718 L p F P
0 g
s
.842 .766 .778 r
.48576 .52511 m .49599 .46587 L .48307 .46546 L p F P
0 g
s
.842 .766 .778 r
.48307 .46546 m .4615 .52477 L .48576 .52511 L p F P
0 g
s
.678 .642 .807 r
.37452 .59565 m .4036 .56116 L .37059 .53677 L p F P
0 g
s
.678 .642 .807 r
.37059 .53677 m .33715 .56825 L .37452 .59565 L p F P
0 g
s
.769 .712 .799 r
.43868 .57407 m .4615 .52477 L .43546 .5149 L p F P
0 g
s
.769 .712 .799 r
.43546 .5149 m .4036 .56116 L .43868 .57407 L p F P
0 g
s
.598 .246 .344 r
.50398 .40072 m .44646 .38748 L .43938 .39622 L closepath p F P
0 g
s
.911 .816 .74 r
.50398 .40072 m .49599 .46587 L .50646 .46126 L closepath p F P
0 g
s
.627 .555 .754 r
.34403 .504 m .30718 .53124 L .33715 .56825 L p F P
0 g
s
.575 .46 .685 r
.30718 .53124 m .34403 .504 L .32742 .46718 L p F P
0 g
s
.627 .555 .754 r
.33715 .56825 m .37059 .53677 L .34403 .504 L p F P
0 g
s
.596 .4 .587 r
.32742 .46718 m .37863 .44487 L .37488 .41806 L p F P
0 g
s
.604 .334 .482 r
.37488 .41806 m .43674 .40846 L .43938 .39622 L p F P
0 g
s
.635 .428 .584 r
.43674 .40846 m .37488 .41806 L .37863 .44487 L p F P
0 g
s
.625 .355 .488 r
.50398 .40072 m .43938 .39622 L .43674 .40846 L closepath p F P
0 g
s
.636 .489 .666 r
.37863 .44487 m .32742 .46718 L .34403 .504 L p F P
0 g
s
.784 .698 .769 r
.4615 .52477 m .48307 .46546 L .46925 .46004 L p F P
0 g
s
.784 .698 .769 r
.46925 .46004 m .43546 .5149 L .4615 .52477 L p F P
0 g
s
.845 .754 .762 r
.50398 .40072 m .48307 .46546 L .49599 .46587 L closepath p F P
0 g
s
.718 .637 .767 r
.4036 .56116 m .43546 .5149 L .41096 .49661 L p F P
0 g
s
.718 .637 .767 r
.41096 .49661 m .37059 .53677 L .4036 .56116 L p F P
0 g
s
.635 .428 .584 r
.37863 .44487 m .43893 .42273 L .43674 .40846 L p F P
0 g
s
.651 .439 .583 r
.50398 .40072 m .43674 .40846 L .43893 .42273 L closepath p F P
0 g
s
.675 .565 .724 r
.39117 .47222 m .34403 .504 L .37059 .53677 L p F P
0 g
s
.636 .489 .666 r
.34403 .504 m .39117 .47222 L .37863 .44487 L p F P
0 g
s
.791 .692 .755 r
.50398 .40072 m .46925 .46004 L .48307 .46546 L closepath p F P
0 g
s
.666 .503 .654 r
.43893 .42273 m .37863 .44487 L .39117 .47222 L p F P
0 g
s
.675 .565 .724 r
.37059 .53677 m .41096 .49661 L .39117 .47222 L p F P
0 g
s
.738 .633 .743 r
.43546 .5149 m .46925 .46004 L .45625 .45023 L p F P
0 g
s
.738 .633 .743 r
.45625 .45023 m .41096 .49661 L .43546 .5149 L p F P
0 g
s
.746 .631 .732 r
.55161 .35131 m .50398 .40072 L .53873 .34137 L closepath p F P
0 g
s
.71 .571 .697 r
.56215 .36425 m .50398 .40072 L .55161 .35131 L closepath p F P
0 g
s
.738 .633 .743 r
.59689 .30494 m .55161 .35131 L .53873 .34137 L p F P
0 g
s
.699 .57 .705 r
.55161 .35131 m .59689 .30494 L .61673 .32926 L p F P
0 g
s
.699 .57 .705 r
.61673 .32926 m .56215 .36425 L .55161 .35131 L p F P
0 g
s
.679 .509 .649 r
.56914 .37868 m .50398 .40072 L .56215 .36425 L closepath p F P
0 g
s
.666 .503 .655 r
.56215 .36425 m .61673 .32926 L .63006 .35632 L p F P
0 g
s
.666 .503 .655 r
.63006 .35632 m .56914 .37868 L .56215 .36425 L p F P
0 g
s
.666 .503 .654 r
.39117 .47222 m .44571 .43725 L .43893 .42273 L p F P
0 g
s
.679 .509 .649 r
.50398 .40072 m .43893 .42273 L .44571 .43725 L closepath p F P
0 g
s
.738 .633 .743 r
.53873 .34137 m .57277 .2861 L .59689 .30494 L p F P
0 g
s
.718 .637 .766 r
.6381 .26393 m .59689 .30494 L .57277 .2861 L p F P
0 g
s
.676 .566 .723 r
.59689 .30494 m .6381 .26393 L .66495 .29678 L p F P
0 g
s
.676 .566 .723 r
.66495 .29678 m .61673 .32926 L .59689 .30494 L p F P
0 g
s
.637 .491 .667 r
.61673 .32926 m .66495 .29678 L .6832 .33326 L p F P
0 g
s
.637 .491 .667 r
.6832 .33326 m .63006 .35632 L .61673 .32926 L p F P
0 g
s
.746 .631 .732 r
.50398 .40072 m .45625 .45023 L .46925 .46004 L closepath p F P
0 g
s
.71 .571 .697 r
.50398 .40072 m .44571 .43725 L .45625 .45023 L closepath p F P
0 g
s
.625 .355 .488 r
.56959 .40528 m .50398 .40072 L .57173 .39292 L closepath p F P
0 g
s
.598 .246 .344 r
.56292 .41429 m .50398 .40072 L .56959 .40528 L closepath p F P
0 g
s
.559 .096 .111 r
.55246 .41879 m .50398 .40072 L .56292 .41429 L closepath p F P
0 g
s
.481 0 0 r
.53944 .4182 m .50398 .40072 L .55246 .41879 L closepath p F P
0 g
s
.362 0 0 r
.52545 .41251 m .50398 .40072 L .53944 .4182 L closepath p F P
0 g
s
0 .215 .679 r
.51223 .4024 m .50398 .40072 L .52545 .41251 L closepath p F P
0 g
s
.988 .807 .417 r
.49445 .34755 m .50398 .40072 L .49197 .35988 L closepath p F P
0 g
s
.979 .857 .65 r
.50145 .33881 m .50398 .40072 L .49445 .34755 L closepath p F P
0 g
s
.911 .816 .74 r
.51208 .33468 m .50398 .40072 L .50145 .33881 L closepath p F P
0 g
s
.845 .754 .762 r
.52502 .33558 m .50398 .40072 L .51208 .33468 L closepath p F P
0 g
s
.791 .692 .755 r
.53873 .34137 m .50398 .40072 L .52502 .33558 L closepath p F P
0 g
s
.651 .439 .583 r
.57173 .39292 m .50398 .40072 L .56914 .37868 L closepath p F P
0 g
s
0 .062 .608 r
.50142 .38912 m .50398 .40072 L .51223 .4024 L closepath p F P
0 g
s
.825 .56 .009 r
.49197 .35988 m .50398 .40072 L .49438 .37433 L closepath p F P
0 g
s
0 0 .381 r
.49438 .37433 m .50398 .40072 L .50142 .38912 L closepath p F P
0 g
s
.784 .698 .769 r
.57277 .2861 m .53873 .34137 L .52502 .33558 L p F P
0 g
s
.699 .57 .705 r
.44571 .43725 m .39117 .47222 L .41096 .49661 L p F P
0 g
s
.699 .57 .705 r
.41096 .49661 m .45625 .45023 L .44571 .43725 L p F P
0 g
s
.635 .428 .585 r
.56914 .37868 m .63006 .35632 L .63531 .38308 L p F P
0 g
s
.635 .428 .585 r
.63531 .38308 m .57173 .39292 L .56914 .37868 L p F P
0 g
s
.784 .698 .769 r
.52502 .33558 m .54707 .2749 L .57277 .2861 L p F P
0 g
s
.768 .71 .797 r
.60561 .23829 m .57277 .2861 L .54707 .2749 L p F P
0 g
s
.718 .637 .766 r
.57277 .2861 m .60561 .23829 L .6381 .26393 L p F P
0 g
s
.68 .639 .803 r
.67418 .22981 m .6381 .26393 L .60561 .23829 L p F P
0 g
s
.631 .556 .752 r
.6381 .26393 m .67418 .22981 L .70494 .26743 L p F P
0 g
s
.631 .556 .752 r
.70494 .26743 m .66495 .29678 L .6381 .26393 L p F P
0 g
s
.598 .404 .589 r
.63006 .35632 m .6832 .33326 L .69073 .36938 L p F P
0 g
s
.598 .404 .589 r
.69073 .36938 m .63531 .38308 L .63006 .35632 L p F P
0 g
s
.842 .766 .778 r
.54707 .2749 m .52502 .33558 L .51208 .33468 L p F P
0 g
s
.583 .467 .687 r
.66495 .29678 m .70494 .26743 L .72606 .30911 L p F P
0 g
s
.583 .467 .687 r
.72606 .30911 m .6832 .33326 L .66495 .29678 L p F P
0 g
s
.604 .336 .483 r
.57173 .39292 m .63531 .38308 L .63173 .40644 L p F P
0 g
s
.604 .336 .483 r
.63173 .40644 m .56959 .40528 L .57173 .39292 L p F P
0 g
s
.768 .71 .797 r
.54707 .2749 m .57101 .22277 L .60561 .23829 L p F P
0 g
s
.734 .727 .844 r
.63708 .2003 m .60561 .23829 L .57101 .22277 L p F P
0 g
s
.68 .639 .803 r
.60561 .23829 m .63708 .2003 L .67418 .22981 L p F P
0 g
s
.912 .835 .756 r
.52272 .27275 m .51208 .33468 L .50145 .33881 L p F P
0 g
s
.842 .766 .778 r
.51208 .33468 m .52272 .27275 L .54707 .2749 L p F P
0 g
s
.831 .79 .813 r
.57101 .22277 m .54707 .2749 L .52272 .27275 L p F P
0 g
s
.527 .358 .595 r
.6832 .33326 m .72606 .30911 L .73508 .35034 L p F P
0 g
s
.527 .358 .595 r
.73508 .35034 m .69073 .36938 L .6832 .33326 L p F P
0 g
s
.567 .21 .322 r
.56959 .40528 m .63173 .40644 L .61957 .42358 L p F P
0 g
s
.567 .21 .322 r
.61957 .42358 m .56292 .41429 L .56959 .40528 L p F P
0 g
s
.553 .29 .471 r
.63531 .38308 m .69073 .36938 L .68644 .40101 L p F P
0 g
s
.553 .29 .471 r
.68644 .40101 m .63173 .40644 L .63531 .38308 L p F P
0 g
s
.608 .635 .853 r
.70468 .20334 m .67418 .22981 L .63708 .2003 L p F P
0 g
s
.551 .534 .789 r
.67418 .22981 m .70468 .20334 L .73583 .2414 L p F P
0 g
s
.551 .534 .789 r
.73583 .2414 m .70494 .26743 L .67418 .22981 L p F P
0 g
s
.486 .422 .71 r
.70494 .26743 m .73583 .2414 L .75736 .28344 L p F P
0 g
s
.486 .422 .71 r
.75736 .28344 m .72606 .30911 L .70494 .26743 L p F P
0 g
s
.981 .882 .657 r
.50261 .28008 m .50145 .33881 L .49445 .34755 L p F P
0 g
s
.912 .835 .756 r
.50145 .33881 m .50261 .28008 L .52272 .27275 L p F P
0 g
s
.506 .026 .05 r
.56292 .41429 m .61957 .42358 L .60006 .43227 L p F P
0 g
s
.506 .026 .05 r
.60006 .43227 m .55246 .41879 L .56292 .41429 L p F P
0 g
s
.831 .79 .813 r
.52272 .27275 m .53816 .21934 L .57101 .22277 L p F P
0 g
s
.801 .828 .873 r
.59764 .18219 m .57101 .22277 L .53816 .21934 L p F P
0 g
s
.734 .727 .844 r
.57101 .22277 m .59764 .18219 L .63708 .2003 L p F P
0 g
s
.663 .743 .909 r
.66727 .17336 m .63708 .2003 L .59764 .18219 L p F P
0 g
s
.608 .635 .853 r
.63708 .2003 m .66727 .17336 L .70468 .20334 L p F P
0 g
s
.908 .877 .794 r
.53816 .21934 m .52272 .27275 L .50261 .28008 L p F P
0 g
s
.448 .2 .444 r
.69073 .36938 m .73508 .35034 L .73067 .38647 L p F P
0 g
s
.448 .2 .444 r
.73067 .38647 m .68644 .40101 L .69073 .36938 L p F P
0 g
s
.394 .272 .593 r
.72606 .30911 m .75736 .28344 L .76676 .32494 L p F P
0 g
s
.394 .272 .593 r
.76676 .32494 m .73508 .35034 L .72606 .30911 L p F P
0 g
s
.964 .809 .377 r
.48925 .29625 m .49445 .34755 L .49197 .35988 L p F P
0 g
s
.981 .882 .657 r
.49445 .34755 m .48925 .29625 L .50261 .28008 L p F P
0 g
s
.487 .12 .268 r
.63173 .40644 m .68644 .40101 L .67047 .42433 L p F P
0 g
s
.487 .12 .268 r
.67047 .42433 m .61957 .42358 L .63173 .40644 L p F P
0 g
s
.381 0 0 r
.55246 .41879 m .60006 .43227 L .57546 .43122 L p F P
0 g
s
.381 0 0 r
.57546 .43122 m .53944 .4182 L .55246 .41879 L p F P
0 g
s
.719 .489 0 r
.48447 .31949 m .49197 .35988 L .49438 .37433 L p F P
0 g
s
.964 .809 .377 r
.49197 .35988 m .48447 .31949 L .48925 .29625 L p F P
0 g
s
0 .362 .702 r
.53944 .4182 m .57546 .43122 L .54877 .42036 L p F P
0 g
s
0 .362 .702 r
.54877 .42036 m .52545 .41251 L .53944 .4182 L p F P
0 g
s
.48 .61 .903 r
.72983 .18442 m .70468 .20334 L .66727 .17336 L p F P
0 g
s
.417 .487 .824 r
.70468 .20334 m .72983 .18442 L .75769 .21843 L p F P
0 g
s
.417 .487 .824 r
.75769 .21843 m .73583 .2414 L .70468 .20334 L p F P
0 g
s
.801 .828 .873 r
.53816 .21934 m .56019 .17779 L .59764 .18219 L p F P
0 g
s
.717 .87 .953 r
.62759 .15482 m .59764 .18219 L .56019 .17779 L p F P
0 g
s
.663 .743 .909 r
.59764 .18219 m .62759 .15482 L .66727 .17336 L p F P
0 g
s
.323 .34 .724 r
.73583 .2414 m .75769 .21843 L .77703 .2559 L p F P
0 g
s
.323 .34 .724 r
.77703 .2559 m .75736 .28344 L .73583 .2414 L p F P
0 g
s
.97 .932 .665 r
.51092 .22872 m .50261 .28008 L .48925 .29625 L p F P
0 g
s
.908 .877 .794 r
.50261 .28008 m .51092 .22872 L .53816 .21934 L p F P
0 g
s
.719 .489 0 r
.49438 .37433 m .48905 .34701 L .48447 .31949 L p F P
0 g
s
0 0 .49 r
.48905 .34701 m .49438 .37433 L .50142 .38912 L p F P
0 g
s
.876 .944 .856 r
.56019 .17779 m .53816 .21934 L .51092 .22872 L p F P
0 g
s
0 .326 .787 r
.52545 .41251 m .54877 .42036 L .52337 .40093 L p F P
0 g
s
0 .326 .787 r
.52337 .40093 m .51223 .4024 L .52545 .41251 L p F P
0 g
s
.229 .022 .377 r
.73508 .35034 m .76676 .32494 L .76268 .36121 L p F P
0 g
s
.229 .022 .377 r
.76268 .36121 m .73067 .38647 L .73508 .35034 L p F P
0 g
s
0 .168 .703 r
.50258 .37538 m .50142 .38912 L .51223 .4024 L p F P
0 g
s
0 0 .49 r
.50142 .38912 m .50258 .37538 L .48905 .34701 L p F P
0 g
s
.356 0 0 r
.61957 .42358 m .67047 .42433 L .64438 .43622 L p F P
0 g
s
.356 0 0 r
.64438 .43622 m .60006 .43227 L .61957 .42358 L p F P
0 g
s
0 .168 .703 r
.51223 .4024 m .52337 .40093 L .50258 .37538 L p F P
0 g
s
.3 0 .147 r
.68644 .40101 m .73067 .38647 L .71289 .41312 L p F P
0 g
s
.3 0 .147 r
.71289 .41312 m .67047 .42433 L .68644 .40101 L p F P
0 g
s
.517 .733 .972 r
.69649 .15756 m .66727 .17336 L .62759 .15482 L p F P
0 g
s
.48 .61 .903 r
.66727 .17336 m .69649 .15756 L .72983 .18442 L p F P
0 g
s
.158 .12 .562 r
.75736 .28344 m .77703 .2559 L .78558 .29272 L p F P
0 g
s
.158 .12 .562 r
.78558 .29272 m .76676 .32494 L .75736 .28344 L p F P
0 g
s
.841 .765 .254 r
.49275 .25023 m .48925 .29625 L .48447 .31949 L p F P
0 g
s
.97 .932 .665 r
.48925 .29625 m .49275 .25023 L .51092 .22872 L p F P
0 g
s
.104 0 0 r
.60006 .43227 m .64438 .43622 L .61108 .43483 L p F P
0 g
s
.104 0 0 r
.61108 .43483 m .57546 .43122 L .60006 .43227 L p F P
0 g
s
.876 .944 .856 r
.51092 .22872 m .52914 .18805 L .56019 .17779 L p F P
0 g
s
.719 .984 .896 r
.59003 .15005 m .56019 .17779 L .52914 .18805 L p F P
0 g
s
.717 .87 .953 r
.56019 .17779 m .59003 .15005 L .62759 .15482 L p F P
0 g
s
.499 .85 .993 r
.66127 .14089 m .62759 .15482 L .59003 .15005 L p F P
0 g
s
.517 .733 .972 r
.62759 .15482 m .66127 .14089 L .69649 .15756 L p F P
0 g
s
.854 .962 .627 r
.52914 .18805 m .51092 .22872 L .49275 .25023 L p F P
0 g
s
0 0 0 r
.73067 .38647 m .76268 .36121 L .74511 .38784 L p F P
0 g
s
0 0 0 r
.74511 .38784 m .71289 .41312 L .73067 .38647 L p F P
0 g
s
0 0 .215 r
.76676 .32494 m .78558 .29272 L .78214 .32472 L p F P
0 g
s
0 0 .215 r
.78214 .32472 m .76268 .36121 L .76676 .32494 L p F P
0 g
s
0 0 0 r
.67047 .42433 m .71289 .41312 L .68336 .42669 L p F P
0 g
s
0 0 0 r
.68336 .42669 m .64438 .43622 L .67047 .42433 L p F P
0 g
s
.288 .543 .919 r
.75046 .17216 m .72983 .18442 L .69649 .15756 L p F P
0 g
s
.225 .403 .83 r
.72983 .18442 m .75046 .17216 L .77158 .19794 L p F P
0 g
s
.225 .403 .83 r
.77158 .19794 m .75769 .21843 L .72983 .18442 L p F P
0 g
s
.841 .765 .254 r
.48447 .31949 m .48623 .2816 L .49275 .25023 L p F P
0 g
s
0 0 .306 r
.48623 .2816 m .48447 .31949 L .48905 .34701 L p F P
0 g
s
.092 .215 .7 r
.75769 .21843 m .77158 .19794 L .78626 .22623 L p F P
0 g
s
.092 .215 .7 r
.78626 .22623 m .77703 .2559 L .75769 .21843 L p F P
0 g
s
.106 .584 .911 r
.57546 .43122 m .61108 .43483 L .57464 .41992 L p F P
0 g
s
.106 .584 .911 r
.57464 .41992 m .54877 .42036 L .57546 .43122 L p F P
0 g
s
.28 .654 .969 r
.72526 .15179 m .69649 .15756 L .66127 .14089 L p F P
0 g
s
.288 .543 .919 r
.69649 .15756 m .72526 .15179 L .75046 .17216 L p F P
0 g
s
0 0 .464 r
.77703 .2559 m .78626 .22623 L .79278 .25387 L p F P
0 g
s
0 0 .464 r
.79278 .25387 m .78558 .29272 L .77703 .2559 L p F P
0 g
s
0 .096 .637 r
.49254 .31912 m .48905 .34701 L .50258 .37538 L p F P
0 g
s
0 0 .306 r
.48905 .34701 m .49254 .31912 L .48623 .2816 L p F P
0 g
s
.719 .984 .896 r
.52914 .18805 m .55899 .16007 L .59003 .15005 L p F P
0 g
s
.26 .758 .701 r
.62812 .1365 m .59003 .15005 L .55899 .16007 L p F P
0 g
s
.499 .85 .993 r
.59003 .15005 m .62812 .1365 L .66127 .14089 L p F P
0 g
s
.152 .491 .904 r
.54877 .42036 m .57464 .41992 L .53979 .39319 L p F P
0 g
s
.152 .491 .904 r
.53979 .39319 m .52337 .40093 L .54877 .42036 L p F P
0 g
s
.854 .962 .627 r
.49275 .25023 m .50844 .21229 L .52914 .18805 L p F P
0 g
s
0 0 .02 r
.50844 .21229 m .49275 .25023 L .48623 .2816 L p F P
0 g
s
0 0 0 r
.55899 .16007 m .52914 .18805 L .50844 .21229 L p F P
0 g
s
.087 .332 .807 r
.51116 .35803 m .50258 .37538 L .52337 .40093 L p F P
0 g
s
0 .096 .637 r
.50258 .37538 m .51116 .35803 L .49254 .31912 L p F P
0 g
s
.703 .863 .454 r
.76268 .36121 m .78214 .32472 L .76673 .34799 L p F P
0 g
s
.703 .863 .454 r
.76673 .34799 m .74511 .38784 L .76268 .36121 L p F P
0 g
s
.087 .332 .807 r
.52337 .40093 m .53979 .39319 L .51116 .35803 L p F P
0 g
s
.368 .816 .944 r
.64438 .43622 m .68336 .42669 L .64535 .42496 L p F P
0 g
s
.368 .816 .944 r
.64535 .42496 m .61108 .43483 L .64438 .43622 L p F P
0 g
s
.132 .666 .859 r
.6988 .13915 m .66127 .14089 L .62812 .1365 L p F P
0 g
s
.28 .654 .969 r
.66127 .14089 m .6988 .13915 L .72526 .15179 L p F P
0 g
s
.604 .949 .808 r
.71289 .41312 m .74511 .38784 L .71564 .40124 L p F P
0 g
s
.604 .949 .808 r
.71564 .40124 m .68336 .42669 L .71289 .41312 L p F P
0 g
s
0 0 0 r
.78558 .29272 m .79278 .25387 L .79025 .27767 L p F P
0 g
s
0 0 0 r
.79025 .27767 m .78214 .32472 L .78558 .29272 L p F P
0 g
s
.016 .002 .495 r
.5011 .24805 m .48623 .2816 L .49254 .31912 L p F P
0 g
s
0 0 .02 r
.48623 .2816 m .5011 .24805 L .50844 .21229 L p F P
0 g
s
0 0 0 r
.50844 .21229 m .53844 .18423 L .55899 .16007 L p F P
0 g
s
.26 .758 .701 r
.55899 .16007 m .60092 .14525 L .62812 .1365 L p F P
0 g
s
.166 0 0 r
.60092 .14525 m .55899 .16007 L .53844 .18423 L p F P
0 g
s
.45 .735 .988 r
.61108 .43483 m .64535 .42496 L .6035 .40765 L p F P
0 g
s
.45 .735 .988 r
.6035 .40765 m .57464 .41992 L .61108 .43483 L p F P
0 g
s
.132 .666 .859 r
.62812 .1365 m .67408 .13583 L .6988 .13915 L p F P
0 g
s
.189 0 0 r
.67408 .13583 m .62812 .1365 L .60092 .14525 L p F P
0 g
s
.087 .447 .881 r
.76793 .16492 m .75046 .17216 L .72526 .15179 L p F P
0 g
s
.029 .302 .794 r
.75046 .17216 m .76793 .16492 L .77945 .17897 L p F P
0 g
s
.029 .302 .794 r
.77945 .17897 m .77158 .19794 L .75046 .17216 L p F P
0 g
s
.103 0 .278 r
.53844 .18423 m .50844 .21229 L .5011 .24805 L p F P
0 g
s
0 .082 .635 r
.77158 .19794 m .77945 .17897 L .78746 .19433 L p F P
0 g
s
0 .082 .635 r
.78746 .19433 m .78626 .22623 L .77158 .19794 L p F P
0 g
s
.868 .981 .844 r
.74511 .38784 m .76673 .34799 L .7408 .35942 L p F P
0 g
s
.868 .981 .844 r
.7408 .35942 m .71564 .40124 L .74511 .38784 L p F P
0 g
s
.938 .933 .577 r
.78214 .32472 m .79025 .27767 L .77874 .29474 L p F P
0 g
s
.938 .933 .577 r
.77874 .29474 m .76673 .34799 L .78214 .32472 L p F P
0 g
s
.036 .524 .881 r
.75423 .15381 m .72526 .15179 L .6988 .13915 L p F P
0 g
s
.087 .447 .881 r
.72526 .15179 m .75423 .15381 L .76793 .16492 L p F P
0 g
s
.692 .901 .971 r
.68336 .42669 m .71564 .40124 L .67753 .3992 L p F P
0 g
s
.692 .901 .971 r
.67753 .3992 m .64535 .42496 L .68336 .42669 L p F P
0 g
s
0 0 .332 r
.78626 .22623 m .78746 .19433 L .791 .20924 L p F P
0 g
s
0 0 .332 r
.791 .20924 m .79278 .25387 L .78626 .22623 L p F P
0 g
s
.239 .285 .709 r
.50854 .29112 m .49254 .31912 L .51116 .35803 L p F P
0 g
s
.016 .002 .495 r
.49254 .31912 m .50854 .29112 L .5011 .24805 L p F P
0 g
s
.425 .602 .92 r
.57464 .41992 m .6035 .40765 L .5633 .37665 L p F P
0 g
s
.425 .602 .92 r
.5633 .37665 m .53979 .39319 L .57464 .41992 L p F P
0 g
s
.036 .524 .881 r
.6988 .13915 m .73994 .14695 L .75423 .15381 L p F P
0 g
s
.161 0 0 r
.73994 .14695 m .6988 .13915 L .67408 .13583 L p F P
0 g
s
.357 .461 .83 r
.53017 .33599 m .51116 .35803 L .53979 .39319 L p F P
0 g
s
.239 .285 .709 r
.51116 .35803 m .53017 .33599 L .50854 .29112 L p F P
0 g
s
.836 .707 .175 r
.79278 .25387 m .791 .20924 L .78962 .22192 L p F P
0 g
s
.836 .707 .175 r
.78962 .22192 m .79025 .27767 L .79278 .25387 L p F P
0 g
s
.357 .461 .83 r
.53979 .39319 m .5633 .37665 L .53017 .33599 L p F P
0 g
s
.166 0 0 r
.53844 .18423 m .58316 .16656 L .60092 .14525 L p F P
0 g
s
.417 .01 .157 r
.65404 .14241 m .60092 .14525 L .58316 .16656 L p F P
0 g
s
.189 0 0 r
.60092 .14525 m .65404 .14241 L .67408 .13583 L p F P
0 g
s
.334 .215 .565 r
.53138 .2201 m .5011 .24805 L .50854 .29112 L p F P
0 g
s
.103 0 .278 r
.5011 .24805 m .53138 .2201 L .53844 .18423 L p F P
0 g
s
.392 .126 .387 r
.58316 .16656 m .53844 .18423 L .53138 .2201 L p F P
0 g
s
.924 .916 .79 r
.76673 .34799 m .77874 .29474 L .75943 .30282 L p F P
0 g
s
.924 .916 .79 r
.75943 .30282 m .7408 .35942 L .76673 .34799 L p F P
0 g
s
.647 .761 .932 r
.64535 .42496 m .67753 .3992 L .63543 .38143 L p F P
0 g
s
.647 .761 .932 r
.63543 .38143 m .6035 .40765 L .64535 .42496 L p F P
0 g
s
.806 .86 .889 r
.71564 .40124 m .7408 .35942 L .70723 .35716 L p F P
0 g
s
.806 .86 .889 r
.70723 .35716 m .67753 .3992 L .71564 .40124 L p F P
0 g
s
.395 0 0 r
.72673 .14518 m .67408 .13583 L .65404 .14241 L p F P
0 g
s
.161 0 0 r
.67408 .13583 m .72673 .14518 L .73994 .14695 L p F P
0 g
s
.985 .902 .594 r
.79025 .27767 m .78962 .22192 L .78342 .23084 L p F P
0 g
s
.985 .902 .594 r
.78342 .23084 m .77874 .29474 L .79025 .27767 L p F P
0 g
s
.451 .397 .706 r
.5392 .26346 m .50854 .29112 L .53017 .33599 L p F P
0 g
s
.334 .215 .565 r
.50854 .29112 m .5392 .26346 L .53138 .2201 L p F P
0 g
s
.59 .64 .868 r
.6035 .40765 m .63543 .38143 L .59485 .34993 L p F P
0 g
s
.59 .64 .868 r
.59485 .34993 m .5633 .37665 L .6035 .40765 L p F P
0 g
s
.392 .126 .387 r
.53138 .2201 m .57738 .19822 L .58316 .16656 L p F P
0 g
s
.522 .239 .427 r
.64121 .15835 m .58316 .16656 L .57738 .19822 L p F P
0 g
s
.417 .01 .157 r
.58316 .16656 m .64121 .15835 L .65404 .14241 L p F P
0 g
s
0 .38 .836 r
.78411 .16032 m .76793 .16492 L .75423 .15381 L closepath p F P
0 g
s
0 .236 .754 r
.78411 .16032 m .77945 .17897 L .76793 .16492 L closepath p F P
0 g
s
.52 .123 .228 r
.71618 .14877 m .65404 .14241 L .64121 .15835 L p F P
0 g
s
.395 0 0 r
.65404 .14241 m .71618 .14877 L .72673 .14518 L p F P
0 g
s
0 .004 .58 r
.78411 .16032 m .78746 .19433 L .77945 .17897 L closepath p F P
0 g
s
.499 .325 .576 r
.57738 .19822 m .53138 .2201 L .5392 .26346 L p F P
0 g
s
0 .434 .802 r
.78411 .16032 m .75423 .15381 L .73994 .14695 L closepath p F P
0 g
s
.844 .817 .823 r
.7408 .35942 m .75943 .30282 L .73449 .30069 L p F P
0 g
s
.844 .817 .823 r
.73449 .30069 m .70723 .35716 L .7408 .35942 L p F P
0 g
s
0 0 .251 r
.78411 .16032 m .791 .20924 L .78746 .19433 L closepath p F P
0 g
s
.935 .87 .75 r
.77874 .29474 m .78342 .23084 L .77308 .23486 L p F P
0 g
s
.935 .87 .75 r
.77308 .23486 m .75943 .30282 L .77874 .29474 L p F P
0 g
s
.528 .526 .797 r
.56127 .30875 m .53017 .33599 L .5633 .37665 L p F P
0 g
s
.451 .397 .706 r
.53017 .33599 m .56127 .30875 L .5392 .26346 L p F P
0 g
s
.735 .744 .859 r
.67753 .3992 m .70723 .35716 L .67012 .34109 L p F P
0 g
s
.735 .744 .859 r
.67012 .34109 m .63543 .38143 L .67753 .3992 L p F P
0 g
s
.528 .526 .797 r
.5633 .37665 m .59485 .34993 L .56127 .30875 L p F P
0 g
s
.287 0 0 r
.78411 .16032 m .73994 .14695 L .72673 .14518 L closepath p F P
0 g
s
.901 .736 .234 r
.78411 .16032 m .78962 .22192 L .791 .20924 L closepath p F P
0 g
s
.467 0 0 r
.78411 .16032 m .72673 .14518 L .71618 .14877 L closepath p F P
0 g
s
.522 .239 .427 r
.57738 .19822 m .63737 .18195 L .64121 .15835 L p F P
0 g
s
.582 .292 .441 r
.7096 .15737 m .64121 .15835 L .63737 .18195 L p F P
0 g
s
.52 .123 .228 r
.64121 .15835 m .7096 .15737 L .71618 .14877 L p F P
0 g
s
.992 .881 .593 r
.78411 .16032 m .78342 .23084 L .78962 .22192 L closepath p F P
0 g
s
.567 .453 .683 r
.5847 .23649 m .5392 .26346 L .56127 .30875 L p F P
0 g
s
.499 .325 .576 r
.5392 .26346 m .5847 .23649 L .57738 .19822 L p F P
0 g
s
.582 .379 .572 r
.63737 .18195 m .57738 .19822 L .5847 .23649 L p F P
0 g
s
.858 .791 .784 r
.75943 .30282 m .77308 .23486 L .75981 .23344 L p F P
0 g
s
.858 .791 .784 r
.75981 .23344 m .73449 .30069 L .75943 .30282 L p F P
0 g
s
.675 .646 .813 r
.63543 .38143 m .67012 .34109 L .63428 .313 L p F P
0 g
s
.675 .646 .813 r
.63428 .313 m .59485 .34993 L .63543 .38143 L p F P
0 g
s
.774 .725 .807 r
.70723 .35716 m .73449 .30069 L .70697 .28837 L p F P
0 g
s
.774 .725 .807 r
.70697 .28837 m .67012 .34109 L .70723 .35716 L p F P
0 g
s
.559 .166 .254 r
.78411 .16032 m .71618 .14877 L .7096 .15737 L closepath p F P
0 g
s
.936 .849 .732 r
.78411 .16032 m .77308 .23486 L .78342 .23084 L closepath p F P
0 g
s
.622 .553 .756 r
.60449 .27652 m .56127 .30875 L .59485 .34993 L p F P
0 g
s
.567 .453 .683 r
.56127 .30875 m .60449 .27652 L .5847 .23649 L p F P
0 g
s
.622 .553 .756 r
.59485 .34993 m .63428 .313 L .60449 .27652 L p F P
0 g
s
.582 .379 .572 r
.5847 .23649 m .64321 .2104 L .63737 .18195 L p F P
0 g
s
.624 .406 .567 r
.70784 .16999 m .63737 .18195 L .64321 .2104 L p F P
0 g
s
.582 .292 .441 r
.63737 .18195 m .70784 .16999 L .7096 .15737 L p F P
0 g
s
.606 .314 .447 r
.78411 .16032 m .7096 .15737 L .70784 .16999 L closepath p F P
0 g
s
.628 .48 .662 r
.64321 .2104 m .5847 .23649 L .60449 .27652 L p F P
0 g
s
.793 .712 .775 r
.73449 .30069 m .75981 .23344 L .74522 .22667 L p F P
0 g
s
.793 .712 .775 r
.74522 .22667 m .70697 .28837 L .73449 .30069 L p F P
0 g
s
.863 .778 .767 r
.78411 .16032 m .75981 .23344 L .77308 .23486 L closepath p F P
0 g
s
.719 .643 .772 r
.67012 .34109 m .70697 .28837 L .68037 .2673 L p F P
0 g
s
.719 .643 .772 r
.68037 .2673 m .63428 .313 L .67012 .34109 L p F P
0 g
s
.624 .406 .567 r
.64321 .2104 m .71119 .18512 L .70784 .16999 L p F P
0 g
s
.641 .418 .563 r
.78411 .16032 m .70784 .16999 L .71119 .18512 L closepath p F P
0 g
s
.672 .564 .725 r
.65816 .24013 m .60449 .27652 L .63428 .313 L p F P
0 g
s
.628 .48 .662 r
.60449 .27652 m .65816 .24013 L .64321 .2104 L p F P
0 g
s
.801 .706 .761 r
.78411 .16032 m .74522 .22667 L .75981 .23344 L closepath p F P
0 g
s
.661 .494 .648 r
.71119 .18512 m .64321 .2104 L .65816 .24013 L p F P
0 g
s
.672 .564 .725 r
.63428 .313 m .68037 .2673 L .65816 .24013 L p F P
0 g
s
.741 .64 .747 r
.70697 .28837 m .74522 .22667 L .73112 .21536 L p F P
0 g
s
.741 .64 .747 r
.73112 .21536 m .68037 .2673 L .70697 .28837 L p F P
0 g
s
.661 .494 .648 r
.65816 .24013 m .71928 .2009 L .71119 .18512 L p F P
0 g
s
.674 .499 .641 r
.78411 .16032 m .71119 .18512 L .71928 .2009 L closepath p F P
0 g
s
.751 .638 .735 r
.78411 .16032 m .73112 .21536 L .74522 .22667 L closepath p F P
0 g
s
.71 .57 .696 r
.78411 .16032 m .71928 .2009 L .73112 .21536 L closepath p F P
0 g
s
.699 .569 .705 r
.71928 .2009 m .65816 .24013 L .68037 .2673 L p F P
0 g
s
.699 .569 .705 r
.68037 .2673 m .73112 .21536 L .71928 .2009 L p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.636054 0.257081 0.772109 0.603319 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0151059 1.01511 -0.144419 1.01511 [
[ 0 0 0 0 ]
[ 1 .67778 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .67778 L
0 .67778 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.655 .515 .681 r
.38568 .46558 m .3414 .47894 L .32998 .44245 L p F P
0 g
s
.655 .515 .681 r
.32998 .44245 m .37252 .42401 L .38568 .46558 L p F P
0 g
s
.682 .587 .743 r
.37252 .42401 m .32998 .44245 L .31165 .40845 L p F P
0 g
s
.702 .542 .668 r
.28061 .46331 m .32998 .44245 L .3414 .47894 L p F P
0 g
s
.725 .604 .721 r
.32998 .44245 m .28061 .46331 L .26695 .43808 L p F P
0 g
s
.725 .604 .721 r
.26695 .43808 m .31165 .40845 L .32998 .44245 L p F P
0 g
s
.702 .542 .668 r
.3414 .47894 m .28901 .49044 L .28061 .46331 L p F P
0 g
s
.727 .556 .659 r
.22572 .48615 m .28061 .46331 L .28901 .49044 L p F P
0 g
s
.748 .612 .708 r
.28061 .46331 m .22572 .48615 L .2184 .47269 L p F P
0 g
s
.748 .612 .708 r
.2184 .47269 m .26695 .43808 L .28061 .46331 L p F P
0 g
s
.682 .587 .743 r
.31165 .40845 m .35169 .3852 L .37252 .42401 L p F P
0 g
s
.712 .661 .798 r
.35169 .3852 m .31165 .40845 L .28843 .38069 L p F P
0 g
s
.754 .668 .767 r
.31165 .40845 m .26695 .43808 L .24955 .4176 L p F P
0 g
s
.754 .668 .767 r
.24955 .4176 m .28843 .38069 L .31165 .40845 L p F P
0 g
s
.775 .671 .748 r
.26695 .43808 m .2184 .47269 L .20903 .46185 L p F P
0 g
s
.775 .671 .748 r
.20903 .46185 m .24955 .4176 L .26695 .43808 L p F P
0 g
s
.626 .435 .603 r
.38966 .50541 m .34463 .5139 L .3414 .47894 L p F P
0 g
s
.626 .435 .603 r
.3414 .47894 m .38568 .46558 L .38966 .50541 L p F P
0 g
s
.682 .476 .6 r
.28901 .49044 m .3414 .47894 L .34463 .5139 L p F P
0 g
s
.682 .476 .6 r
.34463 .5139 m .29116 .51641 L .28901 .49044 L p F P
0 g
s
.712 .498 .598 r
.23015 .50065 m .28901 .49044 L .29116 .51641 L p F P
0 g
s
.727 .556 .659 r
.28901 .49044 m .23015 .50065 L .22572 .48615 L p F P
0 g
s
.575 .469 .696 r
.42111 .44994 m .38568 .46558 L .37252 .42401 L p F P
0 g
s
.575 .469 .696 r
.37252 .42401 m .40776 .40811 L .42111 .44994 L p F P
0 g
s
.609 .556 .77 r
.40776 .40811 m .37252 .42401 L .35169 .3852 L p F P
0 g
s
.609 .556 .77 r
.35169 .3852 m .38684 .36899 L .40776 .40811 L p F P
0 g
s
.638 .642 .838 r
.38684 .36899 m .35169 .3852 L .32541 .35338 L p F P
0 g
s
.712 .661 .798 r
.28843 .38069 m .32541 .35338 L .35169 .3852 L p F P
0 g
s
.739 .562 .655 r
.16742 .51024 m .22572 .48615 L .23015 .50065 L closepath p F P
0 g
s
.758 .615 .701 r
.16742 .51024 m .2184 .47269 L .22572 .48615 L closepath p F P
0 g
s
.785 .671 .739 r
.16742 .51024 m .20903 .46185 L .2184 .47269 L closepath p F P
0 g
s
.529 .363 .601 r
.42537 .48995 m .38966 .50541 L .38568 .46558 L p F P
0 g
s
.529 .363 .601 r
.38568 .46558 m .42111 .44994 L .42537 .48995 L p F P
0 g
s
.712 .498 .598 r
.29116 .51641 m .23116 .5145 L .23015 .50065 L p F P
0 g
s
.725 .508 .596 r
.16742 .51024 m .23015 .50065 L .23116 .5145 L closepath p F P
0 g
s
.792 .743 .808 r
.28843 .38069 m .24955 .4176 L .23036 .40426 L p F P
0 g
s
.812 .737 .781 r
.24955 .4176 m .20903 .46185 L .1987 .4549 L p F P
0 g
s
.812 .737 .781 r
.1987 .4549 m .23036 .40426 L .24955 .4176 L p F P
0 g
s
.749 .749 .852 r
.32541 .35338 m .28843 .38069 L .26282 .36236 L p F P
0 g
s
.792 .743 .808 r
.23036 .40426 m .26282 .36236 L .28843 .38069 L p F P
0 g
s
.662 .395 .505 r
.33915 .54338 m .28676 .53823 L .29116 .51641 L p F P
0 g
s
.662 .395 .505 r
.29116 .51641 m .34463 .5139 L .33915 .54338 L p F P
0 g
s
.7 .431 .513 r
.23116 .5145 m .29116 .51641 L .28676 .53823 L p F P
0 g
s
.821 .734 .769 r
.16742 .51024 m .1987 .4549 L .20903 .46185 L closepath p F P
0 g
s
.7 .431 .513 r
.28676 .53823 m .22861 .52608 L .23116 .5145 L p F P
0 g
s
.716 .446 .517 r
.16742 .51024 m .23116 .5145 L .22861 .52608 L closepath p F P
0 g
s
.589 .326 .487 r
.38385 .53902 m .33915 .54338 L .34463 .5139 L p F P
0 g
s
.589 .326 .487 r
.34463 .5139 m .38966 .50541 L .38385 .53902 L p F P
0 g
s
.449 .393 .703 r
.44795 .43176 m .42111 .44994 L .40776 .40811 L p F P
0 g
s
.449 .393 .703 r
.40776 .40811 m .43601 .39459 L .44795 .43176 L p F P
0 g
s
.492 .5 .793 r
.43601 .39459 m .40776 .40811 L .38684 .36899 L p F P
0 g
s
.966 .936 .643 r
.16742 .51024 m .17392 .46325 L .18001 .45558 L closepath p F P
0 g
s
.821 .774 .267 r
.16742 .51024 m .17112 .47483 L .17392 .46325 L closepath p F P
0 g
s
0 0 .218 r
.16742 .51024 m .17201 .48892 L .17112 .47483 L closepath p F P
0 g
s
.87 .807 .786 r
.16742 .51024 m .18863 .45271 L .1987 .4549 L closepath p F P
0 g
s
.93 .889 .769 r
.16742 .51024 m .18001 .45558 L .18863 .45271 L closepath p F P
0 g
s
0 0 .522 r
.16742 .51024 m .1765 .50378 L .17201 .48892 L closepath p F P
0 g
s
.697 .256 .2 r
.16742 .51024 m .22277 .53399 L .21429 .53723 L closepath p F P
0 g
s
.71 .369 .398 r
.16742 .51024 m .22861 .52608 L .22277 .53399 L closepath p F P
0 g
s
0 .133 .678 r
.16742 .51024 m .18403 .51756 L .1765 .50378 L closepath p F P
0 g
s
.425 0 0 r
.16742 .51024 m .20418 .53536 L .19366 .52853 L closepath p F P
0 g
s
.631 .077 0 r
.16742 .51024 m .21429 .53723 L .20418 .53536 L closepath p F P
0 g
s
0 .207 .723 r
.16742 .51024 m .19366 .52853 L .18403 .51756 L closepath p F P
0 g
s
.638 .642 .838 r
.32541 .35338 m .36057 .33684 L .38684 .36899 L p F P
0 g
s
.662 .743 .911 r
.36057 .33684 m .32541 .35338 L .29649 .33217 L p F P
0 g
s
.749 .749 .852 r
.26282 .36236 m .29649 .33217 L .32541 .35338 L p F P
0 g
s
.863 .817 .802 r
.23036 .40426 m .1987 .4549 L .18863 .45271 L p F P
0 g
s
.688 .342 .383 r
.27617 .55328 m .22277 .53399 L .22861 .52608 L p F P
0 g
s
.688 .342 .383 r
.22861 .52608 m .28676 .53823 L .27617 .55328 L p F P
0 g
s
.492 .5 .793 r
.38684 .36899 m .41743 .35977 L .43601 .39459 L p F P
0 g
s
.511 .597 .876 r
.41743 .35977 m .38684 .36899 L .36057 .33684 L p F P
0 g
s
.843 .836 .839 r
.26282 .36236 m .23036 .40426 L .21158 .39972 L p F P
0 g
s
.863 .817 .802 r
.18863 .45271 m .21158 .39972 L .23036 .40426 L p F P
0 g
s
.447 .201 .446 r
.41988 .52365 m .38385 .53902 L .38966 .50541 L p F P
0 g
s
.447 .201 .446 r
.38966 .50541 m .42537 .48995 L .41988 .52365 L p F P
0 g
s
.367 .247 .581 r
.4519 .46721 m .42537 .48995 L .42111 .44994 L p F P
0 g
s
.367 .247 .581 r
.42111 .44994 m .44795 .43176 L .4519 .46721 L p F P
0 g
s
.635 .277 .347 r
.32536 .56384 m .27617 .55328 L .28676 .53823 L p F P
0 g
s
.635 .277 .347 r
.28676 .53823 m .33915 .54338 L .32536 .56384 L p F P
0 g
s
.924 .908 .787 r
.21158 .39972 m .18863 .45271 L .18001 .45558 L p F P
0 g
s
.794 .863 .901 r
.29649 .33217 m .26282 .36236 L .2377 .35579 L p F P
0 g
s
.843 .836 .839 r
.21158 .39972 m .2377 .35579 L .26282 .36236 L p F P
0 g
s
.662 .204 .155 r
.26053 .55959 m .21429 .53723 L .22277 .53399 L p F P
0 g
s
.662 .204 .155 r
.22277 .53399 m .27617 .55328 L .26053 .55959 L p F P
0 g
s
.517 .144 .272 r
.36862 .56239 m .32536 .56384 L .33915 .54338 L p F P
0 g
s
.517 .144 .272 r
.33915 .54338 m .38385 .53902 L .36862 .56239 L p F P
0 g
s
.511 .597 .876 r
.36057 .33684 m .39424 .33114 L .41743 .35977 L p F P
0 g
s
.493 .699 .961 r
.39424 .33114 m .36057 .33684 L .33177 .31532 L p F P
0 g
s
.662 .743 .911 r
.29649 .33217 m .33177 .31532 L .36057 .33684 L p F P
0 g
s
.924 .908 .787 r
.18001 .45558 m .19543 .40474 L .21158 .39972 L p F P
0 g
s
.943 .951 .638 r
.19543 .40474 m .18001 .45558 L .17392 .46325 L p F P
0 g
s
.9 .947 .827 r
.2377 .35579 m .21158 .39972 L .19543 .40474 L p F P
0 g
s
.663 .874 .978 r
.33177 .31532 m .29649 .33217 L .26815 .32429 L p F P
0 g
s
.794 .863 .901 r
.2377 .35579 m .26815 .32429 L .29649 .33217 L p F P
0 g
s
.191 0 .356 r
.44727 .49693 m .41988 .52365 L .42537 .48995 L p F P
0 g
s
.191 0 .356 r
.42537 .48995 m .4519 .46721 L .44727 .49693 L p F P
0 g
s
.551 0 0 r
.24163 .55619 m .20418 .53536 L .21429 .53723 L p F P
0 g
s
.551 0 0 r
.21429 .53723 m .26053 .55959 L .24163 .55619 L p F P
0 g
s
.564 .069 .039 r
.30466 .57255 m .26053 .55959 L .27617 .55328 L p F P
0 g
s
.564 .069 .039 r
.27617 .55328 m .32536 .56384 L .30466 .57255 L p F P
0 g
s
.276 .286 .69 r
.46735 .41104 m .44795 .43176 L .43601 .39459 L p F P
0 g
s
.276 .286 .69 r
.43601 .39459 m .4583 .38304 L .46735 .41104 L p F P
0 g
s
.331 .414 .797 r
.4583 .38304 m .43601 .39459 L .41743 .35977 L p F P
0 g
s
.25 0 .108 r
.40499 .54701 m .36862 .56239 L .38385 .53902 L p F P
0 g
s
.25 0 .108 r
.38385 .53902 m .41988 .52365 L .40499 .54701 L p F P
0 g
s
.331 .414 .797 r
.41743 .35977 m .44433 .35679 L .4583 .38304 L p F P
0 g
s
.327 .513 .886 r
.44433 .35679 m .41743 .35977 L .39424 .33114 L p F P
0 g
s
.943 .951 .638 r
.17392 .46325 m .18396 .41892 L .19543 .40474 L p F P
0 g
s
.708 .709 .181 r
.18396 .41892 m .17392 .46325 L .17112 .47483 L p F P
0 g
s
.142 .085 .528 r
.47041 .43761 m .4519 .46721 L .44795 .43176 L p F P
0 g
s
.142 .085 .528 r
.44795 .43176 m .46735 .41104 L .47041 .43761 L p F P
0 g
s
0 .27 .694 r
.22176 .54328 m .19366 .52853 L .20418 .53536 L p F P
0 g
s
0 .27 .694 r
.20418 .53536 m .24163 .55619 L .22176 .54328 L p F P
0 g
s
.807 .99 .879 r
.26815 .32429 m .2377 .35579 L .21606 .3621 L p F P
0 g
s
.9 .947 .827 r
.19543 .40474 m .21606 .3621 L .2377 .35579 L p F P
0 g
s
.708 .709 .181 r
.17112 .47483 m .1787 .44072 L .18396 .41892 L p F P
0 g
s
0 0 .316 r
.1787 .44072 m .17112 .47483 L .17201 .48892 L p F P
0 g
s
.493 .699 .961 r
.33177 .31532 m .36895 .31199 L .39424 .33114 L p F P
0 g
s
.345 .769 .975 r
.36895 .31199 m .33177 .31532 L .30364 .30718 L p F P
0 g
s
.663 .874 .978 r
.26815 .32429 m .30364 .30718 L .33177 .31532 L p F P
0 g
s
0 .316 .805 r
.20344 .52233 m .18403 .51756 L .19366 .52853 L p F P
0 g
s
0 .316 .805 r
.19366 .52853 m .22176 .54328 L .20344 .52233 L p F P
0 g
s
.842 .95 .598 r
.21606 .3621 m .19543 .40474 L .18396 .41892 L p F P
0 g
s
.304 0 0 r
.34544 .57236 m .30466 .57255 L .32536 .56384 L p F P
0 g
s
.304 0 0 r
.32536 .56384 m .36862 .56239 L .34544 .57236 L p F P
0 g
s
.327 .513 .886 r
.39424 .33114 m .42697 .33522 L .44433 .35679 L p F P
0 g
s
.227 .579 .943 r
.42697 .33522 m .39424 .33114 L .36895 .31199 L p F P
0 g
s
0 0 .316 r
.17201 .48892 m .18043 .46752 L .1787 .44072 L p F P
0 g
s
0 .055 .59 r
.18043 .46752 m .17201 .48892 L .1765 .50378 L p F P
0 g
s
.016 .23 .737 r
.18904 .49595 m .1765 .50378 L .18403 .51756 L p F P
0 g
s
.016 .23 .737 r
.18403 .51756 m .20344 .52233 L .18904 .49595 L p F P
0 g
s
0 0 0 r
.43437 .51734 m .40499 .54701 L .41988 .52365 L p F P
0 g
s
0 0 0 r
.41988 .52365 m .44727 .49693 L .43437 .51734 L p F P
0 g
s
.312 0 0 r
.27935 .56805 m .24163 .55619 L .26053 .55959 L p F P
0 g
s
.312 0 0 r
.26053 .55959 m .30466 .57255 L .27935 .56805 L p F P
0 g
s
0 .055 .59 r
.1765 .50378 m .18904 .49595 L .18043 .46752 L p F P
0 g
s
0 0 .201 r
.46706 .45972 m .44727 .49693 L .4519 .46721 L p F P
0 g
s
0 0 .201 r
.4519 .46721 m .47041 .43761 L .46706 .45972 L p F P
0 g
s
.462 .887 .821 r
.30364 .30718 m .26815 .32429 L .24374 .33111 L p F P
0 g
s
.807 .99 .879 r
.21606 .3621 m .24374 .33111 L .26815 .32429 L p F P
0 g
s
0 0 0 r
.38211 .55685 m .34544 .57236 L .36862 .56239 L p F P
0 g
s
0 0 0 r
.36862 .56239 m .40499 .54701 L .38211 .55685 L p F P
0 g
s
.842 .95 .598 r
.18396 .41892 m .20066 .38096 L .21606 .3621 L p F P
0 g
s
0 0 .019 r
.20066 .38096 m .18396 .41892 L .1787 .44072 L p F P
0 g
s
0 0 0 r
.24374 .33111 m .21606 .3621 L .20066 .38096 L p F P
0 g
s
.227 .579 .943 r
.36895 .31199 m .40818 .32086 L .42697 .33522 L p F P
0 g
s
0 .474 .755 r
.40818 .32086 m .36895 .31199 L .3444 .30473 L p F P
0 g
s
.345 .769 .975 r
.30364 .30718 m .3444 .30473 L .36895 .31199 L p F P
0 g
s
.101 .173 .653 r
.48128 .38799 m .46735 .41104 L .4583 .38304 L p F P
0 g
s
.101 .173 .653 r
.4583 .38304 m .47636 .37283 L .48128 .38799 L p F P
0 g
s
.166 .318 .774 r
.47636 .37283 m .4583 .38304 L .44433 .35679 L p F P
0 g
s
.066 .511 .896 r
.25252 .5505 m .22176 .54328 L .24163 .55619 L p F P
0 g
s
.066 .511 .896 r
.24163 .55619 m .27935 .56805 L .25252 .5505 L p F P
0 g
s
.166 .318 .774 r
.44433 .35679 m .46879 .35859 L .47636 .37283 L p F P
0 g
s
.136 .408 .855 r
.46879 .35859 m .44433 .35679 L .42697 .33522 L p F P
0 g
s
.462 .887 .821 r
.24374 .33111 m .27951 .31383 L .30364 .30718 L p F P
0 g
s
.138 0 0 r
.3444 .30473 m .30364 .30718 L .27951 .31383 L p F P
0 g
s
.184 .698 .892 r
.31688 .56719 m .27935 .56805 L .30466 .57255 L p F P
0 g
s
.184 .698 .892 r
.30466 .57255 m .34544 .57236 L .31688 .56719 L p F P
0 g
s
.693 .849 .429 r
.45756 .47469 m .43437 .51734 L .44727 .49693 L p F P
0 g
s
.693 .849 .429 r
.44727 .49693 m .46706 .45972 L .45756 .47469 L p F P
0 g
s
0 0 .45 r
.48297 .4023 m .47041 .43761 L .46735 .41104 L p F P
0 g
s
0 0 .45 r
.46735 .41104 m .48128 .38799 L .48297 .4023 L p F P
0 g
s
.748 .994 .832 r
.41447 .5257 m .38211 .55685 L .40499 .54701 L p F P
0 g
s
.748 .994 .832 r
.40499 .54701 m .43437 .51734 L .41447 .5257 L p F P
0 g
s
.136 .408 .855 r
.42697 .33522 m .45945 .34693 L .46879 .35859 L p F P
0 g
s
0 .418 .845 r
.45945 .34693 m .42697 .33522 L .40818 .32086 L p F P
0 g
s
.002 0 .457 r
.19362 .41039 m .1787 .44072 L .18043 .46752 L p F P
0 g
s
0 0 .019 r
.1787 .44072 m .19362 .41039 L .20066 .38096 L p F P
0 g
s
0 0 .046 r
.48121 .41409 m .46706 .45972 L .47041 .43761 L p F P
0 g
s
0 0 .046 r
.47041 .43761 m .48297 .4023 L .48121 .41409 L p F P
0 g
s
.229 .475 .885 r
.2276 .52186 m .20344 .52233 L .22176 .54328 L p F P
0 g
s
.229 .475 .885 r
.22176 .54328 m .25252 .5505 L .2276 .52186 L p F P
0 g
s
.118 0 0 r
.27951 .31383 m .24374 .33111 L .2264 .35238 L p F P
0 g
s
0 0 0 r
.20066 .38096 m .2264 .35238 L .24374 .33111 L p F P
0 g
s
.002 0 .457 r
.18043 .46752 m .19609 .44687 L .19362 .41039 L p F P
0 g
s
.182 .219 .665 r
.19609 .44687 m .18043 .46752 L .18904 .49595 L p F P
0 g
s
.064 0 .257 r
.2264 .35238 m .20066 .38096 L .19362 .41039 L p F P
0 g
s
0 .474 .755 r
.3444 .30473 m .39009 .31549 L .40818 .32086 L p F P
0 g
s
.482 0 0 r
.39009 .31549 m .3444 .30473 L .3235 .31059 L p F P
0 g
s
.138 0 0 r
.27951 .31383 m .3235 .31059 L .3444 .30473 L p F P
0 g
s
.62 .894 .988 r
.35378 .55145 m .31688 .56719 L .34544 .57236 L p F P
0 g
s
.62 .894 .988 r
.34544 .57236 m .38211 .55685 L .35378 .55145 L p F P
0 g
s
.249 .371 .792 r
.20792 .48574 m .18904 .49595 L .20344 .52233 L p F P
0 g
s
.249 .371 .792 r
.20344 .52233 m .2276 .52186 L .20792 .48574 L p F P
0 g
s
0 .418 .845 r
.40818 .32086 m .44942 .33922 L .45945 .34693 L p F P
0 g
s
.386 0 0 r
.44942 .33922 m .40818 .32086 L .39009 .31549 L p F P
0 g
s
.182 .219 .665 r
.18904 .49595 m .20792 .48574 L .19609 .44687 L p F P
0 g
s
.43 .698 .977 r
.28638 .547 m .25252 .5505 L .27935 .56805 L p F P
0 g
s
.43 .698 .977 r
.27935 .56805 m .31688 .56719 L .28638 .547 L p F P
0 g
s
.896 .979 .809 r
.44291 .48057 m .41447 .5257 L .43437 .51734 L p F P
0 g
s
.896 .979 .809 r
.43437 .51734 m .45756 .47469 L .44291 .48057 L p F P
0 g
s
.869 .917 .519 r
.47617 .42193 m .45756 .47469 L .46706 .45972 L p F P
0 g
s
.869 .917 .519 r
.46706 .45972 m .48121 .41409 L .47617 .42193 L p F P
0 g
s
.465 .057 .181 r
.3235 .31059 m .27951 .31383 L .2625 .33503 L p F P
0 g
s
.118 0 0 r
.2264 .35238 m .2625 .33503 L .27951 .31383 L p F P
0 g
s
.793 .895 .916 r
.38977 .52059 m .35378 .55145 L .38211 .55685 L p F P
0 g
s
.793 .895 .916 r
.38211 .55685 m .41447 .5257 L .38977 .52059 L p F P
0 g
s
.305 .188 .551 r
.21859 .38591 m .19362 .41039 L .19609 .44687 L p F P
0 g
s
.064 0 .257 r
.19362 .41039 m .21859 .38591 L .2264 .35238 L p F P
0 g
s
0 .102 .619 r
.47636 .37283 m .49245 .36313 L .48128 .38799 L closepath p F P
0 g
s
.063 .255 .748 r
.46879 .35859 m .49245 .36313 L .47636 .37283 L closepath p F P
0 g
s
.386 0 0 r
.39009 .31549 m .43988 .33641 L .44942 .33922 L p F P
0 g
s
.613 .104 .015 r
.43988 .33641 m .39009 .31549 L .37488 .31996 L p F P
0 g
s
.482 0 0 r
.3235 .31059 m .37488 .31996 L .39009 .31549 L p F P
0 g
s
.398 .137 .397 r
.2625 .33503 m .2264 .35238 L .21859 .38591 L p F P
0 g
s
.019 .337 .818 r
.45945 .34693 m .49245 .36313 L .46879 .35859 L closepath p F P
0 g
s
0 0 .394 r
.48128 .38799 m .49245 .36313 L .48297 .4023 L closepath p F P
0 g
s
.474 .592 .891 r
.25791 .51402 m .2276 .52186 L .25252 .5505 L p F P
0 g
s
.474 .592 .891 r
.25252 .5505 m .28638 .547 L .25791 .51402 L p F P
0 g
s
.612 .222 .281 r
.37488 .31996 m .3235 .31059 L .30895 .3293 L p F P
0 g
s
.465 .057 .181 r
.2625 .33503 m .30895 .3293 L .3235 .31059 L p F P
0 g
s
.935 .943 .773 r
.46842 .42482 m .44291 .48057 L .45756 .47469 L p F P
0 g
s
.935 .943 .773 r
.45756 .47469 m .47617 .42193 L .46842 .42482 L p F P
0 g
s
0 .315 .762 r
.44942 .33922 m .49245 .36313 L .45945 .34693 L closepath p F P
0 g
s
.648 .76 .931 r
.32342 .53094 m .28638 .547 L .31688 .56719 L p F P
0 g
s
.648 .76 .931 r
.31688 .56719 m .35378 .55145 L .32342 .53094 L p F P
0 g
s
0 0 0 r
.48297 .4023 m .49245 .36313 L .48121 .41409 L closepath p F P
0 g
s
.854 .866 .849 r
.42475 .47639 m .38977 .52059 L .41447 .5257 L p F P
0 g
s
.854 .866 .849 r
.41447 .5257 m .44291 .48057 L .42475 .47639 L p F P
0 g
s
.495 0 0 r
.43988 .33641 m .49245 .36313 L .44942 .33922 L closepath p F P
0 g
s
.305 .188 .551 r
.19609 .44687 m .22161 .42772 L .21859 .38591 L p F P
0 g
s
.409 .364 .697 r
.22161 .42772 m .19609 .44687 L .20792 .48574 L p F P
0 g
s
.919 .922 .541 r
.48121 .41409 m .49245 .36313 L .47617 .42193 L closepath p F P
0 g
s
.459 .485 .799 r
.2353 .47241 m .20792 .48574 L .2276 .52186 L p F P
0 g
s
.459 .485 .799 r
.2276 .52186 m .25791 .51402 L .2353 .47241 L p F P
0 g
s
.569 .291 .454 r
.30895 .3293 m .2625 .33503 L .25501 .36864 L p F P
0 g
s
.398 .137 .397 r
.21859 .38591 m .25501 .36864 L .2625 .33503 L p F P
0 g
s
.409 .364 .697 r
.20792 .48574 m .2353 .47241 L .22161 .42772 L p F P
0 g
s
.613 .104 .015 r
.37488 .31996 m .43197 .3389 L .43988 .33641 L p F P
0 g
s
.675 .298 .324 r
.43197 .3389 m .37488 .31996 L .36447 .33398 L p F P
0 g
s
.612 .222 .281 r
.30895 .3293 m .36447 .33398 L .37488 .31996 L p F P
0 g
s
.652 .512 .68 r
.72431 .31608 m .67582 .33087 L .66273 .29225 L p F P
0 g
s
.652 .512 .68 r
.66273 .29225 m .70924 .27207 L .72431 .31608 L p F P
0 g
s
.681 .588 .744 r
.70924 .27207 m .66273 .29225 L .64364 .25567 L p F P
0 g
s
.701 .539 .665 r
.6103 .31439 m .66273 .29225 L .67582 .33087 L p F P
0 g
s
.726 .606 .723 r
.66273 .29225 m .6103 .31439 L .59606 .28725 L p F P
0 g
s
.726 .606 .723 r
.59606 .28725 m .64364 .25567 L .66273 .29225 L p F P
0 g
s
.659 .167 .07 r
.43197 .3389 m .49245 .36313 L .43988 .33641 L closepath p F P
0 g
s
.505 .335 .585 r
.25501 .36864 m .21859 .38591 L .22161 .42772 L p F P
0 g
s
.751 .766 .865 r
.36328 .50221 m .32342 .53094 L .35378 .55145 L p F P
0 g
s
.751 .766 .865 r
.35378 .55145 m .38977 .52059 L .36328 .50221 L p F P
0 g
s
.877 .845 .809 r
.45886 .42236 m .42475 .47639 L .44291 .48057 L p F P
0 g
s
.877 .845 .809 r
.44291 .48057 m .46842 .42482 L .45886 .42236 L p F P
0 g
s
.701 .539 .665 r
.67582 .33087 m .61991 .34311 L .6103 .31439 L p F P
0 g
s
.729 .554 .654 r
.55294 .33821 m .6103 .31439 L .61991 .34311 L p F P
0 g
s
.752 .615 .707 r
.6103 .31439 m .55294 .33821 L .54531 .32373 L p F P
0 g
s
.752 .615 .707 r
.54531 .32373 m .59606 .28725 L .6103 .31439 L p F P
0 g
s
.945 .925 .755 r
.47617 .42193 m .49245 .36313 L .46842 .42482 L closepath p F P
0 g
s
.681 .588 .744 r
.64364 .25567 m .68754 .2303 L .70924 .27207 L p F P
0 g
s
.712 .665 .802 r
.68754 .2303 m .64364 .25567 L .6206 .22515 L p F P
0 g
s
.757 .675 .772 r
.64364 .25567 m .59606 .28725 L .57878 .26474 L p F P
0 g
s
.757 .675 .772 r
.57878 .26474 m .6206 .22515 L .64364 .25567 L p F P
0 g
s
.782 .68 .751 r
.59606 .28725 m .54531 .32373 L .53599 .31181 L p F P
0 g
s
.782 .68 .751 r
.53599 .31181 m .57878 .26474 L .59606 .28725 L p F P
0 g
s
.622 .427 .597 r
.73105 .3576 m .68141 .36732 L .67582 .33087 L p F P
0 g
s
.622 .427 .597 r
.67582 .33087 m .72431 .31608 L .73105 .3576 L p F P
0 g
s
.679 .467 .591 r
.61991 .34311 m .67582 .33087 L .68141 .36732 L p F P
0 g
s
.679 .467 .591 r
.68141 .36732 m .62379 .37019 L .61991 .34311 L p F P
0 g
s
.711 .489 .586 r
.55802 .35356 m .61991 .34311 L .62379 .37019 L p F P
0 g
s
.729 .554 .654 r
.61991 .34311 m .55802 .35356 L .55294 .33821 L p F P
0 g
s
.627 .647 .851 r
.29495 .4976 m .25791 .51402 L .28638 .547 L p F P
0 g
s
.627 .647 .851 r
.28638 .547 m .32342 .53094 L .29495 .4976 L p F P
0 g
s
.575 .469 .696 r
.76487 .29817 m .72431 .31608 L .70924 .27207 L p F P
0 g
s
.575 .469 .696 r
.70924 .27207 m .74956 .25387 L .76487 .29817 L p F P
0 g
s
.609 .556 .77 r
.74956 .25387 m .70924 .27207 L .68754 .2303 L p F P
0 g
s
.654 .37 .477 r
.36447 .33398 m .30895 .3293 L .30278 .35893 L p F P
0 g
s
.569 .291 .454 r
.25501 .36864 m .30278 .35893 L .30895 .3293 L p F P
0 g
s
.609 .556 .77 r
.68754 .2303 m .72776 .21175 L .74956 .25387 L p F P
0 g
s
.638 .642 .838 r
.72776 .21175 m .68754 .2303 L .66151 .19529 L p F P
0 g
s
.712 .665 .802 r
.6206 .22515 m .66151 .19529 L .68754 .2303 L p F P
0 g
s
.7 .328 .34 r
.42667 .34647 m .49245 .36313 L .43197 .3389 L closepath p F P
0 g
s
.675 .298 .324 r
.36447 .33398 m .42667 .34647 L .43197 .3389 L p F P
0 g
s
.742 .561 .649 r
.49245 .36313 m .55294 .33821 L .55802 .35356 L closepath p F P
0 g
s
.763 .619 .7 r
.49245 .36313 m .54531 .32373 L .55294 .33821 L closepath p F P
0 g
s
.792 .681 .741 r
.49245 .36313 m .53599 .31181 L .54531 .32373 L closepath p F P
0 g
s
.529 .363 .601 r
.77196 .33989 m .73105 .3576 L .72431 .31608 L p F P
0 g
s
.529 .363 .601 r
.72431 .31608 m .76487 .29817 L .77196 .33989 L p F P
0 g
s
.799 .76 .817 r
.4053 .46246 m .36328 .50221 L .38977 .52059 L p F P
0 g
s
.799 .76 .817 r
.38977 .52059 m .42475 .47639 L .4053 .46246 L p F P
0 g
s
.886 .835 .79 r
.46842 .42482 m .49245 .36313 L .45886 .42236 L closepath p F P
0 g
s
.711 .489 .586 r
.62379 .37019 m .55993 .36801 L .55802 .35356 L p F P
0 g
s
.726 .499 .583 r
.49245 .36313 m .55802 .35356 L .55993 .36801 L closepath p F P
0 g
s
.798 .757 .816 r
.6206 .22515 m .57878 .26474 L .56038 .24947 L p F P
0 g
s
.822 .754 .788 r
.57878 .26474 m .53599 .31181 L .52607 .30386 L p F P
0 g
s
.822 .754 .788 r
.52607 .30386 m .56038 .24947 L .57878 .26474 L p F P
0 g
s
.75 .757 .858 r
.66151 .19529 m .6206 .22515 L .59611 .20416 L p F P
0 g
s
.798 .757 .816 r
.56038 .24947 m .59611 .20416 L .6206 .22515 L p F P
0 g
s
.696 .41 .487 r
.42667 .34647 m .36447 .33398 L .36027 .35603 L p F P
0 g
s
.654 .37 .477 r
.30278 .35893 m .36027 .35603 L .36447 .33398 L p F P
0 g
s
.655 .375 .482 r
.67875 .39748 m .62142 .39251 L .62379 .37019 L p F P
0 g
s
.655 .375 .482 r
.62379 .37019 m .68141 .36732 L .67875 .39748 L p F P
0 g
s
.696 .411 .487 r
.55993 .36801 m .62379 .37019 L .62142 .39251 L p F P
0 g
s
.832 .751 .774 r
.49245 .36313 m .52607 .30386 L .53599 .31181 L closepath p F P
0 g
s
.505 .335 .585 r
.22161 .42772 m .25832 .41065 L .25501 .36864 L p F P
0 g
s
.56 .457 .694 r
.25832 .41065 m .22161 .42772 L .2353 .47241 L p F P
0 g
s
.617 .419 .591 r
.30278 .35893 m .25501 .36864 L .25832 .41065 L p F P
0 g
s
.696 .411 .487 r
.62142 .39251 m .55843 .37985 L .55993 .36801 L p F P
0 g
s
.714 .427 .49 r
.49245 .36313 m .55993 .36801 L .55843 .37985 L closepath p F P
0 g
s
.579 .309 .471 r
.72855 .39199 m .67875 .39748 L .68141 .36732 L p F P
0 g
s
.579 .309 .471 r
.68141 .36732 m .73105 .3576 L .72855 .39199 L p F P
0 g
s
.822 .754 .788 r
.44864 .41477 m .4053 .46246 L .42475 .47639 L p F P
0 g
s
.822 .754 .788 r
.42475 .47639 m .45886 .42236 L .44864 .41477 L p F P
0 g
s
.598 .553 .775 r
.27223 .45564 m .2353 .47241 L .25791 .51402 L p F P
0 g
s
.598 .553 .775 r
.25791 .51402 m .29495 .4976 L .27223 .45564 L p F P
0 g
s
.714 .427 .49 r
.42467 .35823 m .49245 .36313 L .42667 .34647 L closepath p F P
0 g
s
.696 .41 .487 r
.36027 .35603 m .42467 .35823 L .42667 .34647 L p F P
0 g
s
.832 .751 .774 r
.45886 .42236 m .49245 .36313 L .44864 .41477 L closepath p F P
0 g
s
.712 .669 .806 r
.33839 .47264 m .29495 .4976 L .32342 .53094 L p F P
0 g
s
.712 .669 .806 r
.32342 .53094 m .36328 .50221 L .33839 .47264 L p F P
0 g
s
.466 .406 .706 r
.79783 .27685 m .76487 .29817 L .74956 .25387 L p F P
0 g
s
.466 .406 .706 r
.74956 .25387 m .78412 .23746 L .79783 .27685 L p F P
0 g
s
.506 .506 .79 r
.78412 .23746 m .74956 .25387 L .72776 .21175 L p F P
0 g
s
.886 .835 .79 r
.49245 .36313 m .51671 .30085 L .52607 .30386 L closepath p F P
0 g
s
.945 .925 .755 r
.49245 .36313 m .50903 .30322 L .51671 .30085 L closepath p F P
0 g
s
.919 .922 .541 r
.49245 .36313 m .504 .31073 L .50903 .30322 L closepath p F P
0 g
s
0 0 0 r
.49245 .36313 m .50227 .32255 L .504 .31073 L closepath p F P
0 g
s
0 0 .394 r
.49245 .36313 m .50408 .33725 L .50227 .32255 L closepath p F P
0 g
s
0 .102 .619 r
.49245 .36313 m .50923 .35301 L .50408 .33725 L closepath p F P
0 g
s
.063 .255 .748 r
.49245 .36313 m .5171 .36787 L .50923 .35301 L closepath p F P
0 g
s
.659 .167 .07 r
.49245 .36313 m .55366 .38766 L .54616 .39044 L closepath p F P
0 g
s
.7 .328 .34 r
.49245 .36313 m .55843 .37985 L .55366 .38766 L closepath p F P
0 g
s
.019 .337 .818 r
.49245 .36313 m .52668 .37995 L .5171 .36787 L closepath p F P
0 g
s
.495 0 0 r
.49245 .36313 m .54616 .39044 L .53679 .38778 L closepath p F P
0 g
s
0 .315 .762 r
.49245 .36313 m .53679 .38778 L .52668 .37995 L closepath p F P
0 g
s
.726 .499 .583 r
.42626 .3728 m .49245 .36313 L .42467 .35823 L closepath p F P
0 g
s
.742 .561 .649 r
.43125 .38835 m .49245 .36313 L .42626 .3728 L closepath p F P
0 g
s
.763 .619 .7 r
.43904 .40295 m .49245 .36313 L .43125 .38835 L closepath p F P
0 g
s
.792 .681 .741 r
.44864 .41477 m .49245 .36313 L .43904 .40295 L closepath p F P
0 g
s
.56 .457 .694 r
.2353 .47241 m .27223 .45564 L .25832 .41065 L p F P
0 g
s
.638 .642 .838 r
.66151 .19529 m .70177 .17635 L .72776 .21175 L p F P
0 g
s
.662 .743 .911 r
.70177 .17635 m .66151 .19529 L .63392 .17101 L p F P
0 g
s
.75 .757 .858 r
.59611 .20416 m .63392 .17101 L .66151 .19529 L p F P
0 g
s
.877 .844 .808 r
.56038 .24947 m .52607 .30386 L .51671 .30085 L p F P
0 g
s
.676 .299 .326 r
.61294 .40738 m .55366 .38766 L .55843 .37985 L p F P
0 g
s
.676 .299 .326 r
.55843 .37985 m .62142 .39251 L .61294 .40738 L p F P
0 g
s
.506 .506 .79 r
.72776 .21175 m .76476 .19993 L .78412 .23746 L p F P
0 g
s
.526 .598 .869 r
.76476 .19993 m .72776 .21175 L .70177 .17635 L p F P
0 g
s
.852 .86 .847 r
.59611 .20416 m .56038 .24947 L .54298 .24334 L p F P
0 g
s
.877 .844 .808 r
.51671 .30085 m .54298 .24334 L .56038 .24947 L p F P
0 g
s
.679 .465 .589 r
.36027 .35603 m .30278 .35893 L .30601 .39594 L p F P
0 g
s
.617 .419 .591 r
.25832 .41065 m .30601 .39594 L .30278 .35893 L p F P
0 g
s
.711 .489 .585 r
.42467 .35823 m .36027 .35603 L .36295 .38348 L p F P
0 g
s
.711 .489 .585 r
.36295 .38348 m .42626 .3728 L .42467 .35823 L p F P
0 g
s
.447 .201 .446 r
.76989 .37435 m .72855 .39199 L .73105 .3576 L p F P
0 g
s
.447 .201 .446 r
.73105 .3576 m .77196 .33989 L .76989 .37435 L p F P
0 g
s
.393 .271 .593 r
.80436 .31381 m .77196 .33989 L .76487 .29817 L p F P
0 g
s
.393 .271 .593 r
.76487 .29817 m .79783 .27685 L .80436 .31381 L p F P
0 g
s
.782 .68 .752 r
.4053 .46246 m .44864 .41477 L .43904 .40295 L p F P
0 g
s
.679 .465 .589 r
.30601 .39594 m .36295 .38348 L .36027 .35603 L p F P
0 g
s
.616 .232 .293 r
.66791 .41771 m .61294 .40738 L .62142 .39251 L p F P
0 g
s
.616 .232 .293 r
.62142 .39251 m .67875 .39748 L .66791 .41771 L p F P
0 g
s
.758 .677 .773 r
.38701 .44036 m .33839 .47264 L .36328 .50221 L p F P
0 g
s
.758 .677 .773 r
.36328 .50221 m .4053 .46246 L .38701 .44036 L p F P
0 g
s
.782 .68 .752 r
.43904 .40295 m .38701 .44036 L .4053 .46246 L p F P
0 g
s
.729 .554 .654 r
.42626 .3728 m .36295 .38348 L .37225 .41285 L p F P
0 g
s
.729 .554 .654 r
.37225 .41285 m .43125 .38835 L .42626 .3728 L p F P
0 g
s
.934 .942 .774 r
.54298 .24334 m .51671 .30085 L .50903 .30322 L p F P
0 g
s
.794 .879 .909 r
.63392 .17101 m .59611 .20416 L .57293 .19536 L p F P
0 g
s
.852 .86 .847 r
.54298 .24334 m .57293 .19536 L .59611 .20416 L p F P
0 g
s
.65 .509 .679 r
.30601 .39594 m .25832 .41065 L .27223 .45564 L p F P
0 g
s
.752 .615 .707 r
.38701 .44036 m .43904 .40295 L .43125 .38835 L p F P
0 g
s
.752 .615 .707 r
.43125 .38835 m .37225 .41285 L .38701 .44036 L p F P
0 g
s
.615 .108 .02 r
.59922 .41284 m .54616 .39044 L .55366 .38766 L p F P
0 g
s
.615 .108 .02 r
.55366 .38766 m .61294 .40738 L .59922 .41284 L p F P
0 g
s
.68 .588 .746 r
.31841 .43558 m .27223 .45564 L .29495 .4976 L p F P
0 g
s
.68 .588 .746 r
.29495 .4976 m .33839 .47264 L .31841 .43558 L p F P
0 g
s
.493 .103 .229 r
.7168 .41508 m .66791 .41771 L .67875 .39748 L p F P
0 g
s
.493 .103 .229 r
.67875 .39748 m .72855 .39199 L .7168 .41508 L p F P
0 g
s
.65 .509 .679 r
.27223 .45564 m .31841 .43558 L .30601 .39594 L p F P
0 g
s
.526 .598 .869 r
.70177 .17635 m .74185 .16837 L .76476 .19993 L p F P
0 g
s
.516 .698 .951 r
.74185 .16837 m .70177 .17635 L .67438 .15168 L p F P
0 g
s
.662 .743 .911 r
.63392 .17101 m .67438 .15168 L .70177 .17635 L p F P
0 g
s
.701 .538 .664 r
.36295 .38348 m .30601 .39594 L .31841 .43558 L p F P
0 g
s
.701 .538 .664 r
.31841 .43558 m .37225 .41285 L .36295 .38348 L p F P
0 g
s
.726 .606 .723 r
.33839 .47264 m .38701 .44036 L .37225 .41285 L p F P
0 g
s
.726 .606 .723 r
.37225 .41285 m .31841 .43558 L .33839 .47264 L p F P
0 g
s
.934 .942 .774 r
.50903 .30322 m .52867 .24731 L .54298 .24334 L p F P
0 g
s
.872 .919 .523 r
.52867 .24731 m .50903 .30322 L .504 .31073 L p F P
0 g
s
.898 .975 .814 r
.57293 .19536 m .54298 .24334 L .52867 .24731 L p F P
0 g
s
.663 .874 .978 r
.67438 .15168 m .63392 .17101 L .60786 .1605 L p F P
0 g
s
.794 .879 .909 r
.57293 .19536 m .60786 .1605 L .63392 .17101 L p F P
0 g
s
.241 .04 .394 r
.80284 .34418 m .76989 .37435 L .77196 .33989 L p F P
0 g
s
.241 .04 .394 r
.77196 .33989 m .80436 .31381 L .80284 .34418 L p F P
0 g
s
.392 0 0 r
.5818 .40796 m .53679 .38778 L .54616 .39044 L p F P
0 g
s
.392 0 0 r
.54616 .39044 m .59922 .41284 L .5818 .40796 L p F P
0 g
s
.498 0 0 r
.64991 .42526 m .59922 .41284 L .61294 .40738 L p F P
0 g
s
.498 0 0 r
.61294 .40738 m .66791 .41771 L .64991 .42526 L p F P
0 g
s
.335 .327 .702 r
.82437 .25209 m .79783 .27685 L .78412 .23746 L p F P
0 g
s
.335 .327 .702 r
.78412 .23746 m .81396 .2224 L .82437 .25209 L p F P
0 g
s
.382 .44 .796 r
.81396 .2224 m .78412 .23746 L .76476 .19993 L p F P
0 g
s
.25 0 .108 r
.75859 .3974 m .7168 .41508 L .72855 .39199 L p F P
0 g
s
.25 0 .108 r
.72855 .39199 m .76989 .37435 L .75859 .3974 L p F P
0 g
s
.382 .44 .796 r
.76476 .19993 m .79939 .19406 L .81396 .2224 L p F P
0 g
s
.387 .532 .88 r
.79939 .19406 m .76476 .19993 L .74185 .16837 L p F P
0 g
s
.872 .919 .523 r
.504 .31073 m .51925 .26115 L .52867 .24731 L p F P
0 g
s
0 0 .039 r
.51925 .26115 m .504 .31073 L .50227 .32255 L p F P
0 g
s
.227 .159 .568 r
.82941 .2798 m .80436 .31381 L .79783 .27685 L p F P
0 g
s
.227 .159 .568 r
.79783 .27685 m .82437 .25209 L .82941 .2798 L p F P
0 g
s
0 .414 .842 r
.56277 .39312 m .52668 .37995 L .53679 .38778 L p F P
0 g
s
0 .414 .842 r
.53679 .38778 m .5818 .40796 L .56277 .39312 L p F P
0 g
s
.783 .997 .861 r
.60786 .1605 m .57293 .19536 L .55383 .20017 L p F P
0 g
s
.898 .975 .814 r
.52867 .24731 m .55383 .20017 L .57293 .19536 L p F P
0 g
s
0 0 .039 r
.50227 .32255 m .51605 .28338 L .51925 .26115 L p F P
0 g
s
0 0 .447 r
.51605 .28338 m .50227 .32255 L .50408 .33725 L p F P
0 g
s
.516 .698 .951 r
.67438 .15168 m .71786 .14637 L .74185 .16837 L p F P
0 g
s
.407 .785 .992 r
.71786 .14637 m .67438 .15168 L .64862 .14085 L p F P
0 g
s
.663 .874 .978 r
.60786 .1605 m .64862 .14085 L .67438 .15168 L p F P
0 g
s
.131 .406 .854 r
.54455 .37001 m .5171 .36787 L .52668 .37995 L p F P
0 g
s
.131 .406 .854 r
.52668 .37995 m .56277 .39312 L .54455 .37001 L p F P
0 g
s
.723 .872 .462 r
.55383 .20017 m .52867 .24731 L .51925 .26115 L p F P
0 g
s
.225 0 0 r
.69683 .42371 m .64991 .42526 L .66791 .41771 L p F P
0 g
s
.225 0 0 r
.66791 .41771 m .7168 .41508 L .69683 .42371 L p F P
0 g
s
.387 .532 .88 r
.74185 .16837 m .78226 .17026 L .79939 .19406 L p F P
0 g
s
.323 .609 .951 r
.78226 .17026 m .74185 .16837 L .71786 .14637 L p F P
0 g
s
0 0 .447 r
.50408 .33725 m .51958 .31135 L .51605 .28338 L p F P
0 g
s
.097 .17 .651 r
.51958 .31135 m .50408 .33725 L .50923 .35301 L p F P
0 g
s
.162 .316 .773 r
.5295 .34153 m .50923 .35301 L .5171 .36787 L p F P
0 g
s
.162 .316 .773 r
.5171 .36787 m .54455 .37001 L .5295 .34153 L p F P
0 g
s
0 0 0 r
.79321 .36426 m .75859 .3974 L .76989 .37435 L p F P
0 g
s
0 0 0 r
.76989 .37435 m .80284 .34418 L .79321 .36426 L p F P
0 g
s
0 .447 .722 r
.62672 .41874 m .5818 .40796 L .59922 .41284 L p F P
0 g
s
0 .447 .722 r
.59922 .41284 m .64991 .42526 L .62672 .41874 L p F P
0 g
s
.097 .17 .651 r
.50923 .35301 m .5295 .34153 L .51958 .31135 L p F P
0 g
s
0 0 .312 r
.82845 .30237 m .80284 .34418 L .80436 .31381 L p F P
0 g
s
0 0 .312 r
.80436 .31381 m .82941 .2798 L .82845 .30237 L p F P
0 g
s
.462 .887 .821 r
.64862 .14085 m .60786 .1605 L .58644 .16553 L p F P
0 g
s
.783 .997 .861 r
.55383 .20017 m .58644 .16553 L .60786 .1605 L p F P
0 g
s
0 0 0 r
.73905 .40585 m .69683 .42371 L .7168 .41508 L p F P
0 g
s
0 0 0 r
.7168 .41508 m .75859 .3974 L .73905 .40585 L p F P
0 g
s
.723 .872 .462 r
.51925 .26115 m .54129 .21848 L .55383 .20017 L p F P
0 g
s
0 0 .174 r
.54129 .21848 m .51925 .26115 L .51605 .28338 L p F P
0 g
s
0 0 0 r
.58644 .16553 m .55383 .20017 L .54129 .21848 L p F P
0 g
s
.323 .609 .951 r
.71786 .14637 m .7645 .15373 L .78226 .17026 L p F P
0 g
s
.076 .588 .885 r
.7645 .15373 m .71786 .14637 L .6955 .1367 L p F P
0 g
s
.407 .785 .992 r
.64862 .14085 m .6955 .1367 L .71786 .14637 L p F P
0 g
s
.214 .252 .686 r
.84636 .22421 m .82437 .25209 L .81396 .2224 L p F P
0 g
s
.214 .252 .686 r
.81396 .2224 m .84068 .20812 L .84636 .22421 L p F P
0 g
s
.268 .375 .788 r
.84068 .20812 m .81396 .2224 L .79939 .19406 L p F P
0 g
s
.204 .571 .939 r
.6011 .39853 m .56277 .39312 L .5818 .40796 L p F P
0 g
s
.204 .571 .939 r
.5818 .40796 m .62672 .41874 L .6011 .39853 L p F P
0 g
s
.268 .375 .788 r
.79939 .19406 m .83279 .19273 L .84068 .20812 L p F P
0 g
s
.256 .462 .869 r
.83279 .19273 m .79939 .19406 L .78226 .17026 L p F P
0 g
s
.462 .887 .821 r
.58644 .16553 m .62761 .14564 L .64862 .14085 L p F P
0 g
s
.036 0 0 r
.6955 .1367 m .64862 .14085 L .62761 .14564 L p F P
0 g
s
.273 .742 .944 r
.67078 .4162 m .62672 .41874 L .64991 .42526 L p F P
0 g
s
.273 .742 .944 r
.64991 .42526 m .69683 .42371 L .67078 .4162 L p F P
0 g
s
0 0 0 r
.82146 .31705 m .79321 .36426 L .80284 .34418 L p F P
0 g
s
0 0 0 r
.80284 .34418 m .82845 .30237 L .82146 .31705 L p F P
0 g
s
.078 .059 .531 r
.84915 .23914 m .82941 .2798 L .82437 .25209 L p F P
0 g
s
.078 .059 .531 r
.82437 .25209 m .84636 .22421 L .84915 .23914 L p F P
0 g
s
.696 .977 .785 r
.77634 .37132 m .73905 .40585 L .75859 .3974 L p F P
0 g
s
.696 .977 .785 r
.75859 .3974 m .79321 .36426 L .77634 .37132 L p F P
0 g
s
.256 .462 .869 r
.78226 .17026 m .82359 .17983 L .83279 .19273 L p F P
0 g
s
.143 .507 .911 r
.82359 .17983 m .78226 .17026 L .7645 .15373 L p F P
0 g
s
0 0 .174 r
.51605 .28338 m .53712 .24846 L .54129 .21848 L p F P
0 g
s
.122 .069 .519 r
.53712 .24846 m .51605 .28338 L .51958 .31135 L p F P
0 g
s
0 0 .23 r
.84871 .25116 m .82845 .30237 L .82941 .2798 L p F P
0 g
s
0 0 .23 r
.82941 .2798 m .84915 .23914 L .84871 .25116 L p F P
0 g
s
.314 .508 .887 r
.57635 .3669 m .54455 .37001 L .56277 .39312 L p F P
0 g
s
.314 .508 .887 r
.56277 .39312 m .6011 .39853 L .57635 .3669 L p F P
0 g
s
.118 0 0 r
.62761 .14564 m .58644 .16553 L .57247 .18611 L p F P
0 g
s
0 0 0 r
.54129 .21848 m .57247 .18611 L .58644 .16553 L p F P
0 g
s
.122 .069 .519 r
.51958 .31135 m .54211 .28654 L .53712 .24846 L p F P
0 g
s
.263 .276 .687 r
.54211 .28654 m .51958 .31135 L .5295 .34153 L p F P
0 g
s
.134 0 .313 r
.57247 .18611 m .54129 .21848 L .53712 .24846 L p F P
0 g
s
.076 .588 .885 r
.6955 .1367 m .74814 .14654 L .7645 .15373 L p F P
0 g
s
.375 0 0 r
.74814 .14654 m .6955 .1367 L .67746 .14089 L p F P
0 g
s
.036 0 0 r
.62761 .14564 m .67746 .14089 L .6955 .1367 L p F P
0 g
s
.62 .894 .988 r
.71335 .39804 m .67078 .4162 L .69683 .42371 L p F P
0 g
s
.62 .894 .988 r
.69683 .42371 m .73905 .40585 L .71335 .39804 L p F P
0 g
s
.319 .408 .797 r
.55577 .32784 m .5295 .34153 L .54455 .37001 L p F P
0 g
s
.319 .408 .797 r
.54455 .37001 m .57635 .3669 L .55577 .32784 L p F P
0 g
s
.143 .507 .911 r
.7645 .15373 m .81414 .17094 L .82359 .17983 L p F P
0 g
s
0 .396 .735 r
.81414 .17094 m .7645 .15373 L .74814 .14654 L p F P
0 g
s
.263 .276 .687 r
.5295 .34153 m .55577 .32784 L .54211 .28654 L p F P
0 g
s
.465 .7 .97 r
.64176 .39291 m .6011 .39853 L .62672 .41874 L p F P
0 g
s
.465 .7 .97 r
.62672 .41874 m .67078 .4162 L .64176 .39291 L p F P
0 g
s
.871 .995 .772 r
.80913 .32188 m .77634 .37132 L .79321 .36426 L p F P
0 g
s
.871 .995 .772 r
.79321 .36426 m .82146 .31705 L .80913 .32188 L p F P
0 g
s
.712 .804 .336 r
.84505 .2588 m .82146 .31705 L .82845 .30237 L p F P
0 g
s
.712 .804 .336 r
.82845 .30237 m .84871 .25116 L .84505 .2588 L p F P
0 g
s
.43 .001 .122 r
.67746 .14089 m .62761 .14564 L .61409 .16611 L p F P
0 g
s
.118 0 0 r
.57247 .18611 m .61409 .16611 L .62761 .14564 L p F P
0 g
s
.79 .912 .923 r
.75404 .36402 m .71335 .39804 L .73905 .40585 L p F P
0 g
s
.79 .912 .923 r
.73905 .40585 m .77634 .37132 L .75404 .36402 L p F P
0 g
s
.134 0 .313 r
.53712 .24846 m .56804 .22023 L .57247 .18611 L p F P
0 g
s
.339 .22 .568 r
.56804 .22023 m .53712 .24846 L .54211 .28654 L p F P
0 g
s
.144 .208 .671 r
.84068 .20812 m .86631 .19393 L .84636 .22421 L closepath p F P
0 g
s
.2 .335 .777 r
.83279 .19273 m .86631 .19393 L .84068 .20812 L closepath p F P
0 g
s
0 .396 .735 r
.74814 .14654 m .80557 .16715 L .81414 .17094 L p F P
0 g
s
.529 0 0 r
.80557 .16715 m .74814 .14654 L .73515 .14976 L p F P
0 g
s
.375 0 0 r
.67746 .14089 m .73515 .14976 L .74814 .14654 L p F P
0 g
s
.398 .137 .397 r
.61409 .16611 m .57247 .18611 L .56804 .22023 L p F P
0 g
s
.179 .418 .854 r
.82359 .17983 m .86631 .19393 L .83279 .19273 L closepath p F P
0 g
s
0 .002 .505 r
.84636 .22421 m .86631 .19393 L .84915 .23914 L closepath p F P
0 g
s
.494 .595 .883 r
.61352 .35642 m .57635 .3669 L .6011 .39853 L p F P
0 g
s
.494 .595 .883 r
.6011 .39853 m .64176 .39291 L .61352 .35642 L p F P
0 g
s
.582 .16 .206 r
.73515 .14976 m .67746 .14089 L .66611 .15894 L p F P
0 g
s
.43 .001 .122 r
.61409 .16611 m .66611 .15894 L .67746 .14089 L p F P
0 g
s
.929 .971 .739 r
.83857 .26109 m .80913 .32188 L .82146 .31705 L p F P
0 g
s
.929 .971 .739 r
.82146 .31705 m .84505 .2588 L .83857 .26109 L p F P
0 g
s
.042 .443 .874 r
.81414 .17094 m .86631 .19393 L .82359 .17983 L closepath p F P
0 g
s
.648 .76 .931 r
.68455 .37436 m .64176 .39291 L .67078 .4162 L p F P
0 g
s
.648 .76 .931 r
.67078 .4162 m .71335 .39804 L .68455 .37436 L p F P
0 g
s
0 0 .182 r
.84915 .23914 m .86631 .19393 L .84871 .25116 L closepath p F P
0 g
s
.862 .894 .857 r
.79282 .316 m .75404 .36402 L .77634 .37132 L p F P
0 g
s
.862 .894 .857 r
.77634 .37132 m .80913 .32188 L .79282 .316 L p F P
0 g
s
0 .296 .648 r
.80557 .16715 m .86631 .19393 L .81414 .17094 L closepath p F P
0 g
s
.339 .22 .568 r
.54211 .28654 m .57402 .26387 L .56804 .22023 L p F P
0 g
s
.431 .38 .701 r
.57402 .26387 m .54211 .28654 L .55577 .32784 L p F P
0 g
s
.785 .833 .365 r
.84871 .25116 m .86631 .19393 L .84505 .2588 L closepath p F P
0 g
s
.477 .493 .796 r
.58987 .3114 m .55577 .32784 L .57635 .3669 L p F P
0 g
s
.477 .493 .796 r
.57635 .3669 m .61352 .35642 L .58987 .3114 L p F P
0 g
s
.557 .269 .434 r
.66611 .15894 m .61409 .16611 L .6101 .20029 L p F P
0 g
s
.398 .137 .397 r
.56804 .22023 m .6101 .20029 L .61409 .16611 L p F P
0 g
s
.431 .38 .701 r
.55577 .32784 m .58987 .3114 L .57402 .26387 L p F P
0 g
s
.529 0 0 r
.73515 .14976 m .7989 .16898 L .80557 .16715 L p F P
0 g
s
.654 .239 .245 r
.7989 .16898 m .73515 .14976 L .72721 .16329 L p F P
0 g
s
.582 .16 .206 r
.66611 .15894 m .72721 .16329 L .73515 .14976 L p F P
0 g
s
.586 .037 0 r
.7989 .16898 m .86631 .19393 L .80557 .16715 L closepath p F P
0 g
s
.505 .335 .585 r
.6101 .20029 m .56804 .22023 L .57402 .26387 L p F P
0 g
s
.751 .776 .873 r
.72899 .34278 m .68455 .37436 L .71335 .39804 L p F P
0 g
s
.751 .776 .873 r
.71335 .39804 m .75404 .36402 L .72899 .34278 L p F P
0 g
s
.893 .877 .813 r
.83001 .25768 m .79282 .316 L .80913 .32188 L p F P
0 g
s
.893 .877 .813 r
.80913 .32188 m .83857 .26109 L .83001 .25768 L p F P
0 g
s
.948 .956 .72 r
.84505 .2588 m .86631 .19393 L .83857 .26109 L closepath p F P
0 g
s
.627 .647 .851 r
.65635 .33744 m .61352 .35642 L .64176 .39291 L p F P
0 g
s
.627 .647 .851 r
.64176 .39291 m .68455 .37436 L .65635 .33744 L p F P
0 g
s
.644 .344 .448 r
.72721 .16329 m .66611 .15894 L .66311 .18907 L p F P
0 g
s
.557 .269 .434 r
.6101 .20029 m .66311 .18907 L .66611 .15894 L p F P
0 g
s
.682 .271 .259 r
.79497 .17629 m .86631 .19393 L .7989 .16898 L closepath p F P
0 g
s
.654 .239 .245 r
.72721 .16329 m .79497 .17629 L .7989 .16898 L p F P
0 g
s
.806 .777 .826 r
.77448 .29989 m .72899 .34278 L .75404 .36402 L p F P
0 g
s
.806 .777 .826 r
.75404 .36402 m .79282 .316 L .77448 .29989 L p F P
0 g
s
.905 .869 .793 r
.83857 .26109 m .86631 .19393 L .83001 .25768 L closepath p F P
0 g
s
.69 .384 .453 r
.79497 .17629 m .72721 .16329 L .72544 .18572 L p F P
0 g
s
.644 .344 .448 r
.66311 .18907 m .72544 .18572 L .72721 .16329 L p F P
0 g
s
.505 .335 .585 r
.57402 .26387 m .61646 .24414 L .6101 .20029 L p F P
0 g
s
.56 .457 .694 r
.61646 .24414 m .57402 .26387 L .58987 .3114 L p F P
0 g
s
.611 .41 .584 r
.66311 .18907 m .6101 .20029 L .61646 .24414 L p F P
0 g
s
.834 .774 .795 r
.82041 .24891 m .77448 .29989 L .79282 .316 L p F P
0 g
s
.834 .774 .795 r
.79282 .316 m .83001 .25768 L .82041 .24891 L p F P
0 g
s
.598 .553 .775 r
.63258 .292 m .58987 .3114 L .61352 .35642 L p F P
0 g
s
.598 .553 .775 r
.61352 .35642 m .65635 .33744 L .63258 .292 L p F P
0 g
s
.71 .402 .454 r
.79431 .18826 m .86631 .19393 L .79497 .17629 L closepath p F P
0 g
s
.69 .384 .453 r
.72544 .18572 m .79431 .18826 L .79497 .17629 L p F P
0 g
s
.846 .772 .78 r
.83001 .25768 m .86631 .19393 L .82041 .24891 L closepath p F P
0 g
s
.712 .674 .811 r
.70437 .31001 m .65635 .33744 L .68455 .37436 L p F P
0 g
s
.712 .674 .811 r
.68455 .37436 m .72899 .34278 L .70437 .31001 L p F P
0 g
s
.727 .489 .566 r
.79702 .20346 m .86631 .19393 L .79431 .18826 L closepath p F P
0 g
s
.745 .558 .642 r
.80281 .21999 m .86631 .19393 L .79702 .20346 L closepath p F P
0 g
s
.769 .624 .699 r
.81095 .23581 m .86631 .19393 L .80281 .21999 L closepath p F P
0 g
s
.802 .693 .744 r
.82041 .24891 m .86631 .19393 L .81095 .23581 L closepath p F P
0 g
s
.56 .457 .694 r
.58987 .3114 m .63258 .292 L .61646 .24414 L p F P
0 g
s
.675 .454 .577 r
.72544 .18572 m .66311 .18907 L .6691 .22769 L p F P
0 g
s
.611 .41 .584 r
.61646 .24414 m .6691 .22769 L .66311 .18907 L p F P
0 g
s
.711 .478 .57 r
.79431 .18826 m .72544 .18572 L .73021 .21436 L p F P
0 g
s
.711 .478 .57 r
.73021 .21436 m .79702 .20346 L .79431 .18826 L p F P
0 g
s
.789 .691 .756 r
.77448 .29989 m .82041 .24891 L .81095 .23581 L p F P
0 g
s
.675 .454 .577 r
.6691 .22769 m .73021 .21436 L .72544 .18572 L p F P
0 g
s
.761 .685 .778 r
.75642 .2754 m .70437 .31001 L .72899 .34278 L p F P
0 g
s
.761 .685 .778 r
.72899 .34278 m .77448 .29989 L .75642 .2754 L p F P
0 g
s
.789 .691 .756 r
.81095 .23581 m .75642 .2754 L .77448 .29989 L p F P
0 g
s
.731 .551 .648 r
.79702 .20346 m .73021 .21436 L .74099 .2456 L p F P
0 g
s
.731 .551 .648 r
.74099 .2456 m .80281 .21999 L .79702 .20346 L p F P
0 g
s
.647 .506 .677 r
.6691 .22769 m .61646 .24414 L .63258 .292 L p F P
0 g
s
.756 .619 .707 r
.75642 .2754 m .81095 .23581 L .80281 .21999 L p F P
0 g
s
.756 .619 .707 r
.80281 .21999 m .74099 .2456 L .75642 .2754 L p F P
0 g
s
.678 .589 .748 r
.68347 .26988 m .63258 .292 L .65635 .33744 L p F P
0 g
s
.678 .589 .748 r
.65635 .33744 m .70437 .31001 L .68347 .26988 L p F P
0 g
s
.647 .506 .677 r
.63258 .292 m .68347 .26988 L .6691 .22769 L p F P
0 g
s
.7 .535 .661 r
.73021 .21436 m .6691 .22769 L .68347 .26988 L p F P
0 g
s
.7 .535 .661 r
.68347 .26988 m .74099 .2456 L .73021 .21436 L p F P
0 g
s
.728 .609 .724 r
.70437 .31001 m .75642 .2754 L .74099 .2456 L p F P
0 g
s
.728 .609 .724 r
.74099 .2456 m .68347 .26988 L .70437 .31001 L p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.840136 0.257081 0.97619 0.603319 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0151059 1.01511 -0.144419 1.01511 [
[ 0 0 0 0 ]
[ 1 .67778 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .67778 L
0 .67778 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.644 .513 .688 r
.35954 .4315 m .31687 .44024 L .30975 .39631 L p F P
0 g
s
.644 .513 .688 r
.30975 .39631 m .35231 .38741 L .35954 .4315 L p F P
0 g
s
.658 .582 .758 r
.35231 .38741 m .30975 .39631 L .29775 .35392 L p F P
0 g
s
.712 .559 .679 r
.26246 .40677 m .30975 .39631 L .31687 .44024 L p F P
0 g
s
.725 .622 .743 r
.30975 .39631 m .26246 .40677 L .25178 .3695 L p F P
0 g
s
.725 .622 .743 r
.25178 .3695 m .29775 .35392 L .30975 .39631 L p F P
0 g
s
.712 .559 .679 r
.31687 .44024 m .26864 .44544 L .26246 .40677 L p F P
0 g
s
.756 .589 .67 r
.21038 .41874 m .26246 .40677 L .26864 .44544 L p F P
0 g
s
.769 .647 .727 r
.26246 .40677 m .21038 .41874 L .20232 .39097 L p F P
0 g
s
.769 .647 .727 r
.20232 .39097 m .25178 .3695 L .26246 .40677 L p F P
0 g
s
.621 .431 .603 r
.36128 .47238 m .31832 .48102 L .31687 .44024 L p F P
0 g
s
.621 .431 .603 r
.31687 .44024 m .35954 .4315 L .36128 .47238 L p F P
0 g
s
.698 .491 .603 r
.26864 .44544 m .31687 .44024 L .31832 .48102 L p F P
0 g
s
.698 .491 .603 r
.31832 .48102 m .26964 .48133 L .26864 .44544 L p F P
0 g
s
.748 .53 .6 r
.21493 .44759 m .26864 .44544 L .26964 .48133 L p F P
0 g
s
.756 .589 .67 r
.26864 .44544 m .21493 .44759 L .21038 .41874 L p F P
0 g
s
.658 .582 .758 r
.29775 .35392 m .34039 .34482 L .35231 .38741 L p F P
0 g
s
.666 .655 .829 r
.34039 .34482 m .29775 .35392 L .28212 .31765 L p F P
0 g
s
.741 .691 .804 r
.29775 .35392 m .25178 .3695 L .23773 .33772 L p F P
0 g
s
.741 .691 .804 r
.23773 .33772 m .28212 .31765 L .29775 .35392 L p F P
0 g
s
.787 .712 .78 r
.25178 .3695 m .20232 .39097 L .19162 .36742 L p F P
0 g
s
.787 .712 .78 r
.19162 .36742 m .23773 .33772 L .25178 .3695 L p F P
0 g
s
.554 .45 .69 r
.39719 .41905 m .35954 .4315 L .35231 .38741 L p F P
0 g
s
.554 .45 .69 r
.35231 .38741 m .39071 .37995 L .39719 .41905 L p F P
0 g
s
.568 .526 .768 r
.39071 .37995 m .35231 .38741 L .34039 .34482 L p F P
0 g
s
.516 .35 .594 r
.39895 .45522 m .36128 .47238 L .35954 .4315 L p F P
0 g
s
.516 .35 .594 r
.35954 .4315 m .39719 .41905 L .39895 .45522 L p F P
0 g
s
.783 .607 .662 r
.15405 .43199 m .21038 .41874 L .21493 .44759 L p F P
0 g
s
.795 .661 .716 r
.21038 .41874 m .15405 .43199 L .14967 .41712 L p F P
0 g
s
.795 .661 .716 r
.14967 .41712 m .20232 .39097 L .21038 .41874 L p F P
0 g
s
.568 .526 .768 r
.34039 .34482 m .38024 .34216 L .39071 .37995 L p F P
0 g
s
.562 .597 .846 r
.38024 .34216 m .34039 .34482 L .32501 .30834 L p F P
0 g
s
.666 .655 .829 r
.28212 .31765 m .32501 .30834 L .34039 .34482 L p F P
0 g
s
.748 .53 .6 r
.26964 .48133 m .21544 .47433 L .21493 .44759 L p F P
0 g
s
.776 .553 .597 r
.15645 .44748 m .21493 .44759 L .21544 .47433 L p F P
0 g
s
.783 .607 .662 r
.21493 .44759 m .15645 .44748 L .15405 .43199 L p F P
0 g
s
.814 .722 .764 r
.20232 .39097 m .14967 .41712 L .14381 .4046 L p F P
0 g
s
.814 .722 .764 r
.14381 .4046 m .19162 .36742 L .20232 .39097 L p F P
0 g
s
.679 .4 .493 r
.31383 .51412 m .26525 .5104 L .26964 .48133 L p F P
0 g
s
.679 .4 .493 r
.26964 .48133 m .31832 .48102 L .31383 .51412 L p F P
0 g
s
.74 .458 .502 r
.21544 .47433 m .26964 .48133 L .26525 .5104 L p F P
0 g
s
.578 .31 .474 r
.35723 .50553 m .31383 .51412 L .31832 .48102 L p F P
0 g
s
.578 .31 .474 r
.31832 .48102 m .36128 .47238 L .35723 .50553 L p F P
0 g
s
.758 .779 .87 r
.28212 .31765 m .23773 .33772 L .22182 .31506 L p F P
0 g
s
.813 .793 .834 r
.23773 .33772 m .19162 .36742 L .17946 .35082 L p F P
0 g
s
.813 .793 .834 r
.17946 .35082 m .22182 .31506 L .23773 .33772 L p F P
0 g
s
.662 .743 .911 r
.32501 .30834 m .28212 .31765 L .26449 .29161 L p F P
0 g
s
.758 .779 .87 r
.22182 .31506 m .26449 .29161 L .28212 .31765 L p F P
0 g
s
.74 .458 .502 r
.26525 .5104 m .2118 .49588 L .21544 .47433 L p F P
0 g
s
.774 .491 .507 r
.15659 .46179 m .21544 .47433 L .2118 .49588 L p F P
0 g
s
.776 .553 .597 r
.21544 .47433 m .15659 .46179 L .15645 .44748 L p F P
0 g
s
.432 .186 .439 r
.39573 .48441 m .35723 .50553 L .36128 .47238 L p F P
0 g
s
.432 .186 .439 r
.36128 .47238 m .39895 .45522 L .39573 .48441 L p F P
0 g
s
.842 .798 .808 r
.19162 .36742 m .14381 .4046 L .13714 .39589 L p F P
0 g
s
.842 .798 .808 r
.13714 .39589 m .17946 .35082 L .19162 .36742 L p F P
0 g
s
.451 .377 .683 r
.43087 .40309 m .39719 .41905 L .39071 .37995 L p F P
0 g
s
.451 .377 .683 r
.39071 .37995 m .42595 .37369 L .43087 .40309 L p F P
0 g
s
.465 .459 .767 r
.42595 .37369 m .39071 .37995 L .38024 .34216 L p F P
0 g
s
.795 .615 .658 r
.09466 .44613 m .15405 .43199 L .15645 .44748 L closepath p F P
0 g
s
.806 .667 .71 r
.09466 .44613 m .14967 .41712 L .15405 .43199 L closepath p F P
0 g
s
.562 .597 .846 r
.32501 .30834 m .36688 .30981 L .38024 .34216 L p F P
0 g
s
.515 .672 .935 r
.36688 .30981 m .32501 .30834 L .3078 .28209 L p F P
0 g
s
.662 .743 .911 r
.26449 .29161 m .3078 .28209 L .32501 .30834 L p F P
0 g
s
.396 .258 .574 r
.43234 .43017 m .39895 .45522 L .39719 .41905 L p F P
0 g
s
.396 .258 .574 r
.39719 .41905 m .43087 .40309 L .43234 .43017 L p F P
0 g
s
.789 .564 .595 r
.09466 .44613 m .15645 .44748 L .15659 .46179 L closepath p F P
0 g
s
.826 .726 .755 r
.09466 .44613 m .14381 .4046 L .14967 .41712 L closepath p F P
0 g
s
.465 .459 .767 r
.38024 .34216 m .41815 .34527 L .42595 .37369 L p F P
0 g
s
.44 .523 .847 r
.41815 .34527 m .38024 .34216 L .36688 .30981 L p F P
0 g
s
.774 .491 .507 r
.2118 .49588 m .15443 .47324 L .15659 .46179 L p F P
0 g
s
.789 .507 .509 r
.09466 .44613 m .15659 .46179 L .15443 .47324 L closepath p F P
0 g
s
.633 .243 .288 r
.30373 .53558 m .25582 .52917 L .26525 .5104 L p F P
0 g
s
.633 .243 .288 r
.26525 .5104 m .31383 .51412 L .30373 .53558 L p F P
0 g
s
.725 .347 .334 r
.2118 .49588 m .26525 .5104 L .25582 .52917 L p F P
0 g
s
.855 .799 .796 r
.09466 .44613 m .13714 .39589 L .14381 .4046 L closepath p F P
0 g
s
.725 .347 .334 r
.25582 .52917 m .20435 .50965 L .2118 .49588 L p F P
0 g
s
.771 .403 .359 r
.15443 .47324 m .2118 .49588 L .20435 .50965 L p F P
0 g
s
.463 .071 .209 r
.34767 .52697 m .30373 .53558 L .31383 .51412 L p F P
0 g
s
.463 .071 .209 r
.31383 .51412 m .35723 .50553 L .34767 .52697 L p F P
0 g
s
.763 .902 .938 r
.26449 .29161 m .22182 .31506 L .20581 .30439 L p F P
0 g
s
.842 .905 .88 r
.22182 .31506 m .17946 .35082 L .16723 .34325 L p F P
0 g
s
.842 .905 .88 r
.16723 .34325 m .20581 .30439 L .22182 .31506 L p F P
0 g
s
.879 .898 .841 r
.17946 .35082 m .13714 .39589 L .13045 .39209 L p F P
0 g
s
.879 .898 .841 r
.13045 .39209 m .16723 .34325 L .17946 .35082 L p F P
0 g
s
.26 .046 .388 r
.43016 .45186 m .39573 .48441 L .39895 .45522 L p F P
0 g
s
.26 .046 .388 r
.39895 .45522 m .43234 .43017 L .43016 .45186 L p F P
0 g
s
.771 .403 .359 r
.20435 .50965 m .15021 .48045 L .15443 .47324 L p F P
0 g
s
.791 .428 .37 r
.09466 .44613 m .15443 .47324 L .15021 .48045 L closepath p F P
0 g
s
.597 .854 .993 r
.3078 .28209 m .26449 .29161 L .24681 .27912 L p F P
0 g
s
.763 .902 .938 r
.20581 .30439 m .24681 .27912 L .26449 .29161 L p F P
0 g
s
.893 .893 .822 r
.09466 .44613 m .13045 .39209 L .13714 .39589 L closepath p F P
0 g
s
.44 .523 .847 r
.36688 .30981 m .40832 .321 L .41815 .34527 L p F P
0 g
s
.334 .567 .924 r
.40832 .321 m .36688 .30981 L .35207 .28659 L p F P
0 g
s
.515 .672 .935 r
.3078 .28209 m .35207 .28659 L .36688 .30981 L p F P
0 g
s
.197 0 .09 r
.38774 .50311 m .34767 .52697 L .35723 .50553 L p F P
0 g
s
.197 0 .09 r
.35723 .50553 m .39573 .48441 L .38774 .50311 L p F P
0 g
s
.108 .024 .47 r
.09466 .44613 m .11783 .42665 L .11778 .41207 L closepath p F P
0 g
s
.218 .206 .631 r
.09466 .44613 m .12027 .44258 L .11783 .42665 L closepath p F P
0 g
s
.231 .306 .735 r
.09466 .44613 m .12481 .45784 L .12027 .44258 L closepath p F P
0 g
s
.765 .287 .106 r
.09466 .44613 m .15021 .48045 L .14439 .48251 L closepath p F P
0 g
s
.146 .349 .807 r
.09466 .44613 m .13087 .47053 L .12481 .45784 L closepath p F P
0 g
s
.563 0 0 r
.09466 .44613 m .14439 .48251 L .13768 .47909 L closepath p F P
0 g
s
0 .286 .779 r
.09466 .44613 m .13768 .47909 L .13087 .47053 L closepath p F P
0 g
s
.903 .985 .773 r
.09466 .44613 m .12453 .3937 L .13045 .39209 L closepath p F P
0 g
s
.667 .834 .411 r
.09466 .44613 m .12012 .40062 L .12453 .3937 L closepath p F P
0 g
s
0 0 .155 r
.09466 .44613 m .11778 .41207 L .12012 .40062 L closepath p F P
0 g
s
.731 .237 .064 r
.19388 .51382 m .14439 .48251 L .15021 .48045 L p F P
0 g
s
.731 .237 .064 r
.15021 .48045 m .20435 .50965 L .19388 .51382 L p F P
0 g
s
.312 .709 .979 r
.35207 .28659 m .3078 .28209 L .29066 .26941 L p F P
0 g
s
.597 .854 .993 r
.24681 .27912 m .29066 .26941 L .3078 .28209 L p F P
0 g
s
.361 .313 .669 r
.46203 .38414 m .43087 .40309 L .42595 .37369 L p F P
0 g
s
.361 .313 .669 r
.42595 .37369 m .45935 .36825 L .46203 .38414 L p F P
0 g
s
.374 .398 .757 r
.45935 .36825 m .42595 .37369 L .41815 .34527 L p F P
0 g
s
.876 .994 .789 r
.16723 .34325 m .13045 .39209 L .12453 .3937 L p F P
0 g
s
.641 .114 0 r
.24229 .53507 m .19388 .51382 L .20435 .50965 L p F P
0 g
s
.641 .114 0 r
.20435 .50965 m .25582 .52917 L .24229 .53507 L p F P
0 g
s
.29 .179 .55 r
.4629 .39871 m .43234 .43017 L .43087 .40309 L p F P
0 g
s
.29 .179 .55 r
.43087 .40309 m .46203 .38414 L .4629 .39871 L p F P
0 g
s
.374 .398 .757 r
.41815 .34527 m .45517 .35287 L .45935 .36825 L p F P
0 g
s
.33 .453 .834 r
.45517 .35287 m .41815 .34527 L .40832 .321 L p F P
0 g
s
.797 .999 .819 r
.20581 .30439 m .16723 .34325 L .15639 .34584 L p F P
0 g
s
.876 .994 .789 r
.12453 .3937 m .15639 .34584 L .16723 .34325 L p F P
0 g
s
.437 0 0 r
.28898 .54242 m .24229 .53507 L .25582 .52917 L p F P
0 g
s
.437 0 0 r
.25582 .52917 m .30373 .53558 L .28898 .54242 L p F P
0 g
s
0 0 0 r
.4245 .46553 m .38774 .50311 L .39573 .48441 L p F P
0 g
s
0 0 0 r
.39573 .48441 m .43016 .45186 L .4245 .46553 L p F P
0 g
s
.467 0 0 r
.18157 .50761 m .13768 .47909 L .14439 .48251 L p F P
0 g
s
.467 0 0 r
.14439 .48251 m .19388 .51382 L .18157 .50761 L p F P
0 g
s
0 0 0 r
.15639 .34584 m .12453 .3937 L .12012 .40062 L p F P
0 g
s
.11 0 .337 r
.46185 .41026 m .43016 .45186 L .43234 .43017 L p F P
0 g
s
.11 0 .337 r
.43234 .43017 m .4629 .39871 L .46185 .41026 L p F P
0 g
s
.593 .947 .83 r
.24681 .27912 m .20581 .30439 L .1916 .30741 L p F P
0 g
s
.797 .999 .819 r
.15639 .34584 m .1916 .30741 L .20581 .30439 L p F P
0 g
s
.334 .567 .924 r
.35207 .28659 m .39754 .30371 L .40832 .321 L p F P
0 g
s
0 .48 .858 r
.39754 .30371 m .35207 .28659 L .33746 .27544 L p F P
0 g
s
.312 .709 .979 r
.29066 .26941 m .33746 .27544 L .35207 .28659 L p F P
0 g
s
.039 0 0 r
.33351 .5337 m .28898 .54242 L .30373 .53558 L p F P
0 g
s
.039 0 0 r
.30373 .53558 m .34767 .52697 L .33351 .5337 L p F P
0 g
s
.33 .453 .834 r
.40832 .321 m .44997 .3398 L .45517 .35287 L p F P
0 g
s
.174 .461 .885 r
.44997 .3398 m .40832 .321 L .39754 .30371 L p F P
0 g
s
.17 .703 .709 r
.29066 .26941 m .24681 .27912 L .23118 .28219 L p F P
0 g
s
.593 .947 .83 r
.1916 .30741 m .23118 .28219 L .24681 .27912 L p F P
0 g
s
.006 .38 .842 r
.16893 .49152 m .13087 .47053 L .13768 .47909 L p F P
0 g
s
.006 .38 .842 r
.13768 .47909 m .18157 .50761 L .16893 .49152 L p F P
0 g
s
.424 .843 .678 r
.37576 .50874 m .33351 .5337 L .34767 .52697 L p F P
0 g
s
.424 .843 .678 r
.34767 .52697 m .38774 .50311 L .37576 .50874 L p F P
0 g
s
0 0 0 r
.12012 .40062 m .14829 .35857 L .15639 .34584 L p F P
0 g
s
0 0 .212 r
.14829 .35857 m .12012 .40062 L .11778 .41207 L p F P
0 g
s
.644 .513 .688 r
.75958 .34956 m .71365 .35897 L .70548 .31356 L p F P
0 g
s
.644 .513 .688 r
.70548 .31356 m .75128 .30398 L .75958 .34956 L p F P
0 g
s
.658 .582 .758 r
.75128 .30398 m .70548 .31356 L .69424 .26933 L p F P
0 g
s
.712 .558 .678 r
.65678 .32433 m .70548 .31356 L .71365 .35897 L p F P
0 g
s
.726 .624 .744 r
.70548 .31356 m .65678 .32433 L .64677 .28545 L p F P
0 g
s
.726 .624 .744 r
.64677 .28545 m .69424 .26933 L .70548 .31356 L p F P
0 g
s
0 .336 .699 r
.22618 .52689 m .18157 .50761 L .19388 .51382 L p F P
0 g
s
0 .336 .699 r
.19388 .51382 m .24229 .53507 L .22618 .52689 L p F P
0 g
s
.712 .558 .678 r
.71365 .35897 m .66389 .36431 L .65678 .32433 L p F P
0 g
s
.76 .59 .667 r
.60488 .33631 m .65678 .32433 L .66389 .36431 L p F P
0 g
s
.774 .652 .728 r
.65678 .32433 m .60488 .33631 L .5973 .30733 L p F P
0 g
s
.774 .652 .728 r
.5973 .30733 m .64677 .28545 L .65678 .32433 L p F P
0 g
s
.621 .431 .603 r
.76414 .39142 m .71788 .40072 L .71365 .35897 L p F P
0 g
s
.621 .431 .603 r
.71365 .35897 m .75958 .34956 L .76414 .39142 L p F P
0 g
s
.697 .486 .598 r
.66389 .36431 m .71365 .35897 L .71788 .40072 L p F P
0 g
s
0 0 0 r
.1916 .30741 m .15639 .34584 L .14829 .35857 L p F P
0 g
s
0 0 0 r
.45896 .41739 m .4245 .46553 L .43016 .45186 L p F P
0 g
s
0 0 0 r
.43016 .45186 m .46185 .41026 L .45896 .41739 L p F P
0 g
s
.697 .486 .598 r
.71788 .40072 m .66731 .40105 L .66389 .36431 L p F P
0 g
s
.75 .526 .59 r
.61011 .36614 m .66389 .36431 L .66731 .40105 L p F P
0 g
s
.76 .59 .667 r
.66389 .36431 m .61011 .36614 L .60488 .33631 L p F P
0 g
s
.238 .41 .832 r
.15756 .46739 m .12481 .45784 L .13087 .47053 L p F P
0 g
s
.238 .41 .832 r
.13087 .47053 m .16893 .49152 L .15756 .46739 L p F P
0 g
s
.17 .703 .709 r
.23118 .28219 m .2756 .27235 L .29066 .26941 L p F P
0 g
s
.289 0 0 r
.33746 .27544 m .29066 .26941 L .2756 .27235 L p F P
0 g
s
.658 .582 .758 r
.69424 .26933 m .74014 .25954 L .75128 .30398 L p F P
0 g
s
.666 .655 .829 r
.74014 .25954 m .69424 .26933 L .68113 .23103 L p F P
0 g
s
.742 .696 .808 r
.69424 .26933 m .64677 .28545 L .63491 .25189 L p F P
0 g
s
.742 .696 .808 r
.63491 .25189 m .68113 .23103 L .69424 .26933 L p F P
0 g
s
.793 .722 .786 r
.64677 .28545 m .5973 .30733 L .58823 .28247 L p F P
0 g
s
.793 .722 .786 r
.58823 .28247 m .63491 .25189 L .64677 .28545 L p F P
0 g
s
.196 .092 .501 r
.14403 .38008 m .11778 .41207 L .11783 .42665 L p F P
0 g
s
0 0 .212 r
.11778 .41207 m .14403 .38008 L .14829 .35857 L p F P
0 g
s
.562 .456 .692 r
.80229 .3359 m .75958 .34956 L .75128 .30398 L p F P
0 g
s
.562 .456 .692 r
.75128 .30398 m .79485 .29547 L .80229 .3359 L p F P
0 g
s
.576 .529 .766 r
.79485 .29547 m .75128 .30398 L .74014 .25954 L p F P
0 g
s
.174 .461 .885 r
.39754 .30371 m .44434 .33058 L .44997 .3398 L p F P
0 g
s
0 .288 .717 r
.44434 .33058 m .39754 .30371 L .38705 .29554 L p F P
0 g
s
0 .48 .858 r
.33746 .27544 m .38705 .29554 L .39754 .30371 L p F P
0 g
s
.696 .963 .721 r
.41594 .46936 m .37576 .50874 L .38774 .50311 L p F P
0 g
s
.696 .963 .721 r
.38774 .50311 m .4245 .46553 L .41594 .46936 L p F P
0 g
s
.159 .648 .92 r
.27119 .53316 m .22618 .52689 L .24229 .53507 L p F P
0 g
s
.159 .648 .92 r
.24229 .53507 m .28898 .54242 L .27119 .53316 L p F P
0 g
s
.305 .357 .752 r
.14895 .43823 m .12027 .44258 L .12481 .45784 L p F P
0 g
s
.305 .357 .752 r
.12481 .45784 m .15756 .46739 L .14895 .43823 L p F P
0 g
s
.196 .092 .501 r
.11783 .42665 m .14425 .40781 L .14403 .38008 L p F P
0 g
s
.291 .26 .65 r
.14425 .40781 m .11783 .42665 L .12027 .44258 L p F P
0 g
s
.528 .363 .601 r
.8066 .37294 m .76414 .39142 L .75958 .34956 L p F P
0 g
s
.528 .363 .601 r
.75958 .34956 m .80229 .3359 L .8066 .37294 L p F P
0 g
s
.79 .61 .657 r
.54988 .34934 m .60488 .33631 L .61011 .36614 L p F P
0 g
s
.803 .669 .716 r
.60488 .33631 m .54988 .34934 L .54576 .33382 L p F P
0 g
s
.803 .669 .716 r
.54576 .33382 m .5973 .30733 L .60488 .33631 L p F P
0 g
s
.309 .276 .659 r
.45935 .36825 m .49245 .36313 L .46203 .38414 L closepath p F P
0 g
s
.322 .362 .748 r
.45517 .35287 m .49245 .36313 L .45935 .36825 L closepath p F P
0 g
s
.291 .26 .65 r
.12027 .44258 m .14895 .43823 L .14425 .40781 L p F P
0 g
s
.576 .529 .766 r
.74014 .25954 m .78509 .25601 L .79485 .29547 L p F P
0 g
s
.572 .597 .84 r
.78509 .25601 m .74014 .25954 L .72733 .221 L p F P
0 g
s
.666 .655 .829 r
.68113 .23103 m .72733 .221 L .74014 .25954 L p F P
0 g
s
.229 .134 .534 r
.46203 .38414 m .49245 .36313 L .4629 .39871 L closepath p F P
0 g
s
.75 .526 .59 r
.66731 .40105 m .61241 .39352 L .61011 .36614 L p F P
0 g
s
.782 .55 .584 r
.55265 .36536 m .61011 .36614 L .61241 .39352 L p F P
0 g
s
.79 .61 .657 r
.61011 .36614 m .55265 .36536 L .54988 .34934 L p F P
0 g
s
.267 .411 .821 r
.44997 .3398 m .49245 .36313 L .45517 .35287 L closepath p F P
0 g
s
.551 0 0 r
.38705 .29554 m .33746 .27544 L .3248 .27812 L p F P
0 g
s
.289 0 0 r
.2756 .27235 m .3248 .27812 L .33746 .27544 L p F P
0 g
s
.047 0 0 r
.23118 .28219 m .1916 .30741 L .18102 .32425 L p F P
0 g
s
0 0 0 r
.14829 .35857 m .18102 .32425 L .1916 .30741 L p F P
0 g
s
.824 .736 .768 r
.5973 .30733 m .54576 .33382 L .54076 .32059 L p F P
0 g
s
.824 .736 .768 r
.54076 .32059 m .58823 .28247 L .5973 .30733 L p F P
0 g
s
.675 .389 .479 r
.71762 .4342 m .66659 .43046 L .66731 .40105 L p F P
0 g
s
.675 .389 .479 r
.66731 .40105 m .71788 .40072 L .71762 .4342 L p F P
0 g
s
.741 .444 .479 r
.61241 .39352 m .66731 .40105 L .66659 .43046 L p F P
0 g
s
.578 .31 .474 r
.76439 .42494 m .71762 .4342 L .71788 .40072 L p F P
0 g
s
.578 .31 .474 r
.71788 .40072 m .76414 .39142 L .76439 .42494 L p F P
0 g
s
.228 .532 .921 r
.20941 .50517 m .16893 .49152 L .18157 .50761 L p F P
0 g
s
.228 .532 .921 r
.18157 .50761 m .22618 .52689 L .20941 .50517 L p F P
0 g
s
.028 0 .307 r
.4629 .39871 m .49245 .36313 L .46185 .41026 L closepath p F P
0 g
s
.533 .863 .995 r
.31628 .52428 m .27119 .53316 L .28898 .54242 L p F P
0 g
s
.533 .863 .995 r
.28898 .54242 m .33351 .5337 L .31628 .52428 L p F P
0 g
s
.086 .398 .854 r
.44434 .33058 m .49245 .36313 L .44997 .3398 L closepath p F P
0 g
s
.759 .79 .878 r
.68113 .23103 m .63491 .25189 L .6225 .22748 L p F P
0 g
s
.82 .813 .843 r
.63491 .25189 m .58823 .28247 L .57865 .26458 L p F P
0 g
s
.82 .813 .843 r
.57865 .26458 m .6225 .22748 L .63491 .25189 L p F P
0 g
s
.662 .743 .911 r
.72733 .221 m .68113 .23103 L .66753 .20298 L p F P
0 g
s
.759 .79 .878 r
.6225 .22748 m .66753 .20298 L .68113 .23103 L p F P
0 g
s
.152 0 .302 r
.18102 .32425 m .14829 .35857 L .14403 .38008 L p F P
0 g
s
.809 .983 .709 r
.45458 .41918 m .41594 .46936 L .4245 .46553 L p F P
0 g
s
.809 .983 .709 r
.4245 .46553 m .45896 .41739 L .45458 .41918 L p F P
0 g
s
.741 .444 .479 r
.66659 .43046 m .61149 .41531 L .61241 .39352 L p F P
0 g
s
.782 .55 .584 r
.61241 .39352 m .55375 .38001 L .55265 .36536 L p F P
0 g
s
.779 .477 .478 r
.55375 .38001 m .61241 .39352 L .61149 .41531 L p F P
0 g
s
.454 .214 .46 r
.80724 .40244 m .76439 .42494 L .76414 .39142 L p F P
0 g
s
.454 .214 .46 r
.76414 .39142 m .8066 .37294 L .80724 .40244 L p F P
0 g
s
0 .288 .717 r
.38705 .29554 m .43896 .32634 L .44434 .33058 L p F P
0 g
s
.667 .122 0 r
.43896 .32634 m .38705 .29554 L .37811 .29773 L p F P
0 g
s
.551 0 0 r
.3248 .27812 m .37811 .29773 L .38705 .29554 L p F P
0 g
s
.855 .823 .816 r
.58823 .28247 m .54076 .32059 L .53546 .31121 L p F P
0 g
s
.855 .823 .816 r
.53546 .31121 m .57865 .26458 L .58823 .28247 L p F P
0 g
s
.478 .399 .688 r
.84276 .31819 m .80229 .3359 L .79485 .29547 L p F P
0 g
s
.478 .399 .688 r
.79485 .29547 m .83711 .28778 L .84276 .31819 L p F P
0 g
s
.491 .473 .765 r
.83711 .28778 m .79485 .29547 L .78509 .25601 L p F P
0 g
s
0 0 0 r
.46185 .41026 m .49245 .36313 L .45896 .41739 L closepath p F P
0 g
s
.393 0 .096 r
.2756 .27235 m .23118 .28219 L .21961 .30112 L p F P
0 g
s
.047 0 0 r
.18102 .32425 m .21961 .30112 L .23118 .28219 L p F P
0 g
s
0 .192 .639 r
.43896 .32634 m .49245 .36313 L .44434 .33058 L closepath p F P
0 g
s
.746 .933 .949 r
.36111 .50013 m .31628 .52428 L .33351 .5337 L p F P
0 g
s
.746 .933 .949 r
.33351 .5337 m .37576 .50874 L .36111 .50013 L p F P
0 g
s
.803 .619 .652 r
.49245 .36313 m .54988 .34934 L .55265 .36536 L closepath p F P
0 g
s
.816 .676 .709 r
.49245 .36313 m .54576 .33382 L .54988 .34934 L closepath p F P
0 g
s
.572 .597 .84 r
.72733 .221 m .77404 .22182 L .78509 .25601 L p F P
0 g
s
.533 .67 .925 r
.77404 .22182 m .72733 .221 L .71421 .19271 L p F P
0 g
s
.662 .743 .911 r
.66753 .20298 m .71421 .19271 L .72733 .221 L p F P
0 g
s
.433 .295 .593 r
.84618 .34593 m .8066 .37294 L .80229 .3359 L p F P
0 g
s
.433 .295 .593 r
.80229 .3359 m .84276 .31819 L .84618 .34593 L p F P
0 g
s
.797 .561 .58 r
.49245 .36313 m .55265 .36536 L .55375 .38001 L closepath p F P
0 g
s
.838 .742 .759 r
.49245 .36313 m .54076 .32059 L .54576 .33382 L closepath p F P
0 g
s
.491 .473 .765 r
.78509 .25601 m .82985 .25809 L .83711 .28778 L p F P
0 g
s
.473 .534 .839 r
.82985 .25809 m .78509 .25601 L .77404 .22182 L p F P
0 g
s
.386 .505 .856 r
.19417 .47232 m .15756 .46739 L .16893 .49152 L p F P
0 g
s
.386 .505 .856 r
.16893 .49152 m .20941 .50517 L .19417 .47232 L p F P
0 g
s
.603 .177 .205 r
.3248 .27812 m .2756 .27235 L .2646 .29122 L p F P
0 g
s
.393 0 .096 r
.21961 .30112 m .2646 .29122 L .2756 .27235 L p F P
0 g
s
.467 .673 .954 r
.25251 .50833 m .20941 .50517 L .22618 .52689 L p F P
0 g
s
.467 .673 .954 r
.22618 .52689 m .27119 .53316 L .25251 .50833 L p F P
0 g
s
.843 .941 .887 r
.40545 .4626 m .36111 .50013 L .37576 .50874 L p F P
0 g
s
.843 .941 .887 r
.37576 .50874 m .41594 .46936 L .40545 .4626 L p F P
0 g
s
.339 .202 .544 r
.17554 .35325 m .14403 .38008 L .14425 .40781 L p F P
0 g
s
.152 0 .302 r
.14403 .38008 m .17554 .35325 L .18102 .32425 L p F P
0 g
s
.779 .477 .478 r
.61149 .41531 m .55303 .39158 L .55375 .38001 L p F P
0 g
s
.796 .493 .477 r
.49245 .36313 m .55375 .38001 L .55303 .39158 L closepath p F P
0 g
s
.848 .983 .696 r
.45896 .41739 m .49245 .36313 L .45458 .41918 L closepath p F P
0 g
s
.619 .212 .249 r
.71276 .45538 m .66171 .44897 L .66659 .43046 L p F P
0 g
s
.619 .212 .249 r
.66659 .43046 m .71762 .4342 L .71276 .45538 L p F P
0 g
s
.715 .308 .275 r
.61149 .41531 m .66659 .43046 L .66171 .44897 L p F P
0 g
s
.869 .826 .802 r
.49245 .36313 m .53546 .31121 L .54076 .32059 L closepath p F P
0 g
s
.715 .308 .275 r
.66171 .44897 m .60737 .42888 L .61149 .41531 L p F P
0 g
s
.767 .364 .29 r
.55303 .39158 m .61149 .41531 L .60737 .42888 L p F P
0 g
s
.711 .181 0 r
.43446 .32767 m .49245 .36313 L .43896 .32634 L closepath p F P
0 g
s
.667 .122 0 r
.37811 .29773 m .43446 .32767 L .43896 .32634 L p F P
0 g
s
.463 .071 .209 r
.76017 .44608 m .71276 .45538 L .71762 .4342 L p F P
0 g
s
.463 .071 .209 r
.71762 .4342 m .76439 .42494 L .76017 .44608 L p F P
0 g
s
.378 .116 .386 r
.21961 .30112 m .18102 .32425 L .17554 .35325 L p F P
0 g
s
.756 .918 .945 r
.66753 .20298 m .6225 .22748 L .61092 .2153 L p F P
0 g
s
.844 .935 .886 r
.6225 .22748 m .57865 .26458 L .56967 .25591 L p F P
0 g
s
.844 .935 .886 r
.56967 .25591 m .61092 .2153 L .6225 .22748 L p F P
0 g
s
.712 .299 .261 r
.37811 .29773 m .3248 .27812 L .31571 .29481 L p F P
0 g
s
.603 .177 .205 r
.2646 .29122 m .31571 .29481 L .3248 .27812 L p F P
0 g
s
.887 .936 .843 r
.4492 .41534 m .40545 .4626 L .41594 .46936 L p F P
0 g
s
.887 .936 .843 r
.41594 .46936 m .45458 .41918 L .4492 .41534 L p F P
0 g
s
.887 .934 .843 r
.57865 .26458 m .53546 .31121 L .53048 .30684 L p F P
0 g
s
.887 .934 .843 r
.53048 .30684 m .56967 .25591 L .57865 .26458 L p F P
0 g
s
.326 .12 .439 r
.84695 .36784 m .80724 .40244 L .8066 .37294 L p F P
0 g
s
.326 .12 .439 r
.8066 .37294 m .84618 .34593 L .84695 .36784 L p F P
0 g
s
.425 .438 .769 r
.18251 .43249 m .14895 .43823 L .15756 .46739 L p F P
0 g
s
.425 .438 .769 r
.15756 .46739 m .19417 .47232 L .18251 .43249 L p F P
0 g
s
.767 .364 .29 r
.60737 .42888 m .55056 .39868 L .55303 .39158 L p F P
0 g
s
.789 .39 .298 r
.49245 .36313 m .55303 .39158 L .55056 .39868 L closepath p F P
0 g
s
.597 .854 .993 r
.71421 .19271 m .66753 .20298 L .65496 .18873 L p F P
0 g
s
.756 .918 .945 r
.61092 .2153 m .65496 .18873 L .66753 .20298 L p F P
0 g
s
.339 .202 .544 r
.14425 .40781 m .17602 .39095 L .17554 .35325 L p F P
0 g
s
.41 .345 .674 r
.17602 .39095 m .14425 .40781 L .14895 .43823 L p F P
0 g
s
.904 .931 .822 r
.49245 .36313 m .53048 .30684 L .53546 .31121 L closepath p F P
0 g
s
.766 .363 .288 r
.43446 .32767 m .37811 .29773 L .37186 .31029 L p F P
0 g
s
.712 .299 .261 r
.31571 .29481 m .37186 .31029 L .37811 .29773 L p F P
0 g
s
.473 .534 .839 r
.77404 .22182 m .82179 .23243 L .82985 .25809 L p F P
0 g
s
.397 .583 .916 r
.82179 .23243 m .77404 .22182 L .76292 .19679 L p F P
0 g
s
.533 .67 .925 r
.71421 .19271 m .76292 .19679 L .77404 .22182 L p F P
0 g
s
.904 .931 .822 r
.45458 .41918 m .49245 .36313 L .4492 .41534 L closepath p F P
0 g
s
.41 .345 .674 r
.14895 .43823 m .18251 .43249 L .17602 .39095 L p F P
0 g
s
.256 0 .157 r
.80403 .42085 m .76017 .44608 L .76439 .42494 L p F P
0 g
s
.256 0 .157 r
.76439 .42494 m .80724 .40244 L .80403 .42085 L p F P
0 g
s
.648 .76 .931 r
.29806 .49924 m .25251 .50833 L .27119 .53316 L p F P
0 g
s
.648 .76 .931 r
.27119 .53316 m .31628 .52428 L .29806 .49924 L p F P
0 g
s
.789 .39 .298 r
.43142 .33447 m .49245 .36313 L .43446 .32767 L closepath p F P
0 g
s
.766 .363 .288 r
.37186 .31029 m .43142 .33447 L .43446 .32767 L p F P
0 g
s
.848 .983 .696 r
.49245 .36313 m .52643 .30807 L .53048 .30684 L closepath p F P
0 g
s
0 0 0 r
.49245 .36313 m .5238 .31484 L .52643 .30807 L closepath p F P
0 g
s
.028 0 .307 r
.49245 .36313 m .52295 .32639 L .5238 .31484 L closepath p F P
0 g
s
.229 .134 .534 r
.49245 .36313 m .524 .34134 L .52295 .32639 L closepath p F P
0 g
s
.309 .276 .659 r
.49245 .36313 m .52684 .35782 L .524 .34134 L closepath p F P
0 g
s
.322 .362 .748 r
.49245 .36313 m .5311 .37377 L .52684 .35782 L closepath p F P
0 g
s
.267 .411 .821 r
.49245 .36313 m .53625 .38719 L .5311 .37377 L closepath p F P
0 g
s
.711 .181 0 r
.49245 .36313 m .55056 .39868 L .54661 .40039 L closepath p F P
0 g
s
.086 .398 .854 r
.49245 .36313 m .54164 .39643 L .53625 .38719 L closepath p F P
0 g
s
0 .192 .639 r
.49245 .36313 m .54661 .40039 L .54164 .39643 L closepath p F P
0 g
s
.797 .561 .58 r
.43103 .36087 m .49245 .36313 L .43022 .346 L closepath p F P
0 g
s
.803 .619 .652 r
.43377 .37722 m .49245 .36313 L .43103 .36087 L closepath p F P
0 g
s
.816 .676 .709 r
.4381 .39302 m .49245 .36313 L .43377 .37722 L closepath p F P
0 g
s
.838 .742 .759 r
.44347 .40627 m .49245 .36313 L .4381 .39302 L closepath p F P
0 g
s
.869 .826 .802 r
.4492 .41534 m .49245 .36313 L .44347 .40627 L closepath p F P
0 g
s
.796 .493 .477 r
.43022 .346 m .49245 .36313 L .43142 .33447 L closepath p F P
0 g
s
.67 .126 0 r
.60047 .43241 m .54661 .40039 L .55056 .39868 L p F P
0 g
s
.67 .126 0 r
.55056 .39868 m .60737 .42888 L .60047 .43241 L p F P
0 g
s
.371 .723 .989 r
.76292 .19679 m .71421 .19271 L .70227 .17825 L p F P
0 g
s
.597 .854 .993 r
.65496 .18873 m .70227 .17825 L .71421 .19271 L p F P
0 g
s
.556 .271 .438 r
.2646 .29122 m .21961 .30112 L .21376 .33412 L p F P
0 g
s
.378 .116 .386 r
.17554 .35325 m .21376 .33412 L .21961 .30112 L p F P
0 g
s
.411 .352 .681 r
.88219 .29705 m .84276 .31819 L .83711 .28778 L p F P
0 g
s
.411 .352 .681 r
.83711 .28778 m .87909 .2806 L .88219 .29705 L p F P
0 g
s
.423 .426 .758 r
.87909 .2806 m .83711 .28778 L .82985 .25809 L p F P
0 g
s
.812 .985 .712 r
.56967 .25591 m .53048 .30684 L .52643 .30807 L p F P
0 g
s
.539 .596 .859 r
.23537 .47065 m .19417 .47232 L .20941 .50517 L p F P
0 g
s
.539 .596 .859 r
.20941 .50517 m .25251 .50833 L .23537 .47065 L p F P
0 g
s
.57 .002 0 r
.65309 .45403 m .60047 .43241 L .60737 .42888 L p F P
0 g
s
.57 .002 0 r
.60737 .42888 m .66171 .44897 L .65309 .45403 L p F P
0 g
s
.855 .823 .816 r
.40545 .4626 m .4492 .41534 L .44347 .40627 L p F P
0 g
s
.356 .24 .582 r
.88413 .31198 m .84618 .34593 L .84276 .31819 L p F P
0 g
s
.356 .24 .582 r
.84276 .31819 m .88219 .29705 L .88413 .31198 L p F P
0 g
s
.759 .801 .886 r
.34555 .47784 m .29806 .49924 L .31628 .52428 L p F P
0 g
s
.759 .801 .886 r
.31628 .52428 m .36111 .50013 L .34555 .47784 L p F P
0 g
s
.779 .477 .477 r
.43142 .33447 m .37186 .31029 L .36915 .33191 L p F P
0 g
s
.779 .477 .477 r
.36915 .33191 m .43022 .346 L .43142 .33447 L p F P
0 g
s
.423 .426 .758 r
.82985 .25809 m .87522 .26453 L .87909 .2806 L p F P
0 g
s
.394 .48 .83 r
.87522 .26453 m .82985 .25809 L .82179 .23243 L p F P
0 g
s
.489 .319 .576 r
.21376 .33412 m .17554 .35325 L .17602 .39095 L p F P
0 g
s
.855 .823 .816 r
.44347 .40627 m .39428 .44582 L .40545 .4626 L p F P
0 g
s
.822 .817 .845 r
.36111 .50013 m .40545 .4626 L .39428 .44582 L p F P
0 g
s
.718 .974 .742 r
.61092 .2153 m .56967 .25591 L .56238 .25774 L p F P
0 g
s
.812 .985 .712 r
.52643 .30807 m .56238 .25774 L .56967 .25591 L p F P
0 g
s
.369 0 0 r
.70369 .46125 m .65309 .45403 L .66171 .44897 L p F P
0 g
s
.369 0 0 r
.66171 .44897 m .71276 .45538 L .70369 .46125 L p F P
0 g
s
.822 .817 .845 r
.39428 .44582 m .34555 .47784 L .36111 .50013 L p F P
0 g
s
.05 0 .105 r
.84493 .38127 m .80403 .42085 L .80724 .40244 L p F P
0 g
s
.05 0 .105 r
.80724 .40244 m .84695 .36784 L .84493 .38127 L p F P
0 g
s
.672 .376 .464 r
.31571 .29481 m .2646 .29122 L .25923 .32425 L p F P
0 g
s
.556 .271 .438 r
.21376 .33412 m .25923 .32425 L .2646 .29122 L p F P
0 g
s
0 .283 .712 r
.59155 .42519 m .54164 .39643 L .54661 .40039 L p F P
0 g
s
0 .283 .712 r
.54661 .40039 m .60047 .43241 L .59155 .42519 L p F P
0 g
s
.741 .441 .474 r
.37186 .31029 m .31571 .29481 L .31149 .32389 L p F P
0 g
s
.741 .441 .474 r
.31149 .32389 m .36915 .33191 L .37186 .31029 L p F P
0 g
s
.824 .737 .768 r
.39428 .44582 m .44347 .40627 L .4381 .39302 L p F P
0 g
s
.672 .376 .464 r
.25923 .32425 m .31149 .32389 L .31571 .29481 L p F P
0 g
s
0 0 0 r
.56238 .25774 m .52643 .30807 L .5238 .31484 L p F P
0 g
s
.783 .55 .583 r
.43022 .346 m .36915 .33191 L .37041 .36002 L p F P
0 g
s
.783 .55 .583 r
.37041 .36002 m .43103 .36087 L .43022 .346 L p F P
0 g
s
.225 .047 .418 r
.8847 .32364 m .84695 .36784 L .84618 .34593 L p F P
0 g
s
.225 .047 .418 r
.84618 .34593 m .88413 .31198 L .8847 .32364 L p F P
0 g
s
.514 .905 .762 r
.65496 .18873 m .61092 .2153 L .60159 .21724 L p F P
0 g
s
.718 .974 .742 r
.56238 .25774 m .60159 .21724 L .61092 .2153 L p F P
0 g
s
.397 .583 .916 r
.76292 .19679 m .81384 .21377 L .82179 .23243 L p F P
0 g
s
.142 .558 .926 r
.81384 .21377 m .76292 .19679 L .75299 .18406 L p F P
0 g
s
.371 .723 .989 r
.70227 .17825 m .75299 .18406 L .76292 .19679 L p F P
0 g
s
.039 0 0 r
.75178 .45184 m .70369 .46125 L .71276 .45538 L p F P
0 g
s
.039 0 0 r
.71276 .45538 m .76017 .44608 L .75178 .45184 L p F P
0 g
s
.394 .48 .83 r
.82179 .23243 m .871 .2507 L .87522 .26453 L p F P
0 g
s
.288 .507 .894 r
.871 .2507 m .82179 .23243 L .81384 .21377 L p F P
0 g
s
.55 .519 .773 r
.22211 .42492 m .18251 .43249 L .19417 .47232 L p F P
0 g
s
.55 .519 .773 r
.19417 .47232 m .23537 .47065 L .22211 .42492 L p F P
0 g
s
.803 .669 .716 r
.38385 .42092 m .4381 .39302 L .43377 .37722 L p F P
0 g
s
.824 .737 .768 r
.4381 .39302 m .38385 .42092 L .39428 .44582 L p F P
0 g
s
.79 .61 .657 r
.43103 .36087 m .37041 .36002 L .37553 .39103 L p F P
0 g
s
.79 .61 .657 r
.37553 .39103 m .43377 .37722 L .43103 .36087 L p F P
0 g
s
.489 .319 .576 r
.17602 .39095 m .21458 .37726 L .21376 .33412 L p F P
0 g
s
.535 .434 .686 r
.21458 .37726 m .17602 .39095 L .18251 .43249 L p F P
0 g
s
.66 .662 .84 r
.28121 .46132 m .23537 .47065 L .25251 .50833 L p F P
0 g
s
.66 .662 .84 r
.25251 .50833 m .29806 .49924 L .28121 .46132 L p F P
0 g
s
.803 .669 .716 r
.43377 .37722 m .37553 .39103 L .38385 .42092 L p F P
0 g
s
.17 .703 .709 r
.70227 .17825 m .65496 .18873 L .64497 .19053 L p F P
0 g
s
.514 .905 .762 r
.60159 .21724 m .64497 .19053 L .65496 .18873 L p F P
0 g
s
.17 .459 .884 r
.58166 .40781 m .53625 .38719 L .54164 .39643 L p F P
0 g
s
.17 .459 .884 r
.54164 .39643 m .59155 .42519 L .58166 .40781 L p F P
0 g
s
0 0 0 r
.79722 .42559 m .75178 .45184 L .76017 .44608 L p F P
0 g
s
0 0 0 r
.76017 .44608 m .80403 .42085 L .79722 .42559 L p F P
0 g
s
0 0 0 r
.5238 .31484 m .55773 .27015 L .56238 .25774 L p F P
0 g
s
.106 0 .334 r
.55773 .27015 m .5238 .31484 L .52295 .32639 L p F P
0 g
s
.535 .434 .686 r
.18251 .43249 m .22211 .42492 L .21458 .37726 L p F P
0 g
s
.794 .725 .787 r
.34555 .47784 m .39428 .44582 L .38385 .42092 L p F P
0 g
s
0 .461 .838 r
.64163 .44448 m .59155 .42519 L .60047 .43241 L p F P
0 g
s
0 .461 .838 r
.60047 .43241 m .65309 .45403 L .64163 .44448 L p F P
0 g
s
.611 .414 .591 r
.25923 .32425 m .21376 .33412 L .21458 .37726 L p F P
0 g
s
.751 .525 .588 r
.36915 .33191 m .31149 .32389 L .31284 .3619 L p F P
0 g
s
.751 .525 .588 r
.31284 .3619 m .37041 .36002 L .36915 .33191 L p F P
0 g
s
0 0 0 r
.60159 .21724 m .56238 .25774 L .55773 .27015 L p F P
0 g
s
0 0 .07 r
.8838 .33062 m .84493 .38127 L .84695 .36784 L p F P
0 g
s
0 0 .07 r
.84695 .36784 m .8847 .32364 L .8838 .33062 L p F P
0 g
s
.743 .702 .813 r
.33109 .44436 m .28121 .46132 L .29806 .49924 L p F P
0 g
s
.743 .702 .813 r
.29806 .49924 m .34555 .47784 L .33109 .44436 L p F P
0 g
s
.794 .725 .787 r
.38385 .42092 m .33109 .44436 L .34555 .47784 L p F P
0 g
s
.328 .452 .834 r
.57206 .38227 m .5311 .37377 L .53625 .38719 L p F P
0 g
s
.328 .452 .834 r
.53625 .38719 m .58166 .40781 L .57206 .38227 L p F P
0 g
s
.17 .703 .709 r
.64497 .19053 m .69296 .1799 L .70227 .17825 L p F P
0 g
s
.193 0 0 r
.75299 .18406 m .70227 .17825 L .69296 .1799 L p F P
0 g
s
.106 0 .334 r
.52295 .32639 m .55636 .29185 L .55773 .27015 L p F P
0 g
s
.288 .177 .549 r
.55636 .29185 m .52295 .32639 L .524 .34134 L p F P
0 g
s
.288 .507 .894 r
.81384 .21377 m .86693 .24074 L .871 .2507 L p F P
0 g
s
0 .424 .852 r
.86693 .24074 m .81384 .21377 L .80691 .20443 L p F P
0 g
s
.142 .558 .926 r
.75299 .18406 m .80691 .20443 L .81384 .21377 L p F P
0 g
s
.696 .481 .592 r
.31149 .32389 m .25923 .32425 L .26039 .36751 L p F P
0 g
s
.611 .414 .591 r
.21458 .37726 m .26039 .36751 L .25923 .32425 L p F P
0 g
s
.696 .481 .592 r
.26039 .36751 m .31284 .3619 L .31149 .32389 L p F P
0 g
s
.775 .653 .729 r
.33109 .44436 m .38385 .42092 L .37553 .39103 L p F P
0 g
s
.554 .869 .581 r
.84027 .3844 m .79722 .42559 L .80403 .42085 L p F P
0 g
s
.554 .869 .581 r
.80403 .42085 m .84493 .38127 L .84027 .3844 L p F P
0 g
s
.244 .685 .958 r
.69132 .45043 m .64163 .44448 L .65309 .45403 L p F P
0 g
s
.244 .685 .958 r
.65309 .45403 m .70369 .46125 L .69132 .45043 L p F P
0 g
s
.372 .397 .757 r
.56399 .35177 m .52684 .35782 L .5311 .37377 L p F P
0 g
s
.372 .397 .757 r
.5311 .37377 m .57206 .38227 L .56399 .35177 L p F P
0 g
s
.761 .59 .666 r
.37041 .36002 m .31284 .3619 L .31966 .40393 L p F P
0 g
s
.761 .59 .666 r
.31966 .40393 m .37553 .39103 L .37041 .36002 L p F P
0 g
s
.288 .177 .549 r
.524 .34134 m .55852 .32026 L .55636 .29185 L p F P
0 g
s
.359 .312 .669 r
.55852 .32026 m .524 .34134 L .52684 .35782 L p F P
0 g
s
.653 .582 .763 r
.26805 .41536 m .22211 .42492 L .23537 .47065 L p F P
0 g
s
.653 .582 .763 r
.23537 .47065 m .28121 .46132 L .26805 .41536 L p F P
0 g
s
.374 .326 .676 r
.87909 .2806 m .92188 .27354 L .88219 .29705 L closepath p F P
0 g
s
.386 .401 .753 r
.87522 .26453 m .92188 .27354 L .87909 .2806 L closepath p F P
0 g
s
.359 .312 .669 r
.52684 .35782 m .56399 .35177 L .55852 .32026 L p F P
0 g
s
.775 .653 .729 r
.37553 .39103 m .31966 .40393 L .33109 .44436 L p F P
0 g
s
.638 .506 .686 r
.26039 .36751 m .21458 .37726 L .22211 .42492 L p F P
0 g
s
.314 .211 .574 r
.88219 .29705 m .92188 .27354 L .88413 .31198 L closepath p F P
0 g
s
.351 .45 .822 r
.871 .2507 m .92188 .27354 L .87522 .26453 L closepath p F P
0 g
s
.43 0 0 r
.80691 .20443 m .75299 .18406 L .74546 .1856 L p F P
0 g
s
.193 0 0 r
.69296 .1799 m .74546 .1856 L .75299 .18406 L p F P
0 g
s
.13 0 .015 r
.64497 .19053 m .60159 .21724 L .59575 .23361 L p F P
0 g
s
0 0 0 r
.55773 .27015 m .59575 .23361 L .60159 .21724 L p F P
0 g
s
.319 .562 .924 r
.6287 .421 m .58166 .40781 L .59155 .42519 L p F P
0 g
s
.319 .562 .924 r
.59155 .42519 m .64163 .44448 L .6287 .421 L p F P
0 g
s
.638 .506 .686 r
.22211 .42492 m .26805 .41536 L .26039 .36751 L p F P
0 g
s
.171 .01 .406 r
.88413 .31198 m .92188 .27354 L .8847 .32364 L closepath p F P
0 g
s
.727 .626 .746 r
.28121 .46132 m .33109 .44436 L .31966 .40393 L p F P
0 g
s
.727 .626 .746 r
.31966 .40393 m .26805 .41536 L .28121 .46132 L p F P
0 g
s
.533 .863 .995 r
.74007 .44083 m .69132 .45043 L .70369 .46125 L p F P
0 g
s
.533 .863 .995 r
.70369 .46125 m .75178 .45184 L .74007 .44083 L p F P
0 g
s
.23 .464 .877 r
.86693 .24074 m .92188 .27354 L .871 .2507 L closepath p F P
0 g
s
.712 .557 .677 r
.31284 .3619 m .26039 .36751 L .26805 .41536 L p F P
0 g
s
.712 .557 .677 r
.26805 .41536 m .31966 .40393 L .31284 .3619 L p F P
0 g
s
.245 .03 .376 r
.59575 .23361 m .55773 .27015 L .55636 .29185 L p F P
0 g
s
.669 .901 .559 r
.88152 .33201 m .84027 .3844 L .84493 .38127 L p F P
0 g
s
.669 .901 .559 r
.84493 .38127 m .8838 .33062 L .88152 .33201 L p F P
0 g
s
0 .424 .852 r
.80691 .20443 m .86349 .23587 L .86693 .24074 L p F P
0 g
s
.549 0 0 r
.86349 .23587 m .80691 .20443 L .80186 .20578 L p F P
0 g
s
.43 0 0 r
.74546 .1856 m .80186 .20578 L .80691 .20443 L p F P
0 g
s
0 0 .053 r
.8847 .32364 m .92188 .27354 L .8838 .33062 L closepath p F P
0 g
s
.393 0 .096 r
.69296 .1799 m .64497 .19053 L .6389 .2089 L p F P
0 g
s
.13 0 .015 r
.59575 .23361 m .6389 .2089 L .64497 .19053 L p F P
0 g
s
0 .356 .809 r
.86349 .23587 m .92188 .27354 L .86693 .24074 L closepath p F P
0 g
s
.73 .948 .951 r
.7875 .41555 m .74007 .44083 L .75178 .45184 L p F P
0 g
s
.73 .948 .951 r
.75178 .45184 m .79722 .42559 L .7875 .41555 L p F P
0 g
s
.432 .521 .849 r
.61592 .38621 m .57206 .38227 L .58166 .40781 L p F P
0 g
s
.432 .521 .849 r
.58166 .40781 m .6287 .421 L .61592 .38621 L p F P
0 g
s
.582 .133 .151 r
.74546 .1856 m .69296 .1799 L .68756 .1982 L p F P
0 g
s
.393 0 .096 r
.6389 .2089 m .68756 .1982 L .69296 .1799 L p F P
0 g
s
.494 .673 .944 r
.6771 .42357 m .6287 .421 L .64163 .44448 L p F P
0 g
s
.494 .673 .944 r
.64163 .44448 m .69132 .45043 L .6771 .42357 L p F P
0 g
s
.835 .971 .885 r
.83347 .37655 m .7875 .41555 L .79722 .42559 L p F P
0 g
s
.835 .971 .885 r
.79722 .42559 m .84027 .3844 L .83347 .37655 L p F P
0 g
s
.245 .03 .376 r
.55636 .29185 m .59427 .26284 L .59575 .23361 L p F P
0 g
s
.388 .25 .57 r
.59427 .26284 m .55636 .29185 L .55852 .32026 L p F P
0 g
s
.713 .906 .543 r
.8838 .33062 m .92188 .27354 L .88152 .33201 L closepath p F P
0 g
s
.596 .025 0 r
.8611 .23676 m .92188 .27354 L .86349 .23587 L closepath p F P
0 g
s
.549 0 0 r
.80186 .20578 m .8611 .23676 L .86349 .23587 L p F P
0 g
s
.408 .154 .415 r
.6389 .2089 m .59575 .23361 L .59427 .26284 L p F P
0 g
s
.694 .244 .179 r
.80186 .20578 m .74546 .1856 L .74138 .20178 L p F P
0 g
s
.582 .133 .151 r
.68756 .1982 m .74138 .20178 L .74546 .1856 L p F P
0 g
s
.886 .972 .834 r
.87812 .32757 m .83347 .37655 L .84027 .3844 L p F P
0 g
s
.886 .972 .834 r
.84027 .3844 m .88152 .33201 L .87812 .32757 L p F P
0 g
s
.459 .456 .767 r
.60502 .34452 m .56399 .35177 L .57206 .38227 L p F P
0 g
s
.459 .456 .767 r
.57206 .38227 m .61592 .38621 L .60502 .34452 L p F P
0 g
s
.388 .25 .57 r
.55852 .32026 m .59747 .30148 L .59427 .26284 L p F P
0 g
s
.445 .373 .682 r
.59747 .30148 m .55852 .32026 L .56399 .35177 L p F P
0 g
s
.752 .306 .191 r
.8611 .23676 m .80186 .20578 L .79936 .21797 L p F P
0 g
s
.694 .244 .179 r
.74138 .20178 m .79936 .21797 L .80186 .20578 L p F P
0 g
s
.906 .97 .807 r
.88152 .33201 m .92188 .27354 L .87812 .32757 L closepath p F P
0 g
s
.445 .373 .682 r
.56399 .35177 m .60502 .34452 L .59747 .30148 L p F P
0 g
s
.648 .76 .931 r
.72639 .41373 m .6771 .42357 L .69132 .45043 L p F P
0 g
s
.648 .76 .931 r
.69132 .45043 m .74007 .44083 L .72639 .41373 L p F P
0 g
s
.777 .333 .194 r
.86007 .24339 m .92188 .27354 L .8611 .23676 L closepath p F P
0 g
s
.752 .306 .191 r
.79936 .21797 m .86007 .24339 L .8611 .23676 L p F P
0 g
s
.802 .474 .434 r
.86055 .25501 m .92188 .27354 L .86007 .24339 L closepath p F P
0 g
s
.807 .557 .561 r
.86249 .27024 m .92188 .27354 L .86055 .25501 L closepath p F P
0 g
s
.814 .623 .644 r
.86567 .28719 m .92188 .27354 L .86249 .27024 L closepath p F P
0 g
s
.828 .687 .708 r
.86967 .30372 m .92188 .27354 L .86567 .28719 L closepath p F P
0 g
s
.852 .762 .762 r
.87401 .31776 m .92188 .27354 L .86967 .30372 L closepath p F P
0 g
s
.886 .858 .808 r
.87812 .32757 m .92188 .27354 L .87401 .31776 L closepath p F P
0 g
s
.556 .271 .438 r
.68756 .1982 m .6389 .2089 L .63771 .24215 L p F P
0 g
s
.408 .154 .415 r
.59427 .26284 m .63771 .24215 L .6389 .2089 L p F P
0 g
s
.551 .597 .852 r
.66284 .38365 m .61592 .38621 L .6287 .421 L p F P
0 g
s
.551 .597 .852 r
.6287 .421 m .6771 .42357 L .66284 .38365 L p F P
0 g
s
.869 .853 .825 r
.83347 .37655 m .87812 .32757 L .87401 .31776 L p F P
0 g
s
.76 .813 .895 r
.77599 .39143 m .72639 .41373 L .74007 .44083 L p F P
0 g
s
.76 .813 .895 r
.74007 .44083 m .7875 .41555 L .77599 .39143 L p F P
0 g
s
.783 .458 .438 r
.86007 .24339 m .79936 .21797 L .7998 .23976 L p F P
0 g
s
.783 .458 .438 r
.7998 .23976 m .86055 .25501 L .86007 .24339 L p F P
0 g
s
.504 .336 .586 r
.63771 .24215 m .59427 .26284 L .59747 .30148 L p F P
0 g
s
.869 .853 .825 r
.87401 .31776 m .82533 .35839 L .83347 .37655 L p F P
0 g
s
.829 .841 .855 r
.7875 .41555 m .83347 .37655 L .82533 .35839 L p F P
0 g
s
.829 .841 .855 r
.82533 .35839 m .77599 .39143 L .7875 .41555 L p F P
0 g
s
.667 .361 .446 r
.74138 .20178 m .68756 .1982 L .68693 .23147 L p F P
0 g
s
.556 .271 .438 r
.63771 .24215 m .68693 .23147 L .68756 .1982 L p F P
0 g
s
.74 .422 .443 r
.79936 .21797 m .74138 .20178 L .74138 .23108 L p F P
0 g
s
.74 .422 .443 r
.74138 .23108 m .7998 .23976 L .79936 .21797 L p F P
0 g
s
.836 .755 .773 r
.82533 .35839 m .87401 .31776 L .86967 .30372 L p F P
0 g
s
.667 .361 .446 r
.68693 .23147 m .74138 .23108 L .74138 .20178 L p F P
0 g
s
.79 .545 .567 r
.86055 .25501 m .7998 .23976 L .80319 .26856 L p F P
0 g
s
.79 .545 .567 r
.80319 .26856 m .86249 .27024 L .86055 .25501 L p F P
0 g
s
.56 .523 .77 r
.65048 .33576 m .60502 .34452 L .61592 .38621 L p F P
0 g
s
.56 .523 .77 r
.61592 .38621 m .66284 .38365 L .65048 .33576 L p F P
0 g
s
.813 .679 .716 r
.81685 .33201 m .86967 .30372 L .86567 .28719 L p F P
0 g
s
.836 .755 .773 r
.86967 .30372 m .81685 .33201 L .82533 .35839 L p F P
0 g
s
.798 .612 .65 r
.86249 .27024 m .80319 .26856 L .80913 .30071 L p F P
0 g
s
.798 .612 .65 r
.80913 .30071 m .86567 .28719 L .86249 .27024 L p F P
0 g
s
.504 .336 .586 r
.59747 .30148 m .64171 .28636 L .63771 .24215 L p F P
0 g
s
.545 .442 .688 r
.64171 .28636 m .59747 .30148 L .60502 .34452 L p F P
0 g
s
.66 .662 .84 r
.71249 .37355 m .66284 .38365 L .6771 .42357 L p F P
0 g
s
.66 .662 .84 r
.6771 .42357 m .72639 .41373 L .71249 .37355 L p F P
0 g
s
.813 .679 .716 r
.86567 .28719 m .80913 .30071 L .81685 .33201 L p F P
0 g
s
.545 .442 .688 r
.60502 .34452 m .65048 .33576 L .64171 .28636 L p F P
0 g
s
.801 .738 .793 r
.77599 .39143 m .82533 .35839 L .81685 .33201 L p F P
0 g
s
.611 .414 .591 r
.68693 .23147 m .63771 .24215 L .64171 .28636 L p F P
0 g
s
.754 .519 .576 r
.7998 .23976 m .74138 .23108 L .74559 .27004 L p F P
0 g
s
.754 .519 .576 r
.74559 .27004 m .80319 .26856 L .7998 .23976 L p F P
0 g
s
.744 .708 .818 r
.76414 .35595 m .71249 .37355 L .72639 .41373 L p F P
0 g
s
.744 .708 .818 r
.72639 .41373 m .77599 .39143 L .76414 .35595 L p F P
0 g
s
.801 .738 .793 r
.81685 .33201 m .76414 .35595 L .77599 .39143 L p F P
0 g
s
.695 .476 .586 r
.74138 .23108 m .68693 .23147 L .69132 .2758 L p F P
0 g
s
.611 .414 .591 r
.64171 .28636 m .69132 .2758 L .68693 .23147 L p F P
0 g
s
.695 .476 .586 r
.69132 .2758 m .74559 .27004 L .74138 .23108 L p F P
0 g
s
.78 .66 .73 r
.76414 .35595 m .81685 .33201 L .80913 .30071 L p F P
0 g
s
.765 .591 .662 r
.80319 .26856 m .74559 .27004 L .75353 .3136 L p F P
0 g
s
.765 .591 .662 r
.75353 .3136 m .80913 .30071 L .80319 .26856 L p F P
0 g
s
.653 .582 .763 r
.70023 .32541 m .65048 .33576 L .66284 .38365 L p F P
0 g
s
.653 .582 .763 r
.66284 .38365 m .71249 .37355 L .70023 .32541 L p F P
0 g
s
.78 .66 .73 r
.80913 .30071 m .75353 .3136 L .76414 .35595 L p F P
0 g
s
.638 .506 .686 r
.69132 .2758 m .64171 .28636 L .65048 .33576 L p F P
0 g
s
.638 .506 .686 r
.65048 .33576 m .70023 .32541 L .69132 .2758 L p F P
0 g
s
.728 .628 .748 r
.71249 .37355 m .76414 .35595 L .75353 .3136 L p F P
0 g
s
.728 .628 .748 r
.75353 .3136 m .70023 .32541 L .71249 .37355 L p F P
0 g
s
.712 .556 .675 r
.74559 .27004 m .69132 .2758 L .70023 .32541 L p F P
0 g
s
.712 .556 .675 r
.70023 .32541 m .75353 .3136 L .74559 .27004 L p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.0147151 0.159864 0.360953 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.14112e-16 1.00796 -0.103262 1.00796 [
[ 0 0 0 0 ]
[ 1 .73459 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .73459 L
0 .73459 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.702 .556 .685 r
.31987 .44041 m .27314 .44109 L .27298 .39551 L p F P
0 g
s
.702 .556 .685 r
.27298 .39551 m .31962 .39482 L .31987 .44041 L p F P
0 g
s
.702 .613 .754 r
.31962 .39482 m .27298 .39551 L .27119 .35086 L p F P
0 g
s
.765 .606 .682 r
.22447 .39724 m .27298 .39551 L .27314 .44109 L p F P
0 g
s
.766 .662 .749 r
.27298 .39551 m .22447 .39724 L .22272 .35778 L p F P
0 g
s
.766 .662 .749 r
.22272 .35778 m .27119 .35086 L .27298 .39551 L p F P
0 g
s
.63 .497 .682 r
.3655 .43546 m .31987 .44041 L .31962 .39482 L p F P
0 g
s
.63 .497 .682 r
.31962 .39482 m .36521 .39514 L .3655 .43546 L p F P
0 g
s
.628 .554 .752 r
.36521 .39514 m .31962 .39482 L .31802 .35015 L p F P
0 g
s
.702 .613 .754 r
.27119 .35086 m .31802 .35015 L .31962 .39482 L p F P
0 g
s
.695 .488 .604 r
.31873 .48215 m .27166 .48283 L .27314 .44109 L p F P
0 g
s
.695 .488 .604 r
.27314 .44109 m .31987 .44041 L .31873 .48215 L p F P
0 g
s
.763 .546 .604 r
.22454 .43753 m .27314 .44109 L .27166 .48283 L p F P
0 g
s
.765 .606 .682 r
.27314 .44109 m .22454 .43753 L .22447 .39724 L p F P
0 g
s
.615 .422 .597 r
.36479 .47232 m .31873 .48215 L .31987 .44041 L p F P
0 g
s
.615 .422 .597 r
.31987 .44041 m .3655 .43546 L .36479 .47232 L p F P
0 g
s
.702 .556 .685 r
.74188 .43424 m .69486 .43493 L .69394 .38922 L p F P
0 g
s
.702 .556 .685 r
.69394 .38922 m .74088 .38852 L .74188 .43424 L p F P
0 g
s
.702 .613 .754 r
.74088 .38852 m .69394 .38922 L .6938 .34441 L p F P
0 g
s
.767 .608 .681 r
.64755 .39092 m .69394 .38922 L .69486 .43493 L p F P
0 g
s
.768 .667 .751 r
.69394 .38922 m .64755 .39092 L .64726 .35132 L p F P
0 g
s
.768 .667 .751 r
.64726 .35132 m .6938 .34441 L .69394 .38922 L p F P
0 g
s
.634 .501 .683 r
.79012 .42924 m .74188 .43424 L .74088 .38852 L p F P
0 g
s
.634 .501 .683 r
.74088 .38852 m .78916 .3888 L .79012 .42924 L p F P
0 g
s
.632 .556 .75 r
.78916 .3888 m .74088 .38852 L .74091 .34369 L p F P
0 g
s
.702 .613 .754 r
.6938 .34441 m .74091 .34369 L .74088 .38852 L p F P
0 g
s
.693 .672 .825 r
.31802 .35015 m .27119 .35086 L .26795 .31185 L p F P
0 g
s
.765 .725 .816 r
.27119 .35086 m .22272 .35778 L .21947 .32341 L p F P
0 g
s
.765 .725 .816 r
.21947 .32341 m .26795 .31185 L .27119 .35086 L p F P
0 g
s
.628 .554 .752 r
.31802 .35015 m .36394 .35563 L .36521 .39514 L p F P
0 g
s
.607 .605 .824 r
.36394 .35563 m .31802 .35015 L .31521 .31112 L p F P
0 g
s
.693 .672 .825 r
.26795 .31185 m .31521 .31112 L .31802 .35015 L p F P
0 g
s
.695 .488 .604 r
.74382 .47607 m .69646 .47674 L .69486 .43493 L p F P
0 g
s
.695 .488 .604 r
.69486 .43493 m .74188 .43424 L .74382 .47607 L p F P
0 g
s
.766 .544 .598 r
.64829 .43132 m .69486 .43493 L .69646 .47674 L p F P
0 g
s
.767 .608 .681 r
.69486 .43493 m .64829 .43132 L .64755 .39092 L p F P
0 g
s
.62 .431 .604 r
.79215 .46618 m .74382 .47607 L .74188 .43424 L p F P
0 g
s
.62 .431 .604 r
.74188 .43424 m .79012 .42924 L .79215 .46618 L p F P
0 g
s
.81 .644 .676 r
.1735 .39991 m .22447 .39724 L .22454 .43753 L p F P
0 g
s
.812 .698 .739 r
.22447 .39724 m .1735 .39991 L .17206 .37035 L p F P
0 g
s
.812 .698 .739 r
.17206 .37035 m .22272 .35778 L .22447 .39724 L p F P
0 g
s
.559 .44 .673 r
.41088 .42662 m .3655 .43546 L .36521 .39514 L p F P
0 g
s
.559 .44 .673 r
.36521 .39514 m .4106 .39637 L .41088 .42662 L p F P
0 g
s
.555 .496 .744 r
.4106 .39637 m .36521 .39514 L .36394 .35563 L p F P
0 g
s
.763 .546 .604 r
.27166 .48283 m .22292 .47436 L .22454 .43753 L p F P
0 g
s
.812 .589 .6 r
.1735 .43012 m .22454 .43753 L .22292 .47436 L p F P
0 g
s
.81 .644 .676 r
.22454 .43753 m .1735 .43012 L .1735 .39991 L p F P
0 g
s
.693 .672 .825 r
.74091 .34369 m .6938 .34441 L .69445 .30522 L p F P
0 g
s
.768 .733 .821 r
.6938 .34441 m .64726 .35132 L .64746 .31678 L p F P
0 g
s
.768 .733 .821 r
.64746 .31678 m .69445 .30522 L .6938 .34441 L p F P
0 g
s
.632 .556 .75 r
.74091 .34369 m .78936 .34915 L .78916 .3888 L p F P
0 g
s
.613 .605 .818 r
.78936 .34915 m .74091 .34369 L .742 .30448 L p F P
0 g
s
.693 .672 .825 r
.69445 .30522 m .742 .30448 L .74091 .34369 L p F P
0 g
s
.536 .358 .587 r
.41056 .45419 m .36479 .47232 L .3655 .43546 L p F P
0 g
s
.536 .358 .587 r
.3655 .43546 m .41088 .42662 L .41056 .45419 L p F P
0 g
s
.819 .649 .672 r
.60087 .39353 m .64755 .39092 L .64829 .43132 L p F P
0 g
s
.821 .709 .741 r
.64755 .39092 m .60087 .39353 L .60053 .36386 L p F P
0 g
s
.821 .709 .741 r
.60053 .36386 m .64726 .35132 L .64755 .39092 L p F P
0 g
s
.817 .762 .801 r
.22272 .35778 m .17206 .37035 L .16932 .34472 L p F P
0 g
s
.817 .762 .801 r
.16932 .34472 m .21947 .32341 L .22272 .35778 L p F P
0 g
s
.673 .389 .484 r
.31629 .51549 m .26865 .51616 L .27166 .48283 L p F P
0 g
s
.673 .389 .484 r
.27166 .48283 m .31873 .48215 L .31629 .51549 L p F P
0 g
s
.757 .465 .49 r
.22292 .47436 m .27166 .48283 L .26865 .51616 L p F P
0 g
s
.57 .302 .471 r
.36312 .50164 m .31629 .51549 L .31873 .48215 L p F P
0 g
s
.57 .302 .471 r
.31873 .48215 m .36479 .47232 L .36312 .50164 L p F P
0 g
s
.573 .453 .677 r
.84023 .42031 m .79012 .42924 L .78916 .3888 L p F P
0 g
s
.573 .453 .677 r
.78916 .3888 m .83945 .38997 L .84023 .42031 L p F P
0 g
s
.57 .505 .742 r
.83945 .38997 m .78916 .3888 L .78936 .34915 L p F P
0 g
s
.555 .496 .744 r
.36394 .35563 m .40977 .36675 L .4106 .39637 L p F P
0 g
s
.522 .538 .813 r
.40977 .36675 m .36394 .35563 L .36184 .3212 L p F P
0 g
s
.607 .605 .824 r
.31521 .31112 m .36184 .3212 L .36394 .35563 L p F P
0 g
s
.766 .544 .598 r
.69646 .47674 m .6494 .46823 L .64829 .43132 L p F P
0 g
s
.821 .589 .588 r
.60137 .42382 m .64829 .43132 L .6494 .46823 L p F P
0 g
s
.819 .649 .672 r
.64829 .43132 m .60137 .42382 L .60087 .39353 L p F P
0 g
s
.555 .38 .6 r
.84199 .44793 m .79215 .46618 L .79012 .42924 L p F P
0 g
s
.555 .38 .6 r
.79012 .42924 m .84023 .42031 L .84199 .44793 L p F P
0 g
s
.826 .779 .808 r
.64726 .35132 m .60053 .36386 L .6004 .33811 L p F P
0 g
s
.826 .779 .808 r
.6004 .33811 m .64746 .31678 L .64726 .35132 L p F P
0 g
s
.673 .389 .484 r
.74652 .50943 m .69858 .51011 L .69646 .47674 L p F P
0 g
s
.673 .389 .484 r
.69646 .47674 m .74382 .47607 L .74652 .50943 L p F P
0 g
s
.758 .456 .473 r
.6494 .46823 m .69646 .47674 L .69858 .51011 L p F P
0 g
s
.581 .321 .488 r
.79505 .49552 m .74652 .50943 L .74382 .47607 L p F P
0 g
s
.581 .321 .488 r
.74382 .47607 m .79215 .46618 L .79505 .49552 L p F P
0 g
s
.57 .505 .742 r
.78936 .34915 m .83973 .36024 L .83945 .38997 L p F P
0 g
s
.544 .544 .805 r
.83973 .36024 m .78936 .34915 L .79071 .31456 L p F P
0 g
s
.613 .605 .818 r
.742 .30448 m .79071 .31456 L .78936 .34915 L p F P
0 g
s
.663 .743 .909 r
.31521 .31112 m .26795 .31185 L .26357 .28287 L p F P
0 g
s
.758 .808 .893 r
.26795 .31185 m .21947 .32341 L .21503 .298 L p F P
0 g
s
.758 .808 .893 r
.21503 .298 m .26357 .28287 L .26795 .31185 L p F P
0 g
s
.757 .465 .49 r
.26865 .51616 m .21975 .50367 L .22292 .47436 L p F P
0 g
s
.815 .521 .491 r
.17204 .45765 m .22292 .47436 L .21975 .50367 L p F P
0 g
s
.812 .589 .6 r
.22292 .47436 m .17204 .45765 L .1735 .43012 L p F P
0 g
s
.545 .654 .907 r
.36184 .3212 m .31521 .31112 L .31146 .28212 L p F P
0 g
s
.663 .743 .909 r
.26357 .28287 m .31146 .28212 L .31521 .31112 L p F P
0 g
s
.47 .22 .453 r
.40968 .47595 m .36312 .50164 L .36479 .47232 L p F P
0 g
s
.47 .22 .453 r
.36479 .47232 m .41056 .45419 L .40968 .47595 L p F P
0 g
s
.838 .667 .67 r
.1198 .40335 m .1735 .39991 L .1735 .43012 L p F P
0 g
s
.84 .72 .73 r
.1735 .39991 m .1198 .40335 L .11894 .38741 L p F P
0 g
s
.84 .72 .73 r
.11894 .38741 m .17206 .37035 L .1735 .39991 L p F P
0 g
s
.663 .743 .909 r
.742 .30448 m .69445 .30522 L .69585 .27605 L p F P
0 g
s
.758 .822 .902 r
.69445 .30522 m .64746 .31678 L .64813 .29122 L p F P
0 g
s
.758 .822 .902 r
.64813 .29122 m .69585 .27605 L .69445 .30522 L p F P
0 g
s
.758 .456 .473 r
.69858 .51011 m .65077 .49756 L .6494 .46823 L p F P
0 g
s
.821 .589 .588 r
.6494 .46823 m .60198 .45141 L .60137 .42382 L p F P
0 g
s
.823 .509 .459 r
.60198 .45141 m .6494 .46823 L .65077 .49756 L p F P
0 g
s
.56 .652 .897 r
.79071 .31456 m .742 .30448 L .74405 .27529 L p F P
0 g
s
.663 .743 .909 r
.69585 .27605 m .74405 .27529 L .742 .30448 L p F P
0 g
s
.822 .847 .867 r
.21947 .32341 m .16932 .34472 L .16556 .32596 L p F P
0 g
s
.822 .847 .867 r
.16556 .32596 m .21503 .298 L .21947 .32341 L p F P
0 g
s
.842 .616 .596 r
.11976 .41964 m .1735 .43012 L .17204 .45765 L p F P
0 g
s
.838 .667 .67 r
.1735 .43012 m .11976 .41964 L .1198 .40335 L p F P
0 g
s
.502 .264 .487 r
.84456 .46971 m .79505 .49552 L .79215 .46618 L p F P
0 g
s
.502 .264 .487 r
.79215 .46618 m .84199 .44793 L .84456 .46971 L p F P
0 g
s
.504 .395 .664 r
.45682 .41466 m .41088 .42662 L .4106 .39637 L p F P
0 g
s
.504 .395 .664 r
.4106 .39637 m .45664 .39832 L .45682 .41466 L p F P
0 g
s
.499 .451 .734 r
.45664 .39832 m .4106 .39637 L .40977 .36675 L p F P
0 g
s
.522 .538 .813 r
.36184 .3212 m .40847 .34105 L .40977 .36675 L p F P
0 g
s
.429 .561 .885 r
.40847 .34105 m .36184 .3212 L .35909 .29574 L p F P
0 g
s
.545 .654 .907 r
.31146 .28212 m .35909 .29574 L .36184 .3212 L p F P
0 g
s
.848 .783 .788 r
.17206 .37035 m .11894 .38741 L .1173 .37369 L p F P
0 g
s
.848 .783 .788 r
.1173 .37369 m .16932 .34472 L .17206 .37035 L p F P
0 g
s
.476 .309 .576 r
.45676 .42948 m .41056 .45419 L .41088 .42662 L p F P
0 g
s
.476 .309 .576 r
.41088 .42662 m .45682 .41466 L .45676 .42948 L p F P
0 g
s
.853 .676 .663 r
.55318 .39688 m .60087 .39353 L .60137 .42382 L p F P
0 g
s
.855 .736 .731 r
.60087 .39353 m .55318 .39688 L .55293 .38089 L p F P
0 g
s
.855 .736 .731 r
.55293 .38089 m .60053 .36386 L .60087 .39353 L p F P
0 g
s
.828 .875 .879 r
.64746 .31678 m .6004 .33811 L .60048 .31924 L p F P
0 g
s
.828 .875 .879 r
.60048 .31924 m .64813 .29122 L .64746 .31678 L p F P
0 g
s
.856 .618 .577 r
.55342 .41323 m .60137 .42382 L .60198 .45141 L p F P
0 g
s
.853 .676 .663 r
.60137 .42382 m .55342 .41323 L .55318 .39688 L p F P
0 g
s
.499 .451 .734 r
.40977 .36675 m .45626 .38235 L .45664 .39832 L p F P
0 g
s
.457 .485 .799 r
.45626 .38235 m .40977 .36675 L .40847 .34105 L p F P
0 g
s
.53 .418 .671 r
.89261 .40821 m .84023 .42031 L .83945 .38997 L p F P
0 g
s
.53 .418 .671 r
.83945 .38997 m .89216 .39183 L .89261 .40821 L p F P
0 g
s
.526 .468 .734 r
.89216 .39183 m .83945 .38997 L .83973 .36024 L p F P
0 g
s
.544 .544 .805 r
.79071 .31456 m .84105 .33442 L .83973 .36024 L p F P
0 g
s
.472 .57 .873 r
.84105 .33442 m .79071 .31456 L .7931 .28894 L p F P
0 g
s
.56 .652 .897 r
.74405 .27529 m .7931 .28894 L .79071 .31456 L p F P
0 g
s
.598 .192 .243 r
.31278 .53642 m .2644 .53709 L .26865 .51616 L p F P
0 g
s
.598 .192 .243 r
.26865 .51616 m .31629 .51549 L .31278 .53642 L p F P
0 g
s
.725 .315 .27 r
.21975 .50367 m .26865 .51616 L .2644 .53709 L p F P
0 g
s
.437 .053 .211 r
.36067 .51989 m .31278 .53642 L .31629 .51549 L p F P
0 g
s
.437 .053 .211 r
.31629 .51549 m .36312 .50164 L .36067 .51989 L p F P
0 g
s
.863 .807 .794 r
.60053 .36386 m .55293 .38089 L .5527 .3671 L p F P
0 g
s
.863 .807 .794 r
.5527 .3671 m .6004 .33811 L .60053 .36386 L p F P
0 g
s
.815 .521 .491 r
.21975 .50367 m .16927 .4794 L .17204 .45765 L p F P
0 g
s
.85 .555 .49 r
.11883 .43444 m .17204 .45765 L .16927 .4794 L p F P
0 g
s
.842 .616 .596 r
.17204 .45765 m .11883 .43444 L .11976 .41964 L p F P
0 g
s
.508 .345 .595 r
.8937 .42306 m .84199 .44793 L .84023 .42031 L p F P
0 g
s
.508 .345 .595 r
.84023 .42031 m .89261 .40821 L .8937 .42306 L p F P
0 g
s
.526 .468 .734 r
.83973 .36024 m .89238 .37579 L .89216 .39183 L p F P
0 g
s
.494 .501 .793 r
.89238 .37579 m .83973 .36024 L .84105 .33442 L p F P
0 g
s
.392 .16 .438 r
.45649 .44105 m .40968 .47595 L .41056 .45419 L p F P
0 g
s
.392 .16 .438 r
.41056 .45419 m .45676 .42948 L .45649 .44105 L p F P
0 g
s
.725 .315 .27 r
.2644 .53709 m .21534 .52193 L .21975 .50367 L p F P
0 g
s
.806 .403 .288 r
.16927 .4794 m .21975 .50367 L .21534 .52193 L p F P
0 g
s
.598 .192 .243 r
.7497 .53034 m .70102 .53101 L .69858 .51011 L p F P
0 g
s
.598 .192 .243 r
.69858 .51011 m .74652 .50943 L .7497 .53034 L p F P
0 g
s
.716 .283 .221 r
.65077 .49756 m .69858 .51011 L .70102 .53101 L p F P
0 g
s
.858 .866 .844 r
.16932 .34472 m .1173 .37369 L .11504 .36379 L p F P
0 g
s
.858 .866 .844 r
.11504 .36379 m .16556 .32596 L .16932 .34472 L p F P
0 g
s
.47 .104 .261 r
.79851 .51374 m .7497 .53034 L .74652 .50943 L p F P
0 g
s
.47 .104 .261 r
.74652 .50943 m .79505 .49552 L .79851 .51374 L p F P
0 g
s
.823 .509 .459 r
.65077 .49756 m .60262 .47318 L .60198 .45141 L p F P
0 g
s
.856 .618 .577 r
.60198 .45141 m .55362 .42805 L .55342 .41323 L p F P
0 g
s
.863 .544 .446 r
.55362 .42805 m .60198 .45141 L .60262 .47318 L p F P
0 g
s
.283 0 .18 r
.40833 .48927 m .36067 .51989 L .36312 .50164 L p F P
0 g
s
.283 0 .18 r
.36312 .50164 m .40968 .47595 L .40833 .48927 L p F P
0 g
s
.457 .485 .799 r
.40847 .34105 m .45571 .36857 L .45626 .38235 L p F P
0 g
s
.342 .487 .859 r
.45571 .36857 m .40847 .34105 L .40684 .32223 L p F P
0 g
s
.429 .561 .885 r
.35909 .29574 m .40684 .32223 L .40847 .34105 L p F P
0 g
s
.539 .818 .997 r
.31146 .28212 m .26357 .28287 L .2585 .26759 L p F P
0 g
s
.698 .915 .969 r
.26357 .28287 m .21503 .298 L .20987 .28478 L p F P
0 g
s
.698 .915 .969 r
.20987 .28478 m .2585 .26759 L .26357 .28287 L p F P
0 g
s
.446 .226 .485 r
.8953 .43464 m .84456 .46971 L .84199 .44793 L p F P
0 g
s
.446 .226 .485 r
.84199 .44793 m .8937 .42306 L .8953 .43464 L p F P
0 g
s
.336 .663 .973 r
.35909 .29574 m .31146 .28212 L .30718 .26682 L p F P
0 g
s
.539 .818 .997 r
.2585 .26759 m .30718 .26682 L .31146 .28212 L p F P
0 g
s
.716 .283 .221 r
.70102 .53101 m .65226 .51579 L .65077 .49756 L p F P
0 g
s
.797 .357 .201 r
.60262 .47318 m .65077 .49756 L .65226 .51579 L p F P
0 g
s
.869 .903 .853 r
.6004 .33811 m .5527 .3671 L .55252 .35714 L p F P
0 g
s
.869 .903 .853 r
.55252 .35714 m .60048 .31924 L .6004 .33811 L p F P
0 g
s
.363 .038 .274 r
.84764 .48301 m .79851 .51374 L .79505 .49552 L p F P
0 g
s
.363 .038 .274 r
.79505 .49552 m .84456 .46971 L .84764 .48301 L p F P
0 g
s
.795 .958 .919 r
.21503 .298 m .16556 .32596 L .1612 .31644 L p F P
0 g
s
.795 .958 .919 r
.1612 .31644 m .20987 .28478 L .21503 .298 L p F P
0 g
s
.494 .501 .793 r
.84105 .33442 m .89327 .36195 L .89238 .37579 L p F P
0 g
s
.411 .512 .851 r
.89327 .36195 m .84105 .33442 L .84329 .31548 L p F P
0 g
s
.472 .57 .873 r
.7931 .28894 m .84329 .31548 L .84105 .33442 L p F P
0 g
s
.539 .818 .997 r
.74405 .27529 m .69585 .27605 L .69787 .26061 L p F P
0 g
s
.675 .928 .971 r
.69585 .27605 m .64813 .29122 L .64922 .27785 L p F P
0 g
s
.675 .928 .971 r
.64922 .27785 m .69787 .26061 L .69585 .27605 L p F P
0 g
s
.806 .403 .288 r
.21534 .52193 m .16547 .49273 L .16927 .4794 L p F P
0 g
s
.849 .456 .299 r
.11712 .446 m .16927 .4794 L .16547 .49273 L p F P
0 g
s
.85 .555 .49 r
.16927 .4794 m .11712 .446 L .11883 .43444 L p F P
0 g
s
.15 .5 .908 r
.40684 .32223 m .35909 .29574 L .35601 .28247 L p F P
0 g
s
.336 .663 .973 r
.30718 .26682 m .35601 .28247 L .35909 .29574 L p F P
0 g
s
.389 .674 .973 r
.7931 .28894 m .74405 .27529 L .74686 .25983 L p F P
0 g
s
.539 .818 .997 r
.69787 .26061 m .74686 .25983 L .74405 .27529 L p F P
0 g
s
.852 .678 .666 r
.06349 .40728 m .1198 .40335 L .11976 .41964 L closepath p F P
0 g
s
.854 .73 .725 r
.06349 .40728 m .11894 .38741 L .1198 .40335 L closepath p F P
0 g
s
.856 .629 .594 r
.06349 .40728 m .11976 .41964 L .11883 .43444 L closepath p F P
0 g
s
.172 0 .159 r
.45602 .44797 m .40833 .48927 L .40968 .47595 L p F P
0 g
s
.172 0 .159 r
.40968 .47595 m .45649 .44105 L .45602 .44797 L p F P
0 g
s
.862 .792 .78 r
.06349 .40728 m .1173 .37369 L .11894 .38741 L closepath p F P
0 g
s
.765 .982 .909 r
.64813 .29122 m .60048 .31924 L .60077 .30961 L p F P
0 g
s
.765 .982 .909 r
.60077 .30961 m .64922 .27785 L .64813 .29122 L p F P
0 g
s
.475 .372 .658 r
.45664 .39832 m .50398 .40072 L .45682 .41466 L closepath p F P
0 g
s
.469 .426 .727 r
.45626 .38235 m .50398 .40072 L .45664 .39832 L closepath p F P
0 g
s
.797 .357 .201 r
.65226 .51579 m .60323 .48649 L .60262 .47318 L p F P
0 g
s
.842 .405 .187 r
.55376 .43963 m .60262 .47318 L .60323 .48649 L p F P
0 g
s
.863 .544 .446 r
.60262 .47318 m .55376 .43963 L .55362 .42805 L p F P
0 g
s
.268 .545 .924 r
.84329 .31548 m .7931 .28894 L .79629 .27553 L p F P
0 g
s
.389 .674 .973 r
.74686 .25983 m .79629 .27553 L .7931 .28894 L p F P
0 g
s
.443 .284 .569 r
.45682 .41466 m .50398 .40072 L .45676 .42948 L closepath p F P
0 g
s
.869 .689 .657 r
.50398 .40072 m .55318 .39688 L .55342 .41323 L closepath p F P
0 g
s
.871 .748 .724 r
.50398 .40072 m .55293 .38089 L .55318 .39688 L closepath p F P
0 g
s
.845 .971 .878 r
.16556 .32596 m .11504 .36379 L .11242 .35893 L p F P
0 g
s
.845 .971 .878 r
.11242 .35893 m .1612 .31644 L .16556 .32596 L p F P
0 g
s
.865 .572 .49 r
.06349 .40728 m .11883 .43444 L .11712 .446 L closepath p F P
0 g
s
.873 .632 .572 r
.50398 .40072 m .55342 .41323 L .55362 .42805 L closepath p F P
0 g
s
.422 .456 .79 r
.45571 .36857 m .50398 .40072 L .45626 .38235 L closepath p F P
0 g
s
.292 0 .282 r
.89722 .44156 m .84764 .48301 L .84456 .46971 L p F P
0 g
s
.292 0 .282 r
.84456 .46971 m .8953 .43464 L .89722 .44156 L p F P
0 g
s
.88 .82 .785 r
.50398 .40072 m .5527 .3671 L .55293 .38089 L closepath p F P
0 g
s
.874 .873 .832 r
.06349 .40728 m .11504 .36379 L .1173 .37369 L closepath p F P
0 g
s
.342 .487 .859 r
.40684 .32223 m .45506 .35862 L .45571 .36857 L p F P
0 g
s
.025 .379 .843 r
.45506 .35862 m .40684 .32223 L .40506 .31265 L p F P
0 g
s
.15 .5 .908 r
.35601 .28247 m .40506 .31265 L .40684 .32223 L p F P
0 g
s
.507 .4 .667 r
.89216 .39183 m .9473 .39412 L .89261 .40821 L closepath p F P
0 g
s
.503 .449 .729 r
.89238 .37579 m .9473 .39412 L .89216 .39183 L closepath p F P
0 g
s
.352 .129 .429 r
.45676 .42948 m .50398 .40072 L .45649 .44105 L closepath p F P
0 g
s
.484 .327 .593 r
.89261 .40821 m .9473 .39412 L .8937 .42306 L closepath p F P
0 g
s
.811 .998 .85 r
.60048 .31924 m .55252 .35714 L .5524 .35223 L p F P
0 g
s
.811 .998 .85 r
.5524 .35223 m .60077 .30961 L .60048 .31924 L p F P
0 g
s
.245 0 0 r
.30855 .54194 m .25935 .54262 L .2644 .53709 L p F P
0 g
s
.245 0 0 r
.2644 .53709 m .31278 .53642 L .30855 .54194 L p F P
0 g
s
.501 0 0 r
.21534 .52193 m .2644 .53709 L .25935 .54262 L p F P
0 g
s
.881 .561 .44 r
.50398 .40072 m .55362 .42805 L .55376 .43963 L closepath p F P
0 g
s
0 0 0 r
.35768 .52449 m .30855 .54194 L .31278 .53642 L p F P
0 g
s
0 0 0 r
.31278 .53642 m .36067 .51989 L .35768 .52449 L p F P
0 g
s
.469 .478 .785 r
.89327 .36195 m .9473 .39412 L .89238 .37579 L closepath p F P
0 g
s
.296 .447 .843 r
.45506 .35862 m .50398 .40072 L .45571 .36857 L closepath p F P
0 g
s
.501 0 0 r
.25935 .54262 m .21015 .52656 L .21534 .52193 L p F P
0 g
s
.659 .104 0 r
.16547 .49273 m .21534 .52193 L .21015 .52656 L p F P
0 g
s
.849 .456 .299 r
.16547 .49273 m .11481 .45294 L .11712 .446 L p F P
0 g
s
.868 .481 .305 r
.06349 .40728 m .11712 .446 L .11481 .45294 L closepath p F P
0 g
s
.888 .914 .837 r
.50398 .40072 m .55252 .35714 L .5527 .3671 L closepath p F P
0 g
s
.411 .512 .851 r
.84329 .31548 m .89472 .35194 L .89327 .36195 L p F P
0 g
s
.193 .459 .881 r
.89472 .35194 m .84329 .31548 L .8462 .3058 L p F P
0 g
s
.268 .545 .924 r
.79629 .27553 m .8462 .3058 L .84329 .31548 L p F P
0 g
s
0 0 0 r
.40665 .49234 m .35768 .52449 L .36067 .51989 L p F P
0 g
s
0 0 0 r
.36067 .51989 m .40833 .48927 L .40665 .49234 L p F P
0 g
s
.418 .207 .484 r
.8937 .42306 m .9473 .39412 L .8953 .43464 L closepath p F P
0 g
s
.865 .974 .856 r
.06349 .40728 m .11242 .35893 L .11504 .36379 L closepath p F P
0 g
s
.245 0 0 r
.75301 .53577 m .70348 .53646 L .70102 .53101 L p F P
0 g
s
.245 0 0 r
.70102 .53101 m .7497 .53034 L .75301 .53577 L p F P
0 g
s
.416 0 0 r
.65226 .51579 m .70102 .53101 L .70348 .53646 L p F P
0 g
s
.659 .104 0 r
.21015 .52656 m .16107 .49583 L .16547 .49273 L p F P
0 g
s
.739 .216 0 r
.11481 .45294 m .16547 .49273 L .16107 .49583 L p F P
0 g
s
.069 0 0 r
.80216 .51826 m .75301 .53577 L .7497 .53034 L p F P
0 g
s
.069 0 0 r
.7497 .53034 m .79851 .51374 L .80216 .51826 L p F P
0 g
s
.118 0 .15 r
.45649 .44105 m .50398 .40072 L .45602 .44797 L closepath p F P
0 g
s
.381 .483 .839 r
.89472 .35194 m .9473 .39412 L .89327 .36195 L closepath p F P
0 g
s
.416 0 0 r
.70348 .53646 m .65368 .52034 L .65226 .51579 L p F P
0 g
s
.53 0 0 r
.60323 .48649 m .65226 .51579 L .65368 .52034 L p F P
0 g
s
.842 .405 .187 r
.60323 .48649 m .55382 .44655 L .55376 .43963 L p F P
0 g
s
.861 .428 .181 r
.50398 .40072 m .55376 .43963 L .55382 .44655 L closepath p F P
0 g
s
0 0 0 r
.45541 .44936 m .40665 .49234 L .40833 .48927 L p F P
0 g
s
0 0 0 r
.40833 .48927 m .45602 .44797 L .45541 .44936 L p F P
0 g
s
0 0 0 r
.8509 .48602 m .80216 .51826 L .79851 .51374 L p F P
0 g
s
0 0 0 r
.79851 .51374 m .84764 .48301 L .8509 .48602 L p F P
0 g
s
0 .319 .807 r
.45439 .35372 m .50398 .40072 L .45506 .35862 L closepath p F P
0 g
s
.025 .379 .843 r
.40506 .31265 m .45439 .35372 L .45506 .35862 L p F P
0 g
s
.829 1 .818 r
.50398 .40072 m .5524 .35223 L .55252 .35714 L closepath p F P
0 g
s
.279 .771 .709 r
.2585 .26759 m .20987 .28478 L .20457 .28583 L p F P
0 g
s
.279 .771 .709 r
.20457 .28583 m .2533 .26849 L .2585 .26759 L p F P
0 g
s
.029 0 0 r
.30718 .26682 m .2585 .26759 L .2533 .26849 L p F P
0 g
s
.53 0 0 r
.65368 .52034 m .60374 .48953 L .60323 .48649 L p F P
0 g
s
.591 .047 0 r
.55382 .44655 m .60323 .48649 L .60374 .48953 L p F P
0 g
s
.739 .216 0 r
.16107 .49583 m .11217 .45435 L .11481 .45294 L p F P
0 g
s
.773 .267 0 r
.06349 .40728 m .11481 .45294 L .11217 .45435 L closepath p F P
0 g
s
.495 .881 .697 r
.20987 .28478 m .1612 .31644 L .15673 .31757 L p F P
0 g
s
.495 .881 .697 r
.15673 .31757 m .20457 .28583 L .20987 .28478 L p F P
0 g
s
.318 0 0 r
.35601 .28247 m .30718 .26682 L .30283 .2677 L p F P
0 g
s
.029 0 0 r
.2533 .26849 m .30283 .2677 L .30718 .26682 L p F P
0 g
s
.259 0 .286 r
.8953 .43464 m .9473 .39412 L .89722 .44156 L closepath p F P
0 g
s
.611 .922 .675 r
.1612 .31644 m .11242 .35893 L .10976 .35978 L p F P
0 g
s
.611 .922 .675 r
.10976 .35978 m .15673 .31757 L .1612 .31644 L p F P
0 g
s
.498 0 0 r
.40506 .31265 m .35601 .28247 L .35293 .28349 L p F P
0 g
s
.318 0 0 r
.30283 .2677 m .35293 .28349 L .35601 .28247 L p F P
0 g
s
0 0 0 r
.89925 .44291 m .8509 .48602 L .84764 .48301 L p F P
0 g
s
0 0 0 r
.84764 .48301 m .89722 .44156 L .89925 .44291 L p F P
0 g
s
.159 .418 .858 r
.89656 .34698 m .9473 .39412 L .89472 .35194 L closepath p F P
0 g
s
.193 .459 .881 r
.8462 .3058 m .89656 .34698 L .89472 .35194 L p F P
0 g
s
.661 .935 .662 r
.06349 .40728 m .10976 .35978 L .11242 .35893 L closepath p F P
0 g
s
0 0 0 r
.45602 .44797 m .50398 .40072 L .45541 .44936 L closepath p F P
0 g
s
.585 .041 0 r
.45439 .35372 m .40506 .31265 L .40334 .31374 L p F P
0 g
s
.498 0 0 r
.35293 .28349 m .40334 .31374 L .40506 .31265 L p F P
0 g
s
.029 0 0 r
.74686 .25983 m .69787 .26061 L .7003 .26139 L p F P
0 g
s
0 0 0 r
.69787 .26061 m .64922 .27785 L .65061 .2788 L p F P
0 g
s
0 0 0 r
.65061 .2788 m .7003 .26139 L .69787 .26061 L p F P
0 g
s
.591 .047 0 r
.60374 .48953 m .5538 .44793 L .55382 .44655 L p F P
0 g
s
.617 .091 0 r
.50398 .40072 m .55382 .44655 L .5538 .44793 L closepath p F P
0 g
s
0 0 0 r
.64922 .27785 m .60077 .30961 L .60125 .31067 L p F P
0 g
s
0 0 0 r
.60125 .31067 m .65061 .2788 L .64922 .27785 L p F P
0 g
s
0 .386 .687 r
.79629 .27553 m .74686 .25983 L .75015 .2606 L p F P
0 g
s
.029 0 0 r
.7003 .26139 m .75015 .2606 L .74686 .25983 L p F P
0 g
s
.386 .223 .535 r
.06349 .40728 m .10459 .39302 L .10558 .37788 L closepath p F P
0 g
s
.43 .333 .644 r
.06349 .40728 m .10454 .40987 L .10459 .39302 L closepath p F P
0 g
s
.422 .395 .724 r
.06349 .40728 m .10544 .4263 L .10454 .40987 L closepath p F P
0 g
s
.356 .422 .792 r
.06349 .40728 m .10718 .44024 L .10544 .4263 L closepath p F P
0 g
s
.169 .387 .833 r
.06349 .40728 m .10952 .44997 L .10718 .44024 L closepath p F P
0 g
s
0 .156 .67 r
.06349 .40728 m .11217 .45435 L .10952 .44997 L closepath p F P
0 g
s
0 0 0 r
.06349 .40728 m .10738 .36634 L .10976 .35978 L closepath p F P
0 g
s
.254 .016 .347 r
.06349 .40728 m .10558 .37788 L .10738 .36634 L closepath p F P
0 g
s
0 0 0 r
.60077 .30961 m .5524 .35223 L .55237 .35304 L p F P
0 g
s
0 0 0 r
.55237 .35304 m .60125 .31067 L .60077 .30961 L p F P
0 g
s
0 .243 .664 r
.8462 .3058 m .79629 .27553 L .79993 .27644 L p F P
0 g
s
0 .386 .687 r
.75015 .2606 m .79993 .27644 L .79629 .27553 L p F P
0 g
s
.617 .091 0 r
.45377 .35454 m .50398 .40072 L .45439 .35372 L closepath p F P
0 g
s
.585 .041 0 r
.40334 .31374 m .45377 .35454 L .45439 .35372 L p F P
0 g
s
0 0 0 r
.50398 .40072 m .55237 .35304 L .5524 .35223 L closepath p F P
0 g
s
0 0 0 r
.89722 .44156 m .9473 .39412 L .89925 .44291 L closepath p F P
0 g
s
0 .157 .637 r
.89656 .34698 m .8462 .3058 L .84945 .30681 L p F P
0 g
s
0 .243 .664 r
.79993 .27644 m .84945 .30681 L .8462 .3058 L p F P
0 g
s
0 .239 .731 r
.15658 .48799 m .10952 .44997 L .11217 .45435 L p F P
0 g
s
0 .239 .731 r
.11217 .45435 m .16107 .49583 L .15658 .48799 L p F P
0 g
s
.118 0 .15 r
.50398 .40072 m .55242 .35958 L .55237 .35304 L closepath p F P
0 g
s
.352 .129 .429 r
.50398 .40072 m .55256 .37113 L .55242 .35958 L closepath p F P
0 g
s
.443 .284 .569 r
.50398 .40072 m .55277 .3863 L .55256 .37113 L closepath p F P
0 g
s
.475 .372 .658 r
.50398 .40072 m .55301 .4032 L .55277 .3863 L closepath p F P
0 g
s
.469 .426 .727 r
.50398 .40072 m .55327 .41969 L .55301 .4032 L closepath p F P
0 g
s
.422 .456 .79 r
.50398 .40072 m .5535 .4337 L .55327 .41969 L closepath p F P
0 g
s
.296 .447 .843 r
.50398 .40072 m .55369 .4435 L .5535 .4337 L closepath p F P
0 g
s
0 .319 .807 r
.50398 .40072 m .5538 .44793 L .55369 .4435 L closepath p F P
0 g
s
.873 .632 .572 r
.45292 .3878 m .50398 .40072 L .45298 .37264 L closepath p F P
0 g
s
.869 .689 .657 r
.4531 .40469 m .50398 .40072 L .45292 .3878 L closepath p F P
0 g
s
.871 .748 .724 r
.4535 .42117 m .50398 .40072 L .4531 .40469 L closepath p F P
0 g
s
.88 .82 .785 r
.45407 .43516 m .50398 .40072 L .4535 .42117 L closepath p F P
0 g
s
.888 .914 .837 r
.45474 .44494 m .50398 .40072 L .45407 .43516 L closepath p F P
0 g
s
.829 1 .818 r
.45541 .44936 m .50398 .40072 L .45474 .44494 L closepath p F P
0 g
s
.861 .428 .181 r
.45328 .36109 m .50398 .40072 L .45377 .35454 L closepath p F P
0 g
s
.881 .561 .44 r
.45298 .37264 m .50398 .40072 L .45328 .36109 L closepath p F P
0 g
s
0 .12 .624 r
.89859 .34777 m .9473 .39412 L .89656 .34698 L closepath p F P
0 g
s
0 .157 .637 r
.84945 .30681 m .89859 .34777 L .89656 .34698 L p F P
0 g
s
0 .401 .838 r
.2048 .51639 m .15658 .48799 L .16107 .49583 L p F P
0 g
s
0 .401 .838 r
.16107 .49583 m .21015 .52656 L .2048 .51639 L p F P
0 g
s
0 0 0 r
.15673 .31757 m .10976 .35978 L .10738 .36634 L p F P
0 g
s
.809 .998 .849 r
.40665 .49234 m .45541 .44936 L .45474 .44494 L p F P
0 g
s
.019 .376 .841 r
.60408 .4816 m .55369 .4435 L .5538 .44793 L p F P
0 g
s
.019 .376 .841 r
.5538 .44793 m .60374 .48953 L .60408 .4816 L p F P
0 g
s
.194 .617 .946 r
.25406 .53129 m .2048 .51639 L .21015 .52656 L p F P
0 g
s
.194 .617 .946 r
.21015 .52656 m .25935 .54262 L .25406 .53129 L p F P
0 g
s
.809 .998 .849 r
.45474 .44494 m .40483 .48444 L .40665 .49234 L p F P
0 g
s
.756 .985 .904 r
.35768 .52449 m .40665 .49234 L .40483 .48444 L p F P
0 g
s
.816 .333 0 r
.90056 .3543 m .9473 .39412 L .89859 .34777 L closepath p F P
0 g
s
.895 .541 .365 r
.90223 .36585 m .9473 .39412 L .90056 .3543 L closepath p F P
0 g
s
.894 .635 .54 r
.90337 .38105 m .9473 .39412 L .90223 .36585 L closepath p F P
0 g
s
.89 .703 .644 r
.90385 .39799 m .9473 .39412 L .90337 .38105 L closepath p F P
0 g
s
.892 .772 .721 r
.9036 .41453 m .9473 .39412 L .90385 .39799 L closepath p F P
0 g
s
.901 .855 .788 r
.90266 .42859 m .9473 .39412 L .9036 .41453 L closepath p F P
0 g
s
.893 .959 .832 r
.90114 .43843 m .9473 .39412 L .90266 .42859 L closepath p F P
0 g
s
.719 .965 .706 r
.89925 .44291 m .9473 .39412 L .90114 .43843 L closepath p F P
0 g
s
.451 .816 .995 r
.3041 .53059 m .25406 .53129 L .25935 .54262 L p F P
0 g
s
.451 .816 .995 r
.25935 .54262 m .30855 .54194 L .3041 .53059 L p F P
0 g
s
.756 .985 .904 r
.40483 .48444 m .3545 .51428 L .35768 .52449 L p F P
0 g
s
.645 .936 .966 r
.30855 .54194 m .35768 .52449 L .3545 .51428 L p F P
0 g
s
.842 .403 .183 r
.45377 .35454 m .40334 .31374 L .40188 .32572 L p F P
0 g
s
.842 .403 .183 r
.40188 .32572 m .45328 .36109 L .45377 .35454 L p F P
0 g
s
.645 .936 .966 r
.3545 .51428 m .3041 .53059 L .30855 .54194 L p F P
0 g
s
.122 .487 .901 r
.65488 .51005 m .60408 .4816 L .60374 .48953 L p F P
0 g
s
.122 .487 .901 r
.60374 .48953 m .65368 .52034 L .65488 .51005 L p F P
0 g
s
.168 0 .155 r
.60125 .31067 m .55237 .35304 L .55242 .35958 L p F P
0 g
s
.713 .976 .76 r
.8509 .48602 m .89925 .44291 L .90114 .43843 L p F P
0 g
s
.236 .443 .859 r
.15256 .46984 m .10718 .44024 L .10952 .44997 L p F P
0 g
s
.236 .443 .859 r
.10952 .44997 m .15658 .48799 L .15256 .46984 L p F P
0 g
s
.144 0 .022 r
.20457 .28583 m .15673 .31757 L .15271 .32957 L p F P
0 g
s
0 0 0 r
.10738 .36634 m .15271 .32957 L .15673 .31757 L p F P
0 g
s
.274 .646 .966 r
.70569 .52499 m .65488 .51005 L .65368 .52034 L p F P
0 g
s
.274 .646 .966 r
.65368 .52034 m .70348 .53646 L .70569 .52499 L p F P
0 g
s
.713 .976 .76 r
.90114 .43843 m .85395 .47803 L .8509 .48602 L p F P
0 g
s
.683 .979 .853 r
.80216 .51826 m .8509 .48602 L .85395 .47803 L p F P
0 g
s
.313 .064 .367 r
.15271 .32957 m .10738 .36634 L .10558 .37788 L p F P
0 g
s
.451 .816 .995 r
.75605 .52428 m .70569 .52499 L .70348 .53646 L p F P
0 g
s
.451 .816 .995 r
.70348 .53646 m .75301 .53577 L .75605 .52428 L p F P
0 g
s
.683 .979 .853 r
.85395 .47803 m .80556 .50793 L .80216 .51826 L p F P
0 g
s
.6 .936 .95 r
.75301 .53577 m .80216 .51826 L .80556 .50793 L p F P
0 g
s
.805 .316 .015 r
.89859 .34777 m .84945 .30681 L .85267 .31876 L p F P
0 g
s
.805 .316 .015 r
.85267 .31876 m .90056 .3543 L .89859 .34777 L p F P
0 g
s
.794 .346 .18 r
.40334 .31374 m .35293 .28349 L .35024 .29929 L p F P
0 g
s
.794 .346 .18 r
.35024 .29929 m .40188 .32572 L .40334 .31374 L p F P
0 g
s
.6 .936 .95 r
.80556 .50793 m .75605 .52428 L .75301 .53577 L p F P
0 g
s
.87 .905 .853 r
.40483 .48444 m .45474 .44494 L .45407 .43516 L p F P
0 g
s
.339 .486 .859 r
.6042 .46333 m .5535 .4337 L .55369 .4435 L p F P
0 g
s
.339 .486 .859 r
.55369 .4435 m .60408 .4816 L .6042 .46333 L p F P
0 g
s
.35 0 .081 r
.2533 .26849 m .20457 .28583 L .19979 .30164 L p F P
0 g
s
.144 0 .022 r
.15271 .32957 m .19979 .30164 L .20457 .28583 L p F P
0 g
s
.264 0 .158 r
.65061 .2788 m .60125 .31067 L .60187 .32263 L p F P
0 g
s
.168 0 .155 r
.55242 .35958 m .60187 .32263 L .60125 .31067 L p F P
0 g
s
.863 .544 .445 r
.45328 .36109 m .40188 .32572 L .40089 .34739 L p F P
0 g
s
.863 .544 .445 r
.40089 .34739 m .45298 .37264 L .45328 .36109 L p F P
0 g
s
.703 .247 .166 r
.35293 .28349 m .30283 .2677 L .29895 .28547 L p F P
0 g
s
.703 .247 .166 r
.29895 .28547 m .35024 .29929 L .35293 .28349 L p F P
0 g
s
.404 .461 .805 r
.14955 .44345 m .10544 .4263 L .10718 .44024 L p F P
0 g
s
.404 .461 .805 r
.10718 .44024 m .15256 .46984 L .14955 .44345 L p F P
0 g
s
.391 .157 .436 r
.60187 .32263 m .55242 .35958 L .55256 .37113 L p F P
0 g
s
.552 .1 .133 r
.30283 .2677 m .2533 .26849 L .24863 .28626 L p F P
0 g
s
.35 0 .081 r
.19979 .30164 m .24863 .28626 L .2533 .26849 L p F P
0 g
s
.767 .274 .052 r
.84945 .30681 m .79993 .27644 L .80359 .2922 L p F P
0 g
s
.767 .274 .052 r
.80359 .2922 m .85267 .31876 L .84945 .30681 L p F P
0 g
s
.552 .1 .133 r
.24863 .28626 m .29895 .28547 L .30283 .2677 L p F P
0 g
s
.876 .947 .856 r
.85395 .47803 m .90114 .43843 L .90266 .42859 L p F P
0 g
s
.431 .26 .547 r
.14965 .35123 m .10558 .37788 L .10459 .39302 L p F P
0 g
s
.313 .064 .367 r
.10558 .37788 m .14965 .35123 L .15271 .32957 L p F P
0 g
s
.399 0 .153 r
.7003 .26139 m .65061 .2788 L .65214 .29457 L p F P
0 g
s
.264 0 .158 r
.60187 .32263 m .65214 .29457 L .65061 .2788 L p F P
0 g
s
.358 .541 .898 r
.19994 .49208 m .15256 .46984 L .15658 .48799 L p F P
0 g
s
.358 .541 .898 r
.15658 .48799 m .2048 .51639 L .19994 .49208 L p F P
0 g
s
.863 .808 .794 r
.4031 .46623 m .45407 .43516 L .4535 .42117 L p F P
0 g
s
.87 .905 .853 r
.45407 .43516 m .4031 .46623 L .40483 .48444 L p F P
0 g
s
.876 .525 .382 r
.90056 .3543 m .85267 .31876 L .85544 .34044 L p F P
0 g
s
.876 .525 .382 r
.85544 .34044 m .90223 .36585 L .90056 .3543 L p F P
0 g
s
.684 .2 .096 r
.79993 .27644 m .75015 .2606 L .75351 .27831 L p F P
0 g
s
.684 .2 .096 r
.75351 .27831 m .80359 .2922 L .79993 .27644 L p F P
0 g
s
.456 .484 .799 r
.60407 .43681 m .55327 .41969 L .5535 .4337 L p F P
0 g
s
.456 .484 .799 r
.5535 .4337 m .6042 .46333 L .60407 .43681 L p F P
0 g
s
.462 .427 .733 r
.14795 .41213 m .10454 .40987 L .10544 .4263 L p F P
0 g
s
.462 .427 .733 r
.10544 .4263 m .14955 .44345 L .14795 .41213 L p F P
0 g
s
.552 .1 .133 r
.75015 .2606 m .7003 .26139 L .70286 .27911 L p F P
0 g
s
.399 0 .153 r
.65214 .29457 m .70286 .27911 L .7003 .26139 L p F P
0 g
s
.857 .618 .577 r
.45298 .37264 m .40089 .34739 L .40051 .37617 L p F P
0 g
s
.857 .618 .577 r
.40051 .37617 m .45292 .3878 L .45298 .37264 L p F P
0 g
s
.552 .1 .133 r
.70286 .27911 m .75351 .27831 L .75015 .2606 L p F P
0 g
s
.829 .881 .881 r
.3545 .51428 m .40483 .48444 L .4031 .46623 L p F P
0 g
s
.431 .26 .547 r
.10459 .39302 m .14799 .37998 L .14965 .35123 L p F P
0 g
s
.469 .364 .653 r
.14799 .37998 m .10459 .39302 L .10454 .40987 L p F P
0 g
s
.391 .157 .436 r
.55256 .37113 m .60254 .34431 L .60187 .32263 L p F P
0 g
s
.474 .308 .575 r
.60254 .34431 m .55256 .37113 L .55277 .3863 L p F P
0 g
s
.469 .364 .653 r
.10454 .40987 m .14795 .41213 L .14799 .37998 L p F P
0 g
s
.419 .558 .888 r
.65568 .48558 m .6042 .46333 L .60408 .4816 L p F P
0 g
s
.419 .558 .888 r
.60408 .4816 m .65488 .51005 L .65568 .48558 L p F P
0 g
s
.881 .839 .8 r
.85639 .45969 m .90266 .42859 L .9036 .41453 L p F P
0 g
s
.876 .947 .856 r
.90266 .42859 m .85639 .45969 L .85395 .47803 L p F P
0 g
s
.855 .736 .731 r
.40169 .43977 m .4535 .42117 L .4531 .40469 L p F P
0 g
s
.863 .808 .794 r
.4535 .42117 m .40169 .43977 L .4031 .46623 L p F P
0 g
s
.417 .15 .398 r
.19979 .30164 m .15271 .32957 L .14965 .35123 L p F P
0 g
s
.498 .45 .734 r
.60372 .40537 m .55301 .4032 L .55327 .41969 L p F P
0 g
s
.498 .45 .734 r
.55327 .41969 m .60407 .43681 L .60372 .40537 L p F P
0 g
s
.853 .677 .663 r
.45292 .3878 m .40051 .37617 L .40078 .40838 L p F P
0 g
s
.853 .677 .663 r
.40078 .40838 m .4531 .40469 L .45292 .3878 L p F P
0 g
s
.874 .62 .551 r
.90223 .36585 m .85544 .34044 L .85739 .36928 L p F P
0 g
s
.874 .62 .551 r
.85739 .36928 m .90337 .38105 L .90223 .36585 L p F P
0 g
s
.832 .914 .892 r
.80556 .50793 m .85395 .47803 L .85639 .45969 L p F P
0 g
s
.855 .736 .731 r
.4531 .40469 m .40078 .40838 L .40169 .43977 L p F P
0 g
s
.474 .308 .575 r
.55277 .3863 m .60319 .37312 L .60254 .34431 L p F P
0 g
s
.503 .395 .664 r
.60319 .37312 m .55277 .3863 L .55301 .4032 L p F P
0 g
s
.506 .657 .927 r
.24922 .50373 m .19994 .49208 L .2048 .51639 L p F P
0 g
s
.506 .657 .927 r
.2048 .51639 m .25406 .53129 L .24922 .50373 L p F P
0 g
s
.824 .507 .452 r
.40188 .32572 m .35024 .29929 L .34831 .32845 L p F P
0 g
s
.824 .507 .452 r
.34831 .32845 m .40089 .34739 L .40188 .32572 L p F P
0 g
s
.503 .395 .664 r
.55301 .4032 m .60372 .40537 L .60319 .37312 L p F P
0 g
s
.829 .881 .881 r
.4031 .46623 m .35152 .48992 L .3545 .51428 L p F P
0 g
s
.757 .836 .912 r
.3041 .53059 m .3545 .51428 L .35152 .48992 L p F P
0 g
s
.873 .756 .73 r
.85789 .4331 m .9036 .41453 L .90385 .39799 L p F P
0 g
s
.881 .839 .8 r
.9036 .41453 m .85789 .4331 L .85639 .45969 L p F P
0 g
s
.462 .21 .446 r
.65214 .29457 m .60187 .32263 L .60254 .34431 L p F P
0 g
s
.871 .688 .653 r
.90337 .38105 m .85739 .36928 L .85824 .40159 L p F P
0 g
s
.871 .688 .653 r
.85824 .40159 m .90385 .39799 L .90337 .38105 L p F P
0 g
s
.873 .756 .73 r
.90385 .39799 m .85824 .40159 L .85789 .4331 L p F P
0 g
s
.647 .761 .932 r
.29997 .50301 m .24922 .50373 L .25406 .53129 L p F P
0 g
s
.647 .761 .932 r
.25406 .53129 m .3041 .53059 L .29997 .50301 L p F P
0 g
s
.528 .656 .917 r
.70734 .49724 m .65568 .48558 L .65488 .51005 L p F P
0 g
s
.528 .656 .917 r
.65488 .51005 m .70569 .52499 L .70734 .49724 L p F P
0 g
s
.832 .489 .407 r
.85267 .31876 m .80359 .2922 L .80679 .32138 L p F P
0 g
s
.832 .489 .407 r
.80679 .32138 m .85544 .34044 L .85267 .31876 L p F P
0 g
s
.757 .836 .912 r
.35152 .48992 m .29997 .50301 L .3041 .53059 L p F P
0 g
s
.489 .528 .823 r
.19624 .45633 m .14955 .44345 L .15256 .46984 L p F P
0 g
s
.489 .528 .823 r
.15256 .46984 m .19994 .49208 L .19624 .45633 L p F P
0 g
s
.832 .914 .892 r
.85639 .45969 m .80827 .48341 L .80556 .50793 L p F P
0 g
s
.755 .852 .923 r
.75605 .52428 m .80556 .50793 L .80827 .48341 L p F P
0 g
s
.543 .256 .429 r
.24863 .28626 m .19979 .30164 L .19616 .3308 L p F P
0 g
s
.417 .15 .398 r
.14965 .35123 m .19616 .3308 L .19979 .30164 L p F P
0 g
s
.828 .783 .81 r
.35152 .48992 m .4031 .46623 L .40169 .43977 L p F P
0 g
s
.759 .446 .455 r
.35024 .29929 m .29895 .28547 L .29609 .31861 L p F P
0 g
s
.759 .446 .455 r
.29609 .31861 m .34831 .32845 L .35024 .29929 L p F P
0 g
s
.647 .761 .932 r
.75843 .49652 m .70734 .49724 L .70569 .52499 L p F P
0 g
s
.647 .761 .932 r
.70569 .52499 m .75605 .52428 L .75843 .49652 L p F P
0 g
s
.508 .324 .566 r
.19616 .3308 m .14965 .35123 L .14799 .37998 L p F P
0 g
s
.755 .852 .923 r
.80827 .48341 m .75843 .49652 L .75605 .52428 L p F P
0 g
s
.518 .537 .815 r
.65597 .44965 m .60407 .43681 L .6042 .46333 L p F P
0 g
s
.518 .537 .815 r
.6042 .46333 m .65568 .48558 L .65597 .44965 L p F P
0 g
s
.558 .281 .452 r
.70286 .27911 m .65214 .29457 L .65363 .32374 L p F P
0 g
s
.462 .21 .446 r
.60254 .34431 m .65363 .32374 L .65214 .29457 L p F P
0 g
s
.823 .589 .585 r
.40089 .34739 m .34831 .32845 L .34742 .36752 L p F P
0 g
s
.823 .589 .585 r
.34742 .36752 m .40051 .37617 L .40089 .34739 L p F P
0 g
s
.663 .36 .448 r
.29895 .28547 m .24863 .28626 L .24512 .3194 L p F P
0 g
s
.543 .256 .429 r
.19616 .3308 m .24512 .3194 L .24863 .28626 L p F P
0 g
s
.839 .805 .818 r
.80827 .48341 m .85639 .45969 L .85789 .4331 L p F P
0 g
s
.663 .36 .448 r
.24512 .3194 m .29609 .31861 L .29895 .28547 L p F P
0 g
s
.76 .433 .432 r
.80359 .2922 m .75351 .27831 L .75653 .31147 L p F P
0 g
s
.76 .433 .432 r
.75653 .31147 m .80679 .32138 L .80359 .2922 L p F P
0 g
s
.532 .353 .584 r
.65363 .32374 m .60254 .34431 L .60319 .37312 L p F P
0 g
s
.533 .484 .747 r
.19424 .41367 m .14795 .41213 L .14955 .44345 L p F P
0 g
s
.533 .484 .747 r
.14955 .44345 m .19624 .45633 L .19424 .41367 L p F P
0 g
s
.508 .324 .566 r
.14799 .37998 m .19421 .36984 L .19616 .3308 L p F P
0 g
s
.538 .42 .667 r
.19421 .36984 m .14799 .37998 L .14795 .41213 L p F P
0 g
s
.833 .588 .568 r
.85544 .34044 m .80679 .32138 L .8091 .36053 L p F P
0 g
s
.833 .588 .568 r
.8091 .36053 m .85739 .36928 L .85544 .34044 L p F P
0 g
s
.823 .711 .742 r
.34914 .45411 m .40169 .43977 L .40078 .40838 L p F P
0 g
s
.828 .783 .81 r
.40169 .43977 m .34914 .45411 L .35152 .48992 L p F P
0 g
s
.663 .36 .448 r
.75351 .27831 m .70286 .27911 L .70521 .31226 L p F P
0 g
s
.558 .281 .452 r
.65363 .32374 m .70521 .31226 L .70286 .27911 L p F P
0 g
s
.663 .36 .448 r
.70521 .31226 m .75653 .31147 L .75351 .27831 L p F P
0 g
s
.591 .607 .836 r
.24549 .46294 m .19624 .45633 L .19994 .49208 L p F P
0 g
s
.591 .607 .836 r
.19994 .49208 m .24922 .50373 L .24549 .46294 L p F P
0 g
s
.538 .42 .667 r
.14795 .41213 m .19424 .41367 L .19421 .36984 L p F P
0 g
s
.552 .494 .745 r
.65568 .40682 m .60372 .40537 L .60407 .43681 L p F P
0 g
s
.552 .494 .745 r
.60407 .43681 m .65597 .44965 L .65568 .40682 L p F P
0 g
s
.821 .65 .671 r
.40051 .37617 m .34742 .36752 L .34771 .41139 L p F P
0 g
s
.821 .65 .671 r
.34771 .41139 m .40078 .40838 L .40051 .37617 L p F P
0 g
s
.77 .742 .827 r
.29997 .50301 m .35152 .48992 L .34914 .45411 L p F P
0 g
s
.823 .711 .742 r
.40078 .40838 m .34771 .41139 L .34914 .45411 L p F P
0 g
s
.532 .353 .584 r
.60319 .37312 m .65487 .36286 L .65363 .32374 L p F P
0 g
s
.556 .437 .672 r
.65487 .36286 m .60319 .37312 L .60372 .40537 L p F P
0 g
s
.834 .724 .744 r
.80989 .44742 m .85789 .4331 L .85824 .40159 L p F P
0 g
s
.839 .805 .818 r
.85789 .4331 m .80989 .44742 L .80827 .48341 L p F P
0 g
s
.6 .606 .83 r
.70818 .45625 m .65597 .44965 L .65568 .48558 L p F P
0 g
s
.6 .606 .83 r
.65568 .48558 m .70734 .49724 L .70818 .45625 L p F P
0 g
s
.556 .437 .672 r
.60372 .40537 m .65568 .40682 L .65487 .36286 L p F P
0 g
s
.602 .401 .582 r
.24512 .3194 m .19616 .3308 L .19421 .36984 L p F P
0 g
s
.832 .657 .666 r
.85739 .36928 m .8091 .36053 L .81019 .40453 L p F P
0 g
s
.832 .657 .666 r
.81019 .40453 m .85824 .40159 L .85739 .36928 L p F P
0 g
s
.773 .751 .833 r
.75843 .49652 m .80827 .48341 L .80989 .44742 L p F P
0 g
s
.69 .682 .837 r
.29674 .4622 m .24549 .46294 L .24922 .50373 L p F P
0 g
s
.69 .682 .837 r
.24922 .50373 m .29997 .50301 L .29674 .4622 L p F P
0 g
s
.768 .542 .591 r
.34831 .32845 m .29609 .31861 L .29465 .36321 L p F P
0 g
s
.768 .542 .591 r
.29465 .36321 m .34742 .36752 L .34831 .32845 L p F P
0 g
s
.77 .742 .827 r
.34914 .45411 m .29674 .4622 L .29997 .50301 L p F P
0 g
s
.834 .724 .744 r
.85824 .40159 m .81019 .40453 L .80989 .44742 L p F P
0 g
s
.609 .413 .591 r
.70521 .31226 m .65363 .32374 L .65487 .36286 L p F P
0 g
s
.69 .682 .837 r
.75978 .4555 m .70818 .45625 L .70734 .49724 L p F P
0 g
s
.69 .682 .837 r
.70734 .49724 m .75843 .49652 L .75978 .4555 L p F P
0 g
s
.771 .539 .583 r
.80679 .32138 m .75653 .31147 L .75877 .35616 L p F P
0 g
s
.771 .539 .583 r
.75877 .35616 m .8091 .36053 L .80679 .32138 L p F P
0 g
s
.773 .751 .833 r
.80989 .44742 m .75978 .4555 L .75843 .49652 L p F P
0 g
s
.618 .551 .757 r
.2434 .41414 m .19424 .41367 L .19624 .45633 L p F P
0 g
s
.618 .551 .757 r
.19624 .45633 m .24549 .46294 L .2434 .41414 L p F P
0 g
s
.693 .478 .591 r
.29609 .31861 m .24512 .3194 L .24328 .36399 L p F P
0 g
s
.602 .401 .582 r
.19421 .36984 m .24328 .36399 L .24512 .3194 L p F P
0 g
s
.693 .478 .591 r
.24328 .36399 m .29465 .36321 L .29609 .31861 L p F P
0 g
s
.771 .671 .753 r
.29674 .4622 m .34914 .45411 L .34771 .41139 L p F P
0 g
s
.621 .487 .678 r
.24328 .36399 m .19421 .36984 L .19424 .41367 L p F P
0 g
s
.77 .609 .679 r
.34742 .36752 m .29465 .36321 L .29488 .41338 L p F P
0 g
s
.77 .609 .679 r
.29488 .41338 m .34771 .41139 L .34742 .36752 L p F P
0 g
s
.623 .553 .754 r
.70808 .40725 m .65568 .40682 L .65597 .44965 L p F P
0 g
s
.623 .553 .754 r
.65597 .44965 m .70818 .45625 L .70808 .40725 L p F P
0 g
s
.621 .487 .678 r
.19424 .41367 m .2434 .41414 L .24328 .36399 L p F P
0 g
s
.693 .478 .591 r
.75653 .31147 m .70521 .31226 L .70704 .35694 L p F P
0 g
s
.609 .413 .591 r
.65487 .36286 m .70704 .35694 L .70521 .31226 L p F P
0 g
s
.693 .478 .591 r
.70704 .35694 m .75877 .35616 L .75653 .31147 L p F P
0 g
s
.775 .676 .755 r
.75978 .4555 m .80989 .44742 L .81019 .40453 L p F P
0 g
s
.771 .671 .753 r
.34771 .41139 m .29488 .41338 L .29674 .4622 L p F P
0 g
s
.626 .493 .68 r
.70704 .35694 m .65487 .36286 L .65568 .40682 L p F P
0 g
s
.701 .617 .759 r
.29488 .41338 m .2434 .41414 L .24549 .46294 L p F P
0 g
s
.701 .617 .759 r
.24549 .46294 m .29674 .4622 L .29488 .41338 L p F P
0 g
s
.774 .611 .678 r
.8091 .36053 m .75877 .35616 L .75991 .40649 L p F P
0 g
s
.774 .611 .678 r
.75991 .40649 m .81019 .40453 L .8091 .36053 L p F P
0 g
s
.626 .493 .68 r
.65568 .40682 m .70808 .40725 L .70704 .35694 L p F P
0 g
s
.775 .676 .755 r
.81019 .40453 m .75991 .40649 L .75978 .4555 L p F P
0 g
s
.702 .554 .683 r
.29465 .36321 m .24328 .36399 L .2434 .41414 L p F P
0 g
s
.702 .554 .683 r
.2434 .41414 m .29488 .41338 L .29465 .36321 L p F P
0 g
s
.701 .617 .759 r
.75991 .40649 m .70808 .40725 L .70818 .45625 L p F P
0 g
s
.701 .617 .759 r
.70818 .45625 m .75978 .4555 L .75991 .40649 L p F P
0 g
s
.702 .554 .683 r
.75877 .35616 m .70704 .35694 L .70808 .40725 L p F P
0 g
s
.702 .554 .683 r
.70808 .40725 m .75991 .40649 L .75877 .35616 L p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.227891 0.0147151 0.363946 0.360953 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.55601e-17 1.04994 -0.0593075 1.04994 [
[ 0 0 0 0 ]
[ 1 .82899 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .82899 L
0 .82899 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.693 .544 .68 r
.77409 .54632 m .72233 .54221 L .72865 .49511 L p F P
0 g
s
.693 .544 .68 r
.72865 .49511 m .77954 .5048 L .77409 .54632 L p F P
0 g
s
.68 .585 .742 r
.77954 .5048 m .72865 .49511 L .73999 .44953 L p F P
0 g
s
.755 .602 .687 r
.68264 .48699 m .72865 .49511 L .72233 .54221 L p F P
0 g
s
.742 .648 .756 r
.72865 .49511 m .68264 .48699 L .69384 .44116 L p F P
0 g
s
.742 .648 .756 r
.69384 .44116 m .73999 .44953 L .72865 .49511 L p F P
0 g
s
.644 .5 .672 r
.8317 .54714 m .77409 .54632 L .77954 .5048 L p F P
0 g
s
.644 .5 .672 r
.77954 .5048 m .83568 .51608 L .8317 .54714 L p F P
0 g
s
.632 .537 .728 r
.83568 .51608 m .77954 .5048 L .78972 .46469 L p F P
0 g
s
.68 .585 .742 r
.73999 .44953 m .78972 .46469 L .77954 .5048 L p F P
0 g
s
.693 .488 .606 r
.77396 .58493 m .72173 .58605 L .72233 .54221 L p F P
0 g
s
.693 .488 .606 r
.72233 .54221 m .77409 .54632 L .77396 .58493 L p F P
0 g
s
.761 .545 .605 r
.67618 .5343 m .72233 .54221 L .72173 .58605 L p F P
0 g
s
.755 .602 .687 r
.72233 .54221 m .67618 .5343 L .68264 .48699 L p F P
0 g
s
.651 .618 .803 r
.78972 .46469 m .73999 .44953 L .75526 .41016 L p F P
0 g
s
.717 .693 .826 r
.73999 .44953 m .69384 .44116 L .70869 .40152 L p F P
0 g
s
.717 .693 .826 r
.70869 .40152 m .75526 .41016 L .73999 .44953 L p F P
0 g
s
.64 .446 .604 r
.83195 .57596 m .77396 .58493 L .77409 .54632 L p F P
0 g
s
.64 .446 .604 r
.77409 .54632 m .8317 .54714 L .83195 .57596 L p F P
0 g
s
.823 .666 .689 r
.64065 .48032 m .68264 .48699 L .67618 .5343 L p F P
0 g
s
.809 .718 .765 r
.68264 .48699 m .64065 .48032 L .65045 .43954 L p F P
0 g
s
.809 .718 .765 r
.65045 .43954 m .69384 .44116 L .68264 .48699 L p F P
0 g
s
.632 .537 .728 r
.78972 .46469 m .84345 .48613 L .83568 .51608 L p F P
0 g
s
.601 .561 .781 r
.84345 .48613 m .78972 .46469 L .80361 .43021 L p F P
0 g
s
.651 .618 .803 r
.75526 .41016 m .80361 .43021 L .78972 .46469 L p F P
0 g
s
.761 .545 .605 r
.72173 .58605 m .67515 .57828 L .67618 .5343 L p F P
0 g
s
.834 .608 .596 r
.63481 .52237 m .67618 .5343 L .67515 .57828 L p F P
0 g
s
.823 .666 .689 r
.67618 .5343 m .63481 .52237 L .64065 .48032 L p F P
0 g
s
.789 .775 .841 r
.69384 .44116 m .65045 .43954 L .66322 .40432 L p F P
0 g
s
.789 .775 .841 r
.66322 .40432 m .70869 .40152 L .69384 .44116 L p F P
0 g
s
.613 .471 .665 r
.89472 .54548 m .8317 .54714 L .83568 .51608 L p F P
0 g
s
.613 .471 .665 r
.83568 .51608 m .89681 .52875 L .89472 .54548 L p F P
0 g
s
.601 .505 .717 r
.89681 .52875 m .83568 .51608 L .84345 .48613 L p F P
0 g
s
.673 .401 .501 r
.7793 .61645 m .72704 .62195 L .72173 .58605 L p F P
0 g
s
.673 .401 .501 r
.72173 .58605 m .77396 .58493 L .7793 .61645 L p F P
0 g
s
.753 .457 .482 r
.67515 .57828 m .72173 .58605 L .72704 .62195 L p F P
0 g
s
.606 .419 .602 r
.89506 .56095 m .83195 .57596 L .8317 .54714 L p F P
0 g
s
.606 .419 .602 r
.8317 .54714 m .89472 .54548 L .89506 .56095 L p F P
0 g
s
.613 .36 .51 r
.83648 .59932 m .7793 .61645 L .77396 .58493 L p F P
0 g
s
.613 .36 .51 r
.77396 .58493 m .83195 .57596 L .83648 .59932 L p F P
0 g
s
.601 .505 .717 r
.84345 .48613 m .90108 .51265 L .89681 .52875 L p F P
0 g
s
.569 .524 .765 r
.90108 .51265 m .84345 .48613 L .85419 .46056 L p F P
0 g
s
.601 .561 .781 r
.80361 .43021 m .85419 .46056 L .84345 .48613 L p F P
0 g
s
.591 .642 .87 r
.80361 .43021 m .75526 .41016 L .77296 .38137 L p F P
0 g
s
.664 .74 .907 r
.75526 .41016 m .70869 .40152 L .72574 .37245 L p F P
0 g
s
.664 .74 .907 r
.72574 .37245 m .77296 .38137 L .75526 .41016 L p F P
0 g
s
.537 .569 .835 r
.85419 .46056 m .80361 .43021 L .81983 .40521 L p F P
0 g
s
.591 .642 .87 r
.77296 .38137 m .81983 .40521 L .80361 .43021 L p F P
0 g
s
.881 .723 .681 r
.60141 .47481 m .64065 .48032 L .63481 .52237 L p F P
0 g
s
.867 .779 .763 r
.64065 .48032 m .60141 .47481 L .60869 .44401 L p F P
0 g
s
.867 .779 .763 r
.60869 .44401 m .65045 .43954 L .64065 .48032 L p F P
0 g
s
.753 .457 .482 r
.72704 .62195 m .67981 .61423 L .67515 .57828 L p F P
0 g
s
.834 .608 .596 r
.67515 .57828 m .63356 .56135 L .63481 .52237 L p F P
0 g
s
.84 .521 .45 r
.63356 .56135 m .67515 .57828 L .67981 .61423 L p F P
0 g
s
.575 .335 .515 r
.8978 .57337 m .83648 .59932 L .83195 .57596 L p F P
0 g
s
.575 .335 .515 r
.83195 .57596 m .89506 .56095 L .8978 .57337 L p F P
0 g
s
.897 .665 .578 r
.59693 .50656 m .63481 .52237 L .63356 .56135 L p F P
0 g
s
.881 .723 .681 r
.63481 .52237 m .59693 .50656 L .60141 .47481 L p F P
0 g
s
.743 .848 .929 r
.70869 .40152 m .66322 .40432 L .67769 .37859 L p F P
0 g
s
.743 .848 .929 r
.67769 .37859 m .72574 .37245 L .70869 .40152 L p F P
0 g
s
.569 .524 .765 r
.85419 .46056 m .90706 .49903 L .90108 .51265 L p F P
0 g
s
.504 .524 .81 r
.90706 .49903 m .85419 .46056 L .86676 .4423 L p F P
0 g
s
.537 .569 .835 r
.81983 .40521 m .86676 .4423 L .85419 .46056 L p F P
0 g
s
.849 .847 .841 r
.65045 .43954 m .60869 .44401 L .61801 .41752 L p F P
0 g
s
.849 .847 .841 r
.61801 .41752 m .66322 .40432 L .65045 .43954 L p F P
0 g
s
.597 .457 .661 r
.89681 .52875 m .96187 .54243 L .89472 .54548 L closepath p F P
0 g
s
.586 .49 .712 r
.90108 .51265 m .96187 .54243 L .89681 .52875 L closepath p F P
0 g
s
.59 .406 .6 r
.89472 .54548 m .96187 .54243 L .89506 .56095 L closepath p F P
0 g
s
.554 .506 .757 r
.90706 .49903 m .96187 .54243 L .90108 .51265 L closepath p F P
0 g
s
.535 .203 .351 r
.84489 .61442 m .78972 .63711 L .7793 .61645 L p F P
0 g
s
.535 .203 .351 r
.7793 .61645 m .83648 .59932 L .84489 .61442 L p F P
0 g
s
.604 .231 .308 r
.72704 .62195 m .7793 .61645 L .78972 .63711 L p F P
0 g
s
.604 .231 .308 r
.78972 .63711 m .73795 .64563 L .72704 .62195 L p F P
0 g
s
.699 .274 .235 r
.67981 .61423 m .72704 .62195 L .73795 .64563 L p F P
0 g
s
.84 .521 .45 r
.67981 .61423 m .63714 .59302 L .63356 .56135 L p F P
0 g
s
.897 .665 .578 r
.63356 .56135 m .59576 .53583 L .59693 .50656 L p F P
0 g
s
.908 .577 .405 r
.59576 .53583 m .63356 .56135 L .63714 .59302 L p F P
0 g
s
.558 .324 .517 r
.89506 .56095 m .96187 .54243 L .8978 .57337 L closepath p F P
0 g
s
.495 .188 .375 r
.90267 .58122 m .84489 .61442 L .83648 .59932 L p F P
0 g
s
.495 .188 .375 r
.83648 .59932 m .8978 .57337 L .90267 .58122 L p F P
0 g
s
.489 .503 .798 r
.91407 .4895 m .96187 .54243 L .90706 .49903 L closepath p F P
0 g
s
.504 .524 .81 r
.86676 .4423 m .91407 .4895 L .90706 .49903 L p F P
0 g
s
.393 .54 .884 r
.86676 .4423 m .81983 .40521 L .83664 .39289 L p F P
0 g
s
.44 .637 .939 r
.81983 .40521 m .77296 .38137 L .79124 .36684 L p F P
0 g
s
.44 .637 .939 r
.79124 .36684 m .83664 .39289 L .81983 .40521 L p F P
0 g
s
.803 .933 .918 r
.66322 .40432 m .61801 .41752 L .62839 .39835 L p F P
0 g
s
.803 .933 .918 r
.62839 .39835 m .67769 .37859 L .66322 .40432 L p F P
0 g
s
.366 .483 .846 r
.91407 .4895 m .86676 .4423 L .87979 .43365 L p F P
0 g
s
.393 .54 .884 r
.83664 .39289 m .87979 .43365 L .86676 .4423 L p F P
0 g
s
.506 .773 .992 r
.77296 .38137 m .72574 .37245 L .74318 .35768 L p F P
0 g
s
.506 .773 .992 r
.74318 .35768 m .79124 .36684 L .77296 .38137 L p F P
0 g
s
.699 .274 .235 r
.73795 .64563 m .68988 .63788 L .67981 .61423 L p F P
0 g
s
.79 .324 .129 r
.63714 .59302 m .67981 .61423 L .68988 .63788 L p F P
0 g
s
.477 .183 .386 r
.8978 .57337 m .96187 .54243 L .90267 .58122 L closepath p F P
0 g
s
.355 .458 .828 r
.9213 .48523 m .96187 .54243 L .91407 .4895 L closepath p F P
0 g
s
.366 .483 .846 r
.87979 .43365 m .9213 .48523 L .91407 .4895 L p F P
0 g
s
.921 .763 .669 r
.5634 .47008 m .60141 .47481 L .59693 .50656 L p F P
0 g
s
.906 .822 .753 r
.60141 .47481 m .5634 .47008 L .5673 .45333 L p F P
0 g
s
.906 .822 .753 r
.5673 .45333 m .60869 .44401 L .60141 .47481 L p F P
0 g
s
.563 .899 .981 r
.72574 .37245 m .67769 .37859 L .69229 .36563 L p F P
0 g
s
.563 .899 .981 r
.69229 .36563 m .74318 .35768 L .72574 .37245 L p F P
0 g
s
.938 .704 .557 r
.56093 .48735 m .59693 .50656 L .59576 .53583 L p F P
0 g
s
.921 .763 .669 r
.59693 .50656 m .56093 .48735 L .5634 .47008 L p F P
0 g
s
.888 .894 .828 r
.60869 .44401 m .5673 .45333 L .57219 .43901 L p F P
0 g
s
.888 .894 .828 r
.57219 .43901 m .61801 .41752 L .60869 .44401 L p F P
0 g
s
.054 .298 .787 r
.92789 .48683 m .96187 .54243 L .9213 .48523 L closepath p F P
0 g
s
0 0 .441 r
.93303 .49425 m .96187 .54243 L .92789 .48683 L closepath p F P
0 g
s
.923 .555 .133 r
.93605 .50665 m .96187 .54243 L .93303 .49425 L closepath p F P
0 g
s
.985 .729 .458 r
.93654 .52255 m .96187 .54243 L .93605 .50665 L closepath p F P
0 g
s
.974 .815 .623 r
.9344 .53995 m .96187 .54243 L .93654 .52255 L closepath p F P
0 g
s
.954 .89 .728 r
.92991 .55665 m .96187 .54243 L .9344 .53995 L closepath p F P
0 g
s
.277 0 .139 r
.90267 .58122 m .96187 .54243 L .90912 .5835 L closepath p F P
0 g
s
.911 .969 .798 r
.92364 .57051 m .96187 .54243 L .92991 .55665 L closepath p F P
0 g
s
0 0 0 r
.90912 .5835 m .96187 .54243 L .91641 .57982 L closepath p F P
0 g
s
.734 .981 .756 r
.91641 .57982 m .96187 .54243 L .92364 .57051 L closepath p F P
0 g
s
.283 0 .099 r
.84489 .61442 m .90267 .58122 L .90912 .5835 L p F P
0 g
s
.283 0 .099 r
.90912 .5835 m .85633 .61918 L .84489 .61442 L p F P
0 g
s
.301 0 .007 r
.78972 .63711 m .84489 .61442 L .85633 .61918 L p F P
0 g
s
.79 .324 .129 r
.68988 .63788 m .64534 .6136 L .63714 .59302 L p F P
0 g
s
.831 .358 .015 r
.59808 .55938 m .63714 .59302 L .64534 .6136 L p F P
0 g
s
.908 .577 .405 r
.63714 .59302 m .59808 .55938 L .59576 .53583 L p F P
0 g
s
.039 .317 .803 r
.9213 .48523 m .87979 .43365 L .89174 .43601 L p F P
0 g
s
.039 .317 .803 r
.89174 .43601 m .92789 .48683 L .9213 .48523 L p F P
0 g
s
.301 0 .007 r
.85633 .61918 m .80424 .64398 L .78972 .63711 L p F P
0 g
s
.333 0 0 r
.73795 .64563 m .78972 .63711 L .80424 .64398 L p F P
0 g
s
.938 .704 .557 r
.59576 .53583 m .56018 .50316 L .56093 .48735 L p F P
0 g
s
.945 .611 .362 r
.56018 .50316 m .59576 .53583 L .59808 .55938 L p F P
0 g
s
.009 .362 .833 r
.87979 .43365 m .83664 .39289 L .85208 .39536 L p F P
0 g
s
.009 .362 .833 r
.85208 .39536 m .89174 .43601 L .87979 .43365 L p F P
0 g
s
.692 .542 .678 r
.34395 .47236 m .2907 .46821 L .29842 .41923 L p F P
0 g
s
.692 .542 .678 r
.29842 .41923 m .35063 .42919 L .34395 .47236 L p F P
0 g
s
.678 .586 .744 r
.35063 .42919 m .29842 .41923 L .30835 .3713 L p F P
0 g
s
.755 .602 .687 r
.24827 .41038 m .29842 .41923 L .2907 .46821 L p F P
0 g
s
.742 .648 .756 r
.29842 .41923 m .24827 .41038 L .25803 .36218 L p F P
0 g
s
.742 .648 .756 r
.25803 .36218 m .30835 .3713 L .29842 .41923 L p F P
0 g
s
.572 .94 .874 r
.67769 .37859 m .62839 .39835 L .63866 .38892 L p F P
0 g
s
.572 .94 .874 r
.63866 .38892 m .69229 .36563 L .67769 .37859 L p F P
0 g
s
.831 .977 .884 r
.61801 .41752 m .57219 .43901 L .57753 .4288 L p F P
0 g
s
.831 .977 .884 r
.57753 .4288 m .62839 .39835 L .61801 .41752 L p F P
0 g
s
.333 0 0 r
.80424 .64398 m .75349 .65366 L .73795 .64563 L p F P
0 g
s
.36 0 0 r
.68988 .63788 m .73795 .64563 L .75349 .65366 L p F P
0 g
s
.637 .491 .667 r
.40076 .47264 m .34395 .47236 L .35063 .42919 L p F P
0 g
s
.637 .491 .667 r
.35063 .42919 m .40566 .44033 L .40076 .47264 L p F P
0 g
s
.623 .532 .73 r
.40566 .44033 m .35063 .42919 L .35958 .38701 L p F P
0 g
s
.678 .586 .744 r
.30835 .3713 m .35958 .38701 L .35063 .42919 L p F P
0 g
s
0 0 0 r
.85633 .61918 m .90912 .5835 L .91641 .57982 L p F P
0 g
s
.691 .482 .599 r
.34025 .51208 m .286 .5133 L .2907 .46821 L p F P
0 g
s
.691 .482 .599 r
.2907 .46821 m .34395 .47236 L .34025 .51208 L p F P
0 g
s
.761 .545 .605 r
.24038 .45958 m .2907 .46821 L .286 .5133 L p F P
0 g
s
.755 .602 .687 r
.2907 .46821 m .24038 .45958 L .24827 .41038 L p F P
0 g
s
0 .437 .847 r
.83664 .39289 m .79124 .36684 L .80797 .36912 L p F P
0 g
s
0 .437 .847 r
.80797 .36912 m .85208 .39536 L .83664 .39289 L p F P
0 g
s
.591 .149 0 r
.92789 .48683 m .89174 .43601 L .90109 .44951 L p F P
0 g
s
.591 .149 0 r
.90109 .44951 m .93303 .49425 L .92789 .48683 L p F P
0 g
s
.647 .62 .809 r
.35958 .38701 m .30835 .3713 L .31952 .32931 L p F P
0 g
s
.717 .693 .826 r
.30835 .3713 m .25803 .36218 L .26869 .31987 L p F P
0 g
s
.717 .693 .826 r
.26869 .31987 m .31952 .32931 L .30835 .3713 L p F P
0 g
s
.631 .429 .591 r
.39835 .50229 m .34025 .51208 L .34395 .47236 L p F P
0 g
s
.631 .429 .591 r
.34395 .47236 m .40076 .47264 L .39835 .50229 L p F P
0 g
s
.816 .661 .691 r
.19913 .40248 m .24827 .41038 L .24038 .45958 L p F P
0 g
s
.803 .709 .762 r
.24827 .41038 m .19913 .40248 L .20762 .35957 L p F P
0 g
s
.803 .709 .762 r
.20762 .35957 m .25803 .36218 L .24827 .41038 L p F P
0 g
s
.623 .532 .73 r
.35958 .38701 m .41251 .40882 L .40566 .44033 L p F P
0 g
s
.586 .557 .788 r
.41251 .40882 m .35958 .38701 L .3699 .35023 L p F P
0 g
s
.647 .62 .809 r
.31952 .32931 m .3699 .35023 L .35958 .38701 L p F P
0 g
s
.36 0 0 r
.75349 .65366 m .7045 .64579 L .68988 .63788 L p F P
0 g
s
0 .233 .623 r
.64534 .6136 m .68988 .63788 L .7045 .64579 L p F P
0 g
s
0 .495 .735 r
.79124 .36684 m .74318 .35768 L .75899 .35977 L p F P
0 g
s
0 .495 .735 r
.75899 .35977 m .80797 .36912 L .79124 .36684 L p F P
0 g
s
.761 .545 .605 r
.286 .5133 m .23517 .50482 L .24038 .45958 L p F P
0 g
s
.827 .607 .605 r
.192 .44624 m .24038 .45958 L .23517 .50482 L p F P
0 g
s
.816 .661 .691 r
.24038 .45958 m .192 .44624 L .19913 .40248 L p F P
0 g
s
.831 .358 .015 r
.64534 .6136 m .60373 .57435 L .59808 .55938 L p F P
0 g
s
.824 .371 0 r
.56124 .5157 m .59808 .55938 L .60373 .57435 L p F P
0 g
s
.945 .611 .362 r
.59808 .55938 m .56124 .5157 L .56018 .50316 L p F P
0 g
s
0 0 0 r
.91641 .57982 m .86953 .61262 L .85633 .61918 L p F P
0 g
s
.76 .996 .826 r
.86953 .61262 m .91641 .57982 L .92364 .57051 L p F P
0 g
s
.784 .762 .833 r
.25803 .36218 m .20762 .35957 L .21659 .32195 L p F P
0 g
s
.784 .762 .833 r
.21659 .32195 m .26869 .31987 L .25803 .36218 L p F P
0 g
s
.323 .784 .655 r
.80424 .64398 m .85633 .61918 L .86953 .61262 L p F P
0 g
s
.598 .455 .658 r
.46127 .46999 m .40076 .47264 L .40566 .44033 L p F P
0 g
s
.598 .455 .658 r
.40566 .44033 m .46385 .45257 L .46127 .46999 L p F P
0 g
s
.584 .493 .718 r
.46385 .45257 m .40566 .44033 L .41251 .40882 L p F P
0 g
s
.935 .56 .195 r
.93303 .49425 m .90109 .44951 L .90656 .47282 L p F P
0 g
s
.935 .56 .195 r
.90656 .47282 m .93605 .50665 L .93303 .49425 L p F P
0 g
s
.55 .917 .748 r
.62839 .39835 m .57753 .4288 L .58268 .42396 L p F P
0 g
s
.55 .917 .748 r
.58268 .42396 m .63866 .38892 L .62839 .39835 L p F P
0 g
s
.107 0 0 r
.74318 .35768 m .69229 .36563 L .7053 .36762 L p F P
0 g
s
.107 0 0 r
.7053 .36762 m .75899 .35977 L .74318 .35768 L p F P
0 g
s
.668 .385 .482 r
.33999 .54404 m .28487 .54971 L .286 .5133 L p F P
0 g
s
.668 .385 .482 r
.286 .5133 m .34025 .51208 L .33999 .54404 L p F P
0 g
s
.753 .457 .482 r
.23517 .50482 m .286 .5133 L .28487 .54971 L p F P
0 g
s
.589 .393 .583 r
.46017 .48591 m .39835 .50229 L .40076 .47264 L p F P
0 g
s
.589 .393 .583 r
.40076 .47264 m .46127 .46999 L .46017 .48591 L p F P
0 g
s
.596 .326 .478 r
.39873 .52597 m .33999 .54404 L .34025 .51208 L p F P
0 g
s
.596 .326 .478 r
.34025 .51208 m .39835 .50229 L .39873 .52597 L p F P
0 g
s
.684 .179 0 r
.89174 .43601 m .85208 .39536 L .86416 .41307 L p F P
0 g
s
.684 .179 0 r
.86416 .41307 m .90109 .44951 L .89174 .43601 L p F P
0 g
s
0 .233 .623 r
.7045 .64579 m .65743 .62014 L .64534 .6136 L p F P
0 g
s
0 .184 .684 r
.60373 .57435 m .64534 .6136 L .65743 .62014 L p F P
0 g
s
.584 .493 .718 r
.41251 .40882 m .46763 .43562 L .46385 .45257 L p F P
0 g
s
.544 .513 .771 r
.46763 .43562 m .41251 .40882 L .4206 .38154 L p F P
0 g
s
.586 .557 .788 r
.3699 .35023 m .4206 .38154 L .41251 .40882 L p F P
0 g
s
.939 .783 .66 r
.52497 .46566 m .5634 .47008 L .56093 .48735 L closepath p F P
0 g
s
.924 .842 .745 r
.52497 .46566 m .5673 .45333 L .5634 .47008 L closepath p F P
0 g
s
.956 .722 .543 r
.52497 .46566 m .56093 .48735 L .56018 .50316 L closepath p F P
0 g
s
.901 .948 .826 r
.88286 .59515 m .92364 .57051 L .92991 .55665 L p F P
0 g
s
.76 .996 .826 r
.92364 .57051 m .88286 .59515 L .86953 .61262 L p F P
0 g
s
.905 .915 .817 r
.52497 .46566 m .57219 .43901 L .5673 .45333 L closepath p F P
0 g
s
.578 .645 .88 r
.3699 .35023 m .31952 .32931 L .33078 .29786 L p F P
0 g
s
.664 .74 .907 r
.31952 .32931 m .26869 .31987 L .27916 .28811 L p F P
0 g
s
.664 .74 .907 r
.27916 .28811 m .33078 .29786 L .31952 .32931 L p F P
0 g
s
.506 .563 .848 r
.4206 .38154 m .3699 .35023 L .38052 .32293 L p F P
0 g
s
.578 .645 .88 r
.33078 .29786 m .38052 .32293 L .3699 .35023 L p F P
0 g
s
.969 .713 .492 r
.93605 .50665 m .90656 .47282 L .9073 .50317 L p F P
0 g
s
.969 .713 .492 r
.9073 .50317 m .93654 .52255 L .93605 .50665 L p F P
0 g
s
.323 .784 .655 r
.86953 .61262 m .8213 .63548 L .80424 .64398 L p F P
0 g
s
.393 .848 .896 r
.75349 .65366 m .80424 .64398 L .8213 .63548 L p F P
0 g
s
.863 .708 .688 r
.14982 .39526 m .19913 .40248 L .192 .44624 L p F P
0 g
s
.851 .758 .759 r
.19913 .40248 m .14982 .39526 L .15608 .36282 L p F P
0 g
s
.851 .758 .759 r
.15608 .36282 m .20762 .35957 L .19913 .40248 L p F P
0 g
s
.753 .457 .482 r
.28487 .54971 m .23326 .54128 L .23517 .50482 L p F P
0 g
s
.833 .53 .476 r
.18696 .48634 m .23517 .50482 L .23326 .54128 L p F P
0 g
s
.827 .607 .605 r
.23517 .50482 m .18696 .48634 L .192 .44624 L p F P
0 g
s
.096 0 0 r
.69229 .36563 m .63866 .38892 L .6476 .39072 L p F P
0 g
s
.096 0 0 r
.6476 .39072 m .7053 .36762 L .69229 .36563 L p F P
0 g
s
.958 .626 .337 r
.52497 .46566 m .56018 .50316 L .56124 .5157 L closepath p F P
0 g
s
.546 .287 .475 r
.46071 .49848 m .39873 .52597 L .39835 .50229 L p F P
0 g
s
.546 .287 .475 r
.39835 .50229 m .46017 .48591 L .46071 .49848 L p F P
0 g
s
.935 .865 .746 r
.8946 .56871 m .92991 .55665 L .9344 .53995 L p F P
0 g
s
.901 .948 .826 r
.92991 .55665 m .8946 .56871 L .88286 .59515 L p F P
0 g
s
.839 .991 .856 r
.52497 .46566 m .57753 .4288 L .57219 .43901 L closepath p F P
0 g
s
.954 .793 .643 r
.93654 .52255 m .9073 .50317 L .90313 .53663 L p F P
0 g
s
.954 .793 .643 r
.90313 .53663 m .9344 .53995 L .93654 .52255 L p F P
0 g
s
.878 .658 .6 r
.14434 .42832 m .192 .44624 L .18696 .48634 L p F P
0 g
s
.863 .708 .688 r
.192 .44624 m .14434 .42832 L .14982 .39526 L p F P
0 g
s
.935 .865 .746 r
.9344 .53995 m .90313 .53663 L .8946 .56871 L p F P
0 g
s
.746 .829 .915 r
.26869 .31987 m .21659 .32195 L .2251 .29381 L p F P
0 g
s
.746 .829 .915 r
.2251 .29381 m .27916 .28811 L .26869 .31987 L p F P
0 g
s
.544 .513 .771 r
.4206 .38154 m .47219 .42109 L .46763 .43562 L p F P
0 g
s
.457 .507 .822 r
.47219 .42109 m .4206 .38154 L .42904 .36159 L p F P
0 g
s
.506 .563 .848 r
.38052 .32293 m .42904 .36159 L .4206 .38154 L p F P
0 g
s
.722 .191 0 r
.85208 .39536 m .80797 .36912 L .82097 .38893 L p F P
0 g
s
.722 .191 0 r
.82097 .38893 m .86416 .41307 L .85208 .39536 L p F P
0 g
s
0 .184 .684 r
.65743 .62014 m .61216 .57869 L .60373 .57435 L p F P
0 g
s
.824 .371 0 r
.60373 .57435 m .56403 .52345 L .56124 .5157 L p F P
0 g
s
0 .142 .679 r
.56403 .52345 m .60373 .57435 L .61216 .57869 L p F P
0 g
s
.837 .816 .829 r
.20762 .35957 m .15608 .36282 L .16246 .3345 L p F P
0 g
s
.837 .816 .829 r
.16246 .3345 m .21659 .32195 L .20762 .35957 L p F P
0 g
s
.393 .848 .896 r
.8213 .63548 m .77203 .64411 L .75349 .65366 L p F P
0 g
s
.39 .764 .992 r
.7045 .64579 m .75349 .65366 L .77203 .64411 L p F P
0 g
s
.77 .977 .915 r
.8213 .63548 m .86953 .61262 L .88286 .59515 L p F P
0 g
s
.809 .374 0 r
.52497 .46566 m .56124 .5157 L .56403 .52345 L closepath p F P
0 g
s
.578 .437 .653 r
.46385 .45257 m .52497 .46566 L .46127 .46999 L closepath p F P
0 g
s
.565 .474 .711 r
.46763 .43562 m .52497 .46566 L .46385 .45257 L closepath p F P
0 g
s
.08 0 0 r
.63866 .38892 m .58268 .42396 L .58703 .42517 L p F P
0 g
s
.08 0 0 r
.58703 .42517 m .6476 .39072 L .63866 .38892 L p F P
0 g
s
.568 .375 .579 r
.46127 .46999 m .52497 .46566 L .46017 .48591 L closepath p F P
0 g
s
.533 .892 .677 r
.52497 .46566 m .58268 .42396 L .57753 .4288 L closepath p F P
0 g
s
.524 .491 .762 r
.47219 .42109 m .52497 .46566 L .46763 .43562 L closepath p F P
0 g
s
.919 .545 .29 r
.90109 .44951 m .86416 .41307 L .87113 .44449 L p F P
0 g
s
.919 .545 .29 r
.87113 .44449 m .90656 .47282 L .90109 .44951 L p F P
0 g
s
.488 .122 .27 r
.40196 .54083 m .34334 .56441 L .33999 .54404 L p F P
0 g
s
.488 .122 .27 r
.33999 .54404 m .39873 .52597 L .40196 .54083 L p F P
0 g
s
.583 .186 .256 r
.28487 .54971 m .33999 .54404 L .34334 .56441 L p F P
0 g
s
.39 .764 .992 r
.77203 .64411 m .72214 .63603 L .7045 .64579 L p F P
0 g
s
.337 .618 .954 r
.65743 .62014 m .7045 .64579 L .72214 .63603 L p F P
0 g
s
.583 .186 .256 r
.34334 .56441 m .28761 .57306 L .28487 .54971 L p F P
0 g
s
.699 .274 .235 r
.23326 .54128 m .28487 .54971 L .28761 .57306 L p F P
0 g
s
.656 .169 .082 r
.80797 .36912 m .75899 .35977 L .77109 .37951 L p F P
0 g
s
.656 .169 .082 r
.77109 .37951 m .82097 .38893 L .80797 .36912 L p F P
0 g
s
.833 .53 .476 r
.23326 .54128 m .1846 .51843 L .18696 .48634 L p F P
0 g
s
.892 .589 .466 r
.14024 .45844 m .18696 .48634 L .1846 .51843 L p F P
0 g
s
.878 .658 .6 r
.18696 .48634 m .14024 .45844 L .14434 .42832 L p F P
0 g
s
.521 .269 .473 r
.46017 .48591 m .52497 .46566 L .46071 .49848 L closepath p F P
0 g
s
.427 .084 .28 r
.46285 .50619 m .40196 .54083 L .39873 .52597 L p F P
0 g
s
.427 .084 .28 r
.39873 .52597 m .46071 .49848 L .46285 .50619 L p F P
0 g
s
.434 .48 .808 r
.47699 .41067 m .52497 .46566 L .47219 .42109 L closepath p F P
0 g
s
.457 .507 .822 r
.42904 .36159 m .47699 .41067 L .47219 .42109 L p F P
0 g
s
0 .142 .679 r
.61216 .57869 m .56824 .52539 L .56403 .52345 L p F P
0 g
s
0 .12 .668 r
.52497 .46566 m .56403 .52345 L .56824 .52539 L closepath p F P
0 g
s
.308 .512 .892 r
.42904 .36159 m .38052 .32293 L .39027 .30857 L p F P
0 g
s
.394 .63 .949 r
.38052 .32293 m .33078 .29786 L .34089 .28096 L p F P
0 g
s
.394 .63 .949 r
.34089 .28096 m .39027 .30857 L .38052 .32293 L p F P
0 g
s
.808 .893 .904 r
.21659 .32195 m .16246 .3345 L .16825 .31351 L p F P
0 g
s
.808 .893 .904 r
.16825 .31351 m .2251 .29381 L .21659 .32195 L p F P
0 g
s
.337 .618 .954 r
.72214 .63603 m .67214 .61108 L .65743 .62014 L p F P
0 g
s
.287 .504 .892 r
.61216 .57869 m .65743 .62014 L .67214 .61108 L p F P
0 g
s
.256 .436 .848 r
.47699 .41067 m .42904 .36159 L .43689 .35149 L p F P
0 g
s
.308 .512 .892 r
.39027 .30857 m .43689 .35149 L .42904 .36159 L p F P
0 g
s
.069 0 0 r
.52497 .46566 m .58703 .42517 L .58268 .42396 L closepath p F P
0 g
s
.506 .773 .992 r
.33078 .29786 m .27916 .28811 L .28827 .27093 L p F P
0 g
s
.506 .773 .992 r
.28827 .27093 m .34089 .28096 L .33078 .29786 L p F P
0 g
s
.699 .274 .235 r
.28761 .57306 m .235 .56458 L .23326 .54128 L p F P
0 g
s
.803 .368 .211 r
.1846 .51843 m .23326 .54128 L .235 .56458 L p F P
0 g
s
.556 .133 .194 r
.75899 .35977 m .7053 .36762 L .71502 .38513 L p F P
0 g
s
.556 .133 .194 r
.71502 .38513 m .77109 .37951 L .75899 .35977 L p F P
0 g
s
.864 .894 .854 r
.83883 .61192 m .88286 .59515 L .8946 .56871 L p F P
0 g
s
.77 .977 .915 r
.88286 .59515 m .83883 .61192 L .8213 .63548 L p F P
0 g
s
.398 .068 .286 r
.46071 .49848 m .52497 .46566 L .46285 .50619 L closepath p F P
0 g
s
.727 .89 .955 r
.77203 .64411 m .8213 .63548 L .83883 .61192 L p F P
0 g
s
.287 .504 .892 r
.67214 .61108 m .62246 .57142 L .61216 .57869 L p F P
0 g
s
.251 .434 .848 r
.56824 .52539 m .61216 .57869 L .62246 .57142 L p F P
0 g
s
.233 .401 .825 r
.48149 .40565 m .52497 .46566 L .47699 .41067 L closepath p F P
0 g
s
.256 .436 .848 r
.43689 .35149 m .48149 .40565 L .47699 .41067 L p F P
0 g
s
.925 .673 .537 r
.90656 .47282 m .87113 .44449 L .87184 .4859 L p F P
0 g
s
.925 .673 .537 r
.87184 .4859 m .9073 .50317 L .90656 .47282 L p F P
0 g
s
.894 .74 .683 r
.09917 .3884 m .14982 .39526 L .14434 .42832 L p F P
0 g
s
.882 .789 .754 r
.14982 .39526 m .09917 .3884 L .10249 .37074 L p F P
0 g
s
.882 .789 .754 r
.10249 .37074 m .15608 .36282 L .14982 .39526 L p F P
0 g
s
.476 .102 .25 r
.7053 .36762 m .6476 .39072 L .65406 .40399 L p F P
0 g
s
.476 .102 .25 r
.65406 .40399 m .71502 .38513 L .7053 .36762 L p F P
0 g
s
.613 .894 .988 r
.27916 .28811 m .2251 .29381 L .23218 .27871 L p F P
0 g
s
.613 .894 .988 r
.23218 .27871 m .28827 .27093 L .27916 .28811 L p F P
0 g
s
.251 .434 .848 r
.62246 .57142 m .57339 .52117 L .56824 .52539 L p F P
0 g
s
.233 .401 .825 r
.52497 .46566 m .56824 .52539 L .57339 .52117 L closepath p F P
0 g
s
.91 .691 .594 r
.09614 .40639 m .14434 .42832 L .14024 .45844 L p F P
0 g
s
.894 .74 .683 r
.14434 .42832 m .09614 .40639 L .09917 .3884 L p F P
0 g
s
.852 .496 .378 r
.86416 .41307 m .82097 .38893 L .8283 .42468 L p F P
0 g
s
.852 .496 .378 r
.8283 .42468 m .87113 .44449 L .86416 .41307 L p F P
0 g
s
.424 .08 .276 r
.6476 .39072 m .58703 .42517 L .59004 .43243 L p F P
0 g
s
.424 .08 .276 r
.59004 .43243 m .65406 .40399 L .6476 .39072 L p F P
0 g
s
.87 .85 .821 r
.15608 .36282 m .10249 .37074 L .10574 .35541 L p F P
0 g
s
.87 .85 .821 r
.10574 .35541 m .16246 .3345 L .15608 .36282 L p F P
0 g
s
.398 .068 .286 r
.52497 .46566 m .59004 .43243 L .58703 .42517 L closepath p F P
0 g
s
.521 .269 .473 r
.52497 .46566 m .5913 .44494 L .59004 .43243 L closepath p F P
0 g
s
.568 .375 .579 r
.52497 .46566 m .59062 .46121 L .5913 .44494 L closepath p F P
0 g
s
.578 .437 .653 r
.52497 .46566 m .58807 .47918 L .59062 .46121 L closepath p F P
0 g
s
.565 .474 .711 r
.52497 .46566 m .58398 .49658 L .58807 .47918 L closepath p F P
0 g
s
.524 .491 .762 r
.52497 .46566 m .57887 .51117 L .58398 .49658 L closepath p F P
0 g
s
.434 .48 .808 r
.52497 .46566 m .57339 .52117 L .57887 .51117 L closepath p F P
0 g
s
.956 .722 .543 r
.48715 .44286 m .52497 .46566 L .48819 .42649 L closepath p F P
0 g
s
.939 .783 .66 r
.48447 .461 m .52497 .46566 L .48715 .44286 L closepath p F P
0 g
s
.924 .842 .745 r
.48051 .47861 m .52497 .46566 L .48447 .461 L closepath p F P
0 g
s
.905 .915 .817 r
.47576 .49343 m .52497 .46566 L .48051 .47861 L closepath p F P
0 g
s
.069 0 0 r
.46285 .50619 m .52497 .46566 L .46635 .50802 L closepath p F P
0 g
s
.839 .991 .856 r
.47084 .50363 m .52497 .46566 L .47576 .49343 L closepath p F P
0 g
s
.533 .892 .677 r
.46635 .50802 m .52497 .46566 L .47084 .50363 L closepath p F P
0 g
s
0 .12 .668 r
.48515 .40674 m .52497 .46566 L .48149 .40565 L closepath p F P
0 g
s
.809 .374 0 r
.48748 .41395 m .52497 .46566 L .48515 .40674 L closepath p F P
0 g
s
.958 .626 .337 r
.48819 .42649 m .52497 .46566 L .48748 .41395 L closepath p F P
0 g
s
.087 0 0 r
.40196 .54083 m .46285 .50619 L .46635 .50802 L p F P
0 g
s
.89 .813 .766 r
.85448 .57582 m .8946 .56871 L .90313 .53663 L p F P
0 g
s
.864 .894 .854 r
.8946 .56871 m .85448 .57582 L .83883 .61192 L p F P
0 g
s
.087 0 0 r
.46635 .50802 m .40775 .54478 L .40196 .54083 L p F P
0 g
s
.136 0 0 r
.34334 .56441 m .40196 .54083 L .40775 .54478 L p F P
0 g
s
.803 .368 .211 r
.235 .56458 m .18529 .53867 L .1846 .51843 L p F P
0 g
s
.871 .443 .189 r
.13799 .48228 m .1846 .51843 L .18529 .53867 L p F P
0 g
s
.892 .589 .466 r
.1846 .51843 m .13799 .48228 L .14024 .45844 L p F P
0 g
s
.908 .746 .669 r
.9073 .50317 m .87184 .4859 L .86604 .5318 L p F P
0 g
s
.908 .746 .669 r
.86604 .5318 m .90313 .53663 L .9073 .50317 L p F P
0 g
s
0 .149 .685 r
.48149 .40565 m .43689 .35149 L .44319 .3528 L p F P
0 g
s
0 .149 .685 r
.44319 .3528 m .48515 .40674 L .48149 .40565 L p F P
0 g
s
.727 .89 .955 r
.83883 .61192 m .79133 .61718 L .77203 .64411 L p F P
0 g
s
.645 .763 .935 r
.72214 .63603 m .77203 .64411 L .79133 .61718 L p F P
0 g
s
.136 0 0 r
.40775 .54478 m .35008 .57022 L .34334 .56441 L p F P
0 g
s
.23 0 0 r
.28761 .57306 m .34334 .56441 L .35008 .57022 L p F P
0 g
s
.89 .813 .766 r
.90313 .53663 m .86604 .5318 L .85448 .57582 L p F P
0 g
s
.927 .627 .456 r
.09374 .42267 m .14024 .45844 L .13799 .48228 L p F P
0 g
s
.91 .691 .594 r
.14024 .45844 m .09374 .42267 L .09614 .40639 L p F P
0 g
s
.456 .507 .822 r
.63339 .55304 m .57887 .51117 L .57339 .52117 L p F P
0 g
s
.456 .507 .822 r
.57339 .52117 m .62246 .57142 L .63339 .55304 L p F P
0 g
s
0 .22 .718 r
.43689 .35149 m .39027 .30857 L .39794 .30955 L p F P
0 g
s
0 .22 .718 r
.39794 .30955 m .44319 .3528 L .43689 .35149 L p F P
0 g
s
.684 .962 .941 r
.2251 .29381 m .16825 .31351 L .17277 .30249 L p F P
0 g
s
.684 .962 .941 r
.17277 .30249 m .23218 .27871 L .2251 .29381 L p F P
0 g
s
.545 .285 .473 r
.65406 .40399 m .59004 .43243 L .5913 .44494 L p F P
0 g
s
.844 .928 .886 r
.16246 .3345 m .10574 .35541 L .10852 .34421 L p F P
0 g
s
.844 .928 .886 r
.10852 .34421 m .16825 .31351 L .16246 .3345 L p F P
0 g
s
.23 0 0 r
.35008 .57022 m .29412 .5799 L .28761 .57306 L p F P
0 g
s
.36 0 0 r
.235 .56458 m .28761 .57306 L .29412 .5799 L p F P
0 g
s
.755 .429 .434 r
.82097 .38893 m .77109 .37951 L .77766 .41529 L p F P
0 g
s
.755 .429 .434 r
.77766 .41529 m .8283 .42468 L .82097 .38893 L p F P
0 g
s
.645 .763 .935 r
.79133 .61718 m .74068 .60883 L .72214 .63603 L p F P
0 g
s
.563 .647 .892 r
.67214 .61108 m .72214 .63603 L .74068 .60883 L p F P
0 g
s
.542 .912 .741 r
.40775 .54478 m .46635 .50802 L .47084 .50363 L p F P
0 g
s
.498 .561 .851 r
.68768 .58679 m .63339 .55304 L .62246 .57142 L p F P
0 g
s
.498 .561 .851 r
.62246 .57142 m .67214 .61108 L .68768 .58679 L p F P
0 g
s
0 .343 .752 r
.39027 .30857 m .34089 .28096 L .3486 .28147 L p F P
0 g
s
0 .343 .752 r
.3486 .28147 m .39794 .30955 L .39027 .30857 L p F P
0 g
s
.797 .806 .859 r
.79133 .61718 m .83883 .61192 L .85448 .57582 L p F P
0 g
s
.563 .647 .892 r
.74068 .60883 m .68768 .58679 L .67214 .61108 L p F P
0 g
s
.82 .366 0 r
.48515 .40674 m .44319 .3528 L .4471 .36585 L p F P
0 g
s
.82 .366 0 r
.4471 .36585 m .48748 .41395 L .48515 .40674 L p F P
0 g
s
.544 .513 .772 r
.64353 .52559 m .58398 .49658 L .57887 .51117 L p F P
0 g
s
.544 .513 .772 r
.57887 .51117 m .63339 .55304 L .64353 .52559 L p F P
0 g
s
.592 .318 .471 r
.71502 .38513 m .65406 .40399 L .65711 .42743 L p F P
0 g
s
.545 .285 .473 r
.5913 .44494 m .65711 .42743 L .65406 .40399 L p F P
0 g
s
.588 .392 .583 r
.65711 .42743 m .5913 .44494 L .59062 .46121 L p F P
0 g
s
.852 .61 .572 r
.87113 .44449 m .8283 .42468 L .82869 .47215 L p F P
0 g
s
.852 .61 .572 r
.82869 .47215 m .87184 .4859 L .87113 .44449 L p F P
0 g
s
.36 0 0 r
.29412 .5799 m .24039 .57127 L .235 .56458 L p F P
0 g
s
.477 0 0 r
.18529 .53867 m .235 .56458 L .24039 .57127 L p F P
0 g
s
.663 .367 .461 r
.77109 .37951 m .71502 .38513 L .72001 .41665 L p F P
0 g
s
.663 .367 .461 r
.72001 .41665 m .77766 .41529 L .77109 .37951 L p F P
0 g
s
0 .495 .735 r
.34089 .28096 m .28827 .27093 L .29486 .27122 L p F P
0 g
s
0 .495 .735 r
.29486 .27122 m .3486 .28147 L .34089 .28096 L p F P
0 g
s
.592 .318 .471 r
.65711 .42743 m .72001 .41665 L .71502 .38513 L p F P
0 g
s
.871 .443 .189 r
.18529 .53867 m .13789 .49695 L .13799 .48228 L p F P
0 g
s
.903 .491 .175 r
.09227 .43535 m .13799 .48228 L .13789 .49695 L p F P
0 g
s
.927 .627 .456 r
.13799 .48228 m .09227 .43535 L .09374 .42267 L p F P
0 g
s
.584 .493 .718 r
.65151 .49253 m .58807 .47918 L .58398 .49658 L p F P
0 g
s
.584 .493 .718 r
.58398 .49658 m .64353 .52559 L .65151 .49253 L p F P
0 g
s
.83 .978 .883 r
.4155 .53691 m .47084 .50363 L .47576 .49343 L p F P
0 g
s
.542 .912 .741 r
.47084 .50363 m .4155 .53691 L .40775 .54478 L p F P
0 g
s
.588 .392 .583 r
.59062 .46121 m .65625 .45828 L .65711 .42743 L p F P
0 g
s
.598 .454 .658 r
.65625 .45828 m .59062 .46121 L .58807 .47918 L p F P
0 g
s
.54 .926 .85 r
.35008 .57022 m .40775 .54478 L .4155 .53691 L p F P
0 g
s
.598 .454 .658 r
.58807 .47918 m .65151 .49253 L .65625 .45828 L p F P
0 g
s
.946 .611 .358 r
.48748 .41395 m .4471 .36585 L .44803 .38939 L p F P
0 g
s
.946 .611 .358 r
.44803 .38939 m .48819 .42649 L .48748 .41395 L p F P
0 g
s
.721 .986 .889 r
.16825 .31351 m .10852 .34421 L .11051 .33852 L p F P
0 g
s
.721 .986 .889 r
.11051 .33852 m .17277 .30249 L .16825 .31351 L p F P
0 g
s
0 0 0 r
.28827 .27093 m .23218 .27871 L .23692 .27912 L p F P
0 g
s
0 0 0 r
.23692 .27912 m .29486 .27122 L .28827 .27093 L p F P
0 g
s
.822 .738 .771 r
.80878 .57569 m .85448 .57582 L .86604 .5318 L p F P
0 g
s
.797 .806 .859 r
.85448 .57582 m .80878 .57569 L .79133 .61718 L p F P
0 g
s
.817 .335 0 r
.44319 .3528 m .39794 .30955 L .40247 .32657 L p F P
0 g
s
.817 .335 0 r
.40247 .32657 m .4471 .36585 L .44319 .3528 L p F P
0 g
s
.477 0 0 r
.24039 .57127 m .1891 .54408 L .18529 .53867 L p F P
0 g
s
.545 .018 0 r
.13789 .49695 m .18529 .53867 L .1891 .54408 L p F P
0 g
s
.583 .556 .79 r
.70202 .54986 m .64353 .52559 L .63339 .55304 L p F P
0 g
s
.583 .556 .79 r
.63339 .55304 m .68768 .58679 L .70202 .54986 L p F P
0 g
s
.716 .709 .842 r
.74068 .60883 m .79133 .61718 L .80878 .57569 L p F P
0 g
s
.908 .755 .679 r
.04617 .38153 m .09917 .3884 L .09614 .40639 L closepath p F P
0 g
s
.896 .804 .749 r
.04617 .38153 m .10249 .37074 L .09917 .3884 L closepath p F P
0 g
s
.839 .678 .684 r
.87184 .4859 m .82869 .47215 L .82188 .52498 L p F P
0 g
s
.839 .678 .684 r
.82188 .52498 m .86604 .5318 L .87184 .4859 L p F P
0 g
s
.925 .707 .589 r
.04617 .38153 m .09614 .40639 L .09374 .42267 L closepath p F P
0 g
s
.888 .896 .828 r
.4243 .51775 m .47576 .49343 L .48051 .47861 L p F P
0 g
s
.83 .978 .883 r
.47576 .49343 m .4243 .51775 L .4155 .53691 L p F P
0 g
s
.885 .865 .814 r
.04617 .38153 m .10574 .35541 L .10249 .37074 L closepath p F P
0 g
s
.629 .425 .588 r
.72001 .41665 m .65711 .42743 L .65625 .45828 L p F P
0 g
s
.939 .704 .555 r
.48819 .42649 m .44803 .38939 L .44575 .42065 L p F P
0 g
s
.939 .704 .555 r
.44575 .42065 m .48715 .44286 L .48819 .42649 L p F P
0 g
s
.54 .926 .85 r
.4155 .53691 m .35959 .55996 L .35008 .57022 L p F P
0 g
s
.494 .887 .955 r
.29412 .5799 m .35008 .57022 L .35959 .55996 L p F P
0 g
s
.767 .539 .588 r
.8283 .42468 m .77766 .41529 L .77754 .46292 L p F P
0 g
s
.767 .539 .588 r
.77754 .46292 m .82869 .47215 L .8283 .42468 L p F P
0 g
s
.822 .738 .771 r
.86604 .5318 m .82188 .52498 L .80878 .57569 L p F P
0 g
s
0 0 0 r
.23218 .27871 m .17277 .30249 L .17544 .30314 L p F P
0 g
s
0 0 0 r
.17544 .30314 m .23692 .27912 L .23218 .27871 L p F P
0 g
s
.941 .645 .45 r
.04617 .38153 m .09374 .42267 L .09227 .43535 L closepath p F P
0 g
s
.642 .622 .815 r
.75763 .56702 m .70202 .54986 L .68768 .58679 L p F P
0 g
s
.642 .622 .815 r
.68768 .58679 m .74068 .60883 L .75763 .56702 L p F P
0 g
s
.716 .709 .842 r
.80878 .57569 m .75763 .56702 L .74068 .60883 L p F P
0 g
s
.907 .823 .753 r
.43304 .48943 m .48051 .47861 L .48447 .461 L p F P
0 g
s
.888 .896 .828 r
.48051 .47861 m .43304 .48943 L .4243 .51775 L p F P
0 g
s
.859 .942 .873 r
.04617 .38153 m .10852 .34421 L .10574 .35541 L closepath p F P
0 g
s
.922 .764 .669 r
.48715 .44286 m .44575 .42065 L .44053 .45556 L p F P
0 g
s
.922 .764 .669 r
.44053 .45556 m .48447 .461 L .48715 .44286 L p F P
0 g
s
.907 .823 .753 r
.48447 .461 m .44053 .45556 L .43304 .48943 L p F P
0 g
s
.621 .53 .73 r
.71312 .50502 m .65151 .49253 L .64353 .52559 L p F P
0 g
s
.621 .53 .73 r
.64353 .52559 m .70202 .54986 L .71312 .50502 L p F P
0 g
s
.766 .268 .031 r
.39794 .30955 m .3486 .28147 L .35278 .30045 L p F P
0 g
s
.766 .268 .031 r
.35278 .30045 m .40247 .32657 L .39794 .30955 L p F P
0 g
s
.545 .018 0 r
.1891 .54408 m .14005 .50039 L .13789 .49695 L p F P
0 g
s
.578 .101 0 r
.0919 .4429 m .13789 .49695 L .14005 .50039 L p F P
0 g
s
.903 .491 .175 r
.13789 .49695 m .0919 .4429 L .09227 .43535 L p F P
0 g
s
.69 .475 .591 r
.77766 .41529 m .72001 .41665 L .71939 .45846 L p F P
0 g
s
.629 .425 .588 r
.65625 .45828 m .71939 .45846 L .72001 .41665 L p F P
0 g
s
.635 .489 .666 r
.71939 .45846 m .65625 .45828 L .65151 .49253 L p F P
0 g
s
.69 .475 .591 r
.71939 .45846 m .77754 .46292 L .77766 .41529 L p F P
0 g
s
.494 .887 .955 r
.35959 .55996 m .30384 .56833 L .29412 .5799 L p F P
0 g
s
.39 .764 .992 r
.24039 .57127 m .29412 .5799 L .30384 .56833 L p F P
0 g
s
.8 .941 .919 r
.35959 .55996 m .4155 .53691 L .4243 .51775 L p F P
0 g
s
.914 .513 .17 r
.04617 .38153 m .09227 .43535 L .0919 .4429 L closepath p F P
0 g
s
.635 .489 .666 r
.65151 .49253 m .71312 .50502 L .71939 .45846 L p F P
0 g
s
0 0 0 r
.17277 .30249 m .11051 .33852 L .11145 .33914 L p F P
0 g
s
0 0 0 r
.11145 .33914 m .17544 .30314 L .17277 .30249 L p F P
0 g
s
.746 .658 .763 r
.75763 .56702 m .80878 .57569 L .82188 .52498 L p F P
0 g
s
.735 .991 .859 r
.04617 .38153 m .11051 .33852 L .10852 .34421 L closepath p F P
0 g
s
.911 .573 .39 r
.4471 .36585 m .40247 .32657 L .40309 .35826 L p F P
0 g
s
.911 .573 .39 r
.40309 .35826 m .44803 .38939 L .4471 .36585 L p F P
0 g
s
.761 .605 .684 r
.82869 .47215 m .77754 .46292 L .77055 .516 L p F P
0 g
s
.761 .605 .684 r
.77055 .516 m .82188 .52498 L .82869 .47215 L p F P
0 g
s
.39 .764 .992 r
.30384 .56833 m .24902 .55946 L .24039 .57127 L p F P
0 g
s
.259 .596 .95 r
.1891 .54408 m .24039 .57127 L .24902 .55946 L p F P
0 g
s
.656 .169 .082 r
.3486 .28147 m .29486 .27122 L .29796 .29008 L p F P
0 g
s
.656 .169 .082 r
.29796 .29008 m .35278 .30045 L .3486 .28147 L p F P
0 g
s
.676 .586 .747 r
.77055 .516 m .71312 .50502 L .70202 .54986 L p F P
0 g
s
.676 .586 .747 r
.70202 .54986 m .75763 .56702 L .77055 .516 L p F P
0 g
s
.746 .658 .763 r
.82188 .52498 m .77055 .516 L .75763 .56702 L p F P
0 g
s
.691 .54 .677 r
.77754 .46292 m .71939 .45846 L .71312 .50502 L p F P
0 g
s
.578 .101 0 r
.14005 .50039 m .0927 .44432 L .0919 .4429 L p F P
0 g
s
.593 .141 0 r
.04617 .38153 m .0919 .4429 L .0927 .44432 L closepath p F P
0 g
s
.259 .596 .95 r
.24902 .55946 m .19574 .53316 L .1891 .54408 L p F P
0 g
s
.146 .446 .879 r
.14005 .50039 m .1891 .54408 L .19574 .53316 L p F P
0 g
s
.691 .54 .677 r
.71312 .50502 m .77055 .516 L .77754 .46292 L p F P
0 g
s
0 0 0 r
.04617 .38153 m .11145 .33914 L .11051 .33852 L closepath p F P
0 g
s
.518 .064 .112 r
.29486 .27122 m .23692 .27912 L .23859 .29587 L p F P
0 g
s
.518 .064 .112 r
.23859 .29587 m .29796 .29008 L .29486 .27122 L p F P
0 g
s
.852 .854 .843 r
.37076 .53408 m .4243 .51775 L .43304 .48943 L p F P
0 g
s
.8 .941 .919 r
.4243 .51775 m .37076 .53408 L .35959 .55996 L p F P
0 g
s
.737 .868 .942 r
.30384 .56833 m .35959 .55996 L .37076 .53408 L p F P
0 g
s
.146 .446 .879 r
.19574 .53316 m .1443 .49169 L .14005 .50039 L p F P
0 g
s
.067 .343 .819 r
.0927 .44432 m .14005 .50039 L .1443 .49169 L p F P
0 g
s
.902 .666 .573 r
.44803 .38939 m .40309 .35826 L .39956 .40091 L p F P
0 g
s
.902 .666 .573 r
.39956 .40091 m .44575 .42065 L .44803 .38939 L p F P
0 g
s
.395 0 .123 r
.23692 .27912 m .17544 .30314 L .17585 .31586 L p F P
0 g
s
.395 0 .123 r
.17585 .31586 m .23859 .29587 L .23692 .27912 L p F P
0 g
s
.067 .343 .819 r
.1443 .49169 m .0946 .4393 L .0927 .44432 L p F P
0 g
s
.026 .292 .786 r
.04617 .38153 m .0927 .44432 L .0946 .4393 L closepath p F P
0 g
s
.846 .511 .419 r
.40247 .32657 m .35278 .30045 L .35267 .33647 L p F P
0 g
s
.846 .511 .419 r
.35267 .33647 m .40309 .35826 L .40247 .32657 L p F P
0 g
s
.308 0 .122 r
.17544 .30314 m .11145 .33914 L .11121 .34614 L p F P
0 g
s
.308 0 .122 r
.11121 .34614 m .17585 .31586 L .17544 .30314 L p F P
0 g
s
.262 0 .118 r
.04617 .38153 m .11121 .34614 L .11145 .33914 L closepath p F P
0 g
s
.535 .33 .549 r
.04617 .38153 m .10735 .37551 L .10979 .35876 L closepath p F P
0 g
s
.552 .409 .64 r
.04617 .38153 m .1042 .39428 L .10735 .37551 L closepath p F P
0 g
s
.535 .453 .709 r
.04617 .38153 m .10073 .41266 L .1042 .39428 L closepath p F P
0 g
s
.48 .468 .768 r
.04617 .38153 m .09739 .42832 L .10073 .41266 L closepath p F P
0 g
s
.349 .441 .814 r
.04617 .38153 m .0946 .4393 L .09739 .42832 L closepath p F P
0 g
s
.465 .186 .405 r
.04617 .38153 m .10979 .35876 L .11121 .34614 L closepath p F P
0 g
s
.87 .784 .763 r
.38218 .49539 m .43304 .48943 L .44053 .45556 L p F P
0 g
s
.852 .854 .843 r
.43304 .48943 m .38218 .49539 L .37076 .53408 L p F P
0 g
s
.885 .727 .68 r
.44575 .42065 m .39956 .40091 L .39225 .44885 L p F P
0 g
s
.885 .727 .68 r
.39225 .44885 m .44053 .45556 L .44575 .42065 L p F P
0 g
s
.737 .868 .942 r
.37076 .53408 m .31569 .53873 L .30384 .56833 L p F P
0 g
s
.645 .763 .935 r
.24902 .55946 m .30384 .56833 L .31569 .53873 L p F P
0 g
s
.87 .784 .763 r
.44053 .45556 m .39225 .44885 L .38218 .49539 L p F P
0 g
s
.384 .478 .833 r
.15017 .47147 m .09739 .42832 L .0946 .4393 L p F P
0 g
s
.384 .478 .833 r
.0946 .4393 m .1443 .49169 L .15017 .47147 L p F P
0 g
s
.5 .215 .413 r
.17585 .31586 m .11121 .34614 L .10979 .35876 L p F P
0 g
s
.755 .429 .434 r
.35278 .30045 m .29796 .29008 L .29693 .32613 L p F P
0 g
s
.755 .429 .434 r
.29693 .32613 m .35267 .33647 L .35278 .30045 L p F P
0 g
s
.645 .763 .935 r
.31569 .53873 m .25996 .52953 L .24902 .55946 L p F P
0 g
s
.543 .65 .905 r
.19574 .53316 m .24902 .55946 L .25996 .52953 L p F P
0 g
s
.451 .55 .866 r
.20451 .50644 m .15017 .47147 L .1443 .49169 L p F P
0 g
s
.451 .55 .866 r
.1443 .49169 m .19574 .53316 L .20451 .50644 L p F P
0 g
s
.793 .789 .849 r
.31569 .53873 m .37076 .53408 L .38218 .49539 L p F P
0 g
s
.543 .65 .905 r
.25996 .52953 m .20451 .50644 L .19574 .53316 L p F P
0 g
s
.509 .497 .779 r
.15695 .44201 m .10073 .41266 L .09739 .42832 L p F P
0 g
s
.509 .497 .779 r
.09739 .42832 m .15017 .47147 L .15695 .44201 L p F P
0 g
s
.565 .269 .425 r
.23859 .29587 m .17585 .31586 L .17385 .3395 L p F P
0 g
s
.5 .215 .413 r
.10979 .35876 m .17385 .3395 L .17585 .31586 L p F P
0 g
s
.563 .356 .557 r
.17385 .3395 m .10979 .35876 L .10735 .37551 L p F P
0 g
s
.842 .609 .585 r
.40309 .35826 m .35267 .33647 L .34807 .38537 L p F P
0 g
s
.842 .609 .585 r
.34807 .38537 m .39956 .40091 L .40309 .35826 L p F P
0 g
s
.655 .344 .434 r
.29796 .29008 m .23859 .29587 L .23681 .32763 L p F P
0 g
s
.655 .344 .434 r
.23681 .32763 m .29693 .32613 L .29796 .29008 L p F P
0 g
s
.565 .269 .425 r
.17385 .3395 m .23681 .32763 L .23859 .29587 L p F P
0 g
s
.561 .477 .717 r
.16375 .40705 m .1042 .39428 L .10073 .41266 L p F P
0 g
s
.561 .477 .717 r
.10073 .41266 m .15695 .44201 L .16375 .40705 L p F P
0 g
s
.563 .356 .557 r
.10735 .37551 m .16965 .37128 L .17385 .3395 L p F P
0 g
s
.578 .433 .648 r
.16965 .37128 m .10735 .37551 L .1042 .39428 L p F P
0 g
s
.578 .433 .648 r
.1042 .39428 m .16375 .40705 L .16965 .37128 L p F P
0 g
s
.815 .727 .768 r
.32816 .49421 m .38218 .49539 L .39225 .44885 L p F P
0 g
s
.793 .789 .849 r
.38218 .49539 m .32816 .49421 L .31569 .53873 L p F P
0 g
s
.563 .551 .799 r
.21431 .4668 m .15695 .44201 L .15017 .47147 L p F P
0 g
s
.563 .551 .799 r
.15017 .47147 m .20451 .50644 L .21431 .4668 L p F P
0 g
s
.716 .709 .842 r
.25996 .52953 m .31569 .53873 L .32816 .49421 L p F P
0 g
s
.83 .672 .686 r
.39956 .40091 m .34807 .38537 L .3395 .44057 L p F P
0 g
s
.83 .672 .686 r
.3395 .44057 m .39225 .44885 L .39956 .40091 L p F P
0 g
s
.616 .403 .569 r
.23681 .32763 m .17385 .3395 L .16965 .37128 L p F P
0 g
s
.767 .539 .588 r
.35267 .33647 m .29693 .32613 L .29171 .37519 L p F P
0 g
s
.767 .539 .588 r
.29171 .37519 m .34807 .38537 L .35267 .33647 L p F P
0 g
s
.815 .727 .768 r
.39225 .44885 m .3395 .44057 L .32816 .49421 L p F P
0 g
s
.635 .625 .823 r
.27181 .48466 m .21431 .4668 L .20451 .50644 L p F P
0 g
s
.635 .625 .823 r
.20451 .50644 m .25996 .52953 L .27181 .48466 L p F P
0 g
s
.716 .709 .842 r
.32816 .49421 m .27181 .48466 L .25996 .52953 L p F P
0 g
s
.61 .524 .732 r
.22381 .41936 m .16375 .40705 L .15695 .44201 L p F P
0 g
s
.61 .524 .732 r
.15695 .44201 m .21431 .4668 L .22381 .41936 L p F P
0 g
s
.688 .467 .581 r
.29693 .32613 m .23681 .32763 L .23167 .3707 L p F P
0 g
s
.616 .403 .569 r
.16965 .37128 m .23167 .3707 L .23681 .32763 L p F P
0 g
s
.626 .477 .661 r
.23167 .3707 m .16965 .37128 L .16375 .40705 L p F P
0 g
s
.688 .467 .581 r
.23167 .3707 m .29171 .37519 L .29693 .32613 L p F P
0 g
s
.626 .477 .661 r
.16375 .40705 m .22381 .41936 L .23167 .3707 L p F P
0 g
s
.746 .658 .763 r
.27181 .48466 m .32816 .49421 L .3395 .44057 L p F P
0 g
s
.761 .605 .684 r
.34807 .38537 m .29171 .37519 L .28293 .43067 L p F P
0 g
s
.761 .605 .684 r
.28293 .43067 m .3395 .44057 L .34807 .38537 L p F P
0 g
s
.674 .587 .749 r
.28293 .43067 m .22381 .41936 L .21431 .4668 L p F P
0 g
s
.674 .587 .749 r
.21431 .4668 m .27181 .48466 L .28293 .43067 L p F P
0 g
s
.746 .658 .763 r
.3395 .44057 m .28293 .43067 L .27181 .48466 L p F P
0 g
s
.69 .537 .674 r
.29171 .37519 m .23167 .3707 L .22381 .41936 L p F P
0 g
s
.69 .537 .674 r
.22381 .41936 m .28293 .43067 L .29171 .37519 L p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.431973 0.0147151 0.568027 0.360953 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
8.93383e-17 1.07205 -0.0183018 1.07205 [
[ 0 0 0 0 ]
[ 1 .93328 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .93328 L
0 .93328 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.702 .542 .668 r
.78475 .65714 m .72399 .64559 L .73618 .60322 L p F P
0 g
s
.702 .542 .668 r
.73618 .60322 m .7937 .62561 L .78475 .65714 L p F P
0 g
s
.681 .569 .722 r
.7937 .62561 m .73618 .60322 L .75597 .56352 L p F P
0 g
s
.746 .589 .681 r
.68623 .58345 m .73618 .60322 L .72399 .64559 L p F P
0 g
s
.723 .62 .742 r
.73618 .60322 m .68623 .58345 L .70869 .53813 L p F P
0 g
s
.723 .62 .742 r
.70869 .53813 m .75597 .56352 L .73618 .60322 L p F P
0 g
s
.674 .513 .66 r
.85276 .66705 m .78475 .65714 L .7937 .62561 L p F P
0 g
s
.674 .513 .66 r
.7937 .62561 m .85748 .65018 L .85276 .66705 L p F P
0 g
s
.656 .538 .708 r
.85748 .65018 m .7937 .62561 L .80849 .59613 L p F P
0 g
s
.681 .569 .722 r
.75597 .56352 m .80849 .59613 L .7937 .62561 L p F P
0 g
s
.645 .581 .768 r
.80849 .59613 m .75597 .56352 L .78125 .5308 L p F P
0 g
s
.683 .638 .798 r
.75597 .56352 m .70869 .53813 L .73722 .50062 L p F P
0 g
s
.683 .638 .798 r
.73722 .50062 m .78125 .5308 L .75597 .56352 L p F P
0 g
s
.707 .497 .601 r
.78267 .68718 m .72078 .68602 L .72399 .64559 L p F P
0 g
s
.707 .497 .601 r
.72399 .64559 m .78475 .65714 L .78267 .68718 L p F P
0 g
s
.757 .541 .604 r
.67218 .63171 m .72399 .64559 L .72078 .68602 L p F P
0 g
s
.746 .589 .681 r
.72399 .64559 m .67218 .63171 L .68623 .58345 L p F P
0 g
s
.809 .657 .694 r
.64425 .5664 m .68623 .58345 L .67218 .63171 L p F P
0 g
s
.78 .693 .767 r
.68623 .58345 m .64425 .5664 L .6668 .52071 L p F P
0 g
s
.78 .693 .767 r
.6668 .52071 m .70869 .53813 L .68623 .58345 L p F P
0 g
s
.656 .538 .708 r
.80849 .59613 m .86543 .63445 L .85748 .65018 L p F P
0 g
s
.621 .547 .75 r
.86543 .63445 m .80849 .59613 L .82748 .57199 L p F P
0 g
s
.645 .581 .768 r
.78125 .5308 m .82748 .57199 L .80849 .59613 L p F P
0 g
s
.677 .471 .599 r
.85183 .6831 m .78267 .68718 L .78475 .65714 L p F P
0 g
s
.677 .471 .599 r
.78475 .65714 m .85276 .66705 L .85183 .6831 L p F P
0 g
s
.738 .721 .836 r
.70869 .53813 m .6668 .52071 L .69526 .4828 L p F P
0 g
s
.738 .721 .836 r
.69526 .4828 m .73722 .50062 L .70869 .53813 L p F P
0 g
s
.757 .541 .604 r
.72078 .68602 m .66814 .67776 L .67218 .63171 L p F P
0 g
s
.829 .607 .602 r
.62998 .61497 m .67218 .63171 L .66814 .67776 L p F P
0 g
s
.809 .657 .694 r
.67218 .63171 m .62998 .61497 L .64425 .5664 L p F P
0 g
s
.661 .5 .656 r
.85748 .65018 m .92526 .67618 L .85276 .66705 L closepath p F P
0 g
s
.644 .523 .702 r
.86543 .63445 m .92526 .67618 L .85748 .65018 L closepath p F P
0 g
s
.61 .531 .74 r
.87569 .62166 m .92526 .67618 L .86543 .63445 L closepath p F P
0 g
s
.621 .547 .75 r
.82748 .57199 m .87569 .62166 L .86543 .63445 L p F P
0 g
s
.561 .536 .784 r
.87569 .62166 m .82748 .57199 L .84858 .55601 L p F P
0 g
s
.581 .575 .811 r
.82748 .57199 m .78125 .5308 L .80931 .50882 L p F P
0 g
s
.581 .575 .811 r
.80931 .50882 m .84858 .55601 L .82748 .57199 L p F P
0 g
s
.615 .641 .853 r
.78125 .5308 m .73722 .50062 L .76882 .47518 L p F P
0 g
s
.615 .641 .853 r
.76882 .47518 m .80931 .50882 L .78125 .5308 L p F P
0 g
s
.663 .458 .598 r
.85276 .66705 m .92526 .67618 L .85183 .6831 L closepath p F P
0 g
s
.659 .399 .516 r
.85482 .69643 m .78779 .71232 L .78267 .68718 L p F P
0 g
s
.659 .399 .516 r
.78267 .68718 m .85183 .6831 L .85482 .69643 L p F P
0 g
s
.693 .421 .507 r
.72078 .68602 m .78267 .68718 L .78779 .71232 L p F P
0 g
s
.693 .421 .507 r
.78779 .71232 m .72709 .71998 L .72078 .68602 L p F P
0 g
s
.75 .46 .491 r
.66814 .67776 m .72078 .68602 L .72709 .71998 L p F P
0 g
s
.552 .519 .772 r
.88709 .61335 m .92526 .67618 L .87569 .62166 L closepath p F P
0 g
s
.561 .536 .784 r
.84858 .55601 m .88709 .61335 L .87569 .62166 L p F P
0 g
s
.882 .741 .701 r
.60981 .55187 m .64425 .5664 L .62998 .61497 L p F P
0 g
s
.848 .783 .788 r
.64425 .5664 m .60981 .55187 L .62982 .51117 L p F P
0 g
s
.848 .783 .788 r
.62982 .51117 m .6668 .52071 L .64425 .5664 L p F P
0 g
s
.644 .39 .519 r
.85183 .6831 m .92526 .67618 L .85482 .69643 L closepath p F P
0 g
s
.663 .743 .909 r
.73722 .50062 m .69526 .4828 L .72664 .45697 L p F P
0 g
s
.663 .743 .909 r
.72664 .45697 m .76882 .47518 L .73722 .50062 L p F P
0 g
s
.801 .825 .87 r
.6668 .52071 m .62982 .51117 L .65491 .47739 L p F P
0 g
s
.801 .825 .87 r
.65491 .47739 m .69526 .4828 L .6668 .52071 L p F P
0 g
s
.75 .46 .491 r
.72709 .71998 m .67475 .71648 L .66814 .67776 L p F P
0 g
s
.829 .607 .602 r
.66814 .67776 m .62559 .66124 L .62998 .61497 L p F P
0 g
s
.834 .518 .455 r
.62559 .66124 m .66814 .67776 L .67475 .71648 L p F P
0 g
s
.912 .688 .585 r
.59702 .59507 m .62998 .61497 L .62559 .66124 L p F P
0 g
s
.882 .741 .701 r
.62998 .61497 m .59702 .59507 L .60981 .55187 L p F P
0 g
s
.453 .474 .791 r
.89828 .61053 m .92526 .67618 L .88709 .61335 L closepath p F P
0 g
s
.268 .361 .774 r
.90793 .61362 m .92526 .67618 L .89828 .61053 L closepath p F P
0 g
s
0 .092 .635 r
.91484 .62233 m .92526 .67618 L .90793 .61362 L closepath p F P
0 g
s
0 0 .223 r
.91813 .63567 m .92526 .67618 L .91484 .62233 L closepath p F P
0 g
s
.922 .746 .259 r
.91735 .65202 m .92526 .67618 L .91813 .63567 L closepath p F P
0 g
s
.97 .901 .542 r
.91256 .66936 m .92526 .67618 L .91735 .65202 L closepath p F P
0 g
s
.589 .273 .401 r
.85482 .69643 m .92526 .67618 L .86142 .70546 L closepath p F P
0 g
s
.919 .973 .69 r
.90435 .68552 m .92526 .67618 L .91256 .66936 L closepath p F P
0 g
s
0 0 0 r
.88213 .70662 m .92526 .67618 L .89376 .69847 L closepath p F P
0 g
s
.128 0 0 r
.8709 .70902 m .92526 .67618 L .88213 .70662 L closepath p F P
0 g
s
.452 .059 .202 r
.86142 .70546 m .92526 .67618 L .8709 .70902 L closepath p F P
0 g
s
.772 .985 .737 r
.89376 .69847 m .92526 .67618 L .90435 .68552 L closepath p F P
0 g
s
.456 .492 .807 r
.88709 .61335 m .84858 .55601 L .86938 .55019 L p F P
0 g
s
.456 .492 .807 r
.86938 .55019 m .89828 .61053 L .88709 .61335 L p F P
0 g
s
.603 .275 .387 r
.78779 .71232 m .85482 .69643 L .86142 .70546 L p F P
0 g
s
.464 .534 .844 r
.84858 .55601 m .80931 .50882 L .83704 .50037 L p F P
0 g
s
.464 .534 .844 r
.83704 .50037 m .86938 .55019 L .84858 .55601 L p F P
0 g
s
.603 .275 .387 r
.86142 .70546 m .79967 .72951 L .78779 .71232 L p F P
0 g
s
.637 .282 .353 r
.72709 .71998 m .78779 .71232 L .79967 .72951 L p F P
0 g
s
.476 .611 .905 r
.80931 .50882 m .76882 .47518 L .80001 .46506 L p F P
0 g
s
.476 .611 .905 r
.80001 .46506 m .83704 .50037 L .80931 .50882 L p F P
0 g
s
.252 .372 .792 r
.89828 .61053 m .86938 .55019 L .88742 .55548 L p F P
0 g
s
.252 .372 .792 r
.88742 .55548 m .90793 .61362 L .89828 .61053 L p F P
0 g
s
.709 .868 .957 r
.69526 .4828 m .65491 .47739 L .68241 .45439 L p F P
0 g
s
.709 .868 .957 r
.68241 .45439 m .72664 .45697 L .69526 .4828 L p F P
0 g
s
.637 .282 .353 r
.79967 .72951 m .74246 .74338 L .72709 .71998 L p F P
0 g
s
.695 .294 .283 r
.67475 .71648 m .72709 .71998 L .74246 .74338 L p F P
0 g
s
.454 .038 .158 r
.79967 .72951 m .86142 .70546 L .8709 .70902 L p F P
0 g
s
.834 .518 .455 r
.67475 .71648 m .63177 .70006 L .62559 .66124 L p F P
0 g
s
.912 .688 .585 r
.62559 .66124 m .59289 .63609 L .59702 .59507 L p F P
0 g
s
.925 .586 .378 r
.59289 .63609 m .62559 .66124 L .63177 .70006 L p F P
0 g
s
.482 .73 .98 r
.76882 .47518 m .72664 .45697 L .75749 .44652 L p F P
0 g
s
.482 .73 .98 r
.75749 .44652 m .80001 .46506 L .76882 .47518 L p F P
0 g
s
.946 .822 .69 r
.58167 .53941 m .60981 .55187 L .59702 .59507 L p F P
0 g
s
.906 .871 .792 r
.60981 .55187 m .58167 .53941 L .59674 .50867 L p F P
0 g
s
.906 .871 .792 r
.59674 .50867 m .62982 .51117 L .60981 .55187 L p F P
0 g
s
0 .066 .625 r
.90793 .61362 m .88742 .55548 L .9004 .57155 L p F P
0 g
s
0 .066 .625 r
.9004 .57155 m .91484 .62233 L .90793 .61362 L p F P
0 g
s
.212 .4 .831 r
.86938 .55019 m .83704 .50037 L .86114 .50693 L p F P
0 g
s
.212 .4 .831 r
.86114 .50693 m .88742 .55548 L .86938 .55019 L p F P
0 g
s
.076 0 0 r
.81707 .73652 m .8709 .70902 L .88213 .70662 L p F P
0 g
s
.454 .038 .158 r
.8709 .70902 m .81707 .73652 L .79967 .72951 L p F P
0 g
s
.695 .294 .283 r
.74246 .74338 m .69163 .74323 L .67475 .71648 L p F P
0 g
s
.772 .306 .138 r
.63177 .70006 m .67475 .71648 L .69163 .74323 L p F P
0 g
s
.849 .923 .88 r
.62982 .51117 m .59674 .50867 L .61549 .48321 L p F P
0 g
s
.849 .923 .88 r
.61549 .48321 m .65491 .47739 L .62982 .51117 L p F P
0 g
s
.457 0 .048 r
.74246 .74338 m .79967 .72951 L .81707 .73652 L p F P
0 g
s
.978 .761 .541 r
.57197 .57198 m .59702 .59507 L .59289 .63609 L p F P
0 g
s
.946 .822 .69 r
.59702 .59507 m .57197 .57198 L .58167 .53941 L p F P
0 g
s
.732 .449 0 r
.91484 .62233 m .9004 .57155 L .90659 .59666 L p F P
0 g
s
.732 .449 0 r
.90659 .59666 m .91813 .63567 L .91484 .62233 L p F P
0 g
s
.076 0 0 r
.88213 .70662 m .83801 .73219 L .81707 .73652 L p F P
0 g
s
.497 .885 .708 r
.83801 .73219 m .88213 .70662 L .89376 .69847 L p F P
0 g
s
.12 .446 .881 r
.83704 .50037 m .80001 .46506 L .8271 .47205 L p F P
0 g
s
.12 .446 .881 r
.8271 .47205 m .86114 .50693 L .83704 .50037 L p F P
0 g
s
.433 .835 .977 r
.72664 .45697 m .68241 .45439 L .70924 .44508 L p F P
0 g
s
.433 .835 .977 r
.70924 .44508 m .75749 .44652 L .72664 .45697 L p F P
0 g
s
.716 .962 .943 r
.65491 .47739 m .61549 .48321 L .63588 .46596 L p F P
0 g
s
.716 .962 .943 r
.63588 .46596 m .68241 .45439 L .65491 .47739 L p F P
0 g
s
.457 0 .048 r
.81707 .73652 m .76539 .75309 L .74246 .74338 L p F P
0 g
s
.441 0 0 r
.69163 .74323 m .74246 .74338 L .76539 .75309 L p F P
0 g
s
.772 .306 .138 r
.69163 .74323 m .64817 .7268 L .63177 .70006 L p F P
0 g
s
.776 .281 0 r
.59805 .67032 m .63177 .70006 L .64817 .7268 L p F P
0 g
s
.925 .586 .378 r
.63177 .70006 m .59805 .67032 L .59289 .63609 L p F P
0 g
s
.978 .761 .541 r
.59289 .63609 m .56873 .60276 L .57197 .57198 L p F P
0 g
s
.958 .623 .247 r
.56873 .60276 m .59289 .63609 L .59805 .67032 L p F P
0 g
s
.974 .774 .349 r
.91813 .63567 m .90659 .59666 L .90503 .6278 L p F P
0 g
s
.974 .774 .349 r
.90503 .6278 m .91735 .65202 L .91813 .63567 L p F P
0 g
s
.819 1 .811 r
.85995 .71678 m .89376 .69847 L .90435 .68552 L p F P
0 g
s
.497 .885 .708 r
.89376 .69847 m .85995 .71678 L .83801 .73219 L p F P
0 g
s
0 .001 .574 r
.88742 .55548 m .86114 .50693 L .87853 .52824 L p F P
0 g
s
0 .001 .574 r
.87853 .52824 m .9004 .57155 L .88742 .55548 L p F P
0 g
s
0 0 0 r
.76539 .75309 m .81707 .73652 L .83801 .73219 L p F P
0 g
s
.988 .897 .601 r
.91735 .65202 m .90503 .6278 L .89581 .66103 L p F P
0 g
s
.988 .897 .601 r
.89581 .66103 m .91256 .66936 L .91735 .65202 L p F P
0 g
s
.937 .964 .741 r
.8801 .69203 m .90435 .68552 L .91256 .66936 L p F P
0 g
s
.819 1 .811 r
.90435 .68552 m .8801 .69203 L .85995 .71678 L p F P
0 g
s
0 .458 .811 r
.80001 .46506 m .75749 .44652 L .78417 .45329 L p F P
0 g
s
0 .458 .811 r
.78417 .45329 m .8271 .47205 L .80001 .46506 L p F P
0 g
s
.937 .964 .741 r
.91256 .66936 m .89581 .66103 L .8801 .69203 L p F P
0 g
s
.441 0 0 r
.76539 .75309 m .71718 .75436 L .69163 .74323 L p F P
0 g
s
.312 0 0 r
.64817 .7268 m .69163 .74323 L .71718 .75436 L p F P
0 g
s
.979 .875 .66 r
.55792 .52832 m .58167 .53941 L .57197 .57198 L p F P
0 g
s
.936 .929 .773 r
.58167 .53941 m .55792 .52832 L .56607 .51163 L p F P
0 g
s
.936 .929 .773 r
.56607 .51163 m .59674 .50867 L .58167 .53941 L p F P
0 g
s
.292 .788 .773 r
.68241 .45439 m .63588 .46596 L .65557 .45909 L p F P
0 g
s
.292 .788 .773 r
.65557 .45909 m .70924 .44508 L .68241 .45439 L p F P
0 g
s
.861 .979 .855 r
.59674 .50867 m .56607 .51163 L .57616 .49784 L p F P
0 g
s
.861 .979 .855 r
.57616 .49784 m .61549 .48321 L .59674 .50867 L p F P
0 g
s
1 .798 .477 r
.55262 .54599 m .57197 .57198 L .56873 .60276 L p F P
0 g
s
.979 .875 .66 r
.57197 .57198 m .55262 .54599 L .55792 .52832 L p F P
0 g
s
.894 .544 .063 r
.9004 .57155 m .87853 .52824 L .88676 .56214 L p F P
0 g
s
.894 .544 .063 r
.88676 .56214 m .90659 .59666 L .9004 .57155 L p F P
0 g
s
.621 .119 0 r
.86114 .50693 m .8271 .47205 L .8466 .49604 L p F P
0 g
s
.621 .119 0 r
.8466 .49604 m .87853 .52824 L .86114 .50693 L p F P
0 g
s
.776 .281 0 r
.64817 .7268 m .61218 .69366 L .59805 .67032 L p F P
0 g
s
.607 .196 0 r
.57242 .62823 m .59805 .67032 L .61218 .69366 L p F P
0 g
s
.958 .623 .247 r
.59805 .67032 m .57242 .62823 L .56873 .60276 L p F P
0 g
s
0 0 0 r
.83801 .73219 m .79334 .74738 L .76539 .75309 L p F P
0 g
s
.63 .961 .898 r
.79334 .74738 m .83801 .73219 L .85995 .71678 L p F P
0 g
s
.279 0 0 r
.75749 .44652 m .70924 .44508 L .73223 .45106 L p F P
0 g
s
.279 0 0 r
.73223 .45106 m .78417 .45329 L .75749 .44652 L p F P
0 g
s
.265 .766 .885 r
.71718 .75436 m .76539 .75309 L .79334 .74738 L p F P
0 g
s
.67 .976 .859 r
.61549 .48321 m .57616 .49784 L .58702 .48858 L p F P
0 g
s
.67 .976 .859 r
.58702 .48858 m .63588 .46596 L .61549 .48321 L p F P
0 g
s
.312 0 0 r
.71718 .75436 m .67328 .73777 L .64817 .7268 L p F P
0 g
s
0 .347 .815 r
.61218 .69366 m .64817 .7268 L .67328 .73777 L p F P
0 g
s
1 .798 .477 r
.56873 .60276 m .55082 .56259 L .55262 .54599 L p F P
0 g
s
.907 .604 .112 r
.55082 .56259 m .56873 .60276 L .57242 .62823 L p F P
0 g
s
.995 .767 .472 r
.90659 .59666 m .88676 .56214 L .88448 .60457 L p F P
0 g
s
.995 .767 .472 r
.88448 .60457 m .90503 .6278 L .90659 .59666 L p F P
0 g
s
.727 .209 0 r
.8271 .47205 m .78417 .45329 L .8032 .4772 L p F P
0 g
s
.727 .209 0 r
.8032 .4772 m .8466 .49604 L .8271 .47205 L p F P
0 g
s
.844 .964 .882 r
.82292 .72644 m .85995 .71678 L .8801 .69203 L p F P
0 g
s
.63 .961 .898 r
.85995 .71678 m .82292 .72644 L .79334 .74738 L p F P
0 g
s
.345 0 0 r
.70924 .44508 m .65557 .45909 L .67221 .4637 L p F P
0 g
s
.345 0 0 r
.67221 .4637 m .73223 .45106 L .70924 .44508 L p F P
0 g
s
.265 .766 .885 r
.79334 .74738 m .74863 .74782 L .71718 .75436 L p F P
0 g
s
.398 .724 .989 r
.67328 .73777 m .71718 .75436 L .74863 .74782 L p F P
0 g
s
0 0 0 r
.63588 .46596 m .58702 .48858 L .59737 .485 L p F P
0 g
s
0 0 0 r
.59737 .485 m .65557 .45909 L .63588 .46596 L p F P
0 g
s
.93 .558 .279 r
.87853 .52824 m .8466 .49604 L .85569 .53466 L p F P
0 g
s
.93 .558 .279 r
.85569 .53466 m .88676 .56214 L .87853 .52824 L p F P
0 g
s
0 .347 .815 r
.67328 .73777 m .63393 .70294 L .61218 .69366 L p F P
0 g
s
.607 .196 0 r
.61218 .69366 m .58277 .64533 L .57242 .62823 L p F P
0 g
s
.067 .326 .805 r
.58277 .64533 m .61218 .69366 L .63393 .70294 L p F P
0 g
s
.907 .604 .112 r
.57242 .62823 m .55274 .57617 L .55082 .56259 L p F P
0 g
s
0 0 .47 r
.55274 .57617 m .57242 .62823 L .58277 .64533 L p F P
0 g
s
.97 .851 .667 r
.90503 .6278 m .88448 .60457 L .87179 .65008 L p F P
0 g
s
.97 .851 .667 r
.87179 .65008 m .89581 .66103 L .90503 .6278 L p F P
0 g
s
.923 .909 .789 r
.8503 .69259 m .8801 .69203 L .89581 .66103 L p F P
0 g
s
.844 .964 .882 r
.8801 .69203 m .8503 .69259 L .82292 .72644 L p F P
0 g
s
.681 .899 .975 r
.74863 .74782 m .79334 .74738 L .82292 .72644 L p F P
0 g
s
.923 .909 .789 r
.89581 .66103 m .87179 .65008 L .8503 .69259 L p F P
0 g
s
.671 .226 .186 r
.78417 .45329 m .73223 .45106 L .7484 .47218 L p F P
0 g
s
.671 .226 .186 r
.7484 .47218 m .8032 .4772 L .78417 .45329 L p F P
0 g
s
.986 .895 .633 r
.53603 .51772 m .55792 .52832 L .55262 .54599 L closepath p F P
0 g
s
.941 .952 .752 r
.53603 .51772 m .56607 .51163 L .55792 .52832 L closepath p F P
0 g
s
.398 .724 .989 r
.74863 .74782 m .70436 .73094 L .67328 .73777 L p F P
0 g
s
.42 .603 .922 r
.63393 .70294 m .67328 .73777 L .70436 .73094 L p F P
0 g
s
.854 .995 .825 r
.53603 .51772 m .57616 .49784 L .56607 .51163 L closepath p F P
0 g
s
.993 .806 .431 r
.53603 .51772 m .55262 .54599 L .55082 .56259 L closepath p F P
0 g
s
.357 0 .002 r
.65557 .45909 m .59737 .485 L .60597 .4876 L p F P
0 g
s
.357 0 .002 r
.60597 .4876 m .67221 .4637 L .65557 .45909 L p F P
0 g
s
.067 .326 .805 r
.63393 .70294 m .59872 .65178 L .58277 .64533 L p F P
0 g
s
.125 .302 .772 r
.5582 .58509 m .58277 .64533 L .59872 .65178 L p F P
0 g
s
0 0 .47 r
.58277 .64533 m .5582 .58509 L .55274 .57617 L p F P
0 g
s
.625 .954 .786 r
.53603 .51772 m .58702 .48858 L .57616 .49784 L closepath p F P
0 g
s
.851 .575 .038 r
.53603 .51772 m .55082 .56259 L .55274 .57617 L closepath p F P
0 g
s
.934 .697 .555 r
.88676 .56214 m .85569 .53466 L .85282 .58333 L p F P
0 g
s
.934 .697 .555 r
.85282 .58333 m .88448 .60457 L .88676 .56214 L p F P
0 g
s
.843 .5 .404 r
.8466 .49604 m .8032 .4772 L .81185 .51591 L p F P
0 g
s
.843 .5 .404 r
.81185 .51591 m .85569 .53466 L .8466 .49604 L p F P
0 g
s
.611 .221 .28 r
.73223 .45106 m .67221 .4637 L .68369 .47954 L p F P
0 g
s
.611 .221 .28 r
.68369 .47954 m .7484 .47218 L .73223 .45106 L p F P
0 g
s
.806 .857 .887 r
.78216 .72373 m .82292 .72644 L .8503 .69259 L p F P
0 g
s
.681 .899 .975 r
.82292 .72644 m .78216 .72373 L .74863 .74782 L p F P
0 g
s
.647 .761 .932 r
.70436 .73094 m .74863 .74782 L .78216 .72373 L p F P
0 g
s
.42 .603 .922 r
.70436 .73094 m .66092 .69647 L .63393 .70294 L p F P
0 g
s
.414 .518 .855 r
.59872 .65178 m .63393 .70294 L .66092 .69647 L p F P
0 g
s
0 0 0 r
.53603 .51772 m .59737 .485 L .58702 .48858 L closepath p F P
0 g
s
0 0 .499 r
.53603 .51772 m .55274 .57617 L .5582 .58509 L closepath p F P
0 g
s
.701 .539 .665 r
.38957 .49899 m .32495 .48682 L .33908 .44186 L p F P
0 g
s
.701 .539 .665 r
.33908 .44186 m .39994 .46553 L .38957 .49899 L p F P
0 g
s
.679 .568 .723 r
.39994 .46553 m .33908 .44186 L .35952 .399 L p F P
0 g
s
.748 .59 .679 r
.28449 .42024 m .33908 .44186 L .32495 .48682 L p F P
0 g
s
.723 .622 .744 r
.33908 .44186 m .28449 .42024 L .30768 .37131 L p F P
0 g
s
.723 .622 .744 r
.30768 .37131 m .35952 .399 L .33908 .44186 L p F P
0 g
s
.67 .506 .655 r
.46071 .50892 m .38957 .49899 L .39994 .46553 L p F P
0 g
s
.67 .506 .655 r
.39994 .46553 m .46618 .49101 L .46071 .50892 L p F P
0 g
s
.65 .534 .708 r
.46618 .49101 m .39994 .46553 L .41522 .43371 L p F P
0 g
s
.679 .568 .723 r
.35952 .399 m .41522 .43371 L .39994 .46553 L p F P
0 g
s
.638 .581 .773 r
.41522 .43371 m .35952 .399 L .3841 .36289 L p F P
0 g
s
.682 .641 .802 r
.35952 .399 m .30768 .37131 L .33537 .32989 L p F P
0 g
s
.682 .641 .802 r
.33537 .32989 m .3841 .36289 L .35952 .399 L p F P
0 g
s
.902 .76 .695 r
.88448 .60457 m .85282 .58333 L .83809 .6357 L p F P
0 g
s
.902 .76 .695 r
.83809 .6357 m .87179 .65008 L .88448 .60457 L p F P
0 g
s
.707 .489 .591 r
.38528 .53037 m .31871 .52904 L .32495 .48682 L p F P
0 g
s
.707 .489 .591 r
.32495 .48682 m .38957 .49899 L .38528 .53037 L p F P
0 g
s
.76 .539 .598 r
.26821 .47146 m .32495 .48682 L .31871 .52904 L p F P
0 g
s
.748 .59 .679 r
.32495 .48682 m .26821 .47146 L .28449 .42024 L p F P
0 g
s
.574 .215 .321 r
.67221 .4637 m .60597 .4876 L .61175 .49616 L p F P
0 g
s
.574 .215 .321 r
.61175 .49616 m .68369 .47954 L .67221 .4637 L p F P
0 g
s
.809 .657 .694 r
.23628 .40065 m .28449 .42024 L .26821 .47146 L p F P
0 g
s
.78 .693 .767 r
.28449 .42024 m .23628 .40065 L .25955 .35129 L p F P
0 g
s
.78 .693 .767 r
.25955 .35129 m .30768 .37131 L .28449 .42024 L p F P
0 g
s
.863 .808 .795 r
.81341 .6847 m .8503 .69259 L .87179 .65008 L p F P
0 g
s
.806 .857 .887 r
.8503 .69259 m .81341 .6847 L .78216 .72373 L p F P
0 g
s
.751 .44 .456 r
.8032 .4772 m .7484 .47218 L .75545 .5063 L p F P
0 g
s
.751 .44 .456 r
.75545 .5063 m .81185 .51591 L .8032 .4772 L p F P
0 g
s
.65 .534 .708 r
.41522 .43371 m .4744 .47402 L .46618 .49101 L p F P
0 g
s
.61 .543 .754 r
.4744 .47402 m .41522 .43371 L .43373 .40708 L p F P
0 g
s
.638 .581 .773 r
.3841 .36289 m .43373 .40708 L .41522 .43371 L p F P
0 g
s
.357 0 .056 r
.53603 .51772 m .60597 .4876 L .59737 .485 L closepath p F P
0 g
s
.673 .458 .586 r
.45862 .52567 m .38528 .53037 L .38957 .49899 L p F P
0 g
s
.673 .458 .586 r
.38957 .49899 m .46071 .50892 L .45862 .52567 L p F P
0 g
s
.414 .518 .855 r
.66092 .69647 m .61848 .64649 L .59872 .65178 L p F P
0 g
s
.406 .471 .814 r
.5666 .58822 m .59872 .65178 L .61848 .64649 L p F P
0 g
s
.125 .302 .772 r
.59872 .65178 m .5666 .58822 L .5582 .58509 L p F P
0 g
s
.145 .289 .754 r
.53603 .51772 m .5582 .58509 L .5666 .58822 L closepath p F P
0 g
s
.738 .721 .836 r
.30768 .37131 m .25955 .35129 L .28711 .30939 L p F P
0 g
s
.738 .721 .836 r
.28711 .30939 m .33537 .32989 L .30768 .37131 L p F P
0 g
s
.863 .808 .795 r
.87179 .65008 m .83809 .6357 L .81341 .6847 L p F P
0 g
s
.647 .761 .932 r
.78216 .72373 m .73766 .70646 L .70436 .73094 L p F P
0 g
s
.599 .647 .869 r
.66092 .69647 m .70436 .73094 L .73766 .70646 L p F P
0 g
s
.76 .539 .598 r
.31871 .52904 m .26063 .51954 L .26821 .47146 L p F P
0 g
s
.829 .607 .602 r
.21972 .45222 m .26821 .47146 L .26063 .51954 L p F P
0 g
s
.809 .657 .694 r
.26821 .47146 m .21972 .45222 L .23628 .40065 L p F P
0 g
s
.841 .608 .586 r
.85569 .53466 m .81185 .51591 L .8086 .56481 L p F P
0 g
s
.841 .608 .586 r
.8086 .56481 m .85282 .58333 L .85569 .53466 L p F P
0 g
s
.655 .491 .649 r
.46618 .49101 m .53603 .51772 L .46071 .50892 L closepath p F P
0 g
s
.636 .517 .701 r
.4744 .47402 m .53603 .51772 L .46618 .49101 L closepath p F P
0 g
s
.597 .524 .744 r
.48442 .45991 m .53603 .51772 L .4744 .47402 L closepath p F P
0 g
s
.61 .543 .754 r
.43373 .40708 m .48442 .45991 L .4744 .47402 L p F P
0 g
s
.54 .529 .791 r
.48442 .45991 m .43373 .40708 L .45341 .38871 L p F P
0 g
s
.566 .573 .819 r
.43373 .40708 m .3841 .36289 L .41019 .33763 L p F P
0 g
s
.566 .573 .819 r
.41019 .33763 m .45341 .38871 L .43373 .40708 L p F P
0 g
s
.608 .644 .861 r
.3841 .36289 m .33537 .32989 L .36463 .30063 L p F P
0 g
s
.608 .644 .861 r
.36463 .30063 m .41019 .33763 L .3841 .36289 L p F P
0 g
s
.656 .443 .583 r
.46071 .50892 m .53603 .51772 L .45862 .52567 L closepath p F P
0 g
s
.557 .21 .337 r
.53603 .51772 m .61175 .49616 L .60597 .4876 L closepath p F P
0 g
s
.688 .398 .478 r
.7484 .47218 m .68369 .47954 L .68841 .50494 L p F P
0 g
s
.688 .398 .478 r
.68841 .50494 m .75545 .5063 L .7484 .47218 L p F P
0 g
s
.739 .737 .849 r
.73766 .70646 m .78216 .72373 L .81341 .6847 L p F P
0 g
s
.65 .373 .487 r
.46018 .53932 m .38765 .5561 L .38528 .53037 L p F P
0 g
s
.65 .373 .487 r
.38528 .53037 m .45862 .52567 L .46018 .53932 L p F P
0 g
s
.689 .402 .483 r
.31871 .52904 m .38528 .53037 L .38765 .5561 L p F P
0 g
s
.406 .471 .814 r
.61848 .64649 m .57697 .58509 L .5666 .58822 L p F P
0 g
s
.401 .449 .795 r
.53603 .51772 m .5666 .58822 L .57697 .58509 L closepath p F P
0 g
s
.689 .402 .483 r
.38765 .5561 m .32121 .5638 L .31871 .52904 L p F P
0 g
s
.751 .45 .474 r
.26063 .51954 m .31871 .52904 L .32121 .5638 L p F P
0 g
s
.528 .508 .778 r
.49509 .45035 m .53603 .51772 L .48442 .45991 L closepath p F P
0 g
s
.54 .529 .791 r
.45341 .38871 m .49509 .45035 L .48442 .45991 L p F P
0 g
s
.873 .732 .703 r
.19383 .38283 m .23628 .40065 L .21972 .45222 L p F P
0 g
s
.841 .772 .785 r
.23628 .40065 m .19383 .38283 L .21448 .33882 L p F P
0 g
s
.841 .772 .785 r
.21448 .33882 m .25955 .35129 L .23628 .40065 L p F P
0 g
s
.599 .647 .869 r
.73766 .70646 m .68987 .67451 L .66092 .69647 L p F P
0 g
s
.563 .572 .821 r
.61848 .64649 m .66092 .69647 L .68987 .67451 L p F P
0 g
s
.632 .36 .489 r
.45862 .52567 m .53603 .51772 L .46018 .53932 L closepath p F P
0 g
s
.649 .372 .486 r
.68369 .47954 m .61175 .49616 L .61396 .50972 L p F P
0 g
s
.649 .372 .486 r
.61396 .50972 m .68841 .50494 L .68369 .47954 L p F P
0 g
s
.663 .743 .909 r
.33537 .32989 m .28711 .30939 L .31605 .27965 L p F P
0 g
s
.663 .743 .909 r
.31605 .27965 m .36463 .30063 L .33537 .32989 L p F P
0 g
s
.798 .811 .863 r
.25955 .35129 m .21448 .33882 L .23872 .30143 L p F P
0 g
s
.798 .811 .863 r
.23872 .30143 m .28711 .30939 L .25955 .35129 L p F P
0 g
s
.563 .572 .821 r
.68987 .67451 m .63966 .62981 L .61848 .64649 L p F P
0 g
s
.539 .528 .792 r
.57697 .58509 m .61848 .64649 L .63966 .62981 L p F P
0 g
s
.751 .45 .474 r
.32121 .5638 m .26279 .55917 L .26063 .51954 L p F P
0 g
s
.834 .518 .455 r
.21169 .50054 m .26063 .51954 L .26279 .55917 L p F P
0 g
s
.829 .607 .602 r
.26063 .51954 m .21169 .50054 L .21972 .45222 L p F P
0 g
s
.632 .36 .489 r
.53603 .51772 m .61396 .50972 L .61175 .49616 L closepath p F P
0 g
s
.902 .683 .597 r
.17896 .42873 m .21972 .45222 L .21169 .50054 L p F P
0 g
s
.873 .732 .703 r
.21972 .45222 m .17896 .42873 L .19383 .38283 L p F P
0 g
s
.539 .528 .792 r
.63966 .62981 m .58804 .576 L .57697 .58509 L p F P
0 g
s
.528 .508 .778 r
.53603 .51772 m .57697 .58509 L .58804 .576 L closepath p F P
0 g
s
.656 .443 .583 r
.53603 .51772 m .61228 .52664 L .61396 .50972 L closepath p F P
0 g
s
.655 .491 .649 r
.53603 .51772 m .60689 .54483 L .61228 .52664 L closepath p F P
0 g
s
.636 .517 .701 r
.53603 .51772 m .59845 .562 L .60689 .54483 L closepath p F P
0 g
s
.597 .524 .744 r
.53603 .51772 m .58804 .576 L .59845 .562 L closepath p F P
0 g
s
.401 .449 .795 r
.50515 .44652 m .53603 .51772 L .49509 .45035 L closepath p F P
0 g
s
.145 .289 .754 r
.51339 .44896 m .53603 .51772 L .50515 .44652 L closepath p F P
0 g
s
.993 .806 .431 r
.51867 .48817 m .53603 .51772 L .52065 .47108 L closepath p F P
0 g
s
.986 .895 .633 r
.51309 .50662 m .53603 .51772 L .51867 .48817 L closepath p F P
0 g
s
.941 .952 .752 r
.50459 .5241 m .53603 .51772 L .51309 .50662 L closepath p F P
0 g
s
.357 0 .056 r
.46527 .5482 m .53603 .51772 L .47331 .55119 L closepath p F P
0 g
s
.557 .21 .337 r
.46018 .53932 m .53603 .51772 L .46527 .5482 L closepath p F P
0 g
s
.854 .995 .825 r
.49425 .53842 m .53603 .51772 L .50459 .5241 L closepath p F P
0 g
s
0 0 0 r
.47331 .55119 m .53603 .51772 L .48337 .54782 L closepath p F P
0 g
s
.625 .954 .786 r
.48337 .54782 m .53603 .51772 L .49425 .53842 L closepath p F P
0 g
s
0 0 .499 r
.5188 .45747 m .53603 .51772 L .51339 .44896 L closepath p F P
0 g
s
.851 .575 .038 r
.52065 .47108 m .53603 .51772 L .5188 .45747 L closepath p F P
0 g
s
.408 .471 .814 r
.49509 .45035 m .45341 .38871 L .47203 .38089 L p F P
0 g
s
.408 .471 .814 r
.47203 .38089 m .50515 .44652 L .49509 .45035 L p F P
0 g
s
.819 .665 .692 r
.85282 .58333 m .8086 .56481 L .79361 .61756 L p F P
0 g
s
.819 .665 .692 r
.79361 .61756 m .83809 .6357 L .85282 .58333 L p F P
0 g
s
.575 .217 .323 r
.38765 .5561 m .46018 .53932 L .46527 .5482 L p F P
0 g
s
.762 .536 .591 r
.81185 .51591 m .75545 .5063 L .75218 .54938 L p F P
0 g
s
.762 .536 .591 r
.75218 .54938 m .8086 .56481 L .81185 .51591 L p F P
0 g
s
.424 .521 .853 r
.45341 .38871 m .41019 .33763 L .43488 .32638 L p F P
0 g
s
.424 .521 .853 r
.43488 .32638 m .47203 .38089 L .45341 .38871 L p F P
0 g
s
.788 .705 .773 r
.76883 .66699 m .81341 .6847 L .83809 .6357 L p F P
0 g
s
.739 .737 .849 r
.81341 .6847 m .76883 .66699 L .73766 .70646 L p F P
0 g
s
.68 .644 .807 r
.68987 .67451 m .73766 .70646 L .76883 .66699 L p F P
0 g
s
.575 .217 .323 r
.46527 .5482 m .39656 .57305 L .38765 .5561 L p F P
0 g
s
.616 .233 .294 r
.32121 .5638 m .38765 .5561 L .39656 .57305 L p F P
0 g
s
.672 .457 .585 r
.68841 .50494 m .61396 .50972 L .61228 .52664 L p F P
0 g
s
.45 .608 .914 r
.41019 .33763 m .36463 .30063 L .39225 .28722 L p F P
0 g
s
.45 .608 .914 r
.39225 .28722 m .43488 .32638 L .41019 .33763 L p F P
0 g
s
.788 .705 .773 r
.83809 .6357 m .79361 .61756 L .76883 .66699 L p F P
0 g
s
.61 .542 .754 r
.65957 .60364 m .59845 .562 L .58804 .576 L p F P
0 g
s
.61 .542 .754 r
.58804 .576 m .63966 .62981 L .65957 .60364 L p F P
0 g
s
.706 .487 .589 r
.75545 .5063 m .68841 .50494 L .68564 .53686 L p F P
0 g
s
.706 .487 .589 r
.68564 .53686 m .75218 .54938 L .75545 .5063 L p F P
0 g
s
.13 .304 .773 r
.50515 .44652 m .47203 .38089 L .48735 .38485 L p F P
0 g
s
.13 .304 .773 r
.48735 .38485 m .51339 .44896 L .50515 .44652 L p F P
0 g
s
.672 .457 .585 r
.61228 .52664 m .68564 .53686 L .68841 .50494 L p F P
0 g
s
.718 .852 .946 r
.28711 .30939 m .23872 .30143 L .26396 .2749 L p F P
0 g
s
.718 .852 .946 r
.26396 .2749 m .31605 .27965 L .28711 .30939 L p F P
0 g
s
.616 .233 .294 r
.39656 .57305 m .33244 .58689 L .32121 .5638 L p F P
0 g
s
.684 .262 .238 r
.26279 .55917 m .32121 .5638 L .33244 .58689 L p F P
0 g
s
.361 0 .007 r
.39656 .57305 m .46527 .5482 L .47331 .55119 L p F P
0 g
s
.67 .506 .654 r
.68564 .53686 m .61228 .52664 L .60689 .54483 L p F P
0 g
s
.68 .644 .807 r
.76883 .66699 m .71706 .63949 L .68987 .67451 L p F P
0 g
s
.637 .581 .775 r
.63966 .62981 m .68987 .67451 L .71706 .63949 L p F P
0 g
s
.637 .581 .775 r
.71706 .63949 m .65957 .60364 L .63966 .62981 L p F P
0 g
s
.65 .533 .708 r
.6756 .57126 m .60689 .54483 L .59845 .562 L p F P
0 g
s
.65 .533 .708 r
.59845 .562 m .65957 .60364 L .6756 .57126 L p F P
0 g
s
.67 .506 .654 r
.60689 .54483 m .6756 .57126 L .68564 .53686 L p F P
0 g
s
.834 .518 .455 r
.26279 .55917 m .21326 .54026 L .21169 .50054 L p F P
0 g
s
.918 .594 .415 r
.17152 .47157 m .21169 .50054 L .21326 .54026 L p F P
0 g
s
.902 .683 .597 r
.21169 .50054 m .17152 .47157 L .17896 .42873 L p F P
0 g
s
.75 .59 .678 r
.8086 .56481 m .75218 .54938 L .73881 .59584 L p F P
0 g
s
.75 .59 .678 r
.73881 .59584 m .79361 .61756 L .8086 .56481 L p F P
0 g
s
.482 .73 .98 r
.36463 .30063 m .31605 .27965 L .34318 .26582 L p F P
0 g
s
.482 .73 .98 r
.34318 .26582 m .39225 .28722 L .36463 .30063 L p F P
0 g
s
.927 .8 .701 r
.1559 .36632 m .19383 .38283 L .17896 .42873 L p F P
0 g
s
.891 .843 .791 r
.19383 .38283 m .1559 .36632 L .17145 .33303 L p F P
0 g
s
.891 .843 .791 r
.17145 .33303 m .21448 .33882 L .19383 .38283 L p F P
0 g
s
.724 .624 .746 r
.71706 .63949 m .76883 .66699 L .79361 .61756 L p F P
0 g
s
0 0 .476 r
.51339 .44896 m .48735 .38485 L .4974 .40045 L p F P
0 g
s
0 0 .476 r
.4974 .40045 m .5188 .45747 L .51339 .44896 L p F P
0 g
s
.095 .34 .812 r
.47203 .38089 m .43488 .32638 L .45521 .33102 L p F P
0 g
s
.095 .34 .812 r
.45521 .33102 m .48735 .38485 L .47203 .38089 L p F P
0 g
s
.701 .538 .664 r
.75218 .54938 m .68564 .53686 L .6756 .57126 L p F P
0 g
s
0 0 0 r
.41114 .57898 m .47331 .55119 L .48337 .54782 L p F P
0 g
s
.361 0 .007 r
.47331 .55119 m .41114 .57898 L .39656 .57305 L p F P
0 g
s
.679 .568 .723 r
.73881 .59584 m .6756 .57126 L .65957 .60364 L p F P
0 g
s
.679 .568 .723 r
.65957 .60364 m .71706 .63949 L .73881 .59584 L p F P
0 g
s
.684 .262 .238 r
.33244 .58689 m .27478 .58556 L .26279 .55917 L p F P
0 g
s
.772 .306 .138 r
.21326 .54026 m .26279 .55917 L .27478 .58556 L p F P
0 g
s
.844 .89 .872 r
.21448 .33882 m .17145 .33303 L .18953 .3048 L p F P
0 g
s
.844 .89 .872 r
.18953 .3048 m .23872 .30143 L .21448 .33882 L p F P
0 g
s
.724 .624 .746 r
.79361 .61756 m .73881 .59584 L .71706 .63949 L p F P
0 g
s
.368 0 0 r
.33244 .58689 m .39656 .57305 L .41114 .57898 L p F P
0 g
s
.701 .538 .664 r
.6756 .57126 m .73881 .59584 L .75218 .54938 L p F P
0 g
s
.959 .75 .578 r
.14459 .40095 m .17896 .42873 L .17152 .47157 L p F P
0 g
s
.927 .8 .701 r
.17896 .42873 m .14459 .40095 L .1559 .36632 L p F P
0 g
s
.904 .601 .106 r
.5188 .45747 m .4974 .40045 L .50077 .42605 L p F P
0 g
s
.904 .601 .106 r
.50077 .42605 m .52065 .47108 L .5188 .45747 L p F P
0 g
s
0 0 0 r
.48337 .54782 m .42975 .57282 L .41114 .57898 L p F P
0 g
s
.666 .974 .856 r
.42975 .57282 m .48337 .54782 L .49425 .53842 L p F P
0 g
s
.029 .402 .855 r
.43488 .32638 m .39225 .28722 L .41489 .29191 L p F P
0 g
s
.029 .402 .855 r
.41489 .29191 m .45521 .33102 L .43488 .32638 L p F P
0 g
s
.492 .846 .994 r
.31605 .27965 m .26396 .2749 L .28737 .26257 L p F P
0 g
s
.492 .846 .994 r
.28737 .26257 m .34318 .26582 L .31605 .27965 L p F P
0 g
s
.75 .939 .946 r
.23872 .30143 m .18953 .3048 L .20814 .28486 L p F P
0 g
s
.75 .939 .946 r
.20814 .28486 m .26396 .2749 L .23872 .30143 L p F P
0 g
s
.368 0 0 r
.41114 .57898 m .35139 .59515 L .33244 .58689 L p F P
0 g
s
.367 0 0 r
.27478 .58556 m .33244 .58689 L .35139 .59515 L p F P
0 g
s
.772 .306 .138 r
.27478 .58556 m .22461 .56659 L .21326 .54026 L p F P
0 g
s
.822 .344 0 r
.17248 .50656 m .21326 .54026 L .22461 .56659 L p F P
0 g
s
.918 .594 .415 r
.21326 .54026 m .17248 .50656 L .17152 .47157 L p F P
0 g
s
.968 .652 .353 r
.13879 .43311 m .17152 .47157 L .17248 .50656 L p F P
0 g
s
.959 .75 .578 r
.17152 .47157 m .13879 .43311 L .14459 .40095 L p F P
0 g
s
.999 .798 .474 r
.52065 .47108 m .50077 .42605 L .49687 .45862 L p F P
0 g
s
.999 .798 .474 r
.49687 .45862 m .51867 .48817 L .52065 .47108 L p F P
0 g
s
.861 .98 .854 r
.45018 .55501 m .49425 .53842 L .50459 .5241 L p F P
0 g
s
.666 .974 .856 r
.49425 .53842 m .45018 .55501 L .42975 .57282 L p F P
0 g
s
0 0 .403 r
.48735 .38485 m .45521 .33102 L .4685 .35159 L p F P
0 g
s
0 0 .403 r
.4685 .35159 m .4974 .40045 L .48735 .38485 L p F P
0 g
s
.255 .761 .738 r
.35139 .59515 m .41114 .57898 L .42975 .57282 L p F P
0 g
s
.98 .876 .658 r
.51867 .48817 m .49687 .45862 L .4861 .494 L p F P
0 g
s
.98 .876 .658 r
.4861 .494 m .51309 .50662 L .51867 .48817 L p F P
0 g
s
.936 .93 .773 r
.46982 .52759 m .50459 .5241 L .51309 .50662 L p F P
0 g
s
.861 .98 .854 r
.50459 .5241 m .46982 .52759 L .45018 .55501 L p F P
0 g
s
0 .458 .811 r
.39225 .28722 m .34318 .26582 L .36524 .27021 L p F P
0 g
s
0 .458 .811 r
.36524 .27021 m .41489 .29191 L .39225 .28722 L p F P
0 g
s
.936 .93 .773 r
.51309 .50662 m .4861 .494 L .46982 .52759 L p F P
0 g
s
.367 0 0 r
.35139 .59515 m .29561 .59502 L .27478 .58556 L p F P
0 g
s
.312 0 0 r
.22461 .56659 m .27478 .58556 L .29561 .59502 L p F P
0 g
s
.958 .846 .689 r
.12073 .35048 m .1559 .36632 L .14459 .40095 L p F P
0 g
s
.921 .891 .784 r
.1559 .36632 m .12073 .35048 L .12915 .33237 L p F P
0 g
s
.921 .891 .784 r
.12915 .33237 m .17145 .33303 L .1559 .36632 L p F P
0 g
s
.457 .883 .903 r
.26396 .2749 m .20814 .28486 L .22515 .27571 L p F P
0 g
s
.457 .883 .903 r
.22515 .27571 m .28737 .26257 L .26396 .2749 L p F P
0 g
s
.869 .94 .863 r
.17145 .33303 m .12915 .33237 L .13885 .31705 L p F P
0 g
s
.869 .94 .863 r
.13885 .31705 m .18953 .3048 L .17145 .33303 L p F P
0 g
s
.988 .792 .551 r
.11454 .36929 m .14459 .40095 L .13879 .43311 L p F P
0 g
s
.958 .846 .689 r
.14459 .40095 m .11454 .36929 L .12073 .35048 L p F P
0 g
s
.953 .614 .222 r
.4974 .40045 m .4685 .35159 L .47279 .38611 L p F P
0 g
s
.953 .614 .222 r
.47279 .38611 m .50077 .42605 L .4974 .40045 L p F P
0 g
s
.712 .208 0 r
.45521 .33102 m .41489 .29191 L .42956 .31497 L p F P
0 g
s
.712 .208 0 r
.42956 .31497 m .4685 .35159 L .45521 .33102 L p F P
0 g
s
.822 .344 0 r
.22461 .56659 m .18201 .52948 L .17248 .50656 L p F P
0 g
s
.777 .346 0 r
.13925 .45912 m .17248 .50656 L .18201 .52948 L p F P
0 g
s
.968 .652 .353 r
.17248 .50656 m .13925 .45912 L .13879 .43311 L p F P
0 g
s
.706 .965 .939 r
.37604 .58695 m .42975 .57282 L .45018 .55501 L p F P
0 g
s
.255 .761 .738 r
.42975 .57282 m .37604 .58695 L .35139 .59515 L p F P
0 g
s
.171 0 0 r
.34318 .26582 m .28737 .26257 L .30612 .26641 L p F P
0 g
s
.171 0 0 r
.30612 .26641 m .36524 .27021 L .34318 .26582 L p F P
0 g
s
.36 .811 .943 r
.29561 .59502 m .35139 .59515 L .37604 .58695 L p F P
0 g
s
.754 .98 .915 r
.18953 .3048 m .13885 .31705 L .14869 .30632 L p F P
0 g
s
.754 .98 .915 r
.14869 .30632 m .20814 .28486 L .18953 .3048 L p F P
0 g
s
.312 0 0 r
.29561 .59502 m .24482 .57582 L .22461 .56659 L p F P
0 g
s
0 .274 .75 r
.18201 .52948 m .22461 .56659 L .24482 .57582 L p F P
0 g
s
.974 .678 .291 r
.11131 .38663 m .13879 .43311 L .13925 .45912 L p F P
0 g
s
.988 .792 .551 r
.13879 .43311 m .11131 .38663 L .11454 .36929 L p F P
0 g
s
.982 .763 .532 r
.50077 .42605 m .47279 .38611 L .46723 .43049 L p F P
0 g
s
.982 .763 .532 r
.46723 .43049 m .49687 .45862 L .50077 .42605 L p F P
0 g
s
.727 .209 0 r
.41489 .29191 m .36524 .27021 L .37926 .29313 L p F P
0 g
s
.727 .209 0 r
.37926 .29313 m .42956 .31497 L .41489 .29191 L p F P
0 g
s
.849 .929 .881 r
.40344 .56271 m .45018 .55501 L .46982 .52759 L p F P
0 g
s
.706 .965 .939 r
.45018 .55501 m .40344 .56271 L .37604 .58695 L p F P
0 g
s
.204 0 0 r
.28737 .26257 m .22515 .27571 L .2385 .27872 L p F P
0 g
s
.204 0 0 r
.2385 .27872 m .30612 .26641 L .28737 .26257 L p F P
0 g
s
.36 .811 .943 r
.37604 .58695 m .32312 .58558 L .29561 .59502 L p F P
0 g
s
.398 .724 .989 r
.24482 .57582 m .29561 .59502 L .32312 .58558 L p F P
0 g
s
.404 .852 .777 r
.20814 .28486 m .14869 .30632 L .15754 .30151 L p F P
0 g
s
.404 .852 .777 r
.15754 .30151 m .22515 .27571 L .20814 .28486 L p F P
0 g
s
.929 .575 .335 r
.4685 .35159 m .42956 .31497 L .43401 .35425 L p F P
0 g
s
.929 .575 .335 r
.43401 .35425 m .47279 .38611 L .4685 .35159 L p F P
0 g
s
0 .274 .75 r
.24482 .57582 m .1993 .53713 L .18201 .52948 L p F P
0 g
s
.777 .346 0 r
.18201 .52948 m .14606 .47582 L .13925 .45912 L p F P
0 g
s
0 .229 .749 r
.14606 .47582 m .18201 .52948 L .1993 .53713 L p F P
0 g
s
.693 .327 0 r
.11143 .40047 m .13925 .45912 L .14606 .47582 L p F P
0 g
s
.974 .678 .291 r
.13925 .45912 m .11143 .40047 L .11131 .38663 L p F P
0 g
s
.95 .827 .687 r
.49687 .45862 m .46723 .43049 L .45235 .479 L p F P
0 g
s
.95 .827 .687 r
.45235 .479 m .4861 .494 L .49687 .45862 L p F P
0 g
s
.909 .876 .792 r
.43008 .52513 m .46982 .52759 L .4861 .494 L p F P
0 g
s
.849 .929 .881 r
.46982 .52759 m .43008 .52513 L .40344 .56271 L p F P
0 g
s
.698 .883 .966 r
.32312 .58558 m .37604 .58695 L .40344 .56271 L p F P
0 g
s
.909 .876 .792 r
.4861 .494 m .45235 .479 L .43008 .52513 L p F P
0 g
s
.651 .18 .121 r
.36524 .27021 m .30612 .26641 L .31771 .28663 L p F P
0 g
s
.651 .18 .121 r
.31771 .28663 m .37926 .29313 L .36524 .27021 L p F P
0 g
s
.971 .867 .678 r
.08615 .33458 m .12073 .35048 L .11454 .36929 L closepath p F P
0 g
s
.933 .913 .776 r
.08615 .33458 m .12915 .33237 L .12073 .35048 L closepath p F P
0 g
s
.398 .724 .989 r
.32312 .58558 m .27179 .56601 L .24482 .57582 L p F P
0 g
s
.382 .595 .929 r
.1993 .53713 m .24482 .57582 L .27179 .56601 L p F P
0 g
s
.876 .962 .852 r
.08615 .33458 m .13885 .31705 L .12915 .33237 L closepath p F P
0 g
s
.997 .81 .532 r
.08615 .33458 m .11454 .36929 L .11131 .38663 L closepath p F P
0 g
s
.207 0 0 r
.22515 .27571 m .15754 .30151 L .1643 .30327 L p F P
0 g
s
.207 0 0 r
.1643 .30327 m .2385 .27872 L .22515 .27571 L p F P
0 g
s
0 .229 .749 r
.1993 .53713 m .15859 .48097 L .14606 .47582 L p F P
0 g
s
.693 .327 0 r
.14606 .47582 m .11494 .40914 L .11143 .40047 L p F P
0 g
s
0 .194 .719 r
.11494 .40914 m .14606 .47582 L .15859 .48097 L p F P
0 g
s
.747 .99 .886 r
.08615 .33458 m .14869 .30632 L .13885 .31705 L closepath p F P
0 g
s
.963 .683 .254 r
.08615 .33458 m .11131 .38663 L .11143 .40047 L closepath p F P
0 g
s
.923 .692 .572 r
.47279 .38611 m .43401 .35425 L .42726 .40515 L p F P
0 g
s
.923 .692 .572 r
.42726 .40515 m .46723 .43049 L .47279 .38611 L p F P
0 g
s
.843 .5 .404 r
.42956 .31497 m .37926 .29313 L .3831 .33247 L p F P
0 g
s
.843 .5 .404 r
.3831 .33247 m .43401 .35425 L .42956 .31497 L p F P
0 g
s
.578 .151 .196 r
.30612 .26641 m .2385 .27872 L .24645 .29391 L p F P
0 g
s
.578 .151 .196 r
.24645 .29391 m .31771 .28663 L .30612 .26641 L p F P
0 g
s
.804 .84 .878 r
.35405 .55764 m .40344 .56271 L .43008 .52513 L p F P
0 g
s
.698 .883 .966 r
.40344 .56271 m .35405 .55764 L .32312 .58558 L p F P
0 g
s
.647 .761 .932 r
.27179 .56601 m .32312 .58558 L .35405 .55764 L p F P
0 g
s
.382 .595 .929 r
.27179 .56601 m .22255 .52794 L .1993 .53713 L p F P
0 g
s
.356 .498 .863 r
.15859 .48097 m .1993 .53713 L .22255 .52794 L p F P
0 g
s
.373 .822 .702 r
.08615 .33458 m .15754 .30151 L .14869 .30632 L closepath p F P
0 g
s
0 0 .273 r
.08615 .33458 m .11143 .40047 L .11494 .40914 L closepath p F P
0 g
s
.891 .75 .698 r
.46723 .43049 m .42726 .40515 L .40996 .46103 L p F P
0 g
s
.891 .75 .698 r
.40996 .46103 m .45235 .479 L .46723 .43049 L p F P
0 g
s
.53 .131 .23 r
.2385 .27872 m .1643 .30327 L .16814 .31149 L p F P
0 g
s
.53 .131 .23 r
.16814 .31149 m .24645 .29391 L .2385 .27872 L p F P
0 g
s
.855 .795 .791 r
.38438 .51427 m .43008 .52513 L .45235 .479 L p F P
0 g
s
.804 .84 .878 r
.43008 .52513 m .38438 .51427 L .35405 .55764 L p F P
0 g
s
.752 .427 .434 r
.37926 .29313 m .31771 .28663 L .3204 .32131 L p F P
0 g
s
.752 .427 .434 r
.3204 .32131 m .3831 .33247 L .37926 .29313 L p F P
0 g
s
.204 0 0 r
.08615 .33458 m .1643 .30327 L .15754 .30151 L closepath p F P
0 g
s
.356 .498 .863 r
.22255 .52794 m .17549 .47356 L .15859 .48097 L p F P
0 g
s
.337 .439 .818 r
.12147 .41152 m .15859 .48097 L .17549 .47356 L p F P
0 g
s
0 .194 .719 r
.15859 .48097 m .12147 .41152 L .11494 .40914 L p F P
0 g
s
0 .176 .701 r
.08615 .33458 m .11494 .40914 L .12147 .41152 L closepath p F P
0 g
s
.855 .795 .791 r
.45235 .479 m .40996 .46103 L .38438 .51427 L p F P
0 g
s
.647 .761 .932 r
.35405 .55764 m .30235 .53758 L .27179 .56601 L p F P
0 g
s
.589 .65 .878 r
.22255 .52794 m .27179 .56601 L .30235 .53758 L p F P
0 g
s
.841 .608 .586 r
.43401 .35425 m .3831 .33247 L .37585 .38362 L p F P
0 g
s
.841 .608 .586 r
.37585 .38362 m .42726 .40515 L .43401 .35425 L p F P
0 g
s
.507 .121 .243 r
.08615 .33458 m .16814 .31149 L .1643 .30327 L closepath p F P
0 g
s
.681 .372 .445 r
.31771 .28663 m .24645 .29391 L .24784 .31972 L p F P
0 g
s
.681 .372 .445 r
.24784 .31972 m .3204 .32131 L .31771 .28663 L p F P
0 g
s
.739 .737 .849 r
.30235 .53758 m .35405 .55764 L .38438 .51427 L p F P
0 g
s
.337 .439 .818 r
.17549 .47356 m .13028 .4072 L .12147 .41152 L p F P
0 g
s
.326 .411 .797 r
.08615 .33458 m .12147 .41152 L .13028 .4072 L closepath p F P
0 g
s
.589 .65 .878 r
.30235 .53758 m .249 .50242 L .22255 .52794 L p F P
0 g
s
.542 .569 .831 r
.17549 .47356 m .22255 .52794 L .249 .50242 L p F P
0 g
s
.636 .337 .447 r
.24645 .29391 m .16814 .31149 L .16852 .32528 L p F P
0 g
s
.636 .337 .447 r
.16852 .32528 m .24784 .31972 L .24645 .29391 L p F P
0 g
s
.542 .569 .831 r
.249 .50242 m .19475 .45418 L .17549 .47356 L p F P
0 g
s
.511 .518 .8 r
.13028 .4072 m .17549 .47356 L .19475 .45418 L p F P
0 g
s
.614 .32 .447 r
.08615 .33458 m .16852 .32528 L .16814 .31149 L closepath p F P
0 g
s
.511 .518 .8 r
.19475 .45418 m .1403 .39663 L .13028 .4072 L p F P
0 g
s
.495 .493 .784 r
.08615 .33458 m .13028 .4072 L .1403 .39663 L closepath p F P
0 g
s
.647 .422 .564 r
.08615 .33458 m .16536 .34297 L .16852 .32528 L closepath p F P
0 g
s
.648 .479 .641 r
.08615 .33458 m .15903 .36238 L .16536 .34297 L closepath p F P
0 g
s
.627 .509 .7 r
.08615 .33458 m .1503 .38105 L .15903 .36238 L closepath p F P
0 g
s
.581 .516 .747 r
.08615 .33458 m .1403 .39663 L .1503 .38105 L closepath p F P
0 g
s
.819 .665 .692 r
.42726 .40515 m .37585 .38362 L .35822 .43992 L p F P
0 g
s
.819 .665 .692 r
.35822 .43992 m .40996 .46103 L .42726 .40515 L p F P
0 g
s
.765 .533 .583 r
.3831 .33247 m .3204 .32131 L .31352 .36635 L p F P
0 g
s
.765 .533 .583 r
.31352 .36635 m .37585 .38362 L .3831 .33247 L p F P
0 g
s
.788 .705 .773 r
.33254 .49367 m .38438 .51427 L .40996 .46103 L p F P
0 g
s
.739 .737 .849 r
.38438 .51427 m .33254 .49367 L .30235 .53758 L p F P
0 g
s
.678 .647 .813 r
.249 .50242 m .30235 .53758 L .33254 .49367 L p F P
0 g
s
.666 .441 .568 r
.24784 .31972 m .16852 .32528 L .16536 .34297 L p F P
0 g
s
.788 .705 .773 r
.40996 .46103 m .35822 .43992 L .33254 .49367 L p F P
0 g
s
.597 .537 .758 r
.21393 .42504 m .1503 .38105 L .1403 .39663 L p F P
0 g
s
.597 .537 .758 r
.1403 .39663 m .19475 .45418 L .21393 .42504 L p F P
0 g
s
.705 .477 .576 r
.3204 .32131 m .24784 .31972 L .24232 .3531 L p F P
0 g
s
.705 .477 .576 r
.24232 .3531 m .31352 .36635 L .3204 .32131 L p F P
0 g
s
.666 .441 .568 r
.16536 .34297 m .24232 .3531 L .24784 .31972 L p F P
0 g
s
.665 .498 .648 r
.24232 .3531 m .16536 .34297 L .15903 .36238 L p F P
0 g
s
.678 .647 .813 r
.33254 .49367 m .27526 .46343 L .249 .50242 L p F P
0 g
s
.629 .58 .781 r
.19475 .45418 m .249 .50242 L .27526 .46343 L p F P
0 g
s
.629 .58 .781 r
.27526 .46343 m .21393 .42504 L .19475 .45418 L p F P
0 g
s
.643 .528 .708 r
.23052 .38981 m .15903 .36238 L .1503 .38105 L p F P
0 g
s
.643 .528 .708 r
.1503 .38105 m .21393 .42504 L .23052 .38981 L p F P
0 g
s
.665 .498 .648 r
.15903 .36238 m .23052 .38981 L .24232 .3531 L p F P
0 g
s
.752 .591 .676 r
.37585 .38362 m .31352 .36635 L .29779 .41595 L p F P
0 g
s
.752 .591 .676 r
.29779 .41595 m .35822 .43992 L .37585 .38362 L p F P
0 g
s
.725 .626 .748 r
.27526 .46343 m .33254 .49367 L .35822 .43992 L p F P
0 g
s
.7 .534 .66 r
.31352 .36635 m .24232 .3531 L .23052 .38981 L p F P
0 g
s
.676 .567 .725 r
.29779 .41595 m .23052 .38981 L .21393 .42504 L p F P
0 g
s
.676 .567 .725 r
.21393 .42504 m .27526 .46343 L .29779 .41595 L p F P
0 g
s
.725 .626 .748 r
.35822 .43992 m .29779 .41595 L .27526 .46343 L p F P
0 g
s
.7 .534 .66 r
.23052 .38981 m .29779 .41595 L .31352 .36635 L p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.636054 0.0147151 0.772109 0.360953 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0305255 1.14537 2.15973e-16 1.14537 [
[ 0 0 0 0 ]
[ 1 1.04096 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.04096 L
0 1.04096 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.706 .575 .705 r
.7858 .7734 m .72115 .73462 L .74334 .70564 L p F P
0 g
s
.706 .575 .705 r
.74334 .70564 m .79761 .75797 L .7858 .7734 L p F P
0 g
s
.669 .575 .741 r
.79761 .75797 m .74334 .70564 L .77112 .68351 L p F P
0 g
s
.728 .606 .722 r
.69449 .66011 m .74334 .70564 L .72115 .73462 L p F P
0 g
s
.686 .607 .762 r
.74334 .70564 m .69449 .66011 L .73188 .63005 L p F P
0 g
s
.686 .607 .762 r
.73188 .63005 m .77112 .68351 L .74334 .70564 L p F P
0 g
s
.731 .559 .659 r
.7784 .79074 m .70706 .76716 L .72115 .73462 L p F P
0 g
s
.731 .559 .659 r
.72115 .73462 m .7858 .7734 L .7784 .79074 L p F P
0 g
s
.756 .589 .67 r
.66452 .69924 m .72115 .73462 L .70706 .76716 L p F P
0 g
s
.728 .606 .722 r
.72115 .73462 m .66452 .69924 L .69449 .66011 L p F P
0 g
s
.697 .561 .698 r
.79761 .75797 m .85498 .81414 L .7858 .7734 L closepath p F P
0 g
s
.661 .561 .731 r
.81244 .74627 m .85498 .81414 L .79761 .75797 L closepath p F P
0 g
s
.669 .575 .741 r
.77112 .68351 m .81244 .74627 L .79761 .75797 L p F P
0 g
s
.719 .546 .654 r
.7858 .7734 m .85498 .81414 L .7784 .79074 L closepath p F P
0 g
s
.609 .542 .754 r
.82858 .73969 m .85498 .81414 L .81244 .74627 L closepath p F P
0 g
s
.614 .556 .766 r
.81244 .74627 m .77112 .68351 L .80135 .6708 L p F P
0 g
s
.614 .556 .766 r
.80135 .6708 m .82858 .73969 L .81244 .74627 L p F P
0 g
s
.729 .511 .596 r
.7784 .79074 m .85498 .81414 L .77629 .80799 L closepath p F P
0 g
s
.742 .524 .598 r
.70706 .76716 m .7784 .79074 L .77629 .80799 L p F P
0 g
s
.534 .498 .762 r
.84412 .73903 m .85498 .81414 L .82858 .73969 L closepath p F P
0 g
s
.42 .414 .746 r
.8572 .74443 m .85498 .81414 L .84412 .73903 L closepath p F P
0 g
s
.24 .257 .677 r
.86621 .75531 m .85498 .81414 L .8572 .74443 L closepath p F P
0 g
s
0 0 .496 r
.87003 .7704 m .85498 .81414 L .86621 .75531 L closepath p F P
0 g
s
0 0 .158 r
.86811 .78788 m .85498 .81414 L .87003 .7704 L closepath p F P
0 g
s
0 0 0 r
.86067 .8056 m .85498 .81414 L .86811 .78788 L closepath p F P
0 g
s
0 0 0 r
.83341 .8332 m .85498 .81414 L .8486 .82136 L closepath p F P
0 g
s
0 0 0 r
.81699 .83967 m .85498 .81414 L .83341 .8332 L closepath p F P
0 g
s
.355 0 0 r
.80137 .84 m .85498 .81414 L .81699 .83967 L closepath p F P
0 g
s
.578 .167 .226 r
.78845 .83422 m .85498 .81414 L .80137 .84 L closepath p F P
0 g
s
.681 .346 .402 r
.77976 .82309 m .85498 .81414 L .78845 .83422 L closepath p F P
0 g
s
.721 .45 .517 r
.77629 .80799 m .85498 .81414 L .77976 .82309 L closepath p F P
0 g
s
.583 .827 .451 r
.8486 .82136 m .85498 .81414 L .86067 .8056 L closepath p F P
0 g
s
.764 .66 .748 r
.6526 .62345 m .69449 .66011 L .66452 .69924 L p F P
0 g
s
.714 .663 .798 r
.69449 .66011 m .6526 .62345 L .69522 .58892 L p F P
0 g
s
.714 .663 .798 r
.69522 .58892 m .73188 .63005 L .69449 .66011 L p F P
0 g
s
.756 .589 .67 r
.70706 .76716 m .6453 .7431 L .66452 .69924 L p F P
0 g
s
.799 .642 .687 r
.61832 .66819 m .66452 .69924 L .6453 .7431 L p F P
0 g
s
.764 .66 .748 r
.66452 .69924 m .61832 .66819 L .6526 .62345 L p F P
0 g
s
.625 .589 .793 r
.77112 .68351 m .73188 .63005 L .77256 .61253 L p F P
0 g
s
.625 .589 .793 r
.77256 .61253 m .80135 .6708 L .77112 .68351 L p F P
0 g
s
.742 .524 .598 r
.77629 .80799 m .70276 .79956 L .70706 .76716 L p F P
0 g
s
.772 .552 .6 r
.6453 .7431 m .70706 .76716 L .70276 .79956 L p F P
0 g
s
.533 .511 .777 r
.82858 .73969 m .80135 .6708 L .83056 .66913 L p F P
0 g
s
.533 .511 .777 r
.83056 .66913 m .84412 .73903 L .82858 .73969 L p F P
0 g
s
.735 .46 .512 r
.70276 .79956 m .77629 .80799 L .77976 .82309 L p F P
0 g
s
.642 .647 .84 r
.73188 .63005 m .69522 .58892 L .74154 .56856 L p F P
0 g
s
.642 .647 .84 r
.74154 .56856 m .77256 .61253 L .73188 .63005 L p F P
0 g
s
.772 .552 .6 r
.70276 .79956 m .63908 .78681 L .6453 .7431 L p F P
0 g
s
.824 .602 .602 r
.59615 .71825 m .6453 .7431 L .63908 .78681 L p F P
0 g
s
.799 .642 .687 r
.6453 .7431 m .59615 .71825 L .61832 .66819 L p F P
0 g
s
.531 .542 .811 r
.80135 .6708 m .77256 .61253 L .81194 .60976 L p F P
0 g
s
.531 .542 .811 r
.81194 .60976 m .83056 .66913 L .80135 .6708 L p F P
0 g
s
.735 .46 .512 r
.77976 .82309 m .70886 .82806 L .70276 .79956 L p F P
0 g
s
.769 .481 .499 r
.63908 .78681 m .70276 .79956 L .70886 .82806 L p F P
0 g
s
.407 .421 .762 r
.84412 .73903 m .83056 .66913 L .85527 .67888 L p F P
0 g
s
.407 .421 .762 r
.85527 .67888 m .8572 .74443 L .84412 .73903 L p F P
0 g
s
.694 .346 .383 r
.70886 .82806 m .77976 .82309 L .78845 .83422 L p F P
0 g
s
.817 .746 .786 r
.61834 .59667 m .6526 .62345 L .61832 .66819 L p F P
0 g
s
.755 .753 .851 r
.6526 .62345 m .61834 .59667 L .66123 .56172 L p F P
0 g
s
.755 .753 .851 r
.66123 .56172 m .69522 .58892 L .6526 .62345 L p F P
0 g
s
.865 .726 .707 r
.58373 .64184 m .61832 .66819 L .59615 .71825 L p F P
0 g
s
.817 .746 .786 r
.61832 .66819 m .58373 .64184 L .61834 .59667 L p F P
0 g
s
.197 .244 .685 r
.8572 .74443 m .85527 .67888 L .87243 .69911 L p F P
0 g
s
.197 .244 .685 r
.87243 .69911 m .86621 .75531 L .8572 .74443 L p F P
0 g
s
.578 .142 .176 r
.72485 .84922 m .78845 .83422 L .80137 .84 L p F P
0 g
s
.694 .346 .383 r
.78845 .83422 m .72485 .84922 L .70886 .82806 L p F P
0 g
s
.662 .743 .911 r
.69522 .58892 m .66123 .56172 L .70775 .54098 L p F P
0 g
s
.662 .743 .911 r
.70775 .54098 m .74154 .56856 L .69522 .58892 L p F P
0 g
s
.523 .599 .871 r
.77256 .61253 m .74154 .56856 L .78639 .56497 L p F P
0 g
s
.523 .599 .871 r
.78639 .56497 m .81194 .60976 L .77256 .61253 L p F P
0 g
s
.824 .602 .602 r
.63908 .78681 m .58868 .76812 L .59615 .71825 L p F P
0 g
s
.903 .683 .595 r
.56122 .69227 m .59615 .71825 L .58868 .76812 L p F P
0 g
s
.865 .726 .707 r
.59615 .71825 m .56122 .69227 L .58373 .64184 L p F P
0 g
s
.769 .481 .499 r
.70886 .82806 m .64682 .82537 L .63908 .78681 L p F P
0 g
s
.829 .521 .469 r
.58868 .76812 m .63908 .78681 L .64682 .82537 L p F P
0 g
s
.373 .438 .799 r
.83056 .66913 m .81194 .60976 L .84538 .62245 L p F P
0 g
s
.373 .438 .799 r
.84538 .62245 m .85527 .67888 L .83056 .66913 L p F P
0 g
s
.724 .347 .334 r
.64682 .82537 m .70886 .82806 L .72485 .84922 L p F P
0 g
s
0 0 .464 r
.86621 .75531 m .87243 .69911 L .87974 .72756 L p F P
0 g
s
0 0 .464 r
.87974 .72756 m .87003 .7704 L .86621 .75531 L p F P
0 g
s
.307 0 0 r
.74899 .86033 m .80137 .84 L .81699 .83967 L p F P
0 g
s
.578 .142 .176 r
.80137 .84 m .74899 .86033 L .72485 .84922 L p F P
0 g
s
.878 .863 .822 r
.59153 .57977 m .61834 .59667 L .58373 .64184 L p F P
0 g
s
.795 .876 .906 r
.61834 .59667 m .59153 .57977 L .62965 .54858 L p F P
0 g
s
.795 .876 .906 r
.62965 .54858 m .66123 .56172 L .61834 .59667 L p F P
0 g
s
.941 .84 .716 r
.56069 .62002 m .58373 .64184 L .56122 .69227 L p F P
0 g
s
.878 .863 .822 r
.58373 .64184 m .56069 .62002 L .59153 .57977 L p F P
0 g
s
0 0 .047 r
.87003 .7704 m .87974 .72756 L .87613 .7608 L p F P
0 g
s
0 0 .047 r
.87613 .7608 m .86811 .78788 L .87003 .7704 L p F P
0 g
s
0 0 0 r
.77848 .85983 m .81699 .83967 L .83341 .8332 L p F P
0 g
s
.307 0 0 r
.81699 .83967 m .77848 .85983 L .74899 .86033 L p F P
0 g
s
.487 .692 .959 r
.74154 .56856 m .70775 .54098 L .7527 .53708 L p F P
0 g
s
.487 .692 .959 r
.7527 .53708 m .78639 .56497 L .74154 .56856 L p F P
0 g
s
.829 .521 .469 r
.64682 .82537 m .59707 .81215 L .58868 .76812 L p F P
0 g
s
.903 .683 .595 r
.58868 .76812 m .55343 .74243 L .56122 .69227 L p F P
0 g
s
.918 .583 .39 r
.55343 .74243 m .58868 .76812 L .59707 .81215 L p F P
0 g
s
.291 .467 .861 r
.81194 .60976 m .78639 .56497 L .82449 .57903 L p F P
0 g
s
.291 .467 .861 r
.82449 .57903 m .84538 .62245 L .81194 .60976 L p F P
0 g
s
.079 .206 .696 r
.85527 .67888 m .84538 .62245 L .86867 .64948 L p F P
0 g
s
.079 .206 .696 r
.86867 .64948 m .87243 .69911 L .85527 .67888 L p F P
0 g
s
.724 .347 .334 r
.72485 .84922 m .66796 .85413 L .64682 .82537 L p F P
0 g
s
.775 .34 .218 r
.59707 .81215 m .64682 .82537 L .66796 .85413 L p F P
0 g
s
.57 .074 .037 r
.66796 .85413 m .72485 .84922 L .74899 .86033 L p F P
0 g
s
.747 .826 .363 r
.86811 .78788 m .87613 .7608 L .86189 .79469 L p F P
0 g
s
.747 .826 .363 r
.86189 .79469 m .86067 .8056 L .86811 .78788 L p F P
0 g
s
0 0 0 r
.83341 .8332 m .80972 .84755 L .77848 .85983 L p F P
0 g
s
.528 .885 .66 r
.80972 .84755 m .83341 .8332 L .8486 .82136 L p F P
0 g
s
.657 .87 .979 r
.66123 .56172 m .62965 .54858 L .67086 .53003 L p F P
0 g
s
.657 .87 .979 r
.67086 .53003 m .70775 .54098 L .66123 .56172 L p F P
0 g
s
.988 .787 .544 r
.54056 .66487 m .56122 .69227 L .55343 .74243 L p F P
0 g
s
.941 .84 .716 r
.56122 .69227 m .54056 .66487 L .56069 .62002 L p F P
0 g
s
.725 .931 .597 r
.86067 .8056 m .86189 .79469 L .83877 .8249 L p F P
0 g
s
.725 .931 .597 r
.83877 .8249 m .8486 .82136 L .86067 .8056 L p F P
0 g
s
.528 .885 .66 r
.8486 .82136 m .83877 .8249 L .80972 .84755 L p F P
0 g
s
0 0 .345 r
.87243 .69911 m .86867 .64948 L .87864 .68793 L p F P
0 g
s
0 0 .345 r
.87864 .68793 m .87974 .72756 L .87243 .69911 L p F P
0 g
s
.156 0 0 r
.70032 .86934 m .74899 .86033 L .77848 .85983 L p F P
0 g
s
.57 .074 .037 r
.74899 .86033 m .70032 .86934 L .66796 .85413 L p F P
0 g
s
.341 .764 .975 r
.70775 .54098 m .67086 .53003 L .71051 .52647 L p F P
0 g
s
.341 .764 .975 r
.71051 .52647 m .7527 .53708 L .70775 .54098 L p F P
0 g
s
.063 .472 .888 r
.78639 .56497 m .7527 .53708 L .7908 .55096 L p F P
0 g
s
.063 .472 .888 r
.7908 .55096 m .82449 .57903 L .78639 .56497 L p F P
0 g
s
.918 .583 .39 r
.59707 .81215 m .56155 .78663 L .55343 .74243 L p F P
0 g
s
.988 .787 .544 r
.55343 .74243 m .53349 .70934 L .54056 .66487 L p F P
0 g
s
.94 .608 .174 r
.53349 .70934 m .55343 .74243 L .56155 .78663 L p F P
0 g
s
.775 .34 .218 r
.66796 .85413 m .62078 .84502 L .59707 .81215 L p F P
0 g
s
.782 .28 0 r
.56155 .78663 m .59707 .81215 L .62078 .84502 L p F P
0 g
s
0 .095 .652 r
.84538 .62245 m .82449 .57903 L .85103 .60963 L p F P
0 g
s
0 .095 .652 r
.85103 .60963 m .86867 .64948 L .84538 .62245 L p F P
0 g
s
.489 0 0 r
.62078 .84502 m .66796 .85413 L .70032 .86934 L p F P
0 g
s
.902 .969 .814 r
.57118 .57167 m .59153 .57977 L .56069 .62002 L p F P
0 g
s
.785 .979 .908 r
.59153 .57977 m .57118 .57167 L .59988 .54812 L p F P
0 g
s
.785 .979 .908 r
.59988 .54812 m .62965 .54858 L .59153 .57977 L p F P
0 g
s
.97 .933 .665 r
.5479 .60205 m .56069 .62002 L .54056 .66487 L p F P
0 g
s
.902 .969 .814 r
.56069 .62002 m .5479 .60205 L .57118 .57167 L p F P
0 g
s
.852 .735 .215 r
.87974 .72756 m .87864 .68793 L .87368 .73319 L p F P
0 g
s
.852 .735 .215 r
.87368 .73319 m .87613 .7608 L .87974 .72756 L p F P
0 g
s
.552 .924 .93 r
.62965 .54858 m .59988 .54812 L .63077 .53415 L p F P
0 g
s
.552 .924 .93 r
.63077 .53415 m .67086 .53003 L .62965 .54858 L p F P
0 g
s
.156 0 0 r
.77848 .85983 m .74021 .86872 L .70032 .86934 L p F P
0 g
s
.402 .856 .824 r
.74021 .86872 m .77848 .85983 L .80972 .84755 L p F P
0 g
s
.96 .819 .386 r
.53268 .63583 m .54056 .66487 L .53349 .70934 L p F P
0 g
s
.97 .933 .665 r
.54056 .66487 m .53268 .63583 L .5479 .60205 L p F P
0 g
s
.325 0 0 r
.7527 .53708 m .71051 .52647 L .74391 .53869 L p F P
0 g
s
.325 0 0 r
.74391 .53869 m .7908 .55096 L .7527 .53708 L p F P
0 g
s
.782 .28 0 r
.62078 .84502 m .58509 .81954 L .56155 .78663 L p F P
0 g
s
.94 .608 .174 r
.56155 .78663 m .54053 .74835 L .53349 .70934 L p F P
0 g
s
0 0 .507 r
.54053 .74835 m .56155 .78663 L .58509 .81954 L p F P
0 g
s
.943 .935 .587 r
.87613 .7608 m .87368 .73319 L .85415 .77954 L p F P
0 g
s
.943 .935 .587 r
.85415 .77954 m .86189 .79469 L .87613 .7608 L p F P
0 g
s
.729 .989 .872 r
.78274 .85197 m .80972 .84755 L .83877 .8249 L p F P
0 g
s
.402 .856 .824 r
.80972 .84755 m .78274 .85197 L .74021 .86872 L p F P
0 g
s
.668 .146 0 r
.82449 .57903 m .7908 .55096 L .81722 .58154 L p F P
0 g
s
.668 .146 0 r
.81722 .58154 m .85103 .60963 L .82449 .57903 L p F P
0 g
s
.848 .514 0 r
.86867 .64948 m .85103 .60963 L .86233 .65349 L p F P
0 g
s
.848 .514 0 r
.86233 .65349 m .87864 .68793 L .86867 .64948 L p F P
0 g
s
.489 0 0 r
.70032 .86934 m .65746 .86241 L .62078 .84502 L p F P
0 g
s
0 .364 .793 r
.58509 .81954 m .62078 .84502 L .65746 .86241 L p F P
0 g
s
.18 .694 .893 r
.65746 .86241 m .70032 .86934 L .74021 .86872 L p F P
0 g
s
0 0 0 r
.67086 .53003 m .63077 .53415 L .66031 .5315 L p F P
0 g
s
0 0 0 r
.66031 .5315 m .71051 .52647 L .67086 .53003 L p F P
0 g
s
.96 .819 .386 r
.53349 .70934 m .52732 .66918 L .53268 .63583 L p F P
0 g
s
0 0 .147 r
.52732 .66918 m .53349 .70934 L .54053 .74835 L p F P
0 g
s
.881 .993 .777 r
.86189 .79469 m .85415 .77954 L .82246 .82094 L p F P
0 g
s
.881 .993 .777 r
.82246 .82094 m .83877 .8249 L .86189 .79469 L p F P
0 g
s
.729 .989 .872 r
.83877 .8249 m .82246 .82094 L .78274 .85197 L p F P
0 g
s
.844 .991 .73 r
.55553 .57029 m .57118 .57167 L .5479 .60205 L p F P
0 g
s
.69 .978 .811 r
.57118 .57167 m .55553 .57029 L .57107 .55753 L p F P
0 g
s
.69 .978 .811 r
.57107 .55753 m .59988 .54812 L .57118 .57167 L p F P
0 g
s
.892 .926 .54 r
.54289 .58678 m .5479 .60205 L .53268 .63583 L p F P
0 g
s
.844 .991 .73 r
.5479 .60205 m .54289 .58678 L .55553 .57029 L p F P
0 g
s
.999 .793 .479 r
.87864 .68793 m .86233 .65349 L .8565 .70539 L p F P
0 g
s
.999 .793 .479 r
.8565 .70539 m .87368 .73319 L .87864 .68793 L p F P
0 g
s
.613 .89 .989 r
.70296 .86163 m .74021 .86872 L .78274 .85197 L p F P
0 g
s
.18 .694 .893 r
.74021 .86872 m .70296 .86163 L .65746 .86241 L p F P
0 g
s
.489 0 0 r
.71051 .52647 m .66031 .5315 L .68498 .5407 L p F P
0 g
s
.489 0 0 r
.68498 .5407 m .74391 .53869 L .71051 .52647 L p F P
0 g
s
.753 .273 .103 r
.7908 .55096 m .74391 .53869 L .76687 .56569 L p F P
0 g
s
.753 .273 .103 r
.76687 .56569 m .81722 .58154 L .7908 .55096 L p F P
0 g
s
0 0 .507 r
.58509 .81954 m .56123 .77719 L .54053 .74835 L p F P
0 g
s
0 .098 .638 r
.53257 .69823 m .54053 .74835 L .56123 .77719 L p F P
0 g
s
0 0 .147 r
.54053 .74835 m .53257 .69823 L .52732 .66918 L p F P
0 g
s
0 .364 .793 r
.65746 .86241 m .62172 .8368 L .58509 .81954 L p F P
0 g
s
.19 .422 .855 r
.56123 .77719 m .58509 .81954 L .62172 .8368 L p F P
0 g
s
.366 .825 .734 r
.59988 .54812 m .57107 .55753 L .5877 .54999 L p F P
0 g
s
.366 .825 .734 r
.5877 .54999 m .63077 .53415 L .59988 .54812 L p F P
0 g
s
.775 .714 .179 r
.53463 .60507 m .53268 .63583 L .52732 .66918 L p F P
0 g
s
.892 .926 .54 r
.53268 .63583 m .53463 .60507 L .54289 .58678 L p F P
0 g
s
.926 .561 .311 r
.85103 .60963 m .81722 .58154 L .82828 .62555 L p F P
0 g
s
.926 .561 .311 r
.82828 .62555 m .86233 .65349 L .85103 .60963 L p F P
0 g
s
.425 .69 .974 r
.62172 .8368 m .65746 .86241 L .70296 .86163 L p F P
0 g
s
.961 .867 .7 r
.87368 .73319 m .8565 .70539 L .83391 .75872 L p F P
0 g
s
.961 .867 .7 r
.83391 .75872 m .85415 .77954 L .87368 .73319 L p F P
0 g
s
.139 0 0 r
.63077 .53415 m .5877 .54999 L .60348 .54862 L p F P
0 g
s
.139 0 0 r
.60348 .54862 m .66031 .5315 L .63077 .53415 L p F P
0 g
s
.792 .909 .921 r
.75169 .84227 m .78274 .85197 L .82246 .82094 L p F P
0 g
s
.613 .89 .989 r
.78274 .85197 m .75169 .84227 L .70296 .86163 L p F P
0 g
s
.775 .714 .179 r
.52732 .66918 m .53174 .62303 L .53463 .60507 L p F P
0 g
s
0 0 .321 r
.53174 .62303 m .52732 .66918 L .53257 .69823 L p F P
0 g
s
.891 .896 .826 r
.85415 .77954 m .83391 .75872 L .79737 .80645 L p F P
0 g
s
.891 .896 .826 r
.79737 .80645 m .82246 .82094 L .85415 .77954 L p F P
0 g
s
.792 .909 .921 r
.82246 .82094 m .79737 .80645 L .75169 .84227 L p F P
0 g
s
.712 .299 .261 r
.74391 .53869 m .68498 .5407 L .7017 .5609 L p F P
0 g
s
.712 .299 .261 r
.7017 .5609 m .76687 .56569 L .74391 .53869 L p F P
0 g
s
.19 .422 .855 r
.62172 .8368 m .59348 .79207 L .56123 .77719 L p F P
0 g
s
.308 .405 .798 r
.54803 .71947 m .56123 .77719 L .59348 .79207 L p F P
0 g
s
0 .098 .638 r
.56123 .77719 m .54803 .71947 L .53257 .69823 L p F P
0 g
s
.837 .507 .428 r
.81722 .58154 m .76687 .56569 L .77622 .60454 L p F P
0 g
s
.837 .507 .428 r
.77622 .60454 m .82828 .62555 L .81722 .58154 L p F P
0 g
s
.923 .692 .571 r
.86233 .65349 m .82828 .62555 L .82213 .67776 L p F P
0 g
s
.923 .692 .571 r
.82213 .67776 m .8565 .70539 L .86233 .65349 L p F P
0 g
s
.425 .69 .974 r
.70296 .86163 m .66731 .83576 L .62172 .8368 L p F P
0 g
s
.49 .595 .886 r
.59348 .79207 m .62172 .8368 L .66731 .83576 L p F P
0 g
s
.648 .76 .931 r
.66731 .83576 m .70296 .86163 L .75169 .84227 L p F P
0 g
s
.52 .036 .046 r
.66031 .5315 m .60348 .54862 L .61651 .55363 L p F P
0 g
s
.52 .036 .046 r
.61651 .55363 m .68498 .5407 L .66031 .5315 L p F P
0 g
s
.073 .157 .647 r
.53459 .63853 m .53257 .69823 L .54803 .71947 L p F P
0 g
s
0 0 .321 r
.53257 .69823 m .53459 .63853 L .53174 .62303 L p F P
0 g
s
.771 .959 .647 r
.54216 .57268 m .55553 .57029 L .54289 .58678 L closepath p F P
0 g
s
.6 .929 .714 r
.54216 .57268 m .57107 .55753 L .55553 .57029 L closepath p F P
0 g
s
.802 .875 .441 r
.54216 .57268 m .54289 .58678 L .53463 .60507 L closepath p F P
0 g
s
.88 .741 .704 r
.8565 .70539 m .82213 .67776 L .79918 .73152 L p F P
0 g
s
.88 .741 .704 r
.79918 .73152 m .83391 .75872 L .8565 .70539 L p F P
0 g
s
.757 .771 .864 r
.71627 .81601 m .75169 .84227 L .79737 .80645 L p F P
0 g
s
.648 .76 .931 r
.75169 .84227 m .71627 .81601 L .66731 .83576 L p F P
0 g
s
0 0 0 r
.54216 .57268 m .5877 .54999 L .57107 .55753 L closepath p F P
0 g
s
0 0 0 r
.54216 .57268 m .53463 .60507 L .53174 .62303 L closepath p F P
0 g
s
.681 .303 .323 r
.68498 .5407 m .61651 .55363 L .62518 .5645 L p F P
0 g
s
.681 .303 .323 r
.62518 .5645 m .7017 .5609 L .68498 .5407 L p F P
0 g
s
.772 .466 .468 r
.76687 .56569 m .7017 .5609 L .70824 .58985 L p F P
0 g
s
.772 .466 .468 r
.70824 .58985 m .77622 .60454 L .76687 .56569 L p F P
0 g
s
.308 .405 .798 r
.59348 .79207 m .57204 .73016 L .54803 .71947 L p F P
0 g
s
.352 .389 .76 r
.5429 .6497 m .54803 .71947 L .57204 .73016 L p F P
0 g
s
.073 .157 .647 r
.54803 .71947 m .5429 .6497 L .53459 .63853 L p F P
0 g
s
.49 .595 .886 r
.66731 .83576 m .63361 .79075 L .59348 .79207 L p F P
0 g
s
.505 .534 .82 r
.57204 .73016 m .59348 .79207 L .63361 .79075 L p F P
0 g
s
.835 .603 .588 r
.82828 .62555 m .77622 .60454 L .77043 .65061 L p F P
0 g
s
.835 .603 .588 r
.77043 .65061 m .82213 .67776 L .82828 .62555 L p F P
0 g
s
.632 .653 .853 r
.63361 .79075 m .66731 .83576 L .71627 .81601 L p F P
0 g
s
.208 0 0 r
.54216 .57268 m .60348 .54862 L .5877 .54999 L closepath p F P
0 g
s
0 0 .376 r
.54216 .57268 m .53174 .62303 L .53459 .63853 L closepath p F P
0 g
s
.827 .763 .792 r
.83391 .75872 m .79918 .73152 L .76226 .77972 L p F P
0 g
s
.827 .763 .792 r
.76226 .77972 m .79737 .80645 L .83391 .75872 L p F P
0 g
s
.757 .771 .864 r
.79737 .80645 m .76226 .77972 L .71627 .81601 L p F P
0 g
s
.526 .069 .11 r
.54216 .57268 m .61651 .55363 L .60348 .54862 L closepath p F P
0 g
s
.128 .176 .644 r
.54216 .57268 m .53459 .63853 L .5429 .6497 L closepath p F P
0 g
s
.735 .442 .484 r
.7017 .5609 m .62518 .5645 L .6284 .57997 L p F P
0 g
s
.735 .442 .484 r
.6284 .57997 m .70824 .58985 L .7017 .5609 L p F P
0 g
s
.505 .534 .82 r
.63361 .79075 m .60183 .72876 L .57204 .73016 L p F P
0 g
s
.509 .5 .783 r
.55574 .65515 m .57204 .73016 L .60183 .72876 L p F P
0 g
s
.352 .389 .76 r
.57204 .73016 m .55574 .65515 L .5429 .6497 L p F P
0 g
s
.778 .548 .587 r
.77622 .60454 m .70824 .58985 L .70357 .62409 L p F P
0 g
s
.778 .548 .587 r
.70357 .62409 m .77043 .65061 L .77622 .60454 L p F P
0 g
s
.808 .648 .684 r
.82213 .67776 m .77043 .65061 L .74993 .69807 L p F P
0 g
s
.808 .648 .684 r
.74993 .69807 m .79918 .73152 L .82213 .67776 L p F P
0 g
s
.632 .653 .853 r
.71627 .81601 m .67672 .77297 L .63361 .79075 L p F P
0 g
s
.615 .589 .801 r
.60183 .72876 m .63361 .79075 L .67672 .77297 L p F P
0 g
s
.714 .671 .806 r
.67672 .77297 m .71627 .81601 L .76226 .77972 L p F P
0 g
s
.667 .303 .345 r
.54216 .57268 m .62518 .5645 L .61651 .55363 L closepath p F P
0 g
s
.367 .381 .743 r
.54216 .57268 m .5429 .6497 L .55574 .65515 L closepath p F P
0 g
s
.769 .668 .752 r
.79918 .73152 m .74993 .69807 L .71727 .74071 L p F P
0 g
s
.769 .668 .752 r
.71727 .74071 m .76226 .77972 L .79918 .73152 L p F P
0 g
s
.714 .671 .806 r
.76226 .77972 m .71727 .74071 L .67672 .77297 L p F P
0 g
s
.719 .432 .489 r
.54216 .57268 m .6284 .57997 L .62518 .5645 L closepath p F P
0 g
s
.509 .5 .783 r
.60183 .72876 m .57159 .65413 L .55574 .65515 L p F P
0 g
s
.509 .485 .766 r
.54216 .57268 m .55574 .65515 L .57159 .65413 L closepath p F P
0 g
s
.745 .517 .585 r
.70824 .58985 m .6284 .57997 L .6257 .59819 L p F P
0 g
s
.745 .517 .585 r
.6257 .59819 m .70357 .62409 L .70824 .58985 L p F P
0 g
s
.615 .589 .801 r
.67672 .77297 m .63378 .71521 L .60183 .72876 L p F P
0 g
s
.603 .553 .771 r
.57159 .65413 m .60183 .72876 L .63378 .71521 L p F P
0 g
s
.761 .59 .666 r
.77043 .65061 m .70357 .62409 L .68814 .65933 L p F P
0 g
s
.761 .59 .666 r
.68814 .65933 m .74993 .69807 L .77043 .65061 L p F P
0 g
s
.683 .609 .767 r
.63378 .71521 m .67672 .77297 L .71727 .74071 L p F P
0 g
s
.73 .503 .583 r
.54216 .57268 m .6257 .59819 L .6284 .57997 L closepath p F P
0 g
s
.603 .553 .771 r
.63378 .71521 m .58852 .64672 L .57159 .65413 L p F P
0 g
s
.597 .537 .758 r
.54216 .57268 m .57159 .65413 L .58852 .64672 L closepath p F P
0 g
s
.706 .575 .705 r
.46717 .52861 m .39668 .48634 L .42091 .45473 L p F P
0 g
s
.706 .575 .705 r
.42091 .45473 m .48006 .51179 L .46717 .52861 L p F P
0 g
s
.665 .575 .744 r
.48006 .51179 m .42091 .45473 L .45038 .42992 L p F P
0 g
s
.729 .609 .723 r
.3668 .40442 m .42091 .45473 L .39668 .48634 L p F P
0 g
s
.684 .609 .766 r
.42091 .45473 m .3668 .40442 L .40646 .37071 L p F P
0 g
s
.684 .609 .766 r
.40646 .37071 m .45038 .42992 L .42091 .45473 L p F P
0 g
s
.733 .557 .654 r
.45863 .54719 m .38043 .52118 L .39668 .48634 L p F P
0 g
s
.733 .557 .654 r
.39668 .48634 m .46717 .52861 L .45863 .54719 L p F P
0 g
s
.76 .59 .667 r
.33408 .44711 m .39668 .48634 L .38043 .52118 L p F P
0 g
s
.729 .609 .723 r
.39668 .48634 m .33408 .44711 L .3668 .40442 L p F P
0 g
s
.695 .56 .697 r
.48006 .51179 m .54216 .57268 L .46717 .52861 L closepath p F P
0 g
s
.656 .559 .733 r
.49581 .49868 m .54216 .57268 L .48006 .51179 L closepath p F P
0 g
s
.665 .575 .744 r
.45038 .42992 m .49581 .49868 L .48006 .51179 L p F P
0 g
s
.72 .542 .649 r
.46717 .52861 m .54216 .57268 L .45863 .54719 L closepath p F P
0 g
s
.733 .557 .654 r
.70357 .62409 m .6257 .59819 L .61738 .6169 L p F P
0 g
s
.733 .557 .654 r
.61738 .6169 m .68814 .65933 L .70357 .62409 L p F P
0 g
s
.683 .609 .767 r
.71727 .74071 m .66384 .69106 L .63378 .71521 L p F P
0 g
s
.665 .575 .744 r
.58852 .64672 m .63378 .71521 L .66384 .69106 L p F P
0 g
s
.729 .609 .723 r
.74993 .69807 m .68814 .65933 L .66384 .69106 L p F P
0 g
s
.729 .609 .723 r
.66384 .69106 m .71727 .74071 L .74993 .69807 L p F P
0 g
s
.597 .537 .758 r
.51258 .49083 m .54216 .57268 L .49581 .49868 L closepath p F P
0 g
s
.603 .553 .771 r
.49581 .49868 m .45038 .42992 L .48179 .41479 L p F P
0 g
s
.603 .553 .771 r
.48179 .41479 m .51258 .49083 L .49581 .49868 L p F P
0 g
s
.73 .503 .583 r
.45863 .54719 m .54216 .57268 L .45548 .56535 L closepath p F P
0 g
s
.745 .517 .585 r
.38043 .52118 m .45863 .54719 L .45548 .56535 L p F P
0 g
s
.72 .542 .649 r
.54216 .57268 m .61738 .6169 L .6257 .59819 L closepath p F P
0 g
s
.695 .56 .697 r
.54216 .57268 m .60445 .63378 L .61738 .6169 L closepath p F P
0 g
s
.656 .559 .733 r
.54216 .57268 m .58852 .64672 L .60445 .63378 L closepath p F P
0 g
s
0 0 0 r
.54999 .53894 m .54216 .57268 L .55295 .52051 L closepath p F P
0 g
s
.367 .381 .743 r
.5414 .49409 m .54216 .57268 L .52841 .48922 L closepath p F P
0 g
s
.128 .176 .644 r
.54994 .50494 m .54216 .57268 L .5414 .49409 L closepath p F P
0 g
s
0 0 .376 r
.55295 .52051 m .54216 .57268 L .54994 .50494 L closepath p F P
0 g
s
.802 .875 .441 r
.54139 .55795 m .54216 .57268 L .54999 .53894 L closepath p F P
0 g
s
.667 .303 .345 r
.45811 .58096 m .54216 .57268 L .46627 .59213 L closepath p F P
0 g
s
.719 .432 .489 r
.45548 .56535 m .54216 .57268 L .45811 .58096 L closepath p F P
0 g
s
.509 .485 .766 r
.52841 .48922 m .54216 .57268 L .51258 .49083 L closepath p F P
0 g
s
.771 .959 .647 r
.52819 .57518 m .54216 .57268 L .54139 .55795 L closepath p F P
0 g
s
0 0 0 r
.49496 .5962 m .54216 .57268 L .51204 .58847 L closepath p F P
0 g
s
.208 0 0 r
.47906 .59744 m .54216 .57268 L .49496 .5962 L closepath p F P
0 g
s
.526 .069 .11 r
.46627 .59213 m .54216 .57268 L .47906 .59744 L closepath p F P
0 g
s
.6 .929 .714 r
.51204 .58847 m .54216 .57268 L .52819 .57518 L closepath p F P
0 g
s
.665 .575 .744 r
.66384 .69106 m .60445 .63378 L .58852 .64672 L p F P
0 g
s
.766 .664 .75 r
.31906 .36283 m .3668 .40442 L .33408 .44711 L p F P
0 g
s
.714 .667 .802 r
.3668 .40442 m .31906 .36283 L .36426 .32407 L p F P
0 g
s
.714 .667 .802 r
.36426 .32407 m .40646 .37071 L .3668 .40442 L p F P
0 g
s
.76 .59 .667 r
.38043 .52118 m .31188 .49407 L .33408 .44711 L p F P
0 g
s
.804 .645 .685 r
.28161 .41167 m .33408 .44711 L .31188 .49407 L p F P
0 g
s
.766 .664 .75 r
.33408 .44711 m .28161 .41167 L .31906 .36283 L p F P
0 g
s
.617 .589 .8 r
.45038 .42992 m .40646 .37071 L .44869 .34981 L p F P
0 g
s
.617 .589 .8 r
.44869 .34981 m .48179 .41479 L .45038 .42992 L p F P
0 g
s
.745 .517 .585 r
.45548 .56535 m .37408 .55531 L .38043 .52118 L p F P
0 g
s
.777 .548 .59 r
.31188 .49407 m .38043 .52118 L .37408 .55531 L p F P
0 g
s
.706 .575 .705 r
.68814 .65933 m .61738 .6169 L .60445 .63378 L p F P
0 g
s
.706 .575 .705 r
.60445 .63378 m .66384 .69106 L .68814 .65933 L p F P
0 g
s
.509 .501 .782 r
.51258 .49083 m .48179 .41479 L .51152 .41122 L p F P
0 g
s
.509 .501 .782 r
.51152 .41122 m .52841 .48922 L .51258 .49083 L p F P
0 g
s
.735 .443 .485 r
.37408 .55531 m .45548 .56535 L .45811 .58096 L p F P
0 g
s
.637 .65 .846 r
.40646 .37071 m .36426 .32407 L .41232 .29976 L p F P
0 g
s
.637 .65 .846 r
.41232 .29976 m .44869 .34981 L .40646 .37071 L p F P
0 g
s
.777 .548 .59 r
.37408 .55531 m .30281 .54011 L .31188 .49407 L p F P
0 g
s
.829 .602 .595 r
.25599 .46528 m .31188 .49407 L .30281 .54011 L p F P
0 g
s
.804 .645 .685 r
.31188 .49407 m .25599 .46528 L .28161 .41167 L p F P
0 g
s
.51 .535 .818 r
.48179 .41479 m .44869 .34981 L .48875 .34437 L p F P
0 g
s
.51 .535 .818 r
.48875 .34437 m .51152 .41122 L .48179 .41479 L p F P
0 g
s
.735 .443 .485 r
.45811 .58096 m .3785 .58477 L .37408 .55531 L p F P
0 g
s
.771 .468 .474 r
.30281 .54011 m .37408 .55531 L .3785 .58477 L p F P
0 g
s
.354 .39 .76 r
.52841 .48922 m .51152 .41122 L .53605 .41986 L p F P
0 g
s
.354 .39 .76 r
.53605 .41986 m .5414 .49409 L .52841 .48922 L p F P
0 g
s
.682 .304 .325 r
.3785 .58477 m .45811 .58096 L .46627 .59213 L p F P
0 g
s
.817 .746 .786 r
.27818 .33089 m .31906 .36283 L .28161 .41167 L p F P
0 g
s
.755 .753 .851 r
.31906 .36283 m .27818 .33089 L .32368 .29159 L p F P
0 g
s
.755 .753 .851 r
.32368 .29159 m .36426 .32407 L .31906 .36283 L p F P
0 g
s
.865 .726 .707 r
.24034 .38023 m .28161 .41167 L .25599 .46528 L p F P
0 g
s
.817 .746 .786 r
.28161 .41167 m .24034 .38023 L .27818 .33089 L p F P
0 g
s
.077 .16 .649 r
.5414 .49409 m .53605 .41986 L .55229 .43995 L p F P
0 g
s
.077 .16 .649 r
.55229 .43995 m .54994 .50494 L .5414 .49409 L p F P
0 g
s
.522 .039 .05 r
.39339 .606 m .46627 .59213 L .47906 .59744 L p F P
0 g
s
.682 .304 .325 r
.46627 .59213 m .39339 .606 L .3785 .58477 L p F P
0 g
s
.662 .743 .911 r
.36426 .32407 m .32368 .29159 L .37192 .26678 L p F P
0 g
s
.662 .743 .911 r
.37192 .26678 m .41232 .29976 L .36426 .32407 L p F P
0 g
s
.507 .597 .878 r
.44869 .34981 m .41232 .29976 L .4579 .29299 L p F P
0 g
s
.507 .597 .878 r
.4579 .29299 m .48875 .34437 L .44869 .34981 L p F P
0 g
s
.829 .602 .595 r
.30281 .54011 m .24515 .5178 L .25599 .46528 L p F P
0 g
s
.903 .683 .595 r
.21428 .43426 m .25599 .46528 L .24515 .5178 L p F P
0 g
s
.865 .726 .707 r
.25599 .46528 m .21428 .43426 L .24034 .38023 L p F P
0 g
s
.771 .468 .474 r
.3785 .58477 m .30815 .57997 L .30281 .54011 L p F P
0 g
s
.833 .514 .449 r
.24515 .5178 m .30281 .54011 L .30815 .57997 L p F P
0 g
s
.32 .411 .799 r
.51152 .41122 m .48875 .34437 L .52189 .35542 L p F P
0 g
s
.32 .411 .799 r
.52189 .35542 m .53605 .41986 L .51152 .41122 L p F P
0 g
s
.715 .308 .275 r
.30815 .57997 m .3785 .58477 L .39339 .606 L p F P
0 g
s
0 0 .327 r
.54994 .50494 m .55229 .43995 L .55806 .46927 L p F P
0 g
s
0 0 .327 r
.55806 .46927 m .55295 .52051 L .54994 .50494 L p F P
0 g
s
.145 0 0 r
.41719 .61625 m .47906 .59744 L .49496 .5962 L p F P
0 g
s
.522 .039 .05 r
.47906 .59744 m .41719 .61625 L .39339 .606 L p F P
0 g
s
.871 .848 .818 r
.24386 .30849 m .27818 .33089 L .24034 .38023 L p F P
0 g
s
.795 .86 .898 r
.27818 .33089 m .24386 .30849 L .28431 .27336 L p F P
0 g
s
.795 .86 .898 r
.28431 .27336 m .32368 .29159 L .27818 .33089 L p F P
0 g
s
.931 .827 .72 r
.2101 .35252 m .24034 .38023 L .21428 .43426 L p F P
0 g
s
.871 .848 .818 r
.24034 .38023 m .2101 .35252 L .24386 .30849 L p F P
0 g
s
.77 .709 .172 r
.55295 .52051 m .55806 .46927 L .55242 .50432 L p F P
0 g
s
.77 .709 .172 r
.55242 .50432 m .54999 .53894 L .55295 .52051 L p F P
0 g
s
.145 0 0 r
.49496 .5962 m .44716 .61399 L .41719 .61625 L p F P
0 g
s
.359 .821 .729 r
.44716 .61399 m .49496 .5962 L .51204 .58847 L p F P
0 g
s
.487 .692 .959 r
.41232 .29976 m .37192 .26678 L .41755 .25958 L p F P
0 g
s
.487 .692 .959 r
.41755 .25958 m .4579 .29299 L .41232 .29976 L p F P
0 g
s
.833 .514 .449 r
.30815 .57997 m .25067 .5633 L .24515 .5178 L p F P
0 g
s
.918 .583 .39 r
.203 .48708 m .24515 .5178 L .25067 .5633 L p F P
0 g
s
.903 .683 .595 r
.24515 .5178 m .203 .48708 L .21428 .43426 L p F P
0 g
s
.243 .446 .86 r
.48875 .34437 m .4579 .29299 L .49561 .30506 L p F P
0 g
s
.243 .446 .86 r
.49561 .30506 m .52189 .35542 L .48875 .34437 L p F P
0 g
s
0 .118 .651 r
.53605 .41986 m .52189 .35542 L .54392 .38216 L p F P
0 g
s
0 .118 .651 r
.54392 .38216 m .55229 .43995 L .53605 .41986 L p F P
0 g
s
.715 .308 .275 r
.39339 .606 m .32767 .60882 L .30815 .57997 L p F P
0 g
s
.766 .309 .164 r
.25067 .5633 m .30815 .57997 L .32767 .60882 L p F P
0 g
s
.505 0 0 r
.32767 .60882 m .39339 .606 L .41719 .61625 L p F P
0 g
s
.889 .924 .536 r
.54999 .53894 m .55242 .50432 L .53591 .54072 L p F P
0 g
s
.889 .924 .536 r
.53591 .54072 m .54139 .55795 L .54999 .53894 L p F P
0 g
s
.686 .977 .808 r
.47965 .59928 m .51204 .58847 L .52819 .57518 L p F P
0 g
s
.359 .821 .729 r
.51204 .58847 m .47965 .59928 L .44716 .61399 L p F P
0 g
s
.672 .857 .97 r
.32368 .29159 m .28431 .27336 L .32703 .25113 L p F P
0 g
s
.672 .857 .97 r
.32703 .25113 m .37192 .26678 L .32368 .29159 L p F P
0 g
s
.979 .781 .568 r
.18674 .4006 m .21428 .43426 L .203 .48708 L p F P
0 g
s
.931 .827 .72 r
.21428 .43426 m .18674 .4006 L .2101 .35252 L p F P
0 g
s
.841 .99 .727 r
.54139 .55795 m .53591 .54072 L .51057 .57379 L p F P
0 g
s
.841 .99 .727 r
.51057 .57379 m .52819 .57518 L .54139 .55795 L p F P
0 g
s
.686 .977 .808 r
.52819 .57518 m .51057 .57379 L .47965 .59928 L p F P
0 g
s
0 0 .182 r
.55229 .43995 m .54392 .38216 L .55173 .42173 L p F P
0 g
s
0 0 .182 r
.55173 .42173 m .55806 .46927 L .55229 .43995 L p F P
0 g
s
0 0 0 r
.35945 .62284 m .41719 .61625 L .44716 .61399 L p F P
0 g
s
.505 0 0 r
.41719 .61625 m .35945 .62284 L .32767 .60882 L p F P
0 g
s
.403 .781 .992 r
.37192 .26678 m .32703 .25113 L .36722 .24457 L p F P
0 g
s
.403 .781 .992 r
.36722 .24457 m .41755 .25958 L .37192 .26678 L p F P
0 g
s
.063 .472 .888 r
.4579 .29299 m .41755 .25958 L .45517 .27137 L p F P
0 g
s
.063 .472 .888 r
.45517 .27137 m .49561 .30506 L .4579 .29299 L p F P
0 g
s
.918 .583 .39 r
.25067 .5633 m .20812 .53273 L .203 .48708 L p F P
0 g
s
.961 .637 .249 r
.17649 .44744 m .203 .48708 L .20812 .53273 L p F P
0 g
s
.979 .781 .568 r
.203 .48708 m .17649 .44744 L .18674 .4006 L p F P
0 g
s
.766 .309 .164 r
.32767 .60882 m .2724 .59625 L .25067 .5633 L p F P
0 g
s
.782 .28 0 r
.20812 .53273 m .25067 .5633 L .2724 .59625 L p F P
0 g
s
0 .017 .587 r
.52189 .35542 m .49561 .30506 L .52064 .33521 L p F P
0 g
s
0 .017 .587 r
.52064 .33521 m .54392 .38216 L .52189 .35542 L p F P
0 g
s
.412 0 0 r
.2724 .59625 m .32767 .60882 L .35945 .62284 L p F P
0 g
s
.902 .941 .825 r
.21505 .29453 m .24386 .30849 L .2101 .35252 L p F P
0 g
s
.806 .954 .914 r
.24386 .30849 m .21505 .29453 L .24553 .26796 L p F P
0 g
s
.806 .954 .914 r
.24553 .26796 m .28431 .27336 L .24386 .30849 L p F P
0 g
s
.968 .914 .701 r
.18952 .32782 m .2101 .35252 L .18674 .4006 L p F P
0 g
s
.902 .941 .825 r
.2101 .35252 m .18952 .32782 L .21505 .29453 L p F P
0 g
s
.948 .81 .362 r
.55806 .46927 m .55173 .42173 L .54395 .46946 L p F P
0 g
s
.948 .81 .362 r
.54395 .46946 m .55242 .50432 L .55806 .46927 L p F P
0 g
s
.63 .934 .966 r
.28431 .27336 m .24553 .26796 L .27754 .25116 L p F P
0 g
s
.63 .934 .966 r
.27754 .25116 m .32703 .25113 L .28431 .27336 L p F P
0 g
s
0 0 0 r
.44716 .61399 m .39993 .61982 L .35945 .62284 L p F P
0 g
s
.532 .918 .919 r
.39993 .61982 m .44716 .61399 L .47965 .59928 L p F P
0 g
s
.993 .842 .485 r
.17181 .36407 m .18674 .4006 L .17649 .44744 L p F P
0 g
s
.968 .914 .701 r
.18674 .4006 m .17181 .36407 L .18952 .32782 L p F P
0 g
s
.221 0 0 r
.41755 .25958 m .36722 .24457 L .4001 .25488 L p F P
0 g
s
.221 0 0 r
.4001 .25488 m .45517 .27137 L .41755 .25958 L p F P
0 g
s
.782 .28 0 r
.2724 .59625 m .22955 .56565 L .20812 .53273 L p F P
0 g
s
.961 .637 .249 r
.20812 .53273 m .18079 .48768 L .17649 .44744 L p F P
0 g
s
0 0 .408 r
.18079 .48768 m .20812 .53273 L .22955 .56565 L p F P
0 g
s
.968 .935 .655 r
.55242 .50432 m .54395 .46946 L .52125 .51929 L p F P
0 g
s
.968 .935 .655 r
.52125 .51929 m .53591 .54072 L .55242 .50432 L p F P
0 g
s
.779 .983 .905 r
.44416 .59968 m .47965 .59928 L .51057 .57379 L p F P
0 g
s
.532 .918 .919 r
.47965 .59928 m .44416 .59968 L .39993 .61982 L p F P
0 g
s
.668 .146 0 r
.49561 .30506 m .45517 .27137 L .47996 .30142 L p F P
0 g
s
.668 .146 0 r
.47996 .30142 m .52064 .33521 L .49561 .30506 L p F P
0 g
s
.905 .569 .091 r
.54392 .38216 m .52064 .33521 L .52939 .38031 L p F P
0 g
s
.905 .569 .091 r
.52939 .38031 m .55173 .42173 L .54392 .38216 L p F P
0 g
s
.412 0 0 r
.35945 .62284 m .3083 .61223 L .2724 .59625 L p F P
0 g
s
0 .364 .793 r
.22955 .56565 m .2724 .59625 L .3083 .61223 L p F P
0 g
s
.269 .737 .944 r
.3083 .61223 m .35945 .62284 L .39993 .61982 L p F P
0 g
s
.228 .745 .848 r
.32703 .25113 m .27754 .25116 L .30742 .24622 L p F P
0 g
s
.228 .745 .848 r
.30742 .24622 m .36722 .24457 L .32703 .25113 L p F P
0 g
s
.831 .584 .033 r
.16401 .3992 m .17649 .44744 L .18079 .48768 L p F P
0 g
s
.993 .842 .485 r
.17649 .44744 m .16401 .3992 L .17181 .36407 L p F P
0 g
s
.9 .974 .81 r
.53591 .54072 m .52125 .51929 L .48646 .56469 L p F P
0 g
s
.9 .974 .81 r
.48646 .56469 m .51057 .57379 L .53591 .54072 L p F P
0 g
s
.779 .983 .905 r
.51057 .57379 m .48646 .56469 L .44416 .59968 L p F P
0 g
s
.891 .987 .794 r
.19003 .28693 m .21505 .29453 L .18952 .32782 L p F P
0 g
s
.774 .993 .879 r
.21505 .29453 m .19003 .28693 L .20655 .27248 L p F P
0 g
s
.774 .993 .879 r
.20655 .27248 m .24553 .26796 L .21505 .29453 L p F P
0 g
s
.951 .948 .645 r
.17615 .30503 m .18952 .32782 L .17181 .36407 L p F P
0 g
s
.891 .987 .794 r
.18952 .32782 m .17615 .30503 L .19003 .28693 L p F P
0 g
s
.995 .791 .516 r
.55173 .42173 m .52939 .38031 L .52022 .43504 L p F P
0 g
s
.995 .791 .516 r
.52022 .43504 m .54395 .46946 L .55173 .42173 L p F P
0 g
s
.639 .881 .986 r
.35439 .60863 m .39993 .61982 L .44416 .59968 L p F P
0 g
s
.269 .737 .944 r
.39993 .61982 m .35439 .60863 L .3083 .61223 L p F P
0 g
s
.382 0 0 r
.36722 .24457 m .30742 .24622 L .33161 .25398 L p F P
0 g
s
.382 0 0 r
.33161 .25398 m .4001 .25488 L .36722 .24457 L p F P
0 g
s
.732 .228 .028 r
.45517 .27137 m .4001 .25488 L .42149 .28138 L p F P
0 g
s
.732 .228 .028 r
.42149 .28138 m .47996 .30142 L .45517 .27137 L p F P
0 g
s
0 0 .408 r
.22955 .56565 m .19954 .51645 L .18079 .48768 L p F P
0 g
s
.831 .584 .033 r
.18079 .48768 m .16715 .42913 L .16401 .3992 L p F P
0 g
s
0 0 .554 r
.16715 .42913 m .18079 .48768 L .19954 .51645 L p F P
0 g
s
0 .364 .793 r
.3083 .61223 m .26531 .58143 L .22955 .56565 L p F P
0 g
s
.123 .39 .844 r
.19954 .51645 m .22955 .56565 L .26531 .58143 L p F P
0 g
s
.539 .926 .88 r
.24553 .26796 m .20655 .27248 L .22378 .2634 L p F P
0 g
s
.539 .926 .88 r
.22378 .2634 m .27754 .25116 L .24553 .26796 L p F P
0 g
s
.921 .827 .368 r
.16651 .32468 m .17181 .36407 L .16401 .3992 L p F P
0 g
s
.951 .948 .645 r
.17181 .36407 m .16651 .32468 L .17615 .30503 L p F P
0 g
s
.926 .561 .311 r
.52064 .33521 m .47996 .30142 L .48835 .34664 L p F P
0 g
s
.926 .561 .311 r
.48835 .34664 m .52939 .38031 L .52064 .33521 L p F P
0 g
s
.425 .69 .974 r
.26531 .58143 m .3083 .61223 L .35439 .60863 L p F P
0 g
s
.951 .853 .709 r
.54395 .46946 m .52022 .43504 L .4939 .49242 L p F P
0 g
s
.951 .853 .709 r
.4939 .49242 m .52125 .51929 L .54395 .46946 L p F P
0 g
s
0 0 0 r
.27754 .25116 m .22378 .2634 L .23971 .26078 L p F P
0 g
s
0 0 0 r
.23971 .26078 m .30742 .24622 L .27754 .25116 L p F P
0 g
s
.795 .891 .914 r
.40506 .5853 m .44416 .59968 L .48646 .56469 L p F P
0 g
s
.639 .881 .986 r
.44416 .59968 m .40506 .5853 L .35439 .60863 L p F P
0 g
s
.921 .827 .368 r
.16401 .3992 m .16226 .3436 L .16651 .32468 L p F P
0 g
s
0 0 .126 r
.16226 .3436 m .16401 .3992 L .16715 .42913 L p F P
0 g
s
.884 .878 .824 r
.52125 .51929 m .4939 .49242 L .45374 .54484 L p F P
0 g
s
.884 .878 .824 r
.45374 .54484 m .48646 .56469 L .52125 .51929 L p F P
0 g
s
.795 .891 .914 r
.48646 .56469 m .45374 .54484 L .40506 .5853 L p F P
0 g
s
.693 .244 .179 r
.4001 .25488 m .33161 .25398 L .34704 .27379 L p F P
0 g
s
.693 .244 .179 r
.34704 .27379 m .42149 .28138 L .4001 .25488 L p F P
0 g
s
.123 .39 .844 r
.26531 .58143 m .23094 .52991 L .19954 .51645 L p F P
0 g
s
.233 .365 .793 r
.18111 .45023 m .19954 .51645 L .23094 .52991 L p F P
0 g
s
0 0 .554 r
.19954 .51645 m .18111 .45023 L .16715 .42913 L p F P
0 g
s
.842 .497 .402 r
.47996 .30142 m .42149 .28138 L .42836 .32127 L p F P
0 g
s
.842 .497 .402 r
.42836 .32127 m .48835 .34664 L .47996 .30142 L p F P
0 g
s
.923 .692 .571 r
.52939 .38031 m .48835 .34664 L .47873 .40169 L p F P
0 g
s
.923 .692 .571 r
.47873 .40169 m .52022 .43504 L .52939 .38031 L p F P
0 g
s
.425 .69 .974 r
.35439 .60863 m .31143 .57745 L .26531 .58143 L p F P
0 g
s
.469 .592 .893 r
.23094 .52991 m .26531 .58143 L .31143 .57745 L p F P
0 g
s
.648 .76 .931 r
.31143 .57745 m .35439 .60863 L .40506 .5853 L p F P
0 g
s
.428 0 0 r
.30742 .24622 m .23971 .26078 L .25242 .26501 L p F P
0 g
s
.428 0 0 r
.25242 .26501 m .33161 .25398 L .30742 .24622 L p F P
0 g
s
0 .036 .58 r
.16396 .35954 m .16715 .42913 L .18111 .45023 L p F P
0 g
s
0 0 .126 r
.16715 .42913 m .16396 .35954 L .16226 .3436 L p F P
0 g
s
.866 .994 .759 r
.16651 .28274 m .19003 .28693 L .17615 .30503 L closepath p F P
0 g
s
.737 .992 .838 r
.16651 .28274 m .20655 .27248 L .19003 .28693 L closepath p F P
0 g
s
.918 .946 .597 r
.16651 .28274 m .17615 .30503 L .16651 .32468 L closepath p F P
0 g
s
.88 .741 .704 r
.52022 .43504 m .47873 .40169 L .45194 .45956 L p F P
0 g
s
.88 .741 .704 r
.45194 .45956 m .4939 .49242 L .52022 .43504 L p F P
0 g
s
.757 .771 .864 r
.3623 .5536 m .40506 .5853 L .45374 .54484 L p F P
0 g
s
.648 .76 .931 r
.40506 .5853 m .3623 .5536 L .31143 .57745 L p F P
0 g
s
.472 .891 .803 r
.16651 .28274 m .22378 .2634 L .20655 .27248 L closepath p F P
0 g
s
.85 .79 .293 r
.16651 .28274 m .16651 .32468 L .16226 .3436 L closepath p F P
0 g
s
.661 .244 .243 r
.33161 .25398 m .25242 .26501 L .26034 .27568 L p F P
0 g
s
.661 .244 .243 r
.26034 .27568 m .34704 .27379 L .33161 .25398 L p F P
0 g
s
.774 .449 .436 r
.42149 .28138 m .34704 .27379 L .35162 .30351 L p F P
0 g
s
.774 .449 .436 r
.35162 .30351 m .42836 .32127 L .42149 .28138 L p F P
0 g
s
.233 .365 .793 r
.23094 .52991 m .20445 .45975 L .18111 .45023 L p F P
0 g
s
.278 .345 .753 r
.17145 .37059 m .18111 .45023 L .20445 .45975 L p F P
0 g
s
0 .036 .58 r
.18111 .45023 m .17145 .37059 L .16396 .35954 L p F P
0 g
s
.469 .592 .893 r
.31143 .57745 m .27149 .52588 L .23094 .52991 L p F P
0 g
s
.477 .525 .828 r
.20445 .45975 m .23094 .52991 L .27149 .52588 L p F P
0 g
s
.841 .603 .579 r
.48835 .34664 m .42836 .32127 L .41939 .36984 L p F P
0 g
s
.841 .603 .579 r
.41939 .36984 m .47873 .40169 L .48835 .34664 L p F P
0 g
s
.626 .657 .86 r
.27149 .52588 m .31143 .57745 L .3623 .5536 L p F P
0 g
s
0 0 0 r
.16651 .28274 m .23971 .26078 L .22378 .2634 L closepath p F P
0 g
s
0 0 .191 r
.16651 .28274 m .16226 .3436 L .16396 .35954 L closepath p F P
0 g
s
.827 .763 .792 r
.4939 .49242 m .45194 .45956 L .41133 .51255 L p F P
0 g
s
.827 .763 .792 r
.41133 .51255 m .45374 .54484 L .4939 .49242 L p F P
0 g
s
.757 .771 .864 r
.45374 .54484 m .41133 .51255 L .3623 .5536 L p F P
0 g
s
.439 0 0 r
.16651 .28274 m .25242 .26501 L .23971 .26078 L closepath p F P
0 g
s
0 .058 .582 r
.16651 .28274 m .16396 .35954 L .17145 .37059 L closepath p F P
0 g
s
.734 .42 .449 r
.34704 .27379 m .26034 .27568 L .26244 .29156 L p F P
0 g
s
.734 .42 .449 r
.26244 .29156 m .35162 .30351 L .34704 .27379 L p F P
0 g
s
.477 .525 .828 r
.27149 .52588 m .23452 .45622 L .20445 .45975 L p F P
0 g
s
.477 .486 .788 r
.18392 .37533 m .20445 .45975 L .23452 .45622 L p F P
0 g
s
.278 .345 .753 r
.20445 .45975 m .18392 .37533 L .17145 .37059 L p F P
0 g
s
.783 .544 .574 r
.42836 .32127 m .35162 .30351 L .34452 .3396 L p F P
0 g
s
.783 .544 .574 r
.34452 .3396 m .41939 .36984 L .42836 .32127 L p F P
0 g
s
.813 .651 .682 r
.47873 .40169 m .41939 .36984 L .39544 .42093 L p F P
0 g
s
.813 .651 .682 r
.39544 .42093 m .45194 .45956 L .47873 .40169 L p F P
0 g
s
.626 .657 .86 r
.3623 .5536 m .31626 .50437 L .27149 .52588 L p F P
0 g
s
.605 .589 .809 r
.23452 .45622 m .27149 .52588 L .31626 .50437 L p F P
0 g
s
.714 .676 .811 r
.31626 .50437 m .3623 .5536 L .41133 .51255 L p F P
0 g
s
.645 .243 .267 r
.16651 .28274 m .26034 .27568 L .25242 .26501 L closepath p F P
0 g
s
.294 .335 .735 r
.16651 .28274 m .17145 .37059 L .18392 .37533 L closepath p F P
0 g
s
.771 .673 .754 r
.45194 .45956 m .39544 .42093 L .35948 .46784 L p F P
0 g
s
.771 .673 .754 r
.35948 .46784 m .41133 .51255 L .45194 .45956 L p F P
0 g
s
.714 .676 .811 r
.41133 .51255 m .35948 .46784 L .31626 .50437 L p F P
0 g
s
.716 .407 .453 r
.16651 .28274 m .26244 .29156 L .26034 .27568 L closepath p F P
0 g
s
.477 .486 .788 r
.23452 .45622 m .19989 .37312 L .18392 .37533 L p F P
0 g
s
.476 .468 .77 r
.16651 .28274 m .18392 .37533 L .19989 .37312 L closepath p F P
0 g
s
.748 .509 .569 r
.35162 .30351 m .26244 .29156 L .25839 .31075 L p F P
0 g
s
.748 .509 .569 r
.25839 .31075 m .34452 .3396 L .35162 .30351 L p F P
0 g
s
.605 .589 .809 r
.31626 .50437 m .26767 .43983 L .23452 .45622 L p F P
0 g
s
.59 .549 .777 r
.19989 .37312 m .23452 .45622 L .26767 .43983 L p F P
0 g
s
.765 .591 .662 r
.41939 .36984 m .34452 .3396 L .32646 .37754 L p F P
0 g
s
.765 .591 .662 r
.32646 .37754 m .39544 .42093 L .41939 .36984 L p F P
0 g
s
.681 .612 .772 r
.26767 .43983 m .31626 .50437 L .35948 .46784 L p F P
0 g
s
.732 .493 .566 r
.16651 .28274 m .25839 .31075 L .26244 .29156 L closepath p F P
0 g
s
.59 .549 .777 r
.26767 .43983 m .21745 .36414 L .19989 .37312 L p F P
0 g
s
.582 .531 .763 r
.16651 .28274 m .19989 .37312 L .21745 .36414 L closepath p F P
0 g
s
.736 .555 .648 r
.34452 .3396 m .25839 .31075 L .24865 .33089 L p F P
0 g
s
.736 .555 .648 r
.24865 .33089 m .32646 .37754 L .34452 .3396 L p F P
0 g
s
.681 .612 .772 r
.35948 .46784 m .2997 .41245 L .26767 .43983 L p F P
0 g
s
.66 .574 .747 r
.21745 .36414 m .26767 .43983 L .2997 .41245 L p F P
0 g
s
.731 .612 .724 r
.39544 .42093 m .32646 .37754 L .2997 .41245 L p F P
0 g
s
.731 .612 .724 r
.2997 .41245 m .35948 .46784 L .39544 .42093 L p F P
0 g
s
.722 .538 .642 r
.16651 .28274 m .24865 .33089 L .25839 .31075 L closepath p F P
0 g
s
.694 .558 .696 r
.16651 .28274 m .23441 .34946 L .24865 .33089 L closepath p F P
0 g
s
.65 .556 .736 r
.16651 .28274 m .21745 .36414 L .23441 .34946 L closepath p F P
0 g
s
.66 .574 .747 r
.2997 .41245 m .23441 .34946 L .21745 .36414 L p F P
0 g
s
.706 .575 .705 r
.32646 .37754 m .24865 .33089 L .23441 .34946 L p F P
0 g
s
.706 .575 .705 r
.23441 .34946 m .2997 .41245 L .32646 .37754 L p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.840136 0.0147151 0.97619 0.360953 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0305255 1.14537 -3.71339e-17 1.14537 [
[ 0 0 0 0 ]
[ 1 1.04096 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.04096 L
0 1.04096 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.794 .568 .595 r
.64363 .81975 m .71078 .85503 L .64074 .83638 L closepath p F P
0 g
s
.775 .596 .657 r
.6525 .80399 m .71078 .85503 L .64363 .81975 L closepath p F P
0 g
s
.746 .604 .7 r
.66627 .79095 m .71078 .85503 L .6525 .80399 L closepath p F P
0 g
s
.707 .594 .728 r
.68331 .78216 m .71078 .85503 L .66627 .79095 L closepath p F P
0 g
s
.659 .569 .743 r
.70161 .77865 m .71078 .85503 L .68331 .78216 L closepath p F P
0 g
s
.599 .525 .743 r
.71904 .78086 m .71078 .85503 L .70161 .77865 L closepath p F P
0 g
s
.524 .457 .723 r
.7335 .78857 m .71078 .85503 L .71904 .78086 L closepath p F P
0 g
s
.426 .354 .673 r
.74324 .80088 m .71078 .85503 L .7335 .78857 L closepath p F P
0 g
s
.3 .202 .572 r
.74705 .81637 m .71078 .85503 L .74324 .80088 L closepath p F P
0 g
s
.149 0 .398 r
.7444 .83316 m .71078 .85503 L .74705 .81637 L closepath p F P
0 g
s
.009 0 .154 r
.73557 .84921 m .71078 .85503 L .7444 .83316 L closepath p F P
0 g
s
0 0 0 r
.72162 .86252 m .71078 .85503 L .73557 .84921 L closepath p F P
0 g
s
.051 0 0 r
.70426 .87145 m .71078 .85503 L .72162 .86252 L closepath p F P
0 g
s
.265 0 0 r
.68565 .8749 m .71078 .85503 L .70426 .87145 L closepath p F P
0 g
s
.504 .005 .006 r
.66808 .87245 m .71078 .85503 L .68565 .8749 L closepath p F P
0 g
s
.675 .242 .212 r
.65369 .86444 m .71078 .85503 L .66808 .87245 L closepath p F P
0 g
s
.763 .409 .384 r
.64421 .8519 m .71078 .85503 L .65369 .86444 L closepath p F P
0 g
s
.794 .511 .508 r
.64074 .83638 m .71078 .85503 L .64421 .8519 L closepath p F P
0 g
s
.754 .618 .708 r
.62483 .73082 m .66627 .79095 L .6525 .80399 L p F P
0 g
s
.712 .608 .738 r
.66627 .79095 m .62483 .73082 L .65693 .71422 L p F P
0 g
s
.712 .608 .738 r
.65693 .71422 m .68331 .78216 L .66627 .79095 L p F P
0 g
s
.661 .581 .755 r
.68331 .78216 m .65693 .71422 L .69142 .70743 L p F P
0 g
s
.661 .581 .755 r
.69142 .70743 m .70161 .77865 L .68331 .78216 L p F P
0 g
s
.786 .611 .663 r
.5988 .75532 m .6525 .80399 L .64363 .81975 L p F P
0 g
s
.754 .618 .708 r
.6525 .80399 m .5988 .75532 L .62483 .73082 L p F P
0 g
s
.596 .535 .756 r
.70161 .77865 m .69142 .70743 L .72433 .71132 L p F P
0 g
s
.596 .535 .756 r
.72433 .71132 m .71904 .78086 L .70161 .77865 L p F P
0 g
s
.807 .582 .596 r
.58185 .78492 m .64363 .81975 L .64074 .83638 L p F P
0 g
s
.786 .611 .663 r
.64363 .81975 m .58185 .78492 L .5988 .75532 L p F P
0 g
s
.772 .65 .728 r
.58919 .67812 m .62483 .73082 L .5988 .75532 L p F P
0 g
s
.724 .638 .762 r
.62483 .73082 m .58919 .67812 L .63264 .65561 L p F P
0 g
s
.724 .638 .762 r
.63264 .65561 m .65693 .71422 L .62483 .73082 L p F P
0 g
s
.664 .608 .782 r
.65693 .71422 m .63264 .65561 L .67931 .64621 L p F P
0 g
s
.664 .608 .782 r
.67931 .64621 m .69142 .70743 L .65693 .71422 L p F P
0 g
s
.513 .461 .736 r
.71904 .78086 m .72433 .71132 L .75178 .72554 L p F P
0 g
s
.513 .461 .736 r
.75178 .72554 m .7335 .78857 L .71904 .78086 L p F P
0 g
s
.811 .644 .676 r
.55384 .71119 m .5988 .75532 L .58185 .78492 L p F P
0 g
s
.772 .65 .728 r
.5988 .75532 m .55384 .71119 L .58919 .67812 L p F P
0 g
s
.807 .582 .596 r
.64074 .83638 m .57607 .81625 L .58185 .78492 L p F P
0 g
s
.81 .521 .5 r
.57607 .81625 m .64074 .83638 L .64421 .8519 L p F P
0 g
s
.588 .557 .786 r
.69142 .70743 m .67931 .64621 L .72391 .65113 L p F P
0 g
s
.588 .557 .786 r
.72391 .65113 m .72433 .71132 L .69142 .70743 L p F P
0 g
s
.401 .347 .682 r
.7335 .78857 m .75178 .72554 L .77042 .74858 L p F P
0 g
s
.401 .347 .682 r
.77042 .74858 m .74324 .80088 L .7335 .78857 L p F P
0 g
s
.803 .709 .762 r
.5613 .63532 m .58919 .67812 L .55384 .71119 L p F P
0 g
s
.742 .693 .804 r
.58919 .67812 m .5613 .63532 L .61108 .60948 L p F P
0 g
s
.742 .693 .804 r
.61108 .60948 m .63264 .65561 L .58919 .67812 L p F P
0 g
s
.839 .614 .598 r
.53064 .75114 m .58185 .78492 L .57607 .81625 L p F P
0 g
s
.811 .644 .676 r
.58185 .78492 m .53064 .75114 L .55384 .71119 L p F P
0 g
s
.776 .407 .356 r
.58228 .84561 m .64421 .8519 L .65369 .86444 L p F P
0 g
s
.81 .521 .5 r
.64421 .8519 m .58228 .84561 L .57607 .81625 L p F P
0 g
s
.668 .659 .831 r
.63264 .65561 m .61108 .60948 L .66452 .59853 L p F P
0 g
s
.668 .659 .831 r
.66452 .59853 m .67931 .64621 L .63264 .65561 L p F P
0 g
s
.249 .17 .567 r
.74324 .80088 m .77042 .74858 L .77783 .7778 L p F P
0 g
s
.249 .17 .567 r
.77783 .7778 m .74705 .81637 L .74324 .80088 L p F P
0 g
s
.485 .471 .766 r
.72433 .71132 m .72391 .65113 L .76124 .67003 L p F P
0 g
s
.485 .471 .766 r
.76124 .67003 m .75178 .72554 L .72433 .71132 L p F P
0 g
s
.855 .707 .698 r
.5207 .67313 m .55384 .71119 L .53064 .75114 L p F P
0 g
s
.803 .709 .762 r
.55384 .71119 m .5207 .67313 L .5613 .63532 L p F P
0 g
s
.672 .211 .148 r
.59996 .86945 m .65369 .86444 L .66808 .87245 L p F P
0 g
s
.776 .407 .356 r
.65369 .86444 m .59996 .86945 L .58228 .84561 L p F P
0 g
s
.569 .597 .842 r
.67931 .64621 m .66452 .59853 L .71561 .60387 L p F P
0 g
s
.569 .597 .842 r
.71561 .60387 m .72391 .65113 L .67931 .64621 L p F P
0 g
s
.055 0 .355 r
.74705 .81637 m .77783 .7778 L .77293 .8097 L p F P
0 g
s
.055 0 .355 r
.77293 .8097 m .7444 .83316 L .74705 .81637 L p F P
0 g
s
.839 .614 .598 r
.57607 .81625 m .52244 .79348 L .53064 .75114 L p F P
0 g
s
.846 .544 .477 r
.52244 .79348 m .57607 .81625 L .58228 .84561 L p F P
0 g
s
.457 0 0 r
.62713 .88477 m .66808 .87245 L .68565 .8749 L p F P
0 g
s
.672 .211 .148 r
.66808 .87245 m .62713 .88477 L .59996 .86945 L p F P
0 g
s
.896 .676 .596 r
.49391 .71876 m .53064 .75114 L .52244 .79348 L p F P
0 g
s
.855 .707 .698 r
.53064 .75114 m .49391 .71876 L .5207 .67313 L p F P
0 g
s
.335 .327 .702 r
.75178 .72554 m .76124 .67003 L .78672 .70098 L p F P
0 g
s
.335 .327 .702 r
.78672 .70098 m .77042 .74858 L .75178 .72554 L p F P
0 g
s
0 0 .049 r
.7444 .83316 m .77293 .8097 L .75613 .84034 L p F P
0 g
s
0 0 .049 r
.75613 .84034 m .73557 .84921 L .7444 .83316 L p F P
0 g
s
.847 .81 .814 r
.54223 .60374 m .5613 .63532 L .5207 .67313 L p F P
0 g
s
.765 .787 .871 r
.5613 .63532 m .54223 .60374 L .59256 .57759 L p F P
0 g
s
.765 .787 .871 r
.59256 .57759 m .61108 .60948 L .5613 .63532 L p F P
0 g
s
.662 .743 .911 r
.61108 .60948 m .59256 .57759 L .64652 .56639 L p F P
0 g
s
.662 .743 .911 r
.64652 .56639 m .66452 .59853 L .61108 .60948 L p F P
0 g
s
.156 0 0 r
.66058 .88951 m .68565 .8749 L .70426 .87145 L p F P
0 g
s
.457 0 0 r
.68565 .8749 m .66058 .88951 L .62713 .88477 L p F P
0 g
s
0 0 0 r
.73557 .84921 m .75613 .84034 L .72943 .86584 L p F P
0 g
s
0 0 0 r
.72943 .86584 m .72162 .86252 L .73557 .84921 L p F P
0 g
s
.42 .487 .822 r
.72391 .65113 m .71561 .60387 L .75843 .62518 L p F P
0 g
s
.42 .487 .822 r
.75843 .62518 m .76124 .67003 L .72391 .65113 L p F P
0 g
s
0 0 0 r
.69618 .88295 m .70426 .87145 L .72162 .86252 L p F P
0 g
s
.156 0 0 r
.70426 .87145 m .69618 .88295 L .66058 .88951 L p F P
0 g
s
.921 .815 .725 r
.50113 .64189 m .5207 .67313 L .49391 .71876 L p F P
0 g
s
.847 .81 .814 r
.5207 .67313 m .50113 .64189 L .54223 .60374 L p F P
0 g
s
0 0 0 r
.72162 .86252 m .72943 .86584 L .69618 .88295 L p F P
0 g
s
.805 .398 .28 r
.53047 .83329 m .58228 .84561 L .59996 .86945 L p F P
0 g
s
.846 .544 .477 r
.58228 .84561 m .53047 .83329 L .52244 .79348 L p F P
0 g
s
.51 .663 .93 r
.66452 .59853 m .64652 .56639 L .69807 .57157 L p F P
0 g
s
.51 .663 .93 r
.69807 .57157 m .71561 .60387 L .66452 .59853 L p F P
0 g
s
.105 .08 .543 r
.77042 .74858 m .78672 .70098 L .79699 .7405 L p F P
0 g
s
.105 .08 .543 r
.79699 .7405 m .77783 .7778 L .77042 .74858 L p F P
0 g
s
.896 .676 .596 r
.52244 .79348 m .4842 .76713 L .49391 .71876 L p F P
0 g
s
.912 .587 .417 r
.4842 .76713 m .52244 .79348 L .53047 .83329 L p F P
0 g
s
.98 .782 .565 r
.47393 .68786 m .49391 .71876 L .4842 .76713 L p F P
0 g
s
.921 .815 .725 r
.49391 .71876 m .47393 .68786 L .50113 .64189 L p F P
0 g
s
.644 .115 0 r
.55416 .86572 m .59996 .86945 L .62713 .88477 L p F P
0 g
s
.805 .398 .28 r
.59996 .86945 m .55416 .86572 L .53047 .83329 L p F P
0 g
s
.165 .27 .727 r
.76124 .67003 m .75843 .62518 L .78772 .66036 L p F P
0 g
s
.165 .27 .727 r
.78772 .66036 m .78672 .70098 L .76124 .67003 L p F P
0 g
s
.238 .489 .893 r
.71561 .60387 m .69807 .57157 L .74123 .59285 L p F P
0 g
s
.238 .489 .893 r
.74123 .59285 m .75843 .62518 L .71561 .60387 L p F P
0 g
s
.874 .95 .857 r
.5321 .58344 m .54223 .60374 L .50113 .64189 L p F P
0 g
s
.759 .916 .943 r
.54223 .60374 m .5321 .58344 L .57699 .5601 L p F P
0 g
s
.759 .916 .943 r
.57699 .5601 m .59256 .57759 L .54223 .60374 L p F P
0 g
s
0 0 .213 r
.77783 .7778 m .79699 .7405 L .7904 .78391 L p F P
0 g
s
0 0 .213 r
.7904 .78391 m .77293 .8097 L .77783 .7778 L p F P
0 g
s
.596 .851 .993 r
.59256 .57759 m .57699 .5601 L .62506 .55005 L p F P
0 g
s
.596 .851 .993 r
.62506 .55005 m .64652 .56639 L .59256 .57759 L p F P
0 g
s
.955 .95 .703 r
.49541 .61743 m .50113 .64189 L .47393 .68786 L p F P
0 g
s
.874 .95 .857 r
.50113 .64189 m .49541 .61743 L .5321 .58344 L p F P
0 g
s
.825 .352 .066 r
.49309 .81265 m .53047 .83329 L .55416 .86572 L p F P
0 g
s
.912 .587 .417 r
.53047 .83329 m .49309 .81265 L .4842 .76713 L p F P
0 g
s
.284 0 0 r
.59098 .88663 m .62713 .88477 L .66058 .88951 L p F P
0 g
s
.644 .115 0 r
.62713 .88477 m .59098 .88663 L .55416 .86572 L p F P
0 g
s
.98 .782 .565 r
.4842 .76713 m .46396 .73654 L .47393 .68786 L p F P
0 g
s
.951 .617 .212 r
.46396 .73654 m .4842 .76713 L .49309 .81265 L p F P
0 g
s
.312 .705 .979 r
.64652 .56639 m .62506 .55005 L .67088 .55457 L p F P
0 g
s
.312 .705 .979 r
.67088 .55457 m .69807 .57157 L .64652 .56639 L p F P
0 g
s
0 0 0 r
.77293 .8097 m .7904 .78391 L .76747 .82577 L p F P
0 g
s
0 0 0 r
.76747 .82577 m .75613 .84034 L .77293 .8097 L p F P
0 g
s
0 0 .417 r
.78672 .70098 m .78772 .66036 L .79955 .70551 L p F P
0 g
s
0 0 .417 r
.79955 .70551 m .79699 .7405 L .78672 .70098 L p F P
0 g
s
.284 0 0 r
.66058 .88951 m .63658 .89314 L .59098 .88663 L p F P
0 g
s
.153 .693 .723 r
.63658 .89314 m .66058 .88951 L .69618 .88295 L p F P
0 g
s
.925 .823 .365 r
.47114 .65829 m .47393 .68786 L .46396 .73654 L p F P
0 g
s
.955 .95 .703 r
.47393 .68786 m .47114 .65829 L .49541 .61743 L p F P
0 g
s
0 .065 .623 r
.75843 .62518 m .74123 .59285 L .77069 .62812 L p F P
0 g
s
0 .065 .623 r
.77069 .62812 m .78772 .66036 L .75843 .62518 L p F P
0 g
s
.584 .888 .6 r
.75613 .84034 m .76747 .82577 L .73089 .86071 L p F P
0 g
s
.584 .888 .6 r
.73089 .86071 m .72943 .86584 L .75613 .84034 L p F P
0 g
s
.455 .876 .757 r
.68529 .88416 m .69618 .88295 L .72943 .86584 L p F P
0 g
s
.153 .693 .723 r
.69618 .88295 m .68529 .88416 L .63658 .89314 L p F P
0 g
s
.455 .876 .757 r
.72943 .86584 m .73089 .86071 L .68529 .88416 L p F P
0 g
s
.43 0 0 r
.52001 .8498 m .55416 .86572 L .59098 .88663 L p F P
0 g
s
.825 .352 .066 r
.55416 .86572 m .52001 .8498 L .49309 .81265 L p F P
0 g
s
0 .324 .725 r
.69807 .57157 m .67088 .55457 L .70909 .57339 L p F P
0 g
s
0 .324 .725 r
.70909 .57339 m .74123 .59285 L .69807 .57157 L p F P
0 g
s
.951 .617 .212 r
.49309 .81265 m .47276 .7823 L .46396 .73654 L p F P
0 g
s
0 0 .451 r
.47276 .7823 m .49309 .81265 L .52001 .8498 L p F P
0 g
s
.789 .717 .183 r
.79699 .7405 m .79955 .70551 L .79198 .75527 L p F P
0 g
s
.789 .717 .183 r
.79198 .75527 m .7904 .78391 L .79699 .7405 L p F P
0 g
s
.738 .981 .752 r
.53004 .57325 m .5321 .58344 L .49541 .61743 L p F P
0 g
s
.609 .955 .883 r
.5321 .58344 m .53004 .57325 L .56395 .55561 L p F P
0 g
s
.609 .955 .883 r
.56395 .55561 m .57699 .5601 L .5321 .58344 L p F P
0 g
s
.351 .823 .889 r
.57699 .5601 m .56395 .55561 L .6002 .54802 L p F P
0 g
s
.351 .823 .889 r
.6002 .54802 m .62506 .55005 L .57699 .5601 L p F P
0 g
s
.925 .823 .365 r
.46396 .73654 m .46223 .70144 L .47114 .65829 L p F P
0 g
s
0 0 .253 r
.46223 .70144 m .46396 .73654 L .47276 .7823 L p F P
0 g
s
.722 .871 .46 r
.50234 .5989 m .49541 .61743 L .47114 .65829 L p F P
0 g
s
.738 .981 .752 r
.49541 .61743 m .50234 .5989 L .53004 .57325 L p F P
0 g
s
.882 .539 .043 r
.78772 .66036 m .77069 .62812 L .7825 .67349 L p F P
0 g
s
.882 .539 .043 r
.7825 .67349 m .79955 .70551 L .78772 .66036 L p F P
0 g
s
.43 0 0 r
.59098 .88663 m .56214 .87376 L .52001 .8498 L p F P
0 g
s
.16 .646 .922 r
.56214 .87376 m .59098 .88663 L .63658 .89314 L p F P
0 g
s
.081 0 0 r
.62506 .55005 m .6002 .54802 L .63461 .55142 L p F P
0 g
s
.081 0 0 r
.63461 .55142 m .67088 .55457 L .62506 .55005 L p F P
0 g
s
.763 .252 0 r
.74123 .59285 m .70909 .57339 L .73502 .60459 L p F P
0 g
s
.763 .252 0 r
.73502 .60459 m .77069 .62812 L .74123 .59285 L p F P
0 g
s
.929 .956 .637 r
.7904 .78391 m .79198 .75527 L .76553 .80342 L p F P
0 g
s
.929 .956 .637 r
.76553 .80342 m .76747 .82577 L .7904 .78391 L p F P
0 g
s
.722 .871 .46 r
.47114 .65829 m .48406 .62964 L .50234 .5989 L p F P
0 g
s
0 0 .03 r
.48406 .62964 m .47114 .65829 L .46223 .70144 L p F P
0 g
s
.109 .433 .874 r
.49979 .81958 m .52001 .8498 L .56214 .87376 L p F P
0 g
s
0 0 .451 r
.52001 .8498 m .49979 .81958 L .47276 .7823 L p F P
0 g
s
.531 .861 .995 r
.61454 .88117 m .63658 .89314 L .68529 .88416 L p F P
0 g
s
.16 .646 .922 r
.63658 .89314 m .61454 .88117 L .56214 .87376 L p F P
0 g
s
.552 0 0 r
.67088 .55457 m .63461 .55142 L .66315 .56555 L p F P
0 g
s
.552 0 0 r
.66315 .56555 m .70909 .57339 L .67088 .55457 L p F P
0 g
s
.035 .186 .691 r
.47005 .74187 m .47276 .7823 L .49979 .81958 L p F P
0 g
s
0 0 .253 r
.47276 .7823 m .47005 .74187 L .46223 .70144 L p F P
0 g
s
.865 .983 .845 r
.76747 .82577 m .76553 .80342 L .7233 .84368 L p F P
0 g
s
.865 .983 .845 r
.7233 .84368 m .73089 .86071 L .76747 .82577 L p F P
0 g
s
.996 .792 .512 r
.79955 .70551 m .7825 .67349 L .77471 .72358 L p F P
0 g
s
.996 .792 .512 r
.77471 .72358 m .79198 .75527 L .79955 .70551 L p F P
0 g
s
.735 .946 .95 r
.67068 .87077 m .68529 .88416 L .73089 .86071 L p F P
0 g
s
.531 .861 .995 r
.68529 .88416 m .67068 .87077 L .61454 .88117 L p F P
0 g
s
.735 .946 .95 r
.73089 .86071 m .7233 .84368 L .67068 .87077 L p F P
0 g
s
0 0 .03 r
.46223 .70144 m .47742 .66198 L .48406 .62964 L p F P
0 g
s
0 0 .47 r
.47742 .66198 m .46223 .70144 L .47005 .74187 L p F P
0 g
s
.923 .571 .349 r
.77069 .62812 m .73502 .60459 L .74522 .6447 L p F P
0 g
s
.923 .571 .349 r
.74522 .6447 m .7825 .67349 L .77069 .62812 L p F P
0 g
s
.464 .663 .949 r
.54223 .84356 m .56214 .87376 L .61454 .88117 L p F P
0 g
s
.109 .433 .874 r
.56214 .87376 m .54223 .84356 L .49979 .81958 L p F P
0 g
s
.794 .346 .181 r
.70909 .57339 m .66315 .56555 L .68232 .58892 L p F P
0 g
s
.794 .346 .181 r
.68232 .58892 m .73502 .60459 L .70909 .57339 L p F P
0 g
s
.333 .784 .634 r
.53004 .57325 m .53428 .57081 L .55269 .56123 L p F P
0 g
s
.333 .784 .634 r
.55269 .56123 m .56395 .55561 L .53004 .57325 L p F P
0 g
s
0 0 0 r
.53428 .57081 m .53004 .57325 L .50234 .5989 L p F P
0 g
s
0 0 0 r
.56395 .55561 m .55269 .56123 L .57232 .55712 L p F P
0 g
s
0 0 0 r
.57232 .55712 m .6002 .54802 L .56395 .55561 L p F P
0 g
s
0 0 0 r
.51925 .58472 m .50234 .5989 L .48406 .62964 L p F P
0 g
s
0 0 0 r
.50234 .5989 m .51925 .58472 L .53428 .57081 L p F P
0 g
s
.367 .464 .828 r
.49406 .77466 m .49979 .81958 L .54223 .84356 L p F P
0 g
s
.035 .186 .691 r
.49979 .81958 m .49406 .77466 L .47005 .74187 L p F P
0 g
s
.941 .841 .717 r
.79198 .75527 m .77471 .72358 L .74784 .77211 L p F P
0 g
s
.941 .841 .717 r
.74784 .77211 m .76553 .80342 L .79198 .75527 L p F P
0 g
s
.32 0 0 r
.6002 .54802 m .57232 .55712 L .59087 .55898 L p F P
0 g
s
.32 0 0 r
.59087 .55898 m .63461 .55142 L .6002 .54802 L p F P
0 g
s
.264 .277 .687 r
.48339 .69211 m .47005 .74187 L .49406 .77466 L p F P
0 g
s
0 0 .47 r
.47005 .74187 m .48339 .69211 L .47742 .66198 L p F P
0 g
s
0 0 .23 r
.50938 .60134 m .48406 .62964 L .47742 .66198 L p F P
0 g
s
0 0 0 r
.48406 .62964 m .50938 .60134 L .51925 .58472 L p F P
0 g
s
.648 .76 .931 r
.59512 .85085 m .61454 .88117 L .67068 .87077 L p F P
0 g
s
.464 .663 .949 r
.61454 .88117 m .59512 .85085 L .54223 .84356 L p F P
0 g
s
.915 .684 .575 r
.7825 .67349 m .74522 .6447 L .73803 .68896 L p F P
0 g
s
.915 .684 .575 r
.73803 .68896 m .77471 .72358 L .7825 .67349 L p F P
0 g
s
.624 .11 .005 r
.63461 .55142 m .59087 .55898 L .60614 .56664 L p F P
0 g
s
.624 .11 .005 r
.60614 .56664 m .66315 .56555 L .63461 .55142 L p F P
0 g
s
.857 .532 .436 r
.73502 .60459 m .68232 .58892 L .68962 .61887 L p F P
0 g
s
.857 .532 .436 r
.68962 .61887 m .74522 .6447 L .73502 .60459 L p F P
0 g
s
.86 .836 .821 r
.76553 .80342 m .74784 .77211 L .70506 .81277 L p F P
0 g
s
.86 .836 .821 r
.70506 .81277 m .7233 .84368 L .76553 .80342 L p F P
0 g
s
.767 .809 .887 r
.65184 .8402 m .67068 .87077 L .7233 .84368 L p F P
0 g
s
.648 .76 .931 r
.67068 .87077 m .65184 .8402 L .59512 .85085 L p F P
0 g
s
0 0 .23 r
.47742 .66198 m .50587 .61873 L .50938 .60134 L p F P
0 g
s
.146 .079 .518 r
.50587 .61873 m .47742 .66198 L .48339 .69211 L p F P
0 g
s
.767 .809 .887 r
.7233 .84368 m .70506 .81277 L .65184 .8402 L p F P
0 g
s
.548 .596 .854 r
.5317 .7956 m .54223 .84356 L .59512 .85085 L p F P
0 g
s
.367 .464 .828 r
.54223 .84356 m .5317 .7956 L .49406 .77466 L p F P
0 g
s
.452 .453 .769 r
.50148 .71637 m .49406 .77466 L .5317 .7956 L p F P
0 g
s
.264 .277 .687 r
.49406 .77466 m .50148 .71637 L .48339 .69211 L p F P
0 g
s
.772 .366 .284 r
.66315 .56555 m .60614 .56664 L .61625 .57922 L p F P
0 g
s
.772 .366 .284 r
.61625 .57922 m .68232 .58892 L .66315 .56555 L p F P
0 g
s
.869 .719 .694 r
.77471 .72358 m .73803 .68896 L .71401 .73183 L p F P
0 g
s
.869 .719 .694 r
.71401 .73183 m .74784 .77211 L .77471 .72358 L p F P
0 g
s
.851 .616 .582 r
.74522 .6447 m .68962 .61887 L .68395 .65182 L p F P
0 g
s
.851 .616 .582 r
.68395 .65182 m .73803 .68896 L .74522 .6447 L p F P
0 g
s
.347 .305 .669 r
.50918 .63482 m .48339 .69211 L .50148 .71637 L p F P
0 g
s
.146 .079 .518 r
.48339 .69211 m .50918 .63482 L .50587 .61873 L p F P
0 g
s
.662 .666 .843 r
.57856 .80178 m .59512 .85085 L .65184 .8402 L p F P
0 g
s
.548 .596 .854 r
.59512 .85085 m .57856 .80178 L .5317 .7956 L p F P
0 g
s
.818 .508 .465 r
.68232 .58892 m .61625 .57922 L .61995 .59525 L p F P
0 g
s
.818 .508 .465 r
.61995 .59525 m .68962 .61887 L .68232 .58892 L p F P
0 g
s
0 0 0 r
.54216 .57268 m .53428 .57081 L .51925 .58472 L closepath p F P
0 g
s
0 0 0 r
.54216 .57268 m .55269 .56123 L .53428 .57081 L closepath p F P
0 g
s
.812 .722 .766 r
.74784 .77211 m .71401 .73183 L .676 .7678 L p F P
0 g
s
.812 .722 .766 r
.676 .7678 m .70506 .81277 L .74784 .77211 L p F P
0 g
s
.078 0 0 r
.54216 .57268 m .57232 .55712 L .55269 .56123 L closepath p F P
0 g
s
.574 .553 .793 r
.52969 .7317 m .5317 .7956 L .57856 .80178 L p F P
0 g
s
.452 .453 .769 r
.5317 .7956 m .52969 .7317 L .50148 .71637 L p F P
0 g
s
0 0 0 r
.54216 .57268 m .51925 .58472 L .50938 .60134 L closepath p F P
0 g
s
.395 0 0 r
.54216 .57268 m .59087 .55898 L .57232 .55712 L closepath p F P
0 g
s
.745 .704 .813 r
.62881 .79215 m .65184 .8402 L .70506 .81277 L p F P
0 g
s
.662 .666 .843 r
.65184 .8402 m .62881 .79215 L .57856 .80178 L p F P
0 g
s
.745 .704 .813 r
.70506 .81277 m .676 .7678 L .62881 .79215 L p F P
0 g
s
0 0 .293 r
.54216 .57268 m .50938 .60134 L .50587 .61873 L closepath p F P
0 g
s
.485 .444 .737 r
.51898 .64766 m .50148 .71637 L .52969 .7317 L p F P
0 g
s
.347 .305 .669 r
.50148 .71637 m .51898 .64766 L .50918 .63482 L p F P
0 g
s
.821 .65 .671 r
.73803 .68896 m .68395 .65182 L .66581 .6837 L p F P
0 g
s
.821 .65 .671 r
.66581 .6837 m .71401 .73183 L .73803 .68896 L p F P
0 g
s
.637 .154 .089 r
.54216 .57268 m .60614 .56664 L .59087 .55898 L closepath p F P
0 g
s
.817 .581 .581 r
.68962 .61887 m .61995 .59525 L .61672 .61282 L p F P
0 g
s
.817 .581 .581 r
.61672 .61282 m .68395 .65182 L .68962 .61887 L p F P
0 g
s
.21 .12 .529 r
.54216 .57268 m .50587 .61873 L .50918 .63482 L closepath p F P
0 g
s
.659 .611 .789 r
.56469 .73603 m .57856 .80178 L .62881 .79215 L p F P
0 g
s
.574 .553 .793 r
.57856 .80178 m .56469 .73603 L .52969 .7317 L p F P
0 g
s
.759 .371 .318 r
.54216 .57268 m .61625 .57922 L .60614 .56664 L closepath p F P
0 g
s
.778 .657 .729 r
.71401 .73183 m .66581 .6837 L .63736 .71045 L p F P
0 g
s
.778 .657 .729 r
.63736 .71045 m .676 .7678 L .71401 .73183 L p F P
0 g
s
.583 .529 .76 r
.53415 .65566 m .52969 .7317 L .56469 .73603 L p F P
0 g
s
.485 .444 .737 r
.52969 .7317 m .53415 .65566 L .51898 .64766 L p F P
0 g
s
.377 .315 .66 r
.54216 .57268 m .50918 .63482 L .51898 .64766 L closepath p F P
0 g
s
.725 .644 .767 r
.60216 .72866 m .62881 .79215 L .676 .7678 L p F P
0 g
s
.659 .611 .789 r
.62881 .79215 m .60216 .72866 L .56469 .73603 L p F P
0 g
s
.801 .497 .475 r
.54216 .57268 m .61995 .59525 L .61625 .57922 L closepath p F P
0 g
s
.794 .614 .657 r
.68395 .65182 m .61672 .61282 L .60689 .62977 L p F P
0 g
s
.794 .614 .657 r
.60689 .62977 m .66581 .6837 L .68395 .65182 L p F P
0 g
s
.725 .644 .767 r
.676 .7678 m .63736 .71045 L .60216 .72866 L p F P
0 g
s
.497 .44 .722 r
.54216 .57268 m .51898 .64766 L .53415 .65566 L closepath p F P
0 g
s
.656 .581 .759 r
.55287 .65778 m .56469 .73603 L .60216 .72866 L p F P
0 g
s
.583 .529 .76 r
.56469 .73603 m .55287 .65778 L .53415 .65566 L p F P
0 g
s
.802 .565 .58 r
.54216 .57268 m .61672 .61282 L .61995 .59525 L closepath p F P
0 g
s
.758 .622 .708 r
.66581 .6837 m .60689 .62977 L .59164 .644 L p F P
0 g
s
.758 .622 .708 r
.59164 .644 m .63736 .71045 L .66581 .6837 L p F P
0 g
s
.586 .519 .746 r
.54216 .57268 m .53415 .65566 L .55287 .65778 L closepath p F P
0 g
s
.713 .611 .741 r
.57286 .65374 m .60216 .72866 L .63736 .71045 L p F P
0 g
s
.656 .581 .759 r
.60216 .72866 m .57286 .65374 L .55287 .65778 L p F P
0 g
s
.713 .611 .741 r
.63736 .71045 m .59164 .644 L .57286 .65374 L p F P
0 g
s
.782 .598 .651 r
.54216 .57268 m .60689 .62977 L .61672 .61282 L closepath p F P
0 g
s
.654 .568 .746 r
.54216 .57268 m .55287 .65778 L .57286 .65374 L closepath p F P
0 g
s
.749 .606 .699 r
.54216 .57268 m .59164 .644 L .60689 .62977 L closepath p F P
0 g
s
.707 .596 .73 r
.54216 .57268 m .57286 .65374 L .59164 .644 L closepath p F P
0 g
s
0 0 .293 r
.57621 .54291 m .54216 .57268 L .57964 .52511 L closepath p F P
0 g
s
0 0 0 r
.56605 .56013 m .54216 .57268 L .57621 .54291 L closepath p F P
0 g
s
0 0 0 r
.55039 .57464 m .54216 .57268 L .56605 .56013 L closepath p F P
0 g
s
0 0 0 r
.53116 .58464 m .54216 .57268 L .55039 .57464 L closepath p F P
0 g
s
.078 0 0 r
.51074 .58889 m .54216 .57268 L .53116 .58464 L closepath p F P
0 g
s
.395 0 0 r
.49167 .58688 m .54216 .57268 L .51074 .58889 L closepath p F P
0 g
s
.637 .154 .089 r
.47626 .57891 m .54216 .57268 L .49167 .58688 L closepath p F P
0 g
s
.759 .371 .318 r
.46637 .566 m .54216 .57268 L .47626 .57891 L closepath p F P
0 g
s
.801 .497 .475 r
.46313 .54976 m .54216 .57268 L .46637 .566 L closepath p F P
0 g
s
.802 .565 .58 r
.46685 .53215 m .54216 .57268 L .46313 .54976 L closepath p F P
0 g
s
.782 .598 .651 r
.47704 .51526 m .54216 .57268 L .46685 .53215 L closepath p F P
0 g
s
.749 .606 .699 r
.49247 .50108 m .54216 .57268 L .47704 .51526 L closepath p F P
0 g
s
.707 .596 .73 r
.51131 .49125 m .54216 .57268 L .49247 .50108 L closepath p F P
0 g
s
.654 .568 .746 r
.53136 .48694 m .54216 .57268 L .51131 .49125 L closepath p F P
0 g
s
.586 .519 .746 r
.55026 .48868 m .54216 .57268 L .53136 .48694 L closepath p F P
0 g
s
.497 .44 .722 r
.56577 .49629 m .54216 .57268 L .55026 .48868 L closepath p F P
0 g
s
.377 .315 .66 r
.57599 .50893 m .54216 .57268 L .56577 .49629 L closepath p F P
0 g
s
.21 .12 .529 r
.57964 .52511 m .54216 .57268 L .57599 .50893 L closepath p F P
0 g
s
.758 .621 .708 r
.44595 .43346 m .49247 .50108 L .47704 .51526 L p F P
0 g
s
.713 .611 .741 r
.49247 .50108 m .44595 .43346 L .48146 .4149 L p F P
0 g
s
.713 .611 .741 r
.48146 .4149 m .51131 .49125 L .49247 .50108 L p F P
0 g
s
.656 .581 .759 r
.51131 .49125 m .48146 .4149 L .51924 .40655 L p F P
0 g
s
.656 .581 .759 r
.51924 .40655 m .53136 .48694 L .51131 .49125 L p F P
0 g
s
.794 .613 .657 r
.41676 .4601 m .47704 .51526 L .46685 .53215 L p F P
0 g
s
.758 .621 .708 r
.47704 .51526 m .41676 .4601 L .44595 .43346 L p F P
0 g
s
.583 .529 .76 r
.53136 .48694 m .51924 .40655 L .55496 .40945 L p F P
0 g
s
.583 .529 .76 r
.55496 .40945 m .55026 .48868 L .53136 .48694 L p F P
0 g
s
.816 .581 .582 r
.39726 .49181 m .46685 .53215 L .46313 .54976 L p F P
0 g
s
.794 .613 .657 r
.46685 .53215 m .39726 .49181 L .41676 .4601 L p F P
0 g
s
.777 .656 .729 r
.40541 .37333 m .44595 .43346 L .41676 .4601 L p F P
0 g
s
.725 .643 .766 r
.44595 .43346 m .40541 .37333 L .4535 .34814 L p F P
0 g
s
.725 .643 .766 r
.4535 .34814 m .48146 .4149 L .44595 .43346 L p F P
0 g
s
.66 .611 .788 r
.48146 .4149 m .4535 .34814 L .50464 .33656 L p F P
0 g
s
.66 .611 .788 r
.50464 .33656 m .51924 .40655 L .48146 .4149 L p F P
0 g
s
.486 .445 .737 r
.55026 .48868 m .55496 .40945 L .58441 .42342 L p F P
0 g
s
.486 .445 .737 r
.58441 .42342 m .56577 .49629 L .55026 .48868 L p F P
0 g
s
.819 .649 .672 r
.36573 .4093 m .41676 .4601 L .39726 .49181 L p F P
0 g
s
.777 .656 .729 r
.41676 .4601 m .36573 .4093 L .40541 .37333 L p F P
0 g
s
.818 .508 .467 r
.38982 .52497 m .46313 .54976 L .46637 .566 L p F P
0 g
s
.816 .581 .582 r
.46313 .54976 m .38982 .52497 L .39726 .49181 L p F P
0 g
s
.576 .554 .792 r
.51924 .40655 m .50464 .33656 L .55307 .34007 L p F P
0 g
s
.576 .554 .792 r
.55307 .34007 m .55496 .40945 L .51924 .40655 L p F P
0 g
s
.349 .307 .67 r
.56577 .49629 m .58441 .42342 L .604 .447 L p F P
0 g
s
.349 .307 .67 r
.604 .447 m .57599 .50893 L .56577 .49629 L p F P
0 g
s
.807 .716 .764 r
.37283 .32314 m .40541 .37333 L .36573 .4093 L p F P
0 g
s
.744 .699 .809 r
.40541 .37333 m .37283 .32314 L .42798 .2942 L p F P
0 g
s
.744 .699 .809 r
.42798 .2942 m .4535 .34814 L .40541 .37333 L p F P
0 g
s
.849 .616 .585 r
.33899 .45208 m .39726 .49181 L .38982 .52497 L p F P
0 g
s
.819 .649 .672 r
.39726 .49181 m .33899 .45208 L .36573 .4093 L p F P
0 g
s
.772 .368 .286 r
.39551 .55569 m .46637 .566 L .47626 .57891 L p F P
0 g
s
.818 .508 .467 r
.46637 .566 m .39551 .55569 L .38982 .52497 L p F P
0 g
s
.665 .662 .837 r
.4535 .34814 m .42798 .2942 L .48656 .28068 L p F P
0 g
s
.665 .662 .837 r
.48656 .28068 m .50464 .33656 L .4535 .34814 L p F P
0 g
s
.149 .083 .52 r
.57599 .50893 m .604 .447 L .61116 .4775 L p F P
0 g
s
.149 .083 .52 r
.61116 .4775 m .57964 .52511 L .57599 .50893 L p F P
0 g
s
.458 .457 .769 r
.55496 .40945 m .55307 .34007 L .59316 .35852 L p F P
0 g
s
.458 .457 .769 r
.59316 .35852 m .58441 .42342 L .55496 .40945 L p F P
0 g
s
.862 .713 .696 r
.32722 .36428 m .36573 .4093 L .33899 .45208 L p F P
0 g
s
.807 .716 .764 r
.36573 .4093 m .32722 .36428 L .37283 .32314 L p F P
0 g
s
.626 .114 .01 r
.4139 .58024 m .47626 .57891 L .49167 .58688 L p F P
0 g
s
.772 .368 .286 r
.47626 .57891 m .4139 .58024 L .39551 .55569 L p F P
0 g
s
.559 .597 .848 r
.50464 .33656 m .48656 .28068 L .54207 .2843 L p F P
0 g
s
.559 .597 .848 r
.54207 .2843 m .55307 .34007 L .50464 .33656 L p F P
0 g
s
0 0 .235 r
.57964 .52511 m .61116 .4775 L .60476 .5113 L p F P
0 g
s
0 0 .235 r
.60476 .5113 m .57621 .54291 L .57964 .52511 L p F P
0 g
s
.855 .534 .444 r
.32844 .49688 m .38982 .52497 L .39551 .55569 L p F P
0 g
s
.849 .616 .585 r
.38982 .52497 m .32844 .49688 L .33899 .45208 L p F P
0 g
s
.325 0 0 r
.44298 .59549 m .49167 .58688 L .51074 .58889 L p F P
0 g
s
.626 .114 .01 r
.49167 .58688 m .44298 .59549 L .4139 .58024 L p F P
0 g
s
.905 .68 .586 r
.29627 .41313 m .33899 .45208 L .32844 .49688 L p F P
0 g
s
.862 .713 .696 r
.33899 .45208 m .29627 .41313 L .32722 .36428 L p F P
0 g
s
.277 .286 .69 r
.58441 .42342 m .59316 .35852 L .61997 .3901 L p F P
0 g
s
.277 .286 .69 r
.61997 .3901 m .604 .447 L .58441 .42342 L p F P
0 g
s
0 0 0 r
.57621 .54291 m .60476 .5113 L .58539 .54422 L p F P
0 g
s
0 0 0 r
.58539 .54422 m .56605 .56013 L .57621 .54291 L p F P
0 g
s
.847 .81 .814 r
.34929 .28414 m .37283 .32314 L .32722 .36428 L p F P
0 g
s
.765 .787 .871 r
.37283 .32314 m .34929 .28414 L .4051 .25481 L p F P
0 g
s
.765 .787 .871 r
.4051 .25481 m .42798 .2942 L .37283 .32314 L p F P
0 g
s
.662 .743 .911 r
.42798 .2942 m .4051 .25481 L .46432 .24095 L p F P
0 g
s
.662 .743 .911 r
.46432 .24095 m .48656 .28068 L .42798 .2942 L p F P
0 g
s
0 0 0 r
.47932 .59939 m .51074 .58889 L .53116 .58464 L p F P
0 g
s
.325 0 0 r
.51074 .58889 m .47932 .59939 L .44298 .59549 L p F P
0 g
s
0 0 0 r
.56605 .56013 m .58539 .54422 L .55536 .57207 L p F P
0 g
s
0 0 0 r
.55536 .57207 m .55039 .57464 L .56605 .56013 L p F P
0 g
s
.395 .476 .825 r
.55307 .34007 m .54207 .2843 L .58809 .305 L p F P
0 g
s
.395 .476 .825 r
.58809 .305 m .59316 .35852 L .55307 .34007 L p F P
0 g
s
0 0 0 r
.51843 .59126 m .53116 .58464 L .55039 .57464 L p F P
0 g
s
0 0 0 r
.53116 .58464 m .51843 .59126 L .47932 .59939 L p F P
0 g
s
.921 .815 .725 r
.30304 .32568 m .32722 .36428 L .29627 .41313 L p F P
0 g
s
.847 .81 .814 r
.32722 .36428 m .30304 .32568 L .34929 .28414 L p F P
0 g
s
0 0 0 r
.55039 .57464 m .55536 .57207 L .51843 .59126 L p F P
0 g
s
.797 .356 .2 r
.33565 .53852 m .39551 .55569 L .4139 .58024 L p F P
0 g
s
.855 .534 .444 r
.39551 .55569 m .33565 .53852 L .32844 .49688 L p F P
0 g
s
.51 .663 .93 r
.48656 .28068 m .46432 .24095 L .52037 .24433 L p F P
0 g
s
.51 .663 .93 r
.52037 .24433 m .54207 .2843 L .48656 .28068 L p F P
0 g
s
0 0 .484 r
.604 .447 m .61997 .3901 L .62991 .43132 L p F P
0 g
s
0 0 .484 r
.62991 .43132 m .61116 .4775 L .604 .447 L p F P
0 g
s
.918 .58 .385 r
.28377 .46431 m .32844 .49688 L .33565 .53852 L p F P
0 g
s
.905 .68 .586 r
.32844 .49688 m .28377 .46431 L .29627 .41313 L p F P
0 g
s
.98 .782 .565 r
.27156 .37492 m .29627 .41313 L .28377 .46431 L p F P
0 g
s
.921 .815 .725 r
.29627 .41313 m .27156 .37492 L .30304 .32568 L p F P
0 g
s
.571 .002 0 r
.36023 .57192 m .4139 .58024 L .44298 .59549 L p F P
0 g
s
.797 .356 .2 r
.4139 .58024 m .36023 .57192 L .33565 .53852 L p F P
0 g
s
.104 .231 .712 r
.59316 .35852 m .58809 .305 L .61892 .34081 L p F P
0 g
s
.104 .231 .712 r
.61892 .34081 m .61997 .3901 L .59316 .35852 L p F P
0 g
s
.238 .489 .893 r
.54207 .2843 m .52037 .24433 L .56676 .2649 L p F P
0 g
s
.238 .489 .893 r
.56676 .2649 m .58809 .305 L .54207 .2843 L p F P
0 g
s
.873 .932 .858 r
.33486 .25633 m .34929 .28414 L .30304 .32568 L p F P
0 g
s
.766 .9 .936 r
.34929 .28414 m .33486 .25633 L .38473 .2301 L p F P
0 g
s
.766 .9 .936 r
.38473 .2301 m .4051 .25481 L .34929 .28414 L p F P
0 g
s
0 0 .063 r
.61116 .4775 m .62991 .43132 L .62128 .47731 L p F P
0 g
s
0 0 .063 r
.62128 .47731 m .60476 .5113 L .61116 .4775 L p F P
0 g
s
.618 .842 .985 r
.4051 .25481 m .38473 .2301 L .43754 .21763 L p F P
0 g
s
.618 .842 .985 r
.43754 .21763 m .46432 .24095 L .4051 .25481 L p F P
0 g
s
.956 .938 .724 r
.2935 .29337 m .30304 .32568 L .27156 .37492 L p F P
0 g
s
.873 .932 .858 r
.30304 .32568 m .2935 .29337 L .33486 .25633 L p F P
0 g
s
.799 .306 0 r
.29162 .51191 m .33565 .53852 L .36023 .57192 L p F P
0 g
s
.918 .58 .385 r
.33565 .53852 m .29162 .51191 L .28377 .46431 L p F P
0 g
s
.116 0 0 r
.39962 .59274 m .44298 .59549 L .47932 .59939 L p F P
0 g
s
.571 .002 0 r
.44298 .59549 m .39962 .59274 L .36023 .57192 L p F P
0 g
s
.951 .617 .212 r
.25868 .4264 m .28377 .46431 L .29162 .51191 L p F P
0 g
s
.98 .782 .565 r
.28377 .46431 m .25868 .4264 L .27156 .37492 L p F P
0 g
s
.37 .72 .988 r
.46432 .24095 m .43754 .21763 L .48739 .22048 L p F P
0 g
s
.37 .72 .988 r
.48739 .22048 m .52037 .24433 L .46432 .24095 L p F P
0 g
s
.692 .848 .428 r
.60476 .5113 m .62128 .47731 L .59478 .52232 L p F P
0 g
s
.692 .848 .428 r
.59478 .52232 m .58539 .54422 L .60476 .5113 L p F P
0 g
s
0 0 .34 r
.61997 .3901 m .61892 .34081 L .63037 .38785 L p F P
0 g
s
0 0 .34 r
.63037 .38785 m .62991 .43132 L .61997 .3901 L p F P
0 g
s
.116 0 0 r
.47932 .59939 m .4492 .59806 L .39962 .59274 L p F P
0 g
s
.322 .808 .868 r
.4492 .59806 m .47932 .59939 L .51843 .59126 L p F P
0 g
s
.963 .85 .436 r
.26535 .33716 m .27156 .37492 L .25868 .4264 L p F P
0 g
s
.956 .938 .724 r
.27156 .37492 m .26535 .33716 L .2935 .29337 L p F P
0 g
s
0 .065 .623 r
.58809 .305 m .56676 .2649 L .59776 .30075 L p F P
0 g
s
0 .065 .623 r
.59776 .30075 m .61892 .34081 L .58809 .305 L p F P
0 g
s
.718 .972 .733 r
.58539 .54422 m .59478 .52232 L .55353 .56052 L p F P
0 g
s
.718 .972 .733 r
.55353 .56052 m .55536 .57207 L .58539 .54422 L p F P
0 g
s
.588 .947 .868 r
.50281 .5869 m .51843 .59126 L .55536 .57207 L p F P
0 g
s
.322 .808 .868 r
.51843 .59126 m .50281 .5869 L .4492 .59806 L p F P
0 g
s
.588 .947 .868 r
.55536 .57207 m .55353 .56052 L .50281 .5869 L p F P
0 g
s
.799 .306 0 r
.36023 .57192 m .31949 .55012 L .29162 .51191 L p F P
0 g
s
0 .244 .63 r
.31949 .55012 m .36023 .57192 L .39962 .59274 L p F P
0 g
s
0 .398 .805 r
.52037 .24433 m .48739 .22048 L .52847 .23862 L p F P
0 g
s
0 .398 .805 r
.52847 .23862 m .56676 .2649 L .52037 .24433 L p F P
0 g
s
.951 .617 .212 r
.29162 .51191 m .26637 .47422 L .25868 .4264 L p F P
0 g
s
0 0 .451 r
.26637 .47422 m .29162 .51191 L .31949 .55012 L p F P
0 g
s
.87 .781 .282 r
.62991 .43132 m .63037 .38785 L .62041 .44057 L p F P
0 g
s
.87 .781 .282 r
.62041 .44057 m .62128 .47731 L .62991 .43132 L p F P
0 g
s
.81 1 .823 r
.32865 .23845 m .33486 .25633 L .2935 .29337 L p F P
0 g
s
.687 .968 .93 r
.33486 .25633 m .32865 .23845 L .36638 .21859 L p F P
0 g
s
.687 .968 .93 r
.36638 .21859 m .38473 .2301 L .33486 .25633 L p F P
0 g
s
.474 .873 .961 r
.38473 .2301 m .36638 .21859 L .40627 .20913 L p F P
0 g
s
.474 .873 .961 r
.40627 .20913 m .43754 .21763 L .38473 .2301 L p F P
0 g
s
.963 .85 .436 r
.25868 .4264 m .25381 .38279 L .26535 .33716 L p F P
0 g
s
0 0 .15 r
.25381 .38279 m .25868 .4264 L .26637 .47422 L p F P
0 g
s
.841 .95 .597 r
.29735 .26645 m .2935 .29337 L .26535 .33716 L p F P
0 g
s
.81 1 .823 r
.2935 .29337 m .29735 .26645 L .32865 .23845 L p F P
0 g
s
.882 .539 .043 r
.61892 .34081 m .59776 .30075 L .60913 .34797 L p F P
0 g
s
.882 .539 .043 r
.60913 .34797 m .63037 .38785 L .61892 .34081 L p F P
0 g
s
.244 .682 .959 r
.36455 .57395 m .39962 .59274 L .4492 .59806 L p F P
0 g
s
0 .244 .63 r
.39962 .59274 m .36455 .57395 L .31949 .55012 L p F P
0 g
s
.098 .639 .848 r
.43754 .21763 m .40627 .20913 L .44374 .21124 L p F P
0 g
s
.098 .639 .848 r
.44374 .21124 m .48739 .22048 L .43754 .21763 L p F P
0 g
s
.707 .184 0 r
.56676 .2649 m .52847 .23862 L .55572 .27029 L p F P
0 g
s
.707 .184 0 r
.55572 .27029 m .59776 .30075 L .56676 .2649 L p F P
0 g
s
.948 .957 .676 r
.62128 .47731 m .62041 .44057 L .58977 .49236 L p F P
0 g
s
.948 .957 .676 r
.58977 .49236 m .59478 .52232 L .62128 .47731 L p F P
0 g
s
.841 .95 .597 r
.26535 .33716 m .27609 .29941 L .29735 .26645 L p F P
0 g
s
0 0 0 r
.27609 .29941 m .26535 .33716 L .25381 .38279 L p F P
0 g
s
.109 .433 .874 r
.29433 .51252 m .31949 .55012 L .36455 .57395 L p F P
0 g
s
0 0 .451 r
.31949 .55012 m .29433 .51252 L .26637 .47422 L p F P
0 g
s
.569 .858 .997 r
.42158 .57995 m .4492 .59806 L .50281 .5869 L p F P
0 g
s
.244 .682 .959 r
.4492 .59806 m .42158 .57995 L .36455 .57395 L p F P
0 g
s
.429 0 0 r
.48739 .22048 m .44374 .21124 L .47441 .22485 L p F P
0 g
s
.429 0 0 r
.47441 .22485 m .52847 .23862 L .48739 .22048 L p F P
0 g
s
0 .131 .661 r
.26062 .42499 m .26637 .47422 L .29433 .51252 L p F P
0 g
s
0 0 .15 r
.26637 .47422 m .26062 .42499 L .25381 .38279 L p F P
0 g
s
.872 .967 .854 r
.59478 .52232 m .58977 .49236 L .54207 .53645 L p F P
0 g
s
.872 .967 .854 r
.54207 .53645 m .55353 .56052 L .59478 .52232 L p F P
0 g
s
.996 .792 .512 r
.63037 .38785 m .60913 .34797 L .59885 .40102 L p F P
0 g
s
.996 .792 .512 r
.59885 .40102 m .62041 .44057 L .63037 .38785 L p F P
0 g
s
.75 .931 .947 r
.48343 .56697 m .50281 .5869 L .55353 .56052 L p F P
0 g
s
.569 .858 .997 r
.50281 .5869 m .48343 .56697 L .42158 .57995 L p F P
0 g
s
.75 .931 .947 r
.55353 .56052 m .54207 .53645 L .48343 .56697 L p F P
0 g
s
0 0 .377 r
.26745 .3336 m .25381 .38279 L .26062 .42499 L p F P
0 g
s
0 0 0 r
.25381 .38279 m .26745 .3336 L .27609 .29941 L p F P
0 g
s
.925 .558 .303 r
.59776 .30075 m .55572 .27029 L .56544 .31202 L p F P
0 g
s
.925 .558 .303 r
.56544 .31202 m .60913 .34797 L .59776 .30075 L p F P
0 g
s
.464 .663 .949 r
.33974 .53629 m .36455 .57395 L .42158 .57995 L p F P
0 g
s
.109 .433 .874 r
.36455 .57395 m .33974 .53629 L .29433 .51252 L p F P
0 g
s
.771 .283 .069 r
.52847 .23862 m .47441 .22485 L .4945 .24855 L p F P
0 g
s
.771 .283 .069 r
.4945 .24855 m .55572 .27029 L .52847 .23862 L p F P
0 g
s
.644 .936 .684 r
.32879 .22808 m .32865 .23845 L .29735 .26645 L p F P
0 g
s
.527 .918 .814 r
.32865 .23845 m .32879 .22808 L .34932 .21727 L p F P
0 g
s
.527 .918 .814 r
.34932 .21727 m .36638 .21859 L .32865 .23845 L p F P
0 g
s
.273 .778 .803 r
.36638 .21859 m .34932 .21727 L .37096 .21213 L p F P
0 g
s
.273 .778 .803 r
.37096 .21213 m .40627 .20913 L .36638 .21859 L p F P
0 g
s
.605 .806 .392 r
.31177 .24329 m .29735 .26645 L .27609 .29941 L p F P
0 g
s
.644 .936 .684 r
.29735 .26645 m .31177 .24329 L .32879 .22808 L p F P
0 g
s
.333 .449 .829 r
.28545 .45861 m .29433 .51252 L .33974 .53629 L p F P
0 g
s
0 .131 .661 r
.29433 .51252 m .28545 .45861 L .26062 .42499 L p F P
0 g
s
.941 .841 .717 r
.62041 .44057 m .59885 .40102 L .56767 .45324 L p F P
0 g
s
.941 .841 .717 r
.56767 .45324 m .58977 .49236 L .62041 .44057 L p F P
0 g
s
.129 0 0 r
.40627 .20913 m .37096 .21213 L .39119 .21328 L p F P
0 g
s
.129 0 0 r
.39119 .21328 m .44374 .21124 L .40627 .20913 L p F P
0 g
s
.183 .22 .665 r
.27267 .36502 m .26062 .42499 L .28545 .45861 L p F P
0 g
s
0 0 .377 r
.26062 .42499 m .27267 .36502 L .26745 .3336 L p F P
0 g
s
.605 .806 .392 r
.27609 .29941 m .30026 .26113 L .31177 .24329 L p F P
0 g
s
0 0 .055 r
.30026 .26113 m .27609 .29941 L .26745 .3336 L p F P
0 g
s
.648 .76 .931 r
.39732 .54208 m .42158 .57995 L .48343 .56697 L p F P
0 g
s
.464 .663 .949 r
.42158 .57995 m .39732 .54208 L .33974 .53629 L p F P
0 g
s
.925 .688 .56 r
.60913 .34797 m .56544 .31202 L .55595 .35888 L p F P
0 g
s
.925 .688 .56 r
.55595 .35888 m .59885 .40102 L .60913 .34797 L p F P
0 g
s
.538 0 0 r
.44374 .21124 m .39119 .21328 L .40758 .22064 L p F P
0 g
s
.538 0 0 r
.40758 .22064 m .47441 .22485 L .44374 .21124 L p F P
0 g
s
.866 .517 .39 r
.55572 .27029 m .4945 .24855 L .50136 .27969 L p F P
0 g
s
.866 .517 .39 r
.50136 .27969 m .56544 .31202 L .55572 .27029 L p F P
0 g
s
.86 .836 .821 r
.58977 .49236 m .56767 .45324 L .51927 .4978 L p F P
0 g
s
.86 .836 .821 r
.51927 .4978 m .54207 .53645 L .58977 .49236 L p F P
0 g
s
.767 .809 .887 r
.45988 .52875 m .48343 .56697 L .54207 .53645 L p F P
0 g
s
.648 .76 .931 r
.48343 .56697 m .45988 .52875 L .39732 .54208 L p F P
0 g
s
.004 0 .443 r
.29566 .27952 m .26745 .3336 L .27267 .36502 L p F P
0 g
s
0 0 .055 r
.26745 .3336 m .29566 .27952 L .30026 .26113 L p F P
0 g
s
.767 .809 .887 r
.54207 .53645 m .51927 .4978 L .45988 .52875 L p F P
0 g
s
.535 .595 .861 r
.32573 .47927 m .33974 .53629 L .39732 .54208 L p F P
0 g
s
.333 .449 .829 r
.33974 .53629 m .32573 .47927 L .28545 .45861 L p F P
0 g
s
.416 .434 .771 r
.29139 .38982 m .28545 .45861 L .32573 .47927 L p F P
0 g
s
.183 .22 .665 r
.28545 .45861 m .29139 .38982 L .27267 .36502 L p F P
0 g
s
.758 .309 .185 r
.47441 .22485 m .40758 .22064 L .41815 .2334 L p F P
0 g
s
.758 .309 .185 r
.41815 .2334 m .4945 .24855 L .47441 .22485 L p F P
0 g
s
.877 .727 .692 r
.59885 .40102 m .55595 .35888 L .52802 .40501 L p F P
0 g
s
.877 .727 .692 r
.52802 .40501 m .56767 .45324 L .59885 .40102 L p F P
0 g
s
.863 .617 .565 r
.56544 .31202 m .50136 .27969 L .49388 .31456 L p F P
0 g
s
.863 .617 .565 r
.49388 .31456 m .55595 .35888 L .56544 .31202 L p F P
0 g
s
.275 .25 .649 r
.29858 .29626 m .27267 .36502 L .29139 .38982 L p F P
0 g
s
.004 0 .443 r
.27267 .36502 m .29858 .29626 L .29566 .27952 L p F P
0 g
s
.658 .67 .85 r
.37679 .48403 m .39732 .54208 L .45988 .52875 L p F P
0 g
s
.535 .595 .861 r
.39732 .54208 m .37679 .48403 L .32573 .47927 L p F P
0 g
s
.826 .491 .421 r
.4945 .24855 m .41815 .2334 L .42154 .25006 L p F P
0 g
s
.826 .491 .421 r
.42154 .25006 m .50136 .27969 L .4945 .24855 L p F P
0 g
s
.522 .854 .574 r
.33254 .2217 m .32879 .22808 L .31177 .24329 L closepath p F P
0 g
s
.413 .844 .709 r
.33254 .2217 m .34932 .21727 L .32879 .22808 L closepath p F P
0 g
s
.817 .73 .769 r
.56767 .45324 m .52802 .40501 L .48495 .44443 L p F P
0 g
s
.817 .73 .769 r
.48495 .44443 m .51927 .4978 L .56767 .45324 L p F P
0 g
s
0 0 0 r
.33254 .2217 m .37096 .21213 L .34932 .21727 L closepath p F P
0 g
s
.558 .549 .8 r
.32161 .40484 m .32573 .47927 L .37679 .48403 L p F P
0 g
s
.416 .434 .771 r
.32573 .47927 m .32161 .40484 L .29139 .38982 L p F P
0 g
s
0 0 0 r
.33254 .2217 m .31177 .24329 L .30026 .26113 L closepath p F P
0 g
s
.222 0 0 r
.33254 .2217 m .39119 .21328 L .37096 .21213 L closepath p F P
0 g
s
.746 .711 .818 r
.43225 .47196 m .45988 .52875 L .51927 .4978 L p F P
0 g
s
.658 .67 .85 r
.45988 .52875 m .43225 .47196 L .37679 .48403 L p F P
0 g
s
.746 .711 .818 r
.51927 .4978 m .48495 .44443 L .43225 .47196 L p F P
0 g
s
0 0 .133 r
.33254 .2217 m .30026 .26113 L .29566 .27952 L closepath p F P
0 g
s
.45 .422 .736 r
.30875 .30934 m .29139 .38982 L .32161 .40484 L p F P
0 g
s
.275 .25 .649 r
.29139 .38982 m .30875 .30934 L .29858 .29626 L p F P
0 g
s
.83 .656 .667 r
.55595 .35888 m .49388 .31456 L .47274 .34885 L p F P
0 g
s
.83 .656 .667 r
.47274 .34885 m .52802 .40501 L .55595 .35888 L p F P
0 g
s
.566 .025 0 r
.33254 .2217 m .40758 .22064 L .39119 .21328 L closepath p F P
0 g
s
.828 .579 .562 r
.50136 .27969 m .42154 .25006 L .41728 .26864 L p F P
0 g
s
.828 .579 .562 r
.41728 .26864 m .49388 .31456 L .50136 .27969 L p F P
0 g
s
.081 .005 .462 r
.33254 .2217 m .29566 .27952 L .29858 .29626 L closepath p F P
0 g
s
.654 .613 .796 r
.35976 .40802 m .37679 .48403 L .43225 .47196 L p F P
0 g
s
.558 .549 .8 r
.37679 .48403 m .35976 .40802 L .32161 .40484 L p F P
0 g
s
.747 .315 .225 r
.33254 .2217 m .41815 .2334 L .40758 .22064 L closepath p F P
0 g
s
.784 .663 .731 r
.52802 .40501 m .47274 .34885 L .44047 .37818 L p F P
0 g
s
.784 .663 .731 r
.44047 .37818 m .48495 .44443 L .52802 .40501 L p F P
0 g
s
.567 .522 .765 r
.32501 .31711 m .32161 .40484 L .35976 .40802 L p F P
0 g
s
.45 .422 .736 r
.32161 .40484 m .32501 .31711 L .30875 .30934 L p F P
0 g
s
.309 .26 .64 r
.33254 .2217 m .29858 .29626 L .30875 .30934 L closepath p F P
0 g
s
.726 .649 .772 r
.40113 .39877 m .43225 .47196 L .48495 .44443 L p F P
0 g
s
.654 .613 .796 r
.43225 .47196 m .40113 .39877 L .35976 .40802 L p F P
0 g
s
.808 .479 .431 r
.33254 .2217 m .42154 .25006 L .41815 .2334 L closepath p F P
0 g
s
.803 .617 .651 r
.49388 .31456 m .41728 .26864 L .40581 .28686 L p F P
0 g
s
.803 .617 .651 r
.40581 .28686 m .47274 .34885 L .49388 .31456 L p F P
0 g
s
.726 .649 .772 r
.48495 .44443 m .44047 .37818 L .40113 .39877 L p F P
0 g
s
.463 .416 .72 r
.33254 .2217 m .30875 .30934 L .32501 .31711 L closepath p F P
0 g
s
.65 .581 .765 r
.34543 .31857 m .35976 .40802 L .40113 .39877 L p F P
0 g
s
.567 .522 .765 r
.35976 .40802 m .34543 .31857 L .32501 .31711 L p F P
0 g
s
.812 .562 .56 r
.33254 .2217 m .41728 .26864 L .42154 .25006 L closepath p F P
0 g
s
.763 .626 .708 r
.47274 .34885 m .40581 .28686 L .3885 .30246 L p F P
0 g
s
.763 .626 .708 r
.3885 .30246 m .44047 .37818 L .47274 .34885 L p F P
0 g
s
.569 .51 .749 r
.33254 .2217 m .32501 .31711 L .34543 .31857 L closepath p F P
0 g
s
.713 .614 .745 r
.36751 .31349 m .40113 .39877 L .44047 .37818 L p F P
0 g
s
.65 .581 .765 r
.40113 .39877 m .36751 .31349 L .34543 .31857 L p F P
0 g
s
.713 .614 .745 r
.44047 .37818 m .3885 .30246 L .36751 .31349 L p F P
0 g
s
.79 .599 .643 r
.33254 .2217 m .40581 .28686 L .41728 .26864 L closepath p F P
0 g
s
.647 .567 .75 r
.33254 .2217 m .34543 .31857 L .36751 .31349 L closepath p F P
0 g
s
.754 .609 .697 r
.33254 .2217 m .3885 .30246 L .40581 .28686 L closepath p F P
0 g
s
.707 .598 .732 r
.33254 .2217 m .36751 .31349 L .3885 .30246 L closepath p F P
0 g
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]],

Cell[TextData[{
  "On a computer with a notebook user interface for ",
  StyleBox["Mathematica", "TI"],
  ", such as a Microsoft Windows, Macintosh, or X Windows\[Hyphen]based \
computer, animations can be initiated by selecting a group of pictures and \
choosing the appropriate animation command in the front end. The utilities in \
this package can be used for the production of sequences of images. "
}], "Text",
  CellTags->{"S5.25.1", "1.13"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{550, 600},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.25.1"->{
    Cell[1776, 53, 139, 6, 70, "Subsection",
      CellTags->{"S5.25.1", "1.1"}],
    Cell[1918, 61, 252, 5, 70, "Text",
      CellTags->{"S5.25.1", "1.2"}],
    Cell[2173, 68, 295, 6, 70, "Text",
      CellTags->{"S5.25.1", "1.3"}],
    Cell[2471, 76, 3752, 86, 70, "DefinitionBox",
      CellTags->"S5.25.1"],
    Cell[6226, 164, 72, 1, 70, "Caption",
      CellTags->"S5.25.1"],
    Cell[6301, 167, 307, 7, 70, "Text",
      CellTags->{"S5.25.1", "1.4"}],
    Cell[6611, 176, 79, 1, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.5"}],
    Cell[6693, 179, 86, 2, 70, "Input",
      CellTags->"S5.25.1"],
    Cell[6782, 183, 129, 4, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.6"}],
    Cell[6936, 191, 141, 5, 70, "Input",
      CellTags->"S5.25.1"],
    Cell[7080, 198, 63616, 4065, 70, 63542, 4062, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[70711, 4266, 279, 8, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.7"}],
    Cell[71015, 4278, 193, 5, 70, "Input",
      CellTags->"S5.25.1"],
    Cell[71211, 4285, 8346, 551, 70, 8272, 548, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[79572, 4839, 277, 8, 70, "Text",
      CellTags->{"S5.25.1", "1.8"}],
    Cell[79852, 4849, 14541, 346, 70, "DefinitionBox",
      CellTags->"S5.25.1"],
    Cell[94396, 5197, 70, 1, 70, "Caption",
      CellTags->"S5.25.1"],
    Cell[94469, 5200, 407, 10, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.9"}],
    Cell[94901, 5214, 278, 9, 70, "Input",
      CellTags->"S5.25.1"],
    Cell[95204, 5227, 7425, 476, 70, 7351, 473, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[102632, 5705, 7344, 470, 70, 7270, 467, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[109979, 6177, 7183, 459, 70, 7109, 456, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[117165, 6638, 7359, 470, 70, 7285, 467, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[124527, 7110, 7250, 464, 70, 7176, 461, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[131780, 7576, 7427, 475, 70, 7353, 472, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[139210, 8053, 7326, 469, 70, 7252, 466, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[146539, 8524, 7267, 465, 70, 7193, 462, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[153809, 8991, 7385, 473, 70, 7311, 470, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[161197, 9466, 7425, 476, 70, 7351, 473, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[168649, 9946, 4606, 103, 70, "DefinitionBox3Col",
      CellTags->"S5.25.1"],
    Cell[173258, 10051, 106, 5, 70, "Caption",
      CellTags->"S5.25.1"],
    Cell[173367, 10058, 920, 24, 70, "Text",
      CellTags->{"S5.25.1", "1.10"}],
    Cell[174290, 10084, 108, 1, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.11"}],
    Cell[174423, 10089, 201, 7, 70, "Input",
      CellTags->"S5.25.1"],
    Cell[174627, 10098, 145964, 7351, 70, 145890, 7348, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[320594, 17451, 180, 5, 70, "Output",
      CellTags->"S5.25.1"],
    Cell[320789, 17459, 337, 7, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.12"}],
    Cell[321151, 17470, 139, 5, 70, "Input",
      CellTags->"S5.25.1"],
    Cell[321293, 17477, 445032, 23359, 70, 444958, 23356, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.25.1"],
    Cell[766340, 40839, 449, 8, 70, "Text",
      CellTags->{"S5.25.1", "1.13"}]},
  "1.1"->{
    Cell[1776, 53, 139, 6, 70, "Subsection",
      CellTags->{"S5.25.1", "1.1"}]},
  "1.2"->{
    Cell[1918, 61, 252, 5, 70, "Text",
      CellTags->{"S5.25.1", "1.2"}]},
  "1.3"->{
    Cell[2173, 68, 295, 6, 70, "Text",
      CellTags->{"S5.25.1", "1.3"}]},
  "1.4"->{
    Cell[6301, 167, 307, 7, 70, "Text",
      CellTags->{"S5.25.1", "1.4"}]},
  "1.5"->{
    Cell[6611, 176, 79, 1, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.5"}]},
  "1.6"->{
    Cell[6782, 183, 129, 4, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.6"}]},
  "1.7"->{
    Cell[70711, 4266, 279, 8, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.7"}]},
  "1.8"->{
    Cell[79572, 4839, 277, 8, 70, "Text",
      CellTags->{"S5.25.1", "1.8"}]},
  "1.9"->{
    Cell[94469, 5200, 407, 10, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.9"}]},
  "1.10"->{
    Cell[173367, 10058, 920, 24, 70, "Text",
      CellTags->{"S5.25.1", "1.10"}]},
  "1.11"->{
    Cell[174290, 10084, 108, 1, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.11"}]},
  "1.12"->{
    Cell[320789, 17459, 337, 7, 70, "MathCaption",
      CellTags->{"S5.25.1", "1.12"}]},
  "1.13"->{
    Cell[766340, 40839, 449, 8, 70, "Text",
      CellTags->{"S5.25.1", "1.13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.25.1", 767418, 40866},
  {"1.1", 771638, 40975},
  {"1.2", 771732, 40978},
  {"1.3", 771820, 40981},
  {"1.4", 771908, 40984},
  {"1.5", 771997, 40987},
  {"1.6", 772092, 40990},
  {"1.7", 772188, 40993},
  {"1.8", 772286, 40996},
  {"1.9", 772377, 40999},
  {"1.10", 772477, 41002},
  {"1.11", 772573, 41005},
  {"1.12", 772675, 41008},
  {"1.13", 772777, 41011}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 6, 70, "Subsection",
  CellTags->{"S5.25.1", "1.1"}],
Cell[1918, 61, 252, 5, 70, "Text",
  CellTags->{"S5.25.1", "1.2"}],
Cell[2173, 68, 295, 6, 70, "Text",
  CellTags->{"S5.25.1", "1.3"}],
Cell[2471, 76, 3752, 86, 70, "DefinitionBox",
  CellTags->"S5.25.1"],
Cell[6226, 164, 72, 1, 70, "Caption",
  CellTags->"S5.25.1"],
Cell[6301, 167, 307, 7, 70, "Text",
  CellTags->{"S5.25.1", "1.4"}],
Cell[6611, 176, 79, 1, 70, "MathCaption",
  CellTags->{"S5.25.1", "1.5"}],
Cell[6693, 179, 86, 2, 70, "Input",
  CellTags->"S5.25.1"],
Cell[6782, 183, 129, 4, 70, "MathCaption",
  CellTags->{"S5.25.1", "1.6"}],

Cell[CellGroupData[{
Cell[6936, 191, 141, 5, 70, "Input",
  CellTags->"S5.25.1"],
Cell[7080, 198, 63616, 4065, 70, 63542, 4062, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]],
Cell[70711, 4266, 279, 8, 70, "MathCaption",
  CellTags->{"S5.25.1", "1.7"}],

Cell[CellGroupData[{
Cell[71015, 4278, 193, 5, 70, "Input",
  CellTags->"S5.25.1"],
Cell[71211, 4285, 8346, 551, 70, 8272, 548, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]],
Cell[79572, 4839, 277, 8, 70, "Text",
  CellTags->{"S5.25.1", "1.8"}],
Cell[79852, 4849, 14541, 346, 70, "DefinitionBox",
  CellTags->"S5.25.1"],
Cell[94396, 5197, 70, 1, 70, "Caption",
  CellTags->"S5.25.1"],
Cell[94469, 5200, 407, 10, 70, "MathCaption",
  CellTags->{"S5.25.1", "1.9"}],

Cell[CellGroupData[{
Cell[94901, 5214, 278, 9, 70, "Input",
  CellTags->"S5.25.1"],

Cell[CellGroupData[{
Cell[95204, 5227, 7425, 476, 70, 7351, 473, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[102632, 5705, 7344, 470, 70, 7270, 467, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[109979, 6177, 7183, 459, 70, 7109, 456, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[117165, 6638, 7359, 470, 70, 7285, 467, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[124527, 7110, 7250, 464, 70, 7176, 461, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[131780, 7576, 7427, 475, 70, 7353, 472, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[139210, 8053, 7326, 469, 70, 7252, 466, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[146539, 8524, 7267, 465, 70, 7193, 462, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[153809, 8991, 7385, 473, 70, 7311, 470, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[161197, 9466, 7425, 476, 70, 7351, 473, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]]
}, Open  ]],
Cell[168649, 9946, 4606, 103, 70, "DefinitionBox3Col",
  CellTags->"S5.25.1"],
Cell[173258, 10051, 106, 5, 70, "Caption",
  CellTags->"S5.25.1"],
Cell[173367, 10058, 920, 24, 70, "Text",
  CellTags->{"S5.25.1", "1.10"}],
Cell[174290, 10084, 108, 1, 70, "MathCaption",
  CellTags->{"S5.25.1", "1.11"}],

Cell[CellGroupData[{
Cell[174423, 10089, 201, 7, 70, "Input",
  CellTags->"S5.25.1"],
Cell[174627, 10098, 145964, 7351, 70, 145890, 7348, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"],
Cell[320594, 17451, 180, 5, 70, "Output",
  CellTags->"S5.25.1"]
}, Open  ]],
Cell[320789, 17459, 337, 7, 70, "MathCaption",
  CellTags->{"S5.25.1", "1.12"}],

Cell[CellGroupData[{
Cell[321151, 17470, 139, 5, 70, "Input",
  CellTags->"S5.25.1"],
Cell[321293, 17477, 445032, 23359, 70, 444958, 23356, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.25.1"]
}, Open  ]],
Cell[766340, 40839, 449, 8, 70, "Text",
  CellTags->{"S5.25.1", "1.13"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

