(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    169732,       7698]*)
(*NotebookOutlinePosition[    192500,       8351]*)
(*  CellTagsIndexPosition[    190588,       8274]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "Approximations",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.76.1", "1.1"}],

Cell[TextData[{
 "A degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["m",
      "TI"], ",", 
     StyleBox["k",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " rational function is the ratio of a degree ",
 StyleBox["m", "TI"],
 " polynomial to a degree ",
 StyleBox["k", "TI"],
 " polynomial. Because rational functions only use the elementary arithmetic \
operations, they are very easy to evaluate numerically. The polynomial in the \
denominator allows you to approximate functions that have rational \
singularities. For these reasons a rational function is frequently useful in \
numerical work to approximate a given function. "
}], "Text",
 CellTags->{"S5.76.1", "1.2"}],

Cell[TextData[{
 "There are various methods to perform this approximation. The methods differ \
in how they interpret the notion of the goodness of the approximation. Each \
method is useful for certain classes of problems. You can use this package to \
compute general rational interpolations and minimax approximations. The \
package ",
 StyleBox["Calculus`Pade`", "MR"],
 " contains functions that perform Pad\[EAcute] approximations and economized \
rational approximations. "
}], "Text",
 CellTags->{"S5.76.1", "1.3"}],

Cell[TextData[{
 "There is a related class of approximation questions that involves the \
interpolation or fitting of a set of data points by an approximating \
function. In this type of situation you should use the built\[Hyphen]in \
functions ",
 StyleBox["Fit", "MR"],
 ", ",
 StyleBox["InterpolatingPolynomial", "MR"],
 ", and ",
 StyleBox["Interpolation", "MR"],
 ". For more information, see the section covering numerical operations on \
data in ",
 StyleBox["The Mathematica Book", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RationalInterpolation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         RowBox[{
          StyleBox["m",
           "TI"], "+", 
          StyleBox["k",
           "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a rational interpolation of degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["m",
           "TI"], 
          RowBox[{",", " "}], 
          StyleBox["k",
           "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to the points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox[
           StyleBox["x",
            "TI"], 
           StyleBox["i",
            "TI"]], 
          RowBox[{",", " "}], 
          StyleBox["f",
           "TI"], 
          RowBox[{"(", 
           SubscriptBox[
            StyleBox["x",
             "TI"], 
            StyleBox["i",
             "TI"]], ")"}]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RationalInterpolation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a rational interpolation with the points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" chosen automatically",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.76.1"],

Cell["Rational interpolations. ", "Caption",
 CellTags->"S5.76.1"],

Cell[TextData[{
 "One way to approximate a given function by a rational function is to choose \
a set of values for the independent variable and then construct a rational \
function that agrees with the given function at this set of values. This is \
what is done by ",
 StyleBox["RationalInterpolation", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.5"}],

Cell[TextData[{
 "There are two ways of using ",
 StyleBox["RationalInterpolation", "MR"],
 ". If you just specify a range in the independent variable, then the set of \
values is chosen automatically in a way that ensures a reasonable \
approximation for the degree of approximation you have chosen. You can also \
give an explicit list of the set of values to be used. Note that in this case \
if you ask for a degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["m",
      "TI"], ",", 
     StyleBox["k",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]approximation, you must specify a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m",
     "TI"], "+", 
    StyleBox["k",
     "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " values for the independent variable. "
}], "Text",
 CellTags->{"S5.76.1", "1.6"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.76.1", "1.7"}],

Cell["<<NumericalMath`Approximations`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.76.1"],

Cell[TextData[{
 "This gives a rational interpolation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "4"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at 7 equally spaced points between 0 and 2. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
ri1 = RationalInterpolation[
        Exp[x], {x, 2, 4},
        {0, 1/3, 2/3, 1, 4/3, 5/3, 2}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"1.`", "\[InvisibleSpace]"}], "+", 
   RowBox[{"0.3799615059957821`", " ", "x"}], "+", 
   RowBox[{"0.04695275726402285`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6200285166930014`", " ", "x"}], "+", 
   RowBox[{"0.16691391444469306`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.023405766183479563`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0014527901993652353`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["\<\
This plots the difference between the function and its approximation. Note \
that the error tends to get larger near the endpoints. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.9"}],

Cell[CellGroupData[{

Cell["Plot[ri1 - Exp[x], {x, 0, 2}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.222446 272629 [
[.2619 .20995 -9 -9 ]
[.2619 .20995 9 0 ]
[.5 .20995 -3 -9 ]
[.5 .20995 3 0 ]
[.7381 .20995 -9 -9 ]
[.7381 .20995 9 0 ]
[.97619 .20995 -3 -9 ]
[.97619 .20995 3 0 ]
[.01131 .08613 -39 -6.25 ]
[.01131 .08613 0 6.25 ]
[.01131 .35876 -33 -6.25 ]
[.01131 .35876 0 6.25 ]
[.01131 .49508 -33 -6.25 ]
[.01131 .49508 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .22245 m
.2619 .2287 L
s
[(0.5)] .2619 .20995 0 1 Mshowa
.5 .22245 m
.5 .2287 L
s
[(1)] .5 .20995 0 1 Mshowa
.7381 .22245 m
.7381 .2287 L
s
[(1.5)] .7381 .20995 0 1 Mshowa
.97619 .22245 m
.97619 .2287 L
s
[(2)] .97619 .20995 0 1 Mshowa
.125 Mabswid
.07143 .22245 m
.07143 .2262 L
s
.11905 .22245 m
.11905 .2262 L
s
.16667 .22245 m
.16667 .2262 L
s
.21429 .22245 m
.21429 .2262 L
s
.30952 .22245 m
.30952 .2262 L
s
.35714 .22245 m
.35714 .2262 L
s
.40476 .22245 m
.40476 .2262 L
s
.45238 .22245 m
.45238 .2262 L
s
.54762 .22245 m
.54762 .2262 L
s
.59524 .22245 m
.59524 .2262 L
s
.64286 .22245 m
.64286 .2262 L
s
.69048 .22245 m
.69048 .2262 L
s
.78571 .22245 m
.78571 .2262 L
s
.83333 .22245 m
.83333 .2262 L
s
.88095 .22245 m
.88095 .2262 L
s
.92857 .22245 m
.92857 .2262 L
s
.25 Mabswid
0 .22245 m
1 .22245 L
s
.02381 .08613 m
.03006 .08613 L
s
gsave
.01131 .08613 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .35876 m
.03006 .35876 L
s
gsave
.01131 .35876 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .49508 m
.03006 .49508 L
s
gsave
.01131 .49508 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.125 Mabswid
.02381 .11339 m
.02756 .11339 L
s
.02381 .14066 m
.02756 .14066 L
s
.02381 .16792 m
.02756 .16792 L
s
.02381 .19518 m
.02756 .19518 L
s
.02381 .24971 m
.02756 .24971 L
s
.02381 .27697 m
.02756 .27697 L
s
.02381 .30424 m
.02756 .30424 L
s
.02381 .3315 m
.02756 .3315 L
s
.02381 .38602 m
.02756 .38602 L
s
.02381 .41329 m
.02756 .41329 L
s
.02381 .44055 m
.02756 .44055 L
s
.02381 .46781 m
.02756 .46781 L
s
.02381 .05887 m
.02756 .05887 L
s
.02381 .03161 m
.02756 .03161 L
s
.02381 .00434 m
.02756 .00434 L
s
.02381 .52234 m
.02756 .52234 L
s
.02381 .5496 m
.02756 .5496 L
s
.02381 .57686 m
.02756 .57686 L
s
.02381 .60413 m
.02756 .60413 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .22245 m
.03279 .17688 L
.04262 .13905 L
.04758 .12427 L
.05288 .11135 L
.05785 .10176 L
.06244 .0949 L
.06503 .09182 L
.06788 .08905 L
.07075 .0869 L
.07233 .08597 L
.07379 .08527 L
.07506 .08477 L
.07645 .08436 L
.07722 .08418 L
.07792 .08406 L
.0786 .08396 L
.07932 .0839 L
.07999 .08386 L
.08072 .08386 L
.08204 .08393 L
.08333 .08409 L
.08451 .08432 L
.08567 .08463 L
.08691 .08504 L
.08916 .08598 L
.09183 .08742 L
.09427 .08903 L
.10458 .09854 L
.11449 .11103 L
.12366 .12469 L
.14443 .15972 L
.16468 .19461 L
.18369 .22409 L
.20186 .24694 L
.21207 .25698 L
.22144 .26425 L
.22618 .26721 L
.23125 .26983 L
.23562 .27166 L
.24037 .27317 L
.24327 .27386 L
.24454 .27411 L
.24594 .27435 L
.24718 .27452 L
.2485 .27467 L
.24923 .27474 L
.2499 .27479 L
.25121 .27487 L
.25247 .27491 L
Mistroke
.25363 .27492 L
.25491 .2749 L
.25562 .27488 L
.25627 .27485 L
.25746 .27477 L
.25874 .27466 L
.26107 .27437 L
.26345 .27397 L
.266 .27344 L
.2706 .27218 L
.27606 .27023 L
.28104 .26804 L
.30212 .25517 L
.34202 .22179 L
.36028 .20648 L
.37066 .19867 L
.3804 .19224 L
.39074 .18657 L
.40021 .18259 L
.40515 .18102 L
.41034 .17976 L
.41304 .17928 L
.41555 .17892 L
.41699 .17877 L
.4183 .17865 L
.41902 .1786 L
.41981 .17855 L
.42055 .17852 L
.42124 .17849 L
.42249 .17847 L
.42369 .17847 L
.42476 .17849 L
.42592 .17854 L
.42719 .17861 L
.42854 .17871 L
.43095 .17898 L
.43318 .17931 L
.43527 .17969 L
.44004 .18082 L
.44522 .18247 L
.44997 .18436 L
.46069 .18989 L
.47959 .2035 L
.50028 .22273 L
.52151 .24476 L
.54081 .26417 L
.55043 .27276 L
.56087 .28072 L
.56566 .28378 L
.57073 .28656 L
Mistroke
.57539 .28865 L
.57982 .29019 L
.58218 .29082 L
.58342 .2911 L
.58474 .29136 L
.58597 .29155 L
.58708 .2917 L
.58819 .29181 L
.58924 .29189 L
.59048 .29194 L
.59178 .29195 L
.59289 .29192 L
.59411 .29185 L
.59543 .29173 L
.59683 .29155 L
.59816 .29132 L
.59937 .29107 L
.60388 .28976 L
.60642 .28875 L
.60878 .28764 L
.61768 .28187 L
.62232 .27785 L
.62732 .27274 L
.63636 .26143 L
.65697 .22605 L
.69813 .12595 L
.71867 .07339 L
.72868 .05107 L
.73777 .03426 L
.74232 .02746 L
.74726 .02154 L
.74952 .01939 L
.75192 .01753 L
.75396 .0163 L
.75504 .01579 L
.75621 .01534 L
.75752 .01498 L
.75877 .01478 L
.75999 .01472 L
.76112 .01478 L
.76181 .01488 L
.76245 .01502 L
.76367 .01538 L
.76497 .01594 L
.76638 .01673 L
.7688 .01858 L
.77134 .02121 L
.7759 .02776 L
.78088 .03781 L
.78541 .04975 L
Mistroke
.79559 .08707 L
.80502 .13574 L
.81394 .19522 L
.83391 .37862 L
.85234 .60892 L
Mfstroke
.85234 .60892 m
.85294 .61803 L
s
.97022 .61803 m
.97619 .22245 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "Here ",
 StyleBox["Mathematica", "TI"],
 " automatically chooses the interpolation points. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
ri2 =
     RationalInterpolation[Exp[x],
                {x, 2, 4}, {x, 0, 2}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"1.0000001575579671`", "\[InvisibleSpace]"}], "+", 
   RowBox[{"0.37982664361283597`", " ", "x"}], "+", 
   RowBox[{"0.046869321581514634`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6201657303890787`", " ", "x"}], "+", 
   RowBox[{"0.16697788163174573`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.023411894978914667`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0014519160958339408`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["\<\
The interpolation points are somewhat more bunched at the ends of the \
interval. This usually results in a smaller maximum error. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
Plot[ri2 - Exp[x],
          {x, 0, 2}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.328263 150181 [
[.2619 .31576 -9 -9 ]
[.2619 .31576 9 0 ]
[.5 .31576 -3 -9 ]
[.5 .31576 3 0 ]
[.7381 .31576 -9 -9 ]
[.7381 .31576 9 0 ]
[.97619 .31576 -3 -9 ]
[.97619 .31576 3 0 ]
[.01131 .0279 -39 -6.25 ]
[.01131 .0279 0 6.25 ]
[.01131 .17808 -39 -6.25 ]
[.01131 .17808 0 6.25 ]
[.01131 .47844 -33 -6.25 ]
[.01131 .47844 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .32826 m
.2619 .33451 L
s
[(0.5)] .2619 .31576 0 1 Mshowa
.5 .32826 m
.5 .33451 L
s
[(1)] .5 .31576 0 1 Mshowa
.7381 .32826 m
.7381 .33451 L
s
[(1.5)] .7381 .31576 0 1 Mshowa
.97619 .32826 m
.97619 .33451 L
s
[(2)] .97619 .31576 0 1 Mshowa
.125 Mabswid
.07143 .32826 m
.07143 .33201 L
s
.11905 .32826 m
.11905 .33201 L
s
.16667 .32826 m
.16667 .33201 L
s
.21429 .32826 m
.21429 .33201 L
s
.30952 .32826 m
.30952 .33201 L
s
.35714 .32826 m
.35714 .33201 L
s
.40476 .32826 m
.40476 .33201 L
s
.45238 .32826 m
.45238 .33201 L
s
.54762 .32826 m
.54762 .33201 L
s
.59524 .32826 m
.59524 .33201 L
s
.64286 .32826 m
.64286 .33201 L
s
.69048 .32826 m
.69048 .33201 L
s
.78571 .32826 m
.78571 .33201 L
s
.83333 .32826 m
.83333 .33201 L
s
.88095 .32826 m
.88095 .33201 L
s
.92857 .32826 m
.92857 .33201 L
s
.25 Mabswid
0 .32826 m
1 .32826 L
s
.02381 .0279 m
.03006 .0279 L
s
gsave
.01131 .0279 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.02381 .17808 m
.03006 .17808 L
s
gsave
.01131 .17808 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.02381 .47844 m
.03006 .47844 L
s
gsave
.01131 .47844 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.125 Mabswid
.02381 .05794 m
.02756 .05794 L
s
.02381 .08797 m
.02756 .08797 L
s
.02381 .11801 m
.02756 .11801 L
s
.02381 .14805 m
.02756 .14805 L
s
.02381 .20812 m
.02756 .20812 L
s
.02381 .23815 m
.02756 .23815 L
s
.02381 .26819 m
.02756 .26819 L
s
.02381 .29823 m
.02756 .29823 L
s
.02381 .3583 m
.02756 .3583 L
s
.02381 .38834 m
.02756 .38834 L
s
.02381 .41837 m
.02756 .41837 L
s
.02381 .44841 m
.02756 .44841 L
s
.02381 .50848 m
.02756 .50848 L
s
.02381 .53852 m
.02756 .53852 L
s
.02381 .56855 m
.02756 .56855 L
s
.02381 .59859 m
.02756 .59859 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .35193 m
.03279 .3333 L
.04262 .31852 L
.04758 .31304 L
.05288 .30849 L
.05546 .30673 L
.05789 .30532 L
.06244 .30332 L
.06487 .30257 L
.06627 .30223 L
.06754 .30197 L
.06889 .30176 L
.06958 .30168 L
.07034 .3016 L
.07103 .30155 L
.07168 .30151 L
.07295 .30148 L
.07422 .30149 L
.07541 .30154 L
.07648 .30162 L
.07764 .30174 L
.07891 .30191 L
.08025 .30214 L
.08265 .30265 L
.08806 .30428 L
.0931 .30631 L
.10458 .31241 L
.14349 .33964 L
.1633 .35226 L
.17375 .3576 L
.17947 .36003 L
.18485 .36198 L
.18998 .36351 L
.19469 .36462 L
.19991 .36553 L
.20266 .36587 L
.20404 .366 L
.20555 .36611 L
.20684 .36619 L
.20806 .36624 L
.20915 .36627 L
.21034 .36628 L
.21164 .36628 L
.21229 .36627 L
.21301 .36625 L
.21428 .3662 L
.21547 .36613 L
.21779 .36595 L
.21991 .36573 L
.22469 .365 L
Mistroke
.22948 .36399 L
.23457 .36261 L
.24372 .35936 L
.2546 .35429 L
.26446 .34871 L
.30457 .31939 L
.34318 .28944 L
.36315 .27698 L
.37321 .27211 L
.37887 .26986 L
.38423 .26808 L
.38914 .26678 L
.39172 .26622 L
.39446 .26573 L
.39677 .26539 L
.39799 .26524 L
.39931 .26511 L
.40051 .265 L
.40162 .26493 L
.40267 .26487 L
.40378 .26483 L
.4051 .2648 L
.40629 .2648 L
.40695 .26481 L
.40767 .26482 L
.40897 .26487 L
.41018 .26494 L
.41147 .26503 L
.41378 .26526 L
.41647 .26564 L
.41899 .26608 L
.42471 .26746 L
.4297 .26907 L
.43514 .27125 L
.44504 .27637 L
.46359 .2898 L
.48334 .30898 L
.50434 .33362 L
.54205 .38237 L
.563 .40735 L
.57218 .41684 L
.58222 .42581 L
.59197 .4328 L
.59664 .43547 L
.60105 .43756 L
.60345 .4385 L
.60607 .43938 L
.60824 .43998 L
.61063 .4405 L
.61188 .44072 L
Mistroke
.61322 .44091 L
.61396 .44099 L
.61464 .44105 L
.61532 .4411 L
.61596 .44114 L
.61717 .44118 L
.61848 .44118 L
.61964 .44114 L
.62088 .44106 L
.62212 .44094 L
.62349 .44075 L
.62491 .4405 L
.62624 .44022 L
.63118 .43872 L
.63399 .43754 L
.63655 .43627 L
.64231 .43271 L
.65267 .42376 L
.66248 .41231 L
.68241 .3804 L
.70083 .34182 L
.74012 .24299 L
.75983 .19514 L
.76845 .17698 L
.77789 .16017 L
.78732 .1474 L
.78981 .14482 L
.79247 .14246 L
.79496 .14064 L
.79725 .13931 L
.79854 .13871 L
.79995 .13818 L
.80137 .13779 L
.80215 .13763 L
.80287 .13752 L
.80356 .13746 L
.80421 .13742 L
.80543 .13745 L
.80675 .13759 L
.80749 .13773 L
.80818 .13789 L
.80948 .13831 L
.81071 .13881 L
.81299 .14007 L
.81545 .14188 L
.81811 .1444 L
.82305 .15063 L
.82765 .15833 L
.8381 .18278 L
.84829 .21602 L
Mistroke
.85919 .26154 L
.87905 .36652 L
.90062 .494 L
.91069 .54688 L
.91621 .57069 L
.9189 .58048 L
.92137 .58814 L
.92347 .59358 L
.92576 .59826 L
.92702 .60022 L
.92819 .60163 L
.9293 .6026 L
.93049 .6032 L
.93179 .60332 L
.93253 .60313 L
.9332 .60278 L
.93445 .60171 L
.93576 .59994 L
.93694 .59776 L
.93804 .5952 L
.94054 .5874 L
.94292 .57724 L
.94512 .56527 L
.95011 .52808 L
.95451 .48223 L
.95918 .41814 L
.96727 .26351 L
.97187 .14656 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "number of digits of precision to use",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Bias", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "bias in the automatic choice of interpolation points",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.76.1"],

Cell["Options for rational approximations.", "Caption",
 CellTags->"S5.76.1"],

Cell[TextData[{
 "When you specify a range of ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " values for ",
 StyleBox["RationalInterpolation", "MR"],
 ", the interpolation points are chosen automatically. The option ",
 StyleBox["Bias", "MR"],
 " allows you to bias the interpolation points to the right or to the left. \
Values for ",
 StyleBox["Bias", "MR"],
 " must be numbers between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". A positive value causes the points to be biased to the right. The default \
is ",
 StyleBox["Bias", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["0", "MR"],
 ", which causes the points to be symmetrically distributed. "
}], "Text",
 CellTags->{"S5.76.1", "1.12"}],

Cell["\<\
When you bias the distribution of the points to the right, you get smaller \
errors there and larger errors to the left. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
ri3 = RationalInterpolation[
       Exp[x], {x, 2, 4}, {x, 0, 2},
                  Bias -> .25]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"1.0000006809167996`", "\[InvisibleSpace]"}], "+", 
   RowBox[{"0.38618559512251105`", " ", "x"}], "+", 
   RowBox[{"0.04915261155383016`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6137919183642835`", " ", "x"}], "+", 
   RowBox[{"0.1628204893737883`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.02234036054890879`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0013435969423323056`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["This shows the influence of the bias. ", "MathCaption",
 CellTags->{"S5.76.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
Plot[ri3 - Exp[x],
             {x, 0, 2}]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.303824 401726 [
[.2619 .29132 -9 -9 ]
[.2619 .29132 9 0 ]
[.5 .29132 -3 -9 ]
[.5 .29132 3 0 ]
[.7381 .29132 -9 -9 ]
[.7381 .29132 9 0 ]
[.97619 .29132 -3 -9 ]
[.97619 .29132 3 0 ]
[.01131 .06279 -39 -6.25 ]
[.01131 .06279 0 6.25 ]
[.01131 .14313 -39 -6.25 ]
[.01131 .14313 0 6.25 ]
[.01131 .22348 -39 -6.25 ]
[.01131 .22348 0 6.25 ]
[.01131 .38417 -33 -6.25 ]
[.01131 .38417 0 6.25 ]
[.01131 .46451 -33 -6.25 ]
[.01131 .46451 0 6.25 ]
[.01131 .54486 -33 -6.25 ]
[.01131 .54486 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30382 m
.2619 .31007 L
s
[(0.5)] .2619 .29132 0 1 Mshowa
.5 .30382 m
.5 .31007 L
s
[(1)] .5 .29132 0 1 Mshowa
.7381 .30382 m
.7381 .31007 L
s
[(1.5)] .7381 .29132 0 1 Mshowa
.97619 .30382 m
.97619 .31007 L
s
[(2)] .97619 .29132 0 1 Mshowa
.125 Mabswid
.07143 .30382 m
.07143 .30757 L
s
.11905 .30382 m
.11905 .30757 L
s
.16667 .30382 m
.16667 .30757 L
s
.21429 .30382 m
.21429 .30757 L
s
.30952 .30382 m
.30952 .30757 L
s
.35714 .30382 m
.35714 .30757 L
s
.40476 .30382 m
.40476 .30757 L
s
.45238 .30382 m
.45238 .30757 L
s
.54762 .30382 m
.54762 .30757 L
s
.59524 .30382 m
.59524 .30757 L
s
.64286 .30382 m
.64286 .30757 L
s
.69048 .30382 m
.69048 .30757 L
s
.78571 .30382 m
.78571 .30757 L
s
.83333 .30382 m
.83333 .30757 L
s
.88095 .30382 m
.88095 .30757 L
s
.92857 .30382 m
.92857 .30757 L
s
.25 Mabswid
0 .30382 m
1 .30382 L
s
.02381 .06279 m
.03006 .06279 L
s
gsave
.01131 .06279 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .14313 m
.03006 .14313 L
s
gsave
.01131 .14313 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .22348 m
.03006 .22348 L
s
gsave
.01131 .22348 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .38417 m
.03006 .38417 L
s
gsave
.01131 .38417 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .46451 m
.03006 .46451 L
s
gsave
.01131 .46451 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .54486 m
.03006 .54486 L
s
gsave
.01131 .54486 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.125 Mabswid
.02381 .08288 m
.02756 .08288 L
s
.02381 .10296 m
.02756 .10296 L
s
.02381 .12305 m
.02756 .12305 L
s
.02381 .16322 m
.02756 .16322 L
s
.02381 .18331 m
.02756 .18331 L
s
.02381 .20339 m
.02756 .20339 L
s
.02381 .24357 m
.02756 .24357 L
s
.02381 .26365 m
.02756 .26365 L
s
.02381 .28374 m
.02756 .28374 L
s
.02381 .32391 m
.02756 .32391 L
s
.02381 .344 m
.02756 .344 L
s
.02381 .36408 m
.02756 .36408 L
s
.02381 .40426 m
.02756 .40426 L
s
.02381 .42434 m
.02756 .42434 L
s
.02381 .44443 m
.02756 .44443 L
s
.02381 .4846 m
.02756 .4846 L
s
.02381 .50469 m
.02756 .50469 L
s
.02381 .52477 m
.02756 .52477 L
s
.02381 .0427 m
.02756 .0427 L
s
.02381 .02262 m
.02756 .02262 L
s
.02381 .00253 m
.02756 .00253 L
s
.02381 .56495 m
.02756 .56495 L
s
.02381 .58503 m
.02756 .58503 L
s
.02381 .60512 m
.02756 .60512 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57737 m
.03279 .42553 L
.04262 .29203 L
.05288 .18549 L
.06244 .11306 L
.06792 .08201 L
.0731 .05906 L
.07775 .04337 L
.08036 .0365 L
.0828 .03124 L
.08542 .02684 L
.08692 .02486 L
.0883 .02339 L
.08974 .02219 L
.09111 .02137 L
.09185 .02106 L
.09255 .02084 L
.09331 .02069 L
.09413 .02063 L
.09483 .02066 L
.09548 .02075 L
.0962 .02092 L
.09695 .02119 L
.09822 .02182 L
.09961 .02278 L
.10218 .02524 L
.10458 .02832 L
.10959 .03703 L
.11503 .04969 L
.12493 .07997 L
.14349 .15539 L
.18427 .3541 L
.20452 .44529 L
.22354 .51579 L
.23239 .54222 L
.2417 .56516 L
.24658 .57509 L
.25192 .58426 L
.25641 .59059 L
.26129 .59602 L
.26404 .59842 L
.26657 .60021 L
.269 .60154 L
.27023 .60208 L
.27156 .60255 L
.27276 .60288 L
.27386 .6031 L
.27496 .60325 L
.27601 .60332 L
.27722 .60331 L
Mistroke
.27835 .60323 L
.27958 .60304 L
.2809 .60275 L
.28232 .6023 L
.28362 .60179 L
.28656 .60025 L
.28916 .59847 L
.29189 .59616 L
.29664 .59111 L
.30185 .58411 L
.31208 .56611 L
.3214 .54515 L
.34232 .48452 L
.38222 .33519 L
.4206 .18522 L
.44003 .11991 L
.45034 .09033 L
.46144 .06328 L
.47203 .04263 L
.47667 .0353 L
.48173 .02852 L
.48622 .02363 L
.49101 .01956 L
.49366 .01784 L
.49606 .0166 L
.49722 .01611 L
.49848 .01566 L
.49965 .01533 L
.50076 .01507 L
.50199 .01487 L
.50312 .01476 L
.50434 .01472 L
.50503 .01473 L
.50566 .01476 L
.50672 .01486 L
.50788 .01504 L
.5091 .01532 L
.51025 .01564 L
.51286 .01666 L
.51526 .01791 L
.52067 .02188 L
.52557 .02681 L
.53092 .03363 L
.54173 .05181 L
.56131 .09857 L
.58226 .1648 L
.62372 .32197 L
.6445 .39915 L
.66367 .46037 L
.67331 .48561 L
Mistroke
.68233 .50509 L
.69174 .52061 L
.69674 .5267 L
.69934 .52925 L
.70211 .5315 L
.70486 .53324 L
.70735 .53439 L
.70856 .5348 L
.70986 .53514 L
.71109 .53535 L
.71222 .53545 L
.71286 .53548 L
.71354 .53547 L
.71478 .53538 L
.71553 .53527 L
.71625 .53513 L
.71759 .53478 L
.719 .53428 L
.7203 .5337 L
.72326 .53196 L
.72565 .53012 L
.72789 .52805 L
.733 .52206 L
.73798 .51457 L
.74335 .50471 L
.76341 .45285 L
.78451 .37826 L
.82264 .23039 L
.83274 .19804 L
.84226 .17353 L
.84753 .16307 L
.85031 .15857 L
.85325 .15461 L
.85572 .15194 L
.85703 .15077 L
.85844 .14973 L
.85973 .14895 L
.86091 .1484 L
.86209 .148 L
.86322 .14776 L
.86447 .14767 L
.86518 .14769 L
.86582 .14776 L
.86701 .14802 L
.86827 .14846 L
.8694 .14902 L
.87045 .14967 L
.87284 .15163 L
.87543 .15452 L
.87779 .15783 L
Mistroke
.88308 .16766 L
.88761 .17866 L
.89254 .19319 L
.90148 .22586 L
.92092 .31511 L
.93124 .36222 L
.93693 .38384 L
.93973 .39256 L
.94234 .39918 L
.94445 .40333 L
.94563 .40513 L
.9467 .4064 L
.94788 .40738 L
.94915 .40792 L
.95036 .40791 L
.95146 .40741 L
.95246 .40655 L
.9534 .40538 L
.95442 .40365 L
.95552 .40128 L
.95777 .39462 L
.95981 .38628 L
.96191 .37531 L
.96384 .36277 L
.96822 .32498 L
.97209 .2794 L
.97619 .21646 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 StyleBox["RationalInterpolation", "MR"],
 ", you get a rational function that agrees with the given function at a set \
of points. This guarantees that the rational function is, in one sense, close \
to the given function. A stronger requirement for a good rational \
approximation would be to require that the rational function be close to the \
given function over the entire interval. This type of rational approximation \
is produced by ",
 StyleBox["MiniMaxApproximation", "MR"],
 ". This approximation is so named because it minimizes the maximum value of \
the relative error between the approximation and the given function. This \
means that minimax approximation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["r",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to a given function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the rational function of the given degree that minimizes the maximum \
value of the quantity ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[VerticalSeparator]", "1", "-", 
    StyleBox["r",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "/", 
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "\[VerticalSeparator]"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " over the interval under consideration. Note that the term minimax \
approximation is also sometimes used for the rational function that minimizes \
the absolute error rather than the relative error used here. "
}], "Text",
 CellTags->{"S5.76.1", "1.15"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MiniMaxApproximation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the minimax approximation to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["m",
           "TI"], 
          RowBox[{",", " "}], 
          StyleBox["k",
           "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" on the interval from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MiniMaxApproximation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["approx", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the minimax approximation starting the iterative algorithm with ",
       
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["approx", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.76.1"],

Cell["The minimax approximation. ", "Caption",
 CellTags->"S5.76.1"],

Cell[TextData[{
 StyleBox["MiniMaxApproximation", "MR"],
 " works using an iterative scheme. The first step is to construct a rational \
approximation using ",
 StyleBox["RationalInterpolation", "MR"],
 ". This first approximation is then used to generate a better approximation \
using a scheme based on Remes\[CloseCurlyQuote]s algorithm. Generating the \
new approximation consists of adjusting the choice of the interpolation \
points in a way that ensures that the relative error will diminish. "
}], "Text",
 CellTags->{"S5.76.1", "1.16"}],

Cell[TextData[{
 StyleBox["MiniMaxApproximation", "MR"],
 " returns a list with two parts: a list of the points at which the maximum \
error occurs and a list consisting of the rational approximation and the \
value of the maximum error. This extra information is provided not so much \
for the user\[CloseCurlyQuote]s information, but to provide the capability of \
restarting the procedure without having to start back at the beginning. This \
is useful because the algorithm is iterative, and if convergence does not \
occur before ",
 StyleBox["MaxIterations", "MR"],
 " is reached, the incomplete answer is returned along with a warning. "
}], "Text",
 CellTags->{"S5.76.1", "1.17"}],

Cell["\<\
This gives a list containing the points where the maximum error occurs and \
the desired interpolation, along with the value of the error. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
mmlist = MiniMaxApproximation[Exp[x],
          {x, {0, 2}, 2, 4}]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.10634864875138167`", ",", "0.40091530830518246`", ",", 
     "0.8166361480553884`", ",", "1.26269779324298`", ",", 
     "1.6497494565048285`", ",", "1.9091204969598123`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"1.0000002060521063`", "\[InvisibleSpace]"}], "+", 
       RowBox[{"0.38088147329984634`", " ", "x"}], "+", 
       RowBox[{"0.04723949252641776`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "-", 
       RowBox[{"0.6191092297616275`", " ", "x"}], "+", 
       RowBox[{"0.1662828794265646`", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"0.023230448862049977`", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"0.0014332489234672907`", " ", 
        SuperscriptBox["x", "4"]}]}]], ",", 
     RowBox[{"-", "2.0605210627117777`*^-7"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["This extracts the rational approximation. ", "MathCaption",
 CellTags->{"S5.76.1", "1.19"}],

Cell[CellGroupData[{

Cell["mmfunc = mmlist[[2, 1]]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"1.0000002060521063`", "\[InvisibleSpace]"}], "+", 
   RowBox[{"0.38088147329984634`", " ", "x"}], "+", 
   RowBox[{"0.04723949252641776`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6191092297616275`", " ", "x"}], "+", 
   RowBox[{"0.1662828794265646`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.023230448862049977`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0014332489234672907`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the relative error in the approximation over the interval \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", 
    StyleBox["x",
     "TI"], "\[LessEqual]", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Reducing the error at any one of the extrema will force the error to \
increase at one of the others. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.20"}],

Cell[CellGroupData[{

Cell["Plot[1 - mmfunc/Exp[x], {x, 0, 2}]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.309016 1.42829e+06 [
[.2619 .29652 -9 -9 ]
[.2619 .29652 9 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .02336 -39 -6.25 ]
[.01131 .02336 0 6.25 ]
[.01131 .16619 -39 -6.25 ]
[.01131 .16619 0 6.25 ]
[.01131 .45185 -33 -6.25 ]
[.01131 .45185 0 6.25 ]
[.01131 .59467 -33 -6.25 ]
[.01131 .59467 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30902 m
.2619 .31527 L
s
[(0.5)] .2619 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(1.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .02336 m
.03006 .02336 L
s
gsave
.01131 .02336 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .16619 m
.03006 .16619 L
s
gsave
.01131 .16619 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .45185 m
.03006 .45185 L
s
gsave
.01131 .45185 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .59467 m
.03006 .59467 L
s
gsave
.01131 .59467 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.125 Mabswid
.02381 .05192 m
.02756 .05192 L
s
.02381 .08049 m
.02756 .08049 L
s
.02381 .10906 m
.02756 .10906 L
s
.02381 .13762 m
.02756 .13762 L
s
.02381 .19475 m
.02756 .19475 L
s
.02381 .22332 m
.02756 .22332 L
s
.02381 .25188 m
.02756 .25188 L
s
.02381 .28045 m
.02756 .28045 L
s
.02381 .33758 m
.02756 .33758 L
s
.02381 .36615 m
.02756 .36615 L
s
.02381 .39471 m
.02756 .39471 L
s
.02381 .42328 m
.02756 .42328 L
s
.02381 .48041 m
.02756 .48041 L
s
.02381 .50898 m
.02756 .50898 L
s
.02381 .53754 m
.02756 .53754 L
s
.02381 .56611 m
.02756 .56611 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.03279 .23369 L
.04262 .4049 L
.04758 .46786 L
.05288 .52003 L
.05789 .55634 L
.06244 .57962 L
.06507 .58918 L
.0665 .5933 L
.06785 .59649 L
.06908 .59886 L
.07022 .60057 L
.07148 .60198 L
.07217 .60254 L
.07283 .60293 L
.07354 .6032 L
.07418 .60331 L
.07493 .60329 L
.07563 .60312 L
.07687 .60247 L
.07757 .60192 L
.07822 .6013 L
.07958 .59962 L
.08108 .59723 L
.0841 .59078 L
.08922 .57539 L
.09469 .55352 L
.10458 .50325 L
.14594 .23958 L
.15598 .18139 L
.16664 .12743 L
.17651 .08605 L
.18579 .05551 L
.19455 .0344 L
.19948 .02589 L
.20401 .02021 L
.20643 .01799 L
.20868 .01645 L
.20998 .01578 L
.21116 .01531 L
.21181 .01511 L
.21252 .01494 L
.2138 .01475 L
.21504 .01472 L
.21575 .01476 L
.21641 .01485 L
.2171 .01498 L
.21774 .01514 L
.21917 .01564 L
.22038 .0162 L
Mistroke
.22171 .01697 L
.22412 .01878 L
.22668 .02126 L
.22945 .02458 L
.23446 .03221 L
.24383 .05175 L
.25476 .08234 L
.26481 .1167 L
.30435 .28717 L
.34238 .4543 L
.36193 .52288 L
.3728 .55299 L
.38285 .57492 L
.38771 .58334 L
.39305 .59095 L
.39843 .59679 L
.40137 .59921 L
.40413 .60097 L
.4066 .60213 L
.40784 .60257 L
.40855 .60277 L
.40919 .60293 L
.41036 .60315 L
.4116 .60328 L
.41275 .60332 L
.41383 .60328 L
.4151 .60313 L
.41574 .60302 L
.41644 .60287 L
.41768 .60252 L
.41884 .60211 L
.42146 .60086 L
.42427 .59904 L
.42954 .59429 L
.43442 .58837 L
.44548 .56975 L
.45523 .54768 L
.4656 .51894 L
.50331 .37978 L
.54348 .20898 L
.56194 .13808 L
.5724 .10304 L
.58214 .07476 L
.59262 .04975 L
.60216 .03247 L
.6074 .02536 L
.61235 .02027 L
.61507 .01816 L
.61758 .01666 L
.61889 .01604 L
Mistroke
.62033 .0155 L
.62106 .01528 L
.62184 .01508 L
.62257 .01493 L
.62325 .01483 L
.62454 .01472 L
.62575 .01473 L
.62684 .01482 L
.62802 .01501 L
.62931 .01533 L
.63067 .01579 L
.6331 .01694 L
.63536 .01838 L
.63746 .02004 L
.64225 .02497 L
.64748 .03218 L
.65225 .04039 L
.66298 .06438 L
.68208 .12474 L
.70284 .21134 L
.74364 .41067 L
.76391 .50129 L
.77384 .53819 L
.78293 .56591 L
.79179 .58623 L
.79624 .59364 L
.79875 .59692 L
.80111 .59942 L
.80235 .60048 L
.80368 .60145 L
.8048 .6021 L
.80602 .60266 L
.8067 .6029 L
.80735 .60307 L
.80802 .60321 L
.80875 .60329 L
.81006 .60329 L
.81126 .60312 L
.81246 .60277 L
.81358 .6023 L
.8148 .60161 L
.8161 .60068 L
.81852 .59841 L
.8207 .59574 L
.8256 .58761 L
.83076 .57579 L
.84 .54632 L
.84994 .50293 L
.86084 .44257 L
.88204 .29596 L
Mistroke
.90134 .15222 L
.91094 .08933 L
.916 .0616 L
.92137 .03795 L
.92363 .03014 L
.92606 .02336 L
.92745 .0203 L
.92872 .01805 L
.93 .01634 L
.93122 .01527 L
.93231 .01479 L
.93347 .01478 L
.93457 .01527 L
.93557 .01615 L
.93674 .01775 L
.93801 .02018 L
.93921 .02316 L
.94032 .02652 L
.94255 .03521 L
.94458 .04545 L
.94916 .07729 L
.9534 .11882 L
.95742 .17014 L
.96209 .24607 L
.96641 .33369 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "Because ",
 StyleBox["MiniMaxApproximation", "MR"],
 " tries to minimize the maximum of the ",
 StyleBox["relative", "TI"],
 " error, it is not possible to find a minimax approximation to a function \
that has a zero in the interval in question. The rational approximation would \
have to be ",
 StyleBox["exactly", "TI"],
 " zero at the zero of the function, or the relative error would be infinite. \
It is still possible to deal with such functions, but the zero must be \
divided out of the function and then multiplied back into the rational \
function. "
}], "Text",
 CellTags->{"S5.76.1", "1.21"}],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   FractionBox["\[Pi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " the relative error is infinite. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.22"}],

Cell[CellGroupData[{

Cell["\<\
MiniMaxApproximation[
           Cos[x], {x, {1, 2}, 2, 4}]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "::", "\<\"van\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Failed to locate the extrema in \\!\\(20\\) iterations. \
The function \\!\\(Cos[x]\\) may be vanishing on the interval \\!\\({1, 2}\\) \
or the WorkingPrecision may be insufficient to get convergence.\"\>"}]], \
"Message",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"MiniMaxApproximation", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "Dividing by ",
 StyleBox["(x", "MR"],
 " ",
 StyleBox["-", "MR"],
 " ",
 StyleBox["Pi/2)", "MR"],
 " cancels the zero and there is now no problem computing the approximation. \
"
}], "MathCaption",
 CellTags->{"S5.76.1", "1.23"}],

Cell[CellGroupData[{

Cell["\<\
MiniMaxApproximation[
    Cos[x]/(x-Pi/2),{x,{1,2},2,4}][[2,1]]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "0.6364826405166971`"}], "-", 
   RowBox[{"0.2841959634431811`", " ", "x"}], "+", 
   RowBox[{"0.09045955273246918`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.19136117484915718`", " ", "x"}], "+", 
   RowBox[{"0.07710218648260281`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.010305850313746168`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0016404683275032478`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "Multiplying the approximation by ",
 StyleBox["(x", "MR"],
 " ",
 StyleBox["-", "MR"],
 " ",
 StyleBox["Pi/2)", "MR"],
 " then gives the minimax approximation to ",
 StyleBox["Cos[x]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.24"}],

Cell[CellGroupData[{

Cell["mmacos = % N[x - Pi/2]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1.5707963267948966`"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.6364826405166971`"}], "-", 
     RowBox[{"0.2841959634431811`", " ", "x"}], "+", 
     RowBox[{"0.09045955273246918`", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.19136117484915718`", " ", "x"}], "+", 
   RowBox[{"0.07710218648260281`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.010305850313746168`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0016404683275032478`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["This plots the relative error. ", "MathCaption",
 CellTags->{"S5.76.1", "1.25"}],

Cell[CellGroupData[{

Cell["\<\
Plot[1 - mmacos/Cos[x],
               {x, 1, 2}]\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.928572 0.952381 0.309017 5.73025e+08 [
[.21429 .29652 -9 -9 ]
[.21429 .29652 9 0 ]
[.40476 .29652 -9 -9 ]
[.40476 .29652 9 0 ]
[.59524 .29652 -9 -9 ]
[.59524 .29652 9 0 ]
[.78571 .29652 -9 -9 ]
[.78571 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .07981 -43.5 -6.25 ]
[.01131 .07981 0 6.25 ]
[.01131 .19441 -43.5 -6.25 ]
[.01131 .19441 0 6.25 ]
[.01131 .42362 -37.5 -6.25 ]
[.01131 .42362 0 6.25 ]
[.01131 .53823 -37.5 -6.25 ]
[.01131 .53823 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(1.2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(1.4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(1.6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(1.8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .07981 m
.03006 .07981 L
s
gsave
.01131 .07981 -43.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
.02381 .19441 m
.03006 .19441 L
s
gsave
.01131 .19441 -43.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
.02381 .42362 m
.03006 .42362 L
s
gsave
.01131 .42362 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
.02381 .53823 m
.03006 .53823 L
s
gsave
.01131 .53823 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-10) show
grestore
.125 Mabswid
.02381 .10846 m
.02756 .10846 L
s
.02381 .13711 m
.02756 .13711 L
s
.02381 .16576 m
.02756 .16576 L
s
.02381 .22306 m
.02756 .22306 L
s
.02381 .25171 m
.02756 .25171 L
s
.02381 .28037 m
.02756 .28037 L
s
.02381 .33767 m
.02756 .33767 L
s
.02381 .36632 m
.02756 .36632 L
s
.02381 .39497 m
.02756 .39497 L
s
.02381 .45227 m
.02756 .45227 L
s
.02381 .48092 m
.02756 .48092 L
s
.02381 .50958 m
.02756 .50958 L
s
.02381 .05116 m
.02756 .05116 L
s
.02381 .0225 m
.02756 .0225 L
s
.02381 .56688 m
.02756 .56688 L
s
.02381 .59553 m
.02756 .59553 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02846 .45327 L
.03279 .33801 L
.03793 .22846 L
.04262 .15186 L
.04498 .12074 L
.04754 .09218 L
.0522 .05301 L
.05478 .03769 L
.0562 .03109 L
.05753 .02598 L
.05875 .02217 L
.05987 .01941 L
.06111 .01711 L
.06179 .01618 L
.06244 .01551 L
.0631 .01504 L
.06381 .01477 L
.0651 .01486 L
.06635 .01565 L
.0675 .01696 L
.06875 .01899 L
.07012 .02191 L
.07289 .02986 L
.07531 .03887 L
.07791 .05043 L
.08259 .07559 L
.10458 .23721 L
.12439 .39241 L
.13484 .46276 L
.14594 .52352 L
.15578 .5635 L
.16138 .58011 L
.16394 .58621 L
.16664 .59161 L
.16893 .59539 L
.17144 .59867 L
.17255 .59984 L
.17373 .60089 L
.17483 .60171 L
.17585 .60231 L
.17714 .60287 L
.17781 .60307 L
.17853 .60322 L
.17973 .60332 L
.18042 .60329 L
.18106 .6032 L
.18225 .6029 L
.18334 .60246 L
.18459 .60177 L
Mistroke
.18579 .60093 L
.18839 .59847 L
.19083 .59541 L
.1954 .58781 L
.20032 .57702 L
.20563 .56255 L
.22403 .49364 L
.26509 .28467 L
.28555 .18245 L
.30463 .10343 L
.31406 .07251 L
.32299 .04901 L
.32792 .03857 L
.33328 .02933 L
.33815 .02288 L
.34265 .01858 L
.34508 .01692 L
.3473 .0158 L
.34846 .01538 L
.34974 .01503 L
.35038 .0149 L
.35107 .0148 L
.3523 .01472 L
.35348 .01475 L
.35474 .0149 L
.35594 .01515 L
.35705 .01549 L
.35914 .01638 L
.36135 .01769 L
.3638 .01956 L
.36643 .02207 L
.37118 .02788 L
.37682 .03688 L
.38197 .04698 L
.40103 .0986 L
.42178 .17519 L
.46253 .35492 L
.48276 .44114 L
.50177 .51061 L
.51991 .5613 L
.52488 .57199 L
.53012 .58163 L
.53493 .58899 L
.53948 .59457 L
.54188 .59697 L
.54447 .59914 L
.54664 .6006 L
.54901 .60185 L
.55034 .60238 L
.55159 .60277 L
Mistroke
.5529 .60307 L
.55364 .60319 L
.55431 .60326 L
.55551 .60332 L
.55682 .60327 L
.55805 .60312 L
.5592 .60288 L
.56036 .60256 L
.5616 .60211 L
.56386 .60102 L
.56607 .59965 L
.56809 .59801 L
.57756 .58713 L
.58227 .57954 L
.58731 .56986 L
.5964 .54852 L
.61707 .48343 L
.65845 .3071 L
.67916 .21297 L
.69831 .13378 L
.71691 .07157 L
.7263 .04773 L
.73135 .03737 L
.73666 .02846 L
.74149 .02223 L
.74422 .0195 L
.74677 .01751 L
.74797 .01675 L
.74911 .01614 L
.75015 .01568 L
.75124 .01529 L
.75244 .01498 L
.75354 .0148 L
.75472 .01472 L
.75603 .01477 L
.75669 .01485 L
.75742 .01498 L
.75811 .01514 L
.75874 .01533 L
.75994 .01579 L
.76122 .01641 L
.76415 .01836 L
.76681 .02076 L
.772 .02726 L
.77689 .0355 L
.78669 .05822 L
.79702 .0908 L
.81551 .16896 L
.85355 .38059 L
.87475 .49723 L
Mistroke
.88479 .54279 L
.89405 .57559 L
.89871 .58785 L
.90109 .59285 L
.90366 .59721 L
.90499 .59904 L
.90622 .60045 L
.90746 .6016 L
.90862 .60241 L
.90927 .60275 L
.90996 .60303 L
.91072 .60323 L
.91142 .60331 L
.91208 .6033 L
.91279 .60319 L
.91409 .60272 L
.91527 .60198 L
.91637 .60102 L
.91758 .59966 L
.91888 .59784 L
.92153 .59292 L
.92395 .58697 L
.92861 .57135 L
.93303 .55122 L
.93762 .52448 L
.94268 .4876 L
.95293 .38729 L
.96243 .26093 L
.97135 .11028 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "There are several ways in which ",
 StyleBox["MiniMaxApproximation", "MR"],
 " can fail. In these cases, you will usually get a message indicating what \
probably went wrong and what you can do to avoid the problem. For example, if \
you ask for a minimax approximation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["m",
      "TI"], ",", 
     StyleBox["k",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 StyleBox["MiniMaxApproximation", "MR"],
 " will look for a rational minimax approximation such that the relative \
error oscillates in sign and the extreme values are achieved ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m",
     "TI"], "+", 
    StyleBox["k",
     "TI"], "+", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " times. Sometimes the extreme values occur more times. It may be possible \
to design a more robust algorithm to deal with this problem, but in practice \
it is usually quite simple just to ask for a minimax approximation with \
different degree. "
}], "Text",
 CellTags->{"S5.76.1", "1.26"}],

Cell["\<\
When you try to compute this approximation you get a warning. Notice that \
there is not a single error, but a list of errors corresponding to the \
abscissas in the first part. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.27"}],

Cell[CellGroupData[{

Cell["\<\
MiniMaxApproximation[
 Cos[x]/(x - Pi/2), {x, {1, 2}, 2, 2}]\
\>", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "::", "\<\"extalt\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The extrema of the error do not alternate in sign.  It may \
be that  MiniMaxApproximation has lost track of the extrema by going too \
fast.  If so try increasing the values in the option Brake.  It may be that \
the WorkingPrecision is insufficient.  Otherwise there is an extra extreme \
value of the error, and MiniMaxApproximation cannot deal with this problem.\"\
\>"}]], "Message",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.0912051971626626`", ",", "1.3303090610417638`", ",", 
     "1.6246664205408836`", ",", "1.8540080483894437`", ",", "2.`"}], "}"}], 
   ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "0.6343420065076478`"}], "-", 
     RowBox[{"0.3244374133771145`", " ", "x"}], "+", 
     RowBox[{"0.10328269957446107`", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]"}], "-", 
     RowBox[{"0.14113212898038696`", " ", "x"}], "+", 
     RowBox[{"0.044912437917880806`", " ", 
      SuperscriptBox["x", "2"]}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"4.0830020819893065`*^-7", ",", 
     RowBox[{"-", "3.640061647658399`*^-7"}], ",", "2.532758289763848`*^-7", 
     ",", 
     RowBox[{"-", "1.228623061066969`*^-7"}], ",", "2.191910186688517`*^-8", 
     ",", "3.256175684640539`*^-8"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["This extracts the approximation and cancels the factor. ", "MathCaption",
 CellTags->{"S5.76.1", "1.28"}],

Cell[CellGroupData[{

Cell["badmma = %[[2]] N[x - Pi/2]", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1.5707963267948966`"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.6343420065076478`"}], "-", 
     RowBox[{"0.3244374133771145`", " ", "x"}], "+", 
     RowBox[{"0.10328269957446107`", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"1.`", "\[InvisibleSpace]"}], "-", 
   RowBox[{"0.14113212898038696`", " ", "x"}], "+", 
   RowBox[{"0.044912437917880806`", " ", 
    SuperscriptBox["x", "2"]}]}]]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["\<\
Notice that the relative error has seven local extrema rather than the \
expected six. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.29"}],

Cell[CellGroupData[{

Cell["Plot[1 - badmma/Cos[x], {x, 1, 2}]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.928572 0.952381 0.292137 762142 [
[.21429 .27964 -9 -9 ]
[.21429 .27964 9 0 ]
[.40476 .27964 -9 -9 ]
[.40476 .27964 9 0 ]
[.59524 .27964 -9 -9 ]
[.59524 .27964 9 0 ]
[.78571 .27964 -9 -9 ]
[.78571 .27964 9 0 ]
[.97619 .27964 -3 -9 ]
[.97619 .27964 3 0 ]
[.01131 .13971 -39 -6.25 ]
[.01131 .13971 0 6.25 ]
[.01131 .44457 -33 -6.25 ]
[.01131 .44457 0 6.25 ]
[.01131 .59699 -33 -6.25 ]
[.01131 .59699 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .29214 m
.21429 .29839 L
s
[(1.2)] .21429 .27964 0 1 Mshowa
.40476 .29214 m
.40476 .29839 L
s
[(1.4)] .40476 .27964 0 1 Mshowa
.59524 .29214 m
.59524 .29839 L
s
[(1.6)] .59524 .27964 0 1 Mshowa
.78571 .29214 m
.78571 .29839 L
s
[(1.8)] .78571 .27964 0 1 Mshowa
.97619 .29214 m
.97619 .29839 L
s
[(2)] .97619 .27964 0 1 Mshowa
.125 Mabswid
.07143 .29214 m
.07143 .29589 L
s
.11905 .29214 m
.11905 .29589 L
s
.16667 .29214 m
.16667 .29589 L
s
.2619 .29214 m
.2619 .29589 L
s
.30952 .29214 m
.30952 .29589 L
s
.35714 .29214 m
.35714 .29589 L
s
.45238 .29214 m
.45238 .29589 L
s
.5 .29214 m
.5 .29589 L
s
.54762 .29214 m
.54762 .29589 L
s
.64286 .29214 m
.64286 .29589 L
s
.69048 .29214 m
.69048 .29589 L
s
.7381 .29214 m
.7381 .29589 L
s
.83333 .29214 m
.83333 .29589 L
s
.88095 .29214 m
.88095 .29589 L
s
.92857 .29214 m
.92857 .29589 L
s
.25 Mabswid
0 .29214 m
1 .29214 L
s
.02381 .13971 m
.03006 .13971 L
s
gsave
.01131 .13971 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .44457 m
.03006 .44457 L
s
gsave
.01131 .44457 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.02381 .59699 m
.03006 .59699 L
s
gsave
.01131 .59699 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.125 Mabswid
.02381 .17782 m
.02756 .17782 L
s
.02381 .21592 m
.02756 .21592 L
s
.02381 .25403 m
.02756 .25403 L
s
.02381 .33024 m
.02756 .33024 L
s
.02381 .36835 m
.02756 .36835 L
s
.02381 .40646 m
.02756 .40646 L
s
.02381 .48267 m
.02756 .48267 L
s
.02381 .52078 m
.02756 .52078 L
s
.02381 .55889 m
.02756 .55889 L
s
.02381 .1016 m
.02756 .1016 L
s
.02381 .06349 m
.02756 .06349 L
s
.02381 .02539 m
.02756 .02539 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.03279 .4655 L
.04262 .34082 L
.053 .23579 L
.06244 .1613 L
.07298 .09901 L
.07878 .0731 L
.08426 .05351 L
.08932 .03931 L
.094 .0293 L
.09665 .02487 L
.09914 .02149 L
.10173 .01873 L
.10311 .01756 L
.10458 .01654 L
.10593 .01581 L
.10715 .01531 L
.10838 .01496 L
.10954 .01477 L
.1102 .01472 L
.1109 .01472 L
.11214 .01481 L
.11284 .01493 L
.11349 .01508 L
.11496 .01556 L
.11624 .01614 L
.11745 .01681 L
.11972 .0184 L
.12483 .02345 L
.12944 .02963 L
.1337 .03659 L
.14335 .05618 L
.16202 .1055 L
.18262 .17023 L
.22282 .30047 L
.26151 .40267 L
.28155 .44056 L
.29163 .45525 L
.30265 .4679 L
.30793 .47272 L
.31292 .47652 L
.31746 .47937 L
.32226 .48175 L
.32475 .48273 L
.32749 .48362 L
.32998 .48425 L
.33231 .48469 L
.33372 .48489 L
.33441 .48497 L
.33506 .48503 L
Mistroke
.33626 .48511 L
.33757 .48516 L
.3383 .48517 L
.339 .48516 L
.3403 .48512 L
.34103 .48508 L
.3417 .48503 L
.34321 .48488 L
.34448 .4847 L
.34568 .4845 L
.34792 .48403 L
.35297 .48254 L
.35733 .48077 L
.36207 .47837 L
.37282 .47117 L
.38275 .46254 L
.40145 .44187 L
.42207 .41387 L
.46232 .35085 L
.50106 .29059 L
.52075 .2636 L
.54225 .23859 L
.56282 .21993 L
.572 .21343 L
.58193 .20771 L
.58742 .20514 L
.59248 .20315 L
.59722 .20161 L
.60243 .20027 L
.60468 .19981 L
.6071 .1994 L
.60919 .1991 L
.61147 .19885 L
.6128 .19873 L
.61404 .19864 L
.61521 .19858 L
.61647 .19853 L
.61758 .19851 L
.61863 .1985 L
.61979 .19851 L
.62103 .19853 L
.62228 .19858 L
.62342 .19864 L
.62473 .19873 L
.62598 .19884 L
.62819 .19907 L
.63058 .1994 L
.63602 .2004 L
.64105 .20163 L
.65129 .20502 L
Mistroke
.66214 .2098 L
.68169 .221 L
.69999 .23378 L
.73878 .26392 L
.75851 .27855 L
.78003 .29221 L
.79 .29738 L
.80063 .30191 L
.8058 .30373 L
.81067 .30519 L
.81537 .30638 L
.81976 .30727 L
.82442 .308 L
.82688 .3083 L
.82953 .30854 L
.83086 .30864 L
.8323 .30872 L
.83296 .30875 L
.83367 .30878 L
.83493 .30882 L
.83614 .30884 L
.83727 .30884 L
.83851 .30883 L
.83921 .30882 L
.83985 .30881 L
.84093 .30877 L
.84208 .30872 L
.84415 .3086 L
.84661 .30839 L
.84885 .30816 L
.85373 .3075 L
.85833 .30668 L
.86806 .30439 L
.87836 .30132 L
.89681 .29493 L
.90626 .29175 L
.91146 .29019 L
.9164 .2889 L
.92098 .28794 L
.92358 .28751 L
.92598 .2872 L
.92712 .28708 L
.9282 .28699 L
.92917 .28693 L
.93021 .28688 L
.93136 .28685 L
.93256 .28684 L
.93359 .28686 L
.93472 .28691 L
.93603 .287 L
Mistroke
.93724 .28711 L
.93857 .28728 L
.93998 .2875 L
.94235 .28799 L
.94496 .2887 L
.94977 .29054 L
.95428 .29296 L
.95955 .29674 L
.96437 .30121 L
.97522 .31537 L
.97619 .31695 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["\<\
After changing the degree of the requested approximation, you no longer have \
the problem. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.30"}],

Cell[CellGroupData[{

Cell["\<\
MiniMaxApproximation[
     Cos[x]/(x - Pi/2),
        {x, {1, 2}, 2, 3}][[2, 1]]\
\>", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "0.6348762159335477`"}], "-", 
   RowBox[{"0.31769148942458864`", " ", "x"}], "+", 
   RowBox[{"0.10245244569200992`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.14896308471641245`", " ", "x"}], "+", 
   RowBox[{"0.047772688828217114`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.000714750253987526`", " ", 
    SuperscriptBox["x", "3"]}]}]]], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["\<\
Another thing that can happen is that the initial rational interpolation can \
have a zero in the denominator somewhere in the interval. In such cases it is \
usually easiest to ask for a minimax approximation of different degree. \
Occasionally, however, this approach does not solve the problem. \
\>", "Text",
 CellTags->{"S5.76.1", "1.31"}],

Cell["\<\
A trick that will sometimes work is to start with an approximation that is \
valid over a shorter interval. Because the minimax approximation will usually \
change continuously as you lengthen the interval, you can use the \
approximation for the shorter interval as a starting point for an \
approximation on a slightly longer interval. By slowly stretching the \
interval, you may be able to eventually get a minimax approximation that is \
valid over the interval you desire. \
\>", "Text",
 CellTags->{"S5.76.1", "1.32"}],

Cell[TextData[{
 StyleBox["MiniMaxApproximation", "MR"],
 " has several options that give the user control over how it works and two \
options that help in diagnosing failures. "
}], "Text",
 CellTags->{"S5.76.1", "1.33"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "number of digits of precision to use",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Bias", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "bias in the automatic choice of interpolation points",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Brake", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{5,", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["5}", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "braking to apply on iterative algorithm ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxIterations", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["20", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum number of iterates after braking has ended ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Derivatives", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies a function to use for the derivatives",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrintFlag", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to print information about the relative error at each step in \
the iteration",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotFlag", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to plot the relative error at each step in the iteration",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.76.1"],

Cell["Options for minimax approximations.", "Caption",
 CellTags->"S5.76.1"],

Cell[TextData[{
 StyleBox["MiniMaxApproximation", "MR"],
 " works by first finding a rational interpolation to the given function and \
then perturbing the coefficients until the error is equi\[Hyphen]oscillatory. \
The option ",
 StyleBox["Bias", "MR"],
 " is used to control the initial rational approximation in exactly the same \
way it is used in ",
 StyleBox["RationalInterpolation", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.34"}],

Cell[TextData[{
 "As ",
 StyleBox["MiniMaxApproximation", "MR"],
 " proceeds, it alternately locates the extrema of the relative error and \
then perturbs the coefficients in an effort to equalize the magnitudes of the \
extrema. If the extrema move only a small amount from one iteration to the \
next, their previous positions can be used as starting values in locating \
their new positions. If they move too much from one iteration to the next, ",
 StyleBox["MiniMaxApproximation", "MR"],
 " gets lost. The way ",
 StyleBox["MiniMaxApproximation", "MR"],
 " knows it is lost is if the extrema do not alternate in sign, two extrema \
are the same, or their abscissas are not in sorted order. "
}], "Text",
 CellTags->{"S5.76.1", "1.35"}],

Cell[TextData[{
 "The way to prevent ",
 StyleBox["MiniMaxApproximation", "MR"],
 " from getting lost is to set the option ",
 StyleBox["Brake", "MR"],
 ". ",
 StyleBox["Brake", "MR"],
 " acts as a braking mechanism on the changes from one iteration to the next, \
but its influence eventually dies off to the point where there is no braking \
effect. When the algorithm has almost converged, there is no need to provide \
braking, because the changes are very small. "
}], "Text",
 CellTags->{"S5.76.1", "1.36"}],

Cell[TextData[{
 "A value for ",
 StyleBox["Brake", "MR"],
 " must be a list of two positive integers. The first integer specifies how \
many iterations are to be affected by the braking, and the second integer \
specifies how much braking force is to be applied to the first iteration. ",
 StyleBox["Brake", "MR"],
 " is much more important for minimax approximations of high degree, because \
in this case, the abscissas of the extrema are very close together. "
}], "Text",
 CellTags->{"S5.76.1", "1.37"}],

Cell[TextData[{
 "To perform its iterative scheme, ",
 StyleBox["MiniMaxApproximation", "MR"],
 " must know the first two derivatives of the function being approximated. If \
",
 StyleBox["Mathematica", "TI"],
 " cannot compute the derivatives analytically, you must specify them \
explicitly. A related situation is when the derivatives can be found, but \
calculating them involves a lot of work, much of which is redundant. For \
example, in trying to find a minimax approximation to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 StyleBox["Mathematica", "TI"],
 " needs to evaluate ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to find the value of the function, ",
 StyleBox["Mathematica", "TI"],
 " needs to evaluate ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to find the value of the first derivative, and ",
 StyleBox["Mathematica", "TI"],
 " needs to evaluate ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to find the value of the second derivative. A much simpler way would be \
for the user to specify a function that returns a list of these three values \
for each value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This is the purpose of the option ",
 StyleBox["Derivatives", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.38"}],

Cell[TextData[{
 "There are two things to be aware of when you use this option. First, the \
function should not be allowed to evaluate until ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is actually a number, or the whole purpose of using the option will be \
defeated. "
}], "Text",
 CellTags->{"S5.76.1", "1.39"}],

Cell[TextData[{
 "This prevents ",
 StyleBox["derivs", "MR"],
 " from evaluating unless ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a number. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.40"}],

Cell["\<\
derivs[x_?NumberQ] :=
        Block[{exp = Exp[x]}, {exp, exp, exp}]\
\>", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.76.1"],

Cell[TextData[{
 StyleBox["MiniMaxApproximation", "MR"],
 " works with our definition for the derivatives. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.41"}],

Cell[CellGroupData[{

Cell["\<\
MiniMaxApproximation[
        Exp[x], {x, {-1, 1}, 2, 2},
           Derivatives -> derivs[x]]\
\>", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "0.8123042914372461`"}], ",", 
     RowBox[{"-", "0.3124145944020292`"}], ",", "0.3124145944021315`", ",", 
     "0.8123042914372733`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"0.9999999962330653`", "\[InvisibleSpace]"}], "+", 
       RowBox[{"0.4997856238266085`", " ", "x"}], "+", 
       RowBox[{"0.08159269632523776`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "-", 
       RowBox[{"0.49978562570926466`", " ", "x"}], "+", 
       RowBox[{"0.08159269663259046`", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", 
     RowBox[{"-", "0.00008679786398603287`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "To prevent infinite iteration, ",
 StyleBox["MiniMaxApproximation", "MR"],
 " has the option ",
 StyleBox["MaxIterations", "MR"],
 ". If convergence does not occur before the number of iterations after the \
braking stops reaches ",
 StyleBox["MaxIterations", "MR"],
 ", a warning is returned along with the current approximation. If the \
problem is simply slow convergence, you can restart the iteration from the \
current approximation by inserting the approximation that was returned as the \
second argument to ",
 StyleBox["MiniMaxApproximation", "MR"],
 ". You may find it useful to begin the new iteration with different options. \
"
}], "Text",
 CellTags->{"S5.76.1", "1.42"}],

Cell[TextData[{
 "To get an example of a poor approximation, you can choose a small value of \
",
 StyleBox["MaxIterations", "MR"],
 ", a large bias, and no braking. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.43"}],

Cell[CellGroupData[{

Cell["\<\
approx =
   MiniMaxApproximation[
         Exp[x], {x, {-1, 1}, 2, 2},
            Brake -> {0,0},
     MaxIterations -> 2, Bias -> .4]\
\>", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "::", "\<\"conv\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Warning: convergence was not complete.\"\>"}]], "Message",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "0.8278198033484722`"}], ",", 
     RowBox[{"-", "0.3304808802414957`"}], ",", "0.421134148525639`", ",", 
     "0.8847420999708663`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"0.9999726685696242`", "\[InvisibleSpace]"}], "+", 
       RowBox[{"0.4985267091703634`", " ", "x"}], "+", 
       RowBox[{"0.08097205283240856`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "-", 
       RowBox[{"0.500985708196909`", " ", "x"}], "+", 
       RowBox[{"0.08208101052947224`", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", 
     RowBox[{"-", "0.00006923106415659986`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["\<\
The result of the previous approximation attempt is used as the starting \
point of the new iteration by inserting it as a second argument. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.44"}],

Cell[CellGroupData[{

Cell["\<\
MiniMaxApproximation[
   Exp[x], approx,
                 {x, {-1, 1}, 2, 2},
                       Brake -> {0,0}]\
\>", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "0.8123042956923697`"}], ",", 
     RowBox[{"-", "0.31241460825718986`"}], ",", "0.31241456652075084`", ",", 
     "0.8123043534945186`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"0.9999999962232217`", "\[InvisibleSpace]"}], "+", 
       RowBox[{"0.49978562254337144`", " ", "x"}], "+", 
       RowBox[{"0.08159269575042069`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "-", 
       RowBox[{"0.49978562701130474`", " ", "x"}], "+", 
       RowBox[{"0.08159269724250999`", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", 
     RowBox[{"-", "0.00008679785560271672`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PrintFlag", "MR"],
 " and ",
 StyleBox["PlotFlag", "MR"],
 " are options to ",
 StyleBox["MiniMaxApproximation", "MR"],
 " that are useful for diagnosing the reason for failure. Setting either of \
these options will have no effect on the calculations. If ",
 StyleBox["PlotFlag", "MR"],
 " is set to ",
 StyleBox["True,", "MR"],
 " a plot of the relative error in each iterated rational approximation will \
be generated. If these plots change dramatically from one iteration to the \
next, you should probably increase the braking. If ",
 StyleBox["PrintFlag", "MR"],
 " is set to ",
 StyleBox["True", "MR"],
 ", two things will happen. First, as the extrema are being located for the \
first time, lists of the changes in the approximations to the abscissas will \
be printed out. The numbers in these lists should rapidly decrease once they \
get reasonably small. After the extrema are located for the first time, lists \
of ordered pairs are printed consisting of abscissas of the extrema of the \
relative error and the value of the relative error at each of those \
abscissas. "
}], "Text",
 CellTags->{"S5.76.1", "1.45"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GeneralRationalInterpolation[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",  {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["t",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["t",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["t",
          "TI"], 
         RowBox[{
          StyleBox["n",
           "TI"], "+", 
          StyleBox["k",
           "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a rational interpolation of degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["m",
           "TI"], 
          RowBox[{",", " "}], 
          StyleBox["k",
           "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" whose graph is given parametrically as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GeneralRationalInterpolation[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a rational interpolation with the points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["t",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" chosen automatically",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.76.1"],

Cell["General rational interpolations. ", "Caption",
 CellTags->"S5.76.1"],

Cell[TextData[{
 "There are certain approximation problems in which you will want to use ",
 StyleBox["GeneralRationalInterpolation", "MR"],
 " instead of ",
 StyleBox["RationalInterpolation", "MR"],
 ". For example, you should use ",
 StyleBox["GeneralRationalInterpolation", "MR"],
 " if you want to find a rational interpolating function to the ",
 StyleBox["inverse", "TI"],
 " of a function that can only be evaluated by using ",
 StyleBox["FindRoot", "MR"],
 ". In such a case, ",
 StyleBox["RationalInterpolation", "MR"],
 " would be very slow. "
}], "Text",
 CellTags->{"S5.76.1", "1.46"}],

Cell[TextData[{
 StyleBox["GeneralRationalInterpolation", "MR"],
 " lets you do more general approximation problems by allowing the function \
that is to be approximated to be given parametrically. For example, the graph \
of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "=", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       StyleBox["x",
        "TI"], "2"]}]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is just the upper half of the unit circle. This can also be described \
parametrically as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"cos", 
     StyleBox["t",
      "TI"], ",", "sin", 
     StyleBox["t",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", 
    StyleBox["t",
     "TI"], "\[LessEqual]", "\[Pi]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Thus you can compute an approximation to ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      StyleBox["x",
       "TI"], "2"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " by specifying the function as ",
 StyleBox["{Cos[", "MR"],
 StyleBox["t", "TI"],
 StyleBox["], Sin[", "MR"],
 StyleBox["t", "TI"],
 StyleBox["]}", "MR"],
 " "
}], "Text",
 CellTags->{"S5.76.1", "1.47"}],

Cell[TextData[{
 "In the general case, when you specify the functions in ",
 StyleBox["RationalInterpolation", "MR"],
 " as ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f",
     "TI"], 
    StyleBox["y",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 ", the expressions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f",
     "TI"], 
    StyleBox["y",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are functions of ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The function that is interpolated is the one whose graph is given \
parametrically by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["f",
       "TI"], 
      StyleBox["x",
       "TI"]], 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}], ",", 
     SubscriptBox[
      StyleBox["f",
       "TI"], 
      StyleBox["y",
       "TI"]], 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["tmin",
     "TI"], "\[LessEqual]", 
    StyleBox["t",
     "TI"], "\[LessEqual]", 
    StyleBox["tmax",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.48"}],

Cell[TextData[{
 "Note that you must always specify a symbol for the independent variable; \
using the parametric variable as the independent variable would be incorrect. \
",
 StyleBox["GeneralRationalInterpolation", "MR"],
 " takes the same options as ",
 StyleBox["RationalInterpolation", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.49"}],

Cell["\<\
This gives an approximation to the function whose graph is the upper half \
circle. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.50"}],

Cell[CellGroupData[{

Cell["\<\
gri1 =
    GeneralRationalInterpolation[
        {Cos[t], Sin[t]}, {t, 2, 4}, x,
            Table[i Pi/6, {i,0,6}]]\
\>", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"0.9999999999999999`", "\[InvisibleSpace]"}], "-", 
   RowBox[{"1.6406614177636373`*^-17", " ", "x"}], "-", 
   RowBox[{"0.9999999999999999`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"6.38953177775398`*^-17", " ", "x"}], "-", 
   RowBox[{"0.4705142439600346`", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"1.6698812935362957`*^-17", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   RowBox[{"0.2615365636088429`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["The error is quite large near the endpoints. ", "MathCaption",
 CellTags->{"S5.76.1", "1.51"}],

Cell[CellGroupData[{

Cell["\<\
Plot[gri1 - Sqrt[1 - x^2],
        {x, -1, 1}, PlotRange -> All]\
\>", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.537911 7.19814 [
[.02381 .52541 -6 -9 ]
[.02381 .52541 6 0 ]
[.2619 .52541 -12 -9 ]
[.2619 .52541 12 0 ]
[.7381 .52541 -9 -9 ]
[.7381 .52541 9 0 ]
[.97619 .52541 -3 -9 ]
[.97619 .52541 3 0 ]
[.4875 .10602 -30 -4.5 ]
[.4875 .10602 0 4.5 ]
[.4875 .24998 -30 -4.5 ]
[.4875 .24998 0 4.5 ]
[.4875 .39395 -30 -4.5 ]
[.4875 .39395 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .53791 m
.02381 .54416 L
s
[(-1)] .02381 .52541 0 1 Mshowa
.2619 .53791 m
.2619 .54416 L
s
[(-0.5)] .2619 .52541 0 1 Mshowa
.7381 .53791 m
.7381 .54416 L
s
[(0.5)] .7381 .52541 0 1 Mshowa
.97619 .53791 m
.97619 .54416 L
s
[(1)] .97619 .52541 0 1 Mshowa
.125 Mabswid
.07143 .53791 m
.07143 .54166 L
s
.11905 .53791 m
.11905 .54166 L
s
.16667 .53791 m
.16667 .54166 L
s
.21429 .53791 m
.21429 .54166 L
s
.30952 .53791 m
.30952 .54166 L
s
.35714 .53791 m
.35714 .54166 L
s
.40476 .53791 m
.40476 .54166 L
s
.45238 .53791 m
.45238 .54166 L
s
.54762 .53791 m
.54762 .54166 L
s
.59524 .53791 m
.59524 .54166 L
s
.64286 .53791 m
.64286 .54166 L
s
.69048 .53791 m
.69048 .54166 L
s
.78571 .53791 m
.78571 .54166 L
s
.83333 .53791 m
.83333 .54166 L
s
.88095 .53791 m
.88095 .54166 L
s
.92857 .53791 m
.92857 .54166 L
s
.25 Mabswid
0 .53791 m
1 .53791 L
s
.5 .10602 m
.50625 .10602 L
s
[(-0.06)] .4875 .10602 1 0 Mshowa
.5 .24998 m
.50625 .24998 L
s
[(-0.04)] .4875 .24998 1 0 Mshowa
.5 .39395 m
.50625 .39395 L
s
[(-0.02)] .4875 .39395 1 0 Mshowa
.125 Mabswid
.5 .14201 m
.50375 .14201 L
s
.5 .178 m
.50375 .178 L
s
.5 .21399 m
.50375 .21399 L
s
.5 .28598 m
.50375 .28598 L
s
.5 .32197 m
.50375 .32197 L
s
.5 .35796 m
.50375 .35796 L
s
.5 .42994 m
.50375 .42994 L
s
.5 .46593 m
.50375 .46593 L
s
.5 .50192 m
.50375 .50192 L
s
.5 .07003 m
.50375 .07003 L
s
.5 .03404 m
.50375 .03404 L
s
.5 .5739 m
.50375 .5739 L
s
.5 .60989 m
.50375 .60989 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
.5 Mabswid
.02381 .53498 m
.02499 .16252 L
.02605 .08397 L
.02729 .04051 L
.02846 .02162 L
.02954 .01518 L
.03053 .01536 L
.03163 .02023 L
.03279 .02914 L
.0352 .0554 L
.03746 .08516 L
.04262 .15839 L
.05278 .29135 L
.06244 .38968 L
.06751 .43067 L
.07305 .46819 L
.08274 .51868 L
.08822 .5401 L
.09407 .55833 L
.09954 .57174 L
.10458 .58142 L
.10958 .58888 L
.11487 .59476 L
.11761 .5971 L
.12017 .5989 L
.12298 .60048 L
.12599 .60175 L
.12859 .60252 L
.13005 .60283 L
.13141 .60305 L
.13259 .60319 L
.1339 .60328 L
.13455 .60331 L
.13526 .60332 L
.13654 .6033 L
.13771 .60324 L
.13899 .60312 L
.14032 .60295 L
.14156 .60276 L
.14379 .6023 L
.14616 .60169 L
.15149 .59989 L
.1564 .59779 L
.16751 .5919 L
.18766 .57903 L
.22706 .55407 L
.24686 .54403 L
.26495 .53684 L
.2844 .53125 L
.29512 .52908 L
Mistroke
.30045 .52822 L
.30529 .52756 L
.30991 .52704 L
.3149 .52658 L
.31765 .52638 L
.32017 .52622 L
.32274 .52608 L
.32514 .52598 L
.32737 .5259 L
.32941 .52585 L
.33049 .52582 L
.33167 .5258 L
.33291 .52579 L
.33409 .52578 L
.33522 .52577 L
.33647 .52577 L
.33778 .52578 L
.339 .52579 L
.34014 .5258 L
.34118 .52582 L
.34353 .52587 L
.34603 .52593 L
.34829 .52601 L
.35336 .52623 L
.3625 .52679 L
.37316 .52765 L
.38321 .52861 L
.42173 .53289 L
.44125 .53491 L
.4516 .53582 L
.4627 .53665 L
.46818 .53698 L
.47337 .53726 L
.47842 .53748 L
.4831 .53764 L
.48752 .53777 L
.48975 .53781 L
.49222 .53785 L
.49469 .53788 L
.49607 .5379 L
.49734 .5379 L
.49846 .53791 L
.49969 .53791 L
.50097 .53791 L
.50216 .53791 L
.50343 .5379 L
.50407 .5379 L
.50478 .53789 L
.5072 .53786 L
.50856 .53784 L
Mistroke
.51002 .53782 L
.51266 .53776 L
.51785 .53761 L
.52259 .53744 L
.53212 .53697 L
.54117 .53638 L
.56099 .53469 L
.57938 .53277 L
.61853 .52843 L
.62883 .52747 L
.63424 .52703 L
.63996 .52662 L
.64497 .52632 L
.65047 .52606 L
.65288 .52597 L
.65547 .52589 L
.65672 .52586 L
.65791 .52583 L
.65907 .52581 L
.66013 .5258 L
.66127 .52579 L
.6625 .52578 L
.66359 .52577 L
.66473 .52577 L
.66598 .52578 L
.66715 .52579 L
.66843 .52581 L
.6698 .52583 L
.67113 .52586 L
.67256 .5259 L
.67517 .52599 L
.68006 .52623 L
.68472 .52655 L
.68965 .52699 L
.69848 .52807 L
.70793 .52963 L
.71807 .53184 L
.73639 .5373 L
.75758 .54609 L
.77769 .55679 L
.81595 .58144 L
.82697 .58856 L
.83733 .59463 L
.84663 .59913 L
.85186 .60109 L
.85418 .60179 L
.85667 .60241 L
.85794 .60266 L
.85914 .60287 L
.8603 .60304 L
Mistroke
.86138 .60316 L
.8624 .60324 L
.86349 .6033 L
.86458 .60332 L
.86577 .6033 L
.86707 .60322 L
.86825 .6031 L
.86891 .60301 L
.86962 .60289 L
.87092 .60263 L
.87343 .60194 L
.87575 .60106 L
.87838 .59977 L
.88086 .59822 L
.88549 .59442 L
.89047 .5888 L
.89587 .58065 L
.90078 .57103 L
.90537 .55986 L
.91083 .54337 L
.9158 .52482 L
.92596 .47419 L
.93156 .43746 L
.93686 .39569 L
.95544 .18576 L
.95995 .12162 L
.96482 .05513 L
.96618 .03941 L
.96692 .03188 L
.96761 .02577 L
.96883 .01772 L
.96947 .01535 L
.97016 .01472 L
.97081 .01637 L
.97151 .02133 L
.97279 .04244 L
.97403 .08852 L
.97518 .18129 L
.97619 .53498 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["\<\
You don\[CloseCurlyQuote]t need to specify the interpolation points \
explicitly. \
\>", "MathCaption",
 CellTags->{"S5.76.1", "1.52"}],

Cell[CellGroupData[{

Cell["\<\
gri2 =
   GeneralRationalInterpolation[
        {Cos[t], Sin[t]},{t, 2, 4}, x,
                            {t, 0, Pi}]\
\>", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"1.`", "\[InvisibleSpace]"}], "-", 
   RowBox[{"1.1981125098996491`*^-17", " ", "x"}], "-", 
   RowBox[{"0.9922198938554384`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "+", 
   RowBox[{"6.17445590329887`*^-17", " ", "x"}], "-", 
   RowBox[{"0.4132050487120367`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"1.3857370601595906`*^-17", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   RowBox[{"0.35185873773556564`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "As is the case with ",
 StyleBox["RationalInterpolation", "MR"],
 ", the error is often smaller if the interpolation points are not given \
explicitly. The points chosen automatically tend to be better distributed. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.53"}],

Cell[CellGroupData[{

Cell["Plot[gri2 - Sqrt[1 - x^2], {x, -1, 1}]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.315264 8.80679 [
[.02381 .30276 -6 -9 ]
[.02381 .30276 6 0 ]
[.2619 .30276 -12 -9 ]
[.2619 .30276 12 0 ]
[.7381 .30276 -9 -9 ]
[.7381 .30276 9 0 ]
[.97619 .30276 -3 -9 ]
[.97619 .30276 3 0 ]
[.4875 .05106 -30 -4.5 ]
[.4875 .05106 0 4.5 ]
[.4875 .13913 -30 -4.5 ]
[.4875 .13913 0 4.5 ]
[.4875 .2272 -30 -4.5 ]
[.4875 .2272 0 4.5 ]
[.4875 .40333 -24 -4.5 ]
[.4875 .40333 0 4.5 ]
[.4875 .4914 -24 -4.5 ]
[.4875 .4914 0 4.5 ]
[.4875 .57947 -24 -4.5 ]
[.4875 .57947 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .31526 m
.02381 .32151 L
s
[(-1)] .02381 .30276 0 1 Mshowa
.2619 .31526 m
.2619 .32151 L
s
[(-0.5)] .2619 .30276 0 1 Mshowa
.7381 .31526 m
.7381 .32151 L
s
[(0.5)] .7381 .30276 0 1 Mshowa
.97619 .31526 m
.97619 .32151 L
s
[(1)] .97619 .30276 0 1 Mshowa
.125 Mabswid
.07143 .31526 m
.07143 .31901 L
s
.11905 .31526 m
.11905 .31901 L
s
.16667 .31526 m
.16667 .31901 L
s
.21429 .31526 m
.21429 .31901 L
s
.30952 .31526 m
.30952 .31901 L
s
.35714 .31526 m
.35714 .31901 L
s
.40476 .31526 m
.40476 .31901 L
s
.45238 .31526 m
.45238 .31901 L
s
.54762 .31526 m
.54762 .31901 L
s
.59524 .31526 m
.59524 .31901 L
s
.64286 .31526 m
.64286 .31901 L
s
.69048 .31526 m
.69048 .31901 L
s
.78571 .31526 m
.78571 .31901 L
s
.83333 .31526 m
.83333 .31901 L
s
.88095 .31526 m
.88095 .31901 L
s
.92857 .31526 m
.92857 .31901 L
s
.25 Mabswid
0 .31526 m
1 .31526 L
s
.5 .05106 m
.50625 .05106 L
s
[(-0.03)] .4875 .05106 1 0 Mshowa
.5 .13913 m
.50625 .13913 L
s
[(-0.02)] .4875 .13913 1 0 Mshowa
.5 .2272 m
.50625 .2272 L
s
[(-0.01)] .4875 .2272 1 0 Mshowa
.5 .40333 m
.50625 .40333 L
s
[(0.01)] .4875 .40333 1 0 Mshowa
.5 .4914 m
.50625 .4914 L
s
[(0.02)] .4875 .4914 1 0 Mshowa
.5 .57947 m
.50625 .57947 L
s
[(0.03)] .4875 .57947 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .08629 m
.50375 .08629 L
s
.5 .1039 m
.50375 .1039 L
s
.5 .12151 m
.50375 .12151 L
s
.5 .15674 m
.50375 .15674 L
s
.5 .17436 m
.50375 .17436 L
s
.5 .19197 m
.50375 .19197 L
s
.5 .20958 m
.50375 .20958 L
s
.5 .24481 m
.50375 .24481 L
s
.5 .26242 m
.50375 .26242 L
s
.5 .28004 m
.50375 .28004 L
s
.5 .29765 m
.50375 .29765 L
s
.5 .33288 m
.50375 .33288 L
s
.5 .35049 m
.50375 .35049 L
s
.5 .3681 m
.50375 .3681 L
s
.5 .38572 m
.50375 .38572 L
s
.5 .42095 m
.50375 .42095 L
s
.5 .43856 m
.50375 .43856 L
s
.5 .45617 m
.50375 .45617 L
s
.5 .47379 m
.50375 .47379 L
s
.5 .50901 m
.50375 .50901 L
s
.5 .52663 m
.50375 .52663 L
s
.5 .54424 m
.50375 .54424 L
s
.5 .56185 m
.50375 .56185 L
s
.5 .03345 m
.50375 .03345 L
s
.5 .01583 m
.50375 .01583 L
s
.5 .59708 m
.50375 .59708 L
s
.5 .6147 m
.50375 .6147 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .16101 L
.02605 .07523 L
.02729 .03207 L
.02846 .01672 L
.02954 .01472 L
.03053 .01936 L
.03163 .02918 L
.03279 .04316 L
.04262 .19821 L
.05205 .3213 L
.05742 .37268 L
.06244 .41007 L
.06788 .44057 L
.07305 .46156 L
.07768 .47489 L
.08031 .48045 L
.08274 .48449 L
.08411 .48632 L
.0856 .48797 L
.08691 .48915 L
.08829 .49013 L
.08953 .4908 L
.09024 .49109 L
.0909 .4913 L
.09207 .49155 L
.09331 .49165 L
.09407 .49163 L
.09476 .49155 L
.09553 .49141 L
.09634 .4912 L
.0977 .4907 L
.09921 .48995 L
.10198 .48808 L
.10458 .48578 L
.10928 .48052 L
.11441 .4734 L
.12476 .45592 L
.14327 .41927 L
.18383 .3407 L
.20256 .31164 L
.22287 .28696 L
.23398 .2765 L
.24422 .26869 L
.25401 .26282 L
.25942 .2602 L
.26437 .25818 L
.26889 .25665 L
.27381 .2553 L
.27651 .25469 L
Mistroke
.27901 .25421 L
.28155 .2538 L
.28395 .25349 L
.28618 .25327 L
.28736 .25317 L
.2886 .25309 L
.28965 .25303 L
.2908 .25298 L
.29184 .25295 L
.29282 .25293 L
.29404 .25292 L
.2952 .25293 L
.29624 .25294 L
.29738 .25298 L
.29861 .25303 L
.29991 .2531 L
.30226 .25327 L
.30465 .25349 L
.30716 .25379 L
.31165 .25446 L
.32177 .25658 L
.33051 .25902 L
.34006 .26221 L
.38067 .27961 L
.41977 .29718 L
.43972 .30465 L
.45022 .30791 L
.46132 .31076 L
.47125 .31276 L
.47689 .31364 L
.48216 .31429 L
.48465 .31454 L
.48701 .31475 L
.48915 .3149 L
.49142 .31504 L
.4926 .3151 L
.49389 .31515 L
.49508 .31519 L
.49618 .31522 L
.49746 .31524 L
.49814 .31525 L
.49885 .31526 L
.50005 .31526 L
.50136 .31526 L
.50267 .31524 L
.50389 .31522 L
.50522 .31518 L
.50663 .31513 L
.509 .31502 L
.51161 .31485 L
Mistroke
.51643 .31444 L
.52094 .31393 L
.53103 .31235 L
.54188 .31001 L
.56303 .30371 L
.58313 .29598 L
.62134 .27868 L
.64267 .26906 L
.66201 .26148 L
.6717 .25835 L
.67679 .25695 L
.68217 .25566 L
.68689 .25471 L
.69206 .25389 L
.69433 .25361 L
.69677 .25335 L
.69906 .25316 L
.70116 .25304 L
.70234 .25299 L
.70345 .25295 L
.70466 .25293 L
.70597 .25292 L
.70727 .25293 L
.70792 .25294 L
.70864 .25296 L
.7099 .25301 L
.71108 .25307 L
.71341 .25323 L
.71552 .25343 L
.71796 .25373 L
.72026 .25408 L
.72544 .25512 L
.73022 .25638 L
.74102 .2604 L
.75073 .26547 L
.7598 .27155 L
.78044 .2905 L
.80075 .31635 L
.81929 .34608 L
.85907 .42407 L
.86942 .44487 L
.87916 .46293 L
.88863 .47778 L
.89278 .483 L
.89733 .48752 L
.89972 .4893 L
.90195 .49054 L
.90318 .49104 L
.9043 .49137 L
.9056 .4916 L
Mistroke
.90682 .49165 L
.90806 .49154 L
.90937 .49122 L
.91049 .49078 L
.91173 .49012 L
.91306 .48918 L
.91448 .48789 L
.91706 .48477 L
.91975 .48035 L
.92268 .47401 L
.92526 .46697 L
.92802 .45779 L
.93322 .43513 L
.93805 .40679 L
.94296 .36944 L
.94748 .32626 L
.95769 .19355 L
.96234 .11881 L
.96668 .05041 L
.96781 .03566 L
.96887 .02423 L
.9701 .01584 L
.97121 .01513 L
.97245 .02709 L
.9736 .05903 L
.97485 .14315 L
.97549 .23312 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GeneralMiniMaxApproximation[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the rational approximation of degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["m",
           "TI"], 
          RowBox[{",", " "}], 
          StyleBox["k",
           "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" whose graph is given parametrically as a function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GeneralMiniMaxApproximation[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["approx", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the minimax approximation starting the iterative algorithm with ",
       
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["approx", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GeneralMiniMaxApproximation[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the rational approximation computing the error using a factor ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["g",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.76.1"],

Cell["General minimax approximations. ", "Caption",
 CellTags->"S5.76.1"],

Cell[TextData[{
 "The function that is to be approximated is specified in ",
 StyleBox["GeneralMiniMaxApproximation", "MR"],
 " in the same way as it is in ",
 StyleBox["GeneralRationalInterpolation", "MR"],
 ". The options for ",
 StyleBox["GeneralMiniMaxApproximation", "MR"],
 " are the same as for ",
 StyleBox["MiniMaxApproximation", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.54"}],

Cell[TextData[{
 "This gives a degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "4"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " minimax approximation to the inverse of ",
 StyleBox["Exp", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.55"}],

Cell[CellGroupData[{

Cell["\<\
gmma1 =
  GeneralMiniMaxApproximation[
         {Exp[t], t},
            {t, {1, 2}, 2, 4},  x]\
\>", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.0471601651892473`", ",", "1.1813107377502203`", ",", 
     "1.3793050469654782`", ",", "1.6031080469331895`", ",", 
     "1.807147573896618`", ",", "1.9491940550750617`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "2.082397791620258`"}], "+", 
       RowBox[{"1.2738087749657254`", " ", "x"}], "+", 
       RowBox[{"0.8236002441476196`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "+", 
       RowBox[{"1.7318693038030615`", " ", "x"}], "+", 
       RowBox[{"0.2459175701488926`", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"0.0030965712045108603`", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"0.000058428236482215785`", " ", 
        SuperscriptBox["x", "4"]}]}]], ",", 
     RowBox[{"-", "6.746838846747863`*^-8"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "Since there is an easy way to evaluate the inverse of ",
 StyleBox["Exp", "MR"],
 ", it is also possible to use ",
 StyleBox["MiniMaxApproximation", "MR"],
 " for this problem. The only difference between the solutions is in the \
abscissas of the extrema. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.56"}],

Cell[CellGroupData[{

Cell["\<\
MiniMaxApproximation[
      Log[x],
                {x, {E, E^2}, 2, 4}]\
\>", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2.7182818284590446`", ",", "2.849547373139162`", ",", 
     "3.2586426308766643`", ",", "3.9721402170915394`", ",", 
     "4.968450629274829`", ",", "6.093042666614569`", ",", 
     "7.023025127293686`", ",", "7.38905609893065`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "2.082397791635555`"}], "+", 
       RowBox[{"1.2738087749540261`", " ", "x"}], "+", 
       RowBox[{"0.8236002441741124`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "+", 
       RowBox[{"1.7318693038333708`", " ", "x"}], "+", 
       RowBox[{"0.24591757015842633`", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"0.003096571204735921`", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"0.000058428236488482026`", " ", 
        SuperscriptBox["x", "4"]}]}]], ",", 
     RowBox[{"-", "6.746838858250413`*^-8"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["This extracts the minimax approximation. ", "MathCaption",
 CellTags->{"S5.76.1", "1.57"}],

Cell["log = gmma1[[2,1]];", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.76.1"],

Cell[TextData[{
 "Here is a plot of the relative error in the approximation over the interval \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["e",
     "TI"], "\[LessEqual]", 
    StyleBox["x",
     "TI"], "\[LessEqual]", 
    SuperscriptBox[
     StyleBox["e",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.58"}],

Cell[CellGroupData[{

Cell["Plot[1 - log/Log[x], {x, E, E^2}]", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.530454 0.203902 0.309017 4.36208e+06 [
[.28515 .29652 -3 -9 ]
[.28515 .29652 3 0 ]
[.48906 .29652 -3 -9 ]
[.48906 .29652 3 0 ]
[.69296 .29652 -3 -9 ]
[.69296 .29652 3 0 ]
[.89686 .29652 -3 -9 ]
[.89686 .29652 3 0 ]
[.06875 .04729 -39 -6.25 ]
[.06875 .04729 0 6.25 ]
[.06875 .13453 -39 -6.25 ]
[.06875 .13453 0 6.25 ]
[.06875 .22178 -39 -6.25 ]
[.06875 .22178 0 6.25 ]
[.06875 .39626 -33 -6.25 ]
[.06875 .39626 0 6.25 ]
[.06875 .4835 -33 -6.25 ]
[.06875 .4835 0 6.25 ]
[.06875 .57074 -33 -6.25 ]
[.06875 .57074 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.28515 .30902 m
.28515 .31527 L
s
[(4)] .28515 .29652 0 1 Mshowa
.48906 .30902 m
.48906 .31527 L
s
[(5)] .48906 .29652 0 1 Mshowa
.69296 .30902 m
.69296 .31527 L
s
[(6)] .69296 .29652 0 1 Mshowa
.89686 .30902 m
.89686 .31527 L
s
[(7)] .89686 .29652 0 1 Mshowa
.125 Mabswid
.12203 .30902 m
.12203 .31277 L
s
.16281 .30902 m
.16281 .31277 L
s
.20359 .30902 m
.20359 .31277 L
s
.24437 .30902 m
.24437 .31277 L
s
.32594 .30902 m
.32594 .31277 L
s
.36672 .30902 m
.36672 .31277 L
s
.4075 .30902 m
.4075 .31277 L
s
.44828 .30902 m
.44828 .31277 L
s
.52984 .30902 m
.52984 .31277 L
s
.57062 .30902 m
.57062 .31277 L
s
.6114 .30902 m
.6114 .31277 L
s
.65218 .30902 m
.65218 .31277 L
s
.73374 .30902 m
.73374 .31277 L
s
.77452 .30902 m
.77452 .31277 L
s
.8153 .30902 m
.8153 .31277 L
s
.85608 .30902 m
.85608 .31277 L
s
.04047 .30902 m
.04047 .31277 L
s
.93764 .30902 m
.93764 .31277 L
s
.97842 .30902 m
.97842 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.08125 .04729 m
.0875 .04729 L
s
gsave
.06875 .04729 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.08125 .13453 m
.0875 .13453 L
s
gsave
.06875 .13453 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.08125 .22178 m
.0875 .22178 L
s
gsave
.06875 .22178 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.08125 .39626 m
.0875 .39626 L
s
gsave
.06875 .39626 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.08125 .4835 m
.0875 .4835 L
s
gsave
.06875 .4835 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.08125 .57074 m
.0875 .57074 L
s
gsave
.06875 .57074 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.125 Mabswid
.08125 .0691 m
.085 .0691 L
s
.08125 .09091 m
.085 .09091 L
s
.08125 .11272 m
.085 .11272 L
s
.08125 .15634 m
.085 .15634 L
s
.08125 .17815 m
.085 .17815 L
s
.08125 .19997 m
.085 .19997 L
s
.08125 .24359 m
.085 .24359 L
s
.08125 .2654 m
.085 .2654 L
s
.08125 .28721 m
.085 .28721 L
s
.08125 .33083 m
.085 .33083 L
s
.08125 .35264 m
.085 .35264 L
s
.08125 .37445 m
.085 .37445 L
s
.08125 .41807 m
.085 .41807 L
s
.08125 .43988 m
.085 .43988 L
s
.08125 .46169 m
.085 .46169 L
s
.08125 .50531 m
.085 .50531 L
s
.08125 .52712 m
.085 .52712 L
s
.08125 .54893 m
.085 .54893 L
s
.08125 .02548 m
.085 .02548 L
s
.08125 .00367 m
.085 .00367 L
s
.08125 .59255 m
.085 .59255 L
s
.08125 .61436 m
.085 .61436 L
s
.25 Mabswid
.08125 0 m
.08125 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02846 .23459 L
.03279 .38333 L
.03527 .44797 L
.03754 .49523 L
.04015 .53753 L
.04132 .55266 L
.04262 .56675 L
.04377 .57719 L
.04502 .58628 L
.04633 .59363 L
.04756 .59855 L
.04878 .60167 L
.04994 .60312 L
.05099 .60324 L
.05212 .60216 L
.05282 .60092 L
.05348 .59935 L
.05471 .59547 L
.05604 .58999 L
.05748 .58265 L
.06244 .54785 L
.06753 .50094 L
.07312 .44149 L
.08439 .31376 L
.09495 .20328 L
.10458 .1213 L
.10938 .08877 L
.1146 .06013 L
.11953 .0396 L
.12172 .03248 L
.12409 .02619 L
.12658 .02109 L
.12769 .01929 L
.12891 .01768 L
.13026 .0163 L
.131 .01573 L
.13169 .01532 L
.13292 .01485 L
.13423 .01472 L
.13496 .01482 L
.13562 .01501 L
.13636 .01534 L
.13713 .01581 L
.13844 .01688 L
.13988 .01848 L
.14252 .02252 L
.145 .02754 L
.14998 .04095 L
.15541 .06018 L
Mistroke
.16529 .10535 L
.18383 .21332 L
.20519 .34894 L
.22453 .45903 L
.23423 .50472 L
.24471 .54501 L
.24953 .56011 L
.25461 .57362 L
.25929 .58381 L
.26371 .59148 L
.26609 .59481 L
.26868 .59781 L
.27104 .59996 L
.27321 .60148 L
.27442 .60212 L
.27556 .6026 L
.27681 .60299 L
.27751 .60314 L
.27815 .60324 L
.27937 .60332 L
.28006 .6033 L
.2807 .60325 L
.282 .60302 L
.28273 .60283 L
.28339 .60261 L
.28453 .60214 L
.28575 .60151 L
.28792 .60006 L
.29026 .59804 L
.29283 .59527 L
.29743 .58894 L
.30173 .58149 L
.31217 .55771 L
.32206 .52855 L
.34061 .46029 L
.37891 .29132 L
.39827 .20722 L
.41966 .12622 L
.42939 .0954 L
.43988 .06722 L
.44973 .046 L
.45889 .03104 L
.46351 .02531 L
.46844 .02054 L
.47126 .01845 L
.47392 .0169 L
.47631 .01587 L
.47766 .01543 L
.47891 .01511 L
.48012 .0149 L
Mistroke
.48142 .01476 L
.48265 .01472 L
.48378 .01475 L
.4851 .01489 L
.48584 .01501 L
.48653 .01515 L
.4878 .01548 L
.48915 .01594 L
.49208 .01727 L
.49484 .01897 L
.5 .02329 L
.50466 .02843 L
.50977 .03539 L
.52009 .0535 L
.53857 .09819 L
.57901 .23647 L
.61794 .38975 L
.63777 .46208 L
.65932 .52836 L
.66937 .55323 L
.68003 .57465 L
.68914 .58848 L
.69432 .5944 L
.69684 .59675 L
.69919 .59862 L
.70165 .60025 L
.70389 .60144 L
.70637 .60242 L
.70774 .60281 L
.70903 .60307 L
.71028 .60324 L
.71092 .60329 L
.71161 .60332 L
.71285 .60329 L
.714 .60319 L
.7147 .6031 L
.71536 .60298 L
.7166 .60268 L
.71793 .60226 L
.71938 .60168 L
.72183 .60043 L
.72404 .599 L
.72899 .59472 L
.73358 .58946 L
.73789 .58337 L
.74769 .5655 L
.75803 .54076 L
.77652 .48245 L
.81456 .31945 L
.83576 .21746 L
Mistroke
.85506 .13002 L
.86466 .09195 L
.87509 .05715 L
.87987 .04406 L
.88494 .03248 L
.88927 .02469 L
.89174 .02117 L
.89404 .01856 L
.89652 .01646 L
.89783 .01568 L
.89856 .01534 L
.89923 .01509 L
.90045 .0148 L
.90177 .01472 L
.90302 .01487 L
.90417 .01521 L
.90528 .01572 L
.90632 .01637 L
.90867 .01846 L
.91097 .02136 L
.91344 .02545 L
.91612 .03109 L
.91904 .03871 L
.92436 .05671 L
.92953 .07973 L
.93431 .10622 L
.94393 .17589 L
.95297 .26333 L
.96288 .38671 L
.97357 .55567 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[30]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "If you use the option ",
 StyleBox["Derivatives", "MR"],
 " with ",
 StyleBox["GeneralMiniMaxApproximation", "MR"],
 ", you must specify a list of derivatives for both parts of the \
parametrically defined function. "
}], "Text",
 CellTags->{"S5.76.1", "1.59"}],

Cell[TextData[{
 "This prevents ",
 StyleBox["gderivs", "MR"],
 " from acting on symbols. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.60"}],

Cell["\<\
gderivs[t_?NumberQ] :=
       Block[{exp = Exp[t]},
                {{exp, exp, exp}, {t,1,0}}
                           ]\
\>", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.76.1"],

Cell["We get the same result again. ", "MathCaption",
 CellTags->{"S5.76.1", "1.61"}],

Cell[CellGroupData[{

Cell["\<\
GeneralMiniMaxApproximation[
   {Exp[t], t},
         { t, {1,2}, 2, 4}, x,
         Derivatives -> gderivs[t]]\
\>", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.0471601651892473`", ",", "1.1813107377502203`", ",", 
     "1.3793050469654782`", ",", "1.6031080469331895`", ",", 
     "1.807147573896618`", ",", "1.9491940550750617`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "2.082397791620258`"}], "+", 
       RowBox[{"1.2738087749657254`", " ", "x"}], "+", 
       RowBox[{"0.8236002441476196`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "+", 
       RowBox[{"1.7318693038030615`", " ", "x"}], "+", 
       RowBox[{"0.2459175701488926`", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"0.0030965712045108603`", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"0.000058428236482215785`", " ", 
        SuperscriptBox["x", "4"]}]}]], ",", 
     RowBox[{"-", "6.746838846747863`*^-8"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[32]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "Another situation in which ",
 StyleBox["GeneralMiniMaxApproximation", "MR"],
 " is useful is when you want to do an approximation and measure its goodness \
of fit using the absolute error instead of the relative error that is used by \
default. If you want to use a different metric for the error, you can specify \
it as the third part of the parametrically defined function. If the function \
is given as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["x",
      "TI"], 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}], ",", 
     StyleBox["y",
      "TI"], 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}], ",", 
     StyleBox["g",
      "TI"], 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["h",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the rational minimax approximation to the function that relates ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", then the error that is minimized is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      StyleBox["y",
       "TI"], 
      RowBox[{"(", 
       StyleBox["t",
        "TI"], ")"}], "-", 
      StyleBox["h",
       "TI"], 
      RowBox[{"(", 
       RowBox[{
        StyleBox["x",
         "TI"], 
        RowBox[{"(", 
         StyleBox["t",
          "TI"], ")"}]}], ")"}]}], ")"}], "/", 
    StyleBox["g",
     "TI"], 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["g",
     "TI"], 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not specified, it is taken to be the same as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and it is the maximum relative error that is minimized. If you want to \
minimize the absolute error, simply use the constant ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["g",
     "TI"], 
    RowBox[{"(", 
     StyleBox["t",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", which is the default. "
}], "Text",
 CellTags->{"S5.76.1", "1.62"}],

Cell[TextData[{
 "This gives a rational minimax approximation to the inverse of ",
 StyleBox["Exp", "MR"],
 " with the maximum absolute error minimized. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.63"}],

Cell[CellGroupData[{

Cell["\<\
gmma2 =
 GeneralMiniMaxApproximation[
      {Exp[t], t, 1},
         {t, {1, 2}, 2, 4}, x]\
\>", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.76.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.0526677905951782`", ",", "1.1981457107951534`", ",", 
     "1.4034336396900813`", ",", "1.6253046633081871`", ",", 
     "1.820457892072561`", ",", "1.953108843809389`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "2.0701764032671144`"}], "+", 
       RowBox[{"1.2791576409933936`", " ", "x"}], "+", 
       RowBox[{"0.8066839312024124`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "+", 
       RowBox[{"1.7108292031453503`", " ", "x"}], "+", 
       RowBox[{"0.24006056468422934`", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"0.0029771835474699244`", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"0.000055461322731495475`", " ", 
        SuperscriptBox["x", "4"]}]}]], ",", 
     RowBox[{"-", "9.77379379394143`*^-8"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell["This extracts the approximation. ", "MathCaption",
 CellTags->{"S5.76.1", "1.64"}],

Cell["log = gmma2[[2,1]];", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.76.1"],

Cell[TextData[{
 "Now the ",
 StyleBox["absolute", "TI"],
 " error is equi\[Hyphen]oscillatory. "
}], "MathCaption",
 CellTags->{"S5.76.1", "1.65"}],

Cell[CellGroupData[{

Cell["Plot[log - Log[x], {x, E, E^2}]", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.76.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.530454 0.203902 0.309018 3.01115e+06 [
[.28515 .29652 -3 -9 ]
[.28515 .29652 3 0 ]
[.48906 .29652 -3 -9 ]
[.48906 .29652 3 0 ]
[.69296 .29652 -3 -9 ]
[.69296 .29652 3 0 ]
[.89686 .29652 -3 -9 ]
[.89686 .29652 3 0 ]
[.06875 .0079 -39 -6.25 ]
[.06875 .0079 0 6.25 ]
[.06875 .15846 -39 -6.25 ]
[.06875 .15846 0 6.25 ]
[.06875 .45957 -33 -6.25 ]
[.06875 .45957 0 6.25 ]
[.06875 .61013 -33 -6.25 ]
[.06875 .61013 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.28515 .30902 m
.28515 .31527 L
s
[(4)] .28515 .29652 0 1 Mshowa
.48906 .30902 m
.48906 .31527 L
s
[(5)] .48906 .29652 0 1 Mshowa
.69296 .30902 m
.69296 .31527 L
s
[(6)] .69296 .29652 0 1 Mshowa
.89686 .30902 m
.89686 .31527 L
s
[(7)] .89686 .29652 0 1 Mshowa
.125 Mabswid
.12203 .30902 m
.12203 .31277 L
s
.16281 .30902 m
.16281 .31277 L
s
.20359 .30902 m
.20359 .31277 L
s
.24437 .30902 m
.24437 .31277 L
s
.32594 .30902 m
.32594 .31277 L
s
.36672 .30902 m
.36672 .31277 L
s
.4075 .30902 m
.4075 .31277 L
s
.44828 .30902 m
.44828 .31277 L
s
.52984 .30902 m
.52984 .31277 L
s
.57062 .30902 m
.57062 .31277 L
s
.6114 .30902 m
.6114 .31277 L
s
.65218 .30902 m
.65218 .31277 L
s
.73374 .30902 m
.73374 .31277 L
s
.77452 .30902 m
.77452 .31277 L
s
.8153 .30902 m
.8153 .31277 L
s
.85608 .30902 m
.85608 .31277 L
s
.04047 .30902 m
.04047 .31277 L
s
.93764 .30902 m
.93764 .31277 L
s
.97842 .30902 m
.97842 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.08125 .0079 m
.0875 .0079 L
s
gsave
.06875 .0079 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.08125 .15846 m
.0875 .15846 L
s
gsave
.06875 .15846 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.08125 .45957 m
.0875 .45957 L
s
gsave
.06875 .45957 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.08125 .61013 m
.0875 .61013 L
s
gsave
.06875 .61013 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.125 Mabswid
.08125 .03801 m
.085 .03801 L
s
.08125 .06813 m
.085 .06813 L
s
.08125 .09824 m
.085 .09824 L
s
.08125 .12835 m
.085 .12835 L
s
.08125 .18857 m
.085 .18857 L
s
.08125 .21868 m
.085 .21868 L
s
.08125 .24879 m
.085 .24879 L
s
.08125 .27891 m
.085 .27891 L
s
.08125 .33913 m
.085 .33913 L
s
.08125 .36924 m
.085 .36924 L
s
.08125 .39935 m
.085 .39935 L
s
.08125 .42946 m
.085 .42946 L
s
.08125 .48969 m
.085 .48969 L
s
.08125 .5198 m
.085 .5198 L
s
.08125 .54991 m
.085 .54991 L
s
.08125 .58002 m
.085 .58002 L
s
.25 Mabswid
.08125 0 m
.08125 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02846 .40462 L
.03279 .26453 L
.03754 .1531 L
.0402 .10734 L
.04262 .07482 L
.04516 .04909 L
.0475 .03223 L
.04873 .02583 L
.05008 .02055 L
.05076 .01856 L
.05149 .0169 L
.05281 .0151 L
.05404 .01474 L
.05474 .01507 L
.05539 .01572 L
.05658 .01769 L
.05784 .02086 L
.05908 .02498 L
.06026 .02971 L
.06244 .04058 L
.06757 .0747 L
.07299 .12056 L
.08269 .21644 L
.09325 .32494 L
.10458 .43012 L
.11485 .50685 L
.12422 .55781 L
.12873 .57553 L
.13111 .58308 L
.13363 .58976 L
.13583 .59447 L
.13827 .59848 L
.13933 .59985 L
.14048 .60107 L
.14156 .60198 L
.14255 .6026 L
.14383 .60312 L
.14503 .60332 L
.14612 .60325 L
.14729 .60293 L
.14857 .60229 L
.14922 .60185 L
.14993 .60128 L
.15235 .59866 L
.15463 .59528 L
.15707 .59069 L
.16148 .58002 L
.16702 .56262 L
.17229 .54245 L
Mistroke
.18218 .49676 L
.22042 .27487 L
.24178 .15921 L
.26112 .07927 L
.27082 .05058 L
.27629 .03806 L
.28131 .02892 L
.28572 .02277 L
.28822 .02005 L
.29055 .01803 L
.29182 .01713 L
.29301 .01641 L
.2941 .01587 L
.29526 .01541 L
.29651 .01504 L
.29768 .01482 L
.29892 .01472 L
.29963 .01472 L
.3003 .01476 L
.30148 .01493 L
.30274 .01524 L
.30393 .01565 L
.30501 .01613 L
.30766 .01772 L
.31016 .01974 L
.31513 .02527 L
.32052 .0334 L
.33016 .05318 L
.33904 .07676 L
.3785 .22572 L
.41643 .39245 L
.43755 .47496 L
.45683 .53569 L
.46638 .55929 L
.47678 .5795 L
.48154 .58674 L
.48661 .59303 L
.49093 .59722 L
.4957 .60059 L
.49805 .60175 L
.49939 .60228 L
.50061 .60266 L
.5019 .60297 L
.50261 .6031 L
.50329 .60319 L
.50448 .6033 L
.50578 .60332 L
.50689 .60325 L
.50811 .6031 L
.50939 .60285 L
Mistroke
.51059 .60253 L
.51273 .60174 L
.51503 .60061 L
.5177 .59891 L
.52061 .5966 L
.52592 .59116 L
.53587 .57683 L
.5462 .55656 L
.55556 .53381 L
.57654 .46983 L
.61663 .31545 L
.6552 .16356 L
.67476 .0993 L
.68512 .07125 L
.69622 .04678 L
.70171 .03705 L
.70691 .02936 L
.71197 .02338 L
.7142 .02124 L
.71666 .01921 L
.71879 .01776 L
.72109 .0165 L
.72235 .01595 L
.72352 .01553 L
.72463 .01521 L
.72579 .01496 L
.72698 .0148 L
.72825 .01472 L
.72945 .01474 L
.73054 .01484 L
.73182 .01505 L
.73254 .01522 L
.73321 .01541 L
.7345 .01585 L
.73573 .01637 L
.73817 .01769 L
.74041 .01925 L
.74543 .02394 L
.74977 .02934 L
.7545 .03662 L
.76522 .05846 L
.77515 .08513 L
.79573 .15837 L
.81435 .24171 L
.85449 .44415 L
.87292 .52655 L
.88337 .56349 L
.88847 .57787 L
.89311 .58848 L
.89549 .59292 L
Mistroke
.89808 .5969 L
.90052 .59983 L
.9016 .60086 L
.90277 .60177 L
.904 .60251 L
.90516 .60299 L
.90586 .60318 L
.90653 .60329 L
.90779 .60329 L
.90911 .60301 L
.91033 .60248 L
.91103 .60206 L
.91167 .60161 L
.91311 .60032 L
.91443 .59879 L
.91582 .59682 L
.91832 .59236 L
.92101 .58615 L
.92396 .57757 L
.92925 .55733 L
.93419 .53237 L
.93919 .50066 L
.94463 .45821 L
.95453 .35774 L
.96417 .22772 L
.97308 .07554 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.76.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S5.76.1"]
}, Open  ]],

Cell[TextData[{
 "If you get an approximation for which the error is unacceptably large, \
there are several things you can do. If you increase the degree of the \
numerator and/or the denominator, the minimax error will usually decrease; it \
cannot increase. Even shifting a degree from the numerator to the denominator \
or vice versa can affect the size of the error. If the interval for which the \
approximation is to be valid is very long, it is probably a good idea to look \
at the asymptotic behavior of the function and choose degrees for the \
numerator and denominator that give the correct asymptotic behavior. For \
example, to get an approximation to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["tan", 
     RowBox[{"-", "1"}]], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for large ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the degrees of the numerator and denominator should be the same, since \
for large ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " the function has a nearly constant value of ",
 Cell[BoxData[
  FormBox[
   FractionBox["\[Pi]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.66"}],

Cell["\<\
Another way to decrease the error is to shorten the interval for which the \
approximation is to be valid. Often it is better to have several \
low\[Hyphen]degree approximations to cover a long interval than a single high\
\[Hyphen]degree approximation. The extra storage required is not that much, \
and each of the simpler approximations will evaluate faster. \
\>", "Text",
 CellTags->{"S5.76.1", "1.67"}],

Cell[TextData[{
 "To get an optimal minimax approximation you need to take into account the \
numerical behavior of the final approximation. It is usually a good idea to \
define the function so that the variable appearing in the approximation has \
values near the origin. Thus, instead of finding a minimax approximation to \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"999", "\[LessEqual]", 
    StyleBox["x",
     "TI"], "\[LessEqual]", "1001"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " it would be better to find a minimax approximation to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    RowBox[{
     StyleBox["t",
      "TI"], "+", "1000"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "\[LessEqual]", 
    StyleBox["t",
     "TI"], "\[LessEqual]", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.76.1", "1.68"}],

Cell[TextData[{
 "In cases where you want to avoid all potential problems associated with \
loss of digits due to subtractive cancellation, you may even want to do some \
shifting of the variable after the approximation is found. For example, the \
rational minimax approximation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"7", ",", "7"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "\[LessEqual]", 
    StyleBox["x",
     "TI"], "\[LessEqual]", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has positive coefficients in the numerator and coefficients with \
alternating signs in the denominator. The relative error in the approximation \
is only about ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "20"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", but using the approximation in the given form could result in a larger \
relative error, since a few bits could be lost due to cancellation near the \
endpoints: cancellation occurs in the numerator near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and in the denominator near ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". By replacing the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the numerator by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["s",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the denominator by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "-", 
    StyleBox["t",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", all coefficients in both the numerator and the denominator become \
positive, and the values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " will be between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "; no cancellation can occur. Of course all of this must be done to much \
higher precision to ensure that the coefficients themselves are correct to \
the required precision. "
}], "Text",
 CellTags->{"S5.76.1", "1.69"}],

Cell[TextData[{
 "It is very important to also consider the zeros of the function and its \
asymptotic behavior. The simplicity of the resulting minimax approximation is \
",
 StyleBox["greatly", "TI"],
 " affected by the extent to which you can trivially make the function look \
like a constant function. As an example, to find a minimax approximation to \
",
 StyleBox["Gamma[1/2, ", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", Infinity]", "MR"],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", 
    StyleBox["x",
     "TI"], "\[LessEqual]", "3"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", you can consider the function ",
 StyleBox["Gamma[1/2, ", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", Infinity] Exp[", "MR"],
 StyleBox["x", "TI"],
 StyleBox["] (", "MR"],
 StyleBox["x", "TI"],
 StyleBox[" + 4/7)", "MR"],
 " (",
 StyleBox["cf.", "TI"],
 " Abramowitz and Stegun, ",
 StyleBox["Handbook of Mathematical Functions", "TI"],
 ", 6.5.31; the 4/7 was chosen empirically). This function only varies a few \
percent over the interval in question; it will be ",
 StyleBox["much", "TI"],
 " easier to find a minimax approximation to this function than to the \
original function. "
}], "Text",
 CellTags->{"S5.76.1", "1.70"}],

Cell["\<\
If you are attempting to minimize the maximum relative error, and there are \
zeros of the function in the interval in question, you will have to divide \
out the zeros first. If singularities occur in the interval they will have to \
be eliminated also, either by multiplying by a zero or subtracting them away. \
\
\>", "Text",
 CellTags->{"S5.76.1", "1.71"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.76.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.76.1", "1.1"}],
    Cell[1923, 61, 768, 21, 88, "Text",
      CellTags->{"S5.76.1", "1.2"}],
    Cell[2694, 84, 523, 10, 88, "Text",
      CellTags->{"S5.76.1", "1.3"}],
    Cell[3220, 96, 545, 15, 72, "Text",
      CellTags->{"S5.76.1", "1.4"}],
    Cell[3768, 113, 6003, 191, 120, "DefinitionBox",
      CellTags->"S5.76.1"],
    Cell[9774, 306, 66, 1, 15, "Caption",
      CellTags->"S5.76.1"],
    Cell[9843, 309, 360, 8, 56, "Text",
      CellTags->{"S5.76.1", "1.5"}],
    Cell[10206, 319, 978, 28, 88, "Text",
      CellTags->{"S5.76.1", "1.6"}],
    Cell[11187, 349, 78, 1, 38, "MathCaption",
      CellTags->{"S5.76.1", "1.7"}],
    Cell[11268, 352, 94, 2, 28, "Input",
      CellTags->"S5.76.1"],
    Cell[11365, 356, 524, 18, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.8"}],
    Cell[11914, 378, 165, 6, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[12082, 386, 580, 16, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[12677, 405, 194, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.9"}],
    Cell[12896, 413, 92, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[12991, 417, 6046, 401, 70, 5975, 398, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[19040, 820, 180, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[19235, 829, 161, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.10"}],
    Cell[19421, 838, 149, 6, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[19573, 846, 598, 16, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[20186, 865, 194, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.11"}],
    Cell[20405, 873, 110, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[20518, 880, 6259, 410, 70, 6188, 407, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[26780, 1292, 180, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[26975, 1301, 2670, 77, 70, "DefinitionBox3Col",
      CellTags->"S5.76.1"],
    Cell[29648, 1380, 77, 1, 70, "Caption",
      CellTags->"S5.76.1"],
    Cell[29728, 1383, 1012, 32, 70, "Text",
      CellTags->{"S5.76.1", "1.12"}],
    Cell[30743, 1417, 184, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.13"}],
    Cell[30952, 1425, 167, 6, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[31122, 1433, 595, 16, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[31732, 1452, 93, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.14"}],
    Cell[31850, 1457, 113, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[31966, 1464, 7596, 486, 70, 7525, 483, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[39565, 1952, 180, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[39760, 1961, 1881, 53, 70, "Text",
      CellTags->{"S5.76.1", "1.15"}],
    Cell[41644, 2016, 4930, 155, 70, "DefinitionBox",
      CellTags->"S5.76.1"],
    Cell[46577, 2173, 68, 1, 70, "Caption",
      CellTags->"S5.76.1"],
    Cell[46648, 2176, 545, 10, 70, "Text",
      CellTags->{"S5.76.1", "1.16"}],
    Cell[47196, 2188, 688, 12, 70, "Text",
      CellTags->{"S5.76.1", "1.17"}],
    Cell[47887, 2202, 202, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.18"}],
    Cell[48114, 2210, 137, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[48254, 2217, 1031, 27, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[49300, 2247, 97, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.19"}],
    Cell[49422, 2252, 86, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[49511, 2256, 596, 16, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[50122, 2275, 451, 12, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.20"}],
    Cell[50598, 2291, 98, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[50699, 2295, 6585, 425, 70, 6514, 422, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[57287, 2722, 181, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[57483, 2731, 622, 14, 70, "Text",
      CellTags->{"S5.76.1", "1.21"}],
    Cell[58108, 2747, 249, 8, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.22"}],
    Cell[58382, 2759, 131, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[58516, 2766, 357, 8, 70, "Message",
      CellTags->"S5.76.1"],
    Cell[58876, 2776, 300, 10, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[59191, 2789, 247, 10, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.23"}],
    Cell[59463, 2803, 135, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[59601, 2810, 582, 16, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[60198, 2829, 266, 11, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.24"}],
    Cell[60489, 2844, 86, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[60578, 2848, 727, 21, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[61320, 2872, 86, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.25"}],
    Cell[61431, 2877, 121, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[61555, 2884, 6772, 432, 70, 6701, 429, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[68330, 3318, 181, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[68526, 3327, 1197, 32, 70, "Text",
      CellTags->{"S5.76.1", "1.26"}],
    Cell[69726, 3361, 241, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.27"}],
    Cell[69992, 3370, 132, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[70127, 3377, 525, 10, 70, "Message",
      CellTags->"S5.76.1"],
    Cell[70655, 3389, 986, 26, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[71656, 3418, 111, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.28"}],
    Cell[71792, 3423, 91, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[71886, 3427, 604, 18, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[72505, 3448, 150, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.29"}],
    Cell[72680, 3456, 98, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[72781, 3460, 5923, 383, 70, 5852, 380, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[78707, 3845, 181, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[78903, 3854, 155, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.30"}],
    Cell[79083, 3862, 152, 6, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[79238, 3870, 503, 14, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[79756, 3887, 354, 6, 70, "Text",
      CellTags->{"S5.76.1", "1.31"}],
    Cell[80113, 3895, 535, 9, 70, "Text",
      CellTags->{"S5.76.1", "1.32"}],
    Cell[80651, 3906, 222, 5, 70, "Text",
      CellTags->{"S5.76.1", "1.33"}],
    Cell[80876, 3913, 7116, 204, 70, "DefinitionBox3Col",
      CellTags->"S5.76.1"],
    Cell[87995, 4119, 76, 1, 70, "Caption",
      CellTags->"S5.76.1"],
    Cell[88074, 4122, 446, 11, 70, "Text",
      CellTags->{"S5.76.1", "1.34"}],
    Cell[88523, 4135, 740, 14, 70, "Text",
      CellTags->{"S5.76.1", "1.35"}],
    Cell[89266, 4151, 513, 12, 70, "Text",
      CellTags->{"S5.76.1", "1.36"}],
    Cell[89782, 4165, 508, 10, 70, "Text",
      CellTags->{"S5.76.1", "1.37"}],
    Cell[90293, 4177, 1950, 63, 70, "Text",
      CellTags->{"S5.76.1", "1.38"}],
    Cell[92246, 4242, 412, 11, 70, "Text",
      CellTags->{"S5.76.1", "1.39"}],
    Cell[92661, 4255, 295, 11, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.40"}],
    Cell[92959, 4268, 140, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[93102, 4275, 159, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.41"}],
    Cell[93286, 4283, 166, 6, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[93455, 4291, 848, 23, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[94318, 4317, 703, 16, 70, "Text",
      CellTags->{"S5.76.1", "1.42"}],
    Cell[95024, 4335, 218, 6, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.43"}],
    Cell[95267, 4345, 207, 8, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[95477, 4355, 193, 5, 70, "Message",
      CellTags->"S5.76.1"],
    Cell[95673, 4362, 845, 23, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[96533, 4388, 203, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.44"}],
    Cell[96761, 4396, 188, 7, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[96952, 4405, 851, 23, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[97818, 4431, 1157, 25, 70, "Text",
      CellTags->{"S5.76.1", "1.45"}],
    Cell[98978, 4458, 7651, 239, 70, "DefinitionBox",
      CellTags->"S5.76.1"],
    Cell[106632, 4699, 74, 1, 70, "Caption",
      CellTags->"S5.76.1"],
    Cell[106709, 4702, 597, 15, 70, "Text",
      CellTags->{"S5.76.1", "1.46"}],
    Cell[107309, 4719, 1559, 54, 70, "Text",
      CellTags->{"S5.76.1", "1.47"}],
    Cell[108871, 4775, 1991, 83, 70, "Text",
      CellTags->{"S5.76.1", "1.48"}],
    Cell[110865, 4860, 348, 9, 70, "Text",
      CellTags->{"S5.76.1", "1.49"}],
    Cell[111216, 4871, 147, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.50"}],
    Cell[111388, 4879, 188, 7, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[111579, 4888, 603, 16, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[112197, 4907, 100, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.51"}],
    Cell[112322, 4912, 136, 5, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[112461, 4919, 5514, 375, 70, 5443, 372, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[117978, 5296, 181, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[118174, 5305, 145, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.52"}],
    Cell[118344, 5313, 190, 7, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[118537, 5322, 588, 16, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[119140, 5341, 285, 6, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.53"}],
    Cell[119450, 5351, 102, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[119555, 5355, 6110, 427, 70, 6039, 424, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[125668, 5784, 181, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[125864, 5793, 9564, 301, 70, "DefinitionBox",
      CellTags->"S5.76.1"],
    Cell[135431, 6096, 73, 1, 70, "Caption",
      CellTags->"S5.76.1"],
    Cell[135507, 6099, 395, 11, 70, "Text",
      CellTags->{"S5.76.1", "1.54"}],
    Cell[135905, 6112, 328, 11, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.55"}],
    Cell[136258, 6127, 167, 7, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[136428, 6136, 1014, 27, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[137457, 6166, 327, 8, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.56"}],
    Cell[137809, 6178, 144, 6, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[137956, 6186, 1043, 27, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[139014, 6216, 96, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.57"}],
    Cell[139113, 6219, 83, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[139199, 6223, 429, 16, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.58"}],
    Cell[139653, 6243, 97, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[139753, 6247, 7670, 493, 70, 7599, 490, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[147426, 6742, 181, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[147622, 6751, 279, 8, 70, "Text",
      CellTags->{"S5.76.1", "1.59"}],
    Cell[147904, 6761, 142, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.60"}],
    Cell[148049, 6768, 195, 7, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[148247, 6777, 85, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.61"}],
    Cell[148357, 6782, 183, 7, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[148543, 6791, 1014, 27, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[149572, 6821, 3202, 121, 70, "Text",
      CellTags->{"S5.76.1", "1.62"}],
    Cell[152777, 6944, 205, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.63"}],
    Cell[153007, 6953, 162, 7, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[153172, 6962, 1014, 27, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[154201, 6992, 88, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.64"}],
    Cell[154292, 6995, 83, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[154378, 6999, 148, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.65"}],
    Cell[154551, 7008, 95, 2, 70, "Input",
      CellTags->"S5.76.1"],
    Cell[154649, 7012, 6691, 435, 70, 6620, 432, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.76.1"],
    Cell[161343, 7449, 181, 6, 70, "Output",
      CellTags->"S5.76.1"],
    Cell[161539, 7458, 1518, 39, 70, "Text",
      CellTags->{"S5.76.1", "1.66"}],
    Cell[163060, 7499, 418, 7, 70, "Text",
      CellTags->{"S5.76.1", "1.67"}],
    Cell[163481, 7508, 1305, 41, 70, "Text",
      CellTags->{"S5.76.1", "1.68"}],
    Cell[164789, 7551, 3253, 97, 70, "Text",
      CellTags->{"S5.76.1", "1.69"}],
    Cell[168045, 7650, 1297, 36, 70, "Text",
      CellTags->{"S5.76.1", "1.70"}],
    Cell[169345, 7688, 371, 7, 70, "Text",
      CellTags->{"S5.76.1", "1.71"}]},
  "1.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.76.1", "1.1"}]},
  "1.2"->{
    Cell[1923, 61, 768, 21, 88, "Text",
      CellTags->{"S5.76.1", "1.2"}]},
  "1.3"->{
    Cell[2694, 84, 523, 10, 88, "Text",
      CellTags->{"S5.76.1", "1.3"}]},
  "1.4"->{
    Cell[3220, 96, 545, 15, 72, "Text",
      CellTags->{"S5.76.1", "1.4"}]},
  "1.5"->{
    Cell[9843, 309, 360, 8, 56, "Text",
      CellTags->{"S5.76.1", "1.5"}]},
  "1.6"->{
    Cell[10206, 319, 978, 28, 88, "Text",
      CellTags->{"S5.76.1", "1.6"}]},
  "1.7"->{
    Cell[11187, 349, 78, 1, 38, "MathCaption",
      CellTags->{"S5.76.1", "1.7"}]},
  "1.8"->{
    Cell[11365, 356, 524, 18, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.8"}]},
  "1.9"->{
    Cell[12677, 405, 194, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.9"}]},
  "1.10"->{
    Cell[19235, 829, 161, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.10"}]},
  "1.11"->{
    Cell[20186, 865, 194, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.11"}]},
  "1.12"->{
    Cell[29728, 1383, 1012, 32, 70, "Text",
      CellTags->{"S5.76.1", "1.12"}]},
  "1.13"->{
    Cell[30743, 1417, 184, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.13"}]},
  "1.14"->{
    Cell[31732, 1452, 93, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.14"}]},
  "1.15"->{
    Cell[39760, 1961, 1881, 53, 70, "Text",
      CellTags->{"S5.76.1", "1.15"}]},
  "1.16"->{
    Cell[46648, 2176, 545, 10, 70, "Text",
      CellTags->{"S5.76.1", "1.16"}]},
  "1.17"->{
    Cell[47196, 2188, 688, 12, 70, "Text",
      CellTags->{"S5.76.1", "1.17"}]},
  "1.18"->{
    Cell[47887, 2202, 202, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.18"}]},
  "1.19"->{
    Cell[49300, 2247, 97, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.19"}]},
  "1.20"->{
    Cell[50122, 2275, 451, 12, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.20"}]},
  "1.21"->{
    Cell[57483, 2731, 622, 14, 70, "Text",
      CellTags->{"S5.76.1", "1.21"}]},
  "1.22"->{
    Cell[58108, 2747, 249, 8, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.22"}]},
  "1.23"->{
    Cell[59191, 2789, 247, 10, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.23"}]},
  "1.24"->{
    Cell[60198, 2829, 266, 11, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.24"}]},
  "1.25"->{
    Cell[61320, 2872, 86, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.25"}]},
  "1.26"->{
    Cell[68526, 3327, 1197, 32, 70, "Text",
      CellTags->{"S5.76.1", "1.26"}]},
  "1.27"->{
    Cell[69726, 3361, 241, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.27"}]},
  "1.28"->{
    Cell[71656, 3418, 111, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.28"}]},
  "1.29"->{
    Cell[72505, 3448, 150, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.29"}]},
  "1.30"->{
    Cell[78903, 3854, 155, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.30"}]},
  "1.31"->{
    Cell[79756, 3887, 354, 6, 70, "Text",
      CellTags->{"S5.76.1", "1.31"}]},
  "1.32"->{
    Cell[80113, 3895, 535, 9, 70, "Text",
      CellTags->{"S5.76.1", "1.32"}]},
  "1.33"->{
    Cell[80651, 3906, 222, 5, 70, "Text",
      CellTags->{"S5.76.1", "1.33"}]},
  "1.34"->{
    Cell[88074, 4122, 446, 11, 70, "Text",
      CellTags->{"S5.76.1", "1.34"}]},
  "1.35"->{
    Cell[88523, 4135, 740, 14, 70, "Text",
      CellTags->{"S5.76.1", "1.35"}]},
  "1.36"->{
    Cell[89266, 4151, 513, 12, 70, "Text",
      CellTags->{"S5.76.1", "1.36"}]},
  "1.37"->{
    Cell[89782, 4165, 508, 10, 70, "Text",
      CellTags->{"S5.76.1", "1.37"}]},
  "1.38"->{
    Cell[90293, 4177, 1950, 63, 70, "Text",
      CellTags->{"S5.76.1", "1.38"}]},
  "1.39"->{
    Cell[92246, 4242, 412, 11, 70, "Text",
      CellTags->{"S5.76.1", "1.39"}]},
  "1.40"->{
    Cell[92661, 4255, 295, 11, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.40"}]},
  "1.41"->{
    Cell[93102, 4275, 159, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.41"}]},
  "1.42"->{
    Cell[94318, 4317, 703, 16, 70, "Text",
      CellTags->{"S5.76.1", "1.42"}]},
  "1.43"->{
    Cell[95024, 4335, 218, 6, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.43"}]},
  "1.44"->{
    Cell[96533, 4388, 203, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.44"}]},
  "1.45"->{
    Cell[97818, 4431, 1157, 25, 70, "Text",
      CellTags->{"S5.76.1", "1.45"}]},
  "1.46"->{
    Cell[106709, 4702, 597, 15, 70, "Text",
      CellTags->{"S5.76.1", "1.46"}]},
  "1.47"->{
    Cell[107309, 4719, 1559, 54, 70, "Text",
      CellTags->{"S5.76.1", "1.47"}]},
  "1.48"->{
    Cell[108871, 4775, 1991, 83, 70, "Text",
      CellTags->{"S5.76.1", "1.48"}]},
  "1.49"->{
    Cell[110865, 4860, 348, 9, 70, "Text",
      CellTags->{"S5.76.1", "1.49"}]},
  "1.50"->{
    Cell[111216, 4871, 147, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.50"}]},
  "1.51"->{
    Cell[112197, 4907, 100, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.51"}]},
  "1.52"->{
    Cell[118174, 5305, 145, 4, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.52"}]},
  "1.53"->{
    Cell[119140, 5341, 285, 6, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.53"}]},
  "1.54"->{
    Cell[135507, 6099, 395, 11, 70, "Text",
      CellTags->{"S5.76.1", "1.54"}]},
  "1.55"->{
    Cell[135905, 6112, 328, 11, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.55"}]},
  "1.56"->{
    Cell[137457, 6166, 327, 8, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.56"}]},
  "1.57"->{
    Cell[139014, 6216, 96, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.57"}]},
  "1.58"->{
    Cell[139199, 6223, 429, 16, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.58"}]},
  "1.59"->{
    Cell[147622, 6751, 279, 8, 70, "Text",
      CellTags->{"S5.76.1", "1.59"}]},
  "1.60"->{
    Cell[147904, 6761, 142, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.60"}]},
  "1.61"->{
    Cell[148247, 6777, 85, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.61"}]},
  "1.62"->{
    Cell[149572, 6821, 3202, 121, 70, "Text",
      CellTags->{"S5.76.1", "1.62"}]},
  "1.63"->{
    Cell[152777, 6944, 205, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.63"}]},
  "1.64"->{
    Cell[154201, 6992, 88, 1, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.64"}]},
  "1.65"->{
    Cell[154378, 6999, 148, 5, 70, "MathCaption",
      CellTags->{"S5.76.1", "1.65"}]},
  "1.66"->{
    Cell[161539, 7458, 1518, 39, 70, "Text",
      CellTags->{"S5.76.1", "1.66"}]},
  "1.67"->{
    Cell[163060, 7499, 418, 7, 70, "Text",
      CellTags->{"S5.76.1", "1.67"}]},
  "1.68"->{
    Cell[163481, 7508, 1305, 41, 70, "Text",
      CellTags->{"S5.76.1", "1.68"}]},
  "1.69"->{
    Cell[164789, 7551, 3253, 97, 70, "Text",
      CellTags->{"S5.76.1", "1.69"}]},
  "1.70"->{
    Cell[168045, 7650, 1297, 36, 70, "Text",
      CellTags->{"S5.76.1", "1.70"}]},
  "1.71"->{
    Cell[169345, 7688, 371, 7, 70, "Text",
      CellTags->{"S5.76.1", "1.71"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.76.1", 170355, 7714},
  {"1.1", 183692, 8057},
  {"1.2", 183786, 8060},
  {"1.3", 183875, 8063},
  {"1.4", 183964, 8066},
  {"1.5", 184053, 8069},
  {"1.6", 184142, 8072},
  {"1.7", 184233, 8075},
  {"1.8", 184329, 8078},
  {"1.9", 184427, 8081},
  {"1.10", 184525, 8084},
  {"1.11", 184624, 8087},
  {"1.12", 184723, 8090},
  {"1.13", 184818, 8093},
  {"1.14", 184918, 8096},
  {"1.15", 185017, 8099},
  {"1.16", 185112, 8102},
  {"1.17", 185206, 8105},
  {"1.18", 185300, 8108},
  {"1.19", 185400, 8111},
  {"1.20", 185499, 8114},
  {"1.21", 185600, 8117},
  {"1.22", 185694, 8120},
  {"1.23", 185794, 8123},
  {"1.24", 185895, 8126},
  {"1.25", 185996, 8129},
  {"1.26", 186095, 8132},
  {"1.27", 186190, 8135},
  {"1.28", 186290, 8138},
  {"1.29", 186390, 8141},
  {"1.30", 186490, 8144},
  {"1.31", 186590, 8147},
  {"1.32", 186683, 8150},
  {"1.33", 186776, 8153},
  {"1.34", 186869, 8156},
  {"1.35", 186963, 8159},
  {"1.36", 187057, 8162},
  {"1.37", 187151, 8165},
  {"1.38", 187245, 8168},
  {"1.39", 187340, 8171},
  {"1.40", 187434, 8174},
  {"1.41", 187535, 8177},
  {"1.42", 187635, 8180},
  {"1.43", 187729, 8183},
  {"1.44", 187829, 8186},
  {"1.45", 187929, 8189},
  {"1.46", 188024, 8192},
  {"1.47", 188119, 8195},
  {"1.48", 188215, 8198},
  {"1.49", 188311, 8201},
  {"1.50", 188405, 8204},
  {"1.51", 188506, 8207},
  {"1.52", 188607, 8210},
  {"1.53", 188708, 8213},
  {"1.54", 188809, 8216},
  {"1.55", 188904, 8219},
  {"1.56", 189006, 8222},
  {"1.57", 189107, 8225},
  {"1.58", 189207, 8228},
  {"1.59", 189309, 8231},
  {"1.60", 189403, 8234},
  {"1.61", 189504, 8237},
  {"1.62", 189604, 8240},
  {"1.63", 189701, 8243},
  {"1.64", 189802, 8246},
  {"1.65", 189902, 8249},
  {"1.66", 190003, 8252},
  {"1.67", 190099, 8255},
  {"1.68", 190193, 8258},
  {"1.69", 190289, 8261},
  {"1.70", 190385, 8264},
  {"1.71", 190481, 8267}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 144, 6, 36, "Subsection",
  CellTags->{"S5.76.1", "1.1"}],
Cell[1923, 61, 768, 21, 88, "Text",
  CellTags->{"S5.76.1", "1.2"}],
Cell[2694, 84, 523, 10, 88, "Text",
  CellTags->{"S5.76.1", "1.3"}],
Cell[3220, 96, 545, 15, 72, "Text",
  CellTags->{"S5.76.1", "1.4"}],
Cell[3768, 113, 6003, 191, 120, "DefinitionBox",
  CellTags->"S5.76.1"],
Cell[9774, 306, 66, 1, 15, "Caption",
  CellTags->"S5.76.1"],
Cell[9843, 309, 360, 8, 56, "Text",
  CellTags->{"S5.76.1", "1.5"}],
Cell[10206, 319, 978, 28, 88, "Text",
  CellTags->{"S5.76.1", "1.6"}],
Cell[11187, 349, 78, 1, 38, "MathCaption",
  CellTags->{"S5.76.1", "1.7"}],
Cell[11268, 352, 94, 2, 28, "Input",
  CellTags->"S5.76.1"],
Cell[11365, 356, 524, 18, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.8"}],

Cell[CellGroupData[{
Cell[11914, 378, 165, 6, 70, "Input",
  CellTags->"S5.76.1"],
Cell[12082, 386, 580, 16, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[12677, 405, 194, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.9"}],

Cell[CellGroupData[{
Cell[12896, 413, 92, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[12991, 417, 6046, 401, 70, 5975, 398, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[19040, 820, 180, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[19235, 829, 161, 5, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.10"}],

Cell[CellGroupData[{
Cell[19421, 838, 149, 6, 70, "Input",
  CellTags->"S5.76.1"],
Cell[19573, 846, 598, 16, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[20186, 865, 194, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.11"}],

Cell[CellGroupData[{
Cell[20405, 873, 110, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[20518, 880, 6259, 410, 70, 6188, 407, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[26780, 1292, 180, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[26975, 1301, 2670, 77, 70, "DefinitionBox3Col",
  CellTags->"S5.76.1"],
Cell[29648, 1380, 77, 1, 70, "Caption",
  CellTags->"S5.76.1"],
Cell[29728, 1383, 1012, 32, 70, "Text",
  CellTags->{"S5.76.1", "1.12"}],
Cell[30743, 1417, 184, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.13"}],

Cell[CellGroupData[{
Cell[30952, 1425, 167, 6, 70, "Input",
  CellTags->"S5.76.1"],
Cell[31122, 1433, 595, 16, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[31732, 1452, 93, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.14"}],

Cell[CellGroupData[{
Cell[31850, 1457, 113, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[31966, 1464, 7596, 486, 70, 7525, 483, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[39565, 1952, 180, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[39760, 1961, 1881, 53, 70, "Text",
  CellTags->{"S5.76.1", "1.15"}],
Cell[41644, 2016, 4930, 155, 70, "DefinitionBox",
  CellTags->"S5.76.1"],
Cell[46577, 2173, 68, 1, 70, "Caption",
  CellTags->"S5.76.1"],
Cell[46648, 2176, 545, 10, 70, "Text",
  CellTags->{"S5.76.1", "1.16"}],
Cell[47196, 2188, 688, 12, 70, "Text",
  CellTags->{"S5.76.1", "1.17"}],
Cell[47887, 2202, 202, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.18"}],

Cell[CellGroupData[{
Cell[48114, 2210, 137, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[48254, 2217, 1031, 27, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[49300, 2247, 97, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.19"}],

Cell[CellGroupData[{
Cell[49422, 2252, 86, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[49511, 2256, 596, 16, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[50122, 2275, 451, 12, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.20"}],

Cell[CellGroupData[{
Cell[50598, 2291, 98, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[50699, 2295, 6585, 425, 70, 6514, 422, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[57287, 2722, 181, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[57483, 2731, 622, 14, 70, "Text",
  CellTags->{"S5.76.1", "1.21"}],
Cell[58108, 2747, 249, 8, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.22"}],

Cell[CellGroupData[{
Cell[58382, 2759, 131, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[58516, 2766, 357, 8, 70, "Message",
  CellTags->"S5.76.1"],
Cell[58876, 2776, 300, 10, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[59191, 2789, 247, 10, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.23"}],

Cell[CellGroupData[{
Cell[59463, 2803, 135, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[59601, 2810, 582, 16, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[60198, 2829, 266, 11, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.24"}],

Cell[CellGroupData[{
Cell[60489, 2844, 86, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[60578, 2848, 727, 21, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[61320, 2872, 86, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.25"}],

Cell[CellGroupData[{
Cell[61431, 2877, 121, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[61555, 2884, 6772, 432, 70, 6701, 429, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[68330, 3318, 181, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[68526, 3327, 1197, 32, 70, "Text",
  CellTags->{"S5.76.1", "1.26"}],
Cell[69726, 3361, 241, 5, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.27"}],

Cell[CellGroupData[{
Cell[69992, 3370, 132, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[70127, 3377, 525, 10, 70, "Message",
  CellTags->"S5.76.1"],
Cell[70655, 3389, 986, 26, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[71656, 3418, 111, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.28"}],

Cell[CellGroupData[{
Cell[71792, 3423, 91, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[71886, 3427, 604, 18, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[72505, 3448, 150, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.29"}],

Cell[CellGroupData[{
Cell[72680, 3456, 98, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[72781, 3460, 5923, 383, 70, 5852, 380, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[78707, 3845, 181, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[78903, 3854, 155, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.30"}],

Cell[CellGroupData[{
Cell[79083, 3862, 152, 6, 70, "Input",
  CellTags->"S5.76.1"],
Cell[79238, 3870, 503, 14, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[79756, 3887, 354, 6, 70, "Text",
  CellTags->{"S5.76.1", "1.31"}],
Cell[80113, 3895, 535, 9, 70, "Text",
  CellTags->{"S5.76.1", "1.32"}],
Cell[80651, 3906, 222, 5, 70, "Text",
  CellTags->{"S5.76.1", "1.33"}],
Cell[80876, 3913, 7116, 204, 70, "DefinitionBox3Col",
  CellTags->"S5.76.1"],
Cell[87995, 4119, 76, 1, 70, "Caption",
  CellTags->"S5.76.1"],
Cell[88074, 4122, 446, 11, 70, "Text",
  CellTags->{"S5.76.1", "1.34"}],
Cell[88523, 4135, 740, 14, 70, "Text",
  CellTags->{"S5.76.1", "1.35"}],
Cell[89266, 4151, 513, 12, 70, "Text",
  CellTags->{"S5.76.1", "1.36"}],
Cell[89782, 4165, 508, 10, 70, "Text",
  CellTags->{"S5.76.1", "1.37"}],
Cell[90293, 4177, 1950, 63, 70, "Text",
  CellTags->{"S5.76.1", "1.38"}],
Cell[92246, 4242, 412, 11, 70, "Text",
  CellTags->{"S5.76.1", "1.39"}],
Cell[92661, 4255, 295, 11, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.40"}],
Cell[92959, 4268, 140, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[93102, 4275, 159, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.41"}],

Cell[CellGroupData[{
Cell[93286, 4283, 166, 6, 70, "Input",
  CellTags->"S5.76.1"],
Cell[93455, 4291, 848, 23, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[94318, 4317, 703, 16, 70, "Text",
  CellTags->{"S5.76.1", "1.42"}],
Cell[95024, 4335, 218, 6, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.43"}],

Cell[CellGroupData[{
Cell[95267, 4345, 207, 8, 70, "Input",
  CellTags->"S5.76.1"],
Cell[95477, 4355, 193, 5, 70, "Message",
  CellTags->"S5.76.1"],
Cell[95673, 4362, 845, 23, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[96533, 4388, 203, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.44"}],

Cell[CellGroupData[{
Cell[96761, 4396, 188, 7, 70, "Input",
  CellTags->"S5.76.1"],
Cell[96952, 4405, 851, 23, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[97818, 4431, 1157, 25, 70, "Text",
  CellTags->{"S5.76.1", "1.45"}],
Cell[98978, 4458, 7651, 239, 70, "DefinitionBox",
  CellTags->"S5.76.1"],
Cell[106632, 4699, 74, 1, 70, "Caption",
  CellTags->"S5.76.1"],
Cell[106709, 4702, 597, 15, 70, "Text",
  CellTags->{"S5.76.1", "1.46"}],
Cell[107309, 4719, 1559, 54, 70, "Text",
  CellTags->{"S5.76.1", "1.47"}],
Cell[108871, 4775, 1991, 83, 70, "Text",
  CellTags->{"S5.76.1", "1.48"}],
Cell[110865, 4860, 348, 9, 70, "Text",
  CellTags->{"S5.76.1", "1.49"}],
Cell[111216, 4871, 147, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.50"}],

Cell[CellGroupData[{
Cell[111388, 4879, 188, 7, 70, "Input",
  CellTags->"S5.76.1"],
Cell[111579, 4888, 603, 16, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[112197, 4907, 100, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.51"}],

Cell[CellGroupData[{
Cell[112322, 4912, 136, 5, 70, "Input",
  CellTags->"S5.76.1"],
Cell[112461, 4919, 5514, 375, 70, 5443, 372, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[117978, 5296, 181, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[118174, 5305, 145, 4, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.52"}],

Cell[CellGroupData[{
Cell[118344, 5313, 190, 7, 70, "Input",
  CellTags->"S5.76.1"],
Cell[118537, 5322, 588, 16, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[119140, 5341, 285, 6, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.53"}],

Cell[CellGroupData[{
Cell[119450, 5351, 102, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[119555, 5355, 6110, 427, 70, 6039, 424, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[125668, 5784, 181, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[125864, 5793, 9564, 301, 70, "DefinitionBox",
  CellTags->"S5.76.1"],
Cell[135431, 6096, 73, 1, 70, "Caption",
  CellTags->"S5.76.1"],
Cell[135507, 6099, 395, 11, 70, "Text",
  CellTags->{"S5.76.1", "1.54"}],
Cell[135905, 6112, 328, 11, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.55"}],

Cell[CellGroupData[{
Cell[136258, 6127, 167, 7, 70, "Input",
  CellTags->"S5.76.1"],
Cell[136428, 6136, 1014, 27, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[137457, 6166, 327, 8, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.56"}],

Cell[CellGroupData[{
Cell[137809, 6178, 144, 6, 70, "Input",
  CellTags->"S5.76.1"],
Cell[137956, 6186, 1043, 27, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[139014, 6216, 96, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.57"}],
Cell[139113, 6219, 83, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[139199, 6223, 429, 16, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.58"}],

Cell[CellGroupData[{
Cell[139653, 6243, 97, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[139753, 6247, 7670, 493, 70, 7599, 490, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[147426, 6742, 181, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[147622, 6751, 279, 8, 70, "Text",
  CellTags->{"S5.76.1", "1.59"}],
Cell[147904, 6761, 142, 5, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.60"}],
Cell[148049, 6768, 195, 7, 70, "Input",
  CellTags->"S5.76.1"],
Cell[148247, 6777, 85, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.61"}],

Cell[CellGroupData[{
Cell[148357, 6782, 183, 7, 70, "Input",
  CellTags->"S5.76.1"],
Cell[148543, 6791, 1014, 27, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[149572, 6821, 3202, 121, 70, "Text",
  CellTags->{"S5.76.1", "1.62"}],
Cell[152777, 6944, 205, 5, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.63"}],

Cell[CellGroupData[{
Cell[153007, 6953, 162, 7, 70, "Input",
  CellTags->"S5.76.1"],
Cell[153172, 6962, 1014, 27, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[154201, 6992, 88, 1, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.64"}],
Cell[154292, 6995, 83, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[154378, 6999, 148, 5, 70, "MathCaption",
  CellTags->{"S5.76.1", "1.65"}],

Cell[CellGroupData[{
Cell[154551, 7008, 95, 2, 70, "Input",
  CellTags->"S5.76.1"],
Cell[154649, 7012, 6691, 435, 70, 6620, 432, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.76.1"],
Cell[161343, 7449, 181, 6, 70, "Output",
  CellTags->"S5.76.1"]
}, Open  ]],
Cell[161539, 7458, 1518, 39, 70, "Text",
  CellTags->{"S5.76.1", "1.66"}],
Cell[163060, 7499, 418, 7, 70, "Text",
  CellTags->{"S5.76.1", "1.67"}],
Cell[163481, 7508, 1305, 41, 70, "Text",
  CellTags->{"S5.76.1", "1.68"}],
Cell[164789, 7551, 3253, 97, 70, "Text",
  CellTags->{"S5.76.1", "1.69"}],
Cell[168045, 7650, 1297, 36, 70, "Text",
  CellTags->{"S5.76.1", "1.70"}],
Cell[169345, 7688, 371, 7, 70, "Text",
  CellTags->{"S5.76.1", "1.71"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

