(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10564,        396]*)
(*NotebookOutlinePosition[     13051,        475]*)
(*  CellTagsIndexPosition[     12840,        463]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "ArgColors",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.26.1", "1.1"}],

Cell[TextData[{
 "There are several ways to specify a complex number. The simplest is to give \
its real and imaginary parts. You can also use polar coordinates and specify \
the complex number by an angle, called the ",
 StyleBox["argument", "TI"],
 ", and a length, called the ",
 StyleBox["absolute value", "TI"],
 " or ",
 StyleBox["norm", "TI"],
 ". Thus, the complex number ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is equal to ",
 StyleBox["Abs[", "MR"],
 StyleBox["z", "TI"],
 StyleBox["] Exp[I Arg[", "MR"],
 StyleBox["z", "TI"],
 StyleBox["]]", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.26.1", "1.2"}],

Cell[TextData[{
 "The functions ",
 StyleBox["ArgColor", "MR"],
 ", ",
 StyleBox["ArgShade", "MR"],
 ", and ",
 StyleBox["ColorCircle", "MR"],
 " provided in this package are enhanced graphics directives. ",
 StyleBox["ArgColor", "MR"],
 " and ",
 StyleBox["ArgShade", "MR"],
 " allow you to specify the color or gray level of graphics elements using \
the argument of a complex number. ",
 StyleBox["ColorCircle[", "MR"],
 StyleBox["r", "TI"],
 StyleBox["]", "MR"],
 " treats ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " cyclically, but with a period of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " instead of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". It begins with red and runs through the spectrum, blending the high end \
back into red. "
}], "Text",
 CellTags->{"S5.26.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ArgColor[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a color value whose hue is proportional to the argument of the \
complex number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ArgShade[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["give a gray level",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColorCircle[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a color value whose hue is proportional to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColorCircle[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a color value whose hue is proportional to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", with brightness ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["b",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.26.1"],

Cell["\<\
Colors and gray levels using the arguments of complex numbers. \
\>", "Caption",
 CellTags->"S5.26.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.26.1", "1.4"}],

Cell["<<Graphics`ArgColors`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.26.1"],

Cell["The values of this function are points on the unit circle. ", \
"MathCaption",
 CellTags->{"S5.26.1", "1.5"}],

Cell["un[k_] := Exp[2 Pi I k / 10]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.26.1"],

Cell[TextData[{
 "For numbers near the negative ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, ",
 StyleBox["ArgShade", "MR"],
 " gives a low gray level. The shade grows darker as you move clockwise \
around the circle. "
}], "MathCaption",
 CellTags->{"S5.26.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[Table[
   {ArgShade[un[j]],
   Disk[{Re[un[j]], Im[un[j]]}, 0.2]},
   {j, 10}], AspectRatio -> Automatic]]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.26.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95921 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.396825 0.479607 0.396825 [
[ 0 0 0 0 ]
[ 1 .95921 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95921 L
0 .95921 L
closepath
clip
newpath
.6 g
.82104 .71285 m
.82104 .71285 .07937 0 365.73 arc
F
.7 g
.62263 .85701 m
.62263 .85701 .07937 0 365.73 arc
F
.8 g
.37737 .85701 m
.37737 .85701 .07937 0 365.73 arc
F
.9 g
.17896 .71285 m
.17896 .71285 .07937 0 365.73 arc
F
1 g
.10317 .47961 m
.10317 .47961 .07937 0 365.73 arc
F
.1 g
.17896 .24636 m
.17896 .24636 .07937 0 365.73 arc
F
.2 g
.37737 .1022 m
.37737 .1022 .07937 0 365.73 arc
F
.3 g
.62263 .1022 m
.62263 .1022 .07937 0 365.73 arc
F
.4 g
.82104 .24636 m
.82104 .24636 .07937 0 365.73 arc
F
.5 g
.89683 .47961 m
.89683 .47961 .07937 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.26.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.26.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.26.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.26.1", "1.1"}],
    Cell[1913, 61, 710, 23, 72, "Text",
      CellTags->{"S5.26.1", "1.2"}],
    Cell[2626, 86, 1056, 34, 88, "Text",
      CellTags->{"S5.26.1", "1.3"}],
    Cell[3685, 122, 4352, 136, 144, "DefinitionBox",
      CellTags->"S5.26.1"],
    Cell[8040, 260, 112, 3, 15, "Caption",
      CellTags->"S5.26.1"],
    Cell[8155, 265, 78, 1, 40, "MathCaption",
      CellTags->{"S5.26.1", "1.4"}],
    Cell[8236, 268, 84, 2, 28, "Input",
      CellTags->"S5.26.1"],
    Cell[8323, 272, 115, 2, 40, "MathCaption",
      CellTags->{"S5.26.1", "1.5"}],
    Cell[8441, 276, 91, 2, 28, "Input",
      CellTags->"S5.26.1"],
    Cell[8535, 280, 372, 12, 56, "MathCaption",
      CellTags->{"S5.26.1", "1.6"}],
    Cell[8932, 296, 191, 7, 75, "Input",
      CellTags->"S5.26.1"],
    Cell[9126, 305, 1227, 79, 70, 1156, 76, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.26.1"],
    Cell[10356, 386, 180, 6, 70, "Output",
      CellTags->"S5.26.1"]},
  "1.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.26.1", "1.1"}]},
  "1.2"->{
    Cell[1913, 61, 710, 23, 72, "Text",
      CellTags->{"S5.26.1", "1.2"}]},
  "1.3"->{
    Cell[2626, 86, 1056, 34, 88, "Text",
      CellTags->{"S5.26.1", "1.3"}]},
  "1.4"->{
    Cell[8155, 265, 78, 1, 40, "MathCaption",
      CellTags->{"S5.26.1", "1.4"}]},
  "1.5"->{
    Cell[8323, 272, 115, 2, 40, "MathCaption",
      CellTags->{"S5.26.1", "1.5"}]},
  "1.6"->{
    Cell[8535, 280, 372, 12, 56, "MathCaption",
      CellTags->{"S5.26.1", "1.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.26.1", 11187, 412},
  {"1.1", 12265, 441},
  {"1.2", 12359, 444},
  {"1.3", 12448, 447},
  {"1.4", 12538, 450},
  {"1.5", 12633, 453},
  {"1.6", 12729, 456}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 6, 36, "Subsection",
  CellTags->{"S5.26.1", "1.1"}],
Cell[1913, 61, 710, 23, 72, "Text",
  CellTags->{"S5.26.1", "1.2"}],
Cell[2626, 86, 1056, 34, 88, "Text",
  CellTags->{"S5.26.1", "1.3"}],
Cell[3685, 122, 4352, 136, 144, "DefinitionBox",
  CellTags->"S5.26.1"],
Cell[8040, 260, 112, 3, 15, "Caption",
  CellTags->"S5.26.1"],
Cell[8155, 265, 78, 1, 40, "MathCaption",
  CellTags->{"S5.26.1", "1.4"}],
Cell[8236, 268, 84, 2, 28, "Input",
  CellTags->"S5.26.1"],
Cell[8323, 272, 115, 2, 40, "MathCaption",
  CellTags->{"S5.26.1", "1.5"}],
Cell[8441, 276, 91, 2, 28, "Input",
  CellTags->"S5.26.1"],
Cell[8535, 280, 372, 12, 56, "MathCaption",
  CellTags->{"S5.26.1", "1.6"}],

Cell[CellGroupData[{
Cell[8932, 296, 191, 7, 75, "Input",
  CellTags->"S5.26.1"],
Cell[9126, 305, 1227, 79, 70, 1156, 76, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.26.1"],
Cell[10356, 386, 180, 6, 70, "Output",
  CellTags->"S5.26.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

