(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40329,       1927]*)
(*NotebookOutlinePosition[     46195,       2102]*)
(*  CellTagsIndexPosition[     45755,       2081]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Graphics",
  StyleBox["`", "MB"],
  "Arrow",
  StyleBox["`", "MB"]
}], "Subsection",
  CellTags->{"S5.27.1", "1.1"}],

Cell[TextData[{
  "In top\[Hyphen]level ",
  StyleBox["Mathematica", "TI"],
  " code, it is possible to create a graphic representing a \
two\[Hyphen]dimensional arrow. However, since such a graphic is in the \
standard ",
  StyleBox["Mathematica", "TI"],
  " coordinate system, it does not maintain its aspect ratio when the aspect \
ratio of the coordinate system is changed. This can lead to a rather odd \
looking arrow. This package implements a new graphics primitive to generate \
arrows that can maintain their aspect ratio, and can be quite flexible. "
}], "Text",
  CellTags->{"S5.27.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Arrow[\"\>",
                      "MR"], 
                    StyleBox["\<\"start\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"finish\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"opts\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"a graphics primitive that draws an arrow from \
coordinate \"\>", 
                    StyleBox["\<\"start\"\>",
                      "TI"], "\<\" to \"\>", 
                    StyleBox["\<\"finish\"\>",
                      "TI"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.27.1"],

Cell[TextData[{
  "The ",
  StyleBox["Arrow", "MR"],
  " graphics primitive. "
}], "Caption",
  CellTags->"S5.27.1"],

Cell[TextData[{
  "The ",
  StyleBox["Arrow", "MR"],
  " primitive behaves much as built\[Hyphen]in ",
  StyleBox["Graphics", "MR"],
  " primitives. It obeys color directives, and the line of the arrow follows \
thickness and dashing directives. "
}], "Text",
  CellTags->{"S5.27.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
  CellTags->{"S5.27.1", "1.4"}],

Cell["<<Graphics`Arrow`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S5.27.1"],

Cell["Here is a simple example of two arrows in different colors. ", \
"MathCaption",
  CellTags->{"S5.27.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[{Arrow[{0, 0},{1, 1}],
    Hue[0], Arrow[{.75, .25},{.25, .75}]}]]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S5.27.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .01472 m
.97619 .60332 L
s
% Start of user PostScript
0 0 1. 1. MAarrowhead1
% End of user PostScript
1 0 0 r
.7381 .16187 m
.2619 .45617 L
s
% Start of user PostScript
0.75 0.25 0.25 0.75 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.27.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S5.27.1"]
}, Open  ]],

Cell["You can even place arrows in options.", "MathCaption",
  CellTags->{"S5.27.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Sin[x], {x, 0, 2Pi},
    Epilog -> {Arrow[{4, .25}, {Pi/2, 1}],
     Text[\"Here\", {4, .15}, {0, -1}]}
]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S5.27.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
.63011 .38259 m
.2619 .60332 L
s
% Start of user PostScript
4. 0.25 1.5708 1. MAarrowhead1
% End of user PostScript
gsave
.63011 .35316 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Here) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.27.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S5.27.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HeadScaling\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"scaling to use for coordinates in arrowhead; \
either \"\>", 
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], \(\(,\)\(\ \)\), 
                    StyleBox["\<\"Relative\"\>",
                      "MR"], \(\(,\)\(\ \)\(or\)\(\ \)\), 
                    StyleBox["\<\"Absolute\"\>",
                      "MR"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HeadShape\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"shape of the arrowhead; if \"\>", 
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" uses a description parameterized by \"\>", 
                    
                    StyleBox["\<\"HeadLength\"\>",
                      "MR"], \(\(,\)\(\ \)\), 
                    StyleBox["\<\"HeadWidth\"\>",
                      "MR"], \(\(,\)\(\ \)\(and\)\(\ \)\), 
                    StyleBox["\<\"HeadCenter\"\>",
                      "MR"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HeadLength\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"length of the arrowhead; varies according to \
the value of \"\>", 
                    StyleBox["\<\"HeadScaling\"\>",
                      "MR"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HeadWidth\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\".5\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"width of the arrowhead, expressed as a \
factor of the length of the arrowhead"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HeadCenter\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"1\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"location of the center of the base of the \
arrowhead, expressed as a factor of the length of the arrowhead"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ZeroShape\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"shape of an arrow with no length; default \
is a dot"\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S5.27.1"],

Cell[TextData[{
  "Options for the ",
  StyleBox["Arrow", "MR"],
  " primitive."
}], "Caption",
  CellTags->"S5.27.1"],

Cell[TextData[{
  "There are several options that can be used to adjust the style of the \
arrowhead. ",
  StyleBox["HeadScaling", "MR"],
  " determines the scaling of the coordinate system used in drawing the \
arrowhead. When it is ",
  StyleBox["Automatic", "MR"],
  ", the coordinate system is centered at the tip of the arrow, and is \
rotated to lie along the arrow (with the negative direction towards the tail \
of the arrow). It is scaled by the default attributes coordinate scaling, \
where the distance across the bottom of the graphic is one unit. This allows \
the arrowheads to be scaled directly to the size of the graphic. When it is \
",
  StyleBox["Relative", "MR"],
  ", the coordinate system is scaled so that ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["0,0", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  " is at the head of the arrow, and ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["0,-1", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  " is at the tail of the arrow. This means that the size of a given \
arrowhead will vary with the length of the arrow. When ",
  StyleBox["HeadScaling", "MR"],
  " is ",
  StyleBox["Absolute", "MR"],
  ", the device coordinate scaling is used, centered at the head of the \
arrow, and rotated along the arrow. In this coordinate system, units are \
identical to those used by the standard graphics directives ",
  StyleBox["AbsoluteDashing", "MR"],
  " and ",
  StyleBox["AbsoluteThickness", "MR"],
  ". Whichever coordinate system is being used must be taken into account \
when specifying a style of arrowhead other than the default. "
}], "Text",
  CellTags->{"S5.27.1", "1.7"}],

Cell[TextData[{
  "There are two ways to specify the shape of an arrowhead. One is a \
parameterized method, used when ",
  StyleBox["HeadShape", "MR"],
  " is ",
  StyleBox["Automatic", "MR"],
  ". The parameterized arrowhead is based on three values: ",
  StyleBox["HeadLength", "MR"],
  ", ",
  StyleBox["HeadWidth", "MR"],
  ", and ",
  StyleBox["HeadCenter", "MR"],
  ". ",
  StyleBox["HeadLength", "MR"],
  " specifies the distance from the tip of the arrowhead to its base. It is \
measured in the coordinate system given by ",
  StyleBox["HeadScaling", "MR"],
  ", that is, if ",
  StyleBox["HeadScaling", "MR"],
  " is ",
  StyleBox["Relative", "MR"],
  ", the length is a factor of the length of the entire arrow, and if ",
  StyleBox["HeadScaling", "MR"],
  " is ",
  StyleBox["Absolute", "MR"],
  ", the length is in printer's points. ",
  StyleBox["HeadWidth", "MR"],
  " specifies the greatest distance between the sides of the arrowhead, as a \
factor of the length of the arrowhead. ",
  StyleBox["HeadCenter", "MR"],
  " specifies the location of the center of the base of the arrowhead as a \
factor of the length of the arrowhead. When ",
  StyleBox["HeadCenter", "MR"],
  " is ",
  StyleBox["1", "MR"],
  ", the center of the base is as long as the length of the head, so the head \
is a triangle; when it is ",
  StyleBox["0", "MR"],
  ", the arrow is reduced to a line. "
}], "Text",
  CellTags->{"S5.27.1", "1.8"}],

Cell[TextData[{
  "The other way of specifying the shape of an arrowhead is by a list of ",
  StyleBox["Graphics", "MR"],
  " primitives. Currently, the routines only understand a subset of the \
graphics primitives; they are ",
  StyleBox["Point", "MR"],
  ", ",
  StyleBox["Line", "MR"],
  ", ",
  StyleBox["Polygon", "MR"],
  ", and the various style directives. They are drawn in the same coordinate \
system as specified by the ",
  StyleBox["HeadScaling", "MR"],
  " option, so the heads are automatically rotated to be along the length of \
the arrow, with the origin of the coordinate system at the tip of the arrow. \
"
}], "Text",
  CellTags->{"S5.27.1", "1.9"}],

Cell[TextData[{
  "An arrow whose starting and ending points are identical has no length, and \
hence no direction. Thus, we usually use a different shape to describe it. \
The option ",
  StyleBox["ZeroShape", "MR"],
  " can be used for this purpose. When it is set to ",
  StyleBox["Automatic", "MR"],
  ", the zero length vector is drawn as a point. The coordinate system is \
left unrotated, because no direction can be determined. "
}], "Text",
  CellTags->{"S5.27.1", "1.10"}],

Cell["\<\
With relative scaling, the size of the arrowhead varies with the \
length of the arrow.\
\>", "MathCaption",
  CellTags->{"S5.27.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[
    Table[Arrow[{0, 0}, x {Sin[x], Cos[x]},
     HeadScaling -> Relative],
          {x, 0, 2 Pi, .3}]
], PlotRange -> All]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S5.27.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.714387 0.144424 0.227369 0.0652575 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
arrl arrl scale
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.2 0.05 moveto 0 0 lineto
-0.2 -0.05 lineto fill
-0.2 0.05 moveto 0 0 lineto
-0.2 -0.05 lineto
-0.2 0.05 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.71439 .22737 m
.71439 .22737 L
s
% Start of user PostScript
0 0 MAarrowzero1
% End of user PostScript
.71439 .22737 m
.72719 .24607 L
s
% Start of user PostScript
0 0 0.0886561 0.286601 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.76332 .25968 L
s
% Start of user PostScript
0 0 0.338785 0.495201 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.81621 .26388 L
s
% Start of user PostScript
0 0 0.704994 0.559449 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.87592 .25574 L
s
% Start of user PostScript
0 0 1.11845 0.434829 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.93048 .23429 L
s
% Start of user PostScript
0 0 1.49624 0.106106 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.96755 .20068 L
s
% Start of user PostScript
0 0 1.75293 -0.408964 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.97619 .15818 L
s
% Start of user PostScript
0 0 1.81274 -1.06018 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.94851 .11188 L
s
% Start of user PostScript
0 0 1.62111 -1.76974 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.88104 .06808 L
s
% Start of user PostScript
0 0 1.15393 -2.44099 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.77553 .03356 L
s
% Start of user PostScript
0 0 0.42336 -2.96998 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.63921 .01472 L
s
% Start of user PostScript
0 0 -0.520561 -3.25868 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.48431 .0167 L
s
% Start of user PostScript
0 0 -1.59307 -3.22833 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.327 .04262 L
s
% Start of user PostScript
0 0 -2.68229 -2.83114 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.18571 .093 L
s
% Start of user PostScript
0 0 -3.66062 -2.0591 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.07908 .16547 L
s
% Start of user PostScript
0 0 -4.39889 -0.948581 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.02381 .25478 L
s
% Start of user PostScript
0 0 -4.78159 0.419995 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.03247 .35316 L
s
% Start of user PostScript
0 0 -4.72165 1.92769 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.11172 .45103 L
s
% Start of user PostScript
0 0 -4.17293 3.42734 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.26105 .53786 L
s
% Start of user PostScript
0 0 -3.13891 4.75786 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.47226 .60332 L
s
% Start of user PostScript
0 0 -1.67649 5.76102 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.27.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S5.27.1"]
}, Open  ]],

Cell["With absolute scaling, all arrowheads are the same size.", "MathCaption",
  CellTags->{"S5.27.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[
    Table[Arrow[{0, 0}, x {Sin[x], Cos[x]},
          HeadScaling -> Absolute],
   {x, 0, 2 Pi, .3}]
], PlotRange -> All]\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S5.27.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.714387 0.144424 0.227369 0.0652575 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
currentlinewidth 1 Mabswid
currentlinewidth dup scale setlinewidth
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-15. 3.75 moveto 0 0 lineto
-15. -3.75 lineto fill
-15. 3.75 moveto 0 0 lineto
-15. -3.75 lineto
-15. 3.75 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
currentlinewidth 1 Mabswid
currentlinewidth dup scale setlinewidth
0 0 Mdot
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.71439 .22737 m
.71439 .22737 L
s
% Start of user PostScript
0 0 MAarrowzero1
% End of user PostScript
.71439 .22737 m
.72719 .24607 L
s
% Start of user PostScript
0 0 0.0886561 0.286601 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.76332 .25968 L
s
% Start of user PostScript
0 0 0.338785 0.495201 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.81621 .26388 L
s
% Start of user PostScript
0 0 0.704994 0.559449 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.87592 .25574 L
s
% Start of user PostScript
0 0 1.11845 0.434829 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.93048 .23429 L
s
% Start of user PostScript
0 0 1.49624 0.106106 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.96755 .20068 L
s
% Start of user PostScript
0 0 1.75293 -0.408964 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.97619 .15818 L
s
% Start of user PostScript
0 0 1.81274 -1.06018 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.94851 .11188 L
s
% Start of user PostScript
0 0 1.62111 -1.76974 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.88104 .06808 L
s
% Start of user PostScript
0 0 1.15393 -2.44099 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.77553 .03356 L
s
% Start of user PostScript
0 0 0.42336 -2.96998 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.63921 .01472 L
s
% Start of user PostScript
0 0 -0.520561 -3.25868 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.48431 .0167 L
s
% Start of user PostScript
0 0 -1.59307 -3.22833 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.327 .04262 L
s
% Start of user PostScript
0 0 -2.68229 -2.83114 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.18571 .093 L
s
% Start of user PostScript
0 0 -3.66062 -2.0591 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.07908 .16547 L
s
% Start of user PostScript
0 0 -4.39889 -0.948581 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.02381 .25478 L
s
% Start of user PostScript
0 0 -4.78159 0.419995 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.03247 .35316 L
s
% Start of user PostScript
0 0 -4.72165 1.92769 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.11172 .45103 L
s
% Start of user PostScript
0 0 -4.17293 3.42734 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.26105 .53786 L
s
% Start of user PostScript
0 0 -3.13891 4.75786 MAarrowhead1
% End of user PostScript
.71439 .22737 m
.47226 .60332 L
s
% Start of user PostScript
0 0 -1.67649 5.76102 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.27.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S5.27.1"]
}, Open  ]],

Cell[TextData[{
  "This shows how the shape of the arrowhead can be modified by the \
parameters ",
  StyleBox["HeadCenter", "MR"],
  " and ",
  StyleBox["HeadLength", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S5.27.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[
 Table[Arrow[{0,0},{Sin[x], Cos[x]},
 HeadCenter -> x,
 HeadLength -> .1],
 {x,0,1.6,.2}]
 ],
PlotRange -> {{-.1,1},{-.2,1.1}},
AspectRatio -> Automatic]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S5.27.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0909091 0.909091 0.181818 0.909091 [
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025  moveto 0 0 lineto 
-0.1 -0.025  lineto stroke
} ifelse
grestore
} def
/MAarrowhead2 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.02 0 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.02 0 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
/MAarrowhead3 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.04 0 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.04 0 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
/MAarrowhead4 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.06 0 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.06 0 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
/MAarrowhead5 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.08 0 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.08 0 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
/MAarrowhead6 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
/MAarrowhead7 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.12 0 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.12 0 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
/MAarrowhead8 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.14 0 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.14 0 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
/MAarrowhead9 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.16 0 lineto fill
-0.1 0.025 moveto 0 0 lineto
-0.1 -0.025 lineto
-0.16 0 lineto
-0.1 0.025 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.09091 .18182 m
.09091 1.09091 L
s
% Start of user PostScript
0 0 0 1. MAarrowhead1
% End of user PostScript
.09091 .18182 m
.27152 1.07279 L
s
% Start of user PostScript
0 0 0.198669 0.980067 MAarrowhead2
% End of user PostScript
.09091 .18182 m
.44493 1.01915 L
s
% Start of user PostScript
0 0 0.389418 0.921061 MAarrowhead3
% End of user PostScript
.09091 .18182 m
.60422 .93212 L
s
% Start of user PostScript
0 0 0.564642 0.825336 MAarrowhead4
% End of user PostScript
.09091 .18182 m
.74305 .81519 L
s
% Start of user PostScript
0 0 0.717356 0.696707 MAarrowhead5
% End of user PostScript
.09091 .18182 m
.85588 .673 L
s
% Start of user PostScript
0 0 0.841471 0.540302 MAarrowhead6
% End of user PostScript
.09091 .18182 m
.93822 .51123 L
s
% Start of user PostScript
0 0 0.932039 0.362358 MAarrowhead7
% End of user PostScript
.09091 .18182 m
.98677 .33633 L
s
% Start of user PostScript
0 0 0.98545 0.169967 MAarrowhead8
% End of user PostScript
.09091 .18182 m
.99961 .15527 L
s
% Start of user PostScript
0 0 0.999574 -0.0291995 MAarrowhead9
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.27.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S5.27.1"]
}, Open  ]],

Cell[TextData[{
  "More general objects can be used to describe the head of an arrow. Note \
that the head is in a special coordinate system rotated along the arrow. The \
first arrow depicted here has a ",
  StyleBox["HeadShape", "MR"],
  " consisting of two triangular polygons. The second arrow depicted has a ",
  StyleBox["HeadShape", "MR"],
  " consisting of a cross formed by two intersecting lines. "
}], "MathCaption",
  CellTags->{"S5.27.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[{
 Arrow[{0,1},{1,0},
 HeadScaling -> Relative,
 HeadShape ->
 {Polygon[{{0,0},{-.2,.05},{-.2,-.05}}],
    Polygon[{{-1,0},{-.8,.05},
     {-.8,-.05}}]}],
 Arrow[{.25, .25}, {.75,.75},
 HeadShape -> {Line[{{.1,.1},{-.1,-.1}}],
 Line[{{.1,-.1},{-.1,.1}}]}
 ]},
PlotRange ->All]]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S5.27.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
arrl arrl scale
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
0 0 moveto -0.2 0.05 lineto -0.2 -0.05 lineto 
fill
-1. 0 moveto -0.8 0.05 lineto -0.8 -0.05 lineto 
fill
} ifelse
grestore
} def
/MAarrowhead2 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
0.1 0.1 moveto -0.1 -0.1 lineto 
stroke
0.1 -0.1 moveto -0.1 0.1 lineto 
stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .60332 m
.97619 .01472 L
s
% Start of user PostScript
0 1. 1. 0 MAarrowhead1
% End of user PostScript
.2619 .16187 m
.7381 .45617 L
s
% Start of user PostScript
0.25 0.25 0.75 0.75 MAarrowhead2
% End of user PostScript
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S5.27.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S5.27.1"]
}, Open  ]],

Cell["\<\
Note that the primary difficulty with the arrows created in this \
package is that the arrowheads are not involved in the scaling calculations \
that automatically determine the plot range. It is possible for the head to \
be inadvertently cut off by a poorly set plot range; in some cases it may be \
necessary to adjust plot ranges by hand. \
\>", "Text",
  CellTags->{"S5.27.1", "1.15"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{550, 600},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.27.1"->{
    Cell[1776, 53, 135, 6, 70, "Subsection",
      CellTags->{"S5.27.1", "1.1"}],
    Cell[1914, 61, 605, 12, 70, "Text",
      CellTags->{"S5.27.1", "1.2"}],
    Cell[2522, 75, 1194, 31, 70, "DefinitionBox",
      CellTags->"S5.27.1"],
    Cell[3719, 108, 116, 5, 70, "Caption",
      CellTags->"S5.27.1"],
    Cell[3838, 115, 291, 8, 70, "Text",
      CellTags->{"S5.27.1", "1.3"}],
    Cell[4132, 125, 79, 1, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.4"}],
    Cell[4214, 128, 82, 2, 70, "Input",
      CellTags->"S5.27.1"],
    Cell[4299, 132, 117, 2, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.5"}],
    Cell[4441, 138, 153, 5, 70, "Input",
      CellTags->"S5.27.1"],
    Cell[4597, 145, 1542, 98, 70, 1468, 95, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.27.1"],
    Cell[6142, 245, 178, 5, 70, "Output",
      CellTags->"S5.27.1"],
    Cell[6335, 253, 92, 1, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.6"}],
    Cell[6452, 258, 183, 7, 70, "Input",
      CellTags->"S5.27.1"],
    Cell[6638, 267, 6685, 420, 70, 6611, 417, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.27.1"],
    Cell[13326, 689, 178, 5, 70, "Output",
      CellTags->"S5.27.1"],
    Cell[13519, 697, 4560, 103, 70, "DefinitionBox3Col",
      CellTags->"S5.27.1"],
    Cell[18082, 802, 118, 5, 70, "Caption",
      CellTags->"S5.27.1"],
    Cell[18203, 809, 1768, 40, 70, "Text",
      CellTags->{"S5.27.1", "1.7"}],
    Cell[19974, 851, 1437, 40, 70, "Text",
      CellTags->{"S5.27.1", "1.8"}],
    Cell[21414, 893, 672, 17, 70, "Text",
      CellTags->{"S5.27.1", "1.9"}],
    Cell[22089, 912, 482, 10, 70, "Text",
      CellTags->{"S5.27.1", "1.10"}],
    Cell[22574, 924, 151, 4, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.11"}],
    Cell[22750, 932, 211, 8, 70, "Input",
      CellTags->"S5.27.1"],
    Cell[22964, 942, 3883, 218, 70, 3809, 215, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.27.1"],
    Cell[26850, 1162, 178, 5, 70, "Output",
      CellTags->"S5.27.1"],
    Cell[27043, 1170, 112, 1, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.12"}],
    Cell[27180, 1175, 209, 8, 70, "Input",
      CellTags->"S5.27.1"],
    Cell[27392, 1185, 4001, 221, 70, 3927, 218, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.27.1"],
    Cell[31396, 1408, 178, 5, 70, "Output",
      CellTags->"S5.27.1"],
    Cell[31589, 1416, 233, 8, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.13"}],
    Cell[31847, 1428, 241, 11, 70, "Input",
      CellTags->"S5.27.1"],
    Cell[32091, 1441, 4817, 310, 70, 4743, 307, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.27.1"],
    Cell[36911, 1753, 178, 5, 70, "Output",
      CellTags->"S5.27.1"],
    Cell[37104, 1761, 460, 9, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.14"}],
    Cell[37589, 1774, 364, 15, 70, "Input",
      CellTags->"S5.27.1"],
    Cell[37956, 1791, 1761, 116, 70, 1687, 113, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.27.1"],
    Cell[39720, 1909, 178, 5, 70, "Output",
      CellTags->"S5.27.1"],
    Cell[39913, 1917, 400, 7, 70, "Text",
      CellTags->{"S5.27.1", "1.15"}]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 70, "Subsection",
      CellTags->{"S5.27.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 605, 12, 70, "Text",
      CellTags->{"S5.27.1", "1.2"}]},
  "1.3"->{
    Cell[3838, 115, 291, 8, 70, "Text",
      CellTags->{"S5.27.1", "1.3"}]},
  "1.4"->{
    Cell[4132, 125, 79, 1, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.4"}]},
  "1.5"->{
    Cell[4299, 132, 117, 2, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.5"}]},
  "1.6"->{
    Cell[6335, 253, 92, 1, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.6"}]},
  "1.7"->{
    Cell[18203, 809, 1768, 40, 70, "Text",
      CellTags->{"S5.27.1", "1.7"}]},
  "1.8"->{
    Cell[19974, 851, 1437, 40, 70, "Text",
      CellTags->{"S5.27.1", "1.8"}]},
  "1.9"->{
    Cell[21414, 893, 672, 17, 70, "Text",
      CellTags->{"S5.27.1", "1.9"}]},
  "1.10"->{
    Cell[22089, 912, 482, 10, 70, "Text",
      CellTags->{"S5.27.1", "1.10"}]},
  "1.11"->{
    Cell[22574, 924, 151, 4, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.11"}]},
  "1.12"->{
    Cell[27043, 1170, 112, 1, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.12"}]},
  "1.13"->{
    Cell[31589, 1416, 233, 8, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.13"}]},
  "1.14"->{
    Cell[37104, 1761, 460, 9, 70, "MathCaption",
      CellTags->{"S5.27.1", "1.14"}]},
  "1.15"->{
    Cell[39913, 1917, 400, 7, 70, "Text",
      CellTags->{"S5.27.1", "1.15"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.27.1", 40942, 1943},
  {"1.1", 44323, 2032},
  {"1.2", 44417, 2035},
  {"1.3", 44506, 2038},
  {"1.4", 44595, 2041},
  {"1.5", 44690, 2044},
  {"1.6", 44786, 2047},
  {"1.7", 44881, 2050},
  {"1.8", 44973, 2053},
  {"1.9", 45065, 2056},
  {"1.10", 45157, 2059},
  {"1.11", 45250, 2062},
  {"1.12", 45349, 2065},
  {"1.13", 45449, 2068},
  {"1.14", 45549, 2071},
  {"1.15", 45649, 2074}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 70, "Subsection",
  CellTags->{"S5.27.1", "1.1"}],
Cell[1914, 61, 605, 12, 70, "Text",
  CellTags->{"S5.27.1", "1.2"}],
Cell[2522, 75, 1194, 31, 70, "DefinitionBox",
  CellTags->"S5.27.1"],
Cell[3719, 108, 116, 5, 70, "Caption",
  CellTags->"S5.27.1"],
Cell[3838, 115, 291, 8, 70, "Text",
  CellTags->{"S5.27.1", "1.3"}],
Cell[4132, 125, 79, 1, 70, "MathCaption",
  CellTags->{"S5.27.1", "1.4"}],
Cell[4214, 128, 82, 2, 70, "Input",
  CellTags->"S5.27.1"],
Cell[4299, 132, 117, 2, 70, "MathCaption",
  CellTags->{"S5.27.1", "1.5"}],

Cell[CellGroupData[{
Cell[4441, 138, 153, 5, 70, "Input",
  CellTags->"S5.27.1"],
Cell[4597, 145, 1542, 98, 70, 1468, 95, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.27.1"],
Cell[6142, 245, 178, 5, 70, "Output",
  CellTags->"S5.27.1"]
}, Open  ]],
Cell[6335, 253, 92, 1, 70, "MathCaption",
  CellTags->{"S5.27.1", "1.6"}],

Cell[CellGroupData[{
Cell[6452, 258, 183, 7, 70, "Input",
  CellTags->"S5.27.1"],
Cell[6638, 267, 6685, 420, 70, 6611, 417, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.27.1"],
Cell[13326, 689, 178, 5, 70, "Output",
  CellTags->"S5.27.1"]
}, Open  ]],
Cell[13519, 697, 4560, 103, 70, "DefinitionBox3Col",
  CellTags->"S5.27.1"],
Cell[18082, 802, 118, 5, 70, "Caption",
  CellTags->"S5.27.1"],
Cell[18203, 809, 1768, 40, 70, "Text",
  CellTags->{"S5.27.1", "1.7"}],
Cell[19974, 851, 1437, 40, 70, "Text",
  CellTags->{"S5.27.1", "1.8"}],
Cell[21414, 893, 672, 17, 70, "Text",
  CellTags->{"S5.27.1", "1.9"}],
Cell[22089, 912, 482, 10, 70, "Text",
  CellTags->{"S5.27.1", "1.10"}],
Cell[22574, 924, 151, 4, 70, "MathCaption",
  CellTags->{"S5.27.1", "1.11"}],

Cell[CellGroupData[{
Cell[22750, 932, 211, 8, 70, "Input",
  CellTags->"S5.27.1"],
Cell[22964, 942, 3883, 218, 70, 3809, 215, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.27.1"],
Cell[26850, 1162, 178, 5, 70, "Output",
  CellTags->"S5.27.1"]
}, Open  ]],
Cell[27043, 1170, 112, 1, 70, "MathCaption",
  CellTags->{"S5.27.1", "1.12"}],

Cell[CellGroupData[{
Cell[27180, 1175, 209, 8, 70, "Input",
  CellTags->"S5.27.1"],
Cell[27392, 1185, 4001, 221, 70, 3927, 218, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.27.1"],
Cell[31396, 1408, 178, 5, 70, "Output",
  CellTags->"S5.27.1"]
}, Open  ]],
Cell[31589, 1416, 233, 8, 70, "MathCaption",
  CellTags->{"S5.27.1", "1.13"}],

Cell[CellGroupData[{
Cell[31847, 1428, 241, 11, 70, "Input",
  CellTags->"S5.27.1"],
Cell[32091, 1441, 4817, 310, 70, 4743, 307, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.27.1"],
Cell[36911, 1753, 178, 5, 70, "Output",
  CellTags->"S5.27.1"]
}, Open  ]],
Cell[37104, 1761, 460, 9, 70, "MathCaption",
  CellTags->{"S5.27.1", "1.14"}],

Cell[CellGroupData[{
Cell[37589, 1774, 364, 15, 70, "Input",
  CellTags->"S5.27.1"],
Cell[37956, 1791, 1761, 116, 70, 1687, 113, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.27.1"],
Cell[39720, 1909, 178, 5, 70, "Output",
  CellTags->"S5.27.1"]
}, Open  ]],
Cell[39913, 1917, 400, 7, 70, "Text",
  CellTags->{"S5.27.1", "1.15"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

