(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    506105,      25919]*)
(*NotebookOutlinePosition[    531817,      26652]*)
(*  CellTagsIndexPosition[    529644,      26568]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "Audio",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.51.1", "1.1"}],

Cell[TextData[{
 "This package provides functions for the generation of standard waveforms \
and waveforms with user\[Hyphen]specified spectra, the synthesis of amplitude \
and frequency modulated sinusoids, and a function for reading sound files \
into ",
 StyleBox["Mathematica", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.51.1", "1.2"}],

Cell[TextData[{
 "The graphic output of ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s sound functions is hardware dependent, so the graphics \
included in this documentation may differ from those produced by your \
machine. "
}], "Text",
 CellTags->{"S5.51.1", "1.3"}],

Cell[CellGroupData[{

Cell["Generating Standard Waveforms", "Subsubsection",
 CellTags->{"S5.51.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Waveform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["freq", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object that is a standard waveform of type ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", having a fundamental frequency of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["freq", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" hertz, and a duration of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" seconds",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Creating a standard waveform. ", "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 StyleBox["Waveform", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " uses computationally efficient algorithms to create a standard waveform \
with a theoretically infinite number of overtones. "
}], "Text",
 CellTags->{"S5.51.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Sinusoid",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Triangle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Square",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sawtooth",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Standard waveform definitions. ", "Caption",
 CellTags->"S5.51.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.51.1", "1.6"}],

Cell["<< Miscellaneous`Audio`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "Here ",
 StyleBox["Waveform", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " returns a ",
 StyleBox["Sound", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " object corresponding to a triangle wave having a fundamental of 440 hertz \
and lasting 0.2 seconds. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.7"}],

Cell[CellGroupData[{

Cell["tri440 = Waveform[Triangle, 440, 0.2]//Show", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Waveform[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["freq", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Overtones->", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a standard waveform with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" overtones",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["\<\
Creating a standard waveform with a specified number of overtones. \
\>", "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "By setting the option ",
 StyleBox["Overtones", "MR"],
 ", you can limit the number of overtones that ",
 StyleBox["Waveform", "MR"],
 " includes in a sound. "
}], "Text",
 CellTags->{"S5.51.1", "1.8"}],

Cell[TextData[{
 "You can generate a square wave that has only eight overtones, then hear the \
sound with the ",
 StyleBox["Show", "MR"],
 " function. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
Waveform[Square, 880, 0.2,
        Overtones -> 8, SampleRate -> 2^15] // Show\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "Here ",
 StyleBox["Table", "MR"],
 " is used to create a sequence of sawtooth waveform sounds running from ten \
overtones down to only two. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
Table[Waveform[Sawtooth, 880, 0.1,
    Overtones -> n, SampleRate -> 2^15],
{n, 10, 2, -1}] // Show\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "When you use the option ",
 StyleBox["Overtones", "MR"],
 ", the ",
 StyleBox["Waveform", "MR"],
 " function uses Fourier summation to create the sound. This process is not \
as computationally efficient as the default algorithm, but generates a \
cleaner sound with only the specified number of overtones. ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s ",
 StyleBox["SetOptions", "MR"],
 " function may be used to make Fourier summation the default. "
}], "Text",
 CellTags->{"S5.51.1", "1.11"}],

Cell[TextData[{
 "This ensures that ",
 StyleBox["Waveform", "MR"],
 " will use Fourier summation for the creation of sounds. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.12"}],

Cell[CellGroupData[{

Cell["SetOptions[Waveform, Overtones->Infinity]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.51.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
   RowBox[{"Overtones", "\[Rule]", "\[Infinity]"}], ",", 
   RowBox[{"PlayRange", "\[Rule]", "All"}], ",", 
   RowBox[{"SampleDepth", "\[Rule]", "8"}], ",", 
   RowBox[{"SampleRate", "\[Rule]", "8192"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell["\<\
This ensures the use of faster algorithms in creating sounds. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.13"}],

Cell[CellGroupData[{

Cell["SetOptions[Waveform, Overtones->Automatic]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.51.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
   RowBox[{"Overtones", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlayRange", "\[Rule]", "All"}], ",", 
   RowBox[{"SampleDepth", "\[Rule]", "8"}], ",", 
   RowBox[{"SampleRate", "\[Rule]", "8192"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Specifying the Spectrum for a Waveform", "Subsubsection",
 CellTags->{"S5.51.1", "1.14"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ListWaveform[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ... }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["freq", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object with a fundamental frequency of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["freq", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" lasting for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" seconds, with a spectrum in which relative frequency ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" has relative amplitude ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Creating a waveform with a specified spectrum. ", "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 StyleBox["ListWaveform", "MR"],
 " allows you to create a waveform with a specific spectrum. The first \
argument is a list of pairs, in which the first member of each pair is a \
frequency relative to the fundamental and the second is the frequency\
\[CloseCurlyQuote]s relative amplitude. "
}], "Text",
 CellTags->{"S5.51.1", "1.15"}],

Cell[TextData[{
 "For example, you can define a partial list corresponding to an \
\[OpenCurlyDoubleQuote]instrument\[CloseCurlyDoubleQuote] in which the \
partials\[CloseCurlyQuote] frequencies are nonharmonically related and have \
complicated amplitude relationships. ",
 StyleBox["ListWaveform", "MR"],
 " may then be used to generate these relationships at different fundamental \
frequencies. "
}], "Text",
 CellTags->{"S5.51.1", "1.16"}],

Cell["This partial list will define the instrument. ", "MathCaption",
 CellTags->{"S5.51.1", "1.17"}],

Cell["\<\
partialList =
  {{1,1},{1.1,0.1},{1.2,0.9},{1.3,0.2},
   {1.4,0.8},{1.5,0.3},{1.6,0.7},
   {1.7,0.4},{1.8,0.6},{1.9,0.5}};\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.51.1"],

Cell["\<\
This generates an ascending sequence of six chromatic half\[Hyphen]steps, \
beginning at 440 hertz, all using the same partial list, and each lasting for \
0.2 seconds. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.18"}],

Cell["\<\
sequence = Table[ListWaveform[partialList,
440 2^(x/12), 0.2], {x,0,5}];\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.51.1"],

Cell["\<\
Now you can hear one partial list at different fundamental frequencies. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.19"}],

Cell[CellGroupData[{

Cell["Show[sequence]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "You can create chords with ",
 StyleBox["ListWaveform", "MR"],
 " by defining partial lists with amplitude relationships of unity, so that \
all component frequencies share the same amplitude. "
}], "Text",
 CellTags->{"S5.51.1", "1.20"}],

Cell["\<\
This sequence of relative frequencies defines a major chord. Note that the \
amplitudes are set at unity, so that the component frequencies are of equal \
amplitude. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.21"}],

Cell["majorChord = {{1, 1}, {1.26, 1}, {1.5, 1}};", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "This creates a major chord based on a fundamental of 493.88 hertz (",
 StyleBox["i.e.,", "TI"],
 " the pitch B4). "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.22"}],

Cell[CellGroupData[{

Cell["ListWaveform[majorChord, 493.88, 0.2] // Show", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Amplitude Modulation", "Subsubsection",
 CellTags->{"S5.51.1", "1.23"}],

Cell["\<\
Amplitude modulation is a common analog studio technique in which the created \
sound contains three frequencies: the carrier frequency, and the sum and \
difference of the carrier and modulating frequencies. \
\>", "Text",
 CellTags->{"S5.51.1", "1.24"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["AmplitudeModulation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["m",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " object that is an amplitude modulated sinusoid, having carrier and \
modulator frequencies ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["m",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" measured in hertz, a modulation index of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and a duration of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" seconds ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Amplitude modulation. ", "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "The expression used by ",
 StyleBox["AmplitudeModulation", "MR"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "\[NonBreakingSpace]", 
      StyleBox["m",
       "TI"], 
      StyleBox["i",
       "TI"], " ", "cos", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", 
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["m",
          "TI"]], 
        StyleBox["t",
         "TI"]}], ")"}]}], ")"}], " ", "cos", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", 
      SubscriptBox[
       StyleBox["f",
        "TI"], 
       StyleBox["c",
        "TI"]], 
      StyleBox["t",
       "TI"]}], ")"}], "."}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " "
}], "Text",
 CellTags->{"S5.51.1", "1.25"}],

Cell["\<\
When the modulating frequency is subaudio (below 20 hertz), the result of \
amplitude modulation is what musicians call tremolo. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.26"}],

Cell[CellGroupData[{

Cell["AmplitudeModulation[440, 6, 1, 0.5] //Show", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "The depth or intensity of the modulation is controlled by the modulation \
index ",
 StyleBox["mi", "TI"],
 ". The carrier is said to be overmodulated when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["mi",
     "TI"], "\[NonBreakingSpace]", ">", "\[NonBreakingSpace]", "1"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The best way to understand the effect of ",
 StyleBox["mi", "TI"],
 " is to try it out with different values, usually between 0.1 and 2.0. "
}], "Text",
 CellTags->{"S5.51.1", "1.27"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["AmplitudeModulation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["m",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["mi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", RingModulation->True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object that is a ring modulated sinusoid",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Ring modulation. ", "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "If you set the option ",
 StyleBox["RingModulation->True", "MR"],
 ", the ",
 StyleBox["Sound", "MR"],
 " object created by ",
 StyleBox["AmplitudeModulation", "MR"],
 " will contain only two frequencies: the sum and the difference of the \
carrier and modulating frequencies. This is called ring modulation, and is \
given by the expression ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m",
     "TI"], 
    StyleBox["i",
     "TI"], " ", "cos", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", 
      SubscriptBox[
       StyleBox["f",
        "TI"], 
       StyleBox["m",
        "TI"]], 
      StyleBox["t",
       "TI"]}], ")"}], " ", "cos", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", 
      SubscriptBox[
       StyleBox["f",
        "TI"], 
       StyleBox["c",
        "TI"]], 
      StyleBox["t",
       "TI"]}], ")"}], "."}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " "
}], "Text",
 CellTags->{"S5.51.1", "1.28"}],

Cell["\<\
In this example, the output sound contains the frequencies 700 and 300 hertz, \
the sum and difference of the carrier and modulating frequencies. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.29"}],

Cell[CellGroupData[{

Cell["\<\
AmplitudeModulation[200, 500, 1, 0.5,
        RingModulation->True] //Show\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frequency Modulation", "Subsubsection",
 CellTags->{"S5.51.1", "1.30"}],

Cell[TextData[{
 "Frequency modulation (FM) is a technique used at major universities on \
workstations and in suburban homes on synthesizers. The ubiquitousness of \
this technique stems in part from its mathematical simplicity and its ease of \
implementation in an electronic circuit. The expression for frequency \
modulation is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", 
      SubscriptBox[
       StyleBox["f",
        "TI"], 
       StyleBox["c",
        "TI"]], 
      StyleBox["t",
       "TI"], "\[NonBreakingSpace]", "+", "\[NonBreakingSpace]", 
      FractionBox[
       StyleBox[
        RowBox[{"p", "d"}],
        "TI"], 
       SubscriptBox[
        StyleBox["f",
         "TI"], 
        StyleBox["m",
         "TI"]]], " ", "sin", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", 
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["m",
          "TI"]], 
        StyleBox["t",
         "TI"]}], ")"}]}], ")"}], "."}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " "
}], "Text",
 CellTags->{"S5.51.1", "1.31"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FrequencyModulation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["m",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pd", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " object that is a frequency modulated sinusoid, having carrier and \
modulating frequencies ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["m",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" hertz, peak deviation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pd", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" hertz, and a duration of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" seconds ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Frequency modulation. ", "Caption",
 CellTags->"S5.51.1"],

Cell["\<\
When the modulating frequency is subaudio (below 20 hertz), the result is \
what musicians call vibrato. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.32"}],

Cell[CellGroupData[{

Cell["FrequencyModulation[660, {7,70}, 0.5] //Show", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell["\<\
The modulation index is the ratio of the peak deviation to the modulating \
frequency. Higher values of the modulation index result in more partials and \
a brighter sound. Very high values will result in aliasing, and will add low\
\[Hyphen]frequency components to the sound. \
\>", "Text",
 CellTags->{"S5.51.1", "1.33"}],

Cell["\<\
This is an example of frequency modulation with a modulation index of \
5500/550. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.34"}],

Cell[CellGroupData[{

Cell["\<\
FrequencyModulation[
  440, {550, 5500}, 0.5] //Show\
\>", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell["\<\
The modulation ratio is the ratio of the modulating frequency to the carrier \
frequency. If this ratio is an integer greater than zero, the resulting \
overtones and sidebands will have harmonic relationships to each other, \
analogous to those of standard orchestral instruments. If the modulation \
ratio is not integer valued, the resulting overtones and sidebands will have \
an inharmonic relationship to each other, analogous to percussion instruments \
and bells. One speaks of a harmonic relationship when the overtones and \
sidebands have frequencies that coincide with the harmonics of some \
fundamental, not necessarily the carrier. \
\>", "Text",
 CellTags->{"S5.51.1", "1.35"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FrequencyModulation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pd",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pd",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ...}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["        ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ModulationType->Cascade]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " object that is a cascade frequency modulated sinusoid, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pd",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the peak deviation associated with modulating frequency ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", both values measured in hertz",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Cascade frequency modulation. ", "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "Cascade frequency modulation is a type of frequency modulation where the \
modulating frequency is itself modulated, thus cascading the modulation. The \
expression for cascade frequency modulation with two modulating frequencies \
is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", 
      SubscriptBox[
       StyleBox["f",
        "TI"], 
       StyleBox["c",
        "TI"]], 
      StyleBox["t",
       "TI"], "\[NonBreakingSpace]", "+", "\[NonBreakingSpace]", 
      FractionBox[
       RowBox[{
        StyleBox["p",
         "TI"], 
        SubscriptBox[
         StyleBox["d",
          "TI"], "1"]}], 
       SubscriptBox[
        StyleBox["f",
         "TI"], 
        RowBox[{
         StyleBox["m",
          "TI"], "1"}]]], " ", "sin", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", 
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         RowBox[{
          StyleBox["m",
           "TI"], "1"}]], 
        StyleBox["t",
         "TI"], "\[NonBreakingSpace]", "+", "\[NonBreakingSpace]", 
        FractionBox[
         RowBox[{
          StyleBox["p",
           "TI"], 
          SubscriptBox[
           StyleBox["d",
            "TI"], "2"]}], 
         SubscriptBox[
          StyleBox["f",
           "TI"], 
          RowBox[{
           StyleBox["m",
            "TI"], "2"}]]], " ", "sin", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", 
          SubscriptBox[
           StyleBox["f",
            "TI"], 
           RowBox[{
            StyleBox["m",
             "TI"], "2"}]], 
          StyleBox["t",
           "TI"]}], ")"}]}], ")"}]}], ")"}], "."}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " This nesting process can be carried out for a list of modulating \
frequencies of any size. "
}], "Text",
 CellTags->{"S5.51.1", "1.36"}],

Cell["\<\
In this example of cascade frequency modulation, each modulating frequency is \
given a distinct peak deviation. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.37"}],

Cell[CellGroupData[{

Cell["\<\
FrequencyModulation[880, {{340, 100},
        {550, 50}, {730, 25}}, 0.5,
        ModulationType->Cascade] // Show\
\>", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FrequencyModulation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["c",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pd",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pd",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ...}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dur", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["        ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ModulationType->Parallel]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Sound", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " object that is a parallel frequency modulated sinusoid, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pd",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the peak deviation associated with modulating frequency ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", both values measured in hertz",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell["Parallel frequency modulation. ", "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "In contrast to cascade frequency modulation, parallel frequency modulation \
is a technique where the carrier frequency is modulated by two or more \
modulating frequencies that do not modulate each other. The expression for \
parallel frequency modulation with two modulating frequencies is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", 
      SubscriptBox[
       StyleBox["f",
        "TI"], 
       StyleBox["c",
        "TI"]], 
      StyleBox["t",
       "TI"], "\[NonBreakingSpace]", "+", "\[NonBreakingSpace]", 
      FractionBox[
       RowBox[{
        StyleBox["p",
         "TI"], 
        SubscriptBox[
         StyleBox["d",
          "TI"], "1"]}], 
       SubscriptBox[
        StyleBox["f",
         "TI"], 
        RowBox[{
         StyleBox["m",
          "TI"], "1"}]]], " ", "sin", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", 
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         RowBox[{
          StyleBox["m",
           "TI"], "1"}]], 
        StyleBox["t",
         "TI"]}], ")"}], "\[NonBreakingSpace]", "+", "\[NonBreakingSpace]", 
      FractionBox[
       RowBox[{
        StyleBox["p",
         "TI"], 
        SubscriptBox[
         StyleBox["d",
          "TI"], "2"]}], 
       SubscriptBox[
        StyleBox["f",
         "TI"], 
        RowBox[{
         StyleBox["m",
          "TI"], "2"}]]], " ", "sin", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", 
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         RowBox[{
          StyleBox["m",
           "TI"], "2"}]], 
        StyleBox["t",
         "TI"]}], ")"}]}], ")"}], "."}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " "
}], "Text",
 CellTags->{"S5.51.1", "1.38"}],

Cell["\<\
This uses the same values as the example for cascade FM, but generates an \
instance of parallel FM instead. Note the stronger presence of the higher \
partials in the resulting sound. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.39"}],

Cell[CellGroupData[{

Cell["\<\
FrequencyModulation[880,
        {{340, 100}, {550, 50}, {730, 25}}, 0.5,
        ModulationType->Parallel] // Show\
\>", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reading Sound Files from Disk", "Subsubsection",
 CellTags->{"S5.51.1", "1.40"}],

Cell[TextData[{
 "There are numerous sound file formats used for the storage of sampled \
sounds. In general, they consist of a header containing information that \
describes the sound, followed by the sampled sound data. The ",
 StyleBox["ReadSoundFile", "MR"],
 " function is capable of reading NeXT/Sun, WAVE, and AIFF sound file \
formats. ",
 StyleBox["ReadSoundFile", "MR"],
 " can read the AIFF format used by SGI, Amiga, and some Apple sound files. \
It will not work with Apple\[CloseCurlyQuote]s SoundDesigner II sound files, \
due to the fact that data (the sound samples) are kept in the data fork, but \
format information is kept in the resource fork. "
}], "Text",
 CellTags->{"S5.51.1", "1.41"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ReadSoundFile[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["soundfile", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "read the specified sound file, and convert the sequence of samples \
into a list of integers between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["-", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["32768 and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["+", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["32767",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ReadSoundFile[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["soundfile", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\", PrintHeader->True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "display the header information while reading in the sound file",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.51.1"],

Cell[TextData[{
 "Reading a sound file into ",
 StyleBox["Mathematica", "SO"],
 ". "
}], "Caption",
 CellTags->"S5.51.1"],

Cell[TextData[{
 StyleBox["ReadSoundFile", "MR"],
 " lets you read a sampled sound file directly into ",
 StyleBox["Mathematica", "TI"],
 ". The samples are translated into signed 16\[Hyphen]bit integers. If the \
sound is stereo, ",
 StyleBox["ReadSoundFile", "MR"],
 " returns a list of lists for the right and left channels. The returned list \
can be played with ",
 StyleBox["ListPlay", "MR"],
 " or plotted with ",
 StyleBox["ListPlot", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.51.1", "1.42"}],

Cell[TextData[{
 "This reads the Multimedia sound file ",
 StyleBox["chimes.wav", "MR"],
 ", and returns a list of the samples in the file. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.43"}],

Cell[CellGroupData[{

Cell["\<\
chimes = ReadSoundFile[\"chimes.wav\",
        PrintHeader->True];\
\>", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Format: \"\>", 
   "\[InvisibleSpace]", "\<\"Microsoft PCM WAVE RIFF\"\>"}],
  SequenceForm["Format: ", "Microsoft PCM WAVE RIFF"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Duration: \"\>", "\[InvisibleSpace]", "0.72`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["Duration: ", 0.72, " seconds"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Channels: \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Channels: ", 1],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sampling rate: \"\>", "\[InvisibleSpace]", "22050"}],
  SequenceForm["Sampling rate: ", 22050],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Bits per sample: \"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["Bits per sample: ", 8],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Data size: \"\>", "\[InvisibleSpace]", "15876", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["Data size: ", 15876, " bytes"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of samples: \"\>", "\[InvisibleSpace]", "15876"}],
  SequenceForm["Number of samples: ", 15876],
  Editable->False]], "Print",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "The list ",
 StyleBox["chimes", "MR"],
 " may be played with ",
 StyleBox["ListPlay", "MR"],
 ", at the ",
 StyleBox["SampleRate", "MR"],
 " displayed by setting ",
 StyleBox["PrintHeader->True", "MR"],
 ". Note that the ",
 StyleBox["PlayRange", "MR"],
 " is adjusted to account for the 16\[Hyphen]bit signed samples. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.44"}],

Cell[CellGroupData[{

Cell["\<\
ListPlay[chimes, SampleRate->22050,
        PlayRange->{-2^15,2^15}]\
\>", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "Plot the sound with ",
 StyleBox["ListPlot", "MR"],
 ". Remember to set ",
 StyleBox["PlotRange", "MR"],
 " to a range that will accommodate the 16\[Hyphen]bit signed amplitudes. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.45"}],

Cell[CellGroupData[{

Cell["ListPlot[chimes, PlotRange->{-2^15,2^15}]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.51.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 5.99887e-05 0.309017 9.43045e-06 [
[.17378 .29652 -12 -9 ]
[.17378 .29652 12 0 ]
[.32375 .29652 -12 -9 ]
[.32375 .29652 12 0 ]
[.47372 .29652 -12 -9 ]
[.47372 .29652 12 0 ]
[.6237 .29652 -15 -9 ]
[.6237 .29652 15 0 ]
[.77367 .29652 -15 -9 ]
[.77367 .29652 15 0 ]
[.92364 .29652 -15 -9 ]
[.92364 .29652 15 0 ]
[.01131 .0261 -36 -4.5 ]
[.01131 .0261 0 4.5 ]
[.01131 .12041 -36 -4.5 ]
[.01131 .12041 0 4.5 ]
[.01131 .21471 -36 -4.5 ]
[.01131 .21471 0 4.5 ]
[.01131 .40332 -30 -4.5 ]
[.01131 .40332 0 4.5 ]
[.01131 .49763 -30 -4.5 ]
[.01131 .49763 0 4.5 ]
[.01131 .59193 -30 -4.5 ]
[.01131 .59193 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17378 .30902 m
.17378 .31527 L
s
[(2500)] .17378 .29652 0 1 Mshowa
.32375 .30902 m
.32375 .31527 L
s
[(5000)] .32375 .29652 0 1 Mshowa
.47372 .30902 m
.47372 .31527 L
s
[(7500)] .47372 .29652 0 1 Mshowa
.6237 .30902 m
.6237 .31527 L
s
[(10000)] .6237 .29652 0 1 Mshowa
.77367 .30902 m
.77367 .31527 L
s
[(12500)] .77367 .29652 0 1 Mshowa
.92364 .30902 m
.92364 .31527 L
s
[(15000)] .92364 .29652 0 1 Mshowa
.125 Mabswid
.0538 .30902 m
.0538 .31277 L
s
.0838 .30902 m
.0838 .31277 L
s
.11379 .30902 m
.11379 .31277 L
s
.14379 .30902 m
.14379 .31277 L
s
.20378 .30902 m
.20378 .31277 L
s
.23377 .30902 m
.23377 .31277 L
s
.26376 .30902 m
.26376 .31277 L
s
.29376 .30902 m
.29376 .31277 L
s
.35375 .30902 m
.35375 .31277 L
s
.38374 .30902 m
.38374 .31277 L
s
.41374 .30902 m
.41374 .31277 L
s
.44373 .30902 m
.44373 .31277 L
s
.50372 .30902 m
.50372 .31277 L
s
.53371 .30902 m
.53371 .31277 L
s
.56371 .30902 m
.56371 .31277 L
s
.5937 .30902 m
.5937 .31277 L
s
.65369 .30902 m
.65369 .31277 L
s
.68369 .30902 m
.68369 .31277 L
s
.71368 .30902 m
.71368 .31277 L
s
.74367 .30902 m
.74367 .31277 L
s
.80366 .30902 m
.80366 .31277 L
s
.83366 .30902 m
.83366 .31277 L
s
.86365 .30902 m
.86365 .31277 L
s
.89365 .30902 m
.89365 .31277 L
s
.95363 .30902 m
.95363 .31277 L
s
.98363 .30902 m
.98363 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .0261 m
.03006 .0261 L
s
[(-30000)] .01131 .0261 1 0 Mshowa
.02381 .12041 m
.03006 .12041 L
s
[(-20000)] .01131 .12041 1 0 Mshowa
.02381 .21471 m
.03006 .21471 L
s
[(-10000)] .01131 .21471 1 0 Mshowa
.02381 .40332 m
.03006 .40332 L
s
[(10000)] .01131 .40332 1 0 Mshowa
.02381 .49763 m
.03006 .49763 L
s
[(20000)] .01131 .49763 1 0 Mshowa
.02381 .59193 m
.03006 .59193 L
s
[(30000)] .01131 .59193 1 0 Mshowa
.125 Mabswid
.02381 .04496 m
.02756 .04496 L
s
.02381 .06383 m
.02756 .06383 L
s
.02381 .08269 m
.02756 .08269 L
s
.02381 .10155 m
.02756 .10155 L
s
.02381 .13927 m
.02756 .13927 L
s
.02381 .15813 m
.02756 .15813 L
s
.02381 .17699 m
.02756 .17699 L
s
.02381 .19585 m
.02756 .19585 L
s
.02381 .23357 m
.02756 .23357 L
s
.02381 .25243 m
.02756 .25243 L
s
.02381 .2713 m
.02756 .2713 L
s
.02381 .29016 m
.02756 .29016 L
s
.02381 .32788 m
.02756 .32788 L
s
.02381 .34674 m
.02756 .34674 L
s
.02381 .3656 m
.02756 .3656 L
s
.02381 .38446 m
.02756 .38446 L
s
.02381 .42218 m
.02756 .42218 L
s
.02381 .44104 m
.02756 .44104 L
s
.02381 .4599 m
.02756 .4599 L
s
.02381 .47877 m
.02756 .47877 L
s
.02381 .51649 m
.02756 .51649 L
s
.02381 .53535 m
.02756 .53535 L
s
.02381 .55421 m
.02756 .55421 L
s
.02381 .57307 m
.02756 .57307 L
s
.02381 .00724 m
.02756 .00724 L
s
.02381 .61079 m
.02756 .61079 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02387 .30902 Mdot
.02393 .30902 Mdot
.02399 .30902 Mdot
.02405 .30902 Mdot
.02411 .30902 Mdot
.02417 .30902 Mdot
.02423 .30902 Mdot
.02429 .30902 Mdot
.02435 .30902 Mdot
.02441 .30902 Mdot
.02447 .30902 Mdot
.02453 .30902 Mdot
.02459 .30902 Mdot
.02465 .30902 Mdot
.02471 .30902 Mdot
.02477 .30902 Mdot
.02483 .30902 Mdot
.02489 .30902 Mdot
.02495 .30902 Mdot
.02501 .30902 Mdot
.02507 .30902 Mdot
.02513 .30902 Mdot
.02519 .30902 Mdot
.02525 .30902 Mdot
.02531 .30902 Mdot
.02537 .30902 Mdot
.02543 .30902 Mdot
.02549 .30902 Mdot
.02555 .30902 Mdot
.02561 .30902 Mdot
.02567 .30902 Mdot
.02573 .30902 Mdot
.02579 .30902 Mdot
.02585 .30902 Mdot
.02591 .30902 Mdot
.02597 .30902 Mdot
.02603 .30902 Mdot
.02609 .30902 Mdot
.02615 .30902 Mdot
.02621 .30902 Mdot
.02627 .30902 Mdot
.02633 .30902 Mdot
.02639 .30902 Mdot
.02645 .30902 Mdot
.02651 .30902 Mdot
.02657 .30902 Mdot
.02663 .30902 Mdot
.02669 .30902 Mdot
.02675 .30902 Mdot
.02681 .30902 Mdot
.02687 .30902 Mdot
.02693 .30902 Mdot
.02699 .30902 Mdot
.02705 .30902 Mdot
.02711 .30902 Mdot
.02717 .30902 Mdot
.02723 .30902 Mdot
.02729 .30902 Mdot
.02735 .30902 Mdot
.02741 .30902 Mdot
.02747 .30902 Mdot
.02753 .30902 Mdot
.02759 .30902 Mdot
.02765 .30902 Mdot
.02771 .30902 Mdot
.02777 .30902 Mdot
.02783 .30902 Mdot
.02789 .30902 Mdot
.02795 .30902 Mdot
.02801 .30902 Mdot
.02807 .30902 Mdot
.02813 .30902 Mdot
.02819 .30902 Mdot
.02825 .30902 Mdot
.02831 .30902 Mdot
.02837 .30902 Mdot
.02843 .30902 Mdot
.02849 .30902 Mdot
.02855 .30902 Mdot
.02861 .30902 Mdot
.02867 .30902 Mdot
.02873 .30902 Mdot
.02879 .30902 Mdot
.02885 .30902 Mdot
.02891 .30902 Mdot
.02897 .30902 Mdot
.02903 .30902 Mdot
.02909 .30902 Mdot
.02915 .30902 Mdot
.02921 .30902 Mdot
.02927 .30902 Mdot
.02933 .30902 Mdot
.02939 .30902 Mdot
.02945 .30902 Mdot
.02951 .30902 Mdot
.02957 .30902 Mdot
.02963 .30902 Mdot
.02969 .30902 Mdot
.02975 .30902 Mdot
.02981 .30902 Mdot
.02987 .30902 Mdot
.02993 .30902 Mdot
.02999 .30902 Mdot
.03005 .30902 Mdot
.03011 .30902 Mdot
.03017 .30902 Mdot
.03023 .30902 Mdot
.03029 .30902 Mdot
.03035 .30902 Mdot
.03041 .30902 Mdot
.03047 .30902 Mdot
.03053 .3066 Mdot
.03059 .30902 Mdot
.03065 .30902 Mdot
.03071 .3066 Mdot
.03077 .3066 Mdot
.03083 .3066 Mdot
.03089 .30902 Mdot
.03095 .3066 Mdot
.03101 .3066 Mdot
.03107 .3066 Mdot
.03113 .30902 Mdot
.03119 .30902 Mdot
.03125 .3066 Mdot
.03131 .3066 Mdot
.03137 .3066 Mdot
.03143 .30902 Mdot
.03149 .30902 Mdot
.03155 .30902 Mdot
.03161 .3066 Mdot
.03167 .3066 Mdot
.03173 .30902 Mdot
.03179 .3066 Mdot
.03185 .30902 Mdot
.03191 .30902 Mdot
.03197 .3066 Mdot
.03203 .30902 Mdot
.03209 .30902 Mdot
.03215 .30902 Mdot
.03221 .30902 Mdot
.03227 .3066 Mdot
.03233 .30902 Mdot
.03239 .30902 Mdot
.03245 .3066 Mdot
.03251 .3066 Mdot
.03257 .3066 Mdot
.03263 .30902 Mdot
.03269 .30902 Mdot
.03275 .3066 Mdot
.03281 .30902 Mdot
.03287 .30902 Mdot
.03293 .3066 Mdot
.03299 .30902 Mdot
.03305 .3066 Mdot
.03311 .3066 Mdot
.03317 .30902 Mdot
.03323 .3066 Mdot
.03329 .3066 Mdot
.03335 .3066 Mdot
.03341 .30902 Mdot
.03347 .30902 Mdot
.03353 .30902 Mdot
.03359 .3066 Mdot
.03365 .3066 Mdot
.03371 .3066 Mdot
.03377 .30902 Mdot
.03383 .30902 Mdot
.03389 .3066 Mdot
.03395 .3066 Mdot
.03401 .30902 Mdot
.03407 .3066 Mdot
.03413 .30902 Mdot
.03419 .30902 Mdot
.03425 .30902 Mdot
.03431 .30902 Mdot
.03437 .3066 Mdot
.03443 .3066 Mdot
.03449 .3066 Mdot
.03455 .30902 Mdot
.03461 .30902 Mdot
.03467 .30902 Mdot
.03473 .3066 Mdot
.03479 .3066 Mdot
.03485 .30902 Mdot
.03491 .30902 Mdot
.03497 .30902 Mdot
.03503 .3066 Mdot
.03509 .3066 Mdot
.03515 .30902 Mdot
.03521 .30902 Mdot
.03527 .30902 Mdot
.03533 .3066 Mdot
.03539 .30902 Mdot
.03545 .30902 Mdot
.03551 .3066 Mdot
.03557 .3066 Mdot
.03563 .3066 Mdot
.03569 .3066 Mdot
.03575 .30902 Mdot
.03581 .30902 Mdot
.03587 .3066 Mdot
.03593 .3066 Mdot
.03599 .3066 Mdot
.03605 .30902 Mdot
.03611 .30902 Mdot
.03617 .3066 Mdot
.03623 .30902 Mdot
.03629 .30902 Mdot
.03635 .3066 Mdot
.03641 .30902 Mdot
.03647 .3066 Mdot
.03653 .3066 Mdot
.03659 .30902 Mdot
.03665 .30902 Mdot
.03671 .30902 Mdot
.03677 .3066 Mdot
.03683 .3066 Mdot
.03689 .30902 Mdot
.03695 .30902 Mdot
.03701 .3066 Mdot
.03707 .3066 Mdot
.03713 .3066 Mdot
.03719 .30902 Mdot
.03725 .3066 Mdot
.03731 .30902 Mdot
.03737 .30902 Mdot
.03743 .3066 Mdot
.03749 .30902 Mdot
.03755 .3066 Mdot
.03761 .3066 Mdot
.03767 .30902 Mdot
.03773 .30902 Mdot
.03779 .30902 Mdot
.03785 .3066 Mdot
.03791 .3066 Mdot
.03797 .3066 Mdot
.03803 .30902 Mdot
.03809 .30902 Mdot
.03815 .3066 Mdot
.03821 .3066 Mdot
.03827 .3066 Mdot
.03833 .30902 Mdot
.03839 .30902 Mdot
.03845 .30902 Mdot
.03851 .3066 Mdot
.03857 .3066 Mdot
.03863 .30902 Mdot
.03869 .30902 Mdot
.03875 .3066 Mdot
.03881 .3066 Mdot
.03887 .3066 Mdot
.03893 .30902 Mdot
.03899 .30902 Mdot
.03905 .3066 Mdot
.03911 .3066 Mdot
.03917 .30902 Mdot
.03923 .30902 Mdot
.03929 .30902 Mdot
.03935 .3066 Mdot
.03941 .3066 Mdot
.03947 .30902 Mdot
.03953 .30902 Mdot
.03959 .3066 Mdot
.03965 .30902 Mdot
.03971 .30902 Mdot
.03977 .30902 Mdot
.03983 .30902 Mdot
.03989 .3066 Mdot
.03995 .3066 Mdot
.04001 .30902 Mdot
.04007 .3066 Mdot
.04013 .30902 Mdot
.04019 .30902 Mdot
.04025 .3066 Mdot
.04031 .30902 Mdot
.04037 .30902 Mdot
.04043 .30902 Mdot
.04049 .3066 Mdot
.04055 .3066 Mdot
.04061 .30902 Mdot
.04067 .3066 Mdot
.04073 .3066 Mdot
.04079 .30902 Mdot
.04085 .30902 Mdot
.04091 .3066 Mdot
.04097 .30902 Mdot
.04103 .3066 Mdot
.04109 .3066 Mdot
.04115 .30902 Mdot
.04121 .30902 Mdot
.04127 .30902 Mdot
.04133 .3066 Mdot
.04139 .3066 Mdot
.04145 .30902 Mdot
.04151 .30902 Mdot
.04157 .3066 Mdot
.04163 .30902 Mdot
.04169 .30902 Mdot
.04175 .30902 Mdot
.04181 .30902 Mdot
.04187 .3066 Mdot
.04193 .3066 Mdot
.04199 .30902 Mdot
.04205 .3066 Mdot
.04211 .30902 Mdot
.04217 .30902 Mdot
.04223 .3066 Mdot
.04229 .30902 Mdot
.04235 .3066 Mdot
.04241 .3066 Mdot
.04247 .30902 Mdot
.04253 .3066 Mdot
.04259 .30902 Mdot
.04265 .30902 Mdot
.04271 .30902 Mdot
.04277 .30902 Mdot
.04283 .30902 Mdot
.04289 .30902 Mdot
.04295 .30902 Mdot
.04301 .30902 Mdot
.04307 .30902 Mdot
.04313 .30902 Mdot
.04319 .30902 Mdot
.04325 .30902 Mdot
.04331 .30902 Mdot
.04337 .30902 Mdot
.04343 .30902 Mdot
.04349 .30902 Mdot
.04355 .30902 Mdot
.04361 .30902 Mdot
.04367 .30902 Mdot
.04373 .30902 Mdot
.04379 .30902 Mdot
.04385 .30902 Mdot
.04391 .30902 Mdot
.04397 .30902 Mdot
.04403 .30902 Mdot
.04409 .30902 Mdot
.04415 .30902 Mdot
.04421 .30902 Mdot
.04427 .30902 Mdot
.04433 .30902 Mdot
.04439 .30902 Mdot
.04445 .30902 Mdot
.04451 .30902 Mdot
.04457 .30902 Mdot
.04463 .30902 Mdot
.04469 .30902 Mdot
.04475 .30902 Mdot
.04481 .30902 Mdot
.04487 .30902 Mdot
.04493 .30902 Mdot
.04499 .30902 Mdot
.04505 .30902 Mdot
.04511 .30902 Mdot
.04517 .30902 Mdot
.04523 .30902 Mdot
.04529 .30902 Mdot
.04535 .30902 Mdot
.04541 .30902 Mdot
.04547 .30902 Mdot
.04553 .30902 Mdot
.04559 .30902 Mdot
.04565 .30902 Mdot
.04571 .30902 Mdot
.04577 .30902 Mdot
.04583 .30902 Mdot
.04589 .30902 Mdot
.04595 .30902 Mdot
.04601 .30902 Mdot
.04607 .30902 Mdot
.04613 .30902 Mdot
.04619 .30902 Mdot
.04625 .30902 Mdot
.04631 .30902 Mdot
.04637 .30902 Mdot
.04643 .30902 Mdot
.04649 .30902 Mdot
.04655 .30902 Mdot
.04661 .30902 Mdot
.04667 .30902 Mdot
.04673 .30902 Mdot
.04679 .30902 Mdot
.04685 .30902 Mdot
.04691 .30902 Mdot
.04697 .30902 Mdot
.04703 .30902 Mdot
.04709 .30902 Mdot
.04715 .30902 Mdot
.04721 .30902 Mdot
.04727 .30902 Mdot
.04733 .30902 Mdot
.04739 .30902 Mdot
.04745 .30902 Mdot
.04751 .30902 Mdot
.04757 .30902 Mdot
.04763 .30902 Mdot
.04769 .30902 Mdot
.04775 .30902 Mdot
.04781 .30902 Mdot
.04787 .30902 Mdot
.04792 .30902 Mdot
.04798 .30902 Mdot
.04804 .30902 Mdot
.0481 .30902 Mdot
.04816 .30902 Mdot
.04822 .30902 Mdot
.04828 .30902 Mdot
.04834 .30902 Mdot
.0484 .30902 Mdot
.04846 .30902 Mdot
.04852 .30902 Mdot
.04858 .30902 Mdot
.04864 .30902 Mdot
.0487 .30902 Mdot
.04876 .30902 Mdot
.04882 .30902 Mdot
.04888 .30902 Mdot
.04894 .30902 Mdot
.049 .30902 Mdot
.04906 .30902 Mdot
.04912 .30902 Mdot
.04918 .30902 Mdot
.04924 .30902 Mdot
.0493 .30902 Mdot
.04936 .30902 Mdot
.04942 .30902 Mdot
.04948 .30902 Mdot
.04954 .30902 Mdot
.0496 .30902 Mdot
.04966 .30902 Mdot
.04972 .30902 Mdot
.04978 .30902 Mdot
.04984 .30902 Mdot
.0499 .30902 Mdot
.04996 .30902 Mdot
.05002 .30902 Mdot
.05008 .30902 Mdot
.05014 .30902 Mdot
.0502 .30902 Mdot
.05026 .30902 Mdot
.05032 .30902 Mdot
.05038 .30902 Mdot
.05044 .30902 Mdot
.0505 .30902 Mdot
.05056 .30902 Mdot
.05062 .3066 Mdot
.05068 .30902 Mdot
.05074 .3066 Mdot
.0508 .3066 Mdot
.05086 .30902 Mdot
.05092 .3066 Mdot
.05098 .30902 Mdot
.05104 .3066 Mdot
.0511 .3066 Mdot
.05116 .30902 Mdot
.05122 .30902 Mdot
.05128 .30902 Mdot
.05134 .30902 Mdot
.0514 .30902 Mdot
.05146 .30902 Mdot
.05152 .30902 Mdot
.05158 .30902 Mdot
.05164 .30902 Mdot
.0517 .30902 Mdot
.05176 .30902 Mdot
.05182 .30902 Mdot
.05188 .30902 Mdot
.05194 .30902 Mdot
.052 .31143 Mdot
.05206 .31867 Mdot
.05212 .30902 Mdot
.05218 .2897 Mdot
.05224 .28729 Mdot
.0523 .29936 Mdot
.05236 .31143 Mdot
.05242 .31867 Mdot
.05248 .31143 Mdot
.05254 .31385 Mdot
.0526 .32109 Mdot
.05266 .31385 Mdot
.05272 .30419 Mdot
.05278 .31385 Mdot
.05284 .31385 Mdot
.0529 .29695 Mdot
.05296 .2897 Mdot
.05302 .30177 Mdot
.05308 .29936 Mdot
.05314 .29212 Mdot
.0532 .30902 Mdot
.05326 .32109 Mdot
.05332 .31385 Mdot
.05338 .31626 Mdot
.05344 .33074 Mdot
.0535 .3235 Mdot
.05356 .30902 Mdot
.05362 .31385 Mdot
.05368 .31385 Mdot
.05374 .29453 Mdot
.0538 .28488 Mdot
.05386 .29695 Mdot
.05392 .30177 Mdot
.05398 .29453 Mdot
.05404 .30419 Mdot
.0541 .31626 Mdot
.05416 .31385 Mdot
.05422 .31867 Mdot
.05428 .33316 Mdot
.05434 .33074 Mdot
.0544 .31626 Mdot
.05446 .31385 Mdot
.05452 .31385 Mdot
.05458 .29936 Mdot
.05464 .2897 Mdot
.0547 .29453 Mdot
.05476 .29212 Mdot
.05482 .2897 Mdot
.05488 .30177 Mdot
.05494 .31867 Mdot
.055 .31626 Mdot
.05506 .31867 Mdot
.05512 .33316 Mdot
.05518 .33316 Mdot
.05524 .31867 Mdot
.0553 .31626 Mdot
.05536 .31626 Mdot
.05542 .29936 Mdot
.05548 .2897 Mdot
.05554 .29695 Mdot
.0556 .29453 Mdot
.05566 .28488 Mdot
.05572 .29695 Mdot
.05578 .31385 Mdot
.05584 .31385 Mdot
.0559 .31626 Mdot
.05596 .33074 Mdot
.05602 .33316 Mdot
.05608 .32109 Mdot
.05614 .31867 Mdot
.0562 .31867 Mdot
.05626 .30419 Mdot
.05632 .29212 Mdot
.05638 .29453 Mdot
.05644 .29212 Mdot
.0565 .28488 Mdot
.05656 .29453 Mdot
.05662 .31143 Mdot
.05668 .31143 Mdot
.05674 .31385 Mdot
.0568 .32833 Mdot
.05686 .33316 Mdot
.05692 .32109 Mdot
.05698 .31867 Mdot
.05704 .31867 Mdot
.0571 .3066 Mdot
.05716 .29212 Mdot
.05722 .29453 Mdot
.05728 .29453 Mdot
.05734 .28488 Mdot
.0574 .29453 Mdot
.05746 .30902 Mdot
.05752 .31143 Mdot
.05758 .31385 Mdot
.05764 .32833 Mdot
.0577 .33316 Mdot
.05776 .32109 Mdot
.05782 .31867 Mdot
.05788 .31867 Mdot
.05794 .30419 Mdot
.058 .29212 Mdot
.05806 .29453 Mdot
.05812 .29453 Mdot
.05818 .28729 Mdot
.05824 .29453 Mdot
.0583 .30902 Mdot
.05836 .31143 Mdot
.05842 .31385 Mdot
.05848 .32833 Mdot
.05854 .33074 Mdot
.0586 .32109 Mdot
.05866 .31867 Mdot
.05872 .31867 Mdot
.05878 .30419 Mdot
.05884 .29212 Mdot
.0589 .29212 Mdot
.05896 .29212 Mdot
.05902 .28729 Mdot
.05908 .29453 Mdot
.05914 .30902 Mdot
.0592 .31385 Mdot
.05926 .31626 Mdot
.05932 .32833 Mdot
.05938 .33316 Mdot
.05944 .3235 Mdot
.0595 .31867 Mdot
.05956 .31626 Mdot
.05962 .30419 Mdot
.05968 .2897 Mdot
.05974 .2897 Mdot
.0598 .29212 Mdot
.05986 .28729 Mdot
.05992 .29453 Mdot
.05998 .30902 Mdot
.06004 .31385 Mdot
.0601 .31626 Mdot
.06016 .32833 Mdot
.06022 .33316 Mdot
.06028 .3235 Mdot
.06034 .31867 Mdot
.0604 .31626 Mdot
.06046 .30419 Mdot
.06052 .29212 Mdot
.06058 .29212 Mdot
.06064 .29212 Mdot
.0607 .28729 Mdot
.06076 .29453 Mdot
.06082 .30902 Mdot
.06088 .31385 Mdot
.06094 .31626 Mdot
.061 .32833 Mdot
.06106 .33316 Mdot
.06112 .3235 Mdot
.06118 .31867 Mdot
.06124 .31867 Mdot
.0613 .3066 Mdot
.06136 .29212 Mdot
.06142 .29212 Mdot
.06148 .29212 Mdot
.06154 .28488 Mdot
.0616 .2897 Mdot
.06166 .3066 Mdot
.06172 .31143 Mdot
.06178 .31626 Mdot
.06184 .32592 Mdot
.0619 .33316 Mdot
.06196 .32592 Mdot
.06202 .32109 Mdot
.06208 .32109 Mdot
.06214 .30902 Mdot
.0622 .29453 Mdot
.06226 .29212 Mdot
.06232 .29212 Mdot
.06238 .28488 Mdot
.06244 .28729 Mdot
.0625 .30177 Mdot
.06256 .30902 Mdot
.06262 .31385 Mdot
.06268 .3235 Mdot
.06274 .33316 Mdot
.0628 .32592 Mdot
.06286 .32109 Mdot
.06292 .32109 Mdot
.06298 .31143 Mdot
.06304 .29695 Mdot
.0631 .29212 Mdot
.06316 .29212 Mdot
.06322 .28488 Mdot
.06328 .28729 Mdot
.06334 .29936 Mdot
.0634 .3066 Mdot
.06346 .31143 Mdot
.06352 .32109 Mdot
.06358 .33074 Mdot
.06364 .32592 Mdot
.0637 .3235 Mdot
.06376 .3235 Mdot
.06382 .31385 Mdot
.06388 .29936 Mdot
.06394 .29453 Mdot
.064 .29453 Mdot
.06406 .28729 Mdot
.06412 .28729 Mdot
.06418 .29936 Mdot
.06424 .3066 Mdot
.0643 .30902 Mdot
.06436 .31867 Mdot
.06442 .32833 Mdot
.06448 .32592 Mdot
.06454 .32109 Mdot
.0646 .3235 Mdot
.06466 .31626 Mdot
.06472 .30177 Mdot
.06478 .29695 Mdot
.06484 .29695 Mdot
.0649 .2897 Mdot
.06496 .28729 Mdot
.06502 .29936 Mdot
.06508 .3066 Mdot
.06514 .3066 Mdot
.0652 .31867 Mdot
.06526 .32833 Mdot
.06532 .32592 Mdot
.06538 .32109 Mdot
.06544 .3235 Mdot
.0655 .31626 Mdot
.06556 .30177 Mdot
.06562 .29695 Mdot
.06568 .29695 Mdot
.06574 .2897 Mdot
.0658 .28729 Mdot
.06586 .29936 Mdot
.06592 .3066 Mdot
.06598 .3066 Mdot
.06604 .31626 Mdot
.0661 .32833 Mdot
.06616 .32592 Mdot
.06622 .32109 Mdot
.06628 .32109 Mdot
.06634 .31626 Mdot
.0664 .30177 Mdot
.06646 .29695 Mdot
.06652 .29695 Mdot
.06658 .2897 Mdot
.06664 .2897 Mdot
.0667 .29936 Mdot
.06676 .3066 Mdot
.06682 .3066 Mdot
.06688 .31626 Mdot
.06694 .32592 Mdot
.067 .3235 Mdot
.06706 .31867 Mdot
.06712 .32109 Mdot
.06718 .31626 Mdot
.06724 .30419 Mdot
.0673 .29936 Mdot
.06736 .29936 Mdot
.06742 .29212 Mdot
.06748 .2897 Mdot
.06754 .29936 Mdot
.0676 .3066 Mdot
.06766 .3066 Mdot
.06772 .31385 Mdot
.06778 .3235 Mdot
.06784 .3235 Mdot
.0679 .31867 Mdot
.06796 .32109 Mdot
.06802 .31626 Mdot
.06808 .3066 Mdot
.06814 .29936 Mdot
.0682 .29936 Mdot
.06826 .29453 Mdot
.06832 .29212 Mdot
.06838 .29936 Mdot
.06844 .3066 Mdot
.0685 .3066 Mdot
.06856 .31385 Mdot
.06862 .32109 Mdot
.06868 .3235 Mdot
.06874 .31867 Mdot
.0688 .31867 Mdot
.06886 .31626 Mdot
.06892 .3066 Mdot
.06898 .30177 Mdot
.06904 .30177 Mdot
.0691 .29695 Mdot
.06916 .29212 Mdot
.06922 .29936 Mdot
.06928 .3066 Mdot
.06934 .3066 Mdot
.0694 .31143 Mdot
.06946 .32109 Mdot
.06952 .32109 Mdot
.06958 .31867 Mdot
.06964 .31867 Mdot
.0697 .31626 Mdot
.06976 .3066 Mdot
.06982 .30177 Mdot
.06988 .30177 Mdot
.06994 .29695 Mdot
.07 .29212 Mdot
.07006 .29936 Mdot
.07012 .30419 Mdot
.07018 .3066 Mdot
.07024 .31143 Mdot
.0703 .32109 Mdot
.07036 .32109 Mdot
.07042 .31867 Mdot
.07048 .31867 Mdot
.07054 .31626 Mdot
.0706 .30902 Mdot
.07066 .30177 Mdot
.07072 .30177 Mdot
.07078 .29695 Mdot
.07084 .29212 Mdot
.0709 .29936 Mdot
.07096 .30419 Mdot
.07102 .3066 Mdot
.07108 .31143 Mdot
.07114 .32109 Mdot
.0712 .32109 Mdot
.07126 .31867 Mdot
.07132 .31867 Mdot
.07138 .31867 Mdot
.07144 .30902 Mdot
.0715 .30419 Mdot
.07156 .30177 Mdot
.07162 .29695 Mdot
.07168 .29453 Mdot
.07174 .29936 Mdot
.0718 .30419 Mdot
.07186 .3066 Mdot
.07192 .31143 Mdot
.07198 .31867 Mdot
.07204 .32109 Mdot
.0721 .31867 Mdot
.07216 .31867 Mdot
.07222 .31867 Mdot
.07228 .30902 Mdot
.07234 .30419 Mdot
.0724 .30177 Mdot
.07246 .29936 Mdot
.07252 .29453 Mdot
.07258 .29695 Mdot
.07264 .30419 Mdot
.0727 .3066 Mdot
.07276 .30902 Mdot
.07282 .31867 Mdot
.07288 .32109 Mdot
.07294 .31867 Mdot
.073 .31867 Mdot
.07306 .31867 Mdot
.07312 .30902 Mdot
.07318 .30419 Mdot
.07324 .30177 Mdot
.0733 .29936 Mdot
.07336 .29453 Mdot
.07342 .29936 Mdot
.07348 .30419 Mdot
.07354 .3066 Mdot
.0736 .30902 Mdot
.07366 .31626 Mdot
.07372 .32109 Mdot
.07378 .31867 Mdot
.07384 .31867 Mdot
.0739 .31867 Mdot
.07396 .30902 Mdot
.07402 .30419 Mdot
.07408 .30419 Mdot
.07414 .29936 Mdot
.0742 .29453 Mdot
.07426 .29936 Mdot
.07432 .30419 Mdot
.07438 .3066 Mdot
.07444 .30902 Mdot
.0745 .31626 Mdot
.07456 .32109 Mdot
.07462 .31626 Mdot
.07468 .31867 Mdot
.07474 .31867 Mdot
.0748 .31143 Mdot
.07486 .30419 Mdot
.07492 .30419 Mdot
.07498 .29936 Mdot
.07504 .29453 Mdot
.0751 .29936 Mdot
.07516 .30419 Mdot
.07522 .3066 Mdot
.07528 .30902 Mdot
.07534 .31626 Mdot
.0754 .31867 Mdot
.07546 .31626 Mdot
.07552 .31867 Mdot
.07558 .31867 Mdot
.07564 .31143 Mdot
.0757 .30419 Mdot
.07576 .30419 Mdot
.07582 .30177 Mdot
.07588 .29695 Mdot
.07594 .29695 Mdot
.076 .30419 Mdot
.07606 .3066 Mdot
.07612 .30902 Mdot
.07618 .31626 Mdot
.07624 .31867 Mdot
.0763 .31626 Mdot
.07636 .31626 Mdot
.07642 .31867 Mdot
.07648 .31143 Mdot
.07654 .30419 Mdot
.0766 .30419 Mdot
.07666 .30177 Mdot
.07672 .29695 Mdot
.07678 .29695 Mdot
.07684 .30419 Mdot
.0769 .3066 Mdot
.07696 .3066 Mdot
.07702 .31626 Mdot
.07708 .31867 Mdot
.07714 .31867 Mdot
.0772 .31626 Mdot
.07726 .31867 Mdot
.07732 .31143 Mdot
.07738 .30419 Mdot
.07744 .30419 Mdot
.0775 .30177 Mdot
.07756 .29695 Mdot
.07762 .29695 Mdot
.07768 .30419 Mdot
.07774 .3066 Mdot
.0778 .3066 Mdot
.07786 .31385 Mdot
.07792 .31867 Mdot
.07798 .31867 Mdot
.07804 .31626 Mdot
.0781 .31867 Mdot
.07816 .31143 Mdot
.07822 .3066 Mdot
.07828 .30419 Mdot
.07834 .30177 Mdot
.0784 .29695 Mdot
.07846 .29695 Mdot
.07852 .30419 Mdot
.07858 .3066 Mdot
.07864 .3066 Mdot
.0787 .31385 Mdot
.07876 .31867 Mdot
.07882 .31867 Mdot
.07888 .31626 Mdot
.07894 .31867 Mdot
.079 .31385 Mdot
.07906 .3066 Mdot
.07912 .30419 Mdot
.07918 .30177 Mdot
.07924 .29695 Mdot
.0793 .29695 Mdot
.07936 .30419 Mdot
.07942 .3066 Mdot
.07948 .3066 Mdot
.07954 .31385 Mdot
.0796 .31867 Mdot
.07966 .31867 Mdot
.07972 .31626 Mdot
.07978 .31867 Mdot
.07984 .31385 Mdot
.0799 .3066 Mdot
.07996 .30419 Mdot
.08002 .30177 Mdot
.08008 .29695 Mdot
.08014 .29695 Mdot
.0802 .30177 Mdot
.08026 .3066 Mdot
.08032 .3066 Mdot
.08038 .31385 Mdot
.08044 .31867 Mdot
.0805 .31867 Mdot
.08056 .31626 Mdot
.08062 .31867 Mdot
.08068 .31385 Mdot
.08074 .3066 Mdot
.0808 .30419 Mdot
.08086 .30177 Mdot
.08092 .29695 Mdot
.08098 .29695 Mdot
.08104 .30177 Mdot
.0811 .3066 Mdot
.08116 .3066 Mdot
.08122 .31143 Mdot
.08128 .31867 Mdot
.08134 .31867 Mdot
.0814 .31626 Mdot
.08146 .31867 Mdot
.08152 .31385 Mdot
.08158 .3066 Mdot
.08164 .30419 Mdot
.0817 .30419 Mdot
.08176 .29936 Mdot
.08182 .29695 Mdot
.08188 .30177 Mdot
.08194 .3066 Mdot
.082 .3066 Mdot
.08206 .31143 Mdot
.08212 .31867 Mdot
.08218 .31867 Mdot
.08224 .31626 Mdot
.0823 .31867 Mdot
.08236 .31385 Mdot
.08242 .3066 Mdot
.08248 .30419 Mdot
.08254 .30419 Mdot
.0826 .29936 Mdot
.08266 .29695 Mdot
.08272 .30177 Mdot
.08278 .3066 Mdot
.08284 .3066 Mdot
.0829 .31143 Mdot
.08296 .31867 Mdot
.08302 .31867 Mdot
.08308 .31626 Mdot
.08314 .31626 Mdot
.0832 .31385 Mdot
.08326 .3066 Mdot
.08332 .30419 Mdot
.08338 .30419 Mdot
.08344 .29936 Mdot
.0835 .29695 Mdot
.08356 .30177 Mdot
.08362 .3066 Mdot
.08368 .3066 Mdot
.08374 .31143 Mdot
.0838 .31867 Mdot
.08386 .31867 Mdot
.08392 .31626 Mdot
.08398 .31626 Mdot
.08404 .31626 Mdot
.0841 .30902 Mdot
.08416 .30419 Mdot
.08422 .30419 Mdot
.08428 .29936 Mdot
.08434 .29695 Mdot
.0844 .30177 Mdot
.08446 .3066 Mdot
.08452 .3066 Mdot
.08458 .31143 Mdot
.08464 .31867 Mdot
.0847 .31867 Mdot
.08476 .31626 Mdot
.08482 .31626 Mdot
.08488 .31626 Mdot
.08494 .30902 Mdot
.085 .30419 Mdot
.08506 .30419 Mdot
.08512 .29936 Mdot
.08518 .29695 Mdot
.08524 .30177 Mdot
.0853 .3066 Mdot
.08536 .3066 Mdot
.08542 .31143 Mdot
.08548 .31626 Mdot
.08554 .31867 Mdot
.0856 .31626 Mdot
.08566 .31626 Mdot
.08572 .31626 Mdot
.08578 .30902 Mdot
.08584 .30419 Mdot
.0859 .30419 Mdot
.08596 .29936 Mdot
.08602 .29695 Mdot
.08608 .29936 Mdot
.08614 .3066 Mdot
.0862 .3066 Mdot
.08626 .30902 Mdot
.08632 .31626 Mdot
.08638 .31867 Mdot
.08644 .31626 Mdot
.0865 .31626 Mdot
.08656 .31626 Mdot
.08662 .30902 Mdot
.08668 .30419 Mdot
.08674 .30419 Mdot
.0868 .29936 Mdot
.08686 .29695 Mdot
.08692 .29936 Mdot
.08698 .30419 Mdot
.08704 .3066 Mdot
.0871 .30902 Mdot
.08716 .31626 Mdot
.08722 .31867 Mdot
.08728 .31626 Mdot
.08734 .31626 Mdot
.0874 .31626 Mdot
.08746 .30902 Mdot
.08752 .30419 Mdot
.08758 .30419 Mdot
.08764 .30177 Mdot
.0877 .29695 Mdot
.08776 .29936 Mdot
.08782 .30419 Mdot
.08788 .3066 Mdot
.08794 .30902 Mdot
.088 .31626 Mdot
.08806 .31867 Mdot
.08812 .31626 Mdot
.08818 .31626 Mdot
.08824 .31626 Mdot
.0883 .31143 Mdot
.08836 .30419 Mdot
.08842 .30419 Mdot
.08848 .30177 Mdot
.08854 .29695 Mdot
.0886 .29936 Mdot
.08866 .30419 Mdot
.08872 .3066 Mdot
.08878 .30902 Mdot
.08884 .31626 Mdot
.0889 .31867 Mdot
.08896 .31626 Mdot
.08902 .31626 Mdot
.08908 .31626 Mdot
.08914 .31143 Mdot
.0892 .30419 Mdot
.08926 .30419 Mdot
.08932 .30177 Mdot
.08938 .29695 Mdot
.08944 .29936 Mdot
.0895 .30419 Mdot
.08956 .3066 Mdot
.08962 .30902 Mdot
.08968 .31385 Mdot
.08974 .31867 Mdot
.0898 .31626 Mdot
.08986 .31626 Mdot
.08992 .31626 Mdot
.08998 .31143 Mdot
.09004 .30419 Mdot
.0901 .30419 Mdot
.09016 .30177 Mdot
.09022 .29695 Mdot
.09028 .29936 Mdot
.09034 .30419 Mdot
.0904 .3066 Mdot
.09046 .3066 Mdot
.09052 .31385 Mdot
.09058 .31867 Mdot
.09064 .31626 Mdot
.0907 .31626 Mdot
.09076 .31626 Mdot
.09082 .31143 Mdot
.09088 .30419 Mdot
.09094 .30419 Mdot
.091 .30177 Mdot
.09106 .29695 Mdot
.09112 .29936 Mdot
.09118 .30419 Mdot
.09124 .3066 Mdot
.0913 .3066 Mdot
.09136 .31385 Mdot
.09142 .31867 Mdot
.09148 .31626 Mdot
.09154 .31626 Mdot
.0916 .31626 Mdot
.09166 .31143 Mdot
.09172 .3066 Mdot
.09178 .30419 Mdot
.09184 .30177 Mdot
.0919 .29695 Mdot
.09196 .29936 Mdot
.09202 .30419 Mdot
.09208 .3066 Mdot
.09214 .3066 Mdot
.0922 .31385 Mdot
.09226 .31867 Mdot
.09232 .31626 Mdot
.09238 .31626 Mdot
.09244 .31626 Mdot
.0925 .31385 Mdot
.09256 .3066 Mdot
.09262 .30419 Mdot
.09268 .30177 Mdot
.09274 .29695 Mdot
.0928 .29695 Mdot
.09286 .30419 Mdot
.09292 .3066 Mdot
.09298 .3066 Mdot
.09304 .31385 Mdot
.0931 .31867 Mdot
.09316 .31626 Mdot
.09322 .31626 Mdot
.09328 .31626 Mdot
.09334 .31385 Mdot
.0934 .3066 Mdot
.09346 .30419 Mdot
.09352 .30419 Mdot
.09358 .29936 Mdot
.09364 .29695 Mdot
.0937 .30419 Mdot
.09376 .3066 Mdot
.09382 .3066 Mdot
.09388 .31385 Mdot
.09394 .31867 Mdot
.094 .31626 Mdot
.09406 .31626 Mdot
.09412 .31626 Mdot
.09418 .31385 Mdot
.09424 .3066 Mdot
.0943 .30419 Mdot
.09436 .30419 Mdot
.09442 .29936 Mdot
.09448 .29695 Mdot
.09454 .30419 Mdot
.0946 .3066 Mdot
.09466 .3066 Mdot
.09472 .31143 Mdot
.09478 .31867 Mdot
.09484 .31626 Mdot
.0949 .31626 Mdot
.09496 .31626 Mdot
.09502 .31385 Mdot
.09508 .3066 Mdot
.09514 .30419 Mdot
.0952 .30419 Mdot
.09526 .29936 Mdot
.09532 .29936 Mdot
.09538 .30419 Mdot
.09544 .3066 Mdot
.0955 .3066 Mdot
.09556 .31143 Mdot
.09562 .31867 Mdot
.09568 .31626 Mdot
.09574 .31626 Mdot
.0958 .31626 Mdot
.09586 .31385 Mdot
.09592 .3066 Mdot
.09598 .30419 Mdot
.09604 .30419 Mdot
.0961 .29936 Mdot
.09616 .29695 Mdot
.09622 .30177 Mdot
.09628 .3066 Mdot
.09634 .3066 Mdot
.0964 .31143 Mdot
.09646 .31626 Mdot
.09652 .31626 Mdot
.09658 .31626 Mdot
.09664 .31626 Mdot
.0967 .31385 Mdot
.09676 .3066 Mdot
.09682 .30419 Mdot
.09688 .30419 Mdot
.09694 .29936 Mdot
.097 .29695 Mdot
.09706 .30177 Mdot
.09712 .3066 Mdot
.09718 .3066 Mdot
.09724 .31143 Mdot
.0973 .31626 Mdot
.09736 .31626 Mdot
.09742 .31626 Mdot
.09748 .31626 Mdot
.09754 .31385 Mdot
.0976 .3066 Mdot
.09766 .30419 Mdot
.09772 .30419 Mdot
.09778 .29936 Mdot
.09784 .29695 Mdot
.0979 .30177 Mdot
.09796 .3066 Mdot
.09802 .3066 Mdot
.09808 .31143 Mdot
.09814 .31626 Mdot
.0982 .31867 Mdot
.09826 .31626 Mdot
.09832 .31626 Mdot
.09838 .31385 Mdot
.09844 .30902 Mdot
.0985 .30419 Mdot
.09856 .30419 Mdot
.09862 .30177 Mdot
.09868 .29695 Mdot
.09874 .30177 Mdot
.0988 .3066 Mdot
.09886 .3066 Mdot
.09892 .31143 Mdot
.09898 .31626 Mdot
.09904 .31867 Mdot
.0991 .31626 Mdot
.09916 .31626 Mdot
.09922 .31385 Mdot
.09928 .30902 Mdot
.09934 .30419 Mdot
.0994 .30419 Mdot
.09946 .30177 Mdot
.09952 .29695 Mdot
.09958 .30177 Mdot
.09964 .3066 Mdot
.0997 .3066 Mdot
.09976 .30902 Mdot
.09982 .31626 Mdot
.09988 .31867 Mdot
.09994 .31626 Mdot
.1 .31626 Mdot
.10006 .31626 Mdot
.10012 .30902 Mdot
.10018 .30419 Mdot
.10024 .30419 Mdot
.1003 .30177 Mdot
.10036 .29695 Mdot
.10042 .30177 Mdot
.10048 .3066 Mdot
.10054 .3066 Mdot
.1006 .30902 Mdot
.10066 .31626 Mdot
.10072 .31867 Mdot
.10078 .31626 Mdot
.10084 .31626 Mdot
.1009 .31626 Mdot
.10096 .30902 Mdot
.10102 .30419 Mdot
.10107 .30419 Mdot
.10113 .30177 Mdot
.10119 .29695 Mdot
.10125 .30177 Mdot
.10131 .3066 Mdot
.10137 .3066 Mdot
.10143 .30902 Mdot
.10149 .31626 Mdot
.10155 .31867 Mdot
.10161 .31626 Mdot
.10167 .31626 Mdot
.10173 .31626 Mdot
.10179 .30902 Mdot
.10185 .30419 Mdot
.10191 .30419 Mdot
.10197 .30177 Mdot
.10203 .29695 Mdot
.10209 .29936 Mdot
.10215 .3066 Mdot
.10221 .3066 Mdot
.10227 .30902 Mdot
.10233 .31626 Mdot
.10239 .31867 Mdot
.10245 .31626 Mdot
.10251 .31626 Mdot
.10257 .31626 Mdot
.10263 .30902 Mdot
.10269 .30419 Mdot
.10275 .30419 Mdot
.10281 .30177 Mdot
.10287 .29695 Mdot
.10293 .29936 Mdot
.10299 .30419 Mdot
.10305 .3066 Mdot
.10311 .30902 Mdot
.10317 .31385 Mdot
.10323 .31867 Mdot
.10329 .31626 Mdot
.10335 .31626 Mdot
.10341 .31626 Mdot
.10347 .31143 Mdot
.10353 .30419 Mdot
.10359 .30419 Mdot
.10365 .30177 Mdot
.10371 .29936 Mdot
.10377 .29936 Mdot
.10383 .30419 Mdot
.10389 .3066 Mdot
.10395 .30902 Mdot
.10401 .31385 Mdot
.10407 .31867 Mdot
.10413 .31626 Mdot
.10419 .31626 Mdot
.10425 .31626 Mdot
.10431 .31143 Mdot
.10437 .30419 Mdot
.10443 .30419 Mdot
.10449 .30177 Mdot
.10455 .29936 Mdot
.10461 .29936 Mdot
.10467 .30419 Mdot
.10473 .3066 Mdot
.10479 .30902 Mdot
.10485 .31385 Mdot
.10491 .31867 Mdot
.10497 .31626 Mdot
.10503 .31626 Mdot
.10509 .31626 Mdot
.10515 .31143 Mdot
.10521 .3066 Mdot
.10527 .30419 Mdot
.10533 .30419 Mdot
.10539 .29936 Mdot
.10545 .29936 Mdot
.10551 .30419 Mdot
.10557 .3066 Mdot
.10563 .30902 Mdot
.10569 .31385 Mdot
.10575 .31867 Mdot
.10581 .31626 Mdot
.10587 .31626 Mdot
.10593 .31626 Mdot
.10599 .31143 Mdot
.10605 .3066 Mdot
.10611 .30419 Mdot
.10617 .30419 Mdot
.10623 .29936 Mdot
.10629 .29936 Mdot
.10635 .30419 Mdot
.10641 .3066 Mdot
.10647 .3066 Mdot
.10653 .31385 Mdot
.10659 .31867 Mdot
.10665 .31626 Mdot
.10671 .31626 Mdot
.10677 .31626 Mdot
.10683 .31143 Mdot
.10689 .3066 Mdot
.10695 .30419 Mdot
.10701 .30419 Mdot
.10707 .29936 Mdot
.10713 .29936 Mdot
.10719 .30419 Mdot
.10725 .3066 Mdot
.10731 .3066 Mdot
.10737 .31143 Mdot
.10743 .31626 Mdot
.10749 .31626 Mdot
.10755 .31626 Mdot
.10761 .31626 Mdot
.10767 .31385 Mdot
.10773 .3066 Mdot
.10779 .30419 Mdot
.10785 .30419 Mdot
.10791 .29936 Mdot
.10797 .29936 Mdot
.10803 .30419 Mdot
.10809 .3066 Mdot
.10815 .3066 Mdot
.10821 .31143 Mdot
.10827 .31626 Mdot
.10833 .31626 Mdot
.10839 .31626 Mdot
.10845 .31626 Mdot
.10851 .31385 Mdot
.10857 .3066 Mdot
.10863 .30419 Mdot
.10869 .30419 Mdot
.10875 .29936 Mdot
.10881 .29936 Mdot
.10887 .30419 Mdot
.10893 .3066 Mdot
.10899 .3066 Mdot
.10905 .31143 Mdot
.10911 .31626 Mdot
.10917 .31626 Mdot
.10923 .31626 Mdot
.10929 .31626 Mdot
.10935 .31385 Mdot
.10941 .3066 Mdot
.10947 .30419 Mdot
.10953 .30419 Mdot
.10959 .29936 Mdot
.10965 .29936 Mdot
.10971 .30177 Mdot
.10977 .3066 Mdot
.10983 .3066 Mdot
.10989 .31143 Mdot
.10995 .31626 Mdot
.11001 .31626 Mdot
.11007 .31385 Mdot
.11013 .31626 Mdot
.11019 .31385 Mdot
.11025 .30902 Mdot
.11031 .30419 Mdot
.11037 .30419 Mdot
.11043 .30177 Mdot
.11049 .29936 Mdot
.11055 .30177 Mdot
.11061 .3066 Mdot
.11067 .3066 Mdot
.11073 .31143 Mdot
.11079 .31626 Mdot
.11085 .31626 Mdot
.11091 .31385 Mdot
.11097 .31626 Mdot
.11103 .31385 Mdot
.11109 .30902 Mdot
.11115 .30419 Mdot
.11121 .30419 Mdot
.11127 .30177 Mdot
.11133 .29936 Mdot
.11139 .30177 Mdot
.11145 .3066 Mdot
.11151 .3066 Mdot
.11157 .30902 Mdot
.11163 .31626 Mdot
.11169 .31626 Mdot
.11175 .31626 Mdot
.11181 .31626 Mdot
.11187 .31385 Mdot
.11193 .30902 Mdot
.11199 .3066 Mdot
.11205 .30419 Mdot
.11211 .30177 Mdot
.11217 .29936 Mdot
.11223 .30177 Mdot
.11229 .3066 Mdot
.11235 .3066 Mdot
.11241 .30902 Mdot
.11247 .31385 Mdot
.11253 .31626 Mdot
.11259 .31626 Mdot
.11265 .31626 Mdot
.11271 .31385 Mdot
.11277 .30902 Mdot
.11283 .3066 Mdot
.11289 .30419 Mdot
.11295 .30177 Mdot
.11301 .29936 Mdot
.11307 .30177 Mdot
.11313 .30419 Mdot
.11319 .3066 Mdot
.11325 .30902 Mdot
.11331 .31385 Mdot
.11337 .31626 Mdot
.11343 .31626 Mdot
.11349 .31626 Mdot
.11355 .31385 Mdot
.11361 .31143 Mdot
.11367 .3066 Mdot
.11373 .30419 Mdot
.11379 .30177 Mdot
.11385 .29936 Mdot
.11391 .30177 Mdot
.11397 .30419 Mdot
.11403 .3066 Mdot
.11409 .30902 Mdot
.11415 .31385 Mdot
.11421 .31626 Mdot
.11427 .31626 Mdot
.11433 .31626 Mdot
.11439 .31385 Mdot
.11445 .31143 Mdot
.11451 .3066 Mdot
.11457 .30419 Mdot
.11463 .30177 Mdot
.11469 .29936 Mdot
.11475 .29936 Mdot
.11481 .30419 Mdot
.11487 .3066 Mdot
.11493 .30902 Mdot
.11499 .31385 Mdot
.11505 .31626 Mdot
.11511 .31626 Mdot
.11517 .31626 Mdot
.11523 .31626 Mdot
.11529 .31143 Mdot
.11535 .3066 Mdot
.11541 .30419 Mdot
.11547 .30419 Mdot
.11553 .29936 Mdot
.11559 .29936 Mdot
.11565 .30419 Mdot
.11571 .3066 Mdot
.11577 .30902 Mdot
.11583 .31385 Mdot
.11589 .31626 Mdot
.11595 .31626 Mdot
.11601 .31626 Mdot
.11607 .31626 Mdot
.11613 .31143 Mdot
.11619 .3066 Mdot
.11625 .30419 Mdot
.11631 .30419 Mdot
.11637 .29936 Mdot
.11643 .29936 Mdot
.11649 .30419 Mdot
.11655 .3066 Mdot
.11661 .30902 Mdot
.11667 .31143 Mdot
.11673 .31626 Mdot
.11679 .31626 Mdot
.11685 .31626 Mdot
.11691 .31626 Mdot
.11697 .31143 Mdot
.11703 .3066 Mdot
.11709 .30419 Mdot
.11715 .30419 Mdot
.11721 .29936 Mdot
.11727 .29936 Mdot
.11733 .30419 Mdot
.11739 .3066 Mdot
.11745 .3066 Mdot
.11751 .31143 Mdot
.11757 .31626 Mdot
.11763 .31626 Mdot
.11769 .31626 Mdot
.11775 .31626 Mdot
.11781 .31143 Mdot
.11787 .3066 Mdot
.11793 .30419 Mdot
.11799 .30419 Mdot
.11805 .29936 Mdot
.11811 .29936 Mdot
.11817 .30419 Mdot
.11823 .3066 Mdot
.11829 .3066 Mdot
.11835 .31143 Mdot
.11841 .31626 Mdot
.11847 .31626 Mdot
.11853 .31626 Mdot
.11859 .31626 Mdot
.11865 .31385 Mdot
.11871 .3066 Mdot
.11877 .30419 Mdot
.11883 .30419 Mdot
.11889 .30177 Mdot
.11895 .29936 Mdot
.11901 .30419 Mdot
.11907 .3066 Mdot
.11913 .3066 Mdot
.11919 .31143 Mdot
.11925 .31626 Mdot
.11931 .31626 Mdot
.11937 .31626 Mdot
.11943 .31626 Mdot
.11949 .31385 Mdot
.11955 .3066 Mdot
.11961 .30419 Mdot
.11967 .30419 Mdot
.11973 .30177 Mdot
.11979 .29936 Mdot
.11985 .30419 Mdot
.11991 .3066 Mdot
.11997 .3066 Mdot
.12003 .31143 Mdot
.12009 .31626 Mdot
.12015 .31626 Mdot
.12021 .31385 Mdot
.12027 .31626 Mdot
.12033 .31385 Mdot
.12039 .30902 Mdot
.12045 .30419 Mdot
.12051 .30419 Mdot
.12057 .30177 Mdot
.12063 .29936 Mdot
.12069 .30177 Mdot
.12075 .3066 Mdot
.12081 .3066 Mdot
.12087 .31143 Mdot
.12093 .31626 Mdot
.12099 .31626 Mdot
.12105 .31385 Mdot
.12111 .31626 Mdot
.12117 .31385 Mdot
.12123 .30902 Mdot
.12129 .30419 Mdot
.12135 .30419 Mdot
.12141 .30177 Mdot
.12147 .29936 Mdot
.12153 .30177 Mdot
.12159 .3066 Mdot
.12165 .3066 Mdot
.12171 .31143 Mdot
.12177 .31626 Mdot
.12183 .31626 Mdot
.12189 .31626 Mdot
.12195 .31626 Mdot
.12201 .31385 Mdot
.12207 .30902 Mdot
.12213 .3066 Mdot
.12219 .30419 Mdot
.12225 .30177 Mdot
.12231 .29936 Mdot
.12237 .30177 Mdot
.12243 .3066 Mdot
.12249 .3066 Mdot
.12255 .30902 Mdot
.12261 .31385 Mdot
.12267 .31626 Mdot
.12273 .31385 Mdot
.12279 .31626 Mdot
.12285 .31385 Mdot
.12291 .30902 Mdot
.12297 .3066 Mdot
.12303 .30419 Mdot
.12309 .30177 Mdot
.12315 .29936 Mdot
.12321 .30177 Mdot
.12327 .3066 Mdot
.12333 .3066 Mdot
.12339 .30902 Mdot
.12345 .31385 Mdot
.12351 .31626 Mdot
.12357 .31385 Mdot
.12363 .31626 Mdot
.12369 .31385 Mdot
.12375 .30902 Mdot
.12381 .3066 Mdot
.12387 .30419 Mdot
.12393 .30177 Mdot
.12399 .29936 Mdot
.12405 .30177 Mdot
.12411 .3066 Mdot
.12417 .3066 Mdot
.12423 .30902 Mdot
.12429 .31385 Mdot
.12435 .31626 Mdot
.12441 .31385 Mdot
.12447 .31626 Mdot
.12453 .31385 Mdot
.12459 .30902 Mdot
.12465 .3066 Mdot
.12471 .30419 Mdot
.12477 .30177 Mdot
.12483 .29936 Mdot
.12489 .30177 Mdot
.12495 .3066 Mdot
.12501 .3066 Mdot
.12507 .30902 Mdot
.12513 .31385 Mdot
.12519 .31626 Mdot
.12525 .31626 Mdot
.12531 .31626 Mdot
.12537 .31385 Mdot
.12543 .30902 Mdot
.12549 .3066 Mdot
.12555 .30419 Mdot
.12561 .30177 Mdot
.12567 .29936 Mdot
.12573 .30177 Mdot
.12579 .3066 Mdot
.12585 .3066 Mdot
.12591 .30902 Mdot
.12597 .31385 Mdot
.12603 .31626 Mdot
.12609 .31626 Mdot
.12615 .31385 Mdot
.12621 .31385 Mdot
.12627 .30902 Mdot
.12633 .3066 Mdot
.12639 .30419 Mdot
.12645 .30177 Mdot
.12651 .29936 Mdot
.12657 .30177 Mdot
.12663 .30419 Mdot
.12669 .3066 Mdot
.12675 .30902 Mdot
.12681 .31385 Mdot
.12687 .31626 Mdot
.12693 .31385 Mdot
.12699 .31385 Mdot
.12705 .31385 Mdot
.12711 .31143 Mdot
.12717 .3066 Mdot
.12723 .30419 Mdot
.12729 .30177 Mdot
.12735 .29936 Mdot
.12741 .30177 Mdot
.12747 .30419 Mdot
.12753 .3066 Mdot
.12759 .30902 Mdot
.12765 .31385 Mdot
.12771 .31626 Mdot
.12777 .31626 Mdot
.12783 .31385 Mdot
.12789 .31385 Mdot
.12795 .31143 Mdot
.12801 .3066 Mdot
.12807 .30419 Mdot
.12813 .30419 Mdot
.12819 .29936 Mdot
.12825 .30177 Mdot
.12831 .30419 Mdot
.12837 .3066 Mdot
.12843 .30902 Mdot
.12849 .31385 Mdot
.12855 .31626 Mdot
.12861 .31626 Mdot
.12867 .31385 Mdot
.12873 .31385 Mdot
.12879 .31143 Mdot
.12885 .3066 Mdot
.12891 .30419 Mdot
.12897 .30419 Mdot
.12903 .29936 Mdot
.12909 .30177 Mdot
.12915 .30419 Mdot
.12921 .3066 Mdot
.12927 .30902 Mdot
.12933 .31143 Mdot
.12939 .31626 Mdot
.12945 .31626 Mdot
.12951 .31385 Mdot
.12957 .31385 Mdot
.12963 .31143 Mdot
.12969 .3066 Mdot
.12975 .30419 Mdot
.12981 .30419 Mdot
.12987 .30177 Mdot
.12993 .30177 Mdot
.12999 .30419 Mdot
.13005 .3066 Mdot
.13011 .3066 Mdot
.13017 .31143 Mdot
.13023 .31626 Mdot
.13029 .31385 Mdot
.13035 .31385 Mdot
.13041 .31385 Mdot
.13047 .31143 Mdot
.13053 .3066 Mdot
.13059 .30419 Mdot
.13065 .30419 Mdot
.13071 .30177 Mdot
.13077 .30177 Mdot
.13083 .30419 Mdot
.13089 .3066 Mdot
.13095 .3066 Mdot
.13101 .31143 Mdot
.13107 .31626 Mdot
.13113 .31626 Mdot
.13119 .31385 Mdot
.13125 .31385 Mdot
.13131 .31143 Mdot
.13137 .3066 Mdot
.13143 .30419 Mdot
.13149 .30419 Mdot
.13155 .30177 Mdot
.13161 .30177 Mdot
.13167 .30419 Mdot
.13173 .3066 Mdot
.13179 .3066 Mdot
.13185 .31143 Mdot
.13191 .31626 Mdot
.13197 .31626 Mdot
.13203 .31385 Mdot
.13209 .31385 Mdot
.13215 .31143 Mdot
.13221 .3066 Mdot
.13227 .3066 Mdot
.13233 .30419 Mdot
.13239 .30177 Mdot
.13245 .30177 Mdot
.13251 .30419 Mdot
.13257 .3066 Mdot
.13263 .3066 Mdot
.13269 .31143 Mdot
.13275 .31626 Mdot
.13281 .31626 Mdot
.13287 .31385 Mdot
.13293 .31385 Mdot
.13299 .31143 Mdot
.13305 .30902 Mdot
.13311 .3066 Mdot
.13317 .30419 Mdot
.13323 .30177 Mdot
.13329 .29936 Mdot
.13335 .30419 Mdot
.13341 .3066 Mdot
.13347 .3066 Mdot
.13353 .31143 Mdot
.13359 .31385 Mdot
.13365 .31626 Mdot
.13371 .31385 Mdot
.13377 .31385 Mdot
.13383 .31143 Mdot
.13389 .30902 Mdot
.13395 .3066 Mdot
.13401 .30419 Mdot
.13407 .30177 Mdot
.13413 .29936 Mdot
.13419 .30419 Mdot
.13425 .3066 Mdot
.13431 .3066 Mdot
.13437 .31143 Mdot
.13443 .31385 Mdot
.13449 .31626 Mdot
.13455 .31385 Mdot
.13461 .31385 Mdot
.13467 .31385 Mdot
.13473 .30902 Mdot
.13479 .3066 Mdot
.13485 .30419 Mdot
.13491 .30177 Mdot
.13497 .29936 Mdot
.13503 .30419 Mdot
.13509 .3066 Mdot
.13515 .3066 Mdot
.13521 .31143 Mdot
.13527 .31385 Mdot
.13533 .31626 Mdot
.13539 .31385 Mdot
.13545 .31385 Mdot
.13551 .31385 Mdot
.13557 .30902 Mdot
.13563 .3066 Mdot
.13569 .30419 Mdot
.13575 .30177 Mdot
.13581 .29936 Mdot
.13587 .30419 Mdot
.13593 .3066 Mdot
.13599 .3066 Mdot
.13605 .30902 Mdot
.13611 .31385 Mdot
.13617 .31626 Mdot
.13623 .31385 Mdot
.13629 .31385 Mdot
.13635 .31385 Mdot
.13641 .30902 Mdot
.13647 .3066 Mdot
.13653 .30419 Mdot
.13659 .30177 Mdot
.13665 .29936 Mdot
.13671 .30177 Mdot
.13677 .3066 Mdot
.13683 .3066 Mdot
.13689 .30902 Mdot
.13695 .31385 Mdot
.13701 .31626 Mdot
.13707 .31385 Mdot
.13713 .31385 Mdot
.13719 .31385 Mdot
.13725 .30902 Mdot
.13731 .3066 Mdot
.13737 .30419 Mdot
.13743 .30177 Mdot
.13749 .30177 Mdot
.13755 .30177 Mdot
.13761 .3066 Mdot
.13767 .3066 Mdot
.13773 .30902 Mdot
.13779 .31385 Mdot
.13785 .31626 Mdot
.13791 .31385 Mdot
.13797 .31385 Mdot
.13803 .31385 Mdot
.13809 .30902 Mdot
.13815 .3066 Mdot
.13821 .30419 Mdot
.13827 .30419 Mdot
.13833 .30177 Mdot
.13839 .30177 Mdot
.13845 .3066 Mdot
.13851 .3066 Mdot
.13857 .30902 Mdot
.13863 .31385 Mdot
.13869 .31385 Mdot
.13875 .31385 Mdot
.13881 .31385 Mdot
.13887 .31385 Mdot
.13893 .31143 Mdot
.13899 .3066 Mdot
.13905 .3066 Mdot
.13911 .30419 Mdot
.13917 .30177 Mdot
.13923 .30177 Mdot
.13929 .30419 Mdot
.13935 .3066 Mdot
.13941 .30902 Mdot
.13947 .31143 Mdot
.13953 .31385 Mdot
.13959 .31385 Mdot
.13965 .31385 Mdot
.13971 .31385 Mdot
.13977 .31143 Mdot
.13983 .3066 Mdot
.13989 .3066 Mdot
.13995 .30419 Mdot
.14001 .30177 Mdot
.14007 .30177 Mdot
.14013 .30419 Mdot
.14019 .3066 Mdot
.14025 .30902 Mdot
.14031 .31143 Mdot
.14037 .31385 Mdot
.14043 .31385 Mdot
.14049 .31385 Mdot
.14055 .31385 Mdot
.14061 .31143 Mdot
.14067 .3066 Mdot
.14073 .3066 Mdot
.14079 .30419 Mdot
.14085 .30177 Mdot
.14091 .30177 Mdot
.14097 .30419 Mdot
.14103 .3066 Mdot
.14109 .30902 Mdot
.14115 .31143 Mdot
.14121 .31385 Mdot
.14127 .31385 Mdot
.14133 .31385 Mdot
.14139 .31385 Mdot
.14145 .31143 Mdot
.14151 .3066 Mdot
.14157 .3066 Mdot
.14163 .30419 Mdot
.14169 .30177 Mdot
.14175 .30177 Mdot
.14181 .30419 Mdot
.14187 .3066 Mdot
.14193 .30902 Mdot
.14199 .31143 Mdot
.14205 .31385 Mdot
.14211 .31385 Mdot
.14217 .31385 Mdot
.14223 .31385 Mdot
.14229 .31143 Mdot
.14235 .30902 Mdot
.14241 .3066 Mdot
.14247 .30419 Mdot
.14253 .30177 Mdot
.14259 .30177 Mdot
.14265 .30419 Mdot
.14271 .3066 Mdot
.14277 .3066 Mdot
.14283 .31143 Mdot
.14289 .31385 Mdot
.14295 .31385 Mdot
.14301 .31385 Mdot
.14307 .31385 Mdot
.14313 .31143 Mdot
.14319 .30902 Mdot
.14325 .3066 Mdot
.14331 .30419 Mdot
.14337 .30177 Mdot
.14343 .30177 Mdot
.14349 .30419 Mdot
.14355 .3066 Mdot
.14361 .3066 Mdot
.14367 .31143 Mdot
.14373 .31385 Mdot
.14379 .31385 Mdot
.14385 .31385 Mdot
.14391 .31867 Mdot
.14397 .32833 Mdot
.14403 .31143 Mdot
.14409 .28246 Mdot
.14415 .28246 Mdot
.14421 .2897 Mdot
.14427 .29212 Mdot
.14433 .30419 Mdot
.14439 .31867 Mdot
.14445 .31385 Mdot
.14451 .30902 Mdot
.14457 .31385 Mdot
.14463 .3235 Mdot
.14469 .32833 Mdot
.14475 .31867 Mdot
.14481 .3066 Mdot
.14487 .3066 Mdot
.14493 .31626 Mdot
.14499 .31385 Mdot
.14505 .29695 Mdot
.14511 .28246 Mdot
.14517 .29212 Mdot
.14523 .3066 Mdot
.14529 .30419 Mdot
.14535 .29453 Mdot
.14541 .29936 Mdot
.14547 .31626 Mdot
.14553 .32833 Mdot
.14559 .32109 Mdot
.14565 .30902 Mdot
.14571 .31143 Mdot
.14577 .32592 Mdot
.14583 .32833 Mdot
.14589 .30902 Mdot
.14595 .29453 Mdot
.14601 .3066 Mdot
.14607 .31867 Mdot
.14613 .31143 Mdot
.14619 .29453 Mdot
.14625 .2897 Mdot
.14631 .29936 Mdot
.14637 .31143 Mdot
.14643 .31143 Mdot
.14649 .29936 Mdot
.14655 .29695 Mdot
.14661 .30902 Mdot
.14667 .31385 Mdot
.14673 .3066 Mdot
.14679 .29936 Mdot
.14685 .31143 Mdot
.14691 .32833 Mdot
.14697 .32833 Mdot
.14703 .31867 Mdot
.14709 .31143 Mdot
.14715 .31626 Mdot
.14721 .3235 Mdot
.14727 .31626 Mdot
.14733 .29936 Mdot
.14739 .29212 Mdot
.14745 .29695 Mdot
.14751 .29936 Mdot
.14757 .2897 Mdot
.14763 .28246 Mdot
.14769 .29453 Mdot
.14775 .31143 Mdot
.14781 .31626 Mdot
.14787 .31143 Mdot
.14793 .31385 Mdot
.14799 .32592 Mdot
.14805 .33799 Mdot
.14811 .33557 Mdot
.14817 .31867 Mdot
.14823 .31143 Mdot
.14829 .31385 Mdot
.14835 .31385 Mdot
.14841 .30177 Mdot
.14847 .28729 Mdot
.14853 .28729 Mdot
.14859 .29936 Mdot
.14865 .30177 Mdot
.14871 .29212 Mdot
.14877 .29212 Mdot
.14883 .30419 Mdot
.14889 .32109 Mdot
.14895 .32109 Mdot
.14901 .31143 Mdot
.14907 .31143 Mdot
.14913 .32109 Mdot
.14919 .32833 Mdot
.14925 .32109 Mdot
.14931 .3066 Mdot
.14937 .3066 Mdot
.14943 .31626 Mdot
.14949 .31626 Mdot
.14955 .30419 Mdot
.14961 .29695 Mdot
.14967 .30177 Mdot
.14973 .30902 Mdot
.14979 .30419 Mdot
.14985 .29453 Mdot
.14991 .2897 Mdot
.14997 .29936 Mdot
.15003 .31143 Mdot
.15009 .3066 Mdot
.15015 .29936 Mdot
.15021 .3066 Mdot
.15027 .3235 Mdot
.15033 .32833 Mdot
.15039 .3235 Mdot
.15045 .31626 Mdot
.15051 .31867 Mdot
.15057 .32592 Mdot
.15063 .32109 Mdot
.15069 .3066 Mdot
.15075 .29453 Mdot
.15081 .29695 Mdot
.15087 .29936 Mdot
.15093 .29212 Mdot
.15099 .28246 Mdot
.15105 .28729 Mdot
.15111 .30177 Mdot
.15117 .31143 Mdot
.15123 .31143 Mdot
.15129 .31143 Mdot
.15135 .32109 Mdot
.15141 .33316 Mdot
.15147 .33316 Mdot
.15153 .3235 Mdot
.15159 .31385 Mdot
.15165 .31385 Mdot
.15171 .31626 Mdot
.15177 .3066 Mdot
.15183 .2897 Mdot
.15189 .28729 Mdot
.15195 .29695 Mdot
.15201 .30177 Mdot
.15207 .29453 Mdot
.15213 .29212 Mdot
.15219 .30177 Mdot
.15225 .31385 Mdot
.15231 .31867 Mdot
.15237 .31385 Mdot
.15243 .31143 Mdot
.15249 .31867 Mdot
.15255 .32592 Mdot
.15261 .32109 Mdot
.15267 .30902 Mdot
.15273 .3066 Mdot
.15279 .31385 Mdot
.15285 .31626 Mdot
.15291 .3066 Mdot
.15297 .29695 Mdot
.15303 .29936 Mdot
.15309 .3066 Mdot
.15315 .30419 Mdot
.15321 .29695 Mdot
.15327 .29212 Mdot
.15333 .29936 Mdot
.15339 .30902 Mdot
.15345 .30902 Mdot
.15351 .30419 Mdot
.15357 .3066 Mdot
.15363 .31867 Mdot
.15369 .32833 Mdot
.15375 .3235 Mdot
.15381 .31867 Mdot
.15387 .31867 Mdot
.15393 .3235 Mdot
.15399 .32109 Mdot
.15405 .30902 Mdot
.15411 .29695 Mdot
.15417 .29453 Mdot
.15423 .29695 Mdot
.15428 .29453 Mdot
.15434 .28488 Mdot
.1544 .28488 Mdot
.15446 .29936 Mdot
.15452 .31143 Mdot
.15458 .31143 Mdot
.15464 .31385 Mdot
.1547 .32109 Mdot
.15476 .33074 Mdot
.15482 .33557 Mdot
.15488 .32592 Mdot
.15494 .31626 Mdot
.155 .31385 Mdot
.15506 .31385 Mdot
.15512 .3066 Mdot
.15518 .29453 Mdot
.15524 .28729 Mdot
.1553 .29212 Mdot
.15536 .29936 Mdot
.15542 .29695 Mdot
.15548 .29453 Mdot
.15554 .29936 Mdot
.1556 .31143 Mdot
.15566 .31867 Mdot
.15572 .31626 Mdot
.15578 .31385 Mdot
.15584 .31626 Mdot
.1559 .3235 Mdot
.15596 .3235 Mdot
.15602 .31385 Mdot
.15608 .3066 Mdot
.15614 .31143 Mdot
.1562 .31626 Mdot
.15626 .30902 Mdot
.15632 .29936 Mdot
.15638 .29936 Mdot
.15644 .30419 Mdot
.1565 .30419 Mdot
.15656 .29936 Mdot
.15662 .29212 Mdot
.15668 .29453 Mdot
.15674 .30419 Mdot
.1568 .30902 Mdot
.15686 .30419 Mdot
.15692 .30419 Mdot
.15698 .31626 Mdot
.15704 .32592 Mdot
.1571 .32592 Mdot
.15716 .32109 Mdot
.15722 .32109 Mdot
.15728 .3235 Mdot
.15734 .3235 Mdot
.1574 .31385 Mdot
.15746 .30177 Mdot
.15752 .29453 Mdot
.15758 .29695 Mdot
.15764 .29453 Mdot
.1577 .28488 Mdot
.15776 .28246 Mdot
.15782 .29453 Mdot
.15788 .3066 Mdot
.15794 .30902 Mdot
.158 .30902 Mdot
.15806 .31626 Mdot
.15812 .32592 Mdot
.15818 .33316 Mdot
.15824 .32833 Mdot
.1583 .32109 Mdot
.15836 .31626 Mdot
.15842 .31867 Mdot
.15848 .31385 Mdot
.15854 .30177 Mdot
.1586 .29212 Mdot
.15866 .29212 Mdot
.15872 .29695 Mdot
.15878 .29695 Mdot
.15884 .29212 Mdot
.1589 .29453 Mdot
.15896 .30419 Mdot
.15902 .31385 Mdot
.15908 .31385 Mdot
.15914 .31143 Mdot
.1592 .31385 Mdot
.15926 .32109 Mdot
.15932 .3235 Mdot
.15938 .31626 Mdot
.15944 .30902 Mdot
.1595 .31385 Mdot
.15956 .31867 Mdot
.15962 .31385 Mdot
.15968 .3066 Mdot
.15974 .30177 Mdot
.1598 .3066 Mdot
.15986 .3066 Mdot
.15992 .30177 Mdot
.15998 .29453 Mdot
.16004 .29453 Mdot
.1601 .29936 Mdot
.16016 .30419 Mdot
.16022 .30177 Mdot
.16028 .29936 Mdot
.16034 .30902 Mdot
.1604 .32109 Mdot
.16046 .3235 Mdot
.16052 .32109 Mdot
.16058 .32109 Mdot
.16064 .3235 Mdot
.1607 .32592 Mdot
.16076 .31867 Mdot
.16082 .3066 Mdot
.16088 .29936 Mdot
.16094 .29936 Mdot
.161 .29936 Mdot
.16106 .2897 Mdot
.16112 .28488 Mdot
.16118 .2897 Mdot
.16124 .30177 Mdot
.1613 .3066 Mdot
.16136 .3066 Mdot
.16142 .31143 Mdot
.16148 .32109 Mdot
.16154 .32833 Mdot
.1616 .32833 Mdot
.16166 .32109 Mdot
.16172 .31626 Mdot
.16178 .31867 Mdot
.16184 .31626 Mdot
.1619 .3066 Mdot
.16196 .29453 Mdot
.16202 .29453 Mdot
.16208 .29936 Mdot
.16214 .29936 Mdot
.1622 .29453 Mdot
.16226 .29453 Mdot
.16232 .30177 Mdot
.16238 .31143 Mdot
.16244 .31385 Mdot
.1625 .30902 Mdot
.16256 .30902 Mdot
.16262 .31626 Mdot
.16268 .3235 Mdot
.16274 .31867 Mdot
.1628 .31143 Mdot
.16286 .31143 Mdot
.16292 .31626 Mdot
.16298 .31626 Mdot
.16304 .30902 Mdot
.1631 .30419 Mdot
.16316 .3066 Mdot
.16322 .30902 Mdot
.16328 .30419 Mdot
.16334 .29695 Mdot
.1634 .29453 Mdot
.16346 .29936 Mdot
.16352 .30419 Mdot
.16358 .30177 Mdot
.16364 .29936 Mdot
.1637 .30419 Mdot
.16376 .31626 Mdot
.16382 .3235 Mdot
.16388 .31867 Mdot
.16394 .31867 Mdot
.164 .32109 Mdot
.16406 .32592 Mdot
.16412 .32109 Mdot
.16418 .31143 Mdot
.16424 .30177 Mdot
.1643 .30177 Mdot
.16436 .30177 Mdot
.16442 .29453 Mdot
.16448 .28488 Mdot
.16454 .2897 Mdot
.1646 .29936 Mdot
.16466 .3066 Mdot
.16472 .3066 Mdot
.16478 .30902 Mdot
.16484 .31867 Mdot
.1649 .32592 Mdot
.16496 .32833 Mdot
.16502 .32109 Mdot
.16508 .31626 Mdot
.16514 .31626 Mdot
.1652 .31626 Mdot
.16526 .30902 Mdot
.16532 .29695 Mdot
.16538 .29453 Mdot
.16544 .29936 Mdot
.1655 .30177 Mdot
.16556 .29695 Mdot
.16562 .29695 Mdot
.16568 .30419 Mdot
.16574 .31143 Mdot
.1658 .31385 Mdot
.16586 .31143 Mdot
.16592 .30902 Mdot
.16598 .31385 Mdot
.16604 .31867 Mdot
.1661 .31626 Mdot
.16616 .30902 Mdot
.16622 .30902 Mdot
.16628 .31385 Mdot
.16634 .31626 Mdot
.1664 .31143 Mdot
.16646 .3066 Mdot
.16652 .3066 Mdot
.16658 .30902 Mdot
.16664 .30902 Mdot
.1667 .30177 Mdot
.16676 .29695 Mdot
.16682 .29936 Mdot
.16688 .30419 Mdot
.16694 .30419 Mdot
.167 .29936 Mdot
.16706 .30177 Mdot
.16712 .31143 Mdot
.16718 .31867 Mdot
.16724 .31867 Mdot
.1673 .31867 Mdot
.16736 .32109 Mdot
.16742 .3235 Mdot
.16748 .32109 Mdot
.16754 .31385 Mdot
.1676 .30419 Mdot
.16766 .30177 Mdot
.16772 .30177 Mdot
.16778 .29695 Mdot
.16784 .2897 Mdot
.1679 .2897 Mdot
.16796 .29695 Mdot
.16802 .30419 Mdot
.16808 .3066 Mdot
.16814 .3066 Mdot
.1682 .31385 Mdot
.16826 .3235 Mdot
.16832 .32592 Mdot
.16838 .3235 Mdot
.16844 .31867 Mdot
.1685 .31626 Mdot
.16856 .31626 Mdot
.16862 .31143 Mdot
.16868 .30177 Mdot
.16874 .29695 Mdot
.1688 .29936 Mdot
.16886 .30177 Mdot
.16892 .29936 Mdot
.16898 .29695 Mdot
.16904 .30177 Mdot
.1691 .30902 Mdot
.16916 .31143 Mdot
.16922 .31143 Mdot
.16928 .30902 Mdot
.16934 .31143 Mdot
.1694 .31626 Mdot
.16946 .31626 Mdot
.16952 .31143 Mdot
.16958 .30902 Mdot
.16964 .31385 Mdot
.1697 .31626 Mdot
.16976 .31385 Mdot
.16982 .30902 Mdot
.16988 .3066 Mdot
.16994 .30902 Mdot
.17 .30902 Mdot
.17006 .30419 Mdot
.17012 .29695 Mdot
.17018 .29695 Mdot
.17024 .30177 Mdot
.1703 .30419 Mdot
.17036 .29936 Mdot
.17042 .29936 Mdot
.17048 .30902 Mdot
.17054 .31626 Mdot
.1706 .31867 Mdot
.17066 .31626 Mdot
.17072 .31867 Mdot
.17078 .3235 Mdot
.17084 .3235 Mdot
.1709 .31626 Mdot
.17096 .30902 Mdot
.17102 .30419 Mdot
.17108 .30419 Mdot
.17114 .29936 Mdot
.1712 .29212 Mdot
.17126 .2897 Mdot
.17132 .29453 Mdot
.17138 .30177 Mdot
.17144 .3066 Mdot
.1715 .3066 Mdot
.17156 .31143 Mdot
.17162 .32109 Mdot
.17168 .32592 Mdot
.17174 .3235 Mdot
.1718 .31867 Mdot
.17186 .31626 Mdot
.17192 .31626 Mdot
.17198 .31385 Mdot
.17204 .30419 Mdot
.1721 .29695 Mdot
.17216 .29936 Mdot
.17222 .30177 Mdot
.17228 .30177 Mdot
.17234 .29695 Mdot
.1724 .29936 Mdot
.17246 .3066 Mdot
.17252 .31143 Mdot
.17258 .31143 Mdot
.17264 .30902 Mdot
.1727 .30902 Mdot
.17276 .31626 Mdot
.17282 .31626 Mdot
.17288 .31143 Mdot
.17294 .3066 Mdot
.173 .31143 Mdot
.17306 .31626 Mdot
.17312 .31385 Mdot
.17318 .30902 Mdot
.17324 .3066 Mdot
.1733 .31143 Mdot
.17336 .31143 Mdot
.17342 .3066 Mdot
.17348 .29936 Mdot
.17354 .29936 Mdot
.1736 .30177 Mdot
.17366 .30419 Mdot
.17372 .30177 Mdot
.17378 .29936 Mdot
.17384 .30419 Mdot
.1739 .31385 Mdot
.17396 .31626 Mdot
.17402 .31626 Mdot
.17408 .31867 Mdot
.17414 .32109 Mdot
.1742 .3235 Mdot
.17426 .31867 Mdot
.17432 .31143 Mdot
.17438 .30419 Mdot
.17444 .30419 Mdot
.1745 .30177 Mdot
.17456 .29453 Mdot
.17462 .2897 Mdot
.17468 .29212 Mdot
.17474 .30177 Mdot
.1748 .30419 Mdot
.17486 .3066 Mdot
.17492 .30902 Mdot
.17498 .31867 Mdot
.17504 .3235 Mdot
.1751 .3235 Mdot
.17516 .31867 Mdot
.17522 .31626 Mdot
.17528 .31626 Mdot
.17534 .31385 Mdot
.1754 .3066 Mdot
.17546 .29936 Mdot
.17552 .29695 Mdot
.17558 .30177 Mdot
.17564 .30177 Mdot
.1757 .29695 Mdot
.17576 .29936 Mdot
.17582 .3066 Mdot
.17588 .31143 Mdot
.17594 .31385 Mdot
.176 .30902 Mdot
.17606 .30902 Mdot
.17612 .31385 Mdot
.17618 .31626 Mdot
.17624 .31385 Mdot
.1763 .3066 Mdot
.17636 .30902 Mdot
.17642 .31385 Mdot
.17648 .31385 Mdot
.17654 .30902 Mdot
.1766 .3066 Mdot
.17666 .30902 Mdot
.17672 .31143 Mdot
.17678 .30902 Mdot
.17684 .30177 Mdot
.1769 .29936 Mdot
.17696 .30177 Mdot
.17702 .30419 Mdot
.17708 .30177 Mdot
.17714 .29936 Mdot
.1772 .30177 Mdot
.17726 .31143 Mdot
.17732 .31626 Mdot
.17738 .31626 Mdot
.17744 .31626 Mdot
.1775 .32109 Mdot
.17756 .3235 Mdot
.17762 .32109 Mdot
.17768 .31385 Mdot
.17774 .3066 Mdot
.1778 .30419 Mdot
.17786 .30419 Mdot
.17792 .29695 Mdot
.17798 .2897 Mdot
.17804 .2897 Mdot
.1781 .29936 Mdot
.17816 .30419 Mdot
.17822 .3066 Mdot
.17828 .30902 Mdot
.17834 .31626 Mdot
.1784 .3235 Mdot
.17846 .32592 Mdot
.17852 .32109 Mdot
.17858 .31626 Mdot
.17864 .31626 Mdot
.1787 .31626 Mdot
.17876 .30902 Mdot
.17882 .29936 Mdot
.17888 .29695 Mdot
.17894 .29936 Mdot
.179 .30177 Mdot
.17906 .29936 Mdot
.17912 .29936 Mdot
.17918 .30419 Mdot
.17924 .31143 Mdot
.1793 .31385 Mdot
.17936 .31143 Mdot
.17942 .30902 Mdot
.17948 .31143 Mdot
.17954 .31626 Mdot
.1796 .31385 Mdot
.17966 .30902 Mdot
.17972 .3066 Mdot
.17978 .31385 Mdot
.17984 .31626 Mdot
.1799 .31143 Mdot
.17996 .30902 Mdot
.18002 .30902 Mdot
.18008 .31143 Mdot
.18014 .31143 Mdot
.1802 .30419 Mdot
.18026 .29936 Mdot
.18032 .29936 Mdot
.18038 .30419 Mdot
.18044 .30177 Mdot
.1805 .29695 Mdot
.18056 .29936 Mdot
.18062 .30902 Mdot
.18068 .31626 Mdot
.18074 .31626 Mdot
.1808 .31626 Mdot
.18086 .32109 Mdot
.18092 .3235 Mdot
.18098 .3235 Mdot
.18104 .31626 Mdot
.1811 .30902 Mdot
.18116 .30419 Mdot
.18122 .30419 Mdot
.18128 .29936 Mdot
.18134 .2897 Mdot
.1814 .28729 Mdot
.18146 .29453 Mdot
.18152 .30419 Mdot
.18158 .30419 Mdot
.18164 .3066 Mdot
.1817 .31385 Mdot
.18176 .32109 Mdot
.18182 .32592 Mdot
.18188 .3235 Mdot
.18194 .31867 Mdot
.182 .31626 Mdot
.18206 .31626 Mdot
.18212 .31143 Mdot
.18218 .30177 Mdot
.18224 .29695 Mdot
.1823 .29936 Mdot
.18236 .30177 Mdot
.18242 .30177 Mdot
.18248 .29936 Mdot
.18254 .30177 Mdot
.1826 .30902 Mdot
.18266 .31385 Mdot
.18272 .31385 Mdot
.18278 .30902 Mdot
.18284 .30902 Mdot
.1829 .31385 Mdot
.18296 .31626 Mdot
.18302 .31143 Mdot
.18308 .3066 Mdot
.18314 .30902 Mdot
.1832 .31385 Mdot
.18326 .31385 Mdot
.18332 .30902 Mdot
.18338 .30902 Mdot
.18344 .31143 Mdot
.1835 .31143 Mdot
.18356 .30902 Mdot
.18362 .30177 Mdot
.18368 .29936 Mdot
.18374 .30177 Mdot
.1838 .30419 Mdot
.18386 .29936 Mdot
.18392 .29695 Mdot
.18398 .30419 Mdot
.18404 .31385 Mdot
.1841 .31626 Mdot
.18416 .31626 Mdot
.18422 .31867 Mdot
.18428 .3235 Mdot
.18434 .3235 Mdot
.1844 .32109 Mdot
.18446 .31143 Mdot
.18452 .30419 Mdot
.18458 .30419 Mdot
.18464 .30177 Mdot
.1847 .29453 Mdot
.18476 .28729 Mdot
.18482 .29212 Mdot
.18488 .29936 Mdot
.18494 .30419 Mdot
.185 .3066 Mdot
.18506 .31143 Mdot
.18512 .31626 Mdot
.18518 .3235 Mdot
.18524 .32592 Mdot
.1853 .32109 Mdot
.18536 .31626 Mdot
.18542 .31626 Mdot
.18548 .31626 Mdot
.18554 .3066 Mdot
.1856 .29936 Mdot
.18566 .29695 Mdot
.18572 .30177 Mdot
.18578 .30177 Mdot
.18584 .29936 Mdot
.1859 .29936 Mdot
.18596 .30419 Mdot
.18602 .31143 Mdot
.18608 .31385 Mdot
.18614 .31143 Mdot
.1862 .30902 Mdot
.18626 .31143 Mdot
.18632 .31626 Mdot
.18638 .31143 Mdot
.18644 .3066 Mdot
.1865 .30902 Mdot
.18656 .31385 Mdot
.18662 .31626 Mdot
.18668 .31143 Mdot
.18674 .30902 Mdot
.1868 .31143 Mdot
.18686 .31385 Mdot
.18692 .31143 Mdot
.18698 .30419 Mdot
.18704 .29695 Mdot
.1871 .29936 Mdot
.18716 .30177 Mdot
.18722 .30177 Mdot
.18728 .29695 Mdot
.18734 .29936 Mdot
.1874 .30902 Mdot
.18746 .31626 Mdot
.18752 .31867 Mdot
.18758 .31867 Mdot
.18764 .32109 Mdot
.1877 .32592 Mdot
.18776 .3235 Mdot
.18782 .31626 Mdot
.18788 .3066 Mdot
.18794 .30419 Mdot
.188 .30419 Mdot
.18806 .29695 Mdot
.18812 .2897 Mdot
.18818 .2897 Mdot
.18824 .29695 Mdot
.1883 .30419 Mdot
.18836 .3066 Mdot
.18842 .30902 Mdot
.18848 .31385 Mdot
.18854 .3235 Mdot
.1886 .32592 Mdot
.18866 .3235 Mdot
.18872 .31626 Mdot
.18878 .31626 Mdot
.18884 .31626 Mdot
.1889 .30902 Mdot
.18896 .29936 Mdot
.18902 .29695 Mdot
.18908 .30177 Mdot
.18914 .30177 Mdot
.1892 .30177 Mdot
.18926 .29936 Mdot
.18932 .30419 Mdot
.18938 .30902 Mdot
.18944 .31385 Mdot
.1895 .31143 Mdot
.18956 .30902 Mdot
.18962 .30902 Mdot
.18968 .31385 Mdot
.18974 .31385 Mdot
.1898 .30902 Mdot
.18986 .3066 Mdot
.18992 .31143 Mdot
.18998 .31626 Mdot
.19004 .31385 Mdot
.1901 .30902 Mdot
.19016 .30902 Mdot
.19022 .31143 Mdot
.19028 .31143 Mdot
.19034 .3066 Mdot
.1904 .29936 Mdot
.19046 .29695 Mdot
.19052 .30177 Mdot
.19058 .30177 Mdot
.19064 .29695 Mdot
.1907 .29936 Mdot
.19076 .3066 Mdot
.19082 .31626 Mdot
.19088 .31867 Mdot
.19094 .31867 Mdot
.191 .32109 Mdot
.19106 .3235 Mdot
.19112 .32592 Mdot
.19118 .31867 Mdot
.19124 .30902 Mdot
.1913 .30419 Mdot
.19136 .30419 Mdot
.19142 .29936 Mdot
.19148 .2897 Mdot
.19154 .28729 Mdot
.1916 .29453 Mdot
.19166 .30177 Mdot
.19172 .3066 Mdot
.19178 .3066 Mdot
.19184 .31143 Mdot
.1919 .32109 Mdot
.19196 .32592 Mdot
.19202 .3235 Mdot
.19208 .31867 Mdot
.19214 .31626 Mdot
.1922 .31626 Mdot
.19226 .31143 Mdot
.19232 .30177 Mdot
.19238 .29695 Mdot
.19244 .29936 Mdot
.1925 .30177 Mdot
.19256 .30177 Mdot
.19262 .29936 Mdot
.19268 .30177 Mdot
.19274 .3066 Mdot
.1928 .31385 Mdot
.19286 .31385 Mdot
.19292 .30902 Mdot
.19298 .30902 Mdot
.19304 .31385 Mdot
.1931 .31385 Mdot
.19316 .30902 Mdot
.19322 .3066 Mdot
.19328 .31143 Mdot
.19334 .31626 Mdot
.1934 .31385 Mdot
.19346 .31143 Mdot
.19352 .30902 Mdot
.19358 .31143 Mdot
.19364 .31143 Mdot
.1937 .30902 Mdot
.19376 .29936 Mdot
.19382 .29695 Mdot
.19388 .29936 Mdot
.19394 .30177 Mdot
.194 .29936 Mdot
.19406 .29695 Mdot
.19412 .30419 Mdot
.19418 .31385 Mdot
.19424 .31867 Mdot
.1943 .31867 Mdot
.19436 .32109 Mdot
.19442 .3235 Mdot
.19448 .32592 Mdot
.19454 .32109 Mdot
.1946 .31143 Mdot
.19466 .30419 Mdot
.19472 .30177 Mdot
.19478 .30177 Mdot
.19484 .29212 Mdot
.1949 .28729 Mdot
.19496 .29212 Mdot
.19502 .29936 Mdot
.19508 .30419 Mdot
.19514 .3066 Mdot
.1952 .31143 Mdot
.19526 .31867 Mdot
.19532 .32592 Mdot
.19538 .32592 Mdot
.19544 .31867 Mdot
.1955 .31385 Mdot
.19556 .31626 Mdot
.19562 .31385 Mdot
.19568 .3066 Mdot
.19574 .29936 Mdot
.1958 .29936 Mdot
.19586 .30177 Mdot
.19592 .30177 Mdot
.19598 .29936 Mdot
.19604 .29936 Mdot
.1961 .30419 Mdot
.19616 .31143 Mdot
.19622 .31385 Mdot
.19628 .30902 Mdot
.19634 .3066 Mdot
.1964 .31143 Mdot
.19646 .31385 Mdot
.19652 .31143 Mdot
.19658 .3066 Mdot
.19664 .30902 Mdot
.1967 .31385 Mdot
.19676 .31626 Mdot
.19682 .31385 Mdot
.19688 .30902 Mdot
.19694 .31143 Mdot
.197 .31385 Mdot
.19706 .30902 Mdot
.19712 .30177 Mdot
.19718 .29695 Mdot
.19724 .29936 Mdot
.1973 .30177 Mdot
.19736 .29936 Mdot
.19742 .29695 Mdot
.19748 .30177 Mdot
.19754 .31143 Mdot
.1976 .31867 Mdot
.19766 .31867 Mdot
.19772 .31867 Mdot
.19778 .32109 Mdot
.19784 .32592 Mdot
.1979 .3235 Mdot
.19796 .31385 Mdot
.19802 .3066 Mdot
.19808 .30419 Mdot
.19814 .30177 Mdot
.1982 .29695 Mdot
.19826 .2897 Mdot
.19832 .2897 Mdot
.19838 .29695 Mdot
.19844 .30419 Mdot
.1985 .3066 Mdot
.19856 .30902 Mdot
.19862 .31626 Mdot
.19868 .3235 Mdot
.19874 .32592 Mdot
.1988 .32109 Mdot
.19886 .31626 Mdot
.19892 .31626 Mdot
.19898 .31626 Mdot
.19904 .30902 Mdot
.1991 .29936 Mdot
.19916 .29695 Mdot
.19922 .30177 Mdot
.19928 .30419 Mdot
.19934 .30177 Mdot
.1994 .29936 Mdot
.19946 .30177 Mdot
.19952 .30902 Mdot
.19958 .31385 Mdot
.19964 .31143 Mdot
.1997 .3066 Mdot
.19976 .30902 Mdot
.19982 .31385 Mdot
.19988 .31385 Mdot
.19994 .30902 Mdot
.2 .30902 Mdot
.20006 .31385 Mdot
.20012 .31626 Mdot
.20018 .31385 Mdot
.20024 .30902 Mdot
.2003 .30902 Mdot
.20036 .31143 Mdot
.20042 .31143 Mdot
.20048 .30419 Mdot
.20054 .29695 Mdot
.2006 .29695 Mdot
.20066 .30177 Mdot
.20072 .30177 Mdot
.20078 .29695 Mdot
.20084 .29936 Mdot
.2009 .30902 Mdot
.20096 .31626 Mdot
.20102 .31867 Mdot
.20108 .31867 Mdot
.20114 .32109 Mdot
.2012 .32592 Mdot
.20126 .32592 Mdot
.20132 .31626 Mdot
.20138 .3066 Mdot
.20144 .30419 Mdot
.2015 .30177 Mdot
.20156 .29695 Mdot
.20162 .2897 Mdot
.20168 .28729 Mdot
.20174 .29453 Mdot
.2018 .30177 Mdot
.20186 .3066 Mdot
.20192 .30902 Mdot
.20198 .31385 Mdot
.20204 .32109 Mdot
.2021 .32592 Mdot
.20216 .3235 Mdot
.20222 .31867 Mdot
.20228 .31626 Mdot
.20234 .31626 Mdot
.2024 .31143 Mdot
.20246 .30177 Mdot
.20252 .29695 Mdot
.20258 .29936 Mdot
.20264 .30177 Mdot
.2027 .30177 Mdot
.20276 .29936 Mdot
.20282 .30177 Mdot
.20288 .30902 Mdot
.20294 .31385 Mdot
.203 .31143 Mdot
.20306 .3066 Mdot
.20312 .30902 Mdot
.20318 .31385 Mdot
.20324 .31385 Mdot
.2033 .30902 Mdot
.20336 .3066 Mdot
.20342 .31143 Mdot
.20348 .31626 Mdot
.20354 .31626 Mdot
.2036 .31143 Mdot
.20366 .30902 Mdot
.20372 .31143 Mdot
.20378 .31143 Mdot
.20384 .3066 Mdot
.2039 .29936 Mdot
.20396 .29695 Mdot
.20402 .29936 Mdot
.20408 .30177 Mdot
.20414 .29695 Mdot
.2042 .29695 Mdot
.20426 .30419 Mdot
.20432 .31385 Mdot
.20438 .31867 Mdot
.20444 .31867 Mdot
.2045 .32109 Mdot
.20456 .32592 Mdot
.20462 .32592 Mdot
.20468 .32109 Mdot
.20474 .30902 Mdot
.2048 .30419 Mdot
.20486 .30419 Mdot
.20492 .29936 Mdot
.20498 .29212 Mdot
.20504 .28729 Mdot
.2051 .29212 Mdot
.20516 .29936 Mdot
.20522 .3066 Mdot
.20528 .3066 Mdot
.20534 .31143 Mdot
.2054 .31867 Mdot
.20546 .32592 Mdot
.20552 .32592 Mdot
.20558 .31867 Mdot
.20564 .31626 Mdot
.2057 .31626 Mdot
.20576 .31385 Mdot
.20582 .3066 Mdot
.20588 .29695 Mdot
.20594 .29695 Mdot
.206 .30177 Mdot
.20606 .30177 Mdot
.20612 .29936 Mdot
.20618 .29936 Mdot
.20624 .30419 Mdot
.2063 .31143 Mdot
.20636 .31385 Mdot
.20642 .30902 Mdot
.20648 .3066 Mdot
.20654 .31143 Mdot
.2066 .31626 Mdot
.20666 .31143 Mdot
.20672 .3066 Mdot
.20678 .30902 Mdot
.20684 .31626 Mdot
.2069 .31626 Mdot
.20696 .31385 Mdot
.20702 .30902 Mdot
.20708 .31143 Mdot
.20714 .31385 Mdot
.2072 .30902 Mdot
.20726 .30177 Mdot
.20732 .29453 Mdot
.20738 .29695 Mdot
.20744 .30177 Mdot
.20749 .29936 Mdot
.20755 .29453 Mdot
.20761 .30177 Mdot
.20767 .31143 Mdot
.20773 .31867 Mdot
.20779 .31867 Mdot
.20785 .32109 Mdot
.20791 .3235 Mdot
.20797 .32833 Mdot
.20803 .3235 Mdot
.20809 .31385 Mdot
.20815 .30419 Mdot
.20821 .30177 Mdot
.20827 .30177 Mdot
.20833 .29453 Mdot
.20839 .28729 Mdot
.20845 .28729 Mdot
.20851 .29695 Mdot
.20857 .30419 Mdot
.20863 .3066 Mdot
.20869 .30902 Mdot
.20875 .31626 Mdot
.20881 .32592 Mdot
.20887 .32833 Mdot
.20893 .3235 Mdot
.20899 .31626 Mdot
.20905 .31626 Mdot
.20911 .31626 Mdot
.20917 .30902 Mdot
.20923 .29936 Mdot
.20929 .29695 Mdot
.20935 .29936 Mdot
.20941 .30177 Mdot
.20947 .29936 Mdot
.20953 .29936 Mdot
.20959 .30419 Mdot
.20965 .31143 Mdot
.20971 .31385 Mdot
.20977 .31143 Mdot
.20983 .3066 Mdot
.20989 .30902 Mdot
.20995 .31385 Mdot
.21001 .31385 Mdot
.21007 .30902 Mdot
.21013 .30902 Mdot
.21019 .31385 Mdot
.21025 .31626 Mdot
.21031 .31385 Mdot
.21037 .31143 Mdot
.21043 .31143 Mdot
.21049 .31385 Mdot
.21055 .31143 Mdot
.21061 .30419 Mdot
.21067 .29695 Mdot
.21073 .29453 Mdot
.21079 .30419 Mdot
.21085 .29936 Mdot
.21091 .29212 Mdot
.21097 .33316 Mdot
.21103 .3404 Mdot
.21109 .27522 Mdot
.21115 .26315 Mdot
.21121 .29695 Mdot
.21127 .30177 Mdot
.21133 .30419 Mdot
.21139 .33316 Mdot
.21145 .34523 Mdot
.21151 .3235 Mdot
.21157 .29695 Mdot
.21163 .29453 Mdot
.21169 .3066 Mdot
.21175 .31867 Mdot
.21181 .31143 Mdot
.21187 .29212 Mdot
.21193 .28488 Mdot
.21199 .30177 Mdot
.21205 .32833 Mdot
.21211 .33799 Mdot
.21217 .3235 Mdot
.21223 .29453 Mdot
.21229 .28729 Mdot
.21235 .3066 Mdot
.21241 .3235 Mdot
.21247 .31143 Mdot
.21253 .27763 Mdot
.21259 .26798 Mdot
.21265 .29453 Mdot
.21271 .32833 Mdot
.21277 .32833 Mdot
.21283 .29936 Mdot
.21289 .28488 Mdot
.21295 .31385 Mdot
.21301 .35489 Mdot
.21307 .35972 Mdot
.21313 .3235 Mdot
.21319 .2897 Mdot
.21325 .30419 Mdot
.21331 .33799 Mdot
.21337 .3404 Mdot
.21343 .3066 Mdot
.21349 .26798 Mdot
.21355 .26556 Mdot
.21361 .2897 Mdot
.21367 .31867 Mdot
.21373 .31385 Mdot
.21379 .28729 Mdot
.21385 .28246 Mdot
.21391 .30177 Mdot
.21397 .32592 Mdot
.21403 .31626 Mdot
.21409 .29453 Mdot
.21415 .29212 Mdot
.21421 .31385 Mdot
.21427 .3404 Mdot
.21433 .34764 Mdot
.21439 .33074 Mdot
.21445 .31143 Mdot
.21451 .31626 Mdot
.21457 .33557 Mdot
.21463 .34523 Mdot
.21469 .32833 Mdot
.21475 .29936 Mdot
.21481 .28488 Mdot
.21487 .2897 Mdot
.21493 .29695 Mdot
.21499 .28488 Mdot
.21505 .26073 Mdot
.21511 .25349 Mdot
.21517 .2728 Mdot
.21523 .3066 Mdot
.21529 .32109 Mdot
.21535 .30902 Mdot
.21541 .29936 Mdot
.21547 .3235 Mdot
.21553 .36213 Mdot
.21559 .37903 Mdot
.21565 .3573 Mdot
.21571 .3235 Mdot
.21577 .31626 Mdot
.21583 .33316 Mdot
.21589 .33799 Mdot
.21595 .3066 Mdot
.21601 .2728 Mdot
.21607 .26073 Mdot
.21613 .28246 Mdot
.21619 .29936 Mdot
.21625 .28729 Mdot
.21631 .26315 Mdot
.21637 .25832 Mdot
.21643 .2897 Mdot
.21649 .3235 Mdot
.21655 .32833 Mdot
.21661 .3066 Mdot
.21667 .29936 Mdot
.21673 .3235 Mdot
.21679 .35006 Mdot
.21685 .35972 Mdot
.21691 .34282 Mdot
.21697 .3235 Mdot
.21703 .3235 Mdot
.21709 .33799 Mdot
.21715 .34282 Mdot
.21721 .32109 Mdot
.21727 .29212 Mdot
.21733 .27522 Mdot
.21739 .28246 Mdot
.21745 .28729 Mdot
.21751 .28005 Mdot
.21757 .25832 Mdot
.21763 .24866 Mdot
.21769 .27039 Mdot
.21775 .3066 Mdot
.21781 .32833 Mdot
.21787 .31867 Mdot
.21793 .31143 Mdot
.21799 .32833 Mdot
.21805 .36213 Mdot
.21811 .37661 Mdot
.21817 .35972 Mdot
.21823 .32833 Mdot
.21829 .30902 Mdot
.21835 .32109 Mdot
.21841 .33074 Mdot
.21847 .30419 Mdot
.21853 .26798 Mdot
.21859 .2559 Mdot
.21865 .27522 Mdot
.21871 .29453 Mdot
.21877 .29212 Mdot
.21883 .2728 Mdot
.21889 .27039 Mdot
.21895 .29936 Mdot
.21901 .33074 Mdot
.21907 .33557 Mdot
.21913 .31867 Mdot
.21919 .3066 Mdot
.21925 .31867 Mdot
.21931 .34282 Mdot
.21937 .34764 Mdot
.21943 .33074 Mdot
.21949 .30902 Mdot
.21955 .30902 Mdot
.21961 .3235 Mdot
.21967 .32592 Mdot
.21973 .31143 Mdot
.21979 .28729 Mdot
.21985 .28005 Mdot
.21991 .28729 Mdot
.21997 .29695 Mdot
.22003 .29453 Mdot
.22009 .27763 Mdot
.22015 .26798 Mdot
.22021 .28005 Mdot
.22027 .31143 Mdot
.22033 .32592 Mdot
.22039 .31867 Mdot
.22045 .31143 Mdot
.22051 .32109 Mdot
.22057 .34523 Mdot
.22063 .35972 Mdot
.22069 .34523 Mdot
.22075 .31385 Mdot
.22081 .29936 Mdot
.22087 .31385 Mdot
.22093 .32592 Mdot
.22099 .3066 Mdot
.22105 .2728 Mdot
.22111 .26315 Mdot
.22117 .28246 Mdot
.22123 .30419 Mdot
.22129 .30419 Mdot
.22135 .28729 Mdot
.22141 .28246 Mdot
.22147 .30177 Mdot
.22153 .32833 Mdot
.22159 .33316 Mdot
.22165 .31385 Mdot
.22171 .29936 Mdot
.22177 .31143 Mdot
.22183 .33074 Mdot
.22189 .33557 Mdot
.22195 .3235 Mdot
.22201 .3066 Mdot
.22207 .30902 Mdot
.22213 .32592 Mdot
.22219 .33557 Mdot
.22225 .3235 Mdot
.22231 .30177 Mdot
.22237 .29212 Mdot
.22243 .29453 Mdot
.22249 .30177 Mdot
.22255 .29695 Mdot
.22261 .28005 Mdot
.22267 .26556 Mdot
.22273 .27522 Mdot
.22279 .29936 Mdot
.22285 .31385 Mdot
.22291 .30902 Mdot
.22297 .30177 Mdot
.22303 .31143 Mdot
.22309 .33799 Mdot
.22315 .3573 Mdot
.22321 .35006 Mdot
.22327 .32592 Mdot
.22333 .31385 Mdot
.22339 .3235 Mdot
.22345 .33316 Mdot
.22351 .32109 Mdot
.22357 .2897 Mdot
.22363 .27522 Mdot
.22369 .28488 Mdot
.22375 .30177 Mdot
.22381 .30177 Mdot
.22387 .28246 Mdot
.22393 .27039 Mdot
.22399 .28488 Mdot
.22405 .31143 Mdot
.22411 .31867 Mdot
.22417 .30419 Mdot
.22423 .29212 Mdot
.22429 .3066 Mdot
.22435 .33074 Mdot
.22441 .34282 Mdot
.22447 .33316 Mdot
.22453 .3235 Mdot
.22459 .3235 Mdot
.22465 .3404 Mdot
.22471 .34764 Mdot
.22477 .33557 Mdot
.22483 .30902 Mdot
.22489 .29453 Mdot
.22495 .29453 Mdot
.22501 .29453 Mdot
.22507 .28246 Mdot
.22513 .26315 Mdot
.22519 .25108 Mdot
.22525 .2559 Mdot
.22531 .28005 Mdot
.22537 .29936 Mdot
.22543 .30419 Mdot
.22549 .30419 Mdot
.22555 .31626 Mdot
.22561 .34523 Mdot
.22567 .36937 Mdot
.22573 .36696 Mdot
.22579 .34764 Mdot
.22585 .33316 Mdot
.22591 .33799 Mdot
.22597 .34282 Mdot
.22603 .32833 Mdot
.22609 .29212 Mdot
.22615 .26798 Mdot
.22621 .27039 Mdot
.22627 .28488 Mdot
.22633 .28246 Mdot
.22639 .26556 Mdot
.22645 .25349 Mdot
.22651 .26798 Mdot
.22657 .30177 Mdot
.22663 .31867 Mdot
.22669 .30902 Mdot
.22675 .30177 Mdot
.22681 .31385 Mdot
.22687 .34282 Mdot
.22693 .35489 Mdot
.22699 .34764 Mdot
.22705 .33316 Mdot
.22711 .33074 Mdot
.22717 .3404 Mdot
.22723 .34764 Mdot
.22729 .33316 Mdot
.22735 .30419 Mdot
.22741 .28729 Mdot
.22747 .28488 Mdot
.22753 .28488 Mdot
.22759 .27522 Mdot
.22765 .26073 Mdot
.22771 .25108 Mdot
.22777 .25832 Mdot
.22783 .28005 Mdot
.22789 .30419 Mdot
.22795 .31143 Mdot
.22801 .31143 Mdot
.22807 .3235 Mdot
.22813 .35006 Mdot
.22819 .36696 Mdot
.22825 .36696 Mdot
.22831 .34764 Mdot
.22837 .32833 Mdot
.22843 .32833 Mdot
.22849 .33316 Mdot
.22855 .32109 Mdot
.22861 .2897 Mdot
.22867 .26315 Mdot
.22873 .26315 Mdot
.22879 .28246 Mdot
.22885 .2897 Mdot
.22891 .27763 Mdot
.22897 .26556 Mdot
.22903 .28005 Mdot
.22909 .30902 Mdot
.22915 .32833 Mdot
.22921 .32109 Mdot
.22927 .3066 Mdot
.22933 .31385 Mdot
.22939 .33557 Mdot
.22945 .34764 Mdot
.22951 .33799 Mdot
.22957 .31867 Mdot
.22963 .31385 Mdot
.22969 .3235 Mdot
.22975 .33316 Mdot
.22981 .32592 Mdot
.22987 .30419 Mdot
.22993 .2897 Mdot
.22999 .29212 Mdot
.23005 .29695 Mdot
.23011 .29212 Mdot
.23017 .27763 Mdot
.23023 .26798 Mdot
.23029 .2728 Mdot
.23035 .29212 Mdot
.23041 .30902 Mdot
.23047 .31143 Mdot
.23053 .3066 Mdot
.23059 .31385 Mdot
.23065 .33316 Mdot
.23071 .35006 Mdot
.23077 .35247 Mdot
.23083 .33557 Mdot
.23089 .31626 Mdot
.23095 .31626 Mdot
.23101 .32592 Mdot
.23107 .3235 Mdot
.23113 .29936 Mdot
.23119 .27522 Mdot
.23125 .27763 Mdot
.23131 .29695 Mdot
.23137 .3066 Mdot
.23143 .29453 Mdot
.23149 .28005 Mdot
.23155 .28488 Mdot
.23161 .31143 Mdot
.23167 .32833 Mdot
.23173 .31626 Mdot
.23179 .29453 Mdot
.23185 .29453 Mdot
.23191 .31626 Mdot
.23197 .33316 Mdot
.23203 .32592 Mdot
.23209 .30902 Mdot
.23215 .3066 Mdot
.23221 .32109 Mdot
.23227 .33557 Mdot
.23233 .33557 Mdot
.23239 .31867 Mdot
.23245 .30419 Mdot
.23251 .3066 Mdot
.23257 .31385 Mdot
.23263 .30902 Mdot
.23269 .2897 Mdot
.23275 .2728 Mdot
.23281 .27039 Mdot
.23287 .28488 Mdot
.23293 .29695 Mdot
.23299 .29695 Mdot
.23305 .29212 Mdot
.23311 .29695 Mdot
.23317 .31626 Mdot
.23323 .33799 Mdot
.23329 .34523 Mdot
.23335 .33557 Mdot
.23341 .32109 Mdot
.23347 .3235 Mdot
.23353 .33557 Mdot
.23359 .33557 Mdot
.23365 .31626 Mdot
.23371 .29212 Mdot
.23377 .2897 Mdot
.23383 .30419 Mdot
.23389 .30902 Mdot
.23395 .29695 Mdot
.23401 .27763 Mdot
.23407 .27522 Mdot
.23413 .29695 Mdot
.23419 .31385 Mdot
.23425 .3066 Mdot
.23431 .28488 Mdot
.23437 .28488 Mdot
.23443 .30902 Mdot
.23449 .32833 Mdot
.23455 .32833 Mdot
.23461 .31626 Mdot
.23467 .31626 Mdot
.23473 .33074 Mdot
.23479 .35006 Mdot
.23485 .34764 Mdot
.23491 .33074 Mdot
.23497 .31385 Mdot
.23503 .31143 Mdot
.23509 .31385 Mdot
.23515 .30177 Mdot
.23521 .28246 Mdot
.23527 .26556 Mdot
.23533 .26315 Mdot
.23539 .27039 Mdot
.23545 .28488 Mdot
.23551 .2897 Mdot
.23557 .29212 Mdot
.23563 .29936 Mdot
.23569 .31867 Mdot
.23575 .3404 Mdot
.23581 .35247 Mdot
.23587 .34764 Mdot
.23593 .33799 Mdot
.23599 .33557 Mdot
.23605 .3404 Mdot
.23611 .33799 Mdot
.23617 .31867 Mdot
.23623 .29212 Mdot
.23629 .28005 Mdot
.23635 .2897 Mdot
.23641 .29453 Mdot
.23647 .28488 Mdot
.23653 .27039 Mdot
.23659 .26798 Mdot
.23665 .2897 Mdot
.23671 .31143 Mdot
.23677 .31143 Mdot
.23683 .29936 Mdot
.23689 .29695 Mdot
.23695 .31867 Mdot
.23701 .33799 Mdot
.23707 .3404 Mdot
.23713 .32833 Mdot
.23719 .3235 Mdot
.23725 .33316 Mdot
.23731 .34523 Mdot
.23737 .3404 Mdot
.23743 .32109 Mdot
.23749 .30177 Mdot
.23755 .29936 Mdot
.23761 .30177 Mdot
.23767 .29212 Mdot
.23773 .27522 Mdot
.23779 .26315 Mdot
.23785 .26315 Mdot
.23791 .27522 Mdot
.23797 .29212 Mdot
.23803 .29936 Mdot
.23809 .30419 Mdot
.23815 .31143 Mdot
.23821 .33074 Mdot
.23827 .34764 Mdot
.23833 .35489 Mdot
.23839 .35006 Mdot
.23845 .33799 Mdot
.23851 .32833 Mdot
.23857 .32833 Mdot
.23863 .3235 Mdot
.23869 .3066 Mdot
.23875 .28246 Mdot
.23881 .27039 Mdot
.23887 .28005 Mdot
.23893 .2897 Mdot
.23899 .2897 Mdot
.23905 .27763 Mdot
.23911 .28005 Mdot
.23917 .29936 Mdot
.23923 .32109 Mdot
.23929 .32592 Mdot
.23935 .31385 Mdot
.23941 .3066 Mdot
.23947 .31867 Mdot
.23953 .33799 Mdot
.23959 .33557 Mdot
.23965 .32109 Mdot
.23971 .30902 Mdot
.23977 .31626 Mdot
.23983 .32833 Mdot
.23989 .32833 Mdot
.23995 .31143 Mdot
.24001 .29695 Mdot
.24007 .29695 Mdot
.24013 .30419 Mdot
.24019 .30177 Mdot
.24025 .2897 Mdot
.24031 .27763 Mdot
.24037 .27763 Mdot
.24043 .2897 Mdot
.24049 .30419 Mdot
.24055 .3066 Mdot
.24061 .3066 Mdot
.24067 .30902 Mdot
.24073 .3235 Mdot
.24079 .33557 Mdot
.24085 .3404 Mdot
.24091 .33557 Mdot
.24097 .3235 Mdot
.24103 .31626 Mdot
.24109 .31626 Mdot
.24115 .31867 Mdot
.24121 .30902 Mdot
.24127 .2897 Mdot
.24133 .28246 Mdot
.24139 .29212 Mdot
.24145 .30419 Mdot
.24151 .30419 Mdot
.24157 .29453 Mdot
.24163 .2897 Mdot
.24169 .30419 Mdot
.24175 .3235 Mdot
.24181 .32592 Mdot
.24187 .30902 Mdot
.24193 .29695 Mdot
.24199 .30419 Mdot
.24205 .32109 Mdot
.24211 .32109 Mdot
.24217 .3066 Mdot
.24223 .29936 Mdot
.24229 .3066 Mdot
.24235 .32592 Mdot
.24241 .33316 Mdot
.24247 .3235 Mdot
.24253 .30902 Mdot
.24259 .31143 Mdot
.24265 .32109 Mdot
.24271 .32109 Mdot
.24277 .30419 Mdot
.24283 .28729 Mdot
.24289 .28246 Mdot
.24295 .2897 Mdot
.24301 .29695 Mdot
.24307 .29695 Mdot
.24313 .29212 Mdot
.24319 .29212 Mdot
.24325 .3066 Mdot
.24331 .32109 Mdot
.24337 .33074 Mdot
.24343 .32833 Mdot
.24349 .3235 Mdot
.24355 .32109 Mdot
.24361 .32592 Mdot
.24367 .33074 Mdot
.24373 .32109 Mdot
.24379 .3066 Mdot
.24385 .29695 Mdot
.24391 .30177 Mdot
.24397 .30902 Mdot
.24403 .3066 Mdot
.24409 .29453 Mdot
.24415 .28488 Mdot
.24421 .29212 Mdot
.24427 .3066 Mdot
.24433 .31143 Mdot
.24439 .29936 Mdot
.24445 .28729 Mdot
.24451 .29212 Mdot
.24457 .31143 Mdot
.24463 .32109 Mdot
.24469 .31626 Mdot
.24475 .30902 Mdot
.24481 .31385 Mdot
.24487 .33316 Mdot
.24493 .34523 Mdot
.24499 .33799 Mdot
.24505 .32109 Mdot
.24511 .31385 Mdot
.24517 .31867 Mdot
.24523 .31867 Mdot
.24529 .30177 Mdot
.24535 .28005 Mdot
.24541 .26798 Mdot
.24547 .2728 Mdot
.24553 .28246 Mdot
.24559 .28488 Mdot
.24565 .28488 Mdot
.24571 .2897 Mdot
.24577 .30419 Mdot
.24583 .32592 Mdot
.24589 .33799 Mdot
.24595 .3404 Mdot
.24601 .33799 Mdot
.24607 .33557 Mdot
.24613 .33799 Mdot
.24619 .33799 Mdot
.24625 .32833 Mdot
.24631 .31143 Mdot
.24637 .29212 Mdot
.24643 .2897 Mdot
.24649 .29453 Mdot
.24655 .29453 Mdot
.24661 .28488 Mdot
.24667 .27522 Mdot
.24673 .27763 Mdot
.24679 .29695 Mdot
.24685 .30902 Mdot
.24691 .3066 Mdot
.24697 .29695 Mdot
.24703 .29936 Mdot
.24709 .31867 Mdot
.24715 .33557 Mdot
.24721 .33074 Mdot
.24727 .32109 Mdot
.24733 .32109 Mdot
.24739 .33316 Mdot
.24745 .34282 Mdot
.24751 .33557 Mdot
.24757 .31626 Mdot
.24763 .30419 Mdot
.24769 .30419 Mdot
.24775 .30419 Mdot
.24781 .29212 Mdot
.24787 .27522 Mdot
.24793 .26315 Mdot
.24799 .27039 Mdot
.24805 .28246 Mdot
.24811 .29453 Mdot
.24817 .29695 Mdot
.24823 .29936 Mdot
.24829 .31385 Mdot
.24835 .33557 Mdot
.24841 .34764 Mdot
.24847 .35006 Mdot
.24853 .34282 Mdot
.24859 .33557 Mdot
.24865 .33074 Mdot
.24871 .32833 Mdot
.24877 .31867 Mdot
.24883 .29936 Mdot
.24889 .28246 Mdot
.24895 .27763 Mdot
.24901 .28488 Mdot
.24907 .2897 Mdot
.24913 .28729 Mdot
.24919 .28005 Mdot
.24925 .28729 Mdot
.24931 .30419 Mdot
.24937 .3235 Mdot
.24943 .3235 Mdot
.24949 .31143 Mdot
.24955 .30902 Mdot
.24961 .3235 Mdot
.24967 .33557 Mdot
.24973 .33074 Mdot
.24979 .31385 Mdot
.24985 .30902 Mdot
.24991 .31626 Mdot
.24997 .32833 Mdot
.25003 .3235 Mdot
.25009 .3066 Mdot
.25015 .29453 Mdot
.25021 .29936 Mdot
.25027 .30902 Mdot
.25033 .30177 Mdot
.25039 .28729 Mdot
.25045 .27763 Mdot
.25051 .28246 Mdot
.25057 .29695 Mdot
.25063 .3066 Mdot
.25069 .3066 Mdot
.25075 .30419 Mdot
.25081 .31385 Mdot
.25087 .32833 Mdot
.25093 .33799 Mdot
.25099 .33799 Mdot
.25105 .33074 Mdot
.25111 .32109 Mdot
.25117 .31867 Mdot
.25123 .31626 Mdot
.25129 .31143 Mdot
.25135 .29936 Mdot
.25141 .28488 Mdot
.25147 .28488 Mdot
.25153 .29453 Mdot
.25159 .30177 Mdot
.25165 .30177 Mdot
.25171 .29695 Mdot
.25177 .29695 Mdot
.25183 .31143 Mdot
.25189 .32592 Mdot
.25195 .3235 Mdot
.25201 .30902 Mdot
.25207 .30177 Mdot
.25213 .3066 Mdot
.25219 .31867 Mdot
.25225 .31626 Mdot
.25231 .30419 Mdot
.25237 .29695 Mdot
.25243 .3066 Mdot
.25249 .32592 Mdot
.25255 .33074 Mdot
.25261 .31867 Mdot
.25267 .3066 Mdot
.25273 .31143 Mdot
.25279 .3235 Mdot
.25285 .32109 Mdot
.25291 .30177 Mdot
.25297 .28488 Mdot
.25303 .28246 Mdot
.25309 .29212 Mdot
.25315 .29936 Mdot
.25321 .29695 Mdot
.25327 .2897 Mdot
.25333 .29453 Mdot
.25339 .31143 Mdot
.25345 .32592 Mdot
.25351 .32833 Mdot
.25357 .32592 Mdot
.25363 .32109 Mdot
.25369 .3235 Mdot
.25375 .32833 Mdot
.25381 .32833 Mdot
.25387 .31626 Mdot
.25393 .30177 Mdot
.25399 .29695 Mdot
.25405 .30419 Mdot
.25411 .30902 Mdot
.25417 .3066 Mdot
.25423 .29453 Mdot
.25429 .28729 Mdot
.25435 .29695 Mdot
.25441 .31143 Mdot
.25447 .31143 Mdot
.25453 .29453 Mdot
.25459 .28488 Mdot
.25465 .29453 Mdot
.25471 .31385 Mdot
.25477 .32109 Mdot
.25483 .31143 Mdot
.25489 .3066 Mdot
.25495 .31626 Mdot
.25501 .33799 Mdot
.25507 .34764 Mdot
.25513 .33557 Mdot
.25519 .31867 Mdot
.25525 .31626 Mdot
.25531 .3235 Mdot
.25537 .31867 Mdot
.25543 .29695 Mdot
.25549 .27522 Mdot
.25555 .26798 Mdot
.25561 .27522 Mdot
.25567 .28488 Mdot
.25573 .28488 Mdot
.25579 .28005 Mdot
.25585 .2897 Mdot
.25591 .31143 Mdot
.25597 .33074 Mdot
.25603 .3404 Mdot
.25609 .33799 Mdot
.25615 .33557 Mdot
.25621 .33799 Mdot
.25627 .3404 Mdot
.25633 .33799 Mdot
.25639 .3235 Mdot
.25645 .30419 Mdot
.25651 .29212 Mdot
.25657 .29212 Mdot
.25663 .29695 Mdot
.25669 .29212 Mdot
.25675 .28005 Mdot
.25681 .2728 Mdot
.25687 .28246 Mdot
.25693 .30177 Mdot
.25699 .31143 Mdot
.25705 .30177 Mdot
.25711 .29453 Mdot
.25717 .30419 Mdot
.25723 .32592 Mdot
.25729 .33799 Mdot
.25735 .32833 Mdot
.25741 .31867 Mdot
.25747 .3235 Mdot
.25753 .3404 Mdot
.25759 .34523 Mdot
.25765 .33074 Mdot
.25771 .30902 Mdot
.25777 .30177 Mdot
.25783 .3066 Mdot
.25789 .3066 Mdot
.25795 .28729 Mdot
.25801 .26798 Mdot
.25807 .26315 Mdot
.25813 .27522 Mdot
.25819 .2897 Mdot
.25825 .29453 Mdot
.25831 .29453 Mdot
.25837 .30177 Mdot
.25843 .32109 Mdot
.25849 .34282 Mdot
.25855 .35006 Mdot
.25861 .34523 Mdot
.25867 .33799 Mdot
.25873 .33557 Mdot
.25879 .33316 Mdot
.25885 .32833 Mdot
.25891 .31143 Mdot
.25897 .29212 Mdot
.25903 .27763 Mdot
.25909 .28005 Mdot
.25915 .28488 Mdot
.25921 .28729 Mdot
.25927 .28246 Mdot
.25933 .28005 Mdot
.25939 .29212 Mdot
.25945 .31385 Mdot
.25951 .32592 Mdot
.25957 .31867 Mdot
.25963 .30902 Mdot
.25969 .31385 Mdot
.25975 .33074 Mdot
.25981 .33799 Mdot
.25987 .32833 Mdot
.25993 .31143 Mdot
.25999 .30902 Mdot
.26005 .32109 Mdot
.26011 .33074 Mdot
.26017 .31867 Mdot
.26023 .29695 Mdot
.26029 .29212 Mdot
.26035 .30177 Mdot
.26041 .30902 Mdot
.26047 .29936 Mdot
.26053 .28005 Mdot
.26059 .27522 Mdot
.26064 .28729 Mdot
.2607 .30419 Mdot
.26076 .30902 Mdot
.26082 .30419 Mdot
.26088 .30419 Mdot
.26094 .31867 Mdot
.261 .33557 Mdot
.26106 .34282 Mdot
.26112 .33316 Mdot
.26118 .3235 Mdot
.26124 .32109 Mdot
.2613 .32109 Mdot
.26136 .31867 Mdot
.26142 .3066 Mdot
.26148 .29212 Mdot
.26154 .28246 Mdot
.2616 .28729 Mdot
.26166 .29695 Mdot
.26172 .30177 Mdot
.26178 .29695 Mdot
.26184 .29453 Mdot
.2619 .30177 Mdot
.26196 .31867 Mdot
.26202 .32833 Mdot
.26208 .32109 Mdot
.26214 .30419 Mdot
.2622 .30177 Mdot
.26226 .31385 Mdot
.26232 .3235 Mdot
.26238 .31385 Mdot
.26244 .29936 Mdot
.2625 .29695 Mdot
.26256 .31143 Mdot
.26262 .32833 Mdot
.26268 .32592 Mdot
.26274 .30902 Mdot
.2628 .30419 Mdot
.26286 .31626 Mdot
.26292 .32592 Mdot
.26298 .31626 Mdot
.26304 .29453 Mdot
.2631 .28246 Mdot
.26316 .28729 Mdot
.26322 .29936 Mdot
.26328 .30177 Mdot
.26334 .29212 Mdot
.2634 .28729 Mdot
.26346 .29936 Mdot
.26352 .31867 Mdot
.26358 .32833 Mdot
.26364 .32592 Mdot
.2637 .31867 Mdot
.26376 .32109 Mdot
.26382 .32833 Mdot
.26388 .33074 Mdot
.26394 .32109 Mdot
.264 .30902 Mdot
.26406 .29936 Mdot
.26412 .29936 Mdot
.26418 .3066 Mdot
.26424 .30902 Mdot
.2643 .29936 Mdot
.26436 .2897 Mdot
.26442 .29212 Mdot
.26448 .30419 Mdot
.26454 .31385 Mdot
.2646 .3066 Mdot
.26466 .29212 Mdot
.26472 .28729 Mdot
.26478 .30177 Mdot
.26484 .31867 Mdot
.2649 .31867 Mdot
.26496 .3066 Mdot
.26502 .3066 Mdot
.26508 .3235 Mdot
.26514 .34282 Mdot
.2652 .34282 Mdot
.26526 .32592 Mdot
.26532 .31385 Mdot
.26538 .31867 Mdot
.26544 .32592 Mdot
.2655 .31626 Mdot
.26556 .2897 Mdot
.26562 .26798 Mdot
.26568 .27039 Mdot
.26574 .28246 Mdot
.2658 .28729 Mdot
.26586 .28005 Mdot
.26592 .27763 Mdot
.26598 .29453 Mdot
.26604 .31867 Mdot
.2661 .33557 Mdot
.26616 .33799 Mdot
.26622 .33557 Mdot
.26628 .33799 Mdot
.26634 .34282 Mdot
.2664 .34523 Mdot
.26646 .33557 Mdot
.26652 .31626 Mdot
.26658 .29936 Mdot
.26664 .29453 Mdot
.2667 .29453 Mdot
.26676 .29453 Mdot
.26682 .28488 Mdot
.26688 .2728 Mdot
.26694 .27522 Mdot
.267 .2897 Mdot
.26706 .30419 Mdot
.26712 .3066 Mdot
.26718 .29695 Mdot
.26724 .29695 Mdot
.2673 .31385 Mdot
.26736 .33316 Mdot
.26742 .33557 Mdot
.26748 .32592 Mdot
.26754 .31867 Mdot
.2676 .32833 Mdot
.26766 .34523 Mdot
.26772 .34282 Mdot
.26778 .3235 Mdot
.26784 .30419 Mdot
.2679 .30177 Mdot
.26796 .30902 Mdot
.26802 .30177 Mdot
.26808 .27763 Mdot
.26814 .26073 Mdot
.2682 .26315 Mdot
.26826 .28005 Mdot
.26832 .29212 Mdot
.26838 .29212 Mdot
.26844 .2897 Mdot
.2685 .30419 Mdot
.26856 .33074 Mdot
.26862 .35006 Mdot
.26868 .35247 Mdot
.26874 .34282 Mdot
.2688 .33799 Mdot
.26886 .3404 Mdot
.26892 .33799 Mdot
.26898 .32592 Mdot
.26904 .30419 Mdot
.2691 .28488 Mdot
.26916 .27763 Mdot
.26922 .28246 Mdot
.26928 .28488 Mdot
.26934 .28005 Mdot
.2694 .27522 Mdot
.26946 .28005 Mdot
.26952 .29695 Mdot
.26958 .31626 Mdot
.26964 .3235 Mdot
.2697 .31626 Mdot
.26976 .31143 Mdot
.26982 .3235 Mdot
.26988 .33799 Mdot
.26994 .33799 Mdot
.27 .3235 Mdot
.27006 .30902 Mdot
.27012 .31385 Mdot
.27018 .32833 Mdot
.27024 .32833 Mdot
.2703 .31143 Mdot
.27036 .29212 Mdot
.27042 .29212 Mdot
.27048 .30419 Mdot
.27054 .3066 Mdot
.2706 .2897 Mdot
.27066 .2728 Mdot
.27072 .27522 Mdot
.27078 .29212 Mdot
.27084 .3066 Mdot
.2709 .30902 Mdot
.27096 .30177 Mdot
.27102 .30419 Mdot
.27108 .32592 Mdot
.27114 .34523 Mdot
.2712 .34282 Mdot
.27126 .33074 Mdot
.27132 .3235 Mdot
.27138 .32592 Mdot
.27144 .32592 Mdot
.2715 .31626 Mdot
.27156 .29936 Mdot
.27162 .28488 Mdot
.27168 .28246 Mdot
.27174 .2897 Mdot
.2718 .29453 Mdot
.27186 .29212 Mdot
.27192 .2897 Mdot
.27198 .29453 Mdot
.27204 .30902 Mdot
.2721 .3235 Mdot
.27216 .32592 Mdot
.27222 .31626 Mdot
.27228 .3066 Mdot
.27234 .31143 Mdot
.2724 .3235 Mdot
.27246 .3235 Mdot
.27252 .30902 Mdot
.27258 .29695 Mdot
.27264 .30177 Mdot
.2727 .31867 Mdot
.27276 .32833 Mdot
.27282 .31867 Mdot
.27288 .30177 Mdot
.27294 .30177 Mdot
.273 .31626 Mdot
.27306 .3235 Mdot
.27312 .30902 Mdot
.27318 .28729 Mdot
.27324 .28246 Mdot
.2733 .29453 Mdot
.27336 .3066 Mdot
.27342 .30177 Mdot
.27348 .2897 Mdot
.27354 .2897 Mdot
.2736 .30902 Mdot
.27366 .32833 Mdot
.27372 .33074 Mdot
.27378 .32109 Mdot
.27384 .31626 Mdot
.2739 .3235 Mdot
.27396 .33074 Mdot
.27402 .32833 Mdot
.27408 .31385 Mdot
.27414 .29936 Mdot
.2742 .29695 Mdot
.27426 .30419 Mdot
.27432 .30902 Mdot
.27438 .30419 Mdot
.27444 .29453 Mdot
.2745 .29212 Mdot
.27456 .29936 Mdot
.27462 .31143 Mdot
.27468 .31385 Mdot
.27474 .30419 Mdot
.2748 .29212 Mdot
.27486 .29453 Mdot
.27492 .30902 Mdot
.27498 .31867 Mdot
.27504 .31385 Mdot
.2751 .30419 Mdot
.27516 .30902 Mdot
.27522 .32592 Mdot
.27528 .3404 Mdot
.27534 .33799 Mdot
.2754 .32109 Mdot
.27546 .31385 Mdot
.27552 .32109 Mdot
.27558 .32592 Mdot
.27564 .31143 Mdot
.2757 .28729 Mdot
.27576 .27039 Mdot
.27582 .27522 Mdot
.27588 .28729 Mdot
.27594 .2897 Mdot
.276 .28005 Mdot
.27606 .27763 Mdot
.27612 .29695 Mdot
.27618 .3235 Mdot
.27624 .33557 Mdot
.2763 .33316 Mdot
.27636 .33074 Mdot
.27642 .33557 Mdot
.27648 .34282 Mdot
.27654 .34282 Mdot
.2766 .33074 Mdot
.27666 .31143 Mdot
.27672 .29936 Mdot
.27678 .29936 Mdot
.27684 .29936 Mdot
.2769 .29453 Mdot
.27696 .28246 Mdot
.27702 .27522 Mdot
.27708 .28005 Mdot
.27714 .29212 Mdot
.2772 .30419 Mdot
.27726 .30177 Mdot
.27732 .29453 Mdot
.27738 .29936 Mdot
.27744 .31385 Mdot
.2775 .33074 Mdot
.27756 .33074 Mdot
.27762 .3235 Mdot
.27768 .32109 Mdot
.27774 .33316 Mdot
.2778 .34523 Mdot
.27786 .34282 Mdot
.27792 .3235 Mdot
.27798 .3066 Mdot
.27804 .3066 Mdot
.2781 .31143 Mdot
.27816 .30177 Mdot
.27822 .27763 Mdot
.27828 .26073 Mdot
.27834 .26315 Mdot
.2784 .28246 Mdot
.27846 .29212 Mdot
.27852 .2897 Mdot
.27858 .2897 Mdot
.27864 .3066 Mdot
.2787 .33316 Mdot
.27876 .35006 Mdot
.27882 .34764 Mdot
.27888 .3404 Mdot
.27894 .33799 Mdot
.279 .34282 Mdot
.27906 .3404 Mdot
.27912 .3235 Mdot
.27918 .30177 Mdot
.27924 .28729 Mdot
.2793 .28246 Mdot
.27936 .28488 Mdot
.27942 .28246 Mdot
.27948 .27763 Mdot
.27954 .27522 Mdot
.2796 .28246 Mdot
.27966 .29695 Mdot
.27972 .31385 Mdot
.27978 .31626 Mdot
.27984 .31143 Mdot
.2799 .31143 Mdot
.27996 .3235 Mdot
.28002 .33799 Mdot
.28008 .33799 Mdot
.28014 .3235 Mdot
.2802 .31385 Mdot
.28026 .31867 Mdot
.28032 .33074 Mdot
.28038 .32833 Mdot
.28044 .31143 Mdot
.2805 .29212 Mdot
.28056 .29453 Mdot
.28062 .30419 Mdot
.28068 .30419 Mdot
.28074 .28488 Mdot
.2808 .27039 Mdot
.28086 .2728 Mdot
.28092 .29212 Mdot
.28098 .3066 Mdot
.28104 .3066 Mdot
.2811 .29936 Mdot
.28116 .30902 Mdot
.28122 .33074 Mdot
.28128 .34523 Mdot
.28134 .34282 Mdot
.2814 .33074 Mdot
.28146 .32592 Mdot
.28152 .32833 Mdot
.28158 .32592 Mdot
.28164 .31385 Mdot
.2817 .29453 Mdot
.28176 .28246 Mdot
.28182 .28488 Mdot
.28188 .29212 Mdot
.28194 .29453 Mdot
.282 .2897 Mdot
.28206 .28729 Mdot
.28212 .29453 Mdot
.28218 .30902 Mdot
.28224 .3235 Mdot
.2823 .3235 Mdot
.28236 .31385 Mdot
.28242 .3066 Mdot
.28248 .31385 Mdot
.28254 .3235 Mdot
.2826 .3235 Mdot
.28266 .31143 Mdot
.28272 .29936 Mdot
.28278 .30419 Mdot
.28284 .32109 Mdot
.2829 .32592 Mdot
.28296 .31626 Mdot
.28302 .30177 Mdot
.28308 .30419 Mdot
.28314 .31626 Mdot
.2832 .32109 Mdot
.28326 .30419 Mdot
.28332 .28488 Mdot
.28338 .28005 Mdot
.28344 .29453 Mdot
.2835 .3066 Mdot
.28356 .30177 Mdot
.28362 .2897 Mdot
.28368 .29453 Mdot
.28374 .31385 Mdot
.2838 .33074 Mdot
.28386 .32833 Mdot
.28392 .31867 Mdot
.28398 .31626 Mdot
.28404 .32592 Mdot
.2841 .33074 Mdot
.28416 .3235 Mdot
.28422 .30902 Mdot
.28428 .29936 Mdot
.28434 .29936 Mdot
.2844 .3066 Mdot
.28446 .3066 Mdot
.28452 .30177 Mdot
.28458 .29212 Mdot
.28464 .29212 Mdot
.2847 .29936 Mdot
.28476 .31143 Mdot
.28482 .31143 Mdot
.28488 .29936 Mdot
.28494 .29212 Mdot
.285 .29936 Mdot
.28506 .31385 Mdot
.28512 .31867 Mdot
.28518 .31143 Mdot
.28524 .30419 Mdot
.2853 .31385 Mdot
.28536 .33074 Mdot
.28542 .3404 Mdot
.28548 .33316 Mdot
.28554 .31626 Mdot
.2856 .31385 Mdot
.28566 .32109 Mdot
.28572 .3235 Mdot
.28578 .3066 Mdot
.28584 .28005 Mdot
.2859 .27039 Mdot
.28596 .28005 Mdot
.28602 .29212 Mdot
.28608 .2897 Mdot
.28614 .27763 Mdot
.2862 .28005 Mdot
.28626 .30177 Mdot
.28632 .32592 Mdot
.28638 .33557 Mdot
.28644 .33074 Mdot
.2865 .32833 Mdot
.28656 .33799 Mdot
.28662 .34764 Mdot
.28668 .34282 Mdot
.28674 .32592 Mdot
.2868 .30902 Mdot
.28686 .30177 Mdot
.28692 .30177 Mdot
.28698 .30177 Mdot
.28704 .2897 Mdot
.2871 .27763 Mdot
.28716 .2728 Mdot
.28722 .28246 Mdot
.28728 .29453 Mdot
.28734 .30177 Mdot
.2874 .29453 Mdot
.28746 .29212 Mdot
.28752 .30177 Mdot
.28758 .32109 Mdot
.28764 .33316 Mdot
.2877 .33074 Mdot
.28776 .3235 Mdot
.28782 .32592 Mdot
.28788 .3404 Mdot
.28794 .34764 Mdot
.288 .33799 Mdot
.28806 .31626 Mdot
.28812 .30419 Mdot
.28818 .3066 Mdot
.28824 .30902 Mdot
.2883 .29453 Mdot
.28836 .26798 Mdot
.28842 .2559 Mdot
.28848 .26798 Mdot
.28854 .28729 Mdot
.2886 .29212 Mdot
.28866 .28729 Mdot
.28872 .2897 Mdot
.28878 .31385 Mdot
.28884 .3404 Mdot
.2889 .35247 Mdot
.28896 .34523 Mdot
.28902 .33799 Mdot
.28908 .34282 Mdot
.28914 .34764 Mdot
.2892 .3404 Mdot
.28926 .31867 Mdot
.28932 .29695 Mdot
.28938 .28729 Mdot
.28944 .28729 Mdot
.2895 .28488 Mdot
.28956 .27763 Mdot
.28962 .27039 Mdot
.28968 .27039 Mdot
.28974 .28488 Mdot
.2898 .30177 Mdot
.28986 .31143 Mdot
.28992 .31143 Mdot
.28998 .31143 Mdot
.29004 .31867 Mdot
.2901 .33316 Mdot
.29016 .34282 Mdot
.29022 .33799 Mdot
.29028 .3235 Mdot
.29034 .31867 Mdot
.2904 .32592 Mdot
.29046 .33316 Mdot
.29052 .3235 Mdot
.29058 .30177 Mdot
.29064 .28729 Mdot
.2907 .29212 Mdot
.29076 .30177 Mdot
.29082 .29453 Mdot
.29088 .27522 Mdot
.29094 .26556 Mdot
.291 .27763 Mdot
.29106 .29936 Mdot
.29112 .30902 Mdot
.29118 .30419 Mdot
.29124 .30177 Mdot
.2913 .31867 Mdot
.29136 .34282 Mdot
.29142 .35247 Mdot
.29148 .3404 Mdot
.29154 .32592 Mdot
.2916 .32592 Mdot
.29166 .33074 Mdot
.29172 .32592 Mdot
.29178 .3066 Mdot
.29184 .28729 Mdot
.2919 .28005 Mdot
.29196 .28488 Mdot
.29202 .29212 Mdot
.29208 .2897 Mdot
.29214 .28488 Mdot
.2922 .28488 Mdot
.29226 .29936 Mdot
.29232 .31385 Mdot
.29238 .3235 Mdot
.29244 .32109 Mdot
.2925 .31385 Mdot
.29256 .31385 Mdot
.29262 .3235 Mdot
.29268 .32833 Mdot
.29274 .3235 Mdot
.2928 .30902 Mdot
.29286 .30177 Mdot
.29292 .31143 Mdot
.29298 .32109 Mdot
.29304 .32109 Mdot
.2931 .3066 Mdot
.29316 .29453 Mdot
.29322 .30177 Mdot
.29328 .31626 Mdot
.29334 .31385 Mdot
.2934 .29453 Mdot
.29346 .28005 Mdot
.29352 .28729 Mdot
.29358 .30419 Mdot
.29364 .31143 Mdot
.2937 .30177 Mdot
.29376 .29212 Mdot
.29382 .29936 Mdot
.29388 .3235 Mdot
.29394 .33557 Mdot
.294 .32592 Mdot
.29406 .31385 Mdot
.29412 .31626 Mdot
.29418 .32833 Mdot
.29424 .33074 Mdot
.2943 .31867 Mdot
.29436 .30177 Mdot
.29442 .29453 Mdot
.29448 .30177 Mdot
.29454 .30902 Mdot
.2946 .30419 Mdot
.29466 .29453 Mdot
.29472 .2897 Mdot
.29478 .29695 Mdot
.29484 .3066 Mdot
.2949 .31385 Mdot
.29496 .3066 Mdot
.29502 .29695 Mdot
.29508 .29695 Mdot
.29514 .3066 Mdot
.2952 .31626 Mdot
.29526 .31626 Mdot
.29532 .30902 Mdot
.29538 .3066 Mdot
.29544 .31867 Mdot
.2955 .33316 Mdot
.29556 .33799 Mdot
.29562 .32592 Mdot
.29568 .31385 Mdot
.29574 .31626 Mdot
.2958 .3235 Mdot
.29586 .31867 Mdot
.29592 .29695 Mdot
.29598 .27522 Mdot
.29604 .2728 Mdot
.2961 .28488 Mdot
.29616 .29453 Mdot
.29622 .28488 Mdot
.29628 .27522 Mdot
.29634 .28488 Mdot
.2964 .31385 Mdot
.29646 .33557 Mdot
.29652 .33557 Mdot
.29658 .32592 Mdot
.29664 .32833 Mdot
.2967 .34282 Mdot
.29676 .35006 Mdot
.29682 .33799 Mdot
.29688 .31626 Mdot
.29694 .30177 Mdot
.297 .30177 Mdot
.29706 .30419 Mdot
.29712 .29695 Mdot
.29718 .28246 Mdot
.29724 .2728 Mdot
.2973 .27763 Mdot
.29736 .2897 Mdot
.29742 .29936 Mdot
.29748 .29695 Mdot
.29754 .29212 Mdot
.2976 .29695 Mdot
.29766 .31143 Mdot
.29772 .32592 Mdot
.29778 .33074 Mdot
.29784 .32592 Mdot
.2979 .3235 Mdot
.29796 .33074 Mdot
.29802 .34523 Mdot
.29808 .34523 Mdot
.29814 .33074 Mdot
.2982 .31143 Mdot
.29826 .30419 Mdot
.29832 .30902 Mdot
.29838 .3066 Mdot
.29844 .28488 Mdot
.2985 .25832 Mdot
.29856 .2559 Mdot
.29862 .2728 Mdot
.29868 .28729 Mdot
.29874 .2897 Mdot
.2988 .28005 Mdot
.29886 .28729 Mdot
.29892 .34764 Mdot
.29898 .40317 Mdot
.29904 .38627 Mdot
.2991 .30419 Mdot
.29916 .2559 Mdot
.29922 .30177 Mdot
.29928 .34282 Mdot
.29934 .31143 Mdot
.2994 .28005 Mdot
.29946 .28005 Mdot
.29952 .29453 Mdot
.29958 .31385 Mdot
.29964 .30902 Mdot
.2997 .27039 Mdot
.29976 .25108 Mdot
.29982 .26798 Mdot
.29988 .2897 Mdot
.29994 .32592 Mdot
.3 .3573 Mdot
.30006 .33316 Mdot
.30012 .31143 Mdot
.30018 .32109 Mdot
.30024 .32109 Mdot
.3003 .33557 Mdot
.30036 .35972 Mdot
.30042 .35006 Mdot
.30048 .34282 Mdot
.30054 .34282 Mdot
.3006 .30177 Mdot
.30066 .26073 Mdot
.30072 .26556 Mdot
.30078 .27763 Mdot
.30084 .29695 Mdot
.3009 .31626 Mdot
.30096 .2728 Mdot
.30102 .21728 Mdot
.30108 .22452 Mdot
.30114 .26073 Mdot
.3012 .3066 Mdot
.30126 .35006 Mdot
.30132 .33799 Mdot
.30138 .30902 Mdot
.30144 .3235 Mdot
.3015 .33557 Mdot
.30156 .34764 Mdot
.30162 .37903 Mdot
.30168 .3911 Mdot
.30174 .37661 Mdot
.3018 .36454 Mdot
.30186 .31867 Mdot
.30192 .26798 Mdot
.30198 .27763 Mdot
.30204 .3066 Mdot
.3021 .31626 Mdot
.30216 .31867 Mdot
.30222 .28246 Mdot
.30228 .22935 Mdot
.30234 .23418 Mdot
.3024 .26315 Mdot
.30246 .28488 Mdot
.30252 .32109 Mdot
.30258 .33316 Mdot
.30264 .29936 Mdot
.3027 .29212 Mdot
.30276 .30177 Mdot
.30282 .29453 Mdot
.30288 .31385 Mdot
.30294 .33799 Mdot
.303 .32592 Mdot
.30306 .32109 Mdot
.30312 .32109 Mdot
.30318 .29695 Mdot
.30324 .30419 Mdot
.3033 .3404 Mdot
.30336 .35972 Mdot
.30342 .36937 Mdot
.30348 .35247 Mdot
.30354 .29212 Mdot
.3036 .27039 Mdot
.30366 .29936 Mdot
.30372 .31867 Mdot
.30378 .33557 Mdot
.30384 .33316 Mdot
.3039 .29453 Mdot
.30396 .27522 Mdot
.30402 .29453 Mdot
.30408 .29453 Mdot
.30414 .29453 Mdot
.3042 .31385 Mdot
.30426 .3066 Mdot
.30432 .29212 Mdot
.30438 .2897 Mdot
.30444 .26073 Mdot
.3045 .24866 Mdot
.30456 .29212 Mdot
.30462 .32109 Mdot
.30468 .32833 Mdot
.30474 .3235 Mdot
.3048 .28488 Mdot
.30486 .26556 Mdot
.30492 .31143 Mdot
.30498 .35489 Mdot
.30504 .3742 Mdot
.3051 .38144 Mdot
.30516 .35006 Mdot
.30522 .31143 Mdot
.30528 .31626 Mdot
.30534 .32592 Mdot
.3054 .32592 Mdot
.30546 .34282 Mdot
.30552 .3404 Mdot
.30558 .31385 Mdot
.30564 .3066 Mdot
.3057 .2897 Mdot
.30576 .26798 Mdot
.30582 .2897 Mdot
.30588 .31867 Mdot
.30594 .31143 Mdot
.306 .2897 Mdot
.30606 .24625 Mdot
.30612 .20762 Mdot
.30618 .22935 Mdot
.30624 .28246 Mdot
.3063 .30419 Mdot
.30636 .31143 Mdot
.30642 .29936 Mdot
.30648 .27522 Mdot
.30654 .30177 Mdot
.3066 .34523 Mdot
.30666 .36213 Mdot
.30672 .38144 Mdot
.30678 .40076 Mdot
.30684 .38869 Mdot
.3069 .37179 Mdot
.30696 .34764 Mdot
.30702 .31385 Mdot
.30708 .3235 Mdot
.30714 .35006 Mdot
.3072 .33799 Mdot
.30726 .30419 Mdot
.30732 .26798 Mdot
.30738 .22935 Mdot
.30744 .23659 Mdot
.3075 .28005 Mdot
.30756 .29212 Mdot
.30762 .28246 Mdot
.30768 .27039 Mdot
.30774 .23901 Mdot
.3078 .23901 Mdot
.30786 .28005 Mdot
.30792 .30419 Mdot
.30798 .32592 Mdot
.30804 .35247 Mdot
.3081 .34282 Mdot
.30816 .32592 Mdot
.30822 .33074 Mdot
.30828 .32833 Mdot
.30834 .33799 Mdot
.3084 .37661 Mdot
.30846 .37903 Mdot
.30852 .35006 Mdot
.30858 .31626 Mdot
.30864 .27039 Mdot
.3087 .25832 Mdot
.30876 .30177 Mdot
.30882 .33316 Mdot
.30888 .3235 Mdot
.30894 .30419 Mdot
.309 .27763 Mdot
.30906 .27522 Mdot
.30912 .31143 Mdot
.30918 .33074 Mdot
.30924 .32833 Mdot
.3093 .33316 Mdot
.30936 .32109 Mdot
.30942 .28729 Mdot
.30948 .26798 Mdot
.30954 .25832 Mdot
.3096 .25832 Mdot
.30966 .29212 Mdot
.30972 .31143 Mdot
.30978 .28729 Mdot
.30984 .26315 Mdot
.3099 .25349 Mdot
.30996 .26556 Mdot
.31002 .3235 Mdot
.31008 .37179 Mdot
.31014 .3742 Mdot
.3102 .36213 Mdot
.31026 .34523 Mdot
.31032 .33074 Mdot
.31038 .35006 Mdot
.31044 .37179 Mdot
.3105 .36696 Mdot
.31056 .35972 Mdot
.31062 .34282 Mdot
.31068 .3066 Mdot
.31074 .28246 Mdot
.3108 .27522 Mdot
.31086 .26556 Mdot
.31092 .27763 Mdot
.31098 .29212 Mdot
.31104 .26556 Mdot
.3111 .22211 Mdot
.31116 .20279 Mdot
.31122 .20521 Mdot
.31128 .25108 Mdot
.31134 .31143 Mdot
.3114 .32109 Mdot
.31146 .30419 Mdot
.31152 .3066 Mdot
.31158 .31626 Mdot
.31164 .35006 Mdot
.3117 .39351 Mdot
.31176 .40317 Mdot
.31182 .39834 Mdot
.31188 .39593 Mdot
.31194 .36454 Mdot
.312 .32592 Mdot
.31206 .30902 Mdot
.31212 .3066 Mdot
.31218 .31867 Mdot
.31224 .33316 Mdot
.3123 .29936 Mdot
.31236 .24625 Mdot
.31242 .22693 Mdot
.31248 .23659 Mdot
.31254 .26798 Mdot
.3126 .3066 Mdot
.31266 .3066 Mdot
.31272 .2728 Mdot
.31278 .2559 Mdot
.31284 .2559 Mdot
.3129 .27039 Mdot
.31296 .30419 Mdot
.31302 .32592 Mdot
.31308 .3235 Mdot
.31314 .32592 Mdot
.3132 .31867 Mdot
.31326 .3066 Mdot
.31332 .32109 Mdot
.31338 .34523 Mdot
.31344 .36454 Mdot
.3135 .38627 Mdot
.31356 .37903 Mdot
.31362 .33316 Mdot
.31368 .29936 Mdot
.31374 .29936 Mdot
.3138 .31867 Mdot
.31385 .35247 Mdot
.31391 .35247 Mdot
.31397 .3066 Mdot
.31403 .27039 Mdot
.31409 .26556 Mdot
.31415 .27039 Mdot
.31421 .29212 Mdot
.31427 .30419 Mdot
.31433 .29212 Mdot
.31439 .28005 Mdot
.31445 .27039 Mdot
.31451 .24625 Mdot
.31457 .24142 Mdot
.31463 .26556 Mdot
.31469 .29212 Mdot
.31475 .31867 Mdot
.31481 .32833 Mdot
.31487 .29695 Mdot
.31493 .27763 Mdot
.31499 .3066 Mdot
.31505 .34764 Mdot
.31511 .3911 Mdot
.31517 .41041 Mdot
.31523 .37661 Mdot
.31529 .33557 Mdot
.31535 .32833 Mdot
.31541 .33074 Mdot
.31547 .34282 Mdot
.31553 .35972 Mdot
.31559 .34523 Mdot
.31565 .31626 Mdot
.31571 .29936 Mdot
.31577 .27522 Mdot
.31583 .26073 Mdot
.31589 .27522 Mdot
.31595 .28729 Mdot
.31601 .2897 Mdot
.31607 .28246 Mdot
.31613 .24383 Mdot
.31619 .20038 Mdot
.31625 .20762 Mdot
.31631 .24383 Mdot
.31637 .28488 Mdot
.31643 .31626 Mdot
.31649 .30177 Mdot
.31655 .2728 Mdot
.31661 .28729 Mdot
.31667 .33316 Mdot
.31673 .37661 Mdot
.31679 .41041 Mdot
.31685 .41766 Mdot
.31691 .40076 Mdot
.31697 .39351 Mdot
.31703 .3742 Mdot
.31709 .34523 Mdot
.31715 .34282 Mdot
.31721 .35489 Mdot
.31727 .35247 Mdot
.31733 .32833 Mdot
.31739 .2728 Mdot
.31745 .21486 Mdot
.31751 .20762 Mdot
.31757 .24142 Mdot
.31763 .26556 Mdot
.31769 .27039 Mdot
.31775 .24866 Mdot
.31781 .21245 Mdot
.31787 .21003 Mdot
.31793 .24383 Mdot
.31799 .27763 Mdot
.31805 .31385 Mdot
.31811 .3404 Mdot
.31817 .33799 Mdot
.31823 .33557 Mdot
.31829 .3404 Mdot
.31835 .3404 Mdot
.31841 .36454 Mdot
.31847 .39834 Mdot
.31853 .40558 Mdot
.31859 .3911 Mdot
.31865 .35489 Mdot
.31871 .29936 Mdot
.31877 .27763 Mdot
.31883 .3066 Mdot
.31889 .33557 Mdot
.31895 .33799 Mdot
.31901 .31385 Mdot
.31907 .26798 Mdot
.31913 .24866 Mdot
.31919 .27763 Mdot
.31925 .30419 Mdot
.31931 .31626 Mdot
.31937 .31626 Mdot
.31943 .29695 Mdot
.31949 .27039 Mdot
.31955 .26073 Mdot
.31961 .24383 Mdot
.31967 .24383 Mdot
.31973 .27522 Mdot
.31979 .29695 Mdot
.31985 .2897 Mdot
.31991 .27039 Mdot
.31997 .24625 Mdot
.32003 .2559 Mdot
.32009 .31626 Mdot
.32015 .3742 Mdot
.32021 .39351 Mdot
.32027 .38869 Mdot
.32033 .36454 Mdot
.32039 .34764 Mdot
.32045 .36937 Mdot
.32051 .39351 Mdot
.32057 .39834 Mdot
.32063 .39351 Mdot
.32069 .36937 Mdot
.32075 .3235 Mdot
.32081 .29453 Mdot
.32087 .2728 Mdot
.32093 .2559 Mdot
.32099 .26556 Mdot
.32105 .27039 Mdot
.32111 .24383 Mdot
.32117 .21003 Mdot
.32123 .18106 Mdot
.32129 .16658 Mdot
.32135 .20521 Mdot
.32141 .27039 Mdot
.32147 .30177 Mdot
.32153 .30177 Mdot
.32159 .29212 Mdot
.32165 .2897 Mdot
.32171 .33316 Mdot
.32177 .39593 Mdot
.32183 .42248 Mdot
.32189 .4249 Mdot
.32195 .41766 Mdot
.32201 .3911 Mdot
.32207 .36696 Mdot
.32213 .35247 Mdot
.32219 .33316 Mdot
.32225 .33557 Mdot
.32231 .35006 Mdot
.32237 .32833 Mdot
.32243 .28005 Mdot
.32249 .23901 Mdot
.32255 .21969 Mdot
.32261 .24625 Mdot
.32267 .29453 Mdot
.32273 .30419 Mdot
.32279 .27522 Mdot
.32285 .24625 Mdot
.32291 .22693 Mdot
.32297 .23901 Mdot
.32303 .28005 Mdot
.32309 .30419 Mdot
.32315 .3066 Mdot
.32321 .30902 Mdot
.32327 .29695 Mdot
.32333 .28729 Mdot
.32339 .30419 Mdot
.32345 .32592 Mdot
.32351 .35006 Mdot
.32357 .38386 Mdot
.32363 .38869 Mdot
.32369 .3573 Mdot
.32375 .32833 Mdot
.32381 .31385 Mdot
.32387 .32833 Mdot
.32393 .37179 Mdot
.32399 .38627 Mdot
.32405 .35006 Mdot
.32411 .3066 Mdot
.32417 .27522 Mdot
.32423 .2728 Mdot
.32429 .30419 Mdot
.32435 .31626 Mdot
.32441 .29695 Mdot
.32447 .27763 Mdot
.32453 .2559 Mdot
.32459 .23176 Mdot
.32465 .22693 Mdot
.32471 .23659 Mdot
.32477 .25349 Mdot
.32483 .29212 Mdot
.32489 .3066 Mdot
.32495 .28005 Mdot
.32501 .25832 Mdot
.32507 .27039 Mdot
.32513 .30902 Mdot
.32519 .3742 Mdot
.32525 .41041 Mdot
.32531 .38869 Mdot
.32537 .3573 Mdot
.32543 .34282 Mdot
.32549 .3404 Mdot
.32555 .36454 Mdot
.32561 .38627 Mdot
.32567 .3742 Mdot
.32573 .35247 Mdot
.32579 .32833 Mdot
.32585 .29453 Mdot
.32591 .28005 Mdot
.32597 .28729 Mdot
.32603 .29212 Mdot
.32609 .29695 Mdot
.32615 .29212 Mdot
.32621 .25108 Mdot
.32627 .20762 Mdot
.32633 .19555 Mdot
.32639 .21003 Mdot
.32645 .2559 Mdot
.32651 .29695 Mdot
.32657 .28729 Mdot
.32663 .2559 Mdot
.32669 .2559 Mdot
.32675 .28488 Mdot
.32681 .3404 Mdot
.32687 .39834 Mdot
.32693 .41041 Mdot
.32699 .40076 Mdot
.32705 .39834 Mdot
.32711 .38869 Mdot
.32717 .36937 Mdot
.32723 .36696 Mdot
.32729 .36454 Mdot
.32735 .36454 Mdot
.32741 .35972 Mdot
.32747 .31626 Mdot
.32753 .24866 Mdot
.32759 .22452 Mdot
.32765 .23901 Mdot
.32771 .26798 Mdot
.32777 .2897 Mdot
.32783 .26556 Mdot
.32789 .21486 Mdot
.32795 .20038 Mdot
.32801 .21969 Mdot
.32807 .2559 Mdot
.32813 .30177 Mdot
.32819 .3235 Mdot
.32825 .31626 Mdot
.32831 .31626 Mdot
.32837 .31626 Mdot
.32843 .32109 Mdot
.32849 .34764 Mdot
.32855 .37903 Mdot
.32861 .39351 Mdot
.32867 .39593 Mdot
.32873 .36937 Mdot
.32879 .31626 Mdot
.32885 .2897 Mdot
.32891 .30177 Mdot
.32897 .33074 Mdot
.32903 .35489 Mdot
.32909 .3404 Mdot
.32915 .28729 Mdot
.32921 .2559 Mdot
.32927 .27039 Mdot
.32933 .30177 Mdot
.32939 .33316 Mdot
.32945 .33799 Mdot
.32951 .3066 Mdot
.32957 .28246 Mdot
.32963 .27039 Mdot
.32969 .25108 Mdot
.32975 .24866 Mdot
.32981 .27039 Mdot
.32987 .28729 Mdot
.32993 .2897 Mdot
.32999 .2728 Mdot
.33005 .23418 Mdot
.33011 .22693 Mdot
.33017 .27763 Mdot
.33023 .34282 Mdot
.33029 .38627 Mdot
.33035 .3911 Mdot
.33041 .35972 Mdot
.33047 .33799 Mdot
.33053 .3573 Mdot
.33059 .38627 Mdot
.33065 .408 Mdot
.33071 .41283 Mdot
.33077 .38627 Mdot
.33083 .34764 Mdot
.33089 .31867 Mdot
.33095 .2897 Mdot
.33101 .27522 Mdot
.33107 .28246 Mdot
.33113 .28246 Mdot
.33119 .26073 Mdot
.33125 .22935 Mdot
.33131 .18831 Mdot
.33137 .16175 Mdot
.33143 .19072 Mdot
.33149 .24383 Mdot
.33155 .28488 Mdot
.33161 .30419 Mdot
.33167 .28729 Mdot
.33173 .26556 Mdot
.33179 .29695 Mdot
.33185 .35972 Mdot
.33191 .41041 Mdot
.33197 .43697 Mdot
.33203 .42731 Mdot
.33209 .39593 Mdot
.33215 .38144 Mdot
.33221 .36937 Mdot
.33227 .35247 Mdot
.33233 .35006 Mdot
.33239 .35247 Mdot
.33245 .33557 Mdot
.33251 .30419 Mdot
.33257 .25832 Mdot
.33263 .21728 Mdot
.33269 .22935 Mdot
.33275 .27763 Mdot
.33281 .30419 Mdot
.33287 .29212 Mdot
.33293 .2559 Mdot
.33299 .21728 Mdot
.33305 .22693 Mdot
.33311 .27039 Mdot
.33317 .30177 Mdot
.33323 .31626 Mdot
.33329 .31626 Mdot
.33335 .29453 Mdot
.33341 .28729 Mdot
.33347 .29936 Mdot
.33353 .31385 Mdot
.33359 .34523 Mdot
.33365 .38144 Mdot
.33371 .38627 Mdot
.33377 .36696 Mdot
.33383 .3404 Mdot
.33389 .31385 Mdot
.33395 .32109 Mdot
.33401 .36213 Mdot
.33407 .38386 Mdot
.33413 .36937 Mdot
.33419 .32833 Mdot
.33425 .27763 Mdot
.33431 .26315 Mdot
.33437 .29695 Mdot
.33443 .3235 Mdot
.33449 .32109 Mdot
.33455 .29695 Mdot
.33461 .2559 Mdot
.33467 .22935 Mdot
.33473 .22935 Mdot
.33479 .23418 Mdot
.33485 .24625 Mdot
.33491 .27522 Mdot
.33497 .2897 Mdot
.33503 .27763 Mdot
.33509 .26073 Mdot
.33515 .25108 Mdot
.33521 .28005 Mdot
.33527 .34764 Mdot
.33533 .40317 Mdot
.33539 .40317 Mdot
.33545 .37661 Mdot
.33551 .34764 Mdot
.33557 .34282 Mdot
.33563 .37179 Mdot
.33569 .39834 Mdot
.33575 .3911 Mdot
.33581 .37179 Mdot
.33587 .3404 Mdot
.33593 .30419 Mdot
.33599 .28729 Mdot
.33605 .28729 Mdot
.33611 .29212 Mdot
.33617 .30177 Mdot
.33623 .29453 Mdot
.33629 .2559 Mdot
.33635 .21486 Mdot
.33641 .19555 Mdot
.33647 .20038 Mdot
.33653 .23659 Mdot
.33659 .28005 Mdot
.33665 .28488 Mdot
.33671 .26556 Mdot
.33677 .25108 Mdot
.33683 .2559 Mdot
.33689 .30902 Mdot
.33695 .37903 Mdot
.33701 .41283 Mdot
.33707 .41283 Mdot
.33713 .39834 Mdot
.33719 .37903 Mdot
.33725 .37661 Mdot
.33731 .38869 Mdot
.33737 .38627 Mdot
.33743 .37903 Mdot
.33749 .37179 Mdot
.33755 .33799 Mdot
.33761 .28729 Mdot
.33767 .25108 Mdot
.33773 .23901 Mdot
.33779 .25832 Mdot
.33785 .2897 Mdot
.33791 .28005 Mdot
.33797 .23418 Mdot
.33803 .19796 Mdot
.33809 .19314 Mdot
.33815 .23176 Mdot
.33821 .28729 Mdot
.33827 .31143 Mdot
.33833 .3066 Mdot
.33839 .30177 Mdot
.33845 .29695 Mdot
.33851 .30419 Mdot
.33857 .33557 Mdot
.33863 .36937 Mdot
.33869 .38869 Mdot
.33875 .40076 Mdot
.33881 .38386 Mdot
.33887 .34523 Mdot
.33893 .31867 Mdot
.33899 .31626 Mdot
.33905 .33316 Mdot
.33911 .35972 Mdot
.33917 .3573 Mdot
.33923 .31385 Mdot
.33929 .2728 Mdot
.33935 .26073 Mdot
.33941 .28246 Mdot
.33947 .32833 Mdot
.33953 .34523 Mdot
.33959 .32109 Mdot
.33965 .28488 Mdot
.33971 .26073 Mdot
.33977 .24866 Mdot
.33983 .25832 Mdot
.33989 .27039 Mdot
.33995 .27522 Mdot
.34001 .28246 Mdot
.34007 .27763 Mdot
.34013 .24383 Mdot
.34019 .22693 Mdot
.34025 .25108 Mdot
.34031 .3066 Mdot
.34037 .36454 Mdot
.34043 .3911 Mdot
.34049 .36696 Mdot
.34055 .3404 Mdot
.34061 .34523 Mdot
.34067 .37661 Mdot
.34073 .41041 Mdot
.34079 .42248 Mdot
.34085 .39834 Mdot
.34091 .35972 Mdot
.34097 .33074 Mdot
.34103 .30419 Mdot
.34109 .29695 Mdot
.34115 .30177 Mdot
.34121 .29695 Mdot
.34127 .27763 Mdot
.34133 .24866 Mdot
.34139 .20521 Mdot
.34145 .17382 Mdot
.34151 .18348 Mdot
.34157 .21728 Mdot
.34163 .25832 Mdot
.34169 .28488 Mdot
.34175 .2728 Mdot
.34181 .25349 Mdot
.34187 .26798 Mdot
.34193 .31867 Mdot
.34199 .38386 Mdot
.34205 .43214 Mdot
.34211 .43214 Mdot
.34217 .40317 Mdot
.34223 .38386 Mdot
.34229 .37661 Mdot
.34235 .3742 Mdot
.34241 .3742 Mdot
.34247 .36213 Mdot
.34253 .34282 Mdot
.34259 .31867 Mdot
.34265 .27763 Mdot
.34271 .23418 Mdot
.34277 .23176 Mdot
.34283 .26073 Mdot
.34289 .29453 Mdot
.34295 .30419 Mdot
.34301 .2728 Mdot
.34307 .22693 Mdot
.34313 .21728 Mdot
.34319 .25108 Mdot
.34325 .29212 Mdot
.34331 .31867 Mdot
.34337 .31626 Mdot
.34343 .29212 Mdot
.34349 .28005 Mdot
.34355 .28488 Mdot
.34361 .3066 Mdot
.34367 .33799 Mdot
.34373 .36696 Mdot
.34379 .37661 Mdot
.34385 .36696 Mdot
.34391 .34523 Mdot
.34397 .32109 Mdot
.34403 .31867 Mdot
.34409 .34282 Mdot
.34415 .36696 Mdot
.34421 .37179 Mdot
.34427 .34282 Mdot
.34433 .29212 Mdot
.34439 .26556 Mdot
.34445 .28488 Mdot
.34451 .32109 Mdot
.34457 .33799 Mdot
.34463 .32109 Mdot
.34469 .27522 Mdot
.34475 .23901 Mdot
.34481 .23418 Mdot
.34487 .24383 Mdot
.34493 .2559 Mdot
.34499 .26798 Mdot
.34505 .27522 Mdot
.34511 .27522 Mdot
.34517 .26315 Mdot
.34523 .24866 Mdot
.34529 .26073 Mdot
.34535 .31143 Mdot
.34541 .37179 Mdot
.34547 .39593 Mdot
.34553 .38144 Mdot
.34559 .34764 Mdot
.34565 .33074 Mdot
.34571 .3573 Mdot
.34577 .38869 Mdot
.34583 .39834 Mdot
.34589 .37903 Mdot
.34595 .34282 Mdot
.34601 .30902 Mdot
.34607 .29453 Mdot
.34613 .29212 Mdot
.34619 .29453 Mdot
.34625 .30177 Mdot
.34631 .29936 Mdot
.34637 .27522 Mdot
.34643 .23901 Mdot
.34649 .20762 Mdot
.34655 .20038 Mdot
.34661 .22693 Mdot
.34667 .26315 Mdot
.34673 .28488 Mdot
.34679 .27522 Mdot
.34685 .25349 Mdot
.34691 .24383 Mdot
.34697 .28005 Mdot
.34703 .34282 Mdot
.34709 .39351 Mdot
.34715 .41041 Mdot
.34721 .39834 Mdot
.34727 .37661 Mdot
.34733 .37179 Mdot
.34739 .38144 Mdot
.34745 .38627 Mdot
.34751 .38144 Mdot
.34757 .36937 Mdot
.34763 .34764 Mdot
.34769 .3066 Mdot
.34775 .26556 Mdot
.34781 .23901 Mdot
.34787 .24866 Mdot
.34793 .28005 Mdot
.34799 .29212 Mdot
.34805 .26556 Mdot
.34811 .21969 Mdot
.34817 .19555 Mdot
.34823 .21486 Mdot
.34829 .26315 Mdot
.34835 .30177 Mdot
.34841 .30902 Mdot
.34847 .30177 Mdot
.34853 .29453 Mdot
.34859 .29695 Mdot
.34865 .31867 Mdot
.34871 .35006 Mdot
.34877 .3742 Mdot
.34883 .3911 Mdot
.34889 .38869 Mdot
.34895 .35972 Mdot
.34901 .32833 Mdot
.34907 .31385 Mdot
.34913 .32109 Mdot
.34919 .34282 Mdot
.34925 .35247 Mdot
.34931 .33316 Mdot
.34937 .29212 Mdot
.34943 .26073 Mdot
.34949 .26556 Mdot
.34955 .30419 Mdot
.34961 .3404 Mdot
.34967 .34282 Mdot
.34973 .31385 Mdot
.34979 .27763 Mdot
.34985 .26073 Mdot
.34991 .26315 Mdot
.34997 .27039 Mdot
.35003 .2728 Mdot
.35009 .27522 Mdot
.35015 .27522 Mdot
.35021 .25832 Mdot
.35027 .23418 Mdot
.35033 .23176 Mdot
.35039 .26073 Mdot
.35045 .32109 Mdot
.35051 .3742 Mdot
.35057 .38144 Mdot
.35063 .35247 Mdot
.35069 .33557 Mdot
.35075 .35489 Mdot
.35081 .39593 Mdot
.35087 .42248 Mdot
.35093 .41524 Mdot
.35099 .38386 Mdot
.35105 .35006 Mdot
.35111 .32109 Mdot
.35117 .30419 Mdot
.35123 .29695 Mdot
.35129 .29695 Mdot
.35135 .2897 Mdot
.35141 .27039 Mdot
.35147 .22935 Mdot
.35153 .18831 Mdot
.35159 .17382 Mdot
.35165 .19314 Mdot
.35171 .23418 Mdot
.35177 .27039 Mdot
.35183 .27763 Mdot
.35189 .26073 Mdot
.35195 .2559 Mdot
.35201 .28729 Mdot
.35207 .34523 Mdot
.35213 .40558 Mdot
.35219 .42973 Mdot
.35225 .41766 Mdot
.35231 .3911 Mdot
.35237 .37661 Mdot
.35243 .3742 Mdot
.35249 .37661 Mdot
.35255 .36937 Mdot
.35261 .35247 Mdot
.35267 .33316 Mdot
.35273 .30177 Mdot
.35279 .25832 Mdot
.35285 .23176 Mdot
.35291 .24142 Mdot
.35297 .27763 Mdot
.35303 .3066 Mdot
.35309 .29695 Mdot
.35315 .25349 Mdot
.35321 .22211 Mdot
.35327 .23176 Mdot
.35333 .2728 Mdot
.35339 .30902 Mdot
.35345 .31867 Mdot
.35351 .30177 Mdot
.35357 .28005 Mdot
.35363 .27522 Mdot
.35369 .28488 Mdot
.35375 .31143 Mdot
.35381 .3404 Mdot
.35387 .36213 Mdot
.35393 .36454 Mdot
.35399 .35247 Mdot
.35405 .32833 Mdot
.35411 .31626 Mdot
.35417 .33316 Mdot
.35423 .35972 Mdot
.35429 .37903 Mdot
.35435 .37179 Mdot
.35441 .32833 Mdot
.35447 .28488 Mdot
.35453 .27763 Mdot
.35459 .30419 Mdot
.35465 .33557 Mdot
.35471 .3404 Mdot
.35477 .3066 Mdot
.35483 .26073 Mdot
.35489 .23418 Mdot
.35495 .23659 Mdot
.35501 .24625 Mdot
.35507 .25832 Mdot
.35513 .26315 Mdot
.35519 .26315 Mdot
.35525 .26073 Mdot
.35531 .24866 Mdot
.35537 .24625 Mdot
.35543 .27522 Mdot
.35549 .33316 Mdot
.35555 .38144 Mdot
.35561 .3911 Mdot
.35567 .36454 Mdot
.35573 .33557 Mdot
.35579 .34282 Mdot
.35585 .37661 Mdot
.35591 .40317 Mdot
.35597 .40076 Mdot
.35603 .36937 Mdot
.35609 .33074 Mdot
.35615 .3066 Mdot
.35621 .29936 Mdot
.35627 .29936 Mdot
.35633 .30419 Mdot
.35639 .30419 Mdot
.35645 .2897 Mdot
.35651 .25832 Mdot
.35657 .22211 Mdot
.35663 .20279 Mdot
.35669 .21003 Mdot
.35675 .24383 Mdot
.35681 .2728 Mdot
.35687 .27763 Mdot
.35693 .2559 Mdot
.35699 .23659 Mdot
.35705 .25349 Mdot
.35711 .3066 Mdot
.35717 .36696 Mdot
.35723 .40076 Mdot
.35729 .39834 Mdot
.35735 .37661 Mdot
.35741 .36696 Mdot
.35747 .3742 Mdot
.35753 .38627 Mdot
.35759 .3911 Mdot
.35765 .38144 Mdot
.35771 .36213 Mdot
.35777 .32833 Mdot
.35783 .2897 Mdot
.35789 .2559 Mdot
.35795 .25108 Mdot
.35801 .2728 Mdot
.35807 .29453 Mdot
.35813 .28488 Mdot
.35819 .24383 Mdot
.35825 .20521 Mdot
.35831 .20279 Mdot
.35837 .24142 Mdot
.35843 .28729 Mdot
.35849 .30902 Mdot
.35855 .30177 Mdot
.35861 .28246 Mdot
.35867 .28246 Mdot
.35873 .30177 Mdot
.35879 .33074 Mdot
.35885 .35972 Mdot
.35891 .38144 Mdot
.35897 .38386 Mdot
.35903 .36454 Mdot
.35909 .33557 Mdot
.35915 .31867 Mdot
.35921 .32109 Mdot
.35927 .3404 Mdot
.35933 .3573 Mdot
.35939 .34764 Mdot
.35945 .31143 Mdot
.35951 .27522 Mdot
.35957 .26556 Mdot
.35963 .29212 Mdot
.35969 .33316 Mdot
.35975 .34764 Mdot
.35981 .32833 Mdot
.35987 .28729 Mdot
.35993 .26073 Mdot
.35999 .26073 Mdot
.36005 .27522 Mdot
.36011 .28246 Mdot
.36017 .28005 Mdot
.36023 .2728 Mdot
.36029 .25832 Mdot
.36035 .24142 Mdot
.36041 .23418 Mdot
.36047 .24866 Mdot
.36053 .29453 Mdot
.36059 .34764 Mdot
.36065 .37179 Mdot
.36071 .3573 Mdot
.36077 .33074 Mdot
.36083 .33316 Mdot
.36089 .3742 Mdot
.36095 .41766 Mdot
.36101 .42731 Mdot
.36107 .39834 Mdot
.36113 .3573 Mdot
.36119 .33074 Mdot
.36125 .32109 Mdot
.36131 .31867 Mdot
.36137 .31385 Mdot
.36143 .30419 Mdot
.36149 .28488 Mdot
.36155 .25349 Mdot
.36161 .21245 Mdot
.36167 .18589 Mdot
.36173 .18831 Mdot
.36179 .21728 Mdot
.36185 .2559 Mdot
.36191 .2728 Mdot
.36197 .26073 Mdot
.36203 .24625 Mdot
.36209 .26315 Mdot
.36215 .31385 Mdot
.36221 .37903 Mdot
.36227 .42007 Mdot
.36233 .41766 Mdot
.36239 .39593 Mdot
.36245 .37661 Mdot
.36251 .37661 Mdot
.36257 .38627 Mdot
.36263 .38627 Mdot
.36269 .36937 Mdot
.36275 .34523 Mdot
.36281 .31385 Mdot
.36287 .28005 Mdot
.36293 .25108 Mdot
.36299 .24383 Mdot
.36305 .26315 Mdot
.36311 .29212 Mdot
.36317 .29936 Mdot
.36323 .27039 Mdot
.36329 .23176 Mdot
.36335 .22452 Mdot
.36341 .2559 Mdot
.36347 .30177 Mdot
.36353 .3235 Mdot
.36359 .31143 Mdot
.36365 .28729 Mdot
.36371 .2728 Mdot
.36377 .28246 Mdot
.36383 .30902 Mdot
.36389 .33799 Mdot
.36395 .3573 Mdot
.36401 .36213 Mdot
.36407 .35247 Mdot
.36413 .33316 Mdot
.36419 .32109 Mdot
.36425 .32833 Mdot
.36431 .35006 Mdot
.36437 .37179 Mdot
.36443 .37179 Mdot
.36449 .34282 Mdot
.36455 .3066 Mdot
.36461 .28488 Mdot
.36467 .29936 Mdot
.36473 .33074 Mdot
.36479 .34764 Mdot
.36485 .32833 Mdot
.36491 .28246 Mdot
.36497 .24383 Mdot
.36503 .23418 Mdot
.36509 .24866 Mdot
.36515 .26556 Mdot
.36521 .27039 Mdot
.36527 .26315 Mdot
.36533 .25108 Mdot
.36539 .24625 Mdot
.36545 .25349 Mdot
.36551 .27039 Mdot
.36557 .30419 Mdot
.36563 .35247 Mdot
.36569 .38627 Mdot
.36575 .37903 Mdot
.36581 .35247 Mdot
.36587 .3404 Mdot
.36593 .36454 Mdot
.36599 .40076 Mdot
.36605 .41524 Mdot
.36611 .38869 Mdot
.36617 .34523 Mdot
.36623 .30902 Mdot
.36629 .29936 Mdot
.36635 .30419 Mdot
.36641 .31143 Mdot
.36647 .30902 Mdot
.36653 .29212 Mdot
.36659 .26798 Mdot
.36665 .23901 Mdot
.36671 .21486 Mdot
.36677 .21486 Mdot
.36683 .23659 Mdot
.36689 .26556 Mdot
.36695 .27763 Mdot
.36701 .26556 Mdot
.36706 .24383 Mdot
.36712 .24383 Mdot
.36718 .28246 Mdot
.36724 .3404 Mdot
.3673 .38869 Mdot
.36736 .39834 Mdot
.36742 .38144 Mdot
.36748 .36213 Mdot
.36754 .36454 Mdot
.3676 .38386 Mdot
.36766 .40076 Mdot
.36772 .39593 Mdot
.36778 .37179 Mdot
.36784 .3404 Mdot
.3679 .3066 Mdot
.36796 .28005 Mdot
.36802 .26556 Mdot
.36808 .2728 Mdot
.36814 .29212 Mdot
.3682 .29453 Mdot
.36826 .26556 Mdot
.36832 .22211 Mdot
.36838 .20038 Mdot
.36844 .22211 Mdot
.3685 .26556 Mdot
.36856 .29936 Mdot
.36862 .29936 Mdot
.36868 .28005 Mdot
.36874 .27039 Mdot
.3688 .28246 Mdot
.36886 .31626 Mdot
.36892 .35247 Mdot
.36898 .37661 Mdot
.36904 .38627 Mdot
.3691 .3742 Mdot
.36916 .35489 Mdot
.36922 .33799 Mdot
.36928 .33557 Mdot
.36934 .34764 Mdot
.3694 .35972 Mdot
.36946 .35489 Mdot
.36952 .32592 Mdot
.36958 .28729 Mdot
.36964 .26556 Mdot
.3697 .27763 Mdot
.36976 .31143 Mdot
.36982 .3404 Mdot
.36988 .33316 Mdot
.36994 .29936 Mdot
.37 .26315 Mdot
.37006 .25349 Mdot
.37012 .27039 Mdot
.37018 .2897 Mdot
.37024 .29212 Mdot
.3703 .27763 Mdot
.37036 .25832 Mdot
.37042 .24383 Mdot
.37048 .24142 Mdot
.37054 .25108 Mdot
.3706 .28005 Mdot
.37066 .3235 Mdot
.37072 .35489 Mdot
.37078 .36213 Mdot
.37084 .3404 Mdot
.3709 .32833 Mdot
.37096 .35006 Mdot
.37102 .39834 Mdot
.37108 .42731 Mdot
.37114 .41524 Mdot
.3712 .36937 Mdot
.37126 .33074 Mdot
.37132 .31867 Mdot
.37138 .32592 Mdot
.37144 .33074 Mdot
.3715 .31867 Mdot
.37156 .29453 Mdot
.37162 .26315 Mdot
.37168 .22935 Mdot
.37174 .20279 Mdot
.3718 .19314 Mdot
.37186 .21003 Mdot
.37192 .23901 Mdot
.37198 .25832 Mdot
.37204 .2559 Mdot
.3721 .23901 Mdot
.37216 .24142 Mdot
.37222 .28005 Mdot
.37228 .34282 Mdot
.37234 .39834 Mdot
.3724 .41766 Mdot
.37246 .40317 Mdot
.37252 .37903 Mdot
.37258 .3742 Mdot
.37264 .3911 Mdot
.3727 .40317 Mdot
.37276 .39351 Mdot
.37282 .36213 Mdot
.37288 .32592 Mdot
.37294 .29212 Mdot
.373 .26556 Mdot
.37306 .25349 Mdot
.37312 .25832 Mdot
.37318 .27522 Mdot
.37324 .28729 Mdot
.3733 .27522 Mdot
.37336 .24383 Mdot
.37342 .21969 Mdot
.37348 .23418 Mdot
.37354 .27763 Mdot
.3736 .31867 Mdot
.37366 .31867 Mdot
.37372 .29212 Mdot
.37378 .26798 Mdot
.37384 .2728 Mdot
.3739 .30177 Mdot
.37396 .33316 Mdot
.37402 .35247 Mdot
.37408 .35489 Mdot
.37414 .34764 Mdot
.3742 .33799 Mdot
.37426 .32833 Mdot
.37432 .32833 Mdot
.37438 .34282 Mdot
.37444 .36454 Mdot
.3745 .37179 Mdot
.37456 .35006 Mdot
.37462 .31385 Mdot
.37468 .28729 Mdot
.37474 .29212 Mdot
.3748 .31867 Mdot
.37486 .34282 Mdot
.37492 .33799 Mdot
.37498 .30177 Mdot
.37504 .25832 Mdot
.3751 .23659 Mdot
.37516 .24625 Mdot
.37522 .26556 Mdot
.37528 .2728 Mdot
.37534 .26315 Mdot
.3754 .24625 Mdot
.37546 .23659 Mdot
.37552 .23901 Mdot
.37558 .25349 Mdot
.37564 .28488 Mdot
.3757 .32592 Mdot
.37576 .36213 Mdot
.37582 .3742 Mdot
.37588 .35972 Mdot
.37594 .34282 Mdot
.376 .35247 Mdot
.37606 .38869 Mdot
.37612 .41766 Mdot
.37618 .41041 Mdot
.37624 .36696 Mdot
.3763 .32109 Mdot
.37636 .30177 Mdot
.37642 .3066 Mdot
.37648 .31626 Mdot
.37654 .31143 Mdot
.3766 .29453 Mdot
.37666 .27039 Mdot
.37672 .24625 Mdot
.37678 .22452 Mdot
.37684 .21486 Mdot
.3769 .22452 Mdot
.37696 .24866 Mdot
.37702 .27039 Mdot
.37708 .27039 Mdot
.37714 .25108 Mdot
.3772 .23901 Mdot
.37726 .25832 Mdot
.37732 .31143 Mdot
.37738 .36454 Mdot
.37744 .3911 Mdot
.3775 .38386 Mdot
.37756 .36454 Mdot
.37762 .35972 Mdot
.37768 .3742 Mdot
.37774 .39593 Mdot
.3778 .40076 Mdot
.37786 .38386 Mdot
.37792 .35006 Mdot
.37798 .31867 Mdot
.37804 .29453 Mdot
.3781 .27522 Mdot
.37816 .27039 Mdot
.37822 .28005 Mdot
.37828 .29212 Mdot
.37834 .28246 Mdot
.3784 .25108 Mdot
.37846 .21486 Mdot
.37852 .21003 Mdot
.37858 .24625 Mdot
.37864 .2897 Mdot
.3787 .30419 Mdot
.37876 .2897 Mdot
.37882 .26556 Mdot
.37888 .26556 Mdot
.37894 .29453 Mdot
.379 .33074 Mdot
.37906 .35489 Mdot
.37912 .36454 Mdot
.37918 .36696 Mdot
.37924 .36213 Mdot
.3793 .34764 Mdot
.37936 .33316 Mdot
.37942 .33557 Mdot
.37948 .35247 Mdot
.37954 .36454 Mdot
.3796 .35247 Mdot
.37966 .31626 Mdot
.37972 .27763 Mdot
.37978 .27039 Mdot
.37984 .29453 Mdot
.3799 .32592 Mdot
.37996 .33799 Mdot
.38002 .31867 Mdot
.38008 .28488 Mdot
.38014 .26073 Mdot
.3802 .26073 Mdot
.38026 .27522 Mdot
.38032 .28729 Mdot
.38038 .28488 Mdot
.38044 .27039 Mdot
.3805 .25349 Mdot
.38056 .24142 Mdot
.38062 .23901 Mdot
.38068 .25349 Mdot
.38074 .28729 Mdot
.3808 .32833 Mdot
.38086 .35247 Mdot
.38092 .34764 Mdot
.38098 .33316 Mdot
.38104 .33316 Mdot
.3811 .36696 Mdot
.38116 .41041 Mdot
.38122 .4249 Mdot
.38128 .40317 Mdot
.38134 .36213 Mdot
.3814 .33316 Mdot
.38146 .32833 Mdot
.38152 .32833 Mdot
.38158 .3235 Mdot
.38164 .30902 Mdot
.3817 .28488 Mdot
.38176 .2559 Mdot
.38182 .22452 Mdot
.38188 .20038 Mdot
.38194 .19314 Mdot
.382 .21486 Mdot
.38206 .24383 Mdot
.38212 .25832 Mdot
.38218 .25108 Mdot
.38224 .23901 Mdot
.3823 .24866 Mdot
.38236 .29695 Mdot
.38242 .35972 Mdot
.38248 .40076 Mdot
.38254 .408 Mdot
.3826 .39351 Mdot
.38266 .37903 Mdot
.38272 .37903 Mdot
.38278 .3911 Mdot
.38284 .39593 Mdot
.3829 .38386 Mdot
.38296 .35489 Mdot
.38302 .32109 Mdot
.38308 .28729 Mdot
.38314 .26073 Mdot
.3832 .25108 Mdot
.38326 .25832 Mdot
.38332 .27763 Mdot
.38338 .28729 Mdot
.38344 .26798 Mdot
.3835 .23659 Mdot
.38356 .22211 Mdot
.38362 .24625 Mdot
.38368 .29212 Mdot
.38374 .3235 Mdot
.3838 .31626 Mdot
.38386 .2897 Mdot
.38392 .2728 Mdot
.38398 .28246 Mdot
.38404 .30902 Mdot
.3841 .33074 Mdot
.38416 .34282 Mdot
.38422 .34764 Mdot
.38428 .34523 Mdot
.38434 .33316 Mdot
.3844 .32109 Mdot
.38446 .32109 Mdot
.38452 .3404 Mdot
.38458 .36454 Mdot
.38464 .37179 Mdot
.3847 .35006 Mdot
.38476 .31143 Mdot
.38482 .29212 Mdot
.38488 .30419 Mdot
.38494 .33316 Mdot
.385 .35006 Mdot
.38506 .33316 Mdot
.38512 .29453 Mdot
.38518 .25832 Mdot
.38524 .24383 Mdot
.3853 .24866 Mdot
.38536 .26073 Mdot
.38542 .26556 Mdot
.38548 .25832 Mdot
.38554 .24625 Mdot
.3856 .23901 Mdot
.38566 .23901 Mdot
.38572 .24866 Mdot
.38578 .28005 Mdot
.38584 .32833 Mdot
.3859 .36696 Mdot
.38596 .3742 Mdot
.38602 .3573 Mdot
.38608 .34523 Mdot
.38614 .36454 Mdot
.3862 .40076 Mdot
.38626 .42248 Mdot
.38632 .40558 Mdot
.38638 .36213 Mdot
.38644 .3235 Mdot
.3865 .3066 Mdot
.38656 .30902 Mdot
.38662 .31143 Mdot
.38668 .30177 Mdot
.38674 .28488 Mdot
.3868 .26556 Mdot
.38686 .24142 Mdot
.38692 .21486 Mdot
.38698 .20521 Mdot
.38704 .22211 Mdot
.3871 .2559 Mdot
.38716 .27763 Mdot
.38722 .2728 Mdot
.38728 .25108 Mdot
.38734 .24625 Mdot
.3874 .27763 Mdot
.38746 .33074 Mdot
.38752 .37661 Mdot
.38758 .3911 Mdot
.38764 .37903 Mdot
.3877 .36696 Mdot
.38776 .36454 Mdot
.38782 .3742 Mdot
.38788 .38627 Mdot
.38794 .38627 Mdot
.388 .37179 Mdot
.38806 .34523 Mdot
.38812 .31385 Mdot
.38818 .28246 Mdot
.38824 .26556 Mdot
.3883 .27039 Mdot
.38836 .28729 Mdot
.38842 .29695 Mdot
.38848 .28005 Mdot
.38854 .24383 Mdot
.3886 .21728 Mdot
.38866 .22211 Mdot
.38872 .25832 Mdot
.38878 .29695 Mdot
.38884 .30419 Mdot
.3889 .28729 Mdot
.38896 .26798 Mdot
.38902 .2728 Mdot
.38908 .29695 Mdot
.38914 .32833 Mdot
.3892 .35006 Mdot
.38926 .35972 Mdot
.38932 .36213 Mdot
.38938 .3573 Mdot
.38944 .3404 Mdot
.3895 .32833 Mdot
.38956 .33557 Mdot
.38962 .3573 Mdot
.38968 .36937 Mdot
.38974 .35247 Mdot
.3898 .31143 Mdot
.38986 .27763 Mdot
.38992 .28005 Mdot
.38998 .31143 Mdot
.39004 .33557 Mdot
.3901 .33074 Mdot
.39016 .30177 Mdot
.39022 .27039 Mdot
.39028 .25832 Mdot
.39034 .25832 Mdot
.3904 .27039 Mdot
.39046 .27763 Mdot
.39052 .27763 Mdot
.39058 .27039 Mdot
.39064 .2559 Mdot
.3907 .24142 Mdot
.39076 .24383 Mdot
.39082 .26798 Mdot
.39088 .30902 Mdot
.39094 .34523 Mdot
.391 .3573 Mdot
.39106 .34282 Mdot
.39112 .32833 Mdot
.39118 .3404 Mdot
.39124 .37903 Mdot
.3913 .41283 Mdot
.39136 .41524 Mdot
.39142 .38627 Mdot
.39148 .34523 Mdot
.39154 .32592 Mdot
.3916 .3235 Mdot
.39166 .32592 Mdot
.39172 .32109 Mdot
.39178 .30419 Mdot
.39184 .28246 Mdot
.3919 .25108 Mdot
.39196 .21969 Mdot
.39202 .19796 Mdot
.39208 .20038 Mdot
.39214 .22935 Mdot
.3922 .25832 Mdot
.39226 .26556 Mdot
.39232 .24866 Mdot
.39238 .23901 Mdot
.39244 .26073 Mdot
.3925 .31143 Mdot
.39256 .36696 Mdot
.39262 .39834 Mdot
.39268 .39593 Mdot
.39274 .38386 Mdot
.3928 .3742 Mdot
.39286 .37661 Mdot
.39292 .38627 Mdot
.39298 .38869 Mdot
.39304 .37903 Mdot
.3931 .35489 Mdot
.39316 .31867 Mdot
.39322 .28488 Mdot
.39328 .26073 Mdot
.39334 .25832 Mdot
.3934 .2728 Mdot
.39346 .28729 Mdot
.39352 .28488 Mdot
.39358 .25832 Mdot
.39364 .22935 Mdot
.3937 .22693 Mdot
.39376 .25349 Mdot
.39382 .29212 Mdot
.39388 .31626 Mdot
.39394 .3066 Mdot
.394 .28488 Mdot
.39406 .27522 Mdot
.39412 .28729 Mdot
.39418 .31385 Mdot
.39424 .33799 Mdot
.3943 .35006 Mdot
.39436 .35247 Mdot
.39442 .34523 Mdot
.39448 .33074 Mdot
.39454 .31867 Mdot
.3946 .32592 Mdot
.39466 .34764 Mdot
.39472 .36454 Mdot
.39478 .36213 Mdot
.39484 .33557 Mdot
.3949 .3066 Mdot
.39496 .29453 Mdot
.39502 .31143 Mdot
.39508 .33557 Mdot
.39514 .34282 Mdot
.3952 .3235 Mdot
.39526 .28488 Mdot
.39532 .2559 Mdot
.39538 .24383 Mdot
.39544 .24866 Mdot
.3955 .26315 Mdot
.39556 .27039 Mdot
.39562 .26315 Mdot
.39568 .24866 Mdot
.39574 .23659 Mdot
.3958 .23901 Mdot
.39586 .26315 Mdot
.39592 .30177 Mdot
.39598 .34282 Mdot
.39604 .36696 Mdot
.3961 .36213 Mdot
.39616 .34764 Mdot
.39622 .34523 Mdot
.39628 .36696 Mdot
.39634 .40076 Mdot
.3964 .41524 Mdot
.39646 .39593 Mdot
.39652 .35247 Mdot
.39658 .31626 Mdot
.39664 .30419 Mdot
.3967 .3066 Mdot
.39676 .31143 Mdot
.39682 .30419 Mdot
.39688 .28729 Mdot
.39694 .26315 Mdot
.397 .23659 Mdot
.39706 .21486 Mdot
.39712 .21245 Mdot
.39718 .23659 Mdot
.39724 .26798 Mdot
.3973 .28246 Mdot
.39736 .26798 Mdot
.39742 .24866 Mdot
.39748 .25349 Mdot
.39754 .28729 Mdot
.3976 .33799 Mdot
.39766 .37903 Mdot
.39772 .38386 Mdot
.39778 .36937 Mdot
.39784 .3573 Mdot
.3979 .3573 Mdot
.39796 .36937 Mdot
.39802 .38386 Mdot
.39808 .38386 Mdot
.39814 .36696 Mdot
.3982 .3404 Mdot
.39826 .3066 Mdot
.39832 .28005 Mdot
.39838 .27039 Mdot
.39844 .28246 Mdot
.3985 .29936 Mdot
.39856 .29936 Mdot
.39862 .27522 Mdot
.39868 .23901 Mdot
.39874 .21969 Mdot
.3988 .23176 Mdot
.39886 .26798 Mdot
.39892 .29695 Mdot
.39898 .29936 Mdot
.39904 .28005 Mdot
.3991 .26556 Mdot
.39916 .27522 Mdot
.39922 .29695 Mdot
.39928 .32833 Mdot
.39934 .35247 Mdot
.3994 .36454 Mdot
.39946 .36213 Mdot
.39952 .34764 Mdot
.39958 .32833 Mdot
.39964 .32833 Mdot
.3997 .34764 Mdot
.39976 .36696 Mdot
.39982 .36696 Mdot
.39988 .3404 Mdot
.39994 .29936 Mdot
.4 .28005 Mdot
.40006 .29212 Mdot
.40012 .31626 Mdot
.40018 .33316 Mdot
.40024 .32592 Mdot
.4003 .29695 Mdot
.40036 .27039 Mdot
.40042 .25832 Mdot
.40048 .25832 Mdot
.40054 .26798 Mdot
.4006 .28005 Mdot
.40066 .28246 Mdot
.40072 .27039 Mdot
.40078 .25108 Mdot
.40084 .23901 Mdot
.4009 .24625 Mdot
.40096 .28005 Mdot
.40102 .3235 Mdot
.40108 .35006 Mdot
.40114 .35247 Mdot
.4012 .33799 Mdot
.40126 .33074 Mdot
.40132 .35006 Mdot
.40138 .38386 Mdot
.40144 .41041 Mdot
.4015 .40558 Mdot
.40156 .37661 Mdot
.40162 .3404 Mdot
.40168 .32109 Mdot
.40174 .31867 Mdot
.4018 .31867 Mdot
.40186 .31867 Mdot
.40192 .30419 Mdot
.40198 .27763 Mdot
.40204 .24383 Mdot
.4021 .21245 Mdot
.40216 .20038 Mdot
.40222 .21486 Mdot
.40228 .24625 Mdot
.40234 .26798 Mdot
.4024 .26556 Mdot
.40246 .24625 Mdot
.40252 .24383 Mdot
.40258 .2728 Mdot
.40264 .32592 Mdot
.4027 .3742 Mdot
.40276 .3911 Mdot
.40282 .38627 Mdot
.40288 .3742 Mdot
.40294 .36937 Mdot
.403 .37179 Mdot
.40306 .37903 Mdot
.40312 .38144 Mdot
.40318 .37179 Mdot
.40324 .34764 Mdot
.4033 .31143 Mdot
.40336 .27763 Mdot
.40342 .26073 Mdot
.40348 .26556 Mdot
.40354 .28729 Mdot
.4036 .29936 Mdot
.40366 .28729 Mdot
.40372 .25832 Mdot
.40378 .23418 Mdot
.40384 .23901 Mdot
.4039 .27039 Mdot
.40396 .30419 Mdot
.40402 .31626 Mdot
.40408 .30177 Mdot
.40414 .28005 Mdot
.4042 .2728 Mdot
.40426 .28729 Mdot
.40432 .30902 Mdot
.40438 .33074 Mdot
.40444 .34523 Mdot
.4045 .34523 Mdot
.40456 .33799 Mdot
.40462 .3235 Mdot
.40468 .31626 Mdot
.40474 .32833 Mdot
.4048 .35489 Mdot
.40486 .3742 Mdot
.40492 .36454 Mdot
.40498 .33316 Mdot
.40504 .30177 Mdot
.4051 .29695 Mdot
.40516 .31867 Mdot
.40522 .34282 Mdot
.40528 .3404 Mdot
.40534 .31385 Mdot
.4054 .28005 Mdot
.40546 .2559 Mdot
.40552 .24866 Mdot
.40558 .25108 Mdot
.40564 .26073 Mdot
.4057 .27039 Mdot
.40576 .26556 Mdot
.40582 .25108 Mdot
.40588 .23901 Mdot
.40594 .24142 Mdot
.406 .26556 Mdot
.40606 .30902 Mdot
.40612 .35006 Mdot
.40618 .36696 Mdot
.40624 .3573 Mdot
.4063 .34282 Mdot
.40636 .34282 Mdot
.40642 .36937 Mdot
.40648 .39834 Mdot
.40654 .40558 Mdot
.4066 .38144 Mdot
.40666 .34764 Mdot
.40672 .31867 Mdot
.40678 .3066 Mdot
.40684 .3066 Mdot
.4069 .3066 Mdot
.40696 .30419 Mdot
.40702 .29212 Mdot
.40708 .27039 Mdot
.40714 .24142 Mdot
.4072 .21969 Mdot
.40726 .21728 Mdot
.40732 .24383 Mdot
.40738 .27522 Mdot
.40744 .28488 Mdot
.4075 .26798 Mdot
.40756 .24866 Mdot
.40762 .25349 Mdot
.40768 .2897 Mdot
.40774 .33799 Mdot
.4078 .36696 Mdot
.40786 .37179 Mdot
.40792 .36454 Mdot
.40798 .3573 Mdot
.40804 .3573 Mdot
.4081 .36454 Mdot
.40816 .3742 Mdot
.40822 .37661 Mdot
.40828 .36937 Mdot
.40834 .34523 Mdot
.4084 .31143 Mdot
.40846 .28246 Mdot
.40852 .27522 Mdot
.40858 .2897 Mdot
.40864 .30419 Mdot
.4087 .30177 Mdot
.40876 .27522 Mdot
.40882 .24142 Mdot
.40888 .22693 Mdot
.40894 .24142 Mdot
.409 .2728 Mdot
.40906 .29695 Mdot
.40912 .29453 Mdot
.40918 .28005 Mdot
.40924 .27039 Mdot
.4093 .27763 Mdot
.40936 .29936 Mdot
.40942 .32592 Mdot
.40948 .34764 Mdot
.40954 .3573 Mdot
.4096 .35489 Mdot
.40966 .34282 Mdot
.40972 .32592 Mdot
.40978 .3235 Mdot
.40984 .34282 Mdot
.4099 .36696 Mdot
.40996 .36696 Mdot
.41002 .3404 Mdot
.41008 .30419 Mdot
.41014 .28488 Mdot
.4102 .29695 Mdot
.41026 .3235 Mdot
.41032 .33799 Mdot
.41038 .32592 Mdot
.41044 .29936 Mdot
.4105 .27522 Mdot
.41056 .26073 Mdot
.41062 .26073 Mdot
.41068 .27039 Mdot
.41074 .28005 Mdot
.4108 .28005 Mdot
.41086 .26798 Mdot
.41092 .25108 Mdot
.41098 .23659 Mdot
.41104 .24625 Mdot
.4111 .28005 Mdot
.41116 .32109 Mdot
.41122 .34764 Mdot
.41128 .34764 Mdot
.41134 .33557 Mdot
.4114 .33074 Mdot
.41146 .35006 Mdot
.41152 .38627 Mdot
.41158 .408 Mdot
.41164 .40076 Mdot
.4117 .3742 Mdot
.41176 .34523 Mdot
.41182 .32592 Mdot
.41188 .31867 Mdot
.41194 .31626 Mdot
.412 .31143 Mdot
.41206 .30177 Mdot
.41212 .28005 Mdot
.41218 .24625 Mdot
.41224 .21245 Mdot
.4123 .20038 Mdot
.41236 .21969 Mdot
.41242 .25349 Mdot
.41248 .2728 Mdot
.41254 .26315 Mdot
.4126 .24866 Mdot
.41266 .25108 Mdot
.41272 .28246 Mdot
.41278 .33074 Mdot
.41284 .37179 Mdot
.4129 .38627 Mdot
.41296 .38144 Mdot
.41302 .36937 Mdot
.41308 .36454 Mdot
.41314 .36696 Mdot
.4132 .3742 Mdot
.41326 .37661 Mdot
.41332 .36454 Mdot
.41338 .3404 Mdot
.41344 .3066 Mdot
.4135 .27522 Mdot
.41356 .26315 Mdot
.41362 .27039 Mdot
.41368 .29212 Mdot
.41374 .30177 Mdot
.4138 .2897 Mdot
.41386 .25832 Mdot
.41392 .23901 Mdot
.41398 .24625 Mdot
.41404 .27763 Mdot
.4141 .3066 Mdot
.41416 .31385 Mdot
.41422 .29695 Mdot
.41428 .28005 Mdot
.41434 .27763 Mdot
.4144 .28729 Mdot
.41446 .30902 Mdot
.41452 .32833 Mdot
.41458 .3404 Mdot
.41464 .34282 Mdot
.4147 .33316 Mdot
.41476 .31867 Mdot
.41482 .31143 Mdot
.41488 .32833 Mdot
.41494 .3573 Mdot
.415 .37179 Mdot
.41506 .35972 Mdot
.41512 .32592 Mdot
.41518 .30177 Mdot
.41524 .30419 Mdot
.4153 .32592 Mdot
.41536 .34282 Mdot
.41542 .33799 Mdot
.41548 .31143 Mdot
.41554 .28005 Mdot
.4156 .25832 Mdot
.41566 .25108 Mdot
.41572 .25349 Mdot
.41578 .26556 Mdot
.41584 .27039 Mdot
.4159 .26315 Mdot
.41596 .25108 Mdot
.41602 .23901 Mdot
.41608 .24142 Mdot
.41614 .2728 Mdot
.4162 .31626 Mdot
.41626 .35247 Mdot
.41632 .35972 Mdot
.41638 .35006 Mdot
.41644 .33799 Mdot
.4165 .34523 Mdot
.41656 .3742 Mdot
.41662 .39834 Mdot
.41668 .39834 Mdot
.41674 .3742 Mdot
.4168 .34282 Mdot
.41686 .31867 Mdot
.41692 .30902 Mdot
.41698 .30902 Mdot
.41704 .30902 Mdot
.4171 .30419 Mdot
.41716 .2897 Mdot
.41722 .26315 Mdot
.41728 .23418 Mdot
.41734 .21486 Mdot
.4174 .22452 Mdot
.41746 .25349 Mdot
.41752 .28005 Mdot
.41758 .28246 Mdot
.41764 .26315 Mdot
.4177 .24866 Mdot
.41776 .26315 Mdot
.41782 .3066 Mdot
.41788 .35006 Mdot
.41794 .37179 Mdot
.418 .36937 Mdot
.41806 .35972 Mdot
.41812 .35489 Mdot
.41818 .3573 Mdot
.41824 .36454 Mdot
.4183 .37179 Mdot
.41836 .37179 Mdot
.41842 .3573 Mdot
.41848 .33316 Mdot
.41854 .29936 Mdot
.4186 .27522 Mdot
.41866 .27522 Mdot
.41872 .29453 Mdot
.41878 .30902 Mdot
.41884 .29936 Mdot
.4189 .26798 Mdot
.41896 .23659 Mdot
.41902 .23176 Mdot
.41908 .25349 Mdot
.41914 .28729 Mdot
.4192 .30177 Mdot
.41926 .29212 Mdot
.41932 .27522 Mdot
.41938 .2728 Mdot
.41944 .28246 Mdot
.4195 .30419 Mdot
.41956 .33074 Mdot
.41962 .35006 Mdot
.41968 .3573 Mdot
.41974 .35247 Mdot
.4198 .33557 Mdot
.41986 .32109 Mdot
.41992 .32592 Mdot
.41998 .35006 Mdot
.42004 .36696 Mdot
.4201 .35972 Mdot
.42016 .32833 Mdot
.42021 .29453 Mdot
.42027 .28729 Mdot
.42033 .30419 Mdot
.42039 .32833 Mdot
.42045 .33316 Mdot
.42051 .31626 Mdot
.42057 .2897 Mdot
.42063 .27039 Mdot
.42069 .26315 Mdot
.42075 .26556 Mdot
.42081 .27522 Mdot
.42087 .28246 Mdot
.42093 .28005 Mdot
.42099 .26798 Mdot
.42105 .25108 Mdot
.42111 .24383 Mdot
.42117 .25832 Mdot
.42123 .29695 Mdot
.42129 .33316 Mdot
.42135 .35006 Mdot
.42141 .3404 Mdot
.42147 .32833 Mdot
.42153 .33074 Mdot
.42159 .35489 Mdot
.42165 .38386 Mdot
.42171 .39834 Mdot
.42177 .38627 Mdot
.42183 .35972 Mdot
.42189 .33557 Mdot
.42195 .32109 Mdot
.42201 .31867 Mdot
.42207 .32109 Mdot
.42213 .31626 Mdot
.42219 .30177 Mdot
.42225 .27522 Mdot
.42231 .24142 Mdot
.42237 .21728 Mdot
.42243 .21486 Mdot
.42249 .23418 Mdot
.42255 .26073 Mdot
.42261 .26798 Mdot
.42267 .25832 Mdot
.42273 .24625 Mdot
.42279 .25349 Mdot
.42285 .28729 Mdot
.42291 .33799 Mdot
.42297 .37179 Mdot
.42303 .38144 Mdot
.42309 .3742 Mdot
.42315 .36696 Mdot
.42321 .36454 Mdot
.42327 .36937 Mdot
.42333 .3742 Mdot
.42339 .3742 Mdot
.42345 .36213 Mdot
.42351 .33557 Mdot
.42357 .30177 Mdot
.42363 .27522 Mdot
.42369 .26556 Mdot
.42375 .28005 Mdot
.42381 .29695 Mdot
.42387 .29936 Mdot
.42393 .27763 Mdot
.42399 .25108 Mdot
.42405 .23901 Mdot
.42411 .25349 Mdot
.42417 .28246 Mdot
.42423 .3066 Mdot
.42429 .3066 Mdot
.42435 .2897 Mdot
.42441 .28005 Mdot
.42447 .28005 Mdot
.42453 .29212 Mdot
.42459 .31626 Mdot
.42465 .33557 Mdot
.42471 .34764 Mdot
.42477 .34523 Mdot
.42483 .33074 Mdot
.42489 .31626 Mdot
.42495 .31626 Mdot
.42501 .33799 Mdot
.42507 .36213 Mdot
.42513 .36937 Mdot
.42519 .34764 Mdot
.42525 .31626 Mdot
.42531 .29936 Mdot
.42537 .3066 Mdot
.42543 .32833 Mdot
.42549 .34282 Mdot
.42555 .33316 Mdot
.42561 .30419 Mdot
.42567 .27763 Mdot
.42573 .26073 Mdot
.42579 .25349 Mdot
.42585 .2559 Mdot
.42591 .26556 Mdot
.42597 .26798 Mdot
.42603 .26073 Mdot
.42609 .24625 Mdot
.42615 .23901 Mdot
.42621 .25108 Mdot
.42627 .28729 Mdot
.42633 .33074 Mdot
.42639 .3573 Mdot
.42645 .3573 Mdot
.42651 .34523 Mdot
.42657 .3404 Mdot
.42663 .35489 Mdot
.42669 .38386 Mdot
.42675 .40076 Mdot
.42681 .3911 Mdot
.42687 .36213 Mdot
.42693 .33316 Mdot
.42699 .31385 Mdot
.42705 .30419 Mdot
.42711 .3066 Mdot
.42717 .3066 Mdot
.42723 .30177 Mdot
.42729 .28488 Mdot
.42735 .25832 Mdot
.42741 .22935 Mdot
.42747 .21969 Mdot
.42753 .23659 Mdot
.42759 .26556 Mdot
.42765 .28488 Mdot
.42771 .27763 Mdot
.42777 .25832 Mdot
.42783 .25349 Mdot
.42789 .27522 Mdot
.42795 .31867 Mdot
.42801 .35489 Mdot
.42807 .36937 Mdot
.42813 .36213 Mdot
.42819 .35489 Mdot
.42825 .35247 Mdot
.42831 .35489 Mdot
.42837 .36454 Mdot
.42843 .37179 Mdot
.42849 .36937 Mdot
.42855 .35489 Mdot
.42861 .32592 Mdot
.42867 .29212 Mdot
.42873 .27763 Mdot
.42879 .28488 Mdot
.42885 .30419 Mdot
.42891 .31143 Mdot
.42897 .29212 Mdot
.42903 .25832 Mdot
.42909 .23659 Mdot
.42915 .24142 Mdot
.42921 .26315 Mdot
.42927 .28729 Mdot
.42933 .29453 Mdot
.42939 .28488 Mdot
.42945 .2728 Mdot
.42951 .2728 Mdot
.42957 .28246 Mdot
.42963 .3066 Mdot
.42969 .33316 Mdot
.42975 .35247 Mdot
.42981 .3573 Mdot
.42987 .35006 Mdot
.42993 .33316 Mdot
.42999 .32592 Mdot
.43005 .33799 Mdot
.43011 .35972 Mdot
.43017 .37179 Mdot
.43023 .35489 Mdot
.43029 .31867 Mdot
.43035 .2897 Mdot
.43041 .2897 Mdot
.43047 .30902 Mdot
.43053 .32833 Mdot
.43059 .32833 Mdot
.43065 .3066 Mdot
.43071 .28246 Mdot
.43077 .26798 Mdot
.43083 .26315 Mdot
.43089 .26556 Mdot
.43095 .27522 Mdot
.43101 .28488 Mdot
.43107 .28005 Mdot
.43113 .26556 Mdot
.43119 .24866 Mdot
.43125 .24383 Mdot
.43131 .26556 Mdot
.43137 .3066 Mdot
.43143 .33799 Mdot
.43149 .34764 Mdot
.43155 .33557 Mdot
.43161 .32592 Mdot
.43167 .33557 Mdot
.43173 .36213 Mdot
.43179 .38869 Mdot
.43185 .39593 Mdot
.43191 .37903 Mdot
.43197 .35247 Mdot
.43203 .33074 Mdot
.43209 .32109 Mdot
.43215 .31626 Mdot
.43221 .31626 Mdot
.43227 .31143 Mdot
.43233 .29695 Mdot
.43239 .2728 Mdot
.43245 .24142 Mdot
.43251 .21728 Mdot
.43257 .21969 Mdot
.43263 .24383 Mdot
.43269 .26798 Mdot
.43275 .2728 Mdot
.43281 .25832 Mdot
.43287 .24625 Mdot
.43293 .25832 Mdot
.43299 .30177 Mdot
.43305 .34523 Mdot
.43311 .36937 Mdot
.43317 .3742 Mdot
.43323 .36937 Mdot
.43329 .36454 Mdot
.43335 .36454 Mdot
.43341 .36454 Mdot
.43347 .36696 Mdot
.43353 .36937 Mdot
.43359 .35972 Mdot
.43365 .33316 Mdot
.43371 .29936 Mdot
.43377 .27039 Mdot
.43383 .26798 Mdot
.43389 .28488 Mdot
.43395 .30177 Mdot
.43401 .29936 Mdot
.43407 .27763 Mdot
.43413 .25349 Mdot
.43419 .24625 Mdot
.43425 .26315 Mdot
.43431 .2897 Mdot
.43437 .3066 Mdot
.43443 .30419 Mdot
.43449 .2897 Mdot
.43455 .28005 Mdot
.43461 .28005 Mdot
.43467 .29212 Mdot
.43473 .30902 Mdot
.43479 .32833 Mdot
.43485 .3404 Mdot
.43491 .33799 Mdot
.43497 .32833 Mdot
.43503 .31626 Mdot
.43509 .31626 Mdot
.43515 .33557 Mdot
.43521 .3573 Mdot
.43527 .36937 Mdot
.43533 .36454 Mdot
.43539 .35489 Mdot
.43545 .35247 Mdot
.43551 .36213 Mdot
.43557 .36937 Mdot
.43563 .35006 Mdot
.43569 .30419 Mdot
.43575 .24625 Mdot
.43581 .20521 Mdot
.43587 .19314 Mdot
.43593 .20521 Mdot
.43599 .22693 Mdot
.43605 .24625 Mdot
.43611 .25108 Mdot
.43617 .23659 Mdot
.43623 .21486 Mdot
.43629 .20762 Mdot
.43635 .22693 Mdot
.43641 .2728 Mdot
.43647 .3235 Mdot
.43653 .3573 Mdot
.43659 .36454 Mdot
.43665 .36454 Mdot
.43671 .36937 Mdot
.43677 .38627 Mdot
.43683 .40076 Mdot
.43689 .39834 Mdot
.43695 .37903 Mdot
.43701 .35247 Mdot
.43707 .32592 Mdot
.43713 .31143 Mdot
.43719 .3066 Mdot
.43725 .3066 Mdot
.43731 .30902 Mdot
.43737 .31385 Mdot
.43743 .31385 Mdot
.43749 .29936 Mdot
.43755 .2728 Mdot
.43761 .25108 Mdot
.43767 .2559 Mdot
.43773 .27763 Mdot
.43779 .2897 Mdot
.43785 .27763 Mdot
.43791 .25349 Mdot
.43797 .24625 Mdot
.43803 .26798 Mdot
.43809 .31385 Mdot
.43815 .3573 Mdot
.43821 .37903 Mdot
.43827 .38386 Mdot
.43833 .38144 Mdot
.43839 .3742 Mdot
.43845 .37179 Mdot
.43851 .3742 Mdot
.43857 .37661 Mdot
.43863 .36696 Mdot
.43869 .33557 Mdot
.43875 .28488 Mdot
.43881 .24625 Mdot
.43887 .23659 Mdot
.43893 .2559 Mdot
.43899 .28488 Mdot
.43905 .29453 Mdot
.43911 .28005 Mdot
.43917 .2559 Mdot
.43923 .24383 Mdot
.43929 .2559 Mdot
.43935 .2728 Mdot
.43941 .27763 Mdot
.43947 .26073 Mdot
.43953 .24142 Mdot
.43959 .23176 Mdot
.43965 .23659 Mdot
.43971 .25349 Mdot
.43977 .27763 Mdot
.43983 .30902 Mdot
.43989 .3404 Mdot
.43995 .36454 Mdot
.44001 .3742 Mdot
.44007 .36937 Mdot
.44013 .35972 Mdot
.44019 .35972 Mdot
.44025 .36937 Mdot
.44031 .36937 Mdot
.44037 .35006 Mdot
.44043 .31626 Mdot
.44049 .29212 Mdot
.44055 .2897 Mdot
.44061 .31385 Mdot
.44067 .3404 Mdot
.44073 .35247 Mdot
.44079 .35247 Mdot
.44085 .34282 Mdot
.44091 .32592 Mdot
.44097 .30902 Mdot
.44103 .30177 Mdot
.44109 .30177 Mdot
.44115 .30177 Mdot
.44121 .28488 Mdot
.44127 .2559 Mdot
.44133 .23176 Mdot
.44139 .23176 Mdot
.44145 .2728 Mdot
.44151 .32592 Mdot
.44157 .36454 Mdot
.44163 .37179 Mdot
.44169 .36213 Mdot
.44175 .36213 Mdot
.44181 .3742 Mdot
.44187 .3911 Mdot
.44193 .39593 Mdot
.44199 .3742 Mdot
.44205 .3404 Mdot
.44211 .30902 Mdot
.44217 .28729 Mdot
.44223 .27522 Mdot
.44229 .2728 Mdot
.44235 .27039 Mdot
.44241 .26798 Mdot
.44247 .26315 Mdot
.44253 .25108 Mdot
.44259 .23659 Mdot
.44265 .22211 Mdot
.44271 .22211 Mdot
.44277 .23659 Mdot
.44283 .24625 Mdot
.44289 .24142 Mdot
.44295 .22693 Mdot
.44301 .22211 Mdot
.44307 .23901 Mdot
.44313 .27522 Mdot
.44319 .31626 Mdot
.44325 .35006 Mdot
.44331 .37661 Mdot
.44337 .3911 Mdot
.44343 .38869 Mdot
.44349 .37903 Mdot
.44355 .36937 Mdot
.44361 .36937 Mdot
.44367 .37179 Mdot
.44373 .35972 Mdot
.44379 .32592 Mdot
.44385 .28488 Mdot
.44391 .26315 Mdot
.44397 .27763 Mdot
.44403 .31385 Mdot
.44409 .34282 Mdot
.44415 .34282 Mdot
.44421 .32109 Mdot
.44427 .30419 Mdot
.44433 .3066 Mdot
.44439 .3235 Mdot
.44445 .3404 Mdot
.44451 .33799 Mdot
.44457 .31626 Mdot
.44463 .29453 Mdot
.44469 .28005 Mdot
.44475 .28488 Mdot
.44481 .30177 Mdot
.44487 .3235 Mdot
.44493 .34282 Mdot
.44499 .3573 Mdot
.44505 .35972 Mdot
.44511 .35247 Mdot
.44517 .34764 Mdot
.44523 .34764 Mdot
.44529 .3573 Mdot
.44535 .35972 Mdot
.44541 .3404 Mdot
.44547 .30902 Mdot
.44553 .28246 Mdot
.44559 .27522 Mdot
.44565 .28246 Mdot
.44571 .29212 Mdot
.44577 .29453 Mdot
.44583 .29212 Mdot
.44589 .28246 Mdot
.44595 .26556 Mdot
.44601 .24383 Mdot
.44607 .22693 Mdot
.44613 .21969 Mdot
.44619 .22693 Mdot
.44625 .23176 Mdot
.44631 .21969 Mdot
.44637 .19796 Mdot
.44643 .19072 Mdot
.44649 .21728 Mdot
.44655 .27039 Mdot
.44661 .32833 Mdot
.44667 .3573 Mdot
.44673 .36213 Mdot
.44679 .3573 Mdot
.44685 .36213 Mdot
.44691 .38386 Mdot
.44697 .40558 Mdot
.44703 .40558 Mdot
.44709 .38144 Mdot
.44715 .34764 Mdot
.44721 .31867 Mdot
.44727 .3066 Mdot
.44733 .31143 Mdot
.44739 .3235 Mdot
.44745 .33316 Mdot
.44751 .33316 Mdot
.44757 .32592 Mdot
.44763 .30902 Mdot
.44769 .29453 Mdot
.44775 .29212 Mdot
.44781 .30419 Mdot
.44787 .31385 Mdot
.44793 .3066 Mdot
.44799 .28488 Mdot
.44805 .27039 Mdot
.44811 .28005 Mdot
.44817 .30902 Mdot
.44823 .3404 Mdot
.44829 .36454 Mdot
.44835 .37903 Mdot
.44841 .38869 Mdot
.44847 .39351 Mdot
.44853 .38869 Mdot
.44859 .3742 Mdot
.44865 .36213 Mdot
.44871 .35489 Mdot
.44877 .34523 Mdot
.44883 .3235 Mdot
.44889 .28729 Mdot
.44895 .25108 Mdot
.44901 .23901 Mdot
.44907 .2559 Mdot
.44913 .28246 Mdot
.44919 .29212 Mdot
.44925 .27522 Mdot
.44931 .24866 Mdot
.44937 .23176 Mdot
.44943 .23659 Mdot
.44949 .25349 Mdot
.44955 .25832 Mdot
.44961 .24625 Mdot
.44967 .22693 Mdot
.44973 .21486 Mdot
.44979 .21969 Mdot
.44985 .23901 Mdot
.44991 .27039 Mdot
.44997 .3066 Mdot
.45003 .33557 Mdot
.45009 .34764 Mdot
.45015 .34764 Mdot
.45021 .3404 Mdot
.45027 .34523 Mdot
.45033 .36213 Mdot
.45039 .37179 Mdot
.45045 .36213 Mdot
.45051 .33316 Mdot
.45057 .30419 Mdot
.45063 .29936 Mdot
.45069 .31626 Mdot
.45075 .33799 Mdot
.45081 .34764 Mdot
.45087 .34764 Mdot
.45093 .34282 Mdot
.45099 .3404 Mdot
.45105 .33316 Mdot
.45111 .31867 Mdot
.45117 .3066 Mdot
.45123 .30419 Mdot
.45129 .3066 Mdot
.45135 .30177 Mdot
.45141 .28246 Mdot
.45147 .26556 Mdot
.45153 .26798 Mdot
.45159 .29936 Mdot
.45165 .34282 Mdot
.45171 .37661 Mdot
.45177 .38627 Mdot
.45183 .37903 Mdot
.45189 .36937 Mdot
.45195 .3742 Mdot
.45201 .38627 Mdot
.45207 .38869 Mdot
.45213 .3742 Mdot
.45219 .34523 Mdot
.45225 .31385 Mdot
.45231 .28729 Mdot
.45237 .27522 Mdot
.45243 .27763 Mdot
.45249 .28729 Mdot
.45255 .2897 Mdot
.45261 .27522 Mdot
.45267 .24866 Mdot
.45273 .21969 Mdot
.45279 .20279 Mdot
.45285 .21245 Mdot
.45291 .22935 Mdot
.45297 .22693 Mdot
.45303 .21003 Mdot
.45309 .19314 Mdot
.45315 .19796 Mdot
.45321 .22935 Mdot
.45327 .27522 Mdot
.45333 .31385 Mdot
.45339 .33799 Mdot
.45345 .35247 Mdot
.45351 .36454 Mdot
.45357 .37179 Mdot
.45363 .37179 Mdot
.45369 .36937 Mdot
.45375 .36454 Mdot
.45381 .35489 Mdot
.45387 .33799 Mdot
.45393 .31626 Mdot
.45399 .29212 Mdot
.45405 .28246 Mdot
.45411 .29453 Mdot
.45417 .31867 Mdot
.45423 .33557 Mdot
.45429 .33799 Mdot
.45435 .32592 Mdot
.45441 .31143 Mdot
.45447 .30419 Mdot
.45453 .31385 Mdot
.45459 .32833 Mdot
.45465 .33316 Mdot
.45471 .32109 Mdot
.45477 .30177 Mdot
.45483 .2897 Mdot
.45489 .29212 Mdot
.45495 .31385 Mdot
.45501 .34523 Mdot
.45507 .37179 Mdot
.45513 .38386 Mdot
.45519 .37661 Mdot
.45525 .36213 Mdot
.45531 .35489 Mdot
.45537 .3573 Mdot
.45543 .36696 Mdot
.45549 .35972 Mdot
.45555 .33316 Mdot
.45561 .29695 Mdot
.45567 .27522 Mdot
.45573 .27522 Mdot
.45579 .29212 Mdot
.45585 .30419 Mdot
.45591 .30177 Mdot
.45597 .28729 Mdot
.45603 .27039 Mdot
.45609 .2559 Mdot
.45615 .24383 Mdot
.45621 .23418 Mdot
.45627 .22693 Mdot
.45633 .22452 Mdot
.45639 .21728 Mdot
.45645 .20521 Mdot
.45651 .19555 Mdot
.45657 .20521 Mdot
.45663 .23418 Mdot
.45669 .27522 Mdot
.45675 .31626 Mdot
.45681 .33799 Mdot
.45687 .34764 Mdot
.45693 .35247 Mdot
.45699 .35972 Mdot
.45705 .36937 Mdot
.45711 .37903 Mdot
.45717 .37661 Mdot
.45723 .36454 Mdot
.45729 .34282 Mdot
.45735 .31867 Mdot
.45741 .3066 Mdot
.45747 .30902 Mdot
.45753 .3235 Mdot
.45759 .33799 Mdot
.45765 .3404 Mdot
.45771 .32592 Mdot
.45777 .30177 Mdot
.45783 .28488 Mdot
.45789 .28729 Mdot
.45795 .30177 Mdot
.45801 .31143 Mdot
.45807 .30419 Mdot
.45813 .28488 Mdot
.45819 .27522 Mdot
.45825 .2897 Mdot
.45831 .3235 Mdot
.45837 .35972 Mdot
.45843 .38386 Mdot
.45849 .3911 Mdot
.45855 .3911 Mdot
.45861 .38627 Mdot
.45867 .37903 Mdot
.45873 .37179 Mdot
.45879 .36213 Mdot
.45885 .35247 Mdot
.45891 .33074 Mdot
.45897 .30177 Mdot
.45903 .2728 Mdot
.45909 .25349 Mdot
.45915 .25349 Mdot
.45921 .26798 Mdot
.45927 .28005 Mdot
.45933 .28005 Mdot
.45939 .26556 Mdot
.45945 .24866 Mdot
.45951 .23901 Mdot
.45957 .23659 Mdot
.45963 .23901 Mdot
.45969 .24142 Mdot
.45975 .23659 Mdot
.45981 .22935 Mdot
.45987 .22211 Mdot
.45993 .22452 Mdot
.45999 .24142 Mdot
.46005 .2728 Mdot
.46011 .31143 Mdot
.46017 .33799 Mdot
.46023 .35006 Mdot
.46029 .34282 Mdot
.46035 .33074 Mdot
.46041 .33316 Mdot
.46047 .35006 Mdot
.46053 .36454 Mdot
.46059 .3573 Mdot
.46065 .33316 Mdot
.46071 .30902 Mdot
.46077 .3066 Mdot
.46083 .3235 Mdot
.46089 .34764 Mdot
.46095 .35972 Mdot
.46101 .3573 Mdot
.46107 .34523 Mdot
.46113 .33074 Mdot
.46119 .32109 Mdot
.46125 .31143 Mdot
.46131 .31143 Mdot
.46137 .31143 Mdot
.46143 .30419 Mdot
.46149 .2897 Mdot
.46155 .2728 Mdot
.46161 .27039 Mdot
.46167 .2897 Mdot
.46173 .32592 Mdot
.46179 .35972 Mdot
.46185 .37903 Mdot
.46191 .38144 Mdot
.46197 .37661 Mdot
.46203 .37179 Mdot
.46209 .37179 Mdot
.46215 .37179 Mdot
.46221 .36454 Mdot
.46227 .34523 Mdot
.46233 .3235 Mdot
.46239 .29936 Mdot
.46245 .28005 Mdot
.46251 .27039 Mdot
.46257 .27039 Mdot
.46263 .27763 Mdot
.46269 .28005 Mdot
.46275 .26798 Mdot
.46281 .24142 Mdot
.46287 .21003 Mdot
.46293 .19555 Mdot
.46299 .20521 Mdot
.46305 .22211 Mdot
.46311 .22693 Mdot
.46317 .21728 Mdot
.46323 .20521 Mdot
.46329 .21003 Mdot
.46335 .24383 Mdot
.46341 .28729 Mdot
.46347 .32592 Mdot
.46353 .35006 Mdot
.46359 .35972 Mdot
.46365 .36213 Mdot
.46371 .36213 Mdot
.46377 .36213 Mdot
.46383 .36454 Mdot
.46389 .36454 Mdot
.46395 .35972 Mdot
.46401 .3404 Mdot
.46407 .31626 Mdot
.46413 .29936 Mdot
.46419 .30177 Mdot
.46425 .3235 Mdot
.46431 .34523 Mdot
.46437 .35247 Mdot
.46443 .34282 Mdot
.46449 .32833 Mdot
.46455 .31867 Mdot
.46461 .31867 Mdot
.46467 .3235 Mdot
.46473 .32592 Mdot
.46479 .3235 Mdot
.46485 .31385 Mdot
.46491 .30419 Mdot
.46497 .30177 Mdot
.46503 .30902 Mdot
.46509 .32592 Mdot
.46515 .35247 Mdot
.46521 .3742 Mdot
.46527 .38144 Mdot
.46533 .3742 Mdot
.46539 .35489 Mdot
.46545 .3404 Mdot
.46551 .33799 Mdot
.46557 .34282 Mdot
.46563 .33799 Mdot
.46569 .31626 Mdot
.46575 .28729 Mdot
.46581 .26556 Mdot
.46587 .26315 Mdot
.46593 .27522 Mdot
.46599 .28729 Mdot
.46605 .29212 Mdot
.46611 .28246 Mdot
.46617 .26315 Mdot
.46623 .24142 Mdot
.46629 .22452 Mdot
.46635 .21969 Mdot
.46641 .21969 Mdot
.46647 .22211 Mdot
.46653 .21486 Mdot
.46659 .20038 Mdot
.46665 .19555 Mdot
.46671 .21245 Mdot
.46677 .25108 Mdot
.46683 .29453 Mdot
.46689 .32592 Mdot
.46695 .3404 Mdot
.46701 .34523 Mdot
.46707 .34764 Mdot
.46713 .3573 Mdot
.46719 .36937 Mdot
.46725 .3742 Mdot
.46731 .37179 Mdot
.46737 .35972 Mdot
.46743 .34523 Mdot
.46749 .33557 Mdot
.46755 .33316 Mdot
.46761 .33557 Mdot
.46767 .34523 Mdot
.46773 .35489 Mdot
.46779 .3573 Mdot
.46785 .34523 Mdot
.46791 .32592 Mdot
.46797 .30419 Mdot
.46803 .29936 Mdot
.46809 .3066 Mdot
.46815 .31626 Mdot
.46821 .31143 Mdot
.46827 .29936 Mdot
.46833 .29212 Mdot
.46839 .30177 Mdot
.46845 .33074 Mdot
.46851 .36454 Mdot
.46857 .38627 Mdot
.46863 .39351 Mdot
.46869 .38869 Mdot
.46875 .37179 Mdot
.46881 .3573 Mdot
.46887 .34523 Mdot
.46893 .3404 Mdot
.46899 .33316 Mdot
.46905 .31385 Mdot
.46911 .28488 Mdot
.46917 .2559 Mdot
.46923 .24383 Mdot
.46929 .25108 Mdot
.46935 .26798 Mdot
.46941 .27763 Mdot
.46947 .27039 Mdot
.46953 .25108 Mdot
.46959 .23418 Mdot
.46965 .22935 Mdot
.46971 .23176 Mdot
.46977 .23659 Mdot
.46983 .23418 Mdot
.46989 .22935 Mdot
.46995 .22452 Mdot
.47001 .22693 Mdot
.47007 .23659 Mdot
.47013 .2559 Mdot
.47019 .28246 Mdot
.47025 .31143 Mdot
.47031 .33074 Mdot
.47037 .3404 Mdot
.47043 .33557 Mdot
.47049 .32833 Mdot
.47055 .32833 Mdot
.47061 .33799 Mdot
.47067 .34764 Mdot
.47073 .34282 Mdot
.47079 .33316 Mdot
.47085 .3235 Mdot
.47091 .32592 Mdot
.47097 .3404 Mdot
.47103 .35972 Mdot
.47109 .3742 Mdot
.47115 .37661 Mdot
.47121 .36937 Mdot
.47127 .35247 Mdot
.47133 .33557 Mdot
.47139 .32109 Mdot
.47145 .31626 Mdot
.47151 .31867 Mdot
.47157 .31867 Mdot
.47163 .3066 Mdot
.47169 .2897 Mdot
.47175 .28488 Mdot
.47181 .30177 Mdot
.47187 .33557 Mdot
.47193 .36696 Mdot
.47199 .37661 Mdot
.47205 .3742 Mdot
.47211 .36696 Mdot
.47217 .36213 Mdot
.47223 .36213 Mdot
.47229 .35972 Mdot
.47235 .34764 Mdot
.47241 .33074 Mdot
.47247 .30902 Mdot
.47253 .2897 Mdot
.47259 .27522 Mdot
.47265 .26798 Mdot
.47271 .26798 Mdot
.47277 .2728 Mdot
.47283 .27039 Mdot
.47289 .2559 Mdot
.47295 .23176 Mdot
.47301 .21003 Mdot
.47307 .20279 Mdot
.47313 .20762 Mdot
.47319 .21486 Mdot
.47325 .21486 Mdot
.47331 .21003 Mdot
.47337 .21245 Mdot
.47342 .22452 Mdot
.47348 .25349 Mdot
.47354 .28488 Mdot
.4736 .31626 Mdot
.47366 .3404 Mdot
.47372 .35247 Mdot
.47378 .35489 Mdot
.47384 .34764 Mdot
.4739 .34282 Mdot
.47396 .3404 Mdot
.47402 .34282 Mdot
.47408 .34282 Mdot
.47414 .33074 Mdot
.4742 .31143 Mdot
.47426 .29695 Mdot
.47432 .30419 Mdot
.47438 .32833 Mdot
.47444 .35489 Mdot
.4745 .36454 Mdot
.47456 .35489 Mdot
.47462 .3404 Mdot
.47468 .33316 Mdot
.47474 .33316 Mdot
.4748 .3404 Mdot
.47486 .3404 Mdot
.47492 .33557 Mdot
.47498 .32592 Mdot
.47504 .31867 Mdot
.4751 .31867 Mdot
.47516 .32833 Mdot
.47522 .34523 Mdot
.47528 .36454 Mdot
.47534 .37661 Mdot
.4754 .37661 Mdot
.47546 .36454 Mdot
.47552 .34764 Mdot
.47558 .33799 Mdot
.47564 .33557 Mdot
.4757 .33557 Mdot
.47576 .3235 Mdot
.47582 .30419 Mdot
.47588 .28488 Mdot
.47594 .27522 Mdot
.476 .27763 Mdot
.47606 .28488 Mdot
.47612 .2897 Mdot
.47618 .28729 Mdot
.47624 .27763 Mdot
.4763 .26315 Mdot
.47636 .24142 Mdot
.47642 .22211 Mdot
.47648 .21245 Mdot
.47654 .21003 Mdot
.4766 .21486 Mdot
.47666 .21245 Mdot
.47672 .20279 Mdot
.47678 .19796 Mdot
.47684 .21245 Mdot
.4769 .24866 Mdot
.47696 .2897 Mdot
.47702 .31867 Mdot
.47708 .33074 Mdot
.47714 .33074 Mdot
.4772 .33316 Mdot
.47726 .33799 Mdot
.47732 .35006 Mdot
.47738 .3573 Mdot
.47744 .35489 Mdot
.4775 .34523 Mdot
.47756 .33316 Mdot
.47762 .3235 Mdot
.47768 .3235 Mdot
.47774 .33316 Mdot
.4778 .34764 Mdot
.47786 .3573 Mdot
.47792 .35247 Mdot
.47798 .33316 Mdot
.47804 .31626 Mdot
.4781 .30902 Mdot
.47816 .31143 Mdot
.47822 .31867 Mdot
.47828 .32109 Mdot
.47834 .31385 Mdot
.4784 .30902 Mdot
.47846 .31626 Mdot
.47852 .33316 Mdot
.47858 .3573 Mdot
.47864 .37903 Mdot
.4787 .39593 Mdot
.47876 .40076 Mdot
.47882 .39834 Mdot
.47888 .38386 Mdot
.47894 .36454 Mdot
.479 .34764 Mdot
.47906 .33799 Mdot
.47912 .33074 Mdot
.47918 .31385 Mdot
.47924 .2897 Mdot
.4793 .26315 Mdot
.47936 .25108 Mdot
.47942 .25832 Mdot
.47948 .2728 Mdot
.47954 .28246 Mdot
.4796 .2728 Mdot
.47966 .25349 Mdot
.47972 .23659 Mdot
.47978 .22935 Mdot
.47984 .22693 Mdot
.4799 .23176 Mdot
.47996 .23176 Mdot
.48002 .22935 Mdot
.48008 .22452 Mdot
.48014 .22452 Mdot
.4802 .23176 Mdot
.48026 .25349 Mdot
.48032 .28488 Mdot
.48038 .31143 Mdot
.48044 .3235 Mdot
.4805 .32109 Mdot
.48056 .31143 Mdot
.48062 .30902 Mdot
.48068 .31867 Mdot
.48074 .33074 Mdot
.4808 .33316 Mdot
.48086 .32592 Mdot
.48092 .31143 Mdot
.48098 .31143 Mdot
.48104 .3235 Mdot
.4811 .34282 Mdot
.48116 .3573 Mdot
.48122 .36454 Mdot
.48128 .36454 Mdot
.48134 .3573 Mdot
.4814 .34523 Mdot
.48146 .32833 Mdot
.48152 .31626 Mdot
.48158 .31385 Mdot
.48164 .31867 Mdot
.4817 .31867 Mdot
.48176 .31143 Mdot
.48182 .30177 Mdot
.48188 .30419 Mdot
.48194 .32833 Mdot
.482 .35972 Mdot
.48206 .38144 Mdot
.48212 .3911 Mdot
.48218 .38627 Mdot
.48224 .37661 Mdot
.4823 .36937 Mdot
.48236 .36454 Mdot
.48242 .35972 Mdot
.48248 .35247 Mdot
.48254 .33799 Mdot
.4826 .31626 Mdot
.48266 .29695 Mdot
.48272 .28005 Mdot
.48278 .27522 Mdot
.48284 .28246 Mdot
.4829 .28729 Mdot
.48296 .28005 Mdot
.48302 .26073 Mdot
.48308 .23176 Mdot
.48314 .21003 Mdot
.4832 .20521 Mdot
.48326 .21486 Mdot
.48332 .21969 Mdot
.48338 .21728 Mdot
.48344 .21003 Mdot
.4835 .21245 Mdot
.48356 .23176 Mdot
.48362 .26315 Mdot
.48368 .29453 Mdot
.48374 .31867 Mdot
.4838 .33074 Mdot
.48386 .33799 Mdot
.48392 .33799 Mdot
.48398 .33316 Mdot
.48404 .32592 Mdot
.4841 .32592 Mdot
.48416 .32833 Mdot
.48422 .32592 Mdot
.48428 .31385 Mdot
.48434 .30177 Mdot
.4844 .29695 Mdot
.48446 .3066 Mdot
.48452 .32833 Mdot
.48458 .34523 Mdot
.48464 .34764 Mdot
.4847 .34282 Mdot
.48476 .33074 Mdot
.48482 .3235 Mdot
.48488 .3235 Mdot
.48494 .32592 Mdot
.485 .33074 Mdot
.48506 .33074 Mdot
.48512 .32833 Mdot
.48518 .3235 Mdot
.48524 .3235 Mdot
.4853 .33557 Mdot
.48536 .3573 Mdot
.48542 .38144 Mdot
.48548 .39351 Mdot
.48554 .38627 Mdot
.4856 .36696 Mdot
.48566 .34764 Mdot
.48572 .3404 Mdot
.48578 .34523 Mdot
.48584 .34523 Mdot
.4859 .33074 Mdot
.48596 .3066 Mdot
.48602 .28729 Mdot
.48608 .28246 Mdot
.48614 .2897 Mdot
.4862 .29695 Mdot
.48626 .29936 Mdot
.48632 .29453 Mdot
.48638 .28005 Mdot
.48644 .26073 Mdot
.4865 .24142 Mdot
.48656 .22693 Mdot
.48662 .22211 Mdot
.48668 .22211 Mdot
.48674 .21969 Mdot
.4868 .21245 Mdot
.48686 .20762 Mdot
.48692 .21245 Mdot
.48698 .23418 Mdot
.48704 .27039 Mdot
.4871 .30177 Mdot
.48716 .31867 Mdot
.48722 .32592 Mdot
.48728 .32833 Mdot
.48734 .32833 Mdot
.4874 .33074 Mdot
.48746 .33316 Mdot
.48752 .33557 Mdot
.48758 .33557 Mdot
.48764 .33074 Mdot
.4877 .32109 Mdot
.48776 .31385 Mdot
.48782 .31385 Mdot
.48788 .32592 Mdot
.48794 .34282 Mdot
.488 .35247 Mdot
.48806 .34282 Mdot
.48812 .3235 Mdot
.48818 .30419 Mdot
.48824 .29936 Mdot
.4883 .3066 Mdot
.48836 .31867 Mdot
.48842 .32109 Mdot
.48848 .31385 Mdot
.48854 .3066 Mdot
.4886 .31626 Mdot
.48866 .3404 Mdot
.48872 .36696 Mdot
.48878 .38869 Mdot
.48884 .39834 Mdot
.4889 .39834 Mdot
.48896 .38869 Mdot
.48902 .3742 Mdot
.48908 .35972 Mdot
.48914 .35006 Mdot
.4892 .34282 Mdot
.48926 .33074 Mdot
.48932 .31143 Mdot
.48938 .28729 Mdot
.48944 .27039 Mdot
.4895 .27039 Mdot
.48956 .28005 Mdot
.48962 .2897 Mdot
.48968 .28729 Mdot
.48974 .2728 Mdot
.4898 .2559 Mdot
.48986 .24383 Mdot
.48992 .23418 Mdot
.48998 .23176 Mdot
.49004 .23176 Mdot
.4901 .23176 Mdot
.49016 .23418 Mdot
.49022 .23176 Mdot
.49028 .23418 Mdot
.49034 .24625 Mdot
.4904 .26798 Mdot
.49046 .29695 Mdot
.49052 .32109 Mdot
.49058 .33074 Mdot
.49064 .3235 Mdot
.4907 .31143 Mdot
.49076 .3066 Mdot
.49082 .31626 Mdot
.49088 .32833 Mdot
.49094 .33074 Mdot
.491 .31867 Mdot
.49106 .30902 Mdot
.49112 .30902 Mdot
.49118 .32109 Mdot
.49124 .3404 Mdot
.4913 .35489 Mdot
.49136 .35972 Mdot
.49142 .35489 Mdot
.49148 .34282 Mdot
.49154 .32592 Mdot
.4916 .31385 Mdot
.49166 .30902 Mdot
.49172 .31385 Mdot
.49178 .31867 Mdot
.49184 .31385 Mdot
.4919 .30419 Mdot
.49196 .30177 Mdot
.49202 .31385 Mdot
.49208 .3404 Mdot
.49214 .36696 Mdot
.4922 .38144 Mdot
.49226 .38144 Mdot
.49232 .3742 Mdot
.49238 .36696 Mdot
.49244 .36213 Mdot
.4925 .3573 Mdot
.49256 .35006 Mdot
.49262 .3404 Mdot
.49268 .32592 Mdot
.49274 .31143 Mdot
.4928 .29453 Mdot
.49286 .28488 Mdot
.49292 .28246 Mdot
.49298 .28729 Mdot
.49304 .2897 Mdot
.4931 .28488 Mdot
.49316 .26315 Mdot
.49322 .23418 Mdot
.49328 .21486 Mdot
.49334 .21003 Mdot
.4934 .21969 Mdot
.49346 .22935 Mdot
.49352 .22693 Mdot
.49358 .22452 Mdot
.49364 .22935 Mdot
.4937 .24866 Mdot
.49376 .27763 Mdot
.49382 .3066 Mdot
.49388 .32592 Mdot
.49394 .33557 Mdot
.494 .33799 Mdot
.49406 .33074 Mdot
.49412 .32109 Mdot
.49418 .31867 Mdot
.49424 .3235 Mdot
.4943 .32592 Mdot
.49436 .32109 Mdot
.49442 .30902 Mdot
.49448 .29936 Mdot
.49454 .30419 Mdot
.4946 .32109 Mdot
.49466 .3404 Mdot
.49472 .35006 Mdot
.49478 .34764 Mdot
.49484 .33799 Mdot
.4949 .32833 Mdot
.49496 .3235 Mdot
.49502 .31867 Mdot
.49508 .31867 Mdot
.49514 .32109 Mdot
.4952 .32109 Mdot
.49526 .32109 Mdot
.49532 .3235 Mdot
.49538 .32592 Mdot
.49544 .3404 Mdot
.4955 .3573 Mdot
.49556 .3742 Mdot
.49562 .38144 Mdot
.49568 .37179 Mdot
.49574 .35489 Mdot
.4958 .33799 Mdot
.49586 .33316 Mdot
.49592 .33316 Mdot
.49598 .33074 Mdot
.49604 .32109 Mdot
.4961 .30419 Mdot
.49616 .29212 Mdot
.49622 .2897 Mdot
.49628 .29453 Mdot
.49634 .30177 Mdot
.4964 .30419 Mdot
.49646 .29695 Mdot
.49652 .28246 Mdot
.49658 .26315 Mdot
.49664 .23901 Mdot
.4967 .22452 Mdot
.49676 .22452 Mdot
.49682 .22935 Mdot
.49688 .22935 Mdot
.49694 .22452 Mdot
.497 .21969 Mdot
.49706 .22935 Mdot
.49712 .2559 Mdot
.49718 .28729 Mdot
.49724 .31143 Mdot
.4973 .3235 Mdot
.49736 .3235 Mdot
.49742 .3235 Mdot
.49748 .32592 Mdot
.49754 .32833 Mdot
.4976 .33074 Mdot
.49766 .33074 Mdot
.49772 .33074 Mdot
.49778 .32592 Mdot
.49784 .3235 Mdot
.4979 .32109 Mdot
.49796 .32833 Mdot
.49802 .33799 Mdot
.49808 .34764 Mdot
.49814 .34764 Mdot
.4982 .33799 Mdot
.49826 .32109 Mdot
.49832 .30419 Mdot
.49838 .30177 Mdot
.49844 .3066 Mdot
.4985 .31385 Mdot
.49856 .31385 Mdot
.49862 .31143 Mdot
.49868 .31143 Mdot
.49874 .3235 Mdot
.4988 .34523 Mdot
.49886 .36454 Mdot
.49892 .38144 Mdot
.49898 .38869 Mdot
.49904 .38869 Mdot
.4991 .37903 Mdot
.49916 .35972 Mdot
.49922 .34282 Mdot
.49928 .33557 Mdot
.49934 .33316 Mdot
.4994 .32592 Mdot
.49946 .3066 Mdot
.49952 .28246 Mdot
.49958 .27039 Mdot
.49964 .27522 Mdot
.4997 .2897 Mdot
.49976 .29453 Mdot
.49982 .28729 Mdot
.49988 .2728 Mdot
.49994 .25832 Mdot
.5 .24625 Mdot
.50006 .24383 Mdot
.50012 .24142 Mdot
.50018 .23901 Mdot
.50024 .23901 Mdot
.5003 .23901 Mdot
.50036 .24142 Mdot
.50042 .24625 Mdot
.50048 .25832 Mdot
.50054 .28005 Mdot
.5006 .30177 Mdot
.50066 .31626 Mdot
.50072 .32109 Mdot
.50078 .31385 Mdot
.50084 .3066 Mdot
.5009 .3066 Mdot
.50096 .31385 Mdot
.50102 .32109 Mdot
.50108 .32109 Mdot
.50114 .31626 Mdot
.5012 .31385 Mdot
.50126 .31867 Mdot
.50132 .33074 Mdot
.50138 .34282 Mdot
.50144 .35247 Mdot
.5015 .3573 Mdot
.50156 .35489 Mdot
.50162 .34282 Mdot
.50168 .32833 Mdot
.50174 .31385 Mdot
.5018 .30902 Mdot
.50186 .31626 Mdot
.50192 .31867 Mdot
.50198 .31385 Mdot
.50204 .30419 Mdot
.5021 .30177 Mdot
.50216 .31867 Mdot
.50222 .34523 Mdot
.50228 .36937 Mdot
.50234 .37661 Mdot
.5024 .3742 Mdot
.50246 .36696 Mdot
.50252 .35972 Mdot
.50258 .3573 Mdot
.50264 .35489 Mdot
.5027 .34764 Mdot
.50276 .33799 Mdot
.50282 .32592 Mdot
.50288 .30902 Mdot
.50294 .29453 Mdot
.503 .2897 Mdot
.50306 .2897 Mdot
.50312 .29453 Mdot
.50318 .2897 Mdot
.50324 .27522 Mdot
.5033 .25349 Mdot
.50336 .23418 Mdot
.50342 .22452 Mdot
.50348 .22693 Mdot
.50354 .23176 Mdot
.5036 .22935 Mdot
.50366 .22693 Mdot
.50372 .22935 Mdot
.50378 .24142 Mdot
.50384 .26073 Mdot
.5039 .28488 Mdot
.50396 .3066 Mdot
.50402 .3235 Mdot
.50408 .33316 Mdot
.50414 .33316 Mdot
.5042 .32592 Mdot
.50426 .31626 Mdot
.50432 .31626 Mdot
.50438 .32109 Mdot
.50444 .32592 Mdot
.5045 .31867 Mdot
.50456 .30419 Mdot
.50462 .29695 Mdot
.50468 .30419 Mdot
.50474 .3235 Mdot
.5048 .34282 Mdot
.50486 .34764 Mdot
.50492 .3404 Mdot
.50498 .33074 Mdot
.50504 .3235 Mdot
.5051 .32109 Mdot
.50516 .3235 Mdot
.50522 .32592 Mdot
.50528 .32592 Mdot
.50534 .32592 Mdot
.5054 .32592 Mdot
.50546 .3235 Mdot
.50552 .33074 Mdot
.50558 .34764 Mdot
.50564 .36454 Mdot
.5057 .37661 Mdot
.50576 .3742 Mdot
.50582 .36213 Mdot
.50588 .34764 Mdot
.50594 .33799 Mdot
.506 .33799 Mdot
.50606 .33557 Mdot
.50612 .32833 Mdot
.50618 .31385 Mdot
.50624 .30177 Mdot
.5063 .29695 Mdot
.50636 .29695 Mdot
.50642 .30177 Mdot
.50648 .30177 Mdot
.50654 .29936 Mdot
.5066 .29212 Mdot
.50666 .28005 Mdot
.50672 .26073 Mdot
.50678 .24142 Mdot
.50684 .23176 Mdot
.5069 .23176 Mdot
.50696 .23418 Mdot
.50702 .23176 Mdot
.50708 .22452 Mdot
.50714 .22211 Mdot
.5072 .23418 Mdot
.50726 .26073 Mdot
.50732 .28729 Mdot
.50738 .3066 Mdot
.50744 .31626 Mdot
.5075 .31867 Mdot
.50756 .31867 Mdot
.50762 .32109 Mdot
.50768 .32592 Mdot
.50774 .33074 Mdot
.5078 .33316 Mdot
.50786 .33074 Mdot
.50792 .32592 Mdot
.50798 .31867 Mdot
.50804 .31867 Mdot
.5081 .32833 Mdot
.50816 .3404 Mdot
.50822 .34523 Mdot
.50828 .34282 Mdot
.50834 .32592 Mdot
.5084 .30902 Mdot
.50846 .30177 Mdot
.50852 .30419 Mdot
.50858 .31143 Mdot
.50864 .31626 Mdot
.5087 .31385 Mdot
.50876 .31143 Mdot
.50882 .31867 Mdot
.50888 .33557 Mdot
.50894 .35247 Mdot
.509 .36937 Mdot
.50906 .38144 Mdot
.50912 .38386 Mdot
.50918 .38144 Mdot
.50924 .36937 Mdot
.5093 .35489 Mdot
.50936 .34523 Mdot
.50942 .3404 Mdot
.50948 .33316 Mdot
.50954 .3235 Mdot
.5096 .30419 Mdot
.50966 .28488 Mdot
.50972 .28005 Mdot
.50978 .28729 Mdot
.50984 .29212 Mdot
.5099 .29453 Mdot
.50996 .28729 Mdot
.51002 .2728 Mdot
.51008 .25832 Mdot
.51014 .24625 Mdot
.5102 .24142 Mdot
.51026 .24142 Mdot
.51032 .24383 Mdot
.51038 .24383 Mdot
.51044 .24383 Mdot
.5105 .24383 Mdot
.51056 .24866 Mdot
.51062 .26315 Mdot
.51068 .28729 Mdot
.51074 .30419 Mdot
.5108 .31385 Mdot
.51086 .31143 Mdot
.51092 .30177 Mdot
.51098 .29936 Mdot
.51104 .3066 Mdot
.5111 .31626 Mdot
.51116 .32109 Mdot
.51122 .31867 Mdot
.51128 .31385 Mdot
.51134 .31385 Mdot
.5114 .3235 Mdot
.51146 .33316 Mdot
.51152 .34523 Mdot
.51158 .35247 Mdot
.51164 .35247 Mdot
.5117 .34523 Mdot
.51176 .33316 Mdot
.51182 .31867 Mdot
.51188 .31143 Mdot
.51194 .31143 Mdot
.512 .31626 Mdot
.51206 .31626 Mdot
.51212 .31143 Mdot
.51218 .30902 Mdot
.51224 .31385 Mdot
.5123 .33074 Mdot
.51236 .35247 Mdot
.51242 .36696 Mdot
.51248 .37179 Mdot
.51254 .36937 Mdot
.5126 .36213 Mdot
.51266 .35489 Mdot
.51272 .35006 Mdot
.51278 .34764 Mdot
.51284 .34282 Mdot
.5129 .33557 Mdot
.51296 .3235 Mdot
.51302 .31143 Mdot
.51308 .29936 Mdot
.51314 .29453 Mdot
.5132 .29695 Mdot
.51326 .29936 Mdot
.51332 .29212 Mdot
.51338 .2728 Mdot
.51344 .25108 Mdot
.5135 .23418 Mdot
.51356 .22935 Mdot
.51362 .23418 Mdot
.51368 .23659 Mdot
.51374 .23418 Mdot
.5138 .23176 Mdot
.51386 .23418 Mdot
.51392 .24866 Mdot
.51398 .27039 Mdot
.51404 .2897 Mdot
.5141 .3066 Mdot
.51416 .32109 Mdot
.51422 .3235 Mdot
.51428 .32109 Mdot
.51434 .31626 Mdot
.5144 .31385 Mdot
.51446 .31626 Mdot
.51452 .32109 Mdot
.51458 .32109 Mdot
.51464 .31626 Mdot
.5147 .30902 Mdot
.51476 .3066 Mdot
.51482 .31626 Mdot
.51488 .32833 Mdot
.51494 .33799 Mdot
.515 .33799 Mdot
.51506 .33316 Mdot
.51512 .3235 Mdot
.51518 .31867 Mdot
.51524 .31626 Mdot
.5153 .31867 Mdot
.51536 .32109 Mdot
.51542 .32592 Mdot
.51548 .32833 Mdot
.51554 .32592 Mdot
.5156 .32833 Mdot
.51566 .33557 Mdot
.51572 .35006 Mdot
.51578 .36696 Mdot
.51584 .37179 Mdot
.5159 .36696 Mdot
.51596 .35247 Mdot
.51602 .33799 Mdot
.51608 .33316 Mdot
.51614 .33316 Mdot
.5162 .33316 Mdot
.51626 .32592 Mdot
.51632 .31385 Mdot
.51638 .30419 Mdot
.51644 .29936 Mdot
.5165 .30419 Mdot
.51656 .30902 Mdot
.51662 .30902 Mdot
.51668 .30419 Mdot
.51674 .29212 Mdot
.5168 .27522 Mdot
.51686 .25832 Mdot
.51692 .24383 Mdot
.51698 .23659 Mdot
.51704 .23901 Mdot
.5171 .24142 Mdot
.51716 .23659 Mdot
.51722 .23176 Mdot
.51728 .23418 Mdot
.51734 .25108 Mdot
.5174 .2728 Mdot
.51746 .29453 Mdot
.51752 .3066 Mdot
.51758 .31143 Mdot
.51764 .31143 Mdot
.5177 .31385 Mdot
.51776 .31867 Mdot
.51782 .32109 Mdot
.51788 .32592 Mdot
.51794 .33074 Mdot
.518 .33074 Mdot
.51806 .32833 Mdot
.51812 .3235 Mdot
.51818 .32592 Mdot
.51824 .33316 Mdot
.5183 .3404 Mdot
.51836 .34282 Mdot
.51842 .33557 Mdot
.51848 .31867 Mdot
.51854 .30419 Mdot
.5186 .29695 Mdot
.51866 .30177 Mdot
.51872 .30902 Mdot
.51878 .31385 Mdot
.51884 .31385 Mdot
.5189 .31385 Mdot
.51896 .3235 Mdot
.51902 .33799 Mdot
.51908 .35247 Mdot
.51914 .36696 Mdot
.5192 .37661 Mdot
.51926 .37661 Mdot
.51932 .36937 Mdot
.51938 .3573 Mdot
.51944 .34523 Mdot
.5195 .33799 Mdot
.51956 .33557 Mdot
.51962 .32833 Mdot
.51968 .31626 Mdot
.51974 .29936 Mdot
.5198 .2897 Mdot
.51986 .2897 Mdot
.51992 .29453 Mdot
.51998 .29695 Mdot
.52004 .29453 Mdot
.5201 .28246 Mdot
.52016 .27039 Mdot
.52022 .25832 Mdot
.52028 .24866 Mdot
.52034 .24625 Mdot
.5204 .24625 Mdot
.52046 .24866 Mdot
.52052 .25108 Mdot
.52058 .25349 Mdot
.52064 .25349 Mdot
.5207 .26315 Mdot
.52076 .27763 Mdot
.52082 .29453 Mdot
.52088 .3066 Mdot
.52094 .31143 Mdot
.521 .30902 Mdot
.52106 .30419 Mdot
.52112 .29936 Mdot
.52118 .30419 Mdot
.52124 .31143 Mdot
.5213 .31867 Mdot
.52136 .31867 Mdot
.52142 .31626 Mdot
.52148 .31867 Mdot
.52154 .32592 Mdot
.5216 .33799 Mdot
.52166 .34764 Mdot
.52172 .35006 Mdot
.52178 .34764 Mdot
.52184 .3404 Mdot
.5219 .32592 Mdot
.52196 .31385 Mdot
.52202 .3066 Mdot
.52208 .30902 Mdot
.52214 .31385 Mdot
.5222 .31626 Mdot
.52226 .31143 Mdot
.52232 .30902 Mdot
.52238 .31867 Mdot
.52244 .33557 Mdot
.5225 .35247 Mdot
.52256 .35972 Mdot
.52262 .35972 Mdot
.52268 .35489 Mdot
.52274 .35006 Mdot
.5228 .34523 Mdot
.52286 .3404 Mdot
.52292 .33557 Mdot
.52298 .33316 Mdot
.52304 .32833 Mdot
.5231 .32109 Mdot
.52316 .31143 Mdot
.52322 .30419 Mdot
.52328 .30177 Mdot
.52334 .30177 Mdot
.5234 .29936 Mdot
.52346 .29212 Mdot
.52352 .27522 Mdot
.52358 .2559 Mdot
.52364 .24142 Mdot
.5237 .23659 Mdot
.52376 .23659 Mdot
.52382 .24142 Mdot
.52388 .24142 Mdot
.52394 .24383 Mdot
.524 .25108 Mdot
.52406 .26315 Mdot
.52412 .28005 Mdot
.52418 .29695 Mdot
.52424 .31143 Mdot
.5243 .32109 Mdot
.52436 .3235 Mdot
.52442 .31867 Mdot
.52448 .31143 Mdot
.52454 .3066 Mdot
.5246 .31143 Mdot
.52466 .31626 Mdot
.52472 .31867 Mdot
.52478 .31385 Mdot
.52484 .30902 Mdot
.5249 .31385 Mdot
.52496 .3235 Mdot
.52502 .33316 Mdot
.52508 .3404 Mdot
.52514 .33557 Mdot
.5252 .32833 Mdot
.52526 .3235 Mdot
.52532 .31867 Mdot
.52538 .31626 Mdot
.52544 .31626 Mdot
.5255 .31867 Mdot
.52556 .32109 Mdot
.52562 .32592 Mdot
.52568 .32592 Mdot
.52574 .32833 Mdot
.5258 .33557 Mdot
.52586 .34523 Mdot
.52592 .35489 Mdot
.52598 .3573 Mdot
.52604 .35006 Mdot
.5261 .33799 Mdot
.52616 .32833 Mdot
.52622 .3235 Mdot
.52628 .3235 Mdot
.52634 .32109 Mdot
.5264 .31626 Mdot
.52646 .30902 Mdot
.52652 .30419 Mdot
.52658 .30419 Mdot
.52663 .30902 Mdot
.52669 .30902 Mdot
.52675 .30902 Mdot
.52681 .30177 Mdot
.52687 .29212 Mdot
.52693 .28005 Mdot
.52699 .26073 Mdot
.52705 .24866 Mdot
.52711 .24383 Mdot
.52717 .24625 Mdot
.52723 .24866 Mdot
.52729 .24625 Mdot
.52735 .24383 Mdot
.52741 .24866 Mdot
.52747 .26315 Mdot
.52753 .28488 Mdot
.52759 .29936 Mdot
.52765 .3066 Mdot
.52771 .3066 Mdot
.52777 .30902 Mdot
.52783 .31143 Mdot
.52789 .31385 Mdot
.52795 .31626 Mdot
.52801 .32109 Mdot
.52807 .3235 Mdot
.52813 .32592 Mdot
.52819 .32592 Mdot
.52825 .32592 Mdot
.52831 .32833 Mdot
.52837 .33557 Mdot
.52843 .34282 Mdot
.52849 .3404 Mdot
.52855 .33074 Mdot
.52861 .31867 Mdot
.52867 .3066 Mdot
.52873 .30177 Mdot
.52879 .30419 Mdot
.52885 .3066 Mdot
.52891 .30902 Mdot
.52897 .31143 Mdot
.52903 .31626 Mdot
.52909 .3235 Mdot
.52915 .33557 Mdot
.52921 .34764 Mdot
.52927 .35972 Mdot
.52933 .36454 Mdot
.52939 .36454 Mdot
.52945 .3573 Mdot
.52951 .34523 Mdot
.52957 .33557 Mdot
.52963 .32833 Mdot
.52969 .32592 Mdot
.52975 .3235 Mdot
.52981 .31385 Mdot
.52987 .29936 Mdot
.52993 .2897 Mdot
.52999 .2897 Mdot
.53005 .29695 Mdot
.53011 .29936 Mdot
.53017 .29212 Mdot
.53023 .28246 Mdot
.53029 .2728 Mdot
.53035 .26315 Mdot
.53041 .2559 Mdot
.53047 .25108 Mdot
.53053 .25349 Mdot
.53059 .2559 Mdot
.53065 .26073 Mdot
.53071 .26073 Mdot
.53077 .26556 Mdot
.53083 .2728 Mdot
.53089 .28488 Mdot
.53095 .30177 Mdot
.53101 .30902 Mdot
.53107 .30902 Mdot
.53113 .30419 Mdot
.53119 .29936 Mdot
.53125 .29936 Mdot
.53131 .30419 Mdot
.53137 .30902 Mdot
.53143 .31385 Mdot
.53149 .31385 Mdot
.53155 .31626 Mdot
.53161 .32109 Mdot
.53167 .33074 Mdot
.53173 .33799 Mdot
.53179 .34523 Mdot
.53185 .34764 Mdot
.53191 .34523 Mdot
.53197 .33799 Mdot
.53203 .32592 Mdot
.53209 .31385 Mdot
.53215 .30902 Mdot
.53221 .31143 Mdot
.53227 .31626 Mdot
.53233 .31385 Mdot
.53239 .30902 Mdot
.53245 .30902 Mdot
.53251 .31867 Mdot
.53257 .33316 Mdot
.53263 .34523 Mdot
.53269 .35247 Mdot
.53275 .35006 Mdot
.53281 .34764 Mdot
.53287 .34282 Mdot
.53293 .33799 Mdot
.53299 .33316 Mdot
.53305 .33074 Mdot
.53311 .33074 Mdot
.53317 .32592 Mdot
.53323 .31626 Mdot
.53329 .3066 Mdot
.53335 .30177 Mdot
.53341 .29936 Mdot
.53347 .29936 Mdot
.53353 .29695 Mdot
.53359 .28488 Mdot
.53365 .26798 Mdot
.53371 .25349 Mdot
.53377 .24383 Mdot
.53383 .24142 Mdot
.53389 .24383 Mdot
.53395 .24625 Mdot
.53401 .24866 Mdot
.53407 .25108 Mdot
.53413 .26073 Mdot
.53419 .2728 Mdot
.53425 .28729 Mdot
.53431 .30177 Mdot
.53437 .31385 Mdot
.53443 .32109 Mdot
.53449 .32109 Mdot
.53455 .31867 Mdot
.53461 .31143 Mdot
.53467 .30902 Mdot
.53473 .31385 Mdot
.53479 .31867 Mdot
.53485 .31867 Mdot
.53491 .31385 Mdot
.53497 .31143 Mdot
.53503 .31385 Mdot
.53509 .3235 Mdot
.53515 .33316 Mdot
.53521 .33557 Mdot
.53527 .33316 Mdot
.53533 .32833 Mdot
.53539 .3235 Mdot
.53545 .31867 Mdot
.53551 .31385 Mdot
.53557 .31626 Mdot
.53563 .32109 Mdot
.53569 .32592 Mdot
.53575 .32833 Mdot
.53581 .32592 Mdot
.53587 .32833 Mdot
.53593 .33799 Mdot
.53599 .34764 Mdot
.53605 .35489 Mdot
.53611 .35489 Mdot
.53617 .34523 Mdot
.53623 .33316 Mdot
.53629 .32592 Mdot
.53635 .3235 Mdot
.53641 .32109 Mdot
.53647 .31867 Mdot
.53653 .31385 Mdot
.53659 .3066 Mdot
.53665 .30419 Mdot
.53671 .30419 Mdot
.53677 .30419 Mdot
.53683 .30419 Mdot
.53689 .30419 Mdot
.53695 .29695 Mdot
.53701 .28729 Mdot
.53707 .2728 Mdot
.53713 .25832 Mdot
.53719 .24866 Mdot
.53725 .24625 Mdot
.53731 .25108 Mdot
.53737 .25349 Mdot
.53743 .25108 Mdot
.53749 .25108 Mdot
.53755 .25832 Mdot
.53761 .2728 Mdot
.53767 .2897 Mdot
.53773 .30177 Mdot
.53779 .30902 Mdot
.53785 .31143 Mdot
.53791 .31143 Mdot
.53797 .31143 Mdot
.53803 .31385 Mdot
.53809 .31626 Mdot
.53815 .3235 Mdot
.53821 .32833 Mdot
.53827 .32833 Mdot
.53833 .32592 Mdot
.53839 .32592 Mdot
.53845 .32833 Mdot
.53851 .33799 Mdot
.53857 .34282 Mdot
.53863 .33799 Mdot
.53869 .32833 Mdot
.53875 .31385 Mdot
.53881 .30419 Mdot
.53887 .30177 Mdot
.53893 .3066 Mdot
.53899 .31143 Mdot
.53905 .31385 Mdot
.53911 .31385 Mdot
.53917 .31867 Mdot
.53923 .32833 Mdot
.53929 .33799 Mdot
.53935 .35006 Mdot
.53941 .35972 Mdot
.53947 .36213 Mdot
.53953 .35972 Mdot
.53959 .35006 Mdot
.53965 .3404 Mdot
.53971 .33074 Mdot
.53977 .32833 Mdot
.53983 .32592 Mdot
.53989 .32109 Mdot
.53995 .30902 Mdot
.54001 .29936 Mdot
.54007 .29212 Mdot
.54013 .29212 Mdot
.54019 .29453 Mdot
.54025 .29453 Mdot
.54031 .28729 Mdot
.54037 .27763 Mdot
.54043 .26798 Mdot
.54049 .25832 Mdot
.54055 .25349 Mdot
.54061 .25108 Mdot
.54067 .2559 Mdot
.54073 .26073 Mdot
.54079 .26315 Mdot
.54085 .26556 Mdot
.54091 .27039 Mdot
.54097 .28005 Mdot
.54103 .29212 Mdot
.54109 .30419 Mdot
.54115 .31143 Mdot
.54121 .30902 Mdot
.54127 .30177 Mdot
.54133 .29695 Mdot
.54139 .29936 Mdot
.54145 .3066 Mdot
.54151 .31143 Mdot
.54157 .31626 Mdot
.54163 .31626 Mdot
.54169 .31626 Mdot
.54175 .3235 Mdot
.54181 .33074 Mdot
.54187 .3404 Mdot
.54193 .34523 Mdot
.54199 .34523 Mdot
.54205 .3404 Mdot
.54211 .33074 Mdot
.54217 .32109 Mdot
.54223 .31143 Mdot
.54229 .30902 Mdot
.54235 .31385 Mdot
.54241 .31626 Mdot
.54247 .31626 Mdot
.54253 .31385 Mdot
.54259 .31626 Mdot
.54265 .32592 Mdot
.54271 .33799 Mdot
.54277 .34764 Mdot
.54283 .35006 Mdot
.54289 .34764 Mdot
.54295 .34282 Mdot
.54301 .33799 Mdot
.54307 .33316 Mdot
.54313 .33074 Mdot
.54319 .33074 Mdot
.54325 .32833 Mdot
.54331 .32592 Mdot
.54337 .31626 Mdot
.54343 .30902 Mdot
.54349 .30177 Mdot
.54355 .30177 Mdot
.54361 .29936 Mdot
.54367 .29453 Mdot
.54373 .28246 Mdot
.54379 .26315 Mdot
.54385 .24866 Mdot
.54391 .24142 Mdot
.54397 .24383 Mdot
.54403 .24625 Mdot
.54409 .25108 Mdot
.54415 .25349 Mdot
.54421 .25832 Mdot
.54427 .26556 Mdot
.54433 .28005 Mdot
.54439 .29453 Mdot
.54445 .3066 Mdot
.54451 .31626 Mdot
.54457 .31867 Mdot
.54463 .31626 Mdot
.54469 .31143 Mdot
.54475 .3066 Mdot
.54481 .30902 Mdot
.54487 .31385 Mdot
.54493 .31867 Mdot
.54499 .31867 Mdot
.54505 .31385 Mdot
.54511 .31143 Mdot
.54517 .31626 Mdot
.54523 .32592 Mdot
.54529 .33316 Mdot
.54535 .33316 Mdot
.54541 .32833 Mdot
.54547 .32109 Mdot
.54553 .31626 Mdot
.54559 .31385 Mdot
.54565 .31385 Mdot
.54571 .31626 Mdot
.54577 .3235 Mdot
.54583 .32833 Mdot
.54589 .32833 Mdot
.54595 .32833 Mdot
.54601 .33074 Mdot
.54607 .33799 Mdot
.54613 .34764 Mdot
.54619 .35247 Mdot
.54625 .34764 Mdot
.54631 .33799 Mdot
.54637 .32833 Mdot
.54643 .32109 Mdot
.54649 .32109 Mdot
.54655 .32109 Mdot
.54661 .31867 Mdot
.54667 .31626 Mdot
.54673 .31143 Mdot
.54679 .3066 Mdot
.54685 .3066 Mdot
.54691 .3066 Mdot
.54697 .3066 Mdot
.54703 .30177 Mdot
.54709 .29453 Mdot
.54715 .28246 Mdot
.54721 .26556 Mdot
.54727 .25108 Mdot
.54733 .24866 Mdot
.54739 .25108 Mdot
.54745 .2559 Mdot
.54751 .2559 Mdot
.54757 .2559 Mdot
.54763 .2559 Mdot
.54769 .26556 Mdot
.54775 .28005 Mdot
.54781 .29453 Mdot
.54787 .30177 Mdot
.54793 .3066 Mdot
.54799 .3066 Mdot
.54805 .30902 Mdot
.54811 .31143 Mdot
.54817 .31143 Mdot
.54823 .31626 Mdot
.54829 .3235 Mdot
.54835 .32833 Mdot
.54841 .32833 Mdot
.54847 .32592 Mdot
.54853 .32592 Mdot
.54859 .32833 Mdot
.54865 .33557 Mdot
.54871 .33799 Mdot
.54877 .33316 Mdot
.54883 .32109 Mdot
.54889 .3066 Mdot
.54895 .30177 Mdot
.54901 .30177 Mdot
.54907 .3066 Mdot
.54913 .31143 Mdot
.54919 .31385 Mdot
.54925 .31867 Mdot
.54931 .3235 Mdot
.54937 .33316 Mdot
.54943 .3404 Mdot
.54949 .34764 Mdot
.54955 .35489 Mdot
.54961 .35489 Mdot
.54967 .35006 Mdot
.54973 .3404 Mdot
.54979 .33074 Mdot
.54985 .3235 Mdot
.54991 .3235 Mdot
.54997 .3235 Mdot
.55003 .31867 Mdot
.55009 .30902 Mdot
.55015 .29936 Mdot
.55021 .29695 Mdot
.55027 .29695 Mdot
.55033 .29936 Mdot
.55039 .29453 Mdot
.55045 .28488 Mdot
.55051 .27522 Mdot
.55057 .26798 Mdot
.55063 .26315 Mdot
.55069 .25832 Mdot
.55075 .2559 Mdot
.55081 .26073 Mdot
.55087 .26798 Mdot
.55093 .2728 Mdot
.55099 .27522 Mdot
.55105 .27763 Mdot
.55111 .28488 Mdot
.55117 .29453 Mdot
.55123 .30419 Mdot
.55129 .3066 Mdot
.55135 .30177 Mdot
.55141 .29695 Mdot
.55147 .29453 Mdot
.55153 .29695 Mdot
.55159 .30419 Mdot
.55165 .30902 Mdot
.55171 .31385 Mdot
.55177 .31867 Mdot
.55183 .3235 Mdot
.55189 .32833 Mdot
.55195 .33316 Mdot
.55201 .33799 Mdot
.55207 .3404 Mdot
.55213 .3404 Mdot
.55219 .33557 Mdot
.55225 .32592 Mdot
.55231 .31626 Mdot
.55237 .30902 Mdot
.55243 .30902 Mdot
.55249 .31385 Mdot
.55255 .31626 Mdot
.55261 .31626 Mdot
.55267 .31626 Mdot
.55273 .31867 Mdot
.55279 .32833 Mdot
.55285 .33799 Mdot
.55291 .34282 Mdot
.55297 .34282 Mdot
.55303 .33799 Mdot
.55309 .33557 Mdot
.55315 .33074 Mdot
.55321 .32833 Mdot
.55327 .32592 Mdot
.55333 .32592 Mdot
.55339 .32592 Mdot
.55345 .3235 Mdot
.55351 .31867 Mdot
.55357 .31143 Mdot
.55363 .3066 Mdot
.55369 .30419 Mdot
.55375 .29936 Mdot
.55381 .29212 Mdot
.55387 .27763 Mdot
.55393 .26556 Mdot
.55399 .25349 Mdot
.55405 .24866 Mdot
.55411 .24866 Mdot
.55417 .25349 Mdot
.55423 .25832 Mdot
.55429 .26315 Mdot
.55435 .27039 Mdot
.55441 .27763 Mdot
.55447 .28729 Mdot
.55453 .29936 Mdot
.55459 .30902 Mdot
.55465 .31385 Mdot
.55471 .31385 Mdot
.55477 .31143 Mdot
.55483 .3066 Mdot
.55489 .30419 Mdot
.55495 .3066 Mdot
.55501 .31143 Mdot
.55507 .31626 Mdot
.55513 .31626 Mdot
.55519 .31385 Mdot
.55525 .31626 Mdot
.55531 .32109 Mdot
.55537 .32833 Mdot
.55543 .33316 Mdot
.55549 .33316 Mdot
.55555 .32592 Mdot
.55561 .32109 Mdot
.55567 .31626 Mdot
.55573 .31385 Mdot
.55579 .31385 Mdot
.55585 .31867 Mdot
.55591 .3235 Mdot
.55597 .32592 Mdot
.55603 .32833 Mdot
.55609 .32833 Mdot
.55615 .32833 Mdot
.55621 .33557 Mdot
.55627 .34282 Mdot
.55633 .34523 Mdot
.55639 .3404 Mdot
.55645 .33074 Mdot
.55651 .3235 Mdot
.55657 .31867 Mdot
.55663 .31867 Mdot
.55669 .31867 Mdot
.55675 .31867 Mdot
.55681 .31626 Mdot
.55687 .31385 Mdot
.55693 .31143 Mdot
.55699 .30902 Mdot
.55705 .30902 Mdot
.55711 .3066 Mdot
.55717 .30419 Mdot
.55723 .29453 Mdot
.55729 .28246 Mdot
.55735 .27039 Mdot
.55741 .25832 Mdot
.55747 .25349 Mdot
.55753 .2559 Mdot
.55759 .26073 Mdot
.55765 .26315 Mdot
.55771 .26315 Mdot
.55777 .26556 Mdot
.55783 .2728 Mdot
.55789 .28729 Mdot
.55795 .29695 Mdot
.55801 .30419 Mdot
.55807 .3066 Mdot
.55813 .30902 Mdot
.55819 .30902 Mdot
.55825 .30902 Mdot
.55831 .31143 Mdot
.55837 .31626 Mdot
.55843 .32109 Mdot
.55849 .32592 Mdot
.55855 .32592 Mdot
.55861 .32592 Mdot
.55867 .32592 Mdot
.55873 .32833 Mdot
.55879 .33316 Mdot
.55885 .33316 Mdot
.55891 .32592 Mdot
.55897 .31867 Mdot
.55903 .30902 Mdot
.55909 .30419 Mdot
.55915 .30419 Mdot
.55921 .30902 Mdot
.55927 .31143 Mdot
.55933 .31626 Mdot
.55939 .32109 Mdot
.55945 .32592 Mdot
.55951 .33074 Mdot
.55957 .33799 Mdot
.55963 .34523 Mdot
.55969 .35006 Mdot
.55975 .35006 Mdot
.55981 .34282 Mdot
.55987 .33557 Mdot
.55993 .32592 Mdot
.55999 .32109 Mdot
.56005 .32109 Mdot
.56011 .32109 Mdot
.56017 .31626 Mdot
.56023 .30902 Mdot
.56029 .30177 Mdot
.56035 .29936 Mdot
.56041 .29936 Mdot
.56047 .29936 Mdot
.56053 .29695 Mdot
.56059 .2897 Mdot
.56065 .28005 Mdot
.56071 .2728 Mdot
.56077 .26556 Mdot
.56083 .26315 Mdot
.56089 .26315 Mdot
.56095 .26798 Mdot
.56101 .2728 Mdot
.56107 .27522 Mdot
.56113 .27522 Mdot
.56119 .28005 Mdot
.56125 .28729 Mdot
.56131 .29695 Mdot
.56137 .30419 Mdot
.56143 .3066 Mdot
.56149 .30177 Mdot
.56155 .29695 Mdot
.56161 .29695 Mdot
.56167 .30177 Mdot
.56173 .30902 Mdot
.56179 .31385 Mdot
.56185 .31867 Mdot
.56191 .3235 Mdot
.56197 .3235 Mdot
.56203 .32833 Mdot
.56209 .33316 Mdot
.56215 .33799 Mdot
.56221 .3404 Mdot
.56227 .33799 Mdot
.56233 .33074 Mdot
.56239 .32109 Mdot
.56245 .31143 Mdot
.56251 .3066 Mdot
.56257 .30902 Mdot
.56263 .31385 Mdot
.56269 .31626 Mdot
.56275 .31626 Mdot
.56281 .31626 Mdot
.56287 .31867 Mdot
.56293 .32592 Mdot
.56299 .33557 Mdot
.56305 .3404 Mdot
.56311 .34282 Mdot
.56317 .33799 Mdot
.56323 .33316 Mdot
.56329 .33074 Mdot
.56335 .32833 Mdot
.56341 .32833 Mdot
.56347 .32833 Mdot
.56353 .32833 Mdot
.56359 .3235 Mdot
.56365 .31385 Mdot
.56371 .3066 Mdot
.56377 .30419 Mdot
.56383 .30419 Mdot
.56389 .29936 Mdot
.56395 .29212 Mdot
.56401 .27763 Mdot
.56407 .26556 Mdot
.56413 .25832 Mdot
.56419 .2559 Mdot
.56425 .25832 Mdot
.56431 .26315 Mdot
.56437 .26556 Mdot
.56443 .27039 Mdot
.56449 .27522 Mdot
.56455 .28005 Mdot
.56461 .2897 Mdot
.56467 .30177 Mdot
.56473 .30902 Mdot
.56479 .31385 Mdot
.56485 .31385 Mdot
.56491 .30902 Mdot
.56497 .3066 Mdot
.56503 .3066 Mdot
.56509 .30902 Mdot
.56515 .31626 Mdot
.56521 .31867 Mdot
.56527 .31867 Mdot
.56533 .31626 Mdot
.56539 .31867 Mdot
.56545 .32109 Mdot
.56551 .32833 Mdot
.56557 .33074 Mdot
.56563 .32833 Mdot
.56569 .3235 Mdot
.56575 .31867 Mdot
.56581 .31385 Mdot
.56587 .31143 Mdot
.56593 .31385 Mdot
.56599 .31867 Mdot
.56605 .3235 Mdot
.56611 .32592 Mdot
.56617 .32592 Mdot
.56623 .32592 Mdot
.56629 .32833 Mdot
.56635 .33557 Mdot
.56641 .3404 Mdot
.56647 .3404 Mdot
.56653 .33316 Mdot
.56659 .32592 Mdot
.56665 .32109 Mdot
.56671 .31867 Mdot
.56677 .32109 Mdot
.56683 .32109 Mdot
.56689 .32109 Mdot
.56695 .31867 Mdot
.56701 .31385 Mdot
.56707 .31143 Mdot
.56713 .30902 Mdot
.56719 .3066 Mdot
.56725 .3066 Mdot
.56731 .30177 Mdot
.56737 .2897 Mdot
.56743 .27763 Mdot
.56749 .26556 Mdot
.56755 .26073 Mdot
.56761 .25832 Mdot
.56767 .26315 Mdot
.56773 .26556 Mdot
.56779 .26798 Mdot
.56785 .26798 Mdot
.56791 .27039 Mdot
.56797 .28005 Mdot
.56803 .2897 Mdot
.56809 .29936 Mdot
.56815 .30419 Mdot
.56821 .3066 Mdot
.56827 .30902 Mdot
.56833 .30902 Mdot
.56839 .30902 Mdot
.56845 .31385 Mdot
.56851 .31867 Mdot
.56857 .32592 Mdot
.56863 .32833 Mdot
.56869 .32592 Mdot
.56875 .3235 Mdot
.56881 .3235 Mdot
.56887 .32833 Mdot
.56893 .33074 Mdot
.56899 .33074 Mdot
.56905 .32109 Mdot
.56911 .31143 Mdot
.56917 .3066 Mdot
.56923 .30419 Mdot
.56929 .3066 Mdot
.56935 .31143 Mdot
.56941 .31626 Mdot
.56947 .31867 Mdot
.56953 .3235 Mdot
.56959 .32592 Mdot
.56965 .33074 Mdot
.56971 .33557 Mdot
.56977 .34282 Mdot
.56983 .34523 Mdot
.56989 .34282 Mdot
.56995 .33557 Mdot
.57001 .32833 Mdot
.57007 .32109 Mdot
.57013 .32109 Mdot
.57019 .3235 Mdot
.57025 .3235 Mdot
.57031 .31867 Mdot
.57037 .30902 Mdot
.57043 .30419 Mdot
.57049 .30177 Mdot
.57055 .30177 Mdot
.57061 .30177 Mdot
.57067 .29453 Mdot
.57073 .28729 Mdot
.57079 .27763 Mdot
.57085 .27039 Mdot
.57091 .26556 Mdot
.57097 .26556 Mdot
.57103 .26798 Mdot
.57109 .2728 Mdot
.57115 .27522 Mdot
.57121 .27763 Mdot
.57127 .27763 Mdot
.57133 .28246 Mdot
.57139 .2897 Mdot
.57145 .29936 Mdot
.57151 .3066 Mdot
.57157 .30419 Mdot
.57163 .29936 Mdot
.57169 .29695 Mdot
.57175 .29936 Mdot
.57181 .3066 Mdot
.57187 .31385 Mdot
.57193 .31867 Mdot
.57199 .32109 Mdot
.57205 .3235 Mdot
.57211 .32592 Mdot
.57217 .32833 Mdot
.57223 .33316 Mdot
.57229 .33557 Mdot
.57235 .33557 Mdot
.57241 .33074 Mdot
.57247 .3235 Mdot
.57253 .31385 Mdot
.57259 .3066 Mdot
.57265 .3066 Mdot
.57271 .31143 Mdot
.57277 .31626 Mdot
.57283 .31626 Mdot
.57289 .31385 Mdot
.57295 .31626 Mdot
.57301 .32109 Mdot
.57307 .32833 Mdot
.57313 .33557 Mdot
.57319 .33799 Mdot
.57325 .33799 Mdot
.57331 .33316 Mdot
.57337 .33074 Mdot
.57343 .32833 Mdot
.57349 .32592 Mdot
.57355 .32592 Mdot
.57361 .32833 Mdot
.57367 .32833 Mdot
.57373 .32109 Mdot
.57379 .31385 Mdot
.57385 .3066 Mdot
.57391 .30419 Mdot
.57397 .30177 Mdot
.57403 .29936 Mdot
.57409 .28729 Mdot
.57415 .2728 Mdot
.57421 .26315 Mdot
.57427 .25832 Mdot
.57433 .25832 Mdot
.57439 .26315 Mdot
.57445 .26556 Mdot
.57451 .27039 Mdot
.57457 .27522 Mdot
.57463 .28005 Mdot
.57469 .28488 Mdot
.57475 .29212 Mdot
.57481 .30177 Mdot
.57487 .30902 Mdot
.57493 .31143 Mdot
.57499 .30902 Mdot
.57505 .3066 Mdot
.57511 .30419 Mdot
.57517 .3066 Mdot
.57523 .31385 Mdot
.57529 .31867 Mdot
.57535 .32109 Mdot
.57541 .31867 Mdot
.57547 .31867 Mdot
.57553 .32109 Mdot
.57559 .32592 Mdot
.57565 .33074 Mdot
.57571 .33074 Mdot
.57577 .32592 Mdot
.57583 .32109 Mdot
.57589 .31626 Mdot
.57595 .31143 Mdot
.57601 .31143 Mdot
.57607 .31385 Mdot
.57613 .31867 Mdot
.57619 .3235 Mdot
.57625 .32592 Mdot
.57631 .3235 Mdot
.57637 .3235 Mdot
.57643 .32592 Mdot
.57649 .33316 Mdot
.57655 .33799 Mdot
.57661 .33557 Mdot
.57667 .32833 Mdot
.57673 .32109 Mdot
.57679 .31867 Mdot
.57685 .31867 Mdot
.57691 .32109 Mdot
.57697 .32109 Mdot
.57703 .32109 Mdot
.57709 .31867 Mdot
.57715 .31626 Mdot
.57721 .31385 Mdot
.57727 .30902 Mdot
.57733 .3066 Mdot
.57739 .30419 Mdot
.57745 .29695 Mdot
.57751 .28729 Mdot
.57757 .27522 Mdot
.57763 .26556 Mdot
.57769 .26073 Mdot
.57775 .26315 Mdot
.57781 .26798 Mdot
.57787 .27039 Mdot
.57793 .27039 Mdot
.57799 .2728 Mdot
.57805 .27763 Mdot
.57811 .28488 Mdot
.57817 .29453 Mdot
.57823 .30177 Mdot
.57829 .30419 Mdot
.57835 .30419 Mdot
.57841 .3066 Mdot
.57847 .3066 Mdot
.57853 .30902 Mdot
.57859 .31385 Mdot
.57865 .31867 Mdot
.57871 .32592 Mdot
.57877 .32833 Mdot
.57883 .32592 Mdot
.57889 .32592 Mdot
.57895 .32592 Mdot
.57901 .32833 Mdot
.57907 .33074 Mdot
.57913 .32592 Mdot
.57919 .31626 Mdot
.57925 .30902 Mdot
.57931 .3066 Mdot
.57937 .30902 Mdot
.57943 .30902 Mdot
.57949 .31143 Mdot
.57955 .31626 Mdot
.57961 .32109 Mdot
.57967 .3235 Mdot
.57973 .32592 Mdot
.57979 .32833 Mdot
.57984 .33316 Mdot
.5799 .33799 Mdot
.57996 .33799 Mdot
.58002 .33557 Mdot
.58008 .32833 Mdot
.58014 .3235 Mdot
.5802 .31867 Mdot
.58026 .31867 Mdot
.58032 .32109 Mdot
.58038 .32109 Mdot
.58044 .31385 Mdot
.5805 .30902 Mdot
.58056 .3066 Mdot
.58062 .30419 Mdot
.58068 .30419 Mdot
.58074 .29936 Mdot
.5808 .29212 Mdot
.58086 .28488 Mdot
.58092 .28005 Mdot
.58098 .2728 Mdot
.58104 .26798 Mdot
.5811 .26798 Mdot
.58116 .2728 Mdot
.58122 .27763 Mdot
.58128 .28005 Mdot
.58134 .28246 Mdot
.5814 .28246 Mdot
.58146 .28729 Mdot
.58152 .29453 Mdot
.58158 .30177 Mdot
.58164 .30419 Mdot
.5817 .30177 Mdot
.58176 .29936 Mdot
.58182 .29936 Mdot
.58188 .30177 Mdot
.58194 .3066 Mdot
.582 .31143 Mdot
.58206 .31626 Mdot
.58212 .32109 Mdot
.58218 .3235 Mdot
.58224 .32592 Mdot
.5823 .32833 Mdot
.58236 .33074 Mdot
.58242 .33074 Mdot
.58248 .33074 Mdot
.58254 .32592 Mdot
.5826 .32109 Mdot
.58266 .31385 Mdot
.58272 .30902 Mdot
.58278 .30902 Mdot
.58284 .31143 Mdot
.5829 .31626 Mdot
.58296 .31626 Mdot
.58302 .31385 Mdot
.58308 .31626 Mdot
.58314 .32109 Mdot
.5832 .32592 Mdot
.58326 .33074 Mdot
.58332 .33316 Mdot
.58338 .33074 Mdot
.58344 .32833 Mdot
.5835 .32592 Mdot
.58356 .3235 Mdot
.58362 .3235 Mdot
.58368 .3235 Mdot
.58374 .32592 Mdot
.5838 .3235 Mdot
.58386 .31867 Mdot
.58392 .31143 Mdot
.58398 .3066 Mdot
.58404 .3066 Mdot
.5841 .30419 Mdot
.58416 .29695 Mdot
.58422 .28729 Mdot
.58428 .27763 Mdot
.58434 .26798 Mdot
.5844 .26556 Mdot
.58446 .26556 Mdot
.58452 .26798 Mdot
.58458 .27039 Mdot
.58464 .27522 Mdot
.5847 .28005 Mdot
.58476 .28488 Mdot
.58482 .2897 Mdot
.58488 .29453 Mdot
.58494 .30177 Mdot
.585 .3066 Mdot
.58506 .30902 Mdot
.58512 .30902 Mdot
.58518 .3066 Mdot
.58524 .30419 Mdot
.5853 .3066 Mdot
.58536 .31143 Mdot
.58542 .31385 Mdot
.58548 .31626 Mdot
.58554 .31626 Mdot
.5856 .31626 Mdot
.58566 .31867 Mdot
.58572 .3235 Mdot
.58578 .32592 Mdot
.58584 .32592 Mdot
.5859 .3235 Mdot
.58596 .31867 Mdot
.58602 .31626 Mdot
.58608 .31143 Mdot
.58614 .31143 Mdot
.5862 .31385 Mdot
.58626 .31867 Mdot
.58632 .32109 Mdot
.58638 .32109 Mdot
.58644 .32109 Mdot
.5865 .32109 Mdot
.58656 .32592 Mdot
.58662 .33074 Mdot
.58668 .33074 Mdot
.58674 .32833 Mdot
.5868 .3235 Mdot
.58686 .31867 Mdot
.58692 .31626 Mdot
.58698 .31867 Mdot
.58704 .31867 Mdot
.5871 .31867 Mdot
.58716 .31867 Mdot
.58722 .31867 Mdot
.58728 .31626 Mdot
.58734 .31385 Mdot
.5874 .30902 Mdot
.58746 .3066 Mdot
.58752 .30419 Mdot
.58758 .29695 Mdot
.58764 .28729 Mdot
.5877 .27763 Mdot
.58776 .27039 Mdot
.58782 .26798 Mdot
.58788 .27039 Mdot
.58794 .2728 Mdot
.588 .27522 Mdot
.58806 .27522 Mdot
.58812 .27763 Mdot
.58818 .28246 Mdot
.58824 .2897 Mdot
.5883 .29695 Mdot
.58836 .30177 Mdot
.58842 .30419 Mdot
.58848 .30419 Mdot
.58854 .30419 Mdot
.5886 .3066 Mdot
.58866 .30902 Mdot
.58872 .31385 Mdot
.58878 .32109 Mdot
.58884 .3235 Mdot
.5889 .3235 Mdot
.58896 .3235 Mdot
.58902 .3235 Mdot
.58908 .3235 Mdot
.58914 .32592 Mdot
.5892 .32592 Mdot
.58926 .32109 Mdot
.58932 .31385 Mdot
.58938 .30902 Mdot
.58944 .3066 Mdot
.5895 .3066 Mdot
.58956 .30902 Mdot
.58962 .31143 Mdot
.58968 .31385 Mdot
.58974 .31867 Mdot
.5898 .32109 Mdot
.58986 .3235 Mdot
.58992 .32833 Mdot
.58998 .33074 Mdot
.59004 .33557 Mdot
.5901 .33557 Mdot
.59016 .33074 Mdot
.59022 .32592 Mdot
.59028 .32109 Mdot
.59034 .31867 Mdot
.5904 .32109 Mdot
.59046 .32109 Mdot
.59052 .31867 Mdot
.59058 .31385 Mdot
.59064 .31143 Mdot
.5907 .3066 Mdot
.59076 .30419 Mdot
.59082 .30177 Mdot
.59088 .29936 Mdot
.59094 .29212 Mdot
.591 .28729 Mdot
.59106 .28005 Mdot
.59112 .27522 Mdot
.59118 .2728 Mdot
.59124 .2728 Mdot
.5913 .27763 Mdot
.59136 .28246 Mdot
.59142 .28488 Mdot
.59148 .28488 Mdot
.59154 .28729 Mdot
.5916 .2897 Mdot
.59166 .29695 Mdot
.59172 .30177 Mdot
.59178 .30419 Mdot
.59184 .30177 Mdot
.5919 .29936 Mdot
.59196 .29936 Mdot
.59202 .30419 Mdot
.59208 .30902 Mdot
.59214 .31143 Mdot
.5922 .31626 Mdot
.59226 .32109 Mdot
.59232 .3235 Mdot
.59238 .3235 Mdot
.59244 .32592 Mdot
.5925 .32833 Mdot
.59256 .32833 Mdot
.59262 .32833 Mdot
.59268 .3235 Mdot
.59274 .31626 Mdot
.5928 .31143 Mdot
.59286 .30902 Mdot
.59292 .31143 Mdot
.59298 .31385 Mdot
.59304 .31626 Mdot
.5931 .31385 Mdot
.59316 .31626 Mdot
.59322 .31626 Mdot
.59328 .32109 Mdot
.59334 .3235 Mdot
.5934 .32833 Mdot
.59346 .32833 Mdot
.59352 .32592 Mdot
.59358 .3235 Mdot
.59364 .32109 Mdot
.5937 .32109 Mdot
.59376 .32109 Mdot
.59382 .32109 Mdot
.59388 .3235 Mdot
.59394 .32109 Mdot
.594 .31626 Mdot
.59406 .31143 Mdot
.59412 .3066 Mdot
.59418 .30419 Mdot
.59424 .30177 Mdot
.5943 .29695 Mdot
.59436 .28729 Mdot
.59442 .27763 Mdot
.59448 .2728 Mdot
.59454 .27039 Mdot
.5946 .27039 Mdot
.59466 .2728 Mdot
.59472 .27763 Mdot
.59478 .28005 Mdot
.59484 .28488 Mdot
.5949 .28729 Mdot
.59496 .29212 Mdot
.59502 .29695 Mdot
.59508 .30419 Mdot
.59514 .3066 Mdot
.5952 .30902 Mdot
.59526 .3066 Mdot
.59532 .30419 Mdot
.59538 .3066 Mdot
.59544 .31143 Mdot
.5955 .31626 Mdot
.59556 .31867 Mdot
.59562 .31867 Mdot
.59568 .31867 Mdot
.59574 .32109 Mdot
.5958 .32109 Mdot
.59586 .32109 Mdot
.59592 .3235 Mdot
.59598 .3235 Mdot
.59604 .32109 Mdot
.5961 .31626 Mdot
.59616 .31143 Mdot
.59622 .31143 Mdot
.59628 .31143 Mdot
.59634 .31385 Mdot
.5964 .31867 Mdot
.59646 .32109 Mdot
.59652 .32109 Mdot
.59658 .31867 Mdot
.59664 .32109 Mdot
.5967 .3235 Mdot
.59676 .32592 Mdot
.59682 .32833 Mdot
.59688 .3235 Mdot
.59694 .32109 Mdot
.597 .31626 Mdot
.59706 .31626 Mdot
.59712 .31626 Mdot
.59718 .31867 Mdot
.59724 .31867 Mdot
.5973 .31867 Mdot
.59736 .31626 Mdot
.59742 .31385 Mdot
.59748 .30902 Mdot
.59754 .3066 Mdot
.5976 .30419 Mdot
.59766 .30177 Mdot
.59772 .29453 Mdot
.59778 .28729 Mdot
.59784 .27763 Mdot
.5979 .27522 Mdot
.59796 .27522 Mdot
.59802 .27522 Mdot
.59808 .27763 Mdot
.59814 .28005 Mdot
.5982 .28005 Mdot
.59826 .28246 Mdot
.59832 .28729 Mdot
.59838 .29212 Mdot
.59844 .29936 Mdot
.5985 .30419 Mdot
.59856 .30419 Mdot
.59862 .3066 Mdot
.59868 .3066 Mdot
.59874 .30902 Mdot
.5988 .31143 Mdot
.59886 .31626 Mdot
.59892 .32109 Mdot
.59898 .3235 Mdot
.59904 .3235 Mdot
.5991 .3235 Mdot
.59916 .3235 Mdot
.59922 .3235 Mdot
.59928 .32592 Mdot
.59934 .3235 Mdot
.5994 .31867 Mdot
.59946 .31143 Mdot
.59952 .30902 Mdot
.59958 .30902 Mdot
.59964 .30902 Mdot
.5997 .31143 Mdot
.59976 .31385 Mdot
.59982 .31626 Mdot
.59988 .31867 Mdot
.59994 .32109 Mdot
.6 .32109 Mdot
.60006 .3235 Mdot
.60012 .32833 Mdot
.60018 .33074 Mdot
.60024 .32833 Mdot
.6003 .32592 Mdot
.60036 .32109 Mdot
.60042 .31626 Mdot
.60048 .31867 Mdot
.60054 .31867 Mdot
.6006 .31867 Mdot
.60066 .31626 Mdot
.60072 .31385 Mdot
.60078 .30902 Mdot
.60084 .3066 Mdot
.6009 .30419 Mdot
.60096 .30177 Mdot
.60102 .29936 Mdot
.60108 .29453 Mdot
.60114 .28729 Mdot
.6012 .28246 Mdot
.60126 .27763 Mdot
.60132 .27522 Mdot
.60138 .27763 Mdot
.60144 .28246 Mdot
.6015 .28488 Mdot
.60156 .28488 Mdot
.60162 .28729 Mdot
.60168 .28729 Mdot
.60174 .29212 Mdot
.6018 .29936 Mdot
.60186 .30177 Mdot
.60192 .30419 Mdot
.60198 .30177 Mdot
.60204 .30177 Mdot
.6021 .30419 Mdot
.60216 .30902 Mdot
.60222 .31143 Mdot
.60228 .31626 Mdot
.60234 .32109 Mdot
.6024 .3235 Mdot
.60246 .3235 Mdot
.60252 .3235 Mdot
.60258 .3235 Mdot
.60264 .32592 Mdot
.6027 .32592 Mdot
.60276 .32592 Mdot
.60282 .31867 Mdot
.60288 .31385 Mdot
.60294 .30902 Mdot
.603 .30902 Mdot
.60306 .31143 Mdot
.60312 .31143 Mdot
.60318 .31385 Mdot
.60324 .31385 Mdot
.6033 .31626 Mdot
.60336 .31626 Mdot
.60342 .31867 Mdot
.60348 .3235 Mdot
.60354 .32592 Mdot
.6036 .32592 Mdot
.60366 .3235 Mdot
.60372 .32109 Mdot
.60378 .31867 Mdot
.60384 .31867 Mdot
.6039 .31867 Mdot
.60396 .32109 Mdot
.60402 .32109 Mdot
.60408 .31867 Mdot
.60414 .31385 Mdot
.6042 .30902 Mdot
.60426 .3066 Mdot
.60432 .30419 Mdot
.60438 .30177 Mdot
.60444 .29453 Mdot
.6045 .28729 Mdot
.60456 .28005 Mdot
.60462 .27522 Mdot
.60468 .27522 Mdot
.60474 .27522 Mdot
.6048 .27763 Mdot
.60486 .28005 Mdot
.60492 .28488 Mdot
.60498 .28729 Mdot
.60504 .2897 Mdot
.6051 .29453 Mdot
.60516 .29936 Mdot
.60522 .30419 Mdot
.60528 .3066 Mdot
.60534 .3066 Mdot
.6054 .3066 Mdot
.60546 .30419 Mdot
.60552 .3066 Mdot
.60558 .30902 Mdot
.60564 .31385 Mdot
.6057 .31626 Mdot
.60576 .31867 Mdot
.60582 .32109 Mdot
.60588 .32109 Mdot
.60594 .3235 Mdot
.606 .3235 Mdot
.60606 .3235 Mdot
.60612 .3235 Mdot
.60618 .32109 Mdot
.60624 .31626 Mdot
.6063 .31385 Mdot
.60636 .31143 Mdot
.60642 .31143 Mdot
.60648 .31626 Mdot
.60654 .31867 Mdot
.6066 .32109 Mdot
.60666 .31867 Mdot
.60672 .31867 Mdot
.60678 .32109 Mdot
.60684 .3235 Mdot
.6069 .32592 Mdot
.60696 .3235 Mdot
.60702 .32109 Mdot
.60708 .31867 Mdot
.60714 .31626 Mdot
.6072 .31626 Mdot
.60726 .31626 Mdot
.60732 .31626 Mdot
.60738 .31626 Mdot
.60744 .31867 Mdot
.6075 .31626 Mdot
.60756 .31385 Mdot
.60762 .30902 Mdot
.60768 .3066 Mdot
.60774 .30419 Mdot
.6078 .30177 Mdot
.60786 .29453 Mdot
.60792 .28729 Mdot
.60798 .28005 Mdot
.60804 .27522 Mdot
.6081 .27522 Mdot
.60816 .27522 Mdot
.60822 .27763 Mdot
.60828 .28005 Mdot
.60834 .28246 Mdot
.6084 .28488 Mdot
.60846 .28729 Mdot
.60852 .29212 Mdot
.60858 .29695 Mdot
.60864 .30177 Mdot
.6087 .3066 Mdot
.60876 .3066 Mdot
.60882 .3066 Mdot
.60888 .30902 Mdot
.60894 .31143 Mdot
.609 .31626 Mdot
.60906 .32109 Mdot
.60912 .3235 Mdot
.60918 .3235 Mdot
.60924 .32109 Mdot
.6093 .32109 Mdot
.60936 .3235 Mdot
.60942 .3235 Mdot
.60948 .3235 Mdot
.60954 .31867 Mdot
.6096 .31385 Mdot
.60966 .31143 Mdot
.60972 .30902 Mdot
.60978 .30902 Mdot
.60984 .31143 Mdot
.6099 .31385 Mdot
.60996 .31626 Mdot
.61002 .32109 Mdot
.61008 .3235 Mdot
.61014 .3235 Mdot
.6102 .32592 Mdot
.61026 .32833 Mdot
.61032 .33074 Mdot
.61038 .32833 Mdot
.61044 .3235 Mdot
.6105 .31867 Mdot
.61056 .31867 Mdot
.61062 .31867 Mdot
.61068 .31626 Mdot
.61074 .31626 Mdot
.6108 .31385 Mdot
.61086 .31143 Mdot
.61092 .30902 Mdot
.61098 .3066 Mdot
.61104 .30419 Mdot
.6111 .30177 Mdot
.61116 .29936 Mdot
.61122 .29453 Mdot
.61128 .2897 Mdot
.61134 .28488 Mdot
.6114 .28005 Mdot
.61146 .27763 Mdot
.61152 .27763 Mdot
.61158 .28005 Mdot
.61164 .28246 Mdot
.6117 .28488 Mdot
.61176 .28488 Mdot
.61182 .28729 Mdot
.61188 .29212 Mdot
.61194 .29695 Mdot
.612 .30177 Mdot
.61206 .30177 Mdot
.61212 .30177 Mdot
.61218 .30177 Mdot
.61224 .30419 Mdot
.6123 .3066 Mdot
.61236 .31143 Mdot
.61242 .31385 Mdot
.61248 .31867 Mdot
.61254 .3235 Mdot
.6126 .3235 Mdot
.61266 .3235 Mdot
.61272 .3235 Mdot
.61278 .32592 Mdot
.61284 .32833 Mdot
.6129 .32592 Mdot
.61296 .32109 Mdot
.61302 .31626 Mdot
.61308 .31143 Mdot
.61314 .31143 Mdot
.6132 .31143 Mdot
.61326 .31385 Mdot
.61332 .31385 Mdot
.61338 .31385 Mdot
.61344 .31626 Mdot
.6135 .31626 Mdot
.61356 .31867 Mdot
.61362 .32109 Mdot
.61368 .32592 Mdot
.61374 .32592 Mdot
.6138 .32592 Mdot
.61386 .32592 Mdot
.61392 .32109 Mdot
.61398 .32109 Mdot
.61404 .32109 Mdot
.6141 .32109 Mdot
.61416 .32109 Mdot
.61422 .31867 Mdot
.61428 .31385 Mdot
.61434 .30902 Mdot
.6144 .3066 Mdot
.61446 .30419 Mdot
.61452 .30177 Mdot
.61458 .29453 Mdot
.61464 .28729 Mdot
.6147 .28005 Mdot
.61476 .27522 Mdot
.61482 .2728 Mdot
.61488 .2728 Mdot
.61494 .2728 Mdot
.615 .27763 Mdot
.61506 .28246 Mdot
.61512 .28488 Mdot
.61518 .28729 Mdot
.61524 .29212 Mdot
.6153 .29695 Mdot
.61536 .30419 Mdot
.61542 .30902 Mdot
.61548 .30902 Mdot
.61554 .3066 Mdot
.6156 .3066 Mdot
.61566 .30902 Mdot
.61572 .31143 Mdot
.61578 .31385 Mdot
.61584 .31626 Mdot
.6159 .31626 Mdot
.61596 .31867 Mdot
.61602 .31867 Mdot
.61608 .31867 Mdot
.61614 .32109 Mdot
.6162 .3235 Mdot
.61626 .3235 Mdot
.61632 .32109 Mdot
.61638 .31867 Mdot
.61644 .31626 Mdot
.6165 .31385 Mdot
.61656 .31385 Mdot
.61662 .31626 Mdot
.61668 .31867 Mdot
.61674 .32109 Mdot
.6168 .32109 Mdot
.61686 .31867 Mdot
.61692 .32109 Mdot
.61698 .3235 Mdot
.61704 .32592 Mdot
.6171 .32592 Mdot
.61716 .3235 Mdot
.61722 .32109 Mdot
.61728 .31867 Mdot
.61734 .31626 Mdot
.6174 .31626 Mdot
.61746 .31626 Mdot
.61752 .31867 Mdot
.61758 .31867 Mdot
.61764 .31626 Mdot
.6177 .31385 Mdot
.61776 .30902 Mdot
.61782 .30902 Mdot
.61788 .3066 Mdot
.61794 .30177 Mdot
.618 .29453 Mdot
.61806 .28729 Mdot
.61812 .28005 Mdot
.61818 .27522 Mdot
.61824 .2728 Mdot
.6183 .2728 Mdot
.61836 .27522 Mdot
.61842 .27522 Mdot
.61848 .27763 Mdot
.61854 .28005 Mdot
.6186 .28729 Mdot
.61866 .29212 Mdot
.61872 .29936 Mdot
.61878 .30419 Mdot
.61884 .3066 Mdot
.6189 .30902 Mdot
.61896 .30902 Mdot
.61902 .31143 Mdot
.61908 .31143 Mdot
.61914 .31626 Mdot
.6192 .32109 Mdot
.61926 .3235 Mdot
.61932 .3235 Mdot
.61938 .3235 Mdot
.61944 .32109 Mdot
.6195 .3235 Mdot
.61956 .3235 Mdot
.61962 .3235 Mdot
.61968 .31867 Mdot
.61974 .31626 Mdot
.6198 .31143 Mdot
.61986 .30902 Mdot
.61992 .30902 Mdot
.61998 .31143 Mdot
.62004 .31385 Mdot
.6201 .31867 Mdot
.62016 .31867 Mdot
.62022 .32109 Mdot
.62028 .3235 Mdot
.62034 .32592 Mdot
.6204 .33074 Mdot
.62046 .33316 Mdot
.62052 .33074 Mdot
.62058 .32592 Mdot
.62064 .3235 Mdot
.6207 .31867 Mdot
.62076 .31867 Mdot
.62082 .31867 Mdot
.62088 .31626 Mdot
.62094 .31626 Mdot
.621 .31143 Mdot
.62106 .30902 Mdot
.62112 .30419 Mdot
.62118 .30419 Mdot
.62124 .30177 Mdot
.6213 .29936 Mdot
.62136 .29453 Mdot
.62142 .28729 Mdot
.62148 .28005 Mdot
.62154 .27522 Mdot
.6216 .27522 Mdot
.62166 .27522 Mdot
.62172 .27763 Mdot
.62178 .28005 Mdot
.62184 .28246 Mdot
.6219 .28488 Mdot
.62196 .28729 Mdot
.62202 .29212 Mdot
.62208 .29936 Mdot
.62214 .30419 Mdot
.6222 .30419 Mdot
.62226 .30419 Mdot
.62232 .30419 Mdot
.62238 .30419 Mdot
.62244 .30902 Mdot
.6225 .31143 Mdot
.62256 .31626 Mdot
.62262 .32109 Mdot
.62268 .3235 Mdot
.62274 .3235 Mdot
.6228 .3235 Mdot
.62286 .32592 Mdot
.62292 .32833 Mdot
.62298 .32833 Mdot
.62304 .32833 Mdot
.6231 .32109 Mdot
.62316 .31626 Mdot
.62322 .31143 Mdot
.62328 .31143 Mdot
.62334 .31143 Mdot
.6234 .31385 Mdot
.62346 .31385 Mdot
.62352 .31626 Mdot
.62358 .31626 Mdot
.62364 .31867 Mdot
.6237 .32109 Mdot
.62376 .32592 Mdot
.62382 .32833 Mdot
.62388 .32833 Mdot
.62394 .32592 Mdot
.624 .3235 Mdot
.62406 .32109 Mdot
.62412 .32109 Mdot
.62418 .32109 Mdot
.62424 .32109 Mdot
.6243 .32109 Mdot
.62436 .31867 Mdot
.62442 .31385 Mdot
.62448 .30902 Mdot
.62454 .3066 Mdot
.6246 .30419 Mdot
.62466 .29936 Mdot
.62472 .29453 Mdot
.62478 .28488 Mdot
.62484 .27763 Mdot
.6249 .27039 Mdot
.62496 .26798 Mdot
.62502 .26798 Mdot
.62508 .27039 Mdot
.62514 .27522 Mdot
.6252 .28005 Mdot
.62526 .28246 Mdot
.62532 .28488 Mdot
.62538 .29212 Mdot
.62544 .29936 Mdot
.6255 .3066 Mdot
.62556 .31143 Mdot
.62562 .31143 Mdot
.62568 .30902 Mdot
.62574 .30902 Mdot
.6258 .30902 Mdot
.62586 .31143 Mdot
.62592 .31626 Mdot
.62598 .31867 Mdot
.62604 .32109 Mdot
.6261 .32109 Mdot
.62616 .31867 Mdot
.62622 .32109 Mdot
.62628 .3235 Mdot
.62634 .32592 Mdot
.6264 .32592 Mdot
.62646 .32109 Mdot
.62652 .31626 Mdot
.62658 .31385 Mdot
.62664 .31143 Mdot
.6267 .31385 Mdot
.62676 .31626 Mdot
.62682 .31867 Mdot
.62688 .32109 Mdot
.62694 .32109 Mdot
.627 .32109 Mdot
.62706 .3235 Mdot
.62712 .32592 Mdot
.62718 .32833 Mdot
.62724 .32833 Mdot
.6273 .32592 Mdot
.62736 .32109 Mdot
.62742 .31626 Mdot
.62748 .31626 Mdot
.62754 .31626 Mdot
.6276 .31626 Mdot
.62766 .31867 Mdot
.62772 .31626 Mdot
.62778 .31385 Mdot
.62784 .31143 Mdot
.6279 .30902 Mdot
.62796 .3066 Mdot
.62802 .30419 Mdot
.62808 .29936 Mdot
.62814 .29212 Mdot
.6282 .28246 Mdot
.62826 .27522 Mdot
.62832 .27039 Mdot
.62838 .26798 Mdot
.62844 .27039 Mdot
.6285 .2728 Mdot
.62856 .27522 Mdot
.62862 .27763 Mdot
.62868 .28005 Mdot
.62874 .28729 Mdot
.6288 .29453 Mdot
.62886 .30177 Mdot
.62892 .3066 Mdot
.62898 .3066 Mdot
.62904 .3066 Mdot
.6291 .3066 Mdot
.62916 .31143 Mdot
.62922 .31385 Mdot
.62928 .31867 Mdot
.62934 .32109 Mdot
.6294 .3235 Mdot
.62946 .3235 Mdot
.62952 .3235 Mdot
.62958 .3235 Mdot
.62964 .3235 Mdot
.6297 .32592 Mdot
.62976 .3235 Mdot
.62982 .32109 Mdot
.62988 .31385 Mdot
.62994 .30902 Mdot
.63 .30902 Mdot
.63006 .30902 Mdot
.63012 .31143 Mdot
.63018 .31626 Mdot
.63024 .31867 Mdot
.6303 .32109 Mdot
.63036 .3235 Mdot
.63042 .3235 Mdot
.63048 .32833 Mdot
.63054 .33316 Mdot
.6306 .33316 Mdot
.63066 .33074 Mdot
.63072 .32592 Mdot
.63078 .32109 Mdot
.63084 .31867 Mdot
.6309 .31626 Mdot
.63096 .31867 Mdot
.63102 .31867 Mdot
.63108 .31626 Mdot
.63114 .31143 Mdot
.6312 .30902 Mdot
.63126 .30419 Mdot
.63132 .30419 Mdot
.63138 .30177 Mdot
.63144 .29695 Mdot
.6315 .29212 Mdot
.63156 .28246 Mdot
.63162 .27522 Mdot
.63168 .2728 Mdot
.63174 .2728 Mdot
.6318 .2728 Mdot
.63186 .27522 Mdot
.63192 .27763 Mdot
.63198 .28246 Mdot
.63204 .28488 Mdot
.6321 .28729 Mdot
.63216 .29212 Mdot
.63222 .29936 Mdot
.63228 .30419 Mdot
.63234 .3066 Mdot
.6324 .30419 Mdot
.63246 .30419 Mdot
.63252 .30419 Mdot
.63258 .30902 Mdot
.63264 .31385 Mdot
.6327 .31867 Mdot
.63276 .32109 Mdot
.63282 .3235 Mdot
.63288 .32592 Mdot
.63294 .32592 Mdot
.63299 .32833 Mdot
.63305 .32833 Mdot
.63311 .32833 Mdot
.63317 .32592 Mdot
.63323 .32109 Mdot
.63329 .31385 Mdot
.63335 .31143 Mdot
.63341 .30902 Mdot
.63347 .31143 Mdot
.63353 .31626 Mdot
.63359 .31867 Mdot
.63365 .31867 Mdot
.63371 .32109 Mdot
.63377 .32109 Mdot
.63383 .32592 Mdot
.63389 .32833 Mdot
.63395 .33074 Mdot
.63401 .33074 Mdot
.63407 .32592 Mdot
.63413 .32109 Mdot
.63419 .31867 Mdot
.63425 .31867 Mdot
.63431 .31867 Mdot
.63437 .32109 Mdot
.63443 .32109 Mdot
.63449 .31626 Mdot
.63455 .31385 Mdot
.63461 .30902 Mdot
.63467 .30419 Mdot
.63473 .30177 Mdot
.63479 .29936 Mdot
.63485 .2897 Mdot
.63491 .28246 Mdot
.63497 .2728 Mdot
.63503 .26798 Mdot
.63509 .26798 Mdot
.63515 .26798 Mdot
.63521 .27039 Mdot
.63527 .27522 Mdot
.63533 .28005 Mdot
.63539 .28488 Mdot
.63545 .2897 Mdot
.63551 .29453 Mdot
.63557 .30177 Mdot
.63563 .3066 Mdot
.63569 .30902 Mdot
.63575 .30902 Mdot
.63581 .3066 Mdot
.63587 .3066 Mdot
.63593 .3066 Mdot
.63599 .30902 Mdot
.63605 .31385 Mdot
.63611 .31867 Mdot
.63617 .32109 Mdot
.63623 .32109 Mdot
.63629 .32109 Mdot
.63635 .32109 Mdot
.63641 .32592 Mdot
.63647 .32592 Mdot
.63653 .32592 Mdot
.63659 .32109 Mdot
.63665 .31626 Mdot
.63671 .31385 Mdot
.63677 .31385 Mdot
.63683 .31626 Mdot
.63689 .32109 Mdot
.63695 .3235 Mdot
.63701 .32592 Mdot
.63707 .3235 Mdot
.63713 .3235 Mdot
.63719 .32592 Mdot
.63725 .32833 Mdot
.63731 .33074 Mdot
.63737 .32833 Mdot
.63743 .3235 Mdot
.63749 .31867 Mdot
.63755 .31626 Mdot
.63761 .31385 Mdot
.63767 .31626 Mdot
.63773 .31626 Mdot
.63779 .31867 Mdot
.63785 .31867 Mdot
.63791 .31626 Mdot
.63797 .31143 Mdot
.63803 .30902 Mdot
.63809 .3066 Mdot
.63815 .30177 Mdot
.63821 .29695 Mdot
.63827 .2897 Mdot
.63833 .27763 Mdot
.63839 .27039 Mdot
.63845 .26556 Mdot
.63851 .26798 Mdot
.63857 .27039 Mdot
.63863 .2728 Mdot
.63869 .27522 Mdot
.63875 .27763 Mdot
.63881 .28246 Mdot
.63887 .28729 Mdot
.63893 .29695 Mdot
.63899 .30419 Mdot
.63905 .3066 Mdot
.63911 .30902 Mdot
.63917 .30902 Mdot
.63923 .3066 Mdot
.63929 .30902 Mdot
.63935 .31143 Mdot
.63941 .31626 Mdot
.63947 .32109 Mdot
.63953 .3235 Mdot
.63959 .3235 Mdot
.63965 .32109 Mdot
.63971 .32109 Mdot
.63977 .3235 Mdot
.63983 .32592 Mdot
.63989 .3235 Mdot
.63995 .31867 Mdot
.64001 .31143 Mdot
.64007 .30902 Mdot
.64013 .30902 Mdot
.64019 .31143 Mdot
.64025 .31385 Mdot
.64031 .31867 Mdot
.64037 .32109 Mdot
.64043 .3235 Mdot
.64049 .32592 Mdot
.64055 .32833 Mdot
.64061 .33074 Mdot
.64067 .33557 Mdot
.64073 .33557 Mdot
.64079 .33074 Mdot
.64085 .32592 Mdot
.64091 .32109 Mdot
.64097 .31626 Mdot
.64103 .31626 Mdot
.64109 .31626 Mdot
.64115 .31626 Mdot
.64121 .31385 Mdot
.64127 .31143 Mdot
.64133 .30902 Mdot
.64139 .3066 Mdot
.64145 .30419 Mdot
.64151 .30419 Mdot
.64157 .29936 Mdot
.64163 .29453 Mdot
.64169 .28488 Mdot
.64175 .27763 Mdot
.64181 .2728 Mdot
.64187 .2728 Mdot
.64193 .2728 Mdot
.64199 .27763 Mdot
.64205 .28005 Mdot
.64211 .28246 Mdot
.64217 .28246 Mdot
.64223 .28729 Mdot
.64229 .29453 Mdot
.64235 .30177 Mdot
.64241 .3066 Mdot
.64247 .3066 Mdot
.64253 .3066 Mdot
.64259 .3066 Mdot
.64265 .3066 Mdot
.64271 .30902 Mdot
.64277 .31385 Mdot
.64283 .31867 Mdot
.64289 .32109 Mdot
.64295 .3235 Mdot
.64301 .32109 Mdot
.64307 .32109 Mdot
.64313 .3235 Mdot
.64319 .32592 Mdot
.64325 .32833 Mdot
.64331 .3235 Mdot
.64337 .31626 Mdot
.64343 .30902 Mdot
.64349 .3066 Mdot
.64355 .30902 Mdot
.64361 .30902 Mdot
.64367 .31143 Mdot
.64373 .31385 Mdot
.64379 .31626 Mdot
.64385 .31867 Mdot
.64391 .32109 Mdot
.64397 .3235 Mdot
.64403 .32833 Mdot
.64409 .33316 Mdot
.64415 .33316 Mdot
.64421 .32833 Mdot
.64427 .3235 Mdot
.64433 .32109 Mdot
.64439 .32109 Mdot
.64445 .32109 Mdot
.64451 .32109 Mdot
.64457 .32109 Mdot
.64463 .31626 Mdot
.64469 .31143 Mdot
.64475 .3066 Mdot
.64481 .30419 Mdot
.64487 .30177 Mdot
.64493 .29936 Mdot
.64499 .29212 Mdot
.64505 .28246 Mdot
.64511 .27522 Mdot
.64517 .27039 Mdot
.64523 .27039 Mdot
.64529 .2728 Mdot
.64535 .27522 Mdot
.64541 .28005 Mdot
.64547 .28246 Mdot
.64553 .28729 Mdot
.64559 .2897 Mdot
.64565 .29695 Mdot
.64571 .3066 Mdot
.64577 .31143 Mdot
.64583 .31385 Mdot
.64589 .31143 Mdot
.64595 .30902 Mdot
.64601 .3066 Mdot
.64607 .30902 Mdot
.64613 .31143 Mdot
.64619 .31385 Mdot
.64625 .31626 Mdot
.64631 .31626 Mdot
.64637 .31626 Mdot
.64643 .31626 Mdot
.64649 .31867 Mdot
.64655 .3235 Mdot
.64661 .32592 Mdot
.64667 .3235 Mdot
.64673 .31867 Mdot
.64679 .31143 Mdot
.64685 .30902 Mdot
.64691 .31143 Mdot
.64697 .31385 Mdot
.64703 .31626 Mdot
.64709 .32109 Mdot
.64715 .32109 Mdot
.64721 .31867 Mdot
.64727 .31867 Mdot
.64733 .3235 Mdot
.64739 .32833 Mdot
.64745 .33074 Mdot
.64751 .33074 Mdot
.64757 .32592 Mdot
.64763 .32109 Mdot
.64769 .31867 Mdot
.64775 .31867 Mdot
.64781 .31867 Mdot
.64787 .31867 Mdot
.64793 .31867 Mdot
.64799 .31626 Mdot
.64805 .31385 Mdot
.64811 .30902 Mdot
.64817 .3066 Mdot
.64823 .3066 Mdot
.64829 .3066 Mdot
.64835 .29936 Mdot
.64841 .2897 Mdot
.64847 .27763 Mdot
.64853 .27039 Mdot
.64859 .27039 Mdot
.64865 .27039 Mdot
.64871 .2728 Mdot
.64877 .27522 Mdot
.64883 .27763 Mdot
.64889 .28005 Mdot
.64895 .28488 Mdot
.64901 .2897 Mdot
.64907 .29936 Mdot
.64913 .3066 Mdot
.64919 .31143 Mdot
.64925 .31143 Mdot
.64931 .31143 Mdot
.64937 .31143 Mdot
.64943 .31385 Mdot
.64949 .31626 Mdot
.64955 .32109 Mdot
.64961 .3235 Mdot
.64967 .32109 Mdot
.64973 .31867 Mdot
.64979 .31867 Mdot
.64985 .31867 Mdot
.64991 .32109 Mdot
.64997 .3235 Mdot
.65003 .31867 Mdot
.65009 .31385 Mdot
.65015 .3066 Mdot
.65021 .30419 Mdot
.65027 .30419 Mdot
.65033 .30902 Mdot
.65039 .31143 Mdot
.65045 .31626 Mdot
.65051 .31867 Mdot
.65057 .32109 Mdot
.65063 .32109 Mdot
.65069 .32592 Mdot
.65075 .33316 Mdot
.65081 .33799 Mdot
.65087 .33799 Mdot
.65093 .33316 Mdot
.65099 .32592 Mdot
.65105 .32109 Mdot
.65111 .31867 Mdot
.65117 .31867 Mdot
.65123 .32109 Mdot
.65129 .31867 Mdot
.65135 .31385 Mdot
.65141 .30902 Mdot
.65147 .30419 Mdot
.65153 .30177 Mdot
.65159 .30177 Mdot
.65165 .30177 Mdot
.65171 .29695 Mdot
.65177 .2897 Mdot
.65183 .28005 Mdot
.65189 .2728 Mdot
.65195 .27039 Mdot
.65201 .2728 Mdot
.65207 .27763 Mdot
.65213 .28005 Mdot
.65219 .28246 Mdot
.65225 .28246 Mdot
.65231 .28488 Mdot
.65237 .2897 Mdot
.65243 .29936 Mdot
.65249 .3066 Mdot
.65255 .30902 Mdot
.65261 .30902 Mdot
.65267 .3066 Mdot
.65273 .30419 Mdot
.65279 .3066 Mdot
.65285 .31143 Mdot
.65291 .31626 Mdot
.65297 .31867 Mdot
.65303 .32109 Mdot
.65309 .32109 Mdot
.65315 .32109 Mdot
.65321 .32109 Mdot
.65327 .3235 Mdot
.65333 .32592 Mdot
.65339 .32592 Mdot
.65345 .32109 Mdot
.65351 .31143 Mdot
.65357 .3066 Mdot
.65363 .30419 Mdot
.65369 .3066 Mdot
.65375 .31143 Mdot
.65381 .31385 Mdot
.65387 .31626 Mdot
.65393 .31626 Mdot
.65399 .31626 Mdot
.65405 .32109 Mdot
.65411 .32592 Mdot
.65417 .33316 Mdot
.65423 .33557 Mdot
.65429 .33316 Mdot
.65435 .32833 Mdot
.65441 .3235 Mdot
.65447 .32109 Mdot
.65453 .3235 Mdot
.65459 .3235 Mdot
.65465 .3235 Mdot
.65471 .32109 Mdot
.65477 .31626 Mdot
.65483 .30902 Mdot
.65489 .3066 Mdot
.65495 .30419 Mdot
.65501 .30419 Mdot
.65507 .29936 Mdot
.65513 .2897 Mdot
.65519 .27763 Mdot
.65525 .26798 Mdot
.65531 .26556 Mdot
.65537 .26556 Mdot
.65543 .27039 Mdot
.65549 .2728 Mdot
.65555 .27763 Mdot
.65561 .28246 Mdot
.65567 .28488 Mdot
.65573 .29212 Mdot
.65579 .29936 Mdot
.65585 .30902 Mdot
.65591 .31385 Mdot
.65597 .31385 Mdot
.65603 .31143 Mdot
.65609 .3066 Mdot
.65615 .3066 Mdot
.65621 .31143 Mdot
.65627 .31626 Mdot
.65633 .31867 Mdot
.65639 .31867 Mdot
.65645 .31626 Mdot
.65651 .31626 Mdot
.65657 .31626 Mdot
.65663 .31867 Mdot
.65669 .32109 Mdot
.65675 .3235 Mdot
.65681 .32109 Mdot
.65687 .31385 Mdot
.65693 .30902 Mdot
.65699 .3066 Mdot
.65705 .30902 Mdot
.65711 .31626 Mdot
.65717 .31867 Mdot
.65723 .32109 Mdot
.65729 .31867 Mdot
.65735 .31867 Mdot
.65741 .32109 Mdot
.65747 .32833 Mdot
.65753 .33316 Mdot
.65759 .33316 Mdot
.65765 .33074 Mdot
.65771 .3235 Mdot
.65777 .31867 Mdot
.65783 .31867 Mdot
.65789 .31867 Mdot
.65795 .31867 Mdot
.65801 .32109 Mdot
.65807 .31867 Mdot
.65813 .31626 Mdot
.65819 .31385 Mdot
.65825 .31143 Mdot
.65831 .31143 Mdot
.65837 .30902 Mdot
.65843 .3066 Mdot
.65849 .29695 Mdot
.65855 .28488 Mdot
.65861 .2728 Mdot
.65867 .26798 Mdot
.65873 .26556 Mdot
.65879 .26798 Mdot
.65885 .27039 Mdot
.65891 .2728 Mdot
.65897 .27522 Mdot
.65903 .27763 Mdot
.65909 .28246 Mdot
.65915 .29212 Mdot
.65921 .30177 Mdot
.65927 .30902 Mdot
.65933 .31385 Mdot
.65939 .31143 Mdot
.65945 .30902 Mdot
.65951 .31143 Mdot
.65957 .31385 Mdot
.65963 .31867 Mdot
.65969 .3235 Mdot
.65975 .3235 Mdot
.65981 .32109 Mdot
.65987 .31867 Mdot
.65993 .31867 Mdot
.65999 .32109 Mdot
.66005 .3235 Mdot
.66011 .32109 Mdot
.66017 .31626 Mdot
.66023 .30902 Mdot
.66029 .30419 Mdot
.66035 .29936 Mdot
.66041 .30177 Mdot
.66047 .30902 Mdot
.66053 .31385 Mdot
.66059 .31867 Mdot
.66065 .32109 Mdot
.66071 .32109 Mdot
.66077 .32592 Mdot
.66083 .33074 Mdot
.66089 .33799 Mdot
.66095 .3404 Mdot
.66101 .33799 Mdot
.66107 .33074 Mdot
.66113 .3235 Mdot
.66119 .32109 Mdot
.66125 .31867 Mdot
.66131 .32109 Mdot
.66137 .31867 Mdot
.66143 .31626 Mdot
.66149 .31385 Mdot
.66155 .30902 Mdot
.66161 .3066 Mdot
.66167 .3066 Mdot
.66173 .30419 Mdot
.66179 .30177 Mdot
.66185 .29695 Mdot
.66191 .28488 Mdot
.66197 .27522 Mdot
.66203 .27039 Mdot
.66209 .26798 Mdot
.66215 .2728 Mdot
.66221 .27522 Mdot
.66227 .27763 Mdot
.66233 .27763 Mdot
.66239 .28005 Mdot
.66245 .28488 Mdot
.66251 .29212 Mdot
.66257 .30177 Mdot
.66263 .3066 Mdot
.66269 .3066 Mdot
.66275 .30419 Mdot
.66281 .30177 Mdot
.66287 .30177 Mdot
.66293 .3066 Mdot
.66299 .31143 Mdot
.66305 .31626 Mdot
.66311 .32109 Mdot
.66317 .32109 Mdot
.66323 .32109 Mdot
.66329 .32109 Mdot
.66335 .3235 Mdot
.66341 .32833 Mdot
.66347 .32833 Mdot
.66353 .32592 Mdot
.66359 .31867 Mdot
.66365 .31143 Mdot
.66371 .3066 Mdot
.66377 .3066 Mdot
.66383 .30902 Mdot
.66389 .31385 Mdot
.66395 .31626 Mdot
.66401 .31626 Mdot
.66407 .31867 Mdot
.66413 .32109 Mdot
.66419 .32592 Mdot
.66425 .33074 Mdot
.66431 .33557 Mdot
.66437 .33557 Mdot
.66443 .33074 Mdot
.66449 .32592 Mdot
.66455 .32109 Mdot
.66461 .32109 Mdot
.66467 .32109 Mdot
.66473 .3235 Mdot
.66479 .3235 Mdot
.66485 .31867 Mdot
.66491 .31385 Mdot
.66497 .31143 Mdot
.66503 .30902 Mdot
.66509 .30902 Mdot
.66515 .30419 Mdot
.66521 .29695 Mdot
.66527 .28488 Mdot
.66533 .2728 Mdot
.66539 .26798 Mdot
.66545 .26556 Mdot
.66551 .26556 Mdot
.66557 .27039 Mdot
.66563 .2728 Mdot
.66569 .27522 Mdot
.66575 .28005 Mdot
.66581 .28488 Mdot
.66587 .29212 Mdot
.66593 .30177 Mdot
.66599 .30902 Mdot
.66605 .31385 Mdot
.66611 .30902 Mdot
.66617 .3066 Mdot
.66623 .30419 Mdot
.66629 .3066 Mdot
.66635 .31143 Mdot
.66641 .31385 Mdot
.66647 .31626 Mdot
.66653 .31626 Mdot
.66659 .31626 Mdot
.66665 .31626 Mdot
.66671 .31867 Mdot
.66677 .3235 Mdot
.66683 .3235 Mdot
.66689 .3235 Mdot
.66695 .31867 Mdot
.66701 .31143 Mdot
.66707 .3066 Mdot
.66713 .3066 Mdot
.66719 .31143 Mdot
.66725 .31626 Mdot
.66731 .31867 Mdot
.66737 .32109 Mdot
.66743 .32109 Mdot
.66749 .32109 Mdot
.66755 .32592 Mdot
.66761 .33316 Mdot
.66767 .33557 Mdot
.66773 .33316 Mdot
.66779 .32833 Mdot
.66785 .32109 Mdot
.66791 .31626 Mdot
.66797 .31626 Mdot
.66803 .31867 Mdot
.66809 .32109 Mdot
.66815 .32109 Mdot
.66821 .31867 Mdot
.66827 .31626 Mdot
.66833 .31385 Mdot
.66839 .31385 Mdot
.66845 .31385 Mdot
.66851 .31385 Mdot
.66857 .3066 Mdot
.66863 .29453 Mdot
.66869 .28246 Mdot
.66875 .2728 Mdot
.66881 .27039 Mdot
.66887 .27039 Mdot
.66893 .27039 Mdot
.66899 .2728 Mdot
.66905 .2728 Mdot
.66911 .2728 Mdot
.66917 .27763 Mdot
.66923 .28729 Mdot
.66929 .29695 Mdot
.66935 .30419 Mdot
.66941 .30902 Mdot
.66947 .31143 Mdot
.66953 .30902 Mdot
.66959 .3066 Mdot
.66965 .30902 Mdot
.66971 .31385 Mdot
.66977 .31867 Mdot
.66983 .32109 Mdot
.66989 .32109 Mdot
.66995 .31867 Mdot
.67001 .31867 Mdot
.67007 .31867 Mdot
.67013 .3235 Mdot
.67019 .3235 Mdot
.67025 .32109 Mdot
.67031 .31385 Mdot
.67037 .3066 Mdot
.67043 .30177 Mdot
.67049 .29936 Mdot
.67055 .30419 Mdot
.67061 .30902 Mdot
.67067 .31385 Mdot
.67073 .31626 Mdot
.67079 .31626 Mdot
.67085 .32109 Mdot
.67091 .32592 Mdot
.67097 .33074 Mdot
.67103 .33799 Mdot
.67109 .33799 Mdot
.67115 .33316 Mdot
.67121 .32592 Mdot
.67127 .32109 Mdot
.67133 .31867 Mdot
.67139 .31867 Mdot
.67145 .32109 Mdot
.67151 .31867 Mdot
.67157 .31385 Mdot
.67163 .31143 Mdot
.67169 .31143 Mdot
.67175 .30902 Mdot
.67181 .30902 Mdot
.67187 .30902 Mdot
.67193 .3066 Mdot
.67199 .29936 Mdot
.67205 .28729 Mdot
.67211 .28005 Mdot
.67217 .27522 Mdot
.67223 .27522 Mdot
.67229 .27763 Mdot
.67235 .28005 Mdot
.67241 .27763 Mdot
.67247 .27763 Mdot
.67253 .28246 Mdot
.67259 .2897 Mdot
.67265 .29695 Mdot
.67271 .30419 Mdot
.67277 .30902 Mdot
.67283 .30902 Mdot
.67289 .30419 Mdot
.67295 .30419 Mdot
.67301 .30419 Mdot
.67307 .30902 Mdot
.67313 .31385 Mdot
.67319 .31626 Mdot
.67325 .31867 Mdot
.67331 .31626 Mdot
.67337 .31626 Mdot
.67343 .32109 Mdot
.67349 .32592 Mdot
.67355 .32833 Mdot
.67361 .32833 Mdot
.67367 .32109 Mdot
.67373 .31385 Mdot
.67379 .3066 Mdot
.67385 .30419 Mdot
.67391 .3066 Mdot
.67397 .30902 Mdot
.67403 .31143 Mdot
.67409 .31143 Mdot
.67415 .30902 Mdot
.67421 .31385 Mdot
.67427 .31867 Mdot
.67433 .32592 Mdot
.67439 .33074 Mdot
.67445 .33316 Mdot
.67451 .33074 Mdot
.67457 .32833 Mdot
.67463 .3235 Mdot
.67469 .32109 Mdot
.67475 .32109 Mdot
.67481 .3235 Mdot
.67487 .32592 Mdot
.67493 .3235 Mdot
.67499 .31626 Mdot
.67505 .31385 Mdot
.67511 .31143 Mdot
.67517 .31385 Mdot
.67523 .31143 Mdot
.67529 .3066 Mdot
.67535 .29695 Mdot
.67541 .28488 Mdot
.67547 .27522 Mdot
.67553 .27039 Mdot
.67559 .27039 Mdot
.67565 .27039 Mdot
.67571 .2728 Mdot
.67577 .27522 Mdot
.67583 .27763 Mdot
.67589 .28246 Mdot
.67595 .28729 Mdot
.67601 .29695 Mdot
.67607 .3066 Mdot
.67613 .31385 Mdot
.67619 .31385 Mdot
.67625 .31143 Mdot
.67631 .3066 Mdot
.67637 .3066 Mdot
.67643 .30902 Mdot
.67649 .31385 Mdot
.67655 .31626 Mdot
.67661 .31626 Mdot
.67667 .31385 Mdot
.67673 .31385 Mdot
.67679 .31626 Mdot
.67685 .31867 Mdot
.67691 .3235 Mdot
.67697 .3235 Mdot
.67703 .32109 Mdot
.67709 .31385 Mdot
.67715 .30902 Mdot
.67721 .3066 Mdot
.67727 .3066 Mdot
.67733 .31143 Mdot
.67739 .31385 Mdot
.67745 .31626 Mdot
.67751 .31385 Mdot
.67757 .31626 Mdot
.67763 .32109 Mdot
.67769 .32592 Mdot
.67775 .33074 Mdot
.67781 .33316 Mdot
.67787 .33074 Mdot
.67793 .3235 Mdot
.67799 .31867 Mdot
.67805 .31626 Mdot
.67811 .31867 Mdot
.67817 .32109 Mdot
.67823 .32109 Mdot
.67829 .32109 Mdot
.67835 .31867 Mdot
.67841 .31626 Mdot
.67847 .31385 Mdot
.67853 .31626 Mdot
.67859 .31626 Mdot
.67865 .31385 Mdot
.67871 .30419 Mdot
.67877 .29212 Mdot
.67883 .28005 Mdot
.67889 .2728 Mdot
.67895 .2728 Mdot
.67901 .2728 Mdot
.67907 .27522 Mdot
.67913 .27522 Mdot
.67919 .2728 Mdot
.67925 .27522 Mdot
.67931 .28246 Mdot
.67937 .29212 Mdot
.67943 .30177 Mdot
.67949 .3066 Mdot
.67955 .30902 Mdot
.67961 .30902 Mdot
.67967 .3066 Mdot
.67973 .3066 Mdot
.67979 .31143 Mdot
.67985 .31626 Mdot
.67991 .32109 Mdot
.67997 .32109 Mdot
.68003 .31867 Mdot
.68009 .31867 Mdot
.68015 .32109 Mdot
.68021 .3235 Mdot
.68027 .32592 Mdot
.68033 .3235 Mdot
.68039 .31867 Mdot
.68045 .31143 Mdot
.68051 .30419 Mdot
.68057 .30177 Mdot
.68063 .30177 Mdot
.68069 .3066 Mdot
.68075 .30902 Mdot
.68081 .31143 Mdot
.68087 .31385 Mdot
.68093 .31626 Mdot
.68099 .32109 Mdot
.68105 .32592 Mdot
.68111 .33074 Mdot
.68117 .33557 Mdot
.68123 .33557 Mdot
.68129 .33074 Mdot
.68135 .3235 Mdot
.68141 .31867 Mdot
.68147 .31867 Mdot
.68153 .32109 Mdot
.68159 .3235 Mdot
.68165 .31867 Mdot
.68171 .31385 Mdot
.68177 .31143 Mdot
.68183 .31143 Mdot
.68189 .31385 Mdot
.68195 .31143 Mdot
.68201 .30902 Mdot
.68207 .30419 Mdot
.68213 .29453 Mdot
.68219 .28246 Mdot
.68225 .27522 Mdot
.68231 .2728 Mdot
.68237 .27522 Mdot
.68243 .27763 Mdot
.68249 .27763 Mdot
.68255 .27522 Mdot
.68261 .27763 Mdot
.68267 .28246 Mdot
.68273 .29212 Mdot
.68279 .30177 Mdot
.68285 .3066 Mdot
.68291 .30902 Mdot
.68297 .3066 Mdot
.68303 .30419 Mdot
.68309 .30419 Mdot
.68315 .3066 Mdot
.68321 .31143 Mdot
.68327 .31626 Mdot
.68333 .31867 Mdot
.68339 .31867 Mdot
.68345 .31867 Mdot
.68351 .32109 Mdot
.68357 .3235 Mdot
.68363 .32592 Mdot
.68369 .32833 Mdot
.68375 .32592 Mdot
.68381 .31867 Mdot
.68387 .30902 Mdot
.68393 .30419 Mdot
.68399 .30419 Mdot
.68405 .3066 Mdot
.68411 .30902 Mdot
.68417 .30902 Mdot
.68423 .30902 Mdot
.68429 .31143 Mdot
.68435 .31626 Mdot
.68441 .32109 Mdot
.68447 .32833 Mdot
.68453 .33074 Mdot
.68459 .33316 Mdot
.68465 .33074 Mdot
.68471 .3235 Mdot
.68477 .32109 Mdot
.68483 .31867 Mdot
.68489 .3235 Mdot
.68495 .32592 Mdot
.68501 .3235 Mdot
.68507 .31867 Mdot
.68513 .31626 Mdot
.68519 .31385 Mdot
.68525 .31626 Mdot
.68531 .31385 Mdot
.68537 .31143 Mdot
.68543 .30419 Mdot
.68549 .29453 Mdot
.68555 .28246 Mdot
.68561 .2728 Mdot
.68567 .27039 Mdot
.68573 .26798 Mdot
.68579 .27039 Mdot
.68585 .2728 Mdot
.68591 .27522 Mdot
.68597 .27763 Mdot
.68603 .28488 Mdot
.68609 .29212 Mdot
.68615 .30177 Mdot
.6862 .30902 Mdot
.68626 .31385 Mdot
.68632 .31143 Mdot
.68638 .3066 Mdot
.68644 .30419 Mdot
.6865 .3066 Mdot
.68656 .31143 Mdot
.68662 .31385 Mdot
.68668 .31626 Mdot
.68674 .31626 Mdot
.6868 .31626 Mdot
.68686 .31867 Mdot
.68692 .32109 Mdot
.68698 .3235 Mdot
.68704 .32592 Mdot
.6871 .3235 Mdot
.68716 .31867 Mdot
.68722 .31143 Mdot
.68728 .3066 Mdot
.68734 .30419 Mdot
.6874 .3066 Mdot
.68746 .31143 Mdot
.68752 .31385 Mdot
.68758 .31626 Mdot
.68764 .31626 Mdot
.6877 .31867 Mdot
.68776 .3235 Mdot
.68782 .32833 Mdot
.68788 .33074 Mdot
.68794 .33074 Mdot
.688 .32592 Mdot
.68806 .32109 Mdot
.68812 .31626 Mdot
.68818 .31626 Mdot
.68824 .31626 Mdot
.6883 .31867 Mdot
.68836 .31867 Mdot
.68842 .31867 Mdot
.68848 .31867 Mdot
.68854 .31867 Mdot
.6886 .31867 Mdot
.68866 .31867 Mdot
.68872 .31626 Mdot
.68878 .31143 Mdot
.68884 .29936 Mdot
.6889 .28729 Mdot
.68896 .27763 Mdot
.68902 .27039 Mdot
.68908 .27039 Mdot
.68914 .27039 Mdot
.6892 .27039 Mdot
.68926 .2728 Mdot
.68932 .2728 Mdot
.68938 .28005 Mdot
.68944 .28729 Mdot
.6895 .29453 Mdot
.68956 .30177 Mdot
.68962 .3066 Mdot
.68968 .30902 Mdot
.68974 .3066 Mdot
.6898 .3066 Mdot
.68986 .30902 Mdot
.68992 .31385 Mdot
.68998 .31626 Mdot
.69004 .31867 Mdot
.6901 .31867 Mdot
.69016 .31867 Mdot
.69022 .32109 Mdot
.69028 .3235 Mdot
.69034 .32592 Mdot
.6904 .32592 Mdot
.69046 .3235 Mdot
.69052 .31626 Mdot
.69058 .31143 Mdot
.69064 .30419 Mdot
.6907 .30419 Mdot
.69076 .30419 Mdot
.69082 .30902 Mdot
.69088 .31143 Mdot
.69094 .31626 Mdot
.691 .31867 Mdot
.69106 .32109 Mdot
.69112 .32592 Mdot
.69118 .33074 Mdot
.69124 .33316 Mdot
.6913 .33316 Mdot
.69136 .32833 Mdot
.69142 .3235 Mdot
.69148 .31867 Mdot
.69154 .31626 Mdot
.6916 .31626 Mdot
.69166 .31626 Mdot
.69172 .31626 Mdot
.69178 .31385 Mdot
.69184 .31143 Mdot
.6919 .31385 Mdot
.69196 .31385 Mdot
.69202 .31385 Mdot
.69208 .31385 Mdot
.69214 .30902 Mdot
.6922 .30419 Mdot
.69226 .29453 Mdot
.69232 .28488 Mdot
.69238 .27763 Mdot
.69244 .27522 Mdot
.6925 .27522 Mdot
.69256 .27763 Mdot
.69262 .27763 Mdot
.69268 .27763 Mdot
.69274 .28246 Mdot
.6928 .28729 Mdot
.69286 .29453 Mdot
.69292 .29936 Mdot
.69298 .30177 Mdot
.69304 .30419 Mdot
.6931 .30177 Mdot
.69316 .30177 Mdot
.69322 .30177 Mdot
.69328 .3066 Mdot
.69334 .30902 Mdot
.6934 .31385 Mdot
.69346 .31626 Mdot
.69352 .31867 Mdot
.69358 .32109 Mdot
.69364 .32592 Mdot
.6937 .33074 Mdot
.69376 .33074 Mdot
.69382 .33074 Mdot
.69388 .32592 Mdot
.69394 .31626 Mdot
.694 .30902 Mdot
.69406 .3066 Mdot
.69412 .30419 Mdot
.69418 .3066 Mdot
.69424 .3066 Mdot
.6943 .30902 Mdot
.69436 .30902 Mdot
.69442 .31385 Mdot
.69448 .31867 Mdot
.69454 .3235 Mdot
.6946 .32833 Mdot
.69466 .33074 Mdot
.69472 .33074 Mdot
.69478 .32833 Mdot
.69484 .3235 Mdot
.6949 .32109 Mdot
.69496 .32109 Mdot
.69502 .3235 Mdot
.69508 .3235 Mdot
.69514 .32109 Mdot
.6952 .31626 Mdot
.69526 .31626 Mdot
.69532 .31626 Mdot
.69538 .31626 Mdot
.69544 .31626 Mdot
.6955 .30902 Mdot
.69556 .30177 Mdot
.69562 .29212 Mdot
.69568 .28246 Mdot
.69574 .27522 Mdot
.6958 .27039 Mdot
.69586 .27039 Mdot
.69592 .2728 Mdot
.69598 .27522 Mdot
.69604 .27763 Mdot
.6961 .28246 Mdot
.69616 .2897 Mdot
.69622 .29695 Mdot
.69628 .30419 Mdot
.69634 .30902 Mdot
.6964 .31143 Mdot
.69646 .30902 Mdot
.69652 .3066 Mdot
.69658 .3066 Mdot
.69664 .30902 Mdot
.6967 .31143 Mdot
.69676 .31143 Mdot
.69682 .31143 Mdot
.69688 .31143 Mdot
.69694 .31385 Mdot
.697 .31626 Mdot
.69706 .31867 Mdot
.69712 .32109 Mdot
.69718 .32109 Mdot
.69724 .31867 Mdot
.6973 .31626 Mdot
.69736 .30902 Mdot
.69742 .3066 Mdot
.69748 .3066 Mdot
.69754 .30902 Mdot
.6976 .31143 Mdot
.69766 .31143 Mdot
.69772 .31143 Mdot
.69778 .31385 Mdot
.69784 .31867 Mdot
.6979 .3235 Mdot
.69796 .32592 Mdot
.69802 .32592 Mdot
.69808 .32592 Mdot
.69814 .32109 Mdot
.6982 .31867 Mdot
.69826 .31626 Mdot
.69832 .31385 Mdot
.69838 .31626 Mdot
.69844 .31626 Mdot
.6985 .31867 Mdot
.69856 .31867 Mdot
.69862 .31867 Mdot
.69868 .31867 Mdot
.69874 .32109 Mdot
.6988 .32109 Mdot
.69886 .31867 Mdot
.69892 .31143 Mdot
.69898 .30419 Mdot
.69904 .29453 Mdot
.6991 .28488 Mdot
.69916 .28005 Mdot
.69922 .27763 Mdot
.69928 .27522 Mdot
.69934 .2728 Mdot
.6994 .27522 Mdot
.69946 .27763 Mdot
.69952 .28246 Mdot
.69958 .2897 Mdot
.69964 .29695 Mdot
.6997 .30177 Mdot
.69976 .3066 Mdot
.69982 .30902 Mdot
.69988 .31143 Mdot
.69994 .31143 Mdot
.7 .31385 Mdot
.70006 .31626 Mdot
.70012 .31867 Mdot
.70018 .31867 Mdot
.70024 .31867 Mdot
.7003 .31867 Mdot
.70036 .32109 Mdot
.70042 .3235 Mdot
.70048 .32109 Mdot
.70054 .32109 Mdot
.7006 .31626 Mdot
.70066 .31143 Mdot
.70072 .30419 Mdot
.70078 .29936 Mdot
.70084 .29695 Mdot
.7009 .29936 Mdot
.70096 .30177 Mdot
.70102 .3066 Mdot
.70108 .30902 Mdot
.70114 .31385 Mdot
.7012 .31626 Mdot
.70126 .3235 Mdot
.70132 .33074 Mdot
.70138 .33316 Mdot
.70144 .33316 Mdot
.7015 .33074 Mdot
.70156 .32592 Mdot
.70162 .32109 Mdot
.70168 .31867 Mdot
.70174 .31626 Mdot
.7018 .31626 Mdot
.70186 .31626 Mdot
.70192 .31385 Mdot
.70198 .31143 Mdot
.70204 .31143 Mdot
.7021 .31385 Mdot
.70216 .31385 Mdot
.70222 .31385 Mdot
.70228 .30902 Mdot
.70234 .30419 Mdot
.7024 .29695 Mdot
.70246 .2897 Mdot
.70252 .28488 Mdot
.70258 .28246 Mdot
.70264 .28246 Mdot
.7027 .28246 Mdot
.70276 .28246 Mdot
.70282 .28246 Mdot
.70288 .28729 Mdot
.70294 .29212 Mdot
.703 .29695 Mdot
.70306 .30177 Mdot
.70312 .30419 Mdot
.70318 .30419 Mdot
.70324 .30419 Mdot
.7033 .30419 Mdot
.70336 .30419 Mdot
.70342 .3066 Mdot
.70348 .31143 Mdot
.70354 .31626 Mdot
.7036 .31626 Mdot
.70366 .31867 Mdot
.70372 .32109 Mdot
.70378 .3235 Mdot
.70384 .32592 Mdot
.7039 .32592 Mdot
.70396 .3235 Mdot
.70402 .31867 Mdot
.70408 .31385 Mdot
.70414 .3066 Mdot
.7042 .30177 Mdot
.70426 .29936 Mdot
.70432 .29936 Mdot
.70438 .30177 Mdot
.70444 .30177 Mdot
.7045 .3066 Mdot
.70456 .31143 Mdot
.70462 .31626 Mdot
.70468 .32109 Mdot
.70474 .3235 Mdot
.7048 .32592 Mdot
.70486 .32833 Mdot
.70492 .32833 Mdot
.70498 .32592 Mdot
.70504 .3235 Mdot
.7051 .3235 Mdot
.70516 .3235 Mdot
.70522 .3235 Mdot
.70528 .32109 Mdot
.70534 .32109 Mdot
.7054 .32109 Mdot
.70546 .32109 Mdot
.70552 .31626 Mdot
.70558 .31143 Mdot
.70564 .3066 Mdot
.7057 .29936 Mdot
.70576 .29212 Mdot
.70582 .28488 Mdot
.70588 .27763 Mdot
.70594 .27522 Mdot
.706 .27522 Mdot
.70606 .27763 Mdot
.70612 .27763 Mdot
.70618 .28246 Mdot
.70624 .28729 Mdot
.7063 .29453 Mdot
.70636 .30177 Mdot
.70642 .3066 Mdot
.70648 .31143 Mdot
.70654 .31143 Mdot
.7066 .31143 Mdot
.70666 .31143 Mdot
.70672 .30902 Mdot
.70678 .30902 Mdot
.70684 .31143 Mdot
.7069 .31143 Mdot
.70696 .31143 Mdot
.70702 .31385 Mdot
.70708 .31626 Mdot
.70714 .31867 Mdot
.7072 .31867 Mdot
.70726 .31867 Mdot
.70732 .31867 Mdot
.70738 .31626 Mdot
.70744 .31143 Mdot
.7075 .30902 Mdot
.70756 .30419 Mdot
.70762 .30419 Mdot
.70768 .30419 Mdot
.70774 .3066 Mdot
.7078 .30902 Mdot
.70786 .31143 Mdot
.70792 .31626 Mdot
.70798 .32109 Mdot
.70804 .3235 Mdot
.7081 .32592 Mdot
.70816 .32592 Mdot
.70822 .32592 Mdot
.70828 .3235 Mdot
.70834 .31867 Mdot
.7084 .31626 Mdot
.70846 .31626 Mdot
.70852 .31626 Mdot
.70858 .31626 Mdot
.70864 .31626 Mdot
.7087 .31626 Mdot
.70876 .31867 Mdot
.70882 .32109 Mdot
.70888 .32109 Mdot
.70894 .31867 Mdot
.709 .31385 Mdot
.70906 .3066 Mdot
.70912 .29936 Mdot
.70918 .29212 Mdot
.70924 .28246 Mdot
.7093 .27763 Mdot
.70936 .27522 Mdot
.70942 .27522 Mdot
.70948 .27522 Mdot
.70954 .27763 Mdot
.7096 .28005 Mdot
.70966 .28729 Mdot
.70972 .29212 Mdot
.70978 .29936 Mdot
.70984 .30419 Mdot
.7099 .3066 Mdot
.70996 .30902 Mdot
.71002 .30902 Mdot
.71008 .31143 Mdot
.71014 .31385 Mdot
.7102 .31626 Mdot
.71026 .31867 Mdot
.71032 .32109 Mdot
.71038 .32109 Mdot
.71044 .3235 Mdot
.7105 .3235 Mdot
.71056 .3235 Mdot
.71062 .32109 Mdot
.71068 .31867 Mdot
.71074 .31385 Mdot
.7108 .30902 Mdot
.71086 .30419 Mdot
.71092 .29936 Mdot
.71098 .29695 Mdot
.71104 .29695 Mdot
.7111 .29936 Mdot
.71116 .30419 Mdot
.71122 .30902 Mdot
.71128 .31385 Mdot
.71134 .32109 Mdot
.7114 .32592 Mdot
.71146 .32833 Mdot
.71152 .33074 Mdot
.71158 .33074 Mdot
.71164 .33074 Mdot
.7117 .32592 Mdot
.71176 .3235 Mdot
.71182 .31867 Mdot
.71188 .31626 Mdot
.71194 .31626 Mdot
.712 .31626 Mdot
.71206 .31626 Mdot
.71212 .31385 Mdot
.71218 .31385 Mdot
.71224 .31385 Mdot
.7123 .31143 Mdot
.71236 .30902 Mdot
.71242 .30419 Mdot
.71248 .29695 Mdot
.71254 .29212 Mdot
.7126 .28729 Mdot
.71266 .28246 Mdot
.71272 .27763 Mdot
.71278 .27763 Mdot
.71284 .28005 Mdot
.7129 .28246 Mdot
.71296 .28729 Mdot
.71302 .2897 Mdot
.71308 .29453 Mdot
.71314 .29936 Mdot
.7132 .30177 Mdot
.71326 .30419 Mdot
.71332 .3066 Mdot
.71338 .3066 Mdot
.71344 .30419 Mdot
.7135 .3066 Mdot
.71356 .30902 Mdot
.71362 .31385 Mdot
.71368 .31626 Mdot
.71374 .31867 Mdot
.7138 .32109 Mdot
.71386 .32592 Mdot
.71392 .32833 Mdot
.71398 .32833 Mdot
.71404 .3235 Mdot
.7141 .32109 Mdot
.71416 .31626 Mdot
.71422 .31143 Mdot
.71428 .3066 Mdot
.71434 .30177 Mdot
.7144 .29936 Mdot
.71446 .29936 Mdot
.71452 .30419 Mdot
.71458 .3066 Mdot
.71464 .30902 Mdot
.7147 .31385 Mdot
.71476 .31867 Mdot
.71482 .3235 Mdot
.71488 .32592 Mdot
.71494 .32592 Mdot
.715 .32592 Mdot
.71506 .32592 Mdot
.71512 .3235 Mdot
.71518 .32109 Mdot
.71524 .32109 Mdot
.7153 .31867 Mdot
.71536 .32109 Mdot
.71542 .32109 Mdot
.71548 .31867 Mdot
.71554 .31867 Mdot
.7156 .31626 Mdot
.71566 .31385 Mdot
.71572 .31143 Mdot
.71578 .30419 Mdot
.71584 .29936 Mdot
.7159 .29212 Mdot
.71596 .28246 Mdot
.71602 .27522 Mdot
.71608 .2728 Mdot
.71614 .2728 Mdot
.7162 .27522 Mdot
.71626 .28005 Mdot
.71632 .28488 Mdot
.71638 .2897 Mdot
.71644 .29695 Mdot
.7165 .30177 Mdot
.71656 .30419 Mdot
.71662 .30902 Mdot
.71668 .30902 Mdot
.71674 .31143 Mdot
.7168 .31143 Mdot
.71686 .30902 Mdot
.71692 .30902 Mdot
.71698 .30902 Mdot
.71704 .31385 Mdot
.7171 .31626 Mdot
.71716 .31867 Mdot
.71722 .32109 Mdot
.71728 .32109 Mdot
.71734 .32109 Mdot
.7174 .32109 Mdot
.71746 .31867 Mdot
.71752 .31626 Mdot
.71758 .31385 Mdot
.71764 .30902 Mdot
.7177 .30419 Mdot
.71776 .30177 Mdot
.71782 .30177 Mdot
.71788 .3066 Mdot
.71794 .30902 Mdot
.718 .31385 Mdot
.71806 .31867 Mdot
.71812 .32109 Mdot
.71818 .3235 Mdot
.71824 .3235 Mdot
.7183 .32592 Mdot
.71836 .3235 Mdot
.71842 .32109 Mdot
.71848 .31867 Mdot
.71854 .31385 Mdot
.7186 .31143 Mdot
.71866 .31385 Mdot
.71872 .31626 Mdot
.71878 .31867 Mdot
.71884 .31867 Mdot
.7189 .31867 Mdot
.71896 .32109 Mdot
.71902 .31867 Mdot
.71908 .31385 Mdot
.71914 .30902 Mdot
.7192 .30419 Mdot
.71926 .29936 Mdot
.71932 .2897 Mdot
.71938 .28005 Mdot
.71944 .27522 Mdot
.7195 .2728 Mdot
.71956 .27522 Mdot
.71962 .27763 Mdot
.71968 .28246 Mdot
.71974 .28488 Mdot
.7198 .2897 Mdot
.71986 .29453 Mdot
.71992 .29936 Mdot
.71998 .30419 Mdot
.72004 .3066 Mdot
.7201 .30902 Mdot
.72016 .30902 Mdot
.72022 .30902 Mdot
.72028 .30902 Mdot
.72034 .31143 Mdot
.7204 .31385 Mdot
.72046 .31867 Mdot
.72052 .3235 Mdot
.72058 .32592 Mdot
.72064 .32592 Mdot
.7207 .3235 Mdot
.72076 .32109 Mdot
.72082 .31867 Mdot
.72088 .31626 Mdot
.72094 .31143 Mdot
.721 .3066 Mdot
.72106 .30177 Mdot
.72112 .29936 Mdot
.72118 .29936 Mdot
.72124 .30177 Mdot
.7213 .3066 Mdot
.72136 .31385 Mdot
.72142 .31867 Mdot
.72148 .3235 Mdot
.72154 .32592 Mdot
.7216 .32833 Mdot
.72166 .32833 Mdot
.72172 .32833 Mdot
.72178 .32833 Mdot
.72184 .3235 Mdot
.7219 .31867 Mdot
.72196 .31385 Mdot
.72202 .31143 Mdot
.72208 .31143 Mdot
.72214 .31626 Mdot
.7222 .31626 Mdot
.72226 .31626 Mdot
.72232 .31626 Mdot
.72238 .31385 Mdot
.72244 .31385 Mdot
.7225 .30902 Mdot
.72256 .30419 Mdot
.72262 .29695 Mdot
.72268 .29212 Mdot
.72274 .28488 Mdot
.7228 .28005 Mdot
.72286 .27522 Mdot
.72292 .27522 Mdot
.72298 .27763 Mdot
.72304 .28488 Mdot
.7231 .2897 Mdot
.72316 .29212 Mdot
.72322 .29453 Mdot
.72328 .29695 Mdot
.72334 .30177 Mdot
.7234 .3066 Mdot
.72346 .30902 Mdot
.72352 .3066 Mdot
.72358 .30419 Mdot
.72364 .30419 Mdot
.7237 .3066 Mdot
.72376 .31143 Mdot
.72382 .31385 Mdot
.72388 .31867 Mdot
.72394 .32109 Mdot
.724 .32592 Mdot
.72406 .32592 Mdot
.72412 .32592 Mdot
.72418 .3235 Mdot
.72424 .32109 Mdot
.7243 .31867 Mdot
.72436 .31385 Mdot
.72442 .3066 Mdot
.72448 .30177 Mdot
.72454 .29695 Mdot
.7246 .29936 Mdot
.72466 .30419 Mdot
.72472 .30902 Mdot
.72478 .31143 Mdot
.72484 .31385 Mdot
.7249 .31626 Mdot
.72496 .3235 Mdot
.72502 .32592 Mdot
.72508 .32592 Mdot
.72514 .32592 Mdot
.7252 .32592 Mdot
.72526 .3235 Mdot
.72532 .32109 Mdot
.72538 .31626 Mdot
.72544 .31626 Mdot
.7255 .31867 Mdot
.72556 .32109 Mdot
.72562 .32109 Mdot
.72568 .31867 Mdot
.72574 .31626 Mdot
.7258 .31385 Mdot
.72586 .31143 Mdot
.72592 .3066 Mdot
.72598 .30177 Mdot
.72604 .29453 Mdot
.7261 .28488 Mdot
.72616 .28005 Mdot
.72622 .27763 Mdot
.72628 .27763 Mdot
.72634 .28005 Mdot
.7264 .28246 Mdot
.72646 .28729 Mdot
.72652 .29453 Mdot
.72658 .29695 Mdot
.72664 .30177 Mdot
.7267 .30419 Mdot
.72676 .30902 Mdot
.72682 .31385 Mdot
.72688 .31626 Mdot
.72694 .31385 Mdot
.727 .30902 Mdot
.72706 .30902 Mdot
.72712 .31143 Mdot
.72718 .31626 Mdot
.72724 .31867 Mdot
.7273 .31626 Mdot
.72736 .31626 Mdot
.72742 .31626 Mdot
.72748 .31867 Mdot
.72754 .31867 Mdot
.7276 .31626 Mdot
.72766 .31143 Mdot
.72772 .30902 Mdot
.72778 .3066 Mdot
.72784 .30177 Mdot
.7279 .29936 Mdot
.72796 .29936 Mdot
.72802 .30419 Mdot
.72808 .31143 Mdot
.72814 .31626 Mdot
.7282 .31626 Mdot
.72826 .31867 Mdot
.72832 .31867 Mdot
.72838 .3235 Mdot
.72844 .32592 Mdot
.7285 .3235 Mdot
.72856 .32109 Mdot
.72862 .31626 Mdot
.72868 .31385 Mdot
.72874 .31385 Mdot
.7288 .31626 Mdot
.72886 .31626 Mdot
.72892 .31867 Mdot
.72898 .31867 Mdot
.72904 .32109 Mdot
.7291 .31867 Mdot
.72916 .31626 Mdot
.72922 .31385 Mdot
.72928 .31143 Mdot
.72934 .3066 Mdot
.7294 .29936 Mdot
.72946 .29212 Mdot
.72952 .28488 Mdot
.72958 .27763 Mdot
.72964 .27763 Mdot
.7297 .28005 Mdot
.72976 .28246 Mdot
.72982 .28246 Mdot
.72988 .28488 Mdot
.72994 .2897 Mdot
.73 .29695 Mdot
.73006 .30177 Mdot
.73012 .30419 Mdot
.73018 .30902 Mdot
.73024 .31143 Mdot
.7303 .31143 Mdot
.73036 .31143 Mdot
.73042 .31143 Mdot
.73048 .31385 Mdot
.73054 .31626 Mdot
.7306 .32109 Mdot
.73066 .3235 Mdot
.73072 .32109 Mdot
.73078 .31867 Mdot
.73084 .31867 Mdot
.7309 .31867 Mdot
.73096 .31867 Mdot
.73102 .31385 Mdot
.73108 .30902 Mdot
.73114 .30177 Mdot
.7312 .29936 Mdot
.73126 .29695 Mdot
.73132 .29936 Mdot
.73138 .30177 Mdot
.73144 .3066 Mdot
.7315 .31143 Mdot
.73156 .31626 Mdot
.73162 .31867 Mdot
.73168 .32109 Mdot
.73174 .3235 Mdot
.7318 .32592 Mdot
.73186 .32833 Mdot
.73192 .32592 Mdot
.73198 .3235 Mdot
.73204 .31626 Mdot
.7321 .31626 Mdot
.73216 .31626 Mdot
.73222 .31867 Mdot
.73228 .32109 Mdot
.73234 .31867 Mdot
.7324 .31626 Mdot
.73246 .31385 Mdot
.73252 .31385 Mdot
.73258 .31143 Mdot
.73264 .30902 Mdot
.7327 .30419 Mdot
.73276 .29936 Mdot
.73282 .29453 Mdot
.73288 .28729 Mdot
.73294 .28246 Mdot
.733 .28005 Mdot
.73306 .28246 Mdot
.73312 .28729 Mdot
.73318 .2897 Mdot
.73324 .29212 Mdot
.7333 .29212 Mdot
.73336 .29453 Mdot
.73342 .29936 Mdot
.73348 .30419 Mdot
.73354 .3066 Mdot
.7336 .30902 Mdot
.73366 .3066 Mdot
.73372 .3066 Mdot
.73378 .3066 Mdot
.73384 .30902 Mdot
.7339 .31143 Mdot
.73396 .31626 Mdot
.73402 .31867 Mdot
.73408 .32109 Mdot
.73414 .32109 Mdot
.7342 .32109 Mdot
.73426 .32109 Mdot
.73432 .32109 Mdot
.73438 .32109 Mdot
.73444 .31626 Mdot
.7345 .31143 Mdot
.73456 .30419 Mdot
.73462 .29936 Mdot
.73468 .29936 Mdot
.73474 .30177 Mdot
.7348 .3066 Mdot
.73486 .30902 Mdot
.73492 .30902 Mdot
.73498 .31143 Mdot
.73504 .31385 Mdot
.7351 .31867 Mdot
.73516 .32109 Mdot
.73522 .3235 Mdot
.73528 .3235 Mdot
.73534 .3235 Mdot
.7354 .32109 Mdot
.73546 .31867 Mdot
.73552 .31867 Mdot
.73558 .32109 Mdot
.73564 .3235 Mdot
.7357 .3235 Mdot
.73576 .32109 Mdot
.73582 .31867 Mdot
.73588 .31626 Mdot
.73594 .31385 Mdot
.736 .31143 Mdot
.73606 .3066 Mdot
.73612 .29936 Mdot
.73618 .29212 Mdot
.73624 .28488 Mdot
.7363 .28005 Mdot
.73636 .27763 Mdot
.73642 .27763 Mdot
.73648 .28005 Mdot
.73654 .28488 Mdot
.7366 .28729 Mdot
.73666 .29212 Mdot
.73672 .29695 Mdot
.73678 .29936 Mdot
.73684 .3066 Mdot
.7369 .31143 Mdot
.73696 .31385 Mdot
.73702 .31385 Mdot
.73708 .31143 Mdot
.73714 .31143 Mdot
.7372 .31143 Mdot
.73726 .31385 Mdot
.73732 .31626 Mdot
.73738 .31867 Mdot
.73744 .31867 Mdot
.7375 .31626 Mdot
.73756 .31626 Mdot
.73762 .31626 Mdot
.73768 .31626 Mdot
.73774 .31626 Mdot
.7378 .31385 Mdot
.73786 .30902 Mdot
.73792 .30419 Mdot
.73798 .30177 Mdot
.73804 .29936 Mdot
.7381 .30177 Mdot
.73816 .30902 Mdot
.73822 .31143 Mdot
.73828 .31385 Mdot
.73834 .31385 Mdot
.7384 .31626 Mdot
.73846 .32109 Mdot
.73852 .3235 Mdot
.73858 .3235 Mdot
.73864 .3235 Mdot
.7387 .32109 Mdot
.73876 .31867 Mdot
.73882 .31626 Mdot
.73888 .31626 Mdot
.73894 .31626 Mdot
.739 .31867 Mdot
.73906 .31867 Mdot
.73912 .31867 Mdot
.73918 .31867 Mdot
.73924 .31626 Mdot
.7393 .31385 Mdot
.73936 .31385 Mdot
.73941 .31143 Mdot
.73947 .3066 Mdot
.73953 .29936 Mdot
.73959 .29212 Mdot
.73965 .28488 Mdot
.73971 .28005 Mdot
.73977 .28005 Mdot
.73983 .28246 Mdot
.73989 .28246 Mdot
.73995 .28488 Mdot
.74001 .28729 Mdot
.74007 .2897 Mdot
.74013 .29453 Mdot
.74019 .29695 Mdot
.74025 .30419 Mdot
.74031 .30902 Mdot
.74037 .31143 Mdot
.74043 .30902 Mdot
.74049 .30902 Mdot
.74055 .31143 Mdot
.74061 .31626 Mdot
.74067 .32109 Mdot
.74073 .3235 Mdot
.74079 .3235 Mdot
.74085 .32109 Mdot
.74091 .32109 Mdot
.74097 .32109 Mdot
.74103 .32109 Mdot
.74109 .31867 Mdot
.74115 .31626 Mdot
.74121 .31143 Mdot
.74127 .30419 Mdot
.74133 .29695 Mdot
.74139 .29453 Mdot
.74145 .29695 Mdot
.74151 .29936 Mdot
.74157 .30419 Mdot
.74163 .30902 Mdot
.74169 .31143 Mdot
.74175 .31385 Mdot
.74181 .31626 Mdot
.74187 .3235 Mdot
.74193 .32833 Mdot
.74199 .33074 Mdot
.74205 .32833 Mdot
.74211 .3235 Mdot
.74217 .32109 Mdot
.74223 .31867 Mdot
.74229 .31867 Mdot
.74235 .32109 Mdot
.74241 .32109 Mdot
.74247 .31867 Mdot
.74253 .31626 Mdot
.74259 .31143 Mdot
.74265 .30902 Mdot
.74271 .30902 Mdot
.74277 .3066 Mdot
.74283 .30419 Mdot
.74289 .29936 Mdot
.74295 .2897 Mdot
.74301 .28246 Mdot
.74307 .28005 Mdot
.74313 .28005 Mdot
.74319 .28246 Mdot
.74325 .28729 Mdot
.74331 .2897 Mdot
.74337 .2897 Mdot
.74343 .29212 Mdot
.74349 .29695 Mdot
.74355 .30177 Mdot
.74361 .3066 Mdot
.74367 .30902 Mdot
.74373 .30902 Mdot
.74379 .30902 Mdot
.74385 .3066 Mdot
.74391 .3066 Mdot
.74397 .30902 Mdot
.74403 .31385 Mdot
.74409 .31867 Mdot
.74415 .32109 Mdot
.74421 .32109 Mdot
.74427 .32109 Mdot
.74433 .32109 Mdot
.74439 .32109 Mdot
.74445 .3235 Mdot
.74451 .32109 Mdot
.74457 .31626 Mdot
.74463 .30902 Mdot
.74469 .30419 Mdot
.74475 .29936 Mdot
.74481 .29936 Mdot
.74487 .30177 Mdot
.74493 .3066 Mdot
.74499 .30902 Mdot
.74505 .30902 Mdot
.74511 .31143 Mdot
.74517 .31385 Mdot
.74523 .31626 Mdot
.74529 .32109 Mdot
.74535 .3235 Mdot
.74541 .3235 Mdot
.74547 .32109 Mdot
.74553 .31626 Mdot
.74559 .31385 Mdot
.74565 .31626 Mdot
.74571 .32109 Mdot
.74577 .3235 Mdot
.74583 .3235 Mdot
.74589 .32109 Mdot
.74595 .31867 Mdot
.74601 .31626 Mdot
.74607 .31626 Mdot
.74613 .31385 Mdot
.74619 .30902 Mdot
.74625 .30177 Mdot
.74631 .29453 Mdot
.74637 .28488 Mdot
.74643 .27763 Mdot
.74649 .27522 Mdot
.74655 .27763 Mdot
.74661 .28246 Mdot
.74667 .28488 Mdot
.74673 .28729 Mdot
.74679 .2897 Mdot
.74685 .29212 Mdot
.74691 .29936 Mdot
.74697 .3066 Mdot
.74703 .30902 Mdot
.74709 .31143 Mdot
.74715 .31143 Mdot
.74721 .30902 Mdot
.74727 .30902 Mdot
.74733 .31143 Mdot
.74739 .31385 Mdot
.74745 .31626 Mdot
.74751 .31867 Mdot
.74757 .32109 Mdot
.74763 .31867 Mdot
.74769 .31626 Mdot
.74775 .31626 Mdot
.74781 .31867 Mdot
.74787 .31867 Mdot
.74793 .31626 Mdot
.74799 .31143 Mdot
.74805 .30419 Mdot
.74811 .30177 Mdot
.74817 .30177 Mdot
.74823 .30419 Mdot
.74829 .30902 Mdot
.74835 .31143 Mdot
.74841 .31385 Mdot
.74847 .31385 Mdot
.74853 .31626 Mdot
.74859 .32109 Mdot
.74865 .3235 Mdot
.74871 .32592 Mdot
.74877 .32592 Mdot
.74883 .32109 Mdot
.74889 .31867 Mdot
.74895 .31385 Mdot
.74901 .31143 Mdot
.74907 .31385 Mdot
.74913 .31867 Mdot
.74919 .31867 Mdot
.74925 .31626 Mdot
.74931 .31626 Mdot
.74937 .31385 Mdot
.74943 .31385 Mdot
.74949 .31626 Mdot
.74955 .31385 Mdot
.74961 .30902 Mdot
.74967 .29936 Mdot
.74973 .2897 Mdot
.74979 .28488 Mdot
.74985 .28005 Mdot
.74991 .28005 Mdot
.74997 .28246 Mdot
.75003 .28488 Mdot
.75009 .28488 Mdot
.75015 .28729 Mdot
.75021 .2897 Mdot
.75027 .29212 Mdot
.75033 .29695 Mdot
.75039 .30177 Mdot
.75045 .3066 Mdot
.75051 .3066 Mdot
.75057 .3066 Mdot
.75063 .30419 Mdot
.75069 .3066 Mdot
.75075 .31385 Mdot
.75081 .31867 Mdot
.75087 .32109 Mdot
.75093 .32109 Mdot
.75099 .32109 Mdot
.75105 .32109 Mdot
.75111 .32109 Mdot
.75117 .32109 Mdot
.75123 .32109 Mdot
.75129 .31626 Mdot
.75135 .31143 Mdot
.75141 .30419 Mdot
.75147 .29695 Mdot
.75153 .29453 Mdot
.75159 .29695 Mdot
.75165 .30177 Mdot
.75171 .3066 Mdot
.75177 .3066 Mdot
.75183 .30902 Mdot
.75189 .31385 Mdot
.75195 .31867 Mdot
.75201 .3235 Mdot
.75207 .32833 Mdot
.75213 .32833 Mdot
.75219 .32833 Mdot
.75225 .32592 Mdot
.75231 .32109 Mdot
.75237 .31867 Mdot
.75243 .31867 Mdot
.75249 .32109 Mdot
.75255 .32109 Mdot
.75261 .31867 Mdot
.75267 .31626 Mdot
.75273 .31385 Mdot
.75279 .31143 Mdot
.75285 .31143 Mdot
.75291 .30902 Mdot
.75297 .30419 Mdot
.75303 .29936 Mdot
.75309 .29212 Mdot
.75315 .28729 Mdot
.75321 .28488 Mdot
.75327 .28488 Mdot
.75333 .2897 Mdot
.75339 .29212 Mdot
.75345 .29212 Mdot
.75351 .29453 Mdot
.75357 .29695 Mdot
.75363 .29936 Mdot
.75369 .30419 Mdot
.75375 .30902 Mdot
.75381 .31143 Mdot
.75387 .31385 Mdot
.75393 .31143 Mdot
.75399 .3066 Mdot
.75405 .30419 Mdot
.75411 .3066 Mdot
.75417 .31143 Mdot
.75423 .31385 Mdot
.75429 .31626 Mdot
.75435 .31385 Mdot
.75441 .31385 Mdot
.75447 .31626 Mdot
.75453 .31867 Mdot
.75459 .31626 Mdot
.75465 .31626 Mdot
.75471 .31143 Mdot
.75477 .3066 Mdot
.75483 .30177 Mdot
.75489 .29936 Mdot
.75495 .29936 Mdot
.75501 .30419 Mdot
.75507 .3066 Mdot
.75513 .3066 Mdot
.75519 .30902 Mdot
.75525 .30902 Mdot
.75531 .31385 Mdot
.75537 .31626 Mdot
.75543 .32109 Mdot
.75549 .3235 Mdot
.75555 .32109 Mdot
.75561 .32109 Mdot
.75567 .31626 Mdot
.75573 .31626 Mdot
.75579 .31867 Mdot
.75585 .32109 Mdot
.75591 .3235 Mdot
.75597 .3235 Mdot
.75603 .32109 Mdot
.75609 .32109 Mdot
.75615 .31867 Mdot
.75621 .31626 Mdot
.75627 .31626 Mdot
.75633 .31143 Mdot
.75639 .3066 Mdot
.75645 .29695 Mdot
.75651 .28729 Mdot
.75657 .28246 Mdot
.75663 .28005 Mdot
.75669 .28246 Mdot
.75675 .28488 Mdot
.75681 .28729 Mdot
.75687 .28729 Mdot
.75693 .2897 Mdot
.75699 .29695 Mdot
.75705 .30177 Mdot
.75711 .3066 Mdot
.75717 .31143 Mdot
.75723 .31385 Mdot
.75729 .31385 Mdot
.75735 .31143 Mdot
.75741 .30902 Mdot
.75747 .31143 Mdot
.75753 .31626 Mdot
.75759 .31867 Mdot
.75765 .31867 Mdot
.75771 .31626 Mdot
.75777 .31385 Mdot
.75783 .31385 Mdot
.75789 .31385 Mdot
.75795 .31385 Mdot
.75801 .31143 Mdot
.75807 .3066 Mdot
.75813 .30177 Mdot
.75819 .29695 Mdot
.75825 .29453 Mdot
.75831 .29695 Mdot
.75837 .29936 Mdot
.75843 .30419 Mdot
.75849 .3066 Mdot
.75855 .30902 Mdot
.75861 .31385 Mdot
.75867 .31626 Mdot
.75873 .31867 Mdot
.75879 .3235 Mdot
.75885 .32592 Mdot
.75891 .32592 Mdot
.75897 .3235 Mdot
.75903 .31867 Mdot
.75909 .31626 Mdot
.75915 .31626 Mdot
.75921 .31867 Mdot
.75927 .31867 Mdot
.75933 .31867 Mdot
.75939 .31626 Mdot
.75945 .31626 Mdot
.75951 .31626 Mdot
.75957 .31626 Mdot
.75963 .31626 Mdot
.75969 .31385 Mdot
.75975 .30902 Mdot
.75981 .30177 Mdot
.75987 .29453 Mdot
.75993 .28729 Mdot
.75999 .28488 Mdot
.76005 .28729 Mdot
.76011 .2897 Mdot
.76017 .29212 Mdot
.76023 .2897 Mdot
.76029 .2897 Mdot
.76035 .29453 Mdot
.76041 .29936 Mdot
.76047 .30419 Mdot
.76053 .30902 Mdot
.76059 .31143 Mdot
.76065 .30902 Mdot
.76071 .30902 Mdot
.76077 .30902 Mdot
.76083 .30902 Mdot
.76089 .31385 Mdot
.76095 .31626 Mdot
.76101 .31626 Mdot
.76107 .31626 Mdot
.76113 .31626 Mdot
.76119 .31626 Mdot
.76125 .31626 Mdot
.76131 .31626 Mdot
.76137 .31626 Mdot
.76143 .31143 Mdot
.76149 .30419 Mdot
.76155 .29936 Mdot
.76161 .29453 Mdot
.76167 .29453 Mdot
.76173 .29695 Mdot
.76179 .30177 Mdot
.76185 .30419 Mdot
.76191 .3066 Mdot
.76197 .30902 Mdot
.76203 .31143 Mdot
.76209 .31626 Mdot
.76215 .32109 Mdot
.76221 .32592 Mdot
.76227 .32592 Mdot
.76233 .32592 Mdot
.76239 .32109 Mdot
.76245 .31867 Mdot
.76251 .31867 Mdot
.76257 .31867 Mdot
.76263 .32109 Mdot
.76269 .3235 Mdot
.76275 .32109 Mdot
.76281 .31867 Mdot
.76287 .31626 Mdot
.76293 .31626 Mdot
.76299 .31626 Mdot
.76305 .31385 Mdot
.76311 .3066 Mdot
.76317 .29936 Mdot
.76323 .29212 Mdot
.76329 .28729 Mdot
.76335 .28488 Mdot
.76341 .28488 Mdot
.76347 .28729 Mdot
.76353 .2897 Mdot
.76359 .29212 Mdot
.76365 .29453 Mdot
.76371 .29695 Mdot
.76377 .30177 Mdot
.76383 .3066 Mdot
.76389 .31143 Mdot
.76395 .31385 Mdot
.76401 .31143 Mdot
.76407 .30902 Mdot
.76413 .30902 Mdot
.76419 .30902 Mdot
.76425 .31143 Mdot
.76431 .31385 Mdot
.76437 .31385 Mdot
.76443 .31143 Mdot
.76449 .31143 Mdot
.76455 .31143 Mdot
.76461 .31143 Mdot
.76467 .31143 Mdot
.76473 .31143 Mdot
.76479 .31143 Mdot
.76485 .30902 Mdot
.76491 .30177 Mdot
.76497 .29695 Mdot
.76503 .29453 Mdot
.76509 .29936 Mdot
.76515 .3066 Mdot
.76521 .30902 Mdot
.76527 .30902 Mdot
.76533 .30902 Mdot
.76539 .31143 Mdot
.76545 .31626 Mdot
.76551 .32109 Mdot
.76557 .3235 Mdot
.76563 .3235 Mdot
.76569 .32109 Mdot
.76575 .31867 Mdot
.76581 .31626 Mdot
.76587 .31626 Mdot
.76593 .31626 Mdot
.76599 .32109 Mdot
.76605 .3235 Mdot
.76611 .3235 Mdot
.76617 .32109 Mdot
.76623 .31867 Mdot
.76629 .31867 Mdot
.76635 .31867 Mdot
.76641 .31867 Mdot
.76647 .31385 Mdot
.76653 .3066 Mdot
.76659 .29695 Mdot
.76665 .28729 Mdot
.76671 .28488 Mdot
.76677 .28488 Mdot
.76683 .28729 Mdot
.76689 .28729 Mdot
.76695 .28729 Mdot
.76701 .28729 Mdot
.76707 .29212 Mdot
.76713 .29695 Mdot
.76719 .30177 Mdot
.76725 .3066 Mdot
.76731 .31385 Mdot
.76737 .31385 Mdot
.76743 .31385 Mdot
.76749 .30902 Mdot
.76755 .30902 Mdot
.76761 .31385 Mdot
.76767 .31867 Mdot
.76773 .32109 Mdot
.76779 .31867 Mdot
.76785 .31385 Mdot
.76791 .31385 Mdot
.76797 .31385 Mdot
.76803 .31385 Mdot
.76809 .31385 Mdot
.76815 .31143 Mdot
.76821 .30419 Mdot
.76827 .29936 Mdot
.76833 .29453 Mdot
.76839 .29212 Mdot
.76845 .29453 Mdot
.76851 .29936 Mdot
.76857 .30419 Mdot
.76863 .3066 Mdot
.76869 .31143 Mdot
.76875 .31385 Mdot
.76881 .31867 Mdot
.76887 .32109 Mdot
.76893 .32833 Mdot
.76899 .33074 Mdot
.76905 .32833 Mdot
.76911 .3235 Mdot
.76917 .31626 Mdot
.76923 .31385 Mdot
.76929 .31626 Mdot
.76935 .31867 Mdot
.76941 .31867 Mdot
.76947 .31867 Mdot
.76953 .31626 Mdot
.76959 .31626 Mdot
.76965 .31626 Mdot
.76971 .31626 Mdot
.76977 .31385 Mdot
.76983 .31143 Mdot
.76989 .3066 Mdot
.76995 .29695 Mdot
.77001 .2897 Mdot
.77007 .28488 Mdot
.77013 .28488 Mdot
.77019 .28729 Mdot
.77025 .2897 Mdot
.77031 .2897 Mdot
.77037 .2897 Mdot
.77043 .29212 Mdot
.77049 .29695 Mdot
.77055 .30177 Mdot
.77061 .30902 Mdot
.77067 .31143 Mdot
.77073 .31143 Mdot
.77079 .31143 Mdot
.77085 .30902 Mdot
.77091 .30902 Mdot
.77097 .31143 Mdot
.77103 .31385 Mdot
.77109 .31626 Mdot
.77115 .31626 Mdot
.77121 .31626 Mdot
.77127 .31626 Mdot
.77133 .31385 Mdot
.77139 .31385 Mdot
.77145 .31385 Mdot
.77151 .31385 Mdot
.77157 .30902 Mdot
.77163 .30177 Mdot
.77169 .29695 Mdot
.77175 .29212 Mdot
.77181 .29453 Mdot
.77187 .29936 Mdot
.77193 .30177 Mdot
.77199 .30419 Mdot
.77205 .30902 Mdot
.77211 .31143 Mdot
.77217 .31626 Mdot
.77223 .32109 Mdot
.77229 .32592 Mdot
.77235 .32833 Mdot
.77241 .32833 Mdot
.77247 .32592 Mdot
.77253 .32109 Mdot
.77259 .31626 Mdot
.77265 .31867 Mdot
.77271 .32109 Mdot
.77277 .3235 Mdot
.77283 .32109 Mdot
.77289 .31867 Mdot
.77295 .31626 Mdot
.77301 .31626 Mdot
.77307 .31626 Mdot
.77313 .31385 Mdot
.77319 .31143 Mdot
.77325 .3066 Mdot
.77331 .29936 Mdot
.77337 .2897 Mdot
.77343 .28488 Mdot
.77349 .28488 Mdot
.77355 .28488 Mdot
.77361 .28488 Mdot
.77367 .28729 Mdot
.77373 .2897 Mdot
.77379 .29212 Mdot
.77385 .29695 Mdot
.77391 .30177 Mdot
.77397 .30902 Mdot
.77403 .31385 Mdot
.77409 .31626 Mdot
.77415 .31143 Mdot
.77421 .30902 Mdot
.77427 .3066 Mdot
.77433 .30902 Mdot
.77439 .31143 Mdot
.77445 .31385 Mdot
.77451 .31143 Mdot
.77457 .31143 Mdot
.77463 .31385 Mdot
.77469 .31385 Mdot
.77475 .31385 Mdot
.77481 .31143 Mdot
.77487 .31143 Mdot
.77493 .30902 Mdot
.77499 .3066 Mdot
.77505 .29936 Mdot
.77511 .29695 Mdot
.77517 .29695 Mdot
.77523 .29936 Mdot
.77529 .30419 Mdot
.77535 .3066 Mdot
.77541 .30902 Mdot
.77547 .31143 Mdot
.77553 .31626 Mdot
.77559 .32109 Mdot
.77565 .32592 Mdot
.77571 .32833 Mdot
.77577 .32833 Mdot
.77583 .3235 Mdot
.77589 .32109 Mdot
.77595 .31626 Mdot
.77601 .31626 Mdot
.77607 .31626 Mdot
.77613 .31626 Mdot
.77619 .31626 Mdot
.77625 .31867 Mdot
.77631 .31867 Mdot
.77637 .31867 Mdot
.77643 .31867 Mdot
.77649 .31867 Mdot
.77655 .31626 Mdot
.77661 .31143 Mdot
.77667 .30419 Mdot
.77673 .29453 Mdot
.77679 .28729 Mdot
.77685 .28488 Mdot
.77691 .28246 Mdot
.77697 .28246 Mdot
.77703 .28246 Mdot
.77709 .28488 Mdot
.77715 .28729 Mdot
.77721 .29453 Mdot
.77727 .29936 Mdot
.77733 .30419 Mdot
.77739 .30902 Mdot
.77745 .31143 Mdot
.77751 .31143 Mdot
.77757 .31143 Mdot
.77763 .30902 Mdot
.77769 .30902 Mdot
.77775 .31143 Mdot
.77781 .31385 Mdot
.77787 .31385 Mdot
.77793 .31385 Mdot
.77799 .31143 Mdot
.77805 .31385 Mdot
.77811 .31626 Mdot
.77817 .31385 Mdot
.77823 .31143 Mdot
.77829 .30902 Mdot
.77835 .30419 Mdot
.77841 .29936 Mdot
.77847 .29695 Mdot
.77853 .29453 Mdot
.77859 .29453 Mdot
.77865 .29936 Mdot
.77871 .30419 Mdot
.77877 .30902 Mdot
.77883 .31385 Mdot
.77889 .31867 Mdot
.77895 .3235 Mdot
.77901 .32833 Mdot
.77907 .33074 Mdot
.77913 .33074 Mdot
.77919 .32833 Mdot
.77925 .3235 Mdot
.77931 .31867 Mdot
.77937 .31626 Mdot
.77943 .31626 Mdot
.77949 .31626 Mdot
.77955 .31626 Mdot
.77961 .31385 Mdot
.77967 .31626 Mdot
.77973 .31867 Mdot
.77979 .31867 Mdot
.77985 .31867 Mdot
.77991 .31626 Mdot
.77997 .31143 Mdot
.78003 .3066 Mdot
.78009 .29936 Mdot
.78015 .29212 Mdot
.78021 .28729 Mdot
.78027 .28729 Mdot
.78033 .28488 Mdot
.78039 .28488 Mdot
.78045 .28488 Mdot
.78051 .2897 Mdot
.78057 .29453 Mdot
.78063 .30177 Mdot
.78069 .30419 Mdot
.78075 .30902 Mdot
.78081 .31143 Mdot
.78087 .31143 Mdot
.78093 .30902 Mdot
.78099 .30902 Mdot
.78105 .30902 Mdot
.78111 .31143 Mdot
.78117 .31143 Mdot
.78123 .31143 Mdot
.78129 .31143 Mdot
.78135 .31143 Mdot
.78141 .31385 Mdot
.78147 .31143 Mdot
.78153 .31385 Mdot
.78159 .31143 Mdot
.78165 .30902 Mdot
.78171 .30419 Mdot
.78177 .29695 Mdot
.78183 .29453 Mdot
.78189 .29212 Mdot
.78195 .29212 Mdot
.78201 .29453 Mdot
.78207 .29695 Mdot
.78213 .29936 Mdot
.78219 .3066 Mdot
.78225 .31385 Mdot
.78231 .31867 Mdot
.78237 .32109 Mdot
.78243 .32592 Mdot
.78249 .32833 Mdot
.78255 .32833 Mdot
.78261 .32592 Mdot
.78267 .3235 Mdot
.78273 .32109 Mdot
.78279 .32109 Mdot
.78285 .32109 Mdot
.78291 .31867 Mdot
.78297 .31867 Mdot
.78303 .31626 Mdot
.78309 .31867 Mdot
.78315 .31867 Mdot
.78321 .31867 Mdot
.78327 .31626 Mdot
.78333 .31143 Mdot
.78339 .3066 Mdot
.78345 .30177 Mdot
.78351 .29695 Mdot
.78357 .2897 Mdot
.78363 .28729 Mdot
.78369 .28488 Mdot
.78375 .28729 Mdot
.78381 .2897 Mdot
.78387 .29212 Mdot
.78393 .29695 Mdot
.78399 .30177 Mdot
.78405 .30419 Mdot
.78411 .30902 Mdot
.78417 .31143 Mdot
.78423 .31385 Mdot
.78429 .31143 Mdot
.78435 .30902 Mdot
.78441 .3066 Mdot
.78447 .3066 Mdot
.78453 .30902 Mdot
.78459 .30902 Mdot
.78465 .30902 Mdot
.78471 .31143 Mdot
.78477 .31385 Mdot
.78483 .31385 Mdot
.78489 .31143 Mdot
.78495 .31143 Mdot
.78501 .30902 Mdot
.78507 .3066 Mdot
.78513 .30177 Mdot
.78519 .29695 Mdot
.78525 .29212 Mdot
.78531 .29212 Mdot
.78537 .29453 Mdot
.78543 .29695 Mdot
.78549 .29936 Mdot
.78555 .30177 Mdot
.78561 .30902 Mdot
.78567 .31385 Mdot
.78573 .31867 Mdot
.78579 .3235 Mdot
.78585 .32592 Mdot
.78591 .32592 Mdot
.78597 .32833 Mdot
.78603 .32592 Mdot
.78609 .32109 Mdot
.78615 .31867 Mdot
.78621 .31867 Mdot
.78627 .32109 Mdot
.78633 .32109 Mdot
.78639 .32109 Mdot
.78645 .32109 Mdot
.78651 .32109 Mdot
.78657 .32109 Mdot
.78663 .31867 Mdot
.78669 .31385 Mdot
.78675 .30902 Mdot
.78681 .30177 Mdot
.78687 .29453 Mdot
.78693 .2897 Mdot
.78699 .28729 Mdot
.78705 .28729 Mdot
.78711 .28729 Mdot
.78717 .28729 Mdot
.78723 .2897 Mdot
.78729 .29695 Mdot
.78735 .29936 Mdot
.78741 .30419 Mdot
.78747 .3066 Mdot
.78753 .31143 Mdot
.78759 .31385 Mdot
.78765 .31626 Mdot
.78771 .31385 Mdot
.78777 .31143 Mdot
.78783 .30902 Mdot
.78789 .31143 Mdot
.78795 .31143 Mdot
.78801 .30902 Mdot
.78807 .30902 Mdot
.78813 .30902 Mdot
.78819 .31143 Mdot
.78825 .30902 Mdot
.78831 .30902 Mdot
.78837 .3066 Mdot
.78843 .30419 Mdot
.78849 .30177 Mdot
.78855 .29695 Mdot
.78861 .29212 Mdot
.78867 .2897 Mdot
.78873 .29212 Mdot
.78879 .29695 Mdot
.78885 .30177 Mdot
.78891 .30419 Mdot
.78897 .30902 Mdot
.78903 .31385 Mdot
.78909 .31867 Mdot
.78915 .3235 Mdot
.78921 .32592 Mdot
.78927 .32592 Mdot
.78933 .32592 Mdot
.78939 .32592 Mdot
.78945 .3235 Mdot
.78951 .31867 Mdot
.78957 .31867 Mdot
.78963 .31867 Mdot
.78969 .31867 Mdot
.78975 .31867 Mdot
.78981 .32109 Mdot
.78987 .32109 Mdot
.78993 .31867 Mdot
.78999 .31626 Mdot
.79005 .31626 Mdot
.79011 .31385 Mdot
.79017 .3066 Mdot
.79023 .29936 Mdot
.79029 .29453 Mdot
.79035 .2897 Mdot
.79041 .2897 Mdot
.79047 .2897 Mdot
.79053 .2897 Mdot
.79059 .2897 Mdot
.79065 .29453 Mdot
.79071 .29695 Mdot
.79077 .30177 Mdot
.79083 .30419 Mdot
.79089 .30902 Mdot
.79095 .31143 Mdot
.79101 .31385 Mdot
.79107 .31385 Mdot
.79113 .31143 Mdot
.79119 .30902 Mdot
.79125 .30902 Mdot
.79131 .31385 Mdot
.79137 .31385 Mdot
.79143 .31385 Mdot
.79149 .31385 Mdot
.79155 .31385 Mdot
.79161 .31385 Mdot
.79167 .31385 Mdot
.79173 .31143 Mdot
.79179 .3066 Mdot
.79185 .29936 Mdot
.79191 .29453 Mdot
.79197 .2897 Mdot
.79203 .28729 Mdot
.79209 .28729 Mdot
.79215 .2897 Mdot
.79221 .29453 Mdot
.79227 .29936 Mdot
.79233 .3066 Mdot
.79239 .31143 Mdot
.79245 .31626 Mdot
.79251 .32109 Mdot
.79256 .32833 Mdot
.79262 .33074 Mdot
.79268 .33074 Mdot
.79274 .32833 Mdot
.7928 .3235 Mdot
.79286 .3235 Mdot
.79292 .32592 Mdot
.79298 .32592 Mdot
.79304 .3235 Mdot
.7931 .32109 Mdot
.79316 .31867 Mdot
.79322 .31867 Mdot
.79328 .31867 Mdot
.79334 .31385 Mdot
.7934 .31143 Mdot
.79346 .30902 Mdot
.79352 .30419 Mdot
.79358 .29936 Mdot
.79364 .29212 Mdot
.7937 .28729 Mdot
.79376 .28488 Mdot
.79382 .28729 Mdot
.79388 .29212 Mdot
.79394 .29453 Mdot
.794 .29453 Mdot
.79406 .29936 Mdot
.79412 .30419 Mdot
.79418 .30902 Mdot
.79424 .31385 Mdot
.7943 .31385 Mdot
.79436 .31385 Mdot
.79442 .31143 Mdot
.79448 .31143 Mdot
.79454 .30902 Mdot
.7946 .30902 Mdot
.79466 .30902 Mdot
.79472 .31143 Mdot
.79478 .31143 Mdot
.79484 .31385 Mdot
.7949 .31385 Mdot
.79496 .31385 Mdot
.79502 .31385 Mdot
.79508 .31143 Mdot
.79514 .30902 Mdot
.7952 .3066 Mdot
.79526 .29936 Mdot
.79532 .29212 Mdot
.79538 .2897 Mdot
.79544 .2897 Mdot
.7955 .29212 Mdot
.79556 .29453 Mdot
.79562 .29695 Mdot
.79568 .30177 Mdot
.79574 .30902 Mdot
.7958 .31626 Mdot
.79586 .31867 Mdot
.79592 .3235 Mdot
.79598 .32592 Mdot
.79604 .32833 Mdot
.7961 .32833 Mdot
.79616 .32592 Mdot
.79622 .3235 Mdot
.79628 .32109 Mdot
.79634 .3235 Mdot
.7964 .32592 Mdot
.79646 .32592 Mdot
.79652 .3235 Mdot
.79658 .32109 Mdot
.79664 .31867 Mdot
.7967 .31867 Mdot
.79676 .31626 Mdot
.79682 .31143 Mdot
.79688 .30419 Mdot
.79694 .29695 Mdot
.797 .2897 Mdot
.79706 .28488 Mdot
.79712 .28246 Mdot
.79718 .28246 Mdot
.79724 .28488 Mdot
.7973 .28729 Mdot
.79736 .29453 Mdot
.79742 .29936 Mdot
.79748 .30419 Mdot
.79754 .30902 Mdot
.7976 .31385 Mdot
.79766 .31626 Mdot
.79772 .31867 Mdot
.79778 .31626 Mdot
.79784 .31385 Mdot
.7979 .31385 Mdot
.79796 .31143 Mdot
.79802 .31385 Mdot
.79808 .31385 Mdot
.79814 .31385 Mdot
.7982 .31143 Mdot
.79826 .31385 Mdot
.79832 .31385 Mdot
.79838 .31143 Mdot
.79844 .3066 Mdot
.7985 .30419 Mdot
.79856 .29936 Mdot
.79862 .29695 Mdot
.79868 .29453 Mdot
.79874 .28729 Mdot
.7988 .28488 Mdot
.79886 .2897 Mdot
.79892 .29453 Mdot
.79898 .30177 Mdot
.79904 .3066 Mdot
.7991 .31143 Mdot
.79916 .31867 Mdot
.79922 .3235 Mdot
.79928 .32833 Mdot
.79934 .33074 Mdot
.7994 .33074 Mdot
.79946 .32833 Mdot
.79952 .32592 Mdot
.79958 .3235 Mdot
.79964 .32109 Mdot
.7997 .31867 Mdot
.79976 .31867 Mdot
.79982 .31867 Mdot
.79988 .31867 Mdot
.79994 .31867 Mdot
.8 .31626 Mdot
.80006 .31626 Mdot
.80012 .31626 Mdot
.80018 .31626 Mdot
.80024 .31143 Mdot
.8003 .30419 Mdot
.80036 .29695 Mdot
.80042 .2897 Mdot
.80048 .28729 Mdot
.80054 .28729 Mdot
.8006 .28729 Mdot
.80066 .28729 Mdot
.80072 .28729 Mdot
.80078 .29212 Mdot
.80084 .29936 Mdot
.8009 .30177 Mdot
.80096 .30419 Mdot
.80102 .3066 Mdot
.80108 .31143 Mdot
.80114 .31626 Mdot
.8012 .31385 Mdot
.80126 .31143 Mdot
.80132 .30902 Mdot
.80138 .31143 Mdot
.80144 .31626 Mdot
.8015 .31867 Mdot
.80156 .31867 Mdot
.80162 .31626 Mdot
.80168 .31626 Mdot
.80174 .31626 Mdot
.8018 .31385 Mdot
.80186 .30902 Mdot
.80192 .30419 Mdot
.80198 .29695 Mdot
.80204 .29212 Mdot
.8021 .28488 Mdot
.80216 .28246 Mdot
.80222 .28246 Mdot
.80228 .28729 Mdot
.80234 .29212 Mdot
.8024 .29936 Mdot
.80246 .3066 Mdot
.80252 .31385 Mdot
.80258 .32109 Mdot
.80264 .32592 Mdot
.8027 .33316 Mdot
.80276 .33557 Mdot
.80282 .33557 Mdot
.80288 .33316 Mdot
.80294 .32833 Mdot
.803 .32592 Mdot
.80306 .3235 Mdot
.80312 .3235 Mdot
.80318 .32109 Mdot
.80324 .31867 Mdot
.8033 .31867 Mdot
.80336 .31867 Mdot
.80342 .31626 Mdot
.80348 .31385 Mdot
.80354 .30902 Mdot
.8036 .3066 Mdot
.80366 .30419 Mdot
.80372 .29695 Mdot
.80378 .2897 Mdot
.80384 .28488 Mdot
.8039 .28246 Mdot
.80396 .28729 Mdot
.80402 .29212 Mdot
.80408 .29453 Mdot
.80414 .29695 Mdot
.8042 .30177 Mdot
.80426 .30419 Mdot
.80432 .30902 Mdot
.80438 .31143 Mdot
.80444 .31143 Mdot
.8045 .31143 Mdot
.80456 .30902 Mdot
.80462 .3066 Mdot
.80468 .3066 Mdot
.80474 .3066 Mdot
.8048 .3066 Mdot
.80486 .30902 Mdot
.80492 .31143 Mdot
.80498 .31385 Mdot
.80504 .31626 Mdot
.8051 .31626 Mdot
.80516 .31385 Mdot
.80522 .31385 Mdot
.80528 .31143 Mdot
.80534 .3066 Mdot
.8054 .29936 Mdot
.80546 .29212 Mdot
.80552 .28729 Mdot
.80558 .28729 Mdot
.80564 .2897 Mdot
.8057 .29453 Mdot
.80576 .29695 Mdot
.80582 .30419 Mdot
.80588 .30902 Mdot
.80594 .31626 Mdot
.806 .32109 Mdot
.80606 .3235 Mdot
.80612 .32833 Mdot
.80618 .33074 Mdot
.80624 .33074 Mdot
.8063 .32833 Mdot
.80636 .32592 Mdot
.80642 .3235 Mdot
.80648 .32592 Mdot
.80654 .32592 Mdot
.8066 .32592 Mdot
.80666 .3235 Mdot
.80672 .3235 Mdot
.80678 .3235 Mdot
.80684 .31867 Mdot
.8069 .31626 Mdot
.80696 .31143 Mdot
.80702 .3066 Mdot
.80708 .29936 Mdot
.80714 .29212 Mdot
.8072 .28729 Mdot
.80726 .28246 Mdot
.80732 .28246 Mdot
.80738 .28488 Mdot
.80744 .28729 Mdot
.8075 .29212 Mdot
.80756 .29695 Mdot
.80762 .29936 Mdot
.80768 .30419 Mdot
.80774 .31143 Mdot
.8078 .31626 Mdot
.80786 .31867 Mdot
.80792 .31626 Mdot
.80798 .31385 Mdot
.80804 .31143 Mdot
.8081 .31143 Mdot
.80816 .31385 Mdot
.80822 .31385 Mdot
.80828 .31143 Mdot
.80834 .30902 Mdot
.8084 .30902 Mdot
.80846 .3066 Mdot
.80852 .3066 Mdot
.80858 .30419 Mdot
.80864 .30419 Mdot
.8087 .30177 Mdot
.80876 .29695 Mdot
.80882 .29212 Mdot
.80888 .28488 Mdot
.80894 .28488 Mdot
.809 .28729 Mdot
.80906 .29212 Mdot
.80912 .29695 Mdot
.80918 .30177 Mdot
.80924 .3066 Mdot
.8093 .31385 Mdot
.80936 .32109 Mdot
.80942 .32833 Mdot
.80948 .33074 Mdot
.80954 .33074 Mdot
.8096 .32833 Mdot
.80966 .32592 Mdot
.80972 .3235 Mdot
.80978 .32109 Mdot
.80984 .32109 Mdot
.8099 .32109 Mdot
.80996 .32109 Mdot
.81002 .32109 Mdot
.81008 .32109 Mdot
.81014 .32109 Mdot
.8102 .31867 Mdot
.81026 .31867 Mdot
.81032 .31867 Mdot
.81038 .31626 Mdot
.81044 .30902 Mdot
.8105 .30177 Mdot
.81056 .29453 Mdot
.81062 .2897 Mdot
.81068 .28729 Mdot
.81074 .2897 Mdot
.8108 .2897 Mdot
.81086 .29212 Mdot
.81092 .29453 Mdot
.81098 .29695 Mdot
.81104 .30177 Mdot
.8111 .3066 Mdot
.81116 .30902 Mdot
.81122 .31385 Mdot
.81128 .31626 Mdot
.81134 .31385 Mdot
.8114 .31143 Mdot
.81146 .30902 Mdot
.81152 .31143 Mdot
.81158 .31385 Mdot
.81164 .31626 Mdot
.8117 .31626 Mdot
.81176 .31626 Mdot
.81182 .31385 Mdot
.81188 .31143 Mdot
.81194 .30902 Mdot
.812 .3066 Mdot
.81206 .30177 Mdot
.81212 .29695 Mdot
.81218 .2897 Mdot
.81224 .28246 Mdot
.8123 .27763 Mdot
.81236 .28005 Mdot
.81242 .28488 Mdot
.81248 .2897 Mdot
.81254 .29695 Mdot
.8126 .30419 Mdot
.81266 .30902 Mdot
.81272 .31626 Mdot
.81278 .3235 Mdot
.81284 .33074 Mdot
.8129 .33557 Mdot
.81296 .33799 Mdot
.81302 .33557 Mdot
.81308 .33074 Mdot
.81314 .32592 Mdot
.8132 .32592 Mdot
.81326 .32592 Mdot
.81332 .3235 Mdot
.81338 .32109 Mdot
.81344 .32109 Mdot
.8135 .31867 Mdot
.81356 .31626 Mdot
.81362 .31385 Mdot
.81368 .31385 Mdot
.81374 .31143 Mdot
.8138 .3066 Mdot
.81386 .29936 Mdot
.81392 .29212 Mdot
.81398 .28729 Mdot
.81404 .28729 Mdot
.8141 .29212 Mdot
.81416 .29453 Mdot
.81422 .29695 Mdot
.81428 .29936 Mdot
.81434 .30177 Mdot
.8144 .3066 Mdot
.81446 .30902 Mdot
.81452 .31385 Mdot
.81458 .31626 Mdot
.81464 .31626 Mdot
.8147 .31385 Mdot
.81476 .30902 Mdot
.81482 .3066 Mdot
.81488 .3066 Mdot
.81494 .3066 Mdot
.815 .30902 Mdot
.81506 .30902 Mdot
.81512 .30902 Mdot
.81518 .31143 Mdot
.81524 .31143 Mdot
.8153 .30902 Mdot
.81536 .3066 Mdot
.81542 .3066 Mdot
.81548 .30177 Mdot
.81554 .29453 Mdot
.8156 .2897 Mdot
.81566 .28488 Mdot
.81572 .28729 Mdot
.81578 .2897 Mdot
.81584 .29212 Mdot
.8159 .29695 Mdot
.81596 .30177 Mdot
.81602 .3066 Mdot
.81608 .31143 Mdot
.81614 .31626 Mdot
.8162 .32109 Mdot
.81626 .32833 Mdot
.81632 .33074 Mdot
.81638 .33074 Mdot
.81644 .32833 Mdot
.8165 .32592 Mdot
.81656 .32592 Mdot
.81662 .32833 Mdot
.81668 .33074 Mdot
.81674 .32833 Mdot
.8168 .32592 Mdot
.81686 .3235 Mdot
.81692 .3235 Mdot
.81698 .32109 Mdot
.81704 .31867 Mdot
.8171 .31385 Mdot
.81716 .30902 Mdot
.81722 .30177 Mdot
.81728 .29453 Mdot
.81734 .28729 Mdot
.8174 .28246 Mdot
.81746 .28246 Mdot
.81752 .28488 Mdot
.81758 .2897 Mdot
.81764 .29212 Mdot
.8177 .29695 Mdot
.81776 .29936 Mdot
.81782 .30419 Mdot
.81788 .31143 Mdot
.81794 .31867 Mdot
.818 .31867 Mdot
.81806 .31867 Mdot
.81812 .31385 Mdot
.81818 .31143 Mdot
.81824 .31385 Mdot
.8183 .31385 Mdot
.81836 .31385 Mdot
.81842 .31385 Mdot
.81848 .31143 Mdot
.81854 .31143 Mdot
.8186 .3066 Mdot
.81866 .30419 Mdot
.81872 .30177 Mdot
.81878 .29936 Mdot
.81884 .29936 Mdot
.8189 .29212 Mdot
.81896 .28488 Mdot
.81902 .28246 Mdot
.81908 .28246 Mdot
.81914 .28729 Mdot
.8192 .29212 Mdot
.81926 .29695 Mdot
.81932 .29936 Mdot
.81938 .3066 Mdot
.81944 .31385 Mdot
.8195 .32109 Mdot
.81956 .32833 Mdot
.81962 .33074 Mdot
.81968 .33074 Mdot
.81974 .33074 Mdot
.8198 .32833 Mdot
.81986 .32833 Mdot
.81992 .32592 Mdot
.81998 .32592 Mdot
.82004 .32592 Mdot
.8201 .32592 Mdot
.82016 .32592 Mdot
.82022 .3235 Mdot
.82028 .31867 Mdot
.82034 .31626 Mdot
.8204 .31626 Mdot
.82046 .31385 Mdot
.82052 .30902 Mdot
.82058 .30177 Mdot
.82064 .29695 Mdot
.8207 .29212 Mdot
.82076 .2897 Mdot
.82082 .2897 Mdot
.82088 .29212 Mdot
.82094 .29212 Mdot
.821 .29212 Mdot
.82106 .29695 Mdot
.82112 .29936 Mdot
.82118 .30419 Mdot
.82124 .3066 Mdot
.8213 .31143 Mdot
.82136 .31626 Mdot
.82142 .31626 Mdot
.82148 .31143 Mdot
.82154 .30902 Mdot
.8216 .30902 Mdot
.82166 .31143 Mdot
.82172 .31626 Mdot
.82178 .31626 Mdot
.82184 .31143 Mdot
.8219 .30902 Mdot
.82196 .30902 Mdot
.82202 .30902 Mdot
.82208 .30902 Mdot
.82214 .3066 Mdot
.8222 .29936 Mdot
.82226 .29212 Mdot
.82232 .28729 Mdot
.82238 .28488 Mdot
.82244 .28005 Mdot
.8225 .28246 Mdot
.82256 .28729 Mdot
.82262 .29453 Mdot
.82268 .29936 Mdot
.82274 .30419 Mdot
.8228 .30902 Mdot
.82286 .31626 Mdot
.82292 .3235 Mdot
.82298 .33074 Mdot
.82304 .33316 Mdot
.8231 .33316 Mdot
.82316 .33074 Mdot
.82322 .33074 Mdot
.82328 .33074 Mdot
.82334 .33074 Mdot
.8234 .33074 Mdot
.82346 .32833 Mdot
.82352 .32592 Mdot
.82358 .3235 Mdot
.82364 .32109 Mdot
.8237 .31626 Mdot
.82376 .31385 Mdot
.82382 .31143 Mdot
.82388 .30902 Mdot
.82394 .30419 Mdot
.824 .29695 Mdot
.82406 .2897 Mdot
.82412 .28488 Mdot
.82418 .28729 Mdot
.82424 .29212 Mdot
.8243 .29695 Mdot
.82436 .29695 Mdot
.82442 .29695 Mdot
.82448 .29936 Mdot
.82454 .30419 Mdot
.8246 .31143 Mdot
.82466 .31385 Mdot
.82472 .31385 Mdot
.82478 .31385 Mdot
.82484 .31143 Mdot
.8249 .31143 Mdot
.82496 .30902 Mdot
.82502 .30902 Mdot
.82508 .31143 Mdot
.82514 .31143 Mdot
.8252 .31143 Mdot
.82526 .30902 Mdot
.82532 .3066 Mdot
.82538 .3066 Mdot
.82544 .30902 Mdot
.8255 .3066 Mdot
.82556 .30419 Mdot
.82562 .29695 Mdot
.82568 .2897 Mdot
.82574 .28488 Mdot
.8258 .28488 Mdot
.82586 .28488 Mdot
.82592 .28729 Mdot
.82598 .2897 Mdot
.82604 .29453 Mdot
.8261 .30177 Mdot
.82616 .3066 Mdot
.82622 .31385 Mdot
.82628 .31867 Mdot
.82634 .32592 Mdot
.8264 .33074 Mdot
.82646 .33316 Mdot
.82652 .33316 Mdot
.82658 .32833 Mdot
.82664 .32592 Mdot
.8267 .32833 Mdot
.82676 .33074 Mdot
.82682 .33074 Mdot
.82688 .32833 Mdot
.82694 .32592 Mdot
.827 .3235 Mdot
.82706 .32109 Mdot
.82712 .31867 Mdot
.82718 .31626 Mdot
.82724 .31143 Mdot
.8273 .30419 Mdot
.82736 .29936 Mdot
.82742 .29453 Mdot
.82748 .2897 Mdot
.82754 .28729 Mdot
.8276 .2897 Mdot
.82766 .29212 Mdot
.82772 .29453 Mdot
.82778 .29453 Mdot
.82784 .29695 Mdot
.8279 .30177 Mdot
.82796 .30902 Mdot
.82802 .31385 Mdot
.82808 .31626 Mdot
.82814 .31385 Mdot
.8282 .31143 Mdot
.82826 .30902 Mdot
.82832 .30902 Mdot
.82838 .30902 Mdot
.82844 .30902 Mdot
.8285 .31143 Mdot
.82856 .30902 Mdot
.82862 .30902 Mdot
.82868 .30902 Mdot
.82874 .30902 Mdot
.8288 .3066 Mdot
.82886 .30419 Mdot
.82892 .30177 Mdot
.82898 .29695 Mdot
.82904 .29212 Mdot
.8291 .28729 Mdot
.82916 .28246 Mdot
.82922 .28246 Mdot
.82928 .28729 Mdot
.82934 .29453 Mdot
.8294 .29695 Mdot
.82946 .30177 Mdot
.82952 .3066 Mdot
.82958 .31385 Mdot
.82964 .32109 Mdot
.8297 .32592 Mdot
.82976 .32833 Mdot
.82982 .33074 Mdot
.82988 .33074 Mdot
.82994 .32833 Mdot
.83 .32592 Mdot
.83006 .3235 Mdot
.83012 .32592 Mdot
.83018 .32833 Mdot
.83024 .32833 Mdot
.8303 .32833 Mdot
.83036 .32592 Mdot
.83042 .32109 Mdot
.83048 .32109 Mdot
.83054 .32109 Mdot
.8306 .31626 Mdot
.83066 .31143 Mdot
.83072 .30419 Mdot
.83078 .29453 Mdot
.83084 .29212 Mdot
.8309 .2897 Mdot
.83096 .29212 Mdot
.83102 .29212 Mdot
.83108 .29212 Mdot
.83114 .29453 Mdot
.8312 .29936 Mdot
.83126 .30419 Mdot
.83132 .3066 Mdot
.83138 .30902 Mdot
.83144 .31143 Mdot
.8315 .31385 Mdot
.83156 .31385 Mdot
.83162 .30902 Mdot
.83168 .3066 Mdot
.83174 .3066 Mdot
.8318 .30902 Mdot
.83186 .31143 Mdot
.83192 .30902 Mdot
.83198 .30902 Mdot
.83204 .30902 Mdot
.8321 .30902 Mdot
.83216 .30902 Mdot
.83222 .3066 Mdot
.83228 .30177 Mdot
.83234 .29695 Mdot
.8324 .29212 Mdot
.83246 .28729 Mdot
.83252 .28488 Mdot
.83258 .28246 Mdot
.83264 .28488 Mdot
.8327 .29212 Mdot
.83276 .29695 Mdot
.83282 .30177 Mdot
.83288 .3066 Mdot
.83294 .31143 Mdot
.833 .31626 Mdot
.83306 .3235 Mdot
.83312 .32833 Mdot
.83318 .33074 Mdot
.83324 .32833 Mdot
.8333 .32592 Mdot
.83336 .3235 Mdot
.83342 .32592 Mdot
.83348 .32833 Mdot
.83354 .32833 Mdot
.8336 .32592 Mdot
.83366 .32592 Mdot
.83372 .3235 Mdot
.83378 .3235 Mdot
.83384 .3235 Mdot
.8339 .31867 Mdot
.83396 .31385 Mdot
.83402 .31143 Mdot
.83408 .3066 Mdot
.83414 .29936 Mdot
.8342 .29212 Mdot
.83426 .2897 Mdot
.83432 .29212 Mdot
.83438 .29453 Mdot
.83444 .29695 Mdot
.8345 .29695 Mdot
.83456 .29936 Mdot
.83462 .30419 Mdot
.83468 .30902 Mdot
.83474 .31143 Mdot
.8348 .31143 Mdot
.83486 .31143 Mdot
.83492 .31143 Mdot
.83498 .30902 Mdot
.83504 .3066 Mdot
.8351 .30419 Mdot
.83516 .3066 Mdot
.83522 .31143 Mdot
.83528 .31385 Mdot
.83534 .31143 Mdot
.8354 .3066 Mdot
.83546 .3066 Mdot
.83552 .3066 Mdot
.83558 .3066 Mdot
.83564 .30419 Mdot
.8357 .29936 Mdot
.83576 .29453 Mdot
.83582 .28729 Mdot
.83588 .28246 Mdot
.83594 .28246 Mdot
.836 .28488 Mdot
.83606 .2897 Mdot
.83612 .29212 Mdot
.83618 .29695 Mdot
.83624 .30177 Mdot
.8363 .3066 Mdot
.83636 .31385 Mdot
.83642 .32109 Mdot
.83648 .3235 Mdot
.83654 .32592 Mdot
.8366 .32592 Mdot
.83666 .3235 Mdot
.83672 .3235 Mdot
.83678 .3235 Mdot
.83684 .32592 Mdot
.8369 .32833 Mdot
.83696 .32833 Mdot
.83702 .3235 Mdot
.83708 .3235 Mdot
.83714 .3235 Mdot
.8372 .32592 Mdot
.83726 .3235 Mdot
.83732 .31867 Mdot
.83738 .31385 Mdot
.83744 .30902 Mdot
.8375 .3066 Mdot
.83756 .29936 Mdot
.83762 .29695 Mdot
.83768 .29453 Mdot
.83774 .29695 Mdot
.8378 .29936 Mdot
.83786 .30177 Mdot
.83792 .30419 Mdot
.83798 .3066 Mdot
.83804 .30902 Mdot
.8381 .31143 Mdot
.83816 .31385 Mdot
.83822 .31385 Mdot
.83828 .31143 Mdot
.83834 .30902 Mdot
.8384 .3066 Mdot
.83846 .3066 Mdot
.83852 .30902 Mdot
.83858 .31143 Mdot
.83864 .30902 Mdot
.8387 .30902 Mdot
.83876 .30902 Mdot
.83882 .30902 Mdot
.83888 .30902 Mdot
.83894 .3066 Mdot
.839 .30419 Mdot
.83906 .29936 Mdot
.83912 .29453 Mdot
.83918 .2897 Mdot
.83924 .28488 Mdot
.8393 .28246 Mdot
.83936 .28488 Mdot
.83942 .28729 Mdot
.83948 .2897 Mdot
.83954 .29212 Mdot
.8396 .29695 Mdot
.83966 .30419 Mdot
.83972 .31385 Mdot
.83978 .31867 Mdot
.83984 .32109 Mdot
.8399 .32109 Mdot
.83996 .3235 Mdot
.84002 .3235 Mdot
.84008 .3235 Mdot
.84014 .3235 Mdot
.8402 .3235 Mdot
.84026 .32592 Mdot
.84032 .32592 Mdot
.84038 .32592 Mdot
.84044 .3235 Mdot
.8405 .3235 Mdot
.84056 .3235 Mdot
.84062 .3235 Mdot
.84068 .32109 Mdot
.84074 .31626 Mdot
.8408 .30902 Mdot
.84086 .30419 Mdot
.84092 .30177 Mdot
.84098 .29936 Mdot
.84104 .29936 Mdot
.8411 .29936 Mdot
.84116 .30177 Mdot
.84122 .30177 Mdot
.84128 .30177 Mdot
.84134 .3066 Mdot
.8414 .30902 Mdot
.84146 .31143 Mdot
.84152 .31385 Mdot
.84158 .31143 Mdot
.84164 .31143 Mdot
.8417 .30902 Mdot
.84176 .3066 Mdot
.84182 .3066 Mdot
.84188 .30902 Mdot
.84194 .31143 Mdot
.842 .30902 Mdot
.84206 .3066 Mdot
.84212 .3066 Mdot
.84218 .3066 Mdot
.84224 .30902 Mdot
.8423 .30902 Mdot
.84236 .30419 Mdot
.84242 .30177 Mdot
.84248 .29695 Mdot
.84254 .29453 Mdot
.8426 .2897 Mdot
.84266 .28488 Mdot
.84272 .28488 Mdot
.84278 .2897 Mdot
.84284 .29212 Mdot
.8429 .29212 Mdot
.84296 .29695 Mdot
.84302 .30177 Mdot
.84308 .30902 Mdot
.84314 .31385 Mdot
.8432 .31626 Mdot
.84326 .31867 Mdot
.84332 .32109 Mdot
.84338 .32109 Mdot
.84344 .3235 Mdot
.8435 .3235 Mdot
.84356 .32592 Mdot
.84362 .32592 Mdot
.84368 .32833 Mdot
.84374 .32592 Mdot
.8438 .32592 Mdot
.84386 .32592 Mdot
.84392 .32592 Mdot
.84398 .3235 Mdot
.84404 .32109 Mdot
.8441 .31626 Mdot
.84416 .31143 Mdot
.84422 .30902 Mdot
.84428 .30419 Mdot
.84434 .29936 Mdot
.8444 .29936 Mdot
.84446 .29936 Mdot
.84452 .29936 Mdot
.84458 .29936 Mdot
.84464 .29936 Mdot
.8447 .30177 Mdot
.84476 .30902 Mdot
.84482 .31143 Mdot
.84488 .31385 Mdot
.84494 .31143 Mdot
.845 .31143 Mdot
.84506 .31143 Mdot
.84512 .31143 Mdot
.84518 .30902 Mdot
.84524 .30902 Mdot
.8453 .30902 Mdot
.84536 .30902 Mdot
.84542 .30902 Mdot
.84548 .3066 Mdot
.84554 .3066 Mdot
.8456 .3066 Mdot
.84566 .3066 Mdot
.84572 .30419 Mdot
.84577 .29936 Mdot
.84583 .29453 Mdot
.84589 .29212 Mdot
.84595 .28729 Mdot
.84601 .28488 Mdot
.84607 .28729 Mdot
.84613 .2897 Mdot
.84619 .29212 Mdot
.84625 .29695 Mdot
.84631 .29936 Mdot
.84637 .30419 Mdot
.84643 .30902 Mdot
.84649 .31385 Mdot
.84655 .31626 Mdot
.84661 .31867 Mdot
.84667 .31867 Mdot
.84673 .32109 Mdot
.84679 .32109 Mdot
.84685 .31867 Mdot
.84691 .32109 Mdot
.84697 .32592 Mdot
.84703 .32592 Mdot
.84709 .32592 Mdot
.84715 .3235 Mdot
.84721 .3235 Mdot
.84727 .32592 Mdot
.84733 .32592 Mdot
.84739 .3235 Mdot
.84745 .31867 Mdot
.84751 .31143 Mdot
.84757 .30902 Mdot
.84763 .30419 Mdot
.84769 .30177 Mdot
.84775 .29936 Mdot
.84781 .30177 Mdot
.84787 .30177 Mdot
.84793 .30177 Mdot
.84799 .30177 Mdot
.84805 .30419 Mdot
.84811 .30902 Mdot
.84817 .31143 Mdot
.84823 .31143 Mdot
.84829 .30902 Mdot
.84835 .3066 Mdot
.84841 .30419 Mdot
.84847 .30419 Mdot
.84853 .30419 Mdot
.84859 .3066 Mdot
.84865 .30902 Mdot
.84871 .31143 Mdot
.84877 .31143 Mdot
.84883 .30902 Mdot
.84889 .30902 Mdot
.84895 .30902 Mdot
.84901 .30902 Mdot
.84907 .3066 Mdot
.84913 .30177 Mdot
.84919 .29695 Mdot
.84925 .29212 Mdot
.84931 .28729 Mdot
.84937 .28488 Mdot
.84943 .28488 Mdot
.84949 .2897 Mdot
.84955 .29212 Mdot
.84961 .29453 Mdot
.84967 .29453 Mdot
.84973 .29936 Mdot
.84979 .3066 Mdot
.84985 .31385 Mdot
.84991 .31867 Mdot
.84997 .31867 Mdot
.85003 .31867 Mdot
.85009 .31867 Mdot
.85015 .32109 Mdot
.85021 .3235 Mdot
.85027 .3235 Mdot
.85033 .32592 Mdot
.85039 .32833 Mdot
.85045 .32833 Mdot
.85051 .32592 Mdot
.85057 .3235 Mdot
.85063 .3235 Mdot
.85069 .3235 Mdot
.85075 .3235 Mdot
.85081 .31867 Mdot
.85087 .31143 Mdot
.85093 .3066 Mdot
.85099 .30419 Mdot
.85105 .30419 Mdot
.85111 .30419 Mdot
.85117 .30419 Mdot
.85123 .3066 Mdot
.85129 .30419 Mdot
.85135 .30419 Mdot
.85141 .30419 Mdot
.85147 .30902 Mdot
.85153 .31143 Mdot
.85159 .31143 Mdot
.85165 .30902 Mdot
.85171 .3066 Mdot
.85177 .3066 Mdot
.85183 .3066 Mdot
.85189 .30419 Mdot
.85195 .30419 Mdot
.85201 .3066 Mdot
.85207 .30902 Mdot
.85213 .30902 Mdot
.85219 .3066 Mdot
.85225 .3066 Mdot
.85231 .30902 Mdot
.85237 .31143 Mdot
.85243 .30902 Mdot
.85249 .30419 Mdot
.85255 .29936 Mdot
.85261 .29453 Mdot
.85267 .29212 Mdot
.85273 .2897 Mdot
.85279 .28729 Mdot
.85285 .28729 Mdot
.85291 .2897 Mdot
.85297 .29212 Mdot
.85303 .29453 Mdot
.85309 .29695 Mdot
.85315 .30419 Mdot
.85321 .30902 Mdot
.85327 .31385 Mdot
.85333 .31626 Mdot
.85339 .31626 Mdot
.85345 .31867 Mdot
.85351 .31867 Mdot
.85357 .32109 Mdot
.85363 .3235 Mdot
.85369 .32592 Mdot
.85375 .32592 Mdot
.85381 .32592 Mdot
.85387 .32592 Mdot
.85393 .32592 Mdot
.85399 .32833 Mdot
.85405 .32833 Mdot
.85411 .32592 Mdot
.85417 .32109 Mdot
.85423 .31626 Mdot
.85429 .31385 Mdot
.85435 .30902 Mdot
.85441 .30419 Mdot
.85447 .30177 Mdot
.85453 .30177 Mdot
.85459 .30177 Mdot
.85465 .30177 Mdot
.85471 .30177 Mdot
.85477 .30177 Mdot
.85483 .3066 Mdot
.85489 .31143 Mdot
.85495 .31385 Mdot
.85501 .30902 Mdot
.85507 .3066 Mdot
.85513 .3066 Mdot
.85519 .3066 Mdot
.85525 .3066 Mdot
.85531 .30419 Mdot
.85537 .30419 Mdot
.85543 .3066 Mdot
.85549 .3066 Mdot
.85555 .3066 Mdot
.85561 .3066 Mdot
.85567 .30902 Mdot
.85573 .30902 Mdot
.85579 .3066 Mdot
.85585 .30419 Mdot
.85591 .29695 Mdot
.85597 .29212 Mdot
.85603 .2897 Mdot
.85609 .28729 Mdot
.85615 .28729 Mdot
.85621 .28729 Mdot
.85627 .2897 Mdot
.85633 .29212 Mdot
.85639 .29453 Mdot
.85645 .29936 Mdot
.85651 .3066 Mdot
.85657 .31143 Mdot
.85663 .31385 Mdot
.85669 .31626 Mdot
.85675 .31867 Mdot
.85681 .31867 Mdot
.85687 .31867 Mdot
.85693 .31867 Mdot
.85699 .31867 Mdot
.85705 .31867 Mdot
.85711 .3235 Mdot
.85717 .3235 Mdot
.85723 .3235 Mdot
.85729 .3235 Mdot
.85735 .32592 Mdot
.85741 .32833 Mdot
.85747 .32833 Mdot
.85753 .32592 Mdot
.85759 .31867 Mdot
.85765 .31626 Mdot
.85771 .31385 Mdot
.85777 .30902 Mdot
.85783 .3066 Mdot
.85789 .30177 Mdot
.85795 .30177 Mdot
.85801 .30419 Mdot
.85807 .3066 Mdot
.85813 .30419 Mdot
.85819 .3066 Mdot
.85825 .30902 Mdot
.85831 .31143 Mdot
.85837 .30902 Mdot
.85843 .3066 Mdot
.85849 .30419 Mdot
.85855 .30419 Mdot
.85861 .30419 Mdot
.85867 .30419 Mdot
.85873 .30419 Mdot
.85879 .3066 Mdot
.85885 .3066 Mdot
.85891 .3066 Mdot
.85897 .3066 Mdot
.85903 .30902 Mdot
.85909 .31143 Mdot
.85915 .31143 Mdot
.85921 .3066 Mdot
.85927 .30177 Mdot
.85933 .29936 Mdot
.85939 .29453 Mdot
.85945 .2897 Mdot
.85951 .28729 Mdot
.85957 .28488 Mdot
.85963 .28729 Mdot
.85969 .2897 Mdot
.85975 .29212 Mdot
.85981 .29453 Mdot
.85987 .29936 Mdot
.85993 .30902 Mdot
.85999 .31385 Mdot
.86005 .31626 Mdot
.86011 .31385 Mdot
.86017 .31626 Mdot
.86023 .31867 Mdot
.86029 .32109 Mdot
.86035 .32109 Mdot
.86041 .31867 Mdot
.86047 .32109 Mdot
.86053 .32109 Mdot
.86059 .3235 Mdot
.86065 .3235 Mdot
.86071 .3235 Mdot
.86077 .3235 Mdot
.86083 .32592 Mdot
.86089 .3235 Mdot
.86095 .32109 Mdot
.86101 .31626 Mdot
.86107 .31385 Mdot
.86113 .30902 Mdot
.86119 .30902 Mdot
.86125 .3066 Mdot
.86131 .30419 Mdot
.86137 .30419 Mdot
.86143 .30419 Mdot
.86149 .3066 Mdot
.86155 .30902 Mdot
.86161 .31143 Mdot
.86167 .31385 Mdot
.86173 .31143 Mdot
.86179 .30902 Mdot
.86185 .3066 Mdot
.86191 .3066 Mdot
.86197 .3066 Mdot
.86203 .30419 Mdot
.86209 .30177 Mdot
.86215 .30177 Mdot
.86221 .30419 Mdot
.86227 .30419 Mdot
.86233 .30419 Mdot
.86239 .3066 Mdot
.86245 .31143 Mdot
.86251 .31143 Mdot
.86257 .30902 Mdot
.86263 .30177 Mdot
.86269 .29936 Mdot
.86275 .29695 Mdot
.86281 .29453 Mdot
.86287 .29212 Mdot
.86293 .28729 Mdot
.86299 .28729 Mdot
.86305 .2897 Mdot
.86311 .29212 Mdot
.86317 .29453 Mdot
.86323 .29695 Mdot
.86329 .30177 Mdot
.86335 .3066 Mdot
.86341 .30902 Mdot
.86347 .30902 Mdot
.86353 .31143 Mdot
.86359 .31143 Mdot
.86365 .31626 Mdot
.86371 .31867 Mdot
.86377 .31867 Mdot
.86383 .31867 Mdot
.86389 .31867 Mdot
.86395 .32109 Mdot
.86401 .32109 Mdot
.86407 .3235 Mdot
.86413 .32833 Mdot
.86419 .32833 Mdot
.86425 .32592 Mdot
.86431 .32109 Mdot
.86437 .31867 Mdot
.86443 .31626 Mdot
.86449 .31385 Mdot
.86455 .31143 Mdot
.86461 .3066 Mdot
.86467 .3066 Mdot
.86473 .3066 Mdot
.86479 .30419 Mdot
.86485 .3066 Mdot
.86491 .30902 Mdot
.86497 .31385 Mdot
.86503 .31626 Mdot
.86509 .31385 Mdot
.86515 .31143 Mdot
.86521 .30902 Mdot
.86527 .31143 Mdot
.86533 .31143 Mdot
.86539 .31143 Mdot
.86545 .3066 Mdot
.86551 .30419 Mdot
.86557 .3066 Mdot
.86563 .3066 Mdot
.86569 .3066 Mdot
.86575 .3066 Mdot
.86581 .3066 Mdot
.86587 .30902 Mdot
.86593 .3066 Mdot
.86599 .30419 Mdot
.86605 .29936 Mdot
.86611 .29453 Mdot
.86617 .29212 Mdot
.86623 .29212 Mdot
.86629 .2897 Mdot
.86635 .2897 Mdot
.86641 .28729 Mdot
.86647 .2897 Mdot
.86653 .29212 Mdot
.86659 .29936 Mdot
.86665 .30419 Mdot
.86671 .30902 Mdot
.86677 .30902 Mdot
.86683 .31143 Mdot
.86689 .31143 Mdot
.86695 .31143 Mdot
.86701 .31385 Mdot
.86707 .31385 Mdot
.86713 .31626 Mdot
.86719 .31626 Mdot
.86725 .31626 Mdot
.86731 .31626 Mdot
.86737 .31626 Mdot
.86743 .31867 Mdot
.86749 .3235 Mdot
.86755 .32592 Mdot
.86761 .3235 Mdot
.86767 .32109 Mdot
.86773 .31626 Mdot
.86779 .31626 Mdot
.86785 .31626 Mdot
.86791 .31385 Mdot
.86797 .30902 Mdot
.86803 .30419 Mdot
.86809 .30419 Mdot
.86815 .3066 Mdot
.86821 .30902 Mdot
.86827 .30902 Mdot
.86833 .31143 Mdot
.86839 .31385 Mdot
.86845 .31385 Mdot
.86851 .31385 Mdot
.86857 .30902 Mdot
.86863 .3066 Mdot
.86869 .3066 Mdot
.86875 .30902 Mdot
.86881 .30902 Mdot
.86887 .3066 Mdot
.86893 .30419 Mdot
.86899 .30419 Mdot
.86905 .3066 Mdot
.86911 .30902 Mdot
.86917 .31143 Mdot
.86923 .31143 Mdot
.86929 .30902 Mdot
.86935 .3066 Mdot
.86941 .30177 Mdot
.86947 .29936 Mdot
.86953 .29695 Mdot
.86959 .29212 Mdot
.86965 .2897 Mdot
.86971 .28729 Mdot
.86977 .28729 Mdot
.86983 .28729 Mdot
.86989 .2897 Mdot
.86995 .29453 Mdot
.87001 .29936 Mdot
.87007 .3066 Mdot
.87013 .30902 Mdot
.87019 .30902 Mdot
.87025 .30902 Mdot
.87031 .31143 Mdot
.87037 .31626 Mdot
.87043 .31867 Mdot
.87049 .31626 Mdot
.87055 .31626 Mdot
.87061 .31626 Mdot
.87067 .31867 Mdot
.87073 .32109 Mdot
.87079 .32109 Mdot
.87085 .32109 Mdot
.87091 .3235 Mdot
.87097 .3235 Mdot
.87103 .32109 Mdot
.87109 .31626 Mdot
.87115 .31385 Mdot
.87121 .31143 Mdot
.87127 .31143 Mdot
.87133 .30902 Mdot
.87139 .3066 Mdot
.87145 .30419 Mdot
.87151 .30419 Mdot
.87157 .3066 Mdot
.87163 .30902 Mdot
.87169 .31385 Mdot
.87175 .31385 Mdot
.87181 .31626 Mdot
.87187 .31385 Mdot
.87193 .31143 Mdot
.87199 .31143 Mdot
.87205 .31143 Mdot
.87211 .30902 Mdot
.87217 .3066 Mdot
.87223 .3066 Mdot
.87229 .30419 Mdot
.87235 .30419 Mdot
.87241 .30419 Mdot
.87247 .30419 Mdot
.87253 .3066 Mdot
.87259 .30902 Mdot
.87265 .30902 Mdot
.87271 .3066 Mdot
.87277 .30177 Mdot
.87283 .29936 Mdot
.87289 .29936 Mdot
.87295 .29936 Mdot
.87301 .29453 Mdot
.87307 .2897 Mdot
.87313 .2897 Mdot
.87319 .29212 Mdot
.87325 .29453 Mdot
.87331 .29453 Mdot
.87337 .29936 Mdot
.87343 .30419 Mdot
.87349 .3066 Mdot
.87355 .30902 Mdot
.87361 .3066 Mdot
.87367 .30902 Mdot
.87373 .31143 Mdot
.87379 .31626 Mdot
.87385 .31626 Mdot
.87391 .31626 Mdot
.87397 .31385 Mdot
.87403 .31626 Mdot
.87409 .31867 Mdot
.87415 .32109 Mdot
.87421 .3235 Mdot
.87427 .3235 Mdot
.87433 .3235 Mdot
.87439 .32109 Mdot
.87445 .31867 Mdot
.87451 .31867 Mdot
.87457 .31626 Mdot
.87463 .31385 Mdot
.87469 .30902 Mdot
.87475 .3066 Mdot
.87481 .30419 Mdot
.87487 .30419 Mdot
.87493 .30419 Mdot
.87499 .30902 Mdot
.87505 .31143 Mdot
.87511 .31626 Mdot
.87517 .31626 Mdot
.87523 .31385 Mdot
.87529 .31143 Mdot
.87535 .31143 Mdot
.87541 .31385 Mdot
.87547 .31385 Mdot
.87553 .31143 Mdot
.87559 .3066 Mdot
.87565 .30419 Mdot
.87571 .30419 Mdot
.87577 .30419 Mdot
.87583 .30419 Mdot
.87589 .3066 Mdot
.87595 .3066 Mdot
.87601 .3066 Mdot
.87607 .30419 Mdot
.87613 .29936 Mdot
.87619 .29695 Mdot
.87625 .29695 Mdot
.87631 .29695 Mdot
.87637 .29453 Mdot
.87643 .29212 Mdot
.87649 .2897 Mdot
.87655 .2897 Mdot
.87661 .29453 Mdot
.87667 .29936 Mdot
.87673 .30419 Mdot
.87679 .30902 Mdot
.87685 .30902 Mdot
.87691 .30902 Mdot
.87697 .31143 Mdot
.87703 .31143 Mdot
.87709 .31385 Mdot
.87715 .31385 Mdot
.87721 .31385 Mdot
.87727 .31385 Mdot
.87733 .31385 Mdot
.87739 .31385 Mdot
.87745 .31385 Mdot
.87751 .31626 Mdot
.87757 .32109 Mdot
.87763 .3235 Mdot
.87769 .32592 Mdot
.87775 .32109 Mdot
.87781 .31867 Mdot
.87787 .31867 Mdot
.87793 .31867 Mdot
.87799 .31867 Mdot
.87805 .31385 Mdot
.87811 .30902 Mdot
.87817 .3066 Mdot
.87823 .3066 Mdot
.87829 .3066 Mdot
.87835 .30902 Mdot
.87841 .31143 Mdot
.87847 .31143 Mdot
.87853 .31385 Mdot
.87859 .31143 Mdot
.87865 .30902 Mdot
.87871 .30902 Mdot
.87877 .30902 Mdot
.87883 .31143 Mdot
.87889 .31143 Mdot
.87895 .3066 Mdot
.87901 .30419 Mdot
.87907 .30419 Mdot
.87913 .30419 Mdot
.87919 .30902 Mdot
.87925 .30902 Mdot
.87931 .30902 Mdot
.87937 .3066 Mdot
.87943 .30419 Mdot
.87949 .29936 Mdot
.87955 .29936 Mdot
.87961 .29695 Mdot
.87967 .29453 Mdot
.87973 .29212 Mdot
.87979 .2897 Mdot
.87985 .28729 Mdot
.87991 .2897 Mdot
.87997 .29212 Mdot
.88003 .29453 Mdot
.88009 .30177 Mdot
.88015 .3066 Mdot
.88021 .31143 Mdot
.88027 .31143 Mdot
.88033 .31143 Mdot
.88039 .31143 Mdot
.88045 .31626 Mdot
.88051 .31867 Mdot
.88057 .31867 Mdot
.88063 .31385 Mdot
.88069 .31143 Mdot
.88075 .31385 Mdot
.88081 .31626 Mdot
.88087 .31867 Mdot
.88093 .31867 Mdot
.88099 .32109 Mdot
.88105 .32109 Mdot
.88111 .32109 Mdot
.88117 .31867 Mdot
.88123 .31626 Mdot
.88129 .31385 Mdot
.88135 .31626 Mdot
.88141 .31626 Mdot
.88147 .31143 Mdot
.88153 .3066 Mdot
.88159 .3066 Mdot
.88165 .3066 Mdot
.88171 .31143 Mdot
.88177 .31626 Mdot
.88183 .31626 Mdot
.88189 .31626 Mdot
.88195 .31143 Mdot
.88201 .30902 Mdot
.88207 .30902 Mdot
.88213 .31143 Mdot
.88219 .30902 Mdot
.88225 .30902 Mdot
.88231 .30419 Mdot
.88237 .30419 Mdot
.88243 .30419 Mdot
.88249 .30419 Mdot
.88255 .30419 Mdot
.88261 .3066 Mdot
.88267 .30902 Mdot
.88273 .30902 Mdot
.88279 .3066 Mdot
.88285 .30177 Mdot
.88291 .29936 Mdot
.88297 .29936 Mdot
.88303 .29936 Mdot
.88309 .29695 Mdot
.88315 .2897 Mdot
.88321 .28729 Mdot
.88327 .28729 Mdot
.88333 .29212 Mdot
.88339 .29695 Mdot
.88345 .29936 Mdot
.88351 .30419 Mdot
.88357 .3066 Mdot
.88363 .30902 Mdot
.88369 .31143 Mdot
.88375 .31143 Mdot
.88381 .31143 Mdot
.88387 .31385 Mdot
.88393 .31626 Mdot
.88399 .31626 Mdot
.88405 .31385 Mdot
.88411 .31385 Mdot
.88417 .31626 Mdot
.88423 .31867 Mdot
.88429 .32109 Mdot
.88435 .3235 Mdot
.88441 .32109 Mdot
.88447 .32109 Mdot
.88453 .31867 Mdot
.88459 .31626 Mdot
.88465 .31626 Mdot
.88471 .31626 Mdot
.88477 .31143 Mdot
.88483 .30902 Mdot
.88489 .30419 Mdot
.88495 .30419 Mdot
.88501 .3066 Mdot
.88507 .30902 Mdot
.88513 .31143 Mdot
.88519 .31626 Mdot
.88525 .31626 Mdot
.88531 .31626 Mdot
.88537 .31385 Mdot
.88543 .31143 Mdot
.88549 .31143 Mdot
.88555 .31385 Mdot
.88561 .31143 Mdot
.88567 .3066 Mdot
.88573 .30177 Mdot
.88579 .29936 Mdot
.88585 .30177 Mdot
.88591 .30419 Mdot
.88597 .3066 Mdot
.88603 .30419 Mdot
.88609 .30419 Mdot
.88615 .30419 Mdot
.88621 .30177 Mdot
.88627 .29936 Mdot
.88633 .29936 Mdot
.88639 .29936 Mdot
.88645 .29936 Mdot
.88651 .29453 Mdot
.88657 .2897 Mdot
.88663 .2897 Mdot
.88669 .29212 Mdot
.88675 .29695 Mdot
.88681 .30419 Mdot
.88687 .3066 Mdot
.88693 .3066 Mdot
.88699 .30902 Mdot
.88705 .30902 Mdot
.88711 .30902 Mdot
.88717 .31143 Mdot
.88723 .31385 Mdot
.88729 .31385 Mdot
.88735 .31143 Mdot
.88741 .30902 Mdot
.88747 .30902 Mdot
.88753 .31143 Mdot
.88759 .31626 Mdot
.88765 .31867 Mdot
.88771 .3235 Mdot
.88777 .32592 Mdot
.88783 .3235 Mdot
.88789 .32109 Mdot
.88795 .31867 Mdot
.88801 .31867 Mdot
.88807 .31867 Mdot
.88813 .31867 Mdot
.88819 .31143 Mdot
.88825 .30419 Mdot
.88831 .30419 Mdot
.88837 .3066 Mdot
.88843 .30902 Mdot
.88849 .31143 Mdot
.88855 .31143 Mdot
.88861 .31143 Mdot
.88867 .31385 Mdot
.88873 .31385 Mdot
.88879 .31143 Mdot
.88885 .30902 Mdot
.88891 .31143 Mdot
.88897 .31143 Mdot
.88903 .31143 Mdot
.88909 .30902 Mdot
.88915 .30419 Mdot
.88921 .30419 Mdot
.88927 .30902 Mdot
.88933 .30902 Mdot
.88939 .31143 Mdot
.88945 .30902 Mdot
.88951 .30419 Mdot
.88957 .30177 Mdot
.88963 .29936 Mdot
.88969 .29695 Mdot
.88975 .29695 Mdot
.88981 .29453 Mdot
.88987 .2897 Mdot
.88993 .28729 Mdot
.88999 .2897 Mdot
.89005 .29212 Mdot
.89011 .29695 Mdot
.89017 .30177 Mdot
.89023 .3066 Mdot
.89029 .31143 Mdot
.89035 .31143 Mdot
.89041 .31143 Mdot
.89047 .31143 Mdot
.89053 .31385 Mdot
.89059 .31385 Mdot
.89065 .31626 Mdot
.89071 .31143 Mdot
.89077 .3066 Mdot
.89083 .3066 Mdot
.89089 .31143 Mdot
.89095 .31385 Mdot
.89101 .31626 Mdot
.89107 .31867 Mdot
.89113 .31626 Mdot
.89119 .31867 Mdot
.89125 .31867 Mdot
.89131 .31867 Mdot
.89137 .31626 Mdot
.89143 .31626 Mdot
.89149 .31626 Mdot
.89155 .31385 Mdot
.89161 .31143 Mdot
.89167 .30902 Mdot
.89173 .30902 Mdot
.89179 .31143 Mdot
.89185 .31626 Mdot
.89191 .31626 Mdot
.89197 .31385 Mdot
.89203 .31143 Mdot
.89209 .31143 Mdot
.89215 .31143 Mdot
.89221 .31143 Mdot
.89227 .31143 Mdot
.89233 .31143 Mdot
.89239 .3066 Mdot
.89245 .30419 Mdot
.89251 .30419 Mdot
.89257 .3066 Mdot
.89263 .30902 Mdot
.89269 .31143 Mdot
.89275 .31143 Mdot
.89281 .31143 Mdot
.89287 .30902 Mdot
.89293 .3066 Mdot
.89299 .30177 Mdot
.89305 .29936 Mdot
.89311 .29936 Mdot
.89317 .29695 Mdot
.89323 .29453 Mdot
.89329 .2897 Mdot
.89335 .28488 Mdot
.89341 .2897 Mdot
.89347 .29453 Mdot
.89353 .29936 Mdot
.89359 .30177 Mdot
.89365 .30177 Mdot
.89371 .30419 Mdot
.89377 .3066 Mdot
.89383 .30902 Mdot
.89389 .30902 Mdot
.89395 .31143 Mdot
.89401 .31385 Mdot
.89407 .31385 Mdot
.89413 .31385 Mdot
.89419 .31143 Mdot
.89425 .31143 Mdot
.89431 .31385 Mdot
.89437 .31867 Mdot
.89443 .32109 Mdot
.89449 .31867 Mdot
.89455 .31867 Mdot
.89461 .31626 Mdot
.89467 .31626 Mdot
.89473 .31626 Mdot
.89479 .31626 Mdot
.89485 .31385 Mdot
.89491 .31143 Mdot
.89497 .3066 Mdot
.89503 .3066 Mdot
.89509 .3066 Mdot
.89515 .31143 Mdot
.89521 .31385 Mdot
.89527 .31626 Mdot
.89533 .31867 Mdot
.89539 .31867 Mdot
.89545 .31867 Mdot
.89551 .31626 Mdot
.89557 .31385 Mdot
.89563 .31385 Mdot
.89569 .31626 Mdot
.89575 .31143 Mdot
.89581 .3066 Mdot
.89587 .30177 Mdot
.89593 .30177 Mdot
.89599 .3066 Mdot
.89605 .30902 Mdot
.89611 .3066 Mdot
.89617 .3066 Mdot
.89623 .3066 Mdot
.89629 .30419 Mdot
.89635 .30419 Mdot
.89641 .30177 Mdot
.89647 .29936 Mdot
.89653 .29936 Mdot
.89659 .29695 Mdot
.89665 .29453 Mdot
.89671 .29212 Mdot
.89677 .29212 Mdot
.89683 .29453 Mdot
.89689 .29936 Mdot
.89695 .30419 Mdot
.89701 .30419 Mdot
.89707 .30419 Mdot
.89713 .30419 Mdot
.89719 .30419 Mdot
.89725 .3066 Mdot
.89731 .30902 Mdot
.89737 .30902 Mdot
.89743 .30902 Mdot
.89749 .3066 Mdot
.89755 .3066 Mdot
.89761 .31143 Mdot
.89767 .31385 Mdot
.89773 .31626 Mdot
.89779 .31867 Mdot
.89785 .32109 Mdot
.89791 .3235 Mdot
.89797 .32109 Mdot
.89803 .31867 Mdot
.89809 .31626 Mdot
.89815 .31626 Mdot
.89821 .31626 Mdot
.89827 .31385 Mdot
.89833 .30902 Mdot
.89839 .30419 Mdot
.89845 .30419 Mdot
.89851 .30902 Mdot
.89857 .31385 Mdot
.89863 .31385 Mdot
.89869 .31143 Mdot
.89875 .31385 Mdot
.89881 .31385 Mdot
.89887 .31626 Mdot
.89893 .31385 Mdot
.89898 .31385 Mdot
.89904 .31143 Mdot
.8991 .31385 Mdot
.89916 .30902 Mdot
.89922 .3066 Mdot
.89928 .30419 Mdot
.89934 .3066 Mdot
.8994 .30902 Mdot
.89946 .31143 Mdot
.89952 .30902 Mdot
.89958 .3066 Mdot
.89964 .30177 Mdot
.8997 .29936 Mdot
.89976 .29936 Mdot
.89982 .29936 Mdot
.89988 .29695 Mdot
.89994 .29453 Mdot
.9 .29212 Mdot
.90006 .29212 Mdot
.90012 .29212 Mdot
.90018 .29695 Mdot
.90024 .30177 Mdot
.9003 .30419 Mdot
.90036 .3066 Mdot
.90042 .30902 Mdot
.90048 .30902 Mdot
.90054 .30902 Mdot
.9006 .30902 Mdot
.90066 .30902 Mdot
.90072 .31143 Mdot
.90078 .31143 Mdot
.90084 .3066 Mdot
.9009 .30419 Mdot
.90096 .30419 Mdot
.90102 .30902 Mdot
.90108 .31385 Mdot
.90114 .31867 Mdot
.9012 .31626 Mdot
.90126 .31626 Mdot
.90132 .31626 Mdot
.90138 .31626 Mdot
.90144 .31626 Mdot
.9015 .31626 Mdot
.90156 .31626 Mdot
.90162 .31626 Mdot
.90168 .31385 Mdot
.90174 .31143 Mdot
.9018 .30902 Mdot
.90186 .31143 Mdot
.90192 .31385 Mdot
.90198 .31626 Mdot
.90204 .31626 Mdot
.9021 .31385 Mdot
.90216 .31143 Mdot
.90222 .31143 Mdot
.90228 .31143 Mdot
.90234 .30902 Mdot
.9024 .30902 Mdot
.90246 .3066 Mdot
.90252 .30419 Mdot
.90258 .30419 Mdot
.90264 .30419 Mdot
.9027 .3066 Mdot
.90276 .30902 Mdot
.90282 .31143 Mdot
.90288 .31143 Mdot
.90294 .31143 Mdot
.903 .30902 Mdot
.90306 .30419 Mdot
.90312 .30177 Mdot
.90318 .30177 Mdot
.90324 .30177 Mdot
.9033 .29936 Mdot
.90336 .29453 Mdot
.90342 .2897 Mdot
.90348 .2897 Mdot
.90354 .29453 Mdot
.9036 .29936 Mdot
.90366 .30177 Mdot
.90372 .30419 Mdot
.90378 .30419 Mdot
.90384 .3066 Mdot
.9039 .30902 Mdot
.90396 .30902 Mdot
.90402 .30902 Mdot
.90408 .30902 Mdot
.90414 .31143 Mdot
.9042 .31143 Mdot
.90426 .31143 Mdot
.90432 .30902 Mdot
.90438 .31143 Mdot
.90444 .31626 Mdot
.9045 .31867 Mdot
.90456 .31867 Mdot
.90462 .31867 Mdot
.90468 .31626 Mdot
.90474 .31385 Mdot
.9048 .31626 Mdot
.90486 .31385 Mdot
.90492 .31385 Mdot
.90498 .31143 Mdot
.90504 .30902 Mdot
.9051 .30902 Mdot
.90516 .30902 Mdot
.90522 .30902 Mdot
.90528 .31143 Mdot
.90534 .31626 Mdot
.9054 .31626 Mdot
.90546 .31626 Mdot
.90552 .31626 Mdot
.90558 .31385 Mdot
.90564 .31385 Mdot
.9057 .31385 Mdot
.90576 .31143 Mdot
.90582 .31143 Mdot
.90588 .30902 Mdot
.90594 .30419 Mdot
.906 .30177 Mdot
.90606 .30419 Mdot
.90612 .3066 Mdot
.90618 .30902 Mdot
.90624 .3066 Mdot
.9063 .3066 Mdot
.90636 .30419 Mdot
.90642 .30419 Mdot
.90648 .30177 Mdot
.90654 .30177 Mdot
.9066 .29936 Mdot
.90666 .30177 Mdot
.90672 .29936 Mdot
.90678 .29695 Mdot
.90684 .29453 Mdot
.9069 .29695 Mdot
.90696 .29936 Mdot
.90702 .30419 Mdot
.90708 .3066 Mdot
.90714 .30419 Mdot
.9072 .30419 Mdot
.90726 .30419 Mdot
.90732 .3066 Mdot
.90738 .30902 Mdot
.90744 .30902 Mdot
.9075 .30902 Mdot
.90756 .30902 Mdot
.90762 .30902 Mdot
.90768 .30902 Mdot
.90774 .31143 Mdot
.9078 .31385 Mdot
.90786 .31867 Mdot
.90792 .32109 Mdot
.90798 .31867 Mdot
.90804 .31867 Mdot
.9081 .31626 Mdot
.90816 .31626 Mdot
.90822 .31626 Mdot
.90828 .31626 Mdot
.90834 .31385 Mdot
.9084 .31143 Mdot
.90846 .30902 Mdot
.90852 .3066 Mdot
.90858 .3066 Mdot
.90864 .31143 Mdot
.9087 .31385 Mdot
.90876 .31385 Mdot
.90882 .31385 Mdot
.90888 .31143 Mdot
.90894 .31143 Mdot
.909 .31143 Mdot
.90906 .31143 Mdot
.90912 .31143 Mdot
.90918 .31143 Mdot
.90924 .31143 Mdot
.9093 .30902 Mdot
.90936 .30419 Mdot
.90942 .30419 Mdot
.90948 .3066 Mdot
.90954 .30902 Mdot
.9096 .30902 Mdot
.90966 .3066 Mdot
.90972 .30419 Mdot
.90978 .30177 Mdot
.90984 .30177 Mdot
.9099 .30177 Mdot
.90996 .30177 Mdot
.91002 .29936 Mdot
.91008 .29695 Mdot
.91014 .29695 Mdot
.9102 .29453 Mdot
.91026 .29695 Mdot
.91032 .30177 Mdot
.91038 .30419 Mdot
.91044 .3066 Mdot
.9105 .30902 Mdot
.91056 .30902 Mdot
.91062 .3066 Mdot
.91068 .3066 Mdot
.91074 .30902 Mdot
.9108 .31143 Mdot
.91086 .31143 Mdot
.91092 .30902 Mdot
.91098 .3066 Mdot
.91104 .3066 Mdot
.9111 .30902 Mdot
.91116 .31143 Mdot
.91122 .31626 Mdot
.91128 .31626 Mdot
.91134 .31626 Mdot
.9114 .31626 Mdot
.91146 .31626 Mdot
.91152 .31867 Mdot
.91158 .31626 Mdot
.91164 .31626 Mdot
.9117 .31626 Mdot
.91176 .31385 Mdot
.91182 .31143 Mdot
.91188 .3066 Mdot
.91194 .3066 Mdot
.912 .30902 Mdot
.91206 .31143 Mdot
.91212 .31626 Mdot
.91218 .31385 Mdot
.91224 .30902 Mdot
.9123 .30902 Mdot
.91236 .31143 Mdot
.91242 .31143 Mdot
.91248 .31143 Mdot
.91254 .31143 Mdot
.9126 .30902 Mdot
.91266 .3066 Mdot
.91272 .3066 Mdot
.91278 .3066 Mdot
.91284 .3066 Mdot
.9129 .30902 Mdot
.91296 .30902 Mdot
.91302 .30902 Mdot
.91308 .3066 Mdot
.91314 .30419 Mdot
.9132 .30177 Mdot
.91326 .30177 Mdot
.91332 .30177 Mdot
.91338 .30177 Mdot
.91344 .29936 Mdot
.9135 .29453 Mdot
.91356 .29212 Mdot
.91362 .29453 Mdot
.91368 .29936 Mdot
.91374 .30419 Mdot
.9138 .3066 Mdot
.91386 .3066 Mdot
.91392 .3066 Mdot
.91398 .30902 Mdot
.91404 .30902 Mdot
.9141 .31143 Mdot
.91416 .31143 Mdot
.91422 .31143 Mdot
.91428 .31143 Mdot
.91434 .31143 Mdot
.9144 .30902 Mdot
.91446 .30902 Mdot
.91452 .31143 Mdot
.91458 .31626 Mdot
.91464 .31867 Mdot
.9147 .31867 Mdot
.91476 .31626 Mdot
.91482 .31385 Mdot
.91488 .31385 Mdot
.91494 .31626 Mdot
.915 .31626 Mdot
.91506 .31385 Mdot
.91512 .31143 Mdot
.91518 .30902 Mdot
.91524 .30902 Mdot
.9153 .30902 Mdot
.91536 .31143 Mdot
.91542 .31385 Mdot
.91548 .31385 Mdot
.91554 .31385 Mdot
.9156 .31385 Mdot
.91566 .31143 Mdot
.91572 .31143 Mdot
.91578 .31143 Mdot
.91584 .31143 Mdot
.9159 .31143 Mdot
.91596 .30902 Mdot
.91602 .3066 Mdot
.91608 .30177 Mdot
.91614 .30177 Mdot
.9162 .30419 Mdot
.91626 .30902 Mdot
.91632 .30902 Mdot
.91638 .3066 Mdot
.91644 .30419 Mdot
.9165 .30419 Mdot
.91656 .3066 Mdot
.91662 .30419 Mdot
.91668 .30419 Mdot
.91674 .30177 Mdot
.9168 .30177 Mdot
.91686 .30177 Mdot
.91692 .29695 Mdot
.91698 .29453 Mdot
.91704 .29695 Mdot
.9171 .30177 Mdot
.91716 .3066 Mdot
.91722 .3066 Mdot
.91728 .3066 Mdot
.91734 .30419 Mdot
.9174 .3066 Mdot
.91746 .30902 Mdot
.91752 .31143 Mdot
.91758 .30902 Mdot
.91764 .30902 Mdot
.9177 .30902 Mdot
.91776 .30902 Mdot
.91782 .30902 Mdot
.91788 .31143 Mdot
.91794 .31385 Mdot
.918 .31626 Mdot
.91806 .31867 Mdot
.91812 .31867 Mdot
.91818 .31626 Mdot
.91824 .31626 Mdot
.9183 .31626 Mdot
.91836 .31626 Mdot
.91842 .31626 Mdot
.91848 .31626 Mdot
.91854 .31143 Mdot
.9186 .3066 Mdot
.91866 .3066 Mdot
.91872 .30902 Mdot
.91878 .31143 Mdot
.91884 .31385 Mdot
.9189 .31385 Mdot
.91896 .31143 Mdot
.91902 .31143 Mdot
.91908 .31143 Mdot
.91914 .31385 Mdot
.9192 .31385 Mdot
.91926 .31385 Mdot
.91932 .31143 Mdot
.91938 .31143 Mdot
.91944 .3066 Mdot
.9195 .30419 Mdot
.91956 .30419 Mdot
.91962 .3066 Mdot
.91968 .30902 Mdot
.91974 .30902 Mdot
.9198 .30419 Mdot
.91986 .30177 Mdot
.91992 .30177 Mdot
.91998 .30419 Mdot
.92004 .30419 Mdot
.9201 .30419 Mdot
.92016 .30177 Mdot
.92022 .29936 Mdot
.92028 .29695 Mdot
.92034 .29695 Mdot
.9204 .29695 Mdot
.92046 .30177 Mdot
.92052 .30419 Mdot
.92058 .3066 Mdot
.92064 .3066 Mdot
.9207 .3066 Mdot
.92076 .3066 Mdot
.92082 .3066 Mdot
.92088 .30902 Mdot
.92094 .31143 Mdot
.921 .31143 Mdot
.92106 .30902 Mdot
.92112 .3066 Mdot
.92118 .30419 Mdot
.92124 .3066 Mdot
.9213 .31143 Mdot
.92136 .31385 Mdot
.92142 .31626 Mdot
.92148 .31385 Mdot
.92154 .31385 Mdot
.9216 .31385 Mdot
.92166 .31626 Mdot
.92172 .31626 Mdot
.92178 .31626 Mdot
.92184 .31626 Mdot
.9219 .31385 Mdot
.92196 .31143 Mdot
.92202 .30902 Mdot
.92208 .30902 Mdot
.92214 .31143 Mdot
.9222 .31385 Mdot
.92226 .31385 Mdot
.92232 .31385 Mdot
.92238 .31143 Mdot
.92244 .31143 Mdot
.9225 .31143 Mdot
.92256 .31143 Mdot
.92262 .31143 Mdot
.92268 .31143 Mdot
.92274 .30902 Mdot
.9228 .3066 Mdot
.92286 .30419 Mdot
.92292 .30419 Mdot
.92298 .3066 Mdot
.92304 .30902 Mdot
.9231 .31143 Mdot
.92316 .30902 Mdot
.92322 .3066 Mdot
.92328 .30419 Mdot
.92334 .30419 Mdot
.9234 .30177 Mdot
.92346 .30419 Mdot
.92352 .30177 Mdot
.92358 .29936 Mdot
.92364 .29695 Mdot
.9237 .29453 Mdot
.92376 .29695 Mdot
.92382 .29936 Mdot
.92388 .30419 Mdot
.92394 .3066 Mdot
.924 .30419 Mdot
.92406 .30419 Mdot
.92412 .3066 Mdot
.92418 .30902 Mdot
.92424 .31143 Mdot
.9243 .31143 Mdot
.92436 .31143 Mdot
.92442 .31143 Mdot
.92448 .30902 Mdot
.92454 .3066 Mdot
.9246 .3066 Mdot
.92466 .31143 Mdot
.92472 .31385 Mdot
.92478 .31626 Mdot
.92484 .31385 Mdot
.9249 .31143 Mdot
.92496 .31143 Mdot
.92502 .31143 Mdot
.92508 .31385 Mdot
.92514 .31385 Mdot
.9252 .31385 Mdot
.92526 .31143 Mdot
.92532 .30902 Mdot
.92538 .30902 Mdot
.92544 .30902 Mdot
.9255 .31143 Mdot
.92556 .31385 Mdot
.92562 .31626 Mdot
.92568 .31626 Mdot
.92574 .31385 Mdot
.9258 .31143 Mdot
.92586 .31143 Mdot
.92592 .31143 Mdot
.92598 .31143 Mdot
.92604 .31143 Mdot
.9261 .31143 Mdot
.92616 .3066 Mdot
.92622 .30419 Mdot
.92628 .30419 Mdot
.92634 .30419 Mdot
.9264 .3066 Mdot
.92646 .30902 Mdot
.92652 .3066 Mdot
.92658 .30419 Mdot
.92664 .30177 Mdot
.9267 .30419 Mdot
.92676 .30419 Mdot
.92682 .30419 Mdot
.92688 .30419 Mdot
.92694 .30419 Mdot
.927 .30177 Mdot
.92706 .29936 Mdot
.92712 .29695 Mdot
.92718 .30177 Mdot
.92724 .30419 Mdot
.9273 .30902 Mdot
.92736 .3066 Mdot
.92742 .30419 Mdot
.92748 .30419 Mdot
.92754 .3066 Mdot
.9276 .30902 Mdot
.92766 .30902 Mdot
.92772 .30902 Mdot
.92778 .30902 Mdot
.92784 .3066 Mdot
.9279 .3066 Mdot
.92796 .30902 Mdot
.92802 .31143 Mdot
.92808 .31385 Mdot
.92814 .31626 Mdot
.9282 .31626 Mdot
.92826 .31385 Mdot
.92832 .31385 Mdot
.92838 .31385 Mdot
.92844 .31385 Mdot
.9285 .31385 Mdot
.92856 .31626 Mdot
.92862 .31385 Mdot
.92868 .31143 Mdot
.92874 .3066 Mdot
.9288 .3066 Mdot
.92886 .30902 Mdot
.92892 .31143 Mdot
.92898 .31385 Mdot
.92904 .31385 Mdot
.9291 .31143 Mdot
.92916 .31143 Mdot
.92922 .31143 Mdot
.92928 .31385 Mdot
.92934 .31385 Mdot
.9294 .31143 Mdot
.92946 .31143 Mdot
.92952 .30902 Mdot
.92958 .3066 Mdot
.92964 .30419 Mdot
.9297 .3066 Mdot
.92976 .30902 Mdot
.92982 .31143 Mdot
.92988 .30902 Mdot
.92994 .3066 Mdot
.93 .30419 Mdot
.93006 .30419 Mdot
.93012 .30419 Mdot
.93018 .30419 Mdot
.93024 .30419 Mdot
.9303 .30177 Mdot
.93036 .29936 Mdot
.93042 .29695 Mdot
.93048 .29695 Mdot
.93054 .29936 Mdot
.9306 .30177 Mdot
.93066 .3066 Mdot
.93072 .3066 Mdot
.93078 .30902 Mdot
.93084 .3066 Mdot
.9309 .30902 Mdot
.93096 .31143 Mdot
.93102 .31143 Mdot
.93108 .31143 Mdot
.93114 .31143 Mdot
.9312 .30902 Mdot
.93126 .3066 Mdot
.93132 .30419 Mdot
.93138 .3066 Mdot
.93144 .31143 Mdot
.9315 .31385 Mdot
.93156 .31143 Mdot
.93162 .31143 Mdot
.93168 .31143 Mdot
.93174 .31143 Mdot
.9318 .31385 Mdot
.93186 .31385 Mdot
.93192 .31385 Mdot
.93198 .31143 Mdot
.93204 .31143 Mdot
.9321 .30902 Mdot
.93216 .3066 Mdot
.93222 .30902 Mdot
.93228 .31143 Mdot
.93234 .31626 Mdot
.9324 .31626 Mdot
.93246 .31385 Mdot
.93252 .31143 Mdot
.93258 .31143 Mdot
.93264 .31385 Mdot
.9327 .31385 Mdot
.93276 .31385 Mdot
.93282 .30902 Mdot
.93288 .3066 Mdot
.93294 .30419 Mdot
.933 .30419 Mdot
.93306 .30419 Mdot
.93312 .3066 Mdot
.93318 .30902 Mdot
.93324 .30902 Mdot
.9333 .30902 Mdot
.93336 .3066 Mdot
.93342 .3066 Mdot
.93348 .3066 Mdot
.93354 .3066 Mdot
.9336 .3066 Mdot
.93366 .30419 Mdot
.93372 .30177 Mdot
.93378 .29936 Mdot
.93384 .29695 Mdot
.9339 .29936 Mdot
.93396 .30177 Mdot
.93402 .3066 Mdot
.93408 .3066 Mdot
.93414 .3066 Mdot
.9342 .30419 Mdot
.93426 .3066 Mdot
.93432 .30902 Mdot
.93438 .31143 Mdot
.93444 .31143 Mdot
.9345 .31143 Mdot
.93456 .30902 Mdot
.93462 .30902 Mdot
.93468 .3066 Mdot
.93474 .30902 Mdot
.9348 .31143 Mdot
.93486 .31385 Mdot
.93492 .31385 Mdot
.93498 .31143 Mdot
.93504 .30902 Mdot
.9351 .30902 Mdot
.93516 .31143 Mdot
.93522 .31385 Mdot
.93528 .31143 Mdot
.93534 .30902 Mdot
.9354 .3066 Mdot
.93546 .3066 Mdot
.93552 .3066 Mdot
.93558 .3066 Mdot
.93564 .30902 Mdot
.9357 .31143 Mdot
.93576 .31385 Mdot
.93582 .31385 Mdot
.93588 .31143 Mdot
.93594 .31143 Mdot
.936 .31385 Mdot
.93606 .31385 Mdot
.93612 .31385 Mdot
.93618 .31143 Mdot
.93624 .30902 Mdot
.9363 .3066 Mdot
.93636 .30419 Mdot
.93642 .30419 Mdot
.93648 .3066 Mdot
.93654 .30902 Mdot
.9366 .3066 Mdot
.93666 .3066 Mdot
.93672 .30419 Mdot
.93678 .30419 Mdot
.93684 .3066 Mdot
.9369 .3066 Mdot
.93696 .3066 Mdot
.93702 .3066 Mdot
.93708 .30419 Mdot
.93714 .30177 Mdot
.9372 .30177 Mdot
.93726 .30177 Mdot
.93732 .30419 Mdot
.93738 .30902 Mdot
.93744 .30902 Mdot
.9375 .3066 Mdot
.93756 .3066 Mdot
.93762 .3066 Mdot
.93768 .30902 Mdot
.93774 .31143 Mdot
.9378 .31143 Mdot
.93786 .30902 Mdot
.93792 .3066 Mdot
.93798 .3066 Mdot
.93804 .3066 Mdot
.9381 .30902 Mdot
.93816 .30902 Mdot
.93822 .31143 Mdot
.93828 .31385 Mdot
.93834 .31385 Mdot
.9384 .31143 Mdot
.93846 .31143 Mdot
.93852 .31385 Mdot
.93858 .31385 Mdot
.93864 .31385 Mdot
.9387 .31143 Mdot
.93876 .30902 Mdot
.93882 .3066 Mdot
.93888 .3066 Mdot
.93894 .3066 Mdot
.939 .30902 Mdot
.93906 .31143 Mdot
.93912 .31143 Mdot
.93918 .30902 Mdot
.93924 .30902 Mdot
.9393 .31143 Mdot
.93936 .31143 Mdot
.93942 .31143 Mdot
.93948 .31143 Mdot
.93954 .30902 Mdot
.9396 .30902 Mdot
.93966 .30902 Mdot
.93972 .3066 Mdot
.93978 .3066 Mdot
.93984 .30902 Mdot
.9399 .31143 Mdot
.93996 .31143 Mdot
.94002 .30902 Mdot
.94008 .3066 Mdot
.94014 .3066 Mdot
.9402 .3066 Mdot
.94026 .30902 Mdot
.94032 .3066 Mdot
.94038 .30419 Mdot
.94044 .30177 Mdot
.9405 .29936 Mdot
.94056 .29936 Mdot
.94062 .30177 Mdot
.94068 .30177 Mdot
.94074 .30419 Mdot
.9408 .3066 Mdot
.94086 .30902 Mdot
.94092 .30902 Mdot
.94098 .30902 Mdot
.94104 .31143 Mdot
.9411 .31385 Mdot
.94116 .31385 Mdot
.94122 .31385 Mdot
.94128 .31143 Mdot
.94134 .30902 Mdot
.9414 .3066 Mdot
.94146 .3066 Mdot
.94152 .30902 Mdot
.94158 .31143 Mdot
.94164 .31143 Mdot
.9417 .30902 Mdot
.94176 .30902 Mdot
.94182 .30902 Mdot
.94188 .31143 Mdot
.94194 .31143 Mdot
.942 .31143 Mdot
.94206 .30902 Mdot
.94212 .30902 Mdot
.94218 .30902 Mdot
.94224 .3066 Mdot
.9423 .3066 Mdot
.94236 .30902 Mdot
.94242 .31143 Mdot
.94248 .31385 Mdot
.94254 .31385 Mdot
.9426 .31143 Mdot
.94266 .30902 Mdot
.94272 .31143 Mdot
.94278 .31143 Mdot
.94284 .31143 Mdot
.9429 .30902 Mdot
.94296 .3066 Mdot
.94302 .3066 Mdot
.94308 .30419 Mdot
.94314 .3066 Mdot
.9432 .3066 Mdot
.94326 .30902 Mdot
.94332 .30902 Mdot
.94338 .30902 Mdot
.94344 .30902 Mdot
.9435 .3066 Mdot
.94356 .3066 Mdot
.94362 .30902 Mdot
.94368 .30902 Mdot
.94374 .3066 Mdot
.9438 .30419 Mdot
.94386 .30177 Mdot
.94392 .29936 Mdot
.94398 .29936 Mdot
.94404 .30177 Mdot
.9441 .30419 Mdot
.94416 .3066 Mdot
.94422 .3066 Mdot
.94428 .3066 Mdot
.94434 .3066 Mdot
.9444 .30902 Mdot
.94446 .31143 Mdot
.94452 .31143 Mdot
.94458 .31143 Mdot
.94464 .31143 Mdot
.9447 .30902 Mdot
.94476 .30902 Mdot
.94482 .30902 Mdot
.94488 .30902 Mdot
.94494 .31143 Mdot
.945 .31385 Mdot
.94506 .31143 Mdot
.94512 .31143 Mdot
.94518 .30902 Mdot
.94524 .30902 Mdot
.9453 .31143 Mdot
.94536 .31143 Mdot
.94542 .30902 Mdot
.94548 .3066 Mdot
.94554 .3066 Mdot
.9456 .3066 Mdot
.94566 .3066 Mdot
.94572 .3066 Mdot
.94578 .30902 Mdot
.94584 .31143 Mdot
.9459 .31385 Mdot
.94596 .31143 Mdot
.94602 .31143 Mdot
.94608 .31143 Mdot
.94614 .31385 Mdot
.9462 .31385 Mdot
.94626 .31143 Mdot
.94632 .31143 Mdot
.94638 .30902 Mdot
.94644 .3066 Mdot
.9465 .30419 Mdot
.94656 .3066 Mdot
.94662 .3066 Mdot
.94668 .30902 Mdot
.94674 .3066 Mdot
.9468 .30419 Mdot
.94686 .30419 Mdot
.94692 .3066 Mdot
.94698 .3066 Mdot
.94704 .3066 Mdot
.9471 .3066 Mdot
.94716 .30419 Mdot
.94722 .30419 Mdot
.94728 .30177 Mdot
.94734 .30177 Mdot
.9474 .30419 Mdot
.94746 .3066 Mdot
.94752 .3066 Mdot
.94758 .30902 Mdot
.94764 .3066 Mdot
.9477 .3066 Mdot
.94776 .3066 Mdot
.94782 .30902 Mdot
.94788 .31143 Mdot
.94794 .30902 Mdot
.948 .30902 Mdot
.94806 .3066 Mdot
.94812 .3066 Mdot
.94818 .3066 Mdot
.94824 .3066 Mdot
.9483 .30902 Mdot
.94836 .31143 Mdot
.94842 .31143 Mdot
.94848 .31143 Mdot
.94854 .30902 Mdot
.9486 .31143 Mdot
.94866 .31385 Mdot
.94872 .31385 Mdot
.94878 .31385 Mdot
.94884 .31143 Mdot
.9489 .30902 Mdot
.94896 .30902 Mdot
.94902 .3066 Mdot
.94908 .30902 Mdot
.94914 .30902 Mdot
.9492 .31143 Mdot
.94926 .31143 Mdot
.94932 .30902 Mdot
.94938 .30902 Mdot
.94944 .30902 Mdot
.9495 .31143 Mdot
.94956 .31143 Mdot
.94962 .31143 Mdot
.94968 .31143 Mdot
.94974 .30902 Mdot
.9498 .30902 Mdot
.94986 .30902 Mdot
.94992 .30902 Mdot
.94998 .30902 Mdot
.95004 .31143 Mdot
.9501 .30902 Mdot
.95016 .30902 Mdot
.95022 .3066 Mdot
.95028 .3066 Mdot
.95034 .3066 Mdot
.9504 .3066 Mdot
.95046 .3066 Mdot
.95052 .30419 Mdot
.95058 .30177 Mdot
.95064 .30177 Mdot
.9507 .30177 Mdot
.95076 .30177 Mdot
.95082 .30419 Mdot
.95088 .3066 Mdot
.95094 .3066 Mdot
.951 .3066 Mdot
.95106 .3066 Mdot
.95112 .30902 Mdot
.95118 .30902 Mdot
.95124 .31143 Mdot
.9513 .31143 Mdot
.95136 .30902 Mdot
.95142 .30902 Mdot
.95148 .30902 Mdot
.95154 .3066 Mdot
.9516 .3066 Mdot
.95166 .30902 Mdot
.95172 .30902 Mdot
.95178 .30902 Mdot
.95184 .30902 Mdot
.9519 .3066 Mdot
.95196 .3066 Mdot
.95202 .30902 Mdot
.95208 .30902 Mdot
.95213 .30902 Mdot
.95219 .30902 Mdot
.95225 .30902 Mdot
.95231 .30902 Mdot
.95237 .30902 Mdot
.95243 .30902 Mdot
.95249 .30902 Mdot
.95255 .31143 Mdot
.95261 .31143 Mdot
.95267 .31143 Mdot
.95273 .30902 Mdot
.95279 .30902 Mdot
.95285 .30902 Mdot
.95291 .31143 Mdot
.95297 .30902 Mdot
.95303 .30902 Mdot
.95309 .30902 Mdot
.95315 .30902 Mdot
.95321 .30902 Mdot
.95327 .30902 Mdot
.95333 .30902 Mdot
.95339 .30902 Mdot
.95345 .30902 Mdot
.95351 .30902 Mdot
.95357 .30902 Mdot
.95363 .3066 Mdot
.95369 .3066 Mdot
.95375 .30902 Mdot
.95381 .3066 Mdot
.95387 .3066 Mdot
.95393 .3066 Mdot
.95399 .30419 Mdot
.95405 .30419 Mdot
.95411 .30419 Mdot
.95417 .3066 Mdot
.95423 .3066 Mdot
.95429 .3066 Mdot
.95435 .3066 Mdot
.95441 .3066 Mdot
.95447 .3066 Mdot
.95453 .30902 Mdot
.95459 .30902 Mdot
.95465 .30902 Mdot
.95471 .30902 Mdot
.95477 .30902 Mdot
.95483 .30902 Mdot
.95489 .30902 Mdot
.95495 .30902 Mdot
.95501 .30902 Mdot
.95507 .30902 Mdot
.95513 .30902 Mdot
.95519 .30902 Mdot
.95525 .30902 Mdot
.95531 .30902 Mdot
.95537 .30902 Mdot
.95543 .30902 Mdot
.95549 .30902 Mdot
.95555 .30902 Mdot
.95561 .30902 Mdot
.95567 .3066 Mdot
.95573 .3066 Mdot
.95579 .3066 Mdot
.95585 .30902 Mdot
.95591 .30902 Mdot
.95597 .30902 Mdot
.95603 .30902 Mdot
.95609 .30902 Mdot
.95615 .30902 Mdot
.95621 .30902 Mdot
.95627 .30902 Mdot
.95633 .30902 Mdot
.95639 .30902 Mdot
.95645 .30902 Mdot
.95651 .30902 Mdot
.95657 .30902 Mdot
.95663 .30902 Mdot
.95669 .30902 Mdot
.95675 .30902 Mdot
.95681 .30902 Mdot
.95687 .30902 Mdot
.95693 .3066 Mdot
.95699 .3066 Mdot
.95705 .3066 Mdot
.95711 .3066 Mdot
.95717 .3066 Mdot
.95723 .3066 Mdot
.95729 .3066 Mdot
.95735 .3066 Mdot
.95741 .3066 Mdot
.95747 .3066 Mdot
.95753 .3066 Mdot
.95759 .3066 Mdot
.95765 .30902 Mdot
.95771 .3066 Mdot
.95777 .30902 Mdot
.95783 .3066 Mdot
.95789 .3066 Mdot
.95795 .30902 Mdot
.95801 .3066 Mdot
.95807 .30902 Mdot
.95813 .30902 Mdot
.95819 .3066 Mdot
.95825 .30902 Mdot
.95831 .3066 Mdot
.95837 .30902 Mdot
.95843 .30902 Mdot
.95849 .30902 Mdot
.95855 .30902 Mdot
.95861 .30902 Mdot
.95867 .30902 Mdot
.95873 .30902 Mdot
.95879 .30902 Mdot
.95885 .30902 Mdot
.95891 .30902 Mdot
.95897 .30902 Mdot
.95903 .30902 Mdot
.95909 .30902 Mdot
.95915 .30902 Mdot
.95921 .30902 Mdot
.95927 .30902 Mdot
.95933 .30902 Mdot
.95939 .30902 Mdot
.95945 .30902 Mdot
.95951 .30902 Mdot
.95957 .30902 Mdot
.95963 .30902 Mdot
.95969 .30902 Mdot
.95975 .30902 Mdot
.95981 .30902 Mdot
.95987 .30902 Mdot
.95993 .30902 Mdot
.95999 .30902 Mdot
.96005 .30902 Mdot
.96011 .30902 Mdot
.96017 .30902 Mdot
.96023 .30902 Mdot
.96029 .30902 Mdot
.96035 .30902 Mdot
.96041 .30902 Mdot
.96047 .30902 Mdot
.96053 .30902 Mdot
.96059 .30902 Mdot
.96065 .30902 Mdot
.96071 .30902 Mdot
.96077 .30902 Mdot
.96083 .30902 Mdot
.96089 .30902 Mdot
.96095 .30902 Mdot
.96101 .30902 Mdot
.96107 .30902 Mdot
.96113 .30902 Mdot
.96119 .30902 Mdot
.96125 .30902 Mdot
.96131 .30902 Mdot
.96137 .30902 Mdot
.96143 .30902 Mdot
.96149 .30902 Mdot
.96155 .30902 Mdot
.96161 .30902 Mdot
.96167 .30902 Mdot
.96173 .30902 Mdot
.96179 .30902 Mdot
.96185 .30902 Mdot
.96191 .30902 Mdot
.96197 .30902 Mdot
.96203 .30902 Mdot
.96209 .30902 Mdot
.96215 .30902 Mdot
.96221 .30902 Mdot
.96227 .30902 Mdot
.96233 .30902 Mdot
.96239 .30902 Mdot
.96245 .30902 Mdot
.96251 .30902 Mdot
.96257 .30902 Mdot
.96263 .30902 Mdot
.96269 .30902 Mdot
.96275 .30902 Mdot
.96281 .30902 Mdot
.96287 .30902 Mdot
.96293 .30902 Mdot
.96299 .30902 Mdot
.96305 .30902 Mdot
.96311 .30902 Mdot
.96317 .30902 Mdot
.96323 .30902 Mdot
.96329 .30902 Mdot
.96335 .30902 Mdot
.96341 .30902 Mdot
.96347 .30902 Mdot
.96353 .30902 Mdot
.96359 .30902 Mdot
.96365 .30902 Mdot
.96371 .30902 Mdot
.96377 .30902 Mdot
.96383 .30902 Mdot
.96389 .30902 Mdot
.96395 .30902 Mdot
.96401 .30902 Mdot
.96407 .30902 Mdot
.96413 .30902 Mdot
.96419 .30902 Mdot
.96425 .30902 Mdot
.96431 .30902 Mdot
.96437 .30902 Mdot
.96443 .30902 Mdot
.96449 .30902 Mdot
.96455 .30902 Mdot
.96461 .30902 Mdot
.96467 .30902 Mdot
.96473 .30902 Mdot
.96479 .30902 Mdot
.96485 .30902 Mdot
.96491 .30902 Mdot
.96497 .30902 Mdot
.96503 .30902 Mdot
.96509 .30902 Mdot
.96515 .30902 Mdot
.96521 .30902 Mdot
.96527 .30902 Mdot
.96533 .30902 Mdot
.96539 .30902 Mdot
.96545 .30902 Mdot
.96551 .30902 Mdot
.96557 .30902 Mdot
.96563 .30902 Mdot
.96569 .30902 Mdot
.96575 .30902 Mdot
.96581 .30902 Mdot
.96587 .30902 Mdot
.96593 .30902 Mdot
.96599 .30902 Mdot
.96605 .30902 Mdot
.96611 .30902 Mdot
.96617 .30902 Mdot
.96623 .30902 Mdot
.96629 .30902 Mdot
.96635 .30902 Mdot
.96641 .30902 Mdot
.96647 .30902 Mdot
.96653 .30902 Mdot
.96659 .30902 Mdot
.96665 .30902 Mdot
.96671 .30902 Mdot
.96677 .30902 Mdot
.96683 .30902 Mdot
.96689 .30902 Mdot
.96695 .30902 Mdot
.96701 .30902 Mdot
.96707 .30902 Mdot
.96713 .30902 Mdot
.96719 .30902 Mdot
.96725 .30902 Mdot
.96731 .30902 Mdot
.96737 .30902 Mdot
.96743 .30902 Mdot
.96749 .30902 Mdot
.96755 .30902 Mdot
.96761 .30902 Mdot
.96767 .30902 Mdot
.96773 .30902 Mdot
.96779 .30902 Mdot
.96785 .30902 Mdot
.96791 .30902 Mdot
.96797 .30902 Mdot
.96803 .30902 Mdot
.96809 .30902 Mdot
.96815 .30902 Mdot
.96821 .30902 Mdot
.96827 .30902 Mdot
.96833 .30902 Mdot
.96839 .30902 Mdot
.96845 .30902 Mdot
.96851 .30902 Mdot
.96857 .30902 Mdot
.96863 .30902 Mdot
.96869 .30902 Mdot
.96875 .30902 Mdot
.96881 .30902 Mdot
.96887 .30902 Mdot
.96893 .30902 Mdot
.96899 .30902 Mdot
.96905 .30902 Mdot
.96911 .30902 Mdot
.96917 .30902 Mdot
.96923 .30902 Mdot
.96929 .30902 Mdot
.96935 .30902 Mdot
.96941 .30902 Mdot
.96947 .30902 Mdot
.96953 .30902 Mdot
.96959 .30902 Mdot
.96965 .30902 Mdot
.96971 .30902 Mdot
.96977 .30902 Mdot
.96983 .30902 Mdot
.96989 .30902 Mdot
.96995 .30902 Mdot
.97001 .30902 Mdot
.97007 .30902 Mdot
.97013 .30902 Mdot
.97019 .30902 Mdot
.97025 .30902 Mdot
.97031 .30902 Mdot
.97037 .30902 Mdot
.97043 .30902 Mdot
.97049 .30902 Mdot
.97055 .30902 Mdot
.97061 .30902 Mdot
.97067 .30902 Mdot
.97073 .30902 Mdot
.97079 .30902 Mdot
.97085 .30902 Mdot
.97091 .30902 Mdot
.97097 .30902 Mdot
.97103 .30902 Mdot
.97109 .30902 Mdot
.97115 .30902 Mdot
.97121 .30902 Mdot
.97127 .30902 Mdot
.97133 .30902 Mdot
.97139 .30902 Mdot
.97145 .30902 Mdot
.97151 .30902 Mdot
.97157 .30902 Mdot
.97163 .30902 Mdot
.97169 .30902 Mdot
.97175 .30902 Mdot
.97181 .30902 Mdot
.97187 .30902 Mdot
.97193 .30902 Mdot
.97199 .30902 Mdot
.97205 .30902 Mdot
.97211 .30902 Mdot
.97217 .30902 Mdot
.97223 .30902 Mdot
.97229 .30902 Mdot
.97235 .30902 Mdot
.97241 .30902 Mdot
.97247 .30902 Mdot
.97253 .30902 Mdot
.97259 .30902 Mdot
.97265 .30902 Mdot
.97271 .30902 Mdot
.97277 .30902 Mdot
.97283 .30902 Mdot
.97289 .30902 Mdot
.97295 .30902 Mdot
.97301 .30902 Mdot
.97307 .30902 Mdot
.97313 .30902 Mdot
.97319 .30902 Mdot
.97325 .30902 Mdot
.97331 .30902 Mdot
.97337 .30902 Mdot
.97343 .30902 Mdot
.97349 .30902 Mdot
.97355 .30902 Mdot
.97361 .30902 Mdot
.97367 .30902 Mdot
.97373 .30902 Mdot
.97379 .30902 Mdot
.97385 .30902 Mdot
.97391 .30902 Mdot
.97397 .30902 Mdot
.97403 .30902 Mdot
.97409 .30902 Mdot
.97415 .30902 Mdot
.97421 .30902 Mdot
.97427 .30902 Mdot
.97433 .30902 Mdot
.97439 .30902 Mdot
.97445 .30902 Mdot
.97451 .30902 Mdot
.97457 .30902 Mdot
.97463 .30902 Mdot
.97469 .30902 Mdot
.97475 .30902 Mdot
.97481 .30902 Mdot
.97487 .30902 Mdot
.97493 .30902 Mdot
.97499 .30902 Mdot
.97505 .30902 Mdot
.97511 .30902 Mdot
.97517 .30902 Mdot
.97523 .30902 Mdot
.97529 .30902 Mdot
.97535 .30902 Mdot
.97541 .30902 Mdot
.97547 .30902 Mdot
.97553 .30902 Mdot
.97559 .30902 Mdot
.97565 .30902 Mdot
.97571 .30902 Mdot
.97577 .30902 Mdot
.97583 .30902 Mdot
.97589 .30902 Mdot
.97595 .30902 Mdot
.97601 .30902 Mdot
.97607 .30902 Mdot
.97613 .30902 Mdot
.97619 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.51.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ReadSoundFile", "MR"],
 " is capable of reading in sounds that have been mu\[Hyphen]law encoded. Mu\
\[Hyphen]law encoding is a logarithmic encoding scheme in which 12 bits of \
data are stored in 8 bits, resulting in telephone\[Hyphen]quality sound. \
Voice\[Hyphen]mail frequently uses some form of mu\[Hyphen]law encoding. "
}], "Text",
 CellTags->{"S5.51.1", "1.46"}],

Cell[TextData[{
 "Read in the mu\[Hyphen]law encoded Sun sound file ",
 StyleBox["bubbles.au", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.47"}],

Cell[CellGroupData[{

Cell["\<\
bubbles = ReadSoundFile[\"bubbles.au\",
        PrintHeader->True];\
\>", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Format: \"\>", "\[InvisibleSpace]", "\<\"NeXT/Sun\"\>"}],
  SequenceForm["Format: ", "NeXT/Sun"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Duration: \"\>", "\[InvisibleSpace]", "3.901375`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["Duration: ", 3.901375, " seconds"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Channels: \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Channels: ", 1],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sampling rate: \"\>", "\[InvisibleSpace]", "8000"}],
  SequenceForm["Sampling rate: ", 8000],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Bits per sample: \"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["Bits per sample: ", 8],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Data size: \"\>", "\[InvisibleSpace]", "31211", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["Data size: ", 31211, " bytes"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of samples: \"\>", "\[InvisibleSpace]", "31211"}],
  SequenceForm["Number of samples: ", 31211],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Encoding: \"\>", "\[InvisibleSpace]", "\<\"8-bit mulaw\"\>"}],
  SequenceForm["Encoding: ", "8-bit mulaw"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Text: \"\>", "\[InvisibleSpace]", "\<\"bubbling goop   \"\>"}],
  
  SequenceForm["Text: ", "bubbling goop   "],
  Editable->False]], "Print",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "Play the sound with ",
 StyleBox["ListPlay", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.48"}],

Cell[CellGroupData[{

Cell["\<\
ListPlay[bubbles, SampleRate->8000,
        PlayRange->{-2^15, 2^15}]\
\>", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell["\<\
In the case of stereo files, the data are returned as a list of two lists: \
left\[Hyphen]channel sample data and right\[Hyphen]channel sample data. \
\>", "Text",
 CellTags->{"S5.51.1", "1.49"}],

Cell["This reads in a stereo file. ", "MathCaption",
 CellTags->{"S5.51.1", "1.50"}],

Cell[CellGroupData[{

Cell["\<\
voice = ReadSoundFile[\"voice.snd\",
        PrintHeader->True] ;\
\>", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Format: \"\>", "\[InvisibleSpace]", "\<\"NeXT/Sun\"\>"}],
  SequenceForm["Format: ", "NeXT/Sun"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Duration: \"\>", "\[InvisibleSpace]", "0.1434920634920635`", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["Duration: ", 0.143492063492064, " seconds"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Channels: \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Channels: ", 2],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sampling rate: \"\>", "\[InvisibleSpace]", "22050"}],
  SequenceForm["Sampling rate: ", 22050],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Bits per sample: \"\>", "\[InvisibleSpace]", "16"}],
  SequenceForm["Bits per sample: ", 16],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Data size: \"\>", "\[InvisibleSpace]", "25312", 
   "\[InvisibleSpace]", "\<\" bytes\"\>"}],
  SequenceForm["Data size: ", 25312, " bytes"],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of samples: \"\>", "\[InvisibleSpace]", "6328"}],
  SequenceForm["Number of samples: ", 6328],
  Editable->False]], "Print",
 CellTags->"S5.51.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Text: \"\>", 
   "\[InvisibleSpace]", "\<\"by Christopher Penrose  \"\>"}],
  SequenceForm["Text: ", "by Christopher Penrose  "],
  Editable->False]], "Print",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell["This plays the stereo sound. ", "MathCaption",
 CellTags->{"S5.51.1", "1.51"}],

Cell[CellGroupData[{

Cell["\<\
ListPlay[voice, SampleRate->22050,
        PlayRange->{-2^15, 2^15}]\
\>", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell["\<\
When plotting a stereo sound, remember to add the two lists together; \
otherwise you will get a plot of the left channel followed by the right \
channel. \
\>", "Text",
 CellTags->{"S5.51.1", "1.52"}],

Cell["\<\
The left and right channels are added together before plotting. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.53"}],

Cell[CellGroupData[{

Cell["\<\
ListPlot[Plus @@ voice,
  PlotRange->{-2^15, 2^15}];\
\>", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.51.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.000150503 0.309017 9.43045e-06 [
[.17431 .29652 -12 -9 ]
[.17431 .29652 12 0 ]
[.32481 .29652 -12 -9 ]
[.32481 .29652 12 0 ]
[.47532 .29652 -12 -9 ]
[.47532 .29652 12 0 ]
[.62582 .29652 -12 -9 ]
[.62582 .29652 12 0 ]
[.77632 .29652 -12 -9 ]
[.77632 .29652 12 0 ]
[.92683 .29652 -12 -9 ]
[.92683 .29652 12 0 ]
[.01131 .0261 -36 -4.5 ]
[.01131 .0261 0 4.5 ]
[.01131 .12041 -36 -4.5 ]
[.01131 .12041 0 4.5 ]
[.01131 .21471 -36 -4.5 ]
[.01131 .21471 0 4.5 ]
[.01131 .40332 -30 -4.5 ]
[.01131 .40332 0 4.5 ]
[.01131 .49763 -30 -4.5 ]
[.01131 .49763 0 4.5 ]
[.01131 .59193 -30 -4.5 ]
[.01131 .59193 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17431 .30902 m
.17431 .31527 L
s
[(1000)] .17431 .29652 0 1 Mshowa
.32481 .30902 m
.32481 .31527 L
s
[(2000)] .32481 .29652 0 1 Mshowa
.47532 .30902 m
.47532 .31527 L
s
[(3000)] .47532 .29652 0 1 Mshowa
.62582 .30902 m
.62582 .31527 L
s
[(4000)] .62582 .29652 0 1 Mshowa
.77632 .30902 m
.77632 .31527 L
s
[(5000)] .77632 .29652 0 1 Mshowa
.92683 .30902 m
.92683 .31527 L
s
[(6000)] .92683 .29652 0 1 Mshowa
.125 Mabswid
.05391 .30902 m
.05391 .31277 L
s
.08401 .30902 m
.08401 .31277 L
s
.11411 .30902 m
.11411 .31277 L
s
.14421 .30902 m
.14421 .31277 L
s
.20441 .30902 m
.20441 .31277 L
s
.23451 .30902 m
.23451 .31277 L
s
.26461 .30902 m
.26461 .31277 L
s
.29471 .30902 m
.29471 .31277 L
s
.35492 .30902 m
.35492 .31277 L
s
.38502 .30902 m
.38502 .31277 L
s
.41512 .30902 m
.41512 .31277 L
s
.44522 .30902 m
.44522 .31277 L
s
.50542 .30902 m
.50542 .31277 L
s
.53552 .30902 m
.53552 .31277 L
s
.56562 .30902 m
.56562 .31277 L
s
.59572 .30902 m
.59572 .31277 L
s
.65592 .30902 m
.65592 .31277 L
s
.68602 .30902 m
.68602 .31277 L
s
.71612 .30902 m
.71612 .31277 L
s
.74622 .30902 m
.74622 .31277 L
s
.80642 .30902 m
.80642 .31277 L
s
.83652 .30902 m
.83652 .31277 L
s
.86662 .30902 m
.86662 .31277 L
s
.89673 .30902 m
.89673 .31277 L
s
.95693 .30902 m
.95693 .31277 L
s
.98703 .30902 m
.98703 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .0261 m
.03006 .0261 L
s
[(-30000)] .01131 .0261 1 0 Mshowa
.02381 .12041 m
.03006 .12041 L
s
[(-20000)] .01131 .12041 1 0 Mshowa
.02381 .21471 m
.03006 .21471 L
s
[(-10000)] .01131 .21471 1 0 Mshowa
.02381 .40332 m
.03006 .40332 L
s
[(10000)] .01131 .40332 1 0 Mshowa
.02381 .49763 m
.03006 .49763 L
s
[(20000)] .01131 .49763 1 0 Mshowa
.02381 .59193 m
.03006 .59193 L
s
[(30000)] .01131 .59193 1 0 Mshowa
.125 Mabswid
.02381 .04496 m
.02756 .04496 L
s
.02381 .06383 m
.02756 .06383 L
s
.02381 .08269 m
.02756 .08269 L
s
.02381 .10155 m
.02756 .10155 L
s
.02381 .13927 m
.02756 .13927 L
s
.02381 .15813 m
.02756 .15813 L
s
.02381 .17699 m
.02756 .17699 L
s
.02381 .19585 m
.02756 .19585 L
s
.02381 .23357 m
.02756 .23357 L
s
.02381 .25243 m
.02756 .25243 L
s
.02381 .2713 m
.02756 .2713 L
s
.02381 .29016 m
.02756 .29016 L
s
.02381 .32788 m
.02756 .32788 L
s
.02381 .34674 m
.02756 .34674 L
s
.02381 .3656 m
.02756 .3656 L
s
.02381 .38446 m
.02756 .38446 L
s
.02381 .42218 m
.02756 .42218 L
s
.02381 .44104 m
.02756 .44104 L
s
.02381 .4599 m
.02756 .4599 L
s
.02381 .47877 m
.02756 .47877 L
s
.02381 .51649 m
.02756 .51649 L
s
.02381 .53535 m
.02756 .53535 L
s
.02381 .55421 m
.02756 .55421 L
s
.02381 .57307 m
.02756 .57307 L
s
.02381 .00724 m
.02756 .00724 L
s
.02381 .61079 m
.02756 .61079 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02396 .30902 Mdot
.02411 .30902 Mdot
.02426 .30901 Mdot
.02441 .309 Mdot
.02456 .30898 Mdot
.02471 .30899 Mdot
.02486 .30898 Mdot
.02501 .30898 Mdot
.02516 .30899 Mdot
.02531 .30899 Mdot
.02547 .309 Mdot
.02562 .309 Mdot
.02577 .309 Mdot
.02592 .30901 Mdot
.02607 .30902 Mdot
.02622 .30902 Mdot
.02637 .30902 Mdot
.02652 .30901 Mdot
.02667 .30902 Mdot
.02682 .30902 Mdot
.02697 .30901 Mdot
.02712 .30899 Mdot
.02727 .30899 Mdot
.02742 .30899 Mdot
.02757 .30898 Mdot
.02772 .30898 Mdot
.02787 .30898 Mdot
.02802 .309 Mdot
.02817 .30901 Mdot
.02832 .30902 Mdot
.02848 .30902 Mdot
.02863 .30904 Mdot
.02878 .30904 Mdot
.02893 .30903 Mdot
.02908 .30905 Mdot
.02923 .30905 Mdot
.02938 .30906 Mdot
.02953 .30909 Mdot
.02968 .30909 Mdot
.02983 .30909 Mdot
.02998 .30907 Mdot
.03013 .30906 Mdot
.03028 .30905 Mdot
.03043 .30906 Mdot
.03058 .30906 Mdot
.03073 .30905 Mdot
.03088 .30904 Mdot
.03103 .30904 Mdot
.03118 .30903 Mdot
.03133 .30903 Mdot
.03149 .30902 Mdot
.03164 .30901 Mdot
.03179 .30902 Mdot
.03194 .30901 Mdot
.03209 .30902 Mdot
.03224 .30902 Mdot
.03239 .30902 Mdot
.03254 .30903 Mdot
.03269 .30904 Mdot
.03284 .30903 Mdot
.03299 .30904 Mdot
.03314 .30904 Mdot
.03329 .30902 Mdot
.03344 .30903 Mdot
.03359 .30903 Mdot
.03374 .30901 Mdot
.03389 .30901 Mdot
.03404 .30902 Mdot
.03419 .30899 Mdot
.03434 .30899 Mdot
.0345 .30899 Mdot
.03465 .30897 Mdot
.0348 .30899 Mdot
.03495 .30901 Mdot
.0351 .30899 Mdot
.03525 .30896 Mdot
.0354 .30898 Mdot
.03555 .30898 Mdot
.0357 .30897 Mdot
.03585 .30899 Mdot
.036 .30899 Mdot
.03615 .30897 Mdot
.0363 .30893 Mdot
.03645 .30896 Mdot
.0366 .30896 Mdot
.03675 .309 Mdot
.0369 .30904 Mdot
.03705 .30904 Mdot
.0372 .30905 Mdot
.03735 .30905 Mdot
.03751 .30905 Mdot
.03766 .30905 Mdot
.03781 .30908 Mdot
.03796 .30909 Mdot
.03811 .30908 Mdot
.03826 .30907 Mdot
.03841 .30912 Mdot
.03856 .30911 Mdot
.03871 .30912 Mdot
.03886 .30909 Mdot
.03901 .30905 Mdot
.03916 .30899 Mdot
.03931 .30899 Mdot
.03946 .30902 Mdot
.03961 .309 Mdot
.03976 .309 Mdot
.03991 .30899 Mdot
.04006 .30898 Mdot
.04021 .309 Mdot
.04036 .30901 Mdot
.04052 .30905 Mdot
.04067 .30905 Mdot
.04082 .30907 Mdot
.04097 .30907 Mdot
.04112 .30911 Mdot
.04127 .30914 Mdot
.04142 .3092 Mdot
.04157 .30919 Mdot
.04172 .30919 Mdot
.04187 .30915 Mdot
.04202 .30912 Mdot
.04217 .3091 Mdot
.04232 .30906 Mdot
.04247 .30902 Mdot
.04262 .309 Mdot
.04277 .30893 Mdot
.04292 .30886 Mdot
.04307 .30888 Mdot
.04322 .30889 Mdot
.04337 .30892 Mdot
.04353 .30888 Mdot
.04368 .30886 Mdot
.04383 .30888 Mdot
.04398 .30889 Mdot
.04413 .3089 Mdot
.04428 .3089 Mdot
.04443 .30897 Mdot
.04458 .30898 Mdot
.04473 .30903 Mdot
.04488 .30902 Mdot
.04503 .30905 Mdot
.04518 .30908 Mdot
.04533 .30905 Mdot
.04548 .30904 Mdot
.04563 .30901 Mdot
.04578 .30901 Mdot
.04593 .30895 Mdot
.04608 .30893 Mdot
.04623 .3089 Mdot
.04638 .30891 Mdot
.04654 .30896 Mdot
.04669 .30895 Mdot
.04684 .30902 Mdot
.04699 .30902 Mdot
.04714 .30904 Mdot
.04729 .309 Mdot
.04744 .30905 Mdot
.04759 .30903 Mdot
.04774 .30906 Mdot
.04789 .30912 Mdot
.04804 .30918 Mdot
.04819 .30923 Mdot
.04834 .30919 Mdot
.04849 .30921 Mdot
.04864 .30923 Mdot
.04879 .30923 Mdot
.04894 .30922 Mdot
.04909 .3092 Mdot
.04924 .30917 Mdot
.04939 .30916 Mdot
.04955 .30914 Mdot
.0497 .30919 Mdot
.04985 .30922 Mdot
.05 .30923 Mdot
.05015 .30913 Mdot
.0503 .30907 Mdot
.05045 .30899 Mdot
.0506 .30891 Mdot
.05075 .30893 Mdot
.0509 .30896 Mdot
.05105 .30899 Mdot
.0512 .30908 Mdot
.05135 .30902 Mdot
.0515 .30904 Mdot
.05165 .30904 Mdot
.0518 .30903 Mdot
.05195 .309 Mdot
.0521 .30895 Mdot
.05225 .3089 Mdot
.05241 .30888 Mdot
.05256 .30892 Mdot
.05271 .30902 Mdot
.05286 .30905 Mdot
.05301 .30913 Mdot
.05316 .30917 Mdot
.05331 .3091 Mdot
.05346 .30913 Mdot
.05361 .30908 Mdot
.05376 .30905 Mdot
.05391 .30905 Mdot
.05406 .30904 Mdot
.05421 .30913 Mdot
.05436 .30914 Mdot
.05451 .30919 Mdot
.05466 .3091 Mdot
.05481 .30898 Mdot
.05496 .30889 Mdot
.05511 .30886 Mdot
.05526 .30885 Mdot
.05542 .3088 Mdot
.05557 .30879 Mdot
.05572 .30878 Mdot
.05587 .30878 Mdot
.05602 .30883 Mdot
.05617 .30877 Mdot
.05632 .30864 Mdot
.05647 .30863 Mdot
.05662 .30859 Mdot
.05677 .30854 Mdot
.05692 .30859 Mdot
.05707 .30868 Mdot
.05722 .30865 Mdot
.05737 .30872 Mdot
.05752 .30877 Mdot
.05767 .30865 Mdot
.05782 .3087 Mdot
.05797 .30851 Mdot
.05812 .30851 Mdot
.05827 .30861 Mdot
.05843 .30866 Mdot
.05858 .3087 Mdot
.05873 .30875 Mdot
.05888 .30873 Mdot
.05903 .30876 Mdot
.05918 .30884 Mdot
.05933 .30896 Mdot
.05948 .30905 Mdot
.05963 .3093 Mdot
.05978 .30937 Mdot
.05993 .30947 Mdot
.06008 .30968 Mdot
.06023 .30964 Mdot
.06038 .30995 Mdot
.06053 .31008 Mdot
.06068 .31 Mdot
.06083 .31001 Mdot
.06098 .30994 Mdot
.06113 .30993 Mdot
.06128 .31003 Mdot
.06144 .31008 Mdot
.06159 .30998 Mdot
.06174 .31 Mdot
.06189 .30981 Mdot
.06204 .30955 Mdot
.06219 .30935 Mdot
.06234 .30905 Mdot
.06249 .30894 Mdot
.06264 .30884 Mdot
.06279 .3089 Mdot
.06294 .30896 Mdot
.06309 .30896 Mdot
.06324 .30899 Mdot
.06339 .30888 Mdot
.06354 .30889 Mdot
.06369 .3087 Mdot
.06384 .30856 Mdot
.06399 .30832 Mdot
.06414 .30822 Mdot
.06429 .30825 Mdot
.06445 .3083 Mdot
.0646 .30843 Mdot
.06475 .30846 Mdot
.0649 .30837 Mdot
.06505 .30837 Mdot
.0652 .30809 Mdot
.06535 .30801 Mdot
.0655 .30801 Mdot
.06565 .30827 Mdot
.0658 .30855 Mdot
.06595 .30872 Mdot
.0661 .3089 Mdot
.06625 .30914 Mdot
.0664 .30918 Mdot
.06655 .30912 Mdot
.0667 .30897 Mdot
.06685 .30908 Mdot
.067 .30927 Mdot
.06715 .30932 Mdot
.0673 .3096 Mdot
.06746 .30981 Mdot
.06761 .30988 Mdot
.06776 .31002 Mdot
.06791 .30993 Mdot
.06806 .30958 Mdot
.06821 .30933 Mdot
.06836 .30908 Mdot
.06851 .30892 Mdot
.06866 .30879 Mdot
.06881 .30873 Mdot
.06896 .30868 Mdot
.06911 .30847 Mdot
.06926 .30847 Mdot
.06941 .30848 Mdot
.06956 .30855 Mdot
.06971 .30833 Mdot
.06986 .30835 Mdot
.07001 .30791 Mdot
.07016 .30815 Mdot
.07031 .30817 Mdot
.07047 .30801 Mdot
.07062 .30804 Mdot
.07077 .30795 Mdot
.07092 .3078 Mdot
.07107 .30789 Mdot
.07122 .30804 Mdot
.07137 .30806 Mdot
.07152 .30816 Mdot
.07167 .30822 Mdot
.07182 .30835 Mdot
.07197 .30884 Mdot
.07212 .30905 Mdot
.07227 .30945 Mdot
.07242 .30971 Mdot
.07257 .31009 Mdot
.07272 .31011 Mdot
.07287 .31044 Mdot
.07302 .31056 Mdot
.07317 .31074 Mdot
.07332 .31111 Mdot
.07348 .31119 Mdot
.07363 .31119 Mdot
.07378 .31108 Mdot
.07393 .31096 Mdot
.07408 .31079 Mdot
.07423 .31071 Mdot
.07438 .31054 Mdot
.07453 .31042 Mdot
.07468 .31021 Mdot
.07483 .30999 Mdot
.07498 .31 Mdot
.07513 .30977 Mdot
.07528 .30955 Mdot
.07543 .30915 Mdot
.07558 .30894 Mdot
.07573 .30878 Mdot
.07588 .30882 Mdot
.07603 .3087 Mdot
.07618 .30892 Mdot
.07633 .30899 Mdot
.07649 .30879 Mdot
.07664 .30893 Mdot
.07679 .30859 Mdot
.07694 .30784 Mdot
.07709 .30749 Mdot
.07724 .30716 Mdot
.07739 .30697 Mdot
.07754 .30706 Mdot
.07769 .30685 Mdot
.07784 .30684 Mdot
.07799 .3066 Mdot
.07814 .30669 Mdot
.07829 .30696 Mdot
.07844 .30699 Mdot
.07859 .30693 Mdot
.07874 .30725 Mdot
.07889 .30802 Mdot
.07904 .30835 Mdot
.07919 .30882 Mdot
.07935 .30905 Mdot
.0795 .30917 Mdot
.07965 .30937 Mdot
.0798 .30959 Mdot
.07995 .30959 Mdot
.0801 .31016 Mdot
.08025 .31021 Mdot
.0804 .31027 Mdot
.08055 .31027 Mdot
.0807 .31002 Mdot
.08085 .3102 Mdot
.081 .30973 Mdot
.08115 .30922 Mdot
.0813 .30885 Mdot
.08145 .30865 Mdot
.0816 .30802 Mdot
.08175 .30764 Mdot
.0819 .3074 Mdot
.08205 .30741 Mdot
.0822 .3069 Mdot
.08236 .30699 Mdot
.08251 .30741 Mdot
.08266 .30801 Mdot
.08281 .30858 Mdot
.08296 .30905 Mdot
.08311 .30941 Mdot
.08326 .30963 Mdot
.08341 .30967 Mdot
.08356 .3091 Mdot
.08371 .30861 Mdot
.08386 .30841 Mdot
.08401 .30864 Mdot
.08416 .30847 Mdot
.08431 .30859 Mdot
.08446 .30814 Mdot
.08461 .30861 Mdot
.08476 .30883 Mdot
.08491 .30907 Mdot
.08506 .30888 Mdot
.08521 .30862 Mdot
.08537 .30865 Mdot
.08552 .30858 Mdot
.08567 .30823 Mdot
.08582 .30836 Mdot
.08597 .30833 Mdot
.08612 .30799 Mdot
.08627 .30868 Mdot
.08642 .30942 Mdot
.08657 .30997 Mdot
.08672 .31058 Mdot
.08687 .31084 Mdot
.08702 .31147 Mdot
.08717 .31167 Mdot
.08732 .31139 Mdot
.08747 .31054 Mdot
.08762 .30944 Mdot
.08777 .30884 Mdot
.08792 .30839 Mdot
.08807 .30869 Mdot
.08822 .30896 Mdot
.08838 .30874 Mdot
.08853 .30899 Mdot
.08868 .30907 Mdot
.08883 .30944 Mdot
.08898 .31001 Mdot
.08913 .31017 Mdot
.08928 .3097 Mdot
.08943 .30888 Mdot
.08958 .3076 Mdot
.08973 .30634 Mdot
.08988 .30521 Mdot
.09003 .30457 Mdot
.09018 .30367 Mdot
.09033 .30353 Mdot
.09048 .30343 Mdot
.09063 .30367 Mdot
.09078 .30435 Mdot
.09093 .30552 Mdot
.09108 .30657 Mdot
.09123 .30782 Mdot
.09139 .30878 Mdot
.09154 .30929 Mdot
.09169 .30969 Mdot
.09184 .31045 Mdot
.09199 .31182 Mdot
.09214 .31334 Mdot
.09229 .31389 Mdot
.09244 .31468 Mdot
.09259 .31476 Mdot
.09274 .31451 Mdot
.09289 .31385 Mdot
.09304 .31317 Mdot
.09319 .31204 Mdot
.09334 .31078 Mdot
.09349 .30888 Mdot
.09364 .30723 Mdot
.09379 .3053 Mdot
.09394 .30358 Mdot
.09409 .30269 Mdot
.09424 .30283 Mdot
.0944 .30327 Mdot
.09455 .30369 Mdot
.0947 .30516 Mdot
.09485 .30593 Mdot
.095 .30712 Mdot
.09515 .30868 Mdot
.0953 .31048 Mdot
.09545 .31208 Mdot
.0956 .31288 Mdot
.09575 .31414 Mdot
.0959 .31548 Mdot
.09605 .31556 Mdot
.0962 .31534 Mdot
.09635 .31435 Mdot
.0965 .31236 Mdot
.09665 .31073 Mdot
.0968 .30872 Mdot
.09695 .30714 Mdot
.0971 .30505 Mdot
.09725 .30334 Mdot
.09741 .30247 Mdot
.09756 .30227 Mdot
.09771 .30193 Mdot
.09786 .30174 Mdot
.09801 .30187 Mdot
.09816 .30143 Mdot
.09831 .30125 Mdot
.09846 .30151 Mdot
.09861 .30159 Mdot
.09876 .30357 Mdot
.09891 .30602 Mdot
.09906 .30883 Mdot
.09921 .31153 Mdot
.09936 .31484 Mdot
.09951 .31692 Mdot
.09966 .31833 Mdot
.09981 .31953 Mdot
.09996 .32042 Mdot
.10011 .31983 Mdot
.10026 .3175 Mdot
.10042 .31485 Mdot
.10057 .31332 Mdot
.10072 .31189 Mdot
.10087 .31056 Mdot
.10102 .31019 Mdot
.10117 .30949 Mdot
.10132 .30777 Mdot
.10147 .30493 Mdot
.10162 .30363 Mdot
.10177 .30363 Mdot
.10192 .30387 Mdot
.10207 .30399 Mdot
.10222 .30357 Mdot
.10237 .30374 Mdot
.10252 .30367 Mdot
.10267 .30445 Mdot
.10282 .30589 Mdot
.10297 .30624 Mdot
.10312 .30675 Mdot
.10327 .30845 Mdot
.10343 .30971 Mdot
.10358 .31064 Mdot
.10373 .31065 Mdot
.10388 .31126 Mdot
.10403 .31138 Mdot
.10418 .31049 Mdot
.10433 .30975 Mdot
.10448 .30783 Mdot
.10463 .30529 Mdot
.10478 .30443 Mdot
.10493 .30413 Mdot
.10508 .30271 Mdot
.10523 .30007 Mdot
.10538 .29957 Mdot
.10553 .29886 Mdot
.10568 .29921 Mdot
.10583 .29875 Mdot
.10598 .29812 Mdot
.10613 .29811 Mdot
.10628 .29868 Mdot
.10644 .29825 Mdot
.10659 .29945 Mdot
.10674 .30017 Mdot
.10689 .30249 Mdot
.10704 .30686 Mdot
.10719 .31078 Mdot
.10734 .3126 Mdot
.10749 .31421 Mdot
.10764 .31678 Mdot
.10779 .31948 Mdot
.10794 .32056 Mdot
.10809 .32013 Mdot
.10824 .31707 Mdot
.10839 .31595 Mdot
.10854 .3177 Mdot
.10869 .3187 Mdot
.10884 .31931 Mdot
.10899 .31635 Mdot
.10914 .31337 Mdot
.1093 .31319 Mdot
.10945 .31331 Mdot
.1096 .31084 Mdot
.10975 .30845 Mdot
.1099 .30606 Mdot
.11005 .3064 Mdot
.1102 .30638 Mdot
.11035 .30741 Mdot
.1105 .3051 Mdot
.11065 .30658 Mdot
.1108 .30785 Mdot
.11095 .30859 Mdot
.1111 .30613 Mdot
.11125 .30416 Mdot
.1114 .30533 Mdot
.11155 .30699 Mdot
.1117 .30777 Mdot
.11185 .30591 Mdot
.112 .30416 Mdot
.11215 .30337 Mdot
.11231 .30597 Mdot
.11246 .30754 Mdot
.11261 .30809 Mdot
.11276 .30853 Mdot
.11291 .31088 Mdot
.11306 .31237 Mdot
.11321 .31016 Mdot
.11336 .3029 Mdot
.11351 .30063 Mdot
.11366 .29937 Mdot
.11381 .29962 Mdot
.11396 .30199 Mdot
.11411 .30231 Mdot
.11426 .30187 Mdot
.11441 .30586 Mdot
.11456 .31077 Mdot
.11471 .31246 Mdot
.11486 .31151 Mdot
.11501 .31418 Mdot
.11516 .31785 Mdot
.11532 .32479 Mdot
.11547 .3263 Mdot
.11562 .32352 Mdot
.11577 .32252 Mdot
.11592 .32267 Mdot
.11607 .31968 Mdot
.11622 .31688 Mdot
.11637 .31072 Mdot
.11652 .30246 Mdot
.11667 .2971 Mdot
.11682 .29427 Mdot
.11697 .29029 Mdot
.11712 .2848 Mdot
.11727 .28488 Mdot
.11742 .28776 Mdot
.11757 .28608 Mdot
.11772 .28534 Mdot
.11787 .28537 Mdot
.11802 .28907 Mdot
.11817 .29782 Mdot
.11833 .30315 Mdot
.11848 .30663 Mdot
.11863 .30646 Mdot
.11878 .31137 Mdot
.11893 .31935 Mdot
.11908 .32648 Mdot
.11923 .32809 Mdot
.11938 .32367 Mdot
.11953 .31981 Mdot
.11968 .3219 Mdot
.11983 .32041 Mdot
.11998 .31616 Mdot
.12013 .30959 Mdot
.12028 .30914 Mdot
.12043 .31323 Mdot
.12058 .3151 Mdot
.12073 .31117 Mdot
.12088 .30532 Mdot
.12103 .30826 Mdot
.12118 .31298 Mdot
.12134 .31542 Mdot
.12149 .31871 Mdot
.12164 .31816 Mdot
.12179 .31535 Mdot
.12194 .32307 Mdot
.12209 .33319 Mdot
.12224 .33661 Mdot
.12239 .3313 Mdot
.12254 .32859 Mdot
.12269 .32597 Mdot
.12284 .31848 Mdot
.12299 .31022 Mdot
.12314 .30364 Mdot
.12329 .30206 Mdot
.12344 .30307 Mdot
.12359 .30496 Mdot
.12374 .30477 Mdot
.12389 .29858 Mdot
.12404 .2958 Mdot
.12419 .29628 Mdot
.12435 .29797 Mdot
.1245 .29193 Mdot
.12465 .2826 Mdot
.1248 .28032 Mdot
.12495 .28248 Mdot
.1251 .28336 Mdot
.12525 .28576 Mdot
.1254 .2876 Mdot
.12555 .29101 Mdot
.1257 .29787 Mdot
.12585 .30475 Mdot
.126 .30954 Mdot
.12615 .31661 Mdot
.1263 .323 Mdot
.12645 .32828 Mdot
.1266 .33161 Mdot
.12675 .33081 Mdot
.1269 .32774 Mdot
.12705 .32417 Mdot
.1272 .31712 Mdot
.12736 .30637 Mdot
.12751 .30031 Mdot
.12766 .29843 Mdot
.12781 .30181 Mdot
.12796 .30859 Mdot
.12811 .31742 Mdot
.12826 .32429 Mdot
.12841 .32352 Mdot
.12856 .32029 Mdot
.12871 .31244 Mdot
.12886 .29952 Mdot
.12901 .28913 Mdot
.12916 .28372 Mdot
.12931 .28779 Mdot
.12946 .29771 Mdot
.12961 .31341 Mdot
.12976 .32586 Mdot
.12991 .33507 Mdot
.13006 .34147 Mdot
.13021 .33557 Mdot
.13037 .32731 Mdot
.13052 .31561 Mdot
.13067 .3035 Mdot
.13082 .29391 Mdot
.13097 .28618 Mdot
.13112 .28185 Mdot
.13127 .2827 Mdot
.13142 .29115 Mdot
.13157 .30298 Mdot
.13172 .30855 Mdot
.13187 .31033 Mdot
.13202 .30311 Mdot
.13217 .29684 Mdot
.13232 .29743 Mdot
.13247 .30729 Mdot
.13262 .31471 Mdot
.13277 .32083 Mdot
.13292 .32335 Mdot
.13307 .3233 Mdot
.13322 .33063 Mdot
.13338 .3408 Mdot
.13353 .34561 Mdot
.13368 .35032 Mdot
.13383 .35537 Mdot
.13398 .35697 Mdot
.13413 .35114 Mdot
.13428 .34391 Mdot
.13443 .32995 Mdot
.13458 .30991 Mdot
.13473 .29123 Mdot
.13488 .27553 Mdot
.13503 .26414 Mdot
.13518 .26172 Mdot
.13533 .27469 Mdot
.13548 .29183 Mdot
.13563 .30439 Mdot
.13578 .30517 Mdot
.13593 .29956 Mdot
.13608 .29944 Mdot
.13624 .29904 Mdot
.13639 .29159 Mdot
.13654 .28679 Mdot
.13669 .28408 Mdot
.13684 .28227 Mdot
.13699 .29021 Mdot
.13714 .30687 Mdot
.13729 .31037 Mdot
.13744 .30863 Mdot
.13759 .30663 Mdot
.13774 .29683 Mdot
.13789 .29082 Mdot
.13804 .29277 Mdot
.13819 .29306 Mdot
.13834 .28607 Mdot
.13849 .28655 Mdot
.13864 .29281 Mdot
.13879 .30149 Mdot
.13894 .31631 Mdot
.13909 .32167 Mdot
.13925 .31181 Mdot
.1394 .31184 Mdot
.13955 .32827 Mdot
.1397 .35772 Mdot
.13985 .37808 Mdot
.14 .37927 Mdot
.14015 .36107 Mdot
.1403 .34403 Mdot
.14045 .33119 Mdot
.1406 .30537 Mdot
.14075 .28016 Mdot
.1409 .26581 Mdot
.14105 .2633 Mdot
.1412 .27879 Mdot
.14135 .2961 Mdot
.1415 .3047 Mdot
.14165 .31608 Mdot
.1418 .3338 Mdot
.14195 .33222 Mdot
.1421 .30801 Mdot
.14226 .28733 Mdot
.14241 .27945 Mdot
.14256 .28805 Mdot
.14271 .31726 Mdot
.14286 .34682 Mdot
.14301 .35724 Mdot
.14316 .36583 Mdot
.14331 .38505 Mdot
.14346 .38444 Mdot
.14361 .34698 Mdot
.14376 .30126 Mdot
.14391 .27354 Mdot
.14406 .27322 Mdot
.14421 .27862 Mdot
.14436 .2813 Mdot
.14451 .2857 Mdot
.14466 .29672 Mdot
.14481 .30851 Mdot
.14496 .3207 Mdot
.14511 .32323 Mdot
.14527 .30703 Mdot
.14542 .28501 Mdot
.14557 .2796 Mdot
.14572 .27135 Mdot
.14587 .2657 Mdot
.14602 .2812 Mdot
.14617 .31427 Mdot
.14632 .33162 Mdot
.14647 .32902 Mdot
.14662 .32947 Mdot
.14677 .33912 Mdot
.14692 .35702 Mdot
.14707 .38519 Mdot
.14722 .39383 Mdot
.14737 .37537 Mdot
.14752 .34196 Mdot
.14767 .31163 Mdot
.14782 .29314 Mdot
.14797 .27782 Mdot
.14812 .27002 Mdot
.14828 .27792 Mdot
.14843 .29522 Mdot
.14858 .30699 Mdot
.14873 .31352 Mdot
.14888 .31945 Mdot
.14903 .31422 Mdot
.14918 .29817 Mdot
.14933 .27932 Mdot
.14948 .24596 Mdot
.14963 .21663 Mdot
.14978 .21266 Mdot
.14993 .22064 Mdot
.15008 .23776 Mdot
.15023 .27321 Mdot
.15038 .31149 Mdot
.15053 .34146 Mdot
.15068 .36931 Mdot
.15083 .38588 Mdot
.15098 .37314 Mdot
.15113 .35441 Mdot
.15129 .34418 Mdot
.15144 .32764 Mdot
.15159 .31562 Mdot
.15174 .31293 Mdot
.15189 .30507 Mdot
.15204 .2991 Mdot
.15219 .31044 Mdot
.15234 .33034 Mdot
.15249 .34813 Mdot
.15264 .36088 Mdot
.15279 .35463 Mdot
.15294 .32784 Mdot
.15309 .31047 Mdot
.15324 .30294 Mdot
.15339 .29059 Mdot
.15354 .27987 Mdot
.15369 .27307 Mdot
.15384 .26846 Mdot
.15399 .27913 Mdot
.15414 .29932 Mdot
.1543 .31652 Mdot
.15445 .335 Mdot
.1546 .35945 Mdot
.15475 .35882 Mdot
.1549 .3446 Mdot
.15505 .32489 Mdot
.1552 .29421 Mdot
.15535 .27077 Mdot
.1555 .27089 Mdot
.15565 .27637 Mdot
.1558 .28471 Mdot
.15595 .29889 Mdot
.1561 .32537 Mdot
.15625 .35472 Mdot
.1564 .38544 Mdot
.15655 .38826 Mdot
.1567 .3696 Mdot
.15685 .35787 Mdot
.157 .34204 Mdot
.15715 .30968 Mdot
.15731 .27688 Mdot
.15746 .27358 Mdot
.15761 .28343 Mdot
.15776 .29159 Mdot
.15791 .29644 Mdot
.15806 .27698 Mdot
.15821 .25618 Mdot
.15836 .26425 Mdot
.15851 .2891 Mdot
.15866 .29917 Mdot
.15881 .29062 Mdot
.15896 .27443 Mdot
.15911 .25656 Mdot
.15926 .26499 Mdot
.15941 .3023 Mdot
.15956 .33177 Mdot
.15971 .34826 Mdot
.15986 .36054 Mdot
.16001 .37014 Mdot
.16016 .37313 Mdot
.16032 .376 Mdot
.16047 .37128 Mdot
.16062 .34567 Mdot
.16077 .31066 Mdot
.16092 .26702 Mdot
.16107 .23894 Mdot
.16122 .24455 Mdot
.16137 .27417 Mdot
.16152 .3078 Mdot
.16167 .33538 Mdot
.16182 .3529 Mdot
.16197 .35346 Mdot
.16212 .33552 Mdot
.16227 .29982 Mdot
.16242 .24847 Mdot
.16257 .20247 Mdot
.16272 .17085 Mdot
.16287 .16565 Mdot
.16302 .19396 Mdot
.16318 .24427 Mdot
.16333 .30397 Mdot
.16348 .36476 Mdot
.16363 .41589 Mdot
.16378 .43301 Mdot
.16393 .42165 Mdot
.16408 .40214 Mdot
.16423 .37179 Mdot
.16438 .31559 Mdot
.16453 .27311 Mdot
.16468 .27464 Mdot
.16483 .31205 Mdot
.16498 .35952 Mdot
.16513 .39443 Mdot
.16528 .39817 Mdot
.16543 .38439 Mdot
.16558 .35778 Mdot
.16573 .33436 Mdot
.16588 .31014 Mdot
.16603 .28929 Mdot
.16619 .26428 Mdot
.16634 .23241 Mdot
.16649 .204 Mdot
.16664 .17719 Mdot
.16679 .18083 Mdot
.16694 .20918 Mdot
.16709 .24838 Mdot
.16724 .27688 Mdot
.16739 .3016 Mdot
.16754 .33498 Mdot
.16769 .37156 Mdot
.16784 .39964 Mdot
.16799 .40936 Mdot
.16814 .3853 Mdot
.16829 .3465 Mdot
.16844 .31924 Mdot
.16859 .31428 Mdot
.16874 .31164 Mdot
.16889 .3144 Mdot
.16904 .33759 Mdot
.1692 .36717 Mdot
.16935 .38472 Mdot
.1695 .39053 Mdot
.16965 .38457 Mdot
.1698 .35839 Mdot
.16995 .31006 Mdot
.1701 .25547 Mdot
.17025 .19943 Mdot
.1704 .17529 Mdot
.17055 .19387 Mdot
.1707 .24128 Mdot
.17085 .27659 Mdot
.171 .28821 Mdot
.17115 .29568 Mdot
.1713 .31167 Mdot
.17145 .32841 Mdot
.1716 .32411 Mdot
.17175 .29719 Mdot
.1719 .26234 Mdot
.17205 .24527 Mdot
.17221 .25758 Mdot
.17236 .28245 Mdot
.17251 .31193 Mdot
.17266 .34226 Mdot
.17281 .36287 Mdot
.17296 .37157 Mdot
.17311 .3777 Mdot
.17326 .38347 Mdot
.17341 .38015 Mdot
.17356 .37008 Mdot
.17371 .35306 Mdot
.17386 .32072 Mdot
.17401 .28595 Mdot
.17416 .27493 Mdot
.17431 .28572 Mdot
.17446 .28816 Mdot
.17461 .2785 Mdot
.17476 .2762 Mdot
.17491 .27474 Mdot
.17506 .28683 Mdot
.17522 .29115 Mdot
.17537 .28605 Mdot
.17552 .27634 Mdot
.17567 .26767 Mdot
.17582 .25247 Mdot
.17597 .2365 Mdot
.17612 .23715 Mdot
.17627 .27643 Mdot
.17642 .32785 Mdot
.17657 .36899 Mdot
.17672 .38603 Mdot
.17687 .39557 Mdot
.17702 .40141 Mdot
.17717 .39596 Mdot
.17732 .37102 Mdot
.17747 .32253 Mdot
.17762 .29242 Mdot
.17777 .28739 Mdot
.17792 .29052 Mdot
.17807 .2907 Mdot
.17823 .28456 Mdot
.17838 .28423 Mdot
.17853 .30199 Mdot
.17868 .33453 Mdot
.17883 .36054 Mdot
.17898 .35192 Mdot
.17913 .32462 Mdot
.17928 .29814 Mdot
.17943 .27293 Mdot
.17958 .25387 Mdot
.17973 .25633 Mdot
.17988 .28193 Mdot
.18003 .31126 Mdot
.18018 .31456 Mdot
.18033 .294 Mdot
.18048 .27509 Mdot
.18063 .28453 Mdot
.18078 .30721 Mdot
.18093 .31616 Mdot
.18108 .30137 Mdot
.18124 .28655 Mdot
.18139 .28653 Mdot
.18154 .29663 Mdot
.18169 .30768 Mdot
.18184 .32104 Mdot
.18199 .33952 Mdot
.18214 .3612 Mdot
.18229 .36715 Mdot
.18244 .36304 Mdot
.18259 .35882 Mdot
.18274 .35633 Mdot
.18289 .34263 Mdot
.18304 .31818 Mdot
.18319 .28089 Mdot
.18334 .25128 Mdot
.18349 .24679 Mdot
.18364 .25629 Mdot
.18379 .26593 Mdot
.18394 .27546 Mdot
.18409 .28726 Mdot
.18425 .30847 Mdot
.1844 .32873 Mdot
.18455 .31519 Mdot
.1847 .28201 Mdot
.18485 .2648 Mdot
.185 .27461 Mdot
.18515 .28838 Mdot
.1853 .29593 Mdot
.18545 .30453 Mdot
.1856 .31717 Mdot
.18575 .32306 Mdot
.1859 .32213 Mdot
.18605 .31988 Mdot
.1862 .32684 Mdot
.18635 .33257 Mdot
.1865 .3263 Mdot
.18665 .30522 Mdot
.1868 .2891 Mdot
.18695 .28317 Mdot
.1871 .2912 Mdot
.18726 .30538 Mdot
.18741 .31176 Mdot
.18756 .29729 Mdot
.18771 .28547 Mdot
.18786 .27981 Mdot
.18801 .27854 Mdot
.18816 .28255 Mdot
.18831 .29444 Mdot
.18846 .30521 Mdot
.18861 .30357 Mdot
.18876 .28481 Mdot
.18891 .26645 Mdot
.18906 .2608 Mdot
.18921 .27493 Mdot
.18936 .29763 Mdot
.18951 .3062 Mdot
.18966 .30588 Mdot
.18981 .3195 Mdot
.18996 .34415 Mdot
.19011 .35963 Mdot
.19027 .36351 Mdot
.19042 .36496 Mdot
.19057 .36557 Mdot
.19072 .3641 Mdot
.19087 .35658 Mdot
.19102 .34183 Mdot
.19117 .33326 Mdot
.19132 .33546 Mdot
.19147 .34187 Mdot
.19162 .33743 Mdot
.19177 .32277 Mdot
.19192 .30567 Mdot
.19207 .29374 Mdot
.19222 .27837 Mdot
.19237 .26171 Mdot
.19252 .25333 Mdot
.19267 .26404 Mdot
.19282 .2807 Mdot
.19297 .28837 Mdot
.19313 .27693 Mdot
.19328 .26992 Mdot
.19343 .28583 Mdot
.19358 .31618 Mdot
.19373 .33489 Mdot
.19388 .3417 Mdot
.19403 .33678 Mdot
.19418 .32879 Mdot
.19433 .3307 Mdot
.19448 .3336 Mdot
.19463 .32199 Mdot
.19478 .29993 Mdot
.19493 .284 Mdot
.19508 .27855 Mdot
.19523 .2722 Mdot
.19538 .26404 Mdot
.19553 .26906 Mdot
.19568 .28898 Mdot
.19583 .29615 Mdot
.19598 .28163 Mdot
.19614 .2674 Mdot
.19629 .26344 Mdot
.19644 .2728 Mdot
.19659 .28471 Mdot
.19674 .29516 Mdot
.19689 .30247 Mdot
.19704 .30856 Mdot
.19719 .31308 Mdot
.19734 .31514 Mdot
.19749 .31655 Mdot
.19764 .31993 Mdot
.19779 .3181 Mdot
.19794 .31904 Mdot
.19809 .32651 Mdot
.19824 .32967 Mdot
.19839 .32804 Mdot
.19854 .3357 Mdot
.19869 .34494 Mdot
.19884 .34485 Mdot
.19899 .34069 Mdot
.19915 .33227 Mdot
.1993 .31734 Mdot
.19945 .30438 Mdot
.1996 .30162 Mdot
.19975 .30329 Mdot
.1999 .307 Mdot
.20005 .30734 Mdot
.2002 .30163 Mdot
.20035 .29301 Mdot
.2005 .28314 Mdot
.20065 .28104 Mdot
.2008 .2764 Mdot
.20095 .27846 Mdot
.2011 .28971 Mdot
.20125 .29768 Mdot
.2014 .30573 Mdot
.20155 .31316 Mdot
.2017 .32308 Mdot
.20185 .33633 Mdot
.202 .34649 Mdot
.20216 .34259 Mdot
.20231 .33179 Mdot
.20246 .33294 Mdot
.20261 .34293 Mdot
.20276 .34467 Mdot
.20291 .3427 Mdot
.20306 .32808 Mdot
.20321 .31536 Mdot
.20336 .32002 Mdot
.20351 .32563 Mdot
.20366 .31279 Mdot
.20381 .29174 Mdot
.20396 .29413 Mdot
.20411 .30702 Mdot
.20426 .31468 Mdot
.20441 .3183 Mdot
.20456 .31368 Mdot
.20471 .30442 Mdot
.20486 .31068 Mdot
.20501 .32302 Mdot
.20517 .32897 Mdot
.20532 .32582 Mdot
.20547 .32973 Mdot
.20562 .33418 Mdot
.20577 .32932 Mdot
.20592 .32045 Mdot
.20607 .3163 Mdot
.20622 .31802 Mdot
.20637 .31167 Mdot
.20652 .29259 Mdot
.20667 .27222 Mdot
.20682 .25704 Mdot
.20697 .26559 Mdot
.20712 .28556 Mdot
.20727 .29565 Mdot
.20742 .28534 Mdot
.20757 .28058 Mdot
.20772 .29034 Mdot
.20787 .30066 Mdot
.20802 .30273 Mdot
.20818 .29888 Mdot
.20833 .2915 Mdot
.20848 .29324 Mdot
.20863 .29979 Mdot
.20878 .29788 Mdot
.20893 .2999 Mdot
.20908 .3125 Mdot
.20923 .31543 Mdot
.20938 .30751 Mdot
.20953 .30411 Mdot
.20968 .30936 Mdot
.20983 .32155 Mdot
.20998 .33145 Mdot
.21013 .32617 Mdot
.21028 .31061 Mdot
.21043 .30532 Mdot
.21058 .30637 Mdot
.21073 .30868 Mdot
.21088 .31086 Mdot
.21103 .3145 Mdot
.21119 .32526 Mdot
.21134 .34183 Mdot
.21149 .35576 Mdot
.21164 .34921 Mdot
.21179 .33493 Mdot
.21194 .32661 Mdot
.21209 .31568 Mdot
.21224 .30784 Mdot
.21239 .30454 Mdot
.21254 .30371 Mdot
.21269 .30834 Mdot
.21284 .32476 Mdot
.21299 .34039 Mdot
.21314 .3381 Mdot
.21329 .33745 Mdot
.21344 .33163 Mdot
.21359 .31753 Mdot
.21374 .30286 Mdot
.21389 .29145 Mdot
.21404 .28403 Mdot
.2142 .28721 Mdot
.21435 .30221 Mdot
.2145 .31588 Mdot
.21465 .32117 Mdot
.2148 .32511 Mdot
.21495 .32077 Mdot
.2151 .31228 Mdot
.21525 .30928 Mdot
.2154 .31287 Mdot
.21555 .31422 Mdot
.2157 .31373 Mdot
.21585 .31327 Mdot
.216 .3157 Mdot
.21615 .32939 Mdot
.2163 .34424 Mdot
.21645 .34682 Mdot
.2166 .3445 Mdot
.21675 .34283 Mdot
.2169 .34167 Mdot
.21705 .34025 Mdot
.21721 .34056 Mdot
.21736 .32596 Mdot
.21751 .30346 Mdot
.21766 .28731 Mdot
.21781 .27589 Mdot
.21796 .26396 Mdot
.21811 .25263 Mdot
.21826 .25091 Mdot
.21841 .25699 Mdot
.21856 .27485 Mdot
.21871 .29171 Mdot
.21886 .29526 Mdot
.21901 .29471 Mdot
.21916 .29851 Mdot
.21931 .2968 Mdot
.21946 .29062 Mdot
.21961 .27957 Mdot
.21976 .27071 Mdot
.21991 .26964 Mdot
.22007 .27804 Mdot
.22022 .28351 Mdot
.22037 .29032 Mdot
.22052 .29193 Mdot
.22067 .28637 Mdot
.22082 .29171 Mdot
.22097 .30132 Mdot
.22112 .30153 Mdot
.22127 .29336 Mdot
.22142 .28895 Mdot
.22157 .29235 Mdot
.22172 .30812 Mdot
.22187 .32925 Mdot
.22202 .33024 Mdot
.22217 .32041 Mdot
.22232 .32776 Mdot
.22247 .34448 Mdot
.22262 .36977 Mdot
.22277 .38724 Mdot
.22292 .38493 Mdot
.22308 .3653 Mdot
.22323 .35409 Mdot
.22338 .34601 Mdot
.22353 .31671 Mdot
.22368 .28784 Mdot
.22383 .27364 Mdot
.22398 .26994 Mdot
.22413 .27991 Mdot
.22428 .28936 Mdot
.22443 .29574 Mdot
.22458 .31805 Mdot
.22473 .34983 Mdot
.22488 .35172 Mdot
.22503 .32533 Mdot
.22518 .30117 Mdot
.22533 .29361 Mdot
.22548 .30711 Mdot
.22563 .33654 Mdot
.22578 .35874 Mdot
.22593 .36317 Mdot
.22609 .37031 Mdot
.22624 .39022 Mdot
.22639 .39248 Mdot
.22654 .35635 Mdot
.22669 .30748 Mdot
.22684 .27217 Mdot
.22699 .2618 Mdot
.22714 .25386 Mdot
.22729 .24515 Mdot
.22744 .24798 Mdot
.22759 .26113 Mdot
.22774 .2778 Mdot
.22789 .29703 Mdot
.22804 .3074 Mdot
.22819 .29936 Mdot
.22834 .2861 Mdot
.22849 .28574 Mdot
.22864 .27345 Mdot
.22879 .26311 Mdot
.22894 .27648 Mdot
.2291 .30932 Mdot
.22925 .3259 Mdot
.2294 .32163 Mdot
.22955 .32097 Mdot
.2297 .33405 Mdot
.22985 .35911 Mdot
.23 .39281 Mdot
.23015 .40324 Mdot
.2303 .38665 Mdot
.23045 .34835 Mdot
.2306 .31012 Mdot
.23075 .28446 Mdot
.2309 .26045 Mdot
.23105 .24486 Mdot
.2312 .25302 Mdot
.23135 .2697 Mdot
.2315 .27343 Mdot
.23165 .27594 Mdot
.2318 .28991 Mdot
.23195 .2949 Mdot
.23211 .29013 Mdot
.23226 .28559 Mdot
.23241 .25894 Mdot
.23256 .22929 Mdot
.23271 .23261 Mdot
.23286 .25422 Mdot
.23301 .2711 Mdot
.23316 .29435 Mdot
.23331 .32637 Mdot
.23346 .35529 Mdot
.23361 .38245 Mdot
.23376 .40481 Mdot
.23391 .39383 Mdot
.23406 .37315 Mdot
.23421 .36452 Mdot
.23436 .35385 Mdot
.23451 .3386 Mdot
.23466 .32903 Mdot
.23481 .31906 Mdot
.23496 .30968 Mdot
.23512 .31042 Mdot
.23527 .31792 Mdot
.23542 .32471 Mdot
.23557 .33226 Mdot
.23572 .33032 Mdot
.23587 .31553 Mdot
.23602 .30283 Mdot
.23617 .29423 Mdot
.23632 .28312 Mdot
.23647 .28107 Mdot
.23662 .28713 Mdot
.23677 .28921 Mdot
.23692 .29437 Mdot
.23707 .30862 Mdot
.23722 .32892 Mdot
.23737 .348 Mdot
.23752 .3656 Mdot
.23767 .35523 Mdot
.23782 .33512 Mdot
.23797 .30951 Mdot
.23813 .27832 Mdot
.23828 .25654 Mdot
.23843 .25261 Mdot
.23858 .25534 Mdot
.23873 .26497 Mdot
.23888 .27881 Mdot
.23903 .30237 Mdot
.23918 .33251 Mdot
.23933 .36253 Mdot
.23948 .36581 Mdot
.23963 .34909 Mdot
.23978 .33652 Mdot
.23993 .31534 Mdot
.24008 .28457 Mdot
.24023 .26173 Mdot
.24038 .26487 Mdot
.24053 .27988 Mdot
.24068 .30087 Mdot
.24083 .31486 Mdot
.24098 .29718 Mdot
.24114 .27805 Mdot
.24129 .28592 Mdot
.24144 .30551 Mdot
.24159 .31468 Mdot
.24174 .30512 Mdot
.24189 .27678 Mdot
.24204 .24531 Mdot
.24219 .25111 Mdot
.24234 .29233 Mdot
.24249 .32404 Mdot
.24264 .34222 Mdot
.24279 .35561 Mdot
.24294 .36825 Mdot
.24309 .37816 Mdot
.24324 .38675 Mdot
.24339 .37931 Mdot
.24354 .34665 Mdot
.24369 .30846 Mdot
.24384 .26659 Mdot
.24399 .24504 Mdot
.24415 .25406 Mdot
.2443 .27811 Mdot
.24445 .30854 Mdot
.2446 .34077 Mdot
.24475 .35972 Mdot
.2449 .36028 Mdot
.24505 .34979 Mdot
.2452 .32104 Mdot
.24535 .26888 Mdot
.2455 .218 Mdot
.24565 .18058 Mdot
.2458 .16595 Mdot
.24595 .19127 Mdot
.2461 .24952 Mdot
.24625 .30977 Mdot
.2464 .36437 Mdot
.24655 .41155 Mdot
.2467 .42863 Mdot
.24685 .41932 Mdot
.247 .40295 Mdot
.24716 .37657 Mdot
.24731 .3195 Mdot
.24746 .27914 Mdot
.24761 .28564 Mdot
.24776 .324 Mdot
.24791 .37114 Mdot
.24806 .40691 Mdot
.24821 .40592 Mdot
.24836 .38235 Mdot
.24851 .35215 Mdot
.24866 .32766 Mdot
.24881 .29692 Mdot
.24896 .27101 Mdot
.24911 .24353 Mdot
.24926 .20888 Mdot
.24941 .18106 Mdot
.24956 .16323 Mdot
.24971 .17303 Mdot
.24986 .20159 Mdot
.25002 .24103 Mdot
.25017 .26922 Mdot
.25032 .29228 Mdot
.25047 .32495 Mdot
.25062 .36213 Mdot
.25077 .38857 Mdot
.25092 .39785 Mdot
.25107 .37564 Mdot
.25122 .33792 Mdot
.25137 .31103 Mdot
.25152 .31147 Mdot
.25167 .31297 Mdot
.25182 .31762 Mdot
.25197 .34177 Mdot
.25212 .36845 Mdot
.25227 .3812 Mdot
.25242 .38501 Mdot
.25257 .37441 Mdot
.25272 .33913 Mdot
.25287 .28301 Mdot
.25303 .22781 Mdot
.25318 .17261 Mdot
.25333 .15333 Mdot
.25348 .18039 Mdot
.25363 .23395 Mdot
.25378 .2724 Mdot
.25393 .29332 Mdot
.25408 .31447 Mdot
.25423 .33626 Mdot
.25438 .35192 Mdot
.25453 .3469 Mdot
.25468 .31481 Mdot
.25483 .27643 Mdot
.25498 .26109 Mdot
.25513 .27842 Mdot
.25528 .30478 Mdot
.25543 .34116 Mdot
.25558 .37466 Mdot
.25573 .3931 Mdot
.25588 .40049 Mdot
.25604 .40753 Mdot
.25619 .40685 Mdot
.25634 .39268 Mdot
.25649 .37416 Mdot
.25664 .34977 Mdot
.25679 .31137 Mdot
.25694 .27724 Mdot
.25709 .26965 Mdot
.25724 .27913 Mdot
.25739 .2827 Mdot
.25754 .27676 Mdot
.25769 .27716 Mdot
.25784 .27581 Mdot
.25799 .28722 Mdot
.25814 .29059 Mdot
.25829 .2839 Mdot
.25844 .27435 Mdot
.25859 .26806 Mdot
.25874 .25308 Mdot
.25889 .23983 Mdot
.25905 .2431 Mdot
.2592 .28121 Mdot
.25935 .33094 Mdot
.2595 .36912 Mdot
.25965 .38144 Mdot
.2598 .3867 Mdot
.25995 .39158 Mdot
.2601 .38204 Mdot
.26025 .3505 Mdot
.2604 .29962 Mdot
.26055 .2707 Mdot
.2607 .26776 Mdot
.26085 .27028 Mdot
.261 .27132 Mdot
.26115 .26853 Mdot
.2613 .27149 Mdot
.26145 .29147 Mdot
.2616 .32392 Mdot
.26175 .34691 Mdot
.2619 .3365 Mdot
.26206 .30932 Mdot
.26221 .28802 Mdot
.26236 .26974 Mdot
.26251 .25574 Mdot
.26266 .26178 Mdot
.26281 .29223 Mdot
.26296 .32705 Mdot
.26311 .33116 Mdot
.26326 .30824 Mdot
.26341 .28977 Mdot
.26356 .29938 Mdot
.26371 .32141 Mdot
.26386 .32686 Mdot
.26401 .30839 Mdot
.26416 .29174 Mdot
.26431 .29214 Mdot
.26446 .30568 Mdot
.26461 .31758 Mdot
.26476 .33179 Mdot
.26491 .34939 Mdot
.26507 .3701 Mdot
.26522 .37625 Mdot
.26537 .37088 Mdot
.26552 .36585 Mdot
.26567 .36242 Mdot
.26582 .34921 Mdot
.26597 .32285 Mdot
.26612 .28502 Mdot
.26627 .25484 Mdot
.26642 .2466 Mdot
.26657 .25041 Mdot
.26672 .25838 Mdot
.26687 .26841 Mdot
.26702 .28356 Mdot
.26717 .30938 Mdot
.26732 .33255 Mdot
.26747 .31425 Mdot
.26762 .27227 Mdot
.26777 .25173 Mdot
.26792 .26357 Mdot
.26808 .27909 Mdot
.26823 .28672 Mdot
.26838 .29821 Mdot
.26853 .31311 Mdot
.26868 .3223 Mdot
.26883 .32593 Mdot
.26898 .32779 Mdot
.26913 .33846 Mdot
.26928 .34952 Mdot
.26943 .34978 Mdot
.26958 .32955 Mdot
.26973 .30882 Mdot
.26988 .2984 Mdot
.27003 .30879 Mdot
.27018 .3287 Mdot
.27033 .338 Mdot
.27048 .32041 Mdot
.27063 .29811 Mdot
.27078 .28033 Mdot
.27093 .26964 Mdot
.27109 .27333 Mdot
.27124 .2859 Mdot
.27139 .29973 Mdot
.27154 .30085 Mdot
.27169 .2869 Mdot
.27184 .27279 Mdot
.27199 .26725 Mdot
.27214 .28443 Mdot
.27229 .31586 Mdot
.27244 .32716 Mdot
.27259 .32488 Mdot
.27274 .33326 Mdot
.27289 .35429 Mdot
.27304 .36941 Mdot
.27319 .37526 Mdot
.27334 .37533 Mdot
.27349 .37075 Mdot
.27364 .36327 Mdot
.27379 .35554 Mdot
.27394 .34156 Mdot
.2741 .33241 Mdot
.27425 .32815 Mdot
.2744 .32561 Mdot
.27455 .31515 Mdot
.2747 .29622 Mdot
.27485 .27651 Mdot
.275 .25767 Mdot
.27515 .23232 Mdot
.2753 .2099 Mdot
.27545 .20306 Mdot
.2756 .22116 Mdot
.27575 .25142 Mdot
.2759 .27206 Mdot
.27605 .27348 Mdot
.2762 .27507 Mdot
.27635 .30055 Mdot
.2765 .33315 Mdot
.27665 .35089 Mdot
.2768 .35409 Mdot
.27696 .34185 Mdot
.27711 .31853 Mdot
.27726 .30643 Mdot
.27741 .3071 Mdot
.27756 .29947 Mdot
.27771 .28314 Mdot
.27786 .27603 Mdot
.27801 .27721 Mdot
.27816 .27299 Mdot
.27831 .27061 Mdot
.27846 .28513 Mdot
.27861 .30769 Mdot
.27876 .30438 Mdot
.27891 .27449 Mdot
.27906 .25335 Mdot
.27921 .2535 Mdot
.27936 .26999 Mdot
.27951 .29595 Mdot
.27966 .32272 Mdot
.27981 .34037 Mdot
.27997 .35663 Mdot
.28012 .37505 Mdot
.28027 .38707 Mdot
.28042 .39176 Mdot
.28057 .39422 Mdot
.28072 .38064 Mdot
.28087 .3556 Mdot
.28102 .33097 Mdot
.28117 .30585 Mdot
.28132 .29407 Mdot
.28147 .30327 Mdot
.28162 .31278 Mdot
.28177 .31492 Mdot
.28192 .32347 Mdot
.28207 .3289 Mdot
.28222 .32562 Mdot
.28237 .32381 Mdot
.28252 .32325 Mdot
.28267 .32282 Mdot
.28282 .32916 Mdot
.28298 .33736 Mdot
.28313 .33041 Mdot
.28328 .31172 Mdot
.28343 .30048 Mdot
.28358 .30701 Mdot
.28373 .31825 Mdot
.28388 .32958 Mdot
.28403 .33774 Mdot
.28418 .33919 Mdot
.28433 .3377 Mdot
.28448 .33455 Mdot
.28463 .32569 Mdot
.28478 .31859 Mdot
.28493 .31118 Mdot
.28508 .29182 Mdot
.28523 .26199 Mdot
.28538 .24215 Mdot
.28553 .23701 Mdot
.28568 .23929 Mdot
.28583 .24967 Mdot
.28599 .25456 Mdot
.28614 .2482 Mdot
.28629 .2488 Mdot
.28644 .25743 Mdot
.28659 .2683 Mdot
.28674 .2733 Mdot
.28689 .28678 Mdot
.28704 .3059 Mdot
.28719 .32176 Mdot
.28734 .33107 Mdot
.28749 .33587 Mdot
.28764 .34172 Mdot
.28779 .34613 Mdot
.28794 .34399 Mdot
.28809 .34511 Mdot
.28824 .34311 Mdot
.28839 .3375 Mdot
.28854 .33319 Mdot
.28869 .32814 Mdot
.28884 .31578 Mdot
.289 .30465 Mdot
.28915 .29938 Mdot
.2893 .28815 Mdot
.28945 .26627 Mdot
.2896 .24465 Mdot
.28975 .23164 Mdot
.2899 .23568 Mdot
.29005 .25309 Mdot
.2902 .27204 Mdot
.29035 .28416 Mdot
.2905 .30659 Mdot
.29065 .33984 Mdot
.2908 .37106 Mdot
.29095 .39434 Mdot
.2911 .41469 Mdot
.29125 .42812 Mdot
.2914 .43046 Mdot
.29155 .41985 Mdot
.2917 .39637 Mdot
.29185 .3781 Mdot
.29201 .36192 Mdot
.29216 .34013 Mdot
.29231 .30971 Mdot
.29246 .28563 Mdot
.29261 .27879 Mdot
.29276 .28798 Mdot
.29291 .29648 Mdot
.29306 .29218 Mdot
.29321 .28407 Mdot
.29336 .27767 Mdot
.29351 .26683 Mdot
.29366 .25012 Mdot
.29381 .2404 Mdot
.29396 .23591 Mdot
.29411 .2457 Mdot
.29426 .27395 Mdot
.29441 .30289 Mdot
.29456 .31769 Mdot
.29471 .34147 Mdot
.29486 .37887 Mdot
.29502 .39835 Mdot
.29517 .39221 Mdot
.29532 .37272 Mdot
.29547 .34398 Mdot
.29562 .3265 Mdot
.29577 .32692 Mdot
.29592 .32299 Mdot
.29607 .30247 Mdot
.29622 .28798 Mdot
.29637 .28039 Mdot
.29652 .26803 Mdot
.29667 .25704 Mdot
.29682 .25592 Mdot
.29697 .25302 Mdot
.29712 .25032 Mdot
.29727 .25191 Mdot
.29742 .25559 Mdot
.29757 .25416 Mdot
.29772 .25887 Mdot
.29787 .27246 Mdot
.29803 .28504 Mdot
.29818 .29545 Mdot
.29833 .30604 Mdot
.29848 .31717 Mdot
.29863 .32746 Mdot
.29878 .33828 Mdot
.29893 .35057 Mdot
.29908 .35878 Mdot
.29923 .36386 Mdot
.29938 .36062 Mdot
.29953 .34451 Mdot
.29968 .32566 Mdot
.29983 .31274 Mdot
.29998 .30894 Mdot
.30013 .30806 Mdot
.30028 .30541 Mdot
.30043 .30232 Mdot
.30058 .29728 Mdot
.30073 .28587 Mdot
.30088 .26941 Mdot
.30104 .25528 Mdot
.30119 .24804 Mdot
.30134 .2478 Mdot
.30149 .25931 Mdot
.30164 .27367 Mdot
.30179 .28923 Mdot
.30194 .30663 Mdot
.30209 .33256 Mdot
.30224 .35856 Mdot
.30239 .37645 Mdot
.30254 .38124 Mdot
.30269 .37076 Mdot
.30284 .34952 Mdot
.30299 .32419 Mdot
.30314 .31222 Mdot
.30329 .31319 Mdot
.30344 .30868 Mdot
.30359 .30445 Mdot
.30374 .30766 Mdot
.3039 .31362 Mdot
.30405 .31603 Mdot
.3042 .3193 Mdot
.30435 .3204 Mdot
.3045 .31625 Mdot
.30465 .31499 Mdot
.3048 .31336 Mdot
.30495 .30325 Mdot
.3051 .29282 Mdot
.30525 .28405 Mdot
.3054 .27879 Mdot
.30555 .2838 Mdot
.3057 .29791 Mdot
.30585 .31257 Mdot
.306 .32881 Mdot
.30615 .35094 Mdot
.3063 .35885 Mdot
.30645 .35603 Mdot
.3066 .35394 Mdot
.30675 .34906 Mdot
.30691 .33335 Mdot
.30706 .30521 Mdot
.30721 .27134 Mdot
.30736 .24655 Mdot
.30751 .24667 Mdot
.30766 .26645 Mdot
.30781 .28603 Mdot
.30796 .29762 Mdot
.30811 .30468 Mdot
.30826 .31069 Mdot
.30841 .31308 Mdot
.30856 .30376 Mdot
.30871 .29193 Mdot
.30886 .28569 Mdot
.30901 .28488 Mdot
.30916 .28216 Mdot
.30931 .28047 Mdot
.30946 .28233 Mdot
.30961 .28752 Mdot
.30976 .29386 Mdot
.30992 .29879 Mdot
.31007 .2952 Mdot
.31022 .28702 Mdot
.31037 .28421 Mdot
.31052 .27987 Mdot
.31067 .26983 Mdot
.31082 .26185 Mdot
.31097 .26335 Mdot
.31112 .27435 Mdot
.31127 .28559 Mdot
.31142 .28787 Mdot
.31157 .28272 Mdot
.31172 .27755 Mdot
.31187 .27665 Mdot
.31202 .27985 Mdot
.31217 .28866 Mdot
.31232 .30526 Mdot
.31247 .32222 Mdot
.31262 .33514 Mdot
.31277 .34041 Mdot
.31293 .34566 Mdot
.31308 .3579 Mdot
.31323 .37398 Mdot
.31338 .38185 Mdot
.31353 .37781 Mdot
.31368 .36412 Mdot
.31383 .3431 Mdot
.31398 .32841 Mdot
.31413 .3218 Mdot
.31428 .30933 Mdot
.31443 .29366 Mdot
.31458 .28677 Mdot
.31473 .28306 Mdot
.31488 .278 Mdot
.31503 .28692 Mdot
.31518 .31127 Mdot
.31533 .33308 Mdot
.31548 .34375 Mdot
.31563 .35191 Mdot
.31578 .35231 Mdot
.31594 .339 Mdot
.31609 .32405 Mdot
.31624 .31778 Mdot
.31639 .31453 Mdot
.31654 .32181 Mdot
.31669 .34077 Mdot
.31684 .3533 Mdot
.31699 .36356 Mdot
.31714 .38183 Mdot
.31729 .39749 Mdot
.31744 .39602 Mdot
.31759 .38557 Mdot
.31774 .36528 Mdot
.31789 .32552 Mdot
.31804 .2799 Mdot
.31819 .2412 Mdot
.31834 .20985 Mdot
.31849 .19229 Mdot
.31864 .19442 Mdot
.31879 .20853 Mdot
.31895 .22072 Mdot
.3191 .23 Mdot
.31925 .23893 Mdot
.3194 .2511 Mdot
.31955 .26773 Mdot
.3197 .27828 Mdot
.31985 .27195 Mdot
.32 .25839 Mdot
.32015 .25497 Mdot
.3203 .25726 Mdot
.32045 .26101 Mdot
.3206 .27526 Mdot
.32075 .29715 Mdot
.3209 .31831 Mdot
.32105 .33842 Mdot
.3212 .34863 Mdot
.32135 .3411 Mdot
.3215 .33232 Mdot
.32165 .32834 Mdot
.3218 .31407 Mdot
.32196 .29309 Mdot
.32211 .27393 Mdot
.32226 .25269 Mdot
.32241 .24009 Mdot
.32256 .23936 Mdot
.32271 .2434 Mdot
.32286 .24465 Mdot
.32301 .26306 Mdot
.32316 .29337 Mdot
.32331 .30568 Mdot
.32346 .30914 Mdot
.32361 .32491 Mdot
.32376 .34389 Mdot
.32391 .35331 Mdot
.32406 .36254 Mdot
.32421 .36458 Mdot
.32436 .35828 Mdot
.32451 .36532 Mdot
.32466 .37789 Mdot
.32481 .37261 Mdot
.32497 .35657 Mdot
.32512 .35791 Mdot
.32527 .37139 Mdot
.32542 .37581 Mdot
.32557 .36942 Mdot
.32572 .35627 Mdot
.32587 .34212 Mdot
.32602 .33889 Mdot
.32617 .34192 Mdot
.32632 .33504 Mdot
.32647 .31606 Mdot
.32662 .30348 Mdot
.32677 .29961 Mdot
.32692 .29909 Mdot
.32707 .2967 Mdot
.32722 .29463 Mdot
.32737 .30261 Mdot
.32752 .31676 Mdot
.32767 .32074 Mdot
.32782 .31833 Mdot
.32798 .32404 Mdot
.32813 .33217 Mdot
.32828 .33664 Mdot
.32843 .33592 Mdot
.32858 .32652 Mdot
.32873 .30169 Mdot
.32888 .28321 Mdot
.32903 .28093 Mdot
.32918 .27394 Mdot
.32933 .26859 Mdot
.32948 .27057 Mdot
.32963 .27612 Mdot
.32978 .28281 Mdot
.32993 .29448 Mdot
.33008 .29901 Mdot
.33023 .29037 Mdot
.33038 .29097 Mdot
.33053 .30568 Mdot
.33068 .3093 Mdot
.33083 .29925 Mdot
.33099 .29144 Mdot
.33114 .27919 Mdot
.33129 .26428 Mdot
.33144 .26816 Mdot
.33159 .28242 Mdot
.33174 .28735 Mdot
.33189 .28973 Mdot
.33204 .29484 Mdot
.33219 .29309 Mdot
.33234 .2853 Mdot
.33249 .2906 Mdot
.33264 .2937 Mdot
.33279 .28504 Mdot
.33294 .27561 Mdot
.33309 .26562 Mdot
.33324 .25087 Mdot
.33339 .24944 Mdot
.33354 .26616 Mdot
.33369 .28363 Mdot
.33385 .29511 Mdot
.334 .31001 Mdot
.33415 .32313 Mdot
.3343 .32734 Mdot
.33445 .33981 Mdot
.3346 .35515 Mdot
.33475 .36142 Mdot
.3349 .36284 Mdot
.33505 .35941 Mdot
.3352 .3474 Mdot
.33535 .33392 Mdot
.3355 .32405 Mdot
.33565 .31688 Mdot
.3358 .31617 Mdot
.33595 .32396 Mdot
.3361 .32875 Mdot
.33625 .31987 Mdot
.3364 .30856 Mdot
.33655 .30033 Mdot
.3367 .29398 Mdot
.33686 .29537 Mdot
.33701 .30209 Mdot
.33716 .30132 Mdot
.33731 .29386 Mdot
.33746 .29072 Mdot
.33761 .29264 Mdot
.33776 .3045 Mdot
.33791 .33094 Mdot
.33806 .35871 Mdot
.33821 .36889 Mdot
.33836 .37878 Mdot
.33851 .38805 Mdot
.33866 .38836 Mdot
.33881 .38306 Mdot
.33896 .38159 Mdot
.33911 .37154 Mdot
.33926 .35172 Mdot
.33941 .335 Mdot
.33956 .31941 Mdot
.33971 .30118 Mdot
.33987 .28781 Mdot
.34002 .28529 Mdot
.34017 .27544 Mdot
.34032 .26515 Mdot
.34047 .25902 Mdot
.34062 .25751 Mdot
.34077 .25812 Mdot
.34092 .25792 Mdot
.34107 .25767 Mdot
.34122 .25468 Mdot
.34137 .25506 Mdot
.34152 .2681 Mdot
.34167 .28325 Mdot
.34182 .29781 Mdot
.34197 .31017 Mdot
.34212 .32359 Mdot
.34227 .34235 Mdot
.34242 .35503 Mdot
.34257 .35776 Mdot
.34272 .35523 Mdot
.34288 .35277 Mdot
.34303 .34183 Mdot
.34318 .32757 Mdot
.34333 .31668 Mdot
.34348 .31099 Mdot
.34363 .30741 Mdot
.34378 .30228 Mdot
.34393 .29285 Mdot
.34408 .27942 Mdot
.34423 .26635 Mdot
.34438 .25566 Mdot
.34453 .24497 Mdot
.34468 .23824 Mdot
.34483 .23786 Mdot
.34498 .2419 Mdot
.34513 .25165 Mdot
.34528 .26714 Mdot
.34543 .28312 Mdot
.34558 .29484 Mdot
.34573 .31302 Mdot
.34589 .33211 Mdot
.34604 .33953 Mdot
.34619 .33892 Mdot
.34634 .34276 Mdot
.34649 .3473 Mdot
.34664 .35034 Mdot
.34679 .35757 Mdot
.34694 .35971 Mdot
.34709 .3519 Mdot
.34724 .34197 Mdot
.34739 .3423 Mdot
.34754 .34001 Mdot
.34769 .32788 Mdot
.34784 .31447 Mdot
.34799 .30383 Mdot
.34814 .29818 Mdot
.34829 .2918 Mdot
.34844 .28984 Mdot
.34859 .28655 Mdot
.34874 .28771 Mdot
.3489 .29238 Mdot
.34905 .29355 Mdot
.3492 .29191 Mdot
.34935 .29778 Mdot
.3495 .30767 Mdot
.34965 .31322 Mdot
.3498 .31913 Mdot
.34995 .32535 Mdot
.3501 .32782 Mdot
.35025 .335 Mdot
.3504 .34427 Mdot
.35055 .34085 Mdot
.3507 .33007 Mdot
.35085 .32628 Mdot
.351 .32925 Mdot
.35115 .33265 Mdot
.3513 .33485 Mdot
.35145 .33386 Mdot
.3516 .32933 Mdot
.35175 .32745 Mdot
.35191 .32753 Mdot
.35206 .32367 Mdot
.35221 .32173 Mdot
.35236 .32765 Mdot
.35251 .32393 Mdot
.35266 .31178 Mdot
.35281 .30701 Mdot
.35296 .31233 Mdot
.35311 .31932 Mdot
.35326 .32617 Mdot
.35341 .3273 Mdot
.35356 .31042 Mdot
.35371 .28644 Mdot
.35386 .27444 Mdot
.35401 .27829 Mdot
.35416 .28207 Mdot
.35431 .28225 Mdot
.35446 .28169 Mdot
.35461 .2853 Mdot
.35476 .30014 Mdot
.35492 .31188 Mdot
.35507 .31477 Mdot
.35522 .32044 Mdot
.35537 .32524 Mdot
.35552 .31991 Mdot
.35567 .31015 Mdot
.35582 .31069 Mdot
.35597 .30949 Mdot
.35612 .30316 Mdot
.35627 .29995 Mdot
.35642 .30193 Mdot
.35657 .30034 Mdot
.35672 .30563 Mdot
.35687 .31451 Mdot
.35702 .31315 Mdot
.35717 .30094 Mdot
.35732 .28732 Mdot
.35747 .27407 Mdot
.35762 .26945 Mdot
.35777 .27567 Mdot
.35793 .27192 Mdot
.35808 .25253 Mdot
.35823 .23901 Mdot
.35838 .24398 Mdot
.35853 .25756 Mdot
.35868 .28043 Mdot
.35883 .30568 Mdot
.35898 .31766 Mdot
.35913 .3231 Mdot
.35928 .33601 Mdot
.35943 .35238 Mdot
.35958 .3578 Mdot
.35973 .3531 Mdot
.35988 .33801 Mdot
.36003 .31225 Mdot
.36018 .29299 Mdot
.36033 .29255 Mdot
.36048 .2964 Mdot
.36063 .30718 Mdot
.36079 .33018 Mdot
.36094 .3431 Mdot
.36109 .34439 Mdot
.36124 .35024 Mdot
.36139 .35774 Mdot
.36154 .35479 Mdot
.36169 .33941 Mdot
.36184 .31715 Mdot
.36199 .29266 Mdot
.36214 .28077 Mdot
.36229 .29174 Mdot
.36244 .30979 Mdot
.36259 .32043 Mdot
.36274 .326 Mdot
.36289 .33506 Mdot
.36304 .35296 Mdot
.36319 .37576 Mdot
.36334 .38454 Mdot
.36349 .37644 Mdot
.36364 .35763 Mdot
.3638 .33968 Mdot
.36395 .31945 Mdot
.3641 .30394 Mdot
.36425 .30347 Mdot
.3644 .30949 Mdot
.36455 .31047 Mdot
.3647 .31482 Mdot
.36485 .32379 Mdot
.365 .33011 Mdot
.36515 .33592 Mdot
.3653 .3418 Mdot
.36545 .33246 Mdot
.3656 .31341 Mdot
.36575 .29778 Mdot
.3659 .28978 Mdot
.36605 .28517 Mdot
.3662 .27759 Mdot
.36635 .26564 Mdot
.3665 .26056 Mdot
.36665 .27047 Mdot
.36681 .28726 Mdot
.36696 .30112 Mdot
.36711 .30433 Mdot
.36726 .29832 Mdot
.36741 .29105 Mdot
.36756 .28748 Mdot
.36771 .28989 Mdot
.36786 .28813 Mdot
.36801 .28357 Mdot
.36816 .27167 Mdot
.36831 .26314 Mdot
.36846 .26185 Mdot
.36861 .26558 Mdot
.36876 .2743 Mdot
.36891 .28946 Mdot
.36906 .29643 Mdot
.36921 .28999 Mdot
.36936 .2858 Mdot
.36951 .29656 Mdot
.36966 .31186 Mdot
.36982 .32341 Mdot
.36997 .33207 Mdot
.37012 .33245 Mdot
.37027 .32695 Mdot
.37042 .32519 Mdot
.37057 .33144 Mdot
.37072 .32738 Mdot
.37087 .30905 Mdot
.37102 .29625 Mdot
.37117 .28869 Mdot
.37132 .28359 Mdot
.37147 .28181 Mdot
.37162 .28351 Mdot
.37177 .28056 Mdot
.37192 .2793 Mdot
.37207 .28341 Mdot
.37222 .29041 Mdot
.37237 .30109 Mdot
.37252 .3071 Mdot
.37267 .30665 Mdot
.37283 .30707 Mdot
.37298 .31384 Mdot
.37313 .32564 Mdot
.37328 .34401 Mdot
.37343 .36891 Mdot
.37358 .39634 Mdot
.37373 .41159 Mdot
.37388 .41378 Mdot
.37403 .4202 Mdot
.37418 .42647 Mdot
.37433 .41799 Mdot
.37448 .39813 Mdot
.37463 .37066 Mdot
.37478 .34203 Mdot
.37493 .31021 Mdot
.37508 .28548 Mdot
.37523 .27355 Mdot
.37538 .26427 Mdot
.37553 .25554 Mdot
.37568 .25534 Mdot
.37584 .26588 Mdot
.37599 .27473 Mdot
.37614 .27577 Mdot
.37629 .27014 Mdot
.37644 .27006 Mdot
.37659 .2751 Mdot
.37674 .28352 Mdot
.37689 .28945 Mdot
.37704 .29625 Mdot
.37719 .31467 Mdot
.37734 .33786 Mdot
.37749 .35773 Mdot
.37764 .38198 Mdot
.37779 .41094 Mdot
.37794 .42146 Mdot
.37809 .40656 Mdot
.37824 .38008 Mdot
.37839 .34384 Mdot
.37854 .31269 Mdot
.37869 .29916 Mdot
.37885 .28727 Mdot
.379 .25583 Mdot
.37915 .21965 Mdot
.3793 .20128 Mdot
.37945 .19889 Mdot
.3796 .2051 Mdot
.37975 .20843 Mdot
.3799 .19986 Mdot
.38005 .19365 Mdot
.3802 .20232 Mdot
.38035 .22202 Mdot
.3805 .23793 Mdot
.38065 .25925 Mdot
.3808 .28444 Mdot
.38095 .30404 Mdot
.3811 .32621 Mdot
.38125 .35171 Mdot
.3814 .36542 Mdot
.38155 .37023 Mdot
.3817 .37771 Mdot
.38186 .38712 Mdot
.38201 .38842 Mdot
.38216 .38408 Mdot
.38231 .37883 Mdot
.38246 .36803 Mdot
.38261 .35603 Mdot
.38276 .33161 Mdot
.38291 .29803 Mdot
.38306 .27611 Mdot
.38321 .27202 Mdot
.38336 .25999 Mdot
.38351 .23779 Mdot
.38366 .21915 Mdot
.38381 .20766 Mdot
.38396 .21183 Mdot
.38411 .23714 Mdot
.38426 .26179 Mdot
.38441 .26902 Mdot
.38456 .27434 Mdot
.38471 .30447 Mdot
.38487 .34693 Mdot
.38502 .37962 Mdot
.38517 .39382 Mdot
.38532 .39975 Mdot
.38547 .40953 Mdot
.38562 .41318 Mdot
.38577 .39555 Mdot
.38592 .36617 Mdot
.38607 .35656 Mdot
.38622 .35988 Mdot
.38637 .34848 Mdot
.38652 .33792 Mdot
.38667 .33476 Mdot
.38682 .32807 Mdot
.38697 .31619 Mdot
.38712 .30763 Mdot
.38727 .29249 Mdot
.38742 .2658 Mdot
.38757 .24751 Mdot
.38773 .24896 Mdot
.38788 .25252 Mdot
.38803 .25031 Mdot
.38818 .23926 Mdot
.38833 .23719 Mdot
.38848 .25862 Mdot
.38863 .2848 Mdot
.38878 .29458 Mdot
.38893 .30701 Mdot
.38908 .33639 Mdot
.38923 .34909 Mdot
.38938 .35062 Mdot
.38953 .36213 Mdot
.38968 .36916 Mdot
.38983 .35196 Mdot
.38998 .32674 Mdot
.39013 .3068 Mdot
.39028 .282 Mdot
.39043 .2569 Mdot
.39058 .25672 Mdot
.39074 .27302 Mdot
.39089 .28736 Mdot
.39104 .29863 Mdot
.39119 .30097 Mdot
.39134 .29422 Mdot
.39149 .28711 Mdot
.39164 .27375 Mdot
.39179 .24984 Mdot
.39194 .23363 Mdot
.39209 .23038 Mdot
.39224 .22604 Mdot
.39239 .22268 Mdot
.39254 .23382 Mdot
.39269 .24947 Mdot
.39284 .26648 Mdot
.39299 .28935 Mdot
.39314 .30969 Mdot
.39329 .31408 Mdot
.39344 .31223 Mdot
.39359 .31179 Mdot
.39375 .31016 Mdot
.3939 .30879 Mdot
.39405 .31529 Mdot
.3942 .31733 Mdot
.39435 .3117 Mdot
.3945 .3072 Mdot
.39465 .29599 Mdot
.3948 .2848 Mdot
.39495 .29137 Mdot
.3951 .31117 Mdot
.39525 .32784 Mdot
.3954 .33892 Mdot
.39555 .35151 Mdot
.3957 .35227 Mdot
.39585 .34808 Mdot
.396 .35414 Mdot
.39615 .35848 Mdot
.3963 .35185 Mdot
.39645 .34662 Mdot
.3966 .34604 Mdot
.39676 .34475 Mdot
.39691 .35133 Mdot
.39706 .36104 Mdot
.39721 .36079 Mdot
.39736 .3596 Mdot
.39751 .35913 Mdot
.39766 .34217 Mdot
.39781 .31646 Mdot
.39796 .30953 Mdot
.39811 .32232 Mdot
.39826 .3403 Mdot
.39841 .35472 Mdot
.39856 .3617 Mdot
.39871 .34973 Mdot
.39886 .33563 Mdot
.39901 .33296 Mdot
.39916 .32531 Mdot
.39931 .3053 Mdot
.39946 .29816 Mdot
.39961 .30414 Mdot
.39977 .30963 Mdot
.39992 .31601 Mdot
.40007 .33504 Mdot
.40022 .35193 Mdot
.40037 .35975 Mdot
.40052 .35402 Mdot
.40067 .3243 Mdot
.40082 .27688 Mdot
.40097 .24067 Mdot
.40112 .21484 Mdot
.40127 .18615 Mdot
.40142 .16261 Mdot
.40157 .15554 Mdot
.40172 .16317 Mdot
.40187 .1769 Mdot
.40202 .19834 Mdot
.40217 .21218 Mdot
.40232 .21918 Mdot
.40247 .23028 Mdot
.40262 .24958 Mdot
.40278 .26318 Mdot
.40293 .26431 Mdot
.40308 .26527 Mdot
.40323 .2736 Mdot
.40338 .28622 Mdot
.40353 .30586 Mdot
.40368 .32758 Mdot
.40383 .357 Mdot
.40398 .38832 Mdot
.40413 .40287 Mdot
.40428 .39703 Mdot
.40443 .39021 Mdot
.40458 .38605 Mdot
.40473 .36922 Mdot
.40488 .33994 Mdot
.40503 .3045 Mdot
.40518 .26254 Mdot
.40533 .2318 Mdot
.40548 .22038 Mdot
.40563 .22663 Mdot
.40579 .23542 Mdot
.40594 .25984 Mdot
.40609 .29341 Mdot
.40624 .31782 Mdot
.40639 .32922 Mdot
.40654 .33749 Mdot
.40669 .34664 Mdot
.40684 .35531 Mdot
.40699 .36811 Mdot
.40714 .37771 Mdot
.40729 .38248 Mdot
.40744 .38944 Mdot
.40759 .40177 Mdot
.40774 .41468 Mdot
.40789 .41601 Mdot
.40804 .42 Mdot
.40819 .42109 Mdot
.40834 .40724 Mdot
.40849 .38319 Mdot
.40864 .35433 Mdot
.4088 .3167 Mdot
.40895 .28895 Mdot
.4091 .27603 Mdot
.40925 .26895 Mdot
.4094 .25234 Mdot
.40955 .23637 Mdot
.4097 .22416 Mdot
.40985 .21209 Mdot
.41 .20819 Mdot
.41015 .21977 Mdot
.4103 .23442 Mdot
.41045 .24608 Mdot
.4106 .25602 Mdot
.41075 .26546 Mdot
.4109 .27329 Mdot
.41105 .28107 Mdot
.4112 .29313 Mdot
.41135 .30996 Mdot
.4115 .32854 Mdot
.41165 .33465 Mdot
.41181 .32738 Mdot
.41196 .31762 Mdot
.41211 .31251 Mdot
.41226 .31357 Mdot
.41241 .30545 Mdot
.41256 .29567 Mdot
.41271 .292 Mdot
.41286 .29395 Mdot
.41301 .28585 Mdot
.41316 .27052 Mdot
.41331 .2744 Mdot
.41346 .29277 Mdot
.41361 .29723 Mdot
.41376 .27969 Mdot
.41391 .25857 Mdot
.41406 .24388 Mdot
.41421 .23439 Mdot
.41436 .23767 Mdot
.41451 .25168 Mdot
.41466 .26852 Mdot
.41482 .2853 Mdot
.41497 .3107 Mdot
.41512 .33645 Mdot
.41527 .35376 Mdot
.41542 .37074 Mdot
.41557 .37749 Mdot
.41572 .36242 Mdot
.41587 .34187 Mdot
.41602 .33111 Mdot
.41617 .32168 Mdot
.41632 .32016 Mdot
.41647 .3264 Mdot
.41662 .33083 Mdot
.41677 .33028 Mdot
.41692 .3367 Mdot
.41707 .34164 Mdot
.41722 .33228 Mdot
.41737 .32363 Mdot
.41752 .32375 Mdot
.41768 .31754 Mdot
.41783 .30315 Mdot
.41798 .28437 Mdot
.41813 .26718 Mdot
.41828 .25825 Mdot
.41843 .26337 Mdot
.41858 .27141 Mdot
.41873 .28355 Mdot
.41888 .30778 Mdot
.41903 .32962 Mdot
.41918 .32487 Mdot
.41933 .31104 Mdot
.41948 .30402 Mdot
.41963 .30706 Mdot
.41978 .30927 Mdot
.41993 .30505 Mdot
.42008 .2964 Mdot
.42023 .29184 Mdot
.42038 .29845 Mdot
.42053 .31341 Mdot
.42069 .33185 Mdot
.42084 .35246 Mdot
.42099 .35618 Mdot
.42114 .34537 Mdot
.42129 .34153 Mdot
.42144 .34548 Mdot
.42159 .34028 Mdot
.42174 .33236 Mdot
.42189 .3283 Mdot
.42204 .32155 Mdot
.42219 .30885 Mdot
.42234 .30197 Mdot
.42249 .29648 Mdot
.42264 .28945 Mdot
.42279 .27777 Mdot
.42294 .26524 Mdot
.42309 .25277 Mdot
.42324 .24497 Mdot
.42339 .24027 Mdot
.42354 .24109 Mdot
.4237 .24861 Mdot
.42385 .25589 Mdot
.424 .26266 Mdot
.42415 .27369 Mdot
.4243 .2903 Mdot
.42445 .30593 Mdot
.4246 .31691 Mdot
.42475 .32259 Mdot
.4249 .32593 Mdot
.42505 .3372 Mdot
.4252 .35462 Mdot
.42535 .359 Mdot
.4255 .35475 Mdot
.42565 .35553 Mdot
.4258 .35478 Mdot
.42595 .34327 Mdot
.4261 .33178 Mdot
.42625 .32288 Mdot
.4264 .31095 Mdot
.42655 .29713 Mdot
.42671 .28478 Mdot
.42686 .27064 Mdot
.42701 .25326 Mdot
.42716 .24384 Mdot
.42731 .23707 Mdot
.42746 .23025 Mdot
.42761 .23392 Mdot
.42776 .24494 Mdot
.42791 .25958 Mdot
.42806 .27146 Mdot
.42821 .2838 Mdot
.42836 .29095 Mdot
.42851 .30624 Mdot
.42866 .33703 Mdot
.42881 .35657 Mdot
.42896 .35606 Mdot
.42911 .35778 Mdot
.42926 .36518 Mdot
.42941 .37395 Mdot
.42956 .37815 Mdot
.42972 .38763 Mdot
.42987 .38779 Mdot
.43002 .37565 Mdot
.43017 .35794 Mdot
.43032 .34764 Mdot
.43047 .34566 Mdot
.43062 .33663 Mdot
.43077 .32414 Mdot
.43092 .31326 Mdot
.43107 .3029 Mdot
.43122 .28777 Mdot
.43137 .28421 Mdot
.43152 .28931 Mdot
.43167 .29398 Mdot
.43182 .29538 Mdot
.43197 .29477 Mdot
.43212 .2978 Mdot
.43227 .30969 Mdot
.43242 .32303 Mdot
.43257 .32782 Mdot
.43273 .33193 Mdot
.43288 .33909 Mdot
.43303 .34256 Mdot
.43318 .34945 Mdot
.43333 .36369 Mdot
.43348 .36899 Mdot
.43363 .35355 Mdot
.43378 .33802 Mdot
.43393 .33647 Mdot
.43408 .33472 Mdot
.43423 .3254 Mdot
.43438 .31427 Mdot
.43453 .29796 Mdot
.43468 .27977 Mdot
.43483 .26773 Mdot
.43498 .25111 Mdot
.43513 .23542 Mdot
.43528 .22673 Mdot
.43543 .21145 Mdot
.43558 .19361 Mdot
.43574 .19322 Mdot
.43589 .2061 Mdot
.43604 .21153 Mdot
.43619 .21831 Mdot
.43634 .23534 Mdot
.43649 .24645 Mdot
.43664 .24724 Mdot
.43679 .25426 Mdot
.43694 .26788 Mdot
.43709 .27385 Mdot
.43724 .27447 Mdot
.43739 .27175 Mdot
.43754 .27244 Mdot
.43769 .29347 Mdot
.43784 .32196 Mdot
.43799 .33654 Mdot
.43814 .3462 Mdot
.43829 .35272 Mdot
.43844 .34992 Mdot
.43859 .3461 Mdot
.43875 .35597 Mdot
.4389 .35972 Mdot
.43905 .34537 Mdot
.4392 .32923 Mdot
.43935 .3237 Mdot
.4395 .32012 Mdot
.43965 .31769 Mdot
.4398 .3225 Mdot
.43995 .33279 Mdot
.4401 .34698 Mdot
.44025 .35561 Mdot
.4404 .35215 Mdot
.44055 .35402 Mdot
.4407 .37661 Mdot
.44085 .38923 Mdot
.441 .37473 Mdot
.44115 .35326 Mdot
.4413 .34472 Mdot
.44145 .34066 Mdot
.4416 .34475 Mdot
.44176 .35529 Mdot
.44191 .35882 Mdot
.44206 .36034 Mdot
.44221 .37506 Mdot
.44236 .39357 Mdot
.44251 .40142 Mdot
.44266 .39415 Mdot
.44281 .37852 Mdot
.44296 .35995 Mdot
.44311 .34546 Mdot
.44326 .32823 Mdot
.44341 .30277 Mdot
.44356 .28966 Mdot
.44371 .29093 Mdot
.44386 .28639 Mdot
.44401 .27134 Mdot
.44416 .2655 Mdot
.44431 .26701 Mdot
.44446 .27164 Mdot
.44462 .27614 Mdot
.44477 .27566 Mdot
.44492 .26411 Mdot
.44507 .25562 Mdot
.44522 .25491 Mdot
.44537 .25044 Mdot
.44552 .23652 Mdot
.44567 .22326 Mdot
.44582 .21666 Mdot
.44597 .22502 Mdot
.44612 .24659 Mdot
.44627 .25419 Mdot
.44642 .24973 Mdot
.44657 .25351 Mdot
.44672 .27615 Mdot
.44687 .30128 Mdot
.44702 .31685 Mdot
.44717 .32946 Mdot
.44732 .3387 Mdot
.44747 .33965 Mdot
.44763 .33368 Mdot
.44778 .32119 Mdot
.44793 .30325 Mdot
.44808 .29335 Mdot
.44823 .28905 Mdot
.44838 .27816 Mdot
.44853 .2621 Mdot
.44868 .25655 Mdot
.44883 .26448 Mdot
.44898 .28316 Mdot
.44913 .30413 Mdot
.44928 .30739 Mdot
.44943 .29747 Mdot
.44958 .29091 Mdot
.44973 .2942 Mdot
.44988 .30082 Mdot
.45003 .29604 Mdot
.45018 .2862 Mdot
.45033 .28379 Mdot
.45048 .29716 Mdot
.45064 .31523 Mdot
.45079 .33247 Mdot
.45094 .35913 Mdot
.45109 .39218 Mdot
.45124 .4269 Mdot
.45139 .44797 Mdot
.45154 .45149 Mdot
.45169 .44082 Mdot
.45184 .42272 Mdot
.45199 .39928 Mdot
.45214 .36808 Mdot
.45229 .34095 Mdot
.45244 .31796 Mdot
.45259 .30684 Mdot
.45274 .30253 Mdot
.45289 .30397 Mdot
.45304 .3033 Mdot
.45319 .30783 Mdot
.45334 .31844 Mdot
.45349 .32864 Mdot
.45365 .32231 Mdot
.4538 .30308 Mdot
.45395 .28494 Mdot
.4541 .27444 Mdot
.45425 .27029 Mdot
.4544 .26942 Mdot
.45455 .27633 Mdot
.4547 .28604 Mdot
.45485 .29994 Mdot
.455 .31796 Mdot
.45515 .34041 Mdot
.4553 .36591 Mdot
.45545 .38456 Mdot
.4556 .392 Mdot
.45575 .39501 Mdot
.4559 .39292 Mdot
.45605 .37909 Mdot
.4562 .36288 Mdot
.45635 .34864 Mdot
.4565 .33518 Mdot
.45666 .3109 Mdot
.45681 .27733 Mdot
.45696 .2506 Mdot
.45711 .23421 Mdot
.45726 .22759 Mdot
.45741 .22803 Mdot
.45756 .23124 Mdot
.45771 .23556 Mdot
.45786 .23989 Mdot
.45801 .24103 Mdot
.45816 .2456 Mdot
.45831 .24785 Mdot
.45846 .24417 Mdot
.45861 .2411 Mdot
.45876 .25027 Mdot
.45891 .2603 Mdot
.45906 .25933 Mdot
.45921 .25879 Mdot
.45936 .27743 Mdot
.45951 .30772 Mdot
.45967 .33131 Mdot
.45982 .34914 Mdot
.45997 .3576 Mdot
.46012 .36522 Mdot
.46027 .37189 Mdot
.46042 .37301 Mdot
.46057 .36434 Mdot
.46072 .34548 Mdot
.46087 .32007 Mdot
.46102 .28982 Mdot
.46117 .26528 Mdot
.46132 .24929 Mdot
.46147 .24523 Mdot
.46162 .2597 Mdot
.46177 .29062 Mdot
.46192 .31211 Mdot
.46207 .31992 Mdot
.46222 .32761 Mdot
.46237 .34673 Mdot
.46252 .36447 Mdot
.46268 .35798 Mdot
.46283 .3332 Mdot
.46298 .31398 Mdot
.46313 .31013 Mdot
.46328 .31669 Mdot
.46343 .33464 Mdot
.46358 .35901 Mdot
.46373 .37775 Mdot
.46388 .38108 Mdot
.46403 .38846 Mdot
.46418 .39772 Mdot
.46433 .39567 Mdot
.46448 .38596 Mdot
.46463 .37392 Mdot
.46478 .3613 Mdot
.46493 .34567 Mdot
.46508 .32291 Mdot
.46523 .30122 Mdot
.46538 .2909 Mdot
.46553 .29278 Mdot
.46569 .28373 Mdot
.46584 .26955 Mdot
.46599 .26874 Mdot
.46614 .27946 Mdot
.46629 .28143 Mdot
.46644 .28182 Mdot
.46659 .29019 Mdot
.46674 .29616 Mdot
.46689 .29497 Mdot
.46704 .29641 Mdot
.46719 .29449 Mdot
.46734 .28054 Mdot
.46749 .27156 Mdot
.46764 .28218 Mdot
.46779 .30234 Mdot
.46794 .31799 Mdot
.46809 .31789 Mdot
.46824 .30727 Mdot
.46839 .30461 Mdot
.46854 .31571 Mdot
.4687 .31854 Mdot
.46885 .30991 Mdot
.469 .31567 Mdot
.46915 .3295 Mdot
.4693 .32444 Mdot
.46945 .31064 Mdot
.4696 .30015 Mdot
.46975 .28711 Mdot
.4699 .27472 Mdot
.47005 .27059 Mdot
.4702 .26178 Mdot
.47035 .25133 Mdot
.4705 .25314 Mdot
.47065 .26973 Mdot
.4708 .2821 Mdot
.47095 .29413 Mdot
.4711 .30231 Mdot
.47125 .30652 Mdot
.4714 .31529 Mdot
.47155 .31542 Mdot
.47171 .29299 Mdot
.47186 .27623 Mdot
.47201 .28342 Mdot
.47216 .29121 Mdot
.47231 .29356 Mdot
.47246 .30906 Mdot
.47261 .32911 Mdot
.47276 .33402 Mdot
.47291 .33781 Mdot
.47306 .34448 Mdot
.47321 .33564 Mdot
.47336 .31288 Mdot
.47351 .3011 Mdot
.47366 .29634 Mdot
.47381 .29051 Mdot
.47396 .28598 Mdot
.47411 .28107 Mdot
.47426 .27856 Mdot
.47441 .2898 Mdot
.47457 .29715 Mdot
.47472 .28963 Mdot
.47487 .28244 Mdot
.47502 .28619 Mdot
.47517 .28355 Mdot
.47532 .27363 Mdot
.47547 .27312 Mdot
.47562 .27306 Mdot
.47577 .27595 Mdot
.47592 .29223 Mdot
.47607 .31455 Mdot
.47622 .32096 Mdot
.47637 .31979 Mdot
.47652 .33087 Mdot
.47667 .34706 Mdot
.47682 .3591 Mdot
.47697 .36819 Mdot
.47712 .37231 Mdot
.47727 .36982 Mdot
.47742 .36072 Mdot
.47758 .34838 Mdot
.47773 .34026 Mdot
.47788 .35332 Mdot
.47803 .37623 Mdot
.47818 .38555 Mdot
.47833 .3761 Mdot
.47848 .36733 Mdot
.47863 .35771 Mdot
.47878 .34044 Mdot
.47893 .32556 Mdot
.47908 .31381 Mdot
.47923 .29667 Mdot
.47938 .28741 Mdot
.47953 .28817 Mdot
.47968 .29412 Mdot
.47983 .30837 Mdot
.47998 .33223 Mdot
.48013 .35252 Mdot
.48028 .36013 Mdot
.48043 .35117 Mdot
.48059 .32679 Mdot
.48074 .29826 Mdot
.48089 .28026 Mdot
.48104 .27338 Mdot
.48119 .27283 Mdot
.48134 .28067 Mdot
.48149 .29526 Mdot
.48164 .30432 Mdot
.48179 .31011 Mdot
.48194 .31453 Mdot
.48209 .30574 Mdot
.48224 .28286 Mdot
.48239 .26004 Mdot
.48254 .24553 Mdot
.48269 .23169 Mdot
.48284 .21743 Mdot
.48299 .21898 Mdot
.48314 .22939 Mdot
.48329 .24023 Mdot
.48344 .24514 Mdot
.4836 .24664 Mdot
.48375 .25316 Mdot
.4839 .26217 Mdot
.48405 .26363 Mdot
.4842 .25093 Mdot
.48435 .23286 Mdot
.4845 .22451 Mdot
.48465 .23513 Mdot
.4848 .25085 Mdot
.48495 .26629 Mdot
.4851 .27275 Mdot
.48525 .27528 Mdot
.4854 .28486 Mdot
.48555 .30988 Mdot
.4857 .33431 Mdot
.48585 .34995 Mdot
.486 .36041 Mdot
.48615 .37211 Mdot
.4863 .37566 Mdot
.48645 .3646 Mdot
.48661 .35036 Mdot
.48676 .35135 Mdot
.48691 .36915 Mdot
.48706 .38569 Mdot
.48721 .39263 Mdot
.48736 .39447 Mdot
.48751 .39445 Mdot
.48766 .38988 Mdot
.48781 .38032 Mdot
.48796 .36616 Mdot
.48811 .34586 Mdot
.48826 .33026 Mdot
.48841 .31817 Mdot
.48856 .31285 Mdot
.48871 .31014 Mdot
.48886 .31858 Mdot
.48901 .33593 Mdot
.48916 .35765 Mdot
.48931 .37743 Mdot
.48946 .38414 Mdot
.48962 .37243 Mdot
.48977 .35425 Mdot
.48992 .34167 Mdot
.49007 .33675 Mdot
.49022 .34182 Mdot
.49037 .34822 Mdot
.49052 .34996 Mdot
.49067 .35247 Mdot
.49082 .35542 Mdot
.49097 .35723 Mdot
.49112 .351 Mdot
.49127 .34175 Mdot
.49142 .33038 Mdot
.49157 .30948 Mdot
.49172 .27474 Mdot
.49187 .24574 Mdot
.49202 .22858 Mdot
.49217 .21681 Mdot
.49232 .20559 Mdot
.49247 .19723 Mdot
.49263 .19341 Mdot
.49278 .18692 Mdot
.49293 .18412 Mdot
.49308 .1847 Mdot
.49323 .17823 Mdot
.49338 .17356 Mdot
.49353 .18207 Mdot
.49368 .19698 Mdot
.49383 .21373 Mdot
.49398 .22692 Mdot
.49413 .23839 Mdot
.49428 .25792 Mdot
.49443 .29039 Mdot
.49458 .3231 Mdot
.49473 .34456 Mdot
.49488 .35676 Mdot
.49503 .36833 Mdot
.49518 .37429 Mdot
.49533 .36118 Mdot
.49548 .34852 Mdot
.49564 .34674 Mdot
.49579 .35028 Mdot
.49594 .35015 Mdot
.49609 .34299 Mdot
.49624 .33897 Mdot
.49639 .3358 Mdot
.49654 .3305 Mdot
.49669 .31754 Mdot
.49684 .29905 Mdot
.49699 .28708 Mdot
.49714 .27909 Mdot
.49729 .27144 Mdot
.49744 .26548 Mdot
.49759 .26646 Mdot
.49774 .27323 Mdot
.49789 .29259 Mdot
.49804 .31962 Mdot
.49819 .34862 Mdot
.49834 .37069 Mdot
.49849 .37966 Mdot
.49865 .37693 Mdot
.4988 .37303 Mdot
.49895 .37943 Mdot
.4991 .38817 Mdot
.49925 .39582 Mdot
.4994 .39623 Mdot
.49955 .39298 Mdot
.4997 .38815 Mdot
.49985 .38622 Mdot
.5 .3773 Mdot
.50015 .35812 Mdot
.5003 .34069 Mdot
.50045 .3233 Mdot
.5006 .2978 Mdot
.50075 .26434 Mdot
.5009 .23044 Mdot
.50105 .20664 Mdot
.5012 .20147 Mdot
.50135 .21084 Mdot
.50151 .21828 Mdot
.50166 .22084 Mdot
.50181 .23648 Mdot
.50196 .25967 Mdot
.50211 .2765 Mdot
.50226 .287 Mdot
.50241 .29988 Mdot
.50256 .32329 Mdot
.50271 .34656 Mdot
.50286 .36077 Mdot
.50301 .36864 Mdot
.50316 .37917 Mdot
.50331 .39796 Mdot
.50346 .41674 Mdot
.50361 .42943 Mdot
.50376 .43053 Mdot
.50391 .40775 Mdot
.50406 .3734 Mdot
.50421 .3458 Mdot
.50436 .32433 Mdot
.50452 .29744 Mdot
.50467 .27613 Mdot
.50482 .25871 Mdot
.50497 .24016 Mdot
.50512 .22621 Mdot
.50527 .22165 Mdot
.50542 .22161 Mdot
.50557 .22363 Mdot
.50572 .22384 Mdot
.50587 .2195 Mdot
.50602 .21993 Mdot
.50617 .22231 Mdot
.50632 .22879 Mdot
.50647 .24161 Mdot
.50662 .25774 Mdot
.50677 .27004 Mdot
.50692 .28123 Mdot
.50707 .3079 Mdot
.50722 .33819 Mdot
.50737 .34984 Mdot
.50753 .34525 Mdot
.50768 .33541 Mdot
.50783 .32271 Mdot
.50798 .31234 Mdot
.50813 .30506 Mdot
.50828 .294 Mdot
.50843 .27992 Mdot
.50858 .27726 Mdot
.50873 .27579 Mdot
.50888 .26973 Mdot
.50903 .2658 Mdot
.50918 .26832 Mdot
.50933 .26661 Mdot
.50948 .25873 Mdot
.50963 .25226 Mdot
.50978 .25385 Mdot
.50993 .26364 Mdot
.51008 .27912 Mdot
.51023 .29102 Mdot
.51038 .30176 Mdot
.51054 .31742 Mdot
.51069 .33383 Mdot
.51084 .35383 Mdot
.51099 .36932 Mdot
.51114 .37809 Mdot
.51129 .37866 Mdot
.51144 .38796 Mdot
.51159 .40923 Mdot
.51174 .42097 Mdot
.51189 .42306 Mdot
.51204 .43151 Mdot
.51219 .43896 Mdot
.51234 .44308 Mdot
.51249 .4426 Mdot
.51264 .44145 Mdot
.51279 .43257 Mdot
.51294 .41705 Mdot
.51309 .39617 Mdot
.51324 .37367 Mdot
.51339 .36328 Mdot
.51355 .35957 Mdot
.5137 .35617 Mdot
.51385 .35275 Mdot
.514 .34866 Mdot
.51415 .33811 Mdot
.5143 .3295 Mdot
.51445 .32997 Mdot
.5146 .32849 Mdot
.51475 .3192 Mdot
.5149 .31146 Mdot
.51505 .3072 Mdot
.5152 .30316 Mdot
.51535 .29911 Mdot
.5155 .29541 Mdot
.51565 .28971 Mdot
.5158 .28264 Mdot
.51595 .27677 Mdot
.5161 .27253 Mdot
.51625 .27371 Mdot
.5164 .27486 Mdot
.51656 .26713 Mdot
.51671 .25337 Mdot
.51686 .24223 Mdot
.51701 .22696 Mdot
.51716 .21282 Mdot
.51731 .20467 Mdot
.51746 .20008 Mdot
.51761 .19103 Mdot
.51776 .18366 Mdot
.51791 .1759 Mdot
.51806 .17616 Mdot
.51821 .18243 Mdot
.51836 .17959 Mdot
.51851 .1723 Mdot
.51866 .17544 Mdot
.51881 .18703 Mdot
.51896 .19379 Mdot
.51911 .20146 Mdot
.51926 .22441 Mdot
.51941 .25717 Mdot
.51957 .28054 Mdot
.51972 .29307 Mdot
.51987 .30174 Mdot
.52002 .30979 Mdot
.52017 .31844 Mdot
.52032 .32362 Mdot
.52047 .32907 Mdot
.52062 .34576 Mdot
.52077 .36957 Mdot
.52092 .39316 Mdot
.52107 .40642 Mdot
.52122 .4109 Mdot
.52137 .41289 Mdot
.52152 .42058 Mdot
.52167 .433 Mdot
.52182 .44133 Mdot
.52197 .43029 Mdot
.52212 .40512 Mdot
.52227 .37621 Mdot
.52242 .35778 Mdot
.52258 .34568 Mdot
.52273 .34804 Mdot
.52288 .36352 Mdot
.52303 .38681 Mdot
.52318 .40081 Mdot
.52333 .40164 Mdot
.52348 .3987 Mdot
.52363 .40567 Mdot
.52378 .40136 Mdot
.52393 .37942 Mdot
.52408 .34575 Mdot
.52423 .32019 Mdot
.52438 .30717 Mdot
.52453 .3074 Mdot
.52468 .31418 Mdot
.52483 .32449 Mdot
.52498 .33576 Mdot
.52513 .34725 Mdot
.52528 .35811 Mdot
.52543 .3688 Mdot
.52559 .36846 Mdot
.52574 .35855 Mdot
.52589 .34875 Mdot
.52604 .33884 Mdot
.52619 .31512 Mdot
.52634 .28583 Mdot
.52649 .26867 Mdot
.52664 .25624 Mdot
.52679 .245 Mdot
.52694 .23555 Mdot
.52709 .23389 Mdot
.52724 .24114 Mdot
.52739 .25224 Mdot
.52754 .2559 Mdot
.52769 .2482 Mdot
.52784 .23453 Mdot
.52799 .21814 Mdot
.52814 .20227 Mdot
.52829 .18797 Mdot
.52845 .18145 Mdot
.5286 .18436 Mdot
.52875 .18939 Mdot
.5289 .20312 Mdot
.52905 .2233 Mdot
.5292 .23607 Mdot
.52935 .24545 Mdot
.5295 .25722 Mdot
.52965 .27382 Mdot
.5298 .2933 Mdot
.52995 .31189 Mdot
.5301 .32417 Mdot
.53025 .32966 Mdot
.5304 .32717 Mdot
.53055 .32327 Mdot
.5307 .32495 Mdot
.53085 .32693 Mdot
.531 .32789 Mdot
.53115 .32037 Mdot
.5313 .31229 Mdot
.53146 .30758 Mdot
.53161 .31168 Mdot
.53176 .32731 Mdot
.53191 .3386 Mdot
.53206 .34574 Mdot
.53221 .34631 Mdot
.53236 .33802 Mdot
.53251 .33557 Mdot
.53266 .34029 Mdot
.53281 .34643 Mdot
.53296 .33465 Mdot
.53311 .3205 Mdot
.53326 .30957 Mdot
.53341 .31109 Mdot
.53356 .31543 Mdot
.53371 .32319 Mdot
.53386 .34155 Mdot
.53401 .3699 Mdot
.53416 .40235 Mdot
.53431 .43365 Mdot
.53447 .45357 Mdot
.53462 .45608 Mdot
.53477 .43799 Mdot
.53492 .41552 Mdot
.53507 .38587 Mdot
.53522 .36444 Mdot
.53537 .34415 Mdot
.53552 .32434 Mdot
.53567 .29825 Mdot
.53582 .28299 Mdot
.53597 .28448 Mdot
.53612 .30936 Mdot
.53627 .34155 Mdot
.53642 .36626 Mdot
.53657 .35567 Mdot
.53672 .32834 Mdot
.53687 .29937 Mdot
.53702 .29822 Mdot
.53717 .30002 Mdot
.53732 .3063 Mdot
.53748 .30026 Mdot
.53763 .28726 Mdot
.53778 .28626 Mdot
.53793 .30575 Mdot
.53808 .33486 Mdot
.53823 .36824 Mdot
.53838 .38382 Mdot
.53853 .38067 Mdot
.53868 .36629 Mdot
.53883 .35107 Mdot
.53898 .33826 Mdot
.53913 .32905 Mdot
.53928 .30436 Mdot
.53943 .26232 Mdot
.53958 .22268 Mdot
.53973 .19734 Mdot
.53988 .1924 Mdot
.54003 .20435 Mdot
.54018 .21878 Mdot
.54033 .21222 Mdot
.54049 .20809 Mdot
.54064 .20719 Mdot
.54079 .20299 Mdot
.54094 .20016 Mdot
.54109 .20301 Mdot
.54124 .19744 Mdot
.54139 .18839 Mdot
.54154 .18712 Mdot
.54169 .21134 Mdot
.54184 .24203 Mdot
.54199 .27 Mdot
.54214 .27555 Mdot
.54229 .28552 Mdot
.54244 .29932 Mdot
.54259 .32651 Mdot
.54274 .35506 Mdot
.54289 .37675 Mdot
.54304 .366 Mdot
.54319 .35674 Mdot
.54334 .35417 Mdot
.5435 .35649 Mdot
.54365 .35057 Mdot
.5438 .35469 Mdot
.54395 .34434 Mdot
.5441 .31839 Mdot
.54425 .29837 Mdot
.5444 .30401 Mdot
.54455 .31199 Mdot
.5447 .32409 Mdot
.54485 .33073 Mdot
.545 .32312 Mdot
.54515 .31274 Mdot
.5453 .32255 Mdot
.54545 .33906 Mdot
.5456 .34677 Mdot
.54575 .35266 Mdot
.5459 .34568 Mdot
.54605 .31931 Mdot
.5462 .28974 Mdot
.54635 .28381 Mdot
.54651 .30828 Mdot
.54666 .34556 Mdot
.54681 .36575 Mdot
.54696 .36631 Mdot
.54711 .3667 Mdot
.54726 .36425 Mdot
.54741 .36432 Mdot
.54756 .367 Mdot
.54771 .3563 Mdot
.54786 .32293 Mdot
.54801 .29389 Mdot
.54816 .27448 Mdot
.54831 .26111 Mdot
.54846 .27706 Mdot
.54861 .29901 Mdot
.54876 .31556 Mdot
.54891 .32219 Mdot
.54906 .32964 Mdot
.54921 .33414 Mdot
.54936 .35002 Mdot
.54952 .36544 Mdot
.54967 .38169 Mdot
.54982 .3814 Mdot
.54997 .36861 Mdot
.55012 .34738 Mdot
.55027 .33732 Mdot
.55042 .3237 Mdot
.55057 .31995 Mdot
.55072 .32814 Mdot
.55087 .33818 Mdot
.55102 .32861 Mdot
.55117 .33336 Mdot
.55132 .34119 Mdot
.55147 .3325 Mdot
.55162 .31137 Mdot
.55177 .29999 Mdot
.55192 .28241 Mdot
.55207 .27021 Mdot
.55222 .26598 Mdot
.55237 .26397 Mdot
.55253 .22741 Mdot
.55268 .19537 Mdot
.55283 .18956 Mdot
.55298 .20742 Mdot
.55313 .23203 Mdot
.55328 .27561 Mdot
.55343 .28882 Mdot
.55358 .27507 Mdot
.55373 .26752 Mdot
.55388 .27038 Mdot
.55403 .26881 Mdot
.55418 .26377 Mdot
.55433 .25759 Mdot
.55448 .24731 Mdot
.55463 .23968 Mdot
.55478 .24036 Mdot
.55493 .27454 Mdot
.55508 .3462 Mdot
.55523 .39444 Mdot
.55538 .38542 Mdot
.55554 .35396 Mdot
.55569 .31964 Mdot
.55584 .31002 Mdot
.55599 .33257 Mdot
.55614 .36139 Mdot
.55629 .35727 Mdot
.55644 .35431 Mdot
.55659 .34813 Mdot
.55674 .32846 Mdot
.55689 .30586 Mdot
.55704 .28891 Mdot
.55719 .26962 Mdot
.55734 .24161 Mdot
.55749 .22494 Mdot
.55764 .24003 Mdot
.55779 .28948 Mdot
.55794 .3354 Mdot
.55809 .35261 Mdot
.55824 .34441 Mdot
.5584 .30643 Mdot
.55855 .27454 Mdot
.5587 .26294 Mdot
.55885 .26401 Mdot
.559 .27033 Mdot
.55915 .29769 Mdot
.5593 .32524 Mdot
.55945 .33743 Mdot
.5596 .34786 Mdot
.55975 .38597 Mdot
.5599 .40661 Mdot
.56005 .40509 Mdot
.5602 .39396 Mdot
.56035 .40127 Mdot
.5605 .39465 Mdot
.56065 .40021 Mdot
.5608 .41391 Mdot
.56095 .41593 Mdot
.5611 .41121 Mdot
.56125 .41292 Mdot
.56141 .40278 Mdot
.56156 .39678 Mdot
.56171 .38687 Mdot
.56186 .3704 Mdot
.56201 .34846 Mdot
.56216 .34338 Mdot
.56231 .33702 Mdot
.56246 .3548 Mdot
.56261 .36047 Mdot
.56276 .34192 Mdot
.56291 .31961 Mdot
.56306 .32529 Mdot
.56321 .30832 Mdot
.56336 .28086 Mdot
.56351 .27057 Mdot
.56366 .25439 Mdot
.56381 .22573 Mdot
.56396 .21394 Mdot
.56411 .2096 Mdot
.56426 .21417 Mdot
.56442 .24696 Mdot
.56457 .27535 Mdot
.56472 .26295 Mdot
.56487 .20608 Mdot
.56502 .1621 Mdot
.56517 .12291 Mdot
.56532 .10995 Mdot
.56547 .12506 Mdot
.56562 .17867 Mdot
.56577 .21819 Mdot
.56592 .21982 Mdot
.56607 .19511 Mdot
.56622 .18367 Mdot
.56637 .1819 Mdot
.56652 .19454 Mdot
.56667 .21526 Mdot
.56682 .2323 Mdot
.56697 .23994 Mdot
.56712 .2726 Mdot
.56727 .31469 Mdot
.56743 .32863 Mdot
.56758 .3339 Mdot
.56773 .35983 Mdot
.56788 .37435 Mdot
.56803 .35225 Mdot
.56818 .35881 Mdot
.56833 .39301 Mdot
.56848 .42465 Mdot
.56863 .44663 Mdot
.56878 .4489 Mdot
.56893 .43163 Mdot
.56908 .42825 Mdot
.56923 .44691 Mdot
.56938 .44334 Mdot
.56953 .42713 Mdot
.56968 .41637 Mdot
.56983 .40898 Mdot
.56998 .42727 Mdot
.57013 .43052 Mdot
.57028 .41187 Mdot
.57044 .38421 Mdot
.57059 .35346 Mdot
.57074 .32543 Mdot
.57089 .332 Mdot
.57104 .3747 Mdot
.57119 .38228 Mdot
.57134 .35803 Mdot
.57149 .3213 Mdot
.57164 .29103 Mdot
.57179 .2993 Mdot
.57194 .33939 Mdot
.57209 .36938 Mdot
.57224 .36783 Mdot
.57239 .36321 Mdot
.57254 .35783 Mdot
.57269 .33935 Mdot
.57284 .33445 Mdot
.57299 .33472 Mdot
.57314 .33877 Mdot
.57329 .31457 Mdot
.57345 .29428 Mdot
.5736 .28619 Mdot
.57375 .30197 Mdot
.5739 .31587 Mdot
.57405 .30821 Mdot
.5742 .30279 Mdot
.57435 .27406 Mdot
.5745 .23539 Mdot
.57465 .2241 Mdot
.5748 .24484 Mdot
.57495 .25527 Mdot
.5751 .23959 Mdot
.57525 .23091 Mdot
.5754 .21044 Mdot
.57555 .20629 Mdot
.5757 .23586 Mdot
.57585 .23327 Mdot
.576 .20394 Mdot
.57615 .17983 Mdot
.5763 .19249 Mdot
.57646 .20348 Mdot
.57661 .23702 Mdot
.57676 .26893 Mdot
.57691 .26944 Mdot
.57706 .26334 Mdot
.57721 .26401 Mdot
.57736 .27445 Mdot
.57751 .2907 Mdot
.57766 .31497 Mdot
.57781 .33194 Mdot
.57796 .32919 Mdot
.57811 .33472 Mdot
.57826 .34262 Mdot
.57841 .38003 Mdot
.57856 .4054 Mdot
.57871 .41163 Mdot
.57886 .42734 Mdot
.57901 .44731 Mdot
.57916 .4373 Mdot
.57931 .40743 Mdot
.57947 .38997 Mdot
.57962 .36539 Mdot
.57977 .32761 Mdot
.57992 .31077 Mdot
.58007 .30019 Mdot
.58022 .30392 Mdot
.58037 .32682 Mdot
.58052 .35941 Mdot
.58067 .34511 Mdot
.58082 .30187 Mdot
.58097 .28226 Mdot
.58112 .28049 Mdot
.58127 .29596 Mdot
.58142 .31996 Mdot
.58157 .34146 Mdot
.58172 .33984 Mdot
.58187 .31752 Mdot
.58202 .30283 Mdot
.58217 .30208 Mdot
.58232 .3241 Mdot
.58248 .33409 Mdot
.58263 .34017 Mdot
.58278 .33758 Mdot
.58293 .32378 Mdot
.58308 .32445 Mdot
.58323 .34151 Mdot
.58338 .33584 Mdot
.58353 .31727 Mdot
.58368 .30655 Mdot
.58383 .27581 Mdot
.58398 .22963 Mdot
.58413 .24053 Mdot
.58428 .27288 Mdot
.58443 .29972 Mdot
.58458 .31217 Mdot
.58473 .30913 Mdot
.58488 .30248 Mdot
.58503 .32755 Mdot
.58518 .37119 Mdot
.58534 .39637 Mdot
.58549 .4078 Mdot
.58564 .39898 Mdot
.58579 .38509 Mdot
.58594 .39743 Mdot
.58609 .40762 Mdot
.58624 .41047 Mdot
.58639 .40257 Mdot
.58654 .38366 Mdot
.58669 .36379 Mdot
.58684 .37237 Mdot
.58699 .39011 Mdot
.58714 .36465 Mdot
.58729 .32957 Mdot
.58744 .2854 Mdot
.58759 .23237 Mdot
.58774 .18088 Mdot
.58789 .15803 Mdot
.58804 .15613 Mdot
.58819 .15321 Mdot
.58835 .1557 Mdot
.5885 .15483 Mdot
.58865 .14263 Mdot
.5888 .15919 Mdot
.58895 .19411 Mdot
.5891 .21099 Mdot
.58925 .19173 Mdot
.5894 .20446 Mdot
.58955 .23553 Mdot
.5897 .281 Mdot
.58985 .3251 Mdot
.59 .35965 Mdot
.59015 .36584 Mdot
.5903 .35021 Mdot
.59045 .33706 Mdot
.5906 .33941 Mdot
.59075 .37058 Mdot
.5909 .4039 Mdot
.59105 .41802 Mdot
.5912 .42102 Mdot
.59136 .40181 Mdot
.59151 .40419 Mdot
.59166 .42611 Mdot
.59181 .41874 Mdot
.59196 .38902 Mdot
.59211 .36262 Mdot
.59226 .34643 Mdot
.59241 .31866 Mdot
.59256 .31352 Mdot
.59271 .30045 Mdot
.59286 .29243 Mdot
.59301 .28703 Mdot
.59316 .2869 Mdot
.59331 .29745 Mdot
.59346 .34077 Mdot
.59361 .39128 Mdot
.59376 .42764 Mdot
.59391 .43288 Mdot
.59406 .40607 Mdot
.59421 .37925 Mdot
.59437 .39051 Mdot
.59452 .39331 Mdot
.59467 .39995 Mdot
.59482 .41921 Mdot
.59497 .43032 Mdot
.59512 .41675 Mdot
.59527 .39889 Mdot
.59542 .39232 Mdot
.59557 .38127 Mdot
.59572 .37772 Mdot
.59587 .36848 Mdot
.59602 .35861 Mdot
.59617 .3573 Mdot
.59632 .369 Mdot
.59647 .36717 Mdot
.59662 .33008 Mdot
.59677 .27516 Mdot
.59692 .23256 Mdot
.59707 .21608 Mdot
.59722 .21656 Mdot
.59738 .22906 Mdot
.59753 .25785 Mdot
.59768 .28082 Mdot
.59783 .30783 Mdot
.59798 .32687 Mdot
.59813 .33847 Mdot
.59828 .34493 Mdot
.59843 .32743 Mdot
.59858 .3023 Mdot
.59873 .26824 Mdot
.59888 .23673 Mdot
.59903 .23073 Mdot
.59918 .26107 Mdot
.59933 .27483 Mdot
.59948 .27264 Mdot
.59963 .27065 Mdot
.59978 .24505 Mdot
.59993 .22027 Mdot
.60008 .2422 Mdot
.60023 .27323 Mdot
.60039 .27587 Mdot
.60054 .26466 Mdot
.60069 .24977 Mdot
.60084 .24017 Mdot
.60099 .24836 Mdot
.60114 .27107 Mdot
.60129 .27603 Mdot
.60144 .27008 Mdot
.60159 .25474 Mdot
.60174 .26523 Mdot
.60189 .2828 Mdot
.60204 .3048 Mdot
.60219 .32862 Mdot
.60234 .36234 Mdot
.60249 .37611 Mdot
.60264 .39147 Mdot
.60279 .41727 Mdot
.60294 .443 Mdot
.60309 .44251 Mdot
.60324 .42698 Mdot
.6034 .39578 Mdot
.60355 .36144 Mdot
.6037 .35152 Mdot
.60385 .3891 Mdot
.604 .42467 Mdot
.60415 .44432 Mdot
.6043 .45549 Mdot
.60445 .44785 Mdot
.6046 .43004 Mdot
.60475 .40982 Mdot
.6049 .38977 Mdot
.60505 .34382 Mdot
.6052 .29168 Mdot
.60535 .27091 Mdot
.6055 .28982 Mdot
.60565 .31319 Mdot
.6058 .32783 Mdot
.60595 .32611 Mdot
.6061 .30697 Mdot
.60625 .28089 Mdot
.60641 .27901 Mdot
.60656 .30568 Mdot
.60671 .33777 Mdot
.60686 .3506 Mdot
.60701 .35055 Mdot
.60716 .32769 Mdot
.60731 .30552 Mdot
.60746 .30474 Mdot
.60761 .32361 Mdot
.60776 .32285 Mdot
.60791 .30737 Mdot
.60806 .29873 Mdot
.60821 .29723 Mdot
.60836 .30626 Mdot
.60851 .33899 Mdot
.60866 .36318 Mdot
.60881 .34919 Mdot
.60896 .3299 Mdot
.60911 .30951 Mdot
.60926 .29794 Mdot
.60942 .30252 Mdot
.60957 .30004 Mdot
.60972 .28438 Mdot
.60987 .26695 Mdot
.61002 .24229 Mdot
.61017 .2328 Mdot
.61032 .24431 Mdot
.61047 .26218 Mdot
.61062 .27043 Mdot
.61077 .27414 Mdot
.61092 .25966 Mdot
.61107 .24067 Mdot
.61122 .24221 Mdot
.61137 .25293 Mdot
.61152 .26107 Mdot
.61167 .26102 Mdot
.61182 .27047 Mdot
.61197 .26475 Mdot
.61212 .26948 Mdot
.61227 .28397 Mdot
.61243 .3028 Mdot
.61258 .30184 Mdot
.61273 .30613 Mdot
.61288 .32259 Mdot
.61303 .33611 Mdot
.61318 .34319 Mdot
.61333 .35783 Mdot
.61348 .36637 Mdot
.61363 .38007 Mdot
.61378 .39367 Mdot
.61393 .40279 Mdot
.61408 .37351 Mdot
.61423 .3404 Mdot
.61438 .32634 Mdot
.61453 .32907 Mdot
.61468 .32991 Mdot
.61483 .32083 Mdot
.61498 .32744 Mdot
.61513 .33995 Mdot
.61529 .33988 Mdot
.61544 .32857 Mdot
.61559 .32342 Mdot
.61574 .31622 Mdot
.61589 .32412 Mdot
.61604 .33807 Mdot
.61619 .32539 Mdot
.61634 .30036 Mdot
.61649 .30121 Mdot
.61664 .29131 Mdot
.61679 .27284 Mdot
.61694 .26448 Mdot
.61709 .29694 Mdot
.61724 .33988 Mdot
.61739 .37954 Mdot
.61754 .39711 Mdot
.61769 .39338 Mdot
.61784 .3799 Mdot
.61799 .36077 Mdot
.61814 .34622 Mdot
.6183 .32801 Mdot
.61845 .30298 Mdot
.6186 .27951 Mdot
.61875 .27698 Mdot
.6189 .28121 Mdot
.61905 .29531 Mdot
.6192 .31446 Mdot
.61935 .31758 Mdot
.6195 .29172 Mdot
.61965 .28143 Mdot
.6198 .28186 Mdot
.61995 .3025 Mdot
.6201 .31305 Mdot
.62025 .33273 Mdot
.6204 .3182 Mdot
.62055 .28266 Mdot
.6207 .26569 Mdot
.62085 .26997 Mdot
.621 .27461 Mdot
.62115 .29733 Mdot
.62131 .31059 Mdot
.62146 .30248 Mdot
.62161 .29097 Mdot
.62176 .30863 Mdot
.62191 .33053 Mdot
.62206 .34949 Mdot
.62221 .33876 Mdot
.62236 .31341 Mdot
.62251 .27461 Mdot
.62266 .24169 Mdot
.62281 .22334 Mdot
.62296 .21964 Mdot
.62311 .22261 Mdot
.62326 .20435 Mdot
.62341 .19976 Mdot
.62356 .2049 Mdot
.62371 .19313 Mdot
.62386 .19407 Mdot
.62401 .21528 Mdot
.62416 .2285 Mdot
.62432 .22964 Mdot
.62447 .23986 Mdot
.62462 .25515 Mdot
.62477 .26668 Mdot
.62492 .29877 Mdot
.62507 .31008 Mdot
.62522 .3152 Mdot
.62537 .30267 Mdot
.62552 .31877 Mdot
.62567 .33187 Mdot
.62582 .34956 Mdot
.62597 .34226 Mdot
.62612 .34572 Mdot
.62627 .35791 Mdot
.62642 .37321 Mdot
.62657 .38239 Mdot
.62672 .39134 Mdot
.62687 .37934 Mdot
.62702 .36471 Mdot
.62717 .33642 Mdot
.62733 .30149 Mdot
.62748 .25434 Mdot
.62763 .23087 Mdot
.62778 .2307 Mdot
.62793 .2242 Mdot
.62808 .22425 Mdot
.62823 .24067 Mdot
.62838 .26603 Mdot
.62853 .27618 Mdot
.62868 .30012 Mdot
.62883 .29576 Mdot
.62898 .26711 Mdot
.62913 .25037 Mdot
.62928 .25529 Mdot
.62943 .27965 Mdot
.62958 .30896 Mdot
.62973 .32818 Mdot
.62988 .32533 Mdot
.63003 .31644 Mdot
.63018 .30538 Mdot
.63034 .30679 Mdot
.63049 .3247 Mdot
.63064 .3181 Mdot
.63079 .29429 Mdot
.63094 .27646 Mdot
.63109 .25795 Mdot
.63124 .24839 Mdot
.63139 .27325 Mdot
.63154 .30167 Mdot
.63169 .30872 Mdot
.63184 .30297 Mdot
.63199 .29219 Mdot
.63214 .28271 Mdot
.63229 .3016 Mdot
.63244 .323 Mdot
.63259 .34482 Mdot
.63274 .3533 Mdot
.63289 .36555 Mdot
.63304 .3654 Mdot
.63319 .36529 Mdot
.63335 .36393 Mdot
.6335 .36469 Mdot
.63365 .35151 Mdot
.6338 .32847 Mdot
.63395 .30664 Mdot
.6341 .31811 Mdot
.63425 .33096 Mdot
.6344 .33485 Mdot
.63455 .32263 Mdot
.6347 .32507 Mdot
.63485 .30342 Mdot
.635 .279 Mdot
.63515 .26608 Mdot
.6353 .27277 Mdot
.63545 .24836 Mdot
.6356 .23146 Mdot
.63575 .22919 Mdot
.6359 .23247 Mdot
.63605 .24253 Mdot
.6362 .26806 Mdot
.63636 .24447 Mdot
.63651 .21475 Mdot
.63666 .221 Mdot
.63681 .24616 Mdot
.63696 .25751 Mdot
.63711 .25812 Mdot
.63726 .25054 Mdot
.63741 .23639 Mdot
.63756 .2432 Mdot
.63771 .2671 Mdot
.63786 .30972 Mdot
.63801 .36319 Mdot
.63816 .39085 Mdot
.63831 .36847 Mdot
.63846 .32645 Mdot
.63861 .28945 Mdot
.63876 .27916 Mdot
.63891 .30796 Mdot
.63906 .34286 Mdot
.63921 .34469 Mdot
.63937 .34919 Mdot
.63952 .34504 Mdot
.63967 .34018 Mdot
.63982 .33851 Mdot
.63997 .33074 Mdot
.64012 .29605 Mdot
.64027 .24267 Mdot
.64042 .19774 Mdot
.64057 .18631 Mdot
.64072 .2257 Mdot
.64087 .27302 Mdot
.64102 .29978 Mdot
.64117 .3123 Mdot
.64132 .29542 Mdot
.64147 .28598 Mdot
.64162 .27356 Mdot
.64177 .26483 Mdot
.64192 .25775 Mdot
.64207 .29173 Mdot
.64223 .32531 Mdot
.64238 .34 Mdot
.64253 .34854 Mdot
.64268 .38033 Mdot
.64283 .39371 Mdot
.64298 .38155 Mdot
.64313 .3562 Mdot
.64328 .355 Mdot
.64343 .33966 Mdot
.64358 .35001 Mdot
.64373 .35456 Mdot
.64388 .34647 Mdot
.64403 .34166 Mdot
.64418 .35268 Mdot
.64433 .34163 Mdot
.64448 .34181 Mdot
.64463 .35276 Mdot
.64478 .34245 Mdot
.64493 .32446 Mdot
.64508 .3267 Mdot
.64524 .3279 Mdot
.64539 .35419 Mdot
.64554 .3708 Mdot
.64569 .35066 Mdot
.64584 .31198 Mdot
.64599 .30541 Mdot
.64614 .29109 Mdot
.64629 .28145 Mdot
.64644 .29683 Mdot
.64659 .28755 Mdot
.64674 .2625 Mdot
.64689 .24063 Mdot
.64704 .23096 Mdot
.64719 .23779 Mdot
.64734 .2886 Mdot
.64749 .31904 Mdot
.64764 .28982 Mdot
.64779 .20936 Mdot
.64794 .15184 Mdot
.64809 .11517 Mdot
.64825 .12613 Mdot
.6484 .16206 Mdot
.64855 .22223 Mdot
.6487 .2567 Mdot
.64885 .26252 Mdot
.649 .2393 Mdot
.64915 .22465 Mdot
.6493 .22184 Mdot
.64945 .23213 Mdot
.6496 .24224 Mdot
.64975 .24603 Mdot
.6499 .25632 Mdot
.65005 .29496 Mdot
.6502 .35583 Mdot
.65035 .38273 Mdot
.6505 .37818 Mdot
.65065 .37315 Mdot
.6508 .37187 Mdot
.65095 .35607 Mdot
.6511 .37264 Mdot
.65126 .40067 Mdot
.65141 .4124 Mdot
.65156 .41499 Mdot
.65171 .41543 Mdot
.65186 .40319 Mdot
.65201 .4022 Mdot
.65216 .41474 Mdot
.65231 .40953 Mdot
.65246 .39906 Mdot
.65261 .40089 Mdot
.65276 .39878 Mdot
.65291 .4014 Mdot
.65306 .3917 Mdot
.65321 .35931 Mdot
.65336 .32115 Mdot
.65351 .29323 Mdot
.65366 .27333 Mdot
.65381 .28154 Mdot
.65396 .32395 Mdot
.65411 .33322 Mdot
.65427 .31096 Mdot
.65442 .27672 Mdot
.65457 .25211 Mdot
.65472 .26181 Mdot
.65487 .29759 Mdot
.65502 .31736 Mdot
.65517 .30679 Mdot
.65532 .29593 Mdot
.65547 .30159 Mdot
.65562 .30527 Mdot
.65577 .31938 Mdot
.65592 .32628 Mdot
.65607 .32826 Mdot
.65622 .30295 Mdot
.65637 .28529 Mdot
.65652 .28377 Mdot
.65667 .30562 Mdot
.65682 .32196 Mdot
.65697 .31865 Mdot
.65712 .31189 Mdot
.65728 .281 Mdot
.65743 .23443 Mdot
.65758 .21922 Mdot
.65773 .24633 Mdot
.65788 .27752 Mdot
.65803 .28625 Mdot
.65818 .29431 Mdot
.65833 .28117 Mdot
.65848 .26781 Mdot
.65863 .28516 Mdot
.65878 .28025 Mdot
.65893 .25797 Mdot
.65908 .24536 Mdot
.65923 .26998 Mdot
.65938 .28833 Mdot
.65953 .31588 Mdot
.65968 .33129 Mdot
.65983 .32049 Mdot
.65998 .302 Mdot
.66013 .29055 Mdot
.66029 .29034 Mdot
.66044 .29972 Mdot
.66059 .31702 Mdot
.66074 .33889 Mdot
.66089 .34082 Mdot
.66104 .33553 Mdot
.66119 .3246 Mdot
.66134 .34221 Mdot
.66149 .35236 Mdot
.66164 .34477 Mdot
.66179 .34858 Mdot
.66194 .3636 Mdot
.66209 .35981 Mdot
.66224 .34898 Mdot
.66239 .35243 Mdot
.66254 .34171 Mdot
.66269 .30471 Mdot
.66284 .28807 Mdot
.66299 .28573 Mdot
.66314 .29782 Mdot
.6633 .3386 Mdot
.66345 .3883 Mdot
.6636 .38863 Mdot
.66375 .35149 Mdot
.6639 .33133 Mdot
.66405 .31717 Mdot
.6642 .3084 Mdot
.66435 .31164 Mdot
.6645 .3207 Mdot
.66465 .31135 Mdot
.6648 .27524 Mdot
.66495 .25897 Mdot
.6651 .26955 Mdot
.66525 .29805 Mdot
.6654 .30002 Mdot
.66555 .29507 Mdot
.6657 .27891 Mdot
.66585 .26637 Mdot
.666 .2819 Mdot
.66615 .31214 Mdot
.66631 .31227 Mdot
.66646 .31296 Mdot
.66661 .32253 Mdot
.66676 .31203 Mdot
.66691 .27513 Mdot
.66706 .27609 Mdot
.66721 .29259 Mdot
.66736 .30483 Mdot
.66751 .3109 Mdot
.66766 .31508 Mdot
.66781 .32047 Mdot
.66796 .34428 Mdot
.66811 .38906 Mdot
.66826 .4168 Mdot
.66841 .41059 Mdot
.66856 .38012 Mdot
.66871 .35325 Mdot
.66886 .34797 Mdot
.66901 .34524 Mdot
.66917 .33508 Mdot
.66932 .31837 Mdot
.66947 .29249 Mdot
.66962 .27727 Mdot
.66977 .28999 Mdot
.66992 .32137 Mdot
.67007 .30673 Mdot
.67022 .28456 Mdot
.67037 .26259 Mdot
.67052 .23144 Mdot
.67067 .19423 Mdot
.67082 .19157 Mdot
.67097 .19909 Mdot
.67112 .19975 Mdot
.67127 .20921 Mdot
.67142 .21815 Mdot
.67157 .20579 Mdot
.67172 .21551 Mdot
.67187 .24327 Mdot
.67202 .26527 Mdot
.67218 .26009 Mdot
.67233 .27621 Mdot
.67248 .30385 Mdot
.67263 .33828 Mdot
.67278 .37065 Mdot
.67293 .38946 Mdot
.67308 .38951 Mdot
.67323 .36631 Mdot
.67338 .34866 Mdot
.67353 .35413 Mdot
.67368 .39085 Mdot
.67383 .42636 Mdot
.67398 .45048 Mdot
.67413 .45525 Mdot
.67428 .43363 Mdot
.67443 .42294 Mdot
.67458 .43485 Mdot
.67473 .42484 Mdot
.67488 .40211 Mdot
.67503 .3802 Mdot
.67519 .36795 Mdot
.67534 .3414 Mdot
.67549 .32675 Mdot
.67564 .3066 Mdot
.67579 .28669 Mdot
.67594 .26521 Mdot
.67609 .25781 Mdot
.67624 .27087 Mdot
.67639 .31067 Mdot
.67654 .35889 Mdot
.67669 .39412 Mdot
.67684 .38952 Mdot
.67699 .34692 Mdot
.67714 .31153 Mdot
.67729 .31688 Mdot
.67744 .31502 Mdot
.67759 .31638 Mdot
.67774 .32799 Mdot
.67789 .33401 Mdot
.67804 .31652 Mdot
.6782 .29685 Mdot
.67835 .29216 Mdot
.6785 .28288 Mdot
.67865 .27895 Mdot
.6788 .27694 Mdot
.67895 .27711 Mdot
.6791 .28827 Mdot
.67925 .32096 Mdot
.6794 .34277 Mdot
.67955 .32197 Mdot
.6797 .27136 Mdot
.67985 .22409 Mdot
.68 .20446 Mdot
.68015 .21251 Mdot
.6803 .23496 Mdot
.68045 .27132 Mdot
.6806 .29935 Mdot
.68075 .32345 Mdot
.6809 .34966 Mdot
.68105 .37781 Mdot
.68121 .38749 Mdot
.68136 .36363 Mdot
.68151 .33379 Mdot
.68166 .30323 Mdot
.68181 .27726 Mdot
.68196 .28262 Mdot
.68211 .31909 Mdot
.68226 .33417 Mdot
.68241 .3277 Mdot
.68256 .31985 Mdot
.68271 .29383 Mdot
.68286 .27364 Mdot
.68301 .29878 Mdot
.68316 .33661 Mdot
.68331 .34339 Mdot
.68346 .32994 Mdot
.68361 .31139 Mdot
.68376 .29876 Mdot
.68391 .29299 Mdot
.68406 .30585 Mdot
.68422 .31287 Mdot
.68437 .30539 Mdot
.68452 .28793 Mdot
.68467 .30092 Mdot
.68482 .31516 Mdot
.68497 .3278 Mdot
.68512 .33644 Mdot
.68527 .34807 Mdot
.68542 .34626 Mdot
.68557 .35985 Mdot
.68572 .38672 Mdot
.68587 .40755 Mdot
.68602 .39962 Mdot
.68617 .38432 Mdot
.68632 .36177 Mdot
.68647 .32993 Mdot
.68662 .31616 Mdot
.68677 .3408 Mdot
.68692 .37028 Mdot
.68707 .38618 Mdot
.68723 .40169 Mdot
.68738 .39957 Mdot
.68753 .38841 Mdot
.68768 .36906 Mdot
.68783 .34756 Mdot
.68798 .30143 Mdot
.68813 .25521 Mdot
.68828 .23786 Mdot
.68843 .26117 Mdot
.68858 .28002 Mdot
.68873 .288 Mdot
.68888 .28717 Mdot
.68903 .28197 Mdot
.68918 .26342 Mdot
.68933 .26378 Mdot
.68948 .29199 Mdot
.68963 .33077 Mdot
.68978 .35889 Mdot
.68993 .38229 Mdot
.69008 .3743 Mdot
.69024 .34654 Mdot
.69039 .33809 Mdot
.69054 .35162 Mdot
.69069 .3473 Mdot
.69084 .32449 Mdot
.69099 .31226 Mdot
.69114 .29485 Mdot
.69129 .28061 Mdot
.69144 .2991 Mdot
.69159 .32964 Mdot
.69174 .33054 Mdot
.69189 .33013 Mdot
.69204 .32403 Mdot
.69219 .31712 Mdot
.69234 .30939 Mdot
.69249 .29248 Mdot
.69264 .27075 Mdot
.69279 .25489 Mdot
.69294 .23653 Mdot
.69309 .2304 Mdot
.69325 .23843 Mdot
.6934 .25382 Mdot
.69355 .27583 Mdot
.6937 .30276 Mdot
.69385 .30768 Mdot
.694 .29754 Mdot
.69415 .30645 Mdot
.6943 .32004 Mdot
.69445 .32148 Mdot
.6946 .31282 Mdot
.69475 .31577 Mdot
.6949 .29984 Mdot
.69505 .29739 Mdot
.6952 .30825 Mdot
.69535 .32588 Mdot
.6955 .32226 Mdot
.69565 .32484 Mdot
.6958 .32853 Mdot
.69595 .33233 Mdot
.6961 .34269 Mdot
.69626 .36928 Mdot
.69641 .37306 Mdot
.69656 .36479 Mdot
.69671 .35491 Mdot
.69686 .35226 Mdot
.69701 .32492 Mdot
.69716 .29521 Mdot
.69731 .27848 Mdot
.69746 .27781 Mdot
.69761 .27441 Mdot
.69776 .27518 Mdot
.69791 .29702 Mdot
.69806 .32052 Mdot
.69821 .33428 Mdot
.69836 .33105 Mdot
.69851 .32222 Mdot
.69866 .30449 Mdot
.69881 .31877 Mdot
.69896 .34576 Mdot
.69912 .34509 Mdot
.69927 .32069 Mdot
.69942 .32322 Mdot
.69957 .31043 Mdot
.69972 .28589 Mdot
.69987 .26666 Mdot
.70002 .28356 Mdot
.70017 .30015 Mdot
.70032 .31927 Mdot
.70047 .32505 Mdot
.70062 .32095 Mdot
.70077 .30228 Mdot
.70092 .28381 Mdot
.70107 .27507 Mdot
.70122 .26886 Mdot
.70137 .26068 Mdot
.70152 .27146 Mdot
.70167 .29978 Mdot
.70182 .30891 Mdot
.70197 .3119 Mdot
.70213 .31764 Mdot
.70228 .31227 Mdot
.70243 .29972 Mdot
.70258 .3179 Mdot
.70273 .33764 Mdot
.70288 .34429 Mdot
.70303 .33549 Mdot
.70318 .33908 Mdot
.70333 .32833 Mdot
.70348 .31214 Mdot
.70363 .30163 Mdot
.70378 .28764 Mdot
.70393 .26119 Mdot
.70408 .25905 Mdot
.70423 .27069 Mdot
.70438 .27782 Mdot
.70453 .27917 Mdot
.70468 .30452 Mdot
.70483 .32412 Mdot
.70498 .33207 Mdot
.70514 .32074 Mdot
.70529 .31292 Mdot
.70544 .29289 Mdot
.70559 .26824 Mdot
.70574 .25294 Mdot
.70589 .24303 Mdot
.70604 .23848 Mdot
.70619 .23462 Mdot
.70634 .25057 Mdot
.70649 .27092 Mdot
.70664 .27472 Mdot
.70679 .28903 Mdot
.70694 .31024 Mdot
.70709 .31699 Mdot
.70724 .31805 Mdot
.70739 .32585 Mdot
.70754 .31952 Mdot
.70769 .29988 Mdot
.70784 .30423 Mdot
.70799 .30725 Mdot
.70815 .3026 Mdot
.7083 .28223 Mdot
.70845 .28235 Mdot
.7086 .27512 Mdot
.70875 .27768 Mdot
.7089 .28792 Mdot
.70905 .30449 Mdot
.7092 .30839 Mdot
.70935 .30702 Mdot
.7095 .3058 Mdot
.70965 .30184 Mdot
.7098 .29257 Mdot
.70995 .30588 Mdot
.7101 .31328 Mdot
.71025 .29284 Mdot
.7104 .25854 Mdot
.71055 .25047 Mdot
.7107 .2647 Mdot
.71085 .27634 Mdot
.711 .30001 Mdot
.71116 .32296 Mdot
.71131 .33568 Mdot
.71146 .32475 Mdot
.71161 .32212 Mdot
.71176 .29929 Mdot
.71191 .27736 Mdot
.71206 .28275 Mdot
.71221 .30391 Mdot
.71236 .30882 Mdot
.71251 .30114 Mdot
.71266 .2967 Mdot
.71281 .29243 Mdot
.71296 .28474 Mdot
.71311 .28947 Mdot
.71326 .30433 Mdot
.71341 .31159 Mdot
.71356 .29657 Mdot
.71371 .28844 Mdot
.71386 .28412 Mdot
.71401 .26838 Mdot
.71417 .26208 Mdot
.71432 .27003 Mdot
.71447 .27699 Mdot
.71462 .27203 Mdot
.71477 .27726 Mdot
.71492 .27875 Mdot
.71507 .27422 Mdot
.71522 .28651 Mdot
.71537 .30894 Mdot
.71552 .31615 Mdot
.71567 .31692 Mdot
.71582 .3305 Mdot
.71597 .34338 Mdot
.71612 .34283 Mdot
.71627 .34373 Mdot
.71642 .33158 Mdot
.71657 .29809 Mdot
.71672 .26421 Mdot
.71687 .25879 Mdot
.71702 .27339 Mdot
.71718 .27836 Mdot
.71733 .29132 Mdot
.71748 .31157 Mdot
.71763 .32957 Mdot
.71778 .32066 Mdot
.71793 .30773 Mdot
.71808 .2976 Mdot
.71823 .29322 Mdot
.71838 .28819 Mdot
.71853 .29798 Mdot
.71868 .30168 Mdot
.71883 .29583 Mdot
.71898 .29255 Mdot
.71913 .29273 Mdot
.71928 .26935 Mdot
.71943 .26425 Mdot
.71958 .2805 Mdot
.71973 .29751 Mdot
.71988 .30157 Mdot
.72003 .30825 Mdot
.72019 .31265 Mdot
.72034 .30847 Mdot
.72049 .315 Mdot
.72064 .32903 Mdot
.72079 .32568 Mdot
.72094 .30151 Mdot
.72109 .28222 Mdot
.72124 .27587 Mdot
.72139 .26962 Mdot
.72154 .27061 Mdot
.72169 .27701 Mdot
.72184 .28539 Mdot
.72199 .28413 Mdot
.72214 .27751 Mdot
.72229 .27925 Mdot
.72244 .27766 Mdot
.72259 .29117 Mdot
.72274 .31348 Mdot
.72289 .32315 Mdot
.72304 .30694 Mdot
.7232 .29719 Mdot
.72335 .30167 Mdot
.7235 .29838 Mdot
.72365 .29453 Mdot
.7238 .29479 Mdot
.72395 .29117 Mdot
.7241 .29783 Mdot
.72425 .31282 Mdot
.7244 .33184 Mdot
.72455 .3271 Mdot
.7247 .32343 Mdot
.72485 .31624 Mdot
.725 .31769 Mdot
.72515 .30911 Mdot
.7253 .30263 Mdot
.72545 .31272 Mdot
.7256 .32475 Mdot
.72575 .32692 Mdot
.7259 .32213 Mdot
.72606 .31117 Mdot
.72621 .29305 Mdot
.72636 .27925 Mdot
.72651 .28807 Mdot
.72666 .28665 Mdot
.72681 .28625 Mdot
.72696 .29723 Mdot
.72711 .29713 Mdot
.72726 .27876 Mdot
.72741 .26809 Mdot
.72756 .27855 Mdot
.72771 .27515 Mdot
.72786 .28095 Mdot
.72801 .29624 Mdot
.72816 .31063 Mdot
.72831 .3146 Mdot
.72846 .31738 Mdot
.72861 .3169 Mdot
.72876 .30909 Mdot
.72891 .3122 Mdot
.72907 .32346 Mdot
.72922 .32709 Mdot
.72937 .32382 Mdot
.72952 .30475 Mdot
.72967 .29333 Mdot
.72982 .27979 Mdot
.72997 .27792 Mdot
.73012 .29142 Mdot
.73027 .31751 Mdot
.73042 .32585 Mdot
.73057 .31328 Mdot
.73072 .29746 Mdot
.73087 .28257 Mdot
.73102 .27715 Mdot
.73117 .29252 Mdot
.73132 .30674 Mdot
.73147 .30378 Mdot
.73162 .28828 Mdot
.73177 .29261 Mdot
.73192 .29705 Mdot
.73208 .2984 Mdot
.73223 .30872 Mdot
.73238 .31818 Mdot
.73253 .32102 Mdot
.73268 .31691 Mdot
.73283 .32315 Mdot
.73298 .32396 Mdot
.73313 .33294 Mdot
.73328 .3387 Mdot
.73343 .32595 Mdot
.73358 .30333 Mdot
.73373 .29565 Mdot
.73388 .30701 Mdot
.73403 .31932 Mdot
.73418 .31584 Mdot
.73433 .30732 Mdot
.73448 .30226 Mdot
.73463 .30713 Mdot
.73478 .30614 Mdot
.73493 .3107 Mdot
.73509 .31107 Mdot
.73524 .30571 Mdot
.73539 .30697 Mdot
.73554 .31415 Mdot
.73569 .31229 Mdot
.73584 .29188 Mdot
.73599 .28597 Mdot
.73614 .28153 Mdot
.73629 .27778 Mdot
.73644 .28685 Mdot
.73659 .30073 Mdot
.73674 .30401 Mdot
.73689 .30858 Mdot
.73704 .31794 Mdot
.73719 .32025 Mdot
.73734 .31556 Mdot
.73749 .3202 Mdot
.73764 .32181 Mdot
.73779 .31963 Mdot
.73794 .31276 Mdot
.7381 .30868 Mdot
.73825 .30276 Mdot
.7384 .30207 Mdot
.73855 .30351 Mdot
.7387 .29796 Mdot
.73885 .28851 Mdot
.739 .28337 Mdot
.73915 .29216 Mdot
.7393 .30524 Mdot
.73945 .31369 Mdot
.7396 .32109 Mdot
.73975 .32658 Mdot
.7399 .32927 Mdot
.74005 .33221 Mdot
.7402 .33279 Mdot
.74035 .31797 Mdot
.7405 .29645 Mdot
.74065 .29299 Mdot
.7408 .3077 Mdot
.74095 .32272 Mdot
.74111 .33575 Mdot
.74126 .34227 Mdot
.74141 .33351 Mdot
.74156 .31221 Mdot
.74171 .30206 Mdot
.74186 .29899 Mdot
.74201 .29845 Mdot
.74216 .30251 Mdot
.74231 .30995 Mdot
.74246 .30845 Mdot
.74261 .30224 Mdot
.74276 .29998 Mdot
.74291 .29487 Mdot
.74306 .29071 Mdot
.74321 .29478 Mdot
.74336 .30413 Mdot
.74351 .3154 Mdot
.74366 .32859 Mdot
.74381 .34221 Mdot
.74396 .34143 Mdot
.74412 .32433 Mdot
.74427 .30229 Mdot
.74442 .28661 Mdot
.74457 .27732 Mdot
.74472 .27179 Mdot
.74487 .27257 Mdot
.74502 .27643 Mdot
.74517 .28359 Mdot
.74532 .29305 Mdot
.74547 .29643 Mdot
.74562 .2909 Mdot
.74577 .29086 Mdot
.74592 .30532 Mdot
.74607 .31797 Mdot
.74622 .32812 Mdot
.74637 .33608 Mdot
.74652 .34365 Mdot
.74667 .35177 Mdot
.74682 .35368 Mdot
.74697 .34769 Mdot
.74713 .32461 Mdot
.74728 .30154 Mdot
.74743 .28653 Mdot
.74758 .27941 Mdot
.74773 .26938 Mdot
.74788 .27425 Mdot
.74803 .29356 Mdot
.74818 .31495 Mdot
.74833 .31853 Mdot
.74848 .31301 Mdot
.74863 .30313 Mdot
.74878 .30566 Mdot
.74893 .31539 Mdot
.74908 .32809 Mdot
.74923 .32586 Mdot
.74938 .32675 Mdot
.74953 .33202 Mdot
.74968 .33993 Mdot
.74983 .33823 Mdot
.74998 .32153 Mdot
.75014 .30453 Mdot
.75029 .29018 Mdot
.75044 .28309 Mdot
.75059 .28973 Mdot
.75074 .30359 Mdot
.75089 .30748 Mdot
.75104 .31447 Mdot
.75119 .32191 Mdot
.75134 .3167 Mdot
.75149 .30585 Mdot
.75164 .30083 Mdot
.75179 .29203 Mdot
.75194 .29453 Mdot
.75209 .29773 Mdot
.75224 .30466 Mdot
.75239 .30947 Mdot
.75254 .3191 Mdot
.75269 .31802 Mdot
.75284 .31536 Mdot
.753 .30537 Mdot
.75315 .29801 Mdot
.7533 .30015 Mdot
.75345 .30135 Mdot
.7536 .29561 Mdot
.75375 .29479 Mdot
.7539 .29422 Mdot
.75405 .29405 Mdot
.7542 .29994 Mdot
.75435 .30805 Mdot
.7545 .30913 Mdot
.75465 .30305 Mdot
.7548 .29909 Mdot
.75495 .30295 Mdot
.7551 .31765 Mdot
.75525 .32859 Mdot
.7554 .33538 Mdot
.75555 .32624 Mdot
.7557 .31385 Mdot
.75585 .30756 Mdot
.75601 .3129 Mdot
.75616 .31584 Mdot
.75631 .31711 Mdot
.75646 .31782 Mdot
.75661 .31424 Mdot
.75676 .30894 Mdot
.75691 .316 Mdot
.75706 .32034 Mdot
.75721 .31629 Mdot
.75736 .30178 Mdot
.75751 .29136 Mdot
.75766 .2924 Mdot
.75781 .30341 Mdot
.75796 .31364 Mdot
.75811 .32031 Mdot
.75826 .32227 Mdot
.75841 .31531 Mdot
.75856 .31215 Mdot
.75871 .30567 Mdot
.75886 .29704 Mdot
.75902 .29882 Mdot
.75917 .31191 Mdot
.75932 .32008 Mdot
.75947 .3205 Mdot
.75962 .31881 Mdot
.75977 .30876 Mdot
.75992 .29473 Mdot
.76007 .28804 Mdot
.76022 .28807 Mdot
.76037 .29138 Mdot
.76052 .2955 Mdot
.76067 .29931 Mdot
.76082 .30516 Mdot
.76097 .30489 Mdot
.76112 .30292 Mdot
.76127 .30215 Mdot
.76142 .30497 Mdot
.76157 .30532 Mdot
.76172 .30745 Mdot
.76187 .30437 Mdot
.76203 .30124 Mdot
.76218 .30318 Mdot
.76233 .31155 Mdot
.76248 .32388 Mdot
.76263 .3271 Mdot
.76278 .31849 Mdot
.76293 .30933 Mdot
.76308 .30572 Mdot
.76323 .30673 Mdot
.76338 .31214 Mdot
.76353 .3151 Mdot
.76368 .30832 Mdot
.76383 .31224 Mdot
.76398 .32699 Mdot
.76413 .32909 Mdot
.76428 .3193 Mdot
.76443 .30659 Mdot
.76458 .30333 Mdot
.76473 .31007 Mdot
.76488 .32507 Mdot
.76504 .33256 Mdot
.76519 .33107 Mdot
.76534 .3227 Mdot
.76549 .31318 Mdot
.76564 .30432 Mdot
.76579 .29378 Mdot
.76594 .28773 Mdot
.76609 .29337 Mdot
.76624 .29827 Mdot
.76639 .29888 Mdot
.76654 .29637 Mdot
.76669 .29347 Mdot
.76684 .29177 Mdot
.76699 .29997 Mdot
.76714 .30854 Mdot
.76729 .31004 Mdot
.76744 .31156 Mdot
.76759 .3149 Mdot
.76774 .31541 Mdot
.76789 .31735 Mdot
.76805 .31426 Mdot
.7682 .30601 Mdot
.76835 .29662 Mdot
.7685 .29216 Mdot
.76865 .29168 Mdot
.7688 .29559 Mdot
.76895 .29733 Mdot
.7691 .30284 Mdot
.76925 .31463 Mdot
.7694 .32232 Mdot
.76955 .32265 Mdot
.7697 .31703 Mdot
.76985 .30946 Mdot
.77 .30297 Mdot
.77015 .30647 Mdot
.7703 .31754 Mdot
.77045 .32586 Mdot
.7706 .32513 Mdot
.77075 .32045 Mdot
.7709 .31715 Mdot
.77106 .31518 Mdot
.77121 .31237 Mdot
.77136 .31198 Mdot
.77151 .30878 Mdot
.77166 .30433 Mdot
.77181 .30715 Mdot
.77196 .3173 Mdot
.77211 .31771 Mdot
.77226 .31303 Mdot
.77241 .31068 Mdot
.77256 .30486 Mdot
.77271 .29797 Mdot
.77286 .29983 Mdot
.77301 .30602 Mdot
.77316 .30728 Mdot
.77331 .3117 Mdot
.77346 .31836 Mdot
.77361 .32173 Mdot
.77376 .32236 Mdot
.77391 .32434 Mdot
.77407 .31517 Mdot
.77422 .2972 Mdot
.77437 .28622 Mdot
.77452 .28785 Mdot
.77467 .29523 Mdot
.77482 .30384 Mdot
.77497 .30685 Mdot
.77512 .30378 Mdot
.77527 .2986 Mdot
.77542 .29069 Mdot
.77557 .28636 Mdot
.77572 .29371 Mdot
.77587 .31016 Mdot
.77602 .32217 Mdot
.77617 .32146 Mdot
.77632 .30823 Mdot
.77647 .30226 Mdot
.77662 .30768 Mdot
.77677 .31146 Mdot
.77692 .30794 Mdot
.77708 .30949 Mdot
.77723 .31606 Mdot
.77738 .31852 Mdot
.77753 .31608 Mdot
.77768 .31555 Mdot
.77783 .31026 Mdot
.77798 .3084 Mdot
.77813 .31207 Mdot
.77828 .31526 Mdot
.77843 .31253 Mdot
.77858 .31481 Mdot
.77873 .3155 Mdot
.77888 .31795 Mdot
.77903 .32451 Mdot
.77918 .33009 Mdot
.77933 .32446 Mdot
.77948 .31311 Mdot
.77963 .30641 Mdot
.77978 .30829 Mdot
.77993 .31362 Mdot
.78009 .31929 Mdot
.78024 .32022 Mdot
.78039 .31418 Mdot
.78054 .3051 Mdot
.78069 .29647 Mdot
.78084 .28829 Mdot
.78099 .28031 Mdot
.78114 .27928 Mdot
.78129 .28504 Mdot
.78144 .29096 Mdot
.78159 .2938 Mdot
.78174 .3026 Mdot
.78189 .31513 Mdot
.78204 .32364 Mdot
.78219 .31985 Mdot
.78234 .32071 Mdot
.78249 .31537 Mdot
.78264 .3067 Mdot
.78279 .30061 Mdot
.78295 .3018 Mdot
.7831 .30229 Mdot
.78325 .30825 Mdot
.7834 .31377 Mdot
.78355 .3146 Mdot
.7837 .30664 Mdot
.78385 .29656 Mdot
.784 .29231 Mdot
.78415 .29283 Mdot
.7843 .29566 Mdot
.78445 .31331 Mdot
.7846 .33666 Mdot
.78475 .34181 Mdot
.7849 .33673 Mdot
.78505 .32875 Mdot
.7852 .32302 Mdot
.78535 .3172 Mdot
.7855 .31701 Mdot
.78565 .30805 Mdot
.7858 .30058 Mdot
.78596 .30001 Mdot
.78611 .30855 Mdot
.78626 .31799 Mdot
.78641 .33023 Mdot
.78656 .33473 Mdot
.78671 .32956 Mdot
.78686 .31246 Mdot
.78701 .29756 Mdot
.78716 .29233 Mdot
.78731 .30019 Mdot
.78746 .3057 Mdot
.78761 .31443 Mdot
.78776 .32165 Mdot
.78791 .32298 Mdot
.78806 .31736 Mdot
.78821 .30797 Mdot
.78836 .29366 Mdot
.78851 .28212 Mdot
.78866 .28503 Mdot
.78881 .29262 Mdot
.78897 .29671 Mdot
.78912 .30056 Mdot
.78927 .30723 Mdot
.78942 .30975 Mdot
.78957 .30819 Mdot
.78972 .30463 Mdot
.78987 .29858 Mdot
.79002 .29026 Mdot
.79017 .29098 Mdot
.79032 .2973 Mdot
.79047 .30708 Mdot
.79062 .31272 Mdot
.79077 .31938 Mdot
.79092 .32318 Mdot
.79107 .32235 Mdot
.79122 .31587 Mdot
.79137 .31042 Mdot
.79152 .30077 Mdot
.79167 .29777 Mdot
.79182 .30537 Mdot
.79198 .3148 Mdot
.79213 .31187 Mdot
.79228 .31107 Mdot
.79243 .31346 Mdot
.79258 .31868 Mdot
.79273 .32391 Mdot
.79288 .33164 Mdot
.79303 .33664 Mdot
.79318 .33702 Mdot
.79333 .33421 Mdot
.79348 .32708 Mdot
.79363 .31427 Mdot
.79378 .30068 Mdot
.79393 .30097 Mdot
.79408 .30617 Mdot
.79423 .30642 Mdot
.79438 .30152 Mdot
.79453 .29672 Mdot
.79468 .28696 Mdot
.79483 .28532 Mdot
.79499 .29136 Mdot
.79514 .30348 Mdot
.79529 .30475 Mdot
.79544 .30316 Mdot
.79559 .30474 Mdot
.79574 .30924 Mdot
.79589 .31205 Mdot
.79604 .32185 Mdot
.79619 .32655 Mdot
.79634 .31692 Mdot
.79649 .30406 Mdot
.79664 .29863 Mdot
.79679 .29909 Mdot
.79694 .30115 Mdot
.79709 .30441 Mdot
.79724 .30556 Mdot
.79739 .30306 Mdot
.79754 .29838 Mdot
.79769 .30192 Mdot
.79784 .30297 Mdot
.798 .29464 Mdot
.79815 .28775 Mdot
.7983 .29546 Mdot
.79845 .30062 Mdot
.7986 .30912 Mdot
.79875 .31833 Mdot
.7989 .32941 Mdot
.79905 .33468 Mdot
.7992 .33741 Mdot
.79935 .32778 Mdot
.7995 .31335 Mdot
.79965 .3056 Mdot
.7998 .30954 Mdot
.79995 .31604 Mdot
.8001 .31536 Mdot
.80025 .31343 Mdot
.8004 .31872 Mdot
.80055 .31939 Mdot
.8007 .31133 Mdot
.80085 .30286 Mdot
.80101 .29845 Mdot
.80116 .29725 Mdot
.80131 .30137 Mdot
.80146 .3107 Mdot
.80161 .31372 Mdot
.80176 .31694 Mdot
.80191 .31762 Mdot
.80206 .31899 Mdot
.80221 .31551 Mdot
.80236 .31338 Mdot
.80251 .30831 Mdot
.80266 .29536 Mdot
.80281 .28254 Mdot
.80296 .28391 Mdot
.80311 .29467 Mdot
.80326 .30465 Mdot
.80341 .31129 Mdot
.80356 .31242 Mdot
.80371 .30567 Mdot
.80386 .3016 Mdot
.80402 .30169 Mdot
.80417 .30562 Mdot
.80432 .30517 Mdot
.80447 .30514 Mdot
.80462 .31049 Mdot
.80477 .31371 Mdot
.80492 .31132 Mdot
.80507 .30599 Mdot
.80522 .30421 Mdot
.80537 .30172 Mdot
.80552 .30324 Mdot
.80567 .30843 Mdot
.80582 .30882 Mdot
.80597 .30757 Mdot
.80612 .31531 Mdot
.80627 .32969 Mdot
.80642 .33283 Mdot
.80657 .3277 Mdot
.80672 .32376 Mdot
.80687 .31625 Mdot
.80703 .31222 Mdot
.80718 .31413 Mdot
.80733 .31627 Mdot
.80748 .31376 Mdot
.80763 .31697 Mdot
.80778 .31815 Mdot
.80793 .31116 Mdot
.80808 .30177 Mdot
.80823 .29542 Mdot
.80838 .30404 Mdot
.80853 .31514 Mdot
.80868 .31796 Mdot
.80883 .3169 Mdot
.80898 .31766 Mdot
.80913 .31218 Mdot
.80928 .30681 Mdot
.80943 .30387 Mdot
.80958 .29924 Mdot
.80973 .29509 Mdot
.80989 .29829 Mdot
.81004 .29529 Mdot
.81019 .29255 Mdot
.81034 .28892 Mdot
.81049 .29215 Mdot
.81064 .29421 Mdot
.81079 .29928 Mdot
.81094 .30481 Mdot
.81109 .31022 Mdot
.81124 .31143 Mdot
.81139 .31053 Mdot
.81154 .31146 Mdot
.81169 .31153 Mdot
.81184 .31435 Mdot
.81199 .31819 Mdot
.81214 .31355 Mdot
.81229 .30235 Mdot
.81244 .29309 Mdot
.81259 .29228 Mdot
.81274 .30117 Mdot
.8129 .31045 Mdot
.81305 .31977 Mdot
.8132 .32031 Mdot
.81335 .31937 Mdot
.8135 .31799 Mdot
.81365 .32245 Mdot
.8138 .32256 Mdot
.81395 .3209 Mdot
.8141 .322 Mdot
.81425 .32404 Mdot
.8144 .32379 Mdot
.81455 .32025 Mdot
.8147 .31687 Mdot
.81485 .31268 Mdot
.815 .30846 Mdot
.81515 .30908 Mdot
.8153 .30717 Mdot
.81545 .30484 Mdot
.8156 .30618 Mdot
.81575 .31051 Mdot
.81591 .31008 Mdot
.81606 .30658 Mdot
.81621 .30367 Mdot
.81636 .29583 Mdot
.81651 .29508 Mdot
.81666 .29972 Mdot
.81681 .30559 Mdot
.81696 .31053 Mdot
.81711 .31341 Mdot
.81726 .31739 Mdot
.81741 .32251 Mdot
.81756 .32165 Mdot
.81771 .3101 Mdot
.81786 .30281 Mdot
.81801 .30415 Mdot
.81816 .30574 Mdot
.81831 .30995 Mdot
.81846 .3069 Mdot
.81861 .29398 Mdot
.81876 .27985 Mdot
.81892 .27859 Mdot
.81907 .28488 Mdot
.81922 .29154 Mdot
.81937 .29835 Mdot
.81952 .30334 Mdot
.81967 .30673 Mdot
.81982 .31286 Mdot
.81997 .31917 Mdot
.82012 .32366 Mdot
.82027 .32423 Mdot
.82042 .32804 Mdot
.82057 .32583 Mdot
.82072 .32124 Mdot
.82087 .31983 Mdot
.82102 .3185 Mdot
.82117 .3185 Mdot
.82132 .31862 Mdot
.82147 .31702 Mdot
.82162 .30977 Mdot
.82177 .30531 Mdot
.82193 .30215 Mdot
.82208 .30296 Mdot
.82223 .30903 Mdot
.82238 .31431 Mdot
.82253 .31737 Mdot
.82268 .31966 Mdot
.82283 .31693 Mdot
.82298 .31602 Mdot
.82313 .31507 Mdot
.82328 .314 Mdot
.82343 .30915 Mdot
.82358 .30884 Mdot
.82373 .30892 Mdot
.82388 .30834 Mdot
.82403 .31077 Mdot
.82418 .31171 Mdot
.82433 .30867 Mdot
.82448 .301 Mdot
.82463 .29799 Mdot
.82478 .29484 Mdot
.82494 .29196 Mdot
.82509 .29088 Mdot
.82524 .29042 Mdot
.82539 .29244 Mdot
.82554 .29681 Mdot
.82569 .30031 Mdot
.82584 .30414 Mdot
.82599 .30728 Mdot
.82614 .31287 Mdot
.82629 .31799 Mdot
.82644 .32331 Mdot
.82659 .32008 Mdot
.82674 .32028 Mdot
.82689 .32437 Mdot
.82704 .32368 Mdot
.82719 .31707 Mdot
.82734 .30819 Mdot
.82749 .30102 Mdot
.82764 .29803 Mdot
.82779 .30304 Mdot
.82795 .30943 Mdot
.8281 .3096 Mdot
.82825 .30555 Mdot
.8284 .30045 Mdot
.82855 .29997 Mdot
.8287 .30508 Mdot
.82885 .31552 Mdot
.829 .32402 Mdot
.82915 .32213 Mdot
.8293 .31898 Mdot
.82945 .31667 Mdot
.8296 .31907 Mdot
.82975 .31942 Mdot
.8299 .32076 Mdot
.83005 .31882 Mdot
.8302 .31649 Mdot
.83035 .30984 Mdot
.8305 .30236 Mdot
.83065 .29794 Mdot
.8308 .29878 Mdot
.83096 .29907 Mdot
.83111 .30396 Mdot
.83126 .30436 Mdot
.83141 .30169 Mdot
.83156 .30002 Mdot
.83171 .30266 Mdot
.83186 .30316 Mdot
.83201 .30389 Mdot
.83216 .30305 Mdot
.83231 .30094 Mdot
.83246 .3055 Mdot
.83261 .30992 Mdot
.83276 .31326 Mdot
.83291 .31455 Mdot
.83306 .31477 Mdot
.83321 .31341 Mdot
.83336 .31536 Mdot
.83351 .31485 Mdot
.83366 .31065 Mdot
.83381 .30688 Mdot
.83397 .30727 Mdot
.83412 .30621 Mdot
.83427 .30744 Mdot
.83442 .30554 Mdot
.83457 .30216 Mdot
.83472 .30041 Mdot
.83487 .30732 Mdot
.83502 .31438 Mdot
.83517 .32014 Mdot
.83532 .32344 Mdot
.83547 .32399 Mdot
.83562 .32239 Mdot
.83577 .32003 Mdot
.83592 .31808 Mdot
.83607 .31516 Mdot
.83622 .31241 Mdot
.83637 .30812 Mdot
.83652 .30309 Mdot
.83667 .29751 Mdot
.83682 .29747 Mdot
.83698 .30016 Mdot
.83713 .30303 Mdot
.83728 .30587 Mdot
.83743 .31023 Mdot
.83758 .3099 Mdot
.83773 .30942 Mdot
.83788 .30985 Mdot
.83803 .30947 Mdot
.83818 .31003 Mdot
.83833 .31247 Mdot
.83848 .31054 Mdot
.83863 .30566 Mdot
.83878 .30208 Mdot
.83893 .29968 Mdot
.83908 .30284 Mdot
.83923 .30829 Mdot
.83938 .30862 Mdot
.83953 .30434 Mdot
.83968 .30261 Mdot
.83984 .30231 Mdot
.83999 .30321 Mdot
.84014 .3022 Mdot
.84029 .30083 Mdot
.84044 .30153 Mdot
.84059 .30668 Mdot
.84074 .31141 Mdot
.84089 .31465 Mdot
.84104 .3154 Mdot
.84119 .31652 Mdot
.84134 .319 Mdot
.84149 .31953 Mdot
.84164 .31678 Mdot
.84179 .31764 Mdot
.84194 .3219 Mdot
.84209 .32648 Mdot
.84224 .33047 Mdot
.84239 .32591 Mdot
.84254 .31533 Mdot
.84269 .3056 Mdot
.84285 .30028 Mdot
.843 .29613 Mdot
.84315 .29777 Mdot
.8433 .30052 Mdot
.84345 .30264 Mdot
.8436 .30378 Mdot
.84375 .3058 Mdot
.8439 .30593 Mdot
.84405 .3059 Mdot
.8442 .30418 Mdot
.84435 .30522 Mdot
.8445 .30862 Mdot
.84465 .31263 Mdot
.8448 .31333 Mdot
.84495 .31336 Mdot
.8451 .30797 Mdot
.84525 .30267 Mdot
.8454 .30467 Mdot
.84555 .30822 Mdot
.8457 .3069 Mdot
.84586 .3032 Mdot
.84601 .29935 Mdot
.84616 .29849 Mdot
.84631 .30285 Mdot
.84646 .30445 Mdot
.84661 .30375 Mdot
.84676 .30641 Mdot
.84691 .30953 Mdot
.84706 .30888 Mdot
.84721 .30541 Mdot
.84736 .30134 Mdot
.84751 .30506 Mdot
.84766 .31617 Mdot
.84781 .32394 Mdot
.84796 .32319 Mdot
.84811 .31953 Mdot
.84826 .31588 Mdot
.84841 .31631 Mdot
.84856 .31541 Mdot
.84871 .31006 Mdot
.84887 .30565 Mdot
.84902 .30517 Mdot
.84917 .30348 Mdot
.84932 .30405 Mdot
.84947 .3054 Mdot
.84962 .30617 Mdot
.84977 .31123 Mdot
.84992 .31611 Mdot
.85007 .31492 Mdot
.85022 .31569 Mdot
.85037 .31637 Mdot
.85052 .3147 Mdot
.85067 .31508 Mdot
.85082 .31947 Mdot
.85097 .31869 Mdot
.85112 .31633 Mdot
.85127 .31153 Mdot
.85142 .30439 Mdot
.85157 .30065 Mdot
.85172 .30344 Mdot
.85188 .30652 Mdot
.85203 .30755 Mdot
.85218 .3069 Mdot
.85233 .30546 Mdot
.85248 .30285 Mdot
.85263 .30212 Mdot
.85278 .2998 Mdot
.85293 .29841 Mdot
.85308 .29705 Mdot
.85323 .29808 Mdot
.85338 .2975 Mdot
.85353 .29613 Mdot
.85368 .29955 Mdot
.85383 .30872 Mdot
.85398 .31944 Mdot
.85413 .32615 Mdot
.85428 .32646 Mdot
.85443 .32152 Mdot
.85458 .31614 Mdot
.85473 .31363 Mdot
.85489 .31087 Mdot
.85504 .30753 Mdot
.85519 .30626 Mdot
.85534 .30626 Mdot
.85549 .30467 Mdot
.85564 .29941 Mdot
.85579 .2981 Mdot
.85594 .30055 Mdot
.85609 .30783 Mdot
.85624 .31217 Mdot
.85639 .3161 Mdot
.85654 .31738 Mdot
.85669 .32004 Mdot
.85684 .32331 Mdot
.85699 .32511 Mdot
.85714 .32243 Mdot
.85729 .3204 Mdot
.85744 .31509 Mdot
.85759 .30709 Mdot
.85774 .29842 Mdot
.8579 .29328 Mdot
.85805 .29005 Mdot
.8582 .29403 Mdot
.85835 .29819 Mdot
.8585 .29957 Mdot
.85865 .30334 Mdot
.8588 .31092 Mdot
.85895 .31646 Mdot
.8591 .31877 Mdot
.85925 .31617 Mdot
.8594 .3121 Mdot
.85955 .31191 Mdot
.8597 .31306 Mdot
.85985 .30994 Mdot
.86 .30898 Mdot
.86015 .31145 Mdot
.8603 .31165 Mdot
.86045 .3076 Mdot
.8606 .30368 Mdot
.86075 .30099 Mdot
.86091 .30038 Mdot
.86106 .30251 Mdot
.86121 .30486 Mdot
.86136 .30538 Mdot
.86151 .30674 Mdot
.86166 .31132 Mdot
.86181 .31569 Mdot
.86196 .3155 Mdot
.86211 .31077 Mdot
.86226 .30576 Mdot
.86241 .30285 Mdot
.86256 .3044 Mdot
.86271 .3069 Mdot
.86286 .31062 Mdot
.86301 .31638 Mdot
.86316 .32291 Mdot
.86331 .32503 Mdot
.86346 .32301 Mdot
.86361 .31541 Mdot
.86376 .30617 Mdot
.86392 .29872 Mdot
.86407 .29514 Mdot
.86422 .29461 Mdot
.86437 .2989 Mdot
.86452 .30448 Mdot
.86467 .3094 Mdot
.86482 .31315 Mdot
.86497 .31476 Mdot
.86512 .31199 Mdot
.86527 .31024 Mdot
.86542 .30866 Mdot
.86557 .30513 Mdot
.86572 .30303 Mdot
.86587 .30571 Mdot
.86602 .31061 Mdot
.86617 .31609 Mdot
.86632 .31966 Mdot
.86647 .31866 Mdot
.86662 .31385 Mdot
.86678 .30801 Mdot
.86693 .30123 Mdot
.86708 .29594 Mdot
.86723 .29541 Mdot
.86738 .30296 Mdot
.86753 .31432 Mdot
.86768 .32246 Mdot
.86783 .32255 Mdot
.86798 .31701 Mdot
.86813 .31145 Mdot
.86828 .30665 Mdot
.86843 .30019 Mdot
.86858 .29419 Mdot
.86873 .29478 Mdot
.86888 .30055 Mdot
.86903 .3085 Mdot
.86918 .31782 Mdot
.86933 .3247 Mdot
.86948 .32535 Mdot
.86963 .3243 Mdot
.86979 .32078 Mdot
.86994 .31122 Mdot
.87009 .30317 Mdot
.87024 .30277 Mdot
.87039 .30503 Mdot
.87054 .31025 Mdot
.87069 .31738 Mdot
.87084 .32072 Mdot
.87099 .31903 Mdot
.87114 .31443 Mdot
.87129 .30459 Mdot
.87144 .29646 Mdot
.87159 .29478 Mdot
.87174 .29672 Mdot
.87189 .29983 Mdot
.87204 .30592 Mdot
.87219 .3123 Mdot
.87234 .31798 Mdot
.87249 .31952 Mdot
.87264 .313 Mdot
.8728 .3034 Mdot
.87295 .30133 Mdot
.8731 .30329 Mdot
.87325 .3043 Mdot
.8734 .30515 Mdot
.87355 .30637 Mdot
.8737 .30739 Mdot
.87385 .31182 Mdot
.874 .31566 Mdot
.87415 .31278 Mdot
.8743 .30613 Mdot
.87445 .30084 Mdot
.8746 .29887 Mdot
.87475 .29982 Mdot
.8749 .30072 Mdot
.87505 .30342 Mdot
.8752 .30925 Mdot
.87535 .31548 Mdot
.8755 .31863 Mdot
.87565 .3219 Mdot
.87581 .32328 Mdot
.87596 .32064 Mdot
.87611 .31824 Mdot
.87626 .31579 Mdot
.87641 .31076 Mdot
.87656 .30578 Mdot
.87671 .30349 Mdot
.87686 .30315 Mdot
.87701 .30313 Mdot
.87716 .30507 Mdot
.87731 .30623 Mdot
.87746 .30603 Mdot
.87761 .3037 Mdot
.87776 .30425 Mdot
.87791 .30641 Mdot
.87806 .30909 Mdot
.87821 .31093 Mdot
.87836 .31334 Mdot
.87851 .31695 Mdot
.87866 .32154 Mdot
.87882 .3234 Mdot
.87897 .32127 Mdot
.87912 .3148 Mdot
.87927 .30739 Mdot
.87942 .30152 Mdot
.87957 .29878 Mdot
.87972 .2968 Mdot
.87987 .29813 Mdot
.88002 .30288 Mdot
.88017 .3067 Mdot
.88032 .30887 Mdot
.88047 .31074 Mdot
.88062 .3094 Mdot
.88077 .30353 Mdot
.88092 .29914 Mdot
.88107 .29803 Mdot
.88122 .30063 Mdot
.88137 .30577 Mdot
.88152 .31173 Mdot
.88167 .316 Mdot
.88183 .31948 Mdot
.88198 .32018 Mdot
.88213 .31823 Mdot
.88228 .31208 Mdot
.88243 .30524 Mdot
.88258 .30306 Mdot
.88273 .30609 Mdot
.88288 .3075 Mdot
.88303 .3076 Mdot
.88318 .3093 Mdot
.88333 .31148 Mdot
.88348 .31155 Mdot
.88363 .30973 Mdot
.88378 .30488 Mdot
.88393 .3002 Mdot
.88408 .3005 Mdot
.88423 .30641 Mdot
.88438 .31307 Mdot
.88453 .31793 Mdot
.88468 .32133 Mdot
.88484 .32309 Mdot
.88499 .32118 Mdot
.88514 .31603 Mdot
.88529 .31019 Mdot
.88544 .30581 Mdot
.88559 .30204 Mdot
.88574 .30123 Mdot
.88589 .30234 Mdot
.88604 .30387 Mdot
.88619 .30505 Mdot
.88634 .30547 Mdot
.88649 .3043 Mdot
.88664 .30339 Mdot
.88679 .30348 Mdot
.88694 .30388 Mdot
.88709 .30632 Mdot
.88724 .30972 Mdot
.88739 .31362 Mdot
.88754 .31818 Mdot
.88769 .31982 Mdot
.88785 .31813 Mdot
.888 .31684 Mdot
.88815 .31492 Mdot
.8883 .31108 Mdot
.88845 .30739 Mdot
.8886 .30584 Mdot
.88875 .30408 Mdot
.8889 .30514 Mdot
.88905 .306 Mdot
.8892 .30378 Mdot
.88935 .29961 Mdot
.8895 .29797 Mdot
.88965 .29845 Mdot
.8898 .30111 Mdot
.88995 .30522 Mdot
.8901 .30991 Mdot
.89025 .31376 Mdot
.8904 .31606 Mdot
.89055 .3162 Mdot
.8907 .31629 Mdot
.89086 .31535 Mdot
.89101 .31477 Mdot
.89116 .31418 Mdot
.89131 .31388 Mdot
.89146 .3139 Mdot
.89161 .31303 Mdot
.89176 .31079 Mdot
.89191 .30878 Mdot
.89206 .30712 Mdot
.89221 .30515 Mdot
.89236 .30248 Mdot
.89251 .30001 Mdot
.89266 .29895 Mdot
.89281 .30198 Mdot
.89296 .30612 Mdot
.89311 .30911 Mdot
.89326 .31031 Mdot
.89341 .31069 Mdot
.89356 .31178 Mdot
.89372 .31307 Mdot
.89387 .31275 Mdot
.89402 .31115 Mdot
.89417 .31179 Mdot
.89432 .31396 Mdot
.89447 .31483 Mdot
.89462 .31369 Mdot
.89477 .30985 Mdot
.89492 .306 Mdot
.89507 .30392 Mdot
.89522 .3023 Mdot
.89537 .30074 Mdot
.89552 .30129 Mdot
.89567 .30396 Mdot
.89582 .30642 Mdot
.89597 .30905 Mdot
.89612 .30989 Mdot
.89627 .31029 Mdot
.89642 .31141 Mdot
.89657 .31215 Mdot
.89673 .31225 Mdot
.89688 .31341 Mdot
.89703 .31521 Mdot
.89718 .31661 Mdot
.89733 .31768 Mdot
.89748 .31639 Mdot
.89763 .31234 Mdot
.89778 .30866 Mdot
.89793 .30479 Mdot
.89808 .30118 Mdot
.89823 .30054 Mdot
.89838 .30257 Mdot
.89853 .30496 Mdot
.89868 .30669 Mdot
.89883 .30698 Mdot
.89898 .30662 Mdot
.89913 .30743 Mdot
.89928 .30806 Mdot
.89943 .30825 Mdot
.89958 .30909 Mdot
.89974 .31038 Mdot
.89989 .31202 Mdot
.90004 .31453 Mdot
.90019 .31687 Mdot
.90034 .31759 Mdot
.90049 .31678 Mdot
.90064 .31418 Mdot
.90079 .3097 Mdot
.90094 .306 Mdot
.90109 .30447 Mdot
.90124 .3045 Mdot
.90139 .30527 Mdot
.90154 .30619 Mdot
.90169 .30707 Mdot
.90184 .30771 Mdot
.90199 .3073 Mdot
.90214 .30576 Mdot
.90229 .30454 Mdot
.90244 .30526 Mdot
.90259 .30795 Mdot
.90275 .31027 Mdot
.9029 .31102 Mdot
.90305 .31195 Mdot
.9032 .3131 Mdot
.90335 .31322 Mdot
.9035 .31174 Mdot
.90365 .30933 Mdot
.9038 .30787 Mdot
.90395 .30851 Mdot
.9041 .30976 Mdot
.90425 .31058 Mdot
.9044 .31073 Mdot
.90455 .31044 Mdot
.9047 .31019 Mdot
.90485 .30956 Mdot
.905 .30801 Mdot
.90515 .30657 Mdot
.9053 .30657 Mdot
.90545 .30724 Mdot
.9056 .30821 Mdot
.90576 .30961 Mdot
.90591 .31106 Mdot
.90606 .31229 Mdot
.90621 .31259 Mdot
.90636 .31139 Mdot
.90651 .30985 Mdot
.90666 .30924 Mdot
.90681 .30909 Mdot
.90696 .30892 Mdot
.90711 .30888 Mdot
.90726 .30838 Mdot
.90741 .30823 Mdot
.90756 .3081 Mdot
.90771 .30753 Mdot
.90786 .30681 Mdot
.90801 .30648 Mdot
.90816 .30628 Mdot
.90831 .30656 Mdot
.90846 .30735 Mdot
.90861 .30814 Mdot
.90877 .30928 Mdot
.90892 .31112 Mdot
.90907 .31205 Mdot
.90922 .31214 Mdot
.90937 .3119 Mdot
.90952 .31207 Mdot
.90967 .31239 Mdot
.90982 .31219 Mdot
.90997 .31096 Mdot
.91012 .30913 Mdot
.91027 .3077 Mdot
.91042 .30663 Mdot
.91057 .30619 Mdot
.91072 .30605 Mdot
.91087 .30602 Mdot
.91102 .30665 Mdot
.91117 .30719 Mdot
.91132 .30742 Mdot
.91147 .30773 Mdot
.91162 .30819 Mdot
.91178 .30837 Mdot
.91193 .30854 Mdot
.91208 .30913 Mdot
.91223 .31024 Mdot
.91238 .31208 Mdot
.91253 .31379 Mdot
.91268 .31394 Mdot
.91283 .31277 Mdot
.91298 .31156 Mdot
.91313 .3109 Mdot
.91328 .31006 Mdot
.91343 .30912 Mdot
.91358 .30829 Mdot
.91373 .30822 Mdot
.91388 .30852 Mdot
.91403 .30857 Mdot
.91418 .30855 Mdot
.91433 .30821 Mdot
.91448 .3078 Mdot
.91463 .30735 Mdot
.91479 .30704 Mdot
.91494 .30688 Mdot
.91509 .30766 Mdot
.91524 .30905 Mdot
.91539 .31035 Mdot
.91554 .31074 Mdot
.91569 .3105 Mdot
.91584 .31028 Mdot
.91599 .31006 Mdot
.91614 .30954 Mdot
.91629 .30906 Mdot
.91644 .30873 Mdot
.91659 .30829 Mdot
.91674 .30807 Mdot
.91689 .30826 Mdot
.91704 .30842 Mdot
.91719 .30855 Mdot
.91734 .30872 Mdot
.91749 .30857 Mdot
.91764 .30817 Mdot
.9178 .30811 Mdot
.91795 .30864 Mdot
.9181 .30921 Mdot
.91825 .3098 Mdot
.9184 .31041 Mdot
.91855 .31073 Mdot
.9187 .31065 Mdot
.91885 .31002 Mdot
.919 .30932 Mdot
.91915 .30854 Mdot
.9193 .3082 Mdot
.91945 .30835 Mdot
.9196 .30852 Mdot
.91975 .30834 Mdot
.9199 .30859 Mdot
.92005 .3091 Mdot
.9202 .30938 Mdot
.92035 .30931 Mdot
.9205 .30922 Mdot
.92065 .30893 Mdot
.92081 .30887 Mdot
.92096 .3088 Mdot
.92111 .30881 Mdot
.92126 .30878 Mdot
.92141 .30894 Mdot
.92156 .30926 Mdot
.92171 .3097 Mdot
.92186 .30963 Mdot
.92201 .30922 Mdot
.92216 .30893 Mdot
.92231 .30869 Mdot
.92246 .30833 Mdot
.92261 .30832 Mdot
.92276 .30859 Mdot
.92291 .30879 Mdot
.92306 .30897 Mdot
.92321 .30907 Mdot
.92336 .30885 Mdot
.92351 .30879 Mdot
.92367 .30895 Mdot
.92382 .30895 Mdot
.92397 .30883 Mdot
.92412 .30873 Mdot
.92427 .30883 Mdot
.92442 .30931 Mdot
.92457 .30972 Mdot
.92472 .31007 Mdot
.92487 .31024 Mdot
.92502 .30997 Mdot
.92517 .3092 Mdot
.92532 .30864 Mdot
.92547 .30812 Mdot
.92562 .30779 Mdot
.92577 .30768 Mdot
.92592 .30761 Mdot
.92607 .30748 Mdot
.92622 .30765 Mdot
.92637 .30826 Mdot
.92652 .30887 Mdot
.92668 .30928 Mdot
.92683 .30942 Mdot
.92698 .30961 Mdot
.92713 .30974 Mdot
.92728 .30969 Mdot
.92743 .30957 Mdot
.92758 .30951 Mdot
.92773 .30954 Mdot
.92788 .30978 Mdot
.92803 .3099 Mdot
.92818 .30976 Mdot
.92833 .30948 Mdot
.92848 .30922 Mdot
.92863 .30895 Mdot
.92878 .30864 Mdot
.92893 .30837 Mdot
.92908 .30828 Mdot
.92923 .30842 Mdot
.92938 .3086 Mdot
.92953 .30868 Mdot
.92969 .30888 Mdot
.92984 .30904 Mdot
.92999 .30909 Mdot
.93014 .3091 Mdot
.93029 .30902 Mdot
.93044 .30882 Mdot
.93059 .30898 Mdot
.93074 .30909 Mdot
.93089 .30925 Mdot
.93104 .30965 Mdot
.93119 .31009 Mdot
.93134 .31002 Mdot
.93149 .30963 Mdot
.93164 .30903 Mdot
.93179 .30842 Mdot
.93194 .30808 Mdot
.93209 .30809 Mdot
.93224 .30817 Mdot
.93239 .30846 Mdot
.93254 .30872 Mdot
.9327 .30895 Mdot
.93285 .3092 Mdot
.933 .30936 Mdot
.93315 .30949 Mdot
.9333 .30966 Mdot
.93345 .3097 Mdot
.9336 .30955 Mdot
.93375 .30939 Mdot
.9339 .30923 Mdot
.93405 .30914 Mdot
.9342 .30917 Mdot
.93435 .30907 Mdot
.9345 .30874 Mdot
.93465 .3084 Mdot
.9348 .30813 Mdot
.93495 .30813 Mdot
.9351 .30838 Mdot
.93525 .30864 Mdot
.9354 .30881 Mdot
.93555 .30902 Mdot
.93571 .30915 Mdot
.93586 .30934 Mdot
.93601 .30951 Mdot
.93616 .30965 Mdot
.93631 .30974 Mdot
.93646 .30978 Mdot
.93661 .30962 Mdot
.93676 .30941 Mdot
.93691 .30925 Mdot
.93706 .30907 Mdot
.93721 .30892 Mdot
.93736 .30874 Mdot
.93751 .30862 Mdot
.93766 .30865 Mdot
.93781 .30865 Mdot
.93796 .30849 Mdot
.93811 .30838 Mdot
.93826 .30845 Mdot
.93841 .30857 Mdot
.93856 .30881 Mdot
.93872 .30902 Mdot
.93887 .30905 Mdot
.93902 .30908 Mdot
.93917 .30914 Mdot
.93932 .30922 Mdot
.93947 .3095 Mdot
.93962 .30975 Mdot
.93977 .30986 Mdot
.93992 .30991 Mdot
.94007 .30989 Mdot
.94022 .30971 Mdot
.94037 .30955 Mdot
.94052 .30938 Mdot
.94067 .30914 Mdot
.94082 .30894 Mdot
.94097 .30869 Mdot
.94112 .3084 Mdot
.94127 .30828 Mdot
.94142 .30831 Mdot
.94157 .30847 Mdot
.94173 .30864 Mdot
.94188 .30869 Mdot
.94203 .30867 Mdot
.94218 .30872 Mdot
.94233 .30875 Mdot
.94248 .30887 Mdot
.94263 .30902 Mdot
.94278 .30922 Mdot
.94293 .30948 Mdot
.94308 .30971 Mdot
.94323 .30978 Mdot
.94338 .30976 Mdot
.94353 .30968 Mdot
.94368 .30952 Mdot
.94383 .30933 Mdot
.94398 .30914 Mdot
.94413 .30898 Mdot
.94428 .30889 Mdot
.94443 .30881 Mdot
.94458 .30879 Mdot
.94474 .30884 Mdot
.94489 .30887 Mdot
.94504 .30878 Mdot
.94519 .30869 Mdot
.94534 .30859 Mdot
.94549 .30853 Mdot
.94564 .30855 Mdot
.94579 .30865 Mdot
.94594 .30878 Mdot
.94609 .30893 Mdot
.94624 .30906 Mdot
.94639 .30919 Mdot
.94654 .30923 Mdot
.94669 .30917 Mdot
.94684 .30909 Mdot
.94699 .30904 Mdot
.94714 .30898 Mdot
.94729 .30888 Mdot
.94744 .30879 Mdot
.94759 .30871 Mdot
.94775 .3087 Mdot
.9479 .30876 Mdot
.94805 .30888 Mdot
.9482 .30901 Mdot
.94835 .30906 Mdot
.9485 .30909 Mdot
.94865 .30908 Mdot
.9488 .30907 Mdot
.94895 .30913 Mdot
.9491 .30923 Mdot
.94925 .30931 Mdot
.9494 .30934 Mdot
.94955 .30935 Mdot
.9497 .30929 Mdot
.94985 .30921 Mdot
.95 .30912 Mdot
.95015 .30902 Mdot
.9503 .3089 Mdot
.95045 .30874 Mdot
.95061 .3086 Mdot
.95076 .30852 Mdot
.95091 .30852 Mdot
.95106 .30862 Mdot
.95121 .30871 Mdot
.95136 .30879 Mdot
.95151 .30885 Mdot
.95166 .30889 Mdot
.95181 .30893 Mdot
.95196 .30901 Mdot
.95211 .30908 Mdot
.95226 .30915 Mdot
.95241 .30919 Mdot
.95256 .30922 Mdot
.95271 .30924 Mdot
.95286 .30921 Mdot
.95301 .30916 Mdot
.95316 .30914 Mdot
.95331 .3091 Mdot
.95346 .30903 Mdot
.95362 .30897 Mdot
.95377 .30893 Mdot
.95392 .30885 Mdot
.95407 .30879 Mdot
.95422 .30882 Mdot
.95437 .3088 Mdot
.95452 .30884 Mdot
.95467 .30888 Mdot
.95482 .30892 Mdot
.95497 .30896 Mdot
.95512 .309 Mdot
.95527 .30905 Mdot
.95542 .3091 Mdot
.95557 .30916 Mdot
.95572 .30915 Mdot
.95587 .30914 Mdot
.95602 .30912 Mdot
.95617 .30907 Mdot
.95632 .30908 Mdot
.95647 .30907 Mdot
.95663 .30905 Mdot
.95678 .30902 Mdot
.95693 .30898 Mdot
.95708 .30892 Mdot
.95723 .30892 Mdot
.95738 .30893 Mdot
.95753 .30893 Mdot
.95768 .30896 Mdot
.95783 .309 Mdot
.95798 .30901 Mdot
.95813 .30902 Mdot
.95828 .30902 Mdot
.95843 .30904 Mdot
.95858 .30905 Mdot
.95873 .30906 Mdot
.95888 .30905 Mdot
.95903 .30904 Mdot
.95918 .30902 Mdot
.95933 .309 Mdot
.95948 .30902 Mdot
.95964 .30902 Mdot
.95979 .30902 Mdot
.95994 .30902 Mdot
.96009 .30902 Mdot
.96024 .30902 Mdot
.96039 .30902 Mdot
.96054 .30902 Mdot
.96069 .30905 Mdot
.96084 .30905 Mdot
.96099 .30902 Mdot
.96114 .30901 Mdot
.96129 .30901 Mdot
.96144 .30901 Mdot
.96159 .30902 Mdot
.96174 .30903 Mdot
.96189 .30903 Mdot
.96204 .30903 Mdot
.96219 .30903 Mdot
.96234 .30902 Mdot
.96249 .30902 Mdot
.96265 .30902 Mdot
.9628 .30902 Mdot
.96295 .30901 Mdot
.9631 .30899 Mdot
.96325 .30897 Mdot
.9634 .30896 Mdot
.96355 .30894 Mdot
.9637 .30896 Mdot
.96385 .30898 Mdot
.964 .309 Mdot
.96415 .30901 Mdot
.9643 .30902 Mdot
.96445 .30902 Mdot
.9646 .30902 Mdot
.96475 .30902 Mdot
.9649 .30902 Mdot
.96505 .30903 Mdot
.9652 .30903 Mdot
.96535 .30902 Mdot
.9655 .30902 Mdot
.96566 .30902 Mdot
.96581 .30903 Mdot
.96596 .30903 Mdot
.96611 .30903 Mdot
.96626 .30903 Mdot
.96641 .30902 Mdot
.96656 .30902 Mdot
.96671 .30902 Mdot
.96686 .30902 Mdot
.96701 .30902 Mdot
.96716 .30902 Mdot
.96731 .30902 Mdot
.96746 .30902 Mdot
.96761 .30902 Mdot
.96776 .30902 Mdot
.96791 .30902 Mdot
.96806 .30902 Mdot
.96821 .30902 Mdot
.96836 .30902 Mdot
.96851 .30902 Mdot
.96867 .30902 Mdot
.96882 .30902 Mdot
.96897 .30902 Mdot
.96912 .30902 Mdot
.96927 .30902 Mdot
.96942 .30902 Mdot
.96957 .30902 Mdot
.96972 .30902 Mdot
.96987 .30902 Mdot
.97002 .30902 Mdot
.97017 .30902 Mdot
.97032 .30902 Mdot
.97047 .30902 Mdot
.97062 .30902 Mdot
.97077 .30902 Mdot
.97092 .30902 Mdot
.97107 .30902 Mdot
.97122 .30902 Mdot
.97137 .30902 Mdot
.97152 .30902 Mdot
.97168 .30902 Mdot
.97183 .30902 Mdot
.97198 .30902 Mdot
.97213 .30902 Mdot
.97228 .30902 Mdot
.97243 .30902 Mdot
.97258 .30902 Mdot
.97273 .30902 Mdot
.97288 .30902 Mdot
.97303 .30902 Mdot
.97318 .30902 Mdot
.97333 .30902 Mdot
.97348 .30902 Mdot
.97363 .30902 Mdot
.97378 .30902 Mdot
.97393 .30902 Mdot
.97408 .30902 Mdot
.97423 .30902 Mdot
.97438 .30902 Mdot
.97453 .30902 Mdot
.97469 .30902 Mdot
.97484 .30902 Mdot
.97499 .30902 Mdot
.97514 .30902 Mdot
.97529 .30902 Mdot
.97544 .30902 Mdot
.97559 .30902 Mdot
.97574 .30902 Mdot
.97589 .30902 Mdot
.97604 .30902 Mdot
.97619 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Setting Options DisplayFunction, SampleRate, SampleDepth, and PlayRange\
\>", "Subsubsection",
 CellTags->{"S5.51.1", "1.54"}],

Cell[TextData[{
 "All the sound\[Hyphen]generating functions in the ",
 StyleBox["Miscellaneous`Audio`", "MR"],
 " package use the ",
 StyleBox["Mathematica", "TI"],
 " ",
 StyleBox["Play", "MR"],
 " function to do the low\[Hyphen]level work of generating sounds. Some \
options of ",
 StyleBox["Play", "MR"],
 ", such as ",
 StyleBox["SampleRate", "MR"],
 ", ",
 StyleBox["SampleDepth", "MR"],
 ", and ",
 StyleBox["PlayRange", "MR"],
 ", can significantly change the quality and constitution of the resulting \
sound. The option ",
 StyleBox["DisplayFunction", "MR"],
 " affects whether the created ",
 StyleBox["Sound", "MR"],
 " object will be played immediately after it is returned. "
}], "Text",
 CellTags->{"S5.51.1", "1.55"}],

Cell[TextData[{
 "Loading the package will set the options ",
 StyleBox["SampleRate", "MR"],
 ", ",
 StyleBox["SampleDepth", "MR"],
 ", and ",
 StyleBox["PlayRange", "MR"],
 " to their optimum values for your machine. The package also sets ",
 StyleBox["DisplayFunction->Identity", "MR"],
 ", which causes ",
 StyleBox["Sound", "MR"],
 " objects to be returned without being played. You can reset these options \
by using ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s ",
 StyleBox["SetOptions", "MR"],
 " function, or by specifying them on the command line. "
}], "Text",
 CellTags->{"S5.51.1", "1.56"}],

Cell[TextData[{
 "You can create a sound at a specified ",
 StyleBox["SampleRate", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.57"}],

Cell[CellGroupData[{

Cell["\<\
AmplitudeModulation[440, 100, 1, 0.5,
        SampleRate->22050]\
\>", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "By setting the option ",
 StyleBox["DisplayFunction->$SoundDisplayFunction", "MR"],
 ", you can hear a sound immediately after it is created by ",
 StyleBox["Mathematica", "TI"],
 ", without having to use the ",
 StyleBox["Show", "MR"],
 " function each time. This is most useful when you are experimenting with \
combinations of arguments and wish to hear the effect they have on the \
resulting sound. "
}], "Text",
 CellTags->{"S5.51.1", "1.58"}],

Cell[TextData[{
 "Now all ",
 StyleBox["Sound", "MR"],
 " objects returned by ",
 StyleBox["FrequencyModulation", "MR"],
 " will be played immediately after being returned. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.59"}],

Cell[CellGroupData[{

Cell["\<\
SetOptions[FrequencyModulation, DisplayFunction->$SoundDisplayFunction]\
\>", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.51.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DisplayFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Display", "[", 
       RowBox[{"$SoundDisplay", ",", "#1"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"ModulationType", "\[Rule]", "Standard"}], ",", 
   RowBox[{"PlayRange", "\[Rule]", "All"}], ",", 
   RowBox[{"SampleDepth", "\[Rule]", "8"}], ",", 
   RowBox[{"SampleRate", "\[Rule]", "8192"}]}], "}"}]], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "This assigns a frequency modulated sound to ",
 StyleBox["casfm2", "MR"],
 " and plays the sound. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.60"}],

Cell[CellGroupData[{

Cell["\<\
casfm2 = FrequencyModulation[660,{{770, 100},
        {660, 50}, {540, 25}}, 0.5, ModulationType->Cascade]\
\>", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell["\<\
You can hear the same function with slightly different values of the \
modulating frequencies. \
\>", "MathCaption",
 CellTags->{"S5.51.1", "1.61"}],

Cell[CellGroupData[{

Cell["\<\
FrequencyModulation[660,{{660, 100},
        {540, 50}, {660, 25}}, 0.5, ModulationType->Cascade]\
\>", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[29]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "Now ",
 StyleBox["FrequencyModulation", "MR"],
 " will no longer play every ",
 StyleBox["Sound", "MR"],
 " object it creates. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.62"}],

Cell[CellGroupData[{

Cell["SetOptions[FrequencyModulation, DisplayFunction->Identity]", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.51.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
   RowBox[{"ModulationType", "\[Rule]", "Standard"}], ",", 
   RowBox[{"PlayRange", "\[Rule]", "All"}], ",", 
   RowBox[{"SampleDepth", "\[Rule]", "8"}], ",", 
   RowBox[{"SampleRate", "\[Rule]", "8192"}]}], "}"}]], "Output",
 CellLabel->"Out[30]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "You will be better able to use the sound\[Hyphen]generating functions if \
you are aware of the effect of the various options to ",
 StyleBox["Play", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.51.1", "1.63"}],

Cell[TextData[{
 StyleBox["SampleRate", "MR"],
 " is an option for sound primitives that specifies the number of samples per \
second to generate for sounds. According to Nyquist\[CloseCurlyQuote]s \
sampling theorem, ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " samples per second are required to accurately represent a waveform having \
a maximum frequency content of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "/", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " hertz. In other words, your sampling rate must be at least twice the \
highest frequency you would like to hear. Sampling at a lower rate will \
result in aliasing, in which frequency components above half the sampling \
rate are rendered as lower frequency components. Since people register \
frequencies in the range of 20\[Dash]20,000 hertz as audio signals, a \
sampling rate of 40,000 samples per second is the minimum required for the \
accurate encoding of the entire audio range. "
}], "Text",
 CellTags->{"S5.51.1", "1.64"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " allows you to set the ",
 StyleBox["SampleRate", "MR"],
 " to any positive number. However, the sound that will be created depends \
upon the sampling rate of your digital\[Hyphen]to\[Hyphen]analog converter. \
If the converter\[CloseCurlyQuote]s sampling rate is not a multiple of the \
chosen sampling rate, a software conversion to the \
converter\[CloseCurlyQuote]s sampling rate will automatically take place, and \
there may be distortions in the resulting sound. "
}], "Text",
 CellTags->{"S5.51.1", "1.65"}],

Cell[TextData[{
 "This is a frequency modulated sound at the default ",
 StyleBox["SampleRate", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.66"}],

Cell[CellGroupData[{

Cell["\<\
FrequencyModulation[660, {100,100},
        0.5] // Show\
\>", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[31]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "This plays the same sound with ",
 StyleBox["SampleRate->1234", "MR"],
 ". The additional noise is due to the fact that the digital\[Hyphen]to\
\[Hyphen]analog converter\[CloseCurlyQuote]s sampling rate is not a multiple \
of 1234 hertz. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.67"}],

Cell[CellGroupData[{

Cell["\<\
FrequencyModulation[660, {100,100}, 0.5,
        SampleRate->1234] // Show\
\>", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[32]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["SampleDepth", "MR"],
 " (frequently called quantization) is an option for sound primitives which \
specifies how many bits should be used to encode sound amplitude levels. \
Setting ",
 StyleBox["SampleDepth->8", "MR"],
 " gives you ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", "8"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " different amplitude values, and ",
 StyleBox["SampleDepth->16", "MR"],
 " gives you ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", "16"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". You should choose a value for ",
 StyleBox["SampleDepth", "MR"],
 " that is the best for your hardware. "
}], "Text",
 CellTags->{"S5.51.1", "1.68"}],

Cell[TextData[{
 "Here is the pitch A5 using the default setting of ",
 StyleBox["SampleDepth", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.69"}],

Cell[CellGroupData[{

Cell["Waveform[Sawtooth, 880, 0.5] // Show", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "On some computers, this ",
 StyleBox["SampleDepth", "MR"],
 " produces no sound at all. You might get a sound that is simply noisier. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.70"}],

Cell[CellGroupData[{

Cell["\<\
Waveform[Sawtooth, 880, 0.5,
  SampleDepth->3] // Show\
\>", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[34]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PlayRange", "MR"],
 " is an option for ",
 StyleBox["Play", "MR"],
 " and related functions which specifies what range of sound amplitude levels \
should be included. The functions ",
 StyleBox["Waveform", "MR"],
 " and ",
 StyleBox["FrequencyModulation", "MR"],
 " set this value to ",
 StyleBox["All", "MR"],
 ", and the ",
 StyleBox["AmplitudeModulation", "MR"],
 " function sets it to ",
 StyleBox["{-1,1}", "MR"],
 ". ",
 StyleBox["PlayRange", "MR"],
 " in ",
 StyleBox["Play", "MR"],
 " behaves like ",
 StyleBox["PlotRange", "MR"],
 " in ",
 StyleBox["Plot", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.51.1", "1.71"}],

Cell["Here is a simple plot of a sine waveform. ", "MathCaption",
 CellTags->{"S5.51.1", "1.72"}],

Cell[CellGroupData[{

Cell["Plot[Sin[x], {x, 0, 2Pi}]", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.51.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.51.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the same plot with a restricted ",
 StyleBox["PlotRange", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.73"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Sin[x], {x, 0, 2Pi},
        PlotRange->{-0.5, 0.5}]\
\>", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S5.51.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309017 0.618034 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .0618 -24 -4.5 ]
[.01131 .0618 0 4.5 ]
[.01131 .18541 -24 -4.5 ]
[.01131 .18541 0 4.5 ]
[.01131 .43262 -18 -4.5 ]
[.01131 .43262 0 4.5 ]
[.01131 .55623 -18 -4.5 ]
[.01131 .55623 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .0618 m
.03006 .0618 L
s
[(-0.4)] .01131 .0618 1 0 Mshowa
.02381 .18541 m
.03006 .18541 L
s
[(-0.2)] .01131 .18541 1 0 Mshowa
.02381 .43262 m
.03006 .43262 L
s
[(0.2)] .01131 .43262 1 0 Mshowa
.02381 .55623 m
.03006 .55623 L
s
[(0.4)] .01131 .55623 1 0 Mshowa
.125 Mabswid
.02381 .09271 m
.02756 .09271 L
s
.02381 .12361 m
.02756 .12361 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .24721 m
.02756 .24721 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .49443 m
.02756 .49443 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .0309 m
.02756 .0309 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .46485 L
s
.06244 .46485 m
.10326 .61803 L
s
.42051 .61803 m
.45912 .47371 L
.49816 .31652 L
.53966 .14915 L
s
.53966 .14915 m
.57938 0 L
s
.8968 0 m
.93577 .14616 L
.97371 .2989 L
.97619 .30902 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.51.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[36]= ",
 CellTags->"S5.51.1"]
}, Open  ]],

Cell[TextData[{
 "Notice that in the second plot, when the value of the function exceeds the \
limits specified by ",
 StyleBox["PlotRange", "MR"],
 ", the value is cut off or clipped. Similarly, if the amplitude of your \
sound exceeds the setting of ",
 StyleBox["PlayRange", "MR"],
 ", what you hear will not be a complete representation of your function. \
This phenomenon is termed waveshaping by composers and distortion by \
engineers. ",
 StyleBox["PlayRange", "MR"],
 " should be set sufficiently high so that all generated samples may be \
represented without distortion. "
}], "Text",
 CellTags->{"S5.51.1", "1.74"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Playing Sound Objects in Arbitrary Sequences", "Subsubsection",
 CellTags->{"S5.51.1", "1.75"}],

Cell[TextData[{
 "Since all the sound\[Hyphen]generating functions defined in ",
 StyleBox["Miscellaneous`Audio`", "MR"],
 " return a ",
 StyleBox["Sound", "MR"],
 " object, the returned values can be played in sequence with the ",
 StyleBox["Show", "MR"],
 " function. "
}], "Text",
 CellTags->{"S5.51.1", "1.76"}],

Cell["First create three sounds. ", "MathCaption",
 CellTags->{"S5.51.1", "1.77"}],

Cell["\<\
{s1, s2, s3} =
{Waveform[Sawtooth, 880, 0.2],
AmplitudeModulation[440, 530, 1, 0.5],
FrequencyModulation[660,
        {{300,400},{600,200}},
    0.3, ModulationType->Cascade]};\
\>", "Input",
 CellLabel->"In[37]:= ",
 CellTags->"S5.51.1"],

Cell[TextData[{
 "This plays the three ",
 StyleBox["Sound", "MR"],
 " objects in reverse sequence. "
}], "MathCaption",
 CellTags->{"S5.51.1", "1.78"}],

Cell[CellGroupData[{

Cell["Show[s3, s2, s1]", "Input",
 CellLabel->"In[38]:= ",
 CellTags->"S5.51.1"],

Cell["        -Sound-", "Output",
 CellLabel->"Out[38]= ",
 CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.51.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.51.1", "1.1"}],
    Cell[1914, 61, 337, 8, 56, "Text",
      CellTags->{"S5.51.1", "1.2"}],
    Cell[2254, 71, 279, 7, 40, "Text",
      CellTags->{"S5.51.1", "1.3"}],
    Cell[2558, 82, 85, 1, 34, "Subsubsection",
      CellTags->{"S5.51.1", "1.4"}],
    Cell[2646, 85, 2084, 64, 82, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[4733, 151, 71, 1, 15, "Caption",
      CellTags->"S5.51.1"],
    Cell[4807, 154, 274, 7, 40, "Text",
      CellTags->{"S5.51.1", "1.5"}],
    Cell[5084, 163, 863, 24, 66, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[5950, 189, 72, 1, 15, "Caption",
      CellTags->"S5.51.1"],
    Cell[6025, 192, 78, 1, 40, "MathCaption",
      CellTags->{"S5.51.1", "1.6"}],
    Cell[6106, 195, 86, 2, 28, "Input",
      CellTags->"S5.51.1"],
    Cell[6195, 199, 366, 12, 56, "MathCaption",
      CellTags->{"S5.51.1", "1.7"}],
    Cell[6586, 215, 106, 2, 28, "Input",
      CellTags->"S5.51.1"],
    Cell[6695, 219, 79, 2, 26, "Output",
      CellTags->"S5.51.1"],
    Cell[6789, 224, 1792, 56, 64, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[8584, 282, 116, 3, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[8703, 287, 220, 7, 70, "Text",
      CellTags->{"S5.51.1", "1.8"}],
    Cell[8926, 296, 203, 6, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.9"}],
    Cell[9154, 306, 149, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[9306, 313, 79, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[9400, 318, 211, 6, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.10"}],
    Cell[9636, 328, 170, 6, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[9809, 336, 79, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[9903, 341, 524, 13, 70, "Text",
      CellTags->{"S5.51.1", "1.11"}],
    Cell[10430, 356, 178, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.12"}],
    Cell[10633, 365, 104, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[10740, 369, 370, 9, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[11125, 381, 125, 3, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.13"}],
    Cell[11275, 388, 105, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[11383, 392, 368, 9, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[11800, 407, 95, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.14"}],
    Cell[11898, 410, 3888, 119, 70, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[15789, 531, 88, 1, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[15880, 534, 353, 7, 70, "Text",
      CellTags->{"S5.51.1", "1.15"}],
    Cell[16236, 543, 444, 9, 70, "Text",
      CellTags->{"S5.51.1", "1.16"}],
    Cell[16683, 554, 101, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.17"}],
    Cell[16787, 557, 193, 7, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[16983, 566, 232, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.18"}],
    Cell[17218, 573, 143, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[17364, 580, 135, 3, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.19"}],
    Cell[17524, 587, 77, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[17604, 591, 79, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[17698, 596, 256, 6, 70, "Text",
      CellTags->{"S5.51.1", "1.20"}],
    Cell[17957, 604, 229, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.21"}],
    Cell[18189, 611, 107, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[18299, 615, 184, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.22"}],
    Cell[18508, 624, 109, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[18620, 628, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[18749, 636, 77, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.23"}],
    Cell[18829, 639, 265, 5, 70, "Text",
      CellTags->{"S5.51.1", "1.24"}],
    Cell[19097, 646, 3356, 106, 70, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[22456, 754, 63, 1, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[22522, 757, 832, 34, 70, "Text",
      CellTags->{"S5.51.1", "1.25"}],
    Cell[23357, 793, 192, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.26"}],
    Cell[23574, 801, 106, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[23683, 805, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[23778, 810, 578, 16, 70, "Text",
      CellTags->{"S5.51.1", "1.27"}],
    Cell[24359, 828, 2097, 66, 70, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[26459, 896, 58, 1, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[26520, 899, 993, 38, 70, "Text",
      CellTags->{"S5.51.1", "1.28"}],
    Cell[27516, 939, 209, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.29"}],
    Cell[27750, 947, 146, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[27899, 954, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[28028, 962, 77, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.30"}],
    Cell[28108, 965, 1158, 39, 70, "Text",
      CellTags->{"S5.51.1", "1.31"}],
    Cell[29269, 1006, 3345, 106, 70, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[32617, 1114, 63, 1, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[32683, 1117, 168, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.32"}],
    Cell[32876, 1125, 108, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[32987, 1129, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[33082, 1134, 333, 6, 70, "Text",
      CellTags->{"S5.51.1", "1.33"}],
    Cell[33418, 1142, 145, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.34"}],
    Cell[33588, 1150, 124, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[33715, 1157, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[33810, 1162, 703, 11, 70, "Text",
      CellTags->{"S5.51.1", "1.35"}],
    Cell[34516, 1175, 4179, 129, 70, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[38698, 1306, 71, 1, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[38772, 1309, 1902, 68, 70, "Text",
      CellTags->{"S5.51.1", "1.36"}],
    Cell[40677, 1379, 176, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.37"}],
    Cell[40878, 1387, 186, 6, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[41067, 1395, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[41162, 1400, 4181, 129, 70, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[45346, 1531, 72, 1, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[45421, 1534, 1818, 66, 70, "Text",
      CellTags->{"S5.51.1", "1.38"}],
    Cell[47242, 1602, 248, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.39"}],
    Cell[47515, 1611, 187, 6, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[47705, 1619, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[47834, 1627, 86, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.40"}],
    Cell[47923, 1630, 711, 13, 70, "Text",
      CellTags->{"S5.51.1", "1.41"}],
    Cell[48637, 1645, 2299, 67, 70, "DefinitionBox",
      CellTags->"S5.51.1"],
    Cell[50939, 1714, 121, 5, 70, "Caption",
      CellTags->"S5.51.1"],
    Cell[51063, 1721, 499, 14, 70, "Text",
      CellTags->{"S5.51.1", "1.42"}],
    Cell[51565, 1737, 192, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.43"}],
    Cell[51782, 1746, 138, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[51923, 1753, 232, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[52158, 1761, 242, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[52403, 1769, 178, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[52584, 1776, 196, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[52783, 1783, 192, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[52978, 1790, 241, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[53222, 1798, 204, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[53441, 1806, 389, 13, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.44"}],
    Cell[53855, 1823, 140, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[53998, 1830, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[54093, 1835, 249, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.45"}],
    Cell[54367, 1846, 105, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[54475, 1850, 301442, 16157, 70, 301371, 16154, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.51.1"],
    Cell[355920, 18009, 181, 6, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[356116, 18018, 398, 7, 70, "Text",
      CellTags->{"S5.51.1", "1.46"}],
    Cell[356517, 18027, 158, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.47"}],
    Cell[356700, 18036, 139, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[356842, 18043, 198, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[357043, 18050, 250, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[357296, 18058, 178, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[357477, 18065, 194, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[357674, 18072, 192, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[357869, 18079, 241, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[358113, 18087, 204, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[358320, 18094, 208, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[358531, 18101, 213, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[358759, 18110, 126, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.48"}],
    Cell[358910, 18119, 141, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[359054, 18126, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[359149, 18131, 205, 4, 70, "Text",
      CellTags->{"S5.51.1", "1.49"}],
    Cell[359357, 18137, 84, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.50"}],
    Cell[359466, 18142, 137, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[359606, 18149, 198, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[359807, 18156, 269, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[360079, 18164, 178, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[360260, 18171, 196, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[360459, 18178, 194, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[360656, 18185, 241, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[360900, 18193, 202, 5, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[361105, 18200, 230, 6, 70, "Print",
      CellTags->"S5.51.1"],
    Cell[361350, 18209, 84, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.51"}],
    Cell[361459, 18214, 140, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[361602, 18221, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[361697, 18226, 211, 5, 70, "Text",
      CellTags->{"S5.51.1", "1.52"}],
    Cell[361911, 18233, 127, 3, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.53"}],
    Cell[362063, 18240, 124, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[362190, 18247, 122836, 6609, 70, 122765, 6606, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.51.1"],
    Cell[485075, 24862, 136, 3, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.54"}],
    Cell[485214, 24867, 734, 23, 70, "Text",
      CellTags->{"S5.51.1", "1.55"}],
    Cell[485951, 24892, 614, 18, 70, "Text",
      CellTags->{"S5.51.1", "1.56"}],
    Cell[486568, 24912, 146, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.57"}],
    Cell[486739, 24921, 136, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[486878, 24928, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[486973, 24933, 467, 11, 70, "Text",
      CellTags->{"S5.51.1", "1.58"}],
    Cell[487443, 24946, 225, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.59"}],
    Cell[487693, 24957, 143, 4, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[487839, 24963, 491, 13, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[488345, 24979, 168, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.60"}],
    Cell[488538, 24988, 178, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[488719, 24995, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[488814, 25000, 158, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.61"}],
    Cell[488997, 25008, 169, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[489169, 25015, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[489264, 25020, 197, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.62"}],
    Cell[489486, 25031, 122, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[489611, 25035, 373, 9, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[489999, 25047, 224, 6, 70, "Text",
      CellTags->{"S5.51.1", "1.63"}],
    Cell[490226, 25055, 1168, 26, 70, "Text",
      CellTags->{"S5.51.1", "1.64"}],
    Cell[491397, 25083, 566, 11, 70, "Text",
      CellTags->{"S5.51.1", "1.65"}],
    Cell[491966, 25096, 159, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.66"}],
    Cell[492150, 25105, 128, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[492281, 25112, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[492376, 25117, 308, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.67"}],
    Cell[492709, 25128, 146, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[492858, 25135, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[492953, 25140, 781, 22, 70, "Text",
      CellTags->{"S5.51.1", "1.68"}],
    Cell[493737, 25164, 159, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.69"}],
    Cell[493921, 25173, 100, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[494024, 25177, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[494119, 25182, 204, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.70"}],
    Cell[494348, 25191, 126, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[494477, 25198, 80, 2, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[494572, 25203, 649, 25, 70, "Text",
      CellTags->{"S5.51.1", "1.71"}],
    Cell[495224, 25230, 97, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.72"}],
    Cell[495346, 25235, 89, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[495438, 25239, 4659, 323, 70, 4588, 320, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.51.1"],
    Cell[500100, 25564, 181, 6, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[500296, 25573, 150, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.73"}],
    Cell[500471, 25582, 129, 5, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[500603, 25589, 3501, 252, 70, 3430, 249, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.51.1"],
    Cell[504107, 25843, 181, 6, 70, "Output",
      CellTags->"S5.51.1"],
    Cell[504303, 25852, 627, 14, 70, "Text",
      CellTags->{"S5.51.1", "1.74"}],
    Cell[504967, 25871, 101, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.75"}],
    Cell[505071, 25874, 315, 9, 70, "Text",
      CellTags->{"S5.51.1", "1.76"}],
    Cell[505389, 25885, 82, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.77"}],
    Cell[505474, 25888, 248, 9, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[505725, 25899, 152, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.78"}],
    Cell[505902, 25908, 80, 2, 70, "Input",
      CellTags->"S5.51.1"],
    Cell[505985, 25912, 80, 2, 70, "Output",
      CellTags->"S5.51.1"]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.51.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 337, 8, 56, "Text",
      CellTags->{"S5.51.1", "1.2"}]},
  "1.3"->{
    Cell[2254, 71, 279, 7, 40, "Text",
      CellTags->{"S5.51.1", "1.3"}]},
  "1.4"->{
    Cell[2558, 82, 85, 1, 34, "Subsubsection",
      CellTags->{"S5.51.1", "1.4"}]},
  "1.5"->{
    Cell[4807, 154, 274, 7, 40, "Text",
      CellTags->{"S5.51.1", "1.5"}]},
  "1.6"->{
    Cell[6025, 192, 78, 1, 40, "MathCaption",
      CellTags->{"S5.51.1", "1.6"}]},
  "1.7"->{
    Cell[6195, 199, 366, 12, 56, "MathCaption",
      CellTags->{"S5.51.1", "1.7"}]},
  "1.8"->{
    Cell[8703, 287, 220, 7, 70, "Text",
      CellTags->{"S5.51.1", "1.8"}]},
  "1.9"->{
    Cell[8926, 296, 203, 6, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.9"}]},
  "1.10"->{
    Cell[9400, 318, 211, 6, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.10"}]},
  "1.11"->{
    Cell[9903, 341, 524, 13, 70, "Text",
      CellTags->{"S5.51.1", "1.11"}]},
  "1.12"->{
    Cell[10430, 356, 178, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.12"}]},
  "1.13"->{
    Cell[11125, 381, 125, 3, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.13"}]},
  "1.14"->{
    Cell[11800, 407, 95, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.14"}]},
  "1.15"->{
    Cell[15880, 534, 353, 7, 70, "Text",
      CellTags->{"S5.51.1", "1.15"}]},
  "1.16"->{
    Cell[16236, 543, 444, 9, 70, "Text",
      CellTags->{"S5.51.1", "1.16"}]},
  "1.17"->{
    Cell[16683, 554, 101, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.17"}]},
  "1.18"->{
    Cell[16983, 566, 232, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.18"}]},
  "1.19"->{
    Cell[17364, 580, 135, 3, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.19"}]},
  "1.20"->{
    Cell[17698, 596, 256, 6, 70, "Text",
      CellTags->{"S5.51.1", "1.20"}]},
  "1.21"->{
    Cell[17957, 604, 229, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.21"}]},
  "1.22"->{
    Cell[18299, 615, 184, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.22"}]},
  "1.23"->{
    Cell[18749, 636, 77, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.23"}]},
  "1.24"->{
    Cell[18829, 639, 265, 5, 70, "Text",
      CellTags->{"S5.51.1", "1.24"}]},
  "1.25"->{
    Cell[22522, 757, 832, 34, 70, "Text",
      CellTags->{"S5.51.1", "1.25"}]},
  "1.26"->{
    Cell[23357, 793, 192, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.26"}]},
  "1.27"->{
    Cell[23778, 810, 578, 16, 70, "Text",
      CellTags->{"S5.51.1", "1.27"}]},
  "1.28"->{
    Cell[26520, 899, 993, 38, 70, "Text",
      CellTags->{"S5.51.1", "1.28"}]},
  "1.29"->{
    Cell[27516, 939, 209, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.29"}]},
  "1.30"->{
    Cell[28028, 962, 77, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.30"}]},
  "1.31"->{
    Cell[28108, 965, 1158, 39, 70, "Text",
      CellTags->{"S5.51.1", "1.31"}]},
  "1.32"->{
    Cell[32683, 1117, 168, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.32"}]},
  "1.33"->{
    Cell[33082, 1134, 333, 6, 70, "Text",
      CellTags->{"S5.51.1", "1.33"}]},
  "1.34"->{
    Cell[33418, 1142, 145, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.34"}]},
  "1.35"->{
    Cell[33810, 1162, 703, 11, 70, "Text",
      CellTags->{"S5.51.1", "1.35"}]},
  "1.36"->{
    Cell[38772, 1309, 1902, 68, 70, "Text",
      CellTags->{"S5.51.1", "1.36"}]},
  "1.37"->{
    Cell[40677, 1379, 176, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.37"}]},
  "1.38"->{
    Cell[45421, 1534, 1818, 66, 70, "Text",
      CellTags->{"S5.51.1", "1.38"}]},
  "1.39"->{
    Cell[47242, 1602, 248, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.39"}]},
  "1.40"->{
    Cell[47834, 1627, 86, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.40"}]},
  "1.41"->{
    Cell[47923, 1630, 711, 13, 70, "Text",
      CellTags->{"S5.51.1", "1.41"}]},
  "1.42"->{
    Cell[51063, 1721, 499, 14, 70, "Text",
      CellTags->{"S5.51.1", "1.42"}]},
  "1.43"->{
    Cell[51565, 1737, 192, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.43"}]},
  "1.44"->{
    Cell[53441, 1806, 389, 13, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.44"}]},
  "1.45"->{
    Cell[54093, 1835, 249, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.45"}]},
  "1.46"->{
    Cell[356116, 18018, 398, 7, 70, "Text",
      CellTags->{"S5.51.1", "1.46"}]},
  "1.47"->{
    Cell[356517, 18027, 158, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.47"}]},
  "1.48"->{
    Cell[358759, 18110, 126, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.48"}]},
  "1.49"->{
    Cell[359149, 18131, 205, 4, 70, "Text",
      CellTags->{"S5.51.1", "1.49"}]},
  "1.50"->{
    Cell[359357, 18137, 84, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.50"}]},
  "1.51"->{
    Cell[361350, 18209, 84, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.51"}]},
  "1.52"->{
    Cell[361697, 18226, 211, 5, 70, "Text",
      CellTags->{"S5.51.1", "1.52"}]},
  "1.53"->{
    Cell[361911, 18233, 127, 3, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.53"}]},
  "1.54"->{
    Cell[485075, 24862, 136, 3, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.54"}]},
  "1.55"->{
    Cell[485214, 24867, 734, 23, 70, "Text",
      CellTags->{"S5.51.1", "1.55"}]},
  "1.56"->{
    Cell[485951, 24892, 614, 18, 70, "Text",
      CellTags->{"S5.51.1", "1.56"}]},
  "1.57"->{
    Cell[486568, 24912, 146, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.57"}]},
  "1.58"->{
    Cell[486973, 24933, 467, 11, 70, "Text",
      CellTags->{"S5.51.1", "1.58"}]},
  "1.59"->{
    Cell[487443, 24946, 225, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.59"}]},
  "1.60"->{
    Cell[488345, 24979, 168, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.60"}]},
  "1.61"->{
    Cell[488814, 25000, 158, 4, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.61"}]},
  "1.62"->{
    Cell[489264, 25020, 197, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.62"}]},
  "1.63"->{
    Cell[489999, 25047, 224, 6, 70, "Text",
      CellTags->{"S5.51.1", "1.63"}]},
  "1.64"->{
    Cell[490226, 25055, 1168, 26, 70, "Text",
      CellTags->{"S5.51.1", "1.64"}]},
  "1.65"->{
    Cell[491397, 25083, 566, 11, 70, "Text",
      CellTags->{"S5.51.1", "1.65"}]},
  "1.66"->{
    Cell[491966, 25096, 159, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.66"}]},
  "1.67"->{
    Cell[492376, 25117, 308, 7, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.67"}]},
  "1.68"->{
    Cell[492953, 25140, 781, 22, 70, "Text",
      CellTags->{"S5.51.1", "1.68"}]},
  "1.69"->{
    Cell[493737, 25164, 159, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.69"}]},
  "1.70"->{
    Cell[494119, 25182, 204, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.70"}]},
  "1.71"->{
    Cell[494572, 25203, 649, 25, 70, "Text",
      CellTags->{"S5.51.1", "1.71"}]},
  "1.72"->{
    Cell[495224, 25230, 97, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.72"}]},
  "1.73"->{
    Cell[500296, 25573, 150, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.73"}]},
  "1.74"->{
    Cell[504303, 25852, 627, 14, 70, "Text",
      CellTags->{"S5.51.1", "1.74"}]},
  "1.75"->{
    Cell[504967, 25871, 101, 1, 70, "Subsubsection",
      CellTags->{"S5.51.1", "1.75"}]},
  "1.76"->{
    Cell[505071, 25874, 315, 9, 70, "Text",
      CellTags->{"S5.51.1", "1.76"}]},
  "1.77"->{
    Cell[505389, 25885, 82, 1, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.77"}]},
  "1.78"->{
    Cell[505725, 25899, 152, 5, 70, "MathCaption",
      CellTags->{"S5.51.1", "1.78"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.51.1", 506728, 25935},
  {"1.1", 522025, 26330},
  {"1.2", 522119, 26333},
  {"1.3", 522207, 26336},
  {"1.4", 522295, 26339},
  {"1.5", 522391, 26342},
  {"1.6", 522480, 26345},
  {"1.7", 522575, 26348},
  {"1.8", 522672, 26351},
  {"1.9", 522761, 26354},
  {"1.10", 522858, 26357},
  {"1.11", 522956, 26360},
  {"1.12", 523048, 26363},
  {"1.13", 523147, 26366},
  {"1.14", 523246, 26369},
  {"1.15", 523346, 26372},
  {"1.16", 523438, 26375},
  {"1.17", 523530, 26378},
  {"1.18", 523629, 26381},
  {"1.19", 523728, 26384},
  {"1.20", 523827, 26387},
  {"1.21", 523919, 26390},
  {"1.22", 524018, 26393},
  {"1.23", 524117, 26396},
  {"1.24", 524217, 26399},
  {"1.25", 524309, 26402},
  {"1.26", 524402, 26405},
  {"1.27", 524501, 26408},
  {"1.28", 524594, 26411},
  {"1.29", 524687, 26414},
  {"1.30", 524786, 26417},
  {"1.31", 524886, 26420},
  {"1.32", 524980, 26423},
  {"1.33", 525080, 26426},
  {"1.34", 525173, 26429},
  {"1.35", 525273, 26432},
  {"1.36", 525367, 26435},
  {"1.37", 525462, 26438},
  {"1.38", 525562, 26441},
  {"1.39", 525657, 26444},
  {"1.40", 525757, 26447},
  {"1.41", 525858, 26450},
  {"1.42", 525952, 26453},
  {"1.43", 526046, 26456},
  {"1.44", 526146, 26459},
  {"1.45", 526247, 26462},
  {"1.46", 526347, 26465},
  {"1.47", 526442, 26468},
  {"1.48", 526544, 26471},
  {"1.49", 526646, 26474},
  {"1.50", 526741, 26477},
  {"1.51", 526842, 26480},
  {"1.52", 526943, 26483},
  {"1.53", 527038, 26486},
  {"1.54", 527140, 26489},
  {"1.55", 527244, 26492},
  {"1.56", 527340, 26495},
  {"1.57", 527436, 26498},
  {"1.58", 527538, 26501},
  {"1.59", 527634, 26504},
  {"1.60", 527736, 26507},
  {"1.61", 527838, 26510},
  {"1.62", 527940, 26513},
  {"1.63", 528042, 26516},
  {"1.64", 528137, 26519},
  {"1.65", 528234, 26522},
  {"1.66", 528330, 26525},
  {"1.67", 528432, 26528},
  {"1.68", 528534, 26531},
  {"1.69", 528630, 26534},
  {"1.70", 528732, 26537},
  {"1.71", 528834, 26540},
  {"1.72", 528930, 26543},
  {"1.73", 529031, 26546},
  {"1.74", 529133, 26549},
  {"1.75", 529229, 26552},
  {"1.76", 529333, 26555},
  {"1.77", 529428, 26558},
  {"1.78", 529529, 26561}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 36, "Subsection",
  CellTags->{"S5.51.1", "1.1"}],
Cell[1914, 61, 337, 8, 56, "Text",
  CellTags->{"S5.51.1", "1.2"}],
Cell[2254, 71, 279, 7, 40, "Text",
  CellTags->{"S5.51.1", "1.3"}],

Cell[CellGroupData[{
Cell[2558, 82, 85, 1, 34, "Subsubsection",
  CellTags->{"S5.51.1", "1.4"}],
Cell[2646, 85, 2084, 64, 82, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[4733, 151, 71, 1, 15, "Caption",
  CellTags->"S5.51.1"],
Cell[4807, 154, 274, 7, 40, "Text",
  CellTags->{"S5.51.1", "1.5"}],
Cell[5084, 163, 863, 24, 66, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[5950, 189, 72, 1, 15, "Caption",
  CellTags->"S5.51.1"],
Cell[6025, 192, 78, 1, 40, "MathCaption",
  CellTags->{"S5.51.1", "1.6"}],
Cell[6106, 195, 86, 2, 28, "Input",
  CellTags->"S5.51.1"],
Cell[6195, 199, 366, 12, 56, "MathCaption",
  CellTags->{"S5.51.1", "1.7"}],

Cell[CellGroupData[{
Cell[6586, 215, 106, 2, 28, "Input",
  CellTags->"S5.51.1"],
Cell[6695, 219, 79, 2, 26, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[6789, 224, 1792, 56, 64, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[8584, 282, 116, 3, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[8703, 287, 220, 7, 70, "Text",
  CellTags->{"S5.51.1", "1.8"}],
Cell[8926, 296, 203, 6, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.9"}],

Cell[CellGroupData[{
Cell[9154, 306, 149, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[9306, 313, 79, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[9400, 318, 211, 6, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.10"}],

Cell[CellGroupData[{
Cell[9636, 328, 170, 6, 70, "Input",
  CellTags->"S5.51.1"],
Cell[9809, 336, 79, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[9903, 341, 524, 13, 70, "Text",
  CellTags->{"S5.51.1", "1.11"}],
Cell[10430, 356, 178, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.12"}],

Cell[CellGroupData[{
Cell[10633, 365, 104, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[10740, 369, 370, 9, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[11125, 381, 125, 3, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.13"}],

Cell[CellGroupData[{
Cell[11275, 388, 105, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[11383, 392, 368, 9, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11800, 407, 95, 1, 70, "Subsubsection",
  CellTags->{"S5.51.1", "1.14"}],
Cell[11898, 410, 3888, 119, 70, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[15789, 531, 88, 1, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[15880, 534, 353, 7, 70, "Text",
  CellTags->{"S5.51.1", "1.15"}],
Cell[16236, 543, 444, 9, 70, "Text",
  CellTags->{"S5.51.1", "1.16"}],
Cell[16683, 554, 101, 1, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.17"}],
Cell[16787, 557, 193, 7, 70, "Input",
  CellTags->"S5.51.1"],
Cell[16983, 566, 232, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.18"}],
Cell[17218, 573, 143, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[17364, 580, 135, 3, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.19"}],

Cell[CellGroupData[{
Cell[17524, 587, 77, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[17604, 591, 79, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[17698, 596, 256, 6, 70, "Text",
  CellTags->{"S5.51.1", "1.20"}],
Cell[17957, 604, 229, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.21"}],
Cell[18189, 611, 107, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[18299, 615, 184, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.22"}],

Cell[CellGroupData[{
Cell[18508, 624, 109, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[18620, 628, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18749, 636, 77, 1, 70, "Subsubsection",
  CellTags->{"S5.51.1", "1.23"}],
Cell[18829, 639, 265, 5, 70, "Text",
  CellTags->{"S5.51.1", "1.24"}],
Cell[19097, 646, 3356, 106, 70, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[22456, 754, 63, 1, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[22522, 757, 832, 34, 70, "Text",
  CellTags->{"S5.51.1", "1.25"}],
Cell[23357, 793, 192, 4, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.26"}],

Cell[CellGroupData[{
Cell[23574, 801, 106, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[23683, 805, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[23778, 810, 578, 16, 70, "Text",
  CellTags->{"S5.51.1", "1.27"}],
Cell[24359, 828, 2097, 66, 70, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[26459, 896, 58, 1, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[26520, 899, 993, 38, 70, "Text",
  CellTags->{"S5.51.1", "1.28"}],
Cell[27516, 939, 209, 4, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.29"}],

Cell[CellGroupData[{
Cell[27750, 947, 146, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[27899, 954, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28028, 962, 77, 1, 70, "Subsubsection",
  CellTags->{"S5.51.1", "1.30"}],
Cell[28108, 965, 1158, 39, 70, "Text",
  CellTags->{"S5.51.1", "1.31"}],
Cell[29269, 1006, 3345, 106, 70, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[32617, 1114, 63, 1, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[32683, 1117, 168, 4, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.32"}],

Cell[CellGroupData[{
Cell[32876, 1125, 108, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[32987, 1129, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[33082, 1134, 333, 6, 70, "Text",
  CellTags->{"S5.51.1", "1.33"}],
Cell[33418, 1142, 145, 4, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.34"}],

Cell[CellGroupData[{
Cell[33588, 1150, 124, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[33715, 1157, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[33810, 1162, 703, 11, 70, "Text",
  CellTags->{"S5.51.1", "1.35"}],
Cell[34516, 1175, 4179, 129, 70, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[38698, 1306, 71, 1, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[38772, 1309, 1902, 68, 70, "Text",
  CellTags->{"S5.51.1", "1.36"}],
Cell[40677, 1379, 176, 4, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.37"}],

Cell[CellGroupData[{
Cell[40878, 1387, 186, 6, 70, "Input",
  CellTags->"S5.51.1"],
Cell[41067, 1395, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[41162, 1400, 4181, 129, 70, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[45346, 1531, 72, 1, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[45421, 1534, 1818, 66, 70, "Text",
  CellTags->{"S5.51.1", "1.38"}],
Cell[47242, 1602, 248, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.39"}],

Cell[CellGroupData[{
Cell[47515, 1611, 187, 6, 70, "Input",
  CellTags->"S5.51.1"],
Cell[47705, 1619, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47834, 1627, 86, 1, 70, "Subsubsection",
  CellTags->{"S5.51.1", "1.40"}],
Cell[47923, 1630, 711, 13, 70, "Text",
  CellTags->{"S5.51.1", "1.41"}],
Cell[48637, 1645, 2299, 67, 70, "DefinitionBox",
  CellTags->"S5.51.1"],
Cell[50939, 1714, 121, 5, 70, "Caption",
  CellTags->"S5.51.1"],
Cell[51063, 1721, 499, 14, 70, "Text",
  CellTags->{"S5.51.1", "1.42"}],
Cell[51565, 1737, 192, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.43"}],

Cell[CellGroupData[{
Cell[51782, 1746, 138, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[51923, 1753, 232, 6, 70, "Print",
  CellTags->"S5.51.1"],
Cell[52158, 1761, 242, 6, 70, "Print",
  CellTags->"S5.51.1"],
Cell[52403, 1769, 178, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[52584, 1776, 196, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[52783, 1783, 192, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[52978, 1790, 241, 6, 70, "Print",
  CellTags->"S5.51.1"],
Cell[53222, 1798, 204, 5, 70, "Print",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[53441, 1806, 389, 13, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.44"}],

Cell[CellGroupData[{
Cell[53855, 1823, 140, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[53998, 1830, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[54093, 1835, 249, 7, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.45"}],

Cell[CellGroupData[{
Cell[54367, 1846, 105, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[54475, 1850, 301442, 16157, 70, 301371, 16154, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.51.1"],
Cell[355920, 18009, 181, 6, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[356116, 18018, 398, 7, 70, "Text",
  CellTags->{"S5.51.1", "1.46"}],
Cell[356517, 18027, 158, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.47"}],

Cell[CellGroupData[{
Cell[356700, 18036, 139, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[356842, 18043, 198, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[357043, 18050, 250, 6, 70, "Print",
  CellTags->"S5.51.1"],
Cell[357296, 18058, 178, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[357477, 18065, 194, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[357674, 18072, 192, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[357869, 18079, 241, 6, 70, "Print",
  CellTags->"S5.51.1"],
Cell[358113, 18087, 204, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[358320, 18094, 208, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[358531, 18101, 213, 6, 70, "Print",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[358759, 18110, 126, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.48"}],

Cell[CellGroupData[{
Cell[358910, 18119, 141, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[359054, 18126, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[359149, 18131, 205, 4, 70, "Text",
  CellTags->{"S5.51.1", "1.49"}],
Cell[359357, 18137, 84, 1, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.50"}],

Cell[CellGroupData[{
Cell[359466, 18142, 137, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[359606, 18149, 198, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[359807, 18156, 269, 6, 70, "Print",
  CellTags->"S5.51.1"],
Cell[360079, 18164, 178, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[360260, 18171, 196, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[360459, 18178, 194, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[360656, 18185, 241, 6, 70, "Print",
  CellTags->"S5.51.1"],
Cell[360900, 18193, 202, 5, 70, "Print",
  CellTags->"S5.51.1"],
Cell[361105, 18200, 230, 6, 70, "Print",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[361350, 18209, 84, 1, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.51"}],

Cell[CellGroupData[{
Cell[361459, 18214, 140, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[361602, 18221, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[361697, 18226, 211, 5, 70, "Text",
  CellTags->{"S5.51.1", "1.52"}],
Cell[361911, 18233, 127, 3, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.53"}],

Cell[CellGroupData[{
Cell[362063, 18240, 124, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[362190, 18247, 122836, 6609, 70, 122765, 6606, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[485075, 24862, 136, 3, 70, "Subsubsection",
  CellTags->{"S5.51.1", "1.54"}],
Cell[485214, 24867, 734, 23, 70, "Text",
  CellTags->{"S5.51.1", "1.55"}],
Cell[485951, 24892, 614, 18, 70, "Text",
  CellTags->{"S5.51.1", "1.56"}],
Cell[486568, 24912, 146, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.57"}],

Cell[CellGroupData[{
Cell[486739, 24921, 136, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[486878, 24928, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[486973, 24933, 467, 11, 70, "Text",
  CellTags->{"S5.51.1", "1.58"}],
Cell[487443, 24946, 225, 7, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.59"}],

Cell[CellGroupData[{
Cell[487693, 24957, 143, 4, 70, "Input",
  CellTags->"S5.51.1"],
Cell[487839, 24963, 491, 13, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[488345, 24979, 168, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.60"}],

Cell[CellGroupData[{
Cell[488538, 24988, 178, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[488719, 24995, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[488814, 25000, 158, 4, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.61"}],

Cell[CellGroupData[{
Cell[488997, 25008, 169, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[489169, 25015, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[489264, 25020, 197, 7, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.62"}],

Cell[CellGroupData[{
Cell[489486, 25031, 122, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[489611, 25035, 373, 9, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[489999, 25047, 224, 6, 70, "Text",
  CellTags->{"S5.51.1", "1.63"}],
Cell[490226, 25055, 1168, 26, 70, "Text",
  CellTags->{"S5.51.1", "1.64"}],
Cell[491397, 25083, 566, 11, 70, "Text",
  CellTags->{"S5.51.1", "1.65"}],
Cell[491966, 25096, 159, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.66"}],

Cell[CellGroupData[{
Cell[492150, 25105, 128, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[492281, 25112, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[492376, 25117, 308, 7, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.67"}],

Cell[CellGroupData[{
Cell[492709, 25128, 146, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[492858, 25135, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[492953, 25140, 781, 22, 70, "Text",
  CellTags->{"S5.51.1", "1.68"}],
Cell[493737, 25164, 159, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.69"}],

Cell[CellGroupData[{
Cell[493921, 25173, 100, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[494024, 25177, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[494119, 25182, 204, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.70"}],

Cell[CellGroupData[{
Cell[494348, 25191, 126, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[494477, 25198, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[494572, 25203, 649, 25, 70, "Text",
  CellTags->{"S5.51.1", "1.71"}],
Cell[495224, 25230, 97, 1, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.72"}],

Cell[CellGroupData[{
Cell[495346, 25235, 89, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[495438, 25239, 4659, 323, 70, 4588, 320, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.51.1"],
Cell[500100, 25564, 181, 6, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[500296, 25573, 150, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.73"}],

Cell[CellGroupData[{
Cell[500471, 25582, 129, 5, 70, "Input",
  CellTags->"S5.51.1"],
Cell[500603, 25589, 3501, 252, 70, 3430, 249, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.51.1"],
Cell[504107, 25843, 181, 6, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]],
Cell[504303, 25852, 627, 14, 70, "Text",
  CellTags->{"S5.51.1", "1.74"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[504967, 25871, 101, 1, 70, "Subsubsection",
  CellTags->{"S5.51.1", "1.75"}],
Cell[505071, 25874, 315, 9, 70, "Text",
  CellTags->{"S5.51.1", "1.76"}],
Cell[505389, 25885, 82, 1, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.77"}],
Cell[505474, 25888, 248, 9, 70, "Input",
  CellTags->"S5.51.1"],
Cell[505725, 25899, 152, 5, 70, "MathCaption",
  CellTags->{"S5.51.1", "1.78"}],

Cell[CellGroupData[{
Cell[505902, 25908, 80, 2, 70, "Input",
  CellTags->"S5.51.1"],
Cell[505985, 25912, 80, 2, 70, "Output",
  CellTags->"S5.51.1"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

