(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7711,        240]*)
(*NotebookOutlinePosition[      8413,        264]*)
(*  CellTagsIndexPosition[      8369,        260]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Utilities`Benchmark`", "Section"],

Cell[TextData[{
  "This package contains functions for measuring the performance of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on your computer and for producing a comparison report that includes \
benchmark results for other computers. The ",
  StyleBox["MathematicaMark",
    FontSlant->"Italic"],
  " 5.2 ",
  "benchmark, a collection of typical numeric and symbolic computations, is \
used for evaluating the performance of the computer system on which ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is run.\nThe overall ",
  StyleBox["MathematicaMark",
    FontSlant->"Italic"],
  " 5.2 ",
  "result is computed as the mean of the reciprocal of individual timings, \
normalized with respect to a reference system. The timings for the individual \
computations are measured using ",
  StyleBox["AbsoluteTiming[ ]", "MR"],
  ", which returns wall-clock time. Running the ",
  StyleBox["MathematicaMark ",
    FontSlant->"Italic"],
  StyleBox["5.2",
    FontSlant->"Plain"],
  " benchmark takes about 90 seconds on the reference system and requires 512 \
MB of free memory.\nIf ",
  StyleBox["Parallel Computing Toolkit",
    FontSlant->"Italic"],
  " has been loaded and the ",
  StyleBox["$Slaves", "MR"],
  " symbol is not an empty list, a parallel version of the ",
  StyleBox["MathematicaMark",
    FontSlant->"Italic"],
  " 5.2 ",
  "benchmark will run automatically."
}], "Text"],

Cell["This loads the package.", "MathCaption"],

Cell[BoxData[
    \(<< Utilities`Benchmark`\)], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  StyleBox["BenchmarkReport[ ]", "MR",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  " runs the ",
  StyleBox["MathematicaMark",
    FontSlant->"Italic"],
  " 5.2",
  " benchmark and produces a notebook report that compares the performance of \
your computer with results from several known systems. If no front end is \
available, a plain text version of the report is returned."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["BenchmarkReport[ ]", "MR"]]], Cell[
            TextData[{
              "run the ",
              StyleBox["MathematicaMark",
                FontSlant->"Italic"],
              " 5.2",
              " benchmark and produce a comparison report"
            }]]}
          },
        ColumnAlignments->{Right, Left}], Text]], "DefinitionBox"],

Cell["Generating a benchmark report.", "Caption"],

Cell[TextData[{
  StyleBox["Benchmark[ ]", "MR"],
  " runs the ",
  StyleBox["MathematicaMark",
    FontSlant->"Italic"],
  " 5.2",
  " benchmark and returns the results as raw data. This package includes a \
collection of benchmark results for a variety of systems as given in ",
  StyleBox["$BenchmarkSystems", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["Benchmark[ ]", "MR"]]], Cell[
            "raw benchmark data"]},
          {Cell[TextData[StyleBox["$BenchmarkSystems", "MR"]]], Cell[
            TextData[{
              "systems for which ",
              StyleBox["MathematicaMark",
                FontSlant->"Italic"],
              " 5.2",
              " benchmark data is known"
            }]]}
          },
        ColumnAlignments->{Right, Left}], Text]], "DefinitionBox"],

Cell["Benchmark utilities.", "Caption"],

Cell[TextData[{
  "This gives raw benchmark data in ",
  StyleBox["InputForm", "MR"],
  ". (The data shown here was produced on the reference system.)"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Benchmark[]\)], "Input",
  CellLabel->"In[2]:="],

Cell["\<\
{\"MachineName\" -> \"reference\", 
 \"System\" -> \"Microsoft Windows XP\", 
 \"BenchmarkName\" -> \"MathematicaMark5.2\", 
 \"FullVersionNumber\" -> \"5.2.0\", 
 \"Date\" -> \"May 11, 2005\", \"BenchmarkResult\" -> 1.0, 
 \"TotalTime\" -> 92.915, \"Results\" -> 
  {{\"Data Fitting\", 4.156}, {\"Digits of Pi\", 5.186}, 
   {\"Discrete Fourier Transform\", 4.766}, 
   {\"Eigenvalues of a Matrix\", 8.108}, 
   {\"Elementary Functions\", 6.203}, 
   {\"Gamma Function\", 5.218}, 
   {\"Large Integer Multiplication\", 5.188}, 
   {\"Matrix Exponential\", 5.609}, 
   {\"Matrix Multiplication\", 8.625}, 
   {\"Matrix Transpose\", 6.592}, 
   {\"Numerical Integration\", 4.891}, 
   {\"Polynomial Expansion\", 5.421}, 
   {\"Random Number Sort\", 5.046}, 
   {\"Singular Value Decomposition\", 8.656}, 
   {\"Solving a Linear System\", 9.25}}}\
\>", "Output",
  CellLabel->"Out[2]//InputForm="]
}, Open  ]],

Cell[TextData[{
  "You can create a customized comparison report using ",
  StyleBox["BenchmarkReport[ ]", "MR"],
  " by specifying computer systems from ",
  StyleBox["$BenchmarkSystems", "MR"],
  " and raw benchmark data as returned by ",
  StyleBox["Benchmark[ ]", "MR"],
  "."
}], "Text",
  ShowCellBracket->True],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BenchmarkReport[", "MR"],
              StyleBox["string1, string2, ..., data1, data2, ...", "TI"],
              StyleBox["]", "MR"]
            }]], Cell["\<\
produce a custom comparison report with the specified systems and raw data\
\>"]}
          },
        ColumnAlignments->{Right, Left}], Text]], "DefinitionBox"],

Cell["Produce a customized notebook report.", "Caption"],

Cell["This gives a report for two known systems and your computer.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BenchmarkReport["\<2p 2.5 GHz G5 (Apple Mac OS 10.4.1)\>", \ \ "\<3.0 \
GHz Pentium 4 (Red Hat Linux 9)\>", %]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    InterpretationBox[\(NotebookObject[\[LeftSkeleton]"MathematicaMark5.2 \
Report"\[RightSkeleton]]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "nkv_shm", 1, 1]], 91],
      Editable->False]], "Output",
  CellLabel->"Out[3]="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
WindowSize->{656, 671},
WindowMargins->{{127, Automatic}, {Automatic, 60}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 39, 0, 65, "Section"],
Cell[1818, 55, 1416, 37, 194, "Text"],
Cell[3237, 94, 46, 0, 41, "MathCaption"],
Cell[3286, 96, 80, 2, 29, "Input"],
Cell[3369, 100, 426, 11, 59, "Text"],
Cell[3798, 113, 413, 11, 62, "DefinitionBox"],
Cell[4214, 126, 49, 0, 17, "Caption"],
Cell[4266, 128, 337, 10, 42, "Text"],
Cell[4606, 140, 505, 13, 70, "DefinitionBox"],
Cell[5114, 155, 39, 0, 17, "Caption"],
Cell[5156, 157, 170, 4, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[5351, 165, 68, 2, 29, "Input"],
Cell[5422, 169, 905, 22, 404, "Output"]
}, Open  ]],
Cell[6342, 194, 317, 9, 42, "Text"],
Cell[6662, 205, 409, 10, 62, "DefinitionBox"],
Cell[7074, 217, 56, 0, 17, "Caption"],
Cell[7133, 219, 85, 1, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[7243, 224, 167, 3, 49, "Input"],
Cell[7413, 229, 270, 7, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

