(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     45094,       1506]*)
(*NotebookOutlinePosition[     49536,       1641]*)
(*  CellTagsIndexPosition[     49146,       1622]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "BesselZeros",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.77.1", "1.1"}],

Cell[TextData[{
 "Exact solutions to many partial differential equations can be expressed as \
infinite sums over the zeros of some Bessel function or functions. For \
example, the solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["U",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["r",
       "TI"], ",", 
      StyleBox["t",
       "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to the heat equation in canonical units on the unit disc with initial \
temperature ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["U",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["r",
       "TI"], ",", "0"}], ")"}], "=", "0"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and boundary condition ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["U",
     "TI"], 
    RowBox[{"(", 
     RowBox[{"1", ",", 
      StyleBox["t",
       "TI"]}], ")"}], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is given by "
}], "Text",
 CellTags->{"S5.77.1", "1.2"}],

Cell["", "Text",
 CellTags->{"S5.77.1", "1.3"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["U",
    "TI"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["r",
      "TI"], ",", 
     StyleBox["t",
      "TI"]}], ")"}], "=", "1", "-", "2", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["n",
      "TI"], "=", "1"}], "\[Infinity]",
    LimitsPositioning->False], 
   FractionBox[
    RowBox[{
     SubscriptBox[
      StyleBox["J",
       "TI"], "0"], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Alpha]", 
        StyleBox["n",
         "TI"]], 
       StyleBox["r",
        "TI"]}], ")"}]}], 
    RowBox[{
     SubscriptBox["\[Alpha]", 
      StyleBox["n",
       "TI"]], 
     SubscriptBox[
      StyleBox["J",
       "TI"], "1"], 
     RowBox[{"(", 
      SubscriptBox["\[Alpha]", 
       StyleBox["n",
        "TI"]], ")"}]}]], 
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    RowBox[{"-", 
     SubsuperscriptBox["\[Alpha]", 
      StyleBox["n",
       "TI"], "2"], 
     StyleBox["t",
      "TI"]}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.77.1", "1.4"}],

Cell[TextData[{
 "where the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the positive zeros of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["J",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", "1"], "\[TildeTilde]", "2.40483"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", "2"], "\[TildeTilde]", "5.52008"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Alpha]", "3"], "\[TildeTilde]", "8.65373"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", etc. Using ",
 StyleBox["FindRoot", "MR"],
 " it is not difficult to find any single desired zero if you can find a good \
pair of starting values. This package automatically chooses starting values \
and uses ",
 StyleBox["FindRoot", "MR"],
 " to efficiently produce lists of positive zeros of various Bessel \
functions. "
}], "Text",
 CellTags->{"S5.77.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BesselJZeros[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the first ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselYZeros[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the first ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJPrimeZeros[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the first ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselYPrimeZeros[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the first ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJYJYZeros[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the first ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}], 
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], "-", 
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], 
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJPrimeYPrimeJPrimeYPrimeZeros[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}], 
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], "-", 
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], 
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJPrimeYJYPrimeZeros[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}], 
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], "-", 
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], 
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJZeros[ ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["} ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["BesselYZeros[ ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["} ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", etc. ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list containing the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" through the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" zeros ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.77.1"],

Cell["Finding zeros of Bessel functions. ", "Caption",
 CellTags->"S5.77.1"],

Cell[TextData[{
 "Note that ",
 StyleBox["FindRoot", "MR"],
 " can be used with a single starting value, in which case the method is \
based on Newton\[CloseCurlyQuote]s method. But the derivative of a Bessel \
function is usually expressed in terms of two other Bessel functions. In such \
cases the secant method is more efficient than Newton\[CloseCurlyQuote]s \
method. The secant method requires a pair of starting values, preferably one \
on each side of the desired zero and sufficiently close to uniquely determine \
the zero. "
}], "Text",
 CellTags->{"S5.77.1", "1.6"}],

Cell[TextData[{
 "Asymptotic formulae exist for approximating the ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " zeros as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[Rule]", "\[Infinity]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", but the approximations are too inaccurate even to be used as starting \
values to ",
 StyleBox["FindRoot", "MR"],
 " when ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is small and the order ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is large. As a result, the package works by finding an ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " sufficiently large that a good approximation results. After finding \
several consecutive zeros it is able to extrapolate backwards to get a \
starting value for the zero immediately preceding the smallest currently \
known zero. By proceeding in this manner it is able to find the requested \
zeros. "
}], "Text",
 CellTags->{"S5.77.1", "1.7"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorkingPrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["MachinePrecision", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "precision of the arithmetic to use in calculations ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AccuracyGoal", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "desired accuracy of the function at the zeros ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.77.1"],

Cell[TextData[{
 "Options for the ",
 StyleBox["BesselZero", "MR"],
 " functions. "
}], "Caption",
 CellTags->"S5.77.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.77.1", "1.8"}],

Cell["<< NumericalMath`BesselZeros`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.77.1"],

Cell[TextData[{
 "This gives the first 5 zeros of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["J",
      "TI"], "0"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.77.1", "1.9"}],

Cell[CellGroupData[{

Cell["BesselJZeros[0, 5]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.77.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.404825557695773`", ",", "5.5200781102863115`", ",", "8.653727912911013`",
    ",", "11.791534439014281`", ",", "14.930917708487787`"}], "}"}]], "Output",\

 CellLabel->"Out[2]= ",
 CellTags->"S5.77.1"]
}, Open  ]],

Cell[TextData[{
 "Here are the 17",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", 18",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and 19",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " zeros of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox[
     StyleBox["Y",
      "TI"], "3", "\[Prime]"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.77.1", "1.10"}],

Cell[CellGroupData[{

Cell["BesselYPrimeZeros[3, {17, 19}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.77.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "57.24887124516515`", ",", "60.39490564887158`", ",", 
   "63.54049914676421`"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.77.1"]
}, Open  ]],

Cell[TextData[{
 "This gives high\[Hyphen]precision values of the first 3 zeros of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["J",
      "TI"], "2"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], 
    SubscriptBox[
     StyleBox["Y",
      "TI"], "2"], 
    RowBox[{"(", 
     RowBox[{"6", "/", "5", 
      StyleBox["x",
       "TI"]}], ")"}], "-", 
    SubscriptBox[
     StyleBox["J",
      "TI"], "2"], 
    RowBox[{"(", 
     RowBox[{"6", "/", "5", 
      StyleBox["x",
       "TI"]}], ")"}], 
    SubscriptBox[
     StyleBox["Y",
      "TI"], "2"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.77.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
BesselJYJYZeros[2, 6/5, 3,
           WorkingPrecision -> 30]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.77.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "15.80662244417657902536470155747273435124`30.", ",", 
   "31.46556009153684464626531487380467290573`30.", ",", 
   "47.1570167108650317281338334228993077571`30."}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.77.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BesselJZerosInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselYZerosInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJPrimeZerosInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselYPrimeZerosInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJYJYZerosInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}], 
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], "-", 
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], 
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJPrimeYPrimeJPrimeYPrimeZerosInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}], 
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], "-", 
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], 
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BesselJPrimeYJYPrimeZerosInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["nu", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["lambda", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the zeros of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}], 
         SubscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], "-", 
         SubscriptBox[
          StyleBox["J",
           "TI"], "\[Nu]"], 
         RowBox[{"(", 
          RowBox[{"\[Lambda]", 
           StyleBox["x",
            "TI"]}], ")"}], 
         SubsuperscriptBox[
          StyleBox["Y",
           "TI"], "\[Nu]", "\[Prime]"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["max", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.77.1"],

Cell["Finding zeros of Bessel functions between two numbers. ", "Caption",
 CellTags->"S5.77.1"],

Cell["\<\
The package also implements a bisection method for locating zeros between two \
positive starting values. \
\>", "Text",
 CellTags->{"S5.77.1", "1.12"}],

Cell["\<\
Here are the zeros of the first\[Hyphen]order Bessel J function between 1 and \
10. \
\>", "MathCaption",
 CellTags->{"S5.77.1", "1.13"}],

Cell[CellGroupData[{

Cell["BesselJZerosInterval[1, {1, 10}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.77.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.831705970207512`", ",", "7.015586669815616`"}], "}"}]], "Output",\

 CellLabel->"Out[5]= ",
 CellTags->"S5.77.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.77.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.77.1", "1.1"}],
    Cell[1920, 61, 1138, 42, 72, "Text",
      CellTags->{"S5.77.1", "1.2"}],
    Cell[3061, 105, 47, 1, 24, "Text",
      CellTags->{"S5.77.1", "1.3"}],
    Cell[3111, 108, 1162, 50, 52, "DisplayFormula",
      CellTags->{"S5.77.1", "1.4"}],
    Cell[4276, 160, 1351, 45, 72, "Text",
      CellTags->{"S5.77.1", "1.5"}],
    Cell[5630, 207, 15204, 488, 282, "DefinitionBox",
      CellTags->"S5.77.1"],
    Cell[20837, 697, 76, 1, 15, "Caption",
      CellTags->"S5.77.1"],
    Cell[20916, 700, 579, 11, 88, "Text",
      CellTags->{"S5.77.1", "1.6"}],
    Cell[21498, 713, 1497, 43, 70, "Text",
      CellTags->{"S5.77.1", "1.7"}],
    Cell[22998, 758, 2695, 77, 70, "DefinitionBox3Col",
      CellTags->"S5.77.1"],
    Cell[25696, 837, 120, 5, 70, "Caption",
      CellTags->"S5.77.1"],
    Cell[25819, 844, 78, 1, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.8"}],
    Cell[25900, 847, 92, 2, 70, "Input",
      CellTags->"S5.77.1"],
    Cell[25995, 851, 344, 14, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.9"}],
    Cell[26364, 869, 81, 2, 70, "Input",
      CellTags->"S5.77.1"],
    Cell[26448, 873, 246, 7, 70, "Output",
      CellTags->"S5.77.1"],
    Cell[26709, 883, 814, 29, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.10"}],
    Cell[27548, 916, 93, 2, 70, "Input",
      CellTags->"S5.77.1"],
    Cell[27644, 920, 187, 6, 70, "Output",
      CellTags->"S5.77.1"],
    Cell[27846, 929, 794, 34, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.11"}],
    Cell[28665, 967, 132, 5, 70, "Input",
      CellTags->"S5.77.1"],
    Cell[28800, 974, 271, 7, 70, "Output",
      CellTags->"S5.77.1"],
    Cell[29086, 984, 15288, 490, 70, "DefinitionBox",
      CellTags->"S5.77.1"],
    Cell[44377, 1476, 96, 1, 70, "Caption",
      CellTags->"S5.77.1"],
    Cell[44476, 1479, 162, 4, 70, "Text",
      CellTags->{"S5.77.1", "1.12"}],
    Cell[44641, 1485, 147, 4, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.13"}],
    Cell[44813, 1493, 95, 2, 70, "Input",
      CellTags->"S5.77.1"],
    Cell[44911, 1497, 155, 5, 70, "Output",
      CellTags->"S5.77.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.77.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 1138, 42, 72, "Text",
      CellTags->{"S5.77.1", "1.2"}]},
  "1.3"->{
    Cell[3061, 105, 47, 1, 24, "Text",
      CellTags->{"S5.77.1", "1.3"}]},
  "1.4"->{
    Cell[3111, 108, 1162, 50, 52, "DisplayFormula",
      CellTags->{"S5.77.1", "1.4"}]},
  "1.5"->{
    Cell[4276, 160, 1351, 45, 72, "Text",
      CellTags->{"S5.77.1", "1.5"}]},
  "1.6"->{
    Cell[20916, 700, 579, 11, 88, "Text",
      CellTags->{"S5.77.1", "1.6"}]},
  "1.7"->{
    Cell[21498, 713, 1497, 43, 70, "Text",
      CellTags->{"S5.77.1", "1.7"}]},
  "1.8"->{
    Cell[25819, 844, 78, 1, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.8"}]},
  "1.9"->{
    Cell[25995, 851, 344, 14, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.9"}]},
  "1.10"->{
    Cell[26709, 883, 814, 29, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.10"}]},
  "1.11"->{
    Cell[27846, 929, 794, 34, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.11"}]},
  "1.12"->{
    Cell[44476, 1479, 162, 4, 70, "Text",
      CellTags->{"S5.77.1", "1.12"}]},
  "1.13"->{
    Cell[44641, 1485, 147, 4, 70, "MathCaption",
      CellTags->{"S5.77.1", "1.13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.77.1", 45717, 1522},
  {"1.1", 47898, 1579},
  {"1.2", 47992, 1582},
  {"1.3", 48082, 1585},
  {"1.4", 48170, 1588},
  {"1.5", 48271, 1591},
  {"1.6", 48362, 1594},
  {"1.7", 48453, 1597},
  {"1.8", 48545, 1600},
  {"1.9", 48641, 1603},
  {"1.10", 48740, 1606},
  {"1.11", 48840, 1609},
  {"1.12", 48940, 1612},
  {"1.13", 49033, 1615}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.77.1", "1.1"}],
Cell[1920, 61, 1138, 42, 72, "Text",
  CellTags->{"S5.77.1", "1.2"}],
Cell[3061, 105, 47, 1, 24, "Text",
  CellTags->{"S5.77.1", "1.3"}],
Cell[3111, 108, 1162, 50, 52, "DisplayFormula",
  CellTags->{"S5.77.1", "1.4"}],
Cell[4276, 160, 1351, 45, 72, "Text",
  CellTags->{"S5.77.1", "1.5"}],
Cell[5630, 207, 15204, 488, 282, "DefinitionBox",
  CellTags->"S5.77.1"],
Cell[20837, 697, 76, 1, 15, "Caption",
  CellTags->"S5.77.1"],
Cell[20916, 700, 579, 11, 88, "Text",
  CellTags->{"S5.77.1", "1.6"}],
Cell[21498, 713, 1497, 43, 70, "Text",
  CellTags->{"S5.77.1", "1.7"}],
Cell[22998, 758, 2695, 77, 70, "DefinitionBox3Col",
  CellTags->"S5.77.1"],
Cell[25696, 837, 120, 5, 70, "Caption",
  CellTags->"S5.77.1"],
Cell[25819, 844, 78, 1, 70, "MathCaption",
  CellTags->{"S5.77.1", "1.8"}],
Cell[25900, 847, 92, 2, 70, "Input",
  CellTags->"S5.77.1"],
Cell[25995, 851, 344, 14, 70, "MathCaption",
  CellTags->{"S5.77.1", "1.9"}],

Cell[CellGroupData[{
Cell[26364, 869, 81, 2, 70, "Input",
  CellTags->"S5.77.1"],
Cell[26448, 873, 246, 7, 70, "Output",
  CellTags->"S5.77.1"]
}, Open  ]],
Cell[26709, 883, 814, 29, 70, "MathCaption",
  CellTags->{"S5.77.1", "1.10"}],

Cell[CellGroupData[{
Cell[27548, 916, 93, 2, 70, "Input",
  CellTags->"S5.77.1"],
Cell[27644, 920, 187, 6, 70, "Output",
  CellTags->"S5.77.1"]
}, Open  ]],
Cell[27846, 929, 794, 34, 70, "MathCaption",
  CellTags->{"S5.77.1", "1.11"}],

Cell[CellGroupData[{
Cell[28665, 967, 132, 5, 70, "Input",
  CellTags->"S5.77.1"],
Cell[28800, 974, 271, 7, 70, "Output",
  CellTags->"S5.77.1"]
}, Open  ]],
Cell[29086, 984, 15288, 490, 70, "DefinitionBox",
  CellTags->"S5.77.1"],
Cell[44377, 1476, 96, 1, 70, "Caption",
  CellTags->"S5.77.1"],
Cell[44476, 1479, 162, 4, 70, "Text",
  CellTags->{"S5.77.1", "1.12"}],
Cell[44641, 1485, 147, 4, 70, "MathCaption",
  CellTags->{"S5.77.1", "1.13"}],

Cell[CellGroupData[{
Cell[44813, 1493, 95, 2, 70, "Input",
  CellTags->"S5.77.1"],
Cell[44911, 1497, 155, 5, 70, "Output",
  CellTags->"S5.77.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

