(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27391,       1331]*)
(*NotebookOutlinePosition[     30792,       1436]*)
(*  CellTagsIndexPosition[     30526,       1422]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "BlackBodyRadiation",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.52.1", "1.1"}],

Cell["\<\
A body that absorbs all radiation incident on it is called an ideal black \
body. This package provides functions giving the basic properties of black\
\[Hyphen]body radiation at a specified temperature, and a function for \
plotting black\[Hyphen]body spectral distributions. \
\>", "Text",
 CellTags->{"S5.52.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PeakWavelength[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["temp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "wavelength of the maximum emission of a black body at the specified \
temperature",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TotalPower[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["temp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "total power of a black body at the specified temperature",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxPower[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["temp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["band", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "power of a black body at the specified temperature for the specified \
wavelength band about the peak wavelength ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.52.1"],

Cell["\<\
Black\[Hyphen]body radiation properties. \
\>", "Caption",
 CellTags->"S5.52.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.52.1", "1.3"}],

Cell["<<Miscellaneous`BlackBodyRadiation`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.52.1"],

Cell["\<\
The surface of the sun is about 5000 K. Assuming the sun is a \
black\[Hyphen]body radiator, this gives the wavelength at which its spectrum \
peaks. \
\>", "MathCaption",
 CellTags->{"S5.52.1", "1.4"}],

Cell[CellGroupData[{

Cell["PeakWavelength[5000 Kelvin]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.52.1"],

Cell[BoxData[
 RowBox[{"5.8`*^-7", " ", "Meter"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.52.1"]
}, Open  ]],

Cell["\<\
This gives the total power radiated by a black body at a temperature of 5000 \
K. \
\>", "MathCaption",
 CellTags->{"S5.52.1", "1.5"}],

Cell[CellGroupData[{

Cell["TotalPower[5000 Kelvin]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.52.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3.543999590227374`*^7", " ", "Watt"}], 
  SuperscriptBox["Meter", "2"]]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.52.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the radiative power in the wavelength interval of 0.1 ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " about the peak wavelength of a black body at a temperature of 5000 K. "
}], "MathCaption",
 CellTags->{"S5.52.1", "1.6"}],

Cell[CellGroupData[{

Cell["MaxPower[5000 Kelvin, 10^-7 Meter]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.52.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"4.017844556129016`*^6", " ", "Watt"}], 
  SuperscriptBox["Meter", "2"]]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.52.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BlackBodyProfile[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["temp",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["temp",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the black\[Hyphen]body spectral distribution profiles at the \
specified temperatures ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.52.1"],

Cell["Plotting black\[Hyphen]body profiles. ", "Caption",
 CellTags->"S5.52.1"],

Cell["\<\
This gives the spectral distribution of radiation from a black body for three \
different temperatures. \
\>", "MathCaption",
 CellTags->{"S5.52.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
BlackBodyProfile[4000 Kelvin, 5000 Kelvin, 6000 Kelvin,
 PlotRange -> {{0, 2 10^(-6)}, {0, 1.1 10^14}}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.52.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
2.26327e-17 500000 -1.63986e-17 5.61849e-15 [
[.125 -0.0125 -22.5 -12.5 ]
[.125 -0.0125 22.5 0 ]
[.25 -0.0125 -16.5 -12.5 ]
[.25 -0.0125 16.5 0 ]
[.375 -0.0125 -22.5 -12.5 ]
[.375 -0.0125 22.5 0 ]
[.5 -0.0125 -16.5 -12.5 ]
[.5 -0.0125 16.5 0 ]
[.625 -0.0125 -25.5 -12.5 ]
[.625 -0.0125 25.5 0 ]
[.75 -0.0125 -22.5 -12.5 ]
[.75 -0.0125 22.5 0 ]
[.875 -0.0125 -25.5 -12.5 ]
[.875 -0.0125 25.5 0 ]
[1 -0.0125 -16.5 -12.5 ]
[1 -0.0125 16.5 0 ]
[1.025 0 0 -4.90625 ]
[1.025 0 82 4.90625 ]
[-0.0125 .11237 -33 -6.25 ]
[-0.0125 .11237 0 6.25 ]
[-0.0125 .22474 -33 -6.25 ]
[-0.0125 .22474 0 6.25 ]
[-0.0125 .33711 -33 -6.25 ]
[-0.0125 .33711 0 6.25 ]
[-0.0125 .44948 -33 -6.25 ]
[-0.0125 .44948 0 6.25 ]
[-0.0125 .56185 -33 -6.25 ]
[-0.0125 .56185 0 6.25 ]
[0 .64303 -50 0 ]
[0 .64303 50 10.125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.125 0 m
.125 .00625 L
s
gsave
.125 -0.0125 -22.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.25 0 m
.25 .00625 L
s
gsave
.25 -0.0125 -16.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.375 0 m
.375 .00625 L
s
gsave
.375 -0.0125 -22.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(7.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.5 0 m
.5 .00625 L
s
gsave
.5 -0.0125 -16.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.625 0 m
.625 .00625 L
s
gsave
.625 -0.0125 -25.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.25) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.75 0 m
.75 .00625 L
s
gsave
.75 -0.0125 -22.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.875 0 m
.875 .00625 L
s
gsave
.875 -0.0125 -25.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.75) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
1 0 m
1 .00625 L
s
gsave
1 -0.0125 -16.5 -10.5 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Wavelength) show
123.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
135.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
141.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .11237 m
.00625 .11237 L
s
gsave
-0.0125 .11237 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(13) show
grestore
0 .22474 m
.00625 .22474 L
s
gsave
-0.0125 .22474 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(13) show
grestore
0 .33711 m
.00625 .33711 L
s
gsave
-0.0125 .33711 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(6) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(13) show
grestore
0 .44948 m
.00625 .44948 L
s
gsave
-0.0125 .44948 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(8) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(13) show
grestore
0 .56185 m
.00625 .56185 L
s
gsave
-0.0125 .56185 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(14) show
grestore
.125 Mabswid
0 .02809 m
.00375 .02809 L
s
0 .05618 m
.00375 .05618 L
s
0 .08428 m
.00375 .08428 L
s
0 .14046 m
.00375 .14046 L
s
0 .16855 m
.00375 .16855 L
s
0 .19665 m
.00375 .19665 L
s
0 .25283 m
.00375 .25283 L
s
0 .28092 m
.00375 .28092 L
s
0 .30902 m
.00375 .30902 L
s
0 .3652 m
.00375 .3652 L
s
0 .39329 m
.00375 .39329 L
s
0 .42139 m
.00375 .42139 L
s
0 .47757 m
.00375 .47757 L
s
0 .50566 m
.00375 .50566 L
s
0 .53376 m
.00375 .53376 L
s
0 .58994 m
.00375 .58994 L
s
0 .61803 m
.00375 .61803 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Intensity) show
117.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
129.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
135.000 11.562 moveto
(\\220) show
141.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
147.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(^) show
153.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
159.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
[ .01 .01 ] 0 setdash
.3625 0 m
.3625 .07403 L
s
gsave
.3625 .07403 -82.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4000.) show
95.625 11.250 moveto
(K) show
1.000 setlinewidth
grestore
[ ] 0 setdash
0 0 m
.00268 0 L
.00513 0 L
.00795 0 L
.01061 0 L
.01308 0 L
.01535 0 L
.01785 0 L
.0205 0 L
.02316 0 L
.02602 0 L
.02871 0 L
.03118 0 L
.03407 0 L
.0357 0 L
.03722 0 L
.03999 0 L
.04295 0 L
.04444 0 L
.04601 0 L
.04883 0 L
.05039 0 L
.05186 0 L
.05346 0 L
.05518 0 L
.05666 0 L
.05828 0 L
.06121 0 L
.06406 0 L
.0667 0 L
.06926 0 L
.07166 0 L
.0743 0 L
.07714 0 L
.07996 0 L
.08293 1e-05 L
.08546 1e-05 L
.08823 2e-05 L
.08985 2e-05 L
.09135 3e-05 L
.09296 4e-05 L
.09473 5e-05 L
.09771 7e-05 L
.10086 .00011 L
.10372 .00016 L
.10679 .00023 L
.10969 .00031 L
.11233 .00041 L
.11865 .00073 L
.12223 .00098 L
Mistroke
.12554 .00126 L
.13162 .00193 L
.13808 .00289 L
.14411 .00402 L
.15062 .00553 L
.16242 .00902 L
.18446 .01794 L
.22919 .04062 L
.25287 .05183 L
.27822 .06151 L
.29079 .06524 L
.30268 .06812 L
.31335 .07017 L
.31887 .07105 L
.32495 .07187 L
.33024 .07247 L
.33594 .07299 L
.34195 .07343 L
.34465 .07358 L
.34759 .07372 L
.35017 .07382 L
.35292 .07391 L
.35582 .07397 L
.35852 .07401 L
.36122 .07403 L
.36376 .07403 L
.36604 .07401 L
.36852 .07398 L
.37134 .07392 L
.37392 .07385 L
.37972 .07364 L
.3851 .07338 L
.39019 .07307 L
.40159 .07222 L
.414 .07105 L
.46209 .06495 L
.55515 .05081 L
.64475 .03861 L
.73089 .0294 L
.82263 .02207 L
.91091 .01689 L
Mfstroke
.91091 .01689 m
1 .01306 L
s
[ .01 .01 ] 0 setdash
.29 0 m
.29 .22592 L
s
gsave
.29 .22592 -82.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5000.) show
95.625 11.250 moveto
(K) show
1.000 setlinewidth
grestore
[ ] 0 setdash
0 0 m
.00215 0 L
.0041 0 L
.00636 0 L
.00849 0 L
.01046 0 L
.01228 0 L
.01428 0 L
.0164 0 L
.01853 0 L
.02081 0 L
.02297 0 L
.02495 0 L
.02725 0 L
.02856 0 L
.02977 0 L
.03199 0 L
.03436 0 L
.03555 0 L
.03681 0 L
.03906 0 L
.04031 0 L
.04148 0 L
.04277 0 L
.04414 0 L
.04533 0 L
.04662 0 L
.04897 0 L
.05125 0 L
.05336 0 L
.05541 0 L
.05733 0 L
.05944 0 L
.06171 1e-05 L
.06397 1e-05 L
.06634 2e-05 L
.06837 3e-05 L
.07059 5e-05 L
.07188 7e-05 L
.07308 9e-05 L
.07437 .00011 L
.07578 .00015 L
.07817 .00023 L
.08069 .00035 L
.08297 .00049 L
.08543 .0007 L
.08775 .00096 L
.08987 .00125 L
.09492 .00223 L
.09778 .00299 L
Mistroke
.10043 .00386 L
.10529 .0059 L
.11047 .00881 L
.11529 .01227 L
.1205 .01687 L
.12994 .02754 L
.14757 .05474 L
.18335 .12398 L
.20229 .15818 L
.22258 .1877 L
.23263 .1991 L
.24214 .20788 L
.25068 .21415 L
.2551 .21682 L
.25996 .21932 L
.26419 .22115 L
.26875 .22276 L
.27356 .22408 L
.27572 .22455 L
.27808 .22498 L
.28014 .22529 L
.28234 .22554 L
.28466 .22574 L
.28681 .22586 L
.28897 .22591 L
.29101 .22591 L
.29284 .22586 L
.29481 .22576 L
.29708 .22558 L
.29914 .22537 L
.30378 .22473 L
.30808 .22393 L
.31215 .223 L
.32127 .2204 L
.3312 .21684 L
.36967 .19821 L
.44412 .15505 L
.5158 .11783 L
.58471 .08973 L
.6581 .06735 L
.72873 .05155 L
.80383 .03924 L
.87616 .03054 L
.94573 .02427 L
Mfstroke
.94573 .02427 m
1 .02057 L
s
[ .01 .01 ] 0 setdash
.24167 0 m
.24167 .56215 L
s
gsave
.24167 .56215 -82.3125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6000.) show
95.625 11.250 moveto
(K) show
1.000 setlinewidth
grestore
[ ] 0 setdash
0 0 m
.00179 0 L
.00342 0 L
.0053 0 L
.00708 0 L
.00872 0 L
.01024 0 L
.0119 0 L
.01367 0 L
.01544 0 L
.01734 0 L
.01914 0 L
.02079 0 L
.02271 0 L
.0238 0 L
.02481 0 L
.02666 0 L
.02863 0 L
.02963 0 L
.03067 0 L
.03255 0 L
.0336 0 L
.03457 0 L
.03564 0 L
.03679 0 L
.03778 0 L
.03885 0 L
.0408 0 L
.04271 0 L
.04447 0 L
.04617 0 L
.04778 0 L
.04953 1e-05 L
.05143 1e-05 L
.05331 3e-05 L
.05529 5e-05 L
.05697 8e-05 L
.05882 .00013 L
.0599 .00017 L
.0609 .00022 L
.06197 .00028 L
.06315 .00037 L
.06514 .00057 L
.06724 .00086 L
.06915 .00122 L
.07119 .00174 L
.07312 .00238 L
.07489 .00311 L
.0791 .00554 L
.08149 .00745 L
Mistroke
.08369 .00961 L
.08774 .01469 L
.09205 .02192 L
.09607 .03052 L
.10041 .04197 L
.10828 .06853 L
.12297 .1362 L
.15279 .30849 L
.16858 .39361 L
.18548 .46706 L
.19386 .49543 L
.20179 .51728 L
.2089 .53288 L
.21258 .53951 L
.21663 .54575 L
.22016 .55029 L
.22396 .55429 L
.22797 .55758 L
.22977 .55875 L
.23173 .55982 L
.23345 .56058 L
.23528 .56123 L
.23721 .56172 L
.23901 .56201 L
.24081 .56214 L
.24251 .56213 L
.24403 .562 L
.24568 .56175 L
.24756 .56132 L
.24928 .5608 L
.25315 .55919 L
.25673 .5572 L
.26013 .5549 L
.26773 .54842 L
.276 .53957 L
.30806 .49322 L
.3701 .3858 L
.42983 .2932 L
.48726 .22328 L
.54842 .1676 L
.60727 .12826 L
.66986 .09764 L
.73014 .076 L
.78811 .06039 L
.84981 .04782 L
.90921 .03861 L
.97234 .03108 L
Mfstroke
.97234 .03108 m
1 .02853 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.52.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.52.1"]
}, Open  ]],

Cell[TextData[{
 "Note that you can use the option ",
 StyleBox["PlotStyle -> {", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["sty",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["sty",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] }", "MR"],
 " with ",
 StyleBox["BlackBodyProfile", "MR"],
 " to specify different styles for each profile curve. "
}], "Text",
 CellTags->{"S5.52.1", "1.8"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.52.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.52.1", "1.1"}],
    Cell[1927, 61, 332, 6, 56, "Text",
      CellTags->{"S5.52.1", "1.2"}],
    Cell[2262, 69, 2567, 77, 124, "DefinitionBox",
      CellTags->"S5.52.1"],
    Cell[4832, 148, 90, 3, 15, "Caption",
      CellTags->"S5.52.1"],
    Cell[4925, 153, 78, 1, 40, "MathCaption",
      CellTags->{"S5.52.1", "1.3"}],
    Cell[5006, 156, 98, 2, 28, "Input",
      CellTags->"S5.52.1"],
    Cell[5107, 160, 212, 5, 56, "MathCaption",
      CellTags->{"S5.52.1", "1.4"}],
    Cell[5344, 169, 90, 2, 28, "Input",
      CellTags->"S5.52.1"],
    Cell[5437, 173, 107, 3, 27, "Output",
      CellTags->"S5.52.1"],
    Cell[5559, 179, 144, 4, 40, "MathCaption",
      CellTags->{"S5.52.1", "1.5"}],
    Cell[5728, 187, 86, 2, 28, "Input",
      CellTags->"S5.52.1"],
    Cell[5817, 191, 168, 5, 43, "Output",
      CellTags->"S5.52.1"],
    Cell[6000, 199, 326, 7, 52, "MathCaption",
      CellTags->{"S5.52.1", "1.6"}],
    Cell[6351, 210, 97, 2, 28, "Input",
      CellTags->"S5.52.1"],
    Cell[6451, 214, 168, 5, 43, "Output",
      CellTags->"S5.52.1"],
    Cell[6634, 222, 1484, 44, 70, "DefinitionBox",
      CellTags->"S5.52.1"],
    Cell[8121, 268, 79, 1, 70, "Caption",
      CellTags->"S5.52.1"],
    Cell[8203, 271, 166, 4, 70, "MathCaption",
      CellTags->{"S5.52.1", "1.7"}],
    Cell[8394, 279, 174, 5, 70, "Input",
      CellTags->"S5.52.1"],
    Cell[8571, 286, 17985, 1010, 70, 17914, 1007, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.52.1"],
    Cell[26559, 1298, 180, 6, 70, "Output",
      CellTags->"S5.52.1"],
    Cell[26754, 1307, 621, 21, 70, "Text",
      CellTags->{"S5.52.1", "1.8"}]},
  "1.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.52.1", "1.1"}]},
  "1.2"->{
    Cell[1927, 61, 332, 6, 56, "Text",
      CellTags->{"S5.52.1", "1.2"}]},
  "1.3"->{
    Cell[4925, 153, 78, 1, 40, "MathCaption",
      CellTags->{"S5.52.1", "1.3"}]},
  "1.4"->{
    Cell[5107, 160, 212, 5, 56, "MathCaption",
      CellTags->{"S5.52.1", "1.4"}]},
  "1.5"->{
    Cell[5559, 179, 144, 4, 40, "MathCaption",
      CellTags->{"S5.52.1", "1.5"}]},
  "1.6"->{
    Cell[6000, 199, 326, 7, 52, "MathCaption",
      CellTags->{"S5.52.1", "1.6"}]},
  "1.7"->{
    Cell[8203, 271, 166, 4, 70, "MathCaption",
      CellTags->{"S5.52.1", "1.7"}]},
  "1.8"->{
    Cell[26754, 1307, 621, 21, 70, "Text",
      CellTags->{"S5.52.1", "1.8"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.52.1", 28014, 1347},
  {"1.1", 29759, 1394},
  {"1.2", 29853, 1397},
  {"1.3", 29941, 1400},
  {"1.4", 30036, 1403},
  {"1.5", 30132, 1406},
  {"1.6", 30228, 1409},
  {"1.7", 30324, 1412},
  {"1.8", 30420, 1415}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 148, 6, 36, "Subsection",
  CellTags->{"S5.52.1", "1.1"}],
Cell[1927, 61, 332, 6, 56, "Text",
  CellTags->{"S5.52.1", "1.2"}],
Cell[2262, 69, 2567, 77, 124, "DefinitionBox",
  CellTags->"S5.52.1"],
Cell[4832, 148, 90, 3, 15, "Caption",
  CellTags->"S5.52.1"],
Cell[4925, 153, 78, 1, 40, "MathCaption",
  CellTags->{"S5.52.1", "1.3"}],
Cell[5006, 156, 98, 2, 28, "Input",
  CellTags->"S5.52.1"],
Cell[5107, 160, 212, 5, 56, "MathCaption",
  CellTags->{"S5.52.1", "1.4"}],

Cell[CellGroupData[{
Cell[5344, 169, 90, 2, 28, "Input",
  CellTags->"S5.52.1"],
Cell[5437, 173, 107, 3, 27, "Output",
  CellTags->"S5.52.1"]
}, Open  ]],
Cell[5559, 179, 144, 4, 40, "MathCaption",
  CellTags->{"S5.52.1", "1.5"}],

Cell[CellGroupData[{
Cell[5728, 187, 86, 2, 28, "Input",
  CellTags->"S5.52.1"],
Cell[5817, 191, 168, 5, 43, "Output",
  CellTags->"S5.52.1"]
}, Open  ]],
Cell[6000, 199, 326, 7, 52, "MathCaption",
  CellTags->{"S5.52.1", "1.6"}],

Cell[CellGroupData[{
Cell[6351, 210, 97, 2, 28, "Input",
  CellTags->"S5.52.1"],
Cell[6451, 214, 168, 5, 43, "Output",
  CellTags->"S5.52.1"]
}, Open  ]],
Cell[6634, 222, 1484, 44, 70, "DefinitionBox",
  CellTags->"S5.52.1"],
Cell[8121, 268, 79, 1, 70, "Caption",
  CellTags->"S5.52.1"],
Cell[8203, 271, 166, 4, 70, "MathCaption",
  CellTags->{"S5.52.1", "1.7"}],

Cell[CellGroupData[{
Cell[8394, 279, 174, 5, 70, "Input",
  CellTags->"S5.52.1"],
Cell[8571, 286, 17985, 1010, 70, 17914, 1007, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.52.1"],
Cell[26559, 1298, 180, 6, 70, "Output",
  CellTags->"S5.52.1"]
}, Open  ]],
Cell[26754, 1307, 621, 21, 70, "Text",
  CellTags->{"S5.52.1", "1.8"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

