(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    680153,      26694]*)
(*NotebookOutlinePosition[    975177,      35028]*)
(*  CellTagsIndexPosition[    899226,      32997]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Standard Packages", "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[TextData[{
  StyleBox["<<", "MR"],
  ", ",
  StyleBox["Get", "MR"],
  ", ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.1", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"<<"],

Cell[TextData[{
  StyleBox[".m", "MR"],
  " files, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.4", "4.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->".m files"],

Cell[TextData[{
  StyleBox[".mx", "MR"],
  " files, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.4", "4.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  "3\[Hyphen]Script, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["Abbreviation", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Abbreviation"],

Cell[TextData[{
  StyleBox["Abs", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Abs"],

Cell[TextData[{
  "Abscissa, in Gaussian quadrature, ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Abscissa"],

Cell[TextData[{
  "in Newton\[Hyphen]Cotes quadrature, ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Abscissa"],

Cell[TextData[{
  StyleBox["AbsIJK", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AbsIJK"],

Cell[TextData[{
  StyleBox["Absolute", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Absolute"],

Cell[TextData[{
  StyleBox["AccelerationDueToGravity", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AccelerationDueToGravity"],

Cell[TextData[{
  "Accuracy, in estimates, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Accuracy"],

Cell[TextData[{
  StyleBox["AccuracyGoal", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AccuracyGoal"],

Cell[TextData[{
  StyleBox["AcyclicQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.72"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AcyclicQ"],

Cell[TextData[{
  StyleBox["AddEdge", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.39"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AddEdge"],

Cell[TextData[{
  StyleBox["AddEdges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AddEdges"],

Cell[TextData[{
  StyleBox["AddVertex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AddVertex"],

Cell[TextData[{
  StyleBox["AddVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AddVertices"],

Cell[TextData[{
  "Adjacency lists, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Adjacency lists"],

Cell[TextData[{
  "Adjacency matrices, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Adjacency matrices"],

Cell[TextData[{
  StyleBox["AdjustedRSquared", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AdjustedRSquared"],

Cell[TextData[{
  StyleBox["AdjustedSignIJK", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AdjustedSignIJK"],

Cell[TextData[{
  StyleBox["AffineRationalize", "MR"],
  ", ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AffineRationalize"],

Cell[TextData[{
  StyleBox["AffineShape", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AffineShape"],

Cell[TextData[{
  StyleBox["AgeOfUniverse", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AgeOfUniverse"],

Cell[TextData[{
  StyleBox["Agglomerate", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"Agglomerate"],

Cell[TextData[{
  StyleBox["AirWavelength", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AirWavelength"],

Cell[TextData[{
  "Algebraic extension fields, ",
  ButtonBox["NumberTheory`PrimitiveElement`",
    ButtonData:>{"NumberTheory`PrimitiveElement`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Algebraic extension fields"],

Cell[TextData[{
  "Algebraic inequalities, ",
  ButtonBox["Algebra`AlgebraicInequalities`",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`InequalitySolve`",
    ButtonData:>{"Algebra`InequalitySolve`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Algebraic inequalities"],

Cell[TextData[{
  "Algebraic numbers, ",
  ButtonBox["NumberTheory`PrimitiveElement`",
    ButtonData:>{"NumberTheory`PrimitiveElement`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Algebraic numbers"],

Cell[TextData[{
  StyleBox["AlgebraicInequalities", "MR"],
  " package, ",
  ButtonBox["Algebra`AlgebraicInequalities`",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AlgebraicInequalities package"],

Cell[TextData[{
  StyleBox["Algorithm", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Algorithm"],

Cell[TextData[{
  "aliquot sequence, ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"aliquot sequence"],

Cell[TextData[{
  StyleBox["AliquotCycle", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AliquotCycle"],

Cell[TextData[{
  StyleBox["AliquotSequence", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AliquotSequence"],

Cell[TextData[{
  StyleBox["AllColors", "MR"],
  ", ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AllColors"],

Cell[TextData[{
  StyleBox["AllPairsShortestPath", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AllPairsShortestPath"],

Cell[TextData[{
  StyleBox["AllPoints", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AllPoints"],

Cell[TextData[{
  StyleBox["AlternatingGroup", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AlternatingGroup"],

Cell[TextData[{
  StyleBox["AlternatingGroupIndex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AlternatingGroupIndex"],

Cell[TextData[{
  StyleBox["AlternatingPaths", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AlternatingPaths"],

Cell[TextData[{
  StyleBox["ambientlight", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ambientlight 3-Script command"],

Cell[TextData[{
  StyleBox["AmplitudeModulation", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AmplitudeModulation"],

Cell[TextData[{
  StyleBox["Anagrams", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Dictionary`",
    ButtonData:>{"Miscellaneous`Dictionary`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Anagrams"],

Cell[TextData[{
  "Analysis of variance, ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Analysis of variance"],

Cell[TextData[{
  StyleBox["Animate", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Animate"],

Cell[TextData[{
  StyleBox["AnimateGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.58"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AnimateGraph"],

Cell[TextData[{
  "Animation, ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Animation"],

Cell[TextData[{
  StyleBox["Animation", "MR"],
  " package, ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Animation package"],

Cell[TextData[{
  StyleBox["Annotation", "MR"],
  ", ",
  ButtonBox["Utilities`Package`",
    ButtonData:>{"Utilities`Package`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Annotation"],

Cell[TextData[{
  StyleBox["ANOVA", "MR"],
  ", ",
  ButtonBox["Statistics`ANOVA`",
    ButtonData:>{"Statistics`ANOVA`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ANOVA"],

Cell[TextData[{
  StyleBox["ANOVATable", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ANOVATable"],

Cell[TextData[{
  StyleBox["AntiSymmetricQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AntiSymmetricQ"],

Cell[TextData[{
  StyleBox["AppendColumns", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AppendColumns"],

Cell[TextData[{
  StyleBox["AppendRows", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AppendRows"],

Cell[TextData[{
  StyleBox["Applications", "MR"],
  " directory, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Applications directory"],

Cell[TextData[{
  "Approximate numbers, ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Approximate numbers"],

Cell[TextData[{
  "Approximate polynomials, ",
  ButtonBox["NumberTheory`Recognize`",
    ButtonData:>{"NumberTheory`Recognize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Approximate polynomials"],

Cell[TextData[{
  StyleBox["ApproximateIntervals", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ApproximateIntervals"],

Cell[TextData[{
  StyleBox["ApproximateVertexCover", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ApproximateVertexCover"],

Cell[TextData[{
  "Approximation of functions, ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NSeries`",
    ButtonData:>{"NumericalMath`NSeries`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`TrigFit`",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Approximation of functions"],

Cell[TextData[{
  StyleBox["Approximations", "MR"],
  " package, ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Approximations package"],

Cell[TextData[{
  StyleBox["ArcLengthFactor", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ArcLengthFactor"],

Cell[TextData[{
  "Area, between curves, ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Area, between curves"],

Cell[TextData[{
  StyleBox["Area", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Area"],

Cell[TextData[{
  StyleBox["Arg", "MR"],
  ", ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Arg"],

Cell[TextData[{
  StyleBox["ArgColor", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ArgColor"],

Cell[TextData[{
  StyleBox["ArgColors", "MR"],
  " package, ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ArgColors package"],

Cell[TextData[{
  StyleBox["ArgShade", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ArgShade"],

Cell[TextData[{
  StyleBox["Arithmetic", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Arithmetic"],

Cell[TextData[{
  "Arithmetic parameters, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Arithmetic parameters"],

Cell[TextData[{
  StyleBox["Arrow", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Arrow"],

Cell[TextData[{
  StyleBox["Arrow", "MR"],
  " package, ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Arrow package"],

Cell[TextData[{
  StyleBox["ArticulationVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.66"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ArticulationVertices"],

Cell[TextData[{
  StyleBox["AssociationMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.57"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AssociationMatrix"],

Cell[TextData[{
  StyleBox["Assumptions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Assumptions"],

Cell[TextData[{
  StyleBox["AsymptoticCorrelationMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AsymptoticCorrelationMatrix"],

Cell[TextData[{
  StyleBox["AsymptoticCovarianceMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AsymptoticCovarianceMatrix"],

Cell[TextData[{
  "Atkin\[Hyphen]Morain primality certificate, ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Atkin-Morain primality certificate"],

Cell[TextData[{
  StyleBox["AtmosphericPlot", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AtmosphericPlot"],

Cell[TextData[{
  StyleBox["AtomicData", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AtomicData"],

Cell[TextData[{
  StyleBox["AtomicNumber", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AtomicNumber"],

Cell[TextData[{
  StyleBox["AtomicWeight", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AtomicWeight"],

Cell[TextData[{
  StyleBox["Audio", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Audio package"],

Cell[TextData[{
  StyleBox["Autoload", "MR"],
  " directory, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Autoload directory"],

Cell[TextData[{
  "Autoloading, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Autoloading"],

Cell[TextData[{
  StyleBox["Automorphisms", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Automorphisms"],

Cell[TextData[{
  StyleBox["AvogadroConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AvogadroConstant"],

Cell[TextData[{
  "Axes, tick marks on, ",
  StyleBox["Ticks", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Axes"],

Cell[TextData[{
  StyleBox["AxesFront", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"AxesFront"],

Cell[TextData[{
  StyleBox["Axis", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["B", "MR"],
  ", ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"B"],

Cell[TextData[{
  StyleBox["Back", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Back"],

Cell[TextData[{
  "Back substitution, ",
  ButtonBox["LinearAlgebra`Tridiagonal`",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Back substitution"],

Cell[TextData[{
  StyleBox["Backtrack", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Backtrack"],

Cell[TextData[{
  StyleBox["BarChart", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarChart"],

Cell[TextData[{
  StyleBox["BarChart3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarChart3D"],

Cell[TextData[{
  StyleBox["BarEdges", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarEdges"],

Cell[TextData[{
  StyleBox["BarEdgeStyle", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarEdgeStyle"],

Cell[TextData[{
  StyleBox["BarGroupSpacing", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarGroupSpacing"],

Cell[TextData[{
  StyleBox["BarLabels", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarLabels"],

Cell[TextData[{
  StyleBox["BarOrientation", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarOrientation"],

Cell[TextData[{
  StyleBox["BarSpacing", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarSpacing"],

Cell[TextData[{
  StyleBox["BarStyle", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarStyle"],

Cell[TextData[{
  StyleBox["BarValues", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BarValues"],

Cell[TextData[{
  "Basis vectors, ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Basis vectors"],

Cell[TextData[{
  StyleBox["BasisNames", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BasisNames"],

Cell[TextData[{
  StyleBox["Begin", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Begin"],

Cell[TextData[{
  StyleBox["BeginPackage", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BeginPackage"],

Cell[TextData[{
  StyleBox["BellB", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BellB"],

Cell[TextData[{
  StyleBox["BellmanFord", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BellmanFord"],

Cell[TextData[{
  StyleBox["Benchmark", "MR"],
  ", ",
  ButtonBox["Utilities`Benchmark`",
    ButtonData:>{"Utilities`Benchmark`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Benchmark"],

Cell[TextData[{
  StyleBox["BernoulliDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BernoulliDistribution"],

Cell[TextData[{
  "Bessel function zeros, ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bessel function zeros"],

Cell[TextData[{
  StyleBox["BesselJ", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJ"],

Cell[TextData[{
  StyleBox["BesselJPrimeYJYPrimeZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJPrimeYJYPrimeZeros"],

Cell[TextData[{
  StyleBox["BesselJPrimeYJYPrimeZerosInterval", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJPrimeYJYPrimeZerosInterval"],

Cell[TextData[{
  StyleBox["BesselJPrimeYPrimeJPrimeYPrimeZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJPrimeYPrimeJPrimeYPrimeZeros"],

Cell[TextData[{
  StyleBox["BesselJPrimeYPrimeJPrimeYPrimeZerosInterval", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJPrimeYPrimeJPrimeYPrimeZerosInterval"],

Cell[TextData[{
  StyleBox["BesselJPrimeZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJPrimeZeros"],

Cell[TextData[{
  StyleBox["BesselJPrimeZerosInterval", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJPrimeZerosInterval"],

Cell[TextData[{
  StyleBox["BesselJYJYPrimeZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJYJYPrimeZeros"],

Cell[TextData[{
  StyleBox["BesselJYJYPrimeZerosInterval", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJYJYPrimeZerosInterval"],

Cell[TextData[{
  StyleBox["BesselJZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJZeros"],

Cell[TextData[{
  StyleBox["BesselJZerosInterval", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselJZerosInterval"],

Cell[TextData[{
  StyleBox["BesselY", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselY"],

Cell[TextData[{
  StyleBox["BesselYPrimeZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselYPrimeZeros"],

Cell[TextData[{
  StyleBox["BesselYPrimeZerosInterval", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselYPrimeZerosInterval"],

Cell[TextData[{
  StyleBox["BesselYZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselYZeros"],

Cell[TextData[{
  StyleBox["BesselYZerosInterval", "MR"],
  ", ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselYZerosInterval"],

Cell[TextData[{
  StyleBox["BesselZeros", "MR"],
  " package, ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BesselZeros package"],

Cell[TextData[{
  StyleBox["BestFit", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BestFit"],

Cell[TextData[{
  StyleBox["BestFitParameters", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BestFitParameters"],

Cell[TextData[{
  StyleBox["BestFitParametersDelta", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BestFitParametersDelta"],

Cell[TextData[{
  StyleBox["BetaDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BetaDistribution"],

Cell[TextData[{
  StyleBox["Bezier", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`SplineFit`",
    ButtonData:>{"NumericalMath`SplineFit`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bezier"],

Cell[TextData[{
  "Bezier curves, ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`SplineFit`",
    ButtonData:>{"NumericalMath`SplineFit`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bezier curves"],

Cell[TextData[{
  StyleBox["Bias", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bias"],

Cell[TextData[{
  StyleBox["BiconnectedComponents", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.65"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BiconnectedComponents"],

Cell[TextData[{
  StyleBox["BiconnectedQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BiconnectedQ"],

Cell[TextData[{
  StyleBox["Biharmonic", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Biharmonic"],

Cell[TextData[{
  "Binary Gray code, ",
  StyleBox["GrayCode", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Binary Gray code"],

Cell[TextData[{
  "Binary quadratic forms, equivalence classes, ",
  StyleBox["ClassList", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Binary quadratic forms"],

Cell[TextData[{
  "number of equivalence classes, ",
  StyleBox["ClassNumber", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Binary quadratic forms"],

Cell[TextData[{
  "Binary trees, ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Binary trees"],

Cell[TextData[{
  StyleBox["BinarySearch", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BinarySearch"],

Cell[TextData[{
  StyleBox["BinarySubsets", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BinarySubsets"],

Cell[TextData[{
  StyleBox["BinCounts", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BinCounts"],

Cell[TextData[{
  StyleBox["BinLists", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BinLists"],

Cell[TextData[{
  StyleBox["Binomial", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Binomial"],

Cell[TextData[{
  StyleBox["BinomialDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BinomialDistribution"],

Cell[TextData[{
  StyleBox["BipartiteMatching", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.89"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BipartiteMatching"],

Cell[TextData[{
  StyleBox["BipartiteMatchingAndCover", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BipartiteMatchingAndCover"],

Cell[TextData[{
  StyleBox["BipartiteQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BipartiteQ"],

Cell[TextData[{
  StyleBox["Bipolar", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bipolar"],

Cell[TextData[{
  StyleBox["Bispherical", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bispherical"],

Cell[TextData[{
  "Bivariate statistical distributions, ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bivariate statistical distributions"],

Cell[TextData[{
  StyleBox["BlackBodyProfile", "MR"],
  ", ",
  ButtonBox["Miscellaneous`BlackBodyRadiation`",
    ButtonData:>{"Miscellaneous`BlackBodyRadiation`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BlackBodyProfile"],

Cell[TextData[{
  StyleBox["BlackBodyRadiation", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`BlackBodyRadiation`",
    ButtonData:>{"Miscellaneous`BlackBodyRadiation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BlackBodyRadiation package"],

Cell[TextData[{
  StyleBox["BlockMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BlockMatrix"],

Cell[TextData[{
  StyleBox["BohrRadius", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BohrRadius"],

Cell[TextData[{
  StyleBox["BoilingPoint", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoilingPoint"],

Cell[TextData[{
  StyleBox["BoltzmannConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoltzmannConstant"],

Cell[TextData[{
  StyleBox["Bonferroni", "MR"],
  ", ",
  ButtonBox["Statistics`ANOVA`",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bonferroni"],

Cell[TextData[{
  StyleBox["BooleanAlgebra", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BooleanAlgebra"],

Cell[TextData[{
  StyleBox["BoundedDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.44"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoundedDiagram"],

Cell[TextData[{
  StyleBox["boundingbox", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"boundingbox 3-Script command"],

Cell[TextData[{
  StyleBox["Box", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Box"],

Cell[TextData[{
  "Box plot, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Box plot"],

Cell[TextData[{
  "Boxes, with shadows, ",
  StyleBox["ShadowBox", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Boxes"],

Cell[TextData[{
  StyleBox["BoxExtraSpacing", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxExtraSpacing"],

Cell[TextData[{
  StyleBox["BoxLabels", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxLabels"],

Cell[TextData[{
  StyleBox["BoxLineStyle", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxLineStyle"],

Cell[TextData[{
  StyleBox["BoxMedianStyle", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxMedianStyle"],

Cell[TextData[{
  StyleBox["BoxOrientation", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxOrientation"],

Cell[TextData[{
  StyleBox["BoxOutliers", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxOutliers"],

Cell[TextData[{
  StyleBox["BoxOutlierShapes", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxOutlierShapes"],

Cell[TextData[{
  StyleBox["BoxQuantile", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxQuantile"],

Cell[TextData[{
  StyleBox["BoxStyle", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxStyle"],

Cell[TextData[{
  StyleBox["BoxWhiskerPlot", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BoxWhiskerPlot"],

Cell[TextData[{
  StyleBox["Brake", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Brake"],

Cell[TextData[{
  StyleBox["BrayCurtisDistance", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"BrayCurtisDistance"],

Cell[TextData[{
  "Branch cuts, ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Branch cuts"],

Cell[TextData[{
  "Breadth\[Hyphen]first search, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Breadth-first search"],

Cell[TextData[{
  StyleBox["BreadthFirstTraversal", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BreadthFirstTraversal"],

Cell[TextData[{
  StyleBox["Brelaz", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Brelaz"],

Cell[TextData[{
  StyleBox["BrelazColoring", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"BrelazColoring"],

Cell[TextData[{
  StyleBox["Bridges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.67"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Bridges"],

Cell[TextData[{
  "Business graphics, ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Business graphics"],

Cell[TextData[{
  StyleBox["Butcher", "MR"],
  " package, ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Butcher package"],

Cell[TextData[{
  "Butcher trees, drawing of, ",
  StyleBox["ButcherPlot", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Butcher trees"],

Cell[TextData[{
  StyleBox["ButcherTrees", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " \n",
  StyleBox["ButcherTreeSimplify", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Butcher trees"],

Cell[TextData[{
  StyleBox["ButcherAlpha", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherAlpha"],

Cell[TextData[{
  StyleBox["ButcherBeta", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherBeta"],

Cell[TextData[{
  StyleBox["ButcherBetaBar", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherBetaBar"],

Cell[TextData[{
  StyleBox["ButcherColumnConditions", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherColumnConditions"],

Cell[TextData[{
  StyleBox["ButcherGamma", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherGamma"],

Cell[TextData[{
  StyleBox["ButcherHeight", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherHeight"],

Cell[TextData[{
  StyleBox["ButcherOrder", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherOrder"],

Cell[TextData[{
  StyleBox["ButcherPhi", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherPhi"],

Cell[TextData[{
  StyleBox["ButcherPlot", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherPlot"],

Cell[TextData[{
  StyleBox["ButcherPlotColumns", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherPlotColumns"],

Cell[TextData[{
  StyleBox["ButcherPlotLabel", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherPlotLabel"],

Cell[TextData[{
  StyleBox["ButcherPlotNodeSize", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherPlotNodeSize"],

Cell[TextData[{
  StyleBox["ButcherPlotRootSize", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherPlotRootSize"],

Cell[TextData[{
  StyleBox["ButcherPrincipalError", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherPrincipalError"],

Cell[TextData[{
  StyleBox["ButcherQuadratureConditions", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherQuadratureConditions"],

Cell[TextData[{
  StyleBox["ButcherRowConditions", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherRowConditions"],

Cell[TextData[{
  StyleBox["ButcherSigma", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherSigma"],

Cell[TextData[{
  StyleBox["ButcherTreeCount", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherTreeCount"],

Cell[TextData[{
  StyleBox["ButcherTreeQ", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherTreeQ"],

Cell[TextData[{
  StyleBox["ButcherTrees", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherTrees"],

Cell[TextData[{
  StyleBox["ButcherTreeSimplify", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherTreeSimplify"],

Cell[TextData[{
  StyleBox["ButcherWidth", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButcherWidth"],

Cell[TextData[{
  StyleBox["ButterflyGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ButterflyGraph"],

Cell[TextData[{
  StyleBox["CageGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CageGraph"],

Cell[TextData[{
  "Calculus, in three dimensions, ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Calculus"],

Cell[TextData[{
  "Calculus of variations, ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Calculus of variations"],

Cell[TextData[{
  StyleBox["Calendar", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Calendar"],

Cell[TextData[{
  StyleBox["Calendar", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Calendar package"],

Cell[TextData[{
  StyleBox["CalendarChange", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CalendarChange"],

Cell[TextData[{
  "Calendars, converting between, ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Calendars"],

Cell[TextData[{
  StyleBox["CanberraDistance", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"CanberraDistance"],

Cell[TextData[{
  StyleBox["Cartesian", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cartesian"],

Cell[TextData[{
  StyleBox["CartesianMap", "MR"],
  ", ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CartesianMap"],

Cell[TextData[{
  StyleBox["CartesianProduct", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CartesianProduct"],

Cell[TextData[{
  "Cartography, ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cartography"],

Cell[TextData[{
  StyleBox["Cascade", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cascade"],

Cell[TextData[{
  StyleBox["CatalanNumber", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CatalanNumber"],

Cell[TextData[{
  StyleBox["CatcherMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CatcherMatrix"],

Cell[TextData[{
  StyleBox["CategoryCounts", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CategoryCounts"],

Cell[TextData[{
  StyleBox["CategoryLists", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CategoryLists"],

Cell[TextData[{
  "Cauchy distribution, multivariate, ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cauchy distribution"],

Cell[TextData[{
  "Cauchy principal value, ",
  ButtonBox["NumericalMath`CauchyPrincipalValue`",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cauchy principal value"],

Cell[TextData[{
  "Cauchy\[CloseCurlyQuote]s integral formula, ",
  ButtonBox["NumericalMath`NSeries`",
    ButtonData:>{"NumericalMath`NSeries`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cauchy's integral formula"],

Cell[TextData[{
  StyleBox["CauchyDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CauchyDistribution"],

Cell[TextData[{
  StyleBox["CauchyPrincipalValue", "MR"],
  ", ",
  ButtonBox["NumericalMath`CauchyPrincipalValue`",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CauchyPrincipalValue"],

Cell[TextData[{
  StyleBox["CauchyPrincipalValue", "MR"],
  " package, ",
  ButtonBox["NumericalMath`CauchyPrincipalValue`",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CauchyPrincipalValue package"],

Cell[TextData[{
  StyleBox["CDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CDF"],

Cell[TextData[{
  StyleBox["CellMeans", "MR"],
  ", ",
  ButtonBox["Statistics`ANOVA`",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CellMeans"],

Cell[TextData[{
  StyleBox["Center", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Center"],

Cell[TextData[{
  "Central limit theorem, ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Central limit theorem"],

Cell[TextData[{
  StyleBox["CentralMoment", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CentralMoment"],

Cell[TextData[{
  StyleBox["CentsToHertz", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CentsToHertz"],

Cell[TextData[{
  StyleBox["Certificate", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Certificate"],

Cell[TextData[{
  "Certificate of primality, ",
  StyleBox["PrimeQCertificate", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Certificate of primality"],

Cell[TextData[{
  "Certificate of primality checking, ",
  StyleBox["PrimeQCertificateCheck", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Certificate of primality checking"],

Cell[TextData[{
  StyleBox["CGS", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CGS"],

Cell[TextData[{
  StyleBox["ChangeEdges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChangeEdges"],

Cell[TextData[{
  StyleBox["ChangeVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChangeVertices"],

Cell[TextData[{
  "Chaotic behavior, ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Chaotic behavior"],

Cell[TextData[{
  StyleBox["Characteristic", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Characteristic"],

Cell[TextData[{
  StyleBox["CharacteristicFunction", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CharacteristicFunction"],

Cell[TextData[{
  "Charts, histogram, ",
  StyleBox["Histogram", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Charts"],

Cell[TextData[{
  "histogram, ",
  StyleBox["Histogram3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.25"},
    ButtonStyle->"AddOnsLink"],
  " \npie, ",
  StyleBox["PieChart", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \nthree\[Hyphen]dimensional bar, ",
  StyleBox["BarChart3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntwo\[Hyphen]dimensional bar, ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Charts"],

Cell[TextData[{
  "Chebyshev approximation, ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Chebyshev approximation"],

Cell[TextData[{
  "Chemical elements, ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Chemical elements"],

Cell[TextData[{
  StyleBox["ChemicalElements", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChemicalElements package"],

Cell[TextData[{
  "Chi\[Hyphen]square(d), minimization of, ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`TrigFit`",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Chi-square(d)"],

Cell[TextData[{
  "Chi\[Hyphen]square(d) distribution, ",
  StyleBox["ChiSquareDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Chi-square(d) distribution"],

Cell[TextData[{
  "noncentral, ",
  StyleBox["NoncentralChiSquareDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " \np\[Hyphen]value, ",
  StyleBox["ChiSquarePValue", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Chi-square(d) distribution"],

Cell[TextData[{
  StyleBox["ChiDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChiDistribution"],

Cell[TextData[{
  StyleBox["ChineseRemainder", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChineseRemainder"],

Cell[TextData[{
  StyleBox["ChiSquareCI", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChiSquareCI"],

Cell[TextData[{
  StyleBox["ChiSquareDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChiSquareDistribution"],

Cell[TextData[{
  StyleBox["ChiSquarePValue", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChiSquarePValue"],

Cell[TextData[{
  StyleBox["Cholesky", "MR"],
  " package, ",
  ButtonBox["Appendix: Functions Moved to the Kernel",
    ButtonData:>{"6.17.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cholesky package"],

Cell[TextData[{
  StyleBox["ChromaticNumber", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChromaticNumber"],

Cell[TextData[{
  StyleBox["ChromaticPolynomial", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChromaticPolynomial"],

Cell[TextData[{
  StyleBox["ChvatalGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ChvatalGraph"],

Cell[TextData[{
  "Circle, circumscribed, ",
  StyleBox["CircumscribedRadius", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Circle"],

Cell[TextData[{
  "inscribed, ",
  StyleBox["InscribedRadius", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Circle"],

Cell[TextData[{
  StyleBox["Circle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Circle"],

Cell[TextData[{
  StyleBox["CirculantGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.56"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CirculantGraph"],

Cell[TextData[{
  StyleBox["CircularEmbedding", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CircularEmbedding"],

Cell[TextData[{
  StyleBox["CircumscribedRadius", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CircumscribedRadius"],

Cell[TextData[{
  StyleBox["CityData", "MR"],
  ", ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CityData"],

Cell[TextData[{
  StyleBox["CityData", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CityData package"],

Cell[TextData[{
  StyleBox["CityDistance", "MR"],
  ", ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CityDistance"],

Cell[TextData[{
  StyleBox["CityDistanceMethod", "MR"],
  ", ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CityDistanceMethod"],

Cell[TextData[{
  StyleBox["CityPosition", "MR"],
  ", ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CityPosition"],

Cell[TextData[{
  StyleBox["ClassicalElectronRadius", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ClassicalElectronRadius"],

Cell[TextData[{
  StyleBox["ClassList", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ClassList"],

Cell[TextData[{
  StyleBox["ClassNumber", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ClassNumber"],

Cell[TextData[{
  StyleBox["CliqueQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CliqueQ"],

Cell[TextData[{
  StyleBox["Cluster", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"Cluster"],

Cell[TextData[{
  StyleBox["ClusterAnalysis", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ClusterAnalysis"],

Cell[TextData[{
  StyleBox["ClusterFlatten", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"ClusterFlatten"],

Cell[TextData[{
  StyleBox["ClusterSplit", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"ClusterSplit"],

Cell[TextData[{
  "Cliques, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.43"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cliques"],

Cell[TextData[{
  StyleBox["CMYColor", "MR"],
  ", ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CMYColor"],

Cell[TextData[{
  StyleBox["CMYKColor", "MR"],
  ", ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CMYKColor"],

Cell[TextData[{
  StyleBox["CoarserSetPartitionQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CoarserSetPartitionQ"],

Cell[TextData[{
  "Code, binary, ",
  StyleBox["GrayCode", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Code"],

Cell[TextData[{
  StyleBox["CodeToLabeledTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CodeToLabeledTree"],

Cell[TextData[{
  StyleBox["CoefficientOfVariation", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CoefficientOfVariation"],

Cell[TextData[{
  "Coefficients, Fourier, ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Coefficients"],

Cell[TextData[{
  StyleBox["Cofactor", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cofactor"],

Cell[TextData[{
  StyleBox["CollisionFrequency", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CollisionFrequency"],

Cell[TextData[{
  "Color, of graphics, ",
  StyleBox["Hue", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Color"],

Cell[TextData[{
  "specification of, ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Color"],

Cell[TextData[{
  StyleBox["color", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"color 3-Script command"],

Cell[TextData[{
  StyleBox["ColorCircle", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ColorCircle"],

Cell[TextData[{
  StyleBox["ColorFunction", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ColorFunction"],

Cell[TextData[{
  StyleBox["colormesh", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"colormesh 3-Script command"],

Cell[TextData[{
  StyleBox["Colors", "MR"],
  " package, ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Colors package"],

Cell[TextData[{
  StyleBox["Column", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Column"],

Cell[TextData[{
  StyleBox["ColumnDrop", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ColumnDrop"],

Cell[TextData[{
  StyleBox["ColumnJoin", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ColumnJoin"],

Cell[TextData[{
  StyleBox["ColumnTake", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ColumnTake"],

Cell[TextData[{
  "Combinations, construction of, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Combinations"],

Cell[TextData[{
  StyleBox["CombinatorialFunctions", "MR"],
  " package, ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CombinatorialFunctions package"],

Cell[TextData[{
  StyleBox["Combinatorica", "MR"],
  " package, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Combinatorica package"],

Cell[TextData[{
  "Common ",
  StyleBox["Graphics", "MR"],
  " package, ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Common Graphics package"],

Cell[TextData[{
  "Common ",
  StyleBox["Statistics", "MR"],
  " packages, ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Common Statistics packages"],

Cell[TextData[{
  "Complete integrals, parameters of, ",
  StyleBox["B", "MR"],
  ", ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Complete integrals"],

Cell[TextData[{
  StyleBox["CompleteBinaryTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CompleteBinaryTree"],

Cell[TextData[{
  StyleBox["CompleteGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CompleteGraph"],

Cell[TextData[{
  StyleBox["CompleteIntegral", "MR"],
  ", ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CompleteIntegral"],

Cell[TextData[{
  StyleBox["CompleteKaryTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CompleteKaryTree"],

Cell[TextData[{
  StyleBox["CompleteKPartiteGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CompleteKPartiteGraph"],

Cell[TextData[{
  StyleBox["CompleteQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CompleteQ"],

Cell[TextData[{
  "Complex multiplication, ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Complex multiplication"],

Cell[TextData[{
  "Complex numbers, ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Complex numbers"],

Cell[TextData[{
  "functions of, ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Complex numbers"],

Cell[TextData[{
  StyleBox["ComplexExpand", "MR"],
  ", ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ComplexExpand"],

Cell[TextData[{
  StyleBox["ComplexInequalityPlot", "MR"],
  ", ",
  ButtonBox["Graphics`InequalityGraphics`",
    ButtonData:>{"Graphics`InequalityGraphics`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ComplexInequalityPlot"],

Cell[TextData[{
  StyleBox["ComplexMap", "MR"],
  " package, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ComplexMap package"],

Cell[TextData[{
  StyleBox["ComplexRootIntervals", "MR"],
  ", ",
  ButtonBox["Algebra`RootIsolation`",
    ButtonData:>{"Algebra`RootIsolation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ComplexRootIntervals"],

Cell[TextData[{
  StyleBox["CompositeBezier", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`SplineFit`",
    ButtonData:>{"NumericalMath`SplineFit`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CompositeBezier"],

Cell[TextData[{
  "Compositions, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Compositions"],

Cell[TextData[{
  StyleBox["Compositions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Compositions"],

Cell[TextData[{
  "Computational geometry, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Computational geometry"],

Cell[TextData[{
  StyleBox["ComputationalGeometry", "MR"],
  " package, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ComputationalGeometry package"],

Cell[TextData[{
  "Computer arithmetic, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Computer arithmetic"],

Cell[TextData[{
  StyleBox["ComputerArithmetic", "MR"],
  " package, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ComputerArithmetic package"],

Cell[TextData[{
  StyleBox["ComputerNumber", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ComputerNumber"],

Cell[TextData[{
  "Condition number, ",
  StyleBox["MatrixConditionNumber", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Condition number"],

Cell[TextData[{
  "Conductivity, thermal, ",
  StyleBox["ThermalConductivity", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Conductivity"],

Cell[TextData[{
  StyleBox["Cone", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cone"],

Cell[TextData[{
  "Confidence interval, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Confidence interval"],

Cell[TextData[{
  "Confidence level, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Confidence level"],

Cell[TextData[{
  StyleBox["ConfidenceIntervals", "MR"],
  " package, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConfidenceIntervals package"],

Cell[TextData[{
  StyleBox["ConfidenceLevel", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConfidenceLevel"],

Cell[TextData[{
  "Configuration, electron, ",
  StyleBox["ElectronConfiguration", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Configuration"],

Cell[TextData[{
  StyleBox["ConfocalEllipsoidal", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConfocalEllipsoidal"],

Cell[TextData[{
  StyleBox["ConfocalParaboloidal", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConfocalParaboloidal"],

Cell[TextData[{
  "Congruences, simultaneous, ",
  StyleBox["ChineseRemainder", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Congruences"],

Cell[TextData[{
  StyleBox["Conical", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Conical"],

Cell[TextData[{
  StyleBox["Conjugate", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Conjugate"],

Cell[TextData[{
  StyleBox["ConnectedComponents", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.63"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConnectedComponents"],

Cell[TextData[{
  StyleBox["ConnectedQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConnectedQ"],

Cell[TextData[{
  "Constants, physical, ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Constants"],

Cell[TextData[{
  "Constants of motion, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Constants of motion"],

Cell[TextData[{
  StyleBox["ConstructTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConstructTableau"],

Cell[TextData[{
  "Context, current, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Context"],

Cell[TextData[{
  "Context search path, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Context search path"],

Cell[TextData[{
  "Contexts, hierarchical, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Contexts"],

Cell[TextData[{
  "in packages, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Contexts"],

Cell[TextData[{
  "Continued fractions, ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Continued fractions"],

Cell[TextData[{
  StyleBox["ContinuedFractionForm", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContinuedFractionForm"],

Cell[TextData[{
  StyleBox["ContinuedFractions", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContinuedFractions"],

Cell[TextData[{
  StyleBox["ContinuedFractions", "MR"],
  " package, ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContinuedFractions package"],

Cell[TextData[{
  StyleBox["ContinuousDistributions", "MR"],
  " package, ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContinuousDistributions package"],

Cell[TextData[{
  StyleBox["ContourPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContourPlot3D"],

Cell[TextData[{
  StyleBox["ContourPlot3D", "MR"],
  " package, ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContourPlot3D package"],

Cell[TextData[{
  StyleBox["Contours", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Contours"],

Cell[TextData[{
  StyleBox["ContourStyle", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContourStyle"],

Cell[TextData[{
  StyleBox["Contract", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.44"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Contract"],

Cell[TextData[{
  StyleBox["ContractInterval", "MR"],
  ", ",
  ButtonBox["Algebra`RootIsolation`",
    ButtonData:>{"Algebra`RootIsolation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ContractInterval"],

Cell[TextData[{
  StyleBox["Convergents", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Convergents"],

Cell[TextData[{
  "Conversion, to adjacency lists, ",
  StyleBox["ToAdjacencyLists", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Conversion"],

Cell[TextData[{
  "to ordered pairs, ",
  StyleBox["ToOrderedPairs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " \nbetween calendars, ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nbetween color models, ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nbetween temperature scales, ",
  StyleBox["ConvertTemperature", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nbetween units, ",
  StyleBox["Convert", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nfrom Cartesian coordinates, ",
  StyleBox["CoordinatesFromCartesian", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " \nfrom geodetic coordinates to authalic coordinates, ",
  StyleBox["GeodeticToAuthalic", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " \nfrom permutation to cyclic decomposition, ",
  StyleBox["ToCycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " \nto authalic radius, ",
  StyleBox["ToAuthalicRadius", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " \nto bytes, ",
  StyleBox["ToBytes", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " \nto cents, ",
  StyleBox["HertzToCents", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " \nto CGS units, ",
  StyleBox["CGS", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " \nto computer number, ",
  StyleBox["ComputerNumber", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nto degree\[Hyphen]minute\[Hyphen]second format, ",
  StyleBox["ToDMS", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " \nto degrees, ",
  StyleBox["ToDegrees", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " \nto Hertz, ",
  StyleBox["CentsToHertz", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " \nto minutes, ",
  StyleBox["ToMinutes", "MR"],
  ", ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  " \nto MKS units, ",
  StyleBox["MKS", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " \nto SI units, ",
  StyleBox["SI", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Conversion"],

Cell[TextData[{
  StyleBox["Convert", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Convert"],

Cell[TextData[{
  StyleBox["ConvertTemperature", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConvertTemperature"],

Cell[TextData[{
  StyleBox["ConvexHull", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConvexHull"],

Cell[TextData[{
  StyleBox["ConvexHullArea", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConvexHullArea"],

Cell[TextData[{
  StyleBox["ConvexHullMedian", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ConvexHullMedian"],

Cell[TextData[{
  StyleBox["CookD", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CookD"],

Cell[TextData[{
  "Coordinate systems, Cartesian, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Coordinate systems"],

Cell[TextData[{
  "cylindrical, ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nin three dimensions, ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \npolar, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " \nspherical, ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Coordinate systems"],

Cell[TextData[{
  "Coordinate transformations, in three dimensions, ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Coordinate transformations"],

Cell[TextData[{
  StyleBox["CoordinateRanges", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CoordinateRanges"],

Cell[TextData[{
  StyleBox["Coordinates", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Coordinates"],

Cell[TextData[{
  StyleBox["CoordinatesFromCartesian", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CoordinatesFromCartesian"],

Cell[TextData[{
  StyleBox["CoordinatesToCartesian", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CoordinatesToCartesian"],

Cell[TextData[{
  StyleBox["CoordinateSystem", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CoordinateSystem"],

Cell[TextData[{
  "Coprime, ",
  StyleBox["GCD", "MR"],
  ", ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.8", "8.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Coprime"],

Cell[TextData[{
  StyleBox["Correlation", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.52"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Correlation"],

Cell[TextData[{
  StyleBox["CorrelationDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"CorrelationDissimilarity"],

Cell[TextData[{
  StyleBox["CorrelationMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.57"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CorrelationMatrix"],

Cell[TextData[{
  StyleBox["CosineAngleDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"CosineAngleDissimilarity"],

Cell[TextData[{
  StyleBox["CosmicBackgroundTemperature", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CosmicBackgroundTemperature"],

Cell[TextData[{
  StyleBox["CostOfPath", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CostOfPath"],

Cell[TextData[{
  StyleBox["CountRoots", "MR"],
  ", ",
  ButtonBox["Algebra`RootIsolation`",
    ButtonData:>{"Algebra`RootIsolation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CountRoots"],

Cell[TextData[{
  StyleBox["Covariance", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Covariance"],

Cell[TextData[{
  StyleBox["CovarianceMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CovarianceMatrix"],

Cell[TextData[{
  StyleBox["CovarianceMatrixDetRatio", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CovarianceMatrixDetRatio"],

Cell[TextData[{
  StyleBox["CovarianceMatrixMLE", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CovarianceMatrixMLE"],

Cell[TextData[{
  StyleBox["CovarianceMatrixOfSampleMean", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CovarianceMatrixOfSampleMean"],

Cell[TextData[{
  StyleBox["CovarianceMLE", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CovarianceMLE"],

Cell[TextData[{
  StyleBox["CoxeterGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CoxeterGraph"],

Cell[TextData[{
  "Cross product, in various coordinate systems, ",
  StyleBox["CrossProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cross product"],

Cell[TextData[{
  StyleBox["CrossProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CrossProduct"],

Cell[TextData[{
  StyleBox["Cube", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cube"],

Cell[TextData[{
  StyleBox["CubeConnectedCycle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CubeConnectedCycle"],

Cell[TextData[{
  StyleBox["Cubic", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`SplineFit`",
    ButtonData:>{"NumericalMath`SplineFit`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cubic"],

Cell[TextData[{
  StyleBox["CubicalGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CubicalGraph"],

Cell[TextData[{
  StyleBox["Cuboid", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cuboid"],

Cell[TextData[{
  "Cumulative distribution function, ",
  StyleBox["CDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cumulative distribution function"],

Cell[TextData[{
  StyleBox["CumulativeSums", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CumulativeSums"],

Cell[TextData[{
  StyleBox["Curl", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Curl"],

Cell[TextData[{
  "Curve, Bezier, ",
  StyleBox["Bezier", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Curve"],

Cell[TextData[{
  "composite Bezier, ",
  StyleBox["CompositeBezier", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ncubic, ",
  StyleBox["Cubic", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Curve"],

Cell[TextData[{
  "Curve fitting, ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`TrigFit`",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Curve fitting"],

Cell[TextData[{
  StyleBox["CurveCountLimit", "MR"],
  ", ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CurveCountLimit"],

Cell[TextData[{
  StyleBox["CurveNumber", "MR"],
  ", ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CurveNumber"],

Cell[TextData[{
  "Curves, fitting of, ",
  StyleBox["SplineFit", "MR"],
  ", ",
  ButtonBox["NumericalMath`SplineFit`",
    ButtonData:>{"NumericalMath`SplineFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Curves"],

Cell[TextData[{
  "rotating about an axis, ",
  ButtonBox["Graphics`SurfaceOfRevolution`",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Curves"],

Cell[TextData[{
  StyleBox["Curves", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Curves"],

Cell[TextData[{
  "Curvilinear coordinates, ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Curvilinear coordinates"],

Cell[TextData[{
  StyleBox["Cycle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cycle"],

Cell[TextData[{
  StyleBox["CycleIndex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CycleIndex"],

Cell[TextData[{
  StyleBox["Cycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cycles"],

Cell[TextData[{
  StyleBox["CycleStructure", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CycleStructure"],

Cell[TextData[{
  StyleBox["Cyclic", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cyclic"],

Cell[TextData[{
  StyleBox["CyclicGroup", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CyclicGroup"],

Cell[TextData[{
  StyleBox["CyclicGroupIndex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"CyclicGroupIndex"],

Cell[TextData[{
  StyleBox["Cylinder", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cylinder"],

Cell[TextData[{
  StyleBox["Cylindrical", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Cylindrical"],

Cell[TextData[{
  StyleBox["CylindricalPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["D", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"D"],

Cell[TextData[{
  StyleBox["DampingConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DampingConstant"],

Cell[TextData[{
  StyleBox["Dash", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dash"],

Cell[TextData[{
  "Data, chemical element, ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Data"],

Cell[TextData[{
  "city, ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nmanipulation of statistical, ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nnormally distributed, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " \nperiodic table, ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nphysical constants, ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nplotting, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \ntransformation of, ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.72"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Data"],

Cell[TextData[{
  "Databases, geographical, ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Databases"],

Cell[TextData[{
  StyleBox["DataManipulation", "MR"],
  " package, ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DataManipulation package"],

Cell[TextData[{
  StyleBox["DataSmoothing", "MR"],
  " package, ",
  ButtonBox["Statistics`DataSmoothing`",
    ButtonData:>{"Statistics`DataSmoothing`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DataSmoothing package"],

Cell[TextData[{
  "Dates, conversions of, ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dates"],

Cell[TextData[{
  StyleBox["DayOfWeek", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DayOfWeek"],

Cell[TextData[{
  StyleBox["DaysBetween", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DaysBetween"],

Cell[TextData[{
  StyleBox["DaysPlus", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DaysPlus"],

Cell[TextData[{
  "de Moivre number, ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"de Moivre number"],

Cell[TextData[{
  StyleBox["DeBruijnGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.57"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeBruijnGraph"],

Cell[TextData[{
  StyleBox["DeBruijnSequence", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeBruijnSequence"],

Cell[TextData[{
  StyleBox["Decagon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Decagon"],

Cell[TextData[{
  "Decimal expansions, ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Decimal expansions"],

Cell[TextData[{
  StyleBox["DeclarePackage", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeclarePackage"],

Cell[TextData[{
  "Declaring types of numbers, ",
  StyleBox["RealValued", "MR"],
  ", ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Declaring types of numbers"],

Cell[TextData[{
  StyleBox["Decorrelate", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Decorrelate"],

Cell[TextData[{
  StyleBox["Degrees", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Degrees"],

Cell[TextData[{
  StyleBox["DegreeSequence", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DegreeSequence"],

Cell[TextData[{
  StyleBox["DegreesOf2Neighborhood", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DegreesOf2Neighborhood"],

Cell[TextData[{
  StyleBox["DelaunayTriangulation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DelaunayTriangulation"],

Cell[TextData[{
  StyleBox["DelaunayTriangulationQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DelaunayTriangulationQ"],

Cell[TextData[{
  StyleBox["DeleteCycle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeleteCycle"],

Cell[TextData[{
  StyleBox["DeleteEdge", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeleteEdge"],

Cell[TextData[{
  StyleBox["DeleteEdges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeleteEdges"],

Cell[TextData[{
  StyleBox["DeleteFromTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeleteFromTableau"],

Cell[TextData[{
  StyleBox["DeleteVertex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeleteVertex"],

Cell[TextData[{
  StyleBox["DeleteVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeleteVertices"],

Cell[TextData[{
  StyleBox["DendrogramPlot", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"DendrogramPlot"],

Cell[TextData[{
  "Density, of Butcher tree, ",
  StyleBox["ButcherGamma", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Density"],

Cell[TextData[{
  StyleBox["Density", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Density"],

Cell[TextData[{
  "Density function, ",
  StyleBox["PDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Density function"],

Cell[TextData[{
  "Depth\[Hyphen]first search, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.46"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Depth-first search"],

Cell[TextData[{
  StyleBox["DepthFirstTraversal", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.46"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DepthFirstTraversal"],

Cell[TextData[{
  StyleBox["DerangementQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DerangementQ"],

Cell[TextData[{
  StyleBox["Derangements", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Derangements"],

Cell[TextData[{
  "Derivatives, numerical, ",
  StyleBox["ND", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Derivatives"],

Cell[TextData[{
  "variational, ",
  StyleBox["VariationalD", "MR"],
  ", ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Derivatives"],

Cell[TextData[{
  StyleBox["Derivatives", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Derivatives"],

Cell[TextData[{
  StyleBox["DescriptiveStatistics", "MR"],
  " package, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Appendix: Functions Moved to the Kernel",
    ButtonData:>{"6.17.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DescriptiveStatistics package"],

Cell[TextData[{
  StyleBox["DesignedRegress", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DesignedRegress"],

Cell[TextData[{
  StyleBox["DesignMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DesignMatrix"],

Cell[TextData[{
  StyleBox["DeuteronMagneticMoment", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeuteronMagneticMoment"],

Cell[TextData[{
  StyleBox["DeuteronMass", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DeuteronMass"],

Cell[TextData[{
  StyleBox["DiagonallyImplicit", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DiagonallyImplicit"],

Cell[TextData[{
  StyleBox["DiagramPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DiagramPlot"],

Cell[TextData[{
  "Diagrams, of neighborhood polygons, ",
  StyleBox["VoronoiDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Diagrams"],

Cell[TextData[{
  "of partitions, ",
  StyleBox["FerrersDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Diagrams"],

Cell[TextData[{
  StyleBox["Diameter", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Diameter"],

Cell[TextData[{
  StyleBox["DiceDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"DiceDissimilarity"],

Cell[TextData[{
  StyleBox["Dictionary", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Dictionary`",
    ButtonData:>{"Miscellaneous`Dictionary`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dictionary"],

Cell[TextData[{
  StyleBox["DictionaryWordQ", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Dictionary`",
    ButtonData:>{"Miscellaneous`Dictionary`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DictionaryWordQ"],

Cell[TextData[{
  "Differential, arc length, ",
  StyleBox["ArcLengthFactor", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Differential"],

Cell[TextData[{
  "volume, ",
  StyleBox["JacobianDeterminant", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.39"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Differential"],

Cell[TextData[{
  "Differential equations, nonlinear, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Differential equations"],

Cell[TextData[{
  "numerical solution of, ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \npartial first\[Hyphen]order, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Differential equations"],

Cell[TextData[{
  "Differentiation, numerical, ",
  StyleBox["ND", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Differentiation"],

Cell[TextData[{
  StyleBox["Digon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Digon"],

Cell[TextData[{
  StyleBox["Dihedral", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dihedral"],

Cell[TextData[{
  StyleBox["DihedralGroup", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DihedralGroup"],

Cell[TextData[{
  StyleBox["DihedralGroupIndex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DihedralGroupIndex"],

Cell[TextData[{
  StyleBox["Dijkstra", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dijkstra"],

Cell[TextData[{
  StyleBox["DilateVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DilateVertices"],

Cell[TextData[{
  StyleBox["DirectAgglomerate", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"DirectAgglomerate"],

Cell[TextData[{
  StyleBox["Directed", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Directed"],

Cell[TextData[{
  "Dirichlet cells, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dirichlet cells"],

Cell[TextData[{
  StyleBox["DiscreteDistributions", "MR"],
  " package, ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DiscreteDistributions package"],

Cell[TextData[{
  StyleBox["DiscreteUniformDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DiscreteUniformDistribution"],

Cell[TextData[{
  "Discriminant analysis, ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Discriminant analysis"],

Cell[TextData[{
  StyleBox["Disk", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Disk"],

Cell[TextData[{
  StyleBox["DispersionMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DispersionMatrix"],

Cell[TextData[{
  StyleBox["DispersionReport", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DispersionReport"],

Cell[TextData[{
  "Display, of graphs, ",
  StyleBox["ShowGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Display"],

Cell[TextData[{
  "of animation, ",
  StyleBox["ShowAnimation", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " \nof legends, ",
  StyleBox["ShowLegend", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Display"],

Cell[TextData[{
  StyleBox["DisplayFunction", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.56"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DisplayFunction"],

Cell[TextData[{
  StyleBox["DisplayTogether", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DisplayTogether"],

Cell[TextData[{
  StyleBox["DisplayTogetherArray", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DisplayTogetherArray"],

Cell[TextData[{
  "Distance, between cities, ",
  StyleBox["CityDistance", "MR"],
  ", ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Distance"],

Cell[TextData[{
  "spherical, ",
  StyleBox["SphericalDistance", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nspheroidal, ",
  StyleBox["SpheroidalDistance", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Distance"],

Cell[TextData[{
  StyleBox["DistanceFunction", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"DistanceFunction"],

Cell[TextData[{
  StyleBox["DistanceMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"DistanceMatrix"],

Cell[TextData[{
  StyleBox["Distances", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Distances"],

Cell[TextData[{
  StyleBox["DistinctPermutations", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DistinctPermutations"],

Cell[TextData[{
  StyleBox["Distribution", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Distribution"],

Cell[TextData[{
  "Distribution function, ",
  StyleBox["CDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Distribution function"],

Cell[TextData[{
  "Distributions, continuous probability, ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Distributions"],

Cell[TextData[{
  "discrete probability, ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nproperties of, ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Distributions"],

Cell[TextData[{
  StyleBox["Div", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Div"],

Cell[TextData[{
  "Divergence of vector field, ",
  StyleBox["Div", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Divergence of vector field"],

Cell[TextData[{
  StyleBox["Dodecagon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dodecagon"],

Cell[TextData[{
  StyleBox["DodecahedralGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DodecahedralGraph"],

Cell[TextData[{
  StyleBox["Dodecahedron", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dodecahedron"],

Cell[TextData[{
  StyleBox["Domain", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Domain"],

Cell[TextData[{
  StyleBox["DomainQ", "MR"],
  ", ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DomainQ"],

Cell[TextData[{
  StyleBox["DominatingIntegerPartitionQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DominatingIntegerPartitionQ"],

Cell[TextData[{
  StyleBox["DominationLattice", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DominationLattice"],

Cell[TextData[{
  "Dot product, in various coordinate systems, ",
  StyleBox["DotProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dot product"],

Cell[TextData[{
  StyleBox["DotProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DotProduct"],

Cell[TextData[{
  StyleBox["DoubleHelix", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DoubleHelix"],

Cell[TextData[{
  StyleBox["DropNonNumeric", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DropNonNumeric"],

Cell[TextData[{
  StyleBox["DropNonNumericColumn", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DropNonNumericColumn"],

Cell[TextData[{
  StyleBox["DSolveIntegrals", "MR"],
  " package, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DSolveIntegrals package"],

Cell[TextData[{
  StyleBox["DTFourierTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DTFourierTransform"],

Cell[TextData[{
  StyleBox["Dual", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dual"],

Cell[TextData[{
  StyleBox["Duncan", "MR"],
  ", ",
  ButtonBox["Statistics`ANOVA`",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Duncan"],

Cell[TextData[{
  StyleBox["Dunnett", "MR"],
  ", ",
  ButtonBox["Statistics`ANOVA`",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Dunnett"],

Cell[TextData[{
  StyleBox["DurbinWatsonD", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DurbinWatsonD"],

Cell[TextData[{
  StyleBox["DurfeeSquare", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"DurfeeSquare"],

Cell[TextData[{
  StyleBox["DynamicViscosity", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  "Earth, geodesy, ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Earth"],

Cell[TextData[{
  StyleBox["EarthCrustAbundance", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EarthCrustAbundance"],

Cell[TextData[{
  StyleBox["EarthMass", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EarthMass"],

Cell[TextData[{
  StyleBox["EarthOceanAbundance", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EarthOceanAbundance"],

Cell[TextData[{
  StyleBox["EarthRadius", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EarthRadius"],

Cell[TextData[{
  StyleBox["EasterSunday", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EasterSunday"],

Cell[TextData[{
  StyleBox["EasterSundayGreekOrthodox", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EasterSundayGreekOrthodox"],

Cell[TextData[{
  StyleBox["Eccentricity", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Eccentricity"],

Cell[TextData[{
  StyleBox["EconomizedRationalApproximation", "MR"],
  ", ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EconomizedRationalApproximation"],

Cell[TextData[{
  StyleBox["EdgeChromaticNumber", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeChromaticNumber"],

Cell[TextData[{
  StyleBox["EdgeColor", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeColor"],

Cell[TextData[{
  StyleBox["EdgeColoring", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeColoring"],

Cell[TextData[{
  StyleBox["EdgeConnectivity", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.69"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeConnectivity"],

Cell[TextData[{
  StyleBox["EdgeDirection", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeDirection"],

Cell[TextData[{
  StyleBox["EdgeLabel", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeLabel"],

Cell[TextData[{
  StyleBox["EdgeLabelColor", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeLabelColor"],

Cell[TextData[{
  StyleBox["EdgeLabelPosition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeLabelPosition"],

Cell[TextData[{
  StyleBox["Edges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Edges"],

Cell[TextData[{
  "Edges of plot, labeling, ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Edges of plot"],

Cell[TextData[{
  StyleBox["EdgeStyle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeStyle"],

Cell[TextData[{
  StyleBox["EdgeWeight", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EdgeWeight"],

Cell[TextData[{
  StyleBox["EditDistance", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"EditDistance"],

Cell[TextData[{
  StyleBox["EigenstructureTable", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EigenstructureTable"],

Cell[TextData[{
  StyleBox["ElectronCharge", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElectronCharge"],

Cell[TextData[{
  StyleBox["ElectronComptonWavelength", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElectronComptonWavelength"],

Cell[TextData[{
  StyleBox["ElectronConfiguration", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElectronConfiguration"],

Cell[TextData[{
  StyleBox["ElectronConfigurationFormat", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElectronConfigurationFormat"],

Cell[TextData[{
  StyleBox["ElectronGFactor", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElectronGFactor"],

Cell[TextData[{
  StyleBox["ElectronMagneticMoment", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElectronMagneticMoment"],

Cell[TextData[{
  StyleBox["ElectronMass", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElectronMass"],

Cell[TextData[{
  StyleBox["Element", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Element"],

Cell[TextData[{
  StyleBox["ElementAbsorptionMap", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElementAbsorptionMap"],

Cell[TextData[{
  StyleBox["Elements", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Elements"],

Cell[TextData[{
  StyleBox["ElementToPolynomial", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ElementToPolynomial"],

Cell[TextData[{
  "Elimination, Gaussian, ",
  ButtonBox["LinearAlgebra`Tridiagonal`",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Elimination"],

Cell[TextData[{
  StyleBox["Ellipsoid", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Ellipsoid"],

Cell[TextData[{
  StyleBox["EllipsoidQuantile", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EllipsoidQuantile"],

Cell[TextData[{
  StyleBox["EllipsoidQuartiles", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EllipsoidQuartiles"],

Cell[TextData[{
  "Elliptic curves, ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Elliptic curves"],

Cell[TextData[{
  StyleBox["EllipticCylindrical", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EllipticCylindrical"],

Cell[TextData[{
  StyleBox["EmptyGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EmptyGraph"],

Cell[TextData[{
  StyleBox["EmptyQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EmptyQ"],

Cell[TextData[{
  StyleBox["EncroachingListSet", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EncroachingListSet"],

Cell[TextData[{
  StyleBox["End", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"End"],

Cell[TextData[{
  StyleBox["EndPackage", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EndPackage"],

Cell[TextData[{
  StyleBox["EqualVariances", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EqualVariances"],

Cell[TextData[{
  "Equations, difference, ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Equations"],

Cell[TextData[{
  "differential, ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \npartial differential, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nplotting solutions to, ",
  StyleBox["ImplicitPlot", "MR"],
  ", ",
  ButtonBox["Graphics`ImplicitPlot`",
    ButtonData:>{"Graphics`ImplicitPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nrecurrence, ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Equations"],

Cell[TextData[{
  StyleBox["EquivalenceClasses", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EquivalenceClasses"],

Cell[TextData[{
  StyleBox["EquivalenceRelationQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EquivalenceRelationQ"],

Cell[TextData[{
  StyleBox["Equivalences", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Equivalences"],

Cell[TextData[{
  StyleBox["EuclideanDistance", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"EuclideanDistance"],

Cell[TextData[{
  "Error\[Hyphen]correcting codes, ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.2", "2.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Error-correcting codes"],

Cell[TextData[{
  StyleBox["ErrorBar", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ErrorBar"],

Cell[TextData[{
  StyleBox["ErrorBarFunction", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ErrorBarFunction"],

Cell[TextData[{
  StyleBox["ErrorListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ErrorListPlot"],

Cell[TextData[{
  "Errors, in Gaussian quadrature, ",
  StyleBox["GaussianQuadratureError", "MR"],
  ", ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Errors"],

Cell[TextData[{
  "in Newton\[Hyphen]Cotes quadrature, ",
  StyleBox["NewtonCotesError", "MR"],
  ", ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nin numerical integration, ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \ninfinite recursion, ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " \nmachine, ",
  StyleBox["MachineError", "MR"],
  ", ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " \nname conflict, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Errors"],

Cell[TextData[{
  StyleBox["EstimatedVariance", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EstimatedVariance"],

Cell[TextData[{
  "Estimates, maximum likelihood, ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Estimates"],

Cell[TextData[{
  "unbiased, ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Estimates"],

Cell[TextData[{
  "Estimation accuracy, of statistical parameters, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Estimation accuracy"],

Cell[TextData[{
  StyleBox["Euclidean", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Euclidean"],

Cell[TextData[{
  "Euler angles, ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Euler angles"],

Cell[TextData[{
  "Euler\[Hyphen]Lagrange equations, ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Euler-Lagrange equations"],

Cell[TextData[{
  StyleBox["EulerEquations", "MR"],
  ", ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EulerEquations"],

Cell[TextData[{
  StyleBox["Eulerian", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Eulerian"],

Cell[TextData[{
  StyleBox["EulerianCycle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EulerianCycle"],

Cell[TextData[{
  StyleBox["EulerianQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EulerianQ"],

Cell[TextData[{
  StyleBox["EulerRatio", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EulerRatio"],

Cell[TextData[{
  StyleBox["EulerSum", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EulerSum"],

Cell[TextData[{
  StyleBox["EvenQ", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"EvenQ"],

Cell[TextData[{
  StyleBox["ExactRandomGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExactRandomGraph"],

Cell[TextData[{
  StyleBox["ExpandGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExpandGraph"],

Cell[TextData[{
  StyleBox["ExpectedValue", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExpectedValue"],

Cell[TextData[{
  "Experimental data, plotting, ",
  StyleBox["ErrorListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Experimental data"],

Cell[TextData[{
  StyleBox["Explicit", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Explicit"],

Cell[TextData[{
  StyleBox["ExponentialDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExponentialDistribution"],

Cell[TextData[{
  StyleBox["ExponentialGeneratingFunction", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExponentialGeneratingFunction"],

Cell[TextData[{
  StyleBox["ExponentialGeneratingFunctionConstants", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExponentialGeneratingFunctionConstants"],

Cell[TextData[{
  StyleBox["ExponentialPowerSum", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExponentialPowerSum"],

Cell[TextData[{
  StyleBox["ExponentialSmoothing", "MR"],
  ", ",
  ButtonBox["Statistics`DataSmoothing`",
    ButtonData:>{"Statistics`DataSmoothing`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExponentialSmoothing"],

Cell[TextData[{
  StyleBox["ExponentRange", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExponentRange"],

Cell[TextData[{
  "Expressions, plotting, ",
  StyleBox["ExprPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Expressions"],

Cell[TextData[{
  StyleBox["ExprPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExprPlot"],

Cell[TextData[{
  StyleBox["ExtendedGCD", "MR"],
  ", for polynomials, ",
  StyleBox["PolynomialExtendedGCD", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialExtendedGCD`",
    ButtonData:>{"Algebra`PolynomialExtendedGCD`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExtendedGCD"],

Cell[TextData[{
  StyleBox["ExtensionDegree", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExtensionDegree"],

Cell[TextData[{
  StyleBox["ExtractCycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExtractCycles"],

Cell[TextData[{
  StyleBox["ExtraTerms", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ExtraTerms"],

Cell[TextData[{
  StyleBox["ExtremeValueDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  "F distribution, ",
  StyleBox["FRatioDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"F distribution"],

Cell[TextData[{
  "noncentral, ",
  StyleBox["NoncentralFRatioDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " \np\[Hyphen]value, ",
  StyleBox["FRatioPValue", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"F distribution"],

Cell[TextData[{
  "F\[Hyphen]ratio distribution, ",
  StyleBox["FRatioDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"F-ratio distribution"],

Cell[TextData[{
  "noncentral, ",
  StyleBox["NoncentralFRatioDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " \np\[Hyphen]value, ",
  StyleBox["FRatioPValue", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"F-ratio distribution"],

Cell[TextData[{
  StyleBox["Faces", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Faces"],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Factor"],

Cell[TextData[{
  StyleBox["Factorial", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Factorial"],

Cell[TextData[{
  StyleBox["Factorial2", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Factorial2"],

Cell[TextData[{
  "Factoring, imaginary, ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Factoring"],

Cell[TextData[{
  "of integers, ",
  StyleBox["FactorIntegerECM", "MR"],
  ", ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof polynomials over finite fields, ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Factoring"],

Cell[TextData[{
  StyleBox["FactorInteger", "MR"],
  ", ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FactorInteger"],

Cell[TextData[{
  StyleBox["FactorIntegerECM", "MR"],
  ", ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FactorIntegerECM"],

Cell[TextData[{
  StyleBox["FactorIntegerECM", "MR"],
  " package, ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FactorIntegerECM package"],

Cell[TextData[{
  StyleBox["FactorList", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FactorList"],

Cell[TextData[{
  StyleBox["FactorSize", "MR"],
  ", ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FactorSize"],

Cell[TextData[{
  StyleBox["FaradayConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FaradayConstant"],

Cell[TextData[{
  StyleBox["FerrersDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FerrersDiagram"],

Cell[TextData[{
  StyleBox["Fibonacci", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Fibonacci"],

Cell[TextData[{
  StyleBox["FieldExp", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FieldExp"],

Cell[TextData[{
  StyleBox["FieldInd", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FieldInd"],

Cell[TextData[{
  StyleBox["FieldIrreducible", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FieldIrreducible"],

Cell[TextData[{
  StyleBox["FieldSize", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FieldSize"],

Cell[TextData[{
  "File format, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"File format"],

Cell[TextData[{
  "Files, automatic loading of, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Files"],

Cell[TextData[{
  "Filled region, ",
  StyleBox["FilledPlot", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Filled region"],

Cell[TextData[{
  StyleBox["FilledListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FilledListPlot"],

Cell[TextData[{
  StyleBox["FilledPlot", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FilledPlot"],

Cell[TextData[{
  StyleBox["FilledPlot", "MR"],
  " package, ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FilledPlot package"],

Cell[TextData[{
  StyleBox["FilledPlots", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FilledPlots"],

Cell[TextData[{
  StyleBox["Fills", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Fills"],

Cell[TextData[{
  StyleBox["FilterOptions", "MR"],
  ", ",
  ButtonBox["Utilities`FilterOptions`",
    ButtonData:>{"Utilities`FilterOptions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FilterOptions"],

Cell[TextData[{
  StyleBox["FilterOptions", "MR"],
  " package, ",
  ButtonBox["Utilities`FilterOptions`",
    ButtonData:>{"Utilities`FilterOptions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FilterOptions package"],

Cell[TextData[{
  StyleBox["FindClusters", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"FindClusters"],

Cell[TextData[{
  StyleBox["FindCycle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindCycle"],

Cell[TextData[{
  StyleBox["FindIons", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindIons"],

Cell[TextData[{
  StyleBox["FindMinimum", "MR"],
  ", ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindMinimum"],

Cell[TextData[{
  StyleBox["FindPackages", "MR"],
  ", ",
  ButtonBox["Utilities`Package`",
    ButtonData:>{"Utilities`Package`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindPackages"],

Cell[TextData[{
  StyleBox["FindRoot", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.46"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`BesselZeros`",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindRoot"],

Cell[TextData[{
  StyleBox["FindSet", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindSet"],

Cell[TextData[{
  StyleBox["FindWords", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Dictionary`",
    ButtonData:>{"Miscellaneous`Dictionary`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FindWords"],

Cell[TextData[{
  StyleBox["FineStructureConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FineStructureConstant"],

Cell[TextData[{
  "Finite fields, polynomials over, ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Finite fields"],

Cell[TextData[{
  StyleBox["FiniteFields", "MR"],
  " package, ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FiniteFields package"],

Cell[TextData[{
  StyleBox["FiniteGraphs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FiniteGraphs"],

Cell[TextData[{
  "First integrals, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"First integrals"],

Cell[TextData[{
  StyleBox["FirstIntegral", "MR"],
  ", ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FirstIntegral"],

Cell[TextData[{
  StyleBox["FirstIntegrals", "MR"],
  ", ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FirstIntegrals"],

Cell[TextData[{
  StyleBox["FirstLexicographicTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FirstLexicographicTableau"],

Cell[TextData[{
  StyleBox["Fit", "MR"],
  ", ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`TrigFit`",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Fit"],

Cell[TextData[{
  StyleBox["FitCurvatureTable", "MR"],
  ", ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FitCurvatureTable"],

Cell[TextData[{
  StyleBox["FitResiduals", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FitResiduals"],

Cell[TextData[{
  "Fits, nonlinear, ",
  StyleBox["NonlinearFit", "MR"],
  ", ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Fits"],

Cell[TextData[{
  "polynomial, ",
  StyleBox["PolynomialFit", "MR"],
  ", ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nspline, ",
  StyleBox["SplineFit", "MR"],
  ", ",
  ButtonBox["NumericalMath`SplineFit`",
    ButtonData:>{"NumericalMath`SplineFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntrigonometric, ",
  StyleBox["TrigFit", "MR"],
  ", ",
  ButtonBox["NumericalMath`TrigFit`",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Fits"],

Cell[TextData[{
  "Fixed point, of a permutation, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Fixed point"],

Cell[TextData[{
  "Fixed precision arithmetic, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Fixed precision arithmetic"],

Cell[TextData[{
  "Floating\[Hyphen]point hardware, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Floating-point hardware"],

Cell[TextData[{
  StyleBox["FolkmanGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FolkmanGraph"],

Cell[TextData[{
  "Format, for output to files, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Format"],

Cell[TextData[{
  "Four\[Hyphen]dimensional graphics, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Four-dimensional graphics"],

Cell[TextData[{
  "Fourier summation waveform synthesis, ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Fourier summation waveform synthesis"],

Cell[TextData[{
  StyleBox["FourierCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierCoefficient"],

Cell[TextData[{
  StyleBox["FourierCos", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`FourierTrig`",
    ButtonData:>{"LinearAlgebra`FourierTrig`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierCos"],

Cell[TextData[{
  StyleBox["FourierCosCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierCosCoefficient"],

Cell[TextData[{
  StyleBox["FourierSeries", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierSeries"],

Cell[TextData[{
  StyleBox["FourierSin", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`FourierTrig`",
    ButtonData:>{"LinearAlgebra`FourierTrig`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierSin"],

Cell[TextData[{
  StyleBox["FourierSinCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierSinCoefficient"],

Cell[TextData[{
  StyleBox["FourierTransform", "MR"],
  " package, ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierTransform package"],

Cell[TextData[{
  StyleBox["FourierTrig", "MR"],
  " package, ",
  ButtonBox["LinearAlgebra`FourierTrig`",
    ButtonData:>{"LinearAlgebra`FourierTrig`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierTrig package"],

Cell[TextData[{
  StyleBox["FourierTrigSeries", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FourierTrigSeries"],

Cell[TextData[{
  StyleBox["FranklinGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FranklinGraph"],

Cell[TextData[{
  StyleBox["FRatioCI", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FRatioCI"],

Cell[TextData[{
  StyleBox["FRatioDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FRatioDistribution"],

Cell[TextData[{
  StyleBox["FRatioPValue", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FRatioPValue"],

Cell[TextData[{
  StyleBox["Frequencies", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Frequencies"],

Cell[TextData[{
  "Frequency/pitch equivalents, ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Frequency/pitch equivalents"],

Cell[TextData[{
  StyleBox["FrequencyData", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FrequencyData"],

Cell[TextData[{
  StyleBox["FrequencyModulation", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FrequencyModulation"],

Cell[TextData[{
  StyleBox["FromAdjacencyLists", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromAdjacencyLists"],

Cell[TextData[{
  StyleBox["FromAdjacencyMatrix", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromAdjacencyMatrix"],

Cell[TextData[{
  StyleBox["FrobeniusF", "MR"],
  ", ",
  ButtonBox["NumberTheory`Frobenius`",
    ButtonData:>{"NumberTheory`Frobenius`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FrobeniusF"],

Cell[TextData[{
  StyleBox["FrobeniusInstance", "MR"],
  ", ",
  ButtonBox["NumberTheory`Frobenius`",
    ButtonData:>{"NumberTheory`Frobenius`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FrobeniusInstance"],

Cell[TextData[{
  StyleBox["FrobeniusSolve", "MR"],
  ", ",
  ButtonBox["NumberTheory`Frobenius`",
    ButtonData:>{"NumberTheory`Frobenius`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FrobeniusSolve"],

Cell[TextData[{
  StyleBox["FromContinuedFraction", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromContinuedFraction"],

Cell[TextData[{
  StyleBox["FromCycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromCycles"],

Cell[TextData[{
  StyleBox["FromDigits", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromDigits"],

Cell[TextData[{
  StyleBox["FromElementCode", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromElementCode"],

Cell[TextData[{
  StyleBox["FromInversionVector", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromInversionVector"],

Cell[TextData[{
  StyleBox["FromOrderedPairs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromOrderedPairs"],

Cell[TextData[{
  StyleBox["FromQuaternion", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromQuaternion"],

Cell[TextData[{
  StyleBox["FromUnorderedPairs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FromUnorderedPairs"],

Cell[TextData[{
  StyleBox["Front", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Front"],

Cell[TextData[{
  StyleBox["FruchtGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FruchtGraph"],

Cell[TextData[{
  StyleBox["FullPath", "MR"],
  ", ",
  ButtonBox["Utilities`Package`",
    ButtonData:>{"Utilities`Package`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FullPath"],

Cell[TextData[{
  StyleBox["FullReport", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FullReport"],

Cell[TextData[{
  "Function values, list of, ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Function values"],

Cell[TextData[{
  StyleBox["FunctionalGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FunctionalGraph"],

Cell[TextData[{
  "Functions, approximate, ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Functions"],

Cell[TextData[{
  "characteristic, ",
  StyleBox["CharacteristicFunction", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \ncombinatorial, ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ncumulative distribution, ",
  StyleBox["CDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \ngenerating, ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \nin graph theory, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \noptions for, ",
  ButtonBox["Utilities`FilterOptions`",
    ButtonData:>{"Utilities`FilterOptions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nplotting contours of, ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nplotting graphs of, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " \nprobability density, ",
  StyleBox["PDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nremoving completely, ",
  StyleBox["Remove", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Functions"],

Cell[TextData[{
  StyleBox["FundamentalDiscriminantQ", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"FundamentalDiscriminantQ"],

Cell[TextData[{
  "Fusion, heat of, ",
  StyleBox["HeatOfFusion", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["GalacticUnit", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GalacticUnit"],

Cell[TextData[{
  "Galois fields, ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Galois fields"],

Cell[TextData[{
  StyleBox["GammaDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GammaDistribution"],

Cell[TextData[{
  "Gamut, of colors, ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Gamut"],

Cell[TextData[{
  "Gaussian distribution, ",
  StyleBox["MultinormalDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Gaussian distribution"],

Cell[TextData[{
  StyleBox["NormalDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Gaussian distribution"],

Cell[TextData[{
  "Gaussian elimination, ",
  ButtonBox["LinearAlgebra`Tridiagonal`",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Gaussian elimination"],

Cell[TextData[{
  "Gaussian quadrature, ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Gaussian quadrature"],

Cell[TextData[{
  StyleBox["GaussianIntegers", "MR"],
  ", ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GaussianIntegers"],

Cell[TextData[{
  StyleBox["GaussianQuadrature", "MR"],
  " package, ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GaussianQuadrature package"],

Cell[TextData[{
  StyleBox["GaussianQuadratureError", "MR"],
  ", ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GaussianQuadratureError"],

Cell[TextData[{
  StyleBox["GaussianQuadratureWeights", "MR"],
  ", ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GaussianQuadratureWeights"],

Cell[TextData[{
  StyleBox["GCD", "MR"],
  ", ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.8", "8.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GCD"],

Cell[TextData[{
  "Gear ratios, ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.8", "8.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Gear ratios"],

Cell[TextData[{
  StyleBox["GeneralizedBarChart", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeneralizedBarChart"],

Cell[TextData[{
  StyleBox["GeneralizedPetersenGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeneralizedPetersenGraph"],

Cell[TextData[{
  StyleBox["GeneralizedVariance", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeneralizedVariance"],

Cell[TextData[{
  StyleBox["GeneralMiniMaxApproximation", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.53"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeneralMiniMaxApproximation"],

Cell[TextData[{
  StyleBox["GeneralRationalInterpolation", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeneralRationalInterpolation"],

Cell[TextData[{
  StyleBox["GeneratingFunction", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeneratingFunction"],

Cell[TextData[{
  StyleBox["GeneratingFunctionConstants", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeneratingFunctionConstants"],

Cell[TextData[{
  StyleBox["Geodesate", "MR"],
  ", ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Geodesate"],

Cell[TextData[{
  "Geodesy, ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Geodesy"],

Cell[TextData[{
  StyleBox["Geodesy", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Geodesy package"],

Cell[TextData[{
  StyleBox["GeodeticToAuthalic", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeodeticToAuthalic"],

Cell[TextData[{
  "Geography, ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Geography"],

Cell[TextData[{
  "Geometrical characteristics, of polygons, ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Geometrical characteristics"],

Cell[TextData[{
  "of polyhedra, ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Geometrical characteristics"],

Cell[TextData[{
  StyleBox["GeometricDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeometricDistribution"],

Cell[TextData[{
  StyleBox["GeometricMean", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GeometricMean"],

Cell[TextData[{
  "Geostatistics, ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.4", "4.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Geostatistics"],

Cell[TextData[{
  StyleBox["Get", "MR"],
  " (",
  StyleBox["<<", "MR"],
  "), ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.1", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Get (<<)"],

Cell[TextData[{
  StyleBox["GetDictionary", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Dictionary`",
    ButtonData:>{"Miscellaneous`Dictionary`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GetDictionary"],

Cell[TextData[{
  StyleBox["GetEdgeLabels", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GetEdgeLabels"],

Cell[TextData[{
  StyleBox["GetEdgeWeights", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GetEdgeWeights"],

Cell[TextData[{
  StyleBox["GetVertexLabels", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GetVertexLabels"],

Cell[TextData[{
  StyleBox["GetVertexWeights", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GetVertexWeights"],

Cell[TextData[{
  StyleBox["GF", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GF"],

Cell[TextData[{
  StyleBox["Girth", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Girth"],

Cell[TextData[{
  "Goldwasser\[Hyphen]Kilian primality certificate, ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Goldwasser-Kilian primality certificate"],

Cell[TextData[{
  StyleBox["Grad", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Grad"],

Cell[TextData[{
  "Gradient, ",
  StyleBox["Grad", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Gradient"],

Cell[TextData[{
  "three\[Hyphen]dimensional vector field, ",
  StyleBox["PlotGradientField3D", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntwo\[Hyphen]dimensional vector field, ",
  StyleBox["PlotGradientField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Gradient"],

Cell[TextData[{
  StyleBox["GramSchmidt", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GramSchmidt"],

Cell[TextData[{
  "Granularity, of machine numbers, ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Granularity"],

Cell[TextData[{
  "Graph connectivity, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graph connectivity"],

Cell[TextData[{
  "Graph cycle structure, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graph cycle structure"],

Cell[TextData[{
  "Graph flow, ",
  StyleBox["NetworkFlow", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.88"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graph flow"],

Cell[TextData[{
  "Graph invariants, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graph invariants"],

Cell[TextData[{
  "Graph theory, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graph theory"],

Cell[TextData[{
  StyleBox["GraphCenter", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphCenter"],

Cell[TextData[{
  StyleBox["GraphComplement", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphComplement"],

Cell[TextData[{
  StyleBox["GraphCoordinates", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphCoordinates"],

Cell[TextData[{
  StyleBox["GraphCoordinates3D", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphCoordinates3D"],

Cell[TextData[{
  StyleBox["GraphDifference", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphDifference"],

Cell[TextData[{
  StyleBox["GraphDistance", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphDistance"],

Cell[TextData[{
  StyleBox["GraphicQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphicQ"],

Cell[TextData[{
  "Graphics, animated, ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics"],

Cell[TextData[{
  "four\[Hyphen]dimensional, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ngeographical, ",
  StyleBox["WorldGraphics", "MR"],
  ", ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " \nlabeling two\[Hyphen]dimensional, ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nstacked, ",
  StyleBox["StackGraphics", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " \nthree\[Hyphen]dimensional, ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntwo\[Hyphen]dimensional, ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Graphics"],

Cell[TextData[{
  StyleBox["Graphics", "MR"],
  ", ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics"],

Cell[TextData[{
  "Graphics directives, ",
  StyleBox["ArgColor", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics directives"],

Cell[TextData[{
  StyleBox["ArgShade", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " \n",
  StyleBox["ColorCircle", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Graphics directives"],

Cell[TextData[{
  "Graphics file format, three\[Hyphen]dimensional, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics file format"],

Cell[TextData[{
  StyleBox["Graphics", "MR"],
  " package, ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics package"],

Cell[TextData[{
  "Graphics primitives, three\[Hyphen]dimensional, ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics primitives"],

Cell[TextData[{
  "two\[Hyphen]dimensional, ",
  StyleBox["Arrow", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntwo\[Hyphen]dimensional, ",
  StyleBox["Spline", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Graphics primitives"],

Cell[TextData[{
  "Graphics sequence, ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics sequence"],

Cell[TextData[{
  StyleBox["Graphics3D", "MR"],
  " package, ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphics3D package"],

Cell[TextData[{
  StyleBox["GraphicsArray", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphicsArray"],

Cell[TextData[{
  StyleBox["GraphIntersection", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphIntersection"],

Cell[TextData[{
  StyleBox["GraphJoin", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphJoin"],

Cell[TextData[{
  StyleBox["GraphOptions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphOptions"],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", None},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphPlot"],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  " package, ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphPlot package"],

Cell[TextData[{
  StyleBox["GraphPlot3D", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GraphPlot3D"],

Cell[TextData[{
  StyleBox["GraphPolynomial", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphPolynomial"],

Cell[TextData[{
  StyleBox["GraphPower", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphPower"],

Cell[TextData[{
  StyleBox["GraphProduct", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphProduct"],

Cell[TextData[{
  "Graphs, bipartite, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.44"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Graphs"],

Cell[TextData[{
  "cycles of, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  " \nembedded, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  " \nlabeled, ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nproduct of, ",
  StyleBox["GraphProduct", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " \nunion of, ",
  StyleBox["GraphUnion", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.53"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Graphs"],

Cell[TextData[{
  StyleBox["GraphSum", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphSum"],

Cell[TextData[{
  StyleBox["GraphUnion", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.53"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GraphUnion"],

Cell[TextData[{
  StyleBox["GravitationalConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GravitationalConstant"],

Cell[TextData[{
  StyleBox["GravityAcceleration", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GravityAcceleration"],

Cell[TextData[{
  StyleBox["GrayCode", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GrayCode"],

Cell[TextData[{
  StyleBox["GrayCodeKSubsets", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GrayCodeKSubsets"],

Cell[TextData[{
  StyleBox["GrayCodeSubsets", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GrayCodeSubsets"],

Cell[TextData[{
  StyleBox["GrayGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GrayGraph"],

Cell[TextData[{
  StyleBox["GrayLevel", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GrayLevel"],

Cell[TextData[{
  StyleBox["GreatDodecahedron", "MR"],
  ", ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GreatDodecahedron"],

Cell[TextData[{
  "Greatest common divisor of polynomials, extended, ",
  ButtonBox["Algebra`PolynomialExtendedGCD`",
    ButtonData:>{"Algebra`PolynomialExtendedGCD`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Greatest common divisor of polynomials"],

Cell[TextData[{
  StyleBox["GreatIcosahedron", "MR"],
  ", ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GreatIcosahedron"],

Cell[TextData[{
  StyleBox["GreatStellatedDodecahedron", "MR"],
  ", ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GreatStellatedDodecahedron"],

Cell[TextData[{
  StyleBox["GreedyVertexCover", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GreedyVertexCover"],

Cell[TextData[{
  "Grid, specifying size, ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Grid"],

Cell[TextData[{
  StyleBox["GridGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"GridGraph"],

Cell[TextData[{
  StyleBox["GrotztschGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["HalfNormalDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HalfNormalDistribution"],

Cell[TextData[{
  "Hamiltonian, ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hamiltonian"],

Cell[TextData[{
  "vector field, ",
  StyleBox["PlotHamiltonianField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Hamiltonian"],

Cell[TextData[{
  StyleBox["HamiltonianCycle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.75"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HamiltonianCycle"],

Cell[TextData[{
  StyleBox["HamiltonianQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HamiltonianQ"],

Cell[TextData[{
  StyleBox["HankelMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HankelMatrix"],

Cell[TextData[{
  StyleBox["Harary", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Harary"],

Cell[TextData[{
  StyleBox["HarmonicMean", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HarmonicMean"],

Cell[TextData[{
  StyleBox["HasseDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.79"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HasseDiagram"],

Cell[TextData[{
  StyleBox["HatDiagonal", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HatDiagonal"],

Cell[TextData[{
  StyleBox["HeadCenter", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeadCenter"],

Cell[TextData[{
  StyleBox["HeadLength", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeadLength"],

Cell[TextData[{
  StyleBox["HeadScaling", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeadScaling"],

Cell[TextData[{
  StyleBox["HeadShape", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeadShape"],

Cell[TextData[{
  StyleBox["HeadWidth", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeadWidth"],

Cell[TextData[{
  StyleBox["Heapify", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Heapify"],

Cell[TextData[{
  StyleBox["HeapSort", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeapSort"],

Cell[TextData[{
  StyleBox["HeatOfFusion", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeatOfFusion"],

Cell[TextData[{
  StyleBox["HeatOfVaporization", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeatOfVaporization"],

Cell[TextData[{
  StyleBox["HeawoodGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HeawoodGraph"],

Cell[TextData[{
  "Height, of Butcher tree, ",
  StyleBox["ButcherHeight", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Height"],

Cell[TextData[{
  StyleBox["Helix", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Helix"],

Cell[TextData[{
  StyleBox["Heptagon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Heptagon"],

Cell[TextData[{
  StyleBox["HerschelGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HerschelGraph"],

Cell[TextData[{
  StyleBox["HertzToCents", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HertzToCents"],

Cell[TextData[{
  StyleBox["Hexagon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hexagon"],

Cell[TextData[{
  StyleBox["Hexahedron", "MR"],
  ", ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hexahedron"],

Cell[TextData[{
  StyleBox["HideCycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HideCycles"],

Cell[TextData[{
  StyleBox["Highlight", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.58"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Highlight"],

Cell[TextData[{
  StyleBox["HighlightedEdgeColors", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HighlightedEdgeColors"],

Cell[TextData[{
  StyleBox["HighlightedEdgeStyle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HighlightedEdgeStyle"],

Cell[TextData[{
  StyleBox["HighlightedVertexColors", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HighlightedVertexColors"],

Cell[TextData[{
  StyleBox["HighlightedVertexStyle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HighlightedVertexStyle"],

Cell[TextData[{
  StyleBox["HilbertMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HilbertMatrix"],

Cell[TextData[{
  StyleBox["Histogram", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Histogram"],

Cell[TextData[{
  StyleBox["Histogram3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.25"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Histogram3D"],

Cell[TextData[{
  StyleBox["HistogramCategories", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HistogramCategories"],

Cell[TextData[{
  StyleBox["HistogramRange", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HistogramRange"],

Cell[TextData[{
  "Histograms, ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Histograms"],

Cell[TextData[{
  StyleBox["HistogramScale", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HistogramScale"],

Cell[TextData[{
  StyleBox["HLSColor", "MR"],
  ", ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HLSColor"],

Cell[TextData[{
  StyleBox["Hofstadter", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hofstadter"],

Cell[TextData[{
  "Holidays, dates of, ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Holidays"],

Cell[TextData[{
  "Hook length formula, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hook length formula"],

Cell[TextData[{
  StyleBox["Horizontal", "MR"],
  ", ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Horizontal"],

Cell[TextData[{
  StyleBox["Horner", "MR"],
  " package, ",
  ButtonBox["Algebra`Horner`",
    ButtonData:>{"Algebra`Horner`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Horner package"],

Cell[TextData[{
  StyleBox["HotellingTSquareDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HotellingTSquareDistribution"],

Cell[TextData[{
  StyleBox["Householder", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Householder"],

Cell[TextData[{
  StyleBox["HubbleConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HubbleConstant"],

Cell[TextData[{
  StyleBox["Hue", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hue"],

Cell[TextData[{
  StyleBox["Hull", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hull"],

Cell[TextData[{
  StyleBox["Hypercube", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.58"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hypercube"],

Cell[TextData[{
  StyleBox["HypergeometricDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"HypergeometricDistribution"],

Cell[TextData[{
  "Hypothesis tests, ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Hypothesis tests"],

Cell[TextData[{
  StyleBox["HypothesisTests", "MR"],
  " package, ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["IcePoint", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IcePoint"],

Cell[TextData[{
  StyleBox["IcosahedralGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IcosahedralGraph"],

Cell[TextData[{
  StyleBox["Icosahedron", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Icosahedron"],

Cell[TextData[{
  StyleBox["IdealDivide", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IdealDivide"],

Cell[TextData[{
  StyleBox["IdenticalQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IdenticalQ"],

Cell[TextData[{
  StyleBox["IdentityPermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IdentityPermutation"],

Cell[TextData[{
  StyleBox["Im", "MR"],
  ", ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Im"],

Cell[TextData[{
  "Image sequence, ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Image sequence"],

Cell[TextData[{
  StyleBox["Implicit", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Implicit"],

Cell[TextData[{
  "Implicit functions, plotting, ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ImplicitPlot`",
    ButtonData:>{"Graphics`ImplicitPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Implicit functions"],

Cell[TextData[{
  StyleBox["ImplicitPlot", "MR"],
  ", ",
  ButtonBox["Graphics`ImplicitPlot`",
    ButtonData:>{"Graphics`ImplicitPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ImplicitPlot"],

Cell[TextData[{
  StyleBox["ImplicitPlot", "MR"],
  " package, ",
  ButtonBox["Graphics`ImplicitPlot`",
    ButtonData:>{"Graphics`ImplicitPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ImplicitPlot package"],

Cell[TextData[{
  StyleBox["IncidenceMatrix", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IncidenceMatrix"],

Cell[TextData[{
  StyleBox["IncludeConstant", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IncludeConstant"],

Cell[TextData[{
  StyleBox["InDegree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InDegree"],

Cell[TextData[{
  StyleBox["IndependentSetQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IndependentSetQ"],

Cell[TextData[{
  StyleBox["Index", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Index"],

Cell[TextData[{
  "Index files (names files), ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Index files (names files)"],

Cell[TextData[{
  StyleBox["InduceSubgraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.43"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InduceSubgraph"],

Cell[TextData[{
  "Inequalities, algebraic, ",
  ButtonBox["Algebra`AlgebraicInequalities`",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Inequalities"],

Cell[TextData[{
  "polynomial, ",
  ButtonBox["Algebra`AlgebraicInequalities`",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Inequalities"],

Cell[TextData[{
  "Inequality solving, ",
  ButtonBox["Algebra`InequalitySolve`",
    ButtonData:>{"Algebra`InequalitySolve`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Inequality solving"],

Cell[TextData[{
  StyleBox["InequalityGraphics", "MR"],
  " package, ",
  ButtonBox["Graphics`InequalityGraphics`",
    ButtonData:>{"Graphics`InequalityGraphics`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InequalityGraphics package"],

Cell[TextData[{
  StyleBox["InequalityPlot", "MR"],
  ", ",
  ButtonBox["Graphics`InequalityGraphics`",
    ButtonData:>{"Graphics`InequalityGraphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InequalityPlot"],

Cell[TextData[{
  StyleBox["InequalityPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`InequalityGraphics`",
    ButtonData:>{"Graphics`InequalityGraphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InequalityPlot3D"],

Cell[TextData[{
  StyleBox["InequalitySolve", "MR"],
  ", ",
  ButtonBox["Algebra`InequalitySolve`",
    ButtonData:>{"Algebra`InequalitySolve`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InequalitySolve"],

Cell[TextData[{
  StyleBox["InequalitySolve", "MR"],
  " package, ",
  ButtonBox["Algebra`InequalitySolve`",
    ButtonData:>{"Algebra`InequalitySolve`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InequalitySolve package"],

Cell[TextData[{
  "Infinite recursion, ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Infinite recursion"],

Cell[TextData[{
  "Information, about packages, ",
  ButtonBox["Utilities`Package`",
    ButtonData:>{"Utilities`Package`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Information"],

Cell[TextData[{
  "about timing, ",
  ButtonBox["Utilities`ShowTime`",
    ButtonData:>{"Utilities`ShowTime`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Information"],

Cell[TextData[{
  StyleBox["init.m", "MR"],
  " files, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.4", "4.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"init.m files"],

Cell[TextData[{
  "Initialization files, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Initialization files"],

Cell[TextData[{
  StyleBox["InitializeUnionFind", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InitializeUnionFind"],

Cell[TextData[{
  "Inner products, in various coordinate systems, ",
  StyleBox["DotProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Inner products"],

Cell[TextData[{
  StyleBox["InnerProduct", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InnerProduct"],

Cell[TextData[{
  StyleBox["InscribedRadius", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InscribedRadius"],

Cell[TextData[{
  StyleBox["InsertIntoTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InsertIntoTableau"],

Cell[TextData[{
  StyleBox["IntegerQuaternionQ", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntegerQuaternionQ"],

Cell[TextData[{
  "Integers, number of representations as a sum of squares, ",
  StyleBox["SumOfSquaresR", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Integers"],

Cell[TextData[{
  "quadratic representation of, ",
  StyleBox["QuadraticRepresentation", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " \nrepresenting as a sum of squares, ",
  StyleBox["SumOfSquaresRepresentations", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  " \ntesting for squared factors, ",
  StyleBox["SquareFreeQ", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Integers"],

Cell[TextData[{
  "Integrals, divergent, ",
  ButtonBox["NumericalMath`CauchyPrincipalValue`",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Integrals"],

Cell[TextData[{
  "Integration, numerical, ",
  StyleBox["CauchyPrincipalValue", "MR"],
  ", ",
  ButtonBox["NumericalMath`CauchyPrincipalValue`",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Integration"],

Cell[TextData[{
  "numerical, ",
  StyleBox["NIntegrate", "MR"],
  ", ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects, ",
  StyleBox["NIntegrateInterpolatingFunction", "MR"],
  ", ",
  ButtonBox["NumericalMath`NIntegrateInterpolatingFunct`",
    ButtonData:>{"NumericalMath`NIntegrateInterpolatingFunct`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof lists, ",
  StyleBox["ListIntegrate", "MR"],
  ", ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Integration"],

Cell[TextData[{
  StyleBox["Integration:numerical", "MR"],
  ", ",
  ButtonBox["NumericalMath`NIntegrateInterpolatingFunct`",
    ButtonData:>{"NumericalMath`NIntegrateInterpolatingFunct`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Integration:numerical"],

Cell[TextData[{
  StyleBox["InterpolatedQuantile", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InterpolatedQuantile"],

Cell[TextData[{
  StyleBox["InterpolateRoot", "MR"],
  ", ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InterpolateRoot"],

Cell[TextData[{
  StyleBox["InterpolateRoot", "MR"],
  " package, ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InterpolateRoot package"],

Cell[TextData[{
  "InterpolatingFunction, ",
  ButtonBox["NumericalMath`NIntegrateInterpolatingFunct`",
    ButtonData:>{"NumericalMath`NIntegrateInterpolatingFunct`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InterpolatingFunction"],

Cell[TextData[{
  StyleBox["InterpolatingFunction", "MR"],
  ", ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InterpolatingFunction"],

Cell[TextData[{
  StyleBox["InterpolatingPolynomial", "MR"],
  ", ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InterpolatingPolynomial"],

Cell[TextData[{
  StyleBox["Interpolation", "MR"],
  ", ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Interpolation"],

Cell[TextData[{
  StyleBox["InterquartileRange", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InterquartileRange"],

Cell[TextData[{
  "Interval, confidence, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Interval, confidence"],

Cell[TextData[{
  StyleBox["IntervalBisection", "MR"],
  ", ",
  ButtonBox["NumericalMath`IntervalRoots`",
    ButtonData:>{"NumericalMath`IntervalRoots`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntervalBisection"],

Cell[TextData[{
  StyleBox["IntervalBoundaries", "MR"],
  ", ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntervalBoundaries"],

Cell[TextData[{
  StyleBox["IntervalCenters", "MR"],
  ", ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntervalCenters"],

Cell[TextData[{
  StyleBox["IntervalGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntervalGraph"],

Cell[TextData[{
  StyleBox["IntervalNewton", "MR"],
  ", ",
  ButtonBox["NumericalMath`IntervalRoots`",
    ButtonData:>{"NumericalMath`IntervalRoots`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntervalNewton"],

Cell[TextData[{
  StyleBox["IntervalRoots", "MR"],
  " package, ",
  ButtonBox["NumericalMath`IntervalRoots`",
    ButtonData:>{"NumericalMath`IntervalRoots`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntervalRoots package"],

Cell[TextData[{
  StyleBox["IntervalSecant", "MR"],
  ", ",
  ButtonBox["NumericalMath`IntervalRoots`",
    ButtonData:>{"NumericalMath`IntervalRoots`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IntervalSecant"],

Cell[TextData[{
  "Invariants, of graphs, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Invariants"],

Cell[TextData[{
  StyleBox["Invariants", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Invariants"],

Cell[TextData[{
  StyleBox["InverseDTFourierTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InverseDTFourierTransform"],

Cell[TextData[{
  StyleBox["InverseFourierCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InverseFourierCoefficient"],

Cell[TextData[{
  StyleBox["InverseMatrixNorm", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InverseMatrixNorm"],

Cell[TextData[{
  StyleBox["InversePermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InversePermutation"],

Cell[TextData[{
  StyleBox["InversionPoset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InversionPoset"],

Cell[TextData[{
  StyleBox["Inversions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Inversions"],

Cell[TextData[{
  StyleBox["InvolutionQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InvolutionQ"],

Cell[TextData[{
  StyleBox["Involutions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Involutions"],

Cell[TextData[{
  StyleBox["IonizationPotential", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IonizationPotential"],

Cell[TextData[{
  StyleBox["IrreduciblePolynomial", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IrreduciblePolynomial"],

Cell[TextData[{
  "Isolating intervals, ",
  ButtonBox["Algebra`RootIsolation`",
    ButtonData:>{"Algebra`RootIsolation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Isolating intervals"],

Cell[TextData[{
  StyleBox["IsomorphicQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IsomorphicQ"],

Cell[TextData[{
  StyleBox["Isomorphism", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Isomorphism"],

Cell[TextData[{
  StyleBox["IsomorphismQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"IsomorphismQ"],

Cell[TextData[{
  "Isomorphisms, between graphs, ",
  StyleBox["Isomorphism", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Isomorphisms"],

Cell[TextData[{
  "Isotopes, stable, ",
  StyleBox["StableIsotopes", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["JaccardDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"JaccardDissimilarity"],

Cell[TextData[{
  StyleBox["JackknifedVariance", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"JackknifedVariance"],

Cell[TextData[{
  StyleBox["JacobianDeterminant", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.39"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"JacobianDeterminant"],

Cell[TextData[{
  StyleBox["JacobianMatrix", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.39"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"JacobianMatrix"],

Cell[TextData[{
  StyleBox["JacobiSymbol", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.44"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"JacobiSymbol"],

Cell[TextData[{
  StyleBox["JewishNewYear", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"JewishNewYear"],

Cell[TextData[{
  StyleBox["Josephus", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Josephus"],

Cell[TextData[{
  StyleBox["JustMajor", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"JustMajor"],

Cell[TextData[{
  StyleBox["JustMinor", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["KendallRankCorrelation", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.52"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KendallRankCorrelation"],

Cell[TextData[{
  "Kernel initialization files, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Kernel initialization files"],

Cell[TextData[{
  "Keys on plots, ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Keys on plots"],

Cell[TextData[{
  "Keywords, ",
  ButtonBox["Utilities`Package`",
    ButtonData:>{"Utilities`Package`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Keywords"],

Cell[TextData[{
  StyleBox["KinematicViscosity", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KinematicViscosity"],

Cell[TextData[{
  StyleBox["KineticTemperature", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KineticTemperature"],

Cell[TextData[{
  StyleBox["KnightsTourGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KnightsTourGraph"],

Cell[TextData[{
  StyleBox["KnownStandardDeviation", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KnownStandardDeviation"],

Cell[TextData[{
  StyleBox["KnownVariance", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KnownVariance"],

Cell[TextData[{
  StyleBox["KroneckerSymbol", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KroneckerSymbol"],

Cell[TextData[{
  StyleBox["KSetPartitions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KSetPartitions"],

Cell[TextData[{
  StyleBox["KSubsetGroup", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KSubsetGroup"],

Cell[TextData[{
  StyleBox["KSubsetGroupIndex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KSubsetGroupIndex"],

Cell[TextData[{
  StyleBox["KSubsets", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"KSubsets"],

Cell[TextData[{
  StyleBox["Kurtosis", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Kurtosis"],

Cell[TextData[{
  StyleBox["KurtosisExcess", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["LabeledListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LabeledListPlot"],

Cell[TextData[{
  StyleBox["LabeledTreeToCode", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LabeledTreeToCode"],

Cell[TextData[{
  StyleBox["LabelPoints", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LabelPoints"],

Cell[TextData[{
  "Lagrangian, ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Lagrangian"],

Cell[TextData[{
  StyleBox["LaplaceDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LaplaceDistribution"],

Cell[TextData[{
  StyleBox["Laplacian", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Laplacian"],

Cell[TextData[{
  StyleBox["Large", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Large"],

Cell[TextData[{
  StyleBox["LastLexicographicTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LastLexicographicTableau"],

Cell[TextData[{
  "Latitude, ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Latitude"],

Cell[TextData[{
  "Least\[Hyphen]squares fitting, ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`TrigFit`",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Least-squares fitting"],

Cell[TextData[{
  StyleBox["LeastPrimeFactor", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LeastPrimeFactor"],

Cell[TextData[{
  StyleBox["LeftAssociates", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.27"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LeftAssociates"],

Cell[TextData[{
  StyleBox["LeftGCD", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LeftGCD"],

Cell[TextData[{
  StyleBox["Legend", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Legend"],

Cell[TextData[{
  StyleBox["LegendBackground", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendBackground"],

Cell[TextData[{
  StyleBox["LegendBorder", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendBorder"],

Cell[TextData[{
  StyleBox["LegendBorderSpace", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendBorderSpace"],

Cell[TextData[{
  StyleBox["LegendLabel", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendLabel"],

Cell[TextData[{
  StyleBox["LegendLabelSpace", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendLabelSpace"],

Cell[TextData[{
  StyleBox["LegendOrientation", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendOrientation"],

Cell[TextData[{
  StyleBox["LegendPosition", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendPosition"],

Cell[TextData[{
  "Legends on plots, ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Legends on plots"],

Cell[TextData[{
  StyleBox["Legends", "MR"],
  " package, ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Legends package"],

Cell[TextData[{
  StyleBox["LegendShadow", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendShadow"],

Cell[TextData[{
  StyleBox["LegendSize", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendSize"],

Cell[TextData[{
  StyleBox["LegendSpacing", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendSpacing"],

Cell[TextData[{
  StyleBox["LegendTextDirection", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendTextDirection"],

Cell[TextData[{
  StyleBox["LegendTextOffset", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendTextOffset"],

Cell[TextData[{
  StyleBox["LegendTextSpace", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LegendTextSpace"],

Cell[TextData[{
  StyleBox["LengthWhile", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LengthWhile"],

Cell[TextData[{
  "Lenstra\[CloseCurlyQuote]s elliptic curve method, ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Lenstra's elliptic curve method"],

Cell[TextData[{
  "Level, confidence, ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Level"],

Cell[TextData[{
  StyleBox["LeviGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LeviGraph"],

Cell[TextData[{
  StyleBox["LexicographicPermutations", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LexicographicPermutations"],

Cell[TextData[{
  StyleBox["LexicographicSubsets", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LexicographicSubsets"],

Cell[TextData[{
  StyleBox["lightsources", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"lightsources 3-Script command"],

Cell[TextData[{
  StyleBox["Limit", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Limit"],

Cell[TextData[{
  "Limits, numerical, ",
  StyleBox["NLimit", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Limits"],

Cell[TextData[{
  StyleBox["line", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"line 3-Script command"],

Cell[TextData[{
  "Linear equations, ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Linear equations"],

Cell[TextData[{
  "Linear regression, ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Linear regression"],

Cell[TextData[{
  StyleBox["LinearEquationsToMatrices", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LinearEquationsToMatrices"],

Cell[TextData[{
  StyleBox["LinearFilter", "MR"],
  ", ",
  ButtonBox["Statistics`DataSmoothing`",
    ButtonData:>{"Statistics`DataSmoothing`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LinearFilter"],

Cell[TextData[{
  StyleBox["LinearLogListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LinearLogListPlot"],

Cell[TextData[{
  StyleBox["LinearLogPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LinearLogPlot"],

Cell[TextData[{
  StyleBox["LinearRegression", "MR"],
  " package, ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LinearRegression package"],

Cell[TextData[{
  StyleBox["LineGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.55"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LineGraph"],

Cell[TextData[{
  "Lines, plotting, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Lines"],

Cell[TextData[{
  StyleBox["ListContourPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListContourPlot3D"],

Cell[TextData[{
  StyleBox["ListGraphs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListGraphs"],

Cell[TextData[{
  StyleBox["ListIntegrate", "MR"],
  ", ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListIntegrate"],

Cell[TextData[{
  StyleBox["ListIntegrate", "MR"],
  " package, ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListIntegrate package"],

Cell[TextData[{
  StyleBox["ListNecklaces", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListNecklaces"],

Cell[TextData[{
  StyleBox["ListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListPlot"],

Cell[TextData[{
  "filling between curves in, ",
  StyleBox["FilledListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " \nfor multiple lists, ",
  StyleBox["MultipleListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nfor three\[Hyphen]dimensional vectors, ",
  StyleBox["ListPlotVectorField3D", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " \nfor triangulated surfaces, ",
  StyleBox["TriangularSurfacePlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \nin three dimensions, ",
  StyleBox["ScatterPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"ListPlot"],

Cell[TextData[{
  StyleBox["ListPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListPlot3D"],

Cell[TextData[{
  "with shadows, ",
  StyleBox["ListShadowPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"ListPlot3D"],

Cell[TextData[{
  StyleBox["ListPlotVectorField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListPlotVectorField"],

Cell[TextData[{
  StyleBox["ListPlotVectorField3D", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListPlotVectorField3D"],

Cell[TextData[{
  "Lists, adjacency, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Lists"],

Cell[TextData[{
  "manipulation of, ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Lists"],

Cell[TextData[{
  StyleBox["ListShadowPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListShadowPlot3D"],

Cell[TextData[{
  StyleBox["ListSurfaceOfRevolution", "MR"],
  ", ",
  ButtonBox["Graphics`SurfaceOfRevolution`",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListSurfaceOfRevolution"],

Cell[TextData[{
  StyleBox["ListSurfacePlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListSurfacePlot3D"],

Cell[TextData[{
  StyleBox["ListWaveform", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ListWaveform"],

Cell[TextData[{
  StyleBox["LNorm", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LNorm"],

Cell[TextData[{
  "Loading, of packages automatically, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Loading"],

Cell[TextData[{
  "Loading packages, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.4", "4.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Loading packages"],

Cell[TextData[{
  StyleBox["LocationReport", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LocationReport"],

Cell[TextData[{
  StyleBox["LogisticDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogisticDistribution"],

Cell[TextData[{
  StyleBox["LogLinearListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogLinearListPlot"],

Cell[TextData[{
  StyleBox["LogLinearPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogLinearPlot"],

Cell[TextData[{
  StyleBox["LogListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogListPlot"],

Cell[TextData[{
  StyleBox["LogLogListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogLogListPlot"],

Cell[TextData[{
  StyleBox["LogLogPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogLogPlot"],

Cell[TextData[{
  StyleBox["LogNormalDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogNormalDistribution"],

Cell[TextData[{
  StyleBox["LogPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogPlot"],

Cell[TextData[{
  StyleBox["LogSeriesDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LogSeriesDistribution"],

Cell[TextData[{
  StyleBox["LongDash", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LongDash"],

Cell[TextData[{
  StyleBox["LongestIncreasingSubsequence", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LongestIncreasingSubsequence"],

Cell[TextData[{
  "Longitude, ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Longitude"],

Cell[TextData[{
  StyleBox["LoopPosition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LoopPosition"],

Cell[TextData[{
  StyleBox["LowerDiagonalMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LowerDiagonalMatrix"],

Cell[TextData[{
  StyleBox["LowerLeft", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LowerLeft"],

Cell[TextData[{
  StyleBox["LowerRight", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LowerRight"],

Cell[TextData[{
  StyleBox["LowerStatisticalWeight", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LowerStatisticalWeight"],

Cell[TextData[{
  StyleBox["LowerTermFineStructureEnergy", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LowerTermFineStructureEnergy"],

Cell[TextData[{
  "LUDecomposition, ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"LUDecomposition"],

Cell[TextData[{
  StyleBox["LUMatrices", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["M", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.36"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"M"],

Cell[TextData[{
  "Machine arithmetic, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Machine arithmetic"],

Cell[TextData[{
  StyleBox["MachineError", "MR"],
  ", ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MachineError"],

Cell[TextData[{
  StyleBox["MagneticFluxQuantum", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MagneticFluxQuantum"],

Cell[TextData[{
  "Mahalanobis distance, ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Mahalanobis distance"],

Cell[TextData[{
  StyleBox["MakeDirected", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MakeDirected"],

Cell[TextData[{
  StyleBox["MakeGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.76"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MakeGraph"],

Cell[TextData[{
  StyleBox["MakeSimple", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MakeSimple"],

Cell[TextData[{
  StyleBox["MakeSymbol", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MakeSymbol"],

Cell[TextData[{
  StyleBox["MakeTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MakeTree"],

Cell[TextData[{
  StyleBox["MakeUndirected", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MakeUndirected"],

Cell[TextData[{
  StyleBox["ManhattanDistance", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"ManhattanDistance"],

Cell[TextData[{
  "Manipulation of data, ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Manipulation of data"],

Cell[TextData[{
  "Manipulation of matrices, ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Manipulation of matrices"],

Cell[TextData[{
  "Manipulation of polynomials over finite fields, ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Manipulation of polynomials over finite fields"],

Cell[TextData[{
  "Manipulation of trees, ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Manipulation of trees"],

Cell[TextData[{
  "Mappings, functions as, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Mappings"],

Cell[TextData[{
  "Maps, geographical, ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Maps"],

Cell[TextData[{
  "Markings, on axes, ",
  StyleBox["Ticks", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Markings"],

Cell[TextData[{
  StyleBox["MatchingDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"MatchingDissimilarity"],

Cell[TextData[{
  StyleBox["MathematicaMark", "MR"],
  ", ",
  ButtonBox["Utilities`Benchmark`",
    ButtonData:>{"Utilities`Benchmark`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MathematicaMark"],

Cell[TextData[{
  "Matrices, three\[Hyphen]dimensional rotation, ",
  StyleBox["RotationMatrix3D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Matrices"],

Cell[TextData[{
  "two\[Hyphen]dimensional rotation, ",
  StyleBox["RotationMatrix2D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nadjacency, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " \ncomposition of, ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ndesign, ",
  StyleBox["DesignMatrix", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  " \nHankel, ",
  StyleBox["HankelMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " \nHilbert, ",
  StyleBox["HilbertMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " \nlower diagonal, ",
  StyleBox["LowerDiagonalMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " \nnorm of inverse, ",
  StyleBox["InverseMatrixNorm", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " \nspecial, ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntesting for square, ",
  StyleBox["SquareMatrixQ", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " \ntridiagonal, ",
  ButtonBox["LinearAlgebra`Tridiagonal`",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " \nupper diagonal, ",
  StyleBox["UpperDiagonalMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " \nzero, ",
  StyleBox["ZeroMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Matrices"],

Cell[TextData[{
  "Matrix scatter plot, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Matrix scatter plot"],

Cell[TextData[{
  "matrix scatter plot, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"matrix scatter plot"],

Cell[TextData[{
  StyleBox["MatrixConditionNumber", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MatrixConditionNumber"],

Cell[TextData[{
  StyleBox["MatrixManipulation", "MR"],
  " package, ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Appendix: Functions Moved to the Kernel",
    ButtonData:>{"6.17.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MatrixManipulation package"],

Cell[TextData[{
  StyleBox["MatrixPlot", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MatrixPlot"],

Cell[TextData[{
  StyleBox["MaxArrowLength", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxArrowLength"],

Cell[TextData[{
  StyleBox["MaxBend", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxBend"],

Cell[TextData[{
  StyleBox["MaximalBipartiteMatching", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaximalBipartiteMatching"],

Cell[TextData[{
  StyleBox["MaximalIndependentEdgeSet", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaximalIndependentEdgeSet"],

Cell[TextData[{
  StyleBox["MaximalIndependentVertexSet", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaximalIndependentVertexSet"],

Cell[TextData[{
  StyleBox["MaximalMatching", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaximalMatching"],

Cell[TextData[{
  "Maximum likelihood estimate, of covariance, ",
  StyleBox["CovarianceMLE", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Maximum likelihood estimate"],

Cell[TextData[{
  "of covariance matrix, ",
  StyleBox["CovarianceMatrixMLE", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " \nof standard deviation, ",
  StyleBox["StandardDeviationMLE", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " \nof variance, ",
  StyleBox["VarianceMLE", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Maximum likelihood estimate"],

Cell[TextData[{
  StyleBox["MaximumAntichain", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaximumAntichain"],

Cell[TextData[{
  StyleBox["MaximumClique", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaximumClique"],

Cell[TextData[{
  StyleBox["MaximumIndependentSet", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaximumIndependentSet"],

Cell[TextData[{
  StyleBox["MaximumSpanningTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaximumSpanningTree"],

Cell[TextData[{
  StyleBox["MaxIterations", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxIterations"],

Cell[TextData[{
  StyleBox["MaxMatrixSize", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxMatrixSize"],

Cell[TextData[{
  StyleBox["MaxPower", "MR"],
  ", ",
  ButtonBox["Miscellaneous`BlackBodyRadiation`",
    ButtonData:>{"Miscellaneous`BlackBodyRadiation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxPower"],

Cell[TextData[{
  StyleBox["MaxRecursion", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxRecursion"],

Cell[TextData[{
  StyleBox["MaxTerms", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MaxTerms"],

Cell[TextData[{
  StyleBox["McGeeGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"McGeeGraph"],

Cell[TextData[{
  StyleBox["Mean", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Mean"],

Cell[TextData[{
  StyleBox["MeanChromatic", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanChromatic"],

Cell[TextData[{
  StyleBox["MeanCI", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanCI"],

Cell[TextData[{
  StyleBox["MeanDensity", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanDensity"],

Cell[TextData[{
  StyleBox["MeanDeviation", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanDeviation"],

Cell[TextData[{
  StyleBox["MeanDifferenceCI", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanDifferenceCI"],

Cell[TextData[{
  StyleBox["MeanDifferenceTest", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanDifferenceTest"],

Cell[TextData[{
  StyleBox["MeanFreePath", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanFreePath"],

Cell[TextData[{
  StyleBox["MeanMajor", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanMajor"],

Cell[TextData[{
  StyleBox["MeanMinor", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanMinor"],

Cell[TextData[{
  StyleBox["MeanMolecularWeight", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanMolecularWeight"],

Cell[TextData[{
  StyleBox["MeanParticleSpeed", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanParticleSpeed"],

Cell[TextData[{
  StyleBox["MeanPredictionCITable", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanPredictionCITable"],

Cell[TextData[{
  StyleBox["MeanTest", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeanTest"],

Cell[TextData[{
  "Median, multivariate, ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Median"],

Cell[TextData[{
  StyleBox["Median", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Median"],

Cell[TextData[{
  StyleBox["MedianDeviation", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MedianDeviation"],

Cell[TextData[{
  StyleBox["MedianMethod", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.46"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MedianMethod"],

Cell[TextData[{
  StyleBox["MeltingPoint", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ChemicalElements`",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeltingPoint"],

Cell[TextData[{
  "Memory management, ",
  ButtonBox["Utilities`MemoryConserve`",
    ButtonData:>{"Utilities`MemoryConserve`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Memory management"],

Cell[TextData[{
  StyleBox["MemoryConserve", "MR"],
  " package, ",
  ButtonBox["Utilities`MemoryConserve`",
    ButtonData:>{"Utilities`MemoryConserve`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MemoryConserve package"],

Cell[TextData[{
  StyleBox["MeredithGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeredithGraph"],

Cell[TextData[{
  StyleBox["mesh", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"mesh 3-Script command"],

Cell[TextData[{
  StyleBox["MeshRange", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MeshRange"],

Cell[TextData[{
  StyleBox["Method", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Method"],

Cell[TextData[{
  StyleBox["Microscope", "MR"],
  ", ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Microscope"],

Cell[TextData[{
  StyleBox["Microscope", "MR"],
  " package, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Microscope package"],

Cell[TextData[{
  StyleBox["MicroscopicError", "MR"],
  ", ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MicroscopicError"],

Cell[TextData[{
  StyleBox["MinCut", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MinCut"],

Cell[TextData[{
  "Minimax approximation, ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Minimax approximation"],

Cell[TextData[{
  StyleBox["MiniMaxApproximation", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MiniMaxApproximation"],

Cell[TextData[{
  StyleBox["MinimumChainPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MinimumChainPartition"],

Cell[TextData[{
  StyleBox["MinimumChangePermutations", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MinimumChangePermutations"],

Cell[TextData[{
  StyleBox["MinimumSpanningTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.86"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MinimumSpanningTree"],

Cell[TextData[{
  StyleBox["MinimumVertexColoring", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MinimumVertexColoring"],

Cell[TextData[{
  StyleBox["MinimumVertexCover", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MinimumVertexCover"],

Cell[TextData[{
  StyleBox["MixedMode", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MixedMode"],

Cell[TextData[{
  StyleBox["MKS", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MKS"],

Cell[TextData[{
  StyleBox["MLE", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MLE"],

Cell[TextData[{
  StyleBox["Mod", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Mod"],

Cell[TextData[{
  StyleBox["Mode", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Mode"],

Cell[TextData[{
  "Modular equations, ",
  StyleBox["ChineseRemainder", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Modular equations"],

Cell[TextData[{
  "Modulation, amplitude, ",
  StyleBox["AmplitudeModulation", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Modulation"],

Cell[TextData[{
  "frequency, ",
  StyleBox["FrequencyModulation", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Modulation"],

Cell[TextData[{
  StyleBox["ModulationType", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ModulationType"],

Cell[TextData[{
  StyleBox["Modulus", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Modulus"],

Cell[TextData[{
  StyleBox["MoebiusStrip", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MoebiusStrip"],

Cell[TextData[{
  StyleBox["MolarGasConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MolarGasConstant"],

Cell[TextData[{
  StyleBox["MolarVolume", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MolarVolume"],

Cell[TextData[{
  StyleBox["MovieContourPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MovieContourPlot"],

Cell[TextData[{
  StyleBox["MovieDensityPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MovieDensityPlot"],

Cell[TextData[{
  StyleBox["MovieParametricPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MovieParametricPlot"],

Cell[TextData[{
  StyleBox["MoviePlot", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MoviePlot"],

Cell[TextData[{
  StyleBox["MoviePlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MoviePlot3D"],

Cell[TextData[{
  StyleBox["MovingAverage", "MR"],
  ", ",
  ButtonBox["Statistics`DataSmoothing`",
    ButtonData:>{"Statistics`DataSmoothing`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MovingAverage"],

Cell[TextData[{
  StyleBox["MovingMedian", "MR"],
  ", ",
  ButtonBox["Statistics`DataSmoothing`",
    ButtonData:>{"Statistics`DataSmoothing`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MovingMedian"],

Cell[TextData[{
  StyleBox["MultiDescriptiveStatistics", "MR"],
  " package, ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultiDescriptiveStatistics package"],

Cell[TextData[{
  StyleBox["MultiDiscreteDistributions", "MR"],
  " package, ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultiDiscreteDistributions package"],

Cell[TextData[{
  StyleBox["Multinomial", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Multinomial"],

Cell[TextData[{
  StyleBox["MultinomialDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultinomialDistribution"],

Cell[TextData[{
  StyleBox["MultinormalDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultinormalDistribution"],

Cell[TextData[{
  StyleBox["MultinormalDistribution", "MR"],
  " package, ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultinormalDistribution package"],

Cell[TextData[{
  "Multiple curves, area between, ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Multiple curves"],

Cell[TextData[{
  "Multiple\[Hyphen]valued functions, ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Multiple-valued functions"],

Cell[TextData[{
  StyleBox["MultipleEdgesQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultipleEdgesQ"],

Cell[TextData[{
  StyleBox["MultipleListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultipleListPlot"],

Cell[TextData[{
  StyleBox["MultipleListPlot", "MR"],
  " package, ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultipleListPlot package"],

Cell[TextData[{
  "Multiplication, noncommutative, ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Multiplication"],

Cell[TextData[{
  StyleBox["MultiplicationTable", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultiplicationTable"],

Cell[TextData[{
  StyleBox["MultiPoissonDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultiPoissonDistribution"],

Cell[TextData[{
  "Multivariate statistical distributions, ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Multivariate statistical distributions"],

Cell[TextData[{
  StyleBox["MultivariateKurtosis", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateKurtosis"],

Cell[TextData[{
  StyleBox["MultivariateKurtosisExcess", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateKurtosisExcess"],

Cell[TextData[{
  StyleBox["MultivariateMeanDeviation", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateMeanDeviation"],

Cell[TextData[{
  StyleBox["MultivariateMedianDeviation", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateMedianDeviation"],

Cell[TextData[{
  StyleBox["MultivariateMode", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateMode"],

Cell[TextData[{
  StyleBox["MultivariatePearsonSkewness1", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariatePearsonSkewness1"],

Cell[TextData[{
  StyleBox["MultivariatePearsonSkewness2", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariatePearsonSkewness2"],

Cell[TextData[{
  StyleBox["MultivariateSkewness", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.62"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateSkewness"],

Cell[TextData[{
  StyleBox["MultivariateTDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateTDistribution"],

Cell[TextData[{
  StyleBox["MultivariateTrimmedMean", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MultivariateTrimmedMean"],

Cell[TextData[{
  StyleBox["MuonGFactor", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MuonGFactor"],

Cell[TextData[{
  StyleBox["MuonMagneticMoment", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MuonMagneticMoment"],

Cell[TextData[{
  StyleBox["MuonMass", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MuonMass"],

Cell[TextData[{
  StyleBox["Music", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Music package"],

Cell[TextData[{
  StyleBox["MycielskiGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"MycielskiGraph"],

Cell[TextData[{
  StyleBox["myPackage1.m", "MR"],
  " example of package, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"myPackage1.m example of package"],

Cell[TextData[{
  StyleBox["myPackage2.m", "MR"],
  " example of package, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  "Names, of symbols, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Names"],

Cell[TextData[{
  "removing, ",
  StyleBox["Remove", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " \nshadowing of, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " \nshort, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Names"],

Cell[TextData[{
  "Names files, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Names files"],

Cell[TextData[{
  StyleBox["NaN", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NaN"],

Cell[TextData[{
  StyleBox["ND", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ND"],

Cell[TextData[{
  StyleBox["NDTFourierTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NDTFourierTransform"],

Cell[TextData[{
  StyleBox["NearestNeighbor", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NearestNeighbor"],

Cell[TextData[{
  StyleBox["NecklacePolynomial", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NecklacePolynomial"],

Cell[TextData[{
  StyleBox["Needs", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Needs"],

Cell[TextData[{
  StyleBox["NegativeBinomialDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NegativeBinomialDistribution"],

Cell[TextData[{
  StyleBox["NegativeMultinomialDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NegativeMultinomialDistribution"],

Cell[TextData[{
  StyleBox["Neighborhood", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Neighborhood"],

Cell[TextData[{
  "Neighborhood polygons, diagrams of, ",
  StyleBox["VoronoiDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Neighborhood polygons"],

Cell[TextData[{
  StyleBox["NetworkFlow", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.88"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NetworkFlow"],

Cell[TextData[{
  StyleBox["NeutronComptonWavelength", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NeutronComptonWavelength"],

Cell[TextData[{
  StyleBox["NeutronMagneticMoment", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NeutronMagneticMoment"],

Cell[TextData[{
  StyleBox["NeutronMass", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NeutronMass"],

Cell[TextData[{
  "Newton\[Hyphen]Cotes quadrature, ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Newton-Cotes quadrature"],

Cell[TextData[{
  StyleBox["NewtonCotes", "MR"],
  " package, ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NewtonCotes package"],

Cell[TextData[{
  StyleBox["NewtonCotesError", "MR"],
  ", ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NewtonCotesError"],

Cell[TextData[{
  StyleBox["NewtonCotesWeights", "MR"],
  ", ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NewtonCotesWeights"],

Cell[TextData[{
  StyleBox["NextBinarySubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextBinarySubset"],

Cell[TextData[{
  StyleBox["NextComposition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextComposition"],

Cell[TextData[{
  StyleBox["NextGrayCodeSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextGrayCodeSubset"],

Cell[TextData[{
  StyleBox["NextKSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextKSubset"],

Cell[TextData[{
  StyleBox["NextLexicographicSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextLexicographicSubset"],

Cell[TextData[{
  StyleBox["NextPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextPartition"],

Cell[TextData[{
  StyleBox["NextPermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextPermutation"],

Cell[TextData[{
  StyleBox["NextPrime", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextPrime"],

Cell[TextData[{
  StyleBox["NextSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextSubset"],

Cell[TextData[{
  StyleBox["NextTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NextTableau"],

Cell[TextData[{
  StyleBox["NFourierCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierCoefficient"],

Cell[TextData[{
  StyleBox["NFourierCosCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierCosCoefficient"],

Cell[TextData[{
  StyleBox["NFourierCosTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierCosTransform"],

Cell[TextData[{
  StyleBox["NFourierSeries", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierSeries"],

Cell[TextData[{
  StyleBox["NFourierSinCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierSinCoefficient"],

Cell[TextData[{
  StyleBox["NFourierSinTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierSinTransform"],

Cell[TextData[{
  StyleBox["NFourierTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierTransform"],

Cell[TextData[{
  StyleBox["NFourierTrigSeries", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NFourierTrigSeries"],

Cell[TextData[{
  "NIntegrate, ",
  StyleBox["Integration:numerical", "MR"],
  ", ",
  ButtonBox["NumericalMath`NIntegrateInterpolatingFunct`",
    ButtonData:>{"NumericalMath`NIntegrateInterpolatingFunct`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NIntegrate"],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  ", ",
  ButtonBox["NumericalMath`CauchyPrincipalValue`",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NIntegrate"],

Cell[TextData[{
  StyleBox["NIntegrateInterpolatingFunct", "MR"],
  " package, ",
  ButtonBox["NumericalMath`NIntegrateInterpolatingFunct`",
    ButtonData:>{"NumericalMath`NIntegrateInterpolatingFunct`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NIntegrateInterpolatingFunct package"],

Cell[TextData[{
  StyleBox["NIntegrateInterpolatingFunction", "MR"],
  ", ",
  ButtonBox["NumericalMath`NIntegrateInterpolatingFunct`",
    ButtonData:>{"NumericalMath`NIntegrateInterpolatingFunct`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NIntegrateInterpolatingFunction"],

Cell[TextData[{
  StyleBox["NInverseDTFourierTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NInverseDTFourierTransform"],

Cell[TextData[{
  StyleBox["NInverseFourierCoefficient", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NInverseFourierCoefficient"],

Cell[TextData[{
  StyleBox["NInverseFourierCosTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NInverseFourierCosTransform"],

Cell[TextData[{
  StyleBox["NInverseFourierSinTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NInverseFourierSinTransform"],

Cell[TextData[{
  StyleBox["NInverseFourierTransform", "MR"],
  ", ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NInverseFourierTransform"],

Cell[TextData[{
  StyleBox["NLimit", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NLimit"],

Cell[TextData[{
  StyleBox["NLimit", "MR"],
  " package, ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NLimit package"],

Cell[TextData[{
  StyleBox["NMinimize", "MR"],
  " package, ",
  ButtonBox["Appendix: Functions Moved to the Kernel",
    ButtonData:>{"6.17.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NMinimize package"],

Cell[TextData[{
  "Nodes, in trees, ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Nodes"],

Cell[TextData[{
  StyleBox["NoMultipleEdges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NoMultipleEdges"],

Cell[TextData[{
  StyleBox["Nonagon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Nonagon"],

Cell[TextData[{
  StyleBox["NoncentralChiSquareDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NoncentralChiSquareDistribution"],

Cell[TextData[{
  StyleBox["NoncentralFRatioDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NoncentralFRatioDistribution"],

Cell[TextData[{
  StyleBox["NoncentralStudentTDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NoncentralStudentTDistribution"],

Cell[TextData[{
  "Nonlinear regression, ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Nonlinear regression"],

Cell[TextData[{
  StyleBox["NonlinearFit", "MR"],
  ", ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NonlinearFit"],

Cell[TextData[{
  StyleBox["NonlinearFit", "MR"],
  " package, ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Appendix: Functions Moved to the Kernel",
    ButtonData:>{"6.17.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NonlinearFit package"],

Cell[TextData[{
  StyleBox["NonlinearRegress", "MR"],
  ", ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NonlinearRegress"],

Cell[TextData[{
  StyleBox["NonLineGraphs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NonLineGraphs"],

Cell[TextData[{
  StyleBox["Nonreal", "MR"],
  ", ",
  ButtonBox["Miscellaneous`RealOnly`",
    ButtonData:>{"Miscellaneous`RealOnly`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Nonreal"],

Cell[TextData[{
  StyleBox["NoPerfectMatchingGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NoPerfectMatchingGraph"],

Cell[TextData[{
  StyleBox["Norm", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Norm"],

Cell[TextData[{
  StyleBox["Normal", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Normal"],

Cell[TextData[{
  StyleBox["NormalCI", "MR"],
  ", ",
  ButtonBox["Statistics`ConfidenceIntervals`",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NormalCI"],

Cell[TextData[{
  StyleBox["NormalDashed", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NormalDashed"],

Cell[TextData[{
  StyleBox["NormalDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NormalDistribution"],

Cell[TextData[{
  StyleBox["NormalDistribution", "MR"],
  " package, ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NormalDistribution package"],

Cell[TextData[{
  StyleBox["Normalize", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Normalize"],

Cell[TextData[{
  StyleBox["Normalized", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Normalized"],

Cell[TextData[{
  StyleBox["NormalizeVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NormalizeVertices"],

Cell[TextData[{
  StyleBox["NormalPValue", "MR"],
  ", ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NormalPValue"],

Cell[TextData[{
  StyleBox["NoSelfLoops", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NoSelfLoops"],

Cell[TextData[{
  "Not\[Hyphen]a\[Hyphen]Number, ",
  StyleBox["NaN", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Not-a-Number"],

Cell[TextData[{
  "NResidue, ",
  ButtonBox["NumericalMath`NResidue`",
    ButtonData:>{"NumericalMath`NResidue`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NResidue"],

Cell[TextData[{
  StyleBox["NResidue", "MR"],
  ", ",
  ButtonBox["NumericalMath`NResidue`",
    ButtonData:>{"NumericalMath`NResidue`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NResidue"],

Cell[TextData[{
  StyleBox["NResidue", "MR"],
  " package, ",
  ButtonBox["NumericalMath`NResidue`",
    ButtonData:>{"NumericalMath`NResidue`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NResidue package"],

Cell[TextData[{
  StyleBox["NSeries", "MR"],
  ", ",
  ButtonBox["NumericalMath`NSeries`",
    ButtonData:>{"NumericalMath`NSeries`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NSeries"],

Cell[TextData[{
  StyleBox["NSeries", "MR"],
  " package, ",
  ButtonBox["NumericalMath`NSeries`",
    ButtonData:>{"NumericalMath`NSeries`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NSeries package"],

Cell[TextData[{
  StyleBox["NSum", "MR"],
  ", ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NSum"],

Cell[TextData[{
  StyleBox["NthSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NthSubset"],

Cell[TextData[{
  "Null hypothesis, ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Null hypothesis"],

Cell[TextData[{
  "Number system, generalized, ",
  ButtonBox["Miscellaneous`Calendar`",
    ButtonData:>{"Miscellaneous`Calendar`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Number system"],

Cell[TextData[{
  StyleBox["NumberDensity", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberDensity"],

Cell[TextData[{
  StyleBox["NumberOf2Paths", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOf2Paths"],

Cell[TextData[{
  StyleBox["NumberOfCompositions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfCompositions"],

Cell[TextData[{
  StyleBox["NumberOfDerangements", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfDerangements"],

Cell[TextData[{
  StyleBox["NumberOfDirectedGraphs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfDirectedGraphs"],

Cell[TextData[{
  StyleBox["NumberOfEdges", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfEdges"],

Cell[TextData[{
  StyleBox["NumberOfFaces", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfFaces"],

Cell[TextData[{
  StyleBox["NumberOfGraphs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfGraphs"],

Cell[TextData[{
  StyleBox["NumberOfInvolutions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfInvolutions"],

Cell[TextData[{
  StyleBox["NumberOfKPaths", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfKPaths"],

Cell[TextData[{
  StyleBox["NumberOfNecklaces", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfNecklaces"],

Cell[TextData[{
  StyleBox["NumberOfPartitions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfPartitions"],

Cell[TextData[{
  StyleBox["NumberOfPermutationsByCycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfPermutationsByCycles"],

Cell[TextData[{
  StyleBox["NumberOfPermutationsByInversions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfPermutationsByInversions"],

Cell[TextData[{
  StyleBox["NumberOfPermutationsByType", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfPermutationsByType"],

Cell[TextData[{
  StyleBox["NumberOfSpanningTrees", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.87"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfSpanningTrees"],

Cell[TextData[{
  StyleBox["NumberOfTableaux", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfTableaux"],

Cell[TextData[{
  StyleBox["NumberOfVertices", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberOfVertices"],

Cell[TextData[{
  "Numbers, functions of complex, ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Numbers"],

Cell[TextData[{
  StyleBox["NumberTheoryFunctions", "MR"],
  " package, ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"NumberTheoryFunctions package"],

Cell[TextData[{
  "Numerical Fourier functions, ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Numerical Fourier functions"],

Cell[TextData[{
  "Numerical Fourier transforms, ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Numerical Fourier transforms"],

Cell[TextData[{
  StyleBox["NVariationalBound", "MR"],
  ", ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["OblateSpheroidal", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OblateSpheroidal"],

Cell[TextData[{
  StyleBox["Octagon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Octagon"],

Cell[TextData[{
  StyleBox["OctahedralGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OctahedralGraph"],

Cell[TextData[{
  StyleBox["Octahedron", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Octahedron"],

Cell[TextData[{
  StyleBox["OddGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OddGraph"],

Cell[TextData[{
  StyleBox["OddQ", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OddQ"],

Cell[TextData[{
  StyleBox["One", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"One"],

Cell[TextData[{
  StyleBox["OpenTruncate", "MR"],
  ", ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OpenTruncate"],

Cell[TextData[{
  StyleBox["Optimum", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Optimum"],

Cell[TextData[{
  "Options, selecting, ",
  StyleBox["FilterOptions", "MR"],
  ", ",
  ButtonBox["Utilities`FilterOptions`",
    ButtonData:>{"Utilities`FilterOptions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Options"],

Cell[TextData[{
  StyleBox["OrbitInventory", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrbitInventory"],

Cell[TextData[{
  StyleBox["OrbitRepresentatives", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrbitRepresentatives"],

Cell[TextData[{
  StyleBox["Orbits", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Orbits"],

Cell[TextData[{
  "Order, of Butcher tree, ",
  StyleBox["ButcherOrder", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Order"],

Cell[TextData[{
  "Order conditions, Runge\[Hyphen]Kutta, ",
  StyleBox["RungeKuttaOrderConditions", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Order conditions"],

Cell[TextData[{
  StyleBox["Ordered", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Ordered"],

Cell[TextData[{
  StyleBox["OrderedSumOfSquaresRepresentations", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderedSumOfSquaresRepresentations"],

Cell[TextData[{
  StyleBox["OrderStar", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStar"],

Cell[TextData[{
  StyleBox["OrderStar", "MR"],
  " package, ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStar package"],

Cell[TextData[{
  StyleBox["OrderStarInterpolation", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarInterpolation"],

Cell[TextData[{
  StyleBox["OrderStarKind", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarKind"],

Cell[TextData[{
  StyleBox["OrderStarLegend", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarLegend"],

Cell[TextData[{
  StyleBox["OrderStarPoles", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarPoles"],

Cell[TextData[{
  StyleBox["OrderStarSubPlots", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarSubPlots"],

Cell[TextData[{
  StyleBox["OrderStarSymbolSize", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarSymbolSize"],

Cell[TextData[{
  StyleBox["OrderStarSymbolThickness", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarSymbolThickness"],

Cell[TextData[{
  StyleBox["OrderStarZeros", "MR"],
  ", ",
  ButtonBox["NumericalMath`OrderStar`",
    ButtonData:>{"NumericalMath`OrderStar`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrderStarZeros"],

Cell[TextData[{
  "Ordinary differential equations, numerical, ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Ordinary differential equations"],

Cell[TextData[{
  "Organization, of information, ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Organization"],

Cell[TextData[{
  StyleBox["OrientGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OrientGraph"],

Cell[TextData[{
  "Orthogonal basis, ",
  StyleBox["GramSchmidt", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Orthogonal basis"],

Cell[TextData[{
  "Orthogonal coordinates, ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Orthogonal coordinates"],

Cell[TextData[{
  StyleBox["Orthogonalization", "MR"],
  " package, ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Orthogonalization package"],

Cell[TextData[{
  "Orthonormal basis, ",
  StyleBox["GramSchmidt", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Orthonormal basis"],

Cell[TextData[{
  StyleBox["Householder", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Orthonormal basis"],

Cell[TextData[{
  StyleBox["OscillatorStrength", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OscillatorStrength"],

Cell[TextData[{
  StyleBox["OutDegree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"OutDegree"],

Cell[TextData[{
  "Outlier detection, ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Outlier detection"],

Cell[TextData[{
  "outliers, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"outliers"],

Cell[TextData[{
  StyleBox["Overtones", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["Package", "MR"],
  " package, ",
  ButtonBox["Utilities`Package`",
    ButtonData:>{"Utilities`Package`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Package package"],

Cell[TextData[{
  "Packages, automatic loading of, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Packages"],

Cell[TextData[{
  "auxiliary, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.3"},
    ButtonStyle->"AddOnsLink"],
  " \nfile extension, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.4", "4.1"},
    ButtonStyle->"AddOnsLink"],
  " \nfunctions moved to kernel, ",
  ButtonBox["Appendix: Functions Moved to the Kernel",
    ButtonData:>{"6.17.1", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nin the same directory, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.4"},
    ButtonStyle->"AddOnsLink"],
  " \nlist of loaded, ",
  StyleBox["$Packages", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.2"},
    ButtonStyle->"AddOnsLink"],
  " \nlocation of files for, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.9"},
    ButtonStyle->"AddOnsLink"],
  " \nreading in, ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.1", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.3"},
    ButtonStyle->"AddOnsLink"],
  " \nsearching, ",
  ButtonBox["Utilities`Package`",
    ButtonData:>{"Utilities`Package`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nwriting, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Packages"],

Cell[TextData[{
  StyleBox["Pade", "MR"],
  ", ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pade"],

Cell[TextData[{
  "Pad\[EAcute] approximation, ",
  StyleBox["Pade", "MR"],
  ", ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pade approximation"],

Cell[TextData[{
  StyleBox["Pade", "MR"],
  " package, ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pade package"],

Cell[TextData[{
  StyleBox["PairGroup", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PairGroup"],

Cell[TextData[{
  StyleBox["PairGroupIndex", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PairGroupIndex"],

Cell[TextData[{
  "Pairs scatter plot, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pairs scatter plot"],

Cell[TextData[{
  "pairs scatter plot, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"pairs scatter plot"],

Cell[TextData[{
  StyleBox["PairwiseScatterPlot", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PairwiseScatterPlot"],

Cell[TextData[{
  StyleBox["ParabolicCylindrical", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParabolicCylindrical"],

Cell[TextData[{
  StyleBox["Paraboloidal", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Paraboloidal"],

Cell[TextData[{
  StyleBox["Parallel", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Parallel"],

Cell[TextData[{
  StyleBox["ParameterBias", "MR"],
  ", ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParameterBias"],

Cell[TextData[{
  StyleBox["ParameterCITable", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParameterCITable"],

Cell[TextData[{
  StyleBox["ParameterConfidenceRegion", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParameterConfidenceRegion"],

Cell[TextData[{
  StyleBox["ParameterQ", "MR"],
  ", ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParameterQ"],

Cell[TextData[{
  StyleBox["ParameterRanges", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParameterRanges"],

Cell[TextData[{
  StyleBox["Parameters", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Parameters"],

Cell[TextData[{
  "Parameters of complete integrals, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Parameters of complete integrals"],

Cell[TextData[{
  StyleBox["ParameterTable", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParameterTable"],

Cell[TextData[{
  StyleBox["ParametricPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParametricPlot"],

Cell[TextData[{
  StyleBox["ParametricPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParametricPlot3D"],

Cell[TextData[{
  StyleBox["ParametricPlot3D", "MR"],
  " package, ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParametricPlot3D package"],

Cell[TextData[{
  StyleBox["Parent", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Parent"],

Cell[TextData[{
  StyleBox["ParentsToPaths", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParentsToPaths"],

Cell[TextData[{
  StyleBox["ParetoDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParetoDistribution"],

Cell[TextData[{
  StyleBox["ParetoPlot", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ParetoPlot"],

Cell[TextData[{
  "Partial derivatives, plotting, ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Partial derivatives"],

Cell[TextData[{
  "Partial differential equations, ",
  ButtonBox["Calculus`DSolveIntegrals`",
    ButtonData:>{"Calculus`DSolveIntegrals`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Partial differential equations"],

Cell[TextData[{
  StyleBox["PartialOrderQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.77"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PartialOrderQ"],

Cell[TextData[{
  StyleBox["PartialSumOfSquares", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PartialSumOfSquares"],

Cell[TextData[{
  StyleBox["PartitionLattice", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PartitionLattice"],

Cell[TextData[{
  StyleBox["PartitionQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PartitionQ"],

Cell[TextData[{
  "Partitions, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Partitions"],

Cell[TextData[{
  "diagrams of, ",
  StyleBox["FerrersDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Partitions"],

Cell[TextData[{
  StyleBox["Partitions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Partitions"],

Cell[TextData[{
  StyleBox["Path", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.71"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Path"],

Cell[TextData[{
  StyleBox["PDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PDF"],

Cell[TextData[{
  StyleBox["PeakWavelength", "MR"],
  ", ",
  ButtonBox["Miscellaneous`BlackBodyRadiation`",
    ButtonData:>{"Miscellaneous`BlackBodyRadiation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PeakWavelength"],

Cell[TextData[{
  StyleBox["PearsonSkewness1", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PearsonSkewness1"],

Cell[TextData[{
  StyleBox["PearsonSkewness2", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PearsonSkewness2"],

Cell[TextData[{
  StyleBox["Pentagon", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pentagon"],

Cell[TextData[{
  StyleBox["PercentileBarChart", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PercentileBarChart"],

Cell[TextData[{
  StyleBox["PerfectQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PerfectQ"],

Cell[TextData[{
  StyleBox["PeriodicForm", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PeriodicForm"],

Cell[TextData[{
  StyleBox["PermutationGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PermutationGraph"],

Cell[TextData[{
  StyleBox["PermutationGroupQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PermutationGroupQ"],

Cell[TextData[{
  StyleBox["PermutationQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PermutationQ"],

Cell[TextData[{
  "Permutations, construction of, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Permutations"],

Cell[TextData[{
  "enumeration of, ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " \ninversion of, ",
  StyleBox["InversePermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " \ninversions in, ",
  StyleBox["Inversions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Permutations"],

Cell[TextData[{
  StyleBox["Permutations", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Permutations"],

Cell[TextData[{
  StyleBox["PermutationToTableaux", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PermutationToTableaux"],

Cell[TextData[{
  StyleBox["PermutationType", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PermutationType"],

Cell[TextData[{
  StyleBox["PermutationWithCycle", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PermutationWithCycle"],

Cell[TextData[{
  StyleBox["Permute", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Permute"],

Cell[TextData[{
  StyleBox["PermuteSubgraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PermuteSubgraph"],

Cell[TextData[{
  StyleBox["PetersenGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PetersenGraph"],

Cell[TextData[{
  "Phase\[Hyphen]gratings, ",
  ButtonBox["Introduction",
    ButtonData:>{"5.0.8", "8.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Phase-gratings"],

Cell[TextData[{
  "Phi, of Butcher tree, ",
  StyleBox["ButcherPhi", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Phi"],

Cell[TextData[{
  StyleBox["PhysicalConstants", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PhysicalConstants package"],

Cell[TextData[{
  StyleBox["PieChart", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PieChart"],

Cell[TextData[{
  StyleBox["PieExploded", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PieExploded"],

Cell[TextData[{
  StyleBox["PieLabels", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PieLabels"],

Cell[TextData[{
  StyleBox["PieLineStyle", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PieLineStyle"],

Cell[TextData[{
  StyleBox["PieStyle", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PieStyle"],

Cell[TextData[{
  "Pitch/frequency equivalents, ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pitch/frequency equivalents"],

Cell[TextData[{
  "Planar data, analysis of, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Planar data"],

Cell[TextData[{
  StyleBox["PlanarGraphPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlanarGraphPlot"],

Cell[TextData[{
  StyleBox["PlanarQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlanarQ"],

Cell[TextData[{
  StyleBox["PlanckConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlanckConstant"],

Cell[TextData[{
  StyleBox["PlanckConstantReduced", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlanckConstantReduced"],

Cell[TextData[{
  StyleBox["PlanckMass", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlanckMass"],

Cell[TextData[{
  StyleBox["PlayRange", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.55"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlayRange"],

Cell[TextData[{
  StyleBox["Plot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Plot"],

Cell[TextData[{
  StyleBox["Plot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Plot3D"],

Cell[TextData[{
  "with shadows, ",
  StyleBox["ShadowPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Plot3D"],

Cell[TextData[{
  StyleBox["PlotField", "MR"],
  " package, ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotField package"],

Cell[TextData[{
  StyleBox["PlotField3D", "MR"],
  " package, ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotField3D package"],

Cell[TextData[{
  StyleBox["PlotFlag", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotFlag"],

Cell[TextData[{
  StyleBox["PlotGradientField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotGradientField"],

Cell[TextData[{
  StyleBox["PlotGradientField3D", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotGradientField3D"],

Cell[TextData[{
  StyleBox["PlotHamiltonianField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotHamiltonianField"],

Cell[TextData[{
  StyleBox["PlotJoined", "MR"],
  ", ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotJoined"],

Cell[TextData[{
  StyleBox["PlotLegend", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotLegend"],

Cell[TextData[{
  StyleBox["PlotPoints", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotPoints"],

Cell[TextData[{
  StyleBox["PlotPolyaField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotPolyaField"],

Cell[TextData[{
  StyleBox["PlotRange", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotRange"],

Cell[TextData[{
  "Plots, of expressions, ",
  StyleBox["ExprPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Plots"],

Cell[TextData[{
  "of trees, ",
  StyleBox["TreePlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Tree`",
    ButtonData:>{"DiscreteMath`Tree`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " \nanimation of, ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " \natmospheric, ",
  StyleBox["AtmosphericPlot", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nblack\[Hyphen]body spectral distribution, ",
  StyleBox["BlackBodyProfile", "MR"],
  ", ",
  ButtonBox["Miscellaneous`BlackBodyRadiation`",
    ButtonData:>{"Miscellaneous`BlackBodyRadiation`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nbusiness, ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \ndisplaying together, ",
  StyleBox["DisplayTogether", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " \nfilling between curves in, ",
  StyleBox["FilledPlots", "MR"],
  ", ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nfour\[Hyphen]dimensional, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ngeographical, ",
  StyleBox["WorldPlot", "MR"],
  ", ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nin cylindrical coordinates, ",
  StyleBox["CylindricalPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nin spherical coordinates, ",
  StyleBox["SphericalPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nlegends in, ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nlog, ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof complex\[Hyphen]valued functions, ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " \nof experimental data, ",
  StyleBox["ErrorListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " \nof functions using machine arithmetic, ",
  StyleBox["Microscope", "MR"],
  ", ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " \nof implicit functions, ",
  StyleBox["ImplicitPlot", "MR"],
  ", ",
  ButtonBox["Graphics`ImplicitPlot`",
    ButtonData:>{"Graphics`ImplicitPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof machine error, ",
  StyleBox["MicroscopicError", "MR"],
  ", ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " \nof multiple lists, ",
  StyleBox["MultipleListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof surfaces, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`SurfaceOfRevolution`",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof three\[Hyphen]dimensional vector fields, ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nof two\[Hyphen]dimensional neighborhood polygons, ",
  StyleBox["DiagramPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \nof two\[Hyphen]dimensional triangulations, ",
  StyleBox["PlanarGraphPlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \nof two\[Hyphen]dimensional vector fields, ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nPareto, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \npolar, ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nquantile\[Hyphen]quantile, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nsemi\[Hyphen]log, ",
  StyleBox["LogPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nshaded, ",
  ButtonBox["Graphics`FilledPlot`",
    ButtonData:>{"Graphics`FilledPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " \nstatistical, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nthree\[Hyphen]dimensional contour, ",
  StyleBox["ContourPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ContourPlot3D`",
    ButtonData:>{"Graphics`ContourPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nthree\[Hyphen]dimensional scatter, ",
  StyleBox["ScatterPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nthree\[Hyphen]dimensional shadowed, ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " \nwith labeled points, ",
  StyleBox["LabeledListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " \nwith points rendered as text, ",
  StyleBox["TextListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Plots"],

Cell[TextData[{
  StyleBox["PlotStyle", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotStyle"],

Cell[TextData[{
  StyleBox["PlotSymbol", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotSymbol"],

Cell[TextData[{
  "Plotting symbols, ",
  StyleBox["LabeledListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Plotting symbols"],

Cell[TextData[{
  StyleBox["MultipleListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " \n",
  StyleBox["TextListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Plotting symbols"],

Cell[TextData[{
  StyleBox["PlotVectorField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotVectorField"],

Cell[TextData[{
  StyleBox["PlotVectorField3D", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PlotVectorField3D"],

Cell[TextData[{
  StyleBox["Pochhammer", "MR"],
  ", ",
  ButtonBox["DiscreteMath`CombinatorialFunctions`",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pochhammer"],

Cell[TextData[{
  StyleBox["point", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"point 3-Script command"],

Cell[TextData[{
  "Point neighborhood, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Point neighborhood"],

Cell[TextData[{
  StyleBox["PointParametricPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PointParametricPlot3D"],

Cell[TextData[{
  "Points, convex hull in two\[Hyphen]dimensions, ",
  StyleBox["ConvexHull", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Points"],

Cell[TextData[{
  "triangulation in two\[Hyphen]dimensions, ",
  StyleBox["DelaunayTriangulation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nparametric plotting of, ",
  StyleBox["PointParametricPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`ParametricPlot3D`",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Points"],

Cell[TextData[{
  StyleBox["PoissonDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PoissonDistribution"],

Cell[TextData[{
  "PolarDecomposition, ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolarDecomposition"],

Cell[TextData[{
  StyleBox["PolarDecomposition", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`MatrixManipulation`",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolarDecomposition"],

Cell[TextData[{
  StyleBox["PolarListPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolarListPlot"],

Cell[TextData[{
  StyleBox["PolarMap", "MR"],
  ", ",
  ButtonBox["Graphics`ComplexMap`",
    ButtonData:>{"Graphics`ComplexMap`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolarMap"],

Cell[TextData[{
  StyleBox["PolarPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolarPlot"],

Cell[TextData[{
  StyleBox["PollardPTest", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PollardPTest"],

Cell[TextData[{
  StyleBox["PollardRhoTest", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PollardRhoTest"],

Cell[TextData[{
  StyleBox["Polya", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polya"],

Cell[TextData[{
  "Polya representation, plotting, ",
  StyleBox["PlotPolyaField", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polya representation"],

Cell[TextData[{
  "Polya theory, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polya theory"],

Cell[TextData[{
  StyleBox["Polygon", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polygon"],

Cell[TextData[{
  StyleBox["polygon", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics`ThreeScript`",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"polygon 3-Script command"],

Cell[TextData[{
  "Polygons, regular, ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polygons"],

Cell[TextData[{
  "regular, ",
  StyleBox["RegularPolygon", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " \nVoronoi, ",
  ButtonBox["DiscreteMath`ComputationalGeometry`",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Polygons"],

Cell[TextData[{
  StyleBox["Polyhedra", "MR"],
  " package, ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polyhedra package"],

Cell[TextData[{
  StyleBox["Polyhedron", "MR"],
  ", ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polyhedron"],

Cell[TextData[{
  "Polyhedrons, duals of, ",
  StyleBox["Dual", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polyhedrons"],

Cell[TextData[{
  "Polynomial approximation, ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polynomial approximation"],

Cell[TextData[{
  "Polynomial inequalities, ",
  ButtonBox["Algebra`AlgebraicInequalities`",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`InequalitySolve`",
    ButtonData:>{"Algebra`InequalitySolve`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polynomial inequalities"],

Cell[TextData[{
  StyleBox["PolynomialExtendedGCD", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialExtendedGCD`",
    ButtonData:>{"Algebra`PolynomialExtendedGCD`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`PolynomialExtendedGCD`",
    ButtonData:>{"Algebra`PolynomialExtendedGCD`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialExtendedGCD"],

Cell[TextData[{
  StyleBox["PolynomialExtendedGCD", "MR"],
  " package, ",
  ButtonBox["Algebra`PolynomialExtendedGCD`",
    ButtonData:>{"Algebra`PolynomialExtendedGCD`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialExtendedGCD package"],

Cell[TextData[{
  StyleBox["PolynomialFit", "MR"],
  ", ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialFit"],

Cell[TextData[{
  StyleBox["PolynomialFit", "MR"],
  " package, ",
  ButtonBox["NumericalMath`PolynomialFit`",
    ButtonData:>{"NumericalMath`PolynomialFit`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialFit package"],

Cell[TextData[{
  StyleBox["PolynomialGCD", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialGCD"],

Cell[TextData[{
  "extended, ",
  StyleBox["PolynomialExtendedGCD", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialExtendedGCD`",
    ButtonData:>{"Algebra`PolynomialExtendedGCD`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"PolynomialGCD"],

Cell[TextData[{
  StyleBox["PolynomialMod", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialMod"],

Cell[TextData[{
  StyleBox["PolynomialPowerMod", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialPowerMod"],

Cell[TextData[{
  StyleBox["PolynomialPowerMod", "MR"],
  " package, ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialPowerMod package"],

Cell[TextData[{
  StyleBox["PolynomialQuotient", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialQuotient"],

Cell[TextData[{
  StyleBox["PolynomialRemainder", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialRemainder"],

Cell[TextData[{
  "Polynomials, approximate, ",
  ButtonBox["NumberTheory`Recognize`",
    ButtonData:>{"NumberTheory`Recognize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polynomials"],

Cell[TextData[{
  "Horner form, ",
  StyleBox["Horner", "MR"],
  ", ",
  ButtonBox["Algebra`Horner`",
    ButtonData:>{"Algebra`Horner`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " \ninterpolating, ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`ListIntegrate`",
    ButtonData:>{"NumericalMath`ListIntegrate`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " \nmodulo primes, ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \nwith integer coefficients, ",
  ButtonBox["NumberTheory`Recognize`",
    ButtonData:>{"NumberTheory`Recognize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Polynomials"],

Cell[TextData[{
  StyleBox["PolynomialToElement", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolynomialToElement"],

Cell[TextData[{
  StyleBox["Polytope", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polytope"],

Cell[TextData[{
  StyleBox["PolytopeQuantile", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolytopeQuantile"],

Cell[TextData[{
  StyleBox["PolytopeQuartiles", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PolytopeQuartiles"],

Cell[TextData[{
  "Polytopes, regular three\[Hyphen]dimensional, ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polytopes"],

Cell[TextData[{
  StyleBox["Polytopes", "MR"],
  " package, ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Polytopes package"],

Cell[TextData[{
  "Positions, of cites, ",
  StyleBox["CityPosition", "MR"],
  ", ",
  ButtonBox["Miscellaneous`CityData`",
    ButtonData:>{"Miscellaneous`CityData`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Positions"],

Cell[TextData[{
  StyleBox["PostTests", "MR"],
  ", ",
  ButtonBox["Statistics`ANOVA`",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PostTests"],

Cell[TextData[{
  "Power, ",
  StyleBox["$Post", "MR"],
  ", ",
  ButtonBox["Miscellaneous`RealOnly`",
    ButtonData:>{"Miscellaneous`RealOnly`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Power"],

Cell[TextData[{
  StyleBox["PowerList", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PowerList"],

Cell[TextData[{
  StyleBox["PowerListQ", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PowerListQ"],

Cell[TextData[{
  StyleBox["PowerListToField", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.32"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PowerListToField"],

Cell[TextData[{
  StyleBox["PowerMod", "MR"],
  ", ",
  ButtonBox["Algebra`PolynomialPowerMod`",
    ButtonData:>{"Algebra`PolynomialPowerMod`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PowerMod"],

Cell[TextData[{
  StyleBox["PowerSum", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PowerSum"],

Cell[TextData[{
  "Pratt\[CloseCurlyQuote]s primality certificate, ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pratt's primality certificate"],

Cell[TextData[{
  StyleBox["PredictedResponse", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PredictedResponse"],

Cell[TextData[{
  StyleBox["PredictedResponseDelta", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PredictedResponseDelta"],

Cell[TextData[{
  StyleBox["Pressure", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Pressure"],

Cell[TextData[{
  StyleBox["PressureScaleHeight", "MR"],
  ", ",
  ButtonBox["Miscellaneous`StandardAtmosphere`",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PressureScaleHeight"],

Cell[TextData[{
  StyleBox["PreviousPrime", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PreviousPrime"],

Cell[TextData[{
  "Primality certificate, ",
  StyleBox["PrimeQCertificate", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Primality certificate"],

Cell[TextData[{
  "Primality certificate checking, ",
  StyleBox["PrimeQCertificateCheck", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Primality certificate checking"],

Cell[TextData[{
  "Primality proving, ",
  StyleBox["ProvablePrimeQ", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Primality proving"],

Cell[TextData[{
  "Primary colors, ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Primary colors"],

Cell[TextData[{
  StyleBox["PrimaryLeftAssociate", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.27"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimaryLeftAssociate"],

Cell[TextData[{
  StyleBox["PrimaryRightAssociate", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.27"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimaryRightAssociate"],

Cell[TextData[{
  "Prime, next, ",
  StyleBox["NextPrime", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Prime"],

Cell[TextData[{
  "previous, ",
  StyleBox["PreviousPrime", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Prime"],

Cell[TextData[{
  StyleBox["Prime", "MR"],
  ", ",
  ButtonBox["NumberTheory`FactorIntegerECM`",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Prime"],

Cell[TextData[{
  StyleBox["PrimeFactorList", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimeFactorList"],

Cell[TextData[{
  StyleBox["PrimePowerQ", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimePowerQ"],

Cell[TextData[{
  StyleBox["PrimeQ", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.36"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimeQ"],

Cell[TextData[{
  StyleBox["PrimeQ", "MR"],
  " package, ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimeQ package"],

Cell[TextData[{
  StyleBox["PrimeQCertificate", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimeQCertificate"],

Cell[TextData[{
  StyleBox["PrimeQCertificateCheck", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimeQCertificateCheck"],

Cell[TextData[{
  StyleBox["PrimeQMessages", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimeQMessages"],

Cell[TextData[{
  "Primitive elements, ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumberTheory`PrimitiveElement`",
    ButtonData:>{"NumberTheory`PrimitiveElement`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Primitive elements"],

Cell[TextData[{
  "Primitive roots, ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Primitive roots"],

Cell[TextData[{
  StyleBox["PrimitiveElement", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimitiveElement`",
    ButtonData:>{"NumberTheory`PrimitiveElement`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimitiveElement"],

Cell[TextData[{
  StyleBox["PrimitiveElement", "MR"],
  " package, ",
  ButtonBox["NumberTheory`PrimitiveElement`",
    ButtonData:>{"NumberTheory`PrimitiveElement`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimitiveElement package"],

Cell[TextData[{
  StyleBox["PrimitiveRoot", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrimitiveRoot"],

Cell[TextData[{
  "Primitives, geometric, ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Primitives"],

Cell[TextData[{
  "three\[Hyphen]dimensional graphics, ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntwo\[Hyphen]dimensional graphics, ",
  StyleBox["Arrow", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " \ntwo\[Hyphen]dimensional graphics, ",
  StyleBox["Spline", "MR"],
  ", ",
  ButtonBox["Graphics`Spline`",
    ButtonData:>{"Graphics`Spline`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Primitives"],

Cell[TextData[{
  "Principal branch, ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Principal branch"],

Cell[TextData[{
  StyleBox["PrincipalComponents", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrincipalComponents"],

Cell[TextData[{
  StyleBox["PrintFlag", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PrintFlag"],

Cell[TextData[{
  "Probability density function, ",
  StyleBox["PDF", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Probability density function"],

Cell[TextData[{
  "Probability value (p\[Hyphen]value), ",
  ButtonBox["Statistics`HypothesisTests`",
    ButtonData:>{"Statistics`HypothesisTests`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Probability value (p-value)"],

Cell[TextData[{
  "Product, dot, ",
  StyleBox["DotProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Product, dot"],

Cell[TextData[{
  StyleBox["Project", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Project"],

Cell[TextData[{
  StyleBox["Projection", "MR"],
  ", ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["LinearAlgebra`Orthogonalization`",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Projection"],

Cell[TextData[{
  "Projections, map, ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Projections"],

Cell[TextData[{
  "shadow, ",
  StyleBox["Shadow", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Projections"],

Cell[TextData[{
  StyleBox["ProjectiveRationalize", "MR"],
  ", ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ProjectiveRationalize"],

Cell[TextData[{
  StyleBox["ProlateSpheroidal", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ProlateSpheroidal"],

Cell[TextData[{
  StyleBox["ProtonComptonWavelength", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ProtonComptonWavelength"],

Cell[TextData[{
  StyleBox["ProtonMagneticMoment", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ProtonMagneticMoment"],

Cell[TextData[{
  StyleBox["ProtonMass", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ProtonMass"],

Cell[TextData[{
  StyleBox["ProvablePrimeQ", "MR"],
  ", ",
  ButtonBox["NumberTheory`PrimeQ`",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ProvablePrimeQ"],

Cell[TextData[{
  StyleBox["PseudoDiameter", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PseudoDiameter"],

Cell[TextData[{
  StyleBox["PseudographQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PseudographQ"],

Cell[TextData[{
  StyleBox["PythagoreanChromatic", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"PythagoreanChromatic"],

Cell[TextData[{
  StyleBox["PythagoreanMajor", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  "Quadratic forms, binary, ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.54"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quadratic forms"],

Cell[TextData[{
  StyleBox["QuadraticFormDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuadraticFormDistribution"],

Cell[TextData[{
  StyleBox["QuadraticIrrationalQ", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuadraticIrrationalQ"],

Cell[TextData[{
  StyleBox["QuadraticRepresentation", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuadraticRepresentation"],

Cell[TextData[{
  "Quadrature, numerical, ",
  ButtonBox["NumericalMath`GaussianQuadrature`",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quadrature"],

Cell[TextData[{
  StyleBox["QuadratureType", "MR"],
  ", ",
  ButtonBox["NumericalMath`NewtonCotes`",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuadratureType"],

Cell[TextData[{
  StyleBox["Quantile", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quantile"],

Cell[TextData[{
  "Quantile\[Hyphen]quantile plot, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quantile-quantile plot"],

Cell[TextData[{
  StyleBox["QuantileForm", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuantileForm"],

Cell[TextData[{
  StyleBox["QuantilePlot", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.29"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuantilePlot"],

Cell[TextData[{
  StyleBox["QuantizedHallConductance", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuantizedHallConductance"],

Cell[TextData[{
  StyleBox["QuarterTone", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuarterTone"],

Cell[TextData[{
  StyleBox["QuartileDeviation", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuartileDeviation"],

Cell[TextData[{
  StyleBox["Quartiles", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quartiles"],

Cell[TextData[{
  StyleBox["QuartileSkewness", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuartileSkewness"],

Cell[TextData[{
  StyleBox["Quaternion", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quaternion"],

Cell[TextData[{
  StyleBox["QuaternionQ", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"QuaternionQ"],

Cell[TextData[{
  StyleBox["Quaternions", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.36"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quaternions"],

Cell[TextData[{
  StyleBox["Quaternions", "MR"],
  " package, ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Quaternions package"],

Cell[TextData[{
  "Quotients, partial, ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["RadialEmbedding", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RadialEmbedding"],

Cell[TextData[{
  StyleBox["Radius", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NSeries`",
    ButtonData:>{"NumericalMath`NSeries`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Radius"],

Cell[TextData[{
  "Ramanujan functions, ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Ramanujan functions"],

Cell[TextData[{
  "Ramanujan hypothesis, ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Ramanujan hypothesis"],

Cell[TextData[{
  StyleBox["Ramanujan", "MR"],
  " package, ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Ramanujan package"],

Cell[TextData[{
  StyleBox["RamanujanTau", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RamanujanTau"],

Cell[TextData[{
  StyleBox["RamanujanTauDirichletSeries", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RamanujanTauDirichletSeries"],

Cell[TextData[{
  StyleBox["RamanujanTauGeneratingFunction", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RamanujanTauGeneratingFunction"],

Cell[TextData[{
  StyleBox["RamanujanTauTheta", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RamanujanTauTheta"],

Cell[TextData[{
  StyleBox["RamanujanTauZ", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RamanujanTauZ"],

Cell[TextData[{
  StyleBox["Random", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Random"],

Cell[TextData[{
  StyleBox["RandomArray", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`DiscreteDistributions`",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDiscreteDistributions`",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultinormalDistribution`",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NormalDistribution`",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomArray"],

Cell[TextData[{
  StyleBox["RandomColors", "MR"],
  ", ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomColors"],

Cell[TextData[{
  StyleBox["RandomComposition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomComposition"],

Cell[TextData[{
  StyleBox["RandomGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomGraph"],

Cell[TextData[{
  StyleBox["RandomGrays", "MR"],
  ", ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomGrays"],

Cell[TextData[{
  StyleBox["RandomHeap", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomHeap"],

Cell[TextData[{
  StyleBox["RandomInteger", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomInteger"],

Cell[TextData[{
  StyleBox["RandomKSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomKSetPartition"],

Cell[TextData[{
  StyleBox["RandomKSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.56"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomKSubset"],

Cell[TextData[{
  StyleBox["RandomPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomPartition"],

Cell[TextData[{
  StyleBox["RandomPermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomPermutation"],

Cell[TextData[{
  StyleBox["RandomRGF", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomRGF"],

Cell[TextData[{
  StyleBox["RandomSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomSetPartition"],

Cell[TextData[{
  StyleBox["RandomSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.43"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomSubset"],

Cell[TextData[{
  StyleBox["RandomTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.27"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomTableau"],

Cell[TextData[{
  StyleBox["RandomTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.48"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomTree"],

Cell[TextData[{
  StyleBox["RandomVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RandomVertices"],

Cell[TextData[{
  StyleBox["RangeCounts", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RangeCounts"],

Cell[TextData[{
  StyleBox["RangeLists", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RangeLists"],

Cell[TextData[{
  StyleBox["RankBinarySubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankBinarySubset"],

Cell[TextData[{
  StyleBox["RankedEmbedding", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankedEmbedding"],

Cell[TextData[{
  StyleBox["RankGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankGraph"],

Cell[TextData[{
  StyleBox["RankGrayCodeSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankGrayCodeSubset"],

Cell[TextData[{
  StyleBox["RankKSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankKSetPartition"],

Cell[TextData[{
  StyleBox["RankKSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankKSubset"],

Cell[TextData[{
  StyleBox["RankPermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankPermutation"],

Cell[TextData[{
  StyleBox["RankRGF", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankRGF"],

Cell[TextData[{
  StyleBox["RankSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankSetPartition"],

Cell[TextData[{
  StyleBox["RankSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RankSubset"],

Cell[TextData[{
  "Rational function approximations, ",
  ButtonBox["Calculus`Pade`",
    ButtonData:>{"Calculus`Pade`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rational function approximations"],

Cell[TextData[{
  "Rational number approximations, ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rational number approximations"],

Cell[TextData[{
  "simultaneous, ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Rational number approximations"],

Cell[TextData[{
  StyleBox["RationalInterpolation", "MR"],
  ", ",
  ButtonBox["NumericalMath`Approximations`",
    ButtonData:>{"NumericalMath`Approximations`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RationalInterpolation"],

Cell[TextData[{
  "Rationalize, affine, ",
  StyleBox["AffineRationalize", "MR"],
  ", ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rationalize"],

Cell[TextData[{
  "projective, ",
  StyleBox["ProjectiveRationalize", "MR"],
  ", ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Rationalize"],

Cell[TextData[{
  StyleBox["Rationalize", "MR"],
  ", ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rationalize"],

Cell[TextData[{
  StyleBox["Rationalize", "MR"],
  " package, ",
  ButtonBox["NumberTheory`Rationalize`",
    ButtonData:>{"NumberTheory`Rationalize`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rationalize package"],

Cell[TextData[{
  StyleBox["RayleighDistribution", "MR"],
  ", ",
  ButtonBox["Statistics`ContinuousDistributions`",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RayleighDistribution"],

Cell[TextData[{
  StyleBox["Re", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Re"],

Cell[TextData[{
  StyleBox["ReadSoundFile", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ReadSoundFile"],

Cell[TextData[{
  "Real numbers, ",
  ButtonBox["Miscellaneous`RealOnly`",
    ButtonData:>{"Miscellaneous`RealOnly`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Real numbers"],

Cell[TextData[{
  StyleBox["RealDigits", "MR"],
  ", ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RealDigits"],

Cell[TextData[{
  StyleBox["RealizeDegreeSequence", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.65"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RealizeDegreeSequence"],

Cell[TextData[{
  StyleBox["RealOnly", "MR"],
  ", ",
  ButtonBox["Miscellaneous`RealOnly`",
    ButtonData:>{"Miscellaneous`RealOnly`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RealOnly"],

Cell[TextData[{
  StyleBox["RealOnly", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`RealOnly`",
    ButtonData:>{"Miscellaneous`RealOnly`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RealOnly package"],

Cell[TextData[{
  StyleBox["RealRootIntervals", "MR"],
  ", ",
  ButtonBox["Algebra`RootIsolation`",
    ButtonData:>{"Algebra`RootIsolation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RealRootIntervals"],

Cell[TextData[{
  StyleBox["RealValued", "MR"],
  ", ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RealValued"],

Cell[TextData[{
  StyleBox["Recognize", "MR"],
  ", ",
  ButtonBox["NumberTheory`Recognize`",
    ButtonData:>{"NumberTheory`Recognize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Recognize"],

Cell[TextData[{
  StyleBox["Recognize", "MR"],
  " package, ",
  ButtonBox["NumberTheory`Recognize`",
    ButtonData:>{"NumberTheory`Recognize`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Recognize package"],

Cell[TextData[{
  "Recurring decimals, ",
  ButtonBox["NumberTheory`ContinuedFractions`",
    ButtonData:>{"NumberTheory`ContinuedFractions`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Recurring decimals"],

Cell[TextData[{
  StyleBox["ReduceElement", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ReduceElement"],

Cell[TextData[{
  StyleBox["ReferenceLineStyle", "MR"],
  ", ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ReferenceLineStyle"],

Cell[TextData[{
  StyleBox["ReflexiveQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ReflexiveQ"],

Cell[TextData[{
  StyleBox["RegionProbability", "MR"],
  ", ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RegionProbability"],

Cell[TextData[{
  StyleBox["Regress", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Regress"],

Cell[TextData[{
  StyleBox["RegressionReport", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RegressionReport"],

Cell[TextData[{
  StyleBox["RegressionReportValues", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RegressionReportValues"],

Cell[TextData[{
  StyleBox["RegularGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RegularGraph"],

Cell[TextData[{
  StyleBox["RegularPolygon", "MR"],
  ", ",
  ButtonBox["Graphics`MultipleListPlot`",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RegularPolygon"],

Cell[TextData[{
  StyleBox["RegularQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RegularQ"],

Cell[TextData[{
  StyleBox["ReIm", "MR"],
  " package, ",
  ButtonBox["Algebra`ReIm`",
    ButtonData:>{"Algebra`ReIm`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ReIm package"],

Cell[TextData[{
  StyleBox["Relative", "MR"],
  ", ",
  ButtonBox["Graphics`Arrow`",
    ButtonData:>{"Graphics`Arrow`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Relative"],

Cell[TextData[{
  StyleBox["RelativeStrength", "MR"],
  ", ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RelativeStrength"],

Cell[TextData[{
  StyleBox["Remove", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Remove"],

Cell[TextData[{
  StyleBox["RemoveMultipleEdges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RemoveMultipleEdges"],

Cell[TextData[{
  StyleBox["RemoveSelfLoops", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RemoveSelfLoops"],

Cell[TextData[{
  StyleBox["RepeatedSmoothing", "MR"],
  ", ",
  ButtonBox["Statistics`DataSmoothing`",
    ButtonData:>{"Statistics`DataSmoothing`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RepeatedSmoothing"],

Cell[TextData[{
  StyleBox["ResidualFlowGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ResidualFlowGraph"],

Cell[TextData[{
  "Residuals, of fit, ",
  StyleBox["FitResiduals", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Residuals"],

Cell[TextData[{
  "of fit, ",
  StyleBox["StandardizedResiduals", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`NonlinearFit`",
    ButtonData:>{"Statistics`NonlinearFit`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  " \nof fit, ",
  StyleBox["StudentizedResiduals", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Residuals"],

Cell[TextData[{
  "Residue, complex, ",
  StyleBox["NResidue", "MR"],
  ", ",
  ButtonBox["NumericalMath`NResidue`",
    ButtonData:>{"NumericalMath`NResidue`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Residue"],

Cell[TextData[{
  StyleBox["Residue", "MR"],
  ", ",
  ButtonBox["NumericalMath`NResidue`",
    ButtonData:>{"NumericalMath`NResidue`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Residue"],

Cell[TextData[{
  StyleBox["ResonanceAbsorptionLines", "MR"],
  " package, ",
  ButtonBox["Miscellaneous`ResonanceAbsorptionLines`",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ResonanceAbsorptionLines package"],

Cell[TextData[{
  StyleBox["RevealCycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RevealCycles"],

Cell[TextData[{
  StyleBox["ReverseEdges", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ReverseEdges"],

Cell[TextData[{
  StyleBox["RevolutionAxis", "MR"],
  ", ",
  ButtonBox["Graphics`SurfaceOfRevolution`",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RevolutionAxis"],

Cell[TextData[{
  StyleBox["RGBColor", "MR"],
  ", ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RGBColor"],

Cell[TextData[{
  StyleBox["RGFQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RGFQ"],

Cell[TextData[{
  StyleBox["RGFs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RGFs"],

Cell[TextData[{
  StyleBox["RGFToSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RGFToSetPartition"],

Cell[TextData[{
  "Riemann hypothesis, ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Riemann hypothesis"],

Cell[TextData[{
  StyleBox["RiemannSiegelTheta", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RiemannSiegelTheta"],

Cell[TextData[{
  StyleBox["RiemannSiegelZ", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RiemannSiegelZ"],

Cell[TextData[{
  StyleBox["RightAssociates", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.27"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RightAssociates"],

Cell[TextData[{
  StyleBox["RightGCD", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RightGCD"],

Cell[TextData[{
  StyleBox["RingModulation", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.27"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RingModulation"],

Cell[TextData[{
  "Ritz variational principle, ",
  ButtonBox["Calculus`VariationalMethods`",
    ButtonData:>{"Calculus`VariationalMethods`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Ritz variational principle"],

Cell[TextData[{
  StyleBox["RobertsonGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RobertsonGraph"],

Cell[TextData[{
  StyleBox["RogersTanimotoDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"RogersTanimotoDissimilarity"],

Cell[TextData[{
  "Root finding, ",
  StyleBox["InterpolateRoot", "MR"],
  ", ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Root finding"],

Cell[TextData[{
  "root of unity, ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"root of unity"],

Cell[TextData[{
  StyleBox["RootedEmbedding", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RootedEmbedding"],

Cell[TextData[{
  StyleBox["RootIsolation", "MR"],
  " package, ",
  ButtonBox["Algebra`RootIsolation`",
    ButtonData:>{"Algebra`RootIsolation`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RootIsolation package"],

Cell[TextData[{
  StyleBox["RootMeanSquare", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RootMeanSquare"],

Cell[TextData[{
  "Roots of polynomials, approximate, ",
  ButtonBox["NumberTheory`Recognize`",
    ButtonData:>{"NumberTheory`Recognize`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Roots of polynomials"],

Cell[TextData[{
  StyleBox["Rotate2D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rotate2D"],

Cell[TextData[{
  StyleBox["Rotate3D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rotate3D"],

Cell[TextData[{
  StyleBox["RotateLights", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RotateLights"],

Cell[TextData[{
  StyleBox["RotateShape", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RotateShape"],

Cell[TextData[{
  StyleBox["RotateVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RotateVertices"],

Cell[TextData[{
  "Rotation, of three\[Hyphen]dimensional graphics, ",
  StyleBox["SpinShow", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rotation"],

Cell[TextData[{
  "of three\[Hyphen]dimensional objects, ",
  StyleBox["RotateShape", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " \nof three\[Hyphen]dimensional points, ",
  StyleBox["Rotate3D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " \nof two\[Hyphen]dimensional points, ",
  StyleBox["Rotate2D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Rotation"],

Cell[TextData[{
  StyleBox["RotationMatrix2D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RotationMatrix2D"],

Cell[TextData[{
  StyleBox["RotationMatrix3D", "MR"],
  ", ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RotationMatrix3D"],

Cell[TextData[{
  StyleBox["Rotations", "MR"],
  " package, ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Rotations package"],

Cell[TextData[{
  StyleBox["Round", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Round"],

Cell[TextData[{
  StyleBox["RoundingRule", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RoundingRule"],

Cell[TextData[{
  "Roundoff errors, ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`Microscope`",
    ButtonData:>{"NumericalMath`Microscope`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Roundoff errors"],

Cell[TextData[{
  StyleBox["RoundToEven", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RoundToEven"],

Cell[TextData[{
  StyleBox["RoundToInfinity", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RoundToInfinity"],

Cell[TextData[{
  StyleBox["RowJoin", "MR"],
  ", ",
  ButtonBox["Statistics`DataManipulation`",
    ButtonData:>{"Statistics`DataManipulation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RowJoin"],

Cell[TextData[{
  StyleBox["RSolve", "MR"],
  " package, ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Appendix: Functions Moved to the Kernel",
    ButtonData:>{"6.17.1", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RSolve package"],

Cell[TextData[{
  StyleBox["RSquared", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RSquared"],

Cell[TextData[{
  "Runge\[Hyphen]Kutta methods, ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Runge-Kutta methods"],

Cell[TextData[{
  StyleBox["RungeKuttaMethod", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RungeKuttaMethod"],

Cell[TextData[{
  StyleBox["RungeKuttaOrderConditions", "MR"],
  ", ",
  ButtonBox["NumericalMath`Butcher`",
    ButtonData:>{"NumericalMath`Butcher`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"RungeKuttaOrderConditions"],

Cell[TextData[{
  StyleBox["Runs", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Runs"],

Cell[TextData[{
  StyleBox["RussleRaoDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"RussleRaoDissimilarity"],

Cell[TextData[{
  StyleBox["RydbergConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["SackurTetrodeConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous`PhysicalConstants`",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SackurTetrodeConstant"],

Cell[TextData[{
  StyleBox["SamenessRelation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SamenessRelation"],

Cell[TextData[{
  "Sample mean, standard error of, ",
  StyleBox["StandardErrorOfSampleMean", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Sample mean"],

Cell[TextData[{
  "variance of, ",
  StyleBox["VarianceOfSampleMean", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Sample mean"],

Cell[TextData[{
  StyleBox["SampleDepth", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.55"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SampleDepth"],

Cell[TextData[{
  StyleBox["SampleRange", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SampleRange"],

Cell[TextData[{
  StyleBox["SampleRate", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.55"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SampleRate"],

Cell[TextData[{
  StyleBox["Sawtooth", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Audio`",
    ButtonData:>{"Miscellaneous`Audio`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Sawtooth"],

Cell[TextData[{
  "Scalar product, in various coordinate systems, ",
  StyleBox["DotProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Scalar product"],

Cell[TextData[{
  StyleBox["ScalarTripleProduct", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ScalarTripleProduct"],

Cell[TextData[{
  StyleBox["Scale", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Music`",
    ButtonData:>{"Miscellaneous`Music`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Scale"],

Cell[TextData[{
  StyleBox["ScaleFactor", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ScaleFactor"],

Cell[TextData[{
  StyleBox["ScaleFactors", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.39"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ScaleFactors"],

Cell[TextData[{
  StyleBox["ScaleFunction", "MR"],
  ", ",
  ButtonBox["Graphics`PlotField`",
    ButtonData:>{"Graphics`PlotField`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`PlotField3D`",
    ButtonData:>{"Graphics`PlotField3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Common`",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ScaleFunction"],

Cell[TextData[{
  StyleBox["ScaleMethod", "MR"],
  ", ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`MultiDescriptiveStatistics`",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.52"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ScaleMethod"],

Cell[TextData[{
  "Scales, on axes, ",
  StyleBox["Ticks", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Scales"],

Cell[TextData[{
  "Scaling, of three\[Hyphen]dimensional objects, ",
  StyleBox["AffineShape", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Scaling"],

Cell[TextData[{
  "scatter plot, ",
  ButtonBox["Statistics`StatisticsPlots`",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"scatter plot"],

Cell[TextData[{
  StyleBox["ScatterPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ScatterPlot3D"],

Cell[TextData[{
  StyleBox["Schlafli", "MR"],
  ", ",
  ButtonBox["Geometry`Polytopes`",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Schlafli"],

Cell[TextData[{
  StyleBox["SelectionSort", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SelectionSort"],

Cell[TextData[{
  StyleBox["SelfComplementaryQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.71"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SelfComplementaryQ"],

Cell[TextData[{
  StyleBox["SelfLoopsQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SelfLoopsQ"],

Cell[TextData[{
  "Semi\[Hyphen]log plots, ",
  StyleBox["LogPlot", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Semi-log plots"],

Cell[TextData[{
  "Semialgebraic sets, ",
  ButtonBox["Algebra`AlgebraicInequalities`",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Semialgebraic sets"],

Cell[TextData[{
  StyleBox["SemialgebraicComponents", "MR"],
  ", ",
  ButtonBox["Algebra`AlgebraicInequalities`",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SemialgebraicComponents"],

Cell[TextData[{
  StyleBox["SemimajorAxis", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Geodesy`",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SemimajorAxis"],

Cell[TextData[{
  "Separation of colors, ",
  ButtonBox["Graphics`Colors`",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Separation of colors"],

Cell[TextData[{
  "Sequence of graphics, ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Sequence of graphics"],

Cell[TextData[{
  "Sequences, ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Sequences"],

Cell[TextData[{
  StyleBox["SequentialSumOfSquares", "MR"],
  ", ",
  ButtonBox["Statistics`LinearRegression`",
    ButtonData:>{"Statistics`LinearRegression`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Statistics`Common`",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SequentialSumOfSquares"],

Cell[TextData[{
  "Series, alternating, ",
  ButtonBox["NumericalMath`NLimit`",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Series"],

Cell[TextData[{
  "Dirichlet, ",
  StyleBox["RamanujanTauDirichletSeries", "MR"],
  ", ",
  ButtonBox["NumberTheory`Ramanujan`",
    ButtonData:>{"NumberTheory`Ramanujan`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " \nFourier, ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  " \nFourier numerical, ",
  ButtonBox["Calculus`FourierTransform`",
    ButtonData:>{"Calculus`FourierTransform`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " \nnumerical, ",
  StyleBox["NSeries", "MR"],
  ", ",
  ButtonBox["NumericalMath`NSeries`",
    ButtonData:>{"NumericalMath`NSeries`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "IndexSubentry",
  CellTags->"Series"],

Cell[TextData[{
  StyleBox["Series", "MR"],
  ", ",
  ButtonBox["NumericalMath`NSeries`",
    ButtonData:>{"NumericalMath`NSeries`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Series"],

Cell[TextData[{
  StyleBox["SeriesTerm", "MR"],
  ", ",
  ButtonBox["DiscreteMath`RSolve`",
    ButtonData:>{"DiscreteMath`RSolve`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SeriesTerm"],

Cell[TextData[{
  StyleBox["SetArithmetic", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetArithmetic"],

Cell[TextData[{
  StyleBox["SetCoordinates", "MR"],
  ", ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Calculus`VectorAnalysis`",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetCoordinates"],

Cell[TextData[{
  StyleBox["SetEdgeLabels", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetEdgeLabels"],

Cell[TextData[{
  StyleBox["SetEdgeWeights", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetEdgeWeights"],

Cell[TextData[{
  StyleBox["SetFieldFormat", "MR"],
  ", ",
  ButtonBox["Algebra`FiniteFields`",
    ButtonData:>{"Algebra`FiniteFields`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetFieldFormat"],

Cell[TextData[{
  StyleBox["SetGraphOptions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetGraphOptions"],

Cell[TextData[{
  StyleBox["SetPartitionListViaRGF", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetPartitionListViaRGF"],

Cell[TextData[{
  StyleBox["SetPartitionQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetPartitionQ"],

Cell[TextData[{
  StyleBox["SetPartitions", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetPartitions"],

Cell[TextData[{
  StyleBox["SetPartitionToRGF", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetPartitionToRGF"],

Cell[TextData[{
  "Setting arithmetic parameters, ",
  StyleBox["SetArithmetic", "MR"],
  ", ",
  ButtonBox["NumericalMath`ComputerArithmetic`",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Setting arithmetic parameters"],

Cell[TextData[{
  StyleBox["SetVertexLabels", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetVertexLabels"],

Cell[TextData[{
  StyleBox["SetVertexWeights", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SetVertexWeights"],

Cell[TextData[{
  "Shade, of graphics, ",
  StyleBox["GrayLevel", "MR"],
  ", ",
  ButtonBox["Graphics`ArgColors`",
    ButtonData:>{"Graphics`ArgColors`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Shade"],

Cell[TextData[{
  StyleBox["Shadow", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Shadow"],

Cell[TextData[{
  StyleBox["ShadowBackground", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowBackground"],

Cell[TextData[{
  StyleBox["ShadowBorder", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowBorder"],

Cell[TextData[{
  StyleBox["ShadowBox", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowBox"],

Cell[TextData[{
  StyleBox["ShadowForeground", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowForeground"],

Cell[TextData[{
  "Shadowing of names, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.9"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Shadowing of names"],

Cell[TextData[{
  StyleBox["ShadowMesh", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowMesh"],

Cell[TextData[{
  StyleBox["ShadowMeshStyle", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowMeshStyle"],

Cell[TextData[{
  StyleBox["ShadowOffset", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowOffset"],

Cell[TextData[{
  StyleBox["ShadowPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.12"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowPlot3D"],

Cell[TextData[{
  StyleBox["ShadowPosition", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShadowPosition"],

Cell[TextData[{
  StyleBox["ShakeGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShakeGraph"],

Cell[TextData[{
  StyleBox["ShapeReport", "MR"],
  ", ",
  ButtonBox["Statistics`DescriptiveStatistics`",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShapeReport"],

Cell[TextData[{
  "Shapes, seeing inside, ",
  StyleBox["WireFrame", "MR"],
  ", ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Shapes"],

Cell[TextData[{
  StyleBox["Shapes", "MR"],
  " package, ",
  ButtonBox["Geometry`Rotations`",
    ButtonData:>{"Geometry`Rotations`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Shapes package"],

Cell[TextData[{
  StyleBox["Share", "MR"],
  ", ",
  ButtonBox["Utilities`MemoryConserve`",
    ButtonData:>{"Utilities`MemoryConserve`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Share"],

Cell[TextData[{
  StyleBox["ShortestPath", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.85"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShortestPath"],

Cell[TextData[{
  StyleBox["ShortestPathSpanningTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.84"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShortestPathSpanningTree"],

Cell[TextData[{
  StyleBox["Show", "MR"],
  ", ",
  ButtonBox["Graphics`Graphics`",
    ButtonData:>{"Graphics`Graphics`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Graphics3D`",
    ButtonData:>{"Graphics`Graphics3D`", "1.25"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Polyhedra`",
    ButtonData:>{"Graphics`Polyhedra`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Graphics`Shapes`",
    ButtonData:>{"Graphics`Shapes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Miscellaneous`WorldPlot`",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Show"],

Cell[TextData[{
  StyleBox["ShowAnimation", "MR"],
  ", ",
  ButtonBox["Graphics`Animation`",
    ButtonData:>{"Graphics`Animation`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowAnimation"],

Cell[TextData[{
  StyleBox["ShowGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowGraph"],

Cell[TextData[{
  StyleBox["ShowGraphArray", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowGraphArray"],

Cell[TextData[{
  StyleBox["ShowLabeledGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowLabeledGraph"],

Cell[TextData[{
  StyleBox["ShowLegend", "MR"],
  ", ",
  ButtonBox["Graphics`Legend`",
    ButtonData:>{"Graphics`Legend`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowLegend"],

Cell[TextData[{
  StyleBox["ShowProgress", "MR"],
  ", ",
  ButtonBox["NumberTheory`NumberTheoryFunctions`",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["NumericalMath`InterpolateRoot`",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowProgress"],

Cell[TextData[{
  StyleBox["ShowTime", "MR"],
  ", ",
  ButtonBox["Utilities`ShowTime`",
    ButtonData:>{"Utilities`ShowTime`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowTime"],

Cell[TextData[{
  StyleBox["ShowTime", "MR"],
  " package, ",
  ButtonBox["Utilities`ShowTime`",
    ButtonData:>{"Utilities`ShowTime`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShowTime package"],

Cell[TextData[{
  StyleBox["ShuffleExchangeGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ShuffleExchangeGraph"],

Cell[TextData[{
  StyleBox["SI", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Units`",
    ButtonData:>{"Miscellaneous`Units`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SI"],

Cell[TextData[{
  StyleBox["SiegelTheta", "MR"],
  ", ",
  ButtonBox["NumberTheory`SiegelTheta`",
    ButtonData:>{"NumberTheory`SiegelTheta`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SiegelTheta"],

Cell[TextData[{
  StyleBox["SiegelTheta", "MR"],
  " package, ",
  ButtonBox["NumberTheory`SiegelTheta`",
    ButtonData:>{"NumberTheory`SiegelTheta`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SiegelTheta package"],

Cell[TextData[{
  StyleBox["Sign", "MR"],
  ", ",
  ButtonBox["Algebra`Quaternions`",
    ButtonData:>{"Algebra`Quaternions`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Sign"],

Cell[TextData[{
  StyleBox["SignaturePermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath`Combinatorica`",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SignaturePermutation"],

Cell[TextData[{
  "Significance level, ",
  ButtonBox["Statistics`HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Significance level"],

Cell[TextData[{
  StyleBox["SignificanceLevel", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ANOVA",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`HypothesisTests`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SignificanceLevel"],

Cell[TextData[{
  StyleBox["Simple", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Simple"],

Cell[TextData[{
  StyleBox["SimpleQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SimpleQ"],

Cell[TextData[{
  StyleBox["SimplexMedian", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SimplexMedian"],

Cell[TextData[{
  StyleBox["SinglePredictionCITable", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NonlinearFit",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Common",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SinglePredictionCITable"],

Cell[TextData[{
  "Singularities, in numerical integration, ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["CauchyPrincipalValue",
    ButtonData:>{"NumericalMath`CauchyPrincipalValue`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Singularities"],

Cell[TextData[{
  StyleBox["Sinusoid", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Audio`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Audio",
    ButtonData:>{"Miscellaneous`Audio`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Sinusoid"],

Cell[TextData[{
  StyleBox["SixthTone", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Music",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SixthTone"],

Cell[TextData[{
  StyleBox["Skewness", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DiscreteDistributions",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDiscreteDistributions",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultinormalDistribution",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NormalDistribution",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Skewness"],

Cell[TextData[{
  StyleBox["Small", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Small"],

Cell[TextData[{
  StyleBox["SmallestCyclicGroupGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SmallestCyclicGroupGraph"],

Cell[TextData[{
  StyleBox["SmallPrime", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PrimeQ",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SmallPrime"],

Cell[TextData[{
  StyleBox["SmallStellatedDodecahedron", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polyhedra",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SmallStellatedDodecahedron"],

Cell[TextData[{
  "Smoothing data, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DataSmoothing`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DataSmoothing",
    ButtonData:>{"Statistics`DataSmoothing`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Smoothing data"],

Cell[TextData[{
  StyleBox["SokalSneathDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"SokalSneathDissimilarity"],

Cell[TextData[{
  StyleBox["SolarConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolarConstant"],

Cell[TextData[{
  StyleBox["SolarLuminosity", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolarLuminosity"],

Cell[TextData[{
  StyleBox["SolarRadius", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolarRadius"],

Cell[TextData[{
  StyleBox["SolarSchwarzschildRadius", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolarSchwarzschildRadius"],

Cell[TextData[{
  StyleBox["SolarSystemAbundance", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ChemicalElements",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolarSystemAbundance"],

Cell[TextData[{
  StyleBox["SolidBarEdges", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolidBarEdges"],

Cell[TextData[{
  StyleBox["SolidBarEdgeStyle", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolidBarEdgeStyle"],

Cell[TextData[{
  StyleBox["SolidBarStyle", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SolidBarStyle"],

Cell[TextData[{
  "Solids, three\[Hyphen]dimensional, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polyhedra",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Solids"],

Cell[TextData[{
  "Solutions, plotting, ",
  StyleBox["ImplicitPlot", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`ImplicitPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ImplicitPlot",
    ButtonData:>{"Graphics`ImplicitPlot`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Solutions"],

Cell[TextData[{
  "Solving, inequalities, ",
  StyleBox["SemialgebraicComponents", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["AlgebraicInequalities",
    ButtonData:>{"Algebra`AlgebraicInequalities`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Solving"],

Cell[TextData[{
  "Solving differential equations, numerical, ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Butcher`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Butcher",
    ButtonData:>{"NumericalMath`Butcher`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Solving differential equations"],

Cell[TextData[{
  "Solving matrix equations, ",
  StyleBox["TridiagonalSolve", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tridiagonal",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Solving matrix equations"],

Cell[TextData[{
  "Solving simultaneous congruences, ",
  StyleBox["ChineseRemainder", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Solving simultaneous congruences"],

Cell[TextData[{
  "Sorting, of graph vertices, ",
  StyleBox["TopologicalSort", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Sorting"],

Cell[TextData[{
  "Sound, clipping of, ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Audio`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Audio",
    ButtonData:>{"Miscellaneous`Audio`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Sound"],

Cell[TextData[{
  "synthesis of, ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Audio`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Audio",
    ButtonData:>{"Miscellaneous`Audio`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Sound"],

Cell[TextData[{
  StyleBox["SoundSpeed", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["StandardAtmosphere",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SoundSpeed"],

Cell[TextData[{
  "Spanning tree, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.84"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.84"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Spanning tree"],

Cell[TextData[{
  "Spatial data, analysis of, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Spatial data"],

Cell[TextData[{
  StyleBox["SpatialMedian", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.21"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SpatialMedian"],

Cell[TextData[{
  StyleBox["SpearmanRankCorrelation", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.52"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.52"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SpearmanRankCorrelation"],

Cell[TextData[{
  StyleBox["SpecificHeat", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ChemicalElements",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SpecificHeat"],

Cell[TextData[{
  StyleBox["Spectrum", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Spectrum"],

Cell[TextData[{
  StyleBox["SpeedOfLight", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SpeedOfLight"],

Cell[TextData[{
  StyleBox["SpeedOfSound", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SpeedOfSound"],

Cell[TextData[{
  StyleBox["SpellCheck", "MR"],
  ", ",
  ButtonBox["Miscellaneous`Dictionary`",
    ButtonData:>{"Miscellaneous`Dictionary`", None},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"SpellCheck"],

Cell[TextData[{
  "Sphere, circumscribed, ",
  StyleBox["CircumscribedRadius", "MR"],
  ", ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Sphere"],

Cell[TextData[{
  "inscribed, ",
  StyleBox["InscribedRadius", "MR"],
  ", ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Sphere"],

Cell[TextData[{
  StyleBox["Sphere", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Shapes",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Sphere"],

Cell[TextData[{
  StyleBox["Spherical", "MR"],
  ", ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Spherical"],

Cell[TextData[{
  StyleBox["SphericalDistance", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`CityData`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["CityData",
    ButtonData:>{"Miscellaneous`CityData`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Geodesy",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SphericalDistance"],

Cell[TextData[{
  StyleBox["SphericalPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ParametricPlot3D",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SphericalPlot3D"],

Cell[TextData[{
  StyleBox["SpheroidalDistance", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Geodesy",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SpheroidalDistance"],

Cell[TextData[{
  StyleBox["Spline", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Spline`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Spline",
    ButtonData:>{"Graphics`Spline`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Spline"],

Cell[TextData[{
  StyleBox["Spline", "MR"],
  " package, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Spline`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Spline",
    ButtonData:>{"Graphics`Spline`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Spline package"],

Cell[TextData[{
  StyleBox["SplineDivision", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Spline`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Spline",
    ButtonData:>{"Graphics`Spline`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SplineDivision"],

Cell[TextData[{
  StyleBox["SplineDots", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Spline`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Spline",
    ButtonData:>{"Graphics`Spline`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SplineDots"],

Cell[TextData[{
  StyleBox["SplineFit", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`SplineFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SplineFit",
    ButtonData:>{"NumericalMath`SplineFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SplineFit"],

Cell[TextData[{
  StyleBox["SplineFit", "MR"],
  " package, ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`SplineFit`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SplineFit",
    ButtonData:>{"NumericalMath`SplineFit`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SplineFit package"],

Cell[TextData[{
  StyleBox["SplineFunction", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`SplineFit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SplineFit",
    ButtonData:>{"NumericalMath`SplineFit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SplineFunction"],

Cell[TextData[{
  StyleBox["SplinePoints", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Spline`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Spline",
    ButtonData:>{"Graphics`Spline`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SplinePoints"],

Cell[TextData[{
  StyleBox["SpringEmbedding", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SpringEmbedding"],

Cell[TextData[{
  StyleBox["SqrtMod", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SqrtMod"],

Cell[TextData[{
  StyleBox["SqrtModList", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SqrtModList"],

Cell[TextData[{
  StyleBox["Square", "MR"],
  ", ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Audio`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Audio",
    ButtonData:>{"Miscellaneous`Audio`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Square"],

Cell[TextData[{
  StyleBox["SquaredEuclideanDistance", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"SquaredEuclideanDistance"],

Cell[TextData[{
  StyleBox["SquareFreeQ", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["FactorIntegerECM",
    ButtonData:>{"NumberTheory`FactorIntegerECM`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SquareFreeQ"],

Cell[TextData[{
  StyleBox["SquareMatrixQ", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SquareMatrixQ"],

Cell[TextData[{
  StyleBox["StableIsotopes", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ChemicalElements",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StableIsotopes"],

Cell[TextData[{
  StyleBox["StableMarriage", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StableMarriage"],

Cell[TextData[{
  StyleBox["StackedBarChart", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StackedBarChart"],

Cell[TextData[{
  StyleBox["StackGraphics", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.22"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StackGraphics"],

Cell[TextData[{
  StyleBox["StandardAtmosphere", "MR"],
  " package, ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["StandardAtmosphere",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StandardAtmosphere package"],

Cell[TextData[{
  StyleBox["StandardDeviation", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DiscreteDistributions",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDiscreteDistributions",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultinormalDistribution",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NormalDistribution",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StandardDeviation"],

Cell[TextData[{
  StyleBox["StandardDeviationMLE", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StandardDeviationMLE"],

Cell[TextData[{
  StyleBox["StandardErrorOfSampleMean", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StandardErrorOfSampleMean"],

Cell[TextData[{
  StyleBox["Standardize", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Standardize"],

Cell[TextData[{
  StyleBox["StandardizedResiduals", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NonlinearFit`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NonlinearFit",
    ButtonData:>{"Statistics`NonlinearFit`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Common",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StandardizedResiduals"],

Cell[TextData[{
  StyleBox["StandardPackages", "MR"],
  " directory, ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.3", "3.9"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"StandardPackages directory"],

Cell[TextData[{
  StyleBox["Star", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.39"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.39"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.40"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Star"],

Cell[TextData[{
  StyleBox["StartingParameters", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NonlinearFit`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NonlinearFit",
    ButtonData:>{"Statistics`NonlinearFit`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StartingParameters"],

Cell[TextData[{
  "Statistical distributions, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DiscreteDistributions",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDiscreteDistributions",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultinormalDistribution",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NormalDistribution",
    ButtonData:>{"Statistics`NormalDistribution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Statistical distributions"],

Cell[TextData[{
  "Statistics, association, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Statistics"],

Cell[TextData[{
  "dispersion, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.36"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.36"},
    ButtonStyle->"AddOnsLink"],
  "` \ndispersion, ",
  StyleBox["DispersionReport", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` \nlocation, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.19"},
    ButtonStyle->"AddOnsLink"],
  "` \nlocation, ",
  StyleBox["LocationReport", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "` \nshape, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.61"},
    ButtonStyle->"AddOnsLink"],
  "` \nshape, ",
  StyleBox["ShapeReport", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Statistics"],

Cell[TextData[{
  StyleBox["StefanConstant", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StefanConstant"],

Cell[TextData[{
  StyleBox["Stellate", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Polyhedra`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polyhedra",
    ButtonData:>{"Graphics`Polyhedra`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Stellate"],

Cell[TextData[{
  StyleBox["Stem", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultipleListPlot",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Stem"],

Cell[TextData[{
  "stem plot, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultipleListPlot",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"stem plot"],

Cell[TextData[{
  StyleBox["StirlingFirst", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StirlingFirst"],

Cell[TextData[{
  StyleBox["StirlingSecond", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StirlingSecond"],

Cell[TextData[{
  StyleBox["Strings", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Strings"],

Cell[TextData[{
  StyleBox["Strong", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Strong"],

Cell[TextData[{
  StyleBox["StrongComponents", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StrongComponents"],

Cell[TextData[{
  StyleBox["StronglyConnectedComponents", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StronglyConnectedComponents"],

Cell[TextData[{
  StyleBox["StudentizedResiduals", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Common",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StudentizedResiduals"],

Cell[TextData[{
  StyleBox["StudentNewmanKeuls", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ANOVA",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StudentNewmanKeuls"],

Cell[TextData[{
  StyleBox["StudentTCI", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ConfidenceIntervals",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StudentTCI"],

Cell[TextData[{
  StyleBox["StudentTDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NormalDistribution",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StudentTDistribution"],

Cell[TextData[{
  StyleBox["StudentTPValue", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"StudentTPValue"],

Cell[TextData[{
  StyleBox["Subfactorial", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["CombinatorialFunctions",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Subfactorial"],

Cell[TextData[{
  "Submatrices, ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Submatrices"],

Cell[TextData[{
  StyleBox["SubMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SubMatrix"],

Cell[TextData[{
  "Subsets, construction of, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Subsets"],

Cell[TextData[{
  StyleBox["Subsets", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.79"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.79"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Subsets"],

Cell[TextData[{
  StyleBox["Successor", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["FiniteFields",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Successor"],

Cell[TextData[{
  StyleBox["SummaryReport", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NonlinearFit`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NonlinearFit",
    ButtonData:>{"Statistics`NonlinearFit`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Common",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SummaryReport"],

Cell[TextData[{
  StyleBox["SumOfFactors", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SumOfFactors"],

Cell[TextData[{
  StyleBox["SumOfFactorsType", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SumOfFactorsType"],

Cell[TextData[{
  StyleBox["SumOfSquaresR", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SumOfSquaresR"],

Cell[TextData[{
  StyleBox["SumOfSquaresRepresentations", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SumOfSquaresRepresentations"],

Cell[TextData[{
  "Sums, numerical, ",
  StyleBox["EulerSum", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Sums"],

Cell[TextData[{
  "numerical, ",
  StyleBox["NSum", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "` \nof squared integers, ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Sums"],

Cell[TextData[{
  StyleBox["SupDistance", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"SupDistance"],

Cell[TextData[{
  "Surface of revolution, plot of, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SurfaceOfRevolution",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Surface of revolution"],

Cell[TextData[{
  StyleBox["SurfaceMesh", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SurfaceMesh"],

Cell[TextData[{
  StyleBox["SurfaceMeshStyle", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SurfaceMeshStyle"],

Cell[TextData[{
  StyleBox["SurfaceOfRevolution", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SurfaceOfRevolution",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SurfaceOfRevolution"],

Cell[TextData[{
  StyleBox["SurfaceOfRevolution", "MR"],
  " package, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SurfaceOfRevolution",
    ButtonData:>{"Graphics`SurfaceOfRevolution`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SurfaceOfRevolution package"],

Cell[TextData[{
  "Surfaces, plotting parametric, ",
  StyleBox["ParametricPlot3D", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ParametricPlot3D",
    ButtonData:>{"Graphics`ParametricPlot3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Surfaces"],

Cell[TextData[{
  "plotting three\[Hyphen]dimensional, ",
  StyleBox["ListSurfacePlot3D", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "` \nplotting three\[Hyphen]dimensional, ",
  StyleBox["TriangularSurfacePlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Surfaces"],

Cell[TextData[{
  StyleBox["SymbolLabel", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultipleListPlot",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymbolLabel"],

Cell[TextData[{
  "Symbols, removing completely, ",
  StyleBox["Remove", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.20"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Symbols"],

Cell[TextData[{
  StyleBox["SymbolShape", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultipleListPlot",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["StatisticsPlots",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["StatisticsPlots",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymbolShape"],

Cell[TextData[{
  StyleBox["SymbolStyle", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultipleListPlot",
    ButtonData:>{"Graphics`MultipleListPlot`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["StatisticsPlots",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["StatisticsPlots",
    ButtonData:>{"Statistics`StatisticsPlots`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymbolStyle"],

Cell[TextData[{
  "Symmetric polynomials, ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SymmetricPolynomials",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Symmetric polynomials"],

Cell[TextData[{
  StyleBox["SymmetricGroup", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymmetricGroup"],

Cell[TextData[{
  StyleBox["SymmetricGroupIndex", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymmetricGroupIndex"],

Cell[TextData[{
  StyleBox["SymmetricPolynomial", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SymmetricPolynomials",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymmetricPolynomial"],

Cell[TextData[{
  StyleBox["SymmetricPolynomials", "MR"],
  " package, ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SymmetricPolynomials",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymmetricPolynomials package"],

Cell[TextData[{
  StyleBox["SymmetricQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"SymmetricQ"],

Cell[TextData[{
  StyleBox["SymmetricReduction", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SymmetricPolynomials",
    ButtonData:>{"Algebra`SymmetricPolynomials`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["t", "TI"],
  " distribution, ",
  StyleBox["MultivariateTDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultinormalDistribution",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"t distribution"],

Cell[TextData[{
  "noncentral, ",
  StyleBox["NoncentralStudentTDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` \np\[Hyphen]value, ",
  StyleBox["StudentTPValue", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "` \n",
  StyleBox["StudentTDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NormalDistribution",
    ButtonData:>{"Statistics`NormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"t distribution"],

Cell[TextData[{
  "T\[Hyphen]square(d) distribution, ",
  StyleBox["HotellingTSquareDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultinormalDistribution",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"T-square(d) distribution"],

Cell[TextData[{
  StyleBox["TableauClasses", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TableauClasses"],

Cell[TextData[{
  StyleBox["TableauQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TableauQ"],

Cell[TextData[{
  StyleBox["Tableaux", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tableaux"],

Cell[TextData[{
  StyleBox["TableauxToPermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TableauxToPermutation"],

Cell[TextData[{
  StyleBox["TakeColumns", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TakeColumns"],

Cell[TextData[{
  StyleBox["TakeMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TakeMatrix"],

Cell[TextData[{
  StyleBox["TakeRows", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TakeRows"],

Cell[TextData[{
  StyleBox["TakeWhile", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DataManipulation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DataManipulation",
    ButtonData:>{"Statistics`DataManipulation`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TakeWhile"],

Cell[TextData[{
  "Temperature scales, conversion between, ",
  StyleBox["ConvertTemperature", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Units`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Units",
    ButtonData:>{"Miscellaneous`Units`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Temperature scales"],

Cell[TextData[{
  StyleBox["TemperedChromatic", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Music",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TemperedChromatic"],

Cell[TextData[{
  StyleBox["TemperedMajor", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Music",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TemperedMajor"],

Cell[TextData[{
  StyleBox["TemperedMinor", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Music",
    ButtonData:>{"Miscellaneous`Music`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TemperedMinor"],

Cell[TextData[{
  StyleBox["TermIncrement", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TermIncrement"],

Cell[TextData[{
  StyleBox["Terms", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Terms"],

Cell[TextData[{
  "Tessellation, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tessellation"],

Cell[TextData[{
  "Testing hypotheses, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`HypothesisTests`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Testing hypotheses"],

Cell[TextData[{
  StyleBox["TetrahedralGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TetrahedralGraph"],

Cell[TextData[{
  StyleBox["Tetrahedron", "MR"],
  ", ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polyhedra",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tetrahedron"],

Cell[TextData[{
  StyleBox["TextListPlot", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TextListPlot"],

Cell[TextData[{
  StyleBox["ThermalConductivity", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ChemicalElements",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThermalConductivity"],

Cell[TextData[{
  StyleBox["ThermalConductivityCoefficient", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["StandardAtmosphere",
    ButtonData:>{"Miscellaneous`StandardAtmosphere`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThermalConductivityCoefficient"],

Cell[TextData[{
  "Theta functions, ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`SiegelTheta`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["SiegelTheta",
    ButtonData:>{"NumberTheory`SiegelTheta`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Theta functions"],

Cell[TextData[{
  StyleBox["Thick", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Thick"],

Cell[TextData[{
  StyleBox["ThickDashed", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThickDashed"],

Cell[TextData[{
  "Thiessen polygons, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Thiessen polygons"],

Cell[TextData[{
  StyleBox["Thin", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Thin"],

Cell[TextData[{
  StyleBox["ThinDashed", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThinDashed"],

Cell[TextData[{
  StyleBox["ThomassenGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThomassenGraph"],

Cell[TextData[{
  StyleBox["ThomsonCrossSection", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThomsonCrossSection"],

Cell[TextData[{
  "Three\[Hyphen]dimensional graphics, primitives for, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polyhedra",
    ButtonData:>{"Graphics`Polyhedra`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Three-dimensional graphics"],

Cell[TextData[{
  StyleBox["ThreeScript", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`ThreeScript`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ThreeScript",
    ButtonData:>{"Graphics`ThreeScript`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThreeScript"],

Cell[TextData[{
  StyleBox["ThreeScript", "MR"],
  " package, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`ThreeScript`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ThreeScript",
    ButtonData:>{"Graphics`ThreeScript`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ThreeScript package"],

Cell[TextData[{
  "Tick marks, ",
  StyleBox["Ticks", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tick marks"],

Cell[TextData[{
  StyleBox["Ticks", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics`", "1.47"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Ticks"],

Cell[TextData[{
  StyleBox["TileAreas", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.51"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.51"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TileAreas"],

Cell[TextData[{
  StyleBox["Timing", "MR"],
  ", ",
  ButtonBox["Utilities",
    ButtonData:>{"Utilities`ShowTime`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ShowTime",
    ButtonData:>{"Utilities`ShowTime`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Timing"],

Cell[TextData[{
  StyleBox["ToAdjacencyLists", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToAdjacencyLists"],

Cell[TextData[{
  StyleBox["ToAdjacencyMatrix", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToAdjacencyMatrix"],

Cell[TextData[{
  StyleBox["ToAuthalicRadius", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Geodesy",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToAuthalicRadius"],

Cell[TextData[{
  StyleBox["ToCanonicalSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToCanonicalSetPartition"],

Cell[TextData[{
  StyleBox["ToCycles", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToCycles"],

Cell[TextData[{
  StyleBox["ToDegrees", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Geodesy",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToDegrees"],

Cell[TextData[{
  StyleBox["ToDMS", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Geodesy",
    ButtonData:>{"Miscellaneous`Geodesy`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToDMS"],

Cell[TextData[{
  StyleBox["ToElementCode", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["FiniteFields",
    ButtonData:>{"Algebra`FiniteFields`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToElementCode"],

Cell[TextData[{
  StyleBox["ToInversionVector", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToInversionVector"],

Cell[TextData[{
  StyleBox["ToMinutes", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToMinutes"],

Cell[TextData[{
  StyleBox["ToOrderedPairs", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToOrderedPairs"],

Cell[TextData[{
  StyleBox["TopologicalSort", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.80"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TopologicalSort"],

Cell[TextData[{
  StyleBox["ToQuaternion", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`Quaternions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Quaternions",
    ButtonData:>{"Algebra`Quaternions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToQuaternion"],

Cell[TextData[{
  StyleBox["Toroidal", "MR"],
  ", ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Toroidal"],

Cell[TextData[{
  StyleBox["Torus", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Shapes",
    ButtonData:>{"Graphics`Shapes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Torus"],

Cell[TextData[{
  StyleBox["TotalPower", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`BlackBodyRadiation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["BlackBodyRadiation",
    ButtonData:>{"Miscellaneous`BlackBodyRadiation`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TotalPower"],

Cell[TextData[{
  StyleBox["TotalVariation", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.45"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TotalVariation"],

Cell[TextData[{
  StyleBox["ToUnorderedPairs", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ToUnorderedPairs"],

Cell[TextData[{
  "Transformation, of coordinates in three dimensions, ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.26"},
    ButtonStyle->"AddOnsLink"],
  "` "
}], "Index",
  CellTags->"Transformation"],

Cell[TextData[{
  "of data, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.72"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.72"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Transformation"],

Cell[TextData[{
  "Transforms, Fourier, ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["FourierTransform",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`FourierTransform`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["FourierTransform",
    ButtonData:>{"Calculus`FourierTransform`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Transforms"],

Cell[TextData[{
  "numerical, ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["FourierTransform",
    ButtonData:>{"Calculus`FourierTransform`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Transforms"],

Cell[TextData[{
  StyleBox["TransitionProbability", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ResonanceAbsorptionLines",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TransitionProbability"],

Cell[TextData[{
  StyleBox["TransitiveClosure", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TransitiveClosure"],

Cell[TextData[{
  StyleBox["TransitiveQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TransitiveQ"],

Cell[TextData[{
  StyleBox["TransitiveReduction", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TransitiveReduction"],

Cell[TextData[{
  StyleBox["TranslateShape", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Shapes",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TranslateShape"],

Cell[TextData[{
  StyleBox["TranslateVertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TranslateVertices"],

Cell[TextData[{
  "Translation, of three\[Hyphen]dimensional objects, ",
  StyleBox["TranslateShape", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Shapes",
    ButtonData:>{"Graphics`Shapes`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Translation"],

Cell[TextData[{
  StyleBox["TransposePartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TransposePartition"],

Cell[TextData[{
  StyleBox["TransposeTableau", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TransposeTableau"],

Cell[TextData[{
  StyleBox["TravelingSalesman", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TravelingSalesman"],

Cell[TextData[{
  StyleBox["TravelingSalesmanBounds", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TravelingSalesmanBounds"],

Cell[TextData[{
  "Tree, enumeration, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["CombinatorialFunctions",
    ButtonData:>{"DiscreteMath`CombinatorialFunctions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tree"],

Cell[TextData[{
  "spanning, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.84"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.84"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Tree"],

Cell[TextData[{
  StyleBox["Tree", "MR"],
  " package, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Tree`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tree",
    ButtonData:>{"DiscreteMath`Tree`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tree package"],

Cell[TextData[{
  StyleBox["TreeFind", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Tree`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tree",
    ButtonData:>{"DiscreteMath`Tree`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TreeFind"],

Cell[TextData[{
  StyleBox["TreeIsomorphismQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TreeIsomorphismQ"],

Cell[TextData[{
  StyleBox["TreePlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Tree`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tree",
    ButtonData:>{"DiscreteMath`Tree`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TreePlot"],

Cell[TextData[{
  StyleBox["TreePlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TreePlot"],

Cell[TextData[{
  StyleBox["TreePlot3D", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TreePlot3D"],

Cell[TextData[{
  StyleBox["TreeQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TreeQ"],

Cell[TextData[{
  "Trees, generation of, ",
  StyleBox["MakeTree", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Tree`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tree",
    ButtonData:>{"DiscreteMath`Tree`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Trees"],

Cell[TextData[{
  "search of, ",
  StyleBox["TreeFind", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Tree`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tree",
    ButtonData:>{"DiscreteMath`Tree`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Trees"],

Cell[TextData[{
  StyleBox["TreeToCertificate", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TreeToCertificate"],

Cell[TextData[{
  StyleBox["TrialDivisionLimit", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PrimeQ",
    ButtonData:>{"NumberTheory`PrimeQ`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TrialDivisionLimit"],

Cell[TextData[{
  StyleBox["Triangle", "MR"],
  ", ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Audio`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Audio",
    ButtonData:>{"Miscellaneous`Audio`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Triangle"],

Cell[TextData[{
  StyleBox["TriangleInequalityQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TriangleInequalityQ"],

Cell[TextData[{
  StyleBox["TriangularSurfacePlot", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TriangularSurfacePlot"],

Cell[TextData[{
  "Triangulation, of two\[Hyphen]dimensional points, ",
  StyleBox["DelaunayTriangulation", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Triangulation"],

Cell[TextData[{
  StyleBox["Tridiagonal", "MR"],
  " package, ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tridiagonal",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tridiagonal package"],

Cell[TextData[{
  StyleBox["TridiagonalMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TridiagonalMatrix"],

Cell[TextData[{
  StyleBox["TridiagonalSolve", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Tridiagonal",
    ButtonData:>{"LinearAlgebra`Tridiagonal`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TridiagonalSolve"],

Cell[TextData[{
  StyleBox["TrigFit", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["TrigFit",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TrigFit"],

Cell[TextData[{
  StyleBox["TrigFit", "MR"],
  " package, ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`TrigFit`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["TrigFit",
    ButtonData:>{"NumericalMath`TrigFit`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TrigFit package"],

Cell[TextData[{
  "Trigonometric approximation, ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["TrigFit",
    ButtonData:>{"NumericalMath`TrigFit`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Trigonometric approximation"],

Cell[TextData[{
  StyleBox["TrimmedMean", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TrimmedMean"],

Cell[TextData[{
  StyleBox["TrimPoints", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TrimPoints"],

Cell[TextData[{
  StyleBox["Truncate", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Polyhedra`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polyhedra",
    ButtonData:>{"Graphics`Polyhedra`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Truncate"],

Cell[TextData[{
  StyleBox["Truncation", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputerArithmetic",
    ButtonData:>{"NumericalMath`ComputerArithmetic`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Truncation"],

Cell[TextData[{
  StyleBox["Tukey", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ANOVA",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Tukey"],

Cell[TextData[{
  StyleBox["Turan", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Turan"],

Cell[TextData[{
  StyleBox["TutteGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TutteGraph"],

Cell[TextData[{
  StyleBox["TwoColoring", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.90"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TwoColoring"],

Cell[TextData[{
  StyleBox["TwoSided", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`HypothesisTests`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"TwoSided"],

Cell[TextData[{
  StyleBox["Type", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["Ulp", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Microscope",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Ulp"],

Cell[TextData[{
  "Unbiased estimate, of covariance, ",
  StyleBox["Covariance", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.37"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Unbiased estimate"],

Cell[TextData[{
  "of covariance matrix, ",
  StyleBox["CovarianceMatrix", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.41"},
    ButtonStyle->"AddOnsLink"],
  "` \nof standard deviation, ",
  StyleBox["StandardDeviation", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` \nof variance, ",
  StyleBox["Variance", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Unbiased estimate"],

Cell[TextData[{
  StyleBox["Undecagon", "MR"],
  ", ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Undecagon"],

Cell[TextData[{
  StyleBox["Undirected", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Undirected"],

Cell[TextData[{
  StyleBox["UndirectedQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UndirectedQ"],

Cell[TextData[{
  StyleBox["UniformDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UniformDistribution"],

Cell[TextData[{
  StyleBox["UnionSet", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnionSet"],

Cell[TextData[{
  StyleBox["Uniquely3ColorableGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Uniquely3ColorableGraph"],

Cell[TextData[{
  "Unit in the last place, ",
  StyleBox["Ulp", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Microscope",
    ButtonData:>{"NumericalMath`Microscope`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Unit in the last place"],

Cell[TextData[{
  StyleBox["UnitQuaternionQ", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Quaternions",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnitQuaternionQ"],

Cell[TextData[{
  StyleBox["UnitQuaternions", "MR"],
  ", ",
  ButtonBox["Algebra",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Quaternions",
    ButtonData:>{"Algebra`Quaternions`", "1.23"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnitQuaternions"],

Cell[TextData[{
  StyleBox["UnitransitiveGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnitransitiveGraph"],

Cell[TextData[{
  "Units, conversion between, ",
  StyleBox["Convert", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Units`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Units",
    ButtonData:>{"Miscellaneous`Units`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Units"],

Cell[TextData[{
  StyleBox["Units", "MR"],
  " package, ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Units`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Units",
    ButtonData:>{"Miscellaneous`Units`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Units package"],

Cell[TextData[{
  StyleBox["UnrankBinarySubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankBinarySubset"],

Cell[TextData[{
  StyleBox["UnrankGrayCodeSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankGrayCodeSubset"],

Cell[TextData[{
  StyleBox["UnrankKSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankKSetPartition"],

Cell[TextData[{
  StyleBox["UnrankKSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankKSubset"],

Cell[TextData[{
  StyleBox["UnrankPermutation", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankPermutation"],

Cell[TextData[{
  StyleBox["UnrankRGF", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankRGF"],

Cell[TextData[{
  StyleBox["UnrankSetPartition", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.28"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankSetPartition"],

Cell[TextData[{
  StyleBox["UnrankSubset", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.14"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnrankSubset"],

Cell[TextData[{
  StyleBox["UnweightedQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UnweightedQ"],

Cell[TextData[{
  StyleBox["UpperDiagonalMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UpperDiagonalMatrix"],

Cell[TextData[{
  StyleBox["UpperLeft", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UpperLeft"],

Cell[TextData[{
  StyleBox["UpperRight", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"UpperRight"],

Cell[TextData[{
  StyleBox["UpperStatisticalWeight", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ResonanceAbsorptionLines",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["V", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.35"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"V"],

Cell[TextData[{
  StyleBox["VacuumPermeability", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VacuumPermeability"],

Cell[TextData[{
  StyleBox["VacuumPermittivity", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VacuumPermittivity"],

Cell[TextData[{
  StyleBox["VacuumWavelength", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ResonanceAbsorptionLines",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VacuumWavelength"],

Cell[TextData[{
  "Vaporization, heat of, ",
  StyleBox["HeatOfVaporization", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ChemicalElements",
    ButtonData:>{"Miscellaneous`ChemicalElements`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Vaporization"],

Cell[TextData[{
  "Variance, analysis of, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NonlinearFit",
    ButtonData:>{"Statistics`NonlinearFit`", "1.17"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Variance"],

Cell[TextData[{
  StyleBox["Variance", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DiscreteDistributions",
    ButtonData:>{"Statistics`DiscreteDistributions`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDiscreteDistributions",
    ButtonData:>{"Statistics`MultiDiscreteDistributions`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultinormalDistribution",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NormalDistribution",
    ButtonData:>{"Statistics`NormalDistribution`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Variance"],

Cell[TextData[{
  StyleBox["VarianceCI", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ConfidenceIntervals",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VarianceCI"],

Cell[TextData[{
  StyleBox["VarianceInflation", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.31"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Common",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VarianceInflation"],

Cell[TextData[{
  StyleBox["VarianceMLE", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VarianceMLE"],

Cell[TextData[{
  StyleBox["VarianceOfSampleMean", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VarianceOfSampleMean"],

Cell[TextData[{
  StyleBox["VarianceRatioCI", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ConfidenceIntervals",
    ButtonData:>{"Statistics`ConfidenceIntervals`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VarianceRatioCI"],

Cell[TextData[{
  StyleBox["VarianceRatioTest", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`HypothesisTests`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VarianceRatioTest"],

Cell[TextData[{
  StyleBox["VarianceTest", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`HypothesisTests`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["HypothesisTests",
    ButtonData:>{"Statistics`HypothesisTests`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VarianceTest"],

Cell[TextData[{
  "Variational methods, ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VariationalMethods`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VariationalMethods",
    ButtonData:>{"Calculus`VariationalMethods`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Variational methods"],

Cell[TextData[{
  StyleBox["VariationalBound", "MR"],
  ", ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VariationalMethods`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VariationalMethods",
    ButtonData:>{"Calculus`VariationalMethods`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VariationalBound"],

Cell[TextData[{
  StyleBox["VariationalD", "MR"],
  ", ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VariationalMethods`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VariationalMethods",
    ButtonData:>{"Calculus`VariationalMethods`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VariationalD"],

Cell[TextData[{
  StyleBox["VariationalMethods", "MR"],
  " package, ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VariationalMethods`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VariationalMethods",
    ButtonData:>{"Calculus`VariationalMethods`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VariationalMethods package"],

Cell[TextData[{
  "Vector fields, analysis of, ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Vector fields"],

Cell[TextData[{
  "plotting three\[Hyphen]dimensional, ",
  StyleBox["PlotVectorField3D", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`PlotField3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PlotField3D",
    ButtonData:>{"Graphics`PlotField3D`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` \nplotting two\[Hyphen]dimensional, ",
  StyleBox["PlotVectorField", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PlotField",
    ButtonData:>{"Graphics`PlotField`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "IndexSubentry",
  CellTags->"Vector fields"],

Cell[TextData[{
  "Vector product, in various coordinate systems, ",
  StyleBox["CrossProduct", "MR"],
  ", ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Vector product"],

Cell[TextData[{
  "Vector space, ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Orthogonalization",
    ButtonData:>{"LinearAlgebra`Orthogonalization`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Vector space"],

Cell[TextData[{
  StyleBox["VectorAnalysis", "MR"],
  " package, ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VectorAnalysis package"],

Cell[TextData[{
  StyleBox["VectorHeads", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`PlotField3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PlotField3D",
    ButtonData:>{"Graphics`PlotField3D`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VectorHeads"],

Cell[TextData[{
  "Vectors, multiplication of, ",
  StyleBox["DotProduct", "MR"],
  ", ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Vectors"],

Cell[TextData[{
  StyleBox["VertexColor", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexColor"],

Cell[TextData[{
  StyleBox["VertexColoring", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexColoring"],

Cell[TextData[{
  StyleBox["VertexConnectivity", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.68"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.68"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexConnectivity"],

Cell[TextData[{
  StyleBox["VertexConnectivityGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexConnectivityGraph"],

Cell[TextData[{
  StyleBox["VertexCover", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexCover"],

Cell[TextData[{
  StyleBox["VertexCoverQ", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.74"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexCoverQ"],

Cell[TextData[{
  StyleBox["VertexLabel", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexLabel"],

Cell[TextData[{
  StyleBox["VertexLabelColor", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexLabelColor"],

Cell[TextData[{
  StyleBox["VertexLabelPosition", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexLabelPosition"],

Cell[TextData[{
  StyleBox["VertexList", "MR"],
  ", ",
  ButtonBox["DiscreteMath`GraphPlot`",
    ButtonData:>{"DiscreteMath`GraphPlot`", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VertexList"],

Cell[TextData[{
  StyleBox["VertexNumber", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.78"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.78"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexNumber"],

Cell[TextData[{
  StyleBox["VertexNumberColor", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexNumberColor"],

Cell[TextData[{
  StyleBox["VertexNumberPosition", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexNumberPosition"],

Cell[TextData[{
  StyleBox["VertexStyle", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexStyle"],

Cell[TextData[{
  StyleBox["VertexWeight", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"VertexWeight"],

Cell[TextData[{
  StyleBox["Vertical", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Common",
    ButtonData:>{"Graphics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Vertical"],

Cell[TextData[{
  StyleBox["Vertices", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.34"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Polyhedra`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polyhedra",
    ButtonData:>{"Graphics`Polyhedra`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Vertices"],

Cell[TextData[{
  StyleBox["viewpoint", "MR"],
  " 3\[Hyphen]Script command, ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ThreeScript",
    ButtonData:>{"Graphics`ThreeScript`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"viewpoint 3-Script command"],

Cell[TextData[{
  StyleBox["Volume", "MR"],
  ", ",
  ButtonBox["Geometry",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Polytopes",
    ButtonData:>{"Geometry`Polytopes`", "1.9"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Volume"],

Cell[TextData[{
  "Voronoi polygons, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Voronoi polygons"],

Cell[TextData[{
  StyleBox["VoronoiDiagram", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ComputationalGeometry",
    ButtonData:>{"DiscreteMath`ComputationalGeometry`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["WaltherGraph", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WaltherGraph"],

Cell[TextData[{
  StyleBox["Waveform", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Audio`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Audio",
    ButtonData:>{"Miscellaneous`Audio`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Waveform"],

Cell[TextData[{
  StyleBox["WavelengthAbsorptionMap", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ResonanceAbsorptionLines",
    ButtonData:>{"Miscellaneous`ResonanceAbsorptionLines`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WavelengthAbsorptionMap"],

Cell[TextData[{
  StyleBox["Weak", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Weak"],

Cell[TextData[{
  StyleBox["WeaklyConnectedComponents", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.81"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WeaklyConnectedComponents"],

Cell[TextData[{
  StyleBox["WeakMixingAngle", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["PhysicalConstants",
    ButtonData:>{"Miscellaneous`PhysicalConstants`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WeakMixingAngle"],

Cell[TextData[{
  "Wedge product, in various coordinate systems, ",
  StyleBox["CrossProduct", "MR"],
  ", ",
  ButtonBox["Calculus",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["VectorAnalysis",
    ButtonData:>{"Calculus`VectorAnalysis`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Wedge product"],

Cell[TextData[{
  StyleBox["WeibullDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ContinuousDistributions",
    ButtonData:>{"Statistics`ContinuousDistributions`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WeibullDistribution"],

Cell[TextData[{
  "Weighted least\[Hyphen]squares fitting, ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Weighted least-squares fitting"],

Cell[TextData[{
  StyleBox["WeightingFunction", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WeightingFunction"],

Cell[TextData[{
  StyleBox["WeightRange", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WeightRange"],

Cell[TextData[{
  "Weights, in Gaussian quadrature, ",
  StyleBox["GaussianQuadratureWeights", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["GaussianQuadrature",
    ButtonData:>{"NumericalMath`GaussianQuadrature`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Weights, in Gaussian quadrature"],

Cell[TextData[{
  "Weights, in Newton\[Hyphen]Cotes quadrature, ",
  StyleBox["NewtonCotesWeights", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NewtonCotes",
    ButtonData:>{"NumericalMath`NewtonCotes`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Weights, in Newton-Cotes quadrature"],

Cell[TextData[{
  StyleBox["Weights", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["LinearRegression",
    ButtonData:>{"Statistics`LinearRegression`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`NonlinearFit`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NonlinearFit",
    ButtonData:>{"Statistics`NonlinearFit`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Common",
    ButtonData:>{"Statistics`Common`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Weights"],

Cell[TextData[{
  StyleBox["Wheel", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.59"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.64"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Wheel"],

Cell[TextData[{
  StyleBox["WhichRootOfUnity", "MR"],
  ", ",
  ButtonBox["NumberTheory",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NumberTheoryFunctions",
    ButtonData:>{"NumberTheory`NumberTheoryFunctions`", "1.70"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WhichRootOfUnity"],

Cell[TextData[{
  "Width, of Butcher tree, ",
  StyleBox["ButcherWidth", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Butcher",
    ButtonData:>{"NumericalMath`Butcher`", "1.42"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Width"],

Cell[TextData[{
  StyleBox["WireFrame", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Shapes`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Shapes",
    ButtonData:>{"Graphics`Shapes`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WireFrame"],

Cell[TextData[{
  StyleBox["WishartDistribution", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultinormalDistribution",
    ButtonData:>{"Statistics`MultinormalDistribution`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WishartDistribution"],

Cell[TextData[{
  StyleBox["WorkingPrecision", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Approximations`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Approximations",
    ButtonData:>{"NumericalMath`Approximations`", "1.11"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Approximations",
    ButtonData:>{"NumericalMath`Approximations`", "1.33"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["BesselZeros",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.7"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["InterpolateRoot",
    ButtonData:>{"NumericalMath`InterpolateRoot`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.8"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.15"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NSeries`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NSeries",
    ButtonData:>{"NumericalMath`NSeries`", "1.3"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["ANOVA",
    ButtonData:>{"Statistics`ANOVA`", "1.13"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorkingPrecision"],

Cell[TextData[{
  StyleBox["WorldBackground", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldBackground"],

Cell[TextData[{
  StyleBox["WorldBorders", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldBorders"],

Cell[TextData[{
  StyleBox["WorldClipping", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldClipping"],

Cell[TextData[{
  StyleBox["WorldCountries", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldCountries"],

Cell[TextData[{
  StyleBox["WorldDatabase", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldDatabase"],

Cell[TextData[{
  StyleBox["WorldFrame", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldFrame"],

Cell[TextData[{
  StyleBox["WorldFrameParts", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldFrameParts"],

Cell[TextData[{
  StyleBox["WorldGraphics", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.30"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldGraphics"],

Cell[TextData[{
  StyleBox["WorldGrid", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldGrid"],

Cell[TextData[{
  StyleBox["WorldGridBehind", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldGridBehind"],

Cell[TextData[{
  StyleBox["WorldGridStyle", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldGridStyle"],

Cell[TextData[{
  StyleBox["WorldPlot", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldPlot"],

Cell[TextData[{
  StyleBox["WorldPlot", "MR"],
  " package, ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldPlot package"],

Cell[TextData[{
  StyleBox["WorldPoints", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldPoints"],

Cell[TextData[{
  StyleBox["WorldProjection", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldProjection"],

Cell[TextData[{
  StyleBox["WorldRange", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldRange"],

Cell[TextData[{
  StyleBox["WorldRotatedRange", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldRotatedRange"],

Cell[TextData[{
  StyleBox["WorldRotation", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldRotation"],

Cell[TextData[{
  StyleBox["WorldToGraphics", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["WorldPlot",
    ButtonData:>{"Miscellaneous`WorldPlot`", "1.20"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"WorldToGraphics"],

Cell[TextData[{
  StyleBox["WynnDegree", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["NLimit",
    ButtonData:>{"NumericalMath`NLimit`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["XSpacing", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["YIQColor", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Colors",
    ButtonData:>{"Graphics`Colors`", "1.2"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"YIQColor"],

Cell[TextData[{
  "Young tableaux, ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.18"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Young tableaux"],

Cell[TextData[{
  StyleBox["YSpacing", "MR"],
  ", ",
  ButtonBox["Graphics",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Graphics3D",
    ButtonData:>{"Graphics`Graphics3D`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["YuleDissimilarity", "MR"],
  ", ",
  ButtonBox["Statistics`ClusterAnalysis`",
    ButtonData:>{"Statistics`ClusterAnalysis`"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellTags->"YuleDissimilarity"],

Cell[TextData[{
  "Zero finding, of Bessel functions, ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["BesselZeros",
    ButtonData:>{"NumericalMath`BesselZeros`", "1.5"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"Zero finding"],

Cell[TextData[{
  StyleBox["ZeroMatrix", "MR"],
  ", ",
  ButtonBox["LinearAlgebra",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MatrixManipulation",
    ButtonData:>{"LinearAlgebra`MatrixManipulation`", "1.16"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ZeroMatrix"],

Cell[TextData[{
  StyleBox["ZeroMean", "MR"],
  ", ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["DescriptiveStatistics",
    ButtonData:>{"Statistics`DescriptiveStatistics`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "` , ",
  ButtonBox["Statistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MultiDescriptiveStatistics",
    ButtonData:>{"Statistics`MultiDescriptiveStatistics`", "1.73"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"ZeroMean"],

Cell[TextData[{
  StyleBox["Zoom", "MR"],
  ", ",
  ButtonBox["DiscreteMath",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Combinatorica",
    ButtonData:>{"DiscreteMath`Combinatorica`", "1.50"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index"],

Cell[TextData[{
  StyleBox["$CityFields", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`CityData`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["CityData",
    ButtonData:>{"Miscellaneous`CityData`", "1.10"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"$CityFields"],

Cell[TextData[{
  StyleBox["$Context", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.3"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$Context"],

Cell[TextData[{
  StyleBox["$ContextPath", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.1", "1.8"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.5", "5.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$ContextPath"],

Cell[TextData[{
  StyleBox["$MachineEpsilon", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Microscope`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Microscope",
    ButtonData:>{"NumericalMath`Microscope`", "1.4"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"$MachineEpsilon"],

Cell[TextData[{
  StyleBox["$MemoryIncrement", "MR"],
  ", ",
  ButtonBox["Utilities",
    ButtonData:>{"Utilities`MemoryConserve`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["MemoryConserve",
    ButtonData:>{"Utilities`MemoryConserve`", "1.1"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"$MemoryIncrement"],

Cell[TextData[{
  StyleBox["$Packages", "MR"],
  ", ",
  ButtonBox["Using Packages",
    ButtonData:>{"6.16.2", "2.2"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"$Packages"],

Cell[TextData[{
  StyleBox["$Post", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`RealOnly`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["RealOnly",
    ButtonData:>{"Miscellaneous`RealOnly`", "1.6"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"$Post"],

Cell[TextData[{
  StyleBox["$RungeKuttaMethod", "MR"],
  ", ",
  ButtonBox["NumericalMath",
    ButtonData:>{"NumericalMath`Butcher`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Butcher",
    ButtonData:>{"NumericalMath`Butcher`", "1.24"},
    ButtonStyle->"AddOnsLink"],
  "`",
  " "
}], "Index",
  CellTags->"$RungeKuttaMethod"],

Cell[TextData[{
  StyleBox["$SoundDisplayFunction", "MR"],
  ", ",
  ButtonBox["Miscellaneous",
    ButtonData:>{"Miscellaneous`Audio`", "1.58"},
    ButtonStyle->"AddOnsLink"],
  "`",
  ButtonBox["Audio",
    ButtonData:>{"Miscellaneous`Audio`", "1.58"},
    ButtonStyle->"AddOnsLink"],
  "`",
  "  "
}], "Index"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 938}},
ScreenStyleEnvironment->"Working",
WindowSize->{619, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1754, 51, 75, 1, 41, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "<<"->{
    Cell[1832, 54, 423, 18, 16, "Index",
      CellTags->"<<"]},
  ".m files"->{
    Cell[2258, 74, 193, 8, 16, "Index",
      CellTags->".m files"]},
  "Abbreviation"->{
    Cell[2807, 101, 243, 8, 16, "Index",
      CellTags->"Abbreviation"]},
  "Abs"->{
    Cell[3053, 111, 440, 16, 16, "Index",
      CellTags->"Abs"]},
  "Abscissa"->{
    Cell[3496, 129, 241, 7, 16, "Index",
      CellTags->"Abscissa"],
    Cell[3740, 138, 237, 7, 16, "IndexSubentry",
      CellTags->"Abscissa"]},
  "AbsIJK"->{
    Cell[3980, 147, 210, 8, 16, "Index",
      CellTags->"AbsIJK"]},
  "Absolute"->{
    Cell[4193, 157, 203, 8, 16, "Index",
      CellTags->"Absolute"]},
  "AccelerationDueToGravity"->{
    Cell[4399, 167, 269, 8, 16, "Index",
      CellTags->"AccelerationDueToGravity"]},
  "Accuracy"->{
    Cell[4671, 177, 227, 7, 16, "Index",
      CellTags->"Accuracy"]},
  "AccuracyGoal"->{
    Cell[4901, 186, 379, 12, 16, "Index",
      CellTags->"AccuracyGoal"]},
  "AcyclicQ"->{
    Cell[5283, 200, 369, 12, 16, "Index",
      CellTags->"AcyclicQ"]},
  "AddEdge"->{
    Cell[5655, 214, 367, 12, 16, "Index",
      CellTags->"AddEdge"]},
  "AddEdges"->{
    Cell[6025, 228, 228, 8, 16, "Index",
      CellTags->"AddEdges"]},
  "AddVertex"->{
    Cell[6256, 238, 230, 8, 16, "Index",
      CellTags->"AddVertex"]},
  "AddVertices"->{
    Cell[6489, 248, 234, 8, 16, "Index",
      CellTags->"AddVertices"]},
  "Adjacency lists"->{
    Cell[6726, 258, 220, 7, 16, "Index",
      CellTags->"Adjacency lists"]},
  "Adjacency matrices"->{
    Cell[6949, 267, 226, 7, 16, "Index",
      CellTags->"Adjacency matrices"]},
  "AdjustedRSquared"->{
    Cell[7178, 276, 368, 12, 16, "Index",
      CellTags->"AdjustedRSquared"]},
  "AdjustedSignIJK"->{
    Cell[7549, 290, 228, 8, 16, "Index",
      CellTags->"AdjustedSignIJK"]},
  "AffineRationalize"->{
    Cell[7780, 300, 241, 8, 16, "Index",
      CellTags->"AffineRationalize"]},
  "AffineShape"->{
    Cell[8024, 310, 211, 8, 16, "Index",
      CellTags->"AffineShape"]},
  "AgeOfUniverse"->{
    Cell[8238, 320, 247, 8, 16, "Index",
      CellTags->"AgeOfUniverse"]},
  "Agglomerate"->{
    Cell[8488, 330, 276, 10, 16, "Index",
      CellTags->"Agglomerate"]},
  "AirWavelength"->{
    Cell[8767, 342, 261, 8, 16, "Index",
      CellTags->"AirWavelength"]},
  "Algebraic extension fields"->{
    Cell[9031, 352, 247, 7, 16, "Index",
      CellTags->"Algebraic extension fields"]},
  "Algebraic inequalities"->{
    Cell[9281, 361, 373, 11, 16, "Index",
      CellTags->"Algebraic inequalities"]},
  "Algebraic numbers"->{
    Cell[9657, 374, 229, 7, 16, "Index",
      CellTags->"Algebraic numbers"]},
  "AlgebraicInequalities package"->{
    Cell[9889, 383, 275, 8, 16, "Index",
      CellTags->"AlgebraicInequalities package"]},
  "Algorithm"->{
    Cell[10167, 393, 230, 8, 16, "Index",
      CellTags->"Algorithm"]},
  "aliquot sequence"->{
    Cell[10400, 403, 238, 7, 16, "Index",
      CellTags->"aliquot sequence"]},
  "AliquotCycle"->{
    Cell[10641, 412, 252, 8, 16, "Index",
      CellTags->"AliquotCycle"]},
  "AliquotSequence"->{
    Cell[10896, 422, 258, 8, 16, "Index",
      CellTags->"AliquotSequence"]},
  "AllColors"->{
    Cell[11157, 432, 207, 8, 16, "Index",
      CellTags->"AllColors"]},
  "AllPairsShortestPath"->{
    Cell[11367, 442, 252, 8, 16, "Index",
      CellTags->"AllPairsShortestPath"]},
  "AllPoints"->{
    Cell[11622, 452, 246, 8, 16, "Index",
      CellTags->"AllPoints"]},
  "AlternatingGroup"->{
    Cell[11871, 462, 244, 8, 16, "Index",
      CellTags->"AlternatingGroup"]},
  "AlternatingGroupIndex"->{
    Cell[12118, 472, 254, 8, 16, "Index",
      CellTags->"AlternatingGroupIndex"]},
  "AlternatingPaths"->{
    Cell[12375, 482, 244, 8, 16, "Index",
      CellTags->"AlternatingPaths"]},
  "ambientlight 3-Script command"->{
    Cell[12622, 492, 265, 8, 16, "Index",
      CellTags->"ambientlight 3-Script command"]},
  "AmplitudeModulation"->{
    Cell[12890, 502, 236, 8, 16, "Index",
      CellTags->"AmplitudeModulation"]},
  "Anagrams"->{
    Cell[13129, 512, 222, 8, 16, "Index",
      CellTags->"Anagrams"]},
  "Analysis of variance"->{
    Cell[13354, 522, 367, 11, 16, "Index",
      CellTags->"Analysis of variance"]},
  "Animate"->{
    Cell[13724, 535, 209, 8, 16, "Index",
      CellTags->"Animate"]},
  "AnimateGraph"->{
    Cell[13936, 545, 377, 12, 16, "Index",
      CellTags->"AnimateGraph"]},
  "Animation"->{
    Cell[14316, 559, 191, 7, 16, "Index",
      CellTags->"Animation"]},
  "Animation package"->{
    Cell[14510, 568, 229, 8, 16, "Index",
      CellTags->"Animation package"]},
  "Annotation"->{
    Cell[14742, 578, 213, 8, 16, "Index",
      CellTags->"Annotation"]},
  "ANOVA"->{
    Cell[14958, 588, 201, 8, 16, "Index",
      CellTags->"ANOVA"]},
  "ANOVATable"->{
    Cell[15162, 598, 491, 16, 32, "Index",
      CellTags->"ANOVATable"]},
  "AntiSymmetricQ"->{
    Cell[15656, 616, 240, 8, 16, "Index",
      CellTags->"AntiSymmetricQ"]},
  "AppendColumns"->{
    Cell[15899, 626, 249, 8, 16, "Index",
      CellTags->"AppendColumns"]},
  "AppendRows"->{
    Cell[16151, 636, 243, 8, 16, "Index",
      CellTags->"AppendRows"]},
  "Applications directory"->{
    Cell[16397, 646, 221, 8, 16, "Index",
      CellTags->"Applications directory"]},
  "Approximate numbers"->{
    Cell[16621, 656, 373, 11, 16, "Index",
      CellTags->"Approximate numbers"]},
  "Approximate polynomials"->{
    Cell[16997, 669, 227, 7, 16, "Index",
      CellTags->"Approximate polynomials"]},
  "ApproximateIntervals"->{
    Cell[17227, 678, 479, 16, 16, "Index",
      CellTags->"ApproximateIntervals"]},
  "ApproximateVertexCover"->{
    Cell[17709, 696, 256, 8, 16, "Index",
      CellTags->"ApproximateVertexCover"]},
  "Approximation of functions"->{
    Cell[17968, 706, 761, 23, 32, "Index",
      CellTags->"Approximation of functions"]},
  "Approximations package"->{
    Cell[18732, 731, 259, 8, 16, "Index",
      CellTags->"Approximations package"]},
  "ArcLengthFactor"->{
    Cell[18994, 741, 236, 8, 16, "Index",
      CellTags->"ArcLengthFactor"]},
  "Area, between curves"->{
    Cell[19233, 751, 215, 7, 16, "Index",
      CellTags->"Area, between curves"]},
  "Area"->{
    Cell[19451, 760, 327, 12, 16, "Index",
      CellTags->"Area"]},
  "Arg"->{
    Cell[19781, 774, 313, 12, 16, "Index",
      CellTags->"Arg"]},
  "ArgColor"->{
    Cell[20097, 788, 211, 8, 16, "Index",
      CellTags->"ArgColor"]},
  "ArgColors package"->{
    Cell[20311, 798, 229, 8, 16, "Index",
      CellTags->"ArgColors package"]},
  "ArgShade"->{
    Cell[20543, 808, 211, 8, 16, "Index",
      CellTags->"ArgShade"]},
  "Arithmetic"->{
    Cell[20757, 818, 244, 8, 16, "Index",
      CellTags->"Arithmetic"]},
  "Arithmetic parameters"->{
    Cell[21004, 828, 244, 7, 16, "Index",
      CellTags->"Arithmetic parameters"]},
  "Arrow"->{
    Cell[21251, 837, 197, 8, 16, "Index",
      CellTags->"Arrow"]},
  "Arrow package"->{
    Cell[21451, 847, 213, 8, 16, "Index",
      CellTags->"Arrow package"]},
  "ArticulationVertices"->{
    Cell[21667, 857, 393, 12, 16, "Index",
      CellTags->"ArticulationVertices"]},
  "AssociationMatrix"->{
    Cell[22063, 871, 268, 8, 16, "Index",
      CellTags->"AssociationMatrix"]},
  "Assumptions"->{
    Cell[22334, 881, 220, 8, 16, "Index",
      CellTags->"Assumptions"]},
  "AsymptoticCorrelationMatrix"->{
    Cell[22557, 891, 260, 8, 16, "Index",
      CellTags->"AsymptoticCorrelationMatrix"]},
  "AsymptoticCovarianceMatrix"->{
    Cell[22820, 901, 258, 8, 16, "Index",
      CellTags->"AsymptoticCovarianceMatrix"]},
  "Atkin-Morain primality certificate"->{
    Cell[23081, 911, 251, 7, 16, "Index",
      CellTags->"Atkin-Morain primality certificate"]},
  "AtmosphericPlot"->{
    Cell[23335, 920, 253, 8, 16, "Index",
      CellTags->"AtmosphericPlot"]},
  "AtomicData"->{
    Cell[23591, 930, 255, 8, 16, "Index",
      CellTags->"AtomicData"]},
  "AtomicNumber"->{
    Cell[23849, 940, 243, 8, 16, "Index",
      CellTags->"AtomicNumber"]},
  "AtomicWeight"->{
    Cell[24095, 950, 243, 8, 16, "Index",
      CellTags->"AtomicWeight"]},
  "Audio package"->{
    Cell[24341, 960, 223, 8, 16, "Index",
      CellTags->"Audio package"]},
  "Autoload directory"->{
    Cell[24567, 970, 214, 8, 16, "Index",
      CellTags->"Autoload directory"]},
  "Autoloading"->{
    Cell[24784, 980, 284, 11, 16, "Index",
      CellTags->"Autoloading"]},
  "Automorphisms"->{
    Cell[25071, 993, 238, 8, 16, "Index",
      CellTags->"Automorphisms"]},
  "AvogadroConstant"->{
    Cell[25312, 1003, 253, 8, 16, "Index",
      CellTags->"AvogadroConstant"]},
  "Axes"->{
    Cell[25568, 1013, 357, 13, 16, "Index",
      CellTags->"Axes"]},
  "AxesFront"->{
    Cell[25928, 1028, 216, 8, 16, "Index",
      CellTags->"AxesFront"]},
  "B"->{
    Cell[26335, 1047, 209, 8, 16, "Index",
      CellTags->"B"]},
  "Back"->{
    Cell[26547, 1057, 205, 8, 16, "Index",
      CellTags->"Back"]},
  "Back substitution"->{
    Cell[26755, 1067, 221, 7, 16, "Index",
      CellTags->"Back substitution"]},
  "Backtrack"->{
    Cell[26979, 1076, 230, 8, 16, "Index",
      CellTags->"Backtrack"]},
  "BarChart"->{
    Cell[27212, 1086, 209, 8, 16, "Index",
      CellTags->"BarChart"]},
  "BarChart3D"->{
    Cell[27424, 1096, 217, 8, 16, "Index",
      CellTags->"BarChart3D"]},
  "BarEdges"->{
    Cell[27644, 1106, 351, 12, 16, "Index",
      CellTags->"BarEdges"]},
  "BarEdgeStyle"->{
    Cell[27998, 1120, 359, 12, 16, "Index",
      CellTags->"BarEdgeStyle"]},
  "BarGroupSpacing"->{
    Cell[28360, 1134, 224, 8, 16, "Index",
      CellTags->"BarGroupSpacing"]},
  "BarLabels"->{
    Cell[28587, 1144, 353, 12, 16, "Index",
      CellTags->"BarLabels"]},
  "BarOrientation"->{
    Cell[28943, 1158, 363, 12, 16, "Index",
      CellTags->"BarOrientation"]},
  "BarSpacing"->{
    Cell[29309, 1172, 214, 8, 16, "Index",
      CellTags->"BarSpacing"]},
  "BarStyle"->{
    Cell[29526, 1182, 474, 16, 16, "Index",
      CellTags->"BarStyle"]},
  "BarValues"->{
    Cell[30003, 1200, 212, 8, 16, "Index",
      CellTags->"BarValues"]},
  "Basis vectors"->{
    Cell[30218, 1210, 225, 7, 16, "Index",
      CellTags->"Basis vectors"]},
  "BasisNames"->{
    Cell[30446, 1219, 356, 12, 16, "Index",
      CellTags->"BasisNames"]},
  "Begin"->{
    Cell[30805, 1233, 187, 8, 16, "Index",
      CellTags->"Begin"]},
  "BeginPackage"->{
    Cell[30995, 1243, 201, 8, 16, "Index",
      CellTags->"BeginPackage"]},
  "BellB"->{
    Cell[31199, 1253, 222, 8, 16, "Index",
      CellTags->"BellB"]},
  "BellmanFord"->{
    Cell[31424, 1263, 234, 8, 16, "Index",
      CellTags->"BellmanFord"]},
  "Benchmark"->{
    Cell[31661, 1273, 214, 8, 16, "Index",
      CellTags->"Benchmark"]},
  "BernoulliDistribution"->{
    Cell[31878, 1283, 265, 8, 16, "Index",
      CellTags->"BernoulliDistribution"]},
  "Bessel function zeros"->{
    Cell[32146, 1293, 229, 7, 16, "Index",
      CellTags->"Bessel function zeros"]},
  "BesselJ"->{
    Cell[32378, 1302, 223, 8, 16, "Index",
      CellTags->"BesselJ"]},
  "BesselJPrimeYJYPrimeZeros"->{
    Cell[32604, 1312, 259, 8, 16, "Index",
      CellTags->"BesselJPrimeYJYPrimeZeros"]},
  "BesselJPrimeYJYPrimeZerosInterval"->{
    Cell[32866, 1322, 276, 8, 16, "Index",
      CellTags->"BesselJPrimeYJYPrimeZerosInterval"]},
  "BesselJPrimeYPrimeJPrimeYPrimeZeros"->{
    Cell[33145, 1332, 279, 8, 16, "Index",
      CellTags->"BesselJPrimeYPrimeJPrimeYPrimeZeros"]},
  "BesselJPrimeYPrimeJPrimeYPrimeZerosInterval"->{
    Cell[33427, 1342, 296, 8, 16, "Index",
      CellTags->"BesselJPrimeYPrimeJPrimeYPrimeZerosInterval"]},
  "BesselJPrimeZeros"->{
    Cell[33726, 1352, 243, 8, 16, "Index",
      CellTags->"BesselJPrimeZeros"]},
  "BesselJPrimeZerosInterval"->{
    Cell[33972, 1362, 260, 8, 16, "Index",
      CellTags->"BesselJPrimeZerosInterval"]},
  "BesselJYJYPrimeZeros"->{
    Cell[34235, 1372, 249, 8, 16, "Index",
      CellTags->"BesselJYJYPrimeZeros"]},
  "BesselJYJYPrimeZerosInterval"->{
    Cell[34487, 1382, 266, 8, 16, "Index",
      CellTags->"BesselJYJYPrimeZerosInterval"]},
  "BesselJZeros"->{
    Cell[34756, 1392, 233, 8, 16, "Index",
      CellTags->"BesselJZeros"]},
  "BesselJZerosInterval"->{
    Cell[34992, 1402, 250, 8, 16, "Index",
      CellTags->"BesselJZerosInterval"]},
  "BesselY"->{
    Cell[35245, 1412, 223, 8, 16, "Index",
      CellTags->"BesselY"]},
  "BesselYPrimeZeros"->{
    Cell[35471, 1422, 243, 8, 16, "Index",
      CellTags->"BesselYPrimeZeros"]},
  "BesselYPrimeZerosInterval"->{
    Cell[35717, 1432, 260, 8, 16, "Index",
      CellTags->"BesselYPrimeZerosInterval"]},
  "BesselYZeros"->{
    Cell[35980, 1442, 233, 8, 16, "Index",
      CellTags->"BesselYZeros"]},
  "BesselYZerosInterval"->{
    Cell[36216, 1452, 250, 8, 16, "Index",
      CellTags->"BesselYZerosInterval"]},
  "BesselZeros package"->{
    Cell[36469, 1462, 247, 8, 16, "Index",
      CellTags->"BesselZeros package"]},
  "BestFit"->{
    Cell[36719, 1472, 485, 16, 16, "Index",
      CellTags->"BestFit"]},
  "BestFitParameters"->{
    Cell[37207, 1490, 505, 16, 32, "Index",
      CellTags->"BestFitParameters"]},
  "BestFitParametersDelta"->{
    Cell[37715, 1508, 380, 12, 16, "Index",
      CellTags->"BestFitParametersDelta"]},
  "BetaDistribution"->{
    Cell[38098, 1522, 259, 8, 16, "Index",
      CellTags->"BetaDistribution"]},
  "Bezier"->{
    Cell[38360, 1532, 335, 12, 16, "Index",
      CellTags->"Bezier"]},
  "Bezier curves"->{
    Cell[38698, 1546, 327, 11, 16, "Index",
      CellTags->"Bezier curves"]},
  "Bias"->{
    Cell[39028, 1559, 369, 12, 16, "Index",
      CellTags->"Bias"]},
  "BiconnectedComponents"->{
    Cell[39400, 1573, 395, 12, 16, "Index",
      CellTags->"BiconnectedComponents"]},
  "BiconnectedQ"->{
    Cell[39798, 1587, 236, 8, 16, "Index",
      CellTags->"BiconnectedQ"]},
  "Biharmonic"->{
    Cell[40037, 1597, 226, 8, 16, "Index",
      CellTags->"Biharmonic"]},
  "Binary Gray code"->{
    Cell[40266, 1607, 260, 9, 16, "Index",
      CellTags->"Binary Gray code"]},
  "Binary quadratic forms"->{
    Cell[40529, 1618, 310, 9, 16, "Index",
      CellTags->"Binary quadratic forms"],
    Cell[40842, 1629, 306, 9, 16, "IndexSubentry",
      CellTags->"Binary quadratic forms"]},
  "Binary trees"->{
    Cell[41151, 1640, 195, 7, 16, "Index",
      CellTags->"Binary trees"]},
  "BinarySearch"->{
    Cell[41349, 1649, 236, 8, 16, "Index",
      CellTags->"BinarySearch"]},
  "BinarySubsets"->{
    Cell[41588, 1659, 238, 8, 16, "Index",
      CellTags->"BinarySubsets"]},
  "BinCounts"->{
    Cell[41829, 1669, 232, 8, 16, "Index",
      CellTags->"BinCounts"]},
  "BinLists"->{
    Cell[42064, 1679, 230, 8, 16, "Index",
      CellTags->"BinLists"]},
  "Binomial"->{
    Cell[42297, 1689, 245, 8, 16, "Index",
      CellTags->"Binomial"]},
  "BinomialDistribution"->{
    Cell[42545, 1699, 263, 8, 16, "Index",
      CellTags->"BinomialDistribution"]},
  "BipartiteMatching"->{
    Cell[42811, 1709, 387, 12, 16, "Index",
      CellTags->"BipartiteMatching"]},
  "BipartiteMatchingAndCover"->{
    Cell[43201, 1723, 262, 8, 16, "Index",
      CellTags->"BipartiteMatchingAndCover"]},
  "BipartiteQ"->{
    Cell[43466, 1733, 232, 8, 16, "Index",
      CellTags->"BipartiteQ"]},
  "Bipolar"->{
    Cell[43701, 1743, 219, 8, 16, "Index",
      CellTags->"Bipolar"]},
  "Bispherical"->{
    Cell[43923, 1753, 227, 8, 16, "Index",
      CellTags->"Bispherical"]},
  "Bivariate statistical distributions"->{
    Cell[44153, 1763, 437, 11, 32, "Index",
      CellTags->"Bivariate statistical distributions"]},
  "BlackBodyProfile"->{
    Cell[44593, 1776, 255, 8, 16, "Index",
      CellTags->"BlackBodyProfile"]},
  "BlackBodyRadiation package"->{
    Cell[44851, 1786, 275, 8, 16, "Index",
      CellTags->"BlackBodyRadiation package"]},
  "BlockMatrix"->{
    Cell[45129, 1796, 245, 8, 16, "Index",
      CellTags->"BlockMatrix"]},
  "BohrRadius"->{
    Cell[45377, 1806, 241, 8, 16, "Index",
      CellTags->"BohrRadius"]},
  "BoilingPoint"->{
    Cell[45621, 1816, 243, 8, 16, "Index",
      CellTags->"BoilingPoint"]},
  "BoltzmannConstant"->{
    Cell[45867, 1826, 255, 8, 16, "Index",
      CellTags->"BoltzmannConstant"]},
  "Bonferroni"->{
    Cell[46125, 1836, 212, 8, 16, "Index",
      CellTags->"Bonferroni"]},
  "BooleanAlgebra"->{
    Cell[46340, 1846, 240, 8, 16, "Index",
      CellTags->"BooleanAlgebra"]},
  "BoundedDiagram"->{
    Cell[46583, 1856, 256, 8, 16, "Index",
      CellTags->"BoundedDiagram"]},
  "boundingbox 3-Script command"->{
    Cell[46842, 1866, 263, 8, 16, "Index",
      CellTags->"boundingbox 3-Script command"]},
  "Box"->{
    Cell[47108, 1876, 218, 8, 16, "Index",
      CellTags->"Box"]},
  "Box plot"->{
    Cell[47329, 1886, 205, 7, 16, "Index",
      CellTags->"Box plot"]},
  "Boxes"->{
    Cell[47537, 1895, 230, 9, 16, "Index",
      CellTags->"Boxes"]},
  "BoxExtraSpacing"->{
    Cell[47770, 1906, 241, 8, 16, "Index",
      CellTags->"BoxExtraSpacing"]},
  "BoxLabels"->{
    Cell[48014, 1916, 229, 8, 16, "Index",
      CellTags->"BoxLabels"]},
  "BoxLineStyle"->{
    Cell[48246, 1926, 235, 8, 16, "Index",
      CellTags->"BoxLineStyle"]},
  "BoxMedianStyle"->{
    Cell[48484, 1936, 239, 8, 16, "Index",
      CellTags->"BoxMedianStyle"]},
  "BoxOrientation"->{
    Cell[48726, 1946, 239, 8, 16, "Index",
      CellTags->"BoxOrientation"]},
  "BoxOutliers"->{
    Cell[48968, 1956, 233, 8, 16, "Index",
      CellTags->"BoxOutliers"]},
  "BoxOutlierShapes"->{
    Cell[49204, 1966, 243, 8, 16, "Index",
      CellTags->"BoxOutlierShapes"]},
  "BoxQuantile"->{
    Cell[49450, 1976, 233, 8, 16, "Index",
      CellTags->"BoxQuantile"]},
  "BoxStyle"->{
    Cell[49686, 1986, 227, 8, 16, "Index",
      CellTags->"BoxStyle"]},
  "BoxWhiskerPlot"->{
    Cell[49916, 1996, 239, 8, 16, "Index",
      CellTags->"BoxWhiskerPlot"]},
  "Brake"->{
    Cell[50158, 2006, 226, 8, 16, "Index",
      CellTags->"Brake"]},
  "BrayCurtisDistance"->{
    Cell[50387, 2016, 290, 10, 16, "Index",
      CellTags->"BrayCurtisDistance"]},
  "Branch cuts"->{
    Cell[50680, 2028, 310, 11, 16, "Index",
      CellTags->"Branch cuts"]},
  "Breadth-first search"->{
    Cell[50993, 2041, 238, 7, 16, "Index",
      CellTags->"Breadth-first search"]},
  "BreadthFirstTraversal"->{
    Cell[51234, 2050, 395, 12, 16, "Index",
      CellTags->"BreadthFirstTraversal"]},
  "Brelaz"->{
    Cell[51632, 2064, 224, 8, 16, "Index",
      CellTags->"Brelaz"]},
  "BrelazColoring"->{
    Cell[51859, 2074, 240, 8, 16, "Index",
      CellTags->"BrelazColoring"]},
  "Bridges"->{
    Cell[52102, 2084, 367, 12, 16, "Index",
      CellTags->"Bridges"]},
  "Business graphics"->{
    Cell[52472, 2098, 472, 15, 16, "Index",
      CellTags->"Business graphics"]},
  "Butcher package"->{
    Cell[52947, 2115, 231, 8, 16, "Index",
      CellTags->"Butcher package"]},
  "Butcher trees"->{
    Cell[53181, 2125, 259, 9, 16, "Index",
      CellTags->"Butcher trees"],
    Cell[53443, 2136, 415, 14, 32, "IndexSubentry",
      CellTags->"Butcher trees"]},
  "ButcherAlpha"->{
    Cell[53861, 2152, 226, 8, 16, "Index",
      CellTags->"ButcherAlpha"]},
  "ButcherBeta"->{
    Cell[54090, 2162, 224, 8, 16, "Index",
      CellTags->"ButcherBeta"]},
  "ButcherBetaBar"->{
    Cell[54317, 2172, 230, 8, 16, "Index",
      CellTags->"ButcherBetaBar"]},
  "ButcherColumnConditions"->{
    Cell[54550, 2182, 248, 8, 16, "Index",
      CellTags->"ButcherColumnConditions"]},
  "ButcherGamma"->{
    Cell[54801, 2192, 226, 8, 16, "Index",
      CellTags->"ButcherGamma"]},
  "ButcherHeight"->{
    Cell[55030, 2202, 228, 8, 16, "Index",
      CellTags->"ButcherHeight"]},
  "ButcherOrder"->{
    Cell[55261, 2212, 226, 8, 16, "Index",
      CellTags->"ButcherOrder"]},
  "ButcherPhi"->{
    Cell[55490, 2222, 222, 8, 16, "Index",
      CellTags->"ButcherPhi"]},
  "ButcherPlot"->{
    Cell[55715, 2232, 224, 8, 16, "Index",
      CellTags->"ButcherPlot"]},
  "ButcherPlotColumns"->{
    Cell[55942, 2242, 238, 8, 16, "Index",
      CellTags->"ButcherPlotColumns"]},
  "ButcherPlotLabel"->{
    Cell[56183, 2252, 234, 8, 16, "Index",
      CellTags->"ButcherPlotLabel"]},
  "ButcherPlotNodeSize"->{
    Cell[56420, 2262, 240, 8, 16, "Index",
      CellTags->"ButcherPlotNodeSize"]},
  "ButcherPlotRootSize"->{
    Cell[56663, 2272, 240, 8, 16, "Index",
      CellTags->"ButcherPlotRootSize"]},
  "ButcherPrincipalError"->{
    Cell[56906, 2282, 244, 8, 16, "Index",
      CellTags->"ButcherPrincipalError"]},
  "ButcherQuadratureConditions"->{
    Cell[57153, 2292, 256, 8, 16, "Index",
      CellTags->"ButcherQuadratureConditions"]},
  "ButcherRowConditions"->{
    Cell[57412, 2302, 242, 8, 16, "Index",
      CellTags->"ButcherRowConditions"]},
  "ButcherSigma"->{
    Cell[57657, 2312, 226, 8, 16, "Index",
      CellTags->"ButcherSigma"]},
  "ButcherTreeCount"->{
    Cell[57886, 2322, 234, 8, 16, "Index",
      CellTags->"ButcherTreeCount"]},
  "ButcherTreeQ"->{
    Cell[58123, 2332, 226, 8, 16, "Index",
      CellTags->"ButcherTreeQ"]},
  "ButcherTrees"->{
    Cell[58352, 2342, 226, 8, 16, "Index",
      CellTags->"ButcherTrees"]},
  "ButcherTreeSimplify"->{
    Cell[58581, 2352, 240, 8, 16, "Index",
      CellTags->"ButcherTreeSimplify"]},
  "ButcherWidth"->{
    Cell[58824, 2362, 226, 8, 16, "Index",
      CellTags->"ButcherWidth"]},
  "ButterflyGraph"->{
    Cell[59053, 2372, 240, 8, 16, "Index",
      CellTags->"ButterflyGraph"]},
  "CageGraph"->{
    Cell[59296, 2382, 371, 12, 16, "Index",
      CellTags->"CageGraph"]},
  "Calculus"->{
    Cell[59670, 2396, 220, 7, 16, "Index",
      CellTags->"Calculus"]},
  "Calculus of variations"->{
    Cell[59893, 2405, 235, 7, 16, "Index",
      CellTags->"Calculus of variations"]},
  "Calendar"->{
    Cell[60131, 2414, 219, 8, 16, "Index",
      CellTags->"Calendar"]},
  "Calendar package"->{
    Cell[60353, 2424, 235, 8, 16, "Index",
      CellTags->"Calendar package"]},
  "CalendarChange"->{
    Cell[60591, 2434, 231, 8, 16, "Index",
      CellTags->"CalendarChange"]},
  "Calendars"->{
    Cell[60825, 2444, 219, 7, 16, "Index",
      CellTags->"Calendars"]},
  "CanberraDistance"->{
    Cell[61047, 2453, 286, 10, 16, "Index",
      CellTags->"CanberraDistance"]},
  "Cartesian"->{
    Cell[61336, 2465, 223, 8, 16, "Index",
      CellTags->"Cartesian"]},
  "CartesianMap"->{
    Cell[61562, 2475, 221, 8, 16, "Index",
      CellTags->"CartesianMap"]},
  "CartesianProduct"->{
    Cell[61786, 2485, 244, 8, 16, "Index",
      CellTags->"CartesianProduct"]},
  "Cartography"->{
    Cell[62033, 2495, 205, 7, 16, "Index",
      CellTags->"Cartography"]},
  "Cascade"->{
    Cell[62241, 2504, 212, 8, 16, "Index",
      CellTags->"Cascade"]},
  "CatalanNumber"->{
    Cell[62456, 2514, 255, 8, 16, "Index",
      CellTags->"CatalanNumber"]},
  "CatcherMatrix"->{
    Cell[62714, 2524, 362, 12, 16, "Index",
      CellTags->"CatcherMatrix"]},
  "CategoryCounts"->{
    Cell[63079, 2538, 242, 8, 16, "Index",
      CellTags->"CategoryCounts"]},
  "CategoryLists"->{
    Cell[63324, 2548, 240, 8, 16, "Index",
      CellTags->"CategoryLists"]},
  "Cauchy distribution"->{
    Cell[63567, 2558, 257, 7, 16, "Index",
      CellTags->"Cauchy distribution"]},
  "Cauchy principal value"->{
    Cell[63827, 2567, 249, 7, 16, "Index",
      CellTags->"Cauchy principal value"]},
  "Cauchy's integral formula"->{
    Cell[64079, 2576, 246, 7, 16, "Index",
      CellTags->"Cauchy's integral formula"]},
  "CauchyDistribution"->{
    Cell[64328, 2585, 263, 8, 16, "Index",
      CellTags->"CauchyDistribution"]},
  "CauchyPrincipalValue"->{
    Cell[64594, 2595, 267, 8, 16, "Index",
      CellTags->"CauchyPrincipalValue"]},
  "CauchyPrincipalValue package"->{
    Cell[64864, 2605, 283, 8, 16, "Index",
      CellTags->"CauchyPrincipalValue package"]},
  "CDF"->{
    Cell[65150, 2615, 973, 28, 48, "Index",
      CellTags->"CDF"]},
  "CellMeans"->{
    Cell[66126, 2645, 210, 8, 16, "Index",
      CellTags->"CellMeans"]},
  "Center"->{
    Cell[66339, 2655, 224, 8, 16, "Index",
      CellTags->"Center"]},
  "Central limit theorem"->{
    Cell[66566, 2665, 231, 7, 16, "Index",
      CellTags->"Central limit theorem"]},
  "CentralMoment"->{
    Cell[66800, 2674, 576, 16, 48, "Index",
      CellTags->"CentralMoment"]},
  "CentsToHertz"->{
    Cell[67379, 2692, 221, 8, 16, "Index",
      CellTags->"CentsToHertz"]},
  "Certificate"->{
    Cell[67603, 2702, 346, 12, 16, "Index",
      CellTags->"Certificate"]},
  "Certificate of primality"->{
    Cell[67952, 2716, 270, 9, 16, "Index",
      CellTags->"Certificate of primality"]},
  "Certificate of primality checking"->{
    Cell[68225, 2727, 293, 9, 16, "Index",
      CellTags->"Certificate of primality checking"]},
  "CGS"->{
    Cell[68521, 2738, 203, 8, 16, "Index",
      CellTags->"CGS"]},
  "ChangeEdges"->{
    Cell[68727, 2748, 234, 8, 16, "Index",
      CellTags->"ChangeEdges"]},
  "ChangeVertices"->{
    Cell[68964, 2758, 240, 8, 16, "Index",
      CellTags->"ChangeVertices"]},
  "Chaotic behavior"->{
    Cell[69207, 2768, 239, 7, 16, "Index",
      CellTags->"Chaotic behavior"]},
  "Characteristic"->{
    Cell[69449, 2777, 228, 8, 16, "Index",
      CellTags->"Characteristic"]},
  "CharacteristicFunction"->{
    Cell[69680, 2787, 1011, 28, 64, "Index",
      CellTags->"CharacteristicFunction"]},
  "Charts"->{
    Cell[70694, 2817, 234, 9, 16, "Index",
      CellTags->"Charts"],
    Cell[70931, 2828, 754, 25, 64, "IndexSubentry",
      CellTags->"Charts"]},
  "Chebyshev approximation"->{
    Cell[71688, 2855, 354, 11, 16, "Index",
      CellTags->"Chebyshev approximation"]},
  "Chemical elements"->{
    Cell[72045, 2868, 231, 7, 16, "Index",
      CellTags->"Chemical elements"]},
  "ChemicalElements package"->{
    Cell[72279, 2877, 267, 8, 16, "Index",
      CellTags->"ChemicalElements package"]},
  "Chi-square(d)"->{
    Cell[72549, 2887, 648, 19, 32, "Index",
      CellTags->"Chi-square(d)"]},
  "Chi-square(d) distribution"->{
    Cell[73200, 2908, 306, 9, 16, "Index",
      CellTags->"Chi-square(d) distribution"],
    Cell[73509, 2919, 514, 15, 32, "IndexSubentry",
      CellTags->"Chi-square(d) distribution"]},
  "ChiDistribution"->{
    Cell[74026, 2936, 257, 8, 16, "Index",
      CellTags->"ChiDistribution"]},
  "ChineseRemainder"->{
    Cell[74286, 2946, 260, 8, 16, "Index",
      CellTags->"ChineseRemainder"]},
  "ChiSquareCI"->{
    Cell[74549, 2956, 242, 8, 16, "Index",
      CellTags->"ChiSquareCI"]},
  "ChiSquareDistribution"->{
    Cell[74794, 2966, 415, 12, 32, "Index",
      CellTags->"ChiSquareDistribution"]},
  "ChiSquarePValue"->{
    Cell[75212, 2980, 242, 8, 16, "Index",
      CellTags->"ChiSquarePValue"]},
  "Cholesky package"->{
    Cell[75457, 2990, 234, 8, 16, "Index",
      CellTags->"Cholesky package"]},
  "ChromaticNumber"->{
    Cell[75694, 3000, 242, 8, 16, "Index",
      CellTags->"ChromaticNumber"]},
  "ChromaticPolynomial"->{
    Cell[75939, 3010, 250, 8, 16, "Index",
      CellTags->"ChromaticPolynomial"]},
  "ChvatalGraph"->{
    Cell[76192, 3020, 236, 8, 16, "Index",
      CellTags->"ChvatalGraph"]},
  "Circle"->{
    Cell[76431, 3030, 249, 9, 16, "Index",
      CellTags->"Circle"],
    Cell[76683, 3041, 241, 9, 16, "IndexSubentry",
      CellTags->"Circle"],
    Cell[76927, 3052, 224, 8, 16, "Index",
      CellTags->"Circle"]},
  "CirculantGraph"->{
    Cell[77154, 3062, 381, 12, 16, "Index",
      CellTags->"CirculantGraph"]},
  "CircularEmbedding"->{
    Cell[77538, 3076, 246, 8, 16, "Index",
      CellTags->"CircularEmbedding"]},
  "CircumscribedRadius"->{
    Cell[77787, 3086, 357, 12, 16, "Index",
      CellTags->"CircumscribedRadius"]},
  "CityData"->{
    Cell[78147, 3100, 219, 8, 16, "Index",
      CellTags->"CityData"]},
  "CityData package"->{
    Cell[78369, 3110, 235, 8, 16, "Index",
      CellTags->"CityData package"]},
  "CityDistance"->{
    Cell[78607, 3120, 227, 8, 16, "Index",
      CellTags->"CityDistance"]},
  "CityDistanceMethod"->{
    Cell[78837, 3130, 239, 8, 16, "Index",
      CellTags->"CityDistanceMethod"]},
  "CityPosition"->{
    Cell[79079, 3140, 228, 8, 16, "Index",
      CellTags->"CityPosition"]},
  "ClassicalElectronRadius"->{
    Cell[79310, 3150, 267, 8, 16, "Index",
      CellTags->"ClassicalElectronRadius"]},
  "ClassList"->{
    Cell[79580, 3160, 246, 8, 16, "Index",
      CellTags->"ClassList"]},
  "ClassNumber"->{
    Cell[79829, 3170, 250, 8, 16, "Index",
      CellTags->"ClassNumber"]},
  "CliqueQ"->{
    Cell[80082, 3180, 226, 8, 16, "Index",
      CellTags->"CliqueQ"]},
  "Cluster"->{
    Cell[80311, 3190, 268, 10, 16, "Index",
      CellTags->"Cluster"]},
  "ClusterAnalysis"->{
    Cell[80582, 3202, 240, 8, 16, "Index",
      CellTags->"ClusterAnalysis"]},
  "ClusterFlatten"->{
    Cell[80825, 3212, 282, 10, 16, "Index",
      CellTags->"ClusterFlatten"]},
  "ClusterSplit"->{
    Cell[81110, 3224, 278, 10, 16, "Index",
      CellTags->"ClusterSplit"]},
  "Cliques"->{
    Cell[81391, 3236, 204, 7, 16, "Index",
      CellTags->"Cliques"]},
  "CMYColor"->{
    Cell[81598, 3245, 205, 8, 16, "Index",
      CellTags->"CMYColor"]},
  "CMYKColor"->{
    Cell[81806, 3255, 207, 8, 16, "Index",
      CellTags->"CMYKColor"]},
  "CoarserSetPartitionQ"->{
    Cell[82016, 3265, 252, 8, 16, "Index",
      CellTags->"CoarserSetPartitionQ"]},
  "Code"->{
    Cell[82271, 3275, 244, 9, 16, "Index",
      CellTags->"Code"]},
  "CodeToLabeledTree"->{
    Cell[82518, 3286, 246, 8, 16, "Index",
      CellTags->"CodeToLabeledTree"]},
  "CoefficientOfVariation"->{
    Cell[82767, 3296, 411, 12, 32, "Index",
      CellTags->"CoefficientOfVariation"]},
  "Coefficients"->{
    Cell[83181, 3310, 221, 7, 16, "Index",
      CellTags->"Coefficients"]},
  "Cofactor"->{
    Cell[83405, 3319, 228, 8, 16, "Index",
      CellTags->"Cofactor"]},
  "CollisionFrequency"->{
    Cell[83636, 3329, 259, 8, 16, "Index",
      CellTags->"CollisionFrequency"]},
  "Color"->{
    Cell[83898, 3339, 229, 9, 16, "Index",
      CellTags->"Color"],
    Cell[84130, 3350, 196, 7, 16, "IndexSubentry",
      CellTags->"Color"]},
  "color 3-Script command"->{
    Cell[84329, 3359, 251, 8, 16, "Index",
      CellTags->"color 3-Script command"]},
  "ColorCircle"->{
    Cell[84583, 3369, 217, 8, 16, "Index",
      CellTags->"ColorCircle"]},
  "ColorFunction"->{
    Cell[84803, 3379, 476, 16, 16, "Index",
      CellTags->"ColorFunction"]},
  "colormesh 3-Script command"->{
    Cell[85282, 3397, 259, 8, 16, "Index",
      CellTags->"colormesh 3-Script command"]},
  "Colors package"->{
    Cell[85544, 3407, 217, 8, 16, "Index",
      CellTags->"Colors package"]},
  "Column"->{
    Cell[85764, 3417, 225, 8, 16, "Index",
      CellTags->"Column"]},
  "ColumnDrop"->{
    Cell[85992, 3427, 233, 8, 16, "Index",
      CellTags->"ColumnDrop"]},
  "ColumnJoin"->{
    Cell[86228, 3437, 233, 8, 16, "Index",
      CellTags->"ColumnJoin"]},
  "ColumnTake"->{
    Cell[86464, 3447, 233, 8, 16, "Index",
      CellTags->"ColumnTake"]},
  "Combinations"->{
    Cell[86700, 3457, 230, 7, 16, "Index",
      CellTags->"Combinations"]},
  "CombinatorialFunctions package"->{
    Cell[86933, 3466, 289, 8, 16, "Index",
      CellTags->"CombinatorialFunctions package"]},
  "Combinatorica package"->{
    Cell[87225, 3476, 253, 8, 16, "Index",
      CellTags->"Combinatorica package"]},
  "Common Graphics package"->{
    Cell[87481, 3486, 241, 9, 16, "Index",
      CellTags->"Common Graphics package"]},
  "Common Statistics packages"->{
    Cell[87725, 3497, 251, 9, 16, "Index",
      CellTags->"Common Statistics packages"]},
  "Complete integrals"->{
    Cell[87979, 3508, 267, 9, 16, "Index",
      CellTags->"Complete integrals"]},
  "CompleteBinaryTree"->{
    Cell[88249, 3519, 248, 8, 16, "Index",
      CellTags->"CompleteBinaryTree"]},
  "CompleteGraph"->{
    Cell[88500, 3529, 379, 12, 16, "Index",
      CellTags->"CompleteGraph"]},
  "CompleteIntegral"->{
    Cell[88882, 3543, 239, 8, 16, "Index",
      CellTags->"CompleteIntegral"]},
  "CompleteKaryTree"->{
    Cell[89124, 3553, 244, 8, 16, "Index",
      CellTags->"CompleteKaryTree"]},
  "CompleteKPartiteGraph"->{
    Cell[89371, 3563, 254, 8, 16, "Index",
      CellTags->"CompleteKPartiteGraph"]},
  "CompleteQ"->{
    Cell[89628, 3573, 230, 8, 16, "Index",
      CellTags->"CompleteQ"]},
  "Complex multiplication"->{
    Cell[89861, 3583, 219, 7, 16, "Index",
      CellTags->"Complex multiplication"]},
  "Complex numbers"->{
    Cell[90083, 3592, 205, 7, 16, "Index",
      CellTags->"Complex numbers"],
    Cell[90291, 3601, 334, 11, 16, "IndexSubentry",
      CellTags->"Complex numbers"]},
  "ComplexExpand"->{
    Cell[90628, 3614, 209, 8, 16, "Index",
      CellTags->"ComplexExpand"]},
  "ComplexInequalityPlot"->{
    Cell[90840, 3624, 256, 8, 16, "Index",
      CellTags->"ComplexInequalityPlot"]},
  "ComplexMap package"->{
    Cell[91099, 3634, 233, 8, 16, "Index",
      CellTags->"ComplexMap package"]},
  "ComplexRootIntervals"->{
    Cell[91335, 3644, 241, 8, 16, "Index",
      CellTags->"ComplexRootIntervals"]},
  "CompositeBezier"->{
    Cell[91579, 3654, 353, 12, 16, "Index",
      CellTags->"CompositeBezier"]},
  "Compositions"->{
    Cell[91935, 3668, 214, 7, 16, "Index",
      CellTags->"Compositions"],
    Cell[92152, 3677, 377, 12, 16, "Index",
      CellTags->"Compositions"]},
  "Computational geometry"->{
    Cell[92532, 3691, 249, 7, 16, "Index",
      CellTags->"Computational geometry"]},
  "ComputationalGeometry package"->{
    Cell[92784, 3700, 285, 8, 16, "Index",
      CellTags->"ComputationalGeometry package"]},
  "Computer arithmetic"->{
    Cell[93072, 3710, 239, 7, 16, "Index",
      CellTags->"Computer arithmetic"]},
  "ComputerArithmetic package"->{
    Cell[93314, 3719, 411, 12, 32, "Index",
      CellTags->"ComputerArithmetic package"]},
  "ComputerNumber"->{
    Cell[93728, 3733, 251, 8, 16, "Index",
      CellTags->"ComputerNumber"]},
  "Condition number"->{
    Cell[93982, 3743, 285, 9, 16, "Index",
      CellTags->"Condition number"]},
  "Conductivity"->{
    Cell[94270, 3754, 279, 9, 16, "Index",
      CellTags->"Conductivity"]},
  "Cone"->{
    Cell[94552, 3765, 197, 8, 16, "Index",
      CellTags->"Cone"]},
  "Confidence interval"->{
    Cell[94752, 3775, 235, 7, 16, "Index",
      CellTags->"Confidence interval"]},
  "Confidence level"->{
    Cell[94990, 3784, 229, 7, 16, "Index",
      CellTags->"Confidence level"]},
  "ConfidenceIntervals package"->{
    Cell[95222, 3793, 273, 8, 16, "Index",
      CellTags->"ConfidenceIntervals package"]},
  "ConfidenceLevel"->{
    Cell[95498, 3803, 249, 8, 16, "Index",
      CellTags->"ConfidenceLevel"]},
  "Configuration"->{
    Cell[95750, 3813, 285, 9, 16, "Index",
      CellTags->"Configuration"]},
  "ConfocalEllipsoidal"->{
    Cell[96038, 3824, 243, 8, 16, "Index",
      CellTags->"ConfocalEllipsoidal"]},
  "ConfocalParaboloidal"->{
    Cell[96284, 3834, 245, 8, 16, "Index",
      CellTags->"ConfocalParaboloidal"]},
  "Congruences"->{
    Cell[96532, 3844, 288, 9, 16, "Index",
      CellTags->"Congruences"]},
  "Conical"->{
    Cell[96823, 3855, 219, 8, 16, "Index",
      CellTags->"Conical"]},
  "Conjugate"->{
    Cell[97045, 3865, 328, 12, 16, "Index",
      CellTags->"Conjugate"]},
  "ConnectedComponents"->{
    Cell[97376, 3879, 391, 12, 16, "Index",
      CellTags->"ConnectedComponents"]},
  "ConnectedQ"->{
    Cell[97770, 3893, 373, 12, 16, "Index",
      CellTags->"ConnectedQ"]},
  "Constants"->{
    Cell[98146, 3907, 227, 7, 16, "Index",
      CellTags->"Constants"]},
  "Constants of motion"->{
    Cell[98376, 3916, 223, 7, 16, "Index",
      CellTags->"Constants of motion"]},
  "ConstructTableau"->{
    Cell[98602, 3925, 244, 8, 16, "Index",
      CellTags->"ConstructTableau"]},
  "Context"->{
    Cell[98849, 3935, 178, 7, 16, "Index",
      CellTags->"Context"]},
  "Context search path"->{
    Cell[99030, 3944, 193, 7, 16, "Index",
      CellTags->"Context search path"]},
  "Contexts"->{
    Cell[99226, 3953, 185, 7, 16, "Index",
      CellTags->"Contexts"],
    Cell[99414, 3962, 182, 7, 16, "IndexSubentry",
      CellTags->"Contexts"]},
  "Continued fractions"->{
    Cell[99599, 3971, 237, 7, 16, "Index",
      CellTags->"Continued fractions"]},
  "ContinuedFractionForm"->{
    Cell[99839, 3980, 263, 8, 16, "Index",
      CellTags->"ContinuedFractionForm"]},
  "ContinuedFractions"->{
    Cell[100105, 3990, 257, 8, 16, "Index",
      CellTags->"ContinuedFractions"]},
  "ContinuedFractions package"->{
    Cell[100365, 4000, 273, 8, 16, "Index",
      CellTags->"ContinuedFractions package"]},
  "ContinuousDistributions package"->{
    Cell[100641, 4010, 739, 20, 48, "Index",
      CellTags->"ContinuousDistributions package"]},
  "ContourPlot3D"->{
    Cell[101383, 4032, 229, 8, 16, "Index",
      CellTags->"ContourPlot3D"]},
  "ContourPlot3D package"->{
    Cell[101615, 4042, 245, 8, 16, "Index",
      CellTags->"ContourPlot3D package"]},
  "Contours"->{
    Cell[101863, 4052, 351, 12, 16, "Index",
      CellTags->"Contours"]},
  "ContourStyle"->{
    Cell[102217, 4066, 359, 12, 16, "Index",
      CellTags->"ContourStyle"]},
  "Contract"->{
    Cell[102579, 4080, 369, 12, 16, "Index",
      CellTags->"Contract"]},
  "ContractInterval"->{
    Cell[102951, 4094, 233, 8, 16, "Index",
      CellTags->"ContractInterval"]},
  "Convergents"->{
    Cell[103187, 4104, 244, 8, 16, "Index",
      CellTags->"Convergents"]},
  "Conversion"->{
    Cell[103434, 4114, 276, 9, 16, "Index",
      CellTags->"Conversion"],
    Cell[103713, 4125, 3653, 113, 304, "IndexSubentry",
      CellTags->"Conversion"]},
  "Convert"->{
    Cell[107369, 4240, 211, 8, 16, "Index",
      CellTags->"Convert"]},
  "ConvertTemperature"->{
    Cell[107583, 4250, 233, 8, 16, "Index",
      CellTags->"ConvertTemperature"]},
  "ConvexHull"->{
    Cell[107819, 4260, 404, 12, 16, "Index",
      CellTags->"ConvexHull"]},
  "ConvexHullArea"->{
    Cell[108226, 4274, 262, 8, 16, "Index",
      CellTags->"ConvexHullArea"]},
  "ConvexHullMedian"->{
    Cell[108491, 4284, 266, 8, 16, "Index",
      CellTags->"ConvexHullMedian"]},
  "CookD"->{
    Cell[108760, 4294, 346, 12, 16, "Index",
      CellTags->"CookD"]},
  "Coordinate systems"->{
    Cell[109109, 4308, 222, 7, 16, "Index",
      CellTags->"Coordinate systems"],
    Cell[109334, 4317, 661, 19, 64, "IndexSubentry",
      CellTags->"Coordinate systems"]},
  "Coordinate transformations"->{
    Cell[109998, 4338, 257, 7, 16, "Index",
      CellTags->"Coordinate transformations"]},
  "CoordinateRanges"->{
    Cell[110258, 4347, 238, 8, 16, "Index",
      CellTags->"CoordinateRanges"]},
  "Coordinates"->{
    Cell[110499, 4357, 227, 8, 16, "Index",
      CellTags->"Coordinates"]},
  "CoordinatesFromCartesian"->{
    Cell[110729, 4367, 254, 8, 16, "Index",
      CellTags->"CoordinatesFromCartesian"]},
  "CoordinatesToCartesian"->{
    Cell[110986, 4377, 250, 8, 16, "Index",
      CellTags->"CoordinatesToCartesian"]},
  "CoordinateSystem"->{
    Cell[111239, 4387, 237, 8, 16, "Index",
      CellTags->"CoordinateSystem"]},
  "Coprime"->{
    Cell[111479, 4397, 199, 9, 16, "Index",
      CellTags->"Coprime"]},
  "Correlation"->{
    Cell[111681, 4408, 256, 8, 16, "Index",
      CellTags->"Correlation"]},
  "CorrelationDissimilarity"->{
    Cell[111940, 4418, 302, 10, 16, "Index",
      CellTags->"CorrelationDissimilarity"]},
  "CorrelationMatrix"->{
    Cell[112245, 4430, 853, 24, 64, "Index",
      CellTags->"CorrelationMatrix"]},
  "CosineAngleDissimilarity"->{
    Cell[113101, 4456, 302, 10, 16, "Index",
      CellTags->"CosineAngleDissimilarity"]},
  "CosmicBackgroundTemperature"->{
    Cell[113406, 4468, 275, 8, 16, "Index",
      CellTags->"CosmicBackgroundTemperature"]},
  "CostOfPath"->{
    Cell[113684, 4478, 232, 8, 16, "Index",
      CellTags->"CostOfPath"]},
  "CountRoots"->{
    Cell[113919, 4488, 221, 8, 16, "Index",
      CellTags->"CountRoots"]},
  "Covariance"->{
    Cell[114143, 4498, 254, 8, 16, "Index",
      CellTags->"Covariance"]},
  "CovarianceMatrix"->{
    Cell[114400, 4508, 851, 24, 64, "Index",
      CellTags->"CovarianceMatrix"]},
  "CovarianceMatrixDetRatio"->{
    Cell[115254, 4534, 384, 12, 16, "Index",
      CellTags->"CovarianceMatrixDetRatio"]},
  "CovarianceMatrixMLE"->{
    Cell[115641, 4548, 272, 8, 16, "Index",
      CellTags->"CovarianceMatrixMLE"]},
  "CovarianceMatrixOfSampleMean"->{
    Cell[115916, 4558, 290, 8, 16, "Index",
      CellTags->"CovarianceMatrixOfSampleMean"]},
  "CovarianceMLE"->{
    Cell[116209, 4568, 260, 8, 16, "Index",
      CellTags->"CovarianceMLE"]},
  "CoxeterGraph"->{
    Cell[116472, 4578, 236, 8, 16, "Index",
      CellTags->"CoxeterGraph"]},
  "Cross product"->{
    Cell[116711, 4588, 283, 9, 16, "Index",
      CellTags->"Cross product"]},
  "CrossProduct"->{
    Cell[116997, 4599, 230, 8, 16, "Index",
      CellTags->"CrossProduct"]},
  "Cube"->{
    Cell[117230, 4609, 327, 12, 16, "Index",
      CellTags->"Cube"]},
  "CubeConnectedCycle"->{
    Cell[117560, 4623, 248, 8, 16, "Index",
      CellTags->"CubeConnectedCycle"]},
  "Cubic"->{
    Cell[117811, 4633, 333, 12, 16, "Index",
      CellTags->"Cubic"]},
  "CubicalGraph"->{
    Cell[118147, 4647, 236, 8, 16, "Index",
      CellTags->"CubicalGraph"]},
  "Cuboid"->{
    Cell[118386, 4657, 201, 8, 16, "Index",
      CellTags->"Cuboid"]},
  "Cumulative distribution function"->{
    Cell[118590, 4667, 920, 25, 48, "Index",
      CellTags->"Cumulative distribution function"]},
  "CumulativeSums"->{
    Cell[119513, 4694, 241, 8, 16, "Index",
      CellTags->"CumulativeSums"]},
  "Curl"->{
    Cell[119757, 4704, 214, 8, 16, "Index",
      CellTags->"Curl"]},
  "Curve"->{
    Cell[119974, 4714, 221, 9, 16, "Index",
      CellTags->"Curve"],
    Cell[120198, 4725, 401, 15, 32, "IndexSubentry",
      CellTags->"Curve"]},
  "Curve fitting"->{
    Cell[120602, 4742, 623, 19, 32, "Index",
      CellTags->"Curve fitting"]},
  "CurveCountLimit"->{
    Cell[121228, 4763, 248, 8, 16, "Index",
      CellTags->"CurveCountLimit"]},
  "CurveNumber"->{
    Cell[121479, 4773, 240, 8, 16, "Index",
      CellTags->"CurveNumber"]},
  "Curves"->{
    Cell[121722, 4783, 246, 9, 16, "Index",
      CellTags->"Curves"],
    Cell[121971, 4794, 229, 7, 16, "IndexSubentry",
      CellTags->"Curves"],
    Cell[122203, 4803, 209, 8, 16, "Index",
      CellTags->"Curves"]},
  "Curvilinear coordinates"->{
    Cell[122415, 4813, 229, 7, 16, "Index",
      CellTags->"Curvilinear coordinates"]},
  "Cycle"->{
    Cell[122647, 4822, 363, 12, 16, "Index",
      CellTags->"Cycle"]},
  "CycleIndex"->{
    Cell[123013, 4836, 232, 8, 16, "Index",
      CellTags->"CycleIndex"]},
  "Cycles"->{
    Cell[123248, 4846, 224, 8, 16, "Index",
      CellTags->"Cycles"]},
  "CycleStructure"->{
    Cell[123475, 4856, 240, 8, 16, "Index",
      CellTags->"CycleStructure"]},
  "Cyclic"->{
    Cell[123718, 4866, 224, 8, 16, "Index",
      CellTags->"Cyclic"]},
  "CyclicGroup"->{
    Cell[123945, 4876, 234, 8, 16, "Index",
      CellTags->"CyclicGroup"]},
  "CyclicGroupIndex"->{
    Cell[124182, 4886, 244, 8, 16, "Index",
      CellTags->"CyclicGroupIndex"]},
  "Cylinder"->{
    Cell[124429, 4896, 205, 8, 16, "Index",
      CellTags->"Cylinder"]},
  "Cylindrical"->{
    Cell[124637, 4906, 227, 8, 16, "Index",
      CellTags->"Cylindrical"]},
  "D"->{
    Cell[125080, 4925, 202, 8, 16, "Index",
      CellTags->"D"]},
  "DampingConstant"->{
    Cell[125285, 4935, 265, 8, 16, "Index",
      CellTags->"DampingConstant"]},
  "Dash"->{
    Cell[125553, 4945, 218, 8, 16, "Index",
      CellTags->"Dash"]},
  "Data"->{
    Cell[125774, 4955, 223, 7, 16, "Index",
      CellTags->"Data"],
    Cell[126000, 4964, 1514, 39, 128, "IndexSubentry",
      CellTags->"Data"]},
  "Databases"->{
    Cell[127517, 5005, 213, 7, 16, "Index",
      CellTags->"Databases"]},
  "DataManipulation package"->{
    Cell[127733, 5014, 261, 8, 16, "Index",
      CellTags->"DataManipulation package"]},
  "DataSmoothing package"->{
    Cell[127997, 5024, 249, 8, 16, "Index",
      CellTags->"DataSmoothing package"]},
  "Dates"->{
    Cell[128249, 5034, 207, 7, 16, "Index",
      CellTags->"Dates"]},
  "DayOfWeek"->{
    Cell[128459, 5043, 353, 12, 16, "Index",
      CellTags->"DayOfWeek"]},
  "DaysBetween"->{
    Cell[128815, 5057, 357, 12, 16, "Index",
      CellTags->"DaysBetween"]},
  "DaysPlus"->{
    Cell[129175, 5071, 351, 12, 16, "Index",
      CellTags->"DaysPlus"]},
  "de Moivre number"->{
    Cell[129529, 5085, 238, 7, 16, "Index",
      CellTags->"de Moivre number"]},
  "DeBruijnGraph"->{
    Cell[129770, 5094, 379, 12, 16, "Index",
      CellTags->"DeBruijnGraph"]},
  "DeBruijnSequence"->{
    Cell[130152, 5108, 244, 8, 16, "Index",
      CellTags->"DeBruijnSequence"]},
  "Decagon"->{
    Cell[130399, 5118, 209, 8, 16, "Index",
      CellTags->"Decagon"]},
  "Decimal expansions"->{
    Cell[130611, 5128, 236, 7, 16, "Index",
      CellTags->"Decimal expansions"]},
  "DeclarePackage"->{
    Cell[130850, 5137, 311, 12, 16, "Index",
      CellTags->"DeclarePackage"]},
  "Declaring types of numbers"->{
    Cell[131164, 5151, 253, 9, 16, "Index",
      CellTags->"Declaring types of numbers"]},
  "Decorrelate"->{
    Cell[131420, 5162, 256, 8, 16, "Index",
      CellTags->"Decorrelate"]},
  "Degrees"->{
    Cell[131679, 5172, 226, 8, 16, "Index",
      CellTags->"Degrees"]},
  "DegreeSequence"->{
    Cell[131908, 5182, 240, 8, 16, "Index",
      CellTags->"DegreeSequence"]},
  "DegreesOf2Neighborhood"->{
    Cell[132151, 5192, 256, 8, 16, "Index",
      CellTags->"DegreesOf2Neighborhood"]},
  "DelaunayTriangulation"->{
    Cell[132410, 5202, 426, 12, 32, "Index",
      CellTags->"DelaunayTriangulation"]},
  "DelaunayTriangulationQ"->{
    Cell[132839, 5216, 272, 8, 16, "Index",
      CellTags->"DelaunayTriangulationQ"]},
  "DeleteCycle"->{
    Cell[133114, 5226, 234, 8, 16, "Index",
      CellTags->"DeleteCycle"]},
  "DeleteEdge"->{
    Cell[133351, 5236, 373, 12, 16, "Index",
      CellTags->"DeleteEdge"]},
  "DeleteEdges"->{
    Cell[133727, 5250, 234, 8, 16, "Index",
      CellTags->"DeleteEdges"]},
  "DeleteFromTableau"->{
    Cell[133964, 5260, 246, 8, 16, "Index",
      CellTags->"DeleteFromTableau"]},
  "DeleteVertex"->{
    Cell[134213, 5270, 236, 8, 16, "Index",
      CellTags->"DeleteVertex"]},
  "DeleteVertices"->{
    Cell[134452, 5280, 240, 8, 16, "Index",
      CellTags->"DeleteVertices"]},
  "DendrogramPlot"->{
    Cell[134695, 5290, 282, 10, 16, "Index",
      CellTags->"DendrogramPlot"]},
  "Density"->{
    Cell[134980, 5302, 253, 9, 16, "Index",
      CellTags->"Density"],
    Cell[135236, 5313, 233, 8, 16, "Index",
      CellTags->"Density"]},
  "Density function"->{
    Cell[135472, 5323, 888, 25, 48, "Index",
      CellTags->"Density function"]},
  "Depth-first search"->{
    Cell[136363, 5350, 234, 7, 16, "Index",
      CellTags->"Depth-first search"]},
  "DepthFirstTraversal"->{
    Cell[136600, 5359, 391, 12, 16, "Index",
      CellTags->"DepthFirstTraversal"]},
  "DerangementQ"->{
    Cell[136994, 5373, 236, 8, 16, "Index",
      CellTags->"DerangementQ"]},
  "Derangements"->{
    Cell[137233, 5383, 236, 8, 16, "Index",
      CellTags->"Derangements"]},
  "Derivatives"->{
    Cell[137472, 5393, 243, 9, 16, "Index",
      CellTags->"Derivatives"],
    Cell[137718, 5404, 263, 9, 16, "IndexSubentry",
      CellTags->"Derivatives"],
    Cell[137984, 5415, 238, 8, 16, "Index",
      CellTags->"Derivatives"]},
  "DescriptiveStatistics package"->{
    Cell[138225, 5425, 561, 16, 32, "Index",
      CellTags->"DescriptiveStatistics package"]},
  "DesignedRegress"->{
    Cell[138789, 5443, 244, 8, 16, "Index",
      CellTags->"DesignedRegress"]},
  "DesignMatrix"->{
    Cell[139036, 5453, 238, 8, 16, "Index",
      CellTags->"DesignMatrix"]},
  "DeuteronMagneticMoment"->{
    Cell[139277, 5463, 265, 8, 16, "Index",
      CellTags->"DeuteronMagneticMoment"]},
  "DeuteronMass"->{
    Cell[139545, 5473, 245, 8, 16, "Index",
      CellTags->"DeuteronMass"]},
  "DiagonallyImplicit"->{
    Cell[139793, 5483, 238, 8, 16, "Index",
      CellTags->"DiagonallyImplicit"]},
  "DiagramPlot"->{
    Cell[140034, 5493, 407, 12, 32, "Index",
      CellTags->"DiagramPlot"]},
  "Diagrams"->{
    Cell[140444, 5507, 291, 9, 16, "Index",
      CellTags->"Diagrams"],
    Cell[140738, 5518, 263, 9, 16, "IndexSubentry",
      CellTags->"Diagrams"]},
  "Diameter"->{
    Cell[141004, 5529, 228, 8, 16, "Index",
      CellTags->"Diameter"]},
  "DiceDissimilarity"->{
    Cell[141235, 5539, 288, 10, 16, "Index",
      CellTags->"DiceDissimilarity"]},
  "Dictionary"->{
    Cell[141526, 5551, 226, 8, 16, "Index",
      CellTags->"Dictionary"]},
  "DictionaryWordQ"->{
    Cell[141755, 5561, 236, 8, 16, "Index",
      CellTags->"DictionaryWordQ"]},
  "Differential"->{
    Cell[141994, 5571, 265, 9, 16, "Index",
      CellTags->"Differential"],
    Cell[142262, 5582, 259, 9, 16, "IndexSubentry",
      CellTags->"Differential"]},
  "Differential equations"->{
    Cell[142524, 5593, 240, 7, 16, "Index",
      CellTags->"Differential equations"],
    Cell[142767, 5602, 395, 11, 32, "IndexSubentry",
      CellTags->"Differential equations"]},
  "Differentiation"->{
    Cell[143165, 5615, 251, 9, 16, "Index",
      CellTags->"Differentiation"]},
  "Digon"->{
    Cell[143419, 5626, 205, 8, 16, "Index",
      CellTags->"Digon"]},
  "Dihedral"->{
    Cell[143627, 5636, 228, 8, 16, "Index",
      CellTags->"Dihedral"]},
  "DihedralGroup"->{
    Cell[143858, 5646, 238, 8, 16, "Index",
      CellTags->"DihedralGroup"]},
  "DihedralGroupIndex"->{
    Cell[144099, 5656, 248, 8, 16, "Index",
      CellTags->"DihedralGroupIndex"]},
  "Dijkstra"->{
    Cell[144350, 5666, 228, 8, 16, "Index",
      CellTags->"Dijkstra"]},
  "DilateVertices"->{
    Cell[144581, 5676, 240, 8, 16, "Index",
      CellTags->"DilateVertices"]},
  "DirectAgglomerate"->{
    Cell[144824, 5686, 288, 10, 16, "Index",
      CellTags->"DirectAgglomerate"]},
  "Directed"->{
    Cell[145115, 5698, 228, 8, 16, "Index",
      CellTags->"Directed"]},
  "Dirichlet cells"->{
    Cell[145346, 5708, 235, 7, 16, "Index",
      CellTags->"Dirichlet cells"]},
  "DiscreteDistributions package"->{
    Cell[145584, 5717, 589, 16, 32, "Index",
      CellTags->"DiscreteDistributions package"]},
  "DiscreteUniformDistribution"->{
    Cell[146176, 5735, 277, 8, 16, "Index",
      CellTags->"DiscreteUniformDistribution"]},
  "Discriminant analysis"->{
    Cell[146456, 5745, 247, 7, 16, "Index",
      CellTags->"Discriminant analysis"]},
  "Disk"->{
    Cell[146706, 5754, 220, 8, 16, "Index",
      CellTags->"Disk"]},
  "DispersionMatrix"->{
    Cell[146929, 5764, 266, 8, 16, "Index",
      CellTags->"DispersionMatrix"]},
  "DispersionReport"->{
    Cell[147198, 5774, 256, 8, 16, "Index",
      CellTags->"DispersionReport"]},
  "Display"->{
    Cell[147457, 5784, 254, 9, 16, "Index",
      CellTags->"Display"],
    Cell[147714, 5795, 413, 15, 32, "IndexSubentry",
      CellTags->"Display"]},
  "DisplayFunction"->{
    Cell[148130, 5812, 228, 8, 16, "Index",
      CellTags->"DisplayFunction"]},
  "DisplayTogether"->{
    Cell[148361, 5822, 224, 8, 16, "Index",
      CellTags->"DisplayTogether"]},
  "DisplayTogetherArray"->{
    Cell[148588, 5832, 234, 8, 16, "Index",
      CellTags->"DisplayTogetherArray"]},
  "Distance"->{
    Cell[148825, 5842, 255, 9, 16, "Index",
      CellTags->"Distance"],
    Cell[149083, 5853, 441, 15, 32, "IndexSubentry",
      CellTags->"Distance"]},
  "DistanceFunction"->{
    Cell[149527, 5870, 286, 10, 16, "Index",
      CellTags->"DistanceFunction"]},
  "DistanceMatrix"->{
    Cell[149816, 5882, 282, 10, 16, "Index",
      CellTags->"DistanceMatrix"]},
  "Distances"->{
    Cell[150101, 5894, 230, 8, 16, "Index",
      CellTags->"Distances"]},
  "DistinctPermutations"->{
    Cell[150334, 5904, 252, 8, 16, "Index",
      CellTags->"DistinctPermutations"]},
  "Distribution"->{
    Cell[150589, 5914, 236, 8, 16, "Index",
      CellTags->"Distribution"]},
  "Distribution function"->{
    Cell[150828, 5924, 898, 25, 48, "Index",
      CellTags->"Distribution function"]},
  "Distributions"->{
    Cell[151729, 5951, 557, 15, 32, "Index",
      CellTags->"Distributions"],
    Cell[152289, 5968, 733, 19, 64, "IndexSubentry",
      CellTags->"Distributions"]},
  "Div"->{
    Cell[153025, 5989, 212, 8, 16, "Index",
      CellTags->"Div"]},
  "Divergence of vector field"->{
    Cell[153240, 5999, 269, 9, 16, "Index",
      CellTags->"Divergence of vector field"]},
  "Dodecagon"->{
    Cell[153512, 6010, 213, 8, 16, "Index",
      CellTags->"Dodecagon"]},
  "DodecahedralGraph"->{
    Cell[153728, 6020, 246, 8, 16, "Index",
      CellTags->"DodecahedralGraph"]},
  "Dodecahedron"->{
    Cell[153977, 6030, 343, 12, 16, "Index",
      CellTags->"Dodecahedron"]},
  "Domain"->{
    Cell[154323, 6044, 979, 28, 48, "Index",
      CellTags->"Domain"]},
  "DomainQ"->{
    Cell[155305, 6074, 207, 8, 16, "Index",
      CellTags->"DomainQ"]},
  "DominatingIntegerPartitionQ"->{
    Cell[155515, 6084, 266, 8, 16, "Index",
      CellTags->"DominatingIntegerPartitionQ"]},
  "DominationLattice"->{
    Cell[155784, 6094, 246, 8, 16, "Index",
      CellTags->"DominationLattice"]},
  "Dot product"->{
    Cell[156033, 6104, 277, 9, 16, "Index",
      CellTags->"Dot product"]},
  "DotProduct"->{
    Cell[156313, 6115, 226, 8, 16, "Index",
      CellTags->"DotProduct"]},
  "DoubleHelix"->{
    Cell[156542, 6125, 211, 8, 16, "Index",
      CellTags->"DoubleHelix"]},
  "DropNonNumeric"->{
    Cell[156756, 6135, 241, 8, 16, "Index",
      CellTags->"DropNonNumeric"]},
  "DropNonNumericColumn"->{
    Cell[157000, 6145, 253, 8, 16, "Index",
      CellTags->"DropNonNumericColumn"]},
  "DSolveIntegrals package"->{
    Cell[157256, 6155, 253, 8, 16, "Index",
      CellTags->"DSolveIntegrals package"]},
  "DTFourierTransform"->{
    Cell[157512, 6165, 246, 8, 16, "Index",
      CellTags->"DTFourierTransform"]},
  "Dual"->{
    Cell[157761, 6175, 203, 8, 16, "Index",
      CellTags->"Dual"]},
  "Duncan"->{
    Cell[157967, 6185, 204, 8, 16, "Index",
      CellTags->"Duncan"]},
  "Dunnett"->{
    Cell[158174, 6195, 206, 8, 16, "Index",
      CellTags->"Dunnett"]},
  "DurbinWatsonD"->{
    Cell[158383, 6205, 362, 12, 16, "Index",
      CellTags->"DurbinWatsonD"]},
  "DurfeeSquare"->{
    Cell[158748, 6219, 236, 8, 16, "Index",
      CellTags->"DurfeeSquare"]},
  "Earth"->{
    Cell[159213, 6238, 198, 7, 16, "Index",
      CellTags->"Earth"]},
  "EarthCrustAbundance"->{
    Cell[159414, 6247, 258, 8, 16, "Index",
      CellTags->"EarthCrustAbundance"]},
  "EarthMass"->{
    Cell[159675, 6257, 239, 8, 16, "Index",
      CellTags->"EarthMass"]},
  "EarthOceanAbundance"->{
    Cell[159917, 6267, 258, 8, 16, "Index",
      CellTags->"EarthOceanAbundance"]},
  "EarthRadius"->{
    Cell[160178, 6277, 243, 8, 16, "Index",
      CellTags->"EarthRadius"]},
  "EasterSunday"->{
    Cell[160424, 6287, 228, 8, 16, "Index",
      CellTags->"EasterSunday"]},
  "EasterSundayGreekOrthodox"->{
    Cell[160655, 6297, 254, 8, 16, "Index",
      CellTags->"EasterSundayGreekOrthodox"]},
  "Eccentricity"->{
    Cell[160912, 6307, 366, 12, 16, "Index",
      CellTags->"Eccentricity"]},
  "EconomizedRationalApproximation"->{
    Cell[161281, 6321, 248, 8, 16, "Index",
      CellTags->"EconomizedRationalApproximation"]},
  "EdgeChromaticNumber"->{
    Cell[161532, 6331, 250, 8, 16, "Index",
      CellTags->"EdgeChromaticNumber"]},
  "EdgeColor"->{
    Cell[161785, 6341, 230, 8, 16, "Index",
      CellTags->"EdgeColor"]},
  "EdgeColoring"->{
    Cell[162018, 6351, 236, 8, 16, "Index",
      CellTags->"EdgeColoring"]},
  "EdgeConnectivity"->{
    Cell[162257, 6361, 385, 12, 16, "Index",
      CellTags->"EdgeConnectivity"]},
  "EdgeDirection"->{
    Cell[162645, 6375, 238, 8, 16, "Index",
      CellTags->"EdgeDirection"]},
  "EdgeLabel"->{
    Cell[162886, 6385, 230, 8, 16, "Index",
      CellTags->"EdgeLabel"]},
  "EdgeLabelColor"->{
    Cell[163119, 6395, 240, 8, 16, "Index",
      CellTags->"EdgeLabelColor"]},
  "EdgeLabelPosition"->{
    Cell[163362, 6405, 246, 8, 16, "Index",
      CellTags->"EdgeLabelPosition"]},
  "Edges"->{
    Cell[163611, 6415, 363, 12, 16, "Index",
      CellTags->"Edges"]},
  "Edges of plot"->{
    Cell[163977, 6429, 203, 7, 16, "Index",
      CellTags->"Edges of plot"]},
  "EdgeStyle"->{
    Cell[164183, 6438, 230, 8, 16, "Index",
      CellTags->"EdgeStyle"]},
  "EdgeWeight"->{
    Cell[164416, 6448, 232, 8, 16, "Index",
      CellTags->"EdgeWeight"]},
  "EditDistance"->{
    Cell[164651, 6458, 278, 10, 16, "Index",
      CellTags->"EditDistance"]},
  "EigenstructureTable"->{
    Cell[164932, 6470, 374, 12, 16, "Index",
      CellTags->"EigenstructureTable"]},
  "ElectronCharge"->{
    Cell[165309, 6484, 249, 8, 16, "Index",
      CellTags->"ElectronCharge"]},
  "ElectronComptonWavelength"->{
    Cell[165561, 6494, 271, 8, 16, "Index",
      CellTags->"ElectronComptonWavelength"]},
  "ElectronConfiguration"->{
    Cell[165835, 6504, 262, 8, 16, "Index",
      CellTags->"ElectronConfiguration"]},
  "ElectronConfigurationFormat"->{
    Cell[166100, 6514, 274, 8, 16, "Index",
      CellTags->"ElectronConfigurationFormat"]},
  "ElectronGFactor"->{
    Cell[166377, 6524, 251, 8, 16, "Index",
      CellTags->"ElectronGFactor"]},
  "ElectronMagneticMoment"->{
    Cell[166631, 6534, 265, 8, 16, "Index",
      CellTags->"ElectronMagneticMoment"]},
  "ElectronMass"->{
    Cell[166899, 6544, 245, 8, 16, "Index",
      CellTags->"ElectronMass"]},
  "Element"->{
    Cell[167147, 6554, 226, 8, 16, "Index",
      CellTags->"Element"]},
  "ElementAbsorptionMap"->{
    Cell[167376, 6564, 275, 8, 16, "Index",
      CellTags->"ElementAbsorptionMap"]},
  "Elements"->{
    Cell[167654, 6574, 235, 8, 16, "Index",
      CellTags->"Elements"]},
  "ElementToPolynomial"->{
    Cell[167892, 6584, 238, 8, 16, "Index",
      CellTags->"ElementToPolynomial"]},
  "Elimination"->{
    Cell[168133, 6594, 219, 7, 16, "Index",
      CellTags->"Elimination"]},
  "Ellipsoid"->{
    Cell[168355, 6603, 374, 12, 16, "Index",
      CellTags->"Ellipsoid"]},
  "EllipsoidQuantile"->{
    Cell[168732, 6617, 268, 8, 16, "Index",
      CellTags->"EllipsoidQuantile"]},
  "EllipsoidQuartiles"->{
    Cell[169003, 6627, 270, 8, 16, "Index",
      CellTags->"EllipsoidQuartiles"]},
  "Elliptic curves"->{
    Cell[169276, 6637, 351, 11, 16, "Index",
      CellTags->"Elliptic curves"]},
  "EllipticCylindrical"->{
    Cell[169630, 6650, 243, 8, 16, "Index",
      CellTags->"EllipticCylindrical"]},
  "EmptyGraph"->{
    Cell[169876, 6660, 373, 12, 16, "Index",
      CellTags->"EmptyGraph"]},
  "EmptyQ"->{
    Cell[170252, 6674, 224, 8, 16, "Index",
      CellTags->"EmptyQ"]},
  "EncroachingListSet"->{
    Cell[170479, 6684, 248, 8, 16, "Index",
      CellTags->"EncroachingListSet"]},
  "End"->{
    Cell[170730, 6694, 183, 8, 16, "Index",
      CellTags->"End"]},
  "EndPackage"->{
    Cell[170916, 6704, 197, 8, 16, "Index",
      CellTags->"EndPackage"]},
  "EqualVariances"->{
    Cell[171116, 6714, 510, 16, 32, "Index",
      CellTags->"EqualVariances"]},
  "Equations"->{
    Cell[171629, 6732, 205, 7, 16, "Index",
      CellTags->"Equations"],
    Cell[171837, 6741, 699, 21, 64, "IndexSubentry",
      CellTags->"Equations"]},
  "EquivalenceClasses"->{
    Cell[172539, 6764, 248, 8, 16, "Index",
      CellTags->"EquivalenceClasses"]},
  "EquivalenceRelationQ"->{
    Cell[172790, 6774, 252, 8, 16, "Index",
      CellTags->"EquivalenceRelationQ"]},
  "Equivalences"->{
    Cell[173045, 6784, 236, 8, 16, "Index",
      CellTags->"Equivalences"]},
  "EuclideanDistance"->{
    Cell[173284, 6794, 288, 10, 16, "Index",
      CellTags->"EuclideanDistance"]},
  "Error-correcting codes"->{
    Cell[173575, 6806, 205, 7, 16, "Index",
      CellTags->"Error-correcting codes"]},
  "ErrorBar"->{
    Cell[173783, 6815, 225, 8, 16, "Index",
      CellTags->"ErrorBar"]},
  "ErrorBarFunction"->{
    Cell[174011, 6825, 241, 8, 16, "Index",
      CellTags->"ErrorBarFunction"]},
  "ErrorListPlot"->{
    Cell[174255, 6835, 220, 8, 16, "Index",
      CellTags->"ErrorListPlot"]},
  "Errors"->{
    Cell[174478, 6845, 290, 9, 16, "Index",
      CellTags->"Errors"],
    Cell[174771, 6856, 1038, 31, 80, "IndexSubentry",
      CellTags->"Errors"]},
  "EstimatedVariance"->{
    Cell[175812, 6889, 505, 16, 32, "Index",
      CellTags->"EstimatedVariance"]},
  "Estimates"->{
    Cell[176320, 6907, 728, 19, 64, "Index",
      CellTags->"Estimates"],
    Cell[177051, 6928, 715, 19, 48, "IndexSubentry",
      CellTags->"Estimates"]},
  "Estimation accuracy"->{
    Cell[177769, 6949, 262, 7, 16, "Index",
      CellTags->"Estimation accuracy"]},
  "Euclidean"->{
    Cell[178034, 6958, 230, 8, 16, "Index",
      CellTags->"Euclidean"]},
  "Euler angles"->{
    Cell[178267, 6968, 321, 11, 16, "Index",
      CellTags->"Euler angles"]},
  "Euler-Lagrange equations"->{
    Cell[178591, 6981, 247, 7, 16, "Index",
      CellTags->"Euler-Lagrange equations"]},
  "EulerEquations"->{
    Cell[178841, 6990, 241, 8, 16, "Index",
      CellTags->"EulerEquations"]},
  "Eulerian"->{
    Cell[179085, 7000, 228, 8, 16, "Index",
      CellTags->"Eulerian"]},
  "EulerianCycle"->{
    Cell[179316, 7010, 379, 12, 16, "Index",
      CellTags->"EulerianCycle"]},
  "EulerianQ"->{
    Cell[179698, 7024, 230, 8, 16, "Index",
      CellTags->"EulerianQ"]},
  "EulerRatio"->{
    Cell[179931, 7034, 219, 8, 16, "Index",
      CellTags->"EulerRatio"]},
  "EulerSum"->{
    Cell[180153, 7044, 215, 8, 16, "Index",
      CellTags->"EulerSum"]},
  "EvenQ"->{
    Cell[180371, 7054, 208, 8, 16, "Index",
      CellTags->"EvenQ"]},
  "ExactRandomGraph"->{
    Cell[180582, 7064, 244, 8, 16, "Index",
      CellTags->"ExactRandomGraph"]},
  "ExpandGraph"->{
    Cell[180829, 7074, 234, 8, 16, "Index",
      CellTags->"ExpandGraph"]},
  "ExpectedValue"->{
    Cell[181066, 7084, 869, 24, 48, "Index",
      CellTags->"ExpectedValue"]},
  "Experimental data"->{
    Cell[181938, 7110, 259, 9, 16, "Index",
      CellTags->"Experimental data"]},
  "Explicit"->{
    Cell[182200, 7121, 218, 8, 16, "Index",
      CellTags->"Explicit"]},
  "ExponentialDistribution"->{
    Cell[182421, 7131, 273, 8, 16, "Index",
      CellTags->"ExponentialDistribution"]},
  "ExponentialGeneratingFunction"->{
    Cell[182697, 7141, 256, 8, 16, "Index",
      CellTags->"ExponentialGeneratingFunction"]},
  "ExponentialGeneratingFunctionConstants"->{
    Cell[182956, 7151, 274, 8, 16, "Index",
      CellTags->"ExponentialGeneratingFunctionConstants"]},
  "ExponentialPowerSum"->{
    Cell[183233, 7161, 235, 8, 16, "Index",
      CellTags->"ExponentialPowerSum"]},
  "ExponentialSmoothing"->{
    Cell[183471, 7171, 247, 8, 16, "Index",
      CellTags->"ExponentialSmoothing"]},
  "ExponentRange"->{
    Cell[183721, 7181, 250, 8, 16, "Index",
      CellTags->"ExponentRange"]},
  "Expressions"->{
    Cell[183974, 7191, 241, 9, 16, "Index",
      CellTags->"Expressions"]},
  "ExprPlot"->{
    Cell[184218, 7202, 209, 8, 16, "Index",
      CellTags->"ExprPlot"]},
  "ExtendedGCD"->{
    Cell[184430, 7212, 307, 10, 16, "Index",
      CellTags->"ExtendedGCD"]},
  "ExtensionDegree"->{
    Cell[184740, 7224, 230, 8, 16, "Index",
      CellTags->"ExtensionDegree"]},
  "ExtractCycles"->{
    Cell[184973, 7234, 238, 8, 16, "Index",
      CellTags->"ExtractCycles"]},
  "ExtraTerms"->{
    Cell[185214, 7244, 219, 8, 16, "Index",
      CellTags->"ExtraTerms"]},
  "F distribution"->{
    Cell[185674, 7263, 271, 9, 16, "Index",
      CellTags->"F distribution"],
    Cell[185948, 7274, 496, 15, 32, "IndexSubentry",
      CellTags->"F distribution"]},
  "F-ratio distribution"->{
    Cell[186447, 7291, 291, 9, 16, "Index",
      CellTags->"F-ratio distribution"],
    Cell[186741, 7302, 502, 15, 32, "IndexSubentry",
      CellTags->"F-ratio distribution"]},
  "Faces"->{
    Cell[187246, 7319, 330, 12, 16, "Index",
      CellTags->"Faces"]},
  "Factor"->{
    Cell[187579, 7333, 223, 8, 16, "Index",
      CellTags->"Factor"]},
  "Factorial"->{
    Cell[187805, 7343, 247, 8, 16, "Index",
      CellTags->"Factorial"]},
  "Factorial2"->{
    Cell[188055, 7353, 249, 8, 16, "Index",
      CellTags->"Factorial2"]},
  "Factoring"->{
    Cell[188307, 7363, 235, 7, 16, "Index",
      CellTags->"Factoring"],
    Cell[188545, 7372, 444, 13, 32, "IndexSubentry",
      CellTags->"Factoring"]},
  "FactorInteger"->{
    Cell[188992, 7387, 243, 8, 16, "Index",
      CellTags->"FactorInteger"]},
  "FactorIntegerECM"->{
    Cell[189238, 7397, 688, 20, 32, "Index",
      CellTags->"FactorIntegerECM"]},
  "FactorIntegerECM package"->{
    Cell[189929, 7419, 265, 8, 16, "Index",
      CellTags->"FactorIntegerECM package"]},
  "FactorList"->{
    Cell[190197, 7429, 231, 8, 16, "Index",
      CellTags->"FactorList"]},
  "FactorSize"->{
    Cell[190431, 7439, 238, 8, 16, "Index",
      CellTags->"FactorSize"]},
  "FaradayConstant"->{
    Cell[190672, 7449, 251, 8, 16, "Index",
      CellTags->"FaradayConstant"]},
  "FerrersDiagram"->{
    Cell[190926, 7459, 381, 12, 16, "Index",
      CellTags->"FerrersDiagram"]},
  "Fibonacci"->{
    Cell[191310, 7473, 247, 8, 16, "Index",
      CellTags->"Fibonacci"]},
  "FieldExp"->{
    Cell[191560, 7483, 216, 8, 16, "Index",
      CellTags->"FieldExp"]},
  "FieldInd"->{
    Cell[191779, 7493, 216, 8, 16, "Index",
      CellTags->"FieldInd"]},
  "FieldIrreducible"->{
    Cell[191998, 7503, 232, 8, 16, "Index",
      CellTags->"FieldIrreducible"]},
  "FieldSize"->{
    Cell[192233, 7513, 218, 8, 16, "Index",
      CellTags->"FieldSize"]},
  "File format"->{
    Cell[192454, 7523, 199, 7, 16, "Index",
      CellTags->"File format"]},
  "Files"->{
    Cell[192656, 7532, 294, 11, 16, "Index",
      CellTags->"Files"]},
  "Filled region"->{
    Cell[192953, 7545, 241, 9, 16, "Index",
      CellTags->"Filled region"]},
  "FilledListPlot"->{
    Cell[193197, 7556, 225, 8, 16, "Index",
      CellTags->"FilledListPlot"]},
  "FilledPlot"->{
    Cell[193425, 7566, 217, 8, 16, "Index",
      CellTags->"FilledPlot"]},
  "FilledPlot package"->{
    Cell[193645, 7576, 233, 8, 16, "Index",
      CellTags->"FilledPlot package"]},
  "FilledPlots"->{
    Cell[193881, 7586, 219, 8, 16, "Index",
      CellTags->"FilledPlots"]},
  "Fills"->{
    Cell[194103, 7596, 207, 8, 16, "Index",
      CellTags->"Fills"]},
  "FilterOptions"->{
    Cell[194313, 7606, 231, 8, 16, "Index",
      CellTags->"FilterOptions"]},
  "FilterOptions package"->{
    Cell[194547, 7616, 247, 8, 16, "Index",
      CellTags->"FilterOptions package"]},
  "FindClusters"->{
    Cell[194797, 7626, 278, 10, 16, "Index",
      CellTags->"FindClusters"]},
  "FindCycle"->{
    Cell[195078, 7638, 230, 8, 16, "Index",
      CellTags->"FindCycle"]},
  "FindIons"->{
    Cell[195311, 7648, 251, 8, 16, "Index",
      CellTags->"FindIons"]},
  "FindMinimum"->{
    Cell[195565, 7658, 236, 8, 16, "Index",
      CellTags->"FindMinimum"]},
  "FindPackages"->{
    Cell[195804, 7668, 217, 8, 16, "Index",
      CellTags->"FindPackages"]},
  "FindRoot"->{
    Cell[196024, 7678, 516, 16, 32, "Index",
      CellTags->"FindRoot"]},
  "FindSet"->{
    Cell[196543, 7696, 226, 8, 16, "Index",
      CellTags->"FindSet"]},
  "FindWords"->{
    Cell[196772, 7706, 224, 8, 16, "Index",
      CellTags->"FindWords"]},
  "FineStructureConstant"->{
    Cell[196999, 7716, 263, 8, 16, "Index",
      CellTags->"FineStructureConstant"]},
  "Finite fields"->{
    Cell[197265, 7726, 233, 7, 16, "Index",
      CellTags->"Finite fields"]},
  "FiniteFields package"->{
    Cell[197501, 7735, 239, 8, 16, "Index",
      CellTags->"FiniteFields package"]},
  "FiniteGraphs"->{
    Cell[197743, 7745, 236, 8, 16, "Index",
      CellTags->"FiniteGraphs"]},
  "First integrals"->{
    Cell[197982, 7755, 215, 7, 16, "Index",
      CellTags->"First integrals"]},
  "FirstIntegral"->{
    Cell[198200, 7764, 240, 8, 16, "Index",
      CellTags->"FirstIntegral"]},
  "FirstIntegrals"->{
    Cell[198443, 7774, 242, 8, 16, "Index",
      CellTags->"FirstIntegrals"]},
  "FirstLexicographicTableau"->{
    Cell[198688, 7784, 262, 8, 16, "Index",
      CellTags->"FirstLexicographicTableau"]},
  "Fit"->{
    Cell[198953, 7794, 1026, 32, 48, "Index",
      CellTags->"Fit"]},
  "FitCurvatureTable"->{
    Cell[199982, 7828, 240, 8, 16, "Index",
      CellTags->"FitCurvatureTable"]},
  "FitResiduals"->{
    Cell[200225, 7838, 495, 16, 32, "Index",
      CellTags->"FitResiduals"]},
  "Fits"->{
    Cell[200723, 7856, 244, 9, 16, "Index",
      CellTags->"Fits"],
    Cell[200970, 7867, 619, 21, 48, "IndexSubentry",
      CellTags->"Fits"]},
  "Fixed point"->{
    Cell[201592, 7890, 230, 7, 16, "Index",
      CellTags->"Fixed point"]},
  "Fixed precision arithmetic"->{
    Cell[201825, 7899, 253, 7, 16, "Index",
      CellTags->"Fixed precision arithmetic"]},
  "Floating-point hardware"->{
    Cell[202081, 7908, 391, 11, 16, "Index",
      CellTags->"Floating-point hardware"]},
  "FolkmanGraph"->{
    Cell[202475, 7921, 236, 8, 16, "Index",
      CellTags->"FolkmanGraph"]},
  "Format"->{
    Cell[202714, 7931, 210, 7, 16, "Index",
      CellTags->"Format"]},
  "Four-dimensional graphics"->{
    Cell[202927, 7940, 233, 7, 16, "Index",
      CellTags->"Four-dimensional graphics"]},
  "Fourier summation waveform synthesis"->{
    Cell[203163, 7949, 248, 7, 16, "Index",
      CellTags->"Fourier summation waveform synthesis"]},
  "FourierCoefficient"->{
    Cell[203414, 7958, 384, 12, 16, "Index",
      CellTags->"FourierCoefficient"]},
  "FourierCos"->{
    Cell[203801, 7972, 229, 8, 16, "Index",
      CellTags->"FourierCos"]},
  "FourierCosCoefficient"->{
    Cell[204033, 7982, 251, 8, 16, "Index",
      CellTags->"FourierCosCoefficient"]},
  "FourierSeries"->{
    Cell[204287, 7992, 235, 8, 16, "Index",
      CellTags->"FourierSeries"]},
  "FourierSin"->{
    Cell[204525, 8002, 229, 8, 16, "Index",
      CellTags->"FourierSin"]},
  "FourierSinCoefficient"->{
    Cell[204757, 8012, 251, 8, 16, "Index",
      CellTags->"FourierSinCoefficient"]},
  "FourierTransform package"->{
    Cell[205011, 8022, 257, 8, 16, "Index",
      CellTags->"FourierTransform package"]},
  "FourierTrig package"->{
    Cell[205271, 8032, 247, 8, 16, "Index",
      CellTags->"FourierTrig package"]},
  "FourierTrigSeries"->{
    Cell[205521, 8042, 243, 8, 16, "Index",
      CellTags->"FourierTrigSeries"]},
  "FranklinGraph"->{
    Cell[205767, 8052, 238, 8, 16, "Index",
      CellTags->"FranklinGraph"]},
  "FRatioCI"->{
    Cell[206008, 8062, 236, 8, 16, "Index",
      CellTags->"FRatioCI"]},
  "FRatioDistribution"->{
    Cell[206247, 8072, 409, 12, 32, "Index",
      CellTags->"FRatioDistribution"]},
  "FRatioPValue"->{
    Cell[206659, 8086, 236, 8, 16, "Index",
      CellTags->"FRatioPValue"]},
  "Frequencies"->{
    Cell[206898, 8096, 235, 8, 16, "Index",
      CellTags->"Frequencies"]},
  "Frequency/pitch equivalents"->{
    Cell[207136, 8106, 230, 7, 16, "Index",
      CellTags->"Frequency/pitch equivalents"]},
  "FrequencyData"->{
    Cell[207369, 8115, 465, 16, 16, "Index",
      CellTags->"FrequencyData"]},
  "FrequencyModulation"->{
    Cell[207837, 8133, 236, 8, 16, "Index",
      CellTags->"FrequencyModulation"]},
  "FromAdjacencyLists"->{
    Cell[208076, 8143, 248, 8, 16, "Index",
      CellTags->"FromAdjacencyLists"]},
  "FromAdjacencyMatrix"->{
    Cell[208327, 8153, 250, 8, 16, "Index",
      CellTags->"FromAdjacencyMatrix"]},
  "FrobeniusF"->{
    Cell[208580, 8163, 222, 8, 16, "Index",
      CellTags->"FrobeniusF"]},
  "FrobeniusInstance"->{
    Cell[208805, 8173, 236, 8, 16, "Index",
      CellTags->"FrobeniusInstance"]},
  "FrobeniusSolve"->{
    Cell[209044, 8183, 230, 8, 16, "Index",
      CellTags->"FrobeniusSolve"]},
  "FromContinuedFraction"->{
    Cell[209277, 8193, 263, 8, 16, "Index",
      CellTags->"FromContinuedFraction"]},
  "FromCycles"->{
    Cell[209543, 8203, 232, 8, 16, "Index",
      CellTags->"FromCycles"]},
  "FromDigits"->{
    Cell[209778, 8213, 241, 8, 16, "Index",
      CellTags->"FromDigits"]},
  "FromElementCode"->{
    Cell[210022, 8223, 230, 8, 16, "Index",
      CellTags->"FromElementCode"]},
  "FromInversionVector"->{
    Cell[210255, 8233, 250, 8, 16, "Index",
      CellTags->"FromInversionVector"]},
  "FromOrderedPairs"->{
    Cell[210508, 8243, 244, 8, 16, "Index",
      CellTags->"FromOrderedPairs"]},
  "FromQuaternion"->{
    Cell[210755, 8253, 225, 8, 16, "Index",
      CellTags->"FromQuaternion"]},
  "FromUnorderedPairs"->{
    Cell[210983, 8263, 248, 8, 16, "Index",
      CellTags->"FromUnorderedPairs"]},
  "Front"->{
    Cell[211234, 8273, 207, 8, 16, "Index",
      CellTags->"Front"]},
  "FruchtGraph"->{
    Cell[211444, 8283, 234, 8, 16, "Index",
      CellTags->"FruchtGraph"]},
  "FullPath"->{
    Cell[211681, 8293, 209, 8, 16, "Index",
      CellTags->"FullPath"]},
  "FullReport"->{
    Cell[211893, 8303, 231, 8, 16, "Index",
      CellTags->"FullReport"]},
  "Function values"->{
    Cell[212127, 8313, 230, 7, 16, "Index",
      CellTags->"Function values"]},
  "FunctionalGraph"->{
    Cell[212360, 8322, 242, 8, 16, "Index",
      CellTags->"FunctionalGraph"]},
  "Functions"->{
    Cell[212605, 8332, 224, 7, 16, "Index",
      CellTags->"Functions"],
    Cell[212832, 8341, 3919, 107, 256, "IndexSubentry",
      CellTags->"Functions"]},
  "FundamentalDiscriminantQ"->{
    Cell[216754, 8450, 276, 8, 16, "Index",
      CellTags->"FundamentalDiscriminantQ"]},
  "GalacticUnit"->{
    Cell[217274, 8470, 245, 8, 16, "Index",
      CellTags->"GalacticUnit"]},
  "Galois fields"->{
    Cell[217522, 8480, 343, 11, 16, "Index",
      CellTags->"Galois fields"]},
  "GammaDistribution"->{
    Cell[217868, 8493, 261, 8, 16, "Index",
      CellTags->"GammaDistribution"]},
  "Gamut"->{
    Cell[218132, 8503, 188, 7, 16, "Index",
      CellTags->"Gamut"]},
  "Gaussian distribution"->{
    Cell[218323, 8512, 300, 9, 16, "Index",
      CellTags->"Gaussian distribution"],
    Cell[218626, 8523, 264, 8, 16, "IndexSubentry",
      CellTags->"Gaussian distribution"]},
  "Gaussian elimination"->{
    Cell[218893, 8533, 227, 7, 16, "Index",
      CellTags->"Gaussian elimination"]},
  "Gaussian quadrature"->{
    Cell[219123, 8542, 377, 11, 16, "Index",
      CellTags->"Gaussian quadrature"]},
  "GaussianIntegers"->{
    Cell[219503, 8555, 215, 8, 16, "Index",
      CellTags->"GaussianIntegers"]},
  "GaussianQuadrature package"->{
    Cell[219721, 8565, 275, 8, 16, "Index",
      CellTags->"GaussianQuadrature package"]},
  "GaussianQuadratureError"->{
    Cell[219999, 8575, 269, 8, 16, "Index",
      CellTags->"GaussianQuadratureError"]},
  "GaussianQuadratureWeights"->{
    Cell[220271, 8585, 273, 8, 16, "Index",
      CellTags->"GaussianQuadratureWeights"]},
  "GCD"->{
    Cell[220547, 8595, 180, 8, 16, "Index",
      CellTags->"GCD"]},
  "Gear ratios"->{
    Cell[220730, 8605, 174, 7, 16, "Index",
      CellTags->"Gear ratios"]},
  "GeneralizedBarChart"->{
    Cell[220907, 8614, 231, 8, 16, "Index",
      CellTags->"GeneralizedBarChart"]},
  "GeneralizedPetersenGraph"->{
    Cell[221141, 8624, 260, 8, 16, "Index",
      CellTags->"GeneralizedPetersenGraph"]},
  "GeneralizedVariance"->{
    Cell[221404, 8634, 272, 8, 16, "Index",
      CellTags->"GeneralizedVariance"]},
  "GeneralMiniMaxApproximation"->{
    Cell[221679, 8644, 270, 8, 16, "Index",
      CellTags->"GeneralMiniMaxApproximation"]},
  "GeneralRationalInterpolation"->{
    Cell[221952, 8654, 272, 8, 16, "Index",
      CellTags->"GeneralRationalInterpolation"]},
  "GeneratingFunction"->{
    Cell[222227, 8664, 234, 8, 16, "Index",
      CellTags->"GeneratingFunction"]},
  "GeneratingFunctionConstants"->{
    Cell[222464, 8674, 252, 8, 16, "Index",
      CellTags->"GeneratingFunctionConstants"]},
  "Geodesate"->{
    Cell[222719, 8684, 213, 8, 16, "Index",
      CellTags->"Geodesate"]},
  "Geodesy"->{
    Cell[222935, 8694, 193, 7, 16, "Index",
      CellTags->"Geodesy"]},
  "Geodesy package"->{
    Cell[223131, 8703, 363, 12, 16, "Index",
      CellTags->"Geodesy package"]},
  "GeodeticToAuthalic"->{
    Cell[223497, 8717, 237, 8, 16, "Index",
      CellTags->"GeodeticToAuthalic"]},
  "Geography"->{
    Cell[223737, 8727, 331, 11, 16, "Index",
      CellTags->"Geography"]},
  "Geometrical characteristics"->{
    Cell[224071, 8740, 240, 7, 16, "Index",
      CellTags->"Geometrical characteristics"],
    Cell[224314, 8749, 220, 7, 16, "IndexSubentry",
      CellTags->"Geometrical characteristics"]},
  "GeometricDistribution"->{
    Cell[224537, 8758, 265, 8, 16, "Index",
      CellTags->"GeometricDistribution"]},
  "GeometricMean"->{
    Cell[224805, 8768, 411, 12, 32, "Index",
      CellTags->"GeometricMean"]},
  "Geostatistics"->{
    Cell[225219, 8782, 178, 7, 16, "Index",
      CellTags->"Geostatistics"]},
  "Get (<<)"->{
    Cell[225400, 8791, 324, 14, 16, "Index",
      CellTags->"Get (<<)"]},
  "GetDictionary"->{
    Cell[225727, 8807, 232, 8, 16, "Index",
      CellTags->"GetDictionary"]},
  "GetEdgeLabels"->{
    Cell[225962, 8817, 238, 8, 16, "Index",
      CellTags->"GetEdgeLabels"]},
  "GetEdgeWeights"->{
    Cell[226203, 8827, 240, 8, 16, "Index",
      CellTags->"GetEdgeWeights"]},
  "GetVertexLabels"->{
    Cell[226446, 8837, 242, 8, 16, "Index",
      CellTags->"GetVertexLabels"]},
  "GetVertexWeights"->{
    Cell[226691, 8847, 244, 8, 16, "Index",
      CellTags->"GetVertexWeights"]},
  "GF"->{
    Cell[226938, 8857, 203, 8, 16, "Index",
      CellTags->"GF"]},
  "Girth"->{
    Cell[227144, 8867, 363, 12, 16, "Index",
      CellTags->"Girth"]},
  "Goldwasser-Kilian primality certificate"->{
    Cell[227510, 8881, 261, 7, 16, "Index",
      CellTags->"Goldwasser-Kilian primality certificate"]},
  "Grad"->{
    Cell[227774, 8890, 214, 8, 16, "Index",
      CellTags->"Grad"]},
  "Gradient"->{
    Cell[227991, 8900, 234, 9, 16, "Index",
      CellTags->"Gradient"],
    Cell[228228, 8911, 489, 15, 32, "IndexSubentry",
      CellTags->"Gradient"]},
  "GramSchmidt"->{
    Cell[228720, 8928, 543, 16, 32, "Index",
      CellTags->"GramSchmidt"]},
  "Granularity"->{
    Cell[229266, 8946, 227, 7, 16, "Index",
      CellTags->"Granularity"]},
  "Graph connectivity"->{
    Cell[229496, 8955, 226, 7, 16, "Index",
      CellTags->"Graph connectivity"]},
  "Graph cycle structure"->{
    Cell[229725, 8964, 232, 7, 16, "Index",
      CellTags->"Graph cycle structure"]},
  "Graph flow"->{
    Cell[229960, 8973, 251, 9, 16, "Index",
      CellTags->"Graph flow"]},
  "Graph invariants"->{
    Cell[230214, 8984, 222, 7, 16, "Index",
      CellTags->"Graph invariants"]},
  "Graph theory"->{
    Cell[230439, 8993, 214, 7, 16, "Index",
      CellTags->"Graph theory"]},
  "GraphCenter"->{
    Cell[230656, 9002, 234, 8, 16, "Index",
      CellTags->"GraphCenter"]},
  "GraphComplement"->{
    Cell[230893, 9012, 242, 8, 16, "Index",
      CellTags->"GraphComplement"]},
  "GraphCoordinates"->{
    Cell[231138, 9022, 228, 7, 16, "Index",
      CellTags->"GraphCoordinates"]},
  "GraphCoordinates3D"->{
    Cell[231369, 9031, 232, 7, 16, "Index",
      CellTags->"GraphCoordinates3D"]},
  "GraphDifference"->{
    Cell[231604, 9040, 242, 8, 16, "Index",
      CellTags->"GraphDifference"]},
  "GraphDistance"->{
    Cell[231849, 9050, 222, 7, 16, "Index",
      CellTags->"GraphDistance"]},
  "GraphicQ"->{
    Cell[232074, 9059, 228, 8, 16, "Index",
      CellTags->"GraphicQ"]},
  "Graphics"->{
    Cell[232305, 9069, 199, 7, 16, "Index",
      CellTags->"Graphics"],
    Cell[232507, 9078, 1156, 35, 96, "IndexSubentry",
      CellTags->"Graphics"],
    Cell[233666, 9115, 222, 8, 16, "Index",
      CellTags->"Graphics"]},
  "Graphics directives"->{
    Cell[233891, 9125, 249, 9, 16, "Index",
      CellTags->"Graphics directives"],
    Cell[234143, 9136, 395, 14, 32, "IndexSubentry",
      CellTags->"Graphics directives"]},
  "Graphics file format"->{
    Cell[234541, 9152, 244, 7, 16, "Index",
      CellTags->"Graphics file format"]},
  "Graphics package"->{
    Cell[234788, 9161, 225, 8, 16, "Index",
      CellTags->"Graphics package"]},
  "Graphics primitives"->{
    Cell[235016, 9171, 356, 11, 16, "Index",
      CellTags->"Graphics primitives"],
    Cell[235375, 9184, 429, 15, 32, "IndexSubentry",
      CellTags->"Graphics primitives"]},
  "Graphics sequence"->{
    Cell[235807, 9201, 207, 7, 16, "Index",
      CellTags->"Graphics sequence"]},
  "Graphics3D package"->{
    Cell[236017, 9210, 233, 8, 16, "Index",
      CellTags->"Graphics3D package"]},
  "GraphicsArray"->{
    Cell[236253, 9220, 220, 8, 16, "Index",
      CellTags->"GraphicsArray"]},
  "GraphIntersection"->{
    Cell[236476, 9230, 246, 8, 16, "Index",
      CellTags->"GraphIntersection"]},
  "GraphJoin"->{
    Cell[236725, 9240, 371, 12, 16, "Index",
      CellTags->"GraphJoin"]},
  "GraphOptions"->{
    Cell[237099, 9254, 236, 8, 16, "Index",
      CellTags->"GraphOptions"]},
  "GraphPlot"->{
    Cell[237338, 9264, 213, 7, 16, "Index",
      CellTags->"GraphPlot"]},
  "GraphPlot package"->{
    Cell[237554, 9273, 230, 7, 16, "Index",
      CellTags->"GraphPlot package"]},
  "GraphPlot3D"->{
    Cell[237787, 9282, 218, 7, 16, "Index",
      CellTags->"GraphPlot3D"]},
  "GraphPolynomial"->{
    Cell[238008, 9291, 242, 8, 16, "Index",
      CellTags->"GraphPolynomial"]},
  "GraphPower"->{
    Cell[238253, 9301, 232, 8, 16, "Index",
      CellTags->"GraphPower"]},
  "GraphProduct"->{
    Cell[238488, 9311, 377, 12, 16, "Index",
      CellTags->"GraphProduct"]},
  "Graphs"->{
    Cell[238868, 9325, 213, 7, 16, "Index",
      CellTags->"Graphs"],
    Cell[239084, 9334, 875, 27, 80, "IndexSubentry",
      CellTags->"Graphs"]},
  "GraphSum"->{
    Cell[239962, 9363, 369, 12, 16, "Index",
      CellTags->"GraphSum"]},
  "GraphUnion"->{
    Cell[240334, 9377, 373, 12, 16, "Index",
      CellTags->"GraphUnion"]},
  "GravitationalConstant"->{
    Cell[240710, 9391, 263, 8, 16, "Index",
      CellTags->"GravitationalConstant"]},
  "GravityAcceleration"->{
    Cell[240976, 9401, 261, 8, 16, "Index",
      CellTags->"GravityAcceleration"]},
  "GrayCode"->{
    Cell[241240, 9411, 228, 8, 16, "Index",
      CellTags->"GrayCode"]},
  "GrayCodeKSubsets"->{
    Cell[241471, 9421, 244, 8, 16, "Index",
      CellTags->"GrayCodeKSubsets"]},
  "GrayCodeSubsets"->{
    Cell[241718, 9431, 242, 8, 16, "Index",
      CellTags->"GrayCodeSubsets"]},
  "GrayGraph"->{
    Cell[241963, 9441, 230, 8, 16, "Index",
      CellTags->"GrayGraph"]},
  "GrayLevel"->{
    Cell[242196, 9451, 213, 8, 16, "Index",
      CellTags->"GrayLevel"]},
  "GreatDodecahedron"->{
    Cell[242412, 9461, 229, 8, 16, "Index",
      CellTags->"GreatDodecahedron"]},
  "Greatest common divisor of polynomials"->{
    Cell[242644, 9471, 281, 7, 16, "Index",
      CellTags->"Greatest common divisor of polynomials"]},
  "GreatIcosahedron"->{
    Cell[242928, 9480, 227, 8, 16, "Index",
      CellTags->"GreatIcosahedron"]},
  "GreatStellatedDodecahedron"->{
    Cell[243158, 9490, 247, 8, 16, "Index",
      CellTags->"GreatStellatedDodecahedron"]},
  "GreedyVertexCover"->{
    Cell[243408, 9500, 246, 8, 16, "Index",
      CellTags->"GreedyVertexCover"]},
  "Grid"->{
    Cell[243657, 9510, 212, 7, 16, "Index",
      CellTags->"Grid"]},
  "GridGraph"->{
    Cell[243872, 9519, 371, 12, 16, "Index",
      CellTags->"GridGraph"]},
  "HalfNormalDistribution"->{
    Cell[244459, 9542, 271, 8, 16, "Index",
      CellTags->"HalfNormalDistribution"]},
  "Hamiltonian"->{
    Cell[244733, 9552, 214, 7, 16, "Index",
      CellTags->"Hamiltonian"],
    Cell[244950, 9561, 254, 9, 16, "IndexSubentry",
      CellTags->"Hamiltonian"]},
  "HamiltonianCycle"->{
    Cell[245207, 9572, 385, 12, 16, "Index",
      CellTags->"HamiltonianCycle"]},
  "HamiltonianQ"->{
    Cell[245595, 9586, 236, 8, 16, "Index",
      CellTags->"HamiltonianQ"]},
  "HankelMatrix"->{
    Cell[245834, 9596, 248, 8, 16, "Index",
      CellTags->"HankelMatrix"]},
  "Harary"->{
    Cell[246085, 9606, 224, 8, 16, "Index",
      CellTags->"Harary"]},
  "HarmonicMean"->{
    Cell[246312, 9616, 409, 12, 32, "Index",
      CellTags->"HarmonicMean"]},
  "HasseDiagram"->{
    Cell[246724, 9630, 377, 12, 16, "Index",
      CellTags->"HasseDiagram"]},
  "HatDiagonal"->{
    Cell[247104, 9644, 493, 16, 32, "Index",
      CellTags->"HatDiagonal"]},
  "HeadCenter"->{
    Cell[247600, 9662, 207, 8, 16, "Index",
      CellTags->"HeadCenter"]},
  "HeadLength"->{
    Cell[247810, 9672, 207, 8, 16, "Index",
      CellTags->"HeadLength"]},
  "HeadScaling"->{
    Cell[248020, 9682, 209, 8, 16, "Index",
      CellTags->"HeadScaling"]},
  "HeadShape"->{
    Cell[248232, 9692, 205, 8, 16, "Index",
      CellTags->"HeadShape"]},
  "HeadWidth"->{
    Cell[248440, 9702, 205, 8, 16, "Index",
      CellTags->"HeadWidth"]},
  "Heapify"->{
    Cell[248648, 9712, 226, 8, 16, "Index",
      CellTags->"Heapify"]},
  "HeapSort"->{
    Cell[248877, 9722, 228, 8, 16, "Index",
      CellTags->"HeapSort"]},
  "HeatOfFusion"->{
    Cell[249108, 9732, 243, 8, 16, "Index",
      CellTags->"HeatOfFusion"]},
  "HeatOfVaporization"->{
    Cell[249354, 9742, 255, 8, 16, "Index",
      CellTags->"HeatOfVaporization"]},
  "HeawoodGraph"->{
    Cell[249612, 9752, 236, 8, 16, "Index",
      CellTags->"HeawoodGraph"]},
  "Height"->{
    Cell[249851, 9762, 252, 9, 16, "Index",
      CellTags->"Height"]},
  "Helix"->{
    Cell[250106, 9773, 199, 8, 16, "Index",
      CellTags->"Helix"]},
  "Heptagon"->{
    Cell[250308, 9783, 211, 8, 16, "Index",
      CellTags->"Heptagon"]},
  "HerschelGraph"->{
    Cell[250522, 9793, 238, 8, 16, "Index",
      CellTags->"HerschelGraph"]},
  "HertzToCents"->{
    Cell[250763, 9803, 221, 8, 16, "Index",
      CellTags->"HertzToCents"]},
  "Hexagon"->{
    Cell[250987, 9813, 209, 8, 16, "Index",
      CellTags->"Hexagon"]},
  "Hexahedron"->{
    Cell[251199, 9823, 215, 8, 16, "Index",
      CellTags->"Hexahedron"]},
  "HideCycles"->{
    Cell[251417, 9833, 232, 8, 16, "Index",
      CellTags->"HideCycles"]},
  "Highlight"->{
    Cell[251652, 9843, 371, 12, 16, "Index",
      CellTags->"Highlight"]},
  "HighlightedEdgeColors"->{
    Cell[252026, 9857, 254, 8, 16, "Index",
      CellTags->"HighlightedEdgeColors"]},
  "HighlightedEdgeStyle"->{
    Cell[252283, 9867, 252, 8, 16, "Index",
      CellTags->"HighlightedEdgeStyle"]},
  "HighlightedVertexColors"->{
    Cell[252538, 9877, 258, 8, 16, "Index",
      CellTags->"HighlightedVertexColors"]},
  "HighlightedVertexStyle"->{
    Cell[252799, 9887, 256, 8, 16, "Index",
      CellTags->"HighlightedVertexStyle"]},
  "HilbertMatrix"->{
    Cell[253058, 9897, 250, 8, 16, "Index",
      CellTags->"HilbertMatrix"]},
  "Histogram"->{
    Cell[253311, 9907, 212, 8, 16, "Index",
      CellTags->"Histogram"]},
  "Histogram3D"->{
    Cell[253526, 9917, 220, 8, 16, "Index",
      CellTags->"Histogram3D"]},
  "HistogramCategories"->{
    Cell[253749, 9927, 477, 16, 16, "Index",
      CellTags->"HistogramCategories"]},
  "HistogramRange"->{
    Cell[254229, 9945, 467, 16, 16, "Index",
      CellTags->"HistogramRange"]},
  "Histograms"->{
    Cell[254699, 9963, 212, 7, 16, "Index",
      CellTags->"Histograms"]},
  "HistogramScale"->{
    Cell[254914, 9972, 467, 16, 16, "Index",
      CellTags->"HistogramScale"]},
  "HLSColor"->{
    Cell[255384, 9990, 205, 8, 16, "Index",
      CellTags->"HLSColor"]},
  "Hofstadter"->{
    Cell[255592, 10000, 249, 8, 16, "Index",
      CellTags->"Hofstadter"]},
  "Holidays"->{
    Cell[255844, 10010, 208, 7, 16, "Index",
      CellTags->"Holidays"]},
  "Hook length formula"->{
    Cell[256055, 10019, 228, 7, 16, "Index",
      CellTags->"Hook length formula"]},
  "Horizontal"->{
    Cell[256286, 10028, 209, 8, 16, "Index",
      CellTags->"Horizontal"]},
  "Horner package"->{
    Cell[256498, 10038, 215, 8, 16, "Index",
      CellTags->"Horner package"]},
  "HotellingTSquareDistribution"->{
    Cell[256716, 10048, 283, 8, 16, "Index",
      CellTags->"HotellingTSquareDistribution"]},
  "Householder"->{
    Cell[257002, 10058, 244, 8, 16, "Index",
      CellTags->"Householder"]},
  "HubbleConstant"->{
    Cell[257249, 10068, 249, 8, 16, "Index",
      CellTags->"HubbleConstant"]},
  "Hue"->{
    Cell[257501, 10078, 319, 12, 16, "Index",
      CellTags->"Hue"]},
  "Hull"->{
    Cell[257823, 10092, 236, 8, 16, "Index",
      CellTags->"Hull"]},
  "Hypercube"->{
    Cell[258062, 10102, 371, 12, 16, "Index",
      CellTags->"Hypercube"]},
  "HypergeometricDistribution"->{
    Cell[258436, 10116, 275, 8, 16, "Index",
      CellTags->"HypergeometricDistribution"]},
  "Hypothesis tests"->{
    Cell[258714, 10126, 221, 7, 16, "Index",
      CellTags->"Hypothesis tests"]},
  "IcePoint"->{
    Cell[259311, 10148, 237, 8, 16, "Index",
      CellTags->"IcePoint"]},
  "IcosahedralGraph"->{
    Cell[259551, 10158, 244, 8, 16, "Index",
      CellTags->"IcosahedralGraph"]},
  "Icosahedron"->{
    Cell[259798, 10168, 341, 12, 16, "Index",
      CellTags->"Icosahedron"]},
  "IdealDivide"->{
    Cell[260142, 10182, 246, 8, 16, "Index",
      CellTags->"IdealDivide"]},
  "IdenticalQ"->{
    Cell[260391, 10192, 232, 8, 16, "Index",
      CellTags->"IdenticalQ"]},
  "IdentityPermutation"->{
    Cell[260626, 10202, 250, 8, 16, "Index",
      CellTags->"IdentityPermutation"]},
  "Im"->{
    Cell[260879, 10212, 187, 8, 16, "Index",
      CellTags->"Im"]},
  "Image sequence"->{
    Cell[261069, 10222, 201, 7, 16, "Index",
      CellTags->"Image sequence"]},
  "Implicit"->{
    Cell[261273, 10231, 218, 8, 16, "Index",
      CellTags->"Implicit"]},
  "Implicit functions"->{
    Cell[261494, 10241, 357, 11, 16, "Index",
      CellTags->"Implicit functions"]},
  "ImplicitPlot"->{
    Cell[261854, 10254, 225, 8, 16, "Index",
      CellTags->"ImplicitPlot"]},
  "ImplicitPlot package"->{
    Cell[262082, 10264, 241, 8, 16, "Index",
      CellTags->"ImplicitPlot package"]},
  "IncidenceMatrix"->{
    Cell[262326, 10274, 242, 8, 16, "Index",
      CellTags->"IncidenceMatrix"]},
  "IncludeConstant"->{
    Cell[262571, 10284, 244, 8, 16, "Index",
      CellTags->"IncludeConstant"]},
  "InDegree"->{
    Cell[262818, 10294, 228, 8, 16, "Index",
      CellTags->"InDegree"]},
  "IndependentSetQ"->{
    Cell[263049, 10304, 242, 8, 16, "Index",
      CellTags->"IndependentSetQ"]},
  "Index"->{
    Cell[263294, 10314, 222, 8, 16, "Index",
      CellTags->"Index"]},
  "Index files (names files)"->{
    Cell[263519, 10324, 311, 11, 16, "Index",
      CellTags->"Index files (names files)"]},
  "InduceSubgraph"->{
    Cell[263833, 10337, 381, 12, 16, "Index",
      CellTags->"InduceSubgraph"]},
  "Inequalities"->{
    Cell[264217, 10351, 230, 7, 16, "Index",
      CellTags->"Inequalities"],
    Cell[264450, 10360, 225, 7, 16, "IndexSubentry",
      CellTags->"Inequalities"]},
  "Inequality solving"->{
    Cell[264678, 10369, 219, 7, 16, "Index",
      CellTags->"Inequality solving"]},
  "InequalityGraphics package"->{
    Cell[264900, 10378, 265, 8, 16, "Index",
      CellTags->"InequalityGraphics package"]},
  "InequalityPlot"->{
    Cell[265168, 10388, 241, 8, 16, "Index",
      CellTags->"InequalityPlot"]},
  "InequalityPlot3D"->{
    Cell[265412, 10398, 245, 8, 16, "Index",
      CellTags->"InequalityPlot3D"]},
  "InequalitySolve"->{
    Cell[265660, 10408, 235, 8, 16, "Index",
      CellTags->"InequalitySolve"]},
  "InequalitySolve package"->{
    Cell[265898, 10418, 251, 8, 16, "Index",
      CellTags->"InequalitySolve package"]},
  "Infinite recursion"->{
    Cell[266152, 10428, 198, 7, 16, "Index",
      CellTags->"Infinite recursion"]},
  "Information"->{
    Cell[266353, 10437, 209, 7, 16, "Index",
      CellTags->"Information"],
    Cell[266565, 10446, 204, 7, 16, "IndexSubentry",
      CellTags->"Information"]},
  "init.m files"->{
    Cell[266772, 10455, 307, 12, 16, "Index",
      CellTags->"init.m files"]},
  "Initialization files"->{
    Cell[267082, 10469, 195, 7, 16, "Index",
      CellTags->"Initialization files"]},
  "InitializeUnionFind"->{
    Cell[267280, 10478, 250, 8, 16, "Index",
      CellTags->"InitializeUnionFind"]},
  "Inner products"->{
    Cell[267533, 10488, 283, 9, 16, "Index",
      CellTags->"Inner products"]},
  "InnerProduct"->{
    Cell[267819, 10499, 245, 8, 16, "Index",
      CellTags->"InnerProduct"]},
  "InscribedRadius"->{
    Cell[268067, 10509, 349, 12, 16, "Index",
      CellTags->"InscribedRadius"]},
  "InsertIntoTableau"->{
    Cell[268419, 10523, 246, 8, 16, "Index",
      CellTags->"InsertIntoTableau"]},
  "IntegerQuaternionQ"->{
    Cell[268668, 10533, 234, 8, 16, "Index",
      CellTags->"IntegerQuaternionQ"]},
  "Integers"->{
    Cell[268905, 10543, 312, 9, 32, "Index",
      CellTags->"Integers"],
    Cell[269220, 10554, 776, 21, 64, "IndexSubentry",
      CellTags->"Integers"]},
  "Integrals"->{
    Cell[269999, 10577, 235, 7, 16, "Index",
      CellTags->"Integrals"]},
  "Integration"->{
    Cell[270237, 10586, 288, 9, 16, "Index",
      CellTags->"Integration"],
    Cell[270528, 10597, 1039, 31, 80, "IndexSubentry",
      CellTags->"Integration"]},
  "Integration:numerical"->{
    Cell[271570, 10630, 285, 8, 16, "Index",
      CellTags->"Integration:numerical"]},
  "InterpolatedQuantile"->{
    Cell[271858, 10640, 425, 12, 32, "Index",
      CellTags->"InterpolatedQuantile"]},
  "InterpolateRoot"->{
    Cell[272286, 10654, 247, 8, 16, "Index",
      CellTags->"InterpolateRoot"]},
  "InterpolateRoot package"->{
    Cell[272536, 10664, 263, 8, 16, "Index",
      CellTags->"InterpolateRoot package"]},
  "InterpolatingFunction"->{
    Cell[272802, 10674, 263, 7, 16, "Index",
      CellTags->"InterpolatingFunction"],
    Cell[273068, 10683, 255, 8, 16, "Index",
      CellTags->"InterpolatingFunction"]},
  "InterpolatingPolynomial"->{
    Cell[273326, 10693, 375, 12, 16, "Index",
      CellTags->"InterpolatingPolynomial"]},
  "Interpolation"->{
    Cell[273704, 10707, 497, 16, 32, "Index",
      CellTags->"Interpolation"]},
  "InterquartileRange"->{
    Cell[274204, 10725, 422, 12, 32, "Index",
      CellTags->"InterquartileRange"]},
  "Interval, confidence"->{
    Cell[274629, 10739, 237, 7, 16, "Index",
      CellTags->"Interval, confidence"]},
  "IntervalBisection"->{
    Cell[274869, 10748, 247, 8, 16, "Index",
      CellTags->"IntervalBisection"]},
  "IntervalBoundaries"->{
    Cell[275119, 10758, 225, 8, 16, "Index",
      CellTags->"IntervalBoundaries"]},
  "IntervalCenters"->{
    Cell[275347, 10768, 219, 8, 16, "Index",
      CellTags->"IntervalCenters"]},
  "IntervalGraph"->{
    Cell[275569, 10778, 238, 8, 16, "Index",
      CellTags->"IntervalGraph"]},
  "IntervalNewton"->{
    Cell[275810, 10788, 241, 8, 16, "Index",
      CellTags->"IntervalNewton"]},
  "IntervalRoots package"->{
    Cell[276054, 10798, 255, 8, 16, "Index",
      CellTags->"IntervalRoots package"]},
  "IntervalSecant"->{
    Cell[276312, 10808, 241, 8, 16, "Index",
      CellTags->"IntervalSecant"]},
  "Invariants"->{
    Cell[276556, 10818, 221, 7, 16, "Index",
      CellTags->"Invariants"],
    Cell[276780, 10827, 232, 8, 16, "Index",
      CellTags->"Invariants"]},
  "InverseDTFourierTransform"->{
    Cell[277015, 10837, 260, 8, 16, "Index",
      CellTags->"InverseDTFourierTransform"]},
  "InverseFourierCoefficient"->{
    Cell[277278, 10847, 260, 8, 16, "Index",
      CellTags->"InverseFourierCoefficient"]},
  "InverseMatrixNorm"->{
    Cell[277541, 10857, 258, 8, 16, "Index",
      CellTags->"InverseMatrixNorm"]},
  "InversePermutation"->{
    Cell[277802, 10867, 389, 12, 16, "Index",
      CellTags->"InversePermutation"]},
  "InversionPoset"->{
    Cell[278194, 10881, 240, 8, 16, "Index",
      CellTags->"InversionPoset"]},
  "Inversions"->{
    Cell[278437, 10891, 373, 12, 16, "Index",
      CellTags->"Inversions"]},
  "InvolutionQ"->{
    Cell[278813, 10905, 234, 8, 16, "Index",
      CellTags->"InvolutionQ"]},
  "Involutions"->{
    Cell[279050, 10915, 234, 8, 16, "Index",
      CellTags->"Involutions"]},
  "IonizationPotential"->{
    Cell[279287, 10925, 258, 8, 16, "Index",
      CellTags->"IonizationPotential"]},
  "IrreduciblePolynomial"->{
    Cell[279548, 10935, 242, 8, 16, "Index",
      CellTags->"IrreduciblePolynomial"]},
  "Isolating intervals"->{
    Cell[279793, 10945, 217, 7, 16, "Index",
      CellTags->"Isolating intervals"]},
  "IsomorphicQ"->{
    Cell[280013, 10954, 234, 8, 16, "Index",
      CellTags->"IsomorphicQ"]},
  "Isomorphism"->{
    Cell[280250, 10964, 375, 12, 16, "Index",
      CellTags->"Isomorphism"]},
  "IsomorphismQ"->{
    Cell[280628, 10978, 236, 8, 16, "Index",
      CellTags->"IsomorphismQ"]},
  "Isomorphisms"->{
    Cell[280867, 10988, 271, 9, 16, "Index",
      CellTags->"Isomorphisms"]},
  "JaccardDissimilarity"->{
    Cell[281385, 11009, 294, 10, 16, "Index",
      CellTags->"JaccardDissimilarity"]},
  "JackknifedVariance"->{
    Cell[281682, 11021, 372, 12, 16, "Index",
      CellTags->"JackknifedVariance"]},
  "JacobianDeterminant"->{
    Cell[282057, 11035, 244, 8, 16, "Index",
      CellTags->"JacobianDeterminant"]},
  "JacobianMatrix"->{
    Cell[282304, 11045, 234, 8, 16, "Index",
      CellTags->"JacobianMatrix"]},
  "JacobiSymbol"->{
    Cell[282541, 11055, 409, 12, 32, "Index",
      CellTags->"JacobiSymbol"]},
  "JewishNewYear"->{
    Cell[282953, 11069, 230, 8, 16, "Index",
      CellTags->"JewishNewYear"]},
  "Josephus"->{
    Cell[283186, 11079, 228, 8, 16, "Index",
      CellTags->"Josephus"]},
  "JustMajor"->{
    Cell[283417, 11089, 215, 8, 16, "Index",
      CellTags->"JustMajor"]},
  "KendallRankCorrelation"->{
    Cell[283828, 11108, 278, 8, 16, "Index",
      CellTags->"KendallRankCorrelation"]},
  "Kernel initialization files"->{
    Cell[284109, 11118, 209, 7, 16, "Index",
      CellTags->"Kernel initialization files"]},
  "Keys on plots"->{
    Cell[284321, 11127, 193, 7, 16, "Index",
      CellTags->"Keys on plots"]},
  "Keywords"->{
    Cell[284517, 11136, 187, 7, 16, "Index",
      CellTags->"Keywords"]},
  "KinematicViscosity"->{
    Cell[284707, 11145, 259, 8, 16, "Index",
      CellTags->"KinematicViscosity"]},
  "KineticTemperature"->{
    Cell[284969, 11155, 259, 8, 16, "Index",
      CellTags->"KineticTemperature"]},
  "KnightsTourGraph"->{
    Cell[285231, 11165, 244, 8, 16, "Index",
      CellTags->"KnightsTourGraph"]},
  "KnownStandardDeviation"->{
    Cell[285478, 11175, 526, 16, 32, "Index",
      CellTags->"KnownStandardDeviation"]},
  "KnownVariance"->{
    Cell[286007, 11193, 508, 16, 32, "Index",
      CellTags->"KnownVariance"]},
  "KroneckerSymbol"->{
    Cell[286518, 11211, 258, 8, 16, "Index",
      CellTags->"KroneckerSymbol"]},
  "KSetPartitions"->{
    Cell[286779, 11221, 240, 8, 16, "Index",
      CellTags->"KSetPartitions"]},
  "KSubsetGroup"->{
    Cell[287022, 11231, 236, 8, 16, "Index",
      CellTags->"KSubsetGroup"]},
  "KSubsetGroupIndex"->{
    Cell[287261, 11241, 246, 8, 16, "Index",
      CellTags->"KSubsetGroupIndex"]},
  "KSubsets"->{
    Cell[287510, 11251, 228, 8, 16, "Index",
      CellTags->"KSubsets"]},
  "Kurtosis"->{
    Cell[287741, 11261, 1177, 32, 64, "Index",
      CellTags->"Kurtosis"]},
  "LabeledListPlot"->{
    Cell[290083, 11328, 224, 8, 16, "Index",
      CellTags->"LabeledListPlot"]},
  "LabeledTreeToCode"->{
    Cell[290310, 11338, 246, 8, 16, "Index",
      CellTags->"LabeledTreeToCode"]},
  "LabelPoints"->{
    Cell[290559, 11348, 250, 8, 16, "Index",
      CellTags->"LabelPoints"]},
  "Lagrangian"->{
    Cell[290812, 11358, 211, 7, 16, "Index",
      CellTags->"Lagrangian"]},
  "LaplaceDistribution"->{
    Cell[291026, 11367, 265, 8, 16, "Index",
      CellTags->"LaplaceDistribution"]},
  "Laplacian"->{
    Cell[291294, 11377, 224, 8, 16, "Index",
      CellTags->"Laplacian"]},
  "Large"->{
    Cell[291521, 11387, 222, 8, 16, "Index",
      CellTags->"Large"]},
  "LastLexicographicTableau"->{
    Cell[291746, 11397, 260, 8, 16, "Index",
      CellTags->"LastLexicographicTableau"]},
  "Latitude"->{
    Cell[292009, 11407, 327, 11, 16, "Index",
      CellTags->"Latitude"]},
  "Least-squares fitting"->{
    Cell[292339, 11420, 647, 19, 32, "Index",
      CellTags->"Least-squares fitting"]},
  "LeastPrimeFactor"->{
    Cell[292989, 11441, 260, 8, 16, "Index",
      CellTags->"LeastPrimeFactor"]},
  "LeftAssociates"->{
    Cell[293252, 11451, 226, 8, 16, "Index",
      CellTags->"LeftAssociates"]},
  "LeftGCD"->{
    Cell[293481, 11461, 212, 8, 16, "Index",
      CellTags->"LeftGCD"]},
  "Legend"->{
    Cell[293696, 11471, 201, 8, 16, "Index",
      CellTags->"Legend"]},
  "LegendBackground"->{
    Cell[293900, 11481, 221, 8, 16, "Index",
      CellTags->"LegendBackground"]},
  "LegendBorder"->{
    Cell[294124, 11491, 213, 8, 16, "Index",
      CellTags->"LegendBorder"]},
  "LegendBorderSpace"->{
    Cell[294340, 11501, 223, 8, 16, "Index",
      CellTags->"LegendBorderSpace"]},
  "LegendLabel"->{
    Cell[294566, 11511, 211, 8, 16, "Index",
      CellTags->"LegendLabel"]},
  "LegendLabelSpace"->{
    Cell[294780, 11521, 221, 8, 16, "Index",
      CellTags->"LegendLabelSpace"]},
  "LegendOrientation"->{
    Cell[295004, 11531, 223, 8, 16, "Index",
      CellTags->"LegendOrientation"]},
  "LegendPosition"->{
    Cell[295230, 11541, 217, 8, 16, "Index",
      CellTags->"LegendPosition"]},
  "Legends on plots"->{
    Cell[295450, 11551, 199, 7, 16, "Index",
      CellTags->"Legends on plots"]},
  "Legends package"->{
    Cell[295652, 11560, 219, 8, 16, "Index",
      CellTags->"Legends package"]},
  "LegendShadow"->{
    Cell[295874, 11570, 213, 8, 16, "Index",
      CellTags->"LegendShadow"]},
  "LegendSize"->{
    Cell[296090, 11580, 209, 8, 16, "Index",
      CellTags->"LegendSize"]},
  "LegendSpacing"->{
    Cell[296302, 11590, 215, 8, 16, "Index",
      CellTags->"LegendSpacing"]},
  "LegendTextDirection"->{
    Cell[296520, 11600, 227, 8, 16, "Index",
      CellTags->"LegendTextDirection"]},
  "LegendTextOffset"->{
    Cell[296750, 11610, 221, 8, 16, "Index",
      CellTags->"LegendTextOffset"]},
  "LegendTextSpace"->{
    Cell[296974, 11620, 219, 8, 16, "Index",
      CellTags->"LegendTextSpace"]},
  "LengthWhile"->{
    Cell[297196, 11630, 235, 8, 16, "Index",
      CellTags->"LengthWhile"]},
  "Lenstra's elliptic curve method"->{
    Cell[297434, 11640, 274, 7, 16, "Index",
      CellTags->"Lenstra's elliptic curve method"]},
  "Level"->{
    Cell[297711, 11649, 219, 7, 16, "Index",
      CellTags->"Level"]},
  "LeviGraph"->{
    Cell[297933, 11658, 230, 8, 16, "Index",
      CellTags->"LeviGraph"]},
  "LexicographicPermutations"->{
    Cell[298166, 11668, 262, 8, 16, "Index",
      CellTags->"LexicographicPermutations"]},
  "LexicographicSubsets"->{
    Cell[298431, 11678, 252, 8, 16, "Index",
      CellTags->"LexicographicSubsets"]},
  "lightsources 3-Script command"->{
    Cell[298686, 11688, 265, 8, 16, "Index",
      CellTags->"lightsources 3-Script command"]},
  "Limit"->{
    Cell[298954, 11698, 209, 8, 16, "Index",
      CellTags->"Limit"]},
  "Limits"->{
    Cell[299166, 11708, 236, 9, 16, "Index",
      CellTags->"Limits"]},
  "line 3-Script command"->{
    Cell[299405, 11719, 249, 8, 16, "Index",
      CellTags->"line 3-Script command"]},
  "Linear equations"->{
    Cell[299657, 11729, 234, 7, 16, "Index",
      CellTags->"Linear equations"]},
  "Linear regression"->{
    Cell[299894, 11738, 225, 7, 16, "Index",
      CellTags->"Linear regression"]},
  "LinearEquationsToMatrices"->{
    Cell[300122, 11747, 274, 8, 16, "Index",
      CellTags->"LinearEquationsToMatrices"]},
  "LinearFilter"->{
    Cell[300399, 11757, 231, 8, 16, "Index",
      CellTags->"LinearFilter"]},
  "LinearLogListPlot"->{
    Cell[300633, 11767, 227, 8, 16, "Index",
      CellTags->"LinearLogListPlot"]},
  "LinearLogPlot"->{
    Cell[300863, 11777, 219, 8, 16, "Index",
      CellTags->"LinearLogPlot"]},
  "LinearRegression package"->{
    Cell[301085, 11787, 261, 8, 16, "Index",
      CellTags->"LinearRegression package"]},
  "LineGraph"->{
    Cell[301349, 11797, 371, 12, 16, "Index",
      CellTags->"LineGraph"]},
  "Lines"->{
    Cell[301723, 11811, 195, 7, 16, "Index",
      CellTags->"Lines"]},
  "ListContourPlot3D"->{
    Cell[301921, 11820, 237, 8, 16, "Index",
      CellTags->"ListContourPlot3D"]},
  "ListGraphs"->{
    Cell[302161, 11830, 232, 8, 16, "Index",
      CellTags->"ListGraphs"]},
  "ListIntegrate"->{
    Cell[302396, 11840, 239, 8, 16, "Index",
      CellTags->"ListIntegrate"]},
  "ListIntegrate package"->{
    Cell[302638, 11850, 255, 8, 16, "Index",
      CellTags->"ListIntegrate package"]},
  "ListNecklaces"->{
    Cell[302896, 11860, 238, 8, 16, "Index",
      CellTags->"ListNecklaces"]},
  "ListPlot"->{
    Cell[303137, 11870, 209, 8, 16, "Index",
      CellTags->"ListPlot"],
    Cell[303349, 11880, 1107, 33, 80, "IndexSubentry",
      CellTags->"ListPlot"]},
  "ListPlot3D"->{
    Cell[304459, 11915, 217, 8, 16, "Index",
      CellTags->"ListPlot3D"],
    Cell[304679, 11925, 252, 9, 16, "IndexSubentry",
      CellTags->"ListPlot3D"]},
  "ListPlotVectorField"->{
    Cell[304934, 11936, 234, 8, 16, "Index",
      CellTags->"ListPlotVectorField"]},
  "ListPlotVectorField3D"->{
    Cell[305171, 11946, 241, 8, 16, "Index",
      CellTags->"ListPlotVectorField3D"]},
  "Lists"->{
    Cell[305415, 11956, 211, 7, 16, "Index",
      CellTags->"Lists"],
    Cell[305629, 11965, 219, 7, 16, "IndexSubentry",
      CellTags->"Lists"]},
  "ListShadowPlot3D"->{
    Cell[305851, 11974, 230, 8, 16, "Index",
      CellTags->"ListShadowPlot3D"]},
  "ListSurfaceOfRevolution"->{
    Cell[306084, 11984, 261, 8, 16, "Index",
      CellTags->"ListSurfaceOfRevolution"]},
  "ListSurfacePlot3D"->{
    Cell[306348, 11994, 231, 8, 16, "Index",
      CellTags->"ListSurfacePlot3D"]},
  "ListWaveform"->{
    Cell[306582, 12004, 222, 8, 16, "Index",
      CellTags->"ListWaveform"]},
  "LNorm"->{
    Cell[306807, 12014, 222, 8, 16, "Index",
      CellTags->"LNorm"]},
  "Loading"->{
    Cell[307032, 12024, 303, 11, 16, "Index",
      CellTags->"Loading"]},
  "Loading packages"->{
    Cell[307338, 12037, 187, 7, 16, "Index",
      CellTags->"Loading packages"]},
  "LocationReport"->{
    Cell[307528, 12046, 251, 8, 16, "Index",
      CellTags->"LocationReport"]},
  "LogisticDistribution"->{
    Cell[307782, 12056, 267, 8, 16, "Index",
      CellTags->"LogisticDistribution"]},
  "LogLinearListPlot"->{
    Cell[308052, 12066, 227, 8, 16, "Index",
      CellTags->"LogLinearListPlot"]},
  "LogLinearPlot"->{
    Cell[308282, 12076, 219, 8, 16, "Index",
      CellTags->"LogLinearPlot"]},
  "LogListPlot"->{
    Cell[308504, 12086, 215, 8, 16, "Index",
      CellTags->"LogListPlot"]},
  "LogLogListPlot"->{
    Cell[308722, 12096, 221, 8, 16, "Index",
      CellTags->"LogLogListPlot"]},
  "LogLogPlot"->{
    Cell[308946, 12106, 213, 8, 16, "Index",
      CellTags->"LogLogPlot"]},
  "LogNormalDistribution"->{
    Cell[309162, 12116, 269, 8, 16, "Index",
      CellTags->"LogNormalDistribution"]},
  "LogPlot"->{
    Cell[309434, 12126, 207, 8, 16, "Index",
      CellTags->"LogPlot"]},
  "LogSeriesDistribution"->{
    Cell[309644, 12136, 265, 8, 16, "Index",
      CellTags->"LogSeriesDistribution"]},
  "LongDash"->{
    Cell[309912, 12146, 226, 8, 16, "Index",
      CellTags->"LongDash"]},
  "LongestIncreasingSubsequence"->{
    Cell[310141, 12156, 409, 12, 32, "Index",
      CellTags->"LongestIncreasingSubsequence"]},
  "Longitude"->{
    Cell[310553, 12170, 329, 11, 16, "Index",
      CellTags->"Longitude"]},
  "LoopPosition"->{
    Cell[310885, 12183, 236, 8, 16, "Index",
      CellTags->"LoopPosition"]},
  "LowerDiagonalMatrix"->{
    Cell[311124, 12193, 262, 8, 16, "Index",
      CellTags->"LowerDiagonalMatrix"]},
  "LowerLeft"->{
    Cell[311389, 12203, 230, 8, 16, "Index",
      CellTags->"LowerLeft"]},
  "LowerRight"->{
    Cell[311622, 12213, 232, 8, 16, "Index",
      CellTags->"LowerRight"]},
  "LowerStatisticalWeight"->{
    Cell[311857, 12223, 279, 8, 16, "Index",
      CellTags->"LowerStatisticalWeight"]},
  "LowerTermFineStructureEnergy"->{
    Cell[312139, 12233, 291, 8, 16, "Index",
      CellTags->"LowerTermFineStructureEnergy"]},
  "LUDecomposition"->{
    Cell[312433, 12243, 232, 7, 16, "Index",
      CellTags->"LUDecomposition"]},
  "M"->{
    Cell[312889, 12261, 355, 12, 16, "Index",
      CellTags->"M"]},
  "Machine arithmetic"->{
    Cell[313247, 12275, 373, 11, 16, "Index",
      CellTags->"Machine arithmetic"]},
  "MachineError"->{
    Cell[313623, 12288, 231, 8, 16, "Index",
      CellTags->"MachineError"]},
  "MagneticFluxQuantum"->{
    Cell[313857, 12298, 259, 8, 16, "Index",
      CellTags->"MagneticFluxQuantum"]},
  "Mahalanobis distance"->{
    Cell[314119, 12308, 245, 7, 16, "Index",
      CellTags->"Mahalanobis distance"]},
  "MakeDirected"->{
    Cell[314367, 12317, 236, 8, 16, "Index",
      CellTags->"MakeDirected"]},
  "MakeGraph"->{
    Cell[314606, 12327, 371, 12, 16, "Index",
      CellTags->"MakeGraph"]},
  "MakeSimple"->{
    Cell[314980, 12341, 232, 8, 16, "Index",
      CellTags->"MakeSimple"]},
  "MakeSymbol"->{
    Cell[315215, 12351, 230, 8, 16, "Index",
      CellTags->"MakeSymbol"]},
  "MakeTree"->{
    Cell[315448, 12361, 209, 8, 16, "Index",
      CellTags->"MakeTree"]},
  "MakeUndirected"->{
    Cell[315660, 12371, 240, 8, 16, "Index",
      CellTags->"MakeUndirected"]},
  "ManhattanDistance"->{
    Cell[315903, 12381, 288, 10, 16, "Index",
      CellTags->"ManhattanDistance"]},
  "Manipulation of data"->{
    Cell[316194, 12393, 231, 7, 16, "Index",
      CellTags->"Manipulation of data"]},
  "Manipulation of matrices"->{
    Cell[316428, 12402, 249, 7, 16, "Index",
      CellTags->"Manipulation of matrices"]},
  "Manipulation of polynomials over finite fields"->{
    Cell[316680, 12411, 281, 7, 16, "Index",
      CellTags->"Manipulation of polynomials over finite fields"]},
  "Manipulation of trees"->{
    Cell[316964, 12420, 213, 7, 16, "Index",
      CellTags->"Manipulation of trees"]},
  "Mappings"->{
    Cell[317180, 12429, 205, 7, 16, "Index",
      CellTags->"Mappings"]},
  "Maps"->{
    Cell[317388, 12438, 205, 7, 16, "Index",
      CellTags->"Maps"]},
  "Markings"->{
    Cell[317596, 12447, 359, 13, 16, "Index",
      CellTags->"Markings"]},
  "MatchingDissimilarity"->{
    Cell[317958, 12462, 296, 10, 16, "Index",
      CellTags->"MatchingDissimilarity"]},
  "MathematicaMark"->{
    Cell[318257, 12474, 226, 8, 16, "Index",
      CellTags->"MathematicaMark"]},
  "Matrices"->{
    Cell[318486, 12484, 271, 9, 16, "Index",
      CellTags->"Matrices"],
    Cell[318760, 12495, 2568, 73, 208, "IndexSubentry",
      CellTags->"Matrices"]},
  "Matrix scatter plot"->{
    Cell[321331, 12570, 227, 7, 16, "Index",
      CellTags->"Matrix scatter plot"]},
  "matrix scatter plot"->{
    Cell[321561, 12579, 228, 7, 16, "Index",
      CellTags->"matrix scatter plot"]},
  "MatrixConditionNumber"->{
    Cell[321792, 12588, 266, 8, 16, "Index",
      CellTags->"MatrixConditionNumber"]},
  "MatrixManipulation package"->{
    Cell[322061, 12598, 406, 12, 32, "Index",
      CellTags->"MatrixManipulation package"]},
  "MatrixPlot"->{
    Cell[322470, 12612, 244, 8, 16, "Index",
      CellTags->"MatrixPlot"]},
  "MaxArrowLength"->{
    Cell[322717, 12622, 469, 16, 16, "Index",
      CellTags->"MaxArrowLength"]},
  "MaxBend"->{
    Cell[323189, 12640, 203, 8, 16, "Index",
      CellTags->"MaxBend"]},
  "MaximalBipartiteMatching"->{
    Cell[323395, 12650, 244, 7, 16, "Index",
      CellTags->"MaximalBipartiteMatching"]},
  "MaximalIndependentEdgeSet"->{
    Cell[323642, 12659, 246, 7, 16, "Index",
      CellTags->"MaximalIndependentEdgeSet"]},
  "MaximalIndependentVertexSet"->{
    Cell[323891, 12668, 250, 7, 16, "Index",
      CellTags->"MaximalIndependentVertexSet"]},
  "MaximalMatching"->{
    Cell[324144, 12677, 383, 12, 16, "Index",
      CellTags->"MaximalMatching"]},
  "Maximum likelihood estimate"->{
    Cell[324530, 12691, 324, 9, 32, "Index",
      CellTags->"Maximum likelihood estimate"],
    Cell[324857, 12702, 1073, 29, 80, "IndexSubentry",
      CellTags->"Maximum likelihood estimate"]},
  "MaximumAntichain"->{
    Cell[325933, 12733, 244, 8, 16, "Index",
      CellTags->"MaximumAntichain"]},
  "MaximumClique"->{
    Cell[326180, 12743, 238, 8, 16, "Index",
      CellTags->"MaximumClique"]},
  "MaximumIndependentSet"->{
    Cell[326421, 12753, 254, 8, 16, "Index",
      CellTags->"MaximumIndependentSet"]},
  "MaximumSpanningTree"->{
    Cell[326678, 12763, 250, 8, 16, "Index",
      CellTags->"MaximumSpanningTree"]},
  "MaxIterations"->{
    Cell[326931, 12773, 545, 16, 32, "Index",
      CellTags->"MaxIterations"]},
  "MaxMatrixSize"->{
    Cell[327479, 12791, 250, 8, 16, "Index",
      CellTags->"MaxMatrixSize"]},
  "MaxPower"->{
    Cell[327732, 12801, 239, 8, 16, "Index",
      CellTags->"MaxPower"]},
  "MaxRecursion"->{
    Cell[327974, 12811, 227, 8, 16, "Index",
      CellTags->"MaxRecursion"]},
  "MaxTerms"->{
    Cell[328204, 12821, 244, 8, 16, "Index",
      CellTags->"MaxTerms"]},
  "McGeeGraph"->{
    Cell[328451, 12831, 232, 8, 16, "Index",
      CellTags->"McGeeGraph"]},
  "Mean"->{
    Cell[328686, 12841, 1167, 32, 64, "Index",
      CellTags->"Mean"]},
  "MeanChromatic"->{
    Cell[329856, 12875, 223, 8, 16, "Index",
      CellTags->"MeanChromatic"]},
  "MeanCI"->{
    Cell[330082, 12885, 231, 8, 16, "Index",
      CellTags->"MeanCI"]},
  "MeanDensity"->{
    Cell[330316, 12895, 245, 8, 16, "Index",
      CellTags->"MeanDensity"]},
  "MeanDeviation"->{
    Cell[330564, 12905, 412, 12, 32, "Index",
      CellTags->"MeanDeviation"]},
  "MeanDifferenceCI"->{
    Cell[330979, 12919, 251, 8, 16, "Index",
      CellTags->"MeanDifferenceCI"]},
  "MeanDifferenceTest"->{
    Cell[331233, 12929, 247, 8, 16, "Index",
      CellTags->"MeanDifferenceTest"]},
  "MeanFreePath"->{
    Cell[331483, 12939, 247, 8, 16, "Index",
      CellTags->"MeanFreePath"]},
  "MeanMajor"->{
    Cell[331733, 12949, 215, 8, 16, "Index",
      CellTags->"MeanMajor"]},
  "MeanMinor"->{
    Cell[331951, 12959, 215, 8, 16, "Index",
      CellTags->"MeanMinor"]},
  "MeanMolecularWeight"->{
    Cell[332169, 12969, 261, 8, 16, "Index",
      CellTags->"MeanMolecularWeight"]},
  "MeanParticleSpeed"->{
    Cell[332433, 12979, 257, 8, 16, "Index",
      CellTags->"MeanParticleSpeed"]},
  "MeanPredictionCITable"->{
    Cell[332693, 12989, 513, 16, 32, "Index",
      CellTags->"MeanPredictionCITable"]},
  "MeanTest"->{
    Cell[333209, 13007, 227, 8, 16, "Index",
      CellTags->"MeanTest"]},
  "Median"->{
    Cell[333439, 13017, 238, 7, 16, "Index",
      CellTags->"Median"],
    Cell[333680, 13026, 397, 12, 16, "Index",
      CellTags->"Median"]},
  "MedianDeviation"->{
    Cell[334080, 13040, 416, 12, 32, "Index",
      CellTags->"MedianDeviation"]},
  "MedianMethod"->{
    Cell[334499, 13054, 421, 12, 32, "Index",
      CellTags->"MedianMethod"]},
  "MeltingPoint"->{
    Cell[334923, 13068, 243, 8, 16, "Index",
      CellTags->"MeltingPoint"]},
  "Memory management"->{
    Cell[335169, 13078, 219, 7, 16, "Index",
      CellTags->"Memory management"]},
  "MemoryConserve package"->{
    Cell[335391, 13087, 251, 8, 16, "Index",
      CellTags->"MemoryConserve package"]},
  "MeredithGraph"->{
    Cell[335645, 13097, 238, 8, 16, "Index",
      CellTags->"MeredithGraph"]},
  "mesh 3-Script command"->{
    Cell[335886, 13107, 249, 8, 16, "Index",
      CellTags->"mesh 3-Script command"]},
  "MeshRange"->{
    Cell[336138, 13117, 221, 8, 16, "Index",
      CellTags->"MeshRange"]},
  "Method"->{
    Cell[336362, 13127, 211, 8, 16, "Index",
      CellTags->"Method"]},
  "Microscope"->{
    Cell[336576, 13137, 363, 12, 16, "Index",
      CellTags->"Microscope"]},
  "Microscope package"->{
    Cell[336942, 13151, 395, 12, 16, "Index",
      CellTags->"Microscope package"]},
  "MicroscopicError"->{
    Cell[337340, 13165, 375, 12, 16, "Index",
      CellTags->"MicroscopicError"]},
  "MinCut"->{
    Cell[337718, 13179, 208, 7, 16, "Index",
      CellTags->"MinCut"]},
  "Minimax approximation"->{
    Cell[337929, 13188, 236, 7, 16, "Index",
      CellTags->"Minimax approximation"]},
  "MiniMaxApproximation"->{
    Cell[338168, 13197, 256, 8, 16, "Index",
      CellTags->"MiniMaxApproximation"]},
  "MinimumChainPartition"->{
    Cell[338427, 13207, 254, 8, 16, "Index",
      CellTags->"MinimumChainPartition"]},
  "MinimumChangePermutations"->{
    Cell[338684, 13217, 402, 12, 32, "Index",
      CellTags->"MinimumChangePermutations"]},
  "MinimumSpanningTree"->{
    Cell[339089, 13231, 391, 12, 16, "Index",
      CellTags->"MinimumSpanningTree"]},
  "MinimumVertexColoring"->{
    Cell[339483, 13245, 254, 8, 16, "Index",
      CellTags->"MinimumVertexColoring"]},
  "MinimumVertexCover"->{
    Cell[339740, 13255, 248, 8, 16, "Index",
      CellTags->"MinimumVertexCover"]},
  "MixedMode"->{
    Cell[339991, 13265, 242, 8, 16, "Index",
      CellTags->"MixedMode"]},
  "MKS"->{
    Cell[340236, 13275, 203, 8, 16, "Index",
      CellTags->"MKS"]},
  "MLE"->{
    Cell[340442, 13285, 230, 8, 16, "Index",
      CellTags->"MLE"]},
  "Mod"->{
    Cell[340675, 13295, 204, 8, 16, "Index",
      CellTags->"Mod"]},
  "Mode"->{
    Cell[340882, 13305, 393, 12, 16, "Index",
      CellTags->"Mode"]},
  "Modular equations"->{
    Cell[341278, 13319, 286, 9, 16, "Index",
      CellTags->"Modular equations"]},
  "Modulation"->{
    Cell[341567, 13330, 256, 9, 16, "Index",
      CellTags->"Modulation"],
    Cell[341826, 13341, 252, 9, 16, "IndexSubentry",
      CellTags->"Modulation"]},
  "ModulationType"->{
    Cell[342081, 13352, 353, 12, 16, "Index",
      CellTags->"ModulationType"]},
  "Modulus"->{
    Cell[342437, 13366, 225, 8, 16, "Index",
      CellTags->"Modulus"]},
  "MoebiusStrip"->{
    Cell[342665, 13376, 213, 8, 16, "Index",
      CellTags->"MoebiusStrip"]},
  "MolarGasConstant"->{
    Cell[342881, 13386, 253, 8, 16, "Index",
      CellTags->"MolarGasConstant"]},
  "MolarVolume"->{
    Cell[343137, 13396, 243, 8, 16, "Index",
      CellTags->"MolarVolume"]},
  "MovieContourPlot"->{
    Cell[343383, 13406, 227, 8, 16, "Index",
      CellTags->"MovieContourPlot"]},
  "MovieDensityPlot"->{
    Cell[343613, 13416, 227, 8, 16, "Index",
      CellTags->"MovieDensityPlot"]},
  "MovieParametricPlot"->{
    Cell[343843, 13426, 233, 8, 16, "Index",
      CellTags->"MovieParametricPlot"]},
  "MoviePlot"->{
    Cell[344079, 13436, 213, 8, 16, "Index",
      CellTags->"MoviePlot"]},
  "MoviePlot3D"->{
    Cell[344295, 13446, 217, 8, 16, "Index",
      CellTags->"MoviePlot3D"]},
  "MovingAverage"->{
    Cell[344515, 13456, 233, 8, 16, "Index",
      CellTags->"MovingAverage"]},
  "MovingMedian"->{
    Cell[344751, 13466, 231, 8, 16, "Index",
      CellTags->"MovingMedian"]},
  "MultiDescriptiveStatistics package"->{
    Cell[344985, 13476, 301, 8, 16, "Index",
      CellTags->"MultiDescriptiveStatistics package"]},
  "MultiDiscreteDistributions package"->{
    Cell[345289, 13486, 301, 8, 16, "Index",
      CellTags->"MultiDiscreteDistributions package"]},
  "Multinomial"->{
    Cell[345593, 13496, 251, 8, 16, "Index",
      CellTags->"Multinomial"]},
  "MultinomialDistribution"->{
    Cell[345847, 13506, 279, 8, 16, "Index",
      CellTags->"MultinomialDistribution"]},
  "MultinormalDistribution"->{
    Cell[346129, 13516, 273, 8, 16, "Index",
      CellTags->"MultinormalDistribution"]},
  "MultinormalDistribution package"->{
    Cell[346405, 13526, 451, 12, 32, "Index",
      CellTags->"MultinormalDistribution package"]},
  "Multiple curves"->{
    Cell[346859, 13540, 219, 7, 16, "Index",
      CellTags->"Multiple curves"]},
  "Multiple-valued functions"->{
    Cell[347081, 13549, 220, 7, 16, "Index",
      CellTags->"Multiple-valued functions"]},
  "MultipleEdgesQ"->{
    Cell[347304, 13558, 240, 8, 16, "Index",
      CellTags->"MultipleEdgesQ"]},
  "MultipleListPlot"->{
    Cell[347547, 13568, 241, 8, 16, "Index",
      CellTags->"MultipleListPlot"]},
  "MultipleListPlot package"->{
    Cell[347791, 13578, 257, 8, 16, "Index",
      CellTags->"MultipleListPlot package"]},
  "Multiplication"->{
    Cell[348051, 13588, 219, 7, 16, "Index",
      CellTags->"Multiplication"]},
  "MultiplicationTable"->{
    Cell[348273, 13597, 250, 8, 16, "Index",
      CellTags->"MultiplicationTable"]},
  "MultiPoissonDistribution"->{
    Cell[348526, 13607, 281, 8, 16, "Index",
      CellTags->"MultiPoissonDistribution"]},
  "Multivariate statistical distributions"->{
    Cell[348810, 13617, 443, 11, 32, "Index",
      CellTags->"Multivariate statistical distributions"]},
  "MultivariateKurtosis"->{
    Cell[349256, 13630, 594, 16, 48, "Index",
      CellTags->"MultivariateKurtosis"]},
  "MultivariateKurtosisExcess"->{
    Cell[349853, 13648, 286, 8, 16, "Index",
      CellTags->"MultivariateKurtosisExcess"]},
  "MultivariateMeanDeviation"->{
    Cell[350142, 13658, 284, 8, 16, "Index",
      CellTags->"MultivariateMeanDeviation"]},
  "MultivariateMedianDeviation"->{
    Cell[350429, 13668, 288, 8, 16, "Index",
      CellTags->"MultivariateMedianDeviation"]},
  "MultivariateMode"->{
    Cell[350720, 13678, 266, 8, 16, "Index",
      CellTags->"MultivariateMode"]},
  "MultivariatePearsonSkewness1"->{
    Cell[350989, 13688, 290, 8, 16, "Index",
      CellTags->"MultivariatePearsonSkewness1"]},
  "MultivariatePearsonSkewness2"->{
    Cell[351282, 13698, 290, 8, 16, "Index",
      CellTags->"MultivariatePearsonSkewness2"]},
  "MultivariateSkewness"->{
    Cell[351575, 13708, 594, 16, 48, "Index",
      CellTags->"MultivariateSkewness"]},
  "MultivariateTDistribution"->{
    Cell[352172, 13726, 277, 8, 16, "Index",
      CellTags->"MultivariateTDistribution"]},
  "MultivariateTrimmedMean"->{
    Cell[352452, 13736, 280, 8, 16, "Index",
      CellTags->"MultivariateTrimmedMean"]},
  "MuonGFactor"->{
    Cell[352735, 13746, 243, 8, 16, "Index",
      CellTags->"MuonGFactor"]},
  "MuonMagneticMoment"->{
    Cell[352981, 13756, 257, 8, 16, "Index",
      CellTags->"MuonMagneticMoment"]},
  "MuonMass"->{
    Cell[353241, 13766, 237, 8, 16, "Index",
      CellTags->"MuonMass"]},
  "Music package"->{
    Cell[353481, 13776, 223, 8, 16, "Index",
      CellTags->"Music package"]},
  "MycielskiGraph"->{
    Cell[353707, 13786, 240, 8, 16, "Index",
      CellTags->"MycielskiGraph"]},
  "myPackage1.m example of package"->{
    Cell[353950, 13796, 240, 8, 16, "Index",
      CellTags->"myPackage1.m example of package"]},
  "Names"->{
    Cell[354389, 13815, 177, 7, 16, "Index",
      CellTags->"Names"],
    Cell[354569, 13824, 446, 17, 48, "IndexSubentry",
      CellTags->"Names"]},
  "Names files"->{
    Cell[355018, 13843, 283, 11, 16, "Index",
      CellTags->"Names files"]},
  "NaN"->{
    Cell[355304, 13856, 229, 8, 16, "Index",
      CellTags->"NaN"]},
  "ND"->{
    Cell[355536, 13866, 204, 8, 16, "Index",
      CellTags->"ND"]},
  "NDTFourierTransform"->{
    Cell[355743, 13876, 248, 8, 16, "Index",
      CellTags->"NDTFourierTransform"]},
  "NearestNeighbor"->{
    Cell[355994, 13886, 258, 8, 16, "Index",
      CellTags->"NearestNeighbor"]},
  "NecklacePolynomial"->{
    Cell[356255, 13896, 248, 8, 16, "Index",
      CellTags->"NecklacePolynomial"]},
  "Needs"->{
    Cell[356506, 13906, 187, 8, 16, "Index",
      CellTags->"Needs"]},
  "NegativeBinomialDistribution"->{
    Cell[356696, 13916, 279, 8, 16, "Index",
      CellTags->"NegativeBinomialDistribution"]},
  "NegativeMultinomialDistribution"->{
    Cell[356978, 13926, 295, 8, 16, "Index",
      CellTags->"NegativeMultinomialDistribution"]},
  "Neighborhood"->{
    Cell[357276, 13936, 236, 8, 16, "Index",
      CellTags->"Neighborhood"]},
  "Neighborhood polygons"->{
    Cell[357515, 13946, 304, 9, 16, "Index",
      CellTags->"Neighborhood polygons"]},
  "NetworkFlow"->{
    Cell[357822, 13957, 375, 12, 16, "Index",
      CellTags->"NetworkFlow"]},
  "NeutronComptonWavelength"->{
    Cell[358200, 13971, 269, 8, 16, "Index",
      CellTags->"NeutronComptonWavelength"]},
  "NeutronMagneticMoment"->{
    Cell[358472, 13981, 263, 8, 16, "Index",
      CellTags->"NeutronMagneticMoment"]},
  "NeutronMass"->{
    Cell[358738, 13991, 243, 8, 16, "Index",
      CellTags->"NeutronMass"]},
  "Newton-Cotes quadrature"->{
    Cell[358984, 14001, 241, 7, 16, "Index",
      CellTags->"Newton-Cotes quadrature"]},
  "NewtonCotes package"->{
    Cell[359228, 14010, 247, 8, 16, "Index",
      CellTags->"NewtonCotes package"]},
  "NewtonCotesError"->{
    Cell[359478, 14020, 241, 8, 16, "Index",
      CellTags->"NewtonCotesError"]},
  "NewtonCotesWeights"->{
    Cell[359722, 14030, 245, 8, 16, "Index",
      CellTags->"NewtonCotesWeights"]},
  "NextBinarySubset"->{
    Cell[359970, 14040, 244, 8, 16, "Index",
      CellTags->"NextBinarySubset"]},
  "NextComposition"->{
    Cell[360217, 14050, 242, 8, 16, "Index",
      CellTags->"NextComposition"]},
  "NextGrayCodeSubset"->{
    Cell[360462, 14060, 248, 8, 16, "Index",
      CellTags->"NextGrayCodeSubset"]},
  "NextKSubset"->{
    Cell[360713, 14070, 234, 8, 16, "Index",
      CellTags->"NextKSubset"]},
  "NextLexicographicSubset"->{
    Cell[360950, 14080, 258, 8, 16, "Index",
      CellTags->"NextLexicographicSubset"]},
  "NextPartition"->{
    Cell[361211, 14090, 238, 8, 16, "Index",
      CellTags->"NextPartition"]},
  "NextPermutation"->{
    Cell[361452, 14100, 242, 8, 16, "Index",
      CellTags->"NextPermutation"]},
  "NextPrime"->{
    Cell[361697, 14110, 245, 8, 16, "Index",
      CellTags->"NextPrime"]},
  "NextSubset"->{
    Cell[361945, 14120, 232, 8, 16, "Index",
      CellTags->"NextSubset"]},
  "NextTableau"->{
    Cell[362180, 14130, 234, 8, 16, "Index",
      CellTags->"NextTableau"]},
  "NFourierCoefficient"->{
    Cell[362417, 14140, 387, 12, 16, "Index",
      CellTags->"NFourierCoefficient"]},
  "NFourierCosCoefficient"->{
    Cell[362807, 14154, 254, 8, 16, "Index",
      CellTags->"NFourierCosCoefficient"]},
  "NFourierCosTransform"->{
    Cell[363064, 14164, 249, 8, 16, "Index",
      CellTags->"NFourierCosTransform"]},
  "NFourierSeries"->{
    Cell[363316, 14174, 238, 8, 16, "Index",
      CellTags->"NFourierSeries"]},
  "NFourierSinCoefficient"->{
    Cell[363557, 14184, 254, 8, 16, "Index",
      CellTags->"NFourierSinCoefficient"]},
  "NFourierSinTransform"->{
    Cell[363814, 14194, 249, 8, 16, "Index",
      CellTags->"NFourierSinTransform"]},
  "NFourierTransform"->{
    Cell[364066, 14204, 243, 8, 16, "Index",
      CellTags->"NFourierTransform"]},
  "NFourierTrigSeries"->{
    Cell[364312, 14214, 246, 8, 16, "Index",
      CellTags->"NFourierTrigSeries"]},
  "NIntegrate"->{
    Cell[364561, 14224, 292, 9, 16, "Index",
      CellTags->"NIntegrate"],
    Cell[364856, 14235, 679, 20, 32, "Index",
      CellTags->"NIntegrate"]},
  "NIntegrateInterpolatingFunct package"->{
    Cell[365538, 14257, 315, 8, 16, "Index",
      CellTags->"NIntegrateInterpolatingFunct package"]},
  "NIntegrateInterpolatingFunction"->{
    Cell[365856, 14267, 305, 8, 16, "Index",
      CellTags->"NIntegrateInterpolatingFunction"]},
  "NInverseDTFourierTransform"->{
    Cell[366164, 14277, 262, 8, 16, "Index",
      CellTags->"NInverseDTFourierTransform"]},
  "NInverseFourierCoefficient"->{
    Cell[366429, 14287, 262, 8, 16, "Index",
      CellTags->"NInverseFourierCoefficient"]},
  "NInverseFourierCosTransform"->{
    Cell[366694, 14297, 263, 8, 16, "Index",
      CellTags->"NInverseFourierCosTransform"]},
  "NInverseFourierSinTransform"->{
    Cell[366960, 14307, 263, 8, 16, "Index",
      CellTags->"NInverseFourierSinTransform"]},
  "NInverseFourierTransform"->{
    Cell[367226, 14317, 257, 8, 16, "Index",
      CellTags->"NInverseFourierTransform"]},
  "NLimit"->{
    Cell[367486, 14327, 211, 8, 16, "Index",
      CellTags->"NLimit"]},
  "NLimit package"->{
    Cell[367700, 14337, 227, 8, 16, "Index",
      CellTags->"NLimit package"]},
  "NMinimize package"->{
    Cell[367930, 14347, 236, 8, 16, "Index",
      CellTags->"NMinimize package"]},
  "Nodes"->{
    Cell[368169, 14357, 191, 7, 16, "Index",
      CellTags->"Nodes"]},
  "NoMultipleEdges"->{
    Cell[368363, 14366, 242, 8, 16, "Index",
      CellTags->"NoMultipleEdges"]},
  "Nonagon"->{
    Cell[368608, 14376, 209, 8, 16, "Index",
      CellTags->"Nonagon"]},
  "NoncentralChiSquareDistribution"->{
    Cell[368820, 14386, 290, 8, 16, "Index",
      CellTags->"NoncentralChiSquareDistribution"]},
  "NoncentralFRatioDistribution"->{
    Cell[369113, 14396, 284, 8, 16, "Index",
      CellTags->"NoncentralFRatioDistribution"]},
  "NoncentralStudentTDistribution"->{
    Cell[369400, 14406, 288, 8, 16, "Index",
      CellTags->"NoncentralStudentTDistribution"]},
  "Nonlinear regression"->{
    Cell[369691, 14416, 223, 7, 16, "Index",
      CellTags->"Nonlinear regression"]},
  "NonlinearFit"->{
    Cell[369917, 14425, 229, 8, 16, "Index",
      CellTags->"NonlinearFit"]},
  "NonlinearFit package"->{
    Cell[370149, 14435, 376, 12, 32, "Index",
      CellTags->"NonlinearFit package"]},
  "NonlinearRegress"->{
    Cell[370528, 14449, 237, 8, 16, "Index",
      CellTags->"NonlinearRegress"]},
  "NonLineGraphs"->{
    Cell[370768, 14459, 238, 8, 16, "Index",
      CellTags->"NonLineGraphs"]},
  "Nonreal"->{
    Cell[371009, 14469, 217, 8, 16, "Index",
      CellTags->"Nonreal"]},
  "NoPerfectMatchingGraph"->{
    Cell[371229, 14479, 256, 8, 16, "Index",
      CellTags->"NoPerfectMatchingGraph"]},
  "Norm"->{
    Cell[371488, 14489, 206, 8, 16, "Index",
      CellTags->"Norm"]},
  "Normal"->{
    Cell[371697, 14499, 525, 16, 32, "Index",
      CellTags->"Normal"]},
  "NormalCI"->{
    Cell[372225, 14517, 236, 8, 16, "Index",
      CellTags->"NormalCI"]},
  "NormalDashed"->{
    Cell[372464, 14527, 236, 8, 16, "Index",
      CellTags->"NormalDashed"]},
  "NormalDistribution"->{
    Cell[372703, 14537, 409, 12, 32, "Index",
      CellTags->"NormalDistribution"]},
  "NormalDistribution package"->{
    Cell[373115, 14551, 425, 12, 32, "Index",
      CellTags->"NormalDistribution package"]},
  "Normalize"->{
    Cell[373543, 14565, 389, 12, 16, "Index",
      CellTags->"Normalize"]},
  "Normalized"->{
    Cell[373935, 14579, 241, 8, 16, "Index",
      CellTags->"Normalized"]},
  "NormalizeVertices"->{
    Cell[374179, 14589, 246, 8, 16, "Index",
      CellTags->"NormalizeVertices"]},
  "NormalPValue"->{
    Cell[374428, 14599, 236, 8, 16, "Index",
      CellTags->"NormalPValue"]},
  "NoSelfLoops"->{
    Cell[374667, 14609, 234, 8, 16, "Index",
      CellTags->"NoSelfLoops"]},
  "Not-a-Number"->{
    Cell[374904, 14619, 274, 9, 16, "Index",
      CellTags->"Not-a-Number"]},
  "NResidue"->{
    Cell[375181, 14630, 197, 7, 16, "Index",
      CellTags->"NResidue"],
    Cell[375381, 14639, 219, 8, 16, "Index",
      CellTags->"NResidue"]},
  "NResidue package"->{
    Cell[375603, 14649, 235, 8, 16, "Index",
      CellTags->"NResidue package"]},
  "NSeries"->{
    Cell[375841, 14659, 215, 8, 16, "Index",
      CellTags->"NSeries"]},
  "NSeries package"->{
    Cell[376059, 14669, 231, 8, 16, "Index",
      CellTags->"NSeries package"]},
  "NSum"->{
    Cell[376293, 14679, 207, 8, 16, "Index",
      CellTags->"NSum"]},
  "NthSubset"->{
    Cell[376503, 14689, 230, 8, 16, "Index",
      CellTags->"NthSubset"]},
  "Null hypothesis"->{
    Cell[376736, 14699, 219, 7, 16, "Index",
      CellTags->"Null hypothesis"]},
  "Number system"->{
    Cell[376958, 14708, 220, 7, 16, "Index",
      CellTags->"Number system"]},
  "NumberDensity"->{
    Cell[377181, 14717, 249, 8, 16, "Index",
      CellTags->"NumberDensity"]},
  "NumberOf2Paths"->{
    Cell[377433, 14727, 240, 8, 16, "Index",
      CellTags->"NumberOf2Paths"]},
  "NumberOfCompositions"->{
    Cell[377676, 14737, 252, 8, 16, "Index",
      CellTags->"NumberOfCompositions"]},
  "NumberOfDerangements"->{
    Cell[377931, 14747, 252, 8, 16, "Index",
      CellTags->"NumberOfDerangements"]},
  "NumberOfDirectedGraphs"->{
    Cell[378186, 14757, 256, 8, 16, "Index",
      CellTags->"NumberOfDirectedGraphs"]},
  "NumberOfEdges"->{
    Cell[378445, 14767, 345, 12, 16, "Index",
      CellTags->"NumberOfEdges"]},
  "NumberOfFaces"->{
    Cell[378793, 14781, 345, 12, 16, "Index",
      CellTags->"NumberOfFaces"]},
  "NumberOfGraphs"->{
    Cell[379141, 14795, 240, 8, 16, "Index",
      CellTags->"NumberOfGraphs"]},
  "NumberOfInvolutions"->{
    Cell[379384, 14805, 250, 8, 16, "Index",
      CellTags->"NumberOfInvolutions"]},
  "NumberOfKPaths"->{
    Cell[379637, 14815, 240, 8, 16, "Index",
      CellTags->"NumberOfKPaths"]},
  "NumberOfNecklaces"->{
    Cell[379880, 14825, 246, 8, 16, "Index",
      CellTags->"NumberOfNecklaces"]},
  "NumberOfPartitions"->{
    Cell[380129, 14835, 248, 8, 16, "Index",
      CellTags->"NumberOfPartitions"]},
  "NumberOfPermutationsByCycles"->{
    Cell[380380, 14845, 268, 8, 16, "Index",
      CellTags->"NumberOfPermutationsByCycles"]},
  "NumberOfPermutationsByInversions"->{
    Cell[380651, 14855, 276, 8, 16, "Index",
      CellTags->"NumberOfPermutationsByInversions"]},
  "NumberOfPermutationsByType"->{
    Cell[380930, 14865, 264, 8, 16, "Index",
      CellTags->"NumberOfPermutationsByType"]},
  "NumberOfSpanningTrees"->{
    Cell[381197, 14875, 395, 12, 16, "Index",
      CellTags->"NumberOfSpanningTrees"]},
  "NumberOfTableaux"->{
    Cell[381595, 14889, 385, 12, 16, "Index",
      CellTags->"NumberOfTableaux"]},
  "NumberOfVertices"->{
    Cell[381983, 14903, 351, 12, 16, "Index",
      CellTags->"NumberOfVertices"]},
  "Numbers"->{
    Cell[382337, 14917, 335, 11, 16, "Index",
      CellTags->"Numbers"]},
  "NumberTheoryFunctions package"->{
    Cell[382675, 14930, 432, 12, 32, "Index",
      CellTags->"NumberTheoryFunctions package"]},
  "Numerical Fourier functions"->{
    Cell[383110, 14944, 380, 11, 16, "Index",
      CellTags->"Numerical Fourier functions"]},
  "Numerical Fourier transforms"->{
    Cell[383493, 14957, 243, 7, 16, "Index",
      CellTags->"Numerical Fourier transforms"]},
  "OblateSpheroidal"->{
    Cell[383957, 14975, 237, 8, 16, "Index",
      CellTags->"OblateSpheroidal"]},
  "Octagon"->{
    Cell[384197, 14985, 209, 8, 16, "Index",
      CellTags->"Octagon"]},
  "OctahedralGraph"->{
    Cell[384409, 14995, 242, 8, 16, "Index",
      CellTags->"OctahedralGraph"]},
  "Octahedron"->{
    Cell[384654, 15005, 339, 12, 16, "Index",
      CellTags->"Octahedron"]},
  "OddGraph"->{
    Cell[384996, 15019, 228, 8, 16, "Index",
      CellTags->"OddGraph"]},
  "OddQ"->{
    Cell[385227, 15029, 206, 8, 16, "Index",
      CellTags->"OddQ"]},
  "One"->{
    Cell[385436, 15039, 218, 8, 16, "Index",
      CellTags->"One"]},
  "OpenTruncate"->{
    Cell[385657, 15049, 219, 8, 16, "Index",
      CellTags->"OpenTruncate"]},
  "Optimum"->{
    Cell[385879, 15059, 226, 8, 16, "Index",
      CellTags->"Optimum"]},
  "Options"->{
    Cell[386108, 15069, 251, 9, 16, "Index",
      CellTags->"Options"]},
  "OrbitInventory"->{
    Cell[386362, 15080, 240, 8, 16, "Index",
      CellTags->"OrbitInventory"]},
  "OrbitRepresentatives"->{
    Cell[386605, 15090, 252, 8, 16, "Index",
      CellTags->"OrbitRepresentatives"]},
  "Orbits"->{
    Cell[386860, 15100, 224, 8, 16, "Index",
      CellTags->"Orbits"]},
  "Order"->{
    Cell[387087, 15110, 249, 9, 16, "Index",
      CellTags->"Order"]},
  "Order conditions"->{
    Cell[387339, 15121, 288, 9, 16, "Index",
      CellTags->"Order conditions"]},
  "Ordered"->{
    Cell[387630, 15132, 226, 8, 16, "Index",
      CellTags->"Ordered"]},
  "OrderedSumOfSquaresRepresentations"->{
    Cell[387859, 15142, 296, 8, 16, "Index",
      CellTags->"OrderedSumOfSquaresRepresentations"]},
  "OrderStar"->{
    Cell[388158, 15152, 223, 8, 16, "Index",
      CellTags->"OrderStar"]},
  "OrderStar package"->{
    Cell[388384, 15162, 239, 8, 16, "Index",
      CellTags->"OrderStar package"]},
  "OrderStarInterpolation"->{
    Cell[388626, 15172, 250, 8, 16, "Index",
      CellTags->"OrderStarInterpolation"]},
  "OrderStarKind"->{
    Cell[388879, 15182, 232, 8, 16, "Index",
      CellTags->"OrderStarKind"]},
  "OrderStarLegend"->{
    Cell[389114, 15192, 236, 8, 16, "Index",
      CellTags->"OrderStarLegend"]},
  "OrderStarPoles"->{
    Cell[389353, 15202, 234, 8, 16, "Index",
      CellTags->"OrderStarPoles"]},
  "OrderStarSubPlots"->{
    Cell[389590, 15212, 240, 8, 16, "Index",
      CellTags->"OrderStarSubPlots"]},
  "OrderStarSymbolSize"->{
    Cell[389833, 15222, 244, 8, 16, "Index",
      CellTags->"OrderStarSymbolSize"]},
  "OrderStarSymbolThickness"->{
    Cell[390080, 15232, 254, 8, 16, "Index",
      CellTags->"OrderStarSymbolThickness"]},
  "OrderStarZeros"->{
    Cell[390337, 15242, 234, 8, 16, "Index",
      CellTags->"OrderStarZeros"]},
  "Ordinary differential equations"->{
    Cell[390574, 15252, 252, 7, 16, "Index",
      CellTags->"Ordinary differential equations"]},
  "Organization"->{
    Cell[390829, 15261, 211, 7, 16, "Index",
      CellTags->"Organization"]},
  "OrientGraph"->{
    Cell[391043, 15270, 375, 12, 16, "Index",
      CellTags->"OrientGraph"]},
  "Orthogonal basis"->{
    Cell[391421, 15284, 272, 9, 16, "Index",
      CellTags->"Orthogonal basis"]},
  "Orthogonal coordinates"->{
    Cell[391696, 15295, 227, 7, 16, "Index",
      CellTags->"Orthogonal coordinates"]},
  "Orthogonalization package"->{
    Cell[391926, 15304, 271, 8, 16, "Index",
      CellTags->"Orthogonalization package"]},
  "Orthonormal basis"->{
    Cell[392200, 15314, 274, 9, 16, "Index",
      CellTags->"Orthonormal basis"],
    Cell[392477, 15325, 258, 8, 16, "IndexSubentry",
      CellTags->"Orthonormal basis"]},
  "OscillatorStrength"->{
    Cell[392738, 15335, 271, 8, 16, "Index",
      CellTags->"OscillatorStrength"]},
  "OutDegree"->{
    Cell[393012, 15345, 230, 8, 16, "Index",
      CellTags->"OutDegree"]},
  "Outlier detection"->{
    Cell[393245, 15355, 361, 11, 16, "Index",
      CellTags->"Outlier detection"]},
  "outliers"->{
    Cell[393609, 15368, 205, 7, 16, "Index",
      CellTags->"outliers"]},
  "Package package"->{
    Cell[394010, 15386, 223, 8, 16, "Index",
      CellTags->"Package package"]},
  "Packages"->{
    Cell[394236, 15396, 300, 11, 16, "Index",
      CellTags->"Packages"],
    Cell[394539, 15409, 1560, 53, 144, "IndexSubentry",
      CellTags->"Packages"]},
  "Pade"->{
    Cell[396102, 15464, 307, 12, 16, "Index",
      CellTags->"Pade"]},
  "Pade approximation"->{
    Cell[396412, 15478, 241, 9, 16, "Index",
      CellTags->"Pade approximation"]},
  "Pade package"->{
    Cell[396656, 15489, 353, 12, 16, "Index",
      CellTags->"Pade package"]},
  "PairGroup"->{
    Cell[397012, 15503, 230, 8, 16, "Index",
      CellTags->"PairGroup"]},
  "PairGroupIndex"->{
    Cell[397245, 15513, 240, 8, 16, "Index",
      CellTags->"PairGroupIndex"]},
  "Pairs scatter plot"->{
    Cell[397488, 15523, 225, 7, 16, "Index",
      CellTags->"Pairs scatter plot"]},
  "pairs scatter plot"->{
    Cell[397716, 15532, 226, 7, 16, "Index",
      CellTags->"pairs scatter plot"]},
  "PairwiseScatterPlot"->{
    Cell[397945, 15541, 390, 12, 16, "Index",
      CellTags->"PairwiseScatterPlot"]},
  "ParabolicCylindrical"->{
    Cell[398338, 15555, 245, 8, 16, "Index",
      CellTags->"ParabolicCylindrical"]},
  "Paraboloidal"->{
    Cell[398586, 15565, 229, 8, 16, "Index",
      CellTags->"Paraboloidal"]},
  "Parallel"->{
    Cell[398818, 15575, 214, 8, 16, "Index",
      CellTags->"Parallel"]},
  "ParameterBias"->{
    Cell[399035, 15585, 232, 8, 16, "Index",
      CellTags->"ParameterBias"]},
  "ParameterCITable"->{
    Cell[399270, 15595, 503, 16, 32, "Index",
      CellTags->"ParameterCITable"]},
  "ParameterConfidenceRegion"->{
    Cell[399776, 15613, 386, 12, 16, "Index",
      CellTags->"ParameterConfidenceRegion"]},
  "ParameterQ"->{
    Cell[400165, 15627, 213, 8, 16, "Index",
      CellTags->"ParameterQ"]},
  "ParameterRanges"->{
    Cell[400381, 15637, 236, 8, 16, "Index",
      CellTags->"ParameterRanges"]},
  "Parameters"->{
    Cell[400620, 15647, 226, 8, 16, "Index",
      CellTags->"Parameters"]},
  "Parameters of complete integrals"->{
    Cell[400849, 15657, 249, 7, 16, "Index",
      CellTags->"Parameters of complete integrals"]},
  "ParameterTable"->{
    Cell[401101, 15666, 499, 16, 32, "Index",
      CellTags->"ParameterTable"]},
  "ParametricPlot"->{
    Cell[401603, 15684, 221, 8, 16, "Index",
      CellTags->"ParametricPlot"]},
  "ParametricPlot3D"->{
    Cell[401827, 15694, 367, 12, 16, "Index",
      CellTags->"ParametricPlot3D"]},
  "ParametricPlot3D package"->{
    Cell[402197, 15708, 257, 8, 16, "Index",
      CellTags->"ParametricPlot3D package"]},
  "Parent"->{
    Cell[402457, 15718, 224, 8, 16, "Index",
      CellTags->"Parent"]},
  "ParentsToPaths"->{
    Cell[402684, 15728, 240, 8, 16, "Index",
      CellTags->"ParentsToPaths"]},
  "ParetoDistribution"->{
    Cell[402927, 15738, 263, 8, 16, "Index",
      CellTags->"ParetoDistribution"]},
  "ParetoPlot"->{
    Cell[403193, 15748, 372, 12, 16, "Index",
      CellTags->"ParetoPlot"]},
  "Partial derivatives"->{
    Cell[403568, 15762, 349, 11, 16, "Index",
      CellTags->"Partial derivatives"]},
  "Partial differential equations"->{
    Cell[403920, 15775, 245, 7, 16, "Index",
      CellTags->"Partial differential equations"]},
  "PartialOrderQ"->{
    Cell[404168, 15784, 379, 12, 16, "Index",
      CellTags->"PartialOrderQ"]},
  "PartialSumOfSquares"->{
    Cell[404550, 15798, 374, 12, 16, "Index",
      CellTags->"PartialSumOfSquares"]},
  "PartitionLattice"->{
    Cell[404927, 15812, 244, 8, 16, "Index",
      CellTags->"PartitionLattice"]},
  "PartitionQ"->{
    Cell[405174, 15822, 232, 8, 16, "Index",
      CellTags->"PartitionQ"]},
  "Partitions"->{
    Cell[405409, 15832, 210, 7, 16, "Index",
      CellTags->"Partitions"],
    Cell[405622, 15841, 263, 9, 16, "IndexSubentry",
      CellTags->"Partitions"],
    Cell[405888, 15852, 373, 12, 16, "Index",
      CellTags->"Partitions"]},
  "Path"->{
    Cell[406264, 15866, 361, 12, 16, "Index",
      CellTags->"Path"]},
  "PDF"->{
    Cell[406628, 15880, 973, 28, 64, "Index",
      CellTags->"PDF"]},
  "PeakWavelength"->{
    Cell[407604, 15910, 251, 8, 16, "Index",
      CellTags->"PeakWavelength"]},
  "PearsonSkewness1"->{
    Cell[407858, 15920, 419, 12, 32, "Index",
      CellTags->"PearsonSkewness1"]},
  "PearsonSkewness2"->{
    Cell[408280, 15934, 419, 12, 32, "Index",
      CellTags->"PearsonSkewness2"]},
  "Pentagon"->{
    Cell[408702, 15948, 211, 8, 16, "Index",
      CellTags->"Pentagon"]},
  "PercentileBarChart"->{
    Cell[408916, 15958, 229, 8, 16, "Index",
      CellTags->"PercentileBarChart"]},
  "PerfectQ"->{
    Cell[409148, 15968, 228, 8, 16, "Index",
      CellTags->"PerfectQ"]},
  "PeriodicForm"->{
    Cell[409379, 15978, 246, 8, 16, "Index",
      CellTags->"PeriodicForm"]},
  "PermutationGraph"->{
    Cell[409628, 15988, 244, 8, 16, "Index",
      CellTags->"PermutationGraph"]},
  "PermutationGroupQ"->{
    Cell[409875, 15998, 246, 8, 16, "Index",
      CellTags->"PermutationGroupQ"]},
  "PermutationQ"->{
    Cell[410124, 16008, 236, 8, 16, "Index",
      CellTags->"PermutationQ"]},
  "Permutations"->{
    Cell[410363, 16018, 230, 7, 16, "Index",
      CellTags->"Permutations"],
    Cell[410596, 16027, 640, 19, 48, "IndexSubentry",
      CellTags->"Permutations"],
    Cell[411239, 16048, 235, 8, 16, "Index",
      CellTags->"Permutations"]},
  "PermutationToTableaux"->{
    Cell[411477, 16058, 254, 8, 16, "Index",
      CellTags->"PermutationToTableaux"]},
  "PermutationType"->{
    Cell[411734, 16068, 242, 8, 16, "Index",
      CellTags->"PermutationType"]},
  "PermutationWithCycle"->{
    Cell[411979, 16078, 252, 8, 16, "Index",
      CellTags->"PermutationWithCycle"]},
  "Permute"->{
    Cell[412234, 16088, 226, 8, 16, "Index",
      CellTags->"Permute"]},
  "PermuteSubgraph"->{
    Cell[412463, 16098, 242, 8, 16, "Index",
      CellTags->"PermuteSubgraph"]},
  "PetersenGraph"->{
    Cell[412708, 16108, 238, 8, 16, "Index",
      CellTags->"PetersenGraph"]},
  "Phase-gratings"->{
    Cell[412949, 16118, 189, 7, 16, "Index",
      CellTags->"Phase-gratings"]},
  "Phi"->{
    Cell[413141, 16127, 243, 9, 16, "Index",
      CellTags->"Phi"]},
  "PhysicalConstants package"->{
    Cell[413387, 16138, 271, 8, 16, "Index",
      CellTags->"PhysicalConstants package"]},
  "PieChart"->{
    Cell[413661, 16148, 210, 8, 16, "Index",
      CellTags->"PieChart"]},
  "PieExploded"->{
    Cell[413874, 16158, 216, 8, 16, "Index",
      CellTags->"PieExploded"]},
  "PieLabels"->{
    Cell[414093, 16168, 212, 8, 16, "Index",
      CellTags->"PieLabels"]},
  "PieLineStyle"->{
    Cell[414308, 16178, 218, 8, 16, "Index",
      CellTags->"PieLineStyle"]},
  "PieStyle"->{
    Cell[414529, 16188, 210, 8, 16, "Index",
      CellTags->"PieStyle"]},
  "Pitch/frequency equivalents"->{
    Cell[414742, 16198, 230, 7, 16, "Index",
      CellTags->"Pitch/frequency equivalents"]},
  "Planar data"->{
    Cell[414975, 16207, 240, 7, 16, "Index",
      CellTags->"Planar data"]},
  "PlanarGraphPlot"->{
    Cell[415218, 16216, 415, 12, 32, "Index",
      CellTags->"PlanarGraphPlot"]},
  "PlanarQ"->{
    Cell[415636, 16230, 226, 8, 16, "Index",
      CellTags->"PlanarQ"]},
  "PlanckConstant"->{
    Cell[415865, 16240, 249, 8, 16, "Index",
      CellTags->"PlanckConstant"]},
  "PlanckConstantReduced"->{
    Cell[416117, 16250, 263, 8, 16, "Index",
      CellTags->"PlanckConstantReduced"]},
  "PlanckMass"->{
    Cell[416383, 16260, 241, 8, 16, "Index",
      CellTags->"PlanckMass"]},
  "PlayRange"->{
    Cell[416627, 16270, 216, 8, 16, "Index",
      CellTags->"PlayRange"]},
  "Plot"->{
    Cell[416846, 16280, 201, 8, 16, "Index",
      CellTags->"Plot"]},
  "Plot3D"->{
    Cell[417050, 16290, 209, 8, 16, "Index",
      CellTags->"Plot3D"],
    Cell[417262, 16300, 244, 9, 16, "IndexSubentry",
      CellTags->"Plot3D"]},
  "PlotField package"->{
    Cell[417509, 16311, 229, 8, 16, "Index",
      CellTags->"PlotField package"]},
  "PlotField3D package"->{
    Cell[417741, 16321, 237, 8, 16, "Index",
      CellTags->"PlotField3D package"]},
  "PlotFlag"->{
    Cell[417981, 16331, 232, 8, 16, "Index",
      CellTags->"PlotFlag"]},
  "PlotGradientField"->{
    Cell[418216, 16341, 229, 8, 16, "Index",
      CellTags->"PlotGradientField"]},
  "PlotGradientField3D"->{
    Cell[418448, 16351, 237, 8, 16, "Index",
      CellTags->"PlotGradientField3D"]},
  "PlotHamiltonianField"->{
    Cell[418688, 16361, 235, 8, 16, "Index",
      CellTags->"PlotHamiltonianField"]},
  "PlotJoined"->{
    Cell[418926, 16371, 509, 16, 32, "Index",
      CellTags->"PlotJoined"]},
  "PlotLegend"->{
    Cell[419438, 16389, 347, 12, 16, "Index",
      CellTags->"PlotLegend"]},
  "PlotPoints"->{
    Cell[419788, 16403, 475, 16, 16, "Index",
      CellTags->"PlotPoints"]},
  "PlotPolyaField"->{
    Cell[420266, 16421, 224, 8, 16, "Index",
      CellTags->"PlotPolyaField"]},
  "PlotRange"->{
    Cell[420493, 16431, 230, 8, 16, "Index",
      CellTags->"PlotRange"]},
  "Plots"->{
    Cell[420726, 16441, 235, 9, 16, "Index",
      CellTags->"Plots"],
    Cell[420964, 16452, 6655, 191, 560, "IndexSubentry",
      CellTags->"Plots"]},
  "PlotStyle"->{
    Cell[427622, 16645, 371, 12, 16, "Index",
      CellTags->"PlotStyle"]},
  "PlotSymbol"->{
    Cell[427996, 16659, 230, 8, 16, "Index",
      CellTags->"PlotSymbol"]},
  "Plotting symbols"->{
    Cell[428229, 16669, 249, 9, 16, "Index",
      CellTags->"Plotting symbols"],
    Cell[428481, 16680, 415, 14, 32, "IndexSubentry",
      CellTags->"Plotting symbols"]},
  "PlotVectorField"->{
    Cell[428899, 16696, 225, 8, 16, "Index",
      CellTags->"PlotVectorField"]},
  "PlotVectorField3D"->{
    Cell[429127, 16706, 233, 8, 16, "Index",
      CellTags->"PlotVectorField3D"]},
  "Pochhammer"->{
    Cell[429363, 16716, 249, 8, 16, "Index",
      CellTags->"Pochhammer"]},
  "point 3-Script command"->{
    Cell[429615, 16726, 251, 8, 16, "Index",
      CellTags->"point 3-Script command"]},
  "Point neighborhood"->{
    Cell[429869, 16736, 241, 7, 16, "Index",
      CellTags->"Point neighborhood"]},
  "PointParametricPlot3D"->{
    Cell[430113, 16745, 251, 8, 16, "Index",
      CellTags->"PointParametricPlot3D"]},
  "Points"->{
    Cell[430367, 16755, 296, 9, 16, "Index",
      CellTags->"Points"],
    Cell[430666, 16766, 522, 15, 48, "IndexSubentry",
      CellTags->"Points"]},
  "PoissonDistribution"->{
    Cell[431191, 16783, 261, 8, 16, "Index",
      CellTags->"PoissonDistribution"]},
  "PolarDecomposition"->{
    Cell[431455, 16793, 238, 7, 16, "Index",
      CellTags->"PolarDecomposition"],
    Cell[431696, 16802, 260, 8, 16, "Index",
      CellTags->"PolarDecomposition"]},
  "PolarListPlot"->{
    Cell[431959, 16812, 219, 8, 16, "Index",
      CellTags->"PolarListPlot"]},
  "PolarMap"->{
    Cell[432181, 16822, 213, 8, 16, "Index",
      CellTags->"PolarMap"]},
  "PolarPlot"->{
    Cell[432397, 16832, 211, 8, 16, "Index",
      CellTags->"PolarPlot"]},
  "PollardPTest"->{
    Cell[432611, 16842, 222, 8, 16, "Index",
      CellTags->"PollardPTest"]},
  "PollardRhoTest"->{
    Cell[432836, 16852, 226, 8, 16, "Index",
      CellTags->"PollardRhoTest"]},
  "Polya"->{
    Cell[433065, 16862, 222, 8, 16, "Index",
      CellTags->"Polya"]},
  "Polya representation"->{
    Cell[433290, 16872, 268, 9, 16, "Index",
      CellTags->"Polya representation"]},
  "Polya theory"->{
    Cell[433561, 16883, 214, 7, 16, "Index",
      CellTags->"Polya theory"]},
  "Polygon"->{
    Cell[433778, 16892, 203, 8, 16, "Index",
      CellTags->"Polygon"]},
  "polygon 3-Script command"->{
    Cell[433984, 16902, 255, 8, 16, "Index",
      CellTags->"polygon 3-Script command"]},
  "Polygons"->{
    Cell[434242, 16912, 198, 7, 16, "Index",
      CellTags->"Polygons"],
    Cell[434443, 16921, 420, 13, 32, "IndexSubentry",
      CellTags->"Polygons"]},
  "Polyhedra package"->{
    Cell[434866, 16936, 229, 8, 16, "Index",
      CellTags->"Polyhedra package"]},
  "Polyhedron"->{
    Cell[435098, 16946, 215, 8, 16, "Index",
      CellTags->"Polyhedron"]},
  "Polyhedrons"->{
    Cell[435316, 16956, 239, 9, 16, "Index",
      CellTags->"Polyhedrons"]},
  "Polynomial approximation"->{
    Cell[435558, 16967, 239, 7, 16, "Index",
      CellTags->"Polynomial approximation"]},
  "Polynomial inequalities"->{
    Cell[435800, 16976, 375, 11, 16, "Index",
      CellTags->"Polynomial inequalities"]},
  "PolynomialExtendedGCD"->{
    Cell[436178, 16989, 405, 12, 32, "Index",
      CellTags->"PolynomialExtendedGCD"]},
  "PolynomialExtendedGCD package"->{
    Cell[436586, 17003, 275, 8, 16, "Index",
      CellTags->"PolynomialExtendedGCD package"]},
  "PolynomialFit"->{
    Cell[436864, 17013, 239, 8, 16, "Index",
      CellTags->"PolynomialFit"]},
  "PolynomialFit package"->{
    Cell[437106, 17023, 255, 8, 16, "Index",
      CellTags->"PolynomialFit package"]},
  "PolynomialGCD"->{
    Cell[437364, 17033, 237, 8, 16, "Index",
      CellTags->"PolynomialGCD"],
    Cell[437604, 17043, 275, 9, 16, "IndexSubentry",
      CellTags->"PolynomialGCD"]},
  "PolynomialMod"->{
    Cell[437882, 17054, 237, 8, 16, "Index",
      CellTags->"PolynomialMod"]},
  "PolynomialPowerMod"->{
    Cell[438122, 17064, 247, 8, 16, "Index",
      CellTags->"PolynomialPowerMod"]},
  "PolynomialPowerMod package"->{
    Cell[438372, 17074, 263, 8, 16, "Index",
      CellTags->"PolynomialPowerMod package"]},
  "PolynomialQuotient"->{
    Cell[438638, 17084, 247, 8, 16, "Index",
      CellTags->"PolynomialQuotient"]},
  "PolynomialRemainder"->{
    Cell[438888, 17094, 249, 8, 16, "Index",
      CellTags->"PolynomialRemainder"]},
  "Polynomials"->{
    Cell[439140, 17104, 216, 7, 16, "Index",
      CellTags->"Polynomials"],
    Cell[439359, 17113, 848, 25, 64, "IndexSubentry",
      CellTags->"Polynomials"]},
  "PolynomialToElement"->{
    Cell[440210, 17140, 238, 8, 16, "Index",
      CellTags->"PolynomialToElement"]},
  "Polytope"->{
    Cell[440451, 17150, 372, 12, 16, "Index",
      CellTags->"Polytope"]},
  "PolytopeQuantile"->{
    Cell[440826, 17164, 266, 8, 16, "Index",
      CellTags->"PolytopeQuantile"]},
  "PolytopeQuartiles"->{
    Cell[441095, 17174, 268, 8, 16, "Index",
      CellTags->"PolytopeQuartiles"]},
  "Polytopes"->{
    Cell[441366, 17184, 226, 7, 16, "Index",
      CellTags->"Polytopes"]},
  "Polytopes package"->{
    Cell[441595, 17193, 229, 8, 16, "Index",
      CellTags->"Polytopes package"]},
  "Positions"->{
    Cell[441827, 17203, 252, 9, 16, "Index",
      CellTags->"Positions"]},
  "PostTests"->{
    Cell[442082, 17214, 210, 8, 16, "Index",
      CellTags->"PostTests"]},
  "Power"->{
    Cell[442295, 17224, 226, 9, 16, "Index",
      CellTags->"Power"]},
  "PowerList"->{
    Cell[442524, 17235, 218, 8, 16, "Index",
      CellTags->"PowerList"]},
  "PowerListQ"->{
    Cell[442745, 17245, 220, 8, 16, "Index",
      CellTags->"PowerListQ"]},
  "PowerListToField"->{
    Cell[442968, 17255, 232, 8, 16, "Index",
      CellTags->"PowerListToField"]},
  "PowerMod"->{
    Cell[443203, 17265, 374, 12, 16, "Index",
      CellTags->"PowerMod"]},
  "PowerSum"->{
    Cell[443580, 17279, 213, 8, 16, "Index",
      CellTags->"PowerSum"]},
  "Pratt's primality certificate"->{
    Cell[443796, 17289, 251, 7, 16, "Index",
      CellTags->"Pratt's primality certificate"]},
  "PredictedResponse"->{
    Cell[444050, 17298, 505, 16, 32, "Index",
      CellTags->"PredictedResponse"]},
  "PredictedResponseDelta"->{
    Cell[444558, 17316, 380, 12, 16, "Index",
      CellTags->"PredictedResponseDelta"]},
  "Pressure"->{
    Cell[444941, 17330, 239, 8, 16, "Index",
      CellTags->"Pressure"]},
  "PressureScaleHeight"->{
    Cell[445183, 17340, 261, 8, 16, "Index",
      CellTags->"PressureScaleHeight"]},
  "PreviousPrime"->{
    Cell[445447, 17350, 253, 8, 16, "Index",
      CellTags->"PreviousPrime"]},
  "Primality certificate"->{
    Cell[445703, 17360, 264, 9, 16, "Index",
      CellTags->"Primality certificate"]},
  "Primality certificate checking"->{
    Cell[445970, 17371, 287, 9, 16, "Index",
      CellTags->"Primality certificate checking"]},
  "Primality proving"->{
    Cell[446260, 17382, 253, 9, 16, "Index",
      CellTags->"Primality proving"]},
  "Primary colors"->{
    Cell[446516, 17393, 195, 7, 16, "Index",
      CellTags->"Primary colors"]},
  "PrimaryLeftAssociate"->{
    Cell[446714, 17402, 238, 8, 16, "Index",
      CellTags->"PrimaryLeftAssociate"]},
  "PrimaryRightAssociate"->{
    Cell[446955, 17412, 240, 8, 16, "Index",
      CellTags->"PrimaryRightAssociate"]},
  "Prime"->{
    Cell[447198, 17422, 260, 9, 16, "Index",
      CellTags->"Prime"],
    Cell[447461, 17433, 269, 9, 16, "IndexSubentry",
      CellTags->"Prime"],
    Cell[447733, 17444, 227, 8, 16, "Index",
      CellTags->"Prime"]},
  "PrimeFactorList"->{
    Cell[447963, 17454, 258, 8, 16, "Index",
      CellTags->"PrimeFactorList"]},
  "PrimePowerQ"->{
    Cell[448224, 17464, 250, 8, 16, "Index",
      CellTags->"PrimePowerQ"]},
  "PrimeQ"->{
    Cell[448477, 17474, 366, 12, 16, "Index",
      CellTags->"PrimeQ"]},
  "PrimeQ package"->{
    Cell[448846, 17488, 225, 8, 16, "Index",
      CellTags->"PrimeQ package"]},
  "PrimeQCertificate"->{
    Cell[449074, 17498, 231, 8, 16, "Index",
      CellTags->"PrimeQCertificate"]},
  "PrimeQCertificateCheck"->{
    Cell[449308, 17508, 241, 8, 16, "Index",
      CellTags->"PrimeQCertificateCheck"]},
  "PrimeQMessages"->{
    Cell[449552, 17518, 226, 8, 16, "Index",
      CellTags->"PrimeQMessages"]},
  "Primitive elements"->{
    Cell[449781, 17528, 360, 11, 16, "Index",
      CellTags->"Primitive elements"]},
  "Primitive roots"->{
    Cell[450144, 17541, 236, 7, 16, "Index",
      CellTags->"Primitive roots"]},
  "PrimitiveElement"->{
    Cell[450383, 17550, 249, 8, 16, "Index",
      CellTags->"PrimitiveElement"]},
  "PrimitiveElement package"->{
    Cell[450635, 17560, 265, 8, 16, "Index",
      CellTags->"PrimitiveElement package"]},
  "PrimitiveRoot"->{
    Cell[450903, 17570, 254, 8, 16, "Index",
      CellTags->"PrimitiveRoot"]},
  "Primitives"->{
    Cell[451160, 17580, 243, 7, 16, "Index",
      CellTags->"Primitives"],
    Cell[451406, 17589, 716, 23, 48, "IndexSubentry",
      CellTags->"Primitives"]},
  "Principal branch"->{
    Cell[452125, 17614, 194, 7, 16, "Index",
      CellTags->"Principal branch"]},
  "PrincipalComponents"->{
    Cell[452322, 17623, 272, 8, 16, "Index",
      CellTags->"PrincipalComponents"]},
  "PrintFlag"->{
    Cell[452597, 17633, 234, 8, 16, "Index",
      CellTags->"PrintFlag"]},
  "Probability density function"->{
    Cell[452834, 17643, 912, 25, 48, "Index",
      CellTags->"Probability density function"]},
  "Probability value (p-value)"->{
    Cell[453749, 17670, 251, 7, 16, "Index",
      CellTags->"Probability value (p-value)"]},
  "Product, dot"->{
    Cell[454003, 17679, 248, 9, 16, "Index",
      CellTags->"Product, dot"]},
  "Project"->{
    Cell[454254, 17690, 212, 8, 16, "Index",
      CellTags->"Project"]},
  "Projection"->{
    Cell[454469, 17700, 391, 12, 16, "Index",
      CellTags->"Projection"]},
  "Projections"->{
    Cell[454863, 17714, 210, 7, 16, "Index",
      CellTags->"Projections"],
    Cell[455076, 17723, 237, 9, 16, "IndexSubentry",
      CellTags->"Projections"]},
  "ProjectiveRationalize"->{
    Cell[455316, 17734, 249, 8, 16, "Index",
      CellTags->"ProjectiveRationalize"]},
  "ProlateSpheroidal"->{
    Cell[455568, 17744, 239, 8, 16, "Index",
      CellTags->"ProlateSpheroidal"]},
  "ProtonComptonWavelength"->{
    Cell[455810, 17754, 267, 8, 16, "Index",
      CellTags->"ProtonComptonWavelength"]},
  "ProtonMagneticMoment"->{
    Cell[456080, 17764, 261, 8, 16, "Index",
      CellTags->"ProtonMagneticMoment"]},
  "ProtonMass"->{
    Cell[456344, 17774, 241, 8, 16, "Index",
      CellTags->"ProtonMass"]},
  "ProvablePrimeQ"->{
    Cell[456588, 17784, 225, 8, 16, "Index",
      CellTags->"ProvablePrimeQ"]},
  "PseudoDiameter"->{
    Cell[456816, 17794, 224, 7, 16, "Index",
      CellTags->"PseudoDiameter"]},
  "PseudographQ"->{
    Cell[457043, 17803, 236, 8, 16, "Index",
      CellTags->"PseudographQ"]},
  "PythagoreanChromatic"->{
    Cell[457282, 17813, 237, 8, 16, "Index",
      CellTags->"PythagoreanChromatic"]},
  "Quadratic forms"->{
    Cell[457722, 17832, 244, 7, 16, "Index",
      CellTags->"Quadratic forms"]},
  "QuadraticFormDistribution"->{
    Cell[457969, 17841, 277, 8, 16, "Index",
      CellTags->"QuadraticFormDistribution"]},
  "QuadraticIrrationalQ"->{
    Cell[458249, 17851, 262, 8, 16, "Index",
      CellTags->"QuadraticIrrationalQ"]},
  "QuadraticRepresentation"->{
    Cell[458514, 17861, 274, 8, 16, "Index",
      CellTags->"QuadraticRepresentation"]},
  "Quadrature"->{
    Cell[458791, 17871, 370, 11, 16, "Index",
      CellTags->"Quadrature"]},
  "QuadratureType"->{
    Cell[459164, 17884, 237, 8, 16, "Index",
      CellTags->"QuadratureType"]},
  "Quantile"->{
    Cell[459404, 17894, 1014, 28, 48, "Index",
      CellTags->"Quantile"]},
  "Quantile-quantile plot"->{
    Cell[460421, 17924, 241, 7, 16, "Index",
      CellTags->"Quantile-quantile plot"]},
  "QuantileForm"->{
    Cell[460665, 17933, 237, 8, 16, "Index",
      CellTags->"QuantileForm"]},
  "QuantilePlot"->{
    Cell[460905, 17943, 376, 12, 16, "Index",
      CellTags->"QuantilePlot"]},
  "QuantizedHallConductance"->{
    Cell[461284, 17957, 269, 8, 16, "Index",
      CellTags->"QuantizedHallConductance"]},
  "QuarterTone"->{
    Cell[461556, 17967, 219, 8, 16, "Index",
      CellTags->"QuarterTone"]},
  "QuartileDeviation"->{
    Cell[461778, 17977, 420, 12, 32, "Index",
      CellTags->"QuartileDeviation"]},
  "Quartiles"->{
    Cell[462201, 17991, 403, 12, 32, "Index",
      CellTags->"Quartiles"]},
  "QuartileSkewness"->{
    Cell[462607, 18005, 419, 12, 32, "Index",
      CellTags->"QuartileSkewness"]},
  "Quaternion"->{
    Cell[463029, 18019, 217, 8, 16, "Index",
      CellTags->"Quaternion"]},
  "QuaternionQ"->{
    Cell[463249, 18029, 219, 8, 16, "Index",
      CellTags->"QuaternionQ"]},
  "Quaternions"->{
    Cell[463471, 18039, 220, 8, 16, "Index",
      CellTags->"Quaternions"]},
  "Quaternions package"->{
    Cell[463694, 18049, 235, 8, 16, "Index",
      CellTags->"Quaternions package"]},
  "RadialEmbedding"->{
    Cell[464136, 18067, 242, 8, 16, "Index",
      CellTags->"RadialEmbedding"]},
  "Radius"->{
    Cell[464381, 18077, 484, 16, 16, "Index",
      CellTags->"Radius"]},
  "Ramanujan functions"->{
    Cell[464868, 18095, 220, 7, 16, "Index",
      CellTags->"Ramanujan functions"]},
  "Ramanujan hypothesis"->{
    Cell[465091, 18104, 221, 7, 16, "Index",
      CellTags->"Ramanujan hypothesis"]},
  "Ramanujan package"->{
    Cell[465315, 18113, 237, 8, 16, "Index",
      CellTags->"Ramanujan package"]},
  "RamanujanTau"->{
    Cell[465555, 18123, 228, 8, 16, "Index",
      CellTags->"RamanujanTau"]},
  "RamanujanTauDirichletSeries"->{
    Cell[465786, 18133, 258, 8, 16, "Index",
      CellTags->"RamanujanTauDirichletSeries"]},
  "RamanujanTauGeneratingFunction"->{
    Cell[466047, 18143, 264, 8, 16, "Index",
      CellTags->"RamanujanTauGeneratingFunction"]},
  "RamanujanTauTheta"->{
    Cell[466314, 18153, 238, 8, 16, "Index",
      CellTags->"RamanujanTauTheta"]},
  "RamanujanTauZ"->{
    Cell[466555, 18163, 230, 8, 16, "Index",
      CellTags->"RamanujanTauZ"]},
  "Random"->{
    Cell[466788, 18173, 1013, 28, 48, "Index",
      CellTags->"Random"]},
  "RandomArray"->{
    Cell[467804, 18203, 989, 28, 48, "Index",
      CellTags->"RandomArray"]},
  "RandomColors"->{
    Cell[468796, 18233, 229, 8, 16, "Index",
      CellTags->"RandomColors"]},
  "RandomComposition"->{
    Cell[469028, 18243, 246, 8, 16, "Index",
      CellTags->"RandomComposition"]},
  "RandomGraph"->{
    Cell[469277, 18253, 234, 8, 16, "Index",
      CellTags->"RandomGraph"]},
  "RandomGrays"->{
    Cell[469514, 18263, 227, 8, 16, "Index",
      CellTags->"RandomGrays"]},
  "RandomHeap"->{
    Cell[469744, 18273, 232, 8, 16, "Index",
      CellTags->"RandomHeap"]},
  "RandomInteger"->{
    Cell[469979, 18283, 238, 8, 16, "Index",
      CellTags->"RandomInteger"]},
  "RandomKSetPartition"->{
    Cell[470220, 18293, 250, 8, 16, "Index",
      CellTags->"RandomKSetPartition"]},
  "RandomKSubset"->{
    Cell[470473, 18303, 379, 12, 16, "Index",
      CellTags->"RandomKSubset"]},
  "RandomPartition"->{
    Cell[470855, 18317, 383, 12, 16, "Index",
      CellTags->"RandomPartition"]},
  "RandomPermutation"->{
    Cell[471241, 18331, 386, 12, 16, "Index",
      CellTags->"RandomPermutation"]},
  "RandomRGF"->{
    Cell[471630, 18345, 230, 8, 16, "Index",
      CellTags->"RandomRGF"]},
  "RandomSetPartition"->{
    Cell[471863, 18355, 248, 8, 16, "Index",
      CellTags->"RandomSetPartition"]},
  "RandomSubset"->{
    Cell[472114, 18365, 377, 12, 16, "Index",
      CellTags->"RandomSubset"]},
  "RandomTableau"->{
    Cell[472494, 18379, 379, 12, 16, "Index",
      CellTags->"RandomTableau"]},
  "RandomTree"->{
    Cell[472876, 18393, 373, 12, 16, "Index",
      CellTags->"RandomTree"]},
  "RandomVertices"->{
    Cell[473252, 18407, 240, 8, 16, "Index",
      CellTags->"RandomVertices"]},
  "RangeCounts"->{
    Cell[473495, 18417, 236, 8, 16, "Index",
      CellTags->"RangeCounts"]},
  "RangeLists"->{
    Cell[473734, 18427, 234, 8, 16, "Index",
      CellTags->"RangeLists"]},
  "RankBinarySubset"->{
    Cell[473971, 18437, 244, 8, 16, "Index",
      CellTags->"RankBinarySubset"]},
  "RankedEmbedding"->{
    Cell[474218, 18447, 383, 12, 16, "Index",
      CellTags->"RankedEmbedding"]},
  "RankGraph"->{
    Cell[474604, 18461, 230, 8, 16, "Index",
      CellTags->"RankGraph"]},
  "RankGrayCodeSubset"->{
    Cell[474837, 18471, 248, 8, 16, "Index",
      CellTags->"RankGrayCodeSubset"]},
  "RankKSetPartition"->{
    Cell[475088, 18481, 246, 8, 16, "Index",
      CellTags->"RankKSetPartition"]},
  "RankKSubset"->{
    Cell[475337, 18491, 234, 8, 16, "Index",
      CellTags->"RankKSubset"]},
  "RankPermutation"->{
    Cell[475574, 18501, 382, 12, 16, "Index",
      CellTags->"RankPermutation"]},
  "RankRGF"->{
    Cell[475959, 18515, 226, 8, 16, "Index",
      CellTags->"RankRGF"]},
  "RankSetPartition"->{
    Cell[476188, 18525, 244, 8, 16, "Index",
      CellTags->"RankSetPartition"]},
  "RankSubset"->{
    Cell[476435, 18535, 232, 8, 16, "Index",
      CellTags->"RankSubset"]},
  "Rational function approximations"->{
    Cell[476670, 18545, 371, 11, 16, "Index",
      CellTags->"Rational function approximations"]},
  "Rational number approximations"->{
    Cell[477044, 18558, 259, 7, 16, "Index",
      CellTags->"Rational number approximations"],
    Cell[477306, 18567, 235, 7, 16, "IndexSubentry",
      CellTags->"Rational number approximations"]},
  "RationalInterpolation"->{
    Cell[477544, 18576, 257, 8, 16, "Index",
      CellTags->"RationalInterpolation"]},
  "Rationalize"->{
    Cell[477804, 18586, 262, 9, 16, "Index",
      CellTags->"Rationalize"],
    Cell[478069, 18597, 265, 9, 16, "IndexSubentry",
      CellTags->"Rationalize"],
    Cell[478337, 18608, 229, 8, 16, "Index",
      CellTags->"Rationalize"]},
  "Rationalize package"->{
    Cell[478569, 18618, 245, 8, 16, "Index",
      CellTags->"Rationalize package"]},
  "RayleighDistribution"->{
    Cell[478817, 18628, 267, 8, 16, "Index",
      CellTags->"RayleighDistribution"]},
  "Re"->{
    Cell[479087, 18638, 314, 12, 16, "Index",
      CellTags->"Re"]},
  "ReadSoundFile"->{
    Cell[479404, 18652, 224, 8, 16, "Index",
      CellTags->"ReadSoundFile"]},
  "Real numbers"->{
    Cell[479631, 18662, 205, 7, 16, "Index",
      CellTags->"Real numbers"]},
  "RealDigits"->{
    Cell[479839, 18671, 241, 8, 16, "Index",
      CellTags->"RealDigits"]},
  "RealizeDegreeSequence"->{
    Cell[480083, 18681, 395, 12, 16, "Index",
      CellTags->"RealizeDegreeSequence"]},
  "RealOnly"->{
    Cell[480481, 18695, 219, 8, 16, "Index",
      CellTags->"RealOnly"]},
  "RealOnly package"->{
    Cell[480703, 18705, 235, 8, 16, "Index",
      CellTags->"RealOnly package"]},
  "RealRootIntervals"->{
    Cell[480941, 18715, 235, 8, 16, "Index",
      CellTags->"RealRootIntervals"]},
  "RealValued"->{
    Cell[481179, 18725, 315, 12, 16, "Index",
      CellTags->"RealValued"]},
  "Recognize"->{
    Cell[481497, 18739, 221, 8, 16, "Index",
      CellTags->"Recognize"]},
  "Recognize package"->{
    Cell[481721, 18749, 237, 8, 16, "Index",
      CellTags->"Recognize package"]},
  "Recurring decimals"->{
    Cell[481961, 18759, 236, 7, 16, "Index",
      CellTags->"Recurring decimals"]},
  "ReduceElement"->{
    Cell[482200, 18768, 226, 8, 16, "Index",
      CellTags->"ReduceElement"]},
  "ReferenceLineStyle"->{
    Cell[482429, 18778, 248, 8, 16, "Index",
      CellTags->"ReferenceLineStyle"]},
  "ReflexiveQ"->{
    Cell[482680, 18788, 232, 8, 16, "Index",
      CellTags->"ReflexiveQ"]},
  "RegionProbability"->{
    Cell[482915, 18798, 227, 8, 16, "Index",
      CellTags->"RegionProbability"]},
  "Regress"->{
    Cell[483145, 18808, 361, 12, 16, "Index",
      CellTags->"Regress"]},
  "RegressionReport"->{
    Cell[483509, 18822, 503, 16, 32, "Index",
      CellTags->"RegressionReport"]},
  "RegressionReportValues"->{
    Cell[484015, 18840, 658, 20, 32, "Index",
      CellTags->"RegressionReportValues"]},
  "RegularGraph"->{
    Cell[484676, 18862, 236, 8, 16, "Index",
      CellTags->"RegularGraph"]},
  "RegularPolygon"->{
    Cell[484915, 18872, 238, 8, 16, "Index",
      CellTags->"RegularPolygon"]},
  "RegularQ"->{
    Cell[485156, 18882, 228, 8, 16, "Index",
      CellTags->"RegularQ"]},
  "ReIm package"->{
    Cell[485387, 18892, 207, 8, 16, "Index",
      CellTags->"ReIm package"]},
  "Relative"->{
    Cell[485597, 18902, 203, 8, 16, "Index",
      CellTags->"Relative"]},
  "RelativeStrength"->{
    Cell[485803, 18912, 267, 8, 16, "Index",
      CellTags->"RelativeStrength"]},
  "Remove"->{
    Cell[486073, 18922, 190, 8, 16, "Index",
      CellTags->"Remove"]},
  "RemoveMultipleEdges"->{
    Cell[486266, 18932, 250, 8, 16, "Index",
      CellTags->"RemoveMultipleEdges"]},
  "RemoveSelfLoops"->{
    Cell[486519, 18942, 242, 8, 16, "Index",
      CellTags->"RemoveSelfLoops"]},
  "RepeatedSmoothing"->{
    Cell[486764, 18952, 241, 8, 16, "Index",
      CellTags->"RepeatedSmoothing"]},
  "ResidualFlowGraph"->{
    Cell[487008, 18962, 246, 8, 16, "Index",
      CellTags->"ResidualFlowGraph"]},
  "Residuals"->{
    Cell[487257, 18972, 395, 13, 16, "Index",
      CellTags->"Residuals"],
    Cell[487655, 18987, 602, 19, 32, "IndexSubentry",
      CellTags->"Residuals"]},
  "Residue"->{
    Cell[488260, 19008, 242, 9, 16, "Index",
      CellTags->"Residue"],
    Cell[488505, 19019, 217, 8, 16, "Index",
      CellTags->"Residue"]},
  "ResonanceAbsorptionLines package"->{
    Cell[488725, 19029, 299, 8, 16, "Index",
      CellTags->"ResonanceAbsorptionLines package"]},
  "RevealCycles"->{
    Cell[489027, 19039, 236, 8, 16, "Index",
      CellTags->"RevealCycles"]},
  "ReverseEdges"->{
    Cell[489266, 19049, 236, 8, 16, "Index",
      CellTags->"ReverseEdges"]},
  "RevolutionAxis"->{
    Cell[489505, 19059, 243, 8, 16, "Index",
      CellTags->"RevolutionAxis"]},
  "RGBColor"->{
    Cell[489751, 19069, 205, 8, 16, "Index",
      CellTags->"RGBColor"]},
  "RGFQ"->{
    Cell[489959, 19079, 220, 8, 16, "Index",
      CellTags->"RGFQ"]},
  "RGFs"->{
    Cell[490182, 19089, 220, 8, 16, "Index",
      CellTags->"RGFs"]},
  "RGFToSetPartition"->{
    Cell[490405, 19099, 246, 8, 16, "Index",
      CellTags->"RGFToSetPartition"]},
  "Riemann hypothesis"->{
    Cell[490654, 19109, 217, 7, 16, "Index",
      CellTags->"Riemann hypothesis"]},
  "RiemannSiegelTheta"->{
    Cell[490874, 19118, 240, 8, 16, "Index",
      CellTags->"RiemannSiegelTheta"]},
  "RiemannSiegelZ"->{
    Cell[491117, 19128, 232, 8, 16, "Index",
      CellTags->"RiemannSiegelZ"]},
  "RightAssociates"->{
    Cell[491352, 19138, 228, 8, 16, "Index",
      CellTags->"RightAssociates"]},
  "RightGCD"->{
    Cell[491583, 19148, 214, 8, 16, "Index",
      CellTags->"RightGCD"]},
  "RingModulation"->{
    Cell[491800, 19158, 226, 8, 16, "Index",
      CellTags->"RingModulation"]},
  "Ritz variational principle"->{
    Cell[492029, 19168, 244, 7, 16, "Index",
      CellTags->"Ritz variational principle"]},
  "RobertsonGraph"->{
    Cell[492276, 19177, 240, 8, 16, "Index",
      CellTags->"RobertsonGraph"]},
  "RogersTanimotoDissimilarity"->{
    Cell[492519, 19187, 308, 10, 16, "Index",
      CellTags->"RogersTanimotoDissimilarity"]},
  "Root finding"->{
    Cell[492830, 19199, 264, 9, 16, "Index",
      CellTags->"Root finding"]},
  "root of unity"->{
    Cell[493097, 19210, 232, 7, 16, "Index",
      CellTags->"root of unity"]},
  "RootedEmbedding"->{
    Cell[493332, 19219, 242, 8, 16, "Index",
      CellTags->"RootedEmbedding"]},
  "RootIsolation package"->{
    Cell[493577, 19229, 243, 8, 16, "Index",
      CellTags->"RootIsolation package"]},
  "RootMeanSquare"->{
    Cell[493823, 19239, 413, 12, 32, "Index",
      CellTags->"RootMeanSquare"]},
  "Roots of polynomials"->{
    Cell[494239, 19253, 234, 7, 16, "Index",
      CellTags->"Roots of polynomials"]},
  "Rotate2D"->{
    Cell[494476, 19262, 211, 8, 16, "Index",
      CellTags->"Rotate2D"]},
  "Rotate3D"->{
    Cell[494690, 19272, 211, 8, 16, "Index",
      CellTags->"Rotate3D"]},
  "RotateLights"->{
    Cell[494904, 19282, 219, 8, 16, "Index",
      CellTags->"RotateLights"]},
  "RotateShape"->{
    Cell[495126, 19292, 336, 12, 16, "Index",
      CellTags->"RotateShape"]},
  "RotateVertices"->{
    Cell[495465, 19306, 240, 8, 16, "Index",
      CellTags->"RotateVertices"]},
  "Rotation"->{
    Cell[495708, 19316, 266, 9, 16, "Index",
      CellTags->"Rotation"],
    Cell[495977, 19327, 656, 21, 48, "IndexSubentry",
      CellTags->"Rotation"]},
  "RotationMatrix2D"->{
    Cell[496636, 19350, 227, 8, 16, "Index",
      CellTags->"RotationMatrix2D"]},
  "RotationMatrix3D"->{
    Cell[496866, 19360, 227, 8, 16, "Index",
      CellTags->"RotationMatrix3D"]},
  "Rotations package"->{
    Cell[497096, 19370, 229, 8, 16, "Index",
      CellTags->"Rotations package"]},
  "Round"->{
    Cell[497328, 19380, 208, 8, 16, "Index",
      CellTags->"Round"]},
  "RoundingRule"->{
    Cell[497539, 19390, 248, 8, 16, "Index",
      CellTags->"RoundingRule"]},
  "Roundoff errors"->{
    Cell[497790, 19400, 367, 11, 16, "Index",
      CellTags->"Roundoff errors"]},
  "RoundToEven"->{
    Cell[498160, 19413, 246, 8, 16, "Index",
      CellTags->"RoundToEven"]},
  "RoundToInfinity"->{
    Cell[498409, 19423, 254, 8, 16, "Index",
      CellTags->"RoundToInfinity"]},
  "RowJoin"->{
    Cell[498666, 19433, 227, 8, 16, "Index",
      CellTags->"RowJoin"]},
  "RSolve package"->{
    Cell[498896, 19443, 356, 12, 16, "Index",
      CellTags->"RSolve package"]},
  "RSquared"->{
    Cell[499255, 19457, 352, 12, 16, "Index",
      CellTags->"RSquared"]},
  "Runge-Kutta methods"->{
    Cell[499610, 19471, 225, 7, 16, "Index",
      CellTags->"Runge-Kutta methods"]},
  "RungeKuttaMethod"->{
    Cell[499838, 19480, 234, 8, 16, "Index",
      CellTags->"RungeKuttaMethod"]},
  "RungeKuttaOrderConditions"->{
    Cell[500075, 19490, 252, 8, 16, "Index",
      CellTags->"RungeKuttaOrderConditions"]},
  "Runs"->{
    Cell[500330, 19500, 220, 8, 16, "Index",
      CellTags->"Runs"]},
  "RussleRaoDissimilarity"->{
    Cell[500553, 19510, 298, 10, 16, "Index",
      CellTags->"RussleRaoDissimilarity"]},
  "SackurTetrodeConstant"->{
    Cell[501077, 19531, 263, 8, 16, "Index",
      CellTags->"SackurTetrodeConstant"]},
  "SamenessRelation"->{
    Cell[501343, 19541, 244, 8, 16, "Index",
      CellTags->"SamenessRelation"]},
  "Sample mean"->{
    Cell[501590, 19551, 460, 13, 32, "Index",
      CellTags->"Sample mean"],
    Cell[502053, 19566, 444, 13, 32, "IndexSubentry",
      CellTags->"Sample mean"]},
  "SampleDepth"->{
    Cell[502500, 19581, 220, 8, 16, "Index",
      CellTags->"SampleDepth"]},
  "SampleRange"->{
    Cell[502723, 19591, 408, 12, 32, "Index",
      CellTags->"SampleRange"]},
  "SampleRate"->{
    Cell[503134, 19605, 218, 8, 16, "Index",
      CellTags->"SampleRate"]},
  "Sawtooth"->{
    Cell[503355, 19615, 213, 8, 16, "Index",
      CellTags->"Sawtooth"]},
  "Scalar product"->{
    Cell[503571, 19625, 283, 9, 16, "Index",
      CellTags->"Scalar product"]},
  "ScalarTripleProduct"->{
    Cell[503857, 19636, 244, 8, 16, "Index",
      CellTags->"ScalarTripleProduct"]},
  "Scale"->{
    Cell[504104, 19646, 464, 16, 16, "Index",
      CellTags->"Scale"]},
  "ScaleFactor"->{
    Cell[504571, 19664, 463, 16, 16, "Index",
      CellTags->"ScaleFactor"]},
  "ScaleFactors"->{
    Cell[505037, 19682, 230, 8, 16, "Index",
      CellTags->"ScaleFactors"]},
  "ScaleFunction"->{
    Cell[505270, 19692, 467, 16, 16, "Index",
      CellTags->"ScaleFunction"]},
  "ScaleMethod"->{
    Cell[505740, 19710, 419, 12, 32, "Index",
      CellTags->"ScaleMethod"]},
  "Scales"->{
    Cell[506162, 19724, 355, 13, 16, "Index",
      CellTags->"Scales"]},
  "Scaling"->{
    Cell[506520, 19739, 260, 9, 16, "Index",
      CellTags->"Scaling"]},
  "scatter plot"->{
    Cell[506783, 19750, 214, 7, 16, "Index",
      CellTags->"scatter plot"]},
  "ScatterPlot3D"->{
    Cell[507000, 19759, 223, 8, 16, "Index",
      CellTags->"ScatterPlot3D"]},
  "Schlafli"->{
    Cell[507226, 19769, 211, 8, 16, "Index",
      CellTags->"Schlafli"]},
  "SelectionSort"->{
    Cell[507440, 19779, 238, 8, 16, "Index",
      CellTags->"SelectionSort"]},
  "SelfComplementaryQ"->{
    Cell[507681, 19789, 389, 12, 16, "Index",
      CellTags->"SelfComplementaryQ"]},
  "SelfLoopsQ"->{
    Cell[508073, 19803, 232, 8, 16, "Index",
      CellTags->"SelfLoopsQ"]},
  "Semi-log plots"->{
    Cell[508308, 19813, 244, 9, 16, "Index",
      CellTags->"Semi-log plots"]},
  "Semialgebraic sets"->{
    Cell[508555, 19824, 231, 7, 16, "Index",
      CellTags->"Semialgebraic sets"]},
  "SemialgebraicComponents"->{
    Cell[508789, 19833, 263, 8, 16, "Index",
      CellTags->"SemialgebraicComponents"]},
  "SemimajorAxis"->{
    Cell[509055, 19843, 227, 8, 16, "Index",
      CellTags->"SemimajorAxis"]},
  "Separation of colors"->{
    Cell[509285, 19853, 207, 7, 16, "Index",
      CellTags->"Separation of colors"]},
  "Sequence of graphics"->{
    Cell[509495, 19862, 213, 7, 16, "Index",
      CellTags->"Sequence of graphics"]},
  "Sequences"->{
    Cell[509711, 19871, 208, 7, 16, "Index",
      CellTags->"Sequences"]},
  "SequentialSumOfSquares"->{
    Cell[509922, 19880, 380, 12, 16, "Index",
      CellTags->"SequentialSumOfSquares"]},
  "Series"->{
    Cell[510305, 19894, 202, 7, 16, "Index",
      CellTags->"Series"],
    Cell[510510, 19903, 883, 27, 64, "IndexSubentry",
      CellTags->"Series"],
    Cell[511396, 19932, 213, 8, 16, "Index",
      CellTags->"Series"]},
  "SeriesTerm"->{
    Cell[511612, 19942, 218, 8, 16, "Index",
      CellTags->"SeriesTerm"]},
  "SetArithmetic"->{
    Cell[511833, 19952, 250, 8, 16, "Index",
      CellTags->"SetArithmetic"]},
  "SetCoordinates"->{
    Cell[512086, 19962, 368, 12, 16, "Index",
      CellTags->"SetCoordinates"]},
  "SetEdgeLabels"->{
    Cell[512457, 19976, 238, 8, 16, "Index",
      CellTags->"SetEdgeLabels"]},
  "SetEdgeWeights"->{
    Cell[512698, 19986, 240, 8, 16, "Index",
      CellTags->"SetEdgeWeights"]},
  "SetFieldFormat"->{
    Cell[512941, 19996, 228, 8, 16, "Index",
      CellTags->"SetFieldFormat"]},
  "SetGraphOptions"->{
    Cell[513172, 20006, 242, 8, 16, "Index",
      CellTags->"SetGraphOptions"]},
  "SetPartitionListViaRGF"->{
    Cell[513417, 20016, 256, 8, 16, "Index",
      CellTags->"SetPartitionListViaRGF"]},
  "SetPartitionQ"->{
    Cell[513676, 20026, 238, 8, 16, "Index",
      CellTags->"SetPartitionQ"]},
  "SetPartitions"->{
    Cell[513917, 20036, 238, 8, 16, "Index",
      CellTags->"SetPartitions"]},
  "SetPartitionToRGF"->{
    Cell[514158, 20046, 246, 8, 16, "Index",
      CellTags->"SetPartitionToRGF"]},
  "Setting arithmetic parameters"->{
    Cell[514407, 20056, 303, 9, 16, "Index",
      CellTags->"Setting arithmetic parameters"]},
  "SetVertexLabels"->{
    Cell[514713, 20067, 242, 8, 16, "Index",
      CellTags->"SetVertexLabels"]},
  "SetVertexWeights"->{
    Cell[514958, 20077, 244, 8, 16, "Index",
      CellTags->"SetVertexWeights"]},
  "Shade"->{
    Cell[515205, 20087, 235, 9, 16, "Index",
      CellTags->"Shade"]},
  "Shadow"->{
    Cell[515443, 20098, 210, 8, 16, "Index",
      CellTags->"Shadow"]},
  "ShadowBackground"->{
    Cell[515656, 20108, 222, 8, 16, "Index",
      CellTags->"ShadowBackground"]},
  "ShadowBorder"->{
    Cell[515881, 20118, 214, 8, 16, "Index",
      CellTags->"ShadowBorder"]},
  "ShadowBox"->{
    Cell[516098, 20128, 207, 8, 16, "Index",
      CellTags->"ShadowBox"]},
  "ShadowForeground"->{
    Cell[516308, 20138, 222, 8, 16, "Index",
      CellTags->"ShadowForeground"]},
  "Shadowing of names"->{
    Cell[516533, 20148, 298, 11, 16, "Index",
      CellTags->"Shadowing of names"]},
  "ShadowMesh"->{
    Cell[516834, 20161, 218, 8, 16, "Index",
      CellTags->"ShadowMesh"]},
  "ShadowMeshStyle"->{
    Cell[517055, 20171, 228, 8, 16, "Index",
      CellTags->"ShadowMeshStyle"]},
  "ShadowOffset"->{
    Cell[517286, 20181, 214, 8, 16, "Index",
      CellTags->"ShadowOffset"]},
  "ShadowPlot3D"->{
    Cell[517503, 20191, 222, 8, 16, "Index",
      CellTags->"ShadowPlot3D"]},
  "ShadowPosition"->{
    Cell[517728, 20201, 226, 8, 16, "Index",
      CellTags->"ShadowPosition"]},
  "ShakeGraph"->{
    Cell[517957, 20211, 232, 8, 16, "Index",
      CellTags->"ShakeGraph"]},
  "ShapeReport"->{
    Cell[518192, 20221, 246, 8, 16, "Index",
      CellTags->"ShapeReport"]},
  "Shapes"->{
    Cell[518441, 20231, 234, 9, 16, "Index",
      CellTags->"Shapes"]},
  "Shapes package"->{
    Cell[518678, 20242, 342, 12, 16, "Index",
      CellTags->"Shapes package"]},
  "Share"->{
    Cell[519023, 20256, 217, 8, 16, "Index",
      CellTags->"Share"]},
  "ShortestPath"->{
    Cell[519243, 20266, 377, 12, 16, "Index",
      CellTags->"ShortestPath"]},
  "ShortestPathSpanningTree"->{
    Cell[519623, 20280, 401, 12, 16, "Index",
      CellTags->"ShortestPathSpanningTree"]},
  "Show"->{
    Cell[520027, 20294, 830, 28, 32, "Index",
      CellTags->"Show"]},
  "ShowAnimation"->{
    Cell[520860, 20324, 221, 8, 16, "Index",
      CellTags->"ShowAnimation"]},
  "ShowGraph"->{
    Cell[521084, 20334, 371, 12, 16, "Index",
      CellTags->"ShowGraph"]},
  "ShowGraphArray"->{
    Cell[521458, 20348, 381, 12, 16, "Index",
      CellTags->"ShowGraphArray"]},
  "ShowLabeledGraph"->{
    Cell[521842, 20362, 244, 8, 16, "Index",
      CellTags->"ShowLabeledGraph"]},
  "ShowLegend"->{
    Cell[522089, 20372, 209, 8, 16, "Index",
      CellTags->"ShowLegend"]},
  "ShowProgress"->{
    Cell[522301, 20382, 398, 12, 16, "Index",
      CellTags->"ShowProgress"]},
  "ShowTime"->{
    Cell[522702, 20396, 211, 8, 16, "Index",
      CellTags->"ShowTime"]},
  "ShowTime package"->{
    Cell[522916, 20406, 227, 8, 16, "Index",
      CellTags->"ShowTime package"]},
  "ShuffleExchangeGraph"->{
    Cell[523146, 20416, 252, 8, 16, "Index",
      CellTags->"ShuffleExchangeGraph"]},
  "SI"->{
    Cell[523401, 20426, 201, 8, 16, "Index",
      CellTags->"SI"]},
  "SiegelTheta"->{
    Cell[523605, 20436, 229, 8, 16, "Index",
      CellTags->"SiegelTheta"]},
  "SiegelTheta package"->{
    Cell[523837, 20446, 245, 8, 16, "Index",
      CellTags->"SiegelTheta package"]},
  "Sign"->{
    Cell[524085, 20456, 206, 8, 16, "Index",
      CellTags->"Sign"]},
  "SignaturePermutation"->{
    Cell[524294, 20466, 252, 8, 16, "Index",
      CellTags->"SignaturePermutation"]},
  "Significance level"->{
    Cell[524549, 20476, 231, 8, 16, "Index",
      CellTags->"Significance level"]},
  "SignificanceLevel"->{
    Cell[524783, 20486, 583, 21, 16, "Index",
      CellTags->"SignificanceLevel"]},
  "Simple"->{
    Cell[525369, 20509, 341, 13, 16, "Index",
      CellTags->"Simple"]},
  "SimpleQ"->{
    Cell[525713, 20524, 343, 13, 16, "Index",
      CellTags->"SimpleQ"]},
  "SimplexMedian"->{
    Cell[526059, 20539, 388, 13, 16, "Index",
      CellTags->"SimplexMedian"]},
  "SinglePredictionCITable"->{
    Cell[526450, 20554, 844, 29, 32, "Index",
      CellTags->"SinglePredictionCITable"]},
  "Singularities"->{
    Cell[527297, 20585, 381, 12, 16, "Index",
      CellTags->"Singularities"]},
  "Sinusoid"->{
    Cell[527681, 20599, 322, 13, 16, "Index",
      CellTags->"Sinusoid"]},
  "SixthTone"->{
    Cell[528006, 20614, 324, 13, 16, "Index",
      CellTags->"SixthTone"]},
  "Skewness"->{
    Cell[528333, 20629, 2010, 61, 64, "Index",
      CellTags->"Skewness"]},
  "Small"->{
    Cell[530346, 20692, 339, 13, 16, "Index",
      CellTags->"Small"]},
  "SmallestCyclicGroupGraph"->{
    Cell[530688, 20707, 377, 13, 16, "Index",
      CellTags->"SmallestCyclicGroupGraph"]},
  "SmallPrime"->{
    Cell[531068, 20722, 328, 13, 16, "Index",
      CellTags->"SmallPrime"]},
  "SmallStellatedDodecahedron"->{
    Cell[531399, 20737, 355, 13, 16, "Index",
      CellTags->"SmallStellatedDodecahedron"]},
  "Smoothing data"->{
    Cell[531757, 20752, 327, 12, 16, "Index",
      CellTags->"Smoothing data"]},
  "SokalSneathDissimilarity"->{
    Cell[532087, 20766, 302, 10, 16, "Index",
      CellTags->"SokalSneathDissimilarity"]},
  "SolarConstant"->{
    Cell[532392, 20778, 368, 13, 16, "Index",
      CellTags->"SolarConstant"]},
  "SolarLuminosity"->{
    Cell[532763, 20793, 372, 13, 16, "Index",
      CellTags->"SolarLuminosity"]},
  "SolarRadius"->{
    Cell[533138, 20808, 364, 13, 16, "Index",
      CellTags->"SolarRadius"]},
  "SolarSchwarzschildRadius"->{
    Cell[533505, 20823, 390, 13, 16, "Index",
      CellTags->"SolarSchwarzschildRadius"]},
  "SolarSystemAbundance"->{
    Cell[533898, 20838, 381, 13, 16, "Index",
      CellTags->"SolarSystemAbundance"]},
  "SolidBarEdges"->{
    Cell[534282, 20853, 332, 13, 16, "Index",
      CellTags->"SolidBarEdges"]},
  "SolidBarEdgeStyle"->{
    Cell[534617, 20868, 340, 13, 16, "Index",
      CellTags->"SolidBarEdgeStyle"]},
  "SolidBarStyle"->{
    Cell[534960, 20883, 332, 13, 16, "Index",
      CellTags->"SolidBarStyle"]},
  "Solids"->{
    Cell[535295, 20898, 320, 12, 16, "Index",
      CellTags->"Solids"]},
  "Solutions"->{
    Cell[535618, 20912, 360, 14, 16, "Index",
      CellTags->"Solutions"]},
  "Solving"->{
    Cell[535981, 20928, 395, 14, 16, "Index",
      CellTags->"Solving"]},
  "Solving differential equations"->{
    Cell[536379, 20944, 361, 12, 16, "Index",
      CellTags->"Solving differential equations"]},
  "Solving matrix equations"->{
    Cell[536743, 20958, 396, 14, 16, "Index",
      CellTags->"Solving matrix equations"]},
  "Solving simultaneous congruences"->{
    Cell[537142, 20974, 441, 14, 16, "Index",
      CellTags->"Solving simultaneous congruences"]},
  "Sorting"->{
    Cell[537586, 20990, 385, 14, 16, "Index",
      CellTags->"Sorting"]},
  "Sound"->{
    Cell[537974, 21006, 309, 12, 16, "Index",
      CellTags->"Sound"],
    Cell[538286, 21020, 309, 12, 16, "IndexSubentry",
      CellTags->"Sound"]},
  "SoundSpeed"->{
    Cell[538598, 21034, 365, 13, 16, "Index",
      CellTags->"SoundSpeed"]},
  "Spanning tree"->{
    Cell[538966, 21049, 333, 12, 16, "Index",
      CellTags->"Spanning tree"]},
  "Spatial data"->{
    Cell[539302, 21063, 366, 12, 16, "Index",
      CellTags->"Spatial data"]},
  "SpatialMedian"->{
    Cell[539671, 21077, 388, 13, 16, "Index",
      CellTags->"SpatialMedian"]},
  "SpearmanRankCorrelation"->{
    Cell[540062, 21092, 408, 13, 16, "Index",
      CellTags->"SpearmanRankCorrelation"]},
  "SpecificHeat"->{
    Cell[540473, 21107, 365, 13, 16, "Index",
      CellTags->"SpecificHeat"]},
  "Spectrum"->{
    Cell[540841, 21122, 345, 13, 16, "Index",
      CellTags->"Spectrum"]},
  "SpeedOfLight"->{
    Cell[541189, 21137, 366, 13, 16, "Index",
      CellTags->"SpeedOfLight"]},
  "SpeedOfSound"->{
    Cell[541558, 21152, 366, 13, 16, "Index",
      CellTags->"SpeedOfSound"]},
  "SpellCheck"->{
    Cell[541927, 21167, 226, 8, 16, "Index",
      CellTags->"SpellCheck"]},
  "Sphere"->{
    Cell[542156, 21177, 357, 14, 16, "Index",
      CellTags->"Sphere"],
    Cell[542516, 21193, 349, 14, 16, "IndexSubentry",
      CellTags->"Sphere"],
    Cell[542868, 21209, 306, 13, 16, "Index",
      CellTags->"Sphere"]},
  "Spherical"->{
    Cell[543177, 21224, 336, 13, 16, "Index",
      CellTags->"Spherical"]},
  "SphericalDistance"->{
    Cell[543516, 21239, 584, 21, 16, "Index",
      CellTags->"SphericalDistance"]},
  "SphericalPlot3D"->{
    Cell[544103, 21262, 354, 13, 16, "Index",
      CellTags->"SphericalPlot3D"]},
  "SpheroidalDistance"->{
    Cell[544460, 21277, 348, 13, 16, "Index",
      CellTags->"SpheroidalDistance"]},
  "Spline"->{
    Cell[544811, 21292, 306, 13, 16, "Index",
      CellTags->"Spline"]},
  "Spline package"->{
    Cell[545120, 21307, 322, 13, 16, "Index",
      CellTags->"Spline package"]},
  "SplineDivision"->{
    Cell[545445, 21322, 322, 13, 16, "Index",
      CellTags->"SplineDivision"]},
  "SplineDots"->{
    Cell[545770, 21337, 314, 13, 16, "Index",
      CellTags->"SplineDots"]},
  "SplineFit"->{
    Cell[546087, 21352, 336, 13, 16, "Index",
      CellTags->"SplineFit"]},
  "SplineFit package"->{
    Cell[546426, 21367, 352, 13, 16, "Index",
      CellTags->"SplineFit package"]},
  "SplineFunction"->{
    Cell[546781, 21382, 346, 13, 16, "Index",
      CellTags->"SplineFunction"]},
  "SplinePoints"->{
    Cell[547130, 21397, 318, 13, 16, "Index",
      CellTags->"SplinePoints"]},
  "SpringEmbedding"->{
    Cell[547451, 21412, 359, 13, 16, "Index",
      CellTags->"SpringEmbedding"]},
  "SqrtMod"->{
    Cell[547813, 21427, 367, 13, 16, "Index",
      CellTags->"SqrtMod"]},
  "SqrtModList"->{
    Cell[548183, 21442, 375, 13, 16, "Index",
      CellTags->"SqrtModList"]},
  "Square"->{
    Cell[548561, 21457, 544, 21, 16, "Index",
      CellTags->"Square"]},
  "SquaredEuclideanDistance"->{
    Cell[549108, 21480, 302, 10, 16, "Index",
      CellTags->"SquaredEuclideanDistance"]},
  "SquareFreeQ"->{
    Cell[549413, 21492, 634, 21, 16, "Index",
      CellTags->"SquareFreeQ"]},
  "SquareMatrixQ"->{
    Cell[550050, 21515, 373, 13, 16, "Index",
      CellTags->"SquareMatrixQ"]},
  "StableIsotopes"->{
    Cell[550426, 21530, 367, 13, 16, "Index",
      CellTags->"StableIsotopes"]},
  "StableMarriage"->{
    Cell[550796, 21545, 357, 13, 16, "Index",
      CellTags->"StableMarriage"]},
  "StackedBarChart"->{
    Cell[551156, 21560, 330, 13, 16, "Index",
      CellTags->"StackedBarChart"]},
  "StackGraphics"->{
    Cell[551489, 21575, 334, 13, 16, "Index",
      CellTags->"StackGraphics"]},
  "StandardAtmosphere package"->{
    Cell[551826, 21590, 397, 13, 16, "Index",
      CellTags->"StandardAtmosphere package"]},
  "StandardDeviation"->{
    Cell[552226, 21605, 2026, 61, 64, "Index",
      CellTags->"StandardDeviation"]},
  "StandardDeviationMLE"->{
    Cell[554255, 21668, 670, 21, 32, "Index",
      CellTags->"StandardDeviationMLE"]},
  "StandardErrorOfSampleMean"->{
    Cell[554928, 21691, 680, 21, 32, "Index",
      CellTags->"StandardErrorOfSampleMean"]},
  "Standardize"->{
    Cell[555611, 21714, 654, 21, 16, "Index",
      CellTags->"Standardize"]},
  "StandardizedResiduals"->{
    Cell[556268, 21737, 840, 29, 32, "Index",
      CellTags->"StandardizedResiduals"]},
  "StandardPackages directory"->{
    Cell[557111, 21768, 229, 8, 16, "Index",
      CellTags->"StandardPackages directory"]},
  "Star"->{
    Cell[557343, 21778, 841, 29, 32, "Index",
      CellTags->"Star"]},
  "StartingParameters"->{
    Cell[558187, 21809, 356, 13, 16, "Index",
      CellTags->"StartingParameters"]},
  "Statistical distributions"->{
    Cell[558546, 21824, 1463, 44, 48, "Index",
      CellTags->"Statistical distributions"]},
  "Statistics"->{
    Cell[560012, 21870, 373, 12, 16, "Index",
      CellTags->"Statistics"],
    Cell[560388, 21884, 2774, 82, 144, "IndexSubentry",
      CellTags->"Statistics"]},
  "StefanConstant"->{
    Cell[563165, 21968, 370, 13, 16, "Index",
      CellTags->"StefanConstant"]},
  "Stellate"->{
    Cell[563538, 21983, 319, 13, 16, "Index",
      CellTags->"Stellate"]},
  "Stem"->{
    Cell[563860, 21998, 334, 13, 16, "Index",
      CellTags->"Stem"]},
  "stem plot"->{
    Cell[564197, 22013, 322, 12, 16, "Index",
      CellTags->"stem plot"]},
  "StirlingFirst"->{
    Cell[564522, 22027, 355, 13, 16, "Index",
      CellTags->"StirlingFirst"]},
  "StirlingSecond"->{
    Cell[564880, 22042, 357, 13, 16, "Index",
      CellTags->"StirlingSecond"]},
  "Strings"->{
    Cell[565240, 22057, 343, 13, 16, "Index",
      CellTags->"Strings"]},
  "Strong"->{
    Cell[565586, 22072, 341, 13, 16, "Index",
      CellTags->"Strong"]},
  "StrongComponents"->{
    Cell[565930, 22087, 228, 7, 16, "Index",
      CellTags->"StrongComponents"]},
  "StronglyConnectedComponents"->{
    Cell[566161, 22096, 383, 13, 16, "Index",
      CellTags->"StronglyConnectedComponents"]},
  "StudentizedResiduals"->{
    Cell[566547, 22111, 595, 21, 16, "Index",
      CellTags->"StudentizedResiduals"]},
  "StudentNewmanKeuls"->{
    Cell[567145, 22134, 335, 13, 16, "Index",
      CellTags->"StudentNewmanKeuls"]},
  "StudentTCI"->{
    Cell[567483, 22149, 361, 13, 16, "Index",
      CellTags->"StudentTCI"]},
  "StudentTDistribution"->{
    Cell[567847, 22164, 650, 21, 32, "Index",
      CellTags->"StudentTDistribution"]},
  "StudentTPValue"->{
    Cell[568500, 22187, 357, 13, 16, "Index",
      CellTags->"StudentTPValue"]},
  "Subfactorial"->{
    Cell[568860, 22202, 378, 13, 16, "Index",
      CellTags->"Subfactorial"]},
  "Submatrices"->{
    Cell[569241, 22217, 345, 12, 16, "Index",
      CellTags->"Submatrices"]},
  "SubMatrix"->{
    Cell[569589, 22231, 363, 13, 16, "Index",
      CellTags->"SubMatrix"]},
  "Subsets"->{
    Cell[569955, 22246, 336, 12, 16, "Index",
      CellTags->"Subsets"],
    Cell[570294, 22260, 595, 21, 16, "Index",
      CellTags->"Subsets"]},
  "Successor"->{
    Cell[570892, 22283, 329, 13, 16, "Index",
      CellTags->"Successor"]},
  "SummaryReport"->{
    Cell[571224, 22298, 824, 29, 32, "Index",
      CellTags->"SummaryReport"]},
  "SumOfFactors"->{
    Cell[572051, 22329, 377, 13, 16, "Index",
      CellTags->"SumOfFactors"]},
  "SumOfFactorsType"->{
    Cell[572431, 22344, 385, 13, 16, "Index",
      CellTags->"SumOfFactorsType"]},
  "SumOfSquaresR"->{
    Cell[572819, 22359, 379, 13, 16, "Index",
      CellTags->"SumOfSquaresR"]},
  "SumOfSquaresRepresentations"->{
    Cell[573201, 22374, 407, 13, 16, "Index",
      CellTags->"SumOfSquaresRepresentations"]},
  "Sums"->{
    Cell[573611, 22389, 344, 14, 16, "Index",
      CellTags->"Sums"],
    Cell[573958, 22405, 639, 22, 32, "IndexSubentry",
      CellTags->"Sums"]},
  "SupDistance"->{
    Cell[574600, 22429, 276, 10, 16, "Index",
      CellTags->"SupDistance"]},
  "Surface of revolution"->{
    Cell[574879, 22441, 362, 12, 16, "Index",
      CellTags->"Surface of revolution"]},
  "SurfaceMesh"->{
    Cell[575244, 22455, 330, 13, 16, "Index",
      CellTags->"SurfaceMesh"]},
  "SurfaceMeshStyle"->{
    Cell[575577, 22470, 340, 13, 16, "Index",
      CellTags->"SurfaceMeshStyle"]},
  "SurfaceOfRevolution"->{
    Cell[575920, 22485, 371, 13, 16, "Index",
      CellTags->"SurfaceOfRevolution"]},
  "SurfaceOfRevolution package"->{
    Cell[576294, 22500, 387, 13, 16, "Index",
      CellTags->"SurfaceOfRevolution package"]},
  "Surfaces"->{
    Cell[576684, 22515, 385, 14, 16, "Index",
      CellTags->"Surfaces"],
    Cell[577072, 22531, 744, 24, 32, "IndexSubentry",
      CellTags->"Surfaces"]},
  "SymbolLabel"->{
    Cell[577819, 22557, 346, 13, 16, "Index",
      CellTags->"SymbolLabel"]},
  "Symbols"->{
    Cell[578168, 22572, 227, 9, 16, "Index",
      CellTags->"Symbols"]},
  "SymbolShape"->{
    Cell[578398, 22583, 850, 29, 32, "Index",
      CellTags->"SymbolShape"]},
  "SymbolStyle"->{
    Cell[579251, 22614, 850, 29, 32, "Index",
      CellTags->"SymbolStyle"]},
  "Symmetric polynomials"->{
    Cell[580104, 22645, 353, 12, 16, "Index",
      CellTags->"Symmetric polynomials"]},
  "SymmetricGroup"->{
    Cell[580460, 22659, 357, 13, 16, "Index",
      CellTags->"SymmetricGroup"]},
  "SymmetricGroupIndex"->{
    Cell[580820, 22674, 367, 13, 16, "Index",
      CellTags->"SymmetricGroupIndex"]},
  "SymmetricPolynomial"->{
    Cell[581190, 22689, 371, 13, 16, "Index",
      CellTags->"SymmetricPolynomial"]},
  "SymmetricPolynomials package"->{
    Cell[581564, 22704, 389, 13, 16, "Index",
      CellTags->"SymmetricPolynomials package"]},
  "SymmetricQ"->{
    Cell[581956, 22719, 349, 13, 16, "Index",
      CellTags->"SymmetricQ"]},
  "t distribution"->{
    Cell[582646, 22748, 434, 15, 16, "Index",
      CellTags->"t distribution"],
    Cell[583083, 22765, 1045, 34, 48, "IndexSubentry",
      CellTags->"t distribution"]},
  "T-square(d) distribution"->{
    Cell[584131, 22801, 443, 14, 16, "Index",
      CellTags->"T-square(d) distribution"]},
  "TableauClasses"->{
    Cell[584577, 22817, 357, 13, 16, "Index",
      CellTags->"TableauClasses"]},
  "TableauQ"->{
    Cell[584937, 22832, 345, 13, 16, "Index",
      CellTags->"TableauQ"]},
  "Tableaux"->{
    Cell[585285, 22847, 597, 21, 16, "Index",
      CellTags->"Tableaux"]},
  "TableauxToPermutation"->{
    Cell[585885, 22870, 371, 13, 16, "Index",
      CellTags->"TableauxToPermutation"]},
  "TakeColumns"->{
    Cell[586259, 22885, 367, 13, 16, "Index",
      CellTags->"TakeColumns"]},
  "TakeMatrix"->{
    Cell[586629, 22900, 365, 13, 16, "Index",
      CellTags->"TakeMatrix"]},
  "TakeRows"->{
    Cell[586997, 22915, 361, 13, 16, "Index",
      CellTags->"TakeRows"]},
  "TakeWhile"->{
    Cell[587361, 22930, 348, 13, 16, "Index",
      CellTags->"TakeWhile"]},
  "Temperature scales"->{
    Cell[587712, 22945, 388, 14, 16, "Index",
      CellTags->"Temperature scales"]},
  "TemperedChromatic"->{
    Cell[588103, 22961, 340, 13, 16, "Index",
      CellTags->"TemperedChromatic"]},
  "TemperedMajor"->{
    Cell[588446, 22976, 332, 13, 16, "Index",
      CellTags->"TemperedMajor"]},
  "TemperedMinor"->{
    Cell[588781, 22991, 332, 13, 16, "Index",
      CellTags->"TemperedMinor"]},
  "TermIncrement"->{
    Cell[589116, 23006, 379, 13, 16, "Index",
      CellTags->"TermIncrement"]},
  "Terms"->{
    Cell[589498, 23021, 785, 29, 16, "Index",
      CellTags->"Terms"]},
  "Tessellation"->{
    Cell[590286, 23052, 353, 12, 16, "Index",
      CellTags->"Tessellation"]},
  "Testing hypotheses"->{
    Cell[590642, 23066, 341, 12, 16, "Index",
      CellTags->"Testing hypotheses"]},
  "TetrahedralGraph"->{
    Cell[590986, 23080, 361, 13, 16, "Index",
      CellTags->"TetrahedralGraph"]},
  "Tetrahedron"->{
    Cell[591350, 23095, 551, 21, 16, "Index",
      CellTags->"Tetrahedron"]},
  "TextListPlot"->{
    Cell[591904, 23118, 326, 13, 16, "Index",
      CellTags->"TextListPlot"]},
  "ThermalConductivity"->{
    Cell[592233, 23133, 377, 13, 16, "Index",
      CellTags->"ThermalConductivity"]},
  "ThermalConductivityCoefficient"->{
    Cell[592613, 23148, 405, 13, 16, "Index",
      CellTags->"ThermalConductivityCoefficient"]},
  "Theta functions"->{
    Cell[593021, 23163, 329, 12, 16, "Index",
      CellTags->"Theta functions"]},
  "Thick"->{
    Cell[593353, 23177, 339, 13, 16, "Index",
      CellTags->"Thick"]},
  "ThickDashed"->{
    Cell[593695, 23192, 351, 13, 16, "Index",
      CellTags->"ThickDashed"]},
  "Thiessen polygons"->{
    Cell[594049, 23207, 363, 12, 16, "Index",
      CellTags->"Thiessen polygons"]},
  "Thin"->{
    Cell[594415, 23221, 337, 13, 16, "Index",
      CellTags->"Thin"]},
  "ThinDashed"->{
    Cell[594755, 23236, 349, 13, 16, "Index",
      CellTags->"ThinDashed"]},
  "ThomassenGraph"->{
    Cell[595107, 23251, 357, 13, 16, "Index",
      CellTags->"ThomassenGraph"]},
  "ThomsonCrossSection"->{
    Cell[595467, 23266, 380, 13, 16, "Index",
      CellTags->"ThomsonCrossSection"]},
  "Three-dimensional graphics"->{
    Cell[595850, 23281, 357, 12, 16, "Index",
      CellTags->"Three-dimensional graphics"]},
  "ThreeScript"->{
    Cell[596210, 23295, 331, 13, 16, "Index",
      CellTags->"ThreeScript"]},
  "ThreeScript package"->{
    Cell[596544, 23310, 347, 13, 16, "Index",
      CellTags->"ThreeScript package"]},
  "Tick marks"->{
    Cell[596894, 23325, 566, 22, 16, "Index",
      CellTags->"Tick marks"]},
  "Ticks"->{
    Cell[597463, 23349, 312, 13, 16, "Index",
      CellTags->"Ticks"]},
  "TileAreas"->{
    Cell[597778, 23364, 371, 13, 16, "Index",
      CellTags->"TileAreas"]},
  "Timing"->{
    Cell[598152, 23379, 315, 13, 16, "Index",
      CellTags->"Timing"]},
  "ToAdjacencyLists"->{
    Cell[598470, 23394, 613, 21, 16, "Index",
      CellTags->"ToAdjacencyLists"]},
  "ToAdjacencyMatrix"->{
    Cell[599086, 23417, 363, 13, 16, "Index",
      CellTags->"ToAdjacencyMatrix"]},
  "ToAuthalicRadius"->{
    Cell[599452, 23432, 344, 13, 16, "Index",
      CellTags->"ToAuthalicRadius"]},
  "ToCanonicalSetPartition"->{
    Cell[599799, 23447, 375, 13, 16, "Index",
      CellTags->"ToCanonicalSetPartition"]},
  "ToCycles"->{
    Cell[600177, 23462, 597, 21, 16, "Index",
      CellTags->"ToCycles"]},
  "ToDegrees"->{
    Cell[600777, 23485, 330, 13, 16, "Index",
      CellTags->"ToDegrees"]},
  "ToDMS"->{
    Cell[601110, 23500, 322, 13, 16, "Index",
      CellTags->"ToDMS"]},
  "ToElementCode"->{
    Cell[601435, 23515, 337, 13, 16, "Index",
      CellTags->"ToElementCode"]},
  "ToInversionVector"->{
    Cell[601775, 23530, 363, 13, 16, "Index",
      CellTags->"ToInversionVector"]},
  "ToMinutes"->{
    Cell[602141, 23545, 338, 13, 16, "Index",
      CellTags->"ToMinutes"]},
  "ToOrderedPairs"->{
    Cell[602482, 23560, 609, 21, 16, "Index",
      CellTags->"ToOrderedPairs"]},
  "TopologicalSort"->{
    Cell[603094, 23583, 611, 21, 16, "Index",
      CellTags->"TopologicalSort"]},
  "ToQuaternion"->{
    Cell[603708, 23606, 330, 13, 16, "Index",
      CellTags->"ToQuaternion"]},
  "Toroidal"->{
    Cell[604041, 23621, 334, 13, 16, "Index",
      CellTags->"Toroidal"]},
  "Torus"->{
    Cell[604378, 23636, 304, 13, 16, "Index",
      CellTags->"Torus"]},
  "TotalPower"->{
    Cell[604685, 23651, 365, 13, 16, "Index",
      CellTags->"TotalPower"]},
  "TotalVariation"->{
    Cell[605053, 23666, 390, 13, 16, "Index",
      CellTags->"TotalVariation"]},
  "ToUnorderedPairs"->{
    Cell[605446, 23681, 361, 13, 16, "Index",
      CellTags->"ToUnorderedPairs"]},
  "Transformation"->{
    Cell[605810, 23696, 356, 11, 16, "Index",
      CellTags->"Transformation"],
    Cell[606169, 23709, 639, 20, 16, "IndexSubentry",
      CellTags->"Transformation"]},
  "Transforms"->{
    Cell[606811, 23731, 580, 20, 16, "Index",
      CellTags->"Transforms"],
    Cell[607394, 23753, 329, 12, 16, "IndexSubentry",
      CellTags->"Transforms"]},
  "TransitionProbability"->{
    Cell[607726, 23767, 405, 13, 16, "Index",
      CellTags->"TransitionProbability"]},
  "TransitiveClosure"->{
    Cell[608134, 23782, 363, 13, 16, "Index",
      CellTags->"TransitiveClosure"]},
  "TransitiveQ"->{
    Cell[608500, 23797, 351, 13, 16, "Index",
      CellTags->"TransitiveQ"]},
  "TransitiveReduction"->{
    Cell[608854, 23812, 367, 13, 16, "Index",
      CellTags->"TransitiveReduction"]},
  "TranslateShape"->{
    Cell[609224, 23827, 322, 13, 16, "Index",
      CellTags->"TranslateShape"]},
  "TranslateVertices"->{
    Cell[609549, 23842, 363, 13, 16, "Index",
      CellTags->"TranslateVertices"]},
  "Translation"->{
    Cell[609915, 23857, 376, 14, 16, "Index",
      CellTags->"Translation"]},
  "TransposePartition"->{
    Cell[610294, 23873, 365, 13, 16, "Index",
      CellTags->"TransposePartition"]},
  "TransposeTableau"->{
    Cell[610662, 23888, 361, 13, 16, "Index",
      CellTags->"TransposeTableau"]},
  "TravelingSalesman"->{
    Cell[611026, 23903, 363, 13, 16, "Index",
      CellTags->"TravelingSalesman"]},
  "TravelingSalesmanBounds"->{
    Cell[611392, 23918, 375, 13, 16, "Index",
      CellTags->"TravelingSalesmanBounds"]},
  "Tree"->{
    Cell[611770, 23933, 353, 12, 16, "Index",
      CellTags->"Tree"],
    Cell[612126, 23947, 327, 12, 16, "IndexSubentry",
      CellTags->"Tree"]},
  "Tree package"->{
    Cell[612456, 23961, 324, 13, 16, "Index",
      CellTags->"Tree package"]},
  "TreeFind"->{
    Cell[612783, 23976, 316, 13, 16, "Index",
      CellTags->"TreeFind"]},
  "TreeIsomorphismQ"->{
    Cell[613102, 23991, 361, 13, 16, "Index",
      CellTags->"TreeIsomorphismQ"]},
  "TreePlot"->{
    Cell[613466, 24006, 316, 13, 16, "Index",
      CellTags->"TreePlot"],
    Cell[613785, 24021, 212, 7, 16, "Index",
      CellTags->"TreePlot"]},
  "TreePlot3D"->{
    Cell[614000, 24030, 216, 7, 16, "Index",
      CellTags->"TreePlot3D"]},
  "TreeQ"->{
    Cell[614219, 24039, 339, 13, 16, "Index",
      CellTags->"TreeQ"]},
  "Trees"->{
    Cell[614561, 24054, 341, 14, 16, "Index",
      CellTags->"Trees"],
    Cell[614905, 24070, 338, 14, 16, "IndexSubentry",
      CellTags->"Trees"]},
  "TreeToCertificate"->{
    Cell[615246, 24086, 363, 13, 16, "Index",
      CellTags->"TreeToCertificate"]},
  "TrialDivisionLimit"->{
    Cell[615612, 24101, 344, 13, 16, "Index",
      CellTags->"TrialDivisionLimit"]},
  "Triangle"->{
    Cell[615959, 24116, 548, 21, 16, "Index",
      CellTags->"Triangle"]},
  "TriangleInequalityQ"->{
    Cell[616510, 24139, 367, 13, 16, "Index",
      CellTags->"TriangleInequalityQ"]},
  "TriangularSurfacePlot"->{
    Cell[616880, 24154, 395, 13, 16, "Index",
      CellTags->"TriangularSurfacePlot"]},
  "Triangulation"->{
    Cell[617278, 24169, 441, 14, 32, "Index",
      CellTags->"Triangulation"]},
  "Tridiagonal package"->{
    Cell[617722, 24185, 362, 13, 16, "Index",
      CellTags->"Tridiagonal package"]},
  "TridiagonalMatrix"->{
    Cell[618087, 24200, 381, 13, 16, "Index",
      CellTags->"TridiagonalMatrix"]},
  "TridiagonalSolve"->{
    Cell[618471, 24215, 356, 13, 16, "Index",
      CellTags->"TridiagonalSolve"]},
  "TrigFit"->{
    Cell[618830, 24230, 326, 13, 16, "Index",
      CellTags->"TrigFit"]},
  "TrigFit package"->{
    Cell[619159, 24245, 342, 13, 16, "Index",
      CellTags->"TrigFit package"]},
  "Trigonometric approximation"->{
    Cell[619504, 24260, 344, 12, 16, "Index",
      CellTags->"Trigonometric approximation"]},
  "TrimmedMean"->{
    Cell[619851, 24274, 650, 21, 32, "Index",
      CellTags->"TrimmedMean"]},
  "TrimPoints"->{
    Cell[620504, 24297, 373, 13, 16, "Index",
      CellTags->"TrimPoints"]},
  "Truncate"->{
    Cell[620880, 24312, 319, 13, 16, "Index",
      CellTags->"Truncate"]},
  "Truncation"->{
    Cell[621202, 24327, 367, 13, 16, "Index",
      CellTags->"Truncation"]},
  "Tukey"->{
    Cell[621572, 24342, 309, 13, 16, "Index",
      CellTags->"Tukey"]},
  "Turan"->{
    Cell[621884, 24357, 339, 13, 16, "Index",
      CellTags->"Turan"]},
  "TutteGraph"->{
    Cell[622226, 24372, 349, 13, 16, "Index",
      CellTags->"TutteGraph"]},
  "TwoColoring"->{
    Cell[622578, 24387, 351, 13, 16, "Index",
      CellTags->"TwoColoring"]},
  "TwoSided"->{
    Cell[622932, 24402, 343, 13, 16, "Index",
      CellTags->"TwoSided"]},
  "Ulp"->{
    Cell[623598, 24431, 327, 13, 16, "Index",
      CellTags->"Ulp"]},
  "Unbiased estimate"->{
    Cell[623928, 24446, 429, 14, 16, "Index",
      CellTags->"Unbiased estimate"],
    Cell[624360, 24462, 1658, 50, 80, "IndexSubentry",
      CellTags->"Unbiased estimate"]},
  "Undecagon"->{
    Cell[626021, 24514, 321, 13, 16, "Index",
      CellTags->"Undecagon"]},
  "Undirected"->{
    Cell[626345, 24529, 349, 13, 16, "Index",
      CellTags->"Undirected"]},
  "UndirectedQ"->{
    Cell[626697, 24544, 351, 13, 16, "Index",
      CellTags->"UndirectedQ"]},
  "UniformDistribution"->{
    Cell[627051, 24559, 389, 13, 16, "Index",
      CellTags->"UniformDistribution"]},
  "UnionSet"->{
    Cell[627443, 24574, 345, 13, 16, "Index",
      CellTags->"UnionSet"]},
  "Uniquely3ColorableGraph"->{
    Cell[627791, 24589, 375, 13, 16, "Index",
      CellTags->"Uniquely3ColorableGraph"]},
  "Unit in the last place"->{
    Cell[628169, 24604, 376, 14, 16, "Index",
      CellTags->"Unit in the last place"]},
  "UnitQuaternionQ"->{
    Cell[628548, 24620, 338, 13, 16, "Index",
      CellTags->"UnitQuaternionQ"]},
  "UnitQuaternions"->{
    Cell[628889, 24635, 338, 13, 16, "Index",
      CellTags->"UnitQuaternions"]},
  "UnitransitiveGraph"->{
    Cell[629230, 24650, 365, 13, 16, "Index",
      CellTags->"UnitransitiveGraph"]},
  "Units"->{
    Cell[629598, 24665, 351, 14, 16, "Index",
      CellTags->"Units"]},
  "Units package"->{
    Cell[629952, 24681, 332, 13, 16, "Index",
      CellTags->"Units package"]},
  "UnrankBinarySubset"->{
    Cell[630287, 24696, 365, 13, 16, "Index",
      CellTags->"UnrankBinarySubset"]},
  "UnrankGrayCodeSubset"->{
    Cell[630655, 24711, 369, 13, 16, "Index",
      CellTags->"UnrankGrayCodeSubset"]},
  "UnrankKSetPartition"->{
    Cell[631027, 24726, 367, 13, 16, "Index",
      CellTags->"UnrankKSetPartition"]},
  "UnrankKSubset"->{
    Cell[631397, 24741, 355, 13, 16, "Index",
      CellTags->"UnrankKSubset"]},
  "UnrankPermutation"->{
    Cell[631755, 24756, 363, 13, 16, "Index",
      CellTags->"UnrankPermutation"]},
  "UnrankRGF"->{
    Cell[632121, 24771, 347, 13, 16, "Index",
      CellTags->"UnrankRGF"]},
  "UnrankSetPartition"->{
    Cell[632471, 24786, 365, 13, 16, "Index",
      CellTags->"UnrankSetPartition"]},
  "UnrankSubset"->{
    Cell[632839, 24801, 605, 21, 16, "Index",
      CellTags->"UnrankSubset"]},
  "UnweightedQ"->{
    Cell[633447, 24824, 351, 13, 16, "Index",
      CellTags->"UnweightedQ"]},
  "UpperDiagonalMatrix"->{
    Cell[633801, 24839, 385, 13, 16, "Index",
      CellTags->"UpperDiagonalMatrix"]},
  "UpperLeft"->{
    Cell[634189, 24854, 347, 13, 16, "Index",
      CellTags->"UpperLeft"]},
  "UpperRight"->{
    Cell[634539, 24869, 349, 13, 16, "Index",
      CellTags->"UpperRight"]},
  "V"->{
    Cell[635263, 24898, 583, 21, 16, "Index",
      CellTags->"V"]},
  "VacuumPermeability"->{
    Cell[635849, 24921, 378, 13, 16, "Index",
      CellTags->"VacuumPermeability"]},
  "VacuumPermittivity"->{
    Cell[636230, 24936, 378, 13, 16, "Index",
      CellTags->"VacuumPermittivity"]},
  "VacuumWavelength"->{
    Cell[636611, 24951, 395, 13, 16, "Index",
      CellTags->"VacuumWavelength"]},
  "Vaporization"->{
    Cell[637009, 24966, 398, 14, 16, "Index",
      CellTags->"Vaporization"]},
  "Variance"->{
    Cell[637410, 24982, 582, 20, 16, "Index",
      CellTags->"Variance"],
    Cell[637995, 25004, 2008, 61, 64, "Index",
      CellTags->"Variance"]},
  "VarianceCI"->{
    Cell[640006, 25067, 361, 13, 16, "Index",
      CellTags->"VarianceCI"]},
  "VarianceInflation"->{
    Cell[640370, 25082, 589, 21, 16, "Index",
      CellTags->"VarianceInflation"]},
  "VarianceMLE"->{
    Cell[640962, 25105, 652, 21, 32, "Index",
      CellTags->"VarianceMLE"]},
  "VarianceOfSampleMean"->{
    Cell[641617, 25128, 670, 21, 32, "Index",
      CellTags->"VarianceOfSampleMean"]},
  "VarianceRatioCI"->{
    Cell[642290, 25151, 371, 13, 16, "Index",
      CellTags->"VarianceRatioCI"]},
  "VarianceRatioTest"->{
    Cell[642664, 25166, 363, 13, 16, "Index",
      CellTags->"VarianceRatioTest"]},
  "VarianceTest"->{
    Cell[643030, 25181, 353, 13, 16, "Index",
      CellTags->"VarianceTest"]},
  "Variational methods"->{
    Cell[643386, 25196, 346, 12, 16, "Index",
      CellTags->"Variational methods"]},
  "VariationalBound"->{
    Cell[643735, 25210, 364, 13, 16, "Index",
      CellTags->"VariationalBound"]},
  "VariationalD"->{
    Cell[644102, 25225, 354, 13, 16, "Index",
      CellTags->"VariationalD"]},
  "VariationalMethods package"->{
    Cell[644459, 25240, 382, 13, 16, "Index",
      CellTags->"VariationalMethods package"]},
  "Vector fields"->{
    Cell[644844, 25255, 337, 12, 16, "Index",
      CellTags->"Vector fields"],
    Cell[645184, 25269, 694, 24, 32, "IndexSubentry",
      CellTags->"Vector fields"]},
  "Vector product"->{
    Cell[645881, 25295, 399, 14, 16, "Index",
      CellTags->"Vector product"]},
  "Vector space"->{
    Cell[646283, 25311, 344, 12, 16, "Index",
      CellTags->"Vector space"]},
  "VectorAnalysis package"->{
    Cell[646630, 25325, 362, 13, 16, "Index",
      CellTags->"VectorAnalysis package"]},
  "VectorHeads"->{
    Cell[646995, 25340, 331, 13, 16, "Index",
      CellTags->"VectorHeads"]},
  "Vectors"->{
    Cell[647329, 25355, 371, 14, 16, "Index",
      CellTags->"Vectors"]},
  "VertexColor"->{
    Cell[647703, 25371, 351, 13, 16, "Index",
      CellTags->"VertexColor"]},
  "VertexColoring"->{
    Cell[648057, 25386, 357, 13, 16, "Index",
      CellTags->"VertexColoring"]},
  "VertexConnectivity"->{
    Cell[648417, 25401, 617, 21, 16, "Index",
      CellTags->"VertexConnectivity"]},
  "VertexConnectivityGraph"->{
    Cell[649037, 25424, 375, 13, 16, "Index",
      CellTags->"VertexConnectivityGraph"]},
  "VertexCover"->{
    Cell[649415, 25439, 351, 13, 16, "Index",
      CellTags->"VertexCover"]},
  "VertexCoverQ"->{
    Cell[649769, 25454, 353, 13, 16, "Index",
      CellTags->"VertexCoverQ"]},
  "VertexLabel"->{
    Cell[650125, 25469, 351, 13, 16, "Index",
      CellTags->"VertexLabel"]},
  "VertexLabelColor"->{
    Cell[650479, 25484, 361, 13, 16, "Index",
      CellTags->"VertexLabelColor"]},
  "VertexLabelPosition"->{
    Cell[650843, 25499, 367, 13, 16, "Index",
      CellTags->"VertexLabelPosition"]},
  "VertexList"->{
    Cell[651213, 25514, 216, 7, 16, "Index",
      CellTags->"VertexList"]},
  "VertexNumber"->{
    Cell[651432, 25523, 605, 21, 16, "Index",
      CellTags->"VertexNumber"]},
  "VertexNumberColor"->{
    Cell[652040, 25546, 363, 13, 16, "Index",
      CellTags->"VertexNumberColor"]},
  "VertexNumberPosition"->{
    Cell[652406, 25561, 369, 13, 16, "Index",
      CellTags->"VertexNumberPosition"]},
  "VertexStyle"->{
    Cell[652778, 25576, 351, 13, 16, "Index",
      CellTags->"VertexStyle"]},
  "VertexWeight"->{
    Cell[653132, 25591, 353, 13, 16, "Index",
      CellTags->"VertexWeight"]},
  "Vertical"->{
    Cell[653488, 25606, 310, 13, 16, "Index",
      CellTags->"Vertical"]},
  "Vertices"->{
    Cell[653801, 25621, 1277, 45, 32, "Index",
      CellTags->"Vertices"]},
  "viewpoint 3-Script command"->{
    Cell[655081, 25668, 369, 13, 16, "Index",
      CellTags->"viewpoint 3-Script command"]},
  "Volume"->{
    Cell[655453, 25683, 315, 13, 16, "Index",
      CellTags->"Volume"]},
  "Voronoi polygons"->{
    Cell[655771, 25698, 361, 12, 16, "Index",
      CellTags->"Voronoi polygons"]},
  "WaltherGraph"->{
    Cell[656763, 25734, 353, 13, 16, "Index",
      CellTags->"WaltherGraph"]},
  "Waveform"->{
    Cell[657119, 25749, 322, 13, 16, "Index",
      CellTags->"Waveform"]},
  "WavelengthAbsorptionMap"->{
    Cell[657444, 25764, 409, 13, 16, "Index",
      CellTags->"WavelengthAbsorptionMap"]},
  "Weak"->{
    Cell[657856, 25779, 337, 13, 16, "Index",
      CellTags->"Weak"]},
  "WeaklyConnectedComponents"->{
    Cell[658196, 25794, 379, 13, 16, "Index",
      CellTags->"WeaklyConnectedComponents"]},
  "WeakMixingAngle"->{
    Cell[658578, 25809, 372, 13, 16, "Index",
      CellTags->"WeakMixingAngle"]},
  "Wedge product"->{
    Cell[658953, 25824, 397, 14, 16, "Index",
      CellTags->"Wedge product"]},
  "WeibullDistribution"->{
    Cell[659353, 25840, 389, 13, 16, "Index",
      CellTags->"WeibullDistribution"]},
  "Weighted least-squares fitting"->{
    Cell[659745, 25855, 378, 12, 16, "Index",
      CellTags->"Weighted least-squares fitting"]},
  "WeightingFunction"->{
    Cell[660126, 25869, 363, 13, 16, "Index",
      CellTags->"WeightingFunction"]},
  "WeightRange"->{
    Cell[660492, 25884, 351, 13, 16, "Index",
      CellTags->"WeightRange"]},
  "Weights, in Gaussian quadrature"->{
    Cell[660846, 25899, 440, 14, 16, "Index",
      CellTags->"Weights, in Gaussian quadrature"]},
  "Weights, in Newton-Cotes quadrature"->{
    Cell[661289, 25915, 428, 14, 16, "Index",
      CellTags->"Weights, in Newton-Cotes quadrature"]},
  "Weights"->{
    Cell[661720, 25931, 812, 29, 16, "Index",
      CellTags->"Weights"]},
  "Wheel"->{
    Cell[662535, 25962, 591, 21, 16, "Index",
      CellTags->"Wheel"]},
  "WhichRootOfUnity"->{
    Cell[663129, 25985, 385, 13, 16, "Index",
      CellTags->"WhichRootOfUnity"]},
  "Width"->{
    Cell[663517, 26000, 361, 14, 16, "Index",
      CellTags->"Width"]},
  "WireFrame"->{
    Cell[663881, 26016, 314, 13, 16, "Index",
      CellTags->"WireFrame"]},
  "WishartDistribution"->{
    Cell[664198, 26031, 389, 13, 16, "Index",
      CellTags->"WishartDistribution"]},
  "WorkingPrecision"->{
    Cell[664590, 26046, 2286, 77, 64, "Index",
      CellTags->"WorkingPrecision"]},
  "WorldBackground"->{
    Cell[666879, 26125, 350, 13, 16, "Index",
      CellTags->"WorldBackground"]},
  "WorldBorders"->{
    Cell[667232, 26140, 344, 13, 16, "Index",
      CellTags->"WorldBorders"]},
  "WorldClipping"->{
    Cell[667579, 26155, 346, 13, 16, "Index",
      CellTags->"WorldClipping"]},
  "WorldCountries"->{
    Cell[667928, 26170, 348, 13, 16, "Index",
      CellTags->"WorldCountries"]},
  "WorldDatabase"->{
    Cell[668279, 26185, 346, 13, 16, "Index",
      CellTags->"WorldDatabase"]},
  "WorldFrame"->{
    Cell[668628, 26200, 340, 13, 16, "Index",
      CellTags->"WorldFrame"]},
  "WorldFrameParts"->{
    Cell[668971, 26215, 350, 13, 16, "Index",
      CellTags->"WorldFrameParts"]},
  "WorldGraphics"->{
    Cell[669324, 26230, 346, 13, 16, "Index",
      CellTags->"WorldGraphics"]},
  "WorldGrid"->{
    Cell[669673, 26245, 338, 13, 16, "Index",
      CellTags->"WorldGrid"]},
  "WorldGridBehind"->{
    Cell[670014, 26260, 350, 13, 16, "Index",
      CellTags->"WorldGridBehind"]},
  "WorldGridStyle"->{
    Cell[670367, 26275, 348, 13, 16, "Index",
      CellTags->"WorldGridStyle"]},
  "WorldPlot"->{
    Cell[670718, 26290, 577, 21, 16, "Index",
      CellTags->"WorldPlot"]},
  "WorldPlot package"->{
    Cell[671298, 26313, 352, 13, 16, "Index",
      CellTags->"WorldPlot package"]},
  "WorldPoints"->{
    Cell[671653, 26328, 342, 13, 16, "Index",
      CellTags->"WorldPoints"]},
  "WorldProjection"->{
    Cell[671998, 26343, 350, 13, 16, "Index",
      CellTags->"WorldProjection"]},
  "WorldRange"->{
    Cell[672351, 26358, 340, 13, 16, "Index",
      CellTags->"WorldRange"]},
  "WorldRotatedRange"->{
    Cell[672694, 26373, 354, 13, 16, "Index",
      CellTags->"WorldRotatedRange"]},
  "WorldRotation"->{
    Cell[673051, 26388, 346, 13, 16, "Index",
      CellTags->"WorldRotation"]},
  "WorldToGraphics"->{
    Cell[673400, 26403, 350, 13, 16, "Index",
      CellTags->"WorldToGraphics"]},
  "YIQColor"->{
    Cell[674360, 26446, 310, 13, 16, "Index",
      CellTags->"YIQColor"]},
  "Young tableaux"->{
    Cell[674673, 26461, 335, 12, 16, "Index",
      CellTags->"Young tableaux"]},
  "YuleDissimilarity"->{
    Cell[675312, 26489, 288, 10, 16, "Index",
      CellTags->"YuleDissimilarity"]},
  "Zero finding"->{
    Cell[675603, 26501, 347, 12, 16, "Index",
      CellTags->"Zero finding"]},
  "ZeroMatrix"->{
    Cell[675953, 26515, 367, 13, 16, "Index",
      CellTags->"ZeroMatrix"]},
  "ZeroMean"->{
    Cell[676323, 26530, 648, 21, 16, "Index",
      CellTags->"ZeroMean"]},
  "$CityFields"->{
    Cell[677294, 26567, 339, 13, 16, "Index",
      CellTags->"$CityFields"]},
  "$Context"->{
    Cell[677636, 26582, 299, 12, 16, "Index",
      CellTags->"$Context"]},
  "$ContextPath"->{
    Cell[677938, 26596, 307, 12, 16, "Index",
      CellTags->"$ContextPath"]},
  "$MachineEpsilon"->{
    Cell[678248, 26610, 351, 13, 16, "Index",
      CellTags->"$MachineEpsilon"]},
  "$MemoryIncrement"->{
    Cell[678602, 26625, 353, 13, 16, "Index",
      CellTags->"$MemoryIncrement"]},
  "$Packages"->{
    Cell[678958, 26640, 195, 8, 16, "Index",
      CellTags->"$Packages"]},
  "$Post"->{
    Cell[679156, 26650, 325, 13, 16, "Index",
      CellTags->"$Post"]},
  "$RungeKuttaMethod"->{
    Cell[679484, 26665, 348, 13, 16, "Index",
      CellTags->"$RungeKuttaMethod"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 680821, 26711},
  {"<<", 680917, 26714},
  {".m files", 680998, 26717},
  {"Abbreviation", 681088, 26720},
  {"Abs", 681174, 26723},
  {"Abscissa", 681257, 26726},
  {"AbsIJK", 681420, 26731},
  {"Absolute", 681505, 26734},
  {"AccelerationDueToGravity", 681608, 26737},
  {"Accuracy", 681711, 26740},
  {"AccuracyGoal", 681802, 26743},
  {"AcyclicQ", 681894, 26746},
  {"AddEdge", 681981, 26749},
  {"AddEdges", 682068, 26752},
  {"AddVertex", 682156, 26755},
  {"AddVertices", 682247, 26758},
  {"Adjacency lists", 682344, 26761},
  {"Adjacency matrices", 682448, 26764},
  {"AdjustedRSquared", 682553, 26767},
  {"AdjustedSignIJK", 682656, 26770},
  {"AffineRationalize", 682759, 26773},
  {"AffineShape", 682858, 26776},
  {"AgeOfUniverse", 682953, 26779},
  {"Agglomerate", 683048, 26782},
  {"AirWavelength", 683144, 26785},
  {"Algebraic extension fields", 683254, 26788},
  {"Algebraic inequalities", 683373, 26791},
  {"Algebraic numbers", 683484, 26794},
  {"AlgebraicInequalities package", 683601, 26797},
  {"Algorithm", 683710, 26800},
  {"aliquot sequence", 683807, 26803},
  {"AliquotCycle", 683907, 26806},
  {"AliquotSequence", 684006, 26809},
  {"AllColors", 684102, 26812},
  {"AllPairsShortestPath", 684203, 26815},
  {"AllPoints", 684304, 26818},
  {"AlternatingGroup", 684401, 26821},
  {"AlternatingGroupIndex", 684510, 26824},
  {"AlternatingPaths", 684619, 26827},
  {"ambientlight 3-Script command", 684736, 26830},
  {"AmplitudeModulation", 684856, 26833},
  {"Anagrams", 684955, 26836},
  {"Analysis of variance", 685055, 26839},
  {"Animate", 685155, 26842},
  {"AnimateGraph", 685246, 26845},
  {"Animation", 685340, 26848},
  {"Animation package", 685438, 26851},
  {"Annotation", 685537, 26854},
  {"ANOVA", 685624, 26857},
  {"ANOVATable", 685711, 26860},
  {"AntiSymmetricQ", 685808, 26863},
  {"AppendColumns", 685907, 26866},
  {"AppendRows", 686002, 26869},
  {"Applications directory", 686106, 26872},
  {"Approximate numbers", 686219, 26875},
  {"Approximate polynomials", 686334, 26878},
  {"ApproximateIntervals", 686449, 26881},
  {"ApproximateVertexCover", 686564, 26884},
  {"Approximation of functions", 686684, 26887},
  {"Approximations package", 686805, 26890},
  {"ArcLengthFactor", 686914, 26893},
  {"Area, between curves", 687021, 26896},
  {"Area", 687117, 26899},
  {"Arg", 687197, 26902},
  {"ArgColor", 687281, 26905},
  {"ArgColors package", 687378, 26908},
  {"ArgShade", 687475, 26911},
  {"Arithmetic", 687565, 26914},
  {"Arithmetic parameters", 687668, 26917},
  {"Arrow", 687766, 26920},
  {"Arrow package", 687856, 26923},
  {"ArticulationVertices", 687961, 26926},
  {"AssociationMatrix", 688071, 26929},
  {"Assumptions", 688171, 26932},
  {"AsymptoticCorrelationMatrix", 688281, 26935},
  {"AsymptoticCovarianceMatrix", 688406, 26938},
  {"Atkin-Morain primality certificate", 688538, 26941},
  {"AtmosphericPlot", 688659, 26944},
  {"AtomicData", 688756, 26947},
  {"AtomicNumber", 688850, 26950},
  {"AtomicWeight", 688946, 26953},
  {"Audio package", 689043, 26956},
  {"Autoload directory", 689146, 26959},
  {"Autoloading", 689247, 26962},
  {"Automorphisms", 689344, 26965},
  {"AvogadroConstant", 689445, 26968},
  {"Axes", 689538, 26971},
  {"AxesFront", 689625, 26974},
  {"B", 689708, 26977},
  {"Back", 689786, 26980},
  {"Back substitution", 689880, 26983},
  {"Backtrack", 689979, 26986},
  {"BarChart", 690069, 26989},
  {"BarChart3D", 690160, 26992},
  {"BarEdges", 690251, 26995},
  {"BarEdgeStyle", 690345, 26998},
  {"BarGroupSpacing", 690446, 27001},
  {"BarLabels", 690543, 27004},
  {"BarOrientation", 690640, 27007},
  {"BarSpacing", 690738, 27010},
  {"BarStyle", 690829, 27013},
  {"BarValues", 690920, 27016},
  {"Basis vectors", 691015, 27019},
  {"BasisNames", 691111, 27022},
  {"Begin", 691200, 27025},
  {"BeginPackage", 691290, 27028},
  {"BellB", 691380, 27031},
  {"BellmanFord", 691469, 27034},
  {"Benchmark", 691562, 27037},
  {"BernoulliDistribution", 691665, 27040},
  {"Bessel function zeros", 691780, 27043},
  {"BesselJ", 691881, 27046},
  {"BesselJPrimeYJYPrimeZeros", 691986, 27049},
  {"BesselJPrimeYJYPrimeZerosInterval", 692117, 27052},
  {"BesselJPrimeYPrimeJPrimeYPrimeZeros", 692258, 27055},
  {"BesselJPrimeYPrimeJPrimeYPrimeZerosInterval", 692409, 27058},
  {"BesselJPrimeZeros", 692542, 27061},
  {"BesselJPrimeZerosInterval", 692657, 27064},
  {"BesselJYJYPrimeZeros", 692775, 27067},
  {"BesselJYJYPrimeZerosInterval", 692896, 27070},
  {"BesselJZeros", 693009, 27073},
  {"BesselJZerosInterval", 693114, 27076},
  {"BesselY", 693214, 27079},
  {"BesselYPrimeZeros", 693311, 27082},
  {"BesselYPrimeZerosInterval", 693426, 27085},
  {"BesselYZeros", 693536, 27088},
  {"BesselYZerosInterval", 693641, 27091},
  {"BesselZeros package", 693753, 27094},
  {"BestFit", 693852, 27097},
  {"BestFitParameters", 693950, 27100},
  {"BestFitParametersDelta", 694063, 27103},
  {"BetaDistribution", 694175, 27106},
  {"Bezier", 694270, 27109},
  {"Bezier curves", 694363, 27112},
  {"Bias", 694454, 27115},
  {"BiconnectedComponents", 694553, 27118},
  {"BiconnectedQ", 694660, 27121},
  {"Biharmonic", 694755, 27124},
  {"Binary Gray code", 694854, 27127},
  {"Binary quadratic forms", 694965, 27130},
  {"Binary trees", 695166, 27135},
  {"BinarySearch", 695263, 27138},
  {"BinarySubsets", 695361, 27141},
  {"BinCounts", 695456, 27144},
  {"BinLists", 695546, 27147},
  {"Binomial", 695635, 27150},
  {"BinomialDistribution", 695736, 27153},
  {"BipartiteMatching", 695846, 27156},
  {"BipartiteMatchingAndCover", 695962, 27159},
  {"BipartiteQ", 696070, 27162},
  {"Bipolar", 696160, 27165},
  {"Bispherical", 696251, 27168},
  {"Bivariate statistical distributions", 696370, 27171},
  {"BlackBodyProfile", 696495, 27174},
  {"BlackBodyRadiation package", 696610, 27177},
  {"BlockMatrix", 696720, 27180},
  {"BohrRadius", 696814, 27183},
  {"BoilingPoint", 696909, 27186},
  {"BoltzmannConstant", 697011, 27189},
  {"Bonferroni", 697111, 27192},
  {"BooleanAlgebra", 697208, 27195},
  {"BoundedDiagram", 697309, 27198},
  {"boundingbox 3-Script command", 697424, 27201},
  {"Box", 697528, 27204},
  {"Box plot", 697612, 27207},
  {"Boxes", 697698, 27210},
  {"BoxExtraSpacing", 697791, 27213},
  {"BoxLabels", 697888, 27216},
  {"BoxLineStyle", 697982, 27219},
  {"BoxMedianStyle", 698081, 27222},
  {"BoxOrientation", 698182, 27225},
  {"BoxOutliers", 698280, 27228},
  {"BoxOutlierShapes", 698380, 27231},
  {"BoxQuantile", 698480, 27234},
  {"BoxStyle", 698572, 27237},
  {"BoxWhiskerPlot", 698667, 27240},
  {"Brake", 698759, 27243},
  {"BrayCurtisDistance", 698855, 27246},
  {"Branch cuts", 698958, 27249},
  {"Breadth-first search", 699063, 27252},
  {"BreadthFirstTraversal", 699177, 27255},
  {"Brelaz", 699278, 27258},
  {"BrelazColoring", 699371, 27261},
  {"Bridges", 699465, 27264},
  {"Business graphics", 699563, 27267},
  {"Butcher package", 699669, 27270},
  {"Butcher trees", 699770, 27273},
  {"ButcherAlpha", 699954, 27278},
  {"ButcherBeta", 700050, 27281},
  {"ButcherBetaBar", 700148, 27284},
  {"ButcherColumnConditions", 700258, 27287},
  {"ButcherGamma", 700366, 27290},
  {"ButcherHeight", 700464, 27293},
  {"ButcherOrder", 700562, 27296},
  {"ButcherPhi", 700657, 27299},
  {"ButcherPlot", 700751, 27302},
  {"ButcherPlotColumns", 700853, 27305},
  {"ButcherPlotLabel", 700960, 27308},
  {"ButcherPlotNodeSize", 701068, 27311},
  {"ButcherPlotRootSize", 701179, 27314},
  {"ButcherPrincipalError", 701292, 27317},
  {"ButcherQuadratureConditions", 701413, 27320},
  {"ButcherRowConditions", 701533, 27323},
  {"ButcherSigma", 701638, 27326},
  {"ButcherTreeCount", 701739, 27329},
  {"ButcherTreeQ", 701840, 27332},
  {"ButcherTrees", 701937, 27335},
  {"ButcherTreeSimplify", 702041, 27338},
  {"ButcherWidth", 702145, 27341},
  {"ButterflyGraph", 702244, 27344},
  {"CageGraph", 702340, 27347},
  {"Calculus", 702431, 27350},
  {"Calculus of variations", 702534, 27353},
  {"Calendar", 702637, 27356},
  {"Calendar package", 702734, 27359},
  {"CalendarChange", 702837, 27362},
  {"Calendars", 702933, 27365},
  {"CanberraDistance", 703031, 27368},
  {"Cartesian", 703130, 27371},
  {"CartesianMap", 703224, 27374},
  {"CartesianProduct", 703325, 27377},
  {"Cartography", 703425, 27380},
  {"Cascade", 703516, 27383},
  {"CatalanNumber", 703609, 27386},
  {"CatcherMatrix", 703708, 27389},
  {"CategoryCounts", 703809, 27392},
  {"CategoryLists", 703909, 27395},
  {"Cauchy distribution", 704014, 27398},
  {"Cauchy principal value", 704128, 27401},
  {"Cauchy's integral formula", 704248, 27404},
  {"CauchyDistribution", 704364, 27407},
  {"CauchyPrincipalValue", 704475, 27410},
  {"CauchyPrincipalValue package", 704596, 27413},
  {"CDF", 704700, 27416},
  {"CellMeans", 704786, 27419},
  {"Center", 704874, 27422},
  {"Central limit theorem", 704974, 27425},
  {"CentralMoment", 705081, 27428},
  {"CentsToHertz", 705180, 27431},
  {"Certificate", 705276, 27434},
  {"Certificate of primality", 705385, 27437},
  {"Certificate of primality checking", 705515, 27440},
  {"CGS", 705624, 27443},
  {"ChangeEdges", 705711, 27446},
  {"ChangeVertices", 705809, 27449},
  {"Chaotic behavior", 705912, 27452},
  {"Characteristic", 706015, 27455},
  {"CharacteristicFunction", 706124, 27458},
  {"Charts", 706227, 27461},
  {"Chebyshev approximation", 706408, 27466},
  {"Chemical elements", 706522, 27469},
  {"ChemicalElements package", 706636, 27472},
  {"Chi-square(d)", 706746, 27475},
  {"Chi-square(d) distribution", 706859, 27478},
  {"ChiDistribution", 707072, 27483},
  {"ChineseRemainder", 707176, 27486},
  {"ChiSquareCI", 707276, 27489},
  {"ChiSquareDistribution", 707381, 27492},
  {"ChiSquarePValue", 707491, 27495},
  {"Cholesky package", 707595, 27498},
  {"ChromaticNumber", 707699, 27501},
  {"ChromaticPolynomial", 707806, 27504},
  {"ChvatalGraph", 707910, 27507},
  {"Circle", 708001, 27510},
  {"CirculantGraph", 708242, 27517},
  {"CircularEmbedding", 708347, 27520},
  {"CircumscribedRadius", 708456, 27523},
  {"CityData", 708557, 27526},
  {"CityData package", 708654, 27529},
  {"CityDistance", 708755, 27532},
  {"CityDistanceMethod", 708858, 27535},
  {"CityPosition", 708961, 27538},
  {"ClassicalElectronRadius", 709069, 27541},
  {"ClassList", 709174, 27544},
  {"ClassNumber", 709267, 27547},
  {"CliqueQ", 709358, 27550},
  {"Cluster", 709445, 27553},
  {"ClusterAnalysis", 709541, 27556},
  {"ClusterFlatten", 709643, 27559},
  {"ClusterSplit", 709743, 27562},
  {"Cliques", 709836, 27565},
  {"CMYColor", 709924, 27568},
  {"CMYKColor", 710014, 27571},
  {"CoarserSetPartitionQ", 710116, 27574},
  {"Code", 710213, 27577},
  {"CodeToLabeledTree", 710307, 27580},
  {"CoefficientOfVariation", 710419, 27583},
  {"Coefficients", 710527, 27586},
  {"Cofactor", 710620, 27589},
  {"CollisionFrequency", 710719, 27592},
  {"Color", 710815, 27595},
  {"color 3-Script command", 710992, 27600},
  {"ColorCircle", 711098, 27603},
  {"ColorFunction", 711195, 27606},
  {"colormesh 3-Script command", 711308, 27609},
  {"Colors package", 711421, 27612},
  {"Column", 711514, 27615},
  {"ColumnDrop", 711603, 27618},
  {"ColumnJoin", 711696, 27621},
  {"ColumnTake", 711789, 27624},
  {"Combinations", 711884, 27627},
  {"CombinatorialFunctions package", 711999, 27630},
  {"Combinatorica package", 712123, 27633},
  {"Common Graphics package", 712240, 27636},
  {"Common Statistics packages", 712362, 27639},
  {"Complete integrals", 712479, 27642},
  {"CompleteBinaryTree", 712588, 27645},
  {"CompleteGraph", 712692, 27648},
  {"CompleteIntegral", 712795, 27651},
  {"CompleteKaryTree", 712900, 27654},
  {"CompleteKPartiteGraph", 713010, 27657},
  {"CompleteQ", 713113, 27660},
  {"Complex multiplication", 713217, 27663},
  {"Complex numbers", 713327, 27666},
  {"ComplexExpand", 713516, 27671},
  {"ComplexInequalityPlot", 713623, 27674},
  {"ComplexMap package", 713735, 27677},
  {"ComplexRootIntervals", 713846, 27680},
  {"CompositeBezier", 713954, 27683},
  {"Compositions", 714055, 27686},
  {"Computational geometry", 714239, 27691},
  {"ComputationalGeometry package", 714363, 27694},
  {"Computer arithmetic", 714484, 27697},
  {"ComputerArithmetic package", 714602, 27700},
  {"ComputerNumber", 714716, 27703},
  {"Condition number", 714819, 27706},
  {"Conductivity", 714920, 27709},
  {"Cone", 715009, 27712},
  {"Confidence interval", 715105, 27715},
  {"Confidence level", 715213, 27718},
  {"ConfidenceIntervals package", 715329, 27721},
  {"ConfidenceLevel", 715444, 27724},
  {"Configuration", 715545, 27727},
  {"ConfocalEllipsoidal", 715650, 27730},
  {"ConfocalParaboloidal", 715762, 27733},
  {"Congruences", 715866, 27736},
  {"Conical", 715957, 27739},
  {"Conjugate", 716046, 27742},
  {"ConnectedComponents", 716148, 27745},
  {"ConnectedQ", 716251, 27748},
  {"Constants", 716344, 27751},
  {"Constants of motion", 716445, 27754},
  {"ConstructTableau", 716553, 27757},
  {"Context", 716649, 27760},
  {"Context search path", 716748, 27763},
  {"Contexts", 716848, 27766},
  {"Continued fractions", 717028, 27771},
  {"ContinuedFractionForm", 717141, 27774},
  {"ContinuedFractions", 717253, 27777},
  {"ContinuedFractions package", 717371, 27780},
  {"ContinuousDistributions package", 717502, 27783},
  {"ContourPlot3D", 717621, 27786},
  {"ContourPlot3D package", 717729, 27789},
  {"Contours", 717832, 27792},
  {"ContourStyle", 717927, 27795},
  {"Contract", 718022, 27798},
  {"ContractInterval", 718121, 27801},
  {"Convergents", 718222, 27804},
  {"Conversion", 718317, 27807},
  {"Convert", 718495, 27812},
  {"ConvertTemperature", 718594, 27815},
  {"ConvexHull", 718696, 27818},
  {"ConvexHullArea", 718795, 27821},
  {"ConvexHullMedian", 718899, 27824},
  {"CookD", 718994, 27827},
  {"Coordinate systems", 719092, 27830},
  {"Coordinate transformations", 719302, 27835},
  {"CoordinateRanges", 719418, 27838},
  {"Coordinates", 719519, 27841},
  {"CoordinatesFromCartesian", 719628, 27844},
  {"CoordinatesToCartesian", 719748, 27847},
  {"CoordinateSystem", 719860, 27850},
  {"Coprime", 719957, 27853},
  {"Correlation", 720049, 27856},
  {"CorrelationDissimilarity", 720158, 27859},
  {"CorrelationMatrix", 720274, 27862},
  {"CosineAngleDissimilarity", 720390, 27865},
  {"CosmicBackgroundTemperature", 720516, 27868},
  {"CostOfPath", 720627, 27871},
  {"CountRoots", 720721, 27874},
  {"Covariance", 720815, 27877},
  {"CovarianceMatrix", 720915, 27880},
  {"CovarianceMatrixDetRatio", 721030, 27883},
  {"CovarianceMatrixMLE", 721148, 27886},
  {"CovarianceMatrixOfSampleMean", 721269, 27889},
  {"CovarianceMLE", 721384, 27892},
  {"CoxeterGraph", 721483, 27895},
  {"Cross product", 721582, 27898},
  {"CrossProduct", 721681, 27901},
  {"Cube", 721771, 27904},
  {"CubeConnectedCycle", 721868, 27907},
  {"Cubic", 721965, 27910},
  {"CubicalGraph", 722057, 27913},
  {"Cuboid", 722149, 27916},
  {"Cumulative distribution function", 722261, 27919},
  {"CumulativeSums", 722382, 27922},
  {"Curl", 722474, 27925},
  {"Curve", 722557, 27928},
  {"Curve fitting", 722728, 27933},
  {"CurveCountLimit", 722831, 27936},
  {"CurveNumber", 722931, 27939},
  {"Curves", 723022, 27942},
  {"Curvilinear coordinates", 723275, 27949},
  {"Cycle", 723377, 27952},
  {"CycleIndex", 723467, 27955},
  {"Cycles", 723557, 27958},
  {"CycleStructure", 723651, 27961},
  {"Cyclic", 723745, 27964},
  {"CyclicGroup", 723836, 27967},
  {"CyclicGroupIndex", 723937, 27970},
  {"Cylinder", 724035, 27973},
  {"Cylindrical", 724128, 27976},
  {"D", 724214, 27979},
  {"DampingConstant", 724304, 27982},
  {"Dash", 724397, 27985},
  {"Data", 724479, 27988},
  {"Databases", 724646, 27993},
  {"DataManipulation package", 724753, 27996},
  {"DataSmoothing package", 724872, 27999},
  {"Dates", 724972, 28002},
  {"DayOfWeek", 725060, 28005},
  {"DaysBetween", 725155, 28008},
  {"DaysPlus", 725249, 28011},
  {"de Moivre number", 725348, 28014},
  {"DeBruijnGraph", 725451, 28017},
  {"DeBruijnSequence", 725555, 28020},
  {"Decagon", 725652, 28023},
  {"Decimal expansions", 725751, 28026},
  {"DeclarePackage", 725857, 28029},
  {"Declaring types of numbers", 725972, 28032},
  {"Decorrelate", 726083, 28035},
  {"Degrees", 726175, 28038},
  {"DegreeSequence", 726270, 28041},
  {"DegreesOf2Neighborhood", 726380, 28044},
  {"DelaunayTriangulation", 726497, 28047},
  {"DelaunayTriangulationQ", 726615, 28050},
  {"DeleteCycle", 726722, 28053},
  {"DeleteEdge", 726817, 28056},
  {"DeleteEdges", 726913, 28059},
  {"DeleteFromTableau", 727015, 28062},
  {"DeleteVertex", 727118, 28065},
  {"DeleteVertices", 727218, 28068},
  {"DendrogramPlot", 727320, 28071},
  {"Density", 727416, 28074},
  {"Density function", 727585, 28079},
  {"Depth-first search", 727694, 28082},
  {"DepthFirstTraversal", 727805, 28085},
  {"DerangementQ", 727911, 28088},
  {"Derangements", 728009, 28091},
  {"Derivatives", 728106, 28094},
  {"DescriptiveStatistics package", 728380, 28101},
  {"DesignedRegress", 728499, 28104},
  {"DesignMatrix", 728600, 28107},
  {"DeuteronMagneticMoment", 728708, 28110},
  {"DeuteronMass", 728816, 28113},
  {"DiagonallyImplicit", 728920, 28116},
  {"DiagramPlot", 729023, 28119},
  {"Diagrams", 729117, 28122},
  {"Diameter", 729288, 28127},
  {"DiceDissimilarity", 729387, 28130},
  {"Dictionary", 729489, 28133},
  {"DictionaryWordQ", 729588, 28136},
  {"Differential", 729689, 28139},
  {"Differential equations", 729882, 28144},
  {"Differentiation", 730089, 28149},
  {"Digon", 730183, 28152},
  {"Dihedral", 730270, 28155},
  {"DihedralGroup", 730365, 28158},
  {"DihedralGroupIndex", 730470, 28161},
  {"Dijkstra", 730570, 28164},
  {"DilateVertices", 730666, 28167},
  {"DirectAgglomerate", 730771, 28170},
  {"Directed", 730871, 28173},
  {"Dirichlet cells", 730968, 28176},
  {"DiscreteDistributions package", 731086, 28179},
  {"DiscreteUniformDistribution", 731217, 28182},
  {"Discriminant analysis", 731339, 28185},
  {"Disk", 731438, 28188},
  {"DispersionMatrix", 731532, 28191},
  {"DispersionReport", 731638, 28194},
  {"Display", 731735, 28197},
  {"DisplayFunction", 731912, 28202},
  {"DisplayTogether", 732016, 28205},
  {"DisplayTogetherArray", 732125, 28208},
  {"Distance", 732227, 28211},
  {"DistanceFunction", 732407, 28216},
  {"DistanceMatrix", 732512, 28219},
  {"Distances", 732610, 28222},
  {"DistinctPermutations", 732713, 28225},
  {"Distribution", 732819, 28228},
  {"Distribution function", 732926, 28231},
  {"Distributions", 733035, 28234},
  {"Div", 733213, 28239},
  {"Divergence of vector field", 733316, 28242},
  {"Dodecagon", 733425, 28245},
  {"DodecahedralGraph", 733525, 28248},
  {"Dodecahedron", 733628, 28251},
  {"Domain", 733721, 28254},
  {"DomainQ", 733809, 28257},
  {"DominatingIntegerPartitionQ", 733917, 28260},
  {"DominationLattice", 734035, 28263},
  {"Dot product", 734137, 28266},
  {"DotProduct", 734232, 28269},
  {"DoubleHelix", 734327, 28272},
  {"DropNonNumeric", 734426, 28275},
  {"DropNonNumericColumn", 734534, 28278},
  {"DSolveIntegrals package", 734651, 28281},
  {"DTFourierTransform", 734766, 28284},
  {"Dual", 734862, 28287},
  {"Duncan", 734946, 28290},
  {"Dunnett", 735033, 28293},
  {"DurbinWatsonD", 735127, 28296},
  {"DurfeeSquare", 735227, 28299},
  {"Earth", 735318, 28302},
  {"EarthCrustAbundance", 735416, 28305},
  {"EarthMass", 735518, 28308},
  {"EarthOceanAbundance", 735620, 28311},
  {"EarthRadius", 735724, 28314},
  {"EasterSunday", 735821, 28317},
  {"EasterSundayGreekOrthodox", 735932, 28320},
  {"Eccentricity", 736043, 28323},
  {"EconomizedRationalApproximation", 736161, 28326},
  {"EdgeChromaticNumber", 736285, 28329},
  {"EdgeColor", 736387, 28332},
  {"EdgeColoring", 736482, 28335},
  {"EdgeConnectivity", 736584, 28338},
  {"EdgeDirection", 736688, 28341},
  {"EdgeLabel", 736784, 28344},
  {"EdgeLabelColor", 736881, 28347},
  {"EdgeLabelPosition", 736986, 28350},
  {"Edges", 737082, 28353},
  {"Edges of plot", 737175, 28356},
  {"EdgeStyle", 737271, 28359},
  {"EdgeWeight", 737364, 28362},
  {"EditDistance", 737460, 28365},
  {"EigenstructureTable", 737566, 28368},
  {"ElectronCharge", 737674, 28371},
  {"ElectronComptonWavelength", 737787, 28374},
  {"ElectronConfiguration", 737907, 28377},
  {"ElectronConfigurationFormat", 738029, 28380},
  {"ElectronGFactor", 738145, 28383},
  {"ElectronMagneticMoment", 738256, 28386},
  {"ElectronMass", 738364, 28389},
  {"Element", 738457, 28392},
  {"ElementAbsorptionMap", 738558, 28395},
  {"Elements", 738660, 28398},
  {"ElementToPolynomial", 738761, 28401},
  {"Elimination", 738865, 28404},
  {"Ellipsoid", 738959, 28407},
  {"EllipsoidQuantile", 739060, 28410},
  {"EllipsoidQuartiles", 739169, 28413},
  {"Elliptic curves", 739276, 28416},
  {"EllipticCylindrical", 739385, 28419},
  {"EmptyGraph", 739488, 28422},
  {"EmptyQ", 739579, 28425},
  {"EncroachingListSet", 739677, 28428},
  {"End", 739772, 28431},
  {"EndPackage", 739859, 28434},
  {"EqualVariances", 739957, 28437},
  {"Equations", 740055, 28440},
  {"EquivalenceClasses", 740239, 28445},
  {"EquivalenceRelationQ", 740351, 28448},
  {"Equivalences", 740457, 28451},
  {"EuclideanDistance", 740560, 28454},
  {"Error-correcting codes", 740674, 28457},
  {"ErrorBar", 740778, 28460},
  {"ErrorBarFunction", 740876, 28463},
  {"ErrorListPlot", 740979, 28466},
  {"Errors", 741072, 28469},
  {"EstimatedVariance", 741250, 28474},
  {"Estimates", 741351, 28477},
  {"Estimation accuracy", 741537, 28482},
  {"Euclidean", 741639, 28485},
  {"Euler angles", 741734, 28488},
  {"Euler-Lagrange equations", 741845, 28491},
  {"EulerEquations", 741957, 28494},
  {"Eulerian", 742053, 28497},
  {"EulerianCycle", 742148, 28500},
  {"EulerianQ", 742245, 28503},
  {"EulerRatio", 742338, 28506},
  {"EulerSum", 742430, 28509},
  {"EvenQ", 742517, 28512},
  {"ExactRandomGraph", 742612, 28515},
  {"ExpandGraph", 742713, 28518},
  {"ExpectedValue", 742811, 28521},
  {"Experimental data", 742916, 28524},
  {"Explicit", 743015, 28527},
  {"ExponentialDistribution", 743120, 28530},
  {"ExponentialGeneratingFunction", 743246, 28533},
  {"ExponentialGeneratingFunctionConstants", 743387, 28536},
  {"ExponentialPowerSum", 743518, 28539},
  {"ExponentialSmoothing", 743631, 28542},
  {"ExponentRange", 743738, 28545},
  {"Expressions", 743836, 28548},
  {"ExprPlot", 743929, 28551},
  {"ExtendedGCD", 744022, 28554},
  {"ExtensionDegree", 744123, 28557},
  {"ExtractCycles", 744225, 28560},
  {"ExtraTerms", 744322, 28563},
  {"F distribution", 744420, 28566},
  {"F-ratio distribution", 744616, 28571},
  {"Faces", 744809, 28576},
  {"Factor", 744895, 28579},
  {"Factorial", 744984, 28582},
  {"Factorial2", 745077, 28585},
  {"Factoring", 745170, 28588},
  {"FactorInteger", 745349, 28593},
  {"FactorIntegerECM", 745452, 28596},
  {"FactorIntegerECM package", 745567, 28599},
  {"FactorList", 745675, 28602},
  {"FactorSize", 745769, 28605},
  {"FaradayConstant", 745868, 28608},
  {"FerrersDiagram", 745971, 28611},
  {"Fibonacci", 746069, 28614},
  {"FieldExp", 746160, 28617},
  {"FieldInd", 746250, 28620},
  {"FieldIrreducible", 746348, 28623},
  {"FieldSize", 746447, 28626},
  {"File format", 746541, 28629},
  {"Files", 746631, 28632},
  {"Filled region", 746724, 28635},
  {"FilledListPlot", 746825, 28638},
  {"FilledPlot", 746923, 28641},
  {"FilledPlot package", 747025, 28644},
  {"FilledPlots", 747128, 28647},
  {"Fills", 747218, 28650},
  {"FilterOptions", 747310, 28653},
  {"FilterOptions package", 747418, 28656},
  {"FindClusters", 747525, 28659},
  {"FindCycle", 747621, 28662},
  {"FindIons", 747712, 28665},
  {"FindMinimum", 747805, 28668},
  {"FindPackages", 747902, 28671},
  {"FindRoot", 747996, 28674},
  {"FindSet", 748086, 28677},
  {"FindWords", 748176, 28680},
  {"FineStructureConstant", 748280, 28683},
  {"Finite fields", 748388, 28686},
  {"FiniteFields package", 748495, 28689},
  {"FiniteGraphs", 748601, 28692},
  {"First integrals", 748702, 28695},
  {"FirstIntegral", 748804, 28698},
  {"FirstIntegrals", 748905, 28701},
  {"FirstLexicographicTableau", 749018, 28704},
  {"Fit", 749120, 28707},
  {"FitCurvatureTable", 749216, 28710},
  {"FitResiduals", 749319, 28713},
  {"Fits", 749410, 28716},
  {"Fixed point", 749577, 28721},
  {"Fixed precision arithmetic", 749688, 28724},
  {"Floating-point hardware", 749811, 28727},
  {"FolkmanGraph", 749921, 28730},
  {"Format", 750013, 28733},
  {"Four-dimensional graphics", 750118, 28736},
  {"Fourier summation waveform synthesis", 750253, 28739},
  {"FourierCoefficient", 750381, 28742},
  {"FourierCos", 750484, 28745},
  {"FourierCosCoefficient", 750589, 28748},
  {"FourierSeries", 750697, 28751},
  {"FourierSin", 750794, 28754},
  {"FourierSinCoefficient", 750899, 28757},
  {"FourierTransform package", 751018, 28760},
  {"FourierTrig package", 751135, 28763},
  {"FourierTrigSeries", 751245, 28766},
  {"FranklinGraph", 751349, 28769},
  {"FRatioCI", 751444, 28772},
  {"FRatioDistribution", 751544, 28775},
  {"FRatioPValue", 751649, 28778},
  {"Frequencies", 751746, 28781},
  {"Frequency/pitch equivalents", 751858, 28784},
  {"FrequencyData", 751972, 28787},
  {"FrequencyModulation", 752079, 28790},
  {"FromAdjacencyLists", 752190, 28793},
  {"FromAdjacencyMatrix", 752301, 28796},
  {"FrobeniusF", 752404, 28799},
  {"FrobeniusInstance", 752505, 28802},
  {"FrobeniusSolve", 752610, 28805},
  {"FromContinuedFraction", 752719, 28808},
  {"FromCycles", 752824, 28811},
  {"FromDigits", 752918, 28814},
  {"FromElementCode", 753017, 28817},
  {"FromInversionVector", 753125, 28820},
  {"FromOrderedPairs", 753234, 28823},
  {"FromQuaternion", 753338, 28826},
  {"FromUnorderedPairs", 753444, 28829},
  {"Front", 753541, 28832},
  {"FruchtGraph", 753631, 28835},
  {"FullPath", 753724, 28838},
  {"FullReport", 753816, 28841},
  {"Function values", 753915, 28844},
  {"FunctionalGraph", 754019, 28847},
  {"Functions", 754117, 28850},
  {"FundamentalDiscriminantQ", 754310, 28855},
  {"GalacticUnit", 754420, 28858},
  {"Galois fields", 754519, 28861},
  {"GammaDistribution", 754624, 28864},
  {"Gamut", 754720, 28867},
  {"Gaussian distribution", 754820, 28870},
  {"Gaussian elimination", 755029, 28875},
  {"Gaussian quadrature", 755142, 28878},
  {"GaussianIntegers", 755252, 28881},
  {"GaussianQuadrature package", 755368, 28884},
  {"GaussianQuadratureError", 755491, 28887},
  {"GaussianQuadratureWeights", 755613, 28890},
  {"GCD", 755715, 28893},
  {"Gear ratios", 755803, 28896},
  {"GeneralizedBarChart", 755907, 28899},
  {"GeneralizedPetersenGraph", 756024, 28902},
  {"GeneralizedVariance", 756141, 28905},
  {"GeneralMiniMaxApproximation", 756261, 28908},
  {"GeneralRationalInterpolation", 756390, 28911},
  {"GeneratingFunction", 756510, 28914},
  {"GeneratingFunctionConstants", 756629, 28917},
  {"Geodesate", 756739, 28920},
  {"Geodesy", 756829, 28923},
  {"Geodesy package", 756925, 28926},
  {"GeodeticToAuthalic", 757033, 28929},
  {"Geography", 757134, 28932},
  {"Geometrical characteristics", 757245, 28935},
  {"GeometricDistribution", 757467, 28940},
  {"GeometricMean", 757575, 28943},
  {"Geostatistics", 757676, 28946},
  {"Get (<<)", 757771, 28949},
  {"GetDictionary", 757867, 28952},
  {"GetEdgeLabels", 757967, 28955},
  {"GetEdgeWeights", 758068, 28958},
  {"GetVertexLabels", 758171, 28961},
  {"GetVertexWeights", 758276, 28964},
  {"GF", 758368, 28967},
  {"Girth", 758449, 28970},
  {"Goldwasser-Kilian primality certificate", 758568, 28973},
  {"Grad", 758685, 28976},
  {"Gradient", 758771, 28979},
  {"GramSchmidt", 758946, 28984},
  {"Granularity", 759043, 28987},
  {"Graph connectivity", 759146, 28990},
  {"Graph cycle structure", 759259, 28993},
  {"Graph flow", 759364, 28996},
  {"Graph invariants", 759464, 28999},
  {"Graph theory", 759566, 29002},
  {"GraphCenter", 759663, 29005},
  {"GraphComplement", 759763, 29008},
  {"GraphCoordinates", 759868, 29011},
  {"GraphCoordinates3D", 759976, 29014},
  {"GraphDifference", 760083, 29017},
  {"GraphDistance", 760185, 29020},
  {"GraphicQ", 760280, 29023},
  {"Graphics", 760370, 29026},
  {"Graphics directives", 760627, 29033},
  {"Graphics file format", 760833, 29038},
  {"Graphics package", 760943, 29041},
  {"Graphics primitives", 761052, 29044},
  {"Graphics sequence", 761256, 29049},
  {"Graphics3D package", 761365, 29052},
  {"GraphicsArray", 761470, 29055},
  {"GraphIntersection", 761574, 29058},
  {"GraphJoin", 761674, 29061},
  {"GraphOptions", 761770, 29064},
  {"GraphPlot", 761865, 29067},
  {"GraphPlot package", 761965, 29070},
  {"GraphPlot3D", 762067, 29073},
  {"GraphPolynomial", 762167, 29076},
  {"GraphPower", 762266, 29079},
  {"GraphProduct", 762362, 29082},
  {"Graphs", 762455, 29085},
  {"GraphSum", 762623, 29090},
  {"GraphUnion", 762716, 29093},
  {"GravitationalConstant", 762822, 29096},
  {"GravityAcceleration", 762936, 29099},
  {"GrayCode", 763037, 29102},
  {"GrayCodeKSubsets", 763135, 29105},
  {"GrayCodeSubsets", 763240, 29108},
  {"GrayGraph", 763338, 29111},
  {"GrayLevel", 763430, 29114},
  {"GreatDodecahedron", 763530, 29117},
  {"Greatest common divisor of polynomials", 763659, 29120},
  {"GreatIcosahedron", 763787, 29123},
  {"GreatStellatedDodecahedron", 763903, 29126},
  {"GreedyVertexCover", 764020, 29129},
  {"Grid", 764115, 29132},
  {"GridGraph", 764202, 29135},
  {"HalfNormalDistribution", 764308, 29138},
  {"Hamiltonian", 764415, 29141},
  {"HamiltonianCycle", 764600, 29146},
  {"HamiltonianQ", 764703, 29149},
  {"HankelMatrix", 764801, 29152},
  {"Harary", 764893, 29155},
  {"HarmonicMean", 764985, 29158},
  {"HasseDiagram", 765084, 29161},
  {"HatDiagonal", 765182, 29164},
  {"HeadCenter", 765278, 29167},
  {"HeadLength", 765372, 29170},
  {"HeadScaling", 765467, 29173},
  {"HeadShape", 765561, 29176},
  {"HeadWidth", 765653, 29179},
  {"Heapify", 765743, 29182},
  {"HeapSort", 765832, 29185},
  {"HeatOfFusion", 765926, 29188},
  {"HeatOfVaporization", 766030, 29191},
  {"HeawoodGraph", 766134, 29194},
  {"Height", 766226, 29197},
  {"Helix", 766311, 29200},
  {"Heptagon", 766398, 29203},
  {"HerschelGraph", 766493, 29206},
  {"HertzToCents", 766592, 29209},
  {"Hexagon", 766685, 29212},
  {"Hexahedron", 766776, 29215},
  {"HideCycles", 766870, 29218},
  {"Highlight", 766963, 29221},
  {"HighlightedEdgeColors", 767068, 29224},
  {"HighlightedEdgeStyle", 767183, 29227},
  {"HighlightedVertexColors", 767300, 29230},
  {"HighlightedVertexStyle", 767419, 29233},
  {"HilbertMatrix", 767528, 29236},
  {"Histogram", 767624, 29239},
  {"Histogram3D", 767718, 29242},
  {"HistogramCategories", 767822, 29245},
  {"HistogramRange", 767930, 29248},
  {"Histograms", 768029, 29251},
  {"HistogramScale", 768127, 29254},
  {"HLSColor", 768224, 29257},
  {"Hofstadter", 768316, 29260},
  {"Holidays", 768409, 29263},
  {"Hook length formula", 768511, 29266},
  {"Horizontal", 768615, 29269},
  {"Horner package", 768714, 29272},
  {"HotellingTSquareDistribution", 768831, 29275},
  {"Householder", 768945, 29278},
  {"HubbleConstant", 769045, 29281},
  {"Hue", 769137, 29284},
  {"Hull", 769220, 29287},
  {"Hypercube", 769308, 29290},
  {"HypergeometricDistribution", 769419, 29293},
  {"Hypothesis tests", 769536, 29296},
  {"IcePoint", 769635, 29299},
  {"IcosahedralGraph", 769734, 29302},
  {"Icosahedron", 769836, 29305},
  {"IdealDivide", 769934, 29308},
  {"IdenticalQ", 770030, 29311},
  {"IdentityPermutation", 770134, 29314},
  {"Im", 770230, 29317},
  {"Image sequence", 770321, 29320},
  {"Implicit", 770418, 29323},
  {"Implicit functions", 770519, 29326},
  {"ImplicitPlot", 770625, 29329},
  {"ImplicitPlot package", 770732, 29332},
  {"IncidenceMatrix", 770842, 29335},
  {"IncludeConstant", 770947, 29338},
  {"InDegree", 771045, 29341},
  {"IndependentSetQ", 771143, 29344},
  {"Index", 771238, 29347},
  {"Index files (names files)", 771343, 29350},
  {"InduceSubgraph", 771458, 29353},
  {"Inequalities", 771560, 29356},
  {"Inequality solving", 771751, 29361},
  {"InequalityGraphics package", 771870, 29364},
  {"InequalityPlot", 771985, 29367},
  {"InequalityPlot3D", 772090, 29370},
  {"InequalitySolve", 772196, 29373},
  {"InequalitySolve package", 772309, 29376},
  {"Infinite recursion", 772425, 29379},
  {"Information", 772529, 29382},
  {"init.m files", 772712, 29387},
  {"Initialization files", 772820, 29390},
  {"InitializeUnionFind", 772934, 29393},
  {"Inner products", 773042, 29396},
  {"InnerProduct", 773143, 29399},
  {"InscribedRadius", 773245, 29402},
  {"InsertIntoTableau", 773353, 29405},
  {"IntegerQuaternionQ", 773463, 29408},
  {"Integers", 773564, 29411},
  {"Integrals", 773739, 29416},
  {"Integration", 773834, 29419},
  {"Integration:numerical", 774028, 29424},
  {"InterpolatedQuantile", 774144, 29427},
  {"InterpolateRoot", 774255, 29430},
  {"InterpolateRoot package", 774368, 29433},
  {"InterpolatingFunction", 774487, 29436},
  {"InterpolatingPolynomial", 774693, 29441},
  {"Interpolation", 774805, 29444},
  {"InterquartileRange", 774912, 29447},
  {"Interval, confidence", 775026, 29450},
  {"IntervalBisection", 775138, 29453},
  {"IntervalBoundaries", 775248, 29456},
  {"IntervalCenters", 775356, 29459},
  {"IntervalGraph", 775459, 29462},
  {"IntervalNewton", 775561, 29465},
  {"IntervalRoots package", 775671, 29468},
  {"IntervalSecant", 775781, 29471},
  {"Invariants", 775880, 29474},
  {"InverseDTFourierTransform", 776066, 29479},
  {"InverseFourierCoefficient", 776191, 29482},
  {"InverseMatrixNorm", 776308, 29485},
  {"InversePermutation", 776418, 29488},
  {"InversionPoset", 776526, 29491},
  {"Inversions", 776625, 29494},
  {"InvolutionQ", 776722, 29497},
  {"Involutions", 776819, 29500},
  {"IonizationPotential", 776924, 29503},
  {"IrreduciblePolynomial", 777039, 29506},
  {"Isolating intervals", 777154, 29509},
  {"IsomorphicQ", 777259, 29512},
  {"Isomorphism", 777356, 29515},
  {"IsomorphismQ", 777455, 29518},
  {"Isomorphisms", 777554, 29521},
  {"JaccardDissimilarity", 777661, 29524},
  {"JackknifedVariance", 777775, 29527},
  {"JacobianDeterminant", 777888, 29530},
  {"JacobianMatrix", 777996, 29533},
  {"JacobiSymbol", 778097, 29536},
  {"JewishNewYear", 778198, 29539},
  {"Josephus", 778294, 29542},
  {"JustMajor", 778386, 29545},
  {"KendallRankCorrelation", 778492, 29548},
  {"Kernel initialization files", 778616, 29551},
  {"Keys on plots", 778731, 29554},
  {"Keywords", 778827, 29557},
  {"KinematicViscosity", 778928, 29560},
  {"KineticTemperature", 779039, 29563},
  {"KnightsTourGraph", 779148, 29566},
  {"KnownStandardDeviation", 779261, 29569},
  {"KnownVariance", 779372, 29572},
  {"KroneckerSymbol", 779476, 29575},
  {"KSetPartitions", 779580, 29578},
  {"KSubsetGroup", 779681, 29581},
  {"KSubsetGroupIndex", 779785, 29584},
  {"KSubsets", 779885, 29587},
  {"Kurtosis", 779976, 29590},
  {"LabeledListPlot", 780076, 29593},
  {"LabeledTreeToCode", 780183, 29596},
  {"LabelPoints", 780286, 29599},
  {"Lagrangian", 780382, 29602},
  {"LaplaceDistribution", 780486, 29605},
  {"Laplacian", 780589, 29608},
  {"Large", 780678, 29611},
  {"LastLexicographicTableau", 780782, 29614},
  {"Latitude", 780889, 29617},
  {"Least-squares fitting", 780994, 29620},
  {"LeastPrimeFactor", 781107, 29623},
  {"LeftAssociates", 781212, 29626},
  {"LeftGCD", 781308, 29629},
  {"Legend", 781396, 29632},
  {"LegendBackground", 781493, 29635},
  {"LegendBorder", 781596, 29638},
  {"LegendBorderSpace", 781700, 29641},
  {"LegendLabel", 781803, 29644},
  {"LegendLabelSpace", 781905, 29647},
  {"LegendOrientation", 782013, 29650},
  {"LegendPosition", 782119, 29653},
  {"Legends on plots", 782224, 29656},
  {"Legends package", 782330, 29659},
  {"LegendShadow", 782432, 29662},
  {"LegendSize", 782529, 29665},
  {"LegendSpacing", 782627, 29668},
  {"LegendTextDirection", 782734, 29671},
  {"LegendTextOffset", 782844, 29674},
  {"LegendTextSpace", 782950, 29677},
  {"LengthWhile", 783051, 29680},
  {"Lenstra's elliptic curve method", 783168, 29683},
  {"Level", 783279, 29686},
  {"LeviGraph", 783368, 29689},
  {"LexicographicPermutations", 783477, 29692},
  {"LexicographicSubsets", 783597, 29695},
  {"lightsources 3-Script command", 783721, 29698},
  {"Limit", 783830, 29701},
  {"Limits", 783916, 29704},
  {"line 3-Script command", 784018, 29707},
  {"Linear equations", 784130, 29710},
  {"Linear regression", 784238, 29713},
  {"LinearEquationsToMatrices", 784355, 29716},
  {"LinearFilter", 784467, 29719},
  {"LinearLogListPlot", 784571, 29722},
  {"LinearLogPlot", 784676, 29725},
  {"LinearRegression package", 784788, 29728},
  {"LineGraph", 784896, 29731},
  {"Lines", 784986, 29734},
  {"ListContourPlot3D", 785083, 29737},
  {"ListGraphs", 785185, 29740},
  {"ListIntegrate", 785283, 29743},
  {"ListIntegrate package", 785392, 29746},
  {"ListNecklaces", 785501, 29749},
  {"ListPlot", 785597, 29752},
  {"ListPlot3D", 785774, 29757},
  {"ListPlotVectorField", 785962, 29762},
  {"ListPlotVectorField3D", 786077, 29765},
  {"Lists", 786178, 29768},
  {"ListShadowPlot3D", 786353, 29773},
  {"ListSurfaceOfRevolution", 786467, 29776},
  {"ListSurfacePlot3D", 786582, 29779},
  {"ListWaveform", 786686, 29782},
  {"LNorm", 786778, 29785},
  {"Loading", 786865, 29788},
  {"Loading packages", 786964, 29791},
  {"LocationReport", 787069, 29794},
  {"LogisticDistribution", 787178, 29797},
  {"LogLinearListPlot", 787290, 29800},
  {"LogLinearPlot", 787395, 29803},
  {"LogListPlot", 787494, 29806},
  {"LogLogListPlot", 787594, 29809},
  {"LogLogPlot", 787693, 29812},
  {"LogNormalDistribution", 787799, 29815},
  {"LogPlot", 787902, 29818},
  {"LogSeriesDistribution", 788005, 29821},
  {"LongDash", 788109, 29824},
  {"LongestIncreasingSubsequence", 788220, 29827},
  {"Longitude", 788333, 29830},
  {"LoopPosition", 788430, 29833},
  {"LowerDiagonalMatrix", 788536, 29836},
  {"LowerLeft", 788639, 29839},
  {"LowerRight", 788733, 29842},
  {"LowerStatisticalWeight", 788840, 29845},
  {"LowerTermFineStructureEnergy", 788965, 29848},
  {"LUDecomposition", 789083, 29851},
  {"M", 789174, 29854},
  {"Machine arithmetic", 789269, 29857},
  {"MachineError", 789375, 29860},
  {"MagneticFluxQuantum", 789481, 29863},
  {"Mahalanobis distance", 789595, 29866},
  {"MakeDirected", 789702, 29869},
  {"MakeGraph", 789798, 29872},
  {"MakeSimple", 789893, 29875},
  {"MakeSymbol", 789988, 29878},
  {"MakeTree", 790081, 29881},
  {"MakeUndirected", 790178, 29884},
  {"ManhattanDistance", 790284, 29887},
  {"Manipulation of data", 790397, 29890},
  {"Manipulation of matrices", 790516, 29893},
  {"Manipulation of polynomials over finite fields", 790661, 29896},
  {"Manipulation of trees", 790803, 29899},
  {"Mappings", 790907, 29902},
  {"Maps", 790994, 29905},
  {"Markings", 791081, 29908},
  {"MatchingDissimilarity", 791186, 29911},
  {"MathematicaMark", 791298, 29914},
  {"Matrices", 791396, 29917},
  {"Matrix scatter plot", 791583, 29922},
  {"matrix scatter plot", 791696, 29925},
  {"MatrixConditionNumber", 791811, 29928},
  {"MatrixManipulation package", 791933, 29931},
  {"MatrixPlot", 792045, 29934},
  {"MaxArrowLength", 792144, 29937},
  {"MaxBend", 792241, 29940},
  {"MaximalBipartiteMatching", 792347, 29943},
  {"MaximalIndependentEdgeSet", 792471, 29946},
  {"MaximalIndependentVertexSet", 792598, 29949},
  {"MaximalMatching", 792715, 29952},
  {"Maximum likelihood estimate", 792833, 29955},
  {"MaximumAntichain", 793054, 29960},
  {"MaximumClique", 793158, 29963},
  {"MaximumIndependentSet", 793267, 29966},
  {"MaximumSpanningTree", 793382, 29969},
  {"MaxIterations", 793489, 29972},
  {"MaxMatrixSize", 793591, 29975},
  {"MaxPower", 793687, 29978},
  {"MaxRecursion", 793782, 29981},
  {"MaxTerms", 793877, 29984},
  {"McGeeGraph", 793970, 29987},
  {"Mean", 794059, 29990},
  {"MeanChromatic", 794153, 29993},
  {"MeanCI", 794247, 29996},
  {"MeanDensity", 794339, 29999},
  {"MeanDeviation", 794438, 30002},
  {"MeanDifferenceCI", 794543, 30005},
  {"MeanDifferenceTest", 794652, 30008},
  {"MeanFreePath", 794757, 30011},
  {"MeanMajor", 794853, 30014},
  {"MeanMinor", 794946, 30017},
  {"MeanMolecularWeight", 795049, 30020},
  {"MeanParticleSpeed", 795160, 30023},
  {"MeanPredictionCITable", 795273, 30026},
  {"MeanTest", 795378, 30029},
  {"Median", 795467, 30032},
  {"MedianDeviation", 795636, 30037},
  {"MedianMethod", 795739, 30040},
  {"MeltingPoint", 795839, 30043},
  {"Memory management", 795943, 30046},
  {"MemoryConserve package", 796057, 30049},
  {"MeredithGraph", 796167, 30052},
  {"mesh 3-Script command", 796276, 30055},
  {"MeshRange", 796381, 30058},
  {"Method", 796471, 30061},
  {"Microscope", 796562, 30064},
  {"Microscope package", 796666, 30067},
  {"MicroscopicError", 796776, 30070},
  {"MinCut", 796874, 30073},
  {"Minimax approximation", 796976, 30076},
  {"MiniMaxApproximation", 797092, 30079},
  {"MinimumChainPartition", 797208, 30082},
  {"MinimumChangePermutations", 797329, 30085},
  {"MinimumSpanningTree", 797449, 30088},
  {"MinimumVertexColoring", 797565, 30091},
  {"MinimumVertexCover", 797679, 30094},
  {"MixedMode", 797781, 30097},
  {"MKS", 797868, 30100},
  {"MLE", 797949, 30103},
  {"Mod", 798030, 30106},
  {"Mode", 798112, 30109},
  {"Modular equations", 798209, 30112},
  {"Modulation", 798311, 30115},
  {"ModulationType", 798494, 30120},
  {"Modulus", 798591, 30123},
  {"MoebiusStrip", 798685, 30126},
  {"MolarGasConstant", 798788, 30129},
  {"MolarVolume", 798890, 30132},
  {"MovieContourPlot", 798992, 30135},
  {"MovieDensityPlot", 799099, 30138},
  {"MovieParametricPlot", 799209, 30141},
  {"MoviePlot", 799312, 30144},
  {"MoviePlot3D", 799407, 30147},
  {"MovingAverage", 799506, 30150},
  {"MovingMedian", 799606, 30153},
  {"MultiDescriptiveStatistics package", 799727, 30156},
  {"MultiDiscreteDistributions package", 799870, 30159},
  {"Multinomial", 799990, 30162},
  {"MultinomialDistribution", 800099, 30165},
  {"MultinormalDistribution", 800220, 30168},
  {"MultinormalDistribution package", 800349, 30171},
  {"Multiple curves", 800471, 30174},
  {"Multiple-valued functions", 800586, 30177},
  {"MultipleEdgesQ", 800700, 30180},
  {"MultipleListPlot", 800805, 30183},
  {"MultipleListPlot package", 800920, 30186},
  {"Multiplication", 801033, 30189},
  {"MultiplicationTable", 801141, 30192},
  {"MultiPoissonDistribution", 801259, 30195},
  {"Multivariate statistical distributions", 801396, 30198},
  {"MultivariateKurtosis", 801530, 30201},
  {"MultivariateKurtosisExcess", 801652, 30204},
  {"MultivariateMeanDeviation", 801778, 30207},
  {"MultivariateMedianDeviation", 801905, 30210},
  {"MultivariateMode", 802023, 30213},
  {"MultivariatePearsonSkewness1", 802142, 30216},
  {"MultivariatePearsonSkewness2", 802273, 30219},
  {"MultivariateSkewness", 802396, 30222},
  {"MultivariateTDistribution", 802517, 30225},
  {"MultivariateTrimmedMean", 802640, 30228},
  {"MuonGFactor", 802749, 30231},
  {"MuonMagneticMoment", 802853, 30234},
  {"MuonMass", 802954, 30237},
  {"Music package", 803050, 30240},
  {"MycielskiGraph", 803152, 30243},
  {"myPackage1.m example of package", 803272, 30246},
  {"Names", 803383, 30249},
  {"Names files", 803554, 30254},
  {"NaN", 803644, 30257},
  {"ND", 803724, 30260},
  {"NDTFourierTransform", 803820, 30263},
  {"NearestNeighbor", 803929, 30266},
  {"NecklacePolynomial", 804037, 30269},
  {"Needs", 804135, 30272},
  {"NegativeBinomialDistribution", 804243, 30275},
  {"NegativeMultinomialDistribution", 804377, 30278},
  {"Neighborhood", 804495, 30281},
  {"Neighborhood polygons", 804603, 30284},
  {"NetworkFlow", 804710, 30287},
  {"NeutronComptonWavelength", 804821, 30290},
  {"NeutronMagneticMoment", 804941, 30293},
  {"NeutronMass", 805048, 30296},
  {"Newton-Cotes quadrature", 805157, 30299},
  {"NewtonCotes package", 805274, 30302},
  {"NewtonCotesError", 805384, 30305},
  {"NewtonCotesWeights", 805493, 30308},
  {"NextBinarySubset", 805602, 30311},
  {"NextComposition", 805708, 30314},
  {"NextGrayCodeSubset", 805816, 30317},
  {"NextKSubset", 805920, 30320},
  {"NextLexicographicSubset", 806029, 30323},
  {"NextPartition", 806140, 30326},
  {"NextPermutation", 806243, 30329},
  {"NextPrime", 806342, 30332},
  {"NextSubset", 806436, 30335},
  {"NextTableau", 806532, 30338},
  {"NFourierCoefficient", 806637, 30341},
  {"NFourierCosCoefficient", 806754, 30344},
  {"NFourierCosTransform", 806871, 30347},
  {"NFourierSeries", 806980, 30350},
  {"NFourierSinCoefficient", 807091, 30353},
  {"NFourierSinTransform", 807208, 30356},
  {"NFourierTransform", 807320, 30359},
  {"NFourierTrigSeries", 807430, 30362},
  {"NIntegrate", 807533, 30365},
  {"NIntegrateInterpolatingFunct package", 807731, 30370},
  {"NIntegrateInterpolatingFunction", 807873, 30373},
  {"NInverseDTFourierTransform", 808005, 30376},
  {"NInverseFourierCoefficient", 808132, 30379},
  {"NInverseFourierCosTransform", 808260, 30382},
  {"NInverseFourierSinTransform", 808389, 30385},
  {"NInverseFourierTransform", 808515, 30388},
  {"NLimit", 808620, 30391},
  {"NLimit package", 808715, 30394},
  {"NMinimize package", 808821, 30397},
  {"Nodes", 808918, 30400},
  {"NoMultipleEdges", 809013, 30403},
  {"Nonagon", 809110, 30406},
  {"NoncentralChiSquareDistribution", 809223, 30409},
  {"NoncentralFRatioDistribution", 809357, 30412},
  {"NoncentralStudentTDistribution", 809490, 30415},
  {"Nonlinear regression", 809615, 30418},
  {"NonlinearFit", 809722, 30421},
  {"NonlinearFit package", 809829, 30424},
  {"NonlinearRegress", 809941, 30427},
  {"NonLineGraphs", 810045, 30430},
  {"Nonreal", 810140, 30433},
  {"NoPerfectMatchingGraph", 810244, 30436},
  {"Norm", 810345, 30439},
  {"Normal", 810430, 30442},
  {"NormalCI", 810520, 30445},
  {"NormalDashed", 810615, 30448},
  {"NormalDistribution", 810720, 30451},
  {"NormalDistribution package", 810840, 30454},
  {"Normalize", 810951, 30457},
  {"Normalized", 811046, 30460},
  {"NormalizeVertices", 811148, 30463},
  {"NormalPValue", 811252, 30466},
  {"NoSelfLoops", 811350, 30469},
  {"Not-a-Number", 811448, 30472},
  {"NResidue", 811543, 30475},
  {"NResidue package", 811716, 30480},
  {"NSeries", 811814, 30483},
  {"NSeries package", 811911, 30486},
  {"NSum", 812005, 30489},
  {"NthSubset", 812093, 30492},
  {"Null hypothesis", 812192, 30495},
  {"Number system", 812295, 30498},
  {"NumberDensity", 812396, 30501},
  {"NumberOf2Paths", 812498, 30504},
  {"NumberOfCompositions", 812607, 30507},
  {"NumberOfDerangements", 812722, 30510},
  {"NumberOfDirectedGraphs", 812839, 30513},
  {"NumberOfEdges", 812949, 30516},
  {"NumberOfFaces", 813051, 30519},
  {"NumberOfGraphs", 813154, 30522},
  {"NumberOfInvolutions", 813262, 30525},
  {"NumberOfKPaths", 813370, 30528},
  {"NumberOfNecklaces", 813476, 30531},
  {"NumberOfPartitions", 813586, 30534},
  {"NumberOfPermutationsByCycles", 813707, 30537},
  {"NumberOfPermutationsByInversions", 813842, 30540},
  {"NumberOfPermutationsByType", 813975, 30543},
  {"NumberOfSpanningTrees", 814097, 30546},
  {"NumberOfTableaux", 814210, 30549},
  {"NumberOfVertices", 814318, 30552},
  {"Numbers", 814417, 30555},
  {"NumberTheoryFunctions package", 814529, 30558},
  {"Numerical Fourier functions", 814661, 30561},
  {"Numerical Fourier transforms", 814792, 30564},
  {"OblateSpheroidal", 814911, 30567},
  {"Octagon", 815009, 30570},
  {"OctahedralGraph", 815106, 30573},
  {"Octahedron", 815206, 30576},
  {"OddGraph", 815300, 30579},
  {"OddQ", 815387, 30582},
  {"One", 815469, 30585},
  {"OpenTruncate", 815559, 30588},
  {"Optimum", 815653, 30591},
  {"Options", 815742, 30594},
  {"OrbitInventory", 815838, 30597},
  {"OrbitRepresentatives", 815947, 30600},
  {"Orbits", 816048, 30603},
  {"Order", 816134, 30606},
  {"Order conditions", 816230, 30609},
  {"Ordered", 816328, 30612},
  {"OrderedSumOfSquaresRepresentations", 816444, 30615},
  {"OrderStar", 816562, 30618},
  {"OrderStar package", 816663, 30621},
  {"OrderStarInterpolation", 816777, 30624},
  {"OrderStarKind", 816887, 30627},
  {"OrderStarLegend", 816990, 30630},
  {"OrderStarPoles", 817094, 30633},
  {"OrderStarSubPlots", 817200, 30636},
  {"OrderStarSymbolSize", 817311, 30639},
  {"OrderStarSymbolThickness", 817429, 30642},
  {"OrderStarZeros", 817542, 30645},
  {"Ordinary differential equations", 817662, 30648},
  {"Organization", 817780, 30651},
  {"OrientGraph", 817878, 30654},
  {"Orthogonal basis", 817981, 30657},
  {"Orthogonal coordinates", 818094, 30660},
  {"Orthogonalization package", 818216, 30663},
  {"Orthonormal basis", 818333, 30666},
  {"OscillatorStrength", 818534, 30671},
  {"OutDegree", 818636, 30674},
  {"Outlier detection", 818737, 30677},
  {"outliers", 818838, 30680},
  {"Package package", 818936, 30683},
  {"Packages", 819034, 30686},
  {"Pade", 819207, 30691},
  {"Pade approximation", 819305, 30694},
  {"Pade package", 819410, 30697},
  {"PairGroup", 819507, 30700},
  {"PairGroupIndex", 819605, 30703},
  {"Pairs scatter plot", 819712, 30706},
  {"pairs scatter plot", 819823, 30709},
  {"PairwiseScatterPlot", 819935, 30712},
  {"ParabolicCylindrical", 820050, 30715},
  {"Paraboloidal", 820157, 30718},
  {"Parallel", 820252, 30721},
  {"ParameterBias", 820348, 30724},
  {"ParameterCITable", 820452, 30727},
  {"ParameterConfidenceRegion", 820569, 30730},
  {"ParameterQ", 820680, 30733},
  {"ParameterRanges", 820780, 30736},
  {"Parameters", 820880, 30739},
  {"Parameters of complete integrals", 820997, 30742},
  {"ParameterTable", 821118, 30745},
  {"ParametricPlot", 821222, 30748},
  {"ParametricPlot3D", 821327, 30751},
  {"ParametricPlot3D package", 821443, 30754},
  {"Parent", 821548, 30757},
  {"ParentsToPaths", 821643, 30760},
  {"ParetoDistribution", 821750, 30763},
  {"ParetoPlot", 821853, 30766},
  {"Partial derivatives", 821958, 30769},
  {"Partial differential equations", 822083, 30772},
  {"PartialOrderQ", 822201, 30775},
  {"PartialSumOfSquares", 822309, 30778},
  {"PartitionLattice", 822420, 30781},
  {"PartitionQ", 822521, 30784},
  {"Partitions", 822616, 30787},
  {"Path", 822866, 30794},
  {"PDF", 822949, 30797},
  {"PeakWavelength", 823042, 30800},
  {"PearsonSkewness1", 823147, 30803},
  {"PearsonSkewness2", 823255, 30806},
  {"Pentagon", 823355, 30809},
  {"PercentileBarChart", 823456, 30812},
  {"PerfectQ", 823557, 30815},
  {"PeriodicForm", 823652, 30818},
  {"PermutationGraph", 823755, 30821},
  {"PermutationGroupQ", 823863, 30824},
  {"PermutationQ", 823967, 30827},
  {"Permutations", 824066, 30830},
  {"PermutationToTableaux", 824339, 30837},
  {"PermutationType", 824450, 30840},
  {"PermutationWithCycle", 824560, 30843},
  {"Permute", 824662, 30846},
  {"PermuteSubgraph", 824759, 30849},
  {"PetersenGraph", 824862, 30852},
  {"Phase-gratings", 824964, 30855},
  {"Phi", 825056, 30858},
  {"PhysicalConstants package", 825159, 30861},
  {"PieChart", 825267, 30864},
  {"PieExploded", 825361, 30867},
  {"PieLabels", 825456, 30870},
  {"PieLineStyle", 825552, 30873},
  {"PieStyle", 825647, 30876},
  {"Pitch/frequency equivalents", 825757, 30879},
  {"Planar data", 825870, 30882},
  {"PlanarGraphPlot", 825971, 30885},
  {"PlanarQ", 826069, 30888},
  {"PlanckConstant", 826165, 30891},
  {"PlanckConstantReduced", 826275, 30894},
  {"PlanckMass", 826381, 30897},
  {"PlayRange", 826475, 30900},
  {"Plot", 826563, 30903},
  {"Plot3D", 826648, 30906},
  {"PlotField package", 826826, 30911},
  {"PlotField3D package", 826937, 30914},
  {"PlotFlag", 827039, 30917},
  {"PlotGradientField", 827139, 30920},
  {"PlotGradientField3D", 827250, 30923},
  {"PlotHamiltonianField", 827364, 30926},
  {"PlotJoined", 827469, 30929},
  {"PlotLegend", 827565, 30932},
  {"PlotPoints", 827661, 30935},
  {"PlotPolyaField", 827761, 30938},
  {"PlotRange", 827859, 30941},
  {"Plots", 827948, 30944},
  {"PlotStyle", 828120, 30949},
  {"PlotSymbol", 828215, 30952},
  {"Plotting symbols", 828316, 30955},
  {"PlotVectorField", 828513, 30960},
  {"PlotVectorField3D", 828620, 30963},
  {"Pochhammer", 828722, 30966},
  {"point 3-Script command", 828829, 30969},
  {"Point neighborhood", 828944, 30972},
  {"PointParametricPlot3D", 829058, 30975},
  {"Points", 829160, 30978},
  {"PoissonDistribution", 829341, 30983},
  {"PolarDecomposition", 829453, 30986},
  {"PolarListPlot", 829643, 30991},
  {"PolarMap", 829739, 30994},
  {"PolarPlot", 829831, 30997},
  {"PollardPTest", 829927, 31000},
  {"PollardRhoTest", 830028, 31003},
  {"Polya", 830122, 31006},
  {"Polya representation", 830222, 31009},
  {"Polya theory", 830329, 31012},
  {"Polygon", 830423, 31015},
  {"polygon 3-Script command", 830529, 31018},
  {"Polygons", 830636, 31021},
  {"Polyhedra package", 830819, 31026},
  {"Polyhedron", 830921, 31029},
  {"Polyhedrons", 831017, 31032},
  {"Polynomial approximation", 831127, 31035},
  {"Polynomial inequalities", 831249, 31038},
  {"PolynomialExtendedGCD", 831369, 31041},
  {"PolynomialExtendedGCD package", 831495, 31044},
  {"PolynomialFit", 831612, 31047},
  {"PolynomialFit package", 831721, 31050},
  {"PolynomialGCD", 831830, 31053},
  {"PolynomialMod", 832018, 31058},
  {"PolynomialPowerMod", 832124, 31061},
  {"PolynomialPowerMod package", 832243, 31064},
  {"PolynomialQuotient", 832362, 31067},
  {"PolynomialRemainder", 832474, 31070},
  {"Polynomials", 832579, 31073},
  {"PolynomialToElement", 832770, 31078},
  {"Polytope", 832872, 31081},
  {"PolytopeQuantile", 832972, 31084},
  {"PolytopeQuartiles", 833080, 31087},
  {"Polytopes", 833181, 31090},
  {"Polytopes package", 833282, 31093},
  {"Positions", 833383, 31096},
  {"PostTests", 833476, 31099},
  {"Power", 833565, 31102},
  {"PowerList", 833654, 31105},
  {"PowerListQ", 833748, 31108},
  {"PowerListToField", 833849, 31111},
  {"PowerMod", 833948, 31114},
  {"PowerSum", 834040, 31117},
  {"Pratt's primality certificate", 834152, 31120},
  {"PredictedResponse", 834273, 31123},
  {"PredictedResponseDelta", 834388, 31126},
  {"Pressure", 834494, 31129},
  {"PressureScaleHeight", 834596, 31132},
  {"PreviousPrime", 834703, 31135},
  {"Primality certificate", 834812, 31138},
  {"Primality certificate checking", 834938, 31141},
  {"Primality proving", 835060, 31144},
  {"Primary colors", 835166, 31147},
  {"PrimaryLeftAssociate", 835275, 31150},
  {"PrimaryRightAssociate", 835391, 31153},
  {"Prime", 835492, 31156},
  {"PrimeFactorList", 835737, 31163},
  {"PrimePowerQ", 835838, 31166},
  {"PrimeQ", 835930, 31169},
  {"PrimeQ package", 836026, 31172},
  {"PrimeQCertificate", 836132, 31175},
  {"PrimeQCertificateCheck", 836246, 31178},
  {"PrimeQMessages", 836357, 31181},
  {"Primitive elements", 836464, 31184},
  {"Primitive roots", 836573, 31187},
  {"PrimitiveElement", 836679, 31190},
  {"PrimitiveElement package", 836794, 31193},
  {"PrimitiveRoot", 836906, 31196},
  {"Primitives", 837004, 31199},
  {"Principal branch", 837190, 31204},
  {"PrincipalComponents", 837300, 31207},
  {"PrintFlag", 837403, 31210},
  {"Probability density function", 837515, 31213},
  {"Probability value (p-value)", 837646, 31216},
  {"Product, dot", 837760, 31219},
  {"Project", 837854, 31222},
  {"Projection", 837946, 31225},
  {"Projections", 838043, 31228},
  {"ProjectiveRationalize", 838235, 31233},
  {"ProlateSpheroidal", 838348, 31236},
  {"ProtonComptonWavelength", 838463, 31239},
  {"ProtonMagneticMoment", 838581, 31242},
  {"ProtonMass", 838686, 31245},
  {"ProvablePrimeQ", 838785, 31248},
  {"PseudoDiameter", 838888, 31251},
  {"PseudographQ", 838989, 31254},
  {"PythagoreanChromatic", 839096, 31257},
  {"Quadratic forms", 839206, 31260},
  {"QuadraticFormDistribution", 839321, 31263},
  {"QuadraticIrrationalQ", 839441, 31266},
  {"QuadraticRepresentation", 839559, 31269},
  {"Quadrature", 839667, 31272},
  {"QuadratureType", 839767, 31275},
  {"Quantile", 839864, 31278},
  {"Quantile-quantile plot", 839971, 31281},
  {"QuantileForm", 840080, 31284},
  {"QuantilePlot", 840179, 31287},
  {"QuantizedHallConductance", 840291, 31290},
  {"QuarterTone", 840401, 31293},
  {"QuartileDeviation", 840504, 31296},
  {"Quartiles", 840606, 31299},
  {"QuartileSkewness", 840707, 31302},
  {"Quaternion", 840809, 31305},
  {"QuaternionQ", 840905, 31308},
  {"Quaternions", 841002, 31311},
  {"Quaternions package", 841107, 31314},
  {"RadialEmbedding", 841216, 31317},
  {"Radius", 841312, 31320},
  {"Ramanujan functions", 841413, 31323},
  {"Ramanujan hypothesis", 841527, 31326},
  {"Ramanujan package", 841639, 31329},
  {"RamanujanTau", 841743, 31332},
  {"RamanujanTauDirichletSeries", 841857, 31335},
  {"RamanujanTauGeneratingFunction", 841989, 31338},
  {"RamanujanTauTheta", 842111, 31341},
  {"RamanujanTauZ", 842216, 31344},
  {"Random", 842310, 31347},
  {"RandomArray", 842404, 31350},
  {"RandomColors", 842503, 31353},
  {"RandomComposition", 842607, 31356},
  {"RandomGraph", 842710, 31359},
  {"RandomGrays", 842807, 31362},
  {"RandomHeap", 842903, 31365},
  {"RandomInteger", 843001, 31368},
  {"RandomKSetPartition", 843108, 31371},
  {"RandomKSubset", 843215, 31374},
  {"RandomPartition", 843319, 31377},
  {"RandomPermutation", 843427, 31380},
  {"RandomRGF", 843529, 31383},
  {"RandomSetPartition", 843631, 31386},
  {"RandomSubset", 843736, 31389},
  {"RandomTableau", 843837, 31392},
  {"RandomTree", 843936, 31395},
  {"RandomVertices", 844036, 31398},
  {"RangeCounts", 844136, 31401},
  {"RangeLists", 844232, 31404},
  {"RankBinarySubset", 844333, 31407},
  {"RankedEmbedding", 844439, 31410},
  {"RankGraph", 844539, 31413},
  {"RankGrayCodeSubset", 844641, 31416},
  {"RankKSetPartition", 844751, 31419},
  {"RankKSubset", 844854, 31422},
  {"RankPermutation", 844955, 31425},
  {"RankRGF", 845053, 31428},
  {"RankSetPartition", 845151, 31431},
  {"RankSubset", 845252, 31434},
  {"Rational function approximations", 845369, 31437},
  {"Rational number approximations", 845507, 31440},
  {"RationalInterpolation", 845737, 31445},
  {"Rationalize", 845844, 31448},
  {"Rationalize package", 846111, 31455},
  {"RayleighDistribution", 846225, 31458},
  {"Re", 846322, 31461},
  {"ReadSoundFile", 846413, 31464},
  {"Real numbers", 846513, 31467},
  {"RealDigits", 846610, 31470},
  {"RealizeDegreeSequence", 846716, 31473},
  {"RealOnly", 846821, 31476},
  {"RealOnly package", 846920, 31479},
  {"RealRootIntervals", 847028, 31482},
  {"RealValued", 847130, 31485},
  {"Recognize", 847225, 31488},
  {"Recognize package", 847326, 31491},
  {"Recurring decimals", 847436, 31494},
  {"ReduceElement", 847542, 31497},
  {"ReferenceLineStyle", 847648, 31500},
  {"ReflexiveQ", 847751, 31503},
  {"RegionProbability", 847853, 31506},
  {"Regress", 847952, 31509},
  {"RegressionReport", 848051, 31512},
  {"RegressionReportValues", 848165, 31515},
  {"RegularGraph", 848275, 31518},
  {"RegularPolygon", 848376, 31521},
  {"RegularQ", 848473, 31524},
  {"ReIm package", 848568, 31527},
  {"Relative", 848663, 31530},
  {"RelativeStrength", 848762, 31533},
  {"Remove", 848859, 31536},
  {"RemoveMultipleEdges", 848959, 31539},
  {"RemoveSelfLoops", 849068, 31542},
  {"RepeatedSmoothing", 849175, 31545},
  {"ResidualFlowGraph", 849284, 31548},
  {"Residuals", 849385, 31551},
  {"Residue", 849561, 31556},
  {"ResonanceAbsorptionLines package", 849748, 31561},
  {"RevealCycles", 849867, 31564},
  {"ReverseEdges", 849966, 31567},
  {"RevolutionAxis", 850067, 31570},
  {"RGBColor", 850164, 31573},
  {"RGFQ", 850251, 31576},
  {"RGFs", 850334, 31579},
  {"RGFToSetPartition", 850430, 31582},
  {"Riemann hypothesis", 850540, 31585},
  {"RiemannSiegelTheta", 850651, 31588},
  {"RiemannSiegelZ", 850758, 31591},
  {"RightAssociates", 850862, 31594},
  {"RightGCD", 850960, 31597},
  {"RingModulation", 851057, 31600},
  {"Ritz variational principle", 851172, 31603},
  {"RobertsonGraph", 851287, 31606},
  {"RogersTanimotoDissimilarity", 851403, 31609},
  {"Root finding", 851518, 31612},
  {"root of unity", 851618, 31615},
  {"RootedEmbedding", 851721, 31618},
  {"RootIsolation package", 851832, 31621},
  {"RootMeanSquare", 851942, 31624},
  {"Roots of polynomials", 852052, 31627},
  {"Rotate2D", 852155, 31630},
  {"Rotate3D", 852246, 31633},
  {"RotateLights", 852341, 31636},
  {"RotateShape", 852439, 31639},
  {"RotateVertices", 852540, 31642},
  {"Rotation", 852637, 31645},
  {"RotationMatrix2D", 852819, 31650},
  {"RotationMatrix3D", 852926, 31653},
  {"Rotations package", 853034, 31656},
  {"Round", 853131, 31659},
  {"RoundingRule", 853223, 31662},
  {"Roundoff errors", 853325, 31665},
  {"RoundToEven", 853427, 31668},
  {"RoundToInfinity", 853528, 31671},
  {"RowJoin", 853625, 31674},
  {"RSolve package", 853721, 31677},
  {"RSquared", 853819, 31680},
  {"Runge-Kutta methods", 853922, 31683},
  {"RungeKuttaMethod", 854032, 31686},
  {"RungeKuttaOrderConditions", 854148, 31689},
  {"Runs", 854252, 31692},
  {"RussleRaoDissimilarity", 854353, 31695},
  {"SackurTetrodeConstant", 854472, 31698},
  {"SamenessRelation", 854584, 31701},
  {"Sample mean", 854686, 31704},
  {"SampleDepth", 854870, 31709},
  {"SampleRange", 854967, 31712},
  {"SampleRate", 855064, 31715},
  {"Sawtooth", 855157, 31718},
  {"Scalar product", 855254, 31721},
  {"ScalarTripleProduct", 855362, 31724},
  {"Scale", 855461, 31727},
  {"ScaleFactor", 855553, 31730},
  {"ScaleFactors", 855652, 31733},
  {"ScaleFunction", 855752, 31736},
  {"ScaleMethod", 855852, 31739},
  {"Scales", 855945, 31742},
  {"Scaling", 856034, 31745},
  {"scatter plot", 856128, 31748},
  {"ScatterPlot3D", 856228, 31751},
  {"Schlafli", 856324, 31754},
  {"SelectionSort", 856420, 31757},
  {"SelfComplementaryQ", 856526, 31760},
  {"SelfLoopsQ", 856630, 31763},
  {"Semi-log plots", 856729, 31766},
  {"Semialgebraic sets", 856836, 31769},
  {"SemialgebraicComponents", 856952, 31772},
  {"SemimajorAxis", 857063, 31775},
  {"Separation of colors", 857171, 31778},
  {"Sequence of graphics", 857286, 31781},
  {"Sequences", 857390, 31784},
  {"SequentialSumOfSquares", 857496, 31787},
  {"Series", 857600, 31790},
  {"SeriesTerm", 857844, 31797},
  {"SetArithmetic", 857942, 31800},
  {"SetCoordinates", 858044, 31803},
  {"SetEdgeLabels", 858147, 31806},
  {"SetEdgeWeights", 858249, 31809},
  {"SetFieldFormat", 858352, 31812},
  {"SetGraphOptions", 858456, 31815},
  {"SetPartitionListViaRGF", 858568, 31818},
  {"SetPartitionQ", 858678, 31821},
  {"SetPartitions", 858779, 31824},
  {"SetPartitionToRGF", 858884, 31827},
  {"Setting arithmetic parameters", 859005, 31830},
  {"SetVertexLabels", 859124, 31833},
  {"SetVertexWeights", 859230, 31836},
  {"Shade", 859326, 31839},
  {"Shadow", 859412, 31842},
  {"ShadowBackground", 859509, 31845},
  {"ShadowBorder", 859612, 31848},
  {"ShadowBox", 859708, 31851},
  {"ShadowForeground", 859808, 31854},
  {"Shadowing of names", 859917, 31857},
  {"ShadowMesh", 860021, 31860},
  {"ShadowMeshStyle", 860121, 31863},
  {"ShadowOffset", 860223, 31866},
  {"ShadowPlot3D", 860322, 31869},
  {"ShadowPosition", 860423, 31872},
  {"ShakeGraph", 860522, 31875},
  {"ShapeReport", 860618, 31878},
  {"Shapes", 860710, 31881},
  {"Shapes package", 860805, 31884},
  {"Share", 860900, 31887},
  {"ShortestPath", 860992, 31890},
  {"ShortestPathSpanningTree", 861104, 31893},
  {"Show", 861208, 31896},
  {"ShowAnimation", 861301, 31899},
  {"ShowGraph", 861398, 31902},
  {"ShowGraphArray", 861497, 31905},
  {"ShowLabeledGraph", 861603, 31908},
  {"ShowLegend", 861704, 31911},
  {"ShowProgress", 861801, 31914},
  {"ShowTime", 861897, 31917},
  {"ShowTime package", 861996, 31920},
  {"ShuffleExchangeGraph", 862107, 31923},
  {"SI", 862204, 31926},
  {"SiegelTheta", 862292, 31929},
  {"SiegelTheta package", 862397, 31932},
  {"Sign", 862495, 31935},
  {"SignaturePermutation", 862594, 31938},
  {"Significance level", 862707, 31941},
  {"SignificanceLevel", 862817, 31944},
  {"Simple", 862916, 31947},
  {"SimpleQ", 863005, 31950},
  {"SimplexMedian", 863101, 31953},
  {"SinglePredictionCITable", 863213, 31956},
  {"Singularities", 863325, 31959},
  {"Sinusoid", 863422, 31962},
  {"SixthTone", 863515, 31965},
  {"Skewness", 863608, 31968},
  {"Small", 863698, 31971},
  {"SmallestCyclicGroupGraph", 863803, 31974},
  {"SmallPrime", 863913, 31977},
  {"SmallStellatedDodecahedron", 864025, 31980},
  {"Smoothing data", 864141, 31983},
  {"SokalSneathDissimilarity", 864255, 31986},
  {"SolarConstant", 864368, 31989},
  {"SolarLuminosity", 864472, 31992},
  {"SolarRadius", 864574, 31995},
  {"SolarSchwarzschildRadius", 864685, 31998},
  {"SolarSystemAbundance", 864805, 32001},
  {"SolidBarEdges", 864914, 32004},
  {"SolidBarEdgeStyle", 865020, 32007},
  {"SolidBarStyle", 865126, 32010},
  {"Solids", 865221, 32013},
  {"Solutions", 865312, 32016},
  {"Solving", 865404, 32019},
  {"Solving differential equations", 865517, 32022},
  {"Solving matrix equations", 865647, 32025},
  {"Solving simultaneous congruences", 865779, 32028},
  {"Sorting", 865894, 32031},
  {"Sound", 865982, 32034},
  {"SoundSpeed", 866153, 32039},
  {"Spanning tree", 866252, 32042},
  {"Spatial data", 866353, 32045},
  {"SpatialMedian", 866454, 32048},
  {"SpearmanRankCorrelation", 866566, 32051},
  {"SpecificHeat", 866677, 32054},
  {"Spectrum", 866773, 32057},
  {"SpeedOfLight", 866869, 32060},
  {"SpeedOfSound", 866969, 32063},
  {"SpellCheck", 867067, 32066},
  {"Sphere", 867158, 32069},
  {"Spherical", 867403, 32076},
  {"SphericalDistance", 867505, 32079},
  {"SphericalPlot3D", 867613, 32082},
  {"SpheroidalDistance", 867722, 32085},
  {"Spline", 867822, 32088},
  {"Spline package", 867918, 32091},
  {"SplineDivision", 868022, 32094},
  {"SplineDots", 868122, 32097},
  {"SplineFit", 868217, 32100},
  {"SplineFit package", 868319, 32103},
  {"SplineFunction", 868426, 32106},
  {"SplinePoints", 868528, 32109},
  {"SpringEmbedding", 868631, 32112},
  {"SqrtMod", 868729, 32115},
  {"SqrtModList", 868823, 32118},
  {"Square", 868916, 32121},
  {"SquaredEuclideanDistance", 869022, 32124},
  {"SquareFreeQ", 869133, 32127},
  {"SquareMatrixQ", 869233, 32130},
  {"StableIsotopes", 869336, 32133},
  {"StableMarriage", 869440, 32136},
  {"StackedBarChart", 869545, 32139},
  {"StackGraphics", 869649, 32142},
  {"StandardAtmosphere package", 869764, 32145},
  {"StandardDeviation", 869883, 32148},
  {"StandardDeviationMLE", 869997, 32151},
  {"StandardErrorOfSampleMean", 870118, 32154},
  {"Standardize", 870230, 32157},
  {"StandardizedResiduals", 870338, 32160},
  {"StandardPackages directory", 870461, 32163},
  {"Star", 870566, 32166},
  {"StartingParameters", 870664, 32169},
  {"Statistical distributions", 870783, 32172},
  {"Statistics", 870895, 32175},
  {"StefanConstant", 871082, 32180},
  {"Stellate", 871180, 32183},
  {"Stem", 871268, 32186},
  {"stem plot", 871357, 32189},
  {"StirlingFirst", 871455, 32192},
  {"StirlingSecond", 871558, 32195},
  {"Strings", 871655, 32198},
  {"Strong", 871744, 32201},
  {"StrongComponents", 871842, 32204},
  {"StronglyConnectedComponents", 871960, 32207},
  {"StudentizedResiduals", 872083, 32210},
  {"StudentNewmanKeuls", 872197, 32213},
  {"StudentTCI", 872301, 32216},
  {"StudentTDistribution", 872407, 32219},
  {"StudentTPValue", 872517, 32222},
  {"Subfactorial", 872619, 32225},
  {"Submatrices", 872718, 32228},
  {"SubMatrix", 872814, 32231},
  {"Subsets", 872906, 32234},
  {"Successor", 873072, 32239},
  {"SummaryReport", 873170, 32242},
  {"SumOfFactors", 873271, 32245},
  {"SumOfFactorsType", 873375, 32248},
  {"SumOfSquaresR", 873480, 32251},
  {"SumOfSquaresRepresentations", 873596, 32254},
  {"Sums", 873703, 32257},
  {"SupDistance", 873873, 32262},
  {"Surface of revolution", 873981, 32265},
  {"SurfaceMesh", 874089, 32268},
  {"SurfaceMeshStyle", 874192, 32271},
  {"SurfaceOfRevolution", 874303, 32274},
  {"SurfaceOfRevolution package", 874425, 32277},
  {"Surfaces", 874536, 32280},
  {"SymbolLabel", 874714, 32285},
  {"Symbols", 874808, 32288},
  {"SymbolShape", 874901, 32291},
  {"SymbolStyle", 874999, 32294},
  {"Symmetric polynomials", 875107, 32297},
  {"SymmetricGroup", 875218, 32300},
  {"SymmetricGroupIndex", 875327, 32303},
  {"SymmetricPolynomial", 875441, 32306},
  {"SymmetricPolynomials package", 875564, 32309},
  {"SymmetricQ", 875678, 32312},
  {"t distribution", 875778, 32315},
  {"T-square(d) distribution", 875982, 32320},
  {"TableauClasses", 876096, 32323},
  {"TableauQ", 876194, 32326},
  {"Tableaux", 876286, 32329},
  {"TableauxToPermutation", 876391, 32332},
  {"TakeColumns", 876499, 32335},
  {"TakeMatrix", 876596, 32338},
  {"TakeRows", 876690, 32341},
  {"TakeWhile", 876783, 32344},
  {"Temperature scales", 876886, 32347},
  {"TemperedChromatic", 876997, 32350},
  {"TemperedMajor", 877103, 32353},
  {"TemperedMinor", 877205, 32356},
  {"TermIncrement", 877307, 32359},
  {"Terms", 877401, 32362},
  {"Tessellation", 877494, 32365},
  {"Testing hypotheses", 877600, 32368},
  {"TetrahedralGraph", 877710, 32371},
  {"Tetrahedron", 877813, 32374},
  {"TextListPlot", 877912, 32377},
  {"ThermalConductivity", 878019, 32380},
  {"ThermalConductivityCoefficient", 878144, 32383},
  {"Theta functions", 878265, 32386},
  {"Thick", 878361, 32389},
  {"ThickDashed", 878453, 32392},
  {"Thiessen polygons", 878557, 32395},
  {"Thin", 878654, 32398},
  {"ThinDashed", 878744, 32401},
  {"ThomassenGraph", 878844, 32404},
  {"ThomsonCrossSection", 878953, 32407},
  {"Three-dimensional graphics", 879074, 32410},
  {"ThreeScript", 879187, 32413},
  {"ThreeScript package", 879293, 32416},
  {"Tick marks", 879398, 32419},
  {"Ticks", 879489, 32422},
  {"TileAreas", 879579, 32425},
  {"Timing", 879670, 32428},
  {"ToAdjacencyLists", 879768, 32431},
  {"ToAdjacencyMatrix", 879877, 32434},
  {"ToAuthalicRadius", 879986, 32437},
  {"ToCanonicalSetPartition", 880101, 32440},
  {"ToCycles", 880208, 32443},
  {"ToDegrees", 880301, 32446},
  {"ToDMS", 880391, 32449},
  {"ToElementCode", 880485, 32452},
  {"ToInversionVector", 880591, 32455},
  {"ToMinutes", 880693, 32458},
  {"ToOrderedPairs", 880792, 32461},
  {"TopologicalSort", 880897, 32464},
  {"ToQuaternion", 881000, 32467},
  {"Toroidal", 881096, 32470},
  {"Torus", 881185, 32473},
  {"TotalPower", 881276, 32476},
  {"TotalVariation", 881376, 32479},
  {"ToUnorderedPairs", 881482, 32482},
  {"Transformation", 881588, 32485},
  {"Transforms", 881777, 32490},
  {"TransitionProbability", 881969, 32495},
  {"TransitiveClosure", 882083, 32498},
  {"TransitiveQ", 882187, 32501},
  {"TransitiveReduction", 882293, 32504},
  {"TranslateShape", 882402, 32507},
  {"TranslateVertices", 882509, 32510},
  {"Translation", 882613, 32513},
  {"TransposePartition", 882718, 32516},
  {"TransposeTableau", 882828, 32519},
  {"TravelingSalesman", 882937, 32522},
  {"TravelingSalesmanBounds", 883053, 32525},
  {"Tree", 883156, 32528},
  {"Tree package", 883327, 32533},
  {"TreeFind", 883423, 32536},
  {"TreeIsomorphismQ", 883523, 32539},
  {"TreePlot", 883623, 32542},
  {"TreePlot3D", 883791, 32547},
  {"TreeQ", 883881, 32550},
  {"Trees", 883967, 32553},
  {"TreeToCertificate", 884145, 32558},
  {"TrialDivisionLimit", 884256, 32561},
  {"Triangle", 884358, 32564},
  {"TriangleInequalityQ", 884461, 32567},
  {"TriangularSurfacePlot", 884577, 32570},
  {"Triangulation", 884687, 32573},
  {"Tridiagonal package", 884795, 32576},
  {"TridiagonalMatrix", 884907, 32579},
  {"TridiagonalSolve", 885016, 32582},
  {"TrigFit", 885115, 32585},
  {"TrigFit package", 885213, 32588},
  {"Trigonometric approximation", 885331, 32591},
  {"TrimmedMean", 885445, 32594},
  {"TrimPoints", 885542, 32597},
  {"Truncate", 885636, 32600},
  {"Truncation", 885730, 32603},
  {"Tukey", 885821, 32606},
  {"Turan", 885907, 32609},
  {"TutteGraph", 885998, 32612},
  {"TwoColoring", 886095, 32615},
  {"TwoSided", 886190, 32618},
  {"Ulp", 886277, 32621},
  {"Unbiased estimate", 886373, 32624},
  {"Undecagon", 886568, 32629},
  {"Undirected", 886663, 32632},
  {"UndirectedQ", 886760, 32635},
  {"UniformDistribution", 886866, 32638},
  {"UnionSet", 886969, 32641},
  {"Uniquely3ColorableGraph", 887076, 32644},
  {"Unit in the last place", 887197, 32647},
  {"UnitQuaternionQ", 887310, 32650},
  {"UnitQuaternions", 887416, 32653},
  {"UnitransitiveGraph", 887525, 32656},
  {"Units", 887624, 32659},
  {"Units package", 887718, 32662},
  {"UnrankBinarySubset", 887825, 32665},
  {"UnrankGrayCodeSubset", 887939, 32668},
  {"UnrankKSetPartition", 888054, 32671},
  {"UnrankKSubset", 888162, 32674},
  {"UnrankPermutation", 888268, 32677},
  {"UnrankRGF", 888370, 32680},
  {"UnrankSetPartition", 888473, 32683},
  {"UnrankSubset", 888579, 32686},
  {"UnweightedQ", 888678, 32689},
  {"UpperDiagonalMatrix", 888784, 32692},
  {"UpperLeft", 888888, 32695},
  {"UpperRight", 888983, 32698},
  {"V", 889070, 32701},
  {"VacuumPermeability", 889165, 32704},
  {"VacuumPermittivity", 889277, 32707},
  {"VacuumWavelength", 889387, 32710},
  {"Vaporization", 889491, 32713},
  {"Variance", 889587, 32716},
  {"VarianceCI", 889757, 32721},
  {"VarianceInflation", 889860, 32724},
  {"VarianceMLE", 889964, 32727},
  {"VarianceOfSampleMean", 890071, 32730},
  {"VarianceRatioCI", 890182, 32733},
  {"VarianceRatioTest", 890290, 32736},
  {"VarianceTest", 890395, 32739},
  {"Variational methods", 890502, 32742},
  {"VariationalBound", 890613, 32745},
  {"VariationalD", 890717, 32748},
  {"VariationalMethods package", 890831, 32751},
  {"Vector fields", 890946, 32754},
  {"Vector product", 891137, 32759},
  {"Vector space", 891239, 32762},
  {"VectorAnalysis package", 891349, 32765},
  {"VectorHeads", 891458, 32768},
  {"Vectors", 891552, 32771},
  {"VertexColor", 891646, 32774},
  {"VertexColoring", 891747, 32777},
  {"VertexConnectivity", 891855, 32780},
  {"VertexConnectivityGraph", 891972, 32783},
  {"VertexCover", 892082, 32786},
  {"VertexCoverQ", 892181, 32789},
  {"VertexLabel", 892280, 32792},
  {"VertexLabelColor", 892383, 32795},
  {"VertexLabelPosition", 892494, 32798},
  {"VertexList", 892599, 32801},
  {"VertexNumber", 892696, 32804},
  {"VertexNumberColor", 892801, 32807},
  {"VertexNumberPosition", 892914, 32810},
  {"VertexStyle", 893021, 32813},
  {"VertexWeight", 893120, 32816},
  {"Vertical", 893216, 32819},
  {"Vertices", 893308, 32822},
  {"viewpoint 3-Script command", 893419, 32825},
  {"Volume", 893527, 32828},
  {"Voronoi polygons", 893625, 32831},
  {"WaltherGraph", 893729, 32834},
  {"Waveform", 893825, 32837},
  {"WavelengthAbsorptionMap", 893932, 32840},
  {"Weak", 894035, 32843},
  {"WeaklyConnectedComponents", 894140, 32846},
  {"WeakMixingAngle", 894256, 32849},
  {"Wedge product", 894360, 32852},
  {"WeibullDistribution", 894468, 32855},
  {"Weighted least-squares fitting", 894593, 32858},
  {"WeightingFunction", 894716, 32861},
  {"WeightRange", 894820, 32864},
  {"Weights, in Gaussian quadrature", 894938, 32867},
  {"Weights, in Newton-Cotes quadrature", 895080, 32870},
  {"Weights", 895198, 32873},
  {"Wheel", 895286, 32876},
  {"WhichRootOfUnity", 895383, 32879},
  {"Width", 895480, 32882},
  {"WireFrame", 895570, 32885},
  {"WishartDistribution", 895674, 32888},
  {"WorkingPrecision", 895785, 32891},
  {"WorldBackground", 895893, 32894},
  {"WorldBorders", 895996, 32897},
  {"WorldClipping", 896097, 32900},
  {"WorldCountries", 896200, 32903},
  {"WorldDatabase", 896303, 32906},
  {"WorldFrame", 896402, 32909},
  {"WorldFrameParts", 896503, 32912},
  {"WorldGraphics", 896607, 32915},
  {"WorldGrid", 896705, 32918},
  {"WorldGridBehind", 896805, 32921},
  {"WorldGridStyle", 896910, 32924},
  {"WorldPlot", 897009, 32927},
  {"WorldPlot package", 897111, 32930},
  {"WorldPoints", 897215, 32933},
  {"WorldProjection", 897317, 32936},
  {"WorldRange", 897418, 32939},
  {"WorldRotatedRange", 897521, 32942},
  {"WorldRotation", 897627, 32945},
  {"WorldToGraphics", 897731, 32948},
  {"YIQColor", 897830, 32951},
  {"Young tableaux", 897928, 32954},
  {"YuleDissimilarity", 898035, 32957},
  {"Zero finding", 898140, 32960},
  {"ZeroMatrix", 898238, 32963},
  {"ZeroMean", 898332, 32966},
  {"$CityFields", 898427, 32969},
  {"$Context", 898522, 32972},
  {"$ContextPath", 898618, 32975},
  {"$MachineEpsilon", 898721, 32978},
  {"$MemoryIncrement", 898828, 32981},
  {"$Packages", 898929, 32984},
  {"$Post", 899018, 32987},
  {"$RungeKuttaMethod", 899116, 32990}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 75, 1, 41, "IndexSection",
  CellTags->"MasterIndexHeading"],
Cell[1832, 54, 423, 18, 16, "Index",
  CellTags->"<<"],
Cell[2258, 74, 193, 8, 16, "Index",
  CellTags->".m files"],
Cell[2454, 84, 170, 7, 16, "Index"],
Cell[2627, 93, 177, 6, 16, "Index"],
Cell[2807, 101, 243, 8, 16, "Index",
  CellTags->"Abbreviation"],
Cell[3053, 111, 440, 16, 16, "Index",
  CellTags->"Abs"],
Cell[3496, 129, 241, 7, 16, "Index",
  CellTags->"Abscissa"],
Cell[3740, 138, 237, 7, 16, "IndexSubentry",
  CellTags->"Abscissa"],
Cell[3980, 147, 210, 8, 16, "Index",
  CellTags->"AbsIJK"],
Cell[4193, 157, 203, 8, 16, "Index",
  CellTags->"Absolute"],
Cell[4399, 167, 269, 8, 16, "Index",
  CellTags->"AccelerationDueToGravity"],
Cell[4671, 177, 227, 7, 16, "Index",
  CellTags->"Accuracy"],
Cell[4901, 186, 379, 12, 16, "Index",
  CellTags->"AccuracyGoal"],
Cell[5283, 200, 369, 12, 16, "Index",
  CellTags->"AcyclicQ"],
Cell[5655, 214, 367, 12, 16, "Index",
  CellTags->"AddEdge"],
Cell[6025, 228, 228, 8, 16, "Index",
  CellTags->"AddEdges"],
Cell[6256, 238, 230, 8, 16, "Index",
  CellTags->"AddVertex"],
Cell[6489, 248, 234, 8, 16, "Index",
  CellTags->"AddVertices"],
Cell[6726, 258, 220, 7, 16, "Index",
  CellTags->"Adjacency lists"],
Cell[6949, 267, 226, 7, 16, "Index",
  CellTags->"Adjacency matrices"],
Cell[7178, 276, 368, 12, 16, "Index",
  CellTags->"AdjustedRSquared"],
Cell[7549, 290, 228, 8, 16, "Index",
  CellTags->"AdjustedSignIJK"],
Cell[7780, 300, 241, 8, 16, "Index",
  CellTags->"AffineRationalize"],
Cell[8024, 310, 211, 8, 16, "Index",
  CellTags->"AffineShape"],
Cell[8238, 320, 247, 8, 16, "Index",
  CellTags->"AgeOfUniverse"],
Cell[8488, 330, 276, 10, 16, "Index",
  CellTags->"Agglomerate"],
Cell[8767, 342, 261, 8, 16, "Index",
  CellTags->"AirWavelength"],
Cell[9031, 352, 247, 7, 16, "Index",
  CellTags->"Algebraic extension fields"],
Cell[9281, 361, 373, 11, 16, "Index",
  CellTags->"Algebraic inequalities"],
Cell[9657, 374, 229, 7, 16, "Index",
  CellTags->"Algebraic numbers"],
Cell[9889, 383, 275, 8, 16, "Index",
  CellTags->"AlgebraicInequalities package"],
Cell[10167, 393, 230, 8, 16, "Index",
  CellTags->"Algorithm"],
Cell[10400, 403, 238, 7, 16, "Index",
  CellTags->"aliquot sequence"],
Cell[10641, 412, 252, 8, 16, "Index",
  CellTags->"AliquotCycle"],
Cell[10896, 422, 258, 8, 16, "Index",
  CellTags->"AliquotSequence"],
Cell[11157, 432, 207, 8, 16, "Index",
  CellTags->"AllColors"],
Cell[11367, 442, 252, 8, 16, "Index",
  CellTags->"AllPairsShortestPath"],
Cell[11622, 452, 246, 8, 16, "Index",
  CellTags->"AllPoints"],
Cell[11871, 462, 244, 8, 16, "Index",
  CellTags->"AlternatingGroup"],
Cell[12118, 472, 254, 8, 16, "Index",
  CellTags->"AlternatingGroupIndex"],
Cell[12375, 482, 244, 8, 16, "Index",
  CellTags->"AlternatingPaths"],
Cell[12622, 492, 265, 8, 16, "Index",
  CellTags->"ambientlight 3-Script command"],
Cell[12890, 502, 236, 8, 16, "Index",
  CellTags->"AmplitudeModulation"],
Cell[13129, 512, 222, 8, 16, "Index",
  CellTags->"Anagrams"],
Cell[13354, 522, 367, 11, 16, "Index",
  CellTags->"Analysis of variance"],
Cell[13724, 535, 209, 8, 16, "Index",
  CellTags->"Animate"],
Cell[13936, 545, 377, 12, 16, "Index",
  CellTags->"AnimateGraph"],
Cell[14316, 559, 191, 7, 16, "Index",
  CellTags->"Animation"],
Cell[14510, 568, 229, 8, 16, "Index",
  CellTags->"Animation package"],
Cell[14742, 578, 213, 8, 16, "Index",
  CellTags->"Annotation"],
Cell[14958, 588, 201, 8, 16, "Index",
  CellTags->"ANOVA"],
Cell[15162, 598, 491, 16, 32, "Index",
  CellTags->"ANOVATable"],
Cell[15656, 616, 240, 8, 16, "Index",
  CellTags->"AntiSymmetricQ"],
Cell[15899, 626, 249, 8, 16, "Index",
  CellTags->"AppendColumns"],
Cell[16151, 636, 243, 8, 16, "Index",
  CellTags->"AppendRows"],
Cell[16397, 646, 221, 8, 16, "Index",
  CellTags->"Applications directory"],
Cell[16621, 656, 373, 11, 16, "Index",
  CellTags->"Approximate numbers"],
Cell[16997, 669, 227, 7, 16, "Index",
  CellTags->"Approximate polynomials"],
Cell[17227, 678, 479, 16, 16, "Index",
  CellTags->"ApproximateIntervals"],
Cell[17709, 696, 256, 8, 16, "Index",
  CellTags->"ApproximateVertexCover"],
Cell[17968, 706, 761, 23, 32, "Index",
  CellTags->"Approximation of functions"],
Cell[18732, 731, 259, 8, 16, "Index",
  CellTags->"Approximations package"],
Cell[18994, 741, 236, 8, 16, "Index",
  CellTags->"ArcLengthFactor"],
Cell[19233, 751, 215, 7, 16, "Index",
  CellTags->"Area, between curves"],
Cell[19451, 760, 327, 12, 16, "Index",
  CellTags->"Area"],
Cell[19781, 774, 313, 12, 16, "Index",
  CellTags->"Arg"],
Cell[20097, 788, 211, 8, 16, "Index",
  CellTags->"ArgColor"],
Cell[20311, 798, 229, 8, 16, "Index",
  CellTags->"ArgColors package"],
Cell[20543, 808, 211, 8, 16, "Index",
  CellTags->"ArgShade"],
Cell[20757, 818, 244, 8, 16, "Index",
  CellTags->"Arithmetic"],
Cell[21004, 828, 244, 7, 16, "Index",
  CellTags->"Arithmetic parameters"],
Cell[21251, 837, 197, 8, 16, "Index",
  CellTags->"Arrow"],
Cell[21451, 847, 213, 8, 16, "Index",
  CellTags->"Arrow package"],
Cell[21667, 857, 393, 12, 16, "Index",
  CellTags->"ArticulationVertices"],
Cell[22063, 871, 268, 8, 16, "Index",
  CellTags->"AssociationMatrix"],
Cell[22334, 881, 220, 8, 16, "Index",
  CellTags->"Assumptions"],
Cell[22557, 891, 260, 8, 16, "Index",
  CellTags->"AsymptoticCorrelationMatrix"],
Cell[22820, 901, 258, 8, 16, "Index",
  CellTags->"AsymptoticCovarianceMatrix"],
Cell[23081, 911, 251, 7, 16, "Index",
  CellTags->"Atkin-Morain primality certificate"],
Cell[23335, 920, 253, 8, 16, "Index",
  CellTags->"AtmosphericPlot"],
Cell[23591, 930, 255, 8, 16, "Index",
  CellTags->"AtomicData"],
Cell[23849, 940, 243, 8, 16, "Index",
  CellTags->"AtomicNumber"],
Cell[24095, 950, 243, 8, 16, "Index",
  CellTags->"AtomicWeight"],
Cell[24341, 960, 223, 8, 16, "Index",
  CellTags->"Audio package"],
Cell[24567, 970, 214, 8, 16, "Index",
  CellTags->"Autoload directory"],
Cell[24784, 980, 284, 11, 16, "Index",
  CellTags->"Autoloading"],
Cell[25071, 993, 238, 8, 16, "Index",
  CellTags->"Automorphisms"],
Cell[25312, 1003, 253, 8, 16, "Index",
  CellTags->"AvogadroConstant"],
Cell[25568, 1013, 357, 13, 16, "Index",
  CellTags->"Axes"],
Cell[25928, 1028, 216, 8, 16, "Index",
  CellTags->"AxesFront"],
Cell[26147, 1038, 185, 7, 16, "Index"],
Cell[26335, 1047, 209, 8, 16, "Index",
  CellTags->"B"],
Cell[26547, 1057, 205, 8, 16, "Index",
  CellTags->"Back"],
Cell[26755, 1067, 221, 7, 16, "Index",
  CellTags->"Back substitution"],
Cell[26979, 1076, 230, 8, 16, "Index",
  CellTags->"Backtrack"],
Cell[27212, 1086, 209, 8, 16, "Index",
  CellTags->"BarChart"],
Cell[27424, 1096, 217, 8, 16, "Index",
  CellTags->"BarChart3D"],
Cell[27644, 1106, 351, 12, 16, "Index",
  CellTags->"BarEdges"],
Cell[27998, 1120, 359, 12, 16, "Index",
  CellTags->"BarEdgeStyle"],
Cell[28360, 1134, 224, 8, 16, "Index",
  CellTags->"BarGroupSpacing"],
Cell[28587, 1144, 353, 12, 16, "Index",
  CellTags->"BarLabels"],
Cell[28943, 1158, 363, 12, 16, "Index",
  CellTags->"BarOrientation"],
Cell[29309, 1172, 214, 8, 16, "Index",
  CellTags->"BarSpacing"],
Cell[29526, 1182, 474, 16, 16, "Index",
  CellTags->"BarStyle"],
Cell[30003, 1200, 212, 8, 16, "Index",
  CellTags->"BarValues"],
Cell[30218, 1210, 225, 7, 16, "Index",
  CellTags->"Basis vectors"],
Cell[30446, 1219, 356, 12, 16, "Index",
  CellTags->"BasisNames"],
Cell[30805, 1233, 187, 8, 16, "Index",
  CellTags->"Begin"],
Cell[30995, 1243, 201, 8, 16, "Index",
  CellTags->"BeginPackage"],
Cell[31199, 1253, 222, 8, 16, "Index",
  CellTags->"BellB"],
Cell[31424, 1263, 234, 8, 16, "Index",
  CellTags->"BellmanFord"],
Cell[31661, 1273, 214, 8, 16, "Index",
  CellTags->"Benchmark"],
Cell[31878, 1283, 265, 8, 16, "Index",
  CellTags->"BernoulliDistribution"],
Cell[32146, 1293, 229, 7, 16, "Index",
  CellTags->"Bessel function zeros"],
Cell[32378, 1302, 223, 8, 16, "Index",
  CellTags->"BesselJ"],
Cell[32604, 1312, 259, 8, 16, "Index",
  CellTags->"BesselJPrimeYJYPrimeZeros"],
Cell[32866, 1322, 276, 8, 16, "Index",
  CellTags->"BesselJPrimeYJYPrimeZerosInterval"],
Cell[33145, 1332, 279, 8, 16, "Index",
  CellTags->"BesselJPrimeYPrimeJPrimeYPrimeZeros"],
Cell[33427, 1342, 296, 8, 16, "Index",
  CellTags->"BesselJPrimeYPrimeJPrimeYPrimeZerosInterval"],
Cell[33726, 1352, 243, 8, 16, "Index",
  CellTags->"BesselJPrimeZeros"],
Cell[33972, 1362, 260, 8, 16, "Index",
  CellTags->"BesselJPrimeZerosInterval"],
Cell[34235, 1372, 249, 8, 16, "Index",
  CellTags->"BesselJYJYPrimeZeros"],
Cell[34487, 1382, 266, 8, 16, "Index",
  CellTags->"BesselJYJYPrimeZerosInterval"],
Cell[34756, 1392, 233, 8, 16, "Index",
  CellTags->"BesselJZeros"],
Cell[34992, 1402, 250, 8, 16, "Index",
  CellTags->"BesselJZerosInterval"],
Cell[35245, 1412, 223, 8, 16, "Index",
  CellTags->"BesselY"],
Cell[35471, 1422, 243, 8, 16, "Index",
  CellTags->"BesselYPrimeZeros"],
Cell[35717, 1432, 260, 8, 16, "Index",
  CellTags->"BesselYPrimeZerosInterval"],
Cell[35980, 1442, 233, 8, 16, "Index",
  CellTags->"BesselYZeros"],
Cell[36216, 1452, 250, 8, 16, "Index",
  CellTags->"BesselYZerosInterval"],
Cell[36469, 1462, 247, 8, 16, "Index",
  CellTags->"BesselZeros package"],
Cell[36719, 1472, 485, 16, 16, "Index",
  CellTags->"BestFit"],
Cell[37207, 1490, 505, 16, 32, "Index",
  CellTags->"BestFitParameters"],
Cell[37715, 1508, 380, 12, 16, "Index",
  CellTags->"BestFitParametersDelta"],
Cell[38098, 1522, 259, 8, 16, "Index",
  CellTags->"BetaDistribution"],
Cell[38360, 1532, 335, 12, 16, "Index",
  CellTags->"Bezier"],
Cell[38698, 1546, 327, 11, 16, "Index",
  CellTags->"Bezier curves"],
Cell[39028, 1559, 369, 12, 16, "Index",
  CellTags->"Bias"],
Cell[39400, 1573, 395, 12, 16, "Index",
  CellTags->"BiconnectedComponents"],
Cell[39798, 1587, 236, 8, 16, "Index",
  CellTags->"BiconnectedQ"],
Cell[40037, 1597, 226, 8, 16, "Index",
  CellTags->"Biharmonic"],
Cell[40266, 1607, 260, 9, 16, "Index",
  CellTags->"Binary Gray code"],
Cell[40529, 1618, 310, 9, 16, "Index",
  CellTags->"Binary quadratic forms"],
Cell[40842, 1629, 306, 9, 16, "IndexSubentry",
  CellTags->"Binary quadratic forms"],
Cell[41151, 1640, 195, 7, 16, "Index",
  CellTags->"Binary trees"],
Cell[41349, 1649, 236, 8, 16, "Index",
  CellTags->"BinarySearch"],
Cell[41588, 1659, 238, 8, 16, "Index",
  CellTags->"BinarySubsets"],
Cell[41829, 1669, 232, 8, 16, "Index",
  CellTags->"BinCounts"],
Cell[42064, 1679, 230, 8, 16, "Index",
  CellTags->"BinLists"],
Cell[42297, 1689, 245, 8, 16, "Index",
  CellTags->"Binomial"],
Cell[42545, 1699, 263, 8, 16, "Index",
  CellTags->"BinomialDistribution"],
Cell[42811, 1709, 387, 12, 16, "Index",
  CellTags->"BipartiteMatching"],
Cell[43201, 1723, 262, 8, 16, "Index",
  CellTags->"BipartiteMatchingAndCover"],
Cell[43466, 1733, 232, 8, 16, "Index",
  CellTags->"BipartiteQ"],
Cell[43701, 1743, 219, 8, 16, "Index",
  CellTags->"Bipolar"],
Cell[43923, 1753, 227, 8, 16, "Index",
  CellTags->"Bispherical"],
Cell[44153, 1763, 437, 11, 32, "Index",
  CellTags->"Bivariate statistical distributions"],
Cell[44593, 1776, 255, 8, 16, "Index",
  CellTags->"BlackBodyProfile"],
Cell[44851, 1786, 275, 8, 16, "Index",
  CellTags->"BlackBodyRadiation package"],
Cell[45129, 1796, 245, 8, 16, "Index",
  CellTags->"BlockMatrix"],
Cell[45377, 1806, 241, 8, 16, "Index",
  CellTags->"BohrRadius"],
Cell[45621, 1816, 243, 8, 16, "Index",
  CellTags->"BoilingPoint"],
Cell[45867, 1826, 255, 8, 16, "Index",
  CellTags->"BoltzmannConstant"],
Cell[46125, 1836, 212, 8, 16, "Index",
  CellTags->"Bonferroni"],
Cell[46340, 1846, 240, 8, 16, "Index",
  CellTags->"BooleanAlgebra"],
Cell[46583, 1856, 256, 8, 16, "Index",
  CellTags->"BoundedDiagram"],
Cell[46842, 1866, 263, 8, 16, "Index",
  CellTags->"boundingbox 3-Script command"],
Cell[47108, 1876, 218, 8, 16, "Index",
  CellTags->"Box"],
Cell[47329, 1886, 205, 7, 16, "Index",
  CellTags->"Box plot"],
Cell[47537, 1895, 230, 9, 16, "Index",
  CellTags->"Boxes"],
Cell[47770, 1906, 241, 8, 16, "Index",
  CellTags->"BoxExtraSpacing"],
Cell[48014, 1916, 229, 8, 16, "Index",
  CellTags->"BoxLabels"],
Cell[48246, 1926, 235, 8, 16, "Index",
  CellTags->"BoxLineStyle"],
Cell[48484, 1936, 239, 8, 16, "Index",
  CellTags->"BoxMedianStyle"],
Cell[48726, 1946, 239, 8, 16, "Index",
  CellTags->"BoxOrientation"],
Cell[48968, 1956, 233, 8, 16, "Index",
  CellTags->"BoxOutliers"],
Cell[49204, 1966, 243, 8, 16, "Index",
  CellTags->"BoxOutlierShapes"],
Cell[49450, 1976, 233, 8, 16, "Index",
  CellTags->"BoxQuantile"],
Cell[49686, 1986, 227, 8, 16, "Index",
  CellTags->"BoxStyle"],
Cell[49916, 1996, 239, 8, 16, "Index",
  CellTags->"BoxWhiskerPlot"],
Cell[50158, 2006, 226, 8, 16, "Index",
  CellTags->"Brake"],
Cell[50387, 2016, 290, 10, 16, "Index",
  CellTags->"BrayCurtisDistance"],
Cell[50680, 2028, 310, 11, 16, "Index",
  CellTags->"Branch cuts"],
Cell[50993, 2041, 238, 7, 16, "Index",
  CellTags->"Breadth-first search"],
Cell[51234, 2050, 395, 12, 16, "Index",
  CellTags->"BreadthFirstTraversal"],
Cell[51632, 2064, 224, 8, 16, "Index",
  CellTags->"Brelaz"],
Cell[51859, 2074, 240, 8, 16, "Index",
  CellTags->"BrelazColoring"],
Cell[52102, 2084, 367, 12, 16, "Index",
  CellTags->"Bridges"],
Cell[52472, 2098, 472, 15, 16, "Index",
  CellTags->"Business graphics"],
Cell[52947, 2115, 231, 8, 16, "Index",
  CellTags->"Butcher package"],
Cell[53181, 2125, 259, 9, 16, "Index",
  CellTags->"Butcher trees"],
Cell[53443, 2136, 415, 14, 32, "IndexSubentry",
  CellTags->"Butcher trees"],
Cell[53861, 2152, 226, 8, 16, "Index",
  CellTags->"ButcherAlpha"],
Cell[54090, 2162, 224, 8, 16, "Index",
  CellTags->"ButcherBeta"],
Cell[54317, 2172, 230, 8, 16, "Index",
  CellTags->"ButcherBetaBar"],
Cell[54550, 2182, 248, 8, 16, "Index",
  CellTags->"ButcherColumnConditions"],
Cell[54801, 2192, 226, 8, 16, "Index",
  CellTags->"ButcherGamma"],
Cell[55030, 2202, 228, 8, 16, "Index",
  CellTags->"ButcherHeight"],
Cell[55261, 2212, 226, 8, 16, "Index",
  CellTags->"ButcherOrder"],
Cell[55490, 2222, 222, 8, 16, "Index",
  CellTags->"ButcherPhi"],
Cell[55715, 2232, 224, 8, 16, "Index",
  CellTags->"ButcherPlot"],
Cell[55942, 2242, 238, 8, 16, "Index",
  CellTags->"ButcherPlotColumns"],
Cell[56183, 2252, 234, 8, 16, "Index",
  CellTags->"ButcherPlotLabel"],
Cell[56420, 2262, 240, 8, 16, "Index",
  CellTags->"ButcherPlotNodeSize"],
Cell[56663, 2272, 240, 8, 16, "Index",
  CellTags->"ButcherPlotRootSize"],
Cell[56906, 2282, 244, 8, 16, "Index",
  CellTags->"ButcherPrincipalError"],
Cell[57153, 2292, 256, 8, 16, "Index",
  CellTags->"ButcherQuadratureConditions"],
Cell[57412, 2302, 242, 8, 16, "Index",
  CellTags->"ButcherRowConditions"],
Cell[57657, 2312, 226, 8, 16, "Index",
  CellTags->"ButcherSigma"],
Cell[57886, 2322, 234, 8, 16, "Index",
  CellTags->"ButcherTreeCount"],
Cell[58123, 2332, 226, 8, 16, "Index",
  CellTags->"ButcherTreeQ"],
Cell[58352, 2342, 226, 8, 16, "Index",
  CellTags->"ButcherTrees"],
Cell[58581, 2352, 240, 8, 16, "Index",
  CellTags->"ButcherTreeSimplify"],
Cell[58824, 2362, 226, 8, 16, "Index",
  CellTags->"ButcherWidth"],
Cell[59053, 2372, 240, 8, 16, "Index",
  CellTags->"ButterflyGraph"],
Cell[59296, 2382, 371, 12, 16, "Index",
  CellTags->"CageGraph"],
Cell[59670, 2396, 220, 7, 16, "Index",
  CellTags->"Calculus"],
Cell[59893, 2405, 235, 7, 16, "Index",
  CellTags->"Calculus of variations"],
Cell[60131, 2414, 219, 8, 16, "Index",
  CellTags->"Calendar"],
Cell[60353, 2424, 235, 8, 16, "Index",
  CellTags->"Calendar package"],
Cell[60591, 2434, 231, 8, 16, "Index",
  CellTags->"CalendarChange"],
Cell[60825, 2444, 219, 7, 16, "Index",
  CellTags->"Calendars"],
Cell[61047, 2453, 286, 10, 16, "Index",
  CellTags->"CanberraDistance"],
Cell[61336, 2465, 223, 8, 16, "Index",
  CellTags->"Cartesian"],
Cell[61562, 2475, 221, 8, 16, "Index",
  CellTags->"CartesianMap"],
Cell[61786, 2485, 244, 8, 16, "Index",
  CellTags->"CartesianProduct"],
Cell[62033, 2495, 205, 7, 16, "Index",
  CellTags->"Cartography"],
Cell[62241, 2504, 212, 8, 16, "Index",
  CellTags->"Cascade"],
Cell[62456, 2514, 255, 8, 16, "Index",
  CellTags->"CatalanNumber"],
Cell[62714, 2524, 362, 12, 16, "Index",
  CellTags->"CatcherMatrix"],
Cell[63079, 2538, 242, 8, 16, "Index",
  CellTags->"CategoryCounts"],
Cell[63324, 2548, 240, 8, 16, "Index",
  CellTags->"CategoryLists"],
Cell[63567, 2558, 257, 7, 16, "Index",
  CellTags->"Cauchy distribution"],
Cell[63827, 2567, 249, 7, 16, "Index",
  CellTags->"Cauchy principal value"],
Cell[64079, 2576, 246, 7, 16, "Index",
  CellTags->"Cauchy's integral formula"],
Cell[64328, 2585, 263, 8, 16, "Index",
  CellTags->"CauchyDistribution"],
Cell[64594, 2595, 267, 8, 16, "Index",
  CellTags->"CauchyPrincipalValue"],
Cell[64864, 2605, 283, 8, 16, "Index",
  CellTags->"CauchyPrincipalValue package"],
Cell[65150, 2615, 973, 28, 48, "Index",
  CellTags->"CDF"],
Cell[66126, 2645, 210, 8, 16, "Index",
  CellTags->"CellMeans"],
Cell[66339, 2655, 224, 8, 16, "Index",
  CellTags->"Center"],
Cell[66566, 2665, 231, 7, 16, "Index",
  CellTags->"Central limit theorem"],
Cell[66800, 2674, 576, 16, 48, "Index",
  CellTags->"CentralMoment"],
Cell[67379, 2692, 221, 8, 16, "Index",
  CellTags->"CentsToHertz"],
Cell[67603, 2702, 346, 12, 16, "Index",
  CellTags->"Certificate"],
Cell[67952, 2716, 270, 9, 16, "Index",
  CellTags->"Certificate of primality"],
Cell[68225, 2727, 293, 9, 16, "Index",
  CellTags->"Certificate of primality checking"],
Cell[68521, 2738, 203, 8, 16, "Index",
  CellTags->"CGS"],
Cell[68727, 2748, 234, 8, 16, "Index",
  CellTags->"ChangeEdges"],
Cell[68964, 2758, 240, 8, 16, "Index",
  CellTags->"ChangeVertices"],
Cell[69207, 2768, 239, 7, 16, "Index",
  CellTags->"Chaotic behavior"],
Cell[69449, 2777, 228, 8, 16, "Index",
  CellTags->"Characteristic"],
Cell[69680, 2787, 1011, 28, 64, "Index",
  CellTags->"CharacteristicFunction"],
Cell[70694, 2817, 234, 9, 16, "Index",
  CellTags->"Charts"],
Cell[70931, 2828, 754, 25, 64, "IndexSubentry",
  CellTags->"Charts"],
Cell[71688, 2855, 354, 11, 16, "Index",
  CellTags->"Chebyshev approximation"],
Cell[72045, 2868, 231, 7, 16, "Index",
  CellTags->"Chemical elements"],
Cell[72279, 2877, 267, 8, 16, "Index",
  CellTags->"ChemicalElements package"],
Cell[72549, 2887, 648, 19, 32, "Index",
  CellTags->"Chi-square(d)"],
Cell[73200, 2908, 306, 9, 16, "Index",
  CellTags->"Chi-square(d) distribution"],
Cell[73509, 2919, 514, 15, 32, "IndexSubentry",
  CellTags->"Chi-square(d) distribution"],
Cell[74026, 2936, 257, 8, 16, "Index",
  CellTags->"ChiDistribution"],
Cell[74286, 2946, 260, 8, 16, "Index",
  CellTags->"ChineseRemainder"],
Cell[74549, 2956, 242, 8, 16, "Index",
  CellTags->"ChiSquareCI"],
Cell[74794, 2966, 415, 12, 32, "Index",
  CellTags->"ChiSquareDistribution"],
Cell[75212, 2980, 242, 8, 16, "Index",
  CellTags->"ChiSquarePValue"],
Cell[75457, 2990, 234, 8, 16, "Index",
  CellTags->"Cholesky package"],
Cell[75694, 3000, 242, 8, 16, "Index",
  CellTags->"ChromaticNumber"],
Cell[75939, 3010, 250, 8, 16, "Index",
  CellTags->"ChromaticPolynomial"],
Cell[76192, 3020, 236, 8, 16, "Index",
  CellTags->"ChvatalGraph"],
Cell[76431, 3030, 249, 9, 16, "Index",
  CellTags->"Circle"],
Cell[76683, 3041, 241, 9, 16, "IndexSubentry",
  CellTags->"Circle"],
Cell[76927, 3052, 224, 8, 16, "Index",
  CellTags->"Circle"],
Cell[77154, 3062, 381, 12, 16, "Index",
  CellTags->"CirculantGraph"],
Cell[77538, 3076, 246, 8, 16, "Index",
  CellTags->"CircularEmbedding"],
Cell[77787, 3086, 357, 12, 16, "Index",
  CellTags->"CircumscribedRadius"],
Cell[78147, 3100, 219, 8, 16, "Index",
  CellTags->"CityData"],
Cell[78369, 3110, 235, 8, 16, "Index",
  CellTags->"CityData package"],
Cell[78607, 3120, 227, 8, 16, "Index",
  CellTags->"CityDistance"],
Cell[78837, 3130, 239, 8, 16, "Index",
  CellTags->"CityDistanceMethod"],
Cell[79079, 3140, 228, 8, 16, "Index",
  CellTags->"CityPosition"],
Cell[79310, 3150, 267, 8, 16, "Index",
  CellTags->"ClassicalElectronRadius"],
Cell[79580, 3160, 246, 8, 16, "Index",
  CellTags->"ClassList"],
Cell[79829, 3170, 250, 8, 16, "Index",
  CellTags->"ClassNumber"],
Cell[80082, 3180, 226, 8, 16, "Index",
  CellTags->"CliqueQ"],
Cell[80311, 3190, 268, 10, 16, "Index",
  CellTags->"Cluster"],
Cell[80582, 3202, 240, 8, 16, "Index",
  CellTags->"ClusterAnalysis"],
Cell[80825, 3212, 282, 10, 16, "Index",
  CellTags->"ClusterFlatten"],
Cell[81110, 3224, 278, 10, 16, "Index",
  CellTags->"ClusterSplit"],
Cell[81391, 3236, 204, 7, 16, "Index",
  CellTags->"Cliques"],
Cell[81598, 3245, 205, 8, 16, "Index",
  CellTags->"CMYColor"],
Cell[81806, 3255, 207, 8, 16, "Index",
  CellTags->"CMYKColor"],
Cell[82016, 3265, 252, 8, 16, "Index",
  CellTags->"CoarserSetPartitionQ"],
Cell[82271, 3275, 244, 9, 16, "Index",
  CellTags->"Code"],
Cell[82518, 3286, 246, 8, 16, "Index",
  CellTags->"CodeToLabeledTree"],
Cell[82767, 3296, 411, 12, 32, "Index",
  CellTags->"CoefficientOfVariation"],
Cell[83181, 3310, 221, 7, 16, "Index",
  CellTags->"Coefficients"],
Cell[83405, 3319, 228, 8, 16, "Index",
  CellTags->"Cofactor"],
Cell[83636, 3329, 259, 8, 16, "Index",
  CellTags->"CollisionFrequency"],
Cell[83898, 3339, 229, 9, 16, "Index",
  CellTags->"Color"],
Cell[84130, 3350, 196, 7, 16, "IndexSubentry",
  CellTags->"Color"],
Cell[84329, 3359, 251, 8, 16, "Index",
  CellTags->"color 3-Script command"],
Cell[84583, 3369, 217, 8, 16, "Index",
  CellTags->"ColorCircle"],
Cell[84803, 3379, 476, 16, 16, "Index",
  CellTags->"ColorFunction"],
Cell[85282, 3397, 259, 8, 16, "Index",
  CellTags->"colormesh 3-Script command"],
Cell[85544, 3407, 217, 8, 16, "Index",
  CellTags->"Colors package"],
Cell[85764, 3417, 225, 8, 16, "Index",
  CellTags->"Column"],
Cell[85992, 3427, 233, 8, 16, "Index",
  CellTags->"ColumnDrop"],
Cell[86228, 3437, 233, 8, 16, "Index",
  CellTags->"ColumnJoin"],
Cell[86464, 3447, 233, 8, 16, "Index",
  CellTags->"ColumnTake"],
Cell[86700, 3457, 230, 7, 16, "Index",
  CellTags->"Combinations"],
Cell[86933, 3466, 289, 8, 16, "Index",
  CellTags->"CombinatorialFunctions package"],
Cell[87225, 3476, 253, 8, 16, "Index",
  CellTags->"Combinatorica package"],
Cell[87481, 3486, 241, 9, 16, "Index",
  CellTags->"Common Graphics package"],
Cell[87725, 3497, 251, 9, 16, "Index",
  CellTags->"Common Statistics packages"],
Cell[87979, 3508, 267, 9, 16, "Index",
  CellTags->"Complete integrals"],
Cell[88249, 3519, 248, 8, 16, "Index",
  CellTags->"CompleteBinaryTree"],
Cell[88500, 3529, 379, 12, 16, "Index",
  CellTags->"CompleteGraph"],
Cell[88882, 3543, 239, 8, 16, "Index",
  CellTags->"CompleteIntegral"],
Cell[89124, 3553, 244, 8, 16, "Index",
  CellTags->"CompleteKaryTree"],
Cell[89371, 3563, 254, 8, 16, "Index",
  CellTags->"CompleteKPartiteGraph"],
Cell[89628, 3573, 230, 8, 16, "Index",
  CellTags->"CompleteQ"],
Cell[89861, 3583, 219, 7, 16, "Index",
  CellTags->"Complex multiplication"],
Cell[90083, 3592, 205, 7, 16, "Index",
  CellTags->"Complex numbers"],
Cell[90291, 3601, 334, 11, 16, "IndexSubentry",
  CellTags->"Complex numbers"],
Cell[90628, 3614, 209, 8, 16, "Index",
  CellTags->"ComplexExpand"],
Cell[90840, 3624, 256, 8, 16, "Index",
  CellTags->"ComplexInequalityPlot"],
Cell[91099, 3634, 233, 8, 16, "Index",
  CellTags->"ComplexMap package"],
Cell[91335, 3644, 241, 8, 16, "Index",
  CellTags->"ComplexRootIntervals"],
Cell[91579, 3654, 353, 12, 16, "Index",
  CellTags->"CompositeBezier"],
Cell[91935, 3668, 214, 7, 16, "Index",
  CellTags->"Compositions"],
Cell[92152, 3677, 377, 12, 16, "Index",
  CellTags->"Compositions"],
Cell[92532, 3691, 249, 7, 16, "Index",
  CellTags->"Computational geometry"],
Cell[92784, 3700, 285, 8, 16, "Index",
  CellTags->"ComputationalGeometry package"],
Cell[93072, 3710, 239, 7, 16, "Index",
  CellTags->"Computer arithmetic"],
Cell[93314, 3719, 411, 12, 32, "Index",
  CellTags->"ComputerArithmetic package"],
Cell[93728, 3733, 251, 8, 16, "Index",
  CellTags->"ComputerNumber"],
Cell[93982, 3743, 285, 9, 16, "Index",
  CellTags->"Condition number"],
Cell[94270, 3754, 279, 9, 16, "Index",
  CellTags->"Conductivity"],
Cell[94552, 3765, 197, 8, 16, "Index",
  CellTags->"Cone"],
Cell[94752, 3775, 235, 7, 16, "Index",
  CellTags->"Confidence interval"],
Cell[94990, 3784, 229, 7, 16, "Index",
  CellTags->"Confidence level"],
Cell[95222, 3793, 273, 8, 16, "Index",
  CellTags->"ConfidenceIntervals package"],
Cell[95498, 3803, 249, 8, 16, "Index",
  CellTags->"ConfidenceLevel"],
Cell[95750, 3813, 285, 9, 16, "Index",
  CellTags->"Configuration"],
Cell[96038, 3824, 243, 8, 16, "Index",
  CellTags->"ConfocalEllipsoidal"],
Cell[96284, 3834, 245, 8, 16, "Index",
  CellTags->"ConfocalParaboloidal"],
Cell[96532, 3844, 288, 9, 16, "Index",
  CellTags->"Congruences"],
Cell[96823, 3855, 219, 8, 16, "Index",
  CellTags->"Conical"],
Cell[97045, 3865, 328, 12, 16, "Index",
  CellTags->"Conjugate"],
Cell[97376, 3879, 391, 12, 16, "Index",
  CellTags->"ConnectedComponents"],
Cell[97770, 3893, 373, 12, 16, "Index",
  CellTags->"Connect