(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    115141,       4182]*)
(*NotebookOutlinePosition[    131378,       4649]*)
(*  CellTagsIndexPosition[    130038,       4594]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "Butcher",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.78.1", "1.1"}],

Cell[TextData[{
 "Runge\[Hyphen]Kutta methods are useful for numerically solving certain \
types of ordinary differential equations. Deriving high\[Hyphen]order Runge\
\[Hyphen]Kutta methods is no easy task, however. There are several reasons \
for this. The first difficulty is in finding the so\[Hyphen]called order \
conditions. These are nonlinear equations in the coefficients for the method \
that must be satisfied to make the error in the method of order ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["O",
     "TI"], 
    RowBox[{"(", 
     SuperscriptBox[
      StyleBox["h",
       "TI"], 
      StyleBox["n",
       "TI"]], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for some integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["h",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the step size. The second difficulty is in solving these equations. \
Besides being nonlinear, there is generally no unique solution, and many \
heuristics and simplifying assumptions are usually made. Finally, there is \
the problem of combinatorial explosion. For a twelfth\[Hyphen]order method \
there are 7813 order conditions! "
}], "Text",
 CellTags->{"S5.78.1", "1.2"}],

Cell[TextData[{
 "This package performs the first task: finding the order conditions that \
must be satisfied. The result is expressed in terms of unknown coefficients \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox[
     RowBox[{"i", "j"}],
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["b",
     "TI"], 
    StyleBox["j",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]stage Runge\[Hyphen]Kutta method to advance from ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "+", 
    StyleBox["h",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is then "
}], "Text",
 CellTags->{"S5.78.1", "1.3"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["Y",
    "TI"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["x",
      "TI"], "+", 
     StyleBox["h",
      "TI"]}], ")"}], "=", 
   StyleBox["y",
    "TI"], 
   RowBox[{"(", 
    StyleBox["x",
     "TI"], ")"}], "+", 
   StyleBox["h",
    "TI"], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["j",
      "TI"], "=", "1"}], 
    StyleBox["s",
     "TI"],
    LimitsPositioning->False], 
   SubscriptBox[
    StyleBox["b",
     "TI"], 
    StyleBox["j",
     "TI"]], " ", 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["Y",
       "TI"], 
      StyleBox["j",
       "TI"]], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "+", 
       StyleBox["h",
        "TI"]}], ")"}]}], ")"}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.78.1", "1.4"}],

Cell["where ", "Text",
 CellTags->{"S5.78.1", "1.5"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    StyleBox["Y",
     "TI"], 
    StyleBox["i",
     "TI"]], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["x",
      "TI"], "+", 
     StyleBox["h",
      "TI"]}], ")"}], "=", 
   StyleBox["y",
    "TI"], 
   RowBox[{"(", 
    StyleBox["x",
     "TI"], ")"}], "+", 
   StyleBox["h",
    "TI"], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["j",
      "TI"], "=", "1"}], 
    StyleBox["s",
     "TI"],
    LimitsPositioning->False], 
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox[
     RowBox[{"i", "j"}],
     "TI"]], " ", 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["Y",
       "TI"], 
      StyleBox["j",
       "TI"]], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["x",
        "TI"], "+", 
       StyleBox["h",
        "TI"]}], ")"}]}], ")"}], 
   RowBox[{",", "    "}], 
   StyleBox["i",
    "TI"], "=", "1", ",", "2", ",", "\[Ellipsis]", ",", 
   StyleBox["s",
    "TI"]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.78.1", "1.6"}],

Cell[TextData[{
 "Sums of the elements in the rows of the matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    SubscriptBox[
     StyleBox["a",
      "TI"], 
     StyleBox[
      RowBox[{"i", "j"}],
      "TI"]], "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " occur repeatedly in the conditions imposed on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox[
     RowBox[{"i", "j"}],
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["b",
     "TI"], 
    StyleBox["j",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In recognition of this and as a notational convenience it is usual to \
introduce the coefficients ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the definition "
}], "Text",
 CellTags->{"S5.78.1", "1.7"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    StyleBox["c",
     "TI"], 
    StyleBox["i",
     "TI"]], "=", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["j",
      "TI"], "=", "1"}], 
    StyleBox["s",
     "TI"],
    LimitsPositioning->False], 
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox[
     RowBox[{"i", "j"}],
     "TI"]], 
   RowBox[{",", "    "}], 
   StyleBox["i",
    "TI"], "=", "1", ",", "2", ",", "\[Ellipsis]", ",", 
   StyleBox["s",
    "TI"]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.78.1", "1.8"}],

Cell["\<\
This definition is referred to as the row\[Hyphen]sum condition and is the \
first in a sequence of row\[Hyphen]simplifying conditions. \
\>", "Text",
 CellTags->{"S5.78.1", "1.9"}],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["a",
      "TI"], 
     StyleBox[
      RowBox[{"i", "j"}],
      "TI"]], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i",
     "TI"], "<", "=", 
    StyleBox["j",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " the method is ",
 StyleBox["explicit", "TI"],
 "; that is, each of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["Y",
      "TI"], 
     StyleBox["i",
      "TI"]], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x",
       "TI"], "+", 
      StyleBox["h",
       "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is defined in terms of previously computed values. If the matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    SubscriptBox[
     StyleBox["a",
      "TI"], 
     StyleBox[
      RowBox[{"i", "j"}],
      "TI"]], "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not strictly lower triangular, the method is ",
 StyleBox["implicit", "TI"],
 " and requires the solution of a (generally nonlinear) system of equations \
for each timestep. A diagonally implicit method has ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["a",
      "TI"], 
     StyleBox[
      RowBox[{"i", "j"}],
      "TI"]], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i",
     "TI"], "<", 
    StyleBox["j",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.78.1", "1.10"}],

Cell[TextData[{
 "There are several ways to express the order conditions. If the number of \
stages ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is specified as a positive integer, the order conditions are expressed in \
terms of sums of explicit terms. If the number of stages is specified as a \
symbol, the order conditions will involve symbolic sums. If the number of \
stages is not specified at all, the order conditions will be expressed in \
stage\[Hyphen]independent tensor notation. In addition to the matrix ",
 StyleBox["a", "MR"],
 " and the vectors ",
 StyleBox["b", "MR"],
 " and ",
 StyleBox["c", "MR"],
 ", this notation involves the vector ",
 StyleBox["e", "MR"],
 ", which is composed of all ones. This notation has two distinct advantages: \
it is independent of the number of stages ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and it is independent of the particular Runge\[Hyphen]Kutta method. "
}], "Text",
 CellTags->{"S5.78.1", "1.11"}],

Cell["For further details of the theory see the references. ", "Text",
 CellTags->{"S5.78.1", "1.12"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "MR"], 
         RowBox[{
          StyleBox["i",
           "MR"], ",", 
          StyleBox["j",
           "MR"]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the coefficient of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["Y",
             "TI"], 
            StyleBox["j",
             "TI"]], 
           RowBox[{"(", 
            StyleBox["x",
             "TI"], ")"}]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the formula for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["Y",
           "TI"], 
          StyleBox["i",
           "TI"]], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of the method",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "MR"], 
         StyleBox["j",
          "MR"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the coefficient of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox[
            StyleBox["Y",
             "TI"], 
            StyleBox["j",
             "TI"]], 
           RowBox[{"(", 
            StyleBox["x",
             "TI"], ")"}]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the formula for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["Y",
          "TI"], 
         RowBox[{"(", 
          StyleBox["x",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of the method",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "MR"], 
         StyleBox["i",
          "MR"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a notational convenience for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{
           StyleBox["j",
            "TI"], "=", "1"}], 
          StyleBox["s",
           "TI"],
          LimitsPositioning->True], 
         SubscriptBox[
          StyleBox["a",
           "TI"], 
          StyleBox[
           RowBox[{"i", "j"}],
           "TI"]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["e", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a notational convenience for the vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{"1", 
          RowBox[{",", " "}], "1", 
          RowBox[{",", " "}], "1", 
          RowBox[{",", " "}], "\[Ellipsis]"}], ")"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell[TextData[{
 "Notation used by functions in ",
 StyleBox["NumericalMath`Butcher`", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.78.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RungeKuttaOrderConditions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the order conditions that any ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]stage Runge\[Hyphen]Kutta method of order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" must satisfy",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherPrincipalError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " terms appearing in the Taylor series expansion of the error for an \
order\[Hyphen]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]stage Runge\[Hyphen]Kutta method ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RungeKuttaOrderConditions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ButcherPrincipalError[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the result in stage\[Hyphen]independent tensor notation ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell["\<\
Functions associated with the order conditions of Runge\[Hyphen]Kutta \
methods. \
\>", "Caption",
 CellTags->"S5.78.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ButcherRowSum", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["specify whether the row\[Hyphen]sum conditions for the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " should be explicitly included in the list of order conditions",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherSimplify", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify whether to apply Butcher\[CloseCurlyQuote]s row and column \
simplifying assumptions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell[TextData[{
 "Some options for ",
 StyleBox["RungeKuttaOrderConditions", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.78.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.78.1", "1.13"}],

Cell["<< NumericalMath`Butcher`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.78.1"],

Cell[TextData[{
 "This gives the number of order conditions for each order up through order \
",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Notice the combinatorial explosion. "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.14"}],

Cell[CellGroupData[{

Cell["Length /@ RungeKuttaOrderConditions[10]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "4", ",", "9", ",", "20", ",", "48", ",", 
   "115", ",", "286", ",", "719"}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
This gives the order conditions that must be satisfied by any \
first\[Hyphen]order, 3\[Hyphen]stage Runge\[Hyphen]Kutta method, explicitly \
including the row\[Hyphen]sum conditions. \
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
RungeKuttaOrderConditions[1, 3,
    ButcherRowSum -> True]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], "+", 
       SubscriptBox["a", 
        RowBox[{"1", ",", "2"}]], "+", 
       SubscriptBox["a", 
        RowBox[{"1", ",", "3"}]]}], "\[Equal]", 
      SubscriptBox["c", "1"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"2", ",", "1"}]], "+", 
       SubscriptBox["a", 
        RowBox[{"2", ",", "2"}]], "+", 
       SubscriptBox["a", 
        RowBox[{"2", ",", "3"}]]}], "\[Equal]", 
      SubscriptBox["c", "2"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"3", ",", "1"}]], "+", 
       SubscriptBox["a", 
        RowBox[{"3", ",", "2"}]], "+", 
       SubscriptBox["a", 
        RowBox[{"3", ",", "3"}]]}], "\[Equal]", 
      SubscriptBox["c", "3"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
These are the order conditions that must be satisfied by any \
second\[Hyphen]order, 3\[Hyphen]stage Runge\[Hyphen]Kutta method. Here the \
row\[Hyphen]sum conditions are not included. \
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.16"}],

Cell[CellGroupData[{

Cell["RungeKuttaOrderConditions[2, 3]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
It should be noted that the sums involved on the left\[Hyphen]hand sides of \
the order conditions will be left in symbolic form and not expanded if the \
number of stages is left as a symbolic argument. This will greatly simplify \
the results for high\[Hyphen]order, many\[Hyphen]stage methods. An even more \
compact form results if you do not specify the number of stages at all and \
the answer is given in tensor form. \
\>", "Text",
 CellTags->{"S5.78.1", "1.17"}],

Cell[TextData[{
 "These are the order conditions that must be satisfied by any \
second\[Hyphen]order, ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]stage method. "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.18"}],

Cell[CellGroupData[{

Cell["RungeKuttaOrderConditions[2, s]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "s"], 
      SubscriptBox["b", "i"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "s"], 
      RowBox[{
       SubscriptBox["b", "i"], " ", 
       SubscriptBox["c", "i"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "Replacing ",
 StyleBox["s", "MR"],
 " by 3 gives the same result as\[NonBreakingSpace]",
 StyleBox["RungeKuttaOrderConditions[2,", "MR"],
 " ",
 StyleBox["3]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.19"}],

Cell[CellGroupData[{

Cell["% /. s -> 3", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "These are the order conditions that must be satisfied by any \
second\[Hyphen]order method. This uses tensor notation. The vector ",
 StyleBox["e", "MR"],
 " is a vector of ones whose length is the number of stages. "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.20"}],

Cell[CellGroupData[{

Cell["RungeKuttaOrderConditions[2]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "e"}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "c"}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
The tensor notation can likewise be expanded to give the conditions in full. \
\
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
% /. {a -> Array[a,{3,3}], b -> Array[b,3],
        c -> Array[c,3], e -> {1,1,1}}\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
These are the principal error coefficients for any third\[Hyphen]order \
method. \
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.22"}],

Cell[CellGroupData[{

Cell["ButcherPrincipalError[3]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "24"]}], "+", 
    RowBox[{"b", ".", "a", ".", "a", ".", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "12"]}], "+", 
      RowBox[{"b", ".", "a", ".", 
       SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], "+", 
    RowBox[{"b", ".", 
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"a", ".", "c"}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], "+", 
      RowBox[{"b", ".", 
       SuperscriptBox["c", "3"]}]}], ")"}]}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "This is a bound on the local error of any third\[Hyphen]order method in the \
limit as ",
 StyleBox["h", "MR"],
 " approaches 0, normalized to eliminate the effects of the ODE. "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.23"}],

Cell[CellGroupData[{

Cell["(Plus @@ Abs[%]) h^4", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["h", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], "+", 
       RowBox[{"b", ".", 
        SuperscriptBox["c", "3"]}]}], "]"}]}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "8"]}], "+", 
      RowBox[{"b", ".", 
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"a", ".", "c"}]}], ")"}]}]}], "]"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "12"]}], "+", 
       RowBox[{"b", ".", "a", ".", 
        SuperscriptBox["c", "2"]}]}], "]"}]}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "24"]}], "+", 
      RowBox[{"b", ".", "a", ".", "a", ".", "c"}]}], "]"}]}], 
   ")"}]}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
Here are the order conditions that must be satisfied by any \
fourth\[Hyphen]order, 1\[Hyphen]stage Runge\[Hyphen]Kutta method. Note that \
there is no possible way for these order conditions to be satisfied; there \
need to be more stages (the second argument must be larger) for there to be \
sufficiently many unknowns to satisfy all of the conditions. \
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.24"}],

Cell[CellGroupData[{

Cell["RungeKuttaOrderConditions[4, 1]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["b", "1"], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], " ", 
      SubscriptBox["c", "1"]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "\[Equal]", 
      FractionBox["1", "6"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "2"]}], "\[Equal]", 
      FractionBox["1", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubsuperscriptBox["a", 
        RowBox[{"1", ",", "1"}], "2"], " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "\[Equal]", 
      FractionBox["1", "24"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], " ", 
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "2"]}], "\[Equal]", 
      FractionBox["1", "12"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], " ", 
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "2"]}], "\[Equal]", 
      FractionBox["1", "8"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "3"]}], "\[Equal]", 
      FractionBox["1", "4"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RungeKuttaMethod", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify the type of Runge\[Hyphen]Kutta method for which order \
conditions are being sought",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Explicit", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a setting for the option ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["RungeKuttaMethod", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " specifying that the order conditions are to be for an explicit Runge\
\[Hyphen]Kutta method ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DiagonallyImplicit", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a setting for the option ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["RungeKuttaMethod", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " specifying that the order conditions are to be for a diagonally \
implicit Runge\[Hyphen]Kutta method ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Implicit", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a setting for the option ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["RungeKuttaMethod", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " specifying that the order conditions are to be for an implicit Runge\
\[Hyphen]Kutta method ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["$RungeKuttaMethod", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a global variable whose value can be set to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Explicit", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["DiagonallyImplicit", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", or ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Implicit", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell[TextData[{
 "Controlling the type of Runge\[Hyphen]Kutta method in ",
 StyleBox["RungeKuttaOrderConditions", "MR"],
 " and related functions. "
}], "Caption",
 CellTags->"S5.78.1"],

Cell[TextData[{
 StyleBox["RungeKuttaOrderConditions", "MR"],
 " and certain related functions have the option ",
 StyleBox["RungeKuttaMethod", "MR"],
 " with default setting ",
 StyleBox["$RungeKuttaMethod", "MR"],
 ". Normally you will want to determine the Runge\[Hyphen]Kutta method being \
considered by setting ",
 StyleBox["$RungeKuttaMethod", "MR"],
 " to one of ",
 StyleBox["Implicit", "MR"],
 ", ",
 StyleBox["DiagonallyImplicit", "MR"],
 ", and ",
 StyleBox["Explicit", "MR"],
 ", but you can specify an option setting or even change the default for an \
individual function. "
}], "Text",
 CellTags->{"S5.78.1", "1.25"}],

Cell["\<\
These are the order conditions that must be satisfied by any \
second\[Hyphen]order, 3\[Hyphen]stage diagonally implicit Runge\[Hyphen]Kutta \
method. \
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.26"}],

Cell[CellGroupData[{

Cell["\<\
RungeKuttaOrderConditions[2, 3,
    RungeKuttaMethod -> DiagonallyImplicit]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "An alternative (but less efficient) way to get a diagonally implicit method \
is to force ",
 StyleBox["a", "MR"],
 " to be lower triangular by replacing upper\[Hyphen]triangular elements with \
0. "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.27"}],

Cell[CellGroupData[{

Cell["\<\
RungeKuttaOrderConditions[2, 3] /.
    a[i_,j_]:>0 /; i<j\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
These are the order conditions that must be satisfied by any \
third\[Hyphen]order, 2\[Hyphen]stage explicit Runge\[Hyphen]Kutta method. The \
contradiction in the order conditions indicates that no such method is \
possible, a result which holds for any explicit Runge\[Hyphen]Kutta method \
when the number of stages is less than the order. \
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.28"}],

Cell[CellGroupData[{

Cell["\<\
RungeKuttaOrderConditions[3, 2,
    RungeKuttaMethod -> Explicit]\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "2"], " ", 
      SubscriptBox["c", "2"]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubsuperscriptBox["c", "2", "2"]}], "\[Equal]", 
      FractionBox["1", "3"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ButcherColumnConditions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the column simplifying conditions up to and including order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" stages ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherRowConditions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the row simplifying conditions up to and including order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" stages ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherQuadratureConditions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the quadrature conditions up to and including order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["s",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" stages ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherColumnConditions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ButcherRowConditions[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", etc. ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the result in stage\[Hyphen]independent tensor notation ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell["\<\
More functions associated with the order conditions of Runge\[Hyphen]Kutta \
methods. \
\>", "Caption",
 CellTags->"S5.78.1"],

Cell[TextData[{
 "Butcher showed that the number and complexity of the order conditions can \
be reduced considerably at high orders by the adoption of so\[Hyphen]called \
simplifying assumptions. For example, this reduction can be accomplished by \
adopting sufficient row and column simplifying assumptions and quadrature\
\[Hyphen]type order conditions. The option ",
 StyleBox["ButcherSimplify", "MR"],
 " in ",
 StyleBox["RungeKuttaOrderConditions", "MR"],
 " can be used to determine these automatically. "
}], "Text",
 CellTags->{"S5.78.1", "1.29"}],

Cell["These are the column simplifying conditions up to order 4. ", \
"MathCaption",
 CellTags->{"S5.78.1", "1.30"}],

Cell[CellGroupData[{

Cell["ButcherColumnConditions[4]", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", ".", "a"}], "\[Equal]", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "c"}], "+", "e"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", " ", "c"}], ")"}], ".", "a"}], "\[Equal]", 
    RowBox[{
     FractionBox["1", "2"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "+", "e"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], ")"}], ".", "a"}], "\[Equal]", 
    RowBox[{
     FractionBox["1", "3"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "3"]}], "+", "e"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], ")"}], ".", "a"}], "\[Equal]", 
    RowBox[{
     FractionBox["1", "4"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "4"]}], "+", "e"}], ")"}]}]}]}], "}"}]], "Output",\

 CellLabel->"Out[15]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["These are the row simplifying conditions up to order 4. ", "MathCaption",
 CellTags->{"S5.78.1", "1.31"}],

Cell[CellGroupData[{

Cell["ButcherRowConditions[4]", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", ".", "e"}], "\[Equal]", "c"}], ",", 
   RowBox[{
    RowBox[{"a", ".", "c"}], "\[Equal]", 
    FractionBox[
     SuperscriptBox["c", "2"], "2"]}], ",", 
   RowBox[{
    RowBox[{"a", ".", 
     SuperscriptBox["c", "2"]}], "\[Equal]", 
    FractionBox[
     SuperscriptBox["c", "3"], "3"]}], ",", 
   RowBox[{
    RowBox[{"a", ".", 
     SuperscriptBox["c", "3"]}], "\[Equal]", 
    FractionBox[
     SuperscriptBox["c", "4"], "4"]}]}], "}"}]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["These are the quadrature conditions up to order 4. ", "MathCaption",
 CellTags->{"S5.78.1", "1.32"}],

Cell[CellGroupData[{

Cell["ButcherQuadratureConditions[4]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "e"}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "c"}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", 
      SuperscriptBox["c", "2"]}], "\[Equal]", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", 
      SuperscriptBox["c", "3"]}], "\[Equal]", 
     FractionBox["1", "4"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "Trees are fundamental objects in Butcher\[CloseCurlyQuote]s formalism. They \
yield both the derivative in a power series expansion of a \
Runge\[Hyphen]Kutta method ",
 StyleBox["and", "TI"],
 " the related order constraint on the coefficients. This package provides a \
number of functions related to Butcher trees. "
}], "Text",
 CellTags->{"S5.78.1", "1.33"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["f", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the elementary symbol used in the representation of Butcher trees",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherTrees[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list, partitioned by order, of the trees for any \
Runge\[Hyphen]Kutta method of order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherTreeSimplify[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Eta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Xi]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the set of trees through order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " that are not reduced by Butcher\[CloseCurlyQuote]s simplifying \
assumptions, assuming that the quadrature conditions through order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", the row simplifying conditions through order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Eta]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and the column simplifying conditions through order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Xi]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " all hold. The result is grouped by order, starting with the first \
nonvanishing trees",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherTreeCount[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the number of trees through order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherTreeQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" if the tree or list of trees ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is valid functional syntax, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" otherwise",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell["Constructing and enumerating Butcher trees. ", "Caption",
 CellTags->"S5.78.1"],

Cell[TextData[{
 "This gives the trees that are needed for any third\[Hyphen]order method. \
The trees are represented in a functional form in terms of the elementary \
symbol ",
 StyleBox["f", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.34"}],

Cell[CellGroupData[{

Cell["ButcherTrees[3]", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "f", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", "[", "f", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "f", "]"}], "]"}], ",", 
     RowBox[{"f", "[", 
      SuperscriptBox["f", "2"], "]"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "This tests the validity of the syntax of two trees. Butcher trees must be \
constructed using multiplication, exponentiation or application of the \
function ",
 StyleBox["f", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.35"}],

Cell[CellGroupData[{

Cell["ButcherTreeQ /@ {f[f[f[f] f^2]], f[f f[f+f]]}", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "This evaluates the number of trees at each order through order 10. The \
result is equivalent to ",
 StyleBox["Out[2]", "MR"],
 " but the calculation is much more efficient since it does not actually \
involve constructing order conditions or trees. "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.36"}],

Cell[CellGroupData[{

Cell["ButcherTreeCount[10]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "4", ",", "9", ",", "20", ",", "48", ",", 
   "115", ",", "286", ",", "719"}], "}"}]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "The previous result can be used to calculate the ",
 StyleBox["total", "TI"],
 " number of trees required at each order through order\[NonBreakingSpace]10. \
"
}], "MathCaption",
 CellTags->{"S5.78.1", "1.37"}],

Cell[CellGroupData[{

Cell["FoldList[ Plus, First[%], Rest[%] ]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "8", ",", "17", ",", "37", ",", "85", ",", 
   "200", ",", "486", ",", "1205"}], "}"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "The number of constraints for a method using row and column simplifying \
assumptions depends upon the number of stages. ",
 StyleBox["ButcherTreeSimplify", "MR"],
 " gives the Butcher trees that are not reduced assuming that these \
assumptions hold. "
}], "Text",
 CellTags->{"S5.78.1", "1.38"}],

Cell["\<\
This gives the additional trees that are necessary for a fourth\[Hyphen]order \
method assuming that the quadrature conditions through order 4 and the row \
and column simplifying assumptions of order 1 hold. The result is a single \
tree of order 4 (which corresponds to a single fourth\[Hyphen]order \
condition). \
\>", "MathCaption",
 CellTags->{"S5.78.1", "1.39"}],

Cell[CellGroupData[{

Cell["ButcherTreeSimplify[4, 1, 1]", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "[", 
    RowBox[{"f", " ", 
     RowBox[{"f", "[", "f", "]"}]}], "]"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
It is often useful to be able to visualize a tree or forest of trees \
graphically. For example, depicting trees yields insight, which can in turn \
be used to aid in the construction of Runge\[Hyphen]Kutta methods. \
\>", "Text",
 CellTags->{"S5.78.1", "1.40"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ButcherPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a plot of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherPlot[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["tree",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["tree",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give an array of plots of the trees in the forest ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["tree",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["tree",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell["Drawing Butcher trees. ", "Caption",
 CellTags->"S5.78.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ButcherPlotColumns", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["specify the number of columns in the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["GraphicsArray", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" plot of a list of trees",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherPlotLabel", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify a list of plot labels to be used to label the nodes of the \
plot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherPlotNodeSize", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify a scaling factor for the nodes of the trees in the plot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherPlotRootSize", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify a scaling factor for the highlighting of the root of each tree \
in the plot; a zero value does not highlight roots ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell[TextData[{
 "Options to ",
 StyleBox["ButcherPlot", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.78.1"],

Cell["This plots and labels the trees through order 4. ", "MathCaption",
 CellTags->{"S5.78.1", "1.41"}],

Cell[CellGroupData[{

Cell["\<\
ButcherPlot[ #,
    ButcherPlotLabel -> (InputForm /@ #)]& @
        Flatten[ ButcherTrees[4] ]\
\>", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.78.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0238095 0.183286 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0238095 0.321429 0.321429 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -30.8125 0 ]
[.5 1.74455 30.8125 10.125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -91.8125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 11.250 moveto
(@) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
82.812 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(*) show
90.625 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.625 11.250 moveto
(@) show
102.625 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.625 11.250 moveto
(D) show
114.625 11.250 moveto
(D) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
.5 Mabswid
.5 .08572 m
.28601 .60592 L
s
.06049 w
.28601 .60592 Mdot
.5 Mabswid
.5 .08572 m
.71399 .60592 L
s
.06049 w
.71399 .60592 Mdot
.5 Mabswid
.71399 .60592 m
.71399 1.12613 L
s
.06049 w
.71399 1.12613 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.0238095 0.64881 0.321429 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -21.1875 0 ]
[.5 1.74455 21.1875 10.125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -82.1875 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 11.250 moveto
(@) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
82.188 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(^) show
89.375 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
95.375 11.250 moveto
(D) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
.5 Mabswid
.5 .08572 m
.21468 .60592 L
s
.06049 w
.21468 .60592 Mdot
.5 Mabswid
.5 .08572 m
.5 .60592 L
s
.06049 w
.5 .60592 Mdot
.5 Mabswid
.5 .08572 m
.78532 .60592 L
s
.06049 w
.78532 .60592 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.35119 0.321429 0.64881 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -21.1875 0 ]
[.5 1.74455 21.1875 10.125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -82.1875 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 11.250 moveto
(@) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
82.188 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(^) show
89.375 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
95.375 11.250 moveto
(D) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
.5 Mabswid
.5 .08572 m
.28601 .60592 L
s
.06049 w
.28601 .60592 Mdot
.5 Mabswid
.5 .08572 m
.71399 .60592 L
s
.06049 w
.71399 .60592 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.35119 0.64881 0.64881 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -32 0 ]
[.5 1.74455 32 10.125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -93 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 11.250 moveto
(@) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
81.000 11.250 moveto
(@) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 11.250 moveto
(@) show
99.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
105.000 11.250 moveto
(D) show
111.000 11.250 moveto
(D) show
117.000 11.250 moveto
(D) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
.5 Mabswid
.5 .08572 m
.5 .60592 L
s
.06049 w
.5 .60592 Mdot
.5 Mabswid
.5 .60592 m
.5 1.12613 L
s
.06049 w
.5 1.12613 Mdot
.5 Mabswid
.5 1.12613 m
.5 1.64633 L
s
.06049 w
.5 1.64633 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.35119 0.97619 0.64881 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -30.1875 0 ]
[.5 1.74455 30.1875 10.125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -91.1875 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 11.250 moveto
(@) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
81.000 11.250 moveto
(@) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
94.188 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(^) show
101.375 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
107.375 11.250 moveto
(D) show
113.375 11.250 moveto
(D) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
.5 Mabswid
.5 .08572 m
.5 .60592 L
s
.06049 w
.5 .60592 Mdot
.5 Mabswid
.5 .60592 m
.28601 1.12613 L
s
.06049 w
.28601 1.12613 Mdot
.5 Mabswid
.5 .60592 m
.71399 1.12613 L
s
.06049 w
.71399 1.12613 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.678571 0.321429 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -5 0 ]
[.5 1.74455 5 9.8125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.678571 0.64881 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -14 0 ]
[.5 1.74455 14 10.125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 11.250 moveto
(@) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
81.000 11.250 moveto
(D) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
.5 Mabswid
.5 .08572 m
.5 .60592 L
s
.06049 w
.5 .60592 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.678571 0.97619 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.901023 0.0857169 1.56062 [
[.5 1.74455 -23 0 ]
[.5 1.74455 23 10.125 ]
[ 0 0 0 0 ]
[ 1 1.73205 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 1.74455 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 11.250 moveto
(@) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
81.000 11.250 moveto
(@) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 11.250 moveto
(D) show
99.000 11.250 moveto
(D) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1.73205 L
0 1.73205 L
closepath
clip
newpath
.06049 w
.5 .08572 Mdot
.5 Mabswid
[ ] 0 setdash
newpath
matrix currentmatrix
0.0604919 0.0604919 scale
8.26557 1.41705 1 0 365.73 arc
setmatrix s
.06049 w
.5 .08572 Mdot
.5 Mabswid
.5 .08572 m
.5 .60592 L
s
.06049 w
.5 .60592 Mdot
.5 Mabswid
.5 .60592 m
.5 1.12613 L
s
.06049 w
.5 1.12613 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.78.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "GraphicsArray", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell["\<\
In addition to generating and drawing Butcher trees, many functions are \
provided for measuring and manipulating them. For a complete description of \
the importance of these functions, see Butcher\[NonBreakingSpace][1]. \
\>", "Text",
 CellTags->{"S5.78.1", "1.42"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ButcherHeight[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the height of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherWidth[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the width of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherOrder[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the order, or number of vertices, of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherAlpha[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the number of ways of labeling the vertices of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with a totally ordered set of labels such that if ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["m",
           "TI"], 
          RowBox[{",", " "}], 
          StyleBox["n",
           "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is an edge, then ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["m",
          "TI"], "<", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherBeta[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the number of ways of labeling the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ButcherOrder[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]-1", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " distinct labels such that the root is not labeled, but every other \
vertex is labeled",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherBeta[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the number of ways of labeling ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of the vertices of the tree with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " distinct labels such that every leaf is labeled and the root is not \
labeled",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherBetaBar[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the number of ways of labeling the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ButcherOrder[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " distinct labels such that every node, including the root, is labeled",
       
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherBetaBar[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the number of ways of labeling ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of the vertices of the tree with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" distinct labels such that every leaf is labeled",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherGamma[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the density of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      "; the reciprocal of the density is the right\[Hyphen]hand side of the \
order condition imposed by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherPhi[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the weight of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["; the weight ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[CapitalPhi]", 
         RowBox[{"(", 
          StyleBox[
           RowBox[{"t", "r", "e", "e"}],
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the left\[Hyphen]hand side of the order condition imposed by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherPhi[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[CapitalPhi]", 
         RowBox[{"(", 
          StyleBox[
           RowBox[{"t", "r", "e", "e"}],
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using tensor notation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ButcherSigma[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the order of the symmetry group of isomorphisms of the tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with itself",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.78.1"],

Cell["Other functions associated with Butcher trees. ", "Caption",
 CellTags->"S5.78.1"],

Cell[TextData[{
 "This gives the order of the tree ",
 StyleBox["f[f[f[f]", "MR"],
 " ",
 StyleBox["f^2]]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.43"}],

Cell[CellGroupData[{

Cell["ButcherOrder[f[f[f[f] f^2]]]", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData["6"], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the density of the tree ",
 StyleBox["f[f[f[f]", "MR"],
 " ",
 StyleBox["f^2]]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.44"}],

Cell[CellGroupData[{

Cell["ButcherGamma[f[f[f[f] f^2]]]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData["60"], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the elementary weight function imposed by ",
 StyleBox["f[f[f[f]", "MR"],
 " ",
 StyleBox["f^2]]", "MR"],
 " for an ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]stage method. "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.45"}],

Cell[CellGroupData[{

Cell["ButcherPhi[f[f[f[f] f^2]], s]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"i", "=", "1"}], "s"], 
  RowBox[{
   SubscriptBox["b", "i"], " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"j", "=", "1"}], "s"], 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"i", ",", "j"}]], " ", 
     SubsuperscriptBox["c", "j", "2"], " ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "s"], 
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"j", ",", "k"}]], " ", 
       SubscriptBox["c", "k"]}]}]}]}]}]}]], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "The subscript notation is a formatting device and the subscripts are really \
just the indexed variable ",
 StyleBox["NumericalMath`Butcher`Private`$i", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.78.1", "1.46"}],

Cell[CellGroupData[{

Cell["FullForm[%[[1,1]]]", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.78.1"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"b", "[", "NumericalMath`Butcher`Private`$i1", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 CellLabel->"Out[27]//FullForm= ",
 CellTags->"S5.78.1"]
}, Open  ]],

Cell[TextData[{
 "It is also possible to obtain solutions to the order conditions using ",
 StyleBox["Solve", "MR"],
 " and related functions. Many issues related to the construction Runge\
\[Hyphen]Kutta methods using this package can be found in Sofroniou\
\[NonBreakingSpace][6]. The article also contains details concerning \
algorithms used in ",
 StyleBox["Butcher.m", "MR"],
 " and discusses applications. "
}], "Text",
 CellTags->{"S5.78.1", "1.47"}],

Cell[CellGroupData[{

Cell["References", "Subsubsection",
 CellTags->{"S5.78.1", "1.48"}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "1", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["The Numerical Analysis of Ordinary Differential Equations: Runge\
\[Hyphen]Kutta and General Linear Methods", "TI"],
 ", J. C. Butcher, John Wiley and Sons, New York, 1987. \n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "2", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["A First Course in the Numerical Analysis of Differential Equations \
", "TI"],
 ", A.\[NonBreakingSpace]Iserles, Cambridge University Press, Cambridge, \
England, 1996. \n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "3", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["Numerical Methods for Ordinary Differential Systems, The Initial \
Value Problem", "TI"],
 ", J. D. Lambert, John Wiley and Sons, New York, 1991. \n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "4", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["Solving Ordinary Differential Equations I: Nonstiff Problems", 
  "TI"],
 ", E. Hairer, S. P. Norsett and G. Wanner, Second edition, Springer Verlag, \
New York, 1993. \n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "5", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ",
 StyleBox["Solving Ordinary Differential Equations II: Stiff and Differential \
Algebraic Problems", "TI"],
 ", E. Hairer and G. Wanner, Springer\[Hyphen]Verlag, New York, 1991. \n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "6", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " \[OpenCurlyDoubleQuote]Symbolic Derivation of Runge\[Hyphen]Kutta Methods\
\[CloseCurlyDoubleQuote], M. Sofroniou, ",
 StyleBox["Journal of Symbolic Computation", "TI"],
 ", 18(3), pp.\[NonBreakingSpace]265\[Dash]296, 1994. "
}], "Text",
 CellTags->{"S5.78.1", "1.49"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.78.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.78.1", "1.1"}],
    Cell[1916, 61, 1424, 37, 136, "Text",
      CellTags->{"S5.78.1", "1.2"}],
    Cell[3343, 100, 1371, 54, 56, "Text",
      CellTags->{"S5.78.1", "1.3"}],
    Cell[4717, 156, 982, 47, 54, "DisplayFormula",
      CellTags->{"S5.78.1", "1.4"}],
    Cell[5702, 205, 53, 1, 24, "Text",
      CellTags->{"S5.78.1", "1.5"}],
    Cell[5758, 208, 1184, 56, 54, "DisplayFormula",
      CellTags->{"S5.78.1", "1.6"}],
    Cell[6945, 266, 1122, 43, 56, "Text",
      CellTags->{"S5.78.1", "1.7"}],
    Cell[8070, 311, 671, 28, 54, "DisplayFormula",
      CellTags->{"S5.78.1", "1.8"}],
    Cell[8744, 341, 191, 4, 40, "Text",
      CellTags->{"S5.78.1", "1.9"}],
    Cell[8938, 347, 1882, 75, 72, "Text",
      CellTags->{"S5.78.1", "1.10"}],
    Cell[10823, 424, 1157, 29, 120, "Text",
      CellTags->{"S5.78.1", "1.11"}],
    Cell[11983, 455, 102, 1, 70, "Text",
      CellTags->{"S5.78.1", "1.12"}],
    Cell[12088, 458, 6086, 203, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[18177, 663, 136, 5, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[18316, 670, 4933, 148, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[23252, 820, 130, 4, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[23385, 826, 1720, 52, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[25108, 880, 126, 5, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[25237, 887, 79, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.13"}],
    Cell[25319, 890, 88, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[25410, 894, 302, 8, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.14"}],
    Cell[25737, 906, 102, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[25842, 910, 214, 6, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[26071, 919, 247, 5, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.15"}],
    Cell[26343, 928, 129, 5, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[26475, 935, 1140, 39, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[27630, 977, 248, 5, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.16"}],
    Cell[27903, 986, 94, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[28000, 990, 648, 23, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[28663, 1016, 481, 8, 70, "Text",
      CellTags->{"S5.78.1", "1.17"}],
    Cell[29147, 1026, 319, 10, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.18"}],
    Cell[29491, 1040, 94, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[29588, 1044, 544, 19, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[30147, 1066, 241, 9, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.19"}],
    Cell[30413, 1079, 74, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[30490, 1083, 648, 23, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[31153, 1109, 286, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.20"}],
    Cell[31464, 1119, 91, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[31558, 1123, 307, 11, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[31880, 1137, 142, 4, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.21"}],
    Cell[32047, 1145, 153, 5, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[32203, 1152, 648, 23, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[32866, 1178, 144, 4, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.22"}],
    Cell[33035, 1186, 87, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[33125, 1190, 842, 31, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[33982, 1224, 247, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.23"}],
    Cell[34254, 1234, 84, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[34341, 1238, 1011, 36, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[35367, 1277, 419, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.24"}],
    Cell[35811, 1288, 95, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[35909, 1292, 1647, 55, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[37571, 1350, 4117, 125, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[41691, 1477, 185, 5, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[41879, 1484, 633, 18, 70, "Text",
      CellTags->{"S5.78.1", "1.25"}],
    Cell[42515, 1504, 214, 5, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.26"}],
    Cell[42754, 1513, 147, 5, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[42904, 1520, 649, 23, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[43568, 1546, 268, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.27"}],
    Cell[43861, 1557, 129, 5, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[43993, 1564, 649, 23, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[44657, 1590, 406, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.28"}],
    Cell[45088, 1601, 137, 5, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[45228, 1608, 624, 22, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[45867, 1633, 6054, 185, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[51924, 1820, 135, 4, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[52062, 1826, 556, 11, 70, "Text",
      CellTags->{"S5.78.1", "1.29"}],
    Cell[52621, 1839, 116, 2, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.30"}],
    Cell[52762, 1845, 90, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[52855, 1849, 1179, 43, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[54049, 1895, 111, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.31"}],
    Cell[54185, 1900, 87, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[54275, 1904, 568, 20, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[54858, 1927, 106, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.32"}],
    Cell[54989, 1932, 94, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[55086, 1936, 596, 21, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[55697, 1960, 381, 8, 70, "Text",
      CellTags->{"S5.78.1", "1.33"}],
    Cell[56081, 1970, 6744, 198, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[62828, 2170, 85, 1, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[62916, 2173, 257, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.34"}],
    Cell[63198, 2184, 79, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[63280, 2188, 379, 13, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[63674, 2204, 257, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.35"}],
    Cell[63956, 2215, 109, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[64068, 2219, 127, 4, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[64210, 2226, 320, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.36"}],
    Cell[64555, 2237, 84, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[64642, 2241, 215, 6, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[64872, 2250, 228, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.37"}],
    Cell[65125, 2260, 99, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[65227, 2264, 217, 6, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[65459, 2273, 315, 7, 70, "Text",
      CellTags->{"S5.78.1", "1.38"}],
    Cell[65777, 2282, 379, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.39"}],
    Cell[66181, 2293, 92, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[66276, 2297, 205, 7, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[66496, 2307, 272, 5, 70, "Text",
      CellTags->{"S5.78.1", "1.40"}],
    Cell[66771, 2314, 3056, 94, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[69830, 2410, 64, 1, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[69897, 2413, 2557, 75, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[72457, 2490, 106, 5, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[72566, 2497, 104, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.41"}],
    Cell[72695, 2502, 167, 6, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[72865, 2510, 22073, 1016, 70, 22002, 1013, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.78.1"],
    Cell[94941, 3528, 186, 6, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[95142, 3537, 278, 5, 70, "Text",
      CellTags->{"S5.78.1", "1.42"}],
    Cell[95423, 3544, 14510, 449, 70, "DefinitionBox",
      CellTags->"S5.78.1"],
    Cell[109936, 3995, 88, 1, 70, "Caption",
      CellTags->"S5.78.1"],
    Cell[110027, 3998, 171, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.43"}],
    Cell[110223, 4009, 92, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[110318, 4013, 75, 2, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[110408, 4018, 173, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.44"}],
    Cell[110606, 4029, 92, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[110701, 4033, 76, 2, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[110792, 4038, 361, 13, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.45"}],
    Cell[111178, 4055, 93, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[111274, 4059, 608, 21, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[111897, 4083, 234, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.46"}],
    Cell[112156, 4093, 82, 2, 70, "Input",
      CellTags->"S5.78.1"],
    Cell[112241, 4097, 267, 9, 70, "Output",
      CellTags->"S5.78.1"],
    Cell[112523, 4109, 458, 10, 70, "Text",
      CellTags->{"S5.78.1", "1.47"}],
    Cell[113006, 4123, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.78.1", "1.48"}],
    Cell[113076, 4126, 2037, 52, 70, "Text",
      CellTags->{"S5.78.1", "1.49"}]},
  "1.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.78.1", "1.1"}]},
  "1.2"->{
    Cell[1916, 61, 1424, 37, 136, "Text",
      CellTags->{"S5.78.1", "1.2"}]},
  "1.3"->{
    Cell[3343, 100, 1371, 54, 56, "Text",
      CellTags->{"S5.78.1", "1.3"}]},
  "1.4"->{
    Cell[4717, 156, 982, 47, 54, "DisplayFormula",
      CellTags->{"S5.78.1", "1.4"}]},
  "1.5"->{
    Cell[5702, 205, 53, 1, 24, "Text",
      CellTags->{"S5.78.1", "1.5"}]},
  "1.6"->{
    Cell[5758, 208, 1184, 56, 54, "DisplayFormula",
      CellTags->{"S5.78.1", "1.6"}]},
  "1.7"->{
    Cell[6945, 266, 1122, 43, 56, "Text",
      CellTags->{"S5.78.1", "1.7"}]},
  "1.8"->{
    Cell[8070, 311, 671, 28, 54, "DisplayFormula",
      CellTags->{"S5.78.1", "1.8"}]},
  "1.9"->{
    Cell[8744, 341, 191, 4, 40, "Text",
      CellTags->{"S5.78.1", "1.9"}]},
  "1.10"->{
    Cell[8938, 347, 1882, 75, 72, "Text",
      CellTags->{"S5.78.1", "1.10"}]},
  "1.11"->{
    Cell[10823, 424, 1157, 29, 120, "Text",
      CellTags->{"S5.78.1", "1.11"}]},
  "1.12"->{
    Cell[11983, 455, 102, 1, 70, "Text",
      CellTags->{"S5.78.1", "1.12"}]},
  "1.13"->{
    Cell[25237, 887, 79, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.13"}]},
  "1.14"->{
    Cell[25410, 894, 302, 8, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.14"}]},
  "1.15"->{
    Cell[26071, 919, 247, 5, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.15"}]},
  "1.16"->{
    Cell[27630, 977, 248, 5, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.16"}]},
  "1.17"->{
    Cell[28663, 1016, 481, 8, 70, "Text",
      CellTags->{"S5.78.1", "1.17"}]},
  "1.18"->{
    Cell[29147, 1026, 319, 10, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.18"}]},
  "1.19"->{
    Cell[30147, 1066, 241, 9, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.19"}]},
  "1.20"->{
    Cell[31153, 1109, 286, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.20"}]},
  "1.21"->{
    Cell[31880, 1137, 142, 4, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.21"}]},
  "1.22"->{
    Cell[32866, 1178, 144, 4, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.22"}]},
  "1.23"->{
    Cell[33982, 1224, 247, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.23"}]},
  "1.24"->{
    Cell[35367, 1277, 419, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.24"}]},
  "1.25"->{
    Cell[41879, 1484, 633, 18, 70, "Text",
      CellTags->{"S5.78.1", "1.25"}]},
  "1.26"->{
    Cell[42515, 1504, 214, 5, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.26"}]},
  "1.27"->{
    Cell[43568, 1546, 268, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.27"}]},
  "1.28"->{
    Cell[44657, 1590, 406, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.28"}]},
  "1.29"->{
    Cell[52062, 1826, 556, 11, 70, "Text",
      CellTags->{"S5.78.1", "1.29"}]},
  "1.30"->{
    Cell[52621, 1839, 116, 2, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.30"}]},
  "1.31"->{
    Cell[54049, 1895, 111, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.31"}]},
  "1.32"->{
    Cell[54858, 1927, 106, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.32"}]},
  "1.33"->{
    Cell[55697, 1960, 381, 8, 70, "Text",
      CellTags->{"S5.78.1", "1.33"}]},
  "1.34"->{
    Cell[62916, 2173, 257, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.34"}]},
  "1.35"->{
    Cell[63674, 2204, 257, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.35"}]},
  "1.36"->{
    Cell[64210, 2226, 320, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.36"}]},
  "1.37"->{
    Cell[64872, 2250, 228, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.37"}]},
  "1.38"->{
    Cell[65459, 2273, 315, 7, 70, "Text",
      CellTags->{"S5.78.1", "1.38"}]},
  "1.39"->{
    Cell[65777, 2282, 379, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.39"}]},
  "1.40"->{
    Cell[66496, 2307, 272, 5, 70, "Text",
      CellTags->{"S5.78.1", "1.40"}]},
  "1.41"->{
    Cell[72566, 2497, 104, 1, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.41"}]},
  "1.42"->{
    Cell[95142, 3537, 278, 5, 70, "Text",
      CellTags->{"S5.78.1", "1.42"}]},
  "1.43"->{
    Cell[110027, 3998, 171, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.43"}]},
  "1.44"->{
    Cell[110408, 4018, 173, 7, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.44"}]},
  "1.45"->{
    Cell[110792, 4038, 361, 13, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.45"}]},
  "1.46"->{
    Cell[111897, 4083, 234, 6, 70, "MathCaption",
      CellTags->{"S5.78.1", "1.46"}]},
  "1.47"->{
    Cell[112523, 4109, 458, 10, 70, "Text",
      CellTags->{"S5.78.1", "1.47"}]},
  "1.48"->{
    Cell[113006, 4123, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.78.1", "1.48"}]},
  "1.49"->{
    Cell[113076, 4126, 2037, 52, 70, "Text",
      CellTags->{"S5.78.1", "1.49"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.78.1", 115764, 4198},
  {"1.1", 125252, 4443},
  {"1.2", 125346, 4446},
  {"1.3", 125437, 4449},
  {"1.4", 125528, 4452},
  {"1.5", 125628, 4455},
  {"1.6", 125716, 4458},
  {"1.7", 125817, 4461},
  {"1.8", 125908, 4464},
  {"1.9", 126008, 4467},
  {"1.10", 126098, 4470},
  {"1.11", 126191, 4473},
  {"1.12", 126286, 4476},
  {"1.13", 126378, 4479},
  {"1.14", 126476, 4482},
  {"1.15", 126575, 4485},
  {"1.16", 126674, 4488},
  {"1.17", 126773, 4491},
  {"1.18", 126866, 4494},
  {"1.19", 126967, 4497},
  {"1.20", 127067, 4500},
  {"1.21", 127167, 4503},
  {"1.22", 127267, 4506},
  {"1.23", 127367, 4509},
  {"1.24", 127467, 4512},
  {"1.25", 127567, 4515},
  {"1.26", 127661, 4518},
  {"1.27", 127761, 4521},
  {"1.28", 127861, 4524},
  {"1.29", 127961, 4527},
  {"1.30", 128055, 4530},
  {"1.31", 128155, 4533},
  {"1.32", 128255, 4536},
  {"1.33", 128355, 4539},
  {"1.34", 128448, 4542},
  {"1.35", 128548, 4545},
  {"1.36", 128648, 4548},
  {"1.37", 128748, 4551},
  {"1.38", 128848, 4554},
  {"1.39", 128941, 4557},
  {"1.40", 129041, 4560},
  {"1.41", 129134, 4563},
  {"1.42", 129234, 4566},
  {"1.43", 129327, 4569},
  {"1.44", 129428, 4572},
  {"1.45", 129529, 4575},
  {"1.46", 129631, 4578},
  {"1.47", 129732, 4581},
  {"1.48", 129827, 4584},
  {"1.49", 129929, 4587}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 137, 6, 36, "Subsection",
  CellTags->{"S5.78.1", "1.1"}],
Cell[1916, 61, 1424, 37, 136, "Text",
  CellTags->{"S5.78.1", "1.2"}],
Cell[3343, 100, 1371, 54, 56, "Text",
  CellTags->{"S5.78.1", "1.3"}],
Cell[4717, 156, 982, 47, 54, "DisplayFormula",
  CellTags->{"S5.78.1", "1.4"}],
Cell[5702, 205, 53, 1, 24, "Text",
  CellTags->{"S5.78.1", "1.5"}],
Cell[5758, 208, 1184, 56, 54, "DisplayFormula",
  CellTags->{"S5.78.1", "1.6"}],
Cell[6945, 266, 1122, 43, 56, "Text",
  CellTags->{"S5.78.1", "1.7"}],
Cell[8070, 311, 671, 28, 54, "DisplayFormula",
  CellTags->{"S5.78.1", "1.8"}],
Cell[8744, 341, 191, 4, 40, "Text",
  CellTags->{"S5.78.1", "1.9"}],
Cell[8938, 347, 1882, 75, 72, "Text",
  CellTags->{"S5.78.1", "1.10"}],
Cell[10823, 424, 1157, 29, 120, "Text",
  CellTags->{"S5.78.1", "1.11"}],
Cell[11983, 455, 102, 1, 70, "Text",
  CellTags->{"S5.78.1", "1.12"}],
Cell[12088, 458, 6086, 203, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[18177, 663, 136, 5, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[18316, 670, 4933, 148, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[23252, 820, 130, 4, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[23385, 826, 1720, 52, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[25108, 880, 126, 5, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[25237, 887, 79, 1, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.13"}],
Cell[25319, 890, 88, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[25410, 894, 302, 8, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.14"}],

Cell[CellGroupData[{
Cell[25737, 906, 102, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[25842, 910, 214, 6, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[26071, 919, 247, 5, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.15"}],

Cell[CellGroupData[{
Cell[26343, 928, 129, 5, 70, "Input",
  CellTags->"S5.78.1"],
Cell[26475, 935, 1140, 39, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[27630, 977, 248, 5, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.16"}],

Cell[CellGroupData[{
Cell[27903, 986, 94, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[28000, 990, 648, 23, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[28663, 1016, 481, 8, 70, "Text",
  CellTags->{"S5.78.1", "1.17"}],
Cell[29147, 1026, 319, 10, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.18"}],

Cell[CellGroupData[{
Cell[29491, 1040, 94, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[29588, 1044, 544, 19, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[30147, 1066, 241, 9, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.19"}],

Cell[CellGroupData[{
Cell[30413, 1079, 74, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[30490, 1083, 648, 23, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[31153, 1109, 286, 6, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.20"}],

Cell[CellGroupData[{
Cell[31464, 1119, 91, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[31558, 1123, 307, 11, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[31880, 1137, 142, 4, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.21"}],

Cell[CellGroupData[{
Cell[32047, 1145, 153, 5, 70, "Input",
  CellTags->"S5.78.1"],
Cell[32203, 1152, 648, 23, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[32866, 1178, 144, 4, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.22"}],

Cell[CellGroupData[{
Cell[33035, 1186, 87, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[33125, 1190, 842, 31, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[33982, 1224, 247, 6, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.23"}],

Cell[CellGroupData[{
Cell[34254, 1234, 84, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[34341, 1238, 1011, 36, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[35367, 1277, 419, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.24"}],

Cell[CellGroupData[{
Cell[35811, 1288, 95, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[35909, 1292, 1647, 55, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[37571, 1350, 4117, 125, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[41691, 1477, 185, 5, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[41879, 1484, 633, 18, 70, "Text",
  CellTags->{"S5.78.1", "1.25"}],
Cell[42515, 1504, 214, 5, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.26"}],

Cell[CellGroupData[{
Cell[42754, 1513, 147, 5, 70, "Input",
  CellTags->"S5.78.1"],
Cell[42904, 1520, 649, 23, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[43568, 1546, 268, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.27"}],

Cell[CellGroupData[{
Cell[43861, 1557, 129, 5, 70, "Input",
  CellTags->"S5.78.1"],
Cell[43993, 1564, 649, 23, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[44657, 1590, 406, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.28"}],

Cell[CellGroupData[{
Cell[45088, 1601, 137, 5, 70, "Input",
  CellTags->"S5.78.1"],
Cell[45228, 1608, 624, 22, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[45867, 1633, 6054, 185, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[51924, 1820, 135, 4, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[52062, 1826, 556, 11, 70, "Text",
  CellTags->{"S5.78.1", "1.29"}],
Cell[52621, 1839, 116, 2, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.30"}],

Cell[CellGroupData[{
Cell[52762, 1845, 90, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[52855, 1849, 1179, 43, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[54049, 1895, 111, 1, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.31"}],

Cell[CellGroupData[{
Cell[54185, 1900, 87, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[54275, 1904, 568, 20, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[54858, 1927, 106, 1, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.32"}],

Cell[CellGroupData[{
Cell[54989, 1932, 94, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[55086, 1936, 596, 21, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[55697, 1960, 381, 8, 70, "Text",
  CellTags->{"S5.78.1", "1.33"}],
Cell[56081, 1970, 6744, 198, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[62828, 2170, 85, 1, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[62916, 2173, 257, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.34"}],

Cell[CellGroupData[{
Cell[63198, 2184, 79, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[63280, 2188, 379, 13, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[63674, 2204, 257, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.35"}],

Cell[CellGroupData[{
Cell[63956, 2215, 109, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[64068, 2219, 127, 4, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[64210, 2226, 320, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.36"}],

Cell[CellGroupData[{
Cell[64555, 2237, 84, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[64642, 2241, 215, 6, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[64872, 2250, 228, 6, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.37"}],

Cell[CellGroupData[{
Cell[65125, 2260, 99, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[65227, 2264, 217, 6, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[65459, 2273, 315, 7, 70, "Text",
  CellTags->{"S5.78.1", "1.38"}],
Cell[65777, 2282, 379, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.39"}],

Cell[CellGroupData[{
Cell[66181, 2293, 92, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[66276, 2297, 205, 7, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[66496, 2307, 272, 5, 70, "Text",
  CellTags->{"S5.78.1", "1.40"}],
Cell[66771, 2314, 3056, 94, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[69830, 2410, 64, 1, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[69897, 2413, 2557, 75, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[72457, 2490, 106, 5, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[72566, 2497, 104, 1, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.41"}],

Cell[CellGroupData[{
Cell[72695, 2502, 167, 6, 70, "Input",
  CellTags->"S5.78.1"],
Cell[72865, 2510, 22073, 1016, 70, 22002, 1013, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.78.1"],
Cell[94941, 3528, 186, 6, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[95142, 3537, 278, 5, 70, "Text",
  CellTags->{"S5.78.1", "1.42"}],
Cell[95423, 3544, 14510, 449, 70, "DefinitionBox",
  CellTags->"S5.78.1"],
Cell[109936, 3995, 88, 1, 70, "Caption",
  CellTags->"S5.78.1"],
Cell[110027, 3998, 171, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.43"}],

Cell[CellGroupData[{
Cell[110223, 4009, 92, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[110318, 4013, 75, 2, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[110408, 4018, 173, 7, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.44"}],

Cell[CellGroupData[{
Cell[110606, 4029, 92, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[110701, 4033, 76, 2, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[110792, 4038, 361, 13, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.45"}],

Cell[CellGroupData[{
Cell[111178, 4055, 93, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[111274, 4059, 608, 21, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[111897, 4083, 234, 6, 70, "MathCaption",
  CellTags->{"S5.78.1", "1.46"}],

Cell[CellGroupData[{
Cell[112156, 4093, 82, 2, 70, "Input",
  CellTags->"S5.78.1"],
Cell[112241, 4097, 267, 9, 70, "Output",
  CellTags->"S5.78.1"]
}, Open  ]],
Cell[112523, 4109, 458, 10, 70, "Text",
  CellTags->{"S5.78.1", "1.47"}],

Cell[CellGroupData[{
Cell[113006, 4123, 67, 1, 70, "Subsubsection",
  CellTags->{"S5.78.1", "1.48"}],
Cell[113076, 4126, 2037, 52, 70, "Text",
  CellTags->{"S5.78.1", "1.49"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

