(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26974,        859]*)
(*NotebookOutlinePosition[     33246,       1048]*)
(*  CellTagsIndexPosition[     32744,       1024]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "Calendar",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.53.1", "1.1"}],

Cell[TextData[{
 "This package provides a unified treatment of the basic calendar operations. \
The main idea is to treat the calendar as a generalized number system, so \
that days, weeks, months, and years are thought of as generalizing the digits \
of a number in a given base. A detailed analysis of how this is done is given \
in the third chapter of ",
 StyleBox["Computational Recreations in Mathematica", "TI"],
 ", by Ilan Vardi (Addison\[Hyphen]Wesley, 1991). The key to the \
implementation is ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s ability to work consistently with general objects. "
}], "Text",
 CellTags->{"S5.53.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["DayOfWeek[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["month", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["day", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the day of the week on which the given date occurred",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DaysBetween[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["year",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["month",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["day",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["year",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["month",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["day",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the number of days between the given dates",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DaysPlus[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["month", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["day", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the date ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" days after the given date",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.53.1"],

Cell["Calendar computations using the standard calendar. ", "Caption",
 CellTags->"S5.53.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.53.1", "1.3"}],

Cell["<<Miscellaneous`Calendar`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.53.1"],

Cell["The basic calendar utility is finding the day of the week. ", \
"MathCaption",
 CellTags->{"S5.53.1", "1.4"}],

Cell[CellGroupData[{

Cell["DayOfWeek[{1988, 6, 23}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData["Thursday"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell["\<\
This computes the number of days between the given dates. The year 1900 was \
not a leap year. \
\>", "MathCaption",
 CellTags->{"S5.53.1", "1.5"}],

Cell[CellGroupData[{

Cell["DaysBetween[{1900, 1, 1}, {1901, 1, 1}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData["365"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell[TextData[{
 "January 2, 1901 is ",
 Cell[BoxData[
  FormBox["366", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " days after January 1, 1900. "
}], "MathCaption",
 CellTags->{"S5.53.1", "1.6"}],

Cell[CellGroupData[{

Cell["DaysPlus[{1900, 1, 1}, 366]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1901", ",", "1", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["DayOfWeek[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["month", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["day", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["}, Calendar -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cal", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the day of the week on which the given date occurred using the \
calendar system ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["cal", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DaysBetween[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["year",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["month",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["day",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["year",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["month",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["day",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["}, Calendar -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cal", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the number of days between the given dates using the calendar \
system ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["cal", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DaysPlus[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["month", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["day", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", Calendar -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cal", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the date ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[" days after the given date using the calendar system ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["cal", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CalendarChange[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["month", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["day", "TI",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["cal",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["cal",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert the date given in ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["cal",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[" into a date given in ",
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["cal",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{False, False, True},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, False, True},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, False, True},
 RowSpacings->0.4},
 CellTags->"S5.53.1"],

Cell["Calendar computations using specified systems. ", "Caption",
 CellTags->"S5.53.1"],

Cell[TextData[{
 "The Gregorian calendar has been in use in the Western world since 1582 by \
Roman Catholic countries, and since 1752 by English\[Hyphen]speaking \
countries. The Gregorian calendar counts leap years every year divisible by \
4, except for centuries not divisible by ",
 Cell[BoxData[
  FormBox["400", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", which are not leap years. "
}], "Text",
 CellTags->{"S5.53.1", "1.7"}],

Cell[TextData[{
 "The calendar used before the Gregorian calendar was the Julian calendar. \
This system counts ",
 StyleBox["every", "TI"],
 " year divisible by 4 as a leap year. At present there is a disparity of 13 \
days between the calendars. The changeover between these two calendars was \
done by omitting a number of days, therefore one must account for this in \
computations. "
}], "Text",
 CellTags->{"S5.53.1", "1.8"}],

Cell[TextData[{
 "The default calendar used in this package is the one used by England and \
her former colonies (e.g., the United\[NonBreakingSpace]States). It uses the \
Gregorian calendar for dates starting with September\[NonBreakingSpace]14, \
1752, and the Julian calendar for dates up to September\[NonBreakingSpace]2, \
1752. If you do not specify a system, this is the calendar used by ",
 StyleBox["DayOfWeek", "MR"],
 ", ",
 StyleBox["DaysBetween", "MR"],
 ", and ",
 StyleBox["DaysPlus", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.53.1", "1.9"}],

Cell[TextData[{
 "The Julian calendar is valid to March\[NonBreakingSpace]1, year 4, but not \
before then since the year 4 was ",
 StyleBox["not", "TI"],
 " a leap year. "
}], "Text",
 CellTags->{"S5.53.1", "1.10"}],

Cell["\<\
The Islamic calendar is used mainly to keep track of Islamic holy days. It is \
a purely lunar calendar and a year has either 354 or 355 days. The months do \
not correspond to the solar year and migrate over the solar year following a \
30\[Hyphen]year cycle. The Islamic calendar began on the Hejira, which was \
July\[NonBreakingSpace]16, 622, in the Julian calendar. \
\>", "Text",
 CellTags->{"S5.53.1", "1.11"}],

Cell["\<\
In the Julian calendar, the year beginning a century not divisible by 400 is \
a leap year. \
\>", "MathCaption",
 CellTags->{"S5.53.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
DaysBetween[{1900, 1, 1}, {1901, 1, 1},
                      Calendar -> Julian]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData["366"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell["\<\
The Gregorian calendar is 13 days ahead of the Julian calendar. \
\>", "MathCaption",
 CellTags->{"S5.53.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
CalendarChange[{1992, 2, 29},
        Gregorian, Julian]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1992", ",", "2", ",", "16"}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell["Here is a conversion into the Islamic system. ", "MathCaption",
 CellTags->{"S5.53.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
CalendarChange[{1992, 2, 29},
    Gregorian, Islamic]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1412", ",", "8", ",", "25"}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell["\<\
This gives the first day in the Islamic system, the date of the Hejira. The \
date is given in the Julian calendar because the Gregorian calendar was not \
used before 1582. \
\>", "MathCaption",
 CellTags->{"S5.53.1", "1.15"}],

Cell[CellGroupData[{

Cell["CalendarChange[{1,1,1}, Islamic, Julian]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"622", ",", "7", ",", "16"}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["EasterSunday[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the date of Easter Sunday in the Gregorian system",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EasterSundayGreekOrthodox[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the date of Easter Sunday according to the Greek Orthodox Church \
using the Gregorian system",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["JewishNewYear[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["year", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the date of the Jewish New Year occurring in Gregorian years \
between 1900 and 2099",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.53.1"],

Cell["Dates of holidays. ", "Caption",
 CellTags->"S5.53.1"],

Cell["In 1945, Easter Sunday was on April 1. ", "MathCaption",
 CellTags->{"S5.53.1", "1.16"}],

Cell[CellGroupData[{

Cell["EasterSunday[1945]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1945", ",", "4", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell["\<\
This uses the pre\[Hyphen]Gregorian computation, but the result is given as a \
Gregorian date. \
\>", "MathCaption",
 CellTags->{"S5.53.1", "1.17"}],

Cell[CellGroupData[{

Cell["EasterSundayGreekOrthodox[1984]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1984", ",", "4", ",", "22"}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.53.1"]
}, Open  ]],

Cell["\<\
This gives the date of the Jewish New Year in the Gregorian year 1997. \
\>", "MathCaption",
 CellTags->{"S5.53.1", "1.18"}],

Cell[CellGroupData[{

Cell["JewishNewYear[1997]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.53.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1997", ",", "10", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.53.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.53.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.53.1", "1.1"}],
    Cell[1917, 61, 657, 12, 104, "Text",
      CellTags->{"S5.53.1", "1.2"}],
    Cell[2577, 75, 5570, 170, 142, "DefinitionBox",
      CellTags->"S5.53.1"],
    Cell[8150, 247, 92, 1, 15, "Caption",
      CellTags->"S5.53.1"],
    Cell[8245, 250, 78, 1, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.3"}],
    Cell[8326, 253, 88, 2, 28, "Input",
      CellTags->"S5.53.1"],
    Cell[8417, 257, 115, 2, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.4"}],
    Cell[8557, 263, 87, 2, 28, "Input",
      CellTags->"S5.53.1"],
    Cell[8647, 267, 81, 2, 25, "Output",
      CellTags->"S5.53.1"],
    Cell[8743, 272, 157, 4, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.5"}],
    Cell[8925, 280, 102, 2, 28, "Input",
      CellTags->"S5.53.1"],
    Cell[9030, 284, 76, 2, 25, "Output",
      CellTags->"S5.53.1"],
    Cell[9121, 289, 236, 7, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.6"}],
    Cell[9382, 300, 90, 2, 28, "Input",
      CellTags->"S5.53.1"],
    Cell[9475, 304, 132, 4, 25, "Output",
      CellTags->"S5.53.1"],
    Cell[9622, 311, 9729, 278, 70, "DefinitionBox",
      CellTags->"S5.53.1"],
    Cell[19354, 591, 88, 1, 70, "Caption",
      CellTags->"S5.53.1"],
    Cell[19445, 594, 475, 10, 70, "Text",
      CellTags->{"S5.53.1", "1.7"}],
    Cell[19923, 606, 431, 9, 70, "Text",
      CellTags->{"S5.53.1", "1.8"}],
    Cell[20357, 617, 555, 13, 70, "Text",
      CellTags->{"S5.53.1", "1.9"}],
    Cell[20915, 632, 216, 6, 70, "Text",
      CellTags->{"S5.53.1", "1.10"}],
    Cell[21134, 640, 427, 7, 70, "Text",
      CellTags->{"S5.53.1", "1.11"}],
    Cell[21564, 649, 155, 4, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.12"}],
    Cell[21744, 657, 152, 5, 70, "Input",
      CellTags->"S5.53.1"],
    Cell[21899, 664, 76, 2, 70, "Output",
      CellTags->"S5.53.1"],
    Cell[21990, 669, 127, 3, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.13"}],
    Cell[22142, 676, 127, 5, 70, "Input",
      CellTags->"S5.53.1"],
    Cell[22272, 683, 133, 4, 70, "Output",
      CellTags->"S5.53.1"],
    Cell[22420, 690, 101, 1, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.14"}],
    Cell[22546, 695, 124, 5, 70, "Input",
      CellTags->"S5.53.1"],
    Cell[22673, 702, 133, 4, 70, "Output",
      CellTags->"S5.53.1"],
    Cell[22821, 709, 237, 5, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.15"}],
    Cell[23083, 718, 103, 2, 70, "Input",
      CellTags->"S5.53.1"],
    Cell[23189, 722, 132, 4, 70, "Output",
      CellTags->"S5.53.1"],
    Cell[23336, 729, 2384, 71, 70, "DefinitionBox",
      CellTags->"S5.53.1"],
    Cell[25723, 802, 60, 1, 70, "Caption",
      CellTags->"S5.53.1"],
    Cell[25786, 805, 94, 1, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.16"}],
    Cell[25905, 810, 81, 2, 70, "Input",
      CellTags->"S5.53.1"],
    Cell[25989, 814, 132, 4, 70, "Output",
      CellTags->"S5.53.1"],
    Cell[26136, 821, 159, 4, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.17"}],
    Cell[26320, 829, 95, 2, 70, "Input",
      CellTags->"S5.53.1"],
    Cell[26418, 833, 134, 4, 70, "Output",
      CellTags->"S5.53.1"],
    Cell[26567, 840, 134, 3, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.18"}],
    Cell[26726, 847, 83, 2, 70, "Input",
      CellTags->"S5.53.1"],
    Cell[26812, 851, 134, 4, 70, "Output",
      CellTags->"S5.53.1"]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.53.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 657, 12, 104, "Text",
      CellTags->{"S5.53.1", "1.2"}]},
  "1.3"->{
    Cell[8245, 250, 78, 1, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.3"}]},
  "1.4"->{
    Cell[8417, 257, 115, 2, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.4"}]},
  "1.5"->{
    Cell[8743, 272, 157, 4, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.5"}]},
  "1.6"->{
    Cell[9121, 289, 236, 7, 40, "MathCaption",
      CellTags->{"S5.53.1", "1.6"}]},
  "1.7"->{
    Cell[19445, 594, 475, 10, 70, "Text",
      CellTags->{"S5.53.1", "1.7"}]},
  "1.8"->{
    Cell[19923, 606, 431, 9, 70, "Text",
      CellTags->{"S5.53.1", "1.8"}]},
  "1.9"->{
    Cell[20357, 617, 555, 13, 70, "Text",
      CellTags->{"S5.53.1", "1.9"}]},
  "1.10"->{
    Cell[20915, 632, 216, 6, 70, "Text",
      CellTags->{"S5.53.1", "1.10"}]},
  "1.11"->{
    Cell[21134, 640, 427, 7, 70, "Text",
      CellTags->{"S5.53.1", "1.11"}]},
  "1.12"->{
    Cell[21564, 649, 155, 4, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.12"}]},
  "1.13"->{
    Cell[21990, 669, 127, 3, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.13"}]},
  "1.14"->{
    Cell[22420, 690, 101, 1, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.14"}]},
  "1.15"->{
    Cell[22821, 709, 237, 5, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.15"}]},
  "1.16"->{
    Cell[25786, 805, 94, 1, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.16"}]},
  "1.17"->{
    Cell[26136, 821, 159, 4, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.17"}]},
  "1.18"->{
    Cell[26567, 840, 134, 3, 70, "MathCaption",
      CellTags->{"S5.53.1", "1.18"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.53.1", 27597, 875},
  {"1.1", 31015, 966},
  {"1.2", 31109, 969},
  {"1.3", 31199, 972},
  {"1.4", 31294, 975},
  {"1.5", 31390, 978},
  {"1.6", 31486, 981},
  {"1.7", 31582, 984},
  {"1.8", 31673, 987},
  {"1.9", 31763, 990},
  {"1.10", 31855, 993},
  {"1.11", 31947, 996},
  {"1.12", 32039, 999},
  {"1.13", 32138, 1002},
  {"1.14", 32237, 1005},
  {"1.15", 32336, 1008},
  {"1.16", 32435, 1011},
  {"1.17", 32533, 1014},
  {"1.18", 32632, 1017}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S5.53.1", "1.1"}],
Cell[1917, 61, 657, 12, 104, "Text",
  CellTags->{"S5.53.1", "1.2"}],
Cell[2577, 75, 5570, 170, 142, "DefinitionBox",
  CellTags->"S5.53.1"],
Cell[8150, 247, 92, 1, 15, "Caption",
  CellTags->"S5.53.1"],
Cell[8245, 250, 78, 1, 40, "MathCaption",
  CellTags->{"S5.53.1", "1.3"}],
Cell[8326, 253, 88, 2, 28, "Input",
  CellTags->"S5.53.1"],
Cell[8417, 257, 115, 2, 40, "MathCaption",
  CellTags->{"S5.53.1", "1.4"}],

Cell[CellGroupData[{
Cell[8557, 263, 87, 2, 28, "Input",
  CellTags->"S5.53.1"],
Cell[8647, 267, 81, 2, 25, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[8743, 272, 157, 4, 40, "MathCaption",
  CellTags->{"S5.53.1", "1.5"}],

Cell[CellGroupData[{
Cell[8925, 280, 102, 2, 28, "Input",
  CellTags->"S5.53.1"],
Cell[9030, 284, 76, 2, 25, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[9121, 289, 236, 7, 40, "MathCaption",
  CellTags->{"S5.53.1", "1.6"}],

Cell[CellGroupData[{
Cell[9382, 300, 90, 2, 28, "Input",
  CellTags->"S5.53.1"],
Cell[9475, 304, 132, 4, 25, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[9622, 311, 9729, 278, 70, "DefinitionBox",
  CellTags->"S5.53.1"],
Cell[19354, 591, 88, 1, 70, "Caption",
  CellTags->"S5.53.1"],
Cell[19445, 594, 475, 10, 70, "Text",
  CellTags->{"S5.53.1", "1.7"}],
Cell[19923, 606, 431, 9, 70, "Text",
  CellTags->{"S5.53.1", "1.8"}],
Cell[20357, 617, 555, 13, 70, "Text",
  CellTags->{"S5.53.1", "1.9"}],
Cell[20915, 632, 216, 6, 70, "Text",
  CellTags->{"S5.53.1", "1.10"}],
Cell[21134, 640, 427, 7, 70, "Text",
  CellTags->{"S5.53.1", "1.11"}],
Cell[21564, 649, 155, 4, 70, "MathCaption",
  CellTags->{"S5.53.1", "1.12"}],

Cell[CellGroupData[{
Cell[21744, 657, 152, 5, 70, "Input",
  CellTags->"S5.53.1"],
Cell[21899, 664, 76, 2, 70, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[21990, 669, 127, 3, 70, "MathCaption",
  CellTags->{"S5.53.1", "1.13"}],

Cell[CellGroupData[{
Cell[22142, 676, 127, 5, 70, "Input",
  CellTags->"S5.53.1"],
Cell[22272, 683, 133, 4, 70, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[22420, 690, 101, 1, 70, "MathCaption",
  CellTags->{"S5.53.1", "1.14"}],

Cell[CellGroupData[{
Cell[22546, 695, 124, 5, 70, "Input",
  CellTags->"S5.53.1"],
Cell[22673, 702, 133, 4, 70, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[22821, 709, 237, 5, 70, "MathCaption",
  CellTags->{"S5.53.1", "1.15"}],

Cell[CellGroupData[{
Cell[23083, 718, 103, 2, 70, "Input",
  CellTags->"S5.53.1"],
Cell[23189, 722, 132, 4, 70, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[23336, 729, 2384, 71, 70, "DefinitionBox",
  CellTags->"S5.53.1"],
Cell[25723, 802, 60, 1, 70, "Caption",
  CellTags->"S5.53.1"],
Cell[25786, 805, 94, 1, 70, "MathCaption",
  CellTags->{"S5.53.1", "1.16"}],

Cell[CellGroupData[{
Cell[25905, 810, 81, 2, 70, "Input",
  CellTags->"S5.53.1"],
Cell[25989, 814, 132, 4, 70, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[26136, 821, 159, 4, 70, "MathCaption",
  CellTags->{"S5.53.1", "1.17"}],

Cell[CellGroupData[{
Cell[26320, 829, 95, 2, 70, "Input",
  CellTags->"S5.53.1"],
Cell[26418, 833, 134, 4, 70, "Output",
  CellTags->"S5.53.1"]
}, Open  ]],
Cell[26567, 840, 134, 3, 70, "MathCaption",
  CellTags->{"S5.53.1", "1.18"}],

Cell[CellGroupData[{
Cell[26726, 847, 83, 2, 70, "Input",
  CellTags->"S5.53.1"],
Cell[26812, 851, 134, 4, 70, "Output",
  CellTags->"S5.53.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

