(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14575,        505]*)
(*NotebookOutlinePosition[     17940,        610]*)
(*  CellTagsIndexPosition[     17636,        594]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "CauchyPrincipalValue",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.79.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["NIntegrate", "MR"],
 " computes a numerical approximation to a definite integral. However, if you \
want to evaluate the Cauchy principal value of an integral, ",
 StyleBox["NIntegrate", "MR"],
 " cannot be used directly. To find the Cauchy principal value, you should \
use instead ",
 StyleBox["CauchyPrincipalValue", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.79.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CauchyPrincipalValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["c", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "numerically find the Cauchy principal value of the integral ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubsuperscriptBox["\[Integral]", 
          StyleBox["a",
           "TI"], 
          StyleBox["c",
           "TI"]], 
         StyleBox["f",
          "TI"], "\[DifferentialD]", 
         StyleBox["x",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" which has a nonintegrable singularity at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["x",
          "TI"], "=", 
         StyleBox["b",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CauchyPrincipalValue[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eps", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["c", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find the Cauchy principal value by integrating from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["a",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["b",
          "TI"], "-", "\[Epsilon]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["b",
          "TI"], "+", "\[Epsilon]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["c",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and exploiting symmetry on the interval from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["b",
          "TI"], "-", "\[Epsilon]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["b",
          "TI"], "+", "\[Epsilon]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.79.1"],

Cell["Finding the Cauchy principal value of an integral. ", "Caption",
 CellTags->"S5.79.1"],

Cell[TextData[{
 StyleBox["CauchyPrincipalValue", "MR"],
 " works by using ",
 StyleBox["NIntegrate", "MR"],
 " directly on those regions where there is no difficulty and by pairing \
values symmetrically about the specified singularities in order to take \
advantage of the cancellation of the positive and negative values. Thus ",
 StyleBox["CauchyPrincipalValue[f[x],{x,", "MR"],
 " ",
 StyleBox["a,", "MR"],
 " ",
 StyleBox["{b,", "MR"],
 " ",
 StyleBox["eps},", "MR"],
 " ",
 StyleBox["c}]", "MR"],
 " is evaluated as "
}], "Text",
 CellTags->{"S5.79.1", "1.3"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    StyleBox["a",
     "TI"], 
    RowBox[{
     StyleBox["b",
      "TI"], "-", "\[Epsilon]"}]], 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    StyleBox["x",
     "TI"], ")"}], "\[DifferentialD]", 
   StyleBox["x",
    "TI"], "+", 
   SubsuperscriptBox["\[Integral]", "0", "\[Epsilon]"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["b",
        "TI"], "+", 
       StyleBox["t",
        "TI"]}], ")"}], "+", 
     StyleBox["f",
      "TI"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["b",
        "TI"], "-", 
       StyleBox["t",
        "TI"]}], ")"}]}], ")"}], "\[DifferentialD]", 
   StyleBox["t",
    "TI"], "+", 
   SubsuperscriptBox["\[Integral]", 
    RowBox[{
     StyleBox["b",
      "TI"], "+", "\[Epsilon]"}], 
    StyleBox["c",
     "TI"]], 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    StyleBox["x",
     "TI"], ")"}], "\[DifferentialD]", 
   StyleBox["x",
    "TI"]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.79.1", "1.4"}],

Cell[TextData[{
 "where each of the integrals is evaluated using ",
 StyleBox["NIntegrate", "MR"],
 ". If ",
 Cell[BoxData[
  FormBox["\[Epsilon]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not given explicitly, a value is chosen based upon the differences ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     "TI"], "-", 
    StyleBox["a",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     "TI"], "-", 
    StyleBox["b",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The options to ",
 StyleBox["CauchyPrincipalValue", "MR"],
 " are simply passed directly to ",
 StyleBox["NIntegrate", "MR"],
 "; ",
 StyleBox["CauchyPrincipalValue", "MR"],
 " itself does not make any use of them. "
}], "Text",
 CellTags->{"S5.79.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.79.1", "1.6"}],

Cell["<<NumericalMath`CauchyPrincipalValue`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.79.1"],

Cell[TextData[{
 "This finds the Cauchy principal value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], "1"], 
    FractionBox["1", 
     RowBox[{
      StyleBox["x",
       "TI"], "+", 
      SuperscriptBox[
       StyleBox["x",
        "TI"], "2"]}]], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.79.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
CauchyPrincipalValue[1/(x+x^2), {x, -1/2,
 {0}, 1}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.79.1"],

Cell[BoxData[
 RowBox[{"-", "0.6931471805596515`"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.79.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the Cauchy principal value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "2"}], "1"], 
    FractionBox["1", 
     RowBox[{
      StyleBox["x",
       "TI"], "+", 
      SuperscriptBox[
       StyleBox["x",
        "TI"], "2"]}]], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Note that there are two singularities that need to be specified. "
}], "MathCaption",
 CellTags->{"S5.79.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
CauchyPrincipalValue[1/(x+x^2), {x, -2, {-1},
 {0}, 1}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.79.1"],

Cell[BoxData[
 RowBox[{"-", "1.386294361119086`"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.79.1"]
}, Open  ]],

Cell["\<\
This checks the value. The result would be 0 if everything were done exactly. \
\
\>", "MathCaption",
 CellTags->{"S5.79.1", "1.9"}],

Cell[CellGroupData[{

Cell["% + 2 Log[2.]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.79.1"],

Cell[BoxData["8.044676036433884`*^-13"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.79.1"]
}, Open  ]],

Cell[TextData[{
 "It should be noted that the singularities must be located exactly. Because \
the points on both sides of the singularity are paired together in the \
algorithm, if the singularity is slightly mislocated the cancellation will \
not be sufficiently good near the pole and the result can be significantly in \
error if ",
 StyleBox["NIntegrate", "MR"],
 " converges at all. "
}], "Text",
 CellTags->{"S5.79.1", "1.10"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.79.1"->{
    Cell[1776, 53, 150, 6, 36, "Subsection",
      CellTags->{"S5.79.1", "1.1"}],
    Cell[1929, 61, 458, 13, 72, "Text",
      CellTags->{"S5.79.1", "1.2"}],
    Cell[2390, 76, 6709, 206, 122, "DefinitionBox",
      CellTags->"S5.79.1"],
    Cell[9102, 284, 92, 1, 15, "Caption",
      CellTags->"S5.79.1"],
    Cell[9197, 287, 567, 18, 72, "Text",
      CellTags->{"S5.79.1", "1.3"}],
    Cell[9767, 307, 1210, 52, 47, "DisplayFormula",
      CellTags->{"S5.79.1", "1.4"}],
    Cell[10980, 361, 955, 33, 72, "Text",
      CellTags->{"S5.79.1", "1.5"}],
    Cell[11938, 396, 78, 1, 40, "MathCaption",
      CellTags->{"S5.79.1", "1.6"}],
    Cell[12019, 399, 100, 2, 28, "Input",
      CellTags->"S5.79.1"],
    Cell[12122, 403, 530, 20, 44, "MathCaption",
      CellTags->{"S5.79.1", "1.7"}],
    Cell[12677, 427, 122, 5, 45, "Input",
      CellTags->"S5.79.1"],
    Cell[12802, 434, 109, 3, 25, "Output",
      CellTags->"S5.79.1"],
    Cell[12926, 440, 565, 19, 60, "MathCaption",
      CellTags->{"S5.79.1", "1.8"}],
    Cell[13516, 463, 126, 5, 70, "Input",
      CellTags->"S5.79.1"],
    Cell[13645, 470, 108, 3, 70, "Output",
      CellTags->"S5.79.1"],
    Cell[13768, 476, 142, 4, 70, "MathCaption",
      CellTags->{"S5.79.1", "1.9"}],
    Cell[13935, 484, 76, 2, 70, "Input",
      CellTags->"S5.79.1"],
    Cell[14014, 488, 96, 2, 70, "Output",
      CellTags->"S5.79.1"],
    Cell[14125, 493, 434, 9, 70, "Text",
      CellTags->{"S5.79.1", "1.10"}]},
  "1.1"->{
    Cell[1776, 53, 150, 6, 36, "Subsection",
      CellTags->{"S5.79.1", "1.1"}]},
  "1.2"->{
    Cell[1929, 61, 458, 13, 72, "Text",
      CellTags->{"S5.79.1", "1.2"}]},
  "1.3"->{
    Cell[9197, 287, 567, 18, 72, "Text",
      CellTags->{"S5.79.1", "1.3"}]},
  "1.4"->{
    Cell[9767, 307, 1210, 52, 47, "DisplayFormula",
      CellTags->{"S5.79.1", "1.4"}]},
  "1.5"->{
    Cell[10980, 361, 955, 33, 72, "Text",
      CellTags->{"S5.79.1", "1.5"}]},
  "1.6"->{
    Cell[11938, 396, 78, 1, 40, "MathCaption",
      CellTags->{"S5.79.1", "1.6"}]},
  "1.7"->{
    Cell[12122, 403, 530, 20, 44, "MathCaption",
      CellTags->{"S5.79.1", "1.7"}]},
  "1.8"->{
    Cell[12926, 440, 565, 19, 60, "MathCaption",
      CellTags->{"S5.79.1", "1.8"}]},
  "1.9"->{
    Cell[13768, 476, 142, 4, 70, "MathCaption",
      CellTags->{"S5.79.1", "1.9"}]},
  "1.10"->{
    Cell[14125, 493, 434, 9, 70, "Text",
      CellTags->{"S5.79.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.79.1", 15198, 521},
  {"1.1", 16676, 560},
  {"1.2", 16770, 563},
  {"1.3", 16859, 566},
  {"1.4", 16949, 569},
  {"1.5", 17050, 572},
  {"1.6", 17141, 575},
  {"1.7", 17237, 578},
  {"1.8", 17335, 581},
  {"1.9", 17433, 584},
  {"1.10", 17531, 587}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 150, 6, 36, "Subsection",
  CellTags->{"S5.79.1", "1.1"}],
Cell[1929, 61, 458, 13, 72, "Text",
  CellTags->{"S5.79.1", "1.2"}],
Cell[2390, 76, 6709, 206, 122, "DefinitionBox",
  CellTags->"S5.79.1"],
Cell[9102, 284, 92, 1, 15, "Caption",
  CellTags->"S5.79.1"],
Cell[9197, 287, 567, 18, 72, "Text",
  CellTags->{"S5.79.1", "1.3"}],
Cell[9767, 307, 1210, 52, 47, "DisplayFormula",
  CellTags->{"S5.79.1", "1.4"}],
Cell[10980, 361, 955, 33, 72, "Text",
  CellTags->{"S5.79.1", "1.5"}],
Cell[11938, 396, 78, 1, 40, "MathCaption",
  CellTags->{"S5.79.1", "1.6"}],
Cell[12019, 399, 100, 2, 28, "Input",
  CellTags->"S5.79.1"],
Cell[12122, 403, 530, 20, 44, "MathCaption",
  CellTags->{"S5.79.1", "1.7"}],

Cell[CellGroupData[{
Cell[12677, 427, 122, 5, 45, "Input",
  CellTags->"S5.79.1"],
Cell[12802, 434, 109, 3, 25, "Output",
  CellTags->"S5.79.1"]
}, Open  ]],
Cell[12926, 440, 565, 19, 60, "MathCaption",
  CellTags->{"S5.79.1", "1.8"}],

Cell[CellGroupData[{
Cell[13516, 463, 126, 5, 70, "Input",
  CellTags->"S5.79.1"],
Cell[13645, 470, 108, 3, 70, "Output",
  CellTags->"S5.79.1"]
}, Open  ]],
Cell[13768, 476, 142, 4, 70, "MathCaption",
  CellTags->{"S5.79.1", "1.9"}],

Cell[CellGroupData[{
Cell[13935, 484, 76, 2, 70, "Input",
  CellTags->"S5.79.1"],
Cell[14014, 488, 96, 2, 70, "Output",
  CellTags->"S5.79.1"]
}, Open  ]],
Cell[14125, 493, 434, 9, 70, "Text",
  CellTags->{"S5.79.1", "1.10"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

