(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     38541,       1605]*)
(*NotebookOutlinePosition[     45865,       1820]*)
(*  CellTagsIndexPosition[     45375,       1797]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "ChemicalElements",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.54.1", "1.1"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Abbreviation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the standard abbreviation ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AtomicNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the atomic number of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AtomicWeight[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["give the atomic weight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["StableIsotopes[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the stable isotopes of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Elements", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "list of the names of the chemical elements ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.54.1"],

Cell["Basic properties of the chemical elements. ", "Caption",
 CellTags->"S5.54.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.54.1", "1.2"}],

Cell["<<Miscellaneous`ChemicalElements`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.54.1"],

Cell["\<\
This gives the atomic weight of tungsten using the data in the package. \
\>", "MathCaption",
 CellTags->{"S5.54.1", "1.3"}],

Cell[CellGroupData[{

Cell["AtomicWeight[Tungsten]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData["183.84`"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell[TextData[{
 "If you ask for the atomic weight of an unstable element, ",
 StyleBox["Mathematica", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " issues a warning message. "
}], "MathCaption",
 CellTags->{"S5.54.1", "1.4"}],

Cell[CellGroupData[{

Cell["AtomicWeight[Plutonium]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AtomicWeight", "::", "\<\"unstable\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"No stable isotope of \\!\\(Plutonium\\) exists.\"\>"}]], \
"Message",
 CellTags->"S5.54.1"],

Cell[BoxData["244"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell["This switches off the warning message. ", "MathCaption",
 CellTags->{"S5.54.1", "1.5"}],

Cell["Off[AtomicWeight::unstable]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.54.1"],

Cell["\<\
Here is a plot of the ratio of atomic weight to atomic number. \
\>", "MathCaption",
 CellTags->{"S5.54.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
ListPlot[Map[
AtomicWeight[#]/AtomicNumber[#]&,
Drop[Elements, -1]],
    PlotJoined -> True]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.54.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00858001 -0.962725 0.603312 [
[.19541 .2314 -6 -9 ]
[.19541 .2314 6 0 ]
[.36701 .2314 -6 -9 ]
[.36701 .2314 6 0 ]
[.53861 .2314 -6 -9 ]
[.53861 .2314 6 0 ]
[.71021 .2314 -6 -9 ]
[.71021 .2314 6 0 ]
[.88181 .2314 -9 -9 ]
[.88181 .2314 9 0 ]
[.01131 .00257 -18 -4.5 ]
[.01131 .00257 0 4.5 ]
[.01131 .12324 -18 -4.5 ]
[.01131 .12324 0 4.5 ]
[.01131 .36456 -18 -4.5 ]
[.01131 .36456 0 4.5 ]
[.01131 .48522 -18 -4.5 ]
[.01131 .48522 0 4.5 ]
[.01131 .60589 -18 -4.5 ]
[.01131 .60589 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.19541 .2439 m
.19541 .25015 L
s
[(20)] .19541 .2314 0 1 Mshowa
.36701 .2439 m
.36701 .25015 L
s
[(40)] .36701 .2314 0 1 Mshowa
.53861 .2439 m
.53861 .25015 L
s
[(60)] .53861 .2314 0 1 Mshowa
.71021 .2439 m
.71021 .25015 L
s
[(80)] .71021 .2314 0 1 Mshowa
.88181 .2439 m
.88181 .25015 L
s
[(100)] .88181 .2314 0 1 Mshowa
.125 Mabswid
.06671 .2439 m
.06671 .24765 L
s
.10961 .2439 m
.10961 .24765 L
s
.15251 .2439 m
.15251 .24765 L
s
.23831 .2439 m
.23831 .24765 L
s
.28121 .2439 m
.28121 .24765 L
s
.32411 .2439 m
.32411 .24765 L
s
.40991 .2439 m
.40991 .24765 L
s
.45281 .2439 m
.45281 .24765 L
s
.49571 .2439 m
.49571 .24765 L
s
.58151 .2439 m
.58151 .24765 L
s
.62441 .2439 m
.62441 .24765 L
s
.66731 .2439 m
.66731 .24765 L
s
.75311 .2439 m
.75311 .24765 L
s
.79601 .2439 m
.79601 .24765 L
s
.83891 .2439 m
.83891 .24765 L
s
.92471 .2439 m
.92471 .24765 L
s
.96761 .2439 m
.96761 .24765 L
s
.25 Mabswid
0 .2439 m
1 .2439 L
s
.02381 .00257 m
.03006 .00257 L
s
[(1.6)] .01131 .00257 1 0 Mshowa
.02381 .12324 m
.03006 .12324 L
s
[(1.8)] .01131 .12324 1 0 Mshowa
.02381 .36456 m
.03006 .36456 L
s
[(2.2)] .01131 .36456 1 0 Mshowa
.02381 .48522 m
.03006 .48522 L
s
[(2.4)] .01131 .48522 1 0 Mshowa
.02381 .60589 m
.03006 .60589 L
s
[(2.6)] .01131 .60589 1 0 Mshowa
.125 Mabswid
.02381 .03274 m
.02756 .03274 L
s
.02381 .06291 m
.02756 .06291 L
s
.02381 .09307 m
.02756 .09307 L
s
.02381 .1534 m
.02756 .1534 L
s
.02381 .18357 m
.02756 .18357 L
s
.02381 .21373 m
.02756 .21373 L
s
.02381 .27406 m
.02756 .27406 L
s
.02381 .30423 m
.02756 .30423 L
s
.02381 .3344 m
.02756 .3344 L
s
.02381 .39473 m
.02756 .39473 L
s
.02381 .42489 m
.02756 .42489 L
s
.02381 .45506 m
.02756 .45506 L
s
.02381 .51539 m
.02756 .51539 L
s
.02381 .54555 m
.02756 .54555 L
s
.02381 .57572 m
.02756 .57572 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03747 0 m
.04097 .24468 L
.04955 .43314 L
.05813 .39656 L
.06671 .34164 L
.07529 .24497 L
.08387 .24448 L
.09245 .24385 L
.10103 .31083 L
.10961 .25474 L
.11819 .29818 L
.12677 .25923 L
.13535 .28945 L
.14393 .24758 L
.15251 .28306 L
.16109 .24639 L
.16967 .29545 L
.17825 .37623 L
.18683 .27877 L
.19541 .24625 L
.20399 .32882 L
.21257 .34994 L
.22115 .37352 L
.22973 .34435 L
.23831 .36307 L
.24689 .33312 L
.25547 .35413 L
.26405 .30193 L
.27263 .35928 L
.28121 .35229 L
.28979 .3942 L
.29837 .40623 L
.30695 .40701 L
.31553 .43838 L
.32411 .41462 L
.33269 .44165 L
.34127 .43089 L
.34985 .42839 L
.35843 .41261 L
.36701 .41319 L
.37559 .40439 L
.38417 .41541 L
.39275 .41227 L
.40133 .42311 L
.40991 .41692 L
.41849 .43302 L
.42707 .42192 L
.43565 .45017 L
.44423 .45097 L
.45281 .46966 L
Mistroke
.46139 .47765 L
.46997 .51771 L
.47855 .48186 L
.48713 .50411 L
.49571 .49516 L
.50429 .51676 L
.51287 .50751 L
.52145 .49475 L
.53003 .47814 L
.53861 .48764 L
.54719 .47138 L
.55577 .5004 L
.56435 .49254 L
.57293 .51963 L
.58151 .51238 L
.59009 .5227 L
.59867 .52242 L
.60725 .52125 L
.61583 .51438 L
.62441 .52866 L
.63299 .52403 L
.64157 .5329 L
.65015 .53273 L
.65873 .5361 L
.66731 .53515 L
.67589 .54738 L
.68447 .54334 L
.69305 .54616 L
.70163 .54148 L
.71021 .55 L
.71879 .55958 L
.72737 .56174 L
.73595 .55632 L
.74453 .53837 L
.75311 .52781 L
.76169 .59466 L
.77027 .5837 L
.77885 .58669 L
.78743 .57606 L
.79601 .59273 L
.80459 .569 L
.81317 .59821 L
.82175 .57475 L
.83033 .60332 L
.83891 .58048 L
.84749 .58955 L
.85607 .57354 L
.86465 .58249 L
.87323 .57298 L
.88181 .58779 L
Mistroke
.89039 .57841 L
.89897 .56921 L
.90755 .57191 L
.91613 .55136 L
.92471 .54268 L
.93329 .53417 L
.94187 .51454 L
.95045 .51762 L
.95903 .50958 L
.96761 .51265 L
.97619 .51566 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.54.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MeltingPoint[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the melting point in degrees Kelvin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoilingPoint[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the boiling point in degrees Kelvin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HeatOfFusion[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the heat of fusion in kilojoules per mole",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["HeatOfVaporization[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the heat of vaporization in kilojoules per mole",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Density[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the density in kilograms per cubic meter",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ThermalConductivity[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the thermal conductivity in watts per meter per Kelvin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.54.1"],

Cell["Physical properties of chemical elements. ", "Caption",
 CellTags->"S5.54.1"],

Cell[TextData[{
 "The densities given are usually for the elements at ",
 Cell[BoxData[
  FormBox["298", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " Kelvin and one atmosphere pressure. A message is generated if the density \
given is for another temperature or for a special form of the element. The \
thermal conductivities are for the specified elements at ",
 Cell[BoxData[
  FormBox["300", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " Kelvin unless a message is returned giving an exception. "
}], "Text",
 CellTags->{"S5.54.1", "1.7"}],

Cell["This gives the heat of fusion of nitrogen. ", "MathCaption",
 CellTags->{"S5.54.1", "1.8"}],

Cell[CellGroupData[{

Cell["HeatOfFusion[Nitrogen]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.72`", " ", "Joule", " ", "Kilo"}], "Mole"]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell[TextData[{
 "When you ask for the density, ",
 StyleBox["Mathematica", "TI"],
 " warns you that this density is taken at a temperature of 21 Kelvin. The \
standard used for most other elements is 298 Kelvin. "
}], "MathCaption",
 CellTags->{"S5.54.1", "1.9"}],

Cell[CellGroupData[{

Cell["Density[Nitrogen]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Density", "::", "\<\"temp\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Density is for \\!\\(Nitrogen\\) at \\!\\(21\\) \
Kelvin.\"\>"}]], "Message",
 CellTags->"S5.54.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1026.`", " ", "Kilogram"}], 
  SuperscriptBox["Meter", "3"]]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell["This thermal conductivity is for the gaseous state. ", "MathCaption",
 CellTags->{"S5.54.1", "1.10"}],

Cell[CellGroupData[{

Cell["ThermalConductivity[Nitrogen]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ThermalConductivity", "::", "\<\"form\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Thermal conductivity is for the \\!\\(\\\"gaseous\\\"\\) \
form of \\!\\(Nitrogen\\).\"\>"}]], "Message",
 CellTags->"S5.54.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.02598`", " ", "Watt"}], 
  RowBox[{"Kelvin", " ", "Meter"}]]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ElectronConfiguration[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the electron configuration",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ElectronConfigurationFormat[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the electron configuration including orbital labels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.54.1"],

Cell["Electronic structure of chemical elements. ", "Caption",
 CellTags->"S5.54.1"],

Cell[TextData[{
 "When you use ",
 StyleBox["ElectronConfiguration", "MR"],
 " to get the electronic configuration of an element, the result is a list \
using the standard order of listing of subshells ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", 
    StyleBox["s",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["s",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", 
    StyleBox["s",
     "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " . Each shell is grouped into a sublist. ",
 StyleBox["ElectronConfigurationFormat", "MR"],
 " returns the number of electrons in each subshell along with the label for \
the subshell. "
}], "Text",
 CellTags->{"S5.54.1", "1.11"}],

Cell["\<\
This gives the electronic configuration as a list in the standard format. \
\>", "MathCaption",
 CellTags->{"S5.54.1", "1.12"}],

Cell[CellGroupData[{

Cell["ElectronConfiguration[Actinium]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "10", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell["This includes the orbital labels in the list. ", "MathCaption",
 CellTags->{"S5.54.1", "1.13"}],

Cell[CellGroupData[{

Cell["ElectronConfigurationFormat[Actinium]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"1\"\>", "\[InvisibleSpace]", "\<\"s\"\>", "\[InvisibleSpace]", 
   
   InterpretationBox[
    SuperscriptBox["\[Null]", "2"],
    Superscript[2],
    Editable->False], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"2\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "2"],
    Superscript[2],
    Editable->False], "\[InvisibleSpace]", "\<\"2\"\>", 
   "\[InvisibleSpace]", "\<\"p\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "6"],
    Superscript[6],
    Editable->False], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"3\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "2"],
    Superscript[2],
    Editable->False], "\[InvisibleSpace]", "\<\"3\"\>", 
   "\[InvisibleSpace]", "\<\"p\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "6"],
    Superscript[6],
    Editable->False], "\[InvisibleSpace]", "\<\"3\"\>", 
   "\[InvisibleSpace]", "\<\"d\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "10"],
    Superscript[10],
    Editable->False], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"4\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "2"],
    Superscript[2],
    Editable->False], "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\"p\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "6"],
    Superscript[6],
    Editable->False], "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\"d\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "10"],
    Superscript[10],
    Editable->False], "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\"f\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "14"],
    Superscript[14],
    Editable->False], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"5\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "2"],
    Superscript[2],
    Editable->False], "\[InvisibleSpace]", "\<\"5\"\>", 
   "\[InvisibleSpace]", "\<\"p\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "6"],
    Superscript[6],
    Editable->False], "\[InvisibleSpace]", "\<\"5\"\>", 
   "\[InvisibleSpace]", "\<\"d\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "10"],
    Superscript[10],
    Editable->False], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"6\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "2"],
    Superscript[2],
    Editable->False], "\[InvisibleSpace]", "\<\"6\"\>", 
   "\[InvisibleSpace]", "\<\"p\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "6"],
    Superscript[6],
    Editable->False], "\[InvisibleSpace]", "\<\"6\"\>", 
   "\[InvisibleSpace]", "\<\"d\"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "1"],
    Superscript[1],
    Editable->False], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "\<\"7\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    SuperscriptBox["\[Null]", "2"],
    Superscript[2],
    Editable->False]}],
  SequenceForm["1", "s", 
   Superscript[2], " ", "2", "s", 
   Superscript[2], "2", "p", 
   Superscript[6], " ", "3", "s", 
   Superscript[2], "3", "p", 
   Superscript[6], "3", "d", 
   Superscript[10], " ", "4", "s", 
   Superscript[2], "4", "p", 
   Superscript[6], "4", "d", 
   Superscript[10], "4", "f", 
   Superscript[14], " ", "5", "s", 
   Superscript[2], "5", "p", 
   Superscript[6], "5", "d", 
   Superscript[10], " ", "6", "s", 
   Superscript[2], "6", "p", 
   Superscript[6], "6", "d", 
   Superscript[1], " ", "7", "s", 
   Superscript[2]],
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["IonizationPotential[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the ionization potential of the specified element",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SpecificHeat[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the specific heat of the specified element",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.54.1"],

Cell["\<\
Ionization potential and specific heat of chemical elements. \
\>", "Caption",
 CellTags->"S5.54.1"],

Cell["This gives the specific heat of potassium. ", "MathCaption",
 CellTags->{"S5.54.1", "1.14"}],

Cell[CellGroupData[{

Cell["SpecificHeat[Potassium]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.757`", " ", "Joule"}], 
  RowBox[{"Gram", " ", "Kelvin"}]]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell["This gives the ionization potential of helium. ", "MathCaption",
 CellTags->{"S5.54.1", "1.15"}],

Cell[CellGroupData[{

Cell["IonizationPotential[Helium]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 RowBox[{"24.587`", " ", "ElectronVolt"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell["\<\
Here is a plot of the ionization potential against the atomic number of the \
elements. \
\>", "MathCaption",
 CellTags->{"S5.54.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
(Off[IonizationPotential::unknown];  Off[Graphics::gptn];
ListPlot[ IonizationPotential[Elements]/ElectronVolt,
    PlotJoined -> True, PlotRange -> All])\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.54.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0152295 0.00858001 -0.0960481 0.0284446 [
[.18683 .03367 -6 -9 ]
[.18683 .03367 6 0 ]
[.35843 .03367 -6 -9 ]
[.35843 .03367 6 0 ]
[.53003 .03367 -6 -9 ]
[.53003 .03367 6 0 ]
[.70163 .03367 -6 -9 ]
[.70163 .03367 6 0 ]
[.87323 .03367 -9 -9 ]
[.87323 .03367 9 0 ]
[.00273 .1884 -12 -4.5 ]
[.00273 .1884 0 4.5 ]
[.00273 .33062 -12 -4.5 ]
[.00273 .33062 0 4.5 ]
[.00273 .47284 -12 -4.5 ]
[.00273 .47284 0 4.5 ]
[.00273 .61507 -12 -4.5 ]
[.00273 .61507 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18683 .04617 m
.18683 .05242 L
s
[(20)] .18683 .03367 0 1 Mshowa
.35843 .04617 m
.35843 .05242 L
s
[(40)] .35843 .03367 0 1 Mshowa
.53003 .04617 m
.53003 .05242 L
s
[(60)] .53003 .03367 0 1 Mshowa
.70163 .04617 m
.70163 .05242 L
s
[(80)] .70163 .03367 0 1 Mshowa
.87323 .04617 m
.87323 .05242 L
s
[(100)] .87323 .03367 0 1 Mshowa
.125 Mabswid
.05813 .04617 m
.05813 .04992 L
s
.10103 .04617 m
.10103 .04992 L
s
.14393 .04617 m
.14393 .04992 L
s
.22973 .04617 m
.22973 .04992 L
s
.27263 .04617 m
.27263 .04992 L
s
.31553 .04617 m
.31553 .04992 L
s
.40133 .04617 m
.40133 .04992 L
s
.44423 .04617 m
.44423 .04992 L
s
.48713 .04617 m
.48713 .04992 L
s
.57293 .04617 m
.57293 .04992 L
s
.61583 .04617 m
.61583 .04992 L
s
.65873 .04617 m
.65873 .04992 L
s
.74453 .04617 m
.74453 .04992 L
s
.78743 .04617 m
.78743 .04992 L
s
.83033 .04617 m
.83033 .04992 L
s
.91613 .04617 m
.91613 .04992 L
s
.95903 .04617 m
.95903 .04992 L
s
.25 Mabswid
0 .04617 m
1 .04617 L
s
.01523 .1884 m
.02148 .1884 L
s
[(10)] .00273 .1884 1 0 Mshowa
.01523 .33062 m
.02148 .33062 L
s
[(15)] .00273 .33062 1 0 Mshowa
.01523 .47284 m
.02148 .47284 L
s
[(20)] .00273 .47284 1 0 Mshowa
.01523 .61507 m
.02148 .61507 L
s
[(25)] .00273 .61507 1 0 Mshowa
.125 Mabswid
.01523 .07462 m
.01898 .07462 L
s
.01523 .10306 m
.01898 .10306 L
s
.01523 .13151 m
.01898 .13151 L
s
.01523 .15995 m
.01898 .15995 L
s
.01523 .21684 m
.01898 .21684 L
s
.01523 .24529 m
.01898 .24529 L
s
.01523 .27373 m
.01898 .27373 L
s
.01523 .30218 m
.01898 .30218 L
s
.01523 .35907 m
.01898 .35907 L
s
.01523 .38751 m
.01898 .38751 L
s
.01523 .41595 m
.01898 .41595 L
s
.01523 .4444 m
.01898 .4444 L
s
.01523 .50129 m
.01898 .50129 L
s
.01523 .52973 m
.01898 .52973 L
s
.01523 .55818 m
.01898 .55818 L
s
.01523 .58662 m
.01898 .58662 L
s
.01523 .01773 m
.01898 .01773 L
s
.25 Mabswid
.01523 0 m
.01523 .61803 L
s
.5 Mabswid
.02381 .29074 m
.03239 .60332 L
.04097 .05733 L
.04955 .16914 L
.05813 .13999 L
.06671 .22424 L
.07529 .31737 L
.08387 .29131 L
.09245 .39954 L
.10103 .51736 L
.10961 .05013 L
.11819 .12144 L
.12677 .07422 L
.13535 .13583 L
.14393 .20225 L
.15251 .19864 L
.16109 .27282 L
.16967 .35224 L
.17825 .02743 L
.18683 .07783 L
.19541 .09058 L
.20399 .09817 L
.21257 .09584 L
.22115 .09644 L
.22973 .11541 L
.23831 .12872 L
.24689 .12812 L
.25547 .12127 L
.26405 .12371 L
.27263 .17116 L
.28121 .07459 L
.28979 .12866 L
.29837 .18314 L
.30695 .18134 L
.31553 .24 L
.32411 .30218 L
.33269 .02276 L
.34127 .06594 L
.34985 .08079 L
.35843 .09265 L
.36701 .09621 L
.37559 .10568 L
.38417 .11103 L
.39275 .11333 L
.40133 .11612 L
.40991 .14109 L
.41849 .11945 L
.42707 .15978 L
.43565 .06853 L
.44423 .11285 L
Mistroke
.45281 .14971 L
.46139 .16024 L
.46997 .20123 L
.47855 .24898 L
.48713 .01472 L
.49571 .05221 L
.50429 .06259 L
.51287 .06151 L
.52145 .05937 L
.53003 .06111 L
.53861 .06182 L
.54719 .06449 L
.55577 .06523 L
.56435 .07889 L
.57293 .07075 L
.58151 .07288 L
.59009 .07525 L
.59867 .07769 L
.60725 .07985 L
.61583 .08184 L
.62441 .05829 L
.63299 .09809 L
.64157 .12838 L
.65015 .13094 L
.65873 .1281 L
.66731 .15142 L
.67589 .1628 L
.68447 .15995 L
.69305 .16638 L
.70163 .20086 L
.71021 .07769 L
.71879 .11493 L
.72737 .11128 L
.73595 .14337 L
Mfstroke
.75311 .2097 m
0 0 rlineto s
.77027 .05411 m
.77885 .05101 L
.78743 .07689 L
.79601 .07149 L
.80459 .08014 L
.81317 .08219 L
.82175 .07633 L
.83033 .07442 L
.83891 .07519 L
.84749 .08116 L
.85607 .08315 L
.86465 .08657 L
.87323 .08884 L
.88181 .09112 L
.89039 .09311 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.54.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.54.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SolarSystemAbundance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the relative abundance of the specified element in the solar \
system",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EarthCrustAbundance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the relative abundance of the specified element in the Earth\
\[CloseCurlyQuote]s crust",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EarthOceanAbundance[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the relative abundance of the specified element in the Earth\
\[CloseCurlyQuote]s ocean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.54.1"],

Cell["Abundances of the chemical elements. ", "Caption",
 CellTags->"S5.54.1"],

Cell["\<\
This gives the ten most abundant elements in the Solar System. \
\>", "MathCaption",
 CellTags->{"S5.54.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
(Off[SolarSystemAbundance::unknown];
Take[Reverse[Sort[
 Map[{ SolarSystemAbundance[#] /. Unknown->0, #}&, Elements]
]], 10])\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.54.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.91`", ",", "Hydrogen"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.089`", ",", "Helium"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00078`", ",", "Oxygen"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00033`", ",", "Carbon"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000112`", ",", "Neon"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000102`", ",", "Nitrogen"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.000035`", ",", "Magnesium"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0000326`", ",", "Sulfur"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0000326`", ",", "Silicon"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0000294`", ",", "Iron"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.54.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.54.1"->{
    Cell[1776, 53, 146, 6, 36, "Subsection",
      CellTags->{"S5.54.1", "1.1"}],
    Cell[1925, 61, 3617, 112, 130, "DefinitionBox",
      CellTags->"S5.54.1"],
    Cell[5545, 175, 84, 1, 15, "Caption",
      CellTags->"S5.54.1"],
    Cell[5632, 178, 78, 1, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.2"}],
    Cell[5713, 181, 96, 2, 28, "Input",
      CellTags->"S5.54.1"],
    Cell[5812, 185, 134, 3, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.3"}],
    Cell[5971, 192, 85, 2, 28, "Input",
      CellTags->"S5.54.1"],
    Cell[6059, 196, 80, 2, 25, "Output",
      CellTags->"S5.54.1"],
    Cell[6154, 201, 247, 7, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.4"}],
    Cell[6426, 212, 86, 2, 28, "Input",
      CellTags->"S5.54.1"],
    Cell[6515, 216, 200, 6, 19, "Message",
      CellTags->"S5.54.1"],
    Cell[6718, 224, 76, 2, 25, "Output",
      CellTags->"S5.54.1"],
    Cell[6809, 229, 93, 1, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.5"}],
    Cell[6905, 232, 90, 2, 28, "Input",
      CellTags->"S5.54.1"],
    Cell[6998, 236, 125, 3, 38, "MathCaption",
      CellTags->{"S5.54.1", "1.6"}],
    Cell[7148, 243, 163, 7, 79, "Input",
      CellTags->"S5.54.1"],
    Cell[7314, 252, 4778, 323, 70, 4707, 320, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.54.1"],
    Cell[12095, 577, 180, 6, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[12290, 586, 4378, 132, 70, "DefinitionBox",
      CellTags->"S5.54.1"],
    Cell[16671, 720, 83, 1, 70, "Caption",
      CellTags->"S5.54.1"],
    Cell[16757, 723, 621, 13, 70, "Text",
      CellTags->{"S5.54.1", "1.7"}],
    Cell[17381, 738, 97, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.8"}],
    Cell[17503, 743, 85, 2, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[17591, 747, 141, 4, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[17747, 754, 264, 6, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.9"}],
    Cell[18036, 764, 80, 2, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[18119, 768, 199, 6, 70, "Message",
      CellTags->"S5.54.1"],
    Cell[18321, 776, 157, 5, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[18493, 784, 107, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.10"}],
    Cell[18625, 789, 92, 2, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[18720, 793, 239, 6, 70, "Message",
      CellTags->"S5.54.1"],
    Cell[18962, 801, 159, 5, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[19136, 809, 1619, 48, 70, "DefinitionBox",
      CellTags->"S5.54.1"],
    Cell[20758, 859, 84, 1, 70, "Caption",
      CellTags->"S5.54.1"],
    Cell[20845, 862, 1106, 37, 70, "Text",
      CellTags->{"S5.54.1", "1.11"}],
    Cell[21954, 901, 137, 3, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.12"}],
    Cell[22116, 908, 94, 2, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[22213, 912, 516, 16, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[22744, 931, 101, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.13"}],
    Cell[22870, 936, 101, 2, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[22974, 940, 4196, 114, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[27185, 1057, 1596, 48, 70, "DefinitionBox",
      CellTags->"S5.54.1"],
    Cell[28784, 1107, 110, 3, 70, "Caption",
      CellTags->"S5.54.1"],
    Cell[28897, 1112, 98, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.14"}],
    Cell[29020, 1117, 87, 2, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[29110, 1121, 158, 5, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[29283, 1129, 102, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.15"}],
    Cell[29410, 1134, 91, 2, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[29504, 1138, 114, 3, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[29633, 1144, 151, 4, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.16"}],
    Cell[29809, 1152, 226, 6, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[30038, 1160, 4605, 313, 70, 4534, 310, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.54.1"],
    Cell[34646, 1475, 181, 6, 70, "Output",
      CellTags->"S5.54.1"],
    Cell[34842, 1484, 2418, 72, 70, "DefinitionBox",
      CellTags->"S5.54.1"],
    Cell[37263, 1558, 78, 1, 70, "Caption",
      CellTags->"S5.54.1"],
    Cell[37344, 1561, 126, 3, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.17"}],
    Cell[37495, 1568, 197, 7, 70, "Input",
      CellTags->"S5.54.1"],
    Cell[37695, 1577, 818, 24, 70, "Output",
      CellTags->"S5.54.1"]},
  "1.1"->{
    Cell[1776, 53, 146, 6, 36, "Subsection",
      CellTags->{"S5.54.1", "1.1"}]},
  "1.2"->{
    Cell[5632, 178, 78, 1, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.2"}]},
  "1.3"->{
    Cell[5812, 185, 134, 3, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.3"}]},
  "1.4"->{
    Cell[6154, 201, 247, 7, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.4"}]},
  "1.5"->{
    Cell[6809, 229, 93, 1, 40, "MathCaption",
      CellTags->{"S5.54.1", "1.5"}]},
  "1.6"->{
    Cell[6998, 236, 125, 3, 38, "MathCaption",
      CellTags->{"S5.54.1", "1.6"}]},
  "1.7"->{
    Cell[16757, 723, 621, 13, 70, "Text",
      CellTags->{"S5.54.1", "1.7"}]},
  "1.8"->{
    Cell[17381, 738, 97, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.8"}]},
  "1.9"->{
    Cell[17747, 754, 264, 6, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.9"}]},
  "1.10"->{
    Cell[18493, 784, 107, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.10"}]},
  "1.11"->{
    Cell[20845, 862, 1106, 37, 70, "Text",
      CellTags->{"S5.54.1", "1.11"}]},
  "1.12"->{
    Cell[21954, 901, 137, 3, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.12"}]},
  "1.13"->{
    Cell[22744, 931, 101, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.13"}]},
  "1.14"->{
    Cell[28897, 1112, 98, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.14"}]},
  "1.15"->{
    Cell[29283, 1129, 102, 1, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.15"}]},
  "1.16"->{
    Cell[29633, 1144, 151, 4, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.16"}]},
  "1.17"->{
    Cell[37344, 1561, 126, 3, 70, "MathCaption",
      CellTags->{"S5.54.1", "1.17"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.54.1", 39164, 1621},
  {"1.1", 43715, 1742},
  {"1.2", 43809, 1745},
  {"1.3", 43904, 1748},
  {"1.4", 44000, 1751},
  {"1.5", 44096, 1754},
  {"1.6", 44191, 1757},
  {"1.7", 44287, 1760},
  {"1.8", 44378, 1763},
  {"1.9", 44474, 1766},
  {"1.10", 44572, 1769},
  {"1.11", 44671, 1772},
  {"1.12", 44765, 1775},
  {"1.13", 44864, 1778},
  {"1.14", 44963, 1781},
  {"1.15", 45062, 1784},
  {"1.16", 45162, 1787},
  {"1.17", 45262, 1790}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 146, 6, 36, "Subsection",
  CellTags->{"S5.54.1", "1.1"}],
Cell[1925, 61, 3617, 112, 130, "DefinitionBox",
  CellTags->"S5.54.1"],
Cell[5545, 175, 84, 1, 15, "Caption",
  CellTags->"S5.54.1"],
Cell[5632, 178, 78, 1, 40, "MathCaption",
  CellTags->{"S5.54.1", "1.2"}],
Cell[5713, 181, 96, 2, 28, "Input",
  CellTags->"S5.54.1"],
Cell[5812, 185, 134, 3, 40, "MathCaption",
  CellTags->{"S5.54.1", "1.3"}],

Cell[CellGroupData[{
Cell[5971, 192, 85, 2, 28, "Input",
  CellTags->"S5.54.1"],
Cell[6059, 196, 80, 2, 25, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[6154, 201, 247, 7, 40, "MathCaption",
  CellTags->{"S5.54.1", "1.4"}],

Cell[CellGroupData[{
Cell[6426, 212, 86, 2, 28, "Input",
  CellTags->"S5.54.1"],
Cell[6515, 216, 200, 6, 19, "Message",
  CellTags->"S5.54.1"],
Cell[6718, 224, 76, 2, 25, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[6809, 229, 93, 1, 40, "MathCaption",
  CellTags->{"S5.54.1", "1.5"}],
Cell[6905, 232, 90, 2, 28, "Input",
  CellTags->"S5.54.1"],
Cell[6998, 236, 125, 3, 38, "MathCaption",
  CellTags->{"S5.54.1", "1.6"}],

Cell[CellGroupData[{
Cell[7148, 243, 163, 7, 79, "Input",
  CellTags->"S5.54.1"],
Cell[7314, 252, 4778, 323, 70, 4707, 320, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.54.1"],
Cell[12095, 577, 180, 6, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[12290, 586, 4378, 132, 70, "DefinitionBox",
  CellTags->"S5.54.1"],
Cell[16671, 720, 83, 1, 70, "Caption",
  CellTags->"S5.54.1"],
Cell[16757, 723, 621, 13, 70, "Text",
  CellTags->{"S5.54.1", "1.7"}],
Cell[17381, 738, 97, 1, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.8"}],

Cell[CellGroupData[{
Cell[17503, 743, 85, 2, 70, "Input",
  CellTags->"S5.54.1"],
Cell[17591, 747, 141, 4, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[17747, 754, 264, 6, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.9"}],

Cell[CellGroupData[{
Cell[18036, 764, 80, 2, 70, "Input",
  CellTags->"S5.54.1"],
Cell[18119, 768, 199, 6, 70, "Message",
  CellTags->"S5.54.1"],
Cell[18321, 776, 157, 5, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[18493, 784, 107, 1, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.10"}],

Cell[CellGroupData[{
Cell[18625, 789, 92, 2, 70, "Input",
  CellTags->"S5.54.1"],
Cell[18720, 793, 239, 6, 70, "Message",
  CellTags->"S5.54.1"],
Cell[18962, 801, 159, 5, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[19136, 809, 1619, 48, 70, "DefinitionBox",
  CellTags->"S5.54.1"],
Cell[20758, 859, 84, 1, 70, "Caption",
  CellTags->"S5.54.1"],
Cell[20845, 862, 1106, 37, 70, "Text",
  CellTags->{"S5.54.1", "1.11"}],
Cell[21954, 901, 137, 3, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.12"}],

Cell[CellGroupData[{
Cell[22116, 908, 94, 2, 70, "Input",
  CellTags->"S5.54.1"],
Cell[22213, 912, 516, 16, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[22744, 931, 101, 1, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.13"}],

Cell[CellGroupData[{
Cell[22870, 936, 101, 2, 70, "Input",
  CellTags->"S5.54.1"],
Cell[22974, 940, 4196, 114, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[27185, 1057, 1596, 48, 70, "DefinitionBox",
  CellTags->"S5.54.1"],
Cell[28784, 1107, 110, 3, 70, "Caption",
  CellTags->"S5.54.1"],
Cell[28897, 1112, 98, 1, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.14"}],

Cell[CellGroupData[{
Cell[29020, 1117, 87, 2, 70, "Input",
  CellTags->"S5.54.1"],
Cell[29110, 1121, 158, 5, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[29283, 1129, 102, 1, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.15"}],

Cell[CellGroupData[{
Cell[29410, 1134, 91, 2, 70, "Input",
  CellTags->"S5.54.1"],
Cell[29504, 1138, 114, 3, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[29633, 1144, 151, 4, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.16"}],

Cell[CellGroupData[{
Cell[29809, 1152, 226, 6, 70, "Input",
  CellTags->"S5.54.1"],
Cell[30038, 1160, 4605, 313, 70, 4534, 310, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.54.1"],
Cell[34646, 1475, 181, 6, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]],
Cell[34842, 1484, 2418, 72, 70, "DefinitionBox",
  CellTags->"S5.54.1"],
Cell[37263, 1558, 78, 1, 70, "Caption",
  CellTags->"S5.54.1"],
Cell[37344, 1561, 126, 3, 70, "MathCaption",
  CellTags->{"S5.54.1", "1.17"}],

Cell[CellGroupData[{
Cell[37495, 1568, 197, 7, 70, "Input",
  CellTags->"S5.54.1"],
Cell[37695, 1577, 818, 24, 70, "Output",
  CellTags->"S5.54.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

