(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63628,       1751]*)
(*NotebookOutlinePosition[     69424,       1924]*)
(*  CellTagsIndexPosition[     68959,       1902]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "CityData",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.55.1", "1.1"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s programming capabilities allow you to create powerful \
customized tools. In this package, one approach to a sample database is used. \
This database, containing information about cities, is expandable and can be \
used with other functions. "
}], "Text",
 CellTags->{"S5.55.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CityData[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["city", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["datatype", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give data from the \
\[OpenCurlyDoubleQuote]field\[CloseCurlyDoubleQuote] ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["datatype", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" about the named city",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CityData[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["city", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list of \[OpenCurlyDoubleQuote]fieldnames\
\[CloseCurlyDoubleQuote] and their corresponding values for ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["city", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CityData[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["datatype", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the cities in the database with information in this \
\[OpenCurlyDoubleQuote]field\[CloseCurlyDoubleQuote]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.55.1"],

Cell[TextData[{
 "Accessing the ",
 StyleBox["CityData", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " database. "
}], "Caption",
 CellTags->"S5.55.1"],

Cell[TextData[{
 "The database currently contains only position location for a number of \
cities around the world. Positions are stored as latitudes and longitudes in \
a ",
 StyleBox["{", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["degree", "TI"],
 StyleBox[", ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["minute", "TI"],
 StyleBox[", ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["second", "TI"],
 StyleBox["}", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " or ",
 StyleBox["{", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["degree", "TI"],
 StyleBox[", ", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 StyleBox["minute", "TI"],
 StyleBox["}", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " format. "
}], "Text",
 CellTags->{"S5.55.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.55.1", "1.4"}],

Cell["<< Miscellaneous`CityData`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.55.1"],

Cell["This gives the latitude and longitude of Montreal. ", "MathCaption",
 CellTags->{"S5.55.1", "1.5"}],

Cell[CellGroupData[{

Cell["CityData[\"Montreal\", CityPosition]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.55.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"45", ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "73"}], ",", 
     RowBox[{"-", "36"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.55.1"]
}, Open  ]],

Cell["\<\
This returns the information in the database about Washington. \
\>", "MathCaption",
 CellTags->{"S5.55.1", "1.6"}],

Cell[CellGroupData[{

Cell["CityData[\"Washington\"]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.55.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"CityPosition", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"38", ",", "53", ",", "42"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "77"}], ",", 
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "12"}]}], "}"}]}], "}"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.55.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Abidjan, Ivory Coast",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Abu Dhabi, UAE",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Accra, Ghana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Addis Ababa, Ethiopia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Aden, Yemen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Agana, USA, GU",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Algiers, Algeria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Alma Alta, Kazakhstan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Amman, Jordan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Amsterdam, Netherlands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Anchorage, USA, AK",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Andorre\[Hyphen]la\[Hyphen]Vella, Andorra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ankara, Turkey",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Antananarivo, Madagascar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Apia, Western Samoa",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ashkhabad, Turkmenistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Asmera, Eritrea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Asuncion, Paraguay",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Athens, Greece",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Atlanta, USA, GA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Baghdad, Iraq",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Baku, Azerbaijan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bamako, Mali",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Bandar Seri Begawan, Brunei",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bangkok, Thailand",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Bangui, Central African Republic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Banjul, The Gambia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Basse\[Hyphen]Terre, Guadeloupe",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Basseterre, St. Christopher\[Hyphen] Nevis",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Beijing, China",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Beirut, Lebanon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Belgrade, Yugoslavia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Belmopan, Belize",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Beograd, Serbia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Berlin, Germany",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bern, Switzerland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bishkek, Kirghizia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Bissau, Guinea\[Hyphen]Bissau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bogota, Colombia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bombay, India",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bonn, Germany",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Boston, USA, MA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Brasilia, Brazil",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Bratislava, Slovak Republic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Brazzaville, Congo",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bridgetown, Barbados",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Brussels, Belgium",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bucharest, Romania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Budapest, Hungary",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Buenos Aires, Argentina",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bujumbura, Burundi",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Cairo, Egypt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Calcutta, India",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Canberra, Australia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cape Town, South Africa",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Caracas, Venezuela",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cardiff, United Kingdom",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Castries, St. Lucia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cayenne, French Guiana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Charlotte Amalie, USA, VI",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Chicago, USA, IL",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Colombo, Sri Lanka",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Conakry, Guinea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Copenhagen, Denmark",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cupertino, USA, CA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Dacca, Bangladesh",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Dakar, Sengal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Dallas, USA, TX",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Damascus, Syria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Dar es Salaam, Tanzania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Denver, USA, CO",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Djakarta, Indonesia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Djibouti, Djibouti",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Doha, Qatar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Domaneab, Nauru",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Dublin, Ireland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Dushanbe, Tajikistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Edinburgh, United Kingdom",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["El Aaiun, Western Sahara",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Fort\[Hyphen]de\[Hyphen]France, Martinique",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Freetown, Sierra Leone",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Funafuti, Tuvalu",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Gaborone, Botswana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Geneva, Switzerland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Georgetown, Cayman Islands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Georgetown, Guyana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Gibraltar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Godthab, Greenland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Guatemala City, Guatemala",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Hamilton, Bermuda",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Hanoi, Vietnam",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Harare, Zimbabwe",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Havana, Cuba",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Helsinki, Finland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Hong Kong",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Honiara, Solomon Islands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Honolulu, USA, HI",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Islamabad, Pakistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Istanbul, Turkey",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Jerusalem, Israel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kabul, Afghanistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kampala, Uganda",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Karachi, Pakistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Katmandu, Nepal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Khartoum, Sudan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kiev, Ukraine",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kigali, Rwanda",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kingston, Jamaica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kingstown, St. Vincent\[Hyphen]Grenadines",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kinshasa, Zaire",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kishinev, Moldavia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kolonia, USA, FM",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Koror, Belau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kuala Lumpur, Malaysia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kuwait City, Kuwait",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lagos, Nigeria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["La Paz, Bolivia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Las Palmas, Canary Islands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Libreville, Gabon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lilongwe, Malawi",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Lima, Peru",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lisbon, Portugal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ljubljana, Slovenia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lome, Togo",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["London, United Kingdom",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Los Angeles, USA, CA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Luanda, Angola",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lusaka, Zambia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Luxembourg, Luxembourg",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Madrid, Spain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Malabo, Equatorial Guinea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Male, Maldives",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Managua, Nicaragua",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Manama, Bahrain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Manila, Philippines",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Maputo, Mozambique",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Maseru, Lesotho",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mbabane, Swaziland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mecca, Saudi Arabia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mexico City, Mexico",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Miami, USA, FL",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Minneapolis, USA, MN",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Minsk, Belorussia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mogadisho, Somalia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Monaco",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Monrovia, Liberia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Montevideo, Uruguay",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Montreal, Canada",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Moroni, Comoros",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Moscow, Russia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Muscat, Oman",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Nairobi, Kenya",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Nassau, Bahamas",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ndjamena, Chad",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["New Delhi, India",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["New York, USA, NY",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Niamey, Niger",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Nicosia, Cyprus",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Nouakchott, Mauritania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Noumea, New Caledonia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Nuku\[CloseCurlyQuote]alofa, Tonga",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Nukunonu, Tokelau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Oranjestad, Aruba",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Osaka, Japan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Oslo, Norway",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ottawa, Canada",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ouagadougou, Burkina Faso",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Pago Pago, American Samoa",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Panama City, Panama",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Paramaribo, Surinam",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Paris, France",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Peking, China",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Perth, Australia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Philadelphia, USA, PA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Phnom Penh, Cambodia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Plymouth, Montserrat",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ponta Delgada, Azores",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Port\[Hyphen]au\[Hyphen]Prince, Haiti",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Portland, USA, OR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Port Louis, Mauritius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Port Moresby, Papua New Guinea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Port of Spain, Trinidad and Tobago",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Porto\[Hyphen]Novo, Benin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Port Vila, Vanuatu",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Prague, Czech Republic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Praia, Cape Verde Islands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pretoria, South Africa",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Pyongyang, North Korea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Quito, Ecuador",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Rabat, Morocco",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rangoon, Burma",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Reykjavik, Iceland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Riga, Latvia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Rio de Janeiro, Brazil",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Riyadh, Saudi Arabia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Road Town, United Kingdom, Virgin Islands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rome, Italy",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Roseau, Dominica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Saint Louis, USA, MO",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Salt Lake City, USA, UT",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Sana, Yemen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["San Diego, USA, CA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["San Francisco, USA, CA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["San Jose, Costa Rica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["San Juan, USA, PR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["San Marino, San Marino",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["San Salvador, El Salvador",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Santiago, Chile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Santo Domingo, Dominican Republic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sao Paulo, Brazil",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Sao Tome, Sao Tome and Principe",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Sarajevo, Bosnia\[Hyphen]Herzogovina",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Seoul, South Korea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Shanghai, China",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Singapore, Singapore",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Skopje, Macedonia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Sofia, Bulgaria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Stanley, Falkland Islands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["St. Denis, Reunion",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "St. George\[CloseCurlyQuote]s, Grenada",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox[
     "St. John\[CloseCurlyQuote]s, Antigua and Barbuda",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Stockholm, Sweden",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["St. Peterburg, Russia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sucre, Bolivia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Suva, Fiji",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sydney, Australia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Taipei, Taiwan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tallinn, Estonia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tarawa, Kiribati",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tashkent, Uzbekistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tblisi, Georgia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tegucigalpa, Honduras",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tehran, Iran",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["The Valley, Anguilla",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Thimphu, Bhutan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tianjin, China",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tirana, Albania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tokyo, Japan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Torshavn, Faroe Islands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tripoli, Libya",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tunis, Tunisia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ulan Bator, Mongolia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Vaduz, Liechtenstein",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Valletta, Malta",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Vancouver, Canada",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Vatican City",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Victoria, Seychelles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Vienna, Austria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Vientiane, Laos",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Vilnius, Lithuania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Warsaw, Poland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Washington, USA, DC",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Wellington, New Zealand",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Willemstad, Netherlands Antilles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Windhoek, Namibia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Yaounde, Cameroon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Yerevan, Armenia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Zagreb, Croatia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Zurich, Switzerland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.55.1"],

Cell[TextData[{
 "Cities defined in ",
 StyleBox["Miscellaneous`CityData`", "MR"],
 "."
}], "Caption",
 CellTags->"S5.55.1"],

Cell[TextData[{
 "You can give a more precise name for a city using the form ",
 StyleBox["{", "MR"],
 StyleBox["cityname", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["countryname", "TI"],
 StyleBox["}", "MR"],
 ", with more precise indicators such as state names following, if necessary. \
The database also checks the spelling of your request. If there is no \
matching name, but a name that is close, that name will be suggested to you. \
"
}], "Text",
 CellTags->{"S5.55.1", "1.7"}],

Cell["This city is in the database under the name Rome. ", "MathCaption",
 CellTags->{"S5.55.1", "1.8"}],

Cell[CellGroupData[{

Cell["CityData[\"Roma\", CityPosition]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.55.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CityData", "::", "\<\"alternates\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Requested city not in database.  Possible alternatives: \
\\!\\({\\({\\\"Rome\\\", \\\"Italy\\\"}\\)}\\)\"\>"}]], "Message",
 CellTags->"S5.55.1"],

Cell[BoxData[
 RowBox[{"CityData", "[", 
  RowBox[{"\<\"Roma\"\>", ",", "CityPosition"}], "]"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.55.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CityDistance[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["city",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\", \"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["city",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the distance between the cities in kilometers ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CityDistance[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["city",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\", \"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["city",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\", CityDistanceMethod -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["method", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the distance using the specified method, a pure function of two \
arguments representing the positions of the cities ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.55.1"],

Cell[TextData[{
 "The ",
 StyleBox["CityDistance", "MR"],
 " function. "
}], "Caption",
 CellTags->"S5.55.1"],

Cell[TextData[{
 "The function ",
 StyleBox["CityDistance", "MR"],
 " uses the positions in the database to determine the distance between two \
cities. The default method of computing distance is ",
 StyleBox["SphericalDistance", "MR"],
 " from the package ",
 StyleBox["Miscellaneous`Geodesy`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.55.1", "1.9"}],

Cell["This gives the distance between Washington and Montreal. ", \
"MathCaption",
 CellTags->{"S5.55.1", "1.10"}],

Cell[CellGroupData[{

Cell["CityDistance[\"Washington\", \"Montreal\"]//N", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.55.1"],

Cell[BoxData["786.9150125626869`"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.55.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["$CityFields", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the symbol that holds the names of the data fields in the database",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CityPosition", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the field in the database that holds position information",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.55.1"],

Cell["Controlling information in the database. ", "Caption",
 CellTags->"S5.55.1"],

Cell["\<\
The database is quite expandable; you can add additional cities and \
additional information for each city. \
\>", "Text",
 CellTags->{"S5.55.1", "1.11"}],

Cell["\<\
This places position information for Champaign, Illinois, into the database. \
\
\>", "MathCaption",
 CellTags->{"S5.55.1", "1.12"}],

Cell["\<\
CityPosition[{\"Champaign\", \"USA\", \"IL\"}] =
        {{40, 7, 5}, {-88, -14, -48}};\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.55.1"],

Cell["Here is the position of Champaign. ", "MathCaption",
 CellTags->{"S5.55.1", "1.13"}],

Cell[CellGroupData[{

Cell["CityData[\"Champaign\", CityPosition]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.55.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"40", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "88"}], ",", 
     RowBox[{"-", "14"}], ",", 
     RowBox[{"-", "48"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.55.1"]
}, Open  ]],

Cell["\<\
This adds a new field to the database to hold population information. \
\>", "MathCaption",
 CellTags->{"S5.55.1", "1.14"}],

Cell["AppendTo[$CityFields, CityPopulation];", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.55.1"],

Cell["Here is the population for Washington. ", "MathCaption",
 CellTags->{"S5.55.1", "1.15"}],

Cell["CityPopulation[{\"Washington\", \"USA\", \"DC\"}] = 638000;", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.55.1"],

Cell["This accesses all data about Washington in the database. ", \
"MathCaption",
 CellTags->{"S5.55.1", "1.16"}],

Cell[CellGroupData[{

Cell["CityData[\"Washington\"]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.55.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"CityPosition", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"38", ",", "53", ",", "42"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "77"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "12"}]}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"CityPopulation", ",", "638000"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.55.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.55.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.55.1", "1.1"}],
    Cell[1917, 61, 356, 7, 56, "Text",
      CellTags->{"S5.55.1", "1.2"}],
    Cell[2276, 70, 2964, 91, 124, "DefinitionBox",
      CellTags->"S5.55.1"],
    Cell[5243, 163, 172, 7, 15, "Caption",
      CellTags->"S5.55.1"],
    Cell[5418, 172, 930, 33, 56, "Text",
      CellTags->{"S5.55.1", "1.3"}],
    Cell[6351, 207, 78, 1, 40, "MathCaption",
      CellTags->{"S5.55.1", "1.4"}],
    Cell[6432, 210, 89, 2, 28, "Input",
      CellTags->"S5.55.1"],
    Cell[6524, 214, 105, 1, 40, "MathCaption",
      CellTags->{"S5.55.1", "1.5"}],
    Cell[6654, 219, 99, 2, 28, "Input",
      CellTags->"S5.55.1"],
    Cell[6756, 223, 263, 10, 25, "Output",
      CellTags->"S5.55.1"],
    Cell[7034, 236, 125, 3, 40, "MathCaption",
      CellTags->{"S5.55.1", "1.6"}],
    Cell[7184, 243, 87, 2, 28, "Input",
      CellTags->"S5.55.1"],
    Cell[7274, 247, 412, 14, 25, "Output",
      CellTags->"S5.55.1"],
    Cell[7701, 264, 47315, 1187, 2754, "DefinitionBox",
      CellTags->"S5.55.1"],
    Cell[55019, 1453, 124, 5, 70, "Caption",
      CellTags->"S5.55.1"],
    Cell[55146, 1460, 483, 12, 70, "Text",
      CellTags->{"S5.55.1", "1.7"}],
    Cell[55632, 1474, 104, 1, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.8"}],
    Cell[55761, 1479, 95, 2, 70, "Input",
      CellTags->"S5.55.1"],
    Cell[55859, 1483, 253, 6, 70, "Message",
      CellTags->"S5.55.1"],
    Cell[56115, 1491, 153, 4, 70, "Output",
      CellTags->"S5.55.1"],
    Cell[56283, 1498, 2967, 87, 70, "DefinitionBox",
      CellTags->"S5.55.1"],
    Cell[59253, 1587, 109, 5, 70, "Caption",
      CellTags->"S5.55.1"],
    Cell[59365, 1594, 352, 10, 70, "Text",
      CellTags->{"S5.55.1", "1.9"}],
    Cell[59720, 1606, 114, 2, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.10"}],
    Cell[59859, 1612, 108, 2, 70, "Input",
      CellTags->"S5.55.1"],
    Cell[59970, 1616, 91, 2, 70, "Output",
      CellTags->"S5.55.1"],
    Cell[60076, 1621, 1220, 36, 70, "DefinitionBox",
      CellTags->"S5.55.1"],
    Cell[61299, 1659, 82, 1, 70, "Caption",
      CellTags->"S5.55.1"],
    Cell[61384, 1662, 164, 4, 70, "Text",
      CellTags->{"S5.55.1", "1.11"}],
    Cell[61551, 1668, 142, 4, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.12"}],
    Cell[61696, 1674, 158, 5, 70, "Input",
      CellTags->"S5.55.1"],
    Cell[61857, 1681, 90, 1, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.13"}],
    Cell[61972, 1686, 100, 2, 70, "Input",
      CellTags->"S5.55.1"],
    Cell[62075, 1690, 304, 11, 70, "Output",
      CellTags->"S5.55.1"],
    Cell[62394, 1704, 133, 3, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.14"}],
    Cell[62530, 1709, 101, 2, 70, "Input",
      CellTags->"S5.55.1"],
    Cell[62634, 1713, 94, 1, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.15"}],
    Cell[62731, 1716, 122, 2, 70, "Input",
      CellTags->"S5.55.1"],
    Cell[62856, 1720, 114, 2, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.16"}],
    Cell[62995, 1726, 88, 2, 70, "Input",
      CellTags->"S5.55.1"],
    Cell[63086, 1730, 514, 17, 70, "Output",
      CellTags->"S5.55.1"]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.55.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 356, 7, 56, "Text",
      CellTags->{"S5.55.1", "1.2"}]},
  "1.3"->{
    Cell[5418, 172, 930, 33, 56, "Text",
      CellTags->{"S5.55.1", "1.3"}]},
  "1.4"->{
    Cell[6351, 207, 78, 1, 40, "MathCaption",
      CellTags->{"S5.55.1", "1.4"}]},
  "1.5"->{
    Cell[6524, 214, 105, 1, 40, "MathCaption",
      CellTags->{"S5.55.1", "1.5"}]},
  "1.6"->{
    Cell[7034, 236, 125, 3, 40, "MathCaption",
      CellTags->{"S5.55.1", "1.6"}]},
  "1.7"->{
    Cell[55146, 1460, 483, 12, 70, "Text",
      CellTags->{"S5.55.1", "1.7"}]},
  "1.8"->{
    Cell[55632, 1474, 104, 1, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.8"}]},
  "1.9"->{
    Cell[59365, 1594, 352, 10, 70, "Text",
      CellTags->{"S5.55.1", "1.9"}]},
  "1.10"->{
    Cell[59720, 1606, 114, 2, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.10"}]},
  "1.11"->{
    Cell[61384, 1662, 164, 4, 70, "Text",
      CellTags->{"S5.55.1", "1.11"}]},
  "1.12"->{
    Cell[61551, 1668, 142, 4, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.12"}]},
  "1.13"->{
    Cell[61857, 1681, 90, 1, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.13"}]},
  "1.14"->{
    Cell[62394, 1704, 133, 3, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.14"}]},
  "1.15"->{
    Cell[62634, 1713, 94, 1, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.15"}]},
  "1.16"->{
    Cell[62856, 1720, 114, 2, 70, "MathCaption",
      CellTags->{"S5.55.1", "1.16"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.55.1", 64251, 1767},
  {"1.1", 67413, 1850},
  {"1.2", 67507, 1853},
  {"1.3", 67595, 1856},
  {"1.4", 67685, 1859},
  {"1.5", 67780, 1862},
  {"1.6", 67876, 1865},
  {"1.7", 67972, 1868},
  {"1.8", 68064, 1871},
  {"1.9", 68162, 1874},
  {"1.10", 68255, 1877},
  {"1.11", 68355, 1880},
  {"1.12", 68448, 1883},
  {"1.13", 68548, 1886},
  {"1.14", 68647, 1889},
  {"1.15", 68747, 1892},
  {"1.16", 68846, 1895}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S5.55.1", "1.1"}],
Cell[1917, 61, 356, 7, 56, "Text",
  CellTags->{"S5.55.1", "1.2"}],
Cell[2276, 70, 2964, 91, 124, "DefinitionBox",
  CellTags->"S5.55.1"],
Cell[5243, 163, 172, 7, 15, "Caption",
  CellTags->"S5.55.1"],
Cell[5418, 172, 930, 33, 56, "Text",
  CellTags->{"S5.55.1", "1.3"}],
Cell[6351, 207, 78, 1, 40, "MathCaption",
  CellTags->{"S5.55.1", "1.4"}],
Cell[6432, 210, 89, 2, 28, "Input",
  CellTags->"S5.55.1"],
Cell[6524, 214, 105, 1, 40, "MathCaption",
  CellTags->{"S5.55.1", "1.5"}],

Cell[CellGroupData[{
Cell[6654, 219, 99, 2, 28, "Input",
  CellTags->"S5.55.1"],
Cell[6756, 223, 263, 10, 25, "Output",
  CellTags->"S5.55.1"]
}, Open  ]],
Cell[7034, 236, 125, 3, 40, "MathCaption",
  CellTags->{"S5.55.1", "1.6"}],

Cell[CellGroupData[{
Cell[7184, 243, 87, 2, 28, "Input",
  CellTags->"S5.55.1"],
Cell[7274, 247, 412, 14, 25, "Output",
  CellTags->"S5.55.1"]
}, Open  ]],
Cell[7701, 264, 47315, 1187, 2754, "DefinitionBox",
  CellTags->"S5.55.1"],
Cell[55019, 1453, 124, 5, 70, "Caption",
  CellTags->"S5.55.1"],
Cell[55146, 1460, 483, 12, 70, "Text",
  CellTags->{"S5.55.1", "1.7"}],
Cell[55632, 1474, 104, 1, 70, "MathCaption",
  CellTags->{"S5.55.1", "1.8"}],

Cell[CellGroupData[{
Cell[55761, 1479, 95, 2, 70, "Input",
  CellTags->"S5.55.1"],
Cell[55859, 1483, 253, 6, 70, "Message",
  CellTags->"S5.55.1"],
Cell[56115, 1491, 153, 4, 70, "Output",
  CellTags->"S5.55.1"]
}, Open  ]],
Cell[56283, 1498, 2967, 87, 70, "DefinitionBox",
  CellTags->"S5.55.1"],
Cell[59253, 1587, 109, 5, 70, "Caption",
  CellTags->"S5.55.1"],
Cell[59365, 1594, 352, 10, 70, "Text",
  CellTags->{"S5.55.1", "1.9"}],
Cell[59720, 1606, 114, 2, 70, "MathCaption",
  CellTags->{"S5.55.1", "1.10"}],

Cell[CellGroupData[{
Cell[59859, 1612, 108, 2, 70, "Input",
  CellTags->"S5.55.1"],
Cell[59970, 1616, 91, 2, 70, "Output",
  CellTags->"S5.55.1"]
}, Open  ]],
Cell[60076, 1621, 1220, 36, 70, "DefinitionBox",
  CellTags->"S5.55.1"],
Cell[61299, 1659, 82, 1, 70, "Caption",
  CellTags->"S5.55.1"],
Cell[61384, 1662, 164, 4, 70, "Text",
  CellTags->{"S5.55.1", "1.11"}],
Cell[61551, 1668, 142, 4, 70, "MathCaption",
  CellTags->{"S5.55.1", "1.12"}],
Cell[61696, 1674, 158, 5, 70, "Input",
  CellTags->"S5.55.1"],
Cell[61857, 1681, 90, 1, 70, "MathCaption",
  CellTags->{"S5.55.1", "1.13"}],

Cell[CellGroupData[{
Cell[61972, 1686, 100, 2, 70, "Input",
  CellTags->"S5.55.1"],
Cell[62075, 1690, 304, 11, 70, "Output",
  CellTags->"S5.55.1"]
}, Open  ]],
Cell[62394, 1704, 133, 3, 70, "MathCaption",
  CellTags->{"S5.55.1", "1.14"}],
Cell[62530, 1709, 101, 2, 70, "Input",
  CellTags->"S5.55.1"],
Cell[62634, 1713, 94, 1, 70, "MathCaption",
  CellTags->{"S5.55.1", "1.15"}],
Cell[62731, 1716, 122, 2, 70, "Input",
  CellTags->"S5.55.1"],
Cell[62856, 1720, 114, 2, 70, "MathCaption",
  CellTags->{"S5.55.1", "1.16"}],

Cell[CellGroupData[{
Cell[62995, 1726, 88, 2, 70, "Input",
  CellTags->"S5.55.1"],
Cell[63086, 1730, 514, 17, 70, "Output",
  CellTags->"S5.55.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

