(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    773685,      19299]*)
(*NotebookOutlinePosition[    775501,      19361]*)
(*  CellTagsIndexPosition[    775219,      19348]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Statistics`ClusterAnalysis`", "Section"],

Cell["\<\
Cluster analysis is an unsupervised learning technique used for \
classification of data. Data elements are partitioned into groups called \
clusters representing collections of data elements that are proximate based \
on a distance or dissimilarity function. The distance or dissimilarity \
function measures how dissimilar data elements are. Identical element pairs \
have zero distance or dissimilarity and all others have positive distance or \
dissimilarity.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FindClusters",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["data",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "partitions ",
              StyleBox["data",
                FontSlant->"Italic"],
              " into lists of similar elements"
            }], "Text"]},
          {
            RowBox[{
              StyleBox["FindClusters",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                RowBox[{
                  StyleBox["data",
                    "TI"], 
                  StyleBox[",",
                    "TI"], " ", "n"}],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"partitions", " ", 
              StyleBox["data",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], "into", " ", "exactly", " ", 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], "lists", " ", "of", " ", "similar", " ",
               "elements"}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell[TextData[StyleBox["General clustering function.",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}]], "Caption",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[TextData[{
  "The data argument of ",
  StyleBox["FindClusters", "MR"],
  " can be a list of data elements or rules indexing elements and labels."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " \[Ellipsis] ",
              StyleBox["}", "MR"],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[{
              StyleBox["data specified as a list of data elements ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`e\_i\)]]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                RowBox[{
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"],
                    "TraditionalForm"], " ", 
                  StyleBox["\[Rule]",
                    "MR"], " ", 
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"],
                    "TraditionalForm"]}], 
                StyleBox[",",
                  "MR"], " ", 
                RowBox[{
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"],
                    "TraditionalForm"], 
                  StyleBox["->",
                    "MR"], 
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"],
                    "TraditionalForm"]}], 
                StyleBox[",",
                  "MR"], " ", "\[Ellipsis]"}], " ", 
              StyleBox["}",
                "MR"]}], Cell[TextData[{
              StyleBox["data specified as a list of rules data elements ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  \(TraditionalForm\`e\_i\)]],
              " and labels ",
              Cell[BoxData[
                  \(TraditionalForm\`v\_i\)]],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {
            RowBox[{
              RowBox[{
                StyleBox["{",
                  "MR"], 
                RowBox[{
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"],
                    "TraditionalForm"], 
                  StyleBox[",",
                    "MR"], " ", 
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"],
                    "TraditionalForm"], 
                  StyleBox[",",
                    "MR"], " ", "\[Ellipsis]"}], " ", 
                StyleBox["}",
                  "MR"]}], " ", 
              StyleBox["\[Rule]",
                "MR"], " ", 
              RowBox[{
                StyleBox["{",
                  "MR"], 
                RowBox[{
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"],
                    "TraditionalForm"], 
                  StyleBox[",",
                    "MR"], " ", 
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "2"],
                    "TraditionalForm"], 
                  StyleBox[",",
                    "MR"], " ", "\[Ellipsis]"}], " ", 
                StyleBox["}",
                  "MR"]}]}], 
            RowBox[{"data", " ", "specified", " ", 
              StyleBox["as",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}], 
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}], 
              StyleBox["a",
                FontSlant->"Plain",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}], 
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}], "rule", " ", "mapping", " ", "data", " ", 
              "elements", " ", \(e\_i\), " ", "to", " ", "labels", 
              " ", \(v\_i\)}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.7.1"],

Cell[TextData[{
  "Ways of specifying data in ",
  StyleBox["FindClusters", "MR"],
  "."
}], "Caption",
  CellTags->"S6.7.1"],

Cell[TextData[{
  "The data elements ",
  Cell[BoxData[
      \(TraditionalForm\`e\_i\)]],
  " can be numeric lists, matrices, or tensors, lists of ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " elements, or lists of strings. All data elements ",
  Cell[BoxData[
      \(TraditionalForm\`e\_i\)]],
  " must have the same dimensions."
}], "Text"],

Cell["This loads the package.", "MathCaption"],

Cell[BoxData[
    \(<< Statistics`ClusterAnalysis`\)], "Input",
  CellLabel->"In[1]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["Here is a list of numbers.", "MathCaption"],

Cell[BoxData[
    StyleBox[\(data\  = \ {1.2, \ 9.1, \ 2.3, \ 15.4, \ 71.8};\),
      FormatType->StandardForm]], "Input",
  CellLabel->"In[2]:="],

Cell[TextData[{
  StyleBox["FindClusters", "MR"],
  " clusters the numbers based on their proximity."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(FindClusters[data]\),
      FormatType->StandardForm]], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{1.2`, 2.3`}, {9.1`, 15.4`}, {71.8`}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell["\<\
The rule-based data syntax allows for clustering data elements and returning \
labels for those elements.\
\>", "Text"],

Cell["\<\
Here two-dimensional points are clustered and labeled with their positions in \
the data list.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{\(data1 = {{1, \ 2}, \ {3, \ 7}, \ {0, \ 3}, \ {3, \ 
            1}}\ ;\), "\[IndentingNewLine]", 
    StyleBox[\(FindClusters[data1 -> \ Range[Length[data1]]]\),
      FormatType->StandardForm]}], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{1, 3, 4}, {2}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell["\<\
The rule-based data syntax can also be used to cluster data based on parts of \
each data entry. For instance, you might want to cluster data in a data table \
while ignoring particular columns in the table. \
\>", "Text"],

Cell["Here is a list of data entries.", "MathCaption"],

Cell[BoxData[
    \(\(datarecords = {{"\<Joe\>", \ "\<Smith\>", 158, 
            64.4}, {"\<Mary\>", \ "\<Davis\>", 137, 
            64.4}, {"\<Bob\>", \ "\<Lewis\>", 141, 
            62.8}, {"\<John\>", \ "\<Thompson\>", 235, 
            71.1}, {"\<Lewis\>", \ "\<Black\>", 225, 
            71.4}, {"\<Sally\>", \ "\<Jones\>", 168, 
            62. }, {"\<Tom\>", \ "\<Smith\>", 243, 
            70.9}, {"\<Jane\>", \ "\<Doe\>", 225, 71.4}};\)\)], "Input",
  CellLabel->"In[6]:="],

Cell["\<\
This clusters the data while ignoring the first two elements in each data \
entry.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindClusters[
      Drop[datarecords, None, {1, 2}] \[Rule] datarecords]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({{{"Joe", "Smith", 158, 64.4`}, {"Mary", "Davis", 137, 64.4`}, {"Bob", 
          "Lewis", 141, 62.8`}, {"Sally", "Jones", 168, 62.`}}, {{"John", 
          "Thompson", 235, 71.1`}, {"Lewis", "Black", 225, 71.4`}, {"Tom", 
          "Smith", 243, 70.9`}, {"Jane", "Doe", 225, 71.4`}}}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["\<\
In principle, it is possible to cluster points given in an arbitrary number \
of dimensions. However, it is difficult at best to visualize the clusters \
above two or three dimensions. For comparison of optional methods in this \
documentation, an easily visualizable set of two-dimensional data will be \
used.\
\>", "Text"],

Cell["\<\
The following commands define a set of 300 two-dimensional data points chosen \
to group in four somewhat nebulous clusters.\
\>", "MathCaption"],

Cell[BoxData[
    \(<< Statistics`ContinuousDistributions`\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[{
    \(\(GaussianRandomData[n_Integer, p_, sigma_] := 
        Table[\(p + {Re[#], Im[#]} &\)[
            Random[NormalDistribution[0, 
                  sigma]] \[ExponentialE]\^\(\[ImaginaryI]\ Random[Real, {0, \
2  \[Pi]}]\)], {n}];\)\), "\[IndentingNewLine]", 
    \(\(datapairs = 
        Block[{$RandomState, \ n\  = \ 100}, \[IndentingNewLine]SeedRandom[
            1234]; \[IndentingNewLine]Join[
            GaussianRandomData[n, {2, 1},  .3], 
            GaussianRandomData[n, {1, 1.5},  .2], 
            GaussianRandomData[n, {1, 1.1},  .4], 
            GaussianRandomData[n, {1.75, 1.75}, 0.1]]];\)\)}], "Input",
  CellLabel->"In[9]:="],

Cell["\<\
This defines a command that will display two-dimensional data with different \
colors for different clusters.\
\>", "MathCaption"],

Cell[BoxData[
    \(\(ClusterPlot[cl_, opts___] := 
        Module[{len, 
            colors\  = \ {Red, Blue, Green, Purple, 
                Cyan}}, \[IndentingNewLine]colors = 
            PadRight[colors, Length[cl], colors]; \[IndentingNewLine]Show[
            Graphics[{AbsolutePointSize[5], 
                Transpose[{colors, Map[Thread[Point /@ #] &, cl]}]}, opts, \ 
              Frame \[Rule] True]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[11]:="],

Cell["This clusters the data based on the proximity of points.", "MathCaption"],

Cell[BoxData[
    \(\(cl = FindClusters[datapairs];\)\)], "Input",
  CellLabel->"In[12]:="],

Cell["Here is a plot of the clusters.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[cl];\)\)], "Input",
  CellLabel->"In[13]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.74339 .20901 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.63111 .26316 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.76855 .29221 Mdot
.64184 .24847 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.68066 .3047 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.69671 .23691 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.66926 .24111 Mdot
.76788 .34998 Mdot
.61911 .30613 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.65701 .29945 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.67529 .26694 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.68588 .15456 Mdot
.71085 .30459 Mdot
.75343 .22417 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
.59365 .34236 Mdot
.58581 .26062 Mdot
0 0 1 r
.82053 .49726 Mdot
.76051 .41915 Mdot
.58727 .41465 Mdot
.81575 .4557 Mdot
.73644 .46735 Mdot
.55655 .53432 Mdot
.54869 .44925 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
0 1 0 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.50457 .41568 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.46226 .4736 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.45339 .47461 Mdot
.38991 .40728 Mdot
.12969 .4303 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.32957 .39806 Mdot
.21578 .40395 Mdot
.23747 .60332 Mdot
.44919 .45135 Mdot
.45596 .42689 Mdot
.43534 .37683 Mdot
.40259 .46445 Mdot
.39253 .39693 Mdot
.48314 .49626 Mdot
.44256 .43831 Mdot
.5 0 .5 r
.4277 .36836 Mdot
.23057 .38102 Mdot
.30997 .34212 Mdot
.36299 .33887 Mdot
.31611 .33914 Mdot
.50655 .33632 Mdot
.35128 .3572 Mdot
.35204 .29427 Mdot
.46924 .23893 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.41883 .25293 Mdot
.46806 .26461 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.51064 .25923 Mdot
.37319 .20988 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.3901 .21179 Mdot
.36788 .33111 Mdot
.43167 .32106 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.39434 .26552 Mdot
.32447 .30993 Mdot
.3944 .27361 Mdot
.30618 .37235 Mdot
.43209 .27502 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.39048 .33085 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.37563 .24168 Mdot
.39062 .3288 Mdot
.34568 .29468 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43464 .32716 Mdot
.38168 .28503 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.43823 .34941 Mdot
.3932 .32665 Mdot
.42653 .34969 Mdot
.38127 .3321 Mdot
.44956 .22897 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.37706 .28113 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.46494 .29543 Mdot
.48614 .12625 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.3757 .25456 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.38565 .12838 Mdot
.22581 .33042 Mdot
.43989 .34764 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30?l005X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@3o001I0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50?l005T0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0o`00FP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool307l0OaP0oooo0`1o07n60?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool507l0OaH0oooo1@1o07n50?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L0O`1o503oool507l0Oh@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P0O`1o4`3oool507l0OhD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L0O`1o503oool307l0OhH0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
O`1oW@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`1o07nN0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30?l00540oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@3o001?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30?l00540oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool307l0Oi@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool507l0Oi<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool507l0Oi@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D0O`1oL03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<0O`1oL03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`1o07mB0?ooo`<0
o`00;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<0O`1o
2P3oool507l0Oe00oooo1@3o000[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<0O`1o9`3oool507l0O`T0oooo1@1o07l>0?ooo`<0O`1o00@0
oooo07l0O`1o07l0O`1o>`3oool50?l001/0oooo0`3o000<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0O`1o9P3oool507l0O`T0oooo1@1o
07l=0?ooo`T0O`1o>P3oool50?l001X0oooo1@3o000;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0O`1o9P3oool507l0O`X0oooo0`1o07l>
0?ooo`T0O`1o>`3oool30?l001/0oooo1@3o000;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@1o07lW0?ooo`<0O`1o703oool907l0OeT0oooo1@3o000<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
O`1oB03oool307l0O`040?ooo`1o07l0O`1o07l0Oe/0oooo1P3o000E0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`1o07l@0?ooo`<0O`1oC@3oool50?l001D0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool507l0O`h0oooo
1@1o07m<0?ooo`L0o`005`3oool30?l00280oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`D0O`1o3P3oool507l0Oc80oooo0`3o00090?ooo`<0o`002`3oool80?l003/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0O`1o3P3oool507l0O`040?ooo`1o07l0
O`1o07l0Obd0oooo1@3o0000103oool0o`000?l0003o00030?ooo`D0o`002`3oool70?l003/0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0O`1o3`3oool307l0O`030?ooo`1o
07l0O`1o00<0O`1o;03oool:0?l00080oooo1@3o000=0?ooo`D0o`00>`3oool100000040oooo000E
0?ooo`030000003oool0oooo05h0oooo1P1o07lC0?ooo`D0O`1o:P3oool<0?l00080oooo1@3o0000
103oool0o`000?l0003o000:0?ooo`<0o`00?03oool100000040oooo000E0?ooo`800000A@3oool3
07l0OaL0oooo1P1o07l70?ooo`<0O`1o2@3oool507l0ObT0oooo1`3o00000`3oool0o`000?l00003
0?l000<0oooo0`3o00000`3oool0o`000?l000030?l000H0oooo0`3o00040?ooo`<0o`004@3oool3
0?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<0O`1o1@3oool707l0
Oa@0oooo1@1o07l70?ooo`D0O`1o2@3oool307l0ObX0oooo1@3o00040?ooo`<0o`00203oool50?l0
00D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`D0O`1o103oool807l0O`l0oooo0`1o07l20?ooo`D0O`1o1P3oool507l0Oa@0
oooo0`1o07lA0?ooo`<0o`00203oool80?l000l0oooo203o00020?ooo`D0o`000P3oool50?l000l0
oooo1@3o000S0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>P3oool507l0O`<0oooo
2@1o07l>0?ooo`D0O`1o00<0oooo07l0O`1o07l00`1o07l60?ooo`D0O`1o2@3oool307l0O`L0oooo
1@1o07l?0?ooo`D0o`001P3oool80?l00140oooo203o00000`3oool0o`000?l000040?l000030?oo
o`3o0000o`0000<0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0j0?ooo`D0O`1o0`3oool907l0O`h0oooo1@1o07l00`3oool0O`1o07l0O`0307l0O`040?ooo`1o
07l0O`1o07l0O`<0oooo0`1o07l90?ooo`D0O`1o1P3oool507l0O`l0oooo1@3o00060?ooo`H0o`00
203oool30?l000P0oooo203o00020?ooo`D0o`000P3oool30?l00140oooo0`3o000T0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>`3oool307l0O`@0oooo201o07l?0?ooo`D0O`1o0P3o
ool307l0O`030?ooo`1o07l0O`1o00<0O`1o0P3oool307l0O`T0oooo1@1o07l60?ooo`D0O`1o3`3o
ool50?l000H0oooo1P3o00070?ooo`D0o`00203oool70?l00080oooo1@3o00040?ooo`<0o`004`3o
ool30?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`130?ooo`<0O`1o503oool3
07l0O`L0oooo1@1o07l00`3oool0O`1o07l0O`0607l0O`D0oooo1@1o07l70?ooo`<0O`1o4@3oool3
0?l000P0oooo1@3o00070?ooo`D0o`002`3oool30?l000@0oooo0`3o00030?ooo`L0o`00403oool5
0?l001l0oooo0@0000010?ooo`005@3oool2000006D0oooo1@1o07l00`3oool0O`1o07l0O`0707l0
O`D0oooo0`1o07lX0?ooo`<0o`00203oool60?l000P0oooo0`3o00040?ooo`H0o`0000<0oooo0?l0
003o00001`3o000?0?ooo`D0o`007P3oool200000040oooo000E0?ooo`030000003oool0oooo0600
oooo0`1o07l00`3oool0O`1o07l0O`0307l0O`030?ooo`1o07l0O`1o00L0O`1o<@3oool30?l000P0
oooo1P3o00060?ooo`D0o`000P3ooolA0?l000h0oooo1P3o000O0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G`3oool:07l0O`80oooo201o07l`0?ooo`D0o`00203oool50?l000H0oooo
1@3o00020?oooa40o`003@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`T0O`1o1`3oool307l0Oc40oooo1@3o00080?ooo`D0o`001P3oool50?l00080oooo203o
00001@3oool0o`000?l0003o0000oooo00<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1H0?ooo`@0O`1o0`3oool807l0Oc`0oooo1@3o00090?ooo`<0o`001P3o
ool50?l000<0oooo2@3o00040?ooo`<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`1@0?ooo`<0O`1o103oool807l0O`030?ooo`1o07l0O`1o00H0O`1o3`3oool3
07l0ObX0oooo0`3o000C0?ooo`D0o`000`3oool:0?l00080oooo1@3o000>0?ooo`<0o`008P3oool1
00000040oooo000=0?ooo`D000000`3oool00`000000oooo0?ooo`1?0?ooo`D0O`1o0P3oool:07l0
O`030?ooo`1o07l0O`1o00P0O`1o2`3oool507l0Obl0oooo0`3o00080?ooo`<0o`000P3oool50?l0
00<0oooo2P3o00020?ooo`D0o`002`3oool30?l002D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo04l0oooo1@1o07l20?ooo`X0O`1o0P3oool:07l0O`X0
oooo1@1o07lU0?ooo`<0o`001P3oool50?l000<0oooo3@3o00030?ooo`/0o`000P3oool50?l000X0
oooo1P3o000S0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool200000500oooo
1P1o07l00`3oool0O`1o07l0O`0807l0O`030?ooo`1o07l0O`1o00T0O`1o2P3oool507l0Ob@0oooo
1@3o00050?ooo`D0o`000P3oool?0?l00080oooo2P3o00040?ooo`<0o`002`3oool70?l00240oooo
0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo0`1o
07lo0?ooo`H0O`1o00@0oooo07l0O`1o07l0O`1o0P3oool307l0O`80oooo2`1o07l80?ooo`H0O`1o
9@3oool50?l000D0oooo1@3o00020?ooo`l0o`000P3oool90?l000P0oooo0`3o00080?ooo`L0o`00
8P3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3o
ool507l0OcH0oooo0`1o07l40?ooo`L0O`1o2`3oool:07l0O`P0oooo1@1o07lW0?ooo`D0o`001P3o
ool30?l00080oooo403o00030?ooo`T0o`001P3oool50?l000@0oooo0`3o00000`3oool0o`000?l0
00040?l00280oooo0@0000010?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool03@3oool5
07l0OcD0oooo1@1o07l20?ooo`P0O`1o00@0oooo07l0O`1o07l0O`1o0P3oool:07l0O`P0oooo0`1o
07l20?ooo`D0O`1o:03oool30?l000040?ooo`3o0000o`000?l000L0oooo403o00040?ooo`X0o`00
1@3oool50?l000<0oooo1@3o00020?ooo`<0o`008`3oool100000040oooo000E0?ooo`030000003o
ool0oooo00d0oooo1@1o07le0?ooo`D0O`1o0P3oool707l0O`030?ooo`1o07l0O`1o0140O`1o103o
ool507l0O`030?ooo`1o07l0O`1o00<0O`1o:`3oool50?l000H0oooo3@3o00060?ooo`D0o`0000<0
oooo0?l0003o00000`3o00050?ooo`D0o`000`3oool50?l002P0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0>0?ooo`<0O`1o=P3oool507l0O`80oooo1@1o07l30?oooa@0O`1o0`3oool5
07l0O`80oooo0`1o07l/0?ooo`H0o`001@3oool=0?l000H0oooo1@3o00000`3oool0o`000?l00003
0?l000H0oooo0`3o00040?ooo`D0o`00:03oool100000040oooo000E0?ooo`030000003oool0oooo
03P0oooo0`1o07l=0?ooo`<0O`1o103oool307l0O`@0oooo501o07l30?ooo`H0O`1o<03oool60?l0
00H0oooo0`3o00020?ooo`L0o`001P3oool:0?l000l0oooo0`3o000Y0?ooo`4000000@3oool001D0
oooo0P00000h0?ooo`D0O`1o6`3oool307l0O`80oooo3P1o07l40?ooo`D0O`1o0`3oool307l0O`T0
oooo0`1o07lO0?ooo`D0o`003P3oool30?l000P0oooo0`3o00000`3oool0o`000?l000030?l000L0
oooo0`3o000`0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0=`3oool507l0Oa@0oooo
0`1o07l80?ooo`l0O`1o0`3oool607l0O`80oooo1@1o07l70?ooo`D0O`1o7`3oool30?l001d0oooo
1P3o00020?ooo`<0o`0000<0oooo0?l0003o00000`3o000`0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=`3oool507l0Oa80oooo1P1o07l60?oooa00O`1o0P3oool607l0O`<0oooo1@1o
07l70?ooo`D0O`1o4`3oool30?l002T0oooo1@3o00020?ooo`X0o`002`3oool40?l00240oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`<0O`1o2P3oool307l0O`D0oooo1`1o07l6
0?oooa00O`1o0P3oool807l0O`030?ooo`1o07l0O`1o00<0O`1o1`3oool507l0Oa80oooo1@3o000X
0?ooo`D0o`000P3oool:0?l000X0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0@P3oool707l0O`@0oooo1`1o07l20?ooo`<0O`1o00<0oooo07l0O`1o07l0101o07l01@3o
ool0O`1o07l0O`1o07l0oooo00D0O`1o0P3oool907l0O`040?ooo`1o07l0O`1o07l0O`T0oooo0`1o
07lC0?ooo`D0o`00:@3oool50?l000030?ooo`3o0000o`0000<0o`0000@0oooo0?l0003o0000o`00
2`3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`110?ooo`P0O`1o103o
ool607l0O`80oooo1@1o07l00`3oool0O`1o07l0O`0207l0O`050?ooo`1o07l0O`1o07l0O`3oool0
1@1o07l30?ooo`T0O`1o8`3oool50?l001T0oooo0`3o000>0?ooo`D0o`0000@0oooo0?l0003o0000
o`00203oool30?l000D0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
@@3oool807l0O`D0oooo0`1o07l40?ooo`L0O`1o0`3oool:07l0O`<0oooo2@1o07lB0?ooo`<0O`1o
3`3oool30?l000/0oooo0`3o000;0?ooo`P0o`000`3oool30?l000@0oooo1@3o00000`3oool0o`00
0?l000030?l000D0oooo1@3o00050?ooo`@0o`008@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0440oooo1`1o07l=0?ooo`P0O`1o0P3oool:07l0O`<0oooo201o07lB0?ooo`D0O`1o6`3o
ool50?l000X0oooo2@3o00000`3oool0o`000?l000050?l000030?ooo`3o0000o`0000X0o`00103o
ool50?l000H0oooo0`3o000Q0?ooo`4000000@3oool001D0oooo0P0000130?ooo`<0O`1o4@3oool7
07l0O`80oooo2@1o07l50?ooo`H0O`1o4`3oool507l0Oa/0oooo1@3o00020?ooo`<0o`0000D0oooo
0?l0003o0000o`000?ooo`090?l000030?ooo`3o0000o`0000H0o`0000D0oooo0?l0003o0000o`00
0?ooo`070?l000@0oooo1@3o00050?ooo`D0o`007`3oool200000040oooo000E0?ooo`030000003o
ool0oooo05P0oooo1@1o07l30?ooo`H0O`1o1`3oool307l0OaH0oooo1@1o07lK0?ooo`D0o`0000<0
oooo0?l0003o00001`3o00000`3oool0o`000?l000060?l000030?ooo`3o0000o`0000H0o`001@3o
ool70?l000D0oooo0`3o00060?ooo`D0o`00803oool100000040oooo000E0?ooo`030000003oool0
oooo04d0oooo0`1o07l90?ooo`<0O`1o0`3oool607l0O`L0oooo1@1o07lF0?ooo`<0O`1o7@3oool3
0?l00080oooo303o00020?ooo`<0o`000`3oool70?l000H0oooo1@3o000?0?ooo`P0o`007@3oool1
00000040oooo000E0?ooo`030000003oool0oooo04`0oooo1@1o07l>0?ooo`D0O`1o203oool507l0
O`<00?l0>03oool=0?l000X0oooo1@3o000J0?ooo`P0o`00703oool100000040oooo000E0?ooo`03
0000003oool0oooo03T0oooo0`1o07l@0?ooo`D0O`1o3P3oool507l0O`P0oooo1@1o07l4003o03P0
oooo0`3o00000`3oool0o`000?l000060?l000X0oooo1@3o000E0?ooo`<0o`001@3oool50?l001`0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`D0O`1o3`3oool507l0O`l0oooo
0`1o07l2003o00P0oooo0`1o07l5003o03l0oooo1@3o000:0?ooo`D0o`002@3oool30?l000P0oooo
1@3o00040?ooo`D0o`00703oool100000040oooo000E0?ooo`030000003oool0oooo03P0oooo1@1o
07l@0?ooo`<0O`1o4@3oool5003o00P0oooo2000o`0o0?ooo`<0o`00303oool30?l000T0oooo1@3o
00070?ooo`D0o`001@3oool30?l001d0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h
0?ooo`D0O`1o2`3oool3003o01H0oooo1@00o`090?ooo`P00?l0A@3oool30?l00140oooo1@3o0007
0?ooo`D0o`009@3oool100000040oooo000E0?ooo`800000>P3oool307l0O`/0oooo1@00o`0E0?oo
o`D00?l01`3oool3003o0080oooo1@00o`140?ooo`D0o`00403oool50?l000P0oooo0`3o000U0?oo
o`8000000@3oool001D0oooo00<000000?ooo`3oool0A`3oool5003o00L0oooo0`00o`00103oool0
0?l0003o0000o`080?ooo`D00?l01@3oool5003o00030?ooo`00o`000?l000<00?l0A03oool50?l0
0140oooo0`3o000b0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0=@3oool3003o00l0
oooo1@00o`060?ooo`T00?l01`3oool6003o00@0oooo1@00o`020?ooo`<00?l0A@3oool50?l004H0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0d0?ooo`D00?l03`3oool3003o00L0oooo
2@00o`070?ooo`P00?l00P3oool5003o04/0oooo0`3o00170?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=03oool5003o01T0oooo2@00o`070?ooo`T00?l00P3oool3003o00040?ooo`00
o`000?l0003o0980oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0d0?ooo`D00?l06P3o
ool3003o00040?ooo`00o`000?l0003o00P0oooo2@00o`030?ooo`L00?l08`3oool30000oc<0oooo
0`3o000e0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0=03oool5003o00040?ooo`00
o`000?l0003o02<0oooo2`00o`020?ooo`P00?l000@0oooo003o0000o`000?l02@3oool3003o0180
oooo1@000?l50?ooo`<0003o8P3oool30000o`@0oooo1@3o000d0?ooo`4000000@3oool001D0oooo
0P00000f0?ooo`<00?l000<0oooo003o0000o`000`00o`0Q0?ooo`L00?l000D0oooo003o0000o`00
0?l00?ooo`0?003o00L0oooo1@00o`0A0?ooo`D0003o103oool50000ob00oooo1@000?l30?ooo`D0
o`00<`3oool200000040oooo000E0?ooo`030000003oool0oooo03T0oooo1@00o`0Q0?ooo`L00?l0
0P3oool<003o00030?ooo`00o`000?l000<00?l01`3oool5003o0140oooo1@000?l40?ooo`D0003o
803oool50000o`<0oooo1@3o000d0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07P3o
ool3003o01P0oooo1@00o`0Q0?oooa800?l00`3oool6003o00L0oooo1@00o`0B0?ooo`<0003o1@3o
ool50000ob00oooo1@000?l40?ooo`<0o`00;P3oool30?l000@0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0M0?ooo`D00?l0603oool3003o00d0oooo0`00o`0B0?oooa400?l0103oool5
003o00T0oooo0`00o`0L0?ooo`<0003o2@3oool30000oaH0oooo0`000?le0?ooo`D0o`000`3oool1
00000040oooo000E0?ooo`030000003oool0oooo01d0oooo1@00o`0T0?ooo`P00?l04P3ooolA003o
0080oooo1P00o`0c0?ooo`D0003oC@3oool50?l000<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0M0?ooo`D00?l08`3oool9003o00050?ooo`00o`000?l0003o003oool00`00o`0:0?oo
oaP00?l0=03oool50000odd0oooo1@3o00030?ooo`4000000@3oool000030?ooo`000000000000<0
00000P3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo01h0oooo0`00o`0T0?oooa80
0?l01`3ooolI003o03D0oooo1@000?m>0?ooo`<0o`00103oool100000040oooo00030?ooo`030000
003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`150?oooaD0
0?l00`3ooolJ003o01L0oooo0`000?lK0?ooo`D0003oE@3oool100000040oooo00030?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool2000004L0oooo0`00o`000`3oool00?l0
003o000Q003o00030?ooo`00o`000?l000H00?l00`3oool3003o0140oooo1@000?lJ0?ooo`D0003o
E03oool200000040oooo00030?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000003o
ool0oooo04/0oooo1`00o`000`3oool00?l0003o000H003o00@0oooo1P00o`000`3oool00?l0003o
0003003o0100oooo1@000?lK0?ooo`<0003o903oool30000obl0oooo0@0000010?ooo`000`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0BP3oool6
003o00H0oooo5`00o`050?ooo`D00?l000<0oooo003o0000o`000`00o`0@0?ooo`D0003o@@3oool5
0000obh0oooo0@0000010?ooo`000P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo
04X0oooo1P00o`070?oooaD00?l01@3oool6003o00030?ooo`00o`000?l000<00?l04@3oool30000
oa40oooo0`000?l^0?ooo`D0003o;P3oool100000040oooo000E0?ooo`030000003oool0oooo04P0
oooo1`00o`090?ooo`H00?l00P3oool;003o00D0oooo1P00o`030?ooo`<00?l09@3oool50000oaT0
oooo0`000?lA0?ooo`D0003o;P3oool100000040oooo000E0?ooo`030000003oool0oooo04L0oooo
1`00o`0:0?ooo`D00?l0103oool;003o00@0oooo1@00o`0/0?ooo`D0003o603oool50000oa40oooo
0`000?l_0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0A`3oool5003o00`0oooo1@00
o`040?ooo`d00?l00P3oool:003o02L0oooo1@000?l;0?ooo`<0003o2P3oool50000od<0oooo0@00
00010?ooo`005@3oool2000004P0oooo1@00o`0<0?ooo`D00?l00P3oool@003o00030?ooo`00o`00
0?l000T00?l09`3oool30000o`/0oooo1@000?l90?ooo`D0003o@P3oool200000040oooo000E0?oo
o`030000003oool0oooo04P0oooo0`00o`0>0?ooo`<00?l00P3oool9003o00030?ooo`00o`000?l0
00D00?l000<0oooo003o0000o`002@00o`0e0?ooo`D0003o2P3oool30000od@0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`1M0?ooo`T00?l00`3ooolB003o02P0oooo0`000?l30?ooo`<0
003o103oool50000oe40oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1M0?ooo`H00?l0
203oool?003o02P0oooo2`000?l30?ooo`D0003o00@0oooo0000o`000?l0003oC@3oool100000040
oooo000E0?ooo`030000003oool0oooo05d0oooo1@00o`0<0?ooo`/00?l0:@3oool;0000o`030?oo
o`000?l0003o00X0003oC03oool100000040oooo000E0?ooo`030000003oool0oooo05h0oooo0`00
o`0=0?ooo`/00?l00`3oool3003o0200oooo6`000?lL0?ooo`<0003o;@3oool100000040oooo000E
0?ooo`030000003oool0oooo05`0oooo0`00o`0@0?ooo`<00?l000<0oooo003o0000o`001000o`02
0?ooo`D00?l07P3oool>0000o`030?ooo`000?l0003o00/0003o6`3oool50000ob`0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`1K0?ooo`D00?l0103oool3003o00`0oooo1@00o`030?oo
o`D00?l0703ooolM0000oa`0oooo1@000?l/0?ooo`4000000@3oool001D0oooo0P00001L0?ooo`L0
0?l000<0oooo003o0000o`000`00o`0<0?ooo`<00?l0103oool5003o01/0oooo70000?lN0?ooo`D0
003o:`3oool200000040oooo000E0?ooo`030000003oool0oooo05/0oooo3@00o`0D0?ooo`<00?l0
703oool90000o`030?ooo`000?l0003o0100003o7`3oool30000obd0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1L0?ooo``00?l0<`3ooolL0000o`H0oooo0`000?m60?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0GP3oool5003o00040?ooo`00o`000?l0003o00d0oooo0`00
o`0U0?oooa/0003o1@3oool50000odD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1M
0?ooo`D00?l04@3oool5003o02D0oooo0`000?l00`3oool0003o0000o`0D0000o`D0oooo1P000?m4
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G03oool5003o0180oooo1@00o`0Y0?oo
oaD0003o1P3oool70000od<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L0?ooo`D0
0?l04P3oool5003o02P0oooo5P000?l70?ooo`H0003o@`3oool100000040oooo000E0?ooo`800000
G@3oool7003o0140oooo0`00o`0I0?ooo`<0003o3@3ooolF0000o`P0oooo1@000?m20?ooo`800000
0@3oool001D0oooo00<000000?ooo`3oool0@P3oool3003o01P0oooo1`00o`0[0?ooo`D0003o303o
oolE0000o`X0oooo0`000?m40?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0@@3oool5
003o01T0oooo1P00o`0Z0?ooo`D0003o3@3ooolC0000o`030?ooo`000?l0003o00@0003oB`3oool1
00000040oooo000E0?ooo`030000003oool0oooo0440oooo1@00o`0I0?ooo`H00?l0:P3oool50000
o`l0oooo1`000?l00`3oool0003o0000o`060000o`030?ooo`000?l0003o00H0003oBP3oool10000
0040oooo000E0?ooo`030000003oool0oooo0440oooo1@00o`0J0?ooo`D00?l0:`3oool30000oa00
oooo20000?l20?ooo`H0003o00<0oooo0000o`000?l01P000?m:0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0@P3oool3003o01`0oooo0`00o`100?ooo`P0003o0P3oool50000o`030?oo
o`000?l0003o00H0003oBP3oool100000040oooo000E0?ooo`030000003oool0oooo0:L0oooo1@00
0?l20?ooo`D0003o0P3oool60000od/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2W
0?ooo`D0003o0P3oool50000oe<0oooo0@0000010?ooo`005@3oool2000009X0oooo1P000?l90?oo
o`@0003o0P3oool50000oe80oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`2H0?ooo`P0
003o203oool50000o`80oooo0`000?mD0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
V03oool80000o`P0oooo1@000?mI0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0V03o
ool80000o`P0oooo1@000?mI0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0V@3oool6
0000o`X0oooo0`000?mJ0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?oo
o`4000000@3oool000d0oooo100000040?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3oool70?ooo`400000
0@3oool000h0oooo00<000000?ooo`3oool0103oool200000;L0oooo0`000?m<0?ooo`8000000@3o
ool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2e0?ooo`D0003oC03oool1
00000040oooo000=0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0>`3oool3
003o07L0oooo1@000?m<0?ooo`4000000@3oool000h0oooo0P0000050?ooo`030000003oool0oooo
03X0oooo1@00o`1f0?ooo`D0003oC03oool100000040oooo000E0?ooo`030000003oool0oooo03X0
oooo1@00o`1g0?ooo`<0003oC@3oool100000040oooo000E0?ooo`030000003oool0oooo03X0oooo
1@00o`370?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>`3oool3003o0<P0oooo0@00
00010?ooo`005@3oool2000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0080oooo0P0000010?ooo`005@3ooooo000000/000000@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell[TextData[{
  "With the default settings, ",
  StyleBox["FindClusters", "MR"],
  " has found the four clusters of points."
}], "Text"],

Cell[TextData[{
  "You can also direct ",
  StyleBox["FindClusters", "MR"],
  " to find a specific number of clusters."
}], "Text"],

Cell["This shows the effect of choosing 3 clusters.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[FindClusters[datapairs, 3]];\)\)], "Input",
  CellLabel->"In[14]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.74339 .20901 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.63111 .26316 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.76855 .29221 Mdot
.64184 .24847 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.68066 .3047 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.69671 .23691 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.66926 .24111 Mdot
.76788 .34998 Mdot
.61911 .30613 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.65701 .29945 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.67529 .26694 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.68588 .15456 Mdot
.71085 .30459 Mdot
.75343 .22417 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
.59365 .34236 Mdot
.48614 .12625 Mdot
.58581 .26062 Mdot
0 0 1 r
.82053 .49726 Mdot
.76051 .41915 Mdot
.58727 .41465 Mdot
.81575 .4557 Mdot
.73644 .46735 Mdot
.55655 .53432 Mdot
.54869 .44925 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
0 1 0 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.4277 .36836 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.23057 .38102 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.50457 .41568 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.30997 .34212 Mdot
.46226 .4736 Mdot
.36299 .33887 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.31611 .33914 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.50655 .33632 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.35128 .3572 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.35204 .29427 Mdot
.45339 .47461 Mdot
.46924 .23893 Mdot
.38991 .40728 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.41883 .25293 Mdot
.12969 .4303 Mdot
.46806 .26461 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.51064 .25923 Mdot
.37319 .20988 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.3901 .21179 Mdot
.36788 .33111 Mdot
.43167 .32106 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.39434 .26552 Mdot
.32447 .30993 Mdot
.3944 .27361 Mdot
.30618 .37235 Mdot
.43209 .27502 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.39048 .33085 Mdot
.32957 .39806 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.21578 .40395 Mdot
.37563 .24168 Mdot
.23747 .60332 Mdot
.39062 .3288 Mdot
.44919 .45135 Mdot
.34568 .29468 Mdot
.45596 .42689 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43464 .32716 Mdot
.43534 .37683 Mdot
.38168 .28503 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.43823 .34941 Mdot
.40259 .46445 Mdot
.3932 .32665 Mdot
.42653 .34969 Mdot
.38127 .3321 Mdot
.44956 .22897 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.37706 .28113 Mdot
.39253 .39693 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.46494 .29543 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.3757 .25456 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.48314 .49626 Mdot
.38565 .12838 Mdot
.22581 .33042 Mdot
.43989 .34764 Mdot
.44256 .43831 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[14]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30?l005X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@3o001I0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50?l005T0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0o`00FP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool3003o01P0oooo0`3o00260?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool5003o01H0oooo1@3o00250?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L00?l0503oool50?l008@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P00?l04`3oool50?l008D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L00?l0503oool30?l008H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
0?l0W@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`00o`2N0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30?l00540oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@3o001?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30?l00540oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool3003o09@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool5003o09<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool5003o09@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D00?l0L03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<00?l0L03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`00o`1B0?ooo`<0
o`00;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<00?l0
2P3oool5003o0500oooo1@3o000[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<00?l09`3oool5003o00T0oooo1@00o`0>0?ooo`<00?l000@0
oooo003o0000o`000?l0>`3oool50?l001/0oooo0`3o000<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?l09P3oool5003o00T0oooo1@00
o`0=0?ooo`T00?l0>P3oool50?l001X0oooo1@3o000;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?l09P3oool5003o00X0oooo0`00o`0>
0?ooo`T00?l0>`3oool30?l001/0oooo1@3o000;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@00o`0W0?ooo`<00?l0703oool9003o05T0oooo1@3o000<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
0?l0B03oool3003o00040?ooo`00o`000?l0003o05/0oooo1P3o000E0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`00o`0@0?ooo`<00?l0C@3oool50?l001D0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool5003o00h0oooo
1@00o`1<0?ooo`L0o`005`3oool30?l00280oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`D00?l03P3oool5003o0380oooo0`3o00090?ooo`<0o`002`3oool80?l003/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D00?l03P3oool5003o00040?ooo`00o`00
0?l0003o02d0oooo1@3o0000103oool0o`000?l0003o00030?ooo`D0o`002`3oool70?l003/0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D00?l03`3oool3003o00030?ooo`00
o`000?l000<00?l0;03oool:0?l00080oooo1@3o000=0?ooo`D0o`00>`3oool100000040oooo000E
0?ooo`030000003oool0oooo05h0oooo1P00o`0C0?ooo`D00?l0:P3oool<0?l00080oooo1@3o0000
103oool0o`000?l0003o000:0?ooo`<0o`00?03oool100000040oooo000E0?ooo`800000A@3oool3
003o01L0oooo1P00o`070?ooo`<00?l02@3oool5003o02T0oooo1`3o00000`3oool0o`000?l00003
0?l000<0oooo0`3o00000`3oool0o`000?l000030?l000H0oooo0`3o00040?ooo`<0o`004@3oool3
0?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<00?l01@3oool7003o
01@0oooo1@00o`070?ooo`D00?l02@3oool3003o02X0oooo1@3o00040?ooo`<0o`00203oool50?l0
00D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`D00?l0103oool8003o00l0oooo0`00o`020?ooo`D00?l01P3oool5003o01@0
oooo0`00o`0A0?ooo`<0o`00203oool80?l000l0oooo203o00020?ooo`D0o`000P3oool50?l000l0
oooo1@3o000S0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>P3oool5003o00<0oooo
2@00o`0>0?ooo`D00?l000<0oooo003o0000o`000`00o`060?ooo`D00?l02@3oool3003o00L0oooo
1@00o`0?0?ooo`D0o`001P3oool80?l00140oooo203o00000`3oool0o`000?l000040?l000030?oo
o`3o0000o`0000<0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0j0?ooo`D00?l00`3oool9003o00h0oooo1@00o`000`3oool00?l0003o0003003o00040?ooo`00
o`000?l0003o00<0oooo0`00o`090?ooo`D00?l01P3oool5003o00l0oooo1@3o00060?ooo`H0o`00
203oool30?l000P0oooo203o00020?ooo`D0o`000P3oool30?l00140oooo0`3o000T0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>`3oool3003o00@0oooo2000o`0?0?ooo`D00?l00P3o
ool3003o00030?ooo`00o`000?l000<00?l00P3oool3003o00T0oooo1@00o`060?ooo`D00?l03`3o
ool50?l000H0oooo1P3o00070?ooo`D0o`00203oool70?l00080oooo1@3o00040?ooo`<0o`004`3o
ool30?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`130?ooo`<00?l0503oool3
003o00L0oooo1@00o`000`3oool00?l0003o0006003o00D0oooo1@00o`070?ooo`<00?l04@3oool3
0?l000P0oooo1@3o00070?ooo`D0o`002`3oool30?l000@0oooo0`3o00030?ooo`L0o`00403oool5
0?l001l0oooo0@0000010?ooo`005@3oool2000006D0oooo1@00o`000`3oool00?l0003o0007003o
00D0oooo0`00o`0X0?ooo`<0o`00203oool60?l000P0oooo0`3o00040?ooo`H0o`0000<0oooo0?l0
003o00001`3o000?0?ooo`D0o`007P3oool200000040oooo000E0?ooo`030000003oool0oooo0600
oooo0`00o`000`3oool00?l0003o0003003o00030?ooo`00o`000?l000L00?l0<@3oool30?l000P0
oooo1P3o00060?ooo`D0o`000P3ooolA0?l000h0oooo1P3o000O0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G`3oool:003o0080oooo2000o`0`0?ooo`D0o`00203oool50?l000H0oooo
1@3o00020?oooa40o`003@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`T00?l01`3oool3003o0340oooo1@3o00080?ooo`D0o`001P3oool50?l00080oooo203o
00001@3oool0o`000?l0003o0000oooo00<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1H0?ooo`@00?l00`3oool8003o03`0oooo1@3o00090?ooo`<0o`001P3o
ool50?l000<0oooo2@3o00040?ooo`<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`1@0?ooo`<00?l0103oool8003o00030?ooo`00o`000?l000H00?l03`3oool3
003o02X0oooo0`3o000C0?ooo`D0o`000`3oool:0?l00080oooo1@3o000>0?ooo`<0o`008P3oool1
00000040oooo000=0?ooo`D000000`3oool00`000000oooo0?ooo`1?0?ooo`D00?l00P3oool:003o
00030?ooo`00o`000?l000P00?l02`3oool5003o02l0oooo0`3o00080?ooo`<0o`000P3oool50?l0
00<0oooo2P3o00020?ooo`D0o`002`3oool30?l002D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo04l0oooo1@00o`020?ooo`X00?l00P3oool:003o00X0
oooo1@00o`0U0?ooo`<0o`001P3oool50?l000<0oooo3@3o00030?ooo`/0o`000P3oool50?l000X0
oooo1P3o000S0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool200000500oooo
1P00o`000`3oool00?l0003o0008003o00030?ooo`00o`000?l000T00?l02P3oool5003o02@0oooo
1@3o00050?ooo`D0o`000P3oool?0?l00080oooo2P3o00040?ooo`<0o`002`3oool70?l00240oooo
0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo0`00
o`0o0?ooo`H00?l000@0oooo003o0000o`000?l00P3oool3003o0080oooo2`00o`080?ooo`H00?l0
9@3oool50?l000D0oooo1@3o00020?ooo`l0o`000P3oool90?l000P0oooo0`3o00080?ooo`L0o`00
8P3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3o
ool5003o03H0oooo0`00o`040?ooo`L00?l02`3oool:003o00P0oooo1@00o`0W0?ooo`D0o`001P3o
ool30?l00080oooo403o00030?ooo`T0o`001P3oool50?l000@0oooo0`3o00000`3oool0o`000?l0
00040?l00280oooo0@0000010?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool03@3oool5
003o03D0oooo1@00o`020?ooo`P00?l000@0oooo003o0000o`000?l00P3oool:003o00P0oooo0`00
o`020?ooo`D00?l0:03oool30?l000040?ooo`3o0000o`000?l000L0oooo403o00040?ooo`X0o`00
1@3oool50?l000<0oooo1@3o00020?ooo`<0o`008`3oool100000040oooo000E0?ooo`030000003o
ool0oooo00d0oooo1@00o`0e0?ooo`D00?l00P3oool7003o00030?ooo`00o`000?l001400?l0103o
ool5003o00030?ooo`00o`000?l000<00?l0:`3oool50?l000H0oooo3@3o00060?ooo`D0o`0000<0
oooo0?l0003o00000`3o00050?ooo`D0o`000`3oool50?l002P0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0>0?ooo`<00?l0=P3oool5003o0080oooo1@00o`030?oooa@00?l00`3oool5
003o0080oooo0`00o`0/0?ooo`H0o`001@3oool=0?l000H0oooo1@3o00000`3oool0o`000?l00003
0?l000H0oooo0`3o00040?ooo`D0o`00:03oool100000040oooo000E0?ooo`030000003oool0oooo
03P0oooo0`00o`0=0?ooo`<00?l0103oool3003o00@0oooo5000o`030?ooo`H00?l0<03oool60?l0
00H0oooo0`3o00020?ooo`L0o`001P3oool:0?l000l0oooo0`3o000Y0?ooo`4000000@3oool001D0
oooo0P00000h0?ooo`D00?l06`3oool3003o0080oooo3P00o`040?ooo`D00?l00`3oool3003o00T0
oooo0`00o`0O0?ooo`D0o`003P3oool30?l000P0oooo0`3o00000`3oool0o`000?l000030?l000L0
oooo0`3o000`0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0=`3oool5003o01@0oooo
0`00o`080?ooo`l00?l00`3oool6003o0080oooo1@00o`070?ooo`D00?l07`3oool30?l001d0oooo
1P3o00020?ooo`<0o`0000<0oooo0?l0003o00000`3o000`0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=`3oool5003o0180oooo1P00o`060?oooa000?l00P3oool6003o00<0oooo1@00
o`070?ooo`D00?l04`3oool30?l002T0oooo1@3o00020?ooo`X0o`002`3oool40?l00240oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`<00?l02P3oool3003o00D0oooo1`00o`06
0?oooa000?l00P3oool8003o00030?ooo`00o`000?l000<00?l01`3oool5003o0180oooo1@3o000X
0?ooo`D0o`000P3oool:0?l000X0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0@P3oool7003o00@0oooo1`00o`020?ooo`<00?l000<0oooo003o0000o`001000o`001@3o
ool00?l0003o0000o`00oooo00D00?l00P3oool9003o00040?ooo`00o`000?l0003o00T0oooo0`00
o`0C0?ooo`D0o`00:@3oool50?l000030?ooo`3o0000o`0000<0o`0000@0oooo0?l0003o0000o`00
2`3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`110?ooo`P00?l0103o
ool6003o0080oooo1@00o`000`3oool00?l0003o0002003o00050?ooo`00o`000?l0003o003oool0
1@00o`030?ooo`T00?l08`3oool50?l001T0oooo0`3o000>0?ooo`D0o`0000@0oooo0?l0003o0000
o`00203oool30?l000D0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
@@3oool8003o00D0oooo0`00o`040?ooo`L00?l00`3oool:003o00<0oooo2@00o`0B0?ooo`<00?l0
3`3oool30?l000/0oooo0`3o000;0?ooo`P0o`000`3oool30?l000@0oooo1@3o00000`3oool0o`00
0?l000030?l000D0oooo1@3o00050?ooo`@0o`008@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0440oooo1`00o`0=0?ooo`P00?l00P3oool:003o00<0oooo2000o`0B0?ooo`D00?l06`3o
ool50?l000X0oooo2@3o00000`3oool0o`000?l000050?l000030?ooo`3o0000o`0000X0o`00103o
ool50?l000H0oooo0`3o000Q0?ooo`4000000@3oool001D0oooo0P0000130?ooo`<00?l04@3oool7
003o0080oooo2@00o`050?ooo`H00?l04`3oool5003o01/0oooo1@3o00020?ooo`<0o`0000D0oooo
0?l0003o0000o`000?ooo`090?l000030?ooo`3o0000o`0000H0o`0000D0oooo0?l0003o0000o`00
0?ooo`070?l000@0oooo1@3o00050?ooo`D0o`007`3oool200000040oooo000E0?ooo`030000003o
ool0oooo05P0oooo1@00o`030?ooo`H00?l01`3oool3003o01H0oooo1@00o`0K0?ooo`D0o`0000<0
oooo0?l0003o00001`3o00000`3oool0o`000?l000060?l000030?ooo`3o0000o`0000H0o`001@3o
ool70?l000D0oooo0`3o00060?ooo`D0o`00803oool100000040oooo000E0?ooo`030000003oool0
oooo04d0oooo0`00o`090?ooo`<00?l00`3oool6003o00L0oooo1@00o`0F0?ooo`<00?l07@3oool3
0?l00080oooo303o00020?ooo`<0o`000`3oool70?l000H0oooo1@3o000?0?ooo`P0o`007@3oool1
00000040oooo000E0?ooo`030000003oool0oooo04`0oooo1@00o`0>0?ooo`D00?l0203oool8003o
03P0oooo3@3o000:0?ooo`D0o`006P3oool80?l001`0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0i0?ooo`<00?l0403oool5003o00h0oooo1@00o`080?ooo`T00?l0>03oool30?l00003
0?ooo`3o0000o`0000H0o`002P3oool50?l001D0oooo0`3o00050?ooo`D0o`00703oool100000040
oooo000E0?ooo`030000003oool0oooo03P0oooo1@00o`0?0?ooo`D00?l03`3oool5003o00P0oooo
2000o`0o0?ooo`D0o`002P3oool50?l000T0oooo0`3o00080?ooo`D0o`00103oool50?l001`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`D00?l0403oool3003o0140oooo1@00
o`080?ooo`P00?l0?`3oool30?l000`0oooo0`3o00090?ooo`D0o`001`3oool50?l000D0oooo0`3o
000M0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>03oool5003o00/0oooo0`00o`0F
0?ooo`D00?l02@3oool8003o04D0oooo0`3o000A0?ooo`D0o`001`3oool50?l002D0oooo0@000001
0?ooo`005@3oool2000003X0oooo0`00o`0;0?ooo`D00?l05@3oool5003o00L0oooo0`00o`020?oo
o`D00?l0A03oool50?l00100oooo1@3o00080?ooo`<0o`009@3oool200000040oooo000E0?ooo`03
0000003oool0oooo04L0oooo1@00o`070?ooo`<00?l000@0oooo003o0000o`000?l0203oool5003o
00D0oooo1@00o`000`3oool00?l0003o0003003o04@0oooo1@3o000A0?ooo`<0o`00<P3oool10000
0040oooo000E0?ooo`030000003oool0oooo03D0oooo0`00o`0?0?ooo`D00?l01P3oool9003o00L0
oooo1P00o`040?ooo`D00?l00P3oool3003o04D0oooo1@3o00160?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0=03oool5003o00l0oooo0`00o`070?ooo`T00?l01`3oool8003o0080oooo
1@00o`1;0?ooo`<0o`00A`3oool100000040oooo000E0?ooo`030000003oool0oooo03@0oooo1@00
o`0I0?ooo`T00?l01`3oool9003o0080oooo0`00o`00103oool00?l0003o0000o`2B0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0=03oool5003o01X0oooo0`00o`00103oool00?l0003o
0000o`080?ooo`T00?l00`3oool7003o02<0oooo0`000?lc0?ooo`<0o`00=@3oool100000040oooo
000E0?ooo`030000003oool0oooo03@0oooo1@00o`00103oool00?l0003o0000o`0S0?ooo`/00?l0
0P3oool8003o00040?ooo`00o`000?l0003o00T0oooo0`00o`0B0?ooo`D0003o1@3oool30000ob80
oooo0`000?l40?ooo`D0o`00=03oool100000040oooo000E0?ooo`800000=P3oool3003o00030?oo
o`00o`000?l000<00?l08@3oool7003o00050?ooo`00o`000?l0003o003oool03`00o`070?ooo`D0
0?l04@3oool50000o`@0oooo1@000?lP0?ooo`D0003o0`3oool50?l003<0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`0i0?ooo`D00?l08@3oool7003o0080oooo3000o`000`3oool00?l0
003o0003003o00L0oooo1@00o`0A0?ooo`D0003o103oool50000ob00oooo1@000?l30?ooo`D0o`00
=03oool100000040oooo000E0?ooo`030000003oool0oooo01h0oooo0`00o`0H0?ooo`D00?l08@3o
oolB003o00<0oooo1P00o`070?ooo`D00?l04P3oool30000o`D0oooo1@000?lP0?ooo`D0003o103o
ool30?l002h0oooo0`3o00040?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool5
003o01P0oooo0`00o`0=0?ooo`<00?l04P3ooolA003o00@0oooo1@00o`090?ooo`<00?l0703oool3
0000o`T0oooo0`000?lF0?ooo`<0003o=@3oool50?l000<0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`0M0?ooo`D00?l0903oool8003o0180oooo4@00o`020?ooo`H00?l0<`3oool50000
odd0oooo1@3o00030?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool5003o02<0
oooo2@00o`001@3oool00?l0003o0000o`00oooo00<00?l02P3ooolH003o03@0oooo1@000?m=0?oo
o`D0o`000`3oool100000040oooo00000`3oool000000000000300000080oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`0N0?ooo`<00?l0903ooolB003o00L0oooo6@00o`0e0?ooo`D0
003oCP3oool30?l000@0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0A@3ooolE003o00<0oooo6P00o`0G0?ooo`<0
003o6`3oool50000oeD0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0080oooo0P0000170?ooo`<00?l000<0oooo003o0000o`008@00o`000`3oool00?l0
003o0006003o00<0oooo0`00o`0A0?ooo`D0003o6P3oool50000oe@0oooo0P0000010?ooo`000`3o
ool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`1;0?ooo`L00?l000<0
oooo003o0000o`006000o`040?ooo`H00?l000<0oooo003o0000o`000`00o`0@0?ooo`D0003o6`3o
ool30000ob@0oooo0`000?l_0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo04X0oooo1P00o`060?oooaL00?l01@3oool5
003o00030?ooo`00o`000?l000<00?l0403oool50000od40oooo1@000?l^0?ooo`4000000@3oool0
0080oooo0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`1:0?ooo`H00?l01`3ooolE003o
00D0oooo1P00o`000`3oool00?l0003o0003003o0140oooo0`000?lA0?ooo`<0003o;P3oool50000
obh0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`180?ooo`L00?l02@3oool6003o0080
oooo2`00o`050?ooo`H00?l00`3oool3003o02D0oooo1@000?lI0?ooo`<0003o4@3oool50000obh0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`170?ooo`L00?l02P3oool5003o00@0oooo
2`00o`040?ooo`D00?l0;03oool50000oaP0oooo1@000?lA0?ooo`<0003o;`3oool100000040oooo
000E0?ooo`030000003oool0oooo04L0oooo1@00o`0<0?ooo`D00?l0103oool=003o0080oooo2P00
o`0W0?ooo`D0003o2`3oool30000o`X0oooo1@000?m30?ooo`4000000@3oool001D0oooo0P000018
0?ooo`D00?l0303oool5003o0080oooo4000o`000`3oool00?l0003o0009003o02L0oooo0`000?l;
0?ooo`D0003o2@3oool50000od80oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`180?oo
o`<00?l03P3oool3003o0080oooo2@00o`000`3oool00?l0003o0005003o00030?ooo`00o`000?l0
00T00?l0=@3oool50000o`X0oooo0`000?m40?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0G@3oool9003o00<0oooo4P00o`0X0?ooo`<0003o0`3oool30000o`@0oooo1@000?mA0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0G@3oool6003o00P0oooo3`00o`0X0?ooo`/0003o
0`3oool50000o`040?ooo`000?l0003o0000odd0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`1M0?ooo`D00?l0303oool;003o02T0oooo2`000?l00`3oool0003o0000o`0:0000od`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`<00?l03@3oool;003o00<0oooo0`00
o`0P0?oooa/0003o703oool30000obd0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L
0?ooo`<00?l0403oool3003o00030?ooo`00o`000?l000@00?l00P3oool5003o01h0oooo3P000?l0
0`3oool0003o0000o`0;0000oa/0oooo1@000?l/0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0F`3oool5003o00@0oooo0`00o`0<0?ooo`D00?l00`3oool5003o01`0oooo7@000?lL0?oo
o`D0003o;03oool100000040oooo000E0?ooo`800000G03oool7003o00030?ooo`00o`000?l000<0
0?l0303oool3003o00@0oooo1@00o`0K0?oooa`0003o7P3oool50000ob/0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`1K0?ooo`d00?l0503oool3003o01`0oooo2@000?l00`3oool0003o
0000o`0@0000oal0oooo0`000?l]0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G03o
ool<003o03<0oooo70000?l60?ooo`<0003oAP3oool100000040oooo000E0?ooo`030000003oool0
oooo05h0oooo1@00o`00103oool00?l0003o0000o`0=0?ooo`<00?l09@3ooolK0000o`D0oooo1@00
0?m50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G@3oool5003o0140oooo1@00o`0U
0?ooo`<0003o00<0oooo0000o`000?l050000?l50?ooo`H0003oA03oool100000040oooo000E0?oo
o`030000003oool0oooo05`0oooo1@00o`0B0?ooo`D00?l0:@3ooolE0000o`H0oooo1`000?m30?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0G03oool5003o0180oooo1@00o`0X0?oooaH0
003o1`3oool60000od<0oooo0@0000010?ooo`005@3oool2000005d0oooo1`00o`0A0?ooo`<00?l0
6@3oool30000o`d0oooo5P000?l80?ooo`D0003o@P3oool200000040oooo000E0?ooo`030000003o
ool0oooo0480oooo0`00o`0H0?ooo`L00?l0:`3oool50000o``0oooo5@000?l:0?ooo`<0003oA03o
ool100000040oooo000E0?ooo`030000003oool0oooo0440oooo1@00o`0I0?ooo`H00?l0:P3oool5
0000o`d0oooo4`000?l00`3oool0003o0000o`040000od/0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`110?ooo`D00?l06@3oool6003o02X0oooo1@000?l?0?ooo`L0003o00<0oooo0000
o`000?l01P000?l00`3oool0003o0000o`060000odX0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`110?ooo`D00?l06P3oool5003o02/0oooo0`000?l@0?ooo`P0003o0P3oool60000o`03
0?ooo`000?l0003o00H0003oBP3oool100000040oooo000E0?ooo`030000003oool0oooo0480oooo
0`00o`0L0?ooo`<00?l0@03oool80000o`80oooo1@000?l00`3oool0003o0000o`060000odX0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`2W0?ooo`D0003o0P3oool50000o`80oooo1P00
0?m;0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0Y`3oool50000o`80oooo1@000?mC
0?ooo`4000000@3oool001D0oooo0P00002J0?ooo`H0003o2@3oool40000o`80oooo1@000?mB0?oo
o`8000000@3oool001D0oooo00<000000?ooo`3oool0V03oool80000o`P0oooo1@000?l20?ooo`<0
003oE03oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo20000?l80?ooo`D0003o
F@3oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo20000?l80?ooo`D0003oF@3o
ool100000040oooo000E0?ooo`030000003oool0oooo09T0oooo1P000?l:0?ooo`<0003oFP3oool1
00000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000=0?ooo`@0
0000103oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`003@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000>0?ooo`030000003o
ool0oooo00@0oooo0P00002g0?ooo`<0003oC03oool200000040oooo000?0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0]@3oool50000od`0oooo0@0000010?ooo`003@3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo03/0oooo0`00o`1g0?ooo`D0003oC03oool1
00000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0MP3oool50000
od`0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0M`3oool30000odd0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0a`3oool100000040oooo
000E0?ooo`030000003oool0oooo03/0oooo0`00o`380?ooo`4000000@3oool001D0oooo0P000004
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`02
0?ooo`8000000@3oool001D0ooooo`00000;00000040oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell["This shows the effect of choosing 5 clusters.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[FindClusters[datapairs, 5]];\)\)], "Input",
  CellLabel->"In[15]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.76051 .41915 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.76855 .29221 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.76788 .34998 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.71085 .30459 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
0 0 1 r
.74339 .20901 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.63111 .26316 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.64184 .24847 Mdot
.68066 .3047 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.69671 .23691 Mdot
.66926 .24111 Mdot
.61911 .30613 Mdot
.65701 .29945 Mdot
.67529 .26694 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.68588 .15456 Mdot
.75343 .22417 Mdot
.51064 .25923 Mdot
.59365 .34236 Mdot
.48614 .12625 Mdot
.58581 .26062 Mdot
0 1 0 r
.82053 .49726 Mdot
.58727 .41465 Mdot
.81575 .4557 Mdot
.73644 .46735 Mdot
.55655 .53432 Mdot
.54869 .44925 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
.5 0 .5 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.50457 .41568 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.46226 .4736 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.45339 .47461 Mdot
.38991 .40728 Mdot
.12969 .4303 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.32957 .39806 Mdot
.21578 .40395 Mdot
.23747 .60332 Mdot
.44919 .45135 Mdot
.45596 .42689 Mdot
.43534 .37683 Mdot
.40259 .46445 Mdot
.39253 .39693 Mdot
.48314 .49626 Mdot
.44256 .43831 Mdot
0 1 1 r
.4277 .36836 Mdot
.23057 .38102 Mdot
.30997 .34212 Mdot
.36299 .33887 Mdot
.31611 .33914 Mdot
.50655 .33632 Mdot
.35128 .3572 Mdot
.35204 .29427 Mdot
.46924 .23893 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.41883 .25293 Mdot
.46806 .26461 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.37319 .20988 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.3901 .21179 Mdot
.36788 .33111 Mdot
.43167 .32106 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.39434 .26552 Mdot
.32447 .30993 Mdot
.3944 .27361 Mdot
.30618 .37235 Mdot
.43209 .27502 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.39048 .33085 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.37563 .24168 Mdot
.39062 .3288 Mdot
.34568 .29468 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43464 .32716 Mdot
.38168 .28503 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.43823 .34941 Mdot
.3932 .32665 Mdot
.42653 .34969 Mdot
.38127 .3321 Mdot
.44956 .22897 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.37706 .28113 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.46494 .29543 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.3757 .25456 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.38565 .12838 Mdot
.22581 .33042 Mdot
.43989 .34764 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30000oeX0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0003o
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@000?mI0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50000oeT0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0003oFP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool3003ooaP0oooo0`000?n60?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool5003ooaH0oooo1@000?n50?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L00?oo503oool50000oh@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P00?oo4`3oool50000ohD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L00?oo503oool30000ohH0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
0?ooW@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`00oonN0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30000oe40oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0003oD03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0003oD03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@000?m?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30000oe40oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool3003ooi@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool5003ooi<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool5003ooi@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D00?ooL03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<00?ooL03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`00oomB0?ooo`<0
003o;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<00?oo
2P3oool5003ooe00oooo1@000?l[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<00?oo9`3oool5003oo`T0oooo1@00ool>0?ooo`<00?oo00@0
oooo003oo`00ool00?oo>`3oool50000oa/0oooo0`000?l<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?oo9P3oool5003oo`T0oooo1@00
ool=0?ooo`T00?oo>P3oool50000oaX0oooo1@000?l;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?oo9P3oool5003oo`X0oooo0`00ool>
0?ooo`T00?oo>`3oool30000oa/0oooo1@000?l;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@00oolW0?ooo`<00?oo703oool9003ooeT0oooo1@000?l<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
0?ooB03oool3003oo`040?ooo`00ool00?oo003ooe/0oooo1P000?lE0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`00ool@0?ooo`<00?ooC@3oool50000oaD0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool5003oo`h0oooo
1@00oom<0?ooo`D0003o0P3o000G0?ooo`<0o`008P3oool100000040oooo000E0?ooo`030000003o
ool0oooo05l0oooo1@00ool>0?ooo`D00?oo<P3oool30000o`T0oooo0`000?l;0?ooo`D0003o0`3o
000k0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool5003oo`h0oooo1@00ool0
103oool00?oo003oo`00ool]0?ooo`D0003o00@0oooo0000o`000?l0003o0`3oool50000o`/0oooo
0`000?l40?l003/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D00?oo3`3o
ool3003oo`030?ooo`00ool00?oo00<00?oo;03oool:0000o`80oooo1@000?l=0?ooo`D0o`00>`3o
ool100000040oooo000E0?ooo`030000003oool0oooo05h0oooo1P00oolC0?ooo`D00?oo:P3oool<
0000o`80oooo1@000?l0103oool0003o0000o`000?l:0?ooo`<0o`00?03oool100000040oooo000E
0?ooo`800000A@3oool3003ooaL0oooo1P00ool70?ooo`<00?oo2@3oool5003oobT0oooo1`000?l0
0`3oool0003o0000o`030000o`<0oooo0`000?l00`3oool0003o0000o`030000o`H0oooo0`3o0004
0?ooo`<0o`004@3oool30?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?oo
o`<00?oo1@3oool7003ooa@0oooo1@00ool70?ooo`D00?oo2@3oool3003oobX0oooo1@000?l40?oo
o`<0003o203oool50000o`D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`0j0?ooo`D00?oo103oool8003oo`l0oooo0`00ool20?ooo`D0
0?oo1P3oool5003ooa@0oooo0`000?lA0?ooo`<0003o203oool80000o`l0oooo1P000?l20?l00080
oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`0j0?ooo`D00?oo0`3oool9003oo`h0oooo1@00ool00`3oool00?oo003oo`03003oo`H0oooo
1@00ool90?ooo`<00?oo1`3oool50000o`l0oooo1@000?l60?ooo`P0003o4@3oool50000o`<0o`00
00<0oooo0?l0003o0000103o00000`3oool0o`000?l000030?l000l0oooo1@3o000S0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>P3oool5003oo`<0oooo2@00ool>0?ooo`D00?oo00<0
oooo003oo`00ool00`00ool0103oool00?oo003oo`00ool30?ooo`<00?oo2@3oool5003oo`H0oooo
1@000?l?0?ooo`D0003o1P3oool60000o`P0oooo0`000?l80?ooo`D0003o0`3o00020?ooo`D0o`00
0P3oool30?l00140oooo0`3o000T0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>`3o
ool3003oo`@0oooo2000ool?0?ooo`D00?oo0P3oool3003oo`030?ooo`00ool00?oo00<00?oo0P3o
ool3003oo`T0oooo1@00ool60?ooo`D0003o3`3oool50000o`H0oooo1P000?l70?ooo`D0003o203o
ool30000o`@0o`000P3oool50?l000@0oooo0`3o000C0?ooo`<0o`00803oool100000040oooo000E
0?ooo`030000003oool0oooo04<0oooo0`00oolD0?ooo`<00?oo1`3oool5003oo`030?ooo`00ool0
0?oo00H00?oo1@3oool5003oo`L0oooo0`000?lA0?ooo`<0003o203oool50000o`L0oooo1@000?l;
0?ooo`<0o`00103oool30?l000<0oooo1`3o000@0?ooo`D0o`007`3oool100000040oooo000E0?oo
o`800000I@3oool5003oo`030?ooo`00ool00?oo00L00?oo1@3oool3003oobP0oooo0`000?l80?oo
o`H0003o203oool30?l000@0oooo1P3o00000`3oool0o`000?l000070?l000l0oooo1@3o000N0?oo
o`8000000@3oool001D0oooo00<000000?ooo`3oool0H03oool3003oo`030?ooo`00ool00?oo00<0
0?oo00<0oooo003oo`00ool01`00oola0?ooo`<0003o203oool60000o`H0oooo1@3o00020?oooa40
o`003P3oool60?l001l0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`X00?oo
0P3oool8003ooc00oooo1@000?l80?ooo`D0003o1P3oool50?l00080oooo4@3o000=0?ooo`H0o`00
803oool100000040oooo000E0?ooo`030000003oool0oooo05l0oooo2@00ool70?ooo`<00?oo<@3o
ool50000o`P0oooo1@000?l60?ooo`D0o`000P3oool80?l000050?ooo`3o0000o`000?l0003oool0
0`3o000>0?ooo`D0o`008@3oool100000040oooo000E0?ooo`030000003oool0oooo05P0oooo1000
ool30?ooo`P00?oo?03oool50000o`T0oooo0`000?l60?ooo`D0o`000`3oool90?l000@0oooo0`3o
000>0?ooo`D0o`008@3oool100000040oooo000E0?ooo`030000003oool0oooo0500oooo0`00ool4
0?ooo`P00?oo00<0oooo003oo`00ool01P00ool?0?ooo`<00?oo:P3oool30000oa<0oooo1@3o0003
0?ooo`X0o`000P3oool50?l000h0oooo0`3o000R0?ooo`4000000@3oool000d0oooo1@0000030?oo
o`030000003oool0oooo04l0oooo1@00ool20?ooo`X00?oo00<0oooo003oo`00ool02000ool;0?oo
o`D00?oo;`3oool30000o`P0oooo0`3o00020?ooo`D0o`000`3oool:0?l00080oooo1@3o000;0?oo
o`<0o`009@3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0C`3oool5003oo`80oooo2P00ool20?ooo`X00?oo2P3oool5003oobD0oooo0`000?l60?ooo`D0
003o0`3oool30000o`X0o`000`3oool;0?l00080oooo1@3o000:0?ooo`H0o`008`3oool100000040
oooo000?0?ooo`030000003oool0oooo00<0oooo0P00001@0?ooo`H00?oo00<0oooo003oo`00ool0
2000ool00`3oool00?oo003oo`09003oo`X0oooo1@00oolT0?ooo`D0003o1@3oool50000o`80oooo
1@000?l:0?l00080oooo2P3o00040?ooo`<0o`002`3oool70?l00240oooo0P0000010?ooo`003`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo0`00oolo0?ooo`H00?oo00@0
oooo003oo`00ool00?oo0P3oool3003oo`80oooo2`00ool80?ooo`H00?oo9@3oool50000o`D0oooo
1@000?l20?ooo`D0003o2P3o00020?ooo`T0o`00203oool30?l000P0oooo1`3o000R0?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`D00?oo=P3o
ool3003oo`@0oooo1`00ool;0?ooo`X00?oo203oool5003oobL0oooo1@000?l60?ooo`<0003o0P3o
ool00`3o0000003o0000o`030000o`X0o`000`3oool90?l000H0oooo1@3o00040?ooo`<0o`0000<0
oooo0?l0003o0000103o000R0?ooo`4000000@3oool000h0oooo0P0000050?ooo`030000003oool0
oooo00d0oooo1@00oole0?ooo`D00?oo0P3oool8003oo`040?ooo`00ool00?oo003oo`80oooo2P00
ool80?ooo`<00?oo0P3oool5003oobP0oooo0`000?l0103oool0003o0000o`000?l70?ooo`<0o`00
0`000?l:0?l000@0oooo2P3o00050?ooo`D0o`000`3oool50?l00080oooo0`3o000S0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool03@3oool5003oocD0oooo1@00ool20?ooo`L00?oo00<0
oooo003oo`00ool04@00ool40?ooo`D00?oo00<0oooo003oo`00ool00`00ool[0?ooo`D0003o1P3o
ool=0?l000H0oooo1@3o00000`3oool0o`000?l000030?l000D0oooo1@3o00030?ooo`D0o`00:03o
ool100000040oooo000E0?ooo`030000003oool0oooo00h0oooo0`00oolf0?ooo`D00?oo0P3oool5
003oo`<0oooo5000ool30?ooo`D00?oo0P3oool3003oob`0oooo1P000?l50?ooo`d0o`001P3oool5
0?l000030?ooo`3o0000o`0000<0o`001P3oool30?l000@0oooo1@3o000X0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0>03oool3003oo`d0oooo0`00ool40?ooo`<00?oo103ooolD003o
o`<0oooo1P00ool`0?ooo`H0003o1P3oool30?l00080oooo1`3o00060?ooo`X0o`003`3oool30?l0
02T0oooo0@0000010?ooo`005@3oool2000003P0oooo1@00oolK0?ooo`<00?oo0P3oool>003oo`@0
oooo1@00ool30?ooo`<00?oo2@3oool3003ooal0oooo1@000?l>0?ooo`<0o`00203oool30?l00003
0?ooo`3o0000o`0000<0o`001`3oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo
0?ooo`0g0?ooo`D00?oo503oool3003oo`P0oooo3`00ool30?ooo`H00?oo0P3oool5003oo`L0oooo
1@00oolO0?ooo`<0003o7@3oool60?l00080oooo0`3o00000`3oool0o`000?l000030?l00300oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0g0?ooo`D00?oo4P3oool6003oo`H0oooo4000
ool20?ooo`H00?oo0`3oool5003oo`L0oooo1@00oolC0?ooo`<0003o:@3oool50?l00080oooo2P3o
000;0?ooo`@0o`008@3oool100000040oooo000E0?ooo`030000003oool0oooo03P0oooo0`00ool:
0?ooo`<00?oo1@3oool7003oo`H0oooo4000ool20?ooo`P00?oo00<0oooo003oo`00ool00`00ool7
0?ooo`D00?oo4P3oool50000obP0oooo1@3o00020?ooo`X0o`002P3oool60?l00200oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`120?ooo`L00?oo103oool7003oo`80oooo0`00ool00`3o
ool00?oo003oo`04003oo`050?ooo`00ool00?oo003oo`3oool01@00ool20?ooo`T00?oo00@0oooo
003oo`00ool00?oo2@3oool3003ooa<0oooo1@000?lY0?ooo`D0o`0000<0oooo0?l0003o00000`3o
0000103oool0o`000?l0003o000;0?ooo`H0o`00803oool100000040oooo000E0?ooo`030000003o
ool0oooo0440oooo2000ool40?ooo`H00?oo0P3oool5003oo`030?ooo`00ool00?oo00800?oo00D0
oooo003oo`00ool00?oo0?ooo`05003oo`<0oooo2@00oolS0?ooo`D0003o6@3oool30?l000h0oooo
1@3o0000103oool0o`000?l0003o00080?ooo`<0o`001@3oool60?l00200oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`110?ooo`P00?oo1@3oool3003oo`@0oooo1`00ool30?ooo`X00?oo
0`3oool9003ooa80oooo0`00ool?0?ooo`<0003o2`3oool30?l000/0oooo203o00030?ooo`<0o`00
103oool50?l000030?ooo`3o0000o`0000<0o`001@3oool50?l000D0oooo103o000Q0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0@@3oool7003oo`d0oooo2000ool20?ooo`X00?oo0`3o
ool8003ooa80oooo1@00oolK0?ooo`D0o`002P3oool90?l000030?ooo`3o0000o`0000D0o`0000<0
oooo0?l0003o00002P3o00040?ooo`D0o`001P3oool30?l00240oooo0@0000010?ooo`005@3oool2
000004<0oooo0`00oolA0?ooo`L00?oo0P3oool9003oo`D0oooo1P00oolC0?ooo`D00?oo6`3oool5
0?l00080oooo0`3o00001@3oool0o`000?l0003o0000oooo00T0o`0000<0oooo0?l0003o00001P3o
00001@3oool0o`000?l0003o0000oooo00L0o`00103oool50?l000D0oooo1@3o000O0?ooo`800000
0@3oool001D0oooo00<000000?ooo`3oool0F03oool5003oo`<0oooo1P00ool70?ooo`<00?oo5P3o
ool5003ooa/0oooo1@3o00000`3oool0o`000?l000070?l000030?ooo`3o0000o`0000H0o`0000<0
oooo0?l0003o00001P3o00050?ooo`L0o`001@3oool30?l000H0oooo1@3o000P0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0C@3oool3003oo`T0oooo0`00ool30?ooo`H00?oo1`3oool5
003ooaH0oooo0`00oolM0?ooo`<0o`000P3oool<0?l00080oooo0`3o00030?ooo`L0o`001P3oool5
0?l000l0oooo203o000M0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0C03oool5003o
o`h0oooo1@00ool80?ooo`D00?oo0`1o07lh0?ooo`d0o`002P3oool50?l001X0oooo203o000L0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0>@3oool3003ooa00oooo1@00ool>0?ooo`D0
0?oo203oool5003oo`@0O`1o>03oool30?l000030?ooo`3o0000o`0000H0o`002P3oool50?l001D0
oooo0`3o00050?ooo`D0o`00703oool100000040oooo000E0?ooo`030000003oool0oooo03P0oooo
1@00ool?0?ooo`D00?oo3`3oool3003oo`80O`1o203oool3003oo`D0O`1o?`3oool50?l000X0oooo
1@3o00090?ooo`<0o`00203oool50?l000@0oooo1@3o000L0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0>03oool5003ooa00oooo0`00oolA0?ooo`D0O`1o203oool807l0Ocl0oooo0`3o
000<0?ooo`<0o`002@3oool50?l000L0oooo1@3o00050?ooo`<0o`007@3oool100000040oooo000E
0?ooo`030000003oool0oooo03P0oooo1@00ool;0?ooo`<0O`1o5P3oool507l0O`T0oooo201o07m5
0?ooo`<0o`004@3oool50?l000L0oooo1@3o000U0?ooo`4000000@3oool001D0oooo0P00000j0?oo
o`<00?oo2`3oool507l0OaD0oooo1@1o07l70?ooo`<0O`1o0P3oool507l0Od@0oooo1@3o000@0?oo
o`D0o`00203oool30?l002D0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`170?ooo`D0
O`1o1`3oool307l0O`040?ooo`1o07l0O`1o07l0O`P0oooo1@1o07l50?ooo`D0O`1o00<0oooo07l0
O`1o07l00`1o07m40?ooo`D0o`004@3oool30?l00380oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0e0?ooo`<0O`1o3`3oool507l0O`H0oooo2@1o07l70?ooo`H0O`1o103oool507l0O`80
oooo0`1o07m50?ooo`D0o`00AP3oool100000040oooo000E0?ooo`030000003oool0oooo03@0oooo
1@1o07l?0?ooo`<0O`1o1`3oool907l0O`L0oooo201o07l20?ooo`D0O`1oB`3oool30?l004L0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0d0?ooo`D0O`1o6@3oool907l0O`L0oooo2@1o
07l20?ooo`<0O`1o00@0oooo07l0O`1o07l0O`1oTP3oool100000040oooo000E0?ooo`030000003o
ool0oooo03@0oooo1@1o07lJ0?ooo`<0O`1o00@0oooo07l0O`1o07l0O`1o203oool907l0O`<0oooo
1`1o07lS0?ooo`<00?l0<`3oool30?l003D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0d0?ooo`D0O`1o00@0oooo07l0O`1o07l0O`1o8`3oool;07l0O`80oooo201o07l0103oool0O`1o
07l0O`1o07l90?ooo`<0O`1o4P3oool5003o00D0oooo0`00o`0R0?ooo`<0o`00103oool50?l003@0
oooo0@0000010?ooo`005@3oool2000003H0oooo0`1o07l00`3oool0O`1o07l0O`0307l0Ob40oooo
1`1o07l01@3oool0O`1o07l0O`1o07l0oooo00l0O`1o1`3oool507l0Oa40oooo1@00o`040?ooo`D0
0?l0803oool50?l000<0oooo1@3o000c0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0
>@3oool507l0Ob40oooo1`1o07l20?ooo``0O`1o00<0oooo07l0O`1o07l00`1o07l70?ooo`D0O`1o
4@3oool5003o00@0oooo1@00o`0P0?ooo`D0o`000`3oool50?l003@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0N0?ooo`<0O`1o603oool507l0Ob40oooo4P1o07l30?ooo`H0O`1o1`3o
ool507l0Oa80oooo0`00o`050?ooo`D00?l0803oool50?l000@0oooo0`3o000^0?ooo`<0o`00103o
ool100000040oooo000E0?ooo`030000003oool0oooo01d0oooo1@1o07lH0?ooo`<0O`1o3@3oool3
07l0Oa80oooo4@1o07l40?ooo`D0O`1o2@3oool307l0Oa`0oooo0`00o`090?ooo`<00?l05P3oool3
0?l003D0oooo1@3o00030?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool507l0
Ob@0oooo201o07lB0?oooa40O`1o0P3oool607l0Oc<0oooo1@00o`1=0?ooo`D0o`000`3oool10000
0040oooo000E0?ooo`030000003oool0oooo01d0oooo1@1o07lS0?ooo`T0O`1o00D0oooo07l0O`1o
07l0O`1o0?ooo`0307l0O`X0oooo601o07ld0?ooo`D00?l0C@3oool50?l000<0oooo0@0000010?oo
o`0000<0oooo0000000000000`0000020?ooo`800000103oool2000000D0oooo00<000000?ooo`3o
ool07P3oool307l0Ob@0oooo4P1o07l70?oooaT0O`1o=@3oool5003o04h0oooo0`3o00040?ooo`40
00000@3oool000<0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo04D0oooo5@1o07l30?oooaX0O`1o5`3oool3003o01/0oooo1@00o`1E0?ooo`40
00000@3oool000<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`800000
A`3oool307l0O`030?ooo`1o07l0O`1o0240O`1o00<0oooo07l0O`1o07l01P1o07l30?ooo`<0O`1o
4@3oool5003o01X0oooo1@00o`1D0?ooo`8000000@3oool000<0oooo00<000000?ooo`3oool0203o
ool2000000D0oooo00<000000?ooo`3oool0B`3oool707l0O`030?ooo`1o07l0O`1o01P0O`1o103o
ool607l0O`030?ooo`1o07l0O`1o00<0O`1o403oool5003o01/0oooo0`00o`0T0?ooo`<00?l0;`3o
ool100000040oooo00030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`1:0?ooo`H0O`1o1P3ooolG07l0O`D0oooo1@1o07l00`3oool0O`1o07l0O`03
07l0Oa00oooo1@00o`110?ooo`D00?l0;P3oool100000040oooo00020?ooo`8000002P3oool30000
00@0oooo00<000000?ooo`3oool0BP3oool607l0O`L0oooo5@1o07l50?ooo`H0O`1o00<0oooo07l0
O`1o07l00`1o07lA0?ooo`<00?l04@3oool3003o02h0oooo1@00o`0^0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0B03oool707l0O`T0oooo1P1o07l20?ooo`/0O`1o1@3oool607l0O`<0
oooo0`1o07lU0?ooo`D00?l06@3oool3003o0140oooo1@00o`0^0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0A`3oool707l0O`X0oooo1@1o07l40?ooo`/0O`1o103oool507l0Ob`0oooo
1@00o`0H0?ooo`D00?l04@3oool3003o02l0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`170?ooo`D0O`1o303oool507l0O`@0oooo3@1o07l20?ooo`X0O`1o9`3oool5003o00/0oooo0`00
o`0:0?ooo`D00?l0@`3oool100000040oooo000E0?ooo`800000B03oool507l0O``0oooo1@1o07l2
0?oooa00O`1o00<0oooo07l0O`1o07l02@1o07lW0?ooo`<00?l02`3oool5003o00T0oooo1@00o`12
0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0B03oool307l0O`h0oooo0`1o07l20?oo
o`T0O`1o00<0oooo07l0O`1o07l01@1o07l00`3oool0O`1o07l0O`0907l0OcD0oooo1@00o`0:0?oo
o`<00?l0A03oool100000040oooo000E0?ooo`030000003oool0oooo05d0oooo2@1o07l30?oooa80
O`1o:03oool3003o00<0oooo0`00o`040?ooo`D00?l0D@3oool100000040oooo000E0?ooo`030000
003oool0oooo05d0oooo1P1o07l80?ooo`l0O`1o:03oool;003o00<0oooo1@00o`00103oool00?l0
003o0000o`1=0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G@3oool507l0O``0oooo
2`1o07lY0?ooo`/00?l000<0oooo003o0000o`002P00o`1<0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0GP3oool307l0O`d0oooo2`1o07l30?ooo`<0O`1o803ooolK003o01`0oooo0`00
o`0]0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G03oool307l0Oa00oooo0`1o07l0
0`3oool0O`1o07l0O`0407l0O`80oooo1@1o07lN0?ooo`h00?l000<0oooo003o0000o`002`00o`0K
0?ooo`D00?l0;03oool100000040oooo000E0?ooo`030000003oool0oooo05/0oooo1@1o07l40?oo
o`<0O`1o303oool507l0O`<0oooo1@1o07lL0?oooad00?l0703oool5003o02`0oooo0@0000010?oo
o`005@3oool2000005`0oooo1`1o07l00`3oool0O`1o07l0O`0307l0O``0oooo0`1o07l40?ooo`D0
O`1o6`3ooolL003o01h0oooo1@00o`0[0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0
F`3oool=07l0Oa@0oooo0`1o07lL0?ooo`T00?l000<0oooo003o0000o`004000o`0O0?ooo`<00?l0
;@3oool100000040oooo000E0?ooo`030000003oool0oooo05`0oooo301o07lc0?oooa`00?l01P3o
ool3003o04H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`D0O`1o00@0oooo
07l0O`1o07l0O`1o3@3oool307l0ObD0oooo6`00o`050?ooo`D00?l0A@3oool100000040oooo000E
0?ooo`030000003oool0oooo05d0oooo1@1o07lA0?ooo`D0O`1o9@3oool3003o00030?ooo`00o`00
0?l001@00?l01@3oool6003o04@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L0?oo
o`D0O`1o4P3oool507l0ObT0oooo5@00o`060?ooo`L00?l0@`3oool100000040oooo000E0?ooo`03
0000003oool0oooo05`0oooo1@1o07lB0?ooo`D0O`1o:03ooolF003o00L0oooo1P00o`130?ooo`40
00000@3oool001D0oooo0P00001M0?ooo`L0O`1o4@3oool307l0OaT0oooo0`00o`0=0?oooaH00?l0
203oool5003o0480oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`120?ooo`<0O`1o603o
ool707l0Ob/0oooo1@00o`0<0?oooaD00?l02P3oool3003o04@0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`110?ooo`D0O`1o6@3oool607l0ObX0oooo1@00o`0=0?oooa<00?l000<0oooo
003o0000o`001000o`1;0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0@@3oool507l0
OaT0oooo1P1o07lZ0?ooo`D00?l03`3oool7003o00030?ooo`00o`000?l000H00?l000<0oooo003o
0000o`001P00o`1:0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0@@3oool507l0OaX0
oooo1@1o07l[0?ooo`<00?l0403oool8003o0080oooo1P00o`000`3oool00?l0003o0006003o04X0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`120?ooo`<0O`1o703oool307l0Od00oooo
2000o`020?ooo`D00?l000<0oooo003o0000o`001P00o`1:0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0Y`3oool5003o0080oooo1@00o`020?ooo`H00?l0B`3oool100000040oooo000E
0?ooo`030000003oool0oooo0:L0oooo1@00o`020?ooo`D00?l0D`3oool100000040oooo000E0?oo
o`800000VP3oool6003o00T0oooo1000o`020?ooo`D00?l0DP3oool200000040oooo000E0?ooo`03
0000003oool0oooo09P0oooo2000o`080?ooo`D00?l00P3oool3003o05@0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`2H0?ooo`P00?l0203oool5003o05T0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`2H0?ooo`P00?l0203oool5003o05T0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`2I0?ooo`H00?l02P3oool3003o05X0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`003@3oool4000000@0oooo00<000000?ooo`3o
ool0o`3oool70?ooo`4000000@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`3o0?ooo`L0oooo0@0000010?ooo`003P3oool00`000000oooo0?ooo`040?ooo`800000]`3o
ool3003o04`0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0;D0oooo1@00o`1<0?ooo`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`0k0?ooo`<0O`1oM`3oool5003o04`0oooo0@0000010?ooo`003P3oool20000
00D0oooo00<000000?ooo`3oool0>P3oool507l0OgH0oooo1@00o`1<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0>P3oool507l0OgL0oooo0`00o`1=0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0>P3oool507l0OlL0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0k0?ooo`<0O`1ob03oool100000040oooo000E0?ooo`800000103oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool200000040oooo000E0?oo
ool000002`0000010?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["DistanceFunction",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell[
            "the distance or dissimilarity measure to use", "Text"]},
          {
            StyleBox["Method",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(the\ clustering\ method\ to\ use\)},
          {
            StyleBox["RandomSeed",
              "MR"], 
            StyleBox["Automatic",
              
              "MR"], \(starting\ value\ for\ the\ random\ number\ \
generator\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.3, 0.4},
  RowLines->{0.5, False}}],

Cell[TextData[{
  "Options for ",
  StyleBox["FindClusters", "MR"],
  "."
}], "Caption"],

Cell[TextData[{
  "Randomness is used in clustering in two different ways. Some of the \
methods use a random assignment of some points to a specific number of \
clusters as a starting point. Randomness may also be used to help determine \
what seems to be the best number of clusters to use. Changing the random seed \
for generating the randomness by using ",
  StyleBox["FindClusters[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " \[Ellipsis] ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["RandomSeed", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " may lead to different results for some cases."
}], "Text"],

Cell["\<\
In principle, clustering techniques can be applied to any set of data. What \
is needed is a measure of how far apart each element in the set is from other \
elements: basically a function giving distance between elements.\
\>", "Text"],

Cell[TextData[{
  StyleBox["FindClusters[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " \[Ellipsis] ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["DistanceFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  " treats pairs of elements as being less similar when their distances ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["j",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " are larger. The function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " can be any appropriate distance or dissimilarity function. A \
dissimilarity function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " satisfies the following:"
}], "Text"],

Cell[BoxData[{
    \(TraditionalForm\`f(e\_i, e\_i) = 0\), "\n", 
    \(TraditionalForm\`f(e\_i, e\_j) \[GreaterEqual] 0\), "\n", 
    \(TraditionalForm\`f(e\_i, e\_j) = f(e\_j, e\_i)\)}], "DisplayMath"],

Cell[TextData[{
  "If the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are vectors of numbers, ",
  StyleBox["FindClusters", "MR"],
  " by default uses a squared Euclidean distance. If the ",
  Cell[BoxData[
      \(TraditionalForm\`e\_i\)]],
  " are lists of Boolean ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " elements, ",
  StyleBox["FindClusters", "MR"],
  " by default uses a dissimilarity based on the normalized fraction of \
elements that disagree.",
  " ",
  "If the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are strings, ",
  StyleBox["FindClusters", "MR"],
  " by default uses a distance function based on the number of point changes \
needed to get from one string to another."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["EuclideanDistance",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                SubscriptBox[
                  StyleBox["d",
                    "TI"], "1"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"],
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"the", " ", "Euclidean", " ", "norm", " ", 
              SqrtBox[
                StyleBox[
                  RowBox[{"Total", "[", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          SubscriptBox[
                            StyleBox["d",
                              "TI"], "1"], "-", 
                          SubscriptBox[
                            StyleBox["d",
                              "TI"], "2"]}], ")"}], "2"], "]"}],
                  "MR"]]}]},
          {
            StyleBox[
              RowBox[{"SquaredEuclideanDistance", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]}], "]"}],
              "MR"], Cell["the square of the Euclidean norm", "Text"]},
          {
            StyleBox[
              RowBox[{"ManhattanDistance", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]}], "]"}],
              "MR"], Cell[TextData[{
              "the Manhattan distance ",
              StyleBox["Total[Abs[", "MR"],
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], "-", 
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "2"]}]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]]", "MR"]
            }], "Text"]},
          {
            StyleBox[
              RowBox[{"SupDistance", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]}], "]"}],
              "MR"], Cell[TextData[{
              "the sup distance ",
              StyleBox["Max[Abs[", "MR"],
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], "-", 
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "2"]}]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]]", "MR"]
            }], "Text"]},
          {
            StyleBox[
              RowBox[{"CanberraDistance", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]}], "]"}],
              "MR"], Cell[TextData[{
              "the Canberra distance ",
              StyleBox["Total[Abs[", "MR"],
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], "-", 
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "2"]}]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]/(Abs[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]+Abs[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["])]", "MR"]
            }], "Text"]},
          {
            StyleBox[
              RowBox[{"CosineAngleDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]}], "]"}],
              "MR"], Cell[TextData[{
              "the angular cosine dissimilarity ",
              StyleBox["Dot[", "MR"],
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], ",", 
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "2"]}]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]/(Norm[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]Norm[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["])", "MR"]
            }], "Text"]},
          {
            StyleBox[
              RowBox[{"CorrelationDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]}], "]"}],
              "MR"], Cell[TextData[{
              "the correlation coefficient dissimilarity ",
              StyleBox["1-Abs[Dot[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["-Mean[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["],", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["-Mean[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]]/(Norm[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["-Mean[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]]Norm[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["-Mean[", "MR"],
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]],
                GridBoxOptions->{ColumnAlignments->{Right, Left},
                RowLines->{0.5, False}}],
              StyleBox["]])]", "MR"]
            }], "Text"]},
          {
            StyleBox[
              RowBox[{"BrayCurtisDistance", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["d",
                      "TI"], "2"]}], "]"}],
              "MR"], 
            RowBox[{"the", " ", "Bray\[Hyphen]Curtis", " ", "distance", " ", 
              StyleBox[
                RowBox[{
                  RowBox[{"Total", "[", 
                    RowBox[{"Abs", "[", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["d",
                            "TI"], "1"], "-", 
                        SubscriptBox[
                          StyleBox["d",
                            "TI"], "2"]}], "]"}], "]"}], "/", 
                  RowBox[{"Total", "[", 
                    RowBox[{"Abs", "[", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["d",
                            "TI"], "1"], "+", 
                        SubscriptBox[
                          StyleBox["d",
                            "TI"], "2"]}], "]"}], "]"}]}],
                "MR"]}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["Distance and dissimilarity functions for numerical data.", "Caption"],

Cell[TextData[{
  "This shows the clusters in ",
  StyleBox["datapairs", "MR"],
  " found using a Manhattan distance."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[
        FindClusters[datapairs, 
          DistanceFunction \[Rule] ManhattanDistance]];\)\)], "Input",
  CellLabel->"In[16]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.74339 .20901 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.63111 .26316 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.76051 .41915 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.76855 .29221 Mdot
.64184 .24847 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.68066 .3047 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.69671 .23691 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.66926 .24111 Mdot
.76788 .34998 Mdot
.61911 .30613 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.65701 .29945 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.67529 .26694 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.68588 .15456 Mdot
.71085 .30459 Mdot
.75343 .22417 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
.59365 .34236 Mdot
.58581 .26062 Mdot
0 0 1 r
.82053 .49726 Mdot
.58727 .41465 Mdot
.81575 .4557 Mdot
.73644 .46735 Mdot
.55655 .53432 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
0 1 0 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.23057 .38102 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.50457 .41568 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.46226 .4736 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.45339 .47461 Mdot
.38991 .40728 Mdot
.12969 .4303 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.32957 .39806 Mdot
.21578 .40395 Mdot
.23747 .60332 Mdot
.44919 .45135 Mdot
.45596 .42689 Mdot
.43534 .37683 Mdot
.54869 .44925 Mdot
.40259 .46445 Mdot
.39253 .39693 Mdot
.48314 .49626 Mdot
.44256 .43831 Mdot
.5 0 .5 r
.4277 .36836 Mdot
.30997 .34212 Mdot
.36299 .33887 Mdot
.31611 .33914 Mdot
.50655 .33632 Mdot
.35128 .3572 Mdot
.35204 .29427 Mdot
.46924 .23893 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.41883 .25293 Mdot
.46806 .26461 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.51064 .25923 Mdot
.37319 .20988 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.3901 .21179 Mdot
.36788 .33111 Mdot
.43167 .32106 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.39434 .26552 Mdot
.32447 .30993 Mdot
.3944 .27361 Mdot
.30618 .37235 Mdot
.43209 .27502 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.39048 .33085 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.37563 .24168 Mdot
.39062 .3288 Mdot
.34568 .29468 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43464 .32716 Mdot
.38168 .28503 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.43823 .34941 Mdot
.3932 .32665 Mdot
.42653 .34969 Mdot
.38127 .3321 Mdot
.44956 .22897 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.37706 .28113 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.46494 .29543 Mdot
.48614 .12625 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.3757 .25456 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.38565 .12838 Mdot
.22581 .33042 Mdot
.43989 .34764 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[16]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30?l005X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@3o001I0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50?l005T0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0o`00FP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool307l0OaP0oooo0`1o07n60?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool507l0OaH0oooo1@1o07n50?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L0O`1o503oool507l0Oh@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P0O`1o4`3oool507l0OhD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L0O`1o503oool307l0OhH0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
O`1oW@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`1o07nN0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30?l00540oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@3o001?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30?l00540oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool307l0Oi@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool507l0Oi<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool507l0Oi@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D0O`1oL03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<0O`1oL03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`1o07mB0?ooo`<0
o`00;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<0O`1o
2P3oool507l0Oe00oooo1@3o000[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<0O`1o9`3oool507l0O`T0oooo1@1o07l>0?ooo`<0O`1o00@0
oooo07l0O`1o07l0O`1o>`3oool50?l001/0oooo0`3o000<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0O`1o9P3oool507l0O`T0oooo1@1o
07l=0?ooo`T0O`1o>P3oool50?l001X0oooo1@3o000;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0O`1o9P3oool507l0O`X0oooo0`1o07l>
0?ooo`T0O`1o>`3oool30?l001/0oooo1@3o000;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@1o07lW0?ooo`<0O`1o703oool907l0OeT0oooo1@3o000<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
O`1oB03oool307l0O`040?ooo`1o07l0O`1o07l0Oe/0oooo1P3o000E0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`1o07l@0?ooo`<0O`1oC@3oool50?l001D0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool507l0O`h0oooo
1@1o07m<0?ooo`L0o`005`3oool30?l00280oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`D0O`1o3P3oool507l0Oc80oooo0`3o00090?ooo`<0o`002`3oool80?l003/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0O`1o3P3oool507l0O`040?ooo`1o07l0
O`1o07l0Obd0oooo1@3o0000103oool0o`000?l0003o00030?ooo`D0o`002`3oool70?l003/0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0O`1o3`3oool307l0O`030?ooo`1o
07l0O`1o00<0O`1o;03oool:0?l00080oooo1@3o000=0?ooo`D0o`00>`3oool100000040oooo000E
0?ooo`030000003oool0oooo05h0oooo1P1o07lC0?ooo`D0O`1o:P3oool<0?l00080oooo1@3o0000
103oool0o`000?l0003o000:0?ooo`<0o`00?03oool100000040oooo000E0?ooo`800000A@3oool3
07l0OaL0oooo1P1o07l70?ooo`<0O`1o2@3oool507l0ObT0oooo1`3o00000`3oool0o`000?l00003
0?l000<0oooo0`3o00000`3oool0o`000?l000030?l000H0oooo0`3o00040?ooo`<0o`004@3oool3
0?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<0O`1o1@3oool707l0
Oa@0oooo1@1o07l70?ooo`D0O`1o2@3oool307l0ObX0oooo1@3o00040?ooo`<0o`00203oool50?l0
00D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`D0O`1o103oool807l0O`l0oooo0`1o07l20?ooo`D0O`1o1P3oool507l0Oa@0
oooo0`1o07lA0?ooo`<0o`00203oool80?l000l0oooo203o00020?ooo`D0o`000P3oool50?l000l0
oooo1@3o000S0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>P3oool507l0O`<0oooo
2@1o07l>0?ooo`D0O`1o00<0oooo07l0O`1o07l00`1o07l60?ooo`D0O`1o2@3oool307l0O`L0oooo
1@1o07l?0?ooo`D0o`001P3oool80?l00140oooo203o00000`3oool0o`000?l000040?l000030?oo
o`3o0000o`0000<0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0j0?ooo`D0O`1o0`3oool907l0O`h0oooo1@1o07l00`3oool0O`1o07l0O`0307l0O`040?ooo`1o
07l0O`1o07l0O`<0oooo0`1o07l90?ooo`D0O`1o1P3oool507l0O`l0oooo1@3o00060?ooo`H0o`00
203oool30?l000P0oooo203o00020?ooo`D0o`000P3oool30?l00140oooo0`3o000T0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>`3oool307l0O`@0oooo201o07l?0?ooo`D0O`1o0P3o
ool307l0O`030?ooo`1o07l0O`1o00<0O`1o0P3oool307l0O`T0oooo1@1o07l60?ooo`D0O`1o3`3o
ool50?l000H0oooo1P3o00070?ooo`D0o`00203oool70?l00080oooo1@3o00040?ooo`<0o`004`3o
ool30?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`130?ooo`<0O`1o503oool3
07l0O`L0oooo1@1o07l00`3oool0O`1o07l0O`0607l0O`D0oooo1@1o07l70?ooo`<0O`1o4@3oool3
0?l000P0oooo1@3o00070?ooo`D0o`002`3oool30?l000@0oooo0`3o00030?ooo`L0o`00403oool5
0?l001l0oooo0@0000010?ooo`005@3oool2000006D0oooo1@1o07l00`3oool0O`1o07l0O`0707l0
O`D0oooo0`1o07lX0?ooo`<0o`00203oool60?l000P0oooo0`3o00040?ooo`H0o`0000<0oooo0?l0
003o00001`3o000?0?ooo`D0o`007P3oool200000040oooo000E0?ooo`030000003oool0oooo0600
oooo0`1o07l00`3oool0O`1o07l0O`0307l0O`030?ooo`1o07l0O`1o00L0O`1o<@3oool30?l000P0
oooo1P3o00060?ooo`D0o`000P3ooolA0?l000h0oooo1P3o000O0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G`3oool:07l0O`80oooo201o07l`0?ooo`D0o`00203oool50?l000H0oooo
1@3o00020?oooa40o`003@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`T0O`1o1`3oool307l0Oc40oooo1@3o00080?ooo`D0o`001P3oool50?l00080oooo203o
00001@3oool0o`000?l0003o0000oooo00<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1H0?ooo`@0O`1o0`3oool807l0Oc`0oooo1@3o00090?ooo`<0o`001P3o
ool50?l000<0oooo2@3o00040?ooo`<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`1@0?ooo`<0O`1o103oool807l0O`030?ooo`1o07l0O`1o00H0O`1o3`3oool3
07l0ObX0oooo0`3o000C0?ooo`D0o`000`3oool:0?l00080oooo1@3o000>0?ooo`<0o`008P3oool1
00000040oooo000=0?ooo`D000000`3oool00`000000oooo0?ooo`1?0?ooo`D0O`1o0P3oool:07l0
O`030?ooo`1o07l0O`1o00P0O`1o2`3oool507l0Obl0oooo0`3o00080?ooo`<0o`000P3oool50?l0
00<0oooo2P3o00020?ooo`D0o`002`3oool30?l002D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo04l0oooo1@1o07l20?ooo`X0O`1o0P3oool:07l0O`X0
oooo1@1o07lU0?ooo`<0o`001P3oool50?l000<0oooo3@3o00030?ooo`/0o`000P3oool50?l000X0
oooo1P3o000S0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool200000500oooo
1P1o07l00`3oool0O`1o07l0O`0807l0O`030?ooo`1o07l0O`1o00T0O`1o2P3oool507l0Ob@0oooo
1@3o00050?ooo`D0o`000P3oool?0?l00080oooo2P3o00040?ooo`<0o`002`3oool70?l00240oooo
0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo0`1o
07lo0?ooo`H0O`1o00@0oooo07l0O`1o07l0O`1o0P3oool307l0O`80oooo2`1o07l80?ooo`H0O`1o
9@3oool50?l000D0oooo1@3o00020?ooo`l0o`000P3oool90?l000P0oooo0`3o00080?ooo`L0o`00
8P3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3o
ool507l0OcH0oooo0`1o07l40?ooo`L0O`1o2`3oool:07l0O`P0oooo1@1o07lW0?ooo`D0o`001P3o
ool30?l00080oooo403o00030?ooo`T0o`001P3oool50?l000@0oooo0`3o00000`3oool0o`000?l0
00040?l00280oooo0@0000010?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool03@3oool5
07l0OcD0oooo1@1o07l20?ooo`P0O`1o00@0oooo07l0O`1o07l0O`1o0P3oool:07l0O`P0oooo0`1o
07l20?ooo`D0O`1o:03oool30?l000040?ooo`3o0000o`000?l000L0oooo403o00040?ooo`X0o`00
1@3oool50?l000<0oooo1@3o00020?ooo`<0o`008`3oool100000040oooo000E0?ooo`030000003o
ool0oooo00d0oooo1@1o07le0?ooo`D0O`1o0P3oool707l0O`030?ooo`1o07l0O`1o0140O`1o103o
ool507l0O`030?ooo`1o07l0O`1o00<0O`1o:`3oool50?l000H0oooo3@3o00060?ooo`D0o`0000<0
oooo0?l0003o00000`3o00050?ooo`D0o`000`3oool50?l002P0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0>0?ooo`<0O`1o=P3oool507l0O`80oooo1@1o07l30?oooa@0O`1o0`3oool5
07l0O`80oooo0`1o07l/0?ooo`H0o`001@3oool=0?l000H0oooo1@3o00000`3oool0o`000?l00003
0?l000H0oooo0`3o00040?ooo`D0o`00:03oool100000040oooo000E0?ooo`030000003oool0oooo
03P0oooo0`1o07l=0?ooo`<0O`1o103oool307l0O`@0oooo501o07l30?ooo`H0O`1o<03oool60?l0
00H0oooo0`3o00020?ooo`L0o`001P3oool:0?l000l0oooo0`3o000Y0?ooo`4000000@3oool001D0
oooo0P00000h0?ooo`D0O`1o6`3oool307l0O`80oooo3P1o07l40?ooo`D0O`1o0`3oool307l0O`T0
oooo0`1o07lO0?ooo`D0o`003P3oool30?l000P0oooo0`3o00000`3oool0o`000?l000030?l000L0
oooo0`3o000`0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0=`3oool507l0Oa@0oooo
0`1o07l80?ooo`l0O`1o0`3oool607l0O`80oooo1@1o07l70?ooo`D0O`1o7`3oool30?l001d0oooo
1P3o00020?ooo`<0o`0000<0oooo0?l0003o00000`3o000`0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=`3oool507l0Oa80oooo1P1o07l60?oooa00O`1o0P3oool607l0O`<0oooo1@1o
07l70?ooo`D0O`1o4`3oool30?l002T0oooo1@3o00020?ooo`X0o`002`3oool40?l00240oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`<0O`1o2P3oool307l0O`D0oooo1`1o07l6
0?oooa00O`1o0P3oool807l0O`030?ooo`1o07l0O`1o00<0O`1o1`3oool507l0Oa80oooo1@3o000X
0?ooo`D0o`000P3oool:0?l000X0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0@P3oool707l0O`@0oooo1`1o07l20?ooo`<0O`1o00<0oooo07l0O`1o07l0101o07l01@3o
ool0O`1o07l0O`1o07l0oooo00D0O`1o0P3oool907l0O`040?ooo`1o07l0O`1o07l0O`T0oooo0`1o
07lC0?ooo`D0o`00:@3oool50?l000030?ooo`3o0000o`0000<0o`0000@0oooo0?l0003o0000o`00
2`3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`110?ooo`P0O`1o103o
ool607l0O`80oooo1@1o07l00`3oool0O`1o07l0O`0207l0O`050?ooo`1o07l0O`1o07l0O`3oool0
1@1o07l30?ooo`T0O`1o8`3oool50?l001T0oooo0`3o000>0?ooo`D0o`0000@0oooo0?l0003o0000
o`00203oool30?l000D0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
@@3oool807l0O`D0oooo0`1o07l40?ooo`L0O`1o0`3oool:07l0O`<0oooo2@1o07lB0?ooo`<0O`1o
3`3oool30?l000/0oooo0`3o000;0?ooo`P0o`000`3oool30?l000@0oooo1@3o00000`3oool0o`00
0?l000030?l000D0oooo1@3o00050?ooo`@0o`008@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0440oooo1`1o07l=0?ooo`P0O`1o0P3oool:07l0O`<0oooo201o07lB0?ooo`D0O`1o6`3o
ool50?l000X0oooo2@3o00000`3oool0o`000?l000050?l000030?ooo`3o0000o`0000X0o`00103o
ool50?l000H0oooo0`3o000Q0?ooo`4000000@3oool001D0oooo0P0000130?ooo`<0O`1o4@3oool7
07l0O`80oooo2@1o07l50?ooo`H0O`1o4`3oool507l0Oa/0oooo1@3o00020?ooo`<0o`0000D0oooo
0?l0003o0000o`000?ooo`090?l000030?ooo`3o0000o`0000H0o`0000D0oooo0?l0003o0000o`00
0?ooo`070?l000@0oooo1@3o00050?ooo`D0o`007`3oool200000040oooo000E0?ooo`030000003o
ool0oooo05P0oooo1@1o07l30?ooo`H0O`1o1`3oool307l0OaH0oooo1@1o07lK0?ooo`D0o`0000<0
oooo0?l0003o00001`3o00000`3oool0o`000?l000060?l000030?ooo`3o0000o`0000H0o`001@3o
ool70?l000D0oooo0`3o00060?ooo`D0o`00803oool100000040oooo000E0?ooo`030000003oool0
oooo04d0oooo0`1o07l90?ooo`<0O`1o0`3oool607l0O`L0oooo1@1o07lF0?ooo`<0O`1o7@3oool3
0?l00080oooo303o00020?ooo`<0o`000`3oool70?l000H0oooo1@3o000?0?ooo`P0o`007@3oool1
00000040oooo000E0?ooo`030000003oool0oooo04`0oooo1@1o07l>0?ooo`D0O`1o203oool507l0
O`<00?l0>03oool=0?l000X0oooo1@3o000J0?ooo`P0o`00703oool100000040oooo000E0?ooo`03
0000003oool0oooo03T0oooo0`00o`0@0?ooo`D0O`1o3P3oool507l0O`P0oooo1@1o07l4003o03P0
oooo0`3o00000`3oool0o`000?l000060?l000X0oooo1@3o000E0?ooo`<0o`001@3oool50?l001`0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`D00?l03`3oool507l0O`l0oooo
0`1o07l2003o00P0oooo0`1o07l5003o03l0oooo1@3o000:0?ooo`D0o`002@3oool30?l000P0oooo
1@3o00040?ooo`D0o`00703oool100000040oooo000E0?ooo`030000003oool0oooo03P0oooo1@00
o`0@0?ooo`<0O`1o4@3oool5003o00P0oooo2000o`0o0?ooo`<0o`00303oool30?l000T0oooo1@3o
00070?ooo`D0o`001@3oool30?l001d0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h
0?ooo`D00?l02`3oool3003o01H0oooo1@00o`090?ooo`P00?l0A@3oool30?l00140oooo1@3o0007
0?ooo`D0o`009@3oool100000040oooo000E0?ooo`800000>P3oool3003o00/0oooo1@00o`0E0?oo
o`D00?l01`3oool3003o0080oooo1@00o`140?ooo`D0o`00403oool50?l000P0oooo0`3o000U0?oo
o`8000000@3oool001D0oooo00<000000?ooo`3oool0A`3oool5003o00L0oooo0`00o`00103oool0
0?l0003o0000o`080?ooo`D00?l01@3oool5003o00030?ooo`00o`000?l000<00?l0A03oool50?l0
0140oooo0`3o000b0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0=@3oool3003o00l0
oooo1@00o`060?ooo`T00?l01`3oool6003o00@0oooo1@00o`020?ooo`<00?l0A@3oool50?l004H0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0d0?ooo`D00?l03`3oool3003o00L0oooo
2@00o`070?ooo`P00?l00P3oool5003o04/0oooo0`3o00170?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=03oool5003o01T0oooo2@00o`070?ooo`T00?l00P3oool3003o00040?ooo`00
o`000?l0003o0980oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0d0?ooo`D00?l06P3o
ool3003o00040?ooo`00o`000?l0003o00P0oooo2@00o`030?ooo`L00?l08`3oool30000oc<0oooo
0`3o000e0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0=03oool5003o00040?ooo`00
o`000?l0003o02<0oooo2`00o`020?ooo`P00?l000@0oooo003o0000o`000?l02@3oool3003o0180
oooo1@000?l50?ooo`<0003o8P3oool30?l000@0oooo1@3o000d0?ooo`4000000@3oool001D0oooo
0P00000f0?ooo`<00?l000<0oooo003o0000o`000`00o`0Q0?ooo`L00?l000D0oooo003o0000o`00
0?l00?ooo`0?003o00L0oooo1@00o`0A0?ooo`D0003o103oool50000ob00oooo1@3o00030?ooo`D0
o`00<`3oool200000040oooo000E0?ooo`030000003oool0oooo03T0oooo1@00o`0Q0?ooo`L00?l0
0P3oool<003o00030?ooo`00o`000?l000<00?l01`3oool5003o0140oooo1@000?l40?ooo`D0003o
803oool50?l000<0oooo1@3o000d0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07P3o
ool3003o01P0oooo1@00o`0Q0?oooa800?l00`3oool6003o00L0oooo1@00o`0B0?ooo`<0003o1@3o
ool50000ob00oooo1@3o00040?ooo`<0o`00;P3oool30?l000@0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0M0?ooo`D00?l0603oool3003o00d0oooo0`00o`0B0?oooa400?l0103oool5
003o00T0oooo0`00o`0L0?ooo`<0003o2@3oool30000oaH0oooo0`3o000e0?ooo`D0o`000`3oool1
00000040oooo000E0?ooo`030000003oool0oooo01d0oooo1@00o`0T0?ooo`P00?l04P3ooolA003o
0080oooo1P00o`0c0?ooo`D0003oC@3oool50?l000<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0M0?ooo`D00?l08`3oool9003o00050?ooo`00o`000?l0003o003oool00`00o`0:0?oo
oaP00?l0=03oool50000odd0oooo1@3o00030?ooo`4000000@3oool000030?ooo`000000000000<0
00000P3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo01h0oooo0`00o`0T0?oooa80
0?l01`3ooolI003o03D0oooo1@000?m>0?ooo`<0o`00103oool100000040oooo00030?ooo`030000
003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`150?oooaD0
0?l00`3ooolJ003o01L0oooo0`00o`0K0?ooo`D0003oE@3oool100000040oooo00030?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool2000004L0oooo0`00o`000`3oool00?l0
003o000Q003o00030?ooo`00o`000?l000H00?l00`3oool3003o0140oooo1@00o`0J0?ooo`D0003o
E03oool200000040oooo00030?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000003o
ool0oooo04/0oooo1`00o`000`3oool00?l0003o000H003o00@0oooo1P00o`000`3oool00?l0003o
0003003o0100oooo1@00o`0K0?ooo`<0003o903oool30000obl0oooo0@0000010?ooo`000`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0BP3oool6
003o00H0oooo5`00o`050?ooo`D00?l000<0oooo003o0000o`000`00o`0@0?ooo`D00?l0@@3oool5
0000obh0oooo0@0000010?ooo`000P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo
04X0oooo1P00o`070?oooaD00?l01@3oool6003o00030?ooo`00o`000?l000<00?l04@3oool3003o
0140oooo0`000?l^0?ooo`D0003o;P3oool100000040oooo000E0?ooo`030000003oool0oooo04P0
oooo1`00o`090?ooo`H00?l00P3oool;003o00D0oooo1P00o`030?ooo`<00?l09@3oool50000oaT0
oooo0`000?lA0?ooo`D0003o;P3oool100000040oooo000E0?ooo`030000003oool0oooo04L0oooo
1`00o`0:0?ooo`D00?l0103oool;003o00@0oooo1@00o`0/0?ooo`D0003o603oool50000oa40oooo
0`000?l_0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0A`3oool5003o00`0oooo1@00
o`040?ooo`d00?l00P3oool:003o02L0oooo1@000?l;0?ooo`<0003o2P3oool50000od<0oooo0@00
00010?ooo`005@3oool2000004P0oooo1@00o`0<0?ooo`D00?l00P3oool@003o00030?ooo`00o`00
0?l000T00?l09`3oool30000o`/0oooo1@000?l90?ooo`D0003o@P3oool200000040oooo000E0?oo
o`030000003oool0oooo04P0oooo0`00o`0>0?ooo`<00?l00P3oool9003o00030?ooo`00o`000?l0
00D00?l000<0oooo003o0000o`002@00o`0e0?ooo`D0003o2P3oool30000od@0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`1M0?ooo`T00?l00`3ooolB003o02P0oooo0`000?l30?ooo`<0
003o103oool50000oe40oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1M0?ooo`H00?l0
203oool?003o02P0oooo2`000?l30?ooo`D0003o00@0oooo0000o`000?l0003oC@3oool100000040
oooo000E0?ooo`030000003oool0oooo05d0oooo1@00o`0<0?ooo`/00?l0:@3oool;0000o`030?oo
o`000?l0003o00X0003oC03oool100000040oooo000E0?ooo`030000003oool0oooo05h0oooo0`00
o`0=0?ooo`/00?l00`3oool3003o0200oooo6`000?lL0?ooo`<0003o;@3oool100000040oooo000E
0?ooo`030000003oool0oooo05`0oooo0`00o`0@0?ooo`<00?l000<0oooo003o0000o`001000o`02
0?ooo`D00?l07P3oool>0000o`030?ooo`000?l0003o00/0003o6`3oool50000ob`0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`1K0?ooo`D00?l0103oool3003o00`0oooo1@00o`030?oo
o`D00?l0703ooolM0000oa`0oooo1@000?l/0?ooo`4000000@3oool001D0oooo0P00001L0?ooo`L0
0?l000<0oooo003o0000o`000`00o`0<0?ooo`<00?l0103oool5003o01/0oooo70000?lN0?ooo`D0
003o:`3oool200000040oooo000E0?ooo`030000003oool0oooo05/0oooo3@00o`0D0?ooo`<00?l0
703oool90000o`030?ooo`000?l0003o0100003o7`3oool30000obd0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1L0?ooo``00?l0<`3ooolL0000o`H0oooo0`000?m60?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0GP3oool5003o00040?ooo`00o`000?l0003o00d0oooo0`00
o`0U0?oooa/0003o1@3oool50000odD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1M
0?ooo`D00?l04@3oool5003o02D0oooo0`000?l00`3oool0003o0000o`0D0000o`D0oooo1P000?m4
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G03oool5003o0180oooo1@00o`0Y0?oo
oaD0003o1P3oool70000od<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L0?ooo`D0
0?l04P3oool5003o02P0oooo5P000?l70?ooo`H0003o@`3oool100000040oooo000E0?ooo`800000
G@3oool7003o0140oooo0`00o`0I0?ooo`<0003o3@3ooolF0000o`P0oooo1@000?m20?ooo`800000
0@3oool001D0oooo00<000000?ooo`3oool0@P3oool3003o01P0oooo1`00o`0[0?ooo`D0003o303o
oolE0000o`X0oooo0`000?m40?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0@@3oool5
003o01T0oooo1P00o`0Z0?ooo`D0003o3@3ooolC0000o`030?ooo`000?l0003o00@0003oB`3oool1
00000040oooo000E0?ooo`030000003oool0oooo0440oooo1@00o`0I0?ooo`H00?l0:P3oool50000
o`l0oooo1`000?l00`3oool0003o0000o`060000o`030?ooo`000?l0003o00H0003oBP3oool10000
0040oooo000E0?ooo`030000003oool0oooo0440oooo1@00o`0J0?ooo`D00?l0:`3oool30000oa00
oooo20000?l20?ooo`H0003o00<0oooo0000o`000?l01P000?m:0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0@P3oool3003o01`0oooo0`00o`100?ooo`P0003o0P3oool50000o`030?oo
o`000?l0003o00H0003oBP3oool100000040oooo000E0?ooo`030000003oool0oooo0:L0oooo1@00
0?l20?ooo`D0003o0P3oool60000od/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2W
0?ooo`D0003o0P3oool50000oe<0oooo0@0000010?ooo`005@3oool2000009X0oooo1P000?l90?oo
o`@0003o0P3oool50000oe80oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`2H0?ooo`P0
003o203oool50000o`80oooo0`000?mD0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
V03oool80000o`P0oooo1@000?mI0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0V03o
ool80000o`P0oooo1@000?mI0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0V@3oool6
0000o`X0oooo0`000?mJ0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?oo
o`4000000@3oool000d0oooo100000040?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3oool70?ooo`400000
0@3oool000h0oooo00<000000?ooo`3oool0103oool200000;L0oooo0`000?m<0?ooo`8000000@3o
ool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2e0?ooo`D0003oC03oool1
00000040oooo000=0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0>`3oool3
003o07L0oooo1@000?m<0?ooo`4000000@3oool000h0oooo0P0000050?ooo`030000003oool0oooo
03X0oooo1@00o`1f0?ooo`D0003oC03oool100000040oooo000E0?ooo`030000003oool0oooo03X0
oooo1@00o`1g0?ooo`<0003oC@3oool100000040oooo000E0?ooo`030000003oool0oooo03X0oooo
1@00o`370?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>`3oool3003o0<P0oooo0@00
00010?ooo`005@3oool2000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0080oooo0P0000010?ooo`005@3ooooo000000/000000@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell[TextData[{
  "Dissimilarities for Boolean vectors are typically calculated by comparing \
the elements of two Boolean vectors ",
  Cell[BoxData[
      \(TraditionalForm\`b\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\_2\)]],
  " pairwise and counting the number of true results for various Boolean \
functions applied to the pairs. It is convenient to summarize each \
dissimilarity function in terms of four sums representing the four possible \
elements of the truth table: a, the number of pairs for which ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(1\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(2\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " are both ",
  StyleBox["True", "MR"],
  "; b, the number of pairs for which ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(1\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " is ",
  StyleBox["True", "MR"],
  " but ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(2\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " is ",
  StyleBox["False", "MR"],
  "; c the number of pairs for which ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(1\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " is ",
  StyleBox["False", "MR"],
  " but ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(2\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " is ",
  StyleBox["True", "MR"],
  "; and d the number of pairs for which both ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(1\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\_\(2\_i\)\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " are ",
  StyleBox["False", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox[\(Matching  Dissimilarity\),
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                SubscriptBox[
                  StyleBox["b",
                    "TI"], "1"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "2"],
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[\(\((b + c)\)\/Length[b\_1]\),
              "MR"], Cell["simple matching", "Text"]},
          {
            StyleBox[
              RowBox[{"JaccardDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "2"]}], "]"}],
              "MR"], 
            StyleBox[\(\((b + c)\)\/\((a + b + c)\)\),
              "MR"], Cell["the Jaccard dissimilarity", "Text"]},
          {
            StyleBox[
              RowBox[{"RussleRaoDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "2"]}], "]"}],
              "MR"], 
            StyleBox[\(\(b + c + d\)\/Length[b\_1]\),
              "MR"], Cell["the Russle-Rao dissimilarity", "Text"]},
          {
            StyleBox[
              RowBox[{"SokalSneathDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "2"]}], "]"}],
              "MR"], 
            StyleBox[\(\(2 \((b + c)\)\)\/\(2 \((b + c)\) + a\)\),
              "MR"], Cell["the Sokal-Sneath dissimilarity", "Text"]},
          {
            StyleBox[
              RowBox[{"RogersTanimotoDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "2"]}], "]"}],
              "MR"], 
            StyleBox[\(\(2 \((b + c)\)\)\/\(2 \((b + c)\) + a + d\)\),
              "MR"], Cell["the Rogers-Tanimoto dissimilarity", "Text"]},
          {
            StyleBox[
              RowBox[{"DiceDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "2"]}], "]"}],
              "MR"], 
            StyleBox[\(\((b + c)\)\/\(2  a + b + c\)\),
              "MR"], Cell["the Dice dissimilarity", "Text"]},
          {
            StyleBox[
              RowBox[{"YuleDissimilarity", "[", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "1"], ",", 
                  SubscriptBox[
                    StyleBox["b",
                      "TI"], "2"]}], "]"}],
              "MR"], 
            StyleBox[\(\(2  bc\)\/\(ad + bc\)\),
              "MR"], Cell["the Yule dissimilarity ", "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnAlignments->{Right, Center, Left}}],

Cell["Dissimilarity functions for Boolean data.", "Caption"],

Cell["Here is some Boolean data.", "MathCaption"],

Cell[BoxData[
    \(\(bdata = {{False, False, False, False, False, True, False, False, 
            True, True}, {True, False, False, False, False, False, False, 
            False, False, True}, {True, False, False, True, False, False, 
            True, False, True, True}, {True, True, False, False, True, False, 
            False, False, True, True}, {True, True, False, False, True, True, 
            True, True, True, True}};\)\)], "Input",
  CellLabel->"In[17]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["\<\
These are the clusters found using the default dissimilarity for Boolean \
data.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindClusters[bdata]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \({{{False, False, False, False, False, True, False, False, True, 
          True}}, {{True, False, False, False, False, False, False, False, 
          False, True}, {True, False, False, True, False, False, True, False, 
          True, True}, {True, True, False, False, True, False, False, False, 
          True, True}, {True, True, False, False, True, True, True, True, 
          True, True}}}\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["EditDistance",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                SubscriptBox[
                  StyleBox["s",
                    "TI"], "1"], 
                StyleBox[",",
                  "MR"], 
                SubscriptBox[
                  StyleBox["s",
                    "TI"], "2"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "computes", " ", "the", " ", "number", " ", "of", " ", "edits", 
              " ", "to", " ", "transform", " ", "string", " ", 
              SubscriptBox[
                StyleBox["s",
                  "TI"], "1"], " ", "into", " ", "string", " ", 
              SubscriptBox[
                StyleBox["s",
                  "TI"], "2"]}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["Dissimilarity function for string data.", "Caption"],

Cell["\<\
The edit distance is determined by counting the number of deletions, \
insertions, and substitutions required to transform one string into another \
while preserving the ordering of characters.\
\>", "Text"],

Cell["Here is some string data.", "MathCaption"],

Cell[BoxData[
    \(\(sdata = {"\<The\>", "\<quick\>", "\<brown\>", "\<fox\>", "\<jumps\>", \
"\<over\>", "\<the\>", "\<lazy\>", "\<dog\>"};\)\)], "Input",
  CellLabel->"In[19]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["This clusters the string data.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindClusters[sdata]\)], "Input",
  CellLabel->"In[20]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \({{"The", "fox", "over", "the", "lazy", "dog"}, {"quick", "brown", 
        "jumps"}}\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Method", "MR"],
  " option can be used to specify different methods of clustering."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["\"Agglomerate\"", "MR"]], "Text"], Cell[
            "find clustering heirarchically", "Text"]},
          {Cell[TextData[StyleBox[
            "\"Optimize\"", "MR"]], 
              "Text"], \(find\ clustering\ by\ local\ optimization\)}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Explicit settings for the ",
  StyleBox["Method", "MR"],
  " option."
}], "Caption"],

Cell[TextData[{
  "The methods ",
  StyleBox["\"Agglomerate\"", "MR"],
  " and ",
  StyleBox["\"Optimize\"", "MR"],
  " determine how to cluster the data for a particular number of clusters ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(k\)\(.\)\)\)]],
  " ",
  StyleBox["\"Agglomerate\"", "MR"],
  " uses an ",
  ButtonBox["agglomerative hierarchical method",
    ButtonData:>"Agglomerate",
    ButtonStyle->"Hyperlink"],
  " starting with each member of the set in a cluster of its own and fusing \
nearest clusters until there are ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " remaining. ",
  StyleBox["\"Optimize\"", "MR"],
  " starts by building a set of ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " representative objects and clustering around those, iterating until a \
(locally) optimal clustering is found. The default ",
  StyleBox["\"Optimize\"", "MR"],
  " method is based on partitioning around medoids [",
  ButtonBox["1",
    ButtonData:>"KR90",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "Additional ",
  StyleBox["Method", "MR"],
  " suboptions are available to allow for more control over the clustering.",
  " ",
  "Available suboptions depend on the ",
  StyleBox["Method", "MR"],
  " chosen."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\"",
              StyleBox["SignificanceTest", "MR"],
              "\""
            }], "Text"], Cell[
            "test for identifying the best number of clusters", "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["Suboption for all methods.", "Caption"],

Cell[TextData[{
  "For a given set of data and distance function, the choice of the best \
number of clusters ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(k\)\(\ \)\)\)]],
  "may be unclear. With ",
  StyleBox["Method->{methodname,\"SignificanceTest\"->\"stest\"}", "MR"],
  ", ",
  StyleBox["\"stest\"", "MR"],
  " is used to determine statistically significant clusters to help choose an \
appropriate number of them. Possible values of ",
  StyleBox["\"stest\"", "MR"],
  " are ",
  StyleBox["\"Silhouette\"", "MR"],
  " and ",
  StyleBox["\"Gap\"", "MR"],
  ". The ",
  StyleBox["\"Silhouette\"", "MR"],
  " test uses the silhouette statistic [",
  ButtonBox["2",
    ButtonData:>"R87",
    ButtonStyle->"Hyperlink"],
  "] to test how well data are clustered. The ",
  StyleBox["\"Gap\"", "MR"],
  " test uses the gap statistic [",
  ButtonBox["3",
    ButtonData:>"TWH00",
    ButtonStyle->"Hyperlink"],
  "] to determine how well data are clustered."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["\"Silhouette\"", "MR"],
  " test subdivides the data into successively more clusters looking for the \
first minimum of the silhouette statistic."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["\"Gap\"", "MR"],
  " test compares the dispersion of clusters generated from the data to that \
derived from a sample of null hypothesis sets. The null hypothesis sets are \
uniformly randomly distributed data in the box defined by the principal \
components of the input data. The ",
  StyleBox["\"Gap\"", "MR"],
  " method takes two suboptions: ",
  StyleBox["\"NullSets\"", "MR"],
  " and ",
  StyleBox["\"Tolerance\"", "MR"],
  ". The suboption ",
  StyleBox["\"NullSets\"", "MR"],
  " sets the number of null hypothesis sets to compare with the input data. \
The option ",
  StyleBox["\"Tolerance\"", "MR"],
  " sets the sensitivity. Typically larger values of ",
  StyleBox["\"Tolerance\"", "MR"],
  " will favor fewer clusters being chosen.",
  " ",
  "The default settings are ",
  StyleBox["\"NullSets\"->5", "MR"],
  " and ",
  StyleBox["\"Tolerance\"->1", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  "This shows the result of clustering ",
  StyleBox["datapairs", "MR"],
  " using the ",
  StyleBox["\"Silhouette\"", "MR"],
  " test."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[
        FindClusters[datapairs, 
          Method \[Rule] {Automatic, \ "\<SignificanceTest\>" -> \
"\<Silhouette\>"}]];\)\)], "Input",
  CellLabel->"In[21]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.74339 .20901 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.63111 .26316 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.76855 .29221 Mdot
.64184 .24847 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.68066 .3047 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.69671 .23691 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.66926 .24111 Mdot
.76788 .34998 Mdot
.61911 .30613 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.65701 .29945 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.67529 .26694 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.68588 .15456 Mdot
.71085 .30459 Mdot
.75343 .22417 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
.59365 .34236 Mdot
.48614 .12625 Mdot
.58581 .26062 Mdot
0 0 1 r
.82053 .49726 Mdot
.76051 .41915 Mdot
.58727 .41465 Mdot
.81575 .4557 Mdot
.73644 .46735 Mdot
.55655 .53432 Mdot
.54869 .44925 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
0 1 0 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.4277 .36836 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.23057 .38102 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.50457 .41568 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.30997 .34212 Mdot
.46226 .4736 Mdot
.36299 .33887 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.31611 .33914 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.50655 .33632 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.35128 .3572 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.35204 .29427 Mdot
.45339 .47461 Mdot
.46924 .23893 Mdot
.38991 .40728 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.41883 .25293 Mdot
.12969 .4303 Mdot
.46806 .26461 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.51064 .25923 Mdot
.37319 .20988 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.3901 .21179 Mdot
.36788 .33111 Mdot
.43167 .32106 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.39434 .26552 Mdot
.32447 .30993 Mdot
.3944 .27361 Mdot
.30618 .37235 Mdot
.43209 .27502 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.39048 .33085 Mdot
.32957 .39806 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.21578 .40395 Mdot
.37563 .24168 Mdot
.23747 .60332 Mdot
.39062 .3288 Mdot
.44919 .45135 Mdot
.34568 .29468 Mdot
.45596 .42689 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43464 .32716 Mdot
.43534 .37683 Mdot
.38168 .28503 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.43823 .34941 Mdot
.40259 .46445 Mdot
.3932 .32665 Mdot
.42653 .34969 Mdot
.38127 .3321 Mdot
.44956 .22897 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.37706 .28113 Mdot
.39253 .39693 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.46494 .29543 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.3757 .25456 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.48314 .49626 Mdot
.38565 .12838 Mdot
.22581 .33042 Mdot
.43989 .34764 Mdot
.44256 .43831 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30?l005X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@3o001I0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50?l005T0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0o`00FP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool3003o01P0oooo0`3o00260?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool5003o01H0oooo1@3o00250?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L00?l0503oool50?l008@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P00?l04`3oool50?l008D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L00?l0503oool30?l008H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
0?l0W@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`00o`2N0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30?l00540oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@3o001?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30?l00540oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool3003o09@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool5003o09<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool5003o09@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D00?l0L03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<00?l0L03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`00o`1B0?ooo`<0
o`00;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<00?l0
2P3oool5003o0500oooo1@3o000[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<00?l09`3oool5003o00T0oooo1@00o`0>0?ooo`<00?l000@0
oooo003o0000o`000?l0>`3oool50?l001/0oooo0`3o000<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?l09P3oool5003o00T0oooo1@00
o`0=0?ooo`T00?l0>P3oool50?l001X0oooo1@3o000;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?l09P3oool5003o00X0oooo0`00o`0>
0?ooo`T00?l0>`3oool30?l001/0oooo1@3o000;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@00o`0W0?ooo`<00?l0703oool9003o05T0oooo1@3o000<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
0?l0B03oool3003o00040?ooo`00o`000?l0003o05/0oooo1P3o000E0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`00o`0@0?ooo`<00?l0C@3oool50?l001D0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool5003o00h0oooo
1@00o`1<0?ooo`L0o`005`3oool30?l00280oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`D00?l03P3oool5003o0380oooo0`3o00090?ooo`<0o`002`3oool80?l003/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D00?l03P3oool5003o00040?ooo`00o`00
0?l0003o02d0oooo1@3o0000103oool0o`000?l0003o00030?ooo`D0o`002`3oool70?l003/0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D00?l03`3oool3003o00030?ooo`00
o`000?l000<00?l0;03oool:0?l00080oooo1@3o000=0?ooo`D0o`00>`3oool100000040oooo000E
0?ooo`030000003oool0oooo05h0oooo1P00o`0C0?ooo`D00?l0:P3oool<0?l00080oooo1@3o0000
103oool0o`000?l0003o000:0?ooo`<0o`00?03oool100000040oooo000E0?ooo`800000A@3oool3
003o01L0oooo1P00o`070?ooo`<00?l02@3oool5003o02T0oooo1`3o00000`3oool0o`000?l00003
0?l000<0oooo0`3o00000`3oool0o`000?l000030?l000H0oooo0`3o00040?ooo`<0o`004@3oool3
0?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<00?l01@3oool7003o
01@0oooo1@00o`070?ooo`D00?l02@3oool3003o02X0oooo1@3o00040?ooo`<0o`00203oool50?l0
00D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`D00?l0103oool8003o00l0oooo0`00o`020?ooo`D00?l01P3oool5003o01@0
oooo0`00o`0A0?ooo`<0o`00203oool80?l000l0oooo203o00020?ooo`D0o`000P3oool50?l000l0
oooo1@3o000S0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>P3oool5003o00<0oooo
2@00o`0>0?ooo`D00?l000<0oooo003o0000o`000`00o`060?ooo`D00?l02@3oool3003o00L0oooo
1@00o`0?0?ooo`D0o`001P3oool80?l00140oooo203o00000`3oool0o`000?l000040?l000030?oo
o`3o0000o`0000<0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0j0?ooo`D00?l00`3oool9003o00h0oooo1@00o`000`3oool00?l0003o0003003o00040?ooo`00
o`000?l0003o00<0oooo0`00o`090?ooo`D00?l01P3oool5003o00l0oooo1@3o00060?ooo`H0o`00
203oool30?l000P0oooo203o00020?ooo`D0o`000P3oool30?l00140oooo0`3o000T0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>`3oool3003o00@0oooo2000o`0?0?ooo`D00?l00P3o
ool3003o00030?ooo`00o`000?l000<00?l00P3oool3003o00T0oooo1@00o`060?ooo`D00?l03`3o
ool50?l000H0oooo1P3o00070?ooo`D0o`00203oool70?l00080oooo1@3o00040?ooo`<0o`004`3o
ool30?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`130?ooo`<00?l0503oool3
003o00L0oooo1@00o`000`3oool00?l0003o0006003o00D0oooo1@00o`070?ooo`<00?l04@3oool3
0?l000P0oooo1@3o00070?ooo`D0o`002`3oool30?l000@0oooo0`3o00030?ooo`L0o`00403oool5
0?l001l0oooo0@0000010?ooo`005@3oool2000006D0oooo1@00o`000`3oool00?l0003o0007003o
00D0oooo0`00o`0X0?ooo`<0o`00203oool60?l000P0oooo0`3o00040?ooo`H0o`0000<0oooo0?l0
003o00001`3o000?0?ooo`D0o`007P3oool200000040oooo000E0?ooo`030000003oool0oooo0600
oooo0`00o`000`3oool00?l0003o0003003o00030?ooo`00o`000?l000L00?l0<@3oool30?l000P0
oooo1P3o00060?ooo`D0o`000P3ooolA0?l000h0oooo1P3o000O0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G`3oool:003o0080oooo2000o`0`0?ooo`D0o`00203oool50?l000H0oooo
1@3o00020?oooa40o`003@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`T00?l01`3oool3003o0340oooo1@3o00080?ooo`D0o`001P3oool50?l00080oooo203o
00001@3oool0o`000?l0003o0000oooo00<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1H0?ooo`@00?l00`3oool8003o03`0oooo1@3o00090?ooo`<0o`001P3o
ool50?l000<0oooo2@3o00040?ooo`<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`1@0?ooo`<00?l0103oool8003o00030?ooo`00o`000?l000H00?l03`3oool3
003o02X0oooo0`3o000C0?ooo`D0o`000`3oool:0?l00080oooo1@3o000>0?ooo`<0o`008P3oool1
00000040oooo000=0?ooo`D000000`3oool00`000000oooo0?ooo`1?0?ooo`D00?l00P3oool:003o
00030?ooo`00o`000?l000P00?l02`3oool5003o02l0oooo0`3o00080?ooo`<0o`000P3oool50?l0
00<0oooo2P3o00020?ooo`D0o`002`3oool30?l002D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo04l0oooo1@00o`020?ooo`X00?l00P3oool:003o00X0
oooo1@00o`0U0?ooo`<0o`001P3oool50?l000<0oooo3@3o00030?ooo`/0o`000P3oool50?l000X0
oooo1P3o000S0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool200000500oooo
1P00o`000`3oool00?l0003o0008003o00030?ooo`00o`000?l000T00?l02P3oool5003o02@0oooo
1@3o00050?ooo`D0o`000P3oool?0?l00080oooo2P3o00040?ooo`<0o`002`3oool70?l00240oooo
0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo0`00
o`0o0?ooo`H00?l000@0oooo003o0000o`000?l00P3oool3003o0080oooo2`00o`080?ooo`H00?l0
9@3oool50?l000D0oooo1@3o00020?ooo`l0o`000P3oool90?l000P0oooo0`3o00080?ooo`L0o`00
8P3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3o
ool5003o03H0oooo0`00o`040?ooo`L00?l02`3oool:003o00P0oooo1@00o`0W0?ooo`D0o`001P3o
ool30?l00080oooo403o00030?ooo`T0o`001P3oool50?l000@0oooo0`3o00000`3oool0o`000?l0
00040?l00280oooo0@0000010?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool03@3oool5
003o03D0oooo1@00o`020?ooo`P00?l000@0oooo003o0000o`000?l00P3oool:003o00P0oooo0`00
o`020?ooo`D00?l0:03oool30?l000040?ooo`3o0000o`000?l000L0oooo403o00040?ooo`X0o`00
1@3oool50?l000<0oooo1@3o00020?ooo`<0o`008`3oool100000040oooo000E0?ooo`030000003o
ool0oooo00d0oooo1@00o`0e0?ooo`D00?l00P3oool7003o00030?ooo`00o`000?l001400?l0103o
ool5003o00030?ooo`00o`000?l000<00?l0:`3oool50?l000H0oooo3@3o00060?ooo`D0o`0000<0
oooo0?l0003o00000`3o00050?ooo`D0o`000`3oool50?l002P0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0>0?ooo`<00?l0=P3oool5003o0080oooo1@00o`030?oooa@00?l00`3oool5
003o0080oooo0`00o`0/0?ooo`H0o`001@3oool=0?l000H0oooo1@3o00000`3oool0o`000?l00003
0?l000H0oooo0`3o00040?ooo`D0o`00:03oool100000040oooo000E0?ooo`030000003oool0oooo
03P0oooo0`00o`0=0?ooo`<00?l0103oool3003o00@0oooo5000o`030?ooo`H00?l0<03oool60?l0
00H0oooo0`3o00020?ooo`L0o`001P3oool:0?l000l0oooo0`3o000Y0?ooo`4000000@3oool001D0
oooo0P00000h0?ooo`D00?l06`3oool3003o0080oooo3P00o`040?ooo`D00?l00`3oool3003o00T0
oooo0`00o`0O0?ooo`D0o`003P3oool30?l000P0oooo0`3o00000`3oool0o`000?l000030?l000L0
oooo0`3o000`0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0=`3oool5003o01@0oooo
0`00o`080?ooo`l00?l00`3oool6003o0080oooo1@00o`070?ooo`D00?l07`3oool30?l001d0oooo
1P3o00020?ooo`<0o`0000<0oooo0?l0003o00000`3o000`0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=`3oool5003o0180oooo1P00o`060?oooa000?l00P3oool6003o00<0oooo1@00
o`070?ooo`D00?l04`3oool30?l002T0oooo1@3o00020?ooo`X0o`002`3oool40?l00240oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`<00?l02P3oool3003o00D0oooo1`00o`06
0?oooa000?l00P3oool8003o00030?ooo`00o`000?l000<00?l01`3oool5003o0180oooo1@3o000X
0?ooo`D0o`000P3oool:0?l000X0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0@P3oool7003o00@0oooo1`00o`020?ooo`<00?l000<0oooo003o0000o`001000o`001@3o
ool00?l0003o0000o`00oooo00D00?l00P3oool9003o00040?ooo`00o`000?l0003o00T0oooo0`00
o`0C0?ooo`D0o`00:@3oool50?l000030?ooo`3o0000o`0000<0o`0000@0oooo0?l0003o0000o`00
2`3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`110?ooo`P00?l0103o
ool6003o0080oooo1@00o`000`3oool00?l0003o0002003o00050?ooo`00o`000?l0003o003oool0
1@00o`030?ooo`T00?l08`3oool50?l001T0oooo0`3o000>0?ooo`D0o`0000@0oooo0?l0003o0000
o`00203oool30?l000D0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
@@3oool8003o00D0oooo0`00o`040?ooo`L00?l00`3oool:003o00<0oooo2@00o`0B0?ooo`<00?l0
3`3oool30?l000/0oooo0`3o000;0?ooo`P0o`000`3oool30?l000@0oooo1@3o00000`3oool0o`00
0?l000030?l000D0oooo1@3o00050?ooo`@0o`008@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0440oooo1`00o`0=0?ooo`P00?l00P3oool:003o00<0oooo2000o`0B0?ooo`D00?l06`3o
ool50?l000X0oooo2@3o00000`3oool0o`000?l000050?l000030?ooo`3o0000o`0000X0o`00103o
ool50?l000H0oooo0`3o000Q0?ooo`4000000@3oool001D0oooo0P0000130?ooo`<00?l04@3oool7
003o0080oooo2@00o`050?ooo`H00?l04`3oool5003o01/0oooo1@3o00020?ooo`<0o`0000D0oooo
0?l0003o0000o`000?ooo`090?l000030?ooo`3o0000o`0000H0o`0000D0oooo0?l0003o0000o`00
0?ooo`070?l000@0oooo1@3o00050?ooo`D0o`007`3oool200000040oooo000E0?ooo`030000003o
ool0oooo05P0oooo1@00o`030?ooo`H00?l01`3oool3003o01H0oooo1@00o`0K0?ooo`D0o`0000<0
oooo0?l0003o00001`3o00000`3oool0o`000?l000060?l000030?ooo`3o0000o`0000H0o`001@3o
ool70?l000D0oooo0`3o00060?ooo`D0o`00803oool100000040oooo000E0?ooo`030000003oool0
oooo04d0oooo0`00o`090?ooo`<00?l00`3oool6003o00L0oooo1@00o`0F0?ooo`<00?l07@3oool3
0?l00080oooo303o00020?ooo`<0o`000`3oool70?l000H0oooo1@3o000?0?ooo`P0o`007@3oool1
00000040oooo000E0?ooo`030000003oool0oooo04`0oooo1@00o`0>0?ooo`D00?l0203oool8003o
03P0oooo3@3o000:0?ooo`D0o`006P3oool80?l001`0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0i0?ooo`<00?l0403oool5003o00h0oooo1@00o`080?ooo`T00?l0>03oool30?l00003
0?ooo`3o0000o`0000H0o`002P3oool50?l001D0oooo0`3o00050?ooo`D0o`00703oool100000040
oooo000E0?ooo`030000003oool0oooo03P0oooo1@00o`0?0?ooo`D00?l03`3oool5003o00P0oooo
2000o`0o0?ooo`D0o`002P3oool50?l000T0oooo0`3o00080?ooo`D0o`00103oool50?l001`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`D00?l0403oool3003o0140oooo1@00
o`080?ooo`P00?l0?`3oool30?l000`0oooo0`3o00090?ooo`D0o`001`3oool50?l000D0oooo0`3o
000M0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>03oool5003o00/0oooo0`00o`0F
0?ooo`D00?l02@3oool8003o04D0oooo0`3o000A0?ooo`D0o`001`3oool50?l002D0oooo0@000001
0?ooo`005@3oool2000003X0oooo0`00o`0;0?ooo`D00?l05@3oool5003o00L0oooo0`00o`020?oo
o`D00?l0A03oool50?l00100oooo1@3o00080?ooo`<0o`009@3oool200000040oooo000E0?ooo`03
0000003oool0oooo04L0oooo1@00o`070?ooo`<00?l000@0oooo003o0000o`000?l0203oool5003o
00D0oooo1@00o`000`3oool00?l0003o0003003o04@0oooo1@3o000A0?ooo`<0o`00<P3oool10000
0040oooo000E0?ooo`030000003oool0oooo03D0oooo0`00o`0?0?ooo`D00?l01P3oool9003o00L0
oooo1P00o`040?ooo`D00?l00P3oool3003o04D0oooo1@3o00160?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0=03oool5003o00l0oooo0`00o`070?ooo`T00?l01`3oool8003o0080oooo
1@00o`1;0?ooo`<0o`00A`3oool100000040oooo000E0?ooo`030000003oool0oooo03@0oooo1@00
o`0I0?ooo`T00?l01`3oool9003o0080oooo0`00o`00103oool00?l0003o0000o`2B0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0=03oool5003o01X0oooo0`00o`00103oool00?l0003o
0000o`080?ooo`T00?l00`3oool7003o02<0oooo0`000?lc0?ooo`<0o`00=@3oool100000040oooo
000E0?ooo`030000003oool0oooo03@0oooo1@00o`00103oool00?l0003o0000o`0S0?ooo`/00?l0
0P3oool8003o00040?ooo`00o`000?l0003o00T0oooo0`00o`0B0?ooo`D0003o1@3oool30000ob80
oooo0`000?l40?ooo`D0o`00=03oool100000040oooo000E0?ooo`800000=P3oool3003o00030?oo
o`00o`000?l000<00?l08@3oool7003o00050?ooo`00o`000?l0003o003oool03`00o`070?ooo`D0
0?l04@3oool50000o`@0oooo1@000?lP0?ooo`D0003o0`3oool50?l003<0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`0i0?ooo`D00?l08@3oool7003o0080oooo3000o`000`3oool00?l0
003o0003003o00L0oooo1@00o`0A0?ooo`D0003o103oool50000ob00oooo1@000?l30?ooo`D0o`00
=03oool100000040oooo000E0?ooo`030000003oool0oooo01h0oooo0`00o`0H0?ooo`D00?l08@3o
oolB003o00<0oooo1P00o`070?ooo`D00?l04P3oool30000o`D0oooo1@000?lP0?ooo`D0003o103o
ool30?l002h0oooo0`3o00040?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool5
003o01P0oooo0`00o`0=0?ooo`<00?l04P3ooolA003o00@0oooo1@00o`090?ooo`<00?l0703oool3
0000o`T0oooo0`000?lF0?ooo`<0003o=@3oool50?l000<0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`0M0?ooo`D00?l0903oool8003o0180oooo4@00o`020?ooo`H00?l0<`3oool50000
odd0oooo1@3o00030?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool5003o02<0
oooo2@00o`001@3oool00?l0003o0000o`00oooo00<00?l02P3ooolH003o03@0oooo1@000?m=0?oo
o`D0o`000`3oool100000040oooo00000`3oool000000000000300000080oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`0N0?ooo`<00?l0903ooolB003o00L0oooo6@00o`0e0?ooo`D0
003oCP3oool30?l000@0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0A@3ooolE003o00<0oooo6P00o`0G0?ooo`<0
003o6`3oool50000oeD0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0080oooo0P0000170?ooo`<00?l000<0oooo003o0000o`008@00o`000`3oool00?l0
003o0006003o00<0oooo0`00o`0A0?ooo`D0003o6P3oool50000oe@0oooo0P0000010?ooo`000`3o
ool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`1;0?ooo`L00?l000<0
oooo003o0000o`006000o`040?ooo`H00?l000<0oooo003o0000o`000`00o`0@0?ooo`D0003o6`3o
ool30000ob@0oooo0`000?l_0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo04X0oooo1P00o`060?oooaL00?l01@3oool5
003o00030?ooo`00o`000?l000<00?l0403oool50000od40oooo1@000?l^0?ooo`4000000@3oool0
0080oooo0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`1:0?ooo`H00?l01`3ooolE003o
00D0oooo1P00o`000`3oool00?l0003o0003003o0140oooo0`000?lA0?ooo`<0003o;P3oool50000
obh0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`180?ooo`L00?l02@3oool6003o0080
oooo2`00o`050?ooo`H00?l00`3oool3003o02D0oooo1@000?lI0?ooo`<0003o4@3oool50000obh0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`170?ooo`L00?l02P3oool5003o00@0oooo
2`00o`040?ooo`D00?l0;03oool50000oaP0oooo1@000?lA0?ooo`<0003o;`3oool100000040oooo
000E0?ooo`030000003oool0oooo04L0oooo1@00o`0<0?ooo`D00?l0103oool=003o0080oooo2P00
o`0W0?ooo`D0003o2`3oool30000o`X0oooo1@000?m30?ooo`4000000@3oool001D0oooo0P000018
0?ooo`D00?l0303oool5003o0080oooo4000o`000`3oool00?l0003o0009003o02L0oooo0`000?l;
0?ooo`D0003o2@3oool50000od80oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`180?oo
o`<00?l03P3oool3003o0080oooo2@00o`000`3oool00?l0003o0005003o00030?ooo`00o`000?l0
00T00?l0=@3oool50000o`X0oooo0`000?m40?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0G@3oool9003o00<0oooo4P00o`0X0?ooo`<0003o0`3oool30000o`@0oooo1@000?mA0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0G@3oool6003o00P0oooo3`00o`0X0?ooo`/0003o
0`3oool50000o`040?ooo`000?l0003o0000odd0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`1M0?ooo`D00?l0303oool;003o02T0oooo2`000?l00`3oool0003o0000o`0:0000od`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`<00?l03@3oool;003o00<0oooo0`00
o`0P0?oooa/0003o703oool30000obd0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L
0?ooo`<00?l0403oool3003o00030?ooo`00o`000?l000@00?l00P3oool5003o01h0oooo3P000?l0
0`3oool0003o0000o`0;0000oa/0oooo1@000?l/0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0F`3oool5003o00@0oooo0`00o`0<0?ooo`D00?l00`3oool5003o01`0oooo7@000?lL0?oo
o`D0003o;03oool100000040oooo000E0?ooo`800000G03oool7003o00030?ooo`00o`000?l000<0
0?l0303oool3003o00@0oooo1@00o`0K0?oooa`0003o7P3oool50000ob/0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`1K0?ooo`d00?l0503oool3003o01`0oooo2@000?l00`3oool0003o
0000o`0@0000oal0oooo0`000?l]0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G03o
ool<003o03<0oooo70000?l60?ooo`<0003oAP3oool100000040oooo000E0?ooo`030000003oool0
oooo05h0oooo1@00o`00103oool00?l0003o0000o`0=0?ooo`<00?l09@3ooolK0000o`D0oooo1@00
0?m50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G@3oool5003o0140oooo1@00o`0U
0?ooo`<0003o00<0oooo0000o`000?l050000?l50?ooo`H0003oA03oool100000040oooo000E0?oo
o`030000003oool0oooo05`0oooo1@00o`0B0?ooo`D00?l0:@3ooolE0000o`H0oooo1`000?m30?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0G03oool5003o0180oooo1@00o`0X0?oooaH0
003o1`3oool60000od<0oooo0@0000010?ooo`005@3oool2000005d0oooo1`00o`0A0?ooo`<00?l0
6@3oool30000o`d0oooo5P000?l80?ooo`D0003o@P3oool200000040oooo000E0?ooo`030000003o
ool0oooo0480oooo0`00o`0H0?ooo`L00?l0:`3oool50000o``0oooo5@000?l:0?ooo`<0003oA03o
ool100000040oooo000E0?ooo`030000003oool0oooo0440oooo1@00o`0I0?ooo`H00?l0:P3oool5
0000o`d0oooo4`000?l00`3oool0003o0000o`040000od/0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`110?ooo`D00?l06@3oool6003o02X0oooo1@000?l?0?ooo`L0003o00<0oooo0000
o`000?l01P000?l00`3oool0003o0000o`060000odX0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`110?ooo`D00?l06P3oool5003o02/0oooo0`000?l@0?ooo`P0003o0P3oool60000o`03
0?ooo`000?l0003o00H0003oBP3oool100000040oooo000E0?ooo`030000003oool0oooo0480oooo
0`00o`0L0?ooo`<00?l0@03oool80000o`80oooo1@000?l00`3oool0003o0000o`060000odX0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`2W0?ooo`D0003o0P3oool50000o`80oooo1P00
0?m;0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0Y`3oool50000o`80oooo1@000?mC
0?ooo`4000000@3oool001D0oooo0P00002J0?ooo`H0003o2@3oool40000o`80oooo1@000?mB0?oo
o`8000000@3oool001D0oooo00<000000?ooo`3oool0V03oool80000o`P0oooo1@000?l20?ooo`<0
003oE03oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo20000?l80?ooo`D0003o
F@3oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo20000?l80?ooo`D0003oF@3o
ool100000040oooo000E0?ooo`030000003oool0oooo09T0oooo1P000?l:0?ooo`<0003oFP3oool1
00000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000=0?ooo`@0
0000103oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`003@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000>0?ooo`030000003o
ool0oooo00@0oooo0P00002g0?ooo`<0003oC03oool200000040oooo000?0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0]@3oool50000od`0oooo0@0000010?ooo`003@3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo03/0oooo0`00o`1g0?ooo`D0003oC03oool1
00000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0MP3oool50000
od`0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0M`3oool30000odd0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0a`3oool100000040oooo
000E0?ooo`030000003oool0oooo03/0oooo0`00o`380?ooo`4000000@3oool001D0oooo0P000004
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`02
0?ooo`8000000@3oool001D0ooooo`00000;00000040oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell[TextData[{
  "Here are the clusters found using the ",
  StyleBox["\"Gap\"", "MR"],
  " test with the tolerance parameter set to 3.",
  " ",
  "The larger value leads to fewer clusters being selected."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[
        FindClusters[datapairs, 
          Method \[Rule] {Automatic, \ "\<SignificanceTest\>" \[Rule] {"\<Gap\
\>", "\<Tolerance\>" \[Rule] 3}}]];\)\)], "Input",
  CellLabel->"In[22]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.74339 .20901 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.63111 .26316 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.76855 .29221 Mdot
.64184 .24847 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.68066 .3047 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.69671 .23691 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.66926 .24111 Mdot
.76788 .34998 Mdot
.61911 .30613 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.65701 .29945 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.67529 .26694 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.68588 .15456 Mdot
.71085 .30459 Mdot
.75343 .22417 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
.59365 .34236 Mdot
.48614 .12625 Mdot
.58581 .26062 Mdot
0 0 1 r
.82053 .49726 Mdot
.76051 .41915 Mdot
.58727 .41465 Mdot
.81575 .4557 Mdot
.73644 .46735 Mdot
.55655 .53432 Mdot
.54869 .44925 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
0 1 0 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.4277 .36836 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.23057 .38102 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.50457 .41568 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.30997 .34212 Mdot
.46226 .4736 Mdot
.36299 .33887 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.31611 .33914 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.50655 .33632 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.35128 .3572 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.35204 .29427 Mdot
.45339 .47461 Mdot
.46924 .23893 Mdot
.38991 .40728 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.41883 .25293 Mdot
.12969 .4303 Mdot
.46806 .26461 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.51064 .25923 Mdot
.37319 .20988 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.3901 .21179 Mdot
.36788 .33111 Mdot
.43167 .32106 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.39434 .26552 Mdot
.32447 .30993 Mdot
.3944 .27361 Mdot
.30618 .37235 Mdot
.43209 .27502 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.39048 .33085 Mdot
.32957 .39806 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.21578 .40395 Mdot
.37563 .24168 Mdot
.23747 .60332 Mdot
.39062 .3288 Mdot
.44919 .45135 Mdot
.34568 .29468 Mdot
.45596 .42689 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43464 .32716 Mdot
.43534 .37683 Mdot
.38168 .28503 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.43823 .34941 Mdot
.40259 .46445 Mdot
.3932 .32665 Mdot
.42653 .34969 Mdot
.38127 .3321 Mdot
.44956 .22897 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.37706 .28113 Mdot
.39253 .39693 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.46494 .29543 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.3757 .25456 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.48314 .49626 Mdot
.38565 .12838 Mdot
.22581 .33042 Mdot
.43989 .34764 Mdot
.44256 .43831 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[22]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30?l005X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@3o001I0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50?l005T0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0o`00FP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool3003o01P0oooo0`3o00260?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool5003o01H0oooo1@3o00250?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L00?l0503oool50?l008@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P00?l04`3oool50?l008D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L00?l0503oool30?l008H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
0?l0W@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`00o`2N0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30?l00540oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@3o001?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30?l00540oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool3003o09@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool5003o09<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool5003o09@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D00?l0L03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<00?l0L03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`00o`1B0?ooo`<0
o`00;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<00?l0
2P3oool5003o0500oooo1@3o000[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<00?l09`3oool5003o00T0oooo1@00o`0>0?ooo`<00?l000@0
oooo003o0000o`000?l0>`3oool50?l001/0oooo0`3o000<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?l09P3oool5003o00T0oooo1@00
o`0=0?ooo`T00?l0>P3oool50?l001X0oooo1@3o000;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D00?l09P3oool5003o00X0oooo0`00o`0>
0?ooo`T00?l0>`3oool30?l001/0oooo1@3o000;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@00o`0W0?ooo`<00?l0703oool9003o05T0oooo1@3o000<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
0?l0B03oool3003o00040?ooo`00o`000?l0003o05/0oooo1P3o000E0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`00o`0@0?ooo`<00?l0C@3oool50?l001D0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool5003o00h0oooo
1@00o`1<0?ooo`L0o`005`3oool30?l00280oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`D00?l03P3oool5003o0380oooo0`3o00090?ooo`<0o`002`3oool80?l003/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D00?l03P3oool5003o00040?ooo`00o`00
0?l0003o02d0oooo1@3o0000103oool0o`000?l0003o00030?ooo`D0o`002`3oool70?l003/0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D00?l03`3oool3003o00030?ooo`00
o`000?l000<00?l0;03oool:0?l00080oooo1@3o000=0?ooo`D0o`00>`3oool100000040oooo000E
0?ooo`030000003oool0oooo05h0oooo1P00o`0C0?ooo`D00?l0:P3oool<0?l00080oooo1@3o0000
103oool0o`000?l0003o000:0?ooo`<0o`00?03oool100000040oooo000E0?ooo`800000A@3oool3
003o01L0oooo1P00o`070?ooo`<00?l02@3oool5003o02T0oooo1`3o00000`3oool0o`000?l00003
0?l000<0oooo0`3o00000`3oool0o`000?l000030?l000H0oooo0`3o00040?ooo`<0o`004@3oool3
0?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<00?l01@3oool7003o
01@0oooo1@00o`070?ooo`D00?l02@3oool3003o02X0oooo1@3o00040?ooo`<0o`00203oool50?l0
00D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`D00?l0103oool8003o00l0oooo0`00o`020?ooo`D00?l01P3oool5003o01@0
oooo0`00o`0A0?ooo`<0o`00203oool80?l000l0oooo203o00020?ooo`D0o`000P3oool50?l000l0
oooo1@3o000S0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>P3oool5003o00<0oooo
2@00o`0>0?ooo`D00?l000<0oooo003o0000o`000`00o`060?ooo`D00?l02@3oool3003o00L0oooo
1@00o`0?0?ooo`D0o`001P3oool80?l00140oooo203o00000`3oool0o`000?l000040?l000030?oo
o`3o0000o`0000<0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0j0?ooo`D00?l00`3oool9003o00h0oooo1@00o`000`3oool00?l0003o0003003o00040?ooo`00
o`000?l0003o00<0oooo0`00o`090?ooo`D00?l01P3oool5003o00l0oooo1@3o00060?ooo`H0o`00
203oool30?l000P0oooo203o00020?ooo`D0o`000P3oool30?l00140oooo0`3o000T0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>`3oool3003o00@0oooo2000o`0?0?ooo`D00?l00P3o
ool3003o00030?ooo`00o`000?l000<00?l00P3oool3003o00T0oooo1@00o`060?ooo`D00?l03`3o
ool50?l000H0oooo1P3o00070?ooo`D0o`00203oool70?l00080oooo1@3o00040?ooo`<0o`004`3o
ool30?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`130?ooo`<00?l0503oool3
003o00L0oooo1@00o`000`3oool00?l0003o0006003o00D0oooo1@00o`070?ooo`<00?l04@3oool3
0?l000P0oooo1@3o00070?ooo`D0o`002`3oool30?l000@0oooo0`3o00030?ooo`L0o`00403oool5
0?l001l0oooo0@0000010?ooo`005@3oool2000006D0oooo1@00o`000`3oool00?l0003o0007003o
00D0oooo0`00o`0X0?ooo`<0o`00203oool60?l000P0oooo0`3o00040?ooo`H0o`0000<0oooo0?l0
003o00001`3o000?0?ooo`D0o`007P3oool200000040oooo000E0?ooo`030000003oool0oooo0600
oooo0`00o`000`3oool00?l0003o0003003o00030?ooo`00o`000?l000L00?l0<@3oool30?l000P0
oooo1P3o00060?ooo`D0o`000P3ooolA0?l000h0oooo1P3o000O0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G`3oool:003o0080oooo2000o`0`0?ooo`D0o`00203oool50?l000H0oooo
1@3o00020?oooa40o`003@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`T00?l01`3oool3003o0340oooo1@3o00080?ooo`D0o`001P3oool50?l00080oooo203o
00001@3oool0o`000?l0003o0000oooo00<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1H0?ooo`@00?l00`3oool8003o03`0oooo1@3o00090?ooo`<0o`001P3o
ool50?l000<0oooo2@3o00040?ooo`<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`1@0?ooo`<00?l0103oool8003o00030?ooo`00o`000?l000H00?l03`3oool3
003o02X0oooo0`3o000C0?ooo`D0o`000`3oool:0?l00080oooo1@3o000>0?ooo`<0o`008P3oool1
00000040oooo000=0?ooo`D000000`3oool00`000000oooo0?ooo`1?0?ooo`D00?l00P3oool:003o
00030?ooo`00o`000?l000P00?l02`3oool5003o02l0oooo0`3o00080?ooo`<0o`000P3oool50?l0
00<0oooo2P3o00020?ooo`D0o`002`3oool30?l002D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo04l0oooo1@00o`020?ooo`X00?l00P3oool:003o00X0
oooo1@00o`0U0?ooo`<0o`001P3oool50?l000<0oooo3@3o00030?ooo`/0o`000P3oool50?l000X0
oooo1P3o000S0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool200000500oooo
1P00o`000`3oool00?l0003o0008003o00030?ooo`00o`000?l000T00?l02P3oool5003o02@0oooo
1@3o00050?ooo`D0o`000P3oool?0?l00080oooo2P3o00040?ooo`<0o`002`3oool70?l00240oooo
0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo0`00
o`0o0?ooo`H00?l000@0oooo003o0000o`000?l00P3oool3003o0080oooo2`00o`080?ooo`H00?l0
9@3oool50?l000D0oooo1@3o00020?ooo`l0o`000P3oool90?l000P0oooo0`3o00080?ooo`L0o`00
8P3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3o
ool5003o03H0oooo0`00o`040?ooo`L00?l02`3oool:003o00P0oooo1@00o`0W0?ooo`D0o`001P3o
ool30?l00080oooo403o00030?ooo`T0o`001P3oool50?l000@0oooo0`3o00000`3oool0o`000?l0
00040?l00280oooo0@0000010?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool03@3oool5
003o03D0oooo1@00o`020?ooo`P00?l000@0oooo003o0000o`000?l00P3oool:003o00P0oooo0`00
o`020?ooo`D00?l0:03oool30?l000040?ooo`3o0000o`000?l000L0oooo403o00040?ooo`X0o`00
1@3oool50?l000<0oooo1@3o00020?ooo`<0o`008`3oool100000040oooo000E0?ooo`030000003o
ool0oooo00d0oooo1@00o`0e0?ooo`D00?l00P3oool7003o00030?ooo`00o`000?l001400?l0103o
ool5003o00030?ooo`00o`000?l000<00?l0:`3oool50?l000H0oooo3@3o00060?ooo`D0o`0000<0
oooo0?l0003o00000`3o00050?ooo`D0o`000`3oool50?l002P0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0>0?ooo`<00?l0=P3oool5003o0080oooo1@00o`030?oooa@00?l00`3oool5
003o0080oooo0`00o`0/0?ooo`H0o`001@3oool=0?l000H0oooo1@3o00000`3oool0o`000?l00003
0?l000H0oooo0`3o00040?ooo`D0o`00:03oool100000040oooo000E0?ooo`030000003oool0oooo
03P0oooo0`00o`0=0?ooo`<00?l0103oool3003o00@0oooo5000o`030?ooo`H00?l0<03oool60?l0
00H0oooo0`3o00020?ooo`L0o`001P3oool:0?l000l0oooo0`3o000Y0?ooo`4000000@3oool001D0
oooo0P00000h0?ooo`D00?l06`3oool3003o0080oooo3P00o`040?ooo`D00?l00`3oool3003o00T0
oooo0`00o`0O0?ooo`D0o`003P3oool30?l000P0oooo0`3o00000`3oool0o`000?l000030?l000L0
oooo0`3o000`0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0=`3oool5003o01@0oooo
0`00o`080?ooo`l00?l00`3oool6003o0080oooo1@00o`070?ooo`D00?l07`3oool30?l001d0oooo
1P3o00020?ooo`<0o`0000<0oooo0?l0003o00000`3o000`0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=`3oool5003o0180oooo1P00o`060?oooa000?l00P3oool6003o00<0oooo1@00
o`070?ooo`D00?l04`3oool30?l002T0oooo1@3o00020?ooo`X0o`002`3oool40?l00240oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`<00?l02P3oool3003o00D0oooo1`00o`06
0?oooa000?l00P3oool8003o00030?ooo`00o`000?l000<00?l01`3oool5003o0180oooo1@3o000X
0?ooo`D0o`000P3oool:0?l000X0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0@P3oool7003o00@0oooo1`00o`020?ooo`<00?l000<0oooo003o0000o`001000o`001@3o
ool00?l0003o0000o`00oooo00D00?l00P3oool9003o00040?ooo`00o`000?l0003o00T0oooo0`00
o`0C0?ooo`D0o`00:@3oool50?l000030?ooo`3o0000o`0000<0o`0000@0oooo0?l0003o0000o`00
2`3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`110?ooo`P00?l0103o
ool6003o0080oooo1@00o`000`3oool00?l0003o0002003o00050?ooo`00o`000?l0003o003oool0
1@00o`030?ooo`T00?l08`3oool50?l001T0oooo0`3o000>0?ooo`D0o`0000@0oooo0?l0003o0000
o`00203oool30?l000D0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
@@3oool8003o00D0oooo0`00o`040?ooo`L00?l00`3oool:003o00<0oooo2@00o`0B0?ooo`<00?l0
3`3oool30?l000/0oooo0`3o000;0?ooo`P0o`000`3oool30?l000@0oooo1@3o00000`3oool0o`00
0?l000030?l000D0oooo1@3o00050?ooo`@0o`008@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0440oooo1`00o`0=0?ooo`P00?l00P3oool:003o00<0oooo2000o`0B0?ooo`D00?l06`3o
ool50?l000X0oooo2@3o00000`3oool0o`000?l000050?l000030?ooo`3o0000o`0000X0o`00103o
ool50?l000H0oooo0`3o000Q0?ooo`4000000@3oool001D0oooo0P0000130?ooo`<00?l04@3oool7
003o0080oooo2@00o`050?ooo`H00?l04`3oool5003o01/0oooo1@3o00020?ooo`<0o`0000D0oooo
0?l0003o0000o`000?ooo`090?l000030?ooo`3o0000o`0000H0o`0000D0oooo0?l0003o0000o`00
0?ooo`070?l000@0oooo1@3o00050?ooo`D0o`007`3oool200000040oooo000E0?ooo`030000003o
ool0oooo05P0oooo1@00o`030?ooo`H00?l01`3oool3003o01H0oooo1@00o`0K0?ooo`D0o`0000<0
oooo0?l0003o00001`3o00000`3oool0o`000?l000060?l000030?ooo`3o0000o`0000H0o`001@3o
ool70?l000D0oooo0`3o00060?ooo`D0o`00803oool100000040oooo000E0?ooo`030000003oool0
oooo04d0oooo0`00o`090?ooo`<00?l00`3oool6003o00L0oooo1@00o`0F0?ooo`<00?l07@3oool3
0?l00080oooo303o00020?ooo`<0o`000`3oool70?l000H0oooo1@3o000?0?ooo`P0o`007@3oool1
00000040oooo000E0?ooo`030000003oool0oooo04`0oooo1@00o`0>0?ooo`D00?l0203oool8003o
03P0oooo3@3o000:0?ooo`D0o`006P3oool80?l001`0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0i0?ooo`<00?l0403oool5003o00h0oooo1@00o`080?ooo`T00?l0>03oool30?l00003
0?ooo`3o0000o`0000H0o`002P3oool50?l001D0oooo0`3o00050?ooo`D0o`00703oool100000040
oooo000E0?ooo`030000003oool0oooo03P0oooo1@00o`0?0?ooo`D00?l03`3oool5003o00P0oooo
2000o`0o0?ooo`D0o`002P3oool50?l000T0oooo0`3o00080?ooo`D0o`00103oool50?l001`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`D00?l0403oool3003o0140oooo1@00
o`080?ooo`P00?l0?`3oool30?l000`0oooo0`3o00090?ooo`D0o`001`3oool50?l000D0oooo0`3o
000M0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>03oool5003o00/0oooo0`00o`0F
0?ooo`D00?l02@3oool8003o04D0oooo0`3o000A0?ooo`D0o`001`3oool50?l002D0oooo0@000001
0?ooo`005@3oool2000003X0oooo0`00o`0;0?ooo`D00?l05@3oool5003o00L0oooo0`00o`020?oo
o`D00?l0A03oool50?l00100oooo1@3o00080?ooo`<0o`009@3oool200000040oooo000E0?ooo`03
0000003oool0oooo04L0oooo1@00o`070?ooo`<00?l000@0oooo003o0000o`000?l0203oool5003o
00D0oooo1@00o`000`3oool00?l0003o0003003o04@0oooo1@3o000A0?ooo`<0o`00<P3oool10000
0040oooo000E0?ooo`030000003oool0oooo03D0oooo0`00o`0?0?ooo`D00?l01P3oool9003o00L0
oooo1P00o`040?ooo`D00?l00P3oool3003o04D0oooo1@3o00160?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0=03oool5003o00l0oooo0`00o`070?ooo`T00?l01`3oool8003o0080oooo
1@00o`1;0?ooo`<0o`00A`3oool100000040oooo000E0?ooo`030000003oool0oooo03@0oooo1@00
o`0I0?ooo`T00?l01`3oool9003o0080oooo0`00o`00103oool00?l0003o0000o`2B0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0=03oool5003o01X0oooo0`00o`00103oool00?l0003o
0000o`080?ooo`T00?l00`3oool7003o02<0oooo0`000?lc0?ooo`<0o`00=@3oool100000040oooo
000E0?ooo`030000003oool0oooo03@0oooo1@00o`00103oool00?l0003o0000o`0S0?ooo`/00?l0
0P3oool8003o00040?ooo`00o`000?l0003o00T0oooo0`00o`0B0?ooo`D0003o1@3oool30000ob80
oooo0`000?l40?ooo`D0o`00=03oool100000040oooo000E0?ooo`800000=P3oool3003o00030?oo
o`00o`000?l000<00?l08@3oool7003o00050?ooo`00o`000?l0003o003oool03`00o`070?ooo`D0
0?l04@3oool50000o`@0oooo1@000?lP0?ooo`D0003o0`3oool50?l003<0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`0i0?ooo`D00?l08@3oool7003o0080oooo3000o`000`3oool00?l0
003o0003003o00L0oooo1@00o`0A0?ooo`D0003o103oool50000ob00oooo1@000?l30?ooo`D0o`00
=03oool100000040oooo000E0?ooo`030000003oool0oooo01h0oooo0`00o`0H0?ooo`D00?l08@3o
oolB003o00<0oooo1P00o`070?ooo`D00?l04P3oool30000o`D0oooo1@000?lP0?ooo`D0003o103o
ool30?l002h0oooo0`3o00040?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool5
003o01P0oooo0`00o`0=0?ooo`<00?l04P3ooolA003o00@0oooo1@00o`090?ooo`<00?l0703oool3
0000o`T0oooo0`000?lF0?ooo`<0003o=@3oool50?l000<0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`0M0?ooo`D00?l0903oool8003o0180oooo4@00o`020?ooo`H00?l0<`3oool50000
odd0oooo1@3o00030?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool5003o02<0
oooo2@00o`001@3oool00?l0003o0000o`00oooo00<00?l02P3ooolH003o03@0oooo1@000?m=0?oo
o`D0o`000`3oool100000040oooo00000`3oool000000000000300000080oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`0N0?ooo`<00?l0903ooolB003o00L0oooo6@00o`0e0?ooo`D0
003oCP3oool30?l000@0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0A@3ooolE003o00<0oooo6P00o`0G0?ooo`<0
003o6`3oool50000oeD0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0080oooo0P0000170?ooo`<00?l000<0oooo003o0000o`008@00o`000`3oool00?l0
003o0006003o00<0oooo0`00o`0A0?ooo`D0003o6P3oool50000oe@0oooo0P0000010?ooo`000`3o
ool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`1;0?ooo`L00?l000<0
oooo003o0000o`006000o`040?ooo`H00?l000<0oooo003o0000o`000`00o`0@0?ooo`D0003o6`3o
ool30000ob@0oooo0`000?l_0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo04X0oooo1P00o`060?oooaL00?l01@3oool5
003o00030?ooo`00o`000?l000<00?l0403oool50000od40oooo1@000?l^0?ooo`4000000@3oool0
0080oooo0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`1:0?ooo`H00?l01`3ooolE003o
00D0oooo1P00o`000`3oool00?l0003o0003003o0140oooo0`000?lA0?ooo`<0003o;P3oool50000
obh0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`180?ooo`L00?l02@3oool6003o0080
oooo2`00o`050?ooo`H00?l00`3oool3003o02D0oooo1@000?lI0?ooo`<0003o4@3oool50000obh0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`170?ooo`L00?l02P3oool5003o00@0oooo
2`00o`040?ooo`D00?l0;03oool50000oaP0oooo1@000?lA0?ooo`<0003o;`3oool100000040oooo
000E0?ooo`030000003oool0oooo04L0oooo1@00o`0<0?ooo`D00?l0103oool=003o0080oooo2P00
o`0W0?ooo`D0003o2`3oool30000o`X0oooo1@000?m30?ooo`4000000@3oool001D0oooo0P000018
0?ooo`D00?l0303oool5003o0080oooo4000o`000`3oool00?l0003o0009003o02L0oooo0`000?l;
0?ooo`D0003o2@3oool50000od80oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`180?oo
o`<00?l03P3oool3003o0080oooo2@00o`000`3oool00?l0003o0005003o00030?ooo`00o`000?l0
00T00?l0=@3oool50000o`X0oooo0`000?m40?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0G@3oool9003o00<0oooo4P00o`0X0?ooo`<0003o0`3oool30000o`@0oooo1@000?mA0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0G@3oool6003o00P0oooo3`00o`0X0?ooo`/0003o
0`3oool50000o`040?ooo`000?l0003o0000odd0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`1M0?ooo`D00?l0303oool;003o02T0oooo2`000?l00`3oool0003o0000o`0:0000od`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`<00?l03@3oool;003o00<0oooo0`00
o`0P0?oooa/0003o703oool30000obd0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L
0?ooo`<00?l0403oool3003o00030?ooo`00o`000?l000@00?l00P3oool5003o01h0oooo3P000?l0
0`3oool0003o0000o`0;0000oa/0oooo1@000?l/0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0F`3oool5003o00@0oooo0`00o`0<0?ooo`D00?l00`3oool5003o01`0oooo7@000?lL0?oo
o`D0003o;03oool100000040oooo000E0?ooo`800000G03oool7003o00030?ooo`00o`000?l000<0
0?l0303oool3003o00@0oooo1@00o`0K0?oooa`0003o7P3oool50000ob/0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`1K0?ooo`d00?l0503oool3003o01`0oooo2@000?l00`3oool0003o
0000o`0@0000oal0oooo0`000?l]0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G03o
ool<003o03<0oooo70000?l60?ooo`<0003oAP3oool100000040oooo000E0?ooo`030000003oool0
oooo05h0oooo1@00o`00103oool00?l0003o0000o`0=0?ooo`<00?l09@3ooolK0000o`D0oooo1@00
0?m50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G@3oool5003o0140oooo1@00o`0U
0?ooo`<0003o00<0oooo0000o`000?l050000?l50?ooo`H0003oA03oool100000040oooo000E0?oo
o`030000003oool0oooo05`0oooo1@00o`0B0?ooo`D00?l0:@3ooolE0000o`H0oooo1`000?m30?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0G03oool5003o0180oooo1@00o`0X0?oooaH0
003o1`3oool60000od<0oooo0@0000010?ooo`005@3oool2000005d0oooo1`00o`0A0?ooo`<00?l0
6@3oool30000o`d0oooo5P000?l80?ooo`D0003o@P3oool200000040oooo000E0?ooo`030000003o
ool0oooo0480oooo0`00o`0H0?ooo`L00?l0:`3oool50000o``0oooo5@000?l:0?ooo`<0003oA03o
ool100000040oooo000E0?ooo`030000003oool0oooo0440oooo1@00o`0I0?ooo`H00?l0:P3oool5
0000o`d0oooo4`000?l00`3oool0003o0000o`040000od/0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`110?ooo`D00?l06@3oool6003o02X0oooo1@000?l?0?ooo`L0003o00<0oooo0000
o`000?l01P000?l00`3oool0003o0000o`060000odX0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`110?ooo`D00?l06P3oool5003o02/0oooo0`000?l@0?ooo`P0003o0P3oool60000o`03
0?ooo`000?l0003o00H0003oBP3oool100000040oooo000E0?ooo`030000003oool0oooo0480oooo
0`00o`0L0?ooo`<00?l0@03oool80000o`80oooo1@000?l00`3oool0003o0000o`060000odX0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`2W0?ooo`D0003o0P3oool50000o`80oooo1P00
0?m;0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0Y`3oool50000o`80oooo1@000?mC
0?ooo`4000000@3oool001D0oooo0P00002J0?ooo`H0003o2@3oool40000o`80oooo1@000?mB0?oo
o`8000000@3oool001D0oooo00<000000?ooo`3oool0V03oool80000o`P0oooo1@000?l20?ooo`<0
003oE03oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo20000?l80?ooo`D0003o
F@3oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo20000?l80?ooo`D0003oF@3o
ool100000040oooo000E0?ooo`030000003oool0oooo09T0oooo1P000?l:0?ooo`<0003oFP3oool1
00000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000=0?ooo`@0
0000103oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`003@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000>0?ooo`030000003o
ool0oooo00@0oooo0P00002g0?ooo`<0003oC03oool200000040oooo000?0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0]@3oool50000od`0oooo0@0000010?ooo`003@3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo03/0oooo0`00o`1g0?ooo`D0003oC03oool1
00000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0MP3oool50000
od`0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0M`3oool30000odd0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D00?l0a`3oool100000040oooo
000E0?ooo`030000003oool0oooo03/0oooo0`00o`380?ooo`4000000@3oool001D0oooo0P000004
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`02
0?ooo`8000000@3oool001D0ooooo`00000;00000040oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell["\<\
Note that the clusters found in these two examples are identical. \
The only difference is how the number of clusters is chosen.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\"",
              StyleBox["Linkage", "MR"],
              "\""
            }], "Text"], Cell["the clustering linkage to use", "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Suboption for ",
  StyleBox["\"Agglomerate\"", "MR"],
  " method."
}], "Caption"],

Cell[TextData[{
  "With ",
  StyleBox["Method->{\"Agglomerate\",\"Linkage\"->linkagefunction}", "MR"],
  ", the specified ",
  StyleBox["linkagefunction", "MR"],
  " is used for agglomerative clustering. Possible ",
  StyleBox["linkagefunction", "MR"],
  " values are the same as for the ",
  StyleBox[ButtonBox["Linkage",
    ButtonData:>"linkages",
    ButtonStyle->"Hyperlink"], "MR"],
  " option to the ",
  StyleBox[ButtonBox["Agglomerate",
    ButtonData:>"Agglomerate",
    ButtonStyle->"Hyperlink"], "MR"],
  " function defined in this package."
}], "Text"],

Cell["\<\
These are the clusters found using complete linkage hierarchical \
clustering.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[
        FindClusters[datapairs, 
          Method \[Rule] {"\<Agglomerate\>", "\<Linkage\>" \[Rule] \
"\<Complete\>"}]];\)\)], "Input",
  CellLabel->"In[23]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.74339 .20901 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.63111 .26316 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.82053 .49726 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.76051 .41915 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.76855 .29221 Mdot
.64184 .24847 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.68066 .3047 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.58727 .41465 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.69671 .23691 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.81575 .4557 Mdot
.66926 .24111 Mdot
.76788 .34998 Mdot
.61911 .30613 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.73644 .46735 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.65701 .29945 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.67529 .26694 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.68588 .15456 Mdot
.71085 .30459 Mdot
.75343 .22417 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
.50457 .41568 Mdot
.50655 .33632 Mdot
.55655 .53432 Mdot
.46924 .23893 Mdot
.41883 .25293 Mdot
.46806 .26461 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.51064 .25923 Mdot
.37319 .20988 Mdot
.3901 .21179 Mdot
.43167 .32106 Mdot
.39434 .26552 Mdot
.3944 .27361 Mdot
.43209 .27502 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.37563 .24168 Mdot
.43464 .32716 Mdot
.38168 .28503 Mdot
.43823 .34941 Mdot
.54869 .44925 Mdot
.42653 .34969 Mdot
.44956 .22897 Mdot
.59365 .34236 Mdot
.37706 .28113 Mdot
.46494 .29543 Mdot
.48614 .12625 Mdot
.58581 .26062 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.3757 .25456 Mdot
.38565 .12838 Mdot
.43989 .34764 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
0 0 1 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.4277 .36836 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.23057 .38102 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.30997 .34212 Mdot
.46226 .4736 Mdot
.36299 .33887 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.31611 .33914 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.35128 .3572 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.35204 .29427 Mdot
.45339 .47461 Mdot
.38991 .40728 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.12969 .4303 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.36788 .33111 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.32447 .30993 Mdot
.30618 .37235 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.39048 .33085 Mdot
.32957 .39806 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.21578 .40395 Mdot
.23747 .60332 Mdot
.39062 .3288 Mdot
.44919 .45135 Mdot
.34568 .29468 Mdot
.45596 .42689 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43534 .37683 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.40259 .46445 Mdot
.3932 .32665 Mdot
.38127 .3321 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.39253 .39693 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.48314 .49626 Mdot
.22581 .33042 Mdot
.44256 .43831 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[23]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30?l005X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@3o001I0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50?l005T0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0o`00FP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool30?l001P0oooo0`3o00260?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool50?l001H0oooo1@3o00250?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L0o`00503oool50?l008@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P0o`004`3oool50?l008D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L0o`00503oool30?l008H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
o`00W@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`3o002N0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30?l00540oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@3o001?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30?l00540oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool30?l009@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool50?l009<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool50?l009@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D0o`00L03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<0o`00L03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`000?mB0?ooo`<0
o`00;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<0003o
2P3oool50000oe00oooo1@3o000[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<0003o9`3oool50000o`T0oooo1@000?l>0?ooo`<0o`0000@0
oooo0?l0003o0000o`00>`3oool50?l001/0oooo0`3o000<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0003o9P3oool50000o`T0oooo1@00
0?l=0?ooo`T0o`00>P3oool50?l001X0oooo1@3o000;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0003o9P3oool50000o`X0oooo0`000?l>
0?ooo`T0o`00>`3oool30?l001/0oooo1@3o000;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@000?lW0?ooo`<0003o703oool90?l005T0oooo1@3o000<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
003oB03oool30?l000040?ooo`3o0000o`000?l005/0oooo1P3o000E0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`3o000@0?ooo`<0o`00C@3oool50?l001D0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool50?l000h0oooo
1@3o001<0?ooo`L0o`005`3oool30?l00280oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`D0o`003P3oool50?l00380oooo0`3o00090?ooo`<0o`002`3oool80?l003/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0o`003P3oool50?l000040?ooo`3o0000
o`000?l002d0oooo1@3o0000103oool0o`000?l0003o00030?ooo`D0o`002`3oool70?l003/0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0o`003`3oool30?l000030?ooo`3o
0000o`0000<0o`00;03oool:0?l00080oooo1@3o000=0?ooo`D0o`00>`3oool100000040oooo000E
0?ooo`030000003oool0oooo05h0oooo1P3o000C0?ooo`D0o`00:P3oool<0?l00080oooo1@3o0000
103oool0o`000?l0003o000:0?ooo`<0o`00?03oool100000040oooo000E0?ooo`800000A@3oool3
0000oaL0oooo1P3o00070?ooo`<0o`002@3oool50?l002T0oooo1`3o00000`3oool0o`000?l00003
0?l000<0oooo0`3o00000`3oool0o`000?l000030?l000H0oooo0`3o00040?ooo`<0o`004@3oool3
0?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<0003o1@3oool70000
oa@0oooo1@3o00070?ooo`D0o`002@3oool30?l002X0oooo1@3o00040?ooo`<0o`00203oool50?l0
00D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`D0003o103oool80000o`l0oooo0`3o00020?ooo`D0o`001P3oool50?l001@0
oooo0`3o000A0?ooo`<0o`00203oool80?l000l0oooo203o00020?ooo`D0o`000P3oool50?l000l0
oooo1@3o000S0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>P3oool50000o`<0oooo
2@000?l>0?ooo`D0o`0000<0oooo0?l0003o00000`3o00060?ooo`D0o`002@3oool30?l000L0oooo
1@3o000?0?ooo`D0o`001P3oool80?l00140oooo203o00000`3oool0o`000?l000040?l000030?oo
o`3o0000o`0000<0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0j0?ooo`D0003o0`3oool90000o`h0oooo1@3o00000`3oool0o`000?l000030?l000040?ooo`3o
0000o`000?l000<0oooo0`3o00090?ooo`D0o`001P3oool50?l000l0oooo1@3o00060?ooo`H0o`00
203oool30?l000P0oooo203o00020?ooo`D0o`000P3oool30?l00140oooo0`3o000T0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>`3oool30000o`@0oooo20000?l?0?ooo`D0o`000P3o
ool30?l000030?ooo`3o0000o`0000<0o`000P3oool30?l000T0oooo1@3o00060?ooo`D0o`003`3o
ool50?l000H0oooo1P3o00070?ooo`D0o`00203oool70?l00080oooo1@3o00040?ooo`<0o`004`3o
ool30?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`130?ooo`<0003o503oool3
0?l000L0oooo1@3o00000`3oool0o`000?l000060?l000D0oooo1@3o00070?ooo`<0o`004@3oool3
0?l000P0oooo1@3o00070?ooo`D0o`002`3oool30?l000@0oooo0`3o00030?ooo`L0o`00403oool5
0?l001l0oooo0@0000010?ooo`005@3oool2000006D0oooo1@3o00000`3oool0o`000?l000070?l0
00D0oooo0`3o000X0?ooo`<0o`00203oool60?l000P0oooo0`3o00040?ooo`H0o`0000<0oooo0?l0
003o00001`3o000?0?ooo`D0o`007P3oool200000040oooo000E0?ooo`030000003oool0oooo0600
oooo0`3o00000`3oool0o`000?l000030?l000030?ooo`3o0000o`0000L0o`00<@3oool30?l000P0
oooo1P3o00060?ooo`D0o`000P3ooolA0?l000h0oooo1P3o000O0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G`3oool:0?l00080oooo203o000`0?ooo`D0o`00203oool50?l000H0oooo
1@3o00020?oooa40o`003@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`T0o`001`3oool30?l00340oooo1@3o00080?ooo`D0o`001P3oool50?l00080oooo203o
00001@3oool0o`000?l0003o0000oooo00<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1H0?ooo`@0003o0`3oool50?l000<0003o?03oool50?l000T0oooo0`3o
00060?ooo`D0o`000`3oool90?l000@0oooo0`3o000>0?ooo`D0o`008@3oool100000040oooo000E
0?ooo`030000003oool0oooo0500oooo0`000?l40?ooo`P0003o00@0oooo0?l0003o0000o`001@00
0?l?0?ooo`<0o`00:P3oool30?l001<0oooo1@3o00030?ooo`X0o`000P3oool50?l000h0oooo0`3o
000R0?ooo`4000000@3oool000d0oooo1@0000030?ooo`030000003oool0oooo04l0oooo1@000?l2
0?ooo`X0003o00<0oooo0?l0003o000020000?l;0?ooo`D0o`00;`3oool30?l000P0oooo0`3o0002
0?ooo`D0o`000`3oool:0?l00080oooo1@3o000;0?ooo`<0o`009@3oool100000040oooo000?0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0C`3oool50000o`80oooo2P000?l20?oo
o`X0003o2P3oool50?l002D0oooo0`3o00060?ooo`D0o`000`3oool=0?l000<0oooo2`3o00020?oo
o`D0o`002P3oool60?l002<0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`80
0000D03oool60000o`030?ooo`000?l0003o00P0003o00<0oooo0000o`000?l02@000?l:0?ooo`D0
o`00903oool50?l000D0oooo1@3o00020?ooo`l0o`000P3oool:0?l000@0oooo0`3o000;0?ooo`L0
o`008@3oool200000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
3P3oool30000ocl0oooo1P000?l0103oool0003o0000o`000?l20?ooo`<0003o0P3oool;0000o`P0
oooo1P3o000U0?ooo`D0o`001@3oool50?l00080oooo3`3o00020?ooo`T0o`00203oool30?l000P0
oooo1`3o000R0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0=0?ooo`D0003o=P3oool30000o`@0oooo1`000?l;0?ooo`X0003o203oool50?l002L0oooo
1@3o00060?ooo`<0o`000P3oool@0?l000<0oooo2@3o00060?ooo`D0o`00103oool30?l000030?oo
o`3o0000o`0000@0o`008P3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?oo
o`0=0?ooo`D0003o=@3oool50000o`80oooo20000?l0103oool0003o0000o`000?l20?ooo`X0003o
203oool30?l00080oooo1@3o000X0?ooo`<0o`0000@0oooo0?l0003o0000o`001`3oool@0?l000@0
oooo2P3o00050?ooo`D0o`000`3oool50?l00080oooo0`3o000S0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool03@3oool50000ocD0oooo1@000?l20?ooo`L0003o00<0oooo0000o`000?l0
4@000?l40?ooo`D0o`0000<0oooo0?l0003o00000`3o000[0?ooo`D0o`001P3oool=0?l000H0oooo
1@3o00000`3oool0o`000?l000030?l000D0oooo1@3o00030?ooo`D0o`00:03oool100000040oooo
000E0?ooo`030000003oool0oooo00h0oooo0`000?lf0?ooo`D0003o0P3oool50000o`<0oooo5000
0?l30?ooo`D0o`000P3oool30?l002`0oooo1P3o00050?ooo`d0o`001P3oool50?l000030?ooo`3o
0000o`0000<0o`001P3oool30?l000@0oooo1@3o000X0?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool0>03oool30000o`d0oooo0`000?l40?ooo`<0003o103ooolD0000o`<0oooo1P3o000`
0?ooo`H0o`001P3oool30?l00080oooo1`3o00060?ooo`X0o`003`3oool30?l002T0oooo0@000001
0?ooo`005@3oool2000003P0oooo1@000?lK0?ooo`<0003o0P3oool>0000o`@0oooo1@3o00030?oo
o`<0o`002@3oool30?l001l0oooo1@3o000>0?ooo`<0o`00203oool30?l000030?ooo`3o0000o`00
00<0o`001`3oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0g0?ooo`D0
003o503oool30000o`P0oooo3`000?l30?ooo`H0o`000P3oool50?l000L0oooo1@3o000O0?ooo`<0
o`007@3oool60?l00080oooo0`3o00000`3oool0o`000?l000030?l00300oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`0g0?ooo`D0003o4P3oool60000o`H0oooo40000?l20?ooo`H0o`00
0`3oool50?l000L0oooo1@3o000C0?ooo`<0o`00:@3oool50?l00080oooo2P3o000;0?ooo`@0o`00
8@3oool100000040oooo000E0?ooo`030000003oool0oooo03P0oooo0`000?l:0?ooo`<0003o1@3o
ool70000o`H0oooo40000?l20?ooo`P0o`0000<0oooo0?l0003o00000`3o00070?ooo`D0o`004P3o
ool50?l002P0oooo1@3o00020?ooo`X0o`002P3oool60?l00200oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`120?ooo`L0003o103oool70000o`80oooo0`000?l00`3oool0003o0000o`04
0000o`050?ooo`000?l0003o0000o`3oool01@000?l20?ooo`T0o`0000@0oooo0?l0003o0000o`00
2@3oool30?l001<0oooo1@3o000Y0?ooo`D0o`0000<0oooo0?l0003o00000`3o0000103oool0o`00
0?l0003o000;0?ooo`H0o`00803oool100000040oooo000E0?ooo`030000003oool0oooo0440oooo
20000?l40?ooo`H0003o0P3oool50000o`030?ooo`000?l0003o0080003o00D0oooo0000o`000?l0
003o0?ooo`050000o`<0oooo2@3o000S0?ooo`D0o`006@3oool30?l000h0oooo1@3o0000103oool0
o`000?l0003o00080?ooo`<0o`001@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`110?ooo`P0003o1@3oool30000o`@0oooo1`000?l30?ooo`X0003o0`3oool90?l00180
oooo0`3o000?0?ooo`<0o`002`3oool30?l000/0oooo203o00030?ooo`<0o`00103oool50?l00003
0?ooo`3o0000o`0000<0o`001@3oool50?l000D0oooo103o000Q0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0@@3oool70000o`d0oooo20000?l20?ooo`X0003o0`3oool80?l00180oooo
1@3o000K0?ooo`D0o`002P3oool90?l000030?ooo`3o0000o`0000D0o`0000<0oooo0?l0003o0000
2P3o00040?ooo`D0o`001P3oool30?l00240oooo0@0000010?ooo`005@3oool2000004<0oooo0`00
0?lA0?ooo`L0003o0P3oool90000o`D0oooo1P3o000C0?ooo`D0o`006`3oool50?l00080oooo0`3o
00001@3oool0o`000?l0003o0000oooo00T0o`0000<0oooo0?l0003o00001P3o00001@3oool0o`00
0?l0003o0000oooo00L0o`00103oool50?l000D0oooo1@3o000O0?ooo`8000000@3oool001D0oooo
00<000000?ooo`3oool0F03oool50000o`<0oooo1P000?l70?ooo`<0003o5P3oool50?l001/0oooo
1@3o00000`3oool0o`000?l000070?l000030?ooo`3o0000o`0000H0o`0000<0oooo0?l0003o0000
1P3o00050?ooo`L0o`001@3oool30?l000H0oooo1@3o000P0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0C@3oool30000o`T0oooo0`000?l30?ooo`H0003o1`3oool50000oaH0oooo0`3o
000M0?ooo`<0o`000P3oool<0?l00080oooo0`3o00030?ooo`L0o`001P3oool50?l000l0oooo203o
000M0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0C03oool50000o`h0oooo1@000?l8
0?ooo`P0003o>03oool=0?l000X0oooo1@3o000J0?ooo`P0o`00703oool100000040oooo000E0?oo
o`030000003oool0oooo03T0oooo0`000?l@0?ooo`D0003o3P3oool50000o`P0oooo2@000?lh0?oo
o`<0o`0000<0oooo0?l0003o00001P3o000:0?ooo`D0o`005@3oool30?l000D0oooo1@3o000L0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0>03oool50000o`l0oooo1@000?l?0?ooo`D0
003o203oool80000ocl0oooo1@3o000:0?ooo`D0o`002@3oool30?l000P0oooo1@3o00040?ooo`D0
o`00703oool100000040oooo000E0?ooo`030000003oool0oooo03P0oooo1@000?l@0?ooo`<0003o
4@3oool50000o`P0oooo20000?lo0?ooo`<0o`00303oool30?l000T0oooo1@3o00070?ooo`D0o`00
1@3oool30?l001d0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`D0003o2`3o
ool30000oaH0oooo1@000?l90?ooo`P0003oA@3oool30?l00140oooo1@3o00070?ooo`D0o`009@3o
ool100000040oooo000E0?ooo`800000>P3oool30000o`/0oooo1@000?lE0?ooo`D0003o1`3oool3
0000o`80oooo1@000?m40?ooo`D0o`00403oool50?l000P0oooo0`3o000U0?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool0A`3oool50000o`L0oooo0`000?l0103oool0003o0000o`000?l8
0?ooo`D0003o1@3oool50000o`030?ooo`000?l0003o00<0003oA03oool50?l00140oooo0`3o000b
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0=@3oool30000o`l0oooo1@000?l60?oo
o`T0003o1`3oool60000o`@0oooo1@000?l20?ooo`<0003oA@3oool50?l004H0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`0d0?ooo`D0003o3`3oool30000o`L0oooo2@000?l70?ooo`P0
003o0P3oool50000od/0oooo0`3o00170?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
=03oool50000oaT0oooo2@000?l70?ooo`T0003o0P3oool30000o`040?ooo`000?l0003o0000oi80
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0d0?ooo`D0003o6P3oool30000o`040?oo
o`000?l0003o0000o`P0oooo2@000?l30?ooo`L0003o8`3oool30?l003<0oooo0`3o000e0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0=03oool50000o`040?ooo`000?l0003o0000ob<0
oooo2`000?l20?ooo`P0003o00@0oooo0000o`000?l0003o2@3oool30?l00180oooo1@3o00050?oo
o`<0o`008P3oool30?l000@0oooo1@3o000d0?ooo`4000000@3oool001D0oooo0P00000f0?ooo`<0
003o00<0oooo0000o`000?l00`000?lQ0?ooo`L0003o00D0oooo0000o`000?l0003o0?ooo`0?0000
o`L0oooo1@3o000A0?ooo`D0o`00103oool50?l00200oooo1@3o00030?ooo`D0o`00<`3oool20000
0040oooo000E0?ooo`030000003oool0oooo03T0oooo1@000?lQ0?ooo`L0003o0P3oool<0000o`03
0?ooo`000?l0003o00<0003o1`3oool50?l00140oooo1@3o00040?ooo`D0o`00803oool50?l000<0
oooo1@3o000d0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07P3oool30000oaP0oooo
1@000?lQ0?oooa80003o0`3oool60000o`L0oooo1@3o000B0?ooo`<0o`001@3oool50?l00200oooo
1@3o00040?ooo`<0o`00;P3oool30?l000@0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0M0?ooo`D0003o603oool30000o`d0oooo0`000?lB0?oooa40003o103oool50000o`T0oooo0`3o
000L0?ooo`<0o`002@3oool30?l001H0oooo0`3o000e0?ooo`D0o`000`3oool100000040oooo000E
0?ooo`030000003oool0oooo01d0oooo1@000?lT0?ooo`P0003o4P3ooolA0000o`80oooo1P000?lc
0?ooo`D0o`00C@3oool50?l000<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0M0?oo
o`D0003o8`3oool90000o`050?ooo`000?l0003o0000o`3oool00`000?l:0?oooaP0003o=03oool5
0?l004d0oooo1@3o00030?ooo`4000000@3oool000030?ooo`000000000000<000000P3oool20000
00@0oooo0P0000050?ooo`030000003oool0oooo01h0oooo0`000?lT0?oooa80003o1`3ooolI0000
ocD0oooo1@3o001>0?ooo`<0o`00103oool100000040oooo00030?ooo`030000003oool0oooo00L0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`150?oooaD0003o0`3ooolJ0000
oaL0oooo0`3o000K0?ooo`D0o`00E@3oool100000040oooo00030?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool00P3oool2000004L0oooo0`000?l00`3oool0003o0000o`0Q0000o`03
0?ooo`000?l0003o00H0003o0`3oool30000oa40oooo1@3o000J0?ooo`D0o`00E03oool200000040
oooo00030?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000003oool0oooo04/0oooo
1`000?l00`3oool0003o0000o`0H0000o`@0oooo1P000?l00`3oool0003o0000o`030000oa00oooo
1@3o000K0?ooo`<0o`00903oool30?l002l0oooo0@0000010?ooo`000`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0BP3oool60000o`H0oooo5`00
0?l50?ooo`D0003o00<0oooo0000o`000?l00`000?l@0?ooo`D0o`00@@3oool50?l002h0oooo0@00
00010?ooo`000P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo04X0oooo1P000?l7
0?oooaD0003o1@3oool60000o`030?ooo`000?l0003o00<0003o4@3oool30?l00140oooo0`3o000^
0?ooo`D0o`00;P3oool100000040oooo000E0?ooo`030000003oool0oooo04P0oooo1`000?l90?oo
o`H0003o0P3oool;0000o`D0oooo1P000?l30?ooo`<0003o9@3oool50?l001T0oooo0`3o000A0?oo
o`D0o`00;P3oool100000040oooo000E0?ooo`030000003oool0oooo04L0oooo1`000?l:0?ooo`D0
003o103oool;0000o`@0oooo1@000?l/0?ooo`D0o`00603oool50?l00140oooo0`3o000_0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0A`3oool50000o``0oooo1@000?l40?ooo`d0003o
0P3oool:0000obL0oooo1@3o000;0?ooo`<0o`002P3oool50?l004<0oooo0@0000010?ooo`005@3o
ool2000004P0oooo1@000?l<0?ooo`D0003o0P3oool@0000o`030?ooo`000?l0003o00T0003o9`3o
ool30?l000/0oooo1@3o00090?ooo`D0o`00@P3oool200000040oooo000E0?ooo`030000003oool0
oooo04P0oooo0`000?l>0?ooo`<0003o0P3oool90000o`030?ooo`000?l0003o00D0003o00<0oooo
0000o`000?l02@000?le0?ooo`D0o`002P3oool30?l004@0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`1M0?ooo`T0003o0`3ooolB0000obP0oooo0`3o00030?ooo`<0o`00103oool50?l0
0540oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1M0?ooo`H0003o203oool?0000obP0
oooo2`3o00030?ooo`D0o`0000@0oooo0?l0003o0000o`00C@3oool100000040oooo000E0?ooo`03
0000003oool0oooo05d0oooo1@000?l<0?ooo`/0003o:@3oool;0?l000030?ooo`3o0000o`0000X0
o`00C03oool100000040oooo000E0?ooo`030000003oool0oooo05h0oooo0`000?l=0?ooo`/0003o
0`3oool30000ob00oooo6`3o000L0?ooo`<0o`00;@3oool100000040oooo000E0?ooo`030000003o
ool0oooo05`0oooo0`000?l@0?ooo`<0003o00<0oooo0000o`000?l010000?l20?ooo`D0003o7P3o
ool>0?l000030?ooo`3o0000o`0000/0o`006`3oool50?l002`0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`1K0?ooo`D0003o103oool30000o``0oooo1@000?l30?ooo`D0003o703ooolM
0?l001`0oooo1@3o000/0?ooo`4000000@3oool001D0oooo0P00001L0?ooo`L0003o00<0oooo0000
o`000?l00`000?l<0?ooo`<0003o103oool50000oa/0oooo703o000N0?ooo`D0o`00:`3oool20000
0040oooo000E0?ooo`030000003oool0oooo05/0oooo3@000?lD0?ooo`<0003o703oool90?l00003
0?ooo`3o0000o`000100o`007`3oool30?l002d0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`1L0?ooo``0003o<`3ooolL0?l000H0oooo0`3o00160?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0GP3oool50000o`040?ooo`000?l0003o0000o`d0oooo0`000?lU0?oooa/0o`00
1@3oool50?l004D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1M0?ooo`D0003o4@3o
ool50000obD0oooo0`3o00000`3oool0o`000?l0000D0?l000D0oooo1P3o00140?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0G03oool50000oa80oooo1@000?lY0?oooaD0o`001P3oool7
0?l004<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L0?ooo`D0003o4P3oool50000
obP0oooo5P3o00070?ooo`H0o`00@`3oool100000040oooo000E0?ooo`800000G@3oool70000oa40
oooo0`000?lI0?ooo`<0o`003@3ooolF0?l000P0oooo1@3o00120?ooo`8000000@3oool001D0oooo
00<000000?ooo`3oool0@P3oool30000oaP0oooo1`000?l[0?ooo`D0o`00303ooolE0?l000X0oooo
0`3o00140?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0@@3oool50000oaT0oooo1P00
0?lZ0?ooo`D0o`003@3ooolC0?l000030?ooo`3o0000o`0000@0o`00B`3oool100000040oooo000E
0?ooo`030000003oool0oooo0440oooo1@000?lI0?ooo`H0003o:P3oool50?l000l0oooo1`3o0000
0`3oool0o`000?l000060?l000030?ooo`3o0000o`0000H0o`00BP3oool100000040oooo000E0?oo
o`030000003oool0oooo0440oooo1@000?lJ0?ooo`D0003o:`3oool30?l00100oooo203o00020?oo
o`H0o`0000<0oooo0?l0003o00001P3o001:0?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0@P3oool30000oa`0oooo0`000?m00?ooo`P0o`000P3oool50?l000030?ooo`3o0000o`0000H0
o`00BP3oool100000040oooo000E0?ooo`030000003oool0oooo0:L0oooo1@3o00020?ooo`D0o`00
0P3oool60?l004/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2W0?ooo`D0o`000P3o
ool50?l005<0oooo0@0000010?ooo`005@3oool2000009X0oooo1P3o00090?ooo`@0o`000P3oool5
0?l00580oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`2H0?ooo`P0o`00203oool50?l0
0080oooo0`3o001D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0V03oool80?l000P0
oooo1@3o001I0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0V03oool80?l000P0oooo
1@3o001I0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0V@3oool60?l000X0oooo0`3o
001J0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
00d0oooo100000040?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000=0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool000h0oooo
00<000000?ooo`3oool0103oool200000;L0oooo0`3o001<0?ooo`8000000@3oool000l0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`2e0?ooo`D0o`00C03oool100000040oooo000=
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0>`3oool30000ogL0oooo1@3o
001<0?ooo`4000000@3oool000h0oooo0P0000050?ooo`030000003oool0oooo03X0oooo1@000?mf
0?ooo`D0o`00C03oool100000040oooo000E0?ooo`030000003oool0oooo03X0oooo1@000?mg0?oo
o`<0o`00C@3oool100000040oooo000E0?ooo`030000003oool0oooo03X0oooo1@000?o70?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0>`3oool30000olP0oooo0@0000010?ooo`005@3o
ool2000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0080oooo0P0000010?ooo`005@3ooooo000000/000000@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\"",
              StyleBox["Iterations", "MR"],
              "\""
            }], "Text"], Cell[
            "the maximum number of iterations to use", "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Suboption for ",
  StyleBox["\"Optimize\"", "MR"],
  " method."
}], "Caption"],

Cell[TextData[{
  "Here are the clusters determined from a single iteration of the ",
  StyleBox["\"Optimize\"", "MR"],
  " method."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ClusterPlot[
        FindClusters[datapairs, 
          Method \[Rule] {"\<Optimize\>", "\<Iterations\>" \[Rule] 
                1}]];\)\)], "Input",
  CellLabel->"In[24]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.366902 0.0147151 0.285293 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.20726 -0.0125 -9 -9 ]
[.20726 -0.0125 9 0 ]
[.39071 -0.0125 -3 -9 ]
[.39071 -0.0125 3 0 ]
[.57416 -0.0125 -9 -9 ]
[.57416 -0.0125 9 0 ]
[.75761 -0.0125 -3 -9 ]
[.75761 -0.0125 3 0 ]
[.94107 -0.0125 -9 -9 ]
[.94107 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .15736 -18 -4.5 ]
[-0.0125 .15736 0 4.5 ]
[-0.0125 .30001 -6 -4.5 ]
[-0.0125 .30001 0 4.5 ]
[-0.0125 .44265 -18 -4.5 ]
[-0.0125 .44265 0 4.5 ]
[-0.0125 .5853 -6 -4.5 ]
[-0.0125 .5853 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.20726 0 m
.20726 .00625 L
s
[(0.5)] .20726 -0.0125 0 1 Mshowa
.39071 0 m
.39071 .00625 L
s
[(1)] .39071 -0.0125 0 1 Mshowa
.57416 0 m
.57416 .00625 L
s
[(1.5)] .57416 -0.0125 0 1 Mshowa
.75761 0 m
.75761 .00625 L
s
[(2)] .75761 -0.0125 0 1 Mshowa
.94107 0 m
.94107 .00625 L
s
[(2.5)] .94107 -0.0125 0 1 Mshowa
.125 Mabswid
.0605 0 m
.0605 .00375 L
s
.09719 0 m
.09719 .00375 L
s
.13388 0 m
.13388 .00375 L
s
.17057 0 m
.17057 .00375 L
s
.24395 0 m
.24395 .00375 L
s
.28064 0 m
.28064 .00375 L
s
.31733 0 m
.31733 .00375 L
s
.35402 0 m
.35402 .00375 L
s
.4274 0 m
.4274 .00375 L
s
.46409 0 m
.46409 .00375 L
s
.50078 0 m
.50078 .00375 L
s
.53747 0 m
.53747 .00375 L
s
.61085 0 m
.61085 .00375 L
s
.64754 0 m
.64754 .00375 L
s
.68423 0 m
.68423 .00375 L
s
.72092 0 m
.72092 .00375 L
s
.7943 0 m
.7943 .00375 L
s
.83099 0 m
.83099 .00375 L
s
.86769 0 m
.86769 .00375 L
s
.90438 0 m
.90438 .00375 L
s
.97776 0 m
.97776 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .15736 m
.00625 .15736 L
s
[(0.5)] -0.0125 .15736 1 0 Mshowa
0 .30001 m
.00625 .30001 L
s
[(1)] -0.0125 .30001 1 0 Mshowa
0 .44265 m
.00625 .44265 L
s
[(1.5)] -0.0125 .44265 1 0 Mshowa
0 .5853 m
.00625 .5853 L
s
[(2)] -0.0125 .5853 1 0 Mshowa
.125 Mabswid
0 .04324 m
.00375 .04324 L
s
0 .07177 m
.00375 .07177 L
s
0 .1003 m
.00375 .1003 L
s
0 .12883 m
.00375 .12883 L
s
0 .18589 m
.00375 .18589 L
s
0 .21442 m
.00375 .21442 L
s
0 .24295 m
.00375 .24295 L
s
0 .27148 m
.00375 .27148 L
s
0 .32854 m
.00375 .32854 L
s
0 .35707 m
.00375 .35707 L
s
0 .3856 m
.00375 .3856 L
s
0 .41413 m
.00375 .41413 L
s
0 .47118 m
.00375 .47118 L
s
0 .49971 m
.00375 .49971 L
s
0 .52824 m
.00375 .52824 L
s
0 .55677 m
.00375 .55677 L
s
0 .61383 m
.00375 .61383 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.20726 .61178 m
.20726 .61803 L
s
.39071 .61178 m
.39071 .61803 L
s
.57416 .61178 m
.57416 .61803 L
s
.75761 .61178 m
.75761 .61803 L
s
.94107 .61178 m
.94107 .61803 L
s
.125 Mabswid
.0605 .61428 m
.0605 .61803 L
s
.09719 .61428 m
.09719 .61803 L
s
.13388 .61428 m
.13388 .61803 L
s
.17057 .61428 m
.17057 .61803 L
s
.24395 .61428 m
.24395 .61803 L
s
.28064 .61428 m
.28064 .61803 L
s
.31733 .61428 m
.31733 .61803 L
s
.35402 .61428 m
.35402 .61803 L
s
.4274 .61428 m
.4274 .61803 L
s
.46409 .61428 m
.46409 .61803 L
s
.50078 .61428 m
.50078 .61803 L
s
.53747 .61428 m
.53747 .61803 L
s
.61085 .61428 m
.61085 .61803 L
s
.64754 .61428 m
.64754 .61803 L
s
.68423 .61428 m
.68423 .61803 L
s
.72092 .61428 m
.72092 .61803 L
s
.7943 .61428 m
.7943 .61803 L
s
.83099 .61428 m
.83099 .61803 L
s
.86769 .61428 m
.86769 .61803 L
s
.90438 .61428 m
.90438 .61803 L
s
.97776 .61428 m
.97776 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .15736 m
1 .15736 L
s
.99375 .30001 m
1 .30001 L
s
.99375 .44265 m
1 .44265 L
s
.99375 .5853 m
1 .5853 L
s
.125 Mabswid
.99625 .04324 m
1 .04324 L
s
.99625 .07177 m
1 .07177 L
s
.99625 .1003 m
1 .1003 L
s
.99625 .12883 m
1 .12883 L
s
.99625 .18589 m
1 .18589 L
s
.99625 .21442 m
1 .21442 L
s
.99625 .24295 m
1 .24295 L
s
.99625 .27148 m
1 .27148 L
s
.99625 .32854 m
1 .32854 L
s
.99625 .35707 m
1 .35707 L
s
.99625 .3856 m
1 .3856 L
s
.99625 .41413 m
1 .41413 L
s
.99625 .47118 m
1 .47118 L
s
.99625 .49971 m
1 .49971 L
s
.99625 .52824 m
1 .52824 L
s
.99625 .55677 m
1 .55677 L
s
.99625 .61383 m
1 .61383 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
5 Mabswid
.70414 .31891 Mdot
.71831 .30279 Mdot
.86066 .3055 Mdot
.74339 .20901 Mdot
.7623 .29067 Mdot
.83794 .31718 Mdot
.76102 .27635 Mdot
.63728 .32207 Mdot
.65371 .23705 Mdot
.79677 .35837 Mdot
.80464 .38547 Mdot
.75803 .259 Mdot
.80795 .33421 Mdot
.63111 .26316 Mdot
.69625 .37118 Mdot
.97619 .42931 Mdot
.64489 .35897 Mdot
.82053 .49726 Mdot
.86288 .21837 Mdot
.80658 .19327 Mdot
.75612 .30258 Mdot
.65108 .0892 Mdot
.71788 .24817 Mdot
.76094 .29687 Mdot
.75104 .30682 Mdot
.7204 .2905 Mdot
.7447 .30186 Mdot
.67527 .31579 Mdot
.76051 .41915 Mdot
.75003 .3605 Mdot
.76764 .316 Mdot
.72425 .27886 Mdot
.68312 .36382 Mdot
.78119 .25058 Mdot
.70256 .31285 Mdot
.68268 .27723 Mdot
.62595 .26042 Mdot
.76855 .29221 Mdot
.64184 .24847 Mdot
.80715 .3126 Mdot
.69866 .30174 Mdot
.86844 .36215 Mdot
.75299 .3016 Mdot
.75601 .29721 Mdot
.75219 .37401 Mdot
.86321 .28278 Mdot
.68066 .3047 Mdot
.77896 .27596 Mdot
.74479 .32027 Mdot
.74901 .27996 Mdot
.78815 .26917 Mdot
.72015 .25585 Mdot
.62651 .20127 Mdot
.58727 .41465 Mdot
.79564 .29354 Mdot
.84704 .21496 Mdot
.8012 .20533 Mdot
.78849 .35598 Mdot
.69671 .23691 Mdot
.75702 .30255 Mdot
.88176 .37146 Mdot
.75964 .33608 Mdot
.81575 .4557 Mdot
.66926 .24111 Mdot
.76788 .34998 Mdot
.61911 .30613 Mdot
.76604 .23237 Mdot
.8308 .35469 Mdot
.73711 .35602 Mdot
.8485 .38049 Mdot
.73644 .46735 Mdot
.69997 .35415 Mdot
.7948 .27379 Mdot
.85427 .25042 Mdot
.7305 .2602 Mdot
.65701 .29945 Mdot
.86745 .34264 Mdot
.94208 .17448 Mdot
.72351 .39159 Mdot
.76324 .32604 Mdot
.87059 .26917 Mdot
.85046 .30258 Mdot
.71485 .35721 Mdot
.67529 .26694 Mdot
.75423 .25133 Mdot
.75952 .30455 Mdot
.69449 .31686 Mdot
.79259 .41304 Mdot
.63226 .28174 Mdot
.63255 .31828 Mdot
.7879 .33881 Mdot
.85508 .20788 Mdot
.7603 .29189 Mdot
.86242 .34392 Mdot
.75016 .28933 Mdot
.68588 .15456 Mdot
.71085 .30459 Mdot
.75343 .22417 Mdot
.76169 .30016 Mdot
.66582 .36353 Mdot
.55655 .53432 Mdot
.59365 .34236 Mdot
.58581 .26062 Mdot
.63718 .48795 Mdot
.64959 .51704 Mdot
.66977 .51838 Mdot
.63856 .51614 Mdot
.60161 .50536 Mdot
.69034 .49198 Mdot
.69828 .54233 Mdot
.66539 .51364 Mdot
.65457 .50626 Mdot
.60403 .56384 Mdot
.66643 .52059 Mdot
.6657 .51428 Mdot
.67176 .53958 Mdot
.66364 .50358 Mdot
.61568 .49727 Mdot
.64591 .51186 Mdot
.67583 .54253 Mdot
.66726 .43396 Mdot
.66484 .51077 Mdot
.68024 .5041 Mdot
.63445 .52379 Mdot
.64975 .54926 Mdot
.6666 .51346 Mdot
.67538 .55341 Mdot
.65735 .52528 Mdot
.69155 .51008 Mdot
.67624 .50602 Mdot
.66914 .51624 Mdot
.67888 .4938 Mdot
.67224 .51467 Mdot
.65711 .51863 Mdot
.67018 .4924 Mdot
.62253 .49491 Mdot
.65815 .51452 Mdot
.69141 .50067 Mdot
.63951 .52063 Mdot
.6868 .52171 Mdot
.66118 .53155 Mdot
.65062 .51519 Mdot
.69048 .5069 Mdot
.6818 .52465 Mdot
.66109 .50763 Mdot
.65052 .51979 Mdot
.64151 .53674 Mdot
.66947 .51381 Mdot
.6211 .52613 Mdot
.69977 .48957 Mdot
.65716 .51458 Mdot
.67495 .51731 Mdot
.73526 .52205 Mdot
.64292 .51359 Mdot
.66124 .51546 Mdot
.66423 .51344 Mdot
.67325 .50046 Mdot
.64535 .51357 Mdot
.63415 .53864 Mdot
.65385 .51839 Mdot
.66447 .53032 Mdot
.68402 .47396 Mdot
.66162 .51337 Mdot
.65329 .48463 Mdot
.66134 .50372 Mdot
.62685 .4628 Mdot
.72912 .5147 Mdot
.67741 .51923 Mdot
.67503 .52875 Mdot
.66303 .51913 Mdot
.66687 .52651 Mdot
.68318 .47925 Mdot
.69988 .5943 Mdot
.65003 .52004 Mdot
.6648 .51316 Mdot
.62184 .41795 Mdot
.65751 .52209 Mdot
.65615 .51055 Mdot
.63712 .53609 Mdot
.68336 .52522 Mdot
.66843 .5114 Mdot
.66591 .51392 Mdot
.63118 .48618 Mdot
.6734 .50485 Mdot
.64266 .51574 Mdot
.67153 .50668 Mdot
.66562 .4399 Mdot
.59314 .56359 Mdot
.65168 .50276 Mdot
.60721 .50618 Mdot
.63852 .51416 Mdot
.67417 .53112 Mdot
.65342 .51924 Mdot
.62612 .51387 Mdot
.6582 .51946 Mdot
.67178 .51055 Mdot
.65389 .56325 Mdot
.67717 .5233 Mdot
.64623 .52802 Mdot
.63763 .4976 Mdot
.67509 .53916 Mdot
.61372 .50025 Mdot
.70693 .54087 Mdot
0 0 1 r
.36974 .48241 Mdot
.4696 .45114 Mdot
.4088 .42517 Mdot
.40797 .43814 Mdot
.44186 .37739 Mdot
.42811 .4137 Mdot
.33013 .43905 Mdot
.43484 .48466 Mdot
.38299 .46624 Mdot
.41778 .42129 Mdot
.30378 .45175 Mdot
.27828 .43802 Mdot
.4277 .36836 Mdot
.40476 .44603 Mdot
.39141 .42989 Mdot
.23057 .38102 Mdot
.39513 .45752 Mdot
.3739 .50672 Mdot
.43963 .46242 Mdot
.29303 .43732 Mdot
.40431 .40724 Mdot
.37629 .53342 Mdot
.3812 .53945 Mdot
.3419 .44636 Mdot
.29644 .45493 Mdot
.38426 .46878 Mdot
.38677 .39689 Mdot
.45028 .43603 Mdot
.38379 .45379 Mdot
.50457 .41568 Mdot
.41089 .47144 Mdot
.45129 .52051 Mdot
.36822 .44604 Mdot
.44309 .40999 Mdot
.3916 .46444 Mdot
.40134 .46326 Mdot
.36295 .49984 Mdot
.38694 .4367 Mdot
.37849 .4186 Mdot
.39521 .44924 Mdot
.3911 .43927 Mdot
.26609 .53683 Mdot
.41711 .4754 Mdot
.30997 .34212 Mdot
.46226 .4736 Mdot
.36299 .33887 Mdot
.3688 .48091 Mdot
.40291 .45977 Mdot
.41453 .43026 Mdot
.43732 .48036 Mdot
.38345 .4495 Mdot
.34398 .39829 Mdot
.41025 .43428 Mdot
.37075 .44348 Mdot
.31611 .33914 Mdot
.35836 .45047 Mdot
.41858 .434 Mdot
.40827 .45048 Mdot
.50655 .33632 Mdot
.38182 .45133 Mdot
.38166 .43514 Mdot
.38602 .46252 Mdot
.38614 .42647 Mdot
.38205 .45692 Mdot
.39556 .43571 Mdot
.39098 .44091 Mdot
.35114 .46814 Mdot
.39856 .45306 Mdot
.38588 .3823 Mdot
.37915 .44756 Mdot
.37804 .42192 Mdot
.42301 .42081 Mdot
.41183 .44884 Mdot
.37432 .47775 Mdot
.42868 .43715 Mdot
.39078 .44237 Mdot
.31276 .43933 Mdot
.38594 .41501 Mdot
.29625 .43344 Mdot
.35128 .3572 Mdot
.42328 .43404 Mdot
.38577 .46224 Mdot
.38984 .46965 Mdot
.46178 .41595 Mdot
.35064 .45918 Mdot
.45808 .49046 Mdot
.42749 .39502 Mdot
.44786 .38573 Mdot
.3907 .44264 Mdot
.39105 .4426 Mdot
.30527 .44413 Mdot
.45105 .49295 Mdot
.44261 .47388 Mdot
.38745 .44251 Mdot
.39105 .50504 Mdot
.28756 .38995 Mdot
.36527 .52151 Mdot
.28635 .46664 Mdot
.38632 .44206 Mdot
.35204 .29427 Mdot
.45339 .47461 Mdot
.46924 .23893 Mdot
.38991 .40728 Mdot
.38547 .32573 Mdot
.38967 .3287 Mdot
.41883 .25293 Mdot
.12969 .4303 Mdot
.46806 .26461 Mdot
.25327 .20649 Mdot
.34435 .29701 Mdot
.23927 .25566 Mdot
.45344 .3122 Mdot
.37318 .2459 Mdot
.51064 .25923 Mdot
.37319 .20988 Mdot
.39127 .32724 Mdot
.28487 .25477 Mdot
.06938 .3119 Mdot
.26311 .35132 Mdot
.09189 .21059 Mdot
.3901 .21179 Mdot
.36788 .33111 Mdot
.43167 .32106 Mdot
.3379 .34964 Mdot
.40116 .30061 Mdot
.39434 .26552 Mdot
.32447 .30993 Mdot
.3944 .27361 Mdot
.30618 .37235 Mdot
.43209 .27502 Mdot
.31863 .31268 Mdot
.38464 .30999 Mdot
.31209 .31415 Mdot
.21414 .40547 Mdot
.23454 .41922 Mdot
.39048 .33085 Mdot
.32957 .39806 Mdot
.36874 .31906 Mdot
.40048 .33828 Mdot
.42578 .33871 Mdot
.37769 .23036 Mdot
.34209 .31818 Mdot
.40699 .30219 Mdot
.21578 .40395 Mdot
.37563 .24168 Mdot
.23747 .60332 Mdot
.39062 .3288 Mdot
.44919 .45135 Mdot
.34568 .29468 Mdot
.45596 .42689 Mdot
.3184 .29776 Mdot
.38005 .33547 Mdot
.43464 .32716 Mdot
.43534 .37683 Mdot
.38168 .28503 Mdot
.35982 .34027 Mdot
.39979 .32262 Mdot
.43823 .34941 Mdot
.54869 .44925 Mdot
.40259 .46445 Mdot
.3932 .32665 Mdot
.42653 .34969 Mdot
.38127 .3321 Mdot
.44956 .22897 Mdot
.27054 .2519 Mdot
.3765 .36874 Mdot
.3989 .32841 Mdot
.38608 .35757 Mdot
.37706 .28113 Mdot
.39253 .39693 Mdot
.36951 .31927 Mdot
.36307 .29794 Mdot
.46494 .29543 Mdot
.48614 .12625 Mdot
.38504 .30562 Mdot
.37799 .35293 Mdot
.36088 .3198 Mdot
.41833 .26891 Mdot
.52436 .35887 Mdot
.26705 .25865 Mdot
.28504 .31517 Mdot
.3757 .25456 Mdot
.38424 .31297 Mdot
.39274 .32764 Mdot
.48314 .49626 Mdot
.38565 .12838 Mdot
.22581 .33042 Mdot
.43989 .34764 Mdot
.44256 .43831 Mdot
.3932 .29309 Mdot
.27701 .34653 Mdot
.30404 .20363 Mdot
.3964 .35065 Mdot
.4611 .33596 Mdot
.35338 .25921 Mdot
.36998 .17907 Mdot
.39651 .13373 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[24]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006P3oool2000002T0oooo0P0000040?ooo`800000103oool2000002P0oooo1@00000U0?oo
o`D000000P3oool2000000@0oooo0P00000X0?ooo`@000009`3oool4000000<0oooo0P0000040?oo
o`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`070?ooo`040000003oool0oooo000002L0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`090?ooo`040000003oool0oooo000000T0oooo000I0?ooo`040000003oool0oooo000002L0
oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
02L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`006@3oool010000000
oooo0?ooo`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0203oool2000002X0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`080?ooo`8000002P3oool001T0oooo00@000000?ooo`3oool000009`3oool0
10000000oooo0?ooo`0000090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
9`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00T0oooo000J0?ooo`800000
:@3oool2000000X0oooo0`00000X0?ooo`800000:03oool2000000X0oooo0`00000X0?ooo`800000
:@3oool2000000X0oooo0`0000090?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0<0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oool70?oo
o`8000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`L0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?oo
o`005@3oool200000?l0oooo1`3oool200000040oooo000E0?ooo`030000003oool0oooo0?l0oooo
1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E
0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo
0?l0oooo1`3oool100000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040
oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000E0?ooo`800000o`3o
ool70?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0Z@3oool30?l005X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`2X0?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo0:P0oooo1@3o001I0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0Z03oool50?l005T0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`2Y0?ooo`<0o`00FP3oool100000040oooo000E0?ooo`800000o`3oool70?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0o`3oool70?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0HP3oool30000oaP0oooo0`000?n60?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0H@3oool50000oaH0oooo1@000?n50?ooo`4000000@3oool001D0oooo0P00
001R0?ooo`L0003o503oool50000oh@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1Q
0?ooo`P0003o4`3oool50000ohD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1R0?oo
o`L0003o503oool30000ohH0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1T0?ooo`D0
003oW@3oool100000040oooo000E0?ooo`030000003oool0oooo06D0oooo0`000?nN0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0/P3oool30?l00540oooo0@0000010?ooo`000P3oool2
000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool1
00000040oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`2a0?ooo`D0o`00D03oool100000040oooo00001@3oool000000?ooo`3o
ool0000000/0oooo00<000000?ooo`3oool00P3oool200000;80oooo1@3o001?0?ooo`8000000@3o
ool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0/P3o
ool30?l00540oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0mP3oool30?l000d0oooo0@0000010?ooo`000P3oool2
000000X0oooo0`0000040?ooo`030000003oool0oooo0?D0oooo1@3o000<0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0GP3oool30000oi@0oooo1@3o000<0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool0G@3oool50000oi<0oooo1@3o000<0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G@3oool50000oi@0oooo0`3o000=0?ooo`4000000@3oool001D0oooo0P00
001N0?ooo`D0003oL03oool30?l00300oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`1N
0?ooo`<0003oL03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?oo
o`D0o`00<03oool100000040oooo000E0?ooo`030000003oool0oooo04d0oooo0`000?mB0?ooo`<0
o`00;03oool50?l00300oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`<0003o
2P3oool50000oe00oooo1@3o000[0?ooo`@0o`002P3oool30?l002@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`<0003o9`3oool50000o`T0oooo1@000?l>0?ooo`<0003o00@0
oooo0000o`000?l0003o>`3oool50?l001/0oooo0`3o000<0?ooo`D0o`002@3oool50?l002<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0003o9P3oool50000o`T0oooo1@00
0?l=0?ooo`T0003o>P3oool50?l001X0oooo1@3o000;0?ooo`D0o`00203oool60?l002<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`D0003o9P3oool50000o`X0oooo0`000?l>
0?ooo`T0003o>`3oool30?l001/0oooo1@3o000;0?ooo`D0o`001`3oool80?l00280oooo0@000001
0?ooo`005@3oool2000001@0oooo1@000?lW0?ooo`<0003o703oool90000oeT0oooo1@3o000<0?oo
o`<0o`00203oool90?l00200oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`<0
003oB03oool30000o`040?ooo`000?l0003o0000oe/0oooo1P3o000E0?ooo`T0o`008@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0600oooo0`000?l@0?ooo`<0003oC@3oool50?l001D0
oooo203o000Q0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G`3oool50000o`h0oooo
1@000?m<0?ooo`L0o`005`3oool30?l00280oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`D0003o3P3oool50000oc80oooo0`3o00090?ooo`<0o`002`3oool80?l003/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0003o3P3oool50000o`040?ooo`000?l0
003o0000obd0oooo1@3o0000103oool0o`000?l0003o00030?ooo`D0o`002`3oool70?l003/0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`D0003o3`3oool30000o`030?ooo`00
0?l0003o00<0003o;03oool:0?l00080oooo1@3o000=0?ooo`D0o`00>`3oool100000040oooo000E
0?ooo`030000003oool0oooo05h0oooo1P000?lC0?ooo`D0003o:P3oool<0?l00080oooo1@3o0000
103oool0o`000?l0003o000:0?ooo`<0o`00?03oool100000040oooo000E0?ooo`800000A@3oool3
0000oaL0oooo1P000?l70?ooo`<0003o2@3oool50000obT0oooo1`3o00000`3oool0o`000?l00003
0?l000<0oooo0`3o00000`3oool0o`000?l000030?l000H0oooo0`3o00040?ooo`<0o`004@3oool3
0?l002<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`<0003o1@3oool70000
oa@0oooo1@000?l70?ooo`D0003o2@3oool30000obX0oooo1@3o00040?ooo`<0o`00203oool50?l0
00D0oooo1@3o00020?ooo`D0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`D0003o103oool80000o`l0oooo0`000?l20?ooo`D0003o1P3oool50000oa@0
oooo0`000?lA0?ooo`<0o`00203oool80?l000l0oooo203o00020?ooo`D0o`000P3oool50?l000l0
oooo1@3o000S0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>P3oool50000o`<0oooo
2@000?l>0?ooo`D0003o00<0oooo0000o`000?l00`000?l60?ooo`D0003o2@3oool30000o`L0oooo
1@000?l?0?ooo`D0o`001P3oool80?l00140oooo203o00000`3oool0o`000?l000040?l000030?oo
o`3o0000o`0000<0o`003`3oool50?l002<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0j0?ooo`D0003o0`3oool90000o`h0oooo1@000?l00`3oool0003o0000o`030000o`040?ooo`00
0?l0003o0000o`<0oooo0`000?l90?ooo`D0003o1P3oool50000o`l0oooo1@3o00060?ooo`H0o`00
203oool30?l000P0oooo203o00020?ooo`D0o`000P3oool30?l00140oooo0`3o000T0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0>`3oool30000o`@0oooo20000?l?0?ooo`D0003o0P3o
ool30000o`030?ooo`000?l0003o00<0003o0P3oool30000o`T0oooo1@000?l60?ooo`D0003o3`3o
ool50?l000H0oooo1P3o00070?ooo`D0o`00203oool70?l00080oooo1@3o00040?ooo`<0o`004`3o
ool30?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`130?ooo`<0003o503oool3
0000o`L0oooo1@000?l00`3oool0003o0000o`060000o`D0oooo1@000?l70?ooo`<0003o4@3oool3
0?l000P0oooo1@3o00070?ooo`D0o`002`3oool30?l000@0oooo0`3o00030?ooo`L0o`00403oool5
0?l001l0oooo0@0000010?ooo`005@3oool2000006D0oooo1@000?l00`3oool0003o0000o`070000
o`D0oooo0`000?lX0?ooo`<0o`00203oool60?l000P0oooo0`3o00040?ooo`H0o`0000<0oooo0?l0
003o00001`3o000?0?ooo`D0o`007P3oool200000040oooo000E0?ooo`030000003oool0oooo0600
oooo0`000?l00`3oool0003o0000o`030000o`030?ooo`000?l0003o00L0003o<@3oool30?l000P0
oooo1P3o00060?ooo`D0o`000P3ooolA0?l000h0oooo1P3o000O0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0G`3oool:0000o`80oooo20000?l`0?ooo`D0o`00203oool50?l000H0oooo
1@3o00020?oooa40o`003@3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`1O0?ooo`T0003o1`3oool30000oc40oooo1@3o00080?ooo`D0o`001P3oool50?l00080oooo203o
00001@3oool0o`000?l0003o0000oooo00<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`1H0?ooo`@0003o0`3oool80000oc`0oooo1@3o00090?ooo`<0o`001P3o
ool50?l000<0oooo2@3o00040?ooo`<0o`003P3oool50?l00240oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`1@0?ooo`<0003o103oool80000o`030?ooo`000?l0003o00H0003o3`3oool3
0000obX0oooo0`3o000C0?ooo`D0o`000`3oool:0?l00080oooo1@3o000>0?ooo`<0o`008P3oool1
00000040oooo000=0?ooo`D000000`3oool00`000000oooo0?ooo`1?0?ooo`D0003o0P3oool:0000
o`030?ooo`000?l0003o00P0003o2`3oool50000obl0oooo0`3o00080?ooo`<0o`000P3oool50?l0
00<0oooo2P3o00020?ooo`D0o`002`3oool30?l002D0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo04l0oooo1@000?l20?ooo`X0003o0P3oool:0000o`X0
oooo1@000?lU0?ooo`<0o`001P3oool50?l000<0oooo3@3o00030?ooo`/0o`000P3oool50?l000X0
oooo1P3o000S0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool200000500oooo
1P000?l00`3oool0003o0000o`080000o`030?ooo`000?l0003o00T0003o2P3oool50000ob@0oooo
1@3o00050?ooo`D0o`000P3oool?0?l00080oooo2P3o00040?ooo`<0o`002`3oool70?l00240oooo
0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo0`00
0?lo0?ooo`H0003o00@0oooo0000o`000?l0003o0P3oool30000o`80oooo2`000?l80?ooo`H0003o
9@3oool50?l000D0oooo1@3o00020?ooo`l0o`000P3oool90?l000P0oooo0`3o00080?ooo`L0o`00
8P3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3o
ool50000ocH0oooo0`000?l40?ooo`L0003o2`3oool:0000o`P0oooo1@000?lW0?ooo`D0o`001P3o
ool30?l00080oooo403o00030?ooo`T0o`001P3oool50?l000@0oooo0`3o00000`3oool0o`000?l0
00040?l00280oooo0@0000010?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool03@3oool5
0000ocD0oooo1@000?l20?ooo`P0003o00@0oooo0000o`000?l0003o0P3oool:0000o`P0oooo0`00
0?l20?ooo`D0003o:03oool30?l000040?ooo`3o0000o`000?l000L0oooo403o00040?ooo`X0o`00
1@3oool50?l000<0oooo1@3o00020?ooo`<0o`008`3oool100000040oooo000E0?ooo`030000003o
ool0oooo00d0oooo1@000?le0?ooo`D0003o0P3oool70000o`030?ooo`000?l0003o0140003o103o
ool50000o`030?ooo`000?l0003o00<0003o:`3oool50?l000H0oooo3@3o00060?ooo`D0o`0000<0
oooo0?l0003o00000`3o00050?ooo`D0o`000`3oool50?l002P0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0>0?ooo`<0003o=P3oool50000o`80oooo1@000?l30?oooa@0003o0`3oool5
0000o`80oooo0`000?l/0?ooo`H0o`001@3oool=0?l000H0oooo1@3o00000`3oool0o`000?l00003
0?l000H0oooo0`3o00040?ooo`D0o`00:03oool100000040oooo000E0?ooo`030000003oool0oooo
03P0oooo0`000?l=0?ooo`<0003o103oool30000o`@0oooo50000?l30?ooo`H0003o<03oool60?l0
00H0oooo0`3o00020?ooo`L0o`001P3oool:0?l000l0oooo0`3o000Y0?ooo`4000000@3oool001D0
oooo0P00000h0?ooo`D0003o6`3oool30000o`80oooo3P000?l40?ooo`D0003o0`3oool30000o`T0
oooo0`000?lO0?ooo`D0o`003P3oool30?l000P0oooo0`3o00000`3oool0o`000?l000030?l000L0
oooo0`3o000`0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0=`3oool50000oa@0oooo
0`000?l80?ooo`l0003o0`3oool60000o`80oooo1@000?l70?ooo`D0003o7`3oool30?l001d0oooo
1P3o00020?ooo`<0o`0000<0oooo0?l0003o00000`3o000`0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0=`3oool50000oa80oooo1P000?l60?oooa00003o0P3oool60000o`<0oooo1@00
0?l70?ooo`D0003o4`3oool30?l002T0oooo1@3o00020?ooo`X0o`002`3oool40?l00240oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`<0003o2P3oool30000o`D0oooo1`000?l6
0?oooa00003o0P3oool80000o`030?ooo`000?l0003o00<0003o1`3oool50000oa80oooo1@3o000X
0?ooo`D0o`000P3oool:0?l000X0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0@P3oool70000o`@0oooo1`000?l20?ooo`<0003o00<0oooo0000o`000?l010000?l01@3o
ool0003o0000o`000?l0oooo00D0003o0P3oool90000o`040?ooo`000?l0003o0000o`T0oooo0`00
0?lC0?ooo`D0o`00:@3oool50?l000030?ooo`3o0000o`0000<0o`0000@0oooo0?l0003o0000o`00
2`3oool60?l00200oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`110?ooo`P0003o103o
ool60000o`80oooo1@000?l00`3oool0003o0000o`020000o`050?ooo`000?l0003o0000o`3oool0
1@000?l30?ooo`T0003o8`3oool50?l001T0oooo0`3o000>0?ooo`D0o`0000@0oooo0?l0003o0000
o`00203oool30?l000D0oooo1P3o000P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
@@3oool80000o`D0oooo0`000?l40?ooo`L0003o0`3oool:0000o`<0oooo2@000?lB0?ooo`<0003o
3`3oool30?l000/0oooo0`3o000;0?ooo`P0o`000`3oool30?l000@0oooo1@3o00000`3oool0o`00
0?l000030?l000D0oooo1@3o00050?ooo`@0o`008@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0440oooo1`000?l=0?ooo`P0003o0P3oool:0000o`<0oooo20000?lB0?ooo`D0003o6`3o
ool50?l000X0oooo2@3o00000`3oool0o`000?l000050?l000030?ooo`3o0000o`0000X0o`00103o
ool50?l000H0oooo0`3o000Q0?ooo`4000000@3oool001D0oooo0P0000130?ooo`<0003o4@3oool7
0000o`80oooo2@000?l50?ooo`H0003o4`3oool50000oa/0oooo1@3o00020?ooo`<0o`0000D0oooo
0?l0003o0000o`000?ooo`090?l000030?ooo`3o0000o`0000H0o`0000D0oooo0?l0003o0000o`00
0?ooo`070?l000@0oooo1@3o00050?ooo`D0o`007`3oool200000040oooo000E0?ooo`030000003o
ool0oooo05P0oooo1@000?l30?ooo`H0003o1`3oool30000oaH0oooo1@000?lK0?ooo`D0o`0000<0
oooo0?l0003o00001`3o00000`3oool0o`000?l000060?l000030?ooo`3o0000o`0000H0o`001@3o
ool70?l000D0oooo0`3o00060?ooo`D0o`00803oool100000040oooo000E0?ooo`030000003oool0
oooo04d0oooo0`000?l90?ooo`<0003o0`3oool60000o`L0oooo1@000?lF0?ooo`<0003o7@3oool3
0?l00080oooo303o00020?ooo`<0o`000`3oool70?l000H0oooo1@3o000?0?ooo`P0o`007@3oool1
00000040oooo000E0?ooo`030000003oool0oooo04`0oooo1@000?l>0?ooo`D0003o203oool80000
ocP0oooo3@3o000:0?ooo`D0o`006P3oool80?l001`0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0i0?ooo`<0003o403oool50000o`h0oooo1@000?l80?ooo`T0003o>03oool30?l00003
0?ooo`3o0000o`0000H0o`002P3oool50?l001D0oooo0`3o00050?ooo`D0o`00703oool100000040
oooo000E0?ooo`030000003oool0oooo03P0oooo1@000?l?0?ooo`D0003o3`3oool50000o`P0oooo
20000?lo0?ooo`D0o`002P3oool50?l000T0oooo0`3o00080?ooo`D0o`00103oool50?l001`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`D0003o403oool30000oa40oooo1@00
0?l80?ooo`P0003o?`3oool30?l000`0oooo0`3o00090?ooo`D0o`001`3oool50?l000D0oooo0`3o
000M0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0>03oool50000o`/0oooo0`000?lF
0?ooo`D0003o2@3oool80000odD0oooo0`3o000A0?ooo`D0o`001`3oool50?l002D0oooo0@000001
0?ooo`005@3oool2000003X0oooo0`000?l;0?ooo`D0003o5@3oool50000o`L0oooo0`000?l20?oo
o`D0003oA03oool50?l00100oooo1@3o00080?ooo`<0o`009@3oool200000040oooo000E0?ooo`03
0000003oool0oooo04L0oooo1@000?l70?ooo`<0003o00@0oooo0000o`000?l0003o203oool50000
o`D0oooo1@000?l00`3oool0003o0000o`030000od@0oooo1@3o000A0?ooo`<0o`00<P3oool10000
0040oooo000E0?ooo`030000003oool0oooo03D0oooo0`000?l?0?ooo`D0003o1P3oool90000o`L0
oooo1P000?l40?ooo`D0003o0P3oool30000odD0oooo1@3o00160?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0=03oool50000o`l0oooo0`000?l70?ooo`T0003o1`3oool80000o`80oooo
1@000?m;0?ooo`<0o`00A`3oool100000040oooo000E0?ooo`030000003oool0oooo03@0oooo1@00
0?lI0?ooo`T0003o1`3oool90000o`80oooo0`000?l0103oool0003o0000o`000?nB0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool0=03oool50000oaX0oooo0`000?l0103oool0003o0000
o`000?l80?ooo`T0003o0`3oool70000ob<0oooo0`3o000c0?ooo`<0o`00=@3oool100000040oooo
000E0?ooo`030000003oool0oooo03@0oooo1@000?l0103oool0003o0000o`000?lS0?ooo`/0003o
0P3oool80000o`040?ooo`000?l0003o0000o`T0oooo0`000?lB0?ooo`D0o`001@3oool30?l00280
oooo0`3o00040?ooo`D0o`00=03oool100000040oooo000E0?ooo`800000=P3oool30000o`030?oo
o`000?l0003o00<0003o8@3oool70000o`050?ooo`000?l0003o0000o`3oool03`000?l70?ooo`D0
003o4@3oool50?l000@0oooo1@3o000P0?ooo`D0o`000`3oool50?l003<0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`0i0?ooo`D0003o8@3oool70000o`80oooo30000?l00`3oool0003o
0000o`030000o`L0oooo1@000?lA0?ooo`D0o`00103oool50?l00200oooo1@3o00030?ooo`D0o`00
=03oool100000040oooo000E0?ooo`030000003oool0oooo01h0oooo0`000?lH0?ooo`D0003o8@3o
oolB0000o`<0oooo1P000?l70?ooo`D0003o4P3oool30?l000D0oooo1@3o000P0?ooo`D0o`00103o
ool30?l002h0oooo0`3o00040?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool5
0000oaP0oooo0`000?l=0?ooo`<0003o4P3ooolA0000o`@0oooo1@000?l90?ooo`<0003o703oool3
0?l000T0oooo0`3o000F0?ooo`<0o`00=@3oool50?l000<0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`0M0?ooo`D0003o903oool80000oa80oooo4@000?l20?ooo`H0003o<`3oool50?l0
04d0oooo1@3o00030?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool07@3oool50000ob<0
oooo2@000?l01@3oool0003o0000o`000?l0oooo00<0003o2P3ooolH0000oc@0oooo1@3o001=0?oo
o`D0o`000`3oool100000040oooo00000`3oool000000000000300000080oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`0N0?ooo`<0003o903ooolB0000o`L0oooo6@000?le0?ooo`D0
o`00CP3oool30?l000@0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0A@3ooolE0000o`<0oooo6P000?lG0?ooo`<0
003o6`3oool50?l005D0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0080oooo0P0000170?ooo`<0003o00<0oooo0000o`000?l08@000?l00`3oool0003o
0000o`060000o`<0oooo0`000?lA0?ooo`D0003o6P3oool50?l005@0oooo0P0000010?ooo`000`3o
ool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`1;0?ooo`L0003o00<0
oooo0000o`000?l060000?l40?ooo`H0003o00<0oooo0000o`000?l00`000?l@0?ooo`D0003o6`3o
ool30?l002@0oooo0`3o000_0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo04X0oooo1P000?l60?oooaL0003o1@3oool5
0000o`030?ooo`000?l0003o00<0003o403oool50000od40oooo1@3o000^0?ooo`4000000@3oool0
0080oooo0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`1:0?ooo`H0003o1`3ooolE0000
o`D0oooo1P000?l00`3oool0003o0000o`030000oa40oooo0`000?lA0?ooo`<0o`00;P3oool50?l0
02h0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`180?ooo`L0003o2@3oool60000o`80
oooo2`000?l50?ooo`H0003o0`3oool30000obD0oooo1@3o000I0?ooo`<0o`004@3oool50?l002h0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`170?ooo`L0003o2P3oool50000o`@0oooo
2`000?l40?ooo`D0003o;03oool50?l001P0oooo1@3o000A0?ooo`<0o`00;`3oool100000040oooo
000E0?ooo`030000003oool0oooo04L0oooo1@000?l<0?ooo`D0003o103oool=0000o`80oooo2P00
0?lW0?ooo`D0o`002`3oool30?l000X0oooo1@3o00130?ooo`4000000@3oool001D0oooo0P000018
0?ooo`D0003o303oool50000o`80oooo40000?l00`3oool0003o0000o`090000obL0oooo0`3o000;
0?ooo`D0o`002@3oool50?l00480oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`180?oo
o`<0003o3P3oool30000o`80oooo2@000?l00`3oool0003o0000o`050000o`030?ooo`000?l0003o
00T0003o=@3oool50?l000X0oooo0`3o00140?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0G@3oool90000o`<0oooo4P000?lX0?ooo`<0o`000`3oool30?l000@0oooo1@3o001A0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0G@3oool60000o`P0oooo3`000?lX0?ooo`/0o`00
0`3oool50?l000040?ooo`3o0000o`000?l004d0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`1M0?ooo`D0003o303oool;0000obT0oooo2`3o00000`3oool0o`000?l0000:0?l004`0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`<0003o3@3oool;0000o`<0oooo0`00
0?lP0?oooa/0o`00703oool30?l002d0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`1L
0?ooo`<0003o403oool30000o`030?ooo`000?l0003o00@0003o0P3oool50000oah0oooo3P3o0000
0`3oool0o`000?l0000;0?l001/0oooo1@3o000/0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0F`3oool50000o`@0oooo0`000?l<0?ooo`D0003o0`3oool50000oa`0oooo7@3o000L0?oo
o`D0o`00;03oool100000040oooo000E0?ooo`800000G03oool70000o`030?ooo`000?l0003o00<0
003o303oool30000o`@0oooo1@000?lK0?oooa`0o`007P3oool50?l002/0oooo0P0000010?ooo`00
5@3oool00`000000oooo0?ooo`1K0?ooo`d0003o503oool30000oa`0oooo2@3o00000`3oool0o`00
0?l0000@0?l001l0oooo0`3o000]0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G03o
ool<0000oc<0oooo703o00060?ooo`<0o`00AP3oool100000040oooo000E0?ooo`030000003oool0
oooo05h0oooo1@000?l0103oool0003o0000o`000?l=0?ooo`<0003o9@3ooolK0?l000D0oooo1@3o
00150?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0G@3oool50000oa40oooo1@000?lU
0?ooo`<0o`0000<0oooo0?l0003o0000503o00050?ooo`H0o`00A03oool100000040oooo000E0?oo
o`030000003oool0oooo05`0oooo1@000?lB0?ooo`D0003o:@3ooolE0?l000H0oooo1`3o00130?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0G03oool50000oa80oooo1@000?lX0?oooaH0
o`001`3oool60?l004<0oooo0@0000010?ooo`005@3oool2000005d0oooo1`000?lA0?ooo`<0003o
6@3oool30?l000d0oooo5P3o00080?ooo`D0o`00@P3oool200000040oooo000E0?ooo`030000003o
ool0oooo0480oooo0`000?lH0?ooo`L0003o:`3oool50?l000`0oooo5@3o000:0?ooo`<0o`00A03o
ool100000040oooo000E0?ooo`030000003oool0oooo0440oooo1@000?lI0?ooo`H0003o:P3oool5
0?l000d0oooo4`3o00000`3oool0o`000?l000040?l004/0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`110?ooo`D0003o6@3oool60000obX0oooo1@3o000?0?ooo`L0o`0000<0oooo0?l0
003o00001P3o00000`3oool0o`000?l000060?l004X0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`110?ooo`D0003o6P3oool50000ob/0oooo0`3o000@0?ooo`P0o`000P3oool60?l00003
0?ooo`3o0000o`0000H0o`00BP3oool100000040oooo000E0?ooo`030000003oool0oooo0480oooo
0`000?lL0?ooo`<0003o@03oool80?l00080oooo1@3o00000`3oool0o`000?l000060?l004X0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`2W0?ooo`D0o`000P3oool50?l00080oooo1P3o
001;0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0Y`3oool50?l00080oooo1@3o001C
0?ooo`4000000@3oool001D0oooo0P00002J0?ooo`H0o`002@3oool40?l00080oooo1@3o001B0?oo
o`8000000@3oool001D0oooo00<000000?ooo`3oool0V03oool80?l000P0oooo1@3o00020?ooo`<0
o`00E03oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo203o00080?ooo`D0o`00
F@3oool100000040oooo000E0?ooo`030000003oool0oooo09P0oooo203o00080?ooo`D0o`00F@3o
ool100000040oooo000E0?ooo`030000003oool0oooo09T0oooo1P3o000:0?ooo`<0o`00FP3oool1
00000040oooo000E0?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000=0?ooo`@0
0000103oool00`000000oooo0?ooo`3o0?ooo`L0oooo0@0000010?ooo`003@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0oooo1`3oool100000040oooo000>0?ooo`030000003o
ool0oooo00@0oooo0P00002g0?ooo`<0o`00C03oool200000040oooo000?0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0]@3oool50?l004`0oooo0@0000010?ooo`003@3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo03/0oooo0`000?mg0?ooo`D0o`00C03oool1
00000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`0j0?ooo`D0003oMP3oool50?l0
04`0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D0003oM`3oool30?l004d0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`D0003oa`3oool100000040oooo
000E0?ooo`030000003oool0oooo03/0oooo0`000?o80?ooo`4000000@3oool001D0oooo0P000004
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`02
0?ooo`8000000@3oool001D0ooooo`00000;00000040oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.283721, -0.217479, \
0.0102636, 0.0131995}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hierarchical Clustering", "Subsubsection"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Agglomerate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["data",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "collects the elements of ",
              StyleBox["data",
                FontSlant->"Italic"],
              " into a hierarchy of clusters"
            }], "Text"]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->"Agglomerate"],

Cell[TextData[StyleBox["Hierarchical clustering function.",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}]], "Caption",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[TextData[{
  "The ",
  StyleBox["Agglomerate", "MR"],
  " function computes a cluster hierarchy of a data set. ",
  StyleBox["Agglomerate", "MR"],
  " accepts data in the same forms accepted by ",
  StyleBox["FindClusters", "MR"],
  ". The output from ",
  StyleBox["Agglomerate", "MR"],
  " is a nested ",
  StyleBox["Cluster", "MR"],
  " object representing the hierarchical clustering."
}], "Text"],

Cell["Here is a small numerical data set.", "MathCaption"],

Cell[BoxData[
    \(\(data2 = {{0.7253055971477931`, \(-1.1302536982240747`\)}, \
{0.5810146986977534`, 1.4463710601068265`}, {0.8460694069050189`, 
            2.0329569918374406`}, {0.2169129449840166`, \
\(-0.33368074105304846`\)}, {\(-0.02675560596423776`\), 
            1.1506670168024957`}, {\(-0.38070042430357054`\), \
\(-0.24750818092033833`\)}, {2.4423867332670177`, 
            1.9380008134953024`}, {\(-0.3152439519516439`\), \
\(-0.2760546508444408`\)}, {1.1616304061543707`, 
            0.794607673348773`}, {\(-0.25171211458875775`\), 
            2.0210234868823256`}};\)\)], "Input",
  CellLabel->"In[25]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["This constructs a hierarchical clustering of the data.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cl = Agglomerate[data2]\)], "Input",
  CellLabel->"In[26]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[
      Cluster[Cluster[{0.7253055971477931`, \(-1.1302536982240747`\)}, 
          Cluster[{0.2169129449840166`, \(-0.33368074105304846`\)}, 
            Cluster[{\(-0.3152439519516439`\), \(-0.2760546508444408`\)}, \
{\(-0.38070042430357054`\), \(-0.24750818092033833`\)}, 
              0.005099450717886225`, 1, 1], 0.28651172922892176`, 1, 2], 
          0.8929915648703123`, 1, 3], 
        Cluster[Cluster[
            Cluster[{\(-0.02675560596423776`\), 1.1506670168024957`}, 
              Cluster[{0.5810146986977534`, 
                  1.4463710601068265`}, {0.8460694069050189`, 
                  2.0329569918374406`}, 0.4143370536471114`, 1, 1], 
              0.456825624455459`, 1, 2], {1.1616304061543707`, 
              0.794607673348773`}, 0.7619101120636763`, 3, 
            1], {\(-0.25171211458875775`\), 2.0210234868823256`}, 
          0.8081258157823555`, 4, 1], 2.0801708179565495`, 4, 
        5], {2.4423867332670177`, 1.9380008134953024`}, 2.5572456822488645`, 
      9, 1]\)], "Output",
  CellLabel->"Out[26]="]
}, Open  ]],

Cell["Here is some Boolean data.", "MathCaption"],

Cell[BoxData[
    \(\(bdata = {{False, False, False, False, False, True, False, False, 
            True, True}, {True, False, False, False, False, False, False, 
            False, False, True}, {True, False, False, True, False, False, 
            True, False, True, True}, {True, True, False, False, True, False, 
            False, False, True, True}, {True, True, False, False, True, True, 
            True, True, True, True}};\)\)], "Input",
  CellLabel->"In[27]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["This clusters the Boolean data.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Agglomerate[bdata]\)], "Input",
  CellLabel->"In[28]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[{False, False, False, False, False, True, False, False, True, 
        True}, Cluster[
        Cluster[Cluster[{True, True, False, False, True, True, True, True, 
              True, True}, {True, True, False, False, True, False, False, 
              False, True, True}, 3\/8, 1, 1], {True, False, False, True, 
            False, False, True, False, True, True}, 5\/9, 2, 1], {True, 
          False, False, False, False, False, False, False, False, True}, 
        3\/5, 3, 1], 5\/8, 1, 4]\)], "Output",
  CellLabel->"Out[28]="]
}, Open  ]],

Cell["Here is some string data.", "MathCaption"],

Cell[BoxData[
    \(\(sdata = {"\<The\>", "\<quick\>", "\<brown\>", "\<fox\>", "\<jumps\>", \
"\<over\>", "\<the\>", "\<lazy\>", "\<dog\>"};\)\)], "Input",
  CellLabel->"In[29]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["This clusters the string data.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Agglomerate[sdata]\)], "Input",
  CellLabel->"In[30]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[
      Cluster[Cluster[
          Cluster[Cluster[Cluster["The", "the", 1, 1, 1], 
              Cluster["dog", "fox", 2, 1, 1], 3, 2, 2], "over", 3, 4, 1], 
          "lazy", 4, 5, 1], "brown", 4, 6, 1], 
      Cluster["jumps", "quick", 4, 1, 1], 5, 7, 2]\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Cluster",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                SubscriptBox[
                  StyleBox["c",
                    "TI"], "1"], ",", " ", 
                SubscriptBox[
                  StyleBox["c",
                    "TI"], "2"], ",", " ", 
                StyleBox["d",
                  "TI"], ",", " ", 
                SubscriptBox[
                  StyleBox["n",
                    "TI"], "1"], ",", " ", 
                SubscriptBox[
                  StyleBox["n",
                    "TI"], "2"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "represents a merger in the cluster hierarchy where the \
elements ",
              Cell[BoxData[
                  \(TraditionalForm\`c\_1\)]],
              " and ",
              Cell[BoxData[
                  \(TraditionalForm\`c\_2\)]],
              
              " are the subclusters merged with distance or dissimilarity \
value ",
              StyleBox["d", "TI"],
              ", and the subclusters contain ",
              Cell[BoxData[
                  \(TraditionalForm\`n\_1\)]],
              " and ",
              Cell[BoxData[
                  \(TraditionalForm\`n\_2\)]],
              " data elements respectively"
            }], "Text"]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["An element of the cluster hierarchy.", "Caption"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ClusterFlatten",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["cluster",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "flattens ",
              StyleBox["cluster",
                FontSlant->"Italic"],
              
              " returning a list of the data elements contained in the \
cluster"
            }], "Text"]},
          {
            RowBox[{
              StyleBox["ClusterSplit",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["cluster",
                  "TI"], ",", " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"splits", " ", 
                StyleBox["cluster",
                  FontSlant->"Italic"], " ", "into", " ", 
                StyleBox["n",
                  FontSlant->"Italic"], " ", "clusters"}], ",", " ", 
              RowBox[{
                RowBox[{
                "effectively", " ", "undoing", " ", "the", " ", "last", " ", 
                  StyleBox["n",
                    FontSlant->"Italic"]}], "-", \(1\ mergers\)}]}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell[TextData[{
  "Functions for manipulating ",
  StyleBox["Cluster", "MR"],
  " expressions."
}], "Caption"],

Cell[TextData[{
  "The ",
  StyleBox["ClusterFlatten", "MR"],
  " and ",
  StyleBox["ClusterSplit", "MR"],
  " functions are utilities for manipulating ",
  StyleBox["Cluster", "MR"],
  " objects."
}], "Text"],

Cell["This splits the cluster into the top 3 subclusters.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClusterSplit[cl, 3]\)], "Input",
  CellLabel->"In[31]:="],

Cell[BoxData[
    \({Cluster[{0.7253055971477931`, \(-1.1302536982240747`\)}, 
        Cluster[{0.2169129449840166`, \(-0.33368074105304846`\)}, 
          Cluster[{\(-0.3152439519516439`\), \(-0.2760546508444408`\)}, \
{\(-0.38070042430357054`\), \(-0.24750818092033833`\)}, 
            0.005099450717886225`, 1, 1], 0.28651172922892176`, 1, 2], 
        0.8929915648703123`, 1, 3], 
      Cluster[Cluster[
          Cluster[{\(-0.02675560596423776`\), 1.1506670168024957`}, 
            Cluster[{0.5810146986977534`, 
                1.4463710601068265`}, {0.8460694069050189`, 
                2.0329569918374406`}, 0.4143370536471114`, 1, 1], 
            0.456825624455459`, 1, 2], {1.1616304061543707`, 
            0.794607673348773`}, 0.7619101120636763`, 3, 
          1], {\(-0.25171211458875775`\), 2.0210234868823256`}, 
        0.8081258157823555`, 4, 1], {2.4423867332670177`, 
        1.9380008134953024`}}\)], "Output",
  CellLabel->"Out[31]="]
}, Open  ]],

Cell["This flattens the cluster.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClusterFlatten[cl]\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \({{0.7253055971477931`, \(-1.1302536982240747`\)}, {0.2169129449840166`, \
\(-0.33368074105304846`\)}, {\(-0.3152439519516439`\), \(-0.2760546508444408`\
\)}, {\(-0.38070042430357054`\), \(-0.24750818092033833`\)}, \
{\(-0.02675560596423776`\), 1.1506670168024957`}, {0.5810146986977534`, 
        1.4463710601068265`}, {0.8460694069050189`, 
        2.0329569918374406`}, {1.1616304061543707`, 
        0.794607673348773`}, {\(-0.25171211458875775`\), 
        2.0210234868823256`}, {2.4423867332670177`, 
        1.9380008134953024`}}\)], "Output",
  CellLabel->"Out[32]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["DistanceFunction",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell[
            "the distance or dissimilarity measure to use", "Text"]},
          {
            StyleBox["Linkage",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(the\ clustering\ linkage\ algorithm\ to\ use\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.3, 0.4},
  RowLines->{0.5, False}}],

Cell["Options for Agglomerate.", "Caption"],

Cell[TextData[{
  "The ",
  StyleBox["DistanceFunction", "MR"],
  " option is the same as for ",
  StyleBox["FindClusters", "MR"],
  ".",
  " ",
  StyleBox["DistanceFunction", "MR"],
  " defines the distance or dissimilarity between data points, while ",
  StyleBox["Linkage", "MR"],
  " defines the dissimilarity between clusters of data points."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\"",
              StyleBox["Single", "MR"],
              "\""
            }], "Text"], Cell[
            "smallest intercluster dissimilarity", "Text"]},
          {Cell[TextData[{
              "\"",
              StyleBox["Average", "MR"],
              "\""
            }], "Text"], Cell["average intercluster dissimilarity", "Text"]},
          {Cell[TextData[{
              "\"",
              StyleBox["Complete", "MR"],
              "\""
            }], "Text"], Cell["largest intercluster dissimilarity", "Text"]},
          {Cell[TextData[{
              "\"",
              StyleBox["Weighted", "MR"],
              "\""
            }], "Text"], Cell[
            "weighted average intercluster dissimilarity", "Text"]},
          {Cell[TextData[{
              "\"",
              StyleBox["Centroid", "MR"],
              "\""
            }], "Text"], Cell["distance from cluster centroids", "Text"]},
          {Cell[TextData[{
              "\"",
              StyleBox["Median", "MR"],
              "\""
            }], "Text"], Cell["distance from cluster medians ", "Text"]},
          {Cell[TextData[{
              "\"",
              StyleBox["Ward", "MR"],
              "\""
            }], "Text"], Cell["\<\
Ward\[CloseCurlyQuote]s minimum variance dissimilarity\
\>", "Text"]},
          {
            StyleBox["f",
              "TI"], Cell["a pure function", "Text"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"linkages"],

Cell[TextData[{
  "Possible values for the ",
  StyleBox["Linkage", "MR"],
  " option."
}], "Caption"],

Cell["\<\
Linkage methods determine this intercluster dissimilarity, or fusion level, \
given the dissimilarities between member elements. Common algorithms include \
single linkage, which selects the smallest distance between elements; \
complete linkage, which selects the largest distance between elements; and \
centroid linkage, which uses the dissimilarity between cluster centroids.\
\>", "Text"],

Cell[TextData[{
  "With ",
  StyleBox["Linkage->", "MR"],
  " ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", ",
  StyleBox["f",
    FontSlant->"Italic"],
  " is a pure function that defines the linkage algorithm. Distances or \
dissimilarities between clusters are determined recursively using information \
about the distances or dissimilarities of the unmerged clusters and their \
counterparts to determine the distances or dissimilarities for the newly \
merged cluster. If ",
  StyleBox["i",
    FontSlant->"Italic"],
  " and ",
  StyleBox["j",
    FontSlant->"Italic"],
  " represent clusters to be merged, new distances or dissimilarities are \
recursively calculated between this merged cluster and the remaining ",
  StyleBox["k",
    FontSlant->"Italic"],
  " clusters. The function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " defines the recursion and is passed arguments ",
  Cell[BoxData[
      \(TraditionalForm\`f[d\_\(i, k\), d\_\(j, k\), d\_\(i, j\), n\_i, n\_j, 
        n\_k]\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`d\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  " represents the distances or dissimilarities between clusters and ",
  StyleBox["n",
    FontSlant->"Italic"],
  " represents the number of data elements in a cluster. The function returns \
the dissimilarity between ",
  StyleBox["k",
    FontSlant->"Italic"],
  " and the cluster formed by merging clusters ",
  StyleBox["i",
    FontSlant->"Italic"],
  " and ",
  StyleBox["j",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "This clusters ",
  StyleBox["data2", "MR"],
  " using the average linkage method."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Agglomerate[data2, Linkage \[Rule] "\<Average\>"]\)], "Input",
  CellLabel->"In[33]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[
      Cluster[{0.7253055971477931`, \(-1.1302536982240747`\)}, 
        Cluster[{0.2169129449840166`, \(-0.33368074105304846`\)}, 
          Cluster[{\(-0.38070042430357054`\), \(-0.24750818092033833`\)}, \
{\(-0.3152439519516439`\), \(-0.2760546508444408`\)}, 0.005099450717886225`, 
            1, 1], 0.32553958925000465`, 1, 2], 1.5692933031173812`, 1, 3], 
      Cluster[Cluster[
          Cluster[Cluster[{0.5810146986977534`, 
                1.4463710601068265`}, {0.8460694069050189`, 
                2.0329569918374406`}, 0.4143370536471114`, 1, 1], 
            Cluster[{\(-0.25171211458875775`\), 
                2.0210234868823256`}, {\(-0.02675560596423776`\), 
                1.1506670168024957`}, 0.8081258157823555`, 1, 1], 
            1.056502690557956`, 2, 2], {1.1616304061543707`, 
            0.794607673348773`}, 1.858917572349461`, 4, 
          1], {2.4423867332670177`, 1.9380008134953024`}, 4.638591151045734`, 
        5, 1], 6.1180264431022895`, 4, 6]\)], "Output",
  CellLabel->"Out[33]="]
}, Open  ]],

Cell[TextData[{
  "This clusters ",
  StyleBox["data2", "MR"],
  " using a recursion function. It is equivalent to the average linkage."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Agglomerate[data2, 
      Linkage \[Rule] \((#1\ #4\/\(#4 + #5\) + #2\ #5\/\(#4 + #5\) &)\)]\)], \
"Input",
  CellLabel->"In[34]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[
      Cluster[{0.7253055971477931`, \(-1.1302536982240747`\)}, 
        Cluster[{0.2169129449840166`, \(-0.33368074105304846`\)}, 
          Cluster[{\(-0.38070042430357054`\), \(-0.24750818092033833`\)}, \
{\(-0.3152439519516439`\), \(-0.2760546508444408`\)}, 0.005099450717886225`, 
            1, 1], 0.32553958925000465`, 1, 2], 1.569293303117381`, 1, 3], 
      Cluster[Cluster[
          Cluster[Cluster[{0.5810146986977534`, 
                1.4463710601068265`}, {0.8460694069050189`, 
                2.0329569918374406`}, 0.4143370536471114`, 1, 1], 
            Cluster[{\(-0.25171211458875775`\), 
                2.0210234868823256`}, {\(-0.02675560596423776`\), 
                1.1506670168024957`}, 0.8081258157823555`, 1, 1], 
            1.056502690557956`, 2, 2], {1.1616304061543707`, 
            0.794607673348773`}, 1.858917572349461`, 4, 
          1], {2.4423867332670177`, 1.9380008134953024`}, 4.638591151045734`, 
        5, 1], 6.118026443102289`, 4, 6]\)], "Output",
  CellLabel->"Out[34]="]
}, Open  ]],

Cell[TextData[{
  "Elements can be labeled using a list of rules or a single rule. Distances \
or dissimilarities between elements are computed using the expression on the \
left\[Hyphen]hand sides of the rules. The output ",
  StyleBox["Cluster", "MR"],
  " object contains the right\[Hyphen]hand sides of the rules."
}], "Text"],

Cell["This clusters the data showing results by label.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Agglomerate[
      data2 \[Rule] {"\<a\>", "\<b\>", \ "\<c\>", \ "\<d\>", \ "\<e\>", \ \
"\<f\>", \ "\<g\>", \ "\<h\>", \ "\<i\>", \ "\<j\>"}]\)], "Input",
  CellLabel->"In[35]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[
      Cluster[Cluster["a", 
          Cluster["d", Cluster["h", "f", 0.005099450717886225`, 1, 1], 
            0.28651172922892176`, 1, 2], 0.8929915648703123`, 1, 3], 
        Cluster[Cluster[
            Cluster["e", Cluster["b", "c", 0.4143370536471114`, 1, 1], 
              0.456825624455459`, 1, 2], "i", 0.7619101120636763`, 3, 1], 
          "j", 0.8081258157823555`, 4, 1], 2.0801708179565495`, 4, 5], "g", 
      2.5572456822488645`, 9, 1]\)], "Output",
  CellLabel->"Out[35]="]
}, Open  ]],

Cell[TextData[{
  "It is also possible to build a cluster hierarchy directly using a distance \
or dissimilarity matrix\[LongDash]a matrix that provides the pairwise \
distances or dissimilarities between all data elements in lieu of a distance \
or dissimilarity function. In a distance matrix the element in the ",
  Cell[BoxData[
      \(TraditionalForm\`i\^th\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " row and ",
  Cell[BoxData[
      \(TraditionalForm\`j\^th\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  "column stores the distance value between the ",
  Cell[BoxData[
      \(TraditionalForm\`i\^th\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`j\^th\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  " data elements. Note that only the upper\[Hyphen]triangular portion of the \
matrix is used, that is ",
  Cell[BoxData[
      \(TraditionalForm\`i < j\)],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  ", since distances and dissimilarities are symmetric."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DistanceMatrix",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "computes the symmetric matrix of distance or dissimilarity \
coefficents between the elements of ",
              StyleBox["list", "TI"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["DirectAgglomerate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["mat",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "constructs", " ", "a", " ", "cluster", " ", "hierarchy", " ", 
              "based", " ", "on", " ", "the", " ", "square", " ", "distance", 
              " ", "matrix", " ", 
              StyleBox["mat",
                "TI"]}]},
          {
            RowBox[{
              StyleBox["DirectAgglomerate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["mat",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["list",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "associates", " ", "the", " ", "elements", " ", "of", " ", 
              StyleBox["list",
                FontSlant->"Italic"], " ", "with", " ", "the", " ", 
              "corresponding", " ", "rows", " ", "in", " ", "the", " ", 
              "distance", " ", "matrix"}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["\<\
Functions for clustering using distance or dissimilarity matrices.\
\>", "Caption"],

Cell[TextData[{
  "The ",
  StyleBox["DistanceMatrix", "MR"],
  " function can be given a ",
  StyleBox["DistanceFunction", "MR"],
  " option to define the distance measure."
}], "Text"],

Cell["Here is an example distance matrix.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dc = DistanceMatrix[data2]\)], "Input",
  CellLabel->"In[36]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \({{0.`, 6.659815008619295`, 10.020485767466527`, 0.8929915648703123`, 
        5.768195361463636`, 2.0024889678065154`, 12.3625533767028`, 
        1.8123993766753157`, 3.895470638727931`, 
        10.885111506419044`}, {6.659815008619295`, 0.`, 0.4143370536471114`, 
        3.3011545018699335`, 0.456825624455459`, 3.7941228609922155`, 
        3.706405665493336`, 3.770029898609857`, 0.7619101120636763`, 
        1.0236593571652783`}, {10.020485767466527`, 0.4143370536471114`, 0.`, 
        5.996812012317988`, 1.5402591031373816`, 6.7054856229247175`, 
        2.5572456822488645`, 6.680183483499424`, 1.633087778848597`, 
        1.2052666774737049`}, {0.8929915648703123`, 3.3011545018699335`, 
        5.996812012317988`, 0.`, 2.262662628972003`, 0.36456744927108753`, 
        10.113270667609903`, 0.28651172922892176`, 2.165525827513536`, 
        5.764241447516312`}, {5.768195361463636`, 0.456825624455459`, 
        1.5402591031373816`, 2.262662628972003`, 0.`, 2.0801708179565495`, 
        6.716558398799106`, 2.118760242703805`, 1.5390395698598656`, 
        0.8081258157823555`}, {2.0024889678065154`, 3.7941228609922155`, 
        6.7054856229247175`, 0.36456744927108753`, 2.0801708179565495`, 0.`, 
        12.746270663911648`, 0.005099450717886225`, 3.4647898443001224`, 
        5.162873911866621`}, {12.3625533767028`, 3.706405665493336`, 
        2.5572456822488645`, 10.113270667609903`, 6.716558398799106`, 
        12.746270663911648`, 0.`, 12.50656859523222`, 2.9476846423732184`, 
        7.2650613663141455`}, {1.8123993766753157`, 3.770029898609857`, 
        6.680183483499424`, 0.28651172922892176`, 2.118760242703805`, 
        0.005099450717886225`, 12.50656859523222`, 0.`, 3.3274756820778673`, 
        5.2806042651809735`}, {3.895470638727931`, 0.7619101120636763`, 
        1.633087778848597`, 2.165525827513536`, 1.5390395698598656`, 
        3.4647898443001224`, 2.9476846423732184`, 3.3274756820778673`, 0.`, 
        3.501632828625706`}, {10.885111506419044`, 1.0236593571652783`, 
        1.2052666774737049`, 5.764241447516312`, 0.8081258157823555`, 
        5.162873911866621`, 7.2650613663141455`, 5.2806042651809735`, 
        3.501632828625706`, 0.`}}\)], "Output",
  CellLabel->"Out[36]="]
}, Open  ]],

Cell["\<\
This clusters the distance matrix directly. Row numbers of the matrix are \
used to represent the data elements.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DirectAgglomerate[dc]\)], "Input",
  CellLabel->"In[37]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[
      Cluster[Cluster[1, 
          Cluster[4, Cluster[6, 8, 0.005099450717886225`, 1, 1], 
            0.28651172922892176`, 1, 2], 0.8929915648703123`, 1, 3], 
        Cluster[Cluster[
            Cluster[Cluster[2, 3, 0.4143370536471114`, 1, 1], 5, 
              0.456825624455459`, 2, 1], 9, 0.7619101120636763`, 3, 1], 10, 
          0.8081258157823555`, 4, 1], 2.0801708179565495`, 4, 5], 7, 
      2.5572456822488645`, 9, 1]\)], "Output",
  CellLabel->"Out[37]="]
}, Open  ]],

Cell[TextData[{
  "This clusters the distance matrix while specifying the corresponding data \
elements to store in the ",
  StyleBox["Cluster", "MR"],
  " expression."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DirectAgglomerate[dc, data2]\)], "Input",
  CellLabel->"In[38]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[BoxData[
    \(Cluster[
      Cluster[Cluster[{0.7253055971477931`, \(-1.1302536982240747`\)}, 
          Cluster[{0.2169129449840166`, \(-0.33368074105304846`\)}, 
            Cluster[{\(-0.38070042430357054`\), \(-0.24750818092033833`\)}, {\
\(-0.3152439519516439`\), \(-0.2760546508444408`\)}, 0.005099450717886225`, 
              1, 1], 0.28651172922892176`, 1, 2], 0.8929915648703123`, 1, 3], 
        Cluster[Cluster[
            Cluster[Cluster[{0.5810146986977534`, 
                  1.4463710601068265`}, {0.8460694069050189`, 
                  2.0329569918374406`}, 0.4143370536471114`, 1, 
                1], {\(-0.02675560596423776`\), 1.1506670168024957`}, 
              0.456825624455459`, 2, 1], {1.1616304061543707`, 
              0.794607673348773`}, 0.7619101120636763`, 3, 
            1], {\(-0.25171211458875775`\), 2.0210234868823256`}, 
          0.8081258157823555`, 4, 1], 2.0801708179565495`, 4, 
        5], {2.4423867332670177`, 1.9380008134953024`}, 2.5572456822488645`, 
      9, 1]\)], "Output",
  CellLabel->"Out[38]="]
}, Open  ]],

Cell["\<\
The binary tree structure of the hierarchical cluster leads naturally to a \
graphical representation\[LongDash]the dendrogram. A dendrogram plot shows a \
visual representation of the merger history by connecting two lines \
representing clusters with a bar at their fusion level.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DendrogramPlot",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "plots a dendrogram derived from clustering ",
              StyleBox["list",
                FontSlant->"Italic"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["DendrogramPlot",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["cluster",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "plots", " ", "a", " ", "dendrogram", " ", "for", " ", "the", " ",
               
              StyleBox["Cluster",
                "MR"], " ", "expression", " ", 
              StyleBox["cluster",
                FontSlant->"Italic"]}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}}],

Cell["Dendrogram plotting functions.", "Caption"],

Cell["This generates a basic dendrogram plot.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[data2];\)\)], "Input",
  CellLabel->"In[39]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0820106 0.10582 0.0147151 0.230171 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.23545 .01472 m
.23545 .01589 L
.34127 .01589 L
.34127 .01472 L
s
.12963 .01472 m
.12963 .08066 L
.28836 .08066 L
.28836 .01589 L
s
.02381 .01472 m
.02381 .22026 L
.20899 .22026 L
.20899 .08066 L
s
.55291 .01472 m
.55291 .11008 L
.65873 .11008 L
.65873 .01472 L
s
.44709 .01472 m
.44709 .11986 L
.60582 .11986 L
.60582 .11008 L
s
.52646 .11986 m
.52646 .19008 L
.76455 .19008 L
.76455 .01472 L
s
.6455 .19008 m
.6455 .20072 L
.87037 .20072 L
.87037 .01472 L
s
.1164 .22026 m
.1164 .49351 L
.75794 .49351 L
.75794 .20072 L
s
.43717 .49351 m
.43717 .60332 L
.97619 .60332 L
.97619 .01472 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[39]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo:P00000X0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo0009
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`00
0000oooo0?ooo`0V0?oooch00000?03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05T0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?oo
o`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1I0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0
oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05T0
oooo00<000000?ooo`3oool09@3ooolZ000002P0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo
00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<00000
0?ooo`3oool0F@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oooln000003`0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`03
0000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`00
2@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003o
ool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool0
0`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo
07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo
00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?oo
o`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3o
ool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000
003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3o
ool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0
oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0
oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo0009
0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?oo
o`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`03
0000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0
M`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003o
ool0oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool0
0`000000oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
04@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo
00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?oooed000009`3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`2U
0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0:D0oooo00<000000?oo
o`3oool0D`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`03
0000003oool0oooo04@0oooo00<000000?ooo`3oool0Y@3ooomG000002P0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`3@0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03o
ool00`000000oooo0?ooo`3@0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203o
ool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`3@0?ooo`030000003oool0
oooo0540oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`3@0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool000T0
oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`3@0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo
0?ooo`3@0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool000T0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`3@0?ooo`030000003oool0oooo0540oooo00<0
00000?ooo`3oool0203oool000T0ooooB000003B0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?oo
o`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3o
ool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3o
ool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0
oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`00
0000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0
oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0
oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo
0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<0
00000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A
0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?oo
o`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`03
0000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0
l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003o
ool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool0
0`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool0
02d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo
00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000
oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo
00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3o
ool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000
003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3o
ool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203o
ool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0
oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`00
0000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo
0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<0
00000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c
0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?oo
o`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`03
0000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00
;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0
203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003o
ool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool0
0`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo
0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000
oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo
00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?oo
o`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<00000
0?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?oo
o`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?oo
o`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3o
ool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000
003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3o
ool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0
oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`00
0000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0
oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo
0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<0
00000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]
0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`08
0?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?oo
o`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`03
0000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0
D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003o
ool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool0
0`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo
0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000
oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo
00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo
000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?oo
o`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?oo
o`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3o
ool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3o
ool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0
oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`00
0000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0
oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0
oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo
0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<0
00000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A
0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?oo
o`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`03
0000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0
l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003o
ool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool0
0`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool0
02d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo
00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000
oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo
00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3o
ool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000
003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3o
ool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203o
ool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0
oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`00
0000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo
0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<0
00000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c
0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?oo
o`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`03
0000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00
;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0
203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003o
ool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool0
0`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo
0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000
oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo
00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?oo
o`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<00000
0?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?oo
o`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?oo
o`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3o
ool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000
003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3o
ool00`000000oooo0?ooo`080?ooo`00;@3oooog000005<0oooo00<000000?ooo`3oool0203oool0
0:P0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`080?ooo`00Z03oool00`000000
oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo002X0?ooo`030000003oool0oooo0<`0oooo
00<000000?ooo`3oool0203oool00:P0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?oo
o`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo002X0?oo
o`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0203oool00:P0oooo00<000000?ooo`3o
ool0c03oool00`000000oooo0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?ooo`030000
003oool0oooo00P0oooo002X0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0203o
ool00:P0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`080?ooo`00Z03oool00`00
0000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo002X0?ooo`030000003oool0oooo0<`0
oooo00<000000?ooo`3oool0203oool00:P0oooo00<000000?ooo`3oool0c03oool00`000000oooo
0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo002X
0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0203oool00:P0oooo00<000000?oo
o`3oool0c03oool00`000000oooo0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?ooo`03
0000003oool0oooo00P0oooo002X0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0
203oool00:P0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`080?ooo`00Z03oool0
0`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo002X0?ooo`030000003oool0oooo
0<`0oooo00<000000?ooo`3oool0203oool00:P0oooo00<000000?ooo`3oool0c03oool00`000000
oooo0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo
002X0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0203oool00:P0oooo00<00000
0?ooo`3oool0c03oool00`000000oooo0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?oo
o`030000003oool0oooo00P0oooo002X0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3o
ool0203oool00:P0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`080?ooo`00Z03o
ool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo002X0?ooo`030000003oool0
oooo0<`0oooo00<000000?ooo`3oool0203oool00:P0oooo00<000000?ooo`3oool0c03oool00`00
0000oooo0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0
oooo002X0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0203oool00:P0oooo00<0
00000?ooo`3oool0c03oool00`000000oooo0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<
0?ooo`030000003oool0oooo00P0oooo002X0?ooo`030000003oool0oooo0<`0oooo00<000000?oo
o`3oool0203oool00:P0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`080?ooo`00
Z03oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo00P0oooo002X0?ooo`030000003o
ool0oooo0<`0oooo00<000000?ooo`3oool0203oool00:P0oooo00<000000?ooo`3oool0c03oool0
0`000000oooo0?ooo`080?ooo`00Z03oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo
00P0oooo002X0?ooom0000002P3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool0
0?l0ooooP`3oool00?l0ooooP`3oool00001\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {0.763676, -0.0639446, \
0.0246043, 0.0113117}}]
}, Open  ]],

Cell["This generates a dendrogram using the Manhattan distance.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[data2, 
        DistanceFunction -> ManhattanDistance];\)\)], "Input",
  CellLabel->"In[40]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0820106 0.10582 0.0147151 0.343167 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.23545 .01472 m
.23545 .04697 L
.34127 .04697 L
.34127 .01472 L
s
.12963 .01472 m
.12963 .21711 L
.28836 .21711 L
.28836 .04697 L
s
.02381 .01472 m
.02381 .46254 L
.20899 .46254 L
.20899 .21711 L
s
.55291 .01472 m
.55291 .30697 L
.65873 .30697 L
.65873 .01472 L
s
.44709 .01472 m
.44709 .32476 L
.60582 .32476 L
.60582 .30697 L
s
.52646 .32476 m
.52646 .39059 L
.76455 .39059 L
.76455 .01472 L
s
.6455 .39059 m
.6455 .43763 L
.87037 .43763 L
.87037 .01472 L
s
.75794 .43763 m
.75794 .5951 L
.97619 .5951 L
.97619 .01472 L
s
.1164 .46254 m
.1164 .60332 L
.86706 .60332 L
.86706 .5951 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[40]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`00
2@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02D0oooo:P00000X0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0
oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool0
00T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203o
ool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`00
2@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo0009
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo02H0oooo?P00000l0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1I0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`00
2@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool0
0`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo
05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo
00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`140?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<00000
0?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1I0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000
003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03o
ool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0
oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0
oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1I
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05T0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`03
0000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0
A03oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003o
ool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool0
00T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo
00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05T0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3o
ool0A03oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000
003oool0oooo05T0oooo00<000000?ooo`3oool09@3ooolZ000002P0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo
00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<00000
0?ooo`3oool0F@3oooln000003`0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`03
0000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0
A03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool0
00T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo
05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`000000
oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo
00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`1g0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<00000
0?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3o
ool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000
003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203o
ool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0
oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`00
0000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0
oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo
0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?oo
o`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo05T0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`03
0000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1I0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`00
2@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1g0?ooo`030000003o
ool0oooo05T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0M`3ooomM
000002L0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`00
0000oooo0?ooo`140?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0
oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo
0?ooo`2U0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0:D0oooo00<0
00000?ooo`3oool0D`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo0009
0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?oo
o`3oool0A03oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo05<0oooo00<000000?oo
o`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`03
0000003oool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0
Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`2U0?ooo`030000003o
ool0oooo05<0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
04@0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`2U0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0:D0oooo
00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?oo
o`1C0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo05<0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`2U0?oooeL00000
:03oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003o
ool0oooo0=00oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`002@3oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3oool0D@3oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo
0=00oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3oool0D@3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0=00oooo
00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`140?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0=00oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo0=00oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3o
ool0D@3oool00`000000oooo0?ooo`080?ooo`002@3ooom800000=80oooo00<000000?ooo`3oool0
D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003o
ool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool0
0`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo
0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000
oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo
00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo
000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?oo
o`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?oo
o`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3o
ool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000
003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3o
ool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0
oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`00
0000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0
oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0
oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo
0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<0
00000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A
0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?oo
o`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`03
0000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0
l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003o
ool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool0
0`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool0
02d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo
00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000
oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo
00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3o
ool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000
003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3o
ool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203o
ool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0
oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`00
0000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo
0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<0
00000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c
0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?oo
o`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`03
0000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00
;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0
203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003o
ool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool0
0`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo
0540oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000
oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0oooo
00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?oo
o`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0203oool002d0oooo00<00000
0?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00P0oooo000]0?oo
o`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`080?oo
o`00;@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3o
ool0203oool002d0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`1A0?ooo`030000
003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0?<0ooooE@00000:0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooah0oooo00<000000?ooo`3oool0<P3oool002d0oooo00<000000?oo
o`3oool0o`3ooolN0?ooo`030000003oool0oooo0380oooo000]0?ooool000008P00000d0?ooo`00
o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00
\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {0.763676, -0.0428893, \
0.0246043, 0.00758706}}]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["TruncateDendrogram",
              "MR"], 
            StyleBox["All",
              "MR"], Cell[
            "the level at which to truncate the dendrogram", "Text"]},
          {
            StyleBox["HighlightLevel",
              "MR"], 
            StyleBox["None",
              "MR"], Cell[
            "the level at which to highlight the clusters", "Text"]},
          {
            StyleBox["HighlightStyle",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell["\<\
graphics directives to specify the style of each highlighted cluster\
\>", "Text"]},
          {
            StyleBox["LeafLabels",
              "MR"], 
            StyleBox["None",
              "MR"], Cell["the leaf labels", "Text"]},
          {
            StyleBox["DistanceFunction",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(the\ distance\ or\ dissimilarity\ measure\ to\ use\)},
          {
            StyleBox["Linkage",
              "MR"], 
            StyleBox["Automatic",
              "MR"], \(the\ clustering\ linkage\ algorithm\ to\ use\)},
          {
            StyleBox["Orientation",
              "MR"], 
            StyleBox["Top",
              "MR"], Cell["the orientation of the dendrogram", "Text"]},
          {
            StyleBox["PlotStyle",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell[
            "graphics directives to specify the style of the dendrogram", 
              "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options for ",
  StyleBox["DendrogramPlot.", "MR"]
}], "Caption"],

Cell["\<\
This generates a dendrogram using Ward\[CloseCurlyQuote]s linkage method to \
cluster the data.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[data2, Linkage \[Rule] "\<Ward\>"];\)\)], "Input",
  CellLabel->"In[41]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0820106 0.10582 0.0147151 0.0513011 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.23545 .01472 m
.23545 .01485 L
.34127 .01485 L
.34127 .01472 L
s
.12963 .01472 m
.12963 .02581 L
.28836 .02581 L
.28836 .01485 L
s
.02381 .01472 m
.02381 .07229 L
.20899 .07229 L
.20899 .02581 L
s
.44709 .01472 m
.44709 .02534 L
.55291 .02534 L
.55291 .01472 L
s
.5 .02534 m
.5 .05213 L
.65873 .05213 L
.65873 .01472 L
s
.76455 .01472 m
.76455 .03544 L
.87037 .03544 L
.87037 .01472 L
s
.57937 .05213 m
.57937 .07814 L
.81746 .07814 L
.81746 .03544 L
s
.69841 .07814 m
.69841 .19099 L
.97619 .19099 L
.97619 .01472 L
s
.1164 .07229 m
.1164 .60332 L
.8373 .60332 L
.8373 .19099 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[41]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo:P00000X0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo00P0oooo00090?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0V0?oooch00000?03ooolY
000002P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`1]0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0
oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo03X0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo
0?ooo`1]0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool000T0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool09P3ooolY000002P0oooo00<000000?ooo`3oool0203oool000T0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0j0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1]0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K@3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0
oooo06d0oooo?P00000l0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0203oool0
00T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`2;0?ooo`030000003oool0oooo
05T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo08/0oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo04@0oooo
00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`2;0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo08/0oooo00<00000
0?ooo`3oool0F@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`1I0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3o
ool0A03oool00`000000oooo0?ooo`2;0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`080?ooo`002@3ooom8000008d0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003o
ool0oooo0:h0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0j0?ooo`030000003o
ool0oooo00P0oooo000]0?ooo`030000003oool0oooo0:h0ooooG@00000l0?ooo`030000003oool0
oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0J03oool00`00
0000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0g03oool00`000000oooo
0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0oooo00<0
00000?ooo`3oool0J03oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3L
0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?oo
o`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]0?ooo`03
0000003oool0oooo0=`0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`080?ooo`00
;@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0
203oool002d0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`030000003o
ool0oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0J03oool0
0`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo
06P0oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0g03oool00`000000
oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0oooo
00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?oo
o`3L0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0203oool002d0oooo00<00000
0?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]0?oo
o`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`080?oo
o`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3o
ool0203oool002d0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`030000
003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0J03o
ool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0
oooo06P0oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0g03oool00`00
0000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0
oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo
0?ooo`3L0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0203oool002d0oooo00<0
00000?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]
0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`08
0?ooo`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo06P0oooo00<000000?oo
o`3oool0203oool002d0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`03
0000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0
J03oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000003o
ool0oooo06P0oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0g03oool0
0`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo
0=`0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000
oooo0?ooo`3L0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0203oool002d0oooo
00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo
000]0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?oo
o`080?ooo`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo06P0oooo00<00000
0?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?oo
o`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3o
ool0J03oool00`000000oooo0?ooo`080?ooo`00;@3oool00`000000oooo0?ooo`3L0?ooo`030000
003oool0oooo06P0oooo00<000000?ooo`3oool0203oool002d0oooo00<000000?ooo`3oool0g03o
ool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0oooo000]0?ooo`030000003oool0
oooo0=`0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`080?ooo`00;@3oool00`00
0000oooo0?ooo`3L0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0203oool002d0
oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00P0
oooo000]0?ooo`030000003oool0oooo0=`0ooooK000000:0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo
00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003o
ool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m
0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0
oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000
003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?oo
o`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`030000003oool0oooo03d0oooo000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`00
0000oooo0?ooo`0m0?ooo`00;@3oool00`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3o
ool0?@3oool002d0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo
000]0?ooo`030000003oool0oooo0?l0oooo4`3oool00`000000oooo0?ooo`0m0?ooo`00;@3oool0
0`000000oooo0?ooo`3o0?oooa<0oooo00<000000?ooo`3oool0?@3oool002d0oooo00<000000?oo
o`3oool0o`3ooolC0?ooo`030000003oool0oooo03d0oooo000]0?ooool000005`00000o0?ooo`00
o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00
\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {0.763676, -0.286898, \
0.0246043, 0.0507519}}]
}, Open  ]],

Cell[TextData[{
  "The option ",
  StyleBox["LeafLabels", "MR"],
  " is provided to support labeling of the dendrogram. For data, a value of \
",
  StyleBox["LeafLabels\[Rule]Automatic", "MR"],
  " will use the data element position for the label, but the option can also \
take a list of expressions or a function. The function will be applied to \
each data element to generate the label expression.",
  " ",
  "For ",
  StyleBox["Cluster", "MR"],
  " objects, the ",
  StyleBox["LeafLabels", "MR"],
  " option can take a function but not a list or ",
  StyleBox["Automatic", "MR"],
  ", as there is no unambiguous mapping between the labels and data points in \
a ",
  StyleBox["Cluster", "MR"],
  " object."
}], "Text"],

Cell["\<\
This generates a dendrogram with automatically generated labels.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[data2, LeafLabels \[Rule] Automatic, 
        Orientation \[Rule] Left];\)\)], "Input",
  CellLabel->"In[42]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.372425 -0.0506853 0.0654004 [
[.97619 .01472 4 -4.5 ]
[.97619 .01472 10 4.5 ]
[.97619 .08012 4 -4.5 ]
[.97619 .08012 10 4.5 ]
[.97619 .14552 4 -4.5 ]
[.97619 .14552 10 4.5 ]
[.97619 .21092 4 -4.5 ]
[.97619 .21092 10 4.5 ]
[.97619 .27632 4 -4.5 ]
[.97619 .27632 10 4.5 ]
[.97619 .34172 4 -4.5 ]
[.97619 .34172 10 4.5 ]
[.97619 .40712 4 -4.5 ]
[.97619 .40712 10 4.5 ]
[.97619 .47252 4 -4.5 ]
[.97619 .47252 10 4.5 ]
[.97619 .53792 4 -4.5 ]
[.97619 .53792 16 4.5 ]
[.97619 .60332 4 -4.5 ]
[.97619 .60332 10 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.97619 .14552 m
.97429 .14552 L
.97429 .21092 L
.97619 .21092 L
s
.97619 .08012 m
.86949 .08012 L
.86949 .17822 L
.97429 .17822 L
s
.97619 .01472 m
.64362 .01472 L
.64362 .12917 L
.86949 .12917 L
s
.97619 .34172 m
.82188 .34172 L
.82188 .40712 L
.97619 .40712 L
s
.97619 .27632 m
.80606 .27632 L
.80606 .37442 L
.82188 .37442 L
s
.80606 .32537 m
.69244 .32537 L
.69244 .47252 L
.97619 .47252 L
s
.69244 .39894 m
.67522 .39894 L
.67522 .53792 L
.97619 .53792 L
s
.64362 .07194 m
.20148 .07194 L
.20148 .46843 L
.67522 .46843 L
s
.20148 .27019 m
.02381 .27019 L
.02381 .60332 L
.97619 .60332 L
s
[(1)] .97619 .01472 4 0 Mabsadd -1 0 Mshowa
[(4)] .97619 .08012 4 0 Mabsadd -1 0 Mshowa
[(8)] .97619 .14552 4 0 Mabsadd -1 0 Mshowa
[(6)] .97619 .21092 4 0 Mabsadd -1 0 Mshowa
[(5)] .97619 .27632 4 0 Mabsadd -1 0 Mshowa
[(2)] .97619 .34172 4 0 Mabsadd -1 0 Mshowa
[(3)] .97619 .40712 4 0 Mabsadd -1 0 Mshowa
[(9)] .97619 .47252 4 0 Mabsadd -1 0 Mshowa
[(10)] .97619 .53792 4 0 Mabsadd -1 0 Mshowa
[(7)] .97619 .60332 4 0 Mabsadd -1 0 Mshowa
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[42]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooomg0?ooo`D000001`3oool00?l0ooooN@3oool00`000000oooo0?ooo`070?ooo`00
l`3ooomo000000H0oooo00<000000?ooo`3oool01`3oool00?<0oooo00<000000?ooo`3oool0PP3o
ool00`000000oooo0?ooo`070?ooo`00l`3oool00`000000oooo0?ooo`220?ooo`030000003oool0
oooo00L0oooo003c0?ooo`030000003oool0oooo0840oooo0P0000090?ooo`00l`3oool00`000000
oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?oo
o`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?oo
o`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3o
ool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`00
0000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo
0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<
0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00l`3oool00`000000oooo0?ooo`2<0?ooo`00
l`3oool00`000000oooo0?ooo`2<0?ooo`00C03ooonX000008h0oooo001<0?ooo`030000003oool0
oooo0:@0oooo00<000000?ooo`3oool0PP3oool3000000L0oooo001<0?ooo`030000003oool0oooo
0:@0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`060?ooo`00C03oool00`000000
oooo0?ooo`2T0?ooo`030000003oool0oooo0580oooo:P0000040?ooo`D000001`3oool004`0oooo
00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo02/0oooo
00@000000?ooo`3oool00000203oool004`0oooo00<000000?ooo`3oool0Y03oool00`000000oooo
0?ooo`1B0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`000000203oool004`0oooo00<0
00000?ooo`3oool0Y03oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo02d0oooo0P00
00080?ooo`00C03oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo0580oooo00<00000
0?ooo`3oool0=`3oool004`0oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`1B0?oo
o`030000003oool0oooo03L0oooo001<0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3o
ool0DP3oool00`000000oooo0?ooo`0g0?ooo`00C03oool00`000000oooo0?ooo`2T0?ooo`030000
003oool0oooo0580oooo00<000000?ooo`3oool0=`3oool004`0oooo00<000000?ooo`3oool0Y03o
ool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo03L0oooo001<0?ooo`030000003oool0
oooo0:@0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0g0?ooo`00C03oool00`00
0000oooo0?ooo`2T0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0=`3oool004`0
oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo03L0
oooo001<0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0DP3oool00`000000oooo
0?ooo`0g0?ooo`00C03oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo0580oooo00<0
00000?ooo`3oool0=`3oool004`0oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`1B
0?ooo`030000003oool0oooo03L0oooo001<0?ooo`030000003oool0oooo0:@0oooo00<000000?oo
o`3oool0DP3oool00`000000oooo0?ooo`0g0?ooo`00C03oool00`000000oooo0?ooo`2T0?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool0=`3oool004`0oooo00<000000?ooo`3oool0
Y03oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo03L0oooo001<0?ooo`030000003o
ool0oooo0:@0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0g0?ooo`00C03oool0
0`000000oooo0?ooo`2T0?oooeH00000>@3oool004`0oooo00<000000?ooo`3oool0n@3oool00`00
0000oooo0?ooo`0g0?ooo`00C03oool00`000000oooo0?ooo`3i0?ooo`030000003oool0oooo03L0
oooo001<0?ooo`030000003oool0oooo0?T0oooo00<000000?ooo`3oool0=`3oool004`0oooo00<0
00000?ooo`3oool0n@3oool00`000000oooo0?ooo`0/0?ooo`8000002@3oool004`0oooo00<00000
0?ooo`3oool0n@3oool00`000000oooo0?ooo`0[0?ooo`040000003oool0oooo000000P0oooo001<
0?ooo`030000003oool0oooo0?T0oooo00<000000?ooo`3oool09@3oool2000000@0oooo00@00000
0?ooo`3oool00000203oool004`0oooo00<000000?ooo`3oool0n@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo00@0oooo0P0000090?ooo`00C03oool00`000000oooo0?ooo`3i0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`000008
0?ooo`00C03oool00`000000oooo0?ooo`3i0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool0103oool2000000T0oooo001<0?ooo`030000003oool0oooo0?T0oooo00<000000?ooo`3o
ool09@3oool00`000000oooo0?ooo`0?0?ooo`00C03oool00`000000oooo0?ooo`3i0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool03`3oool004`0oooo00<000000?ooo`3oool0n@3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00l0oooo001<0?ooo`030000003oool0
oooo0?T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0?0?ooo`00C03oool00`00
0000oooo0?ooo`3i0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool03`3oool004`0
oooo00<000000?ooo`3oool0n@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00l0
oooo001<0?ooo`030000003oool0oooo0?T0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0?0?ooo`00C03oool00`000000oooo0?ooo`3i0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool03`3oool004`0oooo00<000000?ooo`3oool0n@3ooolY00000140oooo001<0?oo
o`030000003oool0oooo0?l0oooo8P3oool00`000000oooo0?ooo`0?0?ooo`00C03oool00`000000
oooo0?ooo`3o0?ooob80oooo00<000000?ooo`3oool03`3oool004`0oooo00<000000?ooo`3oool0
o`3ooolR0?ooo`030000003oool0oooo00l0oooo001<0?ooo`030000003oool0oooo0?l0oooo8P3o
ool00`000000oooo0?ooo`0?0?ooo`00C03oool00`000000oooo0?ooo`3o0?ooob80oooo00<00000
0?ooo`3oool03`3oool004`0oooo00<000000?ooo`3oool0o`3ooolR0?ooo`030000003oool0oooo
00l0oooo001<0?ooo`030000003oool0oooo0?l0oooo8P3oool00`000000oooo0?ooo`0?0?ooo`00
C03oool00`000000oooo0?ooo`3o0?ooob80oooo00<000000?ooo`3oool03`3oool004`0oooo00<0
00000?ooo`3oool0o`3ooolR0?ooo`030000003oool0oooo00l0oooo001<0?ooo`030000003oool0
oooo0?l0oooo8P3oool00`000000oooo0?ooo`0?0?ooo`00C03oool00`000000oooo0?ooo`3o0?oo
ob80oooo00<000000?ooo`3oool00`3oool3000000T0oooo001<0?ooo`030000003oool0oooo0?l0
oooo8P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000P0oooo001<0?ooo`03
0000003oool0oooo0?l0oooo8P3oool2000000@0oooo00@000000?ooo`3oool00000203oool004`0
oooo00<000000?ooo`3oool0o`3ooolX0?ooo`<000002@3oool004`0oooo00<000000?ooo`3oool0
o`3ooolY0?ooo`030000003oool0oooo00P0oooo001<0?ooo`030000003oool0oooo0?l0oooo:@3o
ool3000000P0oooo001<0?ooo`030000003oool0oooo0?l0oooo=03oool004`0oooo00<000000?oo
o`3oool0o`3ooold0?ooo`00C03oool00`000000oooo0?ooo`3o0?oooc@0oooo001<0?ooo`030000
003oool0oooo0?l0oooo=03oool004`0oooo00<000000?ooo`3oool0o`3ooold0?ooo`00C03oool0
0`000000oooo0?ooo`3o0?oooc@0oooo001<0?ooo`030000003oool0oooo0?l0oooo=03oool004`0
oooo00<000000?ooo`3oool0o`3ooold0?ooo`00C03oool00`000000oooo0?ooo`3o0?oooc@0oooo
001<0?ooo`030000003oool0oooo0?l0oooo=03oool004`0oooo00<000000?ooo`3oool0o`3ooold
0?ooo`00C03oool00`000000oooo0?ooo`3o0?oooc@0oooo001<0?ooo`030000003oool0oooo0?l0
oooo=03oool004`0oooo00<000000?ooo`3oool0o`3ooold0?ooo`00C03oool00`000000oooo0?oo
o`3o0?oooc@0oooo001<0?ooo`030000003oool0oooo0?l0oooo=03oool004`0oooo00<000000?oo
o`3oool0o`3ooold0?ooo`00C03oool00`000000oooo0?ooo`3o0?oooc@0oooo00090?oood@00000
o`3oool[0?ooo`8000002@3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`3o0?ooobP0oooo00@000000?ooo`3oool00000203oool000T0oooo00<000000?ooo`3oool0@03o
ool00`000000oooo0?ooo`3Q0?oood8000001`3oool00`000000oooo0?ooo`060?ooo`002@3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0>40oooo00<000000?ooo`3oool0A03oool2
000000T0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0h@3oool00`00
0000oooo0?ooo`140?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool0h@3oool00`000000oooo0?ooo`140?ooo`<00000203oool000T0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`3Q0?ooo`030000003oool0oooo04l0oooo
00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0h@3oool00`000000oooo0?oo
o`1?0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0>40oooo00<00000
0?ooo`3oool0C`3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`3Q0?oo
o`030000003oool0oooo04l0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3o
ool0h@3oool00`000000oooo0?ooo`1?0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000
003oool0oooo0>40oooo00<000000?ooo`3oool0C`3oool000T0oooo00<000000?ooo`3oool0@03o
ool00`000000oooo0?ooo`3Q0?ooo`030000003oool0oooo04l0oooo00090?ooo`030000003oool0
oooo0400oooo00<000000?ooo`3oool0h@3oool00`000000oooo0?ooo`1?0?ooo`002@3oool00`00
0000oooo0?ooo`100?ooo`030000003oool0oooo0>40oooo00<000000?ooo`3oool0C`3oool000T0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`3Q0?ooo`030000003oool0oooo04l0
oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0h@3oool00`000000oooo
0?ooo`1?0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0>40oooo00<0
00000?ooo`3oool0C`3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`3Q
0?ooo`030000003oool0oooo04l0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0h@3oool00`000000oooo0?ooo`1?0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo0>40oooo00<000000?ooo`3oool0C`3oool000T0oooo00<000000?ooo`3oool0
@03oool00`000000oooo0?ooo`2f0?ooob`00000D@3oool000T0oooo00<000000?ooo`3oool0@03o
ool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0C`3o
ool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2f0?ooo`030000003oool0
oooo02P0oooo00<000000?ooo`3oool0C`3oool000T0oooo00<000000?ooo`3oool0@03oool00`00
0000oooo0?ooo`2f0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0C`3oool000T0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo02P0
oooo00<000000?ooo`3oool0@`3oool4000000P0oooo00090?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo04<0oooo
00<000000?ooo`3oool02@3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`2f0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00`3oooll000000D0oooo00<0
00000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2f
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0o
0?ooo`030000003oool0oooo00L0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0]P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0?@3oool010000000oooo0?ooo`0000080?ooo`002@3oool00`000000oooo0?ooo`100?oo
o`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo03h0oooo0P0000090?ooo`002@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo0;H0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo04T0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
]P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
B@3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2f0?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`190?ooo`002@3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo04T0oooo00090?ooo`030000003oool0oooo
0400oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0B@3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000
oooo0?ooo`2f0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`190?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;H0oooo
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04T0oooo
00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0B@3oool000T0oooo00<00000
0?ooo`3oool0@03oool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo02P0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`190?ooo`002@3oool00`000000oooo0?ooo`100?oo
o`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0:03oool7000004/0oooo00090?ooo`03
0000003oool0oooo0400oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo04T0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
]P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04T0oooo00090?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0^0?ooo`030000003o
ool0oooo04T0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0]P3oool0
0`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04T0oooo00090?ooo`030000003oool0oooo
0400oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
04T0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0]P3oool00`000000
oooo0?ooo`0^0?ooo`030000003oool0oooo04T0oooo00090?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04T0oooo
00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo04T0oooo00090?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0/03oool700000300oooo00<000000?ooo`3oool0B@3oool000T0oooo00<000000?oo
o`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`0n0?ooo`8000002@3oool000T0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0;P3oool00`000000oooo0?ooo`0m0?ooo`040000003oool0oooo000000P0oooo00090?ooo`03
0000003oool0oooo0400oooo00<000000?ooo`3oool0/03oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo02h0oooo?00000060?ooo`030000003oool0oooo00L0oooo00090?ooo`030000
003oool0oooo0400oooo00<000000?ooo`3oool0/03oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0740oooo00<000000?ooo`3oool01P3oool000T0oooo00<000000?ooo`3oool0@03o
ool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0KP3o
ool010000000oooo0?ooo`0000080?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003o
ool0oooo0;00oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1_0?ooo`8000002@3o
ool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`00
0000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<0
00000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?oo
o`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0
@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool0
00T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000
oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<00000
0?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0NP3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2`0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0NP3oool000T0oooo00<000000?ooo`3oool0@03o
oond000000D0oooo00<000000?ooo`3oool0KP3oool3000000T0oooo00090?ooo`030000003oool0
oooo0?<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0
oooo00L0oooo00090?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool00`3ooom]0000
00D0oooo0`0000080?ooo`002@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo07@0
oooo00@000000?ooo`3oool00000203oool000T0oooo00<000000?ooo`3oool0l`3oool00`000000
oooo0?ooo`1d0?ooo`040000003oool0oooo000000P0oooo00090?ooo`030000003oool0oooo0?<0
oooo00<000000?ooo`3oool0M@3oool3000000P0oooo00090?ooo`030000003oool0oooo0?<0oooo
00<000000?ooo`3oool0P03oool000T0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?oo
o`200?ooo`002@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0800oooo00090?oo
o`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0P03oool000T0oooo00<000000?ooo`3o
ool0l`3oool00`000000oooo0?ooo`200?ooo`002@3oool00`000000oooo0?ooo`3c0?ooo`030000
003oool0oooo0800oooo00090?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0P03o
ool000T0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`200?ooo`002@3oool00`00
0000oooo0?ooo`3c0?ooo`030000003oool0oooo0800oooo00090?ooo`030000003oool0oooo0?<0
oooo00<000000?ooo`3oool0P03oool000T0oooo00<000000?ooo`3oool0l`3oool00`000000oooo
0?ooo`200?ooo`002@3oool00`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0800oooo0009
0?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0P03oool000T0oooo00<000000?oo
o`3oool0l`3oool00`000000oooo0?ooo`200?ooo`002@3oool00`000000oooo0?ooo`3c0?ooo`03
0000003oool0oooo0800oooo00090?ooo`030000003oool0oooo0?<0oooo00<000000?ooo`3oool0
P03oool000T0oooo00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`200?ooo`002@3oool0
0`000000oooo0?ooo`3c0?ooo`030000003oool0oooo0800oooo00090?ooo`030000003oool0oooo
0?<0oooo00<000000?ooo`3oool0M03oool500000080oooo0P0000030?ooo`002@3oool00`000000
oooo0?ooo`3c0?ooo`030000003oool0oooo07H0oooo00D000000?ooo`3oool0oooo000000020?oo
o`4000000@3oool10?ooo`002@3oool00`000000oooo0?ooo`3c0?ooog<000001P3oool01@000000
oooo0?ooo`3oool000000080oooo0@0000010?ooo`40oooo00090?ooo`030000003oool0oooo0?l0
ooooK@3oool01@000000oooo0?ooo`3oool000000080oooo0@0000010?ooo`40oooo00090?ooo`03
0000003oool0oooo0?l0ooooK@3oool01@000000oooo0?ooo`3oool000000080oooo0@0000010?oo
o`40oooo00090?ooo`030000003oool0oooo0?l0ooooK03oool2000000@0oooo0P0000030?ooo`00
2@3oool00`000000oooo0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0oooo0?l0ooooM`3o
ool000T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?oo
ogL0oooo00090?ooo`030000003oool0oooo0?l0ooooM`3oool000T0oooo00<000000?ooo`3oool0
o`3ooomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0
oooo0?l0ooooM`3oool000T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000
oooo0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0oooo0?l0ooooM`3oool000T0oooo00<0
00000?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?ooogL0oooo00090?oo
o`030000003oool0oooo0?l0ooooM`3oool000T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`00
2@3oool00`000000oooo0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0oooo0?l0ooooM`3o
ool000T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?oo
ogL0oooo00090?ooo`030000003oool0oooo0?l0ooooK@3oool00`000000oooo0?ooo`070?ooo`00
2@3oool00`000000oooo0?ooo`3o0?ooofd0oooo00<000000?ooo`3oool01`3oool000T0ooooo`00
001Z000000H0oooo00<000000?ooo`3oool01`3oool00?l0ooooNP3oool00`000000oooo0?ooo`06
0?ooo`00o`3ooomg0?ooo`040000003oool0oooo000000P0oooo003o0?ooogL0oooo100000080?oo
o`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {-2.62119, 0.698913, \
0.00710352, 0.0404512}}]
}, Open  ]],

Cell["This generates a dendrogram using a list of labels.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[data2, 
        LeafLabels \[Rule] {"\<a\>", "\<b\>", "\<c\>", "\<d\>", "\<e\>", "\<f\
\>", "\<g\>", "\<h\>", "\<i\>", "\<j\>"}, 
        Orientation \[Rule] Left];\)\)], "Input",
  CellLabel->"In[43]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.372425 -0.0506853 0.0654004 [
[.97619 .01472 4 -6.28125 ]
[.97619 .01472 14 6.28125 ]
[.97619 .08012 4 -6.28125 ]
[.97619 .08012 14 6.28125 ]
[.97619 .14552 4 -6.28125 ]
[.97619 .14552 14 6.28125 ]
[.97619 .21092 4 -6.28125 ]
[.97619 .21092 14 6.28125 ]
[.97619 .27632 4 -6.28125 ]
[.97619 .27632 14 6.28125 ]
[.97619 .34172 4 -6.28125 ]
[.97619 .34172 14 6.28125 ]
[.97619 .40712 4 -6.28125 ]
[.97619 .40712 14 6.28125 ]
[.97619 .47252 4 -6.28125 ]
[.97619 .47252 14 6.28125 ]
[.97619 .53792 4 -6.28125 ]
[.97619 .53792 14 6.28125 ]
[.97619 .60332 4 -6.28125 ]
[.97619 .60332 14 6.28125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.97619 .14552 m
.97429 .14552 L
.97429 .21092 L
.97619 .21092 L
s
.97619 .08012 m
.86949 .08012 L
.86949 .17822 L
.97429 .17822 L
s
.97619 .01472 m
.64362 .01472 L
.64362 .12917 L
.86949 .12917 L
s
.97619 .34172 m
.82188 .34172 L
.82188 .40712 L
.97619 .40712 L
s
.97619 .27632 m
.80606 .27632 L
.80606 .37442 L
.82188 .37442 L
s
.80606 .32537 m
.69244 .32537 L
.69244 .47252 L
.97619 .47252 L
s
.69244 .39894 m
.67522 .39894 L
.67522 .53792 L
.97619 .53792 L
s
.64362 .07194 m
.20148 .07194 L
.20148 .46843 L
.67522 .46843 L
s
.20148 .27019 m
.02381 .27019 L
.02381 .60332 L
.97619 .60332 L
s
gsave
.97619 .01472 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .08012 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .14552 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .21092 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .27632 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .34172 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .40712 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .47252 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(i) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .53792 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(j) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .60332 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[43]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooomk
0?ooo`D000000`3oool00?l0ooooN`3oool4000000@0oooo003d0?oooh0000002@3oool00`000000
oooo0?ooo`020?ooo`00m03oool00`000000oooo0?ooo`240?ooo`<00000103oool00?@0oooo00<0
00000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?oo
o`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0
R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool0
0?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo
00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<00000
0?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3o
ool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3o
ool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool00?@0
oooo00<000000?ooo`3oool0R`3oool00?@0oooo00<000000?ooo`3oool0R`3oool004`0ooooZ@00
002=0?ooo`00C03oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo08@0oooo10000003
0?ooo`00C03oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo08<0oooo00@000000?oo
o`3oool00000103oool004`0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C0?oo
obX000001P3oool010000000oooo0?ooo`0000040?ooo`00C03oool00`000000oooo0?ooo`2U0?oo
o`030000003oool0oooo05<0oooo00<000000?ooo`3oool0;P3oool3000000@0oooo001<0?ooo`03
0000003oool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0`0?ooo`03
0000003oool0oooo0080oooo001<0?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3oool0
D`3oool00`000000oooo0?ooo`0_0?ooo`800000103oool004`0oooo00<000000?ooo`3oool0Y@3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo03D0oooo001<0?ooo`030000003oool0
oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0e0?ooo`00C03oool00`00
0000oooo0?ooo`2U0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0=@3oool004`0
oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo03D0
oooo001<0?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`000000oooo
0?ooo`0e0?ooo`00C03oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo05<0oooo00<0
00000?ooo`3oool0=@3oool004`0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C
0?ooo`030000003oool0oooo03D0oooo001<0?ooo`030000003oool0oooo0:D0oooo00<000000?oo
o`3oool0D`3oool00`000000oooo0?ooo`0e0?ooo`00C03oool00`000000oooo0?ooo`2U0?ooo`03
0000003oool0oooo05<0oooo00<000000?ooo`3oool0=@3oool004`0oooo00<000000?ooo`3oool0
Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo03D0oooo001<0?ooo`030000003o
ool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0e0?ooo`00C03oool0
0`000000oooo0?ooo`2U0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0=@3oool0
04`0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo
03D0oooo001<0?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3oool0D`3oool00`000000
oooo0?ooo`0e0?ooo`00C03oool00`000000oooo0?ooo`2U0?oooeL00000=`3oool004`0oooo00<0
00000?ooo`3oool0n`3oool00`000000oooo0?ooo`0e0?ooo`00C03oool00`000000oooo0?ooo`3k
0?ooo`030000003oool0oooo03D0oooo001<0?ooo`030000003oool0oooo0?/0oooo00<000000?oo
o`3oool0=@3oool004`0oooo00<000000?ooo`3oool0n`3oool00`000000oooo0?ooo`0e0?ooo`00
C03oool00`000000oooo0?ooo`3k0?ooo`030000003oool0oooo02`0oooo0`0000000`3oool00000
000000030?ooo`00C03oool00`000000oooo0?ooo`3k0?ooo`030000003oool0oooo02d0oooo00@0
00000?ooo`3oool00000103oool004`0oooo00<000000?ooo`3oool0n`3oool00`000000oooo0?oo
o`0U0?ooo`8000001P3oool010000000oooo0?ooo`0000040?ooo`00C03oool00`000000oooo0?oo
o`3k0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool01@3oool3000000D0oooo001<
0?ooo`030000003oool0oooo0?/0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo001<0?ooo`030000003oool0oooo0?/0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`040?ooo`8000001`3oool004`0oooo00<000000?ooo`3o
ool0n`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00d0oooo001<0?ooo`030000
003oool0oooo0?/0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0=0?ooo`00C03o
ool00`000000oooo0?ooo`3k0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool03@3o
ool004`0oooo00<000000?ooo`3oool0n`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo00d0oooo001<0?ooo`030000003oool0oooo0?/0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`0=0?ooo`00C03oool00`000000oooo0?ooo`3k0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool03@3oool004`0oooo00<000000?ooo`3oool0n`3oool00`000000oooo
0?ooo`0U0?ooo`030000003oool0oooo00d0oooo001<0?ooo`030000003oool0oooo0?/0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0=0?ooo`00C03oool00`000000oooo0?ooo`3k
0?ooobT000003`3oool004`0oooo00<000000?ooo`3oool0o`3ooolT0?ooo`030000003oool0oooo
00d0oooo001<0?ooo`030000003oool0oooo0?l0oooo903oool00`000000oooo0?ooo`0=0?ooo`00
C03oool00`000000oooo0?ooo`3o0?ooob@0oooo00<000000?ooo`3oool03@3oool004`0oooo00<0
00000?ooo`3oool0o`3ooolT0?ooo`030000003oool0oooo00d0oooo001<0?ooo`030000003oool0
oooo0?l0oooo903oool00`000000oooo0?ooo`0=0?ooo`00C03oool00`000000oooo0?ooo`3o0?oo
ob@0oooo00<000000?ooo`3oool03@3oool004`0oooo00<000000?ooo`3oool0o`3ooolT0?ooo`03
0000003oool0oooo00d0oooo001<0?ooo`030000003oool0oooo0?l0oooo903oool00`000000oooo
0?ooo`0=0?ooo`00C03oool00`000000oooo0?ooo`3o0?ooob@0oooo00<000000?ooo`3oool03@3o
ool004`0oooo00<000000?ooo`3oool0o`3ooolT0?ooo`030000003oool0oooo00d0oooo001<0?oo
o`030000003oool0oooo0?l0oooo903oool00`000000oooo0?ooo`050?ooo`@00000103oool004`0
oooo00<000000?ooo`3oool0o`3ooolT0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0103oool004`0oooo00<000000?ooo`3oool0o`3ooolT0?ooo`8000001`3oool00`000000oooo
0?ooo`040?ooo`00C03oool00`000000oooo0?ooo`3o0?ooob`0oooo100000040?ooo`00C03oool0
0`000000oooo0?ooo`3o0?ooobd0oooo00<000000?ooo`3oool0103oool004`0oooo00<000000?oo
o`3oool0o`3oool^0?ooo`800000103oool004`0oooo00<000000?ooo`3oool0o`3ooold0?ooo`00
C03oool00`000000oooo0?ooo`3o0?oooc@0oooo001<0?ooo`030000003oool0oooo0?l0oooo=03o
ool004`0oooo00<000000?ooo`3oool0o`3ooold0?ooo`00C03oool00`000000oooo0?ooo`3o0?oo
oc@0oooo001<0?ooo`030000003oool0oooo0?l0oooo=03oool004`0oooo00<000000?ooo`3oool0
o`3ooold0?ooo`00C03oool00`000000oooo0?ooo`3o0?oooc@0oooo001<0?ooo`030000003oool0
oooo0?l0oooo=03oool004`0oooo00<000000?ooo`3oool0o`3ooold0?ooo`00C03oool00`000000
oooo0?ooo`3o0?oooc@0oooo001<0?ooo`030000003oool0oooo0?l0oooo=03oool004`0oooo00<0
00000?ooo`3oool0o`3ooold0?ooo`00C03oool00`000000oooo0?ooo`3o0?oooc@0oooo001<0?oo
o`030000003oool0oooo0?l0oooo=03oool004`0oooo00<000000?ooo`3oool0o`3ooold0?ooo`00
C03oool00`000000oooo0?ooo`3o0?oooc@0oooo001<0?ooo`030000003oool0oooo0?l0oooo=03o
ool000T0ooooA000003o0?ooocH0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0o`3oool]0?ooo`<00000103oool000T0oooo00<000000?ooo`3oool0@03oool00`000000
oooo0?ooo`3S0?oood8000001P3oool00`000000oooo0?ooo`050?ooo`002@3oool00`000000oooo
0?ooo`100?ooo`030000003oool0oooo0><0oooo00<000000?ooo`3oool0A@3oool4000000@0oooo
00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0h`3oool00`000000oooo0?oo
o`160?ooo`8000001@3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`3S
0?ooo`030000003oool0oooo04d0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0h`3oool00`000000oooo0?ooo`1=0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo0><0oooo00<000000?ooo`3oool0C@3oool000T0oooo00<000000?ooo`3oool0
@03oool00`000000oooo0?ooo`3S0?ooo`030000003oool0oooo04d0oooo00090?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0h`3oool00`000000oooo0?ooo`1=0?ooo`002@3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0><0oooo00<000000?ooo`3oool0C@3oool0
00T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`3S0?ooo`030000003oool0oooo
04d0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0h`3oool00`000000
oooo0?ooo`1=0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0><0oooo
00<000000?ooo`3oool0C@3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`3S0?ooo`030000003oool0oooo04d0oooo00090?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0h`3oool00`000000oooo0?ooo`1=0?ooo`002@3oool00`000000oooo0?ooo`100?oo
o`030000003oool0oooo0><0oooo00<000000?ooo`3oool0C@3oool000T0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`3S0?ooo`030000003oool0oooo04d0oooo00090?ooo`030000
003oool0oooo0400oooo00<000000?ooo`3oool0h`3oool00`000000oooo0?ooo`1=0?ooo`002@3o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0><0oooo00<000000?ooo`3oool0C@3o
ool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`3S0?ooo`030000003oool0
oooo04d0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool/0000
04l0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo04d0oooo00090?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo04d0oooo
00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo04d0oooo00090?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0^03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo04d0oooo00090?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0X0?oo
o`030000003oool0oooo04@0oooo100000050?ooo`002@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo0;P0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`030?oooc`0
00001P3oool010000000oooo0?ooo`0000040?ooo`002@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo0;P0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo03l0oooo00@000000?ooo`3oool00000103oool000T0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0o0?ooo`<000001@3oool000T0oooo00<000000?ooo`3oool0
@03oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00D0oooo00090?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0?P3oool2000000L0oooo00090?ooo`030000003oool0
oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0A`3oool000T0oooo00<000000?ooo`3oool0@03oool00`00
0000oooo0?ooo`2h0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`170?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;P0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04L0
oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0A`3oool000T0oooo00<0
00000?ooo`3oool0@03oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`170?ooo`002@3oool00`000000oooo0?ooo`10
0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo04L0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0^03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0A`3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2h0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`170?ooo`00
2@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool0
:03oool7000004T0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03o
ool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04L0oooo00090?ooo`030000003oool0
oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo04L0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo04L0oooo00090?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04L0
oooo00090?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo
0?ooo`0^0?ooo`030000003oool0oooo04L0oooo00090?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool0^03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04L0oooo0009
0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo04L0oooo00090?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0^03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04L0oooo00090?ooo`03
0000003oool0oooo0400oooo00<000000?ooo`3oool0/@3oool800000300oooo00<000000?ooo`3o
ool0A`3oool000T0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`2a0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`170?ooo`002@3o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0400oooo0`0000040?ooo`002@3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0^0?oooc`000001P3oool00`000000oooo0?ooo`050?ooo`002@3oool00`00
0000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`1`0?ooo`030000003oool0oooo00D0oooo00090?ooo`030000003oool0oooo0400
oooo00<000000?ooo`3oool0/@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0740
oooo0`0000040?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?oo
o`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?oo
o`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?oo
o`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000
003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0
oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`00
0000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo
0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`10
0?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h
0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`00
2@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003o
ool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo
0;40oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1h0?ooo`002@3oool00`000000
oooo0?ooo`100?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`1h0?ooo`002@3oool00`000000oooo0?ooo`100?oookD000001P3oool00`000000oooo
0?ooo`1a0?ooo`<00000103oool000T0oooo00<000000?ooo`3oool0m03oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool00`3oool000T0oooo00<00000
0?ooo`3oool0m03oool00`000000oooo0?ooo`040?ooofd00000203oool00`000000oooo0?ooo`03
0?ooo`002@3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo07P0oooo0P0000050?oo
o`002@3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo07l0oooo00090?ooo`030000
003oool0oooo0?@0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`030?ooo`002@3o
ool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo07l0oooo00090?ooo`030000003oool0
oooo0?@0oooo00<000000?ooo`3oool0O`3oool000T0oooo00<000000?ooo`3oool0m03oool00`00
0000oooo0?ooo`1o0?ooo`002@3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo07l0
oooo00090?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool0O`3oool000T0oooo00<0
00000?ooo`3oool0m03oool00`000000oooo0?ooo`1o0?ooo`002@3oool00`000000oooo0?ooo`3d
0?ooo`030000003oool0oooo07l0oooo00090?ooo`030000003oool0oooo0?@0oooo00<000000?oo
o`3oool0O`3oool000T0oooo00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`1o0?ooo`00
2@3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo07l0oooo00090?ooo`030000003o
ool0oooo0?@0oooo00<000000?ooo`3oool0O`3oool000T0oooo00<000000?ooo`3oool0m03oool0
0`000000oooo0?ooo`1o0?ooo`002@3oool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo
07l0oooo00090?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool0O`3oool000T0oooo
00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`1o0?ooo`002@3oool00`000000oooo0?oo
o`3d0?ooo`030000003oool0oooo07l0oooo00090?ooo`030000003oool0oooo0?@0oooo00<00000
0?ooo`3oool0O`3oool000T0oooo00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`1g0?oo
o`@00000103oool000T0oooo00<000000?ooo`3oool0m03oool00`000000oooo0?ooo`1j0?ooo`03
0000003oool0oooo0080oooo00090?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool0
NP3oool00`000000oooo0?ooo`020?ooo`002@3oool00`000000oooo0?ooo`3d0?ooo`030000003o
ool0oooo07X0oooo00<000000?ooo`3oool00P3oool000T0oooo00<000000?ooo`3oool0m03ooomd
000000T0oooo00<000000?ooo`3oool00P3oool000T0oooo00<000000?ooo`3oool0o`3ooom_0?oo
o`@00000103oool000T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000oooo
0?ooo`3o0?ooog40oooo00<000000?ooo`3oool00`3oool000T0oooo00<000000?ooo`3oool0o`3o
oomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0oooo
0?l0ooooM`3oool000T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000oooo
0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0oooo0?l0ooooM`3oool000T0oooo00<00000
0?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?ooogL0oooo00090?ooo`03
0000003oool0oooo0?l0ooooM`3oool000T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`002@3o
ool00`000000oooo0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0oooo0?l0ooooM`3oool0
00T0oooo00<000000?ooo`3oool0o`3ooomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?ooogL0
oooo00090?ooo`030000003oool0oooo0?l0ooooM`3oool000T0oooo00<000000?ooo`3oool0o`3o
oomg0?ooo`002@3oool00`000000oooo0?ooo`3o0?ooogL0oooo00090?ooo`030000003oool0oooo
0?l0ooooK`3oool3000000D0oooo00090?ooo`030000003oool0oooo0?l0ooooLP3oool00`000000
oooo0?ooo`020?ooo`002@3oool00`000000oooo0?ooo`3o0?ooog00oooo0`0000040?ooo`002@3o
ool00`000000oooo0?ooo`3o0?ooofl0oooo00@000000?ooo`3oool00000103oool000T0ooooo`00
001/000000H0oooo00@000000?ooo`3oool00000103oool00?l0ooooO03oool4000000<0oooo003o
0?oooh<0oooo003o0?oooh<0oooo003o0?oooh<0oooo003o0?oooh<0oooo003o0?oooh<0oooo0000
\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {-2.62119, 0.724872, \
0.00706522, 0.0402332}}]
}, Open  ]],

Cell["This generates a dendrogram using a label function.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[data2, LeafLabels \[Rule] \((# &)\), 
        Orientation \[Rule] Left];\)\)], "Input",
  CellLabel->"In[44]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.372425 -0.0506853 0.0654004 [
[.97619 .01472 4 -6.28125 ]
[.97619 .01472 126.188 6.28125 ]
[.97619 .08012 4 -6.28125 ]
[.97619 .08012 132.188 6.28125 ]
[.97619 .14552 4 -6.28125 ]
[.97619 .14552 138.813 6.28125 ]
[.97619 .21092 4 -6.28125 ]
[.97619 .21092 126.813 6.28125 ]
[.97619 .27632 4 -6.28125 ]
[.97619 .27632 132.188 6.28125 ]
[.97619 .34172 4 -6.28125 ]
[.97619 .34172 119.563 6.28125 ]
[.97619 .40712 4 -6.28125 ]
[.97619 .40712 119.563 6.28125 ]
[.97619 .47252 4 -6.28125 ]
[.97619 .47252 119.563 6.28125 ]
[.97619 .53792 4 -6.28125 ]
[.97619 .53792 126.188 6.28125 ]
[.97619 .60332 4 -6.28125 ]
[.97619 .60332 101.563 6.28125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.97619 .14552 m
.97429 .14552 L
.97429 .21092 L
.97619 .21092 L
s
.97619 .08012 m
.86949 .08012 L
.86949 .17822 L
.97429 .17822 L
s
.97619 .01472 m
.64362 .01472 L
.64362 .12917 L
.86949 .12917 L
s
.97619 .34172 m
.82188 .34172 L
.82188 .40712 L
.97619 .40712 L
s
.97619 .27632 m
.80606 .27632 L
.80606 .37442 L
.82188 .37442 L
s
.80606 .32537 m
.69244 .32537 L
.69244 .47252 L
.97619 .47252 L
s
.69244 .39894 m
.67522 .39894 L
.67522 .53792 L
.97619 .53792 L
s
.64362 .07194 m
.20148 .07194 L
.20148 .46843 L
.67522 .46843 L
s
.20148 .27019 m
.02381 .27019 L
.02381 .60332 L
.97619 .60332 L
s
gsave
.97619 .01472 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.725306) show
117.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
126.563 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
133.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.13025) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
175.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .08012 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.216913) show
117.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
126.563 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
133.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.333681) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
181.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .14552 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.315244) show
123.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
133.188 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
139.813 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.276055) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
187.813 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .21092 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3807) show
111.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
121.188 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
127.813 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.247508) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
175.813 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .27632 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.0267556) show
129.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
139.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15067) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
181.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .34172 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.581015) show
117.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
126.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.44637) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
168.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .40712 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.846069) show
117.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
126.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.03296) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
168.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .47252 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.16163) show
111.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
120.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.794608) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
168.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .53792 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
75.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.251712) show
123.625 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
133.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.02102) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
175.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
gsave
.97619 .60332 -57 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.44239) show
111.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
120.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.938) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
150.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[44]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3oool10?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool04P3oool00?l0
oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0140
oooo003o0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`8000001@3oool010000000oooo
0?ooo`3oool4000000<0oooo0P0000040?ooo`800000103oool2000000<0oooo0`0000040?ooo`03
0000003oool0oooo00`0oooo1@0000020?ooo`8000000`3oool500000080oooo0P0000040?ooo`80
00000`3oool4000000<0oooo0P0000040?ooo`030000003oool0oooo0140oooo003o0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?oo
o`0000001@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00@0
oooo100000050?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo000000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo0140oooo002R0?oooeD000001`3oool00`000000oooo0?oo
o`020?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000001`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo002R
0?ooo`030000003oool0oooo05X0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`8000001P3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<000005@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003oool0oooo0140
oooo002R0?ooo`030000003oool0oooo05X0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00H0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02@3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000002
0?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`0A0?ooo`00XP3oool0
0`000000oooo0?ooo`1K0?ooo`040000003oool0oooo0?ooo`8000002@3oool4000000<0oooo0P00
00040?ooo`<000000`3oool2000000@0oooo0P0000040?ooo`<000004`3oool2000000X0oooo0P00
00040?ooo`800000103oool2000000@0oooo0P0000040?ooo`<000000P3oool00`000000oooo0?oo
o`0B0?ooo`00XP3oool00`000000oooo0?ooo`3M0?ooo`00XP3oool00`000000oooo0?ooo`3M0?oo
o`00XP3oool00`000000oooo0?ooo`3M0?ooo`00XP3oool00`000000oooo0?ooo`3M0?ooo`00XP3o
ool00`000000oooo0?ooo`3M0?ooo`00XP3oool00`000000oooo0?ooo`3M0?ooo`00XP3oool00`00
0000oooo0?ooo`3M0?ooo`00XP3oool00`000000oooo0?ooo`3M0?ooo`00XP3oool00`000000oooo
0?ooo`3M0?ooo`00XP3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo0700oooo00<0
00000?ooo`3oool0303oool00380ooooL@00001L0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool0?@3oool00`000000oooo0?ooo`0;0?ooo`00<P3oool00`000000oooo0?ooo`1]0?oo
o`030000003oool0oooo05X0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000030?oo
o`@000000P3oool5000000040?ooo`0000000000000000<0oooo0`0000030?ooo`D000000P3oool2
000000@0oooo00<000000?ooo`3oool03@3oool2000000@0oooo0P0000040?ooo`800000103oool2
000000@0oooo0P0000030?ooo`<00000103oool2000000<0oooo1@0000020?ooo`030000003oool0
oooo00/0oooo000b0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0=P3ooolL0000
00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00@0oooo100000030?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00380oooo00<000000?ooo`3oool0
K@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
0P3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0oooo0?ooo`<00000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0140oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00X0oooo000b0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool0oooo0`0000030?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0@
0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<00000103oool2000000D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0;0?ooo`00<P3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool08@3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool01P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`0@0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool02`3oool00380oooo00<000000?ooo`3oool0K@3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo0280oooo00@000000?ooo`3oool0oooo0P00000:0?oo
o`800000103oool2000000@0oooo0`0000030?ooo`<000000`3oool2000000@0oooo0P00000D0?oo
o`8000002P3oool2000000@0oooo0P0000040?ooo`800000103oool3000000<0oooo0P0000040?oo
o`8000000`3oool00`000000oooo0?ooo`0<0?ooo`00<P3oool00`000000oooo0?ooo`1]0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool0Y03oool00380oooo00<000000?ooo`3oool0
K@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo0:@0oooo000b0?ooo`030000003o
ool0oooo06d0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`2T0?ooo`00<P3oool0
0`000000oooo0?ooo`1]0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0Y03oool0
0380oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
0:@0oooo000b0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`2T0?ooo`00<P3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo03H0oooo
00<000000?ooo`3oool0Y03oool00380oooo00<000000?ooo`3oool0K@3ooolj00000:H0oooo000b
0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`1g
0?ooo`030000003oool0oooo00D0oooo000b0?ooo`030000003oool0oooo0:H0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo03h0oooo00<000000?oo
o`3oool0103oool00380oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`0Q0?ooo`03
0000003oool0oooo00P0oooo0P0000040?ooo`800000103oool2000000<0oooo1@0000020?ooo`80
00000`3oool4000000@0oooo0`0000030?ooo`<000000P3oool00`000000oooo0?ooo`0>0?ooo`80
0000103oool2000000<0oooo100000040?ooo`040000003oool0oooo0?ooo`<00000103oool20000
00@0oooo0P0000040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`00<P3oool00`000000
oooo0?ooo`2V0?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oool0oooo100000020?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool4000000<0oooo00@000000?ooo`3o
ool00000203oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00000P3oool01@000000oooo0?ooo`3oool0000000H0oooo000b0?ooo`030000003oool0oooo0:H0
oooo00<000000?ooo`3oool05`3oool2000000L0oooo00<000000?ooo`3oool0203oool010000000
oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool0000000@0oooo1@0000000`3oool000000000000300000180oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000
0P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo000b0?ooo`030000
003oool0oooo0:H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00L0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000000P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo0140oooo00@000000?ooo`3oool000002P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<000000`3oool010000000oooo0?oo
o`0000030?ooo`800000103oool2000000@0oooo00<000000?ooo`3oool0103oool00380oooo00<0
00000?ooo`3oool0YP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000000C0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00380oooo00<000000?ooo`3oool0
YP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1`3oool2000000X0oooo0P0000040?ooo`800000103oool3000000<0oooo0P0000050?ooo`800000
103oool2000001@0oooo0P00000:0?ooo`8000000`3oool4000000<0oooo0`0000030?ooo`800000
103oool3000000<0oooo0`0000020?ooo`030000003oool0oooo00D0oooo000b0?ooo`030000003o
ool0oooo0:H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`2:0?ooo`00<P3oool0
0`000000oooo0?ooo`2V0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0RP3oool0
0380oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
08X0oooo000b0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`2:0?ooo`00<P3oool00`000000oooo0?ooo`2V0?oooa/00000S03oool00380oooo00<0
00000?ooo`3oool0`03oool00`000000oooo0?ooo`2:0?ooo`00<P3oool00`000000oooo0?ooo`30
0?ooo`030000003oool0oooo08X0oooo000b0?ooo`030000003oool0oooo0<00oooo00<000000?oo
o`3oool0RP3oool00380oooo00<000000?ooo`3oool0`03oool00`000000oooo0?ooo`2:0?ooo`00
<P3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
J`3oool00`000000oooo0?ooo`0A0?ooo`00<P3oool00`000000oooo0?ooo`300?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo0100oooo000b0?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`800000103oool2000000@0oooo0P0000040?ooo`800000103oool2
000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`800000103oool2
000000<0oooo100000040?ooo`<000000`3oool00`000000oooo0?ooo`020?ooo`800000103oool2
000000@0oooo0P0000040?ooo`030000003oool0oooo0100oooo000b0?ooo`030000003oool0oooo
0<00oooo0P0000080?ooo`040000003oool0oooo0?ooo`@000000P3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool40000
00<0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool000000180oooo000b0?ooo`03
0000003oool0oooo0<T0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00000:0?oo
o`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool04P3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0oooo0080oooo1@0000030?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool03`3oool00380oooo00<000000?ooo`3oool0bP3oool00`000000oooo0?ooo`070?ooo`04
0000003oool0oooo000000/0oooo00@000000?ooo`3oool0oooo0P0000030?ooo`040000003oool0
oooo000000D0oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`00000:0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?oo
o`8000000`3oool010000000oooo0?ooo`0000030?ooo`800000103oool00`000000oooo0?ooo`0@
0?ooo`00<P3oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo00L0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000C0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000020?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`3oool0403oool00380oooo00<000000?ooo`3o
ool0b`3oool00`000000oooo0?ooo`070?ooo`8000002P3oool2000000@0oooo0P0000040?ooo`80
00000`3oool4000001@0oooo0P00000:0?ooo`8000001@3oool200000080oooo100000030?ooo`<0
00000`3oool2000000@0oooo0P0000030?ooo`030000003oool0oooo0140oooo000b0?ooo`030000
003oool0oooo0?l0ooooCP3oool00380oooo00<000000?ooo`3oool0o`3ooom>0?ooo`00<P3oool0
0`000000oooo0?ooo`3o0?ooodh0oooo000b0?ooo`030000003oool0oooo0?l0ooooCP3oool00380
oooo00<000000?ooo`3oool0o`3ooom>0?ooo`00<P3oool00`000000oooo0?ooo`3o0?ooodh0oooo
000b0?ooo`030000003oool0oooo0?l0ooooCP3oool00380oooo00<000000?ooo`3oool0o`3ooom>
0?ooo`00<P3oool00`000000oooo0?ooo`3;0?ooo`030000003oool0oooo0700oooo00<000000?oo
o`3oool0303oool00380oooo00<000000?ooo`3oool0bP3oool00`000000oooo0?ooo`0n0?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool02`3oool000H0oooo;@00003<0?ooo`030000
003oool0oooo00P0oooo0P0000040?ooo`800000103oool2000000<0oooo100000020?ooo`<00000
1@3oool00`000000oooo0?ooo`020?ooo`800000103oool2000000<0oooo0`0000040?ooo`030000
003oool0oooo00H0oooo1@0000020?ooo`8000000`3oool500000080oooo0P0000040?ooo`800000
0`3oool3000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`001P3o
ool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0<X0oooo00@000000?ooo`3oool0oooo
100000020?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool01@000000
oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0;0?ooo`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo09H0oooo;0000007
0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00060?ooo`030000003oool0
oooo02T0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0
oooo00L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`040000
003oool0oooo0?ooo`<000001P3oool010000000oooo0?ooo`3oool2000000@0oooo0P0000030?oo
o`<000003`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo0P0000030?oo
o`040000003oool0oooo00000080oooo0`0000060?ooo`050000003oool0oooo0?ooo`0000003@3o
ool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`2F0?ooo`030000003oool0
oooo0340oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool02`3oool000H0oooo00<00000
0?ooo`3oool0:@3oool00`000000oooo0?ooo`2F0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool01`3oool2000000X0oooo0P0000040?ooo`800000103oool300000080oooo10000003
0?ooo`<000000`3oool3000000<0oooo0`00000=0?ooo`8000002P3oool2000000@0oooo0`000003
0?ooo`800000103oool300000080oooo100000020?ooo`030000003oool0oooo00`0oooo00060?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`2d0?oo
o`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3o
ool0]03oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`2F0?ooo`030000
003oool0oooo0;@0oooo00060?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0UP3o
ool00`000000oooo0?ooo`2d0?ooo`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0
oooo09H0oooo00<000000?ooo`3oool0]03oool000H0oooo00<000000?ooo`3oool0:@3oool00`00
0000oooo0?ooo`2F0?ooo`030000003oool0oooo0;@0oooo00060?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`2d0?ooo`001P3oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool0]03oool000H0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`1i0?oooah00000]P3oool000H0oooo00<00000
0?ooo`3oool0:@3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool0<P3oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo01T0oooo00060?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0J0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo01P0oooo00060?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3o
ool0N@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3o
ool00P3oool2000000@0oooo0P0000040?ooo`800000103oool2000000<0oooo1@0000020?ooo`80
00000`3oool500000080oooo0P0000040?ooo`030000003oool0oooo00D0oooo1@0000020?ooo`80
00001@3oool3000000<0oooo0`000000103oool000000000000000040?ooo`8000001@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo01P0oooo00060?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0J0?ooo`040000003oool0oooo0?oo
obP00000203oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0H0?ooo`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo07T0oooo00<00000
0?ooo`3oool06P3oool01@000000oooo0?ooo`3oool0000002h0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`00000;0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool50000
00030?ooo`000000000000<0000000D0oooo0000003oool0oooo000000040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0G0?ooo`001P3oool00`00
0000oooo0?ooo`0Y0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool06P3oool01@00
0000oooo0?ooo`3oool0000002l0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo00L0oooo0P0000040?ooo`8000001@3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`8000003P3oool00`000000oooo
0?ooo`070?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool30000
00H0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000001X0oooo00060?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0J0?oo
o`050000003oool0oooo0?ooo`000000;`3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`00
00000`3oool00`000000oooo000000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo01P0oooo00060?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0J0?oo
o`050000003oool0oooo0?ooo`000000<03oool010000000oooo0?ooo`3oool2000000X0oooo0`00
00030?ooo`800000103oool2000000@0oooo0P0000040?ooo`800000103oool3000000`0oooo0P00
000;0?ooo`800000103oool2000000<0oooo0`0000030?ooo`8000000`3oool400000080oooo00<0
00000?ooo`3oool06@3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1i
0?ooo`030000003oool0oooo01X0oooo00D000000?ooo`3oool0oooo0000002b0?ooo`001P3oool0
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool06P3oool0
1@000000oooo0?ooo`3oool000000;80oooo00060?ooo`030000003oool0oooo02T0oooo00<00000
0?ooo`3oool0N@3oool00`000000oooo0?ooo`0J0?ooo`050000003oool0oooo0?ooo`000000/P3o
ool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0
oooo01X0oooo1@00002b0?ooo`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo
07T0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2`0?ooo`001P3oool00`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool07P3oool00`000000
oooo0?ooo`2`0?ooo`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo07T0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2`0?ooo`001P3oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`2`0?ooo`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo07T0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo06<0oooo00<00000
0?ooo`3oool06@3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e0?oo
o`D00000803oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool0<03oool00`000000oooo0?ooo`0H0?ooo`001P3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo07D0oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000040?ooo`8000001@3oool30000
00040?ooo`0000000000000000@0oooo0P0000030?ooo`<000000`3oool3000000@0oooo00<00000
0?ooo`3oool01@3oool4000000<0oooo0P0000040?ooo`800000103oool2000000<0oooo10000002
0?ooo`<000000`3oool3000000@0oooo00<000000?ooo`3oool0603oool000H0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`050000003oool0oooo0?ooo`000000803oool0
0`000000oooo0?ooo`0]0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo000000D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
1@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000J0?oo
o`001P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo07D0oooo00D000000?ooo`3o
ool0oooo0000000P0?ooobP000001`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000000P3oool5000000050?ooo`000000oooo0?ooo`000000
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo0`00000<0?oo
o`030000003oool0oooo00P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00<0oooo0`0000020?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool05`3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e
0?ooo`050000003oool0oooo0?ooo`000000D03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool01`3oool2000000<0oooo00@000000?ooo`3oool000000P3oool3000000<0
oooo00@000000?ooo`3oool000000P3oool3000000<0oooo00@000000?ooo`3oool000003@3oool0
0`000000oooo0?ooo`070?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`0000040?ooo`030000
003oool0oooo01P0oooo00060?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0M@3o
ool01@000000oooo0?ooo`3oool000000500oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00H0oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000030?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000/0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0603o
ool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`050000003oool0
oooo0?ooo`000000D@3oool010000000oooo0?ooo`3oool2000000X0oooo0P0000050?ooo`800000
0`3oool3000000<0oooo0P0000040?ooo`<000000`3oool3000000`0oooo0P00000:0?ooo`800000
103oool2000000@0oooo0P0000040?ooo`<000000`3oool300000080oooo00<000000?ooo`3oool0
6@3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`050000003o
ool0oooo0?ooo`000000d`3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`1e0?ooo`050000003oool0oooo0?ooo`000000d`3oool000H0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`1e0?ooo`050000003oool0oooo0?ooo`000000d`3oool000H0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`050000003oool0oooo0?ooo`000000
d`3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`050000003o
ool0oooo0?ooo`000000d`3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`1e0?ooo`050000003oool0oooo0?ooo`000000d`3oool000H0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`1e0?ooo`050000003oool0oooo0?ooo`000000d`3oool000H0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`050000003oool0oooo0?ooo`000000
d`3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`050000003o
ool0oooo0?ooo`000000d`3oool000H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`1e0?ooo`050000003oool0oooo0?ooo`000000D@3oool00`000000oooo0?ooo`1S0?ooo`030000
003oool0oooo01T0oooo00060?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0M@3o
ool01@000000oooo0?ooo`3oool000000500oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`0f0?ooo`030000003oool0oooo01P0oooo00060?ooo`030000003oool0oooo02T0ooooN@00
00030?ooo`030000003oool0oooo04h0oooo00@000000?ooo`3oool0oooo1@0000020?ooo`800000
0`3oool5000000040?ooo`0000000000000000<0oooo1@000000103oool000000000000000040?oo
o`800000103oool00`000000oooo0?ooo`060?ooo`800000103oool2000000D0oooo00@000000?oo
o`3oool0oooo0`0000050?ooo`<0000000@0oooo0000000000000000103oool2000000@0oooo0P00
00040?ooo`030000003oool0oooo01P0oooo00060?ooo`030000003oool0oooo0:40oooo00@00000
0?ooo`3oool0ooooB@0000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02@3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00@0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo0000000J0?oo
o`001P3oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?oo
o`020?ooo`<000000P3oool5000000050?ooo`000000oooo0?ooo`0000000P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool05`3oool000H0
oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`3oool3000000D0oooo00@000000?oo
o`3oool0oooo0`0000060?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool000002`3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00`0000030?ooo`040000003oool0oooo000000<0oooo0P0000040?ooo`030000003oool0oooo
01P0oooo00060?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool0DP3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000;0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool0603oool000H0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`1C0?ooo`04
0000003oool0oooo0?ooo`8000002P3oool2000000@0oooo0`0000030?ooo`800000103oool30000
00<0oooo0P00000=0?ooo`8000002@3oool4000000<0oooo0`0000040?ooo`8000000`3oool30000
00<0oooo0P0000040?ooo`8000000`3oool00`000000oooo0?ooo`0I0?ooo`001P3oool00`000000
oooo0?ooo`2Q0?ooo`030000003oool0oooo0=D0oooo00060?ooo`030000003oool0oooo0:40oooo
00<000000?ooo`3oool0e@3oool000H0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?oo
o`3E0?ooo`001P3oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo0=D0oooo00060?oo
o`030000003oool0oooo0:40oooo00<000000?ooo`3oool0e@3oool000H0oooo00<000000?ooo`3o
ool0X@3oool00`000000oooo0?ooo`3E0?ooo`001P3oool00`000000oooo0?ooo`2Q0?ooo`030000
003oool0oooo0=D0oooo00060?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool0e@3o
ool000H0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0
oooo06X0oooo00<000000?ooo`3oool04P3oool000H0oooo00<000000?ooo`3oool0X@3oool00`00
0000oooo0?ooo`1B0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`0A0?ooo`001P3oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo0580
oooo00<000000?ooo`3oool0203oool2000000@0oooo0P0000030?ooo`@000000`3oool2000000<0
oooo1@0000030?ooo`040000003oool0oooo0?ooo`D0000000<0oooo0000000000000P0000030?oo
o`030000003oool0oooo00H0oooo100000030?ooo`800000103oool2000000<0oooo100000020?oo
o`D000000P3oool2000000<0oooo100000030?ooo`030000003oool0oooo0140oooo00060?ooo`03
0000003oool0oooo0:40oooo00<000000?ooo`3oool0DP3oool010000000oooo0?ooo`3oool40000
0080oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`030?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`050000003o
ool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?oo
o`0000000P3oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo0140oooo00060?oo
o`030000003oool0oooo0:40ooooC@0000070?ooo`030000003oool0oooo00P0oooo00@000000?oo
o`3oool000002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000060?ooo`030000003oool0oooo0100oooo00060?ooo`030000003oool0oooo0?H0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo0080
oooo0P0000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01`3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0A
0?ooo`001P3oool00`000000oooo0?ooo`3f0?ooo`030000003oool0oooo00L0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00@0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo
000000020?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo0000000C0?oo
o`001P3oool00`000000oooo0?ooo`3g0?ooo`030000003oool0oooo00L0oooo0P00000:0?ooo`80
0000103oool3000000<0oooo0P0000030?ooo`@000000`3oool2000000@0oooo0P00000>0?ooo`80
00002P3oool2000000@0oooo0P0000040?ooo`800000103oool2000000@0oooo0P0000030?ooo`03
0000003oool0oooo0180oooo00060?ooo`030000003oool0oooo0?l0ooooNP3oool000H0oooo00<0
00000?ooo`3oool0o`3ooomj0?ooo`001P3oool00`000000oooo0?ooo`3o0?ooogX0oooo00060?oo
o`030000003oool0oooo0?l0ooooNP3oool000H0oooo00<000000?ooo`3oool0o`3ooomj0?ooo`00
1P3oool00`000000oooo0?ooo`3o0?ooogX0oooo00060?ooo`030000003oool0oooo0?l0ooooNP3o
ool000H0oooo00<000000?ooo`3oool0o`3ooomj0?ooo`001P3oool00`000000oooo0?ooo`3g0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool0:`3oool000H0oooo00<000000?ooo`3o
ool0mP3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool0:P3oool000H0oooo00<000000?ooo`3oool0mP3oool010000000oooo0?ooo`3oool4000000<0
oooo0P0000050?ooo`<000000`3oool3000000030?ooo`0000000000008000000`3oool2000000<0
oooo0`0000040?ooo`030000003oool0oooo00D0oooo1@0000020?ooo`8000000`3oool3000000@0
oooo0P0000040?ooo`800000103oool00`000000oooo0?ooo`0Z0?ooo`001P3oool00`000000oooo
0?ooo`3f0?ooo`050000003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`030?ooo`04
0000003oool0oooo000000D0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3o
ool000000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool0000002`0
oooo00060?oooo4000001`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo
1@0000000`3oool000000000000300000080oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`020?ooo`<000003@3oool00`000000oooo0?ooo`080?ooo`<00000103oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0Y0?ooo`00
o`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00@00000
0?ooo`3oool000001@3oool010000000oooo0?ooo`3oool2000000@0oooo00<000000?ooo`3oool0
:P3oool00?l0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000020?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000=0?ooo`030000003oool0
oooo00L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool0:P3oool00?l0oooo0@3oool010000000oooo
0?ooo`3oool2000000/0oooo0P0000040?ooo`8000000`3oool2000000@0oooo0P0000040?ooo`<0
0000303oool2000000X0oooo0`0000030?ooo`800000103oool2000000<0oooo00<000000?ooo`3o
ool0:`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0ooooP`3oool00?l0
ooooP`3oool00?l0ooooP`3oool00001\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {-2.62119, -1.69607, \
0.0106472, 0.0606308}}]
}, Open  ]],

Cell[TextData[{
  "For large data sets, only a summary of the full dendrogram may be desired. \
Dendrograms may be truncated using the ",
  StyleBox["TruncateDendrogram", "MR"],
  " option by providing an integer or a list of two integers. If given as a \
list of two integers, the first value specifies the fusion level above which \
mergers should not be shown, while the second indicates the fusion level \
under which the dendrogram should be truncated. For a single integer ",
  StyleBox["n", "MR"],
  ", ",
  StyleBox["TruncateDendrogram\[Rule]n", "MR"],
  " is equivalent to ",
  StyleBox["TruncateDendrogram\[Rule]{1,n}", "MR"],
  ".",
  " ",
  "A value of \[Infinity] may be given as a second value to show the full \
clustering without truncation from below. When a cluster is truncated and \
labels are specified, a box is substituted for a label indicating the size of \
the cluster that has been truncated."
}], "Text"],

Cell[TextData[{
  "Here is a larger data set to cluster. It is based on a series of \
measurements of different species of irises [",
  ButtonBox["4",
    ButtonData:>"Fisher",
    ButtonStyle->"Hyperlink"],
  "]."
}], "MathCaption",
  CellTags->"FisherRef"],

Cell[BoxData[
    \(\(iris = Import["\<StatisticsExamples/Data/iris.dat\>"];\)\)], "Input",
  CellLabel->"In[45]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["This turns off tie warnings.", "MathCaption"],

Cell[BoxData[
    \(Off[Agglomerate::ties]\)], "Input",
  CellLabel->"In[46]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell["\<\
This generates a dendrogram truncated to show only the highest 20 mergers.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[iris, TruncateDendrogram \[Rule] 20, 
        LeafLabels \[Rule] Automatic];\)\)], "Input",
  CellLabel->"In[47]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0291005 0.0529101 0.0147151 0.218812 [
[.02381 .01472 -12.5 -17.4375 ]
[.02381 .01472 12.5 -4 ]
[.07672 .01472 -6 -13 ]
[.07672 .01472 6 -4 ]
[.12963 .01472 -6 -13 ]
[.12963 .01472 6 -4 ]
[.18254 .01472 -9.5 -17.3125 ]
[.18254 .01472 9.5 -4 ]
[.23545 .01472 -12.5 -17.3125 ]
[.23545 .01472 12.5 -4 ]
[.28836 .01472 -9 -13 ]
[.28836 .01472 9 -4 ]
[.34127 .01472 -6 -13 ]
[.34127 .01472 6 -4 ]
[.39418 .01472 -9 -13 ]
[.39418 .01472 9 -4 ]
[.44709 .01472 -9.5 -17.4375 ]
[.44709 .01472 9.5 -4 ]
[.5 .01472 -9 -13 ]
[.5 .01472 9 -4 ]
[.55291 .01472 -6 -13 ]
[.55291 .01472 6 -4 ]
[.60582 .01472 -9.5 -17.4375 ]
[.60582 .01472 9.5 -4 ]
[.65873 .01472 -9.5 -17.4375 ]
[.65873 .01472 9.5 -4 ]
[.71164 .01472 -9 -13 ]
[.71164 .01472 9 -4 ]
[.76455 .01472 -9 -13 ]
[.76455 .01472 9 -4 ]
[.81746 .01472 -9 -13 ]
[.81746 .01472 9 -4 ]
[.87037 .01472 -9 -13 ]
[.87037 .01472 9 -4 ]
[.92328 .01472 -9 -13 ]
[.92328 .01472 9 -4 ]
[.97619 .01472 -9.5 -17.4375 ]
[.97619 .01472 9.5 -4 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .06067 L
.07672 .06067 L
.07672 .01472 L
s
.05026 .06067 m
.05026 .10005 L
.12963 .10005 L
.12963 .01472 L
s
.23545 .01472 m
.23545 .0541 L
.28836 .0541 L
.28836 .01472 L
s
.2619 .0541 m
.2619 .0541 L
.34127 .0541 L
.34127 .01472 L
s
.30159 .0541 m
.30159 .05629 L
.39418 .05629 L
.39418 .01472 L
s
.34788 .05629 m
.34788 .05629 L
.44709 .05629 L
.44709 .01472 L
s
.39749 .05629 m
.39749 .06723 L
.5 .06723 L
.5 .01472 L
s
.44874 .06723 m
.44874 .06723 L
.55291 .06723 L
.55291 .01472 L
s
.50083 .06723 m
.50083 .07161 L
.60582 .07161 L
.60582 .01472 L
s
.55332 .07161 m
.55332 .07598 L
.65873 .07598 L
.65873 .01472 L
s
.60603 .07598 m
.60603 .07817 L
.71164 .07817 L
.71164 .01472 L
s
.65883 .07817 m
.65883 .07817 L
.76455 .07817 L
.76455 .01472 L
s
.71169 .07817 m
.71169 .08255 L
.81746 .08255 L
.81746 .01472 L
s
.76458 .08255 m
.76458 .10224 L
.87037 .10224 L
.87037 .01472 L
s
.18254 .01472 m
.18254 .10662 L
.81747 .10662 L
.81747 .10224 L
s
.50001 .10662 m
.50001 .13287 L
.92328 .13287 L
.92328 .01472 L
s
.71164 .13287 m
.71164 .16132 L
.97619 .16132 L
.97619 .01472 L
s
.08995 .10005 m
.08995 .60332 L
.84392 .60332 L
.84392 .16132 L
s
gsave
.02381 .01472 -73.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(48) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
83.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
83.813 16.000 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
83.813 16.000 moveto
83.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(23)] .07672 .01472 0 -4 Mabsadd 0 1 Mshowa
[(42)] .12963 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.18254 .01472 -70.5 -21.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.563 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
77.813 15.813 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.813 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
gsave
.23545 .01472 -73.5 -21.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.563 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(77) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
83.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
83.813 15.813 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
83.813 15.813 moveto
83.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(101)] .28836 .01472 0 -4 Mabsadd 0 1 Mshowa
[(65)] .34127 .01472 0 -4 Mabsadd 0 1 Mshowa
[(120)] .39418 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.44709 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(115)] .5 .01472 0 -4 Mabsadd 0 1 Mshowa
[(63)] .55291 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.60582 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
gsave
.65873 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
77.813 16.000 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 16.000 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(136)] .71164 .01472 0 -4 Mabsadd 0 1 Mshowa
[(135)] .76455 .01472 0 -4 Mabsadd 0 1 Mshowa
[(109)] .81746 .01472 0 -4 Mabsadd 0 1 Mshowa
[(110)] .87037 .01472 0 -4 Mabsadd 0 1 Mshowa
[(107)] .92328 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.97619 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[47]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`002P3ooolE000002L0oooo400000000`3oool000000000000C000003/0
oooo4000000Z0?ooo`l00000103oool@000006@0oooo3`00000;0?ooo`002P3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0303oool00`000000oooo
0000000C0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0000000C0?ooo`030000003oool0oooo03T0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0680oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`04
0?ooo`<000000P3oool2000000H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`05
0?ooo`<00000103oool00`000000oooo000000060?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0080oooo10000006
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool4000000D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`1R
0?ooo`030000003oool0oooo0080oooo100000050?ooo`030000003oool0oooo00T0oooo000:0?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo0?ooo`@000000`3oool2000000`0oooo0`0000000`3oool000000000
0002000000L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`H000000P3o
ool2000000<0oooo1@0000060?ooo`<00000103oool2000000L0oooo1@0000000`3oool000000000
0002000000<0oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3o
ool010000000oooo0?ooo`3oool5000000030?ooo`000000000000<000000P3oool2000000L0oooo
0`0000040?ooo`800000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0
oooo00@000000?ooo`3oool0oooo1@0000020?ooo`8000000`3oool3000000@0oooo1@0000020?oo
o`800000103oool2000000@0oooo1@0000020?ooo`8000000`3oool3000000D0oooo1@0000000`3o
ool000000000000300000080oooo0P0000040?ooo`D000000P3oool2000000D0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool00P3oool5000000050?ooo`000000oooo0?oo
o`0000001@3oool01@000000oooo0?ooo`3oool0000000D0oooo00@000000?ooo`3oool00000303o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo1@0000040?ooo`030000
003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`060?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000203oool01@000000oooo0?oo
o`3oool0000000D0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00000`3oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00P0oooo1@0000020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0000000L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000D0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0oooo
0`0000060?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000001@3oool0
0`000000oooo000000040?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
1@3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool01P3oool3000000@0oooo0P0000090?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`8000001`3oool3000000H0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<000001P3oool00`000000
oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`8000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P0000060?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000070?ooo`030000003o
ool0oooo00D0oooo0P0000050?ooo`030000003oool0000000@0oooo100000020?ooo`@000001@3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`030?ooo`8000001P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00001`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000007
0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P000006
0?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool00P3oool2000000@0oooo0P00000<0?ooo`8000000`3oool2000000P0oooo00<000000?oo
o`3oool0303oool00`000000oooo0000000C0?ooo`040000003oool00000000000@0oooo0P000004
0?ooo`8000002@3oool3000000<0oooo0`0000070?ooo`800000103oool2000000@0oooo0P000005
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P000004
0?ooo`<000001`3oool3000000<0oooo0P0000080?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080oooo0P000004
0?ooo`800000103oool3000000@0oooo0P0000040?ooo`800000103oool3000000@0oooo0P000004
0?ooo`800000103oool3000000D0oooo0P0000040?ooo`800000103oool2000000D0oooo0P000004
0?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`09
0?ooo`002P3ooolE000002L0oooo400000000`3oool000000000000C000003/0oooo4000000Z0?oo
o`l00000103oool@000006@0oooo3`00000;0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3o
oon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00
503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00503oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0@0?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?oo
o`00503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00503o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00503oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0@0?ooobP0000000<0oooo0000003oool03`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool001@0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool0:03ooolf000001<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool001@0oooo5000000B0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0100oooo000N0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403o
ool001h0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo04/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo000N0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`1;0?ooocX000004P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0100oooo000N0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`1a0?ooobL000004P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`007P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0Q03oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo000N0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`240?ooobP000004P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool001h0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo09L0oooo>`00000B
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo0100oooo000N0?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`2n0?ooobL000004`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0=40oooo00<000000?ooo`3o
ool0903oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0403oool001h0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0=40oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0=40oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403o
ool001h0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0=40oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0=40oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool001h0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0=40
oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0403oool001h0oooo7@00000C0?ooo`030000003oool0oooo0=40oooo
:000000B0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool002`0oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`3T0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00;03oool00`000000oooo0?ooo`0O
0?ooonP000009P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo000/0?oo
o`030000003oool0oooo09<0oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3o
ool0U`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo000/0?ooo`030000
003oool0oooo09<0oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0U`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo000/0?ooo`030000003oool0
oooo09<0oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0U`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0
oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100
oooo000/0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0U`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<0
00000?ooo`3oool0U`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo000/
0?ooo`030000003oool0oooo09<0ooooV`00000B0?ooo`030000003oool0oooo0100oooo000/0?oo
o`030000003oool0oooo0>00oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`0@0?oo
o`00;03oool00`000000oooo0?ooo`3P0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3o
ool0403oool002`0oooo00<000000?ooo`3oool0h03oool00`000000oooo0?ooo`1M0?ooo`030000
003oool0oooo0100oooo000/0?ooo`030000003oool0oooo0>00oooo00<000000?ooo`3oool0G@3o
ool00`000000oooo0?ooo`0@0?ooo`00;03oool00`000000oooo0?ooo`3P0?ooo`030000003oool0
oooo05d0oooo00<000000?ooo`3oool0403oool002`0oooo00<000000?ooo`3oool0h03oool00`00
0000oooo0?ooo`1M0?ooo`030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo0>00
oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`0@0?ooo`00;03oool00`000000oooo
0?ooo`3P0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0403oool002`0oooo00<0
00000?ooo`3oool0h03oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo0100oooo000/
0?ooo`030000003oool0oooo0>00ooooH@00000B0?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0ooooo`00000E00000480oooo003o0?oooh<0oooo003o0?oooh<0oooo
003o0?oooh<0oooo003o0?oooh<0oooo003o0?oooh<0oooo0000\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {-0.0579423, -0.218596, \
0.051845, 0.0125364}}]
}, Open  ]],

Cell["This highlights the two top clusters.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[iris, TruncateDendrogram \[Rule] 20, 
        LeafLabels \[Rule] Automatic, HighlightLevel \[Rule] 2];\)\)], "Input",\

  CellLabel->"In[48]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0291005 0.0529101 0.0147151 0.218812 [
[.02381 .01472 -12.5 -17.4375 ]
[.02381 .01472 12.5 -4 ]
[.07672 .01472 -6 -13 ]
[.07672 .01472 6 -4 ]
[.12963 .01472 -6 -13 ]
[.12963 .01472 6 -4 ]
[.18254 .01472 -9.5 -17.3125 ]
[.18254 .01472 9.5 -4 ]
[.23545 .01472 -12.5 -17.3125 ]
[.23545 .01472 12.5 -4 ]
[.28836 .01472 -9 -13 ]
[.28836 .01472 9 -4 ]
[.34127 .01472 -6 -13 ]
[.34127 .01472 6 -4 ]
[.39418 .01472 -9 -13 ]
[.39418 .01472 9 -4 ]
[.44709 .01472 -9.5 -17.4375 ]
[.44709 .01472 9.5 -4 ]
[.5 .01472 -9 -13 ]
[.5 .01472 9 -4 ]
[.55291 .01472 -6 -13 ]
[.55291 .01472 6 -4 ]
[.60582 .01472 -9.5 -17.4375 ]
[.60582 .01472 9.5 -4 ]
[.65873 .01472 -9.5 -17.4375 ]
[.65873 .01472 9.5 -4 ]
[.71164 .01472 -9 -13 ]
[.71164 .01472 9 -4 ]
[.76455 .01472 -9 -13 ]
[.76455 .01472 9 -4 ]
[.81746 .01472 -9 -13 ]
[.81746 .01472 9 -4 ]
[.87037 .01472 -9 -13 ]
[.87037 .01472 9 -4 ]
[.92328 .01472 -9 -13 ]
[.92328 .01472 9 -4 ]
[.97619 .01472 -9.5 -17.4375 ]
[.97619 .01472 9.5 -4 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 1 0 r
.02381 .01472 m
.02381 .06067 L
.07672 .06067 L
.07672 .01472 L
F
.05026 .01472 m
.05026 .10005 L
.12963 .10005 L
.12963 .01472 L
F
.23545 .01472 m
.23545 .0541 L
.28836 .0541 L
.28836 .01472 L
F
.2619 .01472 m
.2619 .0541 L
.34127 .0541 L
.34127 .01472 L
F
.30159 .01472 m
.30159 .05629 L
.39418 .05629 L
.39418 .01472 L
F
.34788 .01472 m
.34788 .05629 L
.44709 .05629 L
.44709 .01472 L
F
.39749 .01472 m
.39749 .06723 L
.5 .06723 L
.5 .01472 L
F
.44874 .01472 m
.44874 .06723 L
.55291 .06723 L
.55291 .01472 L
F
.50083 .01472 m
.50083 .07161 L
.60582 .07161 L
.60582 .01472 L
F
.55332 .01472 m
.55332 .07598 L
.65873 .07598 L
.65873 .01472 L
F
.60603 .01472 m
.60603 .07817 L
.71164 .07817 L
.71164 .01472 L
F
.65883 .01472 m
.65883 .07817 L
.76455 .07817 L
.76455 .01472 L
F
.71169 .01472 m
.71169 .08255 L
.81746 .08255 L
.81746 .01472 L
F
.76458 .01472 m
.76458 .10224 L
.87037 .10224 L
.87037 .01472 L
F
.18254 .01472 m
.18254 .10662 L
.81747 .10662 L
.81747 .01472 L
F
.50001 .01472 m
.50001 .13287 L
.92328 .13287 L
.92328 .01472 L
F
.71164 .01472 m
.71164 .16132 L
.97619 .16132 L
.97619 .01472 L
F
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .06067 L
.07672 .06067 L
.07672 .01472 L
s
.05026 .06067 m
.05026 .10005 L
.12963 .10005 L
.12963 .01472 L
s
.23545 .01472 m
.23545 .0541 L
.28836 .0541 L
.28836 .01472 L
s
.2619 .0541 m
.2619 .0541 L
.34127 .0541 L
.34127 .01472 L
s
.30159 .0541 m
.30159 .05629 L
.39418 .05629 L
.39418 .01472 L
s
.34788 .05629 m
.34788 .05629 L
.44709 .05629 L
.44709 .01472 L
s
.39749 .05629 m
.39749 .06723 L
.5 .06723 L
.5 .01472 L
s
.44874 .06723 m
.44874 .06723 L
.55291 .06723 L
.55291 .01472 L
s
.50083 .06723 m
.50083 .07161 L
.60582 .07161 L
.60582 .01472 L
s
.55332 .07161 m
.55332 .07598 L
.65873 .07598 L
.65873 .01472 L
s
.60603 .07598 m
.60603 .07817 L
.71164 .07817 L
.71164 .01472 L
s
.65883 .07817 m
.65883 .07817 L
.76455 .07817 L
.76455 .01472 L
s
.71169 .07817 m
.71169 .08255 L
.81746 .08255 L
.81746 .01472 L
s
.76458 .08255 m
.76458 .10224 L
.87037 .10224 L
.87037 .01472 L
s
.18254 .01472 m
.18254 .10662 L
.81747 .10662 L
.81747 .10224 L
s
.50001 .10662 m
.50001 .13287 L
.92328 .13287 L
.92328 .01472 L
s
.71164 .13287 m
.71164 .16132 L
.97619 .16132 L
.97619 .01472 L
s
.08995 .10005 m
.08995 .60332 L
.84392 .60332 L
.84392 .16132 L
s
gsave
.02381 .01472 -73.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(48) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
83.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
83.813 16.000 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
83.813 16.000 moveto
83.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(23)] .07672 .01472 0 -4 Mabsadd 0 1 Mshowa
[(42)] .12963 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.18254 .01472 -70.5 -21.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.563 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
77.813 15.813 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.813 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
gsave
.23545 .01472 -73.5 -21.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.563 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(77) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
83.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
83.813 15.813 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
83.813 15.813 moveto
83.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(101)] .28836 .01472 0 -4 Mabsadd 0 1 Mshowa
[(65)] .34127 .01472 0 -4 Mabsadd 0 1 Mshowa
[(120)] .39418 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.44709 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(115)] .5 .01472 0 -4 Mabsadd 0 1 Mshowa
[(63)] .55291 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.60582 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
gsave
.65873 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
77.813 16.000 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 16.000 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(136)] .71164 .01472 0 -4 Mabsadd 0 1 Mshowa
[(135)] .76455 .01472 0 -4 Mabsadd 0 1 Mshowa
[(109)] .81746 .01472 0 -4 Mabsadd 0 1 Mshowa
[(110)] .87037 .01472 0 -4 Mabsadd 0 1 Mshowa
[(107)] .92328 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.97619 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`002P3ooolE000002L0oooo400000000`3oool000000000000C000003/0
oooo4000000Z0?ooo`l00000103oool@000006@0oooo3`00000;0?ooo`002P3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0303oool00`000000oooo
0000000C0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0000000C0?ooo`030000003oool0oooo03T0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0680oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`04
0?ooo`<000000P3oool2000000H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`05
0?ooo`<00000103oool00`000000oooo000000060?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0080oooo10000006
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool4000000D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`1R
0?ooo`030000003oool0oooo0080oooo100000050?ooo`030000003oool0oooo00T0oooo000:0?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo0?ooo`@000000`3oool2000000`0oooo0`0000000`3oool000000000
0002000000L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`H000000P3o
ool2000000<0oooo1@0000060?ooo`<00000103oool2000000L0oooo1@0000000`3oool000000000
0002000000<0oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3o
ool010000000oooo0?ooo`3oool5000000030?ooo`000000000000<000000P3oool2000000L0oooo
0`0000040?ooo`800000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0
oooo00@000000?ooo`3oool0oooo1@0000020?ooo`8000000`3oool3000000@0oooo1@0000020?oo
o`800000103oool2000000@0oooo1@0000020?ooo`8000000`3oool3000000D0oooo1@0000000`3o
ool000000000000300000080oooo0P0000040?ooo`D000000P3oool2000000D0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool00P3oool5000000050?ooo`000000oooo0?oo
o`0000001@3oool01@000000oooo0?ooo`3oool0000000D0oooo00@000000?ooo`3oool00000303o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo1@0000040?ooo`030000
003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`060?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000203oool01@000000oooo0?oo
o`3oool0000000D0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00000`3oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00P0oooo1@0000020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0000000L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000D0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0oooo
0`0000060?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000001@3oool0
0`000000oooo000000040?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
1@3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool01P3oool3000000@0oooo0P0000090?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`8000001`3oool3000000H0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<000001P3oool00`000000
oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`8000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P0000060?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000070?ooo`030000003o
ool0oooo00D0oooo0P0000050?ooo`030000003oool0000000@0oooo100000020?ooo`@000001@3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`030?ooo`8000001P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00001`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000007
0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P000006
0?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool00P3oool2000000@0oooo0P00000<0?ooo`8000000`3oool2000000P0oooo00<000000?oo
o`3oool0303oool00`000000oooo0000000C0?ooo`040000003oool00000000000@0oooo0P000004
0?ooo`8000002@3oool3000000<0oooo0`0000070?ooo`800000103oool2000000@0oooo0P000005
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P000004
0?ooo`<000001`3oool3000000<0oooo0P0000080?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080oooo0P000004
0?ooo`800000103oool3000000@0oooo0P0000040?ooo`800000103oool3000000@0oooo0P000004
0?ooo`800000103oool3000000D0oooo0P0000040?ooo`800000103oool2000000D0oooo0P000004
0?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`09
0?ooo`002P3ooolE000002L0oooo400000000`3oool000000000000C000003/0oooo4000000Z0?oo
o`l00000103oool@000006@0oooo3`00000;0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3o
oon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00
503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0
4@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?oo
o`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
0?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?oo
o`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3o
ool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`00
00000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`00
00000?l0003o000@003o02P0000000<00?l000000000o`003`00o`000`0000000?l0003o000@003o
000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001@0oooo00<00000003o0000
o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0140oooo00<00000003o0000
o`00:000o`0f000001<00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<000000?ooo`3oool0403oool001@0oooo5000000B003o00030000
003oool0oooo0140oooo00<00000003o0000o`00B`00o`000`0000000?l0003o000S003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000
0000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000
0000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000
003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3o
ool00`0000000?l0003o001;003o000300000000o`000?l002<00?l000<00000003o0000o`004000
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403o
ool001h0oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`00
0?l004/00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`00
0?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`00
0?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0
oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`00
00000?l0003o001;003o03X000004P00o`000`0000000?l0003o000@003o000300000000o`000?l0
01400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`000?l0
01400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo
0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o001a003o02L000004P00o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`007P3oool00`0000000?l0
003o000I003o00030000003oool0oooo0140oooo00<00000003o0000o`00Q000o`000`0000000?l0
003o000S003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0
003o000@003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0
003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<0
00000?ooo`3oool04@3oool00`0000000?l0003o0024003o02P000004P00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<00000
003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l009L00?l0>`00000B
003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@
003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?oo
o`3oool04@3oool00`0000000?l0003o002n003o02L000004`00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<00000003o0000
o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l00=400?l000<00000003o0000
o`009000o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3o
ool0403oool001h0oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`030000
0000o`000?l00=400?l000<00000003o0000o`009000o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<00000003o0000o`006@00
o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l00=400?l000<00000003o0000o`009000
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403o
ool001h0oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`00
0?l00=400?l000<00000003o0000o`009000o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<00000003o0000o`006@00o`000`00
0000oooo0?ooo`0A0?ooo`0300000000o`000?l00=400?l000<00000003o0000o`009000o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001h0
oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l00=40
0?l000<00000003o0000o`009000o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<000000?ooo`3oool0403oool001h0oooo7@00000C0?ooo`0300000000o`000?l00=400?l0
:000000B003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool002`0oooo00<0
00000?ooo`3oool07`3oool00`0000000?l0003o003T003o000300000000o`000?l002@00?l000<0
0000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00;03oool00`000000oooo0?ooo`0O
0?ooonP000009P00o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000/0?oo
o`030000003oool0oooo09<0oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o
00030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<00000003o0000
o`00U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000/0?ooo`030000
003oool0oooo09<0oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000
003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<00000003o0000o`00U`00
o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000/0?ooo`030000003oool0
oooo09<0oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000003oool0
oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<00000003o0000o`00U`00o`000`00
00000?l0003o000@003o00030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0
oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100
oooo000/0?ooo`030000003oool0oooo09<0oooo00<00000003o0000o`00U`00o`000`0000000?l0
003o000@003o00030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo09<0oooo00<0
0000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000/
0?ooo`030000003oool0oooo09<0ooooV`00000B003o00030000003oool0oooo0100oooo000/0?oo
o`030000003oool0oooo0>00oooo00<00000003o0000o`00G@00o`000`000000oooo0?ooo`0@0?oo
o`00;03oool00`000000oooo0?ooo`3P0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3o
ool0403oool002`0oooo00<000000?ooo`3oool0h03oool00`0000000?l0003o001M003o00030000
003oool0oooo0100oooo000/0?ooo`030000003oool0oooo0>00oooo00<00000003o0000o`00G@00
o`000`000000oooo0?ooo`0@0?ooo`00;03oool00`000000oooo0?ooo`3P0?ooo`0300000000o`00
0?l005d00?l000<000000?ooo`3oool0403oool002`0oooo00<000000?ooo`3oool0h03oool00`00
00000?l0003o001M003o00030000003oool0oooo0100oooo000/0?ooo`030000003oool0oooo0>00
oooo00<00000003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00;03oool00`000000oooo
0?ooo`3P0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3oool0403oool002`0oooo00<0
00000?ooo`3oool0h03oool00`0000000?l0003o001M003o00030000003oool0oooo0100oooo000/
0?ooo`030000003oool0oooo0>00ooooH@00000B0?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo
0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00
;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<0
00000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0
oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`03
0000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3oool00`000000oooo
0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03o
ool002`0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?oo
o`030000003oool0oooo0?l0oooo4@3oool00`000000oooo0?ooo`100?ooo`00;03oool00`000000
oooo0?ooo`3o0?oooa40oooo00<000000?ooo`3oool0@03oool002`0oooo00<000000?ooo`3oool0
o`3ooolA0?ooo`030000003oool0oooo0400oooo000/0?ooo`030000003oool0oooo0?l0oooo4@3o
ool00`000000oooo0?ooo`100?ooo`00;03oool00`000000oooo0?ooo`3o0?oooa40oooo00<00000
0?ooo`3oool0@03oool002`0ooooo`00000E00000480oooo003o0?oooh<0oooo003o0?oooh<0oooo
003o0?oooh<0oooo003o0?oooh<0oooo003o0?oooh<0oooo0000\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {-0.0579423, -0.218596, \
0.051845, 0.0125364}}]
}, Open  ]],

Cell["\<\
This generates a dendrogram truncated between levels 2 and 20.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DendrogramPlot[iris, TruncateDendrogram \[Rule] {2, 20}, 
        LeafLabels \[Rule] Automatic, HighlightLevel \[Rule] 2];\)\)], "Input",\

  CellLabel->"In[49]:=",
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Left}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0291005 0.0529101 0.0147151 0.878513 [
[.02381 .01472 -12.5 -17.4375 ]
[.02381 .01472 12.5 -4 ]
[.07672 .01472 -6 -13 ]
[.07672 .01472 6 -4 ]
[.12963 .01472 -6 -13 ]
[.12963 .01472 6 -4 ]
[.18254 .01472 -9.5 -17.3125 ]
[.18254 .01472 9.5 -4 ]
[.23545 .01472 -12.5 -17.3125 ]
[.23545 .01472 12.5 -4 ]
[.28836 .01472 -9 -13 ]
[.28836 .01472 9 -4 ]
[.34127 .01472 -6 -13 ]
[.34127 .01472 6 -4 ]
[.39418 .01472 -9 -13 ]
[.39418 .01472 9 -4 ]
[.44709 .01472 -9.5 -17.4375 ]
[.44709 .01472 9.5 -4 ]
[.5 .01472 -9 -13 ]
[.5 .01472 9 -4 ]
[.55291 .01472 -6 -13 ]
[.55291 .01472 6 -4 ]
[.60582 .01472 -9.5 -17.4375 ]
[.60582 .01472 9.5 -4 ]
[.65873 .01472 -9.5 -17.4375 ]
[.65873 .01472 9.5 -4 ]
[.71164 .01472 -9 -13 ]
[.71164 .01472 9 -4 ]
[.76455 .01472 -9 -13 ]
[.76455 .01472 9 -4 ]
[.81746 .01472 -9 -13 ]
[.81746 .01472 9 -4 ]
[.87037 .01472 -9 -13 ]
[.87037 .01472 9 -4 ]
[.92328 .01472 -9 -13 ]
[.92328 .01472 9 -4 ]
[.97619 .01472 -9.5 -17.4375 ]
[.97619 .01472 9.5 -4 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 1 0 r
.02381 .01472 m
.02381 .1992 L
.07672 .1992 L
.07672 .01472 L
F
.05026 .01472 m
.05026 .35734 L
.12963 .35734 L
.12963 .01472 L
F
.23545 .01472 m
.23545 .17285 L
.28836 .17285 L
.28836 .01472 L
F
.2619 .01472 m
.2619 .17285 L
.34127 .17285 L
.34127 .01472 L
F
.30159 .01472 m
.30159 .18163 L
.39418 .18163 L
.39418 .01472 L
F
.34788 .01472 m
.34788 .18163 L
.44709 .18163 L
.44709 .01472 L
F
.39749 .01472 m
.39749 .22556 L
.5 .22556 L
.5 .01472 L
F
.44874 .01472 m
.44874 .22556 L
.55291 .22556 L
.55291 .01472 L
F
.50083 .01472 m
.50083 .24313 L
.60582 .24313 L
.60582 .01472 L
F
.55332 .01472 m
.55332 .2607 L
.65873 .2607 L
.65873 .01472 L
F
.60603 .01472 m
.60603 .26948 L
.71164 .26948 L
.71164 .01472 L
F
.65883 .01472 m
.65883 .26948 L
.76455 .26948 L
.76455 .01472 L
F
.71169 .01472 m
.71169 .28705 L
.81746 .28705 L
.81746 .01472 L
F
.76458 .01472 m
.76458 .36612 L
.87037 .36612 L
.87037 .01472 L
F
.18254 .01472 m
.18254 .38369 L
.81747 .38369 L
.81747 .01472 L
F
.50001 .01472 m
.50001 .48911 L
.92328 .48911 L
.92328 .01472 L
F
.71164 .01472 m
.71164 .60332 L
.97619 .60332 L
.97619 .01472 L
F
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .1992 L
.07672 .1992 L
.07672 .01472 L
s
.05026 .1992 m
.05026 .35734 L
.12963 .35734 L
.12963 .01472 L
s
.23545 .01472 m
.23545 .17285 L
.28836 .17285 L
.28836 .01472 L
s
.2619 .17285 m
.2619 .17285 L
.34127 .17285 L
.34127 .01472 L
s
.30159 .17285 m
.30159 .18163 L
.39418 .18163 L
.39418 .01472 L
s
.34788 .18163 m
.34788 .18163 L
.44709 .18163 L
.44709 .01472 L
s
.39749 .18163 m
.39749 .22556 L
.5 .22556 L
.5 .01472 L
s
.44874 .22556 m
.44874 .22556 L
.55291 .22556 L
.55291 .01472 L
s
.50083 .22556 m
.50083 .24313 L
.60582 .24313 L
.60582 .01472 L
s
.55332 .24313 m
.55332 .2607 L
.65873 .2607 L
.65873 .01472 L
s
.60603 .2607 m
.60603 .26948 L
.71164 .26948 L
.71164 .01472 L
s
.65883 .26948 m
.65883 .26948 L
.76455 .26948 L
.76455 .01472 L
s
.71169 .26948 m
.71169 .28705 L
.81746 .28705 L
.81746 .01472 L
s
.76458 .28705 m
.76458 .36612 L
.87037 .36612 L
.87037 .01472 L
s
.18254 .01472 m
.18254 .38369 L
.81747 .38369 L
.81747 .36612 L
s
.50001 .38369 m
.50001 .48911 L
.92328 .48911 L
.92328 .01472 L
s
.71164 .48911 m
.71164 .60332 L
.97619 .60332 L
.97619 .01472 L
s
gsave
.02381 .01472 -73.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(48) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
83.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
83.813 16.000 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
83.813 16.000 moveto
83.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(23)] .07672 .01472 0 -4 Mabsadd 0 1 Mshowa
[(42)] .12963 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.18254 .01472 -70.5 -21.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.563 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
77.813 15.813 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.813 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
gsave
.23545 .01472 -73.5 -21.3125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.3125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.563 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(77) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
83.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
83.813 15.813 lineto
stroke
0.375 setlinewidth
63.188 15.813 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
83.813 15.813 moveto
83.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(101)] .28836 .01472 0 -4 Mabsadd 0 1 Mshowa
[(65)] .34127 .01472 0 -4 Mabsadd 0 1 Mshowa
[(120)] .39418 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.44709 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(115)] .5 .01472 0 -4 Mabsadd 0 1 Mshowa
[(63)] .55291 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.60582 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
gsave
.65873 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
77.813 16.000 lineto
stroke
0.375 setlinewidth
63.188 16.000 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 16.000 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
[(136)] .71164 .01472 0 -4 Mabsadd 0 1 Mshowa
[(135)] .76455 .01472 0 -4 Mabsadd 0 1 Mshowa
[(109)] .81746 .01472 0 -4 Mabsadd 0 1 Mshowa
[(110)] .87037 .01472 0 -4 Mabsadd 0 1 Mshowa
[(107)] .92328 .01472 0 -4 Mabsadd 0 1 Mshowa
gsave
.97619 .01472 -70.5 -21.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

67.625 13.688 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
0.000 0.000 0.000 setrgbcolor
0.375 setlinewidth
63.188 5.188 moveto
77.813 5.188 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
77.813 15.938 lineto
stroke
0.375 setlinewidth
63.188 15.938 moveto
63.188 5.188 lineto
stroke
0.375 setlinewidth
77.813 15.938 moveto
77.813 5.188 lineto
stroke
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[49]:=",
  ImageSize->{386, 238.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000620000kR000`400?l00000o`00003oo`3ooon3
0?ooo`00o`3ooon30?ooo`002P3ooolE000002L0oooo400000000`3oool000000000000C000003/0
oooo4000000Z0?ooo`l00000103oool@000006@0oooo3`00000;0?ooo`002P3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0303oool00`000000oooo
0000000C0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02D0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0000000C0?ooo`030000003oool0oooo03T0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0680oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`04
0?ooo`<000000P3oool2000000H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`05
0?ooo`<00000103oool00`000000oooo000000060?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0080oooo10000006
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool4000000D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`1R
0?ooo`030000003oool0oooo0080oooo100000050?ooo`030000003oool0oooo00T0oooo000:0?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo0?ooo`@000000`3oool2000000`0oooo0`0000000`3oool000000000
0002000000L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`H000000P3o
ool2000000<0oooo1@0000060?ooo`<00000103oool2000000L0oooo1@0000000`3oool000000000
0002000000<0oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3o
ool010000000oooo0?ooo`3oool5000000030?ooo`000000000000<000000P3oool2000000L0oooo
0`0000040?ooo`800000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0
oooo00@000000?ooo`3oool0oooo1@0000020?ooo`8000000`3oool3000000@0oooo1@0000020?oo
o`800000103oool2000000@0oooo1@0000020?ooo`8000000`3oool3000000D0oooo1@0000000`3o
ool000000000000300000080oooo0P0000040?ooo`D000000P3oool2000000D0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool00P3oool5000000050?ooo`000000oooo0?oo
o`0000001@3oool01@000000oooo0?ooo`3oool0000000D0oooo00@000000?ooo`3oool00000303o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo1@0000040?ooo`030000
003oool0000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`060?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000203oool01@000000oooo0?oo
o`3oool0000000D0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00000`3oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00P0oooo1@0000020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0000000L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000D0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0oooo
0`0000060?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000001@3oool0
0`000000oooo000000040?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
1@3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool01P3oool3000000@0oooo0P0000090?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`020?ooo`8000001`3oool3000000H0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<000001P3oool00`000000
oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`8000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool0103oool2000000<0oooo0P0000060?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000070?ooo`030000003o
ool0oooo00D0oooo0P0000050?ooo`030000003oool0000000@0oooo100000020?ooo`@000001@3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`030?ooo`8000001P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00001`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000007
0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P000006
0?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool00P3oool2000000@0oooo0P00000<0?ooo`8000000`3oool2000000P0oooo00<000000?oo
o`3oool0303oool00`000000oooo0000000C0?ooo`040000003oool00000000000@0oooo0P000004
0?ooo`8000002@3oool3000000<0oooo0`0000070?ooo`800000103oool2000000@0oooo0P000005
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P000004
0?ooo`<000001`3oool3000000<0oooo0P0000080?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080oooo0P000004
0?ooo`800000103oool3000000@0oooo0P0000040?ooo`800000103oool3000000@0oooo0P000004
0?ooo`800000103oool3000000D0oooo0P0000040?ooo`800000103oool2000000D0oooo0P000004
0?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`09
0?ooo`002P3ooolE000002L0oooo400000000`3oool000000000000C000003/0oooo4000000Z0?oo
o`l00000103oool@000006@0oooo3`00000;0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3o
oon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00503oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`00
503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0
4@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?oo
o`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
0?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?oo
o`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3o
ool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`00
00000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
00000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
00000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
0000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0
003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0
003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0
003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo
0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
00000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@
003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@
003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@
003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@
0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?oo
o`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o
0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o
0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00
503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0
4@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?oo
o`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
0?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?oo
o`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3o
ool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`00
00000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
00000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
00000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
0000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0
003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0
003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0
003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo
0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
00000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@
003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@
003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@
003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@
0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?oo
o`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o
0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o
0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00
503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0
4@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool0
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o
000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?oo
o`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
0?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?oo
o`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3o
ool04@3oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000
o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o00030000
0000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3o
ool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00
o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000
o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`00
0?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`00
00000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
00000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
00000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`00
0000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0
003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0
003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0
003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo
0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
00000?ooo`3oool04@3oool00`0000000?l0003o000@003o02P000004P00o`000`0000000?l0003o
000@003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001@0oooo00<00000
003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0140oooo00<00000
003o0000o`00:000o`000`0000000?l0003o000O003o000300000000o`000?l001000?l000<00000
003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o
000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o000X003o
000300000000o`000?l001l00?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o
000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o
000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o
000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o
00030000003oool0oooo0100oooo000D0?ooo`0300000000o`000?l001000?l000<00000003o0000
o`004000o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l002P00?l0=P00000C003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
00000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
00000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
0000003oool0oooo0100oooo000D0?ooo`0300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l004/00?l000<00000003o0000o`00
8`00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool04@3oool00`0000000?l0003o001;003o000300000000
o`000?l002<00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool0403oool001@0oooo00<00000003o0000o`004000o`00
0`0000000?l0003o000@003o00030000003oool0oooo0140oooo00<00000003o0000o`00B`00o`00
0`0000000?l0003o000S003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000@003o000300000000o`000?l001400?l000<00000003o0000o`004000o`00
0`0000000?l0003o000@003o000300000000o`000?l001400?l000<00000003o0000o`004000o`00
0`0000000?l0003o000@003o00030000003oool0oooo0100oooo000D0?ooo`0300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l0
04/00?l000<00000003o0000o`008`00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00503oool00`000000
0?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o001;003o000300000000o`000?l002<00?l000<00000003o0000o`004000o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001@0oooo
00<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0140oooo
00<00000003o0000o`00B`00o`000`0000000?l0003o000S003o000300000000o`000?l001000?l0
00<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`000?l001400?l0
00<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`000?l001400?l0
00<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo
000D0?oooa@000004P00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l004/00?l000<0
0000003o0000o`008`00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<0
0000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`007P3oool00`0000000?l0003o000I
003o00030000003oool0oooo0140oooo00<00000003o0000o`00B`00o`000`0000000?l0003o000S
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000@
003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@
003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@
003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?oo
o`3oool04@3oool00`0000000?l0003o001;003o000300000000o`000?l002<00?l000<00000003o
0000o`004000o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?oo
o`3oool0403oool001h0oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`03
00000000o`000?l004/00?l000<00000003o0000o`008`00o`000`0000000?l0003o000@003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o0003
00000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00
7P3oool00`0000000?l0003o000I003o00030000003oool0oooo0140oooo00<00000003o0000o`00
B`00o`000`0000000?l0003o000S003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000@003o000300000000o`000?l001400?l000<00000003o0000o`00
4000o`000`0000000?l0003o000@003o000300000000o`000?l001400?l000<00000003o0000o`00
4000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000
o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o001;003o000300000000
o`000?l002<00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<00000003o0000o`006@00o`00
0`000000oooo0?ooo`0A0?ooo`0300000000o`000?l004/00?l000<00000003o0000o`008`00o`00
0`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`00
0`000000oooo0?ooo`0@0?ooo`007P3oool00`0000000?l0003o000I003o00030000003oool0oooo
0140oooo00<00000003o0000o`00B`00o`000`0000000?l0003o000S003o000300000000o`000?l0
01000?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`000?l0
01400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`000?l0
01400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo
0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o001;003o000300000000o`000?l002<00?l000<00000003o0000o`004000o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`000000
0?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo
00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l004/00?l0
>P00000B003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0
003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<0
0000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l007400?l000<0
0000003o0000o`008`00o`000`0000000?l0003o000@003o000300000000o`000?l001400?l000<0
0000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`000?l001400?l000<0
0000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N
0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o001a
003o000300000000o`000?l002<00?l000<00000003o0000o`004000o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@
0?ooo`007P3oool00`0000000?l0003o000I003o00030000003oool0oooo0140oooo00<00000003o
0000o`00L@00o`000`0000000?l0003o000S003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<00000003o
0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<000000?oo
o`3oool0403oool001h0oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`03
00000000o`000?l007400?l000<00000003o0000o`008`00o`000`0000000?l0003o000@003o0003
00000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
00000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
0000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool0
4@3oool00`0000000?l0003o001a003o000300000000o`000?l002<00?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0@0?ooo`007P3oool00`0000000?l0003o000I003o00030000003o
ool0oooo0140oooo00<00000003o0000o`00L@00o`000`0000000?l0003o000S003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000
o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<00000003o0000o`006@00o`00
0`000000oooo0?ooo`0A0?ooo`0300000000o`000?l007400?l09`00000B003o000300000000o`00
0?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o000300000000o`00
0?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0
oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`00
00000?l0003o0024003o000300000000o`000?l002<00?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<00000003o0000o`004@00o`000`00
00000?l0003o000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001h0
oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l008@0
0?l000<00000003o0000o`008`00o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`0000000?l0003o000A003o000300000000o`000?l00100
0?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`007P3oool00`0000000?l0
003o000I003o00030000003oool0oooo0140oooo00<00000003o0000o`00Q000o`000`0000000?l0
003o000S003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0
003o000@003o000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0
003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<0
00000?ooo`3oool04@3oool00`0000000?l0003o0024003o000300000000o`000?l002<00?l000<0
0000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
0000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l001000?l000<0
00000?ooo`3oool0403oool001h0oooo00<00000003o0000o`006@00o`000`000000oooo0?ooo`0A
0?ooo`0300000000o`000?l008@00?l000<00000003o0000o`008`00o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`0000000?l0003o000A
003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@
0?ooo`007P3oool00`0000000?l0003o000I003o00030000003oool0oooo0140oooo00<00000003o
0000o`00Q000o`0W000001<00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o
000300000000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o
00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3o
ool04@3oool00`0000000?l0003o002G003o000300000000o`000?l002@00?l000<00000003o0000
o`004000o`000`0000000?l0003o000@003o000300000000o`000?l001400?l000<00000003o0000
o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`030000
0000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o002G003o00030000
0000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000
0000o`000?l001400?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000
003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3o
ool00`0000000?l0003o002G003o03/000004P00o`000`0000000?l0003o000A003o000300000000
o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`007P3oool0
0`0000000?l0003o000I003o00030000003oool0oooo0140oooo00<00000003o0000o`00_P00o`00
0`0000000?l0003o000S003o000300000000o`000?l001400?l000<00000003o0000o`004000o`00
0`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l0
01T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o002n003o000300000000o`000?l0
02<00?l000<00000003o0000o`004@00o`000`0000000?l0003o000@003o000300000000o`000?l0
01000?l000<000000?ooo`3oool0403oool001h0oooo00<00000003o0000o`006@00o`000`000000
oooo0?ooo`0A0?ooo`0300000000o`000?l00;h00?l000<00000003o0000o`008`00o`000`000000
0?l0003o000A003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000
oooo0?ooo`0@0?ooo`007P3oool00`0000000?l0003o000I003o00030000003oool0oooo0140oooo
00<00000003o0000o`00_P00o`000`0000000?l0003o000S003o000300000000o`000?l001400?l0
00<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo
000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o
002n003o000300000000o`000?l002<00?l000<00000003o0000o`004@00o`000`0000000?l0003o
000@003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool001h0oooo00<00000
003o0000o`006@00o`000`000000oooo0?ooo`0A0?ooo`0300000000o`000?l00;h00?l000<00000
003o0000o`008`00o`000`0000000?l0003o000A003o000300000000o`000?l001000?l000<00000
003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`007P3oool00`0000000?l0003o000I003o
00030000003oool0oooo0140oooo00<00000003o0000o`00_P00o`0W000001<00?l000<00000003o
0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`03
00000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o0003
00000000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
0000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool0
4@3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`00
4000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000
o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000
o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003o
ool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool0
0`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`00
0`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l0
01T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000o`000?l0
02@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo
0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`000000
0?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`000`000000
0?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l0
00<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l0
00<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo
000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o
003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o
000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<00000
0?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000
003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?oo
o`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o
000300000000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o
00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3o
ool04@3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000
o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`030000
0000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o00030000
0000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000
003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3o
ool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000
o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`00
0?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000o`00
0?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0
oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`00
00000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`000`00
00000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T0
0?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000o`000?l002@0
0?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100
oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0
003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0
003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<0
00000?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<0
0000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N
0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A
003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@
003o00030000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?oo
o`3oool04@3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o
0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`03
00000000o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o0003
00000000o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o0003
0000003oool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool0
4@3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`00
4000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?ooo`0300000000
o`000?l001T00?l000<000000?ooo`3oool04@3oool00`0000000?l0003o003A003o000300000000
o`000?l002@00?l000<00000003o0000o`004000o`000`0000000?l0003o000@003o00030000003o
ool0oooo0100oooo000N0?ooo`0300000000o`000?l001T00?l000<000000?ooo`3oool04@3oool0
0`0000000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`00
0`0000000?l0003o000@003o00030000003oool0oooo0100oooo000N0?oooad000004`3oool00`00
00000?l0003o003A003o000300000000o`000?l002@00?l000<00000003o0000o`004000o`000`00
00000?l0003o000@003o00030000003oool0oooo0100oooo001>0?ooo`0300000000o`000?l00=40
0?l000<00000003o0000o`009000o`000`0000000?l0003o000@003o000300000000o`000?l00100
0?l000<000000?ooo`3oool0403oool004h0oooo00<00000003o0000o`00d@00o`000`0000000?l0
003o000T003o000300000000o`000?l001000?l000<00000003o0000o`004000o`000`000000oooo
0?ooo`0@0?ooo`00CP3oool00`0000000?l0003o003A003o000300000000o`000?l002@00?l000<0
0000003o0000o`004000o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo001>
0?ooo`0300000000o`000?l00=400?l0:000000B003o000300000000o`000?l001000?l000<00000
0?ooo`3oool0403oool004h0oooo00<00000003o0000o`00i000o`000`0000000?l0003o000T003o
000300000000o`000?l001000?l000<000000?ooo`3oool0403oool004h0oooo00<00000003o0000
o`00i000o`000`0000000?l0003o000T003o000300000000o`000?l001000?l000<000000?ooo`3o
ool0403oool004h0oooo00<00000003o0000o`00i000o`000`0000000?l0003o000T003o00030000
0000o`000?l001000?l000<000000?ooo`3oool0403oool004h0oooo00<00000003o0000o`00i000
o`000`0000000?l0003o000T003o000300000000o`000?l001000?l000<000000?ooo`3oool0403o
ool004h0oooo00<00000003o0000o`00i000o`000`0000000?l0003o000T003o000300000000o`00
0?l001000?l000<000000?ooo`3oool0403oool004h0ooooj000000V003o000300000000o`000?l0
01000?l000<000000?ooo`3oool0403oool00<80oooo00<00000003o0000o`00U`00o`000`000000
0?l0003o000@003o00030000003oool0oooo0100oooo00320?ooo`0300000000o`000?l009L00?l0
00<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`0000000?l0003o
002G003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool00<80oooo00<00000
003o0000o`00U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo00320?oo
o`0300000000o`000?l009L00?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?oo
o`00`P3oool00`0000000?l0003o002G003o000300000000o`000?l001000?l000<000000?ooo`3o
ool0403oool00<80oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000
003oool0oooo0100oooo00320?ooo`0300000000o`000?l009L00?l000<00000003o0000o`004000
o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`0000000?l0003o002G003o000300000000o`00
0?l001000?l000<000000?ooo`3oool0403oool00<80oooo00<00000003o0000o`00U`00o`000`00
00000?l0003o000@003o00030000003oool0oooo0100oooo00320?ooo`0300000000o`000?l009L0
0?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`0000000?l0
003o002G003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool00<80oooo00<0
0000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo0032
0?ooo`0300000000o`000?l009L00?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@
0?ooo`00`P3oool00`0000000?l0003o002G003o000300000000o`000?l001000?l000<000000?oo
o`3oool0403oool00<80oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o0003
0000003oool0oooo0100oooo00320?ooo`0300000000o`000?l009L00?l000<00000003o0000o`00
4000o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`0000000?l0003o002G003o000300000000
o`000?l001000?l000<000000?ooo`3oool0403oool00<80oooo00<00000003o0000o`00U`00o`00
0`0000000?l0003o000@003o00030000003oool0oooo0100oooo00320?ooo`0300000000o`000?l0
09L00?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`000000
0?l0003o002G003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool00<80oooo
00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo
00320?ooo`0300000000o`000?l009L00?l000<00000003o0000o`004000o`000`000000oooo0?oo
o`0@0?ooo`00`P3oool00`0000000?l0003o002G003o000300000000o`000?l001000?l000<00000
0?ooo`3oool0403oool00<80oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o
00030000003oool0oooo0100oooo00320?ooo`0300000000o`000?l009L00?l000<00000003o0000
o`004000o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`0000000?l0003o002G003o00030000
0000o`000?l001000?l000<000000?ooo`3oool0403oool00<80oooo00<00000003o0000o`00U`00
o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo00320?ooo`0300000000o`00
0?l009L00?l000<00000003o0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`00
00000?l0003o002G003o000300000000o`000?l001000?l000<000000?ooo`3oool0403oool00<80
oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100
oooo00320?ooo`0300000000o`000?l009L00?l000<00000003o0000o`004000o`000`000000oooo
0?ooo`0@0?ooo`00`P3oool00`0000000?l0003o002G003o000300000000o`000?l001000?l000<0
00000?ooo`3oool0403oool00<80oooo00<00000003o0000o`00U`00o`000`0000000?l0003o000@
003o00030000003oool0oooo0100oooo00320?ooo`0300000000o`000?l009L00?l000<00000003o
0000o`004000o`000`000000oooo0?ooo`0@0?ooo`00`P3oool00`0000000?l0003o002G003o0003
00000000o`000?l001000?l000<000000?ooo`3oool0403oool00<80oooo00<00000003o0000o`00
U`00o`000`0000000?l0003o000@003o00030000003oool0oooo0100oooo00320?oooi/000004P00
o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l005d00?l000<00000
0?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0003o001M003o00030000003oool0oooo
0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00
o`3oool@0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3oool0403oool00?l0oooo403o
ool00`0000000?l0003o001M003o00030000003oool0oooo0100oooo003o0?oooa00oooo00<00000
003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l0
05d00?l000<000000?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0003o001M003o0003
0000003oool0oooo0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00o`000`000000oooo
0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3oool0403o
ool00?l0oooo403oool00`0000000?l0003o001M003o00030000003oool0oooo0100oooo003o0?oo
oa00oooo00<00000003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`03
00000000o`000?l005d00?l000<000000?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0
003o001M003o00030000003oool0oooo0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00
o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l005d00?l000<00000
0?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0003o001M003o00030000003oool0oooo
0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00
o`3oool@0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3oool0403oool00?l0oooo403o
ool00`0000000?l0003o001M003o00030000003oool0oooo0100oooo003o0?oooa00oooo00<00000
003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l0
05d00?l000<000000?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0003o001M003o0003
0000003oool0oooo0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00o`000`000000oooo
0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3oool0403o
ool00?l0oooo403oool00`0000000?l0003o001M003o00030000003oool0oooo0100oooo003o0?oo
oa00oooo00<00000003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`03
00000000o`000?l005d00?l000<000000?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0
003o001M003o00030000003oool0oooo0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00
o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l005d00?l000<00000
0?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0003o001M003o00030000003oool0oooo
0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00
o`3oool@0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3oool0403oool00?l0oooo403o
ool00`0000000?l0003o001M003o00030000003oool0oooo0100oooo003o0?oooa00oooo00<00000
003o0000o`00G@00o`000`000000oooo0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l0
05d00?l000<000000?ooo`3oool0403oool00?l0oooo403oool00`0000000?l0003o001M003o0003
0000003oool0oooo0100oooo003o0?oooa00oooo00<00000003o0000o`00G@00o`000`000000oooo
0?ooo`0@0?ooo`00o`3oool@0?ooo`0300000000o`000?l005d00?l000<000000?ooo`3oool0403o
ool00?l0oooo403oool00`0000000?l0003o001M003o00030000003oool0oooo0100oooo003o0?oo
oa00ooooH@00000B0?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon30?ooo`00o`3ooon3
0?ooo`00o`3ooon30?ooo`00\
\>"],
  ImageRangeCache->{{{0, 385}, {237.375, 0}} -> {-0.0579423, -0.0544458, \
0.051845, 0.00312246}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Subsection"],

Cell[TextData[{
  "[1] L. Kaufman and P. J. Rousseeuw, ",
  StyleBox["Finding Groups in Data: An Introduction to Cluster Analysis",
    FontSlant->"Italic"],
  ", New York: John Wiley & Sons, 1990."
}], "Text",
  CellTags->"KR90"],

Cell[TextData[{
  "[2] P. J. Rousseeuw, \[OpenCurlyDoubleQuote]Silhouettes: A Graphical Aid \
to the Interpretation and Validation of Cluster Analysis,\
\[CloseCurlyDoubleQuote] ",
  StyleBox["J Comput. Appl. Math.",
    FontSlant->"Italic"],
  ", ",
  StyleBox["20",
    FontWeight->"Bold"],
  ", 1987, 53\[Dash]65."
}], "Text",
  CellTags->"R87"],

Cell[TextData[{
  "[3] R. Tibshirani, G. Walther, and T. Hastie, \
\[OpenCurlyDoubleQuote]Estimating the Number of Clusters in a Dataset Via the \
Gap Statistic.\[CloseCurlyDoubleQuote] Stanford Univ. Tech. report. March \
2000. (published ",
  StyleBox["Journal of the Royal Statistical Society",
    FontSlant->"Italic"],
  ", B, ",
  StyleBox["63",
    FontWeight->"Bold"],
  ", 2001, 411\[Dash]423.)"
}], "Text",
  CellTags->"TWH00"],

Cell[TextData[{
  "[4] R. A. Fisher, \[OpenCurlyDoubleQuote]The Use of Multiple Measurements \
in Taxonomic Problems,\[CloseCurlyDoubleQuote] ",
  StyleBox["Annals of Eugenics",
    FontSlant->"Italic"],
  ", ",
  StyleBox["7",
    FontWeight->"Bold"],
  ", 1936, 179\[Dash]188."
}], "Reference",
  CellTags->"Fisher"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{550, 550},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cluster Analysis",
ShowSelection->True,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.7.1"->{
    Cell[4177, 126, 5261, 148, 120, "DefinitionBox",
      CellTags->"S6.7.1"],
    Cell[9441, 276, 125, 5, 15, "Caption",
      CellTags->"S6.7.1"]},
  "Agglomerate"->{
    Cell[343521, 10354, 612, 19, 44, "DefinitionBox",
      CellTags->"Agglomerate"]},
  "linkages"->{
    Cell[355887, 10719, 1544, 45, 218, "DefinitionBox",
      CellTags->"linkages"]},
  "FisherRef"->{
    Cell[585767, 15218, 258, 8, 56, "MathCaption",
      CellTags->"FisherRef"]},
  "KR90"->{
    Cell[772315, 19250, 230, 6, 40, "Text",
      CellTags->"KR90"]},
  "R87"->{
    Cell[772548, 19258, 348, 11, 38, "Text",
      CellTags->"R87"]},
  "TWH00"->{
    Cell[772899, 19271, 437, 12, 54, "Text",
      CellTags->"TWH00"]},
  "Fisher"->{
    Cell[773339, 19285, 318, 10, 40, "Reference",
      CellTags->"Fisher"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.7.1", 774396, 19318},
  {"Agglomerate", 774566, 19323},
  {"linkages", 774669, 19326},
  {"FisherRef", 774772, 19329},
  {"KR90", 774866, 19332},
  {"R87", 774947, 19335},
  {"TWH00", 775030, 19338},
  {"Fisher", 775116, 19341}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 46, 0, 61, "Section"],
Cell[1825, 55, 487, 8, 78, "Text"],
Cell[2315, 65, 1393, 43, 64, "DefinitionBox"],
Cell[3711, 110, 297, 8, 15, "Caption"],
Cell[4011, 120, 163, 4, 37, "Text"],
Cell[4177, 126, 5261, 148, 120, "DefinitionBox",
  CellTags->"S6.7.1"],
Cell[9441, 276, 125, 5, 15, "Caption",
  CellTags->"S6.7.1"],
Cell[9569, 283, 369, 12, 37, "Text"],
Cell[9941, 297, 46, 0, 40, "MathCaption"],
Cell[9990, 299, 202, 6, 26, "Input"],
Cell[10195, 307, 49, 0, 40, "MathCaption"],
Cell[10247, 309, 146, 3, 26, "Input"],
Cell[10396, 314, 120, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[10541, 321, 117, 3, 26, "Input"],
Cell[10661, 326, 96, 2, 25, "Output"]
}, Open  ]],
Cell[10772, 331, 129, 3, 36, "Text"],
Cell[10904, 336, 125, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[11054, 343, 245, 4, 42, "Input"],
Cell[11302, 349, 74, 2, 25, "Output"]
}, Open  ]],
Cell[11391, 354, 232, 4, 50, "Text"],
Cell[11626, 360, 54, 0, 40, "MathCaption"],
Cell[11683, 362, 487, 9, 106, "Input"],
Cell[12173, 373, 113, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[12311, 380, 129, 3, 42, "Input"],
Cell[12443, 385, 342, 5, 73, "Output"]
}, Open  ]],
Cell[12800, 393, 335, 6, 64, "Text"],
Cell[13138, 401, 155, 3, 56, "MathCaption"],
Cell[13296, 406, 95, 2, 26, "Input"],
Cell[13394, 410, 667, 13, 180, "Input"],
Cell[14064, 425, 140, 3, 56, "MathCaption"],
Cell[14207, 430, 473, 9, 122, "Input"],
Cell[14683, 441, 79, 0, 40, "MathCaption"],
Cell[14765, 443, 91, 2, 26, "Input"],
Cell[14859, 447, 54, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[14938, 451, 78, 2, 26, "Input"],
Cell[15019, 455, 36928, 1105, 184, 12274, 795, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[51962, 1563, 138, 4, 23, "Text"],
Cell[52103, 1569, 131, 4, 23, "Text"],
Cell[52237, 1575, 68, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[52330, 1579, 102, 2, 26, "Input"],
Cell[52435, 1583, 36889, 1103, 184, 12264, 794, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[89339, 2689, 68, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[89432, 2693, 102, 2, 26, "Input"],
Cell[89537, 2697, 37041, 1107, 184, 12282, 796, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[126593, 3807, 853, 24, 140, "DefinitionBox3Col"],
Cell[127449, 3833, 88, 4, 15, "Caption"],
Cell[127540, 3839, 957, 30, 81, "Text"],
Cell[128500, 3871, 246, 4, 50, "Text"],
Cell[128749, 3877, 1341, 52, 54, "Text"],
Cell[130093, 3931, 203, 3, 60, "DisplayMath"],
Cell[130299, 3936, 1011, 35, 81, "Text"],
Cell[131313, 3973, 10299, 278, 306, "DefinitionBox"],
Cell[141615, 4253, 75, 0, 15, "Caption"],
Cell[141693, 4255, 137, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[141855, 4263, 163, 4, 42, "Input"],
Cell[142021, 4269, 36928, 1105, 184, 12274, 795, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[178964, 5377, 2399, 80, 112, "Text"],
Cell[181366, 5459, 3654, 102, 286, "DefinitionBox3Col"],
Cell[185023, 5563, 60, 0, 15, "Caption"],
Cell[185086, 5565, 49, 0, 40, "MathCaption"],
Cell[185138, 5567, 588, 11, 138, "Input"],
Cell[185729, 5580, 111, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[185865, 5587, 77, 2, 26, "Input"],
Cell[185945, 5591, 455, 7, 121, "Output"]
}, Open  ]],
Cell[186415, 5601, 982, 29, 56, "DefinitionBox"],
Cell[187400, 5632, 58, 0, 15, "Caption"],
Cell[187461, 5634, 217, 4, 36, "Text"],
Cell[187681, 5640, 48, 0, 40, "MathCaption"],
Cell[187732, 5642, 295, 7, 42, "Input"],
Cell[188030, 5651, 53, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[188108, 5655, 192, 6, 26, "Input"],
Cell[188303, 5663, 143, 3, 25, "Output"]
}, Open  ]],
Cell[188461, 5669, 133, 4, 23, "Text"],
Cell[188597, 5675, 352, 7, 68, "DefinitionBox"],
Cell[188952, 5684, 103, 4, 15, "Caption"],
Cell[189058, 5690, 1030, 31, 99, "Text"],
Cell[190091, 5723, 239, 8, 38, "Text"],
Cell[190333, 5733, 298, 8, 44, "DefinitionBox"],
Cell[190634, 5743, 45, 0, 15, "Caption"],
Cell[190682, 5745, 971, 29, 98, "Text"],
Cell[191656, 5776, 196, 5, 37, "Text"],
Cell[191855, 5783, 929, 26, 112, "Text"],
Cell[192787, 5811, 171, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[192983, 5821, 195, 5, 42, "Input"],
Cell[193181, 5828, 36889, 1103, 184, 12264, 794, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[230085, 6934, 225, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[230335, 6944, 222, 5, 58, "Input"],
Cell[230560, 6951, 36889, 1103, 184, 12264, 794, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[267464, 8057, 152, 3, 36, "Text"],
Cell[267619, 8062, 257, 7, 44, "DefinitionBox"],
Cell[267879, 8071, 100, 4, 15, "Caption"],
Cell[267982, 8077, 565, 16, 67, "Text"],
Cell[268550, 8095, 109, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[268684, 8102, 195, 5, 42, "Input"],
Cell[268882, 8109, 36893, 1102, 184, 12256, 793, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[305790, 9214, 283, 8, 44, "DefinitionBox"],
Cell[306076, 9224, 97, 4, 15, "Caption"],
Cell[306176, 9230, 151, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[306352, 9238, 197, 5, 42, "Input"],
Cell[306552, 9245, 36881, 1102, 184, 12256, 793, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[343470, 10352, 48, 0, 34, "Subsubsection"],
Cell[343521, 10354, 612, 19, 44, "DefinitionBox",
  CellTags->"Agglomerate"],
Cell[344136, 10375, 302, 8, 15, "Caption"],
Cell[344441, 10385, 406, 12, 53, "Text"],
Cell[344850, 10399, 58, 0, 40, "MathCaption"],
Cell[344911, 10401, 743, 15, 170, "Input"],
Cell[345657, 10418, 77, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[345759, 10422, 196, 6, 26, "Input"],
Cell[345958, 10430, 1071, 19, 185, "Output"]
}, Open  ]],
Cell[347044, 10452, 49, 0, 40, "MathCaption"],
Cell[347096, 10454, 588, 11, 138, "Input"],
Cell[347687, 10467, 54, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[347766, 10471, 191, 6, 26, "Input"],
Cell[347960, 10479, 559, 9, 225, "Output"]
}, Open  ]],
Cell[348534, 10491, 48, 0, 40, "MathCaption"],
Cell[348585, 10493, 295, 7, 42, "Input"],
Cell[348883, 10502, 53, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[348961, 10506, 191, 6, 26, "Input"],
Cell[349155, 10514, 323, 7, 89, "Output"]
}, Open  ]],
Cell[349493, 10524, 1545, 46, 92, "DefinitionBox"],
Cell[351041, 10572, 55, 0, 15, "Caption"],
Cell[351099, 10574, 1466, 44, 98, "DefinitionBox"],
Cell[352568, 10620, 110, 4, 15, "Caption"],
Cell[352681, 10626, 209, 8, 38, "Text"],
Cell[352893, 10636, 74, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[352992, 10640, 77, 2, 26, "Input"],
Cell[353072, 10644, 961, 17, 121, "Output"]
}, Open  ]],
Cell[354048, 10664, 49, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[354122, 10668, 76, 2, 26, "Input"],
Cell[354201, 10672, 594, 10, 89, "Output"]
}, Open  ]],
Cell[354810, 10685, 666, 17, 120, "DefinitionBox3Col"],
Cell[355479, 10704, 43, 0, 15, "Caption"],
Cell[355525, 10706, 359, 11, 52, "Text"],
Cell[355887, 10719, 1544, 45, 218, "DefinitionBox",
  CellTags->"linkages"],
Cell[357434, 10766, 102, 4, 15, "Caption"],
Cell[357539, 10772, 403, 6, 64, "Text"],
Cell[357945, 10780, 1757, 55, 144, "Text"],
Cell[359705, 10837, 120, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[359850, 10845, 222, 6, 26, "Input"],
Cell[360075, 10853, 1052, 18, 169, "Output"]
}, Open  ]],
Cell[361142, 10874, 155, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[361322, 10882, 267, 8, 41, "Input"],
Cell[361592, 10892, 1050, 18, 169, "Output"]
}, Open  ]],
Cell[362657, 10913, 330, 6, 51, "Text"],
Cell[362990, 10921, 71, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[363086, 10925, 315, 8, 42, "Input"],
Cell[363404, 10935, 519, 10, 105, "Output"]
}, Open  ]],
Cell[363938, 10948, 1444, 41, 94, "Text"],
Cell[365385, 10991, 1896, 57, 136, "DefinitionBox"],
Cell[367284, 11050, 93, 2, 15, "Caption"],
Cell[367380, 11054, 186, 6, 37, "Text"],
Cell[367569, 11062, 58, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[367652, 11066, 199, 6, 26, "Input"],
Cell[367854, 11074, 2259, 32, 329, "Output"]
}, Open  ]],
Cell[370128, 11109, 143, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[370296, 11116, 194, 6, 26, "Input"],
Cell[370493, 11124, 500, 10, 105, "Output"]
}, Open  ]],
Cell[371008, 11137, 187, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[371220, 11146, 201, 6, 26, "Input"],
Cell[371424, 11154, 1062, 18, 185, "Output"]
}, Open  ]],
Cell[372501, 11175, 305, 5, 50, "Text"],
Cell[372809, 11182, 1094, 34, 82, "DefinitionBox"],
Cell[373906, 11218, 49, 0, 15, "Caption"],
Cell[373958, 11220, 62, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[374045, 11224, 199, 6, 26, "Input"],
Cell[374247, 11232, 29552, 439, 245, 1217, 84, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[403814, 11674, 82, 1, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[403921, 11679, 247, 7, 42, "Input"],
Cell[404171, 11688, 43608, 613, 245, 1214, 84, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[447794, 12304, 1791, 51, 298, "DefinitionBox3Col"],
Cell[449588, 12357, 84, 3, 15, "Caption"],
Cell[449675, 12362, 126, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[449826, 12369, 227, 6, 26, "Input"],
Cell[450056, 12377, 20922, 333, 245, 1210, 84, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[470993, 12713, 723, 20, 97, "Text"],
Cell[471719, 12735, 95, 2, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[471839, 12741, 264, 7, 42, "Input"],
Cell[472106, 12750, 21436, 357, 245, 2142, 114, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[493557, 13110, 74, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[493656, 13114, 356, 9, 58, "Input"],
Cell[494015, 13125, 33794, 824, 245, 14811, 584, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[527824, 13952, 74, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[527923, 13956, 264, 7, 42, "Input"],
Cell[528190, 13965, 56627, 1229, 245, 20684, 780, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[584832, 15197, 932, 19, 137, "Text"],
Cell[585767, 15218, 258, 8, 56, "MathCaption",
  CellTags->"FisherRef"],
Cell[586028, 15228, 231, 6, 26, "Input"],
Cell[586262, 15236, 51, 0, 40, "MathCaption"],
Cell[586316, 15238, 195, 6, 26, "Input"],
Cell[586514, 15246, 105, 2, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[586644, 15252, 268, 7, 42, "Input"],
Cell[586915, 15261, 50466, 1132, 245, 15068, 690, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[637396, 16396, 60, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[637481, 16400, 296, 8, 42, "Input"],
Cell[637780, 16410, 51582, 1218, 245, 16184, 776, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[689377, 17631, 93, 2, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[689495, 17637, 301, 8, 42, "Input"],
Cell[689799, 17647, 82432, 1595, 245, 16118, 771, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[772280, 19248, 32, 0, 36, "Subsection"],
Cell[772315, 19250, 230, 6, 40, "Text",
  CellTags->"KR90"],
Cell[772548, 19258, 348, 11, 38, "Text",
  CellTags->"R87"],
Cell[772899, 19271, 437, 12, 54, "Text",
  CellTags->"TWH00"],
Cell[773339, 19285, 318, 10, 40, "Reference",
  CellTags->"Fisher"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

