(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     31537,       1596]*)
(*NotebookOutlinePosition[     34489,       1689]*)
(*  CellTagsIndexPosition[     34223,       1675]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "DiscreteMath",
 StyleBox["`", "MB"],
 "CombinatorialFunctions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.17.1", "1.1"}],

Cell[TextData[{
 "This package defines the functions ",
 StyleBox["CatalanNumber", "MR"],
 StyleBox[",", "TI"],
 StyleBox[" Hofstadter", "MR"],
 ", and ",
 StyleBox["Subfactorial", "MR"],
 " that are used in combinatorial analysis. Several related functions, such \
as ",
 StyleBox["Factorial", "MR"],
 ", ",
 StyleBox["Factorial2", "MR"],
 ", ",
 StyleBox["Binomial", "MR"],
 ", ",
 StyleBox["Multinomial", "MR"],
 ", ",
 StyleBox["Pochhammer", "MR"],
 ", and ",
 StyleBox["Fibonacci", "MR"],
 " are normally available in ",
 StyleBox["Mathematica", "TI"],
 " without loading this package. "
}], "Text",
 CellTags->{"S5.17.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CatalanNumber[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" Catalan number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Hofstadter[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "Hofstadter\[CloseCurlyQuote]s function ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Subfactorial[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["subfactorial of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.17.1"],

Cell["Combinatorial functions. ", "Caption",
 CellTags->"S5.17.1"],

Cell[TextData[{
 "The ",
 StyleBox["Catalan numbers", "TB"],
 ", which appear in various tree enumeration problems, are given in terms of \
binomial coefficients according to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["c",
      "TI"], 
     StyleBox["n",
      "TI"]], "=", 
    FractionBox["1", 
     RowBox[{
      StyleBox["n",
       "TI"], "+", "1"}]], 
    RowBox[{"(", 
     FractionBox[
      RowBox[{"2", 
       StyleBox["n",
        "TI"]}], 
      StyleBox["n",
       "TI"],
      FractionLine->None], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.17.1", "1.3"}],

Cell[TextData[{
 StyleBox["Hofstadter\[CloseCurlyQuote]s function", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["q",
     "TI"], 
    RowBox[{"(", 
     StyleBox["n",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is defined recursively for positive integers by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["q",
     "TI"], 
    RowBox[{"(", "1", ")"}], "=", 
    StyleBox["q",
     "TI"], 
    RowBox[{"(", "2", ")"}], "=", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["q",
     "TI"], 
    RowBox[{"(", 
     StyleBox["n",
      "TI"], ")"}], "=", 
    StyleBox["q",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["n",
       "TI"], "-", 
      StyleBox["q",
       "TI"], 
      RowBox[{"(", 
       RowBox[{
        StyleBox["n",
         "TI"], "-", "1"}], ")"}]}], ")"}], "+", 
    StyleBox["q",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["n",
       "TI"], "-", 
      StyleBox["q",
       "TI"], 
      RowBox[{"(", 
       RowBox[{
        StyleBox["n",
         "TI"], "-", "2"}], ")"}]}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.17.1", "1.4"}],

Cell[TextData[{
 StyleBox["Subfactorial[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "!", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["k",
       "TI"], "=", "0"}], 
     StyleBox["n",
      "TI"],
     LimitsPositioning->True], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     StyleBox["k",
      "TI"]], "/", 
    StyleBox["k",
     "TI"], "!"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " . "
}], "Text",
 CellTags->{"S5.17.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.17.1", "1.6"}],

Cell["<<DiscreteMath`CombinatorialFunctions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.17.1"],

Cell["\<\
This is the number of permutations of four objects that leaves none of the \
objects unchanged. \
\>", "MathCaption",
 CellTags->{"S5.17.1", "1.7"}],

Cell[CellGroupData[{

Cell["Subfactorial[4]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.17.1"],

Cell[BoxData["9"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.17.1"]
}, Open  ]],

Cell[TextData[{
 "This plot demonstrates the chaotic behavior of \
Hofstadter\[CloseCurlyQuote]s function, described in the book ",
 StyleBox["G\[ODoubleDot]del, Escher, Bach: An Eternal Golden Braid", "TI"],
 ". "
}], "MathCaption",
 CellTags->{"S5.17.1", "1.8"}],

Cell[CellGroupData[{

Cell["ListPlot[Table[Hofstadter[n], {n, 1000}]]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.17.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.000952381 0.0147151 0.000972899 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -12 -9 ]
[.97619 .00222 12 0 ]
[.01131 .112 -18 -4.5 ]
[.01131 .112 0 4.5 ]
[.01131 .20929 -18 -4.5 ]
[.01131 .20929 0 4.5 ]
[.01131 .30658 -18 -4.5 ]
[.01131 .30658 0 4.5 ]
[.01131 .40387 -18 -4.5 ]
[.01131 .40387 0 4.5 ]
[.01131 .50116 -18 -4.5 ]
[.01131 .50116 0 4.5 ]
[.01131 .59845 -18 -4.5 ]
[.01131 .59845 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(200)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(400)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(600)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(800)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1000)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .112 m
.03006 .112 L
s
[(100)] .01131 .112 1 0 Mshowa
.02381 .20929 m
.03006 .20929 L
s
[(200)] .01131 .20929 1 0 Mshowa
.02381 .30658 m
.03006 .30658 L
s
[(300)] .01131 .30658 1 0 Mshowa
.02381 .40387 m
.03006 .40387 L
s
[(400)] .01131 .40387 1 0 Mshowa
.02381 .50116 m
.03006 .50116 L
s
[(500)] .01131 .50116 1 0 Mshowa
.02381 .59845 m
.03006 .59845 L
s
[(600)] .01131 .59845 1 0 Mshowa
.125 Mabswid
.02381 .03417 m
.02756 .03417 L
s
.02381 .05363 m
.02756 .05363 L
s
.02381 .07309 m
.02756 .07309 L
s
.02381 .09255 m
.02756 .09255 L
s
.02381 .13146 m
.02756 .13146 L
s
.02381 .15092 m
.02756 .15092 L
s
.02381 .17038 m
.02756 .17038 L
s
.02381 .18984 m
.02756 .18984 L
s
.02381 .22875 m
.02756 .22875 L
s
.02381 .24821 m
.02756 .24821 L
s
.02381 .26767 m
.02756 .26767 L
s
.02381 .28713 m
.02756 .28713 L
s
.02381 .32604 m
.02756 .32604 L
s
.02381 .3455 m
.02756 .3455 L
s
.02381 .36496 m
.02756 .36496 L
s
.02381 .38442 m
.02756 .38442 L
s
.02381 .42333 m
.02756 .42333 L
s
.02381 .44279 m
.02756 .44279 L
s
.02381 .46225 m
.02756 .46225 L
s
.02381 .48171 m
.02756 .48171 L
s
.02381 .52062 m
.02756 .52062 L
s
.02381 .54008 m
.02756 .54008 L
s
.02381 .55954 m
.02756 .55954 L
s
.02381 .579 m
.02756 .579 L
s
.02381 .61791 m
.02756 .61791 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02476 .01569 Mdot
.02571 .01569 Mdot
.02667 .01666 Mdot
.02762 .01763 Mdot
.02857 .01763 Mdot
.02952 .01861 Mdot
.03048 .01958 Mdot
.03143 .01958 Mdot
.03238 .02055 Mdot
.03333 .02055 Mdot
.03429 .02055 Mdot
.03524 .0225 Mdot
.03619 .0225 Mdot
.03714 .0225 Mdot
.0381 .02444 Mdot
.03905 .02347 Mdot
.04 .02444 Mdot
.04095 .02542 Mdot
.0419 .02542 Mdot
.04286 .02639 Mdot
.04381 .02639 Mdot
.04476 .02639 Mdot
.04571 .02639 Mdot
.04667 .03028 Mdot
.04762 .02834 Mdot
.04857 .02834 Mdot
.04952 .03028 Mdot
.05048 .03028 Mdot
.05143 .03028 Mdot
.05238 .03028 Mdot
.05333 .03417 Mdot
.05429 .03125 Mdot
.05524 .03125 Mdot
.05619 .03417 Mdot
.05714 .03515 Mdot
.0581 .0332 Mdot
.05905 .03417 Mdot
.06 .03612 Mdot
.06095 .03515 Mdot
.0619 .03612 Mdot
.06286 .03709 Mdot
.06381 .03709 Mdot
.06476 .03806 Mdot
.06571 .03806 Mdot
.06667 .03806 Mdot
.06762 .03806 Mdot
.06857 .03806 Mdot
.06952 .04585 Mdot
.07048 .03806 Mdot
.07143 .03904 Mdot
.07238 .0439 Mdot
.07333 .04196 Mdot
.07429 .04001 Mdot
.07524 .0439 Mdot
.07619 .0439 Mdot
.07714 .04196 Mdot
.0781 .04585 Mdot
.07905 .0439 Mdot
.08 .04585 Mdot
.08095 .04585 Mdot
.0819 .04585 Mdot
.08286 .04585 Mdot
.08381 .05363 Mdot
.08476 .04682 Mdot
.08571 .04487 Mdot
.08667 .05169 Mdot
.08762 .04877 Mdot
.08857 .04682 Mdot
.08952 .05266 Mdot
.09048 .05363 Mdot
.09143 .05071 Mdot
.09238 .05169 Mdot
.09333 .05363 Mdot
.09429 .05266 Mdot
.09524 .05363 Mdot
.09619 .05266 Mdot
.09714 .05558 Mdot
.0981 .05363 Mdot
.09905 .0546 Mdot
.1 .05655 Mdot
.10095 .05752 Mdot
.1019 .05655 Mdot
.10286 .05655 Mdot
.10381 .05947 Mdot
.10476 .05752 Mdot
.10571 .0585 Mdot
.10667 .06044 Mdot
.10762 .06044 Mdot
.10857 .05947 Mdot
.10952 .06141 Mdot
.11048 .06141 Mdot
.11143 .06141 Mdot
.11238 .06141 Mdot
.11333 .06141 Mdot
.11429 .06141 Mdot
.11524 .07698 Mdot
.11619 .0546 Mdot
.11714 .06531 Mdot
.1181 .06725 Mdot
.11905 .0692 Mdot
.12 .06141 Mdot
.12095 .06725 Mdot
.1219 .06725 Mdot
.12286 .06336 Mdot
.12381 .07309 Mdot
.12476 .06531 Mdot
.12571 .06725 Mdot
.12667 .07114 Mdot
.12762 .07309 Mdot
.12857 .06628 Mdot
.12952 .07309 Mdot
.13048 .07309 Mdot
.13143 .06531 Mdot
.13238 .07503 Mdot
.13333 .07893 Mdot
.13429 .06822 Mdot
.13524 .07503 Mdot
.13619 .08087 Mdot
.13714 .07503 Mdot
.1381 .07114 Mdot
.13905 .08476 Mdot
.14 .07114 Mdot
.14095 .07406 Mdot
.1419 .0906 Mdot
.14286 .07017 Mdot
.14381 .08379 Mdot
.14476 .08087 Mdot
.14571 .07698 Mdot
.14667 .07601 Mdot
.14762 .08574 Mdot
.14857 .07601 Mdot
.14952 .08379 Mdot
.15048 .08476 Mdot
.15143 .08476 Mdot
.15238 .09255 Mdot
.15333 .07406 Mdot
.15429 .08379 Mdot
.15524 .08963 Mdot
.15619 .07795 Mdot
.15714 .09255 Mdot
.1581 .08379 Mdot
.15905 .08185 Mdot
.16 .08963 Mdot
.16095 .08768 Mdot
.1619 .08574 Mdot
.16286 .08963 Mdot
.16381 .09157 Mdot
.16476 .08866 Mdot
.16571 .09255 Mdot
.16667 .09157 Mdot
.16762 .08768 Mdot
.16857 .09449 Mdot
.16952 .08963 Mdot
.17048 .09255 Mdot
.17143 .09255 Mdot
.17238 .0906 Mdot
.17333 .09547 Mdot
.17429 .09547 Mdot
.17524 .0906 Mdot
.17619 .09741 Mdot
.17714 .09449 Mdot
.1781 .09741 Mdot
.17905 .09644 Mdot
.18 .09644 Mdot
.18095 .10033 Mdot
.1819 .09547 Mdot
.18286 .09936 Mdot
.18381 .10033 Mdot
.18476 .09936 Mdot
.18571 .09838 Mdot
.18667 .10228 Mdot
.18762 .10033 Mdot
.18857 .09936 Mdot
.18952 .10422 Mdot
.19048 .10228 Mdot
.19143 .10325 Mdot
.19238 .10422 Mdot
.19333 .10422 Mdot
.19429 .10617 Mdot
.19524 .10422 Mdot
.19619 .10519 Mdot
.19714 .10617 Mdot
.1981 .10617 Mdot
.19905 .10811 Mdot
.2 .10617 Mdot
.20095 .10811 Mdot
.2019 .10811 Mdot
.20286 .10811 Mdot
.20381 .10811 Mdot
.20476 .10811 Mdot
.20571 .10811 Mdot
.20667 .13925 Mdot
.20762 .08476 Mdot
.20857 .10811 Mdot
.20952 .1266 Mdot
.21048 .112 Mdot
.21143 .09644 Mdot
.21238 .12563 Mdot
.21333 .12173 Mdot
.21429 .10519 Mdot
.21524 .11784 Mdot
.21619 .13535 Mdot
.21714 .09449 Mdot
.2181 .11298 Mdot
.21905 .12271 Mdot
.22 .11979 Mdot
.22095 .12952 Mdot
.2219 .1159 Mdot
.22286 .11979 Mdot
.22381 .11784 Mdot
.22476 .12563 Mdot
.22571 .1159 Mdot
.22667 .12563 Mdot
.22762 .12076 Mdot
.22857 .112 Mdot
.22952 .12076 Mdot
.23048 .13146 Mdot
.23143 .12368 Mdot
.23238 .11979 Mdot
.23333 .12952 Mdot
.23429 .11784 Mdot
.23524 .11687 Mdot
.23619 .14119 Mdot
.23714 .12173 Mdot
.2381 .12563 Mdot
.23905 .1266 Mdot
.24 .12368 Mdot
.24095 .11882 Mdot
.2419 .13146 Mdot
.24286 .12563 Mdot
.24381 .13341 Mdot
.24476 .13244 Mdot
.24571 .13146 Mdot
.24667 .12563 Mdot
.24762 .14898 Mdot
.24857 .12173 Mdot
.24952 .13341 Mdot
.25048 .13049 Mdot
.25143 .13146 Mdot
.25238 .14119 Mdot
.25333 .14314 Mdot
.25429 .12465 Mdot
.25524 .14411 Mdot
.25619 .13438 Mdot
.25714 .12952 Mdot
.2581 .13633 Mdot
.25905 .13244 Mdot
.26 .14022 Mdot
.26095 .13341 Mdot
.2619 .14703 Mdot
.26286 .14022 Mdot
.26381 .12757 Mdot
.26476 .15968 Mdot
.26571 .148 Mdot
.26667 .13146 Mdot
.26762 .13438 Mdot
.26857 .15384 Mdot
.26952 .15676 Mdot
.27048 .11882 Mdot
.27143 .14995 Mdot
.27238 .14898 Mdot
.27333 .14995 Mdot
.27429 .14606 Mdot
.27524 .13146 Mdot
.27619 .15676 Mdot
.27714 .14606 Mdot
.2781 .15384 Mdot
.27905 .14022 Mdot
.28 .16162 Mdot
.28095 .14411 Mdot
.2819 .14606 Mdot
.28286 .14703 Mdot
.28381 .1587 Mdot
.28476 .1587 Mdot
.28571 .14703 Mdot
.28667 .15481 Mdot
.28762 .15384 Mdot
.28857 .1626 Mdot
.28952 .14022 Mdot
.29048 .14995 Mdot
.29143 .16162 Mdot
.29238 .15092 Mdot
.29333 .1587 Mdot
.29429 .14703 Mdot
.29524 .16162 Mdot
.29619 .16941 Mdot
.29714 .13633 Mdot
.2981 .15773 Mdot
.29905 .16357 Mdot
.3 .1587 Mdot
.30095 .16454 Mdot
.3019 .1626 Mdot
.30286 .14703 Mdot
.30381 .1626 Mdot
.30476 .16551 Mdot
.30571 .15676 Mdot
.30667 .15481 Mdot
.30762 .17232 Mdot
.30857 .16162 Mdot
.30952 .16746 Mdot
.31048 .16454 Mdot
.31143 .15968 Mdot
.31238 .17038 Mdot
.31333 .16551 Mdot
.31429 .1626 Mdot
.31524 .16551 Mdot
.31619 .17232 Mdot
.31714 .16454 Mdot
.3181 .16941 Mdot
.31905 .16357 Mdot
.32 .17524 Mdot
.32095 .16746 Mdot
.3219 .16454 Mdot
.32286 .17816 Mdot
.32381 .17135 Mdot
.32476 .16649 Mdot
.32571 .17038 Mdot
.32667 .17816 Mdot
.32762 .16357 Mdot
.32857 .17913 Mdot
.32952 .18011 Mdot
.33048 .16941 Mdot
.33143 .17135 Mdot
.33238 .18205 Mdot
.33333 .17135 Mdot
.33429 .17816 Mdot
.33524 .17135 Mdot
.33619 .18205 Mdot
.33714 .18108 Mdot
.3381 .17135 Mdot
.33905 .18108 Mdot
.34 .18205 Mdot
.34095 .17719 Mdot
.3419 .18205 Mdot
.34286 .18205 Mdot
.34381 .17816 Mdot
.34476 .18497 Mdot
.34571 .18011 Mdot
.34667 .18108 Mdot
.34762 .18303 Mdot
.34857 .184 Mdot
.34952 .18497 Mdot
.35048 .18497 Mdot
.35143 .184 Mdot
.35238 .18595 Mdot
.35333 .184 Mdot
.35429 .18692 Mdot
.35524 .19178 Mdot
.35619 .18497 Mdot
.35714 .18789 Mdot
.3581 .18789 Mdot
.35905 .19373 Mdot
.36 .18692 Mdot
.36095 .18789 Mdot
.3619 .19373 Mdot
.36286 .18984 Mdot
.36381 .18886 Mdot
.36476 .19567 Mdot
.36571 .18886 Mdot
.36667 .1947 Mdot
.36762 .1947 Mdot
.36857 .19373 Mdot
.36952 .19567 Mdot
.37048 .19373 Mdot
.37143 .19665 Mdot
.37238 .19762 Mdot
.37333 .19567 Mdot
.37429 .19567 Mdot
.37524 .19762 Mdot
.37619 .19957 Mdot
.37714 .19665 Mdot
.3781 .19762 Mdot
.37905 .19957 Mdot
.38 .20151 Mdot
.38095 .19762 Mdot
.3819 .20151 Mdot
.38286 .19957 Mdot
.38381 .20151 Mdot
.38476 .20151 Mdot
.38571 .20151 Mdot
.38667 .20151 Mdot
.38762 .20151 Mdot
.38857 .20151 Mdot
.38952 .26378 Mdot
.39048 .14606 Mdot
.39143 .21124 Mdot
.39238 .21902 Mdot
.39333 .19762 Mdot
.39429 .20929 Mdot
.39524 .22875 Mdot
.39619 .19567 Mdot
.39714 .2054 Mdot
.3981 .21124 Mdot
.39905 .25016 Mdot
.4 .15968 Mdot
.40095 .21027 Mdot
.4019 .23751 Mdot
.40286 .18108 Mdot
.40381 .20248 Mdot
.40476 .24627 Mdot
.40571 .19762 Mdot
.40667 .20248 Mdot
.40762 .21513 Mdot
.40857 .23654 Mdot
.40952 .21124 Mdot
.41048 .20248 Mdot
.41143 .22875 Mdot
.41238 .2054 Mdot
.41333 .21902 Mdot
.41429 .21124 Mdot
.41524 .22292 Mdot
.41619 .22875 Mdot
.41714 .19178 Mdot
.4181 .22583 Mdot
.41905 .24237 Mdot
.42 .21319 Mdot
.42095 .21708 Mdot
.4219 .22389 Mdot
.42286 .22389 Mdot
.42381 .2307 Mdot
.42476 .22681 Mdot
.42571 .20346 Mdot
.42667 .23945 Mdot
.42762 .19567 Mdot
.42857 .22486 Mdot
.42952 .24432 Mdot
.43048 .21902 Mdot
.43143 .24821 Mdot
.43238 .21319 Mdot
.43333 .22 Mdot
.43429 .23848 Mdot
.43524 .23848 Mdot
.43619 .17427 Mdot
.43714 .24237 Mdot
.4381 .24918 Mdot
.43905 .24724 Mdot
.44 .22292 Mdot
.44095 .22875 Mdot
.4419 .2307 Mdot
.44286 .23848 Mdot
.44381 .2307 Mdot
.44476 .2307 Mdot
.44571 .22097 Mdot
.44667 .23459 Mdot
.44762 .23654 Mdot
.44857 .23848 Mdot
.44952 .23654 Mdot
.45048 .23848 Mdot
.45143 .22292 Mdot
.45238 .23654 Mdot
.45333 .25989 Mdot
.45429 .21221 Mdot
.45524 .25016 Mdot
.45619 .2414 Mdot
.45714 .22778 Mdot
.4581 .25989 Mdot
.45905 .23848 Mdot
.46 .22389 Mdot
.46095 .25113 Mdot
.4619 .24627 Mdot
.46286 .25016 Mdot
.46381 .23654 Mdot
.46476 .2521 Mdot
.46571 .23654 Mdot
.46667 .23654 Mdot
.46762 .24627 Mdot
.46857 .24821 Mdot
.46952 .22973 Mdot
.47048 .25697 Mdot
.47143 .23654 Mdot
.47238 .24627 Mdot
.47333 .24529 Mdot
.47429 .25599 Mdot
.47524 .24529 Mdot
.47619 .23945 Mdot
.47714 .24627 Mdot
.4781 .25308 Mdot
.47905 .25794 Mdot
.48 .24237 Mdot
.48095 .24724 Mdot
.4819 .24237 Mdot
.48286 .26961 Mdot
.48381 .23654 Mdot
.48476 .23654 Mdot
.48571 .29296 Mdot
.48667 .24724 Mdot
.48762 .24335 Mdot
.48857 .27837 Mdot
.48952 .25697 Mdot
.49048 .24821 Mdot
.49143 .25016 Mdot
.49238 .25989 Mdot
.49333 .26864 Mdot
.49429 .2414 Mdot
.49524 .26086 Mdot
.49619 .27545 Mdot
.49714 .25113 Mdot
.4981 .24237 Mdot
.49905 .27642 Mdot
.5 .26475 Mdot
.50095 .2521 Mdot
.5019 .27156 Mdot
.50286 .23556 Mdot
.50381 .28032 Mdot
.50476 .28032 Mdot
.50571 .24821 Mdot
.50667 .26475 Mdot
.50762 .26572 Mdot
.50857 .25308 Mdot
.50952 .26961 Mdot
.51048 .26475 Mdot
.51143 .26378 Mdot
.51238 .27351 Mdot
.51333 .28226 Mdot
.51429 .25989 Mdot
.51524 .25989 Mdot
.51619 .2988 Mdot
.51714 .25794 Mdot
.5181 .27059 Mdot
.51905 .28324 Mdot
.52 .27156 Mdot
.52095 .27837 Mdot
.5219 .23167 Mdot
.52286 .3095 Mdot
.52381 .26183 Mdot
.52476 .27351 Mdot
.52571 .29296 Mdot
.52667 .25989 Mdot
.52762 .28324 Mdot
.52857 .29588 Mdot
.52952 .2414 Mdot
.53048 .29102 Mdot
.53143 .28615 Mdot
.53238 .26378 Mdot
.53333 .25989 Mdot
.53429 .28226 Mdot
.53524 .29686 Mdot
.53619 .27156 Mdot
.53714 .26572 Mdot
.5381 .29102 Mdot
.53905 .29783 Mdot
.54 .28226 Mdot
.54095 .25308 Mdot
.5419 .30853 Mdot
.54286 .29686 Mdot
.54381 .25405 Mdot
.54476 .30367 Mdot
.54571 .28518 Mdot
.54667 .25891 Mdot
.54762 .29394 Mdot
.54857 .28421 Mdot
.54952 .28907 Mdot
.55048 .28615 Mdot
.55143 .27934 Mdot
.55238 .2988 Mdot
.55333 .26378 Mdot
.55429 .30658 Mdot
.55524 .30172 Mdot
.55619 .23556 Mdot
.55714 .31923 Mdot
.5581 .30756 Mdot
.55905 .26767 Mdot
.56 .30561 Mdot
.56095 .30756 Mdot
.5619 .2628 Mdot
.56286 .31729 Mdot
.56381 .28713 Mdot
.56476 .29686 Mdot
.56571 .28907 Mdot
.56667 .29296 Mdot
.56762 .31048 Mdot
.56857 .29491 Mdot
.56952 .30853 Mdot
.57048 .30172 Mdot
.57143 .29394 Mdot
.57238 .31048 Mdot
.57333 .30269 Mdot
.57429 .29491 Mdot
.57524 .30853 Mdot
.57619 .31048 Mdot
.57714 .27934 Mdot
.5781 .31145 Mdot
.57905 .32312 Mdot
.58 .27934 Mdot
.58095 .29005 Mdot
.5819 .33383 Mdot
.58286 .26961 Mdot
.58381 .3134 Mdot
.58476 .30756 Mdot
.58571 .30756 Mdot
.58667 .30269 Mdot
.58762 .30658 Mdot
.58857 .28713 Mdot
.58952 .32604 Mdot
.59048 .30367 Mdot
.59143 .30172 Mdot
.59238 .31242 Mdot
.59333 .31826 Mdot
.59429 .26864 Mdot
.59524 .3241 Mdot
.59619 .32702 Mdot
.59714 .29394 Mdot
.5981 .30269 Mdot
.59905 .32021 Mdot
.6 .31923 Mdot
.60095 .29491 Mdot
.6019 .31145 Mdot
.60286 .3348 Mdot
.60381 .30075 Mdot
.60476 .3134 Mdot
.60571 .32118 Mdot
.60667 .30269 Mdot
.60762 .32799 Mdot
.60857 .32604 Mdot
.60952 .29783 Mdot
.61048 .3134 Mdot
.61143 .32702 Mdot
.61238 .31534 Mdot
.61333 .32118 Mdot
.61429 .32312 Mdot
.61524 .31631 Mdot
.61619 .31534 Mdot
.61714 .32799 Mdot
.6181 .31631 Mdot
.61905 .32702 Mdot
.62 .31437 Mdot
.62095 .31437 Mdot
.6219 .34355 Mdot
.62286 .32993 Mdot
.62381 .3134 Mdot
.62476 .33966 Mdot
.62571 .32896 Mdot
.62667 .31048 Mdot
.62762 .33188 Mdot
.62857 .33577 Mdot
.62952 .31437 Mdot
.63048 .33869 Mdot
.63143 .31923 Mdot
.63238 .32896 Mdot
.63333 .32702 Mdot
.63429 .34258 Mdot
.63524 .32799 Mdot
.63619 .33091 Mdot
.63714 .31826 Mdot
.6381 .34161 Mdot
.63905 .33091 Mdot
.64 .32993 Mdot
.64095 .33869 Mdot
.6419 .32312 Mdot
.64286 .33285 Mdot
.64381 .34939 Mdot
.64476 .32118 Mdot
.64571 .3348 Mdot
.64667 .33772 Mdot
.64762 .3348 Mdot
.64857 .33869 Mdot
.64952 .34939 Mdot
.65048 .3348 Mdot
.65143 .32799 Mdot
.65238 .34647 Mdot
.65333 .3455 Mdot
.65429 .3348 Mdot
.65524 .33869 Mdot
.65619 .34842 Mdot
.65714 .33674 Mdot
.6581 .33869 Mdot
.65905 .3455 Mdot
.66 .34939 Mdot
.66095 .33772 Mdot
.6619 .34355 Mdot
.66286 .34355 Mdot
.66381 .34939 Mdot
.66476 .34842 Mdot
.66571 .33772 Mdot
.66667 .35231 Mdot
.66762 .35037 Mdot
.66857 .33869 Mdot
.66952 .34842 Mdot
.67048 .34745 Mdot
.67143 .35037 Mdot
.67238 .34453 Mdot
.67333 .35523 Mdot
.67429 .34647 Mdot
.67524 .35231 Mdot
.67619 .34939 Mdot
.67714 .35134 Mdot
.6781 .35426 Mdot
.67905 .35134 Mdot
.68 .35328 Mdot
.68095 .35426 Mdot
.6819 .35523 Mdot
.68286 .35523 Mdot
.68381 .35523 Mdot
.68476 .35328 Mdot
.68571 .35815 Mdot
.68667 .36204 Mdot
.68762 .35231 Mdot
.68857 .35718 Mdot
.68952 .36593 Mdot
.69048 .35815 Mdot
.69143 .36009 Mdot
.69238 .35718 Mdot
.69333 .36496 Mdot
.69429 .36301 Mdot
.69524 .35815 Mdot
.69619 .36399 Mdot
.69714 .36496 Mdot
.6981 .36204 Mdot
.69905 .36399 Mdot
.7 .36009 Mdot
.70095 .36885 Mdot
.7019 .36593 Mdot
.70286 .36399 Mdot
.70381 .36593 Mdot
.70476 .36301 Mdot
.70571 .37469 Mdot
.70667 .36107 Mdot
.70762 .3708 Mdot
.70857 .36788 Mdot
.70952 .36204 Mdot
.71048 .37469 Mdot
.71143 .37566 Mdot
.71238 .36593 Mdot
.71333 .36788 Mdot
.71429 .37274 Mdot
.71524 .37663 Mdot
.71619 .36788 Mdot
.71714 .37177 Mdot
.7181 .37663 Mdot
.71905 .37663 Mdot
.72 .36301 Mdot
.72095 .3815 Mdot
.7219 .37274 Mdot
.72286 .37177 Mdot
.72381 .37663 Mdot
.72476 .37663 Mdot
.72571 .37858 Mdot
.72667 .37663 Mdot
.72762 .37761 Mdot
.72857 .37663 Mdot
.72952 .37858 Mdot
.73048 .38053 Mdot
.73143 .37858 Mdot
.73238 .38053 Mdot
.73333 .37955 Mdot
.73429 .3815 Mdot
.73524 .38247 Mdot
.73619 .3815 Mdot
.73714 .37955 Mdot
.7381 .38247 Mdot
.73905 .38636 Mdot
.74 .38636 Mdot
.74095 .37858 Mdot
.7419 .38442 Mdot
.74286 .38442 Mdot
.74381 .38831 Mdot
.74476 .38442 Mdot
.74571 .38831 Mdot
.74667 .38442 Mdot
.74762 .38831 Mdot
.74857 .38636 Mdot
.74952 .38831 Mdot
.75048 .38831 Mdot
.75143 .38831 Mdot
.75238 .38831 Mdot
.75333 .38831 Mdot
.75429 .38831 Mdot
.75524 .51284 Mdot
.75619 .28518 Mdot
.75714 .40193 Mdot
.7581 .45349 Mdot
.75905 .3669 Mdot
.76 .37761 Mdot
.76095 .41166 Mdot
.7619 .38344 Mdot
.76286 .41847 Mdot
.76381 .36009 Mdot
.76476 .42041 Mdot
.76571 .37469 Mdot
.76667 .3922 Mdot
.76762 .41944 Mdot
.76857 .43306 Mdot
.76952 .36788 Mdot
.77048 .39998 Mdot
.77143 .39804 Mdot
.77238 .41944 Mdot
.77333 .39317 Mdot
.77429 .38539 Mdot
.77524 .43695 Mdot
.77619 .39415 Mdot
.77714 .37177 Mdot
.7781 .41263 Mdot
.77905 .49338 Mdot
.78 .29102 Mdot
.78095 .42041 Mdot
.7819 .45057 Mdot
.78286 .37177 Mdot
.78381 .41166 Mdot
.78476 .41944 Mdot
.78571 .45447 Mdot
.78667 .31631 Mdot
.78762 .43306 Mdot
.78857 .45349 Mdot
.78952 .37371 Mdot
.79048 .42041 Mdot
.79143 .4175 Mdot
.79238 .42528 Mdot
.79333 .44668 Mdot
.79429 .40096 Mdot
.79524 .37469 Mdot
.79619 .44182 Mdot
.79714 .41555 Mdot
.7981 .38442 Mdot
.79905 .43014 Mdot
.8 .43209 Mdot
.80095 .4136 Mdot
.8019 .41166 Mdot
.80286 .40193 Mdot
.80381 .43501 Mdot
.80476 .38636 Mdot
.80571 .42528 Mdot
.80667 .47003 Mdot
.80762 .37663 Mdot
.80857 .38734 Mdot
.80952 .46614 Mdot
.81048 .39998 Mdot
.81143 .41944 Mdot
.81238 .45252 Mdot
.81333 .37858 Mdot
.81429 .44668 Mdot
.81524 .44279 Mdot
.81619 .38831 Mdot
.81714 .41944 Mdot
.8181 .44571 Mdot
.81905 .41458 Mdot
.82 .42139 Mdot
.82095 .45349 Mdot
.8219 .43501 Mdot
.82286 .41166 Mdot
.82381 .42917 Mdot
.82476 .40193 Mdot
.82571 .43306 Mdot
.82667 .4136 Mdot
.82762 .45349 Mdot
.82857 .48463 Mdot
.82952 .34064 Mdot
.83048 .44279 Mdot
.83143 .46419 Mdot
.83238 .42333 Mdot
.83333 .4029 Mdot
.83429 .43598 Mdot
.83524 .45933 Mdot
.83619 .42625 Mdot
.83714 .46128 Mdot
.8381 .43403 Mdot
.83905 .44766 Mdot
.84 .45836 Mdot
.84095 .37955 Mdot
.8419 .43695 Mdot
.84286 .52257 Mdot
.84381 .38539 Mdot
.84476 .41068 Mdot
.84571 .51479 Mdot
.84667 .41166 Mdot
.84762 .41166 Mdot
.84857 .43306 Mdot
.84952 .45933 Mdot
.85048 .43695 Mdot
.85143 .46322 Mdot
.85238 .45155 Mdot
.85333 .39998 Mdot
.85429 .471 Mdot
.85524 .4749 Mdot
.85619 .39415 Mdot
.85714 .48073 Mdot
.8581 .47003 Mdot
.85905 .38539 Mdot
.86 .44766 Mdot
.86095 .47003 Mdot
.8619 .46322 Mdot
.86286 .40777 Mdot
.86381 .47003 Mdot
.86476 .47003 Mdot
.86571 .41166 Mdot
.86667 .45544 Mdot
.86762 .4175 Mdot
.86857 .48365 Mdot
.86952 .43306 Mdot
.87048 .46517 Mdot
.87143 .45057 Mdot
.87238 .45447 Mdot
.87333 .45836 Mdot
.87429 .4389 Mdot
.87524 .43793 Mdot
.87619 .48268 Mdot
.87714 .47781 Mdot
.8781 .42528 Mdot
.87905 .43501 Mdot
.88 .48657 Mdot
.88095 .45738 Mdot
.8819 .43695 Mdot
.88286 .45155 Mdot
.88381 .48365 Mdot
.88476 .41652 Mdot
.88571 .48463 Mdot
.88667 .49338 Mdot
.88762 .42333 Mdot
.88857 .47684 Mdot
.88952 .48463 Mdot
.89048 .45349 Mdot
.89143 .47976 Mdot
.89238 .47781 Mdot
.89333 .45738 Mdot
.89429 .46517 Mdot
.89524 .44376 Mdot
.89619 .4749 Mdot
.89714 .46614 Mdot
.8981 .46322 Mdot
.89905 .43695 Mdot
.9 .48365 Mdot
.90095 .45933 Mdot
.9019 .4603 Mdot
.90286 .46809 Mdot
.90381 .45544 Mdot
.90476 .48171 Mdot
.90571 .47976 Mdot
.90667 .44474 Mdot
.90762 .46906 Mdot
.90857 .46517 Mdot
.90952 .4856 Mdot
.91048 .45155 Mdot
.91143 .4603 Mdot
.91238 .46128 Mdot
.91333 .471 Mdot
.91429 .47781 Mdot
.91524 .47976 Mdot
.91619 .48657 Mdot
.91714 .48171 Mdot
.9181 .47781 Mdot
.91905 .46809 Mdot
.92 .46128 Mdot
.92095 .46809 Mdot
.9219 .4749 Mdot
.92286 .48949 Mdot
.92381 .46906 Mdot
.92476 .45155 Mdot
.92571 .4749 Mdot
.92667 .50116 Mdot
.92762 .45447 Mdot
.92857 .46419 Mdot
.92952 .51868 Mdot
.93048 .47587 Mdot
.93143 .47684 Mdot
.93238 .4749 Mdot
.93333 .50214 Mdot
.93429 .4496 Mdot
.93524 .51479 Mdot
.93619 .48463 Mdot
.93714 .46809 Mdot
.9381 .47976 Mdot
.93905 .48268 Mdot
.94 .46419 Mdot
.94095 .507 Mdot
.9419 .48073 Mdot
.94286 .48365 Mdot
.94381 .46517 Mdot
.94476 .55857 Mdot
.94571 .48463 Mdot
.94667 .44376 Mdot
.94762 .51187 Mdot
.94857 .52743 Mdot
.94952 .47198 Mdot
.95048 .45933 Mdot
.95143 .5644 Mdot
.95238 .45447 Mdot
.95333 .5177 Mdot
.95429 .49338 Mdot
.95524 .48268 Mdot
.95619 .471 Mdot
.95714 .52646 Mdot
.9581 .47684 Mdot
.95905 .50992 Mdot
.96 .4963 Mdot
.96095 .48171 Mdot
.9619 .51381 Mdot
.96286 .48949 Mdot
.96381 .507 Mdot
.96476 .51965 Mdot
.96571 .45836 Mdot
.96667 .49533 Mdot
.96762 .4963 Mdot
.96857 .47879 Mdot
.96952 .48754 Mdot
.97048 .54981 Mdot
.97143 .4749 Mdot
.97238 .45544 Mdot
.97333 .60332 Mdot
.97429 .49338 Mdot
.97524 .50019 Mdot
.97619 .50311 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.17.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.17.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.17.1"->{
    Cell[1776, 53, 151, 6, 36, "Subsection",
      CellTags->{"S5.17.1", "1.1"}],
    Cell[1930, 61, 635, 24, 72, "Text",
      CellTags->{"S5.17.1", "1.2"}],
    Cell[2568, 87, 3017, 94, 88, "DefinitionBox",
      CellTags->"S5.17.1"],
    Cell[5588, 183, 66, 1, 15, "Caption",
      CellTags->"S5.17.1"],
    Cell[5657, 186, 685, 28, 44, "Text",
      CellTags->{"S5.17.1", "1.3"}],
    Cell[6345, 216, 1366, 60, 40, "Text",
      CellTags->{"S5.17.1", "1.4"}],
    Cell[7714, 278, 625, 27, 24, "Text",
      CellTags->{"S5.17.1", "1.5"}],
    Cell[8342, 307, 78, 1, 40, "MathCaption",
      CellTags->{"S5.17.1", "1.6"}],
    Cell[8423, 310, 101, 2, 28, "Input",
      CellTags->"S5.17.1"],
    Cell[8527, 314, 158, 4, 40, "MathCaption",
      CellTags->{"S5.17.1", "1.7"}],
    Cell[8710, 322, 78, 2, 28, "Input",
      CellTags->"S5.17.1"],
    Cell[8791, 326, 74, 2, 25, "Output",
      CellTags->"S5.17.1"],
    Cell[8880, 331, 264, 6, 56, "MathCaption",
      CellTags->{"S5.17.1", "1.8"}],
    Cell[9169, 341, 104, 2, 27, "Input",
      CellTags->"S5.17.1"],
    Cell[9276, 345, 22050, 1239, 186, 21979, 1236, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.17.1"],
    Cell[31329, 1586, 180, 6, 70, "Output",
      CellTags->"S5.17.1"]},
  "1.1"->{
    Cell[1776, 53, 151, 6, 36, "Subsection",
      CellTags->{"S5.17.1", "1.1"}]},
  "1.2"->{
    Cell[1930, 61, 635, 24, 72, "Text",
      CellTags->{"S5.17.1", "1.2"}]},
  "1.3"->{
    Cell[5657, 186, 685, 28, 44, "Text",
      CellTags->{"S5.17.1", "1.3"}]},
  "1.4"->{
    Cell[6345, 216, 1366, 60, 40, "Text",
      CellTags->{"S5.17.1", "1.4"}]},
  "1.5"->{
    Cell[7714, 278, 625, 27, 24, "Text",
      CellTags->{"S5.17.1", "1.5"}]},
  "1.6"->{
    Cell[8342, 307, 78, 1, 40, "MathCaption",
      CellTags->{"S5.17.1", "1.6"}]},
  "1.7"->{
    Cell[8527, 314, 158, 4, 40, "MathCaption",
      CellTags->{"S5.17.1", "1.7"}]},
  "1.8"->{
    Cell[8880, 331, 264, 6, 56, "MathCaption",
      CellTags->{"S5.17.1", "1.8"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.17.1", 32160, 1612},
  {"1.1", 33468, 1647},
  {"1.2", 33562, 1650},
  {"1.3", 33651, 1653},
  {"1.4", 33741, 1656},
  {"1.5", 33832, 1659},
  {"1.6", 33922, 1662},
  {"1.7", 34017, 1665},
  {"1.8", 34113, 1668}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 151, 6, 36, "Subsection",
  CellTags->{"S5.17.1", "1.1"}],
Cell[1930, 61, 635, 24, 72, "Text",
  CellTags->{"S5.17.1", "1.2"}],
Cell[2568, 87, 3017, 94, 88, "DefinitionBox",
  CellTags->"S5.17.1"],
Cell[5588, 183, 66, 1, 15, "Caption",
  CellTags->"S5.17.1"],
Cell[5657, 186, 685, 28, 44, "Text",
  CellTags->{"S5.17.1", "1.3"}],
Cell[6345, 216, 1366, 60, 40, "Text",
  CellTags->{"S5.17.1", "1.4"}],
Cell[7714, 278, 625, 27, 24, "Text",
  CellTags->{"S5.17.1", "1.5"}],
Cell[8342, 307, 78, 1, 40, "MathCaption",
  CellTags->{"S5.17.1", "1.6"}],
Cell[8423, 310, 101, 2, 28, "Input",
  CellTags->"S5.17.1"],
Cell[8527, 314, 158, 4, 40, "MathCaption",
  CellTags->{"S5.17.1", "1.7"}],

Cell[CellGroupData[{
Cell[8710, 322, 78, 2, 28, "Input",
  CellTags->"S5.17.1"],
Cell[8791, 326, 74, 2, 25, "Output",
  CellTags->"S5.17.1"]
}, Open  ]],
Cell[8880, 331, 264, 6, 56, "MathCaption",
  CellTags->{"S5.17.1", "1.8"}],

Cell[CellGroupData[{
Cell[9169, 341, 104, 2, 27, "Input",
  CellTags->"S5.17.1"],
Cell[9276, 345, 22050, 1239, 186, 21979, 1236, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.17.1"],
Cell[31329, 1586, 180, 6, 70, "Output",
  CellTags->"S5.17.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

