(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    283745,      13131]*)
(*NotebookOutlinePosition[    320664,      14155]*)
(*  CellTagsIndexPosition[    318167,      14059]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "DiscreteMath",
 StyleBox["`", "MB"],
 "Combinatorica",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.18.1", "1.1"}],

Cell[TextData[{
 StyleBox["DiscreteMath`Combinatorica`", "MR"],
 " extends ",
 StyleBox["Mathematica", "TI"],
 " by over 450 functions in combinatorics and graph theory. It includes \
functions for constructing graphs and other combinatorial objects, computing \
invariants of these objects, and finally displaying them. This documentation \
covers only a subset of these functions. The best guide to this package is \
the book ",
 StyleBox["Computational Discrete Mathematics: Combinatorics and Graph Theory \
with Mathematica", "TI"],
 ", by Steven Skiena and Sriram Pemmaraju, published by Cambridge University \
Press, 2003. The new ",
 StyleBox["Combinatorica", "TI"],
 " is a substantial rewrite of the original 1990 version. It is now much \
faster than before, and provides improved graphics and significant additional \
functionality. "
}], "Text",
 CellTags->{"S5.18.1", "1.2"}],

Cell[TextData[{
 "We encourage you to visit our website, www.combinatorica.com, where you \
will find the latest release of the package, an editor for ",
 StyleBox["Combinatorica", "TI"],
 " graphs, and additional files of interest. "
}], "Text",
 CellTags->{"S5.18.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.18.1", "1.4"}],

Cell["<<DiscreteMath`Combinatorica`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.18.1"],

Cell[CellGroupData[{

Cell["Permutations and Combinations", "Subsubsection",
 CellTags->{"S5.18.1", "1.5"}],

Cell[TextData[{
 "Permutations and subsets are the most basic combinatorial objects. ",
 StyleBox["DiscreteMath`Combinatorica`", "MR"],
 " provides functions for constructing objects both randomly and \
deterministically, to rank and unrank them, and to compute invariants on \
them. Here we provide examples of some of these functions in action. "
}], "Text",
 CellTags->{"S5.18.1", "1.6"}],

Cell[TextData[{
 "These permutations are generated in minimum change order, where successive \
permutations differ by exactly one transposition. The built\[Hyphen]in \
generator ",
 StyleBox["Permutations", "MR"],
 " constructs permutations in lexicographic order. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.7"}],

Cell[CellGroupData[{

Cell["MinimumChangePermutations[{a,b,c}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b", ",", "a"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The ranking function illustrates that the built\[Hyphen]in function ",
 StyleBox["Permutations", "MR"],
 " uses lexicographic sequencing. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.8"}],

Cell[CellGroupData[{

Cell["Map[RankPermutation, Permutations[{1,2,3,4}]]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
   ",", "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", 
   ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", "20", ",", 
   "21", ",", "22", ",", "23"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", "!"}], ")"}], "=", "6"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distinct permutations of three elements, within 20 random permutations we \
are likely to see all of them. Observe that it is unlikely for the first six \
permutations to all be distinct. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.9"}],

Cell[CellGroupData[{

Cell["Table[RandomPermutation[3], {20}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A fixed point of a permutation ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is an element in the same position in ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " as in the inverse of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Thus, the only fixed point in this permutation is 7. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.10"}],

Cell[CellGroupData[{

Cell["InversePermutation[{4,8,5,2,1,3,7,6}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5", ",", "4", ",", "6", ",", "1", ",", "3", ",", "8", ",", "7", ",", "2"}],
   "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The identity permutation consists of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " singleton cycles or fixed points. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.11"}],

Cell[CellGroupData[{

Cell["ToCycles[{1,2,3,4,5,6,7,8,9,10}]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", "9", "}"}], ",", 
   RowBox[{"{", "10", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The classic problem in Polya theory is counting how many different ways \
necklaces can be made out of ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " beads, when there are ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " different types or colors of beads to choose from. When two necklaces are \
considered the same if they can be obtained only by shifting the beads (as \
opposed to turning the necklace over), the symmetries are defined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " permutations, each of which is a cyclic shift of the identity permutation. \
When a variable is specified for the number of colors, a polynomial results. \
"
}], "MathCaption",
 CellTags->{"S5.18.1", "1.12"}],

Cell[CellGroupData[{

Cell["NecklacePolynomial[8,m,Cyclic]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{
  FractionBox["m", "2"], "+", 
  FractionBox[
   SuperscriptBox["m", "2"], "4"], "+", 
  FractionBox[
   SuperscriptBox["m", "4"], "8"], "+", 
  FractionBox[
   SuperscriptBox["m", "8"], "8"]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The number of inversions in a permutation is equal to that of its inverse. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
(p=RandomPermutation[50]; {Inversions[p], Inversions[InversePermutation[p]]})\
\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"642", ",", "642"}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Generating subsets incrementally is efficient when the goal is to find the \
first subset with a given property, since every subset need not be \
constructed. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.14"}],

Cell[CellGroupData[{

Cell["Table[UnrankSubset[n,{a,b,c,d}], {n,0,15}]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "d", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", "a", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "In a Gray code, each subset differs in exactly one element from its \
neighbors. Observe that the last eight subsets all contain ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", while none of the first eight do. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.15"}],

Cell[CellGroupData[{

Cell["GrayCodeSubsets[{1,2,3,4}]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]subset is a subset with exactly ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " elements in it. Since the lead element is placed in first, the ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]subsets are given in lexicographic order. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.16"}],

Cell[CellGroupData[{

Cell["KSubsets[{1,2,3,4,5},3]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["BinarySearch",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DerangementQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Derangements",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DistinctPermutations",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["EncroachingListSet",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FromCycles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FromInversionVector",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HeapSort",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Heapify",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HideCycles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["IdentityPermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Index",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["InversePermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["InversionPoset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Inversions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["InvolutionQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Involutions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Josephus",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LexicographicPermutations",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "LongestIncreasingSubsequence",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MinimumChangePermutations",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NextPermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PermutationQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PermutationType",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PermutationWithCycle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Permute",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RandomHeap",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RandomPermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RankPermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RevealCycles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Runs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SelectionSort",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SignaturePermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ToCycles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ToInversionVector",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UnrankPermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for permutations."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["BinarySubsets",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DeBruijnSequence",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GrayCodeKSubsets",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GrayCodeSubsets",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GrayGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["KSubsets",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LexicographicSubsets",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NextBinarySubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NextGrayCodeSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NextKSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NextLexicographicSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NextSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NthSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RandomKSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RandomSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RankBinarySubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RankGrayCodeSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RankKSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RankSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Strings",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Subsets",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UnrankBinarySubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["UnrankGrayCodeSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UnrankKSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["UnrankSubset",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for subsets."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AlternatingGroup",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AlternatingGroupIndex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CycleIndex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CycleStructure",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cycles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Cyclic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CyclicGroup",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CyclicGroupIndex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Dihedral",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DihedralGroup",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DihedralGroupIndex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EquivalenceClasses",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["KSubsetGroup",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["KSubsetGroupIndex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ListNecklaces",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MultiplicationTable",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NecklacePolynomial",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["OrbitInventory",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["OrbitRepresentatives",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Orbits",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ordered",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PairGroup",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PairGroupIndex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PermutationGroupQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SamenessRelation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SymmetricGroup",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SymmetricGroupIndex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for group theory."
}], "Caption",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partitions, Compositions, and Young Tableaux", "Subsubsection",
  CellTags->{"S5.18.1", "1.17"}],

Cell[TextData[{
 "A partition of a positive integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a set of ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " strictly positive integers whose sum is ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". A composition of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a particular arrangement of nonnegative integers whose sum is ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". A set partition of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " elements is a grouping of all the elements into nonempty, nonintersecting \
subsets. A Young tableau is a structure of integers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", ",", "\[Ellipsis]", ",", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where the number of elements in each row is defined by an integer \
partition of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Further, the elements of each row and column are in increasing order, and \
the rows are left justified. These four related combinatorial objects have a \
host of interesting applications and properties. "
}], "Text",
 CellTags->{"S5.18.1", "1.18"}],

Cell["\<\
Here are the eleven partitions of 6. Observe that they are given in reverse \
lexicographic order. \
\>", "MathCaption",
  CellTags->{"S5.18.1", "1.19"}],

Cell[CellGroupData[{

Cell["ReverseLexicographicPartitions[6]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
  "Although the number of partitions grows exponentially, it does so more \
slowly than permutations or subsets, so complete tables can be generated for \
larger values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  ". "
}], "MathCaption",
  CellTags->{"S5.18.1", "1.20"}],

Cell[CellGroupData[{

Cell["Length[ReverseLexicographicPartitions[20]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S5.18.1"],

Cell[BoxData["627"], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Ferrers diagrams represent partitions as patterns of dots. They provide a \
useful tool for visualizing partitions, because moving the dots around \
provides a mechanism for proving bijections between classes of partitions. \
Here we construct a random partition of 100.\
\>", "MathCaption",
  CellTags->{"S5.18.1", "1.21"}],

Cell[CellGroupData[{

Cell["FerrersDiagram[RandomPartition[100]]", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0128205 0.03663 -0.00691244 0.030722 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.01852 w
.02381 .02381 Mdot
.02381 .05453 Mdot
.02381 .08525 Mdot
.02381 .11598 Mdot
.02381 .1467 Mdot
.02381 .17742 Mdot
.02381 .20814 Mdot
.02381 .23886 Mdot
.02381 .26959 Mdot
.02381 .30031 Mdot
.02381 .33103 Mdot
.02381 .36175 Mdot
.02381 .39247 Mdot
.02381 .4232 Mdot
.02381 .45392 Mdot
.02381 .48464 Mdot
.02381 .51536 Mdot
.02381 .54608 Mdot
.02381 .5768 Mdot
.06044 .5768 Mdot
.02381 .60753 Mdot
.06044 .60753 Mdot
.02381 .63825 Mdot
.06044 .63825 Mdot
.02381 .66897 Mdot
.06044 .66897 Mdot
.02381 .69969 Mdot
.06044 .69969 Mdot
.02381 .73041 Mdot
.06044 .73041 Mdot
.02381 .76114 Mdot
.06044 .76114 Mdot
.02381 .79186 Mdot
.06044 .79186 Mdot
.09707 .79186 Mdot
.02381 .82258 Mdot
.06044 .82258 Mdot
.09707 .82258 Mdot
.1337 .82258 Mdot
.02381 .8533 Mdot
.06044 .8533 Mdot
.09707 .8533 Mdot
.1337 .8533 Mdot
.17033 .8533 Mdot
.02381 .88402 Mdot
.06044 .88402 Mdot
.09707 .88402 Mdot
.1337 .88402 Mdot
.17033 .88402 Mdot
.20696 .88402 Mdot
.24359 .88402 Mdot
.28022 .88402 Mdot
.02381 .91475 Mdot
.06044 .91475 Mdot
.09707 .91475 Mdot
.1337 .91475 Mdot
.17033 .91475 Mdot
.20696 .91475 Mdot
.24359 .91475 Mdot
.28022 .91475 Mdot
.31685 .91475 Mdot
.35348 .91475 Mdot
.02381 .94547 Mdot
.06044 .94547 Mdot
.09707 .94547 Mdot
.1337 .94547 Mdot
.17033 .94547 Mdot
.20696 .94547 Mdot
.24359 .94547 Mdot
.28022 .94547 Mdot
.31685 .94547 Mdot
.35348 .94547 Mdot
.39011 .94547 Mdot
.02381 .97619 Mdot
.06044 .97619 Mdot
.09707 .97619 Mdot
.1337 .97619 Mdot
.17033 .97619 Mdot
.20696 .97619 Mdot
.24359 .97619 Mdot
.28022 .97619 Mdot
.31685 .97619 Mdot
.35348 .97619 Mdot
.39011 .97619 Mdot
.42674 .97619 Mdot
.46337 .97619 Mdot
.5 .97619 Mdot
.53663 .97619 Mdot
.57326 .97619 Mdot
.60989 .97619 Mdot
.64652 .97619 Mdot
.68315 .97619 Mdot
.71978 .97619 Mdot
.75641 .97619 Mdot
.79304 .97619 Mdot
.82967 .97619 Mdot
.8663 .97619 Mdot
.90293 .97619 Mdot
.93956 .97619 Mdot
.97619 .97619 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03oool00`000000oooo0?oo
o`3Y0?ooo`00?`3oool300000>X0oooo00100?ooo`030000003oool0oooo0>T0oooo003o0?ooobd0
oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo0>T0oooo000o0?ooo`<00000jP3oool0
0400oooo00<000000?ooo`3oool0j@3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3o
ool00400oooo00<000000?ooo`3oool0j@3oool003l0oooo0`00003Z0?ooo`00@03oool00`000000
oooo0?ooo`3Y0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03oool00`000000oooo0?ooo`3Y
0?ooo`00?`3oool300000>X0oooo00100?ooo`030000003oool0oooo0>T0oooo003o0?ooobd0oooo
003o0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo0>T0oooo000o0?ooo`<0
0000jP3oool00400oooo00<000000?ooo`3oool0j@3oool00?l0oooo;@3oool00?l0oooo;@3oool0
0400oooo00<000000?ooo`3oool0j@3oool003l0oooo0`00003Z0?ooo`00@03oool00`000000oooo
0?ooo`3Y0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03oool00`000000
oooo0?ooo`3Y0?ooo`00?`3oool300000>X0oooo00100?ooo`030000003oool0oooo0>T0oooo003o
0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo0>T0oooo000o0?ooo`<00000
jP3oool00400oooo00<000000?ooo`3oool0j@3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0
oooo;@3oool00400oooo00<000000?ooo`3oool0j@3oool003l0oooo0`00003Z0?ooo`00@03oool0
0`000000oooo0?ooo`3Y0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03oool00`000000oooo
0?ooo`3Y0?ooo`00?`3oool300000>X0oooo00100?ooo`030000003oool0oooo0>T0oooo003o0?oo
obd0oooo003o0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo0>T0oooo000o
0?ooo`<00000jP3oool00400oooo00<000000?ooo`3oool0j@3oool00?l0oooo;@3oool00?l0oooo
;@3oool00400oooo00<000000?ooo`3oool0j@3oool003l0oooo0`00003Z0?ooo`00@03oool00`00
0000oooo0?ooo`3Y0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03oool0
0`000000oooo0?ooo`3Y0?ooo`00?`3oool300000>X0oooo00100?ooo`030000003oool0oooo0>T0
oooo003o0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo0>T0oooo000o0?oo
o`<00000jP3oool00400oooo00<000000?ooo`3oool0j@3oool00?l0oooo;@3oool00?l0oooo;@3o
ool00?l0oooo;@3oool00400oooo00<000000?ooo`3oool0j@3oool003l0oooo0`00003Z0?ooo`00
@03oool00`000000oooo0?ooo`3Y0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03oool00`00
0000oooo0?ooo`3Y0?ooo`00?`3oool300000>X0oooo00100?ooo`030000003oool0oooo0>T0oooo
003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo0>T0
oooo000o0?ooo`<00000jP3oool00400oooo00<000000?ooo`3oool0j@3oool00?l0oooo;@3oool0
0?l0oooo;@3oool00400oooo00<000000?ooo`3oool0j@3oool003l0oooo0`00003Z0?ooo`00@03o
ool00`000000oooo0?ooo`3Y0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00
@03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0><0oooo000o0?ooo`<000000`3o
ool300000>@0oooo00100?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0h`3oool0
0?l0oooo;@3oool00?l0oooo;@3oool00400oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`3S0?ooo`00?`3oool3000000<0oooo0`00003T0?ooo`00@03oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0><0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo
00100?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0h`3oool003l0oooo0`000003
0?ooo`<00000i03oool00400oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3S0?oo
o`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0><0oooo000o0?ooo`<000000`3oool300000>@0oooo00100?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0h`3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3o
ool00400oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3S0?ooo`00?`3oool30000
00<0oooo0`00003T0?ooo`00@03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0><0
oooo003o0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0h`3oool003l0oooo0`0000030?ooo`<00000i03oool00400oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`3S0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]
0?ooo`00@03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0><0oooo000o0?ooo`<0
00000`3oool300000>@0oooo00100?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
h`3oool00?l0oooo;@3oool00?l0oooo;@3oool00400oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0=`0oooo000o0?ooo`<000000`3oool3000000@0
oooo0`00003M0?ooo`00@03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0g03oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool00400
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0eP3oool003l0oooo0`0000030?ooo`<00000103oool3000000<0oooo
0`00003G0?ooo`00@03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`3F0?ooo`00o`3oool]0?ooo`00o`3oool]0?oo
o`00@03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0<l0oooo000o0?ooo`<00000
0`3oool3000000@0oooo0`0000030?ooo`<00000103oool300000=00oooo00100?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0c`3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0
oooo;@3oool00400oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2k0?ooo`00?`3o
ool3000000<0oooo0`0000040?ooo`<000000`3oool3000000@0oooo0`0000030?ooo`<00000103o
ool3000000@0oooo0`00002l0?ooo`00@03oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0;/0oooo003o0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:h0oooo
000o0?ooo`<000000`3oool3000000@0oooo0`0000030?ooo`<00000103oool3000000<0oooo0`00
00040?ooo`<00000103oool3000000<0oooo0`0000040?ooo`<00000[`3oool00400oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0[P3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool00400oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`2X0?ooo`00?`3oool3000000<0oooo0`000004
0?ooo`<000000`3oool3000000@0oooo0`0000030?ooo`<00000103oool3000000@0oooo0`000003
0?ooo`<00000103oool3000000<0oooo0`00002Y0?ooo`00@03oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0:P0oooo003o0?ooobd0oooo003o0?ooobd0oooo00100?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0o0?ooo`00?`3oool3
000000<0oooo0`0000040?ooo`<000000`3oool3000000@0oooo0`0000030?ooo`<00000103oool3
000000@0oooo0`0000030?ooo`<00000103oool3000000<0oooo0`0000040?ooo`<000000`3oool3
000000@0oooo0`0000030?ooo`<00000103oool3000000@0oooo0`0000030?ooo`<00000103oool3
000000<0oooo0`0000040?ooo`<000000`3oool3000000@0oooo0`0000030?ooo`<00000103oool3
000000@0oooo0`0000030?ooo`<00000@03oool00400oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo03l0oooo003o0?ooobd0oooo003o0?ooobd0oooo
003o0?ooobd0oooo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-8.80107, 0.224837, 0.152516, \
0.181845}},
  CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Here every composition of 5 into 3 parts is generated exactly once. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.22"}],

Cell[CellGroupData[{

Cell["Compositions[5,3]", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Set partitions are different than integer partitions, representing the ways \
we can partition distinct elements into subsets. They are useful for \
representing colorings and clusterings. \
\>", "MathCaption",
  CellTags->{"S5.18.1", "1.23"}],

Cell[CellGroupData[{

Cell["SetPartitions[3]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The list of tableaux of shape ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " illustrates the amount of freedom available to tableaux structures. The \
smallest element is always in the upper left\[Hyphen]hand corner, but the \
largest element is free to be the rightmost position of the last row defined \
by the ",
 StyleBox["distinct", "TI"],
 " parts of the partition. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.24"}],

Cell[CellGroupData[{

Cell["Tableaux[{2,2,1}]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
By iterating through the different integer partitions as shapes, all tableaux \
of a particular size can be constructed. \
\>", "MathCaption",
  CellTags->{"S5.18.1", "1.25"}],

Cell[CellGroupData[{

Cell["Tableaux[3]", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
  "The hook length formula can be used to count the number of tableaux for \
any shape. Using the hook length formula over all partitions of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " computes the number of tableaux on ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula",
    GridBoxOptions->{ColumnWidths->Automatic}],
  " elements. "
}], "MathCaption",
  CellTags->{"S5.18.1", "1.26"}],

Cell[CellGroupData[{

Cell["NumberOfTableaux[10]", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["9496"], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Each of the 117,123,756,750 tableaux of this shape will be selected with \
equal likelihood. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.27"}],

Cell[CellGroupData[{

Cell["TableForm[ RandomTableau[{6,5,5,4,3,2}] ]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "2", "3", "4", "16", "17"},
    {"5", "6", "12", "19", "21", "\<\"\"\>"},
    {"7", "8", "13", "20", "24", "\<\"\"\>"},
    {"9", "10", "18", "22", "\<\"\"\>", "\<\"\"\>"},
    {"11", "14", "23", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"15", "25", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
    },
   RowSpacings->1,
   ColumnSpacings->3,
   RowAlignments->Baseline,
   ColumnAlignments->{Left}],
  TableForm[{{1, 2, 3, 4, 16, 17}, {5, 6, 12, 19, 21}, {7, 8, 13, 20, 24}, {9,
     10, 18, 22}, {11, 14, 23}, {15, 25}}]]], "Output",
 CellLabel->"Out[20]//TableForm= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A pigeonhole result states that any sequence of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["n",
      "TI"], "2"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " distinct integers must contain either an increasing or a decreasing \
scattered subsequence of length ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "+", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.28"}],

Cell[CellGroupData[{

Cell["\<\
LongestIncreasingSubsequence[
        RandomPermutation[50] ]\
\>", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "6", ",", "9", ",", "11", ",", "17", ",", "19", ",", "21", ",", 
   "25", ",", "27", ",", "33", ",", "34", ",", "35"}], "}"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["Compositions",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "DominatingIntegerPartitionQ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["DominationLattice",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["DurfeeSquare",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["FerrersDiagram",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["NextComposition",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NextPartition",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["PartitionQ",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["ReverseLexicographicPartitions",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["RandomComposition",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["RandomPartition",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["TransposePartition",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.18.1"],

Cell[TextData[{
  StyleBox["Combinatorica", "MR"],
  " functions for integer partitions."
}], "Caption",
  CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["CoarserSetPartitionQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FindSet",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["InitializeUnionFind",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["KSetPartitions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PartitionLattice",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RGFQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RGFToSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RGFs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RandomKSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RandomRGF",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RandomSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RankKSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RankRGF",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RankSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SetPartitionListViaRGF",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SetPartitionQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SetPartitionToRGF",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SetPartitions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ToCanonicalSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UnionSet",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["UnrankKSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UnrankRGF",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["UnrankSetPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
  StyleBox["Combinatorica", "MR"],
  " functions for set partitions."
}], "Caption",
  CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["ConstructTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DeleteFromTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FirstLexicographicTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["InsertIntoTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LastLexicographicTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NextTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PermutationToTableaux",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RandomTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TableauClasses",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TableauQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tableaux",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TableauxToPermutation",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TransposeTableau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for Young tableaux."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["Backtrack",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["BellB",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["Cofactor",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["Distribution",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["Element",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["Eulerian",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NumberOf2Paths",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "NumberOfCompositions",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NumberOfDerangements",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "NumberOfDirectedGraphs",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NumberOfGraphs",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "NumberOfInvolutions",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NumberOfKPaths",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["NumberOfNecklaces",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NumberOfPartitions",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "NumberOfPermutationsByCycles",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NumberOfPermutationsByInversions",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "NumberOfPermutationsByType",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["NumberOfSpanningTrees",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["NumberOfTableaux",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[StyleBox["StirlingFirst",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox["StirlingSecond",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for counting."
}], "Caption",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Representing Graphs", "Subsubsection",
 CellTags->{"S5.18.1", "1.29"}],

Cell["\<\
We define a graph to be a set of vertices with a set of edges, where an edge \
is defined as a pair of vertices. The representation of graphs takes on \
different requirements depending upon whether the intended consumer is a \
person or a machine. Computers digest graphs best as data structures such as \
adjacency matrices or lists. People prefer a visualization of the structure \
as a collection of points connected by lines, which implies adding geometric \
information to the graph. \
\>", "Text",
 CellTags->{"S5.18.1", "1.30"}],

Cell[TextData[{
 "In the complete graph on five vertices, denoted ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], "5"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", each vertex is adjacent to all other vertices. ",
 StyleBox["CompleteGraph[n]", "MR"],
 " constructs the complete graph on ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " vertices. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.31"}],

Cell[CellGroupData[{

Cell["ShowGraph[ CompleteGraph[5] ]", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .78027 L
s
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.60654 .04652 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The internals of the graph representation are not shown to the \
user\[LongDash]only a notation with the number of edges and vertices, \
followed by whether the graph is directed or undirected. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.32"}],

Cell[CellGroupData[{

Cell["CompleteGraph[5]", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 10, ", ", 5, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The adjacency matrix of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], "5"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " shows that each vertex is adjacent to all other vertices. The main \
diagonal consists of zeros, since there are no self\[Hyphen]loops in the \
complete graph, meaning edges from a vertex to itself. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.33"}],

Cell[CellGroupData[{

Cell["TableForm[ToAdjacencyMatrix[CompleteGraph[5]]]", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "1", "1", "1", "1"},
    {"1", "0", "1", "1", "1"},
    {"1", "1", "0", "1", "1"},
    {"1", "1", "1", "0", "1"},
    {"1", "1", "1", "1", "0"}
    },
   RowSpacings->1,
   ColumnSpacings->3,
   RowAlignments->Baseline,
   ColumnAlignments->{Left}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[24]//TableForm= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The standard embedding of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], "5"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " consists of five vertices equally spaced on a circle. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.34"}],

Cell[CellGroupData[{

Cell["Vertices[ CompleteGraph[5] ]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.30901699437494745`", ",", "0.9510565162951535`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8090169943749473`"}], ",", "0.5877852522924732`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8090169943749476`"}], ",", 
     RowBox[{"-", "0.587785252292473`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.30901699437494723`", ",", 
     RowBox[{"-", "0.9510565162951536`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The number of vertices in a graph is termed the order of the graph. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.35"}],

Cell[CellGroupData[{

Cell["V[ CompleteGraph[5] ]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["M", "MR"],
 " returns the number of edges in a graph. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.36"}],

Cell[CellGroupData[{

Cell["M[ CompleteGraph[5] ]", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["10"], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Edge/vertex colors/styles can be globally modified, giving complete \
flexibility to change the appearance of a graph. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.37"}],

Cell[CellGroupData[{

Cell["\<\
g = SetGraphOptions[CompleteGraph[4], VertexColor -> Red,
     EdgeColor -> Blue]\
\>", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 6, ", ", 4, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The colors, styles, labels, and weights of individual vertices and edges can \
also be changed individually, perhaps to highlight interesting features of \
the graph. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.38"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[ SetGraphOptions[ CompleteGraph[4],
       {{1, 2, VertexColor -> Green, VertexStyle -> Disk[Large]},
        {3, 4, VertexColor -> Blue}},
       EdgeColor -> Red
] ]\
\>", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.005 w
[ ] 0 setdash
.5 .95455 m
.04545 .5 L
s
.5 .95455 m
.5 .04545 L
s
.5 .95455 m
.95455 .5 L
s
.04545 .5 m
.5 .04545 L
s
.04545 .5 m
.95455 .5 L
s
.5 .04545 m
.95455 .5 L
s
0 1 0 r
.07 w
.5 .95455 Mdot
.04545 .5 Mdot
0 0 1 r
.025 w
.5 .04545 Mdot
.95455 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[29]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A star is a tree with one vertex of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Adding any new edge to a star produces a cycle of length 3. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.39"}],

Cell[CellGroupData[{

Cell["ShowGraph[ AddEdge[Star[10], {1,2}] ]", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0253138 0.928273 0.0457731 0.915461 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.84417 .79648 m
.56711 .95423 L
s
.84417 .79648 m
.4859 .5 L
s
.56711 .95423 m
.4859 .5 L
s
.25205 .89944 m
.4859 .5 L
s
.04641 .65775 m
.4859 .5 L
s
.04641 .34225 m
.4859 .5 L
s
.25205 .10056 m
.4859 .5 L
s
.56711 .04577 m
.4859 .5 L
s
.84417 .20352 m
.4859 .5 L
s
.95359 .5 m
.4859 .5 L
s
.025 w
.84417 .79648 Mdot
.56711 .95423 Mdot
.25205 .89944 Mdot
.04641 .65775 Mdot
.04641 .34225 Mdot
.25205 .10056 Mdot
.56711 .04577 Mdot
.84417 .20352 Mdot
.95359 .5 Mdot
.4859 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[30]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Graphs with multi\[Hyphen]edges and self\[Hyphen]loops are supported. Here \
there are two copies of each edge of a star. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.40"}],

Cell[CellGroupData[{

Cell["ShowGraph[ GraphSum[Star[10], Star[10]] ]", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0253138 0.928273 0.0457731 0.915461 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.84417 .79648 m
.65501 .66002 L
.4859 .5 L
s
.84417 .79648 m
.67505 .63646 L
.4859 .5 L
s
.56711 .95423 m
.51115 .72978 L
.4859 .5 L
s
.56711 .95423 m
.54186 .72444 L
.4859 .5 L
s
.25205 .89944 m
.35547 .69203 L
.4859 .5 L
s
.25205 .89944 m
.38248 .70741 L
.4859 .5 L
s
.04641 .65775 m
.26082 .56443 L
.4859 .5 L
s
.04641 .65775 m
.27149 .59332 L
.4859 .5 L
s
.04641 .34225 m
.26082 .43557 L
.4859 .5 L
s
.04641 .34225 m
.27149 .40668 L
.4859 .5 L
s
.25205 .10056 m
.35547 .30797 L
.4859 .5 L
s
.25205 .10056 m
.38248 .29259 L
.4859 .5 L
s
.56711 .04577 m
.51115 .27022 L
.4859 .5 L
s
.56711 .04577 m
.54186 .27556 L
.4859 .5 L
s
.84417 .20352 m
.65501 .33998 L
.4859 .5 L
s
.84417 .20352 m
.67505 .36354 L
.4859 .5 L
s
.95359 .5 m
.71974 .51537 L
.4859 .5 L
s
.95359 .5 m
.71974 .48463 L
.4859 .5 L
s
.025 w
.84417 .79648 Mdot
.56711 .95423 Mdot
.25205 .89944 Mdot
.04641 .65775 Mdot
.04641 .34225 Mdot
.25205 .10056 Mdot
.56711 .04577 Mdot
.84417 .20352 Mdot
.95359 .5 Mdot
.4859 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[31]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The adjacency list representation of a graph consists of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " lists, one list for each vertex ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[LessEqual]", 
    StyleBox["i",
     "TI"], "\[LessEqual]", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", which records the vertices to which ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is adjacent. Each vertex in the complete graph is adjacent to all other \
vertices. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.41"}],

Cell[CellGroupData[{

Cell["TableForm[ ToAdjacencyLists[CompleteGraph[5]] ]", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[GridBox[{
    {"2", "3", "4", "5"},
    {"1", "3", "4", "5"},
    {"1", "2", "4", "5"},
    {"1", "2", "3", "5"},
    {"1", "2", "3", "4"}
    },
   RowSpacings->1,
   ColumnSpacings->3,
   RowAlignments->Baseline,
   ColumnAlignments->{Left}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[32]//TableForm= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "There are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["n",
       "TI"], "-", "1"}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " ordered pairs of edges defined by a complete graph of order ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.42"}],

Cell[CellGroupData[{

Cell["ToOrderedPairs[ CompleteGraph[5] ]", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "An induced subgraph of a graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a subset of the vertices of ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " together with any edges whose endpoints are both in this subset. An \
induced subgraph that is complete is called a clique. Any subset of the \
vertices in a complete graph defines a clique. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.43"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[ InduceSubgraph[CompleteGraph[20],
        RandomSubset[Range[20]]] ]\
\>", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0464888 0.929776 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.9323 .65503 m
.86773 .78463 L
s
.9323 .65503 m
.76718 .88748 L
s
.9323 .65503 m
.35954 .95351 L
s
.9323 .65503 m
.23282 .88748 L
s
.9323 .65503 m
.13227 .78463 L
s
.9323 .65503 m
.04545 .51138 L
s
.9323 .65503 m
.35954 .06924 L
s
.9323 .65503 m
.5 .04649 L
s
.9323 .65503 m
.76718 .13527 L
s
.9323 .65503 m
.86773 .23812 L
s
.9323 .65503 m
.95455 .51138 L
s
.86773 .78463 m
.76718 .88748 L
s
.86773 .78463 m
.35954 .95351 L
s
.86773 .78463 m
.23282 .88748 L
s
.86773 .78463 m
.13227 .78463 L
s
.86773 .78463 m
.04545 .51138 L
s
.86773 .78463 m
.35954 .06924 L
s
.86773 .78463 m
.5 .04649 L
s
.86773 .78463 m
.76718 .13527 L
s
.86773 .78463 m
.86773 .23812 L
s
.86773 .78463 m
.95455 .51138 L
s
.76718 .88748 m
.35954 .95351 L
s
.76718 .88748 m
.23282 .88748 L
s
.76718 .88748 m
.13227 .78463 L
s
.76718 .88748 m
.04545 .51138 L
s
.76718 .88748 m
.35954 .06924 L
s
.76718 .88748 m
.5 .04649 L
s
.76718 .88748 m
.76718 .13527 L
s
.76718 .88748 m
.86773 .23812 L
s
.76718 .88748 m
.95455 .51138 L
s
.35954 .95351 m
.23282 .88748 L
s
.35954 .95351 m
.13227 .78463 L
s
.35954 .95351 m
.04545 .51138 L
s
.35954 .95351 m
.35954 .06924 L
s
.35954 .95351 m
.5 .04649 L
s
.35954 .95351 m
.76718 .13527 L
s
.35954 .95351 m
.86773 .23812 L
s
.35954 .95351 m
.95455 .51138 L
s
.23282 .88748 m
.13227 .78463 L
s
.23282 .88748 m
.04545 .51138 L
s
.23282 .88748 m
.35954 .06924 L
s
.23282 .88748 m
.5 .04649 L
s
.23282 .88748 m
.76718 .13527 L
s
.23282 .88748 m
.86773 .23812 L
s
.23282 .88748 m
.95455 .51138 L
s
.13227 .78463 m
.04545 .51138 L
s
.13227 .78463 m
.35954 .06924 L
s
.13227 .78463 m
.5 .04649 L
s
.13227 .78463 m
.76718 .13527 L
s
.13227 .78463 m
.86773 .23812 L
s
.13227 .78463 m
.95455 .51138 L
s
.04545 .51138 m
.35954 .06924 L
s
.04545 .51138 m
.5 .04649 L
s
.04545 .51138 m
.76718 .13527 L
s
.04545 .51138 m
.86773 .23812 L
s
.04545 .51138 m
.95455 .51138 L
s
.35954 .06924 m
.5 .04649 L
s
.35954 .06924 m
.76718 .13527 L
s
.35954 .06924 m
.86773 .23812 L
s
.35954 .06924 m
.95455 .51138 L
s
.5 .04649 m
.76718 .13527 L
s
.5 .04649 m
.86773 .23812 L
s
.5 .04649 m
.95455 .51138 L
s
.76718 .13527 m
.86773 .23812 L
s
.76718 .13527 m
.95455 .51138 L
s
.86773 .23812 m
.95455 .51138 L
s
.025 w
.9323 .65503 Mdot
.86773 .78463 Mdot
.76718 .88748 Mdot
.35954 .95351 Mdot
.23282 .88748 Mdot
.13227 .78463 Mdot
.04545 .51138 Mdot
.35954 .06924 Mdot
.5 .04649 Mdot
.76718 .13527 Mdot
.86773 .23812 Mdot
.95455 .51138 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[34]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The vertices of a bipartite graph have the property that they can be \
partitioned into two sets such that no edge connects two vertices of the same \
set. Contracting an edge in a bipartite graph can ruin its bipartiteness. \
Note the self\[Hyphen]loop created by the contraction. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.44"}],

Cell[CellGroupData[{

Cell["ShowGraph[ Contract[ CompleteGraph[6,6],{1,7} ] ]", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.16667 3.33333 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.16667 .22727 m
.83333 .22727 L
s
.16667 .22727 m
.83333 .40909 L
s
.16667 .22727 m
.83333 .59091 L
s
.16667 .22727 m
.83333 .77273 L
s
.16667 .22727 m
.83333 .95455 L
s
.16667 .22727 m
.5 .04545 L
s
.16667 .40909 m
.83333 .22727 L
s
.16667 .40909 m
.83333 .40909 L
s
.16667 .40909 m
.83333 .59091 L
s
.16667 .40909 m
.83333 .77273 L
s
.16667 .40909 m
.83333 .95455 L
s
.16667 .40909 m
.5 .04545 L
s
.16667 .59091 m
.83333 .22727 L
s
.16667 .59091 m
.83333 .40909 L
s
.16667 .59091 m
.83333 .59091 L
s
.16667 .59091 m
.83333 .77273 L
s
.16667 .59091 m
.83333 .95455 L
s
.16667 .59091 m
.5 .04545 L
s
.16667 .77273 m
.83333 .22727 L
s
.16667 .77273 m
.83333 .40909 L
s
.16667 .77273 m
.83333 .59091 L
s
.16667 .77273 m
.83333 .77273 L
s
.16667 .77273 m
.83333 .95455 L
s
.16667 .77273 m
.5 .04545 L
s
.16667 .95455 m
.83333 .22727 L
s
.16667 .95455 m
.83333 .40909 L
s
.16667 .95455 m
.83333 .59091 L
s
.16667 .95455 m
.83333 .77273 L
s
.16667 .95455 m
.83333 .95455 L
s
.16667 .95455 m
.5 .04545 L
s
.83333 .22727 m
.5 .04545 L
s
.83333 .40909 m
.5 .04545 L
s
.83333 .59091 m
.5 .04545 L
s
.83333 .77273 m
.5 .04545 L
s
.83333 .95455 m
.5 .04545 L
s
.025 w
.16667 .22727 Mdot
.16667 .40909 Mdot
.16667 .59091 Mdot
.16667 .77273 Mdot
.16667 .95455 Mdot
.83333 .22727 Mdot
.83333 .40909 Mdot
.83333 .59091 Mdot
.83333 .77273 Mdot
.83333 .95455 Mdot
.5 .04545 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
A breadth\[Hyphen]first search of a graph explores all the vertices adjacent \
to the current vertex before moving on. A breadth\[Hyphen]first traversal of \
a simple cycle alternates sides as it wraps around the cycle. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.45"}],

Cell[CellGroupData[{

Cell["BreadthFirstTraversal[Cycle[20],1]", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12", ",", 
   "14", ",", "16", ",", "18", ",", "20", ",", "19", ",", "17", ",", "15", 
   ",", "13", ",", "11", ",", "9", ",", "7", ",", "5", ",", "3"}], 
  "}"}]], "Output",
 CellLabel->"Out[36]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
In a depth\[Hyphen]first search, the children of the first son of a vertex \
are explored before visiting his brothers. The depth\[Hyphen]first traversal \
differs from the breadth\[Hyphen]first traversal above in that it proceeds \
directly around the cycle. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.46"}],

Cell[CellGroupData[{

Cell["DepthFirstTraversal[Cycle[20], 1]", "Input",
 CellLabel->"In[37]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",\

 CellLabel->"Out[37]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Different drawings or embeddings of a graph can reveal different aspects of \
its structure. The default embedding for a grid graph is a ranked embedding \
from all the vertices on one side. Ranking from the center vertex yields a \
different but interesting drawing. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.47"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[
        RankedEmbedding[GridGraph[5,5],{13}]]\
\>", "Input",
 CellLabel->"In[38]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.840206 1.75258 0.0541401 1.0828 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.91237 .30892 m
.70619 .05414 L
s
.91237 .30892 m
.70619 .30892 L
s
.70619 .05414 m
.5 .05414 L
s
.70619 .05414 m
.5 .18153 L
s
.5 .05414 m
.70619 .18153 L
s
.5 .05414 m
.29381 .30892 L
s
.70619 .18153 m
.91237 .43631 L
s
.70619 .18153 m
.5 .30892 L
s
.91237 .43631 m
.70619 .43631 L
s
.70619 .30892 m
.5 .18153 L
s
.70619 .30892 m
.5 .43631 L
s
.5 .18153 m
.29381 .30892 L
s
.5 .18153 m
.29381 .43631 L
s
.29381 .30892 m
.5 .30892 L
s
.29381 .30892 m
.08763 .5 L
s
.5 .30892 m
.70619 .43631 L
s
.5 .30892 m
.29381 .56369 L
s
.70619 .43631 m
.5 .56369 L
s
.5 .43631 m
.29381 .43631 L
s
.5 .43631 m
.70619 .56369 L
s
.29381 .43631 m
.08763 .5 L
s
.29381 .43631 m
.5 .69108 L
s
.08763 .5 m
.29381 .56369 L
s
.08763 .5 m
.29381 .69108 L
s
.29381 .56369 m
.5 .56369 L
s
.29381 .56369 m
.5 .81847 L
s
.5 .56369 m
.70619 .69108 L
s
.70619 .56369 m
.5 .69108 L
s
.70619 .56369 m
.91237 .56369 L
s
.5 .69108 m
.29381 .69108 L
s
.5 .69108 m
.70619 .81847 L
s
.29381 .69108 m
.5 .81847 L
s
.29381 .69108 m
.5 .94586 L
s
.5 .81847 m
.70619 .69108 L
s
.5 .81847 m
.70619 .94586 L
s
.70619 .69108 m
.91237 .69108 L
s
.91237 .56369 m
.70619 .81847 L
s
.70619 .81847 m
.5 .94586 L
s
.5 .94586 m
.70619 .94586 L
s
.70619 .94586 m
.91237 .69108 L
s
.025 w
.91237 .30892 Mdot
.70619 .05414 Mdot
.5 .05414 Mdot
.70619 .18153 Mdot
.91237 .43631 Mdot
.70619 .30892 Mdot
.5 .18153 Mdot
.29381 .30892 Mdot
.5 .30892 Mdot
.70619 .43631 Mdot
.5 .43631 Mdot
.29381 .43631 Mdot
.08763 .5 Mdot
.29381 .56369 Mdot
.5 .56369 Mdot
.70619 .56369 Mdot
.5 .69108 Mdot
.29381 .69108 Mdot
.5 .81847 Mdot
.70619 .69108 Mdot
.91237 .56369 Mdot
.70619 .81847 Mdot
.5 .94586 Mdot
.70619 .94586 Mdot
.91237 .69108 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[38]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The radial embedding of a tree is guaranteed to be planar, but radial \
embeddings can be used with any graph. Here we see a radial embedding of a \
random labeled tree. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.48"}],

Cell[CellGroupData[{

Cell["ShowGraph[ RandomTree[10] ]", "Input",
 CellLabel->"In[39]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.510528 1.4386 0.066882 1.33764 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.21656 .74294 m
.21656 .93312 L
s
.21656 .74294 m
.21656 .55276 L
s
.73911 .27273 m
.92807 .19995 L
s
.73911 .27273 m
.55014 .34551 L
s
.07193 .41829 m
.21656 .55276 L
s
.43945 .24258 m
.51772 .06688 L
s
.43945 .24258 m
.36118 .41829 L
s
.21656 .55276 m
.36118 .41829 L
s
.36118 .41829 m
.55014 .34551 L
s
.025 w
.21656 .74294 Mdot
.73911 .27273 Mdot
.92807 .19995 Mdot
.07193 .41829 Mdot
.43945 .24258 Mdot
.21656 .93312 Mdot
.51772 .06688 Mdot
.21656 .55276 Mdot
.36118 .41829 Mdot
.55014 .34551 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[39]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
By arbitrarily selecting a root, any tree can be represented as a rooted \
tree. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.49"}],

Cell[CellGroupData[{

Cell["ShowGraph[ RootedEmbedding[RandomTree[10],1] ]", "Input",
 CellLabel->"In[40]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.418919 1.35135 0.0714286 1.42857 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.39189 .92857 m
.39189 .75714 L
s
.93243 .24286 m
.93243 .41429 L
s
.06757 .58571 m
.39189 .75714 L
s
.71622 .58571 m
.5 .41429 L
s
.71622 .58571 m
.71622 .41429 L
s
.71622 .58571 m
.93243 .41429 L
s
.71622 .58571 m
.39189 .75714 L
s
.71622 .24286 m
.71622 .41429 L
s
.71622 .24286 m
.71622 .07143 L
s
.025 w
.39189 .92857 Mdot
.93243 .24286 Mdot
.06757 .58571 Mdot
.71622 .58571 Mdot
.71622 .24286 Mdot
.5 .41429 Mdot
.71622 .41429 Mdot
.93243 .41429 Mdot
.71622 .07143 Mdot
.39189 .75714 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[40]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "An interesting general heuristic for drawing graphs models the graph as a \
system of springs and lets Hooke\[CloseCurlyQuote]s law space the vertices. \
Here it does a good job illustrating the ",
 StyleBox["Join", "MR"],
 " operation, where each vertex of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], "7"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is connected to each of two disconnected vertices. In achieving the \
minimum energy configuration, these two vertices end up on different sides of \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], "7"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.50"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[
        SpringEmbedding[
        GraphJoin[EmptyGraph[2], CompleteGraph[7]]]]\
\>", "Input",
 CellLabel->"In[41]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0960295 1.04384 0.128767 2.57535 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.05219 .49848 m
.55876 .80463 L
s
.05219 .49848 m
.47833 .87123 L
s
.05219 .49848 m
.41571 .66923 L
s
.05219 .49848 m
.41619 .32136 L
s
.05219 .49848 m
.47957 .12877 L
s
.05219 .49848 m
.55935 .20007 L
s
.05219 .49848 m
.59202 .49978 L
s
.94781 .50078 m
.55876 .80463 L
s
.94781 .50078 m
.47833 .87123 L
s
.94781 .50078 m
.41571 .66923 L
s
.94781 .50078 m
.41619 .32136 L
s
.94781 .50078 m
.47957 .12877 L
s
.94781 .50078 m
.55935 .20007 L
s
.94781 .50078 m
.59202 .49978 L
s
.55876 .80463 m
.47833 .87123 L
s
.55876 .80463 m
.41571 .66923 L
s
.55876 .80463 m
.41619 .32136 L
s
.55876 .80463 m
.47957 .12877 L
s
.55876 .80463 m
.55935 .20007 L
s
.55876 .80463 m
.59202 .49978 L
s
.47833 .87123 m
.41571 .66923 L
s
.47833 .87123 m
.41619 .32136 L
s
.47833 .87123 m
.47957 .12877 L
s
.47833 .87123 m
.55935 .20007 L
s
.47833 .87123 m
.59202 .49978 L
s
.41571 .66923 m
.41619 .32136 L
s
.41571 .66923 m
.47957 .12877 L
s
.41571 .66923 m
.55935 .20007 L
s
.41571 .66923 m
.59202 .49978 L
s
.41619 .32136 m
.47957 .12877 L
s
.41619 .32136 m
.55935 .20007 L
s
.41619 .32136 m
.59202 .49978 L
s
.47957 .12877 m
.55935 .20007 L
s
.47957 .12877 m
.59202 .49978 L
s
.55935 .20007 m
.59202 .49978 L
s
.025 w
.05219 .49848 Mdot
.94781 .50078 Mdot
.55876 .80463 Mdot
.47833 .87123 Mdot
.41571 .66923 Mdot
.41619 .32136 Mdot
.47957 .12877 Mdot
.55935 .20007 Mdot
.59202 .49978 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[41]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AddEdge",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AddEdges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["AddVertex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AddVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ChangeEdges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ChangeVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Contract",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DeleteCycle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DeleteEdge",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DeleteEdges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DeleteVertex",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DeleteVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["InduceSubgraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MakeDirected",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MakeSimple",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MakeUndirected",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PermuteSubgraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RemoveMultipleEdges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RemoveSelfLoops",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ReverseEdges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for modifying graphs."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Edges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FromAdjacencyLists",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FromAdjacencyMatrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FromOrderedPairs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FromUnorderedPairs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["IncidenceMatrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ToAdjacencyLists",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ToAdjacencyMatrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ToOrderedPairs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ToUnorderedPairs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for graph format translation."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Algorithm",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Box",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Brelaz",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Center",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Circle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Directed",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Disk",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EdgeColor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["EdgeDirection",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EdgeLabel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["EdgeLabelColor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EdgeLabelPosition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["EdgeStyle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EdgeWeight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Euclidean",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HighlightedEdgeColors",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["HighlightedEdgeStyle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HighlightedVertexColors",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["HighlightedVertexStyle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Invariants",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LNorm",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Large",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LoopPosition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["LowerLeft",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LowerRight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NoMultipleEdges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NoSelfLoops",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Normal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NormalDashed",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NormalizeVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["One",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Optimum",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Parent",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PlotRange",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RandomInteger",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Simple",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Small",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Strong",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Thick",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ThickDashed",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Thin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ThinDashed",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Type",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Undirected",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["UpperLeft",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UpperRight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexColor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VertexLabel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexLabelColor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VertexLabelPosition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexNumber",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VertexNumberColor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexNumberPosition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VertexStyle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexWeight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Weak",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["WeightRange",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["WeightingFunction",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Zoom",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " options for graph functions."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["GetEdgeLabels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GetEdgeWeights",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GetVertexLabels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GetVertexWeights",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SetEdgeLabels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SetEdgeWeights",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SetGraphOptions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SetVertexLabels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SetVertexWeights",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for graph labels and weights."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AnimateGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CircularEmbedding",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DilateVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GraphOptions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Highlight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RadialEmbedding",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RandomVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RankGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RankedEmbedding",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RootedEmbedding",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RotateVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ShakeGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ShowGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ShowGraphArray",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ShowLabeledGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SpringEmbedding",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TranslateVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Vertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for drawing graphs."
}], "Caption",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating Graphs", "Subsubsection",
 CellTags->{"S5.18.1", "1.51"}],

Cell[TextData[{
 "Many graphs consistently prove interesting, in the sense that they are \
models of important binary relations or have unique graph theoretic \
properties. Often, these graphs can be parameterized, such as the complete \
graph on ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " vertices ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", giving a concise notation for expressing an infinite class of graphs. \
Start off with several operations that act on graphs to give different graphs \
and which, together with parameterized graphs, give the means to construct \
essentially any interesting graph. "
}], "Text",
 CellTags->{"S5.18.1", "1.52"}],

Cell["\<\
The union of two connected graphs has two connected components. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.53"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[ GraphUnion[ CompleteGraph[3],
                        CompleteGraph[5,5] ] ]\
\>", "Input",
 CellLabel->"In[42]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0367082 0.987341 0.0918367 1.83673 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.04937 .84955 m
.04937 .09184 L
s
.04937 .84955 m
.40211 .4707 L
s
.04937 .09184 m
.40211 .4707 L
s
.84093 .09184 m
.95063 .09184 L
s
.84093 .09184 m
.95063 .29592 L
s
.84093 .09184 m
.95063 .5 L
s
.84093 .09184 m
.95063 .70408 L
s
.84093 .09184 m
.95063 .90816 L
s
.84093 .29592 m
.95063 .09184 L
s
.84093 .29592 m
.95063 .29592 L
s
.84093 .29592 m
.95063 .5 L
s
.84093 .29592 m
.95063 .70408 L
s
.84093 .29592 m
.95063 .90816 L
s
.84093 .5 m
.95063 .09184 L
s
.84093 .5 m
.95063 .29592 L
s
.84093 .5 m
.95063 .5 L
s
.84093 .5 m
.95063 .70408 L
s
.84093 .5 m
.95063 .90816 L
s
.84093 .70408 m
.95063 .09184 L
s
.84093 .70408 m
.95063 .29592 L
s
.84093 .70408 m
.95063 .5 L
s
.84093 .70408 m
.95063 .70408 L
s
.84093 .70408 m
.95063 .90816 L
s
.84093 .90816 m
.95063 .09184 L
s
.84093 .90816 m
.95063 .29592 L
s
.84093 .90816 m
.95063 .5 L
s
.84093 .90816 m
.95063 .70408 L
s
.84093 .90816 m
.95063 .90816 L
s
.025 w
.04937 .84955 Mdot
.04937 .09184 Mdot
.40211 .4707 Mdot
.84093 .09184 Mdot
.84093 .29592 Mdot
.84093 .5 Mdot
.84093 .70408 Mdot
.84093 .90816 Mdot
.95063 .09184 Mdot
.95063 .29592 Mdot
.95063 .5 Mdot
.95063 .70408 Mdot
.95063 .90816 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[42]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Graph products can be very interesting. The embedding of a product has been \
designed to show off its structure, and is formed by shrinking the first \
graph and translating it to the position of each vertex in the second graph. \
\
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.54"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[ GraphProduct[ CompleteGraph[3],
        CompleteGraph[5] ] ]\
\>", "Input",
 CellLabel->"In[43]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0458698 0.917396 0.0178222 0.935407 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.04587 .66264 m
.04587 .51696 L
s
.04587 .66264 m
.1696 .5898 L
s
.04587 .66264 m
.1957 .19245 L
s
.04587 .66264 m
.68056 .19245 L
s
.04587 .66264 m
.8304 .66264 L
s
.04587 .66264 m
.43813 .95323 L
s
.04587 .51696 m
.1696 .5898 L
s
.04587 .51696 m
.1957 .04677 L
s
.04587 .51696 m
.68056 .04677 L
s
.04587 .51696 m
.8304 .51696 L
s
.04587 .51696 m
.43813 .80755 L
s
.1696 .5898 m
.31944 .11961 L
s
.1696 .5898 m
.8043 .11961 L
s
.1696 .5898 m
.95413 .5898 L
s
.1696 .5898 m
.56187 .88039 L
s
.1957 .19245 m
.1957 .04677 L
s
.1957 .19245 m
.31944 .11961 L
s
.1957 .19245 m
.68056 .19245 L
s
.1957 .19245 m
.8304 .66264 L
s
.1957 .19245 m
.43813 .95323 L
s
.1957 .04677 m
.31944 .11961 L
s
.1957 .04677 m
.68056 .04677 L
s
.1957 .04677 m
.8304 .51696 L
s
.1957 .04677 m
.43813 .80755 L
s
.31944 .11961 m
.8043 .11961 L
s
.31944 .11961 m
.95413 .5898 L
s
.31944 .11961 m
.56187 .88039 L
s
.68056 .19245 m
.68056 .04677 L
s
.68056 .19245 m
.8043 .11961 L
s
.68056 .19245 m
.8304 .66264 L
s
.68056 .19245 m
.43813 .95323 L
s
.68056 .04677 m
.8043 .11961 L
s
.68056 .04677 m
.8304 .51696 L
s
.68056 .04677 m
.43813 .80755 L
s
.8043 .11961 m
.95413 .5898 L
s
.8043 .11961 m
.56187 .88039 L
s
.8304 .66264 m
.8304 .51696 L
s
.8304 .66264 m
.95413 .5898 L
s
.8304 .66264 m
.43813 .95323 L
s
.8304 .51696 m
.95413 .5898 L
s
.8304 .51696 m
.43813 .80755 L
s
.95413 .5898 m
.56187 .88039 L
s
.43813 .95323 m
.43813 .80755 L
s
.43813 .95323 m
.56187 .88039 L
s
.43813 .80755 m
.56187 .88039 L
s
.025 w
.04587 .66264 Mdot
.04587 .51696 Mdot
.1696 .5898 Mdot
.1957 .19245 Mdot
.1957 .04677 Mdot
.31944 .11961 Mdot
.68056 .19245 Mdot
.68056 .04677 Mdot
.8043 .11961 Mdot
.8304 .66264 Mdot
.8304 .51696 Mdot
.95413 .5898 Mdot
.43813 .95323 Mdot
.43813 .80755 Mdot
.56187 .88039 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[43]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The line graph ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["L",
     "TI"], 
    RowBox[{"(", 
     StyleBox["G",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of a graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has a vertex of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["L",
     "TI"], 
    RowBox[{"(", 
     StyleBox["G",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " associated with each edge of ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and an edge of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["L",
     "TI"], 
    RowBox[{"(", 
     StyleBox["G",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if, and only if, the two edges of ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " share a common vertex. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.55"}],

Cell[CellGroupData[{

Cell["ShowGraph[ LineGraph[CompleteGraph[5]] ]", "Input",
 CellLabel->"In[44]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0486761 0.973522 0.023178 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.39346 .95348 m
.39346 .60705 L
s
.39346 .95348 m
.73824 .5 L
s
.39346 .95348 m
.95132 .78027 L
s
.39346 .95348 m
.04868 .5 L
s
.39346 .95348 m
.39346 .39295 L
s
.39346 .95348 m
.60654 .67322 L
s
.39346 .60705 m
.73824 .5 L
s
.39346 .60705 m
.95132 .78027 L
s
.39346 .60705 m
.04868 .5 L
s
.39346 .60705 m
.39346 .04652 L
s
.39346 .60705 m
.60654 .32678 L
s
.73824 .5 m
.95132 .78027 L
s
.73824 .5 m
.39346 .39295 L
s
.73824 .5 m
.39346 .04652 L
s
.73824 .5 m
.95132 .21973 L
s
.95132 .78027 m
.60654 .67322 L
s
.95132 .78027 m
.60654 .32678 L
s
.95132 .78027 m
.95132 .21973 L
s
.04868 .5 m
.39346 .39295 L
s
.04868 .5 m
.60654 .67322 L
s
.04868 .5 m
.39346 .04652 L
s
.04868 .5 m
.60654 .32678 L
s
.39346 .39295 m
.60654 .67322 L
s
.39346 .39295 m
.39346 .04652 L
s
.39346 .39295 m
.95132 .21973 L
s
.60654 .67322 m
.60654 .32678 L
s
.60654 .67322 m
.95132 .21973 L
s
.39346 .04652 m
.60654 .32678 L
s
.39346 .04652 m
.95132 .21973 L
s
.60654 .32678 m
.95132 .21973 L
s
.025 w
.39346 .95348 Mdot
.39346 .60705 Mdot
.73824 .5 Mdot
.95132 .78027 Mdot
.04868 .5 Mdot
.39346 .39295 Mdot
.60654 .67322 Mdot
.39346 .04652 Mdot
.60654 .32678 Mdot
.95132 .21973 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[44]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "Circulants are graphs whose adjacency matrix can be constructed by rotating \
a vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " times, and include complete graphs and cycles as special cases. Even \
random circulant graphs have an interesting, regular structure. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.56"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[ CirculantGraph[21,
        RandomKSubset[Range[10],3]]]\
\>", "Input",
 CellLabel->"In[45]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0418026 0.912569 0.0455125 0.910249 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.93407 .63434 m
.78234 .85633 L
s
.93407 .63434 m
.39577 .94434 L
s
.93407 .63434 m
.08577 .69775 L
s
.93407 .63434 m
.26899 .1053 L
s
.93407 .63434 m
.66438 .07574 L
s
.93407 .63434 m
.93407 .36566 L
s
.87498 .75674 m
.66438 .92426 L
s
.87498 .75674 m
.26899 .8947 L
s
.87498 .75674 m
.04563 .56793 L
s
.87498 .75674 m
.39577 .05566 L
s
.87498 .75674 m
.78234 .14367 L
s
.87498 .75674 m
.95437 .5 L
s
.78234 .85633 m
.53159 .95449 L
s
.78234 .85633 m
.1625 .81 L
s
.78234 .85633 m
.04563 .43207 L
s
.78234 .85633 m
.53159 .04551 L
s
.78234 .85633 m
.87498 .24326 L
s
.66438 .92426 m
.39577 .94434 L
s
.66438 .92426 m
.08577 .69775 L
s
.66438 .92426 m
.08577 .30225 L
s
.66438 .92426 m
.66438 .07574 L
s
.66438 .92426 m
.93407 .36566 L
s
.53159 .95449 m
.26899 .8947 L
s
.53159 .95449 m
.04563 .56793 L
s
.53159 .95449 m
.1625 .19 L
s
.53159 .95449 m
.78234 .14367 L
s
.53159 .95449 m
.95437 .5 L
s
.39577 .94434 m
.1625 .81 L
s
.39577 .94434 m
.04563 .43207 L
s
.39577 .94434 m
.26899 .1053 L
s
.39577 .94434 m
.87498 .24326 L
s
.26899 .8947 m
.08577 .69775 L
s
.26899 .8947 m
.08577 .30225 L
s
.26899 .8947 m
.39577 .05566 L
s
.26899 .8947 m
.93407 .36566 L
s
.1625 .81 m
.04563 .56793 L
s
.1625 .81 m
.1625 .19 L
s
.1625 .81 m
.53159 .04551 L
s
.1625 .81 m
.95437 .5 L
s
.08577 .69775 m
.04563 .43207 L
s
.08577 .69775 m
.26899 .1053 L
s
.08577 .69775 m
.66438 .07574 L
s
.04563 .56793 m
.08577 .30225 L
s
.04563 .56793 m
.39577 .05566 L
s
.04563 .56793 m
.78234 .14367 L
s
.04563 .43207 m
.1625 .19 L
s
.04563 .43207 m
.53159 .04551 L
s
.04563 .43207 m
.87498 .24326 L
s
.08577 .30225 m
.26899 .1053 L
s
.08577 .30225 m
.66438 .07574 L
s
.08577 .30225 m
.93407 .36566 L
s
.1625 .19 m
.39577 .05566 L
s
.1625 .19 m
.78234 .14367 L
s
.1625 .19 m
.95437 .5 L
s
.26899 .1053 m
.53159 .04551 L
s
.26899 .1053 m
.87498 .24326 L
s
.39577 .05566 m
.66438 .07574 L
s
.39577 .05566 m
.93407 .36566 L
s
.53159 .04551 m
.78234 .14367 L
s
.53159 .04551 m
.95437 .5 L
s
.66438 .07574 m
.87498 .24326 L
s
.78234 .14367 m
.93407 .36566 L
s
.87498 .24326 m
.95437 .5 L
s
.025 w
.93407 .63434 Mdot
.87498 .75674 Mdot
.78234 .85633 Mdot
.66438 .92426 Mdot
.53159 .95449 Mdot
.39577 .94434 Mdot
.26899 .8947 Mdot
.1625 .81 Mdot
.08577 .69775 Mdot
.04563 .56793 Mdot
.04563 .43207 Mdot
.08577 .30225 Mdot
.1625 .19 Mdot
.26899 .1053 Mdot
.39577 .05566 Mdot
.53159 .04551 Mdot
.66438 .07574 Mdot
.78234 .14367 Mdot
.87498 .24326 Mdot
.93407 .36566 Mdot
.95437 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[45]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "Some graph generators create directed graphs with self\[Hyphen]loops, such \
as this ",
 StyleBox["de Bruijn", "TI"],
 " or ",
 StyleBox["shift register", "TI"],
 " graph encoding all length\[Hyphen]5 substrings of a binary alphabet. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.57"}],

Cell[CellGroupData[{

Cell["ShowGraph[ DeBruijnGraph[2,5] ]", "Input",
 CellLabel->"In[46]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
.005 w
[ ] 0 setdash
newpath
.96399 .60686 .02571 0 365.73 arc
s
.94581 .58868 m
.91995 .67395 L
s
% Start of user PostScript
0.990393 0.597545 0.96194 0.691342 MAarrowhead1
% End of user PostScript
.91995 .67395 m
.87794 .75253 L
s
% Start of user PostScript
0.96194 0.691342 0.915735 0.777785 MAarrowhead1
% End of user PostScript
.91995 .67395 m
.82141 .82141 L
s
% Start of user PostScript
0.96194 0.691342 0.853553 0.853553 MAarrowhead1
% End of user PostScript
.87794 .75253 m
.75253 .87794 L
s
% Start of user PostScript
0.915735 0.777785 0.777785 0.915735 MAarrowhead1
% End of user PostScript
.87794 .75253 m
.67395 .91995 L
s
% Start of user PostScript
0.915735 0.777785 0.691342 0.96194 MAarrowhead1
% End of user PostScript
.82141 .82141 m
.58868 .94581 L
s
% Start of user PostScript
0.853553 0.853553 0.597545 0.990393 MAarrowhead1
% End of user PostScript
.82141 .82141 m
.5 .95455 L
s
% Start of user PostScript
0.853553 0.853553 0.5 1. MAarrowhead1
% End of user PostScript
.75253 .87794 m
.41132 .94581 L
s
% Start of user PostScript
0.777785 0.915735 0.402455 0.990393 MAarrowhead1
% End of user PostScript
.75253 .87794 m
.32605 .91995 L
s
% Start of user PostScript
0.777785 0.915735 0.308658 0.96194 MAarrowhead1
% End of user PostScript
.67395 .91995 m
.24747 .87794 L
s
% Start of user PostScript
0.691342 0.96194 0.222215 0.915735 MAarrowhead1
% End of user PostScript
.67395 .91995 m
.17859 .82141 L
s
% Start of user PostScript
0.691342 0.96194 0.146447 0.853553 MAarrowhead1
% End of user PostScript
.58868 .94581 m
.12206 .75253 L
s
% Start of user PostScript
0.597545 0.990393 0.0842652 0.777785 MAarrowhead1
% End of user PostScript
.58868 .94581 m
.08005 .67395 L
s
% Start of user PostScript
0.597545 0.990393 0.0380602 0.691342 MAarrowhead1
% End of user PostScript
.5 .95455 m
.05419 .58868 L
s
% Start of user PostScript
0.5 1. 0.00960736 0.597545 MAarrowhead1
% End of user PostScript
.5 .95455 m
.04545 .5 L
s
% Start of user PostScript
0.5 1. 0 0.5 MAarrowhead1
% End of user PostScript
.41132 .94581 m
.05419 .41132 L
s
% Start of user PostScript
0.402455 0.990393 0.00960736 0.402455 MAarrowhead1
% End of user PostScript
.41132 .94581 m
.08005 .32605 L
s
% Start of user PostScript
0.402455 0.990393 0.0380602 0.308658 MAarrowhead1
% End of user PostScript
.32605 .91995 m
.12206 .24747 L
s
% Start of user PostScript
0.308658 0.96194 0.0842652 0.222215 MAarrowhead1
% End of user PostScript
.32605 .91995 m
.17859 .17859 L
s
% Start of user PostScript
0.308658 0.96194 0.146447 0.146447 MAarrowhead1
% End of user PostScript
.24747 .87794 m
.24747 .12206 L
s
% Start of user PostScript
0.222215 0.915735 0.222215 0.0842652 MAarrowhead1
% End of user PostScript
.24747 .87794 m
.32605 .08005 L
s
% Start of user PostScript
0.222215 0.915735 0.308658 0.0380602 MAarrowhead1
% End of user PostScript
.17859 .82141 m
.41132 .05419 L
s
% Start of user PostScript
0.146447 0.853553 0.402455 0.00960736 MAarrowhead1
% End of user PostScript
.17859 .82141 m
.5 .04545 L
s
% Start of user PostScript
0.146447 0.853553 0.5 0 MAarrowhead1
% End of user PostScript
.12206 .75253 m
.58868 .05419 L
s
% Start of user PostScript
0.0842652 0.777785 0.597545 0.00960736 MAarrowhead1
% End of user PostScript
.12206 .75253 m
.67395 .08005 L
s
% Start of user PostScript
0.0842652 0.777785 0.691342 0.0380602 MAarrowhead1
% End of user PostScript
.08005 .67395 m
.75253 .12206 L
s
% Start of user PostScript
0.0380602 0.691342 0.777785 0.0842652 MAarrowhead1
% End of user PostScript
.08005 .67395 m
.82141 .17859 L
s
% Start of user PostScript
0.0380602 0.691342 0.853553 0.146447 MAarrowhead1
% End of user PostScript
.05419 .58868 m
.87794 .24747 L
s
% Start of user PostScript
0.00960736 0.597545 0.915735 0.222215 MAarrowhead1
% End of user PostScript
.05419 .58868 m
.91995 .32605 L
s
% Start of user PostScript
0.00960736 0.597545 0.96194 0.308658 MAarrowhead1
% End of user PostScript
.04545 .5 m
.94581 .41132 L
s
% Start of user PostScript
0 0.5 0.990393 0.402455 MAarrowhead1
% End of user PostScript
.04545 .5 m
.95455 .5 L
s
% Start of user PostScript
0 0.5 1. 0.5 MAarrowhead1
% End of user PostScript
.05419 .41132 m
.94581 .58868 L
s
% Start of user PostScript
0.00960736 0.402455 0.990393 0.597545 MAarrowhead1
% End of user PostScript
.05419 .41132 m
.91995 .67395 L
s
% Start of user PostScript
0.00960736 0.402455 0.96194 0.691342 MAarrowhead1
% End of user PostScript
.08005 .32605 m
.87794 .75253 L
s
% Start of user PostScript
0.0380602 0.308658 0.915735 0.777785 MAarrowhead1
% End of user PostScript
.08005 .32605 m
.82141 .82141 L
s
% Start of user PostScript
0.0380602 0.308658 0.853553 0.853553 MAarrowhead1
% End of user PostScript
.12206 .24747 m
.75253 .87794 L
s
% Start of user PostScript
0.0842652 0.222215 0.777785 0.915735 MAarrowhead1
% End of user PostScript
.12206 .24747 m
.67395 .91995 L
s
% Start of user PostScript
0.0842652 0.222215 0.691342 0.96194 MAarrowhead1
% End of user PostScript
.17859 .17859 m
.58868 .94581 L
s
% Start of user PostScript
0.146447 0.146447 0.597545 0.990393 MAarrowhead1
% End of user PostScript
.17859 .17859 m
.5 .95455 L
s
% Start of user PostScript
0.146447 0.146447 0.5 1. MAarrowhead1
% End of user PostScript
.24747 .12206 m
.41132 .94581 L
s
% Start of user PostScript
0.222215 0.0842652 0.402455 0.990393 MAarrowhead1
% End of user PostScript
.24747 .12206 m
.32605 .91995 L
s
% Start of user PostScript
0.222215 0.0842652 0.308658 0.96194 MAarrowhead1
% End of user PostScript
.32605 .08005 m
.24747 .87794 L
s
% Start of user PostScript
0.308658 0.0380602 0.222215 0.915735 MAarrowhead1
% End of user PostScript
.32605 .08005 m
.17859 .82141 L
s
% Start of user PostScript
0.308658 0.0380602 0.146447 0.853553 MAarrowhead1
% End of user PostScript
.41132 .05419 m
.12206 .75253 L
s
% Start of user PostScript
0.402455 0.00960736 0.0842652 0.777785 MAarrowhead1
% End of user PostScript
.41132 .05419 m
.08005 .67395 L
s
% Start of user PostScript
0.402455 0.00960736 0.0380602 0.691342 MAarrowhead1
% End of user PostScript
.5 .04545 m
.05419 .58868 L
s
% Start of user PostScript
0.5 0 0.00960736 0.597545 MAarrowhead1
% End of user PostScript
.5 .04545 m
.04545 .5 L
s
% Start of user PostScript
0.5 0 0 0.5 MAarrowhead1
% End of user PostScript
.58868 .05419 m
.05419 .41132 L
s
% Start of user PostScript
0.597545 0.00960736 0.00960736 0.402455 MAarrowhead1
% End of user PostScript
.58868 .05419 m
.08005 .32605 L
s
% Start of user PostScript
0.597545 0.00960736 0.0380602 0.308658 MAarrowhead1
% End of user PostScript
.67395 .08005 m
.12206 .24747 L
s
% Start of user PostScript
0.691342 0.0380602 0.0842652 0.222215 MAarrowhead1
% End of user PostScript
.67395 .08005 m
.17859 .17859 L
s
% Start of user PostScript
0.691342 0.0380602 0.146447 0.146447 MAarrowhead1
% End of user PostScript
.75253 .12206 m
.24747 .12206 L
s
% Start of user PostScript
0.777785 0.0842652 0.222215 0.0842652 MAarrowhead1
% End of user PostScript
.75253 .12206 m
.32605 .08005 L
s
% Start of user PostScript
0.777785 0.0842652 0.308658 0.0380602 MAarrowhead1
% End of user PostScript
.82141 .17859 m
.41132 .05419 L
s
% Start of user PostScript
0.853553 0.146447 0.402455 0.00960736 MAarrowhead1
% End of user PostScript
.82141 .17859 m
.5 .04545 L
s
% Start of user PostScript
0.853553 0.146447 0.5 0 MAarrowhead1
% End of user PostScript
.87794 .24747 m
.58868 .05419 L
s
% Start of user PostScript
0.915735 0.222215 0.597545 0.00960736 MAarrowhead1
% End of user PostScript
.87794 .24747 m
.67395 .08005 L
s
% Start of user PostScript
0.915735 0.222215 0.691342 0.0380602 MAarrowhead1
% End of user PostScript
.91995 .32605 m
.75253 .12206 L
s
% Start of user PostScript
0.96194 0.308658 0.777785 0.0842652 MAarrowhead1
% End of user PostScript
.91995 .32605 m
.82141 .17859 L
s
% Start of user PostScript
0.96194 0.308658 0.853553 0.146447 MAarrowhead1
% End of user PostScript
.94581 .41132 m
.87794 .24747 L
s
% Start of user PostScript
0.990393 0.402455 0.915735 0.222215 MAarrowhead1
% End of user PostScript
.94581 .41132 m
.91995 .32605 L
s
% Start of user PostScript
0.990393 0.402455 0.96194 0.308658 MAarrowhead1
% End of user PostScript
.95455 .5 m
.94581 .41132 L
s
% Start of user PostScript
1. 0.5 0.990393 0.402455 MAarrowhead1
% End of user PostScript
newpath
.97273 .51818 .02571 0 365.73 arc
s
.025 w
.94581 .58868 Mdot
.91995 .67395 Mdot
.87794 .75253 Mdot
.82141 .82141 Mdot
.75253 .87794 Mdot
.67395 .91995 Mdot
.58868 .94581 Mdot
.5 .95455 Mdot
.41132 .94581 Mdot
.32605 .91995 Mdot
.24747 .87794 Mdot
.17859 .82141 Mdot
.12206 .75253 Mdot
.08005 .67395 Mdot
.05419 .58868 Mdot
.04545 .5 Mdot
.05419 .41132 Mdot
.08005 .32605 Mdot
.12206 .24747 Mdot
.17859 .17859 Mdot
.24747 .12206 Mdot
.32605 .08005 Mdot
.41132 .05419 Mdot
.5 .04545 Mdot
.58868 .05419 Mdot
.67395 .08005 Mdot
.75253 .12206 Mdot
.82141 .17859 Mdot
.87794 .24747 Mdot
.91995 .32605 Mdot
.94581 .41132 Mdot
.95455 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[46]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Hypercubes", "TI"],
 " of dimension ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the graph product of cubes of dimension ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the complete graph ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Here, a Hamiltonian cycle of the hypercube is highlighted. Colored \
highlighting and graph animations are also provided in the package. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.58"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[ Highlight[Hypercube[4],
 {Partition[HamiltonianCycle[Hypercube[4]], 2, 1]}] ]\
\>", "Input",
 CellLabel->"In[47]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.02 w
[ ] 0 setdash
.04545 .52837 m
.1044 .41269 L
s
.005 w
.04545 .52837 m
.16114 .58731 L
s
.04545 .52837 m
.41269 .16114 L
s
.02 w
.04545 .52837 m
.41269 .8956 L
s
.1044 .41269 m
.22008 .47163 L
s
.005 w
.1044 .41269 m
.47163 .04545 L
s
.1044 .41269 m
.47163 .77992 L
s
.02 w
.22008 .47163 m
.16114 .58731 L
s
.005 w
.22008 .47163 m
.58731 .1044 L
s
.22008 .47163 m
.58731 .83886 L
s
.02 w
.16114 .58731 m
.52837 .22008 L
s
.005 w
.16114 .58731 m
.52837 .95455 L
s
.02 w
.41269 .16114 m
.47163 .04545 L
s
.41269 .16114 m
.52837 .22008 L
s
.005 w
.41269 .16114 m
.77992 .52837 L
s
.02 w
.47163 .04545 m
.58731 .1044 L
s
.005 w
.47163 .04545 m
.83886 .41269 L
s
.58731 .1044 m
.52837 .22008 L
s
.02 w
.58731 .1044 m
.95455 .47163 L
s
.005 w
.52837 .22008 m
.8956 .58731 L
s
.02 w
.77992 .52837 m
.83886 .41269 L
s
.77992 .52837 m
.8956 .58731 L
s
.005 w
.77992 .52837 m
.41269 .8956 L
s
.02 w
.83886 .41269 m
.95455 .47163 L
s
.005 w
.83886 .41269 m
.47163 .77992 L
s
.95455 .47163 m
.8956 .58731 L
s
.95455 .47163 m
.58731 .83886 L
s
.02 w
.8956 .58731 m
.52837 .95455 L
s
.41269 .8956 m
.47163 .77992 L
s
.005 w
.41269 .8956 m
.52837 .95455 L
s
.02 w
.47163 .77992 m
.58731 .83886 L
s
.58731 .83886 m
.52837 .95455 L
s
.025 w
.04545 .52837 Mdot
.1044 .41269 Mdot
.22008 .47163 Mdot
.16114 .58731 Mdot
.41269 .16114 Mdot
.47163 .04545 Mdot
.58731 .1044 Mdot
.52837 .22008 Mdot
.77992 .52837 Mdot
.83886 .41269 Mdot
.95455 .47163 Mdot
.8956 .58731 Mdot
.41269 .8956 Mdot
.47163 .77992 Mdot
.58731 .83886 Mdot
.52837 .95455 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[47]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "Several of the built\[Hyphen]in graph construction functions do not have \
parameters and only construct a single interesting graph. ",
 StyleBox["FiniteGraphs", "MR"],
 " collects them together in one list for convenient reference. ",
 StyleBox["ShowGraphArray", "MR"],
 " permits the display of multiple graphs in one window. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.59"}],

Cell[CellGroupData[{

Cell["ShowGraphArray[Partition[FiniteGraphs,5,5]]", "Input",
 CellLabel->"In[48]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.0238095 0.190476 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0238095 0.200176 0.200176 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0123746 0.975251 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.29372 .38072 m
.15732 .20573 L
s
.29372 .38072 m
.29372 .16442 L
s
.29372 .38072 m
.33518 .49968 L
s
.15732 .33941 m
.29372 .16442 L
s
.15732 .33941 m
.37801 .27257 L
s
.15732 .33941 m
.04876 .41293 L
s
.15732 .20573 m
.37801 .27257 L
s
.15732 .20573 m
.04876 .1322 L
s
.29372 .16442 m
.33518 .04545 L
s
.37801 .27257 m
.62199 .27257 L
s
.29372 .83558 m
.15732 .66059 L
s
.29372 .83558 m
.29372 .61928 L
s
.29372 .83558 m
.33518 .95455 L
s
.15732 .79427 m
.29372 .61928 L
s
.15732 .79427 m
.37801 .72743 L
s
.15732 .79427 m
.04876 .8678 L
s
.15732 .66059 m
.37801 .72743 L
s
.15732 .66059 m
.04876 .58707 L
s
.29372 .61928 m
.33518 .49968 L
s
.37801 .72743 m
.62199 .72743 L
s
.70628 .16442 m
.84268 .33941 L
s
.70628 .16442 m
.70628 .38072 L
s
.70628 .16442 m
.66482 .04545 L
s
.84268 .20573 m
.70628 .38072 L
s
.84268 .20573 m
.62199 .27257 L
s
.84268 .20573 m
.95124 .1322 L
s
.84268 .33941 m
.62199 .27257 L
s
.84268 .33941 m
.95124 .41293 L
s
.70628 .38072 m
.66482 .49968 L
s
.70628 .61928 m
.84268 .79427 L
s
.70628 .61928 m
.70628 .83558 L
s
.70628 .61928 m
.66482 .49968 L
s
.84268 .66059 m
.70628 .83558 L
s
.84268 .66059 m
.62199 .72743 L
s
.84268 .66059 m
.95124 .58707 L
s
.84268 .79427 m
.62199 .72743 L
s
.84268 .79427 m
.95124 .8678 L
s
.70628 .83558 m
.66482 .95455 L
s
.33518 .49968 m
.04876 .41293 L
s
.33518 .49968 m
.04876 .58707 L
s
.04876 .41293 m
.04876 .1322 L
s
.04876 .1322 m
.33518 .04545 L
s
.33518 .04545 m
.66482 .04545 L
s
.33518 .95455 m
.04876 .8678 L
s
.33518 .95455 m
.66482 .95455 L
s
.04876 .8678 m
.04876 .58707 L
s
.66482 .04545 m
.95124 .1322 L
s
.95124 .1322 m
.95124 .41293 L
s
.95124 .41293 m
.66482 .49968 L
s
.66482 .49968 m
.95124 .58707 L
s
.95124 .58707 m
.95124 .8678 L
s
.95124 .8678 m
.66482 .95455 L
s
.025 w
.29372 .38072 Mdot
.15732 .33941 Mdot
.15732 .20573 Mdot
.29372 .16442 Mdot
.37801 .27257 Mdot
.29372 .83558 Mdot
.15732 .79427 Mdot
.15732 .66059 Mdot
.29372 .61928 Mdot
.37801 .72743 Mdot
.70628 .16442 Mdot
.84268 .20573 Mdot
.84268 .33941 Mdot
.70628 .38072 Mdot
.62199 .27257 Mdot
.70628 .61928 Mdot
.84268 .66059 Mdot
.84268 .79427 Mdot
.70628 .83558 Mdot
.62199 .72743 Mdot
.33518 .49968 Mdot
.04876 .41293 Mdot
.04876 .1322 Mdot
.33518 .04545 Mdot
.33518 .95455 Mdot
.04876 .8678 Mdot
.04876 .58707 Mdot
.66482 .04545 Mdot
.95124 .1322 Mdot
.95124 .41293 Mdot
.66482 .49968 Mdot
.95124 .58707 Mdot
.95124 .8678 Mdot
.66482 .95455 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.217813 0.0238095 0.39418 0.200176 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 -0.0824621 1.03904 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.50653 .51707 m
.4468 .468 L
s
.50653 .51707 m
.50653 .60668 L
s
.50653 .51707 m
.5756 .45733 L
s
.29746 .94378 m
.49347 .94805 L
s
.29746 .94378 m
.04545 .4872 L
s
.29746 .94378 m
.33293 .88404 L
s
.49347 .94805 m
.66707 .94805 L
s
.49347 .94805 m
.49533 .88831 L
s
.66707 .94805 m
.95455 .54907 L
s
.66707 .94805 m
.61854 .84564 L
s
.95455 .54907 m
.83694 .29091 L
s
.95455 .54907 m
.86868 .532 L
s
.83694 .29091 m
.71934 .05409 L
s
.83694 .29091 m
.79214 .33145 L
s
.71934 .05409 m
.3348 .05195 L
s
.71934 .05409 m
.67267 .18423 L
s
.04545 .4872 m
.18172 .29945 L
s
.04545 .4872 m
.15186 .4872 L
s
.18172 .29945 m
.3348 .05195 L
s
.18172 .29945 m
.23399 .35065 L
s
.3348 .05195 m
.36653 .1821 L
s
.4468 .468 m
.34973 .47653 L
s
.4468 .468 m
.43 .40826 L
s
.50653 .60668 m
.45613 .67282 L
s
.50653 .60668 m
.5364 .67495 L
s
.5756 .45733 m
.60174 .40612 L
s
.5756 .45733 m
.6372 .47866 L
s
.34973 .47653 m
.34226 .42746 L
s
.34973 .47653 m
.15186 .4872 L
s
.43 .40826 m
.34226 .42746 L
s
.43 .40826 m
.40386 .32291 L
s
.34226 .42746 m
.29933 .40186 L
s
.29933 .40186 m
.33666 .33785 L
s
.29933 .40186 m
.22279 .42746 L
s
.33666 .33785 m
.40386 .32291 L
s
.33666 .33785 m
.28626 .29731 L
s
.40386 .32291 m
.36653 .1821 L
s
.33293 .88404 m
.3908 .76883 L
s
.33293 .88404 m
.40946 .87551 L
s
.22279 .42746 m
.15186 .4872 L
s
.22279 .42746 m
.23399 .35065 L
s
.23399 .35065 m
.28626 .29731 L
s
.28626 .29731 m
.36653 .1821 L
s
.3908 .76883 m
.45613 .67282 L
s
.3908 .76883 m
.4188 .81363 L
s
.45613 .67282 m
.4972 .71762 L
s
.61854 .84564 m
.5364 .67495 L
s
.61854 .84564 m
.542 .84564 L
s
.5364 .67495 m
.4972 .71762 L
s
.67267 .18423 m
.60174 .40612 L
s
.67267 .18423 m
.73241 .29304 L
s
.60174 .40612 m
.65214 .42533 L
s
.6372 .47866 m
.73987 .49787 L
s
.6372 .47866 m
.65214 .42533 L
s
.73987 .49787 m
.86868 .532 L
s
.73987 .49787 m
.75481 .43173 L
s
.86868 .532 m
.80894 .40612 L
s
.4972 .71762 m
.4972 .77736 L
s
.65214 .42533 m
.70254 .40612 L
s
.4972 .77736 m
.4188 .81363 L
s
.4972 .77736 m
.542 .84564 L
s
.70254 .40612 m
.75481 .43173 L
s
.70254 .40612 m
.73241 .29304 L
s
.4188 .81363 m
.40946 .87551 L
s
.542 .84564 m
.49533 .88831 L
s
.40946 .87551 m
.49533 .88831 L
s
.75481 .43173 m
.80894 .40612 L
s
.80894 .40612 m
.79214 .33145 L
s
.73241 .29304 m
.79214 .33145 L
s
.025 w
.50653 .51707 Mdot
.29746 .94378 Mdot
.49347 .94805 Mdot
.66707 .94805 Mdot
.95455 .54907 Mdot
.83694 .29091 Mdot
.71934 .05409 Mdot
.04545 .4872 Mdot
.18172 .29945 Mdot
.3348 .05195 Mdot
.4468 .468 Mdot
.50653 .60668 Mdot
.5756 .45733 Mdot
.34973 .47653 Mdot
.43 .40826 Mdot
.34226 .42746 Mdot
.29933 .40186 Mdot
.33666 .33785 Mdot
.40386 .32291 Mdot
.33293 .88404 Mdot
.22279 .42746 Mdot
.15186 .4872 Mdot
.23399 .35065 Mdot
.28626 .29731 Mdot
.36653 .1821 Mdot
.3908 .76883 Mdot
.45613 .67282 Mdot
.61854 .84564 Mdot
.5364 .67495 Mdot
.67267 .18423 Mdot
.60174 .40612 Mdot
.6372 .47866 Mdot
.73987 .49787 Mdot
.86868 .532 Mdot
.4972 .71762 Mdot
.65214 .42533 Mdot
.4972 .77736 Mdot
.70254 .40612 Mdot
.4188 .81363 Mdot
.542 .84564 Mdot
.40946 .87551 Mdot
.49533 .88831 Mdot
.75481 .43173 Mdot
.80894 .40612 Mdot
.73241 .29304 Mdot
.79214 .33145 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.411817 0.0238095 0.588183 0.200176 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0490982 0.981964 -0.394309 1.32791 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.43737 .9336 m
.56513 .9336 L
s
.43737 .9336 m
.57014 .44241 L
s
.43737 .9336 m
.32715 .76762 L
s
.43737 .9336 m
.0491 .69309 L
s
.56513 .9336 m
.43487 .44919 L
s
.56513 .9336 m
.68287 .771 L
s
.56513 .9336 m
.9509 .70664 L
s
.67786 .60163 m
.57014 .44241 L
s
.67786 .60163 m
.32715 .76762 L
s
.67786 .60163 m
.68287 .771 L
s
.67786 .60163 m
.9509 .70664 L
s
.67786 .60163 m
.61523 .07995 L
s
.57014 .44241 m
.43487 .44919 L
s
.57014 .44241 m
.43236 .0664 L
s
.43487 .44919 m
.32214 .59485 L
s
.43487 .44919 m
.61523 .07995 L
s
.32214 .59485 m
.32715 .76762 L
s
.32214 .59485 m
.68287 .771 L
s
.32214 .59485 m
.0491 .69309 L
s
.32214 .59485 m
.43236 .0664 L
s
.0491 .69309 m
.61523 .07995 L
s
.9509 .70664 m
.43236 .0664 L
s
.025 w
.43737 .9336 Mdot
.56513 .9336 Mdot
.67786 .60163 Mdot
.57014 .44241 Mdot
.43487 .44919 Mdot
.32214 .59485 Mdot
.32715 .76762 Mdot
.68287 .771 Mdot
.0491 .69309 Mdot
.9509 .70664 Mdot
.43236 .0664 Mdot
.61523 .07995 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.60582 0.0238095 0.782187 0.200176 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0242882 0.951424 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.86773 .77962 m
.64046 .95243 L
s
.86773 .77962 m
.95455 .5 L
s
.86773 .77962 m
.74516 .68641 L
s
.64046 .95243 m
.35954 .95243 L
s
.64046 .95243 m
.59364 .80162 L
s
.35954 .95243 m
.13227 .77962 L
s
.35954 .95243 m
.40636 .80162 L
s
.13227 .77962 m
.04545 .5 L
s
.13227 .77962 m
.25484 .68641 L
s
.04545 .5 m
.13227 .22038 L
s
.04545 .5 m
.19697 .5 L
s
.13227 .22038 m
.35954 .04757 L
s
.13227 .22038 m
.25484 .31359 L
s
.35954 .04757 m
.64046 .04757 L
s
.35954 .04757 m
.40636 .19838 L
s
.64046 .04757 m
.86773 .22038 L
s
.64046 .04757 m
.59364 .19838 L
s
.86773 .22038 m
.95455 .5 L
s
.86773 .22038 m
.74516 .31359 L
s
.95455 .5 m
.80303 .5 L
s
.74516 .68641 m
.25484 .68641 L
s
.74516 .68641 m
.59364 .19838 L
s
.59364 .80162 m
.19697 .5 L
s
.59364 .80162 m
.74516 .31359 L
s
.40636 .80162 m
.25484 .31359 L
s
.40636 .80162 m
.80303 .5 L
s
.25484 .68641 m
.40636 .19838 L
s
.19697 .5 m
.59364 .19838 L
s
.25484 .31359 m
.74516 .31359 L
s
.40636 .19838 m
.80303 .5 L
s
.025 w
.86773 .77962 Mdot
.64046 .95243 Mdot
.35954 .95243 Mdot
.13227 .77962 Mdot
.04545 .5 Mdot
.13227 .22038 Mdot
.35954 .04757 Mdot
.64046 .04757 Mdot
.86773 .22038 Mdot
.95455 .5 Mdot
.74516 .68641 Mdot
.59364 .80162 Mdot
.40636 .80162 Mdot
.25484 .68641 Mdot
.19697 .5 Mdot
.25484 .31359 Mdot
.40636 .19838 Mdot
.59364 .19838 Mdot
.74516 .31359 Mdot
.80303 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.799824 0.0238095 0.97619 0.200176 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 -0.0321728 0.987219 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.51218 .95064 m
.51218 .83605 L
s
.51218 .83605 m
.58117 .7413 L
s
.51218 .83605 m
.38433 .67078 L
s
.58117 .7413 m
.64002 .65095 L
s
.58117 .7413 m
.49391 .64434 L
s
.64002 .65095 m
.71307 .51432 L
s
.64002 .65095 m
.61567 .58043 L
s
.71307 .51432 m
.78003 .3799 L
s
.78003 .3799 m
.8612 .23006 L
s
.78003 .3799 m
.7151 .35787 L
s
.8612 .23006 m
.90179 .13751 L
s
.8612 .23006 m
.53044 .23006 L
s
.90179 .13751 m
.95455 .04936 L
s
.38433 .67078 m
.28084 .47907 L
s
.38433 .67078 m
.49391 .64434 L
s
.28084 .47907 m
.14286 .23006 L
s
.28084 .47907 m
.3539 .42618 L
s
.14286 .23006 m
.09416 .15954 L
s
.14286 .23006 m
.53044 .23006 L
s
.09416 .15954 m
.04545 .08242 L
s
.49391 .64434 m
.49391 .50331 L
s
.49391 .50331 m
.5832 .51212 L
s
.49391 .50331 m
.43506 .36007 L
s
.5832 .51212 m
.61567 .58043 L
s
.5832 .51212 m
.61769 .43279 L
s
.61769 .43279 m
.65016 .34905 L
s
.65016 .34905 m
.7151 .35787 L
s
.65016 .34905 m
.53044 .33363 L
s
.53044 .23006 m
.53044 .33363 L
s
.3539 .42618 m
.43506 .36007 L
s
.43506 .36007 m
.53044 .33363 L
s
.025 w
.51218 .95064 Mdot
.51218 .83605 Mdot
.58117 .7413 Mdot
.64002 .65095 Mdot
.71307 .51432 Mdot
.78003 .3799 Mdot
.8612 .23006 Mdot
.90179 .13751 Mdot
.38433 .67078 Mdot
.28084 .47907 Mdot
.14286 .23006 Mdot
.09416 .15954 Mdot
.04545 .08242 Mdot
.49391 .64434 Mdot
.49391 .50331 Mdot
.5832 .51212 Mdot
.61567 .58043 Mdot
.61769 .43279 Mdot
.65016 .34905 Mdot
.7151 .35787 Mdot
.53044 .23006 Mdot
.95455 .04936 Mdot
.3539 .42618 Mdot
.43506 .36007 Mdot
.53044 .33363 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.217813 0.200176 0.39418 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.1617 1.10638 0.0486285 0.97257 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.05532 .95137 m
.05532 .04863 L
s
.05532 .95137 m
.94468 .5 L
s
.05532 .95137 m
.15414 .5 L
s
.05532 .95137 m
.45059 .65046 L
s
.05532 .04863 m
.94468 .5 L
s
.05532 .04863 m
.15414 .5 L
s
.05532 .04863 m
.45059 .34954 L
s
.94468 .5 m
.45059 .34954 L
s
.94468 .5 m
.45059 .65046 L
s
.15414 .5 m
.45059 .34954 L
s
.15414 .5 m
.45059 .65046 L
s
.45059 .34954 m
.45059 .65046 L
s
.025 w
.05532 .95137 Mdot
.05532 .04863 Mdot
.94468 .5 Mdot
.15414 .5 Mdot
.45059 .34954 Mdot
.45059 .65046 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.217813 0.217813 0.39418 0.39418 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.52945 .72674 m
.25051 .35987 L
s
.52945 .72674 m
.52945 .27326 L
s
.52945 .72674 m
.60654 .95348 L
s
.25051 .64013 m
.52945 .27326 L
s
.25051 .64013 m
.70184 .5 L
s
.25051 .64013 m
.04868 .78027 L
s
.25051 .35987 m
.70184 .5 L
s
.25051 .35987 m
.04868 .21973 L
s
.52945 .27326 m
.60654 .04652 L
s
.70184 .5 m
.95132 .5 L
s
.60654 .95348 m
.04868 .78027 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .21973 m
.60654 .04652 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.52945 .72674 Mdot
.25051 .64013 Mdot
.25051 .35987 Mdot
.52945 .27326 Mdot
.70184 .5 Mdot
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.411817 0.217813 0.588183 0.39418 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0409905 0.913342 0.0455253 0.910507 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.92955 .64807 m
.85787 .7801 L
s
.92955 .64807 m
.4591 .95447 L
s
.92955 .64807 m
.74708 .11823 L
s
.92955 .64807 m
.95433 .5 L
s
.85787 .7801 m
.74708 .88177 L
s
.85787 .7801 m
.04567 .57506 L
s
.85787 .7801 m
.31312 .08238 L
s
.74708 .88177 m
.60918 .94208 L
s
.74708 .88177 m
.18706 .83551 L
s
.74708 .88177 m
.92955 .35193 L
s
.60918 .94208 m
.4591 .95447 L
s
.60918 .94208 m
.18706 .16449 L
s
.60918 .94208 m
.60918 .05792 L
s
.4591 .95447 m
.31312 .91762 L
s
.4591 .95447 m
.04567 .42494 L
s
.31312 .91762 m
.18706 .83551 L
s
.31312 .91762 m
.31312 .08238 L
s
.31312 .91762 m
.85787 .2199 L
s
.18706 .83551 m
.09456 .71705 L
s
.18706 .83551 m
.09456 .28295 L
s
.09456 .71705 m
.04567 .57506 L
s
.09456 .71705 m
.60918 .05792 L
s
.09456 .71705 m
.95433 .5 L
s
.04567 .57506 m
.04567 .42494 L
s
.04567 .57506 m
.85787 .2199 L
s
.04567 .42494 m
.09456 .28295 L
s
.04567 .42494 m
.4591 .04553 L
s
.09456 .28295 m
.18706 .16449 L
s
.09456 .28295 m
.74708 .11823 L
s
.18706 .16449 m
.31312 .08238 L
s
.18706 .16449 m
.95433 .5 L
s
.31312 .08238 m
.4591 .04553 L
s
.4591 .04553 m
.60918 .05792 L
s
.4591 .04553 m
.92955 .35193 L
s
.60918 .05792 m
.74708 .11823 L
s
.74708 .11823 m
.85787 .2199 L
s
.85787 .2199 m
.92955 .35193 L
s
.92955 .35193 m
.95433 .5 L
s
.025 w
.92955 .64807 Mdot
.85787 .7801 Mdot
.74708 .88177 Mdot
.60918 .94208 Mdot
.4591 .95447 Mdot
.31312 .91762 Mdot
.18706 .83551 Mdot
.09456 .71705 Mdot
.04567 .57506 Mdot
.04567 .42494 Mdot
.09456 .28295 Mdot
.18706 .16449 Mdot
.31312 .08238 Mdot
.4591 .04553 Mdot
.60918 .05792 Mdot
.74708 .11823 Mdot
.85787 .2199 Mdot
.92955 .35193 Mdot
.95433 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.60582 0.217813 0.782187 0.39418 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0504528 1.00906 -0.144654 1.09015 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.5 .86862 m
.16688 .22222 L
s
.5 .86862 m
.81695 .22222 L
s
.5 .86862 m
.3674 .942 L
s
.5 .86862 m
.63583 .94549 L
s
.5 .86862 m
.94955 .30957 L
s
.16688 .22222 m
.81695 .22222 L
s
.16688 .22222 m
.3674 .942 L
s
.16688 .22222 m
.16688 .05451 L
s
.16688 .22222 m
.05045 .29909 L
s
.81695 .22222 m
.94955 .30957 L
s
.81695 .22222 m
.81695 .05451 L
s
.81695 .22222 m
.16688 .05451 L
s
.3674 .942 m
.05045 .29909 L
s
.63583 .94549 m
.94955 .30957 L
s
.81695 .05451 m
.16688 .05451 L
s
.025 w
.5 .86862 Mdot
.16688 .22222 Mdot
.81695 .22222 Mdot
.3674 .942 Mdot
.63583 .94549 Mdot
.94955 .30957 Mdot
.81695 .05451 Mdot
.16688 .05451 Mdot
.05045 .29909 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.799824 0.217813 0.97619 0.39418 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.1617 1.10638 0.0486285 0.97257 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.05532 .95137 m
.05532 .04863 L
s
.05532 .95137 m
.94468 .5 L
s
.05532 .95137 m
.35177 .5 L
s
.05532 .04863 m
.94468 .5 L
s
.05532 .04863 m
.35177 .5 L
s
.94468 .5 m
.35177 .5 L
s
.025 w
.05532 .95137 Mdot
.05532 .04863 Mdot
.94468 .5 Mdot
.35177 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.411817 0.200176 0.588183 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0431795 0.913641 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.94461 .59498 m
.91525 .68581 L
s
.94461 .59498 m
.45249 .95432 L
s
.94461 .59498 m
.95455 .5 L
s
.91525 .68581 m
.86773 .76851 L
s
.91525 .68581 m
.72727 .10438 L
s
.86773 .76851 m
.80415 .83948 L
s
.86773 .76851 m
.13227 .76851 L
s
.80415 .83948 m
.72727 .89562 L
s
.80415 .83948 m
.08475 .31419 L
s
.72727 .89562 m
.64046 .93446 L
s
.72727 .89562 m
.45249 .04568 L
s
.64046 .93446 m
.54751 .95432 L
s
.64046 .93446 m
.86773 .23149 L
s
.54751 .95432 m
.45249 .95432 L
s
.54751 .95432 m
.05539 .59498 L
s
.45249 .95432 m
.35954 .93446 L
s
.35954 .93446 m
.27273 .89562 L
s
.35954 .93446 m
.13227 .23149 L
s
.27273 .89562 m
.19585 .83948 L
s
.27273 .89562 m
.54751 .04568 L
s
.19585 .83948 m
.13227 .76851 L
s
.19585 .83948 m
.91525 .31419 L
s
.13227 .76851 m
.08475 .68581 L
s
.08475 .68581 m
.05539 .59498 L
s
.08475 .68581 m
.27273 .10438 L
s
.05539 .59498 m
.04545 .5 L
s
.04545 .5 m
.05539 .40502 L
s
.04545 .5 m
.64046 .06554 L
s
.05539 .40502 m
.08475 .31419 L
s
.05539 .40502 m
.94461 .40502 L
s
.08475 .31419 m
.13227 .23149 L
s
.13227 .23149 m
.19585 .16052 L
s
.19585 .16052 m
.27273 .10438 L
s
.19585 .16052 m
.80415 .16052 L
s
.27273 .10438 m
.35954 .06554 L
s
.35954 .06554 m
.45249 .04568 L
s
.35954 .06554 m
.95455 .5 L
s
.45249 .04568 m
.54751 .04568 L
s
.54751 .04568 m
.64046 .06554 L
s
.64046 .06554 m
.72727 .10438 L
s
.72727 .10438 m
.80415 .16052 L
s
.80415 .16052 m
.86773 .23149 L
s
.86773 .23149 m
.91525 .31419 L
s
.91525 .31419 m
.94461 .40502 L
s
.94461 .40502 m
.95455 .5 L
s
.025 w
.94461 .59498 Mdot
.91525 .68581 Mdot
.86773 .76851 Mdot
.80415 .83948 Mdot
.72727 .89562 Mdot
.64046 .93446 Mdot
.54751 .95432 Mdot
.45249 .95432 Mdot
.35954 .93446 Mdot
.27273 .89562 Mdot
.19585 .83948 Mdot
.13227 .76851 Mdot
.08475 .68581 Mdot
.05539 .59498 Mdot
.04545 .5 Mdot
.05539 .40502 Mdot
.08475 .31419 Mdot
.13227 .23149 Mdot
.19585 .16052 Mdot
.27273 .10438 Mdot
.35954 .06554 Mdot
.45249 .04568 Mdot
.54751 .04568 Mdot
.64046 .06554 Mdot
.72727 .10438 Mdot
.80415 .16052 Mdot
.86773 .23149 Mdot
.91525 .31419 Mdot
.94461 .40502 Mdot
.95455 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.217813 0.411817 0.39418 0.588183 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.93906 .61765 m
.89365 .72727 L
s
.93906 .61765 m
.27273 .89365 L
s
.93906 .61765 m
.95455 .5 L
s
.89365 .72727 m
.82141 .82141 L
s
.89365 .72727 m
.61765 .06094 L
s
.82141 .82141 m
.72727 .89365 L
s
.82141 .82141 m
.17859 .17859 L
s
.72727 .89365 m
.61765 .93906 L
s
.72727 .89365 m
.06094 .61765 L
s
.61765 .93906 m
.5 .95455 L
s
.61765 .93906 m
.89365 .27273 L
s
.5 .95455 m
.38235 .93906 L
s
.5 .95455 m
.5 .04545 L
s
.38235 .93906 m
.27273 .89365 L
s
.38235 .93906 m
.10635 .27273 L
s
.27273 .89365 m
.17859 .82141 L
s
.17859 .82141 m
.10635 .72727 L
s
.17859 .82141 m
.82141 .17859 L
s
.10635 .72727 m
.06094 .61765 L
s
.10635 .72727 m
.38235 .06094 L
s
.06094 .61765 m
.04545 .5 L
s
.04545 .5 m
.06094 .38235 L
s
.04545 .5 m
.95455 .5 L
s
.06094 .38235 m
.10635 .27273 L
s
.06094 .38235 m
.72727 .10635 L
s
.10635 .27273 m
.17859 .17859 L
s
.17859 .17859 m
.27273 .10635 L
s
.27273 .10635 m
.38235 .06094 L
s
.27273 .10635 m
.93906 .38235 L
s
.38235 .06094 m
.5 .04545 L
s
.5 .04545 m
.61765 .06094 L
s
.61765 .06094 m
.72727 .10635 L
s
.72727 .10635 m
.82141 .17859 L
s
.82141 .17859 m
.89365 .27273 L
s
.89365 .27273 m
.93906 .38235 L
s
.93906 .38235 m
.95455 .5 L
s
.025 w
.93906 .61765 Mdot
.89365 .72727 Mdot
.82141 .82141 Mdot
.72727 .89365 Mdot
.61765 .93906 Mdot
.5 .95455 Mdot
.38235 .93906 Mdot
.27273 .89365 Mdot
.17859 .82141 Mdot
.10635 .72727 Mdot
.06094 .61765 Mdot
.04545 .5 Mdot
.06094 .38235 Mdot
.10635 .27273 Mdot
.17859 .17859 Mdot
.27273 .10635 Mdot
.38235 .06094 Mdot
.5 .04545 Mdot
.61765 .06094 Mdot
.72727 .10635 Mdot
.82141 .17859 Mdot
.89365 .27273 Mdot
.93906 .38235 Mdot
.95455 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.411817 0.411817 0.588183 0.588183 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0480036 0.960071 0.0367377 0.917393 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.52131 .25344 m
.51367 .30189 L
s
.52131 .25344 m
.47006 .31543 L
s
.52131 .25344 m
.42644 .32897 L
s
.52131 .25344 m
.77466 .58665 L
s
.47769 .26698 m
.51367 .30189 L
s
.47769 .26698 m
.47006 .31543 L
s
.47769 .26698 m
.42644 .32897 L
s
.47769 .26698 m
.41898 .09432 L
s
.43408 .28052 m
.51367 .30189 L
s
.43408 .28052 m
.47006 .31543 L
s
.43408 .28052 m
.42644 .32897 L
s
.43408 .28052 m
.37537 .10786 L
s
.39046 .29406 m
.51367 .30189 L
s
.39046 .29406 m
.47006 .31543 L
s
.39046 .29406 m
.42644 .32897 L
s
.39046 .29406 m
.39046 .70594 L
s
.77466 .41335 m
.72408 .42138 L
s
.77466 .41335 m
.69713 .38593 L
s
.77466 .41335 m
.67017 .35048 L
s
.77466 .41335 m
.52131 .74656 L
s
.74771 .3779 m
.72408 .42138 L
s
.74771 .3779 m
.69713 .38593 L
s
.74771 .3779 m
.67017 .35048 L
s
.74771 .3779 m
.90142 .27119 L
s
.72075 .34244 m
.72408 .42138 L
s
.72075 .34244 m
.69713 .38593 L
s
.72075 .34244 m
.67017 .35048 L
s
.72075 .34244 m
.87446 .23573 L
s
.69379 .30699 m
.72408 .42138 L
s
.69379 .30699 m
.69713 .38593 L
s
.69379 .30699 m
.67017 .35048 L
s
.69379 .30699 m
.28386 .43427 L
s
.69379 .69301 m
.67017 .64952 L
s
.69379 .69301 m
.69713 .61407 L
s
.69379 .69301 m
.72408 .57862 L
s
.69379 .69301 m
.28386 .56573 L
s
.72075 .65756 m
.67017 .64952 L
s
.72075 .65756 m
.69713 .61407 L
s
.72075 .65756 m
.72408 .57862 L
s
.72075 .65756 m
.87446 .76427 L
s
.74771 .6221 m
.67017 .64952 L
s
.74771 .6221 m
.69713 .61407 L
s
.74771 .6221 m
.72408 .57862 L
s
.74771 .6221 m
.90142 .72881 L
s
.77466 .58665 m
.67017 .64952 L
s
.77466 .58665 m
.69713 .61407 L
s
.77466 .58665 m
.72408 .57862 L
s
.39046 .70594 m
.42644 .67103 L
s
.39046 .70594 m
.47006 .68457 L
s
.39046 .70594 m
.51367 .69811 L
s
.43408 .71948 m
.42644 .67103 L
s
.43408 .71948 m
.47006 .68457 L
s
.43408 .71948 m
.51367 .69811 L
s
.43408 .71948 m
.37537 .89214 L
s
.47769 .73302 m
.42644 .67103 L
s
.47769 .73302 m
.47006 .68457 L
s
.47769 .73302 m
.51367 .69811 L
s
.47769 .73302 m
.41898 .90568 L
s
.52131 .74656 m
.42644 .67103 L
s
.52131 .74656 m
.47006 .68457 L
s
.52131 .74656 m
.51367 .69811 L
s
.28386 .43427 m
.32972 .45618 L
s
.28386 .43427 m
.32972 .5 L
s
.28386 .43427 m
.32972 .54382 L
s
.28386 .47809 m
.32972 .45618 L
s
.28386 .47809 m
.32972 .5 L
s
.28386 .47809 m
.32972 .54382 L
s
.28386 .47809 m
.09386 .47809 L
s
.28386 .52191 m
.32972 .45618 L
s
.28386 .52191 m
.32972 .5 L
s
.28386 .52191 m
.32972 .54382 L
s
.28386 .52191 m
.09386 .52191 L
s
.28386 .56573 m
.32972 .45618 L
s
.28386 .56573 m
.32972 .5 L
s
.28386 .56573 m
.32972 .54382 L
s
.4626 .91922 m
.42662 .95413 L
s
.4626 .91922 m
.383 .94059 L
s
.4626 .91922 m
.33939 .92705 L
s
.4626 .91922 m
.8475 .79972 L
s
.41898 .90568 m
.42662 .95413 L
s
.41898 .90568 m
.383 .94059 L
s
.41898 .90568 m
.33939 .92705 L
s
.37537 .89214 m
.42662 .95413 L
s
.37537 .89214 m
.383 .94059 L
s
.37537 .89214 m
.33939 .92705 L
s
.33175 .8786 m
.42662 .95413 L
s
.33175 .8786 m
.383 .94059 L
s
.33175 .8786 m
.33939 .92705 L
s
.33175 .8786 m
.09386 .56573 L
s
.09386 .56573 m
.048 .54382 L
s
.09386 .56573 m
.048 .5 L
s
.09386 .56573 m
.048 .45618 L
s
.09386 .52191 m
.048 .54382 L
s
.09386 .52191 m
.048 .5 L
s
.09386 .52191 m
.048 .45618 L
s
.09386 .47809 m
.048 .54382 L
s
.09386 .47809 m
.048 .5 L
s
.09386 .47809 m
.048 .45618 L
s
.09386 .43427 m
.048 .54382 L
s
.09386 .43427 m
.048 .5 L
s
.09386 .43427 m
.048 .45618 L
s
.09386 .43427 m
.33175 .1214 L
s
.33175 .1214 m
.33939 .07295 L
s
.33175 .1214 m
.383 .05941 L
s
.33175 .1214 m
.42662 .04587 L
s
.37537 .10786 m
.33939 .07295 L
s
.37537 .10786 m
.383 .05941 L
s
.37537 .10786 m
.42662 .04587 L
s
.41898 .09432 m
.33939 .07295 L
s
.41898 .09432 m
.383 .05941 L
s
.41898 .09432 m
.42662 .04587 L
s
.4626 .08078 m
.33939 .07295 L
s
.4626 .08078 m
.383 .05941 L
s
.4626 .08078 m
.42662 .04587 L
s
.4626 .08078 m
.8475 .20028 L
s
.8475 .20028 m
.89808 .19225 L
s
.8475 .20028 m
.92504 .2277 L
s
.8475 .20028 m
.952 .26315 L
s
.87446 .23573 m
.89808 .19225 L
s
.87446 .23573 m
.92504 .2277 L
s
.87446 .23573 m
.952 .26315 L
s
.90142 .27119 m
.89808 .19225 L
s
.90142 .27119 m
.92504 .2277 L
s
.90142 .27119 m
.952 .26315 L
s
.92837 .30664 m
.89808 .19225 L
s
.92837 .30664 m
.92504 .2277 L
s
.92837 .30664 m
.952 .26315 L
s
.92837 .30664 m
.92837 .69336 L
s
.92837 .69336 m
.952 .73685 L
s
.92837 .69336 m
.92504 .7723 L
s
.92837 .69336 m
.89808 .80775 L
s
.90142 .72881 m
.952 .73685 L
s
.90142 .72881 m
.92504 .7723 L
s
.90142 .72881 m
.89808 .80775 L
s
.87446 .76427 m
.952 .73685 L
s
.87446 .76427 m
.92504 .7723 L
s
.87446 .76427 m
.89808 .80775 L
s
.8475 .79972 m
.952 .73685 L
s
.8475 .79972 m
.92504 .7723 L
s
.8475 .79972 m
.89808 .80775 L
s
.025 w
.52131 .25344 Mdot
.47769 .26698 Mdot
.43408 .28052 Mdot
.39046 .29406 Mdot
.51367 .30189 Mdot
.47006 .31543 Mdot
.42644 .32897 Mdot
.77466 .41335 Mdot
.74771 .3779 Mdot
.72075 .34244 Mdot
.69379 .30699 Mdot
.72408 .42138 Mdot
.69713 .38593 Mdot
.67017 .35048 Mdot
.69379 .69301 Mdot
.72075 .65756 Mdot
.74771 .6221 Mdot
.77466 .58665 Mdot
.67017 .64952 Mdot
.69713 .61407 Mdot
.72408 .57862 Mdot
.39046 .70594 Mdot
.43408 .71948 Mdot
.47769 .73302 Mdot
.52131 .74656 Mdot
.42644 .67103 Mdot
.47006 .68457 Mdot
.51367 .69811 Mdot
.28386 .43427 Mdot
.28386 .47809 Mdot
.28386 .52191 Mdot
.28386 .56573 Mdot
.32972 .45618 Mdot
.32972 .5 Mdot
.32972 .54382 Mdot
.4626 .91922 Mdot
.41898 .90568 Mdot
.37537 .89214 Mdot
.33175 .8786 Mdot
.42662 .95413 Mdot
.383 .94059 Mdot
.33939 .92705 Mdot
.09386 .56573 Mdot
.09386 .52191 Mdot
.09386 .47809 Mdot
.09386 .43427 Mdot
.048 .54382 Mdot
.048 .5 Mdot
.048 .45618 Mdot
.33175 .1214 Mdot
.37537 .10786 Mdot
.41898 .09432 Mdot
.4626 .08078 Mdot
.33939 .07295 Mdot
.383 .05941 Mdot
.42662 .04587 Mdot
.8475 .20028 Mdot
.87446 .23573 Mdot
.90142 .27119 Mdot
.92837 .30664 Mdot
.89808 .19225 Mdot
.92504 .2277 Mdot
.952 .26315 Mdot
.92837 .69336 Mdot
.90142 .72881 Mdot
.87446 .76427 Mdot
.8475 .79972 Mdot
.952 .73685 Mdot
.92504 .7723 Mdot
.89808 .80775 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.60582 0.411817 0.782187 0.588183 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0462869 0.925738 -0.0352113 0.985915 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.07477 .86403 m
.2233 .94637 L
s
.07477 .86403 m
.2233 .86403 L
s
.07477 .86403 m
.21719 .78169 L
s
.4532 .9377 m
.3413 .85103 L
s
.4532 .9377 m
.48983 .85103 L
s
.45117 .75135 m
.3413 .85103 L
s
.45117 .75135 m
.48983 .85103 L
s
.3413 .85103 m
.48983 .85103 L
s
.48983 .85103 m
.56104 .78602 L
s
.78077 .9507 m
.64446 .73835 L
s
.78077 .9507 m
.79095 .8662 L
s
.78077 .9507 m
.93133 .73835 L
s
.75229 .77952 m
.64446 .73835 L
s
.75229 .77952 m
.79095 .8662 L
s
.75229 .77952 m
.93133 .73835 L
s
.64446 .73835 m
.79095 .8662 L
s
.64446 .73835 m
.93133 .73835 L
s
.79095 .8662 m
.93133 .73835 L
s
.22126 .70802 m
.05036 .70802 L
s
.05036 .70802 m
.21109 .60184 L
s
.05036 .70802 m
.11546 .60184 L
s
.21109 .60184 m
.11546 .60184 L
s
.21109 .60184 m
.04629 .48267 L
s
.11546 .60184 m
.04629 .48267 L
s
.04629 .48267 m
.21719 .48267 L
s
.42065 .68202 m
.33113 .56501 L
s
.42065 .68202 m
.51221 .56501 L
s
.42065 .68202 m
.42065 .61484 L
s
.33113 .56501 m
.51221 .56501 L
s
.33113 .56501 m
.42065 .61484 L
s
.33113 .56501 m
.41862 .4675 L
s
.51221 .56501 m
.42065 .61484 L
s
.51221 .56501 m
.41862 .4675 L
s
.41862 .4675 m
.51017 .4675 L
s
.95371 .53034 m
.81129 .66035 L
s
.95371 .53034 m
.81129 .39599 L
s
.95371 .53034 m
.87436 .53034 L
s
.81129 .66035 m
.81129 .39599 L
s
.81129 .66035 m
.87436 .53034 L
s
.81129 .66035 m
.75229 .539 L
s
.81129 .66035 m
.66277 .539 L
s
.81129 .39599 m
.87436 .53034 L
s
.81129 .39599 m
.75229 .539 L
s
.81129 .39599 m
.66277 .539 L
s
.75229 .539 m
.66277 .539 L
s
.1297 .36349 m
.06663 .23781 L
s
.1297 .36349 m
.18871 .23781 L
s
.1297 .36349 m
.26195 .36349 L
s
.12157 .10563 m
.06663 .23781 L
s
.12157 .10563 m
.18871 .23781 L
s
.12157 .10563 m
.26195 .10347 L
s
.06663 .23781 m
.18871 .23781 L
s
.26195 .36349 m
.26195 .10347 L
s
.82146 .31365 m
.82146 .18797 L
s
.82146 .31365 m
.9293 .22914 L
s
.82146 .31365 m
.70956 .22698 L
s
.82146 .18797 m
.9293 .22914 L
s
.82146 .18797 m
.88657 .07963 L
s
.82146 .18797 m
.75229 .07963 L
s
.82146 .18797 m
.70956 .22698 L
s
.9293 .22914 m
.88657 .07963 L
s
.88657 .07963 m
.75229 .07963 L
s
.75229 .07963 m
.70956 .22698 L
s
.48779 .38516 m
.39827 .28982 L
s
.48779 .38516 m
.57731 .28982 L
s
.39827 .28982 m
.57731 .28982 L
s
.39827 .28982 m
.39827 .14464 L
s
.57731 .28982 m
.39827 .14464 L
s
.57731 .28982 m
.57731 .14464 L
s
.39827 .14464 m
.57731 .14464 L
s
.39827 .14464 m
.48779 .0493 L
s
.57731 .14464 m
.48779 .0493 L
s
.025 w
.07477 .86403 Mdot
.2233 .94637 Mdot
.2233 .86403 Mdot
.21719 .78169 Mdot
.4532 .9377 Mdot
.45117 .75135 Mdot
.3413 .85103 Mdot
.48983 .85103 Mdot
.56104 .78602 Mdot
.78077 .9507 Mdot
.75229 .77952 Mdot
.64446 .73835 Mdot
.79095 .8662 Mdot
.93133 .73835 Mdot
.22126 .70802 Mdot
.05036 .70802 Mdot
.21109 .60184 Mdot
.11546 .60184 Mdot
.04629 .48267 Mdot
.21719 .48267 Mdot
.42065 .68202 Mdot
.33113 .56501 Mdot
.51221 .56501 Mdot
.42065 .61484 Mdot
.41862 .4675 Mdot
.51017 .4675 Mdot
.95371 .53034 Mdot
.81129 .66035 Mdot
.81129 .39599 Mdot
.87436 .53034 Mdot
.75229 .539 Mdot
.66277 .539 Mdot
.1297 .36349 Mdot
.12157 .10563 Mdot
.06663 .23781 Mdot
.18871 .23781 Mdot
.26195 .36349 Mdot
.26195 .10347 Mdot
.82146 .31365 Mdot
.82146 .18797 Mdot
.9293 .22914 Mdot
.88657 .07963 Mdot
.75229 .07963 Mdot
.70956 .22698 Mdot
.48779 .38516 Mdot
.39827 .28982 Mdot
.57731 .28982 Mdot
.39827 .14464 Mdot
.57731 .14464 Mdot
.48779 .0493 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.799824 0.411817 0.97619 0.588183 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0489927 0.979853 -0.0966325 1.04441 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.33974 .94778 m
.66255 .94778 L
s
.33974 .94778 m
.33974 .73792 L
s
.33974 .94778 m
.66255 .73792 L
s
.66255 .94778 m
.33974 .73792 L
s
.66255 .94778 m
.66255 .73792 L
s
.33974 .73792 m
.66255 .73792 L
s
.33974 .73792 m
.5 .65739 L
s
.66255 .73792 m
.5 .65739 L
s
.5 .65739 m
.5 .49146 L
s
.5 .49146 m
.6076 .37677 L
s
.5 .49146 m
.37866 .37677 L
s
.6076 .37677 m
.81593 .37677 L
s
.6076 .37677 m
.6076 .18887 L
s
.37866 .37677 m
.20009 .37677 L
s
.37866 .37677 m
.38782 .19863 L
s
.20009 .37677 m
.38782 .19863 L
s
.20009 .37677 m
.24359 .0693 L
s
.20009 .37677 m
.04899 .26452 L
s
.38782 .19863 m
.24359 .0693 L
s
.38782 .19863 m
.04899 .26452 L
s
.24359 .0693 m
.04899 .26452 L
s
.81593 .37677 m
.6076 .18887 L
s
.81593 .37677 m
.74038 .05222 L
s
.81593 .37677 m
.95101 .24988 L
s
.6076 .18887 m
.74038 .05222 L
s
.6076 .18887 m
.95101 .24988 L
s
.74038 .05222 m
.95101 .24988 L
s
.025 w
.33974 .94778 Mdot
.66255 .94778 Mdot
.33974 .73792 Mdot
.66255 .73792 Mdot
.5 .65739 Mdot
.5 .49146 Mdot
.6076 .37677 Mdot
.37866 .37677 Mdot
.20009 .37677 Mdot
.38782 .19863 Mdot
.24359 .0693 Mdot
.04899 .26452 Mdot
.81593 .37677 Mdot
.6076 .18887 Mdot
.74038 .05222 Mdot
.95101 .24988 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.60582 0.200176 0.782187 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0482353 0.964706 -0.277448 1.21662 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.38941 .93917 m
.58706 .93917 L
s
.38941 .93917 m
.38941 .69881 L
s
.38941 .93917 m
.04824 .28042 L
s
.58706 .93917 m
.58706 .69585 L
s
.58706 .93917 m
.95176 .26558 L
s
.38941 .69881 m
.22706 .40504 L
s
.38941 .69881 m
.69059 .21513 L
s
.58706 .69585 m
.78 .40504 L
s
.58706 .69585 m
.30706 .21513 L
s
.22706 .40504 m
.78 .40504 L
s
.22706 .40504 m
.04824 .28042 L
s
.78 .40504 m
.95176 .26558 L
s
.04824 .28042 m
.15176 .06083 L
s
.95176 .26558 m
.84588 .06083 L
s
.15176 .06083 m
.84588 .06083 L
s
.15176 .06083 m
.30706 .21513 L
s
.84588 .06083 m
.69059 .21513 L
s
.69059 .21513 m
.30706 .21513 L
s
.025 w
.38941 .93917 Mdot
.58706 .93917 Mdot
.38941 .69881 Mdot
.58706 .69585 Mdot
.22706 .40504 Mdot
.78 .40504 Mdot
.04824 .28042 Mdot
.95176 .26558 Mdot
.15176 .06083 Mdot
.84588 .06083 Mdot
.69059 .21513 Mdot
.30706 .21513 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.217813 0.60582 0.39418 0.782187 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0619224 1.23845 -0.345124 1.28107 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.48336 .93595 m
.09519 .77533 L
s
.48336 .93595 m
.93808 .71415 L
s
.48336 .93595 m
.54991 .69503 L
s
.09519 .77533 m
.3244 .58795 L
s
.09519 .77533 m
.06192 .38528 L
s
.93808 .71415 m
.91959 .46941 L
s
.93808 .71415 m
.71257 .49618 L
s
.3244 .58795 m
.45749 .52294 L
s
.3244 .58795 m
.06192 .38528 L
s
.45749 .52294 m
.45749 .3088 L
s
.45749 .52294 m
.54991 .69503 L
s
.91959 .46941 m
.81978 .0717 L
s
.91959 .46941 m
.71257 .49618 L
s
.06192 .38528 m
.22828 .06405 L
s
.22828 .06405 m
.45749 .3088 L
s
.22828 .06405 m
.81978 .0717 L
s
.45749 .3088 m
.81978 .0717 L
s
.71257 .49618 m
.54991 .69503 L
s
.025 w
.48336 .93595 Mdot
.09519 .77533 Mdot
.93808 .71415 Mdot
.3244 .58795 Mdot
.45749 .52294 Mdot
.91959 .46941 Mdot
.06192 .38528 Mdot
.22828 .06405 Mdot
.45749 .3088 Mdot
.81978 .0717 Mdot
.71257 .49618 Mdot
.54991 .69503 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.411817 0.60582 0.588183 0.782187 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0609221 1.21844 -0.364222 1.29926 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.47439 .93504 m
.06092 .59949 L
s
.47439 .93504 m
.93908 .58389 L
s
.47439 .93504 m
.7232 .54877 L
s
.47439 .93504 m
.23289 .56048 L
s
.06092 .59949 m
.22558 .06496 L
s
.06092 .59949 m
.47073 .75556 L
s
.06092 .59949 m
.32803 .25224 L
s
.93908 .58389 m
.73783 .06496 L
s
.93908 .58389 m
.47073 .75556 L
s
.93908 .58389 m
.62806 .24834 L
s
.22558 .06496 m
.73783 .06496 L
s
.22558 .06496 m
.62806 .24834 L
s
.22558 .06496 m
.23289 .56048 L
s
.73783 .06496 m
.7232 .54877 L
s
.73783 .06496 m
.32803 .25224 L
s
.47073 .49805 m
.47073 .75556 L
s
.47073 .49805 m
.7232 .54877 L
s
.47073 .49805 m
.62806 .24834 L
s
.47073 .49805 m
.32803 .25224 L
s
.47073 .49805 m
.23289 .56048 L
s
.025 w
.47439 .93504 Mdot
.06092 .59949 Mdot
.93908 .58389 Mdot
.22558 .06496 Mdot
.73783 .06496 Mdot
.47073 .49805 Mdot
.47073 .75556 Mdot
.7232 .54877 Mdot
.62806 .24834 Mdot
.32803 .25224 Mdot
.23289 .56048 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.60582 0.60582 0.782187 0.782187 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0394003 0.916083 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.87512 .75434 m
.78244 .85499 L
s
.87512 .75434 m
.08562 .69472 L
s
.87512 .75434 m
.95455 .49487 L
s
.78244 .85499 m
.53161 .9542 L
s
.78244 .85499 m
.66444 .0661 L
s
.53161 .9542 m
.39573 .94394 L
s
.53161 .9542 m
.08562 .29502 L
s
.39573 .94394 m
.16237 .80817 L
s
.39573 .94394 m
.93424 .3591 L
s
.16237 .80817 m
.08562 .69472 L
s
.16237 .80817 m
.39573 .0458 L
s
.08562 .69472 m
.04545 .42622 L
s
.04545 .42622 m
.08562 .29502 L
s
.04545 .42622 m
.78244 .13475 L
s
.08562 .29502 m
.2689 .09597 L
s
.2689 .09597 m
.39573 .0458 L
s
.2689 .09597 m
.95455 .49487 L
s
.39573 .0458 m
.66444 .0661 L
s
.66444 .0661 m
.78244 .13475 L
s
.78244 .13475 m
.93424 .3591 L
s
.93424 .3591 m
.95455 .49487 L
s
.025 w
.87512 .75434 Mdot
.78244 .85499 Mdot
.53161 .9542 Mdot
.39573 .94394 Mdot
.16237 .80817 Mdot
.08562 .69472 Mdot
.04545 .42622 Mdot
.08562 .29502 Mdot
.2689 .09597 Mdot
.39573 .0458 Mdot
.66444 .0661 Mdot
.78244 .13475 Mdot
.93424 .3591 Mdot
.95455 .49487 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.799824 0.60582 0.97619 0.782187 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 -0.163702 1.37872 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.49436 .93106 m
.95455 .52737 L
s
.49436 .93106 m
.04545 .52395 L
s
.49436 .93106 m
.44248 .63342 L
s
.49436 .93106 m
.53948 .64369 L
s
.4921 .06894 m
.95455 .52737 L
s
.4921 .06894 m
.04545 .52395 L
s
.4921 .06894 m
.44924 .40079 L
s
.4921 .06894 m
.54624 .39394 L
s
.95455 .52737 m
.71769 .52737 L
s
.04545 .52395 m
.26201 .52395 L
s
.44248 .63342 m
.4921 .51368 L
s
.44248 .63342 m
.26201 .52395 L
s
.53948 .64369 m
.4921 .51368 L
s
.53948 .64369 m
.71769 .52737 L
s
.44924 .40079 m
.4921 .51368 L
s
.44924 .40079 m
.26201 .52395 L
s
.54624 .39394 m
.4921 .51368 L
s
.54624 .39394 m
.71769 .52737 L
s
.025 w
.49436 .93106 Mdot
.4921 .06894 Mdot
.95455 .52737 Mdot
.04545 .52395 Mdot
.44248 .63342 Mdot
.53948 .64369 Mdot
.44924 .40079 Mdot
.54624 .39394 Mdot
.4921 .51368 Mdot
.26201 .52395 Mdot
.71769 .52737 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.799824 0.200176 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0465153 0.930307 -0.0221976 0.973522 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.27326 .52945 m
.21973 .04868 L
s
.27326 .52945 m
.5 .95132 L
s
.27326 .52945 m
.42848 .45235 L
s
.27326 .52945 m
.57152 .45235 L
s
.35987 .25051 m
.64013 .25051 L
s
.35987 .25051 m
.04652 .60654 L
s
.35987 .25051 m
.78027 .04868 L
s
.35987 .25051 m
.42848 .45235 L
s
.64013 .25051 m
.21973 .04868 L
s
.64013 .25051 m
.95348 .60654 L
s
.64013 .25051 m
.57152 .45235 L
s
.72674 .52945 m
.78027 .04868 L
s
.72674 .52945 m
.5 .95132 L
s
.72674 .52945 m
.42848 .45235 L
s
.72674 .52945 m
.57152 .45235 L
s
.5 .70184 m
.04652 .60654 L
s
.5 .70184 m
.95348 .60654 L
s
.5 .70184 m
.42848 .45235 L
s
.5 .70184 m
.57152 .45235 L
s
.04652 .60654 m
.21973 .04868 L
s
.04652 .60654 m
.5 .95132 L
s
.21973 .04868 m
.78027 .04868 L
s
.78027 .04868 m
.95348 .60654 L
s
.95348 .60654 m
.5 .95132 L
s
.025 w
.27326 .52945 Mdot
.35987 .25051 Mdot
.64013 .25051 Mdot
.72674 .52945 Mdot
.5 .70184 Mdot
.04652 .60654 Mdot
.21973 .04868 Mdot
.78027 .04868 Mdot
.95348 .60654 Mdot
.5 .95132 Mdot
.42848 .45235 Mdot
.57152 .45235 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.217813 0.799824 0.39418 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0540309 1.08062 -0.15445 1.09948 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.43384 .94503 m
.53431 .94503 L
s
.43384 .94503 m
.37748 .87273 L
s
.43384 .94503 m
.11529 .57105 L
s
.53431 .94503 m
.59802 .87273 L
s
.53431 .94503 m
.87736 .58103 L
s
.37748 .87273 m
.40444 .79294 L
s
.37748 .87273 m
.25251 .56856 L
s
.40444 .79294 m
.4902 .7381 L
s
.40444 .79294 m
.36278 .56607 L
s
.59802 .87273 m
.56371 .79045 L
s
.59802 .87273 m
.73524 .55111 L
s
.56371 .79045 m
.4902 .7381 L
s
.56371 .79045 m
.60782 .5561 L
s
.4902 .7381 m
.4902 .5536 L
s
.11529 .57105 m
.10794 .12727 L
s
.11529 .57105 m
.80385 .05497 L
s
.25251 .56856 m
.05403 .20456 L
s
.25251 .56856 m
.73279 .13475 L
s
.36278 .56607 m
.12999 .27936 L
s
.36278 .56607 m
.71073 .23697 L
s
.4902 .5536 m
.2084 .27686 L
s
.4902 .5536 m
.74749 .30678 L
s
.60782 .5561 m
.26476 .20456 L
s
.60782 .5561 m
.85285 .2993 L
s
.73524 .55111 m
.22556 .12977 L
s
.73524 .55111 m
.94597 .227 L
s
.87736 .58103 m
.16675 .06495 L
s
.87736 .58103 m
.90676 .12478 L
s
.12999 .27936 m
.22556 .12977 L
s
.12999 .27936 m
.16675 .06495 L
s
.2084 .27686 m
.16675 .06495 L
s
.2084 .27686 m
.10794 .12727 L
s
.26476 .20456 m
.10794 .12727 L
s
.26476 .20456 m
.05403 .20456 L
s
.22556 .12977 m
.05403 .20456 L
s
.74749 .30678 m
.73279 .13475 L
s
.74749 .30678 m
.94597 .227 L
s
.71073 .23697 m
.80385 .05497 L
s
.71073 .23697 m
.85285 .2993 L
s
.73279 .13475 m
.90676 .12478 L
s
.80385 .05497 m
.94597 .227 L
s
.90676 .12478 m
.85285 .2993 L
s
.025 w
.43384 .94503 Mdot
.53431 .94503 Mdot
.37748 .87273 Mdot
.40444 .79294 Mdot
.59802 .87273 Mdot
.56371 .79045 Mdot
.4902 .7381 Mdot
.11529 .57105 Mdot
.25251 .56856 Mdot
.36278 .56607 Mdot
.4902 .5536 Mdot
.60782 .5561 Mdot
.73524 .55111 Mdot
.87736 .58103 Mdot
.12999 .27936 Mdot
.2084 .27686 Mdot
.26476 .20456 Mdot
.22556 .12977 Mdot
.16675 .06495 Mdot
.10794 .12727 Mdot
.05403 .20456 Mdot
.74749 .30678 Mdot
.71073 .23697 Mdot
.73279 .13475 Mdot
.80385 .05497 Mdot
.90676 .12478 Mdot
.94597 .227 Mdot
.85285 .2993 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.411817 0.799824 0.588183 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.5 .72727 m
.27273 .5 L
s
.5 .72727 m
.72727 .5 L
s
.5 .72727 m
.5 .95455 L
s
.27273 .5 m
.5 .27273 L
s
.27273 .5 m
.04545 .5 L
s
.5 .27273 m
.72727 .5 L
s
.5 .27273 m
.5 .04545 L
s
.72727 .5 m
.95455 .5 L
s
.5 .95455 m
.04545 .5 L
s
.5 .95455 m
.95455 .5 L
s
.04545 .5 m
.5 .04545 L
s
.5 .04545 m
.95455 .5 L
s
.025 w
.5 .72727 Mdot
.27273 .5 Mdot
.5 .27273 Mdot
.72727 .5 Mdot
.5 .95455 Mdot
.04545 .5 Mdot
.5 .04545 Mdot
.95455 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.60582 0.799824 0.782187 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 -0.00211168 0.990145 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.47846 .95049 m
.04545 .59151 L
s
.47846 .95049 m
.95455 .58681 L
s
.47846 .95049 m
.48492 .7839 L
s
.04545 .59151 m
.24149 .04951 L
s
.04545 .59151 m
.17471 .55162 L
s
.24149 .04951 m
.74774 .04951 L
s
.24149 .04951 m
.32551 .17621 L
s
.74774 .04951 m
.95455 .58681 L
s
.74774 .04951 m
.70034 .17855 L
s
.95455 .58681 m
.80159 .561 L
s
.48492 .7839 m
.35351 .64078 L
s
.48492 .7839 m
.62495 .64078 L
s
.17471 .55162 m
.35351 .64078 L
s
.17471 .55162 m
.28242 .39676 L
s
.32551 .17621 m
.5 .24894 L
s
.32551 .17621 m
.28242 .39676 L
s
.70034 .17855 m
.70681 .40615 L
s
.70034 .17855 m
.5 .24894 L
s
.80159 .561 m
.62495 .64078 L
s
.80159 .561 m
.70681 .40615 L
s
.35351 .64078 m
.43322 .53519 L
s
.62495 .64078 m
.54524 .53519 L
s
.70681 .40615 m
.57324 .42726 L
s
.5 .24894 m
.5 .34984 L
s
.28242 .39676 m
.40737 .42726 L
s
.43322 .53519 m
.54524 .53519 L
s
.43322 .53519 m
.40737 .42726 L
s
.54524 .53519 m
.57324 .42726 L
s
.57324 .42726 m
.5 .34984 L
s
.5 .34984 m
.40737 .42726 L
s
.025 w
.47846 .95049 Mdot
.04545 .59151 Mdot
.24149 .04951 Mdot
.74774 .04951 Mdot
.95455 .58681 Mdot
.48492 .7839 Mdot
.17471 .55162 Mdot
.32551 .17621 Mdot
.70034 .17855 Mdot
.80159 .561 Mdot
.35351 .64078 Mdot
.62495 .64078 Mdot
.70681 .40615 Mdot
.5 .24894 Mdot
.28242 .39676 Mdot
.43322 .53519 Mdot
.54524 .53519 Mdot
.57324 .42726 Mdot
.5 .34984 Mdot
.40737 .42726 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.799824 0.799824 0.97619 0.97619 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0477782 0.955564 -0.0797715 1.02835 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.4882 .86818 m
.58848 .52328 L
s
.4882 .86818 m
.87357 .52751 L
s
.4882 .86818 m
.40562 .52539 L
s
.4882 .86818 m
.13822 .52539 L
s
.48624 .78565 m
.79493 .52328 L
s
.48624 .78565 m
.95222 .52539 L
s
.48624 .78565 m
.2326 .52751 L
s
.48624 .78565 m
.04778 .5127 L
s
.48624 .70736 m
.69072 .52751 L
s
.48624 .70736 m
.87357 .52751 L
s
.48624 .70736 m
.33681 .52328 L
s
.48624 .70736 m
.13822 .52539 L
s
.49214 .62273 m
.58848 .52328 L
s
.49214 .62273 m
.79493 .52328 L
s
.49214 .62273 m
.40562 .52539 L
s
.49214 .62273 m
.2326 .52751 L
s
.48624 .94858 m
.69072 .52751 L
s
.48624 .94858 m
.95222 .52539 L
s
.48624 .94858 m
.33681 .52328 L
s
.48624 .94858 m
.04778 .5127 L
s
.58848 .52328 m
.49803 .41536 L
s
.58848 .52328 m
.49803 .05142 L
s
.69072 .52751 m
.49803 .41536 L
s
.69072 .52751 m
.49214 .30322 L
s
.79493 .52328 m
.49214 .30322 L
s
.79493 .52328 m
.49607 .21646 L
s
.87357 .52751 m
.49607 .21646 L
s
.87357 .52751 m
.49214 .12759 L
s
.95222 .52539 m
.49214 .12759 L
s
.95222 .52539 m
.49803 .05142 L
s
.40562 .52539 m
.49803 .41536 L
s
.40562 .52539 m
.49803 .05142 L
s
.33681 .52328 m
.49803 .41536 L
s
.33681 .52328 m
.49214 .30322 L
s
.2326 .52751 m
.49214 .30322 L
s
.2326 .52751 m
.49607 .21646 L
s
.13822 .52539 m
.49607 .21646 L
s
.13822 .52539 m
.49214 .12759 L
s
.04778 .5127 m
.49214 .12759 L
s
.04778 .5127 m
.49803 .05142 L
s
.025 w
.4882 .86818 Mdot
.48624 .78565 Mdot
.48624 .70736 Mdot
.49214 .62273 Mdot
.48624 .94858 Mdot
.58848 .52328 Mdot
.69072 .52751 Mdot
.79493 .52328 Mdot
.87357 .52751 Mdot
.95222 .52539 Mdot
.40562 .52539 Mdot
.33681 .52328 Mdot
.2326 .52751 Mdot
.13822 .52539 Mdot
.04778 .5127 Mdot
.49803 .41536 Mdot
.49214 .30322 Mdot
.49607 .21646 Mdot
.49214 .12759 Mdot
.49803 .05142 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "GraphicsArray", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[48]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["BooleanAlgebra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ButterflyGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CageGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CartesianProduct",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ChvatalGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CirculantGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CodeToLabeledTree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CompleteBinaryTree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CompleteGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CompleteKPartiteGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CompleteKaryTree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CoxeterGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CubeConnectedCycle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CubicalGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cycle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DeBruijnGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DodecahedralGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EmptyGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ExactRandomGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ExpandGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FiniteGraphs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FolkmanGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FranklinGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FruchtGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FunctionalGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GeneralizedPetersenGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GraphComplement",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GraphDifference",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GraphIntersection",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GraphJoin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GraphPower",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GraphProduct",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GraphSum",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GraphUnion",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GridGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GrotztschGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Harary",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HasseDiagram",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["HeawoodGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HerschelGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Hypercube",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["IcosahedralGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["IntervalGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["KnightsTourGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LabeledTreeToCode",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["LeviGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LineGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ListGraphs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MakeGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["McGeeGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MeredithGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MycielskiGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NoPerfectMatchingGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NonLineGraphs",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["OctahedralGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["OddGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["OrientGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Path",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PermutationGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PetersenGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RandomGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RandomTree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RealizeDegreeSequence",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RegularGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RobertsonGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ShuffleExchangeGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SmallestCyclicGroupGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Star",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TetrahedralGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ThomassenGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TransitiveClosure",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TransitiveReduction",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Turan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TutteGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Uniquely3ColorableGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UnitransitiveGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexConnectivityGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["WaltherGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Wheel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for graph constructors."
}], "Caption",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties of Graphs", "Subsubsection",
 CellTags->{"S5.18.1", "1.60"}],

Cell["\<\
Graph theory is the study of properties or invariants of graphs. Among the \
properties of interest are such things as connectivity, cycle structure, and \
chromatic number. Here we demonstrate how to compute several different graph \
invariants. \
\>", "Text",
 CellTags->{"S5.18.1", "1.61"}],

Cell["\<\
An undirected graph is connected if a path exists between any pair of \
vertices. Deleting an edge from a connected graph can disconnect it. Such an \
edge is called a bridge. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.62"}],

Cell[CellGroupData[{

Cell["ConnectedQ[ DeleteEdge[ Star[10], {1,10} ] ]", "Input",
 CellLabel->"In[49]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[49]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["GraphUnion", "MR"],
 " can be used to create disconnected graphs. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.63"}],

Cell[CellGroupData[{

Cell["\<\
ConnectedComponents[ GraphUnion[CompleteGraph[3],
        CompleteGraph[4]] ]\
\>", "Input",
 CellLabel->"In[50]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[50]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "An orientation of an undirected graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is an assignment of exactly one direction to each of the edges of ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Note that arrows denoting the direction of each edge are automatically \
drawn in displaying directed graphs. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.64"}],

Cell[CellGroupData[{

Cell["ShowGraph[ OrientGraph[Wheel[10]] ]", "Input",
 CellLabel->"In[51]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0253138 0.928273 0.0457731 0.915461 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
.005 w
[ ] 0 setdash
.84417 .79648 m
.56711 .95423 L
s
% Start of user PostScript
0.882127 0.820027 0.583662 0.992346 MAarrowhead1
% End of user PostScript
.56711 .95423 m
.25205 .89944 L
s
% Start of user PostScript
0.583662 0.992346 0.244259 0.9325 MAarrowhead1
% End of user PostScript
.56711 .95423 m
.4859 .5 L
s
% Start of user PostScript
0.583662 0.992346 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.25205 .89944 m
.04641 .65775 L
s
% Start of user PostScript
0.244259 0.9325 0.0227302 0.668492 MAarrowhead1
% End of user PostScript
.25205 .89944 m
.4859 .5 L
s
% Start of user PostScript
0.244259 0.9325 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.04641 .65775 m
.04641 .34225 L
s
% Start of user PostScript
0.0227302 0.668492 0.0227302 0.323854 MAarrowhead1
% End of user PostScript
.04641 .65775 m
.4859 .5 L
s
% Start of user PostScript
0.0227302 0.668492 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.04641 .34225 m
.25205 .10056 L
s
% Start of user PostScript
0.0227302 0.323854 0.244259 0.0598458 MAarrowhead1
% End of user PostScript
.04641 .34225 m
.4859 .5 L
s
% Start of user PostScript
0.0227302 0.323854 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.25205 .10056 m
.56711 .04577 L
s
% Start of user PostScript
0.244259 0.0598458 0.583662 0 MAarrowhead1
% End of user PostScript
.25205 .10056 m
.4859 .5 L
s
% Start of user PostScript
0.244259 0.0598458 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.56711 .04577 m
.84417 .20352 L
s
% Start of user PostScript
0.583662 0 0.882127 0.172319 MAarrowhead1
% End of user PostScript
.56711 .04577 m
.4859 .5 L
s
% Start of user PostScript
0.583662 0 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.84417 .20352 m
.95359 .5 L
s
% Start of user PostScript
0.882127 0.172319 1. 0.496173 MAarrowhead1
% End of user PostScript
.84417 .20352 m
.4859 .5 L
s
% Start of user PostScript
0.882127 0.172319 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.95359 .5 m
.84417 .79648 L
s
% Start of user PostScript
1. 0.496173 0.882127 0.820027 MAarrowhead1
% End of user PostScript
.95359 .5 m
.4859 .5 L
s
% Start of user PostScript
1. 0.496173 0.496173 0.496173 MAarrowhead1
% End of user PostScript
.4859 .5 m
.84417 .79648 L
s
% Start of user PostScript
0.496173 0.496173 0.882127 0.820027 MAarrowhead1
% End of user PostScript
.025 w
.84417 .79648 Mdot
.56711 .95423 Mdot
.25205 .89944 Mdot
.04641 .65775 Mdot
.04641 .34225 Mdot
.25205 .10056 Mdot
.56711 .04577 Mdot
.84417 .20352 Mdot
.95359 .5 Mdot
.4859 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[51]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "An articulation vertex of a graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a vertex whose deletion disconnects ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Any graph with no articulation vertices is said to be biconnected. A \
graph with a vertex of degree 1 cannot be biconnected, since deleting the \
other vertex that defines its only edge disconnects the graph. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.65"}],

Cell[CellGroupData[{

Cell["\<\
BiconnectedComponents[
        RealizeDegreeSequence[{4,4,3,3,3,2,1}] ]\
\>", "Input",
 CellLabel->"In[52]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[52]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The only articulation vertex of a star is its center, even though its \
deletion leaves ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " connected components. Deleting a leaf leaves a connected tree. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.66"}],

Cell[CellGroupData[{

Cell["ArticulationVertices[ Star[10] ]", "Input",
 CellLabel->"In[53]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", "10", "}"}]], "Output",
 CellLabel->"Out[53]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["Every edge in a tree is a bridge. ", "MathCaption",
 CellTags->{"S5.18.1", "1.67"}],

Cell[CellGroupData[{

Cell["Bridges[ RandomTree[10] ]", "Input",
 CellLabel->"In[54]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[54]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A graph is said to be ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]connected if there does not exist a set of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["k",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " vertices whose removal disconnects the graph. The wheel is the basic \
triconnected graph. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.68"}],

Cell[CellGroupData[{

Cell["VertexConnectivity[Wheel[10]]", "Input",
 CellLabel->"In[55]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[55]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A graph is ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]edge\[Hyphen]connected if there does not exist a set of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["k",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " edges whose removal disconnects the graph. The edge connectivity of a \
graph is at most the minimum degree ",
 Cell[BoxData[
  FormBox["\[Delta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", since deleting those edges disconnects the graph. Complete bipartite \
graphs realize this bound. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.69"}],

Cell[CellGroupData[{

Cell["EdgeConnectivity[CompleteGraph[3,4]]", "Input",
 CellLabel->"In[56]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[56]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
These two complete bipartite graphs are isomorphic, since the order of the \
two stages is simply reversed. Here, all isomorphisms are returned. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.70"}],

Cell[CellGroupData[{

Cell["Isomorphism[CompleteGraph[3,2], CompleteGraph[2,3], All]", "Input",
 CellLabel->"In[57]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "4", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "5", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "5", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "3", ",", "2", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[57]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
A graph is self\[Hyphen]complementary if it is isomorphic to its complement. \
The smallest nontrivial self\[Hyphen]complementary graphs are the path on \
four vertices and the cycle on five. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.71"}],

Cell[CellGroupData[{

Cell["\<\
SelfComplementaryQ[ Cycle[5] ] &&
        SelfComplementaryQ[ Path[4] ]\
\>", "Input",
 CellLabel->"In[58]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[58]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
A directed graph in which half the possible edges exist is almost certain to \
contain a cycle. Directed acyclic graphs are often called DAGs. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.72"}],

Cell[CellGroupData[{

Cell["\<\
AcyclicQ[
        RandomGraph[100, 0.5, Type -> Directed]
]\
\>", "Input",
 CellLabel->"In[59]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[59]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The girth of a graph is the length of its shortest cycle. A cage is the \
smallest possible regular graph (here degree 3) that has a prescribed girth. \
\
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.73"}],

Cell[CellGroupData[{

Cell["Girth[ CageGraph[3, 6] ]", "Input",
 CellLabel->"In[60]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["6"], "Output",
 CellLabel->"Out[60]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
An Eulerian cycle is a complete tour of all the edges of a graph. An Eulerian \
cycle of a bipartite graph bounces back and forth between the stages. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.74"}],

Cell[CellGroupData[{

Cell["EulerianCycle[ CompleteGraph[4,4] ]", "Input",
 CellLabel->"In[61]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7", ",", "2", ",", "8", ",", "1", ",", "5", ",", "4", ",", "6", ",", "3", 
   ",", "7", ",", "4", ",", "8", ",", "3", ",", "5", ",", "2", ",", "6", ",", 
   "1", ",", "7"}], "}"}]], "Output",
 CellLabel->"Out[61]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AcyclicQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AntiSymmetricQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["BiconnectedQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["BipartiteQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CliqueQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CompleteQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ConnectedQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EmptyQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["EquivalenceRelationQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EulerianQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GraphicQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HamiltonianQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["IdenticalQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["IndependentSetQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["IsomorphicQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["IsomorphismQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MultipleEdgesQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PartialOrderQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PerfectQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PlanarQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PseudographQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ReflexiveQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RegularQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SelfComplementaryQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SelfLoopsQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SimpleQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SymmetricQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TransitiveQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TreeIsomorphismQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TreeQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TriangleInequalityQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UndirectedQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["UnweightedQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VertexCoverQ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for graph predicates."
}], "Caption",
 CellTags->"S5.18.1"],

Cell[TextData[{
 "A Hamiltonian cycle of a graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a cycle that visits every vertex in ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " exactly once, as opposed to an Eulerian cycle that visits each edge \
exactly once. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], 
    RowBox[{
     StyleBox["n",
      "TI"], ",", 
     StyleBox["n",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], ">", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the only Hamiltonian complete bipartite graphs. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.75"}],

Cell[CellGroupData[{

Cell["HamiltonianCycle[CompleteGraph[3,3], All]", "Input",
 CellLabel->"In[62]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3", ",", "6", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "6", ",", "3", ",", "5", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "5", ",", "2", ",", "6", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "6", ",", "2", ",", "5", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "2", ",", "4", ",", "3", ",", "6", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "2", ",", "6", ",", "3", ",", "4", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "3", ",", "4", ",", "2", ",", "6", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "3", ",", "6", ",", "2", ",", "4", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6", ",", "2", ",", "4", ",", "3", ",", "5", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6", ",", "2", ",", "5", ",", "3", ",", "4", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6", ",", "3", ",", "4", ",", "2", ",", "5", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6", ",", "3", ",", "5", ",", "2", ",", "4", ",", "1"}],
     "}"}]}], "}"}]], "Output",
 CellLabel->"Out[62]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The divisibility relation between integers is reflexive, since each integer \
divides itself, and anti\[Hyphen]symmetric, since ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " cannot divide ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], ">", 
    StyleBox["y",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Finally, it is transitive, as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "\[Backslash]", 
    StyleBox["y",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " implies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], "=", 
    StyleBox["c",
     "TI"], " ", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for some integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], "\[Backslash]", 
    StyleBox["z",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " implies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "\[Backslash]", 
    StyleBox["z",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.76"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[
        g = MakeGraph[Range[8],(Mod[#1,#2]==0)&],
        VertexNumber -> True
]\
\>", "Input",
 CellLabel->"In[63]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
.005 w
[ ] 0 setdash
newpath
.83959 .83959 .02571 0 365.73 arc
s
.5 .95455 m
.82141 .82141 L
s
% Start of user PostScript
0.5 1. 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.51818 .97273 .02571 0 365.73 arc
s
.17859 .82141 m
.82141 .82141 L
s
% Start of user PostScript
0.146447 0.853553 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.19677 .83959 .02571 0 365.73 arc
s
.04545 .5 m
.82141 .82141 L
s
% Start of user PostScript
0 0.5 0.853553 0.853553 MAarrowhead1
% End of user PostScript
.04545 .5 m
.5 .95455 L
s
% Start of user PostScript
0 0.5 0.5 1. MAarrowhead1
% End of user PostScript
newpath
.06364 .51818 .02571 0 365.73 arc
s
.17859 .17859 m
.82141 .82141 L
s
% Start of user PostScript
0.146447 0.146447 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.19677 .19677 .02571 0 365.73 arc
s
.5 .04545 m
.82141 .82141 L
s
% Start of user PostScript
0.5 0 0.853553 0.853553 MAarrowhead1
% End of user PostScript
.5 .04545 m
.5 .95455 L
s
% Start of user PostScript
0.5 0 0.5 1. MAarrowhead1
% End of user PostScript
.5 .04545 m
.17859 .82141 L
s
% Start of user PostScript
0.5 0 0.146447 0.853553 MAarrowhead1
% End of user PostScript
newpath
.51818 .06364 .02571 0 365.73 arc
s
.82141 .17859 m
.82141 .82141 L
s
% Start of user PostScript
0.853553 0.146447 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.83959 .19677 .02571 0 365.73 arc
s
.95455 .5 m
.82141 .82141 L
s
% Start of user PostScript
1. 0.5 0.853553 0.853553 MAarrowhead1
% End of user PostScript
.95455 .5 m
.5 .95455 L
s
% Start of user PostScript
1. 0.5 0.5 1. MAarrowhead1
% End of user PostScript
.95455 .5 m
.04545 .5 L
s
% Start of user PostScript
1. 0.5 0 0.5 MAarrowhead1
% End of user PostScript
newpath
.97273 .51818 .02571 0 365.73 arc
s
.025 w
.82141 .82141 Mdot
[(1)] .80141 .80141 1 0 Mshowa
.5 .95455 Mdot
[(2)] .48 .93455 1 0 Mshowa
.17859 .82141 Mdot
[(3)] .15859 .80141 1 0 Mshowa
.04545 .5 Mdot
[(4)] .02545 .48 1 0 Mshowa
.17859 .17859 Mdot
[(5)] .15859 .15859 1 0 Mshowa
.5 .04545 Mdot
[(6)] .48 .02545 1 0 Mshowa
.82141 .17859 Mdot
[(7)] .80141 .15859 1 0 Mshowa
.95455 .5 Mdot
[(8)] .93455 .48 1 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[63]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
Since the divisibility relation is reflexive, transitive, and \
anti\[Hyphen]symmetric, it is a partial order. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.77"}],

Cell[CellGroupData[{

Cell["PartialOrderQ[g]", "Input",
 CellLabel->"In[64]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[64]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is transitive if any three vertices ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], ",", 
    StyleBox["y",
     "TI"], ",", 
    StyleBox["z",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", such that edges ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x",
       "TI"], ",", 
      StyleBox["y",
       "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y",
       "TI"], ",", 
      StyleBox["z",
       "TI"]}], "}"}], "\[Element]", 
    StyleBox["G",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", imply ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x",
       "TI"], ",", 
      StyleBox["z",
       "TI"]}], "}"}], "\[Element]", 
    StyleBox["G",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The transitive reduction of a graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the smallest graph ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["R",
     "TI"], 
    RowBox[{"(", 
     StyleBox["G",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["C",
     "TI"], 
    RowBox[{"(", 
     StyleBox["G",
      "TI"], ")"}], "=", 
    StyleBox["C",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["R",
       "TI"], 
      RowBox[{"(", 
       StyleBox["G",
        "TI"], ")"}]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The transitive reduction eliminates all implied edges in the divisibility \
relation, such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Backslash]", "8"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[Backslash]", "4"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[Backslash]", "6"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "\[Backslash]", "8"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.78"}],

Cell[CellGroupData[{

Cell["ShowGraph[TransitiveReduction[g], VertexNumber -> True]", "Input",
 CellLabel->"In[65]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
.005 w
[ ] 0 setdash
newpath
.83959 .83959 .02571 0 365.73 arc
s
.5 .95455 m
.82141 .82141 L
s
% Start of user PostScript
0.5 1. 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.51818 .97273 .02571 0 365.73 arc
s
.17859 .82141 m
.82141 .82141 L
s
% Start of user PostScript
0.146447 0.853553 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.19677 .83959 .02571 0 365.73 arc
s
.04545 .5 m
.5 .95455 L
s
% Start of user PostScript
0 0.5 0.5 1. MAarrowhead1
% End of user PostScript
newpath
.06364 .51818 .02571 0 365.73 arc
s
.17859 .17859 m
.82141 .82141 L
s
% Start of user PostScript
0.146447 0.146447 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.19677 .19677 .02571 0 365.73 arc
s
.5 .04545 m
.5 .95455 L
s
% Start of user PostScript
0.5 0 0.5 1. MAarrowhead1
% End of user PostScript
.5 .04545 m
.17859 .82141 L
s
% Start of user PostScript
0.5 0 0.146447 0.853553 MAarrowhead1
% End of user PostScript
newpath
.51818 .06364 .02571 0 365.73 arc
s
.82141 .17859 m
.82141 .82141 L
s
% Start of user PostScript
0.853553 0.146447 0.853553 0.853553 MAarrowhead1
% End of user PostScript
newpath
.83959 .19677 .02571 0 365.73 arc
s
.95455 .5 m
.04545 .5 L
s
% Start of user PostScript
1. 0.5 0 0.5 MAarrowhead1
% End of user PostScript
newpath
.97273 .51818 .02571 0 365.73 arc
s
.025 w
.82141 .82141 Mdot
[(1)] .80141 .80141 1 0 Mshowa
.5 .95455 Mdot
[(2)] .48 .93455 1 0 Mshowa
.17859 .82141 Mdot
[(3)] .15859 .80141 1 0 Mshowa
.04545 .5 Mdot
[(4)] .02545 .48 1 0 Mshowa
.17859 .17859 Mdot
[(5)] .15859 .15859 1 0 Mshowa
.5 .04545 Mdot
[(6)] .48 .02545 1 0 Mshowa
.82141 .17859 Mdot
[(7)] .80141 .15859 1 0 Mshowa
.95455 .5 Mdot
[(8)] .93455 .48 1 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[65]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
The Hasse diagram clearly shows the lattice structure of the Boolean algebra, \
the partial order defined by inclusion on the set of subsets. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.79"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[
  HasseDiagram[MakeGraph[Subsets[4],
  ((Intersection[#2,#1]===#1)&&(#1 != #2))&]]
]\
\>", "Input",
 CellLabel->"In[66]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0652174 1.30435 -0.657895 1.57895 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.5 .07895 m
.23913 .28947 L
s
.5 .07895 m
.41304 .28947 L
s
.5 .07895 m
.58696 .28947 L
s
.5 .07895 m
.76087 .28947 L
s
.23913 .28947 m
.06522 .5 L
s
.23913 .28947 m
.41304 .5 L
s
.23913 .28947 m
.93478 .5 L
s
.06522 .5 m
.41304 .28947 L
s
.06522 .5 m
.23913 .71053 L
s
.06522 .5 m
.76087 .71053 L
s
.41304 .28947 m
.23913 .5 L
s
.41304 .28947 m
.76087 .5 L
s
.23913 .5 m
.23913 .71053 L
s
.23913 .5 m
.58696 .28947 L
s
.23913 .5 m
.58696 .71053 L
s
.23913 .71053 m
.41304 .5 L
s
.23913 .71053 m
.5 .92105 L
s
.41304 .5 m
.58696 .28947 L
s
.41304 .5 m
.41304 .71053 L
s
.58696 .28947 m
.58696 .5 L
s
.58696 .5 m
.41304 .71053 L
s
.58696 .5 m
.58696 .71053 L
s
.58696 .5 m
.76087 .28947 L
s
.41304 .71053 m
.5 .92105 L
s
.41304 .71053 m
.93478 .5 L
s
.5 .92105 m
.58696 .71053 L
s
.5 .92105 m
.76087 .71053 L
s
.58696 .71053 m
.76087 .5 L
s
.76087 .5 m
.76087 .71053 L
s
.76087 .5 m
.76087 .28947 L
s
.76087 .71053 m
.93478 .5 L
s
.93478 .5 m
.76087 .28947 L
s
.025 w
.5 .07895 Mdot
.23913 .28947 Mdot
.06522 .5 Mdot
.41304 .28947 Mdot
.23913 .5 Mdot
.23913 .71053 Mdot
.41304 .5 Mdot
.58696 .28947 Mdot
.58696 .5 Mdot
.41304 .71053 Mdot
.5 .92105 Mdot
.58696 .71053 Mdot
.76087 .5 Mdot
.76087 .71053 Mdot
.93478 .5 Mdot
.76087 .28947 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[66]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A topological sort is a permutation ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of the vertices of a graph such that an edge ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["i",
      "TI"], ",", 
     StyleBox["j",
      "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " implies ",
 Cell[BoxData[
  FormBox[
   StyleBox["i",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " appears before ",
 Cell[BoxData[
  FormBox[
   StyleBox["j",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". A complete directed acyclic graph defines a total order, so there is only \
one possible output from ",
 StyleBox["TopologicalSort", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.80"}],

Cell[CellGroupData[{

Cell["\<\
TopologicalSort[
        MakeGraph[Range[10],(#1 > #2)&] ]\
\>", "Input",
 CellLabel->"In[67]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "9", ",", "8", ",", "7", ",", "6", ",", "5", ",", "4", ",", "3", 
   ",", "2", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[67]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "Any labeled graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be colored in a certain number of ways with exactly ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " colors ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", ",", "\[Ellipsis]", ",", 
    StyleBox["k",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This number is determined by the chromatic polynomial of the graph. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.81"}],

Cell[CellGroupData[{

Cell["\<\
ChromaticPolynomial[
        GraphUnion[CompleteGraph[2,2], Cycle[3]], z ]\
\>", "Input",
 CellLabel->"In[68]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "6"}], " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"21", " ", 
   SuperscriptBox["z", "3"]}], "-", 
  RowBox[{"29", " ", 
   SuperscriptBox["z", "4"]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["z", "5"]}], "-", 
  RowBox[{"7", " ", 
   SuperscriptBox["z", "6"]}], "+", 
  SuperscriptBox["z", "7"]}]], "Output",
 CellLabel->"Out[68]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["ArticulationVertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Automorphisms",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["BiconnectedComponents",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bridges",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ChromaticNumber",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ChromaticPolynomial",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ConnectedComponents",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DegreeSequence",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Degrees",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DegreesOf2Neighborhood",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Diameter",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Distances",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Eccentricity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EdgeChromaticNumber",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["EdgeColoring",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EdgeConnectivity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Equivalences",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EulerianCycle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Girth",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GraphCenter",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GraphPolynomial",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["HamiltonianCycle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["InDegree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Isomorphism",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["M",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MaximalMatching",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MaximumAntichain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MaximumClique",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MaximumIndependentSet",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MaximumSpanningTree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MinimumChainPartition",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MinimumSpanningTree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MinimumVertexColoring",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MinimumVertexCover",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["OutDegree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Radius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Spectrum",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "StronglyConnectedComponents",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TreeToCertificate",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["V",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexColoring",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VertexConnectivity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VertexCover",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["WeaklyConnectedComponents",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for graph invariants."
}], "Caption",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithmic Graph Theory", "Subsubsection",
 CellTags->{"S5.18.1", "1.82"}],

Cell["\<\
Finally, there are several invariants of graphs that are of particular \
interest because of the algorithms that compute them. \
\>", "Text",
 CellTags->{"S5.18.1", "1.83"}],

Cell[TextData[{
 "The shortest\[Hyphen]path spanning tree of a grid graph is defined in terms \
of Manhattan distance, where the distance between points with coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["x",
      "TI"], ",", 
     StyleBox["y",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["u",
      "TI"], ",", 
     StyleBox["v",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["x",
     "TI"], "-", 
    StyleBox["u",
     "TI"], "\[VerticalSeparator]", "+", "\[VerticalSeparator]", 
    StyleBox["y",
     "TI"], "-", 
    StyleBox["v",
     "TI"], "\[VerticalSeparator]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.84"}],

Cell[CellGroupData[{

Cell["\<\
ShowGraph[
  ShortestPathSpanningTree[
    GridGraph[5,5],1] ]\
\>", "Input",
 CellLabel->"In[69]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 0.0454545 0.909091 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.04545 .04545 m
.27273 .04545 L
s
.04545 .04545 m
.04545 .27273 L
s
.27273 .04545 m
.5 .04545 L
s
.27273 .04545 m
.27273 .27273 L
s
.5 .04545 m
.72727 .04545 L
s
.5 .04545 m
.5 .27273 L
s
.72727 .04545 m
.95455 .04545 L
s
.72727 .04545 m
.72727 .27273 L
s
.95455 .04545 m
.95455 .27273 L
s
.04545 .27273 m
.04545 .5 L
s
.27273 .27273 m
.27273 .5 L
s
.5 .27273 m
.5 .5 L
s
.72727 .27273 m
.72727 .5 L
s
.95455 .27273 m
.95455 .5 L
s
.04545 .5 m
.04545 .72727 L
s
.27273 .5 m
.27273 .72727 L
s
.5 .5 m
.5 .72727 L
s
.72727 .5 m
.72727 .72727 L
s
.95455 .5 m
.95455 .72727 L
s
.04545 .72727 m
.04545 .95455 L
s
.27273 .72727 m
.27273 .95455 L
s
.5 .72727 m
.5 .95455 L
s
.72727 .72727 m
.72727 .95455 L
s
.95455 .72727 m
.95455 .95455 L
s
.025 w
.04545 .04545 Mdot
.27273 .04545 Mdot
.5 .04545 Mdot
.72727 .04545 Mdot
.95455 .04545 Mdot
.04545 .27273 Mdot
.27273 .27273 Mdot
.5 .27273 Mdot
.72727 .27273 Mdot
.95455 .27273 Mdot
.04545 .5 Mdot
.27273 .5 Mdot
.5 .5 Mdot
.72727 .5 Mdot
.95455 .5 Mdot
.04545 .72727 Mdot
.27273 .72727 Mdot
.5 .72727 Mdot
.72727 .72727 Mdot
.95455 .72727 Mdot
.04545 .95455 Mdot
.27273 .95455 Mdot
.5 .95455 Mdot
.72727 .95455 Mdot
.95455 .95455 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[69]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell["\<\
In an unweighted graph, there can be many different shortest paths between \
any pair of vertices. This path between two opposing corners goes all the way \
to the right, then all the way to the top. \
\>", "MathCaption",
 CellTags->{"S5.18.1", "1.85"}],

Cell[CellGroupData[{

Cell["ShortestPath[GridGraph[5,5],1,25]", "Input",
 CellLabel->"In[70]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "10", ",", "15", ",", 
   "20", ",", "25"}], "}"}]], "Output",
 CellLabel->"Out[70]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A minimum spanning tree of a weighted graph is a set of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " edges of minimum total weight that form a spanning tree of the graph. Any \
spanning tree is a minimum spanning tree when the graphs are unweighted. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.86"}],

Cell[CellGroupData[{

Cell["ShowGraph[ MinimumSpanningTree[ CompleteGraph[6,6,6] ] ]", "Input",
 CellLabel->"In[71]:= ",
 CellTags->"S5.18.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.26471 2.15686 0.0495495 0.990991 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.005 w
[ ] 0 setdash
.10784 .04955 m
.5 .04955 L
s
.10784 .04955 m
.5 .22973 L
s
.10784 .04955 m
.5 .40991 L
s
.10784 .04955 m
.5 .59009 L
s
.10784 .04955 m
.5 .77027 L
s
.10784 .04955 m
.5 .95045 L
s
.10784 .04955 m
.89216 .04955 L
s
.10784 .04955 m
.89216 .22973 L
s
.10784 .04955 m
.89216 .40991 L
s
.10784 .04955 m
.89216 .59009 L
s
.10784 .04955 m
.89216 .77027 L
s
.10784 .04955 m
.89216 .95045 L
s
.10784 .22973 m
.5 .04955 L
s
.10784 .40991 m
.5 .04955 L
s
.10784 .59009 m
.5 .04955 L
s
.10784 .77027 m
.5 .04955 L
s
.10784 .95045 m
.5 .04955 L
s
.025 w
.10784 .04955 Mdot
.10784 .22973 Mdot
.10784 .40991 Mdot
.10784 .59009 Mdot
.10784 .77027 Mdot
.10784 .95045 Mdot
.5 .04955 Mdot
.5 .22973 Mdot
.5 .40991 Mdot
.5 .59009 Mdot
.5 .77027 Mdot
.5 .95045 Mdot
.89216 .04955 Mdot
.89216 .22973 Mdot
.89216 .40991 Mdot
.89216 .59009 Mdot
.89216 .77027 Mdot
.89216 .95045 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.18.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[71]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The number of spanning trees of a complete graph is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["n",
     "TI"], 
    RowBox[{
     StyleBox["n",
      "TI"], "-", "2"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", as was proved by Cayley. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.87"}],

Cell[CellGroupData[{

Cell["NumberOfSpanningTrees[CompleteGraph[10]]", "Input",
 CellLabel->"In[72]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["100000000"], "Output",
 CellLabel->"Out[72]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "The maximum flow through an unweighted complete bipartite graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the minimum degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", 
    RowBox[{"(", 
     StyleBox["G",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.88"}],

Cell[CellGroupData[{

Cell["NetworkFlow[ CompleteGraph[4,4], 1, 8 ]", "Input",
 CellLabel->"In[73]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[73]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "A matching, in a graph ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is a set of edges of ",
 Cell[BoxData[
  FormBox[
   StyleBox["G",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that no two of them share a vertex in common. A perfect matching of \
an even cycle consists of alternating edges in the cycle. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.89"}],

Cell[CellGroupData[{

Cell["BipartiteMatching[ Cycle[8] ]", "Input",
 CellLabel->"In[74]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[74]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[TextData[{
 "Any maximal matching of a ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["K",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a maximum matching, and perfect if ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is even. "
}], "MathCaption",
 CellTags->{"S5.18.1", "1.90"}],

Cell[CellGroupData[{

Cell["MaximalMatching[CompleteGraph[8]]", "Input",
 CellLabel->"In[75]:= ",
 CellTags->"S5.18.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[75]= ",
 CellTags->"S5.18.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AllPairsShortestPath",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AlternatingPaths",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ApproximateVertexCover",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["BellmanFord",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["BipartiteMatching",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["BipartiteMatchingAndCover",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["BreadthFirstTraversal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["BrelazColoring",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CostOfPath",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DepthFirstTraversal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Dijkstra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ExtractCycles",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FindCycle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GreedyVertexCover",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Neighborhood",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NetworkFlow",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ParentsToPaths",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ResidualFlowGraph",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ShortestPath",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ShortestPathSpanningTree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["StableMarriage",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TopologicalSort",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TravelingSalesman",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TravelingSalesmanBounds",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TwoColoring",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.18.1"],

Cell[TextData[{
 StyleBox["Combinatorica", "MR"],
 " functions for graph algorithms."
}], "Caption",
 CellTags->"S5.18.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 971}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.18.1"->{
    Cell[1776, 53, 142, 6, 40, "Subsection",
      CellTags->{"S5.18.1", "1.1"}],
    Cell[1921, 61, 888, 18, 144, "Text",
      CellTags->{"S5.18.1", "1.2"}],
    Cell[2812, 81, 277, 6, 42, "Text",
      CellTags->{"S5.18.1", "1.3"}],
    Cell[3092, 89, 78, 1, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.4"}],
    Cell[3173, 92, 92, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[3290, 98, 85, 1, 35, "Subsubsection",
      CellTags->{"S5.18.1", "1.5"}],
    Cell[3378, 101, 391, 7, 76, "Text",
      CellTags->{"S5.18.1", "1.6"}],
    Cell[3772, 110, 316, 7, 75, "MathCaption",
      CellTags->{"S5.18.1", "1.7"}],
    Cell[4113, 121, 97, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[4213, 125, 513, 16, 27, "Output",
      CellTags->"S5.18.1"],
    Cell[4741, 144, 207, 5, 56, "MathCaption",
      CellTags->{"S5.18.1", "1.8"}],
    Cell[4973, 153, 108, 2, 28, "Input",
      CellTags->"S5.18.1"],
    Cell[5084, 157, 368, 8, 41, "Output",
      CellTags->"S5.18.1"],
    Cell[5467, 168, 453, 13, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.9"}],
    Cell[5945, 185, 96, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[6044, 189, 1479, 44, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[7538, 236, 640, 21, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.10"}],
    Cell[8203, 261, 100, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[8306, 265, 185, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[8506, 274, 283, 9, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.11"}],
    Cell[8814, 287, 95, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[8912, 291, 440, 14, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[9367, 308, 999, 26, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.12"}],
    Cell[10391, 338, 93, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[10487, 342, 275, 10, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[10777, 355, 138, 3, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.13"}],
    Cell[10940, 362, 150, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[11093, 369, 123, 4, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[11231, 376, 222, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.14"}],
    Cell[11478, 385, 105, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[11586, 389, 973, 31, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[12574, 423, 352, 8, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.15"}],
    Cell[12951, 435, 90, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[13044, 439, 974, 31, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[14033, 473, 651, 21, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.16"}],
    Cell[14709, 498, 87, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[14799, 502, 790, 24, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[15604, 529, 6559, 169, 420, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[22166, 700, 118, 4, 17, "Caption",
      CellTags->"S5.18.1"],
    Cell[22287, 706, 4611, 119, 310, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[26901, 827, 113, 4, 17, "Caption",
      CellTags->"S5.18.1"],
    Cell[27017, 833, 4968, 128, 332, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[31988, 963, 118, 4, 17, "Caption",
      CellTags->"S5.18.1"],
    Cell[32143, 972, 102, 1, 35, "Subsubsection",
      CellTags->{"S5.18.1", "1.17"}],
    Cell[32248, 975, 1848, 56, 127, "Text",
      CellTags->{"S5.18.1", "1.18"}],
    Cell[34099, 1033, 163, 4, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.19"}],
    Cell[34287, 1041, 99, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[34389, 1045, 867, 26, 46, "Output",
      CellTags->"S5.18.1"],
    Cell[35271, 1074, 403, 11, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.20"}],
    Cell[35699, 1089, 108, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[35810, 1093, 77, 2, 27, "Output",
      CellTags->"S5.18.1"],
    Cell[35902, 1098, 334, 6, 75, "MathCaption",
      CellTags->{"S5.18.1", "1.21"}],
    Cell[36261, 1108, 100, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[36364, 1112, 11752, 257, 186, 2473, 138, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.18.1"],
    Cell[48119, 1371, 181, 6, 27, "Output",
      CellTags->"S5.18.1"],
    Cell[48315, 1380, 131, 3, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.22"}],
    Cell[48471, 1387, 81, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[48555, 1391, 1549, 46, 84, "Output",
      CellTags->"S5.18.1"],
    Cell[50119, 1440, 253, 5, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.23"}],
    Cell[50397, 1449, 82, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[50482, 1453, 756, 27, 46, "Output",
      CellTags->"S5.18.1"],
    Cell[51253, 1483, 575, 15, 92, "MathCaption",
      CellTags->{"S5.18.1", "1.24"}],
    Cell[51853, 1502, 81, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[51937, 1506, 1105, 39, 65, "Output",
      CellTags->"S5.18.1"],
    Cell[53057, 1548, 185, 4, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.25"}],
    Cell[53267, 1556, 75, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[53345, 1560, 618, 22, 27, "Output",
      CellTags->"S5.18.1"],
    Cell[53978, 1585, 577, 16, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.26"}],
    Cell[54580, 1605, 84, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[54667, 1609, 78, 2, 27, "Output",
      CellTags->"S5.18.1"],
    Cell[54760, 1614, 156, 4, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.27"}],
    Cell[54941, 1622, 105, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[55049, 1626, 649, 16, 117, "Output",
      CellTags->"S5.18.1"],
    Cell[55713, 1645, 585, 19, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.28"}],
    Cell[56323, 1668, 133, 5, 51, "Input",
      CellTags->"S5.18.1"],
    Cell[56459, 1675, 236, 6, 27, "Output",
      CellTags->"S5.18.1"],
    Cell[56710, 1684, 2787, 61, 156, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[59500, 1747, 127, 4, 17, "Caption",
      CellTags->"S5.18.1"],
    Cell[59630, 1753, 4273, 110, 288, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[63906, 1865, 123, 4, 17, "Caption",
      CellTags->"S5.18.1"],
    Cell[64032, 1871, 2525, 65, 178, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[66560, 1938, 120, 4, 17, "Caption",
      CellTags->"S5.18.1"],
    Cell[66683, 1944, 4976, 110, 266, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[71662, 2056, 114, 4, 17, "Caption",
      CellTags->"S5.18.1"],
    Cell[71813, 2065, 76, 1, 35, "Subsubsection",
      CellTags->{"S5.18.1", "1.29"}],
    Cell[71892, 2068, 546, 9, 93, "Text",
      CellTags->{"S5.18.1", "1.30"}],
    Cell[72441, 2079, 561, 18, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.31"}],
    Cell[73027, 2101, 93, 2, 31, "Input",
      CellTags->"S5.18.1"],
    Cell[73123, 2105, 1101, 78, 186, 1030, 75, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[74227, 2185, 181, 6, 27, "Output",
      CellTags->"S5.18.1"],
    Cell[74423, 2194, 257, 5, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.32"}],
    Cell[74705, 2203, 80, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[74788, 2207, 510, 12, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[75313, 2222, 460, 12, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.33"}],
    Cell[75798, 2238, 110, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[75911, 2242, 412, 15, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[76338, 2260, 317, 10, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.34"}],
    Cell[76680, 2274, 92, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[76775, 2278, 635, 20, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[77425, 2301, 131, 3, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.35"}],
    Cell[77581, 2308, 85, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[77669, 2312, 75, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[77759, 2317, 133, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.36"}],
    Cell[77917, 2325, 85, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[78005, 2329, 76, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[78096, 2334, 182, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.37"}],
    Cell[78303, 2342, 153, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[78459, 2349, 508, 12, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[78982, 2364, 230, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.38"}],
    Cell[79237, 2373, 249, 8, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[79489, 2383, 923, 68, 70, 852, 65, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[80415, 2453, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[80611, 2462, 342, 10, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.39"}],
    Cell[80978, 2476, 101, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[81082, 2480, 1157, 83, 70, 1086, 80, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[82242, 2565, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[82438, 2574, 185, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.40"}],
    Cell[82648, 2582, 105, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[82756, 2586, 1668, 125, 70, 1597, 122, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[84427, 2713, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[84623, 2722, 1035, 37, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.41"}],
    Cell[85683, 2763, 111, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[85797, 2767, 387, 15, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[86199, 2785, 527, 20, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.42"}],
    Cell[86751, 2809, 98, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[86852, 2813, 1280, 44, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[88147, 2860, 607, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.43"}],
    Cell[88779, 2881, 151, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[88933, 2888, 3097, 253, 70, 3026, 250, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[92033, 3143, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[92229, 3152, 345, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.44"}],
    Cell[92599, 3162, 113, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[92715, 3166, 2038, 159, 70, 1967, 156, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[94756, 3327, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[94952, 3336, 283, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.45"}],
    Cell[95260, 3345, 98, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[95361, 3349, 325, 8, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[95701, 3360, 323, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.46"}],
    Cell[96049, 3370, 97, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[96149, 3374, 324, 8, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[96488, 3385, 331, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.47"}],
    Cell[96844, 3395, 128, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[96975, 3402, 2353, 188, 70, 2282, 185, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[99331, 3592, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[99527, 3601, 233, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.48"}],
    Cell[99785, 3610, 91, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[99879, 3614, 1177, 80, 70, 1106, 77, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[101059, 3696, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[101255, 3705, 144, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.49"}],
    Cell[101424, 3713, 110, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[101537, 3717, 1171, 80, 70, 1100, 77, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[102711, 3799, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[102907, 3808, 813, 23, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.50"}],
    Cell[103745, 3835, 160, 6, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[103908, 3843, 2044, 157, 70, 1973, 154, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[105955, 4002, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[106151, 4011, 3678, 96, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[109832, 4109, 122, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[109957, 4115, 1965, 51, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[111925, 4168, 130, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[112058, 4174, 10425, 272, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[122486, 4448, 119, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[122608, 4454, 1793, 47, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[124404, 4503, 130, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[124537, 4509, 3350, 87, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[127890, 4598, 120, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[128047, 4607, 74, 1, 70, "Subsubsection",
      CellTags->{"S5.18.1", "1.51"}],
    Cell[128124, 4610, 901, 24, 70, "Text",
      CellTags->{"S5.18.1", "1.52"}],
    Cell[129028, 4636, 127, 3, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.53"}],
    Cell[129180, 4643, 159, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[129342, 4650, 1833, 140, 70, 1762, 137, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[131178, 4792, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[131374, 4801, 295, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.54"}],
    Cell[131694, 4811, 143, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[131840, 4818, 2444, 193, 70, 2373, 190, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[134287, 5013, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[134483, 5022, 1288, 51, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.55"}],
    Cell[135796, 5077, 104, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[135903, 5081, 1838, 143, 70, 1767, 140, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[137744, 5226, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[137940, 5235, 434, 11, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.56"}],
    Cell[138399, 5250, 138, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[138540, 5257, 3128, 253, 70, 3057, 250, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[141671, 5512, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[141867, 5521, 304, 8, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.57"}],
    Cell[142196, 5533, 95, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[142294, 5537, 10172, 496, 70, 10101, 493, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[152469, 6035, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[152665, 6044, 797, 25, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.58"}],
    Cell[153487, 6073, 160, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[153650, 6080, 2186, 175, 70, 2115, 172, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[155839, 6257, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[156035, 6266, 398, 8, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.59"}],
    Cell[156458, 6278, 107, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[156568, 6282, 49805, 3871, 70, 49734, 3868, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[206376, 10155, 186, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[206577, 10164, 14124, 362, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[220704, 10528, 124, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[220865, 10537, 77, 1, 70, "Subsubsection",
      CellTags->{"S5.18.1", "1.60"}],
    Cell[220945, 10540, 303, 6, 70, "Text",
      CellTags->{"S5.18.1", "1.61"}],
    Cell[221251, 10548, 239, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.62"}],
    Cell[221515, 10557, 108, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[221626, 10561, 79, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[221720, 10566, 145, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.63"}],
    Cell[221890, 10574, 149, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[222042, 10581, 248, 8, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[222305, 10592, 569, 16, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.64"}],
    Cell[222899, 10612, 99, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[223001, 10616, 3810, 204, 70, 3739, 201, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[226814, 10822, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[227010, 10831, 638, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.65"}],
    Cell[227673, 10852, 143, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[227819, 10859, 261, 9, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[228095, 10871, 389, 11, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.66"}],
    Cell[228509, 10886, 96, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[228608, 10890, 98, 3, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[228721, 10896, 89, 1, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.67"}],
    Cell[228835, 10901, 89, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[228927, 10905, 634, 22, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[229576, 10930, 544, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.68"}],
    Cell[230145, 10951, 93, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[230241, 10955, 75, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[230331, 10960, 787, 22, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.69"}],
    Cell[231143, 10986, 100, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[231246, 10990, 75, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[231336, 10995, 208, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.70"}],
    Cell[231569, 11003, 120, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[231692, 11007, 1171, 29, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[232878, 11039, 255, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.71"}],
    Cell[233158, 11048, 143, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[233304, 11055, 78, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[233397, 11060, 206, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.72"}],
    Cell[233628, 11068, 131, 6, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[233762, 11076, 79, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[233856, 11081, 216, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.73"}],
    Cell[234097, 11090, 88, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[234188, 11094, 75, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[234278, 11099, 213, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.74"}],
    Cell[234516, 11107, 99, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[234618, 11111, 281, 7, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[234914, 11121, 6098, 159, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[241015, 11282, 122, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[241140, 11288, 980, 35, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.75"}],
    Cell[242145, 11327, 105, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[242253, 11331, 1468, 40, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[243736, 11374, 1749, 69, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.76"}],
    Cell[245510, 11447, 163, 7, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[245676, 11456, 3435, 198, 70, 3364, 195, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[249114, 11656, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[249310, 11665, 174, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.77"}],
    Cell[249509, 11673, 80, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[249592, 11677, 78, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[249685, 11682, 2741, 108, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.78"}],
    Cell[252451, 11794, 119, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[252573, 11798, 2972, 174, 70, 2901, 171, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[255548, 11974, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[255744, 11983, 205, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.79"}],
    Cell[255974, 11991, 167, 7, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[256144, 12000, 1915, 155, 70, 1844, 152, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[258062, 12157, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[258258, 12166, 1113, 40, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.80"}],
    Cell[259396, 12210, 130, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[259529, 12217, 208, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[259752, 12226, 692, 22, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.81"}],
    Cell[260469, 12252, 146, 5, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[260618, 12259, 423, 15, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[261056, 12277, 7983, 205, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[269042, 12484, 122, 4, 70, "Caption",
      CellTags->"S5.18.1"],
    Cell[269201, 12493, 81, 1, 70, "Subsubsection",
      CellTags->{"S5.18.1", "1.82"}],
    Cell[269285, 12496, 183, 4, 70, "Text",
      CellTags->{"S5.18.1", "1.83"}],
    Cell[269471, 12502, 1038, 37, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.84"}],
    Cell[270534, 12543, 134, 6, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[270671, 12551, 1856, 140, 70, 1785, 137, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[272530, 12693, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[272726, 12702, 263, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.85"}],
    Cell[273014, 12711, 97, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[273114, 12715, 201, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[273330, 12724, 443, 11, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.86"}],
    Cell[273798, 12739, 120, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[273921, 12743, 1535, 112, 70, 1464, 109, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.18.1"],
    Cell[275459, 12857, 181, 6, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[275655, 12866, 370, 13, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.87"}],
    Cell[276050, 12883, 104, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[276157, 12887, 83, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[276255, 12892, 496, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.88"}],
    Cell[276776, 12913, 103, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[276882, 12917, 75, 2, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[276972, 12922, 532, 16, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.89"}],
    Cell[277529, 12942, 93, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[277625, 12946, 336, 12, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[277976, 12961, 478, 18, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.90"}],
    Cell[278479, 12983, 97, 2, 70, "Input",
      CellTags->"S5.18.1"],
    Cell[278579, 12987, 336, 12, 70, "Output",
      CellTags->"S5.18.1"],
    Cell[278930, 13002, 4662, 119, 70, "DefinitionBox",
      CellTags->"S5.18.1"],
    Cell[283595, 13123, 122, 4, 70, "Caption",
      CellTags->"S5.18.1"]},
  "1.1"->{
    Cell[1776, 53, 142, 6, 40, "Subsection",
      CellTags->{"S5.18.1", "1.1"}]},
  "1.2"->{
    Cell[1921, 61, 888, 18, 144, "Text",
      CellTags->{"S5.18.1", "1.2"}]},
  "1.3"->{
    Cell[2812, 81, 277, 6, 42, "Text",
      CellTags->{"S5.18.1", "1.3"}]},
  "1.4"->{
    Cell[3092, 89, 78, 1, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.4"}]},
  "1.5"->{
    Cell[3290, 98, 85, 1, 35, "Subsubsection",
      CellTags->{"S5.18.1", "1.5"}]},
  "1.6"->{
    Cell[3378, 101, 391, 7, 76, "Text",
      CellTags->{"S5.18.1", "1.6"}]},
  "1.7"->{
    Cell[3772, 110, 316, 7, 75, "MathCaption",
      CellTags->{"S5.18.1", "1.7"}]},
  "1.8"->{
    Cell[4741, 144, 207, 5, 56, "MathCaption",
      CellTags->{"S5.18.1", "1.8"}]},
  "1.9"->{
    Cell[5467, 168, 453, 13, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.9"}]},
  "1.10"->{
    Cell[7538, 236, 640, 21, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.10"}]},
  "1.11"->{
    Cell[8506, 274, 283, 9, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.11"}]},
  "1.12"->{
    Cell[9367, 308, 999, 26, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.12"}]},
  "1.13"->{
    Cell[10777, 355, 138, 3, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.13"}]},
  "1.14"->{
    Cell[11231, 376, 222, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.14"}]},
  "1.15"->{
    Cell[12574, 423, 352, 8, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.15"}]},
  "1.16"->{
    Cell[14033, 473, 651, 21, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.16"}]},
  "1.17"->{
    Cell[32143, 972, 102, 1, 35, "Subsubsection",
      CellTags->{"S5.18.1", "1.17"}]},
  "1.18"->{
    Cell[32248, 975, 1848, 56, 127, "Text",
      CellTags->{"S5.18.1", "1.18"}]},
  "1.19"->{
    Cell[34099, 1033, 163, 4, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.19"}]},
  "1.20"->{
    Cell[35271, 1074, 403, 11, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.20"}]},
  "1.21"->{
    Cell[35902, 1098, 334, 6, 75, "MathCaption",
      CellTags->{"S5.18.1", "1.21"}]},
  "1.22"->{
    Cell[48315, 1380, 131, 3, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.22"}]},
  "1.23"->{
    Cell[50119, 1440, 253, 5, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.23"}]},
  "1.24"->{
    Cell[51253, 1483, 575, 15, 92, "MathCaption",
      CellTags->{"S5.18.1", "1.24"}]},
  "1.25"->{
    Cell[53057, 1548, 185, 4, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.25"}]},
  "1.26"->{
    Cell[53978, 1585, 577, 16, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.26"}]},
  "1.27"->{
    Cell[54760, 1614, 156, 4, 41, "MathCaption",
      CellTags->{"S5.18.1", "1.27"}]},
  "1.28"->{
    Cell[55713, 1645, 585, 19, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.28"}]},
  "1.29"->{
    Cell[71813, 2065, 76, 1, 35, "Subsubsection",
      CellTags->{"S5.18.1", "1.29"}]},
  "1.30"->{
    Cell[71892, 2068, 546, 9, 93, "Text",
      CellTags->{"S5.18.1", "1.30"}]},
  "1.31"->{
    Cell[72441, 2079, 561, 18, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.31"}]},
  "1.32"->{
    Cell[74423, 2194, 257, 5, 58, "MathCaption",
      CellTags->{"S5.18.1", "1.32"}]},
  "1.33"->{
    Cell[75313, 2222, 460, 12, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.33"}]},
  "1.34"->{
    Cell[76338, 2260, 317, 10, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.34"}]},
  "1.35"->{
    Cell[77425, 2301, 131, 3, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.35"}]},
  "1.36"->{
    Cell[77759, 2317, 133, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.36"}]},
  "1.37"->{
    Cell[78096, 2334, 182, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.37"}]},
  "1.38"->{
    Cell[78982, 2364, 230, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.38"}]},
  "1.39"->{
    Cell[80611, 2462, 342, 10, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.39"}]},
  "1.40"->{
    Cell[82438, 2574, 185, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.40"}]},
  "1.41"->{
    Cell[84623, 2722, 1035, 37, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.41"}]},
  "1.42"->{
    Cell[86199, 2785, 527, 20, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.42"}]},
  "1.43"->{
    Cell[88147, 2860, 607, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.43"}]},
  "1.44"->{
    Cell[92229, 3152, 345, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.44"}]},
  "1.45"->{
    Cell[94952, 3336, 283, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.45"}]},
  "1.46"->{
    Cell[95701, 3360, 323, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.46"}]},
  "1.47"->{
    Cell[96488, 3385, 331, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.47"}]},
  "1.48"->{
    Cell[99527, 3601, 233, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.48"}]},
  "1.49"->{
    Cell[101255, 3705, 144, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.49"}]},
  "1.50"->{
    Cell[102907, 3808, 813, 23, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.50"}]},
  "1.51"->{
    Cell[128047, 4607, 74, 1, 70, "Subsubsection",
      CellTags->{"S5.18.1", "1.51"}]},
  "1.52"->{
    Cell[128124, 4610, 901, 24, 70, "Text",
      CellTags->{"S5.18.1", "1.52"}]},
  "1.53"->{
    Cell[129028, 4636, 127, 3, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.53"}]},
  "1.54"->{
    Cell[131374, 4801, 295, 6, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.54"}]},
  "1.55"->{
    Cell[134483, 5022, 1288, 51, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.55"}]},
  "1.56"->{
    Cell[137940, 5235, 434, 11, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.56"}]},
  "1.57"->{
    Cell[141867, 5521, 304, 8, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.57"}]},
  "1.58"->{
    Cell[152665, 6044, 797, 25, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.58"}]},
  "1.59"->{
    Cell[156035, 6266, 398, 8, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.59"}]},
  "1.60"->{
    Cell[220865, 10537, 77, 1, 70, "Subsubsection",
      CellTags->{"S5.18.1", "1.60"}]},
  "1.61"->{
    Cell[220945, 10540, 303, 6, 70, "Text",
      CellTags->{"S5.18.1", "1.61"}]},
  "1.62"->{
    Cell[221251, 10548, 239, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.62"}]},
  "1.63"->{
    Cell[221720, 10566, 145, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.63"}]},
  "1.64"->{
    Cell[222305, 10592, 569, 16, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.64"}]},
  "1.65"->{
    Cell[227010, 10831, 638, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.65"}]},
  "1.66"->{
    Cell[228095, 10871, 389, 11, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.66"}]},
  "1.67"->{
    Cell[228721, 10896, 89, 1, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.67"}]},
  "1.68"->{
    Cell[229576, 10930, 544, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.68"}]},
  "1.69"->{
    Cell[230331, 10960, 787, 22, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.69"}]},
  "1.70"->{
    Cell[231336, 10995, 208, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.70"}]},
  "1.71"->{
    Cell[232878, 11039, 255, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.71"}]},
  "1.72"->{
    Cell[233397, 11060, 206, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.72"}]},
  "1.73"->{
    Cell[233856, 11081, 216, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.73"}]},
  "1.74"->{
    Cell[234278, 11099, 213, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.74"}]},
  "1.75"->{
    Cell[241140, 11288, 980, 35, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.75"}]},
  "1.76"->{
    Cell[243736, 11374, 1749, 69, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.76"}]},
  "1.77"->{
    Cell[249310, 11665, 174, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.77"}]},
  "1.78"->{
    Cell[249685, 11682, 2741, 108, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.78"}]},
  "1.79"->{
    Cell[255744, 11983, 205, 4, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.79"}]},
  "1.80"->{
    Cell[258258, 12166, 1113, 40, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.80"}]},
  "1.81"->{
    Cell[259752, 12226, 692, 22, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.81"}]},
  "1.82"->{
    Cell[269201, 12493, 81, 1, 70, "Subsubsection",
      CellTags->{"S5.18.1", "1.82"}]},
  "1.83"->{
    Cell[269285, 12496, 183, 4, 70, "Text",
      CellTags->{"S5.18.1", "1.83"}]},
  "1.84"->{
    Cell[269471, 12502, 1038, 37, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.84"}]},
  "1.85"->{
    Cell[272726, 12702, 263, 5, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.85"}]},
  "1.86"->{
    Cell[273330, 12724, 443, 11, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.86"}]},
  "1.87"->{
    Cell[275655, 12866, 370, 13, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.87"}]},
  "1.88"->{
    Cell[276255, 12892, 496, 17, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.88"}]},
  "1.89"->{
    Cell[276972, 12922, 532, 16, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.89"}]},
  "1.90"->{
    Cell[277976, 12961, 478, 18, 70, "MathCaption",
      CellTags->{"S5.18.1", "1.90"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.18.1", 284374, 13147},
  {"1.1", 309137, 13785},
  {"1.2", 309231, 13788},
  {"1.3", 309321, 13791},
  {"1.4", 309409, 13794},
  {"1.5", 309503, 13797},
  {"1.6", 309599, 13800},
  {"1.7", 309688, 13803},
  {"1.8", 309784, 13806},
  {"1.9", 309880, 13809},
  {"1.10", 309978, 13812},
  {"1.11", 310077, 13815},
  {"1.12", 310175, 13818},
  {"1.13", 310274, 13821},
  {"1.14", 310373, 13824},
  {"1.15", 310472, 13827},
  {"1.16", 310571, 13830},
  {"1.17", 310671, 13833},
  {"1.18", 310772, 13836},
  {"1.19", 310867, 13839},
  {"1.20", 310967, 13842},
  {"1.21", 311068, 13845},
  {"1.22", 311168, 13848},
  {"1.23", 311268, 13851},
  {"1.24", 311368, 13854},
  {"1.25", 311469, 13857},
  {"1.26", 311569, 13860},
  {"1.27", 311670, 13863},
  {"1.28", 311770, 13866},
  {"1.29", 311871, 13869},
  {"1.30", 311972, 13872},
  {"1.31", 312065, 13875},
  {"1.32", 312166, 13878},
  {"1.33", 312266, 13881},
  {"1.34", 312367, 13884},
  {"1.35", 312468, 13887},
  {"1.36", 312568, 13890},
  {"1.37", 312668, 13893},
  {"1.38", 312768, 13896},
  {"1.39", 312868, 13899},
  {"1.40", 312969, 13902},
  {"1.41", 313069, 13905},
  {"1.42", 313171, 13908},
  {"1.43", 313272, 13911},
  {"1.44", 313373, 13914},
  {"1.45", 313473, 13917},
  {"1.46", 313573, 13920},
  {"1.47", 313673, 13923},
  {"1.48", 313773, 13926},
  {"1.49", 313873, 13929},
  {"1.50", 313974, 13932},
  {"1.51", 314076, 13935},
  {"1.52", 314178, 13938},
  {"1.53", 314273, 13941},
  {"1.54", 314374, 13944},
  {"1.55", 314475, 13947},
  {"1.56", 314578, 13950},
  {"1.57", 314680, 13953},
  {"1.58", 314781, 13956},
  {"1.59", 314883, 13959},
  {"1.60", 314984, 13962},
  {"1.61", 315087, 13965},
  {"1.62", 315182, 13968},
  {"1.63", 315284, 13971},
  {"1.64", 315386, 13974},
  {"1.65", 315489, 13977},
  {"1.66", 315592, 13980},
  {"1.67", 315695, 13983},
  {"1.68", 315796, 13986},
  {"1.69", 315899, 13989},
  {"1.70", 316002, 13992},
  {"1.71", 316104, 13995},
  {"1.72", 316206, 13998},
  {"1.73", 316308, 14001},
  {"1.74", 316410, 14004},
  {"1.75", 316512, 14007},
  {"1.76", 316615, 14010},
  {"1.77", 316719, 14013},
  {"1.78", 316821, 14016},
  {"1.79", 316926, 14019},
  {"1.80", 317028, 14022},
  {"1.81", 317132, 14025},
  {"1.82", 317235, 14028},
  {"1.83", 317338, 14031},
  {"1.84", 317433, 14034},
  {"1.85", 317537, 14037},
  {"1.86", 317639, 14040},
  {"1.87", 317742, 14043},
  {"1.88", 317845, 14046},
  {"1.89", 317948, 14049},
  {"1.90", 318051, 14052}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 142, 6, 40, "Subsection",
  CellTags->{"S5.18.1", "1.1"}],
Cell[1921, 61, 888, 18, 144, "Text",
  CellTags->{"S5.18.1", "1.2"}],
Cell[2812, 81, 277, 6, 42, "Text",
  CellTags->{"S5.18.1", "1.3"}],
Cell[3092, 89, 78, 1, 41, "MathCaption",
  CellTags->{"S5.18.1", "1.4"}],
Cell[3173, 92, 92, 2, 31, "Input",
  CellTags->"S5.18.1"],

Cell[CellGroupData[{
Cell[3290, 98, 85, 1, 35, "Subsubsection",
  CellTags->{"S5.18.1", "1.5"}],
Cell[3378, 101, 391, 7, 76, "Text",
  CellTags->{"S5.18.1", "1.6"}],
Cell[3772, 110, 316, 7, 75, "MathCaption",
  CellTags->{"S5.18.1", "1.7"}],

Cell[CellGroupData[{
Cell[4113, 121, 97, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[4213, 125, 513, 16, 27, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[4741, 144, 207, 5, 56, "MathCaption",
  CellTags->{"S5.18.1", "1.8"}],

Cell[CellGroupData[{
Cell[4973, 153, 108, 2, 28, "Input",
  CellTags->"S5.18.1"],
Cell[5084, 157, 368, 8, 41, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[5467, 168, 453, 13, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.9"}],

Cell[CellGroupData[{
Cell[5945, 185, 96, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[6044, 189, 1479, 44, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[7538, 236, 640, 21, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.10"}],

Cell[CellGroupData[{
Cell[8203, 261, 100, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[8306, 265, 185, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[8506, 274, 283, 9, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.11"}],

Cell[CellGroupData[{
Cell[8814, 287, 95, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[8912, 291, 440, 14, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[9367, 308, 999, 26, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.12"}],

Cell[CellGroupData[{
Cell[10391, 338, 93, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[10487, 342, 275, 10, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[10777, 355, 138, 3, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.13"}],

Cell[CellGroupData[{
Cell[10940, 362, 150, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[11093, 369, 123, 4, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[11231, 376, 222, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.14"}],

Cell[CellGroupData[{
Cell[11478, 385, 105, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[11586, 389, 973, 31, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[12574, 423, 352, 8, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.15"}],

Cell[CellGroupData[{
Cell[12951, 435, 90, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[13044, 439, 974, 31, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[14033, 473, 651, 21, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.16"}],

Cell[CellGroupData[{
Cell[14709, 498, 87, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[14799, 502, 790, 24, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[15604, 529, 6559, 169, 420, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[22166, 700, 118, 4, 17, "Caption",
  CellTags->"S5.18.1"],
Cell[22287, 706, 4611, 119, 310, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[26901, 827, 113, 4, 17, "Caption",
  CellTags->"S5.18.1"],
Cell[27017, 833, 4968, 128, 332, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[31988, 963, 118, 4, 17, "Caption",
  CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32143, 972, 102, 1, 35, "Subsubsection",
  CellTags->{"S5.18.1", "1.17"}],
Cell[32248, 975, 1848, 56, 127, "Text",
  CellTags->{"S5.18.1", "1.18"}],
Cell[34099, 1033, 163, 4, 41, "MathCaption",
  CellTags->{"S5.18.1", "1.19"}],

Cell[CellGroupData[{
Cell[34287, 1041, 99, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[34389, 1045, 867, 26, 46, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[35271, 1074, 403, 11, 58, "MathCaption",
  CellTags->{"S5.18.1", "1.20"}],

Cell[CellGroupData[{
Cell[35699, 1089, 108, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[35810, 1093, 77, 2, 27, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[35902, 1098, 334, 6, 75, "MathCaption",
  CellTags->{"S5.18.1", "1.21"}],

Cell[CellGroupData[{
Cell[36261, 1108, 100, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[36364, 1112, 11752, 257, 186, 2473, 138, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.18.1"],
Cell[48119, 1371, 181, 6, 27, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[48315, 1380, 131, 3, 41, "MathCaption",
  CellTags->{"S5.18.1", "1.22"}],

Cell[CellGroupData[{
Cell[48471, 1387, 81, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[48555, 1391, 1549, 46, 84, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[50119, 1440, 253, 5, 58, "MathCaption",
  CellTags->{"S5.18.1", "1.23"}],

Cell[CellGroupData[{
Cell[50397, 1449, 82, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[50482, 1453, 756, 27, 46, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[51253, 1483, 575, 15, 92, "MathCaption",
  CellTags->{"S5.18.1", "1.24"}],

Cell[CellGroupData[{
Cell[51853, 1502, 81, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[51937, 1506, 1105, 39, 65, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[53057, 1548, 185, 4, 58, "MathCaption",
  CellTags->{"S5.18.1", "1.25"}],

Cell[CellGroupData[{
Cell[53267, 1556, 75, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[53345, 1560, 618, 22, 27, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[53978, 1585, 577, 16, 58, "MathCaption",
  CellTags->{"S5.18.1", "1.26"}],

Cell[CellGroupData[{
Cell[54580, 1605, 84, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[54667, 1609, 78, 2, 27, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[54760, 1614, 156, 4, 41, "MathCaption",
  CellTags->{"S5.18.1", "1.27"}],

Cell[CellGroupData[{
Cell[54941, 1622, 105, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[55049, 1626, 649, 16, 117, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[55713, 1645, 585, 19, 58, "MathCaption",
  CellTags->{"S5.18.1", "1.28"}],

Cell[CellGroupData[{
Cell[56323, 1668, 133, 5, 51, "Input",
  CellTags->"S5.18.1"],
Cell[56459, 1675, 236, 6, 27, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[56710, 1684, 2787, 61, 156, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[59500, 1747, 127, 4, 17, "Caption",
  CellTags->"S5.18.1"],
Cell[59630, 1753, 4273, 110, 288, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[63906, 1865, 123, 4, 17, "Caption",
  CellTags->"S5.18.1"],
Cell[64032, 1871, 2525, 65, 178, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[66560, 1938, 120, 4, 17, "Caption",
  CellTags->"S5.18.1"],
Cell[66683, 1944, 4976, 110, 266, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[71662, 2056, 114, 4, 17, "Caption",
  CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[71813, 2065, 76, 1, 35, "Subsubsection",
  CellTags->{"S5.18.1", "1.29"}],
Cell[71892, 2068, 546, 9, 93, "Text",
  CellTags->{"S5.18.1", "1.30"}],
Cell[72441, 2079, 561, 18, 58, "MathCaption",
  CellTags->{"S5.18.1", "1.31"}],

Cell[CellGroupData[{
Cell[73027, 2101, 93, 2, 31, "Input",
  CellTags->"S5.18.1"],
Cell[73123, 2105, 1101, 78, 186, 1030, 75, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[74227, 2185, 181, 6, 27, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[74423, 2194, 257, 5, 58, "MathCaption",
  CellTags->{"S5.18.1", "1.32"}],

Cell[CellGroupData[{
Cell[74705, 2203, 80, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[74788, 2207, 510, 12, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[75313, 2222, 460, 12, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.33"}],

Cell[CellGroupData[{
Cell[75798, 2238, 110, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[75911, 2242, 412, 15, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[76338, 2260, 317, 10, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.34"}],

Cell[CellGroupData[{
Cell[76680, 2274, 92, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[76775, 2278, 635, 20, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[77425, 2301, 131, 3, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.35"}],

Cell[CellGroupData[{
Cell[77581, 2308, 85, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[77669, 2312, 75, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[77759, 2317, 133, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.36"}],

Cell[CellGroupData[{
Cell[77917, 2325, 85, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[78005, 2329, 76, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[78096, 2334, 182, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.37"}],

Cell[CellGroupData[{
Cell[78303, 2342, 153, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[78459, 2349, 508, 12, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[78982, 2364, 230, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.38"}],

Cell[CellGroupData[{
Cell[79237, 2373, 249, 8, 70, "Input",
  CellTags->"S5.18.1"],
Cell[79489, 2383, 923, 68, 70, 852, 65, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[80415, 2453, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[80611, 2462, 342, 10, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.39"}],

Cell[CellGroupData[{
Cell[80978, 2476, 101, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[81082, 2480, 1157, 83, 70, 1086, 80, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[82242, 2565, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[82438, 2574, 185, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.40"}],

Cell[CellGroupData[{
Cell[82648, 2582, 105, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[82756, 2586, 1668, 125, 70, 1597, 122, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[84427, 2713, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[84623, 2722, 1035, 37, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.41"}],

Cell[CellGroupData[{
Cell[85683, 2763, 111, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[85797, 2767, 387, 15, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[86199, 2785, 527, 20, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.42"}],

Cell[CellGroupData[{
Cell[86751, 2809, 98, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[86852, 2813, 1280, 44, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[88147, 2860, 607, 17, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.43"}],

Cell[CellGroupData[{
Cell[88779, 2881, 151, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[88933, 2888, 3097, 253, 70, 3026, 250, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[92033, 3143, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[92229, 3152, 345, 6, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.44"}],

Cell[CellGroupData[{
Cell[92599, 3162, 113, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[92715, 3166, 2038, 159, 70, 1967, 156, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[94756, 3327, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[94952, 3336, 283, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.45"}],

Cell[CellGroupData[{
Cell[95260, 3345, 98, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[95361, 3349, 325, 8, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[95701, 3360, 323, 6, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.46"}],

Cell[CellGroupData[{
Cell[96049, 3370, 97, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[96149, 3374, 324, 8, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[96488, 3385, 331, 6, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.47"}],

Cell[CellGroupData[{
Cell[96844, 3395, 128, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[96975, 3402, 2353, 188, 70, 2282, 185, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[99331, 3592, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[99527, 3601, 233, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.48"}],

Cell[CellGroupData[{
Cell[99785, 3610, 91, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[99879, 3614, 1177, 80, 70, 1106, 77, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[101059, 3696, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[101255, 3705, 144, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.49"}],

Cell[CellGroupData[{
Cell[101424, 3713, 110, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[101537, 3717, 1171, 80, 70, 1100, 77, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[102711, 3799, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[102907, 3808, 813, 23, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.50"}],

Cell[CellGroupData[{
Cell[103745, 3835, 160, 6, 70, "Input",
  CellTags->"S5.18.1"],
Cell[103908, 3843, 2044, 157, 70, 1973, 154, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[105955, 4002, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[106151, 4011, 3678, 96, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[109832, 4109, 122, 4, 70, "Caption",
  CellTags->"S5.18.1"],
Cell[109957, 4115, 1965, 51, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[111925, 4168, 130, 4, 70, "Caption",
  CellTags->"S5.18.1"],
Cell[112058, 4174, 10425, 272, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[122486, 4448, 119, 4, 70, "Caption",
  CellTags->"S5.18.1"],
Cell[122608, 4454, 1793, 47, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[124404, 4503, 130, 4, 70, "Caption",
  CellTags->"S5.18.1"],
Cell[124537, 4509, 3350, 87, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[127890, 4598, 120, 4, 70, "Caption",
  CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[128047, 4607, 74, 1, 70, "Subsubsection",
  CellTags->{"S5.18.1", "1.51"}],
Cell[128124, 4610, 901, 24, 70, "Text",
  CellTags->{"S5.18.1", "1.52"}],
Cell[129028, 4636, 127, 3, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.53"}],

Cell[CellGroupData[{
Cell[129180, 4643, 159, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[129342, 4650, 1833, 140, 70, 1762, 137, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[131178, 4792, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[131374, 4801, 295, 6, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.54"}],

Cell[CellGroupData[{
Cell[131694, 4811, 143, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[131840, 4818, 2444, 193, 70, 2373, 190, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[134287, 5013, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[134483, 5022, 1288, 51, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.55"}],

Cell[CellGroupData[{
Cell[135796, 5077, 104, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[135903, 5081, 1838, 143, 70, 1767, 140, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[137744, 5226, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[137940, 5235, 434, 11, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.56"}],

Cell[CellGroupData[{
Cell[138399, 5250, 138, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[138540, 5257, 3128, 253, 70, 3057, 250, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[141671, 5512, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[141867, 5521, 304, 8, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.57"}],

Cell[CellGroupData[{
Cell[142196, 5533, 95, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[142294, 5537, 10172, 496, 70, 10101, 493, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[152469, 6035, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[152665, 6044, 797, 25, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.58"}],

Cell[CellGroupData[{
Cell[153487, 6073, 160, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[153650, 6080, 2186, 175, 70, 2115, 172, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[155839, 6257, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[156035, 6266, 398, 8, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.59"}],

Cell[CellGroupData[{
Cell[156458, 6278, 107, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[156568, 6282, 49805, 3871, 70, 49734, 3868, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[206376, 10155, 186, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[206577, 10164, 14124, 362, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[220704, 10528, 124, 4, 70, "Caption",
  CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[220865, 10537, 77, 1, 70, "Subsubsection",
  CellTags->{"S5.18.1", "1.60"}],
Cell[220945, 10540, 303, 6, 70, "Text",
  CellTags->{"S5.18.1", "1.61"}],
Cell[221251, 10548, 239, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.62"}],

Cell[CellGroupData[{
Cell[221515, 10557, 108, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[221626, 10561, 79, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[221720, 10566, 145, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.63"}],

Cell[CellGroupData[{
Cell[221890, 10574, 149, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[222042, 10581, 248, 8, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[222305, 10592, 569, 16, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.64"}],

Cell[CellGroupData[{
Cell[222899, 10612, 99, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[223001, 10616, 3810, 204, 70, 3739, 201, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[226814, 10822, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[227010, 10831, 638, 17, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.65"}],

Cell[CellGroupData[{
Cell[227673, 10852, 143, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[227819, 10859, 261, 9, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[228095, 10871, 389, 11, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.66"}],

Cell[CellGroupData[{
Cell[228509, 10886, 96, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[228608, 10890, 98, 3, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[228721, 10896, 89, 1, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.67"}],

Cell[CellGroupData[{
Cell[228835, 10901, 89, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[228927, 10905, 634, 22, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[229576, 10930, 544, 17, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.68"}],

Cell[CellGroupData[{
Cell[230145, 10951, 93, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[230241, 10955, 75, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[230331, 10960, 787, 22, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.69"}],

Cell[CellGroupData[{
Cell[231143, 10986, 100, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[231246, 10990, 75, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[231336, 10995, 208, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.70"}],

Cell[CellGroupData[{
Cell[231569, 11003, 120, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[231692, 11007, 1171, 29, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[232878, 11039, 255, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.71"}],

Cell[CellGroupData[{
Cell[233158, 11048, 143, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[233304, 11055, 78, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[233397, 11060, 206, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.72"}],

Cell[CellGroupData[{
Cell[233628, 11068, 131, 6, 70, "Input",
  CellTags->"S5.18.1"],
Cell[233762, 11076, 79, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[233856, 11081, 216, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.73"}],

Cell[CellGroupData[{
Cell[234097, 11090, 88, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[234188, 11094, 75, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[234278, 11099, 213, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.74"}],

Cell[CellGroupData[{
Cell[234516, 11107, 99, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[234618, 11111, 281, 7, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[234914, 11121, 6098, 159, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[241015, 11282, 122, 4, 70, "Caption",
  CellTags->"S5.18.1"],
Cell[241140, 11288, 980, 35, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.75"}],

Cell[CellGroupData[{
Cell[242145, 11327, 105, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[242253, 11331, 1468, 40, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[243736, 11374, 1749, 69, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.76"}],

Cell[CellGroupData[{
Cell[245510, 11447, 163, 7, 70, "Input",
  CellTags->"S5.18.1"],
Cell[245676, 11456, 3435, 198, 70, 3364, 195, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[249114, 11656, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[249310, 11665, 174, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.77"}],

Cell[CellGroupData[{
Cell[249509, 11673, 80, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[249592, 11677, 78, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[249685, 11682, 2741, 108, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.78"}],

Cell[CellGroupData[{
Cell[252451, 11794, 119, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[252573, 11798, 2972, 174, 70, 2901, 171, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[255548, 11974, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[255744, 11983, 205, 4, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.79"}],

Cell[CellGroupData[{
Cell[255974, 11991, 167, 7, 70, "Input",
  CellTags->"S5.18.1"],
Cell[256144, 12000, 1915, 155, 70, 1844, 152, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[258062, 12157, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[258258, 12166, 1113, 40, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.80"}],

Cell[CellGroupData[{
Cell[259396, 12210, 130, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[259529, 12217, 208, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[259752, 12226, 692, 22, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.81"}],

Cell[CellGroupData[{
Cell[260469, 12252, 146, 5, 70, "Input",
  CellTags->"S5.18.1"],
Cell[260618, 12259, 423, 15, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[261056, 12277, 7983, 205, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[269042, 12484, 122, 4, 70, "Caption",
  CellTags->"S5.18.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[269201, 12493, 81, 1, 70, "Subsubsection",
  CellTags->{"S5.18.1", "1.82"}],
Cell[269285, 12496, 183, 4, 70, "Text",
  CellTags->{"S5.18.1", "1.83"}],
Cell[269471, 12502, 1038, 37, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.84"}],

Cell[CellGroupData[{
Cell[270534, 12543, 134, 6, 70, "Input",
  CellTags->"S5.18.1"],
Cell[270671, 12551, 1856, 140, 70, 1785, 137, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[272530, 12693, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[272726, 12702, 263, 5, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.85"}],

Cell[CellGroupData[{
Cell[273014, 12711, 97, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[273114, 12715, 201, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[273330, 12724, 443, 11, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.86"}],

Cell[CellGroupData[{
Cell[273798, 12739, 120, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[273921, 12743, 1535, 112, 70, 1464, 109, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.18.1"],
Cell[275459, 12857, 181, 6, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[275655, 12866, 370, 13, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.87"}],

Cell[CellGroupData[{
Cell[276050, 12883, 104, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[276157, 12887, 83, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[276255, 12892, 496, 17, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.88"}],

Cell[CellGroupData[{
Cell[276776, 12913, 103, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[276882, 12917, 75, 2, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[276972, 12922, 532, 16, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.89"}],

Cell[CellGroupData[{
Cell[277529, 12942, 93, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[277625, 12946, 336, 12, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[277976, 12961, 478, 18, 70, "MathCaption",
  CellTags->{"S5.18.1", "1.90"}],

Cell[CellGroupData[{
Cell[278479, 12983, 97, 2, 70, "Input",
  CellTags->"S5.18.1"],
Cell[278579, 12987, 336, 12, 70, "Output",
  CellTags->"S5.18.1"]
}, Open  ]],
Cell[278930, 13002, 4662, 119, 70, "DefinitionBox",
  CellTags->"S5.18.1"],
Cell[283595, 13123, 122, 4, 70, "Caption",
  CellTags->"S5.18.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

