(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    354537,      19227]*)
(*NotebookOutlinePosition[    359085,      19361]*)
(*  CellTagsIndexPosition[    358748,      19345]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "ComplexMap",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.29.1", "1.1"}],

Cell["\<\
To plot the graph of a complex\[Hyphen]valued function of a complex variable, \
four dimensions are required as follows: two for the complex variable and two \
for the complex function value. One method, to circumvent the need for four\
\[Hyphen]dimensional graphics, is to show how the function transforms sets of \
lines that lie in the complex plane. Each line will be mapped into some curve \
in the complex plane and these can be represented in two dimensions. \
\>", "Text",
 CellTags->{"S5.29.1", "1.2"}],

Cell[TextData[{
 "The functions ",
 StyleBox["CartesianMap", "MR"],
 " and ",
 StyleBox["PolarMap", "MR"],
 " defined in this package make pictures of this form. ",
 StyleBox["CartesianMap", "MR"],
 " shows the image of Cartesian coordinate lines, while ",
 StyleBox["PolarMap", "MR"],
 " shows the effect on polar coordinate lines. "
}], "Text",
 CellTags->{"S5.29.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CartesianMap[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the image of the Cartesian coordinate lines in the given ranges \
under ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PolarMap[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the image of the polar coordinate lines in the given ranges under \
",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.29.1"],

Cell["\<\
Plotting the image of coordinate lines in the complex plane. \
\>", "Caption",
 CellTags->"S5.29.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.29.1", "1.4"}],

Cell["<<Graphics`ComplexMap`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.29.1"],

Cell[TextData[{
 "We set the option ",
 StyleBox["Frame", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["True", "MR"],
 " to get frame axes on all our plots. "
}], "MathCaption",
 CellTags->{"S5.29.1", "1.5"}],

Cell["SetOptions[Graphics, Frame -> True];", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.29.1"],

Cell["This shows the Cartesian grid. ", "MathCaption",
 CellTags->{"S5.29.1", "1.6"}],

Cell[CellGroupData[{

Cell["CartesianMap[Identity, { -5, 5}, { -5, 5}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.29.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.5 0.0952381 [
[.11905 -0.0125 -6 -9 ]
[.11905 -0.0125 6 0 ]
[.30952 -0.0125 -6 -9 ]
[.30952 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.69048 -0.0125 -3 -9 ]
[.69048 -0.0125 3 0 ]
[.88095 -0.0125 -3 -9 ]
[.88095 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .11905 -12 -4.5 ]
[-0.0125 .11905 0 4.5 ]
[-0.0125 .30952 -12 -4.5 ]
[-0.0125 .30952 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .69048 -6 -4.5 ]
[-0.0125 .69048 0 4.5 ]
[-0.0125 .88095 -6 -4.5 ]
[-0.0125 .88095 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 0 m
.11905 .00625 L
s
[(-4)] .11905 -0.0125 0 1 Mshowa
.30952 0 m
.30952 .00625 L
s
[(-2)] .30952 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.69048 0 m
.69048 .00625 L
s
[(2)] .69048 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(4)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.07143 0 m
.07143 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .11905 m
.00625 .11905 L
s
[(-4)] -0.0125 .11905 1 0 Mshowa
0 .30952 m
.00625 .30952 L
s
[(-2)] -0.0125 .30952 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .69048 m
.00625 .69048 L
s
[(2)] -0.0125 .69048 1 0 Mshowa
0 .88095 m
.00625 .88095 L
s
[(4)] -0.0125 .88095 1 0 Mshowa
.125 Mabswid
0 .16667 m
.00375 .16667 L
s
0 .21429 m
.00375 .21429 L
s
0 .2619 m
.00375 .2619 L
s
0 .35714 m
.00375 .35714 L
s
0 .40476 m
.00375 .40476 L
s
0 .45238 m
.00375 .45238 L
s
0 .54762 m
.00375 .54762 L
s
0 .59524 m
.00375 .59524 L
s
0 .64286 m
.00375 .64286 L
s
0 .7381 m
.00375 .7381 L
s
0 .78571 m
.00375 .78571 L
s
0 .83333 m
.00375 .83333 L
s
0 .07143 m
.00375 .07143 L
s
0 .02381 m
.00375 .02381 L
s
0 .92857 m
.00375 .92857 L
s
0 .97619 m
.00375 .97619 L
s
.25 Mabswid
0 0 m
0 1 L
s
.11905 .99375 m
.11905 1 L
s
.30952 .99375 m
.30952 1 L
s
.5 .99375 m
.5 1 L
s
.69048 .99375 m
.69048 1 L
s
.88095 .99375 m
.88095 1 L
s
.125 Mabswid
.16667 .99625 m
.16667 1 L
s
.21429 .99625 m
.21429 1 L
s
.2619 .99625 m
.2619 1 L
s
.35714 .99625 m
.35714 1 L
s
.40476 .99625 m
.40476 1 L
s
.45238 .99625 m
.45238 1 L
s
.54762 .99625 m
.54762 1 L
s
.59524 .99625 m
.59524 1 L
s
.64286 .99625 m
.64286 1 L
s
.7381 .99625 m
.7381 1 L
s
.78571 .99625 m
.78571 1 L
s
.83333 .99625 m
.83333 1 L
s
.07143 .99625 m
.07143 1 L
s
.02381 .99625 m
.02381 1 L
s
.92857 .99625 m
.92857 1 L
s
.97619 .99625 m
.97619 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .11905 m
1 .11905 L
s
.99375 .30952 m
1 .30952 L
s
.99375 .5 m
1 .5 L
s
.99375 .69048 m
1 .69048 L
s
.99375 .88095 m
1 .88095 L
s
.125 Mabswid
.99625 .16667 m
1 .16667 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .2619 m
1 .2619 L
s
.99625 .35714 m
1 .35714 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .45238 m
1 .45238 L
s
.99625 .54762 m
1 .54762 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .64286 m
1 .64286 L
s
.99625 .7381 m
1 .7381 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .83333 m
1 .83333 L
s
.99625 .07143 m
1 .07143 L
s
.99625 .02381 m
1 .02381 L
s
.99625 .92857 m
1 .92857 L
s
.99625 .97619 m
1 .97619 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .02381 m
.02381 .06244 L
.02381 .10458 L
.02381 .14415 L
.02381 .18221 L
.02381 .22272 L
.02381 .26171 L
.02381 .30316 L
.02381 .34309 L
.02381 .3815 L
.02381 .42237 L
.02381 .46172 L
.02381 .49955 L
.02381 .53984 L
.02381 .57861 L
.02381 .61984 L
.02381 .65954 L
.02381 .69774 L
.02381 .73838 L
.02381 .77751 L
.02381 .81909 L
.02381 .85916 L
.02381 .89771 L
.02381 .93871 L
.02381 .97619 L
s
.09184 .02381 m
.09184 .06244 L
.09184 .10458 L
.09184 .14415 L
.09184 .18221 L
.09184 .22272 L
.09184 .26171 L
.09184 .30316 L
.09184 .34309 L
.09184 .3815 L
.09184 .42237 L
.09184 .46172 L
.09184 .49955 L
.09184 .53984 L
.09184 .57861 L
.09184 .61984 L
.09184 .65954 L
.09184 .69774 L
.09184 .73838 L
.09184 .77751 L
.09184 .81909 L
.09184 .85916 L
.09184 .89771 L
.09184 .93871 L
.09184 .97619 L
s
.15986 .02381 m
.15986 .06244 L
.15986 .10458 L
.15986 .14415 L
.15986 .18221 L
.15986 .22272 L
.15986 .26171 L
.15986 .30316 L
.15986 .34309 L
.15986 .3815 L
.15986 .42237 L
.15986 .46172 L
.15986 .49955 L
.15986 .53984 L
.15986 .57861 L
.15986 .61984 L
.15986 .65954 L
.15986 .69774 L
.15986 .73838 L
.15986 .77751 L
.15986 .81909 L
.15986 .85916 L
.15986 .89771 L
.15986 .93871 L
.15986 .97619 L
s
.22789 .02381 m
.22789 .06244 L
.22789 .10458 L
.22789 .14415 L
.22789 .18221 L
.22789 .22272 L
.22789 .26171 L
.22789 .30316 L
.22789 .34309 L
.22789 .3815 L
.22789 .42237 L
.22789 .46172 L
.22789 .49955 L
.22789 .53984 L
.22789 .57861 L
.22789 .61984 L
.22789 .65954 L
.22789 .69774 L
.22789 .73838 L
.22789 .77751 L
.22789 .81909 L
.22789 .85916 L
.22789 .89771 L
.22789 .93871 L
.22789 .97619 L
s
.29592 .02381 m
.29592 .06244 L
.29592 .10458 L
.29592 .14415 L
.29592 .18221 L
.29592 .22272 L
.29592 .26171 L
.29592 .30316 L
.29592 .34309 L
.29592 .3815 L
.29592 .42237 L
.29592 .46172 L
.29592 .49955 L
.29592 .53984 L
.29592 .57861 L
.29592 .61984 L
.29592 .65954 L
.29592 .69774 L
.29592 .73838 L
.29592 .77751 L
.29592 .81909 L
.29592 .85916 L
.29592 .89771 L
.29592 .93871 L
.29592 .97619 L
s
.36395 .02381 m
.36395 .06244 L
.36395 .10458 L
.36395 .14415 L
.36395 .18221 L
.36395 .22272 L
.36395 .26171 L
.36395 .30316 L
.36395 .34309 L
.36395 .3815 L
.36395 .42237 L
.36395 .46172 L
.36395 .49955 L
.36395 .53984 L
.36395 .57861 L
.36395 .61984 L
.36395 .65954 L
.36395 .69774 L
.36395 .73838 L
.36395 .77751 L
.36395 .81909 L
.36395 .85916 L
.36395 .89771 L
.36395 .93871 L
.36395 .97619 L
s
.43197 .02381 m
.43197 .06244 L
.43197 .10458 L
.43197 .14415 L
.43197 .18221 L
.43197 .22272 L
.43197 .26171 L
.43197 .30316 L
.43197 .34309 L
.43197 .3815 L
.43197 .42237 L
.43197 .46172 L
.43197 .49955 L
.43197 .53984 L
.43197 .57861 L
.43197 .61984 L
.43197 .65954 L
.43197 .69774 L
.43197 .73838 L
.43197 .77751 L
.43197 .81909 L
.43197 .85916 L
.43197 .89771 L
.43197 .93871 L
.43197 .97619 L
s
.5 .02381 m
.5 .06244 L
.5 .10458 L
.5 .14415 L
.5 .18221 L
.5 .22272 L
.5 .26171 L
.5 .30316 L
.5 .34309 L
.5 .3815 L
.5 .42237 L
.5 .46172 L
.5 .49955 L
.5 .53984 L
.5 .57861 L
.5 .61984 L
.5 .65954 L
.5 .69774 L
.5 .73838 L
.5 .77751 L
.5 .81909 L
.5 .85916 L
.5 .89771 L
.5 .93871 L
.5 .97619 L
s
.56803 .02381 m
.56803 .06244 L
.56803 .10458 L
.56803 .14415 L
.56803 .18221 L
.56803 .22272 L
.56803 .26171 L
.56803 .30316 L
.56803 .34309 L
.56803 .3815 L
.56803 .42237 L
.56803 .46172 L
.56803 .49955 L
.56803 .53984 L
.56803 .57861 L
.56803 .61984 L
.56803 .65954 L
.56803 .69774 L
.56803 .73838 L
.56803 .77751 L
.56803 .81909 L
.56803 .85916 L
.56803 .89771 L
.56803 .93871 L
.56803 .97619 L
s
.63605 .02381 m
.63605 .06244 L
.63605 .10458 L
.63605 .14415 L
.63605 .18221 L
.63605 .22272 L
.63605 .26171 L
.63605 .30316 L
.63605 .34309 L
.63605 .3815 L
.63605 .42237 L
.63605 .46172 L
.63605 .49955 L
.63605 .53984 L
.63605 .57861 L
.63605 .61984 L
.63605 .65954 L
.63605 .69774 L
.63605 .73838 L
.63605 .77751 L
.63605 .81909 L
.63605 .85916 L
.63605 .89771 L
.63605 .93871 L
.63605 .97619 L
s
.70408 .02381 m
.70408 .06244 L
.70408 .10458 L
.70408 .14415 L
.70408 .18221 L
.70408 .22272 L
.70408 .26171 L
.70408 .30316 L
.70408 .34309 L
.70408 .3815 L
.70408 .42237 L
.70408 .46172 L
.70408 .49955 L
.70408 .53984 L
.70408 .57861 L
.70408 .61984 L
.70408 .65954 L
.70408 .69774 L
.70408 .73838 L
.70408 .77751 L
.70408 .81909 L
.70408 .85916 L
.70408 .89771 L
.70408 .93871 L
.70408 .97619 L
s
.77211 .02381 m
.77211 .06244 L
.77211 .10458 L
.77211 .14415 L
.77211 .18221 L
.77211 .22272 L
.77211 .26171 L
.77211 .30316 L
.77211 .34309 L
.77211 .3815 L
.77211 .42237 L
.77211 .46172 L
.77211 .49955 L
.77211 .53984 L
.77211 .57861 L
.77211 .61984 L
.77211 .65954 L
.77211 .69774 L
.77211 .73838 L
.77211 .77751 L
.77211 .81909 L
.77211 .85916 L
.77211 .89771 L
.77211 .93871 L
.77211 .97619 L
s
.84014 .02381 m
.84014 .06244 L
.84014 .10458 L
.84014 .14415 L
.84014 .18221 L
.84014 .22272 L
.84014 .26171 L
.84014 .30316 L
.84014 .34309 L
.84014 .3815 L
.84014 .42237 L
.84014 .46172 L
.84014 .49955 L
.84014 .53984 L
.84014 .57861 L
.84014 .61984 L
.84014 .65954 L
.84014 .69774 L
.84014 .73838 L
.84014 .77751 L
.84014 .81909 L
.84014 .85916 L
.84014 .89771 L
.84014 .93871 L
.84014 .97619 L
s
.90816 .02381 m
.90816 .06244 L
.90816 .10458 L
.90816 .14415 L
.90816 .18221 L
.90816 .22272 L
.90816 .26171 L
.90816 .30316 L
.90816 .34309 L
.90816 .3815 L
.90816 .42237 L
.90816 .46172 L
.90816 .49955 L
.90816 .53984 L
.90816 .57861 L
.90816 .61984 L
.90816 .65954 L
.90816 .69774 L
.90816 .73838 L
.90816 .77751 L
.90816 .81909 L
.90816 .85916 L
.90816 .89771 L
.90816 .93871 L
.90816 .97619 L
s
.97619 .02381 m
.97619 .06244 L
.97619 .10458 L
.97619 .14415 L
.97619 .18221 L
.97619 .22272 L
.97619 .26171 L
.97619 .30316 L
.97619 .34309 L
.97619 .3815 L
.97619 .42237 L
.97619 .46172 L
.97619 .49955 L
.97619 .53984 L
.97619 .57861 L
.97619 .61984 L
.97619 .65954 L
.97619 .69774 L
.97619 .73838 L
.97619 .77751 L
.97619 .81909 L
.97619 .85916 L
.97619 .89771 L
.97619 .93871 L
.97619 .97619 L
s
.02381 .02381 m
.06244 .02381 L
.10458 .02381 L
.14415 .02381 L
.18221 .02381 L
.22272 .02381 L
.26171 .02381 L
.30316 .02381 L
.34309 .02381 L
.3815 .02381 L
.42237 .02381 L
.46172 .02381 L
.49955 .02381 L
.53984 .02381 L
.57861 .02381 L
.61984 .02381 L
.65954 .02381 L
.69774 .02381 L
.73838 .02381 L
.77751 .02381 L
.81909 .02381 L
.85916 .02381 L
.89771 .02381 L
.93871 .02381 L
.97619 .02381 L
s
.02381 .09184 m
.06244 .09184 L
.10458 .09184 L
.14415 .09184 L
.18221 .09184 L
.22272 .09184 L
.26171 .09184 L
.30316 .09184 L
.34309 .09184 L
.3815 .09184 L
.42237 .09184 L
.46172 .09184 L
.49955 .09184 L
.53984 .09184 L
.57861 .09184 L
.61984 .09184 L
.65954 .09184 L
.69774 .09184 L
.73838 .09184 L
.77751 .09184 L
.81909 .09184 L
.85916 .09184 L
.89771 .09184 L
.93871 .09184 L
.97619 .09184 L
s
.02381 .15986 m
.06244 .15986 L
.10458 .15986 L
.14415 .15986 L
.18221 .15986 L
.22272 .15986 L
.26171 .15986 L
.30316 .15986 L
.34309 .15986 L
.3815 .15986 L
.42237 .15986 L
.46172 .15986 L
.49955 .15986 L
.53984 .15986 L
.57861 .15986 L
.61984 .15986 L
.65954 .15986 L
.69774 .15986 L
.73838 .15986 L
.77751 .15986 L
.81909 .15986 L
.85916 .15986 L
.89771 .15986 L
.93871 .15986 L
.97619 .15986 L
s
.02381 .22789 m
.06244 .22789 L
.10458 .22789 L
.14415 .22789 L
.18221 .22789 L
.22272 .22789 L
.26171 .22789 L
.30316 .22789 L
.34309 .22789 L
.3815 .22789 L
.42237 .22789 L
.46172 .22789 L
.49955 .22789 L
.53984 .22789 L
.57861 .22789 L
.61984 .22789 L
.65954 .22789 L
.69774 .22789 L
.73838 .22789 L
.77751 .22789 L
.81909 .22789 L
.85916 .22789 L
.89771 .22789 L
.93871 .22789 L
.97619 .22789 L
s
.02381 .29592 m
.06244 .29592 L
.10458 .29592 L
.14415 .29592 L
.18221 .29592 L
.22272 .29592 L
.26171 .29592 L
.30316 .29592 L
.34309 .29592 L
.3815 .29592 L
.42237 .29592 L
.46172 .29592 L
.49955 .29592 L
.53984 .29592 L
.57861 .29592 L
.61984 .29592 L
.65954 .29592 L
.69774 .29592 L
.73838 .29592 L
.77751 .29592 L
.81909 .29592 L
.85916 .29592 L
.89771 .29592 L
.93871 .29592 L
.97619 .29592 L
s
.02381 .36395 m
.06244 .36395 L
.10458 .36395 L
.14415 .36395 L
.18221 .36395 L
.22272 .36395 L
.26171 .36395 L
.30316 .36395 L
.34309 .36395 L
.3815 .36395 L
.42237 .36395 L
.46172 .36395 L
.49955 .36395 L
.53984 .36395 L
.57861 .36395 L
.61984 .36395 L
.65954 .36395 L
.69774 .36395 L
.73838 .36395 L
.77751 .36395 L
.81909 .36395 L
.85916 .36395 L
.89771 .36395 L
.93871 .36395 L
.97619 .36395 L
s
.02381 .43197 m
.06244 .43197 L
.10458 .43197 L
.14415 .43197 L
.18221 .43197 L
.22272 .43197 L
.26171 .43197 L
.30316 .43197 L
.34309 .43197 L
.3815 .43197 L
.42237 .43197 L
.46172 .43197 L
.49955 .43197 L
.53984 .43197 L
.57861 .43197 L
.61984 .43197 L
.65954 .43197 L
.69774 .43197 L
.73838 .43197 L
.77751 .43197 L
.81909 .43197 L
.85916 .43197 L
.89771 .43197 L
.93871 .43197 L
.97619 .43197 L
s
.02381 .5 m
.06244 .5 L
.10458 .5 L
.14415 .5 L
.18221 .5 L
.22272 .5 L
.26171 .5 L
.30316 .5 L
.34309 .5 L
.3815 .5 L
.42237 .5 L
.46172 .5 L
.49955 .5 L
.53984 .5 L
.57861 .5 L
.61984 .5 L
.65954 .5 L
.69774 .5 L
.73838 .5 L
.77751 .5 L
.81909 .5 L
.85916 .5 L
.89771 .5 L
.93871 .5 L
.97619 .5 L
s
.02381 .56803 m
.06244 .56803 L
.10458 .56803 L
.14415 .56803 L
.18221 .56803 L
.22272 .56803 L
.26171 .56803 L
.30316 .56803 L
.34309 .56803 L
.3815 .56803 L
.42237 .56803 L
.46172 .56803 L
.49955 .56803 L
.53984 .56803 L
.57861 .56803 L
.61984 .56803 L
.65954 .56803 L
.69774 .56803 L
.73838 .56803 L
.77751 .56803 L
.81909 .56803 L
.85916 .56803 L
.89771 .56803 L
.93871 .56803 L
.97619 .56803 L
s
.02381 .63605 m
.06244 .63605 L
.10458 .63605 L
.14415 .63605 L
.18221 .63605 L
.22272 .63605 L
.26171 .63605 L
.30316 .63605 L
.34309 .63605 L
.3815 .63605 L
.42237 .63605 L
.46172 .63605 L
.49955 .63605 L
.53984 .63605 L
.57861 .63605 L
.61984 .63605 L
.65954 .63605 L
.69774 .63605 L
.73838 .63605 L
.77751 .63605 L
.81909 .63605 L
.85916 .63605 L
.89771 .63605 L
.93871 .63605 L
.97619 .63605 L
s
.02381 .70408 m
.06244 .70408 L
.10458 .70408 L
.14415 .70408 L
.18221 .70408 L
.22272 .70408 L
.26171 .70408 L
.30316 .70408 L
.34309 .70408 L
.3815 .70408 L
.42237 .70408 L
.46172 .70408 L
.49955 .70408 L
.53984 .70408 L
.57861 .70408 L
.61984 .70408 L
.65954 .70408 L
.69774 .70408 L
.73838 .70408 L
.77751 .70408 L
.81909 .70408 L
.85916 .70408 L
.89771 .70408 L
.93871 .70408 L
.97619 .70408 L
s
.02381 .77211 m
.06244 .77211 L
.10458 .77211 L
.14415 .77211 L
.18221 .77211 L
.22272 .77211 L
.26171 .77211 L
.30316 .77211 L
.34309 .77211 L
.3815 .77211 L
.42237 .77211 L
.46172 .77211 L
.49955 .77211 L
.53984 .77211 L
.57861 .77211 L
.61984 .77211 L
.65954 .77211 L
.69774 .77211 L
.73838 .77211 L
.77751 .77211 L
.81909 .77211 L
.85916 .77211 L
.89771 .77211 L
.93871 .77211 L
.97619 .77211 L
s
.02381 .84014 m
.06244 .84014 L
.10458 .84014 L
.14415 .84014 L
.18221 .84014 L
.22272 .84014 L
.26171 .84014 L
.30316 .84014 L
.34309 .84014 L
.3815 .84014 L
.42237 .84014 L
.46172 .84014 L
.49955 .84014 L
.53984 .84014 L
.57861 .84014 L
.61984 .84014 L
.65954 .84014 L
.69774 .84014 L
.73838 .84014 L
.77751 .84014 L
.81909 .84014 L
.85916 .84014 L
.89771 .84014 L
.93871 .84014 L
.97619 .84014 L
s
.02381 .90816 m
.06244 .90816 L
.10458 .90816 L
.14415 .90816 L
.18221 .90816 L
.22272 .90816 L
.26171 .90816 L
.30316 .90816 L
.34309 .90816 L
.3815 .90816 L
.42237 .90816 L
.46172 .90816 L
.49955 .90816 L
.53984 .90816 L
.57861 .90816 L
.61984 .90816 L
.65954 .90816 L
.69774 .90816 L
.73838 .90816 L
.77751 .90816 L
.81909 .90816 L
.85916 .90816 L
.89771 .90816 L
.93871 .90816 L
.97619 .90816 L
s
.02381 .97619 m
.06244 .97619 L
.10458 .97619 L
.14415 .97619 L
.18221 .97619 L
.22272 .97619 L
.26171 .97619 L
.30316 .97619 L
.34309 .97619 L
.3815 .97619 L
.42237 .97619 L
.46172 .97619 L
.49955 .97619 L
.53984 .97619 L
.57861 .97619 L
.61984 .97619 L
.65954 .97619 L
.69774 .97619 L
.73838 .97619 L
.77751 .97619 L
.81909 .97619 L
.85916 .97619 L
.89771 .97619 L
.93871 .97619 L
.97619 .97619 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oVoooool0
0ooooo_ok^[^oo_oo`2>ooooo`00G_ooool01?ooomcoNBh0o`00;_nUeo8Jooooo`03oooomon[IP3o
000000;o000000?oTLg^ooooooooool05_ooool01OoonnGoV4l0o`000?l0Ci7oiO_o01[ooooo00Ko
oo_Gog000?l0003o0000o`00@Oo8l_lLooooo`04oo_LZom1003o001`om;godgooooo001Gooooo`0;
oo;^j_oZj^[oj^[Zon[Zj_oZk_;oooooon[G`_na/KOo/JF2od5?ROoBk_/05Oooool02oobk^[oj^[Z
on[Zj_oZj^[oj^kbooooooobejGo0000oioBk_okj]Ood^Gg01Sooooo00Gol/f9o`1?ZoooooooZe`0
oh;8kP0Kooooo`05omNUG?l005cocO;kon[GcOoUmol06_ooool01_oooo_oel:gok6g]onUREcoG8:a
on[kodgooooo001Fooooo`03ooool_nA;P3o000000;o000000Oo02jAonkoooo=PP3o0462oinAL?m1
;TooTKgP01Cooooo00?ooooboi4^0?l000000_l000001_l0;Y7ok_ooooooooobg;7o;P00oiS=lQWo
oooo00GodY5?ofJ[g?ooooooh;5Vod69c@0Looooo`03ombaNOl004oocO;o01_ooooo00KoooobohT0
0?m1PYSoTG1Lobi?L?nmh?M=ooooo`00GOooool01?okh:_o@DnUoo_kd_n2TLdNooooo`03ooOBV?l0
073oh?oo01Sooooo00GocHU?ohW8k_ooooool/f9od62`P0Mooooo`03om:H@Ol0I[7onooo01_ooooo
00Coh;5`oebOg?okeiooTLSbC_ooool005kooooo00?ob8U?ogVOWon9V<P07?ooool01Ookl^komooo
oooooon[G03oRLS^01Sooooo00GoiK5`obj9cOoooooodY51ofJ[h00Kooooo`05oo;^l_oooooooooL
oe`0@Oo8l_l06oooool01?ooonkoRD5LoiRUROnHb>i>ooooo`00G_ooool00ooonmcoIP00o`29b00L
ooooo`05om:A@Ol0;X;o_L:[od400?nUg?L06?ooool01Ookh;7o0011oin[Wom1003oZn3g01[ooooo
00Koooogoim10?l^PZ_o_J^2o`00I_oGnolLooooo`03oo_LZol0003oRLS^04kooooo001Oooooo`03
onk=/On[b>Gooooo01_ooooo00CoooogomNmZon9RI7o]m;Z6_ooool00oo^ekOoRH:9okOGkP0Loooo
o`04ooogj_o2ZiSoRHVOom;Zmakooooo00?od[6UolSUmoooool0COooool00?oooooo;Oooool00?oo
oooo;Oooool00?oooooo;Oooool004Sooooo00KomOGeol30`?o8b<Sob<S8olC4a?o3`l<6olS8b003
olC4a?o3`l?ob<S800Gob<S800?o_knookjn__o8b<P01Oo8b<P00oo4a<Co`l?3olS8b005olS8b003
olC4a?o3`l?ob<S800Gob<S800?oa<C4ol?3`oo8b<P01Oo8b<P00onSXj?oXZ:RolS8b005olS8b003
olC4a?o3`l?ob<S800Gob<S800?oa<C4ol?3`oo8b<P01Oo8b<P00oo4a<Co`l?3olS8b005olS8b003
oi^KVonJVY[ob<S800Gob<S800?oa<C4ol?3`oo8b<P01Oo8b<P00oo4a<Co`l?3olS8b005olS8b003
olC4a?o3`l?ob<S800Gob<S800?oWYjNojNWYoo8b<P01Oo8b<P00oo3`l?oa<C4olS8b005olS8b003
ol?3`oo4a<Cob<S800Gob<S800?o`l?3olC4a?o8b<P01Oo8b<P00onNWYkoYjNWolS8b005olS8b003
ol?3`oo4a<Cob<S800Gob<S800Ko`l?3olC4a?o8b<Sob<S8ol30`?oemODjooooo`00B?ooool01_oT
i>Coe=CDooOgmoogmoOom?Cdoo?cl`KomoOg00?om?Cdoo?cloogmoL01OogmoL00ooTi>Cohn?SooOg
m`05ooOgm`03ooCdm?oclo?omoOg00GomoOg00?om?Cdoo?cloogmoL01OogmoL00oodm?Colo?cooOg
m`05ooOgm`03ojZZZ_nYZJWomoOg00GomoOg00?om?Cdoo?cloogmoL01OogmoL00oodm?Colo?cooOg
m`05ooOgm`03ooCdm?oclo?omoOg00GomoOg00?oUIFEoi>CToogmoL01OogmoL00oodm?Colo?cooOg
m`05ooOgm`03ooCdm?oclo?omoOg00GomoOg00?om?Cdoo?cloogmoL01OogmoL00onPX:3o/k>cooOg
m`05ooOgm`03oo?cloodm?ComoOg00GomoOg00?olo?cooCdm?ogmoL01OogmoL00ooclo?om?CdooOg
m`05ooOgm`03oj2PX?nc/k?omoOg00GomoOg00?olo?cooCdm?ogmoL01OogmoL01_oclo?om?CdooOg
moogmoOoeMGEon?Shc[ooooo0018ooooo`03onCTi?oKfm_ooooo057ooooo00?oh>3PomoOgoooool0
DOooool00ooLg=cohn?Sooooo`0iooooo`00B?ooool00ooTi>Cofm_Kooooo`1Aooooo`03on3Ph?oO
gmoooooo057ooooo00?og=cLon?Shoooool0>Oooool004Sooooo00Koi>CTolc<c?ooooooooooon_[
jon7QhL5oi2@T008oi6ATOn@T93oT92@oi2@T?n>SXkoMWIfoi2@T?nATI46oi2@T004oi6ATOn@T93o
OgmoohF5Q@;oT92@00?oTI6Aoi2@T?n@T9001?n@T9000on<S8coNGUioi2@T009oi2@T003ogalO?n:
RX[oT92@00GoT92@00GoTI6Aoi2@T?n@T93oQXJ6ogmoO`02oi2@T003oi6ATOn@T93oT92@00?oT92@
00CoTI6Aoi2@T?mgMgOoSXj>0on@T9000onATI7oT92@oi2@T003oi2@T003og=cLombLW;oT92@00Co
T92@00SoTI6Aoi2@T?n@T93oT92@ohj>S_mfMWKoT92@oi6AT@KoT92@00CoTI6Aoi2@T?mmOGgoQhN7
0_n@T9000onATI7oT92@oi2@T004oi2@T003ohZ:R_mkNg_oT92@00WoT92@00?oNWYjoh^;Ron@T900
1On@T9001OnATI7oT92@oi2@T?n6QXKoOgmo00;oT92@00?oTI6Aoi2@T?n@T9000on@T9000onATI7o
T92@ogEeM@04oi2@T003oi6ATOn@T93oT92@00?oT92@00KoQhN7on[Zj_ooooooooooolg=cOoShn<j
ooooo`00B?ooool01_oTi>CofMWIoooooooooooob<S8ojb/[0Wokno_00?oj>SXoginO_o_knl02Oo_
knl00onTY:Co`/;2ono_k`08ono_k`03omWIfOn=SHgokno_00Wokno_00?oUIFEom7AdOo_knl02?o_
knl00oo2`/;oY:BTono_k`09ono_k`03ogmoOooWinOokno_00Sokno_00?oWIfMoibLW?o_knl02?o_
knl00ooXj>SoOWinono_k`09ono_k`03oifMWOo9bLWokno_00Sokno_00?odM7AoiFEUOo_knl02Oo_
knl00on>SXkof=SHono_k`08ono_k`03ol;2`_nTY:Cokno_00Wokno_00?oMgMgono_koo_knl02?o_
knl01_n][JgoalO7oooooooooooof][Jon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8
b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNG
Uoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOg
moooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOG
eoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_
[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_oo
ool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo
00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo
00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo
00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo
00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo
00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8
okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOo
oooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOo
oooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOo
oooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joo
oooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo
0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03
ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03
om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03
ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03
oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06
okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng
]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGoooo
o`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgoooo
o`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGoooo
o`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_oooo
o`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00
B?ooool01_oTi>Cofm_Koooooooooooob<S8okRh^0Wooooo00?on?ShohR8R?ooool02Oooool00ona
/K7oclo?ooooo`08ooooo`03onSXj?nHV9Sooooo00Wooooo00?oXJ6QomoOgoooool02?ooool00ooA
dM7o[jn_ooooo`09ooooo`03ohR8R?ohn?Sooooo00Sooooo00?oZJVYojNWYoooool02?ooool00ooh
n?SoR8R8ooooo`09ooooo`03ojRXZ?oHf=Sooooo00Sooooo00?ohN7QoinOWoooool02Oooool00onH
V9Soj>SXooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?oPH61ooooooooool02?ooool01_nh
^;Sob<S8oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?o:b/[oooooooooooo8b<So]kNg
2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool0
2Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool0
2?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool0
2?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool0
2Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOoooooooooooo;bl_ohn?S>_ooool004So
oooo00Koi>CTom[Jf_ooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`
olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@
ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?Sh
ohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RH
onOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;Rh
olO7aoooooooooooom_KfooShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wo
oooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wo
oooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00So
oooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00So
oooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wo
oooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018oooo
o`06onCTi?oKfm_oooooooooooo8b<SoS8b<1Oo0`<002?o1`L7o`<30ol30`?o0`<3o^[ZjofEUIOo0
`<3o`L711_o0`<001?o1`L7o`<30ohB4Q?nKVi/2ol30`003ol71`Oo0`<3o`<3000Co`<3000?o[jn_
og5aLOo0`<002Oo0`<000omhN7SoZ:RXol30`005ol30`005ol71`Oo0`<3o`<30oibLW?n3Ph<00_o0
`<000oo1`L7o`<30ol30`003ol30`004ol71`Oo0`<3oIVIVokVi^@?o`<3000?o`L71ol30`?o0`<00
0oo0`<000omoOgooOGemol30`004ol30`008ol71`Oo0`<3o`<30ol30`?nj^[[oIFEUol30`?o1`L46
ol30`004ol71`Oo0`<3oOWinoj6QX@;o`<3000?o`L71ol30`?o0`<001?o0`<000onYZJWoMgMgol30
`009ol30`003og9bL_n^[Zko`<3000Go`<3000Go`L71ol30`?o0`<3oW9bLoh>3P`02ol30`003ol71
`Oo0`<3o`<3000?o`<3000?o`L71ol30`?mPH6001?o0`<000oo1`L7o`<30ol30`003ol30`006ohf=
SOo7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?n;Rh/9
okno_`03okVi^OmUIFGo_kno00Wo_kno00?oPh>3oi^KVono_kl02?no_kl00on][JgoLG5aokno_`09
okno_`03ogMgMonWYjOo_kno00So_kno00?oVi^Koh>3Pono_kl02Ono_kl00omUIFGo^KViokno_`08
okno_`;oOGem2Ono_kl00oni^KWoIFEUokno_`09okno_`03ogemOOnQXJ7o_kno00So_kno00?oYjNW
ogMgMono_kl02Ono_kl00omaLG7o[Jf]okno_`08okno_`03oi^KVon3Ph?o_kno00Wo_kno00?oGemO
okno_ono_kl02?no_kl01_n<S8coalO7oooooooooooog=cLon?Shc[ooooo0012ooooo`04oo_LZom1
003o001`om;go`;ooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo
00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo
00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo
00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo
00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo
00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00>_ooool00ooooo_ok^[Zon[ZjP02
on[ZjP07onkbnooooo_oel:gok6g]onUREcoG8:aon[ko`02ooooo`06onCTi?oKfm_oooooooooooo8
b<So^;Rh2Oooool00oohn?SoR8R8ooooo`09ooooo`03ok6a/Oo?cloooooo00Sooooo00?oj>SXoiRH
V?ooool02Oooool00onQXJ7ogmoOooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?oR8R8ooSh
n?ooool02?ooool00onYZJWoYjNWooooo`08ooooo`03ooShn?n8R8Sooooo00Wooooo00?oZ:RXomSH
f?ooool02?ooool00ooQhN7oWinOooooo`09ooooo`03oiRHV?oXj>Sooooo00Sooooo00?odM7Aojn_
[oooool02Oooool00on1PH7oooooooooo`08ooooo`06okRh^?o8b<SooooooooooooLg=cohn?S>_oo
ool003[ooooo00?oooOBodl00?l000000_l000001ol^RLSoooobohT00?m1PYSoTG1Lobi?L?nmh?L0
0_ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`
/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@
d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00ooh
n?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onH
V9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh
^;SoalO7oooooooooooog=cLon?Shc[ooooo0011ooooo`04on2aL?mLWmconmNOoi78lP?ooooo00Ko
i>CTojZZZ_olo?coooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?cooo
ool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[ooo
ool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qooo
ool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWiooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooo
oooon?Shoj^[ZooShn<jooooo`00@Oooool01?ooonkoRD5LoiRUROnHb>h3ooooo`06onCTi?oHf=So
ooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo
00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo
00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo
00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo
00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooI
fMWohn?S>_ooool004;ooooo00?onmb[o`000?n9b>h00oooool01_oTi>Cofm_Koooooooooooob<S8
okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOo
oooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOo
oooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOo
oooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joo
oooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo
0013ooooo`03om:aYOo8iOOooooo00;ooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03
ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03
oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03
ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03
on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03
oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oT
i>Cofm_Koooooooooooob<S8okRh^0Wooooo00?on?ShohR8R?ooool02Oooool00ona/K7oclo?oooo
o`08ooooo`03onSXj?nHV9Sooooo00Wooooo00?oXJ6QomoOgoooool02?ooool00ooAdM7o[jn_oooo
o`09ooooo`03ohR8R?ohn?Sooooo00Sooooo00?oZJVYojNWYoooool02?ooool00oohn?SoR8R8oooo
o`09ooooo`03ojRXZ?oHf=Sooooo00Sooooo00?ohN7QoinOWoooool02Oooool00onHV9Soj>SXoooo
o`08ooooo`03om7AdOn_[joooooo00Wooooo00?oPH61ooooooooool02?ooool01_nh^;Sob<S8oooo
oooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00ooh
n?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onP
X:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onX
Z:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooP
h>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0
P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CT
om_KfoooooooooooolS8b?na/K45ooShn008ooWinOohn?Son?ShooShn?oalO7oPh>3ooShn?oinOT6
ooShn004ooWinOohn?SoZj^[olW9b@;on?Sh00?onOWiooShn?ohn?P01?ohn?P00ooQhN7oTY:BooSh
n009ooShn003oi^KVooHf=Son?Sh00Gon?Sh00GonOWiooShn?ohn?Sob/[:ojZZZP0:ooShn003ohB4
Q?o`l?3on?Sh00Son?Sh00?oXj>Soj:RX_ohn?P02?ohn?P00ooalO7oPh>3ooShn007ooShn004ooWi
nOohn?SoXj>Som7Ad@;on?Sh00?onOWiooShn?ohn?P01?ohn?P00ooIfMWoVYZJooShn009ooShn003
oi>CTooPh>3on?Sh00Son?Sh00?ob/[:ojZZZ_ohn?P01oohn?P00ooinOWon?ShogalO004ooShn003
ooWinOohn?Son?Sh00?on?Sh00Ko/[:bolO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oT
i>Cofm_Koooooooooooob<S8ofIVIPWoQhN700?oPh>3odM7Aon7QhL02On7QhL00omMGEgoKFe]ohN7
Q`08ohN7Q`03og]kNom?CdooQhN700WoQhN700?oE5ADogIfM_n7QhL02?n7QhL01Om^KVkoG5aLohN7
Qon7QhOoR8R800GoQhN700CoR8R8ohN7Qom8B4SoPX:20on7QhL00on8R8SoQhN7ohN7Q`03ohN7Q`03
oeUIFOmHF5SoQhN700CoQhN700SoR8R8ohN7Qon7QhOoQhN7oh>3Pom7AdOoQhN7ohR8R0SoQhN700?o
F5QHog5aLOn7QhL02?n7QhL00omgMgOoE5ADohN7Q`09ohN7Q`03oe1@D?mkNg_oQhN700GoQhN700Go
R8R8ohN7Qon7QhOoKVi^oeaLG002ohN7Q`03ohR8R?n7QhOoQhN700GoQhN700?o@d=3ohN7Qon7QhL0
2?n7QhL01_mWIfOoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?o:b/[ooooooooo
ooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SX
oiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8
ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RX
omOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@
ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOoooooooooooo;bl_ohn?S
>_ooool004Sooooo00Koi>CTom[Jf_ooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wo
oooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00So
oooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00So
oooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wo
oooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00So
oooo00Ko^;RholO7aoooooooooooom_KfooShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooo
b<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nG
UiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?og
moOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oG
emOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_
[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[o
oooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So^;Rh2Oooool00oohn?SoR8R8ooooo`09oooo
o`03ok6a/Oo?cloooooo00Sooooo00?oj>SXoiRHV?ooool02Oooool00onQXJ7ogmoOooooo`08oooo
o`03om7AdOn_[joooooo00Wooooo00?oR8R8ooShn?ooool02?ooool00onYZJWoYjNWooooo`08oooo
o`03ooShn?n8R8Sooooo00Wooooo00?oZ:RXomSHf?ooool02?ooool00ooQhN7oWinOooooo`09oooo
o`03oiRHV?oXj>Sooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on1PH7oooooooooo`08oooo
o`06okRh^?o8b<SooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8
b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNG
ooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOg
ooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOG
ooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_
ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<joooo
o`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool0
0on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool0
0oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool0
0oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool0
0onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool0
1_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So
]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUooo
ool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmooo
ool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeooo
ool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[ooo
ool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool0
04Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o
/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?o
d=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?o
n?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?o
V9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko
^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cob/[:oooooooooooob<S8okNg
]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo
00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo
00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo
00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo
00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooobl_;on?Shc[ooooo0018
ooooo`06onCTi?oJf][oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`
/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@
d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooSh
n?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRH
V?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh
^?o7alOooooooooooooKfm_ohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?n1PH45
ok2`/008ok6a/On`/;3o/;2`ok2`/?n[Zj_oGEeMok2`/?na/K46ok2`/004ok6a/On`/;3oNGUiohj>
SP;o/;2`00?o/K6aok2`/?n`/;001?n`/;000onQXJ7oJ6QXok2`/009ok2`/003ofi^K_nJVY[o/;2`
00Go/;2`00Go/K6aok2`/?n`/;3oShn?ogQhN002ok2`/003ok6a/On`/;3o/;2`00?o/;2`00Co/K6a
ok2`/?mMGEgoZZZZ0on`/;000ona/K7o/;2`ok2`/003ok2`/003ogAdM?mcLg?o/;2`00Co/;2`00So
/K6aok2`/?n`/;3o/;2`oj^[ZomMGEgo/;2`ok6a/@Ko/;2`00Co/K6aok2`/?mcLg?oU9BD0_n`/;00
0ona/K7o/;2`ok2`/004ok2`/003oi^KVom]KFgo/;2`00Wo/;2`00?oJ6QXoj2PX?n`/;001On`/;00
1Ona/K7o/;2`ok2`/?n?ShooN7Qh00;o/;2`00?o/K6aok2`/?n`/;000on`/;000ona/K7o/;2`oeQH
F004ok2`/003ok6a/On`/;3o/;2`00?o/;2`00KoPX:2olO7aoooooooooooomcLg?oShn<jooooo`00
B?ooool01_oTi>Cofm_Koooooooooooob<S8oiJFUPWoclo?00?obLW9ofe]KOo?cll02Oo?cll00on>
SXkoZ:RXolo?c`08olo?c`03okbl_?mjNW[oclo?00Woclo?00?oPH61okFe]Oo?cll02?o?cll00onX
Z:SoSXj>olo?c`09olo?c`03ofi^K_o8b<Soclo?00Soclo?00?oR8R8ohN7Qoo?cll02?o?cll00oo9
bLWoKFe]olo?c`09olo?c`03ohR8R?n^[Zkoclo?00Soclo?00?o]KFeoh61POo?cll02Oo?cll00omk
Ng_o^k^kolo?c`08olo?c`03ojRXZ?n>SXkoclo?00Woclo?00?oIfMWolo?coo?cll02?o?cll01_nG
UiOoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg
2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool0
2Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool0
2?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool0
2?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool0
2Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004So
oooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`
olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@
ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?Sh
ohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RH
onOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;Rh
olO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wo
oooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wo
oooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00So
oooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00So
oooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wo
oooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018oooo
o`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?
cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_
[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7
QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oW
inOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7
alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTol[:b_ooooooooooolS8b?nh^;P9oooo
o`03ooShn?n8R8Sooooo00Wooooo00?o/K6aolo?coooool02?ooool00ooXj>SoV9RHooooo`09oooo
o`03oj6QXOoOgmoooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on8R8Son?Shooooo`08oooo
o`03ojVYZOnWYjOooooo00Sooooo00?on?ShohR8R?ooool02Oooool00onXZ:Sof=SHooooo`08oooo
o`03on7QhOnOWioooooo00Wooooo00?oV9RHonSXj?ooool02?ooool00ooAdM7o[jn_ooooo`09oooo
o`03oh61POoooooooooo00Sooooo00Ko^;RholS8b?oooooooooool_;booShn<jooooo`00B?ooool0
1_oTi>Cof][Joooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?
ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_
ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7
ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOW
ooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7
oooooooooooofm_Kon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool0
0oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool0
0onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool0
0onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool0
0ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool0
0on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Ko
i>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?cooo
ool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[ooo
ool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qooo
ool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWiooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooo
ooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?o
n?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?o
X:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?o
Z:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?o
h>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?o
P820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0010ooooo`06oook
eom`003o0000o`000?l0047ob?;o0_ooool01_oTi>Cofm_Koooooooooooob<S8ojNWY`Goj>SX00So
jNWYonSXj?oXj>Soj>SXon7QhOmjNW[oj>SXonWYj@Koj>SX00CojNWYonSXj?nPX:3o_;bl0_oXj>P0
0ooYjNWoj>SXonSXj004onSXj003om?Cdon9RHWoj>SX00Woj>SX00?oTI6Aol[:b_oXj>P01OoXj>P0
1OoYjNWoj>SXonSXj?nm_KgoWinO00[oj>SX00?oNg]kon3Ph?oXj>P02?oXj>P00onHV9SoUiNGonSX
j008onSXj003on7QhOmjNW[oj>SX00Ooj>SX00CojNWYonSXj?nHV9So`l?30_oXj>P00ooYjNWoj>SX
onSXj004onSXj003ol_;bon@T93oj>SX00Woj>SX00?oRXZ:om;Bd_oXj>P02?oXj>P00onm_KgoWinO
onSXj007onSXj003onWYjOoXj>SoM7Ad00Coj>SX00?ojNWYonSXj?oXj>P00ooXj>P01_nXZ:SoalO7
oooooooooooog=cLon?Shc[ooooo000jooooo`03oooonoo^j^[oj^[Z00;oj^[Z00Ook_;koooooooG
YEco001LolgbnooZelgoiOOo00;ooooo00Koi>CTom_KfoooooooooooolS8b?maLG49oiNGU`03oi:B
T_m?CdooUiNG00WoUiNG00?oJ6QXogYjN_nGUiL02?nGUiL00on:RX[oFEUIoiNGU`09oiNGU`03oeiN
G_n4Q8CoUiNG00SoUiNG00GoNg]kofMWIonGUiOoUiNGoiRHV005oiNGU`04oiRHV?nGUiOoD51@oi:B
TP?oUiNG00?oV9RHoiNGUonGUiL00onGUiL00omTI6CoHV9RoiNGU`04oiNGU`08oiRHV?nGUiOoUiNG
oiNGUonBTY;oCdm?oiNGUonHV9P8oiNGU`03of=SHomoOgooUiNG00SoUiNG00?oQHF5oeiNG_nGUiL0
2OnGUiL00omJFU[oRHV9oiNGU`05oiNGU`05oiRHV?nGUiOoUiNGog]kNomWIfL00_nGUiL00onHV9So
UiNGoiNGU`05oiNGU`03od];BonGUiOoUiNG00SoUiNG00KoLW9bolO7aoooooooooooomcLg?oShn<j
ooooo`00>_ooool00ooomm;oC`00o`000002o`000006obj9b?ooooooooooombaNOl004oocO;o0ooo
ool01_oTi>Cofm_KoooooooooooobLW9okNg]`Wooooo00?onOWiohN7Qoooool02Oooool00ona/K7o
clo?ooooo`08ooooo`03onWYjOnGUiOooooo00Wooooo00?oXJ6QomoOgoooool02?ooool00ooAdM7o
[jn_ooooo`09ooooo`03ohV9ROogmoOooooo00Sooooo00?oZJVYojNWYoooool02?ooool00ooinOWo
QhN7ooooo`09ooooo`03ojVYZOoGemOooooo00Sooooo00?ohN7QoinOWoooool02Oooool00onIVIWo
inOWooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?oPH61ooooooooool02?ooool01_ni^KWo
alO7oooooooooooog=cLon?Shc[ooooo0013ooooo`03om:H@Ol0I[7onooo00;ooooo00Koi>CTojZZ
Z_olo?coooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?oo
ool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Ooo
ool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Ooo
ool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?oo
ool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooooooon?Sh
oj^[ZooShn<jooooo`00@Oooool01Oobk_;ooooooooog?mL047ob?;o00;ooooo00Koi>CTomSHf?oo
ooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool0
0ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool0
0on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool0
0onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool0
0oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomWI
fOoShn<jooooo`00@?ooool01_ooooOoWd40obj2ZonmZh;o001VomOko`;ooooo00Koi>CTom_Kfooo
ooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool0
0ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool0
0on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool0
0onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool0
0oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcL
g?oShn<jooooo`00@Oooool01?oomn[o`Z^HohV9WooBj_L3ooooo`06onCTi?oKfm_oooooooooooo8
b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNG
Uoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOg
moooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOG
eoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_
[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_oo
ool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo
00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo
00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo
00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo
00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo
00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8
okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOo
oooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOo
oooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOo
oooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joo
oooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo
0018ooooo`06onCTi?oKfm_oooooooooooo8b<So^;Rh2Oooool00oohn?SoR8R8ooooo`09ooooo`03
ok6a/Oo?cloooooo00Sooooo00?oj>SXoiRHV?ooool02Oooool00onQXJ7ogmoOooooo`08ooooo`03
om7AdOn_[joooooo00Wooooo00?oR8R8ooShn?ooool02?ooool00onYZJWoYjNWooooo`08ooooo`03
ooShn?n8R8Sooooo00Wooooo00?oZ:RXomSHf?ooool02?ooool00ooQhN7oWinOooooo`09ooooo`03
oiRHV?oXj>Sooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on1PH7oooooooooo`08ooooo`06
okRh^?o8b<SooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng
]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGoooo
o`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgoooo
o`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGoooo
o`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_oooo
o`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00
B?ooool01_oTi>Cob/[:oooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`
/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@
d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00ooh
n?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onH
V9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh
^;SoalO7oooooooooooobl_;on?Shc[ooooo0018ooooo`06onCTi?oJf][oooooooooooo8b<SoLG5a
1OnHV9P02?nIVIWoV9RHoiRHV?nHV9SoTi>Coe1@D?nHV9SoVIVI1_nHV9P01?nIVIWoV9RHofQXJ?mk
Ng/2oiRHV003oiVIVOnHV9SoV9RH00CoV9RH00?oRXZ:oeYJF_nHV9P02OnHV9P00omOGeooQ8B4oiRH
V005oiRHV005oiVIVOnHV9SoV9RHog]kNomXJ6P02_nHV9P00omADE7oTi>CoiRHV008oiRHV003ofAT
I?mSHf?oV9RH00SoV9RH00?oTi>Coe1@D?nHV9P01onHV9P01?nIVIWoV9RHofATI?n0P802oiRHV003
oiVIVOnHV9SoV9RH00CoV9RH00?oQHF5oeiNG_nHV9P02OnHV9P00omJFU[oRHV9oiRHV008oiRHV003
og]kNomXJ6SoV9RH00OoV9RH00?oVIVIoiRHV?m<C4`01?nHV9P00onIVIWoV9RHoiRHV003oiRHV006
og9bL_o7alOooooooooooooKfm_ohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?nW
YjL9onOWi`03on3Ph?mjNW[oinOW00WoinOW00?oWinOok^k^ooWinL02?oWinL00ooCdm?oR8R8onOW
i`09onOWi`03oi2@T?o:b/[oinOW00SoinOW00Go_;bloijNW_oWinOoinOWonSXj005onOWi`04onSX
j?oWinOoNg]komoOg`?oinOW00?oj>SXonOWiooWinL00ooWinL00onHV9SoUiNGonOWi`04onOWi`08
onSXj?oWinOoinOWonOWiooPh>3oNWYjonOWiooXj>P8onOWi`03oiRHV?o2`/;oinOW00SoinOW00?o
bl_;oi2@T?oWinL02OoWinL00on9RHWod];BonOWi`05onOWi`05onSXj?oWinOoinOWokbl_?nNWYh0
0_oWinL00ooXj>SoinOWonOWi`05onOWi`03og=cLooWinOoinOW00SoinOW00KoZ:RXolO7aooooooo
ooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?Sh
ohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2P
omoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RX
ojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3P
oinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820
ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oK
fm_oooooooooooo9bLWo]kNg2Oooool00ooinOWoQhN7ooooo`09ooooo`03ok6a/Oo?cloooooo00So
oooo00?ojNWYoiNGUoooool02Oooool00onQXJ7ogmoOooooo`08ooooo`03om7AdOn_[joooooo00Wo
oooo00?oRHV9ooOgmoooool02?ooool00onYZJWoYjNWooooo`08ooooo`03ooWinOn7QhOooooo00Wo
oooo00?oZJVYomOGeoooool02?ooool00ooQhN7oWinOooooo`09ooooo`03oiVIVOoWinOooooo00So
oooo00?odM7Aojn_[oooool02Oooool00on1PH7oooooooooo`08ooooo`06okVi^Oo7alOooooooooo
oooLg=cohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7
QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oO
gmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nW
YjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nO
Wioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oo
oooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_K
oooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08oooo
o`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09oooo
o`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09oooo
o`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08oooo
o`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooo
g=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7
ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoO
ooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNW
ooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinO
ooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83ooooo
ooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTol[:b_oo
ooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool0
0ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool0
0on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool0
0onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool0
0oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooooooooooool_;
booShn<jooooo`00B?ooool01_oTi>Cof][Joooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qooo
ool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYooo
ool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWooo
ool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820oooooooo
ool02?ooool01_nh^;SoalO7oooooooooooofm_Kon?Shc[ooooo0018ooooo`06onCTi?oKfm_ooooo
ooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?o
j>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?o
R8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?o
Z:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?o
d=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=co
hn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolW9bOng]kL9ooooo`03ooWinOn7QhOooooo
00Wooooo00?o/K6aolo?coooool02?ooool00ooYjNWoUiNGooooo`09ooooo`03oj6QXOoOgmoooooo
00Sooooo00?odM7Aojn_[oooool02Oooool00on9RHWomoOgooooo`08ooooo`03ojVYZOnWYjOooooo
00Sooooo00?onOWiohN7Qoooool02Oooool00onYZJWoemOGooooo`08ooooo`03on7QhOnOWioooooo
00Wooooo00?oVIVIonOWioooool02?ooool00ooAdM7o[jn_ooooo`09ooooo`03oh61POoooooooooo
00Sooooo00Ko^KViolO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooo
oooob<S8oiNGU`God=3@00SodM7Aom3@d?o@d=3od=3@ol[:b_m^KVkod=3@om7Ad@Kod=3@00CodM7A
om3@d?n?ShooZ:RX0_o@d=000ooAdM7od=3@om3@d004om3@d003okjn__mkNg_od=3@00Wod=3@00?o
PX:2okJf]_o@d=001Oo@d=001OoAdM7od=3@om3@d?nYZJWoSXj>00;od=3@00?odM7Aom3@d?o@d=00
0oo@d=001?oAdM7od=3@ofi^K_o9bLT3om3@d003om7AdOo@d=3od=3@00?od=3@00?oRHV9ohR8R?o@
d=001?o@d=002?oAdM7od=3@om3@d?o@d=3ob/[:ofi^K_o@d=3odM7A1_o@d=001?oAdM7od=3@ohV9
ROn_[jl2om3@d003om7AdOo@d=3od=3@00Cod=3@00?o]kNgoh61POo@d=002Oo@d=000omkNg_o_Kfm
om3@d005om3@d005om7AdOo@d=3od=3@ojVYZOn>SXh00_o@d=000ooAdM7od=3@om3@d003om3@d003
om7AdOo@d=3oJ6QX00Cod=3@00?odM7Aom3@d?o@d=000oo@d=001_nHV9SoalO7oooooooooooog=cL
on?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<SoPH612On_[jl00onZZZ[oG5aLojn_
[`09ojn_[`03ogQhN?n>SXko[jn_00So[jn_00?oWinOofMWIon_[jl02On_[jl00om]KFgoVIVIojn_
[`08ojn_[`03ohj>S_mhN7So[jn_00Wo[jn_00?oGEeMojVYZOn_[jl02?n_[jl00omcLg?oLW9bojn_
[`08ojn_[`03ojZZZ_mLG5co[jn_00Wo[jn_00?oLg=coi>CTon_[jl02?n_[jl00onIVIWoKFe]ojn_
[`09ojn_[`03ofQXJ?nNWYko[jn_00So[jn_00?oSXj>ogQhN?n_[jl02On_[jl00omGEeOo[jn_ojn_
[`08ojn_[`06oh61POo7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_Kfooooooo
ooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooX
j>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8
R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onX
Z:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@
d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oS
hn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool0
2Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool0
2?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool0
2?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool0
2Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool0
2?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?o:b/[ooooooooo
ooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SX
oiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8
ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RX
omOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@
ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOoooooooooooo;bl_ohn?S
>_ooool004Sooooo00Koi>CTom[Jf_ooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wo
oooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00So
oooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00So
oooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wo
oooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00So
oooo00Ko^;RholO7aoooooooooooom_KfooShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooo
bLW9okNg]`Wooooo00?onOWiohN7Qoooool02Oooool00ona/K7oclo?ooooo`08ooooo`03onWYjOnG
UiOooooo00Wooooo00?oXJ6QomoOgoooool02?ooool00ooAdM7o[jn_ooooo`09ooooo`03ohV9ROog
moOooooo00Sooooo00?oZJVYojNWYoooool02?ooool00ooinOWoQhN7ooooo`09ooooo`03ojVYZOoG
emOooooo00Sooooo00?ohN7QoinOWoooool02Oooool00onIVIWoinOWooooo`08ooooo`03om7AdOn_
[joooooo00Wooooo00?oPH61ooooooooool02?ooool01_ni^KWoalO7oooooooooooog=cLon?Shc[o
oooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09oooo
o`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08oooo
o`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08oooo
o`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09oooo
o`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08oooo
o`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004;ooooo00?ooo_bonk^l_ooool00oooool0
1_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?
ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_
ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7
ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOW
ooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7
oooooooooooog=cLon?Shc[ooooo0011ooooo`05oo_U`_mL003o0000odnA`_okool00_ooool01_oT
i>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?oooo
o`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_oooo
o`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7oooo
o`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWoooo
o`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooo
oooooooog=cLon?Shc[ooooo0011ooooo`05olf9;_m?YN3ooooPoe`0;_o2l_l00_ooool01_oTi>Co
fm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08
ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09
ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09
ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08
ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooo
oooog=cLon?Shc[ooooo0010ooooo`06ooool_nH@BkoZn3koooononaIRkoRLg^0_ooool01_oTi>Co
fm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08
ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09
ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09
ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08
ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooo
oooog=cLon?Shc[ooooo0010ooooo`06ooook_n9;Toob?;oooooooo=RDooP/;^0_ooool01_oTi>Co
Q8B4ol71`Oo4a<CoVYZJodi>CPGoJ6QX00SoJFUYofQXJ?mXJ6SoJ6QXofEUIOlf=SKoJ6QXofUYJ@Ko
J6QX00CoJFUYofQXJ?m8B4SoE5AD0_mXJ6P00omYJFWoJ6QXofQXJ004ofQXJ003oemOGolm?CgoJ6QX
00WoJ6QX00?o@D51oe]KFomXJ6P01OmXJ6P01OmYJFWoJ6QXofQXJ?mEEEGoAdM700[oJ6QX00?o>3Ph
ofATI?mXJ6P02?mXJ6P00om5ADGoA4A4ofQXJ008ofQXJ003ofEUIOlf=SKoJ6QX00OoJ6QX00CoJFUY
ofQXJ?m4A4CoF5QH0_mXJ6P00omYJFWoJ6QXofQXJ004ofQXJ003oe]KFom1@D7oJ6QX00WoJ6QX00?o
?ShnoeiNG_mXJ6P02?mXJ6P00omEEEGoAdM7ofQXJ007ofQXJ003ofUYJOmXJ6So=3@d00CoJ6QX00?o
JFUYofQXJ?mXJ6P00omXJ6P01_m?CdooV9RHolC4a?nn_[koQHF5on?Shc[ooooo0010ooooo`06oooo
nongIRkoRLggoooomonA;RkoZn3k0_ooool01_oTi>CoeMGEoo_knookno_oa<C4ojn_[`Wolo?c00?o
k>c/ogmoOooclo<02Ooclo<00onWYjOoa<C4oo?cl`08oo?cl`03omgMgOn?Shoolo?c00Wolo?c00?o
V9RHomCDe?oclo<02?oclo<01Oo5aLGoYZJVoo?clooclo?om?Cd00Golo?c00Com?Cdoo?clon0P83o
jn_[0ooclo<00oodm?Colo?coo?cl`03oo?cl`03oj2PX?nNWYkolo?c00Colo?c00Som?Cdoo?clooc
lo?olo?conc/k?moOgoolo?cooCdm0Solo?c00?oWinOolc<c?oclo<02?oclo<00ooEeMGoUiNGoo?c
l`09oo?cl`03oi2@T?oLg=colo?c00Golo?c00Gom?Cdoo?clooclo?oaLG5ojJVYP02oo?cl`03ooCd
m?oclo?olo?c00Golo?c00?oNGUioo?clooclo<02?oclo<01_n`/;3o`l?3oo_knookno_oe]KFon?S
hc[ooooo0011ooooo`05on2aL?l0;WWoZjEio`00L?oLnol00_ooool01_oTi>Cofm_Koooooooooooo
b<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nG
UiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?og
moOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oG
emOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_
[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[o
oooo0012ooooo`03omNgWon2RIooenko00?ooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9oooo
o`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09oooo
o`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08oooo
o`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08oooo
o`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09oooo
o`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool0
1_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?
ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_
ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7
ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOW
ooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7
oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool0
0oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool0
0onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool0
0onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool0
0ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool0
0on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Ko
i>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?cooo
ool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[ooo
ool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qooo
ool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWiooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooo
ooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_KoooooooooooobLW9okNg]`Wooooo00?o
nOWiohN7Qoooool02Oooool00ona/K7oclo?ooooo`08ooooo`03onWYjOnGUiOooooo00Wooooo00?o
XJ6QomoOgoooool02?ooool00ooAdM7o[jn_ooooo`09ooooo`03ohV9ROogmoOooooo00Sooooo00?o
ZJVYojNWYoooool02?ooool00ooinOWoQhN7ooooo`09ooooo`03ojVYZOoGemOooooo00Sooooo00?o
hN7QoinOWoooool02Oooool00onIVIWoinOWooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?o
PH61ooooooooool02?ooool01_ni^KWoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCT
i?o:b/[oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo
00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo
00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo
00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo
00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooo
ooooooo;bl_ohn?S>_ooool004Sooooo00Koi>CTom[Jf_ooooooooooolS8b?ng]kL9ooooo`03ooSh
n?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2P
X?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRX
Z?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3P
h?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20
P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooom_KfooShn<jooooo`00B?ooool01_oTi>Co
fm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08
ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09
ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09
ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08
ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooo
oooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<SoS8b<1Oo0`<002?o1`L7o
`<30ol30`?o0`<3o^[ZjofEUIOo0`<3o`L711_o0`<001?o1`L7o`<30ohB4Q?nKVi/2ol30`003ol71
`Oo0`<3o`<3000Co`<3000?o[jn_og5aLOo0`<002Oo0`<000omhN7SoZ:RXol30`005ol30`005ol71
`Oo0`<3o`<30oibLW?n3Ph<00_o0`<000oo1`L7o`<30ol30`003ol30`004ol71`Oo0`<3oIVIVokVi
^@?o`<3000?o`L71ol30`?o0`<000oo0`<000omoOgooOGemol30`004ol30`008ol71`Oo0`<3o`<30
ol30`?nj^[[oIFEUol30`?o1`L46ol30`004ol71`Oo0`<3oOWinoj6QX@;o`<3000?o`L71ol30`?o0
`<001?o0`<000onYZJWoMgMgol30`009ol30`003og9bL_n^[Zko`<3000Go`<3000Go`L71ol30`?o0
`<3oW9bLoh>3P`02ol30`003ol71`Oo0`<3o`<3000?o`<3000?o`L71ol30`?mPH6001?o0`<000oo1
`L7o`<30ol30`003ol30`006ohf=SOo7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CT
om_KfoooooooooooolS8b?n;Rh/9okno_`03okVi^OmUIFGo_kno00Wo_kno00?oPh>3oi^KVono_kl0
2?no_kl00on][JgoLG5aokno_`09okno_`03ogMgMonWYjOo_kno00So_kno00?oVi^Koh>3Pono_kl0
2Ono_kl00omUIFGo^KViokno_`08okno_`;oOGem2Ono_kl00oni^KWoIFEUokno_`09okno_`03ogem
OOnQXJ7o_kno00So_kno00?oYjNWogMgMono_kl02Ono_kl00omaLG7o[Jf]okno_`08okno_`03oi^K
Von3Ph?o_kno00Wo_kno00?oGemOokno_ono_kl02?no_kl01_n<S8coalO7oooooooooooog=cLon?S
hc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo9bLWo]kNg2Oooool00ooinOWoQhN7ooooo`09
ooooo`03ok6a/Oo?cloooooo00Sooooo00?ojNWYoiNGUoooool02Oooool00onQXJ7ogmoOooooo`08
ooooo`03om7AdOn_[joooooo00Wooooo00?oRHV9ooOgmoooool02?ooool00onYZJWoYjNWooooo`08
ooooo`03ooWinOn7QhOooooo00Wooooo00?oZJVYomOGeoooool02?ooool00ooQhN7oWinOooooo`09
ooooo`03oiVIVOoWinOooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on1PH7oooooooooo`08
ooooo`06okVi^Oo7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_Kfooooooooooo
olS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>So
UiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8So
moOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:So
emOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o
[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<j
ooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Ooo
ool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?oo
ool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?oo
ool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Ooo
ool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?oo
ool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?o:b/[oooooooooooo8
b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNG
Uoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOg
moooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOG
eoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_
[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOoooooooooooo;bl_ohn?S>_oo
ool004Sooooo00Koi>CTom[Jf_ooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo
00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo
00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo
00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo
00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo
00Ko^;RholO7aoooooooooooom_KfooShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8
okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOo
oooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOo
oooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOo
oooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joo
oooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo
0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03
ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03
om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03
ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03
oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06
okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?nh
^;P9ooooo`03ooShn?n8R8Sooooo00Wooooo00?o/K6aolo?coooool02?ooool00ooXj>SoV9RHoooo
o`09ooooo`03oj6QXOoOgmoooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on8R8Son?Shoooo
o`08ooooo`03ojVYZOnWYjOooooo00Sooooo00?on?ShohR8R?ooool02Oooool00onXZ:Sof=SHoooo
o`08ooooo`03on7QhOnOWioooooo00Wooooo00?oV9RHonSXj?ooool02?ooool00ooAdM7o[jn_oooo
o`09ooooo`03oh61POoooooooooo00Sooooo00Ko^;RholS8b?ooooooooooomcLg?oShn<jooooo`00
B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`
/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@
d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00ooh
n?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onH
V9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh
^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So[:b/
1Oo`l?002?oalO7ol?3`oo3`l?o`l?3ojNWYogmoOoo`l?3olO7a1_o`l?001?oalO7ol?3`ojFUYOo2
`/82oo3`l003oo7alOo`l?3ol?3`00Col?3`00?ofm_Kohj>S_o`l?002Oo`l?000onFUYKod];Boo3`
l005oo3`l005oo7alOo`l?3ol?3`ol?3`onTY:@00_o`l?000ooalO7ol?3`oo3`l003oo3`l004oo7a
lOo`l?3oP820onSXj0?ol?3`00?olO7aoo3`l?o`l?000oo`l?000onNWYkoWIfMoo3`l004oo3`l008
oo7alOo`l?3ol?3`oo3`l?oYjNWoOgmooo3`l?oalO46oo3`l004oo7alOo`l?3oWYjNol[:bP;ol?3`
00?olO7aoo3`l?o`l?001?o`l?000ooCdm?oUIFEoo3`l009oo3`l003ohn?SooJf][ol?3`00Gol?3`
00GolO7aoo3`l?o`l?3o`l?3ojBTY002oo3`l003oo7alOo`l?3ol?3`00?ol?3`00?olO7aoo3`l?mh
N7P01?o`l?000ooalO7ol?3`oo3`l003oo3`l006ojf][Oo7alOooooooooooooLg=cohn?S>_ooool0
04Sooooo00Koi>CTom_KfoooooooooooolS8b?m[Jf/9ohn?S`03oh^;Rom;Bd_oShn?00WoShn?00?o
HV9RogAdM?n?Shl02?n?Shl00on2PX;oE5ADohn?S`09ohn?S`03oeUIFOmmOGgoShn?00SoShn?00?o
M7Adof9RH_n?Shl02On?Shl00om<C4coRXZ:ohn?S`08ohn?S`03oeiNG_mMGEgoShn?00SoShn?00?o
Rh^;od];Bon?Shl02On?Shl00omNGUkoN7Qhohn?S`08ohn?S`03ogemOOmIFEWoShn?00WoShn?00?o
EEEEoh61POn?Shl02?n?Shl00omdM7CoHV9Rohn?S`09ohn?S`03odM7Aon?ShooShn?00SoShn?00Ko
K6a/olO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cob/[:oooooooooooob<S8okNg
]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo
00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo
00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo
00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo
00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooobl_;on?Shc[ooooo0018
ooooo`06onCTi?oJf][oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`
/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@
d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooSh
n?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRH
V?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh
^?o7alOooooooooooooKfm_ohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9
ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09
ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08
ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08
ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09
ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?oo
ool01_oTi>Cofm_Koooooooooooob<S8okRh^0Wooooo00?on?ShohR8R?ooool02Oooool00ona/K7o
clo?ooooo`08ooooo`03onSXj?nHV9Sooooo00Wooooo00?oXJ6QomoOgoooool02?ooool00ooAdM7o
[jn_ooooo`09ooooo`03ohR8R?ohn?Sooooo00Sooooo00?oZJVYojNWYoooool02?ooool00oohn?So
R8R8ooooo`09ooooo`03ojRXZ?oHf=Sooooo00Sooooo00?ohN7QoinOWoooool02Oooool00onHV9So
j>SXooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?oPH61ooooooooool02?ooool01_nh^;So
b<S8oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Ooo
ool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Ooo
ool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?oo
ool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?oo
ool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Ooo
ool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool0043ooooo
00Kooo_Gog000?l0003o0000o`00@Oo8l_l2ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Ooo
ool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Ooo
ool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?oo
ool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?oo
ool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Ooo
ool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool0047ooooo
00GoejELo`00G?o=l__oj]O=onGgo`02ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool0
0oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool0
0onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool0
0onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool0
0ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool0
0on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004;ooooo00?o
g;5io`00Coo=l_l00oooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qooo
ool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYooo
ool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWooo
ool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820oooooooo
ool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0013ooooo`03om:H@Ol0I[7onooo
00;ooooo00Koi>CTojRXZ?olo?coooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o
/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?o
d=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?o
n?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?o
V9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko
^;RholO7aooooooon?ShojVYZOoShn<jooooo`00@Oooool01Oobk_;ooooooooog?mL047ob?;o00;o
oooo00Koi>CTom_KfoooooooooooolW9bOng]kL9ooooo`03ooWinOn7QhOooooo00Wooooo00?o/K6a
olo?coooool02?ooool00ooYjNWoUiNGooooo`09ooooo`03oj6QXOoOgmoooooo00Sooooo00?odM7A
ojn_[oooool02Oooool00on9RHWomoOgooooo`08ooooo`03ojVYZOnWYjOooooo00Sooooo00?onOWi
ohN7Qoooool02Oooool00onYZJWoemOGooooo`08ooooo`03on7QhOnOWioooooo00Wooooo00?oVIVI
onOWioooool02?ooool00ooAdM7o[jn_ooooo`09ooooo`03oh61POoooooooooo00Sooooo00Ko^KVi
olO7aoooooooooooomcLg?oShn<jooooo`00@?ooool01_ooooOoWd40obj2ZonmZh;o001VomOko`;o
oooo00Koi>CTom_KfoooooooooooolS8b?mlO7`5ojRXZ008ojVYZOnXZ:SoZ:RXojRXZ?nSXj?oF5QH
ojRXZ?nYZJT6ojRXZ004ojVYZOnXZ:SoLg=cohR8R0;oZ:RX00?oZJVYojRXZ?nXZ:P01?nXZ:P00onH
V9SoHf=SojRXZ009ojRXZ003ofUYJOnBTY;oZ:RX00GoZ:RX00GoZJVYojRXZ?nXZ:SoRHV9og=cL`0:
ojRXZ003oeUIFOnRXZ;oZ:RX00SoZ:RX0_m^KVh9ojRXZ003oj>SXomHF5SoZ:RX00OoZ:RX00CoZJVY
ojRXZ?m^KVkoSHf=0_nXZ:P00onYZJWoZ:RXojRXZ004ojRXZ003oi>CTomXJ6SoZ:RX00WoZ:RX00?o
I6AToiRHV?nXZ:P02?nXZ:P00on9RHWoLg=cojRXZ007ojRXZ003ojVYZOnXZ:SoE5AD00CoZ:RX00?o
ZJVYojRXZ?nXZ:P00onXZ:P01_mlO7coalO7oooooooooooog=cLon?Shc[ooooo0011ooooo`04ooog
j_o2ZiSoRHVOom;Zm`?ooooo00Koi>CTom_KfoooooooooooolS8b?nLW9`9omOGe`03om7AdOmaLG7o
emOG00WoemOG00?oU9BDojj^[_oGemL02?oGemL00oo4a<CoOgmoomOGe`09omOGe`03ohJ6Q_nl_;co
emOG00SoemOG00Go[jn_oi>CTooGemOoemOGomSHf005omOGe`04omSHf?oGemOoLW9bom3@d0?oemOG
00?of=SHomOGeooGemL00ooGemL00on>SXkoS8b<omOGe`04omOGe`08omSHf?oGemOoemOGomOGeooA
dM7oLG5aomOGeooHf=P8omOGe`03ohf=SOne]KGoemOG00SoemOG00?o_KfmohJ6Q_oGemL02OoGemL0
0on0P83o`l?3omOGe`05omOGe`05omSHf?oGemOoemOGojn_[onCTi<00_oGemL00ooHf=SoemOGomOG
e`05omOGe`03of][JooGemOoemOG00SoemOG00KoWIfMolO7aoooooooooooomcLg?oShn<jooooo`00
B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`
/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@
d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00ooh
n?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onH
V9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh
^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg
2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool0
2Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool0
2?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool0
2?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool0
2Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004So
oooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`
olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@
ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?Sh
ohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RH
onOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;Rh
olO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wo
oooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wo
oooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00So
oooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00So
oooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wo
oooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018oooo
o`06onCTi?o9bLWoooooooooooo8b<So^;Rh2Oooool00oohn?SoR8R8ooooo`09ooooo`03ok6a/Oo?
cloooooo00Sooooo00?oj>SXoiRHV?ooool02Oooool00onQXJ7ogmoOooooo`08ooooo`03om7AdOn_
[joooooo00Wooooo00?oR8R8ooShn?ooool02?ooool00onYZJWoYjNWooooo`08ooooo`03ooShn?n8
R8Sooooo00Wooooo00?oZ:RXomSHf?ooool02?ooool00ooQhN7oWinOooooo`09ooooo`03oiRHV?oX
j>Sooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on1PH7oooooooooo`08ooooo`06okRh^?o8
b<Soooooooooooo:b/[ohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9oooo
o`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09oooo
o`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08oooo
o`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08oooo
o`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09oooo
o`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool0
1_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?
ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_
ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7
ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOW
ooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7
oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool0
0oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool0
0onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool0
0onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool0
0ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool0
0on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Ko
i>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?cooo
ool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[ooo
ool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qooo
ool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWiooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooo
ooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8oj:RXPGoh>3P00So
hN7Qon3Ph?oPh>3oh>3PomWIfOmfMWKoh>3Pon7Qh@Koh>3P00CohN7Qon3Ph?nJVY[o]KFe0_oPh>00
0ooQhN7oh>3Pon3Ph004on3Ph003olc<c?n4Q8Coh>3P00Woh>3P00?oS8b<olC4a?oPh>001OoPh>00
1OoQhN7oh>3Pon3Ph?nf][KoVIVI00;oh>3P00?ohN7Qon3Ph?oPh>000ooPh>001?oQhN7oh>3PogMg
MooHf=P3on3Ph003on7QhOoPh>3oh>3P00?oh>3P00?oU9BDoi:BT_oPh>001?oPh>002?oQhN7oh>3P
on3Ph?oPh>3ofMWIogIfM_oPh>3ohN7Q1_oPh>001?oQhN7oh>3Poi>CTonl_;`2on3Ph003on7QhOoP
h>3oh>3P00Coh>3P00?oaLG5oh^;RooPh>002OoPh>000on5QHGobl_;on3Ph005on3Ph005on7QhOoP
h>3oh>3PokJf]_nIVIT00_oPh>000ooQhN7oh>3Pon3Ph003on3Ph003on7QhOoPh>3oL71`00Coh>3P
00?ohN7Qon3Ph?oPh>000ooPh>001_nSXj?oalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06
onCTi?oKfm_oooooooooooo8b<SoMWIf2OnOWil00onJVY[oE5ADoinOW`09oinOW`03ofe]KOn1PH7o
WinO00SoWinO00?oT92@oeiNG_nOWil02OnOWil00omSHf?oRh^;oinOW`08oinOW`03oh61POm]KFgo
WinO00WoWinO00?oE5ADoiZJV_nOWil02?nOWil2ofQXJ0WoWinO00?oVYZJoeADE?nOWil02OnOWil0
0omXJ6SoQXJ6oinOW`08oinOW`03oh^;RomSHf?oWinO00WoWinO00?oGUiNoi2@T?nOWil02?nOWil0
0on1PH7oKFe]oinOW`09oinOW`03odm?ConOWiooWinO00SoWinO00KoMgMgolO7aoooooooooooomcL
g?oShn<jooooo`00B?ooool01_oTi>Cofm_KoooooooooooobLW9okNg]`Wooooo00?onOWiohN7Qooo
ool02Oooool00ona/K7oclo?ooooo`08ooooo`03onWYjOnGUiOooooo00Wooooo00?oXJ6QomoOgooo
ool02?ooool00ooAdM7o[jn_ooooo`09ooooo`03ohV9ROogmoOooooo00Sooooo00?oZJVYojNWYooo
ool02?ooool00ooinOWoQhN7ooooo`09ooooo`03ojVYZOoGemOooooo00Sooooo00?ohN7QoinOWooo
ool02Oooool00onIVIWoinOWooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?oPH61oooooooo
ool02?ooool01_ni^KWoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?o9bLWooooo
ooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?o
j>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?o
R8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?o
Z:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?o
d=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOoooooooooooo:b/[o
hn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo
00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo
00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo
00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo
00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo
00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooo
oooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSX
j?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8
R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRX
Z?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@
d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?S
hc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09
ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08
ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08
ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09
ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08
ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_Kfooooooooooo
olS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>So
UiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8So
moOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:So
emOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o
[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<j
ooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Ooo
ool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?oo
ool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?oo
ool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Ooo
ool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?oo
ool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo9
bLWo]kNg2Oooool00ooinOWoQhN7ooooo`09ooooo`03ok6a/Oo?cloooooo00Sooooo00?ojNWYoiNG
Uoooool02Oooool00onQXJ7ogmoOooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?oRHV9ooOg
moooool02?ooool00onYZJWoYjNWooooo`08ooooo`03ooWinOn7QhOooooo00Wooooo00?oZJVYomOG
eoooool02?ooool00ooQhN7oWinOooooo`09ooooo`03oiVIVOoWinOooooo00Sooooo00?odM7Aojn_
[oooool02Oooool00on1PH7oooooooooo`08ooooo`06okVi^Oo7alOooooooooooooLg=cohn?S>_oo
ool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo
00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo
00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo
00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo
00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo
00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>CobLW9oooooooooooob<S8
okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOo
oooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOo
oooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOo
oooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joo
oooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooob/[:on?Shc[ooooo
0018ooooo`06onCTi?oKfm_oooooooooooo8b<SoLG5a1OnHV9P02?nIVIWoV9RHoiRHV?nHV9SoTi>C
oe1@D?nHV9SoVIVI1_nHV9P01?nIVIWoV9RHofQXJ?mkNg/2oiRHV003oiVIVOnHV9SoV9RH00CoV9RH
00?oRXZ:oeYJF_nHV9P02OnHV9P00omOGeooQ8B4oiRHV005oiRHV005oiVIVOnHV9SoV9RHog]kNomX
J6P02_nHV9P00omADE7oTi>CoiRHV008oiRHV003ofATI?mSHf?oV9RH00SoV9RH00?oTi>Coe1@D?nH
V9P01onHV9P01?nIVIWoV9RHofATI?n0P802oiRHV003oiVIVOnHV9SoV9RH00CoV9RH00?oQHF5oeiN
G_nHV9P02OnHV9P00omJFU[oRHV9oiRHV008oiRHV003og]kNomXJ6SoV9RH00OoV9RH00?oVIVIoiRH
V?m<C4`01?nHV9P00onIVIWoV9RHoiRHV003oiRHV006og9bL_o7alOooooooooooooLg=cohn?S>_oo
ool004Sooooo00Koi>CTom_KfoooooooooooolS8b?nWYjL9onOWi`03on3Ph?mjNW[oinOW00WoinOW
00?oWinOok^k^ooWinL02?oWinL00ooCdm?oR8R8onOWi`09onOWi`03oi2@T?o:b/[oinOW00SoinOW
00Go_;bloijNW_oWinOoinOWonSXj005onOWi`04onSXj?oWinOoNg]komoOg`?oinOW00?oj>SXonOW
iooWinL00ooWinL00onHV9SoUiNGonOWi`04onOWi`08onSXj?oWinOoinOWonOWiooPh>3oNWYjonOW
iooXj>P8onOWi`03oiRHV?o2`/;oinOW00SoinOW00?obl_;oi2@T?oWinL02OoWinL00on9RHWod];B
onOWi`05onOWi`05onSXj?oWinOoinOWokbl_?nNWYh00_oWinL00ooXj>SoinOWonOWi`05onOWi`03
og=cLooWinOoinOW00SoinOW00KoZ:RXolO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oT
i>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?oooo
o`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_oooo
o`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7oooo
o`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWoooo
o`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooo
oooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo9bLWo]kNg2Oooool00ooi
nOWoQhN7ooooo`09ooooo`03ok6a/Oo?cloooooo00Sooooo00?ojNWYoiNGUoooool02Oooool00onQ
XJ7ogmoOooooo`08ooooo`03om7AdOn_[joooooo00Wooooo00?oRHV9ooOgmoooool02?ooool00onY
ZJWoYjNWooooo`08ooooo`03ooWinOn7QhOooooo00Wooooo00?oZJVYomOGeoooool02?ooool00ooQ
hN7oWinOooooo`09ooooo`03oiVIVOoWinOooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on1
PH7oooooooooo`08ooooo`06okVi^Oo7alOooooooooooooLg=cohn?S>_ooool004;ooooo00Conmb[
od400?l0073od_Oo0_ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qooo
ool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYooo
ool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWooo
ool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820oooooooo
ool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0010ooooo`06oooonooG`[Oo/KNg
ojF9G?mLP[7oj__o0_ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qooo
ool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYooo
ool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWooo
ool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820oooooooo
ool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0010ooooo`06ooool_n9003o@H:H
oi5`G?l^Cg3o_N3g0_ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qooo
ool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYooo
ool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWooo
ool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820oooooooo
ool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0011ooooo`04on2aL?mLWmconmNO
oi78lP?ooooo00Koi>CTojRXZ?olo?coooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo
00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo
00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo
00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo
00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo
00Ko^;RholO7aooooooon?ShojVYZOoShn<jooooo`00@Oooool01?ooonkoRD5LoiRUROnHb>h3oooo
o`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?
cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_
[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7
QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oW
inOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7
alOooooooooooooLg=cohn?S>_ooool004;ooooo00?onmb[o`000?n9b>h00oooool01_oTi>Cofm_K
oooooooooooob<S8okNg]`Wooooo00?on?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08oooo
o`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09oooo
o`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09oooo
o`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08oooo
o`03om3@d?n_[joooooo00Wooooo00?oP820ooooooooool02?ooool01_nh^;SoalO7oooooooooooo
g=cLon?Shc[ooooo0013ooooo`03om:aYOo8iOOooooo00;ooooo00Koi>CTom_KfoooooooooooolS8
b?nh^;P9ooooo`03ooShn?n8R8Sooooo00Wooooo00?o/K6aolo?coooool02?ooool00ooXj>SoV9RH
ooooo`09ooooo`03oj6QXOoOgmoooooo00Sooooo00?odM7Aojn_[oooool02Oooool00on8R8Son?Sh
ooooo`08ooooo`03ojVYZOnWYjOooooo00Sooooo00?on?ShohR8R?ooool02Oooool00onXZ:Sof=SH
ooooo`08ooooo`03on7QhOnOWioooooo00Wooooo00?oV9RHonSXj?ooool02?ooool00ooAdM7o[jn_
ooooo`09ooooo`03oh61POoooooooooo00Sooooo00Ko^;RholS8b?ooooooooooomcLg?oShn<joooo
o`00B?ooool01_oTi>Cofm_Koooooooooooob<S8oi6AT@Gob<S800SobLW9olS8b?o8b<Sob<S8ol;2
`_mYJFWob<S8olW9b@Kob<S800CobLW9olS8b?n:RX[oXZ:R0_o8b<P00oo9bLWob<S8olS8b004olS8
b003okFe]OmfMWKob<S800Wob<S800?oOGemojj^[_o8b<P01Oo8b<P01Oo9bLWob<S8olS8b?nSXj?o
RHV900[ob<S800?oJVYZol71`Oo8b<P02?o8b<P00on3Ph?oPX:2olS8b008olS8b003ol;2`_mYJFWo
b<S800Oob<S800CobLW9olS8b?n3Ph?oZ:RX0_o8b<P00oo9bLWob<S8olS8b004olS8b003ojn_[oml
O7cob<S800Wob<S800?oMgMgokFe]Oo8b<P02?o8b<P00onSXj?oRHV9olS8b007olS8b003olW9bOo8
b<SoI6AT00Cob<S800?obLW9olS8b?o8b<P00oo8b<P01_nBTY;oalO7oooooooooooog=cLon?Shc[o
oooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<SoQXJ62Ong]kL00ona/K7oH61PokNg]`09okNg
]`03oginO_nDU9Co]kNg00So]kNg00?oYjNWofa/K?ng]kL02Ong]kL00ombLW;oX:2PokNg]`08okNg
]`05oiFEUOmmOGgo]kNgokNg]onh^;P01Ong]kL01?nh^;So]kNgof5QHOna/K43okNg]`03okRh^?ng
]kOo]kNg00?o]kNg00?oNGUiogMgMong]kL01?ng]kL02?nh^;So]kNgokNg]ong]kOo/K6aof1PH?ng
]kOo^;Rh2?ng]kL00omhN7SoVYZJokNg]`08okNg]`03oj6QXOmbLW;o]kNg00Wo]kNg00?oKFe]ojJV
Y_ng]kL01Ong]kL01Onh^;So]kNgokNg]onEUIGoOGem00;o]kNg00?o^;RhokNg]ong]kL01Ong]kL0
0omKFe_o]kNgokNg]`08okNg]`06ohN7Qoo7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Ko
i>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?cooo
ool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[ooo
ool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qooo
ool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWiooo
ool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooo
ooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?o
n?ShohN7Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?o
X:2PomoOgoooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?o
Z:RXojNWYoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?o
h>3PoinOWoooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?o
P820ooooooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCT
i?o9bLWoooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo
00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo
00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo
00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo
00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooo
ooooooo:b/[ohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooSh
n?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2P
X?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRX
Z?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3P
h?nOWioooooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20
P?oooooooooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>Co
fm_Koooooooooooob<S8okRh^0Wooooo00?on?ShohR8R?ooool02Oooool00ona/K7oclo?ooooo`08
ooooo`03onSXj?nHV9Sooooo00Wooooo00?oXJ6QomoOgoooool02?ooool00ooAdM7o[jn_ooooo`09
ooooo`03ohR8R?ohn?Sooooo00Sooooo00?oZJVYojNWYoooool02?ooool00oohn?SoR8R8ooooo`09
ooooo`03ojRXZ?oHf=Sooooo00Sooooo00?ohN7QoinOWoooool02Oooool00onHV9Soj>SXooooo`08
ooooo`03om7AdOn_[joooooo00Wooooo00?oPH61ooooooooool02?ooool01_nh^;Sob<S8oooooooo
oooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_oooooooooooo8b<So]kNg2Oooool00oohn?So
QhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo00?oj>SXoiNGUoooool02Oooool00onPX:3o
gmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oR8R8ooOgmoooool02?ooool00onXZ:So
YjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo00?oZ:RXomOGeoooool02?ooool00ooPh>3o
WinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo00?od=3@ojn_[oooool02Oooool00on0P83o
ooooooooo`08ooooo`06okRh^?o7alOooooooooooooLg=cohn?S>_ooool004Sooooo00Koi>CTom_K
foooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOooooo00Wooooo00?o/;2`olo?coooool02?oo
ool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoooooo00Sooooo00?od=3@ojn_[oooool02Ooo
ool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOooooo00Sooooo00?on?ShohN7Qoooool02Ooo
ool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioooooo00Wooooo00?oV9RHonOWioooool02?oo
ool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooooooo00Sooooo00Ko^;RholO7aooooooooooo
omcLg?oShn<jooooo`00B?ooool01_oTi>Cofm_Koooooooooooob<S8okNg]`Wooooo00?on?ShohN7
Qoooool02Oooool00on`/;3oclo?ooooo`08ooooo`03onSXj?nGUiOooooo00Wooooo00?oX:2PomoO
goooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03ohR8R?ogmoOooooo00Sooooo00?oZ:RXojNW
Yoooool02?ooool00oohn?SoQhN7ooooo`09ooooo`03ojRXZ?oGemOooooo00Sooooo00?oh>3PoinO
Woooool02Oooool00onHV9SoinOWooooo`08ooooo`03om3@d?n_[joooooo00Wooooo00?oP820oooo
ooooool02?ooool01_nh^;SoalO7oooooooooooog=cLon?Shc[ooooo0018ooooo`06onCTi?oKfm_o
ooooooooooo8b<So]kNg2Oooool00oohn?SoQhN7ooooo`09ooooo`03ok2`/?o?cloooooo00Sooooo
00?oj>SXoiNGUoooool02Oooool00onPX:3ogmoOooooo`08ooooo`03om3@d?n_[joooooo00Wooooo
00?oR8R8ooOgmoooool02?ooool00onXZ:SoYjNWooooo`08ooooo`03ooShn?n7QhOooooo00Wooooo
00?oZ:RXomOGeoooool02?ooool00ooPh>3oWinOooooo`09ooooo`03oiRHV?oWinOooooo00Sooooo
00?od=3@ojn_[oooool02Oooool00on0P83oooooooooo`08ooooo`06okRh^?o7alOooooooooooooL
g=cohn?S>_ooool004Sooooo00Koi>CTom_KfoooooooooooolS8b?ng]kL9ooooo`03ooShn?n7QhOo
oooo00Wooooo00?o/;2`olo?coooool02?ooool00ooXj>SoUiNGooooo`09ooooo`03oj2PX?oOgmoo
oooo00Sooooo00?od=3@ojn_[oooool02Oooool00on8R8SomoOgooooo`08ooooo`03ojRXZ?nWYjOo
oooo00Sooooo00?on?ShohN7Qoooool02Oooool00onXZ:SoemOGooooo`08ooooo`03on3Ph?nOWioo
oooo00Wooooo00?oV9RHonOWioooool02?ooool00oo@d=3o[jn_ooooo`09ooooo`03oh20P?oooooo
oooo00Sooooo00Ko^;RholO7aoooooooooooomcLg?oShn<jooooo`00B?ooool01_oTi>CobLW9oooo
ooooooooi>CTogAdM0GoP82000SoPH61oh20P?n0P83oP820oginO_mQHF7oP820oh61P@KoP82000Co
PH61oh20P?m/K6coLg=c0_n0P8000on1PH7oP820oh20P004oh20P003og]kNomUIFGoP82000WoP820
00?oJ6QXogQhN?n0P8001On0P8001On1PH7oP820oh20P?mdM7CoJf][00;oP82000?oPH61oh20P?n0
P8000on0P8001?n1PH7oP820of9RH_mmOGd3oh20P003oh61POn0P83oP82000?oP82000?oHf=Sof5Q
HOn0P8001?n0P8002?n1PH7oP820oh20P?n0P83oOWinof5QHOn0P83oPH611_n0P8001?n1PH7oP820
ofYZJ_meMGD2oh20P003oh61POn0P83oP82000CoP82000?oNGUiofMWIon0P8002On0P8000omVIVKo
NWYjoh20P005oh20P005oh61POn0P83oP820ogAdM?m[Jf/00_n0P8000on1PH7oP820oh20P003oh20
P003oh61POn0P83oH61P00CoP82000?oPH61oh20P?n0P8000on0P8001_meMGGohn?Soooooooooooo
b/[:on?Shc[ooooo0018ooooo`03onCTi?oKfm_ooooo057ooooo00?oh>3PomoOgoooool0DOooool0
0ooLg=cohn?Sooooo`0iooooo`00B?ooool00ooTi>Cofm_Kooooo`1Aooooo`03on3Ph?oOgmoooooo
057ooooo00?og=cLon?Shoooool0>Oooool004Sooooo00Koi>CTom_Kfoooooooooooookno_omoOd6
ooooo`03ookno_omoOgooooo00Gooooo00?ok^k^ong]kOooool01Oooool00oono_kooOgmooooo`05
ooooo`03ookno_omoOgooooo00Gooooo00?oo_knoogmoOooool01Oooool00oo^k^kokNg]ooooo`05
ooooo`03ookno_omoOgooooo00Gooooo00?oo_knoogmoOooool01Oooool00oono_kooOgmooooo`05
ooooo`03om7AdOo?cloooooo00Gooooo00?oo_knoogmoOooool01Oooool00oono_kooOgmooooo`05
ooooo`03ookno_omoOgooooo00Gooooo00?ojn_[oo3`l?ooool01Oooool00oomoOgoo_knooooo`05
ooooo`03oogmoOono_kooooo00Gooooo00?ooOgmookno_ooool01Oooool00oo[jn_ol?3`ooooo`05
ooooo`03oogmoOono_kooooo00Gooooo00KooOgmookno_ooooooooooomcLg?oShn<jooooo`00B?oo
ool01_obl_;o][Jfol30`?o0`<3o^k^kokVi^@Ko`<3000?o^[ZjokVi^Oo0`<001Oo0`<000ond];Co
/k>col30`005ol30`003okZj^_ni^KWo`<3000Go`<3000?o^[ZjokVi^Oo0`<001Oo0`<000onj^[[o
^KViol30`005ol30`003okBd]?nc/k?o`<3000Go`<3000?o^[ZjokVi^Oo0`<001Oo0`<000onj^[[o
^KViol30`005ol30`003okZj^_ni^KWo`<3000Go`<3000?oZJVYojNWYoo0`<001Oo0`<000onj^[[o
^KViol30`005ol30`003okZj^_ni^KWo`<3000Go`<3000?o^[ZjokVi^Oo0`<001Oo0`<000onc/k?o
]KFeol30`005ol30`003okVi^Onj^[[o`<3000Go`<3000?o^KViokZj^_o0`<001Oo0`<000oni^KWo
^[Zjol30`005ol30`003ok>c/one]KGo`<3000Go`<3000?o^KViokZj^_o0`<001Oo0`<001_ni^KWo
^[Zjol30`?o0`<3o][Jfoo7alC[ooooo0000\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-9.78628, -5.94414, 0.0625374, \
0.0625374}},
 CellTags->"S5.29.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.29.1"]
}, Open  ]],

Cell["This is the polar coordinate system. ", "MathCaption",
 CellTags->{"S5.29.1", "1.7"}],

Cell[CellGroupData[{

Cell["PolarMap[Identity, { 0, 1}, { 0, 2 Pi}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.29.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47387 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.241769 0.47619 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.2619 -0.0125 -12 -9 ]
[.2619 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7381 -0.0125 -9 -9 ]
[.7381 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .05129 -24 -4.5 ]
[-0.0125 .05129 0 4.5 ]
[-0.0125 .14653 -24 -4.5 ]
[-0.0125 .14653 0 4.5 ]
[-0.0125 .24177 -6 -4.5 ]
[-0.0125 .24177 0 4.5 ]
[-0.0125 .33701 -18 -4.5 ]
[-0.0125 .33701 0 4.5 ]
[-0.0125 .43225 -18 -4.5 ]
[-0.0125 .43225 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .47387 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .47387 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-1)] .02381 -0.0125 0 1 Mshowa
.2619 0 m
.2619 .00625 L
s
[(-0.5)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(0.5)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .05129 m
.00625 .05129 L
s
[(-0.4)] -0.0125 .05129 1 0 Mshowa
0 .14653 m
.00625 .14653 L
s
[(-0.2)] -0.0125 .14653 1 0 Mshowa
0 .24177 m
.00625 .24177 L
s
[(0)] -0.0125 .24177 1 0 Mshowa
0 .33701 m
.00625 .33701 L
s
[(0.2)] -0.0125 .33701 1 0 Mshowa
0 .43225 m
.00625 .43225 L
s
[(0.4)] -0.0125 .43225 1 0 Mshowa
.125 Mabswid
0 .0751 m
.00375 .0751 L
s
0 .09891 m
.00375 .09891 L
s
0 .12272 m
.00375 .12272 L
s
0 .17034 m
.00375 .17034 L
s
0 .19415 m
.00375 .19415 L
s
0 .21796 m
.00375 .21796 L
s
0 .26558 m
.00375 .26558 L
s
0 .28939 m
.00375 .28939 L
s
0 .3132 m
.00375 .3132 L
s
0 .36082 m
.00375 .36082 L
s
0 .38463 m
.00375 .38463 L
s
0 .40844 m
.00375 .40844 L
s
0 .02748 m
.00375 .02748 L
s
0 .00367 m
.00375 .00367 L
s
0 .45605 m
.00375 .45605 L
s
.25 Mabswid
0 0 m
0 .47387 L
s
.02381 .46762 m
.02381 .47387 L
s
.2619 .46762 m
.2619 .47387 L
s
.5 .46762 m
.5 .47387 L
s
.7381 .46762 m
.7381 .47387 L
s
.97619 .46762 m
.97619 .47387 L
s
.125 Mabswid
.07143 .47012 m
.07143 .47387 L
s
.11905 .47012 m
.11905 .47387 L
s
.16667 .47012 m
.16667 .47387 L
s
.21429 .47012 m
.21429 .47387 L
s
.30952 .47012 m
.30952 .47387 L
s
.35714 .47012 m
.35714 .47387 L
s
.40476 .47012 m
.40476 .47387 L
s
.45238 .47012 m
.45238 .47387 L
s
.54762 .47012 m
.54762 .47387 L
s
.59524 .47012 m
.59524 .47387 L
s
.64286 .47012 m
.64286 .47387 L
s
.69048 .47012 m
.69048 .47387 L
s
.78571 .47012 m
.78571 .47387 L
s
.83333 .47012 m
.83333 .47387 L
s
.88095 .47012 m
.88095 .47387 L
s
.92857 .47012 m
.92857 .47387 L
s
.25 Mabswid
0 .47387 m
1 .47387 L
s
.99375 .05129 m
1 .05129 L
s
.99375 .14653 m
1 .14653 L
s
.99375 .24177 m
1 .24177 L
s
.99375 .33701 m
1 .33701 L
s
.99375 .43225 m
1 .43225 L
s
.125 Mabswid
.99625 .0751 m
1 .0751 L
s
.99625 .09891 m
1 .09891 L
s
.99625 .12272 m
1 .12272 L
s
.99625 .17034 m
1 .17034 L
s
.99625 .19415 m
1 .19415 L
s
.99625 .21796 m
1 .21796 L
s
.99625 .26558 m
1 .26558 L
s
.99625 .28939 m
1 .28939 L
s
.99625 .3132 m
1 .3132 L
s
.99625 .36082 m
1 .36082 L
s
.99625 .38463 m
1 .38463 L
s
.99625 .40844 m
1 .40844 L
s
.99625 .02748 m
1 .02748 L
s
.99625 .00367 m
1 .00367 L
s
.99625 .45605 m
1 .45605 L
s
.25 Mabswid
1 0 m
1 .47387 L
s
0 .24177 m
1 .24177 L
s
.5 0 m
.5 .47387 L
s
0 0 m
1 0 L
1 .47387 L
0 .47387 L
closepath
clip
newpath
.5 Mabswid
.5 .24177 m
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
.5 .24177 L
Mistroke
.5 .24177 L
Mfstroke
.53401 .24177 m
.53401 .24203 L
.53401 .24227 L
.534 .24255 L
.534 .24281 L
.53398 .24328 L
.53395 .24378 L
.53392 .24434 L
.53387 .24493 L
.53375 .24598 L
.5336 .24706 L
.53342 .24807 L
.53291 .25035 L
.53223 .25262 L
.53147 .25466 L
.5293 .25905 L
.52691 .26257 L
.52382 .26605 L
.52048 .26893 L
.51654 .27149 L
.51449 .27254 L
.51219 .27352 L
.51015 .27423 L
.50787 .27486 L
.50678 .2751 L
.5056 .27532 L
.50458 .27547 L
.50346 .27561 L
.5028 .27567 L
.5022 .27571 L
.50161 .27574 L
.50132 .27576 L
.50099 .27577 L
.5007 .27578 L
.50043 .27578 L
.50014 .27578 L
.49999 .27578 L
.49983 .27578 L
.49956 .27578 L
.49927 .27577 L
.49899 .27577 L
.49874 .27576 L
.49822 .27574 L
.49765 .2757 L
.49651 .2756 L
.49545 .27548 L
.49446 .27533 L
.49225 .27489 L
.48992 .27426 L
.48777 .27351 L
Mistroke
.4855 .27254 L
.48156 .27035 L
.47801 .26771 L
.47464 .26443 L
.47169 .26063 L
.46944 .2567 L
.46854 .2547 L
.46773 .25253 L
.46711 .25045 L
.46666 .24852 L
.46631 .24642 L
.46617 .24525 L
.46611 .24472 L
.46607 .24415 L
.46604 .24366 L
.46603 .2434 L
.46601 .24312 L
.466 .24287 L
.466 .24263 L
.46599 .24241 L
.46599 .24218 L
.46599 .24192 L
.46599 .24165 L
.46599 .24139 L
.46599 .24115 L
.466 .24088 L
.46601 .24058 L
.46603 .24003 L
.46606 .2395 L
.4661 .23894 L
.46621 .23791 L
.46637 .2367 L
.46655 .2356 L
.46708 .23323 L
.46773 .23103 L
.46941 .2269 L
.47144 .2233 L
.47392 .21994 L
.47712 .2166 L
.4805 .2139 L
.48451 .21149 L
.48863 .20971 L
.49078 .20903 L
.49201 .20871 L
.49318 .20845 L
.49427 .20824 L
.49545 .20806 L
.49654 .20793 L
.49754 .20784 L
.4981 .20781 L
Mistroke
.49862 .20778 L
.49892 .20777 L
.4992 .20776 L
.49935 .20776 L
.49951 .20776 L
.49967 .20776 L
.49982 .20776 L
.49997 .20776 L
.50013 .20776 L
.50029 .20776 L
.50043 .20776 L
.5007 .20776 L
.50099 .20777 L
.50129 .20778 L
.50158 .20779 L
.50223 .20783 L
.50281 .20787 L
.50335 .20792 L
.50457 .20806 L
.50563 .20823 L
.50676 .20843 L
.50869 .20888 L
.51078 .20951 L
.5148 .21114 L
.51886 .21346 L
.52243 .2162 L
.52576 .21956 L
.52843 .2231 L
.53048 .22667 L
.53145 .22883 L
.53224 .23091 L
.53282 .23285 L
.53332 .23494 L
.53362 .23662 L
.53375 .23758 L
.53385 .23848 L
.53392 .2393 L
.53397 .24006 L
.53399 .24048 L
.534 .2407 L
.534 .24094 L
.53401 .24116 L
.53401 .24137 L
.53401 .24158 L
.53401 .24177 L
Mfstroke
.56803 .24177 m
.56803 .2423 L
.56802 .24278 L
.56801 .24333 L
.568 .24385 L
.56796 .24479 L
.56791 .2458 L
.56783 .24691 L
.56773 .24808 L
.5675 .25019 L
.5672 .25235 L
.56685 .25437 L
.56583 .25892 L
.56447 .26348 L
.56295 .26756 L
.5586 .27633 L
.55382 .28338 L
.54765 .29032 L
.54096 .29608 L
.53308 .30121 L
.52897 .30332 L
.52438 .30528 L
.52031 .3067 L
.51574 .30795 L
.51356 .30843 L
.5112 .30887 L
.50916 .30918 L
.50692 .30944 L
.50561 .30956 L
.50439 .30965 L
.50323 .30972 L
.50264 .30975 L
.50199 .30977 L
.50141 .30978 L
.50087 .30979 L
.50028 .3098 L
.49999 .3098 L
.49966 .3098 L
.49912 .30979 L
.49853 .30978 L
.49798 .30977 L
.49748 .30975 L
.49645 .3097 L
.49531 .30963 L
.49301 .30944 L
.49089 .30918 L
.48892 .30889 L
.48451 .30801 L
.47984 .30674 L
.47555 .30525 L
Mistroke
.47099 .3033 L
.46311 .29893 L
.45601 .29366 L
.44927 .28709 L
.44338 .27948 L
.43888 .27163 L
.43708 .26763 L
.43546 .26328 L
.43422 .25912 L
.43333 .25527 L
.43261 .25107 L
.43233 .24874 L
.43223 .24767 L
.43214 .24653 L
.43208 .24555 L
.43205 .24504 L
.43203 .24448 L
.43201 .24397 L
.43199 .2435 L
.43198 .24305 L
.43198 .24258 L
.43197 .24207 L
.43197 .24152 L
.43198 .241 L
.43198 .24054 L
.432 .23998 L
.43201 .23938 L
.43206 .2383 L
.43212 .23724 L
.43221 .2361 L
.43241 .23405 L
.43273 .23163 L
.4331 .22943 L
.43415 .22469 L
.43545 .22028 L
.43882 .21202 L
.44288 .20483 L
.44784 .1981 L
.45423 .19144 L
.461 .18603 L
.46901 .18121 L
.47726 .17766 L
.48156 .17629 L
.48402 .17564 L
.48637 .17512 L
.48854 .17471 L
.49091 .17435 L
.49307 .1741 L
.49507 .17392 L
.49619 .17385 L
Mistroke
.49724 .1738 L
.49784 .17378 L
.49839 .17376 L
.4987 .17375 L
.49903 .17375 L
.49934 .17374 L
.49963 .17374 L
.49993 .17374 L
.50026 .17374 L
.50057 .17374 L
.50086 .17375 L
.5014 .17376 L
.50197 .17377 L
.50259 .17379 L
.50316 .17382 L
.50446 .17389 L
.50563 .17398 L
.5067 .17407 L
.50913 .17436 L
.51127 .17468 L
.51352 .1751 L
.51737 .176 L
.52156 .17725 L
.5296 .18052 L
.53773 .18516 L
.54486 .19063 L
.55153 .19735 L
.55686 .20443 L
.56096 .21158 L
.56291 .21588 L
.56447 .22006 L
.56565 .22394 L
.56664 .22811 L
.56724 .23147 L
.56751 .23338 L
.56771 .23518 L
.56785 .23684 L
.56794 .23836 L
.56798 .23919 L
.56799 .23964 L
.56801 .24011 L
.56802 .24056 L
.56802 .24097 L
.56803 .24138 L
.56803 .24177 L
Mfstroke
.60204 .24177 m
.60204 .24256 L
.60203 .24328 L
.60201 .24411 L
.60199 .2449 L
.60194 .24629 L
.60186 .24781 L
.60175 .24947 L
.6016 .25124 L
.60126 .2544 L
.6008 .25765 L
.60027 .26067 L
.59874 .2675 L
.5967 .27433 L
.59442 .28045 L
.58789 .29361 L
.58073 .30418 L
.57147 .3146 L
.56144 .32324 L
.54962 .33093 L
.54346 .33409 L
.53657 .33703 L
.53046 .33916 L
.52361 .34104 L
.52034 .34176 L
.5168 .34242 L
.51374 .34288 L
.51038 .34328 L
.50841 .34346 L
.50659 .3436 L
.50484 .34369 L
.50396 .34373 L
.50298 .34377 L
.50211 .34379 L
.5013 .3438 L
.50042 .34381 L
.49998 .34381 L
.4995 .34381 L
.49867 .3438 L
.4978 .34379 L
.49697 .34376 L
.49622 .34374 L
.49467 .34367 L
.49296 .34357 L
.48952 .34327 L
.48634 .34289 L
.48338 .34245 L
.47676 .34113 L
.46977 .33923 L
.46332 .33699 L
Mistroke
.45649 .33407 L
.44467 .3275 L
.43402 .3196 L
.42391 .30975 L
.41508 .29834 L
.40832 .28657 L
.40562 .28056 L
.4032 .27404 L
.40133 .2678 L
.39999 .26202 L
.39892 .25572 L
.3985 .25222 L
.39834 .25061 L
.39821 .24891 L
.39812 .24744 L
.39808 .24667 L
.39804 .24583 L
.39801 .24507 L
.39799 .24437 L
.39798 .2437 L
.39797 .24299 L
.39796 .24222 L
.39796 .2414 L
.39797 .24062 L
.39798 .23992 L
.39799 .23909 L
.39802 .23819 L
.39809 .23656 L
.39819 .23497 L
.39831 .23327 L
.39862 .2302 L
.3991 .22656 L
.39965 .22326 L
.40123 .21615 L
.40318 .20954 L
.40823 .19715 L
.41431 .18636 L
.42176 .17627 L
.43135 .16627 L
.4415 .15816 L
.45352 .15093 L
.46589 .1456 L
.47235 .14355 L
.47604 .14258 L
.47955 .1418 L
.48281 .14119 L
.48636 .14064 L
.48961 .14026 L
.49261 .14 L
.49429 .13989 L
Mistroke
.49586 .13981 L
.49676 .13978 L
.49759 .13976 L
.49804 .13975 L
.49854 .13974 L
.49901 .13973 L
.49945 .13973 L
.4999 .13973 L
.50039 .13973 L
.50086 .13973 L
.50129 .13974 L
.5021 .13975 L
.50296 .13977 L
.50388 .1398 L
.50474 .13984 L
.50669 .13995 L
.50844 .14008 L
.51006 .14022 L
.5137 .14065 L
.5169 .14114 L
.52027 .14176 L
.52606 .14311 L
.53234 .14499 L
.5444 .1499 L
.55659 .15686 L
.5673 .16506 L
.57729 .17515 L
.58529 .18576 L
.59144 .19648 L
.59436 .20294 L
.59671 .20921 L
.59847 .21502 L
.59996 .22128 L
.60086 .22632 L
.60126 .22919 L
.60156 .23189 L
.60177 .23438 L
.60191 .23665 L
.60197 .23791 L
.60199 .23857 L
.60201 .23928 L
.60202 .23995 L
.60203 .24057 L
.60204 .24119 L
.60204 .24177 L
Mfstroke
.63605 .24177 m
.63605 .24282 L
.63604 .24378 L
.63602 .24489 L
.63599 .24594 L
.63592 .2478 L
.63582 .24982 L
.63567 .25204 L
.63547 .2544 L
.63501 .25861 L
.6344 .26294 L
.6337 .26697 L
.63166 .27607 L
.62894 .28519 L
.6259 .29335 L
.61719 .31089 L
.60764 .32498 L
.59529 .33888 L
.58192 .35039 L
.56616 .36066 L
.55794 .36487 L
.54876 .36879 L
.54061 .37162 L
.53148 .37413 L
.52711 .37509 L
.52241 .37597 L
.51831 .37659 L
.51384 .37712 L
.51122 .37736 L
.50878 .37754 L
.50645 .37767 L
.50528 .37772 L
.50398 .37777 L
.50281 .37779 L
.50174 .37781 L
.50056 .37782 L
.49997 .37782 L
.49933 .37782 L
.49823 .37781 L
.49707 .37779 L
.49596 .37776 L
.49496 .37773 L
.49289 .37764 L
.49062 .3775 L
.48603 .3771 L
.48179 .3766 L
.47784 .37601 L
.46901 .37425 L
.45969 .37171 L
.4511 .36873 L
Mistroke
.44199 .36483 L
.42622 .35608 L
.41202 .34555 L
.39854 .33242 L
.38677 .3172 L
.37776 .3015 L
.37416 .29348 L
.37093 .2848 L
.36845 .27647 L
.36665 .26877 L
.36522 .26037 L
.36466 .25571 L
.36446 .25356 L
.36428 .25128 L
.36416 .24934 L
.3641 .2483 L
.36405 .24719 L
.36402 .24617 L
.36399 .24523 L
.36397 .24434 L
.36396 .2434 L
.36395 .24237 L
.36395 .24127 L
.36395 .24024 L
.36397 .2393 L
.36399 .2382 L
.36403 .237 L
.36412 .23483 L
.36425 .23271 L
.36442 .23043 L
.36482 .22634 L
.36547 .22149 L
.3662 .21709 L
.3683 .20762 L
.37091 .1988 L
.37764 .18228 L
.38575 .16789 L
.39568 .15443 L
.40847 .14111 L
.42201 .13029 L
.43803 .12065 L
.45452 .11354 L
.46313 .11081 L
.46805 .10952 L
.47274 .10847 L
.47708 .10766 L
.48182 .10694 L
.48614 .10642 L
.49014 .10607 L
.49238 .10593 L
Mistroke
.49448 .10583 L
.49568 .10578 L
.49678 .10575 L
.49739 .10574 L
.49805 .10573 L
.49868 .10572 L
.49926 .10572 L
.49987 .10571 L
.50053 .10572 L
.50115 .10572 L
.50172 .10573 L
.5028 .10574 L
.50394 .10577 L
.50517 .10581 L
.50632 .10586 L
.50893 .10601 L
.51126 .10618 L
.51341 .10638 L
.51827 .10695 L
.52253 .10759 L
.52703 .10843 L
.53475 .11023 L
.54312 .11273 L
.5592 .11927 L
.57545 .12855 L
.58973 .1395 L
.60305 .15294 L
.61372 .16709 L
.62192 .18138 L
.62582 .19 L
.62894 .19835 L
.6313 .20611 L
.63328 .21445 L
.63449 .22116 L
.63502 .225 L
.63542 .2286 L
.6357 .23191 L
.63588 .23494 L
.63596 .23662 L
.63599 .2375 L
.63601 .23844 L
.63603 .23935 L
.63605 .24017 L
.63605 .24099 L
.63605 .24177 L
Mfstroke
.67007 .24177 m
.67006 .24309 L
.67005 .24429 L
.67002 .24567 L
.66999 .24698 L
.6699 .24931 L
.66977 .25183 L
.66958 .25461 L
.66933 .25755 L
.66876 .26282 L
.668 .26823 L
.66712 .27327 L
.66457 .28465 L
.66117 .29604 L
.65737 .30624 L
.64649 .32816 L
.63455 .34579 L
.61912 .36316 L
.6024 .37755 L
.5827 .39038 L
.57243 .39564 L
.56095 .40054 L
.55076 .40408 L
.53935 .40722 L
.53389 .40843 L
.52801 .40951 L
.52289 .41029 L
.5173 .41095 L
.51402 .41126 L
.51098 .41148 L
.50807 .41165 L
.5066 .41171 L
.50497 .41176 L
.50351 .4118 L
.50217 .41182 L
.50071 .41184 L
.49997 .41184 L
.49916 .41183 L
.49779 .41182 L
.49633 .4118 L
.49495 .41176 L
.4937 .41172 L
.49111 .4116 L
.48827 .41143 L
.48253 .41094 L
.47723 .41031 L
.4723 .40957 L
.46127 .40737 L
.44961 .4042 L
.43887 .40047 L
Mistroke
.42748 .3956 L
.40778 .38466 L
.39003 .3715 L
.37318 .35508 L
.35846 .33605 L
.3472 .31643 L
.3427 .30641 L
.33866 .29555 L
.33556 .28515 L
.33332 .27553 L
.33153 .26502 L
.33083 .25919 L
.33057 .25651 L
.33035 .25366 L
.3302 .25123 L
.33013 .24994 L
.33007 .24854 L
.33002 .24727 L
.32999 .2461 L
.32996 .24498 L
.32994 .24381 L
.32993 .24252 L
.32993 .24115 L
.32994 .23986 L
.32996 .23868 L
.32999 .2373 L
.33004 .23581 L
.33015 .23309 L
.33031 .23044 L
.33052 .2276 L
.33103 .22248 L
.33183 .21642 L
.33275 .21092 L
.33538 .19908 L
.33864 .18805 L
.34705 .16741 L
.35719 .14942 L
.36959 .1326 L
.38558 .11594 L
.40251 .10242 L
.42253 .09037 L
.44314 .08149 L
.45391 .07807 L
.46006 .07646 L
.46592 .07515 L
.47135 .07413 L
.47727 .07323 L
.48268 .07259 L
.48768 .07215 L
.49048 .07197 L
Mistroke
.4931 .07184 L
.4946 .07179 L
.49598 .07175 L
.49674 .07173 L
.49757 .07172 L
.49835 .07171 L
.49908 .0717 L
.49984 .0717 L
.50066 .0717 L
.50143 .07171 L
.50215 .07171 L
.5035 .07174 L
.50493 .07177 L
.50647 .07182 L
.5079 .07188 L
.51116 .07207 L
.51407 .07228 L
.51676 .07253 L
.52283 .07324 L
.52816 .07405 L
.53379 .07509 L
.54343 .07734 L
.5539 .08047 L
.57401 .08865 L
.59431 .10025 L
.61216 .11393 L
.62882 .13073 L
.64216 .14842 L
.6524 .16629 L
.65727 .17705 L
.66118 .1875 L
.66412 .19719 L
.66661 .20763 L
.66811 .21601 L
.66877 .22081 L
.66927 .22531 L
.66962 .22945 L
.66985 .23324 L
.66995 .23533 L
.66998 .23644 L
.67002 .23761 L
.67004 .23875 L
.67006 .23977 L
.67007 .2408 L
.67007 .24177 L
Mfstroke
.70408 .24177 m
.70408 .24335 L
.70406 .24479 L
.70403 .24645 L
.70399 .24802 L
.70388 .25082 L
.70372 .25385 L
.7035 .25718 L
.7032 .26071 L
.70251 .26703 L
.7016 .27352 L
.70055 .27958 L
.69749 .29323 L
.69341 .3069 L
.68885 .31913 L
.67579 .34544 L
.66146 .36659 L
.64294 .38743 L
.62288 .40471 L
.59924 .4201 L
.58692 .42642 L
.57314 .43229 L
.56092 .43655 L
.54722 .44031 L
.54067 .44176 L
.53361 .44306 L
.52747 .44399 L
.52077 .44479 L
.51683 .44516 L
.51317 .44542 L
.50968 .44562 L
.50792 .4457 L
.50597 .44576 L
.50422 .44581 L
.50261 .44583 L
.50085 .44585 L
.49996 .44585 L
.49899 .44585 L
.49735 .44583 L
.4956 .4458 L
.49394 .44576 L
.49244 .44571 L
.48934 .44557 L
.48592 .44536 L
.47904 .44477 L
.47268 .44401 L
.46676 .44313 L
.45352 .44049 L
.43953 .43669 L
.42665 .43221 L
Mistroke
.41298 .42637 L
.38933 .41324 L
.36803 .39744 L
.34781 .37774 L
.33015 .35491 L
.31664 .33136 L
.31124 .31934 L
.30639 .30631 L
.30267 .29383 L
.29998 .28228 L
.29783 .26966 L
.29699 .26268 L
.29669 .25946 L
.29642 .25604 L
.29623 .25312 L
.29615 .25157 L
.29608 .2499 L
.29603 .24837 L
.29598 .24697 L
.29595 .24562 L
.29593 .24421 L
.29592 .24267 L
.29592 .24103 L
.29593 .23948 L
.29595 .23807 L
.29599 .23641 L
.29604 .23461 L
.29618 .23136 L
.29637 .22818 L
.29663 .22477 L
.29723 .21863 L
.2982 .21135 L
.2993 .20475 L
.30245 .19054 L
.30636 .17731 L
.31646 .15254 L
.32863 .13095 L
.34351 .11077 L
.3627 .09078 L
.38301 .07455 L
.40704 .06009 L
.43177 .04943 L
.44469 .04533 L
.45207 .04339 L
.45911 .04183 L
.46562 .0406 L
.47272 .03952 L
.47921 .03875 L
.48522 .03822 L
.48857 .03801 L
Mistroke
.49172 .03786 L
.49353 .03779 L
.49518 .03774 L
.49609 .03772 L
.49708 .03771 L
.49802 .0377 L
.49889 .03769 L
.4998 .03769 L
.50079 .03769 L
.50172 .03769 L
.50258 .0377 L
.5042 .03773 L
.50591 .03777 L
.50776 .03783 L
.50948 .03791 L
.51339 .03813 L
.51689 .03839 L
.52011 .03868 L
.5274 .03954 L
.5338 .04051 L
.54055 .04176 L
.55212 .04445 L
.56468 .04821 L
.58881 .05802 L
.61318 .07194 L
.63459 .08836 L
.65458 .10852 L
.67059 .12975 L
.68288 .15119 L
.68873 .16411 L
.69341 .17664 L
.69695 .18828 L
.69993 .2008 L
.70173 .21086 L
.70253 .21662 L
.70312 .22202 L
.70355 .22698 L
.70382 .23153 L
.70394 .23404 L
.70398 .23537 L
.70402 .23678 L
.70405 .23814 L
.70407 .23937 L
.70408 .24061 L
.70408 .24177 L
Mfstroke
.7381 .24177 m
.73809 .24362 L
.73807 .2453 L
.73803 .24723 L
.73798 .24907 L
.73786 .25233 L
.73768 .25586 L
.73742 .25975 L
.73707 .26387 L
.73626 .27124 L
.7352 .27881 L
.73397 .28588 L
.7304 .3018 L
.72564 .31776 L
.72032 .33203 L
.70508 .36272 L
.68837 .3874 L
.66676 .41171 L
.64336 .43186 L
.61578 .44982 L
.6014 .45719 L
.58533 .46405 L
.57107 .46901 L
.55508 .4734 L
s
.55508 .4734 m
.55299 .47387 L
s
.44707 .47387 m
.44578 .47361 L
.42945 .46917 L
.41442 .46395 L
.39848 .45713 L
.37089 .44182 L
.34604 .42339 L
.32245 .4004 L
.30185 .37377 L
.28608 .34629 L
.27978 .33227 L
.27412 .31707 L
.26978 .3025 L
.26664 .28903 L
.26414 .27431 L
.26316 .26616 L
.2628 .26241 L
.26249 .25842 L
.26227 .25501 L
.26218 .2532 L
.26209 .25125 L
.26203 .24947 L
.26198 .24783 L
.26195 .24627 L
.26192 .24462 L
.26191 .24282 L
.26191 .2409 L
.26192 .23909 L
.26194 .23745 L
.26199 .23551 L
.26205 .23342 L
.26221 .22962 L
.26243 .22591 L
.26273 .22193 L
.26344 .21477 L
.26456 .20628 L
.26586 .19857 L
.26953 .182 L
.27409 .16657 L
.28587 .13766 L
.30006 .11248 L
.31743 .08893 L
.33982 .06561 L
.36351 .04668 L
.39155 .02981 L
.4204 .01737 L
.43547 .01258 L
.44408 .01033 L
.45229 .0085 L
.45989 .00708 L
Mistroke
.46818 .00581 L
.47575 .00491 L
.48275 .0043 L
.48667 .00405 L
.49034 .00387 L
.49245 .00379 L
.49437 .00374 L
.49544 .00372 L
.4966 .0037 L
.49769 .00368 L
.49871 .00368 L
.49977 .00367 L
.50092 .00368 L
.50201 .00368 L
.50301 .00369 L
.5049 .00372 L
.5069 .00377 L
.50905 .00385 L
.51106 .00393 L
.51562 .00419 L
.5197 .00449 L
.52347 .00483 L
.53197 .00583 L
.53943 .00696 L
.54731 .00842 L
.56081 .01157 L
.57546 .01595 L
.60361 .0274 L
.63204 .04364 L
.65702 .06279 L
.68034 .08632 L
.69902 .11107 L
.71336 .1361 L
.72018 .15117 L
.72565 .16579 L
.72977 .17936 L
.73325 .19397 L
.73535 .20571 L
.73628 .21242 L
.73698 .21872 L
.73747 .22452 L
.7378 .22982 L
.73792 .23275 L
.73798 .2343 L
.73802 .23595 L
.73806 .23754 L
.73808 .23897 L
.73809 .24041 L
.7381 .24177 L
Mfstroke
.77211 .24177 m
.7721 .24388 L
.77208 .2458 L
.77204 .24802 L
.77198 .25011 L
.77184 .25383 L
.77163 .25787 L
.77133 .26232 L
.77093 .26702 L
.77002 .27545 L
.7688 .28411 L
.7674 .29218 L
.76332 .31038 L
.75788 .32861 L
.7518 .34492 L
.73438 .38 L
.71528 .4082 L
.69058 .43599 L
.66384 .45902 L
s
.66384 .45902 m
.64104 .47387 L
s
.35869 .47387 m
.35244 .4704 L
.32404 .44933 L
.29708 .42306 L
.27354 .39263 L
.25551 .36123 L
.24831 .3452 L
.24186 .32782 L
.23689 .31118 L
.23331 .29578 L
.23045 .27896 L
.22932 .26965 L
.22892 .26536 L
.22856 .2608 L
.22831 .2569 L
.22821 .25484 L
.22811 .25261 L
.22803 .25057 L
.22798 .2487 L
.22794 .24691 L
.22791 .24503 L
.22789 .24297 L
.22789 .24078 L
.22791 .23871 L
.22794 .23683 L
.22799 .23462 L
.22806 .23223 L
.22825 .22789 L
.2285 .22364 L
.22884 .2191 L
.22965 .21091 L
.23093 .20121 L
.23241 .1924 L
.2366 .17346 L
.24182 .15583 L
.25528 .12279 L
.2715 .09401 L
.29135 .0671 L
.31693 .04045 L
.34401 .01881 L
s
.34401 .01881 m
.37527 0 L
s
.62406 0 m
.6509 .01534 L
.67946 .03722 L
.70611 .06411 L
.72745 .0924 L
.74384 .121 L
.75164 .13822 L
.75788 .15493 L
.7626 .17045 L
.76657 .18714 L
.76897 .20056 L
.77003 .20823 L
.77083 .21543 L
.77139 .22206 L
.77177 .22812 L
.77191 .23147 L
.77198 .23324 L
.77203 .23512 L
.77207 .23693 L
.77209 .23857 L
.7721 .24022 L
.77211 .24177 L
s
.80612 .24177 m
.80611 .24414 L
.80609 .2463 L
.80604 .2488 L
.80598 .25115 L
.80582 .25534 L
.80559 .25989 L
.80525 .26489 L
.8048 .27018 L
.80377 .27966 L
.80239 .2894 L
.80082 .29848 L
.79623 .31895 L
.79011 .33947 L
.78327 .35782 L
.76368 .39728 L
.74219 .429 L
.71441 .46026 L
s
.71441 .46026 m
.69862 .47387 L
s
.3006 .47387 m
.27172 .44572 L
.24523 .41148 L
.22495 .37616 L
.21685 .35813 L
.20959 .33858 L
.204 .31986 L
.19997 .30253 L
.19675 .28361 L
.19549 .27313 L
.19503 .26831 L
.19463 .26318 L
.19435 .2588 L
.19423 .25647 L
.19412 .25396 L
.19404 .25167 L
.19398 .24956 L
.19393 .24755 L
.1939 .24544 L
.19388 .24312 L
.19388 .24066 L
.1939 .23833 L
.19393 .23622 L
.19398 .23373 L
.19407 .23103 L
.19428 .22615 L
.19456 .22138 L
.19494 .21627 L
.19585 .20705 L
.1973 .19614 L
.19896 .18623 L
.20368 .16493 L
.20955 .14508 L
.22469 .10792 L
.24294 .07555 L
.26527 .04527 L
.29405 .01529 L
s
.29405 .01529 m
.31318 0 L
s
.68668 0 m
.70189 .01166 L
.73187 .0419 L
.75588 .07373 L
.77432 .1059 L
.78309 .12528 L
.79012 .14408 L
.79542 .16153 L
.79989 .18031 L
.80259 .19541 L
.80379 .20404 L
.80469 .21214 L
.80532 .21959 L
.80574 .22641 L
.8059 .23018 L
.80597 .23217 L
.80603 .23429 L
.80607 .23633 L
.8061 .23817 L
.80612 .24003 L
.80612 .24177 L
s
.84014 .24177 m
.84013 .24441 L
.8401 .24681 L
.84005 .24958 L
.83998 .2522 L
.8398 .25685 L
.83954 .2619 L
.83916 .26746 L
.83867 .27334 L
.83752 .28387 L
.83599 .29469 L
.83425 .30478 L
.82915 .32753 L
.82235 .35032 L
.81475 .37071 L
.79298 .41456 L
.7691 .44981 L
s
.7691 .44981 m
.74772 .47387 L
s
.25198 .47387 m
.24635 .46838 L
.21692 .43034 L
.19439 .39109 L
.18539 .37106 L
.17732 .34933 L
.17112 .32853 L
.16663 .30928 L
.16306 .28826 L
.16165 .27661 L
.16114 .27125 L
.1607 .26556 L
.16039 .26069 L
.16026 .2581 L
.16013 .25532 L
.16004 .25277 L
.15997 .25043 L
.15992 .24819 L
.15989 .24584 L
.15987 .24328 L
.15987 .24053 L
.15989 .23795 L
.15992 .2356 L
.15998 .23283 L
.16007 .22984 L
.16031 .22442 L
.16062 .21911 L
.16105 .21343 L
.16206 .2032 L
.16366 .19107 L
.16551 .18006 L
.17075 .15639 L
.17727 .13434 L
.1941 .09305 L
.21438 .05708 L
.23919 .02343 L
s
.23919 .02343 m
.26168 0 L
s
.73811 0 m
.75763 .01969 L
.78431 .05506 L
.8048 .09081 L
.81455 .11234 L
.82235 .13323 L
.82824 .15262 L
.83321 .17348 L
.83621 .19026 L
.83754 .19985 L
.83854 .20885 L
.83924 .21713 L
.83971 .2247 L
.83989 .22889 L
.83997 .2311 L
.84003 .23346 L
.84008 .23572 L
.84011 .23777 L
.84013 .23983 L
.84014 .24177 L
s
.87415 .24177 m
.87414 .24467 L
.87411 .24731 L
.87405 .25036 L
.87397 .25324 L
.87378 .25836 L
.87349 .26391 L
.87308 .27002 L
.87253 .27649 L
.87127 .28807 L
.86959 .29998 L
.86767 .31108 L
.86206 .33611 L
.85458 .36118 L
.84622 .3836 L
.82227 .43184 L
.79601 .47061 L
s
.79601 .47061 m
.79311 .47387 L
s
.2077 .47387 m
.18861 .4492 L
.16383 .40602 L
.15393 .38398 L
.14505 .36009 L
.13823 .33721 L
.13329 .31603 L
.12936 .29291 L
.12782 .2801 L
.12726 .2742 L
.12677 .26794 L
.12643 .26258 L
.12628 .25974 L
.12615 .25667 L
.12605 .25387 L
.12597 .2513 L
.12592 .24884 L
.12588 .24625 L
.12585 .24343 L
.12585 .24041 L
.12587 .23756 L
.12591 .23498 L
.12598 .23194 L
.12608 .22865 L
.12634 .22268 L
.12668 .21685 L
.12715 .2106 L
.12826 .19934 L
.13003 .186 L
.13206 .17389 L
.13783 .14785 L
.145 .1236 L
.16351 .07818 L
.18581 .03861 L
.21311 .0016 L
s
.21311 .0016 m
.21464 0 L
s
.78529 0 m
.81274 .03639 L
.83528 .07571 L
.846 .09939 L
.85459 .12237 L
.86107 .1437 L
.86653 .16665 L
.86983 .18511 L
.8713 .19566 L
.87239 .20555 L
.87317 .21466 L
.87368 .223 L
.87388 .2276 L
.87397 .23004 L
.87404 .23263 L
.87409 .23512 L
.87412 .23737 L
.87414 .23964 L
.87415 .24177 L
s
.90816 .24177 m
.90815 .24493 L
.90812 .24781 L
.90806 .25114 L
.90797 .25428 L
.90776 .25987 L
.90745 .26593 L
.907 .27259 L
.9064 .27965 L
.90503 .29228 L
.90319 .30527 L
.9011 .31738 L
.89498 .34468 L
.88682 .37203 L
.8777 .3965 L
.85157 .44912 L
s
.85157 .44912 m
.83481 .47387 L
s
.1648 .47387 m
.16031 .46805 L
.13327 .42095 L
.12247 .39691 L
.11278 .37085 L
.10534 .34589 L
.09996 .32278 L
.09567 .29756 L
.09398 .28358 L
.09337 .27715 L
.09284 .27032 L
.09247 .26447 L
.09231 .26137 L
.09216 .25803 L
.09205 .25497 L
.09197 .25216 L
.09191 .24948 L
.09187 .24666 L
.09184 .24358 L
.09184 .24029 L
.09186 .23718 L
.0919 .23437 L
.09198 .23105 L
.09209 .22746 L
.09237 .22094 L
.09274 .21458 L
.09326 .20776 L
.09447 .19548 L
.0964 .18093 L
.09861 .16772 L
.10491 .13931 L
.11273 .11285 L
.13292 .0633 L
.15725 .02014 L
s
.15725 .02014 m
.1721 0 L
s
.82781 0 m
.84117 .01772 L
.86576 .06062 L
.87746 .08645 L
.88682 .11152 L
.89389 .13479 L
.89985 .15982 L
.90346 .17995 L
.90505 .19146 L
.90625 .20226 L
.90709 .2122 L
.90765 .22129 L
.90787 .22632 L
.90796 .22897 L
.90804 .23179 L
.9081 .23451 L
.90814 .23697 L
.90816 .23944 L
.90816 .24177 L
s
.94218 .24177 m
.94216 .2452 L
.94213 .24832 L
.94206 .25192 L
.94197 .25532 L
.94174 .26137 L
.9414 .26794 L
.94091 .27516 L
.94027 .28281 L
.93878 .29649 L
.93679 .31057 L
.93452 .32368 L
.92789 .35326 L
.91905 .38289 L
.90917 .40939 L
.88087 .4664 L
s
.88087 .4664 m
.87581 .47387 L
s
.12451 .47387 m
.10271 .43589 L
.09101 .40984 L
.08052 .3816 L
.07245 .35456 L
.06662 .32954 L
.06197 .30221 L
.06015 .28707 L
.05949 .2801 L
.05891 .27269 L
.05851 .26636 L
.05833 .263 L
.05817 .25938 L
.05805 .25606 L
.05797 .25303 L
.0579 .25012 L
.05785 .24707 L
.05783 .24373 L
.05783 .24016 L
.05785 .2368 L
.0579 .23375 L
.05798 .23015 L
.0581 .22626 L
.0584 .21921 L
.05881 .21232 L
.05936 .20493 L
.06068 .19162 L
.06276 .17586 L
.06516 .16155 L
.07198 .13077 L
.08046 .10211 L
.10233 .04843 L
.12869 .00167 L
s
.12869 .00167 m
.12992 0 L
s
.87015 0 m
.89624 .04552 L
.90891 .07351 L
.91906 .10066 L
.92672 .12587 L
.93317 .153 L
.93708 .1748 L
.93881 .18727 L
.9401 .19897 L
.94101 .20974 L
.94162 .21958 L
.94186 .22503 L
.94196 .2279 L
.94204 .23096 L
.94211 .23391 L
.94215 .23657 L
.94217 .23925 L
.94218 .24177 L
s
.97619 .24177 m
.97618 .24546 L
.97614 .24882 L
.97606 .2527 L
.97597 .25637 L
.97572 .26288 L
.97536 .26995 L
.97483 .27773 L
.97414 .28596 L
.97253 .3007 L
.97039 .31586 L
.96795 .32998 L
.96081 .36184 L
.95129 .39374 L
.94065 .42229 L
s
.94065 .42229 m
.91504 .47387 L
s
.08538 .47387 m
.07215 .45082 L
.05955 .42277 L
.04825 .39236 L
.03956 .36324 L
.03328 .33629 L
.02828 .30686 L
.02632 .29055 L
.0256 .28305 L
.02498 .27507 L
.02455 .26826 L
.02436 .26464 L
.02419 .26074 L
.02406 .25716 L
.02396 .25389 L
.02389 .25076 L
.02384 .24747 L
.02381 .24388 L
.02381 .24004 L
.02384 .23642 L
.02389 .23313 L
.02397 .22926 L
.0241 .22507 L
.02443 .21747 L
.02487 .21005 L
.02546 .2021 L
.02688 .18777 L
.02913 .17079 L
.03171 .15538 L
.03906 .12224 L
.04818 .09137 L
.07174 .03356 L
s
.07174 .03356 m
.09066 0 L
s
.90928 0 m
.92672 .03042 L
.94037 .06056 L
.95129 .08981 L
.95954 .11696 L
.9665 .14617 L
.9707 .16965 L
.97256 .18308 L
.97395 .19568 L
.97494 .20727 L
.97559 .21788 L
.97585 .22374 L
.97596 .22684 L
.97605 .23013 L
.97612 .2333 L
.97616 .23617 L
.97618 .23906 L
.97619 .24177 L
s
.5 .24177 m
.50059 .24177 L
.50112 .24177 L
.50174 .24177 L
.50232 .24177 L
.50286 .24177 L
.50336 .24177 L
.50391 .24177 L
.50449 .24177 L
.50507 .24177 L
.5057 .24177 L
.50629 .24177 L
.50683 .24177 L
.50746 .24177 L
.50782 .24177 L
.50815 .24177 L
.50876 .24177 L
.5094 .24177 L
.50973 .24177 L
.51007 .24177 L
.51069 .24177 L
.51103 .24177 L
.51135 .24177 L
.5117 .24177 L
.51208 .24177 L
.51241 .24177 L
.51276 .24177 L
.5134 .24177 L
.51403 .24177 L
.5146 .24177 L
.51516 .24177 L
.51569 .24177 L
.51627 .24177 L
.51689 .24177 L
.51751 .24177 L
.51816 .24177 L
.51871 .24177 L
.51932 .24177 L
.51967 .24177 L
.52 .24177 L
.52036 .24177 L
.52074 .24177 L
.52138 .24177 L
.52174 .24177 L
.52208 .24177 L
.52272 .24177 L
.52329 .24177 L
.52361 .24177 L
.52396 .24177 L
.52459 .24177 L
Mistroke
.52498 .24177 L
.52534 .24177 L
.52566 .24177 L
.52601 .24177 L
.52639 .24177 L
.5268 .24177 L
.52714 .24177 L
.52752 .24177 L
.52787 .24177 L
.5282 .24177 L
.52857 .24177 L
.52892 .24177 L
.52955 .24177 L
.5299 .24177 L
.53023 .24177 L
.53081 .24177 L
.53144 .24177 L
.53203 .24177 L
.53257 .24177 L
.53318 .24177 L
.53383 .24177 L
.53417 .24177 L
.53452 .24177 L
.53516 .24177 L
.53551 .24177 L
.53584 .24177 L
.53619 .24177 L
.53657 .24177 L
.5372 .24177 L
.53756 .24177 L
.5379 .24177 L
.53853 .24177 L
.5391 .24177 L
.53976 .24177 L
.54039 .24177 L
.54095 .24177 L
.54157 .24177 L
.54214 .24177 L
.54267 .24177 L
.54326 .24177 L
.54391 .24177 L
.54423 .24177 L
.54458 .24177 L
.5452 .24177 L
.54555 .24177 L
.54587 .24177 L
.54621 .24177 L
.54658 .24177 L
.5472 .24177 L
.54756 .24177 L
Mistroke
.54789 .24177 L
.5485 .24177 L
.54906 .24177 L
.54971 .24177 L
.55033 .24177 L
.55091 .24177 L
.55143 .24177 L
.55204 .24177 L
.55261 .24177 L
.55314 .24177 L
.55363 .24177 L
.55416 .24177 L
.55473 .24177 L
.5553 .24177 L
.55592 .24177 L
.55649 .24177 L
.55702 .24177 L
.55764 .24177 L
.55799 .24177 L
.55831 .24177 L
.5589 .24177 L
.55953 .24177 L
.5601 .24177 L
.56073 .24177 L
.56138 .24177 L
.56198 .24177 L
.56255 .24177 L
.56307 .24177 L
.56366 .24177 L
.56422 .24177 L
.56484 .24177 L
.56549 .24177 L
.56604 .24177 L
.56665 .24177 L
.5673 .24177 L
.56767 .24177 L
.56801 .24177 L
.56866 .24177 L
.56928 .24177 L
.56985 .24177 L
.57038 .24177 L
.57098 .24177 L
.57155 .24177 L
.57208 .24177 L
.57256 .24177 L
.57309 .24177 L
.57365 .24177 L
.57422 .24177 L
.57483 .24177 L
.5754 .24177 L
Mistroke
.57593 .24177 L
.57654 .24177 L
.57689 .24177 L
.57721 .24177 L
.5778 .24177 L
.57842 .24177 L
.57902 .24177 L
.57968 .24177 L
.5803 .24177 L
.58087 .24177 L
.58144 .24177 L
.58196 .24177 L
.58256 .24177 L
.58312 .24177 L
.58374 .24177 L
.58439 .24177 L
.58494 .24177 L
.58555 .24177 L
.58621 .24177 L
.58658 .24177 L
.58691 .24177 L
.58756 .24177 L
.58818 .24177 L
.58871 .24177 L
.58928 .24177 L
.58989 .24177 L
.59046 .24177 L
.59099 .24177 L
.59147 .24177 L
.592 .24177 L
.59256 .24177 L
.59313 .24177 L
.59374 .24177 L
.59432 .24177 L
.59484 .24177 L
.59545 .24177 L
.5958 .24177 L
.59612 .24177 L
.59671 .24177 L
.59733 .24177 L
.59793 .24177 L
.59859 .24177 L
.59922 .24177 L
.59979 .24177 L
.60037 .24177 L
.60088 .24177 L
.60148 .24177 L
.60205 .24177 L
.60266 .24177 L
.60331 .24177 L
Mistroke
.60387 .24177 L
.60448 .24177 L
.60514 .24177 L
.60551 .24177 L
.60584 .24177 L
.6065 .24177 L
.60711 .24177 L
.60764 .24177 L
.60822 .24177 L
.60882 .24177 L
.60939 .24177 L
.60992 .24177 L
.61041 .24177 L
.61094 .24177 L
.6115 .24177 L
.61207 .24177 L
.61268 .24177 L
.61326 .24177 L
.61378 .24177 L
.61439 .24177 L
.61474 .24177 L
.61506 .24177 L
.61565 .24177 L
.61627 .24177 L
.61688 .24177 L
.61754 .24177 L
.61816 .24177 L
.61874 .24177 L
.61926 .24177 L
.61983 .24177 L
.62043 .24177 L
.621 .24177 L
.62162 .24177 L
.62227 .24177 L
.62283 .24177 L
.62344 .24177 L
.6241 .24177 L
.62446 .24177 L
.6248 .24177 L
.62545 .24177 L
.62607 .24177 L
.6266 .24177 L
.62718 .24177 L
.62779 .24177 L
.62835 .24177 L
.62889 .24177 L
.62937 .24177 L
.62993 .24177 L
.63046 .24177 L
.63104 .24177 L
Mistroke
.63165 .24177 L
.63222 .24177 L
.63274 .24177 L
.63336 .24177 L
.63371 .24177 L
.63402 .24177 L
.63461 .24177 L
.63523 .24177 L
.63584 .24177 L
.63619 .24177 L
.63651 .24177 L
.63709 .24177 L
.63771 .24177 L
.63827 .24177 L
.63879 .24177 L
.63936 .24177 L
.63997 .24177 L
.64059 .24177 L
.64094 .24177 L
.64126 .24177 L
.64192 .24177 L
.64229 .24177 L
.64262 .24177 L
.64322 .24177 L
.64387 .24177 L
.64449 .24177 L
.64505 .24177 L
.64558 .24177 L
.64615 .24177 L
.64668 .24177 L
.64717 .24177 L
.64775 .24177 L
.64837 .24177 L
.64896 .24177 L
.64951 .24177 L
.65012 .24177 L
.65071 .24177 L
.65123 .24177 L
.65179 .24177 L
.65241 .24177 L
.65306 .24177 L
.65361 .24177 L
.65422 .24177 L
.65488 .24177 L
.65548 .24177 L
.6558 .24177 L
.65615 .24177 L
.65651 .24177 L
.65685 .24177 L
.65748 .24177 L
Mistroke
.65805 .24177 L
.65871 .24177 L
.65934 .24177 L
.6599 .24177 L
.66049 .24177 L
.66106 .24177 L
.66157 .24177 L
.66217 .24177 L
.66282 .24177 L
.66343 .24177 L
.664 .24177 L
.6646 .24177 L
.66525 .24177 L
.66586 .24177 L
.66642 .24177 L
.66708 .24177 L
.66745 .24177 L
.66779 .24177 L
.66842 .24177 L
.66873 .24177 L
.66909 .24177 L
.66942 .24177 L
.66978 .24177 L
.67042 .24177 L
.67078 .24177 L
.67111 .24177 L
.67147 .24177 L
.67186 .24177 L
.67219 .24177 L
.67256 .24177 L
.6729 .24177 L
.67322 .24177 L
.67383 .24177 L
.67446 .24177 L
.67507 .24177 L
.67573 .24177 L
.67635 .24177 L
.67692 .24177 L
.6775 .24177 L
.67801 .24177 L
.67861 .24177 L
.67918 .24177 L
.67979 .24177 L
.68044 .24177 L
.681 .24177 L
.68161 .24177 L
.68227 .24177 L
.68264 .24177 L
.68297 .24177 L
.68362 .24177 L
Mistroke
.68424 .24177 L
.68477 .24177 L
.68535 .24177 L
.68595 .24177 L
.68652 .24177 L
.68705 .24177 L
.68753 .24177 L
.68807 .24177 L
.68863 .24177 L
.6892 .24177 L
.68981 .24177 L
.69038 .24177 L
.6909 .24177 L
.69152 .24177 L
.69187 .24177 L
.69219 .24177 L
.69277 .24177 L
.69339 .24177 L
.694 .24177 L
.69466 .24177 L
.69529 .24177 L
.69586 .24177 L
.69644 .24177 L
.69696 .24177 L
.69756 .24177 L
.69812 .24177 L
.69874 .24177 L
.69939 .24177 L
.69995 .24177 L
.70056 .24177 L
.70122 .24177 L
.70159 .24177 L
.70192 .24177 L
.70257 .24177 L
.70319 .24177 L
.70372 .24177 L
.7043 .24177 L
.70491 .24177 L
.70548 .24177 L
.70601 .24177 L
.70649 .24177 L
.70705 .24177 L
.70758 .24177 L
.70816 .24177 L
.70877 .24177 L
.70934 .24177 L
.70986 .24177 L
.71048 .24177 L
.71083 .24177 L
.71114 .24177 L
Mistroke
.71173 .24177 L
.71235 .24177 L
.71296 .24177 L
.71331 .24177 L
.71362 .24177 L
.71421 .24177 L
.71483 .24177 L
.71538 .24177 L
.7159 .24177 L
.71647 .24177 L
.71709 .24177 L
.71771 .24177 L
.71806 .24177 L
.71838 .24177 L
.71904 .24177 L
.71941 .24177 L
.71974 .24177 L
.72034 .24177 L
.72099 .24177 L
.7216 .24177 L
.72217 .24177 L
.7227 .24177 L
.72326 .24177 L
.7238 .24177 L
.72429 .24177 L
.72486 .24177 L
.72549 .24177 L
.72607 .24177 L
.72662 .24177 L
.72724 .24177 L
.72782 .24177 L
.72834 .24177 L
.7289 .24177 L
.72952 .24177 L
.73017 .24177 L
.73073 .24177 L
.73134 .24177 L
.73199 .24177 L
.7326 .24177 L
.73291 .24177 L
.73326 .24177 L
.73362 .24177 L
.73396 .24177 L
.73459 .24177 L
.73516 .24177 L
.73579 .24177 L
.73645 .24177 L
.73701 .24177 L
.7376 .24177 L
.73817 .24177 L
Mistroke
.73868 .24177 L
.73928 .24177 L
.73993 .24177 L
.74054 .24177 L
.74111 .24177 L
.74171 .24177 L
.74236 .24177 L
.74297 .24177 L
.74353 .24177 L
.74419 .24177 L
.74456 .24177 L
.7449 .24177 L
.74553 .24177 L
.74584 .24177 L
.74619 .24177 L
.74653 .24177 L
.74689 .24177 L
.74753 .24177 L
.74788 .24177 L
.74821 .24177 L
.74858 .24177 L
.74897 .24177 L
.7493 .24177 L
.74967 .24177 L
.75001 .24177 L
.75033 .24177 L
.75093 .24177 L
.75157 .24177 L
.75217 .24177 L
.75283 .24177 L
.75345 .24177 L
.75403 .24177 L
.7546 .24177 L
.75512 .24177 L
.75572 .24177 L
.75628 .24177 L
.7569 .24177 L
.75755 .24177 L
.7581 .24177 L
.75871 .24177 L
.75937 .24177 L
.75974 .24177 L
.76007 .24177 L
.76073 .24177 L
.76134 .24177 L
.76187 .24177 L
.76245 .24177 L
.76305 .24177 L
.76362 .24177 L
.76415 .24177 L
Mistroke
.76464 .24177 L
.76517 .24177 L
.76573 .24177 L
.7663 .24177 L
.76691 .24177 L
.76748 .24177 L
.76801 .24177 L
.76862 .24177 L
.76897 .24177 L
.76929 .24177 L
.76987 .24177 L
.7705 .24177 L
.7711 .24177 L
.77176 .24177 L
.77239 .24177 L
.77296 .24177 L
.77354 .24177 L
.77406 .24177 L
.77466 .24177 L
.77522 .24177 L
.77584 .24177 L
.77649 .24177 L
.77705 .24177 L
.77766 .24177 L
.77831 .24177 L
.77868 .24177 L
.77902 .24177 L
.77967 .24177 L
.78029 .24177 L
.78082 .24177 L
.7814 .24177 L
.782 .24177 L
.78257 .24177 L
.7831 .24177 L
.78359 .24177 L
.78415 .24177 L
.78468 .24177 L
.78525 .24177 L
.78586 .24177 L
.78644 .24177 L
.78696 .24177 L
.78757 .24177 L
.78792 .24177 L
.78824 .24177 L
.78883 .24177 L
.78945 .24177 L
.79006 .24177 L
.7904 .24177 L
.79072 .24177 L
.7913 .24177 L
Mistroke
.79192 .24177 L
.79248 .24177 L
.793 .24177 L
.79357 .24177 L
.79418 .24177 L
.7948 .24177 L
.79515 .24177 L
.79547 .24177 L
.79613 .24177 L
.7965 .24177 L
.79683 .24177 L
.79743 .24177 L
.79808 .24177 L
.79869 .24177 L
.79926 .24177 L
.79979 .24177 L
.80035 .24177 L
.80089 .24177 L
.80138 .24177 L
.80195 .24177 L
.80258 .24177 L
.80316 .24177 L
.80371 .24177 L
.80433 .24177 L
.80491 .24177 L
.80543 .24177 L
.80599 .24177 L
.80661 .24177 L
.80726 .24177 L
.80782 .24177 L
.80843 .24177 L
.80908 .24177 L
.80968 .24177 L
.81 .24177 L
.81035 .24177 L
.81071 .24177 L
.81105 .24177 L
.81168 .24177 L
.81225 .24177 L
.81288 .24177 L
.81354 .24177 L
.81409 .24177 L
.81469 .24177 L
.81525 .24177 L
.81576 .24177 L
.81636 .24177 L
.81701 .24177 L
.81763 .24177 L
.81819 .24177 L
.8188 .24177 L
Mistroke
.81944 .24177 L
.82006 .24177 L
.82062 .24177 L
.82127 .24177 L
.82164 .24177 L
.82198 .24177 L
.82261 .24177 L
.82293 .24177 L
.82328 .24177 L
.82362 .24177 L
.82397 .24177 L
.82461 .24177 L
.82497 .24177 L
.8253 .24177 L
.82566 .24177 L
.82605 .24177 L
.82639 .24177 L
.82675 .24177 L
.8271 .24177 L
.82741 .24177 L
.82802 .24177 L
.82865 .24177 L
.82926 .24177 L
.82991 .24177 L
.83054 .24177 L
.83111 .24177 L
.83168 .24177 L
.8322 .24177 L
.8328 .24177 L
.83336 .24177 L
.83398 .24177 L
.83463 .24177 L
.83518 .24177 L
.83579 .24177 L
.83645 .24177 L
.83682 .24177 L
.83715 .24177 L
.83781 .24177 L
.83842 .24177 L
.83895 .24177 L
.83953 .24177 L
.84013 .24177 L
.8407 .24177 L
.84123 .24177 L
.84171 .24177 L
.84225 .24177 L
.84281 .24177 L
.84338 .24177 L
.84399 .24177 L
.84456 .24177 L
Mistroke
.84508 .24177 L
.8457 .24177 L
.84604 .24177 L
.84636 .24177 L
.84695 .24177 L
.84757 .24177 L
.84818 .24177 L
.84884 .24177 L
.84946 .24177 L
.85004 .24177 L
.85061 .24177 L
.85113 .24177 L
.85173 .24177 L
.85229 .24177 L
.85291 .24177 L
.85356 .24177 L
.85412 .24177 L
.85473 .24177 L
.85539 .24177 L
.85576 .24177 L
.85609 .24177 L
.85674 .24177 L
.85736 .24177 L
.85789 .24177 L
.85847 .24177 L
.85908 .24177 L
.85964 .24177 L
.86017 .24177 L
.86066 .24177 L
.86119 .24177 L
.86175 .24177 L
.86232 .24177 L
.86293 .24177 L
.86351 .24177 L
.86403 .24177 L
.86465 .24177 L
.86499 .24177 L
.86531 .24177 L
.8659 .24177 L
.86652 .24177 L
.86713 .24177 L
.86747 .24177 L
.86779 .24177 L
.86837 .24177 L
.86899 .24177 L
.86955 .24177 L
.87007 .24177 L
.87064 .24177 L
.87125 .24177 L
.87187 .24177 L
Mistroke
.87221 .24177 L
.87254 .24177 L
.8732 .24177 L
.87356 .24177 L
.8739 .24177 L
.8745 .24177 L
.87515 .24177 L
.87576 .24177 L
.87633 .24177 L
.87685 .24177 L
.87742 .24177 L
.87796 .24177 L
.87844 .24177 L
.87902 .24177 L
.87964 .24177 L
.88023 .24177 L
.88078 .24177 L
.88139 .24177 L
.88197 .24177 L
.88249 .24177 L
.88306 .24177 L
.88367 .24177 L
.88433 .24177 L
.88488 .24177 L
.88549 .24177 L
.88614 .24177 L
.88675 .24177 L
.88706 .24177 L
.88741 .24177 L
.88777 .24177 L
.88811 .24177 L
.88874 .24177 L
.88931 .24177 L
.88994 .24177 L
.8906 .24177 L
.89116 .24177 L
.89175 .24177 L
.89231 .24177 L
.89282 .24177 L
.89342 .24177 L
.89407 .24177 L
.89469 .24177 L
.89525 .24177 L
.89586 .24177 L
.8965 .24177 L
.89712 .24177 L
.89767 .24177 L
.89833 .24177 L
.8987 .24177 L
.89904 .24177 L
Mistroke
.89967 .24177 L
.90002 .24177 L
.90034 .24177 L
.90067 .24177 L
.90103 .24177 L
.90167 .24177 L
.90202 .24177 L
.90236 .24177 L
.90272 .24177 L
.90311 .24177 L
.90344 .24177 L
.90381 .24177 L
.90415 .24177 L
.90447 .24177 L
.90507 .24177 L
.90571 .24177 L
.90632 .24177 L
.90697 .24177 L
.90759 .24177 L
.90817 .24177 L
.90874 .24177 L
.90926 .24177 L
.90985 .24177 L
.91042 .24177 L
.91103 .24177 L
.91168 .24177 L
.91224 .24177 L
.91285 .24177 L
.9135 .24177 L
.91387 .24177 L
.91421 .24177 L
.91486 .24177 L
.91548 .24177 L
.916 .24177 L
.91658 .24177 L
.91719 .24177 L
.91775 .24177 L
.91828 .24177 L
.91877 .24177 L
.9193 .24177 L
.91986 .24177 L
.92043 .24177 L
.92104 .24177 L
.92161 .24177 L
.92214 .24177 L
.92275 .24177 L
.9231 .24177 L
.92342 .24177 L
.924 .24177 L
.92463 .24177 L
Mistroke
.92523 .24177 L
.92589 .24177 L
.92651 .24177 L
.92709 .24177 L
.92766 .24177 L
.92818 .24177 L
.92878 .24177 L
.92934 .24177 L
.92996 .24177 L
.93061 .24177 L
.93117 .24177 L
.93178 .24177 L
.93244 .24177 L
.9328 .24177 L
.93314 .24177 L
.93379 .24177 L
.93441 .24177 L
.93494 .24177 L
.93552 .24177 L
.93612 .24177 L
.93669 .24177 L
.93722 .24177 L
.93771 .24177 L
.93824 .24177 L
.9388 .24177 L
.93937 .24177 L
.93998 .24177 L
.94055 .24177 L
.94108 .24177 L
.94169 .24177 L
.94204 .24177 L
.94236 .24177 L
.94294 .24177 L
.94357 .24177 L
.94417 .24177 L
.94452 .24177 L
.94483 .24177 L
.94542 .24177 L
.94604 .24177 L
.94659 .24177 L
.94711 .24177 L
.94768 .24177 L
.94829 .24177 L
.94891 .24177 L
.94926 .24177 L
.94958 .24177 L
.95024 .24177 L
.95061 .24177 L
.95094 .24177 L
.95154 .24177 L
Mistroke
.95219 .24177 L
.9528 .24177 L
.95337 .24177 L
.9539 .24177 L
.95446 .24177 L
.955 .24177 L
.95549 .24177 L
.95606 .24177 L
.95668 .24177 L
.95727 .24177 L
.95782 .24177 L
.95843 .24177 L
.95901 .24177 L
.95953 .24177 L
.9601 .24177 L
.96071 .24177 L
.96137 .24177 L
.96192 .24177 L
.96253 .24177 L
.96297 .24177 L
.96338 .24177 L
.96383 .24177 L
.9643 .24177 L
.96471 .24177 L
.9651 .24177 L
.96552 .24177 L
.96598 .24177 L
.96636 .24177 L
.96678 .24177 L
.96722 .24177 L
.96762 .24177 L
.968 .24177 L
.96835 .24177 L
.96875 .24177 L
.96912 .24177 L
.96953 .24177 L
.96998 .24177 L
.97045 .24177 L
.97089 .24177 L
.9713 .24177 L
.97167 .24177 L
.97211 .24177 L
.97252 .24177 L
.97296 .24177 L
.97343 .24177 L
.97387 .24177 L
.97427 .24177 L
.97475 .24177 L
.97526 .24177 L
.97575 .24177 L
Mistroke
.97619 .24177 L
Mfstroke
.5 .24177 m
.5174 .25015 L
.53639 .25929 L
.55421 .26788 L
.57136 .27613 L
.5896 .28492 L
.60717 .29338 L
.62584 .30237 L
.64383 .31103 L
.66113 .31937 L
.67954 .32823 L
.69727 .33677 L
.71431 .34498 L
.73246 .35372 L
.74993 .36213 L
.7685 .37107 L
.78639 .37969 L
.80359 .38797 L
.8219 .39679 L
.83953 .40528 L
.85826 .4143 L
.87631 .42299 L
.89368 .43135 L
.91215 .44025 L
.92903 .44838 L
s
.5 .24177 m
.51204 .25687 L
.52518 .27334 L
.53752 .28881 L
.54938 .30369 L
.56201 .31952 L
.57416 .33477 L
.58708 .35097 L
.59953 .36658 L
.61151 .3816 L
.62425 .39757 L
.63652 .41295 L
.64831 .42774 L
.66087 .44349 L
.67296 .45865 L
s
.67296 .45865 m
.68509 .47387 L
s
.5 .24177 m
.5043 .2606 L
.50899 .28114 L
.51339 .30043 L
.51762 .31898 L
.52213 .33873 L
.52647 .35774 L
.53108 .37794 L
.53552 .3974 L
.5398 .41613 L
.54434 .43605 L
.54872 .45523 L
.55293 .47368 L
s
.55293 .47368 m
.55297 .47387 L
s
.5 .24177 m
.4957 .2606 L
.49101 .28114 L
.48661 .30043 L
.48238 .31898 L
.47787 .33873 L
.47353 .35774 L
.46892 .37794 L
.46448 .3974 L
.4602 .41613 L
.45566 .43605 L
.45128 .45523 L
.44707 .47368 L
s
.44707 .47368 m
.44703 .47387 L
s
.5 .24177 m
.48796 .25687 L
.47482 .27334 L
.46248 .28881 L
.45062 .30369 L
.43799 .31952 L
.42584 .33477 L
.41292 .35097 L
.40047 .36658 L
.38849 .3816 L
.37575 .39757 L
.36348 .41295 L
.35169 .42774 L
.33913 .44349 L
.32704 .45865 L
s
.32704 .45865 m
.31491 .47387 L
s
.5 .24177 m
.4826 .25015 L
.46361 .25929 L
.44579 .26788 L
.42864 .27613 L
.4104 .28492 L
.39283 .29338 L
.37416 .30237 L
.35617 .31103 L
.33887 .31937 L
.32046 .32823 L
.30273 .33677 L
.28569 .34498 L
.26754 .35372 L
.25007 .36213 L
.2315 .37107 L
.21361 .37969 L
.19641 .38797 L
.1781 .39679 L
.16047 .40528 L
.14174 .4143 L
.12369 .42299 L
.10632 .43135 L
.08785 .44025 L
.07097 .44838 L
s
.5 .24177 m
.48068 .24177 L
.45961 .24177 L
.43983 .24177 L
.4208 .24177 L
.40055 .24177 L
.38105 .24177 L
.36033 .24177 L
.34036 .24177 L
.32116 .24177 L
.30072 .24177 L
.28105 .24177 L
.26213 .24177 L
.24199 .24177 L
.2226 .24177 L
.20199 .24177 L
.18213 .24177 L
.16304 .24177 L
.14271 .24177 L
.12315 .24177 L
.10236 .24177 L
.08232 .24177 L
.06305 .24177 L
.04255 .24177 L
.02381 .24177 L
s
.5 .24177 m
.4826 .23339 L
.46361 .22425 L
.44579 .21566 L
.42864 .20741 L
.4104 .19862 L
.39283 .19016 L
.37416 .18117 L
.35617 .1725 L
.33887 .16417 L
.32046 .15531 L
.30273 .14677 L
.28569 .13856 L
.26754 .12982 L
.25007 .12141 L
.2315 .11247 L
.21361 .10385 L
.19641 .09557 L
.1781 .08675 L
.16047 .07826 L
.14174 .06924 L
.12369 .06055 L
.10632 .05218 L
.08785 .04329 L
.07097 .03516 L
s
.5 .24177 m
.48796 .22667 L
.47482 .21019 L
.46248 .19473 L
.45062 .17985 L
.43799 .16401 L
.42584 .14877 L
.41292 .13257 L
.40047 .11696 L
.38849 .10194 L
.37575 .08597 L
.36348 .07058 L
.35169 .05579 L
.33913 .04004 L
.32704 .02489 L
.31419 .00877 L
s
.31419 .00877 m
.3072 0 L
s
.5 .24177 m
.4957 .22294 L
.49101 .2024 L
.48661 .18311 L
.48238 .16456 L
.47787 .14481 L
.47353 .1258 L
.46892 .1056 L
.46448 .08613 L
.4602 .06741 L
.45566 .04749 L
.45128 .02831 L
.44707 .00986 L
s
.44707 .00986 m
.44482 0 L
s
.5 .24177 m
.5043 .22294 L
.50899 .2024 L
.51339 .18311 L
.51762 .16456 L
.52213 .14481 L
.52647 .1258 L
.53108 .1056 L
.53552 .08613 L
.5398 .06741 L
.54434 .04749 L
.54872 .02831 L
.55293 .00986 L
s
.55293 .00986 m
.55518 0 L
s
.5 .24177 m
.51204 .22667 L
.52518 .21019 L
.53752 .19473 L
.54938 .17985 L
.56201 .16401 L
.57416 .14877 L
.58708 .13257 L
.59953 .11696 L
.61151 .10194 L
.62425 .08597 L
.63652 .07058 L
.64831 .05579 L
.66087 .04004 L
.67296 .02489 L
.68581 .00877 L
s
.68581 .00877 m
.6928 0 L
s
.5 .24177 m
.5174 .23339 L
.53639 .22425 L
.55421 .21566 L
.57136 .20741 L
.5896 .19862 L
.60717 .19016 L
.62584 .18117 L
.64383 .1725 L
.66113 .16417 L
.67954 .15531 L
.69727 .14677 L
.71431 .13856 L
.73246 .12982 L
.74993 .12141 L
.7685 .11247 L
.78639 .10385 L
.80359 .09557 L
.8219 .08675 L
.83953 .07826 L
.85826 .06924 L
.87631 .06055 L
.89368 .05218 L
.91215 .04329 L
.92903 .03516 L
s
.5 .24177 m
.51932 .24177 L
.54039 .24177 L
.56017 .24177 L
.5792 .24177 L
.59945 .24177 L
.61895 .24177 L
.63967 .24177 L
.65964 .24177 L
.67884 .24177 L
.69928 .24177 L
.71895 .24177 L
.73787 .24177 L
.75801 .24177 L
.7774 .24177 L
.79801 .24177 L
.81787 .24177 L
.83696 .24177 L
.85729 .24177 L
.87685 .24177 L
.89764 .24177 L
.91768 .24177 L
.93695 .24177 L
.95745 .24177 L
.97619 .24177 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.29.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.29.1"]
}, Open  ]],

Cell["\<\
Here is the image of the Cartesian grid under exponentiation. \
\>", "MathCaption",
 CellTags->{"S5.29.1", "1.8"}],

Cell[CellGroupData[{

Cell["CartesianMap[Exp, { -1, 1}, { -2, 2}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.29.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.41228 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.303675 0.247405 0.706141 0.247405 [
[.05627 -0.0125 -6 -9 ]
[.05627 -0.0125 6 0 ]
[.30367 -0.0125 -3 -9 ]
[.30367 -0.0125 3 0 ]
[.55108 -0.0125 -3 -9 ]
[.55108 -0.0125 3 0 ]
[.79848 -0.0125 -3 -9 ]
[.79848 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .21133 -12 -4.5 ]
[-0.0125 .21133 0 4.5 ]
[-0.0125 .45874 -12 -4.5 ]
[-0.0125 .45874 0 4.5 ]
[-0.0125 .70614 -6 -4.5 ]
[-0.0125 .70614 0 4.5 ]
[-0.0125 .95355 -6 -4.5 ]
[-0.0125 .95355 0 4.5 ]
[-0.0125 1.20095 -6 -4.5 ]
[-0.0125 1.20095 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1.41228 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1.41228 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05627 0 m
.05627 .00625 L
s
[(-1)] .05627 -0.0125 0 1 Mshowa
.30367 0 m
.30367 .00625 L
s
[(0)] .30367 -0.0125 0 1 Mshowa
.55108 0 m
.55108 .00625 L
s
[(1)] .55108 -0.0125 0 1 Mshowa
.79848 0 m
.79848 .00625 L
s
[(2)] .79848 -0.0125 0 1 Mshowa
.125 Mabswid
.10575 0 m
.10575 .00375 L
s
.15523 0 m
.15523 .00375 L
s
.20471 0 m
.20471 .00375 L
s
.25419 0 m
.25419 .00375 L
s
.35316 0 m
.35316 .00375 L
s
.40264 0 m
.40264 .00375 L
s
.45212 0 m
.45212 .00375 L
s
.5016 0 m
.5016 .00375 L
s
.60056 0 m
.60056 .00375 L
s
.65004 0 m
.65004 .00375 L
s
.69952 0 m
.69952 .00375 L
s
.749 0 m
.749 .00375 L
s
.00679 0 m
.00679 .00375 L
s
.84797 0 m
.84797 .00375 L
s
.89745 0 m
.89745 .00375 L
s
.94693 0 m
.94693 .00375 L
s
.99641 0 m
.99641 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .21133 m
.00625 .21133 L
s
[(-2)] -0.0125 .21133 1 0 Mshowa
0 .45874 m
.00625 .45874 L
s
[(-1)] -0.0125 .45874 1 0 Mshowa
0 .70614 m
.00625 .70614 L
s
[(0)] -0.0125 .70614 1 0 Mshowa
0 .95355 m
.00625 .95355 L
s
[(1)] -0.0125 .95355 1 0 Mshowa
0 1.20095 m
.00625 1.20095 L
s
[(2)] -0.0125 1.20095 1 0 Mshowa
.125 Mabswid
0 .26081 m
.00375 .26081 L
s
0 .31029 m
.00375 .31029 L
s
0 .35977 m
.00375 .35977 L
s
0 .40926 m
.00375 .40926 L
s
0 .50822 m
.00375 .50822 L
s
0 .5577 m
.00375 .5577 L
s
0 .60718 m
.00375 .60718 L
s
0 .65666 m
.00375 .65666 L
s
0 .75562 m
.00375 .75562 L
s
0 .8051 m
.00375 .8051 L
s
0 .85458 m
.00375 .85458 L
s
0 .90407 m
.00375 .90407 L
s
0 1.00303 m
.00375 1.00303 L
s
0 1.05251 m
.00375 1.05251 L
s
0 1.10199 m
.00375 1.10199 L
s
0 1.15147 m
.00375 1.15147 L
s
0 .16185 m
.00375 .16185 L
s
0 .11237 m
.00375 .11237 L
s
0 .06289 m
.00375 .06289 L
s
0 .01341 m
.00375 .01341 L
s
0 1.25043 m
.00375 1.25043 L
s
0 1.29991 m
.00375 1.29991 L
s
0 1.34939 m
.00375 1.34939 L
s
0 1.39887 m
.00375 1.39887 L
s
.25 Mabswid
0 0 m
0 1.41228 L
s
.05627 1.40603 m
.05627 1.41228 L
s
.30367 1.40603 m
.30367 1.41228 L
s
.55108 1.40603 m
.55108 1.41228 L
s
.79848 1.40603 m
.79848 1.41228 L
s
.125 Mabswid
.10575 1.40853 m
.10575 1.41228 L
s
.15523 1.40853 m
.15523 1.41228 L
s
.20471 1.40853 m
.20471 1.41228 L
s
.25419 1.40853 m
.25419 1.41228 L
s
.35316 1.40853 m
.35316 1.41228 L
s
.40264 1.40853 m
.40264 1.41228 L
s
.45212 1.40853 m
.45212 1.41228 L
s
.5016 1.40853 m
.5016 1.41228 L
s
.60056 1.40853 m
.60056 1.41228 L
s
.65004 1.40853 m
.65004 1.41228 L
s
.69952 1.40853 m
.69952 1.41228 L
s
.749 1.40853 m
.749 1.41228 L
s
.00679 1.40853 m
.00679 1.41228 L
s
.84797 1.40853 m
.84797 1.41228 L
s
.89745 1.40853 m
.89745 1.41228 L
s
.94693 1.40853 m
.94693 1.41228 L
s
.99641 1.40853 m
.99641 1.41228 L
s
.25 Mabswid
0 1.41228 m
1 1.41228 L
s
.99375 .21133 m
1 .21133 L
s
.99375 .45874 m
1 .45874 L
s
.99375 .70614 m
1 .70614 L
s
.99375 .95355 m
1 .95355 L
s
.99375 1.20095 m
1 1.20095 L
s
.125 Mabswid
.99625 .26081 m
1 .26081 L
s
.99625 .31029 m
1 .31029 L
s
.99625 .35977 m
1 .35977 L
s
.99625 .40926 m
1 .40926 L
s
.99625 .50822 m
1 .50822 L
s
.99625 .5577 m
1 .5577 L
s
.99625 .60718 m
1 .60718 L
s
.99625 .65666 m
1 .65666 L
s
.99625 .75562 m
1 .75562 L
s
.99625 .8051 m
1 .8051 L
s
.99625 .85458 m
1 .85458 L
s
.99625 .90407 m
1 .90407 L
s
.99625 1.00303 m
1 1.00303 L
s
.99625 1.05251 m
1 1.05251 L
s
.99625 1.10199 m
1 1.10199 L
s
.99625 1.15147 m
1 1.15147 L
s
.99625 .16185 m
1 .16185 L
s
.99625 .11237 m
1 .11237 L
s
.99625 .06289 m
1 .06289 L
s
.99625 .01341 m
1 .01341 L
s
.99625 1.25043 m
1 1.25043 L
s
.99625 1.29991 m
1 1.29991 L
s
.99625 1.34939 m
1 1.34939 L
s
.99625 1.39887 m
1 1.39887 L
s
.25 Mabswid
1 0 m
1 1.41228 L
s
0 .70614 m
1 .70614 L
s
.30367 0 m
.30367 1.41228 L
s
0 0 m
1 0 L
1 1.41228 L
0 1.41228 L
closepath
clip
newpath
.5 Mabswid
.2658 .62338 m
.27245 .62065 L
.27967 .61835 L
.28327 .61744 L
.28716 .61664 L
.29146 .61595 L
.29356 .61569 L
.2955 .61549 L
.29739 .61534 L
.29939 .61523 L
.30043 .61518 L
.30141 .61515 L
.30197 .61514 L
.30248 .61513 L
.30276 .61513 L
.30307 .61513 L
.30336 .61513 L
.30363 .61513 L
.30411 .61513 L
.30439 .61513 L
.30464 .61513 L
.3051 .61514 L
.30558 .61515 L
.30643 .61517 L
.30736 .6152 L
.30835 .61525 L
.30941 .61531 L
.31132 .61545 L
.31333 .61564 L
.31519 .61586 L
.31937 .61649 L
.32303 .61721 L
.32688 .61813 L
.33399 .62032 L
.34049 .6229 L
.35347 .62995 L
.3597 .63441 L
.36582 .63965 L
.37563 .6504 L
.38031 .65704 L
.38403 .66341 L
.38738 .67041 L
.38993 .6771 L
.39199 .68414 L
.39284 .6879 L
.39357 .69193 L
.39407 .6955 L
.39428 .69751 L
.39444 .69936 L
.39455 .70107 L
Mistroke
.3946 .70204 L
.39463 .70294 L
.39465 .70339 L
.39466 .70381 L
.39467 .70419 L
.39468 .70459 L
.39468 .70503 L
.39469 .70544 L
.39469 .70587 L
.39469 .70635 L
.39469 .70685 L
.39468 .70731 L
.39468 .70756 L
.39467 .70782 L
.39466 .70836 L
.39463 .70934 L
.3946 .71026 L
.3945 .71197 L
.39437 .71381 L
.39417 .71584 L
.39392 .71797 L
.39334 .72175 L
.39264 .72534 L
.39174 .72913 L
.3897 .73586 L
.38669 .74345 L
.38324 .75034 L
.37508 .76258 L
.36436 .77397 L
.35833 .77892 L
.35234 .78305 L
.33952 .7898 L
.33226 .79255 L
.32544 .79451 L
.322 .79529 L
.31831 .79597 L
.31637 .79627 L
.31423 .79654 L
.31242 .79674 L
.31043 .79691 L
.30856 .79703 L
.30754 .79707 L
.30658 .79711 L
.30612 .79712 L
.30569 .79713 L
.3053 .79714 L
.30488 .79715 L
.30442 .79715 L
.304 .79716 L
.30355 .79716 L
Mistroke
.30305 .79715 L
.3028 .79715 L
.30252 .79715 L
.30201 .79714 L
.30152 .79713 L
.30107 .79712 L
.30004 .79708 L
.29894 .79703 L
.29692 .79691 L
.29509 .79675 L
.29128 .79631 L
.2878 .79576 L
.28003 .79403 L
.27316 .79189 L
.26584 .78892 L
.2658 .7889 L
Mfstroke
.25998 .61067 m
.26765 .60752 L
.27598 .60487 L
.28013 .60382 L
.28462 .60289 L
.28959 .6021 L
.292 .6018 L
.29424 .60157 L
.29642 .6014 L
.29874 .60127 L
.29994 .60122 L
.30106 .60118 L
.30171 .60117 L
.3023 .60116 L
.30262 .60115 L
.30298 .60115 L
.30331 .60115 L
.30362 .60115 L
.30418 .60115 L
.3045 .60115 L
.30478 .60116 L
.30532 .60116 L
.30588 .60117 L
.30685 .6012 L
.30792 .60124 L
.30906 .60129 L
.31029 .60136 L
.31249 .60152 L
.31481 .60174 L
.31696 .60199 L
.32178 .60272 L
.326 .60355 L
.33044 .60462 L
.33865 .60715 L
.34614 .61012 L
.36111 .61825 L
.3683 .62339 L
.37537 .62944 L
.38668 .64184 L
.39208 .6495 L
.39637 .65685 L
.40024 .66493 L
.40318 .67264 L
.40555 .68076 L
.40654 .6851 L
.40738 .68974 L
.40795 .69387 L
.40819 .69619 L
.40837 .69831 L
.4085 .70029 L
Mistroke
.40856 .70141 L
.4086 .70245 L
.40862 .70297 L
.40863 .70345 L
.40864 .70389 L
.40865 .70436 L
.40866 .70486 L
.40866 .70533 L
.40867 .70583 L
.40867 .70638 L
.40866 .70696 L
.40866 .70749 L
.40865 .70777 L
.40865 .70808 L
.40864 .7087 L
.4086 .70983 L
.40856 .71089 L
.40845 .71287 L
.40829 .71499 L
.40807 .71733 L
.40778 .71978 L
.40711 .72414 L
.40631 .72828 L
.40526 .73266 L
.40291 .74042 L
.39944 .74918 L
.39545 .75713 L
.38604 .77125 L
.37368 .78439 L
.36673 .79009 L
.35981 .79486 L
.34502 .80265 L
.33664 .80582 L
.32879 .80809 L
.32481 .80898 L
.32055 .80977 L
.31832 .81011 L
.31585 .81043 L
.31376 .81065 L
.31147 .81084 L
.30931 .81098 L
.30813 .81104 L
.30703 .81108 L
.3065 .8111 L
.306 .81111 L
.30554 .81112 L
.30506 .81112 L
.30454 .81113 L
.30405 .81113 L
.30353 .81113 L
Mistroke
.30295 .81113 L
.30266 .81113 L
.30234 .81112 L
.30176 .81112 L
.30119 .8111 L
.30067 .81109 L
.29948 .81105 L
.29821 .81099 L
.29588 .81084 L
.29378 .81067 L
.28938 .81016 L
.28536 .80952 L
.2764 .80753 L
.26847 .80506 L
.26003 .80163 L
.25998 .80161 L
Mfstroke
.25327 .59601 m
.26212 .59238 L
.27173 .58932 L
.27652 .58811 L
.2817 .58704 L
.28742 .58612 L
.29021 .58578 L
.29279 .58552 L
.29531 .58532 L
.29798 .58516 L
.29936 .5851 L
.30066 .58506 L
.3014 .58505 L
.30208 .58504 L
.30246 .58503 L
.30287 .58503 L
.30326 .58503 L
.30362 .58503 L
.30426 .58503 L
.30462 .58503 L
.30496 .58503 L
.30557 .58504 L
.30622 .58505 L
.30734 .58508 L
.30857 .58513 L
.30989 .58519 L
.3113 .58527 L
.31385 .58545 L
.31652 .58571 L
.31899 .586 L
.32456 .58684 L
.32943 .5878 L
.33456 .58903 L
.34402 .59194 L
.35266 .59537 L
.36993 .60476 L
.37822 .61069 L
.38638 .61766 L
.39942 .63197 L
.40565 .6408 L
.41061 .64928 L
.41507 .6586 L
.41846 .6675 L
.4212 .67686 L
.42233 .68187 L
.4233 .68723 L
.42396 .69198 L
.42424 .69466 L
.42445 .69711 L
.4246 .69939 L
Mistroke
.42467 .70069 L
.42471 .70188 L
.42473 .70248 L
.42475 .70304 L
.42476 .70354 L
.42477 .70408 L
.42478 .70467 L
.42479 .70521 L
.42479 .70578 L
.42479 .70642 L
.42479 .70709 L
.42478 .7077 L
.42478 .70802 L
.42477 .70838 L
.42475 .70909 L
.42471 .7104 L
.42467 .71162 L
.42454 .7139 L
.42436 .71635 L
.4241 .71905 L
.42376 .72188 L
.423 .72691 L
.42207 .73168 L
.42086 .73674 L
.41815 .74568 L
.41414 .75579 L
.40955 .76496 L
.39869 .78124 L
.38443 .79641 L
.37641 .80298 L
.36843 .80849 L
.35137 .81747 L
.34171 .82113 L
.33264 .82374 L
.32806 .82478 L
.32314 .82568 L
.32057 .82607 L
.31772 .82644 L
.31531 .8267 L
.31267 .82692 L
.31017 .82708 L
.30881 .82715 L
.30755 .82719 L
.30694 .82721 L
.30636 .82723 L
.30583 .82724 L
.30527 .82725 L
.30467 .82725 L
.30411 .82726 L
.30351 .82726 L
Mistroke
.30284 .82725 L
.30251 .82725 L
.30214 .82725 L
.30147 .82724 L
.30081 .82722 L
.30021 .82721 L
.29883 .82716 L
.29737 .82709 L
.29469 .82692 L
.29226 .82672 L
.28719 .82613 L
.28255 .8254 L
.27221 .8231 L
.26307 .82025 L
.25333 .8163 L
.25327 .81627 L
Mfstroke
.24553 .5791 m
.25574 .57491 L
.26682 .57138 L
.27235 .56998 L
.27832 .56875 L
.28493 .56769 L
.28814 .56729 L
.29112 .56699 L
.29402 .56676 L
.2971 .56658 L
.2987 .56652 L
.3002 .56647 L
.30105 .56645 L
.30184 .56644 L
.30227 .56643 L
.30275 .56643 L
.30319 .56643 L
.30361 .56643 L
.30435 .56643 L
.30477 .56643 L
.30515 .56644 L
.30586 .56644 L
.30661 .56646 L
.3079 .56649 L
.30933 .56654 L
.31085 .56661 L
.31248 .5667 L
.31541 .56692 L
.3185 .56722 L
.32135 .56755 L
.32777 .56852 L
.33339 .56962 L
.3393 .57105 L
.35021 .57441 L
.36018 .57836 L
.38011 .58919 L
.38967 .59603 L
.39908 .60407 L
.41413 .62058 L
.42131 .63077 L
.42703 .64054 L
.43217 .65129 L
.43609 .66156 L
.43924 .67237 L
.44056 .67815 L
.44167 .68432 L
.44243 .68981 L
.44276 .6929 L
.443 .69573 L
.44317 .69836 L
Mistroke
.44325 .69985 L
.4433 .70123 L
.44332 .70192 L
.44334 .70256 L
.44336 .70315 L
.44337 .70376 L
.44338 .70444 L
.44338 .70506 L
.44339 .70573 L
.44339 .70646 L
.44338 .70723 L
.44338 .70794 L
.44337 .70831 L
.44336 .70872 L
.44335 .70955 L
.4433 .71105 L
.44325 .71246 L
.4431 .71509 L
.44289 .71792 L
.44259 .72103 L
.4422 .72429 L
.44132 .7301 L
.44025 .73561 L
.43886 .74144 L
.43573 .75176 L
.43111 .76342 L
.42581 .77399 L
.41328 .79278 L
.39683 .81027 L
.38758 .81786 L
.37838 .82421 L
.3587 .83456 L
.34755 .83879 L
.33709 .8418 L
.3318 .84299 L
.32613 .84404 L
.32316 .84449 L
.31987 .84491 L
.31709 .84521 L
.31405 .84547 L
.31117 .84565 L
.3096 .84573 L
.30814 .84578 L
.30744 .8458 L
.30677 .84582 L
.30616 .84583 L
.30552 .84584 L
.30482 .84585 L
.30418 .84585 L
.30348 .84586 L
Mistroke
.30272 .84585 L
.30233 .84585 L
.3019 .84584 L
.30113 .84583 L
.30037 .84582 L
.29967 .8458 L
.29809 .84574 L
.2964 .84567 L
.29331 .84547 L
.2905 .84523 L
.28465 .84455 L
.27931 .84371 L
.26738 .84106 L
.25683 .83777 L
.2456 .83321 L
.24553 .83318 L
Mfstroke
.2366 .55959 m
.24838 .55476 L
.26116 .55068 L
.26754 .54908 L
.27443 .54765 L
.28205 .54643 L
.28576 .54597 L
.28919 .54562 L
.29254 .54536 L
.29609 .54515 L
.29794 .54507 L
.29966 .54502 L
.30065 .545 L
.30156 .54499 L
.30206 .54498 L
.3026 .54498 L
.30312 .54497 L
.3036 .54497 L
.30445 .54497 L
.30493 .54498 L
.30538 .54498 L
.30619 .54499 L
.30706 .54501 L
.30855 .54505 L
.31019 .5451 L
.31195 .54518 L
.31383 .54529 L
.31721 .54554 L
.32077 .54588 L
.32406 .54627 L
.33147 .54739 L
.33795 .54866 L
.34477 .5503 L
.35736 .55418 L
.36886 .55874 L
.39185 .57123 L
.40288 .57912 L
.41373 .5884 L
.43109 .60744 L
.43938 .61919 L
.44598 .63047 L
.45191 .64287 L
.45642 .65472 L
.46006 .66718 L
.46158 .67385 L
.46287 .68097 L
.46374 .6873 L
.46412 .69086 L
.4644 .69413 L
.46459 .69716 L
Mistroke
.46468 .69888 L
.46474 .70048 L
.46477 .70127 L
.46479 .70201 L
.46481 .70269 L
.46482 .7034 L
.46483 .70418 L
.46484 .7049 L
.46484 .70567 L
.46484 .70651 L
.46484 .7074 L
.46483 .70822 L
.46482 .70865 L
.46482 .70912 L
.4648 .71007 L
.46474 .71181 L
.46468 .71344 L
.46451 .71647 L
.46427 .71973 L
.46393 .72332 L
.46348 .72708 L
.46246 .73377 L
.46122 .74013 L
.45962 .74686 L
.45601 .75876 L
.45068 .77221 L
.44456 .78441 L
.43012 .80608 L
.41114 .82626 L
.40046 .83501 L
.38985 .84234 L
.36715 .85429 L
.35428 .85916 L
.34222 .86263 L
.33612 .86401 L
.32958 .86521 L
.32616 .86573 L
.32236 .86622 L
.31916 .86657 L
.31564 .86687 L
.31232 .86708 L
.31051 .86717 L
.30883 .86723 L
.30801 .86725 L
.30724 .86727 L
.30654 .86728 L
.3058 .8673 L
.305 .86731 L
.30425 .86731 L
.30345 .86731 L
Mistroke
.30257 .86731 L
.30212 .8673 L
.30163 .8673 L
.30074 .86728 L
.29987 .86727 L
.29906 .86724 L
.29723 .86718 L
.29529 .86709 L
.29171 .86687 L
.28848 .86659 L
.28173 .86581 L
.27556 .86484 L
.26181 .86178 L
.24964 .85798 L
.23668 .85273 L
.2366 .85269 L
Mfstroke
.22631 .53709 m
.23989 .53151 L
.25463 .52681 L
.26199 .52496 L
.26994 .52331 L
.27873 .5219 L
.28301 .52137 L
.28697 .52097 L
.29083 .52067 L
.29493 .52043 L
.29705 .52034 L
.29905 .52028 L
.30019 .52026 L
.30123 .52024 L
.30181 .52023 L
.30244 .52023 L
.30303 .52022 L
.30358 .52022 L
.30457 .52022 L
.30513 .52023 L
.30564 .52023 L
.30658 .52025 L
.30758 .52026 L
.3093 .52031 L
.31119 .52037 L
.31322 .52047 L
.31539 .52059 L
.31929 .52088 L
.3234 .52127 L
.32719 .52172 L
.33574 .52301 L
.34321 .52447 L
.35108 .52637 L
.36561 .53084 L
.37887 .53611 L
.40539 .55051 L
.41811 .55961 L
.43063 .57032 L
.45065 .59228 L
.46022 .60584 L
.46783 .61885 L
.47467 .63316 L
.47988 .64682 L
.48408 .66119 L
.48582 .66889 L
.48731 .6771 L
.48832 .6844 L
.48876 .68852 L
.48908 .69228 L
.48931 .69578 L
Mistroke
.48941 .69777 L
.48948 .69961 L
.48951 .70052 L
.48953 .70138 L
.48955 .70216 L
.48957 .70298 L
.48958 .70388 L
.48959 .7047 L
.48959 .70559 L
.48959 .70657 L
.48959 .70759 L
.48958 .70854 L
.48957 .70903 L
.48956 .70957 L
.48954 .71067 L
.48948 .71268 L
.4894 .71456 L
.48921 .71805 L
.48893 .72182 L
.48854 .72595 L
.48802 .7303 L
.48684 .73802 L
.48541 .74535 L
.48356 .75311 L
.47941 .76684 L
.47325 .78236 L
.4662 .79643 L
.44953 .82143 L
.42764 .8447 L
.41533 .8548 L
.40308 .86325 L
.3769 .87704 L
.36206 .88266 L
.34814 .88666 L
.34111 .88825 L
.33356 .88964 L
.32961 .89024 L
.32523 .89081 L
.32153 .8912 L
.31748 .89155 L
.31365 .89179 L
.31156 .89189 L
.30962 .89197 L
.30868 .89199 L
.30779 .89201 L
.30699 .89203 L
.30613 .89204 L
.3052 .89205 L
.30434 .89206 L
.30342 .89206 L
Mistroke
.3024 .89206 L
.30188 .89205 L
.30131 .89205 L
.30028 .89203 L
.29928 .89201 L
.29835 .89198 L
.29624 .89191 L
.294 .89181 L
.28988 .89155 L
.28615 .89123 L
.27836 .89033 L
.27125 .88921 L
.25538 .88568 L
.24134 .8813 L
.22639 .87524 L
.22631 .8752 L
Mfstroke
.21442 .51112 m
.23009 .50469 L
.2471 .49927 L
.25559 .49713 L
.26476 .49523 L
.2749 .49361 L
.27984 .493 L
.28441 .49254 L
.28886 .49218 L
.29359 .49191 L
.29604 .49181 L
.29834 .49174 L
.29965 .49171 L
.30086 .49169 L
.30152 .49168 L
.30225 .49168 L
.30293 .49167 L
.30357 .49167 L
.30471 .49167 L
.30535 .49168 L
.30594 .49168 L
.30703 .4917 L
.30818 .49172 L
.31017 .49177 L
.31235 .49185 L
.31468 .49195 L
.31718 .4921 L
.32169 .49243 L
.32643 .49288 L
.3308 .49339 L
.34066 .49488 L
.34928 .49658 L
.35836 .49876 L
.37512 .50392 L
.39042 .51 L
.421 .52661 L
.43568 .53711 L
.45012 .54946 L
.47322 .5748 L
.48426 .59044 L
.49304 .60545 L
.50093 .62195 L
.50693 .63771 L
.51178 .65429 L
.51379 .66317 L
.51551 .67265 L
.51667 .68107 L
.51718 .68581 L
.51755 .69015 L
.51781 .69419 L
Mistroke
.51793 .69648 L
.51801 .6986 L
.51805 .69965 L
.51807 .70064 L
.5181 .70154 L
.51811 .70249 L
.51813 .70353 L
.51814 .70448 L
.51814 .70551 L
.51814 .70664 L
.51814 .70782 L
.51813 .70891 L
.51812 .70947 L
.51811 .7101 L
.51808 .71137 L
.51801 .71368 L
.51792 .71585 L
.5177 .71988 L
.51738 .72422 L
.51692 .729 L
.51633 .73401 L
.51497 .74291 L
.51332 .75137 L
.51119 .76032 L
.50639 .77616 L
.49929 .79406 L
.49116 .8103 L
.47193 .83913 L
.44667 .86598 L
.43247 .87763 L
.41835 .88738 L
.38814 .90328 L
.37102 .90976 L
.35497 .91439 L
.34685 .91622 L
.33815 .91782 L
.33359 .91851 L
.32854 .91916 L
.32427 .91962 L
.3196 .92002 L
.31518 .9203 L
.31278 .92042 L
.31053 .9205 L
.30945 .92053 L
.30842 .92056 L
.30749 .92058 L
.30651 .92059 L
.30543 .9206 L
.30444 .92061 L
.30338 .92061 L
Mistroke
.3022 .92061 L
.30161 .9206 L
.30095 .92059 L
.29976 .92058 L
.29861 .92055 L
.29753 .92052 L
.2951 .92044 L
.29251 .92032 L
.28776 .92002 L
.28346 .91966 L
.27448 .91861 L
.26627 .91732 L
.24796 .91325 L
.23177 .9082 L
.21452 .9012 L
.21442 .90116 L
Mfstroke
.20072 .48118 m
.21879 .47375 L
.23842 .4675 L
.2482 .46504 L
.25878 .46284 L
.27048 .46097 L
.27617 .46027 L
.28145 .45974 L
.28658 .45933 L
.29204 .45901 L
.29486 .45889 L
.29752 .45881 L
.29903 .45878 L
.30042 .45876 L
.30119 .45875 L
.30203 .45874 L
.30282 .45874 L
.30355 .45874 L
.30487 .45874 L
.30561 .45874 L
.30629 .45875 L
.30754 .45877 L
.30887 .45879 L
.31116 .45885 L
.31368 .45894 L
.31637 .45906 L
.31926 .45923 L
.32446 .45961 L
.32992 .46013 L
.33497 .46072 L
.34634 .46244 L
.35629 .4644 L
.36676 .46691 L
.38609 .47287 L
.40374 .47987 L
.43902 .49904 L
.45595 .51115 L
.47261 .5254 L
.49926 .55463 L
.51199 .57267 L
.52211 .58998 L
.53122 .60902 L
.53815 .6272 L
.54374 .64633 L
.54606 .65657 L
.54804 .6675 L
.54938 .67721 L
.54997 .68269 L
.55039 .6877 L
.5507 .69236 L
Mistroke
.55083 .695 L
.55093 .69745 L
.55097 .69866 L
.551 .6998 L
.55102 .70084 L
.55104 .70193 L
.55106 .70313 L
.55107 .70423 L
.55108 .70541 L
.55108 .70671 L
.55107 .70807 L
.55106 .70933 L
.55105 .70999 L
.55104 .71071 L
.55101 .71217 L
.55093 .71484 L
.55083 .71734 L
.55057 .72199 L
.5502 .727 L
.54967 .73251 L
.54898 .73828 L
.54742 .74856 L
.54551 .75832 L
.54306 .76864 L
.53752 .78691 L
.52933 .80757 L
.51995 .82629 L
.49777 .85956 L
.46863 .89053 L
.45225 .90396 L
.43596 .91521 L
.40111 .93355 L
.38136 .94103 L
.36285 .94637 L
.35348 .94848 L
.34345 .95033 L
.33819 .95113 L
.33236 .95188 L
.32744 .9524 L
.32204 .95286 L
.31695 .95319 L
.31417 .95332 L
.31158 .95342 L
.31033 .95346 L
.30915 .95349 L
.30808 .95351 L
.30694 .95352 L
.3057 .95354 L
.30456 .95354 L
.30333 .95355 L
Mistroke
.30198 .95354 L
.30129 .95353 L
.30053 .95353 L
.29916 .9535 L
.29783 .95348 L
.29659 .95344 L
.29378 .95335 L
.2908 .95321 L
.28531 .95286 L
.28035 .95244 L
.26999 .95124 L
.26052 .94975 L
.23941 .94505 L
.22072 .93923 L
.20083 .93116 L
.20072 .93111 L
Mfstroke
.18491 .44663 m
.20576 .43807 L
.22839 .43085 L
.23969 .42801 L
.25188 .42548 L
.26538 .42332 L
.27195 .42251 L
.27803 .4219 L
.28396 .42143 L
.29025 .42106 L
.29351 .42093 L
.29657 .42083 L
.29832 .42079 L
.29993 .42077 L
.30081 .42076 L
.30178 .42075 L
.30269 .42075 L
.30354 .42074 L
.30505 .42075 L
.30591 .42075 L
.30669 .42076 L
.30814 .42078 L
.30966 .42081 L
.31231 .42087 L
.31522 .42098 L
.31832 .42112 L
.32165 .42131 L
.32765 .42175 L
.33395 .42235 L
.33978 .42304 L
.35289 .42502 L
.36436 .42727 L
.37644 .43018 L
.39874 .43704 L
.4191 .44513 L
.45981 .46724 L
.47934 .48121 L
.49856 .49764 L
.52929 .53136 L
.54398 .55217 L
.55566 .57214 L
.56616 .59411 L
.57415 .61508 L
.58061 .63715 L
.58328 .64895 L
.58557 .66157 L
.58711 .67277 L
.58779 .67909 L
.58828 .68487 L
.58863 .69024 L
Mistroke
.58878 .69329 L
.5889 .69611 L
.58894 .69751 L
.58898 .69883 L
.58901 .70002 L
.58903 .70129 L
.58905 .70267 L
.58906 .70394 L
.58907 .7053 L
.58907 .7068 L
.58906 .70837 L
.58905 .70982 L
.58904 .71058 L
.58902 .71141 L
.58899 .7131 L
.5889 .71618 L
.58878 .71906 L
.58849 .72443 L
.58806 .7302 L
.58745 .73656 L
.58665 .74322 L
.58485 .75507 L
.58265 .76633 L
.57982 .77824 L
.57343 .79932 L
.56399 .82314 L
.55316 .84474 L
.52758 .88312 L
.49397 .91884 L
.47507 .93434 L
.45627 .94732 L
.41607 .96847 L
.39329 .9771 L
.37193 .98326 L
.36113 .9857 L
.34955 .98783 L
.34349 .98875 L
.33676 .98961 L
.33109 .99022 L
.32486 .99075 L
.31899 .99113 L
.31579 .99128 L
.3128 .99139 L
.31136 .99144 L
.31 .99147 L
.30876 .99149 L
.30744 .99151 L
.30602 .99153 L
.3047 .99154 L
.30328 .99154 L
Mistroke
.30172 .99153 L
.30092 .99153 L
.30005 .99152 L
.29847 .99149 L
.29693 .99146 L
.2955 .99142 L
.29226 .99131 L
.28882 .99115 L
.28249 .99075 L
.27677 .99027 L
.26482 .98888 L
.2539 .98716 L
.22954 .98174 L
.20799 .97502 L
.18504 .96571 L
.18491 .96565 L
Mfstroke
.16667 .40678 m
.19072 .3969 L
.21683 .38858 L
.22986 .3853 L
.24393 .38238 L
.2595 .37989 L
.26708 .37896 L
.27409 .37825 L
.28093 .3777 L
.28819 .37728 L
.29195 .37713 L
.29548 .37702 L
.2975 .37697 L
.29935 .37695 L
.30037 .37693 L
.30149 .37692 L
.30254 .37692 L
.30351 .37692 L
.30526 .37692 L
.30625 .37693 L
.30715 .37694 L
.30882 .37696 L
.31058 .37699 L
.31364 .37707 L
.31699 .37719 L
.32057 .37735 L
.32441 .37757 L
.33133 .37808 L
.3386 .37878 L
.34532 .37956 L
.36045 .38185 L
.37368 .38445 L
.38762 .3878 L
.41334 .39572 L
.43683 .40505 L
.48378 .43055 L
.50631 .44667 L
.52848 .46562 L
.56394 .50452 L
.58088 .52853 L
.59436 .55157 L
.60647 .5769 L
.61569 .6011 L
.62313 .62655 L
.62622 .64017 L
.62886 .65472 L
.63064 .66765 L
.63142 .67493 L
.63198 .6816 L
.63239 .6878 L
Mistroke
.63257 .69131 L
.6327 .69457 L
.63275 .69618 L
.63279 .6977 L
.63282 .69908 L
.63285 .70054 L
.63287 .70213 L
.63289 .7036 L
.6329 .70517 L
.6329 .7069 L
.63289 .70871 L
.63287 .71038 L
.63286 .71126 L
.63284 .71222 L
.6328 .71417 L
.6327 .71772 L
.63256 .72104 L
.63222 .72724 L
.63173 .7339 L
.63102 .74123 L
.63011 .74891 L
.62802 .76259 L
.62549 .77558 L
.62222 .78931 L
.61486 .81363 L
.60396 .84111 L
.59147 .86602 L
.56196 .91029 L
.52319 .9515 L
.50139 .96939 L
.47971 .98435 L
.43333 1.00876 L
.40706 1.01871 L
.38242 1.02581 L
.36996 1.02862 L
.3566 1.03108 L
.3496 1.03215 L
.34185 1.03315 L
.3353 1.03384 L
.32811 1.03446 L
.32134 1.03489 L
.31765 1.03507 L
.3142 1.0352 L
.31254 1.03525 L
.31097 1.03529 L
.30954 1.03531 L
.30802 1.03534 L
.30638 1.03535 L
.30485 1.03536 L
.30322 1.03537 L
Mistroke
.30142 1.03536 L
.3005 1.03535 L
.2995 1.03534 L
.29767 1.03531 L
.29589 1.03527 L
.29424 1.03523 L
.29051 1.0351 L
.28654 1.03492 L
.27924 1.03446 L
.27264 1.0339 L
.25886 1.0323 L
.24625 1.03032 L
.21815 1.02406 L
.19329 1.01631 L
.16682 1.00557 L
.16667 1.0055 L
Mfstroke
.14563 .36081 m
.17337 .34941 L
.2035 .33981 L
.21853 .33603 L
.23476 .33267 L
.25272 .32979 L
.26146 .32871 L
.26955 .3279 L
.27744 .32727 L
.28581 .32678 L
.29015 .3266 L
.29422 .32648 L
.29655 .32643 L
.29869 .32639 L
.29986 .32638 L
.30115 .32637 L
.30236 .32636 L
.30349 .32636 L
.30551 .32636 L
.30664 .32637 L
.30769 .32638 L
.30961 .32641 L
.31164 .32644 L
.31517 .32653 L
.31904 .32667 L
.32317 .32686 L
.3276 .32711 L
.33558 .3277 L
.34397 .3285 L
.35171 .32941 L
.36917 .33205 L
.38444 .33505 L
.40051 .33891 L
.43018 .34805 L
.45728 .35881 L
.51144 .38823 L
.53743 .40682 L
.56301 .42869 L
.60391 .47356 L
.62345 .50125 L
.63899 .52783 L
.65297 .55705 L
.66361 .58496 L
.67219 .61433 L
.67575 .63004 L
.6788 .64683 L
.68085 .66174 L
.68175 .67014 L
.6824 .67783 L
.68287 .68499 L
Mistroke
.68307 .68904 L
.68322 .69279 L
.68328 .69465 L
.68333 .69641 L
.68337 .698 L
.6834 .69968 L
.68343 .70152 L
.68345 .70321 L
.68345 .70502 L
.68346 .70702 L
.68345 .70911 L
.68343 .71104 L
.68341 .71204 L
.68339 .71315 L
.68334 .7154 L
.68322 .71949 L
.68307 .72333 L
.68268 .73048 L
.6821 .73816 L
.68129 .74661 L
.68024 .75548 L
.67783 .77126 L
.67491 .78624 L
.67114 .80208 L
.66265 .83013 L
.65008 .86183 L
.63567 .89058 L
.60162 .94164 L
.5569 .98918 L
.53175 1.00981 L
.50674 1.02708 L
.45324 1.05523 L
.42293 1.06671 L
.39451 1.0749 L
.38014 1.07815 L
.36473 1.08098 L
.35665 1.08221 L
.34771 1.08336 L
.34015 1.08417 L
.33187 1.08488 L
.32406 1.08538 L
.31979 1.08558 L
.31582 1.08573 L
.3139 1.08579 L
.31209 1.08583 L
.31044 1.08586 L
.30869 1.08589 L
.30679 1.08591 L
.30504 1.08592 L
.30315 1.08592 L
Mistroke
.30107 1.08591 L
.30001 1.08591 L
.29885 1.08589 L
.29675 1.08586 L
.2947 1.08582 L
.2928 1.08577 L
.28849 1.08562 L
.28391 1.08541 L
.27549 1.08488 L
.26787 1.08423 L
.25197 1.08239 L
.23743 1.0801 L
.20502 1.07289 L
.17634 1.06394 L
.1458 1.05155 L
.14563 1.05148 L
Mfstroke
.12136 .30778 m
.15336 .29463 L
.18811 .28355 L
.20545 .27919 L
.22417 .27531 L
.24489 .272 L
.25498 .27075 L
.26431 .26981 L
.27341 .26909 L
.28306 .26852 L
.28807 .26832 L
.29277 .26817 L
.29546 .26812 L
.29792 .26808 L
.29928 .26806 L
.30076 .26805 L
.30216 .26804 L
.30346 .26804 L
.30579 .26804 L
.3071 .26805 L
.30831 .26806 L
.31052 .26809 L
.31287 .26813 L
.31693 .26824 L
.32139 .2684 L
.32616 .26862 L
.33127 .26891 L
.34048 .26959 L
.35016 .27051 L
.35909 .27156 L
.37922 .2746 L
.39684 .27806 L
.41538 .28252 L
.44961 .29306 L
.48086 .30547 L
.54335 .33941 L
.57333 .36086 L
.60283 .38608 L
.65002 .43785 L
.67255 .46979 L
.69049 .50045 L
.70661 .53416 L
.71888 .56636 L
.72878 .60023 L
.73289 .61836 L
.7364 .63772 L
.73877 .65492 L
.7398 .66461 L
.74056 .67348 L
.7411 .68174 L
Mistroke
.74133 .68641 L
.74151 .69074 L
.74158 .69289 L
.74163 .69491 L
.74168 .69675 L
.74171 .69869 L
.74175 .70081 L
.74176 .70276 L
.74178 .70485 L
.74178 .70715 L
.74176 .70956 L
.74174 .71179 L
.74172 .71295 L
.7417 .71423 L
.74165 .71682 L
.74151 .72154 L
.74133 .72597 L
.74088 .73421 L
.74022 .74308 L
.73928 .75283 L
.73806 .76306 L
.73529 .78126 L
.73192 .79854 L
.72757 .81681 L
.71777 .84917 L
.70327 .88574 L
.68665 .9189 L
.64738 .97781 L
.59578 1.03265 L
.56678 1.05644 L
.53792 1.07636 L
.47621 1.10884 L
.44125 1.12208 L
.40846 1.13153 L
.39188 1.13527 L
.3741 1.13855 L
.36479 1.13996 L
.35447 1.14129 L
.34575 1.14222 L
.3362 1.14304 L
.32719 1.14361 L
.32227 1.14385 L
.31768 1.14402 L
.31547 1.14409 L
.31338 1.14414 L
.31148 1.14417 L
.30946 1.14421 L
.30727 1.14423 L
.30525 1.14424 L
.30307 1.14424 L
Mistroke
.30067 1.14423 L
.29945 1.14422 L
.29811 1.14421 L
.29568 1.14417 L
.29332 1.14412 L
.29113 1.14406 L
.28616 1.14389 L
.28087 1.14365 L
.27116 1.14304 L
.26237 1.14229 L
.24403 1.14017 L
.22726 1.13753 L
.18987 1.1292 L
.15679 1.11889 L
.12156 1.1046 L
.12136 1.10451 L
Mfstroke
.09336 .2466 m
.13028 .23144 L
.17037 .21866 L
.19037 .21363 L
.21197 .20915 L
.23586 .20533 L
.2475 .20389 L
.25827 .20281 L
.26876 .20197 L
.2799 .20132 L
.28568 .20108 L
.29109 .20092 L
.2942 .20085 L
.29704 .2008 L
.2986 .20079 L
.30031 .20077 L
.30193 .20076 L
.30343 .20076 L
.30611 .20077 L
.30763 .20078 L
.30902 .20079 L
.31158 .20082 L
.31428 .20087 L
.31897 .20099 L
.32412 .20117 L
.32961 .20143 L
.33551 .20176 L
.34613 .20255 L
.35729 .20361 L
.3676 .20482 L
.39082 .20833 L
.41114 .21232 L
.43253 .21746 L
.47202 .22962 L
.50807 .24394 L
.58015 .28309 L
.61474 .30784 L
.64877 .33693 L
.7032 .39665 L
.7292 .43349 L
.74989 .46886 L
.76849 .50775 L
.78264 .54489 L
.79406 .58396 L
.79881 .60487 L
.80285 .62721 L
.80559 .64705 L
.80678 .65823 L
.80765 .66847 L
.80827 .67799 L
Mistroke
.80854 .68338 L
.80874 .68838 L
.80882 .69086 L
.80889 .69319 L
.80894 .69531 L
.80898 .69754 L
.80902 .69999 L
.80904 .70224 L
.80905 .70465 L
.80905 .70731 L
.80904 .71009 L
.80901 .71265 L
.80899 .71399 L
.80897 .71547 L
.8089 .71846 L
.80874 .72391 L
.80854 .72901 L
.80802 .73852 L
.80726 .74875 L
.80618 .76 L
.80477 .7718 L
.80157 .79279 L
.79769 .81273 L
.79266 .83381 L
.78136 .87114 L
.76464 .91332 L
.74546 .95157 L
.70016 1.01953 L
.64064 1.08279 L
.60718 1.11024 L
.5739 1.13321 L
.50271 1.17068 L
.46237 1.18596 L
.42455 1.19685 L
.40542 1.20117 L
.38492 1.20495 L
.37417 1.20658 L
.36227 1.20811 L
.35222 1.20919 L
.34119 1.21013 L
.3308 1.21079 L
.32512 1.21107 L
.31983 1.21126 L
.31728 1.21134 L
.31487 1.2114 L
.31267 1.21144 L
.31035 1.21148 L
.30782 1.2115 L
.30549 1.21152 L
.30297 1.21152 L
Mistroke
.30021 1.21151 L
.2988 1.2115 L
.29726 1.21148 L
.29446 1.21144 L
.29173 1.21138 L
.2892 1.21131 L
.28347 1.21112 L
.27737 1.21084 L
.26617 1.21013 L
.25603 1.20927 L
.23487 1.20682 L
.21553 1.20378 L
.17239 1.19417 L
.13423 1.18227 L
.09359 1.16579 L
.09336 1.16568 L
Mfstroke
.06107 .17603 m
.10365 .15854 L
.1499 .1438 L
.17296 .13799 L
.19788 .13283 L
.22545 .12842 L
.23887 .12677 L
.25129 .12551 L
.2634 .12455 L
.27625 .1238 L
.28291 .12352 L
.28916 .12333 L
.29274 .12325 L
.29602 .1232 L
.29782 .12318 L
.2998 .12317 L
.30166 .12316 L
.30339 .12315 L
.30649 .12316 L
.30823 .12317 L
.30984 .12318 L
.31279 .12322 L
.31591 .12328 L
.32132 .12342 L
.32725 .12363 L
.3336 .12392 L
.3404 .12431 L
.35265 .12521 L
.36553 .12644 L
.37742 .12784 L
.40421 .13189 L
.42765 .13649 L
.45232 .14242 L
.49787 .15645 L
.53946 .17296 L
.62261 .21813 L
.66251 .24667 L
.70176 .28023 L
.76456 .34912 L
.79454 .39162 L
.81841 .43242 L
.83986 .47728 L
.85619 .52013 L
.86937 .5652 L
.87484 .58932 L
.87951 .61509 L
.88267 .63798 L
.88404 .65087 L
.88504 .66268 L
.88576 .67367 L
Mistroke
.88607 .67988 L
.8863 .68565 L
.8864 .68851 L
.88647 .6912 L
.88653 .69364 L
.88658 .69622 L
.88662 .69904 L
.88665 .70164 L
.88666 .70443 L
.88666 .70748 L
.88665 .71069 L
.88662 .71365 L
.88659 .7152 L
.88656 .71691 L
.88649 .72036 L
.8863 .72664 L
.88607 .73253 L
.88547 .7435 L
.88459 .75529 L
.88334 .76827 L
.88172 .78188 L
.87803 .8061 L
.87355 .8291 L
.86776 .85341 L
.85472 .89648 L
.83542 .94514 L
.8133 .98926 L
.76104 1.06765 L
.69239 1.14063 L
.65379 1.17229 L
.61539 1.1988 L
.53327 1.24202 L
.48674 1.25964 L
.44311 1.27221 L
.42105 1.27719 L
.39739 1.28155 L
.385 1.28343 L
.37127 1.2852 L
.35967 1.28643 L
.34695 1.28752 L
.33496 1.28829 L
.32841 1.28861 L
.32231 1.28883 L
.31937 1.28892 L
.31659 1.28899 L
.31406 1.28904 L
.31138 1.28908 L
.30846 1.28911 L
.30576 1.28913 L
.30287 1.28913 L
Mistroke
.29968 1.28912 L
.29805 1.2891 L
.29627 1.28908 L
.29304 1.28903 L
.28989 1.28897 L
.28698 1.28889 L
.28037 1.28866 L
.27333 1.28834 L
.2604 1.28752 L
.24871 1.28653 L
.22431 1.2837 L
.20199 1.28019 L
.15223 1.26912 L
.10821 1.25539 L
.06133 1.23637 L
.06107 1.23625 L
Mfstroke
.02381 .09462 m
.07294 .07445 L
.12628 .05744 L
.15289 .05075 L
.18164 .04479 L
.21344 .03971 L
.22892 .03779 L
.24325 .03635 L
.25721 .03523 L
.27204 .03437 L
.27973 .03405 L
.28693 .03383 L
.29106 .03374 L
.29484 .03368 L
.29693 .03366 L
.2992 .03364 L
.30135 .03363 L
.30335 .03363 L
.30692 .03363 L
.30893 .03365 L
.31078 .03366 L
.31419 .03371 L
.31779 .03377 L
.32403 .03393 L
.33087 .03418 L
.33819 .03451 L
.34603 .03496 L
.36017 .036 L
.37503 .03742 L
.38874 .03903 L
.41965 .0437 L
.44669 .04901 L
.47515 .05585 L
.52769 .07203 L
.57567 .09108 L
.67159 .14319 L
.71761 .17611 L
.7629 .21482 L
.83533 .29429 L
.86992 .34332 L
.89746 .39039 L
.9222 .44214 L
.94104 .49156 L
.95624 .54356 L
.96255 .57138 L
.96794 .60111 L
.97158 .62751 L
.97316 .64239 L
.97432 .65601 L
.97515 .66868 L
Mistroke
.97551 .67585 L
.97577 .6825 L
.97588 .6858 L
.97597 .6889 L
.97604 .69172 L
.97609 .6947 L
.97614 .69795 L
.97617 .70094 L
.97619 .70416 L
.97619 .70769 L
.97617 .71139 L
.97613 .71481 L
.97611 .71659 L
.97608 .71856 L
.97599 .72254 L
.97577 .72979 L
.9755 .73658 L
.97481 .74923 L
.9738 .76284 L
.97236 .77781 L
.97049 .79352 L
.96623 .82145 L
.96106 .84798 L
.95438 .87603 L
.93934 .92571 L
.91708 .98184 L
.89156 1.03274 L
.83128 1.12317 L
.75208 1.20735 L
.70755 1.24388 L
.66326 1.27445 L
.56853 1.32431 L
.51486 1.34464 L
.46452 1.35914 L
.43907 1.36489 L
.41179 1.36991 L
.39749 1.37208 L
.38165 1.37412 L
.36827 1.37555 L
.3536 1.3768 L
.33977 1.37769 L
.33221 1.37805 L
.32518 1.37831 L
.32178 1.37841 L
.31857 1.37849 L
.31565 1.37855 L
.31256 1.3786 L
.30919 1.37863 L
.30609 1.37865 L
.30274 1.37866 L
Mistroke
.29906 1.37864 L
.29719 1.37863 L
.29514 1.3786 L
.29141 1.37855 L
.28778 1.37847 L
.28441 1.37838 L
.27679 1.37812 L
.26867 1.37775 L
.25376 1.3768 L
.24027 1.37566 L
.21212 1.3724 L
.18638 1.36835 L
.12898 1.35557 L
.07819 1.33973 L
.02411 1.3178 L
.02381 1.31766 L
Mfstroke
.2658 .62338 m
.2626 .61639 L
.2588 .60808 L
.25491 .59959 L
.25085 .59072 L
.24616 .58047 L
.24125 .56975 L
.23558 .55735 L
.22962 .54433 L
.2234 .53074 L
.21621 .51502 L
.20867 .49856 L
.20082 .48139 L
.19173 .46155 L
.18224 .4408 L
.17126 .4168 L
.15974 .39164 L
.14772 .36538 L
.13383 .33501 L
.11928 .30323 L
.10245 .26646 L
.08479 .22787 L
.06633 .18754 L
.04499 .14091 L
.02381 .09462 L
s
.29066 .61606 m
.28956 .60845 L
.28825 .59941 L
.28692 .59016 L
.28552 .58051 L
.28391 .56936 L
.28223 .55769 L
.28028 .54419 L
.27823 .53002 L
.27609 .51522 L
.27362 .49812 L
.27103 .48019 L
.26833 .46151 L
.26521 .43991 L
.26195 .41733 L
.25817 .39121 L
.25422 .36382 L
.25009 .33524 L
.24531 .30219 L
.24031 .26759 L
.23453 .22758 L
.22846 .18557 L
.22212 .14167 L
.21478 .09091 L
.20751 .04054 L
s
.31658 .61605 m
.31767 .60843 L
.31896 .59939 L
.32029 .59014 L
.32167 .58049 L
.32326 .56933 L
.32494 .55766 L
.32687 .54416 L
.3289 .52999 L
.33102 .51519 L
.33347 .49808 L
.33603 .48015 L
.33871 .46147 L
.3418 .43986 L
.34504 .41728 L
.34878 .39115 L
.3527 .36376 L
.35679 .33517 L
.36153 .30211 L
.36648 .26751 L
.37221 .22749 L
.37823 .18547 L
.38452 .14157 L
.39179 .0908 L
.399 .04042 L
s
.34145 .62333 m
.34464 .61634 L
.34843 .60803 L
.35231 .59952 L
.35635 .59065 L
.36103 .5804 L
.36592 .56967 L
.37158 .55726 L
.37752 .54424 L
.38373 .53064 L
.3909 .51491 L
.39842 .49844 L
.40625 .48126 L
.41531 .4614 L
.42478 .44064 L
.43573 .41664 L
.44721 .39146 L
.4592 .36518 L
.47305 .3348 L
.48756 .303 L
.50434 .26621 L
.52195 .22759 L
.54036 .18724 L
.56164 .14058 L
.58277 .09427 L
s
.36325 .63734 m
.36829 .63152 L
.37427 .62462 L
.38038 .61755 L
.38677 .61018 L
.39414 .60166 L
.40186 .59275 L
.41079 .58244 L
.42016 .57162 L
.42995 .56031 L
.44126 .54725 L
.45312 .53356 L
.46547 .51929 L
.47976 .50279 L
.49469 .48554 L
.51197 .46559 L
.53008 .44467 L
.54899 .42284 L
.57085 .39759 L
.59373 .37117 L
.6202 .3406 L
.64798 .30851 L
.67701 .27498 L
.71059 .23621 L
.7439 .19774 L
s
.38023 .65692 m
.3867 .65276 L
.39438 .64782 L
.40224 .64276 L
.41044 .63749 L
.41992 .6314 L
.42984 .62502 L
.44131 .61764 L
.45335 .6099 L
.46593 .60181 L
.48047 .59247 L
.4957 .58267 L
.51158 .57246 L
.52993 .56066 L
.54913 .54832 L
.57132 .53405 L
.5946 .51908 L
.61889 .50346 L
.64698 .4854 L
.67638 .4665 L
.71039 .44463 L
.74609 .42167 L
.7834 .39769 L
.82654 .36995 L
.86935 .34242 L
s
.391 .68049 m
.39838 .67832 L
.40714 .67575 L
.41611 .67311 L
.42546 .67037 L
.43628 .66719 L
.44759 .66387 L
.46068 .66002 L
.47441 .65599 L
.48876 .65177 L
.50534 .6469 L
.52271 .6418 L
.54083 .63648 L
.56176 .63033 L
.58366 .6239 L
.60898 .61646 L
.63553 .60866 L
.66324 .60052 L
.69528 .59111 L
.72881 .58126 L
.76761 .56986 L
.80833 .5579 L
.85089 .5454 L
.90009 .53094 L
.94893 .5166 L
s
.39469 .70614 m
.40238 .70614 L
.41151 .70614 L
.42086 .70614 L
.43061 .70614 L
.44188 .70614 L
.45367 .70614 L
.46731 .70614 L
.48163 .70614 L
.49658 .70614 L
.51386 .70614 L
.53197 .70614 L
.55085 .70614 L
.57267 .70614 L
.59549 .70614 L
.62187 .70614 L
.64955 .70614 L
.67843 .70614 L
.71182 .70614 L
.74678 .70614 L
.78721 .70614 L
.82965 .70614 L
.87401 .70614 L
.92529 .70614 L
.97619 .70614 L
s
.391 .73179 m
.39838 .73396 L
.40714 .73654 L
.41611 .73917 L
.42546 .74192 L
.43628 .74509 L
.44759 .74842 L
.46068 .75226 L
.47441 .7563 L
.48876 .76051 L
.50534 .76538 L
.52271 .77048 L
.54083 .77581 L
.56176 .78196 L
.58366 .78839 L
.60898 .79582 L
.63553 .80362 L
.66324 .81176 L
.69528 .82117 L
.72881 .83103 L
.76761 .84242 L
.80833 .85439 L
.85089 .86689 L
.90009 .88134 L
.94893 .89569 L
s
.38023 .75537 m
.3867 .75953 L
.39438 .76446 L
.40224 .76952 L
.41044 .77479 L
.41992 .78089 L
.42984 .78726 L
.44131 .79464 L
.45335 .80238 L
.46593 .81047 L
.48047 .81982 L
.4957 .82961 L
.51158 .83982 L
.52993 .85162 L
.54913 .86396 L
.57132 .87823 L
.5946 .8932 L
.61889 .90882 L
.64698 .92688 L
.67638 .94579 L
.71039 .96765 L
.74609 .99061 L
.7834 1.0146 L
.82654 1.04233 L
.86935 1.06986 L
s
.36325 .77495 m
.36829 .78076 L
.37427 .78767 L
.38038 .79473 L
.38677 .8021 L
.39414 .81062 L
.40186 .81954 L
.41079 .82985 L
.42016 .84067 L
.42995 .85197 L
.44126 .86504 L
.45312 .87873 L
.46547 .893 L
.47976 .90949 L
.49469 .92674 L
.51197 .94669 L
.53008 .96761 L
.54899 .98945 L
.57085 1.01469 L
.59373 1.04112 L
.6202 1.07168 L
.64798 1.10377 L
.67701 1.1373 L
.71059 1.17607 L
.7439 1.21455 L
s
.34145 .78895 m
.34464 .79595 L
.34843 .80426 L
.35231 .81276 L
.35635 .82163 L
.36103 .83188 L
.36592 .84261 L
.37158 .85502 L
.37752 .86804 L
.38373 .88165 L
.3909 .89737 L
.39842 .91385 L
.40625 .93102 L
.41531 .95088 L
.42478 .97164 L
.43573 .99565 L
.44721 1.02082 L
.4592 1.0471 L
.47305 1.07748 L
.48756 1.10929 L
.50434 1.14607 L
.52195 1.18469 L
.54036 1.22504 L
.56164 1.2717 L
.58277 1.31801 L
s
.31658 .79624 m
.31767 .80385 L
.31896 .81289 L
.32029 .82214 L
.32167 .83179 L
.32326 .84295 L
.32494 .85462 L
.32687 .86813 L
.3289 .88229 L
.33102 .89709 L
.33347 .91421 L
.33603 .93213 L
.33871 .95082 L
.3418 .97242 L
.34504 .99501 L
.34878 1.02113 L
.3527 1.04852 L
.35679 1.07711 L
.36153 1.11017 L
.36648 1.14477 L
.37221 1.18479 L
.37823 1.22681 L
.38452 1.27072 L
.39179 1.32148 L
.399 1.37187 L
s
.29066 .79622 m
.28956 .80383 L
.28825 .81287 L
.28692 .82212 L
.28552 .83177 L
.28391 .84293 L
.28223 .8546 L
.28028 .8681 L
.27823 .88226 L
.27609 .89706 L
.27362 .91417 L
.27103 .93209 L
.26833 .95077 L
.26521 .97237 L
.26195 .99495 L
.25817 1.02107 L
.25422 1.04846 L
.25009 1.07705 L
.24531 1.11009 L
.24031 1.14469 L
.23453 1.18471 L
.22846 1.22672 L
.22212 1.27061 L
.21478 1.32137 L
.20751 1.37175 L
s
.2658 .7889 m
.2626 .7959 L
.2588 .8042 L
.25491 .8127 L
.25085 .82156 L
.24616 .83181 L
.24125 .84253 L
.23558 .85494 L
.22962 .86795 L
.2234 .88155 L
.21621 .89726 L
.20867 .91373 L
.20082 .93089 L
.19173 .95074 L
.18224 .97149 L
.17126 .99548 L
.15974 1.02064 L
.14772 1.04691 L
.13383 1.07727 L
.11928 1.10905 L
.10245 1.14582 L
.08479 1.18441 L
.06633 1.22474 L
.04499 1.27138 L
.02381 1.31766 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.29.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.29.1"]
}, Open  ]],

Cell[TextData[{
 "The square root function halves the angle of each complex number. The \
starting point is moved slightly from ",
 StyleBox["-Pi", "MR"],
 " to avoid problems with the branch cut of the square root function. "
}], "MathCaption",
 CellTags->{"S5.29.1", "1.9"}],

Cell[CellGroupData[{

Cell["PolarMap[Sqrt, { 0, 1}, { -Pi + 0.0001, Pi}]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.29.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 2 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 1 0.952381 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -9 -9 ]
[.21429 -0.0125 9 0 ]
[.40476 -0.0125 -9 -9 ]
[.40476 -0.0125 9 0 ]
[.59524 -0.0125 -9 -9 ]
[.59524 -0.0125 9 0 ]
[.78571 -0.0125 -9 -9 ]
[.78571 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .04762 -12 -4.5 ]
[-0.0125 .04762 0 4.5 ]
[-0.0125 .52381 -24 -4.5 ]
[-0.0125 .52381 0 4.5 ]
[-0.0125 1 -6 -4.5 ]
[-0.0125 1 0 4.5 ]
[-0.0125 1.47619 -18 -4.5 ]
[-0.0125 1.47619 0 4.5 ]
[-0.0125 1.95238 -6 -4.5 ]
[-0.0125 1.95238 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 2 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 2 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(0.2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(0.4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(0.6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(0.8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .04762 m
.00625 .04762 L
s
[(-1)] -0.0125 .04762 1 0 Mshowa
0 .52381 m
.00625 .52381 L
s
[(-0.5)] -0.0125 .52381 1 0 Mshowa
0 1 m
.00625 1 L
s
[(0)] -0.0125 1 1 0 Mshowa
0 1.47619 m
.00625 1.47619 L
s
[(0.5)] -0.0125 1.47619 1 0 Mshowa
0 1.95238 m
.00625 1.95238 L
s
[(1)] -0.0125 1.95238 1 0 Mshowa
.125 Mabswid
0 .14286 m
.00375 .14286 L
s
0 .2381 m
.00375 .2381 L
s
0 .33333 m
.00375 .33333 L
s
0 .42857 m
.00375 .42857 L
s
0 .61905 m
.00375 .61905 L
s
0 .71429 m
.00375 .71429 L
s
0 .80952 m
.00375 .80952 L
s
0 .90476 m
.00375 .90476 L
s
0 1.09524 m
.00375 1.09524 L
s
0 1.19048 m
.00375 1.19048 L
s
0 1.28571 m
.00375 1.28571 L
s
0 1.38095 m
.00375 1.38095 L
s
0 1.57143 m
.00375 1.57143 L
s
0 1.66667 m
.00375 1.66667 L
s
0 1.7619 m
.00375 1.7619 L
s
0 1.85714 m
.00375 1.85714 L
s
.25 Mabswid
0 0 m
0 2 L
s
.02381 1.99375 m
.02381 2 L
s
.21429 1.99375 m
.21429 2 L
s
.40476 1.99375 m
.40476 2 L
s
.59524 1.99375 m
.59524 2 L
s
.78571 1.99375 m
.78571 2 L
s
.97619 1.99375 m
.97619 2 L
s
.125 Mabswid
.07143 1.99625 m
.07143 2 L
s
.11905 1.99625 m
.11905 2 L
s
.16667 1.99625 m
.16667 2 L
s
.2619 1.99625 m
.2619 2 L
s
.30952 1.99625 m
.30952 2 L
s
.35714 1.99625 m
.35714 2 L
s
.45238 1.99625 m
.45238 2 L
s
.5 1.99625 m
.5 2 L
s
.54762 1.99625 m
.54762 2 L
s
.64286 1.99625 m
.64286 2 L
s
.69048 1.99625 m
.69048 2 L
s
.7381 1.99625 m
.7381 2 L
s
.83333 1.99625 m
.83333 2 L
s
.88095 1.99625 m
.88095 2 L
s
.92857 1.99625 m
.92857 2 L
s
.25 Mabswid
0 2 m
1 2 L
s
.99375 .04762 m
1 .04762 L
s
.99375 .52381 m
1 .52381 L
s
.99375 1 m
1 1 L
s
.99375 1.47619 m
1 1.47619 L
s
.99375 1.95238 m
1 1.95238 L
s
.125 Mabswid
.99625 .14286 m
1 .14286 L
s
.99625 .2381 m
1 .2381 L
s
.99625 .33333 m
1 .33333 L
s
.99625 .42857 m
1 .42857 L
s
.99625 .61905 m
1 .61905 L
s
.99625 .71429 m
1 .71429 L
s
.99625 .80952 m
1 .80952 L
s
.99625 .90476 m
1 .90476 L
s
.99625 1.09524 m
1 1.09524 L
s
.99625 1.19048 m
1 1.19048 L
s
.99625 1.28571 m
1 1.28571 L
s
.99625 1.38095 m
1 1.38095 L
s
.99625 1.57143 m
1 1.57143 L
s
.99625 1.66667 m
1 1.66667 L
s
.99625 1.7619 m
1 1.7619 L
s
.99625 1.85714 m
1 1.85714 L
s
.25 Mabswid
1 0 m
1 2 L
s
0 1 m
1 1 L
s
.02381 0 m
.02381 2 L
s
0 0 m
1 0 L
1 2 L
0 2 L
closepath
clip
newpath
.5 Mabswid
.02381 1 m
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
.02381 1 L
Mistroke
.02381 1 L
Mfstroke
.02382 .74547 m
.02481 .74547 L
.02571 .74547 L
.02674 .74548 L
.02772 .7455 L
.02947 .74553 L
.03136 .74558 L
.03344 .74565 L
.03565 .74574 L
.0396 .74596 L
.04368 .74624 L
.0475 .74657 L
.05617 .74753 L
.06498 .74882 L
.07299 .75026 L
.09084 .75445 L
.10607 .75913 L
.12234 .76531 L
.15282 .78058 L
.17999 .79902 L
.20601 .82226 L
.22784 .84782 L
.24549 .87492 L
.25309 .88947 L
.26033 .90596 L
.26619 .92228 L
.27055 .93748 L
.27406 .95347 L
.27555 .96237 L
.27667 .97083 L
.27747 .9789 L
.27777 .98298 L
.27804 .98749 L
.2782 .99133 L
.27826 .99348 L
.27828 .99451 L
.2783 .99546 L
.27832 .99638 L
.27833 .9972 L
.27834 .99813 L
.27834 .99911 L
.27834 1.00006 L
.27834 1.00109 L
.27834 1.00206 L
.27833 1.00295 L
.27831 1.004 L
.27829 1.005 L
.27825 1.00687 L
.27819 1.00889 L
.2781 1.01109 L
Mistroke
.2779 1.01503 L
.27766 1.01869 L
.2769 1.02705 L
.2758 1.03591 L
.27443 1.04446 L
.27263 1.05364 L
.26851 1.07007 L
.26336 1.08604 L
.25681 1.10247 L
.24216 1.13081 L
.2228 1.15872 L
.20082 1.18291 L
.17426 1.20531 L
.14602 1.22328 L
.11685 1.23692 L
.10117 1.24249 L
.08419 1.24727 L
.07649 1.24902 L
.06816 1.25064 L
.06091 1.25182 L
.05296 1.25286 L
.04562 1.2536 L
.03878 1.25409 L
.03498 1.25429 L
.03154 1.25442 L
.02963 1.25447 L
.02862 1.25449 L
.02756 1.25451 L
.02663 1.25452 L
.02561 1.25453 L
.02468 1.25453 L
.02381 1.25453 L
Mfstroke
.02383 .64003 m
.02522 .64004 L
.02649 .64004 L
.02796 .64006 L
.02935 .64008 L
.03181 .64012 L
.03448 .64019 L
.03743 .64029 L
.04055 .64042 L
.04615 .64073 L
.05192 .64113 L
.05731 .6416 L
.06958 .64296 L
.08203 .64477 L
.09337 .64682 L
.1186 .65274 L
.14015 .65935 L
.16315 .66809 L
.20626 .6897 L
.24468 .71576 L
.28147 .74864 L
.31235 .78478 L
.33732 .82311 L
.34806 .84368 L
.35831 .867 L
.36658 .89008 L
.37275 .91158 L
.37771 .9342 L
.37982 .94678 L
.3814 .95875 L
.38254 .97016 L
.38297 .97593 L
.38334 .98231 L
.38357 .98773 L
.38366 .99078 L
.38369 .99223 L
.38372 .99358 L
.38374 .99487 L
.38375 .99605 L
.38377 .99735 L
.38377 .99874 L
.38378 1.00008 L
.38377 1.00154 L
.38376 1.00291 L
.38375 1.00417 L
.38373 1.00566 L
.38371 1.00707 L
.38364 1.00972 L
.38356 1.01257 L
.38343 1.01568 L
Mistroke
.38315 1.02126 L
.3828 1.02643 L
.38174 1.03825 L
.38017 1.05079 L
.37824 1.06288 L
.37569 1.07586 L
.36987 1.0991 L
.36259 1.12167 L
.35332 1.14491 L
.3326 1.185 L
.30522 1.22446 L
.27414 1.25867 L
.23658 1.29035 L
.19664 1.31576 L
.15538 1.33506 L
.13322 1.34294 L
.10919 1.34969 L
.09832 1.35217 L
.08653 1.35446 L
.07628 1.35612 L
.06504 1.3576 L
.05465 1.35864 L
.04498 1.35934 L
.03961 1.35962 L
.03474 1.3598 L
.03204 1.35987 L
.03062 1.3599 L
.02911 1.35993 L
.0278 1.35994 L
.02635 1.35996 L
.02504 1.35996 L
.02381 1.35997 L
Mfstroke
.02383 .55913 m
.02554 .55914 L
.0271 .55915 L
.02889 .55916 L
.03059 .55919 L
.03361 .55924 L
.03688 .55933 L
.04049 .55945 L
.04431 .55961 L
.05117 .55998 L
.05823 .56048 L
.06484 .56105 L
.07986 .56271 L
.09512 .56494 L
.109 .56744 L
.13991 .57469 L
.1663 .58279 L
.19446 .5935 L
.24727 .61996 L
.29433 .65188 L
.33938 .69214 L
.3772 .73641 L
.40778 .78336 L
.42094 .80855 L
.43348 .83711 L
.44362 .86538 L
.45117 .8917 L
.45725 .91941 L
.45983 .93481 L
.46177 .94948 L
.46316 .96345 L
.46369 .97052 L
.46414 .97833 L
.46442 .98498 L
.46453 .98871 L
.46457 .99049 L
.46461 .99214 L
.46463 .99372 L
.46465 .99516 L
.46466 .99675 L
.46467 .99846 L
.46468 1.0001 L
.46467 1.00188 L
.46466 1.00356 L
.46465 1.00511 L
.46462 1.00693 L
.46459 1.00866 L
.46452 1.01191 L
.46441 1.0154 L
.46426 1.0192 L
Mistroke
.46391 1.02604 L
.46349 1.03237 L
.46218 1.04685 L
.46027 1.06221 L
.4579 1.07701 L
.45478 1.09291 L
.44764 1.12137 L
.43873 1.14902 L
.42737 1.17748 L
.402 1.22657 L
.36847 1.2749 L
.3304 1.31681 L
.2844 1.35561 L
.23548 1.38673 L
.18495 1.41036 L
.15781 1.42001 L
.12838 1.42828 L
.11506 1.43132 L
.10062 1.43412 L
.08808 1.43616 L
.07431 1.43797 L
.06158 1.43925 L
.04973 1.4401 L
.04316 1.44044 L
.0372 1.44066 L
.03389 1.44075 L
.03215 1.44079 L
.03031 1.44082 L
.02869 1.44084 L
.02692 1.44086 L
.02531 1.44086 L
.02381 1.44087 L
Mfstroke
.02384 .49093 m
.02581 .49093 L
.02761 .49095 L
.02968 .49096 L
.03164 .49099 L
.03512 .49106 L
.03891 .49115 L
.04307 .4913 L
.04748 .49148 L
.0554 .49191 L
.06356 .49249 L
.07119 .49314 L
.08854 .49506 L
.10615 .49763 L
.12218 .50053 L
.15787 .5089 L
.18834 .51825 L
.22086 .53062 L
.28184 .56117 L
.33617 .59803 L
.3882 .64452 L
.43187 .69564 L
.46718 .74985 L
.48237 .77893 L
.49686 .81191 L
.50857 .84456 L
.51728 .87495 L
.5243 .90694 L
.52728 .92473 L
.52953 .94167 L
.53113 .9578 L
.53174 .96596 L
.53226 .97498 L
.53258 .98265 L
.53271 .98697 L
.53276 .98902 L
.5328 .99093 L
.53283 .99275 L
.53285 .99441 L
.53286 .99625 L
.53288 .99822 L
.53288 1.00012 L
.53287 1.00217 L
.53286 1.00411 L
.53284 1.0059 L
.53282 1.00801 L
.53278 1.01 L
.53269 1.01375 L
.53257 1.01778 L
.5324 1.02217 L
Mistroke
.53199 1.03007 L
.5315 1.03738 L
.53 1.05409 L
.52779 1.07183 L
.52505 1.08893 L
.52145 1.10728 L
.51321 1.14015 L
.50292 1.17207 L
.4898 1.20494 L
.46051 1.26163 L
.42179 1.31743 L
.37783 1.36582 L
.32471 1.41062 L
.26822 1.44656 L
.20988 1.47384 L
.17854 1.48499 L
.14456 1.49454 L
.12918 1.49804 L
.11251 1.50128 L
.09802 1.50363 L
.08212 1.50572 L
.06743 1.5072 L
.05374 1.50819 L
.04616 1.50858 L
.03927 1.50883 L
.03545 1.50894 L
.03344 1.50898 L
.03131 1.50901 L
.02945 1.50904 L
.02741 1.50906 L
.02555 1.50907 L
.02381 1.50907 L
Mfstroke
.02384 .43084 m
.02605 .43085 L
.02805 .43086 L
.03037 .43088 L
.03256 .43091 L
.03646 .43098 L
.04069 .43109 L
.04534 .43125 L
.05028 .43146 L
.05913 .43194 L
.06825 .43258 L
.07679 .43331 L
.09618 .43546 L
.11587 .43834 L
.13379 .44157 L
.17369 .45093 L
.20776 .46139 L
.24412 .47521 L
.31229 .50937 L
.37304 .55058 L
.43121 .60256 L
.48004 .65971 L
.51951 .72032 L
.5365 .75284 L
.55269 .78971 L
.56578 .82621 L
.57553 .86019 L
.58338 .89596 L
.58671 .91585 L
.58922 .93478 L
.59101 .95282 L
.59169 .96194 L
.59228 .97203 L
.59264 .9806 L
.59278 .98543 L
.59283 .98772 L
.59288 .98985 L
.59291 .9919 L
.59293 .99375 L
.59295 .99581 L
.59296 .99801 L
.59297 1.00013 L
.59296 1.00243 L
.59295 1.0046 L
.59293 1.0066 L
.5929 1.00895 L
.59286 1.01118 L
.59276 1.01537 L
.59262 1.01988 L
.59243 1.02479 L
Mistroke
.59197 1.03361 L
.59143 1.04179 L
.58974 1.06048 L
.58727 1.08031 L
.58421 1.09942 L
.58018 1.11994 L
.57097 1.15669 L
.55947 1.19238 L
.54481 1.22913 L
.51205 1.29251 L
.46877 1.3549 L
.41961 1.409 L
.36023 1.45909 L
.29707 1.49927 L
.23184 1.52977 L
.1968 1.54223 L
.15882 1.55291 L
.14162 1.55683 L
.12298 1.56045 L
.10678 1.56308 L
.089 1.56541 L
.07257 1.56706 L
.05728 1.56817 L
.04879 1.56861 L
.04109 1.56889 L
.03682 1.56901 L
.03457 1.56905 L
.0322 1.56909 L
.03012 1.56912 L
.02783 1.56914 L
.02575 1.56915 L
.02381 1.56916 L
Mfstroke
.02384 .37652 m
.02626 .37653 L
.02846 .37654 L
.031 .37656 L
.0334 .37659 L
.03767 .37667 L
.0423 .37679 L
.0474 .37697 L
.0528 .37719 L
.0625 .37772 L
.07249 .37842 L
.08184 .37923 L
.10308 .38158 L
.12465 .38473 L
.14428 .38827 L
.188 .39853 L
.22532 .40998 L
.26515 .42512 L
.33983 .46254 L
.40638 .50769 L
.4701 .56462 L
.52358 .62723 L
.56682 .69362 L
.58543 .72925 L
.60317 .76964 L
.61751 .80962 L
.62819 .84685 L
.63678 .88603 L
.64044 .90781 L
.64318 .92856 L
.64514 .94831 L
.64589 .95831 L
.64654 .96936 L
.64693 .97875 L
.64708 .98404 L
.64714 .98655 L
.64719 .98889 L
.64723 .99112 L
.64725 .99315 L
.64727 .99541 L
.64729 .99782 L
.64729 1.00014 L
.64728 1.00266 L
.64727 1.00504 L
.64725 1.00723 L
.64721 1.00981 L
.64717 1.01225 L
.64706 1.01684 L
.64691 1.02178 L
.6467 1.02716 L
Mistroke
.6462 1.03682 L
.64561 1.04578 L
.64376 1.06625 L
.64105 1.08797 L
.6377 1.10891 L
.63329 1.13139 L
.6232 1.17165 L
.61059 1.21074 L
.59453 1.251 L
.55865 1.32042 L
.51124 1.38877 L
.45739 1.44804 L
.39234 1.50291 L
.32315 1.54692 L
.2517 1.58034 L
.21331 1.59398 L
.1717 1.60569 L
.15286 1.60998 L
.13244 1.61394 L
.11469 1.61682 L
.09522 1.61938 L
.07723 1.62119 L
.06047 1.6224 L
.05118 1.62288 L
.04274 1.62319 L
.03806 1.62332 L
.0356 1.62337 L
.033 1.62341 L
.03072 1.62344 L
.02821 1.62346 L
.02594 1.62348 L
.02381 1.62348 L
Mfstroke
.02384 .32656 m
.02645 .32657 L
.02883 .32658 L
.03157 .32661 L
.03417 .32664 L
.03878 .32673 L
.04378 .32686 L
.04929 .32705 L
.05513 .32729 L
.0656 .32786 L
.07639 .32862 L
.08649 .32949 L
.10944 .33203 L
.13274 .33543 L
.15394 .33926 L
.20115 .35033 L
.24146 .36271 L
.28448 .37906 L
.36515 .41948 L
.43703 .46824 L
.50586 .52974 L
.56362 .59737 L
.61033 .66908 L
.63043 .70756 L
.64959 .75119 L
.66508 .79437 L
.67661 .83457 L
.6859 .8769 L
.68984 .90043 L
.69281 .92283 L
.69493 .94417 L
.69574 .95497 L
.69643 .9669 L
.69685 .97705 L
.69702 .98276 L
.69709 .98547 L
.69714 .988 L
.69718 .99041 L
.6972 .9926 L
.69723 .99504 L
.69724 .99765 L
.69724 1.00015 L
.69724 1.00287 L
.69722 1.00544 L
.6972 1.00781 L
.69716 1.01059 L
.69711 1.01323 L
.697 1.01819 L
.69683 1.02352 L
.69661 1.02933 L
Mistroke
.69607 1.03977 L
.69543 1.04944 L
.69343 1.07156 L
.69051 1.09502 L
.68689 1.11764 L
.68212 1.14192 L
.67122 1.1854 L
.65761 1.22763 L
.64026 1.27111 L
.6015 1.3461 L
.55029 1.41992 L
.49213 1.48393 L
.42186 1.5432 L
.34714 1.59074 L
.26996 1.62684 L
.22849 1.64158 L
.18355 1.65422 L
.1632 1.65885 L
.14115 1.66313 L
.12198 1.66624 L
.10094 1.669 L
.08151 1.67096 L
.06341 1.67227 L
.05337 1.67279 L
.04426 1.67312 L
.03921 1.67326 L
.03655 1.67331 L
.03373 1.67336 L
.03127 1.67339 L
.02857 1.67342 L
.02611 1.67343 L
.02381 1.67344 L
Mfstroke
.02385 .28007 m
.02664 .28007 L
.02918 .28009 L
.03211 .28012 L
.03488 .28015 L
.03981 .28025 L
.04516 .28038 L
.05105 .28058 L
.05729 .28085 L
.06848 .28145 L
.08002 .28227 L
.09082 .28319 L
.11535 .28591 L
.14026 .28955 L
.16292 .29364 L
.21339 .30548 L
.25649 .31871 L
.30248 .33619 L
.38871 .3794 L
.46556 .43153 L
.53914 .49727 L
.6009 .56957 L
.65082 .64623 L
.67232 .68736 L
.6928 .73401 L
.70936 .78017 L
.72168 .82315 L
.73161 .8684 L
.73583 .89355 L
.739 .9175 L
.74126 .94032 L
.74213 .95186 L
.74287 .96462 L
.74332 .97547 L
.74351 .98157 L
.74357 .98447 L
.74363 .98717 L
.74367 .98975 L
.7437 .99209 L
.74372 .9947 L
.74374 .99748 L
.74374 1.00017 L
.74374 1.00307 L
.74372 1.00582 L
.74369 1.00835 L
.74365 1.01132 L
.7436 1.01415 L
.74348 1.01944 L
.7433 1.02515 L
.74306 1.03136 L
Mistroke
.74249 1.04252 L
.7418 1.05286 L
.73967 1.0765 L
.73654 1.10158 L
.73267 1.12576 L
.72757 1.15172 L
.71592 1.1982 L
.70137 1.24335 L
.68282 1.28983 L
.64139 1.36999 L
.58664 1.44891 L
.52446 1.51735 L
.44935 1.58071 L
.36946 1.63153 L
.28695 1.67012 L
.24263 1.68587 L
.19458 1.69939 L
.17283 1.70434 L
.14925 1.70892 L
.12875 1.71224 L
.10627 1.71519 L
.08549 1.71729 L
.06614 1.71869 L
.05541 1.71924 L
.04567 1.7196 L
.04027 1.71974 L
.03743 1.7198 L
.03442 1.71985 L
.03179 1.71989 L
.0289 1.71991 L
.02627 1.71993 L
.02381 1.71993 L
Mfstroke
.02385 .2364 m
.02681 .2364 L
.0295 .23642 L
.03261 .23645 L
.03555 .23649 L
.04078 .23659 L
.04645 .23673 L
.0527 .23694 L
.05932 .23722 L
.07119 .23787 L
.08343 .23873 L
.09488 .23971 L
.1209 .24259 L
.14732 .24645 L
.17136 .25079 L
.2249 .26335 L
.2706 .27738 L
.31939 .29592 L
.41085 .34175 L
.49236 .39705 L
.5704 .46678 L
.6359 .54345 L
.68886 .62477 L
.71166 .6684 L
.73338 .71787 L
.75094 .76683 L
.76402 .81243 L
.77455 .86042 L
.77902 .8871 L
.78238 .9125 L
.78478 .9367 L
.7857 .94894 L
.78649 .96247 L
.78697 .97398 L
.78716 .98045 L
.78724 .98353 L
.78729 .98639 L
.78734 .98913 L
.78737 .99161 L
.78739 .99438 L
.78741 .99733 L
.78741 1.00018 L
.78741 1.00326 L
.78739 1.00617 L
.78736 1.00885 L
.78732 1.01201 L
.78727 1.015 L
.78713 1.02062 L
.78695 1.02667 L
.78669 1.03326 L
Mistroke
.78608 1.0451 L
.78535 1.05607 L
.78309 1.08114 L
.77977 1.10774 L
.77567 1.13339 L
.77026 1.16092 L
.75791 1.21022 L
.74247 1.25811 L
.7228 1.30741 L
.67885 1.39244 L
.62078 1.47615 L
.55483 1.54873 L
.47516 1.61593 L
.39043 1.66984 L
.30292 1.71077 L
.2559 1.72748 L
.20494 1.74181 L
.18187 1.74707 L
.15686 1.75192 L
.13512 1.75545 L
.11127 1.75858 L
.08923 1.7608 L
.06871 1.76228 L
.05733 1.76287 L
.047 1.76325 L
.04127 1.7634 L
.03825 1.76347 L
.03506 1.76352 L
.03227 1.76356 L
.0292 1.76358 L
.02642 1.7636 L
.02381 1.7636 L
Mfstroke
.02385 .19509 m
.02697 .1951 L
.02981 .19511 L
.03309 .19514 L
.03619 .19519 L
.0417 .19529 L
.04768 .19545 L
.05426 .19567 L
.06124 .19596 L
.07375 .19664 L
.08666 .19755 L
.09873 .19859 L
.12615 .20162 L
.154 .20569 L
.17934 .21026 L
.23577 .2235 L
.28395 .23829 L
.33537 .25784 L
.43179 .30615 L
.5177 .36443 L
.59997 .43793 L
.66901 .51876 L
.72483 .60447 L
.74886 .65046 L
.77177 .70261 L
.79028 .75422 L
.80406 .80228 L
.81516 .85287 L
.81987 .88099 L
.82342 .90777 L
.82595 .93327 L
.82692 .94618 L
.82775 .96044 L
.82825 .97257 L
.82845 .97939 L
.82853 .98264 L
.82859 .98565 L
.82864 .98854 L
.82867 .99116 L
.8287 .99407 L
.82871 .99719 L
.82872 1.00019 L
.82871 1.00343 L
.82869 1.0065 L
.82866 1.00933 L
.82862 1.01266 L
.82856 1.01582 L
.82842 1.02174 L
.82823 1.02811 L
.82795 1.03506 L
Mistroke
.82731 1.04754 L
.82655 1.0591 L
.82416 1.08553 L
.82067 1.11357 L
.81634 1.14061 L
.81064 1.16963 L
.79761 1.2216 L
.78134 1.27207 L
.76061 1.32404 L
.71429 1.41367 L
.65307 1.5019 L
.58356 1.57841 L
.49957 1.64925 L
.41026 1.70607 L
.31801 1.74921 L
.26845 1.76683 L
.21474 1.78194 L
.19042 1.78748 L
.16405 1.7926 L
.14114 1.79631 L
.116 1.79961 L
.09277 1.80195 L
.07114 1.80352 L
.05914 1.80413 L
.04825 1.80454 L
.04221 1.8047 L
.03903 1.80476 L
.03567 1.80482 L
.03273 1.80486 L
.0295 1.80489 L
.02656 1.8049 L
.02381 1.80491 L
Mfstroke
.02385 .1558 m
.02713 .15581 L
.0301 .15583 L
.03354 .15586 L
.03679 .1559 L
.04257 .15601 L
.04884 .15618 L
.05575 .15641 L
.06307 .15672 L
.07619 .15743 L
.08972 .15838 L
.10239 .15947 L
.13115 .16266 L
.16035 .16692 L
.18693 .17171 L
.24612 .1856 L
.29665 .20111 L
.35058 .22161 L
.4517 .27228 L
.54181 .33341 L
.62809 .4105 L
.7005 .49527 L
.75905 .58517 L
.78425 .6334 L
.80827 .6881 L
.82769 .74223 L
.84214 .79263 L
.85378 .84569 L
.85873 .87518 L
.86244 .90327 L
.8651 .93002 L
.86612 .94355 L
.86698 .95851 L
.86751 .97123 L
.86773 .97839 L
.86781 .98179 L
.86787 .98495 L
.86792 .98798 L
.86795 .99073 L
.86798 .99379 L
.868 .99705 L
.86801 1.00019 L
.868 1.0036 L
.86798 1.00682 L
.86795 1.00979 L
.8679 1.01328 L
.86784 1.01659 L
.8677 1.0228 L
.86749 1.02949 L
.8672 1.03677 L
Mistroke
.86653 1.04986 L
.86573 1.06198 L
.86323 1.08971 L
.85956 1.11911 L
.85502 1.14747 L
.84905 1.17791 L
.83538 1.23241 L
.81832 1.28535 L
.79657 1.33986 L
.74799 1.43386 L
.68379 1.5264 L
.61088 1.60664 L
.5228 1.68094 L
.42912 1.74053 L
.33237 1.78578 L
.2804 1.80426 L
.22406 1.8201 L
.19855 1.82591 L
.1709 1.83128 L
.14687 1.83518 L
.1205 1.83864 L
.09614 1.84109 L
.07345 1.84273 L
.06087 1.84338 L
.04944 1.84381 L
.04311 1.84397 L
.03978 1.84404 L
.03625 1.8441 L
.03316 1.84414 L
.02977 1.84417 L
.02669 1.84419 L
.02381 1.8442 L
Mfstroke
.02385 .11827 m
.02727 .11827 L
.03038 .11829 L
.03397 .11833 L
.03737 .11837 L
.04341 .11848 L
.04996 .11865 L
.05717 .1189 L
.06481 .11922 L
.07852 .11997 L
.09265 .12096 L
.10588 .12209 L
.13592 .12542 L
.16643 .12988 L
.19419 .13488 L
.256 .14939 L
.30878 .16559 L
.36511 .187 L
.47072 .23992 L
.56484 .30377 L
.65496 .38429 L
.73059 .47283 L
.79174 .56672 L
.81807 .6171 L
.84315 .67423 L
.86343 .73076 L
.87853 .78341 L
.89069 .83882 L
.89585 .86963 L
.89974 .89896 L
.90251 .9269 L
.90357 .94104 L
.90448 .95667 L
.90503 .96995 L
.90525 .97743 L
.90534 .98098 L
.9054 .98428 L
.90545 .98744 L
.90549 .99032 L
.90552 .99351 L
.90554 .99692 L
.90554 1.0002 L
.90553 1.00376 L
.90551 1.00712 L
.90548 1.01022 L
.90543 1.01387 L
.90537 1.01733 L
.90522 1.02381 L
.905 1.0308 L
.90471 1.03841 L
Mistroke
.904 1.05208 L
.90316 1.06474 L
.90055 1.0937 L
.89672 1.12441 L
.89199 1.15403 L
.88574 1.18582 L
.87147 1.24275 L
.85365 1.29804 L
.83094 1.35497 L
.78019 1.45315 L
.71313 1.54981 L
.63698 1.63362 L
.54498 1.71122 L
.44715 1.77346 L
.34609 1.82072 L
.29181 1.84002 L
.23296 1.85657 L
.20632 1.86264 L
.17744 1.86825 L
.15234 1.87232 L
.1248 1.87593 L
.09936 1.87849 L
.07566 1.88021 L
.06251 1.88088 L
.05058 1.88133 L
.04397 1.8815 L
.04049 1.88158 L
.0368 1.88164 L
.03358 1.88168 L
.03004 1.88171 L
.02682 1.88173 L
.02381 1.88173 L
Mfstroke
.02386 .08226 m
.02741 .08227 L
.03065 .08229 L
.03439 .08232 L
.03792 .08237 L
.04421 .08249 L
.05102 .08267 L
.05853 .08292 L
.06649 .08326 L
.08075 .08403 L
.09547 .08506 L
.10923 .08625 L
.1405 .08971 L
.17225 .09435 L
.20114 .09956 L
.26548 .11466 L
.32042 .13152 L
.37905 .1538 L
.48897 .20888 L
.58693 .27534 L
.68073 .35914 L
.75945 .4513 L
.8231 .54903 L
.8505 .60147 L
.87661 .66092 L
.89772 .71977 L
.91343 .77456 L
.92608 .83224 L
.93146 .86431 L
.9355 .89484 L
.93839 .92392 L
.93949 .93863 L
.94044 .9549 L
.94101 .96873 L
.94125 .97651 L
.94133 .9802 L
.9414 .98364 L
.94145 .98693 L
.94149 .98992 L
.94152 .99324 L
.94154 .99679 L
.94155 1.00021 L
.94154 1.00392 L
.94152 1.00742 L
.94149 1.01064 L
.94143 1.01443 L
.94137 1.01803 L
.94121 1.02479 L
.94099 1.03205 L
.94068 1.03997 L
Mistroke
.93994 1.0542 L
.93907 1.06738 L
.93635 1.09752 L
.93237 1.12949 L
.92744 1.16031 L
.92094 1.1934 L
.90608 1.25266 L
.88753 1.31021 L
.86389 1.36946 L
.81107 1.47165 L
.74128 1.57226 L
.66202 1.65949 L
.56627 1.74026 L
.46443 1.80504 L
.35925 1.85424 L
.30275 1.87432 L
.2415 1.89154 L
.21377 1.89786 L
.18371 1.9037 L
.15759 1.90793 L
.12892 1.9117 L
.10244 1.91436 L
.07777 1.91615 L
.0641 1.91685 L
.05168 1.91731 L
.04479 1.9175 L
.04117 1.91757 L
.03733 1.91764 L
.03398 1.91768 L
.03029 1.91771 L
.02694 1.91773 L
.02381 1.91774 L
Mfstroke
.02386 .04762 m
.02755 .04763 L
.03091 .04765 L
.03479 .04768 L
.03846 .04773 L
.04498 .04785 L
.05205 .04804 L
.05984 .0483 L
.0681 .04865 L
.0829 .04945 L
.09817 .05053 L
.11245 .05175 L
.1449 .05535 L
.17785 .06016 L
.20784 .06557 L
.27461 .08123 L
.33162 .09873 L
.39246 .12186 L
.50653 .17902 L
.60819 .24798 L
.70553 .33495 L
.78722 .43059 L
.85327 .532 L
.8817 .58642 L
.9088 .64812 L
.93071 .70919 L
.94701 .76605 L
.96014 .82591 L
.96572 .85918 L
.96992 .89087 L
.97291 .92105 L
.97406 .93632 L
.97504 .95319 L
.97564 .96754 L
.97588 .97562 L
.97597 .97945 L
.97604 .98302 L
.97609 .98644 L
.97613 .98954 L
.97616 .99299 L
.97618 .99667 L
.97619 1.00022 L
.97618 1.00406 L
.97616 1.0077 L
.97613 1.01104 L
.97607 1.01498 L
.97601 1.01871 L
.97584 1.02572 L
.97561 1.03326 L
.97529 1.04148 L
Mistroke
.97453 1.05625 L
.97362 1.06993 L
.9708 1.1012 L
.96666 1.13438 L
.96155 1.16637 L
.9548 1.20071 L
.93939 1.26219 L
.92013 1.32192 L
.8956 1.38341 L
.84079 1.48946 L
.76836 1.59386 L
.68611 1.68438 L
.58674 1.7682 L
.48107 1.83543 L
.37192 1.88648 L
.31328 1.90732 L
.24972 1.9252 L
.22094 1.93176 L
.18975 1.93781 L
.16264 1.94221 L
.13289 1.94611 L
.10541 1.94888 L
.07981 1.95073 L
.06562 1.95146 L
.05273 1.95194 L
.04558 1.95213 L
.04182 1.95221 L
.03785 1.95228 L
.03436 1.95232 L
.03054 1.95236 L
.02706 1.95238 L
.02381 1.95238 L
Mfstroke
.02381 .99981 m
.02382 .80818 L
.02382 .72265 L
.02383 .66146 L
.02383 .6116 L
.02383 .56476 L
.02383 .524 L
.02384 .48421 L
.02384 .44857 L
.02384 .41634 L
.02384 .3839 L
.02384 .3542 L
.02384 .32688 L
.02384 .29896 L
.02385 .2731 L
.02385 .24658 L
.02385 .22189 L
.02385 .19885 L
.02385 .17505 L
.02385 .15276 L
.02385 .1297 L
.02385 .10805 L
.02386 .0877 L
.02386 .06654 L
.02386 .04762 L
s
.02385 .99981 m
.0665 .81299 L
.08554 .7296 L
.09916 .66995 L
.11025 .62134 L
.12068 .57568 L
.12975 .53594 L
.13861 .49714 L
.14654 .4624 L
.15371 .43098 L
.16093 .39935 L
.16754 .3704 L
.17362 .34377 L
.17984 .31654 L
.18559 .29133 L
.1915 .26548 L
.19699 .2414 L
.20212 .21895 L
.20742 .19574 L
.21238 .17401 L
.21751 .15153 L
.22233 .13042 L
.22686 .11058 L
.23157 .08996 L
.23578 .07151 L
s
.02389 .99982 m
.10705 .82718 L
.14416 .75012 L
.17071 .69499 L
.19235 .65007 L
.21267 .60787 L
.23035 .57115 L
.24762 .5353 L
.26309 .50319 L
.27707 .47415 L
.29115 .44493 L
.30404 .41817 L
.31589 .39355 L
.32801 .3684 L
.33923 .3451 L
.35074 .3212 L
.36145 .29896 L
.37144 .27821 L
.38177 .25676 L
.39144 .23668 L
.40145 .21591 L
.41085 .1964 L
.41968 .17806 L
.42886 .159 L
.43707 .14195 L
s
.02393 .99985 m
.14341 .85003 L
.19674 .78316 L
.2349 .73532 L
.26599 .69635 L
.29519 .65972 L
.3206 .62786 L
.34542 .59675 L
.36764 .56889 L
.38773 .54369 L
.40796 .51833 L
.42648 .49511 L
.44351 .47375 L
.46092 .45192 L
.47705 .43171 L
.49358 .41097 L
.50898 .39167 L
.52334 .37366 L
.53818 .35505 L
.55208 .33762 L
.56646 .3196 L
.57996 .30267 L
.59265 .28676 L
.60584 .27022 L
.61764 .25542 L
s
.02396 .99988 m
.17379 .88041 L
.24066 .82708 L
.2885 .78893 L
.32748 .75785 L
.3641 .72864 L
.39597 .70324 L
.42709 .67842 L
.45494 .65621 L
.48014 .63611 L
.50551 .61589 L
.52873 .59737 L
.55009 .58034 L
.57192 .56293 L
.59214 .54681 L
.61287 .53027 L
.63218 .51488 L
.65019 .50052 L
.6688 .48567 L
.68623 .47178 L
.70425 .4574 L
.72118 .4439 L
.73709 .43122 L
.75363 .41803 L
.76843 .40623 L
s
.02398 .99992 m
.19664 .91678 L
.2737 .87967 L
.32883 .85312 L
.37375 .83149 L
.41595 .81117 L
.45267 .79349 L
.48853 .77622 L
.52064 .76076 L
.54968 .74678 L
.5789 .7327 L
.60566 .71982 L
.63028 .70796 L
.65543 .69585 L
.67873 .68463 L
.70263 .67312 L
.72488 .66241 L
.74563 .65242 L
.76708 .64209 L
.78716 .63242 L
.80793 .62242 L
.82744 .61302 L
.84577 .6042 L
.86484 .59502 L
.88189 .5868 L
s
.024 .99996 m
.21082 .95732 L
.29421 .93829 L
.35387 .92468 L
.40248 .91358 L
.44814 .90316 L
.48787 .89409 L
.52667 .88524 L
.56141 .87731 L
.59284 .87014 L
.62447 .86292 L
.65342 .85631 L
.68006 .85024 L
.70728 .84402 L
.73249 .83827 L
.75835 .83237 L
.78242 .82688 L
.80487 .82175 L
.82808 .81645 L
.84981 .8115 L
.87229 .80637 L
.8934 .80155 L
.91324 .79702 L
.93387 .79231 L
.95232 .7881 L
s
.024 1 m
.21563 1 L
.30116 1.00001 L
.36235 1.00001 L
.41221 1.00001 L
.45905 1.00001 L
.4998 1.00001 L
.5396 1.00001 L
.57524 1.00001 L
.60747 1.00001 L
.63991 1.00002 L
.66961 1.00002 L
.69693 1.00002 L
.72485 1.00002 L
.75071 1.00002 L
.77723 1.00002 L
.80192 1.00002 L
.82496 1.00002 L
.84876 1.00002 L
.87105 1.00002 L
.8941 1.00002 L
.91576 1.00002 L
.93611 1.00002 L
.95726 1.00002 L
.97619 1.00002 L
s
.024 1.00004 m
.21082 1.04269 L
.29421 1.06172 L
.35386 1.07534 L
.40247 1.08644 L
.44814 1.09686 L
.48787 1.10593 L
.52667 1.11479 L
.56141 1.12272 L
.59283 1.12989 L
.62446 1.13711 L
.65341 1.14372 L
.68005 1.1498 L
.70727 1.15601 L
.73248 1.16177 L
.75834 1.16767 L
.78241 1.17316 L
.80487 1.17829 L
.82807 1.18359 L
.8498 1.18855 L
.87228 1.19368 L
.89339 1.1985 L
.91323 1.20302 L
.93386 1.20773 L
.95231 1.21194 L
s
.02398 1.00008 m
.19663 1.08323 L
.27369 1.12034 L
.32882 1.14689 L
.37374 1.16853 L
.41595 1.18885 L
.45266 1.20653 L
.48852 1.2238 L
.52062 1.23926 L
.54966 1.25325 L
.57889 1.26733 L
.60565 1.28021 L
.63026 1.29207 L
.65542 1.30418 L
.67872 1.3154 L
.70261 1.32691 L
.72486 1.33762 L
.74561 1.34762 L
.76706 1.35795 L
.78714 1.36762 L
.80791 1.37762 L
.82742 1.38702 L
.84575 1.39585 L
.86482 1.40503 L
.88187 1.41324 L
s
.02396 1.00012 m
.17378 1.1196 L
.24065 1.17293 L
.28849 1.21108 L
.32747 1.24217 L
.36409 1.27137 L
.39595 1.29678 L
.42707 1.3216 L
.45493 1.34382 L
.48013 1.36391 L
.50549 1.38414 L
.52871 1.40266 L
.55007 1.41969 L
.5719 1.4371 L
.59212 1.45322 L
.61285 1.46976 L
.63216 1.48515 L
.65016 1.49952 L
.66878 1.51436 L
.6862 1.52825 L
.70423 1.54263 L
.72116 1.55613 L
.73706 1.56882 L
.75361 1.58201 L
.7684 1.59381 L
s
.02393 1.00015 m
.14341 1.14997 L
.19673 1.21684 L
.23489 1.26469 L
.26597 1.30367 L
.29517 1.34029 L
.32058 1.37215 L
.3454 1.40327 L
.36761 1.43113 L
.38771 1.45633 L
.40794 1.48169 L
.42645 1.50491 L
.44349 1.52627 L
.46089 1.5481 L
.47702 1.56832 L
.49355 1.58905 L
.50895 1.60836 L
.52331 1.62637 L
.53815 1.64498 L
.55205 1.6624 L
.56642 1.68043 L
.57992 1.69736 L
.59261 1.71327 L
.6058 1.72981 L
.6176 1.74461 L
s
.02389 1.00018 m
.10704 1.17283 L
.14415 1.24989 L
.1707 1.30502 L
.19233 1.34994 L
.21265 1.39214 L
.23033 1.42886 L
.2476 1.46472 L
.26306 1.49682 L
.27705 1.52586 L
.29112 1.55509 L
.30401 1.58185 L
.31586 1.60646 L
.32797 1.63162 L
.33919 1.65492 L
.3507 1.67881 L
.36142 1.70106 L
.37141 1.72181 L
.38174 1.74326 L
.39141 1.76334 L
.40141 1.78411 L
.41081 1.80362 L
.41963 1.82195 L
.42881 1.84102 L
.43703 1.85807 L
s
.02385 1.00019 m
.06649 1.18701 L
.08553 1.2704 L
.09914 1.33006 L
.11024 1.37866 L
.12066 1.42433 L
.12973 1.46406 L
.13858 1.50286 L
.14651 1.5376 L
.15368 1.56903 L
.1609 1.60065 L
.16751 1.62961 L
.17359 1.65624 L
.1798 1.68346 L
.18556 1.70867 L
.19146 1.73453 L
.19695 1.75861 L
.20208 1.78106 L
.20738 1.80427 L
.21233 1.826 L
.21747 1.84848 L
.22228 1.86959 L
.22681 1.88943 L
.23152 1.91005 L
.23573 1.9285 L
s
.02381 1.00019 m
.02381 1.19182 L
.02381 1.27735 L
.02381 1.33854 L
.02381 1.3884 L
.02381 1.43524 L
.02381 1.476 L
.02381 1.51579 L
.02381 1.55143 L
.02381 1.58366 L
.02381 1.6161 L
.02381 1.6458 L
.02381 1.67312 L
.02381 1.70104 L
.02381 1.7269 L
.02381 1.75342 L
.02381 1.77811 L
.02381 1.80115 L
.02381 1.82495 L
.02381 1.84724 L
.02381 1.8703 L
.02381 1.89195 L
.02381 1.9123 L
.02381 1.93346 L
.02381 1.95238 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.29.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.29.1"]
}, Open  ]],

Cell[TextData[{
 "The option ",
 StyleBox["Lines", "MR"],
 " can be used to change the number of lines plotted. You can set the value \
of ",
 StyleBox["$Lines", "MR"],
 " to change the default number of lines drawn. "
}], "MathCaption",
 CellTags->{"S5.29.1", "1.10"}],

Cell[CellGroupData[{

Cell["PolarMap[BesselJ[2, #] &, {0, 8}, {0, Pi/4}, Lines -> 30]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.29.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.11091 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.488757 0.202119 0.596731 0.202119 [
[.08452 -0.0125 -6 -9 ]
[.08452 -0.0125 6 0 ]
[.28664 -0.0125 -6 -9 ]
[.28664 -0.0125 6 0 ]
[.48876 -0.0125 -3 -9 ]
[.48876 -0.0125 3 0 ]
[.69088 -0.0125 -3 -9 ]
[.69088 -0.0125 3 0 ]
[.89299 -0.0125 -3 -9 ]
[.89299 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .19249 -12 -4.5 ]
[-0.0125 .19249 0 4.5 ]
[-0.0125 .39461 -12 -4.5 ]
[-0.0125 .39461 0 4.5 ]
[-0.0125 .59673 -6 -4.5 ]
[-0.0125 .59673 0 4.5 ]
[-0.0125 .79885 -6 -4.5 ]
[-0.0125 .79885 0 4.5 ]
[-0.0125 1.00097 -6 -4.5 ]
[-0.0125 1.00097 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1.11091 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1.11091 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08452 0 m
.08452 .00625 L
s
[(-2)] .08452 -0.0125 0 1 Mshowa
.28664 0 m
.28664 .00625 L
s
[(-1)] .28664 -0.0125 0 1 Mshowa
.48876 0 m
.48876 .00625 L
s
[(0)] .48876 -0.0125 0 1 Mshowa
.69088 0 m
.69088 .00625 L
s
[(1)] .69088 -0.0125 0 1 Mshowa
.89299 0 m
.89299 .00625 L
s
[(2)] .89299 -0.0125 0 1 Mshowa
.125 Mabswid
.12494 0 m
.12494 .00375 L
s
.16537 0 m
.16537 .00375 L
s
.20579 0 m
.20579 .00375 L
s
.24621 0 m
.24621 .00375 L
s
.32706 0 m
.32706 .00375 L
s
.36749 0 m
.36749 .00375 L
s
.40791 0 m
.40791 .00375 L
s
.44833 0 m
.44833 .00375 L
s
.52918 0 m
.52918 .00375 L
s
.5696 0 m
.5696 .00375 L
s
.61003 0 m
.61003 .00375 L
s
.65045 0 m
.65045 .00375 L
s
.7313 0 m
.7313 .00375 L
s
.77172 0 m
.77172 .00375 L
s
.81215 0 m
.81215 .00375 L
s
.85257 0 m
.85257 .00375 L
s
.04409 0 m
.04409 .00375 L
s
.00367 0 m
.00367 .00375 L
s
.93342 0 m
.93342 .00375 L
s
.97384 0 m
.97384 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .19249 m
.00625 .19249 L
s
[(-2)] -0.0125 .19249 1 0 Mshowa
0 .39461 m
.00625 .39461 L
s
[(-1)] -0.0125 .39461 1 0 Mshowa
0 .59673 m
.00625 .59673 L
s
[(0)] -0.0125 .59673 1 0 Mshowa
0 .79885 m
.00625 .79885 L
s
[(1)] -0.0125 .79885 1 0 Mshowa
0 1.00097 m
.00625 1.00097 L
s
[(2)] -0.0125 1.00097 1 0 Mshowa
.125 Mabswid
0 .0308 m
.00375 .0308 L
s
0 .07122 m
.00375 .07122 L
s
0 .11165 m
.00375 .11165 L
s
0 .15207 m
.00375 .15207 L
s
0 .23292 m
.00375 .23292 L
s
0 .27334 m
.00375 .27334 L
s
0 .31376 m
.00375 .31376 L
s
0 .35419 m
.00375 .35419 L
s
0 .43504 m
.00375 .43504 L
s
0 .47546 m
.00375 .47546 L
s
0 .51588 m
.00375 .51588 L
s
0 .55631 m
.00375 .55631 L
s
0 .63715 m
.00375 .63715 L
s
0 .67758 m
.00375 .67758 L
s
0 .718 m
.00375 .718 L
s
0 .75843 m
.00375 .75843 L
s
0 .83927 m
.00375 .83927 L
s
0 .8797 m
.00375 .8797 L
s
0 .92012 m
.00375 .92012 L
s
0 .96055 m
.00375 .96055 L
s
0 1.04139 m
.00375 1.04139 L
s
0 1.08182 m
.00375 1.08182 L
s
.25 Mabswid
0 0 m
0 1.11091 L
s
.08452 1.10466 m
.08452 1.11091 L
s
.28664 1.10466 m
.28664 1.11091 L
s
.48876 1.10466 m
.48876 1.11091 L
s
.69088 1.10466 m
.69088 1.11091 L
s
.89299 1.10466 m
.89299 1.11091 L
s
.125 Mabswid
.12494 1.10716 m
.12494 1.11091 L
s
.16537 1.10716 m
.16537 1.11091 L
s
.20579 1.10716 m
.20579 1.11091 L
s
.24621 1.10716 m
.24621 1.11091 L
s
.32706 1.10716 m
.32706 1.11091 L
s
.36749 1.10716 m
.36749 1.11091 L
s
.40791 1.10716 m
.40791 1.11091 L
s
.44833 1.10716 m
.44833 1.11091 L
s
.52918 1.10716 m
.52918 1.11091 L
s
.5696 1.10716 m
.5696 1.11091 L
s
.61003 1.10716 m
.61003 1.11091 L
s
.65045 1.10716 m
.65045 1.11091 L
s
.7313 1.10716 m
.7313 1.11091 L
s
.77172 1.10716 m
.77172 1.11091 L
s
.81215 1.10716 m
.81215 1.11091 L
s
.85257 1.10716 m
.85257 1.11091 L
s
.04409 1.10716 m
.04409 1.11091 L
s
.00367 1.10716 m
.00367 1.11091 L
s
.93342 1.10716 m
.93342 1.11091 L
s
.97384 1.10716 m
.97384 1.11091 L
s
.25 Mabswid
0 1.11091 m
1 1.11091 L
s
.99375 .19249 m
1 .19249 L
s
.99375 .39461 m
1 .39461 L
s
.99375 .59673 m
1 .59673 L
s
.99375 .79885 m
1 .79885 L
s
.99375 1.00097 m
1 1.00097 L
s
.125 Mabswid
.99625 .0308 m
1 .0308 L
s
.99625 .07122 m
1 .07122 L
s
.99625 .11165 m
1 .11165 L
s
.99625 .15207 m
1 .15207 L
s
.99625 .23292 m
1 .23292 L
s
.99625 .27334 m
1 .27334 L
s
.99625 .31376 m
1 .31376 L
s
.99625 .35419 m
1 .35419 L
s
.99625 .43504 m
1 .43504 L
s
.99625 .47546 m
1 .47546 L
s
.99625 .51588 m
1 .51588 L
s
.99625 .55631 m
1 .55631 L
s
.99625 .63715 m
1 .63715 L
s
.99625 .67758 m
1 .67758 L
s
.99625 .718 m
1 .718 L
s
.99625 .75843 m
1 .75843 L
s
.99625 .83927 m
1 .83927 L
s
.99625 .8797 m
1 .8797 L
s
.99625 .92012 m
1 .92012 L
s
.99625 .96055 m
1 .96055 L
s
.99625 1.04139 m
1 1.04139 L
s
.99625 1.08182 m
1 1.08182 L
s
.25 Mabswid
1 0 m
1 1.11091 L
s
0 .59673 m
1 .59673 L
s
.48876 0 m
.48876 1.11091 L
s
0 0 m
1 0 L
1 1.11091 L
0 1.11091 L
closepath
clip
newpath
.5 Mabswid
.48876 .59673 m
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
.48876 .59673 L
Mistroke
.48876 .59673 L
Mfstroke
.49067 .59673 m
.49067 .59673 L
.49067 .59674 L
.49067 .59674 L
.49067 .59675 L
.49067 .59675 L
.49067 .59676 L
.49067 .59677 L
.49067 .59677 L
.49067 .59679 L
.49067 .5968 L
.49067 .59682 L
.49066 .59685 L
.49066 .59688 L
.49066 .59692 L
.49065 .59698 L
.49064 .59704 L
.49063 .59711 L
.4906 .59723 L
.49057 .59735 L
.49052 .59747 L
.49047 .59758 L
.49041 .59769 L
.49034 .5978 L
.49027 .5979 L
.4902 .59799 L
.49011 .59809 L
.49002 .59817 L
.48992 .59825 L
.48982 .59833 L
.48972 .59839 L
.4896 .59845 L
.48949 .5985 L
.48938 .59855 L
.48926 .59858 L
.48914 .59861 L
.48908 .59862 L
.48901 .59864 L
.48895 .59864 L
.48889 .59865 L
.48885 .59865 L
.48884 .59865 L
.48882 .59865 L
.48881 .59865 L
.4888 .59865 L
.48878 .59865 L
.48878 .59865 L
.48877 .59865 L
s
.49625 .59673 m
.49625 .59674 L
.49625 .59676 L
.49625 .59677 L
.49625 .59679 L
.49625 .59681 L
.49625 .59684 L
.49625 .59687 L
.49625 .5969 L
.49625 .59696 L
.49625 .59702 L
.49625 .59707 L
.49624 .5972 L
.49623 .59732 L
.49622 .59744 L
.49619 .5977 L
.49616 .59793 L
.49612 .59817 L
.49601 .59865 L
.49588 .59911 L
.49571 .59958 L
.49551 .60002 L
.4953 .60044 L
.49505 .60087 L
.49478 .60127 L
.49449 .60163 L
.49417 .602 L
.49383 .60234 L
.49345 .60268 L
.49306 .60298 L
.49267 .60324 L
.49223 .6035 L
.4918 .60372 L
.49136 .6039 L
.49089 .60407 L
.49042 .6042 L
.49018 .60426 L
.48992 .60431 L
.48968 .60435 L
.48942 .60438 L
.48929 .60439 L
.48918 .6044 L
.48895 .60442 L
s
.50509 .59673 m
.50509 .59676 L
.50509 .59679 L
.50509 .59682 L
.50509 .59685 L
.50509 .5969 L
.50509 .59696 L
.50509 .59702 L
.50509 .59709 L
.50509 .59721 L
.50508 .59733 L
.50508 .59745 L
.50507 .59771 L
.50505 .59798 L
.50503 .59823 L
.50497 .59878 L
.50491 .59926 L
.50483 .59978 L
.50462 .60079 L
.50436 .60175 L
.50402 .60276 L
.50364 .60372 L
.50321 .60462 L
.50271 .60555 L
.50216 .60642 L
.50159 .60723 L
.50092 .60806 L
.50023 .60882 L
.49945 .60959 L
.49864 .61028 L
.49782 .61091 L
.4969 .61152 L
.49597 .61206 L
.49504 .61252 L
.49402 .61296 L
.493 .61332 L
.49189 .61363 L
.49132 .61376 L
.49079 .61386 L
.48974 .61401 L
s
.51651 .59673 m
.51651 .59678 L
.51651 .59682 L
.51651 .59687 L
.51651 .59692 L
.51651 .59701 L
.51651 .5971 L
.51651 .5972 L
.51651 .59731 L
.5165 .5975 L
.5165 .5977 L
.51649 .59789 L
.51647 .59832 L
.51645 .59875 L
.51642 .59915 L
.51634 .60004 L
.51625 .60082 L
.51613 .60166 L
.51583 .60331 L
.51546 .60489 L
.51497 .60655 L
.51441 .60814 L
.51379 .60964 L
.51304 .61122 L
.51222 .61271 L
.51136 .61411 L
.51035 .61556 L
.50928 .61691 L
.50806 .6183 L
.50679 .61958 L
.50548 .62076 L
.504 .62193 L
.50249 .62299 L
.50095 .62394 L
.49924 .62485 L
.49752 .62563 L
.49562 .62636 L
.49371 .62694 L
.49188 .62737 L
s
.52964 .59673 m
.52964 .5968 L
.52964 .59686 L
.52964 .59693 L
.52964 .59699 L
.52964 .59711 L
.52964 .59724 L
.52964 .59738 L
.52964 .59752 L
.52963 .59779 L
.52963 .59806 L
.52962 .59832 L
.5296 .59891 L
.52957 .5995 L
.52954 .60005 L
.52945 .60128 L
.52935 .60235 L
.52922 .60351 L
.52888 .6058 L
.52845 .60801 L
.52789 .61035 L
.52725 .61261 L
.52652 .61477 L
.52563 .61707 L
.52465 .61927 L
.52359 .62137 L
.52234 .62359 L
.521 .6257 L
.51942 .6279 L
.51776 .62997 L
.51602 .63191 L
.51401 .63391 L
.51193 .63575 L
.50978 .63744 L
.50734 .63913 L
.50484 .64063 L
.50202 .64209 L
.49917 .64333 L
.49636 .64434 L
s
.54346 .59673 m
.54346 .59681 L
.54346 .59688 L
.54346 .59697 L
.54346 .59705 L
.54346 .59719 L
.54346 .59734 L
.54346 .59751 L
.54346 .59769 L
.54345 .59802 L
.54345 .59835 L
.54344 .59866 L
.54343 .59937 L
.54341 .6001 L
.54338 .60076 L
.54331 .60226 L
.54323 .60357 L
.54312 .605 L
.54284 .60782 L
.54248 .61056 L
.542 .6135 L
.54143 .61637 L
.54077 .61917 L
.53994 .62219 L
.53901 .62513 L
.53797 .62799 L
.5367 .63107 L
.5353 .63405 L
.53361 .63724 L
.53177 .64031 L
.52979 .64326 L
.52744 .64637 L
.52493 .64931 L
.52228 .65208 L
.5192 .65493 L
.51597 .65756 L
.51224 .66021 L
.50837 .66257 L
.5045 .6646 L
s
.5569 .59673 m
.5569 .59682 L
.5569 .5969 L
.5569 .59699 L
.5569 .59708 L
.5569 .59723 L
.5569 .5974 L
.5569 .59758 L
.5569 .59778 L
.5569 .59813 L
.5569 .59849 L
.55689 .59883 L
.55689 .59961 L
.55688 .6004 L
.55688 .60112 L
.55686 .60276 L
.55683 .60419 L
.5568 .60577 L
.55675 .6074 L
.55671 .6089 L
.55657 .61198 L
.55639 .61521 L
.55614 .61841 L
.55578 .62192 L
.55533 .62542 L
.55478 .6289 L
.55404 .63272 L
.55316 .63653 L
.55199 .6407 L
.55063 .64484 L
.54906 .64893 L
.54709 .65337 L
.54486 .65772 L
.54239 .66194 L
.53936 .66646 L
.53605 .67078 L
.53207 .67532 L
.52777 .67959 L
.52319 .68354 L
.51783 .68753 L
.51782 .68754 L
s
.56888 .59673 m
.56888 .59682 L
.56888 .59689 L
.56888 .59698 L
.56888 .59707 L
.56888 .59721 L
.56888 .59738 L
.56888 .59756 L
.56888 .59775 L
.56889 .59809 L
.56889 .59844 L
.5689 .59877 L
.56891 .59952 L
.56894 .60029 L
.56896 .60099 L
.56903 .60259 L
.56921 .60554 L
.56944 .60847 L
.56972 .61171 L
.57003 .61497 L
.57035 .61862 L
.57065 .62234 L
.57089 .62613 L
.57098 .62818 L
.57102 .62924 L
.57106 .63041 L
.57107 .63098 L
.57108 .63152 L
.57109 .63201 L
.57109 .63255 L
.5711 .63282 L
.5711 .63313 L
.5711 .63329 L
.5711 .63337 L
.5711 .63346 L
.5711 .63353 L
.5711 .63362 L
.5711 .63376 L
.5711 .63391 L
.5711 .63405 L
.5711 .63412 L
.5711 .6342 L
.5711 .63435 L
.5711 .63449 L
.5711 .63464 L
.57109 .6349 L
.57109 .63519 L
.57109 .63547 L
.57108 .63599 L
.57107 .63656 L
Mistroke
.57105 .63718 L
.57102 .63831 L
.57098 .63937 L
.57084 .64189 L
.57066 .64425 L
.57041 .64675 L
.57007 .64953 L
.56914 .65523 L
.56787 .66099 L
.56625 .66676 L
.56404 .67313 L
.56138 .67944 L
.55792 .6863 L
.55391 .69299 L
.54938 .69945 L
.54379 .70625 L
.53808 .71221 L
Mfstroke
.57842 .59673 m
.57842 .5968 L
.57842 .59686 L
.57842 .59694 L
.57842 .59701 L
.57842 .59713 L
.57842 .59727 L
.57843 .59741 L
.57843 .59757 L
.57844 .59785 L
.57846 .59814 L
.57847 .59842 L
.57852 .59904 L
.57858 .59968 L
.57865 .60027 L
.57885 .6016 L
.57936 .60411 L
.58004 .60665 L
.58093 .60954 L
.58194 .61253 L
.58315 .616 L
.58442 .61966 L
.5857 .62352 L
.58708 .62802 L
.58837 .63279 L
.58952 .63781 L
.59059 .64364 L
.59101 .6465 L
.5914 .64975 L
.59158 .65157 L
.59172 .65329 L
.59184 .65508 L
.59194 .65679 L
.592 .6584 L
.59202 .65931 L
.59204 .66016 L
.59205 .66062 L
.59205 .66104 L
.59206 .66129 L
.59206 .66151 L
.59206 .66164 L
.59206 .66177 L
.59206 .66202 L
.59206 .66226 L
.59206 .66239 L
.59206 .66252 L
.59206 .66265 L
.59206 .66278 L
.59206 .66305 L
.59205 .66329 L
Mistroke
.59205 .66354 L
.59205 .66401 L
.59204 .6645 L
.59203 .66503 L
.592 .666 L
.59196 .66695 L
.59193 .66783 L
.59181 .66986 L
.59165 .67204 L
.59125 .67611 L
.59073 .68001 L
.58912 .68864 L
.58793 .69352 L
.58657 .69825 L
.58334 .70752 L
.57886 .71765 L
.57345 .72759 L
.56718 .73716 L
Mfstroke
.58469 .59673 m
.58469 .59677 L
.58469 .59681 L
.58469 .59686 L
.58469 .5969 L
.58469 .59698 L
.5847 .59706 L
.5847 .59715 L
.58471 .59724 L
.58473 .59742 L
.58475 .59759 L
.58478 .59776 L
.58486 .59814 L
.58497 .59854 L
.5851 .59891 L
.58545 .59975 L
.58639 .60138 L
.58762 .60311 L
.58927 .60519 L
.59118 .60748 L
.59353 .6103 L
.59608 .61345 L
.59874 .61695 L
.60176 .62124 L
.60479 .62599 L
.60775 .6312 L
.61088 .63749 L
.61377 .64431 L
.6166 .65246 L
.61897 .66121 L
.62079 .67048 L
.62151 .6756 L
.62181 .67831 L
.62207 .68129 L
.62227 .68413 L
.62234 .68539 L
.6224 .68678 L
.62245 .68812 L
.62248 .68937 L
.62249 .69007 L
.6225 .6907 L
.62251 .69106 L
.62251 .69144 L
.62251 .6918 L
.62251 .69214 L
.62251 .69251 L
.62251 .69287 L
.62251 .69319 L
.62251 .69354 L
.62251 .69392 L
Mistroke
.6225 .69432 L
.62249 .69505 L
.62248 .6958 L
.62246 .6965 L
.62242 .69783 L
.62235 .69943 L
.62228 .70091 L
.62204 .70431 L
.62176 .70745 L
.62143 .71042 L
.62044 .71732 L
.61912 .72432 L
.61759 .73085 L
.61317 .74531 L
.60732 .75965 L
.60702 .76029 L
Mfstroke
.58708 .59673 m
.58708 .59673 L
.58708 .59674 L
.58708 .59674 L
.58708 .59674 L
.58708 .59675 L
.58709 .59676 L
.5871 .59676 L
.58711 .59677 L
.58714 .59678 L
.58722 .59681 L
.58734 .59685 L
.58821 .59705 L
.58962 .59737 L
.59151 .59788 L
.59407 .59871 L
.59708 .59986 L
.60045 .60137 L
.60453 .6035 L
.60892 .60614 L
.61402 .6097 L
.61931 .61396 L
.62468 .61894 L
.63059 .62528 L
.63639 .63251 L
.64193 .6406 L
.64764 .65054 L
.65277 .66146 L
.65763 .67461 L
.65975 .6818 L
.66148 .68882 L
.66301 .69643 L
.66418 .70391 L
.66467 .70797 L
.66505 .71176 L
.66539 .71607 L
.66553 .71836 L
.66564 .72081 L
.66569 .72196 L
.66572 .72306 L
.66575 .72406 L
.66577 .72512 L
.66578 .72568 L
.66579 .72629 L
.66579 .72685 L
.6658 .72737 L
.6658 .72769 L
.6658 .72799 L
.6658 .72855 L
.6658 .72916 L
Mistroke
.6658 .72951 L
.6658 .72983 L
.66579 .73037 L
.66579 .73095 L
.66577 .73201 L
.66575 .73305 L
.66573 .734 L
.66565 .73619 L
.66555 .73852 L
.66526 .74313 L
.66482 .74815 L
.66369 .7574 L
.66182 .76824 L
.65944 .77876 L
Mfstroke
.58523 .59673 m
.58523 .59668 L
.58523 .59664 L
.58523 .59659 L
.58523 .59655 L
.58524 .59646 L
.58525 .59637 L
.58526 .59628 L
.58527 .59617 L
.58531 .59599 L
.58536 .59579 L
.58541 .59561 L
.58557 .59521 L
.58578 .5948 L
.58602 .59442 L
.58672 .59361 L
.5875 .59294 L
.58855 .59224 L
.58973 .59163 L
.59119 .59105 L
.59288 .59053 L
.59373 .59032 L
.59468 .59013 L
.5956 .58997 L
.59666 .58982 L
.59767 .58971 L
.59865 .58963 L
.59922 .58959 L
.59953 .58957 L
.59985 .58956 L
.60014 .58955 L
.60046 .58954 L
.60076 .58953 L
.60089 .58953 L
.60104 .58953 L
.60118 .58953 L
.60131 .58953 L
.60146 .58953 L
.60161 .58953 L
.60175 .58953 L
.60189 .58953 L
.60201 .58953 L
.60214 .58953 L
.60229 .58953 L
.60245 .58953 L
.60278 .58954 L
.60309 .58955 L
.60338 .58956 L
.60404 .58958 L
.60477 .58962 L
Mistroke
.60613 .58973 L
.6075 .58986 L
.60882 .59002 L
.61198 .59052 L
.61502 .59114 L
.62211 .59309 L
.6296 .59587 L
.63823 .59995 L
.64712 .60516 L
.6561 .61151 L
.666 .61988 L
.6757 .62969 L
.68596 .64218 L
.69552 .65639 L
.70414 .67221 L
.71232 .69146 L
.71587 .70197 L
.71883 .7124 L
.7213 .72304 L
.72343 .73477 L
.7243 .74083 L
.72508 .74762 L
.72564 .75392 L
.72603 .7599 L
.72618 .76335 L
.72625 .7653 L
.7263 .76712 L
.72633 .76871 L
.72635 .76962 L
.72636 .77047 L
.72637 .77137 L
.72637 .7722 L
.72637 .77265 L
.72637 .77315 L
.72637 .77406 L
.72637 .77487 L
.72636 .77563 L
.72635 .77646 L
.72634 .77737 L
.72631 .77922 L
.72626 .78092 L
.72615 .78406 L
.72599 .78739 L
.72591 .78881 L
Mfstroke
.57908 .59673 m
.57908 .59663 L
.57908 .59653 L
.57908 .59642 L
.57908 .59632 L
.57909 .59614 L
.5791 .59594 L
.57911 .59572 L
.57913 .59549 L
.57917 .59507 L
.57923 .59464 L
.5793 .59424 L
.57948 .59332 L
.57974 .59239 L
.58003 .59154 L
.58086 .58965 L
.5818 .58804 L
.58306 .5863 L
.58624 .58304 L
.59023 .58013 L
.59262 .57875 L
.59549 .57737 L
.6016 .57513 L
.60503 .57421 L
.60894 .57339 L
.6108 .57309 L
.61287 .5728 L
.61486 .57258 L
.61677 .57242 L
.61784 .57234 L
.61903 .57228 L
.62026 .57222 L
.62094 .5722 L
.62158 .57219 L
.62216 .57218 L
.62245 .57217 L
.62262 .57217 L
.62277 .57217 L
.62305 .57217 L
.62335 .57217 L
.62362 .57217 L
.62388 .57217 L
.62419 .57217 L
.62434 .57217 L
.62451 .57217 L
.62482 .57218 L
.6251 .57218 L
.62574 .57219 L
.62644 .57221 L
.62775 .57226 L
Mistroke
.62899 .57232 L
.63185 .57251 L
.63445 .57276 L
.63729 .5731 L
.6434 .57406 L
.64944 .57534 L
.66175 .57886 L
.67587 .58441 L
.69035 .59179 L
.70493 .60106 L
.72093 .61356 L
.73648 .62845 L
.75279 .64766 L
.7678 .66973 L
.78107 .69443 L
.78716 .70828 L
.79326 .7246 L
.79804 .73996 L
.80244 .75746 L
.80528 .77192 L
.80736 .7857 L
Mfstroke
.56885 .59673 m
.56885 .59657 L
.56885 .59642 L
.56885 .59624 L
.56886 .59608 L
.56886 .59579 L
.56887 .59547 L
.56889 .59513 L
.56891 .59476 L
.56896 .5941 L
.56902 .59342 L
.56909 .59278 L
.56929 .59133 L
.56957 .58985 L
.56989 .58849 L
.5708 .58546 L
.57184 .58282 L
.57323 .57997 L
.57676 .57443 L
.58122 .56922 L
.58719 .56388 L
.59422 .55901 L
.60226 .55469 L
.61227 .55064 L
.61786 .54889 L
.62345 .54744 L
.62917 .54625 L
.63569 .54522 L
.63923 .54479 L
.64321 .54442 L
.64507 .54428 L
.64708 .54416 L
.64882 .54408 L
.64975 .54404 L
.65077 .54401 L
.6517 .54399 L
.65269 .54397 L
.65324 .54396 L
.65374 .54395 L
.65425 .54395 L
.65473 .54395 L
.65518 .54395 L
.65566 .54395 L
.65606 .54395 L
.65651 .54395 L
.657 .54395 L
.65752 .54396 L
.65847 .54398 L
.65956 .544 L
.66077 .54404 L
Mistroke
.66298 .54413 L
.66517 .54424 L
.66722 .54438 L
.67185 .54477 L
.67632 .54527 L
.68496 .54655 L
.69471 .54848 L
.70404 .55082 L
.72513 .5578 L
.74672 .56746 L
.77083 .5814 L
.79474 .59888 L
.82036 .62236 L
.84456 .65024 L
.86662 .68231 L
.88778 .72238 L
.90378 .76361 L
Mfstroke
.55505 .59673 m
.55505 .59651 L
.55505 .5963 L
.55505 .59607 L
.55505 .59585 L
.55506 .59545 L
.55507 .59503 L
.55509 .59455 L
.55511 .59405 L
.55515 .59316 L
.55521 .59223 L
.55528 .59136 L
.55549 .58939 L
.55577 .58737 L
.55608 .58552 L
.557 .58135 L
.55803 .57771 L
.55943 .57373 L
.56302 .56587 L
.56761 .55824 L
.57383 .55011 L
.58129 .5423 L
.58997 .53488 L
.60101 .52722 L
.6136 .52025 L
.62769 .51414 L
.63645 .51108 L
.64503 .50855 L
.65466 .50623 L
.66416 .50443 L
.67446 .50299 L
.68014 .5024 L
.68337 .50213 L
.68637 .50193 L
.68904 .50178 L
.69199 .50165 L
.69345 .50159 L
.69501 .50155 L
.69588 .50153 L
.69667 .50151 L
.69742 .5015 L
.69822 .50149 L
.69892 .50148 L
.6997 .50148 L
.7004 .50147 L
.70106 .50147 L
.70185 .50147 L
.70256 .50148 L
.70339 .50148 L
.70418 .50149 L
Mistroke
.7056 .50151 L
.70693 .50154 L
.70995 .50163 L
.7117 .5017 L
.71332 .50178 L
.71702 .50198 L
.72384 .50251 L
.7302 .50316 L
.73705 .50403 L
.75166 .50648 L
.76585 .50962 L
.79772 .51936 L
.83388 .53503 L
.87038 .55619 L
.90634 .58296 L
.94453 .61916 L
.98003 .66225 L
Mfstroke
.98003 .66225 m
1 .69353 L
s
.53842 .59673 m
.53842 .59646 L
.53842 .59621 L
.53842 .59592 L
.53842 .59564 L
.53843 .59516 L
.53844 .59463 L
.53845 .59405 L
.53847 .59343 L
.53851 .59233 L
.53857 .59118 L
.53863 .59011 L
.53881 .58767 L
.53906 .58518 L
.53933 .58289 L
.54015 .5777 L
.54108 .57316 L
.54234 .56814 L
.5456 .55809 L
.54985 .54813 L
.55572 .53718 L
.56292 .52627 L
.57151 .51548 L
.58272 .50375 L
.59584 .49235 L
.61092 .48149 L
.62999 .47032 L
.6516 .46034 L
.66395 .4557 L
.67847 .4511 L
.6922 .44753 L
.70844 .44421 L
.72489 .44176 L
.73436 .44074 L
.73871 .44037 L
.74354 .44002 L
.74793 .43977 L
.75269 .43956 L
.75535 .43947 L
.75779 .4394 L
.75897 .43938 L
.76026 .43936 L
.76148 .43934 L
.76261 .43933 L
.76365 .43932 L
.76477 .43932 L
.76583 .43931 L
.7668 .43932 L
.76794 .43932 L
.76918 .43933 L
Mistroke
.77037 .43935 L
.77146 .43936 L
.77389 .43941 L
.77609 .43947 L
.78109 .43965 L
.78613 .4399 L
.79152 .44025 L
.80135 .44108 L
.81219 .4423 L
.82438 .44404 L
.84702 .4483 L
.87233 .45464 L
.92531 .47334 L
.9793 .50033 L
Mfstroke
.9793 .50033 m
1 .51407 L
s
.51991 .59673 m
.51991 .59642 L
.51991 .59613 L
.51991 .5958 L
.51991 .59549 L
.51992 .59493 L
.51992 .59433 L
.51993 .59366 L
.51995 .59296 L
.51997 .59169 L
.52001 .59038 L
.52006 .58916 L
.52019 .58636 L
.52037 .58349 L
.52058 .58086 L
.52118 .57488 L
.52187 .5696 L
.52282 .56374 L
.52533 .55186 L
.52869 .53982 L
.5335 .52627 L
.53961 .51237 L
.54717 .49815 L
.55741 .48211 L
.56986 .46583 L
.58467 .44952 L
.60406 .43171 L
.62682 .41447 L
.65606 .39662 L
.68978 .38062 L
.72791 .36721 L
.74992 .36139 L
.7751 .35627 L
.78695 .35438 L
.80015 .35267 L
.81302 .35137 L
.82517 .35047 L
.8319 .35011 L
.83564 .34995 L
.8392 .34982 L
.84254 .34973 L
.84431 .34969 L
.84619 .34965 L
.84778 .34963 L
.84953 .34961 L
.85113 .34959 L
.85263 .34958 L
.85454 .34958 L
.85563 .34958 L
.85664 .34958 L
Mistroke
.85849 .34959 L
.86047 .34961 L
.86243 .34964 L
.86427 .34967 L
.86774 .34975 L
.87188 .34987 L
.87571 .35002 L
.88445 .35045 L
.89196 .35095 L
.9001 .35161 L
.91506 .35315 L
.93329 .3556 L
.95031 .35844 L
.98441 .36578 L
Mfstroke
.98441 .36578 m
1 .37018 L
s
.50058 .59673 m
.50058 .59639 L
.50058 .59609 L
.50059 .59573 L
.50059 .5954 L
.50059 .5948 L
.50059 .59415 L
.5006 .59344 L
.5006 .59268 L
.50061 .59132 L
.50063 .58992 L
.50065 .5886 L
.50071 .5856 L
.50079 .58251 L
.50088 .57967 L
.50116 .5732 L
.50148 .56746 L
.50195 .56104 L
.50325 .54786 L
.50515 .53425 L
.50811 .51856 L
.5122 .50202 L
.51765 .48461 L
.52557 .46435 L
.53583 .44305 L
.54875 .42091 L
.56656 .39568 L
.58848 .37001 L
.61795 .34174 L
.65339 .31426 L
.695 .28854 L
.74838 .26331 L
.77867 .25213 L
.80952 .24277 L
.84125 .23507 L
.87796 .22841 L
.89685 .22586 L
.91825 .22367 L
.92933 .22281 L
.93551 .22241 L
.94139 .22209 L
.94692 .22184 L
.95297 .22161 L
.95851 .22145 L
.96366 .22134 L
.96645 .22129 L
.96911 .22126 L
.97151 .22125 L
.97413 .22124 L
.97698 .22123 L
Mistroke
.97858 .22124 L
.98003 .22125 L
.98286 .22127 L
.98554 .2213 L
.98808 .22134 L
.99076 .2214 L
.99559 .22152 L
Mfstroke
.99559 .22152 m
1 .22166 L
s
.48158 .59673 m
.48158 .59639 L
.48158 .59608 L
.48158 .59572 L
.48158 .59539 L
.48158 .59479 L
.48158 .59413 L
.48157 .59341 L
.48157 .59265 L
.48156 .59128 L
.48154 .58854 L
.4815 .5855 L
.48138 .57908 L
.48124 .57293 L
.48091 .56075 L
.48074 .55424 L
.48065 .55069 L
.48058 .54682 L
.48054 .54485 L
.48051 .54296 L
.48049 .5411 L
.48047 .53937 L
.48046 .53771 L
.48046 .53687 L
.48045 .53593 L
.48045 .53544 L
.48045 .53499 L
.48045 .53474 L
.48045 .53447 L
.48045 .53397 L
.48045 .53351 L
.48045 .53301 L
.48045 .53259 L
.48045 .53212 L
.48045 .53164 L
.48046 .5312 L
.48046 .53019 L
.48047 .5292 L
.48048 .52813 L
.4805 .52618 L
.48053 .52439 L
.48057 .52227 L
.48063 .51993 L
.48077 .51559 L
.48094 .51142 L
.48118 .50671 L
.48188 .49672 L
.48281 .48692 L
.48419 .47573 L
.48594 .46449 L
Mistroke
.48841 .45146 L
.49493 .4251 L
.50499 .39488 L
.5189 .36259 L
.53951 .3249 L
.56649 .28559 L
.60052 .24558 L
.64712 .20168 L
.70385 .15953 L
.77094 .12096 L
.81415 .10113 L
.85736 .08461 L
.9068 .06927 L
.9563 .05736 L
Mfstroke
.9563 .05736 m
1 .04975 L
s
.46401 .59673 m
.46401 .59641 L
.46401 .59612 L
.46401 .59578 L
.464 .59547 L
.464 .5949 L
.46399 .59429 L
.46398 .59361 L
.46396 .59289 L
.46393 .5916 L
.46388 .59027 L
.46383 .58902 L
.46368 .58616 L
.46347 .58321 L
.46324 .58049 L
.46258 .57423 L
.46089 .56224 L
.45875 .54963 L
.45605 .53464 L
.45324 .51823 L
.45035 .49815 L
.44906 .48686 L
.44805 .47567 L
.44763 .46971 L
.4473 .46395 L
.44703 .45772 L
.44692 .45434 L
.44688 .45255 L
.44683 .45063 L
.4468 .44887 L
.44679 .44793 L
.44678 .44691 L
.44677 .44597 L
.44676 .44511 L
.44676 .44428 L
.44675 .4434 L
.44675 .4429 L
.44675 .44244 L
.44675 .44191 L
.44675 .44141 L
.44675 .44051 L
.44675 .44 L
.44676 .43954 L
.44676 .43854 L
.44678 .43745 L
.44681 .43522 L
.44684 .43323 L
.44688 .4314 L
.44701 .42722 L
.44716 .42328 L
Mistroke
.44735 .41946 L
.44784 .41152 L
.44855 .40275 L
.45038 .38618 L
.45355 .36547 L
.45772 .34459 L
.4697 .30072 L
.48973 .24835 L
.51819 .19254 L
.55623 .13449 L
.6108 .06915 L
.67968 .00463 L
Mfstroke
.67968 .00463 m
.68613 0 L
s
.44888 .59673 m
.44888 .59645 L
.44888 .5962 L
.44888 .59591 L
.44887 .59564 L
.44887 .59515 L
.44885 .59462 L
.44883 .59403 L
.4488 .59341 L
.44874 .59229 L
.44866 .59114 L
.44856 .59006 L
.44829 .58757 L
.44791 .58501 L
.44749 .58264 L
.44628 .57715 L
.44311 .5665 L
.43893 .55507 L
.43334 .54112 L
.42697 .52542 L
.41936 .50561 L
.41154 .48273 L
.40402 .45644 L
.4004 .44125 L
.39673 .42298 L
.39368 .4039 L
.39135 .3845 L
.39034 .37317 L
.38993 .3674 L
.3896 .36196 L
.38935 .35704 L
.38912 .3515 L
.38895 .34583 L
.38888 .34268 L
.38883 .33968 L
.38881 .33821 L
.3888 .33664 L
.38879 .33514 L
.38878 .33377 L
.38878 .33216 L
.38878 .33124 L
.38878 .3304 L
.38879 .32884 L
.3888 .32718 L
.38882 .32558 L
.38884 .32386 L
.3889 .32072 L
.389 .31696 L
.3891 .31348 L
.38935 .30728 L
Mistroke
.38971 .30041 L
.39059 .28755 L
.39202 .27225 L
.39373 .25787 L
.39916 .22386 L
.40638 .19036 L
.41699 .15175 L
.44824 .06841 L
Mfstroke
.44824 .06841 m
.4839 0 L
s
.43706 .59673 m
.43706 .59652 L
.43706 .59633 L
.43705 .5961 L
.43705 .59589 L
.43703 .59552 L
.43701 .59511 L
.43698 .59466 L
.43695 .59419 L
.43686 .59333 L
.43674 .59245 L
.4366 .59161 L
.4362 .5897 L
.43566 .58773 L
.43505 .58589 L
.43328 .58162 L
.42862 .57316 L
.42236 .56381 L
.41376 .55203 L
.40359 .53827 L
.39082 .52024 L
.37676 .49862 L
.36191 .47286 L
.34524 .43888 L
.32916 .39838 L
.3148 .35087 L
.3083 .32275 L
.30238 .28954 L
.29998 .27218 L
.29782 .25235 L
.29699 .24294 L
.29624 .23271 L
.29566 .2229 L
.29524 .21371 L
.29493 .20446 L
.29482 .19975 L
.29477 .19707 L
.29474 .19453 L
.29472 .1932 L
.29471 .19176 L
.29469 .18922 L
.29468 .18778 L
.29467 .18625 L
.29467 .18349 L
.29468 .18093 L
.2947 .17852 L
.29472 .17586 L
.29476 .173 L
.29486 .16787 L
.29501 .16222 L
Mistroke
.29539 .15179 L
.2959 .14145 L
.29651 .13169 L
.29866 .10635 L
.30152 .08155 L
.30934 .03274 L
Mfstroke
.30934 .03274 m
.31663 0 L
s
.42917 .59673 m
.42917 .5966 L
.42917 .59649 L
.42916 .59635 L
.42916 .59622 L
.42914 .59599 L
.42911 .59575 L
.42908 .59548 L
.42903 .59519 L
.42891 .59467 L
.42859 .59362 L
.42807 .59245 L
.4274 .59125 L
.42648 .58992 L
.42434 .58741 L
.41804 .58168 L
.40937 .57495 L
.39846 .56686 L
.38392 .55583 L
.36692 .54204 L
.34552 .52284 L
.3217 .49857 L
.29604 .46835 L
.26636 .42692 L
.23646 .3758 L
.20795 .31407 L
.19291 .27352 L
.1802 .23228 L
.16848 .18492 L
.15922 .13544 L
.15535 .10839 L
.15198 .07827 L
.14978 .0514 L
.14884 .03562 L
.14816 .02048 L
.1479 .01249 L
.1477 .00498 L
.14762 .00062 L
s
.14762 .00062 m
.14761 0 L
s
.4256 .59673 m
.4256 .5967 L
.42559 .59667 L
.42559 .59664 L
.42558 .59661 L
.42556 .59655 L
.42553 .59649 L
.42549 .59642 L
.42543 .59635 L
.42529 .59622 L
.42491 .59595 L
.42432 .59565 L
.42246 .59495 L
.41995 .5942 L
.41305 .59233 L
.40243 .58941 L
.38868 .5852 L
.37182 .57926 L
.34955 .57007 L
.32346 .55733 L
.29033 .53804 L
.25289 .51192 L
.21181 .47757 L
.16315 .4282 L
.1126 .3648 L
.06242 .28567 L
.0348 .23253 L
.0105 .17774 L
s
.0105 .17774 m
0 .14945 L
s
.42642 .59673 m
.42642 .5968 L
.42642 .59687 L
.42641 .59694 L
.4264 .59702 L
.42638 .59714 L
.42635 .59728 L
.4263 .59743 L
.42624 .5976 L
.4261 .59789 L
.4259 .59818 L
.42568 .59846 L
.42504 .59909 L
.42417 .59973 L
.42319 .6003 L
.4203 .60156 L
.417 .60259 L
.41253 .60363 L
.40739 .6045 L
.40411 .60492 L
.40088 .60526 L
.39737 .60555 L
.39391 .60577 L
.39201 .60586 L
.38984 .60595 L
.38872 .60598 L
.38749 .60601 L
.38631 .60603 L
.38575 .60604 L
.38522 .60605 L
.38468 .60606 L
.38419 .60606 L
.38363 .60606 L
.38303 .60607 L
.38248 .60607 L
.38187 .60607 L
.38156 .60607 L
.38123 .60607 L
.38063 .60606 L
.38006 .60606 L
.37944 .60605 L
.3783 .60603 L
.37717 .60601 L
.37612 .60599 L
.37365 .60592 L
.37084 .60581 L
.36489 .60549 L
.35885 .60505 L
.35301 .60451 L
.33868 .60277 L
Mistroke
.32411 .60042 L
.30646 .59684 L
.26594 .58585 L
.21889 .56848 L
.15951 .5398 L
.09281 .49848 L
.02018 .44184 L
Mfstroke
.02018 .44184 m
0 .42192 L
s
.43145 .59673 m
.43145 .59691 L
.43144 .59707 L
.43144 .59725 L
.43143 .59743 L
.43141 .59774 L
.43137 .59808 L
.43133 .59845 L
.43127 .59884 L
.43112 .59955 L
.43093 .60028 L
.43071 .60097 L
.43006 .60254 L
.42919 .60414 L
.4282 .60562 L
.42529 .60897 L
.42195 .61192 L
.4174 .61518 L
.4054 .62167 L
.38946 .62792 L
.37938 .63102 L
.36681 .63422 L
.35411 .63684 L
.33827 .63938 L
.33028 .64038 L
.32118 .64132 L
.31591 .64177 L
.31094 .64213 L
.30609 .64243 L
.30077 .6427 L
.29585 .64289 L
.29319 .64297 L
.29027 .64304 L
.28756 .64309 L
.28636 .64311 L
.28504 .64313 L
.28378 .64314 L
.2826 .64314 L
.28135 .64315 L
.28 .64315 L
.27922 .64315 L
.27839 .64315 L
.2769 .64314 L
.27606 .64314 L
.27527 .64313 L
.27347 .64311 L
.27189 .64309 L
.27044 .64306 L
.26712 .64299 L
.26085 .6428 L
Mistroke
.25472 .64254 L
.24201 .64177 L
.22773 .64057 L
.21353 .63903 L
.20005 .63725 L
.1681 .63188 L
.13001 .62341 L
.04335 .59622 L
Mfstroke
.04335 .59622 m
0 .57692 L
s
.44021 .59673 m
.44021 .597 L
.44021 .59725 L
.4402 .59754 L
.44019 .59781 L
.44017 .59829 L
.44014 .59881 L
.4401 .59939 L
.44004 .6 L
.43991 .6011 L
.43973 .60223 L
.43953 .6033 L
.43893 .60573 L
.43813 .60824 L
.43722 .61056 L
.43452 .61589 L
.43141 .62068 L
.42713 .62609 L
.41574 .63742 L
.40029 .64932 L
.37783 .66304 L
.34879 .67705 L
.3122 .69069 L
.28976 .69735 L
.26168 .7042 L
.23121 .70996 L
.19914 .71437 L
.17995 .71627 L
.17007 .71704 L
.16066 .71765 L
.15208 .7181 L
.14237 .71849 L
.13724 .71865 L
.13235 .71877 L
.12712 .71887 L
.12415 .71891 L
.12141 .71893 L
.11856 .71895 L
.11584 .71895 L
.11339 .71895 L
.11071 .71894 L
.10778 .71892 L
.10629 .7189 L
.10464 .71888 L
.09897 .71879 L
.0936 .71867 L
.08775 .7185 L
.07698 .71807 L
.06306 .71733 L
.04946 .71638 L
Mistroke
.02291 .71396 L
Mfstroke
.02291 .71396 m
0 .7112 L
s
.452 .59673 m
.452 .59708 L
.45199 .59741 L
.45199 .59778 L
.45198 .59813 L
.45197 .59875 L
.45194 .59943 L
.45191 .60018 L
.45186 .60097 L
.45175 .60239 L
.45161 .60387 L
.45144 .60525 L
.45095 .60843 L
.45029 .61171 L
.44954 .61475 L
.4473 .62179 L
.4411 .63553 L
.43203 .65031 L
.41811 .66821 L
.3993 .68797 L
.37162 .71193 L
.33508 .73785 L
.28801 .76489 L
.22146 .79461 L
.18061 .80906 L
.1371 .82182 L
.08987 .83298 L
.03279 .84314 L
.00041 .84744 L
s
.00041 .84744 m
0 .84748 L
s
.46592 .59673 m
.46592 .59714 L
.46592 .59752 L
.46591 .59795 L
.46591 .59836 L
.4659 .59909 L
.46588 .59988 L
.46586 .60075 L
.46583 .60168 L
.46575 .60334 L
.46566 .60506 L
.46554 .60668 L
.46522 .6104 L
.46477 .61424 L
.46426 .61782 L
.46272 .62616 L
.46092 .63381 L
.45838 .64269 L
.45127 .6622 L
.44093 .68431 L
.4247 .71234 L
.40192 .74462 L
.37084 .78118 L
.3243 .82629 L
.26182 .87541 L
.18022 .9266 L
.12346 .95587 L
.06343 .98235 L
s
.06343 .98235 m
0 1.00578 L
s
.48876 .59673 m
.48876 .59673 L
.48877 .59673 L
.48878 .59673 L
.4888 .59673 L
.48882 .59673 L
.48884 .59673 L
.48887 .59673 L
.4889 .59673 L
.48894 .59673 L
.48899 .59673 L
.48904 .59673 L
.48909 .59673 L
.48915 .59673 L
.48919 .59673 L
.48923 .59673 L
.4893 .59673 L
.48939 .59673 L
.48943 .59673 L
.48948 .59673 L
.48957 .59673 L
.48962 .59673 L
.48967 .59673 L
.48973 .59673 L
.48979 .59673 L
.48985 .59673 L
.48991 .59673 L
.49003 .59673 L
.49015 .59673 L
.49027 .59673 L
.49039 .59673 L
.4905 .59673 L
.49063 .59673 L
.49078 .59673 L
.49093 .59673 L
.49109 .59673 L
.49123 .59673 L
.49139 .59673 L
.49149 .59673 L
.49158 .59673 L
.49168 .59673 L
.49179 .59673 L
.49198 .59673 L
.49209 .59673 L
.49219 .59673 L
.49239 .59673 L
.49258 .59673 L
.49268 .59673 L
.4928 .59673 L
.49301 .59673 L
Mistroke
.49314 .59673 L
.49327 .59673 L
.49338 .59673 L
.4935 .59673 L
.49364 .59673 L
.49379 .59673 L
.49392 .59673 L
.49406 .59673 L
.4942 .59673 L
.49432 .59673 L
.49447 .59673 L
.49461 .59673 L
.49486 .59673 L
.495 .59673 L
.49513 .59673 L
.49538 .59673 L
.49564 .59673 L
.4959 .59673 L
.49614 .59673 L
.4964 .59673 L
.4967 .59673 L
.49685 .59673 L
.49702 .59673 L
.49732 .59673 L
.49748 .59673 L
.49764 .59673 L
.49781 .59673 L
.498 .59673 L
.49831 .59673 L
.49849 .59673 L
.49866 .59673 L
.49898 .59673 L
.49927 .59673 L
.49962 .59673 L
.49995 .59673 L
.50025 .59673 L
.50058 .59673 L
.5009 .59673 L
.5012 .59673 L
.50153 .59673 L
.50189 .59673 L
.50208 .59673 L
.50228 .59673 L
.50264 .59673 L
.50284 .59673 L
.50303 .59673 L
.50324 .59673 L
.50346 .59673 L
.50383 .59673 L
.50404 .59673 L
Mistroke
.50424 .59673 L
.50462 .59673 L
.50497 .59673 L
.50538 .59673 L
.50577 .59673 L
.50614 .59673 L
.50647 .59673 L
.50687 .59673 L
.50724 .59673 L
.50759 .59673 L
.50791 .59673 L
.50827 .59673 L
.50865 .59673 L
.50904 .59673 L
.50946 .59673 L
.50985 .59673 L
.51022 .59673 L
.51065 .59673 L
.51089 .59673 L
.51112 .59673 L
.51154 .59673 L
.51199 .59673 L
.5124 .59673 L
.51284 .59673 L
.51332 .59673 L
.51376 .59673 L
.51418 .59673 L
.51456 .59673 L
.515 .59673 L
.51542 .59673 L
.51588 .59673 L
.51637 .59673 L
.51679 .59673 L
.51725 .59673 L
.51775 .59673 L
.51803 .59673 L
.51829 .59673 L
.5188 .59673 L
.51928 .59673 L
.51973 .59673 L
.52014 .59673 L
.52061 .59673 L
.52106 .59673 L
.52148 .59673 L
.52186 .59673 L
.52228 .59673 L
.52273 .59673 L
.52319 .59673 L
.52368 .59673 L
.52414 .59673 L
Mistroke
.52457 .59673 L
.52507 .59673 L
.52535 .59673 L
.52561 .59673 L
.52609 .59673 L
.5266 .59673 L
.52709 .59673 L
.52763 .59673 L
.52815 .59673 L
.52862 .59673 L
.5291 .59673 L
.52953 .59673 L
.53002 .59673 L
.53049 .59673 L
.531 .59673 L
.53155 .59673 L
.53201 .59673 L
.53252 .59673 L
.53307 .59673 L
.53338 .59673 L
.53367 .59673 L
.53421 .59673 L
.53474 .59673 L
.53518 .59673 L
.53567 .59673 L
.53618 .59673 L
.53666 .59673 L
.5371 .59673 L
.53751 .59673 L
.53796 .59673 L
.53843 .59673 L
.53892 .59673 L
.53943 .59673 L
.53992 .59673 L
.54036 .59673 L
.54088 .59673 L
.54117 .59673 L
.54144 .59673 L
.54194 .59673 L
.54246 .59673 L
.54297 .59673 L
.54352 .59673 L
.54405 .59673 L
.54453 .59673 L
.54501 .59673 L
.54545 .59673 L
.54595 .59673 L
.54642 .59673 L
.54693 .59673 L
.54747 .59673 L
Mistroke
.54794 .59673 L
.54844 .59673 L
.54898 .59673 L
.54929 .59673 L
.54957 .59673 L
.5501 .59673 L
.55061 .59673 L
.55104 .59673 L
.55151 .59673 L
.55201 .59673 L
.55247 .59673 L
.5529 .59673 L
.55329 .59673 L
.55372 .59673 L
.55417 .59673 L
.55463 .59673 L
.55511 .59673 L
.55557 .59673 L
.55598 .59673 L
.55647 .59673 L
.55674 .59673 L
.55699 .59673 L
.55745 .59673 L
.55793 .59673 L
.5584 .59673 L
.55892 .59673 L
.55939 .59673 L
.55984 .59673 L
.56023 .59673 L
.56067 .59673 L
.56112 .59673 L
.56154 .59673 L
.562 .59673 L
.56249 .59673 L
.5629 .59673 L
.56334 .59673 L
.56382 .59673 L
.56409 .59673 L
.56433 .59673 L
.5648 .59673 L
.56524 .59673 L
.56561 .59673 L
.56602 .59673 L
.56645 .59673 L
.56684 .59673 L
.56721 .59673 L
.56754 .59673 L
.56792 .59673 L
.56828 .59673 L
.56866 .59673 L
Mistroke
.56907 .59673 L
.56945 .59673 L
.56979 .59673 L
.57019 .59673 L
.57041 .59673 L
.57062 .59673 L
.57099 .59673 L
.57138 .59673 L
.57176 .59673 L
.57198 .59673 L
.57217 .59673 L
.57253 .59673 L
.57291 .59673 L
.57324 .59673 L
.57355 .59673 L
.57388 .59673 L
.57424 .59673 L
.5746 .59673 L
.5748 .59673 L
.57498 .59673 L
.57535 .59673 L
.57555 .59673 L
.57574 .59673 L
.57607 .59673 L
.57642 .59673 L
.57674 .59673 L
.57704 .59673 L
.57731 .59673 L
.5776 .59673 L
.57787 .59673 L
.57812 .59673 L
.5784 .59673 L
.5787 .59673 L
.57899 .59673 L
.57924 .59673 L
.57953 .59673 L
.57979 .59673 L
.58003 .59673 L
.58028 .59673 L
.58055 .59673 L
.58082 .59673 L
.58106 .59673 L
.58131 .59673 L
.58157 .59673 L
.58181 .59673 L
.58193 .59673 L
.58206 .59673 L
.5822 .59673 L
.58233 .59673 L
.58256 .59673 L
Mistroke
.58277 .59673 L
.583 .59673 L
.58321 .59673 L
.5834 .59673 L
.58359 .59673 L
.58377 .59673 L
.58393 .59673 L
.58411 .59673 L
.5843 .59673 L
.58448 .59673 L
.58463 .59673 L
.58479 .59673 L
.58496 .59673 L
.58511 .59673 L
.58525 .59673 L
.5854 .59673 L
.58548 .59673 L
.58556 .59673 L
.58569 .59673 L
.58576 .59673 L
.58583 .59673 L
.58589 .59673 L
.58596 .59673 L
.58607 .59673 L
.58614 .59673 L
.58619 .59673 L
.58625 .59673 L
.58631 .59673 L
.58636 .59673 L
.58642 .59673 L
.58647 .59673 L
.58651 .59673 L
.58659 .59673 L
.58666 .59673 L
.58673 .59673 L
.5868 .59673 L
.58685 .59673 L
.5869 .59673 L
.58694 .59673 L
.58697 .59673 L
.58701 .59673 L
.58703 .59673 L
.58706 .59673 L
.58707 .59673 L
.58708 .59673 L
.58709 .59673 L
.58709 .59673 L
.58708 .59673 L
.58708 .59673 L
.58706 .59673 L
Mistroke
.58704 .59673 L
.58702 .59673 L
.58699 .59673 L
.58695 .59673 L
.58691 .59673 L
.58687 .59673 L
.58683 .59673 L
.58677 .59673 L
.58672 .59673 L
.58665 .59673 L
.58658 .59673 L
.5865 .59673 L
.58643 .59673 L
.58633 .59673 L
.58628 .59673 L
.58623 .59673 L
.58613 .59673 L
.58601 .59673 L
.5859 .59673 L
.58577 .59673 L
.58563 .59673 L
.58551 .59673 L
.58537 .59673 L
.58525 .59673 L
.5851 .59673 L
.58496 .59673 L
.58479 .59673 L
.58461 .59673 L
.58445 .59673 L
.58427 .59673 L
.58407 .59673 L
.58395 .59673 L
.58385 .59673 L
.58363 .59673 L
.58342 .59673 L
.58324 .59673 L
.58303 .59673 L
.58281 .59673 L
.5826 .59673 L
.5824 .59673 L
.58221 .59673 L
.58198 .59673 L
.58177 .59673 L
.58153 .59673 L
.58127 .59673 L
.58102 .59673 L
.58079 .59673 L
.58051 .59673 L
.58035 .59673 L
.5802 .59673 L
Mistroke
.57993 .59673 L
.57963 .59673 L
.57933 .59673 L
.57916 .59673 L
.579 .59673 L
.5787 .59673 L
.57838 .59673 L
.57809 .59673 L
.57781 .59673 L
.5775 .59673 L
.57716 .59673 L
.57681 .59673 L
.57661 .59673 L
.57643 .59673 L
.57604 .59673 L
.57583 .59673 L
.57563 .59673 L
.57527 .59673 L
.57487 .59673 L
.57449 .59673 L
.57414 .59673 L
.5738 .59673 L
.57344 .59673 L
.57309 .59673 L
.57277 .59673 L
.57239 .59673 L
.57197 .59673 L
.57156 .59673 L
.57119 .59673 L
.57076 .59673 L
.57035 .59673 L
.56997 .59673 L
.56957 .59673 L
.56912 .59673 L
.56864 .59673 L
.56822 .59673 L
.56777 .59673 L
.56727 .59673 L
.5668 .59673 L
.56656 .59673 L
.56628 .59673 L
.566 .59673 L
.56573 .59673 L
.56523 .59673 L
.56477 .59673 L
.56426 .59673 L
.56372 .59673 L
.56326 .59673 L
.56277 .59673 L
.56229 .59673 L
Mistroke
.56186 .59673 L
.56135 .59673 L
.56079 .59673 L
.56026 .59673 L
.55976 .59673 L
.55923 .59673 L
.55865 .59673 L
.55811 .59673 L
.5576 .59673 L
.55701 .59673 L
.55667 .59673 L
.55635 .59673 L
.55577 .59673 L
.55548 .59673 L
.55515 .59673 L
.55484 .59673 L
.5545 .59673 L
.5539 .59673 L
.55356 .59673 L
.55324 .59673 L
.5529 .59673 L
.55252 .59673 L
.5522 .59673 L
.55184 .59673 L
.55151 .59673 L
.5512 .59673 L
.55061 .59673 L
.54998 .59673 L
.54938 .59673 L
.54873 .59673 L
.5481 .59673 L
.54752 .59673 L
.54694 .59673 L
.54642 .59673 L
.5458 .59673 L
.54523 .59673 L
.54459 .59673 L
.54391 .59673 L
.54333 .59673 L
.54269 .59673 L
.542 .59673 L
.54161 .59673 L
.54126 .59673 L
.54056 .59673 L
.5399 .59673 L
.53934 .59673 L
.53872 .59673 L
.53806 .59673 L
.53745 .59673 L
.53687 .59673 L
Mistroke
.53634 .59673 L
.53576 .59673 L
.53514 .59673 L
.53451 .59673 L
.53384 .59673 L
.5332 .59673 L
.53262 .59673 L
.53194 .59673 L
.53155 .59673 L
.53119 .59673 L
.53053 .59673 L
.52983 .59673 L
.52915 .59673 L
.5284 .59673 L
.52769 .59673 L
.52703 .59673 L
.52638 .59673 L
.52578 .59673 L
.5251 .59673 L
.52445 .59673 L
.52374 .59673 L
.52299 .59673 L
.52234 .59673 L
.52164 .59673 L
.52087 .59673 L
.52045 .59673 L
.52005 .59673 L
.5193 .59673 L
.51858 .59673 L
.51796 .59673 L
.51728 .59673 L
.51657 .59673 L
.51591 .59673 L
.51528 .59673 L
.51471 .59673 L
.51406 .59673 L
.51343 .59673 L
.51276 .59673 L
.51204 .59673 L
.51136 .59673 L
.51075 .59673 L
.51002 .59673 L
.50961 .59673 L
.50923 .59673 L
.50854 .59673 L
.50781 .59673 L
.50709 .59673 L
.50668 .59673 L
.50631 .59673 L
.50562 .59673 L
Mistroke
.50488 .59673 L
.50423 .59673 L
.50362 .59673 L
.50294 .59673 L
.50222 .59673 L
.50149 .59673 L
.50108 .59673 L
.5007 .59673 L
.49992 .59673 L
.49949 .59673 L
.4991 .59673 L
.49839 .59673 L
.49763 .59673 L
.49691 .59673 L
.49624 .59673 L
.49562 .59673 L
.49496 .59673 L
.49433 .59673 L
.49376 .59673 L
.4931 .59673 L
.49237 .59673 L
.49168 .59673 L
.49105 .59673 L
.49033 .59673 L
.48966 .59673 L
.48906 .59673 L
.48841 .59673 L
.4877 .59673 L
.48695 .59673 L
.48632 .59673 L
.48562 .59673 L
.48487 .59673 L
.48419 .59673 L
.48383 .59673 L
.48343 .59673 L
.48302 .59673 L
.48264 .59673 L
.48193 .59673 L
.48129 .59673 L
.48058 .59673 L
.47984 .59673 L
.47922 .59673 L
.47856 .59673 L
.47794 .59673 L
.47738 .59673 L
.47671 .59673 L
.476 .59673 L
.47533 .59673 L
.47471 .59673 L
.47406 .59673 L
Mistroke
.47336 .59673 L
.4727 .59673 L
.4721 .59673 L
.4714 .59673 L
.47101 .59673 L
.47065 .59673 L
.46998 .59673 L
.46965 .59673 L
.46928 .59673 L
.46893 .59673 L
.46855 .59673 L
.46789 .59673 L
.46752 .59673 L
.46718 .59673 L
.4668 .59673 L
.4664 .59673 L
.46606 .59673 L
.46569 .59673 L
.46534 .59673 L
.46501 .59673 L
.4644 .59673 L
.46376 .59673 L
.46316 .59673 L
.4625 .59673 L
.46189 .59673 L
.46132 .59673 L
.46077 .59673 L
.46026 .59673 L
.45969 .59673 L
.45914 .59673 L
.45856 .59673 L
.45794 .59673 L
.45742 .59673 L
.45685 .59673 L
.45624 .59673 L
.4559 .59673 L
.45559 .59673 L
.45499 .59673 L
.45443 .59673 L
.45396 .59673 L
.45344 .59673 L
.4529 .59673 L
.4524 .59673 L
.45194 .59673 L
.45152 .59673 L
.45106 .59673 L
.45058 .59673 L
.4501 .59673 L
.44958 .59673 L
.4491 .59673 L
Mistroke
.44867 .59673 L
.44817 .59673 L
.44788 .59673 L
.44763 .59673 L
.44715 .59673 L
.44666 .59673 L
.44618 .59673 L
.44566 .59673 L
.44518 .59673 L
.44474 .59673 L
.4443 .59673 L
.44391 .59673 L
.44347 .59673 L
.44305 .59673 L
.44261 .59673 L
.44214 .59673 L
.44174 .59673 L
.44131 .59673 L
.44086 .59673 L
.4406 .59673 L
.44037 .59673 L
.43993 .59673 L
.43952 .59673 L
.43918 .59673 L
.4388 .59673 L
.43841 .59673 L
.43805 .59673 L
.43772 .59673 L
.43742 .59673 L
.43709 .59673 L
.43676 .59673 L
.43642 .59673 L
.43606 .59673 L
.43573 .59673 L
.43543 .59673 L
.43509 .59673 L
.4349 .59673 L
.43472 .59673 L
.43441 .59673 L
.43408 .59673 L
.43376 .59673 L
.43358 .59673 L
.43342 .59673 L
.43313 .59673 L
.43282 .59673 L
.43255 .59673 L
.43231 .59673 L
.43204 .59673 L
.43176 .59673 L
.43148 .59673 L
Mistroke
.43133 .59673 L
.43119 .59673 L
.4309 .59673 L
.43075 .59673 L
.43061 .59673 L
.43037 .59673 L
.43011 .59673 L
.42987 .59673 L
.42966 .59673 L
.42946 .59673 L
.42926 .59673 L
.42907 .59673 L
.42891 .59673 L
.42871 .59673 L
.42851 .59673 L
.42833 .59673 L
.42816 .59673 L
.42798 .59673 L
.42781 .59673 L
.42767 .59673 L
.42751 .59673 L
.42735 .59673 L
.42719 .59673 L
.42706 .59673 L
.42692 .59673 L
.42678 .59673 L
.42665 .59673 L
.42659 .59673 L
.42652 .59673 L
.42645 .59673 L
.42639 .59673 L
.42628 .59673 L
.42618 .59673 L
.42608 .59673 L
.42599 .59673 L
.42591 .59673 L
.42584 .59673 L
.42577 .59673 L
.42572 .59673 L
.42566 .59673 L
.4256 .59673 L
.42555 .59673 L
.42551 .59673 L
.42548 .59673 L
.42544 .59673 L
.42542 .59673 L
.4254 .59673 L
.42539 .59673 L
.42539 .59673 L
.42539 .59673 L
Mistroke
.42539 .59673 L
.42539 .59673 L
.4254 .59673 L
.4254 .59673 L
.42541 .59673 L
.42544 .59673 L
.42545 .59673 L
.42547 .59673 L
.42549 .59673 L
.42551 .59673 L
.42553 .59673 L
.42556 .59673 L
.42559 .59673 L
.42561 .59673 L
.42567 .59673 L
.42573 .59673 L
.4258 .59673 L
.42588 .59673 L
.42596 .59673 L
.42604 .59673 L
.42613 .59673 L
.42621 .59673 L
.42631 .59673 L
.42641 .59673 L
.42652 .59673 L
.42665 .59673 L
.42676 .59673 L
.42689 .59673 L
.42704 .59673 L
.42712 .59673 L
.4272 .59673 L
.42736 .59673 L
.42752 .59673 L
.42765 .59673 L
.42781 .59673 L
.42798 .59673 L
.42814 .59673 L
.4283 .59673 L
.42845 .59673 L
.42861 .59673 L
.42879 .59673 L
.42898 .59673 L
.42919 .59673 L
.42939 .59673 L
.42957 .59673 L
.42979 .59673 L
.42992 .59673 L
.43004 .59673 L
.43026 .59673 L
.43051 .59673 L
Mistroke
.43075 .59673 L
.43101 .59673 L
.43127 .59673 L
.43152 .59673 L
.43177 .59673 L
.43199 .59673 L
.43226 .59673 L
.43252 .59673 L
.4328 .59673 L
.43311 .59673 L
.43338 .59673 L
.43368 .59673 L
.434 .59673 L
.43419 .59673 L
.43436 .59673 L
.43469 .59673 L
.43502 .59673 L
.43529 .59673 L
.4356 .59673 L
.43593 .59673 L
.43625 .59673 L
.43654 .59673 L
.43682 .59673 L
.43712 .59673 L
.43744 .59673 L
.43778 .59673 L
.43814 .59673 L
.43848 .59673 L
.4388 .59673 L
.43917 .59673 L
.43939 .59673 L
.43959 .59673 L
.43995 .59673 L
.44035 .59673 L
.44074 .59673 L
.44096 .59673 L
.44116 .59673 L
.44154 .59673 L
.44195 .59673 L
.44232 .59673 L
.44267 .59673 L
.44306 .59673 L
.44348 .59673 L
.4439 .59673 L
.44415 .59673 L
.44437 .59673 L
.44483 .59673 L
.44509 .59673 L
.44533 .59673 L
.44576 .59673 L
Mistroke
.44623 .59673 L
.44668 .59673 L
.4471 .59673 L
.44749 .59673 L
.44791 .59673 L
.44831 .59673 L
.44868 .59673 L
.44911 .59673 L
.44959 .59673 L
.45004 .59673 L
.45046 .59673 L
.45094 .59673 L
.4514 .59673 L
.45181 .59673 L
.45226 .59673 L
.45275 .59673 L
.45327 .59673 L
.45372 .59673 L
.45421 .59673 L
.45457 .59673 L
.45491 .59673 L
.45528 .59673 L
.45567 .59673 L
.45601 .59673 L
.45633 .59673 L
.45668 .59673 L
.45706 .59673 L
.45738 .59673 L
.45774 .59673 L
.4581 .59673 L
.45845 .59673 L
.45877 .59673 L
.45907 .59673 L
.45941 .59673 L
.45973 .59673 L
.46008 .59673 L
.46047 .59673 L
.46087 .59673 L
.46125 .59673 L
.46161 .59673 L
.46193 .59673 L
.46231 .59673 L
.46267 .59673 L
.46306 .59673 L
.46347 .59673 L
.46386 .59673 L
.46422 .59673 L
.46464 .59673 L
.46509 .59673 L
.46552 .59673 L
Mistroke
.46592 .59673 L
Mfstroke
.48876 .59673 m
.49139 .59687 L
.49993 .59731 L
.51242 .5979 L
.52721 .5985 L
.53607 .59878 L
.54422 .59899 L
.54824 .59907 L
.55033 .59911 L
.55252 .59914 L
.55441 .59916 L
.55541 .59916 L
.55647 .59917 L
.55743 .59918 L
.5583 .59918 L
.55872 .59918 L
.55918 .59918 L
.5596 .59918 L
.56 .59918 L
.56049 .59918 L
.56073 .59918 L
.561 .59918 L
.56147 .59918 L
.56191 .59918 L
.56243 .59918 L
.56289 .59918 L
.56393 .59917 L
.56482 .59916 L
.56576 .59915 L
.56745 .59913 L
.56903 .5991 L
.57066 .59906 L
.57343 .59896 L
.57611 .59884 L
.57872 .59867 L
.58089 .59849 L
.58263 .59829 L
.58427 .59804 L
.58549 .59778 L
.58605 .59761 L
.58647 .59746 L
.58666 .59737 L
.58685 .59727 L
.58698 .59718 L
.5871 .59708 L
.58714 .59704 L
.58718 .59699 L
.58721 .59694 L
.58723 .5969 L
.58725 .59686 L
Mistroke
.58727 .59682 L
.58728 .59677 L
.58728 .59673 L
.58728 .5967 L
.58728 .59667 L
.58727 .59662 L
.58726 .5966 L
.58725 .59657 L
.58723 .59651 L
.5872 .59646 L
.58716 .59641 L
.58707 .59631 L
.58681 .59609 L
.5864 .59584 L
.58532 .59538 L
.58396 .59493 L
.58205 .59442 L
.5769 .59336 L
.5707 .59236 L
.56258 .59129 L
.55372 .59032 L
.5429 .58936 L
.53154 .58855 L
.5207 .58795 L
.51516 .58771 L
.50911 .58749 L
.50578 .58739 L
.5027 .58732 L
.49979 .58726 L
.49819 .58723 L
.49667 .58721 L
.49523 .58719 L
.49367 .58718 L
.49299 .58717 L
.49226 .58717 L
.49163 .58716 L
.49096 .58716 L
.49028 .58716 L
.48966 .58716 L
.48906 .58716 L
.48844 .58716 L
.48776 .58716 L
.48712 .58716 L
.48642 .58716 L
.48568 .58716 L
.48488 .58717 L
.48415 .58717 L
.4825 .58719 L
.48105 .58721 L
.47952 .58723 L
Mistroke
.4769 .58728 L
.47406 .58735 L
.4686 .58753 L
.46379 .58775 L
.45848 .58808 L
.45371 .58845 L
.44947 .58885 L
.44526 .58934 L
.43856 .59036 L
.43533 .59101 L
.43229 .59177 L
.43004 .59246 L
.428 .59327 L
.4272 .59367 L
.42645 .5941 L
.4259 .59448 L
.4254 .5949 L
.42515 .59515 L
.42495 .59538 L
.4248 .5956 L
.42466 .59584 L
.42456 .59606 L
.4245 .59627 L
.42447 .59638 L
.42445 .59649 L
.42444 .5966 L
.42443 .59666 L
.42443 .59672 L
.42443 .59684 L
.42444 .59695 L
.42445 .59701 L
.42445 .59707 L
.42448 .59719 L
.42451 .59731 L
.42454 .59743 L
.42463 .59764 L
.42487 .59808 L
.42518 .59848 L
.42564 .59894 L
.42625 .59945 L
.42768 .60036 L
.42954 .60128 L
.43155 .60209 L
.43715 .60383 L
.44348 .60529 L
.4514 .60668 L
.45801 .60756 L
.46541 .60832 L
Mfstroke
.48876 .59673 m
.49138 .59701 L
.49989 .59789 L
.51234 .59907 L
.52711 .60026 L
.53598 .60084 L
.54415 .60126 L
.54818 .60142 L
.55027 .60149 L
.55248 .60155 L
.55438 .60159 L
.55538 .60161 L
.55644 .60162 L
.55741 .60163 L
.55829 .60164 L
.55871 .60164 L
.55917 .60165 L
.5596 .60165 L
.56 .60165 L
.56049 .60165 L
.56073 .60165 L
.561 .60165 L
.56148 .60165 L
.56192 .60164 L
.56244 .60164 L
.56291 .60163 L
.56396 .60162 L
.56485 .60161 L
.56581 .60159 L
.56751 .60154 L
.56911 .60148 L
.57076 .6014 L
.57356 .60122 L
.57628 .60097 L
.57893 .60064 L
.58116 .60027 L
.58294 .59988 L
.58463 .59938 L
.58589 .59885 L
.58648 .59853 L
.58693 .59822 L
.58714 .59804 L
.58734 .59784 L
.58749 .59767 L
.58762 .59747 L
.58772 .59729 L
.58779 .59711 L
.58781 .59702 L
.58783 .59693 L
.58785 .59684 L
Mistroke
.58786 .59676 L
.58786 .59671 L
.58786 .59665 L
.58786 .59655 L
.58785 .59645 L
.58784 .59636 L
.58782 .59626 L
.58779 .59614 L
.58771 .59592 L
.58759 .59568 L
.58747 .59547 L
.58708 .59498 L
.58607 .59406 L
.58467 .59311 L
.58303 .59221 L
.57808 .59011 L
.57223 .58816 L
.56435 .58603 L
.55494 .58395 L
.54527 .58219 L
.53432 .58056 L
.52355 .5793 L
.51224 .57832 L
.50618 .57793 L
.5028 .57777 L
.4997 .57764 L
.49668 .57754 L
.49515 .57751 L
.4935 .57747 L
.49264 .57746 L
.49186 .57745 L
.49106 .57744 L
.49033 .57743 L
.48992 .57743 L
.48947 .57743 L
.48902 .57742 L
.48854 .57742 L
.48813 .57742 L
.48767 .57742 L
.48725 .57742 L
.48686 .57742 L
.48617 .57743 L
.48542 .57743 L
.48473 .57744 L
.48409 .57745 L
.48254 .57747 L
.48109 .5775 L
.47822 .57758 L
.47514 .57771 L
.47239 .57785 L
Mistroke
.46985 .57801 L
.46422 .57846 L
.45896 .57903 L
.45358 .57979 L
.44889 .58061 L
.44411 .58165 L
.43992 .58277 L
.43645 .58389 L
.43036 .58649 L
.42767 .58806 L
.42557 .58963 L
.42395 .59121 L
.42324 .5921 L
.42269 .59295 L
.42228 .59374 L
.42198 .59447 L
.42185 .59486 L
.42173 .59529 L
.42168 .59553 L
.42164 .59575 L
.42161 .59596 L
.42158 .59618 L
.42156 .59639 L
.42154 .59661 L
.42153 .59682 L
.42153 .59701 L
.42153 .59724 L
.42154 .59745 L
.42155 .59756 L
.42156 .59769 L
.42158 .59791 L
.42164 .59833 L
.42173 .59877 L
.42194 .59956 L
.4223 .60049 L
.42273 .60135 L
.42406 .60333 L
.42578 .60521 L
.42782 .60698 L
.4326 .61017 L
.43903 .61334 L
.44603 .61598 L
.45484 .61849 L
.46353 .6203 L
.46384 .62036 L
Mfstroke
.48876 .59673 m
.49136 .59715 L
.49982 .59847 L
.51221 .60024 L
.52696 .60202 L
.53583 .6029 L
.54402 .60353 L
.54807 .60378 L
.55018 .60388 L
.5524 .60397 L
.55432 .60404 L
.55533 .60407 L
.5564 .60409 L
.55738 .60411 L
.55827 .60412 L
.55869 .60413 L
.55915 .60413 L
.55959 .60413 L
.55999 .60413 L
.56049 .60414 L
.56074 .60414 L
.56101 .60413 L
.56149 .60413 L
.56194 .60413 L
.56221 .60413 L
.56247 .60412 L
.56294 .60412 L
.56401 .6041 L
.56492 .60408 L
.56575 .60405 L
.56761 .60398 L
.5691 .6039 L
.5707 .60379 L
.57378 .60351 L
.57527 .60333 L
.57677 .60312 L
.57926 .60267 L
.58166 .60209 L
.58392 .60135 L
.58569 .60054 L
.58697 .59971 L
.58754 .59922 L
.58804 .59865 L
.58823 .59839 L
.58841 .5981 L
.58854 .59784 L
.58865 .59756 L
.58874 .59727 L
.58877 .59714 L
.5888 .597 L
Mistroke
.58882 .59685 L
.58884 .59672 L
.58885 .59659 L
.58885 .59647 L
.58885 .59632 L
.58884 .59616 L
.58883 .59602 L
.58881 .59587 L
.58879 .59571 L
.58875 .59553 L
.58867 .59521 L
.58856 .59491 L
.58843 .59457 L
.58811 .59395 L
.58727 .59276 L
.58602 .59141 L
.58422 .58988 L
.57925 .58665 L
.57315 .5836 L
.56506 .58034 L
.55612 .57739 L
.54511 .57441 L
.53345 .57189 L
.52222 .57 L
.51645 .56923 L
.51011 .56853 L
.50661 .56822 L
.50337 .56797 L
.5003 .56777 L
.497 .5676 L
.49537 .56753 L
.49383 .56748 L
.49233 .56744 L
.49094 .56741 L
.48963 .56739 L
.48897 .56738 L
.48825 .56737 L
.48752 .56737 L
.48674 .56737 L
.486 .56737 L
.48532 .56737 L
.48459 .56738 L
.4838 .56739 L
.48306 .5674 L
.48238 .56742 L
.48074 .56746 L
.47919 .56751 L
.47613 .56765 L
.47285 .56785 L
.46735 .56833 L
Mistroke
.46148 .56904 L
.45561 .57001 L
.45038 .57111 L
.44533 .57243 L
.44083 .57386 L
.43329 .577 L
.42988 .57884 L
.42664 .58096 L
.4219 .58513 L
.41988 .58764 L
.41901 .58901 L
.41823 .59048 L
.41767 .59179 L
.41719 .59326 L
.41702 .59391 L
.41687 .59461 L
.41677 .59521 L
.41668 .59588 L
.41664 .59624 L
.41661 .59658 L
.41659 .59695 L
.41658 .59715 L
.41658 .59734 L
.41657 .59765 L
.41657 .598 L
.41658 .59836 L
.4166 .5987 L
.41661 .59889 L
.41663 .5991 L
.41666 .59948 L
.41675 .60019 L
.41689 .60103 L
.41706 .6018 L
.41741 .60311 L
.41792 .60456 L
.4193 .60747 L
.42112 .61031 L
.42316 .61287 L
.42903 .61841 L
.4358 .62307 L
.44452 .62759 L
.45221 .63064 L
.46105 .6333 L
Mfstroke
.48876 .59673 m
.49133 .59729 L
.49971 .59905 L
.51203 .6014 L
.52673 .60379 L
.53562 .60496 L
.54384 .60582 L
.54792 .60615 L
.55005 .6063 L
.55229 .60642 L
.55423 .60651 L
.55525 .60655 L
.55634 .60659 L
.55733 .60661 L
.55823 .60663 L
.55866 .60664 L
.55913 .60665 L
.55957 .60665 L
.55998 .60665 L
.56049 .60666 L
.56074 .60666 L
.56102 .60666 L
.56151 .60666 L
.56196 .60665 L
.56224 .60665 L
.5625 .60665 L
.56298 .60664 L
.5635 .60663 L
.56406 .60662 L
.56501 .60659 L
.566 .60656 L
.56774 .60647 L
.56936 .60636 L
.57084 .60624 L
.57407 .60587 L
.57554 .60565 L
.57708 .60537 L
.57998 .60471 L
.58238 .60397 L
.58435 .60317 L
.58634 .60209 L
.58718 .60151 L
.58786 .60094 L
.58893 .5998 L
.58936 .59916 L
.58974 .59845 L
.58989 .59808 L
.59001 .59772 L
.5901 .59739 L
.59017 .59703 L
Mistroke
.59021 .59682 L
.59023 .59663 L
.59025 .59644 L
.59026 .59626 L
.59027 .59616 L
.59027 .59604 L
.59027 .59585 L
.59026 .59563 L
.59026 .59551 L
.59025 .59539 L
.59023 .5952 L
.5902 .59499 L
.59014 .59461 L
.59006 .59423 L
.58997 .59387 L
.5897 .59305 L
.58931 .59216 L
.58829 .59039 L
.58679 .58841 L
.58298 .58468 L
.57724 .58044 L
.56952 .57596 L
.55166 .56828 L
.54082 .5648 L
.5283 .56163 L
.5219 .56032 L
.51481 .55912 L
.50859 .55827 L
.50527 .55789 L
.50169 .55755 L
.49817 .55727 L
.49494 .55707 L
.49339 .557 L
.49171 .55693 L
.49012 .55688 L
.48865 .55685 L
.48786 .55684 L
.48702 .55683 L
.48622 .55682 L
.48549 .55682 L
.48468 .55682 L
.48422 .55682 L
.4838 .55683 L
.48335 .55683 L
.48294 .55683 L
.48202 .55685 L
.48112 .55687 L
.48029 .55689 L
.47843 .55696 L
.47679 .55703 L
Mistroke
.47506 .55713 L
.47195 .55735 L
.46914 .5576 L
.46292 .55836 L
.45733 .5593 L
.4522 .5604 L
.4469 .5618 L
.44154 .56356 L
.43272 .56735 L
.42831 .56982 L
.42399 .57275 L
.42068 .5755 L
.4175 .57871 L
.41503 .58182 L
.41287 .58532 L
.41189 .58731 L
.41114 .58917 L
.41055 .59096 L
.41005 .59289 L
.40972 .59466 L
.40958 .59567 L
.40952 .59613 L
.40948 .59662 L
.40945 .59704 L
.40942 .5975 L
.4094 .59792 L
.40938 .59831 L
.40937 .59877 L
.40937 .59919 L
.40938 .59968 L
.40939 .60014 L
.40941 .6006 L
.40944 .60111 L
.40948 .60164 L
.40953 .60214 L
.40977 .604 L
.40997 .60506 L
.41017 .60603 L
.41075 .60822 L
.41215 .61207 L
.41387 .61562 L
.41639 .61971 L
.41924 .62348 L
.42647 .63081 L
.43449 .63687 L
.44455 .6426 L
.45486 .64695 L
.45677 .64762 L
Mfstroke
.48876 .59673 m
.4913 .59743 L
.49958 .59962 L
.5118 .60255 L
.52645 .60555 L
.53534 .60703 L
.54361 .60812 L
.54772 .60855 L
.54988 .60873 L
.55215 .6089 L
.55411 .60902 L
.55515 .60907 L
.55625 .60912 L
.55726 .60916 L
.55818 .60919 L
.55861 .6092 L
.55909 .60921 L
.55951 .60921 L
.55996 .60922 L
.56021 .60922 L
.56049 .60922 L
.56098 .60923 L
.56125 .60923 L
.56155 .60923 L
.56182 .60923 L
.56207 .60923 L
.56256 .60922 L
.56283 .60922 L
.56308 .60921 L
.56357 .60921 L
.56403 .6092 L
.56486 .60917 L
.56577 .60914 L
.56758 .60904 L
.56853 .60898 L
.56951 .6089 L
.57124 .60873 L
.57304 .60851 L
.57494 .60822 L
.57817 .60756 L
.58087 .60681 L
.58368 .60577 L
.586 .6046 L
.5879 .60332 L
.58954 .6018 L
.59065 .60036 L
.59114 .59949 L
.59152 .59864 L
.59182 .5977 L
.59195 .59716 L
Mistroke
.592 .59689 L
.59205 .59664 L
.59208 .5964 L
.59211 .59613 L
.59213 .59589 L
.59214 .59567 L
.59215 .59542 L
.59215 .59515 L
.59215 .59501 L
.59215 .59486 L
.59214 .5946 L
.59212 .59433 L
.5921 .59408 L
.59204 .59351 L
.59195 .59301 L
.59184 .59246 L
.59159 .59151 L
.59122 .59043 L
.59011 .58799 L
.5887 .58568 L
.58419 .58024 L
.57851 .57514 L
.57065 .56955 L
.5609 .56399 L
.55073 .55926 L
.53884 .5548 L
.52702 .55131 L
.51425 .54848 L
.50734 .54735 L
.50349 .54684 L
.49995 .54645 L
.4968 .54616 L
.49337 .54591 L
.49149 .5458 L
.48974 .54572 L
.48807 .54566 L
.48715 .54563 L
.4863 .54561 L
.48557 .5456 L
.4848 .54559 L
.48403 .54558 L
.48318 .54558 L
.48245 .54558 L
.48167 .54559 L
.48093 .5456 L
.48026 .54561 L
.47941 .54563 L
.47863 .54565 L
.47685 .54571 L
.4753 .54578 L
Mistroke
.47365 .54588 L
.4703 .54613 L
.46726 .54642 L
.46053 .54733 L
.45444 .54847 L
.44883 .54982 L
.44301 .55156 L
.43708 .55375 L
.42725 .55852 L
.42228 .56165 L
.41738 .56538 L
.41358 .56888 L
.40989 .57299 L
.40698 .57698 L
.40439 .58148 L
.40319 .58406 L
.40224 .58645 L
.40148 .58877 L
.40081 .59128 L
.40034 .59356 L
.40014 .59479 L
.39996 .59612 L
.39983 .59734 L
.39979 .59788 L
.39975 .59847 L
.39971 .59899 L
.39969 .59955 L
.39967 .60014 L
.39966 .6007 L
.39965 .60104 L
.39965 .6014 L
.39966 .60205 L
.39967 .60241 L
.39967 .60275 L
.39969 .60312 L
.39971 .60352 L
.39975 .60424 L
.39979 .60493 L
.39991 .60621 L
.40006 .60746 L
.40023 .60863 L
.40072 .61127 L
.40135 .61388 L
.4022 .61671 L
.40416 .6218 L
.40659 .6267 L
.40927 .63113 L
.41632 .64016 L
.42603 .64928 L
.43695 .65688 L
Mistroke
.45022 .66365 L
.45059 .66381 L
Mfstroke
.48876 .59673 m
.49126 .59757 L
.49943 .60018 L
.51151 .6037 L
.52609 .60731 L
.535 .60911 L
.54332 .61044 L
.54747 .61097 L
.54966 .6112 L
.55196 .61141 L
.55395 .61157 L
.55613 .6117 L
.55708 .61175 L
.5581 .61179 L
.55905 .61182 L
.55992 .61184 L
.56044 .61185 L
.56094 .61185 L
.56138 .61186 L
.56186 .61186 L
.56238 .61186 L
.56264 .61186 L
.56293 .61185 L
.56344 .61185 L
.5639 .61184 L
.56438 .61183 L
.56482 .61182 L
.56565 .61179 L
.56653 .61175 L
.56749 .61169 L
.56947 .61155 L
.57153 .61133 L
.57324 .61111 L
.57507 .61081 L
.57843 .61008 L
.58129 .60923 L
.58416 .60811 L
.58686 .60669 L
.58896 .60524 L
.59086 .60348 L
.59231 .60163 L
.59333 .5998 L
.59376 .59872 L
.59396 .59811 L
.59412 .59753 L
.59434 .59648 L
.59443 .59591 L
.59447 .59561 L
.5945 .59529 L
.59451 .59511 L
Mistroke
.59453 .59494 L
.59454 .59461 L
.59455 .59443 L
.59455 .59423 L
.59456 .59404 L
.59456 .59386 L
.59455 .59354 L
.59455 .59336 L
.59454 .59319 L
.59452 .59284 L
.59449 .59246 L
.59441 .59174 L
.59431 .59104 L
.59404 .58972 L
.59369 .5884 L
.5932 .58692 L
.59185 .58382 L
.58825 .57801 L
.58285 .57166 L
.57523 .56475 L
.56641 .55836 L
.55509 .55175 L
.54267 .54597 L
.53033 .54145 L
.51664 .53768 L
.50884 .53607 L
.50135 .53488 L
.49761 .53442 L
.4941 .53406 L
.49042 .53378 L
.48847 .53366 L
.48638 .53356 L
.4846 .5335 L
.48359 .53348 L
.48266 .53346 L
.48185 .53345 L
.48095 .53345 L
.48001 .53344 L
.47913 .53345 L
.47833 .53346 L
.47748 .53347 L
.47676 .53349 L
.47596 .53351 L
.4742 .53357 L
.47255 .53365 L
.46881 .5339 L
.46671 .53409 L
.46477 .53429 L
.45754 .53529 L
.45109 .53655 L
Mistroke
.44442 .53825 L
.43805 .54029 L
.43147 .54289 L
.4204 .54863 L
.41481 .55237 L
.40919 .55688 L
.40433 .56159 L
.40039 .56619 L
.39695 .57103 L
.39377 .57655 L
.39105 .58268 L
.38997 .58577 L
.38911 .5887 L
.38839 .59173 L
.38786 .59452 L
.38743 .59766 L
.38726 .59941 L
.3872 .6002 L
.38714 .60107 L
.3871 .6019 L
.38707 .60269 L
.38705 .60352 L
.38704 .60399 L
.38704 .60441 L
.38704 .60514 L
.38705 .60593 L
.38707 .60676 L
.3871 .60753 L
.38714 .60846 L
.3872 .60933 L
.38734 .61097 L
.38753 .61274 L
.38779 .61466 L
.38835 .61785 L
.38902 .62085 L
.39103 .62765 L
.39367 .63423 L
.39722 .64119 L
.40624 .6542 L
.41722 .66557 L
.42929 .67492 L
.44194 .68235 L
Mfstroke
.48876 .59673 m
.49121 .5977 L
.49924 .60073 L
.51117 .60484 L
.52567 .60907 L
.53459 .61119 L
.54296 .61279 L
.54717 .61342 L
.55172 .61397 L
.55379 .61416 L
.55598 .61433 L
.55783 .61444 L
.55887 .61449 L
.55985 .61452 L
.56037 .61453 L
.56093 .61455 L
.56146 .61456 L
.56193 .61456 L
.56222 .61456 L
.56249 .61456 L
.56278 .61456 L
.56309 .61456 L
.56361 .61456 L
.5639 .61456 L
.56417 .61455 L
.5647 .61454 L
.56519 .61453 L
.56611 .6145 L
.5671 .61445 L
.56816 .61439 L
.56999 .61424 L
.5719 .61403 L
.57522 .61353 L
.57698 .61317 L
.57854 .6128 L
.58189 .61179 L
.58463 .61071 L
.58728 .60936 L
.58971 .60777 L
.59198 .60583 L
.59379 .60377 L
.59514 .60172 L
.59577 .60051 L
.59633 .59917 L
.59673 .59798 L
.59708 .59662 L
.59723 .59584 L
.59734 .59511 L
.5974 .59471 L
.59744 .59426 L
Mistroke
.59748 .59383 L
.5975 .59343 L
.59752 .59303 L
.59753 .59265 L
.59754 .59225 L
.59754 .59202 L
.59753 .5918 L
.59753 .59145 L
.59751 .59105 L
.59749 .59064 L
.59746 .59025 L
.59737 .58939 L
.59727 .58859 L
.59693 .58674 L
.59653 .58507 L
.59598 .58326 L
.59475 .58005 L
.59299 .57641 L
.58815 .5689 L
.581 .56065 L
.57228 .55276 L
.56125 .5448 L
.5492 .53785 L
.53707 .53225 L
.52285 .52717 L
.51464 .52489 L
.5067 .52312 L
.49893 .52179 L
.49498 .52126 L
.4906 .5208 L
.48685 .5205 L
.48474 .52037 L
.48282 .52028 L
.48102 .52022 L
.48001 .52019 L
.47907 .52018 L
.47825 .52016 L
.47734 .52016 L
.4764 .52016 L
.47551 .52016 L
.47455 .52017 L
.47352 .52019 L
.47255 .52022 L
.47167 .52024 L
.46951 .52034 L
.46747 .52045 L
.46343 .52077 L
.45906 .52125 L
.45529 .52178 L
.45132 .52246 L
Mistroke
.44429 .52398 L
.43698 .52602 L
.42935 .52871 L
.41629 .53488 L
.40956 .539 L
.40268 .54405 L
.39662 .5494 L
.39159 .55468 L
.38277 .56674 L
.37889 .57398 L
.37591 .58116 L
.37369 .58834 L
.37282 .59205 L
.37206 .59618 L
.37157 .59977 L
.37136 .6018 L
.37122 .60366 L
.37112 .60539 L
.37108 .60638 L
.37105 .60729 L
.37103 .60809 L
.37102 .60897 L
.37102 .6099 L
.37103 .61077 L
.37105 .61171 L
.37108 .61273 L
.37112 .61369 L
.37116 .61456 L
.37131 .6167 L
.3715 .61873 L
.37201 .62278 L
.37278 .62719 L
.3747 .63508 L
.37709 .64233 L
.3841 .65741 L
.38926 .66572 L
.39482 .67324 L
.40828 .68756 L
.42291 .69916 L
.43003 .70375 L
Mfstroke
.48876 .59673 m
.49116 .59783 L
.49902 .60128 L
.51078 .60596 L
.52518 .61082 L
.5341 .61328 L
.54254 .61516 L
.5468 .61591 L
.55143 .61657 L
.55354 .61681 L
.55578 .61702 L
.55767 .61716 L
.55875 .61723 L
.55975 .61728 L
.56082 .61732 L
.56139 .61733 L
.56168 .61734 L
.56199 .61735 L
.56229 .61735 L
.56256 .61735 L
.5631 .61736 L
.56359 .61736 L
.5641 .61736 L
.56457 .61736 L
.56507 .61735 L
.56554 .61734 L
.56597 .61733 L
.56701 .61729 L
.568 .61724 L
.56903 .61717 L
.57013 .61708 L
.57207 .61688 L
.57411 .6166 L
.57632 .61622 L
.58006 .61533 L
.58331 .61428 L
.58663 .61285 L
.58983 .61105 L
.5924 .60917 L
.59482 .60689 L
.59679 .60448 L
.59827 .60207 L
.59898 .60064 L
.59962 .59907 L
.60008 .59766 L
.6005 .59609 L
.60069 .59518 L
.60083 .59434 L
.60095 .59347 L
.60104 .59265 L
Mistroke
.60109 .59215 L
.60112 .59169 L
.60115 .59117 L
.60116 .59089 L
.60117 .59062 L
.60117 .59038 L
.60117 .59012 L
.60117 .58966 L
.60117 .58917 L
.60116 .58888 L
.60115 .58862 L
.60113 .58813 L
.6011 .58762 L
.60102 .58668 L
.60091 .58565 L
.60075 .58451 L
.60036 .58243 L
.59989 .58044 L
.59872 .57662 L
.59702 .5724 L
.59201 .56327 L
.58459 .55344 L
.57567 .54429 L
.56573 .53608 L
.55403 .52823 L
.53977 .52062 L
.53133 .51696 L
.5232 .51397 L
.51464 .51132 L
.50639 .50925 L
.49853 .5077 L
.49444 .50705 L
.48995 .50647 L
.48738 .50619 L
.485 .50597 L
.48276 .5058 L
.48028 .50565 L
.47921 .5056 L
.47806 .50555 L
.47706 .50551 L
.47597 .50548 L
.4748 .50545 L
.47417 .50544 L
.47357 .50544 L
.47251 .50543 L
.47137 .50543 L
.47026 .50544 L
.46962 .50545 L
.46903 .50546 L
.46783 .50549 L
Mistroke
.46655 .50553 L
.46422 .50564 L
.4621 .50577 L
.45694 .50621 L
.45205 .5068 L
.4434 .50827 L
.43409 .51051 L
.42514 .51336 L
.41723 .5165 L
.40047 .52546 L
.38659 .53599 L
.38012 .54224 L
.37364 .54972 L
.36363 .56497 L
.35929 .57407 L
.356 .58299 L
.35468 .58753 L
.35345 .59256 L
.35257 .59708 L
.35184 .60194 L
.35159 .60406 L
.35136 .60637 L
.35117 .60891 L
.3511 .61005 L
.35104 .61131 L
.351 .61246 L
.35097 .61354 L
.35095 .61468 L
.35094 .6159 L
.35095 .61704 L
.35096 .61812 L
.35098 .61909 L
.35101 .62014 L
.35106 .62138 L
.35112 .62251 L
.35129 .62505 L
.3515 .62741 L
.35174 .62966 L
.35243 .63471 L
.35345 .64022 L
.35629 .65133 L
.35988 .66157 L
.36464 .67218 L
.37004 .68196 L
.38248 .69948 L
.3976 .71539 L
.41386 .72847 L
Mfstroke
.48876 .59673 m
.49109 .59796 L
.49878 .60182 L
.51034 .60707 L
.52461 .61257 L
.53354 .61538 L
.54204 .61755 L
.54636 .61844 L
.55107 .61922 L
.55323 .61952 L
.55552 .61978 L
.55762 .61997 L
.5596 .62011 L
.56065 .62017 L
.56121 .62019 L
.56179 .62022 L
.56234 .62023 L
.56283 .62025 L
.56332 .62026 L
.56378 .62026 L
.56433 .62027 L
.5649 .62027 L
.56539 .62026 L
.56592 .62026 L
.56649 .62024 L
.5671 .62023 L
.5682 .62018 L
.56922 .62013 L
.57031 .62005 L
.57228 .61986 L
.57418 .61962 L
.5759 .61935 L
.57975 .61854 L
.5832 .61753 L
.58679 .61613 L
.5904 .61429 L
.59337 .61233 L
.59631 .60986 L
.59901 .60691 L
.60114 .60383 L
.60205 .60219 L
.60293 .60032 L
.6036 .5986 L
.60421 .5967 L
.60467 .59493 L
.60488 .59397 L
.60507 .59291 L
.60521 .59193 L
.60533 .59102 L
.60542 .59009 L
Mistroke
.60548 .5892 L
.60551 .58867 L
.60553 .58838 L
.60554 .58808 L
.60555 .58753 L
.60556 .58701 L
.60556 .58652 L
.60555 .58605 L
.60554 .58553 L
.60552 .58498 L
.6055 .58438 L
.60545 .58373 L
.60536 .58253 L
.60523 .58135 L
.60508 .58025 L
.60428 .57595 L
.60372 .57372 L
.60298 .57122 L
.59888 .56115 L
.5957 .55531 L
.59223 .54991 L
.5834 .53876 L
.57319 .52864 L
.56077 .51877 L
.54736 .51028 L
.5308 .50213 L
.51441 .49616 L
.50537 .49368 L
.49554 .49158 L
.48696 .49025 L
.48202 .48969 L
.47737 .4893 L
.47478 .48914 L
.47236 .48903 L
.4711 .48899 L
.46971 .48895 L
.46901 .48894 L
.46825 .48893 L
.46754 .48892 L
.46688 .48892 L
.46567 .48892 L
.46455 .48893 L
.46332 .48895 L
.462 .48898 L
.46061 .48902 L
.4593 .48907 L
.45684 .4892 L
.45456 .48935 L
.45214 .48955 L
.44779 .49001 L
Mistroke
.44312 .49064 L
.438 .4915 L
.42777 .49376 L
.41854 .49648 L
.40797 .50045 L
.39844 .50489 L
.38135 .5153 L
.36451 .5296 L
.35023 .54663 L
.33977 .56433 L
.33524 .57467 L
.33182 .58463 L
.32893 .59599 L
.32783 .60187 L
.32735 .605 L
.32691 .60843 L
.32657 .61167 L
.32632 .61468 L
.32614 .61757 L
.32607 .61904 L
.32604 .61983 L
.32602 .62066 L
.32598 .62213 L
.32596 .62347 L
.32595 .62492 L
.32596 .62651 L
.32598 .62789 L
.32601 .62937 L
.32606 .63077 L
.32611 .63204 L
.32631 .63536 L
.32655 .63843 L
.32734 .6454 L
.32832 .65158 L
.32963 .65813 L
.33275 .66999 L
.33719 .68269 L
.34806 .70521 L
.35565 .71729 L
.36518 .73 L
.3858 .75153 L
.39208 .75694 L
Mfstroke
.48876 .59673 m
.49103 .59808 L
.49851 .60234 L
.50985 .60817 L
.52398 .61432 L
.5329 .61749 L
.54146 .61997 L
.54584 .621 L
.55064 .62193 L
.55285 .62229 L
.5552 .62261 L
.55735 .62285 L
.5594 .62304 L
.56048 .62312 L
.56166 .62319 L
.56274 .62324 L
.56321 .62326 L
.56373 .62327 L
.56404 .62328 L
.56433 .62329 L
.5649 .6233 L
.56542 .6233 L
.56596 .6233 L
.56655 .6233 L
.5671 .62329 L
.56769 .62328 L
.56833 .62326 L
.56939 .62322 L
.57054 .62315 L
.57162 .62307 L
.57261 .62298 L
.57447 .62277 L
.57643 .62249 L
.58041 .62169 L
.58259 .62112 L
.58455 .62051 L
.59153 .61749 L
.59495 .61539 L
.5979 .61313 L
.60102 .61012 L
.60363 .6069 L
.60583 .60342 L
.6078 .59927 L
.60852 .59732 L
.60918 .59517 L
.60969 .59313 L
.61009 .59113 L
.61027 .59002 L
.61044 .58879 L
.61057 .58765 L
Mistroke
.61066 .58659 L
.6107 .58599 L
.61074 .58532 L
.61076 .58496 L
.61077 .58462 L
.61079 .58395 L
.6108 .58337 L
.61081 .58274 L
.6108 .58207 L
.61079 .58144 L
.61077 .58084 L
.61075 .58019 L
.61068 .57899 L
.61059 .57782 L
.61048 .57672 L
.61017 .57419 L
.60971 .57146 L
.60846 .56606 L
.60657 .56006 L
.60168 .54887 L
.59408 .53631 L
.58352 .52314 L
.57127 .51124 L
.55791 .50089 L
.5409 .49055 L
.52372 .48262 L
.51452 .47926 L
.50443 .47623 L
.49298 .47356 L
.48734 .47253 L
.48213 .47176 L
.47676 .47112 L
.47161 .47067 L
.46878 .47048 L
.46614 .47035 L
.46476 .4703 L
.46323 .47026 L
.46247 .47024 L
.46164 .47023 L
.46014 .47021 L
.45883 .47021 L
.4576 .47021 L
.45626 .47023 L
.45482 .47026 L
.45331 .4703 L
.45188 .47035 L
.4492 .47048 L
.44669 .47065 L
.44436 .47083 L
.4391 .47136 L
Mistroke
.43372 .47208 L
.42793 .47305 L
.4175 .47533 L
.4052 .47895 L
.39413 .48313 L
.3735 .4936 L
.35258 .50862 L
.33481 .52627 L
.31879 .54852 L
.31223 .56065 L
.3062 .57457 L
.30161 .58842 L
.29839 .60171 L
.2972 .60835 L
.29619 .61558 L
.2958 .61912 L
.2955 .6225 L
.29528 .62555 L
.2951 .62888 L
.29503 .63078 L
.29498 .63256 L
.29494 .63452 L
.29493 .63562 L
.29492 .63664 L
.29493 .63857 L
.29494 .63966 L
.29496 .64068 L
.29498 .64177 L
.29501 .64275 L
.29509 .64496 L
.29519 .6469 L
.29529 .64868 L
.29558 .65273 L
.29635 .66011 L
.29737 .66731 L
.29878 .67507 L
.30216 .68913 L
.30759 .70584 L
.31392 .72098 L
.32983 .74952 L
.35267 .77881 L
.36302 .78943 L
Mfstroke
.48876 .59673 m
.49095 .5982 L
.49822 .60285 L
.5093 .60924 L
.52326 .61605 L
.53217 .61961 L
.5408 .62242 L
.54524 .62361 L
.55013 .6247 L
.5548 .62552 L
.55706 .62583 L
.55913 .62606 L
.56135 .62626 L
.56257 .62634 L
.56373 .6264 L
.56425 .62643 L
.5648 .62645 L
.56528 .62646 L
.56579 .62647 L
.5664 .62648 L
.56697 .62649 L
.56752 .62649 L
.56803 .62648 L
.56859 .62647 L
.5692 .62646 L
.56977 .62644 L
.57028 .62642 L
.57155 .62636 L
.57274 .62628 L
.5751 .62605 L
.57763 .6257 L
.57983 .62531 L
.58187 .62487 L
.58642 .62359 L
.59067 .62195 L
.59503 .61974 L
.59863 .61741 L
.6023 .61445 L
.60582 .61085 L
.60867 .60715 L
.61117 .60304 L
.61315 .59879 L
.61484 .59394 L
.61559 .59104 L
.61615 .58827 L
.61654 .58571 L
.61671 .58424 L
.61684 .58288 L
.61693 .5816 L
.61697 .58087 L
Mistroke
.617 .58019 L
.61702 .57953 L
.61703 .57893 L
.61704 .57823 L
.61705 .57757 L
.61704 .57685 L
.61703 .57605 L
.61702 .57565 L
.617 .57521 L
.61697 .57443 L
.61688 .57289 L
.61677 .57148 L
.61661 .56981 L
.61639 .56798 L
.61586 .56461 L
.61452 .55834 L
.61241 .55123 L
.60951 .54362 L
.6061 .53636 L
.59736 .52178 L
.58699 .50854 L
.57405 .49544 L
.55727 .48214 L
.53895 .47093 L
.51702 .46102 L
.50548 .45709 L
.49246 .45362 L
.48632 .45231 L
.47972 .45115 L
.47345 .45026 L
.46766 .44963 L
.46472 .44937 L
.4615 .44915 L
.45844 .44898 L
.45708 .44893 L
.4556 .44888 L
.45405 .44883 L
.45259 .44881 L
.45174 .4488 L
.45085 .44879 L
.44925 .44879 L
.44757 .4488 L
.446 .44882 L
.44428 .44887 L
.44244 .44893 L
.43934 .44907 L
.43597 .44929 L
.42984 .44983 L
.42385 .45056 L
.41831 .4514 L
Mistroke
.4055 .45401 L
.39353 .4573 L
.38052 .46187 L
.36675 .46792 L
.34056 .48343 L
.31762 .50251 L
.29756 .52538 L
.28184 .54999 L
.27428 .56551 L
.26826 .58098 L
.26383 .59551 L
.26179 .60388 L
.26016 .61184 L
.25874 .62048 L
.25773 .62848 L
.25728 .63309 L
.25694 .6375 L
.25667 .64217 L
.25657 .64483 L
.25652 .64611 L
.25649 .64729 L
.25645 .6495 L
.25643 .65188 L
.25642 .65399 L
.25645 .65622 L
.25646 .6574 L
.25649 .65867 L
.25656 .66096 L
.25667 .66369 L
.25679 .66617 L
.25713 .67118 L
.25761 .67664 L
.25882 .68659 L
.26033 .6959 L
.26208 .70464 L
.26731 .72459 L
.2741 .744 L
.28329 .76468 L
.30208 .79693 L
.32457 .82604 L
Mfstroke
.48876 .59673 m
.49087 .59832 L
.49789 .60335 L
.5087 .6103 L
.52247 .61777 L
.53136 .62173 L
.54004 .6249 L
.54454 .62626 L
.54952 .62753 L
.55431 .6285 L
.55877 .62918 L
.56107 .62945 L
.56234 .62956 L
.56355 .62966 L
.56467 .62973 L
.56526 .62976 L
.56589 .62979 L
.56647 .62981 L
.567 .62982 L
.56753 .62983 L
.56803 .62984 L
.56862 .62985 L
.56927 .62985 L
.56959 .62984 L
.56994 .62984 L
.57058 .62983 L
.57121 .62981 L
.5718 .62979 L
.57291 .62974 L
.57422 .62965 L
.57543 .62955 L
.57815 .62924 L
.58039 .62889 L
.58279 .62843 L
.58705 .62734 L
.59198 .62561 L
.59634 .6236 L
.60414 .61856 L
.60816 .615 L
.6116 .61122 L
.61486 .60676 L
.61756 .60209 L
.61965 .59753 L
.62153 .59222 L
.62294 .58664 L
.62354 .58331 L
.62397 .5801 L
.62414 .57833 L
.62427 .57662 L
.62436 .57507 L
Mistroke
.62439 .57418 L
.62442 .57335 L
.62443 .57288 L
.62443 .57237 L
.62444 .57189 L
.62444 .57145 L
.62444 .5706 L
.62442 .5697 L
.62441 .56923 L
.6244 .56872 L
.62436 .56781 L
.62431 .56672 L
.62425 .56571 L
.62395 .56221 L
.62375 .56042 L
.62348 .55843 L
.62222 .55146 L
.62127 .54745 L
.62006 .54308 L
.61733 .53502 L
.60975 .51855 L
.59863 .50109 L
.58521 .48505 L
.57013 .47088 L
.55042 .45641 L
.53002 .44498 L
.50663 .43534 L
.49251 .43107 L
.48604 .42946 L
.47897 .42796 L
.4719 .42671 L
.46535 .42576 L
.45868 .42501 L
.45228 .42449 L
.44864 .42429 L
.4468 .4242 L
.44476 .42413 L
.44302 .42409 L
.44114 .42405 L
.43936 .42403 L
.43772 .42403 L
.4358 .42405 L
.434 .42407 L
.43296 .4241 L
.43202 .42412 L
.4299 .42419 L
.42785 .42428 L
.42563 .4244 L
.42158 .42468 L
.41418 .42538 L
Mistroke
.40722 .42627 L
.39956 .42753 L
.3913 .4292 L
.37445 .43366 L
.35912 .43901 L
.33066 .45255 L
.30111 .47252 L
.27531 .49652 L
.2512 .52733 L
.24095 .54434 L
.23122 .56405 L
.22405 .58213 L
.21764 .60299 L
.21516 .61319 L
.21293 .62435 L
.21123 .63508 L
.21003 .64503 L
.20949 .65093 L
.2091 .65644 L
.20892 .65957 L
.20879 .66252 L
.20868 .66561 L
.20863 .66726 L
.2086 .66903 L
.20856 .67184 L
.20855 .67343 L
.20855 .67491 L
.20856 .67649 L
.20858 .67792 L
.2086 .67958 L
.20864 .68114 L
.20872 .68394 L
.20881 .68652 L
.20912 .69237 L
.20952 .69802 L
.20998 .70319 L
.21137 .71491 L
.21307 .72583 L
.21507 .73625 L
.22093 .75967 L
.22953 .78522 L
.24794 .82524 L
.27414 .86653 L
Mfstroke
.48876 .59673 m
.49078 .59843 L
.49755 .60383 L
.50804 .61133 L
.5216 .61948 L
.53045 .62385 L
.53918 .6274 L
.54374 .62895 L
.54881 .63042 L
.55368 .63157 L
.55832 .63241 L
.56064 .63274 L
.56315 .63303 L
.56458 .63316 L
.56595 .63325 L
.56717 .63332 L
.56782 .63335 L
.56851 .63338 L
.5689 .63339 L
.56925 .6334 L
.56958 .6334 L
.56995 .63341 L
.57058 .63341 L
.57125 .63341 L
.57163 .63341 L
.57198 .63341 L
.57238 .6334 L
.57276 .63339 L
.57343 .63337 L
.57416 .63334 L
.57548 .63327 L
.57689 .63316 L
.5794 .63291 L
.58191 .63255 L
.5842 .63214 L
.58932 .6309 L
.59374 .62944 L
.59829 .6275 L
.60277 .62511 L
.60736 .62207 L
.61498 .61529 L
.61881 .61078 L
.62255 .6053 L
.6254 .60007 L
.62808 .59381 L
.6302 .58721 L
.63169 .5806 L
.63231 .57678 L
.63273 .57319 L
.6329 .57116 L
Mistroke
.63298 .57008 L
.63304 .56892 L
.6331 .5678 L
.63313 .56677 L
.63316 .56574 L
.63317 .56476 L
.63317 .56383 L
.63317 .56283 L
.63316 .56188 L
.63314 .56101 L
.6331 .55998 L
.63306 .55886 L
.63294 .55681 L
.63277 .55464 L
.63255 .55231 L
.63201 .54807 L
.63065 .54039 L
.62849 .53168 L
.6255 .52238 L
.62206 .51372 L
.61179 .49394 L
.59931 .47604 L
.58218 .45713 L
.56256 .44037 L
.53808 .42446 L
.52481 .41762 L
.50955 .41106 L
.49566 .40618 L
.47969 .40175 L
.47194 .40003 L
.46346 .39845 L
.45601 .39733 L
.44778 .39636 L
.4429 .39593 L
.43835 .39561 L
.43397 .39538 L
.43175 .3953 L
.43055 .39526 L
.42928 .39523 L
.42707 .39519 L
.42503 .39517 L
.42283 .39517 L
.42157 .39517 L
.42041 .39519 L
.41828 .39522 L
.41635 .39527 L
.4141 .39535 L
.41198 .39544 L
.40782 .39567 L
.40391 .39596 L
Mistroke
.39496 .39684 L
.38619 .39802 L
.3767 .39966 L
.35945 .40361 L
.34365 .40837 L
.30983 .42247 L
.29107 .43284 L
.27409 .44405 L
.24092 .47192 L
.21373 .50274 L
.18944 .54 L
.17783 .56327 L
.16867 .58603 L
.16124 .60945 L
.15578 .63228 L
.15333 .64579 L
.15154 .65833 L
.15074 .66536 L
.15002 .67307 L
.1495 .68042 L
.14931 .68375 L
.14915 .68727 L
.14903 .69046 L
.14893 .69396 L
.14887 .69715 L
.14884 .70012 L
.14884 .70366 L
.14886 .70688 L
.14889 .70867 L
.14893 .71061 L
.14902 .71414 L
.14913 .71722 L
.14929 .72061 L
.14969 .7275 L
.15018 .7339 L
.15074 .73992 L
.15257 .75492 L
.15478 .76873 L
.16171 .80006 L
.17002 .82757 L
.17967 .85306 L
.20861 .91015 L
Mfstroke
.48876 .59673 m
.49069 .59854 L
.49717 .60429 L
.50734 .61234 L
.52065 .62118 L
.52944 .62597 L
.53821 .62993 L
.54282 .63168 L
.54799 .63337 L
.55297 .63472 L
.55774 .63575 L
.56275 .63654 L
.56544 .63684 L
.56695 .63698 L
.56835 .63707 L
.56905 .63711 L
.5698 .63715 L
.57044 .63717 L
.57114 .63719 L
.57158 .6372 L
.57197 .63721 L
.57235 .63722 L
.57275 .63722 L
.57345 .63722 L
.57384 .63722 L
.57421 .63721 L
.57456 .63721 L
.57494 .6372 L
.57563 .63718 L
.5763 .63715 L
.57692 .63712 L
.57833 .63704 L
.57982 .63692 L
.5825 .63663 L
.58495 .63626 L
.59046 .63512 L
.59526 .63371 L
.60024 .6318 L
.6052 .6294 L
.61034 .62631 L
.61905 .61933 L
.62353 .61462 L
.62801 .60886 L
.63152 .60333 L
.63495 .59666 L
.63781 .58958 L
.64 .58247 L
.64099 .57841 L
.64178 .57444 L
.64251 .56971 L
Mistroke
.64279 .56743 L
.64301 .56526 L
.64318 .56314 L
.64325 .56202 L
.64332 .56082 L
.64337 .55981 L
.64341 .55869 L
.64344 .55767 L
.64346 .55671 L
.64347 .55613 L
.64348 .5555 L
.64348 .55434 L
.64347 .55321 L
.64346 .55217 L
.64343 .55103 L
.64338 .54976 L
.64333 .54844 L
.64326 .54719 L
.64311 .54503 L
.64292 .54275 L
.64247 .53861 L
.64183 .5341 L
.64095 .52908 L
.6385 .51849 L
.63551 .50865 L
.62601 .48606 L
.61373 .46512 L
.59641 .44284 L
.57582 .42255 L
.5498 .40297 L
.52173 .38721 L
.49237 .37528 L
.4744 .36994 L
.46524 .36773 L
.45658 .36596 L
.44877 .3646 L
.44 .36336 L
.43105 .36239 L
.42608 .36197 L
.42138 .36166 L
.41909 .36154 L
.41662 .36143 L
.41449 .36135 L
.41216 .36129 L
.41074 .36126 L
.40942 .36123 L
.40682 .36121 L
.40445 .3612 L
.40194 .36122 L
.39948 .36126 L
Mistroke
.39682 .36133 L
.39431 .36142 L
.39201 .36151 L
.38635 .36183 L
.38095 .36224 L
.37151 .3632 L
.36268 .36439 L
.34249 .36813 L
.32017 .37398 L
.2991 .38123 L
.26002 .39947 L
.21914 .42626 L
.18378 .45754 L
.15098 .49599 L
.13406 .52099 L
.12009 .54557 L
.10824 .57044 L
.09711 .59911 L
.0875 .63113 L
.08368 .64739 L
.08063 .66298 L
.07815 .67884 L
.07636 .69364 L
.0756 .70175 L
.07495 .71035 L
.07447 .71907 L
.07427 .72403 L
.07419 .72644 L
.07413 .72867 L
.07404 .73319 L
.07401 .73558 L
.07399 .73811 L
.07399 .74237 L
.07401 .7448 L
.07404 .74708 L
.07413 .75133 L
.07424 .75522 L
.07441 .75973 L
.07461 .76402 L
.07521 .77355 L
.07593 .78244 L
.07822 .80273 L
.08107 .82119 L
.08499 .84129 L
.09441 .87798 L
.10653 .9139 L
.12029 .94688 L
.1243 .95547 L
Mfstroke
.48876 .59673 m
.49059 .59864 L
.49677 .60473 L
.50658 .61332 L
.51961 .62285 L
.52833 .62809 L
.53712 .63248 L
.54703 .63638 L
.55172 .63784 L
.55704 .63919 L
.56236 .64021 L
.56532 .64064 L
.56675 .64081 L
.56812 .64095 L
.56938 .64106 L
.57076 .64115 L
.57202 .64122 L
.57258 .64124 L
.57319 .64127 L
.57391 .64129 L
.57459 .6413 L
.57525 .6413 L
.57586 .64131 L
.57652 .6413 L
.57724 .64129 L
.578 .64127 L
.57871 .64125 L
.57944 .64122 L
.58022 .64118 L
.58162 .64109 L
.58313 .64096 L
.5848 .64078 L
.58779 .64036 L
.5906 .63986 L
.59582 .63861 L
.60141 .63681 L
.60691 .63452 L
.6128 .63142 L
.61885 .62745 L
.62414 .62321 L
.63373 .61315 L
.63848 .6066 L
.64256 .59976 L
.64603 .59262 L
.64921 .58444 L
.65147 .57696 L
.65343 .56822 L
.65425 .56329 L
.65485 .55847 L
.65525 .55404 L
Mistroke
.65542 .55149 L
.65553 .5491 L
.65557 .54774 L
.65559 .54697 L
.65561 .54626 L
.65562 .54494 L
.65563 .54355 L
.65562 .54229 L
.65561 .54111 L
.65558 .53981 L
.65554 .5384 L
.65548 .5369 L
.65539 .53526 L
.65519 .53224 L
.65494 .52928 L
.65465 .52652 L
.65397 .52124 L
.65303 .51547 L
.65076 .50483 L
.64706 .49186 L
.64268 .47975 L
.63144 .45609 L
.61471 .43022 L
.59436 .40635 L
.56771 .38243 L
.5353 .36065 L
.51872 .35185 L
.50006 .3435 L
.48184 .33679 L
.46078 .33063 L
.45121 .32837 L
.44073 .32624 L
.43139 .32466 L
.42128 .32327 L
.4157 .32264 L
.40947 .32206 L
.40369 .32162 L
.39835 .32132 L
.39528 .32118 L
.39203 .32106 L
.39045 .32102 L
.38875 .32098 L
.38689 .32095 L
.38515 .32093 L
.38353 .32091 L
.38177 .32091 L
.38011 .32092 L
.37857 .32093 L
.37565 .32097 L
.37255 .32105 L
Mistroke
.3696 .32114 L
.36689 .32125 L
.36077 .32159 L
.35506 .322 L
.34962 .32248 L
.33735 .32389 L
.32384 .32596 L
.29819 .33141 L
.27472 .33816 L
.24752 .34819 L
.22198 .3599 L
.17239 .38972 L
.12881 .42519 L
.08766 .46944 L
.04791 .52726 L
.01715 .59048 L
.00341 .62935 L
Mfstroke
.00341 .62935 m
0 .6421 L
s
0 .94407 m
.00355 .95819 L
.01703 1.00009 L
s
.48876 .59673 m
.49048 .59874 L
.49635 .60516 L
.50577 .61427 L
.51848 .6245 L
.52711 .63021 L
.53591 .63505 L
.54593 .63945 L
.55618 .64273 L
.56167 .644 L
.56475 .64456 L
.56767 .64499 L
.57018 .64528 L
.57291 .64551 L
.57366 .64556 L
.57448 .64561 L
.5752 .64564 L
.57597 .64567 L
.57674 .64569 L
.57743 .64571 L
.57814 .64572 L
.5788 .64572 L
.57951 .64572 L
.58028 .64571 L
.581 .64569 L
.58167 .64567 L
.58244 .64564 L
.58329 .6456 L
.58484 .6455 L
.58646 .64536 L
.58818 .64518 L
.5913 .64476 L
.59683 .6437 L
.60296 .64204 L
.60932 .63974 L
.6151 .63709 L
.62174 .63332 L
.62778 .62913 L
.63859 .6194 L
.64426 .61285 L
.64926 .60594 L
.65376 .59852 L
.65814 .58971 L
.6616 .58109 L
.66437 .57246 L
.66674 .56281 L
.66775 .55745 L
.66863 .55153 L
.669 .54849 L
.66933 .54514 L
Mistroke
.66958 .54193 L
.66968 .54037 L
.66976 .53891 L
.66982 .53745 L
.66988 .53588 L
.66992 .53443 L
.66994 .5331 L
.66996 .53165 L
.66996 .53004 L
.66996 .52923 L
.66995 .52836 L
.66992 .52678 L
.66988 .52527 L
.66982 .52359 L
.66966 .52017 L
.66944 .51696 L
.66918 .51393 L
.66841 .50701 L
.66728 .49943 L
.66433 .48521 L
.66061 .47186 L
.65021 .4449 L
.63389 .41498 L
.61333 .3869 L
.58567 .35815 L
.55127 .33121 L
.51313 .3091 L
.49276 .29988 L
.4699 .29137 L
.4473 .28467 L
.42574 .27975 L
.41431 .27769 L
.40162 .27583 L
.39455 .27499 L
.38794 .27432 L
.38116 .27376 L
.37473 .27333 L
.36924 .27306 L
.36639 .27295 L
.36327 .27285 L
.36002 .27277 L
.35659 .27272 L
.3534 .2727 L
.35042 .2727 L
.34701 .27274 L
.34377 .27279 L
.34085 .27287 L
.33767 .27298 L
.33051 .27331 L
.32386 .27373 L
Mistroke
.3105 .27492 L
.29598 .27671 L
.26938 .28136 L
.25297 .28512 L
.23727 .28936 L
.20761 .29913 L
.14781 .32626 L
.09323 .36081 L
.03497 .41053 L
Mfstroke
.03497 .41053 m
0 .45029 L
s
.48876 .59673 m
.49037 .59883 L
.49591 .60556 L
.5049 .61519 L
.51726 .62612 L
.52578 .6323 L
.53456 .63763 L
.54468 .64257 L
.55514 .64638 L
.56081 .64793 L
.564 .64864 L
.56704 .64921 L
.56988 .64965 L
.57251 .64997 L
.57547 .65025 L
.57712 .65036 L
.5787 .65044 L
.57951 .65047 L
.57993 .65048 L
.58038 .6505 L
.58121 .65051 L
.58198 .65052 L
.58272 .65052 L
.58341 .65051 L
.58416 .6505 L
.58498 .65048 L
.58585 .65045 L
.5868 .65041 L
.58853 .6503 L
.59023 .65017 L
.5918 .65001 L
.59467 .64966 L
.59785 .64915 L
.60433 .64773 L
.61128 .64562 L
.61765 .64312 L
.62506 .63947 L
.63186 .63535 L
.64428 .62561 L
.65692 .61184 L
.6628 .60357 L
.66794 .59496 L
.67623 .57678 L
.67977 .5662 L
.68281 .55424 L
.68479 .54342 L
.68564 .53702 L
.68624 .53089 L
.68649 .52743 L
.68667 .52419 L
Mistroke
.68675 .5223 L
.68681 .52058 L
.68683 .51963 L
.68686 .51859 L
.68687 .51761 L
.68688 .5167 L
.68689 .51504 L
.68689 .51348 L
.68687 .51177 L
.68683 .50992 L
.68681 .50899 L
.68678 .50797 L
.68671 .50612 L
.68653 .50262 L
.68632 .49937 L
.68602 .49575 L
.68522 .48834 L
.68424 .48137 L
.68311 .47473 L
.67969 .45925 L
.67481 .44256 L
.66259 .41202 L
.6442 .37893 L
.62185 .34846 L
.59063 .31573 L
.55641 .28811 L
.51511 .26267 L
.49147 .25113 L
.46372 .23995 L
.43775 .23154 L
.40838 .22421 L
.39152 .22098 L
.37576 .21857 L
.36805 .2176 L
.35956 .21669 L
.35206 .21602 L
.34389 .21543 L
.33996 .2152 L
.33579 .21499 L
.33192 .21483 L
.32829 .21471 L
.32488 .21463 L
.32121 .21456 L
.31713 .21452 L
.3134 .21452 L
.31127 .21453 L
.309 .21455 L
.30492 .21462 L
.30052 .21473 L
.29565 .2149 L
Mistroke
.28689 .21533 L
.27862 .21589 L
.26049 .21761 L
.24371 .2198 L
.22411 .2231 L
.20528 .22703 L
.17081 .23614 L
.13366 .24882 L
.06647 .27978 L
Mfstroke
.06647 .27978 m
0 .32283 L
s
.48876 .59673 m
.49026 .59891 L
.49544 .60594 L
.50399 .61607 L
.51595 .62771 L
.52433 .63438 L
.53306 .64022 L
.54338 .64579 L
.55392 .65013 L
.5595 .65191 L
.56566 .65348 L
.57209 .65467 L
.57584 .65517 L
.57769 .65536 L
.57942 .6555 L
.58107 .65561 L
.58192 .65565 L
.58285 .6557 L
.58338 .65571 L
.58387 .65573 L
.58432 .65574 L
.58483 .65575 L
.58571 .65576 L
.58619 .65577 L
.58664 .65577 L
.58754 .65576 L
.5884 .65575 L
.58917 .65573 L
.59002 .6557 L
.59094 .65567 L
.59192 .65562 L
.59368 .6555 L
.59698 .6552 L
.6001 .6548 L
.60355 .65424 L
.6073 .65349 L
.61448 .65161 L
.6224 .64884 L
.6307 .64512 L
.63839 .64085 L
.65355 .62978 L
.66665 .6167 L
.67904 .60005 L
.68484 .59018 L
.69063 .57832 L
.69514 .56702 L
.69929 .55399 L
.70124 .54641 L
.7028 .53924 L
.70406 .53223 L
Mistroke
.70517 .52456 L
.70564 .52057 L
.70602 .51676 L
.70632 .51301 L
.70655 .50952 L
.70672 .50616 L
.70679 .50446 L
.70685 .50258 L
.70689 .50068 L
.70692 .49864 L
.70694 .4967 L
.70694 .49493 L
.70692 .49282 L
.7069 .49176 L
.70688 .49058 L
.70682 .48849 L
.70676 .48652 L
.70654 .48205 L
.70622 .47719 L
.70537 .46815 L
.70429 .45973 L
.70116 .44214 L
.69706 .42536 L
.69119 .40653 L
.68323 .38607 L
.66175 .34452 L
.6342 .30544 L
.59932 .26778 L
.56036 .23525 L
.51382 .20537 L
.48396 .19015 L
.45474 .17776 L
.4254 .16751 L
.39163 .1582 L
.37233 .15398 L
.35398 .15067 L
.33602 .14807 L
.32657 .14695 L
.3165 .14595 L
.30769 .14522 L
.29796 .14459 L
.29365 .14436 L
.28902 .14415 L
.28466 .14399 L
.28062 .14388 L
.27552 .14377 L
.27282 .14373 L
.26996 .14371 L
.26513 .1437 L
.26237 .14371 L
Mistroke
.25978 .14373 L
.25496 .14381 L
.25053 .14391 L
.2454 .14408 L
.2405 .14427 L
.2316 .14474 L
.22205 .1454 L
.2047 .14698 L
.1838 .14958 L
.16464 .15261 L
.12152 .16171 L
.08118 .17312 L
.0335 .19032 L
Mfstroke
.0335 .19032 m
0 .20527 L
s
.48876 .59673 m
.49014 .59899 L
.49496 .6063 L
.50303 .61692 L
.51455 .62925 L
.52276 .63644 L
.53141 .6428 L
.54177 .64899 L
.55248 .65396 L
.55809 .65603 L
.56456 .65799 L
.57137 .65958 L
.57522 .66027 L
.5789 .66078 L
.5825 .66116 L
.58457 .66132 L
.58556 .66138 L
.58651 .66143 L
.5874 .66147 L
.58838 .6615 L
.58927 .66153 L
.5901 .66154 L
.59099 .66155 L
.59198 .66155 L
.59248 .66154 L
.59301 .66154 L
.59398 .66152 L
.59494 .66149 L
.59582 .66146 L
.59784 .66136 L
.59962 .66123 L
.60153 .66106 L
.60487 .66069 L
.60859 .66014 L
.6168 .65846 L
.62446 .65628 L
.63296 .65316 L
.64197 .64899 L
.65856 .63876 L
.67363 .62611 L
.6895 .60823 L
.70257 .58838 L
.71415 .56423 L
.71959 .54898 L
.72378 .53388 L
.72544 .52647 L
.72699 .51828 L
.72813 .51101 L
.72916 .50288 L
.72966 .49785 L
Mistroke
.73005 .49311 L
.73034 .48853 L
.73046 .48616 L
.73057 .48359 L
.73065 .48103 L
.73071 .47867 L
.73074 .47639 L
.73076 .47398 L
.73075 .4718 L
.73074 .46976 L
.7307 .46751 L
.73064 .46509 L
.73056 .46273 L
.73046 .46012 L
.73017 .4548 L
.72981 .44982 L
.72939 .44511 L
.72816 .43434 L
.72637 .42253 L
.72178 .40037 L
.71602 .37953 L
.6999 .33728 L
.67446 .29012 L
.64212 .2455 L
.59818 .19941 L
.54285 .15571 L
.48074 .11935 L
.44725 .10402 L
.40941 .08971 L
.37176 .07831 L
.33558 .0698 L
.31632 .06619 L
.29486 .06287 L
.27164 .06011 L
.261 .05912 L
.24912 .05822 L
.23811 .05758 L
.22768 .05713 L
.22189 .05696 L
.21655 .05684 L
.21067 .05675 L
.20444 .05672 L
.19939 .05673 L
.19398 .05678 L
.18885 .05687 L
.18416 .05699 L
.17864 .05716 L
.17261 .0574 L
.16162 .05797 L
.14997 .05876 L
Mistroke
.13734 .05983 L
.11428 .06236 L
.08645 .06639 L
.06066 .07108 L
.00367 .08471 L
Mfstroke
.00367 .08471 m
0 .08588 L
s
.48876 .59673 m
.49002 .59906 L
.49445 .60664 L
.50201 .61771 L
.51305 .63076 L
.52106 .63845 L
.5296 .64537 L
.53996 .65223 L
.5508 .65788 L
.56319 .66266 L
.57023 .66466 L
.57429 .66559 L
.57808 .66632 L
.5815 .66686 L
.5853 .66733 L
.58742 .66753 L
.58941 .66769 L
.59132 .66781 L
.59239 .66786 L
.59338 .6679 L
.59432 .66793 L
.59532 .66795 L
.59633 .66796 L
.5969 .66796 L
.59744 .66797 L
.59842 .66796 L
.59931 .66795 L
.60034 .66792 L
.60133 .66789 L
.60315 .66782 L
.60485 .66772 L
.60875 .66739 L
.61277 .66692 L
.61718 .66625 L
.62528 .66457 L
.63511 .66175 L
.64427 .65833 L
.6621 .64937 L
.68157 .63565 L
.69949 .61857 L
.7174 .59565 L
.72546 .58263 L
.73353 .56714 L
.73984 .55259 L
.74594 .53536 L
.75093 .51736 L
.75464 .49944 L
.75625 .48911 L
.75743 .47941 L
.75796 .47394 L
Mistroke
.75843 .46789 L
.75861 .4651 L
.75877 .4621 L
.7589 .45929 L
.759 .45666 L
.75907 .45398 L
.75911 .45243 L
.75913 .45102 L
.75916 .44953 L
.75917 .44812 L
.75918 .44663 L
.75918 .445 L
.75916 .44225 L
.75912 .43933 L
.75906 .43681 L
.75898 .43403 L
.75885 .43077 L
.7587 .42778 L
.75828 .42097 L
.75779 .41489 L
.75715 .40844 L
.75393 .38541 L
.75139 .37203 L
.74853 .35941 L
.74101 .3326 L
.73186 .30675 L
.70897 .25732 L
.67515 .20336 L
.63492 .15424 L
.58446 .10608 L
.51747 .05712 L
.44292 .01663 L
Mfstroke
.44292 .01663 m
.40318 0 L
s
.48876 .59673 m
.48989 .59913 L
.49392 .60694 L
.50095 .61847 L
.51146 .63221 L
.51922 .64043 L
.52763 .64792 L
.53794 .65547 L
.54887 .66186 L
.56152 .66747 L
.56878 .66993 L
.57693 .67209 L
.58447 .67356 L
.58886 .67419 L
.59097 .67443 L
.59296 .67463 L
.59499 .6748 L
.59685 .67492 L
.59893 .67503 L
.60009 .67507 L
.60118 .6751 L
.60215 .67512 L
.60318 .67513 L
.60406 .67514 L
.60503 .67513 L
.60609 .67512 L
.60722 .6751 L
.60829 .67507 L
.60928 .67504 L
.61139 .67493 L
.61375 .67478 L
.61624 .67457 L
.61859 .67433 L
.62748 .67303 L
.63264 .672 L
.63743 .67087 L
.64842 .66758 L
.66824 .65921 L
.67966 .65288 L
.69031 .64589 L
.71195 .62802 L
.73092 .6074 L
.74917 .5815 L
.75783 .56623 L
.76659 .54791 L
.7735 .53047 L
.77999 .51036 L
.78562 .48757 L
.78786 .47595 L
.78961 .46484 L
Mistroke
.79104 .4534 L
.79219 .44088 L
.79267 .43357 L
.79285 .42995 L
.79299 .42659 L
.7931 .42352 L
.79318 .42025 L
.79323 .41695 L
.79325 .41507 L
.79326 .41331 L
.79326 .41009 L
.79325 .40827 L
.79323 .40657 L
.79317 .40346 L
.79309 .40013 L
.79299 .39714 L
.79288 .39433 L
.79254 .38787 L
.79206 .38085 L
.79152 .37435 L
.78989 .35948 L
.78797 .34611 L
.78543 .33161 L
.77947 .30489 L
.76993 .27223 L
.75881 .24188 L
.72986 .18126 L
.68669 .11473 L
.63283 .05181 L
Mfstroke
.63283 .05181 m
.57478 0 L
s
.48876 .59673 m
.48976 .59919 L
.49338 .60723 L
.49985 .61917 L
.50977 .6336 L
.51726 .64236 L
.52547 .65043 L
.53569 .65872 L
.54667 .66588 L
.55952 .67239 L
.56746 .67554 L
.57538 .67809 L
.58289 .68 L
.59139 .68161 L
.59641 .68229 L
.59894 .68256 L
.60131 .68277 L
.60366 .68294 L
.60581 .68306 L
.60706 .68311 L
.60823 .68315 L
.60948 .68318 L
.61019 .6832 L
.61084 .6832 L
.61209 .68321 L
.61328 .68321 L
.61435 .6832 L
.61553 .68318 L
.61681 .68315 L
.61818 .6831 L
.62065 .68298 L
.62295 .68283 L
.62513 .68266 L
.63016 .68213 L
.63573 .68135 L
.64091 .68043 L
.65288 .67763 L
.66413 .67412 L
.67482 .66999 L
.69964 .65722 L
.72448 .63956 L
.74677 .61874 L
.76882 .59212 L
.79076 .55705 L
.80882 .51725 L
.8165 .49481 L
.8236 .4683 L
.82641 .4551 L
.82872 .44217 L
.83051 .4301 L
Mistroke
.83206 .4169 L
.83278 .40924 L
.83332 .40222 L
.83375 .39506 L
.83406 .38824 L
.8342 .38432 L
.83425 .38217 L
.8343 .38016 L
.83436 .37658 L
.8344 .37264 L
.8344 .37042 L
.8344 .36831 L
.83436 .36434 L
.83433 .36211 L
.83429 .36005 L
.83416 .35534 L
.83403 .35167 L
.83386 .34779 L
.83349 .3408 L
.83296 .33321 L
.83225 .32482 L
.83059 .30954 L
.8286 .2951 L
.82233 .26118 L
.81283 .22378 L
.80072 .18664 L
.78409 .14547 L
.74384 .06903 L
Mfstroke
.74384 .06903 m
.69525 0 L
s
.48876 .59673 m
.48962 .59924 L
.49282 .60748 L
.49869 .61983 L
.50799 .63493 L
.51515 .64422 L
.52314 .6529 L
.54417 .66994 L
.55717 .67741 L
.56461 .68088 L
.57341 .6843 L
.58165 .68689 L
.59106 .6892 L
.59649 .69023 L
.60161 .69101 L
.60411 .69133 L
.60689 .69163 L
.60956 .69187 L
.61205 .69205 L
.61475 .6922 L
.61619 .69227 L
.61772 .69232 L
.61905 .69235 L
.62031 .69237 L
.62169 .69238 L
.62247 .69239 L
.62319 .69238 L
.62451 .69237 L
.62574 .69235 L
.6271 .69232 L
.62855 .69227 L
.63101 .69216 L
.63374 .69199 L
.63688 .69174 L
.6398 .69146 L
.64646 .69062 L
.65246 .68965 L
.65888 .68838 L
.67094 .68534 L
.6842 .68103 L
.70887 .67023 L
.73839 .65225 L
.76644 .62931 L
.79371 .60023 L
.81753 .56744 L
.83957 .52789 L
.85087 .50224 L
.86009 .47691 L
.86769 .45132 L
.87457 .42157 L
Mistroke
.87765 .40444 L
.88003 .38805 L
.88184 .37193 L
.88259 .36357 L
.88326 .35428 L
.88376 .3453 L
.88398 .34035 L
.88414 .33569 L
.88425 .3313 L
.88432 .32728 L
.88438 .32261 L
.88439 .31817 L
.88438 .31586 L
.88436 .31331 L
.88433 .31064 L
.88429 .30813 L
.88419 .30362 L
.88404 .29874 L
.88383 .29328 L
.88354 .28751 L
.88289 .27709 L
.88123 .25798 L
.87909 .23987 L
.87204 .19757 L
.86167 .15363 L
.84863 .1109 L
.81491 .02819 L
Mfstroke
.81491 .02819 m
.79916 0 L
s
.48876 .59673 m
.48949 .59928 L
.49225 .6077 L
.4975 .62043 L
.50611 .63618 L
.51291 .64601 L
.52062 .65531 L
.54136 .674 L
.55442 .68251 L
.56198 .68656 L
.57097 .69067 L
.57944 .69391 L
.58918 .69694 L
.59483 .69839 L
.60017 .69956 L
.60539 .70052 L
.61113 .70138 L
.61693 .70205 L
.62233 .70249 L
.62499 .70265 L
.6264 .70272 L
.6279 .70278 L
.62922 .70282 L
.63068 .70285 L
.63202 .70287 L
.63327 .70289 L
.63485 .70289 L
.63574 .70288 L
.63658 .70287 L
.63811 .70285 L
.63975 .70281 L
.64122 .70276 L
.64261 .7027 L
.6458 .70253 L
.64927 .70229 L
.65249 .70201 L
.65987 .70116 L
.66629 .7002 L
.67328 .69892 L
.6862 .69591 L
.70208 .69108 L
.71693 .68542 L
.74681 .67061 L
.78012 .64828 L
.81211 .62014 L
.84515 .58237 L
.87404 .53929 L
.89837 .49165 L
.9106 .4613 L
.9209 .43026 L
Mistroke
.92957 .39754 L
.93601 .36608 L
.93879 .34889 L
.9413 .32977 L
.94245 .31901 L
.94336 .30898 L
.94414 .29863 L
.94472 .28886 L
.9451 .28033 L
.94526 .27592 L
.9454 .27111 L
.94551 .2658 L
.94558 .26074 L
.94562 .25579 L
.94561 .25119 L
.94558 .24634 L
.94552 .24176 L
.94541 .23672 L
.94526 .23125 L
.94481 .22002 L
.94423 .20961 L
.94256 .18798 L
.94002 .16441 L
.93334 .12072 L
.92784 .09322 L
.92162 .06679 L
.90715 .01613 L
Mfstroke
.90715 .01613 m
.90086 0 L
s
.48876 .59673 m
.48935 .59932 L
.49166 .6079 L
.49626 .62097 L
.50413 .63736 L
.51053 .64772 L
.5179 .65763 L
.53821 .67805 L
.55126 .68765 L
.56801 .69719 L
.58668 .70496 L
.59714 .70822 L
.60948 .71117 L
.61561 .71231 L
.6216 .71322 L
.62714 .71389 L
.63334 .71445 L
.63693 .71469 L
.64024 .71485 L
.64209 .71492 L
.64307 .71495 L
.64411 .71497 L
.64502 .71499 L
.64603 .715 L
.64781 .71502 L
.64962 .71502 L
.65128 .71501 L
.6522 .715 L
.65321 .71498 L
.65505 .71493 L
.65678 .71487 L
.65863 .7148 L
.66198 .71462 L
.66544 .71438 L
.66913 .71407 L
.67582 .71336 L
.68317 .71234 L
.69139 .71094 L
.70656 .70758 L
.72116 .70344 L
.75663 .68964 L
.79039 .67141 L
.8262 .64616 L
.86525 .61056 L
.90175 .56772 L
.93812 .51217 L
.96835 .45044 L
.99203 .38352 L
s
.99203 .38352 m
1 .3527 L
s
.48876 .59673 m
.48921 .59935 L
.49106 .60806 L
.49275 .61439 L
.49498 .62144 L
.50207 .63845 L
.50776 .64891 L
.51439 .65903 L
.52371 .67076 L
.53437 .68172 L
.54774 .69285 L
.56266 .70274 L
.58024 .71179 L
.59135 .71631 L
.60275 .72013 L
.6145 .72329 L
.62102 .72472 L
.62821 .72605 L
.63508 .72709 L
.64149 .72787 L
.64465 .72818 L
.64811 .72847 L
.65144 .7287 L
.65451 .72888 L
.65808 .72903 L
.66007 .72909 L
.66197 .72913 L
.66373 .72916 L
.66537 .72917 L
.66718 .72917 L
.66912 .72916 L
.67106 .72913 L
.67217 .72911 L
.67318 .72908 L
.67704 .72895 L
.6791 .72886 L
.68138 .72874 L
.68601 .72843 L
.6949 .7276 L
.70463 .72636 L
.72279 .72312 L
.74189 .71844 L
.76344 .71161 L
.8045 .69403 L
.84698 .66928 L
.89325 .63392 L
.93646 .59156 L
.97599 .54281 L
s
.97599 .54281 m
1 .50494 L
s
.48876 .59673 m
.48907 .59937 L
.48954 .60282 L
.49045 .60819 L
.49367 .62186 L
.49639 .6304 L
.50046 .6407 L
.50569 .65146 L
.51322 .66402 L
.53353 .68868 L
.54736 .701 L
.56517 .71354 L
.58494 .72422 L
.60649 .7329 L
.62009 .73706 L
.63397 .74039 L
.64723 .74278 L
.65507 .74385 L
.66258 .74466 L
.66665 .745 L
.67101 .7453 L
.67332 .74544 L
.67587 .74556 L
.67824 .74565 L
.68041 .74572 L
.68264 .74578 L
.68477 .74581 L
.68703 .74583 L
.68831 .74583 L
.6895 .74583 L
.69149 .74582 L
.6937 .74579 L
.69603 .74574 L
.69822 .74567 L
.70243 .7455 L
.70692 .74526 L
.71508 .74465 L
.72405 .74373 L
.73411 .74241 L
.75534 .7386 L
.77546 .73374 L
.82331 .71738 L
.87001 .69486 L
.92298 .66101 L
.97496 .61821 L
s
.97496 .61821 m
1 .59193 L
s
.48876 .59673 m
.48879 .59736 L
.48892 .59939 L
.48921 .60286 L
.48983 .60829 L
.49078 .61452 L
.49242 .6226 L
.49499 .63226 L
.49854 .64265 L
.5094 .6654 L
.51773 .67833 L
.52909 .6926 L
.55744 .7185 L
.57661 .73115 L
.60121 .74356 L
.61471 .74891 L
.63068 .75412 L
.647 .75831 L
.66324 .76147 L
.67219 .76281 L
.68221 .764 L
.68693 .76444 L
.692 .76484 L
.69644 .76512 L
.70128 .76536 L
.70372 .76545 L
.70605 .76552 L
.70815 .76558 L
.71045 .76562 L
.71265 .76564 L
.71499 .76566 L
.71701 .76565 L
.71924 .76564 L
.72187 .7656 L
.7243 .76555 L
.72698 .76547 L
.72983 .76537 L
.73467 .76515 L
.74003 .76482 L
.75177 .76384 L
.76316 .76254 L
.78523 .75906 L
.81009 .75368 L
.83829 .74575 L
.89282 .72492 L
.95436 .6926 L
s
.95436 .6926 m
1 .66131 L
s
.48876 .59673 m
.48876 .59673 L
.48876 .59674 L
.48876 .59675 L
.48876 .59677 L
.48876 .59679 L
.48876 .59681 L
.48876 .59684 L
.48876 .59687 L
.48876 .59691 L
.48876 .59696 L
.48876 .59706 L
.48876 .59713 L
.48876 .59721 L
.48876 .59736 L
.48876 .59753 L
.48876 .59773 L
.48876 .59816 L
.48877 .59845 L
.48877 .59876 L
.48878 .59939 L
.4888 .60014 L
.48882 .60104 L
.48888 .60291 L
.489 .60529 L
.4892 .60835 L
.48947 .61147 L
.48982 .61463 L
.49102 .62284 L
.49281 .63164 L
.49579 .64256 L
.49993 .65421 L
.50607 .66778 L
.52299 .69469 L
.53532 .7093 L
.55196 .72524 L
.57169 .74031 L
.59689 .75531 L
.62502 .7679 L
.65546 .77773 L
.67486 .78226 L
.68493 .78414 L
.69453 .78566 L
.70335 .78681 L
.71334 .78786 L
.72369 .78867 L
.72948 .789 L
.73498 .78924 L
.73788 .78933 L
.73947 .78937 L
Mistroke
.74098 .78941 L
.74394 .78946 L
.74663 .78949 L
.74821 .7895 L
.74987 .7895 L
.75288 .78949 L
.75456 .78947 L
.75613 .78945 L
.75787 .78942 L
.75973 .78938 L
.76286 .7893 L
.76629 .78918 L
.7726 .78889 L
.77882 .78851 L
.78464 .78808 L
.79585 .78705 L
.80851 .78555 L
.83507 .78129 L
.8646 .77486 L
.89284 .76705 L
.96046 .74194 L
Mfstroke
.96046 .74194 m
1 .72197 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.29.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.29.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.29.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.29.1", "1.1"}],
    Cell[1914, 61, 521, 8, 88, "Text",
      CellTags->{"S5.29.1", "1.2"}],
    Cell[2438, 71, 377, 11, 56, "Text",
      CellTags->{"S5.29.1", "1.3"}],
    Cell[2818, 84, 3398, 108, 102, "DefinitionBox",
      CellTags->"S5.29.1"],
    Cell[6219, 194, 110, 3, 15, "Caption",
      CellTags->"S5.29.1"],
    Cell[6332, 199, 78, 1, 40, "MathCaption",
      CellTags->{"S5.29.1", "1.4"}],
    Cell[6413, 202, 85, 2, 28, "Input",
      CellTags->"S5.29.1"],
    Cell[6501, 206, 215, 9, 40, "MathCaption",
      CellTags->{"S5.29.1", "1.5"}],
    Cell[6719, 217, 99, 2, 28, "Input",
      CellTags->"S5.29.1"],
    Cell[6821, 221, 85, 1, 40, "MathCaption",
      CellTags->{"S5.29.1", "1.6"}],
    Cell[6931, 226, 105, 2, 28, "Input",
      CellTags->"S5.29.1"],
    Cell[7039, 230, 96839, 2136, 186, 15861, 1132, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.29.1"],
    Cell[103881, 2368, 180, 6, 70, "Output",
      CellTags->"S5.29.1"],
    Cell[104076, 2377, 91, 1, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.7"}],
    Cell[104192, 2382, 102, 2, 70, "Input",
      CellTags->"S5.29.1"],
    Cell[104297, 2386, 58341, 4073, 70, 58270, 4070, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.29.1"],
    Cell[162641, 6461, 180, 6, 70, "Output",
      CellTags->"S5.29.1"],
    Cell[162836, 6470, 124, 3, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.8"}],
    Cell[162985, 6477, 100, 2, 70, "Input",
      CellTags->"S5.29.1"],
    Cell[163088, 6481, 38955, 2575, 70, 38884, 2572, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.29.1"],
    Cell[202046, 9058, 180, 6, 70, "Output",
      CellTags->"S5.29.1"],
    Cell[202241, 9067, 276, 6, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.9"}],
    Cell[202542, 9077, 107, 2, 70, "Input",
      CellTags->"S5.29.1"],
    Cell[202652, 9081, 39427, 2844, 70, 39356, 2841, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.29.1"],
    Cell[242082, 11927, 180, 6, 70, "Output",
      CellTags->"S5.29.1"],
    Cell[242277, 11936, 269, 8, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.10"}],
    Cell[242571, 11948, 120, 2, 70, "Input",
      CellTags->"S5.29.1"],
    Cell[242694, 11952, 111632, 7263, 70, 111561, 7260, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.29.1"],
    Cell[354329, 19217, 180, 6, 70, "Output",
      CellTags->"S5.29.1"]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.29.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 521, 8, 88, "Text",
      CellTags->{"S5.29.1", "1.2"}]},
  "1.3"->{
    Cell[2438, 71, 377, 11, 56, "Text",
      CellTags->{"S5.29.1", "1.3"}]},
  "1.4"->{
    Cell[6332, 199, 78, 1, 40, "MathCaption",
      CellTags->{"S5.29.1", "1.4"}]},
  "1.5"->{
    Cell[6501, 206, 215, 9, 40, "MathCaption",
      CellTags->{"S5.29.1", "1.5"}]},
  "1.6"->{
    Cell[6821, 221, 85, 1, 40, "MathCaption",
      CellTags->{"S5.29.1", "1.6"}]},
  "1.7"->{
    Cell[104076, 2377, 91, 1, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.7"}]},
  "1.8"->{
    Cell[162836, 6470, 124, 3, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.8"}]},
  "1.9"->{
    Cell[202241, 9067, 276, 6, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.9"}]},
  "1.10"->{
    Cell[242277, 11936, 269, 8, 70, "MathCaption",
      CellTags->{"S5.29.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.29.1", 355160, 19243},
  {"1.1", 357779, 19311},
  {"1.2", 357873, 19314},
  {"1.3", 357961, 19317},
  {"1.4", 358050, 19320},
  {"1.5", 358145, 19323},
  {"1.6", 358241, 19326},
  {"1.7", 358336, 19329},
  {"1.8", 358434, 19332},
  {"1.9", 358533, 19335},
  {"1.10", 358633, 19338}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 36, "Subsection",
  CellTags->{"S5.29.1", "1.1"}],
Cell[1914, 61, 521, 8, 88, "Text",
  CellTags->{"S5.29.1", "1.2"}],
Cell[2438, 71, 377, 11, 56, "Text",
  CellTags->{"S5.29.1", "1.3"}],
Cell[2818, 84, 3398, 108, 102, "DefinitionBox",
  CellTags->"S5.29.1"],
Cell[6219, 194, 110, 3, 15, "Caption",
  CellTags->"S5.29.1"],
Cell[6332, 199, 78, 1, 40, "MathCaption",
  CellTags->{"S5.29.1", "1.4"}],
Cell[6413, 202, 85, 2, 28, "Input",
  CellTags->"S5.29.1"],
Cell[6501, 206, 215, 9, 40, "MathCaption",
  CellTags->{"S5.29.1", "1.5"}],
Cell[6719, 217, 99, 2, 28, "Input",
  CellTags->"S5.29.1"],
Cell[6821, 221, 85, 1, 40, "MathCaption",
  CellTags->{"S5.29.1", "1.6"}],

Cell[CellGroupData[{
Cell[6931, 226, 105, 2, 28, "Input",
  CellTags->"S5.29.1"],
Cell[7039, 230, 96839, 2136, 186, 15861, 1132, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.29.1"],
Cell[103881, 2368, 180, 6, 70, "Output",
  CellTags->"S5.29.1"]
}, Open  ]],
Cell[104076, 2377, 91, 1, 70, "MathCaption",
  CellTags->{"S5.29.1", "1.7"}],

Cell[CellGroupData[{
Cell[104192, 2382, 102, 2, 70, "Input",
  CellTags->"S5.29.1"],
Cell[104297, 2386, 58341, 4073, 70, 58270, 4070, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.29.1"],
Cell[162641, 6461, 180, 6, 70, "Output",
  CellTags->"S5.29.1"]
}, Open  ]],
Cell[162836, 6470, 124, 3, 70, "MathCaption",
  CellTags->{"S5.29.1", "1.8"}],

Cell[CellGroupData[{
Cell[162985, 6477, 100, 2, 70, "Input",
  CellTags->"S5.29.1"],
Cell[163088, 6481, 38955, 2575, 70, 38884, 2572, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.29.1"],
Cell[202046, 9058, 180, 6, 70, "Output",
  CellTags->"S5.29.1"]
}, Open  ]],
Cell[202241, 9067, 276, 6, 70, "MathCaption",
  CellTags->{"S5.29.1", "1.9"}],

Cell[CellGroupData[{
Cell[202542, 9077, 107, 2, 70, "Input",
  CellTags->"S5.29.1"],
Cell[202652, 9081, 39427, 2844, 70, 39356, 2841, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.29.1"],
Cell[242082, 11927, 180, 6, 70, "Output",
  CellTags->"S5.29.1"]
}, Open  ]],
Cell[242277, 11936, 269, 8, 70, "MathCaption",
  CellTags->{"S5.29.1", "1.10"}],

Cell[CellGroupData[{
Cell[242571, 11948, 120, 2, 70, "Input",
  CellTags->"S5.29.1"],
Cell[242694, 11952, 111632, 7263, 70, 111561, 7260, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.29.1"],
Cell[354329, 19217, 180, 6, 70, "Output",
  CellTags->"S5.29.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

