(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    175233,       7279]*)
(*NotebookOutlinePosition[    196050,       7868]*)
(*  CellTagsIndexPosition[    194554,       7807]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "DiscreteMath",
 StyleBox["`", "MB"],
 "ComputationalGeometry",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.19.1", "1.1"}],

Cell["\<\
Computational geometry is the study of efficient algorithms for solving \
geometric problems. The nearest neighbor problem involves identifying one \
point, out of a set of points, that is nearest to the query point according \
to some measure of distance. The nearest neighborhood problem involves \
identifying the locus of points lying nearer to the query point than to any \
other point in the set. This package provides functions for solving these and \
related problems in the case of planar points and the Euclidean distance \
metric. \
\>", "Text",
 CellTags->{"S5.19.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ConvexHull[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "compute the convex hull of a set of points in the plane",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DelaunayTriangulation[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "compute the Delaunay triangulation of a set of points in the plane",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VoronoiDiagram[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "compute the Voronoi diagram of a set of points in the plane",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["Computational geometry functions. ", "Caption",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "The convex hull of a set ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the boundary of the smallest set containing ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The Voronoi diagram of ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the collection of nearest neighborhoods for each of the points in ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For points in the plane, these neighborhoods are polygons. The Delaunay \
triangulation of ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a triangulation of the points in ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that no triangle contains a point of ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in its circumcircle. This is equivalent to connecting the points in ",
 Cell[BoxData[
  FormBox[
   StyleBox["S",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " according to whether their neighborhood polygons share a common side. "
}], "Text",
 CellTags->{"S5.19.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.19.1", "1.4"}],

Cell["<<DiscreteMath`ComputationalGeometry`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.19.1"],

Cell["Here is a list of points in the plane. ", "MathCaption",
 CellTags->{"S5.19.1", "1.5"}],

Cell["\<\
data2D = {{4.4, 14}, {6.7, 15.25},
 {6.9, 12.8}, {2.1, 11.1}, {9.5, 14.9},
 {13.2, 11.9}, {10.3, 12.3}, {6.8, 9.5},
 {3.3, 7.7}, {0.6, 5.1}, {5.3, 2.4},
 {8.45, 4.7}, {11.5, 9.6}, {13.8, 7.3},
 {12.9, 3.1}, {11, 1.1}};\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.19.1"],

Cell["\<\
This gives the indices of the points lying on the convex hull in \
counterclockwise order. \
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.6"}],

Cell[CellGroupData[{

Cell["convexhull = ConvexHull[data2D]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "14", ",", "6", ",", "5", ",", "2", ",", "1", ",", "4", ",", "10", ",", 
   "11", ",", "16", ",", "15"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["Duplicate points are ignored. ", "MathCaption",
 CellTags->{"S5.19.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
ConvexHull[{{0,0}, {1,0}, {0,0}, {2,0},
 {1,1}}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConvexHull", "::", "\<\"duplicated\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(1\\) duplicated point(s) ignored.\"\>"}]], "Message",\

 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "1", ",", "2"}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the counterclockwise vertex adjacency list for each point in the \
Delaunay triangulation. For example, the entry ",
 StyleBox["{1,", "MR"],
 " ",
 StyleBox["{4,", "MR"],
 " ",
 StyleBox["3,", "MR"],
 " ",
 StyleBox["2}}", "MR"],
 " indicates that the first point in ",
 StyleBox["data2D", "MR"],
 " is connected in counterclockwise order to the fourth, third, and second \
points. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
(delval =
 DelaunayTriangulation[data2D]) // Shallow[#, {5, 6}]&\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "4", ",", "8", ",", "7", ",", "5"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "9", ",", "8", ",", "3", ",", "1"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "7", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "7", ",", "13", ",", "14"}], "}"}]}], "}"}], ",", 
   RowBox[{"\[LeftSkeleton]", "10", "\[RightSkeleton]"}]}], "}"}]], "Output",
 CellLabel->"Out[5]//Shallow= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "While ",
 StyleBox["DelaunayTriangulation", "MR"],
 " need only specify the connections between points, ",
 StyleBox["VoronoiDiagram", "MR"],
 " must specify both a set of diagram vertices and the connections between \
those vertices. Another difference between the two functions is that while a \
triangulation consists of segments, a diagram consists of both segments and \
rays. For example, in the case of a Voronoi diagram, points in the interior \
of the convex hull will have nearest neighborhoods that are closed polygons, \
but the nearest neighborhoods of points on the convex hull will be open \
polygons. "
}], "Text",
 CellTags->{"S5.19.1", "1.9"}],

Cell[TextData[{
 "These considerations make the output of ",
 StyleBox["VoronoiDiagram", "MR"],
 " more complex than that of ",
 StyleBox["DelaunayTriangulation", "MR"],
 ". The diagram is given as a list of diagram vertices followed by a diagram \
vertex adjacency list. The finite vertices of the diagram are listed first in \
the vertex list. The vertices lying at infinity have head ",
 StyleBox["Ray", "MR"],
 " and are listed last. "
}], "Text",
 CellTags->{"S5.19.1", "1.10"}],

Cell[TextData[{
 "This assigns the list of Voronoi diagram vertices to ",
 StyleBox["vorvert", "MR"],
 " and the Voronoi diagram vertex adjacency list to ",
 StyleBox["vorval", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.11"}],

Cell["{vorvert, vorval} = VoronoiDiagram[data2D];", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "The first vertex in ",
 StyleBox["vorvert", "MR"],
 " is a finite diagram vertex having coordinates ",
 StyleBox["{-0.0158537,", "MR"],
 " ",
 StyleBox["8.44146}", "MR"],
 ". The last vertex in ",
 StyleBox["vorvert", "MR"],
 " is a point at infinity. This point is represented by a ",
 StyleBox["Ray", "MR"],
 " object having origin ",
 StyleBox["{10.5172,", "MR"],
 " ",
 StyleBox["3.46115}", "MR"],
 " and containing ",
 StyleBox["{13.95,", "MR"],
 " ",
 StyleBox["0.2}", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.12"}],

Cell[CellGroupData[{

Cell["{First[vorvert], Last[vorvert]}", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.01585365853658583`"}], ",", "8.441463414634146`"}], 
    "}"}], ",", 
   RowBox[{"Ray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10.51721105527638`", ",", "3.4611494974874377`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"13.949999999999996`", ",", "0.20000000000000306`"}], "}"}]}], 
    "]"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "Each entry in ",
 StyleBox["vorval", "MR"],
 " gives the index of a point in ",
 StyleBox["data2D", "MR"],
 " followed by a counterclockwise list of the Voronoi diagram vertices that \
comprise the point\[CloseCurlyQuote]s nearest neighborhood polygon. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.13"}],

Cell[CellGroupData[{

Cell["vorval // Short", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7", ",", "21", ",", "22"}], "}"}]}], "}"}], ",", 
    RowBox[{"\[LeftSkeleton]", "14", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"16", ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "10", ",", "28", ",", "30"}], "}"}]}], "}"}]}], 
   "}"}],
  Short]], "Output",
 CellLabel->"Out[8]//Short= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the Voronoi polygon vertex adjacency list for the first point in ",
 StyleBox["data2D", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.14"}],

Cell[CellGroupData[{

Cell["vorval[[1,2]]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "7", ",", "21", ",", "22"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "This selects the coordinates of the polygon vertices from ",
 StyleBox["vorvert", "MR"],
 ". The first two vertices have head ",
 StyleBox["List", "MR"],
 ", while the last two have head ",
 StyleBox["Ray", "MR"],
 ". Thus, the Voronoi polygon associated with the first point in ",
 StyleBox["data2D", "MR"],
 " is open and is defined by a segment and two rays. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.15"}],

Cell[CellGroupData[{

Cell["vorvert[[%]]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.692757242757244`", ",", "11.405744255744255`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.91533559898046`", ",", "13.952782497875958`"}], "}"}], ",", 
   RowBox[{"Ray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.91533559898046`", ",", "13.952782497875958`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.299999999999998`", ",", "16.925000000000004`"}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"Ray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.692757242757244`", ",", "11.405744255744255`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"0.34999999999999964`", ",", "14.850000000000001`"}], "}"}]}], 
    "]"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["VoronoiDiagram[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "compute the Voronoi diagram using the Delaunay triangulation vertex \
adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VoronoiDiagram[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["convexhull", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "compute the Voronoi diagram using the Delaunay triangulation vertex \
adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the convex hull index list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["convexhull", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["\<\
Computing the Voronoi diagram using the Delaunay triangulation and the convex \
hull. \
\>", "Caption",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "This computes the Voronoi diagram of ",
 StyleBox["data2D", "MR"],
 " more efficiently by making use of the Delaunay triangulation vertex \
adjacency list. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.16"}],

Cell["VoronoiDiagram[data2D, delval];", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.19.1"],

Cell["\<\
Here the Voronoi diagram is computed using both the Delaunay triangulation \
and the convex hull. \
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.17"}],

Cell["\<\
VoronoiDiagram[data2D, delval,
 convexhull];\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PlanarGraphPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the Delaunay triangulation of the points",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlanarGraphPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["indexlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the graph depicted by the counterclockwise list of indices in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["indexlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlanarGraphPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["val", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the graph depicted by the vertex adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["val", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DiagramPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the Voronoi diagram of the points",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DiagramPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diagvert", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diagval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the diagram depicted by the vertex list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diagvert", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the vertex adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["diagval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TriangularSurfacePlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the surface according to the Delaunay triangulation established \
by projecting the points onto the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["y",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" plane",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TriangularSurfacePlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["trival", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the surface according to the triangulation depicted by the vertex \
adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["trival", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["Computational geometry plotting functions. ", "Caption",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "The default of ",
 StyleBox["PlanarGraphPlot", "MR"],
 " is a plot of the Delaunay triangulation of the points. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
PlanarGraphPlot[data2D,
 TextStyle -> {\"FontSize\" -> 8}]\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0166078 0.0671378 -0.0488516 0.0671378 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.05689 .29355 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
gsave
.1576 .69638 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
gsave
.23816 .46811 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(9) show
1.000 setlinewidth
grestore
gsave
.31201 .89108 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
gsave
.37244 .11228 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
1.000 setlinewidth
grestore
gsave
.46643 .975 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
gsave
.47314 .58896 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
1.000 setlinewidth
grestore
gsave
.47986 .81051 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
gsave
.58392 .2667 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
1.000 setlinewidth
grestore
gsave
.65442 .9515 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
gsave
.70813 .77694 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
1.000 setlinewidth
grestore
gsave
.75512 .025 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16) show
1.000 setlinewidth
grestore
gsave
.78869 .59567 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(13) show
1.000 setlinewidth
grestore
gsave
.88269 .15928 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
1.000 setlinewidth
grestore
gsave
.90283 .75009 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
gsave
.94311 .44125 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
1.000 setlinewidth
grestore
.003 w
[ ] 0 setdash
.31201 .89108 m
.46643 .975 L
s
.31201 .89108 m
.47986 .81051 L
s
.31201 .89108 m
.1576 .69638 L
s
.46643 .975 m
.47986 .81051 L
s
.46643 .975 m
.65442 .9515 L
s
.47986 .81051 m
.1576 .69638 L
s
.47986 .81051 m
.65442 .9515 L
s
.47986 .81051 m
.70813 .77694 L
s
.47986 .81051 m
.47314 .58896 L
s
.1576 .69638 m
.47314 .58896 L
s
.1576 .69638 m
.23816 .46811 L
s
.1576 .69638 m
.05689 .29355 L
s
.65442 .9515 m
.90283 .75009 L
s
.65442 .9515 m
.70813 .77694 L
s
.90283 .75009 m
.70813 .77694 L
s
.90283 .75009 m
.78869 .59567 L
s
.90283 .75009 m
.94311 .44125 L
s
.70813 .77694 m
.47314 .58896 L
s
.70813 .77694 m
.78869 .59567 L
s
.47314 .58896 m
.23816 .46811 L
s
.47314 .58896 m
.58392 .2667 L
s
.47314 .58896 m
.78869 .59567 L
s
.23816 .46811 m
.05689 .29355 L
s
.23816 .46811 m
.37244 .11228 L
s
.23816 .46811 m
.58392 .2667 L
s
.05689 .29355 m
.37244 .11228 L
s
.37244 .11228 m
.58392 .2667 L
s
.37244 .11228 m
.75512 .025 L
s
.58392 .2667 m
.78869 .59567 L
s
.58392 .2667 m
.94311 .44125 L
s
.58392 .2667 m
.88269 .15928 L
s
.58392 .2667 m
.75512 .025 L
s
.78869 .59567 m
.94311 .44125 L
s
.94311 .44125 m
.88269 .15928 L
s
.88269 .15928 m
.75512 .025 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["This plots the convex hull of the points. ", "MathCaption",
 CellTags->{"S5.19.1", "1.19"}],

Cell[CellGroupData[{

Cell["PlanarGraphPlot[data2D, convexhull]", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0166078 0.0671378 -0.0488516 0.0671378 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
[(10)] .05689 .29355 0 0 Mshowa
[(4)] .1576 .69638 0 0 Mshowa
[(9)] .23816 .46811 0 0 Mshowa
[(1)] .31201 .89108 0 0 Mshowa
[(11)] .37244 .11228 0 0 Mshowa
[(2)] .46643 .975 0 0 Mshowa
[(8)] .47314 .58896 0 0 Mshowa
[(3)] .47986 .81051 0 0 Mshowa
[(12)] .58392 .2667 0 0 Mshowa
[(5)] .65442 .9515 0 0 Mshowa
[(7)] .70813 .77694 0 0 Mshowa
[(16)] .75512 .025 0 0 Mshowa
[(13)] .78869 .59567 0 0 Mshowa
[(15)] .88269 .15928 0 0 Mshowa
[(6)] .90283 .75009 0 0 Mshowa
[(14)] .94311 .44125 0 0 Mshowa
.003 w
[ ] 0 setdash
.94311 .44125 m
.90283 .75009 L
.65442 .9515 L
.46643 .975 L
.31201 .89108 L
.1576 .69638 L
.05689 .29355 L
.37244 .11228 L
.75512 .025 L
.88269 .15928 L
.94311 .44125 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["Here is an alternative triangulation. ", "MathCaption",
 CellTags->{"S5.19.1", "1.20"}],

Cell["\<\
trival = Insert[Insert[Delete[delval,
 {{12, 2, 4}, {16, 2, 2}}], 15, {11, 2, 2}],
  11, {15, 2, 3}];\
\>", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "This plots the triangulation of ",
 StyleBox["data2D", "MR"],
 " given by ",
 StyleBox["trival", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
PlanarGraphPlot[data2D, trival,
 TextStyle -> {\"FontSize\" -> 8}]\
\>", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0166078 0.0671378 -0.0488516 0.0671378 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.05689 .29355 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
gsave
.1576 .69638 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
gsave
.23816 .46811 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(9) show
1.000 setlinewidth
grestore
gsave
.31201 .89108 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
gsave
.37244 .11228 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(11) show
1.000 setlinewidth
grestore
gsave
.46643 .975 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
gsave
.47314 .58896 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
1.000 setlinewidth
grestore
gsave
.47986 .81051 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
gsave
.58392 .2667 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(12) show
1.000 setlinewidth
grestore
gsave
.65442 .9515 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
1.000 setlinewidth
grestore
gsave
.70813 .77694 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(7) show
1.000 setlinewidth
grestore
gsave
.75512 .025 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16) show
1.000 setlinewidth
grestore
gsave
.78869 .59567 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(13) show
1.000 setlinewidth
grestore
gsave
.88269 .15928 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(15) show
1.000 setlinewidth
grestore
gsave
.90283 .75009 -65.375 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
gsave
.94311 .44125 -67.75 -8.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 16.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 10.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 8.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(14) show
1.000 setlinewidth
grestore
.003 w
[ ] 0 setdash
.31201 .89108 m
.46643 .975 L
s
.31201 .89108 m
.47986 .81051 L
s
.31201 .89108 m
.1576 .69638 L
s
.46643 .975 m
.47986 .81051 L
s
.46643 .975 m
.65442 .9515 L
s
.47986 .81051 m
.1576 .69638 L
s
.47986 .81051 m
.65442 .9515 L
s
.47986 .81051 m
.70813 .77694 L
s
.47986 .81051 m
.47314 .58896 L
s
.1576 .69638 m
.47314 .58896 L
s
.1576 .69638 m
.23816 .46811 L
s
.1576 .69638 m
.05689 .29355 L
s
.65442 .9515 m
.90283 .75009 L
s
.65442 .9515 m
.70813 .77694 L
s
.90283 .75009 m
.70813 .77694 L
s
.90283 .75009 m
.78869 .59567 L
s
.90283 .75009 m
.94311 .44125 L
s
.70813 .77694 m
.47314 .58896 L
s
.70813 .77694 m
.78869 .59567 L
s
.47314 .58896 m
.23816 .46811 L
s
.47314 .58896 m
.58392 .2667 L
s
.47314 .58896 m
.78869 .59567 L
s
.23816 .46811 m
.05689 .29355 L
s
.23816 .46811 m
.37244 .11228 L
s
.23816 .46811 m
.58392 .2667 L
s
.05689 .29355 m
.37244 .11228 L
s
.37244 .11228 m
.58392 .2667 L
s
.37244 .11228 m
.88269 .15928 L
s
.37244 .11228 m
.75512 .025 L
s
.58392 .2667 m
.78869 .59567 L
s
.58392 .2667 m
.94311 .44125 L
s
.58392 .2667 m
.88269 .15928 L
s
.78869 .59567 m
.94311 .44125 L
s
.94311 .44125 m
.88269 .15928 L
s
.88269 .15928 m
.75512 .025 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "The default of ",
 StyleBox["DiagramPlot", "MR"],
 " is a plot of the Voronoi diagram of the points. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.22"}],

Cell[CellGroupData[{

Cell["DiagramPlot[data2D]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.258641 0.0388376 0.227925 0.0388376 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
[(1)] .42953 .77165 0 0 Mshowa
[(2)] .51885 .8202 0 0 Mshowa
[(3)] .52662 .72505 0 0 Mshowa
[(4)] .3402 .65902 0 0 Mshowa
[(5)] .6276 .8066 0 0 Mshowa
[(6)] .7713 .69009 0 0 Mshowa
[(7)] .65867 .70563 0 0 Mshowa
[(8)] .52274 .59688 0 0 Mshowa
[(9)] .38681 .52697 0 0 Mshowa
[(10)] .28194 .426 0 0 Mshowa
[(11)] .46448 .32113 0 0 Mshowa
[(12)] .58682 .41046 0 0 Mshowa
[(13)] .70527 .60077 0 0 Mshowa
[(14)] .7946 .51144 0 0 Mshowa
[(15)] .75965 .34832 0 0 Mshowa
[(16)] .68585 .27065 0 0 Mshowa
.012 w
.25803 .55577 Mdot
.39573 .41277 Mdot
.42723 .61549 Mdot
.4409 .6709 Mdot
.44354 .66342 Mdot
.4707 .44106 Mdot
.48838 .76982 Mdot
.49525 .48321 Mdot
.5686 .77637 Mdot
.57553 .29748 Mdot
.58438 .65915 Mdot
.59653 .74178 Mdot
.6135 .62276 Mdot
.61558 .52457 Mdot
.6671 .36235 Mdot
.67896 .48513 Mdot
.69752 .44694 Mdot
.71058 .66591 Mdot
.72656 .78178 Mdot
.79635 .60251 Mdot
.003 w
[ ] 0 setdash
.48838 .76982 m
.42564 .88525 L
s
.4409 .6709 m
.27223 .80466 L
s
.5686 .77637 m
.58682 .92215 L
s
.25803 .55577 m
.025 .61403 L
s
.72656 .78178 m
.84307 .92548 L
s
.79635 .60251 m
.975 .62582 L
s
.39573 .41277 m
.26835 .19103 L
s
.57553 .29748 m
.52468 .07452 L
s
.69752 .44694 m
.94024 .39493 L
s
.6671 .36235 m
.80043 .23569 L
s
.4409 .6709 m
.48838 .76982 L
s
.48838 .76982 m
.5686 .77637 L
s
.48838 .76982 m
.4409 .6709 L
.44354 .66342 L
.58438 .65915 L
.59653 .74178 L
.5686 .77637 L
.48838 .76982 L
s
.25803 .55577 m
.42723 .61549 L
.44354 .66342 L
.4409 .6709 L
s
.5686 .77637 m
.59653 .74178 L
.72656 .78178 L
s
.72656 .78178 m
.71058 .66591 L
.79635 .60251 L
s
.59653 .74178 m
.58438 .65915 L
.6135 .62276 L
.71058 .66591 L
.72656 .78178 L
.59653 .74178 L
s
.44354 .66342 m
.42723 .61549 L
.49525 .48321 L
.61558 .52457 L
.6135 .62276 L
.58438 .65915 L
.44354 .66342 L
s
.25803 .55577 m
.39573 .41277 L
.4707 .44106 L
.49525 .48321 L
.42723 .61549 L
.25803 .55577 L
s
.39573 .41277 m
.25803 .55577 L
s
.57553 .29748 m
.4707 .44106 L
.39573 .41277 L
s
.49525 .48321 m
.4707 .44106 L
.57553 .29748 L
.6671 .36235 L
.69752 .44694 L
.67896 .48513 L
.61558 .52457 L
.49525 .48321 L
s
.6135 .62276 m
.61558 .52457 L
.67896 .48513 L
.79635 .60251 L
.71058 .66591 L
.6135 .62276 L
s
.79635 .60251 m
.67896 .48513 L
.69752 .44694 L
s
.69752 .44694 m
.6671 .36235 L
s
.6671 .36235 m
.57553 .29748 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["Here is an alternative set of diagram vertices. ", "MathCaption",
 CellTags->{"S5.19.1", "1.23"}],

Cell["\<\
diagvert = ReplacePart[vorvert,
 {-6., 0.}, {27, 2}];\
\>", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.19.1"],

Cell["Here is an alternative diagram vertex adjacency list. ", "MathCaption",
 CellTags->{"S5.19.1", "1.24"}],

Cell["\<\
diagval = Join[Drop[vorval, -8],
 {{9, {1, 6, 8, 3}}, {10, {2, 6, 1,
 24, 27}}},
  Drop[vorval, 10]];\
\>", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "This plots the diagram of ",
 StyleBox["data2D", "MR"],
 " given by ",
 StyleBox["diagvert", "MR"],
 " and ",
 StyleBox["diagval", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.25"}],

Cell[CellGroupData[{

Cell["DiagramPlot[data2D, diagvert, diagval]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.258641 0.0388376 0.227925 0.0388376 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
[(1)] .42953 .77165 0 0 Mshowa
[(2)] .51885 .8202 0 0 Mshowa
[(3)] .52662 .72505 0 0 Mshowa
[(4)] .3402 .65902 0 0 Mshowa
[(5)] .6276 .8066 0 0 Mshowa
[(6)] .7713 .69009 0 0 Mshowa
[(7)] .65867 .70563 0 0 Mshowa
[(8)] .52274 .59688 0 0 Mshowa
[(9)] .38681 .52697 0 0 Mshowa
[(10)] .28194 .426 0 0 Mshowa
[(11)] .46448 .32113 0 0 Mshowa
[(12)] .58682 .41046 0 0 Mshowa
[(13)] .70527 .60077 0 0 Mshowa
[(14)] .7946 .51144 0 0 Mshowa
[(15)] .75965 .34832 0 0 Mshowa
[(16)] .68585 .27065 0 0 Mshowa
.012 w
.25803 .55577 Mdot
.39573 .41277 Mdot
.42723 .61549 Mdot
.4409 .6709 Mdot
.44354 .66342 Mdot
.4707 .44106 Mdot
.48838 .76982 Mdot
.49525 .48321 Mdot
.5686 .77637 Mdot
.57553 .29748 Mdot
.58438 .65915 Mdot
.59653 .74178 Mdot
.6135 .62276 Mdot
.61558 .52457 Mdot
.6671 .36235 Mdot
.67896 .48513 Mdot
.69752 .44694 Mdot
.71058 .66591 Mdot
.72656 .78178 Mdot
.79635 .60251 Mdot
.003 w
[ ] 0 setdash
.48838 .76982 m
.42564 .88525 L
s
.4409 .6709 m
.27223 .80466 L
s
.5686 .77637 m
.58682 .92215 L
s
.25803 .55577 m
.025 .61403 L
s
.72656 .78178 m
.84307 .92548 L
s
.79635 .60251 m
.975 .62582 L
s
.39573 .41277 m
.02562 .22792 L
s
.57553 .29748 m
.52468 .07452 L
s
.69752 .44694 m
.94024 .39493 L
s
.6671 .36235 m
.80043 .23569 L
s
.4409 .6709 m
.48838 .76982 L
s
.48838 .76982 m
.5686 .77637 L
s
.48838 .76982 m
.4409 .6709 L
.44354 .66342 L
.58438 .65915 L
.59653 .74178 L
.5686 .77637 L
.48838 .76982 L
s
.25803 .55577 m
.42723 .61549 L
.44354 .66342 L
.4409 .6709 L
s
.5686 .77637 m
.59653 .74178 L
.72656 .78178 L
s
.72656 .78178 m
.71058 .66591 L
.79635 .60251 L
s
.59653 .74178 m
.58438 .65915 L
.6135 .62276 L
.71058 .66591 L
.72656 .78178 L
.59653 .74178 L
s
.44354 .66342 m
.42723 .61549 L
.49525 .48321 L
.61558 .52457 L
.6135 .62276 L
.58438 .65915 L
.44354 .66342 L
s
.25803 .55577 m
.4707 .44106 L
.49525 .48321 L
.42723 .61549 L
.25803 .55577 L
s
.39573 .41277 m
.4707 .44106 L
.25803 .55577 L
s
.57553 .29748 m
.4707 .44106 L
.39573 .41277 L
s
.49525 .48321 m
.4707 .44106 L
.57553 .29748 L
.6671 .36235 L
.69752 .44694 L
.67896 .48513 L
.61558 .52457 L
.49525 .48321 L
s
.6135 .62276 m
.61558 .52457 L
.67896 .48513 L
.79635 .60251 L
.71058 .66591 L
.6135 .62276 L
s
.79635 .60251 m
.67896 .48513 L
.69752 .44694 L
s
.69752 .44694 m
.6671 .36235 L
s
.6671 .36235 m
.57553 .29748 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a set of three\[Hyphen]dimensional points having the same ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], ",", 
    StyleBox["y",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinates as ",
 StyleBox["data2D", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.26"}],

Cell["\<\
data3D = Map[Append[#,
 Sqrt[64-(#[[1]]-8)^2-(#[[2]]-8)^2]]&,
  data2D];\
\>", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "The default of ",
 StyleBox["TriangularSurfacePlot", "MR"],
 " is a plot of the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinates according to the connectivity established by the Delaunay \
triangulation of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], ",", 
    StyleBox["y",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinates. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.27"}],

Cell[CellGroupData[{

Cell["TriangularSurfacePlot[data3D]", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .89879 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.87638e-17 1.05592 -0.0283686 1.05592 [
[ 0 0 0 0 ]
[ 1 .89879 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04739 .24429 m
0 .56011 L
s
0 .56011 m
.42038 .89879 L
s
.42038 .89879 m
.42835 .61301 L
s
.42835 .61301 m
.04739 .24429 L
s
.66259 0 m
.96176 .44987 L
s
.96176 .44987 m
1 .75036 L
s
1 .75036 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.04739 .24429 m
0 .56011 L
s
0 .56011 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.66259 0 m
.04739 .24429 L
s
.42835 .61301 m
.96176 .44987 L
s
.96176 .44987 m
1 .75036 L
s
1 .75036 m
.42038 .89879 L
s
.42038 .89879 m
.42835 .61301 L
s
0 0 m
1 0 L
1 .89879 L
0 .89879 L
closepath
clip
newpath
.5 Mabswid
.358 0 .078 r
.67362 .64313 m .63866 .70812 L .77743 .62756 L closepath p F P
0 g
s
.484 .049 .138 r
.56355 .67002 m .67362 .64313 L .63866 .70812 L closepath p F P
0 g
s
.48 0 0 r
.56355 .67002 m .63866 .70812 L .4162 .65617 L closepath p F P
0 g
s
0 0 0 r
.77743 .62756 m .88128 .54987 L .76943 .65958 L closepath p F P
0 g
s
.074 0 0 r
.63866 .70812 m .77743 .62756 L .76943 .65958 L closepath p F P
0 g
s
.8 .337 0 r
.4162 .65617 m .38134 .64653 L .22594 .41287 L closepath p F P
0 g
s
.224 0 0 r
.63866 .70812 m .4162 .65617 L .56627 .69633 L closepath p F P
0 g
s
0 .41 .686 r
.4162 .65617 m .56627 .69633 L .38134 .64653 L closepath p F P
0 g
s
.044 .224 .724 r
.38134 .64653 m .22594 .41287 L .33215 .43244 L closepath p F P
0 g
s
.541 .904 .965 r
.63866 .70812 m .76943 .65958 L .56627 .69633 L closepath p F P
0 g
s
.676 .906 .976 r
.76943 .65958 m .56627 .69633 L .77106 .60963 L closepath p F P
0 g
s
.829 .993 .86 r
.88128 .54987 m .76943 .65958 L .77106 .60963 L closepath p F P
0 g
s
.906 .908 .813 r
.88128 .54987 m .77106 .60963 L .82542 .45758 L closepath p F P
0 g
s
.494 .571 .862 r
.38134 .64653 m .33215 .43244 L .52641 .53944 L closepath p F P
0 g
s
.533 .652 .911 r
.56627 .69633 m .38134 .64653 L .52641 .53944 L closepath p F P
0 g
s
.704 .767 .901 r
.56627 .69633 m .52641 .53944 L .77106 .60963 L closepath p F P
0 g
s
.76 .733 .828 r
.52641 .53944 m .77106 .60963 L .82542 .45758 L closepath p F P
0 g
s
.637 .54 .728 r
.33215 .43244 m .52641 .53944 L .55386 .21402 L closepath p F P
0 g
s
.755 .682 .781 r
.52641 .53944 m .82542 .45758 L .69066 .29373 L closepath p F P
0 g
s
.683 .582 .735 r
.52641 .53944 m .69066 .29373 L .55386 .21402 L closepath p F P
0 g
s
.25 Mabswid
.66259 0 m
.96176 .44987 L
s
.96176 .44987 m
1 .75036 L
s
1 .75036 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.04739 .24429 m
0 .56011 L
s
0 .56011 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.66259 0 m
.04739 .24429 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "This plots the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinates according to the connectivity established by the triangulation \
",
 StyleBox["trival", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.28"}],

Cell[CellGroupData[{

Cell["TriangularSurfacePlot[data3D, trival]", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .89879 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.87638e-17 1.05592 -0.0283686 1.05592 [
[ 0 0 0 0 ]
[ 1 .89879 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04739 .24429 m
0 .56011 L
s
0 .56011 m
.42038 .89879 L
s
.42038 .89879 m
.42835 .61301 L
s
.42835 .61301 m
.04739 .24429 L
s
.66259 0 m
.96176 .44987 L
s
.96176 .44987 m
1 .75036 L
s
1 .75036 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.04739 .24429 m
0 .56011 L
s
0 .56011 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.66259 0 m
.04739 .24429 L
s
.42835 .61301 m
.96176 .44987 L
s
.96176 .44987 m
1 .75036 L
s
1 .75036 m
.42038 .89879 L
s
.42038 .89879 m
.42835 .61301 L
s
0 0 m
1 0 L
1 .89879 L
0 .89879 L
closepath
clip
newpath
.5 Mabswid
.358 0 .078 r
.67362 .64313 m .63866 .70812 L .77743 .62756 L closepath p F P
0 g
s
.484 .049 .138 r
.56355 .67002 m .67362 .64313 L .63866 .70812 L closepath p F P
0 g
s
.48 0 0 r
.56355 .67002 m .63866 .70812 L .4162 .65617 L closepath p F P
0 g
s
0 0 0 r
.77743 .62756 m .88128 .54987 L .76943 .65958 L closepath p F P
0 g
s
.074 0 0 r
.63866 .70812 m .77743 .62756 L .76943 .65958 L closepath p F P
0 g
s
.8 .337 0 r
.4162 .65617 m .38134 .64653 L .22594 .41287 L closepath p F P
0 g
s
.224 0 0 r
.63866 .70812 m .4162 .65617 L .56627 .69633 L closepath p F P
0 g
s
0 .41 .686 r
.4162 .65617 m .56627 .69633 L .38134 .64653 L closepath p F P
0 g
s
.044 .224 .724 r
.38134 .64653 m .22594 .41287 L .33215 .43244 L closepath p F P
0 g
s
.541 .904 .965 r
.63866 .70812 m .76943 .65958 L .56627 .69633 L closepath p F P
0 g
s
.676 .906 .976 r
.76943 .65958 m .56627 .69633 L .77106 .60963 L closepath p F P
0 g
s
.829 .993 .86 r
.88128 .54987 m .76943 .65958 L .77106 .60963 L closepath p F P
0 g
s
.906 .908 .813 r
.88128 .54987 m .77106 .60963 L .82542 .45758 L closepath p F P
0 g
s
.494 .571 .862 r
.38134 .64653 m .33215 .43244 L .52641 .53944 L closepath p F P
0 g
s
.533 .652 .911 r
.56627 .69633 m .38134 .64653 L .52641 .53944 L closepath p F P
0 g
s
.704 .767 .901 r
.56627 .69633 m .52641 .53944 L .77106 .60963 L closepath p F P
0 g
s
.76 .733 .828 r
.52641 .53944 m .77106 .60963 L .82542 .45758 L closepath p F P
0 g
s
.666 .589 .759 r
.33215 .43244 m .69066 .29373 L .55386 .21402 L closepath p F P
0 g
s
.648 .534 .711 r
.33215 .43244 m .52641 .53944 L .69066 .29373 L closepath p F P
0 g
s
.755 .682 .781 r
.52641 .53944 m .82542 .45758 L .69066 .29373 L closepath p F P
0 g
s
.25 Mabswid
.66259 0 m
.96176 .44987 L
s
.96176 .44987 m
1 .75036 L
s
1 .75036 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.04739 .24429 m
0 .56011 L
s
0 .56011 m
.67758 .32924 L
s
.67758 .32924 m
.66259 0 L
s
.66259 0 m
.04739 .24429 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ConvexHull[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, AllPoints -> False]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the minimum set of points needed to define the convex hull",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DelaunayTriangulation[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, Hull -> True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give both the Delaunay triangulation vertex adjacency list and the \
convex hull",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlanarGraphPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, LabelPoints -> False]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the Delaunay triangulation without labels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DiagramPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, LabelPoints -> False]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the Voronoi diagram without labels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DiagramPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, TrimPoints -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the Voronoi diagram with the outermost ray plus ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["n",
           "TI"], "-", "1"}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of the outermost diagram vertices trimmed",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["Options for computational geometry functions. ", "Caption",
 CellTags->"S5.19.1"],

Cell["\<\
This gives the minimum set of points needed to define the convex hull. \
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.29"}],

Cell[CellGroupData[{

Cell["\<\
ConvexHull[{{0,0}, {1,0}, {0,0}, {2,0},
 {1,1}}, AllPoints -> False]\
\>", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConvexHull", "::", "\<\"duplicated\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(1\\) duplicated point(s) ignored.\"\>"}]], "Message",\

 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["\<\
This returns both the Delaunay triangulation and the convex hull. \
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.30"}],

Cell[CellGroupData[{

Cell["\<\
DelaunayTriangulation[data2D,
 Hull -> True] // Shallow\
\>", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "}"}], ",", 
     RowBox[{"\[LeftSkeleton]", "6", "\[RightSkeleton]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "1", ",", "4", ",", "10", ",", "11", ",", "16", ",", "15", ",", 
     "14", ",", "6", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[25]//Shallow= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a set of random numbers uniformly distributed on \
[0,\[ThinSpace]1]",
 Cell[BoxData[
  FormBox["\[Cross]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "[0,\[ThinSpace]1]. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.31"}],

Cell["random = Table[{Random[], Random[]}, {40}];", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "This computes the Voronoi diagram of ",
 StyleBox["random", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.32"}],

Cell["\<\
{randvert, randval} =
 VoronoiDiagram[random];\
\>", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.19.1"],

Cell["The diagram plot is dominated by outlier vertices. ", "MathCaption",
 CellTags->{"S5.19.1", "1.33"}],

Cell[CellGroupData[{

Cell["\<\
DiagramPlot[random, randvert, randval,
 LabelPoints -> False]\
\>", "Input",
 CellLabel->"In[28]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0468229 0.140526 0.477912 0.140526 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.012 w
.0547 .56649 Mdot
.0974 .60036 Mdot
.16749 .56006 Mdot
.15122 .53292 Mdot
.09702 .53138 Mdot
.17736 .50254 Mdot
.16745 .60357 Mdot
.08587 .56925 Mdot
.07496 .50307 Mdot
.16683 .60478 Mdot
.16713 .59287 Mdot
.10564 .57672 Mdot
.15925 .5043 Mdot
.05507 .59479 Mdot
.17911 .56268 Mdot
.0912 .53978 Mdot
.12891 .5092 Mdot
.10118 .51516 Mdot
.14881 .52407 Mdot
.06213 .56434 Mdot
.12067 .49891 Mdot
.08266 .578 Mdot
.14089 .52448 Mdot
.16436 .47919 Mdot
.16899 .49809 Mdot
.15612 .50284 Mdot
.17723 .55385 Mdot
.11175 .58149 Mdot
.09514 .52256 Mdot
.05739 .54425 Mdot
.13368 .61692 Mdot
.1826 .59835 Mdot
.05983 .59592 Mdot
.14677 .49826 Mdot
.10629 .54936 Mdot
.16976 .49698 Mdot
.12464 .52918 Mdot
.06046 .61258 Mdot
.13477 .59377 Mdot
.13606 .509 Mdot
.05529 .60444 Mdot
.0555 .5553 Mdot
.06096 .58056 Mdot
.0627 .58026 Mdot
.06618 .58051 Mdot
.07212 .5262 Mdot
.07223 .52638 Mdot
.07342 .56963 Mdot
.07542 .55059 Mdot
.07698 .55243 Mdot
.07797 .60358 Mdot
.0788 .59658 Mdot
.08508 .52932 Mdot
.08515 .36196 Mdot
.08757 .51021 Mdot
.09203 .55515 Mdot
.09414 .57726 Mdot
.09464 .58614 Mdot
.09473 .65423 Mdot
.09683 .49012 Mdot
.09957 .56289 Mdot
.10128 .54056 Mdot
.10136 .58848 Mdot
.1056 .52494 Mdot
.11051 .52619 Mdot
.11124 .53543 Mdot
.11499 .51191 Mdot
.11606 .5169 Mdot
.11662 .60009 Mdot
.1174 .60455 Mdot
.12098 .56339 Mdot
.13081 .52005 Mdot
.13218 .49814 Mdot
.13275 .51853 Mdot
.13296 .46787 Mdot
.13365 .49589 Mdot
.13435 .55645 Mdot
.13581 .56087 Mdot
.13586 .56057 Mdot
.13653 .56274 Mdot
.13664 .54021 Mdot
.14437 .5149 Mdot
.14513 .52983 Mdot
.14714 .50934 Mdot
.14793 .51189 Mdot
.14848 .60602 Mdot
.15048 .57628 Mdot
.15109 .59842 Mdot
.15298 .51363 Mdot
.15628 .59855 Mdot
.15671 .48978 Mdot
.1589 .49055 Mdot
.15915 .49048 Mdot
.16105 .49637 Mdot
.16394 .54374 Mdot
.1688 .50854 Mdot
.1699 .57649 Mdot
.17018 .52271 Mdot
.17036 .52295 Mdot
.17324 .5002 Mdot
.17379 .5592 Mdot
.17401 .59802 Mdot
.17645 .52819 Mdot
.17809 .60984 Mdot
.18018 .58058 Mdot
.18636 .48224 Mdot
.31714 .52856 Mdot
.87919 .51218 Mdot
.003 w
[ ] 0 setdash
.06096 .58056 m
.02658 .581 L
s
.0555 .5553 m
.03326 .55262 L
s
.18636 .48224 m
.20971 .46924 L
s
.87919 .51218 m
.975 .50694 L
s
.08515 .36196 m
.06127 .27256 L
s
.07212 .5262 m
.025 .50609 L
s
.14848 .60602 m
.16239 .644 L
s
.17809 .60984 m
.18452 .62562 L
s
.05529 .60444 m
.0375 .60983 L
s
.09473 .65423 m
.09039 .72744 L
s
.0555 .5553 m
.0627 .58026 L
.06096 .58056 L
s
.07797 .60358 m
.0788 .59658 L
.09464 .58614 L
.10136 .58848 L
.11662 .60009 L
.1174 .60455 L
.09473 .65423 L
.07797 .60358 L
s
.13653 .56274 m
.13581 .56087 L
.13586 .56057 L
.16394 .54374 L
.17379 .5592 L
.1699 .57649 L
.15048 .57628 L
.13653 .56274 L
s
.13435 .55645 m
.13664 .54021 L
.14513 .52983 L
.17036 .52295 L
.17645 .52819 L
.16394 .54374 L
.13586 .56057 L
.13435 .55645 L
s
.08508 .52932 m
.1056 .52494 L
.11051 .52619 L
.11124 .53543 L
.10128 .54056 L
.08508 .52932 L
s
.87919 .51218 m
.31714 .52856 L
.17645 .52819 L
.17036 .52295 L
.17018 .52271 L
.1688 .50854 L
.17324 .5002 L
.18636 .48224 L
s
.15628 .59855 m
.17401 .59802 L
.17809 .60984 L
.15628 .59855 L
s
.07342 .56963 m
.07698 .55243 L
.09203 .55515 L
.09957 .56289 L
.09414 .57726 L
.07342 .56963 L
s
.08515 .36196 m
.09683 .49012 L
.08757 .51021 L
.07212 .5262 L
s
.14848 .60602 m
.15109 .59842 L
.15628 .59855 L
.17809 .60984 L
s
.15628 .59855 m
.15109 .59842 L
.15048 .57628 L
.1699 .57649 L
.18018 .58058 L
.17401 .59802 L
.15628 .59855 L
s
.09464 .58614 m
.09414 .57726 L
.09957 .56289 L
.12098 .56339 L
.10136 .58848 L
.09464 .58614 L
s
.15298 .51363 m
.16105 .49637 L
.1688 .50854 L
.17018 .52271 L
.15298 .51363 L
s
.06096 .58056 m
.05529 .60444 L
s
.1699 .57649 m
.17379 .5592 L
.31714 .52856 L
.87919 .51218 L
.18018 .58058 L
.1699 .57649 L
s
.07698 .55243 m
.07542 .55059 L
.07223 .52638 L
.08508 .52932 L
.10128 .54056 L
.09203 .55515 L
.07698 .55243 L
s
.11606 .5169 m
.11499 .51191 L
.13218 .49814 L
.13275 .51853 L
.13081 .52005 L
.11606 .5169 L
s
.09683 .49012 m
.11499 .51191 L
.11606 .5169 L
.11051 .52619 L
.1056 .52494 L
.08757 .51021 L
.09683 .49012 L
s
.14437 .5149 m
.14793 .51189 L
.15298 .51363 L
.17018 .52271 L
.17036 .52295 L
.14513 .52983 L
.14437 .5149 L
s
.0627 .58026 m
.0555 .5553 L
.07542 .55059 L
.07698 .55243 L
.07342 .56963 L
.06618 .58051 L
.0627 .58026 L
s
.11499 .51191 m
.09683 .49012 L
.08515 .36196 L
.13296 .46787 L
.13365 .49589 L
.13218 .49814 L
.11499 .51191 L
s
.06618 .58051 m
.07342 .56963 L
.09414 .57726 L
.09464 .58614 L
.0788 .59658 L
.06618 .58051 L
s
.13081 .52005 m
.13275 .51853 L
.14437 .5149 L
.14513 .52983 L
.13664 .54021 L
.13081 .52005 L
s
.18636 .48224 m
.15915 .49048 L
.1589 .49055 L
.15671 .48978 L
.13296 .46787 L
.08515 .36196 L
s
.16105 .49637 m
.1589 .49055 L
.15915 .49048 L
.17324 .5002 L
.1688 .50854 L
.16105 .49637 L
s
.14714 .50934 m
.15671 .48978 L
.1589 .49055 L
.16105 .49637 L
.15298 .51363 L
.14793 .51189 L
.14714 .50934 L
s
.16394 .54374 m
.17645 .52819 L
.31714 .52856 L
.17379 .5592 L
.16394 .54374 L
s
.10136 .58848 m
.12098 .56339 L
.13581 .56087 L
.13653 .56274 L
.11662 .60009 L
.10136 .58848 L
s
.07223 .52638 m
.07212 .5262 L
.08757 .51021 L
.1056 .52494 L
.08508 .52932 L
.07223 .52638 L
s
.07212 .5262 m
.07223 .52638 L
.07542 .55059 L
.0555 .5553 L
s
.09473 .65423 m
.1174 .60455 L
.14848 .60602 L
s
.17809 .60984 m
.17401 .59802 L
.18018 .58058 L
.87919 .51218 L
s
.05529 .60444 m
.06096 .58056 L
.0627 .58026 L
.06618 .58051 L
.0788 .59658 L
.07797 .60358 L
.05529 .60444 L
s
.13365 .49589 m
.13296 .46787 L
.15671 .48978 L
.14714 .50934 L
.13365 .49589 L
s
.09957 .56289 m
.09203 .55515 L
.10128 .54056 L
.11124 .53543 L
.13435 .55645 L
.13586 .56057 L
.13581 .56087 L
.12098 .56339 L
.09957 .56289 L
s
.18636 .48224 m
.17324 .5002 L
.15915 .49048 L
.18636 .48224 L
s
.11124 .53543 m
.11051 .52619 L
.11606 .5169 L
.13081 .52005 L
.13664 .54021 L
.13435 .55645 L
.11124 .53543 L
s
.05529 .60444 m
.07797 .60358 L
.09473 .65423 L
s
.1174 .60455 m
.11662 .60009 L
.13653 .56274 L
.15048 .57628 L
.15109 .59842 L
.14848 .60602 L
.1174 .60455 L
s
.13218 .49814 m
.13365 .49589 L
.14714 .50934 L
.14793 .51189 L
.14437 .5149 L
.13275 .51853 L
.13218 .49814 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[28]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["TrimPoints", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["2", "MR"],
 " means that the diagram is plotted so that both the outermost ray and the \
outermost vertex are eliminated. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.34"}],

Cell[CellGroupData[{

Cell["\<\
DiagramPlot[random, randvert, randval,
 LabelPoints -> False, TrimPoints -> 2]\
\>", "Input",
 CellLabel->"In[29]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0478704 0.456772 0.401899 0.456772 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.012 w
.07348 .6898 Mdot
.21226 .79992 Mdot
.44008 .66892 Mdot
.38721 .58071 Mdot
.21104 .57571 Mdot
.47218 .48195 Mdot
.43997 .81034 Mdot
.17481 .6988 Mdot
.13934 .48369 Mdot
.43793 .81428 Mdot
.43892 .77557 Mdot
.23906 .72306 Mdot
.4133 .48767 Mdot
.07467 .78181 Mdot
.47787 .67742 Mdot
.1921 .60301 Mdot
.3147 .50361 Mdot
.22457 .52296 Mdot
.37937 .55195 Mdot
.09763 .68283 Mdot
.28791 .47016 Mdot
.16434 .72722 Mdot
.35363 .55326 Mdot
.42993 .40606 Mdot
.44497 .46749 Mdot
.40313 .48292 Mdot
.47174 .64874 Mdot
.2589 .73858 Mdot
.20491 .54703 Mdot
.08221 .61752 Mdot
.33018 .85375 Mdot
.48922 .79337 Mdot
.09014 .78549 Mdot
.37274 .46805 Mdot
.24115 .63413 Mdot
.44746 .46389 Mdot
.30082 .56854 Mdot
.09219 .83965 Mdot
.33372 .77847 Mdot
.33793 .50296 Mdot
.07539 .81317 Mdot
.07607 .65345 Mdot
.09384 .73555 Mdot
.09949 .73457 Mdot
.11078 .73539 Mdot
.1301 .55886 Mdot
.13044 .55944 Mdot
.13431 .70003 Mdot
.14084 .63815 Mdot
.14588 .64412 Mdot
.14911 .81037 Mdot
.1518 .78763 Mdot
.17224 .56901 Mdot
.17246 .025 Mdot
.18031 .50688 Mdot
.19481 .65295 Mdot
.20168 .72483 Mdot
.20329 .75369 Mdot
.20358 .975 Mdot
.2104 .44157 Mdot
.21933 .67811 Mdot
.22489 .60554 Mdot
.22514 .76131 Mdot
.23893 .55475 Mdot
.25487 .55884 Mdot
.25727 .58885 Mdot
.26945 .5124 Mdot
.27293 .52863 Mdot
.27473 .79902 Mdot
.27729 .81354 Mdot
.28892 .67975 Mdot
.32085 .53888 Mdot
.32532 .46765 Mdot
.32717 .53392 Mdot
.32784 .36925 Mdot
.33011 .46035 Mdot
.33239 .6572 Mdot
.33711 .67156 Mdot
.33728 .67058 Mdot
.33945 .67763 Mdot
.33982 .60441 Mdot
.36495 .52213 Mdot
.36742 .57065 Mdot
.37395 .50406 Mdot
.3765 .51236 Mdot
.3783 .81829 Mdot
.38479 .72165 Mdot
.38678 .79361 Mdot
.39293 .51801 Mdot
.40364 .79404 Mdot
.40506 .44049 Mdot
.41217 .44296 Mdot
.413 .44276 Mdot
.41915 .4619 Mdot
.42854 .61588 Mdot
.44436 .50147 Mdot
.44791 .72234 Mdot
.44883 .54752 Mdot
.44943 .54831 Mdot
.45877 .47436 Mdot
.46056 .66613 Mdot
.4613 .79229 Mdot
.46922 .56534 Mdot
.47454 .83072 Mdot
.48135 .73561 Mdot
.50142 .41596 Mdot
.92652 .56653 Mdot
.003 w
[ ] 0 setdash
.09384 .73555 m
0 0 rlineto s
.09384 .73555 m
0 .73676 L
s
.07607 .65345 m
.00379 .64472 L
s
.50142 .41596 m
.57732 .37371 L
s
.17246 .025 m
0 0 rlineto s
.17246 .025 m
.16578 0 L
s
.1301 .55886 m
0 0 rlineto s
.1301 .55886 m
0 .50332 L
s
.3783 .81829 m
.42352 .94177 L
s
.47454 .83072 m
.49546 .88201 L
s
.07539 .81317 m
.01756 .83069 L
s
.20358 .975 m
0 0 rlineto s
.20358 .975 m
.2021 1 L
s
.07607 .65345 m
.09949 .73457 L
.09384 .73555 L
s
.14911 .81037 m
.1518 .78763 L
.20329 .75369 L
.22514 .76131 L
.27473 .79902 L
.27729 .81354 L
.20358 .975 L
.14911 .81037 L
s
.33945 .67763 m
.33711 .67156 L
.33728 .67058 L
.42854 .61588 L
.46056 .66613 L
.44791 .72234 L
.38479 .72165 L
.33945 .67763 L
s
.33239 .6572 m
.33982 .60441 L
.36742 .57065 L
.44943 .54831 L
.46922 .56534 L
.42854 .61588 L
.33728 .67058 L
.33239 .6572 L
s
.17224 .56901 m
.23893 .55475 L
.25487 .55884 L
.25727 .58885 L
.22489 .60554 L
.17224 .56901 L
s
1 .56439 m
.92652 .56653 L
.46922 .56534 L
.44943 .54831 L
.44883 .54752 L
.44436 .50147 L
.45877 .47436 L
.50142 .41596 L
s
.40364 .79404 m
.4613 .79229 L
.47454 .83072 L
.40364 .79404 L
s
.13431 .70003 m
.14588 .64412 L
.19481 .65295 L
.21933 .67811 L
.20168 .72483 L
.13431 .70003 L
s
.17246 .025 m
.2104 .44157 L
.18031 .50688 L
.1301 .55886 L
s
.3783 .81829 m
.38678 .79361 L
.40364 .79404 L
.47454 .83072 L
s
.40364 .79404 m
.38678 .79361 L
.38479 .72165 L
.44791 .72234 L
.48135 .73561 L
.4613 .79229 L
.40364 .79404 L
s
.20329 .75369 m
.20168 .72483 L
.21933 .67811 L
.28892 .67975 L
.22514 .76131 L
.20329 .75369 L
s
.39293 .51801 m
.41915 .4619 L
.44436 .50147 L
.44883 .54752 L
.39293 .51801 L
s
.09384 .73555 m
.07539 .81317 L
s
.44791 .72234 m
.46056 .66613 L
.92652 .56653 L
s
.92652 .56653 m
1 .56439 L
s
1 .68486 m
.48135 .73561 L
.44791 .72234 L
s
.14588 .64412 m
.14084 .63815 L
.13044 .55944 L
.17224 .56901 L
.22489 .60554 L
.19481 .65295 L
.14588 .64412 L
s
.27293 .52863 m
.26945 .5124 L
.32532 .46765 L
.32717 .53392 L
.32085 .53888 L
.27293 .52863 L
s
.2104 .44157 m
.26945 .5124 L
.27293 .52863 L
.25487 .55884 L
.23893 .55475 L
.18031 .50688 L
.2104 .44157 L
s
.36495 .52213 m
.3765 .51236 L
.39293 .51801 L
.44883 .54752 L
.44943 .54831 L
.36742 .57065 L
.36495 .52213 L
s
.09949 .73457 m
.07607 .65345 L
.14084 .63815 L
.14588 .64412 L
.13431 .70003 L
.11078 .73539 L
.09949 .73457 L
s
.26945 .5124 m
.2104 .44157 L
.17246 .025 L
.32784 .36925 L
.33011 .46035 L
.32532 .46765 L
.26945 .5124 L
s
.11078 .73539 m
.13431 .70003 L
.20168 .72483 L
.20329 .75369 L
.1518 .78763 L
.11078 .73539 L
s
.32085 .53888 m
.32717 .53392 L
.36495 .52213 L
.36742 .57065 L
.33982 .60441 L
.32085 .53888 L
s
.50142 .41596 m
.413 .44276 L
.41217 .44296 L
.40506 .44049 L
.32784 .36925 L
.17246 .025 L
s
.41915 .4619 m
.41217 .44296 L
.413 .44276 L
.45877 .47436 L
.44436 .50147 L
.41915 .4619 L
s
.37395 .50406 m
.40506 .44049 L
.41217 .44296 L
.41915 .4619 L
.39293 .51801 L
.3765 .51236 L
.37395 .50406 L
s
.42854 .61588 m
.46922 .56534 L
.92652 .56653 L
.46056 .66613 L
.42854 .61588 L
s
.22514 .76131 m
.28892 .67975 L
.33711 .67156 L
.33945 .67763 L
.27473 .79902 L
.22514 .76131 L
s
.13044 .55944 m
.1301 .55886 L
.18031 .50688 L
.23893 .55475 L
.17224 .56901 L
.13044 .55944 L
s
.1301 .55886 m
.13044 .55944 L
.14084 .63815 L
.07607 .65345 L
s
.20358 .975 m
.27729 .81354 L
.3783 .81829 L
s
.47454 .83072 m
.4613 .79229 L
.48135 .73561 L
s
.48135 .73561 m
1 .68486 L
s
.07539 .81317 m
.09384 .73555 L
.09949 .73457 L
.11078 .73539 L
.1518 .78763 L
.14911 .81037 L
.07539 .81317 L
s
.33011 .46035 m
.32784 .36925 L
.40506 .44049 L
.37395 .50406 L
.33011 .46035 L
s
.21933 .67811 m
.19481 .65295 L
.22489 .60554 L
.25727 .58885 L
.33239 .6572 L
.33728 .67058 L
.33711 .67156 L
.28892 .67975 L
.21933 .67811 L
s
.50142 .41596 m
.45877 .47436 L
.413 .44276 L
.50142 .41596 L
s
.25727 .58885 m
.25487 .55884 L
.27293 .52863 L
.32085 .53888 L
.33982 .60441 L
.33239 .6572 L
.25727 .58885 L
s
.07539 .81317 m
.14911 .81037 L
.20358 .975 L
s
.27729 .81354 m
.27473 .79902 L
.33945 .67763 L
.38479 .72165 L
.38678 .79361 L
.3783 .81829 L
.27729 .81354 L
s
.32532 .46765 m
.33011 .46035 L
.37395 .50406 L
.3765 .51236 L
.36495 .52213 L
.32717 .53392 L
.32532 .46765 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[29]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["TrimPoints", "MR"],
 " option can be used to magnify the diagram until the points in ",
 StyleBox["random", "MR"],
 " fill the plot. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.35"}],

Cell[CellGroupData[{

Cell["\<\
DiagramPlot[random, randvert, randval,
 LabelPoints -> False, TrimPoints -> 6]\
\>", "Input",
 CellLabel->"In[30]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0421979 0.895632 0.0890177 0.895632 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.012 w
.09242 .65353 Mdot
.36453 .86945 Mdot
.81123 .61259 Mdot
.70757 .43962 Mdot
.36214 .42982 Mdot
.87417 .24598 Mdot
.81102 .88987 Mdot
.29109 .67118 Mdot
.22154 .24939 Mdot
.80702 .89761 Mdot
.80896 .82171 Mdot
.41707 .71875 Mdot
.75874 .25719 Mdot
.09474 .83395 Mdot
.88534 .62926 Mdot
.325 .48334 Mdot
.5654 .28846 Mdot
.38866 .32639 Mdot
.6922 .38323 Mdot
.13977 .63986 Mdot
.51286 .22286 Mdot
.27058 .7269 Mdot
.64173 .3858 Mdot
.79133 .09717 Mdot
.82083 .21763 Mdot
.73879 .24787 Mdot
.87332 .57302 Mdot
.45599 .74918 Mdot
.35012 .37358 Mdot
.10952 .51181 Mdot
.59574 .975 Mdot
.90758 .8566 Mdot
.12508 .84116 Mdot
.6792 .21872 Mdot
.42118 .54438 Mdot
.8257 .21057 Mdot
.53818 .41577 Mdot
.12911 .94734 Mdot
.6027 .8274 Mdot
.61095 .28718 Mdot
.09616 .89542 Mdot
.09748 .58225 Mdot
.13232 .74324 Mdot
.14342 .74131 Mdot
.16555 .74293 Mdot
.20344 .39678 Mdot
.2041 .39792 Mdot
.21169 .67359 Mdot
.22449 .55225 Mdot
.23438 .56396 Mdot
.24071 .88995 Mdot
.24598 .84535 Mdot
.28606 .41668 Mdot
.30189 .29486 Mdot
.33031 .58128 Mdot
.34379 .72221 Mdot
.34694 .77881 Mdot
.36089 .16681 Mdot
.37838 .6306 Mdot
.3893 .48831 Mdot
.38978 .79374 Mdot
.41683 .38873 Mdot
.44808 .39674 Mdot
.45278 .4556 Mdot
.47666 .30569 Mdot
.48349 .33751 Mdot
.48701 .86768 Mdot
.49204 .89615 Mdot
.51484 .63382 Mdot
.57746 .3576 Mdot
.58622 .21794 Mdot
.58985 .34788 Mdot
.59116 .025 Mdot
.5956 .20363 Mdot
.60008 .5896 Mdot
.60934 .61776 Mdot
.60967 .61584 Mdot
.61391 .62967 Mdot
.61465 .4861 Mdot
.66393 .32476 Mdot
.66877 .4199 Mdot
.68158 .28934 Mdot
.68658 .3056 Mdot
.69009 .90548 Mdot
.70283 .71598 Mdot
.70672 .85708 Mdot
.71879 .31668 Mdot
.73979 .85792 Mdot
.74257 .16468 Mdot
.7565 .16954 Mdot
.75814 .16914 Mdot
.77019 .20667 Mdot
.78861 .50859 Mdot
.81963 .28424 Mdot
.8266 .71733 Mdot
.8284 .37455 Mdot
.82957 .37609 Mdot
.84788 .23109 Mdot
.85139 .60711 Mdot
.85284 .85449 Mdot
.86838 .40948 Mdot
.87881 .92985 Mdot
.89216 .74335 Mdot
.93152 .11659 Mdot
.003 w
[ ] 0 setdash
.13232 .74324 m
0 0 rlineto s
.13232 .74324 m
0 .74495 L
s
.09748 .58225 m
0 0 rlineto s
.09748 .58225 m
0 .57049 L
s
.93152 .11659 m
0 0 rlineto s
.93152 .11659 m
1 .07847 L
s
.20344 .39678 m
0 0 rlineto s
.20344 .39678 m
0 .30994 L
s
.69009 .90548 m
0 0 rlineto s
.69009 .90548 m
.72472 1 L
s
.87881 .92985 m
0 0 rlineto s
.87881 .92985 m
.90742 1 L
s
.09616 .89542 m
0 0 rlineto s
.09616 .89542 m
0 .92457 L
s
.09748 .58225 m
.14342 .74131 L
.13232 .74324 L
s
.24071 .88995 m
.24598 .84535 L
.34694 .77881 L
.38978 .79374 L
.48701 .86768 L
.49204 .89615 L
s
.49204 .89615 m
.44463 1 L
s
.27713 1 m
.24071 .88995 L
s
.61391 .62967 m
.60934 .61776 L
.60967 .61584 L
.78861 .50859 L
.85139 .60711 L
.8266 .71733 L
.70283 .71598 L
.61391 .62967 L
s
.60008 .5896 m
.61465 .4861 L
.66877 .4199 L
.82957 .37609 L
.86838 .40948 L
.78861 .50859 L
.60967 .61584 L
.60008 .5896 L
s
.28606 .41668 m
.41683 .38873 L
.44808 .39674 L
.45278 .4556 L
.3893 .48831 L
.28606 .41668 L
s
1 .40983 m
.86838 .40948 L
.82957 .37609 L
.8284 .37455 L
.81963 .28424 L
.84788 .23109 L
.93152 .11659 L
s
.73979 .85792 m
.85284 .85449 L
.87881 .92985 L
.73979 .85792 L
s
.21169 .67359 m
.23438 .56396 L
.33031 .58128 L
.37838 .6306 L
.34379 .72221 L
.21169 .67359 L
s
.3457 0 m
.36089 .16681 L
.30189 .29486 L
.20344 .39678 L
s
.69009 .90548 m
.70672 .85708 L
.73979 .85792 L
.87881 .92985 L
s
.73979 .85792 m
.70672 .85708 L
.70283 .71598 L
.8266 .71733 L
.89216 .74335 L
.85284 .85449 L
.73979 .85792 L
s
.34694 .77881 m
.34379 .72221 L
.37838 .6306 L
.51484 .63382 L
.38978 .79374 L
.34694 .77881 L
s
.71879 .31668 m
.77019 .20667 L
.81963 .28424 L
.8284 .37455 L
.71879 .31668 L
s
.13232 .74324 m
.09616 .89542 L
s
.8266 .71733 m
.85139 .60711 L
s
.85139 .60711 m
1 .57534 L
s
1 .7328 m
.89216 .74335 L
.8266 .71733 L
s
.23438 .56396 m
.22449 .55225 L
.2041 .39792 L
.28606 .41668 L
.3893 .48831 L
.33031 .58128 L
.23438 .56396 L
s
.48349 .33751 m
.47666 .30569 L
.58622 .21794 L
.58985 .34788 L
.57746 .3576 L
.48349 .33751 L
s
.36089 .16681 m
.47666 .30569 L
.48349 .33751 L
.44808 .39674 L
.41683 .38873 L
.30189 .29486 L
.36089 .16681 L
s
.66393 .32476 m
.68658 .3056 L
.71879 .31668 L
.8284 .37455 L
.82957 .37609 L
.66877 .4199 L
.66393 .32476 L
s
.14342 .74131 m
.09748 .58225 L
.22449 .55225 L
.23438 .56396 L
.21169 .67359 L
.16555 .74293 L
.14342 .74131 L
s
.47666 .30569 m
.36089 .16681 L
s
.36089 .16681 m
.3457 0 L
s
.57987 0 m
.59116 .025 L
.5956 .20363 L
.58622 .21794 L
.47666 .30569 L
s
.16555 .74293 m
.21169 .67359 L
.34379 .72221 L
.34694 .77881 L
.24598 .84535 L
.16555 .74293 L
s
.57746 .3576 m
.58985 .34788 L
.66393 .32476 L
.66877 .4199 L
.61465 .4861 L
.57746 .3576 L
s
.93152 .11659 m
.75814 .16914 L
.7565 .16954 L
.74257 .16468 L
.59116 .025 L
s
.59116 .025 m
.57987 0 L
s
.77019 .20667 m
.7565 .16954 L
.75814 .16914 L
.84788 .23109 L
.81963 .28424 L
.77019 .20667 L
s
.68158 .28934 m
.74257 .16468 L
.7565 .16954 L
.77019 .20667 L
.71879 .31668 L
.68658 .3056 L
.68158 .28934 L
s
.78861 .50859 m
.86838 .40948 L
s
.86838 .40948 m
1 .40983 L
s
1 .57534 m
.85139 .60711 L
.78861 .50859 L
s
.38978 .79374 m
.51484 .63382 L
.60934 .61776 L
.61391 .62967 L
.48701 .86768 L
.38978 .79374 L
s
.2041 .39792 m
.20344 .39678 L
.30189 .29486 L
.41683 .38873 L
.28606 .41668 L
.2041 .39792 L
s
.20344 .39678 m
.2041 .39792 L
.22449 .55225 L
.09748 .58225 L
s
.44463 1 m
.49204 .89615 L
.69009 .90548 L
s
.87881 .92985 m
.85284 .85449 L
.89216 .74335 L
s
.89216 .74335 m
1 .7328 L
s
.09616 .89542 m
.13232 .74324 L
.14342 .74131 L
.16555 .74293 L
.24598 .84535 L
.24071 .88995 L
.09616 .89542 L
s
.5956 .20363 m
.59116 .025 L
.74257 .16468 L
.68158 .28934 L
.5956 .20363 L
s
.37838 .6306 m
.33031 .58128 L
.3893 .48831 L
.45278 .4556 L
.60008 .5896 L
.60967 .61584 L
.60934 .61776 L
.51484 .63382 L
.37838 .6306 L
s
.93152 .11659 m
.84788 .23109 L
.75814 .16914 L
.93152 .11659 L
s
.45278 .4556 m
.44808 .39674 L
.48349 .33751 L
.57746 .3576 L
.61465 .4861 L
.60008 .5896 L
.45278 .4556 L
s
.09616 .89542 m
.24071 .88995 L
s
.24071 .88995 m
.27713 1 L
s
.49204 .89615 m
.48701 .86768 L
.61391 .62967 L
.70283 .71598 L
.70672 .85708 L
.69009 .90548 L
.49204 .89615 L
s
.58622 .21794 m
.5956 .20363 L
.68158 .28934 L
.68658 .3056 L
.66393 .32476 L
.58985 .34788 L
.58622 .21794 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[30]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["DelaunayTriangulationQ[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["trival", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" if the vertex adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["trival", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" represents a Delaunay triangulation of the points, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" otherwise",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["Testing for a Delaunay triangulation. ", "Caption",
 CellTags->"S5.19.1"],

Cell[TextData[{
 StyleBox["delval", "MR"],
 " is a Delaunay triangulation, so this returns ",
 StyleBox["True", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.36"}],

Cell[CellGroupData[{

Cell["DelaunayTriangulationQ[data2D, delval]", "Input",
 CellLabel->"In[31]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[31]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "This returns ",
 StyleBox["False", "MR"],
 " because ",
 StyleBox["trival", "MR"],
 " is not a Delaunay triangulation. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.37"}],

Cell[CellGroupData[{

Cell["DelaunayTriangulationQ[data2D, trival]", "Input",
 CellLabel->"In[32]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DelaunayTriangulationQ", "::", "\<\"inval\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Triangle \\!\\({11, 15, 12}\\) is not a valid Delaunay \
triangle.\"\>"}]], "Message",
 CellTags->"S5.19.1"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[32]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NearestNeighbor[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["u",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["compute the nearest neighbor of the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" from the set of points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NearestNeighbor[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vorvert", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vorval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["compute the nearest neighbors of the points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " given the neighborhood structure depicted by Voronoi diagram vertex \
list ", "TR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vorvert", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and Voronoi diagram vertex adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vorval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["Computing the nearest neighbor. ", "Caption",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "This computes the point in ",
 StyleBox["data2D", "MR"],
 " nearest to ",
 StyleBox["{7.92,", "MR"],
 " ",
 StyleBox["8.92}", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.38"}],

Cell[CellGroupData[{

Cell["\<\
neighbor = NearestNeighbor[{7.92, 8.92},
 data2D]\
\>", "Input",
 CellLabel->"In[33]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[33]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "If the Voronoi diagram is known, the diagram vertex list and vertex \
adjacency list can be substituted for the point list for a faster ",
 StyleBox["NearestNeighbor", "MR"],
 " calculation. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.39"}],

Cell[CellGroupData[{

Cell["\<\
NearestNeighbor[{7.92, 8.92},
 vorvert, vorval]\
\>", "Input",
 CellLabel->"In[34]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[34]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the coordinates of the Voronoi polygon containing ",
 StyleBox["{7.92,", "MR"],
 " ",
 StyleBox["8.92}", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.40"}],

Cell[CellGroupData[{

Cell["vorvert[[vorval[[neighbor, 2]]]]", "Input",
 CellLabel->"In[35]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.760912571793235`", ",", "11.21330567964263`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.3407539118065435`", ",", "9.97908961593172`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.092374810318664`", ",", "6.573160091047041`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.190676567656764`", ",", "7.638201320132013`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.13688524590164`", ",", "10.166393442622953`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.387267080745344`", ",", "11.103416149068325`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[35]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[TextData[{
 "For each of the points in ",
 StyleBox["data2D", "MR"],
 ", the nearest point in ",
 StyleBox["data2D", "MR"],
 " is the point itself. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.41"}],

Cell[CellGroupData[{

Cell["NearestNeighbor[data2D, vorvert, vorval]", "Input",
 CellLabel->"In[36]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16"}], "}"}]], "Output",
 CellLabel->"Out[36]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["\<\
The first half of these points is known to derive from one distribution; the \
second half is known to derive from another. \
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.42"}],

Cell["\<\
known = Join[{{5.84, 1.2}, {5.94, 10.99},
 {5.1, 2.82}, {5.8, 1.67}, {5.63, 10.}},
 {{0.31, 5.11}, {7.73, 5.38},
 {10.42, 5.89}, {6.1, 5.1}, {6.92, 5.63}}];\
\>", "Input",
 CellLabel->"In[37]:= ",
 CellTags->"S5.19.1"],

Cell["\<\
Each of these points is believed to derive from one of the two distributions. \
\
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.43"}],

Cell["\<\
unknown = {{5.56, 7.48}, {5.1, 1.67},
 {5.17, 4.89}, {0.3, 5.27},
 {6.74, 5.73}, {5.09, 9.07}};\
\>", "Input",
 CellLabel->"In[38]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "This classifies the points in ",
 StyleBox["unknown", "MR"],
 " according to the classifications of their nearest neighbors in ",
 StyleBox["known", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.44"}],

Cell[CellGroupData[{

Cell["\<\
If[# > 5, 2, 1]& /@
 NearestNeighbor[unknown, known]\
\>", "Input",
 CellLabel->"In[39]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "2", ",", "2", ",", "2", ",", "1"}], 
  "}"}]], "Output",
 CellLabel->"Out[39]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BoundedDiagram[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["compute the bounded Voronoi diagram of a set of points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      ", where the bound is the convex polygon described by the points ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoundedDiagram[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "compute the bounded Voronoi diagram using the Delaunay triangulation \
vertex adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoundedDiagram[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["convexhull", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "compute the bounded Voronoi diagram using the Delaunay triangulation \
vertex adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["delval", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the convex hull index list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["convexhull", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["Computing the bounded Voronoi diagram. ", "Caption",
 CellTags->"S5.19.1"],

Cell["\<\
When spatial data is collected within a finite region of the plane, the \
unbounded Voronoi diagram of the points may not offer an accurate picture of \
the region of influence of each point. A tile on the periphery of the diagram \
will be open, indicating an infinite region of influence, when in fact an \
open tile is simply due to the limited extent of the spatial sampling. It is \
sometimes useful to intersect the unbounded Voronoi diagram of the data with \
the boundary of the convex region from which the data was collected. Then \
each point in the data can be associated with a closed tile or finite region \
of influence. \
\>", "Text",
 CellTags->{"S5.19.1", "1.45"}],

Cell[TextData[{
 StyleBox["BoundedDiagram", "MR"],
 " begins by finding the unbounded Voronoi diagram. It then works \
counterclockwise around the boundary, integrating bounding polygon vertices \
into the diagram, and deleting Voronoi diagram vertices falling outside of \
the boundary. Bounding an open tile of the Voronoi diagram allows one to \
approximate the true underlying closed tile one would have if the data \
collection had not been limited to a portion of the plane. "
}], "Text",
 CellTags->{"S5.19.1", "1.46"}],

Cell["\<\
The bounded diagram is represented as two lists: (1) a vertex coordinate \
list, and (2) a vertex adjacency list, one entry for each point in the \
original unbounded diagram indicating the associated bounded polygon vertices \
in counterclockwise order. \
\>", "Text",
 CellTags->{"S5.19.1", "1.47"}],

Cell[TextData[{
 "Since ",
 StyleBox["BoundedDiagram", "MR"],
 " requires the unbounded Voronoi diagram, the computation of the bounded \
diagram can be made more efficient by providing additional arguments, such as \
the Delaunay triangulation vertex adjacency list and the convex hull. "
}], "Text",
 CellTags->{"S5.19.1", "1.48"}],

Cell[TextData[{
 "These are the coordinates of the rectangular region from which the ",
 StyleBox["data2D", "MR"],
 " sample was drawn. "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.49"}],

Cell["b1 = {{0, 1}, {14, 1}, {14, 16}, {0, 16}};", "Input",
 CellLabel->"In[40]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "This assigns the list of bounded diagram vertices to ",
 StyleBox["diagvert1", "MR"],
 " and the bounded diagram vertex adjacency list to ",
 StyleBox["diagval1", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.50"}],

Cell["\<\
{diagvert1, diagval1} = BoundedDiagram[b1, data2D, delval, convexhull];\
\>", "Input",
 CellLabel->"In[41]:= ",
 CellTags->"S5.19.1"],

Cell[TextData[{
 "Here is a plot of the bounded diagram of ",
 StyleBox["data2D", "MR"],
 " given by ",
 StyleBox["diagvert1", "MR"],
 " and ",
 StyleBox["diagval1", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.19.1", "1.51"}],

Cell[CellGroupData[{

Cell["DiagramPlot[data2D, diagvert1, diagval1]", "Input",
 CellLabel->"In[42]:= ",
 CellTags->"S5.19.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0566667 0.0633333 -0.0383333 0.0633333 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
[(1)] .33533 .84833 0 0 Mshowa
[(2)] .481 .9275 0 0 Mshowa
[(3)] .49367 .77233 0 0 Mshowa
[(4)] .18967 .66467 0 0 Mshowa
[(5)] .65833 .90533 0 0 Mshowa
[(6)] .89267 .71533 0 0 Mshowa
[(7)] .709 .74067 0 0 Mshowa
[(8)] .48733 .56333 0 0 Mshowa
[(9)] .26567 .44933 0 0 Mshowa
[(10)] .09467 .28467 0 0 Mshowa
[(11)] .39233 .11367 0 0 Mshowa
[(12)] .59183 .25933 0 0 Mshowa
[(13)] .785 .56967 0 0 Mshowa
[(14)] .93067 .424 0 0 Mshowa
[(15)] .87367 .158 0 0 Mshowa
[(16)] .75333 .03133 0 0 Mshowa
.012 w
.28022 .26309 Mdot
.33158 .59368 Mdot
.35387 .68403 Mdot
.35819 .67184 Mdot
.40247 .30923 Mdot
.4313 .84534 Mdot
.44252 .37797 Mdot
.56212 .85602 Mdot
.57343 .0751 Mdot
.58786 .66488 Mdot
.60767 .79962 Mdot
.63534 .60554 Mdot
.63874 .44542 Mdot
.72276 .18087 Mdot
.74209 .38109 Mdot
.77235 .31882 Mdot
.79365 .6759 Mdot
.81971 .86486 Mdot
.93352 .57252 Mdot
.94333 .025 Mdot
.94333 .975 Mdot
.05667 .975 Mdot
.05667 .025 Mdot
.94333 .28218 Mdot
.94333 .5738 Mdot
.90901 .975 Mdot
.57699 .975 Mdot
.36084 .975 Mdot
.05667 .91975 Mdot
.05667 .49665 Mdot
.05667 .49525 Mdot
.14345 .025 Mdot
.562 .025 Mdot
.88683 .025 Mdot
.003 w
[ ] 0 setdash
.05667 .975 m
.05667 .91975 L
.35387 .68403 L
.4313 .84534 L
.36084 .975 L
.05667 .975 L
s
.57699 .975 m
.36084 .975 L
.4313 .84534 L
.56212 .85602 L
.57699 .975 L
s
.4313 .84534 m
.35387 .68403 L
.35819 .67184 L
.58786 .66488 L
.60767 .79962 L
.56212 .85602 L
.4313 .84534 L
s
.05667 .91975 m
.05667 .49665 L
.33158 .59368 L
.35819 .67184 L
.35387 .68403 L
.05667 .91975 L
s
.90901 .975 m
.57699 .975 L
.56212 .85602 L
.60767 .79962 L
.81971 .86486 L
.90901 .975 L
s
.94333 .975 m
.90901 .975 L
.81971 .86486 L
.79365 .6759 L
.93352 .57252 L
.94333 .5738 L
.94333 .975 L
s
.60767 .79962 m
.58786 .66488 L
.63534 .60554 L
.79365 .6759 L
.81971 .86486 L
.60767 .79962 L
s
.35819 .67184 m
.33158 .59368 L
.44252 .37797 L
.63874 .44542 L
.63534 .60554 L
.58786 .66488 L
.35819 .67184 L
s
.05667 .49665 m
.05667 .49525 L
.28022 .26309 L
.40247 .30923 L
.44252 .37797 L
.33158 .59368 L
.05667 .49665 L
s
.05667 .025 m
.14345 .025 L
.28022 .26309 L
.05667 .49525 L
.05667 .025 L
s
.14345 .025 m
.562 .025 L
.57343 .0751 L
.40247 .30923 L
.28022 .26309 L
.14345 .025 L
s
.44252 .37797 m
.40247 .30923 L
.57343 .0751 L
.72276 .18087 L
.77235 .31882 L
.74209 .38109 L
.63874 .44542 L
.44252 .37797 L
s
.63534 .60554 m
.63874 .44542 L
.74209 .38109 L
.93352 .57252 L
.79365 .6759 L
.63534 .60554 L
s
.94333 .28218 m
.94333 .5738 L
.93352 .57252 L
.74209 .38109 L
.77235 .31882 L
.94333 .28218 L
s
.94333 .28218 m
.77235 .31882 L
.72276 .18087 L
.88683 .025 L
.94333 .025 L
.94333 .28218 L
s
.562 .025 m
.88683 .025 L
.72276 .18087 L
.57343 .0751 L
.562 .025 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.19.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[42]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["TileAreas[ {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }, {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["q",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["q",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["val", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find the areas of the tiles centered on ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and having vertices ", "TR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["q",
          "TI"], 
         StyleBox["j",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", as stipulated by the vertex adjacency list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["val", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.19.1"],

Cell["Computing tile areas. ", "Caption",
 CellTags->"S5.19.1"],

Cell["\<\
You can make use of Voronoi diagrams to build spatial interaction models, or \
simply calculate the area of influence of individual tiles. \
\>", "Text",
 CellTags->{"S5.19.1", "1.52"}],

Cell["\<\
In an unbounded Voronoi diagram, some of the tiles have infinite area. \
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.53"}],

Cell[CellGroupData[{

Cell["TileAreas[data2D, diagvert, diagval]", "Input",
 CellLabel->"In[43]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[Infinity]", ",", "\[Infinity]", ",", "9.290492419697504`", ",", 
   "\[Infinity]", ",", "\[Infinity]", ",", "\[Infinity]", ",", 
   "9.799010941636514`", ",", "16.85506451213251`", ",", 
   "12.671324257902857`", ",", "\[Infinity]", ",", "\[Infinity]", ",", 
   "20.814509736398783`", ",", "13.205476316006532`", ",", "\[Infinity]", ",",
    "\[Infinity]", ",", "\[Infinity]"}], "}"}]], "Output",
 CellLabel->"Out[43]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["In a bounded diagram, each of the tiles has finite area. ", \
"MathCaption",
 CellTags->{"S5.19.1", "1.54"}],

Cell[CellGroupData[{

Cell["areas = TileAreas[data2D, diagvert1, diagval1]", "Input",
 CellLabel->"In[44]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "15.747851520862898`", ",", "5.413783434699274`", ",", "9.290492419697504`",
    ",", "18.58427158322057`", ",", "10.223816457637623`", ",", 
   "10.66011488889608`", ",", "9.799010941636514`", ",", "16.85506451213251`",
    ",", "17.516179844598177`", ",", "15.68016729691266`", ",", 
   "19.07201482377665`", ",", "20.814509736398783`", ",", 
   "13.205476316006532`", ",", "8.708163679664093`", ",", 
   "11.335647862556169`", ",", "7.093434681303943`"}], "}"}]], "Output",
 CellLabel->"Out[44]= ",
 CellTags->"S5.19.1"]
}, Open  ]],

Cell["\<\
This gives the tile areas scaled by the area of the rectangle from which the \
sample was drawn. \
\>", "MathCaption",
 CellTags->{"S5.19.1", "1.55"}],

Cell[CellGroupData[{

Cell["areas/(14 15)", "Input",
 CellLabel->"In[45]:= ",
 CellTags->"S5.19.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.07498976914696619`", ",", "0.025779921117615595`", ",", 
   "0.04424044009379764`", ",", "0.08849653134866939`", ",", 
   "0.048684840274464874`", ",", "0.0507624518518861`", ",", 
   "0.04666195686493578`", ",", "0.08026221196253577`", ",", 
   "0.08341038021237228`", ",", "0.07466746331863172`", ",", 
   "0.09081911820846025`", ",", "0.0991167130304704`", ",", 
   "0.06288322055241206`", ",", "0.04146744609363854`", ",", 
   "0.05397927553598176`", ",", "0.03377826038716164`"}], "}"}]], "Output",
 CellLabel->"Out[45]= ",
 CellTags->"S5.19.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.19.1"->{
    Cell[1776, 53, 150, 6, 36, "Subsection",
      CellTags->{"S5.19.1", "1.1"}],
    Cell[1929, 61, 597, 10, 104, "Text",
      CellTags->{"S5.19.1", "1.2"}],
    Cell[2529, 73, 6158, 183, 142, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[8690, 258, 75, 1, 15, "Caption",
      CellTags->"S5.19.1"],
    Cell[8768, 261, 1671, 52, 88, "Text",
      CellTags->{"S5.19.1", "1.3"}],
    Cell[10442, 315, 78, 1, 40, "MathCaption",
      CellTags->{"S5.19.1", "1.4"}],
    Cell[10523, 318, 100, 2, 28, "Input",
      CellTags->"S5.19.1"],
    Cell[10626, 322, 93, 1, 40, "MathCaption",
      CellTags->{"S5.19.1", "1.5"}],
    Cell[10722, 325, 289, 9, 113, "Input",
      CellTags->"S5.19.1"],
    Cell[11014, 336, 153, 4, 40, "MathCaption",
      CellTags->{"S5.19.1", "1.6"}],
    Cell[11192, 344, 94, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[11289, 348, 211, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[11515, 357, 84, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.7"}],
    Cell[11624, 362, 119, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[11746, 369, 192, 6, 70, "Message",
      CellTags->"S5.19.1"],
    Cell[11941, 377, 139, 4, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[12095, 384, 462, 15, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.8"}],
    Cell[12582, 403, 135, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[12720, 410, 988, 31, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[13723, 444, 679, 13, 70, "Text",
      CellTags->{"S5.19.1", "1.9"}],
    Cell[14405, 459, 483, 11, 70, "Text",
      CellTags->{"S5.19.1", "1.10"}],
    Cell[14891, 472, 240, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.11"}],
    Cell[15134, 481, 106, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[15243, 485, 556, 21, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.12"}],
    Cell[15824, 510, 94, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[15921, 514, 475, 16, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[16411, 533, 323, 8, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.13"}],
    Cell[16759, 545, 78, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[16840, 549, 475, 16, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[17330, 568, 177, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.14"}],
    Cell[17532, 577, 76, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[17611, 581, 141, 4, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[17767, 588, 432, 11, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.15"}],
    Cell[18224, 603, 76, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[18303, 607, 788, 23, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[19106, 633, 5258, 160, 70, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[24367, 795, 135, 4, 70, "Caption",
      CellTags->"S5.19.1"],
    Cell[24505, 801, 226, 6, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.16"}],
    Cell[24734, 809, 95, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[24832, 813, 161, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.17"}],
    Cell[24996, 819, 116, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[25115, 826, 17925, 541, 70, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[43043, 1369, 84, 1, 70, "Caption",
      CellTags->"S5.19.1"],
    Cell[43130, 1372, 182, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.18"}],
    Cell[43337, 1381, 130, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[43470, 1388, 16456, 691, 70, 16385, 688, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[59929, 2081, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[60125, 2090, 97, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.19"}],
    Cell[60247, 2095, 99, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[60349, 2099, 1345, 70, 70, 1274, 67, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[61697, 2171, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[61893, 2180, 93, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.20"}],
    Cell[61989, 2183, 173, 6, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[62165, 2191, 178, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.21"}],
    Cell[62368, 2202, 138, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[62509, 2209, 16459, 691, 70, 16388, 688, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[78971, 2902, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[79167, 2911, 171, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.22"}],
    Cell[79363, 2920, 83, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[79449, 2924, 2951, 191, 70, 2880, 188, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[82403, 3117, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[82599, 3126, 103, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.23"}],
    Cell[82705, 3129, 125, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[82833, 3136, 109, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.24"}],
    Cell[82945, 3139, 173, 7, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[83121, 3148, 212, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.25"}],
    Cell[83358, 3161, 102, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[83463, 3165, 2950, 191, 70, 2879, 188, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[86416, 3358, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[86612, 3367, 379, 14, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.26"}],
    Cell[86994, 3383, 144, 6, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[87141, 3391, 592, 21, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.27"}],
    Cell[87758, 3416, 93, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[87854, 3420, 3134, 196, 70, 3063, 193, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[90991, 3618, 183, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[91189, 3627, 338, 12, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.28"}],
    Cell[91552, 3643, 101, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[91656, 3647, 3135, 196, 70, 3064, 193, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[94794, 3845, 183, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[94992, 3854, 10834, 321, 70, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[105829, 4177, 87, 1, 70, "Caption",
      CellTags->"S5.19.1"],
    Cell[105919, 4180, 134, 3, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.29"}],
    Cell[106078, 4187, 140, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[106221, 4194, 192, 6, 70, "Message",
      CellTags->"S5.19.1"],
    Cell[106416, 4202, 130, 4, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[106561, 4209, 129, 3, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.30"}],
    Cell[106715, 4216, 127, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[106845, 4223, 1288, 31, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[108148, 4257, 289, 8, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.31"}],
    Cell[108440, 4267, 107, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[108550, 4271, 141, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.32"}],
    Cell[108694, 4278, 118, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[108815, 4285, 106, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.33"}],
    Cell[108946, 4290, 133, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[109082, 4297, 6813, 455, 70, 6742, 452, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[115898, 4754, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[116094, 4763, 267, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.34"}],
    Cell[116386, 4776, 150, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[116539, 4783, 6895, 465, 70, 6824, 462, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[123437, 5250, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[123633, 5259, 221, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.35"}],
    Cell[123879, 5270, 150, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[124032, 5277, 6904, 476, 70, 6833, 473, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[130939, 5755, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[131135, 5764, 2986, 90, 70, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[134124, 5856, 79, 1, 70, "Caption",
      CellTags->"S5.19.1"],
    Cell[134206, 5859, 175, 6, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.36"}],
    Cell[134406, 5869, 102, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[134511, 5873, 78, 2, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[134604, 5878, 189, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.37"}],
    Cell[134818, 5889, 102, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[134923, 5893, 224, 6, 70, "Message",
      CellTags->"S5.19.1"],
    Cell[135150, 5901, 79, 2, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[135244, 5906, 9234, 280, 70, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[144481, 6188, 73, 1, 70, "Caption",
      CellTags->"S5.19.1"],
    Cell[144557, 6191, 207, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.38"}],
    Cell[144789, 6204, 121, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[144913, 6211, 75, 2, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[145003, 6216, 261, 6, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.39"}],
    Cell[145289, 6226, 119, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[145411, 6233, 75, 2, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[145501, 6238, 197, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.40"}],
    Cell[145723, 6249, 96, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[145822, 6253, 662, 17, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[146499, 6273, 205, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.41"}],
    Cell[146729, 6284, 104, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[146836, 6288, 278, 7, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[147129, 6298, 187, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.42"}],
    Cell[147319, 6304, 228, 7, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[147550, 6313, 143, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.43"}],
    Cell[147696, 6319, 167, 6, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[147866, 6327, 230, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.44"}],
    Cell[148121, 6338, 124, 5, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[148248, 6345, 163, 5, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[148426, 6353, 12782, 386, 70, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[161211, 6741, 80, 1, 70, "Caption",
      CellTags->"S5.19.1"],
    Cell[161294, 6744, 692, 11, 70, "Text",
      CellTags->{"S5.19.1", "1.45"}],
    Cell[161989, 6757, 526, 9, 70, "Text",
      CellTags->{"S5.19.1", "1.46"}],
    Cell[162518, 6768, 311, 6, 70, "Text",
      CellTags->{"S5.19.1", "1.47"}],
    Cell[162832, 6776, 333, 7, 70, "Text",
      CellTags->{"S5.19.1", "1.48"}],
    Cell[163168, 6785, 188, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.49"}],
    Cell[163359, 6792, 106, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[163468, 6796, 244, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.50"}],
    Cell[163715, 6805, 143, 4, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[163861, 6811, 229, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.51"}],
    Cell[164115, 6824, 104, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[164222, 6828, 3348, 208, 70, 3277, 205, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.19.1"],
    Cell[167573, 7038, 181, 6, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[167769, 7047, 4712, 145, 70, "DefinitionBox",
      CellTags->"S5.19.1"],
    Cell[172484, 7194, 63, 1, 70, "Caption",
      CellTags->"S5.19.1"],
    Cell[172550, 7197, 195, 4, 70, "Text",
      CellTags->{"S5.19.1", "1.52"}],
    Cell[172748, 7203, 134, 3, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.53"}],
    Cell[172907, 7210, 100, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[173010, 7214, 488, 10, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[173513, 7227, 114, 2, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.54"}],
    Cell[173652, 7233, 110, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[173765, 7237, 565, 11, 70, "Output",
      CellTags->"S5.19.1"],
    Cell[174345, 7251, 160, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.55"}],
    Cell[174530, 7259, 77, 2, 70, "Input",
      CellTags->"S5.19.1"],
    Cell[174610, 7263, 595, 12, 70, "Output",
      CellTags->"S5.19.1"]},
  "1.1"->{
    Cell[1776, 53, 150, 6, 36, "Subsection",
      CellTags->{"S5.19.1", "1.1"}]},
  "1.2"->{
    Cell[1929, 61, 597, 10, 104, "Text",
      CellTags->{"S5.19.1", "1.2"}]},
  "1.3"->{
    Cell[8768, 261, 1671, 52, 88, "Text",
      CellTags->{"S5.19.1", "1.3"}]},
  "1.4"->{
    Cell[10442, 315, 78, 1, 40, "MathCaption",
      CellTags->{"S5.19.1", "1.4"}]},
  "1.5"->{
    Cell[10626, 322, 93, 1, 40, "MathCaption",
      CellTags->{"S5.19.1", "1.5"}]},
  "1.6"->{
    Cell[11014, 336, 153, 4, 40, "MathCaption",
      CellTags->{"S5.19.1", "1.6"}]},
  "1.7"->{
    Cell[11515, 357, 84, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.7"}]},
  "1.8"->{
    Cell[12095, 384, 462, 15, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.8"}]},
  "1.9"->{
    Cell[13723, 444, 679, 13, 70, "Text",
      CellTags->{"S5.19.1", "1.9"}]},
  "1.10"->{
    Cell[14405, 459, 483, 11, 70, "Text",
      CellTags->{"S5.19.1", "1.10"}]},
  "1.11"->{
    Cell[14891, 472, 240, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.11"}]},
  "1.12"->{
    Cell[15243, 485, 556, 21, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.12"}]},
  "1.13"->{
    Cell[16411, 533, 323, 8, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.13"}]},
  "1.14"->{
    Cell[17330, 568, 177, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.14"}]},
  "1.15"->{
    Cell[17767, 588, 432, 11, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.15"}]},
  "1.16"->{
    Cell[24505, 801, 226, 6, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.16"}]},
  "1.17"->{
    Cell[24832, 813, 161, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.17"}]},
  "1.18"->{
    Cell[43130, 1372, 182, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.18"}]},
  "1.19"->{
    Cell[60125, 2090, 97, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.19"}]},
  "1.20"->{
    Cell[61893, 2180, 93, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.20"}]},
  "1.21"->{
    Cell[62165, 2191, 178, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.21"}]},
  "1.22"->{
    Cell[79167, 2911, 171, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.22"}]},
  "1.23"->{
    Cell[82599, 3126, 103, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.23"}]},
  "1.24"->{
    Cell[82833, 3136, 109, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.24"}]},
  "1.25"->{
    Cell[83121, 3148, 212, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.25"}]},
  "1.26"->{
    Cell[86612, 3367, 379, 14, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.26"}]},
  "1.27"->{
    Cell[87141, 3391, 592, 21, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.27"}]},
  "1.28"->{
    Cell[91189, 3627, 338, 12, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.28"}]},
  "1.29"->{
    Cell[105919, 4180, 134, 3, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.29"}]},
  "1.30"->{
    Cell[106561, 4209, 129, 3, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.30"}]},
  "1.31"->{
    Cell[108148, 4257, 289, 8, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.31"}]},
  "1.32"->{
    Cell[108550, 4271, 141, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.32"}]},
  "1.33"->{
    Cell[108815, 4285, 106, 1, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.33"}]},
  "1.34"->{
    Cell[116094, 4763, 267, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.34"}]},
  "1.35"->{
    Cell[123633, 5259, 221, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.35"}]},
  "1.36"->{
    Cell[134206, 5859, 175, 6, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.36"}]},
  "1.37"->{
    Cell[134604, 5878, 189, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.37"}]},
  "1.38"->{
    Cell[144557, 6191, 207, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.38"}]},
  "1.39"->{
    Cell[145003, 6216, 261, 6, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.39"}]},
  "1.40"->{
    Cell[145501, 6238, 197, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.40"}]},
  "1.41"->{
    Cell[146499, 6273, 205, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.41"}]},
  "1.42"->{
    Cell[147129, 6298, 187, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.42"}]},
  "1.43"->{
    Cell[147550, 6313, 143, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.43"}]},
  "1.44"->{
    Cell[147866, 6327, 230, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.44"}]},
  "1.45"->{
    Cell[161294, 6744, 692, 11, 70, "Text",
      CellTags->{"S5.19.1", "1.45"}]},
  "1.46"->{
    Cell[161989, 6757, 526, 9, 70, "Text",
      CellTags->{"S5.19.1", "1.46"}]},
  "1.47"->{
    Cell[162518, 6768, 311, 6, 70, "Text",
      CellTags->{"S5.19.1", "1.47"}]},
  "1.48"->{
    Cell[162832, 6776, 333, 7, 70, "Text",
      CellTags->{"S5.19.1", "1.48"}]},
  "1.49"->{
    Cell[163168, 6785, 188, 5, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.49"}]},
  "1.50"->{
    Cell[163468, 6796, 244, 7, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.50"}]},
  "1.51"->{
    Cell[163861, 6811, 229, 9, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.51"}]},
  "1.52"->{
    Cell[172550, 7197, 195, 4, 70, "Text",
      CellTags->{"S5.19.1", "1.52"}]},
  "1.53"->{
    Cell[172748, 7203, 134, 3, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.53"}]},
  "1.54"->{
    Cell[173513, 7227, 114, 2, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.54"}]},
  "1.55"->{
    Cell[174345, 7251, 160, 4, 70, "MathCaption",
      CellTags->{"S5.19.1", "1.55"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.19.1", 175856, 7295},
  {"1.1", 189109, 7638},
  {"1.2", 189203, 7641},
  {"1.3", 189293, 7644},
  {"1.4", 189384, 7647},
  {"1.5", 189480, 7650},
  {"1.6", 189576, 7653},
  {"1.7", 189673, 7656},
  {"1.8", 189769, 7659},
  {"1.9", 189867, 7662},
  {"1.10", 189959, 7665},
  {"1.11", 190052, 7668},
  {"1.12", 190151, 7671},
  {"1.13", 190251, 7674},
  {"1.14", 190350, 7677},
  {"1.15", 190449, 7680},
  {"1.16", 190549, 7683},
  {"1.17", 190648, 7686},
  {"1.18", 190747, 7689},
  {"1.19", 190847, 7692},
  {"1.20", 190946, 7695},
  {"1.21", 191045, 7698},
  {"1.22", 191145, 7701},
  {"1.23", 191245, 7704},
  {"1.24", 191345, 7707},
  {"1.25", 191445, 7710},
  {"1.26", 191545, 7713},
  {"1.27", 191646, 7716},
  {"1.28", 191747, 7719},
  {"1.29", 191848, 7722},
  {"1.30", 191949, 7725},
  {"1.31", 192050, 7728},
  {"1.32", 192151, 7731},
  {"1.33", 192252, 7734},
  {"1.34", 192353, 7737},
  {"1.35", 192454, 7740},
  {"1.36", 192555, 7743},
  {"1.37", 192656, 7746},
  {"1.38", 192757, 7749},
  {"1.39", 192858, 7752},
  {"1.40", 192959, 7755},
  {"1.41", 193060, 7758},
  {"1.42", 193161, 7761},
  {"1.43", 193262, 7764},
  {"1.44", 193363, 7767},
  {"1.45", 193464, 7770},
  {"1.46", 193559, 7773},
  {"1.47", 193653, 7776},
  {"1.48", 193747, 7779},
  {"1.49", 193841, 7782},
  {"1.50", 193942, 7785},
  {"1.51", 194043, 7788},
  {"1.52", 194144, 7791},
  {"1.53", 194238, 7794},
  {"1.54", 194339, 7797},
  {"1.55", 194440, 7800}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 150, 6, 36, "Subsection",
  CellTags->{"S5.19.1", "1.1"}],
Cell[1929, 61, 597, 10, 104, "Text",
  CellTags->{"S5.19.1", "1.2"}],
Cell[2529, 73, 6158, 183, 142, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[8690, 258, 75, 1, 15, "Caption",
  CellTags->"S5.19.1"],
Cell[8768, 261, 1671, 52, 88, "Text",
  CellTags->{"S5.19.1", "1.3"}],
Cell[10442, 315, 78, 1, 40, "MathCaption",
  CellTags->{"S5.19.1", "1.4"}],
Cell[10523, 318, 100, 2, 28, "Input",
  CellTags->"S5.19.1"],
Cell[10626, 322, 93, 1, 40, "MathCaption",
  CellTags->{"S5.19.1", "1.5"}],
Cell[10722, 325, 289, 9, 113, "Input",
  CellTags->"S5.19.1"],
Cell[11014, 336, 153, 4, 40, "MathCaption",
  CellTags->{"S5.19.1", "1.6"}],

Cell[CellGroupData[{
Cell[11192, 344, 94, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[11289, 348, 211, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[11515, 357, 84, 1, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.7"}],

Cell[CellGroupData[{
Cell[11624, 362, 119, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[11746, 369, 192, 6, 70, "Message",
  CellTags->"S5.19.1"],
Cell[11941, 377, 139, 4, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[12095, 384, 462, 15, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.8"}],

Cell[CellGroupData[{
Cell[12582, 403, 135, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[12720, 410, 988, 31, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[13723, 444, 679, 13, 70, "Text",
  CellTags->{"S5.19.1", "1.9"}],
Cell[14405, 459, 483, 11, 70, "Text",
  CellTags->{"S5.19.1", "1.10"}],
Cell[14891, 472, 240, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.11"}],
Cell[15134, 481, 106, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[15243, 485, 556, 21, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.12"}],

Cell[CellGroupData[{
Cell[15824, 510, 94, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[15921, 514, 475, 16, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[16411, 533, 323, 8, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.13"}],

Cell[CellGroupData[{
Cell[16759, 545, 78, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[16840, 549, 475, 16, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[17330, 568, 177, 5, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.14"}],

Cell[CellGroupData[{
Cell[17532, 577, 76, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[17611, 581, 141, 4, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[17767, 588, 432, 11, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.15"}],

Cell[CellGroupData[{
Cell[18224, 603, 76, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[18303, 607, 788, 23, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[19106, 633, 5258, 160, 70, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[24367, 795, 135, 4, 70, "Caption",
  CellTags->"S5.19.1"],
Cell[24505, 801, 226, 6, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.16"}],
Cell[24734, 809, 95, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[24832, 813, 161, 4, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.17"}],
Cell[24996, 819, 116, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[25115, 826, 17925, 541, 70, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[43043, 1369, 84, 1, 70, "Caption",
  CellTags->"S5.19.1"],
Cell[43130, 1372, 182, 5, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.18"}],

Cell[CellGroupData[{
Cell[43337, 1381, 130, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[43470, 1388, 16456, 691, 70, 16385, 688, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[59929, 2081, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[60125, 2090, 97, 1, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.19"}],

Cell[CellGroupData[{
Cell[60247, 2095, 99, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[60349, 2099, 1345, 70, 70, 1274, 67, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[61697, 2171, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[61893, 2180, 93, 1, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.20"}],
Cell[61989, 2183, 173, 6, 70, "Input",
  CellTags->"S5.19.1"],
Cell[62165, 2191, 178, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.21"}],

Cell[CellGroupData[{
Cell[62368, 2202, 138, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[62509, 2209, 16459, 691, 70, 16388, 688, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[78971, 2902, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[79167, 2911, 171, 5, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.22"}],

Cell[CellGroupData[{
Cell[79363, 2920, 83, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[79449, 2924, 2951, 191, 70, 2880, 188, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[82403, 3117, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[82599, 3126, 103, 1, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.23"}],
Cell[82705, 3129, 125, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[82833, 3136, 109, 1, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.24"}],
Cell[82945, 3139, 173, 7, 70, "Input",
  CellTags->"S5.19.1"],
Cell[83121, 3148, 212, 9, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.25"}],

Cell[CellGroupData[{
Cell[83358, 3161, 102, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[83463, 3165, 2950, 191, 70, 2879, 188, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[86416, 3358, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[86612, 3367, 379, 14, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.26"}],
Cell[86994, 3383, 144, 6, 70, "Input",
  CellTags->"S5.19.1"],
Cell[87141, 3391, 592, 21, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.27"}],

Cell[CellGroupData[{
Cell[87758, 3416, 93, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[87854, 3420, 3134, 196, 70, 3063, 193, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[90991, 3618, 183, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[91189, 3627, 338, 12, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.28"}],

Cell[CellGroupData[{
Cell[91552, 3643, 101, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[91656, 3647, 3135, 196, 70, 3064, 193, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[94794, 3845, 183, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[94992, 3854, 10834, 321, 70, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[105829, 4177, 87, 1, 70, "Caption",
  CellTags->"S5.19.1"],
Cell[105919, 4180, 134, 3, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.29"}],

Cell[CellGroupData[{
Cell[106078, 4187, 140, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[106221, 4194, 192, 6, 70, "Message",
  CellTags->"S5.19.1"],
Cell[106416, 4202, 130, 4, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[106561, 4209, 129, 3, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.30"}],

Cell[CellGroupData[{
Cell[106715, 4216, 127, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[106845, 4223, 1288, 31, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[108148, 4257, 289, 8, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.31"}],
Cell[108440, 4267, 107, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[108550, 4271, 141, 5, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.32"}],
Cell[108694, 4278, 118, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[108815, 4285, 106, 1, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.33"}],

Cell[CellGroupData[{
Cell[108946, 4290, 133, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[109082, 4297, 6813, 455, 70, 6742, 452, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[115898, 4754, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[116094, 4763, 267, 9, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.34"}],

Cell[CellGroupData[{
Cell[116386, 4776, 150, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[116539, 4783, 6895, 465, 70, 6824, 462, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[123437, 5250, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[123633, 5259, 221, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.35"}],

Cell[CellGroupData[{
Cell[123879, 5270, 150, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[124032, 5277, 6904, 476, 70, 6833, 473, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[130939, 5755, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[131135, 5764, 2986, 90, 70, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[134124, 5856, 79, 1, 70, "Caption",
  CellTags->"S5.19.1"],
Cell[134206, 5859, 175, 6, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.36"}],

Cell[CellGroupData[{
Cell[134406, 5869, 102, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[134511, 5873, 78, 2, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[134604, 5878, 189, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.37"}],

Cell[CellGroupData[{
Cell[134818, 5889, 102, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[134923, 5893, 224, 6, 70, "Message",
  CellTags->"S5.19.1"],
Cell[135150, 5901, 79, 2, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[135244, 5906, 9234, 280, 70, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[144481, 6188, 73, 1, 70, "Caption",
  CellTags->"S5.19.1"],
Cell[144557, 6191, 207, 9, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.38"}],

Cell[CellGroupData[{
Cell[144789, 6204, 121, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[144913, 6211, 75, 2, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[145003, 6216, 261, 6, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.39"}],

Cell[CellGroupData[{
Cell[145289, 6226, 119, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[145411, 6233, 75, 2, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[145501, 6238, 197, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.40"}],

Cell[CellGroupData[{
Cell[145723, 6249, 96, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[145822, 6253, 662, 17, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[146499, 6273, 205, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.41"}],

Cell[CellGroupData[{
Cell[146729, 6284, 104, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[146836, 6288, 278, 7, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[147129, 6298, 187, 4, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.42"}],
Cell[147319, 6304, 228, 7, 70, "Input",
  CellTags->"S5.19.1"],
Cell[147550, 6313, 143, 4, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.43"}],
Cell[147696, 6319, 167, 6, 70, "Input",
  CellTags->"S5.19.1"],
Cell[147866, 6327, 230, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.44"}],

Cell[CellGroupData[{
Cell[148121, 6338, 124, 5, 70, "Input",
  CellTags->"S5.19.1"],
Cell[148248, 6345, 163, 5, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[148426, 6353, 12782, 386, 70, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[161211, 6741, 80, 1, 70, "Caption",
  CellTags->"S5.19.1"],
Cell[161294, 6744, 692, 11, 70, "Text",
  CellTags->{"S5.19.1", "1.45"}],
Cell[161989, 6757, 526, 9, 70, "Text",
  CellTags->{"S5.19.1", "1.46"}],
Cell[162518, 6768, 311, 6, 70, "Text",
  CellTags->{"S5.19.1", "1.47"}],
Cell[162832, 6776, 333, 7, 70, "Text",
  CellTags->{"S5.19.1", "1.48"}],
Cell[163168, 6785, 188, 5, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.49"}],
Cell[163359, 6792, 106, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[163468, 6796, 244, 7, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.50"}],
Cell[163715, 6805, 143, 4, 70, "Input",
  CellTags->"S5.19.1"],
Cell[163861, 6811, 229, 9, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.51"}],

Cell[CellGroupData[{
Cell[164115, 6824, 104, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[164222, 6828, 3348, 208, 70, 3277, 205, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.19.1"],
Cell[167573, 7038, 181, 6, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[167769, 7047, 4712, 145, 70, "DefinitionBox",
  CellTags->"S5.19.1"],
Cell[172484, 7194, 63, 1, 70, "Caption",
  CellTags->"S5.19.1"],
Cell[172550, 7197, 195, 4, 70, "Text",
  CellTags->{"S5.19.1", "1.52"}],
Cell[172748, 7203, 134, 3, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.53"}],

Cell[CellGroupData[{
Cell[172907, 7210, 100, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[173010, 7214, 488, 10, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[173513, 7227, 114, 2, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.54"}],

Cell[CellGroupData[{
Cell[173652, 7233, 110, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[173765, 7237, 565, 11, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]],
Cell[174345, 7251, 160, 4, 70, "MathCaption",
  CellTags->{"S5.19.1", "1.55"}],

Cell[CellGroupData[{
Cell[174530, 7259, 77, 2, 70, "Input",
  CellTags->"S5.19.1"],
Cell[174610, 7263, 595, 12, 70, "Output",
  CellTags->"S5.19.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

